/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/CafCoreTypesXml/RequestXml.h"
#include "Doc/DocXml/CafInstallRequestXml/InstallPackageSpecXml.h"
#include "Doc/DocXml/CafInstallRequestXml/InstallProviderSpecXml.h"
#include "Doc/DocXml/CafInstallRequestXml/InstallRequestXml.h"

#include "Doc/CafInstallRequestDoc/CInstallPackageSpecDoc.h"
#include "Doc/CafInstallRequestDoc/CInstallProviderSpecDoc.h"
#include "Doc/CafInstallRequestDoc/CInstallRequestDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/CafInstallRequestXml/CafInstallRequestXmlRoots.h"

using namespace Caf;

std::string XmlRoots::saveInstallRequestToString(
	const SmartPtrCInstallRequestDoc installRequestDoc) {
	CAF_CM_STATIC_FUNC_VALIDATE("XmlRoots", "saveInstallRequestToString");

	std::string rc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(installRequestDoc);

		const std::string schemaNamespace = DocXmlUtils::getSchemaNamespace("fx");
		const std::string schemaLocation = DocXmlUtils::getSchemaLocation("fx/CafInstallRequest.xsd");

		const SmartPtrCXmlElement rootXml = CXmlUtils::createRootElement(
			"installRequest", schemaNamespace, schemaLocation);
		InstallRequestXml::add(installRequestDoc, rootXml);

		rc = rootXml->saveToString();
	}
	CAF_CM_EXIT;

	return rc;
}

SmartPtrCInstallRequestDoc XmlRoots::parseInstallRequestFromString(
	const std::string xml) {
	CAF_CM_STATIC_FUNC_VALIDATE("XmlRoots", "parseInstallRequestFromString");

	SmartPtrCInstallRequestDoc installRequestDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_STRING(xml);

		const SmartPtrCXmlElement rootXml = RequestXml::parseString(xml, "caf:installRequest");
		installRequestDoc = InstallRequestXml::parse(rootXml);
	}
	CAF_CM_EXIT;

	return installRequestDoc;
}

void XmlRoots::saveInstallRequestToFile(
	const SmartPtrCInstallRequestDoc installRequestDoc,
	const std::string filePath) {
	CAF_CM_STATIC_FUNC_LOG_VALIDATE("XmlRoots", "saveInstallRequestToFile");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(installRequestDoc);
		CAF_CM_VALIDATE_STRING(filePath);

		CAF_CM_LOG_DEBUG_VA1("Saving to file - %s", filePath.c_str());

		const std::string installRequestStr =
			saveInstallRequestToString(installRequestDoc);
		FileSystemUtils::saveTextFile(filePath, installRequestStr);
	}
	CAF_CM_EXIT;
}

SmartPtrCInstallRequestDoc XmlRoots::parseInstallRequestFromFile(
	const std::string filePath) {
	CAF_CM_STATIC_FUNC_VALIDATE("XmlRoots", "parseInstallRequestFromFile");

	SmartPtrCInstallRequestDoc installRequestDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_STRING(filePath);

		const SmartPtrCXmlElement rootXml = RequestXml::parseFile(filePath, "caf:installRequest");
		installRequestDoc = InstallRequestXml::parse(rootXml);
	}
	CAF_CM_EXIT;

	return installRequestDoc;
}

std::string XmlRoots::saveInstallProviderSpecToString(
	const SmartPtrCInstallProviderSpecDoc installProviderSpecDoc) {
	CAF_CM_STATIC_FUNC_VALIDATE("XmlRoots", "saveInstallProviderSpecToString");

	std::string rc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(installProviderSpecDoc);

		const std::string schemaNamespace = DocXmlUtils::getSchemaNamespace("fx");
		const std::string schemaLocation = DocXmlUtils::getSchemaLocation("fx/CafInstallRequest.xsd");

		const SmartPtrCXmlElement rootXml = CXmlUtils::createRootElement(
			"installProviderSpec", schemaNamespace, schemaLocation);
		InstallProviderSpecXml::add(installProviderSpecDoc, rootXml);

		rc = rootXml->saveToString();
	}
	CAF_CM_EXIT;

	return rc;
}

SmartPtrCInstallProviderSpecDoc XmlRoots::parseInstallProviderSpecFromString(
	const std::string xml) {
	CAF_CM_STATIC_FUNC_VALIDATE("XmlRoots", "parseInstallProviderSpecFromString");

	SmartPtrCInstallProviderSpecDoc installProviderSpecDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_STRING(xml);

		const SmartPtrCXmlElement rootXml = CXmlUtils::parseString(xml, "caf:installProviderSpec");
		installProviderSpecDoc = InstallProviderSpecXml::parse(rootXml);
	}
	CAF_CM_EXIT;

	return installProviderSpecDoc;
}

void XmlRoots::saveInstallProviderSpecToFile(
	const SmartPtrCInstallProviderSpecDoc installProviderSpecDoc,
	const std::string filePath) {
	CAF_CM_STATIC_FUNC_LOG_VALIDATE("XmlRoots", "saveInstallProviderSpecToFile");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(installProviderSpecDoc);
		CAF_CM_VALIDATE_STRING(filePath);

		CAF_CM_LOG_DEBUG_VA1("Saving to file - %s", filePath.c_str());

		const std::string installProviderSpecStr =
			saveInstallProviderSpecToString(installProviderSpecDoc);
		FileSystemUtils::saveTextFile(filePath, installProviderSpecStr);
	}
	CAF_CM_EXIT;
}

SmartPtrCInstallProviderSpecDoc XmlRoots::parseInstallProviderSpecFromFile(
	const std::string filePath) {
	CAF_CM_STATIC_FUNC_VALIDATE("XmlRoots", "parseInstallProviderSpecFromFile");

	SmartPtrCInstallProviderSpecDoc installProviderSpecDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_STRING(filePath);

		const SmartPtrCXmlElement rootXml = CXmlUtils::parseFile(filePath, "caf:installProviderSpec");
		installProviderSpecDoc = InstallProviderSpecXml::parse(rootXml);
	}
	CAF_CM_EXIT;

	return installProviderSpecDoc;
}

std::string XmlRoots::saveInstallPackageSpecToString(
	const SmartPtrCInstallPackageSpecDoc installPackageSpecDoc) {
	CAF_CM_STATIC_FUNC_VALIDATE("XmlRoots", "saveInstallPackageSpecToString");

	std::string rc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(installPackageSpecDoc);

		const std::string schemaNamespace = DocXmlUtils::getSchemaNamespace("fx");
		const std::string schemaLocation = DocXmlUtils::getSchemaLocation("fx/CafInstallRequest.xsd");

		const SmartPtrCXmlElement rootXml = CXmlUtils::createRootElement(
			"installPackageSpec", schemaNamespace, schemaLocation);
		InstallPackageSpecXml::add(installPackageSpecDoc, rootXml);

		rc = rootXml->saveToString();
	}
	CAF_CM_EXIT;

	return rc;
}

SmartPtrCInstallPackageSpecDoc XmlRoots::parseInstallPackageSpecFromString(
	const std::string xml) {
	CAF_CM_STATIC_FUNC_VALIDATE("XmlRoots", "parseInstallPackageSpecFromString");

	SmartPtrCInstallPackageSpecDoc installPackageSpecDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_STRING(xml);

		const SmartPtrCXmlElement rootXml = CXmlUtils::parseString(xml, "caf:installPackageSpec");
		installPackageSpecDoc = InstallPackageSpecXml::parse(rootXml);
	}
	CAF_CM_EXIT;

	return installPackageSpecDoc;
}

void XmlRoots::saveInstallPackageSpecToFile(
	const SmartPtrCInstallPackageSpecDoc installPackageSpecDoc,
	const std::string filePath) {
	CAF_CM_STATIC_FUNC_LOG_VALIDATE("XmlRoots", "saveInstallPackageSpecToFile");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(installPackageSpecDoc);
		CAF_CM_VALIDATE_STRING(filePath);

		CAF_CM_LOG_DEBUG_VA1("Saving to file - %s", filePath.c_str());

		const std::string installPackageSpecStr =
			saveInstallPackageSpecToString(installPackageSpecDoc);
		FileSystemUtils::saveTextFile(filePath, installPackageSpecStr);
	}
	CAF_CM_EXIT;
}

SmartPtrCInstallPackageSpecDoc XmlRoots::parseInstallPackageSpecFromFile(
	const std::string filePath) {
	CAF_CM_STATIC_FUNC_VALIDATE("XmlRoots", "parseInstallPackageSpecFromFile");

	SmartPtrCInstallPackageSpecDoc installPackageSpecDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_STRING(filePath);

		const SmartPtrCXmlElement rootXml = CXmlUtils::parseFile(filePath, "caf:installPackageSpec");
		installPackageSpecDoc = InstallPackageSpecXml::parse(rootXml);
	}
	CAF_CM_EXIT;

	return installPackageSpecDoc;
}
