/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/ResponseXml/EventKeyXml.h"

#include "Doc/ResponseDoc/CEventKeyCollectionDoc.h"
#include "Doc/ResponseDoc/CEventKeyDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/ResponseXml/EventKeyCollectionXml.h"

using namespace Caf;

void EventKeyCollectionXml::add(
	const SmartPtrCEventKeyCollectionDoc eventKeyCollectionDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("EventKeyCollectionXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(eventKeyCollectionDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::deque<SmartPtrCEventKeyDoc> eventKeyVal =
			eventKeyCollectionDoc->getEventKey();
		CAF_CM_VALIDATE_STL(eventKeyVal);

		if (! eventKeyVal.empty()) {
			for (TConstIterator<std::deque<SmartPtrCEventKeyDoc> > eventKeyIter(eventKeyVal);
				eventKeyIter; eventKeyIter++) {
				const SmartPtrCXmlElement eventKeyXml =
					thisXml->createAndAddElement("eventKey");
				EventKeyXml::add(*eventKeyIter, eventKeyXml);
			}
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCEventKeyCollectionDoc EventKeyCollectionXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("EventKeyCollectionXml", "parse");

	SmartPtrCEventKeyCollectionDoc eventKeyCollectionDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const CXmlElement::SmartPtrCElementCollection eventKeyChildrenXml =
			thisXml->findRequiredChildren("eventKey");

		std::deque<SmartPtrCEventKeyDoc> eventKeyVal;
		if (! eventKeyChildrenXml.IsNull() && ! eventKeyChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> eventKeyXmlIter(*eventKeyChildrenXml);
				eventKeyXmlIter; eventKeyXmlIter++) {
				const SmartPtrCXmlElement eventKeyXml = eventKeyXmlIter->second;
				const SmartPtrCEventKeyDoc eventKeyDoc =
					EventKeyXml::parse(eventKeyXml);
				eventKeyVal.push_back(eventKeyDoc);
			}
		}

		eventKeyCollectionDoc.CreateInstance();
		eventKeyCollectionDoc->initialize(
			eventKeyVal);
	}
	CAF_CM_EXIT;

	return eventKeyCollectionDoc;
}

