/**
 * Copyright (c) 2018 YADRO (KNS Group LLC)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <skiboot.h>
#include <device.h>
#include <console.h>
#include <chip.h>
#include <ipmi.h>

#include "astbmc.h"

#define CHIP_ID_CPU0 0x00
#define CHIP_ID_CPU1 0x08
#define CHIP_ID_CPU2 0x10
#define CHIP_ID_CPU3 0x18


static const struct slot_table_entry vesnin_phb0_0_slot[] = {
	{
		.etype = st_pluggable_slot,
		.location = ST_LOC_DEVFN(0,0),
		.name = "AUX connector0",
	},
	{ .etype = st_end }
};


static const struct slot_table_entry vesnin_plx_slots[] = {
	{
		.etype = st_builtin_dev,
		.location = ST_LOC_DEVFN(0x01,0),
		.name = "Backplane BMC",
	},
	{
		.etype = st_builtin_dev,
		.location = ST_LOC_DEVFN(0x02,0),
		.name = "Backplane USB",
	},
	{
		.etype = st_builtin_dev,
		.location = ST_LOC_DEVFN(0x03,0),
		.name = "Backplane LAN",
	},
	{ .etype = st_end }
};

static const struct slot_table_entry vesnin_plx_up[] = {
	{
		.etype = st_builtin_dev,
		.location = ST_LOC_DEVFN(0,0),
		.children = vesnin_plx_slots,
	},
	{ .etype = st_end }
};

static const struct slot_table_entry vesnin_phb0_1_slot[] = {
	{
		.etype = st_builtin_dev,
		.location = ST_LOC_DEVFN(0,0),
		.name = "Backplane PLX",
		.children = vesnin_plx_up,
	},
	{ .etype = st_end }
};

static const struct slot_table_entry vesnin_phb0_2_slot[] = {
	{
		.etype = st_pluggable_slot,
		.location = ST_LOC_DEVFN(0,0),
		.name = "PCIE0_x8_CPU0",
	},
	{ .etype = st_end }
};

static const struct slot_table_entry vesnin_phb8_0_slot[] = {
	{
		.etype = st_pluggable_slot,
		.location = ST_LOC_DEVFN(0,0),
		.name = "PCIE1_x16_CPU1",
	},
	{ .etype = st_end }
};

static const struct slot_table_entry vesnin_phb8_1_slot[] = {
	{
		.etype = st_pluggable_slot,
		.location = ST_LOC_DEVFN(0,0),
		.name = "AUX connector1",
	},
	{ .etype = st_end }
};

static const struct slot_table_entry vesnin_phb8_2_slot[] = {
	{
		.etype = st_pluggable_slot,
		.location = ST_LOC_DEVFN(0,0),
		.name = "AUX connector2",
	},
	{ .etype = st_end }
};

static const struct slot_table_entry vesnin_phb9_0_slot[] = {
	{
		.etype = st_pluggable_slot,
		.location = ST_LOC_DEVFN(0,0),
		.name = "AUX connector3",
	},
	{ .etype = st_end }
};

static const struct slot_table_entry vesnin_phb9_1_slot[] = {
	{
		.etype = st_pluggable_slot,
		.location = ST_LOC_DEVFN(0,0),
		.name = "PCIE3_x8_CPU2",
	},
	{ .etype = st_end }
};

static const struct slot_table_entry vesnin_phb9_2_slot[] = {
	{
		.etype = st_pluggable_slot,
		.location = ST_LOC_DEVFN(0,0),
		.name = "PCIE2_x8_CPU2",
	},
	{ .etype = st_end }
};

static const struct slot_table_entry vesnin_phbA_0_slot[] = {
	{
		.etype = st_pluggable_slot,
		.location = ST_LOC_DEVFN(0,0),
		.name = "PCIE4_x16_CPU3",
	},
	{ .etype = st_end }
};

static const struct slot_table_entry vesnin_phbA_1_slot[] = {
	{
		.etype = st_pluggable_slot,
		.location = ST_LOC_DEVFN(0,0),
		.name = "AUX connector4",
	},
	{ .etype = st_end }
};

static const struct slot_table_entry vesnin_phbA_2_slot[] = {
	{
		.etype = st_pluggable_slot,
		.location = ST_LOC_DEVFN(0,0),
		.name = "AUX connector5",
	},
	{ .etype = st_end }
};

static const struct slot_table_entry vesnin_phb_table[] = {
	{
		.etype = st_phb,
		.location = ST_LOC_PHB(CHIP_ID_CPU0,0),
		.children = vesnin_phb0_0_slot,
	},
	{
		.etype = st_phb,
		.location = ST_LOC_PHB(CHIP_ID_CPU0,1),
		.children = vesnin_phb0_1_slot,
	},
	{
		.etype = st_phb,
		.location = ST_LOC_PHB(CHIP_ID_CPU0,2),
		.children = vesnin_phb0_2_slot,
	},

	{
		.etype = st_phb,
		.location = ST_LOC_PHB(CHIP_ID_CPU1,0),
		.children = vesnin_phb8_0_slot,
	},
	{
		.etype = st_phb,
		.location = ST_LOC_PHB(CHIP_ID_CPU1,1),
		.children = vesnin_phb8_1_slot,
	},
	{
		.etype = st_phb,
		.location = ST_LOC_PHB(CHIP_ID_CPU1,2),
		.children = vesnin_phb8_2_slot,
	},

	{
		.etype = st_phb,
		.location = ST_LOC_PHB(CHIP_ID_CPU2,0),
		.children = vesnin_phb9_0_slot,
	},
	{
		.etype = st_phb,
		.location = ST_LOC_PHB(CHIP_ID_CPU2,1),
		.children = vesnin_phb9_1_slot,
	},
	{
		.etype = st_phb,
		.location = ST_LOC_PHB(CHIP_ID_CPU2,2),
		.children = vesnin_phb9_2_slot,
	},

	{
		.etype = st_phb,
		.location = ST_LOC_PHB(CHIP_ID_CPU3,0),
		.children = vesnin_phbA_0_slot,
	},
	{
		.etype = st_phb,
		.location = ST_LOC_PHB(CHIP_ID_CPU3,1),
		.children = vesnin_phbA_1_slot,
	},
	{
		.etype = st_phb,
		.location = ST_LOC_PHB(CHIP_ID_CPU3,2),
		.children = vesnin_phbA_2_slot,
	},
	{ .etype = st_end }
};

static bool vesnin_probe(void)
{
	if (!dt_node_is_compatible(dt_root, "YADRO,vesnin"))
		return false;

	/* Lot of common early inits here */
	astbmc_early_init();
	slot_table_init(vesnin_phb_table);

	return true;
}

DECLARE_PLATFORM(vesnin) = {
	.name			= "vesnin",
	.bmc			= &astbmc_ami,
	.probe			= vesnin_probe,
	.init			= astbmc_init,
	.pci_get_slot_info	= slot_table_get_slot_info,
	.pci_probe_complete	= check_all_slot_table,
	.external_irq		= astbmc_ext_irq_serirq_cpld,
	.cec_power_down		= astbmc_ipmi_power_down,
	.cec_reboot		= astbmc_ipmi_reboot,
	.elog_commit		= ipmi_elog_commit,
	.start_preload_resource	= flash_start_preload_resource,
	.resource_loaded	= flash_resource_loaded,
	.exit			= ipmi_wdt_final_reset,
	.terminate		= ipmi_terminate,
};
