// Copyright(c) 2017, Intel Corporation
//
// Redistribution  and  use  in source  and  binary  forms,  with  or  without
// modification, are permitted provided that the following conditions are met:
//
// * Redistributions of  source code  must retain the  above copyright notice,
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice,
//   this list of conditions and the following disclaimer in the documentation
//   and/or other materials provided with the distribution.
// * Neither the name  of Intel Corporation  nor the names of its contributors
//   may be used to  endorse or promote  products derived  from this  software
//   without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,  BUT NOT LIMITED TO,  THE
// IMPLIED WARRANTIES OF  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT  SHALL THE COPYRIGHT OWNER  OR CONTRIBUTORS BE
// LIABLE  FOR  ANY  DIRECT,  INDIRECT,  INCIDENTAL,  SPECIAL,  EXEMPLARY,  OR
// CONSEQUENTIAL  DAMAGES  (INCLUDING,  BUT  NOT LIMITED  TO,  PROCUREMENT  OF
// SUBSTITUTE GOODS OR SERVICES;  LOSS OF USE,  DATA, OR PROFITS;  OR BUSINESS
// INTERRUPTION)  HOWEVER CAUSED  AND ON ANY THEORY  OF LIABILITY,  WHETHER IN
// CONTRACT,  STRICT LIABILITY,  OR TORT  (INCLUDING NEGLIGENCE  OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,  EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

// V1_qph_user_clk_pgm_Uclock_freq_template.cpp.inc: bdx-p user clock fPLL array
// Arthur.Sheiman@Intel.com   Created: 09-08-16
// Revision: 03-21-17  19:51


const uint32_t scu32ia3d_DiffMifTbl_322[QUCPU_INT_NUMFRQ][QUCPU_INT_NUMREG]
				       [QUCPU_INT_NUMRCK] = {
					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0b},
						{0x110ff1e, 0x110ff16},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff40},
						{0x12cff08, 0x12cff18},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f46},
						{0x1347c30, 0x1347c50},
						{0x135ff03, 0x135ff03},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff05},
						{0x110ff1e, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff0a},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c30},
						{0x135ff03, 0x135ff03},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff0f, 0x10fff0a},
						{0x110ff1e, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afc04, 0x12afc04},
						{0x12bff1e, 0x12bff10},
						{0x12cff08, 0x12cff08},
						{0x12dff01, 0x12dff01},
						{0x12eff00, 0x12eff00},
						{0x12fff00, 0x12fff00},
						{0x130ff00, 0x130ff00},
						{0x1337f42, 0x1337f4a},
						{0x1347c30, 0x1347c40},
						{0x135ff03, 0x135ff04},
						{0x1427f00, 0x1427f00}},

					       {{0x10fff3c, 0x10fff3c},
						{0x110ff78, 0x110ff78},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff99},
						{0x12eff00, 0x12eff99},
						{0x12fff00, 0x12fff99},
						{0x130ff00, 0x130ff99},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff3a, 0x10fff3a},
						{0x110ff74, 0x110ff74},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dffd3},
						{0x12effc2, 0x12eff72},
						{0x12ffff5, 0x12fff8d},
						{0x130ff28, 0x130ffbc},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff38, 0x10fff38},
						{0x110ff70, 0x110ff70},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff6f},
						{0x12effa3, 0x12eff5f},
						{0x12fff70, 0x12fff07},
						{0x130ff3d, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff36, 0x10fff36},
						{0x110ff6c, 0x110ff6c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff6f},
						{0x12effa3, 0x12eff5f},
						{0x12fff70, 0x12fff07},
						{0x130ff3d, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff34, 0x10fff34},
						{0x110ff68, 0x110ff68},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dffd3},
						{0x12effc2, 0x12eff72},
						{0x12ffff5, 0x12fff8d},
						{0x130ff28, 0x130ffbc},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff32, 0x10fff32},
						{0x110ff64, 0x110ff64},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff99},
						{0x12eff00, 0x12eff99},
						{0x12fff00, 0x12fff99},
						{0x130ff00, 0x130ff99},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff31, 0x10fff31},
						{0x110ff62, 0x110ff62},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff82},
						{0x12effae, 0x12effbd},
						{0x12fff47, 0x12fff9c},
						{0x130ff61, 0x130ffec},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff2f, 0x10fff2f},
						{0x110ff5e, 0x110ff5e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff36},
						{0x12effe1, 0x12eff86},
						{0x12fff7a, 0x12fff13},
						{0x130ff14, 0x130ffab},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff2e, 0x10fff2e},
						{0x110ff5c, 0x110ff5c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff5a},
						{0x12efff5, 0x12eff42},
						{0x12fff28, 0x12fff3e},
						{0x130ff5c, 0x130ffe8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff2d, 0x10fff2d},
						{0x110ff5a, 0x110ff5a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff31},
						{0x12eff99, 0x12eff08},
						{0x12fff99, 0x12fffac},
						{0x130ff99, 0x130ff1c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff2b, 0x10fff2b},
						{0x110ff56, 0x110ff56},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff5d},
						{0x12eff99, 0x12eff01},
						{0x12fff99, 0x12fff72},
						{0x130ff19, 0x130ffaf},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff2a, 0x10fff2a},
						{0x110ff54, 0x110ff54},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff6f},
						{0x12effa3, 0x12eff5f},
						{0x12fff70, 0x12fff07},
						{0x130ff3d, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff29, 0x10fff29},
						{0x110ff52, 0x110ff52},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dff33},
						{0x12eff3d, 0x12effc7},
						{0x12fff0a, 0x12fffdf},
						{0x130ff57, 0x130ffe3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff28, 0x10fff28},
						{0x110ff50, 0x110ff50},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffa9},
						{0x12eff66, 0x12eff38},
						{0x12fff66, 0x12ffffb},
						{0x130ff66, 0x130fff0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff27, 0x10fff27},
						{0x110ff4e, 0x110ff4e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dffd0},
						{0x12eff1e, 0x12effb3},
						{0x12fff85, 0x12fff59},
						{0x130ff6b, 0x130fff5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff26, 0x10fff26},
						{0x110ff4c, 0x110ff4c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffa9},
						{0x12eff66, 0x12eff38},
						{0x12fff66, 0x12ffffb},
						{0x130ff66, 0x130fff0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff25, 0x10fff25},
						{0x110ff4a, 0x110ff4a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dff33},
						{0x12eff3d, 0x12effc7},
						{0x12fff0a, 0x12fffdf},
						{0x130ff57, 0x130ffe3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff24, 0x10fff24},
						{0x110ff48, 0x110ff48},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff6f},
						{0x12effa3, 0x12eff5f},
						{0x12fff70, 0x12fff07},
						{0x130ff3d, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff23, 0x10fff23},
						{0x110ff46, 0x110ff46},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff5d},
						{0x12eff99, 0x12eff01},
						{0x12fff99, 0x12fff72},
						{0x130ff19, 0x130ffaf},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff23, 0x10fff23},
						{0x110ff46, 0x110ff46},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffb9},
						{0x12effcc, 0x12effd7},
						{0x12fffcc, 0x12fff5c},
						{0x130ffcc, 0x130ff48},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff22, 0x10fff22},
						{0x110ff44, 0x110ff44},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff31},
						{0x12eff99, 0x12eff08},
						{0x12fff99, 0x12fffac},
						{0x130ff99, 0x130ff1c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff21, 0x10fff21},
						{0x110ff42, 0x110ff42},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff5a},
						{0x12efff5, 0x12eff42},
						{0x12fff28, 0x12fff3e},
						{0x130ff5c, 0x130ffe8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff20, 0x10fff20},
						{0x110ff40, 0x110ff40},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff36},
						{0x12effe1, 0x12eff86},
						{0x12fff7a, 0x12fff13},
						{0x130ff14, 0x130ffab},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff20, 0x10fff20},
						{0x110ff40, 0x110ff40},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff1c},
						{0x12effeb, 0x12effeb},
						{0x12fff51, 0x12fffe2},
						{0x130ffb8, 0x130ff36},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff1f, 0x10fff1f},
						{0x110ff3e, 0x110ff3e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff82},
						{0x12effae, 0x12effbd},
						{0x12fff47, 0x12fff9c},
						{0x130ff61, 0x130ffec},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff1e, 0x10fff1e},
						{0x110ff3c, 0x110ff3c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff99},
						{0x12eff00, 0x12eff99},
						{0x12fff00, 0x12fff99},
						{0x130ff00, 0x130ff99},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff1e, 0x10fff1e},
						{0x110ff3c, 0x110ff3c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff31},
						{0x12eff99, 0x12eff08},
						{0x12fff99, 0x12fffac},
						{0x130ff99, 0x130ff1c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff1d, 0x10fff1d},
						{0x110ff3a, 0x110ff3a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dffd3},
						{0x12effc2, 0x12eff72},
						{0x12ffff5, 0x12fff8d},
						{0x130ff28, 0x130ffbc},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff1d, 0x10fff1d},
						{0x110ff3a, 0x110ff3a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff43},
						{0x12effa3, 0x12eff66},
						{0x12fff70, 0x12fff41},
						{0x130ffbd, 0x130ff3b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff1c, 0x10fff1c},
						{0x110ff38, 0x110ff38},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff6f},
						{0x12effa3, 0x12eff5f},
						{0x12fff70, 0x12fff07},
						{0x130ff3d, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff1c, 0x10fff1c},
						{0x110ff38, 0x110ff38},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffb9},
						{0x12effcc, 0x12effd7},
						{0x12fffcc, 0x12fff5c},
						{0x130ffcc, 0x130ff48},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff1b, 0x10fff1b},
						{0x110ff36, 0x110ff36},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff6f},
						{0x12effa3, 0x12eff5f},
						{0x12fff70, 0x12fff07},
						{0x130ff3d, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff1b, 0x10fff1b},
						{0x110ff36, 0x110ff36},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff91},
						{0x12eff14, 0x12eff5c},
						{0x12fffae, 0x12ffffe},
						{0x130ffc7, 0x130ff43},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff1a, 0x10fff1a},
						{0x110ff34, 0x110ff34},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dffd3},
						{0x12effc2, 0x12eff72},
						{0x12ffff5, 0x12fff8d},
						{0x130ff28, 0x130ffbc},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff1a, 0x10fff1a},
						{0x110ff34, 0x110ff34},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dffcd},
						{0x12eff7a, 0x12efff4},
						{0x12fff14, 0x12fff25},
						{0x130ffae, 0x130ff2e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff19, 0x10fff19},
						{0x110ff32, 0x110ff32},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff99},
						{0x12eff00, 0x12eff99},
						{0x12fff00, 0x12fff99},
						{0x130ff00, 0x130ff99},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff19, 0x10fff19},
						{0x110ff32, 0x110ff32},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff6d},
						{0x12eff00, 0x12effa0},
						{0x12fff00, 0x12fffd3},
						{0x130ff80, 0x130ff06},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff19, 0x10fff19},
						{0x110ff32, 0x110ff32},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff40},
						{0x12eff00, 0x12effa7},
						{0x12fff00, 0x12fff0d},
						{0x130ff00, 0x130ff74},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff18, 0x10fff18},
						{0x110ff30, 0x110ff30},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff6f},
						{0x12effa3, 0x12eff5f},
						{0x12fff70, 0x12fff07},
						{0x130ff3d, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff18, 0x10fff18},
						{0x110ff30, 0x110ff30},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff1c},
						{0x12effeb, 0x12effeb},
						{0x12fff51, 0x12fffe2},
						{0x130ffb8, 0x130ff36},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff18, 0x10fff18},
						{0x110ff30, 0x110ff30},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffc8},
						{0x12eff33, 0x12eff76},
						{0x12fff33, 0x12fffbe},
						{0x130ff33, 0x130ff9f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff17, 0x10fff17},
						{0x110ff2e, 0x110ff2e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff5a},
						{0x12efff5, 0x12eff42},
						{0x12fff28, 0x12fff3e},
						{0x130ff5c, 0x130ffe8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff17, 0x10fff17},
						{0x110ff2e, 0x110ff2e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dffe0},
						{0x12eff85, 0x12eff52},
						{0x12fffeb, 0x12fffbb},
						{0x130ffd1, 0x130ff4c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff17, 0x10fff17},
						{0x110ff2e, 0x110ff2e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff65},
						{0x12eff14, 0x12eff63},
						{0x12fffae, 0x12fff38},
						{0x130ff47, 0x130ffb1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff16, 0x10fff16},
						{0x110ff2c, 0x110ff2c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff5a},
						{0x12efff5, 0x12eff42},
						{0x12fff28, 0x12fff3e},
						{0x130ff5c, 0x130ffe8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff16, 0x10fff16},
						{0x110ff2c, 0x110ff2c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffb9},
						{0x12effcc, 0x12effd7},
						{0x12fffcc, 0x12fff5c},
						{0x130ffcc, 0x130ff48},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff16, 0x10fff16},
						{0x110ff2c, 0x110ff2c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff17},
						{0x12effa3, 0x12eff6d},
						{0x12fff70, 0x12fff7b},
						{0x130ff3d, 0x130ffa8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff15, 0x10fff15},
						{0x110ff2a, 0x110ff2a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff6f},
						{0x12effa3, 0x12eff5f},
						{0x12fff70, 0x12fff07},
						{0x130ff3d, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff15, 0x10fff15},
						{0x110ff2a, 0x110ff2a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dffa6},
						{0x12effc2, 0x12eff79},
						{0x12ffff5, 0x12fffc7},
						{0x130ffa8, 0x130ff29},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff15, 0x10fff15},
						{0x110ff2a, 0x110ff2a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dffdd},
						{0x12effe1, 0x12eff93},
						{0x12fff7a, 0x12fff87},
						{0x130ff14, 0x130ff85},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff14, 0x10fff14},
						{0x110ff28, 0x110ff28},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff99},
						{0x12eff00, 0x12eff99},
						{0x12fff00, 0x12fff99},
						{0x130ff00, 0x130ff99},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff14, 0x10fff14},
						{0x110ff28, 0x110ff28},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffa9},
						{0x12eff66, 0x12eff38},
						{0x12fff66, 0x12ffffb},
						{0x130ff66, 0x130fff0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff14, 0x10fff14},
						{0x110ff28, 0x110ff28},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffb9},
						{0x12effcc, 0x12effd7},
						{0x12fffcc, 0x12fff5c},
						{0x130ffcc, 0x130ff48},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff14, 0x10fff14},
						{0x110ff28, 0x110ff28},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffc8},
						{0x12eff33, 0x12eff76},
						{0x12fff33, 0x12fffbe},
						{0x130ff33, 0x130ff9f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff13, 0x10fff13},
						{0x110ff26, 0x110ff26},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dffc0},
						{0x12effb8, 0x12eff14},
						{0x12fff1e, 0x12ffff8},
						{0x130ff05, 0x130ff9d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff13, 0x10fff13},
						{0x110ff26, 0x110ff26},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffa9},
						{0x12eff66, 0x12eff38},
						{0x12fff66, 0x12ffffb},
						{0x130ff66, 0x130fff0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff13, 0x10fff13},
						{0x110ff26, 0x110ff26},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff91},
						{0x12eff14, 0x12eff5c},
						{0x12fffae, 0x12ffffe},
						{0x130ffc7, 0x130ff43},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff13, 0x10fff13},
						{0x110ff26, 0x110ff26},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff7a},
						{0x12effc2, 0x12eff80},
						{0x12ffff5, 0x12fff01},
						{0x130ff28, 0x130ff97},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff13, 0x10fff13},
						{0x110ff26, 0x110ff26},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dff62},
						{0x12eff70, 0x12effa4},
						{0x12fff3d, 0x12fff04},
						{0x130ff8a, 0x130ffea},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff12, 0x10fff12},
						{0x110ff24, 0x110ff24},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff6f},
						{0x12effa3, 0x12eff5f},
						{0x12fff70, 0x12fff07},
						{0x130ff3d, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff12, 0x10fff12},
						{0x110ff24, 0x110ff24},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff31},
						{0x12eff99, 0x12eff08},
						{0x12fff99, 0x12fffac},
						{0x130ff99, 0x130ff1c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff12, 0x10fff12},
						{0x110ff24, 0x110ff24},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dfff2},
						{0x12eff8f, 0x12effb0},
						{0x12fffc2, 0x12fff50},
						{0x130fff5, 0x130ff6b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff12, 0x10fff12},
						{0x110ff24, 0x110ff24},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dffb3},
						{0x12eff85, 0x12eff59},
						{0x12fffeb, 0x12ffff5},
						{0x130ff51, 0x130ffb9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff12, 0x10fff12},
						{0x110ff24, 0x110ff24},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff75},
						{0x12eff7a, 0x12eff02},
						{0x12fff14, 0x12fff9a},
						{0x130ffae, 0x130ff08},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff11, 0x10fff11},
						{0x110ff22, 0x110ff22},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dff97},
						{0x12eff5c, 0x12effda},
						{0x12fff8f, 0x12fff65},
						{0x130ff42, 0x130ffd2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff11, 0x10fff11},
						{0x110ff22, 0x110ff22},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff31},
						{0x12eff99, 0x12eff08},
						{0x12fff99, 0x12fffac},
						{0x130ff99, 0x130ff1c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff11, 0x10fff11},
						{0x110ff22, 0x110ff22},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dffcb},
						{0x12effd7, 0x12eff35},
						{0x12fffa3, 0x12ffff2},
						{0x130fff0, 0x130ff66},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff11, 0x10fff11},
						{0x110ff22, 0x110ff22},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff65},
						{0x12eff14, 0x12eff63},
						{0x12fffae, 0x12fff38},
						{0x130ff47, 0x130ffb1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff11, 0x10fff11},
						{0x110ff22, 0x110ff22},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dffff},
						{0x12eff51, 0x12eff90},
						{0x12fffb8, 0x12fff7e},
						{0x130ff9e, 0x130fffb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff10, 0x10fff10},
						{0x110ff20, 0x110ff20},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff36},
						{0x12effe1, 0x12eff86},
						{0x12fff7a, 0x12fff13},
						{0x130ff14, 0x130ffab},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff10, 0x10fff10},
						{0x110ff20, 0x110ff20},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffa9},
						{0x12eff66, 0x12eff38},
						{0x12fff66, 0x12ffffb},
						{0x130ff66, 0x130fff0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff10, 0x10fff10},
						{0x110ff20, 0x110ff20},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff1c},
						{0x12effeb, 0x12effeb},
						{0x12fff51, 0x12fffe2},
						{0x130ffb8, 0x130ff36},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff10, 0x10fff10},
						{0x110ff20, 0x110ff20},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dff8f},
						{0x12eff70, 0x12eff9d},
						{0x12fff3d, 0x12fffca},
						{0x130ff0a, 0x130ff7c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff10, 0x10fff10},
						{0x110ff20, 0x110ff20},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff02},
						{0x12efff5, 0x12eff50},
						{0x12fff28, 0x12fffb2},
						{0x130ff5c, 0x130ffc2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff10, 0x10fff10},
						{0x110ff20, 0x110ff20},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff75},
						{0x12eff7a, 0x12eff02},
						{0x12fff14, 0x12fff9a},
						{0x130ffae, 0x130ff08},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0f, 0x10fff0f},
						{0x110ff1e, 0x110ff1e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff99},
						{0x12eff00, 0x12eff99},
						{0x12fff00, 0x12fff99},
						{0x130ff00, 0x130ff99},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0f, 0x10fff0f},
						{0x110ff1e, 0x110ff1e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffe5},
						{0x12effcc, 0x12effd0},
						{0x12fffcc, 0x12fff22},
						{0x130ff4c, 0x130ffdb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0f, 0x10fff0f},
						{0x110ff1e, 0x110ff1e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff31},
						{0x12eff99, 0x12eff08},
						{0x12fff99, 0x12fffac},
						{0x130ff99, 0x130ff1c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0f, 0x10fff0f},
						{0x110ff1e, 0x110ff1e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff7c},
						{0x12eff66, 0x12eff3f},
						{0x12fff66, 0x12fff35},
						{0x130ffe6, 0x130ff5e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0f, 0x10fff0f},
						{0x110ff1e, 0x110ff1e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffc8},
						{0x12eff33, 0x12eff76},
						{0x12fff33, 0x12fffbe},
						{0x130ff33, 0x130ff9f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0f, 0x10fff0f},
						{0x110ff1e, 0x110ff1e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff14},
						{0x12eff00, 0x12effae},
						{0x12fff00, 0x12fff47},
						{0x130ff80, 0x130ffe1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0f, 0x10fff0f},
						{0x110ff1e, 0x110ff1e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff60},
						{0x12effcc, 0x12effe5},
						{0x12fffcc, 0x12fffd0},
						{0x130ffcc, 0x130ff22},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0f, 0x10fff0f},
						{0x110ff1e, 0x110ff1e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffac},
						{0x12eff99, 0x12eff1c},
						{0x12fff99, 0x12fff5a},
						{0x130ff19, 0x130ff64},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0e, 0x10fff0e},
						{0x110ff1c, 0x110ff1c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff6f},
						{0x12effa3, 0x12eff5f},
						{0x12fff70, 0x12fff07},
						{0x130ff3d, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0e, 0x10fff0e},
						{0x110ff1c, 0x110ff1c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff94},
						{0x12effb8, 0x12eff1b},
						{0x12fff1e, 0x12fff32},
						{0x130ff85, 0x130ff0b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0e, 0x10fff0e},
						{0x110ff1c, 0x110ff1c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffb9},
						{0x12effcc, 0x12effd7},
						{0x12fffcc, 0x12fff5c},
						{0x130ffcc, 0x130ff48},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0e, 0x10fff0e},
						{0x110ff1c, 0x110ff1c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dffdd},
						{0x12effe1, 0x12eff93},
						{0x12fff7a, 0x12fff87},
						{0x130ff14, 0x130ff85},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0e, 0x10fff0e},
						{0x110ff1c, 0x110ff1c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff02},
						{0x12efff5, 0x12eff50},
						{0x12fff28, 0x12fffb2},
						{0x130ff5c, 0x130ffc2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0e, 0x10fff0e},
						{0x110ff1c, 0x110ff1c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dff26},
						{0x12eff0a, 0x12eff0c},
						{0x12fffd7, 0x12fffdd},
						{0x130ffa3, 0x130ffff},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0e, 0x10fff0e},
						{0x110ff1c, 0x110ff1c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff4b},
						{0x12eff1e, 0x12effc8},
						{0x12fff85, 0x12fff07},
						{0x130ffeb, 0x130ff3d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0e, 0x10fff0e},
						{0x110ff1c, 0x110ff1c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff6f},
						{0x12eff33, 0x12eff84},
						{0x12fff33, 0x12fff32},
						{0x130ff33, 0x130ff7a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0d, 0x10fff0d},
						{0x110ff1a, 0x110ff1a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dffd3},
						{0x12effc2, 0x12eff72},
						{0x12ffff5, 0x12fff8d},
						{0x130ff28, 0x130ffbc},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0d, 0x10fff0d},
						{0x110ff1a, 0x110ff1a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dffd0},
						{0x12eff1e, 0x12effb3},
						{0x12fff85, 0x12fff59},
						{0x130ff6b, 0x130fff5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0d, 0x10fff0d},
						{0x110ff1a, 0x110ff1a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dffcd},
						{0x12eff7a, 0x12efff4},
						{0x12fff14, 0x12fff25},
						{0x130ffae, 0x130ff2e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0d, 0x10fff0d},
						{0x110ff1a, 0x110ff1a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dffcb},
						{0x12effd7, 0x12eff35},
						{0x12fffa3, 0x12ffff2},
						{0x130fff0, 0x130ff66},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0d, 0x10fff0d},
						{0x110ff1a, 0x110ff1a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffc8},
						{0x12eff33, 0x12eff76},
						{0x12fff33, 0x12fffbe},
						{0x130ff33, 0x130ff9f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0d, 0x10fff0d},
						{0x110ff1a, 0x110ff1a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dffc6},
						{0x12eff8f, 0x12effb7},
						{0x12fffc2, 0x12fff8a},
						{0x130ff75, 0x130ffd8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0d, 0x10fff0d},
						{0x110ff1a, 0x110ff1a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dffc3},
						{0x12effeb, 0x12efff8},
						{0x12fff51, 0x12fff56},
						{0x130ffb8, 0x130ff11},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0d, 0x10fff0d},
						{0x110ff1a, 0x110ff1a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dffc0},
						{0x12eff47, 0x12eff39},
						{0x12fffe1, 0x12fff23},
						{0x130fffa, 0x130ff4a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0d, 0x10fff0d},
						{0x110ff1a, 0x110ff1a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dffbe},
						{0x12effa3, 0x12eff7a},
						{0x12fff70, 0x12fffef},
						{0x130ff3d, 0x130ff82},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0c, 0x10fff0c},
						{0x110ff18, 0x110ff18},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff99},
						{0x12eff00, 0x12eff99},
						{0x12fff00, 0x12fff99},
						{0x130ff00, 0x130ff99},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0c, 0x10fff0c},
						{0x110ff18, 0x110ff18},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff6f},
						{0x12effa3, 0x12eff5f},
						{0x12fff70, 0x12fff07},
						{0x130ff3d, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0c, 0x10fff0c},
						{0x110ff18, 0x110ff18},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff46},
						{0x12eff47, 0x12eff25},
						{0x12fffe1, 0x12fff75},
						{0x130ff7a, 0x130ff02},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0c, 0x10fff0c},
						{0x110ff18, 0x110ff18},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff1c},
						{0x12effeb, 0x12effeb},
						{0x12fff51, 0x12fffe2},
						{0x130ffb8, 0x130ff36},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0c, 0x10fff0c},
						{0x110ff18, 0x110ff18},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dfff2},
						{0x12eff8f, 0x12effb0},
						{0x12fffc2, 0x12fff50},
						{0x130fff5, 0x130ff6b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0c, 0x10fff0c},
						{0x110ff18, 0x110ff18},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffc8},
						{0x12eff33, 0x12eff76},
						{0x12fff33, 0x12fffbe},
						{0x130ff33, 0x130ff9f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0c, 0x10fff0c},
						{0x110ff18, 0x110ff18},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff9e},
						{0x12effd7, 0x12eff3c},
						{0x12fffa3, 0x12fff2c},
						{0x130ff70, 0x130ffd4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0c, 0x10fff0c},
						{0x110ff18, 0x110ff18},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff75},
						{0x12eff7a, 0x12eff02},
						{0x12fff14, 0x12fff9a},
						{0x130ffae, 0x130ff08},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0c, 0x10fff0c},
						{0x110ff18, 0x110ff18},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff4b},
						{0x12eff1e, 0x12effc8},
						{0x12fff85, 0x12fff07},
						{0x130ffeb, 0x130ff3d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0c, 0x10fff0c},
						{0x110ff18, 0x110ff18},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff21},
						{0x12effc2, 0x12eff8e},
						{0x12ffff5, 0x12fff75},
						{0x130ff28, 0x130ff71},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0c, 0x10fff0c},
						{0x110ff18, 0x110ff18},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dfff7},
						{0x12eff66, 0x12eff53},
						{0x12fff66, 0x12fffe3},
						{0x130ff66, 0x130ffa5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0c, 0x10fff0c},
						{0x110ff18, 0x110ff18},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dffce},
						{0x12eff0a, 0x12eff19},
						{0x12fffd7, 0x12fff51},
						{0x130ffa3, 0x130ffda},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0b, 0x10fff0b},
						{0x110ff16, 0x110ff16},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dffab},
						{0x12eff0a, 0x12efff7},
						{0x12fffd7, 0x12fff2e},
						{0x130ff23, 0x130ffb8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0b, 0x10fff0b},
						{0x110ff16, 0x110ff16},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff5a},
						{0x12efff5, 0x12eff42},
						{0x12fff28, 0x12fff3e},
						{0x130ff5c, 0x130ffe8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0b, 0x10fff0b},
						{0x110ff16, 0x110ff16},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff09},
						{0x12effe1, 0x12eff8d},
						{0x12fff7a, 0x12fff4d},
						{0x130ff94, 0x130ff18},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0b, 0x10fff0b},
						{0x110ff16, 0x110ff16},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffb9},
						{0x12effcc, 0x12effd7},
						{0x12fffcc, 0x12fff5c},
						{0x130ffcc, 0x130ff48},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0b, 0x10fff0b},
						{0x110ff16, 0x110ff16},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff68},
						{0x12effb8, 0x12eff22},
						{0x12fff1e, 0x12fff6c},
						{0x130ff05, 0x130ff78},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0b, 0x10fff0b},
						{0x110ff16, 0x110ff16},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff17},
						{0x12effa3, 0x12eff6d},
						{0x12fff70, 0x12fff7b},
						{0x130ff3d, 0x130ffa8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0b, 0x10fff0b},
						{0x110ff16, 0x110ff16},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dffc6},
						{0x12eff8f, 0x12effb7},
						{0x12fffc2, 0x12fff8a},
						{0x130ff75, 0x130ffd8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0b, 0x10fff0b},
						{0x110ff16, 0x110ff16},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff75},
						{0x12eff7a, 0x12eff02},
						{0x12fff14, 0x12fff9a},
						{0x130ffae, 0x130ff08},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0b, 0x10fff0b},
						{0x110ff16, 0x110ff16},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff24},
						{0x12eff66, 0x12eff4d},
						{0x12fff66, 0x12fffa9},
						{0x130ffe6, 0x130ff38},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0b, 0x10fff0b},
						{0x110ff16, 0x110ff16},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dffd3},
						{0x12eff51, 0x12eff97},
						{0x12fffb8, 0x12fffb8},
						{0x130ff1e, 0x130ff68},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0b, 0x10fff0b},
						{0x110ff16, 0x110ff16},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dff82},
						{0x12eff3d, 0x12effe2},
						{0x12fff0a, 0x12fffc7},
						{0x130ff57, 0x130ff98},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0b, 0x10fff0b},
						{0x110ff16, 0x110ff16},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff31},
						{0x12eff28, 0x12eff2d},
						{0x12fff5c, 0x12fffd7},
						{0x130ff8f, 0x130ffc8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0b, 0x10fff0b},
						{0x110ff16, 0x110ff16},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dffe0},
						{0x12eff14, 0x12eff77},
						{0x12fffae, 0x12fffe6},
						{0x130ffc7, 0x130fff8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0a, 0x10fff0a},
						{0x110ff14, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff99},
						{0x12eff00, 0x12eff99},
						{0x12fff00, 0x12fff99},
						{0x130ff00, 0x130ff99},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0a, 0x10fff0a},
						{0x110ff14, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff21},
						{0x12eff33, 0x12eff69},
						{0x12fff33, 0x12fff4a},
						{0x130ff33, 0x130ffc5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0a, 0x10fff0a},
						{0x110ff14, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffa9},
						{0x12eff66, 0x12eff38},
						{0x12fff66, 0x12ffffb},
						{0x130ff66, 0x130fff0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0a, 0x10fff0a},
						{0x110ff14, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff31},
						{0x12eff99, 0x12eff08},
						{0x12fff99, 0x12fffac},
						{0x130ff99, 0x130ff1c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0a, 0x10fff0a},
						{0x110ff14, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffb9},
						{0x12effcc, 0x12effd7},
						{0x12fffcc, 0x12fff5c},
						{0x130ffcc, 0x130ff48},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0a, 0x10fff0a},
						{0x110ff14, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff40},
						{0x12eff00, 0x12effa7},
						{0x12fff00, 0x12fff0d},
						{0x130ff00, 0x130ff74},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0a, 0x10fff0a},
						{0x110ff14, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffc8},
						{0x12eff33, 0x12eff76},
						{0x12fff33, 0x12fffbe},
						{0x130ff33, 0x130ff9f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0a, 0x10fff0a},
						{0x110ff14, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff50},
						{0x12eff66, 0x12eff46},
						{0x12fff66, 0x12fff6f},
						{0x130ff66, 0x130ffcb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0a, 0x10fff0a},
						{0x110ff14, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffd8},
						{0x12eff99, 0x12eff15},
						{0x12fff99, 0x12fff20},
						{0x130ff99, 0x130fff7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0a, 0x10fff0a},
						{0x110ff14, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff60},
						{0x12effcc, 0x12effe5},
						{0x12fffcc, 0x12fffd0},
						{0x130ffcc, 0x130ff22},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0a, 0x10fff0a},
						{0x110ff14, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dffe8},
						{0x12eff00, 0x12effb4},
						{0x12fff00, 0x12fff81},
						{0x130ff00, 0x130ff4e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0a, 0x10fff0a},
						{0x110ff14, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff6f},
						{0x12eff33, 0x12eff84},
						{0x12fff33, 0x12fff32},
						{0x130ff33, 0x130ff7a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0a, 0x10fff0a},
						{0x110ff14, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dfff7},
						{0x12eff66, 0x12eff53},
						{0x12fff66, 0x12fffe3},
						{0x130ff66, 0x130ffa5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0a, 0x10fff0a},
						{0x110ff14, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff7f},
						{0x12eff99, 0x12eff23},
						{0x12fff99, 0x12fff94},
						{0x130ff99, 0x130ffd1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0a, 0x10fff0a},
						{0x110ff14, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff07},
						{0x12effcc, 0x12efff3},
						{0x12fffcc, 0x12fff44},
						{0x130ffcc, 0x130fffd},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0a, 0x10fff0a},
						{0x110ff14, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff8f},
						{0x12eff00, 0x12effc2},
						{0x12fff00, 0x12ffff5},
						{0x130ff00, 0x130ff28},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff0a, 0x10fff0a},
						{0x110ff14, 0x110ff14},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff17},
						{0x12eff33, 0x12eff92},
						{0x12fff33, 0x12fffa6},
						{0x130ff33, 0x130ff54},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff09, 0x10fff09},
						{0x110ff12, 0x110ff12},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff0f},
						{0x12eff28, 0x12eff0b},
						{0x12fff5c, 0x12fffb5},
						{0x130ff0f, 0x130ffa6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff09, 0x10fff09},
						{0x110ff12, 0x110ff12},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff6f},
						{0x12effa3, 0x12eff5f},
						{0x12fff70, 0x12fff07},
						{0x130ff3d, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff09, 0x10fff09},
						{0x110ff12, 0x110ff12},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dffd0},
						{0x12eff1e, 0x12effb3},
						{0x12fff85, 0x12fff59},
						{0x130ff6b, 0x130fff5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff09, 0x10fff09},
						{0x110ff12, 0x110ff12},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff31},
						{0x12eff99, 0x12eff08},
						{0x12fff99, 0x12fffac},
						{0x130ff99, 0x130ff1c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff09, 0x10fff09},
						{0x110ff12, 0x110ff12},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff91},
						{0x12eff14, 0x12eff5c},
						{0x12fffae, 0x12ffffe},
						{0x130ffc7, 0x130ff43},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff09, 0x10fff09},
						{0x110ff12, 0x110ff12},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dfff2},
						{0x12eff8f, 0x12effb0},
						{0x12fffc2, 0x12fff50},
						{0x130fff5, 0x130ff6b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff09, 0x10fff09},
						{0x110ff12, 0x110ff12},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dff53},
						{0x12eff0a, 0x12eff05},
						{0x12fffd7, 0x12fffa3},
						{0x130ff23, 0x130ff92},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff09, 0x10fff09},
						{0x110ff12, 0x110ff12},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dffb3},
						{0x12eff85, 0x12eff59},
						{0x12fffeb, 0x12ffff5},
						{0x130ff51, 0x130ffb9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff09, 0x10fff09},
						{0x110ff12, 0x110ff12},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff14},
						{0x12eff00, 0x12effae},
						{0x12fff00, 0x12fff47},
						{0x130ff80, 0x130ffe1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff09, 0x10fff09},
						{0x110ff12, 0x110ff12},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff75},
						{0x12eff7a, 0x12eff02},
						{0x12fff14, 0x12fff9a},
						{0x130ffae, 0x130ff08},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff09, 0x10fff09},
						{0x110ff12, 0x110ff12},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dffd5},
						{0x12efff5, 0x12eff56},
						{0x12fff28, 0x12fffec},
						{0x130ffdc, 0x130ff2f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff09, 0x10fff09},
						{0x110ff12, 0x110ff12},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dff36},
						{0x12eff70, 0x12effab},
						{0x12fff3d, 0x12fff3e},
						{0x130ff0a, 0x130ff57},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff09, 0x10fff09},
						{0x110ff12, 0x110ff12},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff97},
						{0x12effeb, 0x12effff},
						{0x12fff51, 0x12fff90},
						{0x130ff38, 0x130ff7e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff09, 0x10fff09},
						{0x110ff12, 0x110ff12},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dfff7},
						{0x12eff66, 0x12eff53},
						{0x12fff66, 0x12fffe3},
						{0x130ff66, 0x130ffa5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff09, 0x10fff09},
						{0x110ff12, 0x110ff12},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff58},
						{0x12effe1, 0x12effa8},
						{0x12fff7a, 0x12fff35},
						{0x130ff94, 0x130ffcd},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff09, 0x10fff09},
						{0x110ff12, 0x110ff12},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dffb9},
						{0x12eff5c, 0x12efffc},
						{0x12fff8f, 0x12fff87},
						{0x130ffc2, 0x130fff4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff09, 0x10fff09},
						{0x110ff12, 0x110ff12},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff19},
						{0x12effd7, 0x12eff51},
						{0x12fffa3, 0x12fffda},
						{0x130fff0, 0x130ff1b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff09, 0x10fff09},
						{0x110ff12, 0x110ff12},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dff7a},
						{0x12eff51, 0x12effa5},
						{0x12fffb8, 0x12fff2c},
						{0x130ff1e, 0x130ff43},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff09, 0x10fff09},
						{0x110ff12, 0x110ff12},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffdb},
						{0x12effcc, 0x12efff9},
						{0x12fffcc, 0x12fff7e},
						{0x130ff4c, 0x130ff6a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff09, 0x10fff09},
						{0x110ff12, 0x110ff12},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff3b},
						{0x12eff47, 0x12eff4e},
						{0x12fffe1, 0x12fffd1},
						{0x130ff7a, 0x130ff91},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff09, 0x10fff09},
						{0x110ff12, 0x110ff12},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff9c},
						{0x12effc2, 0x12effa2},
						{0x12ffff5, 0x12fff23},
						{0x130ffa8, 0x130ffb9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff36},
						{0x12effe1, 0x12eff86},
						{0x12fff7a, 0x12fff13},
						{0x130ff14, 0x130ffab},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff6f},
						{0x12effa3, 0x12eff5f},
						{0x12fff70, 0x12fff07},
						{0x130ff3d, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffa9},
						{0x12eff66, 0x12eff38},
						{0x12fff66, 0x12ffffb},
						{0x130ff66, 0x130fff0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dffe2},
						{0x12eff28, 0x12eff11},
						{0x12fff5c, 0x12fffef},
						{0x130ff8f, 0x130ff13},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff1c},
						{0x12effeb, 0x12effeb},
						{0x12fff51, 0x12fffe2},
						{0x130ffb8, 0x130ff36},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff55},
						{0x12effae, 0x12effc4},
						{0x12fff47, 0x12fffd6},
						{0x130ffe1, 0x130ff59},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dff8f},
						{0x12eff70, 0x12eff9d},
						{0x12fff3d, 0x12fffca},
						{0x130ff0a, 0x130ff7c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffc8},
						{0x12eff33, 0x12eff76},
						{0x12fff33, 0x12fffbe},
						{0x130ff33, 0x130ff9f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff02},
						{0x12efff5, 0x12eff50},
						{0x12fff28, 0x12fffb2},
						{0x130ff5c, 0x130ffc2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff3b},
						{0x12effb8, 0x12eff29},
						{0x12fff1e, 0x12fffa6},
						{0x130ff85, 0x130ffe5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff75},
						{0x12eff7a, 0x12eff02},
						{0x12fff14, 0x12fff9a},
						{0x130ffae, 0x130ff08},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dffae},
						{0x12eff3d, 0x12effdb},
						{0x12fff0a, 0x12fff8d},
						{0x130ffd7, 0x130ff2b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dffe8},
						{0x12eff00, 0x12effb4},
						{0x12fff00, 0x12fff81},
						{0x130ff00, 0x130ff4e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff21},
						{0x12effc2, 0x12eff8e},
						{0x12ffff5, 0x12fff75},
						{0x130ff28, 0x130ff71},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dff5b},
						{0x12eff85, 0x12eff67},
						{0x12fffeb, 0x12fff69},
						{0x130ff51, 0x130ff94},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff94},
						{0x12eff47, 0x12eff40},
						{0x12fffe1, 0x12fff5d},
						{0x130ff7a, 0x130ffb7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dffce},
						{0x12eff0a, 0x12eff19},
						{0x12fffd7, 0x12fff51},
						{0x130ffa3, 0x130ffda},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff07},
						{0x12effcc, 0x12efff3},
						{0x12fffcc, 0x12fff44},
						{0x130ffcc, 0x130fffd},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dff40},
						{0x12eff8f, 0x12effcc},
						{0x12fffc2, 0x12fff38},
						{0x130fff5, 0x130ff20},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dff7a},
						{0x12eff51, 0x12effa5},
						{0x12fffb8, 0x12fff2c},
						{0x130ff1e, 0x130ff43},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dffb3},
						{0x12eff14, 0x12eff7e},
						{0x12fffae, 0x12fff20},
						{0x130ff47, 0x130ff66},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dffed},
						{0x12effd7, 0x12eff57},
						{0x12fffa3, 0x12fff14},
						{0x130ff70, 0x130ff89},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff26},
						{0x12eff99, 0x12eff31},
						{0x12fff99, 0x12fff08},
						{0x130ff99, 0x130ffac},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dff60},
						{0x12eff5c, 0x12eff0a},
						{0x12fff8f, 0x12ffffc},
						{0x130ffc2, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff99},
						{0x12eff1e, 0x12effe3},
						{0x12fff85, 0x12fffef},
						{0x130ffeb, 0x130fff1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dffd3},
						{0x12effe1, 0x12effbc},
						{0x12fff7a, 0x12fffe3},
						{0x130ff14, 0x130ff14},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff08, 0x10fff08},
						{0x110ff10, 0x110ff10},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff0c},
						{0x12effa3, 0x12eff96},
						{0x12fff70, 0x12fffd7},
						{0x130ff3d, 0x130ff37},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff5d},
						{0x12eff99, 0x12eff01},
						{0x12fff99, 0x12fff72},
						{0x130ff19, 0x130ffaf},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff6f},
						{0x12effa3, 0x12eff5f},
						{0x12fff70, 0x12fff07},
						{0x130ff3d, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff82},
						{0x12effae, 0x12effbd},
						{0x12fff47, 0x12fff9c},
						{0x130ff61, 0x130ffec},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff94},
						{0x12effb8, 0x12eff1b},
						{0x12fff1e, 0x12fff32},
						{0x130ff85, 0x130ff0b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dffa6},
						{0x12effc2, 0x12eff79},
						{0x12ffff5, 0x12fffc7},
						{0x130ffa8, 0x130ff29},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffb9},
						{0x12effcc, 0x12effd7},
						{0x12fffcc, 0x12fff5c},
						{0x130ffcc, 0x130ff48},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dffcb},
						{0x12effd7, 0x12eff35},
						{0x12fffa3, 0x12ffff2},
						{0x130fff0, 0x130ff66},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dffdd},
						{0x12effe1, 0x12eff93},
						{0x12fff7a, 0x12fff87},
						{0x130ff14, 0x130ff85},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dffef},
						{0x12effeb, 0x12efff1},
						{0x12fff51, 0x12fff1c},
						{0x130ff38, 0x130ffa4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff02},
						{0x12efff5, 0x12eff50},
						{0x12fff28, 0x12fffb2},
						{0x130ff5c, 0x130ffc2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff14},
						{0x12eff00, 0x12effae},
						{0x12fff00, 0x12fff47},
						{0x130ff80, 0x130ffe1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dff26},
						{0x12eff0a, 0x12eff0c},
						{0x12fffd7, 0x12fffdd},
						{0x130ffa3, 0x130ffff},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff39},
						{0x12eff14, 0x12eff6a},
						{0x12fffae, 0x12fff72},
						{0x130ffc7, 0x130ff1e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff4b},
						{0x12eff1e, 0x12effc8},
						{0x12fff85, 0x12fff07},
						{0x130ffeb, 0x130ff3d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff5d},
						{0x12eff28, 0x12eff26},
						{0x12fff5c, 0x12fff9d},
						{0x130ff0f, 0x130ff5b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff6f},
						{0x12eff33, 0x12eff84},
						{0x12fff33, 0x12fff32},
						{0x130ff33, 0x130ff7a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dff82},
						{0x12eff3d, 0x12effe2},
						{0x12fff0a, 0x12fffc7},
						{0x130ff57, 0x130ff98},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff94},
						{0x12eff47, 0x12eff40},
						{0x12fffe1, 0x12fff5d},
						{0x130ff7a, 0x130ffb7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dffa6},
						{0x12eff51, 0x12eff9e},
						{0x12fffb8, 0x12ffff2},
						{0x130ff9e, 0x130ffd5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dffb9},
						{0x12eff5c, 0x12efffc},
						{0x12fff8f, 0x12fff87},
						{0x130ffc2, 0x130fff4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffcb},
						{0x12eff66, 0x12eff5a},
						{0x12fff66, 0x12fff1d},
						{0x130ffe6, 0x130ff13},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dffdd},
						{0x12eff70, 0x12effb8},
						{0x12fff3d, 0x12fffb2},
						{0x130ff0a, 0x130ff31},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dfff0},
						{0x12eff7a, 0x12eff16},
						{0x12fff14, 0x12fff48},
						{0x130ff2e, 0x130ff50},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dff02},
						{0x12eff85, 0x12eff75},
						{0x12fffeb, 0x12fffdd},
						{0x130ff51, 0x130ff6e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dff14},
						{0x12eff8f, 0x12effd3},
						{0x12fffc2, 0x12fff72},
						{0x130ff75, 0x130ff8d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff26},
						{0x12eff99, 0x12eff31},
						{0x12fff99, 0x12fff08},
						{0x130ff99, 0x130ffac},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff39},
						{0x12effa3, 0x12eff8f},
						{0x12fff70, 0x12fff9d},
						{0x130ffbd, 0x130ffca},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff4b},
						{0x12effae, 0x12effed},
						{0x12fff47, 0x12fff32},
						{0x130ffe1, 0x130ffe9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff5d},
						{0x12effb8, 0x12eff4b},
						{0x12fff1e, 0x12fffc8},
						{0x130ff05, 0x130ff07},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff70},
						{0x12effc2, 0x12effa9},
						{0x12ffff5, 0x12fff5d},
						{0x130ff28, 0x130ff26},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff82},
						{0x12effcc, 0x12eff07},
						{0x12fffcc, 0x12ffff3},
						{0x130ff4c, 0x130ff44},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff94},
						{0x12effd7, 0x12eff65},
						{0x12fffa3, 0x12fff88},
						{0x130ff70, 0x130ff63},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dffa6},
						{0x12effe1, 0x12effc3},
						{0x12fff7a, 0x12fff1d},
						{0x130ff94, 0x130ff82},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dffb9},
						{0x12effeb, 0x12eff21},
						{0x12fff51, 0x12fffb3},
						{0x130ffb8, 0x130ffa0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff07, 0x10fff07},
						{0x110ff0e, 0x110ff0e},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dffcb},
						{0x12efff5, 0x12eff7f},
						{0x12fff28, 0x12fff48},
						{0x130ffdc, 0x130ffbf},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff99},
						{0x12eff00, 0x12eff99},
						{0x12fff00, 0x12fff99},
						{0x130ff00, 0x130ff99},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dff84},
						{0x12eff51, 0x12eff7c},
						{0x12fffb8, 0x12fffd0},
						{0x130ff1e, 0x130ffb3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff6f},
						{0x12effa3, 0x12eff5f},
						{0x12fff70, 0x12fff07},
						{0x130ff3d, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff5a},
						{0x12efff5, 0x12eff42},
						{0x12fff28, 0x12fff3e},
						{0x130ff5c, 0x130ffe8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff46},
						{0x12eff47, 0x12eff25},
						{0x12fffe1, 0x12fff75},
						{0x130ff7a, 0x130ff02},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff31},
						{0x12eff99, 0x12eff08},
						{0x12fff99, 0x12fffac},
						{0x130ff99, 0x130ff1c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff1c},
						{0x12effeb, 0x12effeb},
						{0x12fff51, 0x12fffe2},
						{0x130ffb8, 0x130ff36},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dff07},
						{0x12eff3d, 0x12effce},
						{0x12fff0a, 0x12fff19},
						{0x130ffd7, 0x130ff51},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dfff2},
						{0x12eff8f, 0x12effb0},
						{0x12fffc2, 0x12fff50},
						{0x130fff5, 0x130ff6b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dffdd},
						{0x12effe1, 0x12eff93},
						{0x12fff7a, 0x12fff87},
						{0x130ff14, 0x130ff85},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffc8},
						{0x12eff33, 0x12eff76},
						{0x12fff33, 0x12fffbe},
						{0x130ff33, 0x130ff9f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dffb3},
						{0x12eff85, 0x12eff59},
						{0x12fffeb, 0x12ffff5},
						{0x130ff51, 0x130ffb9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff9e},
						{0x12effd7, 0x12eff3c},
						{0x12fffa3, 0x12fff2c},
						{0x130ff70, 0x130ffd4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff8a},
						{0x12eff28, 0x12eff1f},
						{0x12fff5c, 0x12fff63},
						{0x130ff8f, 0x130ffee},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff75},
						{0x12eff7a, 0x12eff02},
						{0x12fff14, 0x12fff9a},
						{0x130ffae, 0x130ff08},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff60},
						{0x12effcc, 0x12effe5},
						{0x12fffcc, 0x12fffd0},
						{0x130ffcc, 0x130ff22},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff4b},
						{0x12eff1e, 0x12effc8},
						{0x12fff85, 0x12fff07},
						{0x130ffeb, 0x130ff3d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dff36},
						{0x12eff70, 0x12effab},
						{0x12fff3d, 0x12fff3e},
						{0x130ff0a, 0x130ff57},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff21},
						{0x12effc2, 0x12eff8e},
						{0x12ffff5, 0x12fff75},
						{0x130ff28, 0x130ff71},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff0c},
						{0x12eff14, 0x12eff71},
						{0x12fffae, 0x12fffac},
						{0x130ff47, 0x130ff8b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dfff7},
						{0x12eff66, 0x12eff53},
						{0x12fff66, 0x12fffe3},
						{0x130ff66, 0x130ffa5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dffe2},
						{0x12effb8, 0x12eff36},
						{0x12fff1e, 0x12fff1a},
						{0x130ff85, 0x130ffc0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dffce},
						{0x12eff0a, 0x12eff19},
						{0x12fffd7, 0x12fff51},
						{0x130ffa3, 0x130ffda},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dffb9},
						{0x12eff5c, 0x12efffc},
						{0x12fff8f, 0x12fff87},
						{0x130ffc2, 0x130fff4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dffa4},
						{0x12effae, 0x12effdf},
						{0x12fff47, 0x12fffbe},
						{0x130ffe1, 0x130ff0e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff8f},
						{0x12eff00, 0x12effc2},
						{0x12fff00, 0x12ffff5},
						{0x130ff00, 0x130ff28},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dff7a},
						{0x12eff51, 0x12effa5},
						{0x12fffb8, 0x12fff2c},
						{0x130ff1e, 0x130ff43},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff65},
						{0x12effa3, 0x12eff88},
						{0x12fff70, 0x12fff63},
						{0x130ff3d, 0x130ff5d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff50},
						{0x12efff5, 0x12eff6b},
						{0x12fff28, 0x12fff9a},
						{0x130ff5c, 0x130ff77},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff3b},
						{0x12eff47, 0x12eff4e},
						{0x12fffe1, 0x12fffd1},
						{0x130ff7a, 0x130ff91},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff26},
						{0x12eff99, 0x12eff31},
						{0x12fff99, 0x12fff08},
						{0x130ff99, 0x130ffac},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff12},
						{0x12effeb, 0x12eff14},
						{0x12fff51, 0x12fff3f},
						{0x130ffb8, 0x130ffc6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dfffd},
						{0x12eff3d, 0x12efff6},
						{0x12fff0a, 0x12fff75},
						{0x130ffd7, 0x130ffe0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dffe8},
						{0x12eff8f, 0x12effd9},
						{0x12fffc2, 0x12fffac},
						{0x130fff5, 0x130fffa},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dffd3},
						{0x12effe1, 0x12effbc},
						{0x12fff7a, 0x12fffe3},
						{0x130ff14, 0x130ff14},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffbe},
						{0x12eff33, 0x12eff9f},
						{0x12fff33, 0x12fff1a},
						{0x130ff33, 0x130ff2f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dffa9},
						{0x12eff85, 0x12eff82},
						{0x12fffeb, 0x12fff51},
						{0x130ff51, 0x130ff49},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff94},
						{0x12effd7, 0x12eff65},
						{0x12fffa3, 0x12fff88},
						{0x130ff70, 0x130ff63},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff7f},
						{0x12eff28, 0x12eff48},
						{0x12fff5c, 0x12fffbf},
						{0x130ff8f, 0x130ff7d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff6a},
						{0x12eff7a, 0x12eff2b},
						{0x12fff14, 0x12ffff6},
						{0x130ffae, 0x130ff97},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff56},
						{0x12effcc, 0x12eff0e},
						{0x12fffcc, 0x12fff2d},
						{0x130ffcc, 0x130ffb2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff41},
						{0x12eff1e, 0x12efff1},
						{0x12fff85, 0x12fff63},
						{0x130ffeb, 0x130ffcc},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dff2c},
						{0x12eff70, 0x12effd4},
						{0x12fff3d, 0x12fff9a},
						{0x130ff0a, 0x130ffe6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff17},
						{0x12effc2, 0x12effb7},
						{0x12ffff5, 0x12fffd1},
						{0x130ff28, 0x130ff00},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff02},
						{0x12eff14, 0x12eff9a},
						{0x12fffae, 0x12fff08},
						{0x130ff47, 0x130ff1b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffed},
						{0x12eff66, 0x12eff7c},
						{0x12fff66, 0x12fff3f},
						{0x130ff66, 0x130ff35},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dffd8},
						{0x12effb8, 0x12eff5f},
						{0x12fff1e, 0x12fff76},
						{0x130ff85, 0x130ff4f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dffc3},
						{0x12eff0a, 0x12eff42},
						{0x12fffd7, 0x12fffad},
						{0x130ffa3, 0x130ff69},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dffae},
						{0x12eff5c, 0x12eff25},
						{0x12fff8f, 0x12fffe4},
						{0x130ffc2, 0x130ff83},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff06, 0x10fff06},
						{0x110ff0c, 0x110ff0c},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff9a},
						{0x12effae, 0x12eff08},
						{0x12fff47, 0x12fff1b},
						{0x130ffe1, 0x130ff9e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff99},
						{0x12eff00, 0x12eff99},
						{0x12fff00, 0x12fff99},
						{0x130ff00, 0x130ff99},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff5d},
						{0x12eff99, 0x12eff01},
						{0x12fff99, 0x12fff72},
						{0x130ff19, 0x130ffaf},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff21},
						{0x12eff33, 0x12eff69},
						{0x12fff33, 0x12fff4a},
						{0x130ff33, 0x130ffc5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffe5},
						{0x12effcc, 0x12effd0},
						{0x12fffcc, 0x12fff22},
						{0x130ff4c, 0x130ffdb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffa9},
						{0x12eff66, 0x12eff38},
						{0x12fff66, 0x12ffffb},
						{0x130ff66, 0x130fff0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff6d},
						{0x12eff00, 0x12effa0},
						{0x12fff00, 0x12fffd3},
						{0x130ff80, 0x130ff06},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff31},
						{0x12eff99, 0x12eff08},
						{0x12fff99, 0x12fffac},
						{0x130ff99, 0x130ff1c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dfff5},
						{0x12eff33, 0x12eff6f},
						{0x12fff33, 0x12fff84},
						{0x130ffb3, 0x130ff32},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffb9},
						{0x12effcc, 0x12effd7},
						{0x12fffcc, 0x12fff5c},
						{0x130ffcc, 0x130ff48},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff7c},
						{0x12eff66, 0x12eff3f},
						{0x12fff66, 0x12fff35},
						{0x130ffe6, 0x130ff5e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff40},
						{0x12eff00, 0x12effa7},
						{0x12fff00, 0x12fff0d},
						{0x130ff00, 0x130ff74},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff04},
						{0x12eff99, 0x12eff0f},
						{0x12fff99, 0x12fffe6},
						{0x130ff19, 0x130ff89},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffc8},
						{0x12eff33, 0x12eff76},
						{0x12fff33, 0x12fffbe},
						{0x130ff33, 0x130ff9f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff8c},
						{0x12effcc, 0x12effde},
						{0x12fffcc, 0x12fff96},
						{0x130ff4c, 0x130ffb5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff50},
						{0x12eff66, 0x12eff46},
						{0x12fff66, 0x12fff6f},
						{0x130ff66, 0x130ffcb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff14},
						{0x12eff00, 0x12effae},
						{0x12fff00, 0x12fff47},
						{0x130ff80, 0x130ffe1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffd8},
						{0x12eff99, 0x12eff15},
						{0x12fff99, 0x12fff20},
						{0x130ff99, 0x130fff7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff9c},
						{0x12eff33, 0x12eff7d},
						{0x12fff33, 0x12ffff8},
						{0x130ffb3, 0x130ff0c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff60},
						{0x12effcc, 0x12effe5},
						{0x12fffcc, 0x12fffd0},
						{0x130ffcc, 0x130ff22},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff24},
						{0x12eff66, 0x12eff4d},
						{0x12fff66, 0x12fffa9},
						{0x130ffe6, 0x130ff38},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dffe8},
						{0x12eff00, 0x12effb4},
						{0x12fff00, 0x12fff81},
						{0x130ff00, 0x130ff4e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffac},
						{0x12eff99, 0x12eff1c},
						{0x12fff99, 0x12fff5a},
						{0x130ff19, 0x130ff64},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff6f},
						{0x12eff33, 0x12eff84},
						{0x12fff33, 0x12fff32},
						{0x130ff33, 0x130ff7a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff33},
						{0x12effcc, 0x12effec},
						{0x12fffcc, 0x12fff0a},
						{0x130ff4c, 0x130ff90},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dfff7},
						{0x12eff66, 0x12eff53},
						{0x12fff66, 0x12fffe3},
						{0x130ff66, 0x130ffa5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dffbb},
						{0x12eff00, 0x12effbb},
						{0x12fff00, 0x12fffbb},
						{0x130ff80, 0x130ffbb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff7f},
						{0x12eff99, 0x12eff23},
						{0x12fff99, 0x12fff94},
						{0x130ff99, 0x130ffd1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff43},
						{0x12eff33, 0x12eff8b},
						{0x12fff33, 0x12fff6c},
						{0x130ffb3, 0x130ffe7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff07},
						{0x12effcc, 0x12efff3},
						{0x12fffcc, 0x12fff44},
						{0x130ffcc, 0x130fffd},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffcb},
						{0x12eff66, 0x12eff5a},
						{0x12fff66, 0x12fff1d},
						{0x130ffe6, 0x130ff13},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff8f},
						{0x12eff00, 0x12effc2},
						{0x12fff00, 0x12ffff5},
						{0x130ff00, 0x130ff28},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff53},
						{0x12eff99, 0x12eff2a},
						{0x12fff99, 0x12fffce},
						{0x130ff19, 0x130ff3e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff17},
						{0x12eff33, 0x12eff92},
						{0x12fff33, 0x12fffa6},
						{0x130ff33, 0x130ff54},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffdb},
						{0x12effcc, 0x12efff9},
						{0x12fffcc, 0x12fff7e},
						{0x130ff4c, 0x130ff6a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff9f},
						{0x12eff66, 0x12eff61},
						{0x12fff66, 0x12fff57},
						{0x130ff66, 0x130ff80},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff62},
						{0x12eff00, 0x12effc9},
						{0x12fff00, 0x12fff2f},
						{0x130ff80, 0x130ff96},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff26},
						{0x12eff99, 0x12eff31},
						{0x12fff99, 0x12fff08},
						{0x130ff99, 0x130ffac},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffea},
						{0x12eff33, 0x12eff98},
						{0x12fff33, 0x12fffe0},
						{0x130ffb3, 0x130ffc1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffae},
						{0x12effcc, 0x12eff00},
						{0x12fffcc, 0x12fffb9},
						{0x130ffcc, 0x130ffd7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff72},
						{0x12eff66, 0x12eff68},
						{0x12fff66, 0x12fff91},
						{0x130ffe6, 0x130ffed},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff36},
						{0x12eff00, 0x12effd0},
						{0x12fff00, 0x12fff69},
						{0x130ff00, 0x130ff03},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dfffa},
						{0x12eff99, 0x12eff37},
						{0x12fff99, 0x12fff42},
						{0x130ff19, 0x130ff19},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffbe},
						{0x12eff33, 0x12eff9f},
						{0x12fff33, 0x12fff1a},
						{0x130ff33, 0x130ff2f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff82},
						{0x12effcc, 0x12eff07},
						{0x12fffcc, 0x12ffff3},
						{0x130ff4c, 0x130ff44},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff46},
						{0x12eff66, 0x12eff6f},
						{0x12fff66, 0x12fffcb},
						{0x130ff66, 0x130ff5a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff0a},
						{0x12eff00, 0x12effd7},
						{0x12fff00, 0x12fffa3},
						{0x130ff80, 0x130ff70},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffce},
						{0x12eff99, 0x12eff3e},
						{0x12fff99, 0x12fff7c},
						{0x130ff99, 0x130ff86},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff92},
						{0x12eff33, 0x12effa6},
						{0x12fff33, 0x12fff54},
						{0x130ffb3, 0x130ff9c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff56},
						{0x12effcc, 0x12eff0e},
						{0x12fffcc, 0x12fff2d},
						{0x130ffcc, 0x130ffb2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff19},
						{0x12eff66, 0x12eff76},
						{0x12fff66, 0x12fff05},
						{0x130ffe6, 0x130ffc8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dffdd},
						{0x12eff00, 0x12effdd},
						{0x12fff00, 0x12fffdd},
						{0x130ff00, 0x130ffdd},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffa1},
						{0x12eff99, 0x12eff45},
						{0x12fff99, 0x12fffb6},
						{0x130ff19, 0x130fff3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff65},
						{0x12eff33, 0x12effad},
						{0x12fff33, 0x12fff8e},
						{0x130ff33, 0x130ff09},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff29},
						{0x12effcc, 0x12eff15},
						{0x12fffcc, 0x12fff67},
						{0x130ff4c, 0x130ff1f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffed},
						{0x12eff66, 0x12eff7c},
						{0x12fff66, 0x12fff3f},
						{0x130ff66, 0x130ff35},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dffb1},
						{0x12eff00, 0x12effe4},
						{0x12fff00, 0x12fff17},
						{0x130ff80, 0x130ff4b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff75},
						{0x12eff99, 0x12eff4c},
						{0x12fff99, 0x12ffff0},
						{0x130ff99, 0x130ff60},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff39},
						{0x12eff33, 0x12effb4},
						{0x12fff33, 0x12fffc8},
						{0x130ffb3, 0x130ff76},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dfffd},
						{0x12effcc, 0x12eff1b},
						{0x12fffcc, 0x12fffa1},
						{0x130ffcc, 0x130ff8c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffc1},
						{0x12eff66, 0x12eff83},
						{0x12fff66, 0x12fff79},
						{0x130ffe6, 0x130ffa2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff85},
						{0x12eff00, 0x12effeb},
						{0x12fff00, 0x12fff51},
						{0x130ff00, 0x130ffb8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff49},
						{0x12eff99, 0x12eff53},
						{0x12fff99, 0x12fff2a},
						{0x130ff19, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff0c},
						{0x12eff33, 0x12effbb},
						{0x12fff33, 0x12fff02},
						{0x130ff33, 0x130ffe4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffd0},
						{0x12effcc, 0x12eff22},
						{0x12fffcc, 0x12fffdb},
						{0x130ff4c, 0x130fff9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff94},
						{0x12eff66, 0x12eff8a},
						{0x12fff66, 0x12fffb3},
						{0x130ff66, 0x130ff0f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff58},
						{0x12eff00, 0x12efff2},
						{0x12fff00, 0x12fff8b},
						{0x130ff80, 0x130ff25},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff1c},
						{0x12eff99, 0x12eff5a},
						{0x12fff99, 0x12fff64},
						{0x130ff99, 0x130ff3b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffe0},
						{0x12eff33, 0x12effc1},
						{0x12fff33, 0x12fff3c},
						{0x130ffb3, 0x130ff51},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffa4},
						{0x12effcc, 0x12eff29},
						{0x12fffcc, 0x12fff15},
						{0x130ffcc, 0x130ff67},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff68},
						{0x12eff66, 0x12eff91},
						{0x12fff66, 0x12fffed},
						{0x130ffe6, 0x130ff7c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff2c},
						{0x12eff00, 0x12efff9},
						{0x12fff00, 0x12fffc5},
						{0x130ff00, 0x130ff92},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dfff0},
						{0x12eff99, 0x12eff60},
						{0x12fff99, 0x12fff9e},
						{0x130ff19, 0x130ffa8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffb4},
						{0x12eff33, 0x12effc8},
						{0x12fff33, 0x12fff76},
						{0x130ff33, 0x130ffbe},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff78},
						{0x12effcc, 0x12eff30},
						{0x12fffcc, 0x12fff4f},
						{0x130ff4c, 0x130ffd4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff05, 0x10fff05},
						{0x110ff0a, 0x110ff0a},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff3c},
						{0x12eff66, 0x12eff98},
						{0x12fff66, 0x12fff27},
						{0x130ff66, 0x130ffea},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff99},
						{0x12eff00, 0x12eff99},
						{0x12fff00, 0x12fff99},
						{0x130ff00, 0x130ff99},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff36},
						{0x12effe1, 0x12eff86},
						{0x12fff7a, 0x12fff13},
						{0x130ff14, 0x130ffab},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dffd3},
						{0x12effc2, 0x12eff72},
						{0x12ffff5, 0x12fff8d},
						{0x130ff28, 0x130ffbc},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff6f},
						{0x12effa3, 0x12eff5f},
						{0x12fff70, 0x12fff07},
						{0x130ff3d, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dff0c},
						{0x12eff85, 0x12eff4c},
						{0x12fffeb, 0x12fff81},
						{0x130ff51, 0x130ffdf},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffa9},
						{0x12eff66, 0x12eff38},
						{0x12fff66, 0x12ffffb},
						{0x130ff66, 0x130fff0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff46},
						{0x12eff47, 0x12eff25},
						{0x12fffe1, 0x12fff75},
						{0x130ff7a, 0x130ff02},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dffe2},
						{0x12eff28, 0x12eff11},
						{0x12fff5c, 0x12fffef},
						{0x130ff8f, 0x130ff13},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dff7f},
						{0x12eff0a, 0x12efffe},
						{0x12fffd7, 0x12fff68},
						{0x130ffa3, 0x130ff25},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff1c},
						{0x12effeb, 0x12effeb},
						{0x12fff51, 0x12fffe2},
						{0x130ffb8, 0x130ff36},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffb9},
						{0x12effcc, 0x12effd7},
						{0x12fffcc, 0x12fff5c},
						{0x130ffcc, 0x130ff48},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff55},
						{0x12effae, 0x12effc4},
						{0x12fff47, 0x12fffd6},
						{0x130ffe1, 0x130ff59},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dfff2},
						{0x12eff8f, 0x12effb0},
						{0x12fffc2, 0x12fff50},
						{0x130fff5, 0x130ff6b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dff8f},
						{0x12eff70, 0x12eff9d},
						{0x12fff3d, 0x12fffca},
						{0x130ff0a, 0x130ff7c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dff2b},
						{0x12eff51, 0x12eff8a},
						{0x12fffb8, 0x12fff44},
						{0x130ff1e, 0x130ff8e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffc8},
						{0x12eff33, 0x12eff76},
						{0x12fff33, 0x12fffbe},
						{0x130ff33, 0x130ff9f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff65},
						{0x12eff14, 0x12eff63},
						{0x12fffae, 0x12fff38},
						{0x130ff47, 0x130ffb1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff02},
						{0x12efff5, 0x12eff50},
						{0x12fff28, 0x12fffb2},
						{0x130ff5c, 0x130ffc2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff9e},
						{0x12effd7, 0x12eff3c},
						{0x12fffa3, 0x12fff2c},
						{0x130ff70, 0x130ffd4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff3b},
						{0x12effb8, 0x12eff29},
						{0x12fff1e, 0x12fffa6},
						{0x130ff85, 0x130ffe5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffd8},
						{0x12eff99, 0x12eff15},
						{0x12fff99, 0x12fff20},
						{0x130ff99, 0x130fff7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff75},
						{0x12eff7a, 0x12eff02},
						{0x12fff14, 0x12fff9a},
						{0x130ffae, 0x130ff08},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dff11},
						{0x12eff5c, 0x12effef},
						{0x12fff8f, 0x12fff13},
						{0x130ffc2, 0x130ff1a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dffae},
						{0x12eff3d, 0x12effdb},
						{0x12fff0a, 0x12fff8d},
						{0x130ffd7, 0x130ff2b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff4b},
						{0x12eff1e, 0x12effc8},
						{0x12fff85, 0x12fff07},
						{0x130ffeb, 0x130ff3d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dffe8},
						{0x12eff00, 0x12effb4},
						{0x12fff00, 0x12fff81},
						{0x130ff00, 0x130ff4e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff84},
						{0x12effe1, 0x12effa1},
						{0x12fff7a, 0x12ffffb},
						{0x130ff14, 0x130ff5f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff21},
						{0x12effc2, 0x12eff8e},
						{0x12ffff5, 0x12fff75},
						{0x130ff28, 0x130ff71},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dffbe},
						{0x12effa3, 0x12eff7a},
						{0x12fff70, 0x12fffef},
						{0x130ff3d, 0x130ff82},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dff5b},
						{0x12eff85, 0x12eff67},
						{0x12fffeb, 0x12fff69},
						{0x130ff51, 0x130ff94},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dfff7},
						{0x12eff66, 0x12eff53},
						{0x12fff66, 0x12fffe3},
						{0x130ff66, 0x130ffa5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff94},
						{0x12eff47, 0x12eff40},
						{0x12fffe1, 0x12fff5d},
						{0x130ff7a, 0x130ffb7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff31},
						{0x12eff28, 0x12eff2d},
						{0x12fff5c, 0x12fffd7},
						{0x130ff8f, 0x130ffc8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dffce},
						{0x12eff0a, 0x12eff19},
						{0x12fffd7, 0x12fff51},
						{0x130ffa3, 0x130ffda},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff6a},
						{0x12effeb, 0x12eff06},
						{0x12fff51, 0x12fffcb},
						{0x130ffb8, 0x130ffeb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff07},
						{0x12effcc, 0x12efff3},
						{0x12fffcc, 0x12fff44},
						{0x130ffcc, 0x130fffd},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dffa4},
						{0x12effae, 0x12effdf},
						{0x12fff47, 0x12fffbe},
						{0x130ffe1, 0x130ff0e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dff40},
						{0x12eff8f, 0x12effcc},
						{0x12fffc2, 0x12fff38},
						{0x130fff5, 0x130ff20},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dffdd},
						{0x12eff70, 0x12effb8},
						{0x12fff3d, 0x12fffb2},
						{0x130ff0a, 0x130ff31},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dff7a},
						{0x12eff51, 0x12effa5},
						{0x12fffb8, 0x12fff2c},
						{0x130ff1e, 0x130ff43},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff17},
						{0x12eff33, 0x12eff92},
						{0x12fff33, 0x12fffa6},
						{0x130ff33, 0x130ff54},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dffb3},
						{0x12eff14, 0x12eff7e},
						{0x12fffae, 0x12fff20},
						{0x130ff47, 0x130ff66},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff50},
						{0x12efff5, 0x12eff6b},
						{0x12fff28, 0x12fff9a},
						{0x130ff5c, 0x130ff77},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dffed},
						{0x12effd7, 0x12eff57},
						{0x12fffa3, 0x12fff14},
						{0x130ff70, 0x130ff89},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff8a},
						{0x12effb8, 0x12eff44},
						{0x12fff1e, 0x12fff8e},
						{0x130ff85, 0x130ff9a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff26},
						{0x12eff99, 0x12eff31},
						{0x12fff99, 0x12fff08},
						{0x130ff99, 0x130ffac},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dffc3},
						{0x12eff7a, 0x12eff1d},
						{0x12fff14, 0x12fff82},
						{0x130ffae, 0x130ffbd},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dff60},
						{0x12eff5c, 0x12eff0a},
						{0x12fff8f, 0x12ffffc},
						{0x130ffc2, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dfffd},
						{0x12eff3d, 0x12efff6},
						{0x12fff0a, 0x12fff75},
						{0x130ffd7, 0x130ffe0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff99},
						{0x12eff1e, 0x12effe3},
						{0x12fff85, 0x12fffef},
						{0x130ffeb, 0x130fff1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff36},
						{0x12eff00, 0x12effd0},
						{0x12fff00, 0x12fff69},
						{0x130ff00, 0x130ff03},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dffd3},
						{0x12effe1, 0x12effbc},
						{0x12fff7a, 0x12fffe3},
						{0x130ff14, 0x130ff14},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff70},
						{0x12effc2, 0x12effa9},
						{0x12ffff5, 0x12fff5d},
						{0x130ff28, 0x130ff26},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff0c},
						{0x12effa3, 0x12eff96},
						{0x12fff70, 0x12fffd7},
						{0x130ff3d, 0x130ff37},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dffa9},
						{0x12eff85, 0x12eff82},
						{0x12fffeb, 0x12fff51},
						{0x130ff51, 0x130ff49},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff46},
						{0x12eff66, 0x12eff6f},
						{0x12fff66, 0x12fffcb},
						{0x130ff66, 0x130ff5a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dffe3},
						{0x12eff47, 0x12eff5b},
						{0x12fffe1, 0x12fff45},
						{0x130ff7a, 0x130ff6c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff7f},
						{0x12eff28, 0x12eff48},
						{0x12fff5c, 0x12fffbf},
						{0x130ff8f, 0x130ff7d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dff1c},
						{0x12eff0a, 0x12eff35},
						{0x12fffd7, 0x12fff39},
						{0x130ffa3, 0x130ff8f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dffb9},
						{0x12effeb, 0x12eff21},
						{0x12fff51, 0x12fffb3},
						{0x130ffb8, 0x130ffa0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff56},
						{0x12effcc, 0x12eff0e},
						{0x12fffcc, 0x12fff2d},
						{0x130ffcc, 0x130ffb2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dfff2},
						{0x12effae, 0x12efffa},
						{0x12fff47, 0x12fffa6},
						{0x130ffe1, 0x130ffc3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dff8f},
						{0x12eff8f, 0x12effe7},
						{0x12fffc2, 0x12fff20},
						{0x130fff5, 0x130ffd5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dff2c},
						{0x12eff70, 0x12effd4},
						{0x12fff3d, 0x12fff9a},
						{0x130ff0a, 0x130ffe6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dffc8},
						{0x12eff51, 0x12effc0},
						{0x12fffb8, 0x12fff14},
						{0x130ff1e, 0x130fff8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff65},
						{0x12eff33, 0x12effad},
						{0x12fff33, 0x12fff8e},
						{0x130ff33, 0x130ff09},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff02},
						{0x12eff14, 0x12eff9a},
						{0x12fffae, 0x12fff08},
						{0x130ff47, 0x130ff1b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff9f},
						{0x12efff5, 0x12eff86},
						{0x12fff28, 0x12fff82},
						{0x130ff5c, 0x130ff2c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff3b},
						{0x12effd7, 0x12eff73},
						{0x12fffa3, 0x12ffffc},
						{0x130ff70, 0x130ff3d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dffd8},
						{0x12effb8, 0x12eff5f},
						{0x12fff1e, 0x12fff76},
						{0x130ff85, 0x130ff4f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff75},
						{0x12eff99, 0x12eff4c},
						{0x12fff99, 0x12ffff0},
						{0x130ff99, 0x130ff60},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff12},
						{0x12eff7a, 0x12eff39},
						{0x12fff14, 0x12fff6a},
						{0x130ffae, 0x130ff72},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dffae},
						{0x12eff5c, 0x12eff25},
						{0x12fff8f, 0x12fffe4},
						{0x130ffc2, 0x130ff83},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dff4b},
						{0x12eff3d, 0x12eff12},
						{0x12fff0a, 0x12fff5e},
						{0x130ffd7, 0x130ff95},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dffe8},
						{0x12eff1e, 0x12efffe},
						{0x12fff85, 0x12fffd7},
						{0x130ffeb, 0x130ffa6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff85},
						{0x12eff00, 0x12effeb},
						{0x12fff00, 0x12fff51},
						{0x130ff00, 0x130ffb8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff21},
						{0x12effe1, 0x12effd8},
						{0x12fff7a, 0x12fffcb},
						{0x130ff14, 0x130ffc9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dffbe},
						{0x12effc2, 0x12effc4},
						{0x12ffff5, 0x12fff45},
						{0x130ff28, 0x130ffdb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff5b},
						{0x12effa3, 0x12effb1},
						{0x12fff70, 0x12fffbf},
						{0x130ff3d, 0x130ffec},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dfff8},
						{0x12eff85, 0x12eff9d},
						{0x12fffeb, 0x12fff39},
						{0x130ff51, 0x130fffe},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff94},
						{0x12eff66, 0x12eff8a},
						{0x12fff66, 0x12fffb3},
						{0x130ff66, 0x130ff0f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff31},
						{0x12eff47, 0x12eff77},
						{0x12fffe1, 0x12fff2d},
						{0x130ff7a, 0x130ff21},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dffce},
						{0x12eff28, 0x12eff63},
						{0x12fff5c, 0x12fffa7},
						{0x130ff8f, 0x130ff32},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dff6b},
						{0x12eff0a, 0x12eff50},
						{0x12fffd7, 0x12fff21},
						{0x130ffa3, 0x130ff44},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff07},
						{0x12effeb, 0x12eff3d},
						{0x12fff51, 0x12fff9b},
						{0x130ffb8, 0x130ff55},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffa4},
						{0x12effcc, 0x12eff29},
						{0x12fffcc, 0x12fff15},
						{0x130ffcc, 0x130ff67},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff41},
						{0x12effae, 0x12eff16},
						{0x12fff47, 0x12fff8f},
						{0x130ffe1, 0x130ff78},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dffde},
						{0x12eff8f, 0x12eff02},
						{0x12fffc2, 0x12fff09},
						{0x130fff5, 0x130ff8a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dff7a},
						{0x12eff70, 0x12effef},
						{0x12fff3d, 0x12fff82},
						{0x130ff0a, 0x130ff9b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dff17},
						{0x12eff51, 0x12effdc},
						{0x12fffb8, 0x12ffffc},
						{0x130ff1e, 0x130ffac},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffb4},
						{0x12eff33, 0x12effc8},
						{0x12fff33, 0x12fff76},
						{0x130ff33, 0x130ffbe},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff50},
						{0x12eff14, 0x12effb5},
						{0x12fffae, 0x12ffff0},
						{0x130ff47, 0x130ffcf},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dffed},
						{0x12efff5, 0x12effa1},
						{0x12fff28, 0x12fff6a},
						{0x130ff5c, 0x130ffe1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff8a},
						{0x12effd7, 0x12eff8e},
						{0x12fffa3, 0x12fffe4},
						{0x130ff70, 0x130fff2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff27},
						{0x12effb8, 0x12eff7b},
						{0x12fff1e, 0x12fff5e},
						{0x130ff85, 0x130ff04},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffc3},
						{0x12eff99, 0x12eff67},
						{0x12fff99, 0x12fffd8},
						{0x130ff99, 0x130ff15},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff60},
						{0x12eff7a, 0x12eff54},
						{0x12fff14, 0x12fff52},
						{0x130ffae, 0x130ff27},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dfffd},
						{0x12eff5c, 0x12eff40},
						{0x12fff8f, 0x12fffcc},
						{0x130ffc2, 0x130ff38},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dff9a},
						{0x12eff3d, 0x12eff2d},
						{0x12fff0a, 0x12fff46},
						{0x130ffd7, 0x130ff4a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff36},
						{0x12eff1e, 0x12eff1a},
						{0x12fff85, 0x12fffc0},
						{0x130ffeb, 0x130ff5b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dffd3},
						{0x12eff00, 0x12eff06},
						{0x12fff00, 0x12fff3a},
						{0x130ff00, 0x130ff6d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff70},
						{0x12effe1, 0x12efff3},
						{0x12fff7a, 0x12fffb3},
						{0x130ff14, 0x130ff7e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff0d},
						{0x12effc2, 0x12effe0},
						{0x12ffff5, 0x12fff2d},
						{0x130ff28, 0x130ff90},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dffa9},
						{0x12effa3, 0x12effcc},
						{0x12fff70, 0x12fffa7},
						{0x130ff3d, 0x130ffa1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dff46},
						{0x12eff85, 0x12effb9},
						{0x12fffeb, 0x12fff21},
						{0x130ff51, 0x130ffb3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffe3},
						{0x12eff66, 0x12effa5},
						{0x12fff66, 0x12fff9b},
						{0x130ff66, 0x130ffc4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff80},
						{0x12eff47, 0x12eff92},
						{0x12fffe1, 0x12fff15},
						{0x130ff7a, 0x130ffd6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff1c},
						{0x12eff28, 0x12eff7f},
						{0x12fff5c, 0x12fff8f},
						{0x130ff8f, 0x130ffe7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dffb9},
						{0x12eff0a, 0x12eff6b},
						{0x12fffd7, 0x12fff09},
						{0x130ffa3, 0x130fff9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff56},
						{0x12effeb, 0x12eff58},
						{0x12fff51, 0x12fff83},
						{0x130ffb8, 0x130ff0a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dfff3},
						{0x12effcc, 0x12eff44},
						{0x12fffcc, 0x12ffffd},
						{0x130ffcc, 0x130ff1b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff8f},
						{0x12effae, 0x12eff31},
						{0x12fff47, 0x12fff77},
						{0x130ffe1, 0x130ff2d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dff2c},
						{0x12eff8f, 0x12eff1e},
						{0x12fffc2, 0x12ffff1},
						{0x130fff5, 0x130ff3e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dffc9},
						{0x12eff70, 0x12eff0a},
						{0x12fff3d, 0x12fff6b},
						{0x130ff0a, 0x130ff50},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dff65},
						{0x12eff51, 0x12efff7},
						{0x12fffb8, 0x12fffe4},
						{0x130ff1e, 0x130ff61},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff02},
						{0x12eff33, 0x12effe4},
						{0x12fff33, 0x12fff5e},
						{0x130ff33, 0x130ff73},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff9f},
						{0x12eff14, 0x12effd0},
						{0x12fffae, 0x12fffd8},
						{0x130ff47, 0x130ff84},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff3c},
						{0x12efff5, 0x12effbd},
						{0x12fff28, 0x12fff52},
						{0x130ff5c, 0x130ff96},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dffd8},
						{0x12effd7, 0x12effa9},
						{0x12fffa3, 0x12fffcc},
						{0x130ff70, 0x130ffa7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff75},
						{0x12effb8, 0x12eff96},
						{0x12fff1e, 0x12fff46},
						{0x130ff85, 0x130ffb9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff12},
						{0x12eff99, 0x12eff83},
						{0x12fff99, 0x12fffc0},
						{0x130ff99, 0x130ffca},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dffaf},
						{0x12eff7a, 0x12eff6f},
						{0x12fff14, 0x12fff3a},
						{0x130ffae, 0x130ffdc},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dff4b},
						{0x12eff5c, 0x12eff5c},
						{0x12fff8f, 0x12fffb4},
						{0x130ffc2, 0x130ffed},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dffe8},
						{0x12eff3d, 0x12eff48},
						{0x12fff0a, 0x12fff2e},
						{0x130ffd7, 0x130ffff},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff04, 0x10fff04},
						{0x110ff08, 0x110ff08},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff22},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff85},
						{0x12eff1e, 0x12eff35},
						{0x12fff85, 0x12fffa8},
						{0x130ffeb, 0x130ff10},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff99},
						{0x12eff00, 0x12eff99},
						{0x12fff00, 0x12fff99},
						{0x130ff00, 0x130ff99},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff0f},
						{0x12eff28, 0x12eff0b},
						{0x12fff5c, 0x12fffb5},
						{0x130ff0f, 0x130ffa6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dff84},
						{0x12eff51, 0x12eff7c},
						{0x12fffb8, 0x12fffd0},
						{0x130ff1e, 0x130ffb3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dfffa},
						{0x12eff7a, 0x12effed},
						{0x12fff14, 0x12fffeb},
						{0x130ff2e, 0x130ffc0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff6f},
						{0x12effa3, 0x12eff5f},
						{0x12fff70, 0x12fff07},
						{0x130ff3d, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffe5},
						{0x12effcc, 0x12effd0},
						{0x12fffcc, 0x12fff22},
						{0x130ff4c, 0x130ffdb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff5a},
						{0x12efff5, 0x12eff42},
						{0x12fff28, 0x12fff3e},
						{0x130ff5c, 0x130ffe8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dffd0},
						{0x12eff1e, 0x12effb3},
						{0x12fff85, 0x12fff59},
						{0x130ff6b, 0x130fff5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff46},
						{0x12eff47, 0x12eff25},
						{0x12fffe1, 0x12fff75},
						{0x130ff7a, 0x130ff02},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dffbb},
						{0x12eff70, 0x12eff96},
						{0x12fff3d, 0x12fff90},
						{0x130ff8a, 0x130ff0f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff31},
						{0x12eff99, 0x12eff08},
						{0x12fff99, 0x12fffac},
						{0x130ff99, 0x130ff1c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dffa6},
						{0x12effc2, 0x12eff79},
						{0x12ffff5, 0x12fffc7},
						{0x130ffa8, 0x130ff29},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff1c},
						{0x12effeb, 0x12effeb},
						{0x12fff51, 0x12fffe2},
						{0x130ffb8, 0x130ff36},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff91},
						{0x12eff14, 0x12eff5c},
						{0x12fffae, 0x12ffffe},
						{0x130ffc7, 0x130ff43},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dff07},
						{0x12eff3d, 0x12effce},
						{0x12fff0a, 0x12fff19},
						{0x130ffd7, 0x130ff51},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff7c},
						{0x12eff66, 0x12eff3f},
						{0x12fff66, 0x12fff35},
						{0x130ffe6, 0x130ff5e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dfff2},
						{0x12eff8f, 0x12effb0},
						{0x12fffc2, 0x12fff50},
						{0x130fff5, 0x130ff6b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff68},
						{0x12effb8, 0x12eff22},
						{0x12fff1e, 0x12fff6c},
						{0x130ff05, 0x130ff78},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dffdd},
						{0x12effe1, 0x12eff93},
						{0x12fff7a, 0x12fff87},
						{0x130ff14, 0x130ff85},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dff53},
						{0x12eff0a, 0x12eff05},
						{0x12fffd7, 0x12fffa3},
						{0x130ff23, 0x130ff92},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffc8},
						{0x12eff33, 0x12eff76},
						{0x12fff33, 0x12fffbe},
						{0x130ff33, 0x130ff9f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dff3e},
						{0x12eff5c, 0x12effe8},
						{0x12fff8f, 0x12fffd9},
						{0x130ff42, 0x130ffac},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dffb3},
						{0x12eff85, 0x12eff59},
						{0x12fffeb, 0x12ffff5},
						{0x130ff51, 0x130ffb9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff29},
						{0x12effae, 0x12effcb},
						{0x12fff47, 0x12fff10},
						{0x130ff61, 0x130ffc7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff9e},
						{0x12effd7, 0x12eff3c},
						{0x12fffa3, 0x12fff2c},
						{0x130ff70, 0x130ffd4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff14},
						{0x12eff00, 0x12effae},
						{0x12fff00, 0x12fff47},
						{0x130ff80, 0x130ffe1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff8a},
						{0x12eff28, 0x12eff1f},
						{0x12fff5c, 0x12fff63},
						{0x130ff8f, 0x130ffee},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dffff},
						{0x12eff51, 0x12eff90},
						{0x12fffb8, 0x12fff7e},
						{0x130ff9e, 0x130fffb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff75},
						{0x12eff7a, 0x12eff02},
						{0x12fff14, 0x12fff9a},
						{0x130ffae, 0x130ff08},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dffea},
						{0x12effa3, 0x12eff73},
						{0x12fff70, 0x12fffb5},
						{0x130ffbd, 0x130ff15},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff60},
						{0x12effcc, 0x12effe5},
						{0x12fffcc, 0x12fffd0},
						{0x130ffcc, 0x130ff22},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dffd5},
						{0x12efff5, 0x12eff56},
						{0x12fff28, 0x12fffec},
						{0x130ffdc, 0x130ff2f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff4b},
						{0x12eff1e, 0x12effc8},
						{0x12fff85, 0x12fff07},
						{0x130ffeb, 0x130ff3d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dffc0},
						{0x12eff47, 0x12eff39},
						{0x12fffe1, 0x12fff23},
						{0x130fffa, 0x130ff4a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dff36},
						{0x12eff70, 0x12effab},
						{0x12fff3d, 0x12fff3e},
						{0x130ff0a, 0x130ff57},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffac},
						{0x12eff99, 0x12eff1c},
						{0x12fff99, 0x12fff5a},
						{0x130ff19, 0x130ff64},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff21},
						{0x12effc2, 0x12eff8e},
						{0x12ffff5, 0x12fff75},
						{0x130ff28, 0x130ff71},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff97},
						{0x12effeb, 0x12effff},
						{0x12fff51, 0x12fff90},
						{0x130ff38, 0x130ff7e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff0c},
						{0x12eff14, 0x12eff71},
						{0x12fffae, 0x12fffac},
						{0x130ff47, 0x130ff8b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dff82},
						{0x12eff3d, 0x12effe2},
						{0x12fff0a, 0x12fffc7},
						{0x130ff57, 0x130ff98},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dfff7},
						{0x12eff66, 0x12eff53},
						{0x12fff66, 0x12fffe3},
						{0x130ff66, 0x130ffa5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dff6d},
						{0x12eff8f, 0x12effc5},
						{0x12fffc2, 0x12ffffe},
						{0x130ff75, 0x130ffb2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dffe2},
						{0x12effb8, 0x12eff36},
						{0x12fff1e, 0x12fff1a},
						{0x130ff85, 0x130ffc0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff58},
						{0x12effe1, 0x12effa8},
						{0x12fff7a, 0x12fff35},
						{0x130ff94, 0x130ffcd},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dffce},
						{0x12eff0a, 0x12eff19},
						{0x12fffd7, 0x12fff51},
						{0x130ffa3, 0x130ffda},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff43},
						{0x12eff33, 0x12eff8b},
						{0x12fff33, 0x12fff6c},
						{0x130ffb3, 0x130ffe7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dffb9},
						{0x12eff5c, 0x12efffc},
						{0x12fff8f, 0x12fff87},
						{0x130ffc2, 0x130fff4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dff2e},
						{0x12eff85, 0x12eff6e},
						{0x12fffeb, 0x12fffa3},
						{0x130ffd1, 0x130ff01},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dffa4},
						{0x12effae, 0x12effdf},
						{0x12fff47, 0x12fffbe},
						{0x130ffe1, 0x130ff0e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff19},
						{0x12effd7, 0x12eff51},
						{0x12fffa3, 0x12fffda},
						{0x130fff0, 0x130ff1b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff8f},
						{0x12eff00, 0x12effc2},
						{0x12fff00, 0x12ffff5},
						{0x130ff00, 0x130ff28},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff04},
						{0x12eff28, 0x12eff34},
						{0x12fff5c, 0x12fff11},
						{0x130ff0f, 0x130ff36},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dff7a},
						{0x12eff51, 0x12effa5},
						{0x12fffb8, 0x12fff2c},
						{0x130ff1e, 0x130ff43},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dfff0},
						{0x12eff7a, 0x12eff16},
						{0x12fff14, 0x12fff48},
						{0x130ff2e, 0x130ff50},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff65},
						{0x12effa3, 0x12eff88},
						{0x12fff70, 0x12fff63},
						{0x130ff3d, 0x130ff5d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffdb},
						{0x12effcc, 0x12efff9},
						{0x12fffcc, 0x12fff7e},
						{0x130ff4c, 0x130ff6a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff50},
						{0x12efff5, 0x12eff6b},
						{0x12fff28, 0x12fff9a},
						{0x130ff5c, 0x130ff77},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dffc6},
						{0x12eff1e, 0x12effdc},
						{0x12fff85, 0x12fffb5},
						{0x130ff6b, 0x130ff84},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff3b},
						{0x12eff47, 0x12eff4e},
						{0x12fffe1, 0x12fffd1},
						{0x130ff7a, 0x130ff91},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dffb1},
						{0x12eff70, 0x12effbf},
						{0x12fff3d, 0x12fffec},
						{0x130ff8a, 0x130ff9e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff26},
						{0x12eff99, 0x12eff31},
						{0x12fff99, 0x12fff08},
						{0x130ff99, 0x130ffac},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff9c},
						{0x12effc2, 0x12effa2},
						{0x12ffff5, 0x12fff23},
						{0x130ffa8, 0x130ffb9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff12},
						{0x12effeb, 0x12eff14},
						{0x12fff51, 0x12fff3f},
						{0x130ffb8, 0x130ffc6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff87},
						{0x12eff14, 0x12eff85},
						{0x12fffae, 0x12fff5a},
						{0x130ffc7, 0x130ffd3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dfffd},
						{0x12eff3d, 0x12efff6},
						{0x12fff0a, 0x12fff75},
						{0x130ffd7, 0x130ffe0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff72},
						{0x12eff66, 0x12eff68},
						{0x12fff66, 0x12fff91},
						{0x130ffe6, 0x130ffed},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dffe8},
						{0x12eff8f, 0x12effd9},
						{0x12fffc2, 0x12fffac},
						{0x130fff5, 0x130fffa},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff5d},
						{0x12effb8, 0x12eff4b},
						{0x12fff1e, 0x12fffc8},
						{0x130ff05, 0x130ff07},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dffd3},
						{0x12effe1, 0x12effbc},
						{0x12fff7a, 0x12fffe3},
						{0x130ff14, 0x130ff14},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dff48},
						{0x12eff0a, 0x12eff2e},
						{0x12fffd7, 0x12fffff},
						{0x130ff23, 0x130ff21},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffbe},
						{0x12eff33, 0x12eff9f},
						{0x12fff33, 0x12fff1a},
						{0x130ff33, 0x130ff2f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dff34},
						{0x12eff5c, 0x12eff11},
						{0x12fff8f, 0x12fff36},
						{0x130ff42, 0x130ff3c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dffa9},
						{0x12eff85, 0x12eff82},
						{0x12fffeb, 0x12fff51},
						{0x130ff51, 0x130ff49},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff1f},
						{0x12effae, 0x12efff4},
						{0x12fff47, 0x12fff6c},
						{0x130ff61, 0x130ff56},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff94},
						{0x12effd7, 0x12eff65},
						{0x12fffa3, 0x12fff88},
						{0x130ff70, 0x130ff63},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff0a},
						{0x12eff00, 0x12effd7},
						{0x12fff00, 0x12fffa3},
						{0x130ff80, 0x130ff70},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff7f},
						{0x12eff28, 0x12eff48},
						{0x12fff5c, 0x12fffbf},
						{0x130ff8f, 0x130ff7d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dfff5},
						{0x12eff51, 0x12effb9},
						{0x12fffb8, 0x12fffda},
						{0x130ff9e, 0x130ff8a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff6a},
						{0x12eff7a, 0x12eff2b},
						{0x12fff14, 0x12ffff6},
						{0x130ffae, 0x130ff97},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dffe0},
						{0x12effa3, 0x12eff9c},
						{0x12fff70, 0x12fff11},
						{0x130ffbd, 0x130ffa5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff56},
						{0x12effcc, 0x12eff0e},
						{0x12fffcc, 0x12fff2d},
						{0x130ffcc, 0x130ffb2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dffcb},
						{0x12efff5, 0x12eff7f},
						{0x12fff28, 0x12fff48},
						{0x130ffdc, 0x130ffbf},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff41},
						{0x12eff1e, 0x12efff1},
						{0x12fff85, 0x12fff63},
						{0x130ffeb, 0x130ffcc},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dffb6},
						{0x12eff47, 0x12eff62},
						{0x12fffe1, 0x12fff7f},
						{0x130fffa, 0x130ffd9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dff2c},
						{0x12eff70, 0x12effd4},
						{0x12fff3d, 0x12fff9a},
						{0x130ff0a, 0x130ffe6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffa1},
						{0x12eff99, 0x12eff45},
						{0x12fff99, 0x12fffb6},
						{0x130ff19, 0x130fff3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff17},
						{0x12effc2, 0x12effb7},
						{0x12ffff5, 0x12fffd1},
						{0x130ff28, 0x130ff00},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff8c},
						{0x12effeb, 0x12eff28},
						{0x12fff51, 0x12fffed},
						{0x130ff38, 0x130ff0d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff02},
						{0x12eff14, 0x12eff9a},
						{0x12fffae, 0x12fff08},
						{0x130ff47, 0x130ff1b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dff78},
						{0x12eff3d, 0x12eff0b},
						{0x12fff0a, 0x12fff24},
						{0x130ff57, 0x130ff28},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffed},
						{0x12eff66, 0x12eff7c},
						{0x12fff66, 0x12fff3f},
						{0x130ff66, 0x130ff35},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dff63},
						{0x12eff8f, 0x12effee},
						{0x12fffc2, 0x12fff5a},
						{0x130ff75, 0x130ff42},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dffd8},
						{0x12effb8, 0x12eff5f},
						{0x12fff1e, 0x12fff76},
						{0x130ff85, 0x130ff4f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff4e},
						{0x12effe1, 0x12effd1},
						{0x12fff7a, 0x12fff91},
						{0x130ff94, 0x130ff5c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dffc3},
						{0x12eff0a, 0x12eff42},
						{0x12fffd7, 0x12fffad},
						{0x130ffa3, 0x130ff69},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff39},
						{0x12eff33, 0x12effb4},
						{0x12fff33, 0x12fffc8},
						{0x130ffb3, 0x130ff76},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dffae},
						{0x12eff5c, 0x12eff25},
						{0x12fff8f, 0x12fffe4},
						{0x130ffc2, 0x130ff83},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dff24},
						{0x12eff85, 0x12eff97},
						{0x12fffeb, 0x12fffff},
						{0x130ffd1, 0x130ff90},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff9a},
						{0x12effae, 0x12eff08},
						{0x12fff47, 0x12fff1b},
						{0x130ffe1, 0x130ff9e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff0f},
						{0x12effd7, 0x12eff7a},
						{0x12fffa3, 0x12fff36},
						{0x130fff0, 0x130ffab},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fff03, 0x10fff03},
						{0x110ff06, 0x110ff06},
						{0x111ff30, 0x111ff30},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff85},
						{0x12eff00, 0x12effeb},
						{0x12fff00, 0x12fff51},
						{0x130ff00, 0x130ffb8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff7b},
						{0x12effcc, 0x12effcd},
						{0x12fffcc, 0x12fff85},
						{0x130ff0c, 0x130ffa4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff5d},
						{0x12eff99, 0x12eff01},
						{0x12fff99, 0x12fff72},
						{0x130ff19, 0x130ffaf},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff3f},
						{0x12eff66, 0x12eff35},
						{0x12fff66, 0x12fff5e},
						{0x130ff26, 0x130ffba},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff21},
						{0x12eff33, 0x12eff69},
						{0x12fff33, 0x12fff4a},
						{0x130ff33, 0x130ffc5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff03},
						{0x12eff00, 0x12eff9d},
						{0x12fff00, 0x12fff36},
						{0x130ff40, 0x130ffd0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffe5},
						{0x12effcc, 0x12effd0},
						{0x12fffcc, 0x12fff22},
						{0x130ff4c, 0x130ffdb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffc7},
						{0x12eff99, 0x12eff04},
						{0x12fff99, 0x12fff0f},
						{0x130ff59, 0x130ffe6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffa9},
						{0x12eff66, 0x12eff38},
						{0x12fff66, 0x12ffffb},
						{0x130ff66, 0x130fff0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff8b},
						{0x12eff33, 0x12eff6c},
						{0x12fff33, 0x12fffe7},
						{0x130ff73, 0x130fffb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff6d},
						{0x12eff00, 0x12effa0},
						{0x12fff00, 0x12fffd3},
						{0x130ff80, 0x130ff06},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff4f},
						{0x12effcc, 0x12effd4},
						{0x12fffcc, 0x12fffbf},
						{0x130ff8c, 0x130ff11},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff31},
						{0x12eff99, 0x12eff08},
						{0x12fff99, 0x12fffac},
						{0x130ff99, 0x130ff1c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff13},
						{0x12eff66, 0x12eff3c},
						{0x12fff66, 0x12fff98},
						{0x130ffa6, 0x130ff27},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dfff5},
						{0x12eff33, 0x12eff6f},
						{0x12fff33, 0x12fff84},
						{0x130ffb3, 0x130ff32},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dffd7},
						{0x12eff00, 0x12effa3},
						{0x12fff00, 0x12fff70},
						{0x130ffc0, 0x130ff3d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffb9},
						{0x12effcc, 0x12effd7},
						{0x12fffcc, 0x12fff5c},
						{0x130ffcc, 0x130ff48},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff9a},
						{0x12eff99, 0x12eff0b},
						{0x12fff99, 0x12fff49},
						{0x130ffd9, 0x130ff53},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff7c},
						{0x12eff66, 0x12eff3f},
						{0x12fff66, 0x12fff35},
						{0x130ffe6, 0x130ff5e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff5e},
						{0x12eff33, 0x12eff73},
						{0x12fff33, 0x12fff21},
						{0x130fff3, 0x130ff69},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff40},
						{0x12eff00, 0x12effa7},
						{0x12fff00, 0x12fff0d},
						{0x130ff00, 0x130ff74},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff22},
						{0x12effcc, 0x12effdb},
						{0x12fffcc, 0x12ffff9},
						{0x130ff0c, 0x130ff7e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff04},
						{0x12eff99, 0x12eff0f},
						{0x12fff99, 0x12fffe6},
						{0x130ff19, 0x130ff89},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffe6},
						{0x12eff66, 0x12eff42},
						{0x12fff66, 0x12fffd2},
						{0x130ff26, 0x130ff94},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffc8},
						{0x12eff33, 0x12eff76},
						{0x12fff33, 0x12fffbe},
						{0x130ff33, 0x130ff9f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dffaa},
						{0x12eff00, 0x12effaa},
						{0x12fff00, 0x12fffaa},
						{0x130ff40, 0x130ffaa},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff8c},
						{0x12effcc, 0x12effde},
						{0x12fffcc, 0x12fff96},
						{0x130ff4c, 0x130ffb5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff6e},
						{0x12eff99, 0x12eff12},
						{0x12fff99, 0x12fff83},
						{0x130ff59, 0x130ffc0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff50},
						{0x12eff66, 0x12eff46},
						{0x12fff66, 0x12fff6f},
						{0x130ff66, 0x130ffcb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff32},
						{0x12eff33, 0x12eff7a},
						{0x12fff33, 0x12fff5b},
						{0x130ff73, 0x130ffd6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff14},
						{0x12eff00, 0x12effae},
						{0x12fff00, 0x12fff47},
						{0x130ff80, 0x130ffe1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dfff6},
						{0x12effcc, 0x12effe1},
						{0x12fffcc, 0x12fff33},
						{0x130ff8c, 0x130ffec},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffd8},
						{0x12eff99, 0x12eff15},
						{0x12fff99, 0x12fff20},
						{0x130ff99, 0x130fff7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffba},
						{0x12eff66, 0x12eff49},
						{0x12fff66, 0x12fff0c},
						{0x130ffa6, 0x130ff02},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff9c},
						{0x12eff33, 0x12eff7d},
						{0x12fff33, 0x12ffff8},
						{0x130ffb3, 0x130ff0c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff7e},
						{0x12eff00, 0x12effb1},
						{0x12fff00, 0x12fffe4},
						{0x130ffc0, 0x130ff17},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff60},
						{0x12effcc, 0x12effe5},
						{0x12fffcc, 0x12fffd0},
						{0x130ffcc, 0x130ff22},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff42},
						{0x12eff99, 0x12eff19},
						{0x12fff99, 0x12fffbd},
						{0x130ffd9, 0x130ff2d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff24},
						{0x12eff66, 0x12eff4d},
						{0x12fff66, 0x12fffa9},
						{0x130ffe6, 0x130ff38},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff06},
						{0x12eff33, 0x12eff81},
						{0x12fff33, 0x12fff95},
						{0x130fff3, 0x130ff43},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dffe8},
						{0x12eff00, 0x12effb4},
						{0x12fff00, 0x12fff81},
						{0x130ff00, 0x130ff4e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffca},
						{0x12effcc, 0x12effe8},
						{0x12fffcc, 0x12fff6d},
						{0x130ff0c, 0x130ff59},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffac},
						{0x12eff99, 0x12eff1c},
						{0x12fff99, 0x12fff5a},
						{0x130ff19, 0x130ff64},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff8d},
						{0x12eff66, 0x12eff50},
						{0x12fff66, 0x12fff46},
						{0x130ff26, 0x130ff6f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff6f},
						{0x12eff33, 0x12eff84},
						{0x12fff33, 0x12fff32},
						{0x130ff33, 0x130ff7a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff51},
						{0x12eff00, 0x12effb8},
						{0x12fff00, 0x12fff1e},
						{0x130ff40, 0x130ff85},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff33},
						{0x12effcc, 0x12effec},
						{0x12fffcc, 0x12fff0a},
						{0x130ff4c, 0x130ff90},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff15},
						{0x12eff99, 0x12eff20},
						{0x12fff99, 0x12ffff7},
						{0x130ff59, 0x130ff9a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dfff7},
						{0x12eff66, 0x12eff53},
						{0x12fff66, 0x12fffe3},
						{0x130ff66, 0x130ffa5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffd9},
						{0x12eff33, 0x12eff87},
						{0x12fff33, 0x12fffcf},
						{0x130ff73, 0x130ffb0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dffbb},
						{0x12eff00, 0x12effbb},
						{0x12fff00, 0x12fffbb},
						{0x130ff80, 0x130ffbb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff9d},
						{0x12effcc, 0x12effef},
						{0x12fffcc, 0x12fffa7},
						{0x130ff8c, 0x130ffc6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff7f},
						{0x12eff99, 0x12eff23},
						{0x12fff99, 0x12fff94},
						{0x130ff99, 0x130ffd1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff61},
						{0x12eff66, 0x12eff57},
						{0x12fff66, 0x12fff80},
						{0x130ffa6, 0x130ffdc},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff43},
						{0x12eff33, 0x12eff8b},
						{0x12fff33, 0x12fff6c},
						{0x130ffb3, 0x130ffe7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff25},
						{0x12eff00, 0x12effbf},
						{0x12fff00, 0x12fff58},
						{0x130ffc0, 0x130fff2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff07},
						{0x12effcc, 0x12efff3},
						{0x12fffcc, 0x12fff44},
						{0x130ffcc, 0x130fffd},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffe9},
						{0x12eff99, 0x12eff26},
						{0x12fff99, 0x12fff31},
						{0x130ffd9, 0x130ff08},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffcb},
						{0x12eff66, 0x12eff5a},
						{0x12fff66, 0x12fff1d},
						{0x130ffe6, 0x130ff13},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffad},
						{0x12eff33, 0x12eff8e},
						{0x12fff33, 0x12fff09},
						{0x130fff3, 0x130ff1e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff8f},
						{0x12eff00, 0x12effc2},
						{0x12fff00, 0x12ffff5},
						{0x130ff00, 0x130ff28},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff71},
						{0x12effcc, 0x12efff6},
						{0x12fffcc, 0x12fffe1},
						{0x130ff0c, 0x130ff33},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff53},
						{0x12eff99, 0x12eff2a},
						{0x12fff99, 0x12fffce},
						{0x130ff19, 0x130ff3e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff35},
						{0x12eff66, 0x12eff5e},
						{0x12fff66, 0x12fffba},
						{0x130ff26, 0x130ff49},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff17},
						{0x12eff33, 0x12eff92},
						{0x12fff33, 0x12fffa6},
						{0x130ff33, 0x130ff54},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dfff9},
						{0x12eff00, 0x12effc5},
						{0x12fff00, 0x12fff92},
						{0x130ff40, 0x130ff5f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffdb},
						{0x12effcc, 0x12efff9},
						{0x12fffcc, 0x12fff7e},
						{0x130ff4c, 0x130ff6a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffbd},
						{0x12eff99, 0x12eff2d},
						{0x12fff99, 0x12fff6b},
						{0x130ff59, 0x130ff75},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff9f},
						{0x12eff66, 0x12eff61},
						{0x12fff66, 0x12fff57},
						{0x130ff66, 0x130ff80},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff81},
						{0x12eff33, 0x12eff95},
						{0x12fff33, 0x12fff43},
						{0x130ff73, 0x130ff8b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff62},
						{0x12eff00, 0x12effc9},
						{0x12fff00, 0x12fff2f},
						{0x130ff80, 0x130ff96},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff44},
						{0x12effcc, 0x12efffd},
						{0x12fffcc, 0x12fff1b},
						{0x130ff8c, 0x130ffa1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff26},
						{0x12eff99, 0x12eff31},
						{0x12fff99, 0x12fff08},
						{0x130ff99, 0x130ffac},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff08},
						{0x12eff66, 0x12eff65},
						{0x12fff66, 0x12ffff4},
						{0x130ffa6, 0x130ffb6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffea},
						{0x12eff33, 0x12eff98},
						{0x12fff33, 0x12fffe0},
						{0x130ffb3, 0x130ffc1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dffcc},
						{0x12eff00, 0x12effcc},
						{0x12fff00, 0x12fffcc},
						{0x130ffc0, 0x130ffcc},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffae},
						{0x12effcc, 0x12eff00},
						{0x12fffcc, 0x12fffb9},
						{0x130ffcc, 0x130ffd7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff90},
						{0x12eff99, 0x12eff34},
						{0x12fff99, 0x12fffa5},
						{0x130ffd9, 0x130ffe2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff72},
						{0x12eff66, 0x12eff68},
						{0x12fff66, 0x12fff91},
						{0x130ffe6, 0x130ffed},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff54},
						{0x12eff33, 0x12eff9c},
						{0x12fff33, 0x12fff7d},
						{0x130fff3, 0x130fff8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff36},
						{0x12eff00, 0x12effd0},
						{0x12fff00, 0x12fff69},
						{0x130ff00, 0x130ff03},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff18},
						{0x12effcc, 0x12eff04},
						{0x12fffcc, 0x12fff56},
						{0x130ff0c, 0x130ff0e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dfffa},
						{0x12eff99, 0x12eff37},
						{0x12fff99, 0x12fff42},
						{0x130ff19, 0x130ff19},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffdc},
						{0x12eff66, 0x12eff6b},
						{0x12fff66, 0x12fff2e},
						{0x130ff26, 0x130ff24},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffbe},
						{0x12eff33, 0x12eff9f},
						{0x12fff33, 0x12fff1a},
						{0x130ff33, 0x130ff2f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dffa0},
						{0x12eff00, 0x12effd3},
						{0x12fff00, 0x12fff06},
						{0x130ff40, 0x130ff3a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff82},
						{0x12effcc, 0x12eff07},
						{0x12fffcc, 0x12ffff3},
						{0x130ff4c, 0x130ff44},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff64},
						{0x12eff99, 0x12eff3b},
						{0x12fff99, 0x12fffdf},
						{0x130ff59, 0x130ff4f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff46},
						{0x12eff66, 0x12eff6f},
						{0x12fff66, 0x12fffcb},
						{0x130ff66, 0x130ff5a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff28},
						{0x12eff33, 0x12effa3},
						{0x12fff33, 0x12fffb7},
						{0x130ff73, 0x130ff65},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff0a},
						{0x12eff00, 0x12effd7},
						{0x12fff00, 0x12fffa3},
						{0x130ff80, 0x130ff70},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffec},
						{0x12effcc, 0x12eff0a},
						{0x12fffcc, 0x12fff90},
						{0x130ff8c, 0x130ff7b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffce},
						{0x12eff99, 0x12eff3e},
						{0x12fff99, 0x12fff7c},
						{0x130ff99, 0x130ff86},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffb0},
						{0x12eff66, 0x12eff72},
						{0x12fff66, 0x12fff68},
						{0x130ffa6, 0x130ff91},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff92},
						{0x12eff33, 0x12effa6},
						{0x12fff33, 0x12fff54},
						{0x130ffb3, 0x130ff9c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff74},
						{0x12eff00, 0x12effda},
						{0x12fff00, 0x12fff40},
						{0x130ffc0, 0x130ffa7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff56},
						{0x12effcc, 0x12eff0e},
						{0x12fffcc, 0x12fff2d},
						{0x130ffcc, 0x130ffb2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff37},
						{0x12eff99, 0x12eff42},
						{0x12fff99, 0x12fff19},
						{0x130ffd9, 0x130ffbd},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff19},
						{0x12eff66, 0x12eff76},
						{0x12fff66, 0x12fff05},
						{0x130ffe6, 0x130ffc8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dfffb},
						{0x12eff33, 0x12effa9},
						{0x12fff33, 0x12ffff1},
						{0x130fff3, 0x130ffd2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dffdd},
						{0x12eff00, 0x12effdd},
						{0x12fff00, 0x12fffdd},
						{0x130ff00, 0x130ffdd},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffbf},
						{0x12effcc, 0x12eff11},
						{0x12fffcc, 0x12fffca},
						{0x130ff0c, 0x130ffe8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffa1},
						{0x12eff99, 0x12eff45},
						{0x12fff99, 0x12fffb6},
						{0x130ff19, 0x130fff3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff83},
						{0x12eff66, 0x12eff79},
						{0x12fff66, 0x12fffa2},
						{0x130ff26, 0x130fffe},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff65},
						{0x12eff33, 0x12effad},
						{0x12fff33, 0x12fff8e},
						{0x130ff33, 0x130ff09},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff47},
						{0x12eff00, 0x12effe1},
						{0x12fff00, 0x12fff7a},
						{0x130ff40, 0x130ff14},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff29},
						{0x12effcc, 0x12eff15},
						{0x12fffcc, 0x12fff67},
						{0x130ff4c, 0x130ff1f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff0b},
						{0x12eff99, 0x12eff49},
						{0x12fff99, 0x12fff53},
						{0x130ff59, 0x130ff2a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffed},
						{0x12eff66, 0x12eff7c},
						{0x12fff66, 0x12fff3f},
						{0x130ff66, 0x130ff35},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffcf},
						{0x12eff33, 0x12effb0},
						{0x12fff33, 0x12fff2b},
						{0x130ff73, 0x130ff40},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dffb1},
						{0x12eff00, 0x12effe4},
						{0x12fff00, 0x12fff17},
						{0x130ff80, 0x130ff4b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff93},
						{0x12effcc, 0x12eff18},
						{0x12fffcc, 0x12fff04},
						{0x130ff8c, 0x130ff56},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff75},
						{0x12eff99, 0x12eff4c},
						{0x12fff99, 0x12ffff0},
						{0x130ff99, 0x130ff60},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff57},
						{0x12eff66, 0x12eff80},
						{0x12fff66, 0x12fffdc},
						{0x130ffa6, 0x130ff6b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff39},
						{0x12eff33, 0x12effb4},
						{0x12fff33, 0x12fffc8},
						{0x130ffb3, 0x130ff76},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff1b},
						{0x12eff00, 0x12effe8},
						{0x12fff00, 0x12fffb4},
						{0x130ffc0, 0x130ff81},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dfffd},
						{0x12effcc, 0x12eff1b},
						{0x12fffcc, 0x12fffa1},
						{0x130ffcc, 0x130ff8c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffdf},
						{0x12eff99, 0x12eff4f},
						{0x12fff99, 0x12fff8d},
						{0x130ffd9, 0x130ff97},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffc1},
						{0x12eff66, 0x12eff83},
						{0x12fff66, 0x12fff79},
						{0x130ffe6, 0x130ffa2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffa3},
						{0x12eff33, 0x12effb7},
						{0x12fff33, 0x12fff65},
						{0x130fff3, 0x130ffad},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff85},
						{0x12eff00, 0x12effeb},
						{0x12fff00, 0x12fff51},
						{0x130ff00, 0x130ffb8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff67},
						{0x12effcc, 0x12eff1f},
						{0x12fffcc, 0x12fff3e},
						{0x130ff0c, 0x130ffc3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff49},
						{0x12eff99, 0x12eff53},
						{0x12fff99, 0x12fff2a},
						{0x130ff19, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff2b},
						{0x12eff66, 0x12eff87},
						{0x12fff66, 0x12fff16},
						{0x130ff26, 0x130ffd9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff0c},
						{0x12eff33, 0x12effbb},
						{0x12fff33, 0x12fff02},
						{0x130ff33, 0x130ffe4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dffee},
						{0x12eff00, 0x12effee},
						{0x12fff00, 0x12fffee},
						{0x130ff40, 0x130ffee},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffd0},
						{0x12effcc, 0x12eff22},
						{0x12fffcc, 0x12fffdb},
						{0x130ff4c, 0x130fff9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffb2},
						{0x12eff99, 0x12eff56},
						{0x12fff99, 0x12fffc7},
						{0x130ff59, 0x130ff04},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff94},
						{0x12eff66, 0x12eff8a},
						{0x12fff66, 0x12fffb3},
						{0x130ff66, 0x130ff0f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff76},
						{0x12eff33, 0x12effbe},
						{0x12fff33, 0x12fff9f},
						{0x130ff73, 0x130ff1a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff58},
						{0x12eff00, 0x12efff2},
						{0x12fff00, 0x12fff8b},
						{0x130ff80, 0x130ff25},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff3a},
						{0x12effcc, 0x12eff26},
						{0x12fffcc, 0x12fff78},
						{0x130ff8c, 0x130ff30},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff1c},
						{0x12eff99, 0x12eff5a},
						{0x12fff99, 0x12fff64},
						{0x130ff99, 0x130ff3b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dfffe},
						{0x12eff66, 0x12eff8d},
						{0x12fff66, 0x12fff50},
						{0x130ffa6, 0x130ff46},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffe0},
						{0x12eff33, 0x12effc1},
						{0x12fff33, 0x12fff3c},
						{0x130ffb3, 0x130ff51},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dffc2},
						{0x12eff00, 0x12efff5},
						{0x12fff00, 0x12fff28},
						{0x130ffc0, 0x130ff5c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffa4},
						{0x12effcc, 0x12eff29},
						{0x12fffcc, 0x12fff15},
						{0x130ffcc, 0x130ff67},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff86},
						{0x12eff99, 0x12eff5d},
						{0x12fff99, 0x12fff01},
						{0x130ffd9, 0x130ff72},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff68},
						{0x12eff66, 0x12eff91},
						{0x12fff66, 0x12fffed},
						{0x130ffe6, 0x130ff7c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff4a},
						{0x12eff33, 0x12effc5},
						{0x12fff33, 0x12fffd9},
						{0x130fff3, 0x130ff87},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff2c},
						{0x12eff00, 0x12efff9},
						{0x12fff00, 0x12fffc5},
						{0x130ff00, 0x130ff92},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff0e},
						{0x12effcc, 0x12eff2d},
						{0x12fffcc, 0x12fffb2},
						{0x130ff0c, 0x130ff9d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dfff0},
						{0x12eff99, 0x12eff60},
						{0x12fff99, 0x12fff9e},
						{0x130ff19, 0x130ffa8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffd2},
						{0x12eff66, 0x12eff94},
						{0x12fff66, 0x12fff8a},
						{0x130ff26, 0x130ffb3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffb4},
						{0x12eff33, 0x12effc8},
						{0x12fff33, 0x12fff76},
						{0x130ff33, 0x130ffbe},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff96},
						{0x12eff00, 0x12efffc},
						{0x12fff00, 0x12fff62},
						{0x130ff40, 0x130ffc9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff78},
						{0x12effcc, 0x12eff30},
						{0x12fffcc, 0x12fff4f},
						{0x130ff4c, 0x130ffd4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff5a},
						{0x12eff99, 0x12eff64},
						{0x12fff99, 0x12fff3b},
						{0x130ff59, 0x130ffdf},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff3c},
						{0x12eff66, 0x12eff98},
						{0x12fff66, 0x12fff27},
						{0x130ff66, 0x130ffea},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff05, 0x110ff05},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff1e},
						{0x12eff33, 0x12effcc},
						{0x12fff33, 0x12fff13},
						{0x130ff73, 0x130fff5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff99},
						{0x12eff00, 0x12eff99},
						{0x12fff00, 0x12fff99},
						{0x130ff00, 0x130ff99},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dffe7},
						{0x12eff70, 0x12eff8f},
						{0x12fff3d, 0x12fff56},
						{0x130ff0a, 0x130ffa2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff36},
						{0x12effe1, 0x12eff86},
						{0x12fff7a, 0x12fff13},
						{0x130ff14, 0x130ffab},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dff84},
						{0x12eff51, 0x12eff7c},
						{0x12fffb8, 0x12fffd0},
						{0x130ff1e, 0x130ffb3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dffd3},
						{0x12effc2, 0x12eff72},
						{0x12ffff5, 0x12fff8d},
						{0x130ff28, 0x130ffbc},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff21},
						{0x12eff33, 0x12eff69},
						{0x12fff33, 0x12fff4a},
						{0x130ff33, 0x130ffc5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff6f},
						{0x12effa3, 0x12eff5f},
						{0x12fff70, 0x12fff07},
						{0x130ff3d, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dffbe},
						{0x12eff14, 0x12eff55},
						{0x12fffae, 0x12fffc4},
						{0x130ff47, 0x130ffd6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dff0c},
						{0x12eff85, 0x12eff4c},
						{0x12fffeb, 0x12fff81},
						{0x130ff51, 0x130ffdf},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff5a},
						{0x12efff5, 0x12eff42},
						{0x12fff28, 0x12fff3e},
						{0x130ff5c, 0x130ffe8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffa9},
						{0x12eff66, 0x12eff38},
						{0x12fff66, 0x12ffffb},
						{0x130ff66, 0x130fff0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dfff7},
						{0x12effd7, 0x12eff2e},
						{0x12fffa3, 0x12fffb8},
						{0x130ff70, 0x130fff9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff46},
						{0x12eff47, 0x12eff25},
						{0x12fffe1, 0x12fff75},
						{0x130ff7a, 0x130ff02},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff94},
						{0x12effb8, 0x12eff1b},
						{0x12fff1e, 0x12fff32},
						{0x130ff85, 0x130ff0b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dffe2},
						{0x12eff28, 0x12eff11},
						{0x12fff5c, 0x12fffef},
						{0x130ff8f, 0x130ff13},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff31},
						{0x12eff99, 0x12eff08},
						{0x12fff99, 0x12fffac},
						{0x130ff99, 0x130ff1c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dff7f},
						{0x12eff0a, 0x12efffe},
						{0x12fffd7, 0x12fff68},
						{0x130ffa3, 0x130ff25},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dffcd},
						{0x12eff7a, 0x12efff4},
						{0x12fff14, 0x12fff25},
						{0x130ffae, 0x130ff2e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff1c},
						{0x12effeb, 0x12effeb},
						{0x12fff51, 0x12fffe2},
						{0x130ffb8, 0x130ff36},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dff6a},
						{0x12eff5c, 0x12effe1},
						{0x12fff8f, 0x12fff9f},
						{0x130ffc2, 0x130ff3f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffb9},
						{0x12effcc, 0x12effd7},
						{0x12fffcc, 0x12fff5c},
						{0x130ffcc, 0x130ff48},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dff07},
						{0x12eff3d, 0x12effce},
						{0x12fff0a, 0x12fff19},
						{0x130ffd7, 0x130ff51},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff55},
						{0x12effae, 0x12effc4},
						{0x12fff47, 0x12fffd6},
						{0x130ffe1, 0x130ff59},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dffa4},
						{0x12eff1e, 0x12effba},
						{0x12fff85, 0x12fff93},
						{0x130ffeb, 0x130ff62},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dfff2},
						{0x12eff8f, 0x12effb0},
						{0x12fffc2, 0x12fff50},
						{0x130fff5, 0x130ff6b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff40},
						{0x12eff00, 0x12effa7},
						{0x12fff00, 0x12fff0d},
						{0x130ff00, 0x130ff74},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dff8f},
						{0x12eff70, 0x12eff9d},
						{0x12fff3d, 0x12fffca},
						{0x130ff0a, 0x130ff7c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dffdd},
						{0x12effe1, 0x12eff93},
						{0x12fff7a, 0x12fff87},
						{0x130ff14, 0x130ff85},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dff2b},
						{0x12eff51, 0x12eff8a},
						{0x12fffb8, 0x12fff44},
						{0x130ff1e, 0x130ff8e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff7a},
						{0x12effc2, 0x12eff80},
						{0x12ffff5, 0x12fff01},
						{0x130ff28, 0x130ff97},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffc8},
						{0x12eff33, 0x12eff76},
						{0x12fff33, 0x12fffbe},
						{0x130ff33, 0x130ff9f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff17},
						{0x12effa3, 0x12eff6d},
						{0x12fff70, 0x12fff7b},
						{0x130ff3d, 0x130ffa8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff65},
						{0x12eff14, 0x12eff63},
						{0x12fffae, 0x12fff38},
						{0x130ff47, 0x130ffb1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dffb3},
						{0x12eff85, 0x12eff59},
						{0x12fffeb, 0x12ffff5},
						{0x130ff51, 0x130ffb9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff02},
						{0x12efff5, 0x12eff50},
						{0x12fff28, 0x12fffb2},
						{0x130ff5c, 0x130ffc2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff50},
						{0x12eff66, 0x12eff46},
						{0x12fff66, 0x12fff6f},
						{0x130ff66, 0x130ffcb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff9e},
						{0x12effd7, 0x12eff3c},
						{0x12fffa3, 0x12fff2c},
						{0x130ff70, 0x130ffd4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dffed},
						{0x12eff47, 0x12eff32},
						{0x12fffe1, 0x12fffe9},
						{0x130ff7a, 0x130ffdc},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff3b},
						{0x12effb8, 0x12eff29},
						{0x12fff1e, 0x12fffa6},
						{0x130ff85, 0x130ffe5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff8a},
						{0x12eff28, 0x12eff1f},
						{0x12fff5c, 0x12fff63},
						{0x130ff8f, 0x130ffee},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffd8},
						{0x12eff99, 0x12eff15},
						{0x12fff99, 0x12fff20},
						{0x130ff99, 0x130fff7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dff26},
						{0x12eff0a, 0x12eff0c},
						{0x12fffd7, 0x12fffdd},
						{0x130ffa3, 0x130ffff},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff75},
						{0x12eff7a, 0x12eff02},
						{0x12fff14, 0x12fff9a},
						{0x130ffae, 0x130ff08},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dffc3},
						{0x12effeb, 0x12efff8},
						{0x12fff51, 0x12fff56},
						{0x130ffb8, 0x130ff11},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dff11},
						{0x12eff5c, 0x12effef},
						{0x12fff8f, 0x12fff13},
						{0x130ffc2, 0x130ff1a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff60},
						{0x12effcc, 0x12effe5},
						{0x12fffcc, 0x12fffd0},
						{0x130ffcc, 0x130ff22},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dffae},
						{0x12eff3d, 0x12effdb},
						{0x12fff0a, 0x12fff8d},
						{0x130ffd7, 0x130ff2b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dfffc},
						{0x12effae, 0x12effd1},
						{0x12fff47, 0x12fff4a},
						{0x130ffe1, 0x130ff34},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff4b},
						{0x12eff1e, 0x12effc8},
						{0x12fff85, 0x12fff07},
						{0x130ffeb, 0x130ff3d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dff99},
						{0x12eff8f, 0x12effbe},
						{0x12fffc2, 0x12fffc4},
						{0x130fff5, 0x130ff45},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dffe8},
						{0x12eff00, 0x12effb4},
						{0x12fff00, 0x12fff81},
						{0x130ff00, 0x130ff4e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dff36},
						{0x12eff70, 0x12effab},
						{0x12fff3d, 0x12fff3e},
						{0x130ff0a, 0x130ff57},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff84},
						{0x12effe1, 0x12effa1},
						{0x12fff7a, 0x12ffffb},
						{0x130ff14, 0x130ff5f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dffd3},
						{0x12eff51, 0x12eff97},
						{0x12fffb8, 0x12fffb8},
						{0x130ff1e, 0x130ff68},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff21},
						{0x12effc2, 0x12eff8e},
						{0x12ffff5, 0x12fff75},
						{0x130ff28, 0x130ff71},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff6f},
						{0x12eff33, 0x12eff84},
						{0x12fff33, 0x12fff32},
						{0x130ff33, 0x130ff7a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dffbe},
						{0x12effa3, 0x12eff7a},
						{0x12fff70, 0x12fffef},
						{0x130ff3d, 0x130ff82},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff0c},
						{0x12eff14, 0x12eff71},
						{0x12fffae, 0x12fffac},
						{0x130ff47, 0x130ff8b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dff5b},
						{0x12eff85, 0x12eff67},
						{0x12fffeb, 0x12fff69},
						{0x130ff51, 0x130ff94},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dffa9},
						{0x12efff5, 0x12eff5d},
						{0x12fff28, 0x12fff26},
						{0x130ff5c, 0x130ff9d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dfff7},
						{0x12eff66, 0x12eff53},
						{0x12fff66, 0x12fffe3},
						{0x130ff66, 0x130ffa5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff46},
						{0x12effd7, 0x12eff4a},
						{0x12fffa3, 0x12fffa0},
						{0x130ff70, 0x130ffae},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff94},
						{0x12eff47, 0x12eff40},
						{0x12fffe1, 0x12fff5d},
						{0x130ff7a, 0x130ffb7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dffe2},
						{0x12effb8, 0x12eff36},
						{0x12fff1e, 0x12fff1a},
						{0x130ff85, 0x130ffc0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff31},
						{0x12eff28, 0x12eff2d},
						{0x12fff5c, 0x12fffd7},
						{0x130ff8f, 0x130ffc8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff7f},
						{0x12eff99, 0x12eff23},
						{0x12fff99, 0x12fff94},
						{0x130ff99, 0x130ffd1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dffce},
						{0x12eff0a, 0x12eff19},
						{0x12fffd7, 0x12fff51},
						{0x130ffa3, 0x130ffda},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff1c},
						{0x12eff7a, 0x12eff10},
						{0x12fff14, 0x12fff0e},
						{0x130ffae, 0x130ffe3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff6a},
						{0x12effeb, 0x12eff06},
						{0x12fff51, 0x12fffcb},
						{0x130ffb8, 0x130ffeb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dffb9},
						{0x12eff5c, 0x12efffc},
						{0x12fff8f, 0x12fff87},
						{0x130ffc2, 0x130fff4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff07},
						{0x12effcc, 0x12efff3},
						{0x12fffcc, 0x12fff44},
						{0x130ffcc, 0x130fffd},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dff55},
						{0x12eff3d, 0x12effe9},
						{0x12fff0a, 0x12fff01},
						{0x130ffd7, 0x130ff06},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dffa4},
						{0x12effae, 0x12effdf},
						{0x12fff47, 0x12fffbe},
						{0x130ffe1, 0x130ff0e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dfff2},
						{0x12eff1e, 0x12effd5},
						{0x12fff85, 0x12fff7b},
						{0x130ffeb, 0x130ff17},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dff40},
						{0x12eff8f, 0x12effcc},
						{0x12fffc2, 0x12fff38},
						{0x130fff5, 0x130ff20},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff8f},
						{0x12eff00, 0x12effc2},
						{0x12fff00, 0x12ffff5},
						{0x130ff00, 0x130ff28},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dffdd},
						{0x12eff70, 0x12effb8},
						{0x12fff3d, 0x12fffb2},
						{0x130ff0a, 0x130ff31},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff2c},
						{0x12effe1, 0x12effaf},
						{0x12fff7a, 0x12fff6f},
						{0x130ff14, 0x130ff3a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dff7a},
						{0x12eff51, 0x12effa5},
						{0x12fffb8, 0x12fff2c},
						{0x130ff1e, 0x130ff43},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dffc8},
						{0x12effc2, 0x12eff9b},
						{0x12ffff5, 0x12fffe9},
						{0x130ff28, 0x130ff4b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff17},
						{0x12eff33, 0x12eff92},
						{0x12fff33, 0x12fffa6},
						{0x130ff33, 0x130ff54},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff65},
						{0x12effa3, 0x12eff88},
						{0x12fff70, 0x12fff63},
						{0x130ff3d, 0x130ff5d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dffb3},
						{0x12eff14, 0x12eff7e},
						{0x12fffae, 0x12fff20},
						{0x130ff47, 0x130ff66},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dff02},
						{0x12eff85, 0x12eff75},
						{0x12fffeb, 0x12fffdd},
						{0x130ff51, 0x130ff6e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff50},
						{0x12efff5, 0x12eff6b},
						{0x12fff28, 0x12fff9a},
						{0x130ff5c, 0x130ff77},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff9f},
						{0x12eff66, 0x12eff61},
						{0x12fff66, 0x12fff57},
						{0x130ff66, 0x130ff80},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dffed},
						{0x12effd7, 0x12eff57},
						{0x12fffa3, 0x12fff14},
						{0x130ff70, 0x130ff89},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff3b},
						{0x12eff47, 0x12eff4e},
						{0x12fffe1, 0x12fffd1},
						{0x130ff7a, 0x130ff91},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff8a},
						{0x12effb8, 0x12eff44},
						{0x12fff1e, 0x12fff8e},
						{0x130ff85, 0x130ff9a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dffd8},
						{0x12eff28, 0x12eff3a},
						{0x12fff5c, 0x12fff4b},
						{0x130ff8f, 0x130ffa3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff26},
						{0x12eff99, 0x12eff31},
						{0x12fff99, 0x12fff08},
						{0x130ff99, 0x130ffac},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dff75},
						{0x12eff0a, 0x12eff27},
						{0x12fffd7, 0x12fffc5},
						{0x130ffa3, 0x130ffb4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dffc3},
						{0x12eff7a, 0x12eff1d},
						{0x12fff14, 0x12fff82},
						{0x130ffae, 0x130ffbd},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff12},
						{0x12effeb, 0x12eff14},
						{0x12fff51, 0x12fff3f},
						{0x130ffb8, 0x130ffc6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dff60},
						{0x12eff5c, 0x12eff0a},
						{0x12fff8f, 0x12ffffc},
						{0x130ffc2, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffae},
						{0x12effcc, 0x12eff00},
						{0x12fffcc, 0x12fffb9},
						{0x130ffcc, 0x130ffd7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dfffd},
						{0x12eff3d, 0x12efff6},
						{0x12fff0a, 0x12fff75},
						{0x130ffd7, 0x130ffe0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff4b},
						{0x12effae, 0x12effed},
						{0x12fff47, 0x12fff32},
						{0x130ffe1, 0x130ffe9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff99},
						{0x12eff1e, 0x12effe3},
						{0x12fff85, 0x12fffef},
						{0x130ffeb, 0x130fff1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dffe8},
						{0x12eff8f, 0x12effd9},
						{0x12fffc2, 0x12fffac},
						{0x130fff5, 0x130fffa},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff36},
						{0x12eff00, 0x12effd0},
						{0x12fff00, 0x12fff69},
						{0x130ff00, 0x130ff03},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dff84},
						{0x12eff70, 0x12effc6},
						{0x12fff3d, 0x12fff26},
						{0x130ff0a, 0x130ff0c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dffd3},
						{0x12effe1, 0x12effbc},
						{0x12fff7a, 0x12fffe3},
						{0x130ff14, 0x130ff14},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dff21},
						{0x12eff51, 0x12effb3},
						{0x12fffb8, 0x12fffa0},
						{0x130ff1e, 0x130ff1d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff70},
						{0x12effc2, 0x12effa9},
						{0x12ffff5, 0x12fff5d},
						{0x130ff28, 0x130ff26},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffbe},
						{0x12eff33, 0x12eff9f},
						{0x12fff33, 0x12fff1a},
						{0x130ff33, 0x130ff2f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff0c},
						{0x12effa3, 0x12eff96},
						{0x12fff70, 0x12fffd7},
						{0x130ff3d, 0x130ff37},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff5b},
						{0x12eff14, 0x12eff8c},
						{0x12fffae, 0x12fff94},
						{0x130ff47, 0x130ff40},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dffa9},
						{0x12eff85, 0x12eff82},
						{0x12fffeb, 0x12fff51},
						{0x130ff51, 0x130ff49},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dfff7},
						{0x12efff5, 0x12eff78},
						{0x12fff28, 0x12fff0e},
						{0x130ff5c, 0x130ff52},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff46},
						{0x12eff66, 0x12eff6f},
						{0x12fff66, 0x12fffcb},
						{0x130ff66, 0x130ff5a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff94},
						{0x12effd7, 0x12eff65},
						{0x12fffa3, 0x12fff88},
						{0x130ff70, 0x130ff63},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dffe3},
						{0x12eff47, 0x12eff5b},
						{0x12fffe1, 0x12fff45},
						{0x130ff7a, 0x130ff6c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff31},
						{0x12effb8, 0x12eff52},
						{0x12fff1e, 0x12fff02},
						{0x130ff85, 0x130ff75},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff7f},
						{0x12eff28, 0x12eff48},
						{0x12fff5c, 0x12fffbf},
						{0x130ff8f, 0x130ff7d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffce},
						{0x12eff99, 0x12eff3e},
						{0x12fff99, 0x12fff7c},
						{0x130ff99, 0x130ff86},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dff1c},
						{0x12eff0a, 0x12eff35},
						{0x12fffd7, 0x12fff39},
						{0x130ffa3, 0x130ff8f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff6a},
						{0x12eff7a, 0x12eff2b},
						{0x12fff14, 0x12ffff6},
						{0x130ffae, 0x130ff97},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dffb9},
						{0x12effeb, 0x12eff21},
						{0x12fff51, 0x12fffb3},
						{0x130ffb8, 0x130ffa0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dff07},
						{0x12eff5c, 0x12eff18},
						{0x12fff8f, 0x12fff70},
						{0x130ffc2, 0x130ffa9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff56},
						{0x12effcc, 0x12eff0e},
						{0x12fffcc, 0x12fff2d},
						{0x130ffcc, 0x130ffb2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dffa4},
						{0x12eff3d, 0x12eff04},
						{0x12fff0a, 0x12fffea},
						{0x130ffd7, 0x130ffba},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dfff2},
						{0x12effae, 0x12efffa},
						{0x12fff47, 0x12fffa6},
						{0x130ffe1, 0x130ffc3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff41},
						{0x12eff1e, 0x12efff1},
						{0x12fff85, 0x12fff63},
						{0x130ffeb, 0x130ffcc},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dff8f},
						{0x12eff8f, 0x12effe7},
						{0x12fffc2, 0x12fff20},
						{0x130fff5, 0x130ffd5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dffdd},
						{0x12eff00, 0x12effdd},
						{0x12fff00, 0x12fffdd},
						{0x130ff00, 0x130ffdd},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dff2c},
						{0x12eff70, 0x12effd4},
						{0x12fff3d, 0x12fff9a},
						{0x130ff0a, 0x130ffe6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff7a},
						{0x12effe1, 0x12effca},
						{0x12fff7a, 0x12fff57},
						{0x130ff14, 0x130ffef},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dffc8},
						{0x12eff51, 0x12effc0},
						{0x12fffb8, 0x12fff14},
						{0x130ff1e, 0x130fff8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff17},
						{0x12effc2, 0x12effb7},
						{0x12ffff5, 0x12fffd1},
						{0x130ff28, 0x130ff00},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff65},
						{0x12eff33, 0x12effad},
						{0x12fff33, 0x12fff8e},
						{0x130ff33, 0x130ff09},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dffb4},
						{0x12effa3, 0x12effa3},
						{0x12fff70, 0x12fff4b},
						{0x130ff3d, 0x130ff12},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff02},
						{0x12eff14, 0x12eff9a},
						{0x12fffae, 0x12fff08},
						{0x130ff47, 0x130ff1b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dff50},
						{0x12eff85, 0x12eff90},
						{0x12fffeb, 0x12fffc5},
						{0x130ff51, 0x130ff23},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff9f},
						{0x12efff5, 0x12eff86},
						{0x12fff28, 0x12fff82},
						{0x130ff5c, 0x130ff2c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffed},
						{0x12eff66, 0x12eff7c},
						{0x12fff66, 0x12fff3f},
						{0x130ff66, 0x130ff35},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff3b},
						{0x12effd7, 0x12eff73},
						{0x12fffa3, 0x12ffffc},
						{0x130ff70, 0x130ff3d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff8a},
						{0x12eff47, 0x12eff69},
						{0x12fffe1, 0x12fffb9},
						{0x130ff7a, 0x130ff46},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dffd8},
						{0x12effb8, 0x12eff5f},
						{0x12fff1e, 0x12fff76},
						{0x130ff85, 0x130ff4f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff27},
						{0x12eff28, 0x12eff56},
						{0x12fff5c, 0x12fff33},
						{0x130ff8f, 0x130ff58},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff75},
						{0x12eff99, 0x12eff4c},
						{0x12fff99, 0x12ffff0},
						{0x130ff99, 0x130ff60},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dffc3},
						{0x12eff0a, 0x12eff42},
						{0x12fffd7, 0x12fffad},
						{0x130ffa3, 0x130ff69},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff12},
						{0x12eff7a, 0x12eff39},
						{0x12fff14, 0x12fff6a},
						{0x130ffae, 0x130ff72},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff60},
						{0x12effeb, 0x12eff2f},
						{0x12fff51, 0x12fff27},
						{0x130ffb8, 0x130ff7b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dffae},
						{0x12eff5c, 0x12eff25},
						{0x12fff8f, 0x12fffe4},
						{0x130ffc2, 0x130ff83},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dfffd},
						{0x12effcc, 0x12eff1b},
						{0x12fffcc, 0x12fffa1},
						{0x130ffcc, 0x130ff8c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dff4b},
						{0x12eff3d, 0x12eff12},
						{0x12fff0a, 0x12fff5e},
						{0x130ffd7, 0x130ff95},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff9a},
						{0x12effae, 0x12eff08},
						{0x12fff47, 0x12fff1b},
						{0x130ffe1, 0x130ff9e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dffe8},
						{0x12eff1e, 0x12efffe},
						{0x12fff85, 0x12fffd7},
						{0x130ffeb, 0x130ffa6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dff36},
						{0x12eff8f, 0x12efff5},
						{0x12fffc2, 0x12fff94},
						{0x130fff5, 0x130ffaf},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff85},
						{0x12eff00, 0x12effeb},
						{0x12fff00, 0x12fff51},
						{0x130ff00, 0x130ffb8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dffd3},
						{0x12eff70, 0x12effe1},
						{0x12fff3d, 0x12fff0e},
						{0x130ff0a, 0x130ffc1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff21},
						{0x12effe1, 0x12effd8},
						{0x12fff7a, 0x12fffcb},
						{0x130ff14, 0x130ffc9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dff70},
						{0x12eff51, 0x12effce},
						{0x12fffb8, 0x12fff88},
						{0x130ff1e, 0x130ffd2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dffbe},
						{0x12effc2, 0x12effc4},
						{0x12ffff5, 0x12fff45},
						{0x130ff28, 0x130ffdb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff0c},
						{0x12eff33, 0x12effbb},
						{0x12fff33, 0x12fff02},
						{0x130ff33, 0x130ffe4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff5b},
						{0x12effa3, 0x12effb1},
						{0x12fff70, 0x12fffbf},
						{0x130ff3d, 0x130ffec},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dffa9},
						{0x12eff14, 0x12effa7},
						{0x12fffae, 0x12fff7c},
						{0x130ff47, 0x130fff5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dfff8},
						{0x12eff85, 0x12eff9d},
						{0x12fffeb, 0x12fff39},
						{0x130ff51, 0x130fffe},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff46},
						{0x12efff5, 0x12eff94},
						{0x12fff28, 0x12ffff6},
						{0x130ff5c, 0x130ff06},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff94},
						{0x12eff66, 0x12eff8a},
						{0x12fff66, 0x12fffb3},
						{0x130ff66, 0x130ff0f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dffe3},
						{0x12effd7, 0x12eff80},
						{0x12fffa3, 0x12fff70},
						{0x130ff70, 0x130ff18},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff31},
						{0x12eff47, 0x12eff77},
						{0x12fffe1, 0x12fff2d},
						{0x130ff7a, 0x130ff21},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff7f},
						{0x12effb8, 0x12eff6d},
						{0x12fff1e, 0x12fffea},
						{0x130ff85, 0x130ff29},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dffce},
						{0x12eff28, 0x12eff63},
						{0x12fff5c, 0x12fffa7},
						{0x130ff8f, 0x130ff32},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff1c},
						{0x12eff99, 0x12eff5a},
						{0x12fff99, 0x12fff64},
						{0x130ff99, 0x130ff3b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dff6b},
						{0x12eff0a, 0x12eff50},
						{0x12fffd7, 0x12fff21},
						{0x130ffa3, 0x130ff44},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dffb9},
						{0x12eff7a, 0x12eff46},
						{0x12fff14, 0x12fffde},
						{0x130ffae, 0x130ff4c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff07},
						{0x12effeb, 0x12eff3d},
						{0x12fff51, 0x12fff9b},
						{0x130ffb8, 0x130ff55},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dff56},
						{0x12eff5c, 0x12eff33},
						{0x12fff8f, 0x12fff58},
						{0x130ffc2, 0x130ff5e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffa4},
						{0x12effcc, 0x12eff29},
						{0x12fffcc, 0x12fff15},
						{0x130ffcc, 0x130ff67},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dfff2},
						{0x12eff3d, 0x12eff1f},
						{0x12fff0a, 0x12fffd2},
						{0x130ffd7, 0x130ff6f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff41},
						{0x12effae, 0x12eff16},
						{0x12fff47, 0x12fff8f},
						{0x130ffe1, 0x130ff78},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff8f},
						{0x12eff1e, 0x12eff0c},
						{0x12fff85, 0x12fff4c},
						{0x130ffeb, 0x130ff81},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dffde},
						{0x12eff8f, 0x12eff02},
						{0x12fffc2, 0x12fff09},
						{0x130fff5, 0x130ff8a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff2c},
						{0x12eff00, 0x12efff9},
						{0x12fff00, 0x12fffc5},
						{0x130ff00, 0x130ff92},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dff7a},
						{0x12eff70, 0x12effef},
						{0x12fff3d, 0x12fff82},
						{0x130ff0a, 0x130ff9b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dffc9},
						{0x12effe1, 0x12effe5},
						{0x12fff7a, 0x12fff3f},
						{0x130ff14, 0x130ffa4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dff17},
						{0x12eff51, 0x12effdc},
						{0x12fffb8, 0x12ffffc},
						{0x130ff1e, 0x130ffac},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff65},
						{0x12effc2, 0x12effd2},
						{0x12ffff5, 0x12fffb9},
						{0x130ff28, 0x130ffb5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffb4},
						{0x12eff33, 0x12effc8},
						{0x12fff33, 0x12fff76},
						{0x130ff33, 0x130ffbe},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff02},
						{0x12effa3, 0x12effbf},
						{0x12fff70, 0x12fff33},
						{0x130ff3d, 0x130ffc7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff50},
						{0x12eff14, 0x12effb5},
						{0x12fffae, 0x12ffff0},
						{0x130ff47, 0x130ffcf},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dff9f},
						{0x12eff85, 0x12effab},
						{0x12fffeb, 0x12fffad},
						{0x130ff51, 0x130ffd8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dffed},
						{0x12efff5, 0x12effa1},
						{0x12fff28, 0x12fff6a},
						{0x130ff5c, 0x130ffe1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff3c},
						{0x12eff66, 0x12eff98},
						{0x12fff66, 0x12fff27},
						{0x130ff66, 0x130ffea},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff8a},
						{0x12effd7, 0x12eff8e},
						{0x12fffa3, 0x12fffe4},
						{0x130ff70, 0x130fff2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff1f},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dffd8},
						{0x12eff47, 0x12eff84},
						{0x12fffe1, 0x12fffa1},
						{0x130ff7a, 0x130fffb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff27},
						{0x12effb8, 0x12eff7b},
						{0x12fff1e, 0x12fff5e},
						{0x130ff85, 0x130ff04},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff75},
						{0x12eff28, 0x12eff71},
						{0x12fff5c, 0x12fff1b},
						{0x130ff8f, 0x130ff0d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffc3},
						{0x12eff99, 0x12eff67},
						{0x12fff99, 0x12fffd8},
						{0x130ff99, 0x130ff15},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dff12},
						{0x12eff0a, 0x12eff5e},
						{0x12fffd7, 0x12fff95},
						{0x130ffa3, 0x130ff1e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff60},
						{0x12eff7a, 0x12eff54},
						{0x12fff14, 0x12fff52},
						{0x130ffae, 0x130ff27},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dffaf},
						{0x12effeb, 0x12eff4a},
						{0x12fff51, 0x12fff0f},
						{0x130ffb8, 0x130ff30},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dfffd},
						{0x12eff5c, 0x12eff40},
						{0x12fff8f, 0x12fffcc},
						{0x130ffc2, 0x130ff38},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff4b},
						{0x12effcc, 0x12eff37},
						{0x12fffcc, 0x12fff89},
						{0x130ffcc, 0x130ff41},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dff9a},
						{0x12eff3d, 0x12eff2d},
						{0x12fff0a, 0x12fff46},
						{0x130ffd7, 0x130ff4a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dffe8},
						{0x12effae, 0x12eff23},
						{0x12fff47, 0x12fff03},
						{0x130ffe1, 0x130ff53},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff36},
						{0x12eff1e, 0x12eff1a},
						{0x12fff85, 0x12fffc0},
						{0x130ffeb, 0x130ff5b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff25, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dff85},
						{0x12eff8f, 0x12eff10},
						{0x12fffc2, 0x12fff7d},
						{0x130fff5, 0x130ff64},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dffd3},
						{0x12eff00, 0x12eff06},
						{0x12fff00, 0x12fff3a},
						{0x130ff00, 0x130ff6d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dff21},
						{0x12eff70, 0x12efffd},
						{0x12fff3d, 0x12ffff6},
						{0x130ff0a, 0x130ff75},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff70},
						{0x12effe1, 0x12efff3},
						{0x12fff7a, 0x12fffb3},
						{0x130ff14, 0x130ff7e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dffbe},
						{0x12eff51, 0x12effe9},
						{0x12fffb8, 0x12fff70},
						{0x130ff1e, 0x130ff87},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff0d},
						{0x12effc2, 0x12effe0},
						{0x12ffff5, 0x12fff2d},
						{0x130ff28, 0x130ff90},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff5b},
						{0x12eff33, 0x12effd6},
						{0x12fff33, 0x12fffea},
						{0x130ff33, 0x130ff98},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dffa9},
						{0x12effa3, 0x12effcc},
						{0x12fff70, 0x12fffa7},
						{0x130ff3d, 0x130ffa1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dfff8},
						{0x12eff14, 0x12effc2},
						{0x12fffae, 0x12fff64},
						{0x130ff47, 0x130ffaa},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dff46},
						{0x12eff85, 0x12effb9},
						{0x12fffeb, 0x12fff21},
						{0x130ff51, 0x130ffb3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff94},
						{0x12efff5, 0x12effaf},
						{0x12fff28, 0x12fffde},
						{0x130ff5c, 0x130ffbb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffe3},
						{0x12eff66, 0x12effa5},
						{0x12fff66, 0x12fff9b},
						{0x130ff66, 0x130ffc4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff31},
						{0x12effd7, 0x12eff9c},
						{0x12fffa3, 0x12fff58},
						{0x130ff70, 0x130ffcd},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff80},
						{0x12eff47, 0x12eff92},
						{0x12fffe1, 0x12fff15},
						{0x130ff7a, 0x130ffd6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dffce},
						{0x12effb8, 0x12eff88},
						{0x12fff1e, 0x12fffd2},
						{0x130ff85, 0x130ffde},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff1c},
						{0x12eff28, 0x12eff7f},
						{0x12fff5c, 0x12fff8f},
						{0x130ff8f, 0x130ffe7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff6b},
						{0x12eff99, 0x12eff75},
						{0x12fff99, 0x12fff4c},
						{0x130ff99, 0x130fff0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff20},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dffb9},
						{0x12eff0a, 0x12eff6b},
						{0x12fffd7, 0x12fff09},
						{0x130ffa3, 0x130fff9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff07},
						{0x12eff7a, 0x12eff62},
						{0x12fff14, 0x12fffc6},
						{0x130ffae, 0x130ff01},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff56},
						{0x12effeb, 0x12eff58},
						{0x12fff51, 0x12fff83},
						{0x130ffb8, 0x130ff0a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dffa4},
						{0x12eff5c, 0x12eff4e},
						{0x12fff8f, 0x12fff40},
						{0x130ffc2, 0x130ff13},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dfff3},
						{0x12effcc, 0x12eff44},
						{0x12fffcc, 0x12ffffd},
						{0x130ffcc, 0x130ff1b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dff41},
						{0x12eff3d, 0x12eff3b},
						{0x12fff0a, 0x12fffba},
						{0x130ffd7, 0x130ff24},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff8f},
						{0x12effae, 0x12eff31},
						{0x12fff47, 0x12fff77},
						{0x130ffe1, 0x130ff2d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dffde},
						{0x12eff1e, 0x12eff27},
						{0x12fff85, 0x12fff34},
						{0x130ffeb, 0x130ff36},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff26, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dff2c},
						{0x12eff8f, 0x12eff1e},
						{0x12fffc2, 0x12ffff1},
						{0x130fff5, 0x130ff3e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff7a},
						{0x12eff00, 0x12eff14},
						{0x12fff00, 0x12fffae},
						{0x130ff00, 0x130ff47},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dffc9},
						{0x12eff70, 0x12eff0a},
						{0x12fff3d, 0x12fff6b},
						{0x130ff0a, 0x130ff50},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff17},
						{0x12effe1, 0x12eff01},
						{0x12fff7a, 0x12fff28},
						{0x130ff14, 0x130ff59},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dff65},
						{0x12eff51, 0x12efff7},
						{0x12fffb8, 0x12fffe4},
						{0x130ff1e, 0x130ff61},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dffb4},
						{0x12effc2, 0x12effed},
						{0x12ffff5, 0x12fffa1},
						{0x130ff28, 0x130ff6a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff02},
						{0x12eff33, 0x12effe4},
						{0x12fff33, 0x12fff5e},
						{0x130ff33, 0x130ff73},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff51},
						{0x12effa3, 0x12effda},
						{0x12fff70, 0x12fff1b},
						{0x130ff3d, 0x130ff7c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff9f},
						{0x12eff14, 0x12effd0},
						{0x12fffae, 0x12fffd8},
						{0x130ff47, 0x130ff84},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dffed},
						{0x12eff85, 0x12effc6},
						{0x12fffeb, 0x12fff95},
						{0x130ff51, 0x130ff8d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff3c},
						{0x12efff5, 0x12effbd},
						{0x12fff28, 0x12fff52},
						{0x130ff5c, 0x130ff96},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff8a},
						{0x12eff66, 0x12effb3},
						{0x12fff66, 0x12fff0f},
						{0x130ff66, 0x130ff9f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dffd8},
						{0x12effd7, 0x12effa9},
						{0x12fffa3, 0x12fffcc},
						{0x130ff70, 0x130ffa7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff27},
						{0x12eff47, 0x12effa0},
						{0x12fffe1, 0x12fff89},
						{0x130ff7a, 0x130ffb0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff75},
						{0x12effb8, 0x12eff96},
						{0x12fff1e, 0x12fff46},
						{0x130ff85, 0x130ffb9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dffc4},
						{0x12eff28, 0x12eff8c},
						{0x12fff5c, 0x12fff03},
						{0x130ff8f, 0x130ffc2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff12},
						{0x12eff99, 0x12eff83},
						{0x12fff99, 0x12fffc0},
						{0x130ff99, 0x130ffca},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dff60},
						{0x12eff0a, 0x12eff79},
						{0x12fffd7, 0x12fff7d},
						{0x130ffa3, 0x130ffd3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dffaf},
						{0x12eff7a, 0x12eff6f},
						{0x12fff14, 0x12fff3a},
						{0x130ffae, 0x130ffdc},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dfffd},
						{0x12effeb, 0x12eff65},
						{0x12fff51, 0x12ffff7},
						{0x130ffb8, 0x130ffe4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dff4b},
						{0x12eff5c, 0x12eff5c},
						{0x12fff8f, 0x12fffb4},
						{0x130ffc2, 0x130ffed},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff9a},
						{0x12effcc, 0x12eff52},
						{0x12fffcc, 0x12fff71},
						{0x130ffcc, 0x130fff6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff21},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dffe8},
						{0x12eff3d, 0x12eff48},
						{0x12fff0a, 0x12fff2e},
						{0x130ffd7, 0x130ffff},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff22},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff37},
						{0x12effae, 0x12eff3f},
						{0x12fff47, 0x12fffeb},
						{0x130ffe1, 0x130ff07},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff22},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff85},
						{0x12eff1e, 0x12eff35},
						{0x12fff85, 0x12fffa8},
						{0x130ffeb, 0x130ff10},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff04, 0x110ff04},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff27, 0x12bff22},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dffd3},
						{0x12eff8f, 0x12eff2b},
						{0x12fffc2, 0x12fff65},
						{0x130fff5, 0x130ff19},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff99},
						{0x12eff00, 0x12eff99},
						{0x12fff00, 0x12fff99},
						{0x130ff00, 0x130ff99},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff54},
						{0x12eff14, 0x12eff52},
						{0x12fffae, 0x12fff27},
						{0x130ff07, 0x130ffa0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff0f},
						{0x12eff28, 0x12eff0b},
						{0x12fff5c, 0x12fffb5},
						{0x130ff0f, 0x130ffa6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dffc9},
						{0x12eff3d, 0x12effc3},
						{0x12fff0a, 0x12fff42},
						{0x130ff17, 0x130ffad},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dff84},
						{0x12eff51, 0x12eff7c},
						{0x12fffb8, 0x12fffd0},
						{0x130ff1e, 0x130ffb3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff3f},
						{0x12eff66, 0x12eff35},
						{0x12fff66, 0x12fff5e},
						{0x130ff26, 0x130ffba},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dfffa},
						{0x12eff7a, 0x12effed},
						{0x12fff14, 0x12fffeb},
						{0x130ff2e, 0x130ffc0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dffb5},
						{0x12eff8f, 0x12effa6},
						{0x12fffc2, 0x12fff79},
						{0x130ff35, 0x130ffc7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff6f},
						{0x12effa3, 0x12eff5f},
						{0x12fff70, 0x12fff07},
						{0x130ff3d, 0x130ffce},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff2a},
						{0x12effb8, 0x12eff18},
						{0x12fff1e, 0x12fff95},
						{0x130ff45, 0x130ffd4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffe5},
						{0x12effcc, 0x12effd0},
						{0x12fffcc, 0x12fff22},
						{0x130ff4c, 0x130ffdb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dffa0},
						{0x12effe1, 0x12eff89},
						{0x12fff7a, 0x12fffb0},
						{0x130ff54, 0x130ffe1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff5a},
						{0x12efff5, 0x12eff42},
						{0x12fff28, 0x12fff3e},
						{0x130ff5c, 0x130ffe8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dff15},
						{0x12eff0a, 0x12efffb},
						{0x12fffd7, 0x12fffcb},
						{0x130ff63, 0x130ffee},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dffd0},
						{0x12eff1e, 0x12effb3},
						{0x12fff85, 0x12fff59},
						{0x130ff6b, 0x130fff5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff19},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff8b},
						{0x12eff33, 0x12eff6c},
						{0x12fff33, 0x12fffe7},
						{0x130ff73, 0x130fffb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff46},
						{0x12eff47, 0x12eff25},
						{0x12fffe1, 0x12fff75},
						{0x130ff7a, 0x130ff02},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dff00},
						{0x12eff5c, 0x12effde},
						{0x12fff8f, 0x12fff02},
						{0x130ff82, 0x130ff09},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dffbb},
						{0x12eff70, 0x12eff96},
						{0x12fff3d, 0x12fff90},
						{0x130ff8a, 0x130ff0f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dff76},
						{0x12eff85, 0x12eff4f},
						{0x12fffeb, 0x12fff1e},
						{0x130ff91, 0x130ff16},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff31},
						{0x12eff99, 0x12eff08},
						{0x12fff99, 0x12fffac},
						{0x130ff99, 0x130ff1c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dffeb},
						{0x12effae, 0x12effc0},
						{0x12fff47, 0x12fff39},
						{0x130ffa1, 0x130ff23},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dffa6},
						{0x12effc2, 0x12eff79},
						{0x12ffff5, 0x12fffc7},
						{0x130ffa8, 0x130ff29},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff61},
						{0x12effd7, 0x12eff32},
						{0x12fffa3, 0x12fff55},
						{0x130ffb0, 0x130ff30},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff1c},
						{0x12effeb, 0x12effeb},
						{0x12fff51, 0x12fffe2},
						{0x130ffb8, 0x130ff36},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dffd7},
						{0x12eff00, 0x12effa3},
						{0x12fff00, 0x12fff70},
						{0x130ffc0, 0x130ff3d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff91},
						{0x12eff14, 0x12eff5c},
						{0x12fffae, 0x12ffffe},
						{0x130ffc7, 0x130ff43},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff4c},
						{0x12eff28, 0x12eff15},
						{0x12fff5c, 0x12fff8c},
						{0x130ffcf, 0x130ff4a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dff07},
						{0x12eff3d, 0x12effce},
						{0x12fff0a, 0x12fff19},
						{0x130ffd7, 0x130ff51},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dffc2},
						{0x12eff51, 0x12eff86},
						{0x12fffb8, 0x12fffa7},
						{0x130ffde, 0x130ff57},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff7c},
						{0x12eff66, 0x12eff3f},
						{0x12fff66, 0x12fff35},
						{0x130ffe6, 0x130ff5e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff37},
						{0x12eff7a, 0x12efff8},
						{0x12fff14, 0x12fffc2},
						{0x130ffee, 0x130ff64},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dfff2},
						{0x12eff8f, 0x12effb0},
						{0x12fffc2, 0x12fff50},
						{0x130fff5, 0x130ff6b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1e, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dffad},
						{0x12effa3, 0x12eff69},
						{0x12fff70, 0x12fffde},
						{0x130fffd, 0x130ff71},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff68},
						{0x12effb8, 0x12eff22},
						{0x12fff1e, 0x12fff6c},
						{0x130ff05, 0x130ff78},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff22},
						{0x12effcc, 0x12effdb},
						{0x12fffcc, 0x12ffff9},
						{0x130ff0c, 0x130ff7e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dffdd},
						{0x12effe1, 0x12eff93},
						{0x12fff7a, 0x12fff87},
						{0x130ff14, 0x130ff85},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff98},
						{0x12efff5, 0x12eff4c},
						{0x12fff28, 0x12fff15},
						{0x130ff1c, 0x130ff8c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dff53},
						{0x12eff0a, 0x12eff05},
						{0x12fffd7, 0x12fffa3},
						{0x130ff23, 0x130ff92},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff0d},
						{0x12eff1e, 0x12effbe},
						{0x12fff85, 0x12fff30},
						{0x130ff2b, 0x130ff99},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffc8},
						{0x12eff33, 0x12eff76},
						{0x12fff33, 0x12fffbe},
						{0x130ff33, 0x130ff9f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff83},
						{0x12eff47, 0x12eff2f},
						{0x12fffe1, 0x12fff4c},
						{0x130ff3a, 0x130ffa6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dff3e},
						{0x12eff5c, 0x12effe8},
						{0x12fff8f, 0x12fffd9},
						{0x130ff42, 0x130ffac},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dfff9},
						{0x12eff70, 0x12effa0},
						{0x12fff3d, 0x12fff67},
						{0x130ff4a, 0x130ffb3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dffb3},
						{0x12eff85, 0x12eff59},
						{0x12fffeb, 0x12ffff5},
						{0x130ff51, 0x130ffb9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff6e},
						{0x12eff99, 0x12eff12},
						{0x12fff99, 0x12fff83},
						{0x130ff59, 0x130ffc0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff29},
						{0x12effae, 0x12effcb},
						{0x12fff47, 0x12fff10},
						{0x130ff61, 0x130ffc7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dffe4},
						{0x12effc2, 0x12eff83},
						{0x12ffff5, 0x12fff9e},
						{0x130ff68, 0x130ffcd},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff9e},
						{0x12effd7, 0x12eff3c},
						{0x12fffa3, 0x12fff2c},
						{0x130ff70, 0x130ffd4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff59},
						{0x12effeb, 0x12efff5},
						{0x12fff51, 0x12fffb9},
						{0x130ff78, 0x130ffda},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff14},
						{0x12eff00, 0x12effae},
						{0x12fff00, 0x12fff47},
						{0x130ff80, 0x130ffe1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dffcf},
						{0x12eff14, 0x12eff66},
						{0x12fffae, 0x12fffd5},
						{0x130ff87, 0x130ffe7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff8a},
						{0x12eff28, 0x12eff1f},
						{0x12fff5c, 0x12fff63},
						{0x130ff8f, 0x130ffee},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dff44},
						{0x12eff3d, 0x12effd8},
						{0x12fff0a, 0x12ffff0},
						{0x130ff97, 0x130fff4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1a},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dffff},
						{0x12eff51, 0x12eff90},
						{0x12fffb8, 0x12fff7e},
						{0x130ff9e, 0x130fffb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffba},
						{0x12eff66, 0x12eff49},
						{0x12fff66, 0x12fff0c},
						{0x130ffa6, 0x130ff02},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff75},
						{0x12eff7a, 0x12eff02},
						{0x12fff14, 0x12fff9a},
						{0x130ffae, 0x130ff08},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dff2f},
						{0x12eff8f, 0x12effbb},
						{0x12fffc2, 0x12fff27},
						{0x130ffb5, 0x130ff0f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dffea},
						{0x12effa3, 0x12eff73},
						{0x12fff70, 0x12fffb5},
						{0x130ffbd, 0x130ff15},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dffa5},
						{0x12effb8, 0x12eff2c},
						{0x12fff1e, 0x12fff43},
						{0x130ffc5, 0x130ff1c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff60},
						{0x12effcc, 0x12effe5},
						{0x12fffcc, 0x12fffd0},
						{0x130ffcc, 0x130ff22},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff1b},
						{0x12effe1, 0x12eff9e},
						{0x12fff7a, 0x12fff5e},
						{0x130ffd4, 0x130ff29},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dffd5},
						{0x12efff5, 0x12eff56},
						{0x12fff28, 0x12fffec},
						{0x130ffdc, 0x130ff2f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dff90},
						{0x12eff0a, 0x12eff0f},
						{0x12fffd7, 0x12fff7a},
						{0x130ffe3, 0x130ff36},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff4b},
						{0x12eff1e, 0x12effc8},
						{0x12fff85, 0x12fff07},
						{0x130ffeb, 0x130ff3d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff06},
						{0x12eff33, 0x12eff81},
						{0x12fff33, 0x12fff95},
						{0x130fff3, 0x130ff43},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff1f, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dffc0},
						{0x12eff47, 0x12eff39},
						{0x12fffe1, 0x12fff23},
						{0x130fffa, 0x130ff4a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dff7b},
						{0x12eff5c, 0x12efff2},
						{0x12fff8f, 0x12fffb0},
						{0x130ff02, 0x130ff50},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dff36},
						{0x12eff70, 0x12effab},
						{0x12fff3d, 0x12fff3e},
						{0x130ff0a, 0x130ff57},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dfff1},
						{0x12eff85, 0x12eff63},
						{0x12fffeb, 0x12fffcc},
						{0x130ff11, 0x130ff5d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffac},
						{0x12eff99, 0x12eff1c},
						{0x12fff99, 0x12fff5a},
						{0x130ff19, 0x130ff64},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff66},
						{0x12effae, 0x12effd5},
						{0x12fff47, 0x12fffe7},
						{0x130ff21, 0x130ff6a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff21},
						{0x12effc2, 0x12eff8e},
						{0x12ffff5, 0x12fff75},
						{0x130ff28, 0x130ff71},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dffdc},
						{0x12effd7, 0x12eff46},
						{0x12fffa3, 0x12fff03},
						{0x130ff30, 0x130ff78},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff97},
						{0x12effeb, 0x12effff},
						{0x12fff51, 0x12fff90},
						{0x130ff38, 0x130ff7e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff51},
						{0x12eff00, 0x12effb8},
						{0x12fff00, 0x12fff1e},
						{0x130ff40, 0x130ff85},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff0c},
						{0x12eff14, 0x12eff71},
						{0x12fffae, 0x12fffac},
						{0x130ff47, 0x130ff8b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dffc7},
						{0x12eff28, 0x12eff29},
						{0x12fff5c, 0x12fff3a},
						{0x130ff4f, 0x130ff92},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dff82},
						{0x12eff3d, 0x12effe2},
						{0x12fff0a, 0x12fffc7},
						{0x130ff57, 0x130ff98},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dff3d},
						{0x12eff51, 0x12eff9b},
						{0x12fffb8, 0x12fff55},
						{0x130ff5e, 0x130ff9f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dfff7},
						{0x12eff66, 0x12eff53},
						{0x12fff66, 0x12fffe3},
						{0x130ff66, 0x130ffa5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dffb2},
						{0x12eff7a, 0x12eff0c},
						{0x12fff14, 0x12fff71},
						{0x130ff6e, 0x130ffac},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dff6d},
						{0x12eff8f, 0x12effc5},
						{0x12fffc2, 0x12ffffe},
						{0x130ff75, 0x130ffb2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff28},
						{0x12effa3, 0x12eff7e},
						{0x12fff70, 0x12fff8c},
						{0x130ff7d, 0x130ffb9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dffe2},
						{0x12effb8, 0x12eff36},
						{0x12fff1e, 0x12fff1a},
						{0x130ff85, 0x130ffc0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff9d},
						{0x12effcc, 0x12effef},
						{0x12fffcc, 0x12fffa7},
						{0x130ff8c, 0x130ffc6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff58},
						{0x12effe1, 0x12effa8},
						{0x12fff7a, 0x12fff35},
						{0x130ff94, 0x130ffcd},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff13},
						{0x12efff5, 0x12eff61},
						{0x12fff28, 0x12fffc3},
						{0x130ff9c, 0x130ffd3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dffce},
						{0x12eff0a, 0x12eff19},
						{0x12fffd7, 0x12fff51},
						{0x130ffa3, 0x130ffda},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff88},
						{0x12eff1e, 0x12effd2},
						{0x12fff85, 0x12fffde},
						{0x130ffab, 0x130ffe0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff43},
						{0x12eff33, 0x12eff8b},
						{0x12fff33, 0x12fff6c},
						{0x130ffb3, 0x130ffe7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dfffe},
						{0x12eff47, 0x12eff43},
						{0x12fffe1, 0x12ffffa},
						{0x130ffba, 0x130ffed},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dffb9},
						{0x12eff5c, 0x12efffc},
						{0x12fff8f, 0x12fff87},
						{0x130ffc2, 0x130fff4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1b},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dff73},
						{0x12eff70, 0x12effb5},
						{0x12fff3d, 0x12fff15},
						{0x130ffca, 0x130fffb},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dff2e},
						{0x12eff85, 0x12eff6e},
						{0x12fffeb, 0x12fffa3},
						{0x130ffd1, 0x130ff01},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffe9},
						{0x12eff99, 0x12eff26},
						{0x12fff99, 0x12fff31},
						{0x130ffd9, 0x130ff08},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dffa4},
						{0x12effae, 0x12effdf},
						{0x12fff47, 0x12fffbe},
						{0x130ffe1, 0x130ff0e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff5f},
						{0x12effc2, 0x12eff98},
						{0x12ffff5, 0x12fff4c},
						{0x130ffe8, 0x130ff15},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff19},
						{0x12effd7, 0x12eff51},
						{0x12fffa3, 0x12fffda},
						{0x130fff0, 0x130ff1b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff20, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dffd4},
						{0x12effeb, 0x12eff09},
						{0x12fff51, 0x12fff68},
						{0x130fff8, 0x130ff22},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff8f},
						{0x12eff00, 0x12effc2},
						{0x12fff00, 0x12ffff5},
						{0x130ff00, 0x130ff28},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff4a},
						{0x12eff14, 0x12eff7b},
						{0x12fffae, 0x12fff83},
						{0x130ff07, 0x130ff2f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff04},
						{0x12eff28, 0x12eff34},
						{0x12fff5c, 0x12fff11},
						{0x130ff0f, 0x130ff36},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dffbf},
						{0x12eff3d, 0x12effec},
						{0x12fff0a, 0x12fff9e},
						{0x130ff17, 0x130ff3c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dff7a},
						{0x12eff51, 0x12effa5},
						{0x12fffb8, 0x12fff2c},
						{0x130ff1e, 0x130ff43},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff35},
						{0x12eff66, 0x12eff5e},
						{0x12fff66, 0x12fffba},
						{0x130ff26, 0x130ff49},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dfff0},
						{0x12eff7a, 0x12eff16},
						{0x12fff14, 0x12fff48},
						{0x130ff2e, 0x130ff50},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dffaa},
						{0x12eff8f, 0x12effcf},
						{0x12fffc2, 0x12fffd5},
						{0x130ff35, 0x130ff56},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff65},
						{0x12effa3, 0x12eff88},
						{0x12fff70, 0x12fff63},
						{0x130ff3d, 0x130ff5d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff20},
						{0x12effb8, 0x12eff41},
						{0x12fff1e, 0x12ffff1},
						{0x130ff45, 0x130ff63},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dffdb},
						{0x12effcc, 0x12efff9},
						{0x12fffcc, 0x12fff7e},
						{0x130ff4c, 0x130ff6a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff95},
						{0x12effe1, 0x12effb2},
						{0x12fff7a, 0x12fff0c},
						{0x130ff54, 0x130ff71},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff50},
						{0x12efff5, 0x12eff6b},
						{0x12fff28, 0x12fff9a},
						{0x130ff5c, 0x130ff77},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dff0b},
						{0x12eff0a, 0x12eff24},
						{0x12fffd7, 0x12fff28},
						{0x130ff63, 0x130ff7e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dffc6},
						{0x12eff1e, 0x12effdc},
						{0x12fff85, 0x12fffb5},
						{0x130ff6b, 0x130ff84},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff81},
						{0x12eff33, 0x12eff95},
						{0x12fff33, 0x12fff43},
						{0x130ff73, 0x130ff8b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff3b},
						{0x12eff47, 0x12eff4e},
						{0x12fffe1, 0x12fffd1},
						{0x130ff7a, 0x130ff91},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dfff6},
						{0x12eff5c, 0x12eff06},
						{0x12fff8f, 0x12fff5f},
						{0x130ff82, 0x130ff98},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dffb1},
						{0x12eff70, 0x12effbf},
						{0x12fff3d, 0x12fffec},
						{0x130ff8a, 0x130ff9e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dff6c},
						{0x12eff85, 0x12eff78},
						{0x12fffeb, 0x12fff7a},
						{0x130ff91, 0x130ffa5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff26},
						{0x12eff99, 0x12eff31},
						{0x12fff99, 0x12fff08},
						{0x130ff99, 0x130ffac},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dffe1},
						{0x12effae, 0x12effe9},
						{0x12fff47, 0x12fff95},
						{0x130ffa1, 0x130ffb2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff9c},
						{0x12effc2, 0x12effa2},
						{0x12ffff5, 0x12fff23},
						{0x130ffa8, 0x130ffb9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff57},
						{0x12effd7, 0x12eff5b},
						{0x12fffa3, 0x12fffb1},
						{0x130ffb0, 0x130ffbf},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff12},
						{0x12effeb, 0x12eff14},
						{0x12fff51, 0x12fff3f},
						{0x130ffb8, 0x130ffc6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dffcc},
						{0x12eff00, 0x12effcc},
						{0x12fff00, 0x12fffcc},
						{0x130ffc0, 0x130ffcc},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff87},
						{0x12eff14, 0x12eff85},
						{0x12fffae, 0x12fff5a},
						{0x130ffc7, 0x130ffd3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff42},
						{0x12eff28, 0x12eff3e},
						{0x12fff5c, 0x12fffe8},
						{0x130ffcf, 0x130ffd9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dfffd},
						{0x12eff3d, 0x12efff6},
						{0x12fff0a, 0x12fff75},
						{0x130ffd7, 0x130ffe0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dffb7},
						{0x12eff51, 0x12effaf},
						{0x12fffb8, 0x12fff03},
						{0x130ffde, 0x130ffe7},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dff72},
						{0x12eff66, 0x12eff68},
						{0x12fff66, 0x12fff91},
						{0x130ffe6, 0x130ffed},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff2d},
						{0x12eff7a, 0x12eff21},
						{0x12fff14, 0x12fff1f},
						{0x130ffee, 0x130fff4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1c},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dffe8},
						{0x12eff8f, 0x12effd9},
						{0x12fffc2, 0x12fffac},
						{0x130fff5, 0x130fffa},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff21, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dffa3},
						{0x12effa3, 0x12eff92},
						{0x12fff70, 0x12fff3a},
						{0x130fffd, 0x130ff01},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff5d},
						{0x12effb8, 0x12eff4b},
						{0x12fff1e, 0x12fffc8},
						{0x130ff05, 0x130ff07},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff18},
						{0x12effcc, 0x12eff04},
						{0x12fffcc, 0x12fff56},
						{0x130ff0c, 0x130ff0e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dffd3},
						{0x12effe1, 0x12effbc},
						{0x12fff7a, 0x12fffe3},
						{0x130ff14, 0x130ff14},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff8e},
						{0x12efff5, 0x12eff75},
						{0x12fff28, 0x12fff71},
						{0x130ff1c, 0x130ff1b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dff48},
						{0x12eff0a, 0x12eff2e},
						{0x12fffd7, 0x12fffff},
						{0x130ff23, 0x130ff21},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff03},
						{0x12eff1e, 0x12effe7},
						{0x12fff85, 0x12fff8c},
						{0x130ff2b, 0x130ff28},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dffbe},
						{0x12eff33, 0x12eff9f},
						{0x12fff33, 0x12fff1a},
						{0x130ff33, 0x130ff2f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dff79},
						{0x12eff47, 0x12eff58},
						{0x12fffe1, 0x12fffa8},
						{0x130ff3a, 0x130ff35},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dff34},
						{0x12eff5c, 0x12eff11},
						{0x12fff8f, 0x12fff36},
						{0x130ff42, 0x130ff3c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dffee},
						{0x12eff70, 0x12effc9},
						{0x12fff3d, 0x12fffc3},
						{0x130ff4a, 0x130ff42},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dffa9},
						{0x12eff85, 0x12eff82},
						{0x12fffeb, 0x12fff51},
						{0x130ff51, 0x130ff49},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dff64},
						{0x12eff99, 0x12eff3b},
						{0x12fff99, 0x12fffdf},
						{0x130ff59, 0x130ff4f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff1f},
						{0x12effae, 0x12efff4},
						{0x12fff47, 0x12fff6c},
						{0x130ff61, 0x130ff56},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dffd9},
						{0x12effc2, 0x12effac},
						{0x12ffff5, 0x12ffffa},
						{0x130ff68, 0x130ff5c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff94},
						{0x12effd7, 0x12eff65},
						{0x12fffa3, 0x12fff88},
						{0x130ff70, 0x130ff63},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff4f},
						{0x12effeb, 0x12eff1e},
						{0x12fff51, 0x12fff16},
						{0x130ff78, 0x130ff6a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff0a},
						{0x12eff00, 0x12effd7},
						{0x12fff00, 0x12fffa3},
						{0x130ff80, 0x130ff70},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dffc5},
						{0x12eff14, 0x12eff8f},
						{0x12fffae, 0x12fff31},
						{0x130ff87, 0x130ff77},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dff7f},
						{0x12eff28, 0x12eff48},
						{0x12fff5c, 0x12fffbf},
						{0x130ff8f, 0x130ff7d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dff3a},
						{0x12eff3d, 0x12eff01},
						{0x12fff0a, 0x12fff4d},
						{0x130ff97, 0x130ff84},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dfff5},
						{0x12eff51, 0x12effb9},
						{0x12fffb8, 0x12fffda},
						{0x130ff9e, 0x130ff8a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffb0},
						{0x12eff66, 0x12eff72},
						{0x12fff66, 0x12fff68},
						{0x130ffa6, 0x130ff91},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dff6a},
						{0x12eff7a, 0x12eff2b},
						{0x12fff14, 0x12ffff6},
						{0x130ffae, 0x130ff97},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dff25},
						{0x12eff8f, 0x12effe4},
						{0x12fffc2, 0x12fff83},
						{0x130ffb5, 0x130ff9e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dffe0},
						{0x12effa3, 0x12eff9c},
						{0x12fff70, 0x12fff11},
						{0x130ffbd, 0x130ffa5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dff9b},
						{0x12effb8, 0x12eff55},
						{0x12fff1e, 0x12fff9f},
						{0x130ffc5, 0x130ffab},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff56},
						{0x12effcc, 0x12eff0e},
						{0x12fffcc, 0x12fff2d},
						{0x130ffcc, 0x130ffb2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff10},
						{0x12effe1, 0x12effc7},
						{0x12fff7a, 0x12fffba},
						{0x130ffd4, 0x130ffb8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dffcb},
						{0x12efff5, 0x12eff7f},
						{0x12fff28, 0x12fff48},
						{0x130ffdc, 0x130ffbf},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dff86},
						{0x12eff0a, 0x12eff38},
						{0x12fffd7, 0x12fffd6},
						{0x130ffe3, 0x130ffc5},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff41},
						{0x12eff1e, 0x12efff1},
						{0x12fff85, 0x12fff63},
						{0x130ffeb, 0x130ffcc},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dfffb},
						{0x12eff33, 0x12effa9},
						{0x12fff33, 0x12ffff1},
						{0x130fff3, 0x130ffd2},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff22, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dffb6},
						{0x12eff47, 0x12eff62},
						{0x12fffe1, 0x12fff7f},
						{0x130fffa, 0x130ffd9},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dff71},
						{0x12eff5c, 0x12eff1b},
						{0x12fff8f, 0x12fff0d},
						{0x130ff02, 0x130ffe0},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dff2c},
						{0x12eff70, 0x12effd4},
						{0x12fff3d, 0x12fff9a},
						{0x130ff0a, 0x130ffe6},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dffe7},
						{0x12eff85, 0x12eff8c},
						{0x12fffeb, 0x12fff28},
						{0x130ff11, 0x130ffed},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffa1},
						{0x12eff99, 0x12eff45},
						{0x12fff99, 0x12fffb6},
						{0x130ff19, 0x130fff3},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1d},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff5c},
						{0x12effae, 0x12efffe},
						{0x12fff47, 0x12fff43},
						{0x130ff21, 0x130fffa},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff17},
						{0x12effc2, 0x12effb7},
						{0x12ffff5, 0x12fffd1},
						{0x130ff28, 0x130ff00},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dffd2},
						{0x12effd7, 0x12eff6f},
						{0x12fffa3, 0x12fff5f},
						{0x130ff30, 0x130ff07},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dff8c},
						{0x12effeb, 0x12eff28},
						{0x12fff51, 0x12fffed},
						{0x130ff38, 0x130ff0d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff00, 0x12dff47},
						{0x12eff00, 0x12effe1},
						{0x12fff00, 0x12fff7a},
						{0x130ff40, 0x130ff14},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff7a, 0x12dff02},
						{0x12eff14, 0x12eff9a},
						{0x12fffae, 0x12fff08},
						{0x130ff47, 0x130ff1b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dfff5, 0x12dffbd},
						{0x12eff28, 0x12eff52},
						{0x12fff5c, 0x12fff96},
						{0x130ff4f, 0x130ff21},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff70, 0x12dff78},
						{0x12eff3d, 0x12eff0b},
						{0x12fff0a, 0x12fff24},
						{0x130ff57, 0x130ff28},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffeb, 0x12dff32},
						{0x12eff51, 0x12effc4},
						{0x12fffb8, 0x12fffb1},
						{0x130ff5e, 0x130ff2e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff66, 0x12dffed},
						{0x12eff66, 0x12eff7c},
						{0x12fff66, 0x12fff3f},
						{0x130ff66, 0x130ff35},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffe1, 0x12dffa8},
						{0x12eff7a, 0x12eff35},
						{0x12fff14, 0x12fffcd},
						{0x130ff6e, 0x130ff3b},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff5c, 0x12dff63},
						{0x12eff8f, 0x12effee},
						{0x12fffc2, 0x12fff5a},
						{0x130ff75, 0x130ff42},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffd7, 0x12dff1d},
						{0x12effa3, 0x12effa7},
						{0x12fff70, 0x12fffe8},
						{0x130ff7d, 0x130ff48},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff51, 0x12dffd8},
						{0x12effb8, 0x12eff5f},
						{0x12fff1e, 0x12fff76},
						{0x130ff85, 0x130ff4f},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffcc, 0x12dff93},
						{0x12effcc, 0x12eff18},
						{0x12fffcc, 0x12fff04},
						{0x130ff8c, 0x130ff56},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff47, 0x12dff4e},
						{0x12effe1, 0x12effd1},
						{0x12fff7a, 0x12fff91},
						{0x130ff94, 0x130ff5c},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffc2, 0x12dff09},
						{0x12efff5, 0x12eff8a},
						{0x12fff28, 0x12fff1f},
						{0x130ff9c, 0x130ff63},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff3d, 0x12dffc3},
						{0x12eff0a, 0x12eff42},
						{0x12fffd7, 0x12fffad},
						{0x130ffa3, 0x130ff69},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffb8, 0x12dff7e},
						{0x12eff1e, 0x12efffb},
						{0x12fff85, 0x12fff3a},
						{0x130ffab, 0x130ff70},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff33, 0x12dff39},
						{0x12eff33, 0x12effb4},
						{0x12fff33, 0x12fffc8},
						{0x130ffb3, 0x130ff76},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffae, 0x12dfff4},
						{0x12eff47, 0x12eff6c},
						{0x12fffe1, 0x12fff56},
						{0x130ffba, 0x130ff7d},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff28, 0x12dffae},
						{0x12eff5c, 0x12eff25},
						{0x12fff8f, 0x12fffe4},
						{0x130ffc2, 0x130ff83},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dffa3, 0x12dff69},
						{0x12eff70, 0x12effde},
						{0x12fff3d, 0x12fff71},
						{0x130ffca, 0x130ff8a},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff1e, 0x12dff24},
						{0x12eff85, 0x12eff97},
						{0x12fffeb, 0x12fffff},
						{0x130ffd1, 0x130ff90},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff99, 0x12dffdf},
						{0x12eff99, 0x12eff4f},
						{0x12fff99, 0x12fff8d},
						{0x130ffd9, 0x130ff97},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff14, 0x12dff9a},
						{0x12effae, 0x12eff08},
						{0x12fff47, 0x12fff1b},
						{0x130ffe1, 0x130ff9e},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff8f, 0x12dff54},
						{0x12effc2, 0x12effc1},
						{0x12ffff5, 0x12fffa8},
						{0x130ffe8, 0x130ffa4},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff0a, 0x12dff0f},
						{0x12effd7, 0x12eff7a},
						{0x12fffa3, 0x12fff36},
						{0x130fff0, 0x130ffab},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff23, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff85, 0x12dffca},
						{0x12effeb, 0x12eff32},
						{0x12fff51, 0x12fffc4},
						{0x130fff8, 0x130ffb1},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}},

					       {{0x10fffff, 0x10fffff},
						{0x110ff03, 0x110ff03},
						{0x111ff10, 0x111ff10},
						{0x12afce4, 0x12afce4},
						{0x12bff24, 0x12bff1e},
						{0x12cff08, 0x12cff10},
						{0x12dff01, 0x12dff85},
						{0x12eff00, 0x12effeb},
						{0x12fff00, 0x12fff51},
						{0x130ff00, 0x130ffb8},
						{0x1337f0a, 0x1337f0a},
						{0x1347c10, 0x1347c10},
						{0x135ff03, 0x135ff03},
						{0x1427f04, 0x1427f04}}};
