/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef p384ecdh_vectors_h__
#define p384ecdh_vectors_h__

#include "testvectors_base/test-structs.h"

const EcdhTestVector kP384EcdhWycheproofVectors[] = {

    // Comment: normal case
    // tcID: 1
    {1,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x76,
      0x6e, 0x61, 0x42, 0x5b, 0x2d, 0xa9, 0xf8, 0x46, 0xc0, 0x9f, 0xc3, 0x56,
      0x4b, 0x93, 0xa6, 0xf8, 0x60, 0x3b, 0x73, 0x92, 0xc7, 0x85, 0x16, 0x5b,
      0xf2, 0x0d, 0xa9, 0x48, 0xc4, 0x9f, 0xd1, 0xfb, 0x1d, 0xee, 0x4e, 0xdd,
      0x64, 0x35, 0x6b, 0x9f, 0x21, 0xc5, 0x88, 0xb7, 0x5d, 0xfd, 0x81, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x7a, 0x6e, 0xc8, 0xd3, 0x11, 0xd5, 0xca,
      0x58, 0x8b, 0xae, 0xd4, 0x1b, 0xe3, 0xe9, 0x8f, 0x30, 0xc9, 0x29, 0x48,
      0x44, 0xec, 0xbb, 0x62, 0x99, 0x95, 0x65, 0x36, 0x35, 0xdb, 0xc2, 0x2d,
      0xa2, 0xf0, 0x83, 0xf2, 0x97, 0x11, 0xe0, 0xf9, 0xc5, 0x96, 0x3b, 0xc0,
      0x21, 0xbd, 0x8c, 0xb2, 0x10, 0x9d, 0xaf, 0x56, 0xa5, 0x5f, 0x88, 0x3a,
      0x72, 0x00, 0xce, 0xa9, 0xc4, 0xde, 0x44, 0x48, 0x8e, 0x6d, 0xc4, 0x9f,
      0xb9, 0xc3, 0x94, 0xf5, 0x1c, 0xb5, 0xa4, 0x9f, 0xc6, 0x9d, 0x7e, 0x8a,
      0x03, 0x47, 0x92, 0x96, 0x3a, 0xe4, 0xea, 0xbc, 0x63, 0x48, 0x3a, 0x2c,
      0xf1, 0xa8, 0x99, 0xe8, 0xc8},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x79, 0x0a, 0x6e, 0x05, 0x9e, 0xf9, 0xa5, 0x94, 0x01, 0x63, 0x18, 0x3d,
      0x4a, 0x78, 0x09, 0x13, 0x5d, 0x29, 0x79, 0x16, 0x43, 0xfc, 0x43, 0xa2,
      0xf1, 0x7e, 0xe8, 0xbf, 0x67, 0x7a, 0xb8, 0x4f, 0x79, 0x1b, 0x64, 0xa6,
      0xbe, 0x15, 0x96, 0x9f, 0xfa, 0x01, 0x2d, 0xd9, 0x18, 0x5d, 0x87, 0x96,
      0xd9, 0xb9, 0x54, 0xba, 0xa8, 0xa7, 0x5e, 0x82, 0xdf, 0x71, 0x1b, 0x3b,
      0x56, 0xea, 0xdf, 0xf6, 0xb0, 0xf6, 0x68, 0xc3, 0xb2, 0x6b, 0x4b, 0x1a,
      0xeb, 0x30, 0x8a, 0x1f, 0xcc, 0x1c, 0x68, 0x0d, 0x32, 0x9a, 0x67, 0x05,
      0x02, 0x5f, 0x1c, 0x98, 0xa0, 0xb5, 0xe5, 0xbf, 0xcb, 0x16, 0x3c, 0xaa},
     {0x64, 0x61, 0xde, 0xfb, 0x95, 0xd9, 0x96, 0xb2, 0x42, 0x96, 0xf5, 0xa1,
      0x83, 0x2b, 0x34, 0xdb, 0x05, 0xed, 0x03, 0x11, 0x14, 0xfb, 0xe7, 0xd9,
      0x8d, 0x09, 0x8f, 0x93, 0x85, 0x98, 0x66, 0xe4, 0xde, 0x1e, 0x22, 0x9d,
      0xa7, 0x1f, 0xef, 0x0c, 0x77, 0xfe, 0x49, 0xb2, 0x49, 0x19, 0x01, 0x35},
     false,
     true},

    // Comment: compressed public key
    // tcID: 2
    {2,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x76,
      0x6e, 0x61, 0x42, 0x5b, 0x2d, 0xa9, 0xf8, 0x46, 0xc0, 0x9f, 0xc3, 0x56,
      0x4b, 0x93, 0xa6, 0xf8, 0x60, 0x3b, 0x73, 0x92, 0xc7, 0x85, 0x16, 0x5b,
      0xf2, 0x0d, 0xa9, 0x48, 0xc4, 0x9f, 0xd1, 0xfb, 0x1d, 0xee, 0x4e, 0xdd,
      0x64, 0x35, 0x6b, 0x9f, 0x21, 0xc5, 0x88, 0xb7, 0x5d, 0xfd, 0x81, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x7a, 0x6e, 0xc8, 0xd3, 0x11, 0xd5, 0xca,
      0x58, 0x8b, 0xae, 0xd4, 0x1b, 0xe3, 0xe9, 0x8f, 0x30, 0xc9, 0x29, 0x48,
      0x44, 0xec, 0xbb, 0x62, 0x99, 0x95, 0x65, 0x36, 0x35, 0xdb, 0xc2, 0x2d,
      0xa2, 0xf0, 0x83, 0xf2, 0x97, 0x11, 0xe0, 0xf9, 0xc5, 0x96, 0x3b, 0xc0,
      0x21, 0xbd, 0x8c, 0xb2, 0x10, 0x9d, 0xaf, 0x56, 0xa5, 0x5f, 0x88, 0x3a,
      0x72, 0x00, 0xce, 0xa9, 0xc4, 0xde, 0x44, 0x48, 0x8e, 0x6d, 0xc4, 0x9f,
      0xb9, 0xc3, 0x94, 0xf5, 0x1c, 0xb5, 0xa4, 0x9f, 0xc6, 0x9d, 0x7e, 0x8a,
      0x03, 0x47, 0x92, 0x96, 0x3a, 0xe4, 0xea, 0xbc, 0x63, 0x48, 0x3a, 0x2c,
      0xf1, 0xa8, 0x99, 0xe8, 0xc8},
     {0x30, 0x46, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x32, 0x00, 0x02,
      0x79, 0x0a, 0x6e, 0x05, 0x9e, 0xf9, 0xa5, 0x94, 0x01, 0x63, 0x18, 0x3d,
      0x4a, 0x78, 0x09, 0x13, 0x5d, 0x29, 0x79, 0x16, 0x43, 0xfc, 0x43, 0xa2,
      0xf1, 0x7e, 0xe8, 0xbf, 0x67, 0x7a, 0xb8, 0x4f, 0x79, 0x1b, 0x64, 0xa6,
      0xbe, 0x15, 0x96, 0x9f, 0xfa, 0x01, 0x2d, 0xd9, 0x18, 0x5d, 0x87, 0x96},
     {0x64, 0x61, 0xde, 0xfb, 0x95, 0xd9, 0x96, 0xb2, 0x42, 0x96, 0xf5, 0xa1,
      0x83, 0x2b, 0x34, 0xdb, 0x05, 0xed, 0x03, 0x11, 0x14, 0xfb, 0xe7, 0xd9,
      0x8d, 0x09, 0x8f, 0x93, 0x85, 0x98, 0x66, 0xe4, 0xde, 0x1e, 0x22, 0x9d,
      0xa7, 0x1f, 0xef, 0x0c, 0x77, 0xfe, 0x49, 0xb2, 0x49, 0x19, 0x01, 0x35},
     false,
     false},

    // Comment: edge case for shared secret
    // tcID: 3
    {3,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x49, 0x0e, 0x96, 0xd1, 0x7f, 0x4c, 0x6c, 0xec, 0xcd, 0x45, 0xde, 0xf4,
      0x08, 0xce, 0xa3, 0x3e, 0x97, 0x04, 0xa5, 0xf1, 0xb0, 0x1a, 0x3d, 0xe2,
      0xea, 0xaa, 0x34, 0x09, 0xfd, 0x16, 0x0d, 0x78, 0xd3, 0x95, 0xd6, 0xb3,
      0xb0, 0x03, 0xd7, 0x1f, 0xd1, 0xf5, 0x90, 0xfa, 0xd9, 0x5b, 0xf1, 0xc9,
      0xd8, 0x66, 0x5e, 0xfc, 0x20, 0x70, 0xd0, 0x59, 0xaa, 0x84, 0x71, 0x25,
      0xc2, 0xf7, 0x07, 0x43, 0x59, 0x55, 0x53, 0x5c, 0x7c, 0x5d, 0xf6, 0xd6,
      0xc0, 0x79, 0xec, 0x80, 0x6d, 0xce, 0x6b, 0x68, 0x49, 0xd3, 0x37, 0x14,
      0x0d, 0xb7, 0xca, 0x50, 0x61, 0x6f, 0x94, 0x56, 0xde, 0x13, 0x23, 0xc4},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 4
    {4,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x01, 0x61, 0x32, 0x89, 0x09, 0x67, 0x52, 0x13, 0xe3, 0x20, 0x98, 0xd3,
      0x5a, 0x6b, 0x83, 0x08, 0xa8, 0xd5, 0x00, 0xcc, 0xa3, 0x9d, 0xce, 0xe5,
      0xe8, 0x04, 0xe7, 0x3b, 0xdb, 0x8d, 0xea, 0xf0, 0x6f, 0xe4, 0x17, 0x29,
      0x1f, 0xd9, 0x79, 0x3b, 0x23, 0x1e, 0xf5, 0xfe, 0x86, 0x94, 0x54, 0x44,
      0xa9, 0x7a, 0x01, 0xf3, 0xae, 0x3a, 0x83, 0x10, 0xc4, 0xaf, 0x49, 0xb5,
      0x92, 0xcb, 0x29, 0x1e, 0xf7, 0x0e, 0xe5, 0xbc, 0x7f, 0x55, 0x34, 0xd3,
      0xc2, 0x3d, 0xc9, 0xee, 0xfd, 0xe2, 0x30, 0x48, 0x42, 0xc7, 0x73, 0x7a,
      0xe9, 0x37, 0xcc, 0xf9, 0xbd, 0x21, 0x5c, 0x28, 0x10, 0x3e, 0x9f, 0xe2},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 5
    {5,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xaf, 0x4a, 0xe9, 0x64, 0xe3, 0xbc, 0xbd, 0x92, 0x3a, 0xcc, 0xda, 0x5d,
      0xa3, 0x17, 0x5d, 0x41, 0x1f, 0xd6, 0x2d, 0x17, 0xdd, 0x3c, 0x3a, 0x1c,
      0x41, 0x0b, 0xef, 0x17, 0x30, 0x98, 0x5a, 0x62, 0x65, 0xd9, 0x0e, 0x95,
      0x0a, 0xc0, 0xfc, 0x50, 0x74, 0x3b, 0x1e, 0xd7, 0x71, 0x90, 0x6f, 0xf3,
      0x3b, 0x68, 0xcf, 0x4d, 0x3d, 0x83, 0xa8, 0x85, 0xa8, 0x70, 0x97, 0xfd,
      0xd3, 0x29, 0xce, 0x83, 0xb1, 0x89, 0xf9, 0x8c, 0xec, 0x5b, 0xe4, 0x4c,
      0x31, 0xd1, 0xa3, 0xa2, 0xbb, 0xa1, 0x0f, 0x47, 0x19, 0x63, 0x23, 0x2b,
      0x8b, 0xa7, 0x61, 0x0f, 0xa8, 0xc7, 0x21, 0x79, 0x05, 0x0e, 0xb8, 0x6d},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 6
    {6,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x14, 0x78, 0xab, 0x6e, 0x03, 0x2b, 0x95, 0x45, 0xed, 0xa9, 0xac, 0x2c,
      0x26, 0x4e, 0x57, 0xa1, 0x1f, 0x08, 0xac, 0xbc, 0x76, 0xd1, 0x6a, 0x0a,
      0xb7, 0x7b, 0x04, 0xdb, 0xda, 0xf2, 0x0f, 0x21, 0x5c, 0x41, 0x83, 0x43,
      0x7b, 0x32, 0xaf, 0xc4, 0x71, 0xea, 0xa6, 0x03, 0xd1, 0x4c, 0x7c, 0x5d,
      0x8a, 0x4c, 0x84, 0xee, 0x0e, 0x89, 0x5b, 0xec, 0x5c, 0x37, 0xf0, 0xa1,
      0xca, 0x07, 0x5e, 0x10, 0x6f, 0xf6, 0xbf, 0x38, 0x80, 0x1b, 0x5c, 0x69,
      0x74, 0x09, 0xd3, 0x96, 0x75, 0x23, 0x11, 0x08, 0xd3, 0x3c, 0x4a, 0x5e,
      0xa6, 0x5a, 0xaa, 0x8c, 0x03, 0xe9, 0x39, 0xc9, 0x5d, 0x96, 0xc4, 0xc4},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 7
    {7,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xf6, 0x32, 0x08, 0xe3, 0x4e, 0x7e, 0x90, 0xbb, 0x5f, 0xb0, 0x36, 0x43,
      0x24, 0x67, 0xa8, 0x99, 0x81, 0x44, 0x40, 0x10, 0x66, 0x3b, 0x85, 0x33,
      0xb4, 0x7b, 0xfa, 0x94, 0xbd, 0x2b, 0xc1, 0x6f, 0x38, 0xaa, 0x51, 0x6b,
      0x93, 0x0a, 0x47, 0x26, 0xe3, 0x87, 0x6d, 0x30, 0x91, 0xbf, 0xb7, 0x2e,
      0xc7, 0x83, 0xed, 0x4d, 0xa0, 0xca, 0xc0, 0x63, 0x20, 0x81, 0x7d, 0xc8,
      0xbc, 0x64, 0xf5, 0x9c, 0xcf, 0x06, 0xf4, 0x8a, 0xbc, 0x43, 0x86, 0xa1,
      0x50, 0x91, 0x3f, 0xa9, 0x57, 0x43, 0xa7, 0xb4, 0x60, 0x11, 0x90, 0xe1,
      0xc6, 0xee, 0x8f, 0x8b, 0xf6, 0x35, 0x4b, 0x25, 0x4e, 0xca, 0xce, 0x45},
     {0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 8
    {8,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x03, 0x32, 0x71, 0xef, 0x42, 0xd9, 0x2a, 0xd4, 0x7b, 0x27, 0x3b, 0x09,
      0xea, 0x2f, 0x45, 0x40, 0x11, 0x61, 0xba, 0xa5, 0x26, 0x96, 0x59, 0x0d,
      0x0e, 0x17, 0x5f, 0xf2, 0xd1, 0xc0, 0xdf, 0xa3, 0xfe, 0xa4, 0x0e, 0x42,
      0x66, 0xd4, 0x46, 0x54, 0x6c, 0x05, 0xe4, 0x80, 0xd5, 0x7f, 0xab, 0xec,
      0x78, 0x89, 0xf1, 0x6a, 0x8b, 0xcc, 0x17, 0x66, 0x02, 0xf6, 0xd4, 0x65,
      0x61, 0x61, 0x4a, 0x2f, 0x42, 0x84, 0xab, 0xe6, 0x97, 0xb7, 0xcb, 0x9c,
      0xe7, 0x9f, 0x7e, 0x2e, 0x71, 0xb1, 0x55, 0xcb, 0x1f, 0x15, 0x5c, 0xe9,
      0x25, 0xd1, 0x63, 0x91, 0xa6, 0x80, 0xed, 0xa2, 0x31, 0x52, 0xe6, 0xe1},
     {0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,
      0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,
      0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,
      0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 9
    {9,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x73, 0x7e, 0x84, 0x37, 0xe1, 0x86, 0x83, 0xde, 0x24, 0x55, 0xb6, 0x89,
      0x45, 0xbb, 0xa3, 0x1d, 0xae, 0xc3, 0xe7, 0x54, 0xd7, 0x2f, 0x0a, 0x07,
      0x76, 0xd3, 0x19, 0x2b, 0x2f, 0x92, 0x98, 0xbb, 0x95, 0xca, 0x14, 0x64,
      0xba, 0xa6, 0x68, 0x7a, 0xab, 0xb6, 0x79, 0xf8, 0x04, 0xcf, 0x6e, 0xc6,
      0xc2, 0xb4, 0xd4, 0x7d, 0x61, 0xa6, 0x04, 0x04, 0xdf, 0x63, 0xb1, 0xe9,
      0xac, 0x09, 0x54, 0xb3, 0x41, 0x9b, 0xbc, 0x2a, 0xd5, 0x2a, 0x04, 0x09,
      0xae, 0xeb, 0x82, 0xf4, 0x70, 0x37, 0x58, 0x58, 0x80, 0x59, 0x16, 0x5b,
      0x20, 0x36, 0x7d, 0xcb, 0x4b, 0x23, 0x5b, 0x0c, 0xaf, 0x71, 0xd7, 0x27},
     {0x00, 0x7f, 0xff, 0x00, 0x01, 0xff, 0xfc, 0x00, 0x07, 0xff, 0xf0, 0x00,
      0x1f, 0xff, 0xc0, 0x00, 0x7f, 0xff, 0x00, 0x01, 0xff, 0xfc, 0x00, 0x07,
      0xff, 0xf0, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x7f, 0xff, 0x00, 0x01, 0xff,
      0xfc, 0x00, 0x07, 0xff, 0xf0, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x80, 0x00},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 10
    {10,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x37, 0xf9, 0x00, 0x49, 0x83, 0x15, 0x6b, 0xbd, 0x9c, 0x47, 0x89, 0x1e,
      0x75, 0x23, 0x7b, 0xb1, 0x30, 0x16, 0xbd, 0x7f, 0xe6, 0xf4, 0xe0, 0xf7,
      0x1c, 0xef, 0x0e, 0x63, 0xf1, 0x6a, 0x67, 0x2f, 0x0d, 0x3b, 0x0e, 0x20,
      0x16, 0x5c, 0x33, 0x40, 0x7e, 0x14, 0x6b, 0x6a, 0x4a, 0xe6, 0x96, 0x2d,
      0xd3, 0xb5, 0x7c, 0xcb, 0x99, 0xe7, 0xaa, 0xf1, 0x30, 0x32, 0x40, 0x51,
      0x6d, 0x0e, 0xbe, 0x08, 0xe5, 0x85, 0x51, 0x3e, 0x36, 0x95, 0xd4, 0x2c,
      0x46, 0x7d, 0xca, 0xb5, 0x34, 0x0e, 0xf7, 0x61, 0x99, 0x0c, 0xad, 0xc8,
      0xd8, 0x84, 0x0a, 0xac, 0xc9, 0x44, 0x48, 0x14, 0x15, 0xc0, 0x7f, 0xeb},
     {0x3b, 0x5e, 0xed, 0x80, 0x72, 0x7b, 0xcb, 0xc5, 0x11, 0x3b, 0x8a, 0x9e,
      0x4d, 0xb1, 0xc8, 0x1b, 0x1d, 0xdd, 0xc2, 0xd9, 0x9f, 0xf5, 0x6d, 0x9c,
      0x3c, 0x10, 0x54, 0x34, 0x89, 0x13, 0xbd, 0xe2, 0x96, 0x31, 0x1c, 0x4b,
      0xd2, 0xfa, 0x89, 0x9b, 0x4d, 0x0e, 0x66, 0xaa, 0xa1, 0xb6, 0xa0, 0xdd},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 11
    {11,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x96, 0x55, 0xd8, 0xe5, 0x62, 0x27, 0x18, 0xb3, 0x17, 0xcf, 0xbc, 0x09,
      0x89, 0x43, 0x57, 0xf7, 0x5a, 0x6b, 0x13, 0xfa, 0x51, 0x6b, 0xcd, 0x66,
      0x30, 0x72, 0x1b, 0x86, 0x9a, 0x62, 0x01, 0x96, 0xcf, 0x0c, 0x3d, 0xec,
      0x88, 0x60, 0xb3, 0x2d, 0x27, 0xed, 0x9b, 0xac, 0x2c, 0xf2, 0x63, 0xaf,
      0x17, 0x32, 0x16, 0x98, 0x11, 0x6d, 0x7d, 0x81, 0x1a, 0xe8, 0xda, 0x9b,
      0x9c, 0xbb, 0xf9, 0x38, 0x2c, 0x1e, 0x36, 0xe2, 0xb6, 0x7d, 0x6c, 0x6a,
      0xf9, 0xbc, 0xea, 0x7d, 0x9d, 0xe0, 0x0c, 0xa7, 0x2b, 0x39, 0x86, 0x06,
      0xc0, 0x98, 0xa0, 0xa0, 0xf0, 0xc4, 0xb8, 0x94, 0x19, 0x43, 0xed, 0x65},
     {0x6a, 0x99, 0xa5, 0xac, 0xd4, 0xa7, 0xed, 0xb1, 0xc7, 0x07, 0xd7, 0xf8,
      0xbe, 0x12, 0xe8, 0x11, 0x40, 0x33, 0x8e, 0x3e, 0x14, 0xba, 0x56, 0x3c,
      0x70, 0x3c, 0x68, 0x1a, 0x31, 0x9a, 0x3f, 0x9c, 0xe1, 0xf9, 0x0f, 0x03,
      0x2b, 0xf8, 0x40, 0xf3, 0x75, 0x8e, 0x89, 0xcb, 0x85, 0x2c, 0xec, 0xa6},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 12
    {12,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xcc, 0xb1, 0x3d, 0x42, 0x7b, 0x3c, 0x4b, 0xb3, 0x3d, 0xd4, 0xf2, 0x0c,
      0xdd, 0xab, 0xc6, 0x86, 0x00, 0xea, 0xf9, 0x7e, 0xeb, 0x2c, 0x81, 0xe8,
      0xc2, 0x18, 0xae, 0x90, 0x74, 0x3e, 0x74, 0xff, 0x38, 0xca, 0x56, 0xf0,
      0xc0, 0x22, 0x43, 0x79, 0xdb, 0x46, 0x4d, 0xcf, 0x4a, 0x40, 0xf0, 0x43,
      0x50, 0xcd, 0x7a, 0x65, 0x9b, 0x2c, 0x48, 0x51, 0xa5, 0xdc, 0xf8, 0xc9,
      0x90, 0xfc, 0x92, 0x0c, 0x07, 0xd4, 0xd5, 0xaa, 0x50, 0xa2, 0x18, 0x57,
      0x50, 0xe6, 0xb8, 0x4c, 0x42, 0xe8, 0x3c, 0xff, 0x63, 0x50, 0x50, 0x48,
      0x2d, 0xec, 0xb4, 0x78, 0x0f, 0x81, 0x2e, 0x4c, 0x49, 0xfc, 0x74, 0x04},
     {0x7c, 0x25, 0xa4, 0xf5, 0x7f, 0x76, 0xab, 0x13, 0xb2, 0x5c, 0xab, 0x3c,
      0x26, 0x5d, 0xb9, 0xd9, 0xbd, 0x92, 0x5f, 0xec, 0xbf, 0x7b, 0xf9, 0x3b,
      0xef, 0x13, 0x08, 0x77, 0x86, 0x46, 0x62, 0x8d, 0xec, 0xab, 0x06, 0x7e,
      0xd9, 0x88, 0xa9, 0x75, 0x5c, 0xd8, 0x8e, 0x88, 0xde, 0x36, 0x71, 0x04},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 13
    {13,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x26, 0x64, 0x62, 0x43, 0x07, 0xc0, 0x2e, 0xf4, 0x87, 0x03, 0x0a, 0x63,
      0x21, 0x62, 0xc5, 0x15, 0xf8, 0x41, 0xd1, 0x5e, 0xa3, 0x15, 0x2d, 0x98,
      0xff, 0x23, 0x64, 0x23, 0x2d, 0x7a, 0xab, 0x39, 0x34, 0x3d, 0x5f, 0x70,
      0x3a, 0x4d, 0x5a, 0x31, 0x09, 0x2a, 0xa7, 0x35, 0x6c, 0x3a, 0x2f, 0x67,
      0x1c, 0x1c, 0xd6, 0x03, 0xad, 0xdf, 0xd8, 0xb5, 0x47, 0x75, 0x52, 0xa3,
      0xb3, 0x2a, 0x18, 0xed, 0xaf, 0x3e, 0x33, 0xbe, 0xc2, 0x2e, 0xe2, 0x16,
      0x7f, 0x9d, 0xa7, 0x29, 0x63, 0x60, 0x02, 0xa7, 0x97, 0x4e, 0xae, 0xb5,
      0xff, 0x08, 0x2b, 0x2a, 0xab, 0xf8, 0xc7, 0x05, 0x6b, 0x84, 0xc3, 0xab},
     {0x7f, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xfc, 0x00, 0x00,
      0x01, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xf0, 0x00,
      0x00, 0x07, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xc0,
      0x00, 0x00, 0x1f, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x04, 0x00, 0x00, 0x02},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 14
    {14,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x66, 0x5f, 0x1f, 0x32, 0x0b, 0x6a, 0xb1, 0xc1, 0xb5, 0x2d, 0x14, 0x4e,
      0x52, 0xd8, 0x7a, 0x15, 0x4c, 0x2b, 0x44, 0x89, 0x83, 0x8c, 0x91, 0x19,
      0xde, 0x62, 0x2c, 0x2d, 0x1b, 0x52, 0xb6, 0x5b, 0x0a, 0x39, 0x55, 0xe4,
      0x4e, 0x0d, 0x48, 0x59, 0x17, 0x53, 0x60, 0xc0, 0xf6, 0x3d, 0xee, 0x81,
      0x3f, 0x14, 0xf6, 0x99, 0x72, 0xf1, 0x8c, 0xae, 0xd7, 0x91, 0x6c, 0x94,
      0xa4, 0xd2, 0x0e, 0xc3, 0x44, 0x59, 0x1e, 0x75, 0x36, 0xa4, 0xa7, 0xa4,
      0xd8, 0xc9, 0x83, 0x28, 0x18, 0xc9, 0x6d, 0x60, 0xb1, 0xa8, 0x1f, 0xab,
      0xe6, 0x4e, 0xa0, 0x2c, 0x5f, 0x64, 0x7e, 0x36, 0x1b, 0xf5, 0xb6, 0x0f},
     {0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 15
    {15,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x91, 0x35, 0x7c, 0xa8, 0x7d, 0xbb, 0x08, 0xe8, 0x5d, 0x7b, 0x1a, 0xce,
      0xcf, 0xd1, 0xe0, 0x86, 0x07, 0x8a, 0x82, 0xd1, 0x9f, 0x81, 0x47, 0x4d,
      0xa3, 0x89, 0x36, 0x4a, 0x39, 0xfe, 0x25, 0x43, 0xeb, 0x93, 0x4b, 0x44,
      0x01, 0x73, 0xc3, 0x8e, 0x61, 0xa1, 0xd9, 0x40, 0x78, 0x55, 0xb5, 0xd8,
      0x9e, 0xf0, 0xd9, 0xe9, 0x20, 0x76, 0x4b, 0x6d, 0x77, 0x65, 0xb0, 0x84,
      0xcf, 0x95, 0x41, 0xda, 0xcc, 0x43, 0xd1, 0xda, 0xba, 0xa3, 0x90, 0xb0,
      0xfb, 0x85, 0x60, 0x97, 0xb0, 0xc0, 0x0a, 0x85, 0x56, 0xf4, 0xe3, 0x84,
      0x85, 0x68, 0xab, 0x4a, 0xe7, 0x90, 0xc3, 0xd3, 0x46, 0xca, 0x01, 0xb6},
     {0xff, 0xf0, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00,
      0x00, 0x7f, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff,
      0xfc, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00,
      0x1f, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 16
    {16,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xd5, 0xa8, 0x33, 0xba, 0xe3, 0x3b, 0x2d, 0x10, 0xfd, 0xff, 0x6d, 0xb7,
      0xc5, 0x47, 0x7a, 0xdb, 0x61, 0x4b, 0x19, 0x1c, 0x70, 0xd9, 0x7c, 0x6f,
      0x13, 0x0a, 0x14, 0xe9, 0x39, 0x31, 0xcc, 0x1d, 0xc0, 0x58, 0x05, 0x3f,
      0xee, 0x54, 0xa2, 0x64, 0xa0, 0x0f, 0xdd, 0x16, 0xd3, 0x16, 0x6f, 0xdc,
      0x42, 0x99, 0x22, 0x76, 0xb7, 0x99, 0x25, 0xba, 0xfc, 0xd1, 0x83, 0xb0,
      0x3e, 0xd1, 0x82, 0x35, 0x35, 0x09, 0x80, 0xab, 0xfe, 0x67, 0xb8, 0x14,
      0xc6, 0xc1, 0x10, 0x74, 0xc3, 0x8f, 0x74, 0xcd, 0x4e, 0x73, 0x4a, 0xd5,
      0x8c, 0xdb, 0x49, 0xd9, 0xfc, 0xd2, 0x18, 0x1d, 0x1b, 0x8f, 0x11, 0x19},
     {0xff, 0xff, 0xf0, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x3f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0x00, 0x00,
      0x00, 0x3f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x3f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 17
    {17,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x67, 0x54, 0x7c, 0xda, 0x7f, 0xbe, 0x8f, 0x16, 0xbe, 0x5a, 0x44, 0x77,
      0xcb, 0xb0, 0x29, 0x79, 0xf1, 0xaf, 0x72, 0xfc, 0x0f, 0x39, 0x30, 0x27,
      0x73, 0x55, 0x2f, 0xbc, 0xf4, 0x66, 0x7a, 0x8e, 0x23, 0xab, 0xc0, 0xe1,
      0x28, 0x56, 0xee, 0x62, 0x34, 0xde, 0xec, 0xa5, 0xf2, 0x2a, 0xe0, 0x50,
      0x3a, 0x4d, 0xf7, 0xc0, 0x68, 0xe7, 0x43, 0x24, 0x17, 0x26, 0x0c, 0xb9,
      0xfe, 0x0d, 0x68, 0xb9, 0xc7, 0xfc, 0xf7, 0xe1, 0x6a, 0x2a, 0xda, 0x05,
      0x68, 0x7d, 0x8f, 0x89, 0x00, 0xb8, 0x47, 0x23, 0x10, 0x3e, 0xdb, 0xff,
      0x0a, 0x42, 0xb2, 0x75, 0x17, 0xda, 0x27, 0x60, 0xb7, 0xd3, 0x88, 0x43},
     {0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xf0, 0x00,
      0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff,
      0xff, 0xf0, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x03, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 18
    {18,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x13, 0x63, 0xe3, 0xb9, 0x90, 0x08, 0xe0, 0x9b, 0xb3, 0xf0, 0x85, 0x94,
      0x9b, 0x9b, 0x6e, 0xa2, 0x6a, 0x31, 0x8f, 0x49, 0x6d, 0xe5, 0x68, 0xa9,
      0x66, 0x30, 0xfd, 0xb9, 0xd4, 0xc7, 0x2c, 0x28, 0x14, 0xdf, 0x30, 0x87,
      0xa1, 0x74, 0x1f, 0x32, 0xf2, 0x49, 0x89, 0xb4, 0x28, 0x16, 0x7f, 0x93,
      0xc6, 0x53, 0xcb, 0x3a, 0xe8, 0xc3, 0xec, 0xfa, 0xec, 0x57, 0xef, 0xd5,
      0x4b, 0xb8, 0xce, 0x9d, 0x79, 0xc7, 0xbf, 0x6c, 0xc7, 0x0f, 0xb1, 0x11,
      0x4f, 0x93, 0x9b, 0xe8, 0xf1, 0xa9, 0x9b, 0xf1, 0xe4, 0x2b, 0x97, 0x43,
      0x11, 0x24, 0xef, 0x9f, 0xa3, 0x34, 0x50, 0xfa, 0xa4, 0xe7, 0x68, 0x39},
     {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 19
    {19,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xba, 0x2b, 0xe8, 0xd7, 0x14, 0x7e, 0x24, 0x17, 0xc2, 0xec, 0x80, 0xb2,
      0x4b, 0x4c, 0x1a, 0xa9, 0x44, 0x64, 0xff, 0xd0, 0xaa, 0xe1, 0xfa, 0x2e,
      0x07, 0x8b, 0x3a, 0xfb, 0xc7, 0x7c, 0x14, 0x44, 0x89, 0xca, 0x9d, 0x06,
      0x4a, 0xcb, 0xb7, 0xa9, 0xcf, 0xa6, 0x19, 0x6d, 0x0f, 0x46, 0x7b, 0x7e,
      0x65, 0xee, 0x1c, 0xa1, 0xeb, 0x13, 0x51, 0xff, 0x99, 0x68, 0xf5, 0x53,
      0xdf, 0xe2, 0xe4, 0xc5, 0x9f, 0xf8, 0xba, 0x34, 0xc2, 0x2a, 0x42, 0xb3,
      0xba, 0xa1, 0x3a, 0x9a, 0x1a, 0xdc, 0x7f, 0x13, 0xab, 0xd4, 0x0f, 0x1f,
      0xd2, 0x5d, 0x46, 0xbc, 0x53, 0x30, 0x85, 0x2b, 0x93, 0x71, 0x96, 0x6a},
     {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 20
    {20,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xd6, 0x98, 0x50, 0xcc, 0xba, 0xcc, 0x47, 0x36, 0xea, 0x20, 0x0f, 0xf2,
      0xf8, 0x48, 0x8f, 0x26, 0x24, 0x79, 0x45, 0xa2, 0xab, 0x48, 0xdd, 0x37,
      0x08, 0xf4, 0x94, 0xb2, 0x93, 0xd8, 0xcb, 0xa8, 0x34, 0x17, 0xf4, 0x89,
      0x74, 0x88, 0x1c, 0x7f, 0xb0, 0x38, 0x54, 0x08, 0x9b, 0xbf, 0x66, 0xcc,
      0x1c, 0x77, 0x3e, 0xc0, 0x3c, 0xb8, 0xcd, 0x5f, 0x00, 0x7e, 0xc3, 0xb0,
      0x3b, 0xdd, 0x05, 0xa4, 0x09, 0xb3, 0x52, 0x10, 0x3f, 0x0d, 0xec, 0xf2,
      0x5b, 0x41, 0x67, 0x3a, 0xb8, 0xca, 0x3d, 0x04, 0x33, 0x4b, 0xab, 0xee,
      0x01, 0x21, 0x9f, 0x15, 0x70, 0x1f, 0x2b, 0xca, 0x22, 0xd4, 0x0b, 0x37},
     {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfe},
     false,
     true},

    // Comment: y-coordinate of the public key has many trailing 0's
    // tcID: 21
    {21,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x6f, 0xca, 0xf8, 0x2d, 0x98, 0x2d, 0x22, 0x2d, 0x60, 0x96, 0xba, 0x83,
      0xe5, 0x5b, 0x1c, 0x7d, 0xcb, 0x71, 0xa4, 0x1e, 0x88, 0xf3, 0x23, 0x33,
      0x3f, 0x44, 0x28, 0x4d, 0x95, 0xc4, 0xbd, 0x36, 0x16, 0xda, 0x7a, 0x1b,
      0xef, 0x92, 0x8f, 0x31, 0xc2, 0x6f, 0x88, 0x5b, 0xa7, 0xad, 0xb4, 0x87,
      0x82, 0x6f, 0xde, 0x2e, 0xd9, 0xf5, 0x64, 0x9c, 0x11, 0xcf, 0x84, 0x65,
      0xf8, 0xbf, 0x8a, 0xd5, 0x0f, 0x68, 0x91, 0x49, 0x36, 0xfc, 0x39, 0x66,
      0x6f, 0x68, 0x21, 0x9d, 0x06, 0x65, 0x06, 0xbe, 0xa4, 0x00, 0x1f, 0xdc,
      0x81, 0x6c, 0x9a, 0x90, 0xe7, 0xe2, 0xaf, 0xb1, 0x9b, 0xea, 0x08, 0x5f},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x1f, 0x03, 0x12, 0x3b, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     false,
     true},

    // Comment: y-coordinate of the public key has many trailing 1's
    // tcID: 22
    {22,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x6f, 0xca, 0xf8, 0x2d, 0x98, 0x2d, 0x22, 0x2d, 0x60, 0x96, 0xba, 0x83,
      0xe5, 0x5b, 0x1c, 0x7d, 0xcb, 0x71, 0xa4, 0x1e, 0x88, 0xf3, 0x23, 0x33,
      0x3f, 0x44, 0x28, 0x4d, 0x95, 0xc4, 0xbd, 0x36, 0x16, 0xda, 0x7a, 0x1b,
      0xef, 0x92, 0x8f, 0x31, 0xc2, 0x6f, 0x88, 0x5b, 0xa7, 0xad, 0xb4, 0x87,
      0x7d, 0x90, 0x21, 0xd1, 0x26, 0x0a, 0x9b, 0x63, 0xee, 0x30, 0x7b, 0x9a,
      0x07, 0x40, 0x75, 0x2a, 0xf0, 0x97, 0x6e, 0xb6, 0xc9, 0x03, 0xc6, 0x99,
      0x90, 0x97, 0xde, 0x62, 0xf9, 0x9a, 0xf9, 0x40, 0x5b, 0xff, 0xe0, 0x22,
      0x7e, 0x93, 0x65, 0x6f, 0x18, 0x1d, 0x50, 0x4f, 0x64, 0x15, 0xf7, 0xa0},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x1f, 0x03, 0x12, 0x3b, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     false,
     true},

    // Comment: y-coordinate of the public key is small
    // tcID: 23
    {23,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xbf, 0xeb, 0x47, 0xfb, 0x40, 0xa6, 0x58, 0x78, 0xe6, 0xb6, 0x42, 0xf4,
      0x0b, 0x8e, 0x15, 0x02, 0x2a, 0xde, 0x9e, 0xcf, 0xa8, 0xcb, 0x61, 0x80,
      0x43, 0x06, 0x34, 0x94, 0xe2, 0xbc, 0x5d, 0x2d, 0xf1, 0x0d, 0x36, 0xf3,
      0x78, 0x69, 0xb5, 0x8e, 0xf1, 0x2d, 0xcc, 0x35, 0xe3, 0x98, 0x28, 0x35,
      0xfd, 0x2e, 0x55, 0xec, 0x41, 0xfd, 0xfe, 0x8c, 0xab, 0xbb, 0xb7, 0xbc,
      0xd8, 0x16, 0x36, 0x45, 0xa1, 0x9e, 0x9d, 0xac, 0x59, 0x63, 0x0f, 0x3f,
      0xe9, 0x3b, 0x20, 0x80, 0x94, 0xff, 0x87, 0xcd, 0x46, 0x1b, 0x53, 0xce,
      0xf5, 0x34, 0x82, 0xe7, 0x0e, 0x2e, 0x8e, 0xa8, 0x72, 0x00, 0xcc, 0x3f},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x36, 0xa2, 0x90, 0x7c, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     false,
     true},

    // Comment: y-coordinate of the public key is large
    // tcID: 24
    {24,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xa2,
      0xb6, 0x44, 0x2a, 0x37, 0xf8, 0xa3, 0x75, 0x9d, 0x2c, 0xb9, 0x1d, 0xf5,
      0xec, 0xa7, 0x5b, 0x14, 0xf5, 0xa6, 0x76, 0x6d, 0xa8, 0x03, 0x5c, 0xc1,
      0x94, 0x3b, 0x15, 0xa8, 0xe4, 0xeb, 0xb6, 0x02, 0x5f, 0x37, 0x3b, 0xe3,
      0x34, 0x08, 0x0f, 0x22, 0xab, 0x82, 0x1a, 0x35, 0x35, 0xa6, 0xa7, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5f, 0xb6, 0xfc, 0x5f, 0x17, 0xd5, 0x87,
      0xde, 0xe5, 0xe9, 0x50, 0x2c, 0x4c, 0x48, 0x8e, 0xf3, 0xd6, 0xb0, 0x6c,
      0x09, 0x81, 0x02, 0xf6, 0x23, 0x0a, 0x26, 0x4d, 0x0b, 0x4d, 0x19, 0x27,
      0xc4, 0x61, 0x60, 0x1e, 0x47, 0xca, 0xb6, 0xd9, 0x3f, 0xaf, 0x0e, 0xe9,
      0x82, 0x29, 0xd5, 0xc5, 0xdd, 0xb4, 0x16, 0xc8, 0xa5, 0x21, 0xfd, 0xef,
      0xcc, 0xab, 0x5c, 0xbd, 0x14, 0xa3, 0x9b, 0x05, 0xc6, 0xb8, 0x8c, 0xb6,
      0x5f, 0xfb, 0x48, 0x79, 0x08, 0x62, 0x52, 0x35, 0xc6, 0x91, 0x64, 0xc3,
      0x9e, 0x5e, 0x27, 0xec, 0x34, 0x7c, 0x7f, 0x58, 0xf8, 0x31, 0x1a, 0xde,
      0x42, 0x03, 0x4a, 0x8c, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xbf, 0xeb, 0x47, 0xfb, 0x40, 0xa6, 0x58, 0x78, 0xe6, 0xb6, 0x42, 0xf4,
      0x0b, 0x8e, 0x15, 0x02, 0x2a, 0xde, 0x9e, 0xcf, 0xa8, 0xcb, 0x61, 0x80,
      0x43, 0x06, 0x34, 0x94, 0xe2, 0xbc, 0x5d, 0x2d, 0xf1, 0x0d, 0x36, 0xf3,
      0x78, 0x69, 0xb5, 0x8e, 0xf1, 0x2d, 0xcc, 0x35, 0xe3, 0x98, 0x28, 0x35,
      0x02, 0xd1, 0xaa, 0x13, 0xbe, 0x02, 0x01, 0x73, 0x54, 0x44, 0x48, 0x43,
      0x27, 0xe9, 0xc9, 0xba, 0x5e, 0x61, 0x62, 0x53, 0xa6, 0x9c, 0xf0, 0xc0,
      0x16, 0xc4, 0xdf, 0x7f, 0x6b, 0x00, 0x78, 0x31, 0xb9, 0xe4, 0xac, 0x30,
      0x0a, 0xcb, 0x7d, 0x18, 0xf1, 0xd1, 0x71, 0x58, 0x8d, 0xff, 0x33, 0xc0},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x36, 0xa2, 0x90, 0x7c, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 25
    {25,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x3c, 0xf9, 0x9e, 0xf0, 0x4f, 0x51, 0xa5, 0xea, 0x63, 0x0b, 0xa3, 0xf9,
      0xf9, 0x60, 0xdd, 0x59, 0x3a, 0x14, 0xc9, 0xbe, 0x39, 0xfd, 0x2b, 0xd2,
      0x15, 0xd3, 0xb4, 0xb0, 0x8a, 0xaa, 0xf8, 0x6b, 0xbf, 0x92, 0x7f, 0x2c,
      0x46, 0xe5, 0x2a, 0xb0, 0x6f, 0xb7, 0x42, 0xb8, 0x85, 0x0e, 0x52, 0x1e},
     {0x60, 0x92, 0xa1, 0x75, 0x7d, 0xdd, 0x43, 0xa0, 0x4e, 0x18, 0x5f, 0xf9,
      0x47, 0x2a, 0x0d, 0x18, 0xc7, 0xf7, 0xa7, 0xdc, 0x80, 0x2f, 0x7e, 0x05,
      0x9e, 0x0c, 0x69, 0xae, 0x16, 0xc8, 0x02, 0x65, 0x17, 0x19, 0x40, 0x6e,
      0x04, 0xde, 0x27, 0x65, 0x2f, 0xf8, 0x3d, 0xa4, 0xa7, 0x80, 0xef, 0x2f},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 26
    {26,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
      0x73, 0x21, 0x52, 0x44, 0x2f, 0xb6, 0xee, 0x5c, 0x3e, 0x6c, 0xe1, 0xd9,
      0x20, 0xc0, 0x59, 0xbc, 0x62, 0x35, 0x63, 0x81, 0x4d, 0x79, 0x04, 0x2b,
      0x90, 0x3c, 0xe6, 0x0f, 0x1d, 0x44, 0x87, 0xfc, 0xcd, 0x45, 0x0a, 0x86,
      0xda, 0x03, 0xf3, 0xe6, 0xed, 0x52, 0x5d, 0x02, 0x01, 0x7b, 0xfd, 0xb3},
     {0x89, 0xc8, 0x04, 0xcb, 0x81, 0x44, 0x33, 0x86, 0xb1, 0x85, 0xbc, 0xd9,
      0xe2, 0xe6, 0xc3, 0x5e, 0xe6, 0x17, 0x7c, 0x3b, 0x90, 0x29, 0x89, 0x85,
      0xc4, 0xe8, 0x1a, 0x89, 0xd5, 0x20, 0xcc, 0xeb, 0x17, 0xd7, 0x29, 0x54,
      0x0e, 0x56, 0xec, 0xc3, 0x43, 0xc2, 0x6b, 0xf3, 0x14, 0xf2, 0xd0, 0x52},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 27
    {27,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
      0x66, 0x60, 0x04, 0x1b, 0x1c, 0x79, 0x84, 0x62, 0x0e, 0x8d, 0x7f, 0xd7,
      0xcc, 0xdb, 0x50, 0xcc, 0x3b, 0xa8, 0x16, 0xda, 0x14, 0xd4, 0x1a, 0x4d,
      0x8a, 0xff, 0xab, 0xa8, 0x48, 0x88, 0x67, 0xf0, 0xca, 0x5a, 0x24, 0xf8,
      0xd4, 0x2d, 0xd7, 0xe4, 0x4b, 0x53, 0x0a, 0x27, 0xdc, 0x5b, 0x58, 0xda},
     {0x35, 0x51, 0x31, 0x57, 0xe8, 0x04, 0xbd, 0x91, 0x8d, 0x04, 0xde, 0x20,
      0x27, 0x78, 0xb8, 0x1a, 0x6f, 0xc7, 0xad, 0x8a, 0xa5, 0x41, 0xee, 0x94,
      0x11, 0x6a, 0x0f, 0x18, 0x46, 0x67, 0x25, 0xd7, 0x5e, 0x71, 0xc6, 0x94,
      0x2b, 0xf0, 0x44, 0xb1, 0xb0, 0xec, 0xba, 0x19, 0xdb, 0x33, 0xe0, 0xde},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 28
    {28,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
      0x14, 0x1b, 0x9e, 0xe5, 0x31, 0x0e, 0xa8, 0x17, 0x01, 0x31, 0xb6, 0x04,
      0x48, 0x4a, 0x6d, 0x67, 0x7e, 0xd4, 0x25, 0x76, 0x04, 0x5b, 0x71, 0x43,
      0xc0, 0x26, 0x71, 0x0a, 0xe9, 0x2b, 0x27, 0x7a, 0xfb, 0xbe, 0xa0, 0xc4,
      0x45, 0x8c, 0x22, 0x0d, 0x56, 0x1e, 0x69, 0x40, 0x4d, 0xc7, 0xd8, 0x88},
     {0x10, 0x20, 0x80, 0xc0, 0x47, 0x88, 0x1d, 0x19, 0xae, 0xfb, 0x01, 0xc2,
      0x9c, 0x82, 0xa4, 0xfb, 0x32, 0x8a, 0x8e, 0xa6, 0xe6, 0xd6, 0xc9, 0x14,
      0xaf, 0x73, 0x10, 0x05, 0x07, 0xc8, 0xee, 0x49, 0x97, 0x99, 0xaa, 0xa6,
      0x46, 0xde, 0x0e, 0xa8, 0xc2, 0x72, 0x7c, 0x0b, 0x5e, 0xd2, 0x43, 0x9b},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 29
    {29,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0x70, 0x37, 0x03, 0x85, 0x41, 0x3d, 0x3e, 0xff, 0x6f, 0xa3, 0x40, 0x7b,
      0xa2, 0x4f, 0x68, 0x2c, 0x2b, 0x01, 0xb5, 0x14, 0x45, 0xdb, 0xdf, 0x5e,
      0xf7, 0xb0, 0xdd, 0x09, 0x79, 0xf1, 0x7e, 0x71, 0x3e, 0x09, 0x08, 0x15,
      0x71, 0xf1, 0xe9, 0x4d, 0xfb, 0x66, 0xbf, 0x28, 0x20, 0x02, 0xf3, 0x9f},
     {0xf6, 0x89, 0xf6, 0xe4, 0x75, 0xb4, 0xe1, 0x51, 0x62, 0x52, 0x1a, 0xca,
      0xb4, 0x63, 0x7a, 0x3c, 0xdb, 0x9c, 0xb4, 0x2a, 0xa9, 0x2f, 0x91, 0x14,
      0xb0, 0xee, 0x30, 0x0d, 0xda, 0xe8, 0x9d, 0x5e, 0xaf, 0xff, 0x34, 0x63,
      0xa1, 0xf5, 0x00, 0x4a, 0x2a, 0x1b, 0xd4, 0xae, 0xff, 0xa4, 0x7b, 0x78},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 30
    {30,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,
      0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,
      0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,
      0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,
      0x11, 0x2e, 0x19, 0x1f, 0x1f, 0x78, 0xbb, 0xc5, 0x4b, 0x6c, 0xc4, 0xf0,
      0xb1, 0xe5, 0x9a, 0xe8, 0xc6, 0xff, 0x1a, 0x07, 0xf5, 0x12, 0x8e, 0x41,
      0xdf, 0xa2, 0x82, 0x8e, 0x1b, 0x65, 0x38, 0xd4, 0xfa, 0x2c, 0xa2, 0x39,
      0x4c, 0x6a, 0xab, 0x34, 0x49, 0xdc, 0xb3, 0xfc, 0x4e, 0xb4, 0x4c, 0x09},
     {0xf3, 0x48, 0x62, 0x44, 0x11, 0x9b, 0x36, 0x32, 0xfd, 0x55, 0xbe, 0x9e,
      0x69, 0x51, 0xeb, 0x5d, 0x9c, 0x8c, 0x62, 0xf6, 0xa2, 0x70, 0x42, 0xf9,
      0x4b, 0x92, 0x41, 0x55, 0xec, 0xfd, 0x4f, 0xf8, 0x74, 0x4b, 0xa3, 0xd2,
      0x5b, 0xcf, 0x85, 0xa7, 0xb9, 0x25, 0xbd, 0x28, 0xa1, 0x2b, 0x89, 0x7f},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 31
    {31,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x7f, 0xff, 0x00, 0x01, 0xff, 0xfc, 0x00, 0x07, 0xff, 0xf0, 0x00,
      0x1f, 0xff, 0xc0, 0x00, 0x7f, 0xff, 0x00, 0x01, 0xff, 0xfc, 0x00, 0x07,
      0xff, 0xf0, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x7f, 0xff, 0x00, 0x01, 0xff,
      0xfc, 0x00, 0x07, 0xff, 0xf0, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x80, 0x00,
      0x02, 0x8a, 0x4c, 0x8d, 0xa5, 0xa0, 0x51, 0x12, 0xfe, 0x60, 0x25, 0xef,
      0x41, 0x90, 0x89, 0x69, 0xde, 0x20, 0xd0, 0x5d, 0x96, 0x68, 0xe5, 0xc8,
      0x52, 0xef, 0x2d, 0x49, 0x21, 0x72, 0xdd, 0xc2, 0xa0, 0xa6, 0x22, 0xfc,
      0x48, 0x81, 0x64, 0xfc, 0xc1, 0xa0, 0x76, 0xb8, 0x72, 0x94, 0x2a, 0xf2},
     {0x81, 0x71, 0xb7, 0xc8, 0x0d, 0x4c, 0x90, 0xbb, 0x58, 0xae, 0x54, 0x39,
      0x39, 0x21, 0xab, 0x9c, 0x5c, 0x0b, 0x31, 0x96, 0xf0, 0x45, 0xe9, 0xfe,
      0x5c, 0x8b, 0x16, 0x8f, 0x0e, 0x5f, 0x6a, 0x77, 0xe1, 0xaa, 0x34, 0xec,
      0xed, 0xc5, 0x48, 0x1c, 0xe5, 0x5a, 0xb3, 0x4c, 0x14, 0xe0, 0xf2, 0xe8},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 32
    {32,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x3b, 0x5e, 0xed, 0x80, 0x72, 0x7b, 0xcb, 0xc5, 0x11, 0x3b, 0x8a, 0x9e,
      0x4d, 0xb1, 0xc8, 0x1b, 0x1d, 0xdd, 0xc2, 0xd9, 0x9f, 0xf5, 0x6d, 0x9c,
      0x3c, 0x10, 0x54, 0x34, 0x89, 0x13, 0xbd, 0xe2, 0x96, 0x31, 0x1c, 0x4b,
      0xd2, 0xfa, 0x89, 0x9b, 0x4d, 0x0e, 0x66, 0xaa, 0xa1, 0xb6, 0xa0, 0xdd,
      0x7b, 0x7f, 0x0f, 0x28, 0xd5, 0x5e, 0x2f, 0x3a, 0x50, 0xf1, 0xf1, 0xbe,
      0xf3, 0x97, 0x68, 0x34, 0xa0, 0x5b, 0x43, 0x41, 0x8e, 0x97, 0x93, 0x03,
      0xbc, 0x03, 0x63, 0xed, 0x16, 0xd2, 0xd0, 0xb4, 0x01, 0x1c, 0xc3, 0x7b,
      0x3c, 0x06, 0xad, 0x73, 0x15, 0x4f, 0xae, 0xab, 0x79, 0x15, 0xcd, 0x87},
     {0x1f, 0xe6, 0xfe, 0xa5, 0xf0, 0x0d, 0x30, 0x05, 0xab, 0xaa, 0xe2, 0x26,
      0x7f, 0xf1, 0x8e, 0x43, 0x09, 0x15, 0x83, 0x8d, 0x87, 0x90, 0x9a, 0xb5,
      0x03, 0x88, 0x5e, 0xdf, 0x38, 0xbe, 0x76, 0x18, 0xec, 0xb3, 0x21, 0xf0,
      0xa4, 0xdf, 0x71, 0xb0, 0x91, 0x3f, 0xbf, 0x12, 0xc7, 0x6f, 0xc1, 0xf0},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 33
    {33,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x6a, 0x99, 0xa5, 0xac, 0xd4, 0xa7, 0xed, 0xb1, 0xc7, 0x07, 0xd7, 0xf8,
      0xbe, 0x12, 0xe8, 0x11, 0x40, 0x33, 0x8e, 0x3e, 0x14, 0xba, 0x56, 0x3c,
      0x70, 0x3c, 0x68, 0x1a, 0x31, 0x9a, 0x3f, 0x9c, 0xe1, 0xf9, 0x0f, 0x03,
      0x2b, 0xf8, 0x40, 0xf3, 0x75, 0x8e, 0x89, 0xcb, 0x85, 0x2c, 0xec, 0xa6,
      0x3c, 0xf9, 0x9e, 0xf0, 0x4f, 0x51, 0xa5, 0xea, 0x63, 0x0b, 0xa3, 0xf9,
      0xf9, 0x60, 0xdd, 0x59, 0x3a, 0x14, 0xc9, 0xbe, 0x39, 0xfd, 0x2b, 0xd2,
      0x15, 0xd3, 0xb4, 0xb0, 0x8a, 0xaa, 0xf8, 0x6b, 0xbf, 0x92, 0x7f, 0x2c,
      0x46, 0xe5, 0x2a, 0xb0, 0x6f, 0xb7, 0x42, 0xb8, 0x85, 0x0e, 0x52, 0x1e},
     {0xf5, 0x8a, 0xdc, 0x13, 0xff, 0x99, 0x7d, 0x38, 0x38, 0x39, 0x10, 0xdb,
      0x7b, 0xef, 0xb1, 0x76, 0x70, 0x39, 0x3a, 0x33, 0xd9, 0x5b, 0x04, 0x9c,
      0x2a, 0xa1, 0x9d, 0x76, 0x0c, 0x8e, 0x72, 0x8e, 0xce, 0xdd, 0x32, 0x16,
      0x84, 0x76, 0xb9, 0x0b, 0x26, 0xa3, 0x74, 0x2d, 0xcc, 0x12, 0x1b, 0x07},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 34
    {34,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x7c, 0x25, 0xa4, 0xf5, 0x7f, 0x76, 0xab, 0x13, 0xb2, 0x5c, 0xab, 0x3c,
      0x26, 0x5d, 0xb9, 0xd9, 0xbd, 0x92, 0x5f, 0xec, 0xbf, 0x7b, 0xf9, 0x3b,
      0xef, 0x13, 0x08, 0x77, 0x86, 0x46, 0x62, 0x8d, 0xec, 0xab, 0x06, 0x7e,
      0xd9, 0x88, 0xa9, 0x75, 0x5c, 0xd8, 0x8e, 0x88, 0xde, 0x36, 0x71, 0x04,
      0x56, 0x2e, 0xe0, 0xc5, 0x7e, 0x71, 0xd9, 0x6c, 0xef, 0xe3, 0x1b, 0x4c,
      0x40, 0x45, 0xbd, 0x40, 0x86, 0xa3, 0x8e, 0x8a, 0xb9, 0xad, 0xf2, 0xd5,
      0x56, 0x7b, 0xe3, 0x18, 0x05, 0x1d, 0x70, 0xf3, 0xaa, 0x68, 0xb7, 0x53,
      0xf2, 0x71, 0xab, 0x03, 0x2b, 0x6a, 0xbc, 0xce, 0x91, 0x9e, 0x29, 0x62},
     {0x56, 0x29, 0x96, 0x84, 0xec, 0x5c, 0xeb, 0x09, 0xba, 0x4d, 0x94, 0xd1,
      0x23, 0x10, 0x05, 0xa8, 0x26, 0xc9, 0xc0, 0x8a, 0x52, 0x19, 0xc7, 0x57,
      0xe0, 0x13, 0x6c, 0xbe, 0x8b, 0x64, 0x30, 0xba, 0xdd, 0x49, 0x25, 0x17,
      0x2f, 0x29, 0x39, 0x89, 0x1d, 0xa7, 0xc7, 0x89, 0x38, 0x50, 0x51, 0x2f},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 35
    {35,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x7f, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xfc, 0x00, 0x00,
      0x01, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xf0, 0x00,
      0x00, 0x07, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xc0,
      0x00, 0x00, 0x1f, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x04, 0x00, 0x00, 0x02,
      0x44, 0x80, 0xab, 0x33, 0xcb, 0x4b, 0xf7, 0xcb, 0x79, 0xc0, 0x24, 0xee,
      0xad, 0xe3, 0xfd, 0x64, 0x1e, 0x2f, 0x30, 0x03, 0x69, 0x84, 0x00, 0xe8,
      0x98, 0x6a, 0x73, 0x43, 0xa5, 0xda, 0x59, 0xa3, 0xb2, 0x6e, 0xea, 0x4b,
      0x41, 0x76, 0xe5, 0x32, 0x39, 0x37, 0x14, 0x37, 0xd8, 0x34, 0xa1, 0xa7},
     {0x19, 0x11, 0xa0, 0xee, 0x6a, 0xeb, 0xe2, 0x63, 0xfd, 0xcf, 0x3d, 0xb0,
      0x73, 0xf2, 0x59, 0x8c, 0xda, 0xfa, 0xbe, 0xc2, 0x12, 0x3a, 0x2f, 0x24,
      0xa2, 0x8c, 0x3d, 0x91, 0x51, 0xc8, 0x71, 0xf3, 0x2d, 0x6d, 0xc2, 0xf3,
      0x1d, 0x25, 0xaf, 0x9c, 0x49, 0x8f, 0xd6, 0x8d, 0xa2, 0x3e, 0x5b, 0xef},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 36
    {36,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
      0x07, 0x97, 0xda, 0x4c, 0x07, 0x51, 0xce, 0xd1, 0x6d, 0xe8, 0x0d, 0x16,
      0xab, 0x7c, 0x65, 0x4a, 0x5d, 0xc2, 0x7d, 0x09, 0x26, 0x26, 0xd0, 0x86,
      0x5a, 0x19, 0x2a, 0x1c, 0x5e, 0xa7, 0xc1, 0xb8, 0x8c, 0x9f, 0xca, 0xb0,
      0x57, 0x94, 0x67, 0x41, 0xe4, 0x1c, 0xc2, 0x8c, 0x80, 0xec, 0x0b, 0x9a},
     {0x15, 0x90, 0x06, 0x43, 0xe2, 0xe0, 0x58, 0x39, 0x76, 0x97, 0x4b, 0x05,
      0xf8, 0x3c, 0x7a, 0x96, 0x61, 0x14, 0x25, 0xf7, 0xc4, 0xa6, 0xeb, 0x51,
      0x91, 0x6a, 0xb9, 0x58, 0xa0, 0x37, 0xfd, 0x9c, 0xc1, 0x72, 0xbd, 0xcf,
      0xff, 0x45, 0x40, 0xa2, 0xff, 0x3c, 0xe6, 0x4e, 0x65, 0x05, 0x55, 0x7e},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 37
    {37,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xff, 0xf0, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00,
      0x00, 0x7f, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff,
      0xfc, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00,
      0x1f, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff,
      0x6c, 0x70, 0x89, 0x8a, 0xe6, 0xfb, 0x31, 0xfa, 0x2f, 0x08, 0x65, 0x62,
      0xaf, 0x2d, 0x10, 0x48, 0x6b, 0xa4, 0xc6, 0xfd, 0x5e, 0x41, 0xdf, 0xe4,
      0xaa, 0x61, 0x59, 0x8b, 0x47, 0x07, 0xa3, 0xbc, 0x27, 0x6a, 0x62, 0xfe,
      0xb1, 0xb9, 0x85, 0x57, 0xe3, 0xb1, 0x7c, 0x02, 0x5f, 0x7a, 0xdf, 0x4e},
     {0x88, 0xa5, 0x44, 0xa7, 0x69, 0xd5, 0xc3, 0x4a, 0x05, 0x14, 0x16, 0xbd,
      0x50, 0x9d, 0xfa, 0xc9, 0x11, 0x86, 0x3f, 0x60, 0x4c, 0x83, 0xea, 0x84,
      0x4b, 0xf0, 0xe4, 0xc5, 0xc2, 0x72, 0xde, 0xc8, 0x6d, 0x05, 0x7a, 0x88,
      0xb1, 0x52, 0xa9, 0x27, 0x47, 0x01, 0x93, 0x8c, 0x70, 0x59, 0x00, 0xc3},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 38
    {38,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xff, 0xff, 0xf0, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x3f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0x00, 0x00,
      0x00, 0x3f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x3f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
      0x0e, 0xb1, 0x59, 0x28, 0x58, 0xb6, 0xe6, 0xe3, 0xa1, 0x99, 0xc0, 0xf3,
      0xe7, 0xc5, 0xf0, 0xb4, 0xa9, 0x29, 0x15, 0x93, 0x6e, 0xfb, 0x8b, 0xc0,
      0x40, 0x76, 0x80, 0xeb, 0x72, 0x74, 0xbe, 0x74, 0x22, 0x15, 0x6c, 0xe8,
      0xcf, 0xc8, 0xb5, 0x05, 0xb2, 0xd9, 0x02, 0xc3, 0x99, 0x92, 0x38, 0x0f},
     {0xb7, 0xdb, 0x26, 0xb2, 0x86, 0xe7, 0x52, 0x7c, 0xb1, 0xf4, 0x54, 0x78,
      0x2f, 0xe5, 0x41, 0x86, 0x2f, 0xf0, 0xf8, 0xd7, 0xee, 0xd9, 0x60, 0xe2,
      0x28, 0x55, 0xde, 0xb7, 0xac, 0x2a, 0x69, 0x61, 0x16, 0x68, 0xc7, 0x77,
      0xc5, 0x3b, 0xb7, 0x4c, 0x2b, 0xcd, 0x40, 0xed, 0xfb, 0xf7, 0x94, 0x4d},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 39
    {39,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xf0, 0x00,
      0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff,
      0xff, 0xf0, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x03, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff,
      0x49, 0x87, 0xab, 0xae, 0x41, 0x28, 0x09, 0xc2, 0xfa, 0x48, 0xfd, 0x23,
      0xb1, 0xbd, 0xf9, 0xe6, 0x22, 0xf5, 0xa6, 0x06, 0xc4, 0x41, 0x17, 0x21,
      0x5f, 0xfa, 0x61, 0xb1, 0x8e, 0xf4, 0x6e, 0x54, 0xa7, 0xfb, 0xbf, 0x11,
      0xf9, 0xa6, 0xba, 0x59, 0xc9, 0x91, 0xb4, 0xae, 0x50, 0x1f, 0xed, 0xce},
     {0xb1, 0xe8, 0xaa, 0xb1, 0xaa, 0x63, 0x3d, 0x98, 0xdc, 0x6b, 0x76, 0x85,
      0x94, 0xe1, 0xe3, 0xed, 0xb8, 0x01, 0xa9, 0xef, 0x48, 0x3f, 0x28, 0x7c,
      0x83, 0xe1, 0x97, 0x44, 0xd2, 0xad, 0x34, 0x3a, 0xd3, 0xde, 0xbd, 0xc4,
      0xdc, 0x17, 0x82, 0x13, 0xad, 0x68, 0x76, 0xb5, 0x22, 0x84, 0xf5, 0x52},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 40
    {40,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
      0x36, 0x91, 0xfe, 0x49, 0x3d, 0x4d, 0x28, 0xbf, 0x8e, 0xe1, 0xdf, 0xec,
      0x81, 0x2d, 0x6c, 0x30, 0x6e, 0xae, 0x08, 0x42, 0x91, 0x9e, 0xda, 0x6d,
      0xc5, 0x25, 0xf0, 0xd4, 0x9a, 0xc2, 0xd2, 0x6a, 0x99, 0x22, 0x51, 0x91,
      0x21, 0x39, 0xa2, 0x93, 0x68, 0x49, 0xf9, 0xd6, 0xfa, 0x94, 0x9a, 0x68},
     {0xb0, 0xde, 0x00, 0x6f, 0x80, 0xf6, 0xf8, 0x9e, 0x4e, 0xea, 0x6e, 0x46,
      0xdf, 0xe3, 0x05, 0x15, 0x30, 0x05, 0x61, 0x2d, 0x1e, 0x90, 0x31, 0x71,
      0xec, 0x28, 0x86, 0x23, 0x09, 0x71, 0x96, 0x1b, 0x52, 0x02, 0xa9, 0xf3,
      0x18, 0x7b, 0xda, 0xc4, 0x13, 0xac, 0x24, 0xc8, 0x36, 0xad, 0xf7, 0xa0},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 41
    {41,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0x61, 0x58, 0x42, 0xaa, 0x06, 0xb0, 0x6f, 0x78, 0xf0, 0xa6, 0x6f, 0x7b,
      0xea, 0x88, 0xd4, 0xb6, 0xee, 0x59, 0x65, 0x3e, 0xea, 0xa0, 0x0d, 0xc5,
      0xe0, 0xa2, 0xb6, 0x58, 0xf9, 0x69, 0xb7, 0x1a, 0xf9, 0x0c, 0x9b, 0x4e,
      0x96, 0xbd, 0x3c, 0xa3, 0x38, 0x46, 0x95, 0x5b, 0xdc, 0xcb, 0xd3, 0x59},
     {0xca, 0x8c, 0xfa, 0x42, 0xc5, 0xe3, 0x74, 0x91, 0x4c, 0x14, 0xd6, 0x40,
      0x2b, 0x1a, 0x99, 0x20, 0x8e, 0x47, 0xe0, 0x2e, 0xc4, 0x98, 0x18, 0x91,
      0x36, 0x94, 0xea, 0x08, 0x22, 0xa2, 0xcc, 0x6c, 0x31, 0x02, 0x59, 0xa8,
      0xf3, 0xab, 0x75, 0x59, 0xb9, 0x97, 0x4b, 0xc4, 0xc2, 0xfa, 0x33, 0x7e},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 42
    {42,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfe,
      0x73, 0x21, 0x52, 0x44, 0x2f, 0xb6, 0xee, 0x5c, 0x3e, 0x6c, 0xe1, 0xd9,
      0x20, 0xc0, 0x59, 0xbc, 0x62, 0x35, 0x63, 0x81, 0x4d, 0x79, 0x04, 0x2b,
      0x90, 0x3c, 0xe6, 0x0f, 0x1d, 0x44, 0x87, 0xfc, 0xcd, 0x45, 0x0a, 0x86,
      0xda, 0x03, 0xf3, 0xe6, 0xed, 0x52, 0x5d, 0x02, 0x01, 0x7b, 0xfd, 0xb3},
     {0xed, 0xf0, 0x40, 0xba, 0xce, 0x18, 0xd9, 0x0b, 0xf9, 0xce, 0x72, 0x0d,
      0xf2, 0xa3, 0xb3, 0x1d, 0x76, 0xd9, 0x5b, 0x7e, 0xd9, 0x53, 0x0a, 0x15,
      0x9a, 0xc0, 0xb2, 0x4e, 0x82, 0xa8, 0x71, 0x03, 0x3e, 0xad, 0xa4, 0x05,
      0x52, 0xf9, 0xe6, 0x06, 0xf7, 0x11, 0x5e, 0x6a, 0x78, 0x92, 0x75, 0x11},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 43
    {43,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x1f, 0x03, 0x12, 0x3b, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x71, 0xbd, 0x1e, 0x70, 0x0c, 0x34, 0x07, 0x5c, 0x3c, 0xad, 0xe8, 0xce,
      0x29, 0xd3, 0x37, 0x24, 0xaf, 0x68, 0xa7, 0x67, 0x2b, 0x26, 0x5a, 0x4e,
      0x15, 0x70, 0x55, 0x36, 0x04, 0x40, 0xab, 0x7c, 0x46, 0x1b, 0x8e, 0x9a,
      0xc8, 0x02, 0x4e, 0x63, 0xa8, 0xb9, 0xc1, 0x7c, 0x00, 0x00, 0x00, 0x00},
     {0xea, 0x81, 0x7d, 0xff, 0x44, 0xf1, 0x94, 0x4a, 0x38, 0x44, 0x44, 0x98,
      0xf1, 0xb6, 0xc1, 0xa7, 0x0a, 0x8b, 0x91, 0x3a, 0xa3, 0x26, 0xbc, 0x2a,
      0xcc, 0x50, 0x68, 0x80, 0x5d, 0x8d, 0xdd, 0x7a, 0x5e, 0x41, 0xb8, 0xee,
      0x5b, 0x83, 0x71, 0xa1, 0xcf, 0x3f, 0x7a, 0x09, 0x42, 0x58, 0xe3, 0xa6},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 44
    {44,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x1f, 0x03, 0x12, 0x3b, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x8e, 0x42, 0xe1, 0x8f, 0xf3, 0xcb, 0xf8, 0xa3, 0xc3, 0x52, 0x17, 0x31,
      0xd6, 0x2c, 0xc8, 0xdb, 0x50, 0x97, 0x58, 0x98, 0xd4, 0xd9, 0xa5, 0xb1,
      0xea, 0x8f, 0xaa, 0xc9, 0xfb, 0xbf, 0x54, 0x82, 0xb9, 0xe4, 0x71, 0x64,
      0x37, 0xfd, 0xb1, 0x9c, 0x57, 0x46, 0x3e, 0x84, 0xff, 0xff, 0xff, 0xff},
     {0xea, 0x81, 0x7d, 0xff, 0x44, 0xf1, 0x94, 0x4a, 0x38, 0x44, 0x44, 0x98,
      0xf1, 0xb6, 0xc1, 0xa7, 0x0a, 0x8b, 0x91, 0x3a, 0xa3, 0x26, 0xbc, 0x2a,
      0xcc, 0x50, 0x68, 0x80, 0x5d, 0x8d, 0xdd, 0x7a, 0x5e, 0x41, 0xb8, 0xee,
      0x5b, 0x83, 0x71, 0xa1, 0xcf, 0x3f, 0x7a, 0x09, 0x42, 0x58, 0xe3, 0xa6},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 45
    {45,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x36, 0xa2, 0x90, 0x7c, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x7f, 0x57, 0xb6, 0x9a, 0x01, 0x47, 0x83, 0xdb,
      0xfa, 0x49, 0x67, 0xb2, 0xf9, 0xcf, 0xa6, 0x78, 0xa6, 0xf0, 0xb6, 0xe9,
      0xcf, 0xd4, 0x16, 0x48, 0xce, 0xc5, 0xb3, 0xc4, 0x98, 0xe7, 0x21, 0x52,
      0xda, 0x3f, 0x82, 0xd3, 0xda, 0x2e, 0x8e, 0x9f, 0x8e, 0xf3, 0x7b, 0x11},
     {0xbf, 0xa9, 0x3e, 0x18, 0x4f, 0x76, 0x27, 0x9f, 0xd7, 0x07, 0xd5, 0x3d,
      0xdc, 0xb3, 0x62, 0x88, 0x55, 0xcf, 0xaf, 0xb1, 0x11, 0xbc, 0xbd, 0x0b,
      0x4d, 0xf6, 0xef, 0x77, 0xae, 0xe6, 0x24, 0x92, 0x4d, 0x68, 0x16, 0x26,
      0xa1, 0x53, 0xfa, 0x4e, 0x59, 0xc9, 0x23, 0xb7, 0x1f, 0xc0, 0x90, 0xb3},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 46
    {46,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0xc1, 0x5c, 0xf3, 0x98, 0x1e, 0xab, 0x61, 0x02, 0xc3, 0x9f, 0x9a, 0x92,
      0x5a, 0xa1, 0x30, 0x9d, 0xb5, 0x9c, 0x2c, 0x02, 0xa5, 0x44, 0x11, 0x92,
      0x8d, 0x73, 0xc3, 0x94, 0x5d, 0x15, 0x78, 0x48, 0xdc, 0x36, 0x95, 0x9e,
      0xfe, 0xf7, 0x49, 0x5c, 0x85, 0x28, 0xea, 0x28, 0x4c, 0x1c, 0x97, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xcb, 0x52, 0xa5, 0xb3, 0x76, 0x36, 0xb4,
      0x21, 0x00, 0x73, 0x42, 0x52, 0x74, 0x42, 0x2b, 0x0a, 0xd6, 0xda, 0xda,
      0x39, 0x37, 0xc9, 0x46, 0x12, 0xa4, 0x8c, 0xb2, 0x89, 0x2d, 0xfb, 0xc0,
      0x6c, 0x32, 0xad, 0xdb, 0xbe, 0x9d, 0xea, 0x14, 0x2f, 0x09, 0xc3, 0xba,
      0x5e, 0x58, 0xf1, 0x54, 0xee, 0x20, 0x8a, 0x84, 0xe0, 0xc7, 0x3a, 0x06,
      0x20, 0x87, 0xb4, 0x9c, 0x2d, 0x13, 0x6b, 0x32, 0xce, 0xab, 0x49, 0xad,
      0x9d, 0xdc, 0xfa, 0xe9, 0x24, 0x40, 0x29, 0xc4, 0x12, 0x0c, 0xbb, 0x9f,
      0xf6, 0x08, 0x7f, 0x2e, 0xbe, 0x56, 0x88, 0xc2, 0x07, 0x97, 0xa6, 0x47,
      0xc8, 0x71, 0xd0, 0xd1, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x36, 0xa2, 0x90, 0x7c, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0x80, 0xa8, 0x49, 0x65, 0xfe, 0xb8, 0x7c, 0x24,
      0x05, 0xb6, 0x98, 0x4d, 0x06, 0x30, 0x59, 0x87, 0x59, 0x0f, 0x49, 0x16,
      0x30, 0x2b, 0xe9, 0xb7, 0x31, 0x3a, 0x4c, 0x3a, 0x67, 0x18, 0xde, 0xac,
      0x25, 0xc0, 0x7d, 0x2c, 0x25, 0xd1, 0x71, 0x61, 0x71, 0x0c, 0x84, 0xee},
     {0xbf, 0xa9, 0x3e, 0x18, 0x4f, 0x76, 0x27, 0x9f, 0xd7, 0x07, 0xd5, 0x3d,
      0xdc, 0xb3, 0x62, 0x88, 0x55, 0xcf, 0xaf, 0xb1, 0x11, 0xbc, 0xbd, 0x0b,
      0x4d, 0xf6, 0xef, 0x77, 0xae, 0xe6, 0x24, 0x92, 0x4d, 0x68, 0x16, 0x26,
      0xa1, 0x53, 0xfa, 0x4e, 0x59, 0xc9, 0x23, 0xb7, 0x1f, 0xc0, 0x90, 0xb3},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates
    // tcID: 47
    {47,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfe,
      0x73, 0x21, 0x52, 0x44, 0x2f, 0xb6, 0xee, 0x5c, 0x3e, 0x6c, 0xe1, 0xd9,
      0x20, 0xc0, 0x59, 0xbc, 0x62, 0x35, 0x63, 0x81, 0x4d, 0x79, 0x04, 0x2b,
      0x90, 0x3c, 0xe6, 0x0f, 0x1d, 0x44, 0x87, 0xfc, 0xcd, 0x45, 0x0a, 0x86,
      0xda, 0x03, 0xf3, 0xe6, 0xed, 0x52, 0x5d, 0x02, 0x01, 0x7b, 0xfd, 0xb3},
     {0xc3, 0xd3, 0x84, 0x50, 0xa5, 0xdf, 0xdb, 0xe6, 0x4f, 0x4b, 0x5d, 0xa3,
      0xad, 0xd4, 0xac, 0x13, 0x15, 0xf8, 0x7d, 0x11, 0x72, 0x0f, 0x29, 0xbe,
      0xb6, 0xf3, 0x61, 0x6a, 0x65, 0xeb, 0xca, 0x1d, 0x56, 0x9c, 0x0f, 0xae,
      0x5c, 0x5b, 0xbb, 0x6d, 0x14, 0x6b, 0xf9, 0x10, 0x3e, 0x64, 0x5b, 0x9f},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates
    // tcID: 48
    {48,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x18, 0x3c, 0x0d, 0x36, 0x50, 0xd3, 0x5a, 0x33, 0x42, 0x3c, 0x0d, 0x00,
      0x89, 0x6a, 0xa0, 0xaf, 0x9f, 0x34, 0x02, 0x17, 0xf4, 0x20, 0x86, 0xba,
      0x51, 0x20, 0x3d, 0x15, 0x8a, 0x60, 0xfa, 0x91, 0xee, 0x83, 0xb5, 0x20,
      0x34, 0xee, 0x61, 0x67, 0xc6, 0x59, 0x3c, 0xe6, 0x7a, 0x31, 0xc3, 0x8a,
      0x20, 0x81, 0x3d, 0x9e, 0x7e, 0xea, 0x71, 0x8d, 0x46, 0x48, 0x56, 0x50,
      0x42, 0x03, 0x66, 0xdc, 0xc1, 0xcf, 0xdb, 0x5c, 0xde, 0x93, 0xea, 0xb2,
      0x83, 0x08, 0xde, 0xf7, 0x58, 0xba, 0x4c, 0x3b, 0xa3, 0x86, 0x13, 0x9d,
      0x4a, 0x3a, 0x3b, 0xda, 0xd6, 0x4c, 0x54, 0x19, 0x2f, 0x2b, 0xde, 0x32},
     {0x18, 0x15, 0x09, 0x61, 0x85, 0x9e, 0x3e, 0xfa, 0xd6, 0x26, 0x75, 0x82,
      0xf9, 0x74, 0x17, 0xf1, 0x9e, 0xd8, 0xe7, 0xe5, 0x37, 0xb6, 0x92, 0xb9,
      0x10, 0x50, 0x94, 0x4a, 0x6f, 0xab, 0x80, 0x30, 0x41, 0x1d, 0xd9, 0x2e,
      0x94, 0x13, 0x57, 0xc7, 0x49, 0x4a, 0xf0, 0x11, 0x88, 0x40, 0xa6, 0x14},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates
    // tcID: 49
    {49,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xce, 0x5a, 0xd8, 0x11, 0xe7, 0xeb, 0x08, 0x02, 0x4e, 0x40, 0xe3, 0x0c,
      0x1c, 0xb2, 0x9c, 0xac, 0xdf, 0xc8, 0xf8, 0x09, 0xf7, 0xf0, 0x11, 0x0e,
      0x6b, 0x22, 0x5c, 0x6d, 0x83, 0x36, 0xf6, 0x0c, 0x30, 0xa5, 0x73, 0xef,
      0x1b, 0x91, 0x2f, 0x5f, 0xd3, 0x00, 0xb0, 0x61, 0x5e, 0x9f, 0xdf, 0x1f,
      0x63, 0x1b, 0xa9, 0x74, 0xbe, 0xb9, 0x54, 0x4b, 0x4a, 0x8c, 0x99, 0x45,
      0xf7, 0x2f, 0x3e, 0x5f, 0xc5, 0x69, 0x43, 0x8c, 0x43, 0x03, 0x67, 0x22,
      0x79, 0xfa, 0xfa, 0x90, 0x0e, 0x53, 0x69, 0x0a, 0xff, 0x75, 0x3d, 0xa9,
      0x2f, 0x40, 0x0a, 0xb6, 0x2d, 0xe8, 0x06, 0x7d, 0xa9, 0x9f, 0xe3, 0x7b},
     {0xcd, 0xfc, 0x94, 0x63, 0xaf, 0x89, 0x16, 0x82, 0xc5, 0x1b, 0x6f, 0x4c,
      0x96, 0x56, 0x55, 0x1c, 0x33, 0xb8, 0x07, 0x39, 0xf1, 0x77, 0x61, 0x2f,
      0x27, 0xa4, 0xb1, 0xf3, 0x7c, 0x97, 0xfd, 0x80, 0x23, 0x49, 0x5b, 0x0b,
      0xc1, 0x5c, 0x68, 0x8a, 0xb1, 0x9b, 0x7f, 0x98, 0x80, 0xef, 0xc8, 0xc5},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in left to
    // right addition chain
    // tcID: 50
    {50,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x42, 0xfa, 0xac, 0x2a, 0xe2, 0xbb, 0xad, 0x43, 0xa6, 0xe4, 0x5a, 0x79,
      0x6f, 0x1d, 0xcc, 0x70, 0xca, 0xc4, 0x44, 0xec, 0x15, 0x70, 0xac, 0x76,
      0x9d, 0x6e, 0x86, 0x20, 0x74, 0x43, 0xdb, 0x8c, 0x03, 0xa3, 0x3b, 0xa0,
      0x78, 0x62, 0xfc, 0xc6, 0x19, 0xce, 0xc8, 0x06, 0xce, 0x88, 0x26, 0xc2,
      0x77, 0x6e, 0x31, 0xdd, 0x08, 0x6c, 0x1b, 0x19, 0x32, 0x3b, 0x58, 0x08,
      0x45, 0x53, 0xbb, 0x08, 0x25, 0xd0, 0x91, 0xff, 0xb1, 0x23, 0xd2, 0x65,
      0xaf, 0xa5, 0x97, 0x0c, 0xb7, 0x2c, 0x2e, 0x68, 0x04, 0xab, 0x32, 0x78,
      0x34, 0x29, 0x96, 0x41, 0xe7, 0x0f, 0xf1, 0x42, 0x91, 0x97, 0x5b, 0xb1},
     {0xbe, 0xe4, 0x6c, 0x55, 0x18, 0xe8, 0xe2, 0xf5, 0xc7, 0xfa, 0x23, 0xf2,
      0xab, 0x8f, 0xc4, 0x3f, 0x5a, 0x74, 0x19, 0xf7, 0x03, 0x73, 0xda, 0xa1,
      0xa6, 0x74, 0x63, 0x0b, 0x16, 0x1e, 0xa3, 0x9c, 0x38, 0x1a, 0x1e, 0xaa,
      0xa9, 0x0e, 0xfd, 0x34, 0xae, 0xfa, 0x9a, 0xc6, 0xed, 0xb5, 0x3c, 0x75},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in left to
    // right addition chain
    // tcID: 51
    {51,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x6a, 0xd6, 0x6f, 0x67, 0x3d, 0x83, 0x2f, 0x8a, 0x86, 0xcf, 0xd7, 0xa6,
      0x6d, 0x21, 0x6d, 0x23, 0xa2, 0x65, 0x83, 0x23, 0x5c, 0x28, 0xec, 0xb7,
      0xb5, 0x98, 0xff, 0x8d, 0xd1, 0x13, 0x2b, 0xc6, 0xcf, 0x0d, 0xc4, 0x6a,
      0x98, 0xc8, 0x64, 0x66, 0x5f, 0x19, 0x5a, 0x99, 0x65, 0x63, 0xe5, 0x77,
      0x70, 0xaa, 0xaa, 0xdc, 0xbf, 0x36, 0x53, 0x1a, 0x31, 0x8d, 0xa9, 0x51,
      0x20, 0xd9, 0xa8, 0x00, 0x22, 0x6a, 0xc9, 0xfb, 0xff, 0x06, 0xf4, 0x78,
      0x37, 0x91, 0x1c, 0x7b, 0x95, 0xf5, 0x18, 0x7c, 0x43, 0xef, 0x95, 0x9a,
      0x4e, 0xa3, 0xe1, 0x17, 0xb8, 0x47, 0xf1, 0xdd, 0x1f, 0x8c, 0xc4, 0xb2},
     {0x1e, 0xf2, 0xe4, 0x85, 0x53, 0x1e, 0x26, 0xd6, 0x9a, 0xb7, 0xc7, 0xb8,
      0xc2, 0x7c, 0x1b, 0x4b, 0xe1, 0x52, 0x72, 0x89, 0x61, 0x87, 0x56, 0x81,
      0x04, 0x26, 0x83, 0x67, 0x8c, 0x7b, 0xb4, 0xef, 0x8b, 0x59, 0xc7, 0xc1,
      0xd6, 0x2a, 0xdb, 0x5f, 0x03, 0x4b, 0xb2, 0x88, 0x6f, 0xf6, 0x91, 0xe9},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in left to
    // right addition chain
    // tcID: 52
    {52,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xf8, 0x42, 0xe8, 0xf4, 0x71, 0x51, 0x94, 0x9b, 0x5c, 0xb6, 0xcd, 0xe4,
      0xac, 0xc7, 0xa8, 0x3d, 0x90, 0x11, 0x73, 0xae, 0x31, 0x6e, 0xc4, 0x23,
      0xe1, 0xc9, 0x66, 0xc8, 0xa3, 0x96, 0x38, 0xff, 0xa6, 0xde, 0xf3, 0x16,
      0x0f, 0x7b, 0xea, 0x66, 0x49, 0x82, 0xb9, 0x63, 0x6f, 0x63, 0x9f, 0x72,
      0x70, 0x2f, 0xe1, 0xd5, 0x93, 0x45, 0x4f, 0x73, 0xd0, 0x60, 0x50, 0x65,
      0x5e, 0x28, 0xec, 0xb8, 0xcf, 0xdf, 0xe1, 0x3d, 0xcc, 0x77, 0x52, 0xbd,
      0xe3, 0x8f, 0xe0, 0x07, 0x0b, 0x43, 0xbd, 0xa5, 0xe6, 0xb7, 0x20, 0x3b,
      0x45, 0x07, 0x74, 0x71, 0x82, 0x5d, 0xf1, 0xb8, 0x16, 0xa4, 0x28, 0xc9},
     {0xa8, 0x57, 0x3b, 0x49, 0x00, 0x63, 0x62, 0xd9, 0xb7, 0x36, 0x3c, 0x50,
      0x29, 0x69, 0xb2, 0x23, 0x3b, 0x2f, 0xc5, 0x73, 0x0c, 0xf5, 0x75, 0xd4,
      0x14, 0xc5, 0x0a, 0x45, 0xf0, 0xa5, 0xb4, 0xd5, 0x18, 0xbd, 0x45, 0x02,
      0x88, 0xc8, 0x9e, 0x81, 0xd5, 0x17, 0x1e, 0xfa, 0xdb, 0xce, 0x59, 0xc5},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in left to
    // right addition chain
    // tcID: 53
    {53,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x64, 0xe6, 0x8d, 0x8a, 0x8e, 0x6d, 0x44, 0x14, 0x2f, 0xd0, 0xb3, 0x35,
      0x32, 0x75, 0xdf, 0x4b, 0xe9, 0x5b, 0x0f, 0xf9, 0x46, 0x5d, 0x11, 0x4a,
      0x18, 0xff, 0x23, 0x8f, 0xa4, 0xd3, 0x94, 0x7f, 0xf4, 0xe3, 0xfc, 0x66,
      0x97, 0x0d, 0x85, 0x73, 0x1d, 0x78, 0x4b, 0x0a, 0x17, 0x15, 0x78, 0x87,
      0xcb, 0x96, 0x1c, 0xf6, 0x36, 0xc0, 0xe8, 0xd4, 0xb5, 0xf8, 0xdb, 0x00,
      0x60, 0xc2, 0xb6, 0x99, 0xed, 0x75, 0x0e, 0x92, 0xa0, 0x5a, 0xc4, 0xda,
      0x49, 0x78, 0x0b, 0x8a, 0x48, 0x72, 0x9c, 0x6c, 0x2b, 0x86, 0x6c, 0x75,
      0x75, 0x4a, 0xfb, 0x2c, 0x7c, 0x2d, 0x66, 0x1e, 0xcf, 0x64, 0x0c, 0xc2},
     {0x33, 0xf9, 0xaa, 0x30, 0x84, 0x45, 0xcd, 0xc2, 0xd1, 0x59, 0xcd, 0x39,
      0xc3, 0x3b, 0x49, 0x53, 0x82, 0xff, 0x8b, 0x9e, 0x21, 0xb6, 0xd1, 0xb1,
      0x60, 0x57, 0x7a, 0x4b, 0x3c, 0x5d, 0xaf, 0x00, 0xb8, 0xda, 0xd3, 0xc8,
      0x38, 0x52, 0xf1, 0x8f, 0x27, 0xa4, 0x40, 0x2c, 0xe9, 0x44, 0x21, 0xee},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in left to
    // right addition chain
    // tcID: 54
    {54,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x23, 0x7e, 0x5a, 0x05, 0xa3, 0xb9, 0xdd, 0x16, 0xf2, 0x7d, 0x1c, 0xc0,
      0x4d, 0x16, 0xf1, 0x9e, 0xc3, 0xd2, 0x78, 0x81, 0xb9, 0x0c, 0x20, 0x49,
      0xfd, 0x26, 0x65, 0xce, 0xc7, 0xea, 0xae, 0x1c, 0xac, 0xde, 0xd4, 0xe0,
      0xf8, 0xab, 0xba, 0x5a, 0x64, 0xd4, 0x18, 0x3a, 0x71, 0x44, 0x9d, 0x9b,
      0x74, 0x10, 0x73, 0xdc, 0x25, 0x94, 0xd0, 0x2a, 0xc9, 0xa8, 0x89, 0x88,
      0xe5, 0x1d, 0x7b, 0xee, 0x22, 0x11, 0x19, 0x62, 0xf6, 0x37, 0x48, 0xef,
      0xdc, 0x8c, 0x31, 0x1f, 0x63, 0x1a, 0xe8, 0x68, 0x0c, 0x89, 0x96, 0x02,
      0x8d, 0xa4, 0xe9, 0x56, 0xac, 0x12, 0x84, 0xd0, 0xc0, 0x16, 0x14, 0xf5},
     {0xdd, 0xf7, 0xfe, 0xa5, 0x2b, 0x92, 0xe1, 0x54, 0x4f, 0xb1, 0xc7, 0xce,
      0x22, 0x74, 0x40, 0x9b, 0xca, 0x17, 0x04, 0xf4, 0x4b, 0xc0, 0xae, 0x1a,
      0x6a, 0x8b, 0x38, 0x8e, 0xaf, 0x31, 0x6c, 0x90, 0xbc, 0xe9, 0x9b, 0x0c,
      0x20, 0x3f, 0x75, 0x56, 0xe5, 0xba, 0xaa, 0x26, 0xc6, 0xb7, 0xad, 0x6d},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in left to
    // right addition chain
    // tcID: 55
    {55,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x81, 0x0f, 0xac, 0xe9, 0x95, 0x12, 0xbe, 0xc2, 0x59, 0xd5, 0x75, 0x22,
      0x9d, 0x95, 0x86, 0x79, 0x1b, 0xdf, 0xb1, 0xb2, 0x21, 0xd2, 0x3c, 0x17,
      0x38, 0xe4, 0xf9, 0xaf, 0x04, 0x98, 0xf5, 0x4b, 0x18, 0xcc, 0x0c, 0xbb,
      0x01, 0xb6, 0x4c, 0xf3, 0x41, 0x1e, 0xc4, 0xb6, 0x84, 0x80, 0xdb, 0x6d,
      0x6c, 0x06, 0xe6, 0x20, 0x91, 0x88, 0xf3, 0x54, 0x32, 0x3b, 0x4d, 0xb6,
      0xf5, 0x4f, 0x2b, 0x1d, 0xfc, 0x5c, 0x1c, 0x3d, 0xd4, 0xfe, 0xf0, 0xcb,
      0x37, 0x9a, 0x7d, 0x7e, 0xa0, 0x85, 0xac, 0xda, 0xc9, 0xe6, 0x0e, 0x04,
      0xf8, 0xdb, 0x48, 0x8b, 0xe9, 0x7f, 0x81, 0xde, 0xd6, 0x6e, 0xa3, 0x3e},
     {0xd2, 0x28, 0x7c, 0xcb, 0x64, 0x2a, 0x76, 0xe0, 0x01, 0x12, 0x4d, 0xba,
      0x6c, 0x6c, 0xe1, 0x9e, 0x82, 0x53, 0x66, 0x90, 0xab, 0xf5, 0x42, 0x10,
      0x4c, 0xbd, 0x45, 0xc8, 0x70, 0x8e, 0x46, 0x2d, 0x8c, 0xe0, 0x6e, 0x05,
      0xad, 0x2a, 0x0f, 0xea, 0x4d, 0x68, 0x49, 0x2f, 0xcf, 0x37, 0x6a, 0xfe},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in left to
    // right addition chain
    // tcID: 56
    {56,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xf0, 0xb0, 0x02, 0x71, 0xa2, 0xbd, 0xde, 0x4b, 0xdd, 0xbd, 0xac, 0x00,
      0x40, 0x6a, 0xdf, 0x05, 0x6d, 0x32, 0xb9, 0xb0, 0x3f, 0x4b, 0xd2, 0x9c,
      0xc6, 0x60, 0x93, 0xdf, 0x22, 0xe5, 0xda, 0x09, 0xfe, 0x48, 0xca, 0xbf,
      0xc8, 0xd4, 0x4b, 0xf1, 0x36, 0xb5, 0xbe, 0x27, 0x5c, 0x7f, 0x53, 0xf6,
      0x6c, 0xcd, 0xd0, 0xd0, 0x03, 0x54, 0xa3, 0x07, 0xfe, 0xa0, 0x09, 0x10,
      0x70, 0xb6, 0x1f, 0xa9, 0xe2, 0xda, 0x1e, 0x2f, 0x32, 0x9f, 0xad, 0x68,
      0x01, 0x34, 0x49, 0xec, 0xf4, 0x77, 0xfe, 0x33, 0x45, 0x80, 0x39, 0xba,
      0xc9, 0x11, 0x10, 0x4d, 0xa6, 0x2c, 0x29, 0xc0, 0x81, 0x92, 0xa3, 0x15},
     {0x36, 0x15, 0x1b, 0x0d, 0x1c, 0x1b, 0x28, 0xac, 0x06, 0x2e, 0x08, 0x29,
      0xf4, 0x1b, 0xd5, 0x50, 0x44, 0xda, 0xe6, 0xf1, 0xda, 0xf3, 0x0a, 0xb3,
      0xff, 0x41, 0x48, 0xa8, 0x3c, 0xcb, 0xcc, 0xf5, 0x07, 0xbe, 0xf7, 0x34,
      0x0c, 0x95, 0x44, 0xf0, 0x47, 0xf5, 0x54, 0xc7, 0x12, 0x72, 0xae, 0x24},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in left to
    // right addition chain
    // tcID: 57
    {57,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xf8, 0x2c, 0xbb, 0xaf, 0x1c, 0x9b, 0x60, 0x63, 0xa1, 0xb5, 0x05, 0x58,
      0x07, 0x66, 0xb1, 0x44, 0x6b, 0x6b, 0x5a, 0x99, 0x01, 0x51, 0x70, 0x3e,
      0x7a, 0xfd, 0x8a, 0x31, 0x75, 0x38, 0x7f, 0xae, 0x56, 0x70, 0x81, 0x01,
      0x9e, 0x0f, 0xdb, 0xa7, 0x96, 0x4e, 0xd6, 0xc0, 0xe4, 0xd0, 0xe4, 0x5e,
      0xcf, 0x37, 0x9b, 0xc1, 0xed, 0xa3, 0x0c, 0xe4, 0xfa, 0x56, 0x01, 0x06,
      0xb3, 0xd0, 0x9b, 0xf3, 0x8e, 0x9f, 0xcb, 0xec, 0x3e, 0xad, 0xc9, 0xe1,
      0x2c, 0x56, 0x22, 0xc0, 0x11, 0x30, 0xc8, 0x70, 0xc6, 0x13, 0x64, 0x98,
      0xf5, 0x2b, 0xf6, 0x2f, 0x39, 0x87, 0xde, 0xfd, 0x29, 0x4d, 0xf3, 0x3c},
     {0x24, 0x51, 0xfd, 0x97, 0x98, 0x64, 0x16, 0x94, 0x62, 0xa7, 0x7d, 0x74,
      0x2a, 0xdb, 0x6f, 0x45, 0x05, 0xf2, 0xdb, 0x95, 0x6d, 0x2d, 0x2d, 0xea,
      0x5b, 0x05, 0xe4, 0x0f, 0x40, 0xf2, 0x65, 0x4f, 0xc1, 0x7d, 0x1c, 0xd1,
      0xd3, 0xb3, 0x53, 0x32, 0x2b, 0xf0, 0xd1, 0xf3, 0xcf, 0x82, 0x8c, 0x49},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in left to
    // right addition chain
    // tcID: 58
    {58,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xcc, 0xec, 0x11, 0x70, 0x25, 0xee, 0xce, 0x29, 0xe0, 0xed, 0x07, 0x7d,
      0x98, 0x67, 0x87, 0x38, 0xfd, 0x1a, 0x5c, 0xca, 0x20, 0xe4, 0x0b, 0xb3,
      0x22, 0xa4, 0x05, 0x66, 0x83, 0x12, 0x43, 0xda, 0xc8, 0x06, 0x55, 0x5b,
      0x85, 0x08, 0xf4, 0xea, 0xa6, 0x8b, 0xeb, 0x4e, 0x78, 0xed, 0x91, 0x76,
      0x86, 0x41, 0x5f, 0x11, 0x23, 0x2c, 0x5e, 0xcb, 0x9f, 0x80, 0x5b, 0x0d,
      0xcc, 0x6c, 0xe0, 0x6b, 0x57, 0xfd, 0xf4, 0xe4, 0xae, 0x4e, 0x6d, 0x82,
      0x24, 0x72, 0xd6, 0x72, 0x5a, 0x9c, 0x1d, 0xa4, 0x1c, 0x2f, 0xee, 0x15,
      0x19, 0x58, 0x6c, 0x50, 0x2b, 0xbb, 0x1a, 0x4c, 0xe2, 0x58, 0x28, 0x63},
     {0x0b, 0x3c, 0x06, 0xfb, 0x8c, 0x7c, 0x31, 0xa9, 0x6f, 0xa6, 0xdc, 0x80,
      0x25, 0x01, 0x43, 0xe3, 0x9a, 0xf9, 0xe5, 0xc2, 0x01, 0xfd, 0xbe, 0x92,
      0x24, 0x57, 0x71, 0xe3, 0x45, 0xcf, 0x78, 0x7f, 0x99, 0x23, 0x4e, 0xcc,
      0x1d, 0x68, 0x70, 0x59, 0x9a, 0xd5, 0x0a, 0x1c, 0xad, 0xf6, 0x87, 0xe9},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in left to
    // right addition chain
    // tcID: 59
    {59,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x1e, 0x82, 0x9b, 0xdb, 0xd8, 0xa2, 0xc1, 0x32, 0x1d, 0x04, 0x93, 0x2a,
      0xac, 0xd4, 0x29, 0x72, 0xf5, 0xb2, 0xac, 0x5b, 0x6a, 0x61, 0xb0, 0x41,
      0x21, 0x6c, 0xa9, 0x48, 0x1b, 0xb0, 0xda, 0x8a, 0xbf, 0x6d, 0x5c, 0x1b,
      0x63, 0xe8, 0x68, 0x47, 0x9f, 0x88, 0xd9, 0x13, 0x45, 0xcb, 0x91, 0x53,
      0xfc, 0xa2, 0xc5, 0x69, 0x8f, 0xd5, 0xb4, 0x04, 0xc9, 0xbc, 0x12, 0x5b,
      0xdc, 0x3c, 0x60, 0x8f, 0xe3, 0x85, 0x36, 0x7e, 0xe2, 0xb6, 0x84, 0x08,
      0xe9, 0x59, 0xb8, 0x3e, 0xc8, 0xbc, 0x3e, 0xc1, 0xe0, 0x5a, 0x6f, 0xb9,
      0x84, 0xfe, 0xdb, 0x25, 0x65, 0x74, 0x88, 0x5f, 0x5d, 0xd9, 0x89, 0x40},
     {0x53, 0x88, 0x90, 0x5a, 0xee, 0x7f, 0x82, 0x6b, 0x9a, 0x5b, 0x46, 0xfa,
      0xef, 0xfe, 0x26, 0xd4, 0x9f, 0x85, 0x66, 0xc7, 0xa8, 0xe8, 0xaf, 0x5a,
      0x16, 0x53, 0xfc, 0xfb, 0xff, 0x7c, 0x0d, 0xfd, 0xe5, 0x66, 0xf0, 0x43,
      0x40, 0x12, 0x48, 0x48, 0x6f, 0xf9, 0x1c, 0x39, 0x0f, 0x5c, 0xc6, 0xed},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in left to
    // right addition chain
    // tcID: 60
    {60,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x4d, 0xd1, 0xe1, 0xb4, 0x54, 0x81, 0x4f, 0x3b, 0xe1, 0xc6, 0x2e, 0xb8,
      0x7c, 0x12, 0x07, 0x72, 0xc2, 0x06, 0x2a, 0x3d, 0x7e, 0x54, 0x61, 0xd5,
      0x55, 0x4b, 0x39, 0x63, 0xa9, 0xfb, 0x11, 0x90, 0xdb, 0x96, 0x56, 0x95,
      0xca, 0xf5, 0x55, 0xa4, 0x5a, 0xe2, 0x5b, 0xe7, 0x3e, 0x47, 0xc3, 0x74,
      0x5b, 0xaa, 0x93, 0xfe, 0x2b, 0xfb, 0x09, 0x4f, 0xe7, 0x18, 0xc8, 0xc9,
      0xbd, 0x8e, 0x1e, 0x6e, 0x86, 0xcd, 0x62, 0x9d, 0xca, 0x0b, 0xb9, 0x1e,
      0xe9, 0x34, 0xe9, 0x34, 0x69, 0xd4, 0xff, 0xf3, 0x2a, 0x41, 0xdf, 0xd7,
      0x8c, 0x27, 0xba, 0x53, 0x4a, 0x3d, 0x59, 0x70, 0xc3, 0x88, 0xef, 0xfb},
     {0xb9, 0x20, 0x29, 0x9b, 0xa2, 0x60, 0x75, 0xd2, 0x64, 0x7c, 0xcb, 0x97,
      0x8d, 0x15, 0xa5, 0x4e, 0xf4, 0x83, 0x30, 0xdb, 0x3a, 0x87, 0x94, 0xd8,
      0x68, 0xae, 0x02, 0xbf, 0x15, 0x2b, 0x3c, 0x24, 0xff, 0xa9, 0x66, 0x89,
      0x3e, 0xa9, 0xeb, 0x5d, 0x3c, 0xce, 0x83, 0xe0, 0x23, 0x9b, 0xe0, 0x2c},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in left to
    // right addition chain
    // tcID: 61
    {61,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x94, 0x71, 0xab, 0xf4, 0xfd, 0x1b, 0x89, 0xd1, 0x4d, 0xf2, 0x32, 0x5c,
      0xb0, 0xa6, 0xbc, 0x92, 0xe7, 0x3c, 0x8e, 0xc8, 0xe0, 0x6c, 0x47, 0xb0,
      0x97, 0x8d, 0x93, 0xe9, 0x22, 0x5a, 0xdf, 0x08, 0x9d, 0x3e, 0xe4, 0xe2,
      0x5c, 0x22, 0x2b, 0x60, 0xd0, 0x21, 0x99, 0xc1, 0xb5, 0x80, 0x04, 0xc1,
      0xd1, 0xb3, 0x5b, 0xc1, 0x47, 0x5c, 0xfc, 0xf3, 0xe3, 0xa6, 0x11, 0x65,
      0x93, 0xe2, 0xca, 0x5a, 0x70, 0x34, 0x41, 0x27, 0xad, 0x90, 0x7a, 0x4a,
      0xa1, 0xd0, 0xc6, 0x61, 0x39, 0xf2, 0x87, 0xa7, 0xfe, 0x48, 0xce, 0xa5,
      0x84, 0x4a, 0x20, 0xdf, 0x5a, 0x68, 0x8b, 0x89, 0x21, 0x1f, 0x19, 0xc3},
     {0x70, 0x54, 0x21, 0xb3, 0x66, 0x18, 0x11, 0x5f, 0xcc, 0xb7, 0xce, 0x6d,
      0xb8, 0x57, 0x5f, 0xc4, 0xb3, 0xf0, 0xa2, 0x78, 0x0c, 0xe0, 0x2a, 0x34,
      0x87, 0xe4, 0x05, 0x5d, 0xd0, 0xd5, 0x18, 0x34, 0x00, 0x62, 0x70, 0xe9,
      0x92, 0xe0, 0xaf, 0xaa, 0x4c, 0x7c, 0xe0, 0xf6, 0x99, 0xf7, 0xfe, 0xa2},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in left to
    // right addition chain
    // tcID: 62
    {62,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x97, 0x04, 0x6c, 0x44, 0x38, 0xb0, 0x40, 0x31, 0x5b, 0xe3, 0x9e, 0xe3,
      0x86, 0x9f, 0x3e, 0x87, 0x11, 0xc3, 0x19, 0x67, 0x58, 0x47, 0x6f, 0x2b,
      0x4d, 0x90, 0xcd, 0x43, 0x99, 0x66, 0x5c, 0x8c, 0x5c, 0x87, 0xf9, 0xcf,
      0x64, 0x28, 0x9c, 0x2b, 0xb0, 0x11, 0x66, 0x74, 0x2e, 0x1a, 0xe0, 0x36,
      0xb2, 0x81, 0x92, 0x2e, 0x88, 0x72, 0xb4, 0x8b, 0x7d, 0x3e, 0x13, 0x84,
      0xab, 0x4d, 0x0a, 0x92, 0xc6, 0x02, 0xac, 0xe7, 0xdf, 0x3a, 0x93, 0xa4,
      0x7d, 0xc5, 0x0c, 0x8c, 0x2e, 0x5e, 0x8a, 0x87, 0x5d, 0x2d, 0x92, 0x7f,
      0x72, 0x01, 0xce, 0x11, 0xfd, 0x8d, 0xf8, 0x12, 0xba, 0xa1, 0xe4, 0xf8},
     {0x3c, 0x51, 0x00, 0x06, 0xf8, 0x65, 0x8f, 0x3f, 0xa4, 0x14, 0xfe, 0xf9,
      0x72, 0x3d, 0x63, 0x4a, 0x17, 0x9d, 0xb7, 0xaa, 0xf0, 0xb7, 0x06, 0x8b,
      0x76, 0x96, 0xcf, 0xf9, 0x3f, 0x88, 0xe0, 0x41, 0x36, 0xdf, 0xda, 0xc6,
      0x83, 0x49, 0x78, 0x1b, 0xf0, 0x5a, 0x78, 0x7a, 0xe1, 0x9e, 0x90, 0x21},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in left to
    // right addition chain
    // tcID: 63
    {63,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x8e, 0x3d, 0xae, 0x50, 0x0f, 0xe2, 0xc6, 0x45, 0xaa, 0xb1, 0x53, 0x79,
      0x17, 0x06, 0x82, 0x50, 0x31, 0x54, 0xaf, 0x1f, 0xd0, 0xa2, 0x1f, 0xfd,
      0x2e, 0x34, 0xf0, 0x50, 0x1c, 0x51, 0x85, 0x07, 0xe0, 0xeb, 0xf4, 0x5d,
      0x7c, 0xb8, 0x65, 0x3f, 0xd5, 0x7b, 0xf1, 0xf8, 0x94, 0xf2, 0xa5, 0x52,
      0xcb, 0x69, 0xaf, 0x7e, 0x00, 0x9d, 0x43, 0xbd, 0x6e, 0x68, 0x8b, 0xf2,
      0x8f, 0x5e, 0x28, 0x15, 0xf3, 0xc9, 0xf4, 0xfa, 0xb1, 0xd8, 0x29, 0xd2,
      0x9f, 0x05, 0x31, 0x2b, 0xad, 0x99, 0xd7, 0x5c, 0x25, 0x18, 0xd2, 0xa3,
      0x01, 0xa7, 0x4d, 0x5e, 0xce, 0xe1, 0x33, 0x35, 0x82, 0xd7, 0x9c, 0x14},
     {0x24, 0x89, 0x67, 0xaf, 0xa3, 0x63, 0x86, 0xcf, 0xea, 0xa2, 0x21, 0x48,
      0x47, 0xc7, 0xc8, 0xc3, 0x2a, 0x89, 0x1a, 0x24, 0x38, 0xb8, 0x36, 0x65,
      0xf9, 0x9e, 0x5f, 0xe7, 0xab, 0x6d, 0xd8, 0x63, 0x53, 0xff, 0x7a, 0x8b,
      0x15, 0xd4, 0xbe, 0x4e, 0x12, 0x77, 0xc7, 0x21, 0xd6, 0x9c, 0xbb, 0xa7},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in left to
    // right addition chain
    // tcID: 64
    {64,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x1f, 0xca, 0x8f, 0x96, 0x95, 0x65, 0x0a, 0x02, 0xd6, 0xfb, 0x80, 0x49,
      0xb1, 0x53, 0x1a, 0x37, 0x83, 0xe4, 0x49, 0xdf, 0x75, 0xa9, 0x8d, 0x45,
      0x99, 0x9f, 0xb9, 0x85, 0x7c, 0x3e, 0x75, 0x62, 0x19, 0xd4, 0x8b, 0x2c,
      0x84, 0xd5, 0x14, 0x3f, 0x08, 0xc2, 0xab, 0x09, 0x7b, 0x36, 0x5a, 0x33,
      0x45, 0xaa, 0x19, 0x7e, 0x10, 0xc6, 0x59, 0xd9, 0xc5, 0x3f, 0xa7, 0x54,
      0xf1, 0x12, 0xd7, 0x79, 0x73, 0x10, 0x7e, 0xe3, 0x5c, 0x3a, 0xee, 0x3b,
      0x0b, 0x13, 0x22, 0xb3, 0x62, 0xfa, 0x08, 0x49, 0x7c, 0x09, 0x7c, 0x18,
      0x81, 0x93, 0x4e, 0x36, 0xce, 0xbd, 0x5e, 0x18, 0xe9, 0x24, 0x0c, 0xb6},
     {0xa4, 0x54, 0xff, 0x4d, 0x94, 0x45, 0x87, 0xa1, 0x88, 0xe7, 0xeb, 0xac,
      0xcd, 0x97, 0x64, 0x9a, 0xb0, 0xcf, 0x83, 0xf8, 0xf8, 0xd1, 0x9b, 0x36,
      0x53, 0xa2, 0xe6, 0x21, 0x20, 0x6d, 0x39, 0x92, 0x86, 0x8b, 0x5a, 0x57,
      0x65, 0xd1, 0xfa, 0x76, 0x2f, 0x0e, 0x3b, 0x01, 0x61, 0xa6, 0x80, 0x9b},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in left to
    // right addition chain
    // tcID: 65
    {65,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x73, 0x1b, 0xa7, 0x84, 0xe2, 0xed, 0x21, 0xf4, 0xa4, 0xa2, 0xb4, 0xdd,
      0x48, 0x77, 0xae, 0xc2, 0xfc, 0xd5, 0x90, 0x31, 0xf8, 0x01, 0x93, 0xb9,
      0x55, 0x8b, 0xbc, 0x1c, 0xf7, 0xfe, 0x67, 0x04, 0x46, 0x94, 0x43, 0xfc,
      0x7f, 0x39, 0x8e, 0x8b, 0xec, 0x40, 0x86, 0xf8, 0x8a, 0xa7, 0x6a, 0xa2,
      0x6c, 0x38, 0x9a, 0xcf, 0xd5, 0x1f, 0x69, 0xc8, 0x9a, 0x15, 0x3b, 0xfa,
      0xdb, 0x5d, 0x70, 0x3a, 0x36, 0xcb, 0x12, 0xa4, 0xd8, 0x5f, 0x55, 0x17,
      0xcf, 0x46, 0x2b, 0xf5, 0xd0, 0x2a, 0xbf, 0x7d, 0x19, 0x72, 0x2f, 0x48,
      0x0e, 0xaf, 0x1a, 0x26, 0x17, 0xcb, 0xa1, 0x94, 0x1e, 0x1c, 0x76, 0xb6},
     {0x99, 0x78, 0x0e, 0xd2, 0x15, 0xdc, 0x41, 0x7f, 0x79, 0x8c, 0x24, 0x32,
      0x7c, 0x3c, 0xaf, 0x22, 0xf3, 0x68, 0x5e, 0x5c, 0xf2, 0xab, 0x83, 0x5f,
      0xc5, 0x4b, 0x42, 0x81, 0x17, 0xb7, 0xd1, 0x7f, 0x0f, 0xeb, 0x63, 0xf1,
      0x75, 0x54, 0x68, 0x15, 0x7f, 0x32, 0x37, 0xb8, 0x11, 0x7d, 0xff, 0xa6},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in left to
    // right addition chain
    // tcID: 66
    {66,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x87, 0x25, 0xcb, 0x75, 0x4b, 0x55, 0x27, 0xa3, 0xb0, 0x53, 0xd6, 0x3e,
      0x0c, 0x4b, 0x09, 0x7e, 0x4c, 0x34, 0xc5, 0xd7, 0x31, 0xab, 0x5c, 0xd4,
      0x72, 0x86, 0x50, 0xa6, 0x18, 0xb4, 0xde, 0xd4, 0xbf, 0x92, 0x14, 0xd7,
      0x93, 0xad, 0x74, 0xcf, 0xc4, 0x70, 0xe3, 0x5c, 0x54, 0x93, 0xa4, 0xb4,
      0x20, 0xa3, 0xc5, 0x00, 0x49, 0xa4, 0x27, 0x91, 0x72, 0x1b, 0xc5, 0x0d,
      0x5f, 0x60, 0x8c, 0xb2, 0x72, 0xb6, 0x0a, 0x55, 0x45, 0xdb, 0x06, 0x08,
      0x85, 0x5b, 0xac, 0x8f, 0xbf, 0xa9, 0x39, 0x90, 0xd6, 0xb8, 0x0e, 0x30,
      0x41, 0x77, 0x3e, 0x10, 0x93, 0x7d, 0x83, 0x70, 0x10, 0xca, 0xe6, 0x40},
     {0xd7, 0x38, 0xb7, 0x37, 0x3f, 0xe9, 0x78, 0xf2, 0x7b, 0x19, 0x4f, 0x69,
      0xed, 0xd5, 0xc4, 0x21, 0xb9, 0x89, 0x22, 0xf5, 0xe3, 0x13, 0xb7, 0x68,
      0x59, 0xa9, 0x35, 0x7a, 0x1f, 0xaf, 0x42, 0xed, 0x0e, 0x06, 0xdc, 0x13,
      0xd5, 0x58, 0x43, 0x35, 0x75, 0x38, 0xce, 0x7f, 0x41, 0x27, 0xce, 0xe1},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in left to
    // right addition chain
    // tcID: 67
    {67,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x9c, 0x7a, 0x59, 0x4e, 0xaf, 0x2d, 0xdf, 0x3c, 0x8a, 0xb6, 0xc6, 0xe9,
      0x4f, 0x1e, 0xc0, 0x11, 0xda, 0xc9, 0xfa, 0x42, 0xbd, 0x27, 0xdf, 0x2f,
      0xbe, 0x40, 0x2a, 0xc9, 0x49, 0xd3, 0xa2, 0xc6, 0x76, 0xb6, 0x84, 0xa2,
      0x4c, 0x99, 0xf7, 0xd1, 0xb7, 0xe8, 0x9e, 0x9f, 0x8a, 0x06, 0x34, 0xeb,
      0x3b, 0x83, 0x09, 0x5c, 0x7a, 0x1c, 0xd6, 0xaa, 0x93, 0x32, 0x46, 0x0e,
      0xcb, 0xf2, 0x57, 0xf7, 0xaf, 0xa4, 0x49, 0x60, 0x8b, 0x9e, 0x0d, 0xdd,
      0x15, 0x29, 0x2b, 0x87, 0x5a, 0xd2, 0xfd, 0x06, 0x9d, 0xc9, 0x27, 0xce,
      0x00, 0xa4, 0xb5, 0xe6, 0x79, 0x33, 0x80, 0x23, 0xbd, 0x3a, 0x4e, 0x6c},
     {0xd9, 0xcc, 0x86, 0x1d, 0xb3, 0x05, 0xb0, 0x4a, 0x27, 0x3d, 0x6b, 0x55,
      0x34, 0x8e, 0xf9, 0xf0, 0xa0, 0xa2, 0xae, 0xdf, 0x8b, 0x3d, 0x04, 0x1a,
      0x19, 0xe2, 0x63, 0xed, 0x6a, 0xe2, 0xe0, 0x1e, 0x43, 0x9a, 0x46, 0x82,
      0x30, 0x98, 0xf2, 0xaa, 0xa4, 0x86, 0x7d, 0x4f, 0x08, 0x89, 0x1e, 0x36},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in left to
    // right addition chain
    // tcID: 68
    {68,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x21, 0xb1, 0xaa, 0x35, 0x9d, 0x72, 0xff, 0x33, 0xa8, 0x4e, 0xc9, 0x62,
      0x14, 0x83, 0xe6, 0x58, 0x81, 0xd4, 0xfa, 0x8c, 0xe6, 0xdf, 0x36, 0x69,
      0xe0, 0xab, 0xbb, 0x9f, 0x6b, 0xf8, 0xd0, 0xee, 0x3d, 0x98, 0x62, 0xa7,
      0xdf, 0xb4, 0x52, 0x13, 0xe3, 0x9f, 0xfa, 0xc7, 0xb3, 0xe1, 0xed, 0x87,
      0x1f, 0x5e, 0x59, 0xcd, 0xa5, 0xa5, 0xb8, 0x61, 0xab, 0x3e, 0xb8, 0x6c,
      0xaa, 0x7c, 0x6e, 0x85, 0x93, 0x36, 0x76, 0xef, 0xe6, 0x60, 0xdf, 0xf8,
      0xac, 0x56, 0x25, 0xec, 0x8a, 0x76, 0x30, 0xa9, 0xcb, 0xa9, 0xeb, 0x3f,
      0xc1, 0x49, 0xd3, 0xef, 0x37, 0x9d, 0x4a, 0x5e, 0xc1, 0x74, 0xd2, 0x37},
     {0xc5, 0x92, 0x81, 0xd0, 0x9f, 0x44, 0xf6, 0x79, 0x29, 0x4a, 0xee, 0x56,
      0x68, 0xeb, 0x53, 0x8d, 0x50, 0x3e, 0xf2, 0x5a, 0xac, 0x59, 0x16, 0x14,
      0xb4, 0x6f, 0x52, 0x5d, 0x8c, 0x0b, 0x10, 0x9a, 0xb1, 0x29, 0x67, 0x49,
      0x63, 0x50, 0x0a, 0xd7, 0xb6, 0x26, 0x89, 0x41, 0xa2, 0x8c, 0x00, 0x67},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in left to
    // right addition chain
    // tcID: 69
    {69,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe1, 0xad, 0x2b, 0x68, 0xfa, 0x69, 0x45, 0x65, 0x74, 0xde, 0x95, 0xb1,
      0xe0, 0x48, 0xb0, 0x71, 0x50, 0x09, 0x40, 0x9e, 0xf5, 0xcc, 0x27, 0x0b,
      0xe5, 0x1f, 0xdd, 0x40, 0xb4, 0xf6, 0x5b, 0x1a, 0xde, 0x67, 0x93, 0x8a,
      0x6a, 0x6d, 0x72, 0x5b, 0x01, 0x31, 0x0f, 0x22, 0x53, 0xa3, 0x8c, 0xf4,
      0x44, 0xf7, 0x26, 0xb3, 0xeb, 0x5c, 0x5d, 0xdc, 0x25, 0x7d, 0x6d, 0x9b,
      0xda, 0x9b, 0xfa, 0x60, 0xbe, 0xc6, 0xa0, 0x7f, 0xe0, 0x7d, 0xae, 0x96,
      0x75, 0x11, 0x31, 0x43, 0x70, 0xd3, 0xa4, 0xe0, 0x41, 0xc3, 0x4f, 0x1c,
      0xb4, 0x9f, 0xe6, 0xb7, 0x06, 0x63, 0xf0, 0x20, 0x48, 0x8e, 0x98, 0xa8},
     {0x9e, 0xb7, 0x0f, 0x89, 0x49, 0x86, 0x1c, 0x30, 0xf2, 0x45, 0x69, 0x90,
      0xab, 0xe4, 0xd3, 0x45, 0x55, 0x00, 0x08, 0xb8, 0x53, 0x19, 0x01, 0x52,
      0x13, 0x61, 0xaa, 0xa1, 0x72, 0x96, 0xdb, 0xca, 0x06, 0xfb, 0x3c, 0x87,
      0xe8, 0xf4, 0x59, 0x2b, 0x7d, 0xc5, 0xd1, 0x99, 0x7c, 0x58, 0xc0, 0x76},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in left to
    // right addition chain
    // tcID: 70
    {70,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x93,
      0x8f, 0x3d, 0xbe, 0x37, 0x13, 0x5c, 0xd8, 0xc8, 0xc0, 0x41, 0x82, 0x95,
      0x2f, 0x6e, 0x6f, 0x9b, 0xfe, 0x7a, 0x4c, 0xff, 0x4e, 0xac, 0xf9, 0x06,
      0x12, 0xa4, 0x88, 0x65, 0xdc, 0x43, 0xe9, 0xb5, 0xd2, 0x30, 0xf7, 0x61,
      0xd1, 0xfc, 0x4d, 0xfb, 0x69, 0xbe, 0x20, 0xe8, 0x4c, 0xcc, 0x8f, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x8a, 0x9c, 0x52, 0x27, 0xd1, 0x39, 0x02,
      0x59, 0xb6, 0x75, 0x09, 0x59, 0xaf, 0x6e, 0xf9, 0xbc, 0x0a, 0x51, 0xb0,
      0xf0, 0x85, 0xc9, 0x99, 0x33, 0xf5, 0x6a, 0x76, 0x3a, 0x60, 0xb5, 0x90,
      0xf7, 0x11, 0x5f, 0x0c, 0x6c, 0xf1, 0xe3, 0x0d, 0x35, 0x5e, 0xbb, 0xe7,
      0x60, 0x1e, 0xcb, 0x4d, 0x1a, 0xbb, 0xd2, 0xdf, 0x65, 0xae, 0x39, 0x9a,
      0x71, 0x78, 0x0d, 0xe1, 0x1e, 0x3c, 0xf8, 0xf1, 0xaa, 0x32, 0x95, 0x2f,
      0xc4, 0xb1, 0x48, 0x82, 0x84, 0x45, 0x2f, 0x43, 0xa9, 0x0b, 0x9d, 0xd1,
      0xf3, 0x1a, 0x3a, 0xac, 0xa7, 0x19, 0x11, 0x4f, 0xe7, 0x05, 0x37, 0xf9,
      0xc6, 0xde, 0xc0, 0x79, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x0b, 0xad, 0x67, 0xea, 0x0c, 0xca, 0x96, 0x0e, 0xd3, 0xea, 0x05, 0x88,
      0xd5, 0xee, 0xef, 0x36, 0x6c, 0x24, 0x34, 0x2a, 0xb3, 0xe4, 0x66, 0x02,
      0x89, 0x1d, 0x1a, 0xdb, 0x4d, 0x85, 0xd8, 0x0d, 0xd2, 0x42, 0x96, 0x2c,
      0x56, 0x54, 0xbd, 0x6a, 0xf5, 0x91, 0x3a, 0xea, 0xef, 0xab, 0x27, 0xad,
      0x9a, 0x07, 0xb4, 0x19, 0x71, 0x80, 0xc9, 0x86, 0x9a, 0xf7, 0x95, 0xf6,
      0x96, 0xfd, 0xf6, 0xf2, 0x5c, 0xdc, 0x66, 0x46, 0x9f, 0x4c, 0xa7, 0xca,
      0x89, 0xc5, 0xc9, 0x04, 0x63, 0x6d, 0x85, 0xf6, 0xb9, 0xa1, 0x9e, 0x7b,
      0xcf, 0x05, 0x40, 0x83, 0x1c, 0xa7, 0xaa, 0x40, 0x44, 0x6d, 0xd8, 0xe1},
     {0x45, 0xb0, 0x2f, 0xd4, 0xdd, 0x76, 0x49, 0x67, 0x01, 0xbe, 0x3b, 0x37,
      0xe6, 0x32, 0x05, 0x6c, 0xf7, 0xf6, 0x3e, 0x98, 0x08, 0xf6, 0x27, 0xfa,
      0x85, 0x8e, 0xec, 0xc5, 0xba, 0xc1, 0x6a, 0x01, 0xa9, 0x49, 0x74, 0x1b,
      0x4d, 0xe1, 0x51, 0xfe, 0x35, 0xe7, 0x74, 0xc6, 0xd1, 0xe3, 0x89, 0xe2},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in
    // precomputation or right to left addition chain
    // tcID: 71
    {71,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2c, 0x40, 0x69, 0xbc, 0x80, 0x78, 0x23, 0x6e, 0xb2, 0x3a, 0x8c, 0x4d,
      0x57, 0x5b, 0xde, 0x9b, 0x53, 0x7b, 0x13, 0xb7, 0x99, 0x89, 0x68, 0x8c,
      0x40, 0xd8, 0x9d, 0x89, 0x8a, 0x8c, 0x29, 0xbd, 0x7a, 0xc6, 0x17, 0x45,
      0x79, 0x7b, 0x7e, 0xe5, 0x5a, 0xca, 0x60, 0xea, 0x7d, 0x6c, 0x2a, 0x84,
      0x30, 0xfc, 0xfb, 0xed, 0x18, 0xa2, 0x50, 0x46, 0x61, 0xe0, 0x25, 0x3c,
      0x43, 0xe4, 0x7b, 0xe0, 0x19, 0x40, 0xe8, 0x1f, 0xcb, 0x2d, 0x65, 0xa5,
      0xe5, 0x01, 0x11, 0x19, 0x78, 0x05, 0x99, 0x49, 0xc5, 0xd2, 0x5b, 0x0b,
      0x60, 0xde, 0x78, 0x21, 0x47, 0x6b, 0x88, 0xa8, 0x34, 0x2a, 0x0b, 0xdf},
     {0x6c, 0xe9, 0xbf, 0xfb, 0x89, 0x01, 0xba, 0xa8, 0x01, 0xd1, 0xb1, 0x9e,
      0x92, 0xb5, 0xe5, 0xf4, 0x7f, 0x5b, 0xee, 0x10, 0xc1, 0x5f, 0xe4, 0x4b,
      0x82, 0x09, 0x97, 0x75, 0x72, 0xcc, 0x8b, 0xd7, 0x90, 0x2c, 0xcf, 0xc0,
      0xd7, 0xae, 0x98, 0xf6, 0xb5, 0x8b, 0xb8, 0x7f, 0x31, 0x6a, 0x57, 0x92},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in
    // precomputation or right to left addition chain
    // tcID: 72
    {72,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x44, 0xbc, 0x1c, 0xb2, 0xd4, 0x2f, 0xf9, 0x74, 0xe7, 0x2b, 0xc8, 0x83,
      0xdf, 0xf7, 0x84, 0xe8, 0x69, 0x78, 0x50, 0x1f, 0x91, 0x8e, 0xef, 0x4d,
      0x96, 0xd6, 0xe5, 0x24, 0x2d, 0xa6, 0xf5, 0x65, 0x1a, 0x29, 0xcf, 0x52,
      0x05, 0xc3, 0xdc, 0x3b, 0xe3, 0x33, 0x32, 0xfa, 0x2d, 0xef, 0xc3, 0x47,
      0x88, 0xf8, 0x8f, 0x54, 0x9e, 0xd7, 0x87, 0x32, 0x06, 0x30, 0x20, 0xdd,
      0x3f, 0xcb, 0x87, 0x25, 0x15, 0xb2, 0x5e, 0x08, 0x87, 0x00, 0xe3, 0xea,
      0xcb, 0x92, 0x5d, 0xe7, 0x67, 0xe9, 0xed, 0xf6, 0xe8, 0x9f, 0x08, 0x9c,
      0x4f, 0x9e, 0x0f, 0x4d, 0x88, 0x46, 0x98, 0x03, 0x93, 0x66, 0x7f, 0x6d},
     {0xc6, 0xdd, 0x2d, 0x37, 0x2d, 0x5a, 0x51, 0x73, 0xac, 0x63, 0xf6, 0xd5,
      0xab, 0x5d, 0xec, 0x97, 0x2e, 0x8a, 0xe4, 0x4d, 0x56, 0x6c, 0x7f, 0x82,
      0x6b, 0xeb, 0x7f, 0x26, 0x93, 0xe2, 0x00, 0xc4, 0x70, 0xdd, 0xed, 0xb1,
      0xc9, 0x92, 0x9c, 0x11, 0xed, 0x86, 0xd1, 0x35, 0xf4, 0x4c, 0x97, 0x9f},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in
    // precomputation or right to left addition chain
    // tcID: 73
    {73,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xb8, 0x24, 0xeb, 0x72, 0xc4, 0x3e, 0xdb, 0x5b, 0x3c, 0xe9, 0xaf, 0x94,
      0xeb, 0xbd, 0x33, 0xb4, 0x46, 0xb4, 0xa7, 0x23, 0x3b, 0x89, 0xaf, 0xfe,
      0x1c, 0xfa, 0x3b, 0xeb, 0x53, 0xcd, 0x19, 0x9f, 0xb1, 0x19, 0xa3, 0x56,
      0x77, 0x2b, 0xfe, 0xc1, 0x78, 0xc0, 0x3b, 0x07, 0x7d, 0xf1, 0x2f, 0x53,
      0xf9, 0x98, 0x51, 0xfb, 0xeb, 0x99, 0x71, 0xff, 0xcf, 0x29, 0xad, 0x61,
      0xba, 0x48, 0x4b, 0xd0, 0x58, 0x00, 0x36, 0xdc, 0xaa, 0x59, 0xf4, 0x07,
      0xbc, 0x88, 0xa4, 0x71, 0xcd, 0x86, 0x2b, 0x80, 0xa1, 0x63, 0xc9, 0x1a,
      0x6f, 0x64, 0x60, 0x2b, 0x6f, 0x71, 0x39, 0x59, 0xb2, 0xf6, 0xc2, 0xfd},
     {0x02, 0x99, 0xb7, 0xfc, 0x3e, 0x55, 0x06, 0x92, 0x6f, 0xea, 0x66, 0xd2,
      0x0f, 0x65, 0xb9, 0x79, 0x1f, 0xb6, 0xc8, 0x8c, 0x71, 0x79, 0xf7, 0xd4,
      0x70, 0x1d, 0x68, 0xc1, 0x34, 0x27, 0xab, 0x56, 0xac, 0x0f, 0x9e, 0x1d,
      0xa9, 0x6c, 0x1d, 0x5f, 0x3d, 0x1a, 0x65, 0xff, 0x31, 0x22, 0xc1, 0x53},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in
    // precomputation or right to left addition chain
    // tcID: 74
    {74,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x92, 0x70, 0xb8, 0xce, 0xfb, 0x61, 0xa5, 0xd5, 0x2f, 0xbb, 0x5e, 0x6b,
      0x3b, 0x62, 0x36, 0x1f, 0x3a, 0xfa, 0x5d, 0x1a, 0x6b, 0x01, 0x41, 0x9d,
      0xb9, 0x26, 0x6e, 0x2d, 0xba, 0xba, 0xb3, 0x6a, 0xea, 0x5b, 0x19, 0x61,
      0x31, 0x8e, 0xaf, 0x8f, 0x0b, 0xd7, 0xcc, 0xa7, 0x5f, 0xf2, 0xdf, 0x5b,
      0x7e, 0x53, 0x8c, 0x63, 0x01, 0x2a, 0x73, 0xf7, 0x77, 0xb2, 0x5e, 0x17,
      0x37, 0xd4, 0x4f, 0xdb, 0xc2, 0x99, 0xa7, 0x62, 0x88, 0xd7, 0xbc, 0xb5,
      0x7c, 0x84, 0x84, 0xc7, 0x1c, 0x9b, 0xb6, 0x45, 0x32, 0x45, 0xf2, 0x39,
      0xb6, 0xc6, 0xdf, 0x32, 0x89, 0x84, 0x24, 0x38, 0x3b, 0x4c, 0x03, 0x09},
     {0x13, 0xd7, 0x8b, 0x7a, 0x4d, 0xaf, 0x8d, 0xdd, 0x62, 0xe3, 0x47, 0xba,
      0x23, 0x5c, 0x36, 0x48, 0x6f, 0xb2, 0xeb, 0x4a, 0x75, 0xa3, 0xe1, 0x7a,
      0x13, 0x7e, 0xc6, 0xc2, 0xde, 0x37, 0xab, 0xaf, 0x45, 0xda, 0x92, 0xd1,
      0xcf, 0x1b, 0x29, 0x66, 0xde, 0xd8, 0xd5, 0x38, 0x1f, 0xd2, 0x31, 0x9f},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in
    // precomputation or right to left addition chain
    // tcID: 75
    {75,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x19, 0xe5, 0xc2, 0x86, 0x57, 0x47, 0x9e, 0xb4, 0x1d, 0x37, 0x18, 0xf6,
      0x3e, 0x06, 0x78, 0xbe, 0x0d, 0xaa, 0x58, 0x50, 0x2a, 0x54, 0x06, 0xd6,
      0x59, 0x13, 0x56, 0x7d, 0xf7, 0xb8, 0x6a, 0xb2, 0x5e, 0x90, 0x5e, 0xc8,
      0x46, 0x78, 0x95, 0x30, 0xd8, 0x1d, 0x8d, 0x1f, 0xc2, 0xa8, 0xca, 0xde,
      0x4a, 0xaf, 0x13, 0x1a, 0x0c, 0xcf, 0xc7, 0x9a, 0x24, 0xbc, 0x88, 0x9c,
      0x95, 0x32, 0x49, 0xee, 0x85, 0xb4, 0x9e, 0x2a, 0x1b, 0xfa, 0x52, 0x16,
      0x7f, 0xe2, 0x0d, 0xe2, 0x96, 0xe6, 0x49, 0x7e, 0xf9, 0x01, 0x4c, 0x2c,
      0xd0, 0xa0, 0x2a, 0xfb, 0xad, 0x1f, 0x9d, 0x00, 0xac, 0x3d, 0x92, 0x4d},
     {0x7b, 0x08, 0x63, 0xfc, 0x6d, 0x72, 0xc4, 0xbd, 0x05, 0x85, 0x76, 0xcf,
      0xf7, 0xa4, 0xae, 0xdf, 0x86, 0x48, 0x2d, 0x3d, 0x9b, 0xc9, 0xc5, 0xfc,
      0x55, 0xbd, 0x8f, 0xac, 0x84, 0x10, 0x7d, 0xd0, 0xbf, 0x9f, 0x27, 0xd7,
      0xe8, 0xd6, 0x24, 0xed, 0xb0, 0xaa, 0x6e, 0xf1, 0xb9, 0xcc, 0x22, 0x46},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in
    // precomputation or right to left addition chain
    // tcID: 76
    {76,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x59, 0x66, 0x6d, 0xf4, 0x47, 0xda, 0xbc, 0x38, 0x6d, 0x8d, 0xdd, 0xae,
      0x93, 0x54, 0x3d, 0xc7, 0x61, 0x51, 0xf7, 0xc1, 0xc0, 0x48, 0x58, 0x66,
      0x0d, 0x9c, 0xa8, 0xe0, 0x65, 0x5b, 0x51, 0xa7, 0x2f, 0xef, 0xfb, 0x70,
      0x85, 0xba, 0xcb, 0xde, 0x15, 0x3f, 0xea, 0x75, 0xb5, 0x71, 0x6a, 0xb5,
      0xc3, 0xc7, 0x81, 0x1d, 0x0c, 0x74, 0x35, 0xbe, 0x9e, 0x36, 0xdb, 0x00,
      0xcd, 0x29, 0xc6, 0xca, 0x87, 0x9e, 0xf9, 0x91, 0xad, 0xb1, 0x57, 0xa6,
      0xb4, 0xbf, 0x56, 0xe3, 0xde, 0x5c, 0xb3, 0x45, 0x98, 0xb7, 0x9a, 0x68,
      0x4c, 0xc3, 0xd4, 0xe2, 0x3f, 0x22, 0xd1, 0x00, 0x63, 0xe8, 0xd1, 0x9c},
     {0xfb, 0xa2, 0xbd, 0xfb, 0x54, 0xe4, 0x68, 0xa4, 0xff, 0x5a, 0xfb, 0xaa,
      0x54, 0xc7, 0x03, 0x74, 0x00, 0xd7, 0x64, 0x14, 0xc9, 0x8e, 0xaf, 0xaa,
      0x41, 0x9a, 0xda, 0xb0, 0xdf, 0x50, 0xc9, 0x69, 0x2a, 0xac, 0x67, 0xd4,
      0x4a, 0x9e, 0xfb, 0xd0, 0x0d, 0x4f, 0x9c, 0xfc, 0x20, 0x6d, 0x53, 0x7b},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in right to
    // left addition chain
    // tcID: 77
    {77,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x3b, 0xaf, 0xce, 0x9b, 0x32, 0x61, 0x6f, 0x3b, 0xde, 0x17, 0xfc, 0x98,
      0x9f, 0x1e, 0x55, 0x6f, 0x92, 0xfa, 0xf5, 0xc3, 0x0e, 0x2c, 0xdd, 0xeb,
      0xc2, 0xab, 0xa4, 0x4e, 0xdf, 0x36, 0xae, 0x39, 0x57, 0xc9, 0xc6, 0x10,
      0xa3, 0x45, 0x21, 0xe6, 0xac, 0x45, 0x46, 0x52, 0xaa, 0x59, 0x78, 0x11,
      0x82, 0x7b, 0x4f, 0xf4, 0x5f, 0x99, 0x1f, 0x94, 0x05, 0xf2, 0xd8, 0xcf,
      0x45, 0xd5, 0xd0, 0x87, 0x6a, 0x26, 0x0e, 0xf0, 0xde, 0xb6, 0xe8, 0x60,
      0x90, 0xc5, 0xb4, 0x5f, 0x5b, 0x7b, 0x17, 0x86, 0x10, 0x53, 0x24, 0xf4,
      0x0a, 0x0d, 0x2b, 0x43, 0xde, 0xd5, 0x78, 0x68, 0xb3, 0x8b, 0x43, 0xef},
     {0xba, 0x9b, 0x68, 0xd1, 0xc0, 0x0a, 0xa1, 0x24, 0x6e, 0xda, 0xfb, 0x70,
      0xdb, 0x6d, 0xda, 0xed, 0x85, 0x70, 0xc4, 0x65, 0xd9, 0xa5, 0x83, 0x6d,
      0x41, 0x56, 0xa1, 0xac, 0x7f, 0xda, 0x2a, 0x20, 0x9c, 0x25, 0x47, 0x1a,
      0x0d, 0xf6, 0xd7, 0xde, 0x93, 0xf9, 0x80, 0xc8, 0x9c, 0x84, 0x16, 0x20},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in right to
    // left addition chain
    // tcID: 78
    {78,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x53, 0x38, 0x5b, 0x93, 0x03, 0xd2, 0xc5, 0xd1, 0xea, 0x83, 0xe7, 0x70,
      0x0b, 0x3e, 0x81, 0x1a, 0x7c, 0x90, 0x5d, 0x17, 0x75, 0xc3, 0x79, 0xa4,
      0x4e, 0x9e, 0x5c, 0x96, 0x82, 0x15, 0x59, 0x70, 0x0b, 0x49, 0x2e, 0xe2,
      0x86, 0x8c, 0x5a, 0x01, 0x95, 0x0a, 0xa4, 0xe2, 0xb0, 0x59, 0x32, 0xee,
      0x8f, 0xa1, 0xbd, 0x83, 0x03, 0x5a, 0xab, 0xba, 0xbc, 0x2b, 0xe7, 0xb6,
      0x1f, 0x38, 0x8f, 0x78, 0xb8, 0x04, 0x6d, 0x36, 0xbe, 0xe9, 0x9b, 0x54,
      0x89, 0xba, 0xfb, 0x3a, 0x86, 0xde, 0xde, 0x29, 0xc1, 0x4d, 0x53, 0x73,
      0xed, 0x9b, 0xac, 0x72, 0xa9, 0x2a, 0xb8, 0xe7, 0xc3, 0x1f, 0xb8, 0x6a},
     {0x33, 0xc6, 0xc7, 0xe2, 0xc8, 0x05, 0x88, 0x9c, 0xaa, 0xe5, 0x67, 0x9a,
      0xa0, 0x24, 0xdd, 0x79, 0xf5, 0x44, 0x56, 0xf7, 0x98, 0xef, 0xf0, 0xa0,
      0xdd, 0xcc, 0x1b, 0x28, 0xd8, 0xad, 0x30, 0x2d, 0x2f, 0x67, 0x09, 0x22,
      0x75, 0xff, 0x55, 0xf8, 0xf4, 0xd9, 0x93, 0x57, 0xac, 0x86, 0xce, 0x58},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in right to
    // left addition chain
    // tcID: 79
    {79,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x9e, 0xbf, 0x8d, 0x31, 0x3d, 0xa3, 0xe5, 0xba, 0x23, 0x7e, 0xe3, 0x3e,
      0x6d, 0xd5, 0xbe, 0x77, 0x03, 0x90, 0xf8, 0x37, 0xc9, 0x52, 0x8f, 0xbd,
      0xd4, 0x40, 0xa9, 0xeb, 0x2b, 0xa1, 0xcf, 0xfb, 0x27, 0x83, 0x7d, 0x86,
      0x5c, 0xbe, 0x1b, 0x32, 0xff, 0x9c, 0x79, 0x95, 0xd5, 0xdd, 0x51, 0x1c,
      0xaa, 0x41, 0x25, 0xec, 0x25, 0x8d, 0x18, 0x2e, 0xe7, 0xf7, 0x17, 0x3c,
      0xa1, 0xd1, 0x71, 0x39, 0xae, 0x13, 0xe6, 0x07, 0x2a, 0xcd, 0x97, 0x0b,
      0xa5, 0x6f, 0x6d, 0x50, 0x34, 0xe9, 0xf4, 0x5d, 0xa3, 0x6b, 0x2e, 0xc7,
      0x74, 0x34, 0x9b, 0xe2, 0x16, 0x8f, 0x32, 0xbb, 0xf0, 0x4f, 0x9a, 0x31},
     {0x0d, 0xee, 0xb0, 0x1d, 0xec, 0xaa, 0xe0, 0xee, 0xe5, 0x5e, 0x2c, 0x29,
      0x50, 0x1c, 0xdd, 0x9c, 0xf7, 0xd4, 0xdb, 0x2f, 0x16, 0x79, 0xfb, 0x72,
      0xef, 0xca, 0xa5, 0xdb, 0x6e, 0x05, 0xcc, 0x4a, 0x65, 0x84, 0x80, 0x24,
      0x5c, 0x59, 0xfe, 0xc9, 0x98, 0x4c, 0x61, 0x35, 0x01, 0x41, 0x1b, 0x0a},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in right to
    // left addition chain
    // tcID: 80
    {80,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xd4, 0xcd, 0x22, 0xe8, 0xdf, 0xa6, 0x20, 0xca, 0x7d, 0x68, 0xe2, 0x90,
      0x45, 0x1b, 0x09, 0x28, 0x52, 0x98, 0xa1, 0xdb, 0x5a, 0x7c, 0xa0, 0x0e,
      0xa8, 0x30, 0xd6, 0xe9, 0xec, 0x9c, 0xc4, 0xd0, 0x3f, 0x5c, 0xd4, 0x3f,
      0xb2, 0xa9, 0xaa, 0xaa, 0x14, 0x2f, 0xe4, 0xc6, 0xe2, 0x26, 0x9c, 0xdc,
      0x74, 0x7e, 0x0c, 0xa0, 0x7e, 0x38, 0xf4, 0xc5, 0xb4, 0x12, 0xe5, 0x2c,
      0xb7, 0x93, 0x0c, 0x38, 0x11, 0x00, 0xd2, 0xaa, 0xfe, 0x54, 0xb6, 0x19,
      0xeb, 0xf7, 0x2e, 0x81, 0xa4, 0x6e, 0x11, 0x49, 0x63, 0x5d, 0x25, 0xa3,
      0x7f, 0xa6, 0x6e, 0x2d, 0x1b, 0xc9, 0xac, 0x25, 0xfc, 0x1a, 0x83, 0xf3},
     {0xd3, 0x60, 0x75, 0x3c, 0x56, 0x86, 0x98, 0xd7, 0xf7, 0xb2, 0x61, 0xdd,
      0x2f, 0x50, 0x64, 0xff, 0xc8, 0xaa, 0x9f, 0x03, 0x34, 0x3a, 0x22, 0x91,
      0xb9, 0x67, 0x63, 0x26, 0x46, 0xd5, 0x15, 0x70, 0x56, 0x2f, 0x1a, 0xe8,
      0x77, 0x75, 0x64, 0x8e, 0x74, 0xf9, 0xf3, 0x0e, 0x96, 0x6e, 0x73, 0x80},
     false,
     true},

    // Comment: edge case for Jacobian and projective coordinates in right to
    // left addition chain
    // tcID: 81
    {81,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x21, 0xb9, 0x1b, 0x9c, 0x37, 0x4e, 0xcf, 0x5c, 0xed, 0xc6, 0xd7, 0x34,
      0x22, 0xc6, 0x53, 0x9b, 0x22, 0xae, 0x5d, 0xb6, 0x1b, 0xfd, 0xb0, 0x6b,
      0x9c, 0x89, 0xe6, 0x81, 0x12, 0xf6, 0x43, 0x3e, 0x9d, 0x49, 0x71, 0x5f,
      0x47, 0x45, 0x34, 0xfb, 0x9c, 0xd6, 0xc2, 0xcb, 0xfc, 0xde, 0xf9, 0x4f,
      0xb5, 0xd4, 0xfe, 0x30, 0x6d, 0x59, 0x02, 0x5a, 0xf4, 0xe8, 0x8f, 0x8c,
      0xb3, 0xdd, 0xc3, 0xd6, 0x4f, 0x70, 0x7e, 0x68, 0x20, 0xb4, 0x1c, 0xdf,
      0xc0, 0x55, 0xcd, 0x67, 0x62, 0xda, 0x23, 0xde, 0x01, 0xc1, 0xb3, 0x11,
      0xf1, 0xa5, 0xbf, 0x70, 0x10, 0xc4, 0xff, 0x4e, 0xd0, 0xa7, 0xe8, 0x4c},
     {0x59, 0x6a, 0xf7, 0x12, 0x09, 0xcd, 0xd2, 0x3c, 0x38, 0x6b, 0xb8, 0x61,
      0xed, 0xbd, 0x17, 0x1e, 0xa9, 0xbc, 0x6a, 0x85, 0x89, 0x93, 0x11, 0x0c,
      0x93, 0x33, 0xa9, 0x56, 0xb3, 0xa0, 0x3f, 0xc0, 0xf5, 0x53, 0x93, 0xca,
      0x46, 0xbb, 0x15, 0xbc, 0xf9, 0xf1, 0x2b, 0x49, 0x64, 0x59, 0xc4, 0xe6},
     false,
     true},

    // Comment: point with coordinate x = 0
    // tcID: 82
    {82,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x3c, 0xf9, 0x9e, 0xf0, 0x4f, 0x51, 0xa5, 0xea, 0x63, 0x0b, 0xa3, 0xf9,
      0xf9, 0x60, 0xdd, 0x59, 0x3a, 0x14, 0xc9, 0xbe, 0x39, 0xfd, 0x2b, 0xd2,
      0x15, 0xd3, 0xb4, 0xb0, 0x8a, 0xaa, 0xf8, 0x6b, 0xbf, 0x92, 0x7f, 0x2c,
      0x46, 0xe5, 0x2a, 0xb0, 0x6f, 0xb7, 0x42, 0xb8, 0x85, 0x0e, 0x52, 0x1e},
     {0x96, 0x87, 0x6e, 0x9e, 0xd8, 0x9e, 0xdf, 0x3e, 0x3d, 0xfd, 0x8e, 0xad,
      0x06, 0xdc, 0xba, 0x0a, 0xcd, 0xce, 0x77, 0x63, 0xeb, 0x98, 0xad, 0xed,
      0x82, 0x97, 0x6f, 0xa3, 0x61, 0x81, 0xc7, 0x9a, 0xc4, 0xe8, 0x33, 0xdf,
      0x38, 0x5a, 0xf5, 0xee, 0x86, 0x0c, 0xa1, 0xf2, 0x0d, 0xf4, 0xcb, 0x72},
     false,
     true},

    // Comment: point with coordinate x = 0
    // tcID: 83
    {83,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xdd, 0x60, 0x7e, 0x95, 0x45, 0x56, 0xc6, 0x2e, 0x39, 0xb4, 0x32, 0xd1,
      0xf1, 0xb2, 0xfe, 0x66, 0x52, 0xd7, 0x5a, 0x1f, 0xe3, 0x3c, 0xd1, 0x5c,
      0x79, 0x9f, 0xfa, 0xc9, 0xd1, 0x3d, 0x5d, 0x52, 0x18, 0x99, 0xd2, 0x59,
      0x40, 0xda, 0x65, 0x3d, 0x08, 0x24, 0xad, 0x84, 0x56, 0xdd, 0xfb, 0x62,
      0x9f, 0x41, 0x42, 0xe0, 0x8a, 0x3b, 0xd1, 0xd8, 0x7b, 0xf6, 0x11, 0x9a,
      0x9e, 0xf4, 0xb0, 0xa8, 0x0d, 0xc7, 0x12, 0xa4, 0xd6, 0xc0, 0x01, 0xbc,
      0xb2, 0x79, 0x4c, 0x4d, 0x1a, 0x03, 0xb1, 0xf1, 0xd3, 0x92, 0xdc, 0x08,
      0x8c, 0x89, 0xef, 0x84, 0x4f, 0x93, 0xad, 0xb1, 0x39, 0xd9, 0x56, 0xb8},
     {0x60, 0xd5, 0x97, 0xa9, 0x9c, 0x86, 0xa4, 0x32, 0xe1, 0x44, 0xbc, 0x2b,
      0x0e, 0x0a, 0x89, 0xb9, 0x1c, 0x4a, 0x72, 0xf3, 0xe1, 0xff, 0x8e, 0x56,
      0xe7, 0xf0, 0x7d, 0x53, 0xb2, 0xe5, 0x63, 0xe9, 0x79, 0xc0, 0x9e, 0x27,
      0xb3, 0x4b, 0xe9, 0x8b, 0xb1, 0x98, 0x65, 0xe8, 0x08, 0xd4, 0x29, 0x0e},
     false,
     true},

    // Comment: point with coordinate x = 0
    // tcID: 84
    {84,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x82, 0x6d, 0x71, 0xae, 0x4f, 0x7b, 0x3e, 0xcb, 0xb2, 0xa9, 0xbd, 0xf5,
      0x95, 0x12, 0x94, 0x95, 0x42, 0xd0, 0x11, 0x6f, 0x61, 0x64, 0x40, 0xa5,
      0x50, 0x16, 0x8f, 0x4b, 0x58, 0x81, 0x2f, 0xd6, 0xc1, 0xab, 0x94, 0xf3,
      0x10, 0x38, 0x5f, 0xdf, 0x24, 0x6d, 0xb5, 0xef, 0xc0, 0xfd, 0x13, 0x99,
      0x5d, 0xe0, 0x99, 0xbd, 0xfc, 0xea, 0x35, 0x5e, 0xe6, 0x38, 0x27, 0xcf,
      0x2a, 0x2e, 0x2d, 0x86, 0x8f, 0x5c, 0xf0, 0xb4, 0x87, 0xe4, 0x12, 0x45,
      0xdf, 0x54, 0xfd, 0xc7, 0x35, 0xee, 0xd6, 0xeb, 0x72, 0x6c, 0xfc, 0x92,
      0x8b, 0xd5, 0xb4, 0xd0, 0x17, 0x19, 0xd1, 0x64, 0x49, 0x67, 0xed, 0x1f},
     {0x85, 0x96, 0x19, 0x06, 0xed, 0xaa, 0x9a, 0xdf, 0xa9, 0xc9, 0xb8, 0x27,
      0x9d, 0xa6, 0x61, 0x58, 0xf5, 0x7f, 0xb3, 0x50, 0xff, 0x9b, 0x15, 0xdc,
      0x4d, 0x75, 0xb8, 0xca, 0xb6, 0x4b, 0x9d, 0x34, 0xf5, 0xce, 0x91, 0x2f,
      0x1a, 0xa5, 0x12, 0xa5, 0x4c, 0x71, 0x82, 0x1c, 0x6e, 0x31, 0xff, 0x8f},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 85
    {85,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xfa, 0x89, 0x19, 0xe4, 0x52, 0x4e, 0x70, 0x40, 0x48, 0x9c, 0xc1, 0x7a,
      0xa3, 0xd6, 0x20, 0xf8, 0x82, 0x76, 0xef, 0x24, 0x8d, 0x1e, 0xcd, 0x1e,
      0x9a, 0x66, 0x37, 0xc7, 0xa0, 0x67, 0x65, 0xf6, 0xf1, 0xd5, 0x93, 0xb1,
      0xfe, 0xbe, 0x33, 0x1b, 0x9f, 0x69, 0x6e, 0x82, 0xc5, 0xbe, 0x61, 0xa4,
      0xa0, 0x74, 0xa9, 0x12, 0x30, 0x96, 0x62, 0xf4, 0x4c, 0xe0, 0x82, 0x5b,
      0xf1, 0x34, 0x58, 0x21, 0x16, 0xca, 0xc3, 0x31, 0x05, 0x77, 0xd5, 0xa0,
      0x07, 0x22, 0xba, 0x51, 0x3e, 0x63, 0x34, 0xcc, 0x17, 0x10, 0x10, 0x91,
      0x22, 0x33, 0x46, 0xdb, 0x67, 0x06, 0x3c, 0xf6, 0xe7, 0xbf, 0xfb, 0xff},
     {0x43, 0x48, 0x4d, 0xcf, 0x01, 0x49, 0x2e, 0xab, 0x68, 0x4d, 0x39, 0x88,
      0x19, 0x08, 0xda, 0x7f, 0x40, 0x11, 0x9f, 0xe7, 0x18, 0x3b, 0xba, 0x62,
      0x5c, 0x32, 0xfd, 0xc1, 0x4d, 0xa3, 0xc4, 0x23, 0x6d, 0xc3, 0x39, 0x72,
      0x34, 0xe7, 0xdb, 0x41, 0x85, 0x74, 0x95, 0xcd, 0x0d, 0x09, 0x49, 0x1b},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 86
    {86,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xae, 0xcb, 0x8f, 0x15, 0xab, 0x87, 0x57, 0x9a, 0x03, 0xf5, 0xb8, 0xfc,
      0xf3, 0x3a, 0xa0, 0x94, 0x33, 0x7e, 0x4c, 0x36, 0x23, 0x59, 0xc9, 0xf2,
      0x72, 0x76, 0x34, 0x90, 0x9c, 0x69, 0x13, 0xc3, 0x21, 0xbe, 0x69, 0xf3,
      0xf8, 0xae, 0xd6, 0x93, 0xa3, 0x10, 0x59, 0x98, 0x99, 0x97, 0xfb, 0x32,
      0xd4, 0xf4, 0xa3, 0x7f, 0xf2, 0x36, 0xd8, 0xf6, 0x23, 0x71, 0x86, 0xa3,
      0xa7, 0x21, 0xa8, 0x2a, 0x2b, 0xa2, 0x2f, 0x8a, 0x62, 0x8d, 0x72, 0x73,
      0xef, 0x31, 0x73, 0xe2, 0x1e, 0xcc, 0x69, 0x96, 0x9a, 0x47, 0xe6, 0x69,
      0x38, 0x3e, 0xcf, 0x0c, 0xf5, 0x39, 0x6e, 0xb0, 0x2f, 0x46, 0xc3, 0xed},
     {0x65, 0xe6, 0x13, 0x39, 0x29, 0xc8, 0xb0, 0x61, 0xc2, 0x5f, 0xe0, 0xbe,
      0xc9, 0x14, 0x2c, 0x93, 0xd5, 0x2c, 0x9f, 0x16, 0x95, 0x06, 0x1b, 0x10,
      0x5f, 0x6c, 0x7d, 0xa1, 0x34, 0x7a, 0x96, 0x7b, 0x5a, 0x3f, 0x11, 0x83,
      0x56, 0x56, 0x45, 0xf7, 0xb8, 0xfa, 0xd8, 0x86, 0x3f, 0x9a, 0x63, 0x45},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 87
    {87,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x40, 0xdc, 0x66, 0xd8, 0x1c, 0x4e, 0x15, 0xe1, 0xa4, 0xc0, 0x09, 0xc6,
      0x0c, 0x34, 0x41, 0x72, 0x5f, 0xff, 0x08, 0xb2, 0x54, 0x37, 0x73, 0xb0,
      0xdd, 0xe0, 0x0d, 0xb2, 0x31, 0xf4, 0x4b, 0xad, 0xd7, 0x7a, 0x8b, 0xc9,
      0x61, 0x94, 0x79, 0xbd, 0x52, 0x88, 0xe4, 0x0d, 0xa1, 0x53, 0xb8, 0xdd,
      0xc3, 0xd5, 0x30, 0x26, 0x2b, 0x16, 0x9a, 0x6f, 0xa7, 0x00, 0xee, 0x32,
      0xa5, 0xcd, 0x05, 0x7b, 0xaf, 0x43, 0xd2, 0x96, 0x27, 0xf3, 0x42, 0xfd,
      0xa8, 0xf6, 0xf0, 0xfb, 0x21, 0xb1, 0xfa, 0x35, 0xbe, 0x96, 0xa4, 0x52,
      0xab, 0x48, 0x81, 0xf4, 0x17, 0xc9, 0xa4, 0xe4, 0x13, 0x6b, 0x1e, 0x6d},
     {0x07, 0x73, 0x67, 0x3d, 0xae, 0x33, 0x7a, 0x16, 0x88, 0xc2, 0xc3, 0x1d,
      0x1a, 0x60, 0x0c, 0x0e, 0xd7, 0x26, 0x04, 0xa1, 0x71, 0xc6, 0x65, 0xb5,
      0x30, 0x7e, 0xba, 0xf7, 0x40, 0xfd, 0x51, 0x8e, 0x4a, 0x7c, 0x5c, 0x91,
      0xe4, 0xf8, 0x6f, 0x65, 0x90, 0x56, 0x40, 0xee, 0x37, 0xf4, 0xf8, 0x30},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 88
    {88,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x53, 0xb5, 0x87, 0x47, 0x38, 0x27, 0x5a, 0x2e, 0x1d, 0x73, 0x4e, 0x51,
      0xf8, 0x36, 0x36, 0xf8, 0x91, 0x79, 0xc1, 0x6f, 0xe8, 0x9f, 0x46, 0xf4,
      0xd8, 0xe7, 0x1f, 0x52, 0x1c, 0x59, 0x47, 0x69, 0xd3, 0x17, 0x25, 0xf6,
      0x40, 0x41, 0x22, 0xf2, 0x11, 0x12, 0x94, 0x3a, 0x1a, 0x22, 0xff, 0x07,
      0x58, 0x6b, 0x41, 0xbb, 0x24, 0xbf, 0x30, 0x3a, 0xe8, 0x54, 0x5b, 0x25,
      0xf7, 0xb9, 0x84, 0x25, 0xea, 0x62, 0xc4, 0xd3, 0xbf, 0x51, 0xd2, 0x3d,
      0x9d, 0x85, 0xe0, 0x77, 0x19, 0xb8, 0x28, 0x77, 0x7e, 0xfa, 0x0a, 0x28,
      0xfb, 0x30, 0xf3, 0x3b, 0x89, 0x99, 0x80, 0xde, 0x3c, 0x53, 0x26, 0x11},
     {0xea, 0x25, 0xb0, 0x7a, 0x16, 0x1f, 0x31, 0x8a, 0x81, 0xa6, 0x93, 0xf6,
      0x60, 0x48, 0x10, 0xb8, 0x14, 0x28, 0x43, 0xc4, 0xfd, 0x26, 0x65, 0x8d,
      0x9b, 0x64, 0xfe, 0xdb, 0x58, 0xa5, 0xeb, 0xa5, 0x8c, 0x21, 0x7c, 0x41,
      0x76, 0x56, 0x9c, 0xf3, 0x3f, 0xa4, 0x7a, 0xc9, 0xf2, 0xb3, 0xd7, 0xf5},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 89
    {89,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x29, 0x88, 0xad, 0xdf, 0x62, 0x14, 0x9e, 0x6a, 0xc0, 0x82, 0x19, 0xd2,
      0xf0, 0x36, 0xd3, 0xf5, 0x72, 0x0a, 0xa8, 0x62, 0x90, 0x5c, 0xf3, 0xfe,
      0x7b, 0xdf, 0x13, 0x6d, 0xc0, 0x8b, 0x84, 0x5e, 0x8a, 0x61, 0xbe, 0x43,
      0xdb, 0x86, 0xd7, 0x1a, 0x26, 0xdc, 0x17, 0xbf, 0x55, 0x37, 0x4a, 0x9d,
      0x53, 0xac, 0x99, 0xc5, 0xd0, 0x7d, 0xe1, 0x0c, 0xe7, 0x4e, 0xd3, 0xb1,
      0xc4, 0x13, 0x68, 0x6e, 0xbb, 0xa7, 0x00, 0xf4, 0x92, 0x60, 0xb0, 0x83,
      0x57, 0xf9, 0x5d, 0xaf, 0x5b, 0x31, 0xa5, 0x55, 0x34, 0x5c, 0x07, 0x60,
      0x79, 0xf2, 0x5d, 0x86, 0x90, 0xfc, 0x1a, 0xc2, 0x0c, 0x71, 0x52, 0x8d},
     {0xa8, 0xd4, 0x24, 0x06, 0x8f, 0xb7, 0x84, 0x6b, 0x0d, 0x43, 0xa5, 0xcc,
      0x13, 0x02, 0x9d, 0x05, 0x4b, 0x11, 0xc9, 0x7e, 0x50, 0x8e, 0xe0, 0xf9,
      0x2e, 0x73, 0xd3, 0x5a, 0xc8, 0x35, 0x1a, 0x46, 0x2e, 0xed, 0xfc, 0x9d,
      0xa9, 0xdd, 0x12, 0x79, 0xf1, 0x28, 0x12, 0xba, 0x46, 0xc0, 0x60, 0x53},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 90
    {90,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x49, 0x4b, 0x59, 0xde, 0x1b, 0x69, 0x53, 0x4b, 0x4b, 0x62, 0xd7, 0x58,
      0x10, 0xee, 0x3d, 0xad, 0x05, 0xa1, 0x9a, 0xfa, 0x41, 0xc7, 0x83, 0x6d,
      0xb5, 0xca, 0x78, 0x63, 0x02, 0x08, 0xa8, 0x00, 0x38, 0x8d, 0x04, 0x03,
      0x4b, 0xaf, 0x29, 0x23, 0xad, 0x5a, 0xf6, 0xac, 0x72, 0xee, 0x05, 0xf9,
      0x89, 0xdf, 0x6d, 0x08, 0xf9, 0xa6, 0x40, 0x08, 0x58, 0xd0, 0x84, 0xfe,
      0x77, 0x0c, 0x0d, 0xdd, 0xe2, 0x98, 0x96, 0x6c, 0xdc, 0x56, 0xa9, 0x21,
      0xa4, 0x31, 0x84, 0x38, 0x4d, 0x5a, 0x13, 0xf3, 0x1c, 0x1e, 0xb4, 0xe8,
      0x34, 0xe2, 0x3b, 0xed, 0x30, 0x69, 0xc1, 0x0d, 0xfe, 0xd6, 0xb6, 0x3c},
     {0x29, 0x6f, 0x5d, 0x6f, 0xe4, 0xdd, 0xd8, 0xc3, 0xc7, 0x30, 0x4b, 0xea,
      0xdd, 0x45, 0xf6, 0xcd, 0x3e, 0x3f, 0xcd, 0x42, 0x30, 0xc9, 0xd2, 0xba,
      0x1a, 0x13, 0xbd, 0x9b, 0x94, 0x98, 0xa3, 0xc8, 0xd1, 0xef, 0x0a, 0xb6,
      0xee, 0x2a, 0x45, 0x0b, 0x0c, 0x68, 0xe8, 0x9a, 0x83, 0x71, 0x1f, 0xa2},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 91
    {91,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xb6, 0x4c, 0x49, 0xdd, 0xf1, 0x8b, 0xce, 0x79, 0xcf, 0xf3, 0xb8, 0xcb,
      0x7b, 0x0e, 0x58, 0xd4, 0x84, 0x21, 0xeb, 0x67, 0x39, 0xf5, 0x9d, 0x27,
      0x1f, 0xc4, 0xf5, 0x4d, 0xd2, 0xfc, 0xb1, 0xcf, 0x56, 0xdd, 0x3b, 0x3c,
      0x69, 0x17, 0x3a, 0x5e, 0xab, 0x50, 0xab, 0x1a, 0x2e, 0x06, 0x16, 0xd0,
      0x5d, 0x92, 0xb8, 0x64, 0xcb, 0xc9, 0xe4, 0xa3, 0xf7, 0x56, 0x50, 0xef,
      0xf3, 0x9e, 0x0e, 0xac, 0xbf, 0x87, 0xc4, 0xc0, 0x10, 0x08, 0x8f, 0x33,
      0x38, 0x84, 0x2c, 0xd9, 0x78, 0x32, 0x72, 0x4f, 0x79, 0xbb, 0x15, 0x98,
      0x6b, 0xd3, 0xfa, 0x85, 0x25, 0x58, 0x16, 0x35, 0x04, 0x73, 0xbb, 0xd3},
     {0xdb, 0x1e, 0xdb, 0xbb, 0x1f, 0x3a, 0xc6, 0xdf, 0x9f, 0x46, 0x12, 0x88,
      0x12, 0xbc, 0xe7, 0x81, 0x8b, 0x5d, 0x74, 0x5c, 0x75, 0x32, 0x2a, 0x9a,
      0xbe, 0x89, 0x98, 0x3b, 0xe8, 0x68, 0xaa, 0x1a, 0xac, 0x55, 0x5f, 0x4d,
      0x60, 0xec, 0x27, 0x27, 0x30, 0xbb, 0x4a, 0xd9, 0x49, 0xa5, 0x3d, 0x38},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 92
    {92,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xa4, 0x0b, 0x1c, 0xa1, 0xa5, 0x1a, 0x8e, 0xe6, 0xbe, 0xf5, 0xb5, 0x8a,
      0xaa, 0xbc, 0xff, 0xe2, 0xe1, 0x5f, 0x74, 0xa3, 0x08, 0x7e, 0xdb, 0x26,
      0x20, 0x88, 0x5d, 0x7d, 0x93, 0x3e, 0x4f, 0x50, 0xd6, 0x25, 0xea, 0xad,
      0x93, 0xb8, 0x7b, 0x8d, 0xff, 0x58, 0xf0, 0x56, 0x57, 0x92, 0xb1, 0x74,
      0xab, 0x89, 0x71, 0x7f, 0xfe, 0x87, 0xcd, 0x29, 0xff, 0xbf, 0x3c, 0xd7,
      0xd9, 0x38, 0xb1, 0x17, 0x37, 0x47, 0xbf, 0xc0, 0x31, 0x1b, 0x78, 0x72,
      0x36, 0x84, 0xd7, 0xc9, 0xa1, 0xc2, 0xbe, 0x3b, 0x59, 0x7b, 0xf9, 0x23,
      0x6e, 0xed, 0x09, 0x00, 0x28, 0xed, 0xa2, 0x14, 0x6c, 0x47, 0x7e, 0x65},
     {0x1f, 0x84, 0xc6, 0x41, 0xad, 0xe1, 0x62, 0xa2, 0x74, 0xab, 0x2e, 0xfc,
      0x7c, 0xf6, 0x58, 0x2f, 0x5a, 0x5d, 0x91, 0xce, 0x79, 0x93, 0xaf, 0x69,
      0x56, 0xd5, 0x5e, 0xea, 0x0e, 0x1b, 0x7f, 0xbf, 0x04, 0x0d, 0xa9, 0x75,
      0x04, 0x86, 0xb0, 0xfb, 0xb2, 0xbd, 0x70, 0xd9, 0xcc, 0xab, 0xb7, 0x85},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 93
    {93,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x4e, 0x7a, 0x82, 0xad, 0x74, 0xa1, 0xb7, 0x85, 0x19, 0x95, 0xf6, 0xe1,
      0xa1, 0x81, 0x41, 0xbb, 0x45, 0x84, 0xac, 0x22, 0xe8, 0x39, 0xd4, 0xd9,
      0x16, 0x01, 0x8b, 0x15, 0x0f, 0xed, 0x9c, 0xd0, 0xcc, 0xe4, 0x27, 0xbd,
      0x44, 0x67, 0x98, 0x52, 0x27, 0x44, 0xd3, 0x95, 0xe9, 0x0e, 0xe4, 0xb6,
      0x34, 0x45, 0xc1, 0xa6, 0xa4, 0xcd, 0x46, 0x7c, 0x20, 0xcd, 0xb2, 0x98,
      0x85, 0x4f, 0x1e, 0x27, 0x0a, 0xfb, 0xea, 0x05, 0x3b, 0x77, 0x84, 0x97,
      0x6b, 0x50, 0x4d, 0x0e, 0x13, 0x39, 0xc5, 0xc8, 0x60, 0x07, 0xce, 0xc3,
      0x63, 0x83, 0x99, 0x58, 0xa1, 0xfa, 0x51, 0xe9, 0x48, 0x3d, 0xe5, 0x61},
     {0x54, 0xef, 0xb9, 0xbb, 0x72, 0x69, 0xd8, 0x6b, 0x06, 0x28, 0x2b, 0x1d,
      0x7d, 0xc2, 0x8a, 0x94, 0x0c, 0xd7, 0x78, 0x9c, 0xa4, 0xe1, 0x04, 0xc4,
      0xbb, 0x7c, 0x5e, 0x57, 0x36, 0x67, 0x6c, 0x3e, 0x53, 0x70, 0xcf, 0xd9,
      0x78, 0x49, 0xe1, 0x20, 0x0a, 0x03, 0x1b, 0x66, 0x83, 0x88, 0xd8, 0xd0},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 94
    {94,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x9b, 0x54, 0x67, 0x8f, 0x85, 0x81, 0xce, 0x66, 0x51, 0x08, 0xab, 0xeb,
      0x0c, 0x09, 0xcb, 0x79, 0x85, 0xbb, 0x5d, 0xd8, 0x58, 0xbb, 0xb7, 0x1c,
      0x88, 0xe0, 0x53, 0x44, 0xde, 0x5b, 0x45, 0xb4, 0xe6, 0x7f, 0x33, 0xab,
      0x58, 0xd3, 0x59, 0xdc, 0xa2, 0xda, 0x8d, 0xf1, 0x14, 0x9d, 0xd1, 0xbb,
      0xd0, 0x9b, 0xa7, 0xf6, 0x3a, 0x8d, 0x35, 0x84, 0x8b, 0x40, 0x74, 0x6e,
      0xd5, 0xfe, 0xc7, 0x94, 0x4e, 0xd4, 0x4f, 0xd9, 0xa9, 0xa2, 0xfc, 0x3d,
      0x13, 0xeb, 0xc5, 0xc0, 0x5f, 0xf9, 0x4d, 0x5f, 0x50, 0x0e, 0xe1, 0x50,
      0x72, 0xd1, 0xb4, 0xc1, 0x37, 0x5f, 0xd6, 0xec, 0x4f, 0x32, 0x12, 0x5c},
     {0x1e, 0x96, 0xc8, 0x29, 0xcc, 0x8a, 0x79, 0xd7, 0x3f, 0xa6, 0x43, 0x4b,
      0xc1, 0x59, 0xdc, 0x43, 0x2c, 0x2a, 0xce, 0x3b, 0x49, 0xad, 0x2e, 0x74,
      0x38, 0x0e, 0x7b, 0x02, 0xfe, 0xb5, 0x3b, 0x33, 0x93, 0x44, 0x6a, 0x03,
      0x31, 0xb9, 0x74, 0xf2, 0xbf, 0x21, 0x9a, 0xe9, 0x5d, 0x2b, 0x23, 0xe7},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 95
    {95,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x86, 0xcb, 0x7a, 0x3f, 0xf3, 0xae, 0xdb, 0x2f, 0x39, 0xae, 0x22, 0xf2,
      0xe8, 0x28, 0xec, 0x08, 0x17, 0xd9, 0x4b, 0x83, 0x1a, 0xe6, 0x54, 0xdd,
      0x66, 0xaf, 0xf3, 0x1a, 0x4d, 0x84, 0xb3, 0x3f, 0xab, 0x46, 0xfe, 0xc1,
      0xab, 0xe1, 0xa9, 0xe6, 0xbb, 0xfa, 0xc5, 0xc9, 0x95, 0x65, 0xfd, 0x3b,
      0xb2, 0xf7, 0x2d, 0x56, 0x5d, 0x2f, 0xf5, 0xc5, 0xc2, 0x4f, 0x37, 0x54,
      0x48, 0xdd, 0x7b, 0xb4, 0x42, 0xdf, 0xdc, 0xb6, 0x1e, 0x07, 0x3e, 0x48,
      0x40, 0x27, 0x07, 0xbb, 0xcc, 0x26, 0xad, 0x43, 0xd4, 0x78, 0x8a, 0x9f,
      0x44, 0x71, 0x5f, 0x1b, 0x8e, 0x5b, 0x62, 0xbf, 0x49, 0xce, 0xca, 0x65},
     {0x84, 0xe7, 0xaf, 0x17, 0x6d, 0xdb, 0xa3, 0xec, 0x3c, 0xe7, 0xb7, 0xfc,
      0x43, 0xdf, 0x1e, 0xd5, 0x9b, 0x4e, 0x32, 0x28, 0xfa, 0x3f, 0x6f, 0xb4,
      0x1a, 0x01, 0xf4, 0x13, 0xb0, 0xa6, 0xc7, 0x40, 0x4e, 0x43, 0xf7, 0x74,
      0x71, 0x18, 0xba, 0x26, 0x4b, 0x7b, 0x02, 0x6d, 0x71, 0x4e, 0x90, 0xd0},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 96
    {96,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xcc, 0xf5, 0xa5, 0xb8, 0x0d, 0xeb, 0xa6, 0x31, 0x8b, 0x85, 0xf5, 0x7a,
      0x0d, 0x56, 0x3e, 0x95, 0x76, 0x5c, 0x7f, 0xe3, 0x0d, 0xf5, 0xac, 0x88,
      0x83, 0x7f, 0x35, 0x32, 0x9d, 0xd5, 0x10, 0x70, 0xe2, 0x98, 0x96, 0xf4,
      0xd9, 0x6e, 0xf4, 0x0b, 0xcc, 0xcf, 0x36, 0x24, 0x4d, 0xf8, 0x35, 0x61,
      0x4e, 0x87, 0x85, 0xf8, 0x06, 0x5f, 0x81, 0xc5, 0xe9, 0x27, 0x0f, 0xd5,
      0x59, 0xb6, 0xa3, 0x80, 0xb4, 0x83, 0x87, 0x4d, 0x29, 0x8d, 0x0d, 0x38,
      0x2e, 0xee, 0x1e, 0xdb, 0x6a, 0x59, 0xd9, 0xc1, 0x63, 0x29, 0x6a, 0xb7,
      0xa0, 0x68, 0x18, 0x6b, 0x0d, 0x23, 0xf3, 0x37, 0x37, 0xdd, 0x0e, 0xed},
     {0x82, 0x86, 0x4e, 0xf4, 0xd5, 0xfd, 0x25, 0x20, 0x4a, 0xe1, 0x59, 0x1c,
      0x61, 0x9f, 0x3e, 0xd8, 0x13, 0xc7, 0x62, 0xba, 0xa0, 0x09, 0xba, 0x3b,
      0x49, 0xac, 0x38, 0xc5, 0x7b, 0x2f, 0x46, 0x65, 0x2f, 0x71, 0x9a, 0xdc,
      0xea, 0xbf, 0xbc, 0xaf, 0x98, 0x5b, 0x29, 0x95, 0x8d, 0x1f, 0x42, 0x0c},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 97
    {97,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc7, 0xf7, 0x7a, 0xd2, 0x86, 0xc6, 0x8b, 0x88, 0xff, 0xa6, 0x4f, 0xef,
      0xe4, 0xaa, 0xab, 0x3d, 0xee, 0x1f, 0x9b, 0xae, 0x37, 0xb7, 0xd0, 0x69,
      0xbb, 0x92, 0xbe, 0xa8, 0x20, 0x89, 0xe8, 0x31, 0xa7, 0x0d, 0xd9, 0xed,
      0x00, 0x7b, 0xa6, 0xdc, 0xe1, 0x4f, 0x9c, 0x6d, 0x5e, 0x74, 0x4e, 0xcc,
      0xb3, 0x19, 0xad, 0x6e, 0xc1, 0x34, 0x37, 0x6c, 0xb0, 0x59, 0xa1, 0xc8,
      0x69, 0x84, 0xea, 0x8b, 0xd1, 0x54, 0xd8, 0x26, 0xed, 0x3d, 0xba, 0xe8,
      0xd8, 0xd8, 0xe0, 0x6a, 0xa0, 0xcb, 0xe0, 0x12, 0x7d, 0xdf, 0xc3, 0x26,
      0x21, 0xbb, 0xc1, 0xf7, 0x31, 0xf9, 0xd9, 0x0e, 0x68, 0x7a, 0x7c, 0xf5},
     {0x1d, 0x0d, 0x3e, 0xd8, 0xc1, 0xe0, 0xd2, 0x8f, 0x5e, 0x37, 0x66, 0xf1,
      0x93, 0xda, 0x7b, 0xdc, 0xa1, 0xcc, 0x08, 0x37, 0x62, 0x93, 0xf9, 0xbb,
      0xde, 0x7b, 0xde, 0x0e, 0x9b, 0x1e, 0xbc, 0xf4, 0xcf, 0xa3, 0xc6, 0x83,
      0xdc, 0x63, 0xbc, 0xb4, 0x2b, 0x2d, 0x9e, 0xde, 0x54, 0x24, 0x2b, 0xc2},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 98
    {98,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xaa, 0xc3, 0xb4, 0xd2, 0x80, 0xfc, 0x70, 0xa9, 0xfe, 0x17, 0x5e, 0x18,
      0x82, 0xa6, 0x9e, 0xac, 0xa2, 0x48, 0x2a, 0x0c, 0x9d, 0xed, 0x92, 0x00,
      0x44, 0x40, 0x28, 0xca, 0x3d, 0xbf, 0x50, 0x1f, 0xc3, 0x61, 0xf7, 0x65,
      0x8b, 0xff, 0xec, 0x32, 0x1a, 0xd5, 0x77, 0xb4, 0x8c, 0x97, 0x86, 0xb0,
      0x7f, 0x59, 0x6b, 0xd8, 0x68, 0xd5, 0x1e, 0x73, 0xf0, 0xf7, 0xc2, 0x5d,
      0xb9, 0x56, 0xb1, 0x21, 0x71, 0xcf, 0xab, 0x11, 0xab, 0xd4, 0xab, 0xb0,
      0x0a, 0x59, 0xac, 0x43, 0x2c, 0x0b, 0x0f, 0x05, 0x8f, 0x4c, 0xca, 0x44,
      0xfb, 0x58, 0x1b, 0xc5, 0x80, 0x3e, 0x47, 0x2a, 0x05, 0x30, 0x5f, 0x33},
     {0xbf, 0x19, 0x54, 0x8b, 0xb1, 0xd7, 0x33, 0x3f, 0x46, 0xcf, 0xf4, 0xd9,
      0xd2, 0xa8, 0x1d, 0xbb, 0x48, 0xca, 0x82, 0xa5, 0x2f, 0xae, 0xc2, 0xb2,
      0x0c, 0x3b, 0x27, 0xbd, 0xe3, 0x92, 0xa6, 0x6b, 0x8e, 0x44, 0x78, 0x0c,
      0x20, 0x98, 0xa7, 0xb5, 0x25, 0x31, 0x57, 0xb0, 0x14, 0xb4, 0x0e, 0x51},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 99
    {99,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x74, 0x7e, 0xfb, 0x59, 0x5d, 0x03, 0xdc, 0x05, 0xdd, 0x50, 0xc1, 0x71,
      0x55, 0xe1, 0x01, 0x8c, 0xa1, 0x47, 0x15, 0x05, 0x45, 0x92, 0x90, 0x6e,
      0x67, 0x1a, 0x2e, 0x22, 0x04, 0xac, 0xae, 0x55, 0x2b, 0x6f, 0x5d, 0x34,
      0x5d, 0x3f, 0xcf, 0x9b, 0x41, 0x71, 0x89, 0x2a, 0xfb, 0x3e, 0x55, 0x87,
      0xd8, 0xe7, 0x09, 0xb0, 0x83, 0xa8, 0xb5, 0x36, 0x36, 0x63, 0x49, 0x2f,
      0x8a, 0x2a, 0x9a, 0xf6, 0x4c, 0x3a, 0xd0, 0x1c, 0x64, 0xd8, 0xfa, 0x47,
      0x64, 0xd6, 0x1f, 0x43, 0xe6, 0x90, 0x1a, 0x24, 0x45, 0xce, 0x94, 0xb5,
      0x86, 0xf6, 0x09, 0x0a, 0xe0, 0x68, 0x7a, 0xf0, 0x09, 0x0f, 0xcd, 0x47},
     {0x32, 0xd5, 0x69, 0x31, 0x0f, 0x61, 0xaf, 0x47, 0x5b, 0x6c, 0x6d, 0x07,
      0x55, 0x99, 0x62, 0x5a, 0x33, 0x81, 0xb0, 0xa5, 0xb6, 0xa0, 0xb8, 0xc2,
      0x7c, 0x71, 0x65, 0xd0, 0x0e, 0x2f, 0xd4, 0xdc, 0x8b, 0x2c, 0xf8, 0xe3,
      0xb3, 0x3e, 0x28, 0xad, 0x40, 0x05, 0x52, 0x53, 0x84, 0x22, 0x7f, 0xb4},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 100
    {100,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xab, 0x14, 0x76, 0x4b, 0xf2, 0x4f, 0x83, 0x13, 0xb1, 0xc4, 0x9c, 0x4b,
      0xd6, 0xe3, 0x67, 0x23, 0x12, 0x75, 0xb3, 0x03, 0xc6, 0x01, 0xc6, 0x6f,
      0x7e, 0x8b, 0x31, 0x05, 0xc6, 0xb0, 0x2a, 0x90, 0xb6, 0x0f, 0x38, 0x74,
      0x5d, 0x75, 0x5c, 0xe4, 0xdd, 0x40, 0x68, 0x1e, 0xd1, 0x5a, 0x1a, 0xc9,
      0x3e, 0x14, 0xcf, 0x2f, 0xa7, 0x08, 0x30, 0x0a, 0x2b, 0x27, 0x9f, 0x2c,
      0x37, 0xfb, 0xc0, 0xda, 0x71, 0x75, 0xc9, 0x2c, 0x11, 0x14, 0xc5, 0x7e,
      0xf2, 0x51, 0x46, 0x7f, 0x6f, 0x3d, 0xe7, 0x9f, 0xbc, 0x38, 0xcb, 0x1e,
      0x3d, 0xb7, 0x0e, 0x4d, 0x95, 0x22, 0x5f, 0xbd, 0x8a, 0xd9, 0x68, 0x89},
     {0x26, 0x6b, 0x26, 0x1b, 0x6d, 0xd9, 0xeb, 0x51, 0x77, 0x0f, 0x6c, 0x4c,
      0x11, 0xb8, 0x71, 0x34, 0xab, 0xff, 0x16, 0x29, 0xb6, 0x51, 0x71, 0x10,
      0x7a, 0x9b, 0x20, 0xe0, 0xc7, 0xd1, 0x68, 0xe1, 0xef, 0xc3, 0xcb, 0xc4,
      0x02, 0x46, 0x4f, 0x36, 0xae, 0xb3, 0xc0, 0x27, 0xb9, 0x19, 0x8e, 0x10},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 101
    {101,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x1e, 0x1f, 0xe9, 0x73, 0x0f, 0xcd, 0x5b, 0x87, 0xb0, 0x65, 0xfa, 0x90,
      0xa6, 0x95, 0x34, 0x03, 0x6b, 0xe4, 0x57, 0x58, 0x51, 0x34, 0x43, 0xf7,
      0x9c, 0x64, 0x27, 0xdb, 0xc3, 0x1f, 0xc4, 0x03, 0xe8, 0x94, 0x04, 0x3f,
      0xb9, 0xc7, 0xf9, 0xf5, 0x8c, 0x0a, 0x36, 0x70, 0xb1, 0xc0, 0xd8, 0x03,
      0x59, 0xdb, 0x8f, 0x6a, 0x48, 0x97, 0x0c, 0xcb, 0x99, 0x18, 0xce, 0xf0,
      0x4f, 0x35, 0x2a, 0x4d, 0x91, 0xa2, 0x04, 0x50, 0x21, 0x19, 0xb2, 0xb7,
      0xef, 0xc6, 0xc6, 0x71, 0xa6, 0xba, 0x45, 0x37, 0xe8, 0x2c, 0x19, 0x6e,
      0x6d, 0x42, 0x68, 0x5c, 0x5a, 0x6f, 0x55, 0x9e, 0x4e, 0x8a, 0xf7, 0x04},
     {0xfa, 0x9f, 0x20, 0x8d, 0xce, 0xde, 0xe5, 0x97, 0xf5, 0x11, 0x22, 0xe6,
      0x27, 0x4b, 0x86, 0x71, 0x0e, 0x36, 0x56, 0x1f, 0x23, 0x61, 0xe7, 0x61,
      0x86, 0xfc, 0xb7, 0x3d, 0x1d, 0x7f, 0x29, 0x28, 0x42, 0x6d, 0x98, 0xc3,
      0xf6, 0x9e, 0x4c, 0xf4, 0x8d, 0x30, 0x01, 0xd6, 0x49, 0x70, 0x42, 0x5e},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 102
    {102,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x83, 0xfc, 0xea, 0x20, 0x8c, 0x79, 0x22, 0x7c, 0xbd, 0x97, 0x31, 0x9a,
      0x86, 0x59, 0x7f, 0x85, 0xcb, 0xfc, 0x19, 0xef, 0x60, 0xc5, 0xba, 0x7a,
      0x92, 0xfc, 0x52, 0x1c, 0x68, 0x5e, 0x20, 0x8c, 0xec, 0x77, 0x35, 0xbe,
      0x9b, 0xe2, 0x7c, 0x73, 0x7d, 0x3f, 0x9d, 0x2f, 0xaa, 0x1c, 0x3f, 0x46,
      0x95, 0xa3, 0x21, 0x84, 0xd5, 0x8f, 0xc9, 0x00, 0x14, 0x02, 0x43, 0x6c,
      0xe0, 0x0b, 0x52, 0xb8, 0x88, 0x5b, 0xb1, 0x15, 0x0f, 0x61, 0xe6, 0x60,
      0xec, 0xeb, 0xa1, 0x07, 0x68, 0xd0, 0xf4, 0x1d, 0x5e, 0x4e, 0x7c, 0x21,
      0xd4, 0xfd, 0x90, 0x9a, 0xce, 0xaf, 0x61, 0xa7, 0x45, 0x5d, 0xd0, 0xc6},
     {0x9a, 0x1d, 0xdf, 0x3d, 0x9f, 0xeb, 0x19, 0x0a, 0x26, 0xf2, 0x0e, 0xd9,
      0x25, 0xff, 0xbd, 0x35, 0xdf, 0x10, 0x17, 0xc4, 0xa4, 0xc9, 0x48, 0x5d,
      0x34, 0x4c, 0xb8, 0xf8, 0x1c, 0x7f, 0x45, 0x2b, 0x2f, 0xf3, 0xae, 0xc4,
      0x4b, 0xaf, 0x34, 0xe5, 0x08, 0x86, 0xf1, 0x83, 0x48, 0x0b, 0x63, 0x25},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 103
    {103,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2b, 0xf2, 0x69, 0x36, 0xc9, 0x16, 0x4b, 0xa1, 0x07, 0x25, 0x44, 0xc4,
      0x10, 0x75, 0x76, 0x30, 0xb9, 0x7d, 0x4e, 0x85, 0x3f, 0xdb, 0x78, 0x44,
      0xf1, 0x81, 0x15, 0x07, 0xd0, 0x4a, 0x68, 0x7d, 0x95, 0x1f, 0xa6, 0x5a,
      0x34, 0x36, 0x4e, 0x89, 0x4c, 0xf8, 0xb0, 0x81, 0x5d, 0xb9, 0x5f, 0x5e,
      0x10, 0x66, 0x46, 0x27, 0xbf, 0x6f, 0x72, 0x33, 0x0a, 0x2d, 0x6f, 0x21,
      0x23, 0x61, 0xa2, 0x33, 0x15, 0x5a, 0xbb, 0x79, 0xda, 0x54, 0x34, 0x3b,
      0x85, 0x72, 0xe3, 0x0e, 0xac, 0xe8, 0xc8, 0xf5, 0x48, 0x02, 0x00, 0xe7,
      0x51, 0xc2, 0x10, 0x20, 0x78, 0x52, 0x88, 0x12, 0xc8, 0x3f, 0x3c, 0xf4},
     {0x47, 0xe4, 0x60, 0x8e, 0x9b, 0xcc, 0xf6, 0xa3, 0x29, 0x6e, 0x41, 0xfe,
      0x34, 0xeb, 0x71, 0x81, 0xa1, 0xb5, 0xec, 0x30, 0x6a, 0x93, 0xaa, 0xbd,
      0x5f, 0xb3, 0x8e, 0x75, 0xe3, 0xd7, 0x5e, 0x8e, 0x2e, 0xe4, 0xc1, 0xc4,
      0x4a, 0x7d, 0x08, 0x66, 0x06, 0x81, 0xb9, 0xfa, 0x66, 0x64, 0x29, 0x10},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 104
    {104,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xbb, 0x58, 0x3d, 0xa5, 0xde, 0x4c, 0x35, 0x2e, 0x8a, 0x4f, 0xad, 0x31,
      0xe9, 0xf7, 0x12, 0x97, 0xbc, 0x96, 0x31, 0x34, 0xec, 0x18, 0x2e, 0x96,
      0x37, 0x9c, 0x6b, 0x28, 0xa1, 0x1d, 0x25, 0xfa, 0x4b, 0x77, 0xa4, 0xa0,
      0xf9, 0x47, 0x08, 0x5d, 0xb3, 0x3b, 0x0e, 0xa7, 0x7b, 0x9d, 0xa0, 0x9b,
      0xe1, 0xa0, 0xbd, 0x13, 0x00, 0x38, 0x3e, 0xbd, 0x60, 0xb5, 0xaa, 0x6e,
      0xeb, 0x20, 0xf0, 0x3d, 0x56, 0xdd, 0x14, 0xdf, 0x46, 0x15, 0x74, 0x65,
      0x14, 0x62, 0x78, 0x53, 0x6e, 0xbc, 0x28, 0xc5, 0x47, 0x1a, 0x94, 0xf0,
      0x95, 0x55, 0x4c, 0x4c, 0x08, 0x5a, 0xc9, 0xdc, 0xeb, 0x1d, 0xa5, 0x5f},
     {0x83, 0x93, 0xa2, 0x68, 0x9b, 0x37, 0x6a, 0x22, 0x8f, 0x32, 0x33, 0xac,
      0x61, 0x57, 0x8b, 0xe1, 0xaa, 0x2d, 0xe1, 0xdb, 0xfb, 0xb2, 0x8b, 0x03,
      0xad, 0x24, 0xf1, 0x1a, 0xd9, 0xd7, 0x7f, 0x85, 0x43, 0xe0, 0x97, 0x7a,
      0xea, 0x9a, 0x76, 0x1d, 0x84, 0xe1, 0x15, 0xb6, 0x15, 0x07, 0xae, 0x59},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 105
    {105,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe3, 0x77, 0x91, 0x59, 0x5b, 0x54, 0xe9, 0xb1, 0x7c, 0xc3, 0x07, 0x26,
      0xd2, 0x42, 0x5e, 0xea, 0xcc, 0x96, 0x72, 0xf5, 0xfb, 0xc9, 0x1f, 0xc1,
      0x08, 0xcf, 0x8c, 0x84, 0xff, 0xf9, 0xb6, 0x6e, 0xa6, 0x54, 0x83, 0x84,
      0x1b, 0x76, 0x18, 0x69, 0x48, 0x15, 0xe1, 0xa4, 0x15, 0x18, 0x6b, 0xa7,
      0x27, 0xaf, 0x3a, 0xe6, 0xc6, 0x58, 0xeb, 0x8c, 0x48, 0x5d, 0x6a, 0xd8,
      0xe4, 0x9c, 0x1e, 0xad, 0xe7, 0x51, 0x45, 0x75, 0x62, 0xd6, 0x00, 0x3d,
      0xe7, 0x5c, 0xd1, 0xf1, 0xe1, 0x3e, 0xc1, 0x5e, 0xa1, 0xd0, 0x41, 0x36,
      0x02, 0xed, 0x7f, 0x6a, 0x6b, 0x7b, 0x84, 0xef, 0xd8, 0xa3, 0x05, 0x6e},
     {0x20, 0x94, 0x17, 0xda, 0x72, 0x1b, 0x49, 0xd6, 0x4d, 0xfa, 0x09, 0x98,
      0x3a, 0x86, 0x83, 0x52, 0x0e, 0x5e, 0x30, 0x0a, 0x52, 0xb2, 0xe8, 0xf1,
      0x67, 0x77, 0x72, 0xee, 0x3c, 0x08, 0x6b, 0x33, 0x9a, 0x1d, 0xa2, 0x5c,
      0xab, 0x2b, 0xe6, 0xe4, 0x4d, 0xe4, 0x52, 0x6c, 0x31, 0xf4, 0xeb, 0xbc},
     false,
     true},

    // Comment: point with coordinate x = 0 in precomputation or right to left
    // addition chain
    // tcID: 106
    {106,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x7f, 0x12, 0xcb, 0x98, 0x7b, 0x08, 0xc2, 0x35, 0x52, 0x34, 0x65, 0x14,
      0x6b, 0x42, 0x25, 0x85, 0x84, 0x39, 0x80, 0x62, 0xa1, 0x07, 0x42, 0x9c,
      0xe4, 0x86, 0xb4, 0xb2, 0xf2, 0x6a, 0x96, 0x28, 0x29, 0x3a, 0xe4, 0xd3,
      0x0a, 0xa6, 0x1c, 0x64, 0xbf, 0x92, 0xf9, 0x7e, 0x6c, 0x08, 0xae, 0xa8,
      0xd6, 0x62, 0x1c, 0xfc, 0xe5, 0x27, 0x0c, 0xd7, 0xfa, 0x69, 0xdc, 0xb0,
      0x38, 0xed, 0x8b, 0xa4, 0x28, 0xaf, 0xd7, 0x7d, 0x52, 0x8c, 0x23, 0x0f,
      0x8e, 0x5c, 0x9b, 0x83, 0xef, 0x65, 0x9c, 0x7e, 0x57, 0x3f, 0x66, 0x71,
      0xa1, 0x8d, 0x8b, 0x8c, 0x4c, 0xeb, 0x20, 0xf2, 0xd7, 0x60, 0x85, 0x8e},
     {0xe7, 0xea, 0xc4, 0x60, 0xea, 0xda, 0x6e, 0xb9, 0x99, 0x88, 0xcc, 0x39,
      0xf6, 0x12, 0x9a, 0x74, 0xd9, 0x51, 0x0d, 0x2e, 0xc3, 0x96, 0x01, 0xad,
      0xae, 0x76, 0xb2, 0xb8, 0xfd, 0x61, 0x22, 0x40, 0x7b, 0x79, 0x41, 0x1f,
      0x8e, 0x7a, 0xdf, 0xbc, 0x4f, 0x0d, 0xc5, 0x0d, 0xa9, 0xf2, 0xb8, 0x2b},
     false,
     true},

    // Comment: point with coordinate x = 0 in precomputation or right to left
    // addition chain
    // tcID: 107
    {107,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xdc, 0x4f, 0x06, 0xd6, 0x71, 0xd8, 0x60, 0x12, 0xcd, 0x5c, 0xe1, 0x03,
      0x77, 0xff, 0xef, 0xbd, 0xe6, 0x57, 0xda, 0x08, 0xfa, 0x92, 0x59, 0xe4,
      0xae, 0xff, 0xe6, 0x21, 0x1a, 0xc5, 0x7f, 0x6e, 0x1c, 0x5b, 0xf8, 0x73,
      0x29, 0x89, 0xd4, 0x4c, 0x13, 0x42, 0xa8, 0x4f, 0xa6, 0xfd, 0x7f, 0xba,
      0x27, 0x14, 0xce, 0x23, 0xcc, 0x0f, 0x8e, 0x0a, 0x8b, 0xda, 0x59, 0x3e,
      0xc2, 0xb4, 0xb5, 0x29, 0x4f, 0xfc, 0x03, 0x63, 0xe6, 0xe8, 0x94, 0x03,
      0xd4, 0x48, 0x2f, 0x35, 0x37, 0xdb, 0xa9, 0xe4, 0xf3, 0x6b, 0xe6, 0x8d,
      0x8e, 0x2e, 0xda, 0xfd, 0x8c, 0xc2, 0xc0, 0x1f, 0x5f, 0x7d, 0xce, 0xc4},
     {0x5a, 0x19, 0x7a, 0x9a, 0x87, 0x93, 0xd9, 0x4d, 0x8b, 0x84, 0x08, 0x4c,
      0x6d, 0xc3, 0x6c, 0x36, 0xa2, 0x93, 0xac, 0x90, 0x33, 0x7a, 0x1c, 0xf6,
      0xa2, 0x65, 0x34, 0x35, 0xd0, 0x5e, 0x2f, 0x56, 0x3b, 0xfd, 0x29, 0x33,
      0xf2, 0x3e, 0xd3, 0xae, 0xfd, 0x75, 0x55, 0x5e, 0xad, 0x76, 0xe8, 0x27},
     false,
     true},

    // Comment: point with coordinate x = 0 in precomputation or right to left
    // addition chain
    // tcID: 108
    {108,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xca, 0x1e, 0xc6, 0x79, 0x8c, 0x56, 0x67, 0x81, 0x3b, 0xfc, 0x45, 0xdd,
      0x18, 0x15, 0xe8, 0x2b, 0xec, 0x93, 0xea, 0xa7, 0x08, 0x10, 0x69, 0x76,
      0x7b, 0xec, 0x36, 0x85, 0xcd, 0xfa, 0x56, 0x26, 0x7f, 0xc2, 0x4d, 0xa6,
      0xc1, 0x86, 0xd8, 0xb3, 0x27, 0x16, 0x27, 0xa8, 0x52, 0x56, 0x0c, 0x5a,
      0x09, 0x7d, 0x7c, 0x41, 0xe6, 0x10, 0xe5, 0x26, 0x7d, 0xab, 0xf5, 0x25,
      0x76, 0x3f, 0x4a, 0x4a, 0x74, 0x78, 0xc5, 0xf9, 0xae, 0x4b, 0x80, 0xba,
      0xa1, 0xe6, 0x20, 0xac, 0x1f, 0x22, 0xd8, 0x68, 0x9b, 0x07, 0xed, 0x9a,
      0x99, 0xdc, 0xe0, 0xcd, 0x4a, 0x11, 0x68, 0x2f, 0x07, 0x22, 0x7f, 0xc4},
     {0x8b, 0xf5, 0x20, 0x33, 0x7d, 0xe6, 0xe5, 0xc6, 0xf2, 0x70, 0x05, 0x16,
      0x1b, 0x3b, 0x2f, 0x1c, 0xf0, 0x87, 0x59, 0x52, 0x7c, 0x8f, 0xc7, 0x93,
      0x5e, 0x36, 0x21, 0xf6, 0x89, 0x36, 0xf1, 0x91, 0xac, 0x6e, 0x93, 0x1b,
      0x79, 0x42, 0x78, 0xd3, 0xca, 0x1e, 0x37, 0x72, 0xdb, 0xfb, 0x19, 0xbf},
     false,
     true},

    // Comment: point with coordinate x = 0 in precomputation or right to left
    // addition chain
    // tcID: 109
    {109,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x44, 0xb9, 0xe9, 0x76, 0xb9, 0xe8, 0x9a, 0xa3, 0x15, 0x19, 0xfc, 0x0a,
      0x35, 0x28, 0x8c, 0x55, 0xe2, 0xd7, 0x63, 0x0a, 0x1c, 0xd1, 0xff, 0xfd,
      0x28, 0x8c, 0xda, 0xc8, 0xc7, 0x4b, 0xc2, 0xed, 0xcb, 0x0f, 0xf8, 0x78,
      0xfc, 0xcc, 0xeb, 0xbb, 0x78, 0xdf, 0x9e, 0x7e, 0xb0, 0xaf, 0xa6, 0xb1,
      0x38, 0x47, 0x82, 0xb8, 0xa1, 0x13, 0x89, 0x46, 0x59, 0x4d, 0x8f, 0xd3,
      0xb6, 0xc9, 0xb4, 0x95, 0x4e, 0x73, 0xd8, 0xc0, 0x40, 0xa7, 0xa1, 0x53,
      0xf3, 0xda, 0x5a, 0x40, 0xf9, 0xfd, 0xaf, 0x3b, 0xf3, 0x1a, 0x45, 0x22,
      0x41, 0x6c, 0x31, 0x6f, 0x10, 0xdc, 0x7c, 0xd8, 0xaf, 0xc2, 0x84, 0x9b},
     {0x1e, 0x56, 0xdc, 0x30, 0xda, 0xd3, 0x3e, 0x34, 0x27, 0x35, 0x35, 0x68,
      0x86, 0x05, 0xbb, 0x98, 0xad, 0x7c, 0x6d, 0xd5, 0x1d, 0x92, 0x67, 0xc9,
      0x0a, 0x62, 0x56, 0x2d, 0x08, 0xe4, 0x7d, 0xd6, 0x84, 0x18, 0x0d, 0x4a,
      0xb7, 0xab, 0xb6, 0xcc, 0x14, 0xae, 0x4c, 0x9b, 0xd6, 0xae, 0x9e, 0x92},
     false,
     true},

    // Comment: point with coordinate x = 0 in precomputation or right to left
    // addition chain
    // tcID: 110
    {110,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xcf, 0x66, 0x1b, 0x71, 0xc2, 0xb8, 0x73, 0x4f, 0x7c, 0xf5, 0x14, 0x2a,
      0x66, 0xed, 0xf7, 0x87, 0xc5, 0x6a, 0x33, 0x17, 0x43, 0x03, 0xc2, 0x07,
      0x41, 0xf0, 0x7e, 0x0c, 0x34, 0x8e, 0x1b, 0x54, 0x25, 0x70, 0x5d, 0x9e,
      0xbb, 0xb4, 0x59, 0x96, 0x76, 0x21, 0xde, 0xd6, 0xeb, 0x56, 0xd7, 0x10,
      0x37, 0x33, 0x7a, 0xa1, 0x6e, 0x1c, 0xf6, 0xe5, 0x03, 0x18, 0x21, 0x84,
      0xc9, 0x45, 0x1f, 0x9b, 0xa4, 0x57, 0xd8, 0x1a, 0x03, 0x13, 0xfb, 0x98,
      0x73, 0x43, 0xb8, 0xb3, 0x93, 0x44, 0xf3, 0x69, 0x32, 0x98, 0x01, 0x0c,
      0xd5, 0xb7, 0x3e, 0x38, 0xbc, 0xde, 0xce, 0x66, 0xc6, 0x7f, 0xa5, 0x08},
     {0x14, 0xe3, 0xa9, 0x7e, 0x9e, 0xe6, 0x90, 0x89, 0x41, 0x0b, 0x72, 0x45,
      0x98, 0x70, 0x49, 0x5a, 0x03, 0x7d, 0x40, 0x77, 0xbb, 0xa0, 0x27, 0xef,
      0xf4, 0xc4, 0x99, 0x56, 0x7d, 0x7e, 0x7f, 0x1a, 0xf2, 0x72, 0x0e, 0x1f,
      0xed, 0xd0, 0x7b, 0xd7, 0x80, 0x50, 0x9a, 0x45, 0x16, 0xfa, 0x5c, 0x48},
     false,
     true},

    // Comment: point with coordinate x = 0 in precomputation or right to left
    // addition chain
    // tcID: 111
    {111,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x50, 0x79, 0x09, 0x08, 0xc0, 0x43, 0x34, 0x4e, 0x1c, 0xf4, 0x2b, 0x27,
      0xe4, 0xdc, 0x33, 0xa3, 0x5d, 0x68, 0xa0, 0xb9, 0x3b, 0xe0, 0xec, 0x2b,
      0xe0, 0x57, 0x45, 0xb3, 0xc8, 0x3c, 0x35, 0xf0, 0xa3, 0xec, 0xc3, 0xed,
      0x27, 0xfb, 0x31, 0x88, 0xa5, 0xed, 0x9f, 0x24, 0xcd, 0xbd, 0x29, 0xd1,
      0xb0, 0xf0, 0x3f, 0xf8, 0x5f, 0xd7, 0xfc, 0xad, 0x4e, 0xa5, 0xbb, 0xd8,
      0xbd, 0x4c, 0x42, 0x93, 0x5f, 0x09, 0x57, 0xca, 0x80, 0x11, 0xcf, 0xc9,
      0x3e, 0xbe, 0xb7, 0x89, 0xc4, 0x72, 0x14, 0xe6, 0x0e, 0x5d, 0xa1, 0x6e,
      0x4d, 0xd8, 0x7a, 0x53, 0x54, 0x7e, 0xed, 0xee, 0x47, 0x9b, 0x09, 0x78},
     {0x85, 0xa8, 0xdd, 0xb9, 0x99, 0x7e, 0x25, 0x25, 0xcd, 0x55, 0x57, 0x21,
      0xf2, 0xd5, 0xf3, 0xb1, 0x99, 0xff, 0x76, 0xb5, 0x7e, 0x91, 0xee, 0xc6,
      0xfc, 0x7d, 0x2c, 0x95, 0x70, 0x3a, 0x1a, 0x32, 0xf4, 0x6e, 0x3d, 0x46,
      0x95, 0x2a, 0x90, 0xb5, 0x10, 0x54, 0xc5, 0xfd, 0x04, 0x6b, 0x31, 0x07},
     false,
     true},

    // Comment: point with coordinate x = 0 in right to left addition chain
    // tcID: 112
    {112,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x23, 0x95, 0xd0, 0x07, 0x79, 0xb6, 0xc7, 0xd4, 0xda, 0xd8, 0xcc, 0x9a,
      0x89, 0x18, 0x49, 0x6c, 0x28, 0xb2, 0xd4, 0x07, 0x7e, 0x68, 0x86, 0xd0,
      0xa1, 0xbe, 0xf5, 0x15, 0xe3, 0x12, 0x5d, 0xdd, 0x81, 0x3e, 0x5a, 0x9e,
      0xa0, 0xf1, 0x85, 0xcd, 0x00, 0x9a, 0x69, 0xea, 0x92, 0x21, 0x01, 0x74,
      0xb6, 0x76, 0x77, 0x5f, 0x76, 0x31, 0x83, 0xc8, 0x6f, 0x6f, 0xa5, 0x05,
      0x51, 0xba, 0x13, 0x7d, 0x79, 0xa8, 0x3e, 0x8e, 0x32, 0xff, 0x2f, 0xc0,
      0x9a, 0x2c, 0x28, 0xcd, 0xf8, 0x0c, 0xdd, 0xaf, 0xcc, 0x0f, 0x40, 0x69,
      0x3e, 0x39, 0x85, 0xf2, 0x8f, 0xe5, 0xc7, 0xdf, 0xe2, 0xd8, 0xb2, 0x75},
     {0xc2, 0x69, 0x46, 0x5c, 0xfb, 0x33, 0x6e, 0xd8, 0xc7, 0xe9, 0xc0, 0x37,
      0x73, 0x49, 0x19, 0x3a, 0xa4, 0xdb, 0xdb, 0x92, 0xa9, 0xf4, 0x67, 0x0d,
      0xbf, 0x7f, 0xa7, 0xa1, 0xf7, 0x55, 0x6e, 0x8e, 0x4b, 0x24, 0x0d, 0x5b,
      0x70, 0xed, 0xee, 0xdd, 0x1b, 0xf5, 0xce, 0x76, 0x9c, 0xb8, 0x41, 0x5e},
     false,
     true},

    // Comment: point with coordinate x = 0 in right to left addition chain
    // tcID: 113
    {113,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x56, 0x34, 0xee, 0x15, 0x52, 0x63, 0xc0, 0x7d, 0x7d, 0x1e, 0x34, 0x6b,
      0x86, 0x8d, 0xdd, 0x80, 0xe9, 0xa2, 0x82, 0xfc, 0xef, 0x93, 0xbf, 0x6d,
      0xf8, 0xe8, 0xbc, 0x4e, 0xa3, 0x4f, 0xf0, 0x2e, 0x11, 0x9a, 0x9f, 0x70,
      0x78, 0x16, 0xd0, 0x63, 0x68, 0xcc, 0xb9, 0x4c, 0x6e, 0x48, 0x02, 0xfb,
      0xaa, 0xdc, 0x33, 0x99, 0x15, 0x74, 0xdd, 0xe8, 0x51, 0xe5, 0x47, 0xe4,
      0x70, 0x27, 0xf5, 0x43, 0x53, 0xe0, 0x2d, 0x70, 0xbe, 0x6b, 0xfa, 0x9f,
      0x73, 0x95, 0x3c, 0xa2, 0x59, 0x01, 0x1f, 0x23, 0xa4, 0xa8, 0x0c, 0xbb,
      0xaa, 0xe8, 0x80, 0x5d, 0x9d, 0x09, 0x4e, 0xf1, 0x50, 0xe0, 0xc5, 0x4a},
     {0x6a, 0x21, 0xf2, 0x44, 0x47, 0x25, 0x22, 0x38, 0x9f, 0x08, 0x4e, 0x2e,
      0x4a, 0xe9, 0x9b, 0x74, 0x7b, 0x39, 0xcb, 0xee, 0x99, 0x6c, 0xe9, 0xa3,
      0xfa, 0x05, 0x35, 0x32, 0x19, 0xb6, 0x0c, 0x20, 0xfa, 0x38, 0x34, 0xd3,
      0x9b, 0x0b, 0x82, 0x6f, 0x10, 0x96, 0xb7, 0xa4, 0x67, 0xe8, 0xa2, 0x18},
     false,
     true},

    // Comment: point with coordinate x = 0 in right to left addition chain
    // tcID: 114
    {114,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x63, 0xaa, 0x6c, 0x3c, 0x24, 0x9a, 0x32, 0xeb, 0xbc, 0xcc, 0xe6, 0x5f,
      0xfa, 0x1c, 0x56, 0xa2, 0x05, 0x64, 0x4b, 0x2c, 0x40, 0xb9, 0x31, 0xb1,
      0xec, 0x9b, 0x04, 0x2b, 0x52, 0xc1, 0xe9, 0x9c, 0xd0, 0x7e, 0x53, 0x82,
      0x99, 0xfb, 0x83, 0x7f, 0xe6, 0x75, 0x86, 0xaa, 0xe7, 0x1b, 0x47, 0x06,
      0x16, 0x6a, 0xc4, 0x50, 0xfb, 0xd6, 0xd4, 0x92, 0x1b, 0x44, 0x2a, 0x11,
      0x67, 0x9f, 0x77, 0x86, 0xba, 0x5a, 0x77, 0x2a, 0xb3, 0x3d, 0xb0, 0x05,
      0x43, 0xa9, 0x41, 0xbb, 0xc0, 0x15, 0xe2, 0x35, 0x81, 0xba, 0x62, 0x5a,
      0x72, 0xc0, 0xe4, 0xeb, 0x44, 0x83, 0x8e, 0x5f, 0x40, 0x6c, 0xa1, 0xdc},
     {0xc4, 0x69, 0x91, 0x9f, 0x58, 0xd8, 0x0b, 0x1e, 0x45, 0xd5, 0xd5, 0x3e,
      0xe2, 0x8d, 0x61, 0x6b, 0xdf, 0x82, 0x7a, 0x88, 0xe0, 0xb2, 0xf4, 0x99,
      0x29, 0x1e, 0xc4, 0xf7, 0x6c, 0x3c, 0x89, 0xf2, 0x76, 0x77, 0x6e, 0xa9,
      0x6a, 0x6b, 0x90, 0x53, 0xcf, 0x02, 0x77, 0x66, 0x98, 0x86, 0x45, 0x26},
     false,
     true},

    // Comment: point with coordinate x = 0 in right to left addition chain
    // tcID: 115
    {115,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xa2, 0x87, 0xbd, 0x74, 0xd5, 0x01, 0xc2, 0x9d, 0xf2, 0x3d, 0x78, 0x6b,
      0x7c, 0x34, 0xea, 0x0d, 0xaf, 0x10, 0xe4, 0xb3, 0xfc, 0xe7, 0x1d, 0x72,
      0x0f, 0x61, 0xa2, 0x72, 0xf2, 0x21, 0x51, 0xdb, 0x2c, 0x59, 0x14, 0x86,
      0x74, 0x93, 0x02, 0x8c, 0x01, 0xe1, 0x03, 0x82, 0x0b, 0x0b, 0xa6, 0xb1,
      0x21, 0xcb, 0x29, 0x8f, 0xf8, 0x97, 0x7e, 0xcf, 0x21, 0xfe, 0xa8, 0xee,
      0x1b, 0x6b, 0xa7, 0xd9, 0xb9, 0x8d, 0xac, 0xc2, 0xa4, 0x5d, 0x75, 0xc6,
      0x3e, 0xc8, 0x32, 0x30, 0x01, 0xa9, 0xbf, 0x5f, 0x5b, 0xa4, 0xd3, 0xcb,
      0xfe, 0xe8, 0x04, 0x82, 0xca, 0x13, 0x33, 0xf4, 0xde, 0x90, 0xa1, 0x4a},
     {0x18, 0xdd, 0x1d, 0x7b, 0x6b, 0xbc, 0x63, 0x11, 0xaf, 0xe5, 0x38, 0x3d,
      0x79, 0x6a, 0x5f, 0xec, 0x13, 0x84, 0x4b, 0xae, 0x25, 0x70, 0x87, 0x25,
      0x55, 0x4d, 0xe0, 0xb5, 0xf0, 0x3e, 0xc0, 0xf7, 0xd2, 0xe6, 0x3b, 0x64,
      0xdb, 0x5f, 0x83, 0xd4, 0xee, 0x98, 0x90, 0xc6, 0x1e, 0x44, 0x2c, 0x41},
     false,
     true},

    // Comment: point with coordinate x = 0 in right to left addition chain
    // tcID: 116
    {116,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xba, 0x40, 0x6b, 0x46, 0xc1, 0xd9, 0x2d, 0x4b, 0xa3, 0xf4, 0x0b, 0x7b,
      0x1f, 0xcf, 0x1e, 0x18, 0x22, 0x89, 0xb8, 0x4c, 0xdb, 0x38, 0x7f, 0x28,
      0xe5, 0xad, 0x20, 0xf1, 0xed, 0x8c, 0x43, 0xfe, 0x5f, 0xfa, 0x37, 0x12,
      0x84, 0x62, 0x76, 0x30, 0x51, 0xe8, 0x7f, 0x0d, 0x5e, 0xbf, 0xcd, 0x9d,
      0x9d, 0xd4, 0x10, 0x7c, 0xe4, 0xd9, 0x2d, 0x78, 0x3d, 0x0f, 0x0f, 0x81,
      0xd7, 0xa9, 0x98, 0xb7, 0x60, 0x60, 0x73, 0x5b, 0x6f, 0xd6, 0x3b, 0xfc,
      0xd9, 0x71, 0xca, 0x70, 0x13, 0x2f, 0xe6, 0xdc, 0x9f, 0xbf, 0x85, 0x34,
      0xec, 0xc7, 0x4b, 0x50, 0x1e, 0xa0, 0x1c, 0xd2, 0xe4, 0xf6, 0xc5, 0x64},
     {0xd6, 0x39, 0xb9, 0xc3, 0x1a, 0xd3, 0xce, 0xdd, 0xda, 0x77, 0x45, 0xd1,
      0x9e, 0x82, 0xfd, 0xe2, 0x72, 0xa8, 0x6d, 0x31, 0xf8, 0xe6, 0xc2, 0x03,
      0xee, 0xd5, 0x3b, 0xcb, 0x70, 0x5e, 0x9f, 0xf5, 0x8d, 0x65, 0x9f, 0x8e,
      0x9d, 0x66, 0xaa, 0x04, 0x92, 0xda, 0x54, 0x5a, 0x39, 0x92, 0x94, 0xec},
     false,
     true},

    // Comment: point with coordinate y = 1
    // tcID: 117
    {117,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x22, 0x61, 0xb2, 0xbf, 0x60, 0x5c, 0x22, 0xf2, 0xf3, 0xae, 0xf6, 0x33,
      0x87, 0x19, 0xb2, 0xc4, 0x86, 0x38, 0x8a, 0xd5, 0x24, 0x07, 0x19, 0xa5,
      0x25, 0x73, 0x15, 0x96, 0x9e, 0xf0, 0x1b, 0xa2, 0x7f, 0x0a, 0x10, 0x4c,
      0x89, 0x70, 0x47, 0x73, 0xa8, 0x1f, 0xda, 0xbe, 0xe6, 0xab, 0x5c, 0x78,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01},
     {0xc9, 0x23, 0xfb, 0x0d, 0x4b, 0x24, 0xe9, 0x96, 0xe5, 0xe0, 0xd5, 0xdf,
      0x15, 0x1d, 0x3c, 0x26, 0xb1, 0xf6, 0x1c, 0x05, 0xb1, 0x7b, 0x7f, 0xb3,
      0x9f, 0xc8, 0x59, 0x0b, 0x47, 0xee, 0xaf, 0xf3, 0x47, 0x09, 0xf6, 0xf7,
      0x32, 0x89, 0x23, 0xbd, 0xca, 0xf7, 0xe8, 0xe4, 0x13, 0xd7, 0x7d, 0xdc},
     false,
     true},

    // Comment: point with coordinate y = 1
    // tcID: 118
    {118,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xd3, 0x9c, 0x38, 0xaa, 0xfa, 0x09, 0x52, 0x33, 0xef, 0x1a, 0xf8, 0xc0,
      0xf4, 0xaa, 0xf3, 0x57, 0xdd, 0x68, 0x41, 0x31, 0xb4, 0xac, 0x58, 0xa5,
      0x34, 0xf3, 0xd9, 0x44, 0x61, 0x96, 0xb6, 0x00, 0x92, 0x07, 0x2d, 0xc7,
      0xe5, 0x38, 0x10, 0x6b, 0x7b, 0x2e, 0x66, 0xdc, 0x33, 0xca, 0xc7, 0x28,
      0x3a, 0x1b, 0x20, 0x3f, 0xca, 0x47, 0x82, 0x8e, 0x6f, 0x7a, 0x09, 0xaf,
      0x64, 0x5a, 0xf0, 0xf7, 0x29, 0x80, 0x2c, 0xa2, 0xf4, 0x00, 0x0c, 0x4b,
      0x97, 0x73, 0xb0, 0x8c, 0x5a, 0xf4, 0x0e, 0x20, 0x1a, 0x27, 0x49, 0x3a,
      0xb3, 0xeb, 0xa9, 0xca, 0xd7, 0xda, 0x15, 0x7f, 0x89, 0xf1, 0x4a, 0x2c},
     {0xaf, 0x39, 0x04, 0xf8, 0x3b, 0x9a, 0x0e, 0x95, 0xee, 0x0b, 0x86, 0xb0,
      0x61, 0x55, 0x99, 0x3a, 0xe5, 0x98, 0xd1, 0x48, 0x98, 0x36, 0x6e, 0x5d,
      0xcf, 0xc6, 0x43, 0xde, 0x9d, 0x5a, 0xb7, 0x2f, 0xc5, 0xfb, 0xef, 0x17,
      0xd0, 0xa8, 0xfb, 0x36, 0xeb, 0xfd, 0xdc, 0xe4, 0x6e, 0x5d, 0x44, 0x55},
     false,
     true},

    // Comment: point with coordinate y = 1
    // tcID: 119
    {119,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x86, 0xda, 0x57, 0x85, 0x67, 0x78, 0x8e, 0xa3, 0xcc, 0x0f, 0x2a, 0x9d,
      0xa8, 0xd1, 0x39, 0x3e, 0xd3, 0xa4, 0x44, 0x7a, 0x75, 0xc1, 0x8e, 0xa8,
      0x6a, 0xf9, 0xd8, 0x4b, 0x0c, 0xac, 0xc3, 0xb0, 0x37, 0x49, 0x19, 0x98,
      0x90, 0xef, 0x8e, 0x5d, 0x31, 0x88, 0xd4, 0xf1, 0xd0, 0x41, 0xd4, 0x6e,
      0x43, 0x3a, 0xcd, 0x5d, 0x9f, 0x55, 0x42, 0x43, 0x9e, 0xb2, 0x38, 0x4e,
      0xc1, 0xde, 0x08, 0x47, 0xd0, 0x56, 0x05, 0x8e, 0xa9, 0x24, 0x89, 0xa7,
      0x4e, 0x08, 0x3f, 0xfd, 0x6e, 0x03, 0x0d, 0x06, 0x0f, 0xad, 0x67, 0x4f,
      0x6a, 0x2a, 0x9a, 0x7c, 0x21, 0x98, 0xb8, 0xbe, 0x9e, 0x46, 0x5b, 0xae},
     {0x11, 0x24, 0xbe, 0xdd, 0x4c, 0x53, 0x8a, 0xe7, 0x12, 0x93, 0x08, 0x5f,
      0x2c, 0x95, 0xcf, 0x6b, 0x13, 0xcf, 0xe7, 0x41, 0xf2, 0x1d, 0x62, 0xc1,
      0xf0, 0x2a, 0x1e, 0x91, 0x16, 0x67, 0xd5, 0x34, 0x8b, 0x16, 0xd8, 0xaf,
      0xb5, 0x44, 0x02, 0x1a, 0xcd, 0xc3, 0xcb, 0x74, 0x48, 0xd4, 0xd3, 0x58},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 120
    {120,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x11, 0x14, 0x47, 0xd2, 0x42, 0xf6, 0xb4, 0x21, 0xca, 0x91, 0xf5, 0x61,
      0xd0, 0x4b, 0x2f, 0x1d, 0x2f, 0x0d, 0x92, 0x12, 0xd9, 0x18, 0xbb, 0x4a,
      0x0f, 0xfb, 0x1a, 0xe6, 0x45, 0x9d, 0x07, 0x8e, 0x21, 0xa3, 0x12, 0xb2,
      0xa1, 0x25, 0x94, 0xfc, 0x8c, 0x78, 0xfe, 0x94, 0x4c, 0x81, 0xd5, 0x13,
      0xd3, 0xc9, 0x81, 0xd5, 0xe9, 0xcd, 0xa0, 0x6c, 0x43, 0x80, 0xd1, 0xa8,
      0x42, 0xca, 0x5b, 0xb5, 0x1e, 0xd3, 0xa7, 0x12, 0xb0, 0x49, 0xdd, 0xa3,
      0xa5, 0x0c, 0xe1, 0x0a, 0x9f, 0xbd, 0x0b, 0x69, 0xdf, 0xff, 0xaf, 0xf0,
      0x78, 0x7c, 0x74, 0xd8, 0x32, 0x37, 0xba, 0x9c, 0x46, 0x86, 0xa0, 0x1e},
     {0x69, 0x42, 0x61, 0x58, 0xa2, 0x99, 0x71, 0xef, 0x44, 0xb1, 0x17, 0x83,
      0xef, 0x55, 0x9e, 0xf4, 0x29, 0x72, 0x46, 0x61, 0x1c, 0x99, 0x4d, 0x48,
      0x15, 0x63, 0x71, 0x28, 0x86, 0x9d, 0x5f, 0x6a, 0x02, 0x02, 0x63, 0x2f,
      0xe9, 0xb5, 0xad, 0x7c, 0x36, 0x5b, 0x63, 0x05, 0x0c, 0x9f, 0x2d, 0x08},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 121
    {121,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xd7, 0xcd, 0x50, 0x24, 0xc4, 0x48, 0x1e, 0x27, 0xd1, 0x65, 0x35, 0x66,
      0x15, 0x2e, 0xfb, 0xa3, 0x28, 0x4b, 0x50, 0xba, 0x2a, 0x14, 0x1b, 0x26,
      0x43, 0xff, 0xda, 0x18, 0xf3, 0x00, 0xfa, 0x64, 0xb8, 0x1b, 0x23, 0x4b,
      0x8f, 0x64, 0x6c, 0xab, 0x47, 0x28, 0xb4, 0xe7, 0xa9, 0x70, 0x24, 0xd7,
      0x68, 0x50, 0xae, 0xc0, 0xa2, 0xd1, 0x31, 0xc6, 0xac, 0xd5, 0xb2, 0x98,
      0xb6, 0xf9, 0x05, 0xcd, 0xba, 0x18, 0xe6, 0x85, 0x64, 0xbc, 0x31, 0xf8,
      0x82, 0xfe, 0xd5, 0x1b, 0x28, 0x78, 0x6a, 0x2e, 0x72, 0xf8, 0x81, 0x26,
      0x68, 0xc9, 0x76, 0xf9, 0xdd, 0xc0, 0x42, 0x69, 0x55, 0x95, 0xfc, 0x6f},
     {0x65, 0x97, 0x40, 0x1c, 0x83, 0x7f, 0xb4, 0x98, 0xef, 0x07, 0x80, 0xa3,
      0x82, 0xde, 0xcd, 0x4a, 0x0d, 0xd5, 0x80, 0xe1, 0xaf, 0x5f, 0x24, 0xc4,
      0x4a, 0xc1, 0x64, 0xe2, 0x56, 0xa4, 0x88, 0x4a, 0xd5, 0xbd, 0x2f, 0xb1,
      0xf6, 0xc9, 0x64, 0x68, 0x2c, 0xb0, 0xbf, 0x79, 0xe2, 0xc7, 0xa6, 0xc6},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 122
    {122,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe3, 0x14, 0x87, 0x54, 0x80, 0x37, 0xc0, 0x42, 0x3e, 0x57, 0x10, 0xfc,
      0x60, 0xe7, 0x46, 0xab, 0x6e, 0x47, 0x35, 0x25, 0x61, 0xe4, 0x16, 0xb5,
      0x83, 0x12, 0x3a, 0x6d, 0x45, 0xca, 0xa9, 0x11, 0x76, 0x2c, 0xd8, 0x8a,
      0x60, 0xbc, 0xe5, 0x7b, 0x29, 0xa2, 0xec, 0x1a, 0x1d, 0xc9, 0x7f, 0xc1,
      0xbd, 0x4b, 0x60, 0x40, 0x38, 0xe6, 0xac, 0x01, 0x6d, 0xbd, 0xd4, 0x8f,
      0x0e, 0x6b, 0xd9, 0xf4, 0xb5, 0xda, 0xad, 0x8d, 0x68, 0xfc, 0x28, 0x83,
      0x8c, 0x6a, 0xb4, 0xa4, 0xeb, 0x5a, 0xb0, 0xea, 0xea, 0x2c, 0xbd, 0xef,
      0xa6, 0x1d, 0xc5, 0x7a, 0x3e, 0x04, 0xae, 0x71, 0x24, 0x29, 0x38, 0xb6},
     {0x89, 0x41, 0x1d, 0x9c, 0x81, 0x49, 0xb9, 0x51, 0xfa, 0x0d, 0x5b, 0xea,
      0x1e, 0x14, 0x1b, 0xdf, 0xc2, 0xbe, 0x7e, 0xd5, 0x6d, 0x5e, 0x61, 0x47,
      0x39, 0x35, 0x78, 0x90, 0x16, 0xbf, 0xd2, 0xda, 0xf6, 0xa4, 0x0a, 0xc7,
      0xbf, 0x5b, 0x1b, 0x0c, 0x0c, 0x02, 0xcd, 0x3a, 0xa0, 0xb2, 0xd9, 0x5f},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 123
    {123,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x1e, 0x17, 0xe1, 0x73, 0xd3, 0x7a, 0xb9, 0x83, 0x82, 0x83, 0xf8, 0x4f,
      0x24, 0xa0, 0xa2, 0x5c, 0xaa, 0xa6, 0x0c, 0x41, 0x1f, 0xbf, 0xea, 0x58,
      0x2c, 0x44, 0xf8, 0xfb, 0xa2, 0x56, 0x0e, 0xce, 0x02, 0x8c, 0xbe, 0x39,
      0x7b, 0x0e, 0xda, 0x69, 0xfc, 0x87, 0x2d, 0x80, 0xd9, 0xeb, 0xe0, 0x65,
      0x78, 0x9c, 0x07, 0x23, 0xea, 0xfc, 0xc9, 0xe9, 0xa2, 0xba, 0xd4, 0x31,
      0xb1, 0x1c, 0xaf, 0x7c, 0x5d, 0x75, 0x98, 0xca, 0x99, 0x90, 0x74, 0x05,
      0x6b, 0xa8, 0x08, 0xa5, 0xd0, 0x79, 0x77, 0xc6, 0x78, 0xf9, 0x53, 0x4d,
      0xe1, 0x52, 0xff, 0xda, 0xca, 0x3f, 0x63, 0xcb, 0xa3, 0xf9, 0x78, 0x94},
     {0x6f, 0x0a, 0xa1, 0x1a, 0xb7, 0x4a, 0xe5, 0x03, 0x4e, 0x23, 0x1e, 0xf2,
      0x63, 0x0b, 0xc7, 0x6c, 0xda, 0x6e, 0xed, 0x26, 0x32, 0x5d, 0x12, 0x36,
      0x42, 0xfc, 0xe6, 0xa9, 0x50, 0xb5, 0x0f, 0x90, 0x4b, 0xc0, 0x26, 0x9f,
      0x8f, 0x58, 0x9b, 0xc4, 0xd3, 0x81, 0x07, 0x33, 0x2b, 0x14, 0xda, 0x84},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 124
    {124,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x76, 0xef, 0xcc, 0x83, 0x22, 0xf0, 0xaf, 0x8d, 0x62, 0xe7, 0x36, 0xa0,
      0xe1, 0x10, 0xf6, 0x6b, 0x3a, 0xad, 0x5c, 0x87, 0xbf, 0x7a, 0x77, 0x33,
      0x3f, 0xce, 0x86, 0x4f, 0x4b, 0xa6, 0xe8, 0xdf, 0xdc, 0x16, 0xd6, 0xad,
      0xd2, 0xc5, 0x42, 0xc4, 0x80, 0x55, 0x89, 0xa7, 0x1f, 0x0e, 0x48, 0xa3,
      0xc2, 0x68, 0xfe, 0xab, 0x02, 0x71, 0x4c, 0x89, 0x2f, 0x82, 0x66, 0x22,
      0xb2, 0x5b, 0xd2, 0x1c, 0xe2, 0xa3, 0x35, 0x14, 0xb1, 0x6c, 0x9e, 0xe8,
      0x4c, 0x72, 0x2b, 0x52, 0x3b, 0x19, 0xec, 0x5f, 0xc3, 0x4d, 0x87, 0x41,
      0x33, 0x08, 0x0e, 0x15, 0x89, 0x81, 0x84, 0x93, 0x55, 0xe1, 0xf5, 0x0d},
     {0x7e, 0xb9, 0x96, 0x2e, 0x04, 0x49, 0xcc, 0xd2, 0xe6, 0x0b, 0x4f, 0x80,
      0x94, 0xd5, 0xa7, 0xb4, 0x61, 0xd0, 0xd4, 0xb0, 0x6a, 0xf0, 0xba, 0x30,
      0x6b, 0x74, 0xab, 0x0d, 0x60, 0xad, 0x5c, 0xf8, 0x94, 0xfb, 0xfc, 0x28,
      0x2a, 0xc8, 0xdc, 0xa3, 0xda, 0x19, 0x6d, 0x7a, 0x29, 0x6b, 0xaa, 0x14},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 125
    {125,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc1, 0x47, 0xd6, 0xc2, 0x35, 0xd7, 0x40, 0xb3, 0x88, 0xe6, 0xd2, 0xaf,
      0xaf, 0xcf, 0x85, 0xd5, 0xb7, 0x16, 0x6e, 0x0d, 0xf4, 0xea, 0x21, 0x29,
      0x40, 0x88, 0xe3, 0x04, 0x9b, 0x5c, 0x27, 0xd7, 0x63, 0x3c, 0x93, 0xd3,
      0x0f, 0xdc, 0xf2, 0xb9, 0x37, 0x5e, 0x18, 0x14, 0xf5, 0x1b, 0x57, 0xbb,
      0xef, 0xb2, 0xc1, 0x25, 0x75, 0xc2, 0x23, 0x4e, 0xe1, 0xf6, 0xb1, 0x47,
      0xb2, 0xe0, 0x4c, 0x10, 0x4a, 0x4d, 0x2b, 0x29, 0xcd, 0x84, 0x58, 0xf5,
      0x9b, 0x57, 0xbf, 0xf7, 0x5c, 0xab, 0x9b, 0x6a, 0xcb, 0xe8, 0x54, 0xfc,
      0x4d, 0x96, 0xfb, 0x73, 0x37, 0x2d, 0x60, 0x54, 0xbb, 0x76, 0x83, 0x90},
     {0x79, 0x02, 0x95, 0xbe, 0xd6, 0x9f, 0x53, 0x47, 0xec, 0xaa, 0xe9, 0xbe,
      0xfe, 0x15, 0xcd, 0x34, 0x99, 0x75, 0x9c, 0xdf, 0xbe, 0x51, 0x97, 0x4b,
      0x1f, 0x1c, 0x4b, 0xc5, 0x76, 0xe7, 0xd8, 0x81, 0xce, 0xfa, 0x93, 0xd5,
      0xe8, 0xbf, 0x2c, 0x21, 0xeb, 0xb9, 0x82, 0x69, 0x8e, 0x1c, 0x7a, 0xeb},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 126
    {126,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x84, 0x9c, 0x98, 0xff, 0xf5, 0xe3, 0x1b, 0x10, 0x8a, 0xef, 0xb1, 0x6c,
      0xc5, 0xcf, 0x5c, 0x7e, 0x88, 0x43, 0x9d, 0x8b, 0x3e, 0xf1, 0x88, 0xf2,
      0xa5, 0xbc, 0x53, 0xf3, 0x09, 0x01, 0xde, 0xdf, 0xe2, 0x94, 0xab, 0xb3,
      0x8f, 0xb8, 0xcb, 0x46, 0x54, 0x7a, 0x23, 0xcf, 0xe4, 0x79, 0x09, 0xd6,
      0x56, 0x44, 0x9f, 0x8a, 0x09, 0xaa, 0x88, 0xf8, 0xe2, 0x60, 0x59, 0x8e,
      0xa2, 0x77, 0x2d, 0xf7, 0x4d, 0x26, 0xa4, 0x43, 0x1a, 0x03, 0x78, 0x59,
      0x34, 0x37, 0x3b, 0xe7, 0xb0, 0xec, 0x91, 0x87, 0xb8, 0x21, 0x59, 0x65,
      0x76, 0x17, 0x23, 0xe7, 0x95, 0x91, 0x17, 0x69, 0x60, 0xea, 0xc0, 0x14},
     {0x58, 0xa1, 0x1a, 0x17, 0xc4, 0xad, 0xa4, 0xd4, 0x46, 0xc0, 0x8b, 0x83,
      0xaa, 0x05, 0x68, 0x7f, 0xee, 0x8f, 0xd6, 0xe7, 0x83, 0x03, 0x64, 0x8b,
      0x85, 0x83, 0x26, 0x21, 0x97, 0xf8, 0x7b, 0xe9, 0x7d, 0xbe, 0x0b, 0xbd,
      0x27, 0x4e, 0x44, 0x4a, 0x38, 0x4e, 0x22, 0x16, 0x96, 0x53, 0x0f, 0xc9},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 127
    {127,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x57, 0xcf, 0x64, 0x55, 0x78, 0xdd, 0x24, 0x2c, 0x71, 0x4d, 0x10, 0x0d,
      0xd2, 0x35, 0x68, 0xb1, 0x6d, 0x37, 0x45, 0xda, 0x80, 0x97, 0x08, 0xd0,
      0x1e, 0xb6, 0xa7, 0x16, 0x8e, 0x6f, 0x71, 0xde, 0xc2, 0x07, 0x4c, 0x5a,
      0x6c, 0x23, 0xbd, 0x05, 0x52, 0x3d, 0xfc, 0xcc, 0x97, 0xde, 0xa6, 0xf0,
      0x8d, 0xa1, 0x95, 0xda, 0xa2, 0x05, 0x6d, 0xa0, 0x57, 0x6b, 0xbc, 0x0f,
      0xfb, 0x5e, 0x73, 0xbb, 0xda, 0xd0, 0x3b, 0x04, 0xd2, 0x3b, 0x4b, 0x60,
      0x24, 0x51, 0xa5, 0xba, 0x91, 0xb1, 0x7d, 0xce, 0x30, 0x2f, 0x4a, 0xd1,
      0x64, 0xc6, 0xa4, 0xa2, 0xb5, 0x8e, 0x3f, 0x02, 0x53, 0xa5, 0xe9, 0xd6},
     {0x92, 0x60, 0x48, 0x3a, 0x16, 0x56, 0x90, 0xd5, 0x4c, 0x10, 0xcb, 0x86,
      0x7a, 0x9f, 0x89, 0x6b, 0xbd, 0x12, 0x3d, 0x47, 0x68, 0xa1, 0x8d, 0x32,
      0x23, 0x00, 0xd4, 0x20, 0xaa, 0xc8, 0x8a, 0xe2, 0x0f, 0x18, 0x8b, 0x57,
      0xf8, 0xe9, 0x7a, 0xfa, 0xd5, 0x5e, 0xbb, 0x81, 0x57, 0x28, 0xf4, 0x9a},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 128
    {128,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xca, 0xb2, 0xd9, 0xd3, 0x6c, 0x8e, 0xc0, 0x9f, 0x18, 0xba, 0xa0, 0xab,
      0xb5, 0x21, 0x37, 0x2a, 0x5c, 0xc2, 0xf6, 0x24, 0x84, 0x8f, 0x95, 0x46,
      0x0a, 0x86, 0x15, 0x23, 0x8e, 0x68, 0xc1, 0x1c, 0x1b, 0x43, 0xd2, 0x2b,
      0x84, 0xd1, 0xe5, 0x35, 0xec, 0x1d, 0x85, 0x56, 0x0d, 0xe2, 0x93, 0xce,
      0x1f, 0xd5, 0xe6, 0xe7, 0xac, 0x7e, 0xb6, 0xf1, 0x73, 0xad, 0x27, 0xb6,
      0x39, 0x85, 0xfc, 0xc8, 0x3b, 0x95, 0x32, 0xaa, 0x56, 0xf2, 0xb5, 0x9b,
      0x53, 0xa9, 0xd1, 0x16, 0x09, 0x8f, 0xda, 0x9a, 0xba, 0x49, 0xd5, 0x7c,
      0x1e, 0xed, 0x0f, 0x06, 0x3b, 0xcc, 0x70, 0x1b, 0xb1, 0x0f, 0x6c, 0x2b},
     {0xb4, 0x67, 0x9a, 0xf8, 0x0a, 0x2a, 0xd3, 0x4e, 0xf8, 0x6e, 0xac, 0xf2,
      0xc2, 0x19, 0x15, 0x56, 0xbc, 0x02, 0x40, 0xc7, 0x91, 0x3f, 0xb1, 0x4c,
      0x4c, 0x1f, 0x86, 0x23, 0xb5, 0xdb, 0x41, 0xb8, 0x54, 0xd6, 0x30, 0xdc,
      0x65, 0x73, 0x8d, 0x1f, 0xaf, 0x54, 0x4a, 0xa4, 0x29, 0x79, 0xae, 0xd0},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 129
    {129,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xd7, 0x1d, 0xf4, 0x09, 0x5c, 0x13, 0x85, 0x23, 0x34, 0x0a, 0x40, 0x10,
      0xcf, 0xa9, 0x76, 0xb3, 0xb2, 0x7a, 0xf4, 0x8c, 0xa8, 0x3e, 0x8c, 0x6b,
      0xb4, 0x59, 0x6f, 0x9f, 0x8e, 0x8f, 0x13, 0xe3, 0x8d, 0xe4, 0xe2, 0x5c,
      0xe1, 0xd3, 0x79, 0xb4, 0x1a, 0x95, 0xf9, 0xd7, 0xf8, 0xa8, 0x46, 0x06,
      0xb2, 0x8c, 0x69, 0x70, 0x4b, 0x68, 0x78, 0x8e, 0xb6, 0xa3, 0x5c, 0x8b,
      0xca, 0xa7, 0xd9, 0x71, 0x8e, 0x00, 0xc9, 0xbc, 0x56, 0x7a, 0xcd, 0xc4,
      0x58, 0xb6, 0x73, 0x2a, 0xa8, 0x70, 0x41, 0xd2, 0x7b, 0x6a, 0x57, 0x4d,
      0x51, 0xe9, 0x54, 0x37, 0x85, 0x5b, 0xdc, 0x86, 0x74, 0x8c, 0x5c, 0xac},
     {0x8a, 0x34, 0xde, 0x8b, 0xeb, 0x88, 0x43, 0x64, 0xb5, 0x83, 0xc9, 0xcb,
      0xce, 0x39, 0x09, 0x69, 0x96, 0x7c, 0xc2, 0xa5, 0x00, 0x90, 0xee, 0x13,
      0x2a, 0xcb, 0xd4, 0x9b, 0xf7, 0x80, 0xad, 0x7f, 0x09, 0x2a, 0xe3, 0xeb,
      0xd4, 0x68, 0x6a, 0x70, 0xba, 0x55, 0x4e, 0xfd, 0xd6, 0xac, 0xd4, 0xed},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 130
    {130,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xa5, 0x76, 0x17, 0x75, 0x85, 0x0a, 0x25, 0x98, 0x5a, 0x32, 0x43, 0x04,
      0x42, 0xd6, 0x60, 0xaa, 0xdf, 0x9e, 0x1e, 0x38, 0x8b, 0x57, 0xe6, 0xe1,
      0xbf, 0xe4, 0x14, 0x95, 0xb9, 0xa0, 0x5a, 0x82, 0x40, 0xf7, 0x7f, 0x33,
      0x97, 0xc5, 0xcd, 0xb0, 0xc8, 0x3d, 0x73, 0x94, 0x59, 0x84, 0xab, 0xed,
      0xd2, 0xc7, 0xcf, 0xa5, 0xd5, 0xd9, 0x17, 0x38, 0xc6, 0x57, 0x76, 0x46,
      0x65, 0x8c, 0x04, 0x48, 0xf0, 0x15, 0x5b, 0x5b, 0xf8, 0x39, 0x57, 0x5a,
      0x36, 0xd1, 0xb2, 0x6d, 0x87, 0xd1, 0xb2, 0xb3, 0xaf, 0xb4, 0xf6, 0x86,
      0x53, 0xa6, 0xbf, 0xa5, 0xed, 0xfc, 0x57, 0xaa, 0x85, 0x29, 0xe6, 0x22},
     {0x79, 0x0d, 0xfc, 0xff, 0x47, 0x21, 0xef, 0x17, 0x01, 0xe3, 0xff, 0x52,
      0x1e, 0x42, 0x21, 0xbe, 0x51, 0xae, 0x24, 0x2f, 0x95, 0x16, 0x6b, 0x92,
      0x92, 0xc7, 0xaa, 0x2f, 0xa3, 0xc9, 0xb7, 0x99, 0xaf, 0xd3, 0x53, 0x98,
      0x7a, 0x53, 0x56, 0x90, 0xff, 0x20, 0xd6, 0x6f, 0x57, 0x8f, 0x38, 0xfc},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 131
    {131,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x54, 0xfc, 0x2f, 0x89, 0xcd, 0xe6, 0xf6, 0xe8, 0x6b, 0x6c, 0xf3, 0x28,
      0x61, 0x98, 0xf9, 0xa9, 0xe3, 0x3c, 0x8d, 0x66, 0x2c, 0x21, 0x51, 0x20,
      0x5d, 0xdc, 0xff, 0x12, 0xe2, 0xd3, 0x2f, 0xa8, 0x91, 0xee, 0xc2, 0x35,
      0x9b, 0xc0, 0x72, 0x24, 0xd6, 0x4c, 0x5e, 0x33, 0x9f, 0xf9, 0xd5, 0x89,
      0x18, 0xa3, 0xb7, 0x93, 0x72, 0xd1, 0x42, 0xfb, 0x34, 0x1d, 0xf3, 0xb1,
      0x5b, 0x54, 0xb3, 0x0e, 0x8f, 0x95, 0x6b, 0x07, 0x9b, 0x12, 0x78, 0x27,
      0x6a, 0x33, 0xb4, 0xd8, 0x50, 0x89, 0x20, 0x94, 0x0c, 0xa6, 0x3f, 0xb8,
      0xe9, 0x70, 0xff, 0x98, 0xf9, 0x1e, 0xcc, 0x79, 0x86, 0x27, 0x5e, 0xdb},
     {0xcb, 0x86, 0x10, 0x53, 0xc1, 0xd6, 0x85, 0x19, 0x4e, 0xa5, 0x84, 0x13,
      0xd8, 0xf9, 0x98, 0x1e, 0x07, 0x14, 0x5b, 0xc5, 0x73, 0xba, 0x92, 0x4b,
      0xdb, 0xa2, 0xe2, 0x9c, 0x5f, 0x98, 0xe9, 0xe7, 0x0e, 0xa0, 0xcd, 0x04,
      0x12, 0xd6, 0xc3, 0x87, 0x44, 0x9e, 0x9a, 0xe7, 0x67, 0xdc, 0x43, 0x30},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 132
    {132,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xbf, 0xbf, 0x3f, 0xab, 0x1a, 0xcb, 0x39, 0xce, 0x28, 0xf0, 0x63, 0xd7,
      0x8c, 0xf2, 0x50, 0x77, 0x2b, 0xd0, 0x0b, 0xdc, 0xa9, 0x8b, 0x76, 0x9e,
      0x1f, 0x1f, 0xd4, 0x42, 0xb7, 0x7f, 0x42, 0x70, 0x10, 0x6a, 0x5f, 0x7d,
      0x91, 0x3c, 0x19, 0x05, 0xbe, 0xa0, 0xdc, 0x75, 0xb3, 0x1f, 0x87, 0xa1,
      0x15, 0xc5, 0x66, 0xdb, 0xff, 0x0c, 0xd1, 0x07, 0x33, 0x25, 0x45, 0x0a,
      0x91, 0x09, 0x6f, 0xe5, 0xf5, 0xd6, 0x01, 0xa6, 0x36, 0x40, 0x7c, 0xfb,
      0xc4, 0xf5, 0x72, 0x0f, 0x39, 0x6f, 0xa6, 0xcb, 0x16, 0x98, 0x73, 0x70,
      0xce, 0x70, 0xe2, 0x9b, 0xb7, 0xed, 0x2f, 0x44, 0x74, 0x25, 0xf1, 0x0a},
     {0x37, 0x5f, 0xfb, 0x90, 0xad, 0x6c, 0x51, 0x86, 0x68, 0xe5, 0xd2, 0x59,
      0x41, 0xac, 0xd5, 0xf9, 0xc0, 0x17, 0x34, 0x6d, 0x06, 0xf8, 0x93, 0xcf,
      0x95, 0x75, 0x22, 0x58, 0xbc, 0xc5, 0xf9, 0xa2, 0x59, 0x96, 0xa8, 0x0f,
      0x42, 0xe0, 0x47, 0x5a, 0x80, 0x44, 0x3d, 0xc4, 0x19, 0x7b, 0xba, 0x6c},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 133
    {133,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x57, 0x57, 0x57, 0x74, 0x80, 0xf3, 0x2a, 0xed, 0xac, 0x6e, 0x19, 0x76,
      0x5f, 0x91, 0x97, 0xcc, 0x27, 0x8c, 0xb0, 0xb1, 0xa2, 0x1f, 0xc6, 0xb6,
      0x42, 0x3c, 0x8f, 0x6c, 0x6c, 0xde, 0xa1, 0xd3, 0x24, 0xc9, 0x3e, 0xea,
      0x8b, 0xd7, 0xdc, 0xca, 0x8f, 0xd2, 0x93, 0xd6, 0x98, 0x76, 0x52, 0x43,
      0x60, 0xb1, 0xa4, 0x82, 0x55, 0x22, 0xac, 0xd8, 0x33, 0xd3, 0x8d, 0xbd,
      0x61, 0x50, 0x85, 0x47, 0x35, 0x8a, 0x2f, 0x5c, 0x28, 0x1b, 0x49, 0x6a,
      0xbd, 0x57, 0x07, 0x2a, 0xb1, 0x4f, 0x9a, 0x22, 0x35, 0xbc, 0xa0, 0x25,
      0x45, 0xe0, 0x42, 0x75, 0x26, 0xbc, 0x2b, 0xbc, 0x92, 0x68, 0x34, 0x9f},
     {0xd1, 0xa0, 0x2a, 0x26, 0x4a, 0xb1, 0x5a, 0xef, 0x52, 0xa5, 0x34, 0xeb,
      0x50, 0x00, 0xe2, 0x94, 0x3d, 0x8c, 0xf1, 0xf7, 0x72, 0x55, 0xa2, 0x7f,
      0x84, 0x5e, 0x96, 0xe1, 0xf8, 0x1d, 0xf4, 0x7e, 0xe9, 0x03, 0xc3, 0xe9,
      0x21, 0x53, 0x9d, 0x77, 0xd7, 0x2f, 0x55, 0xb7, 0xef, 0xc9, 0xdf, 0xbb},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 134
    {134,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x14, 0x52, 0xf5, 0xea, 0xfb, 0xb5, 0xcc, 0x56, 0x3f, 0x2c, 0x7c, 0xa4,
      0x03, 0xb8, 0x03, 0xf6, 0xf8, 0xd6, 0x64, 0x79, 0x06, 0x25, 0x08, 0xa2,
      0x25, 0x8a, 0x8d, 0x98, 0x8a, 0x76, 0x9b, 0x80, 0xe0, 0x77, 0x73, 0x5b,
      0x45, 0xef, 0xab, 0x1f, 0x29, 0x7c, 0xee, 0xbd, 0x74, 0x34, 0x7f, 0x58,
      0x4f, 0x2b, 0xad, 0xbc, 0xa5, 0x54, 0x57, 0x40, 0x48, 0x66, 0xba, 0xef,
      0xab, 0xfa, 0x99, 0xb7, 0x0f, 0xbf, 0x10, 0x5d, 0x17, 0xf3, 0x52, 0x34,
      0x7f, 0x67, 0x99, 0x64, 0x74, 0x48, 0x70, 0x8f, 0x78, 0x8f, 0x8a, 0x14,
      0x5b, 0xdd, 0x96, 0xd4, 0xaf, 0x2d, 0x7e, 0x65, 0x4b, 0xe7, 0xe5, 0xf1},
     {0xcc, 0xaa, 0x37, 0x76, 0x9d, 0x03, 0x51, 0x70, 0xbb, 0x5c, 0x19, 0xc1,
      0x35, 0xda, 0x22, 0x91, 0x44, 0x6e, 0xfd, 0x7e, 0xcd, 0x3b, 0xe9, 0x00,
      0x86, 0x12, 0xb8, 0xcc, 0xc2, 0x9f, 0x6e, 0x9d, 0x7a, 0x45, 0xdd, 0x4e,
      0x04, 0x79, 0x12, 0x3f, 0x03, 0xe7, 0xe3, 0x04, 0xf3, 0x47, 0x29, 0xe9},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 135
    {135,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xad, 0x27, 0xa3, 0x65, 0xe4, 0xb6, 0x99, 0x4c, 0x5e, 0xd1, 0x35, 0xfc,
      0x47, 0x94, 0xd7, 0x3e, 0xb7, 0x1e, 0xc2, 0x6d, 0x78, 0x7f, 0xec, 0x10,
      0xf1, 0x38, 0x2b, 0x19, 0xc1, 0xb5, 0xcd, 0x1d, 0x67, 0x29, 0x99, 0xfe,
      0xee, 0x86, 0xd5, 0xf3, 0x05, 0x51, 0x6d, 0x60, 0x1f, 0xd1, 0xc6, 0xaa,
      0xf8, 0x66, 0x48, 0x58, 0x98, 0x8f, 0x02, 0xf3, 0x6c, 0x88, 0x8f, 0x71,
      0x87, 0x20, 0x07, 0x87, 0x0b, 0xb3, 0x26, 0x54, 0xaa, 0x75, 0x53, 0x0f,
      0xc3, 0xb7, 0xa2, 0x35, 0xf7, 0xfd, 0x2b, 0xcd, 0x81, 0x5e, 0x30, 0x34,
      0x45, 0x52, 0x69, 0x60, 0xf6, 0xff, 0xcd, 0xd6, 0x1d, 0x2d, 0x13, 0x40},
     {0x4a, 0xe9, 0x4d, 0x3e, 0xda, 0x58, 0x39, 0xf4, 0xb8, 0xb9, 0xff, 0xe6,
      0xd5, 0x10, 0x14, 0x4c, 0xf2, 0x8b, 0xde, 0x98, 0x58, 0x1e, 0x82, 0x72,
      0x6f, 0x2d, 0x76, 0xd9, 0x33, 0x91, 0x9a, 0xda, 0xb7, 0x1d, 0x2c, 0xdf,
      0x4c, 0x43, 0x10, 0xf8, 0xab, 0xcc, 0x74, 0xd7, 0x0e, 0xba, 0x3a, 0x33},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 136
    {136,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x73, 0x30, 0x41, 0xf3, 0xa6, 0x04, 0x68, 0xbc, 0x07, 0x11, 0xd5, 0xa5,
      0x07, 0x3a, 0x71, 0xef, 0x60, 0x62, 0xd0, 0xae, 0x70, 0x70, 0x6a, 0xf5,
      0x13, 0x16, 0x03, 0x35, 0x80, 0xca, 0xe0, 0x58, 0xfc, 0x4a, 0xc9, 0x9e,
      0xbb, 0xa8, 0x23, 0xb1, 0x9f, 0x48, 0xf3, 0x09, 0xe3, 0x4f, 0xb0, 0x29,
      0x33, 0x67, 0x0d, 0xcc, 0x75, 0xed, 0x47, 0x74, 0x47, 0x71, 0xf6, 0x02,
      0x38, 0xcc, 0xeb, 0xcd, 0xdc, 0xcd, 0x42, 0xd6, 0x4e, 0x41, 0x04, 0x5f,
      0xd8, 0xeb, 0xc3, 0x5b, 0xba, 0xe0, 0xa3, 0x7b, 0x43, 0x38, 0x8d, 0xdb,
      0x87, 0x35, 0x6c, 0xbb, 0x52, 0x5a, 0x13, 0xd5, 0x7f, 0x47, 0xa2, 0xcd},
     {0x06, 0x2b, 0x8a, 0x96, 0x8e, 0x45, 0x43, 0x5c, 0x2b, 0x5b, 0x54, 0xb4,
      0x17, 0xf5, 0x5e, 0x89, 0xf9, 0x35, 0xb6, 0x6d, 0xec, 0x44, 0x88, 0x2c,
      0x06, 0xab, 0x8d, 0x6c, 0xda, 0x8d, 0xcf, 0xb5, 0x53, 0xa7, 0x83, 0x61,
      0xd3, 0x82, 0xa9, 0x21, 0x11, 0x91, 0x87, 0x1e, 0x9a, 0x34, 0x22, 0x0f},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 137
    {137,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x81, 0x88, 0x58, 0x04, 0xee, 0x93, 0x19, 0x88, 0xcf, 0xf3, 0xf2, 0x18,
      0xc9, 0xaf, 0x14, 0x29, 0x57, 0x3c, 0xcf, 0x8c, 0x8f, 0x3d, 0xf4, 0x0c,
      0x69, 0x8d, 0x97, 0x6e, 0x8b, 0xc7, 0xc1, 0x28, 0x81, 0x95, 0x34, 0x45,
      0xdd, 0xc4, 0xf1, 0x90, 0x2b, 0x2f, 0x2f, 0x31, 0x53, 0x30, 0x4e, 0x82,
      0xd7, 0x09, 0x4b, 0x67, 0x3b, 0x76, 0xbe, 0xeb, 0xfa, 0x5d, 0x84, 0xc4,
      0x9b, 0x01, 0xce, 0x16, 0x8c, 0x45, 0x92, 0x01, 0xcb, 0x81, 0x92, 0xef,
      0x96, 0xd8, 0x91, 0x01, 0x0e, 0x4b, 0xc8, 0x8f, 0x0a, 0xcc, 0x4f, 0xbb,
      0x40, 0xad, 0x61, 0x96, 0x6e, 0x78, 0x7b, 0x9a, 0x29, 0x8a, 0x2b, 0xba},
     {0xba, 0x41, 0xc3, 0x8d, 0x33, 0xb2, 0xae, 0x34, 0x27, 0x97, 0xee, 0x69,
      0x72, 0x3f, 0x04, 0x2a, 0x71, 0xdd, 0x7f, 0xb1, 0x5f, 0x3d, 0xc8, 0x0d,
      0xae, 0x40, 0x3d, 0x4f, 0x88, 0xac, 0xae, 0x28, 0xe2, 0xe5, 0x1f, 0x2c,
      0xa9, 0xd5, 0x2b, 0x4a, 0xa4, 0xe2, 0xb3, 0xe5, 0x82, 0x57, 0xe2, 0x4d},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 138
    {138,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x16, 0x79, 0x15, 0xd9, 0x62, 0xa4, 0x05, 0xf8, 0xd0, 0x4d, 0x6d, 0x64,
      0x94, 0x27, 0x0d, 0x88, 0x3f, 0xe7, 0x59, 0x4e, 0x9a, 0x21, 0xf7, 0xb5,
      0x77, 0x15, 0x75, 0x0f, 0x8d, 0x78, 0xec, 0x07, 0x14, 0xf0, 0xfb, 0x85,
      0xa9, 0xfe, 0x5a, 0xee, 0x4e, 0x6d, 0x10, 0x34, 0x4e, 0x4b, 0x12, 0xf9,
      0x1f, 0x00, 0x44, 0x1c, 0x8b, 0xf5, 0x67, 0xff, 0x84, 0xe6, 0xee, 0x42,
      0x98, 0xb9, 0xd3, 0x39, 0x2c, 0x78, 0xfb, 0x32, 0x46, 0x19, 0x58, 0x10,
      0x2e, 0x1d, 0x29, 0xd2, 0xf4, 0xc4, 0x73, 0x21, 0x04, 0x24, 0x2c, 0xc4,
      0xbf, 0xee, 0x22, 0xaa, 0x8f, 0x4a, 0x17, 0x2a, 0xa5, 0x10, 0xac, 0x88},
     {0xc6, 0xaf, 0x4e, 0xae, 0x59, 0x99, 0xe0, 0xd0, 0x65, 0x85, 0x05, 0xcb,
      0x4b, 0x39, 0x5e, 0x9d, 0x73, 0x59, 0x2a, 0x3d, 0x9d, 0x0b, 0x3c, 0x07,
      0xca, 0xeb, 0x2b, 0xef, 0x1b, 0x03, 0xca, 0x4d, 0x60, 0x3b, 0x33, 0xe6,
      0xf6, 0xbb, 0xd9, 0x0f, 0x94, 0x16, 0xc4, 0xaa, 0x00, 0x22, 0xe5, 0x84},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 139
    {139,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x66, 0xe1, 0xfe, 0x89, 0x3f, 0x72, 0xff, 0xea, 0x5e, 0x24, 0xea, 0x5a,
      0x4f, 0x0d, 0x65, 0x58, 0xfd, 0xbd, 0x32, 0x22, 0xdb, 0xa6, 0xe3, 0x34,
      0x07, 0x53, 0xc8, 0x29, 0x79, 0xac, 0x59, 0x53, 0x0d, 0xbd, 0x37, 0xfa,
      0xc2, 0xf5, 0x13, 0x55, 0x46, 0x5d, 0x56, 0xaf, 0xe1, 0xde, 0x58, 0x2b,
      0xea, 0xca, 0x91, 0x04, 0xad, 0x26, 0x9b, 0x0f, 0x84, 0x8d, 0x8b, 0x4d,
      0x71, 0x18, 0x2a, 0xfc, 0x30, 0x12, 0x91, 0x47, 0x36, 0x9a, 0x74, 0x19,
      0x3d, 0xdf, 0x4d, 0xdb, 0x3b, 0x6f, 0xf1, 0x28, 0xf9, 0x41, 0x68, 0xce,
      0x0b, 0xc6, 0x0e, 0x77, 0x91, 0xb4, 0xb1, 0xca, 0x2e, 0x29, 0x43, 0x1b},
     {0x9e, 0x36, 0x4a, 0xdc, 0xb7, 0x2b, 0x15, 0xa4, 0x2c, 0xbd, 0x6f, 0xa7,
      0x91, 0x14, 0x88, 0x9e, 0x22, 0xb9, 0x3b, 0x53, 0x3b, 0x01, 0x19, 0xaf,
      0xd9, 0x09, 0x14, 0xb1, 0x81, 0x12, 0x81, 0x51, 0xb8, 0xa1, 0x7d, 0xb4,
      0x90, 0x04, 0xec, 0x39, 0xad, 0x5d, 0xb5, 0x60, 0x3f, 0xb9, 0x71, 0x1d},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 140
    {140,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x62, 0xeb, 0xaa, 0xbf, 0xf2, 0xa0, 0x7a, 0x85, 0x2a, 0xf9, 0xaa, 0xb8,
      0x12, 0x6e, 0x93, 0xc3, 0x11, 0x09, 0xe8, 0x93, 0xcc, 0x61, 0xb3, 0x54,
      0xa7, 0x2a, 0x17, 0x44, 0xcb, 0x40, 0x9a, 0x02, 0xce, 0xc6, 0xe6, 0x19,
      0x58, 0x45, 0x95, 0x7a, 0x53, 0xbd, 0xe9, 0x7d, 0xec, 0x7a, 0x87, 0xc2,
      0x5e, 0xa1, 0x1b, 0x00, 0x3a, 0x69, 0x4e, 0x37, 0x1c, 0x2b, 0xe1, 0xcf,
      0x5d, 0xb5, 0xb7, 0xfb, 0xa2, 0x78, 0xf6, 0x96, 0x8f, 0x54, 0xc5, 0xfb,
      0x66, 0x77, 0x98, 0x7b, 0xbb, 0x6b, 0x55, 0xdd, 0x90, 0x72, 0xe8, 0x32,
      0x5b, 0x36, 0x5c, 0x25, 0x26, 0x2c, 0x50, 0x24, 0xf6, 0x8b, 0x2e, 0x5b},
     {0x23, 0x10, 0x48, 0x06, 0xdb, 0xd8, 0x5f, 0x71, 0xd8, 0xfc, 0x38, 0x10,
      0x1b, 0x0c, 0xd0, 0xbb, 0xcd, 0x60, 0x33, 0x1d, 0x8f, 0x74, 0x86, 0x9f,
      0x06, 0x43, 0x11, 0x6a, 0xc3, 0x62, 0xb5, 0xe9, 0x33, 0xdb, 0x87, 0x43,
      0xff, 0x80, 0xdf, 0xcc, 0x2d, 0xf5, 0xcb, 0xcb, 0xf0, 0x27, 0x18, 0x5e},
     false,
     true},

    // Comment: point with coordinate y = 1 in precomputation or right to left
    // addition chain
    // tcID: 141
    {141,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x27, 0x6a, 0x5a, 0x27, 0x4b, 0x46, 0xa0, 0xa3, 0x6f, 0x81, 0x1c, 0xf6,
      0x4b, 0xc7, 0xa6, 0x44, 0xd5, 0xad, 0x9c, 0x12, 0x4b, 0xe0, 0x02, 0xa6,
      0xfd, 0xd1, 0xcc, 0x11, 0x18, 0x80, 0x65, 0x5c, 0x8d, 0x29, 0x87, 0x67,
      0x4e, 0xa4, 0x9e, 0x7d, 0x70, 0xd2, 0xa0, 0xae, 0x82, 0x0d, 0x1a, 0x7d,
      0x4e, 0xc3, 0xba, 0xe2, 0xdd, 0x1d, 0x77, 0xaf, 0x08, 0x2f, 0xab, 0xcd,
      0x68, 0xac, 0x20, 0xf2, 0x09, 0xe8, 0xfa, 0x44, 0x64, 0x78, 0x79, 0x42,
      0x23, 0xbe, 0x1d, 0x63, 0xd7, 0x19, 0x87, 0xe9, 0x64, 0xe4, 0x5f, 0x0b,
      0xcf, 0x6a, 0x2e, 0xa0, 0xa1, 0x2c, 0x63, 0x34, 0x45, 0x28, 0x5a, 0x46},
     {0x28, 0x35, 0x02, 0x35, 0x5b, 0x21, 0x18, 0x9f, 0x73, 0x61, 0xe8, 0x94,
      0x57, 0x55, 0x09, 0x74, 0xf8, 0x6a, 0xe2, 0xb6, 0x6d, 0x02, 0x55, 0x06,
      0x89, 0x9c, 0x15, 0xb3, 0x90, 0xda, 0x24, 0x8e, 0x14, 0xfd, 0x1b, 0x4f,
      0x25, 0xc8, 0x58, 0x4d, 0x1a, 0x71, 0xe7, 0xf8, 0xc9, 0x3f, 0xa9, 0x76},
     false,
     true},

    // Comment: point with coordinate y = 1 in precomputation or right to left
    // addition chain
    // tcID: 142
    {142,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x98, 0xfe, 0xe3, 0x14, 0xcf, 0xb3, 0xc0, 0x1c, 0xc2, 0xd9, 0xfd, 0x7c,
      0x25, 0x68, 0x33, 0x60, 0x27, 0x84, 0x00, 0x08, 0xbc, 0xfb, 0xfc, 0x82,
      0x92, 0x42, 0x1e, 0xd6, 0xb0, 0x72, 0x7f, 0xa2, 0x0b, 0x70, 0x02, 0xa5,
      0x72, 0x6a, 0x68, 0x5d, 0x44, 0x96, 0x3a, 0xd8, 0xf7, 0x4c, 0x69, 0x5d,
      0xa2, 0x5a, 0x54, 0x2b, 0x8e, 0x0b, 0xb9, 0xa4, 0x85, 0x8b, 0xe6, 0x4f,
      0x70, 0x80, 0x0d, 0xa9, 0x3a, 0xf6, 0x77, 0x6b, 0xb7, 0x95, 0xbb, 0x16,
      0x9f, 0x4c, 0x9d, 0x15, 0x17, 0x95, 0xf3, 0xa5, 0xa3, 0x7a, 0x3c, 0x82,
      0x26, 0x4c, 0xf6, 0x87, 0x0c, 0x4d, 0xed, 0x68, 0x4a, 0x71, 0x26, 0x9b},
     {0x90, 0x44, 0xbe, 0x70, 0x56, 0x66, 0x64, 0xed, 0x91, 0xda, 0xb8, 0x5a,
      0xa5, 0xff, 0x64, 0x4d, 0x7a, 0x34, 0x68, 0x10, 0xd2, 0x67, 0x8d, 0x27,
      0x75, 0x19, 0x17, 0xc3, 0x82, 0x0c, 0x4c, 0x82, 0x50, 0x34, 0xb7, 0x8a,
      0x95, 0x7b, 0x8f, 0xd1, 0xd4, 0x7e, 0x86, 0xe6, 0x7e, 0x5b, 0xa9, 0xf8},
     false,
     true},

    // Comment: point with coordinate y = 1 in precomputation or right to left
    // addition chain
    // tcID: 143
    {143,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xd1, 0x6d, 0x0b, 0x11, 0xd0, 0xa3, 0x26, 0xbb, 0x27, 0x25, 0xb3, 0xc9,
      0xcd, 0x59, 0x87, 0x46, 0xaf, 0x11, 0x92, 0x4f, 0x61, 0x72, 0xce, 0x53,
      0xb1, 0x9a, 0x94, 0x2b, 0x96, 0x55, 0x62, 0xc2, 0xa2, 0x87, 0x5f, 0xd1,
      0x5c, 0xe1, 0xf4, 0x86, 0x91, 0x56, 0xd5, 0xcf, 0x08, 0x78, 0x0c, 0x74,
      0xd4, 0xc4, 0x92, 0x7c, 0xa1, 0x75, 0xb5, 0x32, 0x7c, 0x9f, 0x32, 0x1c,
      0xd2, 0xa7, 0xb1, 0xac, 0xb5, 0x8f, 0xce, 0x35, 0x11, 0x60, 0xda, 0xea,
      0x5d, 0x5c, 0x64, 0xd7, 0x6d, 0x38, 0xd3, 0xab, 0x17, 0xf7, 0xc1, 0x43,
      0x20, 0x93, 0xad, 0x4d, 0x62, 0x00, 0x53, 0xf6, 0xf6, 0x75, 0x86, 0x4a},
     {0x1f, 0xa4, 0xc8, 0xe6, 0xde, 0xc8, 0x90, 0x88, 0xa8, 0xfe, 0x72, 0x55,
      0x30, 0xf5, 0xc1, 0x54, 0x67, 0x2e, 0x84, 0x48, 0x8b, 0xaa, 0xf7, 0x0a,
      0x08, 0xb2, 0xe9, 0x65, 0x65, 0x96, 0x26, 0x53, 0x57, 0x74, 0x02, 0x16,
      0x14, 0x24, 0x29, 0x4b, 0x7f, 0x37, 0x72, 0x08, 0xfc, 0x93, 0x61, 0x39},
     false,
     true},

    // Comment: point with coordinate y = 1 in precomputation or right to left
    // addition chain
    // tcID: 144
    {144,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x10, 0x52, 0x6e, 0x3b, 0x09, 0x7a, 0x99, 0xea, 0x50, 0x7b, 0xa6, 0x79,
      0x5e, 0xa1, 0xf7, 0x77, 0x18, 0x69, 0x04, 0x60, 0x11, 0x7b, 0xfa, 0xc9,
      0xed, 0x95, 0xbe, 0xe3, 0x11, 0xdb, 0x5f, 0x8a, 0x1a, 0x27, 0x67, 0xc1,
      0x34, 0xb1, 0x9d, 0xb3, 0xc3, 0x87, 0xa1, 0xfb, 0x45, 0xbe, 0x70, 0x29,
      0x31, 0x2c, 0x75, 0xd7, 0xbb, 0xee, 0xee, 0x48, 0xbc, 0x15, 0xb5, 0x5d,
      0xfb, 0x71, 0x65, 0x11, 0xc5, 0x63, 0x4d, 0x71, 0x9d, 0x26, 0x90, 0x3b,
      0xca, 0xce, 0x1c, 0x60, 0xa8, 0xe0, 0x30, 0x49, 0x61, 0x56, 0xd9, 0xcc,
      0xac, 0x97, 0xca, 0xc7, 0x24, 0xe0, 0x93, 0x57, 0x4a, 0xe4, 0xbc, 0x83},
     {0x04, 0xf4, 0x02, 0x9d, 0x37, 0x23, 0x32, 0xb4, 0xb2, 0x26, 0xc9, 0xf3,
      0x25, 0x21, 0xea, 0x39, 0xa5, 0x8b, 0x65, 0x5d, 0x24, 0xe3, 0x51, 0x90,
      0xce, 0x04, 0xd5, 0x8f, 0x0c, 0x04, 0x81, 0x4b, 0xe7, 0xf6, 0xff, 0xcb,
      0x8a, 0x4a, 0x15, 0x13, 0x42, 0x24, 0x13, 0x4f, 0x02, 0x9e, 0xda, 0x9f},
     false,
     true},

    // Comment: point with coordinate y = 1 in precomputation or right to left
    // addition chain
    // tcID: 145
    {145,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe6, 0x32, 0xcb, 0x20, 0x12, 0x88, 0xb6, 0x43, 0xf2, 0x35, 0x53, 0x3c,
      0x44, 0x84, 0x6b, 0x11, 0xa2, 0x87, 0x40, 0xee, 0x41, 0x37, 0xa2, 0x2c,
      0xff, 0x7f, 0x54, 0x20, 0x54, 0xd6, 0x33, 0x7f, 0x46, 0x36, 0x38, 0x49,
      0xc8, 0x31, 0x0e, 0x20, 0xd8, 0xb2, 0x9b, 0xad, 0xdb, 0x31, 0x09, 0xff,
      0x94, 0x8d, 0x42, 0xae, 0x95, 0x9c, 0x3a, 0xe1, 0x43, 0xd4, 0xf0, 0x2d,
      0x26, 0x87, 0x26, 0xbc, 0x2b, 0x66, 0xba, 0xfe, 0xd7, 0x65, 0x7b, 0x1a,
      0x53, 0xe2, 0x3e, 0xed, 0x48, 0x09, 0x4c, 0x5c, 0xa8, 0xd2, 0x8d, 0x16,
      0x12, 0x1a, 0xa6, 0x23, 0x7d, 0x81, 0x50, 0xad, 0x6c, 0x32, 0x66, 0x55},
     {0xf4, 0x1f, 0x91, 0x21, 0x65, 0x82, 0x7c, 0xea, 0x27, 0xab, 0x81, 0x47,
      0xa4, 0x6a, 0xbe, 0xb3, 0x0c, 0x1b, 0xc7, 0x3c, 0xfe, 0x05, 0x20, 0xd7,
      0xd8, 0x69, 0x8d, 0xf8, 0xf9, 0x52, 0x9a, 0xfe, 0x26, 0xea, 0xc7, 0x07,
      0x34, 0x0f, 0x38, 0xb4, 0x9e, 0xc5, 0xe7, 0x41, 0xd6, 0x46, 0xb9, 0xa7},
     false,
     true},

    // Comment: point with coordinate y = 1 in precomputation or right to left
    // addition chain
    // tcID: 146
    {146,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x08, 0x83, 0x30, 0x38, 0x06, 0x13, 0xad, 0xb0, 0xb8, 0xe5, 0x31, 0x64,
      0x98, 0x09, 0xfb, 0xea, 0x34, 0x0e, 0xdb, 0xdf, 0x59, 0x8a, 0xf0, 0x28,
      0xe7, 0x4b, 0xa0, 0xb4, 0xf1, 0x8e, 0x2d, 0x50, 0x11, 0x85, 0x31, 0xb9,
      0xa9, 0x2b, 0x07, 0x75, 0x3b, 0x2c, 0x13, 0xce, 0xb8, 0x7d, 0x3c, 0x8e,
      0x38, 0xe6, 0x25, 0xb5, 0x00, 0xf4, 0xb9, 0xbd, 0x2d, 0xc7, 0x81, 0x89,
      0x2f, 0xff, 0x96, 0xd8, 0x92, 0x71, 0x90, 0x9d, 0x3e, 0x56, 0x1a, 0x63,
      0xe4, 0x15, 0x46, 0x7d, 0x6d, 0x45, 0x5d, 0x0a, 0x4c, 0x19, 0xc3, 0x6f,
      0x16, 0xdc, 0xc2, 0x41, 0x7a, 0x34, 0x25, 0xc2, 0xad, 0xda, 0x90, 0x34},
     {0x6e, 0x43, 0x7e, 0x26, 0x31, 0x6e, 0xb2, 0x59, 0x64, 0x00, 0xd8, 0xfd,
      0xda, 0x5b, 0xe9, 0x0c, 0xaa, 0x94, 0xd6, 0x2c, 0x42, 0x5f, 0x27, 0xdf,
      0x5c, 0xa6, 0x78, 0x98, 0xa8, 0xff, 0xdf, 0x3c, 0xde, 0x57, 0x7c, 0x4d,
      0x2d, 0x66, 0xf6, 0x52, 0x24, 0x98, 0xf0, 0xb2, 0x95, 0xd7, 0x7a, 0x2e},
     false,
     true},

    // Comment: point with coordinate y = 1 in right to left addition chain
    // tcID: 147
    {147,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xd9, 0xa9, 0xd1, 0xe0, 0xaa, 0xca, 0xef, 0x4a, 0xec, 0xf2, 0x41, 0xd6,
      0x90, 0xee, 0x41, 0x01, 0xdf, 0x74, 0xd7, 0xa3, 0x7f, 0x18, 0xce, 0x31,
      0x81, 0x12, 0x8f, 0x8d, 0x42, 0x55, 0xcd, 0x34, 0x70, 0x2b, 0x17, 0xf1,
      0x16, 0xb2, 0x50, 0x6c, 0xb8, 0xf5, 0x77, 0xd9, 0x35, 0x7e, 0x36, 0x29,
      0x96, 0x6e, 0x62, 0xe6, 0xf9, 0x5c, 0x9e, 0xb7, 0x83, 0x3c, 0xcc, 0x1f,
      0x22, 0x95, 0x6a, 0x1e, 0x25, 0x99, 0xa8, 0x75, 0xf8, 0x13, 0x9d, 0x9a,
      0x2b, 0x31, 0xe2, 0x00, 0x06, 0x11, 0xb4, 0xd6, 0xdb, 0x1d, 0x23, 0xe7,
      0xf0, 0xdb, 0x5b, 0x5c, 0x17, 0xbb, 0x44, 0xe1, 0x50, 0xea, 0x26, 0x95},
     {0x85, 0x47, 0x72, 0xb9, 0xb7, 0x7d, 0x46, 0x87, 0x57, 0x1f, 0x19, 0x34,
      0x06, 0x1d, 0xbc, 0xe0, 0x01, 0x6d, 0x47, 0xb9, 0x0a, 0x8b, 0x5d, 0x38,
      0x22, 0x94, 0x75, 0xc2, 0x13, 0xcd, 0x5d, 0xf2, 0x5f, 0x96, 0x0b, 0x77,
      0x5a, 0xe7, 0x29, 0x09, 0xcc, 0xcc, 0x5b, 0xa1, 0x4d, 0xd0, 0x34, 0x48},
     false,
     true},

    // Comment: point with coordinate y = 1 in right to left addition chain
    // tcID: 148
    {148,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x53, 0x5d, 0x22, 0xf3, 0x9c, 0x8a, 0x55, 0x91, 0xe7, 0xa1, 0xde, 0xef,
      0x7a, 0x6c, 0x34, 0x96, 0x5f, 0xb5, 0xd1, 0xe6, 0x16, 0xf1, 0x4b, 0xb1,
      0x2a, 0x7e, 0x63, 0x10, 0xd5, 0x20, 0x35, 0x0f, 0x2f, 0x75, 0x83, 0x6f,
      0x9c, 0x81, 0x89, 0xec, 0x45, 0x03, 0xef, 0x74, 0xa0, 0xb8, 0x50, 0xd4,
      0xab, 0xb0, 0x5a, 0xb1, 0xe5, 0xc6, 0x06, 0x18, 0x84, 0xd1, 0xef, 0xf3,
      0xd2, 0xbe, 0x78, 0xc7, 0x67, 0x59, 0xb9, 0x86, 0xdd, 0xe7, 0x05, 0x52,
      0xaa, 0x1e, 0x97, 0xbc, 0x01, 0x4f, 0x33, 0x3c, 0x0d, 0x5a, 0xf8, 0xb4,
      0x6d, 0x61, 0xe1, 0xae, 0x06, 0x77, 0x4e, 0x2f, 0x86, 0x26, 0x73, 0x12},
     {0x03, 0x7d, 0x45, 0x9a, 0x54, 0xfe, 0x6b, 0x69, 0xd8, 0x93, 0xf4, 0xd3,
      0x09, 0x4a, 0x5e, 0x0a, 0x93, 0x25, 0x1d, 0x52, 0x54, 0xce, 0xf5, 0xb0,
      0x22, 0xe7, 0x06, 0x5f, 0xdf, 0x52, 0xe3, 0xbe, 0x81, 0x27, 0xf2, 0xae,
      0x2e, 0x33, 0x6e, 0x26, 0x1a, 0x71, 0xf6, 0xe4, 0x1a, 0xac, 0xb2, 0xe1},
     false,
     true},

    // Comment: point with coordinate y = 1 in right to left addition chain
    // tcID: 149
    {149,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x89, 0x40, 0x2a, 0x14, 0x3d, 0x57, 0xec, 0x58, 0x5a, 0xee, 0x12, 0x43,
      0xd3, 0xa7, 0xad, 0xfa, 0x87, 0xeb, 0x80, 0xc6, 0x0b, 0xd0, 0x9c, 0xbb,
      0x56, 0xb6, 0x4e, 0xb0, 0xa1, 0xb7, 0xf5, 0x92, 0x73, 0x18, 0xd8, 0x57,
      0x3c, 0x62, 0x39, 0xc6, 0xfe, 0xea, 0xa5, 0x8d, 0xc2, 0xae, 0x2e, 0x40,
      0xd6, 0x05, 0x18, 0x9a, 0xc4, 0xa6, 0x6b, 0xd6, 0xb9, 0xe7, 0x08, 0xbd,
      0xbc, 0xcc, 0x46, 0x47, 0x54, 0x3c, 0x0d, 0xd1, 0xd3, 0xc6, 0x4a, 0x2c,
      0x16, 0x0c, 0x32, 0xf7, 0x29, 0xf2, 0xb1, 0x5d, 0xd9, 0x58, 0x52, 0xc9,
      0xb2, 0x07, 0x50, 0x86, 0x51, 0xd7, 0x74, 0x63, 0x95, 0xa5, 0xa4, 0x90},
     {0xe8, 0xd0, 0x3d, 0xff, 0xea, 0xd2, 0xe4, 0x0e, 0xa9, 0x15, 0xdb, 0x4c,
      0x9c, 0x67, 0xab, 0xb4, 0x5a, 0xa6, 0x09, 0x92, 0x42, 0x2b, 0x70, 0x37,
      0x42, 0x39, 0xca, 0xf5, 0x8b, 0x96, 0xf8, 0x67, 0x16, 0x60, 0x0c, 0x1c,
      0xc4, 0x44, 0x93, 0x62, 0xdc, 0x56, 0xca, 0x05, 0x7b, 0xfc, 0x5e, 0x5e},
     false,
     true},

    // Comment: point with coordinate y = 1 in right to left addition chain
    // tcID: 150
    {150,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xa9, 0xc5, 0x2a, 0x59, 0x36, 0x91, 0x0c, 0x05, 0xc4, 0x14, 0x43,
      0x15, 0x12, 0x7b, 0xf6, 0x62, 0xc2, 0x92, 0xb8, 0xf0, 0x68, 0x18, 0x11,
      0xc2, 0xbf, 0x8f, 0x4f, 0x9c, 0xc5, 0xbd, 0x7a, 0xb6, 0x93, 0xf7, 0xcb,
      0xdd, 0xb5, 0x72, 0x4e, 0x7e, 0x29, 0xdd, 0x02, 0x3d, 0x15, 0x5f, 0xfd,
      0x33, 0x5e, 0x8b, 0x87, 0x2a, 0xe1, 0xb7, 0xa9, 0x12, 0x93, 0xae, 0x9c,
      0xc8, 0xf6, 0x54, 0xf0, 0x5f, 0xf4, 0x76, 0x7d, 0xb2, 0x08, 0xb7, 0x6c,
      0x73, 0xb6, 0xb3, 0x4c, 0x56, 0x26, 0x51, 0x2e, 0x6b, 0xa9, 0x2b, 0xcc,
      0x93, 0x7c, 0x9b, 0xcc, 0xa9, 0x44, 0x7d, 0xbe, 0xc2, 0x2f, 0xf1, 0x06},
     {0xe8, 0x20, 0xf9, 0x97, 0x92, 0x8a, 0x71, 0x18, 0x6c, 0xe0, 0x9b, 0x96,
      0x92, 0x3c, 0x31, 0x7c, 0xc1, 0x28, 0xcb, 0x76, 0x1c, 0x87, 0xe9, 0x70,
      0x73, 0xa8, 0x51, 0x61, 0x0c, 0xa1, 0x2f, 0x21, 0x99, 0x37, 0x93, 0x87,
      0x89, 0xbd, 0x22, 0x7a, 0x8d, 0x72, 0xb2, 0xb4, 0x06, 0xc4, 0x71, 0xfd},
     false,
     true},

    // Comment: point with coordinate y = 1 in right to left addition chain
    // tcID: 151
    {151,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc1,
      0x78, 0x1d, 0x86, 0xca, 0xc2, 0xc0, 0x52, 0xb7, 0xe4, 0xf4, 0x8c, 0xef,
      0x41, 0x5c, 0x5c, 0x13, 0x30, 0x52, 0xf4, 0xe5, 0x04, 0x39, 0x7e, 0x75,
      0xe4, 0xd7, 0xcd, 0x0c, 0xa1, 0x49, 0xda, 0x0b, 0x49, 0x88, 0xb8, 0xa6,
      0xde, 0xd5, 0xce, 0xae, 0x4b, 0x58, 0x06, 0x91, 0x37, 0x61, 0x87, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x29, 0xeb, 0x9c, 0x63, 0xa1, 0x23, 0x22,
      0xcd, 0x99, 0xde, 0x0e, 0x8e, 0x3c, 0x11, 0xe6, 0xc8, 0xa4, 0x86, 0xb1,
      0x00, 0x81, 0x81, 0xbe, 0x4c, 0x82, 0x5f, 0x38, 0xb3, 0x71, 0xe6, 0xf0,
      0x3e, 0x29, 0x26, 0xcd, 0x60, 0xe9, 0xa9, 0xcc, 0xd4, 0x2e, 0x1a, 0xa8,
      0x79, 0x9d, 0x2e, 0xf3, 0xa7, 0x9d, 0x04, 0x5f, 0x3a, 0x3d, 0xf9, 0x74,
      0x74, 0x32, 0x68, 0xbe, 0x65, 0x0f, 0xba, 0xf6, 0x8c, 0x70, 0x45, 0xa4,
      0x83, 0x09, 0x3c, 0xe2, 0xe2, 0x89, 0x90, 0x30, 0x97, 0x39, 0x6f, 0x04,
      0x00, 0x58, 0xfa, 0xac, 0xb7, 0x23, 0xeb, 0x49, 0x3b, 0x5b, 0x63, 0x1b,
      0xc3, 0x65, 0xc5, 0xfc, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xdc, 0xd0, 0x22, 0x4a, 0xd2, 0x21, 0x9d, 0xc3, 0xaf, 0x05, 0xee, 0xa5,
      0xd2, 0x79, 0x74, 0xa7, 0x5f, 0xb1, 0x96, 0x0d, 0x0d, 0x72, 0x1c, 0x39,
      0xf1, 0x07, 0xbf, 0x45, 0x34, 0x62, 0x20, 0x99, 0x4e, 0x52, 0x0c, 0xa5,
      0xa6, 0x46, 0x70, 0x1e, 0x93, 0x19, 0xce, 0xb0, 0x80, 0x17, 0xa3, 0x02,
      0xe0, 0xb1, 0xbe, 0xe2, 0x92, 0xcd, 0x1c, 0xb9, 0x9f, 0x14, 0x5e, 0xad,
      0x3d, 0x12, 0x28, 0x59, 0x03, 0xb1, 0xe5, 0x49, 0xfc, 0xce, 0x75, 0x91,
      0xa1, 0x01, 0xa1, 0x67, 0x5f, 0xb9, 0xb6, 0xe3, 0x0e, 0x67, 0x80, 0x37,
      0xf4, 0xd5, 0x8d, 0x22, 0x0c, 0x1e, 0x36, 0xa4, 0xe7, 0x9f, 0x88, 0x3c},
     {0x0a, 0xed, 0x8a, 0xc7, 0xd0, 0x4a, 0xf0, 0x70, 0xb7, 0x3a, 0x03, 0xf3,
      0x7e, 0xf7, 0x11, 0x29, 0x6d, 0xb8, 0xac, 0x64, 0xba, 0xb1, 0x3e, 0x15,
      0x41, 0x8d, 0xf6, 0x37, 0x3a, 0xad, 0x81, 0xd8, 0xe0, 0xfa, 0x78, 0x9b,
      0x92, 0x92, 0x93, 0x3d, 0x7f, 0x11, 0xb8, 0x61, 0x40, 0x76, 0xe0, 0x74},
     false,
     true},

    // Comment: edge case private key
    // tcID: 152
    {152,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x07, 0x7a, 0x41, 0xd4, 0x60, 0x6f, 0xfa,
      0x14, 0x64, 0x79, 0x3c, 0x7e, 0x5f, 0xdc, 0x7d, 0x98, 0xcb, 0x9d, 0x39,
      0x10, 0x20, 0x2d, 0xcd, 0x06, 0xbe, 0xa4, 0xf2, 0x40, 0xd3, 0x56, 0x6d,
      0xa6, 0xb4, 0x08, 0xbb, 0xae, 0x50, 0x26, 0x58, 0x0d, 0x02, 0xd7, 0xe5,
      0xc7, 0x05, 0x00, 0xc8, 0x31, 0xc9, 0x95, 0xf7, 0xca, 0x0b, 0x0c, 0x42,
      0x83, 0x7d, 0x0b, 0xbe, 0x96, 0x02, 0xa9, 0xfc, 0x99, 0x85, 0x20, 0xb4,
      0x1c, 0x85, 0x11, 0x5a, 0xa5, 0xf7, 0x68, 0x4c, 0x0e, 0xdc, 0x11, 0x1e,
      0xac, 0xc2, 0x4a, 0xbd, 0x6b, 0xe4, 0xb5, 0xd2, 0x98, 0xb6, 0x5f, 0x28,
      0x60, 0x0a, 0x2f, 0x1d, 0xf1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe9, 0xdf, 0xaa, 0xab, 0x80, 0x8b, 0x3a, 0xac, 0x1c, 0xcc, 0xa7, 0xcc,
      0x62, 0x42, 0xa7, 0xee, 0x58, 0x32, 0x49, 0xaf, 0xe8, 0xee, 0x8f, 0x66,
      0xb9, 0x04, 0xcc, 0x8e, 0xec, 0x34, 0xad, 0x33, 0x44, 0x56, 0xe0, 0x0f,
      0x33, 0xa9, 0x4d, 0xe8, 0xb5, 0x16, 0x9c, 0xf0, 0x19, 0x95, 0x50, 0xc0,
      0x20, 0x15, 0x6e, 0x96, 0x51, 0x73, 0x4f, 0xf9, 0x99, 0xc5, 0xf3, 0xea,
      0x62, 0xb8, 0x3d, 0x00, 0x83, 0xa6, 0x09, 0x3f, 0x23, 0x44, 0x57, 0x25,
      0x1e, 0xcf, 0x72, 0xc4, 0x1e, 0x4d, 0xf7, 0xce, 0xa2, 0x42, 0x0b, 0x54,
      0x54, 0xa7, 0xf6, 0x90, 0x03, 0x43, 0x80, 0xba, 0xc9, 0x81, 0xe9, 0x2e},
     {0x45, 0x5a, 0xea, 0x99, 0x24, 0x33, 0x0b, 0xd6, 0xd2, 0xd6, 0x40, 0x34,
      0x78, 0x32, 0x79, 0x00, 0xe1, 0x72, 0xe9, 0x35, 0x98, 0xe2, 0x54, 0xcf,
      0x6d, 0x8e, 0xb1, 0x3f, 0x0a, 0x3d, 0x21, 0xbe, 0x51, 0xa4, 0x61, 0x07,
      0x33, 0x38, 0x44, 0xe6, 0x1d, 0xfa, 0x3d, 0x80, 0xdf, 0x69, 0x28, 0xe9},
     false,
     true},

    // Comment: edge case private key
    // tcID: 153
    {153,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x00,
      0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xaf, 0x51, 0xf1, 0x8a, 0x15, 0x62, 0x8d,
      0x56, 0x12, 0xc8, 0xf7, 0x14, 0x43, 0x6e, 0xf9, 0x0f, 0x90, 0xd5, 0xa0,
      0xba, 0x35, 0x05, 0x4e, 0x99, 0xc5, 0x74, 0x5b, 0xb1, 0x0d, 0x0b, 0xf3,
      0x18, 0xcc, 0x82, 0xc0, 0xf7, 0xf2, 0xc1, 0x19, 0xe0, 0x8a, 0x31, 0xe3,
      0xfc, 0xca, 0x5b, 0x9f, 0xe3, 0x1c, 0xff, 0xb5, 0x65, 0xc8, 0x67, 0x18,
      0xc5, 0x9e, 0x1e, 0x6a, 0x70, 0xa6, 0x57, 0x90, 0x76, 0x89, 0xf7, 0x3a,
      0x71, 0x13, 0xe3, 0x5f, 0xff, 0x59, 0x68, 0x61, 0xd3, 0xe2, 0xfa, 0xee,
      0x70, 0x92, 0x9b, 0xb1, 0x35, 0x74, 0xe0, 0xe1, 0x03, 0x56, 0x94, 0x42,
      0x0c, 0xd7, 0x3e, 0x0c, 0xf5},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe9, 0xdf, 0xaa, 0xab, 0x80, 0x8b, 0x3a, 0xac, 0x1c, 0xcc, 0xa7, 0xcc,
      0x62, 0x42, 0xa7, 0xee, 0x58, 0x32, 0x49, 0xaf, 0xe8, 0xee, 0x8f, 0x66,
      0xb9, 0x04, 0xcc, 0x8e, 0xec, 0x34, 0xad, 0x33, 0x44, 0x56, 0xe0, 0x0f,
      0x33, 0xa9, 0x4d, 0xe8, 0xb5, 0x16, 0x9c, 0xf0, 0x19, 0x95, 0x50, 0xc0,
      0x20, 0x15, 0x6e, 0x96, 0x51, 0x73, 0x4f, 0xf9, 0x99, 0xc5, 0xf3, 0xea,
      0x62, 0xb8, 0x3d, 0x00, 0x83, 0xa6, 0x09, 0x3f, 0x23, 0x44, 0x57, 0x25,
      0x1e, 0xcf, 0x72, 0xc4, 0x1e, 0x4d, 0xf7, 0xce, 0xa2, 0x42, 0x0b, 0x54,
      0x54, 0xa7, 0xf6, 0x90, 0x03, 0x43, 0x80, 0xba, 0xc9, 0x81, 0xe9, 0x2e},
     {0xdb, 0x1d, 0x8e, 0xf1, 0x11, 0x72, 0x82, 0x87, 0x0d, 0xb8, 0x11, 0x3a,
      0xa4, 0xf5, 0x87, 0x23, 0xc7, 0x56, 0xce, 0x59, 0x86, 0x86, 0xeb, 0x8e,
      0xa5, 0x31, 0xaa, 0x4d, 0x39, 0xab, 0xb1, 0xb9, 0x82, 0xb1, 0xe7, 0xbb,
      0x26, 0x48, 0xa6, 0xc2, 0x68, 0xd2, 0xd3, 0x51, 0x20, 0x4d, 0xb8, 0xd5},
     false,
     true},

    // Comment: edge case private key
    // tcID: 154
    {154,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x28, 0x41, 0xb4, 0xda, 0xff, 0x11, 0x3d,
      0x37, 0x57, 0xff, 0xca, 0xca, 0xd8, 0x7a, 0x4a, 0x75, 0xf0, 0x71, 0x1a,
      0x2f, 0xfd, 0x23, 0x52, 0x9e, 0xf1, 0xf3, 0x3f, 0xca, 0x75, 0x66, 0x5b,
      0x49, 0xa8, 0xa8, 0xac, 0xce, 0x54, 0x13, 0x89, 0x4a, 0x4d, 0x15, 0xeb,
      0x3d, 0xb4, 0x1f, 0x37, 0x2e, 0x7c, 0x45, 0x25, 0xe9, 0x1a, 0x53, 0x18,
      0xd1, 0x71, 0x84, 0xf9, 0xff, 0x52, 0x9f, 0xa3, 0xef, 0x96, 0xad, 0x8a,
      0x95, 0x15, 0x55, 0x0e, 0x58, 0x1c, 0x2d, 0x38, 0x90, 0x9c, 0xfc, 0x4d,
      0x7e, 0xc2, 0x58, 0x2d, 0xb4, 0xdb, 0x3e, 0x1b, 0x77, 0xc2, 0x18, 0x15,
      0x90, 0xc9, 0xfa, 0xb2, 0x49},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe9, 0xdf, 0xaa, 0xab, 0x80, 0x8b, 0x3a, 0xac, 0x1c, 0xcc, 0xa7, 0xcc,
      0x62, 0x42, 0xa7, 0xee, 0x58, 0x32, 0x49, 0xaf, 0xe8, 0xee, 0x8f, 0x66,
      0xb9, 0x04, 0xcc, 0x8e, 0xec, 0x34, 0xad, 0x33, 0x44, 0x56, 0xe0, 0x0f,
      0x33, 0xa9, 0x4d, 0xe8, 0xb5, 0x16, 0x9c, 0xf0, 0x19, 0x95, 0x50, 0xc0,
      0x20, 0x15, 0x6e, 0x96, 0x51, 0x73, 0x4f, 0xf9, 0x99, 0xc5, 0xf3, 0xea,
      0x62, 0xb8, 0x3d, 0x00, 0x83, 0xa6, 0x09, 0x3f, 0x23, 0x44, 0x57, 0x25,
      0x1e, 0xcf, 0x72, 0xc4, 0x1e, 0x4d, 0xf7, 0xce, 0xa2, 0x42, 0x0b, 0x54,
      0x54, 0xa7, 0xf6, 0x90, 0x03, 0x43, 0x80, 0xba, 0xc9, 0x81, 0xe9, 0x2e},
     {0xe9, 0x80, 0x62, 0xdf, 0x47, 0xef, 0x88, 0x4c, 0x94, 0x11, 0xe1, 0x64,
      0x66, 0xaf, 0x84, 0xad, 0x27, 0x1d, 0x58, 0x60, 0x08, 0xb1, 0xfb, 0xc5,
      0x0a, 0xeb, 0x3b, 0x36, 0x83, 0x6a, 0x35, 0xa7, 0x70, 0xdd, 0x42, 0xe0,
      0xdb, 0x84, 0xd3, 0x9b, 0x26, 0xf4, 0xdc, 0xd2, 0xdc, 0x03, 0xd9, 0x0b},
     false,
     true},

    // Comment: edge case private key
    // tcID: 155
    {155,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x7f,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xd1, 0x3f, 0x9b, 0xd0, 0xc0, 0x5b, 0x56,
      0xcc, 0x30, 0xf6, 0x01, 0x06, 0xa4, 0xb8, 0xe5, 0x00, 0x69, 0x3b, 0x9d,
      0xf0, 0x59, 0x69, 0xcf, 0x47, 0x49, 0x4d, 0x5d, 0x2c, 0x16, 0x85, 0x4e,
      0xf1, 0xd8, 0x69, 0x2b, 0x3e, 0x09, 0xb8, 0x09, 0x47, 0xf7, 0x35, 0x71,
      0x07, 0x61, 0x6d, 0xdc, 0xb3, 0xbb, 0x3c, 0x7e, 0x83, 0x06, 0xc4, 0x6f,
      0xc3, 0x98, 0xc6, 0x52, 0x1b, 0x64, 0x34, 0x70, 0xc2, 0x57, 0x74, 0xda,
      0xd8, 0x3f, 0xaf, 0xef, 0xb5, 0xc6, 0x41, 0xcf, 0xec, 0xad, 0xec, 0xbf,
      0x94, 0xb3, 0xd6, 0xdd, 0x59, 0xaf, 0x7a, 0xee, 0x86, 0xa9, 0x89, 0x39,
      0x07, 0xd6, 0x81, 0x98, 0x14},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe9, 0xdf, 0xaa, 0xab, 0x80, 0x8b, 0x3a, 0xac, 0x1c, 0xcc, 0xa7, 0xcc,
      0x62, 0x42, 0xa7, 0xee, 0x58, 0x32, 0x49, 0xaf, 0xe8, 0xee, 0x8f, 0x66,
      0xb9, 0x04, 0xcc, 0x8e, 0xec, 0x34, 0xad, 0x33, 0x44, 0x56, 0xe0, 0x0f,
      0x33, 0xa9, 0x4d, 0xe8, 0xb5, 0x16, 0x9c, 0xf0, 0x19, 0x95, 0x50, 0xc0,
      0x20, 0x15, 0x6e, 0x96, 0x51, 0x73, 0x4f, 0xf9, 0x99, 0xc5, 0xf3, 0xea,
      0x62, 0xb8, 0x3d, 0x00, 0x83, 0xa6, 0x09, 0x3f, 0x23, 0x44, 0x57, 0x25,
      0x1e, 0xcf, 0x72, 0xc4, 0x1e, 0x4d, 0xf7, 0xce, 0xa2, 0x42, 0x0b, 0x54,
      0x54, 0xa7, 0xf6, 0x90, 0x03, 0x43, 0x80, 0xba, 0xc9, 0x81, 0xe9, 0x2e},
     {0x89, 0x8a, 0xae, 0x0e, 0xbf, 0x1c, 0xb4, 0x9f, 0xb6, 0xb1, 0x23, 0x4d,
      0x60, 0xf5, 0x90, 0x06, 0x32, 0x54, 0x21, 0x04, 0x9a, 0x8a, 0x32, 0x08,
      0x20, 0xe1, 0xad, 0x6a, 0xf6, 0x59, 0x3c, 0xdc, 0x22, 0x29, 0xa0, 0x8c,
      0x50, 0x0a, 0xa5, 0x5c, 0xa0, 0x59, 0x99, 0xd1, 0x28, 0x29, 0xdb, 0x9c},
     false,
     true},

    // Comment: edge case private key
    // tcID: 156
    {156,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x80,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xe3, 0xe2, 0x5c, 0xdb, 0x16, 0x02, 0x08,
      0xb6, 0x47, 0x4e, 0x2b, 0x34, 0xd7, 0x2b, 0xf5, 0x86, 0xbb, 0xa1, 0x4f,
      0x72, 0xc3, 0xf9, 0x7f, 0x51, 0x5a, 0x40, 0x5d, 0x14, 0x29, 0x19, 0x6e,
      0x66, 0x73, 0x16, 0x1b, 0x78, 0xad, 0x80, 0xaf, 0xe6, 0x64, 0xee, 0x50,
      0x4d, 0x4b, 0x16, 0x1a, 0xb7, 0x37, 0x70, 0xb6, 0x4d, 0x54, 0x42, 0x69,
      0x59, 0x59, 0xfb, 0x89, 0xda, 0x7e, 0xb3, 0xa7, 0xca, 0xfc, 0xba, 0x07,
      0x9d, 0x32, 0x03, 0x1d, 0xf6, 0x21, 0x30, 0x49, 0xc1, 0xcc, 0x50, 0x9e,
      0x3f, 0x91, 0x20, 0xca, 0xf8, 0xdd, 0x91, 0x09, 0x11, 0x5f, 0x40, 0x38,
      0x59, 0xac, 0x33, 0x7a, 0xcc},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe9, 0xdf, 0xaa, 0xab, 0x80, 0x8b, 0x3a, 0xac, 0x1c, 0xcc, 0xa7, 0xcc,
      0x62, 0x42, 0xa7, 0xee, 0x58, 0x32, 0x49, 0xaf, 0xe8, 0xee, 0x8f, 0x66,
      0xb9, 0x04, 0xcc, 0x8e, 0xec, 0x34, 0xad, 0x33, 0x44, 0x56, 0xe0, 0x0f,
      0x33, 0xa9, 0x4d, 0xe8, 0xb5, 0x16, 0x9c, 0xf0, 0x19, 0x95, 0x50, 0xc0,
      0x20, 0x15, 0x6e, 0x96, 0x51, 0x73, 0x4f, 0xf9, 0x99, 0xc5, 0xf3, 0xea,
      0x62, 0xb8, 0x3d, 0x00, 0x83, 0xa6, 0x09, 0x3f, 0x23, 0x44, 0x57, 0x25,
      0x1e, 0xcf, 0x72, 0xc4, 0x1e, 0x4d, 0xf7, 0xce, 0xa2, 0x42, 0x0b, 0x54,
      0x54, 0xa7, 0xf6, 0x90, 0x03, 0x43, 0x80, 0xba, 0xc9, 0x81, 0xe9, 0x2e},
     {0x83, 0xf8, 0x62, 0xf4, 0x96, 0xab, 0x8a, 0xf1, 0x2b, 0x82, 0xa8, 0xa0,
      0xc0, 0x47, 0xd8, 0x36, 0xbd, 0xfa, 0x36, 0x28, 0x13, 0x24, 0xb3, 0xa1,
      0xeb, 0x2e, 0x9c, 0x1d, 0x46, 0x69, 0x9d, 0x81, 0xcb, 0x12, 0x5c, 0xbe,
      0x4b, 0x93, 0x93, 0x9f, 0xd8, 0x4e, 0x1a, 0xe8, 0x6d, 0x8a, 0x83, 0xcb},
     false,
     true},

    // Comment: edge case private key
    // tcID: 157
    {157,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7,
      0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48,
      0xb0, 0xa7, 0x79, 0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x73, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x07, 0x9d, 0xc5, 0x66, 0x51, 0x0c, 0xc7,
      0x18, 0xff, 0x34, 0x87, 0x97, 0xe2, 0xcf, 0xe6, 0x7c, 0x2f, 0xce, 0x93,
      0xbf, 0x5f, 0x6f, 0x39, 0xbf, 0x74, 0xc1, 0xac, 0x3d, 0x8c, 0xba, 0xe3,
      0xef, 0x92, 0xdd, 0x9c, 0xde, 0xdf, 0xa0, 0xf5, 0x6d, 0x06, 0xba, 0x59,
      0x18, 0xd7, 0x4d, 0x96, 0x42, 0x59, 0xb2, 0x5f, 0x65, 0xa2, 0x6f, 0x78,
      0x43, 0x76, 0x57, 0xbc, 0x81, 0xa3, 0x7f, 0x90, 0x77, 0x9d, 0x9c, 0x88,
      0x8f, 0x7b, 0x7b, 0x4a, 0x0e, 0xc9, 0xd8, 0xaa, 0xc7, 0x76, 0xdb, 0xa6,
      0x55, 0xd6, 0x0b, 0x62, 0xae, 0x33, 0xae, 0x3b, 0xd0, 0x5f, 0x13, 0x2a,
      0x30, 0x3e, 0x94, 0x4a, 0xdc},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe9, 0xdf, 0xaa, 0xab, 0x80, 0x8b, 0x3a, 0xac, 0x1c, 0xcc, 0xa7, 0xcc,
      0x62, 0x42, 0xa7, 0xee, 0x58, 0x32, 0x49, 0xaf, 0xe8, 0xee, 0x8f, 0x66,
      0xb9, 0x04, 0xcc, 0x8e, 0xec, 0x34, 0xad, 0x33, 0x44, 0x56, 0xe0, 0x0f,
      0x33, 0xa9, 0x4d, 0xe8, 0xb5, 0x16, 0x9c, 0xf0, 0x19, 0x95, 0x50, 0xc0,
      0x20, 0x15, 0x6e, 0x96, 0x51, 0x73, 0x4f, 0xf9, 0x99, 0xc5, 0xf3, 0xea,
      0x62, 0xb8, 0x3d, 0x00, 0x83, 0xa6, 0x09, 0x3f, 0x23, 0x44, 0x57, 0x25,
      0x1e, 0xcf, 0x72, 0xc4, 0x1e, 0x4d, 0xf7, 0xce, 0xa2, 0x42, 0x0b, 0x54,
      0x54, 0xa7, 0xf6, 0x90, 0x03, 0x43, 0x80, 0xba, 0xc9, 0x81, 0xe9, 0x2e},
     {0x9a, 0x26, 0x89, 0x48, 0x87, 0xa0, 0x34, 0x2c, 0xa5, 0x59, 0xa7, 0x4a,
      0x4d, 0x4a, 0x8e, 0x1d, 0x6b, 0x20, 0x84, 0xf0, 0x2e, 0x1c, 0x65, 0xb3,
      0x09, 0x71, 0x21, 0xa9, 0xa9, 0xaf, 0x04, 0x7d, 0x88, 0x10, 0xfb, 0x94,
      0x5d, 0xc2, 0x5b, 0xbf, 0x02, 0x22, 0x2b, 0x3b, 0x62, 0x5f, 0x1e, 0x0a},
     false,
     true},

    // Comment: edge case private key
    // tcID: 158
    {158,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7,
      0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48,
      0xb0, 0xa7, 0x7a, 0xec, 0xdc, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x73, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xda, 0xe9, 0x76, 0xe4, 0xbe, 0xe3, 0x3d,
      0xfc, 0xeb, 0x34, 0x68, 0xe9, 0x87, 0x4c, 0xd0, 0xd4, 0x72, 0xc8, 0xda,
      0xb9, 0xec, 0xb7, 0x53, 0x83, 0x4f, 0xa6, 0x38, 0x84, 0xc7, 0x33, 0xaa,
      0x38, 0x60, 0x73, 0xbb, 0x16, 0x37, 0x06, 0xe5, 0xac, 0xb5, 0x00, 0x4b,
      0x5d, 0xce, 0xd7, 0xe5, 0xce, 0x8b, 0xac, 0x01, 0xcf, 0xab, 0x26, 0x8f,
      0xa4, 0x12, 0xa4, 0x60, 0xf7, 0x00, 0x75, 0x79, 0x4a, 0x5e, 0xde, 0x56,
      0xc9, 0xa1, 0x60, 0xf1, 0x33, 0x17, 0x3a, 0xe8, 0x68, 0xa2, 0x59, 0x18,
      0x16, 0x0c, 0xd4, 0x6b, 0x94, 0x1c, 0xdc, 0xbc, 0xe4, 0x09, 0xe0, 0xb0,
      0xf4, 0xd7, 0x02, 0x7b, 0x22},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe9, 0xdf, 0xaa, 0xab, 0x80, 0x8b, 0x3a, 0xac, 0x1c, 0xcc, 0xa7, 0xcc,
      0x62, 0x42, 0xa7, 0xee, 0x58, 0x32, 0x49, 0xaf, 0xe8, 0xee, 0x8f, 0x66,
      0xb9, 0x04, 0xcc, 0x8e, 0xec, 0x34, 0xad, 0x33, 0x44, 0x56, 0xe0, 0x0f,
      0x33, 0xa9, 0x4d, 0xe8, 0xb5, 0x16, 0x9c, 0xf0, 0x19, 0x95, 0x50, 0xc0,
      0x20, 0x15, 0x6e, 0x96, 0x51, 0x73, 0x4f, 0xf9, 0x99, 0xc5, 0xf3, 0xea,
      0x62, 0xb8, 0x3d, 0x00, 0x83, 0xa6, 0x09, 0x3f, 0x23, 0x44, 0x57, 0x25,
      0x1e, 0xcf, 0x72, 0xc4, 0x1e, 0x4d, 0xf7, 0xce, 0xa2, 0x42, 0x0b, 0x54,
      0x54, 0xa7, 0xf6, 0x90, 0x03, 0x43, 0x80, 0xba, 0xc9, 0x81, 0xe9, 0x2e},
     {0x8a, 0x8d, 0x9d, 0xc1, 0x94, 0xa2, 0x69, 0x10, 0xcb, 0xda, 0xe7, 0x90,
      0x8d, 0x18, 0x5b, 0x6a, 0xd0, 0x4b, 0x62, 0x0c, 0x94, 0xc5, 0xee, 0x33,
      0x1e, 0x58, 0x4e, 0xd8, 0x04, 0xe4, 0x95, 0xbe, 0xbc, 0x22, 0x90, 0xa2,
      0xd7, 0x00, 0x6a, 0x06, 0xe6, 0x5b, 0x9b, 0xca, 0xce, 0x86, 0xc6, 0xf6},
     false,
     true},

    // Comment: edge case private key
    // tcID: 159
    {159,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7,
      0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48,
      0xb0, 0xa7, 0x7a, 0xec, 0xe4, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x73, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xa7, 0x1b, 0x35, 0xdc, 0xe0, 0x5d, 0x1a,
      0x61, 0x77, 0x64, 0xfb, 0x2e, 0x24, 0x2d, 0x62, 0xba, 0x74, 0x2c, 0x86,
      0xb1, 0x39, 0x23, 0xe8, 0x85, 0x66, 0x4b, 0x60, 0xe5, 0x0f, 0x3e, 0x56,
      0xa4, 0x53, 0xe9, 0x5f, 0x4e, 0x14, 0x36, 0x0b, 0xc1, 0xc9, 0x00, 0x2a,
      0xab, 0x1d, 0x45, 0xa7, 0x23, 0xc6, 0x99, 0xe1, 0x34, 0xfd, 0xef, 0x15,
      0x53, 0xee, 0x35, 0x62, 0x0e, 0x79, 0x41, 0x0e, 0x53, 0x69, 0x6b, 0xfd,
      0x4e, 0xb8, 0x76, 0x2e, 0x34, 0x36, 0x0a, 0x67, 0xdc, 0xad, 0x0b, 0xf3,
      0xba, 0xd1, 0x8f, 0x91, 0x60, 0xf8, 0xfa, 0xc6, 0x7e, 0x81, 0xbb, 0x74,
      0x67, 0x49, 0x6f, 0xb1, 0x9d},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe9, 0xdf, 0xaa, 0xab, 0x80, 0x8b, 0x3a, 0xac, 0x1c, 0xcc, 0xa7, 0xcc,
      0x62, 0x42, 0xa7, 0xee, 0x58, 0x32, 0x49, 0xaf, 0xe8, 0xee, 0x8f, 0x66,
      0xb9, 0x04, 0xcc, 0x8e, 0xec, 0x34, 0xad, 0x33, 0x44, 0x56, 0xe0, 0x0f,
      0x33, 0xa9, 0x4d, 0xe8, 0xb5, 0x16, 0x9c, 0xf0, 0x19, 0x95, 0x50, 0xc0,
      0x20, 0x15, 0x6e, 0x96, 0x51, 0x73, 0x4f, 0xf9, 0x99, 0xc5, 0xf3, 0xea,
      0x62, 0xb8, 0x3d, 0x00, 0x83, 0xa6, 0x09, 0x3f, 0x23, 0x44, 0x57, 0x25,
      0x1e, 0xcf, 0x72, 0xc4, 0x1e, 0x4d, 0xf7, 0xce, 0xa2, 0x42, 0x0b, 0x54,
      0x54, 0xa7, 0xf6, 0x90, 0x03, 0x43, 0x80, 0xba, 0xc9, 0x81, 0xe9, 0x2e},
     {0xd5, 0x7f, 0x6a, 0xa1, 0x2d, 0x3f, 0x07, 0xe8, 0x95, 0x84, 0x99, 0xf2,
      0x49, 0xe5, 0x2c, 0xfb, 0xe5, 0xbe, 0x58, 0x48, 0x2e, 0x14, 0x6c, 0x54,
      0x14, 0xdb, 0xbf, 0x98, 0x4f, 0xc5, 0x33, 0x37, 0x10, 0x35, 0x0e, 0x2c,
      0xe9, 0x6b, 0x33, 0xbe, 0xb7, 0x67, 0x83, 0x81, 0xf4, 0x0f, 0x1d, 0xcb},
     false,
     true},

    // Comment: edge case private key
    // tcID: 160
    {160,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7,
      0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48,
      0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19, 0x69, 0xcc, 0xc5, 0x29, 0x73, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xba, 0x22, 0x13, 0xc7, 0xad, 0x62, 0xb8,
      0x95, 0x62, 0x72, 0xbe, 0xeb, 0x51, 0xd2, 0x58, 0xa2, 0xa5, 0xbe, 0x80,
      0x4e, 0x0e, 0x29, 0xee, 0xd1, 0x61, 0xa1, 0x62, 0x16, 0xee, 0x89, 0xfb,
      0x8a, 0x45, 0x34, 0x6c, 0x2d, 0x84, 0x43, 0x9a, 0xc8, 0x1a, 0xc3, 0xb9,
      0xd6, 0x75, 0xef, 0x7e, 0xce, 0x57, 0x02, 0x46, 0xc3, 0xbb, 0x92, 0x79,
      0x61, 0xe3, 0x81, 0x23, 0x33, 0xef, 0xa9, 0x4c, 0x7d, 0x6e, 0xcd, 0xbb,
      0x71, 0x20, 0xa0, 0xe1, 0x3e, 0xb8, 0xa6, 0x1e, 0xc7, 0xd9, 0x21, 0x54,
      0x71, 0x25, 0x4a, 0x5f, 0x3e, 0x71, 0xfa, 0xa2, 0x0f, 0xfd, 0xdc, 0xb9,
      0xdb, 0xfc, 0xd7, 0xfb, 0x64},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe9, 0xdf, 0xaa, 0xab, 0x80, 0x8b, 0x3a, 0xac, 0x1c, 0xcc, 0xa7, 0xcc,
      0x62, 0x42, 0xa7, 0xee, 0x58, 0x32, 0x49, 0xaf, 0xe8, 0xee, 0x8f, 0x66,
      0xb9, 0x04, 0xcc, 0x8e, 0xec, 0x34, 0xad, 0x33, 0x44, 0x56, 0xe0, 0x0f,
      0x33, 0xa9, 0x4d, 0xe8, 0xb5, 0x16, 0x9c, 0xf0, 0x19, 0x95, 0x50, 0xc0,
      0x20, 0x15, 0x6e, 0x96, 0x51, 0x73, 0x4f, 0xf9, 0x99, 0xc5, 0xf3, 0xea,
      0x62, 0xb8, 0x3d, 0x00, 0x83, 0xa6, 0x09, 0x3f, 0x23, 0x44, 0x57, 0x25,
      0x1e, 0xcf, 0x72, 0xc4, 0x1e, 0x4d, 0xf7, 0xce, 0xa2, 0x42, 0x0b, 0x54,
      0x54, 0xa7, 0xf6, 0x90, 0x03, 0x43, 0x80, 0xba, 0xc9, 0x81, 0xe9, 0x2e},
     {0x18, 0x8e, 0x80, 0x41, 0xd9, 0xa5, 0xf0, 0xb6, 0xcf, 0xda, 0xd3, 0x15,
      0xad, 0xa4, 0x82, 0x3b, 0xed, 0xa0, 0x14, 0x67, 0x74, 0xfa, 0xd6, 0x5b,
      0x50, 0x0e, 0x6e, 0xf9, 0x43, 0x76, 0xeb, 0xf8, 0xaf, 0x7a, 0x40, 0xff,
      0x6f, 0x6b, 0x45, 0x01, 0x9a, 0x09, 0xdd, 0xe7, 0xd7, 0xfb, 0x55, 0x52},
     false,
     true},

    // Comment: edge case private key
    // tcID: 161
    {161,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7,
      0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48,
      0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x59, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x88, 0xda, 0xe9, 0x6d, 0xc7, 0x6a, 0xb8,
      0xcb, 0x2b, 0x88, 0xd3, 0x63, 0xd1, 0xfc, 0xee, 0xc6, 0xa4, 0x37, 0x3c,
      0x71, 0xc9, 0x03, 0x99, 0xa7, 0xce, 0xbb, 0xb2, 0x5a, 0x07, 0x79, 0x2c,
      0x43, 0x14, 0xfc, 0xdf, 0x3b, 0xc8, 0x56, 0x52, 0x76, 0x9c, 0x2c, 0xd4,
      0x8b, 0xb6, 0x52, 0x6e, 0x80, 0x42, 0x89, 0x37, 0xbd, 0xbb, 0xf0, 0x5c,
      0xb4, 0x44, 0xac, 0x12, 0xed, 0xfe, 0xf3, 0x5e, 0x9f, 0x32, 0x9a, 0x3b,
      0xb9, 0x65, 0x8f, 0x56, 0x63, 0x95, 0x8b, 0xec, 0xeb, 0x34, 0x9e, 0xe7,
      0x31, 0x5e, 0x7b, 0xcd, 0xc0, 0xf3, 0x3b, 0x55, 0x6f, 0x86, 0xf9, 0xe7,
      0xae, 0x74, 0x5a, 0x68, 0x65},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe9, 0xdf, 0xaa, 0xab, 0x80, 0x8b, 0x3a, 0xac, 0x1c, 0xcc, 0xa7, 0xcc,
      0x62, 0x42, 0xa7, 0xee, 0x58, 0x32, 0x49, 0xaf, 0xe8, 0xee, 0x8f, 0x66,
      0xb9, 0x04, 0xcc, 0x8e, 0xec, 0x34, 0xad, 0x33, 0x44, 0x56, 0xe0, 0x0f,
      0x33, 0xa9, 0x4d, 0xe8, 0xb5, 0x16, 0x9c, 0xf0, 0x19, 0x95, 0x50, 0xc0,
      0x20, 0x15, 0x6e, 0x96, 0x51, 0x73, 0x4f, 0xf9, 0x99, 0xc5, 0xf3, 0xea,
      0x62, 0xb8, 0x3d, 0x00, 0x83, 0xa6, 0x09, 0x3f, 0x23, 0x44, 0x57, 0x25,
      0x1e, 0xcf, 0x72, 0xc4, 0x1e, 0x4d, 0xf7, 0xce, 0xa2, 0x42, 0x0b, 0x54,
      0x54, 0xa7, 0xf6, 0x90, 0x03, 0x43, 0x80, 0xba, 0xc9, 0x81, 0xe9, 0x2e},
     {0x2e, 0xcf, 0x9d, 0xc4, 0x7e, 0x8b, 0x07, 0xae, 0x61, 0xdd, 0xbd, 0x16,
      0x80, 0xea, 0xd0, 0x26, 0x98, 0xe9, 0xe8, 0x46, 0x9f, 0x78, 0xd5, 0xa2,
      0x83, 0x28, 0xe4, 0x8d, 0x0c, 0x9d, 0x7a, 0x2a, 0xc7, 0x87, 0xe5, 0x0c,
      0xba, 0x58, 0xcc, 0x44, 0xa3, 0x2f, 0xb1, 0x23, 0x5d, 0x2d, 0x70, 0x27},
     false,
     true},

    // Comment: edge case private key
    // tcID: 162
    {162,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7,
      0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48,
      0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x69, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0xa6, 0x69, 0xc5, 0x56, 0x3b, 0xd6, 0x7e,
      0xec, 0x67, 0x8d, 0x29, 0xd6, 0xef, 0x4f, 0xde, 0x86, 0x4f, 0x37, 0x2d,
      0x90, 0xb7, 0x9b, 0x9e, 0x88, 0x93, 0x1d, 0x5c, 0x29, 0x29, 0x12, 0x38,
      0xcc, 0xed, 0x8e, 0x85, 0xab, 0x50, 0x7b, 0xf9, 0x1a, 0xa9, 0xcb, 0x2d,
      0x13, 0x18, 0x66, 0x58, 0xfb, 0x56, 0x77, 0x48, 0xd5, 0x18, 0x3e, 0xd8,
      0x60, 0xdd, 0x26, 0xf7, 0xc2, 0x4a, 0x0f, 0x13, 0x22, 0x08, 0xfe, 0xe6,
      0xaa, 0xf3, 0xe7, 0xc3, 0xce, 0x3a, 0xfd, 0x20, 0x87, 0x3c, 0x48, 0xfa,
      0x56, 0xd6, 0x92, 0x7e, 0x69, 0xdb, 0x7d, 0x77, 0x26, 0x68, 0x87, 0xb0,
      0x96, 0x48, 0xc5, 0xde, 0x22},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe9, 0xdf, 0xaa, 0xab, 0x80, 0x8b, 0x3a, 0xac, 0x1c, 0xcc, 0xa7, 0xcc,
      0x62, 0x42, 0xa7, 0xee, 0x58, 0x32, 0x49, 0xaf, 0xe8, 0xee, 0x8f, 0x66,
      0xb9, 0x04, 0xcc, 0x8e, 0xec, 0x34, 0xad, 0x33, 0x44, 0x56, 0xe0, 0x0f,
      0x33, 0xa9, 0x4d, 0xe8, 0xb5, 0x16, 0x9c, 0xf0, 0x19, 0x95, 0x50, 0xc0,
      0x20, 0x15, 0x6e, 0x96, 0x51, 0x73, 0x4f, 0xf9, 0x99, 0xc5, 0xf3, 0xea,
      0x62, 0xb8, 0x3d, 0x00, 0x83, 0xa6, 0x09, 0x3f, 0x23, 0x44, 0x57, 0x25,
      0x1e, 0xcf, 0x72, 0xc4, 0x1e, 0x4d, 0xf7, 0xce, 0xa2, 0x42, 0x0b, 0x54,
      0x54, 0xa7, 0xf6, 0x90, 0x03, 0x43, 0x80, 0xba, 0xc9, 0x81, 0xe9, 0x2e},
     {0x06, 0xee, 0x9f, 0x55, 0x07, 0x9d, 0x3d, 0x3c, 0x18, 0xc6, 0x83, 0xba,
      0x33, 0xe0, 0xd2, 0x52, 0x1b, 0xe9, 0x7c, 0x4f, 0xbf, 0x79, 0x17, 0xbf,
      0x3b, 0x62, 0x87, 0xd5, 0x8f, 0xfc, 0xde, 0x2d, 0xf8, 0x88, 0x42, 0xe3,
      0xf5, 0x53, 0x0b, 0x39, 0x54, 0x9a, 0xc2, 0x09, 0x74, 0xb1, 0xb6, 0x0e},
     false,
     true},

    // Comment: edge case private key
    // tcID: 163
    {163,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7,
      0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48,
      0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x70, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x07, 0x7a, 0x41, 0xd4, 0x60, 0x6f, 0xfa,
      0x14, 0x64, 0x79, 0x3c, 0x7e, 0x5f, 0xdc, 0x7d, 0x98, 0xcb, 0x9d, 0x39,
      0x10, 0x20, 0x2d, 0xcd, 0x06, 0xbe, 0xa4, 0xf2, 0x40, 0xd3, 0x56, 0x6d,
      0xa6, 0xb4, 0x08, 0xbb, 0xae, 0x50, 0x26, 0x58, 0x0d, 0x02, 0xd7, 0xe5,
      0xc7, 0x05, 0x00, 0xc8, 0x31, 0x36, 0x6a, 0x08, 0x35, 0xf4, 0xf3, 0xbd,
      0x7c, 0x82, 0xf4, 0x41, 0x69, 0xfd, 0x56, 0x03, 0x66, 0x7a, 0xdf, 0x4b,
      0xe3, 0x7a, 0xee, 0xa5, 0x5a, 0x08, 0x97, 0xb3, 0xf1, 0x23, 0xee, 0xe1,
      0x52, 0x3d, 0xb5, 0x42, 0x93, 0x1b, 0x4a, 0x2d, 0x67, 0x49, 0xa0, 0xd7,
      0xa0, 0xf5, 0xd0, 0xe2, 0x0e},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe9, 0xdf, 0xaa, 0xab, 0x80, 0x8b, 0x3a, 0xac, 0x1c, 0xcc, 0xa7, 0xcc,
      0x62, 0x42, 0xa7, 0xee, 0x58, 0x32, 0x49, 0xaf, 0xe8, 0xee, 0x8f, 0x66,
      0xb9, 0x04, 0xcc, 0x8e, 0xec, 0x34, 0xad, 0x33, 0x44, 0x56, 0xe0, 0x0f,
      0x33, 0xa9, 0x4d, 0xe8, 0xb5, 0x16, 0x9c, 0xf0, 0x19, 0x95, 0x50, 0xc0,
      0x20, 0x15, 0x6e, 0x96, 0x51, 0x73, 0x4f, 0xf9, 0x99, 0xc5, 0xf3, 0xea,
      0x62, 0xb8, 0x3d, 0x00, 0x83, 0xa6, 0x09, 0x3f, 0x23, 0x44, 0x57, 0x25,
      0x1e, 0xcf, 0x72, 0xc4, 0x1e, 0x4d, 0xf7, 0xce, 0xa2, 0x42, 0x0b, 0x54,
      0x54, 0xa7, 0xf6, 0x90, 0x03, 0x43, 0x80, 0xba, 0xc9, 0x81, 0xe9, 0x2e},
     {0x45, 0x5a, 0xea, 0x99, 0x24, 0x33, 0x0b, 0xd6, 0xd2, 0xd6, 0x40, 0x34,
      0x78, 0x32, 0x79, 0x00, 0xe1, 0x72, 0xe9, 0x35, 0x98, 0xe2, 0x54, 0xcf,
      0x6d, 0x8e, 0xb1, 0x3f, 0x0a, 0x3d, 0x21, 0xbe, 0x51, 0xa4, 0x61, 0x07,
      0x33, 0x38, 0x44, 0xe6, 0x1d, 0xfa, 0x3d, 0x80, 0xdf, 0x69, 0x28, 0xe9},
     false,
     true},

    // Comment: edge case private key
    // tcID: 164
    {164,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7,
      0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48,
      0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x71, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x08, 0xd9, 0x99, 0x05, 0x7b, 0xa3, 0xd2,
      0xd9, 0x69, 0x26, 0x00, 0x45, 0xc5, 0x5b, 0x97, 0xf0, 0x89, 0x02, 0x59,
      0x59, 0xa6, 0xf4, 0x34, 0xd6, 0x51, 0xd2, 0x07, 0xd1, 0x9f, 0xb9, 0x6e,
      0x9e, 0x4f, 0xe0, 0xe8, 0x6e, 0xbe, 0x0e, 0x64, 0xf8, 0x5b, 0x96, 0xa9,
      0xc7, 0x52, 0x95, 0xdf, 0x61, 0x71, 0x7f, 0x0e, 0x05, 0xa4, 0xe4, 0xc3,
      0x12, 0x48, 0x40, 0x17, 0x20, 0x02, 0x92, 0x45, 0x8b, 0x4d, 0x8a, 0x27,
      0x8a, 0x43, 0x93, 0x3b, 0xc1, 0x6f, 0xb1, 0xaf, 0xa0, 0xda, 0x95, 0x4b,
      0xd9, 0xa0, 0x02, 0xbc, 0x15, 0xb2, 0xc6, 0x1d, 0xd2, 0x9e, 0xaf, 0xe1,
      0x90, 0xf5, 0x6b, 0xf1, 0x7f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe9, 0xdf, 0xaa, 0xab, 0x80, 0x8b, 0x3a, 0xac, 0x1c, 0xcc, 0xa7, 0xcc,
      0x62, 0x42, 0xa7, 0xee, 0x58, 0x32, 0x49, 0xaf, 0xe8, 0xee, 0x8f, 0x66,
      0xb9, 0x04, 0xcc, 0x8e, 0xec, 0x34, 0xad, 0x33, 0x44, 0x56, 0xe0, 0x0f,
      0x33, 0xa9, 0x4d, 0xe8, 0xb5, 0x16, 0x9c, 0xf0, 0x19, 0x95, 0x50, 0xc0,
      0x20, 0x15, 0x6e, 0x96, 0x51, 0x73, 0x4f, 0xf9, 0x99, 0xc5, 0xf3, 0xea,
      0x62, 0xb8, 0x3d, 0x00, 0x83, 0xa6, 0x09, 0x3f, 0x23, 0x44, 0x57, 0x25,
      0x1e, 0xcf, 0x72, 0xc4, 0x1e, 0x4d, 0xf7, 0xce, 0xa2, 0x42, 0x0b, 0x54,
      0x54, 0xa7, 0xf6, 0x90, 0x03, 0x43, 0x80, 0xba, 0xc9, 0x81, 0xe9, 0x2e},
     {0x02, 0x4c, 0x52, 0x81, 0x48, 0x72, 0x16, 0x05, 0x82, 0x70, 0xcd, 0x1c,
      0xfe, 0x25, 0x9e, 0x94, 0x83, 0x10, 0xe4, 0xad, 0xc2, 0x63, 0xa9, 0xed,
      0xaa, 0x4d, 0xa0, 0xbc, 0x3f, 0x5f, 0x8c, 0xe8, 0xff, 0xc8, 0x8a, 0xe4,
      0x1b, 0x2c, 0x05, 0x0b, 0xf6, 0xdd, 0x9c, 0x8c, 0x66, 0x85, 0x72, 0x37},
     false,
     true},

    // Comment: point is not on curve
    // tcID: 165
    {165,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc6,
      0xca, 0xfb, 0x74, 0xe2, 0xa5, 0x0c, 0x82, 0xc7, 0xa6, 0x3d, 0x13, 0x29,
      0x4b, 0xfe, 0xa1, 0x3d, 0x0b, 0xc5, 0x04, 0xba, 0x2b, 0x08, 0xa3, 0x92,
      0xc9, 0x08, 0x1b, 0xf3, 0x81, 0x5d, 0x9e, 0x44, 0xd9, 0x69, 0xed, 0x7f,
      0x05, 0xff, 0xd1, 0xd8, 0x59, 0x43, 0x55, 0x05, 0x3c, 0x61, 0x47, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5e, 0x53, 0xe8, 0x36, 0x14, 0x6b, 0x51,
      0x96, 0x7e, 0x75, 0xc6, 0x23, 0x47, 0xb4, 0x14, 0x6e, 0x79, 0xc0, 0x56,
      0x10, 0xac, 0x61, 0x8b, 0x95, 0xd9, 0xa6, 0x14, 0x2c, 0x0b, 0x23, 0xfb,
      0xcd, 0x3e, 0x3a, 0xf8, 0x65, 0x4a, 0xda, 0x3b, 0xbf, 0xe8, 0x1e, 0x80,
      0xa7, 0x57, 0xac, 0x16, 0x23, 0xda, 0xd5, 0xc2, 0x79, 0x3a, 0x8b, 0xde,
      0x3e, 0x8a, 0x47, 0xab, 0xdb, 0xa3, 0x25, 0x7e, 0x41, 0xc7, 0x07, 0x47,
      0xc8, 0x96, 0x7b, 0xb5, 0x94, 0xe0, 0xaf, 0x5d, 0x3b, 0x97, 0xfa, 0x11,
      0xe8, 0x2f, 0x71, 0xf2, 0x29, 0xcf, 0x4c, 0xff, 0x3b, 0x5c, 0xc8, 0x5b,
      0x5d, 0xa8, 0x09, 0x0e, 0x70},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 166
    {166,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc6,
      0xca, 0xfb, 0x74, 0xe2, 0xa5, 0x0c, 0x82, 0xc7, 0xa6, 0x3d, 0x13, 0x29,
      0x4b, 0xfe, 0xa1, 0x3d, 0x0b, 0xc5, 0x04, 0xba, 0x2b, 0x08, 0xa3, 0x92,
      0xc9, 0x08, 0x1b, 0xf3, 0x81, 0x5d, 0x9e, 0x44, 0xd9, 0x69, 0xed, 0x7f,
      0x05, 0xff, 0xd1, 0xd8, 0x59, 0x43, 0x55, 0x05, 0x3c, 0x61, 0x47, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5e, 0x53, 0xe8, 0x36, 0x14, 0x6b, 0x51,
      0x96, 0x7e, 0x75, 0xc6, 0x23, 0x47, 0xb4, 0x14, 0x6e, 0x79, 0xc0, 0x56,
      0x10, 0xac, 0x61, 0x8b, 0x95, 0xd9, 0xa6, 0x14, 0x2c, 0x0b, 0x23, 0xfb,
      0xcd, 0x3e, 0x3a, 0xf8, 0x65, 0x4a, 0xda, 0x3b, 0xbf, 0xe8, 0x1e, 0x80,
      0xa7, 0x57, 0xac, 0x16, 0x23, 0xda, 0xd5, 0xc2, 0x79, 0x3a, 0x8b, 0xde,
      0x3e, 0x8a, 0x47, 0xab, 0xdb, 0xa3, 0x25, 0x7e, 0x41, 0xc7, 0x07, 0x47,
      0xc8, 0x96, 0x7b, 0xb5, 0x94, 0xe0, 0xaf, 0x5d, 0x3b, 0x97, 0xfa, 0x11,
      0xe8, 0x2f, 0x71, 0xf2, 0x29, 0xcf, 0x4c, 0xff, 0x3b, 0x5c, 0xc8, 0x5b,
      0x5d, 0xa8, 0x09, 0x0e, 0x70},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 167
    {167,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc6,
      0xca, 0xfb, 0x74, 0xe2, 0xa5, 0x0c, 0x82, 0xc7, 0xa6, 0x3d, 0x13, 0x29,
      0x4b, 0xfe, 0xa1, 0x3d, 0x0b, 0xc5, 0x04, 0xba, 0x2b, 0x08, 0xa3, 0x92,
      0xc9, 0x08, 0x1b, 0xf3, 0x81, 0x5d, 0x9e, 0x44, 0xd9, 0x69, 0xed, 0x7f,
      0x05, 0xff, 0xd1, 0xd8, 0x59, 0x43, 0x55, 0x05, 0x3c, 0x61, 0x47, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5e, 0x53, 0xe8, 0x36, 0x14, 0x6b, 0x51,
      0x96, 0x7e, 0x75, 0xc6, 0x23, 0x47, 0xb4, 0x14, 0x6e, 0x79, 0xc0, 0x56,
      0x10, 0xac, 0x61, 0x8b, 0x95, 0xd9, 0xa6, 0x14, 0x2c, 0x0b, 0x23, 0xfb,
      0xcd, 0x3e, 0x3a, 0xf8, 0x65, 0x4a, 0xda, 0x3b, 0xbf, 0xe8, 0x1e, 0x80,
      0xa7, 0x57, 0xac, 0x16, 0x23, 0xda, 0xd5, 0xc2, 0x79, 0x3a, 0x8b, 0xde,
      0x3e, 0x8a, 0x47, 0xab, 0xdb, 0xa3, 0x25, 0x7e, 0x41, 0xc7, 0x07, 0x47,
      0xc8, 0x96, 0x7b, 0xb5, 0x94, 0xe0, 0xaf, 0x5d, 0x3b, 0x97, 0xfa, 0x11,
      0xe8, 0x2f, 0x71, 0xf2, 0x29, 0xcf, 0x4c, 0xff, 0x3b, 0x5c, 0xc8, 0x5b,
      0x5d, 0xa8, 0x09, 0x0e, 0x70},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfe},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 168
    {168,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc6,
      0xca, 0xfb, 0x74, 0xe2, 0xa5, 0x0c, 0x82, 0xc7, 0xa6, 0x3d, 0x13, 0x29,
      0x4b, 0xfe, 0xa1, 0x3d, 0x0b, 0xc5, 0x04, 0xba, 0x2b, 0x08, 0xa3, 0x92,
      0xc9, 0x08, 0x1b, 0xf3, 0x81, 0x5d, 0x9e, 0x44, 0xd9, 0x69, 0xed, 0x7f,
      0x05, 0xff, 0xd1, 0xd8, 0x59, 0x43, 0x55, 0x05, 0x3c, 0x61, 0x47, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5e, 0x53, 0xe8, 0x36, 0x14, 0x6b, 0x51,
      0x96, 0x7e, 0x75, 0xc6, 0x23, 0x47, 0xb4, 0x14, 0x6e, 0x79, 0xc0, 0x56,
      0x10, 0xac, 0x61, 0x8b, 0x95, 0xd9, 0xa6, 0x14, 0x2c, 0x0b, 0x23, 0xfb,
      0xcd, 0x3e, 0x3a, 0xf8, 0x65, 0x4a, 0xda, 0x3b, 0xbf, 0xe8, 0x1e, 0x80,
      0xa7, 0x57, 0xac, 0x16, 0x23, 0xda, 0xd5, 0xc2, 0x79, 0x3a, 0x8b, 0xde,
      0x3e, 0x8a, 0x47, 0xab, 0xdb, 0xa3, 0x25, 0x7e, 0x41, 0xc7, 0x07, 0x47,
      0xc8, 0x96, 0x7b, 0xb5, 0x94, 0xe0, 0xaf, 0x5d, 0x3b, 0x97, 0xfa, 0x11,
      0xe8, 0x2f, 0x71, 0xf2, 0x29, 0xcf, 0x4c, 0xff, 0x3b, 0x5c, 0xc8, 0x5b,
      0x5d, 0xa8, 0x09, 0x0e, 0x70},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 169
    {169,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc6,
      0xca, 0xfb, 0x74, 0xe2, 0xa5, 0x0c, 0x82, 0xc7, 0xa6, 0x3d, 0x13, 0x29,
      0x4b, 0xfe, 0xa1, 0x3d, 0x0b, 0xc5, 0x04, 0xba, 0x2b, 0x08, 0xa3, 0x92,
      0xc9, 0x08, 0x1b, 0xf3, 0x81, 0x5d, 0x9e, 0x44, 0xd9, 0x69, 0xed, 0x7f,
      0x05, 0xff, 0xd1, 0xd8, 0x59, 0x43, 0x55, 0x05, 0x3c, 0x61, 0x47, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5e, 0x53, 0xe8, 0x36, 0x14, 0x6b, 0x51,
      0x96, 0x7e, 0x75, 0xc6, 0x23, 0x47, 0xb4, 0x14, 0x6e, 0x79, 0xc0, 0x56,
      0x10, 0xac, 0x61, 0x8b, 0x95, 0xd9, 0xa6, 0x14, 0x2c, 0x0b, 0x23, 0xfb,
      0xcd, 0x3e, 0x3a, 0xf8, 0x65, 0x4a, 0xda, 0x3b, 0xbf, 0xe8, 0x1e, 0x80,
      0xa7, 0x57, 0xac, 0x16, 0x23, 0xda, 0xd5, 0xc2, 0x79, 0x3a, 0x8b, 0xde,
      0x3e, 0x8a, 0x47, 0xab, 0xdb, 0xa3, 0x25, 0x7e, 0x41, 0xc7, 0x07, 0x47,
      0xc8, 0x96, 0x7b, 0xb5, 0x94, 0xe0, 0xaf, 0x5d, 0x3b, 0x97, 0xfa, 0x11,
      0xe8, 0x2f, 0x71, 0xf2, 0x29, 0xcf, 0x4c, 0xff, 0x3b, 0x5c, 0xc8, 0x5b,
      0x5d, 0xa8, 0x09, 0x0e, 0x70},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 170
    {170,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc6,
      0xca, 0xfb, 0x74, 0xe2, 0xa5, 0x0c, 0x82, 0xc7, 0xa6, 0x3d, 0x13, 0x29,
      0x4b, 0xfe, 0xa1, 0x3d, 0x0b, 0xc5, 0x04, 0xba, 0x2b, 0x08, 0xa3, 0x92,
      0xc9, 0x08, 0x1b, 0xf3, 0x81, 0x5d, 0x9e, 0x44, 0xd9, 0x69, 0xed, 0x7f,
      0x05, 0xff, 0xd1, 0xd8, 0x59, 0x43, 0x55, 0x05, 0x3c, 0x61, 0x47, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5e, 0x53, 0xe8, 0x36, 0x14, 0x6b, 0x51,
      0x96, 0x7e, 0x75, 0xc6, 0x23, 0x47, 0xb4, 0x14, 0x6e, 0x79, 0xc0, 0x56,
      0x10, 0xac, 0x61, 0x8b, 0x95, 0xd9, 0xa6, 0x14, 0x2c, 0x0b, 0x23, 0xfb,
      0xcd, 0x3e, 0x3a, 0xf8, 0x65, 0x4a, 0xda, 0x3b, 0xbf, 0xe8, 0x1e, 0x80,
      0xa7, 0x57, 0xac, 0x16, 0x23, 0xda, 0xd5, 0xc2, 0x79, 0x3a, 0x8b, 0xde,
      0x3e, 0x8a, 0x47, 0xab, 0xdb, 0xa3, 0x25, 0x7e, 0x41, 0xc7, 0x07, 0x47,
      0xc8, 0x96, 0x7b, 0xb5, 0x94, 0xe0, 0xaf, 0x5d, 0x3b, 0x97, 0xfa, 0x11,
      0xe8, 0x2f, 0x71, 0xf2, 0x29, 0xcf, 0x4c, 0xff, 0x3b, 0x5c, 0xc8, 0x5b,
      0x5d, 0xa8, 0x09, 0x0e, 0x70},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 171
    {171,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc6,
      0xca, 0xfb, 0x74, 0xe2, 0xa5, 0x0c, 0x82, 0xc7, 0xa6, 0x3d, 0x13, 0x29,
      0x4b, 0xfe, 0xa1, 0x3d, 0x0b, 0xc5, 0x04, 0xba, 0x2b, 0x08, 0xa3, 0x92,
      0xc9, 0x08, 0x1b, 0xf3, 0x81, 0x5d, 0x9e, 0x44, 0xd9, 0x69, 0xed, 0x7f,
      0x05, 0xff, 0xd1, 0xd8, 0x59, 0x43, 0x55, 0x05, 0x3c, 0x61, 0x47, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5e, 0x53, 0xe8, 0x36, 0x14, 0x6b, 0x51,
      0x96, 0x7e, 0x75, 0xc6, 0x23, 0x47, 0xb4, 0x14, 0x6e, 0x79, 0xc0, 0x56,
      0x10, 0xac, 0x61, 0x8b, 0x95, 0xd9, 0xa6, 0x14, 0x2c, 0x0b, 0x23, 0xfb,
      0xcd, 0x3e, 0x3a, 0xf8, 0x65, 0x4a, 0xda, 0x3b, 0xbf, 0xe8, 0x1e, 0x80,
      0xa7, 0x57, 0xac, 0x16, 0x23, 0xda, 0xd5, 0xc2, 0x79, 0x3a, 0x8b, 0xde,
      0x3e, 0x8a, 0x47, 0xab, 0xdb, 0xa3, 0x25, 0x7e, 0x41, 0xc7, 0x07, 0x47,
      0xc8, 0x96, 0x7b, 0xb5, 0x94, 0xe0, 0xaf, 0x5d, 0x3b, 0x97, 0xfa, 0x11,
      0xe8, 0x2f, 0x71, 0xf2, 0x29, 0xcf, 0x4c, 0xff, 0x3b, 0x5c, 0xc8, 0x5b,
      0x5d, 0xa8, 0x09, 0x0e, 0x70},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfe},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 172
    {172,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc6,
      0xca, 0xfb, 0x74, 0xe2, 0xa5, 0x0c, 0x82, 0xc7, 0xa6, 0x3d, 0x13, 0x29,
      0x4b, 0xfe, 0xa1, 0x3d, 0x0b, 0xc5, 0x04, 0xba, 0x2b, 0x08, 0xa3, 0x92,
      0xc9, 0x08, 0x1b, 0xf3, 0x81, 0x5d, 0x9e, 0x44, 0xd9, 0x69, 0xed, 0x7f,
      0x05, 0xff, 0xd1, 0xd8, 0x59, 0x43, 0x55, 0x05, 0x3c, 0x61, 0x47, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5e, 0x53, 0xe8, 0x36, 0x14, 0x6b, 0x51,
      0x96, 0x7e, 0x75, 0xc6, 0x23, 0x47, 0xb4, 0x14, 0x6e, 0x79, 0xc0, 0x56,
      0x10, 0xac, 0x61, 0x8b, 0x95, 0xd9, 0xa6, 0x14, 0x2c, 0x0b, 0x23, 0xfb,
      0xcd, 0x3e, 0x3a, 0xf8, 0x65, 0x4a, 0xda, 0x3b, 0xbf, 0xe8, 0x1e, 0x80,
      0xa7, 0x57, 0xac, 0x16, 0x23, 0xda, 0xd5, 0xc2, 0x79, 0x3a, 0x8b, 0xde,
      0x3e, 0x8a, 0x47, 0xab, 0xdb, 0xa3, 0x25, 0x7e, 0x41, 0xc7, 0x07, 0x47,
      0xc8, 0x96, 0x7b, 0xb5, 0x94, 0xe0, 0xaf, 0x5d, 0x3b, 0x97, 0xfa, 0x11,
      0xe8, 0x2f, 0x71, 0xf2, 0x29, 0xcf, 0x4c, 0xff, 0x3b, 0x5c, 0xc8, 0x5b,
      0x5d, 0xa8, 0x09, 0x0e, 0x70},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 173
    {173,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc6,
      0xca, 0xfb, 0x74, 0xe2, 0xa5, 0x0c, 0x82, 0xc7, 0xa6, 0x3d, 0x13, 0x29,
      0x4b, 0xfe, 0xa1, 0x3d, 0x0b, 0xc5, 0x04, 0xba, 0x2b, 0x08, 0xa3, 0x92,
      0xc9, 0x08, 0x1b, 0xf3, 0x81, 0x5d, 0x9e, 0x44, 0xd9, 0x69, 0xed, 0x7f,
      0x05, 0xff, 0xd1, 0xd8, 0x59, 0x43, 0x55, 0x05, 0x3c, 0x61, 0x47, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5e, 0x53, 0xe8, 0x36, 0x14, 0x6b, 0x51,
      0x96, 0x7e, 0x75, 0xc6, 0x23, 0x47, 0xb4, 0x14, 0x6e, 0x79, 0xc0, 0x56,
      0x10, 0xac, 0x61, 0x8b, 0x95, 0xd9, 0xa6, 0x14, 0x2c, 0x0b, 0x23, 0xfb,
      0xcd, 0x3e, 0x3a, 0xf8, 0x65, 0x4a, 0xda, 0x3b, 0xbf, 0xe8, 0x1e, 0x80,
      0xa7, 0x57, 0xac, 0x16, 0x23, 0xda, 0xd5, 0xc2, 0x79, 0x3a, 0x8b, 0xde,
      0x3e, 0x8a, 0x47, 0xab, 0xdb, 0xa3, 0x25, 0x7e, 0x41, 0xc7, 0x07, 0x47,
      0xc8, 0x96, 0x7b, 0xb5, 0x94, 0xe0, 0xaf, 0x5d, 0x3b, 0x97, 0xfa, 0x11,
      0xe8, 0x2f, 0x71, 0xf2, 0x29, 0xcf, 0x4c, 0xff, 0x3b, 0x5c, 0xc8, 0x5b,
      0x5d, 0xa8, 0x09, 0x0e, 0x70},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfe,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 174
    {174,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc6,
      0xca, 0xfb, 0x74, 0xe2, 0xa5, 0x0c, 0x82, 0xc7, 0xa6, 0x3d, 0x13, 0x29,
      0x4b, 0xfe, 0xa1, 0x3d, 0x0b, 0xc5, 0x04, 0xba, 0x2b, 0x08, 0xa3, 0x92,
      0xc9, 0x08, 0x1b, 0xf3, 0x81, 0x5d, 0x9e, 0x44, 0xd9, 0x69, 0xed, 0x7f,
      0x05, 0xff, 0xd1, 0xd8, 0x59, 0x43, 0x55, 0x05, 0x3c, 0x61, 0x47, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5e, 0x53, 0xe8, 0x36, 0x14, 0x6b, 0x51,
      0x96, 0x7e, 0x75, 0xc6, 0x23, 0x47, 0xb4, 0x14, 0x6e, 0x79, 0xc0, 0x56,
      0x10, 0xac, 0x61, 0x8b, 0x95, 0xd9, 0xa6, 0x14, 0x2c, 0x0b, 0x23, 0xfb,
      0xcd, 0x3e, 0x3a, 0xf8, 0x65, 0x4a, 0xda, 0x3b, 0xbf, 0xe8, 0x1e, 0x80,
      0xa7, 0x57, 0xac, 0x16, 0x23, 0xda, 0xd5, 0xc2, 0x79, 0x3a, 0x8b, 0xde,
      0x3e, 0x8a, 0x47, 0xab, 0xdb, 0xa3, 0x25, 0x7e, 0x41, 0xc7, 0x07, 0x47,
      0xc8, 0x96, 0x7b, 0xb5, 0x94, 0xe0, 0xaf, 0x5d, 0x3b, 0x97, 0xfa, 0x11,
      0xe8, 0x2f, 0x71, 0xf2, 0x29, 0xcf, 0x4c, 0xff, 0x3b, 0x5c, 0xc8, 0x5b,
      0x5d, 0xa8, 0x09, 0x0e, 0x70},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfe,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 175
    {175,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc6,
      0xca, 0xfb, 0x74, 0xe2, 0xa5, 0x0c, 0x82, 0xc7, 0xa6, 0x3d, 0x13, 0x29,
      0x4b, 0xfe, 0xa1, 0x3d, 0x0b, 0xc5, 0x04, 0xba, 0x2b, 0x08, 0xa3, 0x92,
      0xc9, 0x08, 0x1b, 0xf3, 0x81, 0x5d, 0x9e, 0x44, 0xd9, 0x69, 0xed, 0x7f,
      0x05, 0xff, 0xd1, 0xd8, 0x59, 0x43, 0x55, 0x05, 0x3c, 0x61, 0x47, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5e, 0x53, 0xe8, 0x36, 0x14, 0x6b, 0x51,
      0x96, 0x7e, 0x75, 0xc6, 0x23, 0x47, 0xb4, 0x14, 0x6e, 0x79, 0xc0, 0x56,
      0x10, 0xac, 0x61, 0x8b, 0x95, 0xd9, 0xa6, 0x14, 0x2c, 0x0b, 0x23, 0xfb,
      0xcd, 0x3e, 0x3a, 0xf8, 0x65, 0x4a, 0xda, 0x3b, 0xbf, 0xe8, 0x1e, 0x80,
      0xa7, 0x57, 0xac, 0x16, 0x23, 0xda, 0xd5, 0xc2, 0x79, 0x3a, 0x8b, 0xde,
      0x3e, 0x8a, 0x47, 0xab, 0xdb, 0xa3, 0x25, 0x7e, 0x41, 0xc7, 0x07, 0x47,
      0xc8, 0x96, 0x7b, 0xb5, 0x94, 0xe0, 0xaf, 0x5d, 0x3b, 0x97, 0xfa, 0x11,
      0xe8, 0x2f, 0x71, 0xf2, 0x29, 0xcf, 0x4c, 0xff, 0x3b, 0x5c, 0xc8, 0x5b,
      0x5d, 0xa8, 0x09, 0x0e, 0x70},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfe,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfe},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 176
    {176,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc6,
      0xca, 0xfb, 0x74, 0xe2, 0xa5, 0x0c, 0x82, 0xc7, 0xa6, 0x3d, 0x13, 0x29,
      0x4b, 0xfe, 0xa1, 0x3d, 0x0b, 0xc5, 0x04, 0xba, 0x2b, 0x08, 0xa3, 0x92,
      0xc9, 0x08, 0x1b, 0xf3, 0x81, 0x5d, 0x9e, 0x44, 0xd9, 0x69, 0xed, 0x7f,
      0x05, 0xff, 0xd1, 0xd8, 0x59, 0x43, 0x55, 0x05, 0x3c, 0x61, 0x47, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5e, 0x53, 0xe8, 0x36, 0x14, 0x6b, 0x51,
      0x96, 0x7e, 0x75, 0xc6, 0x23, 0x47, 0xb4, 0x14, 0x6e, 0x79, 0xc0, 0x56,
      0x10, 0xac, 0x61, 0x8b, 0x95, 0xd9, 0xa6, 0x14, 0x2c, 0x0b, 0x23, 0xfb,
      0xcd, 0x3e, 0x3a, 0xf8, 0x65, 0x4a, 0xda, 0x3b, 0xbf, 0xe8, 0x1e, 0x80,
      0xa7, 0x57, 0xac, 0x16, 0x23, 0xda, 0xd5, 0xc2, 0x79, 0x3a, 0x8b, 0xde,
      0x3e, 0x8a, 0x47, 0xab, 0xdb, 0xa3, 0x25, 0x7e, 0x41, 0xc7, 0x07, 0x47,
      0xc8, 0x96, 0x7b, 0xb5, 0x94, 0xe0, 0xaf, 0x5d, 0x3b, 0x97, 0xfa, 0x11,
      0xe8, 0x2f, 0x71, 0xf2, 0x29, 0xcf, 0x4c, 0xff, 0x3b, 0x5c, 0xc8, 0x5b,
      0x5d, 0xa8, 0x09, 0x0e, 0x70},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfe,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 177
    {177,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc6,
      0xca, 0xfb, 0x74, 0xe2, 0xa5, 0x0c, 0x82, 0xc7, 0xa6, 0x3d, 0x13, 0x29,
      0x4b, 0xfe, 0xa1, 0x3d, 0x0b, 0xc5, 0x04, 0xba, 0x2b, 0x08, 0xa3, 0x92,
      0xc9, 0x08, 0x1b, 0xf3, 0x81, 0x5d, 0x9e, 0x44, 0xd9, 0x69, 0xed, 0x7f,
      0x05, 0xff, 0xd1, 0xd8, 0x59, 0x43, 0x55, 0x05, 0x3c, 0x61, 0x47, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5e, 0x53, 0xe8, 0x36, 0x14, 0x6b, 0x51,
      0x96, 0x7e, 0x75, 0xc6, 0x23, 0x47, 0xb4, 0x14, 0x6e, 0x79, 0xc0, 0x56,
      0x10, 0xac, 0x61, 0x8b, 0x95, 0xd9, 0xa6, 0x14, 0x2c, 0x0b, 0x23, 0xfb,
      0xcd, 0x3e, 0x3a, 0xf8, 0x65, 0x4a, 0xda, 0x3b, 0xbf, 0xe8, 0x1e, 0x80,
      0xa7, 0x57, 0xac, 0x16, 0x23, 0xda, 0xd5, 0xc2, 0x79, 0x3a, 0x8b, 0xde,
      0x3e, 0x8a, 0x47, 0xab, 0xdb, 0xa3, 0x25, 0x7e, 0x41, 0xc7, 0x07, 0x47,
      0xc8, 0x96, 0x7b, 0xb5, 0x94, 0xe0, 0xaf, 0x5d, 0x3b, 0x97, 0xfa, 0x11,
      0xe8, 0x2f, 0x71, 0xf2, 0x29, 0xcf, 0x4c, 0xff, 0x3b, 0x5c, 0xc8, 0x5b,
      0x5d, 0xa8, 0x09, 0x0e, 0x70},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 178
    {178,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc6,
      0xca, 0xfb, 0x74, 0xe2, 0xa5, 0x0c, 0x82, 0xc7, 0xa6, 0x3d, 0x13, 0x29,
      0x4b, 0xfe, 0xa1, 0x3d, 0x0b, 0xc5, 0x04, 0xba, 0x2b, 0x08, 0xa3, 0x92,
      0xc9, 0x08, 0x1b, 0xf3, 0x81, 0x5d, 0x9e, 0x44, 0xd9, 0x69, 0xed, 0x7f,
      0x05, 0xff, 0xd1, 0xd8, 0x59, 0x43, 0x55, 0x05, 0x3c, 0x61, 0x47, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5e, 0x53, 0xe8, 0x36, 0x14, 0x6b, 0x51,
      0x96, 0x7e, 0x75, 0xc6, 0x23, 0x47, 0xb4, 0x14, 0x6e, 0x79, 0xc0, 0x56,
      0x10, 0xac, 0x61, 0x8b, 0x95, 0xd9, 0xa6, 0x14, 0x2c, 0x0b, 0x23, 0xfb,
      0xcd, 0x3e, 0x3a, 0xf8, 0x65, 0x4a, 0xda, 0x3b, 0xbf, 0xe8, 0x1e, 0x80,
      0xa7, 0x57, 0xac, 0x16, 0x23, 0xda, 0xd5, 0xc2, 0x79, 0x3a, 0x8b, 0xde,
      0x3e, 0x8a, 0x47, 0xab, 0xdb, 0xa3, 0x25, 0x7e, 0x41, 0xc7, 0x07, 0x47,
      0xc8, 0x96, 0x7b, 0xb5, 0x94, 0xe0, 0xaf, 0x5d, 0x3b, 0x97, 0xfa, 0x11,
      0xe8, 0x2f, 0x71, 0xf2, 0x29, 0xcf, 0x4c, 0xff, 0x3b, 0x5c, 0xc8, 0x5b,
      0x5d, 0xa8, 0x09, 0x0e, 0x70},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 179
    {179,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc6,
      0xca, 0xfb, 0x74, 0xe2, 0xa5, 0x0c, 0x82, 0xc7, 0xa6, 0x3d, 0x13, 0x29,
      0x4b, 0xfe, 0xa1, 0x3d, 0x0b, 0xc5, 0x04, 0xba, 0x2b, 0x08, 0xa3, 0x92,
      0xc9, 0x08, 0x1b, 0xf3, 0x81, 0x5d, 0x9e, 0x44, 0xd9, 0x69, 0xed, 0x7f,
      0x05, 0xff, 0xd1, 0xd8, 0x59, 0x43, 0x55, 0x05, 0x3c, 0x61, 0x47, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5e, 0x53, 0xe8, 0x36, 0x14, 0x6b, 0x51,
      0x96, 0x7e, 0x75, 0xc6, 0x23, 0x47, 0xb4, 0x14, 0x6e, 0x79, 0xc0, 0x56,
      0x10, 0xac, 0x61, 0x8b, 0x95, 0xd9, 0xa6, 0x14, 0x2c, 0x0b, 0x23, 0xfb,
      0xcd, 0x3e, 0x3a, 0xf8, 0x65, 0x4a, 0xda, 0x3b, 0xbf, 0xe8, 0x1e, 0x80,
      0xa7, 0x57, 0xac, 0x16, 0x23, 0xda, 0xd5, 0xc2, 0x79, 0x3a, 0x8b, 0xde,
      0x3e, 0x8a, 0x47, 0xab, 0xdb, 0xa3, 0x25, 0x7e, 0x41, 0xc7, 0x07, 0x47,
      0xc8, 0x96, 0x7b, 0xb5, 0x94, 0xe0, 0xaf, 0x5d, 0x3b, 0x97, 0xfa, 0x11,
      0xe8, 0x2f, 0x71, 0xf2, 0x29, 0xcf, 0x4c, 0xff, 0x3b, 0x5c, 0xc8, 0x5b,
      0x5d, 0xa8, 0x09, 0x0e, 0x70},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfe},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 180
    {180,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc6,
      0xca, 0xfb, 0x74, 0xe2, 0xa5, 0x0c, 0x82, 0xc7, 0xa6, 0x3d, 0x13, 0x29,
      0x4b, 0xfe, 0xa1, 0x3d, 0x0b, 0xc5, 0x04, 0xba, 0x2b, 0x08, 0xa3, 0x92,
      0xc9, 0x08, 0x1b, 0xf3, 0x81, 0x5d, 0x9e, 0x44, 0xd9, 0x69, 0xed, 0x7f,
      0x05, 0xff, 0xd1, 0xd8, 0x59, 0x43, 0x55, 0x05, 0x3c, 0x61, 0x47, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5e, 0x53, 0xe8, 0x36, 0x14, 0x6b, 0x51,
      0x96, 0x7e, 0x75, 0xc6, 0x23, 0x47, 0xb4, 0x14, 0x6e, 0x79, 0xc0, 0x56,
      0x10, 0xac, 0x61, 0x8b, 0x95, 0xd9, 0xa6, 0x14, 0x2c, 0x0b, 0x23, 0xfb,
      0xcd, 0x3e, 0x3a, 0xf8, 0x65, 0x4a, 0xda, 0x3b, 0xbf, 0xe8, 0x1e, 0x80,
      0xa7, 0x57, 0xac, 0x16, 0x23, 0xda, 0xd5, 0xc2, 0x79, 0x3a, 0x8b, 0xde,
      0x3e, 0x8a, 0x47, 0xab, 0xdb, 0xa3, 0x25, 0x7e, 0x41, 0xc7, 0x07, 0x47,
      0xc8, 0x96, 0x7b, 0xb5, 0x94, 0xe0, 0xaf, 0x5d, 0x3b, 0x97, 0xfa, 0x11,
      0xe8, 0x2f, 0x71, 0xf2, 0x29, 0xcf, 0x4c, 0xff, 0x3b, 0x5c, 0xc8, 0x5b,
      0x5d, 0xa8, 0x09, 0x0e, 0x70},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff},
     {},
     false,
     false},

    // Comment:
    // tcID: 181
    {181,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xc6,
      0xca, 0xfb, 0x74, 0xe2, 0xa5, 0x0c, 0x82, 0xc7, 0xa6, 0x3d, 0x13, 0x29,
      0x4b, 0xfe, 0xa1, 0x3d, 0x0b, 0xc5, 0x04, 0xba, 0x2b, 0x08, 0xa3, 0x92,
      0xc9, 0x08, 0x1b, 0xf3, 0x81, 0x5d, 0x9e, 0x44, 0xd9, 0x69, 0xed, 0x7f,
      0x05, 0xff, 0xd1, 0xd8, 0x59, 0x43, 0x55, 0x05, 0x3c, 0x61, 0x47, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x5e, 0x53, 0xe8, 0x36, 0x14, 0x6b, 0x51,
      0x96, 0x7e, 0x75, 0xc6, 0x23, 0x47, 0xb4, 0x14, 0x6e, 0x79, 0xc0, 0x56,
      0x10, 0xac, 0x61, 0x8b, 0x95, 0xd9, 0xa6, 0x14, 0x2c, 0x0b, 0x23, 0xfb,
      0xcd, 0x3e, 0x3a, 0xf8, 0x65, 0x4a, 0xda, 0x3b, 0xbf, 0xe8, 0x1e, 0x80,
      0xa7, 0x57, 0xac, 0x16, 0x23, 0xda, 0xd5, 0xc2, 0x79, 0x3a, 0x8b, 0xde,
      0x3e, 0x8a, 0x47, 0xab, 0xdb, 0xa3, 0x25, 0x7e, 0x41, 0xc7, 0x07, 0x47,
      0xc8, 0x96, 0x7b, 0xb5, 0x94, 0xe0, 0xaf, 0x5d, 0x3b, 0x97, 0xfa, 0x11,
      0xe8, 0x2f, 0x71, 0xf2, 0x29, 0xcf, 0x4c, 0xff, 0x3b, 0x5c, 0xc8, 0x5b,
      0x5d, 0xa8, 0x09, 0x0e, 0x70},
     {0x30, 0x15, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x01, 0x00},
     {},
     false,
     false},

    // Comment: public point not on curve
    // tcID: 182
    {182,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xde,
      0x44, 0xe6, 0x3f, 0xd9, 0x24, 0xf1, 0x77, 0x34, 0x0d, 0x78, 0x0a, 0xf6,
      0xaa, 0xae, 0xa2, 0x71, 0xf5, 0x2d, 0x2c, 0xb9, 0xa5, 0xc5, 0x19, 0xb6,
      0x02, 0x0e, 0x06, 0xc3, 0xcf, 0x0b, 0xaa, 0xfb, 0xc0, 0xb8, 0x01, 0xc6,
      0x50, 0x8c, 0x2e, 0x14, 0x83, 0xb1, 0x5c, 0xfe, 0xf7, 0xaf, 0xc2, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x65, 0xce, 0x6b, 0x9d, 0x7e, 0x71, 0xe9,
      0x31, 0xb6, 0xfd, 0x1f, 0xac, 0x91, 0x05, 0x07, 0xb4, 0x37, 0x7a, 0xc1,
      0x5e, 0x45, 0x32, 0x92, 0xa2, 0x35, 0x5d, 0xf3, 0x9a, 0xb7, 0x41, 0xca,
      0x36, 0x29, 0x7b, 0xf6, 0xde, 0x3c, 0x34, 0xa5, 0xaf, 0xbb, 0xad, 0x37,
      0x18, 0x06, 0xb8, 0x91, 0xf2, 0x4b, 0x08, 0x8b, 0xc5, 0xd1, 0x46, 0x46,
      0xa7, 0x4f, 0x3e, 0xfc, 0xfe, 0xa3, 0x9e, 0x12, 0xe2, 0xb5, 0xf5, 0x6e,
      0xbb, 0xdd, 0x50, 0x3d, 0x5e, 0x8f, 0xee, 0x3f, 0xc3, 0x00, 0xd7, 0x50,
      0x9b, 0xaa, 0x22, 0xb6, 0x68, 0xdb, 0xf1, 0xfd, 0x24, 0x18, 0x07, 0x0a,
      0xb4, 0x0a, 0x07, 0xd9, 0xf6},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x21, 0x21, 0xa3, 0x48, 0xf9, 0x74, 0x38, 0x55, 0x85, 0x9c, 0x49, 0x6f,
      0x91, 0xd0, 0xf3, 0x9f, 0xe7, 0x28, 0xfc, 0x46, 0xe4, 0x8d, 0x00, 0x77,
      0x13, 0x05, 0x1b, 0x22, 0xf1, 0xc0, 0x25, 0x7f, 0xe2, 0x0d, 0xd8, 0x5b,
      0x21, 0xdf, 0x7e, 0x1e, 0xc8, 0x2b, 0xf8, 0xb3, 0x9b, 0x21, 0x38, 0xa2,
      0xae, 0x74, 0xf8, 0x0e, 0x62, 0x57, 0x77, 0x8f, 0x8c, 0xca, 0x9f, 0x27,
      0x9b, 0x57, 0xd2, 0x5e, 0xee, 0xb1, 0x55, 0x96, 0x06, 0x42, 0x97, 0x2f,
      0x05, 0x67, 0xe2, 0x04, 0x51, 0x4f, 0x0a, 0xc1, 0xeb, 0x1e, 0x27, 0xdb,
      0x51, 0x15, 0x05, 0x32, 0x11, 0x91, 0x49, 0x61, 0xd0, 0x96, 0x44, 0xc8},
     {},
     false,
     false},

    // Comment: public point = (0,0)
    // tcID: 183
    {183,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xde,
      0x44, 0xe6, 0x3f, 0xd9, 0x24, 0xf1, 0x77, 0x34, 0x0d, 0x78, 0x0a, 0xf6,
      0xaa, 0xae, 0xa2, 0x71, 0xf5, 0x2d, 0x2c, 0xb9, 0xa5, 0xc5, 0x19, 0xb6,
      0x02, 0x0e, 0x06, 0xc3, 0xcf, 0x0b, 0xaa, 0xfb, 0xc0, 0xb8, 0x01, 0xc6,
      0x50, 0x8c, 0x2e, 0x14, 0x83, 0xb1, 0x5c, 0xfe, 0xf7, 0xaf, 0xc2, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x65, 0xce, 0x6b, 0x9d, 0x7e, 0x71, 0xe9,
      0x31, 0xb6, 0xfd, 0x1f, 0xac, 0x91, 0x05, 0x07, 0xb4, 0x37, 0x7a, 0xc1,
      0x5e, 0x45, 0x32, 0x92, 0xa2, 0x35, 0x5d, 0xf3, 0x9a, 0xb7, 0x41, 0xca,
      0x36, 0x29, 0x7b, 0xf6, 0xde, 0x3c, 0x34, 0xa5, 0xaf, 0xbb, 0xad, 0x37,
      0x18, 0x06, 0xb8, 0x91, 0xf2, 0x4b, 0x08, 0x8b, 0xc5, 0xd1, 0x46, 0x46,
      0xa7, 0x4f, 0x3e, 0xfc, 0xfe, 0xa3, 0x9e, 0x12, 0xe2, 0xb5, 0xf5, 0x6e,
      0xbb, 0xdd, 0x50, 0x3d, 0x5e, 0x8f, 0xee, 0x3f, 0xc3, 0x00, 0xd7, 0x50,
      0x9b, 0xaa, 0x22, 0xb6, 0x68, 0xdb, 0xf1, 0xfd, 0x24, 0x18, 0x07, 0x0a,
      0xb4, 0x0a, 0x07, 0xd9, 0xf6},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {},
     false,
     false},

    // Comment: order =
    // -39402006196394479212279040100143613805079739270465446667946905279627659399113263569398956308152294913554433653942643
    // tcID: 184
    {184,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xde,
      0x44, 0xe6, 0x3f, 0xd9, 0x24, 0xf1, 0x77, 0x34, 0x0d, 0x78, 0x0a, 0xf6,
      0xaa, 0xae, 0xa2, 0x71, 0xf5, 0x2d, 0x2c, 0xb9, 0xa5, 0xc5, 0x19, 0xb6,
      0x02, 0x0e, 0x06, 0xc3, 0xcf, 0x0b, 0xaa, 0xfb, 0xc0, 0xb8, 0x01, 0xc6,
      0x50, 0x8c, 0x2e, 0x14, 0x83, 0xb1, 0x5c, 0xfe, 0xf7, 0xaf, 0xc2, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x65, 0xce, 0x6b, 0x9d, 0x7e, 0x71, 0xe9,
      0x31, 0xb6, 0xfd, 0x1f, 0xac, 0x91, 0x05, 0x07, 0xb4, 0x37, 0x7a, 0xc1,
      0x5e, 0x45, 0x32, 0x92, 0xa2, 0x35, 0x5d, 0xf3, 0x9a, 0xb7, 0x41, 0xca,
      0x36, 0x29, 0x7b, 0xf6, 0xde, 0x3c, 0x34, 0xa5, 0xaf, 0xbb, 0xad, 0x37,
      0x18, 0x06, 0xb8, 0x91, 0xf2, 0x4b, 0x08, 0x8b, 0xc5, 0xd1, 0x46, 0x46,
      0xa7, 0x4f, 0x3e, 0xfc, 0xfe, 0xa3, 0x9e, 0x12, 0xe2, 0xb5, 0xf5, 0x6e,
      0xbb, 0xdd, 0x50, 0x3d, 0x5e, 0x8f, 0xee, 0x3f, 0xc3, 0x00, 0xd7, 0x50,
      0x9b, 0xaa, 0x22, 0xb6, 0x68, 0xdb, 0xf1, 0xfd, 0x24, 0x18, 0x07, 0x0a,
      0xb4, 0x0a, 0x07, 0xd9, 0xf6},
     {0x30, 0x82, 0x01, 0xb5, 0x30, 0x82, 0x01, 0x4d, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x30, 0x82, 0x01, 0x40, 0x02, 0x01, 0x01,
      0x30, 0x3c, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x30, 0x64, 0x04, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x30, 0xb3, 0x31, 0x2f, 0xa7,
      0xe2, 0x3e, 0xe7, 0xe4, 0x98, 0x8e, 0x05, 0x6b, 0xe3, 0xf8, 0x2d, 0x19,
      0x18, 0x1d, 0x9c, 0x6e, 0xfe, 0x81, 0x41, 0x12, 0x03, 0x14, 0x08, 0x8f,
      0x50, 0x13, 0x87, 0x5a, 0xc6, 0x56, 0x39, 0x8d, 0x8a, 0x2e, 0xd1, 0x9d,
      0x2a, 0x85, 0xc8, 0xed, 0xd3, 0xec, 0x2a, 0xef, 0x04, 0x61, 0x04, 0xaa,
      0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05, 0x37, 0x8e, 0xb1, 0xc7, 0x1e, 0xf3,
      0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b, 0x62, 0x8b, 0xa7, 0x9b, 0x98, 0x59,
      0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a, 0x38, 0x55, 0x02, 0xf2, 0x5d, 0xbf,
      0x55, 0x29, 0x6c, 0x3a, 0x54, 0x5e, 0x38, 0x72, 0x76, 0x0a, 0xb7, 0x36,
      0x17, 0xde, 0x4a, 0x96, 0x26, 0x2c, 0x6f, 0x5d, 0x9e, 0x98, 0xbf, 0x92,
      0x92, 0xdc, 0x29, 0xf8, 0xf4, 0x1d, 0xbd, 0x28, 0x9a, 0x14, 0x7c, 0xe9,
      0xda, 0x31, 0x13, 0xb5, 0xf0, 0xb8, 0xc0, 0x0a, 0x60, 0xb1, 0xce, 0x1d,
      0x7e, 0x81, 0x9d, 0x7a, 0x43, 0x1d, 0x7c, 0x90, 0xea, 0x0e, 0x5f, 0x02,
      0x31, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x38, 0x9c, 0xb2, 0x7e, 0x0b, 0xc8, 0xd2, 0x20, 0xa7, 0xe5,
      0xf2, 0x4d, 0xb7, 0x4f, 0x58, 0x85, 0x13, 0x13, 0xe6, 0x95, 0x33, 0x3a,
      0xd6, 0x8d, 0x02, 0x01, 0x01, 0x03, 0x62, 0x00, 0x04, 0x21, 0x21, 0xa3,
      0x48, 0xf9, 0x74, 0x38, 0x55, 0x85, 0x9c, 0x49, 0x6f, 0x91, 0xd0, 0xf3,
      0x9f, 0xe7, 0x28, 0xfc, 0x46, 0xe4, 0x8d, 0x00, 0x77, 0x13, 0x05, 0x1b,
      0x22, 0xf1, 0xc0, 0x25, 0x7f, 0xe2, 0x0d, 0xd8, 0x5b, 0x21, 0xdf, 0x7e,
      0x1e, 0xc8, 0x2b, 0xf8, 0xb3, 0x9b, 0x21, 0x38, 0xa2, 0xae, 0x74, 0xf8,
      0x0e, 0x62, 0x57, 0x77, 0x8f, 0x8c, 0xca, 0x9f, 0x27, 0x9b, 0x57, 0xd2,
      0x5e, 0xee, 0xb1, 0x55, 0x96, 0x06, 0x42, 0x97, 0x2f, 0x05, 0x67, 0xe2,
      0x04, 0x51, 0x4f, 0x0a, 0xc1, 0xeb, 0x1e, 0x27, 0xdb, 0x51, 0x15, 0x05,
      0x32, 0x11, 0x91, 0x49, 0x61, 0xd0, 0x96, 0x44, 0xc6},
     {0x45, 0x5c, 0xf3, 0xc0, 0xb0, 0x09, 0x06, 0x88, 0x59, 0x98, 0x25, 0x52,
      0x2e, 0xf3, 0x31, 0x28, 0x78, 0x20, 0x15, 0x14, 0xf6, 0x33, 0x0c, 0xcc,
      0x7f, 0x42, 0xec, 0x19, 0x45, 0x20, 0x4a, 0xdf, 0xe4, 0x19, 0xb2, 0xdb,
      0xbf, 0xb9, 0x42, 0xdc, 0x98, 0xb1, 0x6d, 0x83, 0x23, 0x15, 0x0c, 0xf6},
     false,
     false},

    // Comment: order = 0
    // tcID: 185
    {185,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xde,
      0x44, 0xe6, 0x3f, 0xd9, 0x24, 0xf1, 0x77, 0x34, 0x0d, 0x78, 0x0a, 0xf6,
      0xaa, 0xae, 0xa2, 0x71, 0xf5, 0x2d, 0x2c, 0xb9, 0xa5, 0xc5, 0x19, 0xb6,
      0x02, 0x0e, 0x06, 0xc3, 0xcf, 0x0b, 0xaa, 0xfb, 0xc0, 0xb8, 0x01, 0xc6,
      0x50, 0x8c, 0x2e, 0x14, 0x83, 0xb1, 0x5c, 0xfe, 0xf7, 0xaf, 0xc2, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x65, 0xce, 0x6b, 0x9d, 0x7e, 0x71, 0xe9,
      0x31, 0xb6, 0xfd, 0x1f, 0xac, 0x91, 0x05, 0x07, 0xb4, 0x37, 0x7a, 0xc1,
      0x5e, 0x45, 0x32, 0x92, 0xa2, 0x35, 0x5d, 0xf3, 0x9a, 0xb7, 0x41, 0xca,
      0x36, 0x29, 0x7b, 0xf6, 0xde, 0x3c, 0x34, 0xa5, 0xaf, 0xbb, 0xad, 0x37,
      0x18, 0x06, 0xb8, 0x91, 0xf2, 0x4b, 0x08, 0x8b, 0xc5, 0xd1, 0x46, 0x46,
      0xa7, 0x4f, 0x3e, 0xfc, 0xfe, 0xa3, 0x9e, 0x12, 0xe2, 0xb5, 0xf5, 0x6e,
      0xbb, 0xdd, 0x50, 0x3d, 0x5e, 0x8f, 0xee, 0x3f, 0xc3, 0x00, 0xd7, 0x50,
      0x9b, 0xaa, 0x22, 0xb6, 0x68, 0xdb, 0xf1, 0xfd, 0x24, 0x18, 0x07, 0x0a,
      0xb4, 0x0a, 0x07, 0xd9, 0xf6},
     {0x30, 0x82, 0x01, 0x85, 0x30, 0x82, 0x01, 0x1d, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x30, 0x82, 0x01, 0x10, 0x02, 0x01, 0x01,
      0x30, 0x3c, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x30, 0x64, 0x04, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x30, 0xb3, 0x31, 0x2f, 0xa7,
      0xe2, 0x3e, 0xe7, 0xe4, 0x98, 0x8e, 0x05, 0x6b, 0xe3, 0xf8, 0x2d, 0x19,
      0x18, 0x1d, 0x9c, 0x6e, 0xfe, 0x81, 0x41, 0x12, 0x03, 0x14, 0x08, 0x8f,
      0x50, 0x13, 0x87, 0x5a, 0xc6, 0x56, 0x39, 0x8d, 0x8a, 0x2e, 0xd1, 0x9d,
      0x2a, 0x85, 0xc8, 0xed, 0xd3, 0xec, 0x2a, 0xef, 0x04, 0x61, 0x04, 0xaa,
      0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05, 0x37, 0x8e, 0xb1, 0xc7, 0x1e, 0xf3,
      0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b, 0x62, 0x8b, 0xa7, 0x9b, 0x98, 0x59,
      0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a, 0x38, 0x55, 0x02, 0xf2, 0x5d, 0xbf,
      0x55, 0x29, 0x6c, 0x3a, 0x54, 0x5e, 0x38, 0x72, 0x76, 0x0a, 0xb7, 0x36,
      0x17, 0xde, 0x4a, 0x96, 0x26, 0x2c, 0x6f, 0x5d, 0x9e, 0x98, 0xbf, 0x92,
      0x92, 0xdc, 0x29, 0xf8, 0xf4, 0x1d, 0xbd, 0x28, 0x9a, 0x14, 0x7c, 0xe9,
      0xda, 0x31, 0x13, 0xb5, 0xf0, 0xb8, 0xc0, 0x0a, 0x60, 0xb1, 0xce, 0x1d,
      0x7e, 0x81, 0x9d, 0x7a, 0x43, 0x1d, 0x7c, 0x90, 0xea, 0x0e, 0x5f, 0x02,
      0x01, 0x00, 0x02, 0x01, 0x01, 0x03, 0x62, 0x00, 0x04, 0x21, 0x21, 0xa3,
      0x48, 0xf9, 0x74, 0x38, 0x55, 0x85, 0x9c, 0x49, 0x6f, 0x91, 0xd0, 0xf3,
      0x9f, 0xe7, 0x28, 0xfc, 0x46, 0xe4, 0x8d, 0x00, 0x77, 0x13, 0x05, 0x1b,
      0x22, 0xf1, 0xc0, 0x25, 0x7f, 0xe2, 0x0d, 0xd8, 0x5b, 0x21, 0xdf, 0x7e,
      0x1e, 0xc8, 0x2b, 0xf8, 0xb3, 0x9b, 0x21, 0x38, 0xa2, 0xae, 0x74, 0xf8,
      0x0e, 0x62, 0x57, 0x77, 0x8f, 0x8c, 0xca, 0x9f, 0x27, 0x9b, 0x57, 0xd2,
      0x5e, 0xee, 0xb1, 0x55, 0x96, 0x06, 0x42, 0x97, 0x2f, 0x05, 0x67, 0xe2,
      0x04, 0x51, 0x4f, 0x0a, 0xc1, 0xeb, 0x1e, 0x27, 0xdb, 0x51, 0x15, 0x05,
      0x32, 0x11, 0x91, 0x49, 0x61, 0xd0, 0x96, 0x44, 0xc6},
     {0x45, 0x5c, 0xf3, 0xc0, 0xb0, 0x09, 0x06, 0x88, 0x59, 0x98, 0x25, 0x52,
      0x2e, 0xf3, 0x31, 0x28, 0x78, 0x20, 0x15, 0x14, 0xf6, 0x33, 0x0c, 0xcc,
      0x7f, 0x42, 0xec, 0x19, 0x45, 0x20, 0x4a, 0xdf, 0xe4, 0x19, 0xb2, 0xdb,
      0xbf, 0xb9, 0x42, 0xdc, 0x98, 0xb1, 0x6d, 0x83, 0x23, 0x15, 0x0c, 0xf6},
     false,
     false},

    // Comment: order = 1
    // tcID: 186
    {186,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xde,
      0x44, 0xe6, 0x3f, 0xd9, 0x24, 0xf1, 0x77, 0x34, 0x0d, 0x78, 0x0a, 0xf6,
      0xaa, 0xae, 0xa2, 0x71, 0xf5, 0x2d, 0x2c, 0xb9, 0xa5, 0xc5, 0x19, 0xb6,
      0x02, 0x0e, 0x06, 0xc3, 0xcf, 0x0b, 0xaa, 0xfb, 0xc0, 0xb8, 0x01, 0xc6,
      0x50, 0x8c, 0x2e, 0x14, 0x83, 0xb1, 0x5c, 0xfe, 0xf7, 0xaf, 0xc2, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x65, 0xce, 0x6b, 0x9d, 0x7e, 0x71, 0xe9,
      0x31, 0xb6, 0xfd, 0x1f, 0xac, 0x91, 0x05, 0x07, 0xb4, 0x37, 0x7a, 0xc1,
      0x5e, 0x45, 0x32, 0x92, 0xa2, 0x35, 0x5d, 0xf3, 0x9a, 0xb7, 0x41, 0xca,
      0x36, 0x29, 0x7b, 0xf6, 0xde, 0x3c, 0x34, 0xa5, 0xaf, 0xbb, 0xad, 0x37,
      0x18, 0x06, 0xb8, 0x91, 0xf2, 0x4b, 0x08, 0x8b, 0xc5, 0xd1, 0x46, 0x46,
      0xa7, 0x4f, 0x3e, 0xfc, 0xfe, 0xa3, 0x9e, 0x12, 0xe2, 0xb5, 0xf5, 0x6e,
      0xbb, 0xdd, 0x50, 0x3d, 0x5e, 0x8f, 0xee, 0x3f, 0xc3, 0x00, 0xd7, 0x50,
      0x9b, 0xaa, 0x22, 0xb6, 0x68, 0xdb, 0xf1, 0xfd, 0x24, 0x18, 0x07, 0x0a,
      0xb4, 0x0a, 0x07, 0xd9, 0xf6},
     {0x30, 0x82, 0x01, 0x85, 0x30, 0x82, 0x01, 0x1d, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x30, 0x82, 0x01, 0x10, 0x02, 0x01, 0x01,
      0x30, 0x3c, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x30, 0x64, 0x04, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x30, 0xb3, 0x31, 0x2f, 0xa7,
      0xe2, 0x3e, 0xe7, 0xe4, 0x98, 0x8e, 0x05, 0x6b, 0xe3, 0xf8, 0x2d, 0x19,
      0x18, 0x1d, 0x9c, 0x6e, 0xfe, 0x81, 0x41, 0x12, 0x03, 0x14, 0x08, 0x8f,
      0x50, 0x13, 0x87, 0x5a, 0xc6, 0x56, 0x39, 0x8d, 0x8a, 0x2e, 0xd1, 0x9d,
      0x2a, 0x85, 0xc8, 0xed, 0xd3, 0xec, 0x2a, 0xef, 0x04, 0x61, 0x04, 0xaa,
      0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05, 0x37, 0x8e, 0xb1, 0xc7, 0x1e, 0xf3,
      0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b, 0x62, 0x8b, 0xa7, 0x9b, 0x98, 0x59,
      0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a, 0x38, 0x55, 0x02, 0xf2, 0x5d, 0xbf,
      0x55, 0x29, 0x6c, 0x3a, 0x54, 0x5e, 0x38, 0x72, 0x76, 0x0a, 0xb7, 0x36,
      0x17, 0xde, 0x4a, 0x96, 0x26, 0x2c, 0x6f, 0x5d, 0x9e, 0x98, 0xbf, 0x92,
      0x92, 0xdc, 0x29, 0xf8, 0xf4, 0x1d, 0xbd, 0x28, 0x9a, 0x14, 0x7c, 0xe9,
      0xda, 0x31, 0x13, 0xb5, 0xf0, 0xb8, 0xc0, 0x0a, 0x60, 0xb1, 0xce, 0x1d,
      0x7e, 0x81, 0x9d, 0x7a, 0x43, 0x1d, 0x7c, 0x90, 0xea, 0x0e, 0x5f, 0x02,
      0x01, 0x01, 0x02, 0x01, 0x01, 0x03, 0x62, 0x00, 0x04, 0x21, 0x21, 0xa3,
      0x48, 0xf9, 0x74, 0x38, 0x55, 0x85, 0x9c, 0x49, 0x6f, 0x91, 0xd0, 0xf3,
      0x9f, 0xe7, 0x28, 0xfc, 0x46, 0xe4, 0x8d, 0x00, 0x77, 0x13, 0x05, 0x1b,
      0x22, 0xf1, 0xc0, 0x25, 0x7f, 0xe2, 0x0d, 0xd8, 0x5b, 0x21, 0xdf, 0x7e,
      0x1e, 0xc8, 0x2b, 0xf8, 0xb3, 0x9b, 0x21, 0x38, 0xa2, 0xae, 0x74, 0xf8,
      0x0e, 0x62, 0x57, 0x77, 0x8f, 0x8c, 0xca, 0x9f, 0x27, 0x9b, 0x57, 0xd2,
      0x5e, 0xee, 0xb1, 0x55, 0x96, 0x06, 0x42, 0x97, 0x2f, 0x05, 0x67, 0xe2,
      0x04, 0x51, 0x4f, 0x0a, 0xc1, 0xeb, 0x1e, 0x27, 0xdb, 0x51, 0x15, 0x05,
      0x32, 0x11, 0x91, 0x49, 0x61, 0xd0, 0x96, 0x44, 0xc6},
     {0x45, 0x5c, 0xf3, 0xc0, 0xb0, 0x09, 0x06, 0x88, 0x59, 0x98, 0x25, 0x52,
      0x2e, 0xf3, 0x31, 0x28, 0x78, 0x20, 0x15, 0x14, 0xf6, 0x33, 0x0c, 0xcc,
      0x7f, 0x42, 0xec, 0x19, 0x45, 0x20, 0x4a, 0xdf, 0xe4, 0x19, 0xb2, 0xdb,
      0xbf, 0xb9, 0x42, 0xdc, 0x98, 0xb1, 0x6d, 0x83, 0x23, 0x15, 0x0c, 0xf6},
     false,
     false},

    // Comment: order =
    // 9173994463960286046443283581208347763186259956673124494950032159599396260248791326163093631191247821216106
    // tcID: 187
    {187,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xde,
      0x44, 0xe6, 0x3f, 0xd9, 0x24, 0xf1, 0x77, 0x34, 0x0d, 0x78, 0x0a, 0xf6,
      0xaa, 0xae, 0xa2, 0x71, 0xf5, 0x2d, 0x2c, 0xb9, 0xa5, 0xc5, 0x19, 0xb6,
      0x02, 0x0e, 0x06, 0xc3, 0xcf, 0x0b, 0xaa, 0xfb, 0xc0, 0xb8, 0x01, 0xc6,
      0x50, 0x8c, 0x2e, 0x14, 0x83, 0xb1, 0x5c, 0xfe, 0xf7, 0xaf, 0xc2, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x65, 0xce, 0x6b, 0x9d, 0x7e, 0x71, 0xe9,
      0x31, 0xb6, 0xfd, 0x1f, 0xac, 0x91, 0x05, 0x07, 0xb4, 0x37, 0x7a, 0xc1,
      0x5e, 0x45, 0x32, 0x92, 0xa2, 0x35, 0x5d, 0xf3, 0x9a, 0xb7, 0x41, 0xca,
      0x36, 0x29, 0x7b, 0xf6, 0xde, 0x3c, 0x34, 0xa5, 0xaf, 0xbb, 0xad, 0x37,
      0x18, 0x06, 0xb8, 0x91, 0xf2, 0x4b, 0x08, 0x8b, 0xc5, 0xd1, 0x46, 0x46,
      0xa7, 0x4f, 0x3e, 0xfc, 0xfe, 0xa3, 0x9e, 0x12, 0xe2, 0xb5, 0xf5, 0x6e,
      0xbb, 0xdd, 0x50, 0x3d, 0x5e, 0x8f, 0xee, 0x3f, 0xc3, 0x00, 0xd7, 0x50,
      0x9b, 0xaa, 0x22, 0xb6, 0x68, 0xdb, 0xf1, 0xfd, 0x24, 0x18, 0x07, 0x0a,
      0xb4, 0x0a, 0x07, 0xd9, 0xf6},
     {0x30, 0x82, 0x01, 0xb1, 0x30, 0x82, 0x01, 0x49, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x30, 0x82, 0x01, 0x3c, 0x02, 0x01, 0x01,
      0x30, 0x3c, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x30, 0x64, 0x04, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x30, 0xb3, 0x31, 0x2f, 0xa7,
      0xe2, 0x3e, 0xe7, 0xe4, 0x98, 0x8e, 0x05, 0x6b, 0xe3, 0xf8, 0x2d, 0x19,
      0x18, 0x1d, 0x9c, 0x6e, 0xfe, 0x81, 0x41, 0x12, 0x03, 0x14, 0x08, 0x8f,
      0x50, 0x13, 0x87, 0x5a, 0xc6, 0x56, 0x39, 0x8d, 0x8a, 0x2e, 0xd1, 0x9d,
      0x2a, 0x85, 0xc8, 0xed, 0xd3, 0xec, 0x2a, 0xef, 0x04, 0x61, 0x04, 0xaa,
      0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05, 0x37, 0x8e, 0xb1, 0xc7, 0x1e, 0xf3,
      0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b, 0x62, 0x8b, 0xa7, 0x9b, 0x98, 0x59,
      0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a, 0x38, 0x55, 0x02, 0xf2, 0x5d, 0xbf,
      0x55, 0x29, 0x6c, 0x3a, 0x54, 0x5e, 0x38, 0x72, 0x76, 0x0a, 0xb7, 0x36,
      0x17, 0xde, 0x4a, 0x96, 0x26, 0x2c, 0x6f, 0x5d, 0x9e, 0x98, 0xbf, 0x92,
      0x92, 0xdc, 0x29, 0xf8, 0xf4, 0x1d, 0xbd, 0x28, 0x9a, 0x14, 0x7c, 0xe9,
      0xda, 0x31, 0x13, 0xb5, 0xf0, 0xb8, 0xc0, 0x0a, 0x60, 0xb1, 0xce, 0x1d,
      0x7e, 0x81, 0x9d, 0x7a, 0x43, 0x1d, 0x7c, 0x90, 0xea, 0x0e, 0x5f, 0x02,
      0x2d, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a,
      0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19, 0x6a, 0x02, 0x01,
      0x01, 0x03, 0x62, 0x00, 0x04, 0x21, 0x21, 0xa3, 0x48, 0xf9, 0x74, 0x38,
      0x55, 0x85, 0x9c, 0x49, 0x6f, 0x91, 0xd0, 0xf3, 0x9f, 0xe7, 0x28, 0xfc,
      0x46, 0xe4, 0x8d, 0x00, 0x77, 0x13, 0x05, 0x1b, 0x22, 0xf1, 0xc0, 0x25,
      0x7f, 0xe2, 0x0d, 0xd8, 0x5b, 0x21, 0xdf, 0x7e, 0x1e, 0xc8, 0x2b, 0xf8,
      0xb3, 0x9b, 0x21, 0x38, 0xa2, 0xae, 0x74, 0xf8, 0x0e, 0x62, 0x57, 0x77,
      0x8f, 0x8c, 0xca, 0x9f, 0x27, 0x9b, 0x57, 0xd2, 0x5e, 0xee, 0xb1, 0x55,
      0x96, 0x06, 0x42, 0x97, 0x2f, 0x05, 0x67, 0xe2, 0x04, 0x51, 0x4f, 0x0a,
      0xc1, 0xeb, 0x1e, 0x27, 0xdb, 0x51, 0x15, 0x05, 0x32, 0x11, 0x91, 0x49,
      0x61, 0xd0, 0x96, 0x44, 0xc6},
     {0x45, 0x5c, 0xf3, 0xc0, 0xb0, 0x09, 0x06, 0x88, 0x59, 0x98, 0x25, 0x52,
      0x2e, 0xf3, 0x31, 0x28, 0x78, 0x20, 0x15, 0x14, 0xf6, 0x33, 0x0c, 0xcc,
      0x7f, 0x42, 0xec, 0x19, 0x45, 0x20, 0x4a, 0xdf, 0xe4, 0x19, 0xb2, 0xdb,
      0xbf, 0xb9, 0x42, 0xdc, 0x98, 0xb1, 0x6d, 0x83, 0x23, 0x15, 0x0c, 0xf6},
     false,
     false},

    // Comment: generator = (0,0)
    // tcID: 188
    {188,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xde,
      0x44, 0xe6, 0x3f, 0xd9, 0x24, 0xf1, 0x77, 0x34, 0x0d, 0x78, 0x0a, 0xf6,
      0xaa, 0xae, 0xa2, 0x71, 0xf5, 0x2d, 0x2c, 0xb9, 0xa5, 0xc5, 0x19, 0xb6,
      0x02, 0x0e, 0x06, 0xc3, 0xcf, 0x0b, 0xaa, 0xfb, 0xc0, 0xb8, 0x01, 0xc6,
      0x50, 0x8c, 0x2e, 0x14, 0x83, 0xb1, 0x5c, 0xfe, 0xf7, 0xaf, 0xc2, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x65, 0xce, 0x6b, 0x9d, 0x7e, 0x71, 0xe9,
      0x31, 0xb6, 0xfd, 0x1f, 0xac, 0x91, 0x05, 0x07, 0xb4, 0x37, 0x7a, 0xc1,
      0x5e, 0x45, 0x32, 0x92, 0xa2, 0x35, 0x5d, 0xf3, 0x9a, 0xb7, 0x41, 0xca,
      0x36, 0x29, 0x7b, 0xf6, 0xde, 0x3c, 0x34, 0xa5, 0xaf, 0xbb, 0xad, 0x37,
      0x18, 0x06, 0xb8, 0x91, 0xf2, 0x4b, 0x08, 0x8b, 0xc5, 0xd1, 0x46, 0x46,
      0xa7, 0x4f, 0x3e, 0xfc, 0xfe, 0xa3, 0x9e, 0x12, 0xe2, 0xb5, 0xf5, 0x6e,
      0xbb, 0xdd, 0x50, 0x3d, 0x5e, 0x8f, 0xee, 0x3f, 0xc3, 0x00, 0xd7, 0x50,
      0x9b, 0xaa, 0x22, 0xb6, 0x68, 0xdb, 0xf1, 0xfd, 0x24, 0x18, 0x07, 0x0a,
      0xb4, 0x0a, 0x07, 0xd9, 0xf6},
     {0x30, 0x82, 0x01, 0xb5, 0x30, 0x82, 0x01, 0x4d, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x30, 0x82, 0x01, 0x40, 0x02, 0x01, 0x01,
      0x30, 0x3c, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x30, 0x64, 0x04, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x30, 0xb3, 0x31, 0x2f, 0xa7,
      0xe2, 0x3e, 0xe7, 0xe4, 0x98, 0x8e, 0x05, 0x6b, 0xe3, 0xf8, 0x2d, 0x19,
      0x18, 0x1d, 0x9c, 0x6e, 0xfe, 0x81, 0x41, 0x12, 0x03, 0x14, 0x08, 0x8f,
      0x50, 0x13, 0x87, 0x5a, 0xc6, 0x56, 0x39, 0x8d, 0x8a, 0x2e, 0xd1, 0x9d,
      0x2a, 0x85, 0xc8, 0xed, 0xd3, 0xec, 0x2a, 0xef, 0x04, 0x61, 0x04, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a,
      0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5,
      0x29, 0x73, 0x02, 0x01, 0x01, 0x03, 0x62, 0x00, 0x04, 0x21, 0x21, 0xa3,
      0x48, 0xf9, 0x74, 0x38, 0x55, 0x85, 0x9c, 0x49, 0x6f, 0x91, 0xd0, 0xf3,
      0x9f, 0xe7, 0x28, 0xfc, 0x46, 0xe4, 0x8d, 0x00, 0x77, 0x13, 0x05, 0x1b,
      0x22, 0xf1, 0xc0, 0x25, 0x7f, 0xe2, 0x0d, 0xd8, 0x5b, 0x21, 0xdf, 0x7e,
      0x1e, 0xc8, 0x2b, 0xf8, 0xb3, 0x9b, 0x21, 0x38, 0xa2, 0xae, 0x74, 0xf8,
      0x0e, 0x62, 0x57, 0x77, 0x8f, 0x8c, 0xca, 0x9f, 0x27, 0x9b, 0x57, 0xd2,
      0x5e, 0xee, 0xb1, 0x55, 0x96, 0x06, 0x42, 0x97, 0x2f, 0x05, 0x67, 0xe2,
      0x04, 0x51, 0x4f, 0x0a, 0xc1, 0xeb, 0x1e, 0x27, 0xdb, 0x51, 0x15, 0x05,
      0x32, 0x11, 0x91, 0x49, 0x61, 0xd0, 0x96, 0x44, 0xc6},
     {0x45, 0x5c, 0xf3, 0xc0, 0xb0, 0x09, 0x06, 0x88, 0x59, 0x98, 0x25, 0x52,
      0x2e, 0xf3, 0x31, 0x28, 0x78, 0x20, 0x15, 0x14, 0xf6, 0x33, 0x0c, 0xcc,
      0x7f, 0x42, 0xec, 0x19, 0x45, 0x20, 0x4a, 0xdf, 0xe4, 0x19, 0xb2, 0xdb,
      0xbf, 0xb9, 0x42, 0xdc, 0x98, 0xb1, 0x6d, 0x83, 0x23, 0x15, 0x0c, 0xf6},
     false,
     false},

    // Comment: generator not on curve
    // tcID: 189
    {189,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xde,
      0x44, 0xe6, 0x3f, 0xd9, 0x24, 0xf1, 0x77, 0x34, 0x0d, 0x78, 0x0a, 0xf6,
      0xaa, 0xae, 0xa2, 0x71, 0xf5, 0x2d, 0x2c, 0xb9, 0xa5, 0xc5, 0x19, 0xb6,
      0x02, 0x0e, 0x06, 0xc3, 0xcf, 0x0b, 0xaa, 0xfb, 0xc0, 0xb8, 0x01, 0xc6,
      0x50, 0x8c, 0x2e, 0x14, 0x83, 0xb1, 0x5c, 0xfe, 0xf7, 0xaf, 0xc2, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x65, 0xce, 0x6b, 0x9d, 0x7e, 0x71, 0xe9,
      0x31, 0xb6, 0xfd, 0x1f, 0xac, 0x91, 0x05, 0x07, 0xb4, 0x37, 0x7a, 0xc1,
      0x5e, 0x45, 0x32, 0x92, 0xa2, 0x35, 0x5d, 0xf3, 0x9a, 0xb7, 0x41, 0xca,
      0x36, 0x29, 0x7b, 0xf6, 0xde, 0x3c, 0x34, 0xa5, 0xaf, 0xbb, 0xad, 0x37,
      0x18, 0x06, 0xb8, 0x91, 0xf2, 0x4b, 0x08, 0x8b, 0xc5, 0xd1, 0x46, 0x46,
      0xa7, 0x4f, 0x3e, 0xfc, 0xfe, 0xa3, 0x9e, 0x12, 0xe2, 0xb5, 0xf5, 0x6e,
      0xbb, 0xdd, 0x50, 0x3d, 0x5e, 0x8f, 0xee, 0x3f, 0xc3, 0x00, 0xd7, 0x50,
      0x9b, 0xaa, 0x22, 0xb6, 0x68, 0xdb, 0xf1, 0xfd, 0x24, 0x18, 0x07, 0x0a,
      0xb4, 0x0a, 0x07, 0xd9, 0xf6},
     {0x30, 0x82, 0x01, 0xb5, 0x30, 0x82, 0x01, 0x4d, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x30, 0x82, 0x01, 0x40, 0x02, 0x01, 0x01,
      0x30, 0x3c, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x30, 0x64, 0x04, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x30, 0xb3, 0x31, 0x2f, 0xa7,
      0xe2, 0x3e, 0xe7, 0xe4, 0x98, 0x8e, 0x05, 0x6b, 0xe3, 0xf8, 0x2d, 0x19,
      0x18, 0x1d, 0x9c, 0x6e, 0xfe, 0x81, 0x41, 0x12, 0x03, 0x14, 0x08, 0x8f,
      0x50, 0x13, 0x87, 0x5a, 0xc6, 0x56, 0x39, 0x8d, 0x8a, 0x2e, 0xd1, 0x9d,
      0x2a, 0x85, 0xc8, 0xed, 0xd3, 0xec, 0x2a, 0xef, 0x04, 0x61, 0x04, 0xaa,
      0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05, 0x37, 0x8e, 0xb1, 0xc7, 0x1e, 0xf3,
      0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b, 0x62, 0x8b, 0xa7, 0x9b, 0x98, 0x59,
      0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a, 0x38, 0x55, 0x02, 0xf2, 0x5d, 0xbf,
      0x55, 0x29, 0x6c, 0x3a, 0x54, 0x5e, 0x38, 0x72, 0x76, 0x0a, 0xb7, 0x36,
      0x17, 0xde, 0x4a, 0x96, 0x26, 0x2c, 0x6f, 0x5d, 0x9e, 0x98, 0xbf, 0x92,
      0x92, 0xdc, 0x29, 0xf8, 0xf4, 0x1d, 0xbd, 0x28, 0x9a, 0x14, 0x7c, 0xe9,
      0xda, 0x31, 0x13, 0xb5, 0xf0, 0xb8, 0xc0, 0x0a, 0x60, 0xb1, 0xce, 0x1d,
      0x7e, 0x81, 0x9d, 0x7a, 0x43, 0x1d, 0x7c, 0x90, 0xea, 0x0e, 0x61, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a,
      0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5,
      0x29, 0x73, 0x02, 0x01, 0x01, 0x03, 0x62, 0x00, 0x04, 0x21, 0x21, 0xa3,
      0x48, 0xf9, 0x74, 0x38, 0x55, 0x85, 0x9c, 0x49, 0x6f, 0x91, 0xd0, 0xf3,
      0x9f, 0xe7, 0x28, 0xfc, 0x46, 0xe4, 0x8d, 0x00, 0x77, 0x13, 0x05, 0x1b,
      0x22, 0xf1, 0xc0, 0x25, 0x7f, 0xe2, 0x0d, 0xd8, 0x5b, 0x21, 0xdf, 0x7e,
      0x1e, 0xc8, 0x2b, 0xf8, 0xb3, 0x9b, 0x21, 0x38, 0xa2, 0xae, 0x74, 0xf8,
      0x0e, 0x62, 0x57, 0x77, 0x8f, 0x8c, 0xca, 0x9f, 0x27, 0x9b, 0x57, 0xd2,
      0x5e, 0xee, 0xb1, 0x55, 0x96, 0x06, 0x42, 0x97, 0x2f, 0x05, 0x67, 0xe2,
      0x04, 0x51, 0x4f, 0x0a, 0xc1, 0xeb, 0x1e, 0x27, 0xdb, 0x51, 0x15, 0x05,
      0x32, 0x11, 0x91, 0x49, 0x61, 0xd0, 0x96, 0x44, 0xc6},
     {0x45, 0x5c, 0xf3, 0xc0, 0xb0, 0x09, 0x06, 0x88, 0x59, 0x98, 0x25, 0x52,
      0x2e, 0xf3, 0x31, 0x28, 0x78, 0x20, 0x15, 0x14, 0xf6, 0x33, 0x0c, 0xcc,
      0x7f, 0x42, 0xec, 0x19, 0x45, 0x20, 0x4a, 0xdf, 0xe4, 0x19, 0xb2, 0xdb,
      0xbf, 0xb9, 0x42, 0xdc, 0x98, 0xb1, 0x6d, 0x83, 0x23, 0x15, 0x0c, 0xf6},
     false,
     false},

    // Comment: cofactor = -1
    // tcID: 190
    {190,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xde,
      0x44, 0xe6, 0x3f, 0xd9, 0x24, 0xf1, 0x77, 0x34, 0x0d, 0x78, 0x0a, 0xf6,
      0xaa, 0xae, 0xa2, 0x71, 0xf5, 0x2d, 0x2c, 0xb9, 0xa5, 0xc5, 0x19, 0xb6,
      0x02, 0x0e, 0x06, 0xc3, 0xcf, 0x0b, 0xaa, 0xfb, 0xc0, 0xb8, 0x01, 0xc6,
      0x50, 0x8c, 0x2e, 0x14, 0x83, 0xb1, 0x5c, 0xfe, 0xf7, 0xaf, 0xc2, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x65, 0xce, 0x6b, 0x9d, 0x7e, 0x71, 0xe9,
      0x31, 0xb6, 0xfd, 0x1f, 0xac, 0x91, 0x05, 0x07, 0xb4, 0x37, 0x7a, 0xc1,
      0x5e, 0x45, 0x32, 0x92, 0xa2, 0x35, 0x5d, 0xf3, 0x9a, 0xb7, 0x41, 0xca,
      0x36, 0x29, 0x7b, 0xf6, 0xde, 0x3c, 0x34, 0xa5, 0xaf, 0xbb, 0xad, 0x37,
      0x18, 0x06, 0xb8, 0x91, 0xf2, 0x4b, 0x08, 0x8b, 0xc5, 0xd1, 0x46, 0x46,
      0xa7, 0x4f, 0x3e, 0xfc, 0xfe, 0xa3, 0x9e, 0x12, 0xe2, 0xb5, 0xf5, 0x6e,
      0xbb, 0xdd, 0x50, 0x3d, 0x5e, 0x8f, 0xee, 0x3f, 0xc3, 0x00, 0xd7, 0x50,
      0x9b, 0xaa, 0x22, 0xb6, 0x68, 0xdb, 0xf1, 0xfd, 0x24, 0x18, 0x07, 0x0a,
      0xb4, 0x0a, 0x07, 0xd9, 0xf6},
     {0x30, 0x82, 0x01, 0xb5, 0x30, 0x82, 0x01, 0x4d, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x30, 0x82, 0x01, 0x40, 0x02, 0x01, 0x01,
      0x30, 0x3c, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x30, 0x64, 0x04, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x30, 0xb3, 0x31, 0x2f, 0xa7,
      0xe2, 0x3e, 0xe7, 0xe4, 0x98, 0x8e, 0x05, 0x6b, 0xe3, 0xf8, 0x2d, 0x19,
      0x18, 0x1d, 0x9c, 0x6e, 0xfe, 0x81, 0x41, 0x12, 0x03, 0x14, 0x08, 0x8f,
      0x50, 0x13, 0x87, 0x5a, 0xc6, 0x56, 0x39, 0x8d, 0x8a, 0x2e, 0xd1, 0x9d,
      0x2a, 0x85, 0xc8, 0xed, 0xd3, 0xec, 0x2a, 0xef, 0x04, 0x61, 0x04, 0xaa,
      0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05, 0x37, 0x8e, 0xb1, 0xc7, 0x1e, 0xf3,
      0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b, 0x62, 0x8b, 0xa7, 0x9b, 0x98, 0x59,
      0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a, 0x38, 0x55, 0x02, 0xf2, 0x5d, 0xbf,
      0x55, 0x29, 0x6c, 0x3a, 0x54, 0x5e, 0x38, 0x72, 0x76, 0x0a, 0xb7, 0x36,
      0x17, 0xde, 0x4a, 0x96, 0x26, 0x2c, 0x6f, 0x5d, 0x9e, 0x98, 0xbf, 0x92,
      0x92, 0xdc, 0x29, 0xf8, 0xf4, 0x1d, 0xbd, 0x28, 0x9a, 0x14, 0x7c, 0xe9,
      0xda, 0x31, 0x13, 0xb5, 0xf0, 0xb8, 0xc0, 0x0a, 0x60, 0xb1, 0xce, 0x1d,
      0x7e, 0x81, 0x9d, 0x7a, 0x43, 0x1d, 0x7c, 0x90, 0xea, 0x0e, 0x5f, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a,
      0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5,
      0x29, 0x73, 0x02, 0x01, 0xff, 0x03, 0x62, 0x00, 0x04, 0x21, 0x21, 0xa3,
      0x48, 0xf9, 0x74, 0x38, 0x55, 0x85, 0x9c, 0x49, 0x6f, 0x91, 0xd0, 0xf3,
      0x9f, 0xe7, 0x28, 0xfc, 0x46, 0xe4, 0x8d, 0x00, 0x77, 0x13, 0x05, 0x1b,
      0x22, 0xf1, 0xc0, 0x25, 0x7f, 0xe2, 0x0d, 0xd8, 0x5b, 0x21, 0xdf, 0x7e,
      0x1e, 0xc8, 0x2b, 0xf8, 0xb3, 0x9b, 0x21, 0x38, 0xa2, 0xae, 0x74, 0xf8,
      0x0e, 0x62, 0x57, 0x77, 0x8f, 0x8c, 0xca, 0x9f, 0x27, 0x9b, 0x57, 0xd2,
      0x5e, 0xee, 0xb1, 0x55, 0x96, 0x06, 0x42, 0x97, 0x2f, 0x05, 0x67, 0xe2,
      0x04, 0x51, 0x4f, 0x0a, 0xc1, 0xeb, 0x1e, 0x27, 0xdb, 0x51, 0x15, 0x05,
      0x32, 0x11, 0x91, 0x49, 0x61, 0xd0, 0x96, 0x44, 0xc6},
     {0x45, 0x5c, 0xf3, 0xc0, 0xb0, 0x09, 0x06, 0x88, 0x59, 0x98, 0x25, 0x52,
      0x2e, 0xf3, 0x31, 0x28, 0x78, 0x20, 0x15, 0x14, 0xf6, 0x33, 0x0c, 0xcc,
      0x7f, 0x42, 0xec, 0x19, 0x45, 0x20, 0x4a, 0xdf, 0xe4, 0x19, 0xb2, 0xdb,
      0xbf, 0xb9, 0x42, 0xdc, 0x98, 0xb1, 0x6d, 0x83, 0x23, 0x15, 0x0c, 0xf6},
     false,
     false},

    // Comment: cofactor = 0
    // tcID: 191
    {191,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xde,
      0x44, 0xe6, 0x3f, 0xd9, 0x24, 0xf1, 0x77, 0x34, 0x0d, 0x78, 0x0a, 0xf6,
      0xaa, 0xae, 0xa2, 0x71, 0xf5, 0x2d, 0x2c, 0xb9, 0xa5, 0xc5, 0x19, 0xb6,
      0x02, 0x0e, 0x06, 0xc3, 0xcf, 0x0b, 0xaa, 0xfb, 0xc0, 0xb8, 0x01, 0xc6,
      0x50, 0x8c, 0x2e, 0x14, 0x83, 0xb1, 0x5c, 0xfe, 0xf7, 0xaf, 0xc2, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x65, 0xce, 0x6b, 0x9d, 0x7e, 0x71, 0xe9,
      0x31, 0xb6, 0xfd, 0x1f, 0xac, 0x91, 0x05, 0x07, 0xb4, 0x37, 0x7a, 0xc1,
      0x5e, 0x45, 0x32, 0x92, 0xa2, 0x35, 0x5d, 0xf3, 0x9a, 0xb7, 0x41, 0xca,
      0x36, 0x29, 0x7b, 0xf6, 0xde, 0x3c, 0x34, 0xa5, 0xaf, 0xbb, 0xad, 0x37,
      0x18, 0x06, 0xb8, 0x91, 0xf2, 0x4b, 0x08, 0x8b, 0xc5, 0xd1, 0x46, 0x46,
      0xa7, 0x4f, 0x3e, 0xfc, 0xfe, 0xa3, 0x9e, 0x12, 0xe2, 0xb5, 0xf5, 0x6e,
      0xbb, 0xdd, 0x50, 0x3d, 0x5e, 0x8f, 0xee, 0x3f, 0xc3, 0x00, 0xd7, 0x50,
      0x9b, 0xaa, 0x22, 0xb6, 0x68, 0xdb, 0xf1, 0xfd, 0x24, 0x18, 0x07, 0x0a,
      0xb4, 0x0a, 0x07, 0xd9, 0xf6},
     {0x30, 0x82, 0x01, 0xb5, 0x30, 0x82, 0x01, 0x4d, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x30, 0x82, 0x01, 0x40, 0x02, 0x01, 0x01,
      0x30, 0x3c, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x30, 0x64, 0x04, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x30, 0xb3, 0x31, 0x2f, 0xa7,
      0xe2, 0x3e, 0xe7, 0xe4, 0x98, 0x8e, 0x05, 0x6b, 0xe3, 0xf8, 0x2d, 0x19,
      0x18, 0x1d, 0x9c, 0x6e, 0xfe, 0x81, 0x41, 0x12, 0x03, 0x14, 0x08, 0x8f,
      0x50, 0x13, 0x87, 0x5a, 0xc6, 0x56, 0x39, 0x8d, 0x8a, 0x2e, 0xd1, 0x9d,
      0x2a, 0x85, 0xc8, 0xed, 0xd3, 0xec, 0x2a, 0xef, 0x04, 0x61, 0x04, 0xaa,
      0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05, 0x37, 0x8e, 0xb1, 0xc7, 0x1e, 0xf3,
      0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b, 0x62, 0x8b, 0xa7, 0x9b, 0x98, 0x59,
      0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a, 0x38, 0x55, 0x02, 0xf2, 0x5d, 0xbf,
      0x55, 0x29, 0x6c, 0x3a, 0x54, 0x5e, 0x38, 0x72, 0x76, 0x0a, 0xb7, 0x36,
      0x17, 0xde, 0x4a, 0x96, 0x26, 0x2c, 0x6f, 0x5d, 0x9e, 0x98, 0xbf, 0x92,
      0x92, 0xdc, 0x29, 0xf8, 0xf4, 0x1d, 0xbd, 0x28, 0x9a, 0x14, 0x7c, 0xe9,
      0xda, 0x31, 0x13, 0xb5, 0xf0, 0xb8, 0xc0, 0x0a, 0x60, 0xb1, 0xce, 0x1d,
      0x7e, 0x81, 0x9d, 0x7a, 0x43, 0x1d, 0x7c, 0x90, 0xea, 0x0e, 0x5f, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a,
      0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5,
      0x29, 0x73, 0x02, 0x01, 0x00, 0x03, 0x62, 0x00, 0x04, 0x21, 0x21, 0xa3,
      0x48, 0xf9, 0x74, 0x38, 0x55, 0x85, 0x9c, 0x49, 0x6f, 0x91, 0xd0, 0xf3,
      0x9f, 0xe7, 0x28, 0xfc, 0x46, 0xe4, 0x8d, 0x00, 0x77, 0x13, 0x05, 0x1b,
      0x22, 0xf1, 0xc0, 0x25, 0x7f, 0xe2, 0x0d, 0xd8, 0x5b, 0x21, 0xdf, 0x7e,
      0x1e, 0xc8, 0x2b, 0xf8, 0xb3, 0x9b, 0x21, 0x38, 0xa2, 0xae, 0x74, 0xf8,
      0x0e, 0x62, 0x57, 0x77, 0x8f, 0x8c, 0xca, 0x9f, 0x27, 0x9b, 0x57, 0xd2,
      0x5e, 0xee, 0xb1, 0x55, 0x96, 0x06, 0x42, 0x97, 0x2f, 0x05, 0x67, 0xe2,
      0x04, 0x51, 0x4f, 0x0a, 0xc1, 0xeb, 0x1e, 0x27, 0xdb, 0x51, 0x15, 0x05,
      0x32, 0x11, 0x91, 0x49, 0x61, 0xd0, 0x96, 0x44, 0xc6},
     {0x45, 0x5c, 0xf3, 0xc0, 0xb0, 0x09, 0x06, 0x88, 0x59, 0x98, 0x25, 0x52,
      0x2e, 0xf3, 0x31, 0x28, 0x78, 0x20, 0x15, 0x14, 0xf6, 0x33, 0x0c, 0xcc,
      0x7f, 0x42, 0xec, 0x19, 0x45, 0x20, 0x4a, 0xdf, 0xe4, 0x19, 0xb2, 0xdb,
      0xbf, 0xb9, 0x42, 0xdc, 0x98, 0xb1, 0x6d, 0x83, 0x23, 0x15, 0x0c, 0xf6},
     false,
     false},

    // Comment: cofactor = 2
    // tcID: 192
    {192,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xde,
      0x44, 0xe6, 0x3f, 0xd9, 0x24, 0xf1, 0x77, 0x34, 0x0d, 0x78, 0x0a, 0xf6,
      0xaa, 0xae, 0xa2, 0x71, 0xf5, 0x2d, 0x2c, 0xb9, 0xa5, 0xc5, 0x19, 0xb6,
      0x02, 0x0e, 0x06, 0xc3, 0xcf, 0x0b, 0xaa, 0xfb, 0xc0, 0xb8, 0x01, 0xc6,
      0x50, 0x8c, 0x2e, 0x14, 0x83, 0xb1, 0x5c, 0xfe, 0xf7, 0xaf, 0xc2, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x65, 0xce, 0x6b, 0x9d, 0x7e, 0x71, 0xe9,
      0x31, 0xb6, 0xfd, 0x1f, 0xac, 0x91, 0x05, 0x07, 0xb4, 0x37, 0x7a, 0xc1,
      0x5e, 0x45, 0x32, 0x92, 0xa2, 0x35, 0x5d, 0xf3, 0x9a, 0xb7, 0x41, 0xca,
      0x36, 0x29, 0x7b, 0xf6, 0xde, 0x3c, 0x34, 0xa5, 0xaf, 0xbb, 0xad, 0x37,
      0x18, 0x06, 0xb8, 0x91, 0xf2, 0x4b, 0x08, 0x8b, 0xc5, 0xd1, 0x46, 0x46,
      0xa7, 0x4f, 0x3e, 0xfc, 0xfe, 0xa3, 0x9e, 0x12, 0xe2, 0xb5, 0xf5, 0x6e,
      0xbb, 0xdd, 0x50, 0x3d, 0x5e, 0x8f, 0xee, 0x3f, 0xc3, 0x00, 0xd7, 0x50,
      0x9b, 0xaa, 0x22, 0xb6, 0x68, 0xdb, 0xf1, 0xfd, 0x24, 0x18, 0x07, 0x0a,
      0xb4, 0x0a, 0x07, 0xd9, 0xf6},
     {0x30, 0x82, 0x01, 0xb5, 0x30, 0x82, 0x01, 0x4d, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x30, 0x82, 0x01, 0x40, 0x02, 0x01, 0x01,
      0x30, 0x3c, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x30, 0x64, 0x04, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x30, 0xb3, 0x31, 0x2f, 0xa7,
      0xe2, 0x3e, 0xe7, 0xe4, 0x98, 0x8e, 0x05, 0x6b, 0xe3, 0xf8, 0x2d, 0x19,
      0x18, 0x1d, 0x9c, 0x6e, 0xfe, 0x81, 0x41, 0x12, 0x03, 0x14, 0x08, 0x8f,
      0x50, 0x13, 0x87, 0x5a, 0xc6, 0x56, 0x39, 0x8d, 0x8a, 0x2e, 0xd1, 0x9d,
      0x2a, 0x85, 0xc8, 0xed, 0xd3, 0xec, 0x2a, 0xef, 0x04, 0x61, 0x04, 0xaa,
      0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05, 0x37, 0x8e, 0xb1, 0xc7, 0x1e, 0xf3,
      0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b, 0x62, 0x8b, 0xa7, 0x9b, 0x98, 0x59,
      0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a, 0x38, 0x55, 0x02, 0xf2, 0x5d, 0xbf,
      0x55, 0x29, 0x6c, 0x3a, 0x54, 0x5e, 0x38, 0x72, 0x76, 0x0a, 0xb7, 0x36,
      0x17, 0xde, 0x4a, 0x96, 0x26, 0x2c, 0x6f, 0x5d, 0x9e, 0x98, 0xbf, 0x92,
      0x92, 0xdc, 0x29, 0xf8, 0xf4, 0x1d, 0xbd, 0x28, 0x9a, 0x14, 0x7c, 0xe9,
      0xda, 0x31, 0x13, 0xb5, 0xf0, 0xb8, 0xc0, 0x0a, 0x60, 0xb1, 0xce, 0x1d,
      0x7e, 0x81, 0x9d, 0x7a, 0x43, 0x1d, 0x7c, 0x90, 0xea, 0x0e, 0x5f, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a,
      0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5,
      0x29, 0x73, 0x02, 0x01, 0x02, 0x03, 0x62, 0x00, 0x04, 0x21, 0x21, 0xa3,
      0x48, 0xf9, 0x74, 0x38, 0x55, 0x85, 0x9c, 0x49, 0x6f, 0x91, 0xd0, 0xf3,
      0x9f, 0xe7, 0x28, 0xfc, 0x46, 0xe4, 0x8d, 0x00, 0x77, 0x13, 0x05, 0x1b,
      0x22, 0xf1, 0xc0, 0x25, 0x7f, 0xe2, 0x0d, 0xd8, 0x5b, 0x21, 0xdf, 0x7e,
      0x1e, 0xc8, 0x2b, 0xf8, 0xb3, 0x9b, 0x21, 0x38, 0xa2, 0xae, 0x74, 0xf8,
      0x0e, 0x62, 0x57, 0x77, 0x8f, 0x8c, 0xca, 0x9f, 0x27, 0x9b, 0x57, 0xd2,
      0x5e, 0xee, 0xb1, 0x55, 0x96, 0x06, 0x42, 0x97, 0x2f, 0x05, 0x67, 0xe2,
      0x04, 0x51, 0x4f, 0x0a, 0xc1, 0xeb, 0x1e, 0x27, 0xdb, 0x51, 0x15, 0x05,
      0x32, 0x11, 0x91, 0x49, 0x61, 0xd0, 0x96, 0x44, 0xc6},
     {0x45, 0x5c, 0xf3, 0xc0, 0xb0, 0x09, 0x06, 0x88, 0x59, 0x98, 0x25, 0x52,
      0x2e, 0xf3, 0x31, 0x28, 0x78, 0x20, 0x15, 0x14, 0xf6, 0x33, 0x0c, 0xcc,
      0x7f, 0x42, 0xec, 0x19, 0x45, 0x20, 0x4a, 0xdf, 0xe4, 0x19, 0xb2, 0xdb,
      0xbf, 0xb9, 0x42, 0xdc, 0x98, 0xb1, 0x6d, 0x83, 0x23, 0x15, 0x0c, 0xf6},
     false,
     false},

    // Comment: cofactor =
    // 39402006196394479212279040100143613805079739270465446667946905279627659399113263569398956308152294913554433653942643
    // tcID: 193
    {193,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xde,
      0x44, 0xe6, 0x3f, 0xd9, 0x24, 0xf1, 0x77, 0x34, 0x0d, 0x78, 0x0a, 0xf6,
      0xaa, 0xae, 0xa2, 0x71, 0xf5, 0x2d, 0x2c, 0xb9, 0xa5, 0xc5, 0x19, 0xb6,
      0x02, 0x0e, 0x06, 0xc3, 0xcf, 0x0b, 0xaa, 0xfb, 0xc0, 0xb8, 0x01, 0xc6,
      0x50, 0x8c, 0x2e, 0x14, 0x83, 0xb1, 0x5c, 0xfe, 0xf7, 0xaf, 0xc2, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x65, 0xce, 0x6b, 0x9d, 0x7e, 0x71, 0xe9,
      0x31, 0xb6, 0xfd, 0x1f, 0xac, 0x91, 0x05, 0x07, 0xb4, 0x37, 0x7a, 0xc1,
      0x5e, 0x45, 0x32, 0x92, 0xa2, 0x35, 0x5d, 0xf3, 0x9a, 0xb7, 0x41, 0xca,
      0x36, 0x29, 0x7b, 0xf6, 0xde, 0x3c, 0x34, 0xa5, 0xaf, 0xbb, 0xad, 0x37,
      0x18, 0x06, 0xb8, 0x91, 0xf2, 0x4b, 0x08, 0x8b, 0xc5, 0xd1, 0x46, 0x46,
      0xa7, 0x4f, 0x3e, 0xfc, 0xfe, 0xa3, 0x9e, 0x12, 0xe2, 0xb5, 0xf5, 0x6e,
      0xbb, 0xdd, 0x50, 0x3d, 0x5e, 0x8f, 0xee, 0x3f, 0xc3, 0x00, 0xd7, 0x50,
      0x9b, 0xaa, 0x22, 0xb6, 0x68, 0xdb, 0xf1, 0xfd, 0x24, 0x18, 0x07, 0x0a,
      0xb4, 0x0a, 0x07, 0xd9, 0xf6},
     {0x30, 0x82, 0x01, 0xe5, 0x30, 0x82, 0x01, 0x7d, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x30, 0x82, 0x01, 0x70, 0x02, 0x01, 0x01,
      0x30, 0x3c, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x30, 0x64, 0x04, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x30, 0xb3, 0x31, 0x2f, 0xa7,
      0xe2, 0x3e, 0xe7, 0xe4, 0x98, 0x8e, 0x05, 0x6b, 0xe3, 0xf8, 0x2d, 0x19,
      0x18, 0x1d, 0x9c, 0x6e, 0xfe, 0x81, 0x41, 0x12, 0x03, 0x14, 0x08, 0x8f,
      0x50, 0x13, 0x87, 0x5a, 0xc6, 0x56, 0x39, 0x8d, 0x8a, 0x2e, 0xd1, 0x9d,
      0x2a, 0x85, 0xc8, 0xed, 0xd3, 0xec, 0x2a, 0xef, 0x04, 0x61, 0x04, 0xaa,
      0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05, 0x37, 0x8e, 0xb1, 0xc7, 0x1e, 0xf3,
      0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b, 0x62, 0x8b, 0xa7, 0x9b, 0x98, 0x59,
      0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a, 0x38, 0x55, 0x02, 0xf2, 0x5d, 0xbf,
      0x55, 0x29, 0x6c, 0x3a, 0x54, 0x5e, 0x38, 0x72, 0x76, 0x0a, 0xb7, 0x36,
      0x17, 0xde, 0x4a, 0x96, 0x26, 0x2c, 0x6f, 0x5d, 0x9e, 0x98, 0xbf, 0x92,
      0x92, 0xdc, 0x29, 0xf8, 0xf4, 0x1d, 0xbd, 0x28, 0x9a, 0x14, 0x7c, 0xe9,
      0xda, 0x31, 0x13, 0xb5, 0xf0, 0xb8, 0xc0, 0x0a, 0x60, 0xb1, 0xce, 0x1d,
      0x7e, 0x81, 0x9d, 0x7a, 0x43, 0x1d, 0x7c, 0x90, 0xea, 0x0e, 0x5f, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a,
      0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5,
      0x29, 0x73, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x73, 0x03, 0x62, 0x00, 0x04, 0x21, 0x21, 0xa3,
      0x48, 0xf9, 0x74, 0x38, 0x55, 0x85, 0x9c, 0x49, 0x6f, 0x91, 0xd0, 0xf3,
      0x9f, 0xe7, 0x28, 0xfc, 0x46, 0xe4, 0x8d, 0x00, 0x77, 0x13, 0x05, 0x1b,
      0x22, 0xf1, 0xc0, 0x25, 0x7f, 0xe2, 0x0d, 0xd8, 0x5b, 0x21, 0xdf, 0x7e,
      0x1e, 0xc8, 0x2b, 0xf8, 0xb3, 0x9b, 0x21, 0x38, 0xa2, 0xae, 0x74, 0xf8,
      0x0e, 0x62, 0x57, 0x77, 0x8f, 0x8c, 0xca, 0x9f, 0x27, 0x9b, 0x57, 0xd2,
      0x5e, 0xee, 0xb1, 0x55, 0x96, 0x06, 0x42, 0x97, 0x2f, 0x05, 0x67, 0xe2,
      0x04, 0x51, 0x4f, 0x0a, 0xc1, 0xeb, 0x1e, 0x27, 0xdb, 0x51, 0x15, 0x05,
      0x32, 0x11, 0x91, 0x49, 0x61, 0xd0, 0x96, 0x44, 0xc6},
     {0x45, 0x5c, 0xf3, 0xc0, 0xb0, 0x09, 0x06, 0x88, 0x59, 0x98, 0x25, 0x52,
      0x2e, 0xf3, 0x31, 0x28, 0x78, 0x20, 0x15, 0x14, 0xf6, 0x33, 0x0c, 0xcc,
      0x7f, 0x42, 0xec, 0x19, 0x45, 0x20, 0x4a, 0xdf, 0xe4, 0x19, 0xb2, 0xdb,
      0xbf, 0xb9, 0x42, 0xdc, 0x98, 0xb1, 0x6d, 0x83, 0x23, 0x15, 0x0c, 0xf6},
     false,
     false},

    // Comment: cofactor = None
    // tcID: 194
    {194,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xde,
      0x44, 0xe6, 0x3f, 0xd9, 0x24, 0xf1, 0x77, 0x34, 0x0d, 0x78, 0x0a, 0xf6,
      0xaa, 0xae, 0xa2, 0x71, 0xf5, 0x2d, 0x2c, 0xb9, 0xa5, 0xc5, 0x19, 0xb6,
      0x02, 0x0e, 0x06, 0xc3, 0xcf, 0x0b, 0xaa, 0xfb, 0xc0, 0xb8, 0x01, 0xc6,
      0x50, 0x8c, 0x2e, 0x14, 0x83, 0xb1, 0x5c, 0xfe, 0xf7, 0xaf, 0xc2, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x65, 0xce, 0x6b, 0x9d, 0x7e, 0x71, 0xe9,
      0x31, 0xb6, 0xfd, 0x1f, 0xac, 0x91, 0x05, 0x07, 0xb4, 0x37, 0x7a, 0xc1,
      0x5e, 0x45, 0x32, 0x92, 0xa2, 0x35, 0x5d, 0xf3, 0x9a, 0xb7, 0x41, 0xca,
      0x36, 0x29, 0x7b, 0xf6, 0xde, 0x3c, 0x34, 0xa5, 0xaf, 0xbb, 0xad, 0x37,
      0x18, 0x06, 0xb8, 0x91, 0xf2, 0x4b, 0x08, 0x8b, 0xc5, 0xd1, 0x46, 0x46,
      0xa7, 0x4f, 0x3e, 0xfc, 0xfe, 0xa3, 0x9e, 0x12, 0xe2, 0xb5, 0xf5, 0x6e,
      0xbb, 0xdd, 0x50, 0x3d, 0x5e, 0x8f, 0xee, 0x3f, 0xc3, 0x00, 0xd7, 0x50,
      0x9b, 0xaa, 0x22, 0xb6, 0x68, 0xdb, 0xf1, 0xfd, 0x24, 0x18, 0x07, 0x0a,
      0xb4, 0x0a, 0x07, 0xd9, 0xf6},
     {0x30, 0x82, 0x01, 0xb2, 0x30, 0x82, 0x01, 0x4a, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x30, 0x82, 0x01, 0x3d, 0x02, 0x01, 0x01,
      0x30, 0x3c, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x30, 0x64, 0x04, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x30, 0xb3, 0x31, 0x2f, 0xa7,
      0xe2, 0x3e, 0xe7, 0xe4, 0x98, 0x8e, 0x05, 0x6b, 0xe3, 0xf8, 0x2d, 0x19,
      0x18, 0x1d, 0x9c, 0x6e, 0xfe, 0x81, 0x41, 0x12, 0x03, 0x14, 0x08, 0x8f,
      0x50, 0x13, 0x87, 0x5a, 0xc6, 0x56, 0x39, 0x8d, 0x8a, 0x2e, 0xd1, 0x9d,
      0x2a, 0x85, 0xc8, 0xed, 0xd3, 0xec, 0x2a, 0xef, 0x04, 0x61, 0x04, 0xaa,
      0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05, 0x37, 0x8e, 0xb1, 0xc7, 0x1e, 0xf3,
      0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b, 0x62, 0x8b, 0xa7, 0x9b, 0x98, 0x59,
      0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a, 0x38, 0x55, 0x02, 0xf2, 0x5d, 0xbf,
      0x55, 0x29, 0x6c, 0x3a, 0x54, 0x5e, 0x38, 0x72, 0x76, 0x0a, 0xb7, 0x36,
      0x17, 0xde, 0x4a, 0x96, 0x26, 0x2c, 0x6f, 0x5d, 0x9e, 0x98, 0xbf, 0x92,
      0x92, 0xdc, 0x29, 0xf8, 0xf4, 0x1d, 0xbd, 0x28, 0x9a, 0x14, 0x7c, 0xe9,
      0xda, 0x31, 0x13, 0xb5, 0xf0, 0xb8, 0xc0, 0x0a, 0x60, 0xb1, 0xce, 0x1d,
      0x7e, 0x81, 0x9d, 0x7a, 0x43, 0x1d, 0x7c, 0x90, 0xea, 0x0e, 0x5f, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a,
      0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5,
      0x29, 0x73, 0x03, 0x62, 0x00, 0x04, 0x21, 0x21, 0xa3, 0x48, 0xf9, 0x74,
      0x38, 0x55, 0x85, 0x9c, 0x49, 0x6f, 0x91, 0xd0, 0xf3, 0x9f, 0xe7, 0x28,
      0xfc, 0x46, 0xe4, 0x8d, 0x00, 0x77, 0x13, 0x05, 0x1b, 0x22, 0xf1, 0xc0,
      0x25, 0x7f, 0xe2, 0x0d, 0xd8, 0x5b, 0x21, 0xdf, 0x7e, 0x1e, 0xc8, 0x2b,
      0xf8, 0xb3, 0x9b, 0x21, 0x38, 0xa2, 0xae, 0x74, 0xf8, 0x0e, 0x62, 0x57,
      0x77, 0x8f, 0x8c, 0xca, 0x9f, 0x27, 0x9b, 0x57, 0xd2, 0x5e, 0xee, 0xb1,
      0x55, 0x96, 0x06, 0x42, 0x97, 0x2f, 0x05, 0x67, 0xe2, 0x04, 0x51, 0x4f,
      0x0a, 0xc1, 0xeb, 0x1e, 0x27, 0xdb, 0x51, 0x15, 0x05, 0x32, 0x11, 0x91,
      0x49, 0x61, 0xd0, 0x96, 0x44, 0xc6},
     {0x45, 0x5c, 0xf3, 0xc0, 0xb0, 0x09, 0x06, 0x88, 0x59, 0x98, 0x25, 0x52,
      0x2e, 0xf3, 0x31, 0x28, 0x78, 0x20, 0x15, 0x14, 0xf6, 0x33, 0x0c, 0xcc,
      0x7f, 0x42, 0xec, 0x19, 0x45, 0x20, 0x4a, 0xdf, 0xe4, 0x19, 0xb2, 0xdb,
      0xbf, 0xb9, 0x42, 0xdc, 0x98, 0xb1, 0x6d, 0x83, 0x23, 0x15, 0x0c, 0xf6},
     false,
     false},

    // Comment: modified prime
    // tcID: 195
    {195,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xde,
      0x44, 0xe6, 0x3f, 0xd9, 0x24, 0xf1, 0x77, 0x34, 0x0d, 0x78, 0x0a, 0xf6,
      0xaa, 0xae, 0xa2, 0x71, 0xf5, 0x2d, 0x2c, 0xb9, 0xa5, 0xc5, 0x19, 0xb6,
      0x02, 0x0e, 0x06, 0xc3, 0xcf, 0x0b, 0xaa, 0xfb, 0xc0, 0xb8, 0x01, 0xc6,
      0x50, 0x8c, 0x2e, 0x14, 0x83, 0xb1, 0x5c, 0xfe, 0xf7, 0xaf, 0xc2, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x65, 0xce, 0x6b, 0x9d, 0x7e, 0x71, 0xe9,
      0x31, 0xb6, 0xfd, 0x1f, 0xac, 0x91, 0x05, 0x07, 0xb4, 0x37, 0x7a, 0xc1,
      0x5e, 0x45, 0x32, 0x92, 0xa2, 0x35, 0x5d, 0xf3, 0x9a, 0xb7, 0x41, 0xca,
      0x36, 0x29, 0x7b, 0xf6, 0xde, 0x3c, 0x34, 0xa5, 0xaf, 0xbb, 0xad, 0x37,
      0x18, 0x06, 0xb8, 0x91, 0xf2, 0x4b, 0x08, 0x8b, 0xc5, 0xd1, 0x46, 0x46,
      0xa7, 0x4f, 0x3e, 0xfc, 0xfe, 0xa3, 0x9e, 0x12, 0xe2, 0xb5, 0xf5, 0x6e,
      0xbb, 0xdd, 0x50, 0x3d, 0x5e, 0x8f, 0xee, 0x3f, 0xc3, 0x00, 0xd7, 0x50,
      0x9b, 0xaa, 0x22, 0xb6, 0x68, 0xdb, 0xf1, 0xfd, 0x24, 0x18, 0x07, 0x0a,
      0xb4, 0x0a, 0x07, 0xd9, 0xf6},
     {0x30, 0x82, 0x01, 0xb5, 0x30, 0x82, 0x01, 0x4d, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x30, 0x82, 0x01, 0x40, 0x02, 0x01, 0x01,
      0x30, 0x3c, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02,
      0x31, 0x00, 0xf4, 0x7e, 0x53, 0x3e, 0x4e, 0x43, 0xe4, 0xbf, 0x04, 0xe9,
      0x01, 0xdb, 0x0e, 0xea, 0x6e, 0xfb, 0xa1, 0x4b, 0xbc, 0xdc, 0x3b, 0x1c,
      0x57, 0x53, 0xa7, 0xc1, 0x41, 0x48, 0x7e, 0x4f, 0x43, 0x78, 0x4e, 0x57,
      0xa7, 0x23, 0x10, 0x20, 0x23, 0x23, 0x36, 0x1f, 0x44, 0x76, 0x0c, 0x83,
      0x68, 0xbf, 0x30, 0x64, 0x04, 0x30, 0x0b, 0x81, 0xac, 0xc1, 0xb1, 0xbc,
      0x1b, 0x40, 0xfb, 0x16, 0xfe, 0x24, 0xf1, 0x15, 0x91, 0x04, 0x5e, 0xb4,
      0x43, 0x23, 0xc4, 0xe3, 0xa8, 0xac, 0x58, 0x3e, 0xbe, 0xb7, 0x81, 0xb0,
      0xbc, 0x86, 0xb1, 0xa8, 0x58, 0xdb, 0xef, 0xdf, 0xdc, 0xdc, 0xc9, 0xe0,
      0xbb, 0x8a, 0xf3, 0x7c, 0x97, 0x3d, 0x04, 0x30, 0xb3, 0x31, 0x2f, 0xa7,
      0xe2, 0x3e, 0xe7, 0xe4, 0x98, 0x8e, 0x05, 0x6b, 0xe3, 0xf8, 0x2d, 0x19,
      0x18, 0x1d, 0x9c, 0x6e, 0xfe, 0x81, 0x41, 0x12, 0x03, 0x14, 0x08, 0x8f,
      0x50, 0x13, 0x87, 0x5a, 0xc6, 0x56, 0x39, 0x8d, 0x8a, 0x2e, 0xd1, 0x9d,
      0x2a, 0x85, 0xc8, 0xed, 0xd3, 0xec, 0x2a, 0xef, 0x04, 0x61, 0x04, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x38, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xcf, 0x36,
      0x46, 0x29, 0x8b, 0xba, 0x2f, 0x24, 0xe8, 0x41, 0x89, 0xcf, 0x0d, 0x1e,
      0x75, 0x18, 0x8f, 0xc4, 0xfc, 0xf5, 0xb0, 0x84, 0x42, 0x81, 0x82, 0x2e,
      0x78, 0x9e, 0x3d, 0x53, 0x4b, 0x15, 0x9f, 0x4c, 0x41, 0x93, 0x42, 0x26,
      0x01, 0x97, 0x62, 0x5a, 0xd9, 0x24, 0xa2, 0xc7, 0x2c, 0x4d, 0x0f, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a,
      0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5,
      0x29, 0x73, 0x02, 0x01, 0x01, 0x03, 0x62, 0x00, 0x04, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x38, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xcf, 0x36, 0x46, 0x29,
      0x8b, 0xba, 0x2f, 0x24, 0xe8, 0x41, 0x89, 0xcf, 0x0d, 0x1e, 0x75, 0x18,
      0x8f, 0xc4, 0xfc, 0xf5, 0xb0, 0x84, 0x42, 0x81, 0x82, 0x2e, 0x78, 0x9e,
      0x3d, 0x53, 0x4b, 0x15, 0x9f, 0x4c, 0x41, 0x93, 0x42, 0x26, 0x01, 0x97,
      0x62, 0x5a, 0xd9, 0x24, 0xa2, 0xc7, 0x2c, 0x4d, 0x0f},
     {0x5d, 0xf0, 0x76, 0x24, 0x88, 0xbc, 0x0a, 0x7b, 0xe1, 0x12, 0x15, 0x08,
      0x94, 0x93, 0x82, 0x86, 0x1f, 0x78, 0x1c, 0x33, 0x16, 0x76, 0x04, 0x8c,
      0x2d, 0x45, 0xd2, 0x45, 0xbe, 0x6f, 0x47, 0x6c, 0x87, 0x21, 0x13, 0xe6,
      0x71, 0x0b, 0xc7, 0x46, 0xc3, 0xd0, 0x69, 0x70, 0x51, 0x01, 0x93, 0xce},
     false,
     false},

    // Comment: using secp224r1
    // tcID: 196
    {196,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xde,
      0x44, 0xe6, 0x3f, 0xd9, 0x24, 0xf1, 0x77, 0x34, 0x0d, 0x78, 0x0a, 0xf6,
      0xaa, 0xae, 0xa2, 0x71, 0xf5, 0x2d, 0x2c, 0xb9, 0xa5, 0xc5, 0x19, 0xb6,
      0x02, 0x0e, 0x06, 0xc3, 0xcf, 0x0b, 0xaa, 0xfb, 0xc0, 0xb8, 0x01, 0xc6,
      0x50, 0x8c, 0x2e, 0x14, 0x83, 0xb1, 0x5c, 0xfe, 0xf7, 0xaf, 0xc2, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x65, 0xce, 0x6b, 0x9d, 0x7e, 0x71, 0xe9,
      0x31, 0xb6, 0xfd, 0x1f, 0xac, 0x91, 0x05, 0x07, 0xb4, 0x37, 0x7a, 0xc1,
      0x5e, 0x45, 0x32, 0x92, 0xa2, 0x35, 0x5d, 0xf3, 0x9a, 0xb7, 0x41, 0xca,
      0x36, 0x29, 0x7b, 0xf6, 0xde, 0x3c, 0x34, 0xa5, 0xaf, 0xbb, 0xad, 0x37,
      0x18, 0x06, 0xb8, 0x91, 0xf2, 0x4b, 0x08, 0x8b, 0xc5, 0xd1, 0x46, 0x46,
      0xa7, 0x4f, 0x3e, 0xfc, 0xfe, 0xa3, 0x9e, 0x12, 0xe2, 0xb5, 0xf5, 0x6e,
      0xbb, 0xdd, 0x50, 0x3d, 0x5e, 0x8f, 0xee, 0x3f, 0xc3, 0x00, 0xd7, 0x50,
      0x9b, 0xaa, 0x22, 0xb6, 0x68, 0xdb, 0xf1, 0xfd, 0x24, 0x18, 0x07, 0x0a,
      0xb4, 0x0a, 0x07, 0xd9, 0xf6},
     {0x30, 0x4e, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x21, 0x03, 0x3a, 0x00, 0x04,
      0x07, 0x4f, 0x56, 0xdc, 0x2e, 0xa6, 0x48, 0xef, 0x89, 0xc3, 0xb7, 0x2e,
      0x23, 0xbb, 0xd2, 0xda, 0x36, 0xf6, 0x02, 0x43, 0xe4, 0xd2, 0x06, 0x7b,
      0x70, 0x60, 0x4a, 0xf1, 0xc2, 0x16, 0x5c, 0xec, 0x2f, 0x86, 0x60, 0x3d,
      0x60, 0xc8, 0xa6, 0x11, 0xd5, 0xb8, 0x4b, 0xa3, 0xd9, 0x1d, 0xfe, 0x1a,
      0x48, 0x08, 0x25, 0xbc, 0xc4, 0xaf, 0x3b, 0xcf},
     {},
     false,
     false},

    // Comment: using secp256r1
    // tcID: 197
    {197,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xde,
      0x44, 0xe6, 0x3f, 0xd9, 0x24, 0xf1, 0x77, 0x34, 0x0d, 0x78, 0x0a, 0xf6,
      0xaa, 0xae, 0xa2, 0x71, 0xf5, 0x2d, 0x2c, 0xb9, 0xa5, 0xc5, 0x19, 0xb6,
      0x02, 0x0e, 0x06, 0xc3, 0xcf, 0x0b, 0xaa, 0xfb, 0xc0, 0xb8, 0x01, 0xc6,
      0x50, 0x8c, 0x2e, 0x14, 0x83, 0xb1, 0x5c, 0xfe, 0xf7, 0xaf, 0xc2, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x65, 0xce, 0x6b, 0x9d, 0x7e, 0x71, 0xe9,
      0x31, 0xb6, 0xfd, 0x1f, 0xac, 0x91, 0x05, 0x07, 0xb4, 0x37, 0x7a, 0xc1,
      0x5e, 0x45, 0x32, 0x92, 0xa2, 0x35, 0x5d, 0xf3, 0x9a, 0xb7, 0x41, 0xca,
      0x36, 0x29, 0x7b, 0xf6, 0xde, 0x3c, 0x34, 0xa5, 0xaf, 0xbb, 0xad, 0x37,
      0x18, 0x06, 0xb8, 0x91, 0xf2, 0x4b, 0x08, 0x8b, 0xc5, 0xd1, 0x46, 0x46,
      0xa7, 0x4f, 0x3e, 0xfc, 0xfe, 0xa3, 0x9e, 0x12, 0xe2, 0xb5, 0xf5, 0x6e,
      0xbb, 0xdd, 0x50, 0x3d, 0x5e, 0x8f, 0xee, 0x3f, 0xc3, 0x00, 0xd7, 0x50,
      0x9b, 0xaa, 0x22, 0xb6, 0x68, 0xdb, 0xf1, 0xfd, 0x24, 0x18, 0x07, 0x0a,
      0xb4, 0x0a, 0x07, 0xd9, 0xf6},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xcb, 0xf6, 0x60, 0x65, 0x95, 0xa3, 0xee, 0x50, 0xf9,
      0xfc, 0xea, 0xa2, 0x79, 0x8c, 0x27, 0x40, 0xc8, 0x25, 0x40, 0x51, 0x6b,
      0x4e, 0x5a, 0x7d, 0x36, 0x1f, 0xf2, 0x4e, 0x9d, 0xd1, 0x53, 0x64, 0xe5,
      0x40, 0x8b, 0x2e, 0x67, 0x9f, 0x9d, 0x53, 0x10, 0xd1, 0xf6, 0x89, 0x3b,
      0x36, 0xce, 0x16, 0xb4, 0xa5, 0x07, 0x50, 0x91, 0x75, 0xfc, 0xb5, 0x2a,
      0xea, 0x53, 0xb7, 0x81, 0x55, 0x6b, 0x39},
     {},
     false,
     false},

    // Comment: using secp256k1
    // tcID: 198
    {198,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xde,
      0x44, 0xe6, 0x3f, 0xd9, 0x24, 0xf1, 0x77, 0x34, 0x0d, 0x78, 0x0a, 0xf6,
      0xaa, 0xae, 0xa2, 0x71, 0xf5, 0x2d, 0x2c, 0xb9, 0xa5, 0xc5, 0x19, 0xb6,
      0x02, 0x0e, 0x06, 0xc3, 0xcf, 0x0b, 0xaa, 0xfb, 0xc0, 0xb8, 0x01, 0xc6,
      0x50, 0x8c, 0x2e, 0x14, 0x83, 0xb1, 0x5c, 0xfe, 0xf7, 0xaf, 0xc2, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x65, 0xce, 0x6b, 0x9d, 0x7e, 0x71, 0xe9,
      0x31, 0xb6, 0xfd, 0x1f, 0xac, 0x91, 0x05, 0x07, 0xb4, 0x37, 0x7a, 0xc1,
      0x5e, 0x45, 0x32, 0x92, 0xa2, 0x35, 0x5d, 0xf3, 0x9a, 0xb7, 0x41, 0xca,
      0x36, 0x29, 0x7b, 0xf6, 0xde, 0x3c, 0x34, 0xa5, 0xaf, 0xbb, 0xad, 0x37,
      0x18, 0x06, 0xb8, 0x91, 0xf2, 0x4b, 0x08, 0x8b, 0xc5, 0xd1, 0x46, 0x46,
      0xa7, 0x4f, 0x3e, 0xfc, 0xfe, 0xa3, 0x9e, 0x12, 0xe2, 0xb5, 0xf5, 0x6e,
      0xbb, 0xdd, 0x50, 0x3d, 0x5e, 0x8f, 0xee, 0x3f, 0xc3, 0x00, 0xd7, 0x50,
      0x9b, 0xaa, 0x22, 0xb6, 0x68, 0xdb, 0xf1, 0xfd, 0x24, 0x18, 0x07, 0x0a,
      0xb4, 0x0a, 0x07, 0xd9, 0xf6},
     {0x30, 0x56, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x0a, 0x03, 0x42,
      0x00, 0x04, 0xa1, 0x26, 0x3e, 0x75, 0xb8, 0x7a, 0xe0, 0x93, 0x70,
      0x60, 0xff, 0x14, 0x72, 0xf3, 0x30, 0xee, 0x55, 0xcd, 0xf8, 0xf4,
      0x32, 0x9d, 0x62, 0x84, 0xa9, 0xeb, 0xfb, 0xcc, 0x85, 0x6c, 0x11,
      0x68, 0x42, 0x25, 0xe7, 0x2c, 0xbe, 0xbf, 0xf4, 0x1e, 0x54, 0xfb,
      0x6f, 0x00, 0xe1, 0x1a, 0xfe, 0x53, 0xa1, 0x79, 0x37, 0xbe, 0xdb,
      0xf2, 0xdf, 0x78, 0x7f, 0x8e, 0xf9, 0x58, 0x4f, 0x77, 0x58, 0x38},
     {},
     false,
     false},

    // Comment: a = 0
    // tcID: 199
    {199,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xde,
      0x44, 0xe6, 0x3f, 0xd9, 0x24, 0xf1, 0x77, 0x34, 0x0d, 0x78, 0x0a, 0xf6,
      0xaa, 0xae, 0xa2, 0x71, 0xf5, 0x2d, 0x2c, 0xb9, 0xa5, 0xc5, 0x19, 0xb6,
      0x02, 0x0e, 0x06, 0xc3, 0xcf, 0x0b, 0xaa, 0xfb, 0xc0, 0xb8, 0x01, 0xc6,
      0x50, 0x8c, 0x2e, 0x14, 0x83, 0xb1, 0x5c, 0xfe, 0xf7, 0xaf, 0xc2, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x65, 0xce, 0x6b, 0x9d, 0x7e, 0x71, 0xe9,
      0x31, 0xb6, 0xfd, 0x1f, 0xac, 0x91, 0x05, 0x07, 0xb4, 0x37, 0x7a, 0xc1,
      0x5e, 0x45, 0x32, 0x92, 0xa2, 0x35, 0x5d, 0xf3, 0x9a, 0xb7, 0x41, 0xca,
      0x36, 0x29, 0x7b, 0xf6, 0xde, 0x3c, 0x34, 0xa5, 0xaf, 0xbb, 0xad, 0x37,
      0x18, 0x06, 0xb8, 0x91, 0xf2, 0x4b, 0x08, 0x8b, 0xc5, 0xd1, 0x46, 0x46,
      0xa7, 0x4f, 0x3e, 0xfc, 0xfe, 0xa3, 0x9e, 0x12, 0xe2, 0xb5, 0xf5, 0x6e,
      0xbb, 0xdd, 0x50, 0x3d, 0x5e, 0x8f, 0xee, 0x3f, 0xc3, 0x00, 0xd7, 0x50,
      0x9b, 0xaa, 0x22, 0xb6, 0x68, 0xdb, 0xf1, 0xfd, 0x24, 0x18, 0x07, 0x0a,
      0xb4, 0x0a, 0x07, 0xd9, 0xf6},
     {0x30, 0x82, 0x01, 0x86, 0x30, 0x82, 0x01, 0x1e, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x30, 0x82, 0x01, 0x11, 0x02, 0x01, 0x01,
      0x30, 0x3c, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x30, 0x35, 0x04, 0x01, 0x00, 0x04, 0x30, 0x4f, 0xcc, 0x45,
      0xcc, 0xf5, 0xe2, 0x3e, 0xe4, 0x07, 0xb9, 0x29, 0x1d, 0x2e, 0x85, 0x52,
      0x39, 0x62, 0xa2, 0xa7, 0x9a, 0x50, 0xda, 0x3f, 0xac, 0xca, 0x04, 0xb7,
      0x26, 0x7a, 0xd3, 0x16, 0xdb, 0x20, 0x2c, 0xb0, 0x7c, 0x24, 0x90, 0x57,
      0x40, 0xd2, 0x01, 0xde, 0xd3, 0x02, 0x88, 0x81, 0x09, 0x04, 0x61, 0x04,
      0x21, 0x21, 0xa3, 0x48, 0xf9, 0x74, 0x38, 0x55, 0x85, 0x9c, 0x49, 0x6f,
      0x91, 0xd0, 0xf3, 0x9f, 0xe7, 0x28, 0xfc, 0x46, 0xe4, 0x8d, 0x00, 0x77,
      0x13, 0x05, 0x1b, 0x22, 0xf1, 0xc0, 0x25, 0x7f, 0xe2, 0x0d, 0xd8, 0x5b,
      0x21, 0xdf, 0x7e, 0x1e, 0xc8, 0x2b, 0xf8, 0xb3, 0x9b, 0x21, 0x38, 0xa2,
      0xae, 0x74, 0xf8, 0x0e, 0x62, 0x57, 0x77, 0x8f, 0x8c, 0xca, 0x9f, 0x27,
      0x9b, 0x57, 0xd2, 0x5e, 0xee, 0xb1, 0x55, 0x96, 0x06, 0x42, 0x97, 0x2f,
      0x05, 0x67, 0xe2, 0x04, 0x51, 0x4f, 0x0a, 0xc1, 0xeb, 0x1e, 0x27, 0xdb,
      0x51, 0x15, 0x05, 0x32, 0x11, 0x91, 0x49, 0x61, 0xd0, 0x96, 0x44, 0xc6,
      0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf, 0x58,
      0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19, 0x6a, 0xcc,
      0xc5, 0x29, 0x73, 0x02, 0x01, 0x01, 0x03, 0x62, 0x00, 0x04, 0x21, 0x21,
      0xa3, 0x48, 0xf9, 0x74, 0x38, 0x55, 0x85, 0x9c, 0x49, 0x6f, 0x91, 0xd0,
      0xf3, 0x9f, 0xe7, 0x28, 0xfc, 0x46, 0xe4, 0x8d, 0x00, 0x77, 0x13, 0x05,
      0x1b, 0x22, 0xf1, 0xc0, 0x25, 0x7f, 0xe2, 0x0d, 0xd8, 0x5b, 0x21, 0xdf,
      0x7e, 0x1e, 0xc8, 0x2b, 0xf8, 0xb3, 0x9b, 0x21, 0x38, 0xa2, 0xae, 0x74,
      0xf8, 0x0e, 0x62, 0x57, 0x77, 0x8f, 0x8c, 0xca, 0x9f, 0x27, 0x9b, 0x57,
      0xd2, 0x5e, 0xee, 0xb1, 0x55, 0x96, 0x06, 0x42, 0x97, 0x2f, 0x05, 0x67,
      0xe2, 0x04, 0x51, 0x4f, 0x0a, 0xc1, 0xeb, 0x1e, 0x27, 0xdb, 0x51, 0x15,
      0x05, 0x32, 0x11, 0x91, 0x49, 0x61, 0xd0, 0x96, 0x44, 0xc6},
     {0x45, 0x5c, 0xf3, 0xc0, 0xb0, 0x09, 0x06, 0x88, 0x59, 0x98, 0x25, 0x52,
      0x2e, 0xf3, 0x31, 0x28, 0x78, 0x20, 0x15, 0x14, 0xf6, 0x33, 0x0c, 0xcc,
      0x7f, 0x42, 0xec, 0x19, 0x45, 0x20, 0x4a, 0xdf, 0xe4, 0x19, 0xb2, 0xdb,
      0xbf, 0xb9, 0x42, 0xdc, 0x98, 0xb1, 0x6d, 0x83, 0x23, 0x15, 0x0c, 0xf6},
     false,
     false},

    // Comment: public key of order 3
    // tcID: 200
    {200,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xde,
      0x44, 0xe6, 0x3f, 0xd9, 0x24, 0xf1, 0x77, 0x34, 0x0d, 0x78, 0x0a, 0xf6,
      0xaa, 0xae, 0xa2, 0x71, 0xf5, 0x2d, 0x2c, 0xb9, 0xa5, 0xc5, 0x19, 0xb6,
      0x02, 0x0e, 0x06, 0xc3, 0xcf, 0x0b, 0xaa, 0xfb, 0xc0, 0xb8, 0x01, 0xc6,
      0x50, 0x8c, 0x2e, 0x14, 0x83, 0xb1, 0x5c, 0xfe, 0xf7, 0xaf, 0xc2, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x65, 0xce, 0x6b, 0x9d, 0x7e, 0x71, 0xe9,
      0x31, 0xb6, 0xfd, 0x1f, 0xac, 0x91, 0x05, 0x07, 0xb4, 0x37, 0x7a, 0xc1,
      0x5e, 0x45, 0x32, 0x92, 0xa2, 0x35, 0x5d, 0xf3, 0x9a, 0xb7, 0x41, 0xca,
      0x36, 0x29, 0x7b, 0xf6, 0xde, 0x3c, 0x34, 0xa5, 0xaf, 0xbb, 0xad, 0x37,
      0x18, 0x06, 0xb8, 0x91, 0xf2, 0x4b, 0x08, 0x8b, 0xc5, 0xd1, 0x46, 0x46,
      0xa7, 0x4f, 0x3e, 0xfc, 0xfe, 0xa3, 0x9e, 0x12, 0xe2, 0xb5, 0xf5, 0x6e,
      0xbb, 0xdd, 0x50, 0x3d, 0x5e, 0x8f, 0xee, 0x3f, 0xc3, 0x00, 0xd7, 0x50,
      0x9b, 0xaa, 0x22, 0xb6, 0x68, 0xdb, 0xf1, 0xfd, 0x24, 0x18, 0x07, 0x0a,
      0xb4, 0x0a, 0x07, 0xd9, 0xf6},
     {0x30, 0x82, 0x01, 0xb5, 0x30, 0x82, 0x01, 0x4d, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x30, 0x82, 0x01, 0x40, 0x02, 0x01, 0x01,
      0x30, 0x3c, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x30, 0x64, 0x04, 0x30, 0x74, 0xa8, 0x9c, 0x1d, 0x95, 0x03,
      0x0a, 0x24, 0xdd, 0xdf, 0x35, 0xde, 0xb3, 0xd4, 0x90, 0x66, 0x5c, 0xab,
      0x6a, 0x0e, 0x72, 0x74, 0x1a, 0xbb, 0x05, 0xf3, 0xfb, 0x7e, 0x34, 0xec,
      0x8b, 0x43, 0x2b, 0x39, 0xfc, 0x1b, 0xa6, 0x42, 0x85, 0xf4, 0x07, 0x85,
      0x6c, 0xa8, 0x06, 0x90, 0xf1, 0x25, 0x04, 0x30, 0x54, 0xe7, 0xa5, 0x58,
      0xb3, 0x5b, 0xb0, 0xe9, 0xaf, 0x4a, 0x41, 0x9e, 0xc6, 0x63, 0x5f, 0x3c,
      0x0d, 0x34, 0xae, 0x01, 0x3c, 0xde, 0x6d, 0xeb, 0xef, 0x47, 0x51, 0x4b,
      0xcb, 0x98, 0x0a, 0xd5, 0x47, 0xc9, 0xaa, 0x58, 0x34, 0xbe, 0x44, 0xea,
      0xa0, 0x2e, 0x93, 0xbf, 0x85, 0x13, 0x44, 0xe8, 0x04, 0x61, 0x04, 0xc9,
      0x8a, 0xdc, 0xe2, 0xb5, 0xef, 0x15, 0x4f, 0x90, 0xd7, 0xd6, 0xf0, 0xc2,
      0xec, 0x6c, 0x52, 0x6a, 0x9f, 0x21, 0x4c, 0xce, 0x85, 0xee, 0x84, 0x29,
      0x0e, 0x45, 0xfd, 0x6e, 0x5e, 0x88, 0xf8, 0x2d, 0xfe, 0x99, 0x4c, 0x00,
      0x50, 0xd8, 0x38, 0x78, 0x97, 0x44, 0xaf, 0x8b, 0x8d, 0x95, 0x05, 0xf2,
      0x9c, 0xbb, 0x59, 0xd9, 0x1d, 0x19, 0x08, 0xfa, 0xaa, 0xb1, 0xcd, 0x17,
      0xb7, 0xe0, 0x73, 0x6d, 0xf1, 0xe0, 0x9a, 0x4f, 0xc4, 0x23, 0x66, 0xab,
      0xb3, 0x39, 0x56, 0x50, 0x86, 0xf7, 0xd8, 0x72, 0xc7, 0x79, 0xaf, 0x84,
      0x98, 0x0f, 0x9f, 0xd7, 0x25, 0x44, 0x6f, 0xf0, 0xe2, 0xdd, 0xe5, 0x02,
      0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a,
      0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5,
      0x29, 0x73, 0x02, 0x01, 0x01, 0x03, 0x62, 0x00, 0x04, 0xc9, 0x8a, 0xdc,
      0xe2, 0xb5, 0xef, 0x15, 0x4f, 0x90, 0xd7, 0xd6, 0xf0, 0xc2, 0xec, 0x6c,
      0x52, 0x6a, 0x9f, 0x21, 0x4c, 0xce, 0x85, 0xee, 0x84, 0x29, 0x0e, 0x45,
      0xfd, 0x6e, 0x5e, 0x88, 0xf8, 0x2d, 0xfe, 0x99, 0x4c, 0x00, 0x50, 0xd8,
      0x38, 0x78, 0x97, 0x44, 0xaf, 0x8b, 0x8d, 0x95, 0x05, 0x0d, 0x63, 0x44,
      0xa6, 0x26, 0xe2, 0xe6, 0xf7, 0x05, 0x55, 0x4e, 0x32, 0xe8, 0x48, 0x1f,
      0x8c, 0x92, 0x0e, 0x1f, 0x65, 0xb0, 0x3b, 0xdc, 0x99, 0x54, 0x4c, 0xc6,
      0xa9, 0xaf, 0x79, 0x08, 0x26, 0x8d, 0x38, 0x86, 0x4f, 0x7b, 0x67, 0xf0,
      0x60, 0x28, 0xda, 0xbb, 0x91, 0x0f, 0x1d, 0x22, 0x1a},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: secp224r1
    // tcID: 201
    {201,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xd6,
      0x33, 0x1a, 0x5a, 0x96, 0x8e, 0x4d, 0x3b, 0xd7, 0x33, 0x6a, 0x42, 0x3b,
      0x41, 0x05, 0x5b, 0x68, 0xed, 0xd1, 0x00, 0xb8, 0xb9, 0x98, 0xd0, 0x0e,
      0xb9, 0xed, 0x93, 0x88, 0x1c, 0x21, 0xe3, 0x91, 0x2b, 0xb2, 0xee, 0x08,
      0xe7, 0x13, 0x27, 0xbe, 0x20, 0x58, 0x98, 0x67, 0x5e, 0xf7, 0xa4, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x2d, 0xff, 0x77, 0x3a, 0x88, 0x32, 0x9e,
      0x60, 0xd4, 0xa0, 0x6b, 0xf3, 0x26, 0xb4, 0x13, 0x83, 0xa4, 0x52, 0xb1,
      0x3b, 0x8c, 0x80, 0x74, 0x5e, 0xc7, 0x01, 0xb9, 0xc4, 0x7e, 0x11, 0x4e,
      0x16, 0x11, 0x53, 0x80, 0x26, 0x59, 0xc5, 0x72, 0x84, 0x0b, 0x56, 0xf7,
      0xaa, 0x77, 0xe4, 0x5c, 0x16, 0x2c, 0xe6, 0xe8, 0xfa, 0x19, 0x44, 0xaf,
      0xcc, 0x45, 0x5a, 0x11, 0x7f, 0x21, 0xde, 0x91, 0xcf, 0x7b, 0x0f, 0x3d,
      0x4e, 0x83, 0xa1, 0x3c, 0xe2, 0xaa, 0xa5, 0xe5, 0xb0, 0xb9, 0xef, 0x43,
      0x32, 0x2a, 0x84, 0xde, 0xb3, 0x11, 0x7c, 0xb7, 0x78, 0x4a, 0x86, 0xd8,
      0xa1, 0x86, 0xbc, 0xb1, 0x5b},
     {0x30, 0x4e, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x21, 0x03, 0x3a, 0x00, 0x04,
      0x07, 0x10, 0xb0, 0xc6, 0xf4, 0x67, 0x54, 0x59, 0xf3, 0xdf, 0x2b, 0xdf,
      0x7c, 0xa0, 0x28, 0x19, 0xf8, 0x08, 0x61, 0x98, 0xd1, 0x5c, 0x69, 0xb8,
      0xab, 0xda, 0x37, 0x63, 0x9e, 0x60, 0x31, 0xca, 0xca, 0x8a, 0x01, 0x21,
      0x89, 0x4d, 0x24, 0x91, 0xd8, 0xb3, 0xdc, 0xe0, 0x93, 0x70, 0x3c, 0x70,
      0x70, 0x5b, 0xc5, 0xdb, 0xc8, 0xfa, 0x17, 0xc8},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: secp256r1
    // tcID: 202
    {202,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xd6,
      0x33, 0x1a, 0x5a, 0x96, 0x8e, 0x4d, 0x3b, 0xd7, 0x33, 0x6a, 0x42, 0x3b,
      0x41, 0x05, 0x5b, 0x68, 0xed, 0xd1, 0x00, 0xb8, 0xb9, 0x98, 0xd0, 0x0e,
      0xb9, 0xed, 0x93, 0x88, 0x1c, 0x21, 0xe3, 0x91, 0x2b, 0xb2, 0xee, 0x08,
      0xe7, 0x13, 0x27, 0xbe, 0x20, 0x58, 0x98, 0x67, 0x5e, 0xf7, 0xa4, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x2d, 0xff, 0x77, 0x3a, 0x88, 0x32, 0x9e,
      0x60, 0xd4, 0xa0, 0x6b, 0xf3, 0x26, 0xb4, 0x13, 0x83, 0xa4, 0x52, 0xb1,
      0x3b, 0x8c, 0x80, 0x74, 0x5e, 0xc7, 0x01, 0xb9, 0xc4, 0x7e, 0x11, 0x4e,
      0x16, 0x11, 0x53, 0x80, 0x26, 0x59, 0xc5, 0x72, 0x84, 0x0b, 0x56, 0xf7,
      0xaa, 0x77, 0xe4, 0x5c, 0x16, 0x2c, 0xe6, 0xe8, 0xfa, 0x19, 0x44, 0xaf,
      0xcc, 0x45, 0x5a, 0x11, 0x7f, 0x21, 0xde, 0x91, 0xcf, 0x7b, 0x0f, 0x3d,
      0x4e, 0x83, 0xa1, 0x3c, 0xe2, 0xaa, 0xa5, 0xe5, 0xb0, 0xb9, 0xef, 0x43,
      0x32, 0x2a, 0x84, 0xde, 0xb3, 0x11, 0x7c, 0xb7, 0x78, 0x4a, 0x86, 0xd8,
      0xa1, 0x86, 0xbc, 0xb1, 0x5b},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x5f, 0xa4, 0xfa, 0x0b, 0x23, 0x5c, 0x21, 0xe5, 0xc9,
      0xf3, 0xba, 0xea, 0x93, 0x03, 0xbf, 0x86, 0xec, 0xcb, 0x7d, 0x31, 0xd0,
      0xb9, 0x98, 0xe1, 0x41, 0xbc, 0x54, 0xb5, 0xdc, 0x43, 0xb2, 0x3e, 0xef,
      0x7f, 0xc5, 0xcf, 0x56, 0x30, 0x8e, 0xd5, 0x95, 0xee, 0xe9, 0x9a, 0xde,
      0x6a, 0xaf, 0x74, 0xd5, 0x91, 0xc3, 0xd0, 0x0a, 0xa1, 0xb4, 0x38, 0xab,
      0xc5, 0x9c, 0x96, 0x07, 0xc2, 0x2c, 0x36},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: secp521r1
    // tcID: 203
    {203,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xd6,
      0x33, 0x1a, 0x5a, 0x96, 0x8e, 0x4d, 0x3b, 0xd7, 0x33, 0x6a, 0x42, 0x3b,
      0x41, 0x05, 0x5b, 0x68, 0xed, 0xd1, 0x00, 0xb8, 0xb9, 0x98, 0xd0, 0x0e,
      0xb9, 0xed, 0x93, 0x88, 0x1c, 0x21, 0xe3, 0x91, 0x2b, 0xb2, 0xee, 0x08,
      0xe7, 0x13, 0x27, 0xbe, 0x20, 0x58, 0x98, 0x67, 0x5e, 0xf7, 0xa4, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x2d, 0xff, 0x77, 0x3a, 0x88, 0x32, 0x9e,
      0x60, 0xd4, 0xa0, 0x6b, 0xf3, 0x26, 0xb4, 0x13, 0x83, 0xa4, 0x52, 0xb1,
      0x3b, 0x8c, 0x80, 0x74, 0x5e, 0xc7, 0x01, 0xb9, 0xc4, 0x7e, 0x11, 0x4e,
      0x16, 0x11, 0x53, 0x80, 0x26, 0x59, 0xc5, 0x72, 0x84, 0x0b, 0x56, 0xf7,
      0xaa, 0x77, 0xe4, 0x5c, 0x16, 0x2c, 0xe6, 0xe8, 0xfa, 0x19, 0x44, 0xaf,
      0xcc, 0x45, 0x5a, 0x11, 0x7f, 0x21, 0xde, 0x91, 0xcf, 0x7b, 0x0f, 0x3d,
      0x4e, 0x83, 0xa1, 0x3c, 0xe2, 0xaa, 0xa5, 0xe5, 0xb0, 0xb9, 0xef, 0x43,
      0x32, 0x2a, 0x84, 0xde, 0xb3, 0x11, 0x7c, 0xb7, 0x78, 0x4a, 0x86, 0xd8,
      0xa1, 0x86, 0xbc, 0xb1, 0x5b},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0x5b, 0xce, 0x61, 0xfe, 0x27, 0xc4, 0x40, 0xfe, 0xdb,
      0xad, 0x47, 0xd8, 0x8b, 0xcc, 0xf6, 0x45, 0xdb, 0x9c, 0x1d, 0x30, 0xda,
      0xa0, 0x86, 0xe5, 0x92, 0xe8, 0xb6, 0xa0, 0xa1, 0x73, 0xb8, 0x79, 0x91,
      0xb6, 0x19, 0x80, 0x19, 0x07, 0xb4, 0x20, 0xfa, 0x55, 0x8c, 0x79, 0x53,
      0xab, 0x97, 0xba, 0xdd, 0x9c, 0x6c, 0x1d, 0x85, 0x85, 0x9d, 0x9e, 0xbe,
      0xf7, 0x44, 0x1a, 0x08, 0x8f, 0xf5, 0x7e, 0xd5, 0x00, 0x8d, 0x76, 0x38,
      0xde, 0x70, 0x3f, 0xaa, 0xbe, 0xb5, 0xa7, 0x8e, 0x83, 0xe8, 0xfc, 0xd4,
      0xeb, 0x78, 0x61, 0x44, 0xa7, 0x5d, 0x79, 0xbd, 0x4c, 0xc8, 0xcf, 0xa8,
      0xbe, 0x66, 0x61, 0x2d, 0x75, 0x6c, 0x7b, 0x65, 0xc6, 0x7f, 0x72, 0xc6,
      0xac, 0xba, 0xde, 0x6f, 0x0d, 0x59, 0xe9, 0x75, 0x2e, 0x84, 0x52, 0x05,
      0xb2, 0xa5, 0x60, 0xd4, 0xf8, 0xd6, 0xa9, 0xe8, 0x4b, 0xf8, 0x12, 0xf9,
      0x4d, 0x18},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: secp256k1
    // tcID: 204
    {204,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xd6,
      0x33, 0x1a, 0x5a, 0x96, 0x8e, 0x4d, 0x3b, 0xd7, 0x33, 0x6a, 0x42, 0x3b,
      0x41, 0x05, 0x5b, 0x68, 0xed, 0xd1, 0x00, 0xb8, 0xb9, 0x98, 0xd0, 0x0e,
      0xb9, 0xed, 0x93, 0x88, 0x1c, 0x21, 0xe3, 0x91, 0x2b, 0xb2, 0xee, 0x08,
      0xe7, 0x13, 0x27, 0xbe, 0x20, 0x58, 0x98, 0x67, 0x5e, 0xf7, 0xa4, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x2d, 0xff, 0x77, 0x3a, 0x88, 0x32, 0x9e,
      0x60, 0xd4, 0xa0, 0x6b, 0xf3, 0x26, 0xb4, 0x13, 0x83, 0xa4, 0x52, 0xb1,
      0x3b, 0x8c, 0x80, 0x74, 0x5e, 0xc7, 0x01, 0xb9, 0xc4, 0x7e, 0x11, 0x4e,
      0x16, 0x11, 0x53, 0x80, 0x26, 0x59, 0xc5, 0x72, 0x84, 0x0b, 0x56, 0xf7,
      0xaa, 0x77, 0xe4, 0x5c, 0x16, 0x2c, 0xe6, 0xe8, 0xfa, 0x19, 0x44, 0xaf,
      0xcc, 0x45, 0x5a, 0x11, 0x7f, 0x21, 0xde, 0x91, 0xcf, 0x7b, 0x0f, 0x3d,
      0x4e, 0x83, 0xa1, 0x3c, 0xe2, 0xaa, 0xa5, 0xe5, 0xb0, 0xb9, 0xef, 0x43,
      0x32, 0x2a, 0x84, 0xde, 0xb3, 0x11, 0x7c, 0xb7, 0x78, 0x4a, 0x86, 0xd8,
      0xa1, 0x86, 0xbc, 0xb1, 0x5b},
     {0x30, 0x56, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x0a, 0x03, 0x42,
      0x00, 0x04, 0xa6, 0x9c, 0xed, 0x11, 0xa8, 0xbf, 0x7a, 0x90, 0x7b,
      0xfa, 0x47, 0xcb, 0xa3, 0x36, 0x8f, 0x24, 0x98, 0xb4, 0x65, 0xa2,
      0x40, 0x7c, 0x90, 0x64, 0x9c, 0x8d, 0xa2, 0x24, 0xd2, 0xa8, 0x5b,
      0xf4, 0x45, 0xad, 0x2d, 0xf3, 0xd0, 0x11, 0x3e, 0x72, 0xae, 0xdc,
      0xcf, 0x92, 0xba, 0x6b, 0x85, 0x29, 0xed, 0x6f, 0xaa, 0x15, 0x4b,
      0xc2, 0x7a, 0xba, 0x25, 0xf4, 0x93, 0x71, 0x98, 0x1e, 0x3b, 0x38},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: secp224k1
    // tcID: 205
    {205,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xd6,
      0x33, 0x1a, 0x5a, 0x96, 0x8e, 0x4d, 0x3b, 0xd7, 0x33, 0x6a, 0x42, 0x3b,
      0x41, 0x05, 0x5b, 0x68, 0xed, 0xd1, 0x00, 0xb8, 0xb9, 0x98, 0xd0, 0x0e,
      0xb9, 0xed, 0x93, 0x88, 0x1c, 0x21, 0xe3, 0x91, 0x2b, 0xb2, 0xee, 0x08,
      0xe7, 0x13, 0x27, 0xbe, 0x20, 0x58, 0x98, 0x67, 0x5e, 0xf7, 0xa4, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x2d, 0xff, 0x77, 0x3a, 0x88, 0x32, 0x9e,
      0x60, 0xd4, 0xa0, 0x6b, 0xf3, 0x26, 0xb4, 0x13, 0x83, 0xa4, 0x52, 0xb1,
      0x3b, 0x8c, 0x80, 0x74, 0x5e, 0xc7, 0x01, 0xb9, 0xc4, 0x7e, 0x11, 0x4e,
      0x16, 0x11, 0x53, 0x80, 0x26, 0x59, 0xc5, 0x72, 0x84, 0x0b, 0x56, 0xf7,
      0xaa, 0x77, 0xe4, 0x5c, 0x16, 0x2c, 0xe6, 0xe8, 0xfa, 0x19, 0x44, 0xaf,
      0xcc, 0x45, 0x5a, 0x11, 0x7f, 0x21, 0xde, 0x91, 0xcf, 0x7b, 0x0f, 0x3d,
      0x4e, 0x83, 0xa1, 0x3c, 0xe2, 0xaa, 0xa5, 0xe5, 0xb0, 0xb9, 0xef, 0x43,
      0x32, 0x2a, 0x84, 0xde, 0xb3, 0x11, 0x7c, 0xb7, 0x78, 0x4a, 0x86, 0xd8,
      0xa1, 0x86, 0xbc, 0xb1, 0x5b},
     {0x30, 0x4e, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x20, 0x03, 0x3a, 0x00, 0x04,
      0xfe, 0xf6, 0x11, 0x98, 0xc8, 0x85, 0x14, 0xf1, 0x9f, 0xe0, 0x0b, 0x2d,
      0xef, 0x1b, 0xd6, 0x07, 0x3f, 0x5c, 0x50, 0xeb, 0x57, 0x2a, 0xe8, 0x06,
      0xc0, 0xb6, 0x57, 0xff, 0x8b, 0xa7, 0x91, 0x86, 0x77, 0x1e, 0x73, 0xf5,
      0x98, 0x03, 0x6e, 0x5d, 0xca, 0x1a, 0x1d, 0xdc, 0x89, 0x9a, 0x56, 0xea,
      0x86, 0x63, 0xc1, 0x0f, 0x21, 0x2e, 0x45, 0x2a},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: brainpoolP224r1
    // tcID: 206
    {206,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xd6,
      0x33, 0x1a, 0x5a, 0x96, 0x8e, 0x4d, 0x3b, 0xd7, 0x33, 0x6a, 0x42, 0x3b,
      0x41, 0x05, 0x5b, 0x68, 0xed, 0xd1, 0x00, 0xb8, 0xb9, 0x98, 0xd0, 0x0e,
      0xb9, 0xed, 0x93, 0x88, 0x1c, 0x21, 0xe3, 0x91, 0x2b, 0xb2, 0xee, 0x08,
      0xe7, 0x13, 0x27, 0xbe, 0x20, 0x58, 0x98, 0x67, 0x5e, 0xf7, 0xa4, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x2d, 0xff, 0x77, 0x3a, 0x88, 0x32, 0x9e,
      0x60, 0xd4, 0xa0, 0x6b, 0xf3, 0x26, 0xb4, 0x13, 0x83, 0xa4, 0x52, 0xb1,
      0x3b, 0x8c, 0x80, 0x74, 0x5e, 0xc7, 0x01, 0xb9, 0xc4, 0x7e, 0x11, 0x4e,
      0x16, 0x11, 0x53, 0x80, 0x26, 0x59, 0xc5, 0x72, 0x84, 0x0b, 0x56, 0xf7,
      0xaa, 0x77, 0xe4, 0x5c, 0x16, 0x2c, 0xe6, 0xe8, 0xfa, 0x19, 0x44, 0xaf,
      0xcc, 0x45, 0x5a, 0x11, 0x7f, 0x21, 0xde, 0x91, 0xcf, 0x7b, 0x0f, 0x3d,
      0x4e, 0x83, 0xa1, 0x3c, 0xe2, 0xaa, 0xa5, 0xe5, 0xb0, 0xb9, 0xef, 0x43,
      0x32, 0x2a, 0x84, 0xde, 0xb3, 0x11, 0x7c, 0xb7, 0x78, 0x4a, 0x86, 0xd8,
      0xa1, 0x86, 0xbc, 0xb1, 0x5b},
     {0x30, 0x52, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x05,
      0x03, 0x3a, 0x00, 0x04, 0xa9, 0xb0, 0xf9, 0x0e, 0x49, 0xa5, 0x7f, 0xbe,
      0x50, 0x88, 0x47, 0xbf, 0x16, 0xe4, 0xa7, 0xb5, 0x65, 0xdf, 0xe8, 0x70,
      0xa5, 0x01, 0x64, 0xbc, 0x28, 0x62, 0xfe, 0x6e, 0x4d, 0x54, 0xbd, 0x8b,
      0x10, 0x99, 0x39, 0xf7, 0xdb, 0xbf, 0x80, 0x05, 0x22, 0x72, 0x2b, 0x9c,
      0x0b, 0x30, 0x9a, 0xce, 0x38, 0x84, 0xab, 0xb6, 0x9c, 0x92, 0x7a, 0xd0},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: brainpoolP256r1
    // tcID: 207
    {207,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xd6,
      0x33, 0x1a, 0x5a, 0x96, 0x8e, 0x4d, 0x3b, 0xd7, 0x33, 0x6a, 0x42, 0x3b,
      0x41, 0x05, 0x5b, 0x68, 0xed, 0xd1, 0x00, 0xb8, 0xb9, 0x98, 0xd0, 0x0e,
      0xb9, 0xed, 0x93, 0x88, 0x1c, 0x21, 0xe3, 0x91, 0x2b, 0xb2, 0xee, 0x08,
      0xe7, 0x13, 0x27, 0xbe, 0x20, 0x58, 0x98, 0x67, 0x5e, 0xf7, 0xa4, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x2d, 0xff, 0x77, 0x3a, 0x88, 0x32, 0x9e,
      0x60, 0xd4, 0xa0, 0x6b, 0xf3, 0x26, 0xb4, 0x13, 0x83, 0xa4, 0x52, 0xb1,
      0x3b, 0x8c, 0x80, 0x74, 0x5e, 0xc7, 0x01, 0xb9, 0xc4, 0x7e, 0x11, 0x4e,
      0x16, 0x11, 0x53, 0x80, 0x26, 0x59, 0xc5, 0x72, 0x84, 0x0b, 0x56, 0xf7,
      0xaa, 0x77, 0xe4, 0x5c, 0x16, 0x2c, 0xe6, 0xe8, 0xfa, 0x19, 0x44, 0xaf,
      0xcc, 0x45, 0x5a, 0x11, 0x7f, 0x21, 0xde, 0x91, 0xcf, 0x7b, 0x0f, 0x3d,
      0x4e, 0x83, 0xa1, 0x3c, 0xe2, 0xaa, 0xa5, 0xe5, 0xb0, 0xb9, 0xef, 0x43,
      0x32, 0x2a, 0x84, 0xde, 0xb3, 0x11, 0x7c, 0xb7, 0x78, 0x4a, 0x86, 0xd8,
      0xa1, 0x86, 0xbc, 0xb1, 0x5b},
     {0x30, 0x5a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x07,
      0x03, 0x42, 0x00, 0x04, 0x51, 0x2f, 0xe1, 0x71, 0x72, 0xdb, 0x11, 0x25,
      0xa4, 0x9f, 0x9d, 0xbb, 0x85, 0xe3, 0x87, 0x86, 0x9a, 0xdf, 0x01, 0x5e,
      0x48, 0x99, 0xc0, 0x6f, 0x66, 0xef, 0x87, 0x0d, 0x72, 0x09, 0x2d, 0x4d,
      0x19, 0x5e, 0x1d, 0x21, 0xb4, 0xa4, 0x64, 0x7b, 0xf7, 0x34, 0x46, 0x8b,
      0xee, 0x80, 0x2d, 0xda, 0xd5, 0x44, 0x92, 0x02, 0xeb, 0xa1, 0x04, 0x1d,
      0xf2, 0xfd, 0x8c, 0xde, 0x04, 0x69, 0x72, 0x37},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: brainpoolP320r1
    // tcID: 208
    {208,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xd6,
      0x33, 0x1a, 0x5a, 0x96, 0x8e, 0x4d, 0x3b, 0xd7, 0x33, 0x6a, 0x42, 0x3b,
      0x41, 0x05, 0x5b, 0x68, 0xed, 0xd1, 0x00, 0xb8, 0xb9, 0x98, 0xd0, 0x0e,
      0xb9, 0xed, 0x93, 0x88, 0x1c, 0x21, 0xe3, 0x91, 0x2b, 0xb2, 0xee, 0x08,
      0xe7, 0x13, 0x27, 0xbe, 0x20, 0x58, 0x98, 0x67, 0x5e, 0xf7, 0xa4, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x2d, 0xff, 0x77, 0x3a, 0x88, 0x32, 0x9e,
      0x60, 0xd4, 0xa0, 0x6b, 0xf3, 0x26, 0xb4, 0x13, 0x83, 0xa4, 0x52, 0xb1,
      0x3b, 0x8c, 0x80, 0x74, 0x5e, 0xc7, 0x01, 0xb9, 0xc4, 0x7e, 0x11, 0x4e,
      0x16, 0x11, 0x53, 0x80, 0x26, 0x59, 0xc5, 0x72, 0x84, 0x0b, 0x56, 0xf7,
      0xaa, 0x77, 0xe4, 0x5c, 0x16, 0x2c, 0xe6, 0xe8, 0xfa, 0x19, 0x44, 0xaf,
      0xcc, 0x45, 0x5a, 0x11, 0x7f, 0x21, 0xde, 0x91, 0xcf, 0x7b, 0x0f, 0x3d,
      0x4e, 0x83, 0xa1, 0x3c, 0xe2, 0xaa, 0xa5, 0xe5, 0xb0, 0xb9, 0xef, 0x43,
      0x32, 0x2a, 0x84, 0xde, 0xb3, 0x11, 0x7c, 0xb7, 0x78, 0x4a, 0x86, 0xd8,
      0xa1, 0x86, 0xbc, 0xb1, 0x5b},
     {0x30, 0x6a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x09,
      0x03, 0x52, 0x00, 0x04, 0xc3, 0x91, 0xdc, 0x7a, 0x81, 0x7d, 0x47, 0xa3,
      0x96, 0x1e, 0xa1, 0x85, 0x78, 0x95, 0xe1, 0x01, 0xc0, 0xf5, 0xa8, 0x76,
      0x7d, 0x3a, 0x9c, 0x7c, 0xad, 0x49, 0xf7, 0xaf, 0x80, 0x29, 0xf2, 0x4c,
      0x67, 0x30, 0x93, 0x73, 0xce, 0xdd, 0x08, 0x31, 0xcc, 0xc0, 0xa0, 0xf4,
      0x5d, 0x34, 0x4f, 0x3a, 0xb5, 0x92, 0x3d, 0x24, 0x52, 0x50, 0x7a, 0x98,
      0x03, 0x01, 0xa2, 0x83, 0x84, 0x8a, 0xe3, 0x15, 0x74, 0xa5, 0x7d, 0xb5,
      0x1c, 0xe5, 0xe6, 0x1d, 0x35, 0xae, 0xe4, 0x83, 0xf1, 0xbb, 0x8e, 0x66},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: brainpoolP384r1
    // tcID: 209
    {209,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xd6,
      0x33, 0x1a, 0x5a, 0x96, 0x8e, 0x4d, 0x3b, 0xd7, 0x33, 0x6a, 0x42, 0x3b,
      0x41, 0x05, 0x5b, 0x68, 0xed, 0xd1, 0x00, 0xb8, 0xb9, 0x98, 0xd0, 0x0e,
      0xb9, 0xed, 0x93, 0x88, 0x1c, 0x21, 0xe3, 0x91, 0x2b, 0xb2, 0xee, 0x08,
      0xe7, 0x13, 0x27, 0xbe, 0x20, 0x58, 0x98, 0x67, 0x5e, 0xf7, 0xa4, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x2d, 0xff, 0x77, 0x3a, 0x88, 0x32, 0x9e,
      0x60, 0xd4, 0xa0, 0x6b, 0xf3, 0x26, 0xb4, 0x13, 0x83, 0xa4, 0x52, 0xb1,
      0x3b, 0x8c, 0x80, 0x74, 0x5e, 0xc7, 0x01, 0xb9, 0xc4, 0x7e, 0x11, 0x4e,
      0x16, 0x11, 0x53, 0x80, 0x26, 0x59, 0xc5, 0x72, 0x84, 0x0b, 0x56, 0xf7,
      0xaa, 0x77, 0xe4, 0x5c, 0x16, 0x2c, 0xe6, 0xe8, 0xfa, 0x19, 0x44, 0xaf,
      0xcc, 0x45, 0x5a, 0x11, 0x7f, 0x21, 0xde, 0x91, 0xcf, 0x7b, 0x0f, 0x3d,
      0x4e, 0x83, 0xa1, 0x3c, 0xe2, 0xaa, 0xa5, 0xe5, 0xb0, 0xb9, 0xef, 0x43,
      0x32, 0x2a, 0x84, 0xde, 0xb3, 0x11, 0x7c, 0xb7, 0x78, 0x4a, 0x86, 0xd8,
      0xa1, 0x86, 0xbc, 0xb1, 0x5b},
     {0x30, 0x7a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x0b,
      0x03, 0x62, 0x00, 0x04, 0x19, 0xd3, 0xc8, 0x11, 0xc0, 0x4c, 0x5c, 0x09,
      0x90, 0xd0, 0x25, 0x83, 0x86, 0x19, 0x5b, 0x2e, 0x29, 0xfd, 0xab, 0xa5,
      0x8d, 0x3f, 0x12, 0xb0, 0xba, 0xc8, 0xd3, 0xd5, 0x38, 0x28, 0xc6, 0x6c,
      0x7a, 0x35, 0xe3, 0xd1, 0xeb, 0x0b, 0xdf, 0x2c, 0x08, 0xf2, 0x3d, 0x0e,
      0x4a, 0xb6, 0xa3, 0x24, 0x6e, 0x45, 0x6b, 0xf0, 0xfb, 0x86, 0x3d, 0x03,
      0x42, 0x3d, 0xbe, 0x43, 0x1b, 0xaf, 0x79, 0x96, 0x57, 0xc7, 0x81, 0x6a,
      0x61, 0x96, 0x62, 0xfe, 0x5b, 0x90, 0x0b, 0x75, 0x41, 0x07, 0xba, 0x5c,
      0xc0, 0x6b, 0x1d, 0x62, 0xc9, 0xa9, 0x27, 0x89, 0x1e, 0xfe, 0xe1, 0xa1,
      0xfd, 0x40, 0x4d, 0x7e},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: brainpoolP512r1
    // tcID: 210
    {210,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xd6,
      0x33, 0x1a, 0x5a, 0x96, 0x8e, 0x4d, 0x3b, 0xd7, 0x33, 0x6a, 0x42, 0x3b,
      0x41, 0x05, 0x5b, 0x68, 0xed, 0xd1, 0x00, 0xb8, 0xb9, 0x98, 0xd0, 0x0e,
      0xb9, 0xed, 0x93, 0x88, 0x1c, 0x21, 0xe3, 0x91, 0x2b, 0xb2, 0xee, 0x08,
      0xe7, 0x13, 0x27, 0xbe, 0x20, 0x58, 0x98, 0x67, 0x5e, 0xf7, 0xa4, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x2d, 0xff, 0x77, 0x3a, 0x88, 0x32, 0x9e,
      0x60, 0xd4, 0xa0, 0x6b, 0xf3, 0x26, 0xb4, 0x13, 0x83, 0xa4, 0x52, 0xb1,
      0x3b, 0x8c, 0x80, 0x74, 0x5e, 0xc7, 0x01, 0xb9, 0xc4, 0x7e, 0x11, 0x4e,
      0x16, 0x11, 0x53, 0x80, 0x26, 0x59, 0xc5, 0x72, 0x84, 0x0b, 0x56, 0xf7,
      0xaa, 0x77, 0xe4, 0x5c, 0x16, 0x2c, 0xe6, 0xe8, 0xfa, 0x19, 0x44, 0xaf,
      0xcc, 0x45, 0x5a, 0x11, 0x7f, 0x21, 0xde, 0x91, 0xcf, 0x7b, 0x0f, 0x3d,
      0x4e, 0x83, 0xa1, 0x3c, 0xe2, 0xaa, 0xa5, 0xe5, 0xb0, 0xb9, 0xef, 0x43,
      0x32, 0x2a, 0x84, 0xde, 0xb3, 0x11, 0x7c, 0xb7, 0x78, 0x4a, 0x86, 0xd8,
      0xa1, 0x86, 0xbc, 0xb1, 0x5b},
     {0x30, 0x81, 0x9b, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x09, 0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01,
      0x0d, 0x03, 0x81, 0x82, 0x00, 0x04, 0x21, 0x6e, 0xb6, 0x19, 0x45, 0x7f,
      0x11, 0x68, 0xac, 0x87, 0x3f, 0x5b, 0x56, 0x0a, 0x75, 0xdf, 0x80, 0x74,
      0x9f, 0x2b, 0xdf, 0x9a, 0xba, 0xc3, 0x1d, 0x65, 0x80, 0xe5, 0x21, 0xad,
      0x70, 0x36, 0x80, 0x13, 0xc3, 0xdb, 0x74, 0xf6, 0x63, 0x26, 0x3b, 0x61,
      0xeb, 0x12, 0xd4, 0xdc, 0xd5, 0x97, 0xad, 0x6c, 0x77, 0xce, 0xf6, 0xa5,
      0xd6, 0xd2, 0x24, 0x0b, 0x1e, 0x24, 0x4d, 0x76, 0x40, 0x3f, 0x69, 0x3f,
      0xb3, 0x17, 0xff, 0xc6, 0x02, 0xa7, 0xac, 0x31, 0x39, 0x91, 0xb0, 0xa6,
      0x2f, 0x7b, 0xf4, 0x69, 0xbb, 0xc9, 0x5b, 0x3f, 0xf3, 0x50, 0x03, 0xd9,
      0x72, 0xeb, 0x8e, 0xbc, 0xc8, 0xd4, 0x83, 0x3e, 0x6c, 0x24, 0xad, 0x52,
      0xd4, 0x9c, 0x1c, 0xe6, 0x24, 0x4c, 0x78, 0x89, 0xab, 0x67, 0xa8, 0x81,
      0x82, 0x32, 0xe1, 0x92, 0x94, 0x45, 0x42, 0x76, 0x3f, 0xc6, 0x67, 0xe5,
      0x79, 0x9d},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: brainpoolP224t1
    // tcID: 211
    {211,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xd6,
      0x33, 0x1a, 0x5a, 0x96, 0x8e, 0x4d, 0x3b, 0xd7, 0x33, 0x6a, 0x42, 0x3b,
      0x41, 0x05, 0x5b, 0x68, 0xed, 0xd1, 0x00, 0xb8, 0xb9, 0x98, 0xd0, 0x0e,
      0xb9, 0xed, 0x93, 0x88, 0x1c, 0x21, 0xe3, 0x91, 0x2b, 0xb2, 0xee, 0x08,
      0xe7, 0x13, 0x27, 0xbe, 0x20, 0x58, 0x98, 0x67, 0x5e, 0xf7, 0xa4, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x2d, 0xff, 0x77, 0x3a, 0x88, 0x32, 0x9e,
      0x60, 0xd4, 0xa0, 0x6b, 0xf3, 0x26, 0xb4, 0x13, 0x83, 0xa4, 0x52, 0xb1,
      0x3b, 0x8c, 0x80, 0x74, 0x5e, 0xc7, 0x01, 0xb9, 0xc4, 0x7e, 0x11, 0x4e,
      0x16, 0x11, 0x53, 0x80, 0x26, 0x59, 0xc5, 0x72, 0x84, 0x0b, 0x56, 0xf7,
      0xaa, 0x77, 0xe4, 0x5c, 0x16, 0x2c, 0xe6, 0xe8, 0xfa, 0x19, 0x44, 0xaf,
      0xcc, 0x45, 0x5a, 0x11, 0x7f, 0x21, 0xde, 0x91, 0xcf, 0x7b, 0x0f, 0x3d,
      0x4e, 0x83, 0xa1, 0x3c, 0xe2, 0xaa, 0xa5, 0xe5, 0xb0, 0xb9, 0xef, 0x43,
      0x32, 0x2a, 0x84, 0xde, 0xb3, 0x11, 0x7c, 0xb7, 0x78, 0x4a, 0x86, 0xd8,
      0xa1, 0x86, 0xbc, 0xb1, 0x5b},
     {0x30, 0x52, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x06,
      0x03, 0x3a, 0x00, 0x04, 0x69, 0x1b, 0x24, 0x00, 0x43, 0x80, 0xa5, 0x99,
      0x77, 0x02, 0x14, 0xd0, 0xc6, 0x0a, 0xb3, 0x7c, 0xfc, 0x80, 0x4c, 0xfa,
      0xa7, 0xae, 0xdd, 0x11, 0xcb, 0xf0, 0xa0, 0x54, 0x67, 0xeb, 0xec, 0x5e,
      0x33, 0x32, 0x2c, 0xda, 0x70, 0x7b, 0x84, 0x80, 0x86, 0xfd, 0x74, 0x02,
      0x44, 0xf6, 0x2c, 0xde, 0xb8, 0x67, 0xfc, 0x05, 0x72, 0x07, 0xfd, 0xe2},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: brainpoolP256t1
    // tcID: 212
    {212,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xd6,
      0x33, 0x1a, 0x5a, 0x96, 0x8e, 0x4d, 0x3b, 0xd7, 0x33, 0x6a, 0x42, 0x3b,
      0x41, 0x05, 0x5b, 0x68, 0xed, 0xd1, 0x00, 0xb8, 0xb9, 0x98, 0xd0, 0x0e,
      0xb9, 0xed, 0x93, 0x88, 0x1c, 0x21, 0xe3, 0x91, 0x2b, 0xb2, 0xee, 0x08,
      0xe7, 0x13, 0x27, 0xbe, 0x20, 0x58, 0x98, 0x67, 0x5e, 0xf7, 0xa4, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x2d, 0xff, 0x77, 0x3a, 0x88, 0x32, 0x9e,
      0x60, 0xd4, 0xa0, 0x6b, 0xf3, 0x26, 0xb4, 0x13, 0x83, 0xa4, 0x52, 0xb1,
      0x3b, 0x8c, 0x80, 0x74, 0x5e, 0xc7, 0x01, 0xb9, 0xc4, 0x7e, 0x11, 0x4e,
      0x16, 0x11, 0x53, 0x80, 0x26, 0x59, 0xc5, 0x72, 0x84, 0x0b, 0x56, 0xf7,
      0xaa, 0x77, 0xe4, 0x5c, 0x16, 0x2c, 0xe6, 0xe8, 0xfa, 0x19, 0x44, 0xaf,
      0xcc, 0x45, 0x5a, 0x11, 0x7f, 0x21, 0xde, 0x91, 0xcf, 0x7b, 0x0f, 0x3d,
      0x4e, 0x83, 0xa1, 0x3c, 0xe2, 0xaa, 0xa5, 0xe5, 0xb0, 0xb9, 0xef, 0x43,
      0x32, 0x2a, 0x84, 0xde, 0xb3, 0x11, 0x7c, 0xb7, 0x78, 0x4a, 0x86, 0xd8,
      0xa1, 0x86, 0xbc, 0xb1, 0x5b},
     {0x30, 0x5a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x08,
      0x03, 0x42, 0x00, 0x04, 0x22, 0xbf, 0x69, 0xf3, 0xa8, 0x1d, 0xfa, 0x1e,
      0xd8, 0xa9, 0x73, 0x01, 0x94, 0x36, 0x26, 0xe2, 0x03, 0x77, 0xb7, 0x8f,
      0x7e, 0x7d, 0x71, 0x4b, 0x88, 0x0d, 0xeb, 0x5a, 0x4a, 0x9c, 0x63, 0xa1,
      0x15, 0x91, 0xc2, 0xe4, 0x7b, 0x77, 0x74, 0x88, 0x99, 0x07, 0x71, 0x85,
      0x57, 0x68, 0xb9, 0xa4, 0x05, 0x0d, 0x61, 0xbf, 0x02, 0xd8, 0x4c, 0xc6,
      0xaa, 0x40, 0x44, 0x7a, 0x07, 0x50, 0x72, 0x85},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: brainpoolP320t1
    // tcID: 213
    {213,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xd6,
      0x33, 0x1a, 0x5a, 0x96, 0x8e, 0x4d, 0x3b, 0xd7, 0x33, 0x6a, 0x42, 0x3b,
      0x41, 0x05, 0x5b, 0x68, 0xed, 0xd1, 0x00, 0xb8, 0xb9, 0x98, 0xd0, 0x0e,
      0xb9, 0xed, 0x93, 0x88, 0x1c, 0x21, 0xe3, 0x91, 0x2b, 0xb2, 0xee, 0x08,
      0xe7, 0x13, 0x27, 0xbe, 0x20, 0x58, 0x98, 0x67, 0x5e, 0xf7, 0xa4, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x2d, 0xff, 0x77, 0x3a, 0x88, 0x32, 0x9e,
      0x60, 0xd4, 0xa0, 0x6b, 0xf3, 0x26, 0xb4, 0x13, 0x83, 0xa4, 0x52, 0xb1,
      0x3b, 0x8c, 0x80, 0x74, 0x5e, 0xc7, 0x01, 0xb9, 0xc4, 0x7e, 0x11, 0x4e,
      0x16, 0x11, 0x53, 0x80, 0x26, 0x59, 0xc5, 0x72, 0x84, 0x0b, 0x56, 0xf7,
      0xaa, 0x77, 0xe4, 0x5c, 0x16, 0x2c, 0xe6, 0xe8, 0xfa, 0x19, 0x44, 0xaf,
      0xcc, 0x45, 0x5a, 0x11, 0x7f, 0x21, 0xde, 0x91, 0xcf, 0x7b, 0x0f, 0x3d,
      0x4e, 0x83, 0xa1, 0x3c, 0xe2, 0xaa, 0xa5, 0xe5, 0xb0, 0xb9, 0xef, 0x43,
      0x32, 0x2a, 0x84, 0xde, 0xb3, 0x11, 0x7c, 0xb7, 0x78, 0x4a, 0x86, 0xd8,
      0xa1, 0x86, 0xbc, 0xb1, 0x5b},
     {0x30, 0x6a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x0a,
      0x03, 0x52, 0x00, 0x04, 0x76, 0x56, 0x83, 0x00, 0xe2, 0xb4, 0xc6, 0x88,
      0x61, 0x58, 0x9b, 0x49, 0x66, 0xe6, 0x7b, 0xc4, 0x14, 0x81, 0x1e, 0x40,
      0x11, 0x26, 0x0c, 0xb8, 0xbe, 0x5f, 0x88, 0x48, 0x69, 0xfa, 0x17, 0x9c,
      0xa8, 0xaf, 0x40, 0xf8, 0x00, 0x09, 0xe0, 0xa5, 0x8b, 0x17, 0xac, 0x3e,
      0x55, 0x1a, 0x77, 0x2e, 0x76, 0x68, 0x3c, 0x32, 0xe6, 0xe0, 0x91, 0x12,
      0x57, 0x25, 0x42, 0xd7, 0xc1, 0xfe, 0x3d, 0x49, 0xab, 0xb5, 0x6d, 0xa5,
      0x6d, 0x66, 0x91, 0x86, 0xe2, 0x62, 0x3d, 0xc7, 0x97, 0x12, 0x9d, 0xc0},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: brainpoolP384t1
    // tcID: 214
    {214,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xd6,
      0x33, 0x1a, 0x5a, 0x96, 0x8e, 0x4d, 0x3b, 0xd7, 0x33, 0x6a, 0x42, 0x3b,
      0x41, 0x05, 0x5b, 0x68, 0xed, 0xd1, 0x00, 0xb8, 0xb9, 0x98, 0xd0, 0x0e,
      0xb9, 0xed, 0x93, 0x88, 0x1c, 0x21, 0xe3, 0x91, 0x2b, 0xb2, 0xee, 0x08,
      0xe7, 0x13, 0x27, 0xbe, 0x20, 0x58, 0x98, 0x67, 0x5e, 0xf7, 0xa4, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x2d, 0xff, 0x77, 0x3a, 0x88, 0x32, 0x9e,
      0x60, 0xd4, 0xa0, 0x6b, 0xf3, 0x26, 0xb4, 0x13, 0x83, 0xa4, 0x52, 0xb1,
      0x3b, 0x8c, 0x80, 0x74, 0x5e, 0xc7, 0x01, 0xb9, 0xc4, 0x7e, 0x11, 0x4e,
      0x16, 0x11, 0x53, 0x80, 0x26, 0x59, 0xc5, 0x72, 0x84, 0x0b, 0x56, 0xf7,
      0xaa, 0x77, 0xe4, 0x5c, 0x16, 0x2c, 0xe6, 0xe8, 0xfa, 0x19, 0x44, 0xaf,
      0xcc, 0x45, 0x5a, 0x11, 0x7f, 0x21, 0xde, 0x91, 0xcf, 0x7b, 0x0f, 0x3d,
      0x4e, 0x83, 0xa1, 0x3c, 0xe2, 0xaa, 0xa5, 0xe5, 0xb0, 0xb9, 0xef, 0x43,
      0x32, 0x2a, 0x84, 0xde, 0xb3, 0x11, 0x7c, 0xb7, 0x78, 0x4a, 0x86, 0xd8,
      0xa1, 0x86, 0xbc, 0xb1, 0x5b},
     {0x30, 0x7a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x0c,
      0x03, 0x62, 0x00, 0x04, 0x33, 0x45, 0xdf, 0xfd, 0xed, 0x3c, 0x33, 0xf7,
      0xdc, 0xc1, 0x9b, 0xb8, 0x99, 0x7a, 0x39, 0xf2, 0xd6, 0x23, 0x0a, 0xbc,
      0xb7, 0x65, 0xd6, 0x14, 0x2c, 0x30, 0xbf, 0x32, 0x0c, 0x1f, 0xad, 0xff,
      0x53, 0x5f, 0xea, 0xfd, 0x85, 0x05, 0xeb, 0x3e, 0x61, 0x4d, 0xb7, 0x18,
      0x26, 0xc1, 0xe2, 0x58, 0x07, 0x7a, 0x1e, 0x60, 0x57, 0xad, 0xd7, 0x47,
      0x4f, 0x6d, 0x35, 0xdc, 0xe6, 0x84, 0x17, 0x81, 0x2e, 0x7b, 0x91, 0x9b,
      0x1c, 0x67, 0x30, 0x32, 0xb2, 0x8c, 0x45, 0xd0, 0xa9, 0x25, 0x1c, 0x43,
      0xa2, 0xa7, 0x3a, 0xb1, 0x52, 0xf6, 0x4f, 0xf8, 0xeb, 0xa4, 0xea, 0xb3,
      0x12, 0xfa, 0x73, 0xbd},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: brainpoolP512t1
    // tcID: 215
    {215,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0xd6,
      0x33, 0x1a, 0x5a, 0x96, 0x8e, 0x4d, 0x3b, 0xd7, 0x33, 0x6a, 0x42, 0x3b,
      0x41, 0x05, 0x5b, 0x68, 0xed, 0xd1, 0x00, 0xb8, 0xb9, 0x98, 0xd0, 0x0e,
      0xb9, 0xed, 0x93, 0x88, 0x1c, 0x21, 0xe3, 0x91, 0x2b, 0xb2, 0xee, 0x08,
      0xe7, 0x13, 0x27, 0xbe, 0x20, 0x58, 0x98, 0x67, 0x5e, 0xf7, 0xa4, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x2d, 0xff, 0x77, 0x3a, 0x88, 0x32, 0x9e,
      0x60, 0xd4, 0xa0, 0x6b, 0xf3, 0x26, 0xb4, 0x13, 0x83, 0xa4, 0x52, 0xb1,
      0x3b, 0x8c, 0x80, 0x74, 0x5e, 0xc7, 0x01, 0xb9, 0xc4, 0x7e, 0x11, 0x4e,
      0x16, 0x11, 0x53, 0x80, 0x26, 0x59, 0xc5, 0x72, 0x84, 0x0b, 0x56, 0xf7,
      0xaa, 0x77, 0xe4, 0x5c, 0x16, 0x2c, 0xe6, 0xe8, 0xfa, 0x19, 0x44, 0xaf,
      0xcc, 0x45, 0x5a, 0x11, 0x7f, 0x21, 0xde, 0x91, 0xcf, 0x7b, 0x0f, 0x3d,
      0x4e, 0x83, 0xa1, 0x3c, 0xe2, 0xaa, 0xa5, 0xe5, 0xb0, 0xb9, 0xef, 0x43,
      0x32, 0x2a, 0x84, 0xde, 0xb3, 0x11, 0x7c, 0xb7, 0x78, 0x4a, 0x86, 0xd8,
      0xa1, 0x86, 0xbc, 0xb1, 0x5b},
     {0x30, 0x81, 0x9b, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x09, 0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01,
      0x0e, 0x03, 0x81, 0x82, 0x00, 0x04, 0xa3, 0x67, 0x7c, 0x64, 0x6c, 0xd8,
      0x87, 0x68, 0x59, 0x40, 0xc2, 0x80, 0x76, 0xf5, 0x5c, 0xda, 0x74, 0x69,
      0x03, 0x28, 0x45, 0xf2, 0xcb, 0x2a, 0xf5, 0x1c, 0x61, 0x49, 0x2d, 0xc4,
      0x35, 0xaa, 0xa5, 0xb7, 0x71, 0xd8, 0xe1, 0x52, 0x84, 0x17, 0xcd, 0xeb,
      0x89, 0xb5, 0xf6, 0x29, 0xe0, 0x6b, 0x23, 0x4e, 0x21, 0x23, 0x6b, 0x9e,
      0xdf, 0x46, 0xc7, 0x02, 0x51, 0x77, 0xee, 0x65, 0xa8, 0xe9, 0x40, 0xf6,
      0x70, 0xd1, 0x0c, 0x72, 0x2c, 0xea, 0x35, 0x5b, 0xd3, 0xa5, 0xc8, 0x84,
      0x7a, 0x38, 0x32, 0x4b, 0x9a, 0x06, 0xa5, 0x0a, 0x95, 0xda, 0x4e, 0x70,
      0xbb, 0x49, 0x2c, 0xd0, 0x01, 0x94, 0xa8, 0x83, 0x09, 0x75, 0xdd, 0x1e,
      0x11, 0x5e, 0x19, 0x31, 0x55, 0x75, 0xff, 0x84, 0x1b, 0x30, 0xfd, 0x4a,
      0x3f, 0x8a, 0x44, 0x72, 0x5d, 0xfe, 0x28, 0x0d, 0x0a, 0xf5, 0x7f, 0xc8,
      0x0c, 0xc3},
     {},
     false,
     false},

    // Comment: invalid public key
    // tcID: 216
    {216,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x2b,
      0x9e, 0x57, 0x57, 0x2d, 0xa6, 0xcf, 0x4f, 0xb5, 0x8c, 0xb9, 0x4e, 0xab,
      0x8d, 0xf1, 0x93, 0x83, 0xa1, 0x36, 0xf2, 0x19, 0xf2, 0xa5, 0x15, 0x77,
      0x6a, 0x8b, 0xf4, 0x8e, 0x15, 0x38, 0xdd, 0x1d, 0x81, 0x19, 0x46, 0xc1,
      0x6d, 0x9f, 0x01, 0x84, 0xc9, 0xce, 0x5c, 0xdf, 0x1d, 0xac, 0x51, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x72, 0xa2, 0xed, 0x50, 0xe2, 0x84, 0xe7,
      0x82, 0x55, 0xb5, 0xd2, 0x13, 0x76, 0xda, 0x33, 0x16, 0xce, 0x70, 0x99,
      0x52, 0x4e, 0xd2, 0xda, 0x3b, 0x16, 0xb5, 0xd4, 0x2b, 0xd9, 0x9e, 0x5c,
      0x2f, 0x7f, 0x4c, 0x4d, 0x85, 0x87, 0x1c, 0xe0, 0xad, 0xa3, 0x82, 0x17,
      0xec, 0x8a, 0xcf, 0x3a, 0xd9, 0x7a, 0x77, 0xfe, 0xd3, 0x54, 0xd7, 0xce,
      0x12, 0x44, 0xc6, 0x3d, 0xe9, 0xb8, 0x04, 0xf8, 0xef, 0xc0, 0xed, 0x51,
      0x94, 0x13, 0x14, 0x9e, 0x3b, 0x59, 0xce, 0x71, 0x9b, 0x3e, 0xa5, 0x60,
      0xab, 0x8f, 0xfd, 0x80, 0x2b, 0x41, 0x5c, 0xe0, 0xf3, 0x8a, 0x7d, 0x07,
      0xdd, 0xfb, 0x40, 0x6f, 0x41},
     {0x30, 0x46, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x32, 0x00, 0x02,
      0x44, 0x24, 0x53, 0x0e, 0xa7, 0x0b, 0xac, 0xe9, 0x06, 0x01, 0xf8, 0xd5,
      0x86, 0x9e, 0x41, 0x79, 0xa6, 0xcd, 0x68, 0x9b, 0x6a, 0x18, 0xfd, 0xfe,
      0xc5, 0x0c, 0xec, 0xf1, 0x7c, 0xb8, 0x36, 0xd2, 0x48, 0x20, 0x21, 0x1a,
      0xda, 0x67, 0x81, 0x5b, 0x42, 0xc2, 0xc2, 0x60, 0x63, 0x03, 0xf6, 0x9e},
     {},
     false,
     false},

    // Comment: long form encoding of length of sequence
    // tcID: 217
    {217,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x81, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03,
      0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf,
      0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3,
      0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f,
      0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a,
      0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7,
      0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: long form encoding of length of sequence
    // tcID: 218
    {218,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x77, 0x30, 0x81, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03,
      0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf,
      0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3,
      0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f,
      0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a,
      0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7,
      0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of sequence contains leading 0
    // tcID: 219
    {219,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x82, 0x00, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of sequence contains leading 0
    // tcID: 220
    {220,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x82, 0x00, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: wrong length of sequence
    // tcID: 221
    {221,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x77, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: wrong length of sequence
    // tcID: 222
    {222,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x75, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: wrong length of sequence
    // tcID: 223
    {223,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x11, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: wrong length of sequence
    // tcID: 224
    {224,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x0f, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: uint32 overflow in length of sequence
    // tcID: 225
    {225,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x85, 0x01, 0x00, 0x00, 0x00, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00,
      0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8,
      0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7,
      0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55,
      0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95,
      0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83,
      0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc,
      0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b,
      0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: uint32 overflow in length of sequence
    // tcID: 226
    {226,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7b, 0x30, 0x85, 0x01, 0x00, 0x00, 0x00, 0x10, 0x06, 0x07, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00,
      0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8,
      0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7,
      0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55,
      0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95,
      0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83,
      0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc,
      0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b,
      0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: uint64 overflow in length of sequence
    // tcID: 227
    {227,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0x30,
      0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05,
      0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4,
      0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4,
      0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb,
      0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30,
      0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52,
      0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f,
      0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf,
      0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20,
      0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: uint64 overflow in length of sequence
    // tcID: 228
    {228,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7f, 0x30, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05,
      0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4,
      0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4,
      0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb,
      0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30,
      0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52,
      0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f,
      0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf,
      0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20,
      0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of sequence = 2**31 - 1
    // tcID: 229
    {229,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba,
      0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f,
      0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04,
      0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49,
      0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1,
      0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b,
      0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of sequence = 2**31 - 1
    // tcID: 230
    {230,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7a, 0x30, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba,
      0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f,
      0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04,
      0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49,
      0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1,
      0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b,
      0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of sequence = 2**32 - 1
    // tcID: 231
    {231,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x84, 0xff, 0xff, 0xff, 0xff, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba,
      0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f,
      0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04,
      0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49,
      0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1,
      0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b,
      0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of sequence = 2**32 - 1
    // tcID: 232
    {232,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7a, 0x30, 0x84, 0xff, 0xff, 0xff, 0xff, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba,
      0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f,
      0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04,
      0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49,
      0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1,
      0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b,
      0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of sequence = 2**40 - 1
    // tcID: 233
    {233,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x10, 0x06, 0x07, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00,
      0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8,
      0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7,
      0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55,
      0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95,
      0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83,
      0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc,
      0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b,
      0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of sequence = 2**40 - 1
    // tcID: 234
    {234,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7b, 0x30, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x06, 0x07, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00,
      0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8,
      0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7,
      0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55,
      0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95,
      0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83,
      0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc,
      0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b,
      0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of sequence = 2**64 - 1
    // tcID: 235
    {235,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x10,
      0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b,
      0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c,
      0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40,
      0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae,
      0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35,
      0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2,
      0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c,
      0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a,
      0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of sequence = 2**64 - 1
    // tcID: 236
    {236,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7e, 0x30, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b,
      0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c,
      0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40,
      0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae,
      0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35,
      0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2,
      0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c,
      0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a,
      0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: incorrect length of sequence
    // tcID: 237
    {237,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0xff, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: incorrect length of sequence
    // tcID: 238
    {238,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0xff, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: indefinite length without termination
    // tcID: 239
    {239,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x80, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: indefinite length without termination
    // tcID: 240
    {240,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x80, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: indefinite length without termination
    // tcID: 241
    {241,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x80, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: indefinite length without termination
    // tcID: 242
    {242,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x80, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: indefinite length without termination
    // tcID: 243
    {243,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x80, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: removing sequence
    // tcID: 244
    {244,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: removing sequence
    // tcID: 245
    {245,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x64, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15,
      0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8,
      0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf,
      0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4,
      0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee,
      0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a,
      0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02,
      0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0,
      0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: lonely sequence tag
    // tcID: 246
    {246,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: lonely sequence tag
    // tcID: 247
    {247,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x65, 0x30, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e,
      0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9,
      0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13,
      0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3,
      0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47,
      0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74,
      0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67,
      0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69,
      0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: appending 0's to sequence
    // tcID: 248
    {248,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51,
      0x00, 0x00},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: appending 0's to sequence
    // tcID: 249
    {249,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x12, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x00, 0x00, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: prepending 0's to sequence
    // tcID: 250
    {250,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x00, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: prepending 0's to sequence
    // tcID: 251
    {251,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x12, 0x00, 0x00, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: appending unused 0's to sequence
    // tcID: 252
    {252,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51,
      0x00, 0x00},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: appending unused 0's to sequence
    // tcID: 253
    {253,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x00, 0x00, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: appending null value to sequence
    // tcID: 254
    {254,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51,
      0x05, 0x00},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: appending null value to sequence
    // tcID: 255
    {255,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x12, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x05, 0x00, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including garbage
    // tcID: 256
    {256,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7b, 0x49, 0x81, 0x77, 0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00,
      0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8,
      0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7,
      0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55,
      0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95,
      0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83,
      0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc,
      0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b,
      0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including garbage
    // tcID: 257
    {257,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7a, 0x25, 0x00, 0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba,
      0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f,
      0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04,
      0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49,
      0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1,
      0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b,
      0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including garbage
    // tcID: 258
    {258,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51, 0x00, 0x04, 0xde, 0xad, 0xbe, 0xef},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including garbage
    // tcID: 259
    {259,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7b, 0x30, 0x15, 0x49, 0x81, 0x77, 0x30, 0x10, 0x06, 0x07, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00,
      0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8,
      0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7,
      0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55,
      0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95,
      0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83,
      0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc,
      0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b,
      0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including garbage
    // tcID: 260
    {260,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7a, 0x30, 0x14, 0x25, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba,
      0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f,
      0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04,
      0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49,
      0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1,
      0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b,
      0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including garbage
    // tcID: 261
    {261,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7e, 0x30, 0x12, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x00, 0x04,
      0xde, 0xad, 0xbe, 0xef, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c,
      0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40,
      0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae,
      0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35,
      0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2,
      0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c,
      0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a,
      0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including garbage
    // tcID: 262
    {262,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7b, 0x30, 0x15, 0x26, 0x0c, 0x49, 0x81, 0x77, 0x06, 0x07, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00,
      0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8,
      0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7,
      0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55,
      0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95,
      0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83,
      0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc,
      0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b,
      0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including garbage
    // tcID: 263
    {263,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7a, 0x30, 0x14, 0x26, 0x0b, 0x25, 0x00, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba,
      0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f,
      0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04,
      0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49,
      0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1,
      0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b,
      0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including garbage
    // tcID: 264
    {264,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7e, 0x30, 0x18, 0x26, 0x09, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x00, 0x04, 0xde, 0xad, 0xbe, 0xef, 0x06, 0x05, 0x2b,
      0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c,
      0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40,
      0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae,
      0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35,
      0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2,
      0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c,
      0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a,
      0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including garbage
    // tcID: 265
    {265,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7b, 0x30, 0x15, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x26, 0x0a, 0x49, 0x81, 0x77, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00,
      0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8,
      0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7,
      0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55,
      0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95,
      0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83,
      0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc,
      0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b,
      0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including garbage
    // tcID: 266
    {266,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x26, 0x09, 0x25, 0x00, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba,
      0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f,
      0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04,
      0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49,
      0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1,
      0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b,
      0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including garbage
    // tcID: 267
    {267,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7e, 0x30, 0x18, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x26, 0x07, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x00, 0x04,
      0xde, 0xad, 0xbe, 0xef, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c,
      0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40,
      0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae,
      0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35,
      0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2,
      0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c,
      0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a,
      0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including garbage
    // tcID: 268
    {268,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x23, 0x67, 0x49, 0x81,
      0x77, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8,
      0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7,
      0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55,
      0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95,
      0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83,
      0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc,
      0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b,
      0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including garbage
    // tcID: 269
    {269,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7a, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x23, 0x66, 0x25, 0x00,
      0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba,
      0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f,
      0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04,
      0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49,
      0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1,
      0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b,
      0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including garbage
    // tcID: 270
    {270,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7e, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x23, 0x64, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51, 0x00, 0x04, 0xde, 0xad, 0xbe, 0xef},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including undefined tags
    // tcID: 271
    {271,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7e, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00, 0x30, 0x76, 0x30, 0x10,
      0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b,
      0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c,
      0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40,
      0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae,
      0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35,
      0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2,
      0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c,
      0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a,
      0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including undefined tags
    // tcID: 272
    {272,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7c, 0xaa, 0x02, 0xaa, 0xbb, 0x30, 0x76, 0x30, 0x10, 0x06, 0x07,
      0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04,
      0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15,
      0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8,
      0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf,
      0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4,
      0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee,
      0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a,
      0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02,
      0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0,
      0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including undefined tags
    // tcID: 273
    {273,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7e, 0x30, 0x18, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00, 0x30, 0x10,
      0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b,
      0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c,
      0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40,
      0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae,
      0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35,
      0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2,
      0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c,
      0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a,
      0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including undefined tags
    // tcID: 274
    {274,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7c, 0x30, 0x16, 0xaa, 0x02, 0xaa, 0xbb, 0x30, 0x10, 0x06, 0x07,
      0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04,
      0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15,
      0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8,
      0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf,
      0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4,
      0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee,
      0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a,
      0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02,
      0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0,
      0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including undefined tags
    // tcID: 275
    {275,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7e, 0x30, 0x18, 0x26, 0x0f, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00,
      0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b,
      0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c,
      0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40,
      0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae,
      0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35,
      0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2,
      0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c,
      0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a,
      0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including undefined tags
    // tcID: 276
    {276,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7c, 0x30, 0x16, 0x26, 0x0d, 0xaa, 0x02, 0xaa, 0xbb, 0x06, 0x07,
      0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04,
      0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15,
      0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8,
      0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf,
      0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4,
      0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee,
      0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a,
      0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02,
      0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0,
      0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including undefined tags
    // tcID: 277
    {277,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7e, 0x30, 0x18, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x26, 0x0d, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00, 0x06, 0x05, 0x2b,
      0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c,
      0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40,
      0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae,
      0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35,
      0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2,
      0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c,
      0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a,
      0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including undefined tags
    // tcID: 278
    {278,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7c, 0x30, 0x16, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x26, 0x0b, 0xaa, 0x02, 0xaa, 0xbb, 0x06, 0x05, 0x2b, 0x81, 0x04,
      0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15,
      0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8,
      0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf,
      0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4,
      0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee,
      0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a,
      0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02,
      0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0,
      0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including undefined tags
    // tcID: 279
    {279,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7e, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x23, 0x6a, 0xaa, 0x00,
      0xbb, 0x00, 0xcd, 0x00, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c,
      0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40,
      0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae,
      0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35,
      0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2,
      0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c,
      0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a,
      0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: including undefined tags
    // tcID: 280
    {280,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7c, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x23, 0x68, 0xaa, 0x02,
      0xaa, 0xbb, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15,
      0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8,
      0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf,
      0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4,
      0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee,
      0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a,
      0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02,
      0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0,
      0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: truncated length of sequence
    // tcID: 281
    {281,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x81},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: truncated length of sequence
    // tcID: 282
    {282,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x66, 0x30, 0x81, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c,
      0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40,
      0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae,
      0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35,
      0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2,
      0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c,
      0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a,
      0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: Replacing sequence with NULL
    // tcID: 283
    {283,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x05, 0x00},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: Replacing sequence with NULL
    // tcID: 284
    {284,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x66, 0x05, 0x00, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c,
      0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40,
      0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae,
      0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35,
      0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2,
      0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c,
      0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a,
      0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: changing tag value of sequence
    // tcID: 285
    {285,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x2e, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: changing tag value of sequence
    // tcID: 286
    {286,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x2f, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: changing tag value of sequence
    // tcID: 287
    {287,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x31, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: changing tag value of sequence
    // tcID: 288
    {288,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x32, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: changing tag value of sequence
    // tcID: 289
    {289,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0xff, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: changing tag value of sequence
    // tcID: 290
    {290,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x2e, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: changing tag value of sequence
    // tcID: 291
    {291,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x2f, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: changing tag value of sequence
    // tcID: 292
    {292,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x31, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: changing tag value of sequence
    // tcID: 293
    {293,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x32, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: changing tag value of sequence
    // tcID: 294
    {294,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0xff, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: dropping value of sequence
    // tcID: 295
    {295,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x00},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: dropping value of sequence
    // tcID: 296
    {296,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x66, 0x30, 0x00, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c,
      0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40,
      0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae,
      0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35,
      0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2,
      0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c,
      0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a,
      0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: truncated sequence
    // tcID: 297
    {297,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x75, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: truncated sequence
    // tcID: 298
    {298,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x75, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01,
      0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2,
      0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c,
      0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05,
      0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5,
      0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d,
      0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73,
      0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87,
      0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7,
      0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: truncated sequence
    // tcID: 299
    {299,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x75, 0x30, 0x0f, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x03, 0x62, 0x00, 0x04, 0xc2,
      0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c,
      0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05,
      0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5,
      0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d,
      0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73,
      0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87,
      0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7,
      0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: truncated sequence
    // tcID: 300
    {300,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x75, 0x30, 0x0f, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01,
      0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2,
      0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c,
      0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05,
      0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5,
      0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d,
      0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73,
      0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87,
      0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7,
      0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: indefinite length
    // tcID: 301
    {301,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x80, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51,
      0x00, 0x00},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: indefinite length
    // tcID: 302
    {302,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x80, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x00, 0x00, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: indefinite length with truncated delimiter
    // tcID: 303
    {303,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x80, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84,
      0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7,
      0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4,
      0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47,
      0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2,
      0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf,
      0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13,
      0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51, 0x00},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: indefinite length with truncated delimiter
    // tcID: 304
    {304,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x77, 0x30, 0x80, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x00, 0x03,
      0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf,
      0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3,
      0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f,
      0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a,
      0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7,
      0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: indefinite length with additional element
    // tcID: 305
    {305,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x80, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51,
      0x05, 0x00, 0x00, 0x00},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: indefinite length with additional element
    // tcID: 306
    {306,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7a, 0x30, 0x80, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x05, 0x00, 0x00, 0x00,
      0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba,
      0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f,
      0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04,
      0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49,
      0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1,
      0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b,
      0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: indefinite length with truncated element
    // tcID: 307
    {307,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x80, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51,
      0x06, 0x08, 0x11, 0x22, 0x00, 0x00},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: indefinite length with truncated element
    // tcID: 308
    {308,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7c, 0x30, 0x80, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x06, 0x08, 0x11, 0x22,
      0x00, 0x00, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15,
      0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8,
      0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf,
      0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4,
      0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee,
      0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a,
      0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02,
      0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0,
      0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: indefinite length with garbage
    // tcID: 309
    {309,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x80, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51,
      0x00, 0x00, 0xfe, 0x02, 0xbe, 0xef},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: indefinite length with garbage
    // tcID: 310
    {310,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7c, 0x30, 0x80, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x00, 0x00, 0xfe, 0x02,
      0xbe, 0xef, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15,
      0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8,
      0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf,
      0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4,
      0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee,
      0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a,
      0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02,
      0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0,
      0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: indefinite length with nonempty EOC
    // tcID: 311
    {311,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x80, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51,
      0x00, 0x02, 0xbe, 0xef},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: indefinite length with nonempty EOC
    // tcID: 312
    {312,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7a, 0x30, 0x80, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x00, 0x02, 0xbe, 0xef,
      0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba,
      0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f,
      0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04,
      0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49,
      0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1,
      0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b,
      0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: prepend empty sequence
    // tcID: 313
    {313,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: prepend empty sequence
    // tcID: 314
    {314,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x12, 0x30, 0x00, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: append empty sequence
    // tcID: 315
    {315,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51,
      0x30, 0x00},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: append empty sequence
    // tcID: 316
    {316,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x12, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x30, 0x00, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: append garbage with high tag number
    // tcID: 317
    {317,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x79, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51,
      0xbf, 0x7f, 0x00},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: append garbage with high tag number
    // tcID: 318
    {318,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x79, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0xbf, 0x7f, 0x00, 0x03,
      0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84,
      0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2,
      0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e,
      0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97,
      0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19,
      0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5,
      0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29,
      0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed,
      0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: sequence of sequence
    // tcID: 319
    {319,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: sequence of sequence
    // tcID: 320
    {320,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x12, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: truncated sequence: removed last 1 elements
    // tcID: 321
    {321,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x12, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: truncated sequence: removed last 1 elements
    // tcID: 322
    {322,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x6f, 0x30, 0x09, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8,
      0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7,
      0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55,
      0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95,
      0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83,
      0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc,
      0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b,
      0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: repeating element in sequence
    // tcID: 323
    {323,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x81, 0xda, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00,
      0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1,
      0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e,
      0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2,
      0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2,
      0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa,
      0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc,
      0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83,
      0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12,
      0x51, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8,
      0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7,
      0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55,
      0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95,
      0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83,
      0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc,
      0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b,
      0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: repeating element in sequence
    // tcID: 324
    {324,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7d, 0x30, 0x17, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x06, 0x05, 0x2b, 0x81,
      0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e,
      0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9,
      0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13,
      0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3,
      0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47,
      0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74,
      0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67,
      0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69,
      0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: long form encoding of length of oid
    // tcID: 325
    {325,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x77, 0x30, 0x11, 0x06, 0x81, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03,
      0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf,
      0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3,
      0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f,
      0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a,
      0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7,
      0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: long form encoding of length of oid
    // tcID: 326
    {326,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x77, 0x30, 0x11, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x81, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03,
      0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf,
      0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3,
      0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f,
      0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a,
      0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7,
      0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of oid contains leading 0
    // tcID: 327
    {327,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x12, 0x06, 0x82, 0x00, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of oid contains leading 0
    // tcID: 328
    {328,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x12, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x82, 0x00, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: wrong length of oid
    // tcID: 329
    {329,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: wrong length of oid
    // tcID: 330
    {330,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x06, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: wrong length of oid
    // tcID: 331
    {331,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x06, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: wrong length of oid
    // tcID: 332
    {332,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x04, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: uint32 overflow in length of oid
    // tcID: 333
    {333,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7b, 0x30, 0x15, 0x06, 0x85, 0x01, 0x00, 0x00, 0x00, 0x07, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00,
      0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8,
      0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7,
      0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55,
      0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95,
      0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83,
      0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc,
      0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b,
      0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: uint32 overflow in length of oid
    // tcID: 334
    {334,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7b, 0x30, 0x15, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x85, 0x01, 0x00, 0x00, 0x00, 0x05, 0x2b, 0x81, 0x04, 0x00,
      0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8,
      0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7,
      0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55,
      0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95,
      0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83,
      0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc,
      0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b,
      0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: uint64 overflow in length of oid
    // tcID: 335
    {335,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7f, 0x30, 0x19, 0x06, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05,
      0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4,
      0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4,
      0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb,
      0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30,
      0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52,
      0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f,
      0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf,
      0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20,
      0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: uint64 overflow in length of oid
    // tcID: 336
    {336,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7f, 0x30, 0x19, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
      0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4,
      0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4,
      0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb,
      0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30,
      0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52,
      0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f,
      0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf,
      0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20,
      0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of oid = 2**31 - 1
    // tcID: 337
    {337,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7a, 0x30, 0x14, 0x06, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba,
      0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f,
      0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04,
      0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49,
      0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1,
      0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b,
      0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of oid = 2**31 - 1
    // tcID: 338
    {338,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba,
      0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f,
      0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04,
      0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49,
      0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1,
      0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b,
      0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of oid = 2**32 - 1
    // tcID: 339
    {339,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7a, 0x30, 0x14, 0x06, 0x84, 0xff, 0xff, 0xff, 0xff, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba,
      0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f,
      0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04,
      0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49,
      0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1,
      0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b,
      0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of oid = 2**32 - 1
    // tcID: 340
    {340,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x84, 0xff, 0xff, 0xff, 0xff, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba,
      0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f,
      0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04,
      0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49,
      0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1,
      0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b,
      0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of oid = 2**40 - 1
    // tcID: 341
    {341,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7b, 0x30, 0x15, 0x06, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00,
      0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8,
      0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7,
      0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55,
      0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95,
      0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83,
      0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc,
      0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b,
      0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of oid = 2**40 - 1
    // tcID: 342
    {342,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7b, 0x30, 0x15, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2b, 0x81, 0x04, 0x00,
      0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8,
      0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7,
      0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55,
      0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95,
      0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83,
      0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc,
      0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b,
      0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of oid = 2**64 - 1
    // tcID: 343
    {343,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7e, 0x30, 0x18, 0x06, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b,
      0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c,
      0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40,
      0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae,
      0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35,
      0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2,
      0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c,
      0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a,
      0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of oid = 2**64 - 1
    // tcID: 344
    {344,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7e, 0x30, 0x18, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2b,
      0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c,
      0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40,
      0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae,
      0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35,
      0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2,
      0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c,
      0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a,
      0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: incorrect length of oid
    // tcID: 345
    {345,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0xff, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: incorrect length of oid
    // tcID: 346
    {346,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0xff, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: removing oid
    // tcID: 347
    {347,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x6d, 0x30, 0x07, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03,
      0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84,
      0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2,
      0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e,
      0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97,
      0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19,
      0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5,
      0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29,
      0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed,
      0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: lonely oid tag
    // tcID: 348
    {348,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x6e, 0x30, 0x08, 0x06, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba,
      0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f,
      0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04,
      0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49,
      0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1,
      0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b,
      0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: lonely oid tag
    // tcID: 349
    {349,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x70, 0x30, 0x0a, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15,
      0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8,
      0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf,
      0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4,
      0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee,
      0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a,
      0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02,
      0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0,
      0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: appending 0's to oid
    // tcID: 350
    {350,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x12, 0x06, 0x09, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x00, 0x00, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: appending 0's to oid
    // tcID: 351
    {351,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x12, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x07, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x00, 0x00, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     true},

    // Comment: prepending 0's to oid
    // tcID: 352
    {352,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x12, 0x06, 0x09, 0x00, 0x00, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: prepending 0's to oid
    // tcID: 353
    {353,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x12, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x07, 0x00, 0x00, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     true},

    // Comment: appending unused 0's to oid
    // tcID: 354
    {354,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x12, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x00, 0x00, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: appending null value to oid
    // tcID: 355
    {355,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x12, 0x06, 0x09, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x05, 0x00, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: appending null value to oid
    // tcID: 356
    {356,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x12, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x07, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x05, 0x00, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     true},

    // Comment: truncated length of oid
    // tcID: 357
    {357,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x6f, 0x30, 0x09, 0x06, 0x81, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00,
      0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8,
      0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7,
      0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55,
      0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95,
      0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83,
      0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc,
      0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b,
      0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: truncated length of oid
    // tcID: 358
    {358,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x71, 0x30, 0x0b, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x81, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e,
      0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9,
      0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13,
      0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3,
      0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47,
      0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74,
      0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67,
      0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69,
      0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: Replacing oid with NULL
    // tcID: 359
    {359,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x6f, 0x30, 0x09, 0x05, 0x00, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00,
      0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8,
      0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7,
      0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55,
      0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95,
      0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83,
      0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc,
      0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b,
      0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: Replacing oid with NULL
    // tcID: 360
    {360,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x71, 0x30, 0x0b, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x05, 0x00, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e,
      0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9,
      0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13,
      0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3,
      0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47,
      0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74,
      0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67,
      0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69,
      0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: changing tag value of oid
    // tcID: 361
    {361,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x04, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: changing tag value of oid
    // tcID: 362
    {362,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x05, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: changing tag value of oid
    // tcID: 363
    {363,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x07, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: changing tag value of oid
    // tcID: 364
    {364,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x08, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: changing tag value of oid
    // tcID: 365
    {365,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0xff, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: changing tag value of oid
    // tcID: 366
    {366,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x04, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: changing tag value of oid
    // tcID: 367
    {367,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x05, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: changing tag value of oid
    // tcID: 368
    {368,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x07, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: changing tag value of oid
    // tcID: 369
    {369,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x08, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: changing tag value of oid
    // tcID: 370
    {370,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0xff, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: dropping value of oid
    // tcID: 371
    {371,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x6f, 0x30, 0x09, 0x06, 0x00, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00,
      0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8,
      0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7,
      0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55,
      0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95,
      0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83,
      0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc,
      0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b,
      0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: dropping value of oid
    // tcID: 372
    {372,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x71, 0x30, 0x0b, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x00, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e,
      0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9,
      0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13,
      0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3,
      0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47,
      0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74,
      0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67,
      0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69,
      0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: modify first byte of oid
    // tcID: 373
    {373,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x28, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: modify first byte of oid
    // tcID: 374
    {374,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x29, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     true},

    // Comment: modify last byte of oid
    // tcID: 375
    {375,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x81, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: modify last byte of oid
    // tcID: 376
    {376,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0xa2, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     true},

    // Comment: truncated oid
    // tcID: 377
    {377,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x75, 0x30, 0x0f, 0x06, 0x06, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2,
      0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c,
      0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05,
      0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5,
      0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d,
      0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73,
      0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87,
      0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7,
      0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: truncated oid
    // tcID: 378
    {378,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x75, 0x30, 0x0f, 0x06, 0x06, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01,
      0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2,
      0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c,
      0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05,
      0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5,
      0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d,
      0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73,
      0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87,
      0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7,
      0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: truncated oid
    // tcID: 379
    {379,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x75, 0x30, 0x0f, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x04, 0x2b, 0x81, 0x04, 0x00, 0x03, 0x62, 0x00, 0x04, 0xc2,
      0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c,
      0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05,
      0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5,
      0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d,
      0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73,
      0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87,
      0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7,
      0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     true},

    // Comment: truncated oid
    // tcID: 380
    {380,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x75, 0x30, 0x0f, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x04, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2,
      0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c,
      0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05,
      0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5,
      0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d,
      0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73,
      0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87,
      0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7,
      0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     true},

    // Comment: wrong oid
    // tcID: 381
    {381,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x74, 0x30, 0x0e, 0x06, 0x05, 0x2b, 0x0e, 0x03, 0x02, 0x1a, 0x06,
      0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe,
      0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77,
      0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4,
      0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e,
      0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe,
      0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2,
      0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a,
      0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13,
      0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: wrong oid
    // tcID: 382
    {382,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x12, 0x06, 0x09, 0x60, 0x86, 0x48, 0x01, 0x65, 0x03,
      0x04, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: wrong oid
    // tcID: 383
    {383,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x0e, 0x03, 0x02, 0x1a, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     true},

    // Comment: wrong oid
    // tcID: 384
    {384,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x60, 0x86, 0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x01,
      0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba,
      0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f,
      0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04,
      0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49,
      0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1,
      0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b,
      0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     true},

    // Comment: longer oid
    // tcID: 385
    {385,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x77, 0x30, 0x11, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03,
      0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf,
      0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3,
      0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f,
      0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a,
      0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7,
      0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: longer oid
    // tcID: 386
    {386,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x77, 0x30, 0x11, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x06, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x01, 0x03,
      0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf,
      0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3,
      0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f,
      0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a,
      0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7,
      0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     true},

    // Comment: oid with modified node
    // tcID: 387
    {387,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x11, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: oid with modified node
    // tcID: 388
    {388,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7a, 0x30, 0x14, 0x06, 0x0b, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x88, 0x80, 0x80, 0x80, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba,
      0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f,
      0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04,
      0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49,
      0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1,
      0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b,
      0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: oid with modified node
    // tcID: 389
    {389,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x32, 0x03, 0x62, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     true},

    // Comment: oid with modified node
    // tcID: 390
    {390,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x2b, 0x81, 0x04, 0x00, 0x88, 0x80, 0x80, 0x80, 0x22,
      0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba,
      0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f,
      0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04,
      0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49,
      0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1,
      0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b,
      0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     true},

    // Comment: large integer in oid
    // tcID: 391
    {391,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7f, 0x30, 0x19, 0x06, 0x10, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x82, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x01, 0x06, 0x05,
      0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4,
      0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4,
      0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb,
      0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30,
      0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52,
      0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f,
      0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf,
      0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20,
      0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: large integer in oid
    // tcID: 392
    {392,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7f, 0x30, 0x19, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x0e, 0x2b, 0x81, 0x04, 0x00, 0x82, 0x80, 0x80, 0x80, 0x80,
      0x80, 0x80, 0x80, 0x80, 0x22, 0x03, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4,
      0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4,
      0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb,
      0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30,
      0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52,
      0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f,
      0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf,
      0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20,
      0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     true},

    // Comment: oid with invalid node
    // tcID: 393
    {393,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x77, 0x30, 0x11, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0xe0, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03,
      0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf,
      0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3,
      0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f,
      0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a,
      0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7,
      0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: oid with invalid node
    // tcID: 394
    {394,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x77, 0x30, 0x11, 0x06, 0x08, 0x2a, 0x80, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03,
      0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf,
      0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3,
      0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f,
      0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a,
      0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7,
      0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: oid with invalid node
    // tcID: 395
    {395,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x77, 0x30, 0x11, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x06, 0x2b, 0x81, 0x04, 0x00, 0x22, 0xe0, 0x03,
      0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf,
      0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3,
      0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f,
      0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a,
      0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7,
      0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     true},

    // Comment: oid with invalid node
    // tcID: 396
    {396,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x77, 0x30, 0x11, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x06, 0x2b, 0x80, 0x81, 0x04, 0x00, 0x22, 0x03,
      0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf,
      0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3,
      0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f,
      0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a,
      0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7,
      0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     true},

    // Comment: long form encoding of length of bit string
    // tcID: 397
    {397,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x77, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x81,
      0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf,
      0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3,
      0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f,
      0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a,
      0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7,
      0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of bit string contains leading 0
    // tcID: 398
    {398,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x82, 0x00, 0x62,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: wrong length of bit string
    // tcID: 399
    {399,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x63, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: wrong length of bit string
    // tcID: 400
    {400,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x61, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: uint32 overflow in length of bit string
    // tcID: 401
    {401,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x85, 0x01, 0x00,
      0x00, 0x00, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8,
      0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7,
      0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55,
      0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95,
      0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83,
      0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc,
      0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b,
      0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: uint64 overflow in length of bit string
    // tcID: 402
    {402,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7f, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x89, 0x01, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x00, 0x04, 0xc2, 0xbe, 0xd4,
      0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4,
      0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb,
      0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30,
      0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52,
      0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f,
      0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf,
      0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20,
      0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of bit string = 2**31 - 1
    // tcID: 403
    {403,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7a, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x84, 0x7f, 0xff,
      0xff, 0xff, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba,
      0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f,
      0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04,
      0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49,
      0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1,
      0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b,
      0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of bit string = 2**32 - 1
    // tcID: 404
    {404,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7a, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x84, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20,
      0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6,
      0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba,
      0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f,
      0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04,
      0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49,
      0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1,
      0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b,
      0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of bit string = 2**40 - 1
    // tcID: 405
    {405,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x85, 0xff, 0xff,
      0xff, 0xff, 0xff, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8,
      0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3,
      0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7,
      0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55,
      0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95,
      0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83,
      0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc,
      0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b,
      0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: length of bit string = 2**64 - 1
    // tcID: 406
    {406,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x7e, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x88, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c,
      0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40,
      0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae,
      0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35,
      0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a,
      0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2,
      0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c,
      0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a,
      0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: incorrect length of bit string
    // tcID: 407
    {407,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0xff, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: lonely bit string tag
    // tcID: 408
    {408,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x13, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: appending 0's to bit string
    // tcID: 409
    {409,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x64, 0x00, 0x04,
      0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11, 0xb1, 0xa1,
      0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf, 0x6e, 0xef,
      0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a, 0xf2, 0x08,
      0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0, 0xf2, 0x79,
      0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5, 0xfa, 0xa2,
      0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91, 0xcc, 0x80,
      0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6, 0x83, 0x51,
      0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03, 0x12, 0x51,
      0x00, 0x00},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: prepending 0's to bit string
    // tcID: 410
    {410,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
      0x3e, 0x8a, 0xdc, 0x46, 0x5d, 0x94, 0xbc, 0x21, 0x34, 0x6d, 0x8f, 0x34,
      0x19, 0x07, 0xa3, 0xc2, 0x7a, 0x25, 0x62, 0xdc, 0xb4, 0x9a, 0x3a, 0xa1,
      0x64, 0x03, 0x62, 0x00, 0x04, 0x01, 0x03, 0x2d, 0xa2, 0xd7, 0x04, 0xcb,
      0xfa, 0x6b, 0x03, 0xab, 0x57, 0xa9, 0x3c, 0x82, 0xa4, 0xbb, 0xb5, 0xe8,
      0x1a, 0xb3, 0x60, 0xa8, 0x7b, 0x9e, 0xd2, 0x43, 0xdf, 0x47, 0xae, 0x03,
      0xca, 0xcf, 0x0d, 0x11, 0x2b, 0xfe, 0x7a, 0xfd, 0x42, 0x4f, 0xde, 0x5a,
      0x6c, 0xee, 0xf3, 0x59, 0x0e, 0x07, 0x3d, 0xf0, 0x0b, 0xd4, 0xe9, 0x92,
      0x12, 0xf3, 0x76, 0xe0, 0x00, 0xdf, 0xe8, 0xae, 0xd2, 0x34, 0x3a, 0x63,
      0x31, 0xe3, 0x10, 0x8f, 0x01, 0xc6, 0xf2, 0xb9, 0xe9, 0xd1, 0x2a, 0xbd,
      0x98, 0x04, 0x39, 0xdd, 0x79, 0x38, 0x62, 0xa1, 0xdd, 0x2c, 0x23, 0xed,
      0x32, 0xd0, 0x84, 0x2c, 0x6f},
     {0x30, 0x78, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x64, 0x00, 0x00,
      0x00, 0x04, 0xc2, 0xbe, 0xd4, 0x8c, 0x5e, 0x15, 0xe8, 0x20, 0x84, 0x11,
      0xb1, 0xa1, 0x4c, 0x77, 0xc4, 0x40, 0xb9, 0xa8, 0xc3, 0xb6, 0xb2, 0xaf,
      0x6e, 0xef, 0x05, 0xe4, 0xfb, 0xae, 0x13, 0xcf, 0xe7, 0xba, 0x5e, 0x9a,
      0xf2, 0x08, 0xc5, 0x4e, 0x30, 0x35, 0xe3, 0xb4, 0x55, 0x9f, 0x97, 0xb0,
      0xf2, 0x79, 0x8d, 0xbe, 0x52, 0x2a, 0x47, 0xee, 0x95, 0x04, 0x19, 0xb5,
      0xfa, 0xa2, 0x73, 0xd2, 0x4f, 0xf2, 0x74, 0x8a, 0x83, 0x49, 0xc5, 0x91,
      0xcc, 0x80, 0x87, 0x1a, 0xcf, 0x3c, 0x67, 0x02, 0xcc, 0xe1, 0x29, 0xc6,
      0x83, 0x51, 0xa7, 0x13, 0x20, 0x7a, 0x69, 0xf0, 0x2b, 0x5b, 0xed, 0x03,
      0x12, 0x51},
     {0x40, 0xc3, 0x44, 0xfb, 0x11, 0x85, 0xa5, 0xa9, 0x7d, 0xd0, 0x0b, 0x11,
      0x4f, 0x1b, 0x9c, 0x5c, 0xe4, 0x00, 0x9f, 0x90, 0xc5, 0x93, 0xf2, 0x36,
      0xfe, 0x46, 0x55, 0x18, 0xf9, 0xff, 0x27, 0x32, 0x6a, 0x42, 0x1e, 0x05,
      0xb5, 0xbc, 0x1b, 0xfe, 0x37, 0x68, 0xd5, 0xbe, 0xcb, 0x9e, 0xc7, 0x97},
     true,
     false},

    // Comment: appending null value to bit string
    // tcID: 411
    {411,
     {0x30, 0x81, 0xb6, 0x02, 0x01, 0x00, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22,
      0x04, 0x81, 0x9e, 0x30, 0x81, 0x9b, 0x02, 0x01, 0x01, 0x04, 0x30, 0x4b,
      0x06, 0x5d, 0x2d, 0xbb, 0xad, 0x95, 0xd7, 0xee, 0xbe, 0xd0, 0x0a, 0x3e,
      0x79, 0xf7, 0x72, 0xcc, 0xdd, 0xfd, 0x93, 0x10, 0x1c, 0x1b, 0x1f, 0x39,
    