/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef p256ecdsa_sha256_vectors_h__
#define p256ecdsa_sha256_vectors_h__

#include "testvectors_base/test-structs.h"

const EcdsaTestVector kP256EcdsaSha256Vectors[] = {

    // Comment: signature malleability
    // tcID: 1
    {SEC_OID_SHA256,
     1,
     {0x30, 0x44, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x20, 0x4c, 0xd6, 0x0b, 0x85, 0x5d, 0x44, 0x2f, 0x5b, 0x3c, 0x7b,
      0x11, 0xeb, 0x6c, 0x4e, 0x0a, 0xe7, 0x52, 0x5f, 0xe7, 0x10, 0xfa, 0xb9,
      0xaa, 0x7c, 0x77, 0xa6, 0x7f, 0x79, 0xe6, 0xfa, 0xdd, 0x76},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: Legacy:ASN encoding of s misses leading 0
    // tcID: 2
    {SEC_OID_SHA256,
     2,
     {0x30, 0x44, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x20, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84,
      0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d,
      0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: valid
    // tcID: 3
    {SEC_OID_SHA256,
     3,
     {0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: long form encoding of length of sequence
    // tcID: 4
    {SEC_OID_SHA256,
     4,
     {0x30, 0x81, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d,
      0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e,
      0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5,
      0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c,
      0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of sequence contains leading 0
    // tcID: 5
    {SEC_OID_SHA256,
     5,
     {0x30, 0x82, 0x00, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b,
      0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e,
      0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a,
      0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4,
      0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1,
      0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of sequence
    // tcID: 6
    {SEC_OID_SHA256,
     6,
     {0x30, 0x46, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of sequence
    // tcID: 7
    {SEC_OID_SHA256,
     7,
     {0x30, 0x44, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint32 overflow in length of sequence
    // tcID: 8
    {SEC_OID_SHA256,
     8,
     {0x30, 0x85, 0x01, 0x00, 0x00, 0x00, 0x45, 0x02, 0x20, 0x2b, 0xa3,
      0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19,
      0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59,
      0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00,
      0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee,
      0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d,
      0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint64 overflow in length of sequence
    // tcID: 9
    {SEC_OID_SHA256,
     9,
     {0x30, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x02,
      0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9,
      0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8,
      0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00,
      0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14,
      0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08,
      0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of sequence = 2**31 - 1
    // tcID: 10
    {SEC_OID_SHA256,
     10,
     {0x30, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x02, 0x20, 0x2b, 0xa3, 0xa8,
      0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a,
      0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8,
      0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3,
      0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14,
      0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4,
      0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of sequence = 2**32 - 1
    // tcID: 11
    {SEC_OID_SHA256,
     11,
     {0x30, 0x84, 0xff, 0xff, 0xff, 0xff, 0x02, 0x20, 0x2b, 0xa3, 0xa8,
      0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a,
      0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8,
      0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3,
      0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14,
      0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4,
      0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of sequence = 2**40 - 1
    // tcID: 12
    {SEC_OID_SHA256,
     12,
     {0x30, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x20, 0x2b, 0xa3,
      0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19,
      0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59,
      0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00,
      0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee,
      0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d,
      0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of sequence = 2**64 - 1
    // tcID: 13
    {SEC_OID_SHA256,
     13,
     {0x30, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x20,
      0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1,
      0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59,
      0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3,
      0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93,
      0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: incorrect length of sequence
    // tcID: 14
    {SEC_OID_SHA256,
     14,
     {0x30, 0xff, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length without termination
    // tcID: 15
    {SEC_OID_SHA256,
     15,
     {0x30, 0x80, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length without termination
    // tcID: 16
    {SEC_OID_SHA256,
     16,
     {0x30, 0x45, 0x02, 0x80, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length without termination
    // tcID: 17
    {SEC_OID_SHA256,
     17,
     {0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x80, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: removing sequence
    // tcID: 18
    {SEC_OID_SHA256,
     18,
     {},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: lonely sequence tag
    // tcID: 19
    {SEC_OID_SHA256,
     19,
     {0x30},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending 0's to sequence
    // tcID: 20
    {SEC_OID_SHA256,
     20,
     {0x30, 0x47, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2,
      0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18,
      0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b,
      0x49, 0x15, 0x68, 0x47, 0xdb, 0x00, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: prepending 0's to sequence
    // tcID: 21
    {SEC_OID_SHA256,
     21,
     {0x30, 0x47, 0x00, 0x00, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b,
      0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e,
      0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a,
      0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4,
      0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1,
      0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending unused 0's to sequence
    // tcID: 22
    {SEC_OID_SHA256,
     22,
     {0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2,
      0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18,
      0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b,
      0x49, 0x15, 0x68, 0x47, 0xdb, 0x00, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending null value to sequence
    // tcID: 23
    {SEC_OID_SHA256,
     23,
     {0x30, 0x47, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2,
      0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18,
      0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b,
      0x49, 0x15, 0x68, 0x47, 0xdb, 0x05, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 24
    {SEC_OID_SHA256,
     24,
     {0x30, 0x4a, 0x49, 0x81, 0x77, 0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3,
      0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19,
      0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59,
      0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00,
      0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee,
      0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d,
      0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 25
    {SEC_OID_SHA256,
     25,
     {0x30, 0x49, 0x25, 0x00, 0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8,
      0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a,
      0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8,
      0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3,
      0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14,
      0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4,
      0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 26
    {SEC_OID_SHA256,
     26,
     {0x30, 0x47, 0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94,
      0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c,
      0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0,
      0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13,
      0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47,
      0xdb, 0x00, 0x04, 0xde, 0xad, 0xbe, 0xef},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 27
    {SEC_OID_SHA256,
     27,
     {0x30, 0x4a, 0x22, 0x25, 0x49, 0x81, 0x77, 0x02, 0x20, 0x2b, 0xa3,
      0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19,
      0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59,
      0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00,
      0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee,
      0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d,
      0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 28
    {SEC_OID_SHA256,
     28,
     {0x30, 0x49, 0x22, 0x24, 0x25, 0x00, 0x02, 0x20, 0x2b, 0xa3, 0xa8,
      0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a,
      0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8,
      0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3,
      0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14,
      0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4,
      0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 29
    {SEC_OID_SHA256,
     29,
     {0x30, 0x4d, 0x22, 0x22, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94,
      0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c,
      0x2e, 0x18, 0x00, 0x04, 0xde, 0xad, 0xbe, 0xef, 0x02, 0x21, 0x00, 0xb3,
      0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93,
      0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 30
    {SEC_OID_SHA256,
     30,
     {0x30, 0x4a, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x22, 0x26, 0x49, 0x81, 0x77, 0x02, 0x21, 0x00,
      0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee,
      0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d,
      0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 31
    {SEC_OID_SHA256,
     31,
     {0x30, 0x49, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x22, 0x25, 0x25, 0x00, 0x02, 0x21, 0x00, 0xb3,
      0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14,
      0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4,
      0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 32
    {SEC_OID_SHA256,
     32,
     {0x30, 0x4d, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x22, 0x23, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0,
      0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13,
      0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47,
      0xdb, 0x00, 0x04, 0xde, 0xad, 0xbe, 0xef},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 33
    {SEC_OID_SHA256,
     33,
     {0x30, 0x4d, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00, 0x30, 0x45, 0x02, 0x20,
      0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1,
      0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59,
      0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3,
      0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93,
      0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 34
    {SEC_OID_SHA256,
     34,
     {0x30, 0x4b, 0xaa, 0x02, 0xaa, 0xbb, 0x30, 0x45, 0x02, 0x20, 0x2b,
      0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1,
      0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8,
      0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21,
      0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84,
      0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 35
    {SEC_OID_SHA256,
     35,
     {0x30, 0x4d, 0x22, 0x28, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00, 0x02, 0x20,
      0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1,
      0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59,
      0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3,
      0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93,
      0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 36
    {SEC_OID_SHA256,
     36,
     {0x30, 0x4b, 0x22, 0x26, 0xaa, 0x02, 0xaa, 0xbb, 0x02, 0x20, 0x2b,
      0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1,
      0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8,
      0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21,
      0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84,
      0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 37
    {SEC_OID_SHA256,
     37,
     {0x30, 0x4d, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x22, 0x29, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00, 0x02, 0x21, 0x00, 0xb3,
      0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93,
      0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 38
    {SEC_OID_SHA256,
     38,
     {0x30, 0x4b, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x22, 0x27, 0xaa, 0x02, 0xaa, 0xbb, 0x02, 0x21,
      0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84,
      0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated length of sequence
    // tcID: 39
    {SEC_OID_SHA256,
     39,
     {0x30, 0x81},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with indefinite length
    // tcID: 40
    {SEC_OID_SHA256,
     40,
     {0x30, 0x80, 0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b,
      0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e,
      0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a,
      0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4,
      0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1,
      0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb, 0x00, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with indefinite length
    // tcID: 41
    {SEC_OID_SHA256,
     41,
     {0x30, 0x49, 0x22, 0x80, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b,
      0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e,
      0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a,
      0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x00, 0x00, 0x02, 0x21, 0x00, 0xb3,
      0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14,
      0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4,
      0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with indefinite length
    // tcID: 42
    {SEC_OID_SHA256,
     42,
     {0x30, 0x49, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x22, 0x80, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4,
      0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1,
      0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb, 0x00, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with wrong tag
    // tcID: 43
    {SEC_OID_SHA256,
     43,
     {0x30, 0x80, 0x31, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b,
      0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e,
      0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a,
      0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4,
      0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1,
      0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb, 0x00, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with wrong tag
    // tcID: 44
    {SEC_OID_SHA256,
     44,
     {0x30, 0x49, 0x22, 0x80, 0x03, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b,
      0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e,
      0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a,
      0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x00, 0x00, 0x02, 0x21, 0x00, 0xb3,
      0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14,
      0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4,
      0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with wrong tag
    // tcID: 45
    {SEC_OID_SHA256,
     45,
     {0x30, 0x49, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x22, 0x80, 0x03, 0x21, 0x00, 0xb3, 0x29, 0xf4,
      0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1,
      0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb, 0x00, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Replacing sequence with NULL
    // tcID: 46
    {SEC_OID_SHA256,
     46,
     {0x05, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of sequence
    // tcID: 47
    {SEC_OID_SHA256,
     47,
     {0x2e, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of sequence
    // tcID: 48
    {SEC_OID_SHA256,
     48,
     {0x2f, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of sequence
    // tcID: 49
    {SEC_OID_SHA256,
     49,
     {0x31, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of sequence
    // tcID: 50
    {SEC_OID_SHA256,
     50,
     {0x32, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of sequence
    // tcID: 51
    {SEC_OID_SHA256,
     51,
     {0xff, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: dropping value of sequence
    // tcID: 52
    {SEC_OID_SHA256,
     52,
     {0x30, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition for sequence
    // tcID: 53
    {SEC_OID_SHA256,
     53,
     {0x30, 0x49, 0x30, 0x01, 0x02, 0x30, 0x44, 0x20, 0x2b, 0xa3, 0xa8,
      0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a,
      0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8,
      0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3,
      0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14,
      0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4,
      0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated sequence
    // tcID: 54
    {SEC_OID_SHA256,
     54,
     {0x30, 0x44, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated sequence
    // tcID: 55
    {SEC_OID_SHA256,
     55,
     {0x30, 0x44, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80,
      0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1,
      0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02,
      0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84,
      0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d,
      0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length
    // tcID: 56
    {SEC_OID_SHA256,
     56,
     {0x30, 0x80, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2,
      0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18,
      0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b,
      0x49, 0x15, 0x68, 0x47, 0xdb, 0x00, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length with truncated delimiter
    // tcID: 57
    {SEC_OID_SHA256,
     57,
     {0x30, 0x80, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length with additional element
    // tcID: 58
    {SEC_OID_SHA256,
     58,
     {0x30, 0x80, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2,
      0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18,
      0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b,
      0x49, 0x15, 0x68, 0x47, 0xdb, 0x05, 0x00, 0x00, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length with truncated element
    // tcID: 59
    {SEC_OID_SHA256,
     59,
     {0x30, 0x80, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2,
      0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18,
      0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b,
      0x49, 0x15, 0x68, 0x47, 0xdb, 0x06, 0x08, 0x11, 0x22, 0x00, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length with garbage
    // tcID: 60
    {SEC_OID_SHA256,
     60,
     {0x30, 0x80, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2,
      0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18,
      0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b,
      0x49, 0x15, 0x68, 0x47, 0xdb, 0x00, 0x00, 0xfe, 0x02, 0xbe, 0xef},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length with nonempty EOC
    // tcID: 61
    {SEC_OID_SHA256,
     61,
     {0x30, 0x80, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2,
      0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18,
      0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b,
      0x49, 0x15, 0x68, 0x47, 0xdb, 0x00, 0x02, 0xbe, 0xef},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: prepend empty sequence
    // tcID: 62
    {SEC_OID_SHA256,
     62,
     {0x30, 0x47, 0x30, 0x00, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b,
      0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e,
      0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a,
      0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4,
      0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1,
      0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: append empty sequence
    // tcID: 63
    {SEC_OID_SHA256,
     63,
     {0x30, 0x47, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2,
      0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18,
      0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b,
      0x49, 0x15, 0x68, 0x47, 0xdb, 0x30, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: append garbage with high tag number
    // tcID: 64
    {SEC_OID_SHA256,
     64,
     {0x30, 0x48, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2,
      0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18,
      0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b,
      0x49, 0x15, 0x68, 0x47, 0xdb, 0xbf, 0x7f, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: sequence of sequence
    // tcID: 65
    {SEC_OID_SHA256,
     65,
     {0x30, 0x47, 0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b,
      0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e,
      0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a,
      0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4,
      0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1,
      0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated sequence: removed last 1 elements
    // tcID: 66
    {SEC_OID_SHA256,
     66,
     {0x30, 0x22, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: repeating element in sequence
    // tcID: 67
    {SEC_OID_SHA256,
     67,
     {0x30, 0x68, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb, 0x02,
      0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84,
      0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d,
      0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: long form encoding of length of integer
    // tcID: 68
    {SEC_OID_SHA256,
     68,
     {0x30, 0x46, 0x02, 0x81, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d,
      0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e,
      0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5,
      0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c,
      0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: long form encoding of length of integer
    // tcID: 69
    {SEC_OID_SHA256,
     69,
     {0x30, 0x46, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x81, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5,
      0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c,
      0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer contains leading 0
    // tcID: 70
    {SEC_OID_SHA256,
     70,
     {0x30, 0x47, 0x02, 0x82, 0x00, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b,
      0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e,
      0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a,
      0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4,
      0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1,
      0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer contains leading 0
    // tcID: 71
    {SEC_OID_SHA256,
     71,
     {0x30, 0x47, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x02, 0x82, 0x00, 0x21, 0x00, 0xb3, 0x29, 0xf4,
      0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1,
      0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of integer
    // tcID: 72
    {SEC_OID_SHA256,
     72,
     {0x30, 0x45, 0x02, 0x21, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of integer
    // tcID: 73
    {SEC_OID_SHA256,
     73,
     {0x30, 0x45, 0x02, 0x1f, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of integer
    // tcID: 74
    {SEC_OID_SHA256,
     74,
     {0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x22, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of integer
    // tcID: 75
    {SEC_OID_SHA256,
     75,
     {0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x20, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint32 overflow in length of integer
    // tcID: 76
    {SEC_OID_SHA256,
     76,
     {0x30, 0x4a, 0x02, 0x85, 0x01, 0x00, 0x00, 0x00, 0x20, 0x2b, 0xa3,
      0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19,
      0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59,
      0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00,
      0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee,
      0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d,
      0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint32 overflow in length of integer
    // tcID: 77
    {SEC_OID_SHA256,
     77,
     {0x30, 0x4a, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x02, 0x85, 0x01, 0x00, 0x00, 0x00, 0x21, 0x00,
      0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee,
      0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d,
      0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint64 overflow in length of integer
    // tcID: 78
    {SEC_OID_SHA256,
     78,
     {0x30, 0x4e, 0x02, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9,
      0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8,
      0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00,
      0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14,
      0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08,
      0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint64 overflow in length of integer
    // tcID: 79
    {SEC_OID_SHA256,
     79,
     {0x30, 0x4e, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x00,
      0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14,
      0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08,
      0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**31 - 1
    // tcID: 80
    {SEC_OID_SHA256,
     80,
     {0x30, 0x49, 0x02, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x2b, 0xa3, 0xa8,
      0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a,
      0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8,
      0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3,
      0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14,
      0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4,
      0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**31 - 1
    // tcID: 81
    {SEC_OID_SHA256,
     81,
     {0x30, 0x49, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x02, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x00, 0xb3,
      0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14,
      0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4,
      0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**32 - 1
    // tcID: 82
    {SEC_OID_SHA256,
     82,
     {0x30, 0x49, 0x02, 0x84, 0xff, 0xff, 0xff, 0xff, 0x2b, 0xa3, 0xa8,
      0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a,
      0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8,
      0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3,
      0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14,
      0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4,
      0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**32 - 1
    // tcID: 83
    {SEC_OID_SHA256,
     83,
     {0x30, 0x49, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x02, 0x84, 0xff, 0xff, 0xff, 0xff, 0x00, 0xb3,
      0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14,
      0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4,
      0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**40 - 1
    // tcID: 84
    {SEC_OID_SHA256,
     84,
     {0x30, 0x4a, 0x02, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2b, 0xa3,
      0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19,
      0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59,
      0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00,
      0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee,
      0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d,
      0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**40 - 1
    // tcID: 85
    {SEC_OID_SHA256,
     85,
     {0x30, 0x4a, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x02, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
      0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee,
      0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d,
      0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**64 - 1
    // tcID: 86
    {SEC_OID_SHA256,
     86,
     {0x30, 0x4d, 0x02, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1,
      0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59,
      0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3,
      0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93,
      0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**64 - 1
    // tcID: 87
    {SEC_OID_SHA256,
     87,
     {0x30, 0x4d, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xb3,
      0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93,
      0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: incorrect length of integer
    // tcID: 88
    {SEC_OID_SHA256,
     88,
     {0x30, 0x45, 0x02, 0xff, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: incorrect length of integer
    // tcID: 89
    {SEC_OID_SHA256,
     89,
     {0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0xff, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: removing integer
    // tcID: 90
    {SEC_OID_SHA256,
     90,
     {0x30, 0x23, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2,
      0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5,
      0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: lonely integer tag
    // tcID: 91
    {SEC_OID_SHA256,
     91,
     {0x30, 0x24, 0x02, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79,
      0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1,
      0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08,
      0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: lonely integer tag
    // tcID: 92
    {SEC_OID_SHA256,
     92,
     {0x30, 0x23, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94,
      0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e,
      0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc,
      0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending 0's to integer
    // tcID: 93
    {SEC_OID_SHA256,
     93,
     {0x30, 0x47, 0x02, 0x22, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x00, 0x00, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4,
      0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1,
      0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending 0's to integer
    // tcID: 94
    {SEC_OID_SHA256,
     94,
     {0x30, 0x47, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x02, 0x23, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2,
      0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18,
      0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b,
      0x49, 0x15, 0x68, 0x47, 0xdb, 0x00, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: prepending 0's to integer
    // tcID: 95
    {SEC_OID_SHA256,
     95,
     {0x30, 0x47, 0x02, 0x22, 0x00, 0x00, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b,
      0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e,
      0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a,
      0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4,
      0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1,
      0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: prepending 0's to integer
    // tcID: 96
    {SEC_OID_SHA256,
     96,
     {0x30, 0x47, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x02, 0x23, 0x00, 0x00, 0x00, 0xb3, 0x29, 0xf4,
      0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1,
      0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending unused 0's to integer
    // tcID: 97
    {SEC_OID_SHA256,
     97,
     {0x30, 0x47, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x00, 0x00, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4,
      0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1,
      0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending null value to integer
    // tcID: 98
    {SEC_OID_SHA256,
     98,
     {0x30, 0x47, 0x02, 0x22, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x05, 0x00, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4,
      0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1,
      0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c,
      0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending null value to integer
    // tcID: 99
    {SEC_OID_SHA256,
     99,
     {0x30, 0x47, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x02, 0x23, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2,
      0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18,
      0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b,
      0x49, 0x15, 0x68, 0x47, 0xdb, 0x05, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated length of integer
    // tcID: 100
    {SEC_OID_SHA256,
     100,
     {0x30, 0x25, 0x02, 0x81, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4,
      0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93,
      0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4,
      0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated length of integer
    // tcID: 101
    {SEC_OID_SHA256,
     101,
     {0x30, 0x24, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94,
      0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e,
      0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc,
      0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x81},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Replacing integer with NULL
    // tcID: 102
    {SEC_OID_SHA256,
     102,
     {0x30, 0x25, 0x05, 0x00, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4,
      0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93,
      0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4,
      0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Replacing integer with NULL
    // tcID: 103
    {SEC_OID_SHA256,
     103,
     {0x30, 0x24, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94,
      0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e,
      0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc,
      0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x05, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 104
    {SEC_OID_SHA256,
     104,
     {0x30, 0x45, 0x00, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 105
    {SEC_OID_SHA256,
     105,
     {0x30, 0x45, 0x01, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 106
    {SEC_OID_SHA256,
     106,
     {0x30, 0x45, 0x03, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 107
    {SEC_OID_SHA256,
     107,
     {0x30, 0x45, 0x04, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 108
    {SEC_OID_SHA256,
     108,
     {0x30, 0x45, 0xff, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 109
    {SEC_OID_SHA256,
     109,
     {0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x00, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 110
    {SEC_OID_SHA256,
     110,
     {0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x01, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 111
    {SEC_OID_SHA256,
     111,
     {0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x03, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 112
    {SEC_OID_SHA256,
     112,
     {0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x04, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 113
    {SEC_OID_SHA256,
     113,
     {0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0xff, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: dropping value of integer
    // tcID: 114
    {SEC_OID_SHA256,
     114,
     {0x30, 0x25, 0x02, 0x00, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4,
      0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93,
      0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4,
      0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: dropping value of integer
    // tcID: 115
    {SEC_OID_SHA256,
     115,
     {0x30, 0x24, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94,
      0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e,
      0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc,
      0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition for integer
    // tcID: 116
    {SEC_OID_SHA256,
     116,
     {0x30, 0x49, 0x22, 0x24, 0x02, 0x01, 0x2b, 0x02, 0x1f, 0xa3, 0xa8,
      0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a,
      0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8,
      0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3,
      0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14,
      0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4,
      0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition for integer
    // tcID: 117
    {SEC_OID_SHA256,
     117,
     {0x30, 0x49, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5,
      0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd,
      0x5c, 0x2e, 0x18, 0x22, 0x25, 0x02, 0x01, 0x00, 0x02, 0x20, 0xb3,
      0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14,
      0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4,
      0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: modify first byte of integer
    // tcID: 118
    {SEC_OID_SHA256,
     118,
     {0x30, 0x45, 0x02, 0x20, 0x29, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: modify first byte of integer
    // tcID: 119
    {SEC_OID_SHA256,
     119,
     {0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x02, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: modify last byte of integer
    // tcID: 120
    {SEC_OID_SHA256,
     120,
     {0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x98,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: modify last byte of integer
    // tcID: 121
    {SEC_OID_SHA256,
     121,
     {0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0x5b},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated integer
    // tcID: 122
    {SEC_OID_SHA256,
     122,
     {0x30, 0x44, 0x02, 0x1f, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x02,
      0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84,
      0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d,
      0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated integer
    // tcID: 123
    {SEC_OID_SHA256,
     123,
     {0x30, 0x44, 0x02, 0x1f, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80,
      0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1,
      0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02,
      0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84,
      0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d,
      0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated integer
    // tcID: 124
    {SEC_OID_SHA256,
     124,
     {0x30, 0x44, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x20, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: leading ff in integer
    // tcID: 125
    {SEC_OID_SHA256,
     125,
     {0x30, 0x46, 0x02, 0x21, 0xff, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d,
      0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e,
      0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5,
      0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c,
      0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: leading ff in integer
    // tcID: 126
    {SEC_OID_SHA256,
     126,
     {0x30, 0x46, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x22, 0xff, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5,
      0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c,
      0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: replaced integer by infinity
    // tcID: 127
    {SEC_OID_SHA256,
     127,
     {0x30, 0x26, 0x09, 0x01, 0x80, 0x02, 0x21, 0x00, 0xb3, 0x29,
      0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14,
      0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d,
      0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: replaced integer by infinity
    // tcID: 128
    {SEC_OID_SHA256,
     128,
     {0x30, 0x25, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94,
      0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e,
      0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc,
      0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x09, 0x01, 0x80},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: replacing integer with zero
    // tcID: 129
    {SEC_OID_SHA256,
     129,
     {0x30, 0x26, 0x02, 0x01, 0x00, 0x02, 0x21, 0x00, 0xb3, 0x29,
      0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14,
      0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d,
      0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: replacing integer with zero
    // tcID: 130
    {SEC_OID_SHA256,
     130,
     {0x30, 0x25, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94,
      0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e,
      0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc,
      0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x01, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 131
    {SEC_OID_SHA256,
     131,
     {0x30, 0x46, 0x02, 0x21, 0x01, 0x2b, 0xa3, 0xa8, 0xbd, 0x6b, 0x94, 0xd5,
      0xed, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xbc, 0xcc, 0x08,
      0x33, 0x49, 0x06, 0x86, 0xde, 0xac, 0x86, 0x35, 0xbc, 0xb9, 0xbf, 0x53,
      0x69, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5,
      0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c,
      0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 132
    {SEC_OID_SHA256,
     132,
     {0x30, 0x46, 0x02, 0x21, 0xff, 0x2b, 0xa3, 0xa8, 0xbf, 0x6b, 0x94, 0xd5,
      0xeb, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6f, 0x42, 0xfe, 0x12,
      0xd7, 0xfa, 0xd7, 0x49, 0xd4, 0xc5, 0x12, 0xa0, 0x36, 0xc0, 0xf9, 0x08,
      0xc7, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5,
      0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c,
      0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 133
    {SEC_OID_SHA256,
     133,
     {0x30, 0x45, 0x02, 0x20, 0xd4, 0x5c, 0x57, 0x41, 0x94, 0x6b, 0x2a, 0x13,
      0x7f, 0x59, 0x26, 0x2e, 0xe6, 0xf5, 0xbc, 0x91, 0x00, 0x1a, 0xf2, 0x7a,
      0x5e, 0x11, 0x17, 0xa6, 0x47, 0x33, 0x95, 0x06, 0x42, 0xa3, 0xd1, 0xe8,
      0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 134
    {SEC_OID_SHA256,
     134,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xd4, 0x5c, 0x57, 0x40, 0x94, 0x6b, 0x2a,
      0x14, 0x7f, 0x59, 0x26, 0x2e, 0xe6, 0xf5, 0xbc, 0x90, 0xbd, 0x01, 0xed,
      0x28, 0x05, 0x28, 0xb6, 0x2b, 0x3a, 0xed, 0x5f, 0xc9, 0x3f, 0x06, 0xf7,
      0x39, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5,
      0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c,
      0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 135
    {SEC_OID_SHA256,
     135,
     {0x30, 0x46, 0x02, 0x21, 0xfe, 0xd4, 0x5c, 0x57, 0x42, 0x94, 0x6b, 0x2a,
      0x12, 0x7f, 0x59, 0x26, 0x2e, 0xe6, 0xf5, 0xbc, 0x91, 0x43, 0x33, 0xf7,
      0xcc, 0xb6, 0xf9, 0x79, 0x21, 0x53, 0x79, 0xca, 0x43, 0x46, 0x40, 0xac,
      0x97, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5,
      0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c,
      0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 136
    {SEC_OID_SHA256,
     136,
     {0x30, 0x46, 0x02, 0x21, 0x01, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5,
      0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d,
      0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e,
      0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5,
      0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c,
      0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 137
    {SEC_OID_SHA256,
     137,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xd4, 0x5c, 0x57, 0x41, 0x94, 0x6b, 0x2a,
      0x13, 0x7f, 0x59, 0x26, 0x2e, 0xe6, 0xf5, 0xbc, 0x91, 0x00, 0x1a, 0xf2,
      0x7a, 0x5e, 0x11, 0x17, 0xa6, 0x47, 0x33, 0x95, 0x06, 0x42, 0xa3, 0xd1,
      0xe8, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5,
      0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c,
      0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 138
    {SEC_OID_SHA256,
     138,
     {0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x01, 0xb3, 0x29, 0xf4, 0x78, 0xa2, 0xbb, 0xd0, 0xa6, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x27, 0x6e, 0x0e, 0x4a, 0x53,
      0x75, 0x92, 0x8d, 0x6f, 0xcd, 0x16, 0x0c, 0x11, 0xcb, 0x6d, 0x2c},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 139
    {SEC_OID_SHA256,
     139,
     {0x30, 0x44, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x20, 0xb3, 0x29, 0xf4, 0x7a, 0xa2, 0xbb, 0xd0, 0xa4, 0xc3, 0x84,
      0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0xad, 0xa0, 0x18, 0xef, 0x05, 0x46,
      0x55, 0x83, 0x88, 0x59, 0x80, 0x86, 0x19, 0x05, 0x22, 0x8a},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 140
    {SEC_OID_SHA256,
     140,
     {0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0xff, 0x4c, 0xd6, 0x0b, 0x86, 0x5d, 0x44, 0x2f, 0x5a, 0x3c,
      0x7b, 0x11, 0xeb, 0x6c, 0x4e, 0x0a, 0xe7, 0x95, 0x78, 0xec, 0x63, 0x53,
      0xa2, 0x0b, 0xf7, 0x83, 0xec, 0xb4, 0xb6, 0xea, 0x97, 0xb8, 0x25},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 141
    {SEC_OID_SHA256,
     141,
     {0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0xfe, 0x4c, 0xd6, 0x0b, 0x87, 0x5d, 0x44, 0x2f, 0x59, 0x3c,
      0x7b, 0x11, 0xeb, 0x6c, 0x4e, 0x0a, 0xe7, 0xd8, 0x91, 0xf1, 0xb5, 0xac,
      0x8a, 0x6d, 0x72, 0x90, 0x32, 0xe9, 0xf3, 0xee, 0x34, 0x92, 0xd4},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 142
    {SEC_OID_SHA256,
     142,
     {0x30, 0x45, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x21, 0x01, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3,
      0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac,
      0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 143
    {SEC_OID_SHA256,
     143,
     {0x30, 0x44, 0x02, 0x20, 0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec,
      0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85,
      0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18,
      0x02, 0x20, 0x4c, 0xd6, 0x0b, 0x86, 0x5d, 0x44, 0x2f, 0x5a, 0x3c, 0x7b,
      0x11, 0xeb, 0x6c, 0x4e, 0x0a, 0xe7, 0x95, 0x78, 0xec, 0x63, 0x53, 0xa2,
      0x0b, 0xf7, 0x83, 0xec, 0xb4, 0xb6, 0xea, 0x97, 0xb8, 0x25},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 144
    {SEC_OID_SHA256,
     144,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x02, 0x01, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 145
    {SEC_OID_SHA256,
     145,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x02, 0x01, 0x01},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 146
    {SEC_OID_SHA256,
     146,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x02, 0x01, 0xff},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 147
    {SEC_OID_SHA256,
     147,
     {0x30, 0x26, 0x02, 0x01, 0x00, 0x02, 0x21, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17,
      0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 148
    {SEC_OID_SHA256,
     148,
     {0x30, 0x26, 0x02, 0x01, 0x00, 0x02, 0x21, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17,
      0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 149
    {SEC_OID_SHA256,
     149,
     {0x30, 0x26, 0x02, 0x01, 0x00, 0x02, 0x21, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17,
      0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 150
    {SEC_OID_SHA256,
     150,
     {0x30, 0x26, 0x02, 0x01, 0x00, 0x02, 0x21, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 151
    {SEC_OID_SHA256,
     151,
     {0x30, 0x26, 0x02, 0x01, 0x00, 0x02, 0x21, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 152
    {SEC_OID_SHA256,
     152,
     {0x30, 0x08, 0x02, 0x01, 0x00, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 153
    {SEC_OID_SHA256,
     153,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x09, 0x01, 0x42},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 154
    {SEC_OID_SHA256,
     154,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 155
    {SEC_OID_SHA256,
     155,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0x01},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 156
    {SEC_OID_SHA256,
     156,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0xff},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 157
    {SEC_OID_SHA256,
     157,
     {0x30, 0x26, 0x02, 0x01, 0x01, 0x02, 0x21, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17,
      0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 158
    {SEC_OID_SHA256,
     158,
     {0x30, 0x26, 0x02, 0x01, 0x01, 0x02, 0x21, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17,
      0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 159
    {SEC_OID_SHA256,
     159,
     {0x30, 0x26, 0x02, 0x01, 0x01, 0x02, 0x21, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17,
      0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 160
    {SEC_OID_SHA256,
     160,
     {0x30, 0x26, 0x02, 0x01, 0x01, 0x02, 0x21, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 161
    {SEC_OID_SHA256,
     161,
     {0x30, 0x26, 0x02, 0x01, 0x01, 0x02, 0x21, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 162
    {SEC_OID_SHA256,
     162,
     {0x30, 0x08, 0x02, 0x01, 0x01, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 163
    {SEC_OID_SHA256,
     163,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x09, 0x01, 0x42},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 164
    {SEC_OID_SHA256,
     164,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x02, 0x01, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 165
    {SEC_OID_SHA256,
     165,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x02, 0x01, 0x01},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 166
    {SEC_OID_SHA256,
     166,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x02, 0x01, 0xff},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 167
    {SEC_OID_SHA256,
     167,
     {0x30, 0x26, 0x02, 0x01, 0xff, 0x02, 0x21, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17,
      0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 168
    {SEC_OID_SHA256,
     168,
     {0x30, 0x26, 0x02, 0x01, 0xff, 0x02, 0x21, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17,
      0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 169
    {SEC_OID_SHA256,
     169,
     {0x30, 0x26, 0x02, 0x01, 0xff, 0x02, 0x21, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17,
      0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 170
    {SEC_OID_SHA256,
     170,
     {0x30, 0x26, 0x02, 0x01, 0xff, 0x02, 0x21, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 171
    {SEC_OID_SHA256,
     171,
     {0x30, 0x26, 0x02, 0x01, 0xff, 0x02, 0x21, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 172
    {SEC_OID_SHA256,
     172,
     {0x30, 0x08, 0x02, 0x01, 0xff, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 173
    {SEC_OID_SHA256,
     173,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x09, 0x01, 0x42},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 174
    {SEC_OID_SHA256,
     174,
     {0x30, 0x26, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3,
      0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51, 0x02, 0x01, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 175
    {SEC_OID_SHA256,
     175,
     {0x30, 0x26, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3,
      0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51, 0x02, 0x01, 0x01},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 176
    {SEC_OID_SHA256,
     176,
     {0x30, 0x26, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3,
      0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51, 0x02, 0x01, 0xff},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 177
    {SEC_OID_SHA256,
     177,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa,
      0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25,
      0x51, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 178
    {SEC_OID_SHA256,
     178,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa,
      0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25,
      0x51, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 179
    {SEC_OID_SHA256,
     179,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa,
      0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25,
      0x51, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 180
    {SEC_OID_SHA256,
     180,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa,
      0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25,
      0x51, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 181
    {SEC_OID_SHA256,
     181,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa,
      0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25,
      0x51, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 182
    {SEC_OID_SHA256,
     182,
     {0x30, 0x28, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
      0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc,
      0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2,
      0xfc, 0x63, 0x25, 0x51, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 183
    {SEC_OID_SHA256,
     183,
     {0x30, 0x26, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3,
      0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51, 0x09, 0x01, 0x42},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 184
    {SEC_OID_SHA256,
     184,
     {0x30, 0x26, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3,
      0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50, 0x02, 0x01, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 185
    {SEC_OID_SHA256,
     185,
     {0x30, 0x26, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3,
      0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50, 0x02, 0x01, 0x01},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 186
    {SEC_OID_SHA256,
     186,
     {0x30, 0x26, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3,
      0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50, 0x02, 0x01, 0xff},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 187
    {SEC_OID_SHA256,
     187,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa,
      0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25,
      0x50, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 188
    {SEC_OID_SHA256,
     188,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa,
      0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25,
      0x50, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 189
    {SEC_OID_SHA256,
     189,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa,
      0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25,
      0x50, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 190
    {SEC_OID_SHA256,
     190,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa,
      0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25,
      0x50, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 191
    {SEC_OID_SHA256,
     191,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa,
      0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25,
      0x50, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 192
    {SEC_OID_SHA256,
     192,
     {0x30, 0x28, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
      0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc,
      0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2,
      0xfc, 0x63, 0x25, 0x50, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 193
    {SEC_OID_SHA256,
     193,
     {0x30, 0x26, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3,
      0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50, 0x09, 0x01, 0x42},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 194
    {SEC_OID_SHA256,
     194,
     {0x30, 0x26, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3,
      0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52, 0x02, 0x01, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 195
    {SEC_OID_SHA256,
     195,
     {0x30, 0x26, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3,
      0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52, 0x02, 0x01, 0x01},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 196
    {SEC_OID_SHA256,
     196,
     {0x30, 0x26, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3,
      0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52, 0x02, 0x01, 0xff},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 197
    {SEC_OID_SHA256,
     197,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa,
      0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25,
      0x52, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 198
    {SEC_OID_SHA256,
     198,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa,
      0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25,
      0x52, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 199
    {SEC_OID_SHA256,
     199,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa,
      0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25,
      0x52, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 200
    {SEC_OID_SHA256,
     200,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa,
      0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25,
      0x52, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 201
    {SEC_OID_SHA256,
     201,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa,
      0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25,
      0x52, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 202
    {SEC_OID_SHA256,
     202,
     {0x30, 0x28, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
      0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc,
      0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2,
      0xfc, 0x63, 0x25, 0x52, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 203
    {SEC_OID_SHA256,
     203,
     {0x30, 0x26, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3,
      0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52, 0x09, 0x01, 0x42},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 204
    {SEC_OID_SHA256,
     204,
     {0x30, 0x26, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x01, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 205
    {SEC_OID_SHA256,
     205,
     {0x30, 0x26, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x01, 0x01},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 206
    {SEC_OID_SHA256,
     206,
     {0x30, 0x26, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x01, 0xff},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 207
    {SEC_OID_SHA256,
     207,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 208
    {SEC_OID_SHA256,
     208,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 209
    {SEC_OID_SHA256,
     209,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 210
    {SEC_OID_SHA256,
     210,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 211
    {SEC_OID_SHA256,
     211,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 212
    {SEC_OID_SHA256,
     212,
     {0x30, 0x28, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
      0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 213
    {SEC_OID_SHA256,
     213,
     {0x30, 0x26, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x09, 0x01, 0x42},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 214
    {SEC_OID_SHA256,
     214,
     {0x30, 0x26, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 215
    {SEC_OID_SHA256,
     215,
     {0x30, 0x26, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x01},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 216
    {SEC_OID_SHA256,
     216,
     {0x30, 0x26, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0xff},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 217
    {SEC_OID_SHA256,
     217,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 218
    {SEC_OID_SHA256,
     218,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 219
    {SEC_OID_SHA256,
     219,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 220
    {SEC_OID_SHA256,
     220,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 221
    {SEC_OID_SHA256,
     221,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 222
    {SEC_OID_SHA256,
     222,
     {0x30, 0x28, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
      0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 223
    {SEC_OID_SHA256,
     223,
     {0x30, 0x26, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x01, 0x42},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong types.
    // tcID: 224
    {SEC_OID_SHA256,
     224,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x0c, 0x01, 0x30},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong types.
    // tcID: 225
    {SEC_OID_SHA256,
     225,
     {0x30, 0x05, 0x02, 0x01, 0x01, 0x0c, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong types.
    // tcID: 226
    {SEC_OID_SHA256,
     226,
     {0x30, 0x09, 0x0c, 0x02, 0x25, 0x73, 0x0c, 0x03, 0x73, 0x25, 0x73},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong types.
    // tcID: 227
    {SEC_OID_SHA256,
     227,
     {0x30, 0x08, 0x02, 0x01, 0x01, 0x30, 0x03, 0x02, 0x01, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong types.
    // tcID: 228
    {SEC_OID_SHA256,
     228,
     {0x30, 0x03, 0x02, 0x01, 0x01},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong types.
    // tcID: 229
    {SEC_OID_SHA256,
     229,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x01, 0x01, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Edge case for Shamir multiplication
    // tcID: 230
    {SEC_OID_SHA256,
     230,
     {0x30, 0x44, 0x02, 0x20, 0x64, 0xa1, 0xaa, 0xb5, 0x00, 0x0d, 0x0e, 0x80,
      0x4f, 0x3e, 0x2f, 0xc0, 0x2b, 0xde, 0xe9, 0xbe, 0x8f, 0xf3, 0x12, 0x33,
      0x4e, 0x2b, 0xa1, 0x6d, 0x11, 0x54, 0x7c, 0x97, 0x71, 0x1c, 0x89, 0x8e,
      0x02, 0x20, 0x6a, 0xf0, 0x15, 0x97, 0x1c, 0xc3, 0x0b, 0xe6, 0xd1, 0xa2,
      0x06, 0xd4, 0xe0, 0x13, 0xe0, 0x99, 0x77, 0x72, 0xa2, 0xf9, 0x1d, 0x73,
      0x28, 0x6f, 0xfd, 0x68, 0x3b, 0x9b, 0xb2, 0xcf, 0x4f, 0x1b},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x36, 0x39, 0x38, 0x31, 0x39},
     true},

    // Comment: special case hash
    // tcID: 231
    {SEC_OID_SHA256,
     231,
     {0x30, 0x44, 0x02, 0x20, 0x16, 0xae, 0xa9, 0x64, 0xa2, 0xf6, 0x50, 0x6d,
      0x6f, 0x78, 0xc8, 0x1c, 0x91, 0xfc, 0x7e, 0x8b, 0xde, 0xd7, 0xd3, 0x97,
      0x73, 0x84, 0x48, 0xde, 0x1e, 0x19, 0xa0, 0xec, 0x58, 0x0b, 0xf2, 0x66,
      0x02, 0x20, 0x25, 0x2c, 0xd7, 0x62, 0x13, 0x0c, 0x66, 0x67, 0xcf, 0xe8,
      0xb7, 0xbc, 0x47, 0xd2, 0x7d, 0x78, 0x39, 0x1e, 0x8e, 0x80, 0xc5, 0x78,
      0xd1, 0xcd, 0x38, 0xc3, 0xff, 0x03, 0x3b, 0xe9, 0x28, 0xe9},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x34, 0x32, 0x36, 0x34, 0x37, 0x39, 0x37, 0x32, 0x34},
     true},

    // Comment: special case hash
    // tcID: 232
    {SEC_OID_SHA256,
     232,
     {0x30, 0x45, 0x02, 0x21, 0x00, 0x9c, 0xc9, 0x8b, 0xe2, 0x34, 0x7d, 0x46,
      0x9b, 0xf4, 0x76, 0xdf, 0xc2, 0x6b, 0x9b, 0x73, 0x3d, 0xf2, 0xd2, 0x6d,
      0x6e, 0xf5, 0x24, 0xaf, 0x91, 0x7c, 0x66, 0x5b, 0xac, 0xcb, 0x23, 0xc8,
      0x82, 0x02, 0x20, 0x09, 0x34, 0x96, 0x45, 0x9e, 0xff, 0xe2, 0xd8, 0xd7,
      0x07, 0x27, 0xb8, 0x24, 0x62, 0xf6, 0x1d, 0x0e, 0xc1, 0xb7, 0x84, 0x79,
      0x29, 0xd1, 0x0e, 0xa6, 0x31, 0xda, 0xcb, 0x16, 0xb5, 0x6c, 0x32},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x37, 0x31, 0x33, 0x38, 0x36, 0x38, 0x34, 0x38, 0x39, 0x31},
     true},

    // Comment: special case hash
    // tcID: 233
    {SEC_OID_SHA256,
     233,
     {0x30, 0x44, 0x02, 0x20, 0x73, 0xb3, 0xc9, 0x0e, 0xcd, 0x39, 0x00, 0x28,
      0x05, 0x81, 0x64, 0x52, 0x4d, 0xde, 0x89, 0x27, 0x03, 0xdc, 0xe3, 0xde,
      0xa0, 0xd5, 0x3f, 0xa8, 0x09, 0x39, 0x99, 0xf0, 0x7a, 0xb8, 0xaa, 0x43,
      0x02, 0x20, 0x2f, 0x67, 0xb0, 0xb8, 0xe2, 0x06, 0x36, 0x69, 0x5b, 0xb7,
      0xd8, 0xbf, 0x0a, 0x65, 0x1c, 0x80, 0x2e, 0xd2, 0x5a, 0x39, 0x53, 0x87,
      0xb5, 0xf4, 0x18, 0x8c, 0x0c, 0x40, 0x75, 0xc8, 0x86, 0x34},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x30, 0x33, 0x35, 0x39, 0x33, 0x33, 0x31, 0x36, 0x36, 0x38},
     true},

    // Comment: special case hash
    // tcID: 234
    {SEC_OID_SHA256,
     234,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xbf, 0xab, 0x30, 0x98, 0x25, 0x28, 0x47,
      0xb3, 0x28, 0xfa, 0xdf, 0x2f, 0x89, 0xb9, 0x5c, 0x85, 0x1a, 0x7f, 0x0e,
      0xb3, 0x90, 0x76, 0x33, 0x78, 0xf3, 0x7e, 0x90, 0x11, 0x9d, 0x5b, 0xa3,
      0xdd, 0x02, 0x21, 0x00, 0xbd, 0xd6, 0x4e, 0x23, 0x4e, 0x83, 0x2b, 0x10,
      0x67, 0xc2, 0xd0, 0x58, 0xcc, 0xb4, 0x4d, 0x97, 0x81, 0x95, 0xcc, 0xeb,
      0xb6, 0x5c, 0x2a, 0xaf, 0x1e, 0x2d, 0xa9, 0xb8, 0xb4, 0x98, 0x7e, 0x3b},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x33, 0x39, 0x34, 0x39, 0x34, 0x30, 0x31, 0x32, 0x31, 0x35},
     true},

    // Comment: special case hash
    // tcID: 235
    {SEC_OID_SHA256,
     235,
     {0x30, 0x44, 0x02, 0x20, 0x20, 0x4a, 0x97, 0x84, 0x07, 0x4b, 0x24, 0x6d,
      0x8b, 0xf8, 0xbf, 0x04, 0xa4, 0xce, 0xb1, 0xc1, 0xf1, 0xc9, 0xaa, 0xab,
      0x16, 0x8b, 0x15, 0x96, 0xd1, 0x70, 0x93, 0xc5, 0xcd, 0x21, 0xd2, 0xcd,
      0x02, 0x20, 0x51, 0xcc, 0xe4, 0x16, 0x70, 0x63, 0x67, 0x83, 0xdc, 0x06,
      0xa7, 0x59, 0xc8, 0x84, 0x78, 0x68, 0xa4, 0x06, 0xc2, 0x50, 0x6f, 0xe1,
      0x79, 0x75, 0x58, 0x2f, 0xe6, 0x48, 0xd1, 0xd8, 0x8b, 0x52},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x33, 0x34, 0x34, 0x32, 0x39, 0x33, 0x30, 0x37, 0x39},
     true},

    // Comment: special case hash
    // tcID: 236
    {SEC_OID_SHA256,
     236,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xed, 0x66, 0xdc, 0x34, 0xf5, 0x51, 0xac,
      0x82, 0xf6, 0x3d, 0x4a, 0xa4, 0xf8, 0x1f, 0xe2, 0xcb, 0x00, 0x31, 0xa9,
      0x1d, 0x13, 0x14, 0xf8, 0x35, 0x02, 0x7b, 0xca, 0x0f, 0x1c, 0xee, 0xaa,
      0x03, 0x02, 0x21, 0x00, 0x99, 0xca, 0x12, 0x3a, 0xa0, 0x9b, 0x13, 0xcd,
      0x19, 0x4a, 0x42, 0x2e, 0x18, 0xd5, 0xfd, 0xa1, 0x67, 0x62, 0x3c, 0x3f,
      0x6e, 0x5d, 0x4d, 0x6a, 0xbb, 0x89, 0x53, 0xd6, 0x7c, 0x0c, 0x48, 0xc7},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x33, 0x37, 0x30, 0x36, 0x32, 0x31, 0x31, 0x37, 0x31, 0x32},
     true},

    // Comment: special case hash
    // tcID: 237
    {SEC_OID_SHA256,
     237,
     {0x30, 0x45, 0x02, 0x20, 0x06, 0x0b, 0x70, 0x0b, 0xef, 0x66, 0x5c, 0x68,
      0x89, 0x9d, 0x44, 0xf2, 0x35, 0x6a, 0x57, 0x8d, 0x12, 0x6b, 0x06, 0x20,
      0x23, 0xcc, 0xc3, 0xc0, 0x56, 0xbf, 0x0f, 0x60, 0xa2, 0x37, 0x01, 0x2b,
      0x02, 0x21, 0x00, 0x8d, 0x18, 0x6c, 0x02, 0x78, 0x32, 0x96, 0x5f, 0x4f,
      0xcc, 0x78, 0xa3, 0x36, 0x6c, 0xa9, 0x5d, 0xed, 0xbb, 0x41, 0x0c, 0xbe,
      0xf3, 0xf2, 0x6d, 0x6b, 0xe5, 0xd5, 0x81, 0xc1, 0x1d, 0x36, 0x10},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x33, 0x34, 0x33, 0x36, 0x38, 0x38, 0x37, 0x31, 0x32},
     true},

    // Comment: special case hash
    // tcID: 238
    {SEC_OID_SHA256,
     238,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0x9f, 0x6a, 0xdf, 0xe8, 0xd5, 0xeb, 0x5b,
      0x2c, 0x24, 0xd7, 0xaa, 0x79, 0x34, 0xb6, 0xcf, 0x29, 0xc9, 0x3e, 0xa7,
      0x6c, 0xd3, 0x13, 0xc9, 0x13, 0x2b, 0xb0, 0xc8, 0xe3, 0x8c, 0x96, 0x83,
      0x1d, 0x02, 0x21, 0x00, 0xb2, 0x6a, 0x9c, 0x9e, 0x40, 0xe5, 0x5e, 0xe0,
      0x89, 0x0c, 0x94, 0x4c, 0xf2, 0x71, 0x75, 0x6c, 0x90, 0x6a, 0x33, 0xe6,
      0x6b, 0x5b, 0xd1, 0x5e, 0x05, 0x15, 0x93, 0x88, 0x3b, 0x5e, 0x99, 0x02},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x33, 0x35, 0x31, 0x35, 0x33, 0x30, 0x33, 0x37, 0x30},
     true},

    // Comment: special case hash
    // tcID: 239
    {SEC_OID_SHA256,
     239,
     {0x30, 0x45, 0x02, 0x21, 0x00, 0xa1, 0xaf, 0x03, 0xca, 0x91, 0x67, 0x7b,
      0x67, 0x3a, 0xd2, 0xf3, 0x36, 0x15, 0xe5, 0x61, 0x74, 0xa1, 0xab, 0xf6,
      0xda, 0x16, 0x8c, 0xeb, 0xfa, 0x88, 0x68, 0xf4, 0xba, 0x27, 0x3f, 0x16,
      0xb7, 0x02, 0x20, 0x20, 0xaa, 0x73, 0xff, 0xe4, 0x8a, 0xfa, 0x64, 0x35,
      0xcd, 0x25, 0x8b, 0x17, 0x3d, 0x0c, 0x23, 0x77, 0xd6, 0x90, 0x22, 0xe7,
      0xd0, 0x98, 0xd7, 0x5c, 0xaf, 0x24, 0xc8, 0xc5, 0xe0, 0x6b, 0x1c},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x36, 0x35, 0x35, 0x33, 0x32, 0x30, 0x33, 0x31, 0x32, 0x36},
     true},

    // Comment: special case hash
    // tcID: 240
    {SEC_OID_SHA256,
     240,
     {0x30, 0x45, 0x02, 0x21, 0x00, 0xfd, 0xc7, 0x06, 0x02, 0x76, 0x6f, 0x8e,
      0xed, 0x11, 0xa6, 0xc9, 0x9a, 0x71, 0xc9, 0x73, 0xd5, 0x65, 0x93, 0x55,
      0x50, 0x7b, 0x84, 0x3d, 0xa6, 0xe3, 0x27, 0xa2, 0x8c, 0x11, 0x89, 0x3d,
      0xb9, 0x02, 0x20, 0x3d, 0xf5, 0x34, 0x96, 0x88, 0xa0, 0x85, 0xb1, 0x37,
      0xb1, 0xea, 0xcf, 0x45, 0x6a, 0x9e, 0x9e, 0x0f, 0x6d, 0x15, 0xec, 0x00,
      0x78, 0xca, 0x60, 0xa7, 0xf8, 0x3f, 0x2b, 0x10, 0xd2, 0x13, 0x50},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x35, 0x36, 0x34, 0x33, 0x34, 0x36, 0x36, 0x30, 0x33},
     true},

    // Comment: special case hash
    // tcID: 241
    {SEC_OID_SHA256,
     241,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xb5, 0x16, 0xa3, 0x14, 0xf2, 0xfc, 0xe5,
      0x30, 0xd6, 0x53, 0x7f, 0x6a, 0x6c, 0x49, 0x96, 0x6c, 0x23, 0x45, 0x6f,
      0x63, 0xc6, 0x43, 0xcf, 0x8e, 0x0d, 0xc7, 0x38, 0xf7, 0xb8, 0x76, 0xe6,
      0x75, 0x02, 0x21, 0x00, 0xd3, 0x9f, 0xfd, 0x03, 0x3c, 0x92, 0xb6, 0xd7,
      0x17, 0xdd, 0x53, 0x6f, 0xbc, 0x5e, 0xfd, 0xf1, 0x96, 0x7c, 0x4b, 0xd8,
      0x09, 0x54, 0x47, 0x9b, 0xa6, 0x6b, 0x01, 0x20, 0xcd, 0x16, 0xff, 0xf2},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x34, 0x34, 0x32, 0x39, 0x35, 0x33, 0x39, 0x31, 0x31, 0x37},
     true},

    // Comment: special case hash
    // tcID: 242
    {SEC_OID_SHA256,
     242,
     {0x30, 0x44, 0x02, 0x20, 0x3b, 0x2c, 0xbf, 0x04, 0x6e, 0xac, 0x45, 0x84,
      0x2e, 0xcb, 0x79, 0x84, 0xd4, 0x75, 0x83, 0x15, 0x82, 0x71, 0x7b, 0xeb,
      0xb6, 0x49, 0x2f, 0xd0, 0xa4, 0x85, 0xc1, 0x01, 0xe2, 0x9f, 0xf0, 0xa8,
      0x02, 0x20, 0x4c, 0x9b, 0x7b, 0x47, 0xa9, 0x8b, 0x0f, 0x82, 0xde, 0x51,
      0x2b, 0xc9, 0x31, 0x3a, 0xaf, 0x51, 0x70, 0x10, 0x99, 0xca, 0xc5, 0xf7,
      0x6e, 0x68, 0xc8, 0x59, 0x5f, 0xc1, 0xc1, 0xd9, 0x92, 0x58},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x30, 0x39, 0x35, 0x33, 0x32, 0x36, 0x31, 0x33, 0x35, 0x31},
     true},

    // Comment: special case hash
    // tcID: 243
    {SEC_OID_SHA256,
     243,
     {0x30, 0x44, 0x02, 0x20, 0x30, 0xc8, 0x7d, 0x35, 0xe6, 0x36, 0xf5, 0x40,
      0x84, 0x1f, 0x14, 0xaf, 0x54, 0xe2, 0xf9, 0xed, 0xd7, 0x9d, 0x03, 0x12,
      0xcf, 0xa1, 0xab, 0x65, 0x6c, 0x3f, 0xb1, 0x5b, 0xfd, 0xe4, 0x8d, 0xcf,
      0x02, 0x20, 0x47, 0xc1, 0x5a, 0x5a, 0x82, 0xd2, 0x4b, 0x75, 0xc8, 0x5a,
      0x69, 0x2b, 0xd6, 0xec, 0xaf, 0xeb, 0x71, 0x40, 0x9e, 0xde, 0x23, 0xef,
      0xd0, 0x8e, 0x0d, 0xb9, 0xab, 0xf6, 0x34, 0x06, 0x77, 0xed},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x35, 0x39, 0x38, 0x37, 0x33, 0x35, 0x30, 0x30, 0x34, 0x31},
     true},

    // Comment: special case hash
    // tcID: 244
    {SEC_OID_SHA256,
     244,
     {0x30, 0x44, 0x02, 0x20, 0x38, 0x68, 0x6f, 0xf0, 0xfd, 0xa2, 0xce, 0xf6,
      0xbc, 0x43, 0xb5, 0x8c, 0xfe, 0x66, 0x47, 0xb9, 0xe2, 0xe8, 0x17, 0x6d,
      0x16, 0x8d, 0xec, 0x3c, 0x68, 0xff, 0x26, 0x21, 0x13, 0x76, 0x0f, 0x52,
      0x02, 0x20, 0x06, 0x7e, 0xc3, 0xb6, 0x51, 0xf4, 0x22, 0x66, 0x96, 0x01,
      0x66, 0x21, 0x67, 0xfa, 0x87, 0x17, 0xe9, 0x76, 0xe2, 0xdb, 0x5e, 0x6a,
      0x4c, 0xf7, 0xc2, 0xdd, 0xab, 0xb3, 0xfd, 0xe9, 0xd6, 0x7d},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x33, 0x34, 0x36, 0x33, 0x30, 0x30, 0x36, 0x38, 0x37, 0x38},
     true},

    // Comment: special case hash
    // tcID: 245
    {SEC_OID_SHA256,
     245,
     {0x30, 0x44, 0x02, 0x20, 0x44, 0xa3, 0xe2, 0x3b, 0xf3, 0x14, 0xf2, 0xb3,
      0x44, 0xfc, 0x25, 0xc7, 0xf2, 0xde, 0x8b, 0x6a, 0xf3, 0xe1, 0x7d, 0x27,
      0xf5, 0xee, 0x84, 0x4b, 0x22, 0x59, 0x85, 0xab, 0x6e, 0x27, 0x75, 0xcf,
      0x02, 0x20, 0x2d, 0x48, 0xe2, 0x23, 0x20, 0x5e, 0x98, 0x04, 0x1d, 0xdc,
      0x87, 0xbe, 0x53, 0x2a, 0xbe, 0xd5, 0x84, 0xf0, 0x41, 0x1f, 0x57, 0x29,
      0x50, 0x04, 0x93, 0xc9, 0xcc, 0x3f, 0x4d, 0xd1, 0x5e, 0x86},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x39, 0x38, 0x31, 0x37, 0x33, 0x32, 0x30, 0x32, 0x38, 0x37},
     true},

    // Comment: special case hash
    // tcID: 246
    {SEC_OID_SHA256,
     246,
     {0x30, 0x44, 0x02, 0x20, 0x2d, 0xed, 0x5b, 0x7e, 0xc8, 0xe9, 0x0e, 0x7b,
      0xf1, 0x1f, 0x96, 0x7a, 0x3d, 0x95, 0x11, 0x0c, 0x41, 0xb9, 0x9d, 0xb3,
      0xb5, 0xaa, 0x8d, 0x33, 0x0e, 0xb9, 0xd6, 0x38, 0x78, 0x16, 0x88, 0xe9,
      0x02, 0x20, 0x7d, 0x57, 0x92, 0xc5, 0x36, 0x28, 0x15, 0x5e, 0x1b, 0xfc,
      0x46, 0xfb, 0x1a, 0x67, 0xe3, 0x08, 0x8d, 0xe0, 0x49, 0xc3, 0x28, 0xae,
      0x1f, 0x44, 0xec, 0x69, 0x23, 0x8a, 0x00, 0x98, 0x08, 0xf9},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x33, 0x32, 0x32, 0x32, 0x30, 0x34, 0x31, 0x30, 0x34, 0x36},
     true},

    // Comment: special case hash
    // tcID: 247
    {SEC_OID_SHA256,
     247,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xbd, 0xae, 0x7b, 0xcb, 0x58, 0x0b, 0xf3,
      0x35, 0xef, 0xd3, 0xbc, 0x3d, 0x31, 0x87, 0x0f, 0x92, 0x3e, 0xac, 0xca,
      0xfc, 0xd4, 0x0e, 0xc2, 0xf6, 0x05, 0x97, 0x6f, 0x15, 0x13, 0x7d, 0x8b,
      0x8f, 0x02, 0x21, 0x00, 0xf6, 0xdf, 0xa1, 0x2f, 0x19, 0xe5, 0x25, 0x27,
      0x0b, 0x01, 0x06, 0xee, 0xcf, 0xe2, 0x57, 0x49, 0x9f, 0x37, 0x3a, 0x4f,
      0xb3, 0x18, 0x99, 0x4f, 0x24, 0x83, 0x81, 0x22, 0xce, 0x7e, 0xc3, 0xc7},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x36, 0x36, 0x36, 0x36, 0x33, 0x30, 0x37, 0x31, 0x30, 0x34},
     true},

    // Comment: special case hash
    // tcID: 248
    {SEC_OID_SHA256,
     248,
     {0x30, 0x45, 0x02, 0x20, 0x50, 0xf9, 0xc4, 0xf0, 0xcd, 0x69, 0x40, 0xe1,
      0x62, 0x72, 0x09, 0x57, 0xff, 0xff, 0x51, 0x37, 0x99, 0x20, 0x9b, 0x78,
      0x59, 0x69, 0x56, 0xd2, 0x1e, 0xce, 0x25, 0x1c, 0x24, 0x01, 0xf1, 0xc6,
      0x02, 0x21, 0x00, 0xd7, 0x03, 0x3a, 0x0a, 0x78, 0x7d, 0x33, 0x8e, 0x88,
      0x9d, 0xef, 0xaa, 0xab, 0xb1, 0x06, 0xb9, 0x5a, 0x43, 0x55, 0xe4, 0x11,
      0xa5, 0x9c, 0x32, 0xaa, 0x51, 0x67, 0xdf, 0xab, 0x24, 0x47, 0x26},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x30, 0x33, 0x35, 0x39, 0x35, 0x31, 0x38, 0x39, 0x38},
     true},

    // Comment: special case hash
    // tcID: 249
    {SEC_OID_SHA256,
     249,
     {0x30, 0x45, 0x02, 0x21, 0x00, 0xf6, 0x12, 0x82, 0x06, 0x87, 0x60, 0x4f,
      0xa0, 0x19, 0x06, 0x06, 0x6a, 0x37, 0x8d, 0x67, 0x54, 0x09, 0x82, 0xe2,
      0x95, 0x75, 0xd0, 0x19, 0xaa, 0xbe, 0x90, 0x92, 0x4e, 0xad, 0x5c, 0x86,
      0x0d, 0x02, 0x20, 0x3f, 0x93, 0x67, 0x70, 0x2d, 0xd7, 0xdd, 0x4f, 0x75,
      0xea, 0x98, 0xaf, 0xd2, 0x0e, 0x32, 0x8a, 0x1a, 0x99, 0xf4, 0x85, 0x7b,
      0x31, 0x65, 0x25, 0x32, 0x82, 0x30, 0xce, 0x29, 0x4b, 0x0f, 0xef},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x38, 0x34, 0x36, 0x35, 0x39, 0x37, 0x31, 0x39, 0x35},
     true},

    // Comment: special case hash
    // tcID: 250
    {SEC_OID_SHA256,
     250,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0x95, 0x05, 0xe4, 0x07, 0x65, 0x7d, 0x6e,
      0x8b, 0xc9, 0x3d, 0xb5, 0xda, 0x7a, 0xa6, 0xf5, 0x08, 0x1f, 0x61, 0x98,
      0x0c, 0x19, 0x49, 0xf5, 0x6b, 0x0f, 0x2f, 0x50, 0x7d, 0xa5, 0x78, 0x2a,
      0x7a, 0x02, 0x21, 0x00, 0xc6, 0x0d, 0x31, 0x90, 0x4e, 0x36, 0x69, 0x73,
      0x8f, 0xfb, 0xec, 0xca, 0xb6, 0xc3, 0x65, 0x6c, 0x08, 0xe0, 0xed, 0x5c,
      0xb9, 0x2b, 0x3c, 0xfa, 0x5e, 0x7f, 0x71, 0x78, 0x4f, 0x9c, 0x50, 0x21},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x33, 0x31, 0x33, 0x36, 0x30, 0x34, 0x36, 0x31, 0x38, 0x39},
     true},

    // Comment: special case hash
    // tcID: 251
    {SEC_OID_SHA256,
     251,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xbb, 0xd1, 0x6f, 0xbb, 0xb6, 0x56, 0xb6,
      0xd0, 0xd8, 0x3e, 0x6a, 0x77, 0x87, 0xcd, 0x69, 0x1b, 0x08, 0x73, 0x5a,
      0xed, 0x37, 0x17, 0x32, 0x72, 0x3e, 0x1c, 0x68, 0xa4, 0x04, 0x04, 0x51,
      0x7d, 0x02, 0x21, 0x00, 0x9d, 0x8e, 0x35, 0xdb, 0xa9, 0x60, 0x28, 0xb7,
      0x78, 0x7d, 0x91, 0x31, 0x5b, 0xe6, 0x75, 0x87, 0x7d, 0x2d, 0x09, 0x7b,
      0xe5, 0xe8, 0xee, 0x34, 0x56, 0x0e, 0x3e, 0x7f, 0xd2, 0x5c, 0x0f, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x32, 0x36, 0x36, 0x33, 0x37, 0x38, 0x34, 0x32, 0x35, 0x34},
     true},

    // Comment: special case hash
    // tcID: 252
    {SEC_OID_SHA256,
     252,
     {0x30, 0x44, 0x02, 0x20, 0x2e, 0xc9, 0x76, 0x01, 0x22, 0xdb, 0x98, 0xfd,
      0x06, 0xea, 0x76, 0x84, 0x8d, 0x35, 0xa6, 0xda, 0x44, 0x2d, 0x2c, 0xee,
      0xf7, 0x55, 0x9a, 0x30, 0xcf, 0x57, 0xc6, 0x1e, 0x92, 0xdf, 0x32, 0x7e,
      0x02, 0x20, 0x7a, 0xb2, 0x71, 0xda, 0x90, 0x85, 0x94, 0x79, 0x70, 0x1f,
      0xcc, 0xf8, 0x6e, 0x46, 0x2e, 0xe3, 0x39, 0x3f, 0xb6, 0x81, 0x4c, 0x27,
      0xb7, 0x60, 0xc4, 0x96, 0x36, 0x25, 0xc0, 0xa1, 0x98, 0x78},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x36, 0x35, 0x32, 0x31, 0x30, 0x30, 0x35, 0x32, 0x34},
     true},

    // Comment: special case hash
    // tcID: 253
    {SEC_OID_SHA256,
     253,
     {0x30, 0x44, 0x02, 0x20, 0x54, 0xe7, 0x6b, 0x76, 0x83, 0xb6, 0x65, 0x0b,
      0xaa, 0x6a, 0x7f, 0xc4, 0x9b, 0x1c, 0x51, 0xee, 0xd9, 0xba, 0x9d, 0xd4,
      0x63, 0x22, 0x1f, 0x7a, 0x4f, 0x10, 0x05, 0xa8, 0x9f, 0xe0, 0x0c, 0x59,
      0x02, 0x20, 0x2e, 0xa0, 0x76, 0x88, 0x6c, 0x77, 0x3e, 0xb9, 0x37, 0xec,
      0x1c, 0xc8, 0x37, 0x4b, 0x79, 0x15, 0xcf, 0xd1, 0x1b, 0x1c, 0x1a, 0xe1,
      0x16, 0x61, 0x52, 0xf2, 0xf7, 0x80, 0x6a, 0x31, 0xc8, 0xfd},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x35, 0x37, 0x34, 0x38, 0x30, 0x38, 0x31, 0x36, 0x39, 0x36},
     true},

    // Comment: special case hash
    // tcID: 254
    {SEC_OID_SHA256,
     254,
     {0x30, 0x44, 0x02, 0x20, 0x52, 0x91, 0xde, 0xaf, 0x24, 0x65, 0x9f, 0xfb,
      0xbc, 0xe6, 0xe3, 0xc2, 0x6f, 0x60, 0x21, 0x09, 0x7a, 0x74, 0xab, 0xdb,
      0xb6, 0x9b, 0xe4, 0xfb, 0x10, 0x41, 0x9c, 0x0c, 0x49, 0x6c, 0x94, 0x66,
      0x02, 0x20, 0x65, 0xd6, 0xfc, 0xf3, 0x36, 0xd2, 0x7c, 0xc7, 0xcd, 0xb9,
      0x82, 0xbb, 0x4e, 0x4e, 0xce, 0xf5, 0x82, 0x7f, 0x84, 0x74, 0x2f, 0x29,
      0xf1, 0x0a, 0xbf, 0x83, 0x46, 0x92, 0x70, 0xa0, 0x3d, 0xc3},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x36, 0x33, 0x34, 0x33, 0x39, 0x31, 0x33, 0x34, 0x36, 0x38},
     true},

    // Comment: special case hash
    // tcID: 255
    {SEC_OID_SHA256,
     255,
     {0x30, 0x45, 0x02, 0x20, 0x20, 0x7a, 0x32, 0x41, 0x81, 0x2d, 0x75, 0xd9,
      0x47, 0x41, 0x9d, 0xc5, 0x8e, 0xfb, 0x05, 0xe8, 0x00, 0x3b, 0x33, 0xfc,
      0x17, 0xeb, 0x50, 0xf9, 0xd1, 0x51, 0x66, 0xa8, 0x84, 0x79, 0xf1, 0x07,
      0x02, 0x21, 0x00, 0xcd, 0xee, 0x74, 0x9f, 0x2e, 0x49, 0x2b, 0x21, 0x3c,
      0xe8, 0x0b, 0x32, 0xd0, 0x57, 0x4f, 0x62, 0xf1, 0xc5, 0xd7, 0x07, 0x93,
      0xcf, 0x55, 0xe3, 0x82, 0xd5, 0xca, 0xad, 0xf7, 0x59, 0x27, 0x67},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x35, 0x34, 0x31, 0x31, 0x30, 0x33, 0x35, 0x39, 0x38},
     true},

    // Comment: special case hash
    // tcID: 256
    {SEC_OID_SHA256,
     256,
     {0x30, 0x45, 0x02, 0x20, 0x65, 0x54, 0xe4, 0x9f, 0x82, 0xa8, 0x55, 0x20,
      0x43, 0x28, 0xac, 0x94, 0x91, 0x3b, 0xf0, 0x1b, 0xbe, 0x84, 0x43, 0x7a,
      0x35, 0x5a, 0x0a, 0x37, 0xc0, 0xde, 0xe3, 0xcf, 0x81, 0xaa, 0x77, 0x28,
      0x02, 0x21, 0x00, 0xae, 0xa0, 0x0d, 0xe2, 0x50, 0x7d, 0xda, 0xf5, 0xc9,
      0x4e, 0x1e, 0x12, 0x69, 0x80, 0xd3, 0xdf, 0x16, 0x25, 0x0a, 0x2e, 0xae,
      0xbc, 0x8b, 0xe4, 0x86, 0xef, 0xfe, 0x7f, 0x22, 0xb4, 0xf9, 0x29},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x30, 0x34, 0x37, 0x38, 0x35, 0x38, 0x30, 0x31, 0x32, 0x38},
     true},

    // Comment: special case hash
    // tcID: 257
    {SEC_OID_SHA256,
     257,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xa5, 0x4c, 0x50, 0x62, 0x64, 0x83, 0x39,
      0xd2, 0xbf, 0xf0, 0x6f, 0x71, 0xc8, 0x82, 0x16, 0xc2, 0x6c, 0x6e, 0x19,
      0xb4, 0xd8, 0x0a, 0x8c, 0x60, 0x29, 0x90, 0xac, 0x82, 0x70, 0x7e, 0xfd,
      0xfc, 0x02, 0x21, 0x00, 0xe9, 0x9b, 0xbe, 0x7f, 0xcf, 0xaf, 0xae, 0x3e,
      0x69, 0xfd, 0x01, 0x67, 0x77, 0x51, 0x7a, 0xa0, 0x10, 0x56, 0x31, 0x7f,
      0x46, 0x7a, 0xd0, 0x9a, 0xff, 0x09, 0xbe, 0x73, 0xc9, 0x73, 0x1b, 0x0d},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x30, 0x35, 0x33, 0x36, 0x32, 0x38, 0x35, 0x35, 0x36, 0x38},
     true},

    // Comment: special case hash
    // tcID: 258
    {SEC_OID_SHA256,
     258,
     {0x30, 0x45, 0x02, 0x21, 0x00, 0x97, 0x5b, 0xd7, 0x15, 0x7a, 0x8d, 0x36,
      0x3b, 0x30, 0x9f, 0x1f, 0x44, 0x40, 0x12, 0xb1, 0xa1, 0xd2, 0x30, 0x96,
      0x59, 0x31, 0x33, 0xe7, 0x1b, 0x4c, 0xa8, 0xb0, 0x59, 0xcf, 0xf3, 0x7e,
      0xaf, 0x02, 0x20, 0x7f, 0xaa, 0x7a, 0x28, 0xb1, 0xc8, 0x22, 0xba, 0xa2,
      0x41, 0x79, 0x3f, 0x2a, 0xbc, 0x93, 0x0b, 0xd4, 0xc6, 0x98, 0x40, 0xfe,
      0x09, 0x0f, 0x2a, 0xac, 0xc4, 0x67, 0x86, 0xbf, 0x91, 0x96, 0x22},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x39, 0x35, 0x33, 0x39, 0x30, 0x34, 0x31, 0x30, 0x35},
     true},

    // Comment: special case hash
    // tcID: 259
    {SEC_OID_SHA256,
     259,
     {0x30, 0x44, 0x02, 0x20, 0x56, 0x94, 0xa6, 0xf8, 0x4b, 0x8f, 0x87, 0x5c,
      0x27, 0x6a, 0xfd, 0x2e, 0xbc, 0xfe, 0x4d, 0x61, 0xde, 0x9e, 0xc9, 0x03,
      0x05, 0xaf, 0xb1, 0x35, 0x7b, 0x95, 0xb3, 0xe0, 0xda, 0x43, 0x88, 0x5e,
      0x02, 0x20, 0x0d, 0xff, 0xad, 0x9f, 0xfd, 0x0b, 0x75, 0x7d, 0x80, 0x51,
      0xde, 0xc0, 0x2e, 0xbd, 0xf7, 0x0d, 0x8e, 0xe2, 0xdc, 0x5c, 0x78, 0x70,
      0xc0, 0x82, 0x3b, 0x6c, 0xcc, 0x7c, 0x67, 0x9c, 0xba, 0xa4},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x39, 0x37, 0x38, 0x38, 0x34, 0x38, 0x30, 0x33, 0x39},
     true},

    // Comment: special case hash
    // tcID: 260
    {SEC_OID_SHA256,
     260,
     {0x30, 0x45, 0x02, 0x21, 0x00, 0xa0, 0xc3, 0x0e, 0x80, 0x26, 0xfd, 0xb2,
      0xb4, 0xb4, 0x96, 0x8a, 0x27, 0xd1, 0x6a, 0x6d, 0x08, 0xf7, 0x09, 0x8f,
      0x1a, 0x98, 0xd2, 0x16, 0x20, 0xd7, 0x45, 0x4b, 0xa9, 0x79, 0x0f, 0x1b,
      0xa6, 0x02, 0x20, 0x5e, 0x47, 0x04, 0x53, 0xa8, 0xa3, 0x99, 0xf1, 0x5b,
      0xaf, 0x46, 0x3f, 0x9d, 0xec, 0xeb, 0x53, 0xac, 0xc5, 0xca, 0x64, 0x45,
      0x91, 0x49, 0x68, 0x8b, 0xd2, 0x76, 0x0c, 0x65, 0x42, 0x43, 0x39},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x33, 0x36, 0x31, 0x30, 0x36, 0x37, 0x32, 0x34, 0x34, 0x32},
     true},

    // Comment: special case hash
    // tcID: 261
    {SEC_OID_SHA256,
     261,
     {0x30, 0x44, 0x02, 0x20, 0x61, 0x4e, 0xa8, 0x4a, 0xcf, 0x73, 0x65, 0x27,
      0xdd, 0x73, 0x60, 0x2c, 0xd4, 0xbb, 0x4e, 0xea, 0x1d, 0xfe, 0xbe, 0xbd,
      0x5a, 0xd8, 0xac, 0xa5, 0x2a, 0xa0, 0x22, 0x8c, 0xf7, 0xb9, 0x9a, 0x88,
      0x02, 0x20, 0x73, 0x7c, 0xc8, 0x5f, 0x5f, 0x2d, 0x2f, 0x60, 0xd1, 0xb8,
      0x18, 0x3f, 0x3e, 0xd4, 0x90, 0xe4, 0xde, 0x14, 0x36, 0x8e, 0x96, 0xa9,
      0x48, 0x2c, 0x2a, 0x4d, 0xd1, 0x93, 0x19, 0x5c, 0x90, 0x2f},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x30, 0x35, 0x34, 0x32, 0x34, 0x30, 0x37, 0x30, 0x35},
     true},

    // Comment: special case hash
    // tcID: 262
    {SEC_OID_SHA256,
     262,
     {0x30, 0x45, 0x02, 0x21, 0x00, 0xbe, 0xad, 0x67, 0x34, 0xeb, 0xe4, 0x4b,
      0x81, 0x0d, 0x3f, 0xb2, 0xea, 0x00, 0xb1, 0x73, 0x29, 0x45, 0x37, 0x73,
      0x38, 0xfe, 0xbf, 0xd4, 0x39, 0xa8, 0xd7, 0x4d, 0xfb, 0xd0, 0xf9, 0x42,
      0xfa, 0x02, 0x20, 0x6b, 0xb1, 0x8e, 0xae, 0x36, 0x61, 0x6a, 0x7d, 0x3c,
      0xad, 0x35, 0x91, 0x9f, 0xd2, 0x1a, 0x8a, 0xf4, 0xbb, 0xe7, 0xa1, 0x0f,
      0x73, 0xb3, 0xe0, 0x36, 0xa4, 0x6b, 0x10, 0x3e, 0xf5, 0x6e, 0x2a},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x35, 0x31, 0x37, 0x34, 0x34, 0x34, 0x38, 0x31, 0x39, 0x37},
     true},

    // Comment: special case hash
    // tcID: 263
    {SEC_OID_SHA256,
     263,
     {0x30, 0x44, 0x02, 0x20, 0x49, 0x96, 0x25, 0x47, 0x9e, 0x16, 0x1d, 0xac,
      0xd4, 0xdb, 0x9d, 0x9c, 0xe6, 0x48, 0x54, 0xc9, 0x8d, 0x92, 0x2c, 0xbf,
      0x21, 0x27, 0x03, 0xe9, 0x65, 0x4f, 0xae, 0x18, 0x2d, 0xf9, 0xba, 0xd2,
      0x02, 0x20, 0x42, 0xc1, 0x77, 0xcf, 0x37, 0xb8, 0x19, 0x3a, 0x01, 0x31,
      0x10, 0x8d, 0x97, 0x81, 0x9e, 0xdd, 0x94, 0x39, 0x93, 0x60, 0x28, 0x86,
      0x4a, 0xc1, 0x95, 0xb6, 0x4f, 0xca, 0x76, 0xd9, 0xd6, 0x93},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x39, 0x36, 0x37, 0x35, 0x36, 0x31, 0x32, 0x35, 0x31},
     true},

    // Comment: special case hash
    // tcID: 264
    {SEC_OID_SHA256,
     264,
     {0x30, 0x45, 0x02, 0x20, 0x08, 0xf1, 0x6b, 0x80, 0x93, 0xa8, 0xfb, 0x4d,
      0x66, 0xa2, 0xc8, 0x06, 0x5b, 0x54, 0x1b, 0x3d, 0x31, 0xe3, 0xbf, 0xe6,
      0x94, 0xf6, 0xb8, 0x9c, 0x50, 0xfb, 0x1a, 0xaa, 0x6f, 0xf6, 0xc9, 0xb2,
      0x02, 0x21, 0x00, 0x9d, 0x64, 0x55, 0xe2, 0xd5, 0xd1, 0x77, 0x97, 0x48,
      0x57, 0x3b, 0x61, 0x1c, 0xb9, 0x5d, 0x4a, 0x21, 0xf9, 0x67, 0x41, 0x03,
      0x99, 0xb3, 0x9b, 0x53, 0x5b, 0xa3, 0xe5, 0xaf, 0x81, 0xca, 0x2e},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x33, 0x34, 0x34, 0x37, 0x32, 0x35, 0x33, 0x33, 0x34, 0x33},
     true},

    // Comment: special case hash
    // tcID: 265
    {SEC_OID_SHA256,
     265,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xbe, 0x26, 0x23, 0x1b, 0x61, 0x91, 0x65,
      0x8a, 0x19, 0xdd, 0x72, 0xdd, 0xb9, 0x9e, 0xd8, 0xf8, 0xc5, 0x79, 0xb6,
      0x93, 0x8d, 0x19, 0xbc, 0xe8, 0xee, 0xd8, 0xdc, 0x2b, 0x33, 0x8c, 0xb5,
      0xf8, 0x02, 0x21, 0x00, 0xe1, 0xd9, 0xa3, 0x2e, 0xe5, 0x6c, 0xff, 0xed,
      0x37, 0xf0, 0xf2, 0x2b, 0x2d, 0xcb, 0x57, 0xd5, 0xc9, 0x43, 0xc1, 0x4f,
      0x79, 0x69, 0x4a, 0x03, 0xb9, 0xc5, 0xe9, 0x69, 0x52, 0x57, 0x5c, 0x89},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x33, 0x36, 0x38, 0x32, 0x36, 0x34, 0x33, 0x31, 0x38},
     true},

    // Comment: special case hash
    // tcID: 266
    {SEC_OID_SHA256,
     266,
     {0x30, 0x45, 0x02, 0x20, 0x15, 0xe7, 0x68, 0x80, 0x89, 0x83, 0x16, 0xb1,
      0x62, 0x04, 0xac, 0x92, 0x0a, 0x02, 0xd5, 0x80, 0x45, 0xf3, 0x6a, 0x22,
      0x9d, 0x4a, 0xa4, 0xf8, 0x12, 0x63, 0x8c, 0x45, 0x5a, 0xbe, 0x04, 0x43,
      0x02, 0x21, 0x00, 0xe7, 0x4d, 0x35, 0x7d, 0x3f, 0xcb, 0x5c, 0x8c, 0x53,
      0x37, 0xbd, 0x6a, 0xba, 0x41, 0x78, 0xb4, 0x55, 0xca, 0x10, 0xe2, 0x26,
      0xe1, 0x3f, 0x96, 0x38, 0x19, 0x65, 0x06, 0xa1, 0x93, 0x91, 0x23},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x33, 0x32, 0x36, 0x31, 0x31, 0x39, 0x38, 0x36, 0x30, 0x38},
     true},

    // Comment: special case hash
    // tcID: 267
    {SEC_OID_SHA256,
     267,
     {0x30, 0x44, 0x02, 0x20, 0x35, 0x2e, 0xcb, 0x53, 0xf8, 0xdf, 0x2c, 0x50,
      0x3a, 0x45, 0xf9, 0x84, 0x6f, 0xc2, 0x8d, 0x1d, 0x31, 0xe6, 0x30, 0x7d,
      0x3d, 0xdb, 0xff, 0xc1, 0x13, 0x23, 0x15, 0xcc, 0x07, 0xf1, 0x6d, 0xad,
      0x02, 0x20, 0x13, 0x48, 0xdf, 0xa9, 0xc4, 0x82, 0xc5, 0x58, 0xe1, 0xd0,
      0x5c, 0x52, 0x42, 0xca, 0x1c, 0x39, 0x43, 0x67, 0x26, 0xec, 0xd2, 0x82,
      0x58, 0xb1, 0x89, 0x97, 0x92, 0x88, 0x7d, 0xd0, 0xa3, 0xc6},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x39, 0x36, 0x37, 0x38, 0x37, 0x38, 0x31, 0x30, 0x39, 0x34},
     true},

    // Comment: special case hash
    // tcID: 268
    {SEC_OID_SHA256,
     268,
     {0x30, 0x44, 0x02, 0x20, 0x4a, 0x40, 0x80, 0x1a, 0x7e, 0x60, 0x6b, 0xa7,
      0x8a, 0x0d, 0xa9, 0x88, 0x2a, 0xb2, 0x3c, 0x76, 0x77, 0xb8, 0x64, 0x23,
      0x49, 0xed, 0x3d, 0x65, 0x2c, 0x5b, 0xfa, 0x5f, 0x2a, 0x95, 0x58, 0xfb,
      0x02, 0x20, 0x3a, 0x49, 0xb6, 0x48, 0x48, 0xd6, 0x82, 0xef, 0x7f, 0x60,
      0x5f, 0x28, 0x32, 0xf7, 0x38, 0x4b, 0xdc, 0x24, 0xed, 0x29, 0x25, 0x82,
      0x5b, 0xf8, 0xea, 0x77, 0xdc, 0x59, 0x81, 0x72, 0x57, 0x82},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x34, 0x39, 0x35, 0x38, 0x38, 0x32, 0x33, 0x38, 0x32, 0x33},
     true},

    // Comment: special case hash
    // tcID: 269
    {SEC_OID_SHA256,
     269,
     {0x30, 0x45, 0x02, 0x21, 0x00, 0xea, 0xcc, 0x5e, 0x1a, 0x83, 0x04, 0xa7,
      0x4d, 0x2b, 0xe4, 0x12, 0xb0, 0x78, 0x92, 0x4b, 0x3b, 0xb3, 0x51, 0x1b,
      0xac, 0x85, 0x5c, 0x05, 0xc9, 0xe5, 0xe9, 0xe4, 0x4d, 0xf3, 0xd6, 0x1e,
      0x96, 0x02, 0x20, 0x74, 0x51, 0xcd, 0x8e, 0x18, 0xd6, 0xed, 0x18, 0x85,
      0xdd, 0x82, 0x77, 0x14, 0x84, 0x7f, 0x96, 0xec, 0x4b, 0xb0, 0xed, 0x4c,
      0x36, 0xce, 0x98, 0x08, 0xdb, 0x8f, 0x71, 0x42, 0x04, 0xf6, 0xd1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x38, 0x32, 0x34, 0x36, 0x33, 0x37, 0x38, 0x33, 0x37},
     true},

    // Comment: special case hash
    // tcID: 270
    {SEC_OID_SHA256,
     270,
     {0x30, 0x45, 0x02, 0x20, 0x2f, 0x7a, 0x5e, 0x9e, 0x57, 0x71, 0xd4, 0x24,
      0xf3, 0x0f, 0x67, 0xfd, 0xab, 0x61, 0xe8, 0xce, 0x4f, 0x8c, 0xd1, 0x21,
      0x48, 0x82, 0xad, 0xb6, 0x5f, 0x7d, 0xe9, 0x4c, 0x31, 0x57, 0x70, 0x52,
      0x02, 0x21, 0x00, 0xac, 0x4e, 0x69, 0x80, 0x83, 0x45, 0x80, 0x9b, 0x44,
      0xac, 0xb0, 0xb2, 0xbd, 0x88, 0x91, 0x75, 0xfb, 0x75, 0xdd, 0x05, 0x0c,
      0x5a, 0x44, 0x9a, 0xb9, 0x52, 0x8f, 0x8f, 0x78, 0xda, 0xa1, 0x0c},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x31, 0x30, 0x32, 0x30, 0x38, 0x33, 0x33, 0x37, 0x37, 0x36},
     true},

    // Comment: special case hash
    // tcID: 271
    {SEC_OID_SHA256,
     271,
     {0x30, 0x45, 0x02, 0x21, 0x00, 0xff, 0xcd, 0xa4, 0x0f, 0x79, 0x2c, 0xe4,
      0xd9, 0x3e, 0x7e, 0x0f, 0x0e, 0x95, 0xe1, 0xa2, 0x14, 0x7d, 0xdd, 0xd7,
      0xf6, 0x48, 0x76, 0x21, 0xc3, 0x0a, 0x03, 0xd7, 0x10, 0xb3, 0x30, 0x02,
      0x19, 0x02, 0x20, 0x79, 0x93, 0x8b, 0x55, 0xf8, 0xa1, 0x7f, 0x7e, 0xd7,
      0xba, 0x9a, 0xde, 0x8f, 0x20, 0x65, 0xa1, 0xfa, 0x77, 0x61, 0x8f, 0x0b,
      0x67, 0xad, 0xd8, 0xd5, 0x8c, 0x42, 0x2c, 0x24, 0x53, 0xa4, 0x9a},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x33, 0x33, 0x38, 0x37, 0x31, 0x36, 0x34, 0x38},
     true},

    // Comment: special case hash
    // tcID: 272
    {SEC_OID_SHA256,
     272,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0x81, 0xf2, 0x35, 0x9c, 0x4f, 0xab, 0xa6,
      0xb5, 0x3d, 0x3e, 0x8c, 0x8c, 0x3f, 0xcc, 0x16, 0xa9, 0x48, 0x35, 0x0f,
      0x7a, 0xb3, 0xa5, 0x88, 0xb2, 0x8c, 0x17, 0x60, 0x3a, 0x43, 0x1e, 0x39,
      0xa8, 0x02, 0x21, 0x00, 0xcd, 0x6f, 0x6a, 0x5c, 0xc3, 0xb5, 0x5e, 0xad,
      0x0f, 0xf6, 0x95, 0xd0, 0x6c, 0x68, 0x60, 0xb5, 0x09, 0xe4, 0x6d, 0x99,
      0xfc, 0xce, 0xfb, 0x9f, 0x7f, 0x9e, 0x10, 0x18, 0x57, 0xf7, 0x43, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x33, 0x32, 0x32, 0x31, 0x34, 0x34, 0x31, 0x36, 0x32},
     true},

    // Comment: special case hash
    // tcID: 273
    {SEC_OID_SHA256,
     273,
     {0x30, 0x45, 0x02, 0x21, 0x00, 0xdf, 0xc8, 0xbf, 0x52, 0x04, 0x45, 0xcb,
      0xb8, 0xee, 0x15, 0x96, 0xfb, 0x07, 0x3e, 0xa2, 0x83, 0xea, 0x13, 0x02,
      0x51, 0xa6, 0xfd, 0xff, 0xa5, 0xc3, 0xf5, 0xf2, 0xaa, 0xf7, 0x5c, 0xa8,
      0x08, 0x02, 0x20, 0x04, 0x8e, 0x33, 0xef, 0xce, 0x14, 0x7c, 0x9d, 0xd9,
      0x28, 0x23, 0x64, 0x0e, 0x33, 0x8e, 0x68, 0xbf, 0xd7, 0xd0, 0xdc, 0x7a,
      0x49, 0x05, 0xb3, 0xa7, 0xac, 0x71, 0x1e, 0x57, 0x7e, 0x90, 0xe7},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x30, 0x36, 0x38, 0x36, 0x36, 0x35, 0x35, 0x35, 0x34, 0x36},
     true},

    // Comment: special case hash
    // tcID: 274
    {SEC_OID_SHA256,
     274,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xad, 0x01, 0x9f, 0x74, 0xc6, 0x94, 0x1d,
      0x20, 0xef, 0xda, 0x70, 0xb4, 0x6c, 0x53, 0xdb, 0x16, 0x65, 0x03, 0xa0,
      0xe3, 0x93, 0xe9, 0x32, 0xf6, 0x88, 0x22, 0x76, 0x88, 0xba, 0x6a, 0x57,
      0x62, 0x02, 0x21, 0x00, 0x93, 0x32, 0x0e, 0xb7, 0xca, 0x07, 0x10, 0x25,
      0x53, 0x46, 0xbd, 0xbb, 0x31, 0x02, 0xcd, 0xcf, 0x79, 0x64, 0xef, 0x2e,
      0x09, 0x88, 0xe7, 0x12, 0xbc, 0x05, 0xef, 0xe1, 0x6c, 0x19, 0x93, 0x45},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x36, 0x32, 0x31, 0x35, 0x35, 0x32, 0x34, 0x36},
     true},

    // Comment: special case hash
    // tcID: 275
    {SEC_OID_SHA256,
     275,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xac, 0x80, 0x96, 0x84, 0x2e, 0x8a, 0xdd,
      0x68, 0xc3, 0x4e, 0x78, 0xce, 0x11, 0xdd, 0x71, 0xe4, 0xb5, 0x43, 0x16,
      0xbd, 0x3e, 0xbf, 0x7f, 0xff, 0xde, 0xb7, 0xbd, 0x5a, 0x3e, 0xbc, 0x18,
      0x83, 0x02, 0x21, 0x00, 0xf5, 0xca, 0x2f, 0x4f, 0x23, 0xd6, 0x74, 0x50,
      0x2d, 0x4c, 0xaf, 0x85, 0xd1, 0x87, 0x21, 0x5d, 0x36, 0xe3, 0xce, 0x9f,
      0x0c, 0xe2, 0x19, 0x70, 0x9f, 0x21, 0xa3, 0xaa, 0xc0, 0x03, 0xb7, 0xa8},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x37, 0x30, 0x33, 0x30, 0x38, 0x31, 0x38, 0x37, 0x37, 0x34},
     true},

    // Comment: special case hash
    // tcID: 276
    {SEC_OID_SHA256,
     276,
     {0x30, 0x44, 0x02, 0x20, 0x67, 0x7b, 0x2d, 0x3a, 0x59, 0xb1, 0x8a, 0x5f,
      0xf9, 0x39, 0xb7, 0x0e, 0xa0, 0x02, 0x25, 0x08, 0x89, 0xdd, 0xcd, 0x7b,
      0x7b, 0x9d, 0x77, 0x68, 0x54, 0xb4, 0x94, 0x36, 0x93, 0xfb, 0x92, 0xf7,
      0x02, 0x20, 0x6b, 0x4b, 0xa8, 0x56, 0xad, 0xe7, 0x67, 0x7b, 0xf3, 0x03,
      0x07, 0xb2, 0x1f, 0x3c, 0xcd, 0xa3, 0x5d, 0x2f, 0x63, 0xae, 0xe8, 0x1e,
      0xfd, 0x0b, 0xab, 0x69, 0x72, 0xcc, 0x07, 0x95, 0xdb, 0x55},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x35, 0x39, 0x32, 0x34, 0x35, 0x32, 0x33, 0x37, 0x34, 0x34},
     true},

    // Comment: special case hash
    // tcID: 277
    {SEC_OID_SHA256,
     277,
     {0x30, 0x45, 0x02, 0x20, 0x47, 0x9e, 0x1d, 0xed, 0x14, 0xbc, 0xae, 0xd0,
      0x37, 0x9b, 0xa8, 0xe1, 0xb7, 0x3d, 0x31, 0x15, 0xd8, 0x4d, 0x31, 0xd4,
      0xb7, 0xc3, 0x0e, 0x1f, 0x05, 0xe1, 0xfc, 0x0d, 0x59, 0x57, 0xcf, 0xb0,
      0x02, 0x21, 0x00, 0x91, 0x8f, 0x79, 0xe3, 0x5b, 0x3d, 0x89, 0x48, 0x7c,
      0xf6, 0x34, 0xa4, 0xf0, 0x5b, 0x2e, 0x0c, 0x30, 0x85, 0x7c, 0xa8, 0x79,
      0xf9, 0x7c, 0x77, 0x1e, 0x87, 0x70, 0x27, 0x35, 0x5b, 0x24, 0x43},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x34, 0x39, 0x35, 0x35, 0x38, 0x36, 0x36, 0x32, 0x31},
     true},

    // Comment: special case hash
    // tcID: 278
    {SEC_OID_SHA256,
     278,
     {0x30, 0x44, 0x02, 0x20, 0x43, 0xdf, 0xcc, 0xd0, 0xed, 0xb9, 0xe2, 0x80,
      0xd9, 0xa5, 0x8f, 0x01, 0x16, 0x4d, 0x55, 0xc3, 0xd7, 0x11, 0xe1, 0x4b,
      0x12, 0xac, 0x5c, 0xf3, 0xb6, 0x48, 0x40, 0xea, 0xd5, 0x12, 0xa0, 0xa3,
      0x02, 0x20, 0x1d, 0xbe, 0x33, 0xfa, 0x8b, 0xa8, 0x45, 0x33, 0xcd, 0x5c,
      0x49, 0x34, 0x36, 0x5b, 0x34, 0x42, 0xca, 0x11, 0x74, 0x89, 0x9b, 0x78,
      0xef, 0x9a, 0x31, 0x99, 0xf4, 0x95, 0x84, 0x38, 0x97, 0x72},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x34, 0x30, 0x30, 0x35, 0x33, 0x31, 0x34, 0x34, 0x30, 0x36},
     true},

    // Comment: special case hash
    // tcID: 279
    {SEC_OID_SHA256,
     279,
     {0x30, 0x44, 0x02, 0x20, 0x5b, 0x09, 0xab, 0x63, 0x7b, 0xd4, 0xca, 0xf0,
      0xf4, 0xc7, 0xc7, 0xe4, 0xbc, 0xa5, 0x92, 0xfe, 0xa2, 0x0e, 0x90, 0x87,
      0xc2, 0x59, 0xd2, 0x6a, 0x38, 0xbb, 0x40, 0x85, 0xf0, 0xbb, 0xff, 0x11,
      0x02, 0x20, 0x45, 0xb7, 0xeb, 0x46, 0x7b, 0x67, 0x48, 0xaf, 0x61, 0x8e,
      0x9d, 0x80, 0xd6, 0xfd, 0xcd, 0x6a, 0xa2, 0x49, 0x64, 0xe5, 0xa1, 0x3f,
      0x88, 0x5b, 0xca, 0x81, 0x01, 0xde, 0x08, 0xeb, 0x0d, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x33, 0x30, 0x39, 0x36, 0x34, 0x35, 0x37, 0x35, 0x31, 0x32},
     true},

    // Comment: special case hash
    // tcID: 280
    {SEC_OID_SHA256,
     280,
     {0x30, 0x45, 0x02, 0x20, 0x5e, 0x9b, 0x1c, 0x5a, 0x02, 0x80, 0x70, 0xdf,
      0x57, 0x28, 0xc5, 0xc8, 0xaf, 0x9b, 0x74, 0xe0, 0x66, 0x7a, 0xfa, 0x57,
      0x0a, 0x6c, 0xfa, 0x01, 0x14, 0xa5, 0x03, 0x9e, 0xd1, 0x5e, 0xe0, 0x6f,
      0x02, 0x21, 0x00, 0xb1, 0x36, 0x09, 0x07, 0xe2, 0xd9, 0x78, 0x5e, 0xad,
      0x36, 0x2b, 0xb8, 0xd7, 0xbd, 0x66, 0x1b, 0x6c, 0x29, 0xee, 0xff, 0xd3,
      0xc5, 0x03, 0x77, 0x44, 0xed, 0xae, 0xb9, 0xad, 0x99, 0x0c, 0x20},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x32, 0x37, 0x38, 0x34, 0x30, 0x32, 0x35, 0x36, 0x32, 0x30},
     true},

    // Comment: special case hash
    // tcID: 281
    {SEC_OID_SHA256,
     281,
     {0x30, 0x45, 0x02, 0x20, 0x06, 0x71, 0xa0, 0xa8, 0x5c, 0x2b, 0x72, 0xd5,
      0x4a, 0x2f, 0xb0, 0x99, 0x0e, 0x34, 0x53, 0x8b, 0x48, 0x90, 0x05, 0x0f,
      0x5a, 0x57, 0x12, 0xf6, 0xd1, 0xa7, 0xa5, 0xfb, 0x85, 0x78, 0xf3, 0x2e,
      0x02, 0x21, 0x00, 0xdb, 0x18, 0x46, 0xba, 0xb6, 0xb7, 0x36, 0x14, 0x79,
      0xab, 0x9c, 0x32, 0x85, 0xca, 0x41, 0x29, 0x18, 0x08, 0xf2, 0x7f, 0xd5,
      0xbd, 0x4f, 0xda, 0xc7, 0x20, 0xe5, 0x85, 0x47, 0x13, 0x69, 0x4c},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x32, 0x36, 0x31, 0x38, 0x37, 0x38, 0x37, 0x34, 0x31, 0x38},
     true},

    // Comment: special case hash
    // tcID: 282
    {SEC_OID_SHA256,
     282,
     {0x30, 0x44, 0x02, 0x20, 0x76, 0x73, 0xf8, 0x52, 0x67, 0x48, 0x44, 0x64,
      0x77, 0xdb, 0xbb, 0x05, 0x90, 0xa4, 0x54, 0x92, 0xc5, 0xd7, 0xd6, 0x98,
      0x59, 0xd3, 0x01, 0xab, 0xba, 0xed, 0xb3, 0x5b, 0x20, 0x95, 0x10, 0x3a,
      0x02, 0x20, 0x3d, 0xc7, 0x0d, 0xdf, 0x9c, 0x6b, 0x52, 0x4d, 0x88, 0x6b,
      0xed, 0x9e, 0x6a, 0xf0, 0x2e, 0x0e, 0x4d, 0xec, 0x0d, 0x41, 0x7a, 0x41,
      0x4f, 0xed, 0x38, 0x07, 0xef, 0x44, 0x22, 0x91, 0x3d, 0x7c},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x31, 0x36, 0x34, 0x32, 0x36, 0x32, 0x35, 0x32, 0x36, 0x32},
     true},

    // Comment: special case hash
    // tcID: 283
    {SEC_OID_SHA256,
     283,
     {0x30, 0x44, 0x02, 0x20, 0x7f, 0x08, 0x54, 0x41, 0x07, 0x0e, 0xcd, 0x2b,
      0xb2, 0x12, 0x85, 0x08, 0x9e, 0xbb, 0x1a, 0xa6, 0x45, 0x0d, 0x1a, 0x06,
      0xc3, 0x6d, 0x3f, 0xf3, 0x9d, 0xfd, 0x65, 0x7a, 0x79, 0x6d, 0x12, 0xb5,
      0x02, 0x20, 0x24, 0x97, 0x12, 0x01, 0x20, 0x29, 0x87, 0x0a, 0x24, 0x59,
      0xd1, 0x8d, 0x47, 0xda, 0x9a, 0xa4, 0x92, 0xa5, 0xe6, 0xcb, 0x4b, 0x2d,
      0x8d, 0xaf, 0xa9, 0xe4, 0xc5, 0xc5, 0x4a, 0x2b, 0x9a, 0x8b},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x36, 0x38, 0x32, 0x34, 0x31, 0x38, 0x39, 0x34, 0x33, 0x36},
     true},

    // Comment: special case hash
    // tcID: 284
    {SEC_OID_SHA256,
     284,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0x91, 0x4c, 0x67, 0xfb, 0x61, 0xdd, 0x1e,
      0x27, 0xc8, 0x67, 0x39, 0x8e, 0xa7, 0x32, 0x2d, 0x5a, 0xb7, 0x6d, 0xf0,
      0x4b, 0xc5, 0xaa, 0x66, 0x83, 0xa8, 0xe0, 0xf3, 0x0a, 0x5d, 0x28, 0x73,
      0x48, 0x02, 0x21, 0x00, 0xfa, 0x07, 0x47, 0x40, 0x31, 0x48, 0x1d, 0xda,
      0x49, 0x53, 0xe3, 0xac, 0x19, 0x59, 0xee, 0x8c, 0xea, 0x7e, 0x66, 0xec,
      0x41, 0x2b, 0x38, 0xd6, 0xc9, 0x6d, 0x28, 0xf6, 0xd3, 0x73, 0x04, 0xea},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc,
      0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19,
      0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38, 0xc7,
      0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a,
      0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d,
      0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e},
     {0x34, 0x38, 0x34, 0x32, 0x34, 0x35, 0x34, 0x32, 0x35},
     true},

    // Comment: k*G has a large x-coordinate
    // tcID: 285
    {SEC_OID_SHA256,
     285,
     {0x30, 0x35, 0x02, 0x10, 0x43, 0x19, 0x05, 0x53, 0x58, 0xe8, 0x61,
      0x7b, 0x0c, 0x46, 0x35, 0x3d, 0x03, 0x9c, 0xda, 0xab, 0x02, 0x21,
      0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7,
      0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x4e},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x0a, 0xd9, 0x95, 0x00, 0x28, 0x8d, 0x46, 0x69, 0x40,
      0x03, 0x1d, 0x72, 0xa9, 0xf5, 0x44, 0x5a, 0x4d, 0x43, 0x78, 0x46, 0x40,
      0x85, 0x5b, 0xf0, 0xa6, 0x98, 0x74, 0xd2, 0xde, 0x5f, 0xe1, 0x03, 0xc5,
      0x01, 0x1e, 0x6e, 0xf2, 0xc4, 0x2d, 0xcd, 0x50, 0xd5, 0xd3, 0xd2, 0x9f,
      0x99, 0xae, 0x6e, 0xba, 0x2c, 0x80, 0xc9, 0x24, 0x4f, 0x4c, 0x54, 0x22,
      0xf0, 0x97, 0x9f, 0xf0, 0xc3, 0xba, 0x5e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: r too large
    // tcID: 286
    {SEC_OID_SHA256,
     286,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfc, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x4e},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x0a, 0xd9, 0x95, 0x00, 0x28, 0x8d, 0x46, 0x69, 0x40,
      0x03, 0x1d, 0x72, 0xa9, 0xf5, 0x44, 0x5a, 0x4d, 0x43, 0x78, 0x46, 0x40,
      0x85, 0x5b, 0xf0, 0xa6, 0x98, 0x74, 0xd2, 0xde, 0x5f, 0xe1, 0x03, 0xc5,
      0x01, 0x1e, 0x6e, 0xf2, 0xc4, 0x2d, 0xcd, 0x50, 0xd5, 0xd3, 0xd2, 0x9f,
      0x99, 0xae, 0x6e, 0xba, 0x2c, 0x80, 0xc9, 0x24, 0x4f, 0x4c, 0x54, 0x22,
      0xf0, 0x97, 0x9f, 0xf0, 0xc3, 0xba, 0x5e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: r,s are large
    // tcID: 287
    {SEC_OID_SHA256,
     287,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa,
      0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25,
      0x4f, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x4e},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xab, 0x05, 0xfd, 0x9d, 0x0d, 0xe2, 0x6b, 0x9c, 0xe6,
      0xf4, 0x81, 0x96, 0x52, 0xd9, 0xfc, 0x69, 0x19, 0x3d, 0x0a, 0xa3, 0x98,
      0xf0, 0xfb, 0xa8, 0x01, 0x3e, 0x09, 0xc5, 0x82, 0x20, 0x45, 0x54, 0x19,
      0x23, 0x52, 0x71, 0x22, 0x8c, 0x78, 0x67, 0x59, 0x09, 0x5d, 0x12, 0xb7,
      0x5a, 0xf0, 0x69, 0x2d, 0xd4, 0x10, 0x3f, 0x19, 0xf6, 0xa8, 0xc3, 0x2f,
      0x49, 0x43, 0x5a, 0x1e, 0x9b, 0x8d, 0x45},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: r and s^-1 have a large Hamming weight
    // tcID: 288
    {SEC_OID_SHA256,
     288,
     {0x30, 0x45, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x21, 0x00, 0x90, 0x91, 0x35, 0xbd, 0xb6, 0x79, 0x92, 0x86, 0x17,
      0x0f, 0x5e, 0xad, 0x2d, 0xe4, 0xf6, 0x51, 0x14, 0x53, 0xfe, 0x50, 0x91,
      0x4f, 0x3d, 0xf2, 0xde, 0x54, 0xa3, 0x63, 0x83, 0xdf, 0x8d, 0xd4},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x80, 0x98, 0x4f, 0x39, 0xa1, 0xff, 0x38, 0xa8, 0x6a,
      0x68, 0xaa, 0x42, 0x01, 0xb6, 0xbe, 0x5d, 0xfb, 0xfe, 0xcf, 0x87, 0x62,
      0x19, 0x71, 0x0b, 0x07, 0xba, 0xdf, 0x6f, 0xdd, 0x4c, 0x6c, 0x56, 0x11,
      0xfe, 0xb9, 0x73, 0x90, 0xd9, 0x82, 0x6e, 0x7a, 0x06, 0xdf, 0xb4, 0x18,
      0x71, 0xc9, 0x40, 0xd7, 0x44, 0x15, 0xed, 0x3c, 0xac, 0x20, 0x89, 0xf1,
      0x44, 0x50, 0x19, 0xbb, 0x55, 0xed, 0x95},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: r and s^-1 have a large Hamming weight
    // tcID: 289
    {SEC_OID_SHA256,
     289,
     {0x30, 0x44, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x20, 0x27, 0xb4, 0x57, 0x7c, 0xa0, 0x09, 0x37, 0x6f, 0x71, 0x30,
      0x3f, 0xd5, 0xdd, 0x22, 0x7d, 0xce, 0xf5, 0xde, 0xb7, 0x73, 0xad, 0x5f,
      0x5a, 0x84, 0x36, 0x06, 0x44, 0x66, 0x9c, 0xa2, 0x49, 0xa5},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x42, 0x01, 0xb4, 0x27, 0x29, 0x44, 0x20, 0x1c, 0x32,
      0x94, 0xf5, 0xba, 0xa9, 0xa3, 0x23, 0x2b, 0x6d, 0xd6, 0x87, 0x49, 0x5f,
      0xcc, 0x19, 0xa7, 0x0a, 0x95, 0xbc, 0x60, 0x2b, 0x4f, 0x7c, 0x05, 0x95,
      0xc3, 0x7e, 0xba, 0x9e, 0xe8, 0x17, 0x1c, 0x1b, 0xb5, 0xac, 0x6f, 0xea,
      0xf7, 0x53, 0xbc, 0x36, 0xf4, 0x63, 0xe3, 0xae, 0xf1, 0x66, 0x29, 0x57,
      0x2c, 0x0c, 0x0a, 0x8f, 0xb0, 0x80, 0x0e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: small r and s
    // tcID: 290
    {SEC_OID_SHA256,
     290,
     {0x30, 0x06, 0x02, 0x01, 0x05, 0x02, 0x01, 0x01},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xa7, 0x1a, 0xf6, 0x4d, 0xe5, 0x12, 0x6a, 0x4a, 0x4e,
      0x02, 0xb7, 0x92, 0x2d, 0x66, 0xce, 0x94, 0x15, 0xce, 0x88, 0xa4, 0xc9,
      0xd2, 0x55, 0x14, 0xd9, 0x10, 0x82, 0xc8, 0x72, 0x5a, 0xc9, 0x57, 0x5d,
      0x47, 0x72, 0x3c, 0x8f, 0xbe, 0x58, 0x0b, 0xb3, 0x69, 0xfe, 0xc9, 0xc2,
      0x66, 0x5d, 0x8e, 0x30, 0xa4, 0x35, 0xb9, 0x93, 0x26, 0x45, 0x48, 0x2e,
      0x7c, 0x9f, 0x11, 0xe8, 0x72, 0x29, 0x6b},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: small r and s
    // tcID: 291
    {SEC_OID_SHA256,
     291,
     {0x30, 0x06, 0x02, 0x01, 0x05, 0x02, 0x01, 0x03},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x66, 0x27, 0xce, 0xc4, 0xf0, 0x73, 0x1e, 0xa2, 0x3f,
      0xc2, 0x93, 0x1f, 0x90, 0xeb, 0xe5, 0xb7, 0x57, 0x2f, 0x59, 0x7d, 0x20,
      0xdf, 0x08, 0xfc, 0x2b, 0x31, 0xee, 0x8e, 0xf1, 0x6b, 0x15, 0x72, 0x61,
      0x70, 0xed, 0x77, 0xd8, 0xd0, 0xa1, 0x4f, 0xc5, 0xc9, 0xc3, 0xc4, 0xc9,
      0xbe, 0x7f, 0x0d, 0x3e, 0xe1, 0x8f, 0x70, 0x9b, 0xb2, 0x75, 0xea, 0xf2,
      0x07, 0x3e, 0x25, 0x8f, 0xe6, 0x94, 0xa5},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: small r and s
    // tcID: 292
    {SEC_OID_SHA256,
     292,
     {0x30, 0x06, 0x02, 0x01, 0x05, 0x02, 0x01, 0x05},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x5a, 0x7c, 0x88, 0x25, 0xe8, 0x56, 0x91, 0xcc, 0xe1,
      0xf5, 0xe7, 0x54, 0x4c, 0x54, 0xe7, 0x3f, 0x14, 0xaf, 0xc0, 0x10, 0xcb,
      0x73, 0x13, 0x43, 0x26, 0x2c, 0xa7, 0xec, 0x5a, 0x77, 0xf5, 0xbf, 0xef,
      0x6e, 0xdf, 0x62, 0xa4, 0x49, 0x7c, 0x1b, 0xd7, 0xb1, 0x47, 0xfb, 0x6c,
      0x3d, 0x22, 0xaf, 0x3c, 0x39, 0xbf, 0xce, 0x95, 0xf3, 0x0e, 0x13, 0xa1,
      0x6d, 0x3d, 0x7b, 0x28, 0x12, 0xf8, 0x13},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: small r and s
    // tcID: 293
    {SEC_OID_SHA256,
     293,
     {0x30, 0x06, 0x02, 0x01, 0x05, 0x02, 0x01, 0x06},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xcb, 0xe0, 0xc2, 0x91, 0x32, 0xcd, 0x73, 0x83, 0x64,
      0xfe, 0xdd, 0x60, 0x31, 0x52, 0x99, 0x0c, 0x04, 0x8e, 0x5e, 0x2f, 0xff,
      0x99, 0x6d, 0x88, 0x3f, 0xa6, 0xca, 0xca, 0x79, 0x78, 0xc7, 0x37, 0x70,
      0xaf, 0x6a, 0x8c, 0xe4, 0x4c, 0xb4, 0x12, 0x24, 0xb2, 0x60, 0x36, 0x06,
      0xf4, 0xc0, 0x4d, 0x18, 0x8e, 0x80, 0xbf, 0xf7, 0xcc, 0x31, 0xad, 0x51,
      0x89, 0xd4, 0xab, 0x0d, 0x70, 0xe8, 0xc1},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: r is larger than n
    // tcID: 294
    {SEC_OID_SHA256,
     294,
     {0x30, 0x26, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3,
      0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x56, 0x02, 0x01, 0x06},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xcb, 0xe0, 0xc2, 0x91, 0x32, 0xcd, 0x73, 0x83, 0x64,
      0xfe, 0xdd, 0x60, 0x31, 0x52, 0x99, 0x0c, 0x04, 0x8e, 0x5e, 0x2f, 0xff,
      0x99, 0x6d, 0x88, 0x3f, 0xa6, 0xca, 0xca, 0x79, 0x78, 0xc7, 0x37, 0x70,
      0xaf, 0x6a, 0x8c, 0xe4, 0x4c, 0xb4, 0x12, 0x24, 0xb2, 0x60, 0x36, 0x06,
      0xf4, 0xc0, 0x4d, 0x18, 0x8e, 0x80, 0xbf, 0xf7, 0xcc, 0x31, 0xad, 0x51,
      0x89, 0xd4, 0xab, 0x0d, 0x70, 0xe8, 0xc1},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: s is larger than n
    // tcID: 295
    {SEC_OID_SHA256,
     295,
     {0x30, 0x26, 0x02, 0x01, 0x05, 0x02, 0x21, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17,
      0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x75, 0xfb, 0xd8},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x4b, 0xe4, 0x17, 0x80, 0x97, 0x00, 0x2f, 0x0d, 0xea,
      0xb6, 0x8f, 0x0d, 0x9a, 0x13, 0x0e, 0x0e, 0xd3, 0x3a, 0x67, 0x95, 0xd0,
      0x2a, 0x20, 0x79, 0x6d, 0xb8, 0x34, 0x44, 0xb0, 0x37, 0xe1, 0x39, 0x20,
      0xf1, 0x30, 0x51, 0xe0, 0xee, 0xcd, 0xcf, 0xce, 0x4d, 0xac, 0xea, 0x0f,
      0x50, 0xd1, 0xf2, 0x47, 0xca, 0xa6, 0x69, 0xf1, 0x93, 0xc1, 0xb4, 0x07,
      0x5b, 0x51, 0xae, 0x29, 0x6d, 0x2d, 0x56},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: small r and s^-1
    // tcID: 296
    {SEC_OID_SHA256,
     296,
     {0x30, 0x27, 0x02, 0x02, 0x01, 0x00, 0x02, 0x21, 0x00, 0x8f, 0x1e,
      0x3c, 0x78, 0x62, 0xc5, 0x8b, 0x16, 0xbb, 0x76, 0xed, 0xdb, 0xb7,
      0x6e, 0xdd, 0xbb, 0x51, 0x6a, 0xf4, 0xf6, 0x3f, 0x2d, 0x74, 0xd7,
      0x6e, 0x0d, 0x28, 0xc9, 0xbb, 0x75, 0xea, 0x88},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xd0, 0xf7, 0x37, 0x92, 0x20, 0x37, 0x16, 0xaf, 0xd4,
      0xbe, 0x43, 0x29, 0xfa, 0xa4, 0x8d, 0x26, 0x9f, 0x15, 0x31, 0x3e, 0xbb,
      0xba, 0x37, 0x9d, 0x77, 0x83, 0xc9, 0x7b, 0xf3, 0xe8, 0x90, 0xd9, 0x97,
      0x1f, 0x4a, 0x32, 0x06, 0x60, 0x5b, 0xec, 0x21, 0x78, 0x2b, 0xf5, 0xe2,
      0x75, 0xc7, 0x14, 0x41, 0x7e, 0x8f, 0x56, 0x65, 0x49, 0xe6, 0xbc, 0x68,
      0x69, 0x0d, 0x23, 0x63, 0xc8, 0x9c, 0xc1},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: smallish r and s^-1
    // tcID: 297
    {SEC_OID_SHA256,
     297,
     {0x30, 0x2c, 0x02, 0x07, 0x2d, 0x9b, 0x4d, 0x34, 0x79, 0x52, 0xd6, 0x02,
      0x21, 0x00, 0xef, 0x30, 0x43, 0xe7, 0x32, 0x95, 0x81, 0xdb, 0xb3, 0x97,
      0x44, 0x97, 0x71, 0x0a, 0xb1, 0x15, 0x05, 0xee, 0x1c, 0x87, 0xff, 0x90,
      0x7b, 0xee, 0xba, 0xdd, 0x19, 0x5a, 0x0f, 0xfe, 0x6d, 0x7a},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x48, 0x38, 0xb2, 0xbe, 0x35, 0xa6, 0x27, 0x6a, 0x80,
      0xef, 0x9e, 0x22, 0x81, 0x40, 0xf9, 0xd9, 0xb9, 0x6c, 0xe8, 0x3b, 0x7a,
      0x25, 0x4f, 0x71, 0xcc, 0xde, 0xbb, 0xb8, 0x05, 0x4c, 0xe0, 0x5f, 0xfa,
      0x9c, 0xbc, 0x12, 0x3c, 0x91, 0x9b, 0x19, 0xe0, 0x02, 0x38, 0x19, 0x8d,
      0x04, 0x06, 0x90, 0x43, 0xbd, 0x66, 0x0a, 0x82, 0x88, 0x14, 0x05, 0x1f,
      0xcb, 0x8a, 0xac, 0x73, 0x8a, 0x6c, 0x6b},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: 100-bit r and small s^-1
    // tcID: 298
    {SEC_OID_SHA256,
     298,
     {0x30, 0x32, 0x02, 0x0d, 0x10, 0x33, 0xe6, 0x7e, 0x37, 0xb3, 0x2b,
      0x44, 0x55, 0x80, 0xbf, 0x4e, 0xff, 0x02, 0x21, 0x00, 0x8b, 0x74,
      0x8b, 0x74, 0x00, 0x00, 0x00, 0x00, 0x8b, 0x74, 0x8b, 0x74, 0x8b,
      0x74, 0x8b, 0x74, 0x66, 0xe7, 0x69, 0xad, 0x4a, 0x16, 0xd3, 0xdc,
      0xd8, 0x71, 0x29, 0xb8, 0xe9, 0x1d, 0x1b, 0x4d},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x73, 0x93, 0x98, 0x3c, 0xa3, 0x0a, 0x52, 0x0b, 0xbc,
      0x47, 0x83, 0xdc, 0x99, 0x60, 0x74, 0x6a, 0xab, 0x44, 0x4e, 0xf5, 0x20,
      0xc0, 0xa8, 0xe7, 0x71, 0x11, 0x9a, 0xa4, 0xe7, 0x4b, 0x0f, 0x64, 0xe9,
      0xd7, 0xbe, 0x1a, 0xb0, 0x1a, 0x0b, 0xf6, 0x26, 0xe7, 0x09, 0x86, 0x3e,
      0x6a, 0x48, 0x6d, 0xba, 0xf3, 0x27, 0x93, 0xaf, 0xcc, 0xf7, 0x74, 0xe2,
      0xc6, 0xcd, 0x27, 0xb1, 0x85, 0x75, 0x26},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: small r and 100 bit s^-1
    // tcID: 299
    {SEC_OID_SHA256,
     299,
     {0x30, 0x27, 0x02, 0x02, 0x01, 0x00, 0x02, 0x21, 0x00, 0xef, 0x9f,
      0x6b, 0xa4, 0xd9, 0x7c, 0x09, 0xd0, 0x31, 0x78, 0xfa, 0x20, 0xb4,
      0xaa, 0xad, 0x83, 0xbe, 0x3c, 0xf9, 0xcb, 0x82, 0x4a, 0x87, 0x9f,
      0xec, 0x32, 0x70, 0xfc, 0x4b, 0x81, 0xef, 0x5b},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x5a, 0xc3, 0x31, 0xa1, 0x10, 0x3f, 0xe9, 0x66, 0x69,
      0x73, 0x79, 0xf3, 0x56, 0xa9, 0x37, 0xf3, 0x50, 0x58, 0x8a, 0x05, 0x47,
      0x7e, 0x30, 0x88, 0x51, 0xb8, 0xa5, 0x02, 0xd5, 0xdf, 0xcd, 0xc5, 0xfe,
      0x99, 0x93, 0xdf, 0x4b, 0x57, 0x93, 0x9b, 0x2b, 0x8d, 0xa0, 0x95, 0xbf,
      0x6d, 0x79, 0x42, 0x65, 0x20, 0x4c, 0xfe, 0x03, 0xbe, 0x99, 0x5a, 0x02,
      0xe6, 0x5d, 0x40, 0x8c, 0x87, 0x1c, 0x0b},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: 100-bit r and s^-1
    // tcID: 300
    {SEC_OID_SHA256,
     300,
     {0x30, 0x32, 0x02, 0x0d, 0x06, 0x25, 0x22, 0xbb, 0xd3, 0xec, 0xbe,
      0x7c, 0x39, 0xe9, 0x3e, 0x7c, 0x25, 0x02, 0x21, 0x00, 0xef, 0x9f,
      0x6b, 0xa4, 0xd9, 0x7c, 0x09, 0xd0, 0x31, 0x78, 0xfa, 0x20, 0xb4,
      0xaa, 0xad, 0x83, 0xbe, 0x3c, 0xf9, 0xcb, 0x82, 0x4a, 0x87, 0x9f,
      0xec, 0x32, 0x70, 0xfc, 0x4b, 0x81, 0xef, 0x5b},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x1d, 0x20, 0x9b, 0xe8, 0xde, 0x2d, 0xe8, 0x77, 0x09,
      0x5a, 0x39, 0x9d, 0x39, 0x04, 0xc7, 0x4c, 0xc4, 0x58, 0xd9, 0x26, 0xe2,
      0x7b, 0xb8, 0xe5, 0x8e, 0x5e, 0xae, 0x57, 0x67, 0xc4, 0x15, 0x09, 0xdd,
      0x59, 0xe0, 0x4c, 0x21, 0x4f, 0x7b, 0x18, 0xdc, 0xe3, 0x51, 0xfc, 0x2a,
      0x54, 0x98, 0x93, 0xa6, 0x86, 0x0e, 0x80, 0x16, 0x3f, 0x38, 0xcc, 0x60,
      0xa4, 0xf2, 0xc9, 0xd0, 0x40, 0xd8, 0xc9},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: r and s^-1 are close to n
    // tcID: 301
    {SEC_OID_SHA256,
     301,
     {0x30, 0x45, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa,
      0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x24,
      0xd5, 0x02, 0x20, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4, 0x8d,
      0x07, 0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x08, 0x35, 0x39, 0xfb, 0xee, 0x44, 0x62, 0x5e, 0x3a,
      0xca, 0xaf, 0xa2, 0xfc, 0xb4, 0x13, 0x49, 0x39, 0x2c, 0xef, 0x06, 0x33,
      0xa1, 0xb8, 0xfa, 0xbe, 0xce, 0xe0, 0xc1, 0x33, 0xb1, 0x0e, 0x99, 0x91,
      0x5c, 0x1e, 0xbe, 0x7b, 0xf0, 0x0d, 0xf8, 0x53, 0x51, 0x96, 0x77, 0x0a,
      0x58, 0x04, 0x7a, 0xe2, 0xa4, 0x02, 0xf2, 0x63, 0x26, 0xbb, 0x7d, 0x41,
      0xd4, 0xd7, 0x61, 0x63, 0x37, 0x91, 0x1e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: s == 1
    // tcID: 302
    {SEC_OID_SHA256,
     302,
     {0x30, 0x25, 0x02, 0x20, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00,
      0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x3e, 0xf7, 0xa8, 0xe4, 0x8d, 0x07, 0xdf, 0x81, 0xa6, 0x93,
      0x43, 0x96, 0x54, 0x21, 0x0c, 0x70, 0x02, 0x01, 0x01},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x8a, 0xeb, 0x36, 0x8a, 0x70, 0x27, 0xa4, 0xd6, 0x4a,
      0xbd, 0xea, 0x37, 0x39, 0x0c, 0x0c, 0x1d, 0x6a, 0x26, 0xf3, 0x99, 0xe2,
      0xd9, 0x73, 0x4d, 0xe1, 0xeb, 0x3d, 0x0e, 0x19, 0x37, 0x38, 0x74, 0x05,
      0xbd, 0x13, 0x83, 0x47, 0x15, 0xe1, 0xdb, 0xae, 0x9b, 0x87, 0x5c, 0xf0,
      0x7b, 0xd5, 0x5e, 0x1b, 0x66, 0x91, 0xc7, 0xf7, 0x53, 0x6a, 0xef, 0x3b,
      0x19, 0xbf, 0x7a, 0x4a, 0xdf, 0x57, 0x6d},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: s == 0
    // tcID: 303
    {SEC_OID_SHA256,
     303,
     {0x30, 0x25, 0x02, 0x20, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00,
      0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x3e, 0xf7, 0xa8, 0xe4, 0x8d, 0x07, 0xdf, 0x81, 0xa6, 0x93,
      0x43, 0x96, 0x54, 0x21, 0x0c, 0x70, 0x02, 0x01, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x8a, 0xeb, 0x36, 0x8a, 0x70, 0x27, 0xa4, 0xd6, 0x4a,
      0xbd, 0xea, 0x37, 0x39, 0x0c, 0x0c, 0x1d, 0x6a, 0x26, 0xf3, 0x99, 0xe2,
      0xd9, 0x73, 0x4d, 0xe1, 0xeb, 0x3d, 0x0e, 0x19, 0x37, 0x38, 0x74, 0x05,
      0xbd, 0x13, 0x83, 0x47, 0x15, 0xe1, 0xdb, 0xae, 0x9b, 0x87, 0x5c, 0xf0,
      0x7b, 0xd5, 0x5e, 0x1b, 0x66, 0x91, 0xc7, 0xf7, 0x53, 0x6a, 0xef, 0x3b,
      0x19, 0xbf, 0x7a, 0x4a, 0xdf, 0x57, 0x6d},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: point at infinity during verify
    // tcID: 304
    {SEC_OID_SHA256,
     304,
     {0x30, 0x44, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00,
      0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x73, 0x7d, 0x56,
      0xd3, 0x8b, 0xcf, 0x42, 0x79, 0xdc, 0xe5, 0x61, 0x7e, 0x31, 0x92, 0xa8,
      0x02, 0x20, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4, 0x8d, 0x07,
      0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xb5, 0x33, 0xd4, 0x69, 0x5d, 0xd5, 0xb8, 0xc5, 0xe0,
      0x77, 0x57, 0xe5, 0x5e, 0x6e, 0x51, 0x6f, 0x7e, 0x2c, 0x88, 0xfa, 0x02,
      0x39, 0xe2, 0x3f, 0x60, 0xe8, 0xec, 0x07, 0xdd, 0x70, 0xf2, 0x87, 0x1b,
      0x13, 0x4e, 0xe5, 0x8c, 0xc5, 0x83, 0x27, 0x84, 0x56, 0x86, 0x3f, 0x33,
      0xc3, 0xa8, 0x5d, 0x88, 0x1f, 0x7d, 0x4a, 0x39, 0x85, 0x01, 0x43, 0xe2,
      0x9d, 0x4e, 0xaf, 0x00, 0x9a, 0xfe, 0x47},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: edge case for signature malleability
    // tcID: 305
    {SEC_OID_SHA256,
     305,
     {0x30, 0x44, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00,
      0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x73, 0x7d, 0x56,
      0xd3, 0x8b, 0xcf, 0x42, 0x79, 0xdc, 0xe5, 0x61, 0x7e, 0x31, 0x92, 0xa9,
      0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x7f, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x73, 0x7d, 0x56, 0xd3, 0x8b,
      0xcf, 0x42, 0x79, 0xdc, 0xe5, 0x61, 0x7e, 0x31, 0x92, 0xa8},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xf5, 0x0d, 0x37, 0x1b, 0x91, 0xbf, 0xb1, 0xd7, 0xd1,
      0x4e, 0x13, 0x23, 0x52, 0x3b, 0xc3, 0xaa, 0x8c, 0xbf, 0x2c, 0x57, 0xf9,
      0xe2, 0x84, 0xde, 0x62, 0x8c, 0x8b, 0x45, 0x36, 0x78, 0x7b, 0x86, 0xf9,
      0x4a, 0xd8, 0x87, 0xac, 0x94, 0xd5, 0x27, 0x24, 0x7c, 0xd2, 0xe7, 0xd0,
      0xc8, 0xb1, 0x29, 0x1c, 0x55, 0x3c, 0x97, 0x30, 0x40, 0x53, 0x80, 0xb1,
      0x4c, 0xbb, 0x20, 0x9f, 0x5f, 0xa2, 0xdd},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for signature malleability
    // tcID: 306
    {SEC_OID_SHA256,
     306,
     {0x30, 0x44, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00,
      0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x73, 0x7d, 0x56,
      0xd3, 0x8b, 0xcf, 0x42, 0x79, 0xdc, 0xe5, 0x61, 0x7e, 0x31, 0x92, 0xa9,
      0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x7f, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x73, 0x7d, 0x56, 0xd3, 0x8b,
      0xcf, 0x42, 0x79, 0xdc, 0xe5, 0x61, 0x7e, 0x31, 0x92, 0xa9},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x68, 0xec, 0x6e, 0x29, 0x8e, 0xaf, 0xe1, 0x65, 0x39,
      0x15, 0x6c, 0xe5, 0x7a, 0x14, 0xb0, 0x4a, 0x70, 0x47, 0xc2, 0x21, 0xba,
      0xfc, 0x3a, 0x58, 0x2e, 0xae, 0xb0, 0xd8, 0x57, 0xc4, 0xd9, 0x46, 0x97,
      0xbe, 0xd1, 0xaf, 0x17, 0x85, 0x01, 0x17, 0xfd, 0xb3, 0x9b, 0x23, 0x24,
      0xf2, 0x20, 0xa5, 0x69, 0x8e, 0xd1, 0x6c, 0x42, 0x6a, 0x27, 0x33, 0x5b,
      0xb3, 0x85, 0xac, 0x8c, 0xa6, 0xfb, 0x30},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: u1 == 1
    // tcID: 307
    {SEC_OID_SHA256,
     307,
     {0x30, 0x45, 0x02, 0x20, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4,
      0x8d, 0x07, 0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70,
      0x02, 0x21, 0x00, 0xbb, 0x5a, 0x52, 0xf4, 0x2f, 0x9c, 0x92, 0x61, 0xed,
      0x43, 0x61, 0xf5, 0x94, 0x22, 0xa1, 0xe3, 0x00, 0x36, 0xe7, 0xc3, 0x2b,
      0x27, 0x0c, 0x88, 0x07, 0xa4, 0x19, 0xfe, 0xca, 0x60, 0x50, 0x23},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x69, 0xda, 0x03, 0x64, 0x73, 0x4d, 0x2e, 0x53, 0x0f,
      0xec, 0xe9, 0x40, 0x19, 0x26, 0x5f, 0xef, 0xb7, 0x81, 0xa0, 0xf1, 0xb0,
      0x8f, 0x6c, 0x88, 0x97, 0xbd, 0xf6, 0x55, 0x79, 0x27, 0xc8, 0xb8, 0x66,
      0xd2, 0xd3, 0xc7, 0xdc, 0xd5, 0x18, 0xb2, 0x3d, 0x72, 0x69, 0x60, 0xf0,
      0x69, 0xad, 0x71, 0xa9, 0x33, 0xd8, 0x6e, 0xf8, 0xab, 0xbc, 0xce, 0x8b,
      0x20, 0xf7, 0x1e, 0x2a, 0x84, 0x70, 0x02},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: u1 == n - 1
    // tcID: 308
    {SEC_OID_SHA256,
     308,
     {0x30, 0x44, 0x02, 0x20, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4,
      0x8d, 0x07, 0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70,
      0x02, 0x20, 0x44, 0xa5, 0xad, 0x0a, 0xd0, 0x63, 0x6d, 0x9f, 0x12, 0xbc,
      0x9e, 0x0a, 0x6b, 0xdd, 0x5e, 0x1c, 0xbc, 0xb0, 0x12, 0xea, 0x7b, 0xf0,
      0x91, 0xfc, 0xec, 0x15, 0xb0, 0xc4, 0x32, 0x02, 0xd5, 0x2e},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xd8, 0xad, 0xc0, 0x00, 0x23, 0xa8, 0xed, 0xc0, 0x25,
      0x76, 0xe2, 0xb6, 0x3e, 0x3e, 0x30, 0x62, 0x1a, 0x47, 0x1e, 0x2b, 0x23,
      0x20, 0x62, 0x01, 0x87, 0xbf, 0x06, 0x7a, 0x1a, 0xc1, 0xff, 0x32, 0x33,
      0xe2, 0xb5, 0x0e, 0xc0, 0x98, 0x07, 0xac, 0xcb, 0x36, 0x13, 0x1f, 0xff,
      0x95, 0xed, 0x12, 0xa0, 0x9a, 0x86, 0xb4, 0xea, 0x96, 0x90, 0xaa, 0x32,
      0x86, 0x15, 0x76, 0xba, 0x23, 0x62, 0xe1},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: u2 == 1
    // tcID: 309
    {SEC_OID_SHA256,
     309,
     {0x30, 0x44, 0x02, 0x20, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4,
      0x8d, 0x07, 0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70,
      0x02, 0x20, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4, 0x8d, 0x07,
      0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x36, 0x23, 0xac, 0x97, 0x3c, 0xed, 0x0a, 0x56, 0xfa,
      0x6d, 0x88, 0x2f, 0x03, 0xa7, 0xd5, 0xc7, 0xed, 0xca, 0x02, 0xcf, 0xc7,
      0xb2, 0x40, 0x1f, 0xab, 0x36, 0x90, 0xdb, 0xe7, 0x5a, 0xb7, 0x85, 0x8d,
      0xb0, 0x69, 0x08, 0xe6, 0x4b, 0x28, 0x61, 0x3d, 0xa7, 0x25, 0x7e, 0x73,
      0x7f, 0x39, 0x79, 0x3d, 0xa8, 0xe7, 0x13, 0xba, 0x06, 0x43, 0xb9, 0x2e,
      0x9b, 0xb3, 0x25, 0x2b, 0xe7, 0xf8, 0xfe},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: u2 == n - 1
    // tcID: 310
    {SEC_OID_SHA256,
     310,
     {0x30, 0x45, 0x02, 0x20, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4,
      0x8d, 0x07, 0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70,
      0x02, 0x21, 0x00, 0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x7d, 0xef, 0x51, 0xc9, 0x1a,
      0x0f, 0xbf, 0x03, 0x4d, 0x26, 0x87, 0x2c, 0xa8, 0x42, 0x18, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xcf, 0x04, 0xea, 0x77, 0xe9, 0x62, 0x25, 0x23, 0xd8,
      0x94, 0xb9, 0x3f, 0xf5, 0x2d, 0xc3, 0x02, 0x7b, 0x31, 0x95, 0x95, 0x03,
      0xb6, 0xfa, 0x38, 0x90, 0xe5, 0xe0, 0x42, 0x63, 0xf9, 0x22, 0xf1, 0xe8,
      0x52, 0x8f, 0xb7, 0xc0, 0x06, 0xb3, 0x98, 0x3c, 0x8b, 0x84, 0x00, 0xe5,
      0x7b, 0x4e, 0xd7, 0x17, 0x40, 0xc2, 0xf3, 0x97, 0x54, 0x38, 0x82, 0x11,
      0x99, 0xbe, 0xde, 0xae, 0xca, 0xb2, 0xe9},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 311
    {SEC_OID_SHA256,
     311,
     {0x30, 0x45, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x21, 0x00, 0xe9, 0x1e, 0x1b, 0xa6, 0x0f, 0xde, 0xdb, 0x76, 0xa4,
      0x6b, 0xcb, 0x51, 0xdc, 0x0b, 0x8b, 0x4b, 0x7e, 0x01, 0x9f, 0x0a, 0x28,
      0x72, 0x18, 0x85, 0xfa, 0x5d, 0x3a, 0x81, 0x96, 0x62, 0x33, 0x97},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xdb, 0x7a, 0x2c, 0x8a, 0x1a, 0xb5, 0x73, 0xe5, 0x92,
      0x9d, 0xc2, 0x40, 0x77, 0xb5, 0x08, 0xd7, 0xe6, 0x83, 0xd4, 0x92, 0x27,
      0x99, 0x6b, 0xda, 0x3e, 0x9f, 0x78, 0xdb, 0xef, 0xf7, 0x73, 0x50, 0x4f,
      0x41, 0x7f, 0x3b, 0xc9, 0xa8, 0x80, 0x75, 0xc2, 0xe0, 0xaa, 0xdd, 0x5a,
      0x13, 0x31, 0x17, 0x30, 0xcf, 0x7c, 0xc7, 0x6a, 0x82, 0xf1, 0x1a, 0x36,
      0xea, 0xf0, 0x8a, 0x6c, 0x99, 0xa2, 0x06},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 312
    {SEC_OID_SHA256,
     312,
     {0x30, 0x45, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x21, 0x00, 0xfd, 0xea, 0x58, 0x43, 0xff, 0xeb, 0x73, 0xaf, 0x94,
      0x31, 0x3b, 0xa4, 0x83, 0x1b, 0x53, 0xfe, 0x24, 0xf7, 0x99, 0xe5, 0x25,
      0xb1, 0xe8, 0xe8, 0xc8, 0x7b, 0x59, 0xb9, 0x5b, 0x43, 0x0a, 0xd9},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xde, 0xad, 0x11, 0xc7, 0xa5, 0xb3, 0x96, 0x86, 0x2f,
      0x21, 0x97, 0x4d, 0xc4, 0x75, 0x2f, 0xad, 0xef, 0xf9, 0x94, 0xef, 0xe9,
      0xbb, 0xd0, 0x5a, 0xb4, 0x13, 0x76, 0x5e, 0xa8, 0x0b, 0x6e, 0x1f, 0x1d,
      0xe3, 0xf0, 0x64, 0x0e, 0x8a, 0xc6, 0xed, 0xcf, 0x89, 0xcf, 0xf5, 0x3c,
      0x40, 0xe2, 0x65, 0xbb, 0x94, 0x07, 0x8a, 0x34, 0x37, 0x36, 0xdf, 0x07,
      0xaa, 0x03, 0x18, 0xfc, 0x7f, 0xe1, 0xff},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 313
    {SEC_OID_SHA256,
     313,
     {0x30, 0x44, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x20, 0x03, 0xff, 0xca, 0xbf, 0x2f, 0x1b, 0x4d, 0x2a, 0x65, 0x19,
      0x0d, 0xb1, 0x68, 0x0d, 0x62, 0xbb, 0x99, 0x4e, 0x41, 0xc5, 0x25, 0x1c,
      0xd7, 0x3b, 0x3c, 0x3d, 0xfc, 0x5e, 0x5b, 0xaf, 0xc0, 0x35},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xd0, 0xbc, 0x47, 0x2e, 0x0d, 0x7c, 0x81, 0xeb, 0xae,
      0xd3, 0xa6, 0xef, 0x96, 0xc1, 0x86, 0x13, 0xbb, 0x1f, 0xea, 0x6f, 0x99,
      0x43, 0x26, 0xfb, 0xe8, 0x0e, 0x00, 0xdf, 0xde, 0x67, 0xc7, 0xe9, 0x98,
      0x6c, 0x72, 0x3e, 0xa4, 0x84, 0x3d, 0x48, 0x38, 0x9b, 0x94, 0x6f, 0x64,
      0xad, 0x56, 0xc8, 0x3a, 0xd7, 0x0f, 0xf1, 0x7b, 0xa8, 0x53, 0x35, 0x66,
      0x7d, 0x1b, 0xb9, 0xfa, 0x61, 0x9e, 0xfd},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 314
    {SEC_OID_SHA256,
     314,
     {0x30, 0x44, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x20, 0x4d, 0xfb, 0xc4, 0x01, 0xf9, 0x71, 0xcd, 0x30, 0x4b, 0x33,
      0xdf, 0xdb, 0x17, 0xd0, 0xfe, 0xd0, 0xfe, 0x4c, 0x1a, 0x88, 0xae, 0x64,
      0x8e, 0x0d, 0x28, 0x47, 0xf7, 0x49, 0x77, 0x53, 0x49, 0x89},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xa0, 0xa4, 0x4c, 0xa9, 0x47, 0xd6, 0x6a, 0x2a, 0xcb,
      0x73, 0x60, 0x08, 0xb9, 0xc0, 0x8d, 0x1a, 0xb2, 0xad, 0x03, 0x77, 0x6e,
      0x02, 0x64, 0x0f, 0x78, 0x49, 0x5d, 0x45, 0x8d, 0xd5, 0x1c, 0x32, 0x63,
      0x37, 0xfe, 0x5c, 0xf8, 0xc4, 0x60, 0x4b, 0x1f, 0x1c, 0x40, 0x9d, 0xc2,
      0xd8, 0x72, 0xd4, 0x29, 0x4a, 0x47, 0x62, 0x42, 0x0d, 0xf4, 0x3a, 0x30,
      0xa2, 0x39, 0x2e, 0x40, 0x42, 0x6a, 0xdd},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 315
    {SEC_OID_SHA256,
     315,
     {0x30, 0x45, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x21, 0x00, 0xbc, 0x40, 0x24, 0x76, 0x1c, 0xd2, 0xff, 0xd4, 0x3d,
      0xfd, 0xb1, 0x7d, 0x0f, 0xed, 0x11, 0x2b, 0x98, 0x89, 0x77, 0x05, 0x5c,
      0xd3, 0xa8, 0xe5, 0x49, 0x71, 0xeb, 0xa9, 0xcd, 0xa5, 0xca, 0x71},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xc9, 0xc2, 0x11, 0x52, 0x90, 0xd0, 0x08, 0xb4, 0x5f,
      0xb6, 0x5f, 0xad, 0x0f, 0x60, 0x23, 0x89, 0x29, 0x8c, 0x25, 0x42, 0x0b,
      0x77, 0x50, 0x19, 0xd4, 0x2b, 0x62, 0xc3, 0xce, 0x8a, 0x96, 0xb7, 0x38,
      0x77, 0xd2, 0x5a, 0x80, 0x80, 0xdc, 0x02, 0xd9, 0x87, 0xca, 0x73, 0x0f,
      0x04, 0x05, 0xc2, 0xc9, 0xdb, 0xef, 0xac, 0x46, 0xf9, 0xe6, 0x01, 0xcc,
      0x3f, 0x06, 0xe9, 0x71, 0x39, 0x73, 0xfd},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 316
    {SEC_OID_SHA256,
     316,
     {0x30, 0x44, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x20, 0x78, 0x80, 0x48, 0xed, 0x39, 0xa5, 0xff, 0xa7, 0x7b, 0xfb,
      0x62, 0xfa, 0x1f, 0xda, 0x22, 0x57, 0x74, 0x2b, 0xf3, 0x5d, 0x12, 0x8f,
      0xb3, 0x45, 0x9f, 0x2a, 0x0c, 0x90, 0x9e, 0xe8, 0x6f, 0x91},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x5e, 0xca, 0x1e, 0xf4, 0xc2, 0x87, 0xdd, 0xdc, 0x66,
      0xb8, 0xbc, 0xcf, 0x1b, 0x88, 0xe8, 0xa2, 0x4c, 0x00, 0x18, 0x96, 0x2f,
      0x3c, 0x5e, 0x7e, 0xfa, 0x83, 0xbc, 0x1a, 0x5f, 0xf6, 0x03, 0x3e, 0x5e,
      0x79, 0xc4, 0xcb, 0x2c, 0x24, 0x5b, 0x8c, 0x45, 0xab, 0xdc, 0xe8, 0xa8,
      0xe4, 0xda, 0x75, 0x8d, 0x92, 0xa6, 0x07, 0xc3, 0x2c, 0xd4, 0x07, 0xec,
      0xae, 0xf2, 0x2f, 0x1c, 0x93, 0x4a, 0x71},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 317
    {SEC_OID_SHA256,
     317,
     {0x30, 0x44, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x20, 0x47, 0x6d, 0x91, 0x31, 0xfd, 0x38, 0x1b, 0xd9, 0x17, 0xd0,
      0xfe, 0xd1, 0x12, 0xbc, 0x9e, 0x0a, 0x59, 0x24, 0xb5, 0xed, 0x5b, 0x11,
      0x16, 0x7e, 0xdd, 0x8b, 0x23, 0x58, 0x2b, 0x3c, 0xb1, 0x5e},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x5c, 0xaa, 0xa0, 0x30, 0xe7, 0xfd, 0xf0, 0xe4, 0x93,
      0x6b, 0xc7, 0xab, 0x5a, 0x96, 0x35, 0x3e, 0x0a, 0x01, 0xe4, 0x13, 0x0c,
      0x3f, 0x8b, 0xf2, 0x2d, 0x47, 0x3e, 0x31, 0x70, 0x29, 0xa4, 0x7a, 0xde,
      0xb6, 0xad, 0xc4, 0x62, 0xf7, 0x05, 0x8f, 0x2a, 0x20, 0xd3, 0x71, 0xe9,
      0x70, 0x22, 0x54, 0xe9, 0xb2, 0x01, 0x64, 0x20, 0x05, 0xb3, 0xce, 0xda,
      0x92, 0x6b, 0x42, 0xb1, 0x78, 0xbe, 0xf9},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 318
    {SEC_OID_SHA256,
     318,
     {0x30, 0x45, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x21, 0x00, 0x83, 0x74, 0x25, 0x3e, 0x3e, 0x21, 0xbd, 0x15, 0x44,
      0x48, 0xd0, 0xa8, 0xf6, 0x40, 0xfe, 0x46, 0xfa, 0xfa, 0x8b, 0x19, 0xce,
      0x78, 0xd5, 0x38, 0xf6, 0xcc, 0x0a, 0x19, 0x66, 0x2d, 0x36, 0x01},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xc2, 0xfd, 0x20, 0xba, 0xc0, 0x6e, 0x55, 0x5b, 0xb8,
      0xac, 0x0c, 0xe6, 0x9e, 0xb1, 0xea, 0x20, 0xf8, 0x3a, 0x1f, 0xc3, 0x50,
      0x1c, 0x8a, 0x66, 0x46, 0x9b, 0x1a, 0x31, 0xf6, 0x19, 0xb0, 0x98, 0x62,
      0x37, 0x05, 0x07, 0x79, 0xf5, 0x2b, 0x61, 0x5b, 0xd7, 0xb8, 0xd7, 0x6a,
      0x25, 0xfc, 0x95, 0xca, 0x2e, 0xd3, 0x25, 0x25, 0xc7, 0x5f, 0x27, 0xff,
      0xc8, 0x7a, 0xc3, 0x97, 0xe6, 0xcb, 0xaf},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 319
    {SEC_OID_SHA256,
     319,
     {0x30, 0x44, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x20, 0x35, 0x7c, 0xfd, 0x3b, 0xe4, 0xd0, 0x1d, 0x41, 0x3c, 0x5b,
      0x9e, 0xde, 0x36, 0xcb, 0xa5, 0x45, 0x2c, 0x11, 0xee, 0x7f, 0xe1, 0x48,
      0x79, 0xe7, 0x49, 0xae, 0x6a, 0x2d, 0x89, 0x7a, 0x52, 0xd6},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x3f, 0xd6, 0xa1, 0xca, 0x7f, 0x77, 0xfb, 0x3b, 0x0b,
      0xbe, 0x72, 0x6c, 0x37, 0x20, 0x10, 0x06, 0x84, 0x26, 0xe1, 0x1e, 0xa6,
      0xae, 0x78, 0xce, 0x17, 0xbe, 0xda, 0xe4, 0xbb, 0xa8, 0x6c, 0xed, 0x03,
      0xce, 0x55, 0x16, 0x40, 0x6b, 0xf8, 0xcf, 0xaa, 0xb8, 0x74, 0x5e, 0xac,
      0x1c, 0xd6, 0x90, 0x18, 0xad, 0x6f, 0x50, 0xb5, 0x46, 0x18, 0x72, 0xdd,
      0xfc, 0x56, 0xe0, 0xdb, 0x3c, 0x8f, 0xf4},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 320
    {SEC_OID_SHA256,
     320,
     {0x30, 0x44, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x20, 0x29, 0x79, 0x8c, 0x5c, 0x0e, 0xe2, 0x87, 0xd4, 0xa5, 0xe8,
      0xe6, 0xb7, 0x99, 0xfd, 0x86, 0xb8, 0xdf, 0x52, 0x25, 0x29, 0x8e, 0x6f,
      0xfc, 0x80, 0x7c, 0xd2, 0xf2, 0xbc, 0x27, 0xa0, 0xa6, 0xd8},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x9c, 0xb8, 0xe5, 0x1e, 0x27, 0xa5, 0xae, 0x3b, 0x62,
      0x4a, 0x60, 0xd6, 0xdc, 0x32, 0x73, 0x4e, 0x49, 0x89, 0xdb, 0x20, 0xe9,
      0xbc, 0xa3, 0xed, 0xe1, 0xed, 0xf7, 0xb0, 0x86, 0x91, 0x11, 0x14, 0xb4,
      0xc1, 0x04, 0xab, 0x3c, 0x67, 0x7e, 0x4b, 0x36, 0xd6, 0x55, 0x6e, 0x8a,
      0xd5, 0xf5, 0x23, 0x41, 0x0a, 0x19, 0xf2, 0xe2, 0x77, 0xaa, 0x89, 0x5f,
      0xc5, 0x73, 0x22, 0xb4, 0x42, 0x75, 0x44},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 321
    {SEC_OID_SHA256,
     321,
     {0x30, 0x44, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x20, 0x0b, 0x70, 0xf2, 0x2c, 0x78, 0x10, 0x92, 0x45, 0x2d, 0xca,
      0x1a, 0x57, 0x11, 0xfa, 0x3a, 0x5a, 0x1f, 0x72, 0xad, 0xd1, 0xbf, 0x52,
      0xc2, 0xff, 0x7c, 0xae, 0x48, 0x20, 0xb3, 0x00, 0x78, 0xdd},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xa3, 0xe5, 0x2c, 0x15, 0x6d, 0xca, 0xf1, 0x05, 0x02,
      0x62, 0x0b, 0x79, 0x55, 0xbc, 0x2b, 0x40, 0xbc, 0x78, 0xef, 0x3d, 0x56,
      0x9e, 0x12, 0x23, 0xc2, 0x62, 0x51, 0x2d, 0x8f, 0x49, 0x60, 0x2a, 0x4a,
      0x20, 0x39, 0xf3, 0x1c, 0x10, 0x97, 0x02, 0x4a, 0xd3, 0xcc, 0x86, 0xe5,
      0x73, 0x21, 0xde, 0x03, 0x23, 0x55, 0x46, 0x34, 0x86, 0x16, 0x4c, 0xf1,
      0x92, 0x94, 0x49, 0x77, 0xdf, 0x14, 0x7f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 322
    {SEC_OID_SHA256,
     322,
     {0x30, 0x44, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x20, 0x16, 0xe1, 0xe4, 0x58, 0xf0, 0x21, 0x24, 0x8a, 0x5b, 0x94,
      0x34, 0xae, 0x23, 0xf4, 0x74, 0xb4, 0x3e, 0xe5, 0x5b, 0xa3, 0x7e, 0xa5,
      0x85, 0xfe, 0xf9, 0x5c, 0x90, 0x41, 0x66, 0x00, 0xf1, 0xba},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xf1, 0x9b, 0x78, 0x92, 0x87, 0x20, 0xd5, 0xbe, 0xe8,
      0xe6, 0x70, 0xfb, 0x90, 0x01, 0x0f, 0xb1, 0x5c, 0x37, 0xbf, 0x91, 0xb5,
      0x8a, 0x51, 0x57, 0xc3, 0xf3, 0xc0, 0x59, 0xb2, 0x65, 0x5e, 0x88, 0xcf,
      0x70, 0x1e, 0xc9, 0x62, 0xfb, 0x4a, 0x11, 0xdc, 0xf2, 0x73, 0xf5, 0xdc,
      0x35, 0x7e, 0x58, 0x46, 0x85, 0x60, 0xc7, 0xcf, 0xeb, 0x94, 0x2d, 0x07,
      0x4a, 0xbd, 0x43, 0x29, 0x26, 0x05, 0x09},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 323
    {SEC_OID_SHA256,
     323,
     {0x30, 0x44, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x20, 0x22, 0x52, 0xd6, 0x85, 0x68, 0x31, 0xb6, 0xcf, 0x89, 0x5e,
      0x4f, 0x05, 0x35, 0xee, 0xaf, 0x0e, 0x5e, 0x58, 0x09, 0x75, 0x3d, 0xf8,
      0x48, 0xfe, 0x76, 0x0a, 0xd8, 0x62, 0x19, 0x01, 0x6a, 0x97},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x83, 0xa7, 0x44, 0x45, 0x9e, 0xcd, 0xfb, 0x01, 0xa5,
      0xcf, 0x52, 0xb2, 0x7a, 0x05, 0xbb, 0x73, 0x37, 0x48, 0x2d, 0x24, 0x2f,
      0x23, 0x5d, 0x7b, 0x4c, 0xb8, 0x93, 0x45, 0x54, 0x5c, 0x90, 0xa8, 0xc0,
      0x5d, 0x49, 0x33, 0x7b, 0x96, 0x49, 0x81, 0x32, 0x87, 0xde, 0x9f, 0xfe,
      0x90, 0x35, 0x5f, 0xd9, 0x05, 0xdf, 0x5f, 0x3c, 0x32, 0x94, 0x58, 0x28,
      0x12, 0x1f, 0x37, 0xcc, 0x50, 0xde, 0x6e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 324
    {SEC_OID_SHA256,
     324,
     {0x30, 0x45, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x21, 0x00, 0x81, 0xff, 0xe5, 0x5f, 0x17, 0x8d, 0xa6, 0x95, 0xb2,
      0x8c, 0x86, 0xd8, 0xb4, 0x06, 0xb1, 0x5d, 0xab, 0x1a, 0x9e, 0x39, 0x66,
      0x1a, 0x3a, 0xe0, 0x17, 0xfb, 0xe3, 0x90, 0xac, 0x09, 0x72, 0xc3},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xdd, 0x13, 0xc6, 0xb3, 0x4c, 0x56, 0x98, 0x2d, 0xda,
      0xe1, 0x24, 0xf0, 0x39, 0xdf, 0xd2, 0x3f, 0x4b, 0x19, 0xbb, 0xe8, 0x8c,
      0xee, 0x8e, 0x52, 0x8a, 0xe5, 0x1e, 0x5d, 0x6f, 0x3a, 0x21, 0xd7, 0xbf,
      0xad, 0x4c, 0x2e, 0x6f, 0x26, 0x3f, 0xe5, 0xeb, 0x59, 0xca, 0x97, 0x4d,
      0x03, 0x9f, 0xc0, 0xe4, 0xc3, 0x34, 0x56, 0x92, 0xfb, 0x53, 0x20, 0xbd,
      0xae, 0x4b, 0xd3, 0xb4, 0x2a, 0x45, 0xff},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 325
    {SEC_OID_SHA256,
     325,
     {0x30, 0x44, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xaa, 0xaa, 0xaa, 0xaa, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe9, 0xa2, 0x53, 0x8f, 0x37, 0xb2,
      0x8a, 0x2c, 0x51, 0x3d, 0xee, 0x40, 0xfe, 0xcb, 0xb7, 0x1a},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x67, 0xe6, 0xf6, 0x59, 0xcd, 0xde, 0x86, 0x9a, 0x2f,
      0x65, 0xf0, 0x94, 0xe9, 0x4e, 0x5b, 0x4d, 0xfa, 0xd6, 0x36, 0xbb, 0xf9,
      0x51, 0x92, 0xfe, 0xee, 0xd0, 0x1b, 0x0f, 0x3d, 0xeb, 0x74, 0x60, 0xa3,
      0x7e, 0x0a, 0x51, 0xf2, 0x58, 0xb7, 0xae, 0xb5, 0x1d, 0xfe, 0x59, 0x2f,
      0x5c, 0xfd, 0x56, 0x85, 0xbb, 0xe5, 0x87, 0x12, 0xc8, 0xd9, 0x23, 0x3c,
      0x62, 0x88, 0x64, 0x37, 0xc3, 0x8b, 0xa0},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 326
    {SEC_OID_SHA256,
     326,
     {0x30, 0x45, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x21, 0x00, 0xb6, 0x2f, 0x26, 0xb5, 0xf2, 0xa2, 0xb2, 0x6f, 0x6d,
      0xe8, 0x6d, 0x42, 0xad, 0x8a, 0x13, 0xda, 0x3a, 0xb3, 0xcc, 0xcd, 0x04,
      0x59, 0xb2, 0x01, 0xde, 0x00, 0x9e, 0x52, 0x6a, 0xdf, 0x21, 0xf2},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x2e, 0xb6, 0x41, 0x25, 0x05, 0xae, 0xc0, 0x5c, 0x65,
      0x45, 0xf0, 0x29, 0x93, 0x20, 0x87, 0xe4, 0x90, 0xd0, 0x55, 0x11, 0xe8,
      0xec, 0x1f, 0x59, 0x96, 0x17, 0xbb, 0x36, 0x7f, 0x9e, 0xca, 0xaf, 0x80,
      0x5f, 0x51, 0xef, 0xcc, 0x48, 0x03, 0x40, 0x3f, 0x9b, 0x1a, 0xe0, 0x12,
      0x48, 0x90, 0xf0, 0x6a, 0x43, 0xfe, 0xdc, 0xdd, 0xb3, 0x18, 0x30, 0xf6,
      0x66, 0x9a, 0xf2, 0x92, 0x89, 0x5c, 0xb0},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 327
    {SEC_OID_SHA256,
     327,
     {0x30, 0x45, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x21, 0x00, 0xbb, 0x1d, 0x9a, 0xc9, 0x49, 0xdd, 0x74, 0x8c, 0xd0,
      0x2b, 0xbb, 0xe7, 0x49, 0xbd, 0x35, 0x1c, 0xd5, 0x7b, 0x38, 0xbb, 0x61,
      0x40, 0x3d, 0x70, 0x06, 0x86, 0xaa, 0x7b, 0x4c, 0x90, 0x85, 0x1e},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x84, 0xdb, 0x64, 0x58, 0x68, 0xea, 0xb3, 0x5e, 0x3a,
      0x9f, 0xd8, 0x0e, 0x05, 0x6e, 0x2e, 0x85, 0x54, 0x35, 0xe3, 0xa6, 0xb6,
      0x8d, 0x75, 0xa5, 0x0a, 0x85, 0x46, 0x25, 0xfe, 0x0d, 0x7f, 0x35, 0x6d,
      0x25, 0x89, 0xac, 0x65, 0x5e, 0xdc, 0x9a, 0x11, 0xef, 0x3e, 0x07, 0x5e,
      0xdd, 0xda, 0x9a, 0xbf, 0x92, 0xe7, 0x21, 0x71, 0x57, 0x0e, 0xf7, 0xbf,
      0x43, 0xa2, 0xee, 0x39, 0x33, 0x8c, 0xfe},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 328
    {SEC_OID_SHA256,
     328,
     {0x30, 0x44, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x20, 0x66, 0x75, 0x5a, 0x00, 0x63, 0x8c, 0xda, 0xec, 0x1c, 0x73,
      0x25, 0x13, 0xca, 0x02, 0x34, 0xec, 0xe5, 0x25, 0x45, 0xda, 0xc1, 0x1f,
      0x81, 0x6e, 0x81, 0x8f, 0x72, 0x5b, 0x4f, 0x60, 0xaa, 0xf2},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x91, 0xb9, 0xe4, 0x7c, 0x56, 0x27, 0x86, 0x62, 0xd7,
      0x5c, 0x09, 0x83, 0xb2, 0x2c, 0xa8, 0xea, 0x6a, 0xa5, 0x05, 0x9b, 0x7a,
      0x2f, 0xf7, 0x63, 0x7e, 0xb2, 0x97, 0x5e, 0x38, 0x6a, 0xd6, 0x63, 0x49,
      0xaa, 0x8f, 0xf2, 0x83, 0xd0, 0xf7, 0x7c, 0x18, 0xd6, 0xd1, 0x1d, 0xc0,
      0x62, 0x16, 0x5f, 0xd1, 0x3c, 0x3c, 0x03, 0x10, 0x67, 0x9c, 0x14, 0x08,
      0x30, 0x2a, 0x16, 0x85, 0x4e, 0xcf, 0xbd},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 329
    {SEC_OID_SHA256,
     329,
     {0x30, 0x44, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x20, 0x55, 0xa0, 0x0c, 0x9f, 0xcd, 0xae, 0xbb, 0x60, 0x32, 0x51,
      0x3c, 0xa0, 0x23, 0x4e, 0xcf, 0xff, 0xe9, 0x8e, 0xbe, 0x49, 0x2f, 0xdf,
      0x02, 0xe4, 0x8c, 0xa4, 0x8e, 0x98, 0x2b, 0xeb, 0x36, 0x69},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xf3, 0xec, 0x2f, 0x13, 0xca, 0xf0, 0x4d, 0x01, 0x92,
      0xb4, 0x7f, 0xb4, 0xc5, 0x31, 0x1f, 0xb6, 0xd4, 0xdc, 0x6b, 0x0a, 0x9e,
      0x80, 0x2e, 0x53, 0x27, 0xf7, 0xec, 0x5e, 0xe8, 0xe4, 0x83, 0x4d, 0xf9,
      0x7e, 0x3e, 0x46, 0x8b, 0x7d, 0x0d, 0xb8, 0x67, 0xd6, 0xec, 0xfe, 0x81,
      0xe2, 0xb0, 0xf9, 0x53, 0x1d, 0xf8, 0x7e, 0xfd, 0xb4, 0x7c, 0x13, 0x38,
      0xac, 0x32, 0x1f, 0xef, 0xe5, 0xa4, 0x32},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 330
    {SEC_OID_SHA256,
     330,
     {0x30, 0x45, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x21, 0x00, 0xab, 0x40, 0x19, 0x3f, 0x9b, 0x5d, 0x76, 0xc0, 0x64,
      0xa2, 0x79, 0x40, 0x46, 0x9d, 0x9f, 0xff, 0xd3, 0x1d, 0x7c, 0x92, 0x5f,
      0xbe, 0x05, 0xc9, 0x19, 0x49, 0x1d, 0x30, 0x57, 0xd6, 0x6c, 0xd2},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xd9, 0x2b, 0x20, 0x0a, 0xef, 0xca, 0xb6, 0xac, 0x7d,
      0xaf, 0xd9, 0xac, 0xaf, 0x2f, 0xa1, 0x0b, 0x31, 0x80, 0x23, 0x5b, 0x8f,
      0x46, 0xb4, 0x50, 0x3e, 0x46, 0x93, 0xc6, 0x70, 0xfc, 0xcc, 0x88, 0x5e,
      0xf2, 0xf3, 0xae, 0xbf, 0x5b, 0x31, 0x74, 0x75, 0x33, 0x62, 0x56, 0x76,
      0x8f, 0x7c, 0x19, 0xef, 0xb7, 0x35, 0x2d, 0x27, 0xe4, 0xcc, 0xca, 0xdc,
      0x85, 0xb6, 0xb8, 0xab, 0x92, 0x2c, 0x72},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 331
    {SEC_OID_SHA256,
     331,
     {0x30, 0x45, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x21, 0x00, 0xca, 0x02, 0x34, 0xeb, 0xb5, 0xfd, 0xcb, 0x13, 0xca,
      0x02, 0x34, 0xec, 0xff, 0xff, 0xff, 0xff, 0xcb, 0x0d, 0xad, 0xbb, 0xc7,
      0xf5, 0x49, 0xf8, 0xa2, 0x6b, 0x44, 0x08, 0xd0, 0xdc, 0x86, 0x00},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x0a, 0x88, 0x36, 0x1e, 0xb9, 0x2e, 0xcc, 0xa2, 0x62,
      0x5b, 0x38, 0xe5, 0xf9, 0x8b, 0xba, 0xbb, 0x96, 0xbf, 0x17, 0x9b, 0x3d,
      0x76, 0xfc, 0x48, 0x14, 0x0a, 0x3b, 0xcd, 0x88, 0x15, 0x23, 0xcd, 0xe6,
      0xbd, 0xf5, 0x60, 0x33, 0xf8, 0x4a, 0x50, 0x54, 0x03, 0x55, 0x97, 0x37,
      0x5d, 0x90, 0x86, 0x6a, 0xa2, 0xc9, 0x6b, 0x86, 0xa4, 0x1c, 0xcf, 0x6e,
      0xde, 0xbf, 0x47, 0x29, 0x8a, 0xd4, 0x89},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 332
    {SEC_OID_SHA256,
     332,
     {0x30, 0x45, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x21, 0x00, 0xbf, 0xff, 0xff, 0xff, 0x3e, 0xa3, 0x67, 0x7e, 0x08,
      0x2b, 0x93, 0x10, 0x57, 0x26, 0x20, 0xae, 0x19, 0x93, 0x3a, 0x9e, 0x65,
      0xb2, 0x85, 0x59, 0x87, 0x11, 0xc7, 0x72, 0x98, 0x81, 0x5a, 0xd3},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xd0, 0xfb, 0x17, 0xcc, 0xd8, 0xfa, 0xfe, 0x82, 0x7e,
      0x0c, 0x1a, 0xfc, 0x5d, 0x8d, 0x80, 0x36, 0x6e, 0x2b, 0x20, 0xe7, 0xf1,
      0x4a, 0x56, 0x3a, 0x2b, 0xa5, 0x04, 0x69, 0xd8, 0x43, 0x75, 0xe8, 0x68,
      0x61, 0x25, 0x69, 0xd3, 0x9e, 0x2b, 0xb9, 0xf5, 0x54, 0x35, 0x55, 0x64,
      0x64, 0x6d, 0xe9, 0x9a, 0xc6, 0x02, 0xcc, 0x63, 0x49, 0xcf, 0x8c, 0x1e,
      0x23, 0x6a, 0x7d, 0xe7, 0x63, 0x7d, 0x93},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 333
    {SEC_OID_SHA256,
     333,
     {0x30, 0x44, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x20, 0x26, 0x66, 0x66, 0x66, 0x3b, 0xbb, 0xbb, 0xbb, 0xe6, 0x66,
      0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x5b, 0x37, 0x90, 0x2e, 0x02, 0x3f,
      0xab, 0x7c, 0x8f, 0x05, 0x5d, 0x86, 0xe5, 0xcc, 0x41, 0xf4},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x83, 0x6f, 0x33, 0xbb, 0xc1, 0xdc, 0x0d, 0x3d, 0x3a,
      0xbb, 0xce, 0xf0, 0xd9, 0x1f, 0x11, 0xe2, 0xac, 0x41, 0x81, 0x07, 0x6c,
      0x9a, 0xf0, 0xa2, 0x2b, 0x1e, 0x43, 0x09, 0xd3, 0xed, 0xb2, 0x76, 0x9a,
      0xb4, 0x43, 0xff, 0x6f, 0x90, 0x1e, 0x30, 0xc7, 0x73, 0x86, 0x75, 0x82,
      0x99, 0x7c, 0x2b, 0xec, 0x2b, 0x0c, 0xb8, 0x12, 0x0d, 0x76, 0x02, 0x36,
      0xf3, 0xa9, 0x5b, 0xbe, 0x88, 0x1f, 0x75},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 334
    {SEC_OID_SHA256,
     334,
     {0x30, 0x45, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x21, 0x00, 0xbf, 0xff, 0xff, 0xff, 0x36, 0xdb, 0x6d, 0xb7, 0xa4,
      0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x14, 0x6c, 0x57, 0x3f, 0x4c,
      0x6d, 0xfc, 0x8d, 0x08, 0xa4, 0x43, 0xe2, 0x58, 0x97, 0x0b, 0x09},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x92, 0xf9, 0x9f, 0xbe, 0x97, 0x3e, 0xd4, 0xa2, 0x99,
      0x71, 0x9b, 0xae, 0xe4, 0xb4, 0x32, 0x74, 0x12, 0x37, 0x03, 0x4d, 0xec,
      0x8d, 0x72, 0xba, 0x51, 0x03, 0xcb, 0x33, 0xe5, 0x5f, 0xee, 0xb8, 0x03,
      0x3d, 0xd0, 0xe9, 0x11, 0x34, 0xc7, 0x34, 0x17, 0x48, 0x89, 0xf3, 0xeb,
      0xcf, 0x1b, 0x7a, 0x1a, 0xc0, 0x57, 0x67, 0x28, 0x92, 0x80, 0xee, 0x7a,
      0x79, 0x4c, 0xeb, 0xd6, 0xe6, 0x96, 0x97},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 335
    {SEC_OID_SHA256,
     335,
     {0x30, 0x45, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x21, 0x00, 0xbf, 0xff, 0xff, 0xff, 0x2a, 0xaa, 0xaa, 0xab, 0x7f,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0x15, 0xd0, 0xe6, 0x0b,
      0x3e, 0x59, 0x6e, 0xcb, 0x1a, 0xd3, 0xa2, 0x7c, 0xfd, 0x49, 0xc4},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xd3, 0x5b, 0xa5, 0x8d, 0xa3, 0x01, 0x97, 0xd3, 0x78,
      0xe6, 0x18, 0xec, 0x0f, 0xa7, 0xe2, 0xe2, 0xd1, 0x2c, 0xff, 0xd7, 0x3e,
      0xbb, 0xb2, 0x04, 0x9d, 0x13, 0x0b, 0xba, 0x43, 0x4a, 0xf0, 0x9e, 0xff,
      0x83, 0x98, 0x6e, 0x68, 0x75, 0xe4, 0x1e, 0xa4, 0x32, 0xb7, 0x58, 0x5a,
      0x49, 0xb3, 0xa6, 0xc7, 0x7c, 0xbb, 0x3c, 0x47, 0x91, 0x9f, 0x8e, 0x82,
      0x87, 0x4c, 0x79, 0x46, 0x35, 0xc1, 0xd2},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 336
    {SEC_OID_SHA256,
     336,
     {0x30, 0x44, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd3, 0x44, 0xa7, 0x1e, 0x6f, 0x65,
      0x14, 0x58, 0xa2, 0x7b, 0xdc, 0x81, 0xfd, 0x97, 0x6e, 0x37},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x86, 0x51, 0xce, 0x49, 0x0f, 0x1b, 0x46, 0xd7, 0x3f,
      0x3f, 0xf4, 0x75, 0x14, 0x9b, 0xe2, 0x91, 0x36, 0x69, 0x73, 0x34, 0xa5,
      0x19, 0xd7, 0xdd, 0xab, 0x07, 0x25, 0xc8, 0xd0, 0x79, 0x32, 0x24, 0xe1,
      0x1c, 0x65, 0xbd, 0x8c, 0xa9, 0x2d, 0xc8, 0xbc, 0x9a, 0xe8, 0x29, 0x11,
      0xf0, 0xb5, 0x27, 0x51, 0xce, 0x21, 0xdd, 0x90, 0x03, 0xae, 0x60, 0x90,
      0x0b, 0xd8, 0x25, 0xf5, 0x90, 0xcc, 0x28},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 337
    {SEC_OID_SHA256,
     337,
     {0x30, 0x44, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x20, 0x3f, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x7f, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x73, 0x7d, 0x56, 0xd3, 0x8b,
      0xcf, 0x42, 0x79, 0xdc, 0xe5, 0x61, 0x7e, 0x31, 0x92, 0xaa},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x6d, 0x8e, 0x1b, 0x12, 0xc8, 0x31, 0xa0, 0xda, 0x87,
      0x95, 0x65, 0x0f, 0xf9, 0x5f, 0x10, 0x1e, 0xd9, 0x21, 0xd9, 0xe2, 0xf7,
      0x2b, 0x15, 0xb1, 0xcd, 0xac, 0xa9, 0x82, 0x6b, 0x9c, 0xfc, 0x6d, 0xef,
      0x6d, 0x63, 0xe2, 0xbc, 0x5c, 0x08, 0x95, 0x70, 0x39, 0x4a, 0x4b, 0xc9,
      0xf8, 0x92, 0xd5, 0xe6, 0xc7, 0xa6, 0xa6, 0x37, 0xb2, 0x04, 0x69, 0xa5,
      0x8c, 0x10, 0x6a, 0xd4, 0x86, 0xbf, 0x37},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 338
    {SEC_OID_SHA256,
     338,
     {0x30, 0x44, 0x02, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
      0x02, 0x20, 0x5d, 0x8e, 0xcd, 0x64, 0xa4, 0xee, 0xba, 0x46, 0x68, 0x15,
      0xdd, 0xf3, 0xa4, 0xde, 0x9a, 0x8e, 0x6a, 0xbd, 0x9c, 0x5d, 0xb0, 0xa0,
      0x1e, 0xb8, 0x03, 0x43, 0x55, 0x3d, 0xa6, 0x48, 0x42, 0x8f},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x0a, 0xe5, 0x80, 0xba, 0xe9, 0x33, 0xb4, 0xef, 0x29,
      0x97, 0xcb, 0xdb, 0xb0, 0x92, 0x23, 0x28, 0xca, 0x9a, 0x41, 0x0f, 0x62,
      0x7a, 0x0f, 0x7d, 0xff, 0x24, 0xcb, 0x4d, 0x92, 0x0e, 0x15, 0x42, 0x89,
      0x11, 0xe7, 0xf8, 0xcc, 0x36, 0x5a, 0x8a, 0x88, 0xeb, 0x81, 0x42, 0x1a,
      0x36, 0x1c, 0xcc, 0x2b, 0x99, 0xe3, 0x09, 0xd8, 0xdc, 0xd9, 0xa9, 0x8b,
      0xa8, 0x3c, 0x39, 0x49, 0xd8, 0x93, 0xe3},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: point duplication during verification
    // tcID: 339
    {SEC_OID_SHA256,
     339,
     {0x30, 0x45, 0x02, 0x20, 0x6f, 0x23, 0x47, 0xca, 0xb7, 0xdd, 0x76, 0x85,
      0x8f, 0xe0, 0x55, 0x5a, 0xc3, 0xbc, 0x99, 0x04, 0x8c, 0x4a, 0xac, 0xaf,
      0xdf, 0xb6, 0xbc, 0xbe, 0x05, 0xea, 0x6c, 0x42, 0xc4, 0x93, 0x45, 0x69,
      0x02, 0x21, 0x00, 0xbb, 0x72, 0x66, 0x60, 0x23, 0x57, 0x93, 0xaa, 0x99,
      0x57, 0xa6, 0x1e, 0x76, 0xe0, 0x0c, 0x2c, 0x43, 0x51, 0x09, 0xcf, 0x9a,
      0x15, 0xdd, 0x62, 0x4d, 0x53, 0xf4, 0x30, 0x10, 0x47, 0x85, 0x6b},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x5b, 0x81, 0x2f, 0xd5, 0x21, 0xaa, 0xfa, 0x69, 0x83,
      0x5a, 0x84, 0x9c, 0xce, 0x6f, 0xbd, 0xeb, 0x69, 0x83, 0xb4, 0x42, 0xd2,
      0x44, 0x4f, 0xe7, 0x0e, 0x13, 0x4c, 0x02, 0x7f, 0xc4, 0x69, 0x63, 0x83,
      0x8a, 0x40, 0xf2, 0xa3, 0x60, 0x92, 0xe9, 0x00, 0x4e, 0x92, 0xd8, 0xd9,
      0x40, 0xcf, 0x56, 0x38, 0x55, 0x0c, 0xe6, 0x72, 0xce, 0x8b, 0x8d, 0x4e,
      0x15, 0xeb, 0xa5, 0x49, 0x92, 0x49, 0xe9},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: duplication bug
    // tcID: 340
    {SEC_OID_SHA256,
     340,
     {0x30, 0x45, 0x02, 0x20, 0x6f, 0x23, 0x47, 0xca, 0xb7, 0xdd, 0x76, 0x85,
      0x8f, 0xe0, 0x55, 0x5a, 0xc3, 0xbc, 0x99, 0x04, 0x8c, 0x4a, 0xac, 0xaf,
      0xdf, 0xb6, 0xbc, 0xbe, 0x05, 0xea, 0x6c, 0x42, 0xc4, 0x93, 0x45, 0x69,
      0x02, 0x21, 0x00, 0xbb, 0x72, 0x66, 0x60, 0x23, 0x57, 0x93, 0xaa, 0x99,
      0x57, 0xa6, 0x1e, 0x76, 0xe0, 0x0c, 0x2c, 0x43, 0x51, 0x09, 0xcf, 0x9a,
      0x15, 0xdd, 0x62, 0x4d, 0x53, 0xf4, 0x30, 0x10, 0x47, 0x85, 0x6b},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x5b, 0x81, 0x2f, 0xd5, 0x21, 0xaa, 0xfa, 0x69, 0x83,
      0x5a, 0x84, 0x9c, 0xce, 0x6f, 0xbd, 0xeb, 0x69, 0x83, 0xb4, 0x42, 0xd2,
      0x44, 0x4f, 0xe7, 0x0e, 0x13, 0x4c, 0x02, 0x7f, 0xc4, 0x69, 0x63, 0x7c,
      0x75, 0xbf, 0x0c, 0x5c, 0x9f, 0x6d, 0x17, 0xff, 0xb1, 0x6d, 0x27, 0x26,
      0xbf, 0x30, 0xa9, 0xc7, 0xaa, 0xf3, 0x1a, 0x8d, 0x31, 0x74, 0x72, 0xb1,
      0xea, 0x14, 0x5a, 0xb6, 0x6d, 0xb6, 0x16},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: point with x-coordinate 0
    // tcID: 341
    {SEC_OID_SHA256,
     341,
     {0x30, 0x25, 0x02, 0x01, 0x01, 0x02, 0x20, 0x55, 0x55, 0x55,
      0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4, 0x8d, 0x07, 0xdf,
      0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x6a, 0xdd, 0xa8, 0x2b, 0x90, 0x26, 0x1b, 0x0f, 0x31,
      0x9f, 0xaa, 0x0d, 0x87, 0x86, 0x65, 0xa6, 0xb6, 0xda, 0x49, 0x7f, 0x09,
      0xc9, 0x03, 0x17, 0x62, 0x22, 0xc3, 0x4a, 0xcf, 0xef, 0x72, 0xa6, 0x47,
      0xe6, 0xf5, 0x0d, 0xcc, 0x40, 0xad, 0x5d, 0x9b, 0x59, 0xf7, 0x60, 0x2b,
      0xb2, 0x22, 0xfa, 0xd7, 0x1a, 0x41, 0xbf, 0x5e, 0x1f, 0x9d, 0xf4, 0x95,
      0x9a, 0x36, 0x4c, 0x62, 0xe4, 0x88, 0xd9},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: point with x-coordinate 0
    // tcID: 342
    {SEC_OID_SHA256,
     342,
     {0x30, 0x45, 0x02, 0x21, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x02, 0x20, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x33,
      0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x25, 0xc7, 0xcb, 0xbc, 0x54,
      0x9e, 0x52, 0xe7, 0x63, 0xf1, 0xf5, 0x5a, 0x32, 0x7a, 0x3a, 0xa9},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x2f, 0xca, 0x0d, 0x0a, 0x47, 0x91, 0x4d, 0xe7, 0x7e,
      0xd5, 0x6e, 0x7e, 0xcc, 0xc3, 0x27, 0x6a, 0x60, 0x11, 0x20, 0xc6, 0xdf,
      0x00, 0x69, 0xc8, 0x25, 0xc8, 0xf6, 0xa0, 0x1c, 0x9f, 0x38, 0x20, 0x65,
      0xf3, 0x45, 0x0a, 0x1d, 0x17, 0xc6, 0xb2, 0x49, 0x89, 0xa3, 0x9b, 0xeb,
      0x1c, 0x7d, 0xec, 0xfc, 0xa8, 0x38, 0x4f, 0xbd, 0xc2, 0x94, 0x41, 0x8e,
      0x5d, 0x80, 0x7b, 0x3c, 0x6e, 0xd7, 0xde},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: comparison with point at infinity
    // tcID: 343
    {SEC_OID_SHA256,
     343,
     {0x30, 0x44, 0x02, 0x20, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4,
      0x8d, 0x07, 0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70,
      0x02, 0x20, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33,
      0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x25, 0xc7, 0xcb, 0xbc, 0x54, 0x9e,
      0x52, 0xe7, 0x63, 0xf1, 0xf5, 0x5a, 0x32, 0x7a, 0x3a, 0xa9},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xdd, 0x86, 0xd3, 0xb5, 0xf4, 0xa1, 0x3e, 0x85, 0x11,
      0x08, 0x3b, 0x78, 0x00, 0x20, 0x81, 0xc5, 0x3f, 0xf4, 0x67, 0xf1, 0x1e,
      0xbd, 0x98, 0xa5, 0x1a, 0x63, 0x3d, 0xb7, 0x66, 0x65, 0xd2, 0x50, 0x45,
      0xd5, 0xc8, 0x20, 0x0c, 0x89, 0xf2, 0xfa, 0x10, 0xd8, 0x49, 0x34, 0x92,
      0x26, 0xd2, 0x1d, 0x8d, 0xfa, 0xed, 0x6f, 0xf8, 0xd5, 0xcb, 0x3e, 0x1b,
      0x7e, 0x17, 0x47, 0x4e, 0xbc, 0x18, 0xf7},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: extreme value for k and edgecase s
    // tcID: 344
    {SEC_OID_SHA256,
     344,
     {0x30, 0x44, 0x02, 0x20, 0x7c, 0xf2, 0x7b, 0x18, 0x8d, 0x03, 0x4f, 0x7e,
      0x8a, 0x52, 0x38, 0x03, 0x04, 0xb5, 0x1a, 0xc3, 0xc0, 0x89, 0x69, 0xe2,
      0x77, 0xf2, 0x1b, 0x35, 0xa6, 0x0b, 0x48, 0xfc, 0x47, 0x66, 0x99, 0x78,
      0x02, 0x20, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4, 0x8d, 0x07,
      0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x4f, 0xea, 0x55, 0xb3, 0x2c, 0xb3, 0x2a, 0xca, 0x0c,
      0x12, 0xc4, 0xcd, 0x0a, 0xbf, 0xb4, 0xe6, 0x4b, 0x0f, 0x5a, 0x51, 0x6e,
      0x57, 0x8c, 0x01, 0x65, 0x91, 0xa9, 0x3f, 0x5a, 0x0f, 0xbc, 0xc5, 0xd7,
      0xd3, 0xfd, 0x10, 0xb2, 0xbe, 0x66, 0x8c, 0x54, 0x7b, 0x21, 0x2f, 0x6b,
      0xb1, 0x4c, 0x88, 0xf0, 0xfe, 0xcd, 0x38, 0xa8, 0xa4, 0xb2, 0xc7, 0x85,
      0xed, 0x3b, 0xe6, 0x2c, 0xe4, 0xb2, 0x80},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 345
    {SEC_OID_SHA256,
     345,
     {0x30, 0x45, 0x02, 0x20, 0x7c, 0xf2, 0x7b, 0x18, 0x8d, 0x03, 0x4f, 0x7e,
      0x8a, 0x52, 0x38, 0x03, 0x04, 0xb5, 0x1a, 0xc3, 0xc0, 0x89, 0x69, 0xe2,
      0x77, 0xf2, 0x1b, 0x35, 0xa6, 0x0b, 0x48, 0xfc, 0x47, 0x66, 0x99, 0x78,
      0x02, 0x21, 0x00, 0xb6, 0xdb, 0x6d, 0xb6, 0x24, 0x92, 0x49, 0x25, 0x49,
      0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x62, 0x5b, 0xd7, 0xa0, 0x9b,
      0xec, 0x4c, 0xa8, 0x1b, 0xcd, 0xd9, 0xf8, 0xfd, 0x6b, 0x63, 0xcc},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xc6, 0xa7, 0x71, 0x52, 0x70, 0x24, 0x22, 0x77, 0x92,
      0x17, 0x0a, 0x6f, 0x8e, 0xee, 0x73, 0x5b, 0xf3, 0x2b, 0x7f, 0x98, 0xaf,
      0x66, 0x9e, 0xad, 0x29, 0x98, 0x02, 0xe3, 0x2d, 0x7c, 0x31, 0x07, 0xbc,
      0x3b, 0x4b, 0x5e, 0x65, 0xab, 0x88, 0x7b, 0xbd, 0x34, 0x35, 0x72, 0xb3,
      0xe5, 0x61, 0x92, 0x61, 0xfe, 0x3a, 0x07, 0x3e, 0x2f, 0xfd, 0x78, 0x41,
      0x2f, 0x72, 0x68, 0x67, 0xdb, 0x58, 0x9e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 346
    {SEC_OID_SHA256,
     346,
     {0x30, 0x45, 0x02, 0x20, 0x7c, 0xf2, 0x7b, 0x18, 0x8d, 0x03, 0x4f, 0x7e,
      0x8a, 0x52, 0x38, 0x03, 0x04, 0xb5, 0x1a, 0xc3, 0xc0, 0x89, 0x69, 0xe2,
      0x77, 0xf2, 0x1b, 0x35, 0xa6, 0x0b, 0x48, 0xfc, 0x47, 0x66, 0x99, 0x78,
      0x02, 0x21, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0x00, 0x00, 0x00, 0x00, 0xcc,
      0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x97, 0x1f, 0x2e, 0xf1, 0x52,
      0x79, 0x4b, 0x9d, 0x8f, 0xc7, 0xd5, 0x68, 0xc9, 0xe8, 0xea, 0xa7},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x85, 0x1c, 0x2b, 0xba, 0xd0, 0x8e, 0x54, 0xec, 0x7a,
      0x9a, 0xf9, 0x9f, 0x49, 0xf0, 0x36, 0x44, 0xd6, 0xec, 0x6d, 0x59, 0xb2,
      0x07, 0xfe, 0xc9, 0x8d, 0xe8, 0x5a, 0x7d, 0x15, 0xb9, 0x56, 0xef, 0xce,
      0xe9, 0x96, 0x02, 0x83, 0x04, 0x50, 0x75, 0x68, 0x4b, 0x41, 0x0b, 0xe8,
      0xd0, 0xf7, 0x49, 0x4b, 0x91, 0xaa, 0x23, 0x79, 0xf6, 0x07, 0x27, 0x31,
      0x9f, 0x10, 0xdd, 0xeb, 0x0f, 0xe9, 0xd6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 347
    {SEC_OID_SHA256,
     347,
     {0x30, 0x44, 0x02, 0x20, 0x7c, 0xf2, 0x7b, 0x18, 0x8d, 0x03, 0x4f, 0x7e,
      0x8a, 0x52, 0x38, 0x03, 0x04, 0xb5, 0x1a, 0xc3, 0xc0, 0x89, 0x69, 0xe2,
      0x77, 0xf2, 0x1b, 0x35, 0xa6, 0x0b, 0x48, 0xfc, 0x47, 0x66, 0x99, 0x78,
      0x02, 0x20, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33,
      0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x25, 0xc7, 0xcb, 0xbc, 0x54, 0x9e,
      0x52, 0xe7, 0x63, 0xf1, 0xf5, 0x5a, 0x32, 0x7a, 0x3a, 0xaa},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xf6, 0x41, 0x7c, 0x8a, 0x67, 0x05, 0x84, 0xe3, 0x88,
      0x67, 0x69, 0x49, 0xe5, 0x3d, 0xa7, 0xfc, 0x55, 0x91, 0x1f, 0xf6, 0x83,
      0x18, 0xd1, 0xbf, 0x30, 0x61, 0x20, 0x5a, 0xcb, 0x19, 0xc4, 0x8f, 0x8f,
      0x2b, 0x74, 0x3d, 0xf3, 0x4a, 0xd0, 0xf7, 0x26, 0x74, 0xac, 0xb7, 0x50,
      0x59, 0x29, 0x78, 0x47, 0x79, 0xcd, 0x9a, 0xc9, 0x16, 0xc3, 0x66, 0x9e,
      0xad, 0x43, 0x02, 0x6a, 0xb6, 0xd4, 0x3f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 348
    {SEC_OID_SHA256,
     348,
     {0x30, 0x44, 0x02, 0x20, 0x7c, 0xf2, 0x7b, 0x18, 0x8d, 0x03, 0x4f, 0x7e,
      0x8a, 0x52, 0x38, 0x03, 0x04, 0xb5, 0x1a, 0xc3, 0xc0, 0x89, 0x69, 0xe2,
      0x77, 0xf2, 0x1b, 0x35, 0xa6, 0x0b, 0x48, 0xfc, 0x47, 0x66, 0x99, 0x78,
      0x02, 0x20, 0x49, 0x24, 0x92, 0x48, 0xdb, 0x6d, 0xb6, 0xdb, 0xb6, 0xdb,
      0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x5a, 0x8b, 0x23, 0x0d, 0x0b, 0x2b,
      0x51, 0xdc, 0xd7, 0xeb, 0xf0, 0xc9, 0xfe, 0xf7, 0xc1, 0x85},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x50, 0x14, 0x21, 0x27, 0x7b, 0xe4, 0x5a, 0x5e, 0xef,
      0xec, 0x6c, 0x63, 0x99, 0x30, 0xd6, 0x36, 0x03, 0x25, 0x65, 0xaf, 0x42,
      0x0c, 0xf3, 0x37, 0x3f, 0x55, 0x7f, 0xaa, 0x7f, 0x8a, 0x06, 0x43, 0x86,
      0x73, 0xd6, 0xcb, 0x60, 0x76, 0xe1, 0xcf, 0xcd, 0xc7, 0xdf, 0xe7, 0x38,
      0x4c, 0x8e, 0x5c, 0xac, 0x08, 0xd7, 0x45, 0x01, 0xf2, 0xae, 0x6e, 0x89,
      0xca, 0xd1, 0x95, 0xd0, 0xaa, 0x13, 0x71},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k
    // tcID: 349
    {SEC_OID_SHA256,
     349,
     {0x30, 0x44, 0x02, 0x20, 0x7c, 0xf2, 0x7b, 0x18, 0x8d, 0x03, 0x4f, 0x7e,
      0x8a, 0x52, 0x38, 0x03, 0x04, 0xb5, 0x1a, 0xc3, 0xc0, 0x89, 0x69, 0xe2,
      0x77, 0xf2, 0x1b, 0x35, 0xa6, 0x0b, 0x48, 0xfc, 0x47, 0x66, 0x99, 0x78,
      0x02, 0x20, 0x16, 0xa4, 0x50, 0x2e, 0x27, 0x81, 0xe1, 0x1a, 0xc8, 0x2c,
      0xbc, 0x9d, 0x1e, 0xdd, 0x8c, 0x98, 0x15, 0x84, 0xd1, 0x3e, 0x18, 0x41,
      0x1e, 0x2f, 0x6e, 0x04, 0x78, 0xc3, 0x44, 0x16, 0xe3, 0xbb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x0d, 0x93, 0x5b, 0xf9, 0xff, 0xc1, 0x15, 0xa5, 0x27,
      0x73, 0x5f, 0x72, 0x9c, 0xa8, 0xa4, 0xca, 0x23, 0xee, 0x01, 0xa4, 0x89,
      0x4a, 0xdf, 0x0e, 0x34, 0x15, 0xac, 0x84, 0xe8, 0x08, 0xbb, 0x34, 0x31,
      0x95, 0xa3, 0x76, 0x2f, 0xea, 0x29, 0xed, 0x38, 0x91, 0x2b, 0xd9, 0xea,
      0x6c, 0x4f, 0xde, 0x70, 0xc3, 0x05, 0x08, 0x93, 0xa4, 0x37, 0x58, 0x50,
      0xce, 0x61, 0xd8, 0x2e, 0xba, 0x33, 0xc5},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and edgecase s
    // tcID: 350
    {SEC_OID_SHA256,
     350,
     {0x30, 0x44, 0x02, 0x20, 0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47,
      0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81,
      0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96,
      0x02, 0x20, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4, 0x8d, 0x07,
      0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x5e, 0x59, 0xf5, 0x07, 0x08, 0x64, 0x6b, 0xe8, 0xa5,
      0x89, 0x35, 0x50, 0x14, 0x30, 0x8e, 0x60, 0xb6, 0x68, 0xfb, 0x67, 0x01,
      0x96, 0x20, 0x6c, 0x41, 0xe7, 0x48, 0xe6, 0x4e, 0x4d, 0xca, 0x21, 0x5d,
      0xe3, 0x7f, 0xee, 0x5c, 0x97, 0xbc, 0xaf, 0x71, 0x44, 0xd5, 0xb4, 0x59,
      0x98, 0x2f, 0x52, 0xee, 0xea, 0xfb, 0xdf, 0x03, 0xaa, 0xcb, 0xaf, 0xef,
      0x38, 0xe2, 0x13, 0x62, 0x4a, 0x01, 0xde},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 351
    {SEC_OID_SHA256,
     351,
     {0x30, 0x45, 0x02, 0x20, 0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47,
      0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81,
      0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96,
      0x02, 0x21, 0x00, 0xb6, 0xdb, 0x6d, 0xb6, 0x24, 0x92, 0x49, 0x25, 0x49,
      0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x62, 0x5b, 0xd7, 0xa0, 0x9b,
      0xec, 0x4c, 0xa8, 0x1b, 0xcd, 0xd9, 0xf8, 0xfd, 0x6b, 0x63, 0xcc},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x16, 0x9f, 0xb7, 0x97, 0x32, 0x58, 0x43, 0xfa, 0xff,
      0x2f, 0x7a, 0x5b, 0x54, 0x45, 0xda, 0x9e, 0x2f, 0xd6, 0x22, 0x6f, 0x7e,
      0xf9, 0x0e, 0xf0, 0xbf, 0xe9, 0x24, 0x10, 0x4b, 0x02, 0xdb, 0x8e, 0x7b,
      0xbb, 0x8d, 0xe6, 0x62, 0xc7, 0xb9, 0xb1, 0xcf, 0x9b, 0x22, 0xf7, 0xa2,
      0xe5, 0x82, 0xbd, 0x46, 0xd5, 0x81, 0xd6, 0x88, 0x78, 0xef, 0xb2, 0xb8,
      0x61, 0xb1, 0x31, 0xd8, 0xa1, 0xd6, 0x67},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 352
    {SEC_OID_SHA256,
     352,
     {0x30, 0x45, 0x02, 0x20, 0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47,
      0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81,
      0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96,
      0x02, 0x21, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0x00, 0x00, 0x00, 0x00, 0xcc,
      0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x97, 0x1f, 0x2e, 0xf1, 0x52,
      0x79, 0x4b, 0x9d, 0x8f, 0xc7, 0xd5, 0x68, 0xc9, 0xe8, 0xea, 0xa7},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x27, 0x1c, 0xd8, 0x9c, 0x00, 0x01, 0x43, 0x09, 0x6b,
      0x62, 0xd4, 0xe9, 0xe4, 0xca, 0x88, 0x5a, 0xef, 0x2f, 0x70, 0x23, 0xd1,
      0x8a, 0xff, 0xda, 0xf8, 0xb7, 0xb5, 0x48, 0x98, 0x14, 0x87, 0x54, 0x0a,
      0x1c, 0x6e, 0x95, 0x4e, 0x32, 0x10, 0x84, 0x35, 0xb5, 0x5f, 0xa3, 0x85,
      0xb0, 0xf7, 0x64, 0x81, 0xa6, 0x09, 0xb9, 0x14, 0x9c, 0xcb, 0x4b, 0x02,
      0xb2, 0xca, 0x47, 0xfe, 0x8e, 0x4d, 0xa5},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 353
    {SEC_OID_SHA256,
     353,
     {0x30, 0x44, 0x02, 0x20, 0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47,
      0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81,
      0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96,
      0x02, 0x20, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33,
      0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x25, 0xc7, 0xcb, 0xbc, 0x54, 0x9e,
      0x52, 0xe7, 0x63, 0xf1, 0xf5, 0x5a, 0x32, 0x7a, 0x3a, 0xaa},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x3d, 0x0b, 0xc7, 0xed, 0x8f, 0x09, 0xd2, 0xcb, 0x7d,
      0xdb, 0x46, 0xeb, 0xc1, 0xed, 0x79, 0x9a, 0xb1, 0x56, 0x3a, 0x9a, 0xb8,
      0x4b, 0xf5, 0x24, 0x58, 0x7a, 0x22, 0x0a, 0xfe, 0x49, 0x9c, 0x12, 0xe2,
      0x2d, 0xc3, 0xb3, 0xc1, 0x03, 0x82, 0x4a, 0x4f, 0x37, 0x8d, 0x96, 0xad,
      0xb0, 0xa4, 0x08, 0xab, 0xf1, 0x9c, 0xe7, 0xd6, 0x8a, 0xa6, 0x24, 0x4f,
      0x78, 0xcb, 0x21, 0x6f, 0xa3, 0xf8, 0xdf},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 354
    {SEC_OID_SHA256,
     354,
     {0x30, 0x44, 0x02, 0x20, 0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47,
      0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81,
      0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96,
      0x02, 0x20, 0x49, 0x24, 0x92, 0x48, 0xdb, 0x6d, 0xb6, 0xdb, 0xb6, 0xdb,
      0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x5a, 0x8b, 0x23, 0x0d, 0x0b, 0x2b,
      0x51, 0xdc, 0xd7, 0xeb, 0xf0, 0xc9, 0xfe, 0xf7, 0xc1, 0x85},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xa6, 0xc8, 0x85, 0xad, 0xe1, 0xa4, 0xc5, 0x66, 0xf9,
      0xbb, 0x01, 0x0d, 0x06, 0x69, 0x74, 0xab, 0xb2, 0x81, 0x79, 0x7f, 0xa7,
      0x01, 0x28, 0x8c, 0x72, 0x1b, 0xcb, 0xd2, 0x36, 0x63, 0xa9, 0xb7, 0x2e,
      0x42, 0x4b, 0x69, 0x09, 0x57, 0x16, 0x8d, 0x19, 0x3a, 0x60, 0x96, 0xfc,
      0x77, 0xa2, 0xb0, 0x04, 0xa9, 0xc7, 0xd4, 0x67, 0xe0, 0x07, 0xe1, 0xf2,
      0x05, 0x84, 0x58, 0xf9, 0x8a, 0xf3, 0x16},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k
    // tcID: 355
    {SEC_OID_SHA256,
     355,
     {0x30, 0x44, 0x02, 0x20, 0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47,
      0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81,
      0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96,
      0x02, 0x20, 0x16, 0xa4, 0x50, 0x2e, 0x27, 0x81, 0xe1, 0x1a, 0xc8, 0x2c,
      0xbc, 0x9d, 0x1e, 0xdd, 0x8c, 0x98, 0x15, 0x84, 0xd1, 0x3e, 0x18, 0x41,
      0x1e, 0x2f, 0x6e, 0x04, 0x78, 0xc3, 0x44, 0x16, 0xe3, 0xbb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x8d, 0x3c, 0x2c, 0x2c, 0x3b, 0x76, 0x5b, 0xa8, 0x28,
      0x9e, 0x6a, 0xc3, 0x81, 0x25, 0x72, 0xa2, 0x5b, 0xf7, 0x5d, 0xf6, 0x2d,
      0x87, 0xab, 0x73, 0x30, 0xc3, 0xbd, 0xba, 0xd9, 0xeb, 0xfa, 0x5c, 0x4c,
      0x68, 0x45, 0x44, 0x2d, 0x66, 0x93, 0x5b, 0x23, 0x85, 0x78, 0xd4, 0x3a,
      0xec, 0x54, 0xf7, 0xca, 0xa1, 0x62, 0x1d, 0x1a, 0xf2, 0x41, 0xd4, 0x63,
      0x2e, 0x0b, 0x78, 0x0c, 0x42, 0x3f, 0x5d},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: testing point duplication
    // tcID: 356
    {SEC_OID_SHA256,
     356,
     {0x30, 0x45, 0x02, 0x21, 0x00, 0xbb, 0x5a, 0x52, 0xf4, 0x2f, 0x9c, 0x92,
      0x61, 0xed, 0x43, 0x61, 0xf5, 0x94, 0x22, 0xa1, 0xe3, 0x00, 0x36, 0xe7,
      0xc3, 0x2b, 0x27, 0x0c, 0x88, 0x07, 0xa4, 0x19, 0xfe, 0xca, 0x60, 0x50,
      0x23, 0x02, 0x20, 0x24, 0x92, 0x49, 0x24, 0x6d, 0xb6, 0xdb, 0x6d, 0xdb,
      0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xad, 0x45, 0x91, 0x86, 0x85,
      0x95, 0xa8, 0xee, 0x6b, 0xf5, 0xf8, 0x64, 0xff, 0x7b, 0xe0, 0xc2},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8,
      0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d,
      0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96, 0x4f,
      0xe3, 0x42, 0xe2, 0xfe, 0x1a, 0x7f, 0x9b, 0x8e, 0xe7, 0xeb, 0x4a, 0x7c,
      0x0f, 0x9e, 0x16, 0x2b, 0xce, 0x33, 0x57, 0x6b, 0x31, 0x5e, 0xce, 0xcb,
      0xb6, 0x40, 0x68, 0x37, 0xbf, 0x51, 0xf5},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: testing point duplication
    // tcID: 357
    {SEC_OID_SHA256,
     357,
     {0x30, 0x44, 0x02, 0x20, 0x44, 0xa5, 0xad, 0x0a, 0xd0, 0x63, 0x6d, 0x9f,
      0x12, 0xbc, 0x9e, 0x0a, 0x6b, 0xdd, 0x5e, 0x1c, 0xbc, 0xb0, 0x12, 0xea,
      0x7b, 0xf0, 0x91, 0xfc, 0xec, 0x15, 0xb0, 0xc4, 0x32, 0x02, 0xd5, 0x2e,
      0x02, 0x20, 0x24, 0x92, 0x49, 0x24, 0x6d, 0xb6, 0xdb, 0x6d, 0xdb, 0x6d,
      0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xad, 0x45, 0x91, 0x86, 0x85, 0x95,
      0xa8, 0xee, 0x6b, 0xf5, 0xf8, 0x64, 0xff, 0x7b, 0xe0, 0xc2},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8,
      0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d,
      0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96, 0x4f,
      0xe3, 0x42, 0xe2, 0xfe, 0x1a, 0x7f, 0x9b, 0x8e, 0xe7, 0xeb, 0x4a, 0x7c,
      0x0f, 0x9e, 0x16, 0x2b, 0xce, 0x33, 0x57, 0x6b, 0x31, 0x5e, 0xce, 0xcb,
      0xb6, 0x40, 0x68, 0x37, 0xbf, 0x51, 0xf5},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: testing point duplication
    // tcID: 358
    {SEC_OID_SHA256,
     358,
     {0x30, 0x45, 0x02, 0x21, 0x00, 0xbb, 0x5a, 0x52, 0xf4, 0x2f, 0x9c, 0x92,
      0x61, 0xed, 0x43, 0x61, 0xf5, 0x94, 0x22, 0xa1, 0xe3, 0x00, 0x36, 0xe7,
      0xc3, 0x2b, 0x27, 0x0c, 0x88, 0x07, 0xa4, 0x19, 0xfe, 0xca, 0x60, 0x50,
      0x23, 0x02, 0x20, 0x24, 0x92, 0x49, 0x24, 0x6d, 0xb6, 0xdb, 0x6d, 0xdb,
      0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xad, 0x45, 0x91, 0x86, 0x85,
      0x95, 0xa8, 0xee, 0x6b, 0xf5, 0xf8, 0x64, 0xff, 0x7b, 0xe0, 0xc2},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8,
      0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d,
      0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96, 0xb0,
      0x1c, 0xbd, 0x1c, 0x01, 0xe5, 0x80, 0x65, 0x71, 0x18, 0x14, 0xb5, 0x83,
      0xf0, 0x61, 0xe9, 0xd4, 0x31, 0xcc, 0xa9, 0x94, 0xce, 0xa1, 0x31, 0x34,
      0x49, 0xbf, 0x97, 0xc8, 0x40, 0xae, 0x0a},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: testing point duplication
    // tcID: 359
    {SEC_OID_SHA256,
     359,
     {0x30, 0x44, 0x02, 0x20, 0x44, 0xa5, 0xad, 0x0a, 0xd0, 0x63, 0x6d, 0x9f,
      0x12, 0xbc, 0x9e, 0x0a, 0x6b, 0xdd, 0x5e, 0x1c, 0xbc, 0xb0, 0x12, 0xea,
      0x7b, 0xf0, 0x91, 0xfc, 0xec, 0x15, 0xb0, 0xc4, 0x32, 0x02, 0xd5, 0x2e,
      0x02, 0x20, 0x24, 0x92, 0x49, 0x24, 0x6d, 0xb6, 0xdb, 0x6d, 0xdb, 0x6d,
      0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xad, 0x45, 0x91, 0x86, 0x85, 0x95,
      0xa8, 0xee, 0x6b, 0xf5, 0xf8, 0x64, 0xff, 0x7b, 0xe0, 0xc2},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8,
      0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d,
      0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96, 0xb0,
      0x1c, 0xbd, 0x1c, 0x01, 0xe5, 0x80, 0x65, 0x71, 0x18, 0x14, 0xb5, 0x83,
      0xf0, 0x61, 0xe9, 0xd4, 0x31, 0xcc, 0xa9, 0x94, 0xce, 0xa1, 0x31, 0x34,
      0x49, 0xbf, 0x97, 0xc8, 0x40, 0xae, 0x0a},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: pseudorandom signature
    // tcID: 360
    {SEC_OID_SHA256,
     360,
     {0x30, 0x45, 0x02, 0x21, 0x00, 0xb2, 0x92, 0xa6, 0x19, 0x33, 0x9f, 0x6e,
      0x56, 0x7a, 0x30, 0x5c, 0x95, 0x1c, 0x0d, 0xcb, 0xcc, 0x42, 0xd1, 0x6e,
      0x47, 0xf2, 0x19, 0xf9, 0xe9, 0x8e, 0x76, 0xe0, 0x9d, 0x87, 0x70, 0xb3,
      0x4a, 0x02, 0x20, 0x01, 0x77, 0xe6, 0x04, 0x92, 0xc5, 0xa8, 0x24, 0x2f,
      0x76, 0xf0, 0x7b, 0xfe, 0x36, 0x61, 0xbd, 0xe5, 0x9e, 0xc2, 0xa1, 0x7c,
      0xe5, 0xbd, 0x2d, 0xab, 0x2a, 0xbe, 0xbd, 0xf8, 0x9a, 0x62, 0xe2},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x04, 0xaa, 0xec, 0x73, 0x63, 0x57, 0x26, 0xf2, 0x13,
      0xfb, 0x8a, 0x9e, 0x64, 0xda, 0x3b, 0x86, 0x32, 0xe4, 0x14, 0x95, 0xa9,
      0x44, 0xd0, 0x04, 0x5b, 0x52, 0x2e, 0xba, 0x72, 0x40, 0xfa, 0xd5, 0x87,
      0xd9, 0x31, 0x57, 0x98, 0xaa, 0xa3, 0xa5, 0xba, 0x01, 0x77, 0x57, 0x87,
      0xce, 0xd0, 0x5e, 0xaa, 0xf7, 0xb4, 0xe0, 0x9f, 0xc8, 0x1d, 0x6d, 0x1a,
      0xa5, 0x46, 0xe8, 0x36, 0x5d, 0x52, 0x5d},
     {},
     true},

    // Comment: pseudorandom signature
    // tcID: 361
    {SEC_OID_SHA256,
     361,
     {0x30, 0x45, 0x02, 0x20, 0x53, 0x0b, 0xd6, 0xb0, 0xc9, 0xaf, 0x2d, 0x69,
      0xba, 0x89, 0x7f, 0x6b, 0x5f, 0xb5, 0x96, 0x95, 0xcf, 0xbf, 0x33, 0xaf,
      0xe6, 0x6d, 0xba, 0xdc, 0xf5, 0xb8, 0xd2, 0xa2, 0xa6, 0x53, 0x8e, 0x23,
      0x02, 0x21, 0x00, 0xd8, 0x5e, 0x48, 0x9c, 0xb7, 0xa1, 0x61, 0xfd, 0x55,
      0xed, 0xed, 0xce, 0xdb, 0xf4, 0xcc, 0x0c, 0x09, 0x87, 0xe3, 0xe3, 0xf0,
      0xf2, 0x42, 0xca, 0xe9, 0x34, 0xc7, 0x2c, 0xaa, 0x3f, 0x43, 0xe9},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x04, 0xaa, 0xec, 0x73, 0x63, 0x57, 0x26, 0xf2, 0x13,
      0xfb, 0x8a, 0x9e, 0x64, 0xda, 0x3b, 0x86, 0x32, 0xe4, 0x14, 0x95, 0xa9,
      0x44, 0xd0, 0x04, 0x5b, 0x52, 0x2e, 0xba, 0x72, 0x40, 0xfa, 0xd5, 0x87,
      0xd9, 0x31, 0x57, 0x98, 0xaa, 0xa3, 0xa5, 0xba, 0x01, 0x77, 0x57, 0x87,
      0xce, 0xd0, 0x5e, 0xaa, 0xf7, 0xb4, 0xe0, 0x9f, 0xc8, 0x1d, 0x6d, 0x1a,
      0xa5, 0x46, 0xe8, 0x36, 0x5d, 0x52, 0x5d},
     {0x4d, 0x73, 0x67},
     true},

    // Comment: pseudorandom signature
    // tcID: 362
    {SEC_OID_SHA256,
     362,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xa8, 0xea, 0x15, 0x0c, 0xb8, 0x01, 0x25,
      0xd7, 0x38, 0x1c, 0x4c, 0x1f, 0x1d, 0xa8, 0xe9, 0xde, 0x27, 0x11, 0xf9,
      0x91, 0x70, 0x60, 0x40, 0x6a, 0x73, 0xd7, 0x90, 0x45, 0x19, 0xe5, 0x13,
      0x88, 0x02, 0x21, 0x00, 0xf3, 0xab, 0x9f, 0xa6, 0x8b, 0xd4, 0x79, 0x73,
      0xa7, 0x3b, 0x2d, 0x40, 0x48, 0x0c, 0x2b, 0xa5, 0x0c, 0x22, 0xc9, 0xd7,
      0x6e, 0xc2, 0x17, 0x25, 0x72, 0x88, 0x29, 0x32, 0x85, 0x44, 0x9b, 0x86},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x04, 0xaa, 0xec, 0x73, 0x63, 0x57, 0x26, 0xf2, 0x13,
      0xfb, 0x8a, 0x9e, 0x64, 0xda, 0x3b, 0x86, 0x32, 0xe4, 0x14, 0x95, 0xa9,
      0x44, 0xd0, 0x04, 0x5b, 0x52, 0x2e, 0xba, 0x72, 0x40, 0xfa, 0xd5, 0x87,
      0xd9, 0x31, 0x57, 0x98, 0xaa, 0xa3, 0xa5, 0xba, 0x01, 0x77, 0x57, 0x87,
      0xce, 0xd0, 0x5e, 0xaa, 0xf7, 0xb4, 0xe0, 0x9f, 0xc8, 0x1d, 0x6d, 0x1a,
      0xa5, 0x46, 0xe8, 0x36, 0x5d, 0x52, 0x5d},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: pseudorandom signature
    // tcID: 363
    {SEC_OID_SHA256,
     363,
     {0x30, 0x45, 0x02, 0x21, 0x00, 0x98, 0x6e, 0x65, 0x93, 0x3e, 0xf2, 0xed,
      0x4e, 0xe5, 0xaa, 0xda, 0x13, 0x9f, 0x52, 0xb7, 0x05, 0x39, 0xaa, 0xf6,
      0x3f, 0x00, 0xa9, 0x1f, 0x29, 0xc6, 0x91, 0x78, 0x49, 0x0d, 0x57, 0xfb,
      0x71, 0x02, 0x20, 0x3d, 0xaf, 0xed, 0xfb, 0x8d, 0xa6, 0x18, 0x9d, 0x37,
      0x23, 0x08, 0xcb, 0xf1, 0x48, 0x9b, 0xbb, 0xda, 0xbf, 0x0c, 0x02, 0x17,
      0xd1, 0xc0, 0xff, 0x0f, 0x70, 0x1a, 0xaa, 0x7a, 0x69, 0x4b, 0x9c},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x04, 0xaa, 0xec, 0x73, 0x63, 0x57, 0x26, 0xf2, 0x13,
      0xfb, 0x8a, 0x9e, 0x64, 0xda, 0x3b, 0x86, 0x32, 0xe4, 0x14, 0x95, 0xa9,
      0x44, 0xd0, 0x04, 0x5b, 0x52, 0x2e, 0xba, 0x72, 0x40, 0xfa, 0xd5, 0x87,
      0xd9, 0x31, 0x57, 0x98, 0xaa, 0xa3, 0xa5, 0xba, 0x01, 0x77, 0x57, 0x87,
      0xce, 0xd0, 0x5e, 0xaa, 0xf7, 0xb4, 0xe0, 0x9f, 0xc8, 0x1d, 0x6d, 0x1a,
      0xa5, 0x46, 0xe8, 0x36, 0x5d, 0x52, 0x5d},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     true},

    // Comment: x-coordinate of the public key has many trailing 0's
    // tcID: 364
    {SEC_OID_SHA256,
     364,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xd4, 0x34, 0xe2, 0x62, 0xa4, 0x9e, 0xab,
      0x77, 0x81, 0xe3, 0x53, 0xa3, 0x56, 0x5e, 0x48, 0x25, 0x50, 0xdd, 0x0f,
      0xd5, 0xde, 0xfa, 0x01, 0x3c, 0x7f, 0x29, 0x74, 0x5e, 0xff, 0x35, 0x69,
      0xf1, 0x02, 0x21, 0x00, 0x9b, 0x0c, 0x0a, 0x93, 0xf2, 0x67, 0xfb, 0x60,
      0x52, 0xfd, 0x80, 0x77, 0xbe, 0x76, 0x9c, 0x2b, 0x98, 0x95, 0x31, 0x95,
      0xd7, 0xbc, 0x10, 0xde, 0x84, 0x42, 0x18, 0x30, 0x5c, 0x6b, 0xa1, 0x7a},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x4f, 0x33, 0x7c, 0xcf, 0xd6, 0x77, 0x26, 0xa8, 0x05,
      0xe4, 0xf1, 0x60, 0x0a, 0xe2, 0x84, 0x9d, 0xf3, 0x80, 0x7e, 0xca, 0x11,
      0x73, 0x80, 0x23, 0x9f, 0xbd, 0x81, 0x69, 0x00, 0x00, 0x00, 0x00, 0xed,
      0x9d, 0xea, 0x12, 0x4c, 0xc8, 0xc3, 0x96, 0x41, 0x64, 0x11, 0xe9, 0x88,
      0xc3, 0x0f, 0x42, 0x7e, 0xb5, 0x04, 0xaf, 0x43, 0xa3, 0x14, 0x6c, 0xd5,
      0xdf, 0x7e, 0xa6, 0x06, 0x66, 0xd6, 0x85},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key has many trailing 0's
    // tcID: 365
    {SEC_OID_SHA256,
     365,
     {0x30, 0x44, 0x02, 0x20, 0x0f, 0xe7, 0x74, 0x35, 0x5c, 0x04, 0xd0, 0x60,
      0xf7, 0x6d, 0x79, 0xfd, 0x7a, 0x77, 0x2e, 0x42, 0x14, 0x63, 0x48, 0x92,
      0x21, 0xbf, 0x0a, 0x33, 0xad, 0xd0, 0xbe, 0x9b, 0x19, 0x79, 0x11, 0x0b,
      0x02, 0x20, 0x50, 0x0d, 0xcb, 0xa1, 0xc6, 0x9a, 0x8f, 0xbd, 0x43, 0xfa,
      0x4f, 0x57, 0xf7, 0x43, 0xce, 0x12, 0x4c, 0xa8, 0xb9, 0x1a, 0x1f, 0x32,
      0x5f, 0x3f, 0xac, 0x61, 0x81, 0x17, 0x5d, 0xf5, 0x57, 0x37},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x4f, 0x33, 0x7c, 0xcf, 0xd6, 0x77, 0x26, 0xa8, 0x05,
      0xe4, 0xf1, 0x60, 0x0a, 0xe2, 0x84, 0x9d, 0xf3, 0x80, 0x7e, 0xca, 0x11,
      0x73, 0x80, 0x23, 0x9f, 0xbd, 0x81, 0x69, 0x00, 0x00, 0x00, 0x00, 0xed,
      0x9d, 0xea, 0x12, 0x4c, 0xc8, 0xc3, 0x96, 0x41, 0x64, 0x11, 0xe9, 0x88,
      0xc3, 0x0f, 0x42, 0x7e, 0xb5, 0x04, 0xaf, 0x43, 0xa3, 0x14, 0x6c, 0xd5,
      0xdf, 0x7e, 0xa6, 0x06, 0x66, 0xd6, 0x85},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key has many trailing 0's
    // tcID: 366
    {SEC_OID_SHA256,
     366,
     {0x30, 0x45, 0x02, 0x21, 0x00, 0xbb, 0x40, 0xbf, 0x21, 0x7b, 0xed, 0x3f,
      0xb3, 0x95, 0x0c, 0x7d, 0x39, 0xf0, 0x3d, 0x36, 0xdc, 0x8e, 0x3b, 0x2c,
      0xd7, 0x96, 0x93, 0xf1, 0x25, 0xbf, 0xd0, 0x65, 0x95, 0xee, 0x11, 0x35,
      0xe3, 0x02, 0x20, 0x54, 0x1b, 0xf3, 0x53, 0x23, 0x51, 0xeb, 0xb0, 0x32,
      0x71, 0x0b, 0xdb, 0x6a, 0x1b, 0xf1, 0xbf, 0xc8, 0x9a, 0x1e, 0x29, 0x1a,
      0xc6, 0x92, 0xb3, 0xfa, 0x47, 0x80, 0x74, 0x5b, 0xb5, 0x56, 0x77},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x4f, 0x33, 0x7c, 0xcf, 0xd6, 0x77, 0x26, 0xa8, 0x05,
      0xe4, 0xf1, 0x60, 0x0a, 0xe2, 0x84, 0x9d, 0xf3, 0x80, 0x7e, 0xca, 0x11,
      0x73, 0x80, 0x23, 0x9f, 0xbd, 0x81, 0x69, 0x00, 0x00, 0x00, 0x00, 0xed,
      0x9d, 0xea, 0x12, 0x4c, 0xc8, 0xc3, 0x96, 0x41, 0x64, 0x11, 0xe9, 0x88,
      0xc3, 0x0f, 0x42, 0x7e, 0xb5, 0x04, 0xaf, 0x43, 0xa3, 0x14, 0x6c, 0xd5,
      0xdf, 0x7e, 0xa6, 0x06, 0x66, 0xd6, 0x85},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key has many trailing 0's
    // tcID: 367
    {SEC_OID_SHA256,
     367,
     {0x30, 0x44, 0x02, 0x20, 0x66, 0x4e, 0xb7, 0xee, 0x6d, 0xb8, 0x4a, 0x34,
      0xdf, 0x3c, 0x86, 0xea, 0x31, 0x38, 0x9a, 0x54, 0x05, 0xba, 0xdd, 0x5c,
      0xa9, 0x92, 0x31, 0xff, 0x55, 0x6d, 0x3e, 0x75, 0xa2, 0x33, 0xe7, 0x3a,
      0x02, 0x20, 0x59, 0xf3, 0xc7, 0x52, 0xe5, 0x2e, 0xca, 0x46, 0x13, 0x76,
      0x42, 0x49, 0x0a, 0x51, 0x56, 0x0c, 0xe0, 0xba, 0xdc, 0x67, 0x87, 0x54,
      0xb8, 0xf7, 0x2e, 0x51, 0xa2, 0x90, 0x14, 0x26, 0xa1, 0xbd},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x3c, 0xf0, 0x3d, 0x61, 0x4d, 0x89, 0x39, 0xcf, 0xd4,
      0x99, 0xa0, 0x78, 0x73, 0xfa, 0xc2, 0x81, 0x61, 0x8f, 0x06, 0xb8, 0xff,
      0x87, 0xe8, 0x01, 0x5c, 0x3f, 0x49, 0x72, 0x65, 0x00, 0x49, 0x35, 0x84,
      0xfa, 0x17, 0x4d, 0x79, 0x1c, 0x72, 0xbf, 0x2c, 0xe3, 0x88, 0x0a, 0x89,
      0x60, 0xdd, 0x2a, 0x7c, 0x7a, 0x13, 0x38, 0xa8, 0x2f, 0x85, 0xa9, 0xe5,
      0x9c, 0xdb, 0xde, 0x80, 0x00, 0x00, 0x00},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key has many trailing 0's
    // tcID: 368
    {SEC_OID_SHA256,
     368,
     {0x30, 0x45, 0x02, 0x20, 0x4c, 0xd0, 0x42, 0x9b, 0xba, 0xbd, 0x28, 0x27,
      0x00, 0x9d, 0x6f, 0xcd, 0x84, 0x3d, 0x4c, 0xe3, 0x9c, 0x3e, 0x42, 0xe2,
      0xd1, 0x63, 0x1f, 0xd0, 0x01, 0x98, 0x5a, 0x79, 0xd1, 0xfd, 0x8b, 0x43,
      0x02, 0x21, 0x00, 0x96, 0x38, 0xbf, 0x12, 0xdd, 0x68, 0x2f, 0x60, 0xbe,
      0x7e, 0xf1, 0xd0, 0xe0, 0xd9, 0x8f, 0x08, 0xb7, 0xbc, 0xa7, 0x7a, 0x1a,
      0x2b, 0x86, 0x9a, 0xe4, 0x66, 0x18, 0x9d, 0x2a, 0xcd, 0xab, 0xe3},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x3c, 0xf0, 0x3d, 0x61, 0x4d, 0x89, 0x39, 0xcf, 0xd4,
      0x99, 0xa0, 0x78, 0x73, 0xfa, 0xc2, 0x81, 0x61, 0x8f, 0x06, 0xb8, 0xff,
      0x87, 0xe8, 0x01, 0x5c, 0x3f, 0x49, 0x72, 0x65, 0x00, 0x49, 0x35, 0x84,
      0xfa, 0x17, 0x4d, 0x79, 0x1c, 0x72, 0xbf, 0x2c, 0xe3, 0x88, 0x0a, 0x89,
      0x60, 0xdd, 0x2a, 0x7c, 0x7a, 0x13, 0x38, 0xa8, 0x2f, 0x85, 0xa9, 0xe5,
      0x9c, 0xdb, 0xde, 0x80, 0x00, 0x00, 0x00},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key has many trailing 0's
    // tcID: 369
    {SEC_OID_SHA256,
     369,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xe5, 0x6c, 0x6e, 0xa2, 0xd1, 0xb0, 0x17,
      0x09, 0x1c, 0x44, 0xd8, 0xb6, 0xcb, 0x62, 0xb9, 0xf4, 0x60, 0xe3, 0xce,
      0x9a, 0xed, 0x5e, 0x5f, 0xd4, 0x1e, 0x8a, 0xdd, 0xed, 0x97, 0xc5, 0x6c,
      0x04, 0x02, 0x21, 0x00, 0xa3, 0x08, 0xec, 0x31, 0xf2, 0x81, 0xe9, 0x55,
      0xbe, 0x20, 0xb4, 0x57, 0xe4, 0x63, 0x44, 0x0b, 0x4f, 0xcf, 0x2b, 0x80,
      0x25, 0x80, 0x78, 0x20, 0x7f, 0xc1, 0x37, 0x81, 0x80, 0xf8, 0x9b, 0x55},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x3c, 0xf0, 0x3d, 0x61, 0x4d, 0x89, 0x39, 0xcf, 0xd4,
      0x99, 0xa0, 0x78, 0x73, 0xfa, 0xc2, 0x81, 0x61, 0x8f, 0x06, 0xb8, 0xff,
      0x87, 0xe8, 0x01, 0x5c, 0x3f, 0x49, 0x72, 0x65, 0x00, 0x49, 0x35, 0x84,
      0xfa, 0x17, 0x4d, 0x79, 0x1c, 0x72, 0xbf, 0x2c, 0xe3, 0x88, 0x0a, 0x89,
      0x60, 0xdd, 0x2a, 0x7c, 0x7a, 0x13, 0x38, 0xa8, 0x2f, 0x85, 0xa9, 0xe5,
      0x9c, 0xdb, 0xde, 0x80, 0x00, 0x00, 0x00},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key has many trailing 1's
    // tcID: 370
    {SEC_OID_SHA256,
     370,
     {0x30, 0x44, 0x02, 0x20, 0x11, 0x58, 0xa0, 0x8d, 0x29, 0x15, 0x00, 0xb4,
      0xca, 0xbe, 0xd3, 0x34, 0x6d, 0x89, 0x1e, 0xee, 0x57, 0xc1, 0x76, 0x35,
      0x6a, 0x26, 0x24, 0xfb, 0x01, 0x1f, 0x8f, 0xbb, 0xf3, 0x46, 0x68, 0x30,
      0x02, 0x20, 0x22, 0x8a, 0x8c, 0x48, 0x6a, 0x73, 0x60, 0x06, 0xe0, 0x82,
      0x32, 0x5b, 0x85, 0x29, 0x0c, 0x5b, 0xc9, 0x1f, 0x37, 0x8b, 0x75, 0xd4,
      0x87, 0xdd, 0xa4, 0x67, 0x98, 0xc1, 0x8f, 0x28, 0x55, 0x19},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x3c, 0xf0, 0x3d, 0x61, 0x4d, 0x89, 0x39, 0xcf, 0xd4,
      0x99, 0xa0, 0x78, 0x73, 0xfa, 0xc2, 0x81, 0x61, 0x8f, 0x06, 0xb8, 0xff,
      0x87, 0xe8, 0x01, 0x5c, 0x3f, 0x49, 0x72, 0x65, 0x00, 0x49, 0x35, 0x7b,
      0x05, 0xe8, 0xb1, 0x86, 0xe3, 0x8d, 0x41, 0xd3, 0x1c, 0x77, 0xf5, 0x76,
      0x9f, 0x22, 0xd5, 0x83, 0x85, 0xec, 0xc8, 0x57, 0xd0, 0x7a, 0x56, 0x1a,
      0x63, 0x24, 0x21, 0x7f, 0xff, 0xff, 0xff},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key has many trailing 1's
    // tcID: 371
    {SEC_OID_SHA256,
     371,
     {0x30, 0x45, 0x02, 0x21, 0x00, 0xb1, 0xdb, 0x92, 0x89, 0x64, 0x9f, 0x59,
      0x41, 0x0e, 0xa3, 0x6b, 0x0c, 0x0f, 0xc8, 0xd6, 0xaa, 0x26, 0x87, 0xb2,
      0x91, 0x76, 0x93, 0x9d, 0xd2, 0x3e, 0x0d, 0xde, 0x56, 0xd3, 0x09, 0xfa,
      0x9d, 0x02, 0x20, 0x3e, 0x15, 0x35, 0xe4, 0x28, 0x05, 0x59, 0x01, 0x5b,
      0x0d, 0xbd, 0x98, 0x73, 0x66, 0xdc, 0xf4, 0x3a, 0x6d, 0x1a, 0xf5, 0xc2,
      0x3c, 0x7d, 0x58, 0x4e, 0x1c, 0x3f, 0x48, 0xa1, 0x25, 0x13, 0x36},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x3c, 0xf0, 0x3d, 0x61, 0x4d, 0x89, 0x39, 0xcf, 0xd4,
      0x99, 0xa0, 0x78, 0x73, 0xfa, 0xc2, 0x81, 0x61, 0x8f, 0x06, 0xb8, 0xff,
      0x87, 0xe8, 0x01, 0x5c, 0x3f, 0x49, 0x72, 0x65, 0x00, 0x49, 0x35, 0x7b,
      0x05, 0xe8, 0xb1, 0x86, 0xe3, 0x8d, 0x41, 0xd3, 0x1c, 0x77, 0xf5, 0x76,
      0x9f, 0x22, 0xd5, 0x83, 0x85, 0xec, 0xc8, 0x57, 0xd0, 0x7a, 0x56, 0x1a,
      0x63, 0x24, 0x21, 0x7f, 0xff, 0xff, 0xff},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key has many trailing 1's
    // tcID: 372
    {SEC_OID_SHA256,
     372,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xb7, 0xb1, 0x6e, 0x76, 0x22, 0x86, 0xcb,
      0x96, 0x44, 0x6a, 0xa8, 0xd4, 0xe6, 0xe7, 0x57, 0x8b, 0x0a, 0x34, 0x1a,
      0x79, 0xf2, 0xdd, 0x1a, 0x22, 0x0a, 0xc6, 0xf0, 0xca, 0x4e, 0x24, 0xed,
      0x86, 0x02, 0x21, 0x00, 0xdd, 0xc6, 0x0a, 0x70, 0x0a, 0x13, 0x9b, 0x04,
      0x66, 0x1c, 0x54, 0x7d, 0x07, 0xbb, 0xb0, 0x72, 0x17, 0x80, 0x14, 0x6d,
      0xf7, 0x99, 0xcc, 0xf5, 0x5e, 0x55, 0x23, 0x4e, 0xcb, 0x8f, 0x12, 0xbc},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x3c, 0xf0, 0x3d, 0x61, 0x4d, 0x89, 0x39, 0xcf, 0xd4,
      0x99, 0xa0, 0x78, 0x73, 0xfa, 0xc2, 0x81, 0x61, 0x8f, 0x06, 0xb8, 0xff,
      0x87, 0xe8, 0x01, 0x5c, 0x3f, 0x49, 0x72, 0x65, 0x00, 0x49, 0x35, 0x7b,
      0x05, 0xe8, 0xb1, 0x86, 0xe3, 0x8d, 0x41, 0xd3, 0x1c, 0x77, 0xf5, 0x76,
      0x9f, 0x22, 0xd5, 0x83, 0x85, 0xec, 0xc8, 0x57, 0xd0, 0x7a, 0x56, 0x1a,
      0x63, 0x24, 0x21, 0x7f, 0xff, 0xff, 0xff},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key has many trailing 1's
    // tcID: 373
    {SEC_OID_SHA256,
     373,
     {0x30, 0x45, 0x02, 0x21, 0x00, 0xd8, 0x2a, 0x7c, 0x27, 0x17, 0x26, 0x11,
      0x87, 0xc8, 0xe0, 0x0d, 0x8d, 0xf9, 0x63, 0xff, 0x35, 0xd7, 0x96, 0xed,
      0xad, 0x36, 0xbc, 0x6e, 0x6b, 0xd1, 0xc9, 0x1c, 0x67, 0x0d, 0x91, 0x05,
      0xb4, 0x02, 0x20, 0x3d, 0xca, 0xbd, 0xda, 0xf8, 0xfc, 0xaa, 0x61, 0xf4,
      0x60, 0x3e, 0x7c, 0xba, 0xc0, 0xf3, 0xc0, 0x35, 0x1e, 0xcd, 0x59, 0x88,
      0xef, 0xb2, 0x3f, 0x68, 0x0d, 0x07, 0xde, 0xbd, 0x13, 0x99, 0x29},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x28, 0x29, 0xc3, 0x1f, 0xaa, 0x2e, 0x40, 0x0e, 0x34,
      0x4e, 0xd9, 0x4b, 0xca, 0x3f, 0xcd, 0x05, 0x45, 0x95, 0x6e, 0xbc, 0xfe,
      0x8a, 0xd0, 0xf6, 0xdf, 0xa5, 0xff, 0x8e, 0xff, 0xff, 0xff, 0xff, 0xa0,
      0x1a, 0xaf, 0xaf, 0x00, 0x0e, 0x52, 0x58, 0x58, 0x55, 0xaf, 0xa7, 0x67,
      0x6a, 0xde, 0x28, 0x41, 0x13, 0x09, 0x90, 0x52, 0xdf, 0x57, 0xe7, 0xeb,
      0x3b, 0xd3, 0x7e, 0xbe, 0xb9, 0x22, 0x2e},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key has many trailing 1's
    // tcID: 374
    {SEC_OID_SHA256,
     374,
     {0x30, 0x44, 0x02, 0x20, 0x5e, 0xb9, 0xc8, 0x84, 0x5d, 0xe6, 0x8e, 0xb1,
      0x3d, 0x5b, 0xef, 0xe7, 0x19, 0xf4, 0x62, 0xd7, 0x77, 0x87, 0x80, 0x2b,
      0xaf, 0xf3, 0x0c, 0xe9, 0x6a, 0x5c, 0xba, 0x06, 0x32, 0x54, 0xaf, 0x78,
      0x02, 0x20, 0x2c, 0x02, 0x6a, 0xe9, 0xbe, 0x2e, 0x2a, 0x5e, 0x7c, 0xa0,
      0xff, 0x9b, 0xbd, 0x92, 0xfb, 0x6e, 0x44, 0x97, 0x21, 0x86, 0x22, 0x8e,
      0xe9, 0xa6, 0x2b, 0x87, 0xdd, 0xbe, 0x2e, 0xf6, 0x6f, 0xb5},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x28, 0x29, 0xc3, 0x1f, 0xaa, 0x2e, 0x40, 0x0e, 0x34,
      0x4e, 0xd9, 0x4b, 0xca, 0x3f, 0xcd, 0x05, 0x45, 0x95, 0x6e, 0xbc, 0xfe,
      0x8a, 0xd0, 0xf6, 0xdf, 0xa5, 0xff, 0x8e, 0xff, 0xff, 0xff, 0xff, 0xa0,
      0x1a, 0xaf, 0xaf, 0x00, 0x0e, 0x52, 0x58, 0x58, 0x55, 0xaf, 0xa7, 0x67,
      0x6a, 0xde, 0x28, 0x41, 0x13, 0x09, 0x90, 0x52, 0xdf, 0x57, 0xe7, 0xeb,
      0x3b, 0xd3, 0x7e, 0xbe, 0xb9, 0x22, 0x2e},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key has many trailing 1's
    // tcID: 375
    {SEC_OID_SHA256,
     375,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0x96, 0x84, 0x3d, 0xd0, 0x3c, 0x22, 0xab,
      0xd2, 0xf3, 0xb7, 0x82, 0xb1, 0x70, 0x23, 0x9f, 0x90, 0xf2, 0x77, 0x92,
      0x1b, 0xec, 0xc1, 0x17, 0xd0, 0x40, 0x4a, 0x8e, 0x4e, 0x36, 0x23, 0x0c,
      0x28, 0x02, 0x21, 0x00, 0xf2, 0xbe, 0x37, 0x8f, 0x52, 0x6f, 0x74, 0xa5,
      0x43, 0xf6, 0x71, 0x65, 0x97, 0x6d, 0xe9, 0xed, 0x9a, 0x31, 0x21, 0x4e,
      0xb4, 0xd7, 0xe6, 0xdb, 0x19, 0xe1, 0xed, 0xe1, 0x23, 0xdd, 0x99, 0x1d},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x28, 0x29, 0xc3, 0x1f, 0xaa, 0x2e, 0x40, 0x0e, 0x34,
      0x4e, 0xd9, 0x4b, 0xca, 0x3f, 0xcd, 0x05, 0x45, 0x95, 0x6e, 0xbc, 0xfe,
      0x8a, 0xd0, 0xf6, 0xdf, 0xa5, 0xff, 0x8e, 0xff, 0xff, 0xff, 0xff, 0xa0,
      0x1a, 0xaf, 0xaf, 0x00, 0x0e, 0x52, 0x58, 0x58, 0x55, 0xaf, 0xa7, 0x67,
      0x6a, 0xde, 0x28, 0x41, 0x13, 0x09, 0x90, 0x52, 0xdf, 0x57, 0xe7, 0xeb,
      0x3b, 0xd3, 0x7e, 0xbe, 0xb9, 0x22, 0x2e},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key is large
    // tcID: 376
    {SEC_OID_SHA256,
     376,
     {0x30, 0x44, 0x02, 0x20, 0x76, 0x64, 0x56, 0xdc, 0xe1, 0x85, 0x7c, 0x90,
      0x6f, 0x99, 0x96, 0xaf, 0x72, 0x93, 0x39, 0x46, 0x4d, 0x27, 0xe9, 0xd9,
      0x8e, 0xdc, 0x2d, 0x0e, 0x3b, 0x76, 0x02, 0x97, 0x06, 0x74, 0x21, 0xf6,
      0x02, 0x20, 0x40, 0x23, 0x85, 0xec, 0xad, 0xae, 0x0d, 0x80, 0x81, 0xdc,
      0xca, 0xf5, 0xd1, 0x90, 0x37, 0xec, 0x4e, 0x55, 0x37, 0x6e, 0xce, 0xd6,
      0x99, 0xe9, 0x36, 0x46, 0xbf, 0xbb, 0xf1, 0x9d, 0x0b, 0x41},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xff, 0xff, 0xff, 0xf9, 0x48, 0x08, 0x1e, 0x6a, 0x04,
      0x58, 0xdd, 0x8f, 0x9e, 0x73, 0x8f, 0x26, 0x65, 0xff, 0x90, 0x59, 0xad,
      0x6a, 0xac, 0x07, 0x08, 0x31, 0x8c, 0x4c, 0xa9, 0xa7, 0xa4, 0xf5, 0x5a,
      0x8a, 0xbc, 0xba, 0x2d, 0xda, 0x84, 0x74, 0x31, 0x1e, 0xe5, 0x41, 0x49,
      0xb9, 0x73, 0xca, 0xe0, 0xc0, 0xfb, 0x89, 0x55, 0x7a, 0xd0, 0xbf, 0x78,
      0xe6, 0x52, 0x9a, 0x16, 0x63, 0xbd, 0x73},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key is large
    // tcID: 377
    {SEC_OID_SHA256,
     377,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xc6, 0x05, 0xc4, 0xb2, 0xed, 0xea, 0xb2,
      0x04, 0x19, 0xe6, 0x51, 0x8a, 0x11, 0xb2, 0xdb, 0xc2, 0xb9, 0x7e, 0xd8,
      0xb0, 0x7c, 0xce, 0xd0, 0xb1, 0x9c, 0x34, 0xf7, 0x77, 0xde, 0x7b, 0x9f,
      0xd9, 0x02, 0x21, 0x00, 0xed, 0xf0, 0xf6, 0x12, 0xc5, 0xf4, 0x6e, 0x03,
      0xc7, 0x19, 0x64, 0x7b, 0xc8, 0xaf, 0x1b, 0x29, 0xb2, 0xcd, 0xe2, 0xed,
      0xa7, 0x00, 0xfb, 0x1c, 0xff, 0x5e, 0x15, 0x9d, 0x47, 0x32, 0x6d, 0xba},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xff, 0xff, 0xff, 0xf9, 0x48, 0x08, 0x1e, 0x6a, 0x04,
      0x58, 0xdd, 0x8f, 0x9e, 0x73, 0x8f, 0x26, 0x65, 0xff, 0x90, 0x59, 0xad,
      0x6a, 0xac, 0x07, 0x08, 0x31, 0x8c, 0x4c, 0xa9, 0xa7, 0xa4, 0xf5, 0x5a,
      0x8a, 0xbc, 0xba, 0x2d, 0xda, 0x84, 0x74, 0x31, 0x1e, 0xe5, 0x41, 0x49,
      0xb9, 0x73, 0xca, 0xe0, 0xc0, 0xfb, 0x89, 0x55, 0x7a, 0xd0, 0xbf, 0x78,
      0xe6, 0x52, 0x9a, 0x16, 0x63, 0xbd, 0x73},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key is large
    // tcID: 378
    {SEC_OID_SHA256,
     378,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xd4, 0x8b, 0x68, 0xe6, 0xca, 0xbf, 0xe0,
      0x3c, 0xf6, 0x14, 0x1c, 0x9a, 0xc5, 0x41, 0x41, 0xf2, 0x10, 0xe6, 0x44,
      0x85, 0xd9, 0x92, 0x9a, 0xd7, 0xb7, 0x32, 0xbf, 0xe3, 0xb7, 0xeb, 0x8a,
      0x84, 0x02, 0x21, 0x00, 0xfe, 0xed, 0xae, 0x50, 0xc6, 0x1b, 0xd0, 0x0e,
      0x19, 0xdc, 0x26, 0xf9, 0xb7, 0xe2, 0x26, 0x5e, 0x45, 0x08, 0xc3, 0x89,
      0x10, 0x9a, 0xd2, 0xf2, 0x08, 0xf0, 0x77, 0x23, 0x15, 0xb6, 0xc9, 0x41},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xff, 0xff, 0xff, 0xf9, 0x48, 0x08, 0x1e, 0x6a, 0x04,
      0x58, 0xdd, 0x8f, 0x9e, 0x73, 0x8f, 0x26, 0x65, 0xff, 0x90, 0x59, 0xad,
      0x6a, 0xac, 0x07, 0x08, 0x31, 0x8c, 0x4c, 0xa9, 0xa7, 0xa4, 0xf5, 0x5a,
      0x8a, 0xbc, 0xba, 0x2d, 0xda, 0x84, 0x74, 0x31, 0x1e, 0xe5, 0x41, 0x49,
      0xb9, 0x73, 0xca, 0xe0, 0xc0, 0xfb, 0x89, 0x55, 0x7a, 0xd0, 0xbf, 0x78,
      0xe6, 0x52, 0x9a, 0x16, 0x63, 0xbd, 0x73},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key is small
    // tcID: 379
    {SEC_OID_SHA256,
     379,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xb7, 0xc8, 0x14, 0x57, 0xd4, 0xae, 0xb6,
      0xaa, 0x65, 0x95, 0x70, 0x98, 0x56, 0x9f, 0x04, 0x79, 0x71, 0x0a, 0xd7,
      0xf6, 0x59, 0x5d, 0x58, 0x74, 0xc3, 0x5a, 0x93, 0xd1, 0x2a, 0x5d, 0xd4,
      0xc7, 0x02, 0x21, 0x00, 0xb7, 0x96, 0x1a, 0x0b, 0x65, 0x28, 0x78, 0xc2,
      0xd5, 0x68, 0x06, 0x9a, 0x43, 0x2c, 0xa1, 0x8a, 0x1a, 0x91, 0x99, 0xf2,
      0xca, 0x57, 0x4d, 0xad, 0x4b, 0x9e, 0x3a, 0x05, 0xc0, 0xa1, 0xcd, 0xb3},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x03, 0xfa, 0x15, 0xf9, 0x63, 0x94,
      0x9d, 0x5f, 0x03, 0xa6, 0xf5, 0xc7, 0xf8, 0x6f, 0x9e, 0x00, 0x15, 0xee,
      0xb2, 0x3a, 0xeb, 0xbf, 0xf1, 0x17, 0x39, 0x37, 0xba, 0x74, 0x8e, 0x10,
      0x99, 0x87, 0x20, 0x70, 0xe8, 0xe8, 0x7c, 0x55, 0x5f, 0xa1, 0x36, 0x59,
      0xcc, 0xa5, 0xd7, 0xfa, 0xdc, 0xfc, 0xb0, 0x02, 0x3e, 0xa8, 0x89, 0x54,
      0x8c, 0xa4, 0x8a, 0xf2, 0xba, 0x7e, 0x71},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key is small
    // tcID: 380
    {SEC_OID_SHA256,
     380,
     {0x30, 0x44, 0x02, 0x20, 0x6b, 0x01, 0x33, 0x2d, 0xdb, 0x6e, 0xdf, 0xa9,
      0xa3, 0x0a, 0x13, 0x21, 0xd5, 0x85, 0x8e, 0x1e, 0xe3, 0xcf, 0x97, 0xe2,
      0x63, 0xe6, 0x69, 0xf8, 0xde, 0x5e, 0x96, 0x52, 0xe7, 0x6f, 0xf3, 0xf7,
      0x02, 0x20, 0x59, 0x39, 0x54, 0x5f, 0xce, 0xd4, 0x57, 0x30, 0x9a, 0x6a,
      0x04, 0xac, 0xe2, 0xbd, 0x0f, 0x70, 0x13, 0x9c, 0x8f, 0x7d, 0x86, 0xb0,
      0x2c, 0xb1, 0xcc, 0x58, 0xf9, 0xe6, 0x9e, 0x96, 0xcd, 0x5a},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x03, 0xfa, 0x15, 0xf9, 0x63, 0x94,
      0x9d, 0x5f, 0x03, 0xa6, 0xf5, 0xc7, 0xf8, 0x6f, 0x9e, 0x00, 0x15, 0xee,
      0xb2, 0x3a, 0xeb, 0xbf, 0xf1, 0x17, 0x39, 0x37, 0xba, 0x74, 0x8e, 0x10,
      0x99, 0x87, 0x20, 0x70, 0xe8, 0xe8, 0x7c, 0x55, 0x5f, 0xa1, 0x36, 0x59,
      0xcc, 0xa5, 0xd7, 0xfa, 0xdc, 0xfc, 0xb0, 0x02, 0x3e, 0xa8, 0x89, 0x54,
      0x8c, 0xa4, 0x8a, 0xf2, 0xba, 0x7e, 0x71},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key is small
    // tcID: 381
    {SEC_OID_SHA256,
     381,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xef, 0xdb, 0x88, 0x47, 0x20, 0xea, 0xea,
      0xdc, 0x34, 0x9f, 0x9f, 0xc3, 0x56, 0xb6, 0xc0, 0x34, 0x41, 0x01, 0xcd,
      0x2f, 0xd8, 0x43, 0x6b, 0x7d, 0x0e, 0x6a, 0x4f, 0xb9, 0x3f, 0x10, 0x63,
      0x61, 0x02, 0x21, 0x00, 0xf2, 0x4b, 0xee, 0x6a, 0xd5, 0xdc, 0x05, 0xf7,
      0x61, 0x39, 0x75, 0x47, 0x3a, 0xad, 0xf3, 0xaa, 0xcb, 0xa9, 0xe7, 0x7d,
      0xe7, 0xd6, 0x9b, 0x6c, 0xe4, 0x8c, 0xb6, 0x0d, 0x81, 0x13, 0x38, 0x5d},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x03, 0xfa, 0x15, 0xf9, 0x63, 0x94,
      0x9d, 0x5f, 0x03, 0xa6, 0xf5, 0xc7, 0xf8, 0x6f, 0x9e, 0x00, 0x15, 0xee,
      0xb2, 0x3a, 0xeb, 0xbf, 0xf1, 0x17, 0x39, 0x37, 0xba, 0x74, 0x8e, 0x10,
      0x99, 0x87, 0x20, 0x70, 0xe8, 0xe8, 0x7c, 0x55, 0x5f, 0xa1, 0x36, 0x59,
      0xcc, 0xa5, 0xd7, 0xfa, 0xdc, 0xfc, 0xb0, 0x02, 0x3e, 0xa8, 0x89, 0x54,
      0x8c, 0xa4, 0x8a, 0xf2, 0xba, 0x7e, 0x71},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key is small
    // tcID: 382
    {SEC_OID_SHA256,
     382,
     {0x30, 0x44, 0x02, 0x20, 0x31, 0x23, 0x04, 0x28, 0x40, 0x55, 0x60, 0xdc,
      0xb8, 0x8f, 0xb5, 0xa6, 0x46, 0x83, 0x6a, 0xea, 0x9b, 0x23, 0xa2, 0x3d,
      0xd9, 0x73, 0xdc, 0xbe, 0x80, 0x14, 0xc8, 0x7b, 0x8b, 0x20, 0xeb, 0x07,
      0x02, 0x20, 0x0f, 0x93, 0x44, 0xd6, 0xe8, 0x12, 0xce, 0x16, 0x66, 0x46,
      0x74, 0x76, 0x94, 0xa4, 0x1b, 0x0a, 0xaf, 0x97, 0x37, 0x4e, 0x19, 0xf3,
      0xc5, 0xfb, 0x8b, 0xd7, 0xae, 0x3d, 0x9b, 0xd0, 0xbe, 0xff},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xbc, 0xbb, 0x29, 0x14, 0xc7, 0x9f, 0x04, 0x5e, 0xaa,
      0x6e, 0xcb, 0xbc, 0x61, 0x28, 0x16, 0xb3, 0xbe, 0x5d, 0x2d, 0x67, 0x96,
      0x70, 0x7d, 0x81, 0x25, 0xe9, 0xf8, 0x51, 0xc1, 0x8a, 0xf0, 0x15, 0x00,
      0x00, 0x00, 0x00, 0x13, 0x52, 0xbb, 0x4a, 0x0f, 0xa2, 0xea, 0x4c, 0xce,
      0xb9, 0xab, 0x63, 0xdd, 0x68, 0x4a, 0xde, 0x5a, 0x11, 0x27, 0xbc, 0xf3,
      0x00, 0xa6, 0x98, 0xa7, 0x19, 0x3b, 0xc2},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key is small
    // tcID: 383
    {SEC_OID_SHA256,
     383,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xca, 0xa7, 0x97, 0xda, 0x65, 0xb3, 0x20,
      0xab, 0x0d, 0x5c, 0x47, 0x0c, 0xda, 0x0b, 0x36, 0xb2, 0x94, 0x35, 0x9c,
      0x7d, 0xb9, 0x84, 0x1d, 0x67, 0x91, 0x74, 0xdb, 0x34, 0xc4, 0x85, 0x57,
      0x43, 0x02, 0x21, 0x00, 0xcf, 0x54, 0x3a, 0x62, 0xf2, 0x3e, 0x21, 0x27,
      0x45, 0x39, 0x1a, 0xaf, 0x75, 0x05, 0xf3, 0x45, 0x12, 0x3d, 0x26, 0x85,
      0xee, 0x3b, 0x94, 0x1d, 0x3d, 0xe6, 0xd9, 0xb3, 0x62, 0x42, 0xe5, 0xa0},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xbc, 0xbb, 0x29, 0x14, 0xc7, 0x9f, 0x04, 0x5e, 0xaa,
      0x6e, 0xcb, 0xbc, 0x61, 0x28, 0x16, 0xb3, 0xbe, 0x5d, 0x2d, 0x67, 0x96,
      0x70, 0x7d, 0x81, 0x25, 0xe9, 0xf8, 0x51, 0xc1, 0x8a, 0xf0, 0x15, 0x00,
      0x00, 0x00, 0x00, 0x13, 0x52, 0xbb, 0x4a, 0x0f, 0xa2, 0xea, 0x4c, 0xce,
      0xb9, 0xab, 0x63, 0xdd, 0x68, 0x4a, 0xde, 0x5a, 0x11, 0x27, 0xbc, 0xf3,
      0x00, 0xa6, 0x98, 0xa7, 0x19, 0x3b, 0xc2},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key is small
    // tcID: 384
    {SEC_OID_SHA256,
     384,
     {0x30, 0x45, 0x02, 0x20, 0x7e, 0x5f, 0x0a, 0xb5, 0xd9, 0x00, 0xd3, 0xd3,
      0xd7, 0x86, 0x76, 0x57, 0xe5, 0xd6, 0xd3, 0x65, 0x19, 0xbc, 0x54, 0x08,
      0x45, 0x36, 0xe7, 0xd2, 0x1c, 0x33, 0x6e, 0xd8, 0x00, 0x18, 0x59, 0x45,
      0x02, 0x21, 0x00, 0x94, 0x50, 0xc0, 0x7f, 0x20, 0x1f, 0xae, 0xc9, 0x4b,
      0x82, 0xdf, 0xb3, 0x22, 0xe5, 0xac, 0x67, 0x66, 0x88, 0x29, 0x4a, 0xad,
      0x35, 0xaa, 0x72, 0xe7, 0x27, 0xff, 0x0b, 0x19, 0xb6, 0x46, 0xaa},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xbc, 0xbb, 0x29, 0x14, 0xc7, 0x9f, 0x04, 0x5e, 0xaa,
      0x6e, 0xcb, 0xbc, 0x61, 0x28, 0x16, 0xb3, 0xbe, 0x5d, 0x2d, 0x67, 0x96,
      0x70, 0x7d, 0x81, 0x25, 0xe9, 0xf8, 0x51, 0xc1, 0x8a, 0xf0, 0x15, 0x00,
      0x00, 0x00, 0x00, 0x13, 0x52, 0xbb, 0x4a, 0x0f, 0xa2, 0xea, 0x4c, 0xce,
      0xb9, 0xab, 0x63, 0xdd, 0x68, 0x4a, 0xde, 0x5a, 0x11, 0x27, 0xbc, 0xf3,
      0x00, 0xa6, 0x98, 0xa7, 0x19, 0x3b, 0xc2},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key is large
    // tcID: 385
    {SEC_OID_SHA256,
     385,
     {0x30, 0x46, 0x02, 0x21, 0x00, 0xd7, 0xd7, 0x0c, 0x58, 0x1a, 0xe9, 0xe3,
      0xf6, 0x6d, 0xc6, 0xa4, 0x80, 0xbf, 0x03, 0x7a, 0xe2, 0x3f, 0x8a, 0x1e,
      0x4a, 0x21, 0x36, 0xfe, 0x4b, 0x03, 0xaa, 0x69, 0xf0, 0xca, 0x25, 0xb3,
      0x56, 0x02, 0x21, 0x00, 0x89, 0xc4, 0x60, 0xf8, 0xa5, 0xa5, 0xc2, 0xbb,
      0xba, 0x96, 0x2c, 0x8a, 0x3e, 0xe8, 0x33, 0xa4, 0x13, 0xe8, 0x56, 0x58,
      0xe6, 0x2a, 0x59, 0xe2, 0xaf, 0x41, 0xd9, 0x12, 0x7c, 0xc4, 0x72, 0x24},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xbc, 0xbb, 0x29, 0x14, 0xc7, 0x9f, 0x04, 0x5e, 0xaa,
      0x6e, 0xcb, 0xbc, 0x61, 0x28, 0x16, 0xb3, 0xbe, 0x5d, 0x2d, 0x67, 0x96,
      0x70, 0x7d, 0x81, 0x25, 0xe9, 0xf8, 0x51, 0xc1, 0x8a, 0xf0, 0x15, 0xff,
      0xff, 0xff, 0xfe, 0xec, 0xad, 0x44, 0xb6, 0xf0, 0x5d, 0x15, 0xb3, 0x31,
      0x46, 0x54, 0x9c, 0x22, 0x97, 0xb5, 0x22, 0xa5, 0xee, 0xd8, 0x43, 0x0c,
      0xff, 0x59, 0x67, 0x58, 0xe6, 0xc4, 0x3d},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key is large
    // tcID: 386
    {SEC_OID_SHA256,
     386,
     {0x30, 0x44, 0x02, 0x20, 0x34, 0x1c, 0x1b, 0x9f, 0xf3, 0xc8, 0x3d, 0xd5,
      0xe0, 0xdf, 0xa0, 0xbf, 0x68, 0xbc, 0xdf, 0x4b, 0xb7, 0xaa, 0x20, 0xc6,
      0x25, 0x97, 0x5e, 0x5e, 0xee, 0xe3, 0x4b, 0xb3, 0x96, 0x26, 0x6b, 0x34,
      0x02, 0x20, 0x72, 0xb6, 0x9f, 0x06, 0x1b, 0x75, 0x0f, 0xd5, 0x12, 0x1b,
      0x22, 0xb1, 0x13, 0x66, 0xfa, 0xd5, 0x49, 0xc6, 0x34, 0xe7, 0x77, 0x65,
      0xa0, 0x17, 0x90, 0x2a, 0x67, 0x09, 0x9e, 0x0a, 0x44, 0x69},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xbc, 0xbb, 0x29, 0x14, 0xc7, 0x9f, 0x04, 0x5e, 0xaa,
      0x6e, 0xcb, 0xbc, 0x61, 0x28, 0x16, 0xb3, 0xbe, 0x5d, 0x2d, 0x67, 0x96,
      0x70, 0x7d, 0x81, 0x25, 0xe9, 0xf8, 0x51, 0xc1, 0x8a, 0xf0, 0x15, 0xff,
      0xff, 0xff, 0xfe, 0xec, 0xad, 0x44, 0xb6, 0xf0, 0x5d, 0x15, 0xb3, 0x31,
      0x46, 0x54, 0x9c, 0x22, 0x97, 0xb5, 0x22, 0xa5, 0xee, 0xd8, 0x43, 0x0c,
      0xff, 0x59, 0x67, 0x58, 0xe6, 0xc4, 0x3d},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key is large
    // tcID: 387
    {SEC_OID_SHA256,
     387,
     {0x30, 0x45, 0x02, 0x20, 0x70, 0xbe, 0xbe, 0x68, 0x4c, 0xdc, 0xb5, 0xca,
      0x72, 0xa4, 0x2f, 0x0d, 0x87, 0x38, 0x79, 0x35, 0x9b, 0xd1, 0x78, 0x1a,
      0x59, 0x18, 0x09, 0x94, 0x76, 0x28, 0xd3, 0x13, 0xa3, 0x81, 0x4f, 0x67,
      0x02, 0x21, 0x00, 0xae, 0xc0, 0x3a, 0xca, 0x8f, 0x55, 0x87, 0xa4, 0xd5,
      0x35, 0xfa, 0x31, 0x02, 0x7b, 0xbe, 0x9c, 0xc0, 0xe4, 0x64, 0xb1, 0xc3,
      0x57, 0x7f, 0x4c, 0x2d, 0xcd, 0xe6, 0xb2, 0x09, 0x47, 0x98, 0xa9},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xbc, 0xbb, 0x29, 0x14, 0xc7, 0x9f, 0x04, 0x5e, 0xaa,
      0x6e, 0xcb, 0xbc, 0x61, 0x28, 0x16, 0xb3, 0xbe, 0x5d, 0x2d, 0x67, 0x96,
      0x70, 0x7d, 0x81, 0x25, 0xe9, 0xf8, 0x51, 0xc1, 0x8a, 0xf0, 0x15, 0xff,
      0xff, 0xff, 0xfe, 0xec, 0xad, 0x44, 0xb6, 0xf0, 0x5d, 0x15, 0xb3, 0x31,
      0x46, 0x54, 0x9c, 0x22, 0x97, 0xb5, 0x22, 0xa5, 0xee, 0xd8, 0x43, 0x0c,
      0xff, 0x59, 0x67, 0x58, 0xe6, 0xc4, 0x3d},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true}};

#endif  // p256ecdsa_sha256_vectors_h__
