# Node.js 6 ChangeLog

<!--lint disable prohibited-strings-->
<!--lint disable maximum-line-length-->
<!--lint disable no-literal-urls-->

<table>
<tr>
<th>LTS 'Boron'</th>
<th title="Previously called 'Stable'">Current</th>
</tr>
<tr>
<td valign="top">
<a href="#6.17.1">6.17.1</a><br/>
<a href="#6.17.0">6.17.0</a><br/>
<a href="#6.16.0">6.16.0</a><br/>
<a href="#6.15.1">6.15.1</a><br/>
<a href="#6.15.0">6.15.0</a><br/>
<a href="#6.14.4">6.14.4</a><br/>
<a href="#6.14.3">6.14.3</a><br/>
<a href="#6.14.2">6.14.2</a><br/>
<a href="#6.14.1">6.14.1</a><br/>
<a href="#6.14.0">6.14.0</a><br/>
<a href="#6.13.1">6.13.1</a><br/>
<a href="#6.13.0">6.13.0</a><br/>
<a href="#6.12.3">6.12.3</a><br/>
<a href="#6.12.2">6.12.2</a><br/>
<a href="#6.12.1">6.12.1</a><br/>
<a href="#6.12.0">6.12.0</a><br/>
<a href="#6.11.5">6.11.5</a><br/>
<a href="#6.11.4">6.11.4</a><br/>
<a href="#6.11.3">6.11.3</a><br/>
<a href="#6.11.2">6.11.2</a><br/>
<a href="#6.11.1">6.11.1</a><br/>
<a href="#6.11.0">6.11.0</a><br/>
<a href="#6.10.3">6.10.3</a><br/>
<a href="#6.10.2">6.10.2</a><br/>
<a href="#6.10.1">6.10.1</a><br/>
<a href="#6.10.0">6.10.0</a><br/>
<a href="#6.9.5">6.9.5</a><br/>
<a href="#6.9.4">6.9.4</a><br/>
<a href="#6.9.3">6.9.3</a><br/>
<a href="#6.9.2">6.9.2</a><br/>
<a href="#6.9.1">6.9.1</a><br/>
<a href="#6.9.0">6.9.0</a><br/>
</td>
<td valign="top">
<a href="#6.8.1">6.8.1</a><br/>
<a href="#6.8.0">6.8.0</a><br/>
<a href="#6.7.0">6.7.0</a><br/>
<a href="#6.6.0">6.6.0</a><br/>
<a href="#6.5.0">6.5.0</a><br/>
<a href="#6.4.0">6.4.0</a><br/>
<a href="#6.3.1">6.3.1</a><br/>
<a href="#6.3.0">6.3.0</a><br/>
<a href="#6.2.2">6.2.2</a><br/>
<a href="#6.2.1">6.2.1</a><br/>
<a href="#6.2.0">6.2.0</a><br/>
<a href="#6.1.0">6.1.0</a><br/>
<a href="#6.0.0">6.0.0</a><br/>
</td>
</tr>
</table>

* Other Versions
  * [16.x](CHANGELOG_V16.md)
  * [15.x](CHANGELOG_V15.md)
  * [14.x](CHANGELOG_V14.md)
  * [13.x](CHANGELOG_V13.md)
  * [12.x](CHANGELOG_V12.md)
  * [11.x](CHANGELOG_V11.md)
  * [10.x](CHANGELOG_V10.md)
  * [9.x](CHANGELOG_V9.md)
  * [8.x](CHANGELOG_V8.md)
  * [7.x](CHANGELOG_V7.md)
  * [5.x](CHANGELOG_V5.md)
  * [4.x](CHANGELOG_V4.md)
  * [0.12.x](CHANGELOG_V012.md)
  * [0.10.x](CHANGELOG_V010.md)
  * [io.js](CHANGELOG_IOJS.md)
  * [Archive](CHANGELOG_ARCHIVE.md)

*Note*: Node.js v6 is covered by the
[Node.js Long Term Support Plan](https://github.com/nodejs/LTS) and
will be supported actively until April 2018 and maintained until April 2019.

<a id="6.17.1"></a>
## 2019-04-03, Version 6.17.1 'Boron' (LTS), @BethGriggs

Node 6 is due to go End-of-Life on 2019-04-30.

### Notable Changes

* **http**:
  * fix error check in `Execute()` (Brian White) [#25939](https://github.com/nodejs/node/pull/25939)

### Commits

* [[`c9d21a0c10`](https://github.com/nodejs/node/commit/c9d21a0c10)] - **build**: set `-blibpath:` for AIX (Richard Lau) [#25447](https://github.com/nodejs/node/pull/25447)
* [[`9ba5fd6bad`](https://github.com/nodejs/node/commit/9ba5fd6bad)] - **build**: only check REPLACEME & DEP...X for releases (Rod Vagg) [#24575](https://github.com/nodejs/node/pull/24575)
* [[`1371a6f88b`](https://github.com/nodejs/node/commit/1371a6f88b)] - **doc**: simplify CODE\_OF\_CONDUCT.md (Rich Trott) [#23989](https://github.com/nodejs/node/pull/23989)
* [[`ad62971573`](https://github.com/nodejs/node/commit/ad62971573)] - **doc**: document that addMembership must be called once in a cluster (James M Snell) [#23746](https://github.com/nodejs/node/pull/23746)
* [[`8080a9bf40`](https://github.com/nodejs/node/commit/8080a9bf40)] - **http**: fix error check in `Execute()` (Brian White) [#25939](https://github.com/nodejs/node/pull/25939)
* [[`aedc7120ea`](https://github.com/nodejs/node/commit/aedc7120ea)] - **src**: fix bootstrap\_node on bsd (sylkat) [#22663](https://github.com/nodejs/node/pull/22663)
* [[`b5d464955a`](https://github.com/nodejs/node/commit/b5d464955a)] - **test**: fix test-repl-envvars (Anna Henningsen) [#25226](https://github.com/nodejs/node/pull/25226)

<a id="6.17.0"></a>
## 2019-02-28, Version 6.17.0 'Boron' (LTS), @rvagg

This is a security release. All Node.js users should consult the security release summary at:

  https://nodejs.org/en/blog/vulnerability/february-2019-security-releases/

for details on patched vulnerabilities.

Fixes for the following CVEs are included in this release:

* Node.js: Denial of Service with keep-alive HTTP connections (CVE-2019-5739)
* Node.js: Slowloris HTTP Denial of Service with keep-alive (CVE-2019-5737)
* OpenSSL: 0-byte record padding oracle (CVE-2019-1559)

### Notable Changes

* **deps**: OpenSSL has been upgraded to 1.0.2r which contains a fix for [CVE-2019-1559](https://www.openssl.org/news/secadv/20190226.txt). Under certain circumstances, a TLS server can be forced to respond differently to a client if a zero-byte record is received with an invalid _padding_ compared to a zero-byte record with an invalid _MAC_. This can be used as the basis of a padding oracle attack to decrypt data.
* **http**:
  * Backport `server.keepAliveTimeout` to prevent keep-alive HTTP and HTTPS connections remaining open and inactive for an extended period of time, leading to a potential Denial of Service (DoS). (CVE-2019-5739 / [Timur Shemsedinov](https://github.com/tshemsedinov), [Matteo Collina](https://twitter.com/matteocollina))
  * Further prevention of "Slowloris" attacks on HTTP and HTTPS connections by consistently applying the receive timeout set by `server.headersTimeout` to connections in keep-alive mode. Reported by Marco Pracucci ([Voxnest](https://voxnest.com)). (CVE-2019-5737 / Matteo Collina)

### Commits

* [[`b282c68ce8`](https://github.com/nodejs/node/commit/b282c68ce8)] - **deps**: add -no\_rand\_screen to openssl s\_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`a80ef49dcf`](https://github.com/nodejs/node/commit/a80ef49dcf)] - **deps**: fix asm build error of openssl in x86\_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`1d3c412101`](https://github.com/nodejs/node/commit/1d3c412101)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`661fd61c3a`](https://github.com/nodejs/node/commit/661fd61c3a)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu)
* [[`da12284235`](https://github.com/nodejs/node/commit/da12284235)] - **deps**: upgrade openssl sources to 1.0.2r (Shigeki Ohtsu)
* [[`b13b4a9ffb`](https://github.com/nodejs/node/commit/b13b4a9ffb)] - **http**: prevent slowloris with keepalive connections (Matteo Collina) [nodejs-private/node-private#162](https://github.com/nodejs-private/node-private/pull/162)
* [[`e9ae4aaaad`](https://github.com/nodejs/node/commit/e9ae4aaaad)] - **http**: fix timeout reset after keep-alive timeout (Alexey Orlenko) [#13549](https://github.com/nodejs/node/pull/13549)
* [[`f23b3b6bad`](https://github.com/nodejs/node/commit/f23b3b6bad)] - **(SEMVER-MINOR)** **http**: destroy sockets after keepAliveTimeout (Timur Shemsedinov) [#2534](https://github.com/nodejs/node/pull/2534)
* [[`190894448b`](https://github.com/nodejs/node/commit/190894448b)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`06a208d316`](https://github.com/nodejs/node/commit/06a208d316)] - **test**: refactor test-http-server-keep-alive-timeout (realwakka) [#13448](https://github.com/nodejs/node/pull/13448)
* [[`1c7fbdc53b`](https://github.com/nodejs/node/commit/1c7fbdc53b)] - **test**: improve test-https-server-keep-alive-timeout (Rich Trott) [#13312](https://github.com/nodejs/node/pull/13312)

<a id="6.16.0"></a>
## 2018-12-26, Version 6.16.0 'Boron' (LTS), @MylesBorins

The 6.15.0 security release introduced some unexpected breakages on the 6.x release line.
This is a special release to fix a regression in the HTTP binary upgrade response body and add
a missing CLI flag to adjust the max header size of the http parser.

### Notable Changes

* **cli**:
  * add --max-http-header-size flag (cjihrig) [#24811](https://github.com/nodejs/node/pull/24811)
* **http**:
  * add maxHeaderSize property (cjihrig) [#24860](https://github.com/nodejs/node/pull/24860)

### Commits

* [[`f233b160c9`](https://github.com/nodejs/node/commit/f233b160c9)] - **(SEMVER-MINOR)** **cli**: add --max-http-header-size flag (cjihrig) [#24811](https://github.com/nodejs/node/pull/24811)
* [[`59f83d6896`](https://github.com/nodejs/node/commit/59f83d6896)] - **(SEMVER-MINOR)** **deps**: cherry-pick http\_parser\_set\_max\_header\_size (cjihrig) [#24811](https://github.com/nodejs/node/pull/24811)
* [[`c0c4de71f0`](https://github.com/nodejs/node/commit/c0c4de71f0)] - **(SEMVER-MINOR)** **http**: add maxHeaderSize property (cjihrig) [#24860](https://github.com/nodejs/node/pull/24860)
* [[`8a3e0c0697`](https://github.com/nodejs/node/commit/8a3e0c0697)] - **http**: fix regression of binary upgrade response body (Matteo Collina) [#25036](https://github.com/nodejs/node/pull/25036)

<a id="6.15.1"></a>
## 2018-12-03, Version 6.15.1 'Boron' (LTS), @rvagg

### Notable Changes

This is a patch release to address a bad backport of the fix for "Slowloris HTTP Denial of Service" (CVE-2018-12122). Node.js 6.15.0 misapplies the headers timeout to an entire keep-alive HTTP session, resulting in prematurely disconnected sockets.

### Commits

* [[`5d9005c359`](https://github.com/nodejs/node/commit/5d9005c359)] - **http**: fix backport of Slowloris headers (Matteo Collina) [#24796](https://github.com/nodejs/node/pull/24796)

<a id="6.15.0"></a>
## 2018-11-27, Version 6.15.0 'Boron' (LTS), @rvagg

This is a security release. All Node.js users should consult the security release summary at:

  https://nodejs.org/en/blog/vulnerability/november-2018-security-releases/

for details on patched vulnerabilities.

Fixes for the following CVEs are included in this release:

* Node.js: Debugger port 5858 listens on any interface by default (CVE-2018-12120)
* Node.js: Denial of Service with large HTTP headers (CVE-2018-12121)
* Node.js: Slowloris HTTP Denial of Service (CVE-2018-12122 / Node.js)
* Node.js: Hostname spoofing in URL parser for javascript protocol (CVE-2018-12123)
* Node.js: HTTP request splitting (CVE-2018-12116)
* OpenSSL: Timing vulnerability in DSA signature generation (CVE-2018-0734)
* OpenSSL: Microarchitecture timing vulnerability in ECC scalar multiplication (CVE-2018-5407)

### Notable Changes

* **debugger**: Backport of [nodejs/node#8106](https://github.com/nodejs/node/pull/8106) to prevent the debugger from listening on `0.0.0.0`. It now defaults to `127.0.0.1`. Reported by Ben Noordhuis. (CVE-2018-12120 / Ben Noordhuis).
* **deps**: Upgrade to OpenSSL 1.0.2q, fixing CVE-2018-0734 and CVE-2018-5407
* **http**:
  * Headers received by HTTP servers must not exceed 8192 bytes in total to prevent possible Denial of Service attacks. Reported by Trevor Norris. (CVE-2018-12121 / Matteo Collina)
  * A timeout of 40 seconds now applies to servers receiving HTTP headers. This value can be adjusted with `server.headersTimeout`. Where headers are not completely received within this period, the socket is destroyed on the next received chunk. In conjunction with `server.setTimeout()`, this aids in protecting against excessive resource retention and possible Denial of Service. Reported by Jan Maybach ([liebdich.com](https://liebdich.com)). (CVE-2018-12122 / Matteo Collina)
  * Two-byte characters are now strictly disallowed for the `path` option in HTTP client requests. Paths containing characters outside of the range `\u0021` - `\u00ff` will now be rejected with a `TypeError`. This behavior can be reverted if necessary by supplying the `--security-revert=CVE-2018-12116` command line argument (this is not recommended). Reported as security concern for Node.js 6 and 8 by [Arkadiy Tetelman](https://twitter.com/arkadiyt) ([Lob](https://lob.com)), fixed by backporting a change by Benno Fünfstück applied to Node.js 10 and later. (CVE-2018-12116 / Matteo Collina)
* **url**: Fix a bug that would allow a hostname being spoofed when parsing URLs with `url.parse()` with the `'javascript:'` protocol. Reported by [Martin Bajanik](https://twitter.com/_bayotop) ([Kentico](https://kenticocloud.com/)). (CVE-2018-12123 / Matteo Collina)

### Commits

* [[`4beba664e1`](https://github.com/nodejs/node/commit/4beba664e1)] - **deps**: add -no\_rand\_screen to openssl s\_client (Shigeki Ohtsu) [nodejs/node#1836](https://github.com/nodejs/node/pull/1836)
* [[`049fe7978f`](https://github.com/nodejs/node/commit/049fe7978f)] - **deps**: fix asm build error of openssl in x86\_win32 (Shigeki Ohtsu) [nodejs/node#1389](https://github.com/nodejs/node/pull/1389)
* [[`e9becec84d`](https://github.com/nodejs/node/commit/e9becec84d)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [nodejs/node#1389](https://github.com/nodejs/node/pull/1389)
* [[`78b3a5b2f7`](https://github.com/nodejs/node/commit/78b3a5b2f7)] - **deps**: copy all openssl header files to include dir (Sam Roberts) [#24530](https://github.com/nodejs/node/pull/24530)
* [[`6120f2429e`](https://github.com/nodejs/node/commit/6120f2429e)] - **deps**: upgrade openssl sources to 1.0.2q (Sam Roberts) [#24530](https://github.com/nodejs/node/pull/24530)
* [[`92231a56d9`](https://github.com/nodejs/node/commit/92231a56d9)] - **deps,http**: http\_parser set max header size to 8KB (Matteo Collina) [nodejs-private/node-private#143](https://github.com/nodejs-private/node-private/pull/143)
* [[`dd20c0186f`](https://github.com/nodejs/node/commit/dd20c0186f)] - **(SEMVER-MINOR)** **http**: add --security-revert for CVE-2018-12116 (Matteo Collina) [nodejs-private/node-private#146](https://github.com/nodejs-private/node-private/pull/146)
* [[`811b63c794`](https://github.com/nodejs/node/commit/811b63c794)] - **(SEMVER-MINOR)** **http**: disallow two-byte characters in URL path (Benno Fünfstück) [nodejs-private/node-private#146](https://github.com/nodejs-private/node-private/pull/146)
* [[`618eebdd17`](https://github.com/nodejs/node/commit/618eebdd17)] - **(SEMVER-MINOR)** **http,https**: protect against slow headers attack (Matteo Collina) [nodejs-private/node-private#152](https://github.com/nodejs-private/node-private/pull/152)
* [[`b78d403da3`](https://github.com/nodejs/node/commit/b78d403da3)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [nodejs/node#1389](https://github.com/nodejs/node/pull/1389)
* [[`35344e87bf`](https://github.com/nodejs/node/commit/35344e87bf)] - **src**: minor cleanup for node\_revert (James M Snell) [#14864](https://github.com/nodejs/node/pull/14864)
* [[`a9791c9090`](https://github.com/nodejs/node/commit/a9791c9090)] - **src**: make debugger listen on 127.0.0.1 by default (Ben Noordhuis) [nodejs-private/node-private#148](https://github.com/nodejs-private/node-private/pull/148)
* [[`9c268d0492`](https://github.com/nodejs/node/commit/9c268d0492)] - **url**: avoid hostname spoofing w/ javascript protocol (Matteo Collina) [nodejs-private/node-private#145](https://github.com/nodejs-private/node-private/pull/145)

<a id="6.14.4"></a>
## 2018-08-15, Version 6.14.4 'Boron' (LTS), @rvagg

This is a security release. All Node.js users should consult the security release summary at:

  https://nodejs.org/en/blog/vulnerability/august-2018-security-releases/

for details on patched vulnerabilities.

Fixes for the following CVEs are included in this release:

* CVE-2018-0732 (OpenSSL)
* CVE-2018-12115 (Node.js)

### Notable Changes

* **buffer**: Fix out-of-bounds (OOB) write in `Buffer.write()` for UCS-2 encoding (CVE-2018-12115)
* **deps**: Upgrade to OpenSSL 1.0.2p, fixing:
  * Client DoS due to large DH parameter (CVE-2018-0732)
  * ECDSA key extraction via local side-channel (CVE not assigned)

### Commits

* [[`0052926476`](https://github.com/nodejs/node/commit/0052926476)] - **buffer**: avoid overrun on UCS-2 string write (Rod Vagg) [nodejs-private/node-private#138](https://github.com/nodejs-private/node-private/pull/138)
* [[`dbe6551b89`](https://github.com/nodejs/node/commit/dbe6551b89)] - **deps**: add -no\_rand\_screen to openssl s\_client (Shigeki Ohtsu) [#1836](https://github.com/nodejs/node/pull/1836)
* [[`7829bbcacb`](https://github.com/nodejs/node/commit/7829bbcacb)] - **deps**: fix asm build error of openssl in x86\_win32 (Shigeki Ohtsu) [#1389](https://github.com/nodejs/node/pull/1389)
* [[`cddca629b5`](https://github.com/nodejs/node/commit/cddca629b5)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [#1389](https://github.com/nodejs/node/pull/1389)
* [[`e6014aed52`](https://github.com/nodejs/node/commit/e6014aed52)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu) [#22320](https://github.com/nodejs/node/pull/22320)
* [[`37ddce514d`](https://github.com/nodejs/node/commit/37ddce514d)] - **deps**: upgrade openssl sources to 1.0.2p (Shigeki Ohtsu) [#22320](https://github.com/nodejs/node/pull/22320)
* [[`08a150fcca`](https://github.com/nodejs/node/commit/08a150fcca)] - **inspector**: don't bind to 0.0.0.0 by default (Ben Noordhuis) [#21376](https://github.com/nodejs/node/pull/21376)
* [[`19b9d7fd77`](https://github.com/nodejs/node/commit/19b9d7fd77)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [#1389](https://github.com/nodejs/node/pull/1389)
* [[`7ccb0422fc`](https://github.com/nodejs/node/commit/7ccb0422fc)] - **test**: fix error messages for OpenSSL-1.0.2p (Shigeki Ohtsu) [#22320](https://github.com/nodejs/node/pull/22320)
* [[`58b9497ca8`](https://github.com/nodejs/node/commit/58b9497ca8)] - **test**: update certificates and private keys (Fedor Indutny) [#22184](https://github.com/nodejs/node/pull/22184)
* [[`9863e11ea8`](https://github.com/nodejs/node/commit/9863e11ea8)] - **test**: update keys/Makefile to clean and build all (Daniel Bevenius) [#19975](https://github.com/nodejs/node/pull/19975)

<a id="6.14.3"></a>
## 2018-06-12, Version 6.14.3 'Boron' (LTS), @evanlucas

### Notable Changes

* **buffer** (CVE-2018-7167): Fixes Denial of Service vulnerability where calling Buffer.fill() could hang

### Commits

* [[`7dbcfc6217`](https://github.com/nodejs/node/commit/7dbcfc6217)] - **src**: avoid hanging on Buffer#fill 0-length input (Сковорода Никита Андреевич) [nodejs-private/node-private#121](https://github.com/nodejs-private/node-private/pull/121)

<a id="6.14.2"></a>
## 2018-04-30, Version 6.14.2 'Boron' (LTS), @MylesBorins

### Notable Changes

* **n-api**:
  * n-api has been backported to v6.x. It is being landed as an experimental interface,
    and as such is landing in a Semver-Patch release. (Gabriel Schulhof) [#19447](https://github.com/nodejs/node/pull/19447)

### Commits

* [[`6ba38e8c2b`](https://github.com/nodejs/node/commit/6ba38e8c2b)] - **N-API**: Reuse ObjectTemplate instances (Gabriel Schulhof) [#13999](https://github.com/nodejs/node/pull/13999)
* [[`49d8c2e8ae`](https://github.com/nodejs/node/commit/49d8c2e8ae)] - **build**: refine static and shared lib build (Yihong Wang) [#17604](https://github.com/nodejs/node/pull/17604)
* [[`cc7469eec8`](https://github.com/nodejs/node/commit/cc7469eec8)] - **build**: allow x86\_64 as a dest\_cpu alias for x64 (Rod Vagg) [#18052](https://github.com/nodejs/node/pull/18052)
* [[`969398d08e`](https://github.com/nodejs/node/commit/969398d08e)] - **crypto**: reuse variable instead of reevaluation (Tobias Nießen) [#17735](https://github.com/nodejs/node/pull/17735)
* [[`71acb5205a`](https://github.com/nodejs/node/commit/71acb5205a)] - **doc**: Add a missing comma (jiangq) [#19555](https://github.com/nodejs/node/pull/19555)
* [[`b9b752ef07`](https://github.com/nodejs/node/commit/b9b752ef07)] - **doc**: fix typos on n-api (Kyle Robinson Young) [#19385](https://github.com/nodejs/node/pull/19385)
* [[`10fe65a0d5`](https://github.com/nodejs/node/commit/10fe65a0d5)] - **doc**: fix n-api asynchronous threading docs (Eric Bickle) [#19073](https://github.com/nodejs/node/pull/19073)
* [[`8826f185b0`](https://github.com/nodejs/node/commit/8826f185b0)] - **doc**: mark NAPI\_AUTO\_LENGTH as code (Tobias Nießen) [#18697](https://github.com/nodejs/node/pull/18697)
* [[`e9e5d56121`](https://github.com/nodejs/node/commit/e9e5d56121)] - **doc**: fix exporting a function example (Aonghus O Nia) [#18661](https://github.com/nodejs/node/pull/18661)
* [[`9719b831a3`](https://github.com/nodejs/node/commit/9719b831a3)] - **doc**: fix typo in n-api.md (Vse Mozhet Byt) [#18590](https://github.com/nodejs/node/pull/18590)
* [[`fdd50fb35f`](https://github.com/nodejs/node/commit/fdd50fb35f)] - **doc**: small typo in n-api.md (iskore) [#18555](https://github.com/nodejs/node/pull/18555)
* [[`24a2791173`](https://github.com/nodejs/node/commit/24a2791173)] - **doc**: remove usage of you in n-api doc (Michael Dawson) [#18528](https://github.com/nodejs/node/pull/18528)
* [[`74086e19f2`](https://github.com/nodejs/node/commit/74086e19f2)] - **doc**: remove uannecessary Require (Michael Dawson) [#18184](https://github.com/nodejs/node/pull/18184)
* [[`fed2136857`](https://github.com/nodejs/node/commit/fed2136857)] - **doc**: napi: make header style consistent (Ali Ijaz Sheikh) [#18122](https://github.com/nodejs/node/pull/18122)
* [[`e04386a363`](https://github.com/nodejs/node/commit/e04386a363)] - **doc**: napi: fix unbalanced emphasis (Ali Ijaz Sheikh) [#18122](https://github.com/nodejs/node/pull/18122)
* [[`3d8e1aaf48`](https://github.com/nodejs/node/commit/3d8e1aaf48)] - **doc**: updates examples to use NULL (Michael Dawson) [#18008](https://github.com/nodejs/node/pull/18008)
* [[`173f29763e`](https://github.com/nodejs/node/commit/173f29763e)] - **doc**: update example in module registration (Franziska Hinkelmann) [#17424](https://github.com/nodejs/node/pull/17424)
* [[`c6852126fd`](https://github.com/nodejs/node/commit/c6852126fd)] - **doc**: use "JavaScript" instead of "Javascript" (Rich Trott) [#17163](https://github.com/nodejs/node/pull/17163)
* [[`35dc8bab9e`](https://github.com/nodejs/node/commit/35dc8bab9e)] - **doc**: document common pattern for instanceof checks (Michael Dawson) [#16699](https://github.com/nodejs/node/pull/16699)
* [[`22490dcb91`](https://github.com/nodejs/node/commit/22490dcb91)] - **doc**: fix typos in N-API (Swathi Kalahastri) [#16911](https://github.com/nodejs/node/pull/16911)
* [[`55fabd7337`](https://github.com/nodejs/node/commit/55fabd7337)] - **doc**: fix a typo in n-api documentation (Vipin Menon) [#16879](https://github.com/nodejs/node/pull/16879)
* [[`0c67f21bcf`](https://github.com/nodejs/node/commit/0c67f21bcf)] - **doc**: update to use NAPI\_AUTO\_LENGTH (Michael Dawson) [#16187](https://github.com/nodejs/node/pull/16187)
* [[`5c2bba0931`](https://github.com/nodejs/node/commit/5c2bba0931)] - **doc**: fix some links (Vse Mozhet Byt) [#16202](https://github.com/nodejs/node/pull/16202)
* [[`e9a6dffc65`](https://github.com/nodejs/node/commit/e9a6dffc65)] - **doc**: fix outdated code sample in n-api.md (rebornix) [#15581](https://github.com/nodejs/node/pull/15581)
* [[`ca69f1dfe7`](https://github.com/nodejs/node/commit/ca69f1dfe7)] - **doc**: fix new nits in links (Vse Mozhet Byt) [#15449](https://github.com/nodejs/node/pull/15449)
* [[`a766802bee`](https://github.com/nodejs/node/commit/a766802bee)] - **doc**: fix doc for napi\_get\_value\_string\_utf8 (Daniel Taveras) [#14529](https://github.com/nodejs/node/pull/14529)
* [[`b0f09a2ee6`](https://github.com/nodejs/node/commit/b0f09a2ee6)] - **doc**: added napi\_get\_value\_string\_latin1 (Kyle Farnung) [#14678](https://github.com/nodejs/node/pull/14678)
* [[`fbcc962727`](https://github.com/nodejs/node/commit/fbcc962727)] - **doc**: delint (Refael Ackermann) [#14707](https://github.com/nodejs/node/pull/14707)
* [[`831de617b0`](https://github.com/nodejs/node/commit/831de617b0)] - **doc**: document napi\_finalize() signature (cjihrig) [#14230](https://github.com/nodejs/node/pull/14230)
* [[`4b9773effa`](https://github.com/nodejs/node/commit/4b9773effa)] - **doc**: fix some links (Vse Mozhet Byt) [#14400](https://github.com/nodejs/node/pull/14400)
* [[`36185b343b`](https://github.com/nodejs/node/commit/36185b343b)] - **doc**: doc lifetime of n-api last error info (Michael Dawson) [#13939](https://github.com/nodejs/node/pull/13939)
* [[`cc3a4af7c8`](https://github.com/nodejs/node/commit/cc3a4af7c8)] - **doc**: fix a few n-api doc issues (Michael Dawson) [#13650](https://github.com/nodejs/node/pull/13650)
* [[`1e91d5804d`](https://github.com/nodejs/node/commit/1e91d5804d)] - **doc**: fix out of date napi\_callback doc (XadillaX) [#13570](https://github.com/nodejs/node/pull/13570)
* [[`c5ae39e401`](https://github.com/nodejs/node/commit/c5ae39e401)] - **doc**: fix napi\_create\_\*\_error signatures in n-api (Jamen Marzonie) [#13544](https://github.com/nodejs/node/pull/13544)
* [[`35a3cbb5dd`](https://github.com/nodejs/node/commit/35a3cbb5dd)] - **doc**: fix out of date sections in n-api doc (Michael Dawson) [#13508](https://github.com/nodejs/node/pull/13508)
* [[`a06cc4684f`](https://github.com/nodejs/node/commit/a06cc4684f)] - **doc**: fix typo "ndapi" in n-api.md (Jamen Marz) [#13484](https://github.com/nodejs/node/pull/13484)
* [[`82f31ff4af`](https://github.com/nodejs/node/commit/82f31ff4af)] - **doc**: add ref to option to enable n-api (Michael Dawson) [#13406](https://github.com/nodejs/node/pull/13406)
* [[`17fe21e83d`](https://github.com/nodejs/node/commit/17fe21e83d)] - **doc**: fix typo in n-api.md (JongChan Choi) [#13323](https://github.com/nodejs/node/pull/13323)
* [[`2e2905266e`](https://github.com/nodejs/node/commit/2e2905266e)] - **doc**: fix title/function name mismatch (Michael Dawson) [#13123](https://github.com/nodejs/node/pull/13123)
* [[`75e91fe5c8`](https://github.com/nodejs/node/commit/75e91fe5c8)] - **doc**: add reference to node\_api.h in docs (Michael Dawson) [#13084](https://github.com/nodejs/node/pull/13084)
* [[`0f74ee5cbf`](https://github.com/nodejs/node/commit/0f74ee5cbf)] - **doc**: clarify operation of napi\_cancel\_async\_work (Michael Dawson) [#12974](https://github.com/nodejs/node/pull/12974)
* [[`5b045374ed`](https://github.com/nodejs/node/commit/5b045374ed)] - **doc**: clarify node.js addons are c++ (Beth Griggs) [#12898](https://github.com/nodejs/node/pull/12898)
* [[`6bcd6d49d5`](https://github.com/nodejs/node/commit/6bcd6d49d5)] - **doc**: fix broken links in n-api doc (Michael Dawson) [#12889](https://github.com/nodejs/node/pull/12889)
* [[`3e388cf819`](https://github.com/nodejs/node/commit/3e388cf819)] - **doc**: Add initial documentation for N-API (Michael Dawson) [#12549](https://github.com/nodejs/node/pull/12549)
* [[`4d67369c1b`](https://github.com/nodejs/node/commit/4d67369c1b)] - **doc**: fix various nits (Vse Mozhet Byt) [#19743](https://github.com/nodejs/node/pull/19743)
* [[`057c80b088`](https://github.com/nodejs/node/commit/057c80b088)] - **doc**: move Fedor to TSC Emeritus (Myles Borins) [#18752](https://github.com/nodejs/node/pull/18752)
* [[`bf72ee667e`](https://github.com/nodejs/node/commit/bf72ee667e)] - **doc**: add mmarchini to collaborators (Matheus Marchini) [#18740](https://github.com/nodejs/node/pull/18740)
* [[`280af052d8`](https://github.com/nodejs/node/commit/280af052d8)] - **doc**: add history for url.parse (Steven) [#18685](https://github.com/nodejs/node/pull/18685)
* [[`29b0d3b104`](https://github.com/nodejs/node/commit/29b0d3b104)] - **doc**: add devsnek to collaborators (Gus Caplan) [#18679](https://github.com/nodejs/node/pull/18679)
* [[`dc6dc8232f`](https://github.com/nodejs/node/commit/dc6dc8232f)] - **doc**: add section for strategic initiatives (Michael Dawson) [#17104](https://github.com/nodejs/node/pull/17104)
* [[`6b348d4483`](https://github.com/nodejs/node/commit/6b348d4483)] - **doc**: modify the return value of request.write() (陈刚) [#18526](https://github.com/nodejs/node/pull/18526)
* [[`dd4d075e51`](https://github.com/nodejs/node/commit/dd4d075e51)] - **doc**: be more explicit in the sypnosis (Tim O. Peters) [#17977](https://github.com/nodejs/node/pull/17977)
* [[`0067bccf6f`](https://github.com/nodejs/node/commit/0067bccf6f)] - **doc**: fix description of createDecipheriv (Tobias Nießen) [#18651](https://github.com/nodejs/node/pull/18651)
* [[`bc2f0a5120`](https://github.com/nodejs/node/commit/bc2f0a5120)] - **doc**: linkify missing types (Vse Mozhet Byt) [#18444](https://github.com/nodejs/node/pull/18444)
* [[`32089bcbc1`](https://github.com/nodejs/node/commit/32089bcbc1)] - **doc**: streamline README intro (Rich Trott) [#18483](https://github.com/nodejs/node/pull/18483)
* [[`43839f1601`](https://github.com/nodejs/node/commit/43839f1601)] - **doc**: move Brian White to TSC Emeriti list (Rich Trott) [#18482](https://github.com/nodejs/node/pull/18482)
* [[`27d3c1a0f4`](https://github.com/nodejs/node/commit/27d3c1a0f4)] - **doc**: add Gibson Fahnestock to TSC (Rich Trott) [#18481](https://github.com/nodejs/node/pull/18481)
* [[`67fd520539`](https://github.com/nodejs/node/commit/67fd520539)] - **doc**: reorder section on updating PR branch (Ali Ijaz Sheikh) [#18355](https://github.com/nodejs/node/pull/18355)
* [[`f81a69aefe`](https://github.com/nodejs/node/commit/f81a69aefe)] - **fs**: fix `createReadStream(…, {end: n})` for non-seekable fds (Anna Henningsen) [#19329](https://github.com/nodejs/node/pull/19329)
* [[`18acad349c`](https://github.com/nodejs/node/commit/18acad349c)] - **http**: make socketPath work with no agent (Luigi Pinca) [#19425](https://github.com/nodejs/node/pull/19425)
* [[`1edadebaa0`](https://github.com/nodejs/node/commit/1edadebaa0)] - **http**: allow \_httpMessage to be GC'ed (Luigi Pinca) [#18865](https://github.com/nodejs/node/pull/18865)
* [[`dbe70b744c`](https://github.com/nodejs/node/commit/dbe70b744c)] - **http**: free the parser before emitting 'upgrade' (Luigi Pinca) [#18209](https://github.com/nodejs/node/pull/18209)
* [[`77a405b92f`](https://github.com/nodejs/node/commit/77a405b92f)] - **lib**: set process.execPath on OpenBSD (Aaron Bieber) [#18543](https://github.com/nodejs/node/pull/18543)
* [[`3aa5b7d939`](https://github.com/nodejs/node/commit/3aa5b7d939)] - **n-api**: add more `int64_t` tests (Kyle Farnung) [#19402](https://github.com/nodejs/node/pull/19402)
* [[`abd9fd6797`](https://github.com/nodejs/node/commit/abd9fd6797)] - **n-api**: back up env before finalize (Gabriel Schulhof) [#19718](https://github.com/nodejs/node/pull/19718)
* [[`e6ccdfbde3`](https://github.com/nodejs/node/commit/e6ccdfbde3)] - **n-api**: ensure in-module exceptions are propagated (Gabriel Schulhof) [#19537](https://github.com/nodejs/node/pull/19537)
* [[`c6d0a66ef2`](https://github.com/nodejs/node/commit/c6d0a66ef2)] - **n-api**: bump version of n-api supported (Michael Dawson) [#19497](https://github.com/nodejs/node/pull/19497)
* [[`c16a705416`](https://github.com/nodejs/node/commit/c16a705416)] - **n-api**: re-write test\_make\_callback (Gabriel Schulhof) [#19448](https://github.com/nodejs/node/pull/19448)
* [[`49cd4fad89`](https://github.com/nodejs/node/commit/49cd4fad89)] - **n-api**: add napi\_fatal\_exception (Mathias Buus) [#19337](https://github.com/nodejs/node/pull/19337)
* [[`eb29266878`](https://github.com/nodejs/node/commit/eb29266878)] - **n-api**: add missing exception checking (Michael Dawson) [#19362](https://github.com/nodejs/node/pull/19362)
* [[`2c1190a93d`](https://github.com/nodejs/node/commit/2c1190a93d)] - **n-api**: take n-api out of experimental (Michael Dawson) [#19262](https://github.com/nodejs/node/pull/19262)
* [[`ce1447920e`](https://github.com/nodejs/node/commit/ce1447920e)] - **n-api**: resolve promise in test (Gabriel Schulhof) [#19245](https://github.com/nodejs/node/pull/19245)
* [[`a8237efaf1`](https://github.com/nodejs/node/commit/a8237efaf1)] - **n-api**: update documentation (Gabriel Schulhof) [#19078](https://github.com/nodejs/node/pull/19078)
* [[`af62c8fff7`](https://github.com/nodejs/node/commit/af62c8fff7)] - **n-api**: update reference test (Gabriel Schulhof) [#19086](https://github.com/nodejs/node/pull/19086)
* [[`d2463745a7`](https://github.com/nodejs/node/commit/d2463745a7)] - **n-api**: fix object test (Gabriel Schulhof) [#19039](https://github.com/nodejs/node/pull/19039)
* [[`516c287f8e`](https://github.com/nodejs/node/commit/516c287f8e)] - **n-api**: remove extra reference from test (Gabriel Schulhof) [#18542](https://github.com/nodejs/node/pull/18542)
* [[`a8dec487f7`](https://github.com/nodejs/node/commit/a8dec487f7)] - **n-api**: add methods to open/close callback scope (Michael Dawson) [#18089](https://github.com/nodejs/node/pull/18089)
* [[`c09a7134e7`](https://github.com/nodejs/node/commit/c09a7134e7)] - **n-api**: wrap control flow macro in do/while (Ben Noordhuis) [#18532](https://github.com/nodejs/node/pull/18532)
* [[`b565ba2d82`](https://github.com/nodejs/node/commit/b565ba2d82)] - **n-api**: implement wrapping using private properties (Gabriel Schulhof) [#18311](https://github.com/nodejs/node/pull/18311)
* [[`d9df8cfe77`](https://github.com/nodejs/node/commit/d9df8cfe77)] - **n-api**: change assert ok check to notStrictEqual. (Aaron Kau) [#18414](https://github.com/nodejs/node/pull/18414)
* [[`2e24a0bfe7`](https://github.com/nodejs/node/commit/2e24a0bfe7)] - **n-api**: throw RangeError napi\_create\_typedarray() (Jinho Bang) [#18037](https://github.com/nodejs/node/pull/18037)
* [[`62427bbed9`](https://github.com/nodejs/node/commit/62427bbed9)] - **n-api**: expose n-api version in process.versions (Michael Dawson) [#18067](https://github.com/nodejs/node/pull/18067)
* [[`bb99f31f30`](https://github.com/nodejs/node/commit/bb99f31f30)] - **n-api**: throw RangeError in napi\_create\_dataview() with invalid range (Jinho Bang) [#17869](https://github.com/nodejs/node/pull/17869)
* [[`65ea7abd55`](https://github.com/nodejs/node/commit/65ea7abd55)] - **n-api**: fix memory leak in napi\_async\_destroy() (alnyan) [#17714](https://github.com/nodejs/node/pull/17714)
* [[`d4284a464b`](https://github.com/nodejs/node/commit/d4284a464b)] - **n-api**: use nullptr instead of NULL in node\_api.cc (Daniel Bevenius) [#17276](https://github.com/nodejs/node/pull/17276)
* [[`f4391b95ee`](https://github.com/nodejs/node/commit/f4391b95ee)] - **n-api**: add helper for addons to get the event loop (Anna Henningsen) [#17109](https://github.com/nodejs/node/pull/17109)
* [[`3c84db624a`](https://github.com/nodejs/node/commit/3c84db624a)] - **n-api**: unexpose symbols and remove EXTERNAL\_NAPI (Gabriel Schulhof) [#16234](https://github.com/nodejs/node/pull/16234)
* [[`55aab6bf01`](https://github.com/nodejs/node/commit/55aab6bf01)] - **n-api**: check against invalid handle scope usage (Anna Henningsen) [#16201](https://github.com/nodejs/node/pull/16201)
* [[`169b53e788`](https://github.com/nodejs/node/commit/169b53e788)] - **n-api**: use module name macro (Michael Dawson) [#16185](https://github.com/nodejs/node/pull/16185)
* [[`32412a8ded`](https://github.com/nodejs/node/commit/32412a8ded)] - **n-api**: make changes for source compatibility (Gabriel Schulhof) [#16102](https://github.com/nodejs/node/pull/16102)
* [[`00d094f9c3`](https://github.com/nodejs/node/commit/00d094f9c3)] - **n-api**: add check for large strings (Michael Dawson) [#15611](https://github.com/nodejs/node/pull/15611)
* [[`2bc8a59915`](https://github.com/nodejs/node/commit/2bc8a59915)] - **n-api**: fix warning about size\_t compare with int (Sampson Gao) [#15508](https://github.com/nodejs/node/pull/15508)
* [[`5e29823d1d`](https://github.com/nodejs/node/commit/5e29823d1d)] - **n-api**: remove n-api module loading flag (Gabriel Schulhof) [#14902](https://github.com/nodejs/node/pull/14902)
* [[`f31b50cfc7`](https://github.com/nodejs/node/commit/f31b50cfc7)] - **n-api**: add optional string length parameters (Sampson Gao) [#15343](https://github.com/nodejs/node/pull/15343)
* [[`fe87a5944b`](https://github.com/nodejs/node/commit/fe87a5944b)] - **n-api**: napi\_is\_construct\_call-\>napi\_get\_new\_target (Sampson Gao) [#14698](https://github.com/nodejs/node/pull/14698)
* [[`5eadd6249d`](https://github.com/nodejs/node/commit/5eadd6249d)] - **n-api**: Context for custom async operations (Jason Ginchereau) [#15189](https://github.com/nodejs/node/pull/15189)
* [[`50cb48b55c`](https://github.com/nodejs/node/commit/50cb48b55c)] - **n-api**: refactor napi\_addon\_register\_func (Taylor Woll) [#15088](https://github.com/nodejs/node/pull/15088)
* [[`156a8b6069`](https://github.com/nodejs/node/commit/156a8b6069)] - **n-api**: change async resource name to napi\_value (Jason Ginchereau) [#14697](https://github.com/nodejs/node/pull/14697)
* [[`7588eead2a`](https://github.com/nodejs/node/commit/7588eead2a)] - **n-api**: use AsyncResource for Work tracking (Anna Henningsen) [#14697](https://github.com/nodejs/node/pull/14697)
* [[`676cff48bd`](https://github.com/nodejs/node/commit/676cff48bd)] - **n-api**: stop creating references to primitives (Gabriel Schulhof) [#15289](https://github.com/nodejs/node/pull/15289)
* [[`3b4708b025`](https://github.com/nodejs/node/commit/3b4708b025)] - **n-api**: implement napi\_run\_script (Gabriel Schulhof) [#15216](https://github.com/nodejs/node/pull/15216)
* [[`ac5b904808`](https://github.com/nodejs/node/commit/ac5b904808)] - **n-api**: adds function to adjust external memory (Chris Young) [#14310](https://github.com/nodejs/node/pull/14310)
* [[`278a2d069f`](https://github.com/nodejs/node/commit/278a2d069f)] - **n-api**: implement promise (Gabriel Schulhof) [#14365](https://github.com/nodejs/node/pull/14365)
* [[`73cc251f50`](https://github.com/nodejs/node/commit/73cc251f50)] - **n-api**: add ability to remove a wrapping (Gabriel Schulhof) [#14658](https://github.com/nodejs/node/pull/14658)
* [[`951adbef3d`](https://github.com/nodejs/node/commit/951adbef3d)] - **n-api**: add napi\_get\_node\_version (Anna Henningsen) [#14696](https://github.com/nodejs/node/pull/14696)
* [[`b29eb693a0`](https://github.com/nodejs/node/commit/b29eb693a0)] - **n-api**: optimize number API performance (Jason Ginchereau) [#14573](https://github.com/nodejs/node/pull/14573)
* [[`bd032a158a`](https://github.com/nodejs/node/commit/bd032a158a)] - **n-api**: add support for DataView (Shivanth MP) [#14382](https://github.com/nodejs/node/pull/14382)
* [[`86b101cb60`](https://github.com/nodejs/node/commit/86b101cb60)] - **n-api**: re-use napi\_env between modules (Gabriel Schulhof) [#14217](https://github.com/nodejs/node/pull/14217)
* [[`1acab66df4`](https://github.com/nodejs/node/commit/1acab66df4)] - **n-api**: directly create Local from Persistent (Kyle Farnung) [#14211](https://github.com/nodejs/node/pull/14211)
* [[`f4d1cae634`](https://github.com/nodejs/node/commit/f4d1cae634)] - **n-api**: add fast paths for integer getters (Anna Henningsen) [#14393](https://github.com/nodejs/node/pull/14393)
* [[`aad36b2cd4`](https://github.com/nodejs/node/commit/aad36b2cd4)] - **n-api**: add napi\_fatal\_error API (Kyle Farnung) [#13971](https://github.com/nodejs/node/pull/13971)
* [[`57be12ed97`](https://github.com/nodejs/node/commit/57be12ed97)] - **n-api**: add code parameter to error helpers (Michael Dawson) [#13988](https://github.com/nodejs/node/pull/13988)
* [[`cd3015408e`](https://github.com/nodejs/node/commit/cd3015408e)] - **n-api**: wrap test macros in do/while (Kyle Farnung) [#14095](https://github.com/nodejs/node/pull/14095)
* [[`7973bd3e63`](https://github.com/nodejs/node/commit/7973bd3e63)] - **n-api**: Implement stricter wrapping (Gabriel Schulhof) [#13872](https://github.com/nodejs/node/pull/13872)
* [[`5b0c57cfeb`](https://github.com/nodejs/node/commit/5b0c57cfeb)] - **n-api**: fix warning in test\_general (Daniel Bevenius) [#14104](https://github.com/nodejs/node/pull/14104)
* [[`a5517d80bb`](https://github.com/nodejs/node/commit/a5517d80bb)] - **n-api**: add napi\_has\_own\_property() (cjihrig) [#14063](https://github.com/nodejs/node/pull/14063)
* [[`8e2a26d3d0`](https://github.com/nodejs/node/commit/8e2a26d3d0)] - **n-api**: fix -Wmaybe-uninitialized compiler warning (Ben Noordhuis) [#14053](https://github.com/nodejs/node/pull/14053)
* [[`33821c3087`](https://github.com/nodejs/node/commit/33821c3087)] - **n-api**: use Maybe version of Object::SetPrototype() (Ben Noordhuis) [#14053](https://github.com/nodejs/node/pull/14053)
* [[`80cf25a8a5`](https://github.com/nodejs/node/commit/80cf25a8a5)] - **n-api**: add napi\_delete\_property() (cjihrig) [#13934](https://github.com/nodejs/node/pull/13934)
* [[`cadec3b37e`](https://github.com/nodejs/node/commit/cadec3b37e)] - **n-api**: add napi\_delete\_element() (cjihrig) [#13949](https://github.com/nodejs/node/pull/13949)
* [[`97b628ba8e`](https://github.com/nodejs/node/commit/97b628ba8e)] - **n-api**: fix section title typo (Kyle Farnung) [#13972](https://github.com/nodejs/node/pull/13972)
* [[`c3eb187bd9`](https://github.com/nodejs/node/commit/c3eb187bd9)] - **n-api**: avoid crash in napi\_escape\_scope() (Michael Dawson) [#13651](https://github.com/nodejs/node/pull/13651)
* [[`919556f27a`](https://github.com/nodejs/node/commit/919556f27a)] - **n-api**: enable napi\_wrap() to work with any object (Jason Ginchereau) [#13250](https://github.com/nodejs/node/pull/13250)
* [[`86c0ebf4e2`](https://github.com/nodejs/node/commit/86c0ebf4e2)] - **n-api**: add napi\_get\_version (Michael Dawson) [#13207](https://github.com/nodejs/node/pull/13207)
* [[`70281ba1be`](https://github.com/nodejs/node/commit/70281ba1be)] - **n-api**: Retain last code when getting error info (Jason Ginchereau) [#13087](https://github.com/nodejs/node/pull/13087)
* [[`8d3162d9e6`](https://github.com/nodejs/node/commit/8d3162d9e6)] - **n-api**: remove compiler warning (Anna Henningsen) [#13014](https://github.com/nodejs/node/pull/13014)
* [[`a128219a48`](https://github.com/nodejs/node/commit/a128219a48)] - **n-api**: Handle fatal exception in async callback (Jason Ginchereau) [#12838](https://github.com/nodejs/node/pull/12838)
* [[`2e36365d56`](https://github.com/nodejs/node/commit/2e36365d56)] - **n-api**: napi\_get\_cb\_info should fill array (Jason Ginchereau) [#12863](https://github.com/nodejs/node/pull/12863)
* [[`7507d1e0e6`](https://github.com/nodejs/node/commit/7507d1e0e6)] - **n-api**: remove unnecessary try-catch bracket from certain APIs (Gabriel Schulhof) [#12705](https://github.com/nodejs/node/pull/12705)
* [[`49d74c648d`](https://github.com/nodejs/node/commit/49d74c648d)] - **n-api**: Sync with back-compat changes (Jason Ginchereau) [#12674](https://github.com/nodejs/node/pull/12674)
* [[`bc252509ca`](https://github.com/nodejs/node/commit/bc252509ca)] - **n-api**: Reference and external tests (Jason Ginchereau) [#12551](https://github.com/nodejs/node/pull/12551)
* [[`c560db9ece`](https://github.com/nodejs/node/commit/c560db9ece)] - **n-api**: Enable scope and ref APIs during exception (Jason Ginchereau) [#12524](https://github.com/nodejs/node/pull/12524)
* [[`8287e7671a`](https://github.com/nodejs/node/commit/8287e7671a)] - **n-api**: tighten null-checking and clean up last error (Gabriel Schulhof) [#12539](https://github.com/nodejs/node/pull/12539)
* [[`f5cfa09ca4`](https://github.com/nodejs/node/commit/f5cfa09ca4)] - **n-api**: remove napi\_get\_value\_string\_length() (Jason Ginchereau) [#12496](https://github.com/nodejs/node/pull/12496)
* [[`c44f6ffc3c`](https://github.com/nodejs/node/commit/c44f6ffc3c)] - **n-api**: fix coverity scan report (Michael Dawson) [#12365](https://github.com/nodejs/node/pull/12365)
* [[`9bf8e9d48c`](https://github.com/nodejs/node/commit/9bf8e9d48c)] - **n-api**: add string api for latin1 encoding (Sampson Gao) [#12368](https://github.com/nodejs/node/pull/12368)
* [[`eb51d42d2b`](https://github.com/nodejs/node/commit/eb51d42d2b)] - **n-api**: fix -Wmismatched-tags compiler warning (Ben Noordhuis) [#12333](https://github.com/nodejs/node/pull/12333)
* [[`d82fd2a9a0`](https://github.com/nodejs/node/commit/d82fd2a9a0)] - **n-api**: implement async helper methods (taylor.woll) [#12250](https://github.com/nodejs/node/pull/12250)
* [[`c127b71526`](https://github.com/nodejs/node/commit/c127b71526)] - **n-api**: change napi\_callback to return napi\_value (Taylor Woll) [#12248](https://github.com/nodejs/node/pull/12248)
* [[`2a726223ea`](https://github.com/nodejs/node/commit/2a726223ea)] - **n-api**: cache Symbol.hasInstance (Gabriel Schulhof) [#12246](https://github.com/nodejs/node/pull/12246)
* [[`db36ca5f91`](https://github.com/nodejs/node/commit/db36ca5f91)] - **n-api**: Update property attrs enum to match JS spec (Jason Ginchereau) [#12240](https://github.com/nodejs/node/pull/12240)
* [[`1e6d3bb841`](https://github.com/nodejs/node/commit/1e6d3bb841)] - **n-api**: create napi\_env as a real structure (Gabriel Schulhof) [#12195](https://github.com/nodejs/node/pull/12195)
* [[`f1bdbd17d0`](https://github.com/nodejs/node/commit/f1bdbd17d0)] - **n-api**: break dep between v8 and napi attributes (Michael Dawson) [#12191](https://github.com/nodejs/node/pull/12191)
* [[`a9562fe30c`](https://github.com/nodejs/node/commit/a9562fe30c)] - **n-api**: add support for abi stable module API (Jason Ginchereau) [#11975](https://github.com/nodejs/node/pull/11975)
* [[`aa0fb7761e`](https://github.com/nodejs/node/commit/aa0fb7761e)] - **n-api,test**: add int64 bounds tests (Kyle Farnung) [#19309](https://github.com/nodejs/node/pull/19309)
* [[`3f6d80e25c`](https://github.com/nodejs/node/commit/3f6d80e25c)] - **n-api,test**: add a new.target test to addons-napi (Taylor Woll) [#19236](https://github.com/nodejs/node/pull/19236)
* [[`011b53e28f`](https://github.com/nodejs/node/commit/011b53e28f)] - **n-api,test**: use module name macro (Gabriel Schulhof) [#16146](https://github.com/nodejs/node/pull/16146)
* [[`a6af97f76c`](https://github.com/nodejs/node/commit/a6af97f76c)] - **napi**: initialize and check status properly (Gabriel Schulhof) [#12283](https://github.com/nodejs/node/pull/12283)
* [[`9b36811d8e`](https://github.com/nodejs/node/commit/9b36811d8e)] - **napi**: supress invalid coverity leak message (Michael Dawson) [#12192](https://github.com/nodejs/node/pull/12192)
* [[`269c2f3ad9`](https://github.com/nodejs/node/commit/269c2f3ad9)] - **net**: remove redundant code from \_writeGeneric() (Luigi Pinca) [#18429](https://github.com/nodejs/node/pull/18429)
* [[`988cca841e`](https://github.com/nodejs/node/commit/988cca841e)] - **process**: fix reading zero-length env vars on win32 (Anna Henningsen) [#18463](https://github.com/nodejs/node/pull/18463)
* [[`72a5710b71`](https://github.com/nodejs/node/commit/72a5710b71)] - **readline**: update references to archived repository (Tobias Nießen) [#17924](https://github.com/nodejs/node/pull/17924)
* [[`b20c278a7c`](https://github.com/nodejs/node/commit/b20c278a7c)] - **src**: add napi\_handle\_scope\_mismatch to msg list (neta) [#17161](https://github.com/nodejs/node/pull/17161)
* [[`0ef0b342e9`](https://github.com/nodejs/node/commit/0ef0b342e9)] - **src**: replace assert with CHECK\_LE in node\_api.cc (Ben Noordhuis) [#14514](https://github.com/nodejs/node/pull/14514)
* [[`a8c73748db`](https://github.com/nodejs/node/commit/a8c73748db)] - **src**: correct endif comment SRC\_NODE\_API\_H\_\_ (Daniel Bevenius) [#13190](https://github.com/nodejs/node/pull/13190)
* [[`0ca2dad3a6`](https://github.com/nodejs/node/commit/0ca2dad3a6)] - **src**: free memory before re-setting URLHost value (Ivan Filenko) [#18357](https://github.com/nodejs/node/pull/18357)
* [[`e54b8e8184`](https://github.com/nodejs/node/commit/e54b8e8184)] - **stream**: cleanup() when unpiping all streams. (陈刚) [#18266](https://github.com/nodejs/node/pull/18266)
* [[`8ab8d6afd6`](https://github.com/nodejs/node/commit/8ab8d6afd6)] - **stream**: fix y.pipe(x)+y.pipe(x)+y.unpipe(x) (Anna Henningsen) [#12746](https://github.com/nodejs/node/pull/12746)
* [[`8f830ca896`](https://github.com/nodejs/node/commit/8f830ca896)] - **stream**: remove unreachable code (Luigi Pinca) [#18239](https://github.com/nodejs/node/pull/18239)
* [[`64c83d7da9`](https://github.com/nodejs/node/commit/64c83d7da9)] - **stream**: simplify `src._readableState` to `state` (陈刚) [#18264](https://github.com/nodejs/node/pull/18264)
* [[`7c58045470`](https://github.com/nodejs/node/commit/7c58045470)] - **test**: remove unnecessary timer (cjihrig) [#18719](https://github.com/nodejs/node/pull/18719)
* [[`c90b77ed5d`](https://github.com/nodejs/node/commit/c90b77ed5d)] - **test**: convert new tests to use error types (Jack Horton) [#18581](https://github.com/nodejs/node/pull/18581)
* [[`7f37dc9c48`](https://github.com/nodejs/node/commit/7f37dc9c48)] - **test**: improve error message output (Bhavani Shankar) [#18498](https://github.com/nodejs/node/pull/18498)
* [[`59249a1768`](https://github.com/nodejs/node/commit/59249a1768)] - **test**: show pending exception error in napi tests (Ben Wilcox) [#18413](https://github.com/nodejs/node/pull/18413)
* [[`eceb70b584`](https://github.com/nodejs/node/commit/eceb70b584)] - **test**: refactor addons-napi/test\_exception/test.js (Rich Trott) [#18340](https://github.com/nodejs/node/pull/18340)
* [[`b3806ecd39`](https://github.com/nodejs/node/commit/b3806ecd39)] - **test**: fixed typos in napi test (furstenheim) [#18148](https://github.com/nodejs/node/pull/18148)
* [[`a6c277e2eb`](https://github.com/nodejs/node/commit/a6c277e2eb)] - **test**: remove ambiguous error messages from test\_error (Nicholas Drane) [#17812](https://github.com/nodejs/node/pull/17812)
* [[`412cc17748`](https://github.com/nodejs/node/commit/412cc17748)] - **test**: remove literals that obscure assert messages (Rich Trott) [#17642](https://github.com/nodejs/node/pull/17642)
* [[`86ddd03608`](https://github.com/nodejs/node/commit/86ddd03608)] - **test**: add unhandled rejection guard (babygoat) [#17275](https://github.com/nodejs/node/pull/17275)
* [[`e54b58c024`](https://github.com/nodejs/node/commit/e54b58c024)] - **test**: replace assert.throws with common.expectsError (Leko) [#17445](https://github.com/nodejs/node/pull/17445)
* [[`976f32d189`](https://github.com/nodejs/node/commit/976f32d189)] - **test**: refactor addons-napi/test\_promise/test.js (ka3e) [#16814](https://github.com/nodejs/node/pull/16814)
* [[`2476ab9619`](https://github.com/nodejs/node/commit/2476ab9619)] - **test**: improve error emssage reporting in testNapiRun.js (Paul Ashfield) [#16821](https://github.com/nodejs/node/pull/16821)
* [[`d4c04e05f7`](https://github.com/nodejs/node/commit/d4c04e05f7)] - **test**: improve assert messages in napi exception test (Paul Blanche) [#16820](https://github.com/nodejs/node/pull/16820)
* [[`c14207c77b`](https://github.com/nodejs/node/commit/c14207c77b)] - **test**: add detailed message for assertion failure (Attila Gonda) [#16812](https://github.com/nodejs/node/pull/16812)
* [[`d31792fcbe`](https://github.com/nodejs/node/commit/d31792fcbe)] - **test**: use default assertion messages (John Byrne) [#16808](https://github.com/nodejs/node/pull/16808)
* [[`087d213f67`](https://github.com/nodejs/node/commit/087d213f67)] - **test**: include actual value in assertion message (Matthew Cantelon) [#15935](https://github.com/nodejs/node/pull/15935)
* [[`9cc435dc85`](https://github.com/nodejs/node/commit/9cc435dc85)] - **test**: improve message for assert.strictEqual() (Jayson D. Henkel) [#16013](https://github.com/nodejs/node/pull/16013)
* [[`ebbd07dd27`](https://github.com/nodejs/node/commit/ebbd07dd27)] - **test**: remove redundant error messages (Christina Chan) [#16043](https://github.com/nodejs/node/pull/16043)
* [[`5bba809e01`](https://github.com/nodejs/node/commit/5bba809e01)] - **test**: cleaned up assert messages (mrgorbo) [#16032](https://github.com/nodejs/node/pull/16032)
* [[`53bd313739`](https://github.com/nodejs/node/commit/53bd313739)] - **test**: fix race condition in addon test (Kinnan Kwok) [#16037](https://github.com/nodejs/node/pull/16037)
* [[`37acd806be`](https://github.com/nodejs/node/commit/37acd806be)] - **test**: remove template literal (Emily Ford) [#15953](https://github.com/nodejs/node/pull/15953)
* [[`31c97178c1`](https://github.com/nodejs/node/commit/31c97178c1)] - **test**: remove unused parameters (Daniil Shakir) [#14968](https://github.com/nodejs/node/pull/14968)
* [[`b59eddd082`](https://github.com/nodejs/node/commit/b59eddd082)] - **test**: use regular expressions in throw assertions (Vincent Xue) [#14318](https://github.com/nodejs/node/pull/14318)
* [[`06b1273464`](https://github.com/nodejs/node/commit/06b1273464)] - **test**: changed error message validator (Pratik Jain) [#14443](https://github.com/nodejs/node/pull/14443)
* [[`3f3eaf9961`](https://github.com/nodejs/node/commit/3f3eaf9961)] - **test**: replace string concat with template literal (Song, Bintao Garfield) [#14269](https://github.com/nodejs/node/pull/14269)
* [[`48274213b1`](https://github.com/nodejs/node/commit/48274213b1)] - **test**: handle missing V8 tests in n-api test (cjihrig) [#14123](https://github.com/nodejs/node/pull/14123)
* [[`7f126c2069`](https://github.com/nodejs/node/commit/7f126c2069)] - **test**: add coverage for napi\_typeof (Michael Dawson) [#13990](https://github.com/nodejs/node/pull/13990)
* [[`a0cf9b7a73`](https://github.com/nodejs/node/commit/a0cf9b7a73)] - **test**: verify napi\_get\_property() walks prototype (cjihrig) [#13961](https://github.com/nodejs/node/pull/13961)
* [[`1e25062fa1`](https://github.com/nodejs/node/commit/1e25062fa1)] - **test**: add coverage for napi\_property\_descriptor (Michael Dawson) [#13510](https://github.com/nodejs/node/pull/13510)
* [[`eb422796cd`](https://github.com/nodejs/node/commit/eb422796cd)] - **test**: fix build warning in addons-napi/test\_object (Jason Ginchereau) [#13412](https://github.com/nodejs/node/pull/13412)
* [[`9d70b43bdc`](https://github.com/nodejs/node/commit/9d70b43bdc)] - **test**: consolidate n-api test addons - part2 (Michael Dawson) [#13380](https://github.com/nodejs/node/pull/13380)
* [[`06cf9480d3`](https://github.com/nodejs/node/commit/06cf9480d3)] - **test**: consolidate n-api test addons (Michael Dawson) [#13317](https://github.com/nodejs/node/pull/13317)
* [[`652d3218fe`](https://github.com/nodejs/node/commit/652d3218fe)] - **test**: Make N-API weak-ref GC tests asynchronous (Jason Ginchereau) [#13121](https://github.com/nodejs/node/pull/13121)
* [[`0dac33d4f2`](https://github.com/nodejs/node/commit/0dac33d4f2)] - **test**: improve n-api coverage for typed arrays (Michael Dawson) [#13244](https://github.com/nodejs/node/pull/13244)
* [[`1829d25907`](https://github.com/nodejs/node/commit/1829d25907)] - **test**: add coverage for napi\_has\_named\_property (Michael Dawson) [#13178](https://github.com/nodejs/node/pull/13178)
* [[`d89afe8685`](https://github.com/nodejs/node/commit/d89afe8685)] - **test**: increase n-api constructor coverage (Michael Dawson) [#13124](https://github.com/nodejs/node/pull/13124)
* [[`71aa251671`](https://github.com/nodejs/node/commit/71aa251671)] - **test**: Improve N-API test coverage (Michael Dawson) [#13044](https://github.com/nodejs/node/pull/13044)
* [[`314f22dcf4`](https://github.com/nodejs/node/commit/314f22dcf4)] - **test**: improve N-API test coverage (Michael Dawson) [#13006](https://github.com/nodejs/node/pull/13006)
* [[`263a633d5e`](https://github.com/nodejs/node/commit/263a633d5e)] - **test**: add common.mustCall() to NAPI exception test (Rich Trott) [#12959](https://github.com/nodejs/node/pull/12959)
* [[`5936f7c9bb`](https://github.com/nodejs/node/commit/5936f7c9bb)] - **test**: improve n-api array func coverage (Michael Dawson) [#12890](https://github.com/nodejs/node/pull/12890)
* [[`ce03977f30`](https://github.com/nodejs/node/commit/ce03977f30)] - **test**: fix napi test\_reference for recent V8 (Michaël Zasso) [#12864](https://github.com/nodejs/node/pull/12864)
* [[`dd7665a68e`](https://github.com/nodejs/node/commit/dd7665a68e)] - **test**: port test for make\_callback to n-api (Hitesh Kanwathirtha) [#12409](https://github.com/nodejs/node/pull/12409)
* [[`f09677fdba`](https://github.com/nodejs/node/commit/f09677fdba)] - **test**: add coverage for error apis (Michael Dawson) [#12729](https://github.com/nodejs/node/pull/12729)
* [[`1785f3cf44`](https://github.com/nodejs/node/commit/1785f3cf44)] - **test**: fix warning in n-api reference test (Michael Dawson) [#12730](https://github.com/nodejs/node/pull/12730)
* [[`5d2afb2174`](https://github.com/nodejs/node/commit/5d2afb2174)] - **test**: replace indexOf with includes (gwer) [#12604](https://github.com/nodejs/node/pull/12604)
* [[`fcb019f6ea`](https://github.com/nodejs/node/commit/fcb019f6ea)] - **test**: add coverage for napi\_cancel\_async\_work (Michael Dawson) [#12575](https://github.com/nodejs/node/pull/12575)
* [[`72c5d976f1`](https://github.com/nodejs/node/commit/72c5d976f1)] - **test**: test doc'd napi\_get\_value\_int32 behaviour (Michael Dawson) [#12633](https://github.com/nodejs/node/pull/12633)
* [[`d9f3e0dd83`](https://github.com/nodejs/node/commit/d9f3e0dd83)] - ***Revert*** "**test**: port test for make\_callback to n-api" (James M Snell) [#12475](https://github.com/nodejs/node/pull/12475)
* [[`a003777d96`](https://github.com/nodejs/node/commit/a003777d96)] - **test**: port test for make\_callback to n-api (Hitesh Kanwathirtha) [#12409](https://github.com/nodejs/node/pull/12409)
* [[`577f327d2c`](https://github.com/nodejs/node/commit/577f327d2c)] - **test**: fix compiler warning in n-api test (Anna Henningsen) [#12318](https://github.com/nodejs/node/pull/12318)
* [[`f8c2585fe0`](https://github.com/nodejs/node/commit/f8c2585fe0)] - **test**: add second argument to assert.throws (Michaël Zasso) [#12270](https://github.com/nodejs/node/pull/12270)
* [[`6bf3d04d6c`](https://github.com/nodejs/node/commit/6bf3d04d6c)] - **test**: improve test coverage for n-api (Michael Dawson) [#12327](https://github.com/nodejs/node/pull/12327)
* [[`d799b1cb61`](https://github.com/nodejs/node/commit/d799b1cb61)] - **test**: update a few tests to work on OpenBSD (Aaron Bieber) [#18543](https://github.com/nodejs/node/pull/18543)
* [[`bc883fb136`](https://github.com/nodejs/node/commit/bc883fb136)] - **test**: refactor test-http-abort-before-end (cjihrig) [#18508](https://github.com/nodejs/node/pull/18508)
* [[`44ab85018c`](https://github.com/nodejs/node/commit/44ab85018c)] - **test**: fix flaky timers-block-eventloop test (Anatoli Papirovski) [#18567](https://github.com/nodejs/node/pull/18567)
* [[`5bcf668f42`](https://github.com/nodejs/node/commit/5bcf668f42)] - **test**: use correct size in test-stream-buffer-list (Luigi Pinca) [#18239](https://github.com/nodejs/node/pull/18239)
* [[`f3c6febedf`](https://github.com/nodejs/node/commit/f3c6febedf)] - **test**: update references to archived repository (Tobias Nießen) [#17924](https://github.com/nodejs/node/pull/17924)
* [[`b2a2a55271`](https://github.com/nodejs/node/commit/b2a2a55271)] - **test**: verify the shell option works properly on execFile (jvelezpo) [#18384](https://github.com/nodejs/node/pull/18384)
* [[`fd7d1990db`](https://github.com/nodejs/node/commit/fd7d1990db)] - **test**: remove orphaned entries from status (Kyle Farnung) [#19042](https://github.com/nodejs/node/pull/19042)
* [[`5ca8dee8cb`](https://github.com/nodejs/node/commit/5ca8dee8cb)] - **test**: remove n-api intermediate files (Gabriel Schulhof) [#19375](https://github.com/nodejs/node/pull/19375)
* [[`46aed5800f`](https://github.com/nodejs/node/commit/46aed5800f)] - **test**: make common.mustNotCall show file:linenumber (Lance Ball) [#17257](https://github.com/nodejs/node/pull/17257)
* [[`4d2efa2415`](https://github.com/nodejs/node/commit/4d2efa2415)] - **test**: remove mark flaky for moved test (Beth Griggs) [#19069](https://github.com/nodejs/node/pull/19069)
* [[`502781c1d7`](https://github.com/nodejs/node/commit/502781c1d7)] - **test**: fix spelling in test case comments (Tobias Nießen) [#18018](https://github.com/nodejs/node/pull/18018)
* [[`b2bf6c873f`](https://github.com/nodejs/node/commit/b2bf6c873f)] - **test,lib,doc**: use function declarations (Rich Trott) [#12711](https://github.com/nodejs/node/pull/12711)
* [[`a91b1b928c`](https://github.com/nodejs/node/commit/a91b1b928c)] - **win, build**: fix intl-none option (Birunthan Mohanathas) [#18292](https://github.com/nodejs/node/pull/18292)
* [[`6ff763bd66`](https://github.com/nodejs/node/commit/6ff763bd66)] - **win, build**: fix without-intl option (Bartosz Sosnowski) [#17614](https://github.com/nodejs/node/pull/17614)

<a id="6.14.1"></a>
## 2018-03-29, Version 6.14.1 'Boron' (LTS), @MylesBorins

### Notable Changes

No additional commits.

Due to incorrect staging of the upgrade to the GCC 4.9.X compiler, the latest releases for PPC little
endian were built using GCC 4.9.X instead of GCC 4.8.X. This caused an ABI breakage on PPCLE based
environments. This has been fixed in our infrastructure and we are doing this release to ensure that
the hosted binaries are adhering to our platform support contract.

<a id="6.14.0"></a>
## 2018-03-28, Version 6.14.0 'Boron' (LTS), @MylesBorins

This is a security release. All Node.js users should consult the security release summary at https://nodejs.org/en/blog/vulnerability/march-2018-security-releases/ for details on patched vulnerabilities.

Fixes for the following CVEs are included in this release:

* CVE-2018-7158
* CVE-2018-7159
* CVE-2018-7160

### Notable Changes

* **Upgrade to OpenSSL 1.0.2o**: Does not contain any security fixes that are known to impact Node.js.
* **Fix for inspector DNS rebinding vulnerability (CVE-2018-7160)**: A malicious website could use a DNS rebinding attack to trick a web browser to bypass same-origin-policy checks and allow HTTP connections to localhost or to hosts on the local network, potentially to an open inspector port as a debugger, therefore gaining full code execution access. The inspector now only allows connections that have a browser `Host` value of `localhost` or `localhost6`.
* **Fix for `'path'` module regular expression denial of service (CVE-2018-7158)**: A regular expression used for parsing POSIX paths could be used to cause a denial of service if an attacker were able to have a specially crafted path string passed through one of the impacted `'path'` module functions.
* **Reject spaces in HTTP `Content-Length` header values (CVE-2018-7159)**: The Node.js HTTP parser allowed for spaces inside `Content-Length` header values. Such values now lead to rejected connections in the same way as non-numeric values.
* **Update root certificates**: 5 additional root certificates have been added to the Node.js binary and 30 have been removed.

### Commits

* [[`ac21bdc149`](https://github.com/nodejs/node/commit/ac21bdc149)] - **crypto**: update root certificates (Ben Noordhuis) [#19322](https://github.com/nodejs/node/pull/19322)
* [[`3c99e41427`](https://github.com/nodejs/node/commit/3c99e41427)] - **deps**: add -no\_rand\_screen to openssl s\_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`d775057090`](https://github.com/nodejs/node/commit/d775057090)] - **deps**: fix asm build error of openssl in x86\_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`982012b96d`](https://github.com/nodejs/node/commit/982012b96d)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`1aa83f7707`](https://github.com/nodejs/node/commit/1aa83f7707)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu) [#19638](https://github.com/nodejs/node/pull/19638)
* [[`05de6f4af7`](https://github.com/nodejs/node/commit/05de6f4af7)] - **deps**: upgrade openssl sources to 1.0.2o (Shigeki Ohtsu) [#19638](https://github.com/nodejs/node/pull/19638)
* [[`ed64cc2be7`](https://github.com/nodejs/node/commit/ed64cc2be7)] - **deps**: reject interior blanks in Content-Length (Ben Noordhuis) [nodejs-private/http-parser-private#1](https://github.com/nodejs-private/http-parser-private/pull/1)
* [[`d786d21f92`](https://github.com/nodejs/node/commit/d786d21f92)] - **deps**: upgrade http-parser to v2.8.0 (Ben Noordhuis) [nodejs-private/http-parser-private#1](https://github.com/nodejs-private/http-parser-private/pull/1)
* [[`4947b0e26e`](https://github.com/nodejs/node/commit/4947b0e26e)] - **inspector**: minor adjustments (Eugene Ostroukhov)
* [[`e3950d1a40`](https://github.com/nodejs/node/commit/e3950d1a40)] - **inspector**: check Host header (Ali Ijaz Sheikh)
* [[`ef32e06a6e`](https://github.com/nodejs/node/commit/ef32e06a6e)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`1dba2f4950`](https://github.com/nodejs/node/commit/1dba2f4950)] - **src**: drop CNNIC+StartCom certificate whitelisting (Ben Noordhuis) [#19322](https://github.com/nodejs/node/pull/19322)
* [[`bdfeb1c739`](https://github.com/nodejs/node/commit/bdfeb1c739)] - **tools**: update certdata.txt (Ben Noordhuis) [#19322](https://github.com/nodejs/node/pull/19322)

<a id="6.13.1"></a>
## 2018-03-06, Version 6.13.1 'Boron' (LTS), @MylesBorins

### Notable Changes

* **http, tls**:
  * better support for IPv6 addresses (Mattias Holmlund) [#14772](https://github.com/nodejs/node/pull/14772)

### Commits

* [[`d333ba5e2a`](https://github.com/nodejs/node/commit/d333ba5e2a)] - **doc**: add vdeturckheim as collaborator (vdeturckheim) [#18432](https://github.com/nodejs/node/pull/18432)
* [[`7fc5c69a4a`](https://github.com/nodejs/node/commit/7fc5c69a4a)] - **doc**: use PBKDF2 in text (Tobias Nießen) [#18279](https://github.com/nodejs/node/pull/18279)
* [[`1e8d1200ce`](https://github.com/nodejs/node/commit/1e8d1200ce)] - **doc**: Add example of null to assert.ifError (Leko) [#18236](https://github.com/nodejs/node/pull/18236)
* [[`46e43111af`](https://github.com/nodejs/node/commit/46e43111af)] - **doc**: V8 branch used in 8.x not active anymore (Franziska Hinkelmann) [#18155](https://github.com/nodejs/node/pull/18155)
* [[`b83b104c17`](https://github.com/nodejs/node/commit/b83b104c17)] - **doc**: add builtin module in building.md (Suixinlei) [#17705](https://github.com/nodejs/node/pull/17705)
* [[`2e76df5b4e`](https://github.com/nodejs/node/commit/2e76df5b4e)] - **doc**: warn users about non-ASCII paths on build (Matheus Marchini) [#16735](https://github.com/nodejs/node/pull/16735)
* [[`2c21421092`](https://github.com/nodejs/node/commit/2c21421092)] - **doc**: simplify sentences that use "considered" (Rich Trott) [#18095](https://github.com/nodejs/node/pull/18095)
* [[`8f9362d6e8`](https://github.com/nodejs/node/commit/8f9362d6e8)] - **doc**: add documentation for deprecation properties (Jon Moss) [#16539](https://github.com/nodejs/node/pull/16539)
* [[`1505b71dab`](https://github.com/nodejs/node/commit/1505b71dab)] - **doc**: add Leko to collaborators (Leko) [#18117](https://github.com/nodejs/node/pull/18117)
* [[`838f7bdb6e`](https://github.com/nodejs/node/commit/838f7bdb6e)] - **doc**: be less tentative about undefined behavior (Rich Trott) [#18091](https://github.com/nodejs/node/pull/18091)
* [[`17c88c4c18`](https://github.com/nodejs/node/commit/17c88c4c18)] - **doc**: examples for fast-tracking regression fixes (Refael Ackermann) [#17379](https://github.com/nodejs/node/pull/17379)
* [[`e021fb73d2`](https://github.com/nodejs/node/commit/e021fb73d2)] - **doc,test**: mention Duplex support for TLS (Anna Henningsen) [#17599](https://github.com/nodejs/node/pull/17599)
* [[`df038ad90f`](https://github.com/nodejs/node/commit/df038ad90f)] - **fs**: fix options.end of fs.ReadStream() (陈刚) [#18121](https://github.com/nodejs/node/pull/18121)
* [[`8e7ac25aa6`](https://github.com/nodejs/node/commit/8e7ac25aa6)] - **http, tls**: better support for IPv6 addresses (Mattias Holmlund) [#14772](https://github.com/nodejs/node/pull/14772)
* [[`969c39eb3a`](https://github.com/nodejs/node/commit/969c39eb3a)] - **lib**: enable dot-notation eslint rule (Anatoli Papirovski) [#18007](https://github.com/nodejs/node/pull/18007)
* [[`37071b8dda`](https://github.com/nodejs/node/commit/37071b8dda)] - **path**: fix path.normalize for relative paths (Weijia Wang) [#17974](https://github.com/nodejs/node/pull/17974)
* [[`fdf73b110f`](https://github.com/nodejs/node/commit/fdf73b110f)] - **test**: preserve env in test cases (Beth Griggs) [#14822](https://github.com/nodejs/node/pull/14822)
* [[`bb2d292562`](https://github.com/nodejs/node/commit/bb2d292562)] - **test**: change assert message to default (ryanmahan) [#18259](https://github.com/nodejs/node/pull/18259)
* [[`27107b957c`](https://github.com/nodejs/node/commit/27107b957c)] - **test**: use countdown timer (Mandeep Singh) [#17326](https://github.com/nodejs/node/pull/17326)
* [[`eaa30e4947`](https://github.com/nodejs/node/commit/eaa30e4947)] - **test**: simplify loadDHParam in TLS test (Tobias Nießen) [#18103](https://github.com/nodejs/node/pull/18103)
* [[`2004efded8`](https://github.com/nodejs/node/commit/2004efded8)] - **test**: improve to use template string (sreepurnajasti) [#18097](https://github.com/nodejs/node/pull/18097)
* [[`16ef24bccf`](https://github.com/nodejs/node/commit/16ef24bccf)] - **test**: use smaller input file for test-zlib.js (Rich Trott) [#17988](https://github.com/nodejs/node/pull/17988)
* [[`48790382f1`](https://github.com/nodejs/node/commit/48790382f1)] - **tools**: add number-isnan rule (Jon Moss) [#17556](https://github.com/nodejs/node/pull/17556)

<a id="6.13.0"></a>
## 2018-02-13, Version 6.13.0 'Boron' (LTS), @MylesBorins

This LTS release comes with 112 commits, 17 of which are considered Semver-Minor. This includes 32 which are doc related,
31 which are test related, 8 which are build / tool related and 1 commit which updates a dependency.

### Notable Changes

* **console**:
  * added console.count() and console.clear() (James M Snell) [#12678](https://github.com/nodejs/node/pull/12678)
* **crypto**:
  * expose ECDH class (Bryan English) [#8188](https://github.com/nodejs/node/pull/8188)
  * added cypto.randomFill() and crypto.randomFillSync() (Evan Lucas) [#10209](https://github.com/nodejs/node/pull/10209)
  * warn on invalid authentication tag length (Tobias Nießen) [#17566](https://github.com/nodejs/node/pull/17566)
* **deps**:
  * upgrade libuv to 1.16.1 (cjihrig) [#16835](https://github.com/nodejs/node/pull/16835)
* **dgram**:
  * added socket.setMulticastInterface() (Will Young) [#7855](https://github.com/nodejs/node/pull/7855)
* **http**:
  * add agent.keepSocketAlive and agent.reuseSocket as to allow overridable keep-alive behavior of `Agent` (Fedor Indutny) [#13005](https://github.com/nodejs/node/pull/13005)
* **lib**:
  * return this from net.Socket.end() (Sam Roberts) [#13481](https://github.com/nodejs/node/pull/13481)
* **module**:
  * add builtinModules api that provides list of all builtin modules in Node (Jon Moss) [#16386](https://github.com/nodejs/node/pull/16386)
* **net**:
  * return this from getConnections() (Sam Roberts) [#13553](https://github.com/nodejs/node/pull/13553)
* **promises**:
  * more robust stringification for unhandled rejections (Timothy Gu) [#13784](https://github.com/nodejs/node/pull/13784)
* **repl**:
  * improve require() autocompletion (Alexey Orlenko) [#14409](https://github.com/nodejs/node/pull/14409)
* **src**:
  * add openssl-system-ca-path configure option (Daniel Bevenius) [#16790](https://github.com/nodejs/node/pull/16790)
  * add --use-bundled-ca --use-openssl-ca check (Daniel Bevenius) [#12087](https://github.com/nodejs/node/pull/12087)
  * add process.ppid (cjihrig) [#16839](https://github.com/nodejs/node/pull/16839)
* **tls**:
  * accept `lookup` option for `tls.connect()` (Fedor Indutny) [#12839](https://github.com/nodejs/node/pull/12839)
* **tools, build**:
  * a new macOS installer! (JP Wesselink) [#15179](https://github.com/nodejs/node/pull/15179)
* **url**:
  * WHATWG URL api support (James M Snell) [#7448](https://github.com/nodejs/node/pull/7448)
* **util**:
  * add %i and %f formatting specifiers (Roman Reiss) [#10308](https://github.com/nodejs/node/pull/10308)

### Commits

* [[`6f33953d90`](https://github.com/nodejs/node/commit/6f33953d90)] - **benchmark**: fix timeout in write-stream-throughput (Anatoli Papirovski) [#17958](https://github.com/nodejs/node/pull/17958)
* [[`ce136392fb`](https://github.com/nodejs/node/commit/ce136392fb)] - **(SEMVER-MINOR)** **console**: add console.count() and console.clear() (James M Snell) [#12678](https://github.com/nodejs/node/pull/12678)
* [[`691cd5a3d1`](https://github.com/nodejs/node/commit/691cd5a3d1)] - **crypto**: warn on invalid authentication tag length (Tobias Nießen) [#17566](https://github.com/nodejs/node/pull/17566)
* [[`4b4e4db1c1`](https://github.com/nodejs/node/commit/4b4e4db1c1)] - **crypto**: add ocsp_request ClientHelloParser::Reset (Daniel Bevenius) [#17753](https://github.com/nodejs/node/pull/17753)
* [[`c377d2299a`](https://github.com/nodejs/node/commit/c377d2299a)] - **crypto**: remove unused header in clienthello.h (Daniel Bevenius) [#17752](https://github.com/nodejs/node/pull/17752)
* [[`ddd9d85681`](https://github.com/nodejs/node/commit/ddd9d85681)] - **crypto**: remove BIO_set_shutdown (Daniel Bevenius) [#17542](https://github.com/nodejs/node/pull/17542)
* [[`f3b3437e48`](https://github.com/nodejs/node/commit/f3b3437e48)] - **(SEMVER-MINOR)** **crypto**: expose ECDH class (Bryan English) [#8188](https://github.com/nodejs/node/pull/8188)
* [[`6f62f83468`](https://github.com/nodejs/node/commit/6f62f83468)] - **(SEMVER-MINOR)** **crypto**: add randomFill and randomFillSync (Evan Lucas) [#10209](https://github.com/nodejs/node/pull/10209)
* [[`a1d7469aef`](https://github.com/nodejs/node/commit/a1d7469aef)] - **(SEMVER-MINOR)** **deps**: upgrade libuv to 1.16.1 (cjihrig) [#16835](https://github.com/nodejs/node/pull/16835)
* [[`8f2e52abd7`](https://github.com/nodejs/node/commit/8f2e52abd7)] - **(SEMVER-MINOR)** **dgram**: added setMulticastInterface() (Will Young) [#7855](https://github.com/nodejs/node/pull/7855)
* [[`1b689863ee`](https://github.com/nodejs/node/commit/1b689863ee)] - **doc**: remove x86 from os.arch() options (Gibson Fahnestock) [#17899](https://github.com/nodejs/node/pull/17899)
* [[`8f80548b7f`](https://github.com/nodejs/node/commit/8f80548b7f)] - **doc**: move matthewloring to emeriti (Rich Trott) [#17998](https://github.com/nodejs/node/pull/17998)
* [[`15d0ed5f33`](https://github.com/nodejs/node/commit/15d0ed5f33)] - **doc**: move joshgav to TSC emeriti list (Rich Trott) [#17953](https://github.com/nodejs/node/pull/17953)
* [[`12db4d97b2`](https://github.com/nodejs/node/commit/12db4d97b2)] - **doc**: improve security section of README.md (Rich Trott) [#17929](https://github.com/nodejs/node/pull/17929)
* [[`b79189b9b6`](https://github.com/nodejs/node/commit/b79189b9b6)] - **doc**: copy-edit COLLABORATOR_GUIDE.md (Rich Trott) [#17922](https://github.com/nodejs/node/pull/17922)
* [[`7628640db6`](https://github.com/nodejs/node/commit/7628640db6)] - **doc**: improve alt text (Rich Trott) [#17922](https://github.com/nodejs/node/pull/17922)
* [[`bb022dbb96`](https://github.com/nodejs/node/commit/bb022dbb96)] - **doc**: fix spelling of contributors (Rich Trott) [#17922](https://github.com/nodejs/node/pull/17922)
* [[`21c5d820bb`](https://github.com/nodejs/node/commit/21c5d820bb)] - **doc**: add references to PR communication articles (Salame William) [#17902](https://github.com/nodejs/node/pull/17902)
* [[`3c3a631643`](https://github.com/nodejs/node/commit/3c3a631643)] - **doc**: fix typo (Tobias Nießen) [#17900](https://github.com/nodejs/node/pull/17900)
* [[`5b00ee31ee`](https://github.com/nodejs/node/commit/5b00ee31ee)] - **doc**: use my legal name in README (Timothy Gu) [#17894](https://github.com/nodejs/node/pull/17894)
* [[`0ce48f9094`](https://github.com/nodejs/node/commit/0ce48f9094)] - **doc**: use dashes instead of asterisks (Ruben Bridgewater) [#17722](https://github.com/nodejs/node/pull/17722)
* [[`f6b4aa62bc`](https://github.com/nodejs/node/commit/f6b4aa62bc)] - **doc**: update AUTHORS list (Ruben Bridgewater) [#17805](https://github.com/nodejs/node/pull/17805)
* [[`653c026578`](https://github.com/nodejs/node/commit/653c026578)] - **doc**: add starkwang to collaborators (Weijia Wang) [#17847](https://github.com/nodejs/node/pull/17847)
* [[`68164145de`](https://github.com/nodejs/node/commit/68164145de)] - **doc**: improve fs api descriptions (Evan Lucas) [#17679](https://github.com/nodejs/node/pull/17679)
* [[`722640f562`](https://github.com/nodejs/node/commit/722640f562)] - **doc**: instructions on how to make membership public (Michael Dawson) [#17688](https://github.com/nodejs/node/pull/17688)
* [[`1553c7326c`](https://github.com/nodejs/node/commit/1553c7326c)] - **doc**: removed extra explanation in api/buffer.md (Waleed Ashraf) [#17796](https://github.com/nodejs/node/pull/17796)
* [[`22607951b8`](https://github.com/nodejs/node/commit/22607951b8)] - **doc**: use american spelling as per style guide (sreepurnajasti) [#17818](https://github.com/nodejs/node/pull/17818)
* [[`d85840dd8f`](https://github.com/nodejs/node/commit/d85840dd8f)] - **doc**: require CI status indicator in PRs (Nikolai Vavilov) [#17151](https://github.com/nodejs/node/pull/17151)
* [[`5cc6dd6295`](https://github.com/nodejs/node/commit/5cc6dd6295)] - **doc**: remove duplicate the from onboarding.md (sreepurnajasti) [#17733](https://github.com/nodejs/node/pull/17733)
* [[`a6f7ba4f09`](https://github.com/nodejs/node/commit/a6f7ba4f09)] - **doc**: fix typo in README.md (Weijia Wang) [#17729](https://github.com/nodejs/node/pull/17729)
* [[`df48a5ded8`](https://github.com/nodejs/node/commit/df48a5ded8)] - **doc**: fix typo in child_process.md (Rich Trott) [#17727](https://github.com/nodejs/node/pull/17727)
* [[`4cba4324ff`](https://github.com/nodejs/node/commit/4cba4324ff)] - **doc**: improve release guide (Evan Lucas) [#17677](https://github.com/nodejs/node/pull/17677)
* [[`423ef3ddbf`](https://github.com/nodejs/node/commit/423ef3ddbf)] - **doc**: not all example code can be run without 1:1 (Jeremiah Senkpiel) [#17702](https://github.com/nodejs/node/pull/17702)
* [[`c683efbf6d`](https://github.com/nodejs/node/commit/c683efbf6d)] - **doc**: adjust TTY wording & add inter-doc links (Jeremiah Senkpiel) [#17702](https://github.com/nodejs/node/pull/17702)
* [[`14ffddd989`](https://github.com/nodejs/node/commit/14ffddd989)] - **doc**: add isTTY property documentation (SonaySevik) [#16828](https://github.com/nodejs/node/pull/16828)
* [[`9c8d0366b3`](https://github.com/nodejs/node/commit/9c8d0366b3)] - **doc**: fix fs.existsSync description (Jeremiah Senkpiel) [#17702](https://github.com/nodejs/node/pull/17702)
* [[`6abd4599af`](https://github.com/nodejs/node/commit/6abd4599af)] - **doc**: improve documentation.md (Jeremiah Senkpiel) [#17702](https://github.com/nodejs/node/pull/17702)
* [[`d0b89a12ec`](https://github.com/nodejs/node/commit/d0b89a12ec)] - **doc**: add countdown module to writing tests guide (Bamieh) [#17201](https://github.com/nodejs/node/pull/17201)
* [[`1eac4055f0`](https://github.com/nodejs/node/commit/1eac4055f0)] - **doc**: include Daniel Bevenius as a TSC member (Rich Trott) [#17652](https://github.com/nodejs/node/pull/17652)
* [[`83fe79c558`](https://github.com/nodejs/node/commit/83fe79c558)] - **doc**: correct pbkdf2 salt length recommendation (Will Clark) [#17524](https://github.com/nodejs/node/pull/17524)
* [[`43a2bc040f`](https://github.com/nodejs/node/commit/43a2bc040f)] - **doc**: improve randomfill and fix broken link (Sakthipriyan Vairamani (thefourtheye)) [#12541](https://github.com/nodejs/node/pull/12541)
* [[`ef0213c0b8`](https://github.com/nodejs/node/commit/ef0213c0b8)] - **doc**: move Code of Conduct to admin repo (Myles Borins) [#17301](https://github.com/nodejs/node/pull/17301)
* [[`e16d01fc94`](https://github.com/nodejs/node/commit/e16d01fc94)] - **gitignore**: ignore *.VC.db files (Tobias Nießen) [#17898](https://github.com/nodejs/node/pull/17898)
* [[`1390c280bc`](https://github.com/nodejs/node/commit/1390c280bc)] - **(SEMVER-MINOR)** **http**: overridable keep-alive behavior of `Agent` (Fedor Indutny) [#13005](https://github.com/nodejs/node/pull/13005)
* [[`063c4fa345`](https://github.com/nodejs/node/commit/063c4fa345)] - **(SEMVER-MINOR)** **lib**: return this from net.Socket.end() (Sam Roberts) [#13481](https://github.com/nodejs/node/pull/13481)
* [[`cdf4a9c394`](https://github.com/nodejs/node/commit/cdf4a9c394)] - **(SEMVER-MINOR)** **module**: add builtinModules (Jon Moss) [#16386](https://github.com/nodejs/node/pull/16386)
* [[`ffc1444117`](https://github.com/nodejs/node/commit/ffc1444117)] - **net**: remove ADDRCONFIG DNS hint on Windows (Bartosz Sosnowski) [#17662](https://github.com/nodejs/node/pull/17662)
* [[`6a27774882`](https://github.com/nodejs/node/commit/6a27774882)] - **(SEMVER-MINOR)** **net**: return this from getConnections() (Sam Roberts) [#13553](https://github.com/nodejs/node/pull/13553)
* [[`a09e2fd43b`](https://github.com/nodejs/node/commit/a09e2fd43b)] - **net**: fix timeout with null handle (Anatoli Papirovski) [#16489](https://github.com/nodejs/node/pull/16489)
* [[`a301c1a0e0`](https://github.com/nodejs/node/commit/a301c1a0e0)] - **net**: fix timeouts during long writes (Anatoli Papirovski) [#15791](https://github.com/nodejs/node/pull/15791)
* [[`c64a73ba6c`](https://github.com/nodejs/node/commit/c64a73ba6c)] - **promises**: more robust stringification (Timothy Gu) [#13784](https://github.com/nodejs/node/pull/13784)
* [[`3b9fea0782`](https://github.com/nodejs/node/commit/3b9fea0782)] - **(SEMVER-MINOR)** **repl**: improve require() autocompletion (Alexey Orlenko) [#14409](https://github.com/nodejs/node/pull/14409)
* [[`9181fbb699`](https://github.com/nodejs/node/commit/9181fbb699)] - **src**: dumb down code by removing std::move (Anna Henningsen) [#18324](https://github.com/nodejs/node/pull/18324)
* [[`57865a9213`](https://github.com/nodejs/node/commit/57865a9213)] - **src**: use correct OOB check for IPv6 parsing (Anna Henningsen) [#17470](https://github.com/nodejs/node/pull/17470)
* [[`f306d3eb7a`](https://github.com/nodejs/node/commit/f306d3eb7a)] - **src**: make url host a proper C++ class (Anna Henningsen) [#17470](https://github.com/nodejs/node/pull/17470)
* [[`1976c7c7a5`](https://github.com/nodejs/node/commit/1976c7c7a5)] - **src**: move url internals into anonymous namespace (Anna Henningsen) [#17470](https://github.com/nodejs/node/pull/17470)
* [[`d66f469931`](https://github.com/nodejs/node/commit/d66f469931)] - **src**: minor cleanups to node_url.cc (Anna Henningsen) [#17470](https://github.com/nodejs/node/pull/17470)
* [[`979af518c1`](https://github.com/nodejs/node/commit/979af518c1)] - **src**: remove nonexistent method from header file (Anna Henningsen) [#17748](https://github.com/nodejs/node/pull/17748)
* [[`2268d00e38`](https://github.com/nodejs/node/commit/2268d00e38)] - **(SEMVER-MINOR)** **src**: add openssl-system-ca-path configure option (Daniel Bevenius) [#16790](https://github.com/nodejs/node/pull/16790)
* [[`a6d2384c9a`](https://github.com/nodejs/node/commit/a6d2384c9a)] - **src**: clean up MaybeStackBuffer (Timothy Gu) [#11464](https://github.com/nodejs/node/pull/11464)
* [[`9f3b4ad5bd`](https://github.com/nodejs/node/commit/9f3b4ad5bd)] - **src**: fix incorrect macro comment (Daniel Bevenius) [#12688](https://github.com/nodejs/node/pull/12688)
* [[`2b29cea1b4`](https://github.com/nodejs/node/commit/2b29cea1b4)] - **src**: guard bundled_ca/openssl_ca with HAVE_OPENSSL (Daniel Bevenius) [#12302](https://github.com/nodejs/node/pull/12302)
* [[`758dc81e8d`](https://github.com/nodejs/node/commit/758dc81e8d)] - **(SEMVER-MAJOR)** **src**: add --use-bundled-ca --use-openssl-ca check (Daniel Bevenius) [#12087](https://github.com/nodejs/node/pull/12087)
* [[`2d4fca2c41`](https://github.com/nodejs/node/commit/2d4fca2c41)] - **(SEMVER-MINOR)** **src**: add process.ppid (cjihrig) [#16839](https://github.com/nodejs/node/pull/16839)
* [[`b6ce918e0a`](https://github.com/nodejs/node/commit/b6ce918e0a)] - **stream**: fix disparity between buffer and the count (jlvivero) [#15661](https://github.com/nodejs/node/pull/15661)
* [[`f82065fbe1`](https://github.com/nodejs/node/commit/f82065fbe1)] - **test**: make test-cli-syntax engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`a4e2ced73b`](https://github.com/nodejs/node/commit/a4e2ced73b)] - **test**: decrease duration of test-cli-syntax (Evan Lucas) [#14187](https://github.com/nodejs/node/pull/14187)
* [[`734ce678f4`](https://github.com/nodejs/node/commit/734ce678f4)] - **test**: use valid authentication tag length (Tobias Nießen) [#17566](https://github.com/nodejs/node/pull/17566)
* [[`694828df0e`](https://github.com/nodejs/node/commit/694828df0e)] - **test**: mark test-inspector-stop-profile-after-done flaky (Myles Borins) [#18491](https://github.com/nodejs/node/pull/18491)
* [[`5668403ddb`](https://github.com/nodejs/node/commit/5668403ddb)] - **test**: improve flaky test-listen-fd-ebadf.js (Rich Trott) [#17797](https://github.com/nodejs/node/pull/17797)
* [[`fce10f722d`](https://github.com/nodejs/node/commit/fce10f722d)] - **test**: fix test-tls-server-verify.js on Windows CI (Rich Trott) [#18382](https://github.com/nodejs/node/pull/18382)
* [[`4473c6c807`](https://github.com/nodejs/node/commit/4473c6c807)] - **test**: fix flaky test-http-pipeline-flood (Anatoli Papirovski) [#17955](https://github.com/nodejs/node/pull/17955)
* [[`001b67296e`](https://github.com/nodejs/node/commit/001b67296e)] - **test**: rename regression tests (Tobias Nießen) [#17948](https://github.com/nodejs/node/pull/17948)
* [[`0c3f23ef59`](https://github.com/nodejs/node/commit/0c3f23ef59)] - **test**: fix flaky test-pipe-unref (Anatoli Papirovski) [#17950](https://github.com/nodejs/node/pull/17950)
* [[`9e760285de`](https://github.com/nodejs/node/commit/9e760285de)] - **test**: fix crypto test case to use correct encoding (Tobias Nießen) [#17956](https://github.com/nodejs/node/pull/17956)
* [[`1c4aa61388`](https://github.com/nodejs/node/commit/1c4aa61388)] - **test**: simplify test-buffer-slice.js (Weijia Wang) [#17962](https://github.com/nodejs/node/pull/17962)
* [[`2c554a9d2b`](https://github.com/nodejs/node/commit/2c554a9d2b)] - **test**: improve to use template string (sreepurnajasti) [#17895](https://github.com/nodejs/node/pull/17895)
* [[`8c1f41fc11`](https://github.com/nodejs/node/commit/8c1f41fc11)] - **test**: make test-tls-invoke-queued use public API (Anna Henningsen) [#17864](https://github.com/nodejs/node/pull/17864)
* [[`b3e625d67a`](https://github.com/nodejs/node/commit/b3e625d67a)] - **test**: refactor test-tls-securepair-fiftharg (Anna Henningsen) [#17836](https://github.com/nodejs/node/pull/17836)
* [[`038e52627f`](https://github.com/nodejs/node/commit/038e52627f)] - **test**: remove undefined function (Rich Trott) [#17845](https://github.com/nodejs/node/pull/17845)
* [[`5314754685`](https://github.com/nodejs/node/commit/5314754685)] - **test**: use common module API in test-child-process-exec-stdout-stderr-data-string (sreepurnajasti) [#17751](https://github.com/nodejs/node/pull/17751)
* [[`f291bc1d98`](https://github.com/nodejs/node/commit/f291bc1d98)] - **test**: refactor test-repl-definecommand (Rich Trott) [#17795](https://github.com/nodejs/node/pull/17795)
* [[`cb7854354f`](https://github.com/nodejs/node/commit/cb7854354f)] - **test**: change callback function to arrow function (rt33) [#17734](https://github.com/nodejs/node/pull/17734)
* [[`bdb535c731`](https://github.com/nodejs/node/commit/bdb535c731)] - **test**: Use countdown in test file (sreepurnajasti) [#17646](https://github.com/nodejs/node/pull/17646)
* [[`31c5db6c03`](https://github.com/nodejs/node/commit/31c5db6c03)] - **test**: update test-http-content-length to use countdown (Bamieh) [#17201](https://github.com/nodejs/node/pull/17201)
* [[`cc03470b82`](https://github.com/nodejs/node/commit/cc03470b82)] - **test**: change callback function to arrow function (routerman) [#17697](https://github.com/nodejs/node/pull/17697)
* [[`81e6569990`](https://github.com/nodejs/node/commit/81e6569990)] - **test**: change callback function to arrow function (you12724) [#17698](https://github.com/nodejs/node/pull/17698)
* [[`2d77241f33`](https://github.com/nodejs/node/commit/2d77241f33)] - **test**: change callback function to arrow function (Shinya Kanamaru) [#17699](https://github.com/nodejs/node/pull/17699)
* [[`af3e074249`](https://github.com/nodejs/node/commit/af3e074249)] - **(SEMVER-MINOR)** **test**: add `makeDuplexPair()` helper (Anna Henningsen) [#16269](https://github.com/nodejs/node/pull/16269)
* [[`fb0bd8a584`](https://github.com/nodejs/node/commit/fb0bd8a584)] - **test**: fix flaky test-child-process-pass-fd (Rich Trott) [#17598](https://github.com/nodejs/node/pull/17598)
* [[`b3b245665e`](https://github.com/nodejs/node/commit/b3b245665e)] - **test**: add test description to fs.readFile tests (Jamie Davis) [#17610](https://github.com/nodejs/node/pull/17610)
* [[`5f7944842a`](https://github.com/nodejs/node/commit/5f7944842a)] - **test**: fix truncation of argv (Daniel Bevenius) [#12110](https://github.com/nodejs/node/pull/12110)
* [[`699c6638c3`](https://github.com/nodejs/node/commit/699c6638c3)] - **test**: add common.hasIntl (James M Snell) [#9246](https://github.com/nodejs/node/pull/9246)
* [[`365dba2195`](https://github.com/nodejs/node/commit/365dba2195)] - **test**: fix flaky test-crypto-classes.js (Bryan English) [#15662](https://github.com/nodejs/node/pull/15662)
* [[`d29a6202e7`](https://github.com/nodejs/node/commit/d29a6202e7)] - **(SEMVER-MINOR)** **test**: crypto createClass instanceof Class (Bryan English) [#8188](https://github.com/nodejs/node/pull/8188)
* [[`7b801b5f83`](https://github.com/nodejs/node/commit/7b801b5f83)] - **test**: don't skip when common.mustCall() is pending (cjihrig) [#15421](https://github.com/nodejs/node/pull/15421)
* [[`4f6dd9649f`](https://github.com/nodejs/node/commit/4f6dd9649f)] - **test,doc**: do not indicate that non-functions "return" values (Rich Trott) [#17267](https://github.com/nodejs/node/pull/17267)
* [[`a08925dcbd`](https://github.com/nodejs/node/commit/a08925dcbd)] - **tls**: comment about old-style errors (xortiz) [#17759](https://github.com/nodejs/node/pull/17759)
* [[`56e1586608`](https://github.com/nodejs/node/commit/56e1586608)] - **tls**: unconsume stream on destroy (Anna Henningsen) [#17478](https://github.com/nodejs/node/pull/17478)
* [[`00b279087e`](https://github.com/nodejs/node/commit/00b279087e)] - **(SEMVER-MINOR)** **tls**: accept `lookup` option for `tls.connect()` (Fedor Indutny) [#12839](https://github.com/nodejs/node/pull/12839)
* [[`521dc2511f`](https://github.com/nodejs/node/commit/521dc2511f)] - **tls**: properly track writeQueueSize during writes (Anatoli Papirovski) [#15791](https://github.com/nodejs/node/pull/15791)
* [[`51bfd32922`](https://github.com/nodejs/node/commit/51bfd32922)] - **tools**: do not override V8's gitignore (Yang Guo) [#18010](https://github.com/nodejs/node/pull/18010)
* [[`32f528a92e`](https://github.com/nodejs/node/commit/32f528a92e)] - **tools**: fix AttributeError: `__exit__` on Python 2.6 (Dmitriy Kasyanov) [#17663](https://github.com/nodejs/node/pull/17663)
* [[`6187aec242`](https://github.com/nodejs/node/commit/6187aec242)] - **tools**: autofixer for lowercase-name-for-primitive (Shobhit Chittora) [#17715](https://github.com/nodejs/node/pull/17715)
* [[`928b7c87cd`](https://github.com/nodejs/node/commit/928b7c87cd)] - **tools**: simplify lowercase-name-for-primitive rule (cjihrig) [#17653](https://github.com/nodejs/node/pull/17653)
* [[`7821a4c899`](https://github.com/nodejs/node/commit/7821a4c899)] - **tools**: add lowercase-name-for-primitive eslint rule (Weijia Wang) [#17568](https://github.com/nodejs/node/pull/17568)
* [[`1d706026a7`](https://github.com/nodejs/node/commit/1d706026a7)] - **tools**: make doc tool a bit more readable (Tobias Nießen) [#17125](https://github.com/nodejs/node/pull/17125)
* [[`b8a5d6dbbc`](https://github.com/nodejs/node/commit/b8a5d6dbbc)] - **tools**: remove useless function declaration (Tobias Nießen) [#17125](https://github.com/nodejs/node/pull/17125)
* [[`18803bc409`](https://github.com/nodejs/node/commit/18803bc409)] - **(SEMVER-MINOR)** **tools, build**: refactor macOS installer (JP Wesselink) [#15179](https://github.com/nodejs/node/pull/15179)
* [[`24def19417`](https://github.com/nodejs/node/commit/24def19417)] - **(SEMVER-MINOR)** **url**: adding WHATWG URL support (James M Snell) [#7448](https://github.com/nodejs/node/pull/7448)
* [[`60b10f0896`](https://github.com/nodejs/node/commit/60b10f0896)] - **url**: update IDNA handling (Timothy Gu) [#13362](https://github.com/nodejs/node/pull/13362)
* [[`7af1ad0ec1`](https://github.com/nodejs/node/commit/7af1ad0ec1)] - **(SEMVER-MINOR)** **util**: add %i and %f formatting specifiers (Roman Reiss) [#10308](https://github.com/nodejs/node/pull/10308)

<a id="6.12.3"></a>
## 2018-01-02, Version 6.12.3 'Boron' (LTS), @MylesBorins

This LTS release comes with 115 commits. This includes 52 which are test related,
40 which are doc related, 12 which are build / tool related and 2 commits which updating a dependency.

### Notable Changes

* **build**:
  * configure can now be run from any directory (Gibson Fahnestock) [#17321](https://github.com/nodejs/node/pull/17321)

### Commits

* [[`b1b975370f`](https://github.com/nodejs/node/commit/b1b975370f)] - **benchmark,path**: remove unused variables (薛定谔的猫) [#15789](https://github.com/nodejs/node/pull/15789)
* [[`ac6f345f70`](https://github.com/nodejs/node/commit/ac6f345f70)] - **build**: allow running configure from any directory (Gibson Fahnestock) [#17321](https://github.com/nodejs/node/pull/17321)
* [[`017492eca2`](https://github.com/nodejs/node/commit/017492eca2)] - **build**: add serial commas to messages in configure script (Rich Trott) [#17464](https://github.com/nodejs/node/pull/17464)
* [[`ad9a8578ee`](https://github.com/nodejs/node/commit/ad9a8578ee)] - **build**: fix test-v8 target (Michaël Zasso) [#17269](https://github.com/nodejs/node/pull/17269)
* [[`9ba35e859f`](https://github.com/nodejs/node/commit/9ba35e859f)] - **build**: remove empty VCLibrarianTool entry (Daniel Bevenius) [#17191](https://github.com/nodejs/node/pull/17191)
* [[`3d22e81d70`](https://github.com/nodejs/node/commit/3d22e81d70)] - **build**: minor corrections to configure descriptions (Daniel Bevenius) [#17094](https://github.com/nodejs/node/pull/17094)
* [[`92f41e553a`](https://github.com/nodejs/node/commit/92f41e553a)] - **build**: allow enabling the --trace-maps flag in V8 (Evan Lucas) [#14018](https://github.com/nodejs/node/pull/14018)
* [[`b563908ff9`](https://github.com/nodejs/node/commit/b563908ff9)] - **crypto**: use SetNull instead of Set (Daniel Bevenius) [#17521](https://github.com/nodejs/node/pull/17521)
* [[`b287b9e64b`](https://github.com/nodejs/node/commit/b287b9e64b)] - **deps**: V8: cherry-pick e8e9c07 from upstream (Ali Ijaz Sheikh)
* [[`9804e7f3bb`](https://github.com/nodejs/node/commit/9804e7f3bb)] - **deps**: V8: cherry-pick 9622696 from upstream (Ali Ijaz Sheikh)
* [[`dcee5edef7`](https://github.com/nodejs/node/commit/dcee5edef7)] - **doc**: simplify and clarify FIPS text in BUILDING.md (Rich Trott) [#17538](https://github.com/nodejs/node/pull/17538)
* [[`f53b4df00e`](https://github.com/nodejs/node/commit/f53b4df00e)] - **doc**: 'constructor' implies use of new keyword (Cameron Moorehead) [#17364](https://github.com/nodejs/node/pull/17364)
* [[`67c526fbb8`](https://github.com/nodejs/node/commit/67c526fbb8)] - **doc**: improve text for Console constructor (Rich Trott) [#17519](https://github.com/nodejs/node/pull/17519)
* [[`013ef22ef8`](https://github.com/nodejs/node/commit/013ef22ef8)] - **doc**: improve readability of COLLABORATOR_GUIDE.md (Rich Trott) [#17519](https://github.com/nodejs/node/pull/17519)
* [[`ee52ce954a`](https://github.com/nodejs/node/commit/ee52ce954a)] - **doc**: mention node-test-pull-request-lite job (Jon Moss) [#17513](https://github.com/nodejs/node/pull/17513)
* [[`a44f0855b4`](https://github.com/nodejs/node/commit/a44f0855b4)] - **doc**: fix typo in repl.md (Rich Trott) [#17502](https://github.com/nodejs/node/pull/17502)
* [[`a15da3bf45`](https://github.com/nodejs/node/commit/a15da3bf45)] - **doc**: fix common typo involving one-time listeners (Rich Trott) [#17502](https://github.com/nodejs/node/pull/17502)
* [[`92d2c9aecb`](https://github.com/nodejs/node/commit/92d2c9aecb)] - **doc**: update AUTHORS list (Michaël Zasso) [#17452](https://github.com/nodejs/node/pull/17452)
* [[`c24fafa881`](https://github.com/nodejs/node/commit/c24fafa881)] - **doc**: edit module introduction (Rich Trott) [#17463](https://github.com/nodejs/node/pull/17463)
* [[`8ca12e2b6e`](https://github.com/nodejs/node/commit/8ca12e2b6e)] - **doc**: standardize preposition usage in fs.md (Rich Trott) [#17463](https://github.com/nodejs/node/pull/17463)
* [[`e8368a12d2`](https://github.com/nodejs/node/commit/e8368a12d2)] - **doc**: improve punctuation in fs.open() text (Rich Trott) [#17463](https://github.com/nodejs/node/pull/17463)
* [[`4d4337d3d3`](https://github.com/nodejs/node/commit/4d4337d3d3)] - **doc**: use colon consistently in assert.md (Rich Trott) [#17463](https://github.com/nodejs/node/pull/17463)
* [[`0fa2f39457`](https://github.com/nodejs/node/commit/0fa2f39457)] - **doc**: improve checkServerIdentity docs (Hannes Magnusson) [#17203](https://github.com/nodejs/node/pull/17203)
* [[`35316dcd10`](https://github.com/nodejs/node/commit/35316dcd10)] - **doc**: add guide to maintaining npm (Myles Borins) [#16541](https://github.com/nodejs/node/pull/16541)
* [[`90ee2ee943`](https://github.com/nodejs/node/commit/90ee2ee943)] - **doc**: clarify fast-track of reversions (Refael Ackermann) [#17332](https://github.com/nodejs/node/pull/17332)
* [[`3eab248a1f`](https://github.com/nodejs/node/commit/3eab248a1f)] - **doc**: Add link for ECMAScript 2015 (smatsu-hl) [#17317](https://github.com/nodejs/node/pull/17317)
* [[`c519287d3d`](https://github.com/nodejs/node/commit/c519287d3d)] - **doc**: replace string with template string (Leko) [#17316](https://github.com/nodejs/node/pull/17316)
* [[`b2236a3804`](https://github.com/nodejs/node/commit/b2236a3804)] - **doc**: replace function with arrow function in vm.md (narirou) [#17307](https://github.com/nodejs/node/pull/17307)
* [[`46dc2416b9`](https://github.com/nodejs/node/commit/46dc2416b9)] - **doc**: fix typo in api doc of url.format(urlObject) (pkovacs) [#17295](https://github.com/nodejs/node/pull/17295)
* [[`b13dab8b4d`](https://github.com/nodejs/node/commit/b13dab8b4d)] - **doc**: add maclover7 to collaborators (Jon Moss) [#17289](https://github.com/nodejs/node/pull/17289)
* [[`ab91fe1686`](https://github.com/nodejs/node/commit/ab91fe1686)] - **doc**: update http URLs to https in README.md (Ronald Eddy Jr) [#17264](https://github.com/nodejs/node/pull/17264)
* [[`23f21a63d8`](https://github.com/nodejs/node/commit/23f21a63d8)] - **doc**: update http URLs to https in GOVERNANCE.md (Ronald Eddy Jr) [#17262](https://github.com/nodejs/node/pull/17262)
* [[`d692f4546c`](https://github.com/nodejs/node/commit/d692f4546c)] - **doc**: update http URLs to https in CONTRIBUTING.md (Ronald Eddy Jr) [#17261](https://github.com/nodejs/node/pull/17261)
* [[`a0bd1c0b81`](https://github.com/nodejs/node/commit/a0bd1c0b81)] - **doc**: add SharedArrayBuffer to Buffer documentation (Thomas den Hollander) [#15489](https://github.com/nodejs/node/pull/15489)
* [[`5f522a18d9`](https://github.com/nodejs/node/commit/5f522a18d9)] - **doc**: use better terminology for build machines (Anna Henningsen) [#17142](https://github.com/nodejs/node/pull/17142)
* [[`3f39e47f6c`](https://github.com/nodejs/node/commit/3f39e47f6c)] - **doc**: update mgol in AUTHORS.txt, add to .mailmap (Michał Gołębiowski-Owczarek) [#17239](https://github.com/nodejs/node/pull/17239)
* [[`80c6384985`](https://github.com/nodejs/node/commit/80c6384985)] - **doc**: update release table in V8 guide (Ali Ijaz Sheikh) [#17136](https://github.com/nodejs/node/pull/17136)
* [[`d4e9a2555d`](https://github.com/nodejs/node/commit/d4e9a2555d)] - **doc**: add guybedford to collaborators (Guy Bedford) [#17197](https://github.com/nodejs/node/pull/17197)
* [[`e232e210f6`](https://github.com/nodejs/node/commit/e232e210f6)] - **doc**: update AUTHORS list (Michaël Zasso) [#16571](https://github.com/nodejs/node/pull/16571)
* [[`ca76c336d1`](https://github.com/nodejs/node/commit/ca76c336d1)] - **doc**: normalize ToC indentation with heading levels in README (Rich Trott) [#17106](https://github.com/nodejs/node/pull/17106)
* [[`1815ca5066`](https://github.com/nodejs/node/commit/1815ca5066)] - **doc**: add Contributing to Node.js to the README ToC (Rich Trott) [#17106](https://github.com/nodejs/node/pull/17106)
* [[`d8f66676e5`](https://github.com/nodejs/node/commit/d8f66676e5)] - **doc**: merge Working Groups with Contributing to Node.js in README (Rich Trott) [#17106](https://github.com/nodejs/node/pull/17106)
* [[`b064c731ff`](https://github.com/nodejs/node/commit/b064c731ff)] - **doc**: remove IRC node-dev link from README (Rich Trott) [#17106](https://github.com/nodejs/node/pull/17106)
* [[`8cae573af1`](https://github.com/nodejs/node/commit/8cae573af1)] - **doc**: add note about using cluster without networking (pimlie) [#17031](https://github.com/nodejs/node/pull/17031)
* [[`b16e6d29f1`](https://github.com/nodejs/node/commit/b16e6d29f1)] - **doc**: explicitly document highWaterMark option (Sebastian Silbermann) [#17049](https://github.com/nodejs/node/pull/17049)
* [[`ccdf4b245a`](https://github.com/nodejs/node/commit/ccdf4b245a)] - **doc**: reorganize collaborator guide (Joyee Cheung) [#17056](https://github.com/nodejs/node/pull/17056)
* [[`d44adf12a9`](https://github.com/nodejs/node/commit/d44adf12a9)] - **doc**: delete unused definition in README.md (Vse Mozhet Byt) [#17108](https://github.com/nodejs/node/pull/17108)
* [[`e03645dd6f`](https://github.com/nodejs/node/commit/e03645dd6f)] - **doc**: add Support section in README (Rich Trott) [#16533](https://github.com/nodejs/node/pull/16533)
* [[`0f94bb9aeb`](https://github.com/nodejs/node/commit/0f94bb9aeb)] - **doc**: add hashseed to collaborators (Yang Guo)
* [[`5cd89c7817`](https://github.com/nodejs/node/commit/5cd89c7817)] - **doc,win**: clarify WSL support (João Reis) [#17008](https://github.com/nodejs/node/pull/17008)
* [[`93ca2f78c6`](https://github.com/nodejs/node/commit/93ca2f78c6)] - **meta**: allow vague objections to be dismissed (James M Snell) [#15233](https://github.com/nodejs/node/pull/15233)
* [[`a12e16818f`](https://github.com/nodejs/node/commit/a12e16818f)] - **path**: remove obsolete comment (Rich Trott) [#17023](https://github.com/nodejs/node/pull/17023)
* [[`2d74af0184`](https://github.com/nodejs/node/commit/2d74af0184)] - **src**: remove unused include node_crypto_clienthello (Daniel Bevenius) [#17546](https://github.com/nodejs/node/pull/17546)
* [[`6792998f6a`](https://github.com/nodejs/node/commit/6792998f6a)] - **src**: make base64.h self-contained (Daniel Bevenius) [#17177](https://github.com/nodejs/node/pull/17177)
* [[`84a8861b62`](https://github.com/nodejs/node/commit/84a8861b62)] - **src**: remove unprofessional slang in assertions (Alexey Orlenko) [#17166](https://github.com/nodejs/node/pull/17166)
* [[`f11acca80c`](https://github.com/nodejs/node/commit/f11acca80c)] - **src**: fix size of CounterSet (Witthawat Piwawatthanapanit) [#16984](https://github.com/nodejs/node/pull/16984)
* [[`a528d573ce`](https://github.com/nodejs/node/commit/a528d573ce)] - **test**: remove hidden use of common.PORT in parallel tests (Rich Trott) [#17466](https://github.com/nodejs/node/pull/17466)
* [[`dbf5ddbc97`](https://github.com/nodejs/node/commit/dbf5ddbc97)] - **test**: refactor test-child-process-pass-fd (Rich Trott) [#17596](https://github.com/nodejs/node/pull/17596)
* [[`a50366fbf7`](https://github.com/nodejs/node/commit/a50366fbf7)] - **test**: improve assert messages in repl-reset-event (Adri Van Houdt) [#16836](https://github.com/nodejs/node/pull/16836)
* [[`bd4b97fe3d`](https://github.com/nodejs/node/commit/bd4b97fe3d)] - **test**: update test-http-should-keep-alive to use countdown (TomerOmri) [#17505](https://github.com/nodejs/node/pull/17505)
* [[`23edd08b00`](https://github.com/nodejs/node/commit/23edd08b00)] - **test**: use Countdown in http test (idandagan1) [#17506](https://github.com/nodejs/node/pull/17506)
* [[`e9cacee677`](https://github.com/nodejs/node/commit/e9cacee677)] - **test**: use Countdown in http-response-statuscode (Mandeep Singh) [#17327](https://github.com/nodejs/node/pull/17327)
* [[`68dabce07a`](https://github.com/nodejs/node/commit/68dabce07a)] - **test**: use Countdown in test-http-set-cookies (Shilo Mangam) [#17504](https://github.com/nodejs/node/pull/17504)
* [[`d4d3f50f9d`](https://github.com/nodejs/node/commit/d4d3f50f9d)] - **test**: Use common.mustCall in http test (sreepurnajasti) [#17487](https://github.com/nodejs/node/pull/17487)
* [[`6e7ace2dcf`](https://github.com/nodejs/node/commit/6e7ace2dcf)] - **test**: replace fs.accessSync with fs.existsSync (Leko) [#17446](https://github.com/nodejs/node/pull/17446)
* [[`3cf8f98c3e`](https://github.com/nodejs/node/commit/3cf8f98c3e)] - **test**: add common.crashOnUnhandledRejection() (IHsuan) [#17247](https://github.com/nodejs/node/pull/17247)
* [[`d1d547d2ab`](https://github.com/nodejs/node/commit/d1d547d2ab)] - **test**: update test-http-request-dont-override-options to use common.mustCall (Mithun Sasidharan) [#17438](https://github.com/nodejs/node/pull/17438)
* [[`f9adf51744`](https://github.com/nodejs/node/commit/f9adf51744)] - **test**: use common.mustCall in test-http-malformed-request (Mithun Sasidharan) [#17439](https://github.com/nodejs/node/pull/17439)
* [[`8fc196905d`](https://github.com/nodejs/node/commit/8fc196905d)] - **test**: use Countdown in http test (Mithun Sasidharan) [#17436](https://github.com/nodejs/node/pull/17436)
* [[`47e5fd940e`](https://github.com/nodejs/node/commit/47e5fd940e)] - **test**: update test-http-response-multiheaders to use countdown (hmammedzadeh) [#17419](https://github.com/nodejs/node/pull/17419)
* [[`660e6dea89`](https://github.com/nodejs/node/commit/660e6dea89)] - **test**: update test-http-upgrade-client to use countdown (Mithun Sasidharan) [#17339](https://github.com/nodejs/node/pull/17339)
* [[`8f997c0117`](https://github.com/nodejs/node/commit/8f997c0117)] - **test**: update test-http-status-reason-invalid-chars to use countdown (Mithun Sasidharan) [#17342](https://github.com/nodejs/node/pull/17342)
* [[`42454a5c34`](https://github.com/nodejs/node/commit/42454a5c34)] - **test**: refactored test-http-allow-req-after-204-res to countdown (Mithun Sasidharan) [#17211](https://github.com/nodejs/node/pull/17211)
* [[`3ee4c1e149`](https://github.com/nodejs/node/commit/3ee4c1e149)] - **test**: update test/parallel/test-http-pipe-fs.js to use countdown (ChungNgoops) [#17346](https://github.com/nodejs/node/pull/17346)
* [[`8908cd6cc1`](https://github.com/nodejs/node/commit/8908cd6cc1)] - **test**: refactored test-http-response-splitting to use countdown (Mithun Sasidharan) [#17348](https://github.com/nodejs/node/pull/17348)
* [[`4f3a165827`](https://github.com/nodejs/node/commit/4f3a165827)] - **test**: replace function with ES6 arrow function (Junichi Kajiwara) [#17306](https://github.com/nodejs/node/pull/17306)
* [[`3a0cb8fcae`](https://github.com/nodejs/node/commit/3a0cb8fcae)] - **test**: refactored http test to use countdown (Mithun Sasidharan) [#17241](https://github.com/nodejs/node/pull/17241)
* [[`f3c1158f57`](https://github.com/nodejs/node/commit/f3c1158f57)] - **test**: Update test-http-parser-free to use countdown timer (Mandeep Singh) [#17322](https://github.com/nodejs/node/pull/17322)
* [[`956198f30d`](https://github.com/nodejs/node/commit/956198f30d)] - **test**: Update test-http-client-agent to use countdown timer (Mandeep Singh) [#17325](https://github.com/nodejs/node/pull/17325)
* [[`35cc1b3fcc`](https://github.com/nodejs/node/commit/35cc1b3fcc)] - **test**: fix isNAN-\>Number.isNAN (yuza yuko) [#17309](https://github.com/nodejs/node/pull/17309)
* [[`32ebcf7fd0`](https://github.com/nodejs/node/commit/32ebcf7fd0)] - **test**: make use of Number.isNaN to test-readfloat.js (Hiromu Yoshiwara) [#17310](https://github.com/nodejs/node/pull/17310)
* [[`1cd4076a4e`](https://github.com/nodejs/node/commit/1cd4076a4e)] - **test**: replace function with arrow function (spring_raining) [#17312](https://github.com/nodejs/node/pull/17312)
* [[`0ef4f78ae0`](https://github.com/nodejs/node/commit/0ef4f78ae0)] - **test**: replace function with arrow function (Hiroaki KARASAWA) [#17308](https://github.com/nodejs/node/pull/17308)
* [[`c0c366634d`](https://github.com/nodejs/node/commit/c0c366634d)] - **test**: use arrow function (koooge) [#17318](https://github.com/nodejs/node/pull/17318)
* [[`8098a6ed0e`](https://github.com/nodejs/node/commit/8098a6ed0e)] - **test**: use Number.isNaN() (MURAKAMI Masahiko) [#17319](https://github.com/nodejs/node/pull/17319)
* [[`bdbcdebb65`](https://github.com/nodejs/node/commit/bdbcdebb65)] - **test**: add test of stream Transform (Yoshiya Hinosawa) [#17303](https://github.com/nodejs/node/pull/17303)
* [[`75ad37c854`](https://github.com/nodejs/node/commit/75ad37c854)] - **test**: use common.crashOnUnhandledRejection (Kcin1993) [#17235](https://github.com/nodejs/node/pull/17235)
* [[`b63f51aa7f`](https://github.com/nodejs/node/commit/b63f51aa7f)] - **test**: use common.crashOnUnhandledRejection (zhengyuanjie) [#17215](https://github.com/nodejs/node/pull/17215)
* [[`797e33b602`](https://github.com/nodejs/node/commit/797e33b602)] - **test**: use common.crashOnUnhandledRejection (Jason Chung) [#17233](https://github.com/nodejs/node/pull/17233)
* [[`699659e5df`](https://github.com/nodejs/node/commit/699659e5df)] - **test**: use common.crashOnUnhandledRejection() (sorarize@gmail.com) [#17232](https://github.com/nodejs/node/pull/17232)
* [[`89f1b6c041`](https://github.com/nodejs/node/commit/89f1b6c041)] - **test**: add common.crashOnHandleRejection (jackyen) [#17225](https://github.com/nodejs/node/pull/17225)
* [[`7cbdeefc7e`](https://github.com/nodejs/node/commit/7cbdeefc7e)] - **test**: remove unlink function which is needless (buji) [#17119](https://github.com/nodejs/node/pull/17119)
* [[`7c57ab76ec`](https://github.com/nodejs/node/commit/7c57ab76ec)] - **test**: dont need to remove nonexistent directory (buji) [#17119](https://github.com/nodejs/node/pull/17119)
* [[`71671df00e`](https://github.com/nodejs/node/commit/71671df00e)] - **test**: fix linting error (James M Snell) [#17251](https://github.com/nodejs/node/pull/17251)
* [[`6620e761d7`](https://github.com/nodejs/node/commit/6620e761d7)] - **test**: use crashOnUnhandledRejection (Roth Peng) [#17226](https://github.com/nodejs/node/pull/17226)
* [[`d4a5499360`](https://github.com/nodejs/node/commit/d4a5499360)] - **test**: use common.crashOnUnhandledRejection (esbb48) [#17218](https://github.com/nodejs/node/pull/17218)
* [[`353e66f823`](https://github.com/nodejs/node/commit/353e66f823)] - **test**: use arrow function instead of bind (Lance Ball) [#17202](https://github.com/nodejs/node/pull/17202)
* [[`289ebb19b5`](https://github.com/nodejs/node/commit/289ebb19b5)] - **test**: use crashOnUnhandledRejection (Chiahao Lin) [#17219](https://github.com/nodejs/node/pull/17219)
* [[`e7ca894114`](https://github.com/nodejs/node/commit/e7ca894114)] - **test**: use common.crashOnUnhandledRejection (Whien) [#17214](https://github.com/nodejs/node/pull/17214)
* [[`0963c75c8e`](https://github.com/nodejs/node/commit/0963c75c8e)] - **test**: clean up inappropriate language (Gus Caplan) [#17170](https://github.com/nodejs/node/pull/17170)
* [[`5d488ee13f`](https://github.com/nodejs/node/commit/5d488ee13f)] - **test**: wrap callback in common.mustCall (suman-mitra) [#17173](https://github.com/nodejs/node/pull/17173)
* [[`fd36b27949`](https://github.com/nodejs/node/commit/fd36b27949)] - **test**: remove unused parameter in test-next-tick-error-spin.js (Francois KY) [#17185](https://github.com/nodejs/node/pull/17185)
* [[`43e4669467`](https://github.com/nodejs/node/commit/43e4669467)] - **test**: remove unused parameter (Fran Herrero) [#17193](https://github.com/nodejs/node/pull/17193)
* [[`4eb1b58481`](https://github.com/nodejs/node/commit/4eb1b58481)] - **test**: remove unused variable (Guillaume Flandre) [#17187](https://github.com/nodejs/node/pull/17187)
* [[`39cd0a8abc`](https://github.com/nodejs/node/commit/39cd0a8abc)] - **test**: utilize common.mustCall() on child exit (sreepurnajasti) [#16996](https://github.com/nodejs/node/pull/16996)
* [[`fe2188620d`](https://github.com/nodejs/node/commit/fe2188620d)] - **test**: use arrow functions instead of bind (Tobias Nießen) [#17070](https://github.com/nodejs/node/pull/17070)
* [[`92daa2d2d3`](https://github.com/nodejs/node/commit/92daa2d2d3)] - **test**: make REPL test pass in coverage mode (Anna Henningsen) [#17082](https://github.com/nodejs/node/pull/17082)
* [[`c18a450e9d`](https://github.com/nodejs/node/commit/c18a450e9d)] - **test**: add coverage to tty module (cjihrig) [#16959](https://github.com/nodejs/node/pull/16959)
* [[`ad0d878772`](https://github.com/nodejs/node/commit/ad0d878772)] - **tools**: simplify buffer-constructor rule (cjihrig) [#17572](https://github.com/nodejs/node/pull/17572)
* [[`5383422672`](https://github.com/nodejs/node/commit/5383422672)] - **tools**: simplify prefer-assert-methods rule (cjihrig) [#17572](https://github.com/nodejs/node/pull/17572)
* [[`3e70ee84fb`](https://github.com/nodejs/node/commit/3e70ee84fb)] - **tools**: simplify prefer-common-mustnotcall rule (cjihrig) [#17572](https://github.com/nodejs/node/pull/17572)
* [[`afd4d9e348`](https://github.com/nodejs/node/commit/afd4d9e348)] - **tools**: add Boxstarter script (Bartosz Sosnowski) [#17046](https://github.com/nodejs/node/pull/17046)
* [[`466e94a6c1`](https://github.com/nodejs/node/commit/466e94a6c1)] - **tools**: avoid using process.cwd in tools/lint-js (Tobias Nießen) [#17121](https://github.com/nodejs/node/pull/17121)
* [[`dcf7646725`](https://github.com/nodejs/node/commit/dcf7646725)] - **tools**: fail tests if malformed status file (Rich Trott) [#16703](https://github.com/nodejs/node/pull/16703)
* [[`d176073511`](https://github.com/nodejs/node/commit/d176073511)] - **tty**: refactor exports (cjihrig) [#16959](https://github.com/nodejs/node/pull/16959)

<a id="6.12.2"></a>
## 2017-12-08, Version 6.12.2 'Boron' (LTS), @MylesBorins

This is a security release. All Node.js users should consult the security release summary at https://nodejs.org/en/blog/vulnerability/december-2017-security-releases/ for details on patched vulnerabilities.

Fixes for the following CVEs are included in this release:

* CVE-2017-15896
* CVE-2017-3738 (from the openssl project)

### Notable Changes

* **deps**:
  * openssl updated to 1.0.2n (Shigeki Ohtsu) [#17526](https://github.com/nodejs/node/pull/17526)

### Commits

* [[`6314a46c48`](https://github.com/nodejs/node/commit/6314a46c48)] - **deps**: update openssl asm and asm_obsolete files (Shigeki Ohtsu) [#17526](https://github.com/nodejs/node/pull/17526)
* [[`f2121a8583`](https://github.com/nodejs/node/commit/f2121a8583)] - **deps**: add -no_rand_screen to openssl s_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`741651cc4b`](https://github.com/nodejs/node/commit/741651cc4b)] - **deps**: fix asm build error of openssl in x86_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`5956aead33`](https://github.com/nodejs/node/commit/5956aead33)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`ac53d01646`](https://github.com/nodejs/node/commit/ac53d01646)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu) [#17526](https://github.com/nodejs/node/pull/17526)
* [[`03651ad9d6`](https://github.com/nodejs/node/commit/03651ad9d6)] - **deps**: upgrade openssl sources to 1.0.2n (Shigeki Ohtsu) [#17526](https://github.com/nodejs/node/pull/17526)
* [[`eb30387c6d`](https://github.com/nodejs/node/commit/eb30387c6d)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)

<a id="6.12.1"></a>
## 2017-12-05, Version 6.12.1 'Boron' (LTS), @MylesBorins

This LTS release comes with 263 commits. This includes 173 which are test related,
41 which are doc related, 18 which are build / tool related and 1 commit which is an update to a dependency.

### Notable Changes

* **build**:
  * fix npm install with --shared (Ben Noordhuis) [#16438](https://github.com/nodejs/node/pull/16438)
* **build**:
  * building with python 3 is now supported (Emily Marigold Klassen) [#16058](https://github.com/nodejs/node/pull/16058)
* **src**:
  * v8 options can be specified with either '\_' or '-' in NODE_OPTIONS (Sam Roberts) [#14093](https://github.com/nodejs/node/pull/14093)

### Commits

* [[`575a920a16`](https://github.com/nodejs/node/commit/575a920a16)] - **assert**: fix actual and expected order (Steve Jenkins) [#15866](https://github.com/nodejs/node/pull/15866)
* [[`a0c1d10e91`](https://github.com/nodejs/node/commit/a0c1d10e91)] - **build**: remove cctest extension (Yihong Wang) [#16680](https://github.com/nodejs/node/pull/16680)
* [[`c287f1235c`](https://github.com/nodejs/node/commit/c287f1235c)] - **build**: include src\tracing when linting on win (Daniel Bevenius) [#16720](https://github.com/nodejs/node/pull/16720)
* [[`706812bc2f`](https://github.com/nodejs/node/commit/706812bc2f)] - **build**: skip bin override on windows (Hitesh Kanwathirtha) [#16460](https://github.com/nodejs/node/pull/16460)
* [[`f4627603aa`](https://github.com/nodejs/node/commit/f4627603aa)] - **build**: fix npm install with --shared (Ben Noordhuis) [#16438](https://github.com/nodejs/node/pull/16438)
* [[`6d63612e93`](https://github.com/nodejs/node/commit/6d63612e93)] - **build**: correct minor typo in lttng help message (Daniel Bevenius) [#16101](https://github.com/nodejs/node/pull/16101)
* [[`de82db7f85`](https://github.com/nodejs/node/commit/de82db7f85)] - **build**: ignore empty folders in test-addons (Gregor) [#16031](https://github.com/nodejs/node/pull/16031)
* [[`ac1beb0fb0`](https://github.com/nodejs/node/commit/ac1beb0fb0)] - **build**: use bin override if no `python` in PATH (Bradley T. Hughes) [#16241](https://github.com/nodejs/node/pull/16241)
* [[`d4b3b633d8`](https://github.com/nodejs/node/commit/d4b3b633d8)] - **build**: allow build with system python 3 (Emily Marigold Klassen) [#16058](https://github.com/nodejs/node/pull/16058)
* [[`fc2ab06014`](https://github.com/nodejs/node/commit/fc2ab06014)] - **build, windows**: use /bigobj for debug builds (Nikolai Vavilov) [#16289](https://github.com/nodejs/node/pull/16289)
* [[`ccca11d026`](https://github.com/nodejs/node/commit/ccca11d026)] - **build,win**: set /MP separately in Debug and Release (Nikolai Vavilov) [#16415](https://github.com/nodejs/node/pull/16415)
* [[`a14f564686`](https://github.com/nodejs/node/commit/a14f564686)] - **build,win**: use /MP for debug builds (Nikolai Vavilov) [#16333](https://github.com/nodejs/node/pull/16333)
* [[`8813867577`](https://github.com/nodejs/node/commit/8813867577)] - **child_process**: set shell to false in fork() (Alex Gresnel) [#15352](https://github.com/nodejs/node/pull/15352)
* [[`f2cafff9b0`](https://github.com/nodejs/node/commit/f2cafff9b0)] - **crypto**: fix error of createCipher in wrap mode (Shigeki Ohtsu) [#15037](https://github.com/nodejs/node/pull/15037)
* [[`7115079c4f`](https://github.com/nodejs/node/commit/7115079c4f)] - **crypto**: warn if counter mode used in createCipher (Shigeki Ohtsu) [#13821](https://github.com/nodejs/node/pull/13821)
* [[`50c3dabc0f`](https://github.com/nodejs/node/commit/50c3dabc0f)] - **deps**: backport 4af8029 from upstream V8 (Michaël Zasso) [#17290](https://github.com/nodejs/node/pull/17290)
* [[`101eb981fe`](https://github.com/nodejs/node/commit/101eb981fe)] - **doc**: mention constant-time in crypto doc (Mithun Sasidharan) [#16604](https://github.com/nodejs/node/pull/16604)
* [[`1bc5c3836c`](https://github.com/nodejs/node/commit/1bc5c3836c)] - **doc**: recommend node-core-utils for metadata (Rich Trott) [#16978](https://github.com/nodejs/node/pull/16978)
* [[`4583f1be0c`](https://github.com/nodejs/node/commit/4583f1be0c)] - **doc**: reorganize COLLABORATOR_GUIDE.md (Rich Trott) [#15710](https://github.com/nodejs/node/pull/15710)
* [[`fce790285f`](https://github.com/nodejs/node/commit/fce790285f)] - **doc**: improve documentation for the vm module (Franziska Hinkelmann) [#16867](https://github.com/nodejs/node/pull/16867)
* [[`727a0fe641`](https://github.com/nodejs/node/commit/727a0fe641)] - **doc**: update subprocess.killed (cjihrig) [#16748](https://github.com/nodejs/node/pull/16748)
* [[`44c0385b04`](https://github.com/nodejs/node/commit/44c0385b04)] - **doc**: more accurate zlib windowBits information (Anna Henningsen) [#16511](https://github.com/nodejs/node/pull/16511)
* [[`732af9b8a4`](https://github.com/nodejs/node/commit/732af9b8a4)] - **doc**: add Gibson Fahnestock to Release team (Gibson Fahnestock) [#16620](https://github.com/nodejs/node/pull/16620)
* [[`935b15285f`](https://github.com/nodejs/node/commit/935b15285f)] - **doc**: slightly relax 50 character rule (James M Snell) [#16523](https://github.com/nodejs/node/pull/16523)
* [[`39c63da6d2`](https://github.com/nodejs/node/commit/39c63da6d2)] - **doc**: add note to releases.md (Jon Moss) [#16507](https://github.com/nodejs/node/pull/16507)
* [[`60ae428f30`](https://github.com/nodejs/node/commit/60ae428f30)] - **doc**: add dot in documentations (erwinwahyura) [#16542](https://github.com/nodejs/node/pull/16542)
* [[`7ae23b744b`](https://github.com/nodejs/node/commit/7ae23b744b)] - **doc**: fix missing newline character (Daijiro Wachi) [#16447](https://github.com/nodejs/node/pull/16447)
* [[`af869f03c1`](https://github.com/nodejs/node/commit/af869f03c1)] - **doc**: add recommendations for first timers (Refael Ackermann) [#16350](https://github.com/nodejs/node/pull/16350)
* [[`b7d609c2f8`](https://github.com/nodejs/node/commit/b7d609c2f8)] - **doc**: replace undocumented encoding aliases (Vse Mozhet Byt) [#16368](https://github.com/nodejs/node/pull/16368)
* [[`2cbf75da7e`](https://github.com/nodejs/node/commit/2cbf75da7e)] - **doc**: replace methods used in the example code (Damian) [#16416](https://github.com/nodejs/node/pull/16416)
* [[`0b5a0ada2a`](https://github.com/nodejs/node/commit/0b5a0ada2a)] - **doc**: fix comment in assert.md (umatoma) [#16335](https://github.com/nodejs/node/pull/16335)
* [[`4fbc490704`](https://github.com/nodejs/node/commit/4fbc490704)] - **doc**: add space after period (Diego Rodríguez Baquero) [#16334](https://github.com/nodejs/node/pull/16334)
* [[`c3cc0fd258`](https://github.com/nodejs/node/commit/c3cc0fd258)] - **doc**: minor correction to note on process section (Daniel Bevenius) [#16311](https://github.com/nodejs/node/pull/16311)
* [[`47bf494979`](https://github.com/nodejs/node/commit/47bf494979)] - **doc**: add apapirovski to collaborators (Anatoli Papirovski) [#16302](https://github.com/nodejs/node/pull/16302)
* [[`9c96d7f4fd`](https://github.com/nodejs/node/commit/9c96d7f4fd)] - **doc**: clarify os.cpus() returns logical CPU cores (Luke Childs) [#16282](https://github.com/nodejs/node/pull/16282)
* [[`ba62b0e48a`](https://github.com/nodejs/node/commit/ba62b0e48a)] - **doc**: support multidimensional arrays in type link (Vse Mozhet Byt) [#16207](https://github.com/nodejs/node/pull/16207)
* [[`aefaed40f0`](https://github.com/nodejs/node/commit/aefaed40f0)] - **doc**: move Shigeki to TSC Emeritus (Rich Trott) [#16195](https://github.com/nodejs/node/pull/16195)
* [[`1fdcf75f9c`](https://github.com/nodejs/node/commit/1fdcf75f9c)] - **doc**: Update a typo in module.js' comments (Orta) [#16205](https://github.com/nodejs/node/pull/16205)
* [[`799c6fdc1c`](https://github.com/nodejs/node/commit/799c6fdc1c)] - **doc**: add missing comma (Jon Moss) [#16204](https://github.com/nodejs/node/pull/16204)
* [[`8c070f9ed5`](https://github.com/nodejs/node/commit/8c070f9ed5)] - **doc**: added note to fs.watchFile on previousStat (NiveditN) [#16099](https://github.com/nodejs/node/pull/16099)
* [[`2515cad90e`](https://github.com/nodejs/node/commit/2515cad90e)] - **doc**: ensure collaborators validate commits (Bradley Farias) [#16162](https://github.com/nodejs/node/pull/16162)
* [[`7647d41da1`](https://github.com/nodejs/node/commit/7647d41da1)] - **doc**: move 8 collaborators to emeriti (Rich Trott) [#16173](https://github.com/nodejs/node/pull/16173)
* [[`de8155ebf2`](https://github.com/nodejs/node/commit/de8155ebf2)] - **doc**: include V8 commit URL in V8 backport guide (Gibson Fahnestock) [#16054](https://github.com/nodejs/node/pull/16054)
* [[`6f1ba792d7`](https://github.com/nodejs/node/commit/6f1ba792d7)] - **doc**: add pronoun for fhinkel (F. Hinkelmann) [#16069](https://github.com/nodejs/node/pull/16069)
* [[`8da3b51472`](https://github.com/nodejs/node/commit/8da3b51472)] - **doc**: document windows shell support (Tim Ermilov) [#16104](https://github.com/nodejs/node/pull/16104)
* [[`281023b20d`](https://github.com/nodejs/node/commit/281023b20d)] - **doc**: exempt test/doc only changes from 48-hr rule (Anna Henningsen) [#16135](https://github.com/nodejs/node/pull/16135)
* [[`04d5835722`](https://github.com/nodejs/node/commit/04d5835722)] - **doc**: rename good first contrib label (Jeremiah Senkpiel) [#16150](https://github.com/nodejs/node/pull/16150)
* [[`1064258f9d`](https://github.com/nodejs/node/commit/1064258f9d)] - **doc**: remove bold typography from STYLE_GUIDE.md (Rich Trott) [#16085](https://github.com/nodejs/node/pull/16085)
* [[`23e9bba9c8`](https://github.com/nodejs/node/commit/23e9bba9c8)] - **doc**: ctc -\> tsc in onboarding extras (Bryan English) [#15621](https://github.com/nodejs/node/pull/15621)
* [[`ff66d63642`](https://github.com/nodejs/node/commit/ff66d63642)] - **doc**: fix emitKeypressEvents stream type (Oblosys) [#15399](https://github.com/nodejs/node/pull/15399)
* [[`1bd6962842`](https://github.com/nodejs/node/commit/1bd6962842)] - **doc**: make stream.Readable consistent (Sakthipriyan Vairamani (thefourtheye)) [#16786](https://github.com/nodejs/node/pull/16786)
* [[`6b9bd51021`](https://github.com/nodejs/node/commit/6b9bd51021)] - **doc**: correct effects to affects (gowpen) [#16794](https://github.com/nodejs/node/pull/16794)
* [[`6af9311939`](https://github.com/nodejs/node/commit/6af9311939)] - **doc**: correct EventEmitter reference (gowpen) [#16791](https://github.com/nodejs/node/pull/16791)
* [[`1a633e3cd8`](https://github.com/nodejs/node/commit/1a633e3cd8)] - **doc**: add docs for Zlib#close() (Luigi Pinca) [#16592](https://github.com/nodejs/node/pull/16592)
* [[`290df5ac41`](https://github.com/nodejs/node/commit/290df5ac41)] - **doc**: add details about rss on process.memoryUsage (Anthony Nandaa) [#16566](https://github.com/nodejs/node/pull/16566)
* [[`3e6da45ce0`](https://github.com/nodejs/node/commit/3e6da45ce0)] - **doc**: howto decode buffers extending from Writable (dicearr) [#16403](https://github.com/nodejs/node/pull/16403)
* [[`c64ed977fc`](https://github.com/nodejs/node/commit/c64ed977fc)] - **doc, win**: remove note about resize (Bartosz Sosnowski) [#16320](https://github.com/nodejs/node/pull/16320)
* [[`644989cf6a`](https://github.com/nodejs/node/commit/644989cf6a)] - **fs**: use Number::New since all fields are uint64_t (Huáng Jùnliàng) [#16705](https://github.com/nodejs/node/pull/16705)
* [[`925e58fecb`](https://github.com/nodejs/node/commit/925e58fecb)] - **fs**: fix stat dev unsigned cast overflow (Huáng Jùnliàng) [#16705](https://github.com/nodejs/node/pull/16705)
* [[`92b13e455f`](https://github.com/nodejs/node/commit/92b13e455f)] - **https**: Use secureProtocol in Agent#getName (Andreas Lind) [#9452](https://github.com/nodejs/node/pull/9452)
* [[`b0ac76d145`](https://github.com/nodejs/node/commit/b0ac76d145)] - **meta**: add note about email sync to CONTRIBUTING.md (Vse Mozhet Byt) [#16340](https://github.com/nodejs/node/pull/16340)
* [[`bf7f63d51b`](https://github.com/nodejs/node/commit/bf7f63d51b)] - **net**: change assert to conform to other files (James Hodgskiss) [#15861](https://github.com/nodejs/node/pull/15861)
* [[`ae3ad5502b`](https://github.com/nodejs/node/commit/ae3ad5502b)] - **src**: remove unused includes from node_wrap.h (Daniel Bevenius) [#16179](https://github.com/nodejs/node/pull/16179)
* [[`a368e5fa63`](https://github.com/nodejs/node/commit/a368e5fa63)] - **src**: make StreamBase prototype accessors robust (Joyee Cheung) [#16860](https://github.com/nodejs/node/pull/16860)
* [[`c79dd9e3ce`](https://github.com/nodejs/node/commit/c79dd9e3ce)] - **src**: CHECK() for argument overflow in Spawn() (cjihrig) [#16761](https://github.com/nodejs/node/pull/16761)
* [[`7c69ca58e0`](https://github.com/nodejs/node/commit/7c69ca58e0)] - **src**: move handle properties to prototype (Ben Noordhuis) [#16482](https://github.com/nodejs/node/pull/16482)
* [[`c87a620ed8`](https://github.com/nodejs/node/commit/c87a620ed8)] - **src**: remove superfluous HandleScope (Ben Noordhuis) [#16482](https://github.com/nodejs/node/pull/16482)
* [[`2f5edc6fd5`](https://github.com/nodejs/node/commit/2f5edc6fd5)] - **src**: remove unused include in tty_wrap.h (Daniel Bevenius) [#16379](https://github.com/nodejs/node/pull/16379)
* [[`42cb64ee91`](https://github.com/nodejs/node/commit/42cb64ee91)] - **src**: fix etw provider include on Windows (Joyee Cheung) [#16639](https://github.com/nodejs/node/pull/16639)
* [[`b00ced5b52`](https://github.com/nodejs/node/commit/b00ced5b52)] - **src**: do not include x.h if x-inl.h is included (Joyee Cheung) [#16548](https://github.com/nodejs/node/pull/16548)
* [[`a4688b0c43`](https://github.com/nodejs/node/commit/a4688b0c43)] - **src**: make header file self-contained (Joyee Cheung) [#16518](https://github.com/nodejs/node/pull/16518)
* [[`cf80089477`](https://github.com/nodejs/node/commit/cf80089477)] - **src**: node_dtrace line continuations clean up (Daniel Bevenius) [#15777](https://github.com/nodejs/node/pull/15777)
* [[`4639cfff0a`](https://github.com/nodejs/node/commit/4639cfff0a)] - **src**: rename perfctr_macros.py-\>noperfctr_macros.py (Daniel Bevenius) [#16100](https://github.com/nodejs/node/pull/16100)
* [[`70f574e6ff`](https://github.com/nodejs/node/commit/70f574e6ff)] - **src**: add help for NODE_PENDING_DEPRECATION env (Thomas Corbière) [#15609](https://github.com/nodejs/node/pull/15609)
* [[`75b1e30e6b`](https://github.com/nodejs/node/commit/75b1e30e6b)] - **src**: add --pending-deprecation to NODE_OPTIONS (Thomas Corbière) [#15494](https://github.com/nodejs/node/pull/15494)
* [[`f659e49862`](https://github.com/nodejs/node/commit/f659e49862)] - **src**: whitelist v8 options with '_' or '-' (Sam Roberts) [#14093](https://github.com/nodejs/node/pull/14093)
* [[`79171e0c2f`](https://github.com/nodejs/node/commit/79171e0c2f)] - **src**: turn key length exception into CHECK (Ben Noordhuis) [#15183](https://github.com/nodejs/node/pull/15183)
* [[`e18df46092`](https://github.com/nodejs/node/commit/e18df46092)] - **src**: notify V8 for low memory when alloc fails (Anna Henningsen) [#8482](https://github.com/nodejs/node/pull/8482)
* [[`6a0eb9f6cf`](https://github.com/nodejs/node/commit/6a0eb9f6cf)] - **src**: provide allocation + nullptr check shortcuts (Anna Henningsen) [#8482](https://github.com/nodejs/node/pull/8482)
* [[`4aec8cfcd2`](https://github.com/nodejs/node/commit/4aec8cfcd2)] - **src**: pass desired return type to allocators (Anna Henningsen) [#8482](https://github.com/nodejs/node/pull/8482)
* [[`19f3ac9749`](https://github.com/nodejs/node/commit/19f3ac9749)] - **src**: add Malloc() size param + overflow detection (Anna Henningsen) [#8482](https://github.com/nodejs/node/pull/8482)
* [[`6269ba334d`](https://github.com/nodejs/node/commit/6269ba334d)] - **test**: allow tests to pass without internet (Daniel Bevenius) [#16255](https://github.com/nodejs/node/pull/16255)
* [[`f0eeddb4b8`](https://github.com/nodejs/node/commit/f0eeddb4b8)] - **test**: reuse existing PassThrough implementation (Tobias Nießen) [#16936](https://github.com/nodejs/node/pull/16936)
* [[`4752fc4336`](https://github.com/nodejs/node/commit/4752fc4336)] - **test**: refactor comments in test-child-process-spawnsync-maxbuf (ChrBergert) [#16829](https://github.com/nodejs/node/pull/16829)
* [[`f226ca6b12`](https://github.com/nodejs/node/commit/f226ca6b12)] - **test**: used fixturesDir from fixtures modules (Klemen Kogovsek) [#16813](https://github.com/nodejs/node/pull/16813)
* [[`5e2231e407`](https://github.com/nodejs/node/commit/5e2231e407)] - **test**: add a test description (Grant Gasparyan) [#16833](https://github.com/nodejs/node/pull/16833)
* [[`a8cff7ad4a`](https://github.com/nodejs/node/commit/a8cff7ad4a)] - **test**: use common/fixtures module in hash-seed test (Javier Blanco) [#16823](https://github.com/nodejs/node/pull/16823)
* [[`090cc9713e`](https://github.com/nodejs/node/commit/090cc9713e)] - **test**: improve template value for test message (Stephan Smith) [#16826](https://github.com/nodejs/node/pull/16826)
* [[`1d3793eb77`](https://github.com/nodejs/node/commit/1d3793eb77)] - **test**: change concatenated string to template (Deepthi Sebastian) [#16929](https://github.com/nodejs/node/pull/16929)
* [[`79dfc3f475`](https://github.com/nodejs/node/commit/79dfc3f475)] - **test**: change concatenated string to template (Anawesha Khuntia) [#16912](https://github.com/nodejs/node/pull/16912)
* [[`2232231d4f`](https://github.com/nodejs/node/commit/2232231d4f)] - **test**: change string concatenation to template (Suryanarayana Murthy N) [#16919](https://github.com/nodejs/node/pull/16919)
* [[`674cbf8402`](https://github.com/nodejs/node/commit/674cbf8402)] - **test**: replace string concatenation with template (Kabir Islam) [#16916](https://github.com/nodejs/node/pull/16916)
* [[`969defaae9`](https://github.com/nodejs/node/commit/969defaae9)] - **test**: enable mustCall() during child exit (Vipin Menon) [#16915](https://github.com/nodejs/node/pull/16915)
* [[`9d4abaa243`](https://github.com/nodejs/node/commit/9d4abaa243)] - **test**: replace string concatenation with template (Tanvi Kini) [#16913](https://github.com/nodejs/node/pull/16913)
* [[`2a1ebae567`](https://github.com/nodejs/node/commit/2a1ebae567)] - **test**: cover vm.runInNewContext() (cjihrig) [#16906](https://github.com/nodejs/node/pull/16906)
* [[`2043ce39d5`](https://github.com/nodejs/node/commit/2043ce39d5)] - **test**: improve assertion messages (Neil Vass) [#16885](https://github.com/nodejs/node/pull/16885)
* [[`668644008e`](https://github.com/nodejs/node/commit/668644008e)] - **test**: improve assert messages in stream test (Katie Stockton Roberts) [#16884](https://github.com/nodejs/node/pull/16884)
* [[`714eb0bc7c`](https://github.com/nodejs/node/commit/714eb0bc7c)] - **test**: improve assertion in test-require-dot (Adam Wegrzynek) [#16805](https://github.com/nodejs/node/pull/16805)
* [[`8e5b4f543c`](https://github.com/nodejs/node/commit/8e5b4f543c)] - **test**: add values to error message (Adam Jeffery) [#16831](https://github.com/nodejs/node/pull/16831)
* [[`b3b7858a97`](https://github.com/nodejs/node/commit/b3b7858a97)] - **test**: replace common.fixtiresDir with fixtures.readKey() (woj) [#16817](https://github.com/nodejs/node/pull/16817)
* [[`3acf156b68`](https://github.com/nodejs/node/commit/3acf156b68)] - **test**: remove message argument in cluster setup test (mbornath) [#16838](https://github.com/nodejs/node/pull/16838)
* [[`cedf8a1cb2`](https://github.com/nodejs/node/commit/cedf8a1cb2)] - **test**: move test-http-keepalive-maxsockets to sequential (Rich Trott) [#16777](https://github.com/nodejs/node/pull/16777)
* [[`ffbb4e68e8`](https://github.com/nodejs/node/commit/ffbb4e68e8)] - **test**: use default assertion message (jonask) [#16819](https://github.com/nodejs/node/pull/16819)
* [[`dd558a56af`](https://github.com/nodejs/node/commit/dd558a56af)] - **test**: include file mode in assert message (Sascha Tandel) [#16815](https://github.com/nodejs/node/pull/16815)
* [[`3d8b3f7b4a`](https://github.com/nodejs/node/commit/3d8b3f7b4a)] - **test**: refactor tls test to use fixtres.readSync (Brian O'Connell) [#16816](https://github.com/nodejs/node/pull/16816)
* [[`54d4557199`](https://github.com/nodejs/node/commit/54d4557199)] - **test**: use fixtures module in test-repl (Maring, Damian Lion) [#16809](https://github.com/nodejs/node/pull/16809)
* [[`9f9e824fc5`](https://github.com/nodejs/node/commit/9f9e824fc5)] - **test**: update test to use fixtures.readKey (Dara Hayes) [#16811](https://github.com/nodejs/node/pull/16811)
* [[`a99755f3fd`](https://github.com/nodejs/node/commit/a99755f3fd)] - **test**: fix typos in read-buffer tests (Jimi van der Woning) [#16834](https://github.com/nodejs/node/pull/16834)
* [[`e7a456a5ee`](https://github.com/nodejs/node/commit/e7a456a5ee)] - **test**: replace common.fixturesDir with fixtures module (Dumitru Glavan) [#16803](https://github.com/nodejs/node/pull/16803)
* [[`04af0fdab7`](https://github.com/nodejs/node/commit/04af0fdab7)] - **test**: replace common.fixturesDir with fixtures.readSync() (Adri Van Houdt) [#16802](https://github.com/nodejs/node/pull/16802)
* [[`755f5e3fd1`](https://github.com/nodejs/node/commit/755f5e3fd1)] - **test**: update test to use fixtures (Adam Wegrzynek) [#16799](https://github.com/nodejs/node/pull/16799)
* [[`143d8a1b3d`](https://github.com/nodejs/node/commit/143d8a1b3d)] - **test**: fix typo (Oscar Funes) [#15938](https://github.com/nodejs/node/pull/15938)
* [[`84741fdc81`](https://github.com/nodejs/node/commit/84741fdc81)] - **test**: update test-timers-block-eventloop.js (zhangzifa) [#16314](https://github.com/nodejs/node/pull/16314)
* [[`8e62fcb2cf`](https://github.com/nodejs/node/commit/8e62fcb2cf)] - **test**: replace fixturesDir in test-tls-connect (Casie Lynch) [#15849](https://github.com/nodejs/node/pull/15849)
* [[`d6dc579f3c`](https://github.com/nodejs/node/commit/d6dc579f3c)] - **test**: use fixtures module (Iryna Yaremtso) [#15901](https://github.com/nodejs/node/pull/15901)
* [[`10c24a157c`](https://github.com/nodejs/node/commit/10c24a157c)] - **test**: add details in assertions in test-vm-context (Vladimir Ilic) [#16116](https://github.com/nodejs/node/pull/16116)
* [[`cb1d16d26b`](https://github.com/nodejs/node/commit/cb1d16d26b)] - **test**: increase fs.exists coverage (Nigel Kibodeaux) [#15963](https://github.com/nodejs/node/pull/15963)
* [[`d3981ae552`](https://github.com/nodejs/node/commit/d3981ae552)] - **test**: use fixtures module in test-fs-realpath.js (Raphael Rheault) [#15904](https://github.com/nodejs/node/pull/15904)
* [[`532c9606b3`](https://github.com/nodejs/node/commit/532c9606b3)] - **test**: use fixtures module (Scott J Beck) [#15843](https://github.com/nodejs/node/pull/15843)
* [[`58fe9b4ec3`](https://github.com/nodejs/node/commit/58fe9b4ec3)] - **test**: imporove assert messages (Hadis-Fard) [#16021](https://github.com/nodejs/node/pull/16021)
* [[`91f9779794`](https://github.com/nodejs/node/commit/91f9779794)] - **test**: show values instead of assertion message (Cheyenne Arrowsmith) [#15979](https://github.com/nodejs/node/pull/15979)
* [[`0ace5a158d`](https://github.com/nodejs/node/commit/0ace5a158d)] - **test**: include values in assertion messages (nhoel) [#15996](https://github.com/nodejs/node/pull/15996)
* [[`8663b05711`](https://github.com/nodejs/node/commit/8663b05711)] - **test**: use process.features.debug in common module (Rich Trott) [#16537](https://github.com/nodejs/node/pull/16537)
* [[`1fffa165a1`](https://github.com/nodejs/node/commit/1fffa165a1)] - **test**: use common.buildType in repl-domain-abort (Rich Trott) [#16538](https://github.com/nodejs/node/pull/16538)
* [[`7d93da54bb`](https://github.com/nodejs/node/commit/7d93da54bb)] - **test**: skip test-process-config if no config.gypi (Gibson Fahnestock) [#16436](https://github.com/nodejs/node/pull/16436)
* [[`5c20164354`](https://github.com/nodejs/node/commit/5c20164354)] - **test**: use fixtures module in tls-handshake-error (Mark Walker) [#15939](https://github.com/nodejs/node/pull/15939)
* [[`4f04d15aa3`](https://github.com/nodejs/node/commit/4f04d15aa3)] - **test**: add failing vm tests to known_issues (Michaël Zasso) [#16410](https://github.com/nodejs/node/pull/16410)
* [[`2b1042bb29`](https://github.com/nodejs/node/commit/2b1042bb29)] - **test**: allow for different nsswitch.conf settings (Daniel Bevenius) [#16378](https://github.com/nodejs/node/pull/16378)
* [[`5095b991c0`](https://github.com/nodejs/node/commit/5095b991c0)] - **test**: handle blank shells in test-os.js (Gibson Fahnestock) [#16287](https://github.com/nodejs/node/pull/16287)
* [[`62dd6a2c40`](https://github.com/nodejs/node/commit/62dd6a2c40)] - **test**: increase enoughTestMem to 1.75 Gb (Rich Trott) [#16374](https://github.com/nodejs/node/pull/16374)
* [[`9c229b4bd3`](https://github.com/nodejs/node/commit/9c229b4bd3)] - **test**: use fixtures.readKey in https-timeout-server (Nicolas 'Pixel' Noble) [#15871](https://github.com/nodejs/node/pull/15871)
* [[`773652903d`](https://github.com/nodejs/node/commit/773652903d)] - **test**: use fixtures.readKey instead of fixturesDir (Paul Marion Camantigue) [#15976](https://github.com/nodejs/node/pull/15976)
* [[`34dfce7710`](https://github.com/nodejs/node/commit/34dfce7710)] - **test**: replace fixturesDir with fixtures module (tpurcell) [#16262](https://github.com/nodejs/node/pull/16262)
* [[`0a88e1bd60`](https://github.com/nodejs/node/commit/0a88e1bd60)] - **test**: replace fixturesDir with fixtures module (André Føyn Berge) [#15947](https://github.com/nodejs/node/pull/15947)
* [[`9e74e542a2`](https://github.com/nodejs/node/commit/9e74e542a2)] - **test**: skip test due to file size limit (jBarz) [#16273](https://github.com/nodejs/node/pull/16273)
* [[`e070e592dd`](https://github.com/nodejs/node/commit/e070e592dd)] - **test**: remove error msg in test-vm-symbols.js (Daniel Abrão) [#15873](https://github.com/nodejs/node/pull/15873)
* [[`257ece287c`](https://github.com/nodejs/node/commit/257ece287c)] - **test**: remove error messages in test-buffer-alloc (Braden Whitten) [#15867](https://github.com/nodejs/node/pull/15867)
* [[`32fa91519a`](https://github.com/nodejs/node/commit/32fa91519a)] - **test**: update assert error messages (Omar Gonzalez) [#16035](https://github.com/nodejs/node/pull/16035)
* [[`da85e6c552`](https://github.com/nodejs/node/commit/da85e6c552)] - **test**: expand error message (Stefania Sharp) [#15991](https://github.com/nodejs/node/pull/15991)
* [[`cbbe125f71`](https://github.com/nodejs/node/commit/cbbe125f71)] - **test**: use fixtures module (Kanika Shah) [#15959](https://github.com/nodejs/node/pull/15959)
* [[`6f15b011c0`](https://github.com/nodejs/node/commit/6f15b011c0)] - **test**: remove literal messages (Oscar Funes) [#15938](https://github.com/nodejs/node/pull/15938)
* [[`aa269ad59b`](https://github.com/nodejs/node/commit/aa269ad59b)] - **test**: fix stderr reference (Oscar Funes) [#15938](https://github.com/nodejs/node/pull/15938)
* [[`3f35fc063e`](https://github.com/nodejs/node/commit/3f35fc063e)] - **test**: use fixtures module in test-https-truncate (Gene Wu) [#15875](https://github.com/nodejs/node/pull/15875)
* [[`c58eaaf1a8`](https://github.com/nodejs/node/commit/c58eaaf1a8)] - **test**: use fixtures module (Alvaro Cruz) [#15874](https://github.com/nodejs/node/pull/15874)
* [[`48e1320c44`](https://github.com/nodejs/node/commit/48e1320c44)] - **test**: use fixtures module (Lance Barlaan) [#15872](https://github.com/nodejs/node/pull/15872)
* [[`339bdca558`](https://github.com/nodejs/node/commit/339bdca558)] - **test**: use default message for assert.strictEqual (hwaisiu) [#15970](https://github.com/nodejs/node/pull/15970)
* [[`ab580c3ae2`](https://github.com/nodejs/node/commit/ab580c3ae2)] - **test**: improve assert message in internet test (Nikki St Onge) [#15998](https://github.com/nodejs/node/pull/15998)
* [[`6285e7221e`](https://github.com/nodejs/node/commit/6285e7221e)] - **test**: replace common.fixturesDir (Shawn McGinty) [#15834](https://github.com/nodejs/node/pull/15834)
* [[`fa8315cb68`](https://github.com/nodejs/node/commit/fa8315cb68)] - **test**: refactor test-process-kill-null (Luigi Pinca) [#16236](https://github.com/nodejs/node/pull/16236)
* [[`c26abc8e94`](https://github.com/nodejs/node/commit/c26abc8e94)] - **test**: add missing spaces in concatenations (Vse Mozhet Byt) [#16244](https://github.com/nodejs/node/pull/16244)
* [[`a94a75f69a`](https://github.com/nodejs/node/commit/a94a75f69a)] - **test**: update output to include exit code & signal (Jenna Zeigen) [#15945](https://github.com/nodejs/node/pull/15945)
* [[`8eb84d6780`](https://github.com/nodejs/node/commit/8eb84d6780)] - **test**: change common.fixturesDir to fixtures.path (tejbirsingh) [#15860](https://github.com/nodejs/node/pull/15860)
* [[`806f03e54c`](https://github.com/nodejs/node/commit/806f03e54c)] - **test**: split up and refactor test-domain (Anna Henningsen) [#13614](https://github.com/nodejs/node/pull/13614)
* [[`e5fbc03563`](https://github.com/nodejs/node/commit/e5fbc03563)] - **test**: replace fixturesDir with common.fixtures (Kasim Doctor) [#15810](https://github.com/nodejs/node/pull/15810)
* [[`2ab826c497`](https://github.com/nodejs/node/commit/2ab826c497)] - **test**: replaced fs.readSync with fixtures.readSync (Lam Chan) [#15882](https://github.com/nodejs/node/pull/15882)
* [[`1fe3e866cf`](https://github.com/nodejs/node/commit/1fe3e866cf)] - **test**: improve coverage for process.umask (Evan Lucas) [#16188](https://github.com/nodejs/node/pull/16188)
* [[`0689ea66ed`](https://github.com/nodejs/node/commit/0689ea66ed)] - **test**: remove message from notStrictEqual (twk-b) [#16048](https://github.com/nodejs/node/pull/16048)
* [[`fafbbb6347`](https://github.com/nodejs/node/commit/fafbbb6347)] - **test**: use fixtures module (Ben Hallion) [#15808](https://github.com/nodejs/node/pull/15808)
* [[`f2108fa51d`](https://github.com/nodejs/node/commit/f2108fa51d)] - **test**: use ES6 classes instead of util.inherits (Tobias Nießen) [#16938](https://github.com/nodejs/node/pull/16938)
* [[`eb11a70424`](https://github.com/nodejs/node/commit/eb11a70424)] - **test**: refactor test-cluster-setup-master (Jean-Baptiste Brossard) [#16065](https://github.com/nodejs/node/pull/16065)
* [[`e00a4c820f`](https://github.com/nodejs/node/commit/e00a4c820f)] - **test**: replace fixtureDir with fixtures methods (Vladimir Ilic) [#16114](https://github.com/nodejs/node/pull/16114)
* [[`f46e1187b3`](https://github.com/nodejs/node/commit/f46e1187b3)] - **test**: remove error messages in crypto-binary test (Kim Gentes) [#15981](https://github.com/nodejs/node/pull/15981)
* [[`086d8519a1`](https://github.com/nodejs/node/commit/086d8519a1)] - **test**: use fixtures module over fixturesDir (JamesNimlos) [#15847](https://github.com/nodejs/node/pull/15847)
* [[`38179fd1ed`](https://github.com/nodejs/node/commit/38179fd1ed)] - **test**: use common.fixtures module (Shaun Sweet) [#15992](https://github.com/nodejs/node/pull/15992)
* [[`229a1fa299`](https://github.com/nodejs/node/commit/229a1fa299)] - **test**: replace fixturesDir with fixtures.path (Bear Trickey) [#15994](https://github.com/nodejs/node/pull/15994)
* [[`c10594f70f`](https://github.com/nodejs/node/commit/c10594f70f)] - **test**: update fixturesDir import (Tyler Seabrook) [#15887](https://github.com/nodejs/node/pull/15887)
* [[`53449f303f`](https://github.com/nodejs/node/commit/53449f303f)] - **test**: replace fixturesDir with fixtures methods (Komivi Agbakpem) [#15967](https://github.com/nodejs/node/pull/15967)
* [[`a28d666f0e`](https://github.com/nodejs/node/commit/a28d666f0e)] - **test**: replace fixturesDir with the fixtures module (WeiPlanet) [#16027](https://github.com/nodejs/node/pull/16027)
* [[`d59175090d`](https://github.com/nodejs/node/commit/d59175090d)] - **test**: change crypto decipheriv assertion messages (Daniel Kostro) [#16007](https://github.com/nodejs/node/pull/16007)
* [[`541866ea86`](https://github.com/nodejs/node/commit/541866ea86)] - **test**: replaces fixturesDir with fixtures (Mike Fleming) [#15835](https://github.com/nodejs/node/pull/15835)
* [[`57ae105c72`](https://github.com/nodejs/node/commit/57ae105c72)] - **test**: remove test messages for assert.strictEqual (Ali Groening) [#15995](https://github.com/nodejs/node/pull/15995)
* [[`87b9b7c8c4`](https://github.com/nodejs/node/commit/87b9b7c8c4)] - **test**: move to common.fixtures (Justin Beckwith) [#15987](https://github.com/nodejs/node/pull/15987)
* [[`72f69f3c2c`](https://github.com/nodejs/node/commit/72f69f3c2c)] - **test**: added fixtures module (Michael Pal) [#15980](https://github.com/nodejs/node/pull/15980)
* [[`65c5ff8e92`](https://github.com/nodejs/node/commit/65c5ff8e92)] - **test**: use fixtures in test-tls-multi-key.js (Cheyenne Arrowsmith) [#15844](https://github.com/nodejs/node/pull/15844)
* [[`9eac5aab8c`](https://github.com/nodejs/node/commit/9eac5aab8c)] - **test**: switch to use common.fixtures.fixturesDir (Roger Jiang) [#15814](https://github.com/nodejs/node/pull/15814)
* [[`449538851c`](https://github.com/nodejs/node/commit/449538851c)] - **test**: use common.fixtures module (Chi-chi Wang) [#16012](https://github.com/nodejs/node/pull/16012)
* [[`04f3f6dd6a`](https://github.com/nodejs/node/commit/04f3f6dd6a)] - **test**: escape script filename on Windows (Bartosz Sosnowski) [#16124](https://github.com/nodejs/node/pull/16124)
* [[`501acdf38c`](https://github.com/nodejs/node/commit/501acdf38c)] - **test**: improve assert message in test-dh-regr (Mabry Cervin) [#15912](https://github.com/nodejs/node/pull/15912)
* [[`4c98e07702`](https://github.com/nodejs/node/commit/4c98e07702)] - **test**: fixtures in test-net-pipe-connect-errors (Eric Freiberg) [#15922](https://github.com/nodejs/node/pull/15922)
* [[`244bfb398d`](https://github.com/nodejs/node/commit/244bfb398d)] - **test**: fixtures in test-process-redirect-warnings-env (Kat Rosario) [#15930](https://github.com/nodejs/node/pull/15930)
* [[`18479d3cff`](https://github.com/nodejs/node/commit/18479d3cff)] - **test**: fix ordering of strictEqual actual/expected (Chad Zezula) [#16008](https://github.com/nodejs/node/pull/16008)
* [[`66fd6a1409`](https://github.com/nodejs/node/commit/66fd6a1409)] - **test**: use fixtures.readSync (szhang351)
* [[`6d33564b1a`](https://github.com/nodejs/node/commit/6d33564b1a)] - **test**: replaced fixturesDir with common.fixtures (Dolapo Toki) [#15836](https://github.com/nodejs/node/pull/15836)
* [[`a6f04bec9e`](https://github.com/nodejs/node/commit/a6f04bec9e)] - **test**: use fixtures.fixturesDir (Gene Wu) [#15822](https://github.com/nodejs/node/pull/15822)
* [[`2103453977`](https://github.com/nodejs/node/commit/2103453977)] - **test**: replaces fixturesDir with fixtures methods (Christian Murphy) [#15817](https://github.com/nodejs/node/pull/15817)
* [[`e705ad2076`](https://github.com/nodejs/node/commit/e705ad2076)] - **test**: fixtures in test-process-redirect-warnings (Nicolas Chaulet) [#15917](https://github.com/nodejs/node/pull/15917)
* [[`9ddbcc877b`](https://github.com/nodejs/node/commit/9ddbcc877b)] - **test**: update test-crypto-from-binary (Raj Parekh) [#16011](https://github.com/nodejs/node/pull/16011)
* [[`6b8830c1df`](https://github.com/nodejs/node/commit/6b8830c1df)] - **test**: use fixtures in test-https-set-timeout-server (Bob Clewell) [#15886](https://github.com/nodejs/node/pull/15886)
* [[`57590cd097`](https://github.com/nodejs/node/commit/57590cd097)] - **test**: make use of common/fixtures.fixturesDir (Jem Bezooyen) [#15815](https://github.com/nodejs/node/pull/15815)
* [[`c9d07faa04`](https://github.com/nodejs/node/commit/c9d07faa04)] - **test**: use common/fixtures in test-https-close (Alberto Lopez de Lara) [#15870](https://github.com/nodejs/node/pull/15870)
* [[`68a2d394dd`](https://github.com/nodejs/node/commit/68a2d394dd)] - **test**: use fixtures in test-process-warnings (Suresh Srinivas) [#15869](https://github.com/nodejs/node/pull/15869)
* [[`28756b318a`](https://github.com/nodejs/node/commit/28756b318a)] - **test**: use fixtures in tls-friendly-error-message (tobyfarley) [#15905](https://github.com/nodejs/node/pull/15905)
* [[`a05fe5f716`](https://github.com/nodejs/node/commit/a05fe5f716)] - **test**: use common/fixtures in tls-connect-no-host (Donovan Buck) [#15986](https://github.com/nodejs/node/pull/15986)
* [[`cf31eb7532`](https://github.com/nodejs/node/commit/cf31eb7532)] - **test**: use common/fixtures in test-https-agent (jpaulptr) [#15941](https://github.com/nodejs/node/pull/15941)
* [[`c9c37d076c`](https://github.com/nodejs/node/commit/c9c37d076c)] - **test**: use common fixtures module (Kat Rosario) [#15856](https://github.com/nodejs/node/pull/15856)
* [[`76ab029bea`](https://github.com/nodejs/node/commit/76ab029bea)] - **test**: fs.readFileSync -\> fixtures.readKey (Ethan Brown) [#16030](https://github.com/nodejs/node/pull/16030)
* [[`dabdb2d186`](https://github.com/nodejs/node/commit/dabdb2d186)] - **test**: reduce run time for misc benchmark tests (Rich Trott) [#16120](https://github.com/nodejs/node/pull/16120)
* [[`3f56ac4450`](https://github.com/nodejs/node/commit/3f56ac4450)] - **test**: improve assertion message in dgram test (Shakeel Mohamed) [#16121](https://github.com/nodejs/node/pull/16121)
* [[`44a60c3807`](https://github.com/nodejs/node/commit/44a60c3807)] - **test**: use of fixtures in test-pipe-head (Nicolas Chaulet) [#15868](https://github.com/nodejs/node/pull/15868)
* [[`c4db4e44b8`](https://github.com/nodejs/node/commit/c4db4e44b8)] - **test**: use fixtures in test-https-localaddress.js (Charles T Wall III) [#15811](https://github.com/nodejs/node/pull/15811)
* [[`c252d874d7`](https://github.com/nodejs/node/commit/c252d874d7)] - **test**: use common/fixtures in fs-symlink test (AlexeyM) [#15830](https://github.com/nodejs/node/pull/15830)
* [[`07c14f3054`](https://github.com/nodejs/node/commit/07c14f3054)] - **test**: replace common.fixtures with fixtures module (Jonathan Eskew) [#15877](https://github.com/nodejs/node/pull/15877)
* [[`0f23836e7b`](https://github.com/nodejs/node/commit/0f23836e7b)] - **test**: improve assert message (Tri Nguyen) [#15909](https://github.com/nodejs/node/pull/15909)
* [[`bbdbf8b9b0`](https://github.com/nodejs/node/commit/bbdbf8b9b0)] - **test**: replace fixturesDir with fixtures method (suraiyah) [#15894](https://github.com/nodejs/node/pull/15894)
* [[`c35420d21d`](https://github.com/nodejs/node/commit/c35420d21d)] - **test**: normalize fixtures use (Ruxandra Fediuc) [#15855](https://github.com/nodejs/node/pull/15855)
* [[`3c176fd6f6`](https://github.com/nodejs/node/commit/3c176fd6f6)] - **test**: replace common.fixturesDir w/common.fixtures (Jason Walton) [#15853](https://github.com/nodejs/node/pull/15853)
* [[`77f9ef32bd`](https://github.com/nodejs/node/commit/77f9ef32bd)] - **test**: switch to use common.fixtures module for fixturesDir (r1cebank) [#15821](https://github.com/nodejs/node/pull/15821)
* [[`71e68799ef`](https://github.com/nodejs/node/commit/71e68799ef)] - **test**: fixturesDir replaced to fixtures module (Pawel Golda) [#15809](https://github.com/nodejs/node/pull/15809)
* [[`d70f9f6a35`](https://github.com/nodejs/node/commit/d70f9f6a35)] - **test**: replace common.fixturesDir with fixtures (Stefania Sharp) [#16015](https://github.com/nodejs/node/pull/16015)
* [[`4cf84ea76e`](https://github.com/nodejs/node/commit/4cf84ea76e)] - **test**: replaces common.fixturesDir usage (Ruy Adorno) [#15818](https://github.com/nodejs/node/pull/15818)
* [[`788d7db4e9`](https://github.com/nodejs/node/commit/788d7db4e9)] - **test**: use common.fixtures.path() (Tobias Kieslich) [#16112](https://github.com/nodejs/node/pull/16112)
* [[`b7865ea70d`](https://github.com/nodejs/node/commit/b7865ea70d)] - **test**: replace common.fixturesDir with fixtures (Shakeel Mohamed) [#15857](https://github.com/nodejs/node/pull/15857)
* [[`9b39ca6cbb`](https://github.com/nodejs/node/commit/9b39ca6cbb)] - **test**: use fixtures module in test (Nigel Kibodeaux) [#16117](https://github.com/nodejs/node/pull/16117)
* [[`5e65069289`](https://github.com/nodejs/node/commit/5e65069289)] - **test**: use template literals in test-string-decoder (Edward Andrew Robinson) [#15884](https://github.com/nodejs/node/pull/15884)
* [[`d2b74fe1e3`](https://github.com/nodejs/node/commit/d2b74fe1e3)] - **test**: switch to fixtures module (Christopher Sidebottom) [#15880](https://github.com/nodejs/node/pull/15880)
* [[`1144be09b7`](https://github.com/nodejs/node/commit/1144be09b7)] - **test**: rewrite assert message (Martin Michaelis) [#15879](https://github.com/nodejs/node/pull/15879)
* [[`095df35a5e`](https://github.com/nodejs/node/commit/095df35a5e)] - **test**: change fixturesDir to fixtures.path (Guilherme Akio Sakae) [#15863](https://github.com/nodejs/node/pull/15863)
* [[`4fd5bf5ff7`](https://github.com/nodejs/node/commit/4fd5bf5ff7)] - **test**: replace fixturesDir with common.fixtures (Oliver Luebeck) [#15907](https://github.com/nodejs/node/pull/15907)
* [[`e3e234ea1c`](https://github.com/nodejs/node/commit/e3e234ea1c)] - **test**: update http test client function signatures (Jakub Mrowiec - Alkagar) [#15807](https://github.com/nodejs/node/pull/15807)
* [[`08ca73f52a`](https://github.com/nodejs/node/commit/08ca73f52a)] - **test**: replace common.fixturesDir w/ fixtures.path (Druotic) [#15819](https://github.com/nodejs/node/pull/15819)
* [[`39ae3f1802`](https://github.com/nodejs/node/commit/39ae3f1802)] - **test**: replace fixtureDir with fixtures.path (matthewreed26) [#15943](https://github.com/nodejs/node/pull/15943)
* [[`1365a6f597`](https://github.com/nodejs/node/commit/1365a6f597)] - **test**: use common.fixtures module for file path (Adil L) [#16017](https://github.com/nodejs/node/pull/16017)
* [[`bd8d4401ee`](https://github.com/nodejs/node/commit/bd8d4401ee)] - **test**: use fixtures module (Maurice Hayward) [#16034](https://github.com/nodejs/node/pull/16034)
* [[`bba5263d00`](https://github.com/nodejs/node/commit/bba5263d00)] - **test**: replace fixturesDir with fixtures module (tabulatedreams) [#16036](https://github.com/nodejs/node/pull/16036)
* [[`a8e7fa4e75`](https://github.com/nodejs/node/commit/a8e7fa4e75)] - **test**: replace fixturesDir with fixtures module (Ivan Etchart) [#15893](https://github.com/nodejs/node/pull/15893)
* [[`1fc3851642`](https://github.com/nodejs/node/commit/1fc3851642)] - **test**: change fixturesDir to fixtures.path (Savio Lucena) [#15902](https://github.com/nodejs/node/pull/15902)
* [[`683e48cb55`](https://github.com/nodejs/node/commit/683e48cb55)] - **test**: changed fixtures require (creisle) [#15899](https://github.com/nodejs/node/pull/15899)
* [[`f82f691d5e`](https://github.com/nodejs/node/commit/f82f691d5e)] - **test**: replaced fixturesDir with fixtures module (Alex McKenzie) [#15908](https://github.com/nodejs/node/pull/15908)
* [[`e68ef291e7`](https://github.com/nodejs/node/commit/e68ef291e7)] - **test**: use common.fixtures in tls test (Ben Michel) [#15965](https://github.com/nodejs/node/pull/15965)
* [[`71daa68c3d`](https://github.com/nodejs/node/commit/71daa68c3d)] - **test**: use fixtures module instead of common (Joe Grace) [#15925](https://github.com/nodejs/node/pull/15925)
* [[`e81fc8aca7`](https://github.com/nodejs/node/commit/e81fc8aca7)] - **test**: replaced fixturesDir with fixtures module (Alex McKenzie) [#15927](https://github.com/nodejs/node/pull/15927)
* [[`33ea6deeab`](https://github.com/nodejs/node/commit/33ea6deeab)] - **test**: replace fixturesDir with fixtures module (Greg Matthews) [#15932](https://github.com/nodejs/node/pull/15932)
* [[`be2b70bb56`](https://github.com/nodejs/node/commit/be2b70bb56)] - **test**: replace fixturesDir with fixtures (Mujtaba Al-Tameemi) [#15949](https://github.com/nodejs/node/pull/15949)
* [[`25a5bf02c7`](https://github.com/nodejs/node/commit/25a5bf02c7)] - **test**: remove common.fixturesDir (Luis Del Águila) [#15950](https://github.com/nodejs/node/pull/15950)
* [[`51d87e338e`](https://github.com/nodejs/node/commit/51d87e338e)] - **test**: replace fixturesDir with fixtures module (BinarySo1o) [#15961](https://github.com/nodejs/node/pull/15961)
* [[`05286b6c80`](https://github.com/nodejs/node/commit/05286b6c80)] - **test**: replaced fixturesDir with common.fixtures (jopann) [#15971](https://github.com/nodejs/node/pull/15971)
* [[`683c5fa58f`](https://github.com/nodejs/node/commit/683c5fa58f)] - **test**: use common.fixtures module in test-preload (Laura Cabrera) [#15975](https://github.com/nodejs/node/pull/15975)
* [[`000965d427`](https://github.com/nodejs/node/commit/000965d427)] - **test**: replaced common.fixturesDir with readKey (Sean Cox) [#15933](https://github.com/nodejs/node/pull/15933)
* [[`0f8b315a9e`](https://github.com/nodejs/node/commit/0f8b315a9e)] - **test**: replace fixturesDir in tls-env-bad-extra-ca (Annie Weng) [#15813](https://github.com/nodejs/node/pull/15813)
* [[`48a55d1364`](https://github.com/nodejs/node/commit/48a55d1364)] - **test**: use common.fixtures in checkServerIdentity (Emily Marigold Klassen) [#15951](https://github.com/nodejs/node/pull/15951)
* [[`909e587a93`](https://github.com/nodejs/node/commit/909e587a93)] - **test**: replaced common.fixturesDir with readKey (rhalldearn) [#15952](https://github.com/nodejs/node/pull/15952)
* [[`544cbd7884`](https://github.com/nodejs/node/commit/544cbd7884)] - **test**: replace fixturesDir with fixtures.readKey (Thomas Schorn) [#15948](https://github.com/nodejs/node/pull/15948)
* [[`4005ed619f`](https://github.com/nodejs/node/commit/4005ed619f)] - **test**: replace common.fixturesDir with fixtures. (Sam Skjonsberg) [#15802](https://github.com/nodejs/node/pull/15802)
* [[`8c5b51d9c3`](https://github.com/nodejs/node/commit/8c5b51d9c3)] - **test**: replace fixturesDir with common.fixtures (rachelnicole) [#16051](https://github.com/nodejs/node/pull/16051)
* [[`107acb1c56`](https://github.com/nodejs/node/commit/107acb1c56)] - **test**: update fixturesDir to fixtures.readKey (bitandbang) [#16016](https://github.com/nodejs/node/pull/16016)
* [[`643a2c6b19`](https://github.com/nodejs/node/commit/643a2c6b19)] - **test**: replace fixturesDir with common.fixtures (Pooya Paridel) [#15837](https://github.com/nodejs/node/pull/15837)
* [[`14aee78554`](https://github.com/nodejs/node/commit/14aee78554)] - **test**: update 'fixturesDir' refs in a test file (James M. Greene) [#15824](https://github.com/nodejs/node/pull/15824)
* [[`e1c45efdbb`](https://github.com/nodejs/node/commit/e1c45efdbb)] - **test**: use fixtures.readKey in https-agent test (Greg Byram) [#15913](https://github.com/nodejs/node/pull/15913)
* [[`2c6aa17fa9`](https://github.com/nodejs/node/commit/2c6aa17fa9)] - **test**: add test for fork() + shell (cjihrig) [#15352](https://github.com/nodejs/node/pull/15352)
* [[`148a030345`](https://github.com/nodejs/node/commit/148a030345)] - **test**: remove node-tap lookalike (cjihrig) [#13707](https://github.com/nodejs/node/pull/13707)
* [[`fa5c706bec`](https://github.com/nodejs/node/commit/fa5c706bec)] - **test**: refactor exitedAfterDisconnect test (Rich Trott) [#16729](https://github.com/nodejs/node/pull/16729)
* [[`9416dab7ac`](https://github.com/nodejs/node/commit/9416dab7ac)] - **test**: use fixtures module in test-https-pfx (Ken Takagi) [#15895](https://github.com/nodejs/node/pull/15895)
* [[`7e9779aade`](https://github.com/nodejs/node/commit/7e9779aade)] - **test**: refactor test-readline-keys (Rich Trott) [#11281](https://github.com/nodejs/node/pull/11281)
* [[`8264328087`](https://github.com/nodejs/node/commit/8264328087)] - **test,net**: remove scatological terminology (Rich Trott) [#16599](https://github.com/nodejs/node/pull/16599)
* [[`bb81390db2`](https://github.com/nodejs/node/commit/bb81390db2)] - **timers**: fix eventloop block (zhangzifa) [#15072](https://github.com/nodejs/node/pull/15072)
* [[`f3749d7b2c`](https://github.com/nodejs/node/commit/f3749d7b2c)] - **tools**: remove unneeded parentheses in doc/html.js (Vse Mozhet Byt) [#16845](https://github.com/nodejs/node/pull/16845)
* [[`1c192f50f6`](https://github.com/nodejs/node/commit/1c192f50f6)] - **tools**: replace string concatenation with template literals (Kevin Yu) [#16804](https://github.com/nodejs/node/pull/16804)
* [[`ce007be05b`](https://github.com/nodejs/node/commit/ce007be05b)] - **tools**: replace string concatenation with template literals (Giovanni Lela) [#16806](https://github.com/nodejs/node/pull/16806)
* [[`d165d3fd1c`](https://github.com/nodejs/node/commit/d165d3fd1c)] - **tools**: replace string concetation with templates (Patrick Heneise) [#16801](https://github.com/nodejs/node/pull/16801)
* [[`a8d7f5f52e`](https://github.com/nodejs/node/commit/a8d7f5f52e)] - **tools**: fix cpplint.py when path contains non-ascii (sharkfisher) [#16047](https://github.com/nodejs/node/pull/16047)
* [[`b48471ac10`](https://github.com/nodejs/node/commit/b48471ac10)] - **tools**: rename unused variale in more pythonic way (Nikhil Komawar) [#16171](https://github.com/nodejs/node/pull/16171)
* [[`5b5b5c0f15`](https://github.com/nodejs/node/commit/5b5b5c0f15)] - **tools**: use template literal in error message (Tim Chon) [#15846](https://github.com/nodejs/node/pull/15846)
* [[`ae5930bbe4`](https://github.com/nodejs/node/commit/ae5930bbe4)] - **tty,doc**: add type-check to isatty (Bryan English) [#15567](https://github.com/nodejs/node/pull/15567)

<a id="6.12.0"></a>
## 2017-11-07, Version 6.12.0 'Boron' (LTS), @MylesBorins

This LTS release comes with 127 commits. This includes 45 which are test related,
33 which are doc related, 13 which are updates to dependencies and 7 commits which are related to build / tools.

This release includes a security update to openssl that has been deemed low severity for the Node.js project.

### Notable Changes

* **assert**:
  * assert.fail() can now take one or two arguments (Rich Trott) [#12293](https://github.com/nodejs/node/pull/12293)
* **crypto**:
  * add sign/verify support for RSASSA-PSS (Tobias Nießen) [#11705](https://github.com/nodejs/node/pull/11705)
* **deps**:
  * upgrade openssl sources to 1.0.2m (Shigeki Ohtsu) [#16691](https://github.com/nodejs/node/pull/16691)
  * upgrade libuv to 1.15.0 (cjihrig) [#15745](https://github.com/nodejs/node/pull/15745)
  * upgrade libuv to 1.14.1 (cjihrig) [#14866](https://github.com/nodejs/node/pull/14866)
  * upgrade libuv to 1.13.1 (cjihrig) [#14117](https://github.com/nodejs/node/pull/14117)
  * upgrade libuv to 1.12.0 (cjihrig) [#13306](https://github.com/nodejs/node/pull/13306)
* **fs**:
  * Add support for fs.write/fs.writeSync(fd, buffer, cb) and fs.write/fs.writeSync(fd, buffer, offset, cb) as documented (Andreas Lind) [#7856](https://github.com/nodejs/node/pull/7856)
* **inspector**:
  * enable --inspect-brk (Refael Ackermann) [#12615](https://github.com/nodejs/node/pull/12615)
* **process**:
  * add --redirect-warnings command line argument (James M Snell) [#10116](https://github.com/nodejs/node/pull/10116)
* **src**:
  * allow CLI args in env with NODE_OPTIONS (Sam Roberts) [#12028](https://github.com/nodejs/node/pull/12028)
  * --abort-on-uncaught-exception in NODE_OPTIONS (Sam Roberts) [#13932](https://github.com/nodejs/node/pull/13932)
  * allow --tls-cipher-list in NODE_OPTIONS (Sam Roberts) [#13172](https://github.com/nodejs/node/pull/13172)
  * use SafeGetenv() for NODE_REDIRECT_WARNINGS (Sam Roberts) [#12677](https://github.com/nodejs/node/pull/12677)
* **test**:
  * remove common.fail() (Rich Trott) [#12293](https://github.com/nodejs/node/pull/12293)

### Commits

* [[`4917d8cfef`](https://github.com/nodejs/node/commit/4917d8cfef)] - **(SEMVER-MINOR)** **assert**: improve assert.fail() API (Rich Trott) [#12293](https://github.com/nodejs/node/pull/12293)
* [[`5522bdf825`](https://github.com/nodejs/node/commit/5522bdf825)] - **benchmark**: use smaller n value in some http tests (Peter Marshall) [#14002](https://github.com/nodejs/node/pull/14002)
* [[`252d08ab77`](https://github.com/nodejs/node/commit/252d08ab77)] - **build**: use generic names for linting tasks (Nikolai Vavilov) [#15272](https://github.com/nodejs/node/pull/15272)
* [[`78dc92860f`](https://github.com/nodejs/node/commit/78dc92860f)] - **build**: fix shared installing target (Yorkie Liu) [#15148](https://github.com/nodejs/node/pull/15148)
* [[`6c9a9ff25c`](https://github.com/nodejs/node/commit/6c9a9ff25c)] - **build**: don't fail `make test` on source tarballs (Gibson Fahnestock) [#15441](https://github.com/nodejs/node/pull/15441)
* [[`af63b38142`](https://github.com/nodejs/node/commit/af63b38142)] - **crypto**: use X509V3_EXT_d2i (David Benjamin) [#15348](https://github.com/nodejs/node/pull/15348)
* [[`6b0812860d`](https://github.com/nodejs/node/commit/6b0812860d)] - **crypto**: use SSL_SESSION_get_id (David Benjamin) [#15348](https://github.com/nodejs/node/pull/15348)
* [[`46695703b6`](https://github.com/nodejs/node/commit/46695703b6)] - **crypto**: only try to set FIPS mode if different (Gibson Fahnestock) [#12210](https://github.com/nodejs/node/pull/12210)
* [[`10a70353b2`](https://github.com/nodejs/node/commit/10a70353b2)] - **crypto**: fix Node_SignFinal (David Benjamin) [#15024](https://github.com/nodejs/node/pull/15024)
* [[`a7d4cade46`](https://github.com/nodejs/node/commit/a7d4cade46)] - **(SEMVER-MINOR)** **crypto**: add sign/verify support for RSASSA-PSS (Tobias Nießen) [#11705](https://github.com/nodejs/node/pull/11705)
* [[`b98fa82de6`](https://github.com/nodejs/node/commit/b98fa82de6)] - **deps**: cherry-pick e7f4e9e from upstream libuv (Bartosz Sosnowski) [#16724](https://github.com/nodejs/node/pull/16724)
* [[`748d3e5d04`](https://github.com/nodejs/node/commit/748d3e5d04)] - **deps**: update openssl asm and asm_obsolete files (Shigeki Ohtsu) [#16691](https://github.com/nodejs/node/pull/16691)
* [[`5da4ceba86`](https://github.com/nodejs/node/commit/5da4ceba86)] - **deps**: add -no_rand_screen to openssl s_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`ef57db81ac`](https://github.com/nodejs/node/commit/ef57db81ac)] - **deps**: fix asm build error of openssl in x86_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`7b93a2fd63`](https://github.com/nodejs/node/commit/7b93a2fd63)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`265d948b30`](https://github.com/nodejs/node/commit/265d948b30)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu) [#16691](https://github.com/nodejs/node/pull/16691)
* [[`8386ce7645`](https://github.com/nodejs/node/commit/8386ce7645)] - **deps**: upgrade openssl sources to 1.0.2m (Shigeki Ohtsu) [#16691](https://github.com/nodejs/node/pull/16691)
* [[`02e4303c13`](https://github.com/nodejs/node/commit/02e4303c13)] - **(SEMVER-MINOR)** **deps**: upgrade libuv to 1.15.0 (cjihrig) [#15745](https://github.com/nodejs/node/pull/15745)
* [[`f22132e8f7`](https://github.com/nodejs/node/commit/f22132e8f7)] - **deps**: v8: fix potential segfault in profiler (Ali Ijaz Sheikh) [#15498](https://github.com/nodejs/node/pull/15498)
* [[`08d683053f`](https://github.com/nodejs/node/commit/08d683053f)] - **deps**: upgrade libuv to 1.14.1 (cjihrig) [#14866](https://github.com/nodejs/node/pull/14866)
* [[`a38755d0a4`](https://github.com/nodejs/node/commit/a38755d0a4)] - **deps**: upgrade libuv to 1.13.1 (cjihrig) [#14117](https://github.com/nodejs/node/pull/14117)
* [[`3265840504`](https://github.com/nodejs/node/commit/3265840504)] - **(SEMVER-MINOR)** **deps**: upgrade libuv to 1.12.0 (cjihrig) [#13306](https://github.com/nodejs/node/pull/13306)
* [[`2d3e735783`](https://github.com/nodejs/node/commit/2d3e735783)] - **deps**: V8: backport e560815 from upstream (Ali Ijaz Sheikh) [#16133](https://github.com/nodejs/node/pull/16133)
* [[`a776639987`](https://github.com/nodejs/node/commit/a776639987)] - **doc**: add 9.x to version picker and mark 8.x as LTS (Chris Young) [#16672](https://github.com/nodejs/node/pull/16672)
* [[`0f3901a905`](https://github.com/nodejs/node/commit/0f3901a905)] - **doc**: standardize function param/object prop style (Gibson Fahnestock) [#13769](https://github.com/nodejs/node/pull/13769)
* [[`b0fadbe54f`](https://github.com/nodejs/node/commit/b0fadbe54f)] - **doc**: fix typo in zlib.md (Luigi Pinca) [#16480](https://github.com/nodejs/node/pull/16480)
* [[`37b93724ff`](https://github.com/nodejs/node/commit/37b93724ff)] - **doc**: fix types and description for dns.resolveTxt (Tobias Nießen) [#15472](https://github.com/nodejs/node/pull/15472)
* [[`6e06d0e1b5`](https://github.com/nodejs/node/commit/6e06d0e1b5)] - **doc**: add callback function signatures in fs.md (Matej Krajčovič) [#13424](https://github.com/nodejs/node/pull/13424)
* [[`f1eda4a391`](https://github.com/nodejs/node/commit/f1eda4a391)] - **doc**: fix external links with 404 status (Vse Mozhet Byt) [#15463](https://github.com/nodejs/node/pull/15463)
* [[`c64603fbb5`](https://github.com/nodejs/node/commit/c64603fbb5)] - **doc**: add kfarnung to collaborators (Kyle Farnung) [#16108](https://github.com/nodejs/node/pull/16108)
* [[`da160cfda0`](https://github.com/nodejs/node/commit/da160cfda0)] - **doc**: mention collaboration summit in onboarding.md (Joyee Cheung) [#16079](https://github.com/nodejs/node/pull/16079)
* [[`699cfa1ee0`](https://github.com/nodejs/node/commit/699cfa1ee0)] - **doc**: fix macosx-firewall suggestion BUILDING (suraiyah) [#15829](https://github.com/nodejs/node/pull/15829)
* [[`547217346c`](https://github.com/nodejs/node/commit/547217346c)] - **doc**: add clearer setup description (Emily Platzer) [#15962](https://github.com/nodejs/node/pull/15962)
* [[`291b9c55cb`](https://github.com/nodejs/node/commit/291b9c55cb)] - **doc**: update style guide for markdown extension (Rich Trott) [#15786](https://github.com/nodejs/node/pull/15786)
* [[`eaec35db9f`](https://github.com/nodejs/node/commit/eaec35db9f)] - **doc**: fix incorrect vm.createContext usage (tshemsedinov) [#16059](https://github.com/nodejs/node/pull/16059)
* [[`ddee71afff`](https://github.com/nodejs/node/commit/ddee71afff)] - **doc**: fix typo in tls.md (kohta ito) [#15738](https://github.com/nodejs/node/pull/15738)
* [[`62ea82b73e`](https://github.com/nodejs/node/commit/62ea82b73e)] - **doc**: add 'git clean -xfd' to backport guide (Lance Ball) [#15715](https://github.com/nodejs/node/pull/15715)
* [[`6d41c850b2`](https://github.com/nodejs/node/commit/6d41c850b2)] - **doc**: alphabetize TSC Emeriti in README.md (Rich Trott) [#15722](https://github.com/nodejs/node/pull/15722)
* [[`6b1ce97196`](https://github.com/nodejs/node/commit/6b1ce97196)] - **doc**: fix dead link in doc/releases.md (Luigi Pinca) [#15733](https://github.com/nodejs/node/pull/15733)
* [[`e865fcbb07`](https://github.com/nodejs/node/commit/e865fcbb07)] - **doc**: edit COLLABORATORS_GUIDE.md for readability (Rich Trott) [#15629](https://github.com/nodejs/node/pull/15629)
* [[`af1863218c`](https://github.com/nodejs/node/commit/af1863218c)] - **doc**: fix links in some intra-repository docs (Vse Mozhet Byt) [#15675](https://github.com/nodejs/node/pull/15675)
* [[`926b46c138`](https://github.com/nodejs/node/commit/926b46c138)] - **doc**: update libuv license (Timothy Gu) [#15649](https://github.com/nodejs/node/pull/15649)
* [[`f29f20f3f9`](https://github.com/nodejs/node/commit/f29f20f3f9)] - **doc**: add bmeurer to collaborators (Benedikt Meurer) [#15677](https://github.com/nodejs/node/pull/15677)
* [[`eefa0a2dcc`](https://github.com/nodejs/node/commit/eefa0a2dcc)] - **doc**: retire bnoordhuis from the TSC (Ben Noordhuis) [#15626](https://github.com/nodejs/node/pull/15626)
* [[`b622a516e2`](https://github.com/nodejs/node/commit/b622a516e2)] - **doc**: ctc -\> tsc in collab guide (Bryan English) [#15590](https://github.com/nodejs/node/pull/15590)
* [[`377f7b9e9e`](https://github.com/nodejs/node/commit/377f7b9e9e)] - **doc**: fix 'aborted' event documentation (Luigi Pinca) [#15471](https://github.com/nodejs/node/pull/15471)
* [[`ccdc194350`](https://github.com/nodejs/node/commit/ccdc194350)] - **doc**: fix some internal links (Vse Mozhet Byt) [#15293](https://github.com/nodejs/node/pull/15293)
* [[`713f239900`](https://github.com/nodejs/node/commit/713f239900)] - **doc**: adding sebdeckers to collaborators (Sebastiaan Deckers) [#15354](https://github.com/nodejs/node/pull/15354)
* [[`21dec5573a`](https://github.com/nodejs/node/commit/21dec5573a)] - **doc**: update AUTHORS list (Michaël Zasso) [#15181](https://github.com/nodejs/node/pull/15181)
* [[`988eec3a93`](https://github.com/nodejs/node/commit/988eec3a93)] - **doc**: update README with SHASUMS256.txt.sig info (Jon Moss) [#15107](https://github.com/nodejs/node/pull/15107)
* [[`0b2d5486c6`](https://github.com/nodejs/node/commit/0b2d5486c6)] - **doc**: fix "added in" for Buffer.allocUnsafeSlow() (Tuan Anh Tran) [#15330](https://github.com/nodejs/node/pull/15330)
* [[`ae111c266c`](https://github.com/nodejs/node/commit/ae111c266c)] - **doc**: use consistent terminology in process doc (Rich Trott) [#15321](https://github.com/nodejs/node/pull/15321)
* [[`ab014d4056`](https://github.com/nodejs/node/commit/ab014d4056)] - **doc**: make mkdtemp example work on Windows (Bartosz Sosnowski) [#15408](https://github.com/nodejs/node/pull/15408)
* [[`a0b38054d9`](https://github.com/nodejs/node/commit/a0b38054d9)] - **doc**: make socket IPC examples more robust (cjihrig) [#13196](https://github.com/nodejs/node/pull/13196)
* [[`9ec87dcb0f`](https://github.com/nodejs/node/commit/9ec87dcb0f)] - **doc**: fix the description of 'close' event (Myles Borins) [#15800](https://github.com/nodejs/node/pull/15800)
* [[`323edfa42d`](https://github.com/nodejs/node/commit/323edfa42d)] - **docs**: clarify usage cli options -e,-p on windows (Łukasz Szewczak) [#15568](https://github.com/nodejs/node/pull/15568)
* [[`1de04908f3`](https://github.com/nodejs/node/commit/1de04908f3)] - **(SEMVER-MINOR)** **fs**: Fix default params for fs.write(Sync) (Andreas Lind) [#7856](https://github.com/nodejs/node/pull/7856)
* [[`3ac769091c`](https://github.com/nodejs/node/commit/3ac769091c)] - **(SEMVER-MINOR)** **gitignore**: add libuv book and GitHub template (cjihrig) [#13306](https://github.com/nodejs/node/pull/13306)
* [[`e31ab7c1ed`](https://github.com/nodejs/node/commit/e31ab7c1ed)] - **(SEMVER-MINOR)** **inspector**: enable --inspect-brk (Refael Ackermann) [#12615](https://github.com/nodejs/node/pull/12615)
* [[`880fba9c56`](https://github.com/nodejs/node/commit/880fba9c56)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`d1bf8cee63`](https://github.com/nodejs/node/commit/d1bf8cee63)] - **path**: fix normalize paths ending with two dots (Michaël Zasso) [nodejs-private/node-private#94](https://github.com/nodejs-private/node-private/pull/94)
* [[`f87a62699b`](https://github.com/nodejs/node/commit/f87a62699b)] - **path**: fix normalize on directories with two dots (Michaël Zasso) [#14107](https://github.com/nodejs/node/pull/14107)
* [[`16802c0b64`](https://github.com/nodejs/node/commit/16802c0b64)] - **(SEMVER-MINOR)** **process**: add --redirect-warnings command line argument (James M Snell) [#10116](https://github.com/nodejs/node/pull/10116)
* [[`02b46847c6`](https://github.com/nodejs/node/commit/02b46847c6)] - **repl**: force editorMode in .load (Lance Ball) [#14861](https://github.com/nodejs/node/pull/14861)
* [[`cdba9890a1`](https://github.com/nodejs/node/commit/cdba9890a1)] - **src**: replace manual memory mgmt with std::string (Ben Noordhuis) [#15782](https://github.com/nodejs/node/pull/15782)
* [[`931addba0b`](https://github.com/nodejs/node/commit/931addba0b)] - **src**: fix ^ in stack trace with vm's columnOffset (Timothy Gu) [#15771](https://github.com/nodejs/node/pull/15771)
* [[`81236d95f8`](https://github.com/nodejs/node/commit/81236d95f8)] - **src**: correct typo in trace_event header (Daniel Bevenius) [#15583](https://github.com/nodejs/node/pull/15583)
* [[`0b5798b3c3`](https://github.com/nodejs/node/commit/0b5798b3c3)] - **src**: remove outdated todo from node_crypto.cc (Bartek Szczepański) [#15104](https://github.com/nodejs/node/pull/15104)
* [[`cccf5a6edf`](https://github.com/nodejs/node/commit/cccf5a6edf)] - **(SEMVER-MINOR)** **src**: --abort-on-uncaught-exception in NODE_OPTIONS (Sam Roberts) [#13932](https://github.com/nodejs/node/pull/13932)
* [[`16f8f9b03f`](https://github.com/nodejs/node/commit/16f8f9b03f)] - **(SEMVER-MINOR)** **src**: allow --tls-cipher-list in NODE_OPTIONS (Sam Roberts) [#13172](https://github.com/nodejs/node/pull/13172)
* [[`12b66e60d7`](https://github.com/nodejs/node/commit/12b66e60d7)] - **src**: whitelist new options for NODE_OPTIONS (Sam Roberts) [#13002](https://github.com/nodejs/node/pull/13002)
* [[`dd6ea89217`](https://github.com/nodejs/node/commit/dd6ea89217)] - **src**: allow CLI args in env with NODE_OPTIONS (Sam Roberts) [#12028](https://github.com/nodejs/node/pull/12028)
* [[`8f4214836e`](https://github.com/nodejs/node/commit/8f4214836e)] - **src**: use a std::vector for preload_modules (Sam Roberts) [#12241](https://github.com/nodejs/node/pull/12241)
* [[`68f698c05a`](https://github.com/nodejs/node/commit/68f698c05a)] - **(SEMVER-MINOR)** **src**: use SafeGetenv() for NODE_REDIRECT_WARNINGS (Sam Roberts) [#12677](https://github.com/nodejs/node/pull/12677)
* [[`b166837551`](https://github.com/nodejs/node/commit/b166837551)] - **src,etw**: fix event 9 on 64 bit Windows (João Reis) [#15563](https://github.com/nodejs/node/pull/15563)
* [[`18987794bd`](https://github.com/nodejs/node/commit/18987794bd)] - **test**: move test-cluster-debug-port to sequential (Oleksandr Kushchak) [#16292](https://github.com/nodejs/node/pull/16292)
* [[`1fdbaed2f2`](https://github.com/nodejs/node/commit/1fdbaed2f2)] - **test**: begin normalizing fixtures use (James M Snell) [#14332](https://github.com/nodejs/node/pull/14332)
* [[`3ad6a9dfc4`](https://github.com/nodejs/node/commit/3ad6a9dfc4)] - **test**: remove assert message (Joe Henry)
* [[`58509ec471`](https://github.com/nodejs/node/commit/58509ec471)] - **test**: clarify assert messages in crypto tests (cpandrews8) [#16019](https://github.com/nodejs/node/pull/16019)
* [[`ab7f43aa41`](https://github.com/nodejs/node/commit/ab7f43aa41)] - **test**: include expected result in error messages (Chowdhurian) [#16039](https://github.com/nodejs/node/pull/16039)
* [[`342ac9f0c6`](https://github.com/nodejs/node/commit/342ac9f0c6)] - **test**: cleanup test-buffer-sharedarraybuffer (Rafal Leszczynski) [#15896](https://github.com/nodejs/node/pull/15896)
* [[`6eb88a4216`](https://github.com/nodejs/node/commit/6eb88a4216)] - **test**: updated error message (Emily Platzer) [#15906](https://github.com/nodejs/node/pull/15906)
* [[`40a98d6e7b`](https://github.com/nodejs/node/commit/40a98d6e7b)] - **test**: assert.strictEqual using template literals (jmcgui05) [#15944](https://github.com/nodejs/node/pull/15944)
* [[`cd57d2d92a`](https://github.com/nodejs/node/commit/cd57d2d92a)] - **test**: replace error msg w/ template literal (Sushil Tailor) [#15910](https://github.com/nodejs/node/pull/15910)
* [[`bce1f3810e`](https://github.com/nodejs/node/commit/bce1f3810e)] - **test**: add NODE_UNIQUE_ID value to err message (Daniele Lisi) [#15914](https://github.com/nodejs/node/pull/15914)
* [[`4243903278`](https://github.com/nodejs/node/commit/4243903278)] - **test**: replace string concatenation with template (Rob Paton) [#15915](https://github.com/nodejs/node/pull/15915)
* [[`f831744464`](https://github.com/nodejs/node/commit/f831744464)] - **test**: improve asset msg in test (Gene Wu) [#15918](https://github.com/nodejs/node/pull/15918)
* [[`d0bd56d509`](https://github.com/nodejs/node/commit/d0bd56d509)] - **test**: remove message from asserts (Justin Lee) [#15920](https://github.com/nodejs/node/pull/15920)
* [[`23e66edcbe`](https://github.com/nodejs/node/commit/23e66edcbe)] - **test**: improve an error message (Pavel Pomerantsev) [#15921](https://github.com/nodejs/node/pull/15921)
* [[`ad69a65b5f`](https://github.com/nodejs/node/commit/ad69a65b5f)] - **test**: replaced literals in errors with templates (Paul Milham) [#15911](https://github.com/nodejs/node/pull/15911)
* [[`16907461fe`](https://github.com/nodejs/node/commit/16907461fe)] - **test**: display better error message for assertion (Russell Dempsey) [#15883](https://github.com/nodejs/node/pull/15883)
* [[`4a664cea7d`](https://github.com/nodejs/node/commit/4a664cea7d)] - **test**: changed buffer-zero output (heeeunkimmm) [#15926](https://github.com/nodejs/node/pull/15926)
* [[`f8bc5ab262`](https://github.com/nodejs/node/commit/f8bc5ab262)] - **test**: remove literal error messages (Faisal Yaqoob) [#15928](https://github.com/nodejs/node/pull/15928)
* [[`1c1312e239`](https://github.com/nodejs/node/commit/1c1312e239)] - **test**: changes to use template literal (joanne-jjb) [#15937](https://github.com/nodejs/node/pull/15937)
* [[`fcab2c5ed2`](https://github.com/nodejs/node/commit/fcab2c5ed2)] - **test**: removed string from assert message arg (dpaulino) [#15954](https://github.com/nodejs/node/pull/15954)
* [[`f954536fc3`](https://github.com/nodejs/node/commit/f954536fc3)] - **test**: replace literal with template string (Brant Barger) [#15957](https://github.com/nodejs/node/pull/15957)
* [[`a93d3eb79d`](https://github.com/nodejs/node/commit/a93d3eb79d)] - **test**: improve assert messages (Eric Pemberton) [#15972](https://github.com/nodejs/node/pull/15972)
* [[`f9cb428cef`](https://github.com/nodejs/node/commit/f9cb428cef)] - **test**: replacing assert message with template (Barry Tam) [#15974](https://github.com/nodejs/node/pull/15974)
* [[`36747eeb62`](https://github.com/nodejs/node/commit/36747eeb62)] - **test**: alter assert.strictEqual to default message (Luke Greenleaf) [#15978](https://github.com/nodejs/node/pull/15978)
* [[`968cc44bd0`](https://github.com/nodejs/node/commit/968cc44bd0)] - **test**: remove messages in assert.strictEqual (Saeed H) [#16014](https://github.com/nodejs/node/pull/16014)
* [[`83a251336c`](https://github.com/nodejs/node/commit/83a251336c)] - **test**: skip test if host is too slow (Rich Trott) [#15688](https://github.com/nodejs/node/pull/15688)
* [[`e3ea2a455b`](https://github.com/nodejs/node/commit/e3ea2a455b)] - **test**: check that this != new.target in addon (Ben Noordhuis) [#15681](https://github.com/nodejs/node/pull/15681)
* [[`1483ebdc2c`](https://github.com/nodejs/node/commit/1483ebdc2c)] - **test**: improve readline test coverage for tty (Claudio Rodriguez) [#12064](https://github.com/nodejs/node/pull/12064)
* [[`96a64af7a6`](https://github.com/nodejs/node/commit/96a64af7a6)] - **test**: use reserved invalid hostname for tests (icarter09) [#14781](https://github.com/nodejs/node/pull/14781)
* [[`514ef7452c`](https://github.com/nodejs/node/commit/514ef7452c)] - **test**: make test-http-agent-maxsockets robust (Rich Trott) [#15192](https://github.com/nodejs/node/pull/15192)
* [[`c4b06b279d`](https://github.com/nodejs/node/commit/c4b06b279d)] - **test**: remove random timer in test-tls-fast-writing (Rich Trott) [#15138](https://github.com/nodejs/node/pull/15138)
* [[`9cebe8296a`](https://github.com/nodejs/node/commit/9cebe8296a)] - **test**: check inspect array with empty string key (Rahul Mishra) [#15258](https://github.com/nodejs/node/pull/15258)
* [[`6fe61d6d9c`](https://github.com/nodejs/node/commit/6fe61d6d9c)] - **test**: remove invalid test (Rich Trott) [#15320](https://github.com/nodejs/node/pull/15320)
* [[`48943e92d7`](https://github.com/nodejs/node/commit/48943e92d7)] - **test**: allow adding known-globals through ENV (Refael Ackermann) [#15187](https://github.com/nodejs/node/pull/15187)
* [[`5c99fc3fb3`](https://github.com/nodejs/node/commit/5c99fc3fb3)] - **test**: backward compatible api for tty (Gergely Nemeth) [#15235](https://github.com/nodejs/node/pull/15235)
* [[`06ee10e523`](https://github.com/nodejs/node/commit/06ee10e523)] - **test**: split path tests into multiple files (Michaël Zasso) [#15093](https://github.com/nodejs/node/pull/15093)
* [[`4030c7e077`](https://github.com/nodejs/node/commit/4030c7e077)] - **test**: update windows module load error message (cjihrig) [#14950](https://github.com/nodejs/node/pull/14950)
* [[`d25dc797f4`](https://github.com/nodejs/node/commit/d25dc797f4)] - **test**: skipIfInspectorDisabled cluster-inspect-brk (Daniel Bevenius) [#12757](https://github.com/nodejs/node/pull/12757)
* [[`7b9710d0df`](https://github.com/nodejs/node/commit/7b9710d0df)] - **test**: add inspect-brk option to cluster module (dave-k) [#12503](https://github.com/nodejs/node/pull/12503)
* [[`c9d440e8bd`](https://github.com/nodejs/node/commit/c9d440e8bd)] - **test**: change == to === in crypto test (Fabio Campinho) [#12405](https://github.com/nodejs/node/pull/12405)
* [[`dd946c3c2a`](https://github.com/nodejs/node/commit/dd946c3c2a)] - **test**: add hasCrypto check to test-cli-node-options (Daniel Bevenius) [#12692](https://github.com/nodejs/node/pull/12692)
* [[`ba830f0352`](https://github.com/nodejs/node/commit/ba830f0352)] - **test**: chdir before running test-cli-node-options (Daniel Bevenius) [#12660](https://github.com/nodejs/node/pull/12660)
* [[`d8f56371a9`](https://github.com/nodejs/node/commit/d8f56371a9)] - **test**: add cwd ENOENT known issue test (cjihrig) [#12343](https://github.com/nodejs/node/pull/12343)
* [[`1091b86290`](https://github.com/nodejs/node/commit/1091b86290)] - **(SEMVER-MINOR)** **test**: remove common.fail() (Rich Trott) [#12293](https://github.com/nodejs/node/pull/12293)
* [[`e0c4f0b85a`](https://github.com/nodejs/node/commit/e0c4f0b85a)] - **test,process**: run 'abort' suite on Windows (Refael Ackermann) [#15056](https://github.com/nodejs/node/pull/15056)
* [[`f49feab35f`](https://github.com/nodejs/node/commit/f49feab35f)] - **timers**: clarify lib/timer.js comment (Daniel Bevenius) [#11018](https://github.com/nodejs/node/pull/11018)
* [[`2409db6c99`](https://github.com/nodejs/node/commit/2409db6c99)] - **tools**: replace concatenation with string templates (Ethan Arrowood) [#15858](https://github.com/nodejs/node/pull/15858)
* [[`15ae5a44cf`](https://github.com/nodejs/node/commit/15ae5a44cf)] - **tools**: replace concat with template literals (Minya Liang) [#16046](https://github.com/nodejs/node/pull/16046)
* [[`705202d410`](https://github.com/nodejs/node/commit/705202d410)] - **tools**: use template literals (Sarah Meyer) [#15956](https://github.com/nodejs/node/pull/15956)
* [[`44cc39d278`](https://github.com/nodejs/node/commit/44cc39d278)] - **(SEMVER-MINOR)** **tools**: remove assert.fail() lint rule (Rich Trott) [#12293](https://github.com/nodejs/node/pull/12293)
* [[`88b9572d76`](https://github.com/nodejs/node/commit/88b9572d76)] - **tty**: require readline at top of file (Bryan English) [#15647](https://github.com/nodejs/node/pull/15647)
* [[`27af0bb446`](https://github.com/nodejs/node/commit/27af0bb446)] - **url**: change variable name to be more descriptive (Yang-Kichang) [#15551](https://github.com/nodejs/node/pull/15551)

<a id="6.11.5"></a>
## 2017-10-24, Version 6.11.5 'Boron' (LTS), @MylesBorins

This is a security release. All Node.js users should consult the security release summary at https://nodejs.org/en/blog/vulnerability/oct-2017-dos/ for details on patched vulnerabilities.

### Notable Changes

* **zlib**:
  * CVE-2017-14919 - In zlib v1.2.9, a change was made that causes an error to be raised when a raw deflate stream is initialized with windowBits set to 8. On some versions this crashes Node and you cannot recover from it, while on some versions it throws an exception. Node.js will now gracefully set windowBits to 9 replicating the legacy behavior to avoid a DOS vector. [nodejs-private/node-private#95](https://github.com/nodejs-private/node-private/pull/95)

### Commits

* [[`dd764d9cb6`](https://github.com/nodejs/node/commit/b66e44c4d3)] - **zlib**: gracefully set windowBits from 8 to 9 (Myles Borins) [nodejs-private/node-private#95](https://github.com/nodejs-private/node-private/pull/95)

<a id="6.11.4"></a>
## 2017-10-03, Version 6.11.4 'Boron' (LTS), @MylesBorins

This LTS release comes with 91 commits. This includes 29 which are test related,
28 which are doc related, 11 which are build / tool related and 3 commits which are updates to dependencies.

### Notable Changes

* **net**:
  * support passing undefined to listen() to match behavior in v4.x and v8.x (Sam Roberts) [#14234](https://github.com/nodejs/node/pull/14234)

### Commits

* [[`73416b46e4`](https://github.com/nodejs/node/commit/73416b46e4)] - **assert**: refactor the code (Ruben Bridgewater) [#13862](https://github.com/nodejs/node/pull/13862)
* [[`a8b917ee2f`](https://github.com/nodejs/node/commit/a8b917ee2f)] - **benchmark**: fix dgram/bind-params.js benchmark (Rich Trott) [#14948](https://github.com/nodejs/node/pull/14948)
* [[`855d7ae326`](https://github.com/nodejs/node/commit/855d7ae326)] - **benchmark**: convert var to es6 const (Sebastian Murphy) [#12886](https://github.com/nodejs/node/pull/12886)
* [[`6a7e46ed9c`](https://github.com/nodejs/node/commit/6a7e46ed9c)] - **build**: add NetBSD support to opensslconf.h (Roy Marples) [#14313](https://github.com/nodejs/node/pull/14313)
* [[`66dd898be8`](https://github.com/nodejs/node/commit/66dd898be8)] - **build**: better support for python3 systems (Ben Noordhuis) [#14737](https://github.com/nodejs/node/pull/14737)
* [[`14cc1abb56`](https://github.com/nodejs/node/commit/14cc1abb56)] - **build**: split up cpplint to avoid long cmd lines (Kyle Farnung) [#14116](https://github.com/nodejs/node/pull/14116)
* [[`c9ae894277`](https://github.com/nodejs/node/commit/c9ae894277)] - **build**: add lint option to vcbuild.bat help (Morgan Brenner) [#11992](https://github.com/nodejs/node/pull/11992)
* [[`66cdcd9d5b`](https://github.com/nodejs/node/commit/66cdcd9d5b)] - **build**: add cpp linting to windows build (liusi) [#11856](https://github.com/nodejs/node/pull/11856)
* [[`25be2a3be3`](https://github.com/nodejs/node/commit/25be2a3be3)] - **crypto**: naming anonymous functions. (solebox) [#8993](https://github.com/nodejs/node/pull/8993)
* [[`4e1a50a079`](https://github.com/nodejs/node/commit/4e1a50a079)] - **deps**: backport 0353a1e from V8 upstream (jBarz) [#15287](https://github.com/nodejs/node/pull/15287)
* [[`921876dcd1`](https://github.com/nodejs/node/commit/921876dcd1)] - **deps**: backport 071b655 from V8 upstream (Michaël Zasso) [#15215](https://github.com/nodejs/node/pull/15215)
* [[`a13ac69ff9`](https://github.com/nodejs/node/commit/a13ac69ff9)] - **doc**: prevent displaying empty version picker (Chris Young) [#15420](https://github.com/nodejs/node/pull/15420)
* [[`ecea33b277`](https://github.com/nodejs/node/commit/ecea33b277)] - **doc**: add links to alternative versions of doc (Chris Young) [#10958](https://github.com/nodejs/node/pull/10958)
* [[`feb6863a5c`](https://github.com/nodejs/node/commit/feb6863a5c)] - **doc**: document bytes to chars after setEncoding (Jessica Quynh Tran) [#13442](https://github.com/nodejs/node/pull/13442)
* [[`33fdbb5417`](https://github.com/nodejs/node/commit/33fdbb5417)] - **doc**: describe what security issues are (Sam Roberts) [#14485](https://github.com/nodejs/node/pull/14485)
* [[`a260190717`](https://github.com/nodejs/node/commit/a260190717)] - **doc**: instructions for generating coverage reports (Simon Brewster) [#15190](https://github.com/nodejs/node/pull/15190)
* [[`1b0e660c25`](https://github.com/nodejs/node/commit/1b0e660c25)] - **doc**: /s/SHASUM256/SHASUMS256 (Jon Moss) [#15101](https://github.com/nodejs/node/pull/15101)
* [[`5696223534`](https://github.com/nodejs/node/commit/5696223534)] - **doc**: clarify http.get data consumption requirement (AJ Jordan) [#15049](https://github.com/nodejs/node/pull/15049)
* [[`4c26913dab`](https://github.com/nodejs/node/commit/4c26913dab)] - **doc**: crypto.randomBytes does not block when async (Sam Roberts) [#14993](https://github.com/nodejs/node/pull/14993)
* [[`605a02b613`](https://github.com/nodejs/node/commit/605a02b613)] - **doc**: environmental-\>environment & NodeJS-\>Node.js (Rod Vagg) [#14974](https://github.com/nodejs/node/pull/14974)
* [[`b10bc31030`](https://github.com/nodejs/node/commit/b10bc31030)] - **doc**: fix typo in Buffer.from(string, \[encoding\]) (Michał Wadas) [#15013](https://github.com/nodejs/node/pull/15013)
* [[`29de000938`](https://github.com/nodejs/node/commit/29de000938)] - **doc**: add note for Windows build path (Kyle Lamse) [#14354](https://github.com/nodejs/node/pull/14354)
* [[`7546eef262`](https://github.com/nodejs/node/commit/7546eef262)] - **doc**: rephrase text of child_process.execSync() (hafiz) [#14953](https://github.com/nodejs/node/pull/14953)
* [[`70e9a6ece3`](https://github.com/nodejs/node/commit/70e9a6ece3)] - **doc**: link to correct "OS Constants" heading in docs (James Kyle) [#14969](https://github.com/nodejs/node/pull/14969)
* [[`55dc14ec61`](https://github.com/nodejs/node/commit/55dc14ec61)] - **doc**: remove misterdjules from the CTC members list (Julien Gilli) [#1498](https://github.com/nodejs/node/pull/1498)
* [[`c76a54f318`](https://github.com/nodejs/node/commit/c76a54f318)] - **doc**: add missing word (Jon Moss) [#14924](https://github.com/nodejs/node/pull/14924)
* [[`27b6737d85`](https://github.com/nodejs/node/commit/27b6737d85)] - **doc**: explain what to do if git push is rejected (Rich Trott) [#14848](https://github.com/nodejs/node/pull/14848)
* [[`d75e9b7d44`](https://github.com/nodejs/node/commit/d75e9b7d44)] - **doc**: add BridgeAR to collaborators (Ruben Bridgewater) [#14862](https://github.com/nodejs/node/pull/14862)
* [[`a63cd82003`](https://github.com/nodejs/node/commit/a63cd82003)] - **doc**: fix word wrapping for api stability boxes (Saad Quadri) [#14809](https://github.com/nodejs/node/pull/14809)
* [[`f8fbac7842`](https://github.com/nodejs/node/commit/f8fbac7842)] - **doc**: improve fs.read() doc text (Rich Trott) [#14631](https://github.com/nodejs/node/pull/14631)
* [[`5a7a49f505`](https://github.com/nodejs/node/commit/5a7a49f505)] - **doc**: clarify the position argument for fs.read (dcharbonnier) [#14631](https://github.com/nodejs/node/pull/14631)
* [[`b5904a2054`](https://github.com/nodejs/node/commit/b5904a2054)] - **doc**: remove undef NDEBUG from addons.md (Daniel Bevenius) [#14048](https://github.com/nodejs/node/pull/14048)
* [[`c0e47e4f22`](https://github.com/nodejs/node/commit/c0e47e4f22)] - **doc**: fix order of AtExit callbacks in addons.md (Daniel Bevenius) [#14048](https://github.com/nodejs/node/pull/14048)
* [[`dcdc9053b4`](https://github.com/nodejs/node/commit/dcdc9053b4)] - **doc**: fix typo in stream.md (Marc Hernández Cabot) [#14364](https://github.com/nodejs/node/pull/14364)
* [[`594e3c2115`](https://github.com/nodejs/node/commit/594e3c2115)] - **doc**: add readline.emitKeypressEvents note (Samuel Reed) [#9447](https://github.com/nodejs/node/pull/9447)
* [[`90fcccd7a3`](https://github.com/nodejs/node/commit/90fcccd7a3)] - **doc**: add documentation on ICU (Timothy Gu) [#13916](https://github.com/nodejs/node/pull/13916)
* [[`38ae5c4e34`](https://github.com/nodejs/node/commit/38ae5c4e34)] - **doc, lib, test**: do not re-require needlessly (Vse Mozhet Byt) [#14244](https://github.com/nodejs/node/pull/14244)
* [[`abf6355936`](https://github.com/nodejs/node/commit/abf6355936)] - **doc,assert**: document stackStartFunction in fail (Ruben Bridgewater) [#13862](https://github.com/nodejs/node/pull/13862)
* [[`f0328f631a`](https://github.com/nodejs/node/commit/f0328f631a)] - **doc,stream**: remove wrong remark on readable.read (Jan Schär) [#15014](https://github.com/nodejs/node/pull/15014)
* [[`0c670e0339`](https://github.com/nodejs/node/commit/0c670e0339)] - **http**: eliminate capture of ClientRequest in Agent (Evan Torrie) [#10134](https://github.com/nodejs/node/pull/10134)
* [[`67074113dc`](https://github.com/nodejs/node/commit/67074113dc)] - **http**: reset stream to unconsumed in `unconsume()` (Anna Henningsen) [#14410](https://github.com/nodejs/node/pull/14410)
* [[`e65c9ec7f4`](https://github.com/nodejs/node/commit/e65c9ec7f4)] - **http**: assert parser.consume argument's type (Gireesh Punathil) [#12288](https://github.com/nodejs/node/pull/12288)
* [[`4e717820a0`](https://github.com/nodejs/node/commit/4e717820a0)] - **lib**: clean up usage of threw (Jackson Tian) [#10534](https://github.com/nodejs/node/pull/10534)
* [[`e014178362`](https://github.com/nodejs/node/commit/e014178362)] - **meta**: merge TSC and CTC back into a single body (James M Snell) [#14973](https://github.com/nodejs/node/pull/14973)
* [[`4ee066eaba`](https://github.com/nodejs/node/commit/4ee066eaba)] - **meta**: considerations for new core modules (James M Snell) [#15022](https://github.com/nodejs/node/pull/15022)
* [[`948a7d70e7`](https://github.com/nodejs/node/commit/948a7d70e7)] - **meta**: improve definition of a collaborator (James M Snell) [#14981](https://github.com/nodejs/node/pull/14981)
* [[`caeee38b1d`](https://github.com/nodejs/node/commit/caeee38b1d)] - **net**: support passing undefined to listen() (Sam Roberts) [#14234](https://github.com/nodejs/node/pull/14234)
* [[`792acc17bf`](https://github.com/nodejs/node/commit/792acc17bf)] - **net**: fix abort on bad address input (Ruben Bridgewater) [#13726](https://github.com/nodejs/node/pull/13726)
* [[`8604772960`](https://github.com/nodejs/node/commit/8604772960)] - **readline**: remove max limit of crlfDelay (Azard) [#13497](https://github.com/nodejs/node/pull/13497)
* [[`362a7c0d8b`](https://github.com/nodejs/node/commit/362a7c0d8b)] - **repl**: do not consider `...` as a REPL command (Shivanth MP) [#14467](https://github.com/nodejs/node/pull/14467)
* [[`968121bbfe`](https://github.com/nodejs/node/commit/968121bbfe)] - **src**: remove unnecessary helper function (Brian White) [#14959](https://github.com/nodejs/node/pull/14959)
* [[`b2112f8d36`](https://github.com/nodejs/node/commit/b2112f8d36)] - **src**: detect nul bytes in InternalModuleReadFile() (Ben Noordhuis) [#14854](https://github.com/nodejs/node/pull/14854)
* [[`d20b7bfb6e`](https://github.com/nodejs/node/commit/d20b7bfb6e)] - **src**: use local isolate instead of args.GetIsolate (Daniel Bevenius) [#14768](https://github.com/nodejs/node/pull/14768)
* [[`66187fa044`](https://github.com/nodejs/node/commit/66187fa044)] - **stream**: fix Writable instanceof for subclasses (Anna Henningsen) [#14945](https://github.com/nodejs/node/pull/14945)
* [[`2c8fe9748c`](https://github.com/nodejs/node/commit/2c8fe9748c)] - **test**: remove envPlus, use Object.assign everywhere (Gibson Fahnestock) [#14845](https://github.com/nodejs/node/pull/14845)
* [[`8e00315506`](https://github.com/nodejs/node/commit/8e00315506)] - **test**: check zlib version for createDeflateRaw (Daniel Bevenius) [#13697](https://github.com/nodejs/node/pull/13697)
* [[`2babae4cd4`](https://github.com/nodejs/node/commit/2babae4cd4)] - **test**: refactor test-fs-readfile-unlink (Rich Trott) [#15173](https://github.com/nodejs/node/pull/15173)
* [[`8b045747e0`](https://github.com/nodejs/node/commit/8b045747e0)] - **test**: pipe some error output if npm fails (Jeremiah Senkpiel) [#12490](https://github.com/nodejs/node/pull/12490)
* [[`6540e99547`](https://github.com/nodejs/node/commit/6540e99547)] - **test**: simplify test-tls-client-default-ciphers (Jon Moss) [#14928](https://github.com/nodejs/node/pull/14928)
* [[`ad1d745498`](https://github.com/nodejs/node/commit/ad1d745498)] - **test**: extend async addon test (Anna Henningsen) [#14922](https://github.com/nodejs/node/pull/14922)
* [[`1e231ba8c7`](https://github.com/nodejs/node/commit/1e231ba8c7)] - **test**: add known issue for vm module (Franziska Hinkelmann) [#14661](https://github.com/nodejs/node/pull/14661)
* [[`644d9905a0`](https://github.com/nodejs/node/commit/644d9905a0)] - **test**: do not modify fixtures in test-fs-chmod (Rich Trott) [#14926](https://github.com/nodejs/node/pull/14926)
* [[`168f73c5f4`](https://github.com/nodejs/node/commit/168f73c5f4)] - **test**: improve assertion fail messages (Refael Ackermann) [#14949](https://github.com/nodejs/node/pull/14949)
* [[`915b56b963`](https://github.com/nodejs/node/commit/915b56b963)] - **test**: remove unused arguments from function (Ankit Parashar) [#14931](https://github.com/nodejs/node/pull/14931)
* [[`724508295d`](https://github.com/nodejs/node/commit/724508295d)] - **test**: make timers-blocking-callback more reliable (Rich Trott) [#14831](https://github.com/nodejs/node/pull/14831)
* [[`4fb4fbea1c`](https://github.com/nodejs/node/commit/4fb4fbea1c)] - **test**: add missing console.error to exec-maxBuffer (Beth Griggs) [#14796](https://github.com/nodejs/node/pull/14796)
* [[`a284ee6129`](https://github.com/nodejs/node/commit/a284ee6129)] - **test**: invoke callback with common.mustCall() (Griffith Tchenpan) [#8597](https://github.com/nodejs/node/pull/8597)
* [[`32260b91f2`](https://github.com/nodejs/node/commit/32260b91f2)] - **test**: check crypto before requiring tls module (Daniel Bevenius) [#14708](https://github.com/nodejs/node/pull/14708)
* [[`68cf7f0b30`](https://github.com/nodejs/node/commit/68cf7f0b30)] - **test**: improve multiple zlib tests (James M Snell) [#14455](https://github.com/nodejs/node/pull/14455)
* [[`f35f06d04c`](https://github.com/nodejs/node/commit/f35f06d04c)] - **test**: improve multiple vm tests (James M Snell) [#14458](https://github.com/nodejs/node/pull/14458)
* [[`1aac05b087`](https://github.com/nodejs/node/commit/1aac05b087)] - **test**: cover all HTTP methods that parser supports (Oky Antoro) [#14773](https://github.com/nodejs/node/pull/14773)
* [[`9f330250b5`](https://github.com/nodejs/node/commit/9f330250b5)] - **test**: remove redundant `using` in cctest (XadillaX) [#14739](https://github.com/nodejs/node/pull/14739)
* [[`91649b913c`](https://github.com/nodejs/node/commit/91649b913c)] - **test**: make test-tls-connect checks more strict (Rich Trott) [#14695](https://github.com/nodejs/node/pull/14695)
* [[`9ed2c4cb0e`](https://github.com/nodejs/node/commit/9ed2c4cb0e)] - **test**: add block scoping to test-readline-interface (Rich Trott) [#14615](https://github.com/nodejs/node/pull/14615)
* [[`4fb755c432`](https://github.com/nodejs/node/commit/4fb755c432)] - **test**: set module loading error for aix (Prakash Palaniappan) [#14511](https://github.com/nodejs/node/pull/14511)
* [[`9d8464161e`](https://github.com/nodejs/node/commit/9d8464161e)] - **test**: fix conversion of microseconds in test (Nick Stanish) [#14706](https://github.com/nodejs/node/pull/14706)
* [[`28b77d1f8b`](https://github.com/nodejs/node/commit/28b77d1f8b)] - **test**: improve check in test-os (Rich Trott) [#14655](https://github.com/nodejs/node/pull/14655)
* [[`fc49cf41ea`](https://github.com/nodejs/node/commit/fc49cf41ea)] - **test**: improve multiple timers tests (James M Snell) [#14616](https://github.com/nodejs/node/pull/14616)
* [[`c88f99f1f3`](https://github.com/nodejs/node/commit/c88f99f1f3)] - **test**: improvements to various http tests (James M Snell) [#14315](https://github.com/nodejs/node/pull/14315)
* [[`860c6198c0`](https://github.com/nodejs/node/commit/860c6198c0)] - **test**: use ciphers supported by shared OpenSSL (Jérémy Lal) [#14566](https://github.com/nodejs/node/pull/14566)
* [[`8b9a05c04b`](https://github.com/nodejs/node/commit/8b9a05c04b)] - **test**: read proper inspector message size (Bartosz Sosnowski) [#14596](https://github.com/nodejs/node/pull/14596)
* [[`86497f1acc`](https://github.com/nodejs/node/commit/86497f1acc)] - **test**: mark inspector-port-zero-cluster as flaky (Refael Ackermann)
* [[`8dfc2838c8`](https://github.com/nodejs/node/commit/8dfc2838c8)] - **test**: fix test-readline-interface (Azard) [#14677](https://github.com/nodejs/node/pull/14677)
* [[`3a6392b283`](https://github.com/nodejs/node/commit/3a6392b283)] - **tls**: fix empty issuer/subject/infoAccess parsing (Ben Noordhuis) [#14473](https://github.com/nodejs/node/pull/14473)
* [[`37dd2adbac`](https://github.com/nodejs/node/commit/37dd2adbac)] - **tools**: fix linter error in html.js (Michaël Zasso) [#15063](https://github.com/nodejs/node/pull/15063)
* [[`8b3ac4b2a2`](https://github.com/nodejs/node/commit/8b3ac4b2a2)] - **tools**: add custom private key option (Ruslan Bekenev) [#14401](https://github.com/nodejs/node/pull/14401)
* [[`cac4beb764`](https://github.com/nodejs/node/commit/cac4beb764)] - **tools**: fix update-eslint.sh (Myles Borins) [#14850](https://github.com/nodejs/node/pull/14850)
* [[`debea1c531`](https://github.com/nodejs/node/commit/debea1c531)] - **tools**: delete an unused argument (phisixersai) [#14251](https://github.com/nodejs/node/pull/14251)
* [[`ca61f3bd80`](https://github.com/nodejs/node/commit/ca61f3bd80)] - **tools**: fix tools/addon-verify.js (Daniel Bevenius) [#14048](https://github.com/nodejs/node/pull/14048)
* [[`f7b6d198b9`](https://github.com/nodejs/node/commit/f7b6d198b9)] - **tools**: eslint - use `error` and `off` (Refael Ackermann) [#14061](https://github.com/nodejs/node/pull/14061)
* [[`f8b85e16cd`](https://github.com/nodejs/node/commit/f8b85e16cd)] - **tools**: replace assert-throw-arguments custom lint (Rich Trott) [#14547](https://github.com/nodejs/node/pull/14547)

<a id="6.11.3"></a>
## 2017-09-05, Version 6.11.3 'Boron' (LTS), @MylesBorins

This LTS release comes with 152 commits. This includes 75 which are test related,
25 which are doc related, 21 which are build / tool related and 3 commits which are updates to dependencies.

### Notable Changes

* **build**:
  * Codesigning is fixed on macOS (Evan Lucas) [#14179](https://github.com/nodejs/node/pull/14179)
* **deps**:
  * Snapshots are turned back on!!! (Yang Guo) [#14385](https://github.com/nodejs/node/pull/14385)
* **path**:
  * win32 volume-relative paths are working again! (Timothy Gu) [#14440](https://github.com/nodejs/node/pull/14440)
* **tools**:
  * v6.x can now build with ICU 59 (Steven R. Loomis) [#12078](https://github.com/nodejs/node/pull/12078)

### Commits

* [[`95be08e3d2`](https://github.com/nodejs/node/commit/95be08e3d2)] - **benchmark**: fix typo in inspect-proxy (Vse Mozhet Byt) [#14237](https://github.com/nodejs/node/pull/14237)
* [[`dbb65203f1`](https://github.com/nodejs/node/commit/dbb65203f1)] - **buffer**: remove a wrongly added attribute specifier (Jiajie Hu) [#14466](https://github.com/nodejs/node/pull/14466)
* [[`977fdce406`](https://github.com/nodejs/node/commit/977fdce406)] - **build**: codesign tarball binary on macOS (Evan Lucas) [#14179](https://github.com/nodejs/node/pull/14179)
* [[`a04d4ea8d7`](https://github.com/nodejs/node/commit/a04d4ea8d7)] - **build**: clean up config_fips.gypi (Daniel Bevenius) [#13837](https://github.com/nodejs/node/pull/13837)
* [[`c7025de6e2`](https://github.com/nodejs/node/commit/c7025de6e2)] - **build**: support dtrace on ARM (Bradley T. Hughes) [#12193](https://github.com/nodejs/node/pull/12193)
* [[`efc0f64c17`](https://github.com/nodejs/node/commit/efc0f64c17)] - **build**: reduce one level of spawning in node_gyp (Refael Ackermann) [#12653](https://github.com/nodejs/node/pull/12653)
* [[`1a7e872302`](https://github.com/nodejs/node/commit/1a7e872302)] - **build,tools**: do not force codesign prefix (Evan Lucas) [#14179](https://github.com/nodejs/node/pull/14179)
* [[`325813ea97`](https://github.com/nodejs/node/commit/325813ea97)] - **build,win**: fix python detection script (Jason Ginchereau) [#14546](https://github.com/nodejs/node/pull/14546)
* [[`c2090a0634`](https://github.com/nodejs/node/commit/c2090a0634)] - **build,windows**: restore DISTTYPEDIR (Refael Ackermann) [#13969](https://github.com/nodejs/node/pull/13969)
* [[`2a1a93dcbf`](https://github.com/nodejs/node/commit/2a1a93dcbf)] - **build,windows**: implement PEP514 python detection (Refael Ackermann) [#13900](https://github.com/nodejs/node/pull/13900)
* [[`2bc7c3a8dd`](https://github.com/nodejs/node/commit/2bc7c3a8dd)] - **child_process**: fix handleless NODE_HANDLE handling (Santiago Gimeno) [#13235](https://github.com/nodejs/node/pull/13235)
* [[`5900ebe9e4`](https://github.com/nodejs/node/commit/5900ebe9e4)] - **crypto**: remove root_cert_store from node_crypto.h (Daniel Bevenius) [#13194](https://github.com/nodejs/node/pull/13194)
* [[`987332abdf`](https://github.com/nodejs/node/commit/987332abdf)] - **deps**: cherry-pick 18ea996 from c-ares upstream (Anna Henningsen) [#13883](https://github.com/nodejs/node/pull/13883)
* [[`7fed989deb`](https://github.com/nodejs/node/commit/7fed989deb)] - **deps**: cherry-pick f5fad6d from upstream v8 (daniel.bevenius) [#12826](https://github.com/nodejs/node/pull/12826)
* [[`67ce52c740`](https://github.com/nodejs/node/commit/67ce52c740)] - **deps**: backport rehash strings after deserialization (Yang Guo) [#14385](https://github.com/nodejs/node/pull/14385)
* [[`6518932466`](https://github.com/nodejs/node/commit/6518932466)] - **dns**: fix `resolve` failed starts without network (XadillaX) [#13076](https://github.com/nodejs/node/pull/13076)
* [[`438a6427e5`](https://github.com/nodejs/node/commit/438a6427e5)] - **doc**: add gabrielschulhof to collaborators (Gabriel Schulhof) [#14692](https://github.com/nodejs/node/pull/14692)
* [[`c013c545a4`](https://github.com/nodejs/node/commit/c013c545a4)] - **doc**: update experimental status to reflect use (James M Snell) [#12723](https://github.com/nodejs/node/pull/12723)
* [[`ad2431ce28`](https://github.com/nodejs/node/commit/ad2431ce28)] - **doc**: describe labelling process for backports (Anna Henningsen) [#12431](https://github.com/nodejs/node/pull/12431)
* [[`013155d0b4`](https://github.com/nodejs/node/commit/013155d0b4)] - **doc**: add XadillaX to collaborators (XadillaX) [#14388](https://github.com/nodejs/node/pull/14388)
* [[`226ef71a1b`](https://github.com/nodejs/node/commit/226ef71a1b)] - **doc**: replace dead link in v8 module (Devin Boyer) [#14372](https://github.com/nodejs/node/pull/14372)
* [[`8b69504e17`](https://github.com/nodejs/node/commit/8b69504e17)] - **doc**: move LTS README link to increase prominence (Gibson Fahnestock) [#14259](https://github.com/nodejs/node/pull/14259)
* [[`b0286acd52`](https://github.com/nodejs/node/commit/b0286acd52)] - **doc**: update umask for clarity (James Sumners) [#14170](https://github.com/nodejs/node/pull/14170)
* [[`49d3dee0c2`](https://github.com/nodejs/node/commit/49d3dee0c2)] - **doc**: correct stream Duplex allowHalfOpen doc (Rich Trott) [#14127](https://github.com/nodejs/node/pull/14127)
* [[`9599faae18`](https://github.com/nodejs/node/commit/9599faae18)] - **doc**: note 'resize' event conditions on Windows (Dean Coakley) [#13576](https://github.com/nodejs/node/pull/13576)
* [[`8dbf827de3`](https://github.com/nodejs/node/commit/8dbf827de3)] - **doc**: fix mistake in http.md (Moogen Tian) [#14126](https://github.com/nodejs/node/pull/14126)
* [[`a3cd733dea`](https://github.com/nodejs/node/commit/a3cd733dea)] - **doc**: fix indentation issues in sample code (Rich Trott) [#13950](https://github.com/nodejs/node/pull/13950)
* [[`3b3d47c483`](https://github.com/nodejs/node/commit/3b3d47c483)] - **doc**: add CTC members to Collaborators list (Rich Trott) [#13284](https://github.com/nodejs/node/pull/13284)
* [[`f1d91ce3d2`](https://github.com/nodejs/node/commit/f1d91ce3d2)] - **doc**: fix example in child_process.md (Ruslan Iusupov) [#13716](https://github.com/nodejs/node/pull/13716)
* [[`db4fabae27`](https://github.com/nodejs/node/commit/db4fabae27)] - **doc**: note that fs.futimes only works on AIX \>7.1 (Gibson Fahnestock) [#13659](https://github.com/nodejs/node/pull/13659)
* [[`7648cca3de`](https://github.com/nodejs/node/commit/7648cca3de)] - **doc**: add @nodejs/documentation to CC table (Vse Mozhet Byt) [#13952](https://github.com/nodejs/node/pull/13952)
* [[`b03430b4ec`](https://github.com/nodejs/node/commit/b03430b4ec)] - **doc**: add gireeshpunathil to collaborators (Gireesh Punathil) [#13967](https://github.com/nodejs/node/pull/13967)
* [[`c34a7472d2`](https://github.com/nodejs/node/commit/c34a7472d2)] - **doc**: fix mistake in path.relative (Tobias Nießen) [#13912](https://github.com/nodejs/node/pull/13912)
* [[`7142c92dd6`](https://github.com/nodejs/node/commit/7142c92dd6)] - **doc**: fixed formatting issue in cli docs (Chris Young) [#13808](https://github.com/nodejs/node/pull/13808)
* [[`87906d25d4`](https://github.com/nodejs/node/commit/87906d25d4)] - **doc**: add missing zlib link to stream API docs (Rob Wu) [#13838](https://github.com/nodejs/node/pull/13838)
* [[`5ba65f2870`](https://github.com/nodejs/node/commit/5ba65f2870)] - **doc**: add entry for subprocess.killed property (Rich Trott) [#14578](https://github.com/nodejs/node/pull/14578)
* [[`73c720dd9e`](https://github.com/nodejs/node/commit/73c720dd9e)] - **doc**: change `child` to `subprocess` (Rich Trott) [#14578](https://github.com/nodejs/node/pull/14578)
* [[`7f6f1c2ddc`](https://github.com/nodejs/node/commit/7f6f1c2ddc)] - **doc, util, console**: clarify ambiguous docs (Natanael Log) [#14027](https://github.com/nodejs/node/pull/14027)
* [[`d6ab8e2f43`](https://github.com/nodejs/node/commit/d6ab8e2f43)] - **doc,stream**: _transform happens one at a time (Matteo Collina) [#14321](https://github.com/nodejs/node/pull/14321)
* [[`c307f03b2b`](https://github.com/nodejs/node/commit/c307f03b2b)] - **doc,test**: fs - reserved characters under win32 (XadillaX) [#13875](https://github.com/nodejs/node/pull/13875)
* [[`1d5ba9c8e9`](https://github.com/nodejs/node/commit/1d5ba9c8e9)] - **docs**: add note about fs.rmdir() (Oleksandr Kushchak) [#14323](https://github.com/nodejs/node/pull/14323)
* [[`f8b60e40a4`](https://github.com/nodejs/node/commit/f8b60e40a4)] - **gyp**: implement LD/LDXX for ninja and FIPS (Sam Roberts)
* [[`963ea0e99b`](https://github.com/nodejs/node/commit/963ea0e99b)] - **lib**: update indentation of ternaries (Rich Trott) [#14247](https://github.com/nodejs/node/pull/14247)
* [[`0cacd6c89e`](https://github.com/nodejs/node/commit/0cacd6c89e)] - **lib**: normalize indentation in parentheses (Rich Trott) [#14125](https://github.com/nodejs/node/pull/14125)
* [[`4dabeeecdd`](https://github.com/nodejs/node/commit/4dabeeecdd)] - **lib**: remove excess indentation (Rich Trott) [#14090](https://github.com/nodejs/node/pull/14090)
* [[`f20ed49b5e`](https://github.com/nodejs/node/commit/f20ed49b5e)] - **lib**: use consistent indentation for ternaries (Rich Trott) [#14078](https://github.com/nodejs/node/pull/14078)
* [[`81edf592ae`](https://github.com/nodejs/node/commit/81edf592ae)] - **lib**: fix typos (Ruben Bridgewater) [#14044](https://github.com/nodejs/node/pull/14044)
* [[`39f62403c7`](https://github.com/nodejs/node/commit/39f62403c7)] - **linkedlist**: correct grammar in comments (alexbostock) [#14546](https://github.com/nodejs/node/pull/14546)
* [[`e82a9144ed`](https://github.com/nodejs/node/commit/e82a9144ed)] - **path**: remove unnecessary string copies (Tobias Nießen) [#14438](https://github.com/nodejs/node/pull/14438)
* [[`eefd32264e`](https://github.com/nodejs/node/commit/eefd32264e)] - **path**: fix win32 volume-relative paths (Timothy Gu) [#14440](https://github.com/nodejs/node/pull/14440)
* [[`fe6735cc19`](https://github.com/nodejs/node/commit/fe6735cc19)] - **src**: use existing strings over creating new ones (Anna Henningsen) [#14587](https://github.com/nodejs/node/pull/14587)
* [[`4d3b76d2be`](https://github.com/nodejs/node/commit/4d3b76d2be)] - **src**: remove GTEST_DONT_DEFINE_ASSERT_EQ in util.h (Daniel Bevenius) [#12638](https://github.com/nodejs/node/pull/12638)
* [[`51364b746f`](https://github.com/nodejs/node/commit/51364b746f)] - **src**: move crypto_bio/clienthello to crypto ns (Daniel Bevenius) [#13957](https://github.com/nodejs/node/pull/13957)
* [[`35f911152a`](https://github.com/nodejs/node/commit/35f911152a)] - **src**: add missing new line to printed message (Timothy Gu) [#13940](https://github.com/nodejs/node/pull/13940)
* [[`135e1e3b0b`](https://github.com/nodejs/node/commit/135e1e3b0b)] - **src**: merge `fn_name` in NODE_SET_PROTOTYPE_METHOD (XadillaX) [#13547](https://github.com/nodejs/node/pull/13547)
* [[`403c45fcc9`](https://github.com/nodejs/node/commit/403c45fcc9)] - **src**: only call FatalException if not verbose (Daniel Bevenius) [#12826](https://github.com/nodejs/node/pull/12826)
* [[`547e74bb22`](https://github.com/nodejs/node/commit/547e74bb22)] - **src**: use option parser for expose_internals (Sam Roberts) [#12245](https://github.com/nodejs/node/pull/12245)
* [[`f9e427945b`](https://github.com/nodejs/node/commit/f9e427945b)] - **src**: supply missing comments for CLI options (Sam Roberts) [#12245](https://github.com/nodejs/node/pull/12245)
* [[`9ca67e0147`](https://github.com/nodejs/node/commit/9ca67e0147)] - **src**: make root_cert_vector function scoped (Daniel Bevenius) [#12788](https://github.com/nodejs/node/pull/12788)
* [[`2ce80d97e9`](https://github.com/nodejs/node/commit/2ce80d97e9)] - **test**: refactor test-domain-abort-on-uncaught (Rich Trott) [#14541](https://github.com/nodejs/node/pull/14541)
* [[`4b9de44022`](https://github.com/nodejs/node/commit/4b9de44022)] - **test**: refactor test-vm-new-script-new-context (Rich Trott) [#14536](https://github.com/nodejs/node/pull/14536)
* [[`e5375a97e0`](https://github.com/nodejs/node/commit/e5375a97e0)] - **test**: add check on an addon that does not register (Ezequiel Garcia) [#13954](https://github.com/nodejs/node/pull/13954)
* [[`1a88c3e5f6`](https://github.com/nodejs/node/commit/1a88c3e5f6)] - **test**: improve error logging for inspector test (Rich Trott) [#14508](https://github.com/nodejs/node/pull/14508)
* [[`95a95cced3`](https://github.com/nodejs/node/commit/95a95cced3)] - **test**: fix flaky test-force-repl (Rich Trott) [#14439](https://github.com/nodejs/node/pull/14439)
* [[`6fd3dd20c0`](https://github.com/nodejs/node/commit/6fd3dd20c0)] - **test**: replace concatenation with template literal (rockcoder23) [#14270](https://github.com/nodejs/node/pull/14270)
* [[`3ba55d8c47`](https://github.com/nodejs/node/commit/3ba55d8c47)] - **test**: replace concatenation with template literal (Ching Hsu) [#14284](https://github.com/nodejs/node/pull/14284)
* [[`7f7a0709be`](https://github.com/nodejs/node/commit/7f7a0709be)] - **test**: replace concatenation with template literals (Zongmin Lei) [#14298](https://github.com/nodejs/node/pull/14298)
* [[`11ed4c2823`](https://github.com/nodejs/node/commit/11ed4c2823)] - **test**: replace string concatenation with template (ziyun) [#14286](https://github.com/nodejs/node/pull/14286)
* [[`bbd1c791f5`](https://github.com/nodejs/node/commit/bbd1c791f5)] - **test**: use path.join for long path concatenation (zzz) [#14280](https://github.com/nodejs/node/pull/14280)
* [[`c4f21b37a1`](https://github.com/nodejs/node/commit/c4f21b37a1)] - **test**: replace concatenation with template literals (SkyAo) [#14296](https://github.com/nodejs/node/pull/14296)
* [[`d7afa17939`](https://github.com/nodejs/node/commit/d7afa17939)] - **test**: fix error handling test-http-full-response (Rich Trott) [#14252](https://github.com/nodejs/node/pull/14252)
* [[`7a8eddf015`](https://github.com/nodejs/node/commit/7a8eddf015)] - **test**: use regex error check in test-crypto-random (Zhang Weijie) [#14273](https://github.com/nodejs/node/pull/14273)
* [[`3047cf1b48`](https://github.com/nodejs/node/commit/3047cf1b48)] - **test**: check error with regex in test-signal-safety (shaman) [#14285](https://github.com/nodejs/node/pull/14285)
* [[`bbe328830f`](https://github.com/nodejs/node/commit/bbe328830f)] - **test**: use regex error checks in test-util-format (Superwoods) [#14299](https://github.com/nodejs/node/pull/14299)
* [[`a696e2ecae`](https://github.com/nodejs/node/commit/a696e2ecae)] - **test**: use template literal for string concat (tobewhatwewant) [#14288](https://github.com/nodejs/node/pull/14288)
* [[`77506e48b0`](https://github.com/nodejs/node/commit/77506e48b0)] - **test**: simplify string concatenation (jiangplus) [#14278](https://github.com/nodejs/node/pull/14278)
* [[`b9b343c412`](https://github.com/nodejs/node/commit/b9b343c412)] - **test**: use regexp to confir error message (Bang Wu) [#14268](https://github.com/nodejs/node/pull/14268)
* [[`94ff5918b6`](https://github.com/nodejs/node/commit/94ff5918b6)] - **test**: use regluar expression in vm test (akira.xue) [#14266](https://github.com/nodejs/node/pull/14266)
* [[`8b945e7649`](https://github.com/nodejs/node/commit/8b945e7649)] - **test**: use regular expression to match error msg (Flandre) [#14265](https://github.com/nodejs/node/pull/14265)
* [[`a168361eb9`](https://github.com/nodejs/node/commit/a168361eb9)] - **test**: check complete error message (Fraser Xu) [#14264](https://github.com/nodejs/node/pull/14264)
* [[`1e403902ba`](https://github.com/nodejs/node/commit/1e403902ba)] - **test**: fix flaky test-net-can-reset-timeout (Rich Trott) [#14257](https://github.com/nodejs/node/pull/14257)
* [[`688e5ed6fd`](https://github.com/nodejs/node/commit/688e5ed6fd)] - **test**: remove common.noop (Rich Trott) [#12822](https://github.com/nodejs/node/pull/12822)
* [[`40a61e1399`](https://github.com/nodejs/node/commit/40a61e1399)] - **test**: add get/set effective uid/gid tests (Evan Lucas) [#14091](https://github.com/nodejs/node/pull/14091)
* [[`1633f8b243`](https://github.com/nodejs/node/commit/1633f8b243)] - **test**: simplify test skipping (Vse Mozhet Byt) [#14021](https://github.com/nodejs/node/pull/14021)
* [[`b7b38bdbaf`](https://github.com/nodejs/node/commit/b7b38bdbaf)] - **test**: adjust indentation for stricter linting (Rich Trott) [#14431](https://github.com/nodejs/node/pull/14431)
* [[`46e4a026b6`](https://github.com/nodejs/node/commit/46e4a026b6)] - **test**: skip test-fs-readdir-ucs2 if no support (Rich Trott) [#14029](https://github.com/nodejs/node/pull/14029)
* [[`49632287d1`](https://github.com/nodejs/node/commit/49632287d1)] - **test**: fix flaky http(s)-set-server-timeout tests (Rich Trott) [#14380](https://github.com/nodejs/node/pull/14380)
* [[`ae7eeff489`](https://github.com/nodejs/node/commit/ae7eeff489)] - **test**: fix flaky test-https-set-timeout-server (Rich Trott) [#14134](https://github.com/nodejs/node/pull/14134)
* [[`c5c65c8ce9`](https://github.com/nodejs/node/commit/c5c65c8ce9)] - **test**: fix require nits in some test-tls-* tests (Vse Mozhet Byt) [#14008](https://github.com/nodejs/node/pull/14008)
* [[`346f199e28`](https://github.com/nodejs/node/commit/346f199e28)] - **test**: refactor test-http(s)-set-timeout-server (Alexey Orlenko) [#13935](https://github.com/nodejs/node/pull/13935)
* [[`ac851c482c`](https://github.com/nodejs/node/commit/ac851c482c)] - **test**: refactor test-http-invalidheaderfield (Rich Trott) [#13996](https://github.com/nodejs/node/pull/13996)
* [[`49e786628f`](https://github.com/nodejs/node/commit/49e786628f)] - **test**: replace indexOf with includes and startsWith (Nataly Shrits) [#13852](https://github.com/nodejs/node/pull/13852)
* [[`2eb926b487`](https://github.com/nodejs/node/commit/2eb926b487)] - **test**: remove undef NDEBUG from at-exit addons test (Daniel Bevenius) [#13998](https://github.com/nodejs/node/pull/13998)
* [[`0bcbcca21c`](https://github.com/nodejs/node/commit/0bcbcca21c)] - **test**: refactor test-fs-watchfile (Rich Trott) [#13721](https://github.com/nodejs/node/pull/13721)
* [[`bd8574ccee`](https://github.com/nodejs/node/commit/bd8574ccee)] - **test**: refactor test-child-process-send-type-error (Rich Trott) [#13904](https://github.com/nodejs/node/pull/13904)
* [[`74945dd18a`](https://github.com/nodejs/node/commit/74945dd18a)] - **test**: refactor test-cluster-basic (Rich Trott) [#13905](https://github.com/nodejs/node/pull/13905)
* [[`dc3d29519d`](https://github.com/nodejs/node/commit/dc3d29519d)] - **test**: remove unneeded HandleScope usage (Ezequiel Garcia) [#13859](https://github.com/nodejs/node/pull/13859)
* [[`beca25ab9e`](https://github.com/nodejs/node/commit/beca25ab9e)] - **test**: skip fips tests using OpenSSL config file (Daniel Bevenius) [#13786](https://github.com/nodejs/node/pull/13786)
* [[`d3c85a4806`](https://github.com/nodejs/node/commit/d3c85a4806)] - **test**: refactor test-tls-invoked-queued (Rich Trott) [#13893](https://github.com/nodejs/node/pull/13893)
* [[`676a94e44d`](https://github.com/nodejs/node/commit/676a94e44d)] - **test**: refactor test-tls-env-extra-ca (Rich Trott) [#13886](https://github.com/nodejs/node/pull/13886)
* [[`fd6bbc098e`](https://github.com/nodejs/node/commit/fd6bbc098e)] - **test**: make http(s)-set-timeout-server more similar (Julien Klepatch) [#13822](https://github.com/nodejs/node/pull/13822)
* [[`8ba784383c`](https://github.com/nodejs/node/commit/8ba784383c)] - **test**: remove `require('buffer')` from 4 test files (XadillaX) [#13844](https://github.com/nodejs/node/pull/13844)
* [[`cd962e6de3`](https://github.com/nodejs/node/commit/cd962e6de3)] - **test**: remove unnecessary require('buffer').Buffer (lena) [#13851](https://github.com/nodejs/node/pull/13851)
* [[`fff0b83f1b`](https://github.com/nodejs/node/commit/fff0b83f1b)] - **test**: remove `require('buffer')` from 4 test files (Zongmin Lei) [#13846](https://github.com/nodejs/node/pull/13846)
* [[`6d02bf40d0`](https://github.com/nodejs/node/commit/6d02bf40d0)] - **test**: remove require('buffer') from 4 buffer tests (OriLev) [#13855](https://github.com/nodejs/node/pull/13855)
* [[`0abc82db50`](https://github.com/nodejs/node/commit/0abc82db50)] - **test**: remove require('buffer') on 6 fs test files (sallen450) [#13845](https://github.com/nodejs/node/pull/13845)
* [[`1fb19ac0c5`](https://github.com/nodejs/node/commit/1fb19ac0c5)] - **test**: remove unnecessary Buffer import (Steven Winston) [#13860](https://github.com/nodejs/node/pull/13860)
* [[`5a9d7b3bf5`](https://github.com/nodejs/node/commit/5a9d7b3bf5)] - **test**: use string instead of RegExp in split() (Vse Mozhet Byt) [#13710](https://github.com/nodejs/node/pull/13710)
* [[`6731d1b067`](https://github.com/nodejs/node/commit/6731d1b067)] - **test**: remove needless RegExp flags (Vse Mozhet Byt) [#13690](https://github.com/nodejs/node/pull/13690)
* [[`842b84c4e7`](https://github.com/nodejs/node/commit/842b84c4e7)] - **test**: refactor test-http-set-timeout-server (Rich Trott) [#13802](https://github.com/nodejs/node/pull/13802)
* [[`389f29406a`](https://github.com/nodejs/node/commit/389f29406a)] - **test**: make test-http(s)-set-timeout-server alike (jklepatch) [#13625](https://github.com/nodejs/node/pull/13625)
* [[`5e9b2030b9`](https://github.com/nodejs/node/commit/5e9b2030b9)] - **test**: use mustNotCall() in test-fs-watch (Rich Trott) [#13595](https://github.com/nodejs/node/pull/13595)
* [[`9356e9667d`](https://github.com/nodejs/node/commit/9356e9667d)] - **test**: add mustCall() to child-process test (Rich Trott) [#13605](https://github.com/nodejs/node/pull/13605)
* [[`406b3c0371`](https://github.com/nodejs/node/commit/406b3c0371)] - **test**: use mustNotCall in test-http-eof-on-connect (Rich Trott) [#13587](https://github.com/nodejs/node/pull/13587)
* [[`2f19dcddaa`](https://github.com/nodejs/node/commit/2f19dcddaa)] - **test**: refactor test-fs-read-* (Rich Trott) [#13501](https://github.com/nodejs/node/pull/13501)
* [[`3bdf7bf9e9`](https://github.com/nodejs/node/commit/3bdf7bf9e9)] - **test**: refactor domain tests (Rich Trott) [#13480](https://github.com/nodejs/node/pull/13480)
* [[`543d2de700`](https://github.com/nodejs/node/commit/543d2de700)] - **test**: check callback not invoked on lookup error (Rich Trott) [#13456](https://github.com/nodejs/node/pull/13456)
* [[`91fb0cb6b0`](https://github.com/nodejs/node/commit/91fb0cb6b0)] - **test**: refactor test-dgram-oob-buffer (Rich Trott) [#13443](https://github.com/nodejs/node/pull/13443)
* [[`08f7cca3b3`](https://github.com/nodejs/node/commit/08f7cca3b3)] - **test**: add documentation for common.mustNotCall() (Rich Trott) [#13359](https://github.com/nodejs/node/pull/13359)
* [[`55c96cf8a8`](https://github.com/nodejs/node/commit/55c96cf8a8)] - **test**: refactor test-net-server-bind (Rich Trott) [#13273](https://github.com/nodejs/node/pull/13273)
* [[`371b648d1b`](https://github.com/nodejs/node/commit/371b648d1b)] - **test**: use mustCall() in test-readline-interface (Rich Trott) [#13259](https://github.com/nodejs/node/pull/13259)
* [[`3808e3701c`](https://github.com/nodejs/node/commit/3808e3701c)] - **test**: use mustNotCall() in test-stream2-objects (Rich Trott) [#13249](https://github.com/nodejs/node/pull/13249)
* [[`b793fc6cf6`](https://github.com/nodejs/node/commit/b793fc6cf6)] - **test**: replace `indexOf` with `includes` (Aditya Anand) [#13215](https://github.com/nodejs/node/pull/13215)
* [[`b7c7112d7b`](https://github.com/nodejs/node/commit/b7c7112d7b)] - **test**: move stream2 test from pummel to parallel (Rich Trott) [#13146](https://github.com/nodejs/node/pull/13146)
* [[`7a5248d172`](https://github.com/nodejs/node/commit/7a5248d172)] - **test**: simplify assert usage in test-stream2-basic (Rich Trott) [#13146](https://github.com/nodejs/node/pull/13146)
* [[`e15e2e7a30`](https://github.com/nodejs/node/commit/e15e2e7a30)] - **test**: check noop function invocations (Rich Trott) [#13146](https://github.com/nodejs/node/pull/13146)
* [[`4a3e089984`](https://github.com/nodejs/node/commit/4a3e089984)] - **test**: confirm callback is invoked in fs test (Rich Trott) [#13132](https://github.com/nodejs/node/pull/13132)
* [[`8b161e0a78`](https://github.com/nodejs/node/commit/8b161e0a78)] - **test**: check number of message events (Rich Trott) [#13125](https://github.com/nodejs/node/pull/13125)
* [[`c2a0a936e1`](https://github.com/nodejs/node/commit/c2a0a936e1)] - **test**: increase coverage for path.parse (Tobias Nießen) [#14438](https://github.com/nodejs/node/pull/14438)
* [[`202bfcc1c0`](https://github.com/nodejs/node/commit/202bfcc1c0)] - **test**: mark test-fs-read-buffer-to-string-fail as flaky (jeyanthinath) [#14495](https://github.com/nodejs/node/pull/14495)
* [[`a1cef1fc8f`](https://github.com/nodejs/node/commit/a1cef1fc8f)] - **test**: harden test-dgram-bind-shared-ports (Refael Ackermann) [#13100](https://github.com/nodejs/node/pull/13100)
* [[`f578c9bbb6`](https://github.com/nodejs/node/commit/f578c9bbb6)] - **test**: add mustCallAtLeast (Refael Ackermann) [#12935](https://github.com/nodejs/node/pull/12935)
* [[`a7b94500f2`](https://github.com/nodejs/node/commit/a7b94500f2)] - **test**: add common.noop, default for common.mustCall() (James M Snell) [#12027](https://github.com/nodejs/node/pull/12027)
* [[`f3c0b8cd6e`](https://github.com/nodejs/node/commit/f3c0b8cd6e)] - **test,fs**: delay unlink in test-regress-GH-4027.js (Jaime Bernardo) [#14010](https://github.com/nodejs/node/pull/14010)
* [[`e8438c1b22`](https://github.com/nodejs/node/commit/e8438c1b22)] - **timers**: do not use user object call/apply (Rich Trott) [#12960](https://github.com/nodejs/node/pull/12960)
* [[`31f572c3ea`](https://github.com/nodejs/node/commit/31f572c3ea)] - **tools**: update to ESLint 4.3.0 (Rich Trott) [#14417](https://github.com/nodejs/node/pull/14417)
* [[`7d851e3b6a`](https://github.com/nodejs/node/commit/7d851e3b6a)] - **tools**: update package.json `engine` field (AJ Jordan) [#14165](https://github.com/nodejs/node/pull/14165)
* [[`c5adb5f008`](https://github.com/nodejs/node/commit/c5adb5f008)] - **tools**: update ESLint to 4.2.0 (Rich Trott) [#14155](https://github.com/nodejs/node/pull/14155)
* [[`2af21650d6`](https://github.com/nodejs/node/commit/2af21650d6)] - **tools**: generate template literal for addon tests (Rich Trott) [#14094](https://github.com/nodejs/node/pull/14094)
* [[`62de339327`](https://github.com/nodejs/node/commit/62de339327)] - **tools**: remove legacy indentation linting (Rich Trott) [#14515](https://github.com/nodejs/node/pull/14515)
* [[`8b7c4fc06f`](https://github.com/nodejs/node/commit/8b7c4fc06f)] - **tools**: remove align-multiline-assignment lint rule (Rich Trott) [#14079](https://github.com/nodejs/node/pull/14079)
* [[`509205fddd`](https://github.com/nodejs/node/commit/509205fddd)] - **tools**: update to ESLint 4.1.1 (Rich Trott) [#13946](https://github.com/nodejs/node/pull/13946)
* [[`8f664e52d9`](https://github.com/nodejs/node/commit/8f664e52d9)] - **tools**: add script to update ESLint (Rich Trott) [#13895](https://github.com/nodejs/node/pull/13895)
* [[`d34bc78fd4`](https://github.com/nodejs/node/commit/d34bc78fd4)] - **tools**: update to ESLint 4.1.0 (Rich Trott) [#13895](https://github.com/nodejs/node/pull/13895)
* [[`01d82d843b`](https://github.com/nodejs/node/commit/01d82d843b)] - **tools**: use no-use-before-define ESLint rule (Vse Mozhet Byt) [#14032](https://github.com/nodejs/node/pull/14032)
* [[`70901b271c`](https://github.com/nodejs/node/commit/70901b271c)] - **tools**: remove comment in eslint rule (Daniel Bevenius) [#13945](https://github.com/nodejs/node/pull/13945)
* [[`74d5cba007`](https://github.com/nodejs/node/commit/74d5cba007)] - **tools**: add missing #include "unicode/putil.h" (Steven R. Loomis) [#12078](https://github.com/nodejs/node/pull/12078)
* [[`7bb200f624`](https://github.com/nodejs/node/commit/7bb200f624)] - **tools**: add rule prefering common.mustNotCall() (James M Snell) [#12027](https://github.com/nodejs/node/pull/12027)
* [[`d5bf1379b5`](https://github.com/nodejs/node/commit/d5bf1379b5)] - **v8**: fix RegExp nits in v8_prof_polyfill.js (Vse Mozhet Byt) [#13709](https://github.com/nodejs/node/pull/13709)
* [[`9e2d85e441`](https://github.com/nodejs/node/commit/9e2d85e441)] - **v8**: handle proxy objects in MakeMirror(), v2 (Ben Noordhuis) [#14343](https://github.com/nodejs/node/pull/14343)
* [[`bccd2f59b0`](https://github.com/nodejs/node/commit/bccd2f59b0)] - **v8**: handle proxy objects in MakeMirror(), v1 (Ben Noordhuis) [#14343](https://github.com/nodejs/node/pull/14343)
* [[`e79c054f76`](https://github.com/nodejs/node/commit/e79c054f76)] - **zlib**: fix crash when initializing failed (Anna Henningsen) [#14666](https://github.com/nodejs/node/pull/14666)

<a id="6.11.2"></a>
## 2017-08-01, Version 6.11.2 'Boron' (LTS), @MylesBorins

This LTS release comes with 221 commits. This includes 80 which are test related,
52 which are doc related, 32 which are build / tool related and 10 commits which are updates to dependencies.

### Notable Changes

* **configure**:
  * add mips64el to valid_arch (Aditya Anand) [#13620](https://github.com/nodejs/node/pull/13620)
* **crypto**:
  * Updated root certificates based on [NSS 3.30](https://developer.mozilla.org/en-US/docs/Mozilla/Projects/NSS/NSS_3.30_release_notes) (Ben Noordhuis)
    * [#13279](https://github.com/nodejs/node/pull/13279)
    * [#12402](https://github.com/nodejs/node/pull/12402)
* **deps**:
  * upgrade OpenSSL to version 1.0.2.l (Shigeki Ohtsu) [#12913](https://github.com/nodejs/node/pull/12913)
* **http**:
  * parse errors are now reported when NODE_DEBUG=http (Sam Roberts) [#13206](https://github.com/nodejs/node/pull/13206)
  * Agent construction can now be envoked without `new` (cjihrig) [#12927](https://github.com/nodejs/node/pull/12927)
* **zlib**:
  * node will now throw an Error when zlib rejects the value of windowBits, instead of crashing (Alexey Orlenko) [#13098](https://github.com/nodejs/node/pull/13098)

### Commits

* [[`8d043876c1`](https://github.com/nodejs/node/commit/8d043876c1)] - doc/tools: fix more type inconsistencies (Roman Reiss) [#11697](https://github.com/nodejs/node/pull/11697)
* [[`8860117600`](https://github.com/nodejs/node/commit/8860117600)] - **addons**: remove semicolons from after module definition (Gabriel Schulhof) [#12919](https://github.com/nodejs/node/pull/12919)
* [[`bb3f54771b`](https://github.com/nodejs/node/commit/bb3f54771b)] - **benchmark**: update an obsolete path (Vse Mozhet Byt) [#12904](https://github.com/nodejs/node/pull/12904)
* [[`7cc68e2c62`](https://github.com/nodejs/node/commit/7cc68e2c62)] - **benchmark**: add final clean-up to module-loader.js (Vse Mozhet Byt) [#12102](https://github.com/nodejs/node/pull/12102)
* [[`0cc7addcb2`](https://github.com/nodejs/node/commit/0cc7addcb2)] - **benchmark,windows**: TCP.readStart() meaningful only after completion (Refael Ackermann) [#12258](https://github.com/nodejs/node/pull/12258)
* [[`8dec80211e`](https://github.com/nodejs/node/commit/8dec80211e)] - **build**: run test-hash-seed at the end of test-v8 (Michaël Zasso) [#14219](https://github.com/nodejs/node/pull/14219)
* [[`bb1b06a4e5`](https://github.com/nodejs/node/commit/bb1b06a4e5)] - **build**: check for linter in bin rather than lib (Rich Trott) [#13645](https://github.com/nodejs/node/pull/13645)
* [[`f571868b1b`](https://github.com/nodejs/node/commit/f571868b1b)] - **build**: fail linter if linting not available (Gibson Fahnestock) [#13658](https://github.com/nodejs/node/pull/13658)
* [[`b0c6bf829b`](https://github.com/nodejs/node/commit/b0c6bf829b)] - **build**: use existing variable to reduce complexity (Bryce Baril) [#2883](https://github.com/nodejs/node/pull/2883)
* [[`ebbde61927`](https://github.com/nodejs/node/commit/ebbde61927)] - **build**: xz tarball extreme compression (Peter Dave Hello) [#10626](https://github.com/nodejs/node/pull/10626)
* [[`a354134f6a`](https://github.com/nodejs/node/commit/a354134f6a)] - **build**: ignore more VC++ artifacts (Refael Ackermann) [#13208](https://github.com/nodejs/node/pull/13208)
* [[`85829a65e8`](https://github.com/nodejs/node/commit/85829a65e8)] - **build**: avoid /docs/api and /docs/doc/api upload (Rod Vagg) [#12957](https://github.com/nodejs/node/pull/12957)
* [[`7bda9620c9`](https://github.com/nodejs/node/commit/7bda9620c9)] - **build**: simplify `if` in setting of arg_paths (Refael Ackermann) [#12653](https://github.com/nodejs/node/pull/12653)
* [[`2724fe34ef`](https://github.com/nodejs/node/commit/2724fe34ef)] - **build**: add static option to vcbuild.bat (Tony Rice) [#12764](https://github.com/nodejs/node/pull/12764)
* [[`7458d4ef98`](https://github.com/nodejs/node/commit/7458d4ef98)] - **build**: disable -O3 for C++ coverage (Anna Henningsen) [#12406](https://github.com/nodejs/node/pull/12406)
* [[`8b8bf39822`](https://github.com/nodejs/node/commit/8b8bf39822)] - **build**: avoid passing kill empty input in Makefile (Gibson Fahnestock) [#12158](https://github.com/nodejs/node/pull/12158)
* [[`914f368efd`](https://github.com/nodejs/node/commit/914f368efd)] - **build**: clear stalled jobs on POSIX CI hosts (Rich Trott) [#11246](https://github.com/nodejs/node/pull/11246)
* [[`890e210a5f`](https://github.com/nodejs/node/commit/890e210a5f)] - **build**: fix openssl link error on windows (Daniel Bevenius) [#13078](https://github.com/nodejs/node/pull/13078)
* [[`3bb117e310`](https://github.com/nodejs/node/commit/3bb117e310)] - **build**: enable cctest to use generated objects (Daniel Bevenius) [#11956](https://github.com/nodejs/node/pull/11956)
* [[`e5ca046c0a`](https://github.com/nodejs/node/commit/e5ca046c0a)] - **build, doc, tools**: add eslint-plugin-markdown (Vse Mozhet Byt) [#14067](https://github.com/nodejs/node/pull/14067)
* [[`b46cf35526`](https://github.com/nodejs/node/commit/b46cf35526)] - **child_process**: fix deoptimizing use of arguments (Vse Mozhet Byt) [#11535](https://github.com/nodejs/node/pull/11535)
* [[`edbe442938`](https://github.com/nodejs/node/commit/edbe442938)] - **cluster, dns, repl, tls, util**: fix RegExp nits (Vse Mozhet Byt) [#13536](https://github.com/nodejs/node/pull/13536)
* [[`a5f3b6fa7c`](https://github.com/nodejs/node/commit/a5f3b6fa7c)] - **configure**: add mips64el to valid_arch (Aditya Anand) [#13620](https://github.com/nodejs/node/pull/13620)
* [[`3b44e5e32c`](https://github.com/nodejs/node/commit/3b44e5e32c)] - **crypto**: return CHECK_OK in VerifyCallback (Daniel Bevenius) [#13241](https://github.com/nodejs/node/pull/13241)
* [[`1bfd177f09`](https://github.com/nodejs/node/commit/1bfd177f09)] - **crypto**: update root certificates (Ben Noordhuis) [#13279](https://github.com/nodejs/node/pull/13279)
* [[`b6f3581ea4`](https://github.com/nodejs/node/commit/b6f3581ea4)] - **crypto**: update root certificates (Ben Noordhuis) [#12402](https://github.com/nodejs/node/pull/12402)
* [[`1d509801e9`](https://github.com/nodejs/node/commit/1d509801e9)] - **crypto**: throw proper errors if out enc is UTF-16 (Anna Henningsen) [#12752](https://github.com/nodejs/node/pull/12752)
* [[`8f8dd97072`](https://github.com/nodejs/node/commit/8f8dd97072)] - **crypto**: clear err stack after ECDH::BufferToPoint (Ryan Kelly) [#13275](https://github.com/nodejs/node/pull/13275)
* [[`3891759afc`](https://github.com/nodejs/node/commit/3891759afc)] - **deps**: update openssl asm and asm_obsolete files (Shigeki Ohtsu) [#12913](https://github.com/nodejs/node/pull/12913)
* [[`92583c4c81`](https://github.com/nodejs/node/commit/92583c4c81)] - **deps**: cherry-pick 4ae5993 from upstream OpenSSL (Shigeki Ohtsu) [#12913](https://github.com/nodejs/node/pull/12913)
* [[`ee40a73d44`](https://github.com/nodejs/node/commit/ee40a73d44)] - **deps**: update openssl asm and asm_obsolete files (Daniel Bevenius) [#13233](https://github.com/nodejs/node/pull/13233)
* [[`a6a85c49c3`](https://github.com/nodejs/node/commit/a6a85c49c3)] - **deps**: update openssl config files (Daniel Bevenius) [#13233](https://github.com/nodejs/node/pull/13233)
* [[`a579a776a3`](https://github.com/nodejs/node/commit/a579a776a3)] - **deps**: add -no_rand_screen to openssl s_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`b937c41405`](https://github.com/nodejs/node/commit/b937c41405)] - **deps**: fix asm build error of openssl in x86_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`69570d370a`](https://github.com/nodejs/node/commit/69570d370a)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`5703d22849`](https://github.com/nodejs/node/commit/5703d22849)] - **deps**: copy all openssl header files to include dir (Daniel Bevenius) [#13233](https://github.com/nodejs/node/pull/13233)
* [[`77a9198aca`](https://github.com/nodejs/node/commit/77a9198aca)] - **deps**: upgrade openssl sources to 1.0.2l (Daniel Bevenius) [#13233](https://github.com/nodejs/node/pull/13233)
* [[`5b4c431365`](https://github.com/nodejs/node/commit/5b4c431365)] - **deps**: add example of comparing OpenSSL changes (Daniel Bevenius) [#13234](https://github.com/nodejs/node/pull/13234)
* [[`18cbee236d`](https://github.com/nodejs/node/commit/18cbee236d)] - **dns**: fix crash using dns.setServers after resolve4 (XadillaX) [#13050](https://github.com/nodejs/node/pull/13050)
* [[`8c0849d5db`](https://github.com/nodejs/node/commit/8c0849d5db)] - **doc**: conform to rules for eslint-plugin-markdown (Vse Mozhet Byt) [#12563](https://github.com/nodejs/node/pull/12563)
* [[`7deb259ccb`](https://github.com/nodejs/node/commit/7deb259ccb)] - **doc**: prepare js code for eslint-plugin-markdown (Vse Mozhet Byt) [#12563](https://github.com/nodejs/node/pull/12563)
* [[`59eb761797`](https://github.com/nodejs/node/commit/59eb761797)] - **doc**: document and test that methods return this (Sam Roberts) [#13553](https://github.com/nodejs/node/pull/13553)
* [[`fcb27fa7a1`](https://github.com/nodejs/node/commit/fcb27fa7a1)] - **doc**: remove leftover WHATWG url.format section (Roman Reiss) [#14351](https://github.com/nodejs/node/pull/14351)
* [[`e400ef9a76`](https://github.com/nodejs/node/commit/e400ef9a76)] - **doc**: don't suggest setEncoding for binary streams (Rick Bullotta) [#11363](https://github.com/nodejs/node/pull/11363)
* [[`092bba5cbf`](https://github.com/nodejs/node/commit/092bba5cbf)] - **doc**: update backporting guide (Refael Ackermann) [#13749](https://github.com/nodejs/node/pull/13749)
* [[`e2abda87f5`](https://github.com/nodejs/node/commit/e2abda87f5)] - **doc**: mention rebasing of v?.x-staging post release (Anna Henningsen) [#13742](https://github.com/nodejs/node/pull/13742)
* [[`24feb333c8`](https://github.com/nodejs/node/commit/24feb333c8)] - **doc**: `path.relative` uses `cwd` (DuanPengfei) [#13714](https://github.com/nodejs/node/pull/13714)
* [[`71581e9308`](https://github.com/nodejs/node/commit/71581e9308)] - **doc**: small makeover for onboarding.md (Anna Henningsen) [#13413](https://github.com/nodejs/node/pull/13413)
* [[`8f430e774b`](https://github.com/nodejs/node/commit/8f430e774b)] - **doc**: note that EoL platforms are not supported (Gibson Fahnestock) [#12672](https://github.com/nodejs/node/pull/12672)
* [[`9fa70069b3`](https://github.com/nodejs/node/commit/9fa70069b3)] - **doc**: use HTTPS URL for suggested upstream remote (Nikolai Vavilov) [#13602](https://github.com/nodejs/node/pull/13602)
* [[`fa209323af`](https://github.com/nodejs/node/commit/fa209323af)] - **doc**: update new CTC members (Refael Ackermann) [#13534](https://github.com/nodejs/node/pull/13534)
* [[`054f8cdc4d`](https://github.com/nodejs/node/commit/054f8cdc4d)] - **doc**: corrects reference to tlsClientError (Tarun) [#13533](https://github.com/nodejs/node/pull/13533)
* [[`17da29ce84`](https://github.com/nodejs/node/commit/17da29ce84)] - **doc**: emphasize Collaborators in GOVERNANCE.md (Rich Trott) [#13423](https://github.com/nodejs/node/pull/13423)
* [[`aea953abc2`](https://github.com/nodejs/node/commit/aea953abc2)] - **doc**: minimal documentation for Emeritus status (Rich Trott) [#13421](https://github.com/nodejs/node/pull/13421)
* [[`42a42c0892`](https://github.com/nodejs/node/commit/42a42c0892)] - **doc**: remove note highlighting in GOVERNANCE doc (Rich Trott) [#13420](https://github.com/nodejs/node/pull/13420)
* [[`cc492c361f`](https://github.com/nodejs/node/commit/cc492c361f)] - **doc**: resume a stream after pipe() and unpipe() (Matteo Collina) [#13329](https://github.com/nodejs/node/pull/13329)
* [[`ae00f25a69`](https://github.com/nodejs/node/commit/ae00f25a69)] - **doc**: suggest xcode-select --install (Gibson Fahnestock) [#13264](https://github.com/nodejs/node/pull/13264)
* [[`8daab3be31`](https://github.com/nodejs/node/commit/8daab3be31)] - **doc**: remove 'you' from writing-tests.md (Michael Dawson) [#13319](https://github.com/nodejs/node/pull/13319)
* [[`f2ede07f17`](https://github.com/nodejs/node/commit/f2ede07f17)] - **doc**: add tniessen to collaborators (Tobias Nießen) [#13371](https://github.com/nodejs/node/pull/13371)
* [[`a33c6759b6`](https://github.com/nodejs/node/commit/a33c6759b6)] - **doc**: create list of CTC emeriti (Rich Trott) [#13232](https://github.com/nodejs/node/pull/13232)
* [[`3745fbaa5d`](https://github.com/nodejs/node/commit/3745fbaa5d)] - **doc**: remove Gitter badge from README (Rich Trott) [#13231](https://github.com/nodejs/node/pull/13231)
* [[`a7b51af049`](https://github.com/nodejs/node/commit/a7b51af049)] - **doc**: make spelling of behavior consistent (Michael Dawson) [#13245](https://github.com/nodejs/node/pull/13245)
* [[`277de4257d`](https://github.com/nodejs/node/commit/277de4257d)] - **doc**: add jasongin & kunalspathak to collaborators (Jason Ginchereau) [#13200](https://github.com/nodejs/node/pull/13200)
* [[`fb07fbcc81`](https://github.com/nodejs/node/commit/fb07fbcc81)] - **doc**: don't use useless constructors in stream.md (Vse Mozhet Byt) [#13145](https://github.com/nodejs/node/pull/13145)
* [[`cb03bd1f48`](https://github.com/nodejs/node/commit/cb03bd1f48)] - **doc**: update code example for Windows in stream.md (Vse Mozhet Byt) [#13138](https://github.com/nodejs/node/pull/13138)
* [[`079b04e58d`](https://github.com/nodejs/node/commit/079b04e58d)] - **doc**: improve formatting of STYLE_GUIDE.md (Alexey Orlenko) [#13135](https://github.com/nodejs/node/pull/13135)
* [[`5f87252969`](https://github.com/nodejs/node/commit/5f87252969)] - **doc**: fix incorrect keyboard shortcut (Alexey Orlenko) [#13134](https://github.com/nodejs/node/pull/13134)
* [[`d4edc82aa5`](https://github.com/nodejs/node/commit/d4edc82aa5)] - **doc**: edit Error.captureStackTrace html comment (Artur Vieira) [#12962](https://github.com/nodejs/node/pull/12962)
* [[`1f9713362d`](https://github.com/nodejs/node/commit/1f9713362d)] - **doc**: add additional useful ci job to list (Michael Dawson) [#13086](https://github.com/nodejs/node/pull/13086)
* [[`2d5e2e9cab`](https://github.com/nodejs/node/commit/2d5e2e9cab)] - **doc**: document method for reverting commits (Gibson Fahnestock) [#13015](https://github.com/nodejs/node/pull/13015)
* [[`b31e6dfef5`](https://github.com/nodejs/node/commit/b31e6dfef5)] - **doc**: update COLLABORATOR_GUIDE.md (morrme) [#12555](https://github.com/nodejs/node/pull/12555)
* [[`b854d27330`](https://github.com/nodejs/node/commit/b854d27330)] - **doc**: Change options at STEP 5 in CONTRIBUTING.md (kysnm) [#12830](https://github.com/nodejs/node/pull/12830)
* [[`c01a2d545e`](https://github.com/nodejs/node/commit/c01a2d545e)] - **doc**: add docs for server.address() for pipe case (Flarna) [#12907](https://github.com/nodejs/node/pull/12907)
* [[`83f272d4ee`](https://github.com/nodejs/node/commit/83f272d4ee)] - **doc**: fix typo in streams.md (Glenn Schlereth) [#12924](https://github.com/nodejs/node/pull/12924)
* [[`28add410c2`](https://github.com/nodejs/node/commit/28add410c2)] - **doc**: improve path.posix.normalize docs (Steven Lehn) [#12700](https://github.com/nodejs/node/pull/12700)
* [[`023ec46d2c`](https://github.com/nodejs/node/commit/023ec46d2c)] - **doc**: remove test-npm from general build doc (Rich Trott) [#12840](https://github.com/nodejs/node/pull/12840)
* [[`74a6929938`](https://github.com/nodejs/node/commit/74a6929938)] - **doc**: upgrade Clang requirement to 3.4.2 (Michaël Zasso) [#12388](https://github.com/nodejs/node/pull/12388)
* [[`5b379e0aad`](https://github.com/nodejs/node/commit/5b379e0aad)] - **doc**: clarify the callback arguments of dns.resolve (Roman Reiss) [#9532](https://github.com/nodejs/node/pull/9532)
* [[`f6e58c35b2`](https://github.com/nodejs/node/commit/f6e58c35b2)] - **doc**: add missing make command to UPGRADING.md (Daniel Bevenius) [#13233](https://github.com/nodejs/node/pull/13233)
* [[`a7869541e4`](https://github.com/nodejs/node/commit/a7869541e4)] - **doc**: increase Buffer.concat() documentation (cjihrig) [#11845](https://github.com/nodejs/node/pull/11845)
* [[`3b1d9112e0`](https://github.com/nodejs/node/commit/3b1d9112e0)] - **doc**: update readFileSync in fs.md (Aditya Anand) [#12800](https://github.com/nodejs/node/pull/12800)
* [[`bc66495061`](https://github.com/nodejs/node/commit/bc66495061)] - **doc**: document vm timeout option perf impact (Anna Henningsen) [#12751](https://github.com/nodejs/node/pull/12751)
* [[`a3ae360ea6`](https://github.com/nodejs/node/commit/a3ae360ea6)] - **doc**: modernize and fix code examples in repl.md (Vse Mozhet Byt) [#12634](https://github.com/nodejs/node/pull/12634)
* [[`2435af9db6`](https://github.com/nodejs/node/commit/2435af9db6)] - **doc**: update os.uptime() and process.uptime() info (Vse Mozhet Byt) [#12294](https://github.com/nodejs/node/pull/12294)
* [[`b2e58b6c7a`](https://github.com/nodejs/node/commit/b2e58b6c7a)] - **doc**: minor improvements in BUILDING.md (Sakthipriyan Vairamani (thefourtheye)) [#11963](https://github.com/nodejs/node/pull/11963)
* [[`7ba172f56f`](https://github.com/nodejs/node/commit/7ba172f56f)] - **doc**: argument types for https methods (Amelia Clarke) [#11681](https://github.com/nodejs/node/pull/11681)
* [[`eb9e281b6b`](https://github.com/nodejs/node/commit/eb9e281b6b)] - **doc**: update output examples in debugger.md (Vse Mozhet Byt) [#10944](https://github.com/nodejs/node/pull/10944)
* [[`b62cec8b02`](https://github.com/nodejs/node/commit/b62cec8b02)] - **doc**: linkify type\[\] syntax, support lowercase for primitives (Roman Reiss) [#11167](https://github.com/nodejs/node/pull/11167)
* [[`dd1fb98bda`](https://github.com/nodejs/node/commit/dd1fb98bda)] - **doc**: consistent case for primitive types (Roman Reiss) [#11167](https://github.com/nodejs/node/pull/11167)
* [[`c43866954e`](https://github.com/nodejs/node/commit/c43866954e)] - **doc,build**: update configure help messages (Gibson Fahnestock) [#12978](https://github.com/nodejs/node/pull/12978)
* [[`0d35bcdf84`](https://github.com/nodejs/node/commit/0d35bcdf84)] - **doc,stream**: clarify 'data', pipe() and 'readable' (Matteo Collina) [#13432](https://github.com/nodejs/node/pull/13432)
* [[`351be2d5a8`](https://github.com/nodejs/node/commit/351be2d5a8)] - **dtrace**: resolve conversion warnings from SLURP_INT (Christopher J. Brody) [#10143](https://github.com/nodejs/node/pull/10143)
* [[`046bd79cf7`](https://github.com/nodejs/node/commit/046bd79cf7)] - **events**: remove unreachable code (cjihrig) [#12501](https://github.com/nodejs/node/pull/12501)
* [[`8bf64d135f`](https://github.com/nodejs/node/commit/8bf64d135f)] - **events**: do not keep arrays with a single listener (Luigi Pinca) [#12043](https://github.com/nodejs/node/pull/12043)
* [[`f66f09f5d1`](https://github.com/nodejs/node/commit/f66f09f5d1)] - **http**: describe parse err in debug output (Sam Roberts) [#13206](https://github.com/nodejs/node/pull/13206)
* [[`cab1285ccf`](https://github.com/nodejs/node/commit/cab1285ccf)] - **http**: fix first body chunk fast case for UTF-16 (Anna Henningsen) [#12747](https://github.com/nodejs/node/pull/12747)
* [[`01302989a7`](https://github.com/nodejs/node/commit/01302989a7)] - **https**: support rejectUnauthorized for unix sockets (cjihrig) [#13505](https://github.com/nodejs/node/pull/13505)
* [[`d51cd61713`](https://github.com/nodejs/node/commit/d51cd61713)] - **https**: support agent construction without new (cjihrig) [#12927](https://github.com/nodejs/node/pull/12927)
* [[`5eb11ba73e`](https://github.com/nodejs/node/commit/5eb11ba73e)] - **lib**: correct typo in createSecureContext (Daniel Bevenius) [#13653](https://github.com/nodejs/node/pull/13653)
* [[`102671823c`](https://github.com/nodejs/node/commit/102671823c)] - **lib**: "iff" changed to "if and only if" (Jacob Jones) [#13496](https://github.com/nodejs/node/pull/13496)
* [[`1609c7f0c5`](https://github.com/nodejs/node/commit/1609c7f0c5)] - **lib**: remove useless default caught (Jackson Tian) [#12884](https://github.com/nodejs/node/pull/12884)
* [[`ef133b36c5`](https://github.com/nodejs/node/commit/ef133b36c5)] - **lib,test**: use regular expression literals (Rich Trott) [#12807](https://github.com/nodejs/node/pull/12807)
* [[`0cb5bd7268`](https://github.com/nodejs/node/commit/0cb5bd7268)] - **meta**: fix nits in README.md collaborators list (Vse Mozhet Byt) [#12866](https://github.com/nodejs/node/pull/12866)
* [[`4c51d969ee`](https://github.com/nodejs/node/commit/4c51d969ee)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`47e702059d`](https://github.com/nodejs/node/commit/47e702059d)] - **os,vm**: fix segfaults and CHECK failure (Tobias Nießen) [#12371](https://github.com/nodejs/node/pull/12371)
* [[`c97b167f47`](https://github.com/nodejs/node/commit/c97b167f47)] - **profiler**: declare missing `printErr` (Fedor Indutny) [#13590](https://github.com/nodejs/node/pull/13590)
* [[`bd323a71a8`](https://github.com/nodejs/node/commit/bd323a71a8)] - **repl**: fix /dev/null history file regression (Brian White) [#12762](https://github.com/nodejs/node/pull/12762)
* [[`b2acb81016`](https://github.com/nodejs/node/commit/b2acb81016)] - **repl**: support hidden history file on Windows (Bartosz Sosnowski) [#12207](https://github.com/nodejs/node/pull/12207)
* [[`79592fe44a`](https://github.com/nodejs/node/commit/79592fe44a)] - **src**: correct indentation for X509ToObject (Daniel Bevenius) [#13543](https://github.com/nodejs/node/pull/13543)
* [[`69143ffcf9`](https://github.com/nodejs/node/commit/69143ffcf9)] - **src**: make IsConstructCall checks consistent (Daniel Bevenius) [#13473](https://github.com/nodejs/node/pull/13473)
* [[`48f00b5170`](https://github.com/nodejs/node/commit/48f00b5170)] - **src**: add comment for TicketKeyCallback (Anna Henningsen) [#13193](https://github.com/nodejs/node/pull/13193)
* [[`37e1929257`](https://github.com/nodejs/node/commit/37e1929257)] - **src**: check IsConstructCall in TLSWrap constructor (Daniel Bevenius) [#13097](https://github.com/nodejs/node/pull/13097)
* [[`2e23da1a12`](https://github.com/nodejs/node/commit/2e23da1a12)] - **src**: remove unused node_buffer.h include (Daniel Bevenius) [#13095](https://github.com/nodejs/node/pull/13095)
* [[`41661287f2`](https://github.com/nodejs/node/commit/41661287f2)] - **src**: split CryptoPemCallback into two functions (Daniel Bevenius) [#12827](https://github.com/nodejs/node/pull/12827)
* [[`f92e065d12`](https://github.com/nodejs/node/commit/f92e065d12)] - **src**: assert that uv_async_init() succeeds (cjihrig) [#13116](https://github.com/nodejs/node/pull/13116)
* [[`f43c969061`](https://github.com/nodejs/node/commit/f43c969061)] - **src**: turn buffer type-CHECK into exception (Anna Henningsen) [#12753](https://github.com/nodejs/node/pull/12753)
* [[`19259f46d0`](https://github.com/nodejs/node/commit/19259f46d0)] - **src**: rename CryptoPemCallback -\> PasswordCallback (Daniel Bevenius) [#12787](https://github.com/nodejs/node/pull/12787)
* [[`7aa5a993b2`](https://github.com/nodejs/node/commit/7aa5a993b2)] - **src**: make cross-context MakeCallback() calls work (Ben Noordhuis) [#9221](https://github.com/nodejs/node/pull/9221)
* [[`b1dc2d455f`](https://github.com/nodejs/node/commit/b1dc2d455f)] - **src**: remove superfluous env_string string (Ben Noordhuis) [#9213](https://github.com/nodejs/node/pull/9213)
* [[`48a923af37`](https://github.com/nodejs/node/commit/48a923af37)] - **stream**: remove unnecessary parameter (Leo) [#12767](https://github.com/nodejs/node/pull/12767)
* [[`9cfec4ba0f`](https://github.com/nodejs/node/commit/9cfec4ba0f)] - **test**: fix RegExp nits (Vse Mozhet Byt) [#13770](https://github.com/nodejs/node/pull/13770)
* [[`a3e2560f7a`](https://github.com/nodejs/node/commit/a3e2560f7a)] - **test**: mark test-npm-install flaky on arm (Refael Ackermann) [#14035](https://github.com/nodejs/node/pull/14035)
* [[`8a7f13bd00`](https://github.com/nodejs/node/commit/8a7f13bd00)] - **test**: mark test-fs-readdir-ucs2 flaky (João Reis) [#13989](https://github.com/nodejs/node/pull/13989)
* [[`34fc7a03d2`](https://github.com/nodejs/node/commit/34fc7a03d2)] - **test**: change deprecated method to recommended (Rich Trott) [#13649](https://github.com/nodejs/node/pull/13649)
* [[`ef3698cad8`](https://github.com/nodejs/node/commit/ef3698cad8)] - **test**: refactor test-cluster-worker-isconnected.js (cjihrig) [#13685](https://github.com/nodejs/node/pull/13685)
* [[`fa75be7901`](https://github.com/nodejs/node/commit/fa75be7901)] - **test**: fix nits in test-fs-mkdir-rmdir.js (Vse Mozhet Byt) [#13680](https://github.com/nodejs/node/pull/13680)
* [[`9e9a9c342c`](https://github.com/nodejs/node/commit/9e9a9c342c)] - **test**: increase bufsize in child process write test (Rich Trott) [#13626](https://github.com/nodejs/node/pull/13626)
* [[`53b345c506`](https://github.com/nodejs/node/commit/53b345c506)] - **test**: fix flaky test-tls-socket-close (Rich Trott) [#13529](https://github.com/nodejs/node/pull/13529)
* [[`a37165a2cc`](https://github.com/nodejs/node/commit/a37165a2cc)] - **test**: exercise once() with varying arguments (cjihrig) [#13524](https://github.com/nodejs/node/pull/13524)
* [[`779402ec5f`](https://github.com/nodejs/node/commit/779402ec5f)] - **test**: validate full error messages (aniketshukla) [#13453](https://github.com/nodejs/node/pull/13453)
* [[`7190d06d1f`](https://github.com/nodejs/node/commit/7190d06d1f)] - **test**: add known_test request with Unicode in the URL (David D Lowe) [#13297](https://github.com/nodejs/node/pull/13297)
* [[`cbcc9c1bbf`](https://github.com/nodejs/node/commit/cbcc9c1bbf)] - **test**: add coverage for socket write after close (cjihrig) [#13171](https://github.com/nodejs/node/pull/13171)
* [[`47d59e7f97`](https://github.com/nodejs/node/commit/47d59e7f97)] - **test**: fix sequential test-net-connect-local-error (Sebastian Plesciuc) [#13064](https://github.com/nodejs/node/pull/13064)
* [[`1d3596561b`](https://github.com/nodejs/node/commit/1d3596561b)] - **test**: bind to 0 in dgram-send-callback-buffer-length (Artur Vieira) [#12943](https://github.com/nodejs/node/pull/12943)
* [[`7909c6d46f`](https://github.com/nodejs/node/commit/7909c6d46f)] - **test**: use dynamic port in test-dgram-send-callback-buffer (Artur Vieira) [#12942](https://github.com/nodejs/node/pull/12942)
* [[`92cc96fa6b`](https://github.com/nodejs/node/commit/92cc96fa6b)] - **test**: allow for absent nobody user in setuid test (Rich Trott) [#13112](https://github.com/nodejs/node/pull/13112)
* [[`253c5aa794`](https://github.com/nodejs/node/commit/253c5aa794)] - **test**: move net reconnect error test to sequential (Artur G Vieira) [#13033](https://github.com/nodejs/node/pull/13033)
* [[`e279eb5aa3`](https://github.com/nodejs/node/commit/e279eb5aa3)] - **test**: ignore spurious 'EMFILE' (Refael Ackermann) [#12698](https://github.com/nodejs/node/pull/12698)
* [[`3e5e38e868`](https://github.com/nodejs/node/commit/3e5e38e868)] - **test**: use dynamic port in test-cluster-dgram-reuse (Artur Vieira) [#12901](https://github.com/nodejs/node/pull/12901)
* [[`5fe68402bd`](https://github.com/nodejs/node/commit/5fe68402bd)] - **test**: refactor test-vm-new-script-new-context (Akshay Iyer) [#13035](https://github.com/nodejs/node/pull/13035)
* [[`2aa68282fc`](https://github.com/nodejs/node/commit/2aa68282fc)] - **test**: track callback invocations (Rich Trott) [#13010](https://github.com/nodejs/node/pull/13010)
* [[`0c83573b61`](https://github.com/nodejs/node/commit/0c83573b61)] - **test**: add a simple abort check in windows (Sreepurna Jasti) [#12914](https://github.com/nodejs/node/pull/12914)
* [[`07137ab4db`](https://github.com/nodejs/node/commit/07137ab4db)] - **test**: fix too optimistic guess in setproctitle (Vse Mozhet Byt) [#12792](https://github.com/nodejs/node/pull/12792)
* [[`7419338b33`](https://github.com/nodejs/node/commit/7419338b33)] - **test**: make the rest of tests path-independent (Vse Mozhet Byt) [#12972](https://github.com/nodejs/node/pull/12972)
* [[`ac400a7b09`](https://github.com/nodejs/node/commit/ac400a7b09)] - **test**: check curve algorithm is supported (Karl Cheng)
* [[`5b74e635e5`](https://github.com/nodejs/node/commit/5b74e635e5)] - **test**: reduce string concatenations (Vse Mozhet Byt) [#12735](https://github.com/nodejs/node/pull/12735)
* [[`c902265b90`](https://github.com/nodejs/node/commit/c902265b90)] - **test**: fix parallel/test-setproctitle.js on alpine (David Cai) [#12413](https://github.com/nodejs/node/pull/12413)
* [[`50bb452510`](https://github.com/nodejs/node/commit/50bb452510)] - **test**: fixed flaky test-net-connect-local-error (Sebastian Plesciuc) [#12964](https://github.com/nodejs/node/pull/12964)
* [[`0cf3e10ce2`](https://github.com/nodejs/node/commit/0cf3e10ce2)] - **test**: remove unneeded string splitting (Vse Mozhet Byt) [#12992](https://github.com/nodejs/node/pull/12992)
* [[`6e7b77fdbb`](https://github.com/nodejs/node/commit/6e7b77fdbb)] - **test**: use mustCall in tls-connect-given-socket (vperezma) [#12592](https://github.com/nodejs/node/pull/12592)
* [[`c10525c562`](https://github.com/nodejs/node/commit/c10525c562)] - **test**: add not-called check to heap-profiler test (Rich Trott) [#12985](https://github.com/nodejs/node/pull/12985)
* [[`2451665157`](https://github.com/nodejs/node/commit/2451665157)] - **test**: move test-dgram-bind-shared-ports to sequential (Rafael Fragoso) [#12452](https://github.com/nodejs/node/pull/12452)
* [[`d35648ffc2`](https://github.com/nodejs/node/commit/d35648ffc2)] - **test**: use dynamic port in test-https-connect-address-family (Artur G Vieira) [#12915](https://github.com/nodejs/node/pull/12915)
* [[`1cd41e7a56`](https://github.com/nodejs/node/commit/1cd41e7a56)] - **test**: dynamic port in cluster disconnect (Sebastian Plesciuc) [#12545](https://github.com/nodejs/node/pull/12545)
* [[`d71de281fa`](https://github.com/nodejs/node/commit/d71de281fa)] - **test**: detect all types of aborts in windows (Gireesh Punathil) [#12856](https://github.com/nodejs/node/pull/12856)
* [[`d743783875`](https://github.com/nodejs/node/commit/d743783875)] - **test**: use assert regexp in tls no cert test (Artur Vieira) [#12891](https://github.com/nodejs/node/pull/12891)
* [[`29d35d0ef1`](https://github.com/nodejs/node/commit/29d35d0ef1)] - **test**: use dynamic port instead of common.PORT (Aditya Anand) [#12473](https://github.com/nodejs/node/pull/12473)
* [[`186c0758b3`](https://github.com/nodejs/node/commit/186c0758b3)] - **test**: added net.connect lookup type check (Luca Maraschi) [#11873](https://github.com/nodejs/node/pull/11873)
* [[`c35f4909f4`](https://github.com/nodejs/node/commit/c35f4909f4)] - **test**: remove unused testpy code (Rich Trott) [#12844](https://github.com/nodejs/node/pull/12844)
* [[`52b7d5ecb1`](https://github.com/nodejs/node/commit/52b7d5ecb1)] - **test**: refactor test-querystring (Łukasz Szewczak) [#12661](https://github.com/nodejs/node/pull/12661)
* [[`8414659d02`](https://github.com/nodejs/node/commit/8414659d02)] - **test**: refactoring test with common.mustCall (weewey) [#12702](https://github.com/nodejs/node/pull/12702)
* [[`608c30913e`](https://github.com/nodejs/node/commit/608c30913e)] - **test**: refactored test-repl-persistent-history (cool88) [#12703](https://github.com/nodejs/node/pull/12703)
* [[`aaf8044a81`](https://github.com/nodejs/node/commit/aaf8044a81)] - **test**: remove common.PORT in test tls ticket cluster (Oscar Martinez) [#12715](https://github.com/nodejs/node/pull/12715)
* [[`802a945d81`](https://github.com/nodejs/node/commit/802a945d81)] - **test**: add mustCall in timers-unrefed-in-callback (Zahidul Islam) [#12594](https://github.com/nodejs/node/pull/12594)
* [[`739c579134`](https://github.com/nodejs/node/commit/739c579134)] - **test**: fix flakyness with `yes.exe` (Refael Ackermann) [#12821](https://github.com/nodejs/node/pull/12821)
* [[`14e835831f`](https://github.com/nodejs/node/commit/14e835831f)] - **test**: dynamic port in dgram tests (Sebastian Plesciuc) [#12623](https://github.com/nodejs/node/pull/12623)
* [[`361bc845dc`](https://github.com/nodejs/node/commit/361bc845dc)] - **test**: verify listener leak is only emitted once (cjihrig) [#12502](https://github.com/nodejs/node/pull/12502)
* [[`f236dcbdd9`](https://github.com/nodejs/node/commit/f236dcbdd9)] - **test**: move WPT to its own testing module (Rich Trott) [#12736](https://github.com/nodejs/node/pull/12736)
* [[`4eb28c80e8`](https://github.com/nodejs/node/commit/4eb28c80e8)] - **test**: introduce `common.crashOnUnhandledRejection` (Anna Henningsen) [#12489](https://github.com/nodejs/node/pull/12489)
* [[`2411318f60`](https://github.com/nodejs/node/commit/2411318f60)] - **test**: add second argument to assert.throws (Michaël Zasso) [#12270](https://github.com/nodejs/node/pull/12270)
* [[`eca9e72a87`](https://github.com/nodejs/node/commit/eca9e72a87)] - **test**: add regex in test_cyclic_link_protection (Clarence Dimitri CHARLES) [#11622](https://github.com/nodejs/node/pull/11622)
* [[`6020e720b5`](https://github.com/nodejs/node/commit/6020e720b5)] - **test**: improve test-fs-open-flags (Vinícius do Carmo) [#10908](https://github.com/nodejs/node/pull/10908)
* [[`e6d6a4111c`](https://github.com/nodejs/node/commit/e6d6a4111c)] - **test**: extended test to makeCallback cb type check (Luca Maraschi) [#12140](https://github.com/nodejs/node/pull/12140)
* [[`d74019d98d`](https://github.com/nodejs/node/commit/d74019d98d)] - **test**: improve test-crypto-rsa-dsa (Adrian Estrada) [#10681](https://github.com/nodejs/node/pull/10681)
* [[`bab8a36f94`](https://github.com/nodejs/node/commit/bab8a36f94)] - **test**: improve the code in test-crypto-dh (Adrian Estrada) [#10734](https://github.com/nodejs/node/pull/10734)
* [[`752bc24943`](https://github.com/nodejs/node/commit/752bc24943)] - **test**: validate errors in test-buffer-indexof (Adrian Estrada) [#10752](https://github.com/nodejs/node/pull/10752)
* [[`9e7f02187a`](https://github.com/nodejs/node/commit/9e7f02187a)] - **test**: improve test-buffer-includes.js (toboid) [#11203](https://github.com/nodejs/node/pull/11203)
* [[`c309bb0695`](https://github.com/nodejs/node/commit/c309bb0695)] - **test**: validate error message from buffer.equals (Sebastian Roeder) [#11215](https://github.com/nodejs/node/pull/11215)
* [[`62c56806fc`](https://github.com/nodejs/node/commit/62c56806fc)] - **test**: add msg validation to test-buffer-compare (Josh Hollandsworth) [#10807](https://github.com/nodejs/node/pull/10807)
* [[`fc9e7a98ed`](https://github.com/nodejs/node/commit/fc9e7a98ed)] - **test**: make tests cwd-independent (Vse Mozhet Byt) [#12812](https://github.com/nodejs/node/pull/12812)
* [[`fff0e39933`](https://github.com/nodejs/node/commit/fff0e39933)] - **test**: add regex check in test-vm-is-context (jeyanthinath) [#12785](https://github.com/nodejs/node/pull/12785)
* [[`74dc86d239`](https://github.com/nodejs/node/commit/74dc86d239)] - **test**: add callback to fs.close() in test-fs-stat (Vse Mozhet Byt) [#12804](https://github.com/nodejs/node/pull/12804)
* [[`a47a9b7cf4`](https://github.com/nodejs/node/commit/a47a9b7cf4)] - **test**: add callback to fs.close() in test-fs-chmod (Vse Mozhet Byt) [#12795](https://github.com/nodejs/node/pull/12795)
* [[`eefa840118`](https://github.com/nodejs/node/commit/eefa840118)] - **test**: increase readline coverage (Anna Henningsen) [#12761](https://github.com/nodejs/node/pull/12761)
* [[`54decfa2ce`](https://github.com/nodejs/node/commit/54decfa2ce)] - **test**: replace indexOf with includes (gwer) [#12604](https://github.com/nodejs/node/pull/12604)
* [[`03adb94ee6`](https://github.com/nodejs/node/commit/03adb94ee6)] - **test**: dynamic port in parallel regress tests (Sebastian Plesciuc) [#12639](https://github.com/nodejs/node/pull/12639)
* [[`8a59f6b038`](https://github.com/nodejs/node/commit/8a59f6b038)] - **test**: dynamic port in cluster worker wait close (Sebastian Plesciuc) [#12466](https://github.com/nodejs/node/pull/12466)
* [[`0383048b76`](https://github.com/nodejs/node/commit/0383048b76)] - **test**: fix coverity UNINIT_CTOR cctest warning (Ben Noordhuis) [#12387](https://github.com/nodejs/node/pull/12387)
* [[`f2467edc62`](https://github.com/nodejs/node/commit/f2467edc62)] - **test**: remove common.PORT from multiple tests (Tarun Batra) [#12451](https://github.com/nodejs/node/pull/12451)
* [[`a23aca4f12`](https://github.com/nodejs/node/commit/a23aca4f12)] - **test**: replace \[\].join() with ''.repeat() (Jackson Tian) [#12305](https://github.com/nodejs/node/pull/12305)
* [[`e512906aab`](https://github.com/nodejs/node/commit/e512906aab)] - **test**: run the addon tests last (Sebastian Van Sande) [#12062](https://github.com/nodejs/node/pull/12062)
* [[`abc2c82bf3`](https://github.com/nodejs/node/commit/abc2c82bf3)] - **test**: remove disabled test-dgram-send-error (Rich Trott) [#12330](https://github.com/nodejs/node/pull/12330)
* [[`d9866ce9c7`](https://github.com/nodejs/node/commit/d9866ce9c7)] - **test**: remove disabled tls_server.js (Rich Trott) [#12275](https://github.com/nodejs/node/pull/12275)
* [[`19d95519c7`](https://github.com/nodejs/node/commit/19d95519c7)] - **test**: add basic cctest for base64.h (Alexey Orlenko) [#12238](https://github.com/nodejs/node/pull/12238)
* [[`01073bc26a`](https://github.com/nodejs/node/commit/01073bc26a)] - **test**: add internal/socket_list tests (DavidCai) [#12109](https://github.com/nodejs/node/pull/12109)
* [[`a5fe098b85`](https://github.com/nodejs/node/commit/a5fe098b85)] - **test**: move common.PORT debug tests to sequential (Gibson Fahnestock) [#13592](https://github.com/nodejs/node/pull/13592)
* [[`0b8adedb88`](https://github.com/nodejs/node/commit/0b8adedb88)] - **test**: move test-debug-brk to sequential (Gibson Fahnestock) [#13580](https://github.com/nodejs/node/pull/13580)
* [[`97b6911ade`](https://github.com/nodejs/node/commit/97b6911ade)] - **test**: enable setuid/setgid test (Rich Trott) [#12403](https://github.com/nodejs/node/pull/12403)
* [[`4dff12849f`](https://github.com/nodejs/node/commit/4dff12849f)] - **test,doc**: document `crashOnUnhandledRejection()` (Anna Henningsen) [#12699](https://github.com/nodejs/node/pull/12699)
* [[`7e6a956a29`](https://github.com/nodejs/node/commit/7e6a956a29)] - **test,lib,doc**: use function declarations (Rich Trott) [#12711](https://github.com/nodejs/node/pull/12711)
* [[`910fa50e0e`](https://github.com/nodejs/node/commit/910fa50e0e)] - **tools**: fix error in custom ESLint rule (Rich Trott) [#13758](https://github.com/nodejs/node/pull/13758)
* [[`bb74da309c`](https://github.com/nodejs/node/commit/bb74da309c)] - **tools**: apply stricter indentation rules to tools (Rich Trott) [#13758](https://github.com/nodejs/node/pull/13758)
* [[`04934b04c3`](https://github.com/nodejs/node/commit/04934b04c3)] - **tools**: fix indentation in required-modules.js (Rich Trott) [#13758](https://github.com/nodejs/node/pull/13758)
* [[`550577749f`](https://github.com/nodejs/node/commit/550577749f)] - **tools**: remove no-useless-regex-char-class-escape (Rich Trott) [#10561](https://github.com/nodejs/node/pull/10561)
* [[`4ffe804c81`](https://github.com/nodejs/node/commit/4ffe804c81)] - **tools**: update ESLint to v4.0.0 (Rich Trott) [#13645](https://github.com/nodejs/node/pull/13645)
* [[`fb214bbcff`](https://github.com/nodejs/node/commit/fb214bbcff)] - **tools**: be explicit about including key-id (Myles Borins) [#13309](https://github.com/nodejs/node/pull/13309)
* [[`f831015928`](https://github.com/nodejs/node/commit/f831015928)] - **tools**: update certdata.txt (Ben Noordhuis) [#13279](https://github.com/nodejs/node/pull/13279)
* [[`bc2e73a05f`](https://github.com/nodejs/node/commit/bc2e73a05f)] - **tools**: update certdata.txt (Ben Noordhuis) [#12402](https://github.com/nodejs/node/pull/12402)
* [[`99da83b54d`](https://github.com/nodejs/node/commit/99da83b54d)] - **tools**: relax lint rule for regexps (Rich Trott) [#12807](https://github.com/nodejs/node/pull/12807)
* [[`3d564a4ed1`](https://github.com/nodejs/node/commit/3d564a4ed1)] - **tools**: require function declarations (Rich Trott) [#12711](https://github.com/nodejs/node/pull/12711)
* [[`6afa5fe348`](https://github.com/nodejs/node/commit/6afa5fe348)] - **tools**: add table parsing capability to the doctool (Roman Reiss) [#9532](https://github.com/nodejs/node/pull/9532)
* [[`9c67032b9a`](https://github.com/nodejs/node/commit/9c67032b9a)] - **tools**: enforce two arguments in assert.throws (Michaël Zasso) [#12270](https://github.com/nodejs/node/pull/12270)
* [[`95d13d59e4`](https://github.com/nodejs/node/commit/95d13d59e4)] - **tools**: remove unused code from test.py (Rich Trott) [#12806](https://github.com/nodejs/node/pull/12806)
* [[`70e9058a8e`](https://github.com/nodejs/node/commit/70e9058a8e)] - **tools**: ignore node_trace.*.log (Daijiro Wachi) [#12754](https://github.com/nodejs/node/pull/12754)
* [[`61427471af`](https://github.com/nodejs/node/commit/61427471af)] - **tools**: replace custom assert.fail lint rule (Rich Trott) [#12287](https://github.com/nodejs/node/pull/12287)
* [[`b2a08fb130`](https://github.com/nodejs/node/commit/b2a08fb130)] - **tools**: replace custom new-with-error rule (Rich Trott) [#12249](https://github.com/nodejs/node/pull/12249)
* [[`beb8485998`](https://github.com/nodejs/node/commit/beb8485998)] - **tools**: fix lint issue in doctool (Roman Reiss) [#11658](https://github.com/nodejs/node/pull/11658)
* [[`d9a8f80c0d`](https://github.com/nodejs/node/commit/d9a8f80c0d)] - **v8**: fix build errors with g++ 7 (Zuzana Svetlikova) [#12392](https://github.com/nodejs/node/pull/12392)
* [[`8b3aacc96a`](https://github.com/nodejs/node/commit/8b3aacc96a)] - **vm**: fix race condition with timeout param (Marcel Laverdet) [#13074](https://github.com/nodejs/node/pull/13074)
* [[`6e60c838c9`](https://github.com/nodejs/node/commit/6e60c838c9)] - **vm**: fix displayErrors in runIn.. functions (Marcel Laverdet) [#13074](https://github.com/nodejs/node/pull/13074)
* [[`55cbe24c60`](https://github.com/nodejs/node/commit/55cbe24c60)] - **zlib**: fix node crashing on invalid options (Alexey Orlenko) [#13098](https://github.com/nodejs/node/pull/13098)

<a id="6.11.1"></a>
## 2017-07-11, Version 6.11.1 'Boron' (LTS), @MylesBorins

This is a security release. All Node.js users should consult the security release summary at https://nodejs.org/en/blog/vulnerability/july-2017-security-releases/ for details on patched vulnerabilities.

### Notable Changes

* **build**:
  * Disable V8 snapshots - The hashseed embedded in the snapshot is currently the same for all runs of the binary. This opens node up to collision attacks which could result in a Denial of Service. We have temporarily disabled snapshots until a more robust solution is found (Ali Ijaz Sheikh)
* **deps**:
  * CVE-2017-1000381 - The c-ares function ares_parse_naptr_reply(), which is used for parsing NAPTR responses, could be triggered to read memory outside of the given input buffer if the passed in DNS response packet was crafted in a particular way. This patch checks that there is enough data for the required elements of an NAPTR record (2 int16, 3 bytes for string lengths) before processing a record. (David Drysdale)

### Commits

* [[`86c0eae524`](https://github.com/nodejs/node/commit/86c0eae524)] - **build**: disable V8 snapshots (Ali Ijaz Sheikh) [nodejs/node-private#84](https://github.com/nodejs/node-private/pull/84)
* [[`75bc33d16f`](https://github.com/nodejs/node/commit/75bc33d16f)] - **deps**: cherry-pick 9478908a49 from cares upstream (David Drysdale) [nodejs/node-private#88](https://github.com/nodejs/node-private/pull/88)
* [[`a92d4ca460`](https://github.com/nodejs/node/commit/a92d4ca460)] - **deps**: Debug code requires bigger buffer on s390 (Michael Dawson) [nodejs/node-private#93](https://github.com/nodejs/node-private/pull/93)
* [[`6e247b8a4e`](https://github.com/nodejs/node/commit/6e247b8a4e)] - **test**: verify hash seed uniqueness (Ali Ijaz Sheikh) [nodejs/node-private#84](https://github.com/nodejs/node-private/pull/84)

<a id="6.11.0"></a>
## 2017-06-06, Version 6.11.0 'Boron' (LTS), @MylesBorins

This LTS release comes with 126 commits. This includes 40 which are test related,
32 which are doc related, 12 which are build / tool related and 4 commits which are updates to dependencies.

### Notable Changes

* **build**:
  * support for building mips64el (nanxiongchao) [#10991](https://github.com/nodejs/node/pull/10991)
* **cluster**:
  * disconnect() now returns a reference to the disconnected worker. (Sean Villars) [#10019](https://github.com/nodejs/node/pull/10019)
* **crypto**:
  * ability to select cert store at runtime (Adam Majer) [#8334](https://github.com/nodejs/node/pull/8334)
  * Use system CAs instead of using bundled ones (Adam Majer) [#8334](https://github.com/nodejs/node/pull/8334)
  * The `Decipher` methods `setAuthTag()` and `setAAD` now return `this`. (Kirill Fomichev) [#9398](https://github.com/nodejs/node/pull/9398)
  * adding support for OPENSSL_CONF again (Sam Roberts) [#11006](https://github.com/nodejs/node/pull/11006)
  * make LazyTransform compabile with Streams1 (Matteo Collina) [#12380](https://github.com/nodejs/node/pull/12380)
* **deps**:
  * upgrade libuv to 1.11.0 (cjihrig) [#11094](https://github.com/nodejs/node/pull/11094)
  * upgrade libuv to 1.10.2 (cjihrig) [#10717](https://github.com/nodejs/node/pull/10717)
  * upgrade libuv to 1.10.1 (cjihrig) [#9647](https://github.com/nodejs/node/pull/9647)
  * upgrade libuv to 1.10.0 (cjihrig) [#9267](https://github.com/nodejs/node/pull/9267)
* **dns**:
  * Implemented `{ttl: true}` for `resolve4()` and `resolve6()`. (Ben Noordhuis) [#9296](https://github.com/nodejs/node/pull/9296)
* **process**:
  * add NODE_NO_WARNINGS environment variable (cjihrig) [#10842](https://github.com/nodejs/node/pull/10842)
* **readline**:
  * add option to stop duplicates in history (Danny Nemer) [#2982](https://github.com/nodejs/node/pull/2982)
* **src**:
  * support "--" after "-e" as end-of-options (John Barboza) [#10651](https://github.com/nodejs/node/pull/10651)
* **tls**:
  * new tls.TLSSocket() supports sec ctx options (Sam Roberts) [#11005](https://github.com/nodejs/node/pull/11005)
  * Allow obvious key/passphrase combinations. (Sam Roberts) [#10294](https://github.com/nodejs/node/pull/10294)

### Commits

* [[`d38364b062`](https://github.com/nodejs/node/commit/d38364b062)] - deps/v8: add missing #include "unicode/normlzr.h" (Bruno Pagani) [#13040](https://github.com/nodejs/node/pull/13040)
* [[`62a8f4774e`](https://github.com/nodejs/node/commit/62a8f4774e)] - **async_wrap**: close the destroy_ids_idle_handle_ (René Schünemann) [#10385](https://github.com/nodejs/node/pull/10385)
* [[`995423e790`](https://github.com/nodejs/node/commit/995423e790)] - **benchmark**: terminate child process on Windows (Rich Trott) [#12658](https://github.com/nodejs/node/pull/12658)
* [[`32fa37f3d6`](https://github.com/nodejs/node/commit/32fa37f3d6)] - **benchmark**: cleanup child_process IPC benchmark (Yuya Tanaka) [#10557](https://github.com/nodejs/node/pull/10557)
* [[`dd0b170b58`](https://github.com/nodejs/node/commit/dd0b170b58)] - **build**: fix case in lib names (Refael Ackermann) [#12522](https://github.com/nodejs/node/pull/12522)
* [[`bc64cf2b5e`](https://github.com/nodejs/node/commit/bc64cf2b5e)] - **build**: make linter targets silent (Sakthipriyan Vairamani (thefourtheye)) [#12423](https://github.com/nodejs/node/pull/12423)
* [[`a0973c3c1c`](https://github.com/nodejs/node/commit/a0973c3c1c)] - **build**: don't create directory for NDK toolchain (TheBeastOfCaerbannog) [#11916](https://github.com/nodejs/node/pull/11916)
* [[`0c318a6157`](https://github.com/nodejs/node/commit/0c318a6157)] - **(SEMVER-MINOR)** **build**: support for mips64el (nanxiongchao) [#10991](https://github.com/nodejs/node/pull/10991)
* [[`7c335f6b7c`](https://github.com/nodejs/node/commit/7c335f6b7c)] - **build**: run cpplint even if jslint failed (Ruslan Bekenev) [#12276](https://github.com/nodejs/node/pull/12276)
* [[`32d7981741`](https://github.com/nodejs/node/commit/32d7981741)] - **build**: use do_not_edit variable where possible (Ruslan Bekenev) [#12610](https://github.com/nodejs/node/pull/12610)
* [[`c13429ad8f`](https://github.com/nodejs/node/commit/c13429ad8f)] - **child_process**: optimize IPC for large data (Yuya Tanaka) [#10557](https://github.com/nodejs/node/pull/10557)
* [[`ae587f3578`](https://github.com/nodejs/node/commit/ae587f3578)] - **(SEMVER-MINOR)** **cluster**: return worker reference from disconnect() (Sean Villars) [#10019](https://github.com/nodejs/node/pull/10019)
* [[`e72749b319`](https://github.com/nodejs/node/commit/e72749b319)] - **(SEMVER-MINOR)** **crypto**: ability to select cert store at runtime (Adam Majer) [#8334](https://github.com/nodejs/node/pull/8334)
* [[`fd9bb56f9a`](https://github.com/nodejs/node/commit/fd9bb56f9a)] - **(SEMVER-MINOR)** **crypto**: Use system CAs instead of using bundled ones (Adam Majer) [#8334](https://github.com/nodejs/node/pull/8334)
* [[`bbfd2e309b`](https://github.com/nodejs/node/commit/bbfd2e309b)] - **(SEMVER-MINOR)** **crypto**: do not use pointers to std::vector (Adam Majer) [#8334](https://github.com/nodejs/node/pull/8334)
* [[`875674bb1c`](https://github.com/nodejs/node/commit/875674bb1c)] - **(SEMVER-MINOR)** **crypto**: return `this` in setAuthTag/setAAD (Kirill Fomichev) [#9398](https://github.com/nodejs/node/pull/9398)
* [[`f8da60fb21`](https://github.com/nodejs/node/commit/f8da60fb21)] - **(SEMVER-MINOR)** **crypto**: support OPENSSL_CONF again (Sam Roberts) [#11006](https://github.com/nodejs/node/pull/11006)
* [[`0a79b2da1b`](https://github.com/nodejs/node/commit/0a79b2da1b)] - **crypto**: make LazyTransform compabile with Streams1 (Matteo Collina) [#12380](https://github.com/nodejs/node/pull/12380)
* [[`7678da4c65`](https://github.com/nodejs/node/commit/7678da4c65)] - **crypto**: handle exceptions in hmac/hash.digest (Tobias Nießen) [#12164](https://github.com/nodejs/node/pull/12164)
* [[`e714243408`](https://github.com/nodejs/node/commit/e714243408)] - **deps**: upgrade libuv to 1.11.0 (cjihrig) [#11094](https://github.com/nodejs/node/pull/11094)
* [[`738d830f09`](https://github.com/nodejs/node/commit/738d830f09)] - **(SEMVER-MINOR)** **deps**: upgrade libuv to 1.10.2 (cjihrig) [#10717](https://github.com/nodejs/node/pull/10717)
* [[`c59370a8fd`](https://github.com/nodejs/node/commit/c59370a8fd)] - **(SEMVER-MINOR)** **deps**: upgrade libuv to 1.10.1 (cjihrig) [#9647](https://github.com/nodejs/node/pull/9647)
* [[`3585ffa247`](https://github.com/nodejs/node/commit/3585ffa247)] - **(SEMVER-MINOR)** **deps**: upgrade libuv to 1.10.0 (cjihrig) [#9267](https://github.com/nodejs/node/pull/9267)
* [[`da70161308`](https://github.com/nodejs/node/commit/da70161308)] - **(SEMVER-MINOR)** **dns**: implement {ttl: true} for dns.resolve6() (Ben Noordhuis) [#9296](https://github.com/nodejs/node/pull/9296)
* [[`0bc14b6d33`](https://github.com/nodejs/node/commit/0bc14b6d33)] - **(SEMVER-MINOR)** **dns**: implement {ttl: true} for dns.resolve4() (Ben Noordhuis) [#9296](https://github.com/nodejs/node/pull/9296)
* [[`699e274693`](https://github.com/nodejs/node/commit/699e274693)] - **doc**: add link on logo to README (Roman Reiss) [#12307](https://github.com/nodejs/node/pull/12307)
* [[`5ce108955d`](https://github.com/nodejs/node/commit/5ce108955d)] - **doc**: fix an unclear wording in readline.md (Vse Mozhet Byt) [#12605](https://github.com/nodejs/node/pull/12605)
* [[`18c56df81e`](https://github.com/nodejs/node/commit/18c56df81e)] - **doc**: fix typo in doc/api/process.md (morrme) [#12612](https://github.com/nodejs/node/pull/12612)
* [[`2b6e58852f`](https://github.com/nodejs/node/commit/2b6e58852f)] - **doc**: make commit guidelines easier to reference (Benjamin Fleischer) [#11732](https://github.com/nodejs/node/pull/11732)
* [[`928382d957`](https://github.com/nodejs/node/commit/928382d957)] - **doc**: add suggestion to use --3way (Michael Dawson) [#12510](https://github.com/nodejs/node/pull/12510)
* [[`278e8cc65f`](https://github.com/nodejs/node/commit/278e8cc65f)] - **doc**: update link to Code of Conduct (Alex Autem) [#12552](https://github.com/nodejs/node/pull/12552)
* [[`3d526727f9`](https://github.com/nodejs/node/commit/3d526727f9)] - **doc**: add lucamaraschi to collaborators (Luca Maraschi) [#12538](https://github.com/nodejs/node/pull/12538)
* [[`e1098a4e9f`](https://github.com/nodejs/node/commit/e1098a4e9f)] - **doc**: unify spaces in a querystring.md code example (Vse Mozhet Byt) [#12465](https://github.com/nodejs/node/pull/12465)
* [[`9881da1585`](https://github.com/nodejs/node/commit/9881da1585)] - **doc**: run tests before landing changes (Rich Trott) [#12416](https://github.com/nodejs/node/pull/12416)
* [[`3556c177a3`](https://github.com/nodejs/node/commit/3556c177a3)] - **doc**: avoid colloquialism (Rich Trott) [#12417](https://github.com/nodejs/node/pull/12417)
* [[`5fa417086a`](https://github.com/nodejs/node/commit/5fa417086a)] - **doc**: fix encoding string in buffer example (MapleUncle) [#12482](https://github.com/nodejs/node/pull/12482)
* [[`bc401697f0`](https://github.com/nodejs/node/commit/bc401697f0)] - **doc**: correct git fix whitespace command (Mateusz Konieczny) [#12445](https://github.com/nodejs/node/pull/12445)
* [[`26fcc7a4df`](https://github.com/nodejs/node/commit/26fcc7a4df)] - **doc**: s/origin/upstream/ collaborator guide (Anna Henningsen) [#12436](https://github.com/nodejs/node/pull/12436)
* [[`e3352bbceb`](https://github.com/nodejs/node/commit/e3352bbceb)] - **doc**: update Mac OS X references in releases.md (JR McEntee) [#12106](https://github.com/nodejs/node/pull/12106)
* [[`32a6d87a21`](https://github.com/nodejs/node/commit/32a6d87a21)] - **doc**: correct markdown file line lengths (JR McEntee) [#12106](https://github.com/nodejs/node/pull/12106)
* [[`db4aef4ac6`](https://github.com/nodejs/node/commit/db4aef4ac6)] - **doc**: change Mac OS X to macOS (JR McEntee) [#12106](https://github.com/nodejs/node/pull/12106)
* [[`40f292cacd`](https://github.com/nodejs/node/commit/40f292cacd)] - **doc**: add missing ) in CONTRIBUTING.md (Mateusz Konieczny) [#12444](https://github.com/nodejs/node/pull/12444)
* [[`656c30e11d`](https://github.com/nodejs/node/commit/656c30e11d)] - **doc**: add guide for backporting prs (Evan Lucas) [#11099](https://github.com/nodejs/node/pull/11099)
* [[`1c1269dfc3`](https://github.com/nodejs/node/commit/1c1269dfc3)] - **doc**: update link for landing PRs (Rich Trott) [#12415](https://github.com/nodejs/node/pull/12415)
* [[`81b53503a7`](https://github.com/nodejs/node/commit/81b53503a7)] - **doc**: add DavidCai1993 to collaborators (David Cai) [#12435](https://github.com/nodejs/node/pull/12435)
* [[`c6f3ebd774`](https://github.com/nodejs/node/commit/c6f3ebd774)] - **doc**: fix typo in streams.md (John Paul Bamberg) [#12428](https://github.com/nodejs/node/pull/12428)
* [[`4a18e51c6a`](https://github.com/nodejs/node/commit/4a18e51c6a)] - **doc**: add jkrems to collaborators (Jan Krems) [#12427](https://github.com/nodejs/node/pull/12427)
* [[`a6e06738ef`](https://github.com/nodejs/node/commit/a6e06738ef)] - **doc**: path functions ignore trailing slashes (Tobias Nießen) [#12181](https://github.com/nodejs/node/pull/12181)
* [[`929ca307d2`](https://github.com/nodejs/node/commit/929ca307d2)] - **doc**: add info about serializable types (Shubheksha Jalan) [#12313](https://github.com/nodejs/node/pull/12313)
* [[`945dcde45b`](https://github.com/nodejs/node/commit/945dcde45b)] - **doc**: fix formatting in onboarding-extras (Rich Trott) [#12350](https://github.com/nodejs/node/pull/12350)
* [[`3c1bd05a24`](https://github.com/nodejs/node/commit/3c1bd05a24)] - **doc**: response.write ignores body in some cases (Ruslan Bekenev) [#12314](https://github.com/nodejs/node/pull/12314)
* [[`d2afd7c5f7`](https://github.com/nodejs/node/commit/d2afd7c5f7)] - **doc**: add AnnaMag to collaborators (AnnaMag) [#12414](https://github.com/nodejs/node/pull/12414)
* [[`dac66d5645`](https://github.com/nodejs/node/commit/dac66d5645)] - **doc**: limit lines to 80 cols in internal README (Evan Lucas) [#12358](https://github.com/nodejs/node/pull/12358)
* [[`3ae8d00dd1`](https://github.com/nodejs/node/commit/3ae8d00dd1)] - **doc**: add single arg scenario for util.format (Tarun Batra) [#12374](https://github.com/nodejs/node/pull/12374)
* [[`43d3c009a5`](https://github.com/nodejs/node/commit/43d3c009a5)] - **doc**: fix formatting of TOC (Refael Ackermann) [#12731](https://github.com/nodejs/node/pull/12731)
* [[`9fc695c574`](https://github.com/nodejs/node/commit/9fc695c574)] - **doc**: fixup the collaborators list (Alexey Orlenko) [#12750](https://github.com/nodejs/node/pull/12750)
* [[`ad29e295b7`](https://github.com/nodejs/node/commit/ad29e295b7)] - **doc**: gcc version is at least 4.8.5 in BUILDING.md (detailyang) [#11840](https://github.com/nodejs/node/pull/11840)
* [[`f2230cc0b5`](https://github.com/nodejs/node/commit/f2230cc0b5)] - **eslint**: remove dead and unused symlink (Sam Roberts)
* [[`ae1f6fd03a`](https://github.com/nodejs/node/commit/ae1f6fd03a)] - **fs**: re-enable watch facility in AIX (Gireesh Punathil) [#10085](https://github.com/nodejs/node/pull/10085)
* [[`6e6e63a341`](https://github.com/nodejs/node/commit/6e6e63a341)] - **lib**: fix typo in comments in module.js (WORMSS) [#12528](https://github.com/nodejs/node/pull/12528)
* [[`f20ebf29f6`](https://github.com/nodejs/node/commit/f20ebf29f6)] - **meta**: update authors list (Aashil Patel) [#11533](https://github.com/nodejs/node/pull/11533)
* [[`b7ca74866b`](https://github.com/nodejs/node/commit/b7ca74866b)] - **meta**: move the Code of Conduct to TSC repository (James M Snell) [#12147](https://github.com/nodejs/node/pull/12147)
* [[`1bd07acbd1`](https://github.com/nodejs/node/commit/1bd07acbd1)] - **net**: refactor onSlaveClose in Server.close (Claudio Rodriguez) [#12334](https://github.com/nodejs/node/pull/12334)
* [[`637d9e3544`](https://github.com/nodejs/node/commit/637d9e3544)] - **(SEMVER-MINOR)** **process**: add NODE_NO_WARNINGS environment variable (cjihrig) [#10842](https://github.com/nodejs/node/pull/10842)
* [[`202f00717b`](https://github.com/nodejs/node/commit/202f00717b)] - **process**: maintain constructor descriptor (Bryan English) [#9306](https://github.com/nodejs/node/pull/9306)
* [[`e9f33e392d`](https://github.com/nodejs/node/commit/e9f33e392d)] - **readline**: rename `deDupeHistory` option (Danny Nemer) [#11950](https://github.com/nodejs/node/pull/11950)
* [[`8bd6ab7870`](https://github.com/nodejs/node/commit/8bd6ab7870)] - **(SEMVER-MINOR)** **readline**: add option to stop duplicates in history (Danny Nemer) [#2982](https://github.com/nodejs/node/pull/2982)
* [[`827411c1c0`](https://github.com/nodejs/node/commit/827411c1c0)] - ***Revert*** "**repl**: disable Ctrl+C support on win32 for now" (Anna Henningsen) [#8645](https://github.com/nodejs/node/pull/8645)
* [[`ce795ecf2b`](https://github.com/nodejs/node/commit/ce795ecf2b)] - **src**: remove invalid comment (cjihrig) [#12645](https://github.com/nodejs/node/pull/12645)
* [[`b296bd5ccc`](https://github.com/nodejs/node/commit/b296bd5ccc)] - **src**: remove TODO about uv errno removal (Daniel Bevenius) [#12536](https://github.com/nodejs/node/pull/12536)
* [[`aec7ae2e67`](https://github.com/nodejs/node/commit/aec7ae2e67)] - **(SEMVER-MINOR)** **src**: add SafeGetenv() to internal API (Sam Roberts) [#11006](https://github.com/nodejs/node/pull/11006)
* [[`f2e97f89f0`](https://github.com/nodejs/node/commit/f2e97f89f0)] - **src**: make copies of startup environment variables (Ben Noordhuis) [#11051](https://github.com/nodejs/node/pull/11051)
* [[`c408a3bd63`](https://github.com/nodejs/node/commit/c408a3bd63)] - **(SEMVER-MINOR)** **src**: support "--" after "-e" as end-of-options (John Barboza) [#10651](https://github.com/nodejs/node/pull/10651)
* [[`f1ea36733d`](https://github.com/nodejs/node/commit/f1ea36733d)] - **src**: use std::list for at_exit_functions (Daniel Bevenius) [#12255](https://github.com/nodejs/node/pull/12255)
* [[`331681a3f5`](https://github.com/nodejs/node/commit/331681a3f5)] - **src**: return early if nextTickQueue is empty (Trevor Norris) [#10274](https://github.com/nodejs/node/pull/10274)
* [[`b09f73813e`](https://github.com/nodejs/node/commit/b09f73813e)] - **test**: cleanup test-fs-watch.js (RobotMermaid) [#12595](https://github.com/nodejs/node/pull/12595)
* [[`a1de1abcdd`](https://github.com/nodejs/node/commit/a1de1abcdd)] - **test**: remove flaky designation for test on AIX (Rich Trott) [#12564](https://github.com/nodejs/node/pull/12564)
* [[`3cce18104d`](https://github.com/nodejs/node/commit/3cce18104d)] - **test**: add mustCall in test-timers-clearImmediate (Zahidul Islam) [#12598](https://github.com/nodejs/node/pull/12598)
* [[`33821e42b5`](https://github.com/nodejs/node/commit/33821e42b5)] - **test**: use block scoped variable names (Neehar Venugopal) [#12544](https://github.com/nodejs/node/pull/12544)
* [[`12287f1299`](https://github.com/nodejs/node/commit/12287f1299)] - **test**: dynamic port in cluster eaddrinuse (Sebastian Plesciuc) [#12547](https://github.com/nodejs/node/pull/12547)
* [[`53d5aacfe4`](https://github.com/nodejs/node/commit/53d5aacfe4)] - **test**: dynamic port in cluster ipc throw (Sebastian Plesciuc) [#12571](https://github.com/nodejs/node/pull/12571)
* [[`0bd0d52af6`](https://github.com/nodejs/node/commit/0bd0d52af6)] - **test**: replace assertion error check with regex (thelady) [#12603](https://github.com/nodejs/node/pull/12603)
* [[`8044b8307c`](https://github.com/nodejs/node/commit/8044b8307c)] - **test**: refactored context type err message to regex (Muhsin Abdul-Musawwir) [#12596](https://github.com/nodejs/node/pull/12596)
* [[`32f905a85d`](https://github.com/nodejs/node/commit/32f905a85d)] - **test**: improve test-process-chdir (vperezma) [#12589](https://github.com/nodejs/node/pull/12589)
* [[`51794dd7b0`](https://github.com/nodejs/node/commit/51794dd7b0)] - **test**: dynamic port in parallel cluster tests (Sebastian Plesciuc) [#12584](https://github.com/nodejs/node/pull/12584)
* [[`daf6535475`](https://github.com/nodejs/node/commit/daf6535475)] - **test**: dynamic port in cluster worker dgram (Sebastian Plesciuc) [#12487](https://github.com/nodejs/node/pull/12487)
* [[`b53d172576`](https://github.com/nodejs/node/commit/b53d172576)] - **test**: move test-debugger-repeat-last to sequential (kumarrishav) [#12470](https://github.com/nodejs/node/pull/12470)
* [[`32425be109`](https://github.com/nodejs/node/commit/32425be109)] - **test**: use duplex streams in duplex stream test (cjihrig) [#12514](https://github.com/nodejs/node/pull/12514)
* [[`830949c8b0`](https://github.com/nodejs/node/commit/830949c8b0)] - **test**: use JSON.stringify to trigger stack overflow (Yang Guo) [#12481](https://github.com/nodejs/node/pull/12481)
* [[`50bfb28960`](https://github.com/nodejs/node/commit/50bfb28960)] - **test**: console.log removed from test-net-localport (Faiz Halde) [#12483](https://github.com/nodejs/node/pull/12483)
* [[`768431cac8`](https://github.com/nodejs/node/commit/768431cac8)] - **test**: dynamic port in cluster worker disconnect (Sebastian Plesciuc) [#12457](https://github.com/nodejs/node/pull/12457)
* [[`b1d26d8b55`](https://github.com/nodejs/node/commit/b1d26d8b55)] - **test**: remove uses of common.PORT in test-tls-client tests (Ahmed Taj elsir) [#12461](https://github.com/nodejs/node/pull/12461)
* [[`ce3b544360`](https://github.com/nodejs/node/commit/ce3b544360)] - **test**: dynamic port in cluster worker send (Sebastian Plesciuc) [#12472](https://github.com/nodejs/node/pull/12472)
* [[`a755ef0634`](https://github.com/nodejs/node/commit/a755ef0634)] - **test**: increase coverage for buffer.js (Rich Trott) [#12476](https://github.com/nodejs/node/pull/12476)
* [[`a4b092c8f3`](https://github.com/nodejs/node/commit/a4b092c8f3)] - **test**: complete coverage of lib/child_process.js (cjihrig) [#12367](https://github.com/nodejs/node/pull/12367)
* [[`4786ad7024`](https://github.com/nodejs/node/commit/4786ad7024)] - **test**: buffer should always be stringified (Luca Maraschi) [#12355](https://github.com/nodejs/node/pull/12355)
* [[`04ec97e39a`](https://github.com/nodejs/node/commit/04ec97e39a)] - **test**: use dynamic port in test-cluster-bind-twice (Rich Trott) [#12418](https://github.com/nodejs/node/pull/12418)
* [[`3244ae36da`](https://github.com/nodejs/node/commit/3244ae36da)] - **test**: remove common.PORT from test-cluster*.js (Tarun Batra) [#12441](https://github.com/nodejs/node/pull/12441)
* [[`384fa17ffa`](https://github.com/nodejs/node/commit/384fa17ffa)] - **test**: use dynamic port in 3 test-cluster-worker tests (Sebastian Plesciuc) [#12443](https://github.com/nodejs/node/pull/12443)
* [[`d54d0c4cdc`](https://github.com/nodejs/node/commit/d54d0c4cdc)] - **test**: add --use-bundled-ca to tls-cnnic-whitelist (Daniel Bevenius) [#12394](https://github.com/nodejs/node/pull/12394)
* [[`0caca45434`](https://github.com/nodejs/node/commit/0caca45434)] - **test**: add crypto check to crypto-lazy-transform (Daniel Bevenius) [#12424](https://github.com/nodejs/node/pull/12424)
* [[`861fa65bdf`](https://github.com/nodejs/node/commit/861fa65bdf)] - **(SEMVER-MINOR)** **test**: make tls-socket-default-options tests run (Sam Roberts) [#11005](https://github.com/nodejs/node/pull/11005)
* [[`7d47b02794`](https://github.com/nodejs/node/commit/7d47b02794)] - **test**: remove common.PORT from test-cluster-basic (Rich Trott) [#12377](https://github.com/nodejs/node/pull/12377)
* [[`9e89edff87`](https://github.com/nodejs/node/commit/9e89edff87)] - **test**: add hasCrypto check to test-debug-usage (Daniel Bevenius) [#12357](https://github.com/nodejs/node/pull/12357)
* [[`afac3161a8`](https://github.com/nodejs/node/commit/afac3161a8)] - **test**: improve punycode coverage to check surrogate pair (Nao YONASHIRO) [#12354](https://github.com/nodejs/node/pull/12354)
* [[`a714449db3`](https://github.com/nodejs/node/commit/a714449db3)] - **test**: cleanup test-fs-watch.js (RobotMermaid) [#12595](https://github.com/nodejs/node/pull/12595)
* [[`89e76e8e4d`](https://github.com/nodejs/node/commit/89e76e8e4d)] - **test**: improved type checking with regex (coreybeaumont) [#12591](https://github.com/nodejs/node/pull/12591)
* [[`c304414007`](https://github.com/nodejs/node/commit/c304414007)] - **test**: improve test-tcp-wrap-listen (alohaglenn) [#12599](https://github.com/nodejs/node/pull/12599)
* [[`bea0a6e557`](https://github.com/nodejs/node/commit/bea0a6e557)] - **test**: add common.mustNotCall() (cjihrig) [#11152](https://github.com/nodejs/node/pull/11152)
* [[`cb63808832`](https://github.com/nodejs/node/commit/cb63808832)] - **test**: improve test-process-kill-pid (alohaglenn) [#12588](https://github.com/nodejs/node/pull/12588)
* [[`ac825fc8bc`](https://github.com/nodejs/node/commit/ac825fc8bc)] - **test**: use common.js to check platform (Ruslan Bekenev) [#12629](https://github.com/nodejs/node/pull/12629)
* [[`64f9adc787`](https://github.com/nodejs/node/commit/64f9adc787)] - **test**: cleanup test-util-inherits.js (RobotMermaid) [#12602](https://github.com/nodejs/node/pull/12602)
* [[`c1e4b2f043`](https://github.com/nodejs/node/commit/c1e4b2f043)] - **test**: move test to sequential for reliability (Rich Trott) [#12704](https://github.com/nodejs/node/pull/12704)
* [[`cd1a7ea5e5`](https://github.com/nodejs/node/commit/cd1a7ea5e5)] - **test**: add regex to text-crypto-random (Nate) [#10020](https://github.com/nodejs/node/pull/10020)
* [[`15226f597a`](https://github.com/nodejs/node/commit/15226f597a)] - **test**: add hasCrypto check to tls-socket-close (Daniel Bevenius) [#11911](https://github.com/nodejs/node/pull/11911)
* [[`7cad5613c7`](https://github.com/nodejs/node/commit/7cad5613c7)] - **(SEMVER-MINOR)** **tls**: new tls.TLSSocket() supports sec ctx options (Sam Roberts) [#11005](https://github.com/nodejs/node/pull/11005)
* [[`df9d8ee6cb`](https://github.com/nodejs/node/commit/df9d8ee6cb)] - **(SEMVER-MINOR)** **tls**: allow obvious key/passphrase combinations (Sam Roberts) [#10294](https://github.com/nodejs/node/pull/10294)
* [[`a679e06c29`](https://github.com/nodejs/node/commit/a679e06c29)] - **tools**: use no-useless-concat ESLint rule (Vse Mozhet Byt) [#12613](https://github.com/nodejs/node/pull/12613)
* [[`b920c5d44b`](https://github.com/nodejs/node/commit/b920c5d44b)] - **tools**: enable no-useless-return eslint rule (cjihrig) [#12577](https://github.com/nodejs/node/pull/12577)
* [[`fd126b5866`](https://github.com/nodejs/node/commit/fd126b5866)] - **tools**: add `root: true` in main .eslintrc.yaml (Vse Mozhet Byt) [#12570](https://github.com/nodejs/node/pull/12570)
* [[`d63befac2a`](https://github.com/nodejs/node/commit/d63befac2a)] - **tools**: Add no useless regex char class rule (Prince J Wesley) [#9591](https://github.com/nodejs/node/pull/9591)
* [[`87534d6c25`](https://github.com/nodejs/node/commit/87534d6c25)] - **tools**: replace custom ESLint timers rule (Rich Trott) [#12504](https://github.com/nodejs/node/pull/12504)
* [[`736a736ed5`](https://github.com/nodejs/node/commit/736a736ed5)] - **tools**: update ESLint to 3.19.0 (Rich Trott) [#12162](https://github.com/nodejs/node/pull/12162)
* [[`00b6646f93`](https://github.com/nodejs/node/commit/00b6646f93)] - **url**: improve descriptiveness of identifier (Rich Trott) [#12579](https://github.com/nodejs/node/pull/12579)
* [[`a0f9d5964e`](https://github.com/nodejs/node/commit/a0f9d5964e)] - **v8**: fix stack overflow in recursive method (Ben Noordhuis) [#12460](https://github.com/nodejs/node/pull/12460)
* [[`2b3381aec6`](https://github.com/nodejs/node/commit/2b3381aec6)] - ***Revert*** "**v8**: drop v8::FunctionCallbackInfo\<T\>::NewTarget()" (Ben Noordhuis)

<a id="6.10.3"></a>
## 2017-05-02, Version 6.10.3 'Boron' (LTS), @MylesBorins

### Notable Changes

* **module**:
  * The [module loading global fallback](https://nodejs.org/dist/latest-v4.x/docs/api/modules.html#modules_loading_from_the_global_folders) to the Node executable's directory now works correctly on Windows.  (Richard Lau) [#9283](https://github.com/nodejs/node/pull/9283)
* **src**:
  * fix base64 decoding in rare edgecase (Nikolai Vavilov) [#11995](https://github.com/nodejs/node/pull/11995)
* **tls**:
  * fix rare segmentation faults when using TLS
    * (Trevor Norris) [#11947](https://github.com/nodejs/node/pull/11947)
    * (Ben Noordhuis) [#11898](https://github.com/nodejs/node/pull/11898)
    * (jBarz) [#11776](https://github.com/nodejs/node/pull/11776)

### Commits

* [[`858bbaa4aa`](https://github.com/nodejs/node/commit/858bbaa4aa)] - Partial revert "tls: keep track of stream that is closed" (Trevor Norris) [#11947](https://github.com/nodejs/node/pull/11947)
* [[`12c0ce749f`](https://github.com/nodejs/node/commit/12c0ce749f)] - **assert, tools**: enforce strict (not)equal in eslint (Gibson Fahnestock) [#10698](https://github.com/nodejs/node/pull/10698)
* [[`abbf6e38f1`](https://github.com/nodejs/node/commit/abbf6e38f1)] - **benchmark**: fix fs\bench-realpathSync.js (Vse Mozhet Byt) [#11904](https://github.com/nodejs/node/pull/11904)
* [[`53d7a89497`](https://github.com/nodejs/node/commit/53d7a89497)] - **buffer**: remove unneeded eslint-disable comment (Rich Trott) [#11906](https://github.com/nodejs/node/pull/11906)
* [[`5d74c9e749`](https://github.com/nodejs/node/commit/5d74c9e749)] - **buffer**: refactor Buffer.prototype.inspect() (Rich Trott) [#11600](https://github.com/nodejs/node/pull/11600)
* [[`e7e83f6f10`](https://github.com/nodejs/node/commit/e7e83f6f10)] - **build**: use $(RM) in Makefile for consistency (Gibson Fahnestock) [#12157](https://github.com/nodejs/node/pull/12157)
* [[`986ef6fffa`](https://github.com/nodejs/node/commit/986ef6fffa)] - **build**: add checks for openssl configure options (Daniel Bevenius) [#12175](https://github.com/nodejs/node/pull/12175)
* [[`c2c467e242`](https://github.com/nodejs/node/commit/c2c467e242)] - **build**: make configure print statements consistent (Daniel Bevenius) [#12176](https://github.com/nodejs/node/pull/12176)
* [[`2c2a6649c1`](https://github.com/nodejs/node/commit/2c2a6649c1)] - **build**: add node_use_openssl check to install.py (Daniel Bevenius) [#11766](https://github.com/nodejs/node/pull/11766)
* [[`a899b0b92b`](https://github.com/nodejs/node/commit/a899b0b92b)] - **build**: fix llvm version detection in freebsd-10 (Shigeki Ohtsu) [#11668](https://github.com/nodejs/node/pull/11668)
* [[`ba23506419`](https://github.com/nodejs/node/commit/ba23506419)] - **build**: --without-ssl implies --without-inspector (Ben Noordhuis) [#12200](https://github.com/nodejs/node/pull/12200)
* [[`cd78a2bd07`](https://github.com/nodejs/node/commit/cd78a2bd07)] - **deps**: backport 75f2d65f00 from upstream V8 (Yang Guo) [#12535](https://github.com/nodejs/node/pull/12535)
* [[`62e047e040`](https://github.com/nodejs/node/commit/62e047e040)] - **deps**: backport ec1ffe3 from upstream V8 (Daniel Bevenius) [#12061](https://github.com/nodejs/node/pull/12061)
* [[`8cdddcdb68`](https://github.com/nodejs/node/commit/8cdddcdb68)] - **deps**: cherry-pick ca0f9573 from V8 upstream (Ali Ijaz Sheikh) [#11940](https://github.com/nodejs/node/pull/11940)
* [[`d15188f6e2`](https://github.com/nodejs/node/commit/d15188f6e2)] - **doc**: modernize and fix code examples in modules.md (Vse Mozhet Byt) [#12224](https://github.com/nodejs/node/pull/12224)
* [[`03f9388eb7`](https://github.com/nodejs/node/commit/03f9388eb7)] - **doc**: clarify out-of-bounds behavior of buf\[index\] (Nikolai Vavilov) [#11286](https://github.com/nodejs/node/pull/11286)
* [[`eddfd5230e`](https://github.com/nodejs/node/commit/eddfd5230e)] - **doc**: add refack to collaborators (Refael Ackermann) [#12277](https://github.com/nodejs/node/pull/12277)
* [[`22af92ac2e`](https://github.com/nodejs/node/commit/22af92ac2e)] - **doc**: add richardlau to collaborators (Richard Lau) [#12020](https://github.com/nodejs/node/pull/12020)
* [[`8d1a474ec2`](https://github.com/nodejs/node/commit/8d1a474ec2)] - **doc**: fix confusing example in process.md (Vse Mozhet Byt) [#12282](https://github.com/nodejs/node/pull/12282)
* [[`88f402c4c1`](https://github.com/nodejs/node/commit/88f402c4c1)] - **doc**: update information on test/known_issues (Jan Krems) [#12262](https://github.com/nodejs/node/pull/12262)
* [[`34f9dfde1f`](https://github.com/nodejs/node/commit/34f9dfde1f)] - **doc**: fix confusing reference in net.md (Vse Mozhet Byt) [#12247](https://github.com/nodejs/node/pull/12247)
* [[`7e67176d79`](https://github.com/nodejs/node/commit/7e67176d79)] - **doc**: document the performance team (Gibson Fahnestock) [#12213](https://github.com/nodejs/node/pull/12213)
* [[`3b38e7109f`](https://github.com/nodejs/node/commit/3b38e7109f)] - **doc**: add aqrln to collaborators (Alexey Orlenko) [#12273](https://github.com/nodejs/node/pull/12273)
* [[`811ccdf06a`](https://github.com/nodejs/node/commit/811ccdf06a)] - **doc**: modernize and fix code examples in https.md (Vse Mozhet Byt) [#12171](https://github.com/nodejs/node/pull/12171)
* [[`c0d9b1c02b`](https://github.com/nodejs/node/commit/c0d9b1c02b)] - **doc**: fix string interpolation in Stream 'finish' (Vinay Hiremath) [#12221](https://github.com/nodejs/node/pull/12221)
* [[`f4dd304c32`](https://github.com/nodejs/node/commit/f4dd304c32)] - **doc**: add table of contents to README.md (Jason Marsh) [#11635](https://github.com/nodejs/node/pull/11635)
* [[`d007427c63`](https://github.com/nodejs/node/commit/d007427c63)] - **doc**: add logo to README (Roman Reiss) [#12148](https://github.com/nodejs/node/pull/12148)
* [[`9dda771c1f`](https://github.com/nodejs/node/commit/9dda771c1f)] - **doc**: update and modernize examples in fs.ms (Vse Mozhet Byt) [#12035](https://github.com/nodejs/node/pull/12035)
* [[`81f561bed8`](https://github.com/nodejs/node/commit/81f561bed8)] - **doc**: stdout/err/in are all Duplex streams (Sebastian Van Sande) [#11194](https://github.com/nodejs/node/pull/11194)
* [[`97035136d6`](https://github.com/nodejs/node/commit/97035136d6)] - **doc**: fix process.stdout fd number (Fumiya KARASAWA) [#12055](https://github.com/nodejs/node/pull/12055)
* [[`aab9526d69`](https://github.com/nodejs/node/commit/aab9526d69)] - **doc**: update collaborator email address (Rich Trott) [#11996](https://github.com/nodejs/node/pull/11996)
* [[`6885dccd3d`](https://github.com/nodejs/node/commit/6885dccd3d)] - **doc**: correct info in child_process.md (Vse Mozhet Byt) [#11949](https://github.com/nodejs/node/pull/11949)
* [[`fb0a2e426d`](https://github.com/nodejs/node/commit/fb0a2e426d)] - **doc**: remove superfluous sample assert code (Rich Trott) [#11933](https://github.com/nodejs/node/pull/11933)
* [[`3ad0a1430d`](https://github.com/nodejs/node/commit/3ad0a1430d)] - **doc**: require uses fs root for '/' prefix (Bradley Farias) [#11897](https://github.com/nodejs/node/pull/11897)
* [[`d149844b49`](https://github.com/nodejs/node/commit/d149844b49)] - **doc**: fix gitter badge in README (Roman Reiss) [#11944](https://github.com/nodejs/node/pull/11944)
* [[`4a97bc7a39`](https://github.com/nodejs/node/commit/4a97bc7a39)] - **doc**: add missing word in stream.md (Jyotman Singh) [#11914](https://github.com/nodejs/node/pull/11914)
* [[`f53c48e173`](https://github.com/nodejs/node/commit/f53c48e173)] - **doc**: add vsemozhetbyt to collaborators (Vse Mozhet Byt) [#11932](https://github.com/nodejs/node/pull/11932)
* [[`c10a4a2a7a`](https://github.com/nodejs/node/commit/c10a4a2a7a)] - **doc**: add note that vm module is not a security mechanism (Ruslan Bekenev) [#11557](https://github.com/nodejs/node/pull/11557)
* [[`b8e3a5f109`](https://github.com/nodejs/node/commit/b8e3a5f109)] - **doc**: fix a typo in api/process.md (Gaara) [#11780](https://github.com/nodejs/node/pull/11780)
* [[`463f29413b`](https://github.com/nodejs/node/commit/463f29413b)] - **doc**: correct comment error in stream.md (Alexander) [#11804](https://github.com/nodejs/node/pull/11804)
* [[`8a521fe0dc`](https://github.com/nodejs/node/commit/8a521fe0dc)] - **doc**: var -\> let / const in events.md (Vse Mozhet Byt) [#11810](https://github.com/nodejs/node/pull/11810)
* [[`331c0a8a26`](https://github.com/nodejs/node/commit/331c0a8a26)] - **doc**: console.log() -\> console.error() in events.md (Vse Mozhet Byt) [#11810](https://github.com/nodejs/node/pull/11810)
* [[`82d2f13680`](https://github.com/nodejs/node/commit/82d2f13680)] - **doc**: update to current V8 versions (Franziska Hinkelmann) [#11787](https://github.com/nodejs/node/pull/11787)
* [[`be537d0062`](https://github.com/nodejs/node/commit/be537d0062)] - **doc**: package main can be directory with an index (Bradley Farias) [#11581](https://github.com/nodejs/node/pull/11581)
* [[`0e13887421`](https://github.com/nodejs/node/commit/0e13887421)] - **doc**: reduce font size on smaller screens (Gibson Fahnestock) [#11695](https://github.com/nodejs/node/pull/11695)
* [[`0acebb985f`](https://github.com/nodejs/node/commit/0acebb985f)] - **doc**: fix occurences of "the the" (Jeroen Mandersloot) [#11711](https://github.com/nodejs/node/pull/11711)
* [[`8de856b191`](https://github.com/nodejs/node/commit/8de856b191)] - **doc**: fix process links to console.log/error (Sam Roberts) [#11718](https://github.com/nodejs/node/pull/11718)
* [[`12760339dc`](https://github.com/nodejs/node/commit/12760339dc)] - **doc**: add Franziska Hinkelmann to the CTC (Rod Vagg) [#11488](https://github.com/nodejs/node/pull/11488)
* [[`e8f0dba3af`](https://github.com/nodejs/node/commit/e8f0dba3af)] - **doc**: fixed readable.isPaused() version annotation (Laurent Fortin) [#11677](https://github.com/nodejs/node/pull/11677)
* [[`40b27ba8bb`](https://github.com/nodejs/node/commit/40b27ba8bb)] - **doc**: remove Locked from stability index (Rich Trott) [#11661](https://github.com/nodejs/node/pull/11661)
* [[`70a6a0a918`](https://github.com/nodejs/node/commit/70a6a0a918)] - **doc**: unlock module (Rich Trott) [#11661](https://github.com/nodejs/node/pull/11661)
* [[`e02d724273`](https://github.com/nodejs/node/commit/e02d724273)] - **doc**: fix misleading ASCII comments (Rahat Ahmed) [#11657](https://github.com/nodejs/node/pull/11657)
* [[`3419b7a9d4`](https://github.com/nodejs/node/commit/3419b7a9d4)] - **doc**: add `Daijiro Wachi` to collaborators (Daijiro Wachi) [#11676](https://github.com/nodejs/node/pull/11676)
* [[`a042c8a0ef`](https://github.com/nodejs/node/commit/a042c8a0ef)] - **doc**: fix typo in stream doc (Bradley Curran) [#11560](https://github.com/nodejs/node/pull/11560)
* [[`c0663e51d1`](https://github.com/nodejs/node/commit/c0663e51d1)] - **doc**: fixup errors.md (Vse Mozhet Byt) [#11566](https://github.com/nodejs/node/pull/11566)
* [[`0aab0503be`](https://github.com/nodejs/node/commit/0aab0503be)] - **doc**: add link to references in net.Socket (Joyee Cheung) [#11625](https://github.com/nodejs/node/pull/11625)
* [[`109fd72f11`](https://github.com/nodejs/node/commit/109fd72f11)] - **doc**: use common malformed instead of misformatted (James Sumners) [#11518](https://github.com/nodejs/node/pull/11518)
* [[`6c3b104548`](https://github.com/nodejs/node/commit/6c3b104548)] - **doc**: fix typo in STYLE_GUIDE.md (Nikolai Vavilov) [#11615](https://github.com/nodejs/node/pull/11615)
* [[`c9b302b96e`](https://github.com/nodejs/node/commit/c9b302b96e)] - **doc**: make os api doc more consistent (Evan Lucas) [#10994](https://github.com/nodejs/node/pull/10994)
* [[`cbfc3fcd9d`](https://github.com/nodejs/node/commit/cbfc3fcd9d)] - **doc**: use correct tls certificate property name (Sam Roberts) [#10389](https://github.com/nodejs/node/pull/10389)
* [[`4fd765eec8`](https://github.com/nodejs/node/commit/4fd765eec8)] - **doc**: clarify memory sharing behavior of buffer ctor (Zach Bjornson) [#10778](https://github.com/nodejs/node/pull/10778)
* [[`c138ba3684`](https://github.com/nodejs/node/commit/c138ba3684)] - **doc**: new TLSSocket has no secure context options (Sam Roberts) [#10545](https://github.com/nodejs/node/pull/10545)
* [[`16048480e7`](https://github.com/nodejs/node/commit/16048480e7)] - **doc**: fix stylistic issues in api/net.md (Alexey Orlenko) [#11786](https://github.com/nodejs/node/pull/11786)
* [[`de22ff642f`](https://github.com/nodejs/node/commit/de22ff642f)] - **doc**: fix broken URL to event loop guide (Poker) [#11670](https://github.com/nodejs/node/pull/11670)
* [[`0dfb9daa04`](https://github.com/nodejs/node/commit/0dfb9daa04)] - **doc**: add supported platforms list for v6.x (Michael Dawson) [#11943](https://github.com/nodejs/node/pull/11943)
* [[`b9766bdd1b`](https://github.com/nodejs/node/commit/b9766bdd1b)] - **doc**: add supported platforms list (Michael Dawson) [#11943](https://github.com/nodejs/node/pull/11943)
* [[`f1c2f2675c`](https://github.com/nodejs/node/commit/f1c2f2675c)] - **doc,test**: tls .ca option supports multi-PEM files (Sam Roberts) [#10389](https://github.com/nodejs/node/pull/10389)
* [[`1158f44599`](https://github.com/nodejs/node/commit/1158f44599)] - **events,test**: fix TypeError in EventEmitter warning (jseagull) [#9021](https://github.com/nodejs/node/pull/9021)
* [[`0fff04f24f`](https://github.com/nodejs/node/commit/0fff04f24f)] - **lib**: add comment to script eval _tickCallback (Gibson Fahnestock) [#12050](https://github.com/nodejs/node/pull/12050)
* [[`1a7d6337fb`](https://github.com/nodejs/node/commit/1a7d6337fb)] - **lib**: fix event race condition with -e (Ben Noordhuis) [#11958](https://github.com/nodejs/node/pull/11958)
* [[`f8426d9177`](https://github.com/nodejs/node/commit/f8426d9177)] - **lib**: remove unused msg parameter in debug_agent (mr-spd) [#11833](https://github.com/nodejs/node/pull/11833)
* [[`e3105cf50a`](https://github.com/nodejs/node/commit/e3105cf50a)] - **meta**: move WORKING_GROUPS.md to CTC repo (James M Snell) [#11555](https://github.com/nodejs/node/pull/11555)
* [[`f0288f3969`](https://github.com/nodejs/node/commit/f0288f3969)] - **meta**: remove out of date ROADMAP.md file (James M Snell) [#11556](https://github.com/nodejs/node/pull/11556)
* [[`500d17b071`](https://github.com/nodejs/node/commit/500d17b071)] - **module**: fix loading from global folders on Windows (Richard Lau) [#9283](https://github.com/nodejs/node/pull/9283)
* [[`06752d1fc0`](https://github.com/nodejs/node/commit/06752d1fc0)] - **net**: remove misleading comment (Ben Noordhuis) [#11573](https://github.com/nodejs/node/pull/11573)
* [[`bed6acb1ed`](https://github.com/nodejs/node/commit/bed6acb1ed)] - ***Revert*** "**src**: fix delete operator on vm context" (Myles Borins) [#12721](https://github.com/nodejs/node/pull/12721)
* [[`c667e6e083`](https://github.com/nodejs/node/commit/c667e6e083)] - **src**: add fcntl.h include to node.cc (Bartosz Sosnowski) [#12540](https://github.com/nodejs/node/pull/12540)
* [[`1a63321dbf`](https://github.com/nodejs/node/commit/1a63321dbf)] - **src**: fix base64 decoding (Nikolai Vavilov) [#11995](https://github.com/nodejs/node/pull/11995)
* [[`1434e7ff11`](https://github.com/nodejs/node/commit/1434e7ff11)] - **src**: ensure that fd 0-2 are valid on windows (Bartosz Sosnowski) [#11863](https://github.com/nodejs/node/pull/11863)
* [[`1035967989`](https://github.com/nodejs/node/commit/1035967989)] - **src**: remove outdated FIXME in node_crypto.cc (Daniel Bevenius) [#11669](https://github.com/nodejs/node/pull/11669)
* [[`c33933eb6d`](https://github.com/nodejs/node/commit/c33933eb6d)] - **src, buffer**: do not segfault on out-of-range index (Timothy Gu) [#11927](https://github.com/nodejs/node/pull/11927)
* [[`f9287461dd`](https://github.com/nodejs/node/commit/f9287461dd)] - **stream**: avoid additional validation for Buffers (Brian White) [#10580](https://github.com/nodejs/node/pull/10580)
* [[`457c47d85e`](https://github.com/nodejs/node/commit/457c47d85e)] - **stream_base,tls_wrap**: notify on destruct (Trevor Norris) [#11947](https://github.com/nodejs/node/pull/11947)
* [[`aae3765e6f`](https://github.com/nodejs/node/commit/aae3765e6f)] - **test**: refactor several parallel/test-timer tests (Beth Griggs) [#10524](https://github.com/nodejs/node/pull/10524)
* [[`8c922736d0`](https://github.com/nodejs/node/commit/8c922736d0)] - **test**: add a second argument to assert.throws() (dave-k) [#12139](https://github.com/nodejs/node/pull/12139)
* [[`a30ae72350`](https://github.com/nodejs/node/commit/a30ae72350)] - **test**: skip irrelevant test on Windows (Rich Trott) [#12261](https://github.com/nodejs/node/pull/12261)
* [[`49ee30b8ac`](https://github.com/nodejs/node/commit/49ee30b8ac)] - **test**: more robust check for location of `node.exe` (Refael Ackermann) [#12120](https://github.com/nodejs/node/pull/12120)
* [[`a93eaa4b2c`](https://github.com/nodejs/node/commit/a93eaa4b2c)] - **test**: performance, remove Popen(shell=True) on Win (Refael Ackermann) [#12138](https://github.com/nodejs/node/pull/12138)
* [[`5f928a85e5`](https://github.com/nodejs/node/commit/5f928a85e5)] - **test**: increase querystring coverage (DavidCai) [#12163](https://github.com/nodejs/node/pull/12163)
* [[`7af87384bc`](https://github.com/nodejs/node/commit/7af87384bc)] - **test**: fix flaky test-child-process-exec-timeout (Santiago Gimeno) [#12159](https://github.com/nodejs/node/pull/12159)
* [[`4caae6924f`](https://github.com/nodejs/node/commit/4caae6924f)] - **test**: reduce buffer size in buffer-creation test (Sakthipriyan Vairamani (thefourtheye)) [#11177](https://github.com/nodejs/node/pull/11177)
* [[`eb19acb84e`](https://github.com/nodejs/node/commit/eb19acb84e)] - **test**: fix misleading comment (Franziska Hinkelmann) [#12048](https://github.com/nodejs/node/pull/12048)
* [[`e2279e297a`](https://github.com/nodejs/node/commit/e2279e297a)] - **test**: fix broken tests in test-buffer-includes (Alexey Orlenko) [#12040](https://github.com/nodejs/node/pull/12040)
* [[`cddc32c954`](https://github.com/nodejs/node/commit/cddc32c954)] - **test**: replace throw with common.fail (Dejon "DJ" Gill) [#9700](https://github.com/nodejs/node/pull/9700)
* [[`f23377c82d`](https://github.com/nodejs/node/commit/f23377c82d)] - **test**: test validity of prefix in mkdtempSync (Luca Maraschi) [#12009](https://github.com/nodejs/node/pull/12009)
* [[`c65de59f52`](https://github.com/nodejs/node/commit/c65de59f52)] - **test**: add regex for expected error message (John F. Mercer) [#12011](https://github.com/nodejs/node/pull/12011)
* [[`fcc19e1637`](https://github.com/nodejs/node/commit/fcc19e1637)] - **test**: add second argument to assert.throws() (Rj Bernaldo) [#12016](https://github.com/nodejs/node/pull/12016)
* [[`b69cac72e4`](https://github.com/nodejs/node/commit/b69cac72e4)] - **test**: refactor test-cluster-disconnect (Rich Trott) [#11981](https://github.com/nodejs/node/pull/11981)
* [[`4cb4803db2`](https://github.com/nodejs/node/commit/4cb4803db2)] - **test**: add coverage for child_process bounds check (Rich Trott) [#11800](https://github.com/nodejs/node/pull/11800)
* [[`2ee2cc6907`](https://github.com/nodejs/node/commit/2ee2cc6907)] - **test**: refactor test-cli-eval.js (cjihrig) [#10898](https://github.com/nodejs/node/pull/10898)
* [[`b6c30e14fc`](https://github.com/nodejs/node/commit/b6c30e14fc)] - **test**: fix broken assertion (cjihrig) [#10840](https://github.com/nodejs/node/pull/10840)
* [[`4d6b484cf4`](https://github.com/nodejs/node/commit/4d6b484cf4)] - **test**: refactor test-cli-eval.js (Sumit Goel) [#10759](https://github.com/nodejs/node/pull/10759)
* [[`31dea5c319`](https://github.com/nodejs/node/commit/31dea5c319)] - **test**: invalid chars in http client path (Luca Maraschi) [#11964](https://github.com/nodejs/node/pull/11964)
* [[`6063a4ac17`](https://github.com/nodejs/node/commit/6063a4ac17)] - **test**: improve test-vm-cached-data.js (Nick Peleh) [#11974](https://github.com/nodejs/node/pull/11974)
* [[`38017905d6`](https://github.com/nodejs/node/commit/38017905d6)] - **test**: add test for child_process.execFile() (Rich Trott) [#11929](https://github.com/nodejs/node/pull/11929)
* [[`485bb1b334`](https://github.com/nodejs/node/commit/485bb1b334)] - **test**: fix flaky test-tls-socket-close (Rich Trott) [#11921](https://github.com/nodejs/node/pull/11921)
* [[`9dd918b0ab`](https://github.com/nodejs/node/commit/9dd918b0ab)] - **test**: fix assertion in vm test (AnnaMag) [#11862](https://github.com/nodejs/node/pull/11862)
* [[`8e5c8a3ac1`](https://github.com/nodejs/node/commit/8e5c8a3ac1)] - **test**: failing behaviour on sandboxed Proxy (AnnaMag) [#11671](https://github.com/nodejs/node/pull/11671)
* [[`72710d05b9`](https://github.com/nodejs/node/commit/72710d05b9)] - **test**: fix flaky test-domain-abort-on-uncaught (Rich Trott) [#11817](https://github.com/nodejs/node/pull/11817)
* [[`46b2e45b40`](https://github.com/nodejs/node/commit/46b2e45b40)] - **test**: added test for indexed properties (AnnaMag) [#11769](https://github.com/nodejs/node/pull/11769)
* [[`a3f327fd21`](https://github.com/nodejs/node/commit/a3f327fd21)] - **test**: add regex to assert.throws (Matej Krajčovič) [#11815](https://github.com/nodejs/node/pull/11815)
* [[`4d916da0d7`](https://github.com/nodejs/node/commit/4d916da0d7)] - **test**: fail when child dies in fork-net (Joyee Cheung) [#11684](https://github.com/nodejs/node/pull/11684)
* [[`7d4941f01a`](https://github.com/nodejs/node/commit/7d4941f01a)] - **test**: fix args in parallel/test-fs-null-bytes.js (Vse Mozhet Byt) [#11601](https://github.com/nodejs/node/pull/11601)
* [[`cd98f5d303`](https://github.com/nodejs/node/commit/cd98f5d303)] - **test**: fix flaky test-http-set-timeout-server (Santiago Gimeno) [#11790](https://github.com/nodejs/node/pull/11790)
* [[`67b6d7d123`](https://github.com/nodejs/node/commit/67b6d7d123)] - **test**: add test for loading from global folders (Richard Lau) [#9283](https://github.com/nodejs/node/pull/9283)
* [[`aa9815081d`](https://github.com/nodejs/node/commit/aa9815081d)] - **test**: add script to create 0-dns-cert.pem (Shigeki Ohtsu) [#11579](https://github.com/nodejs/node/pull/11579)
* [[`5a93eab30d`](https://github.com/nodejs/node/commit/5a93eab30d)] - **test**: increase coverage of console (DavidCai) [#11653](https://github.com/nodejs/node/pull/11653)
* [[`4befdd1c13`](https://github.com/nodejs/node/commit/4befdd1c13)] - **test**: limit lint rule disabling in message test (Rich Trott) [#11724](https://github.com/nodejs/node/pull/11724)
* [[`91b8da67a5`](https://github.com/nodejs/node/commit/91b8da67a5)] - **test**: skip the test with proper TAP message (Sakthipriyan Vairamani (thefourtheye)) [#11584](https://github.com/nodejs/node/pull/11584)
* [[`a43aa0eaa9`](https://github.com/nodejs/node/commit/a43aa0eaa9)] - **test**: changed test1 of test-vm-timeout.js (maurice_hayward) [#11590](https://github.com/nodejs/node/pull/11590)
* [[`1b4f69acae`](https://github.com/nodejs/node/commit/1b4f69acae)] - **test**: remove obsolete eslint-disable comment (Rich Trott) [#11643](https://github.com/nodejs/node/pull/11643)
* [[`7cc4645b70`](https://github.com/nodejs/node/commit/7cc4645b70)] - **test**: fix tests when npn feature is disabled. (Shigeki Ohtsu) [#11655](https://github.com/nodejs/node/pull/11655)
* [[`96924ed8f5`](https://github.com/nodejs/node/commit/96924ed8f5)] - **test**: add test-buffer-prototype-inspect (Rich Trott) [#11600](https://github.com/nodejs/node/pull/11600)
* [[`a27098d921`](https://github.com/nodejs/node/commit/a27098d921)] - **test**: enable max-len for test-repl (Rich Trott) [#11559](https://github.com/nodejs/node/pull/11559)
* [[`640b72e27d`](https://github.com/nodejs/node/commit/640b72e27d)] - **test**: fix flaky test-https-agent-create-connection (Santiago Gimeno) [#11649](https://github.com/nodejs/node/pull/11649)
* [[`678e225d56`](https://github.com/nodejs/node/commit/678e225d56)] - **test**: improve https coverage to check create connection (chiaki-yokoo) [#11435](https://github.com/nodejs/node/pull/11435)
* [[`d4f2ef7a59`](https://github.com/nodejs/node/commit/d4f2ef7a59)] - **test**: apply strict mode in test-repl (Rich Trott) [#11575](https://github.com/nodejs/node/pull/11575)
* [[`0322d3b8d5`](https://github.com/nodejs/node/commit/0322d3b8d5)] - **test**: skip tests with common.skip (Sakthipriyan Vairamani (thefourtheye)) [#11585](https://github.com/nodejs/node/pull/11585)
* [[`4575f92428`](https://github.com/nodejs/node/commit/4575f92428)] - **test**: move common tls connect setup into fixtures (Sam Roberts) [#10389](https://github.com/nodejs/node/pull/10389)
* [[`4207bceacd`](https://github.com/nodejs/node/commit/4207bceacd)] - **test**: check tls server verification with addCACert (Sam Roberts) [#10389](https://github.com/nodejs/node/pull/10389)
* [[`1d7fab3740`](https://github.com/nodejs/node/commit/1d7fab3740)] - **test**: tls cert chain completion scenarios (Sam Roberts) [#10389](https://github.com/nodejs/node/pull/10389)
* [[`a1cb6992d9`](https://github.com/nodejs/node/commit/a1cb6992d9)] - **test**: getgroups() may contain duplicate GIDs (Sam Roberts) [#10389](https://github.com/nodejs/node/pull/10389)
* [[`eb47897f52`](https://github.com/nodejs/node/commit/eb47897f52)] - **test**: refactor test-stream2-readable-wrap.js (dpg5000) [#10551](https://github.com/nodejs/node/pull/10551)
* [[`6f85c81f0d`](https://github.com/nodejs/node/commit/6f85c81f0d)] - **test**: s/assert.equal/assert.strictEqual/ (Gibson Fahnestock) [#10698](https://github.com/nodejs/node/pull/10698)
* [[`afea1d041e`](https://github.com/nodejs/node/commit/afea1d041e)] - **test**: refactor test-beforeexit-event-exit.js (cjihrig) [#10577](https://github.com/nodejs/node/pull/10577)
* [[`f0645200aa`](https://github.com/nodejs/node/commit/f0645200aa)] - **test**: improve test-fs-access (Adrian Estrada) [#10542](https://github.com/nodejs/node/pull/10542)
* [[`f874256aae`](https://github.com/nodejs/node/commit/f874256aae)] - **test**: skip when openssl CLI doesn't exist (Sota Yamashita) [#11095](https://github.com/nodejs/node/pull/11095)
* [[`9162316ef5`](https://github.com/nodejs/node/commit/9162316ef5)] - **test**: add arrow functions to test-util-inspect (Alexey Orlenko) [#11781](https://github.com/nodejs/node/pull/11781)
* [[`db61c952de`](https://github.com/nodejs/node/commit/db61c952de)] - **test**: use eslint to fix var-\>const/let (Gibson Fahnestock) [#10685](https://github.com/nodejs/node/pull/10685)
* [[`632aee186d`](https://github.com/nodejs/node/commit/632aee186d)] - **timers**: fix not to close reused timer handle (Shigeki Ohtsu) [#11646](https://github.com/nodejs/node/pull/11646)
* [[`39f7aaa290`](https://github.com/nodejs/node/commit/39f7aaa290)] - **timers**: unlock the timers API (Rich Trott) [#11580](https://github.com/nodejs/node/pull/11580)
* [[`d0868ff36c`](https://github.com/nodejs/node/commit/d0868ff36c)] - **tls**: fix segfault on destroy after partial read (Ben Noordhuis) [#11898](https://github.com/nodejs/node/pull/11898)
* [[`1baee1829b`](https://github.com/nodejs/node/commit/1baee1829b)] - **tls**: keep track of stream that is closed (jBarz) [#11776](https://github.com/nodejs/node/pull/11776)
* [[`b1ddf11c14`](https://github.com/nodejs/node/commit/b1ddf11c14)] - **tls**: fix macro to check NPN feature (Shigeki Ohtsu) [#11655](https://github.com/nodejs/node/pull/11655)
* [[`6eb1c25263`](https://github.com/nodejs/node/commit/6eb1c25263)] - **tools**: ignore URLs in line length linting (Rich Trott) [#11890](https://github.com/nodejs/node/pull/11890)
* [[`cad425c571`](https://github.com/nodejs/node/commit/cad425c571)] - **tools**: update dotfile whitelist in .gitignore (Michaël Zasso) [#12116](https://github.com/nodejs/node/pull/12116)
* [[`3858861463`](https://github.com/nodejs/node/commit/3858861463)] - **tools**: add links to the stability index reference (Michael Cox) [#11664](https://github.com/nodejs/node/pull/11664)
* [[`3e6d9922b9`](https://github.com/nodejs/node/commit/3e6d9922b9)] - **tools**: remove NODE_PATH from environment for tests (Rich Trott) [#11612](https://github.com/nodejs/node/pull/11612)
* [[`de63698066`](https://github.com/nodejs/node/commit/de63698066)] - **tools, test**: require const/let in test (Gibson Fahnestock) [#10685](https://github.com/nodejs/node/pull/10685)
* [[`63449972d1`](https://github.com/nodejs/node/commit/63449972d1)] - **url**: use `hasIntl` instead of `try-catch` (Daijiro Wachi) [#11571](https://github.com/nodejs/node/pull/11571)

<a id="6.10.2"></a>
## 2017-04-04, Version 6.10.2 'Boron' (LTS), @MylesBorins

This is a special LTS to fix a number of regressions that were found on the 6.10.x release line.

This includes:

* a fix for memory leak in the crypto module that was introduced in 6.10.1
* a fix for a regression introduced to the windows repl in 6.10.0
* a backported fix for V8 to stop a segfault that could occur when using spread syntax

It also includes an upgrade to zlib 1.2.11 to fix a [number of low severity CVEs](http://seclists.org/oss-sec/2016/q4/602)
that were present in zlib 1.2.8.

### Notable changes

* **crypto**:
  * fix memory leak if certificate is revoked (Tom Atkinson) [#12089](https://github.com/nodejs/node/pull/12089)
* **deps**:
  * upgrade zlib to 1.2.11 (Sam Roberts) [#10980](https://github.com/nodejs/node/pull/10980)
  * backport V8 fixes for spread syntax regression causing segfaults (Michaël Zasso) [#12037](https://github.com/nodejs/node/pull/12037)
* **repl**:
  * Revert commit that broke REPL display on Windows (Myles Borins) [#12123](https://github.com/nodejs/node/pull/12123)

### Commits

* [[`5f644d2f6f`](https://github.com/nodejs/node/commit/5f644d2f6f)] - **crypto**: fix memory leak if certificate is revoked (Tom Atkinson) [#12089](https://github.com/nodejs/node/pull/12089)
* [[`912f78a566`](https://github.com/nodejs/node/commit/912f78a566)] - **deps**: fix CLEAR_HASH macro to be usable as a single statement (Sam Roberts) [#11616](https://github.com/nodejs/node/pull/11616)
* [[`abe9132011`](https://github.com/nodejs/node/commit/abe9132011)] - **deps**: upgrade zlib to 1.2.11 (Sam Roberts) [#10980](https://github.com/nodejs/node/pull/10980)
* [[`1ff512c185`](https://github.com/nodejs/node/commit/1ff512c185)] - **deps**: backport e427300 from upstream V8 (Michaël Zasso) [#12037](https://github.com/nodejs/node/pull/12037)
* [[`8dfc710a06`](https://github.com/nodejs/node/commit/8dfc710a06)] - **deps**: cherry-pick b9f682b from upstream V8 (Michaël Zasso) [#12037](https://github.com/nodejs/node/pull/12037)
* [[`52bdb8f246`](https://github.com/nodejs/node/commit/52bdb8f246)] - **deps**: backport 2cabc86 from upstream V8 (Michaël Zasso) [#12037](https://github.com/nodejs/node/pull/12037)
* [[`64fc5a4541`](https://github.com/nodejs/node/commit/d60ceb8a02)] - **repl** Revert: "Revert "repl: disable Ctrl+C support..." (Myles Borins) [#12123](https://github.com/nodejs/node/pull/12123)

<a id="6.10.1"></a>
## 2017-03-21, Version 6.10.1 'Boron' (LTS), @MylesBorins

This LTS release comes with 297 commits. This includes 124 which are test related,
79 which are doc related, 16 which are build / tool related and 4 commits which are updates to dependencies.

### Notable changes

* **performance**: The performance of several APIs has been improved.
  * `Buffer.compare()` is up to 35% faster on average. (Brian White) [#10927](https://github.com/nodejs/node/pull/10927)
  * `buffer.toJSON()` is up to 2859% faster on average. (Brian White) [#10895](https://github.com/nodejs/node/pull/10895)
  * `fs.*statSync()` functions are now up to 9.3% faster on average. (Brian White) [#11522](https://github.com/nodejs/node/pull/11522)
  * `os.loadavg` is up to 151% faster. (Brian White) [#11516](https://github.com/nodejs/node/pull/11516)
  * `process.memoryUsage()` is up to 34% faster. (Brian White) [#11497](https://github.com/nodejs/node/pull/11497)
  * `querystring.unescape()` for `Buffer`s is 15% faster on average. (Brian White) [#10837](https://github.com/nodejs/node/pull/10837)
  * `querystring.stringify()` is up to 7.8% faster on average. (Brian White) [#10852](https://github.com/nodejs/node/pull/10852)
  * `querystring.parse()` is up to 21% faster on average. (Brian White) [#10874](https://github.com/nodejs/node/pull/10874)
* **IPC**: Batched writes have been enabled for process IPC on platforms that support Unix Domain Sockets. (Alexey Orlenko) [#10677](https://github.com/nodejs/node/pull/10677)
  * Performance gains may be up to 40% for some workloads.
* **child_process**: `spawnSync` now returns a null `status` when child is terminated by a signal. (cjihrig) [#11288](https://github.com/nodejs/node/pull/11288)
  * This fixes the behavior to act like `spawn()` does.
* **http**:
  * Control characters are now always rejected when using `http.request()`. (Ben Noordhuis) [#8923](https://github.com/nodejs/node/pull/8923)
  * Debug messages have been added for cases when headers contain invalid values. (Evan Lucas) [#9195](https://github.com/nodejs/node/pull/9195)
* **node**: Heap statistics now support values larger than 4GB. (Ben Noordhuis) [#10186](https://github.com/nodejs/node/pull/10186)
* **timers**: Timer callbacks now always maintain order when interacting with domain error handling. (John Barboza) [#10522](https://github.com/nodejs/node/pull/10522)

### Commits

* [[`fb75bed078`](https://github.com/nodejs/node/commit/fb75bed078)] - **assert**: unlock the assert API (Rich Trott) [#11304](https://github.com/nodejs/node/pull/11304)
* [[`32b264c33b`](https://github.com/nodejs/node/commit/32b264c33b)] - **assert**: remove unneeded condition (Rich Trott) [#11314](https://github.com/nodejs/node/pull/11314)
* [[`a0c705ef79`](https://github.com/nodejs/node/commit/a0c705ef79)] - **assert**: apply minor refactoring (Rich Trott) [#11511](https://github.com/nodejs/node/pull/11511)
* [[`7ecfe4971a`](https://github.com/nodejs/node/commit/7ecfe4971a)] - **assert**: update comments (Kai Cataldo) [#10579](https://github.com/nodejs/node/pull/10579)
* [[`4d6fa8d040`](https://github.com/nodejs/node/commit/4d6fa8d040)] - **benchmark**: add more thorough timers benchmarks (Jeremiah Senkpiel) [#10925](https://github.com/nodejs/node/pull/10925)
* [[`406e623b13`](https://github.com/nodejs/node/commit/406e623b13)] - **benchmark**: add benchmark for object properties (Michaël Zasso) [#10949](https://github.com/nodejs/node/pull/10949)
* [[`7ee04c6015`](https://github.com/nodejs/node/commit/7ee04c6015)] - **benchmark**: don't lint autogenerated modules (Brian White) [#10756](https://github.com/nodejs/node/pull/10756)
* [[`d22d7cce7c`](https://github.com/nodejs/node/commit/d22d7cce7c)] - **benchmark**: move punycode benchmark out of net (Brian White) [#10446](https://github.com/nodejs/node/pull/10446)
* [[`6b361611c3`](https://github.com/nodejs/node/commit/6b361611c3)] - **benchmark**: move setImmediate benchmarks to timers (Joshua Colvin) [#11010](https://github.com/nodejs/node/pull/11010)
* [[`a469ce5826`](https://github.com/nodejs/node/commit/a469ce5826)] - **benchmark**: add assert.deep\[Strict\]Equal benchmarks (Joyee Cheung) [#11092](https://github.com/nodejs/node/pull/11092)
* [[`eca1e80722`](https://github.com/nodejs/node/commit/eca1e80722)] - **benchmark**: add dgram bind(+/- params) benchmark (Vse Mozhet Byt) [#11313](https://github.com/nodejs/node/pull/11313)
* [[`06c339dcce`](https://github.com/nodejs/node/commit/06c339dcce)] - **benchmark**: improve readability of net benchmarks (Brian White) [#10446](https://github.com/nodejs/node/pull/10446)
* [[`b4cf8c4036`](https://github.com/nodejs/node/commit/b4cf8c4036)] - **benchmark,lib,test**: adjust for linting (Rich Trott) [#10561](https://github.com/nodejs/node/pull/10561)
* [[`e397e6f94a`](https://github.com/nodejs/node/commit/e397e6f94a)] - **buffer**: improve compare() performance (Brian White) [#10927](https://github.com/nodejs/node/pull/10927)
* [[`2b52859535`](https://github.com/nodejs/node/commit/2b52859535)] - **buffer**: fix comments in bidirectionalIndexOf (dcposch@dcpos.ch) [#10162](https://github.com/nodejs/node/pull/10162)
* [[`f7879d98f8`](https://github.com/nodejs/node/commit/f7879d98f8)] - **buffer**: improve toJSON() performance (Brian White) [#10895](https://github.com/nodejs/node/pull/10895)
* [[`f83d035c50`](https://github.com/nodejs/node/commit/f83d035c50)] - **buffer**: convert offset & length to int properly (Sakthipriyan Vairamani (thefourtheye)) [#11176](https://github.com/nodejs/node/pull/11176)
* [[`cda593774f`](https://github.com/nodejs/node/commit/cda593774f)] - **build**: sort sources alphabetically (Daniel Bevenius) [#10892](https://github.com/nodejs/node/pull/10892)
* [[`2d31fd8bf7`](https://github.com/nodejs/node/commit/2d31fd8bf7)] - **build**: move source files from headers section (Daniel Bevenius) [#10850](https://github.com/nodejs/node/pull/10850)
* [[`b7c5295437`](https://github.com/nodejs/node/commit/b7c5295437)] - **build**: don't squash signal handlers with --shared (Stewart X Addison) [#10539](https://github.com/nodejs/node/pull/10539)
* [[`6772b1d81c`](https://github.com/nodejs/node/commit/6772b1d81c)] - **build**: disable C4267 conversion compiler warning (Ben Noordhuis) [#11205](https://github.com/nodejs/node/pull/11205)
* [[`93416e9b7a`](https://github.com/nodejs/node/commit/93416e9b7a)] - **build**: fix newlines in addon build output (Brian White) [#11466](https://github.com/nodejs/node/pull/11466)
* [[`2d5cb3b870`](https://github.com/nodejs/node/commit/2d5cb3b870)] - **build**: fail on CI if leftover processes (Rich Trott) [#11269](https://github.com/nodejs/node/pull/11269)
* [[`edcca78f10`](https://github.com/nodejs/node/commit/edcca78f10)] - **build**: add rule to clean addon tests build (Joyee Cheung) [#11519](https://github.com/nodejs/node/pull/11519)
* [[`0200a5a74e`](https://github.com/nodejs/node/commit/0200a5a74e)] - **build**: fix node_g target (Daniel Bevenius) [#10153](https://github.com/nodejs/node/pull/10153)
* [[`f44c0a5d7a`](https://github.com/nodejs/node/commit/f44c0a5d7a)] - **build**: Don't regenerate node symlink (sxa555) [#9827](https://github.com/nodejs/node/pull/9827)
* [[`947d07bd87`](https://github.com/nodejs/node/commit/947d07bd87)] - **child_process**: exit spawnSync with null on signal (cjihrig) [#11288](https://github.com/nodejs/node/pull/11288)
* [[`4179c7050f`](https://github.com/nodejs/node/commit/4179c7050f)] - **child_process**: move anonymous class to top level (Jackson Tian) [#11147](https://github.com/nodejs/node/pull/11147)
* [[`818cef848e`](https://github.com/nodejs/node/commit/818cef848e)] - **child_process**: remove empty if condition (cjihrig) [#11427](https://github.com/nodejs/node/pull/11427)
* [[`c371fdcf34`](https://github.com/nodejs/node/commit/c371fdcf34)] - **child_process**: refactor internal/child_process.js (Arseniy Maximov) [#11366](https://github.com/nodejs/node/pull/11366)
* [[`b662c117cb`](https://github.com/nodejs/node/commit/b662c117cb)] - **crypto**: return the retval of HMAC_Update (Travis Meisenheimer) [#10891](https://github.com/nodejs/node/pull/10891)
* [[`44510197dd`](https://github.com/nodejs/node/commit/44510197dd)] - **crypto**: freelist_max_len is gone in OpenSSL 1.1.0 (Adam Langley) [#10859](https://github.com/nodejs/node/pull/10859)
* [[`34614af53b`](https://github.com/nodejs/node/commit/34614af53b)] - **crypto**: add cert check issued by StartCom/WoSign (Shigeki Ohtsu) [#9469](https://github.com/nodejs/node/pull/9469)
* [[`b4b3bb4c5d`](https://github.com/nodejs/node/commit/b4b3bb4c5d)] - **crypto**: Remove expired certs from CNNIC whitelist (Shigeki Ohtsu) [#9469](https://github.com/nodejs/node/pull/9469)
* [[`1f44922e34`](https://github.com/nodejs/node/commit/1f44922e34)] - **crypto**: use CHECK_NE instead of ABORT or abort (Sam Roberts) [#10413](https://github.com/nodejs/node/pull/10413)
* [[`ccb6045f2d`](https://github.com/nodejs/node/commit/ccb6045f2d)] - **crypto,tls**: fix mutability of return values (Rich Trott) [#10795](https://github.com/nodejs/node/pull/10795)
* [[`3ab070d4e1`](https://github.com/nodejs/node/commit/3ab070d4e1)] - **deps**: backport dfb8d33 from V8 upstream (Michaël Zasso) [#11483](https://github.com/nodejs/node/pull/11483)
* [[`3fc6a2247f`](https://github.com/nodejs/node/commit/3fc6a2247f)] - **deps**: cherry-pick a814b8a from upstream V8 (ishell@chromium.org) [#10733](https://github.com/nodejs/node/pull/10733)
* [[`254cb1cb77`](https://github.com/nodejs/node/commit/254cb1cb77)] - **deps**: back-port 73ee7943 from v8 upstream (Ben Noordhuis) [#9293](https://github.com/nodejs/node/pull/9293)
* [[`e774de1685`](https://github.com/nodejs/node/commit/e774de1685)] - **deps**: back-port 306c412c from v8 upstream (Ben Noordhuis) [#9293](https://github.com/nodejs/node/pull/9293)
* [[`e5d1e273d7`](https://github.com/nodejs/node/commit/e5d1e273d7)] - **dgram**: fix possibly deoptimizing use of arguments (Vse Mozhet Byt) [#11242](https://github.com/nodejs/node/pull/11242)
* [[`c7257e716f`](https://github.com/nodejs/node/commit/c7257e716f)] - **dgram**: remove this aliases (cjihrig) [#11243](https://github.com/nodejs/node/pull/11243)
* [[`227cc1e810`](https://github.com/nodejs/node/commit/227cc1e810)] - **doc**: restrict the ES.Next features usage in tests (DavidCai) [#11452](https://github.com/nodejs/node/pull/11452)
* [[`23246768fb`](https://github.com/nodejs/node/commit/23246768fb)] - **doc**: add missing entry in v6 changelog table (Luigi Pinca) [#11534](https://github.com/nodejs/node/pull/11534)
* [[`ff9a86a73e`](https://github.com/nodejs/node/commit/ff9a86a73e)] - **doc**: remove Chris Dickinson from active releasers (Ben Noordhuis) [#11011](https://github.com/nodejs/node/pull/11011)
* [[`313d1a3009`](https://github.com/nodejs/node/commit/313d1a3009)] - **doc**: for style, remove "isn't" contraction (Sam Roberts) [#10981](https://github.com/nodejs/node/pull/10981)
* [[`ab7587ed6c`](https://github.com/nodejs/node/commit/ab7587ed6c)] - **doc**: update http.md for consistency and clarity (Lance Ball) [#10715](https://github.com/nodejs/node/pull/10715)
* [[`21a94ab78c`](https://github.com/nodejs/node/commit/21a94ab78c)] - **doc**: clarify Buffer.indexOf/lastIndexOf edge cases (dcposch@dcpos.ch) [#10162](https://github.com/nodejs/node/pull/10162)
* [[`8c487de736`](https://github.com/nodejs/node/commit/8c487de736)] - **doc**: document argument variant in the repl.md (Vse Mozhet Byt) [#10221](https://github.com/nodejs/node/pull/10221)
* [[`130710476b`](https://github.com/nodejs/node/commit/130710476b)] - **doc**: DEFAULT_ECDH_CURVE was added in 0.11.13 (Sam Roberts) [#10983](https://github.com/nodejs/node/pull/10983)
* [[`5118e05b15`](https://github.com/nodejs/node/commit/5118e05b15)] - **doc**: HTTP response getHeader doc fix (Faiz Halde) [#10817](https://github.com/nodejs/node/pull/10817)
* [[`243652abbe`](https://github.com/nodejs/node/commit/243652abbe)] - **doc**: remove duplicate properties bullet in readme (Javis Sullivan) [#10741](https://github.com/nodejs/node/pull/10741)
* [[`fa8a394e51`](https://github.com/nodejs/node/commit/fa8a394e51)] - **doc**: specify sorted requires in tests (Sam Roberts) [#10716](https://github.com/nodejs/node/pull/10716)
* [[`1660311056`](https://github.com/nodejs/node/commit/1660311056)] - **doc**: fix typo in http.md (Peter Mescalchin) [#10975](https://github.com/nodejs/node/pull/10975)
* [[`8936814a70`](https://github.com/nodejs/node/commit/8936814a70)] - **doc**: add who to CC list for dgram (cjihrig) [#11035](https://github.com/nodejs/node/pull/11035)
* [[`b934058128`](https://github.com/nodejs/node/commit/b934058128)] - **doc**: correct and complete dgram's Socket.bind docs (Alex Jordan) [#11025](https://github.com/nodejs/node/pull/11025)
* [[`faa55fbe09`](https://github.com/nodejs/node/commit/faa55fbe09)] - **doc**: edit CONTRIBUTING.md for clarity (Rich Trott) [#11045](https://github.com/nodejs/node/pull/11045)
* [[`c26258e1fd`](https://github.com/nodejs/node/commit/c26258e1fd)] - **doc**: fix confusing example in dns.md (Vse Mozhet Byt) [#11022](https://github.com/nodejs/node/pull/11022)
* [[`8bf7f9f202`](https://github.com/nodejs/node/commit/8bf7f9f202)] - **doc**: add personal pronouns option (Rich Trott) [#11089](https://github.com/nodejs/node/pull/11089)
* [[`7c22a52a74`](https://github.com/nodejs/node/commit/7c22a52a74)] - **doc**: clarify msg when doc/api/cli.md not updated (Stewart X Addison) [#10872](https://github.com/nodejs/node/pull/10872)
* [[`d404d8b673`](https://github.com/nodejs/node/commit/d404d8b673)] - **doc**: edit stability text for clarity and style (Rich Trott) [#11112](https://github.com/nodejs/node/pull/11112)
* [[`38938e1ba9`](https://github.com/nodejs/node/commit/38938e1ba9)] - **doc**: remove assertions about assert (Rich Trott) [#11113](https://github.com/nodejs/node/pull/11113)
* [[`89d30908f2`](https://github.com/nodejs/node/commit/89d30908f2)] - **doc**: fix "initial delay" link in http.md (Timo Tijhof) [#11108](https://github.com/nodejs/node/pull/11108)
* [[`c0072f8d71`](https://github.com/nodejs/node/commit/c0072f8d71)] - **doc**: typographical fixes in COLLABORATOR_GUIDE.md (Anna Henningsen) [#11163](https://github.com/nodejs/node/pull/11163)
* [[`207142d050`](https://github.com/nodejs/node/commit/207142d050)] - **doc**: add not-an-aardvark as ESLint contact (Rich Trott) [#11169](https://github.com/nodejs/node/pull/11169)
* [[`3746eee19d`](https://github.com/nodejs/node/commit/3746eee19d)] - **doc**: improve testing guide (Joyee Cheung) [#11150](https://github.com/nodejs/node/pull/11150)
* [[`6cadc7160f`](https://github.com/nodejs/node/commit/6cadc7160f)] - **doc**: remove extraneous paragraph from assert doc (Rich Trott) [#11174](https://github.com/nodejs/node/pull/11174)
* [[`d5d8a8d7b5`](https://github.com/nodejs/node/commit/d5d8a8d7b5)] - **doc**: fix typo in dgram doc (Rich Trott) [#11186](https://github.com/nodejs/node/pull/11186)
* [[`59a1d00906`](https://github.com/nodejs/node/commit/59a1d00906)] - **doc**: add and fix System Error properties (Daiki Arai) [#10986](https://github.com/nodejs/node/pull/10986)
* [[`72adba4317`](https://github.com/nodejs/node/commit/72adba4317)] - **doc**: add links between cork() and uncork() (Matteo Collina) [#11222](https://github.com/nodejs/node/pull/11222)
* [[`1cd526c253`](https://github.com/nodejs/node/commit/1cd526c253)] - **doc**: clarify the behavior of Buffer.byteLength (Nikolai Vavilov) [#11238](https://github.com/nodejs/node/pull/11238)
* [[`b1bda165ce`](https://github.com/nodejs/node/commit/b1bda165ce)] - **doc**: edit maxBuffer/Unicode paragraph for clarity (Rich Trott) [#11228](https://github.com/nodejs/node/pull/11228)
* [[`1150af00f7`](https://github.com/nodejs/node/commit/1150af00f7)] - **doc**: improve consistency in documentation titles (Vse Mozhet Byt) [#11230](https://github.com/nodejs/node/pull/11230)
* [[`ade39cdf9c`](https://github.com/nodejs/node/commit/ade39cdf9c)] - **doc**: drop "and io.js" from release section (Ben Noordhuis) [#11054](https://github.com/nodejs/node/pull/11054)
* [[`c79d9f95d1`](https://github.com/nodejs/node/commit/c79d9f95d1)] - **doc**: update email and add personal pronoun (JungMinu) [#11318](https://github.com/nodejs/node/pull/11318)
* [[`7df4ee8d49`](https://github.com/nodejs/node/commit/7df4ee8d49)] - **doc**: update link to V8 Embedder's guide (Franziska Hinkelmann) [#11336](https://github.com/nodejs/node/pull/11336)
* [[`8468d823a8`](https://github.com/nodejs/node/commit/8468d823a8)] - **doc**: update code examples in domain.md (Vse Mozhet Byt) [#11110](https://github.com/nodejs/node/pull/11110)
* [[`10a497cdcb`](https://github.com/nodejs/node/commit/10a497cdcb)] - **doc**: describe when stdout/err is sync (Sam Roberts) [#10884](https://github.com/nodejs/node/pull/10884)
* [[`53d5002ef9`](https://github.com/nodejs/node/commit/53d5002ef9)] - **doc**: dns examples implied string args were arrays (Sam Roberts) [#11350](https://github.com/nodejs/node/pull/11350)
* [[`42304de4f7`](https://github.com/nodejs/node/commit/42304de4f7)] - **doc**: change STYLE-GUIDE to STYLE_GUIDE (Dean Coakley) [#11460](https://github.com/nodejs/node/pull/11460)
* [[`13a9ba9523`](https://github.com/nodejs/node/commit/13a9ba9523)] - **doc**: add STYLE_GUIDE (moved from nodejs/docs) (Gibson Fahnestock) [#11321](https://github.com/nodejs/node/pull/11321)
* [[`0164d9263e`](https://github.com/nodejs/node/commit/0164d9263e)] - **doc**: improve test/README.md (Joyee Cheung) [#11237](https://github.com/nodejs/node/pull/11237)
* [[`e0868aa529`](https://github.com/nodejs/node/commit/e0868aa529)] - **doc**: add comment for net.Server's error event (QianJin2013) [#11136](https://github.com/nodejs/node/pull/11136)
* [[`9a684a1511`](https://github.com/nodejs/node/commit/9a684a1511)] - **doc**: note message event listeners ref IPC channels (Diego Rodríguez Baquero) [#11494](https://github.com/nodejs/node/pull/11494)
* [[`bfa3989584`](https://github.com/nodejs/node/commit/bfa3989584)] - **doc**: argument types for assert methods (Amelia Clarke) [#11548](https://github.com/nodejs/node/pull/11548)
* [[`fc41a1d34d`](https://github.com/nodejs/node/commit/fc41a1d34d)] - **doc**: document clientRequest.aborted (Zach Bjornson) [#11544](https://github.com/nodejs/node/pull/11544)
* [[`ff77425eba`](https://github.com/nodejs/node/commit/ff77425eba)] - **doc**: link to readable and writeable stream section (Sebastian Van Sande) [#11517](https://github.com/nodejs/node/pull/11517)
* [[`4850b503dd`](https://github.com/nodejs/node/commit/4850b503dd)] - **doc**: update TheAlphaNerd to MylesBorins (Myles Borins) [#10586](https://github.com/nodejs/node/pull/10586)
* [[`d04de226a1`](https://github.com/nodejs/node/commit/d04de226a1)] - **doc**: update examples in api/crypto.md (Vse Mozhet Byt) [#10909](https://github.com/nodejs/node/pull/10909)
* [[`a045af3b95`](https://github.com/nodejs/node/commit/a045af3b95)] - **doc**: update AUTHORS list to fix name (Noah Rose Ledesma) [#10945](https://github.com/nodejs/node/pull/10945)
* [[`d266759b99`](https://github.com/nodejs/node/commit/d266759b99)] - **doc**: add TimothyGu to collaborators (Timothy Gu) [#10954](https://github.com/nodejs/node/pull/10954)
* [[`42a5989b39`](https://github.com/nodejs/node/commit/42a5989b39)] - **doc**: mention moderation repo in onboarding doc (Anna Henningsen) [#10869](https://github.com/nodejs/node/pull/10869)
* [[`cdc981f6e1`](https://github.com/nodejs/node/commit/cdc981f6e1)] - **doc**: add edsadr to collaborators (Adrian Estrada) [#10883](https://github.com/nodejs/node/pull/10883)
* [[`787d4ec197`](https://github.com/nodejs/node/commit/787d4ec197)] - **doc**: clarifying variables in fs.write() (Jessica Quynh Tran) [#9792](https://github.com/nodejs/node/pull/9792)
* [[`f48c86ce48`](https://github.com/nodejs/node/commit/f48c86ce48)] - **doc**: add links for zlib convenience methods (Anna Henningsen) [#10829](https://github.com/nodejs/node/pull/10829)
* [[`1dbb366611`](https://github.com/nodejs/node/commit/1dbb366611)] - **doc**: add missing `added:` tag for `zlib.constants` (Anna Henningsen) [#10826](https://github.com/nodejs/node/pull/10826)
* [[`867b4d87dc`](https://github.com/nodejs/node/commit/867b4d87dc)] - **doc**: fix broken internal link in process.md (Anna Henningsen) [#10828](https://github.com/nodejs/node/pull/10828)
* [[`6d726c07aa`](https://github.com/nodejs/node/commit/6d726c07aa)] - **doc**: update writable.write return value (Nathan Phillip Brink) [#10582](https://github.com/nodejs/node/pull/10582)
* [[`1975f82168`](https://github.com/nodejs/node/commit/1975f82168)] - **doc**: edit writing-tests.md (Rich Trott) [#10585](https://github.com/nodejs/node/pull/10585)
* [[`494ee5163f`](https://github.com/nodejs/node/commit/494ee5163f)] - **doc**: fix misleading language in vm docs (Alexey Orlenko) [#10708](https://github.com/nodejs/node/pull/10708)
* [[`8e807f6552`](https://github.com/nodejs/node/commit/8e807f6552)] - **doc**: mention cc-ing nodejs/url team for reviews (Anna Henningsen) [#10652](https://github.com/nodejs/node/pull/10652)
* [[`f9bd4a5645`](https://github.com/nodejs/node/commit/f9bd4a5645)] - **doc**: sort require statements in tests (Sam Roberts) [#10616](https://github.com/nodejs/node/pull/10616)
* [[`032d73841d`](https://github.com/nodejs/node/commit/032d73841d)] - **doc**: handle backpressure when write() return false (Matteo Collina) [#10631](https://github.com/nodejs/node/pull/10631)
* [[`af991c7a98`](https://github.com/nodejs/node/commit/af991c7a98)] - **doc**: add test naming information to guide (Rich Trott) [#10584](https://github.com/nodejs/node/pull/10584)
* [[`b5fd61d77a`](https://github.com/nodejs/node/commit/b5fd61d77a)] - **doc**: fix missing negation in stream.md (Johannes Rieken) [#10712](https://github.com/nodejs/node/pull/10712)
* [[`7e5a59e6fc`](https://github.com/nodejs/node/commit/7e5a59e6fc)] - **doc**: "s/git apply/git am -3" in V8 guide (Myles Borins) [#10665](https://github.com/nodejs/node/pull/10665)
* [[`789bafd693`](https://github.com/nodejs/node/commit/789bafd693)] - **doc**: update LTS info for current releases (Evan Lucas) [#10720](https://github.com/nodejs/node/pull/10720)
* [[`fef978584a`](https://github.com/nodejs/node/commit/fef978584a)] - **doc**: update BUILDING.md (Lukasz Gasior) [#10669](https://github.com/nodejs/node/pull/10669)
* [[`f2ddc72b62`](https://github.com/nodejs/node/commit/f2ddc72b62)] - **doc**: document use of Refs: for references (Gibson Fahnestock) [#10670](https://github.com/nodejs/node/pull/10670)
* [[`0a1d15fba6`](https://github.com/nodejs/node/commit/0a1d15fba6)] - **doc**: clarify information about ABI version (Rich Trott) [#10419](https://github.com/nodejs/node/pull/10419)
* [[`22f3813b3e`](https://github.com/nodejs/node/commit/22f3813b3e)] - **doc**: clarify the statement in vm.createContext() (AnnaMag) [#10519](https://github.com/nodejs/node/pull/10519)
* [[`38d63e49eb`](https://github.com/nodejs/node/commit/38d63e49eb)] - **doc**: improve rinfo object documentation (Matt Crummey) [#10050](https://github.com/nodejs/node/pull/10050)
* [[`998fd1e7e1`](https://github.com/nodejs/node/commit/998fd1e7e1)] - **doc**: add tls.DEFAULT_ECDH_CURVE (Sam Roberts) [#10264](https://github.com/nodejs/node/pull/10264)
* [[`4995a819e0`](https://github.com/nodejs/node/commit/4995a819e0)] - **doc**: fix a wrong note in the buffer.md (Vse Mozhet Byt) [#9795](https://github.com/nodejs/node/pull/9795)
* [[`6d3c2d6212`](https://github.com/nodejs/node/commit/6d3c2d6212)] - **doc**: fix examples in buffer.md to avoid confusion (Vse Mozhet Byt) [#9795](https://github.com/nodejs/node/pull/9795)
* [[`020c90eb2d`](https://github.com/nodejs/node/commit/020c90eb2d)] - **doc**: remove a wrong remark in the buffer.md (Vse Mozhet Byt) [#9795](https://github.com/nodejs/node/pull/9795)
* [[`8af811f90e`](https://github.com/nodejs/node/commit/8af811f90e)] - **doc**: fix copy-paste artifacts in the buffer.md (Vse Mozhet Byt) [#9795](https://github.com/nodejs/node/pull/9795)
* [[`a2b40ad6a4`](https://github.com/nodejs/node/commit/a2b40ad6a4)] - **doc**: fix wrong function arguments in the buffer.md (Vse Mozhet Byt) [#9795](https://github.com/nodejs/node/pull/9795)
* [[`e94abaec1c`](https://github.com/nodejs/node/commit/e94abaec1c)] - **doc**: fix a syntax error in the buffer.md (Vse Mozhet Byt) [#9795](https://github.com/nodejs/node/pull/9795)
* [[`b36c315423`](https://github.com/nodejs/node/commit/b36c315423)] - **doc**: var =\> const/let in the buffer.md (Vse Mozhet Byt) [#9795](https://github.com/nodejs/node/pull/9795)
* [[`b503824b81`](https://github.com/nodejs/node/commit/b503824b81)] - **doc,test**: args to `buffer.copy` can be Uint8Arrays (Anna Henningsen) [#11486](https://github.com/nodejs/node/pull/11486)
* [[`c8d2ca7a78`](https://github.com/nodejs/node/commit/c8d2ca7a78)] - **fs**: improve performance for sync stat() functions (Brian White) [#11522](https://github.com/nodejs/node/pull/11522)
* [[`b4dc7a778f`](https://github.com/nodejs/node/commit/b4dc7a778f)] - **http**: make request.abort() destroy the socket (Luigi Pinca) [#10818](https://github.com/nodejs/node/pull/10818)
* [[`d777da27bc`](https://github.com/nodejs/node/commit/d777da27bc)] - **http**: reject control characters in http.request() (Ben Noordhuis) [#8923](https://github.com/nodejs/node/pull/8923)
* [[`bad0d9367e`](https://github.com/nodejs/node/commit/bad0d9367e)] - **http**: add debug message for invalid header value (Evan Lucas) [#9195](https://github.com/nodejs/node/pull/9195)
* [[`bde1a7e09e`](https://github.com/nodejs/node/commit/bde1a7e09e)] - **lib**: remove unnecessary parameter for assertCrypto() (Jackson Tian) [#10834](https://github.com/nodejs/node/pull/10834)
* [[`a2aa2f7de4`](https://github.com/nodejs/node/commit/a2aa2f7de4)] - **lib**: refactor bootstrap_node.js regular expression (Rich Trott) [#10749](https://github.com/nodejs/node/pull/10749)
* [[`797d9ee924`](https://github.com/nodejs/node/commit/797d9ee924)] - **lib**: refactor crypto cipher/hash/curve getters (Rich Trott) [#10682](https://github.com/nodejs/node/pull/10682)
* [[`69327f5e72`](https://github.com/nodejs/node/commit/69327f5e72)] - **lib**: rename kMaxCallbacksUntilQueueIsShortened (JungMinu) [#11473](https://github.com/nodejs/node/pull/11473)
* [[`a6b2dfa43c`](https://github.com/nodejs/node/commit/a6b2dfa43c)] - **lib**: add constant kMaxCallbacksUntilQueueIsShortened (Daniel Bevenius) [#11199](https://github.com/nodejs/node/pull/11199)
* [[`a3ad63b9b3`](https://github.com/nodejs/node/commit/a3ad63b9b3)] - **lib,src**: support values \> 4GB in heap statistics (Ben Noordhuis) [#10186](https://github.com/nodejs/node/pull/10186)
* [[`8b5dd35ae8`](https://github.com/nodejs/node/commit/8b5dd35ae8)] - **meta**: add explicit deprecation and semver-major policy (James M Snell) [#7964](https://github.com/nodejs/node/pull/7964)
* [[`4df850ba59`](https://github.com/nodejs/node/commit/4df850ba59)] - **meta**: remove Chris Dickinson from CTC (Chris Dickinson) [#11267](https://github.com/nodejs/node/pull/11267)
* [[`8863360a21`](https://github.com/nodejs/node/commit/8863360a21)] - **meta**: adding Italo A. Casas PGP Fingerprint (Italo A. Casas) [#11202](https://github.com/nodejs/node/pull/11202)
* [[`8287d03adf`](https://github.com/nodejs/node/commit/8287d03adf)] - **meta**: decharter the http working group (James M Snell) [#10604](https://github.com/nodejs/node/pull/10604)
* [[`742ec6213f`](https://github.com/nodejs/node/commit/742ec6213f)] - **net**: prefer === to == (Arseniy Maximov) [#11513](https://github.com/nodejs/node/pull/11513)
* [[`5bfa43d8f0`](https://github.com/nodejs/node/commit/5bfa43d8f0)] - **os**: improve loadavg() performance (Brian White) [#11516](https://github.com/nodejs/node/pull/11516)
* [[`b7088a9355`](https://github.com/nodejs/node/commit/b7088a9355)] - **process**: improve memoryUsage() performance (Brian White) [#11497](https://github.com/nodejs/node/pull/11497)
* [[`02e5f5c57e`](https://github.com/nodejs/node/commit/02e5f5c57e)] - **process**: fix typo in comments (levsthings) [#11503](https://github.com/nodejs/node/pull/11503)
* [[`db45bf850a`](https://github.com/nodejs/node/commit/db45bf850a)] - **querystring**: improve unescapeBuffer performance (Brian White) [#10837](https://github.com/nodejs/node/pull/10837)
* [[`32cdbca2dc`](https://github.com/nodejs/node/commit/32cdbca2dc)] - **querystring**: improve stringify() performance (Brian White) [#10852](https://github.com/nodejs/node/pull/10852)
* [[`23f3f20963`](https://github.com/nodejs/node/commit/23f3f20963)] - **querystring**: improve parse() performance (Brian White) [#10874](https://github.com/nodejs/node/pull/10874)
* [[`dc88b6572d`](https://github.com/nodejs/node/commit/dc88b6572d)] - **readline**: refactor construct Interface (Jackson Tian) [#4740](https://github.com/nodejs/node/pull/4740)
* [[`f7c6ad2df9`](https://github.com/nodejs/node/commit/f7c6ad2df9)] - **readline**: update 6 comparions to strict (Umair Ishaq) [#11078](https://github.com/nodejs/node/pull/11078)
* [[`b5a0d46c55`](https://github.com/nodejs/node/commit/b5a0d46c55)] - **src**: add NODE_NO_WARNINGS to --help output (cjihrig) [#10918](https://github.com/nodejs/node/pull/10918)
* [[`566e2fea48`](https://github.com/nodejs/node/commit/566e2fea48)] - **src**: remove unnecessary req_wrap_obj (Daniel Bevenius) [#10942](https://github.com/nodejs/node/pull/10942)
* [[`c7436df889`](https://github.com/nodejs/node/commit/c7436df889)] - **src**: add a missing space in node_os.cc (Alexey Orlenko) [#10931](https://github.com/nodejs/node/pull/10931)
* [[`4358c6096c`](https://github.com/nodejs/node/commit/4358c6096c)] - **src**: enable writev for pipe handles on Unix (Alexey Orlenko) [#10677](https://github.com/nodejs/node/pull/10677)
* [[`28102edbc8`](https://github.com/nodejs/node/commit/28102edbc8)] - **src**: unconsume stream fix in internal http impl (Roee Kasher) [#11015](https://github.com/nodejs/node/pull/11015)
* [[`587857e301`](https://github.com/nodejs/node/commit/587857e301)] - **src**: fix delete operator on vm context (Franziska Hinkelmann) [#11266](https://github.com/nodejs/node/pull/11266)
* [[`b7cbb8002c`](https://github.com/nodejs/node/commit/b7cbb8002c)] - **src**: support UTF-8 in compiled-in JS source files (Ben Noordhuis) [#11129](https://github.com/nodejs/node/pull/11129)
* [[`ce01372b68`](https://github.com/nodejs/node/commit/ce01372b68)] - **src**: remove unused typedef (Ben Noordhuis) [#11322](https://github.com/nodejs/node/pull/11322)
* [[`1dddfeccb2`](https://github.com/nodejs/node/commit/1dddfeccb2)] - **src**: remove usage of deprecated debug API (Yang Guo) [#11437](https://github.com/nodejs/node/pull/11437)
* [[`7f273c6f6e`](https://github.com/nodejs/node/commit/7f273c6f6e)] - **src**: update http-parser link (Daniel Bevenius) [#11477](https://github.com/nodejs/node/pull/11477)
* [[`214b514efe`](https://github.com/nodejs/node/commit/214b514efe)] - **src**: use ABORT() macro instead of abort() (Evan Lucas) [#9613](https://github.com/nodejs/node/pull/9613)
* [[`412f380903`](https://github.com/nodejs/node/commit/412f380903)] - **stream**: move legacy to lib/internal dir (yorkie) [#8197](https://github.com/nodejs/node/pull/8197)
* [[`336f1bd842`](https://github.com/nodejs/node/commit/336f1bd842)] - **test**: increase setMulticastLoopback() coverage (cjihrig) [#11277](https://github.com/nodejs/node/pull/11277)
* [[`b29165f249`](https://github.com/nodejs/node/commit/b29165f249)] - **test**: increase dgram ref()/unref() coverage (cjihrig) [#11240](https://github.com/nodejs/node/pull/11240)
* [[`22d4ed2484`](https://github.com/nodejs/node/commit/22d4ed2484)] - **test**: add an exception test to http-write-head (Yuta Hiroto) [#11034](https://github.com/nodejs/node/pull/11034)
* [[`9edd342e81`](https://github.com/nodejs/node/commit/9edd342e81)] - **test**: add known_issues test for #10223 (AnnaMag) [#11024](https://github.com/nodejs/node/pull/11024)
* [[`646f82520c`](https://github.com/nodejs/node/commit/646f82520c)] - **test**: guarantee test runs in test-readline-keys (Rich Trott) [#11023](https://github.com/nodejs/node/pull/11023)
* [[`d8eed12d31`](https://github.com/nodejs/node/commit/d8eed12d31)] - **test**: check error message in test-http-outgoing-proto (Alex Ling) [#10943](https://github.com/nodejs/node/pull/10943)
* [[`174bef182a`](https://github.com/nodejs/node/commit/174bef182a)] - **test**: increase coverage for stream's duplex (abouthiroppy) [#10963](https://github.com/nodejs/node/pull/10963)
* [[`8ff15a262d`](https://github.com/nodejs/node/commit/8ff15a262d)] - **test**: allow for slow hosts in spawnSync() test (Rich Trott) [#10998](https://github.com/nodejs/node/pull/10998)
* [[`62f6749cd6`](https://github.com/nodejs/node/commit/62f6749cd6)] - **test**: expand test coverage of fs.js (Vinícius do Carmo) [#10947](https://github.com/nodejs/node/pull/10947)
* [[`5cea2239d8`](https://github.com/nodejs/node/commit/5cea2239d8)] - **test**: expand test coverage of events.js (Vinícius do Carmo) [#10947](https://github.com/nodejs/node/pull/10947)
* [[`a1751864e2`](https://github.com/nodejs/node/commit/a1751864e2)] - **test**: check noAssert option in buf.write*() (larissayvette) [#10790](https://github.com/nodejs/node/pull/10790)
* [[`0b5f2b45f9`](https://github.com/nodejs/node/commit/0b5f2b45f9)] - **test**: expand test coverage of fs.js (Vinícius do Carmo) [#10972](https://github.com/nodejs/node/pull/10972)
* [[`d9362efb6c`](https://github.com/nodejs/node/commit/d9362efb6c)] - **test**: enhance test-timers (Rich Trott) [#10960](https://github.com/nodejs/node/pull/10960)
* [[`b9615b3abc`](https://github.com/nodejs/node/commit/b9615b3abc)] - **test**: increase coverage for exec() functions (cjihrig) [#10919](https://github.com/nodejs/node/pull/10919)
* [[`b45280671a`](https://github.com/nodejs/node/commit/b45280671a)] - **test**: add process.assert's test (abouthiroppy) [#10911](https://github.com/nodejs/node/pull/10911)
* [[`6584ea0715`](https://github.com/nodejs/node/commit/6584ea0715)] - **test**: update Buffer.lastIndexOf (dcposch@dcpos.ch) [#10162](https://github.com/nodejs/node/pull/10162)
* [[`0c60540014`](https://github.com/nodejs/node/commit/0c60540014)] - **test**: improve code in test-crypto-verify (Adrian Estrada) [#10845](https://github.com/nodejs/node/pull/10845)
* [[`2a52a68a96`](https://github.com/nodejs/node/commit/2a52a68a96)] - **test**: add dgram.Socket.prototype.bind's test (abouthiroppy) [#10894](https://github.com/nodejs/node/pull/10894)
* [[`2494d8ac68`](https://github.com/nodejs/node/commit/2494d8ac68)] - **test**: update V8 flag in test (Franziska Hinkelmann) [#10917](https://github.com/nodejs/node/pull/10917)
* [[`9ac22cdcaf`](https://github.com/nodejs/node/commit/9ac22cdcaf)] - **test**: increase coverage of string-decoder (abouthiroppy) [#10863](https://github.com/nodejs/node/pull/10863)
* [[`d766f5e0ad`](https://github.com/nodejs/node/commit/d766f5e0ad)] - **test**: improving coverage of dns-lookup (abouthiroppy) [#10844](https://github.com/nodejs/node/pull/10844)
* [[`8f984c3a8a`](https://github.com/nodejs/node/commit/8f984c3a8a)] - **test**: refactor test-fs-read-zero-length.js (abouthiroppy) [#10729](https://github.com/nodejs/node/pull/10729)
* [[`c0e24f9029`](https://github.com/nodejs/node/commit/c0e24f9029)] - **test**: improving coverage for dgram (abouthiroppy) [#10783](https://github.com/nodejs/node/pull/10783)
* [[`c91d873115`](https://github.com/nodejs/node/commit/c91d873115)] - **test**: improve code in test-console-instance (Adrian Estrada) [#10813](https://github.com/nodejs/node/pull/10813)
* [[`a434f451d9`](https://github.com/nodejs/node/commit/a434f451d9)] - **test**: improve code in test-domain-multi (Adrian Estrada) [#10798](https://github.com/nodejs/node/pull/10798)
* [[`b01db3a73f`](https://github.com/nodejs/node/commit/b01db3a73f)] - **test**: improve test-stream2-large-read-stall (stefan judis) [#10725](https://github.com/nodejs/node/pull/10725)
* [[`76f0556c4a`](https://github.com/nodejs/node/commit/76f0556c4a)] - **test**: improve code in test-http-host-headers (Adrian Estrada) [#10830](https://github.com/nodejs/node/pull/10830)
* [[`c740cb6667`](https://github.com/nodejs/node/commit/c740cb6667)] - **test**: add test case to test-http-response-statuscode.js (abouthiroppy) [#10808](https://github.com/nodejs/node/pull/10808)
* [[`872354563c`](https://github.com/nodejs/node/commit/872354563c)] - **test**: refactor cluster-preload.js (abouthiroppy) [#10701](https://github.com/nodejs/node/pull/10701)
* [[`04dc1cdfcb`](https://github.com/nodejs/node/commit/04dc1cdfcb)] - **test**: improve test-fs-write-file-sync (Adrian Estrada) [#10624](https://github.com/nodejs/node/pull/10624)
* [[`0d25d056a4`](https://github.com/nodejs/node/commit/0d25d056a4)] - **test**: test hmac binding robustness (Sam Roberts) [#10923](https://github.com/nodejs/node/pull/10923)
* [[`99a234c97e`](https://github.com/nodejs/node/commit/99a234c97e)] - **test**: refactor the code in test-fs-watch.js (sivaprasanna) [#10357](https://github.com/nodejs/node/pull/10357)
* [[`c13f01c94d`](https://github.com/nodejs/node/commit/c13f01c94d)] - **test**: reduce unmanaged parallelism in domain test (Joyee Cheung) [#10329](https://github.com/nodejs/node/pull/10329)
* [[`ed76b4a8e9`](https://github.com/nodejs/node/commit/ed76b4a8e9)] - **test**: add dgram.Socket.prototype.sendto's test (abouthiroppy) [#10901](https://github.com/nodejs/node/pull/10901)
* [[`5365501a2f`](https://github.com/nodejs/node/commit/5365501a2f)] - **test**: add regression test for V8 parse error (Michaël Zasso) [#11483](https://github.com/nodejs/node/pull/11483)
* [[`b5fb9f4098`](https://github.com/nodejs/node/commit/b5fb9f4098)] - **test**: increase timeout in break-on-uncaught (Sakthipriyan Vairamani (thefourtheye)) [#10822](https://github.com/nodejs/node/pull/10822)
* [[`443dd508d2`](https://github.com/nodejs/node/commit/443dd508d2)] - **test**: fix process.title expectation (Sakthipriyan Vairamani (thefourtheye)) [#10597](https://github.com/nodejs/node/pull/10597)
* [[`ae338daf06`](https://github.com/nodejs/node/commit/ae338daf06)] - **test**: refactor test-debugger-remote (Sakthipriyan Vairamani (thefourtheye)) [#10455](https://github.com/nodejs/node/pull/10455)
* [[`34e0bc6d16`](https://github.com/nodejs/node/commit/34e0bc6d16)] - **test**: fix and improve debugger-client test (Sakthipriyan Vairamani (thefourtheye)) [#10371](https://github.com/nodejs/node/pull/10371)
* [[`da874590a6`](https://github.com/nodejs/node/commit/da874590a6)] - **test**: improve test-assert (richnologies) [#10916](https://github.com/nodejs/node/pull/10916)
* [[`a15ecd269d`](https://github.com/nodejs/node/commit/a15ecd269d)] - **test**: increase coverage for punycode's decode (abouthiroppy) [#10940](https://github.com/nodejs/node/pull/10940)
* [[`98e32db207`](https://github.com/nodejs/node/commit/98e32db207)] - **test**: check fd 0,1,2 are used, not access mode (John Barboza) [#10339](https://github.com/nodejs/node/pull/10339)
* [[`e59697c695`](https://github.com/nodejs/node/commit/e59697c695)] - **test**: fix flaky test-regress-GH-897 (Rich Trott) [#10903](https://github.com/nodejs/node/pull/10903)
* [[`a08c7f6d87`](https://github.com/nodejs/node/commit/a08c7f6d87)] - **test**: don't connect to :: (use localhost instead) (Gibson Fahnestock) [#10854](https://github.com/nodejs/node/pull/10854)
* [[`ca53866333`](https://github.com/nodejs/node/commit/ca53866333)] - **test**: add message verification on assert.throws (Travis Meisenheimer) [#10890](https://github.com/nodejs/node/pull/10890)
* [[`38b123c918`](https://github.com/nodejs/node/commit/38b123c918)] - **test**: refactor test-repl-tab-complete (Rich Trott) [#10879](https://github.com/nodejs/node/pull/10879)
* [[`68fc4d3a1c`](https://github.com/nodejs/node/commit/68fc4d3a1c)] - **test**: simplify array initialization (Rich Trott) [#10860](https://github.com/nodejs/node/pull/10860)
* [[`a26d752e77`](https://github.com/nodejs/node/commit/a26d752e77)] - **test**: add http-common's test (abouthiroppy) [#10832](https://github.com/nodejs/node/pull/10832)
* [[`80e2ff9bff`](https://github.com/nodejs/node/commit/80e2ff9bff)] - **test**: tests for _readableStream.awaitDrain (Mark) [#8914](https://github.com/nodejs/node/pull/8914)
* [[`e4e9f675d2`](https://github.com/nodejs/node/commit/e4e9f675d2)] - **test**: improve the code in test-process-cpuUsage (Adrian Estrada) [#10714](https://github.com/nodejs/node/pull/10714)
* [[`73c0c46cf2`](https://github.com/nodejs/node/commit/73c0c46cf2)] - **test**: increase test-crypto.js strictness (Rich Trott) [#10784](https://github.com/nodejs/node/pull/10784)
* [[`e316fafbd4`](https://github.com/nodejs/node/commit/e316fafbd4)] - **test**: delete duplicate test of noAssert in readUInt* (larissayvette) [#10791](https://github.com/nodejs/node/pull/10791)
* [[`896fb63173`](https://github.com/nodejs/node/commit/896fb63173)] - **test**: add http_incoming's matchKnownFields test (abouthiroppy) [#10811](https://github.com/nodejs/node/pull/10811)
* [[`c086bdc2de`](https://github.com/nodejs/node/commit/c086bdc2de)] - **test**: check error msg test-writeint.js (Irene Li) [#10755](https://github.com/nodejs/node/pull/10755)
* [[`2eb0c25aa1`](https://github.com/nodejs/node/commit/2eb0c25aa1)] - **test**: no unused args test-fs-watch-file.js (istinson) [#10758](https://github.com/nodejs/node/pull/10758)
* [[`2f026f6668`](https://github.com/nodejs/node/commit/2f026f6668)] - **test**: improve tests in pummel/test-exec (Chase Starr) [#10757](https://github.com/nodejs/node/pull/10757)
* [[`93877c87cc`](https://github.com/nodejs/node/commit/93877c87cc)] - **test**: fix temp-dir option in tools/test.py (Gibson Fahnestock) [#10723](https://github.com/nodejs/node/pull/10723)
* [[`0f3677dd5d`](https://github.com/nodejs/node/commit/0f3677dd5d)] - **test**: use realpath for NODE_TEST_DIR in common.js (Gibson Fahnestock) [#10723](https://github.com/nodejs/node/pull/10723)
* [[`5d0cc617bb`](https://github.com/nodejs/node/commit/5d0cc617bb)] - **test**: move resource intensive test to sequential (Rich Trott) [#10744](https://github.com/nodejs/node/pull/10744)
* [[`cd4bb067ad`](https://github.com/nodejs/node/commit/cd4bb067ad)] - **test**: add test for noAssert option in buf.read*() (larissayvette) [#10713](https://github.com/nodejs/node/pull/10713)
* [[`5b55689b2c`](https://github.com/nodejs/node/commit/5b55689b2c)] - **test**: refactor test-crypto-padding-aes256 (adelmann) [#10622](https://github.com/nodejs/node/pull/10622)
* [[`119e512db3`](https://github.com/nodejs/node/commit/119e512db3)] - **test**: refactor the code of test-keep-alive.js (sivaprasanna) [#10684](https://github.com/nodejs/node/pull/10684)
* [[`ef3d889ee7`](https://github.com/nodejs/node/commit/ef3d889ee7)] - **test**: validate 'expected' argument to mustCall() (Nathan Friedly) [#10692](https://github.com/nodejs/node/pull/10692)
* [[`21704a3b6b`](https://github.com/nodejs/node/commit/21704a3b6b)] - **test**: fix misplaced ) in http response statuscode test (Nathan Friedly) [#10692](https://github.com/nodejs/node/pull/10692)
* [[`8565a06b09`](https://github.com/nodejs/node/commit/8565a06b09)] - **test**: refactor test-doctool-html.js (abouthiroppy) [#10696](https://github.com/nodejs/node/pull/10696)
* [[`168f3e4bf8`](https://github.com/nodejs/node/commit/168f3e4bf8)] - **test**: improve the code in test-process-hrtime (Adrian Estrada) [#10667](https://github.com/nodejs/node/pull/10667)
* [[`9acc86f578`](https://github.com/nodejs/node/commit/9acc86f578)] - **test**: refactor test-watch-file.js (sivaprasanna) [#10679](https://github.com/nodejs/node/pull/10679)
* [[`86e39367d6`](https://github.com/nodejs/node/commit/86e39367d6)] - **test**: improve zlib-from-gzip-with-trailing-garbage (Michael Lefkowitz) [#10674](https://github.com/nodejs/node/pull/10674)
* [[`3135455cd9`](https://github.com/nodejs/node/commit/3135455cd9)] - **test**: refactor the code in test-child-process-spawn-loop.js (sivaprasanna) [#10605](https://github.com/nodejs/node/pull/10605)
* [[`f43a8765a2`](https://github.com/nodejs/node/commit/f43a8765a2)] - **test**: allow testing uid and gid separately (cjihrig) [#10647](https://github.com/nodejs/node/pull/10647)
* [[`2f1d231c0d`](https://github.com/nodejs/node/commit/2f1d231c0d)] - **test**: improve test-http-chunked-304 (Adrian Estrada) [#10462](https://github.com/nodejs/node/pull/10462)
* [[`ec8a9962ce`](https://github.com/nodejs/node/commit/ec8a9962ce)] - **test**: improve test-fs-readfile-zero-byte-liar (Adrian Estrada) [#10570](https://github.com/nodejs/node/pull/10570)
* [[`12746af524`](https://github.com/nodejs/node/commit/12746af524)] - **test**: refactor test-fs-utimes (Junshu Okamoto) [#9290](https://github.com/nodejs/node/pull/9290)
* [[`e81b1cc1ae`](https://github.com/nodejs/node/commit/e81b1cc1ae)] - **test**: provide duration/interval to timers (Rich Trott) [#9472](https://github.com/nodejs/node/pull/9472)
* [[`17a63e15e6`](https://github.com/nodejs/node/commit/17a63e15e6)] - **test**: improve test-event-emitter-modify-in-emit (Adrian Estrada) [#10600](https://github.com/nodejs/node/pull/10600)
* [[`50ee4e6dad`](https://github.com/nodejs/node/commit/50ee4e6dad)] - **test**: require handler to be run in sigwinch test (Rich Trott) [#11068](https://github.com/nodejs/node/pull/11068)
* [[`8cce29587c`](https://github.com/nodejs/node/commit/8cce29587c)] - **test**: add 2nd argument to throws in test-assert (Marlena Compton) [#11061](https://github.com/nodejs/node/pull/11061)
* [[`b14d7b3aa1`](https://github.com/nodejs/node/commit/b14d7b3aa1)] - **test**: improve error messages in test-npm-install (Gonen Dukas) [#11027](https://github.com/nodejs/node/pull/11027)
* [[`87488ba2ff`](https://github.com/nodejs/node/commit/87488ba2ff)] - **test**: add path.join's test (Yuta Hiroto) [#11063](https://github.com/nodejs/node/pull/11063)
* [[`232664a10d`](https://github.com/nodejs/node/commit/232664a10d)] - **test**: fix timing sensitivity in debugger test (Ali Ijaz Sheikh) [#11008](https://github.com/nodejs/node/pull/11008)
* [[`c16160418b`](https://github.com/nodejs/node/commit/c16160418b)] - **test**: improve coverage on removeListeners functions (matsuda-koushi) [#11140](https://github.com/nodejs/node/pull/11140)
* [[`898276b1b4`](https://github.com/nodejs/node/commit/898276b1b4)] - **test**: simplify output handling in repl tests (Rich Trott) [#11124](https://github.com/nodejs/node/pull/11124)
* [[`3248cdb2e6`](https://github.com/nodejs/node/commit/3248cdb2e6)] - **test**: improve crypto.setEngine coverage to check for errors (Sebastian Van Sande) [#11143](https://github.com/nodejs/node/pull/11143)
* [[`28111f9eb2`](https://github.com/nodejs/node/commit/28111f9eb2)] - **test**: increase specificity in dgram test (Rich Trott) [#11187](https://github.com/nodejs/node/pull/11187)
* [[`c5e8ccab63`](https://github.com/nodejs/node/commit/c5e8ccab63)] - **test**: remove obsolete comment from dgram test (ALJCepeda) [#8689](https://github.com/nodejs/node/pull/8689)
* [[`7aebc6907c`](https://github.com/nodejs/node/commit/7aebc6907c)] - **test**: improve checks in test-path-parse-format (cjihrig) [#11223](https://github.com/nodejs/node/pull/11223)
* [[`baec432c93`](https://github.com/nodejs/node/commit/baec432c93)] - **test**: add coverage for string array dgram send() (cjihrig) [#11247](https://github.com/nodejs/node/pull/11247)
* [[`6694c26420`](https://github.com/nodejs/node/commit/6694c26420)] - **test**: adapt test-debugger-pid to localized Windows (Vse Mozhet Byt) [#11270](https://github.com/nodejs/node/pull/11270)
* [[`2db4c3c453`](https://github.com/nodejs/node/commit/2db4c3c453)] - **test**: add vm module edge cases (Franziska Hinkelmann) [#11265](https://github.com/nodejs/node/pull/11265)
* [[`759604912a`](https://github.com/nodejs/node/commit/759604912a)] - **test**: refactor test-dgram-setBroadcast.js (cjihrig) [#11252](https://github.com/nodejs/node/pull/11252)
* [[`3185fa1249`](https://github.com/nodejs/node/commit/3185fa1249)] - **test**: querystring.escape with multibyte characters (Daijiro Wachi) [#11251](https://github.com/nodejs/node/pull/11251)
* [[`460a3e1f7a`](https://github.com/nodejs/node/commit/460a3e1f7a)] - **test**: improve test-assert.js (jobala) [#11193](https://github.com/nodejs/node/pull/11193)
* [[`1adfca4b5e`](https://github.com/nodejs/node/commit/1adfca4b5e)] - **test**: refactor test-repl-sigint (Rich Trott) [#11309](https://github.com/nodejs/node/pull/11309)
* [[`c539325d89`](https://github.com/nodejs/node/commit/c539325d89)] - **test**: improve punycode test coverage (Sebastian Van Sande) [#11144](https://github.com/nodejs/node/pull/11144)
* [[`8db3c770be`](https://github.com/nodejs/node/commit/8db3c770be)] - **test**: refactor test-repl-sigint-nested-eval (Rich Trott) [#11303](https://github.com/nodejs/node/pull/11303)
* [[`874ef9d312`](https://github.com/nodejs/node/commit/874ef9d312)] - **test**: add coverage for dgram _createSocketHandle() (cjihrig) [#11291](https://github.com/nodejs/node/pull/11291)
* [[`92f6919532`](https://github.com/nodejs/node/commit/92f6919532)] - **test**: improve crypto coverage (Akito Ito) [#11280](https://github.com/nodejs/node/pull/11280)
* [[`d9deb1fb62`](https://github.com/nodejs/node/commit/d9deb1fb62)] - **test**: improve message in net-connect-local-error (Rich Trott) [#11393](https://github.com/nodejs/node/pull/11393)
* [[`6677c113aa`](https://github.com/nodejs/node/commit/6677c113aa)] - **test**: refactor test-dgram-membership (Rich Trott) [#11388](https://github.com/nodejs/node/pull/11388)
* [[`e7b7d7279c`](https://github.com/nodejs/node/commit/e7b7d7279c)] - **test**: cases to querystring related to empty string (Daijiro Wachi) [#11329](https://github.com/nodejs/node/pull/11329)
* [[`5a92fc25a1`](https://github.com/nodejs/node/commit/5a92fc25a1)] - **test**: consolidate buffer.read() in a file (larissayvette) [#11297](https://github.com/nodejs/node/pull/11297)
* [[`607158ab6e`](https://github.com/nodejs/node/commit/607158ab6e)] - **test**: improve crypto coverage (樋口　彰) [#11279](https://github.com/nodejs/node/pull/11279)
* [[`27f302d94f`](https://github.com/nodejs/node/commit/27f302d94f)] - **test**: remove unused args and comparison fix (Alexander) [#11396](https://github.com/nodejs/node/pull/11396)
* [[`8da156d68f`](https://github.com/nodejs/node/commit/8da156d68f)] - **test**: add coverage for utf8CheckIncomplete() (xiaoyu) [#11419](https://github.com/nodejs/node/pull/11419)
* [[`0ddad76813`](https://github.com/nodejs/node/commit/0ddad76813)] - **test**: fix over-dependence on native promise impl (Ali Ijaz Sheikh) [#11437](https://github.com/nodejs/node/pull/11437)
* [[`34444580f6`](https://github.com/nodejs/node/commit/34444580f6)] - **test**: add test cases for path (Yuta Hiroto) [#11453](https://github.com/nodejs/node/pull/11453)
* [[`4bcf1a0387`](https://github.com/nodejs/node/commit/4bcf1a0387)] - **test**: refactor test-http-response-splitting (Arseniy Maximov) [#11429](https://github.com/nodejs/node/pull/11429)
* [[`7836807178`](https://github.com/nodejs/node/commit/7836807178)] - **test**: add error checking in callback (Rich Trott) [#11446](https://github.com/nodejs/node/pull/11446)
* [[`13b7856444`](https://github.com/nodejs/node/commit/13b7856444)] - **test**: improve coverage in test-crypto.dh (Eric Christie) [#11253](https://github.com/nodejs/node/pull/11253)
* [[`b2f7e7a5ad`](https://github.com/nodejs/node/commit/b2f7e7a5ad)] - **test**: add regex check to test-module-loading (Tarang Hirani) [#11413](https://github.com/nodejs/node/pull/11413)
* [[`6bf936644e`](https://github.com/nodejs/node/commit/6bf936644e)] - **test**: increase coverage of vm (DavidCai) [#11377](https://github.com/nodejs/node/pull/11377)
* [[`6202f14583`](https://github.com/nodejs/node/commit/6202f14583)] - **test**: throw check in test-zlib-write-after-close (Jason Wilson) [#11482](https://github.com/nodejs/node/pull/11482)
* [[`f8884dd1b5`](https://github.com/nodejs/node/commit/f8884dd1b5)] - **test**: add cases for unescape & unescapeBuffer (Daijiro Wachi) [#11326](https://github.com/nodejs/node/pull/11326)
* [[`05909d045b`](https://github.com/nodejs/node/commit/05909d045b)] - **test**: fix flaky test-vm-timeout-rethrow (Kunal Pathak) [#11530](https://github.com/nodejs/node/pull/11530)
* [[`6e5f6e3c02`](https://github.com/nodejs/node/commit/6e5f6e3c02)] - **test**: favor assertions over console logging (Rich Trott) [#11547](https://github.com/nodejs/node/pull/11547)
* [[`2c4aa39021`](https://github.com/nodejs/node/commit/2c4aa39021)] - **test**: mark test-tty-wrap as flaky for AIX (Michael Dawson) [#10618](https://github.com/nodejs/node/pull/10618)
* [[`cb03e74037`](https://github.com/nodejs/node/commit/cb03e74037)] - **test**: improve test-fs-null-bytes (Adrian Estrada) [#10521](https://github.com/nodejs/node/pull/10521)
* [[`69b55f35f7`](https://github.com/nodejs/node/commit/69b55f35f7)] - **test**: refactor test-https-truncate (Rich Trott) [#10225](https://github.com/nodejs/node/pull/10225)
* [[`ada7166dfd`](https://github.com/nodejs/node/commit/ada7166dfd)] - **test**: simplify test-http-client-unescaped-path (Rod Vagg) [#9649](https://github.com/nodejs/node/pull/9649)
* [[`1b85989fb2`](https://github.com/nodejs/node/commit/1b85989fb2)] - **test**: move long-running test to sequential (Rich Trott) [#11176](https://github.com/nodejs/node/pull/11176)
* [[`87760cc346`](https://github.com/nodejs/node/commit/87760cc346)] - **test**: add new.target add-on regression test (Ben Noordhuis) [#9689](https://github.com/nodejs/node/pull/9689)
* [[`73283060ad`](https://github.com/nodejs/node/commit/73283060ad)] - **test,repl**: add coverage for repl .clear+useGlobal (Rich Trott) [#10777](https://github.com/nodejs/node/pull/10777)
* [[`4a87aee532`](https://github.com/nodejs/node/commit/4a87aee532)] - **test,util**: remove lint workarounds (Rich Trott) [#10785](https://github.com/nodejs/node/pull/10785)
* [[`3e9ce770f7`](https://github.com/nodejs/node/commit/3e9ce770f7)] - **test-console**: streamline arrow fn and refine regex (John Maguire) [#11039](https://github.com/nodejs/node/pull/11039)
* [[`b90a141cc7`](https://github.com/nodejs/node/commit/b90a141cc7)] - **timer**: remove duplicated word in comment (asafdav2) [#11323](https://github.com/nodejs/node/pull/11323)
* [[`d71ebb90ec`](https://github.com/nodejs/node/commit/d71ebb90ec)] - **timer,domain**: maintain order of timer callbacks (John Barboza) [#10522](https://github.com/nodejs/node/pull/10522)
* [[`2a168917cb`](https://github.com/nodejs/node/commit/2a168917cb)] - **tls**: do not crash on STARTTLS when OCSP requested (Fedor Indutny) [#10706](https://github.com/nodejs/node/pull/10706)
* [[`f33684ac5f`](https://github.com/nodejs/node/commit/f33684ac5f)] - **tools**: remove custom align-function-arguments rule (Rich Trott) [#10561](https://github.com/nodejs/node/pull/10561)
* [[`fb2f449acc`](https://github.com/nodejs/node/commit/fb2f449acc)] - **tools**: update ESLint to current version (Rich Trott) [#10561](https://github.com/nodejs/node/pull/10561)
* [[`83a3aef873`](https://github.com/nodejs/node/commit/83a3aef873)] - **tools**: rename eslintrc to an undeprecated format (Sakthipriyan Vairamani) [#7699](https://github.com/nodejs/node/pull/7699)
* [[`e4f7f5c630`](https://github.com/nodejs/node/commit/e4f7f5c630)] - **tools**: add lint rule to enforce timer arguments (Rich Trott) [#9472](https://github.com/nodejs/node/pull/9472)
* [[`a13bb54466`](https://github.com/nodejs/node/commit/a13bb54466)] - **tools**: add compile_commands.json gyp generator (Ben Noordhuis) [#7986](https://github.com/nodejs/node/pull/7986)
* [[`b38d8d6e06`](https://github.com/nodejs/node/commit/b38d8d6e06)] - **tools**: suggest python2 command in configure (Roman Reiss) [#11375](https://github.com/nodejs/node/pull/11375)
* [[`291346ea51`](https://github.com/nodejs/node/commit/291346ea51)] - **tools,doc**: add Google Analytics tracking. (Phillip Johnsen) [#6601](https://github.com/nodejs/node/pull/6601)
* [[`1ed47d3f33`](https://github.com/nodejs/node/commit/1ed47d3f33)] - **tty**: avoid oob warning in TTYWrap::GetWindowSize() (Dmitry Tsvettsikh) [#11454](https://github.com/nodejs/node/pull/11454)
* [[`9e6fcbb34c`](https://github.com/nodejs/node/commit/9e6fcbb34c)] - **url**: fix surrogate handling in encodeAuth() (Timothy Gu) [#11387](https://github.com/nodejs/node/pull/11387)
* [[`53213004eb`](https://github.com/nodejs/node/commit/53213004eb)] - **util**: improve readability of normalizeEncoding (Joyee Cheung) [#10439](https://github.com/nodejs/node/pull/10439)
* [[`e54b433c8d`](https://github.com/nodejs/node/commit/e54b433c8d)] - **util**: use ES2015+ Object.is to check negative zero (Shinnosuke Watanabe) [#11332](https://github.com/nodejs/node/pull/11332)
* [[`2e15d48447`](https://github.com/nodejs/node/commit/2e15d48447)] - **v8**: drop v8::FunctionCallbackInfo\<T\>::NewTarget() (Ben Noordhuis) [#9293](https://github.com/nodejs/node/pull/9293)
* [[`fd1ffe4f5a`](https://github.com/nodejs/node/commit/fd1ffe4f5a)] - **v8**: fix --always-opt bug (Ben Noordhuis) [#9293](https://github.com/nodejs/node/pull/9293)
* [[`a55af77fc5`](https://github.com/nodejs/node/commit/a55af77fc5)] - **vm**: refactor vm module (James M Snell) [#11392](https://github.com/nodejs/node/pull/11392)

<a id="6.10.0"></a>
## 2017-02-21, Version 6.10.0 'Boron' (LTS), @MylesBorins

This LTS release comes with 168 commits. This includes 85 which are test related,
34 which are doc related, 12 commits which are updates to dependencies and
5 which are build / tool related.

### Notable Changes

The SEMVER-MINOR changes include:

* **crypto**: allow adding extra certs to well-known CAs (Sam Roberts) [#9139](https://github.com/nodejs/node/pull/9139)
* **deps**: Upgrade INTL ICU to version 58 (Steven R. Loomis) [#9234](https://github.com/nodejs/node/pull/9234)
* **process**: add `process.memoryUsage.external` (Fedor Indutny) [#9587](https://github.com/nodejs/node/pull/9587)
* **src**: add wrapper for process.emitWarning() (Sam Roberts) [#9139](https://github.com/nodejs/node/pull/9139)

Notable SEMVER-PATCH changes include:

* **fs**: cache non-symlinks in realpathSync. (Jeremy Yallop) [#10253](https://github.com/nodejs/node/pull/10253)
* **repl**: allow autocompletion for scoped packages (Evan Lucas) [#10296](https://github.com/nodejs/node/pull/10296)

### Commits

* [[`d532d7497a`](https://github.com/nodejs/node/commit/d532d7497a)] - **async_wrap**: clear destroy_ids vector (Trevor Norris) [#10400](https://github.com/nodejs/node/pull/10400)
* [[`75d6f111aa`](https://github.com/nodejs/node/commit/75d6f111aa)] - **benchmark**: refactor buffer benchmarks (Troy Connor) [#10175](https://github.com/nodejs/node/pull/10175)
* [[`40c7ec62e0`](https://github.com/nodejs/node/commit/40c7ec62e0)] - **buffer**: fix single-character string filling (Anna Henningsen) [#9837](https://github.com/nodejs/node/pull/9837)
* [[`03f0d2ac21`](https://github.com/nodejs/node/commit/03f0d2ac21)] - **buffer**: handle UCS2 `.fill()` properly on BE (Anna Henningsen) [#9837](https://github.com/nodejs/node/pull/9837)
* [[`9e76350372`](https://github.com/nodejs/node/commit/9e76350372)] - **build**: add /opt/freeware/... to AIX library path (Stewart X Addison) [#10128](https://github.com/nodejs/node/pull/10128)
* [[`7d519fa87c`](https://github.com/nodejs/node/commit/7d519fa87c)] - **build**: add (not) cross-compiled configure flags (Jesús Leganés-Combarro 'piranna) [#10287](https://github.com/nodejs/node/pull/10287)
* [[`a2f02859b0`](https://github.com/nodejs/node/commit/a2f02859b0)] - **(SEMVER-MINOR)** **crypto**: allow adding extra certs to well-known CAs (Sam Roberts) [#9139](https://github.com/nodejs/node/pull/9139)
* [[`4e1a5a71c1`](https://github.com/nodejs/node/commit/4e1a5a71c1)] - **crypto**: fix handling of root_cert_store. (Adam Langley) [#9409](https://github.com/nodejs/node/pull/9409)
* [[`8c6ecce743`](https://github.com/nodejs/node/commit/8c6ecce743)] - **crypto**: Use reference count to manage cert_store (Adam Majer) [#9409](https://github.com/nodejs/node/pull/9409)
* [[`8bccd9ed67`](https://github.com/nodejs/node/commit/8bccd9ed67)] - **debugger**: call `this.resume()` after `this.run()` (Lance Ball) [#10099](https://github.com/nodejs/node/pull/10099)
* [[`2a39d1c7a4`](https://github.com/nodejs/node/commit/2a39d1c7a4)] - **deps**: backport 7c3748a from upstream V8 (Cristian Cavalli) [#10881](https://github.com/nodejs/node/pull/10881)
* [[`5c5f5fb415`](https://github.com/nodejs/node/commit/5c5f5fb415)] - **deps**: backport 224d376 from V8 upstream (jBarz) [#10546](https://github.com/nodejs/node/pull/10546)
* [[`687137eced`](https://github.com/nodejs/node/commit/687137eced)] - **deps**: ICU 58.2 bump download URL (Steven R. Loomis) [#10206](https://github.com/nodejs/node/pull/10206)
* [[`ae477b7b62`](https://github.com/nodejs/node/commit/ae477b7b62)] - **deps**: ICU 58.2 bump (Steven R. Loomis) [#10206](https://github.com/nodejs/node/pull/10206)
* [[`ad807ad29b`](https://github.com/nodejs/node/commit/ad807ad29b)] - **(SEMVER-MINOR)** **deps**: Intl: ICU 58 bump - small icu (BIG COMMIT) (Steven R. Loomis) [#9234](https://github.com/nodejs/node/pull/9234)
* [[`0ee665c4ed`](https://github.com/nodejs/node/commit/0ee665c4ed)] - **(SEMVER-MINOR)** **deps**: Intl: ICU 58 bump: configure/LICENSE/docs (Steven R. Loomis) [#9234](https://github.com/nodejs/node/pull/9234)
* [[`4197b9b041`](https://github.com/nodejs/node/commit/4197b9b041)] - **deps**: update patch level in V8 (Myles Borins) [#10666](https://github.com/nodejs/node/pull/10666)
* [[`e71129ebbc`](https://github.com/nodejs/node/commit/e71129ebbc)] - **deps**: cherry-pick a715957 from V8 upstream (Myles Borins) [#10666](https://github.com/nodejs/node/pull/10666)
* [[`87839ca036`](https://github.com/nodejs/node/commit/87839ca036)] - **deps**: cherry-pick 7a88ff3 from V8 upstream (Myles Borins) [#10666](https://github.com/nodejs/node/pull/10666)
* [[`13983d474a`](https://github.com/nodejs/node/commit/13983d474a)] - **deps**: cherry-pick d800a65 from V8 upstream (Myles Borins) [#10666](https://github.com/nodejs/node/pull/10666)
* [[`f77fcf893f`](https://github.com/nodejs/node/commit/f77fcf893f)] - **deps**: cherry-pick baba152 from V8 upstream (Michaël Zasso) [#10689](https://github.com/nodejs/node/pull/10689)
* [[`fdc373d639`](https://github.com/nodejs/node/commit/fdc373d639)] - **deps**: fix compile bug in v8/lookup.h (Matthew Avery) [#10525](https://github.com/nodejs/node/pull/10525)
* [[`055f666065`](https://github.com/nodejs/node/commit/055f666065)] - **doc**: change logical to bitwise OR in dns lookup (Sakthipriyan Vairamani (thefourtheye)) [#11037](https://github.com/nodejs/node/pull/11037)
* [[`78b83e7249`](https://github.com/nodejs/node/commit/78b83e7249)] - **doc**: killSignal option accepts integer values (Sakthipriyan Vairamani (thefourtheye)) [#10424](https://github.com/nodejs/node/pull/10424)
* [[`76e6e7ef55`](https://github.com/nodejs/node/commit/76e6e7ef55)] - **doc**: correct vcbuild options for windows testing (Jonathan Boarman) [#10686](https://github.com/nodejs/node/pull/10686)
* [[`50c2ecdf0e`](https://github.com/nodejs/node/commit/50c2ecdf0e)] - **doc**: replace newlines in deprecation with space (Sakthipriyan Vairamani (thefourtheye)) [#11074](https://github.com/nodejs/node/pull/11074)
* [[`15df5c08ea`](https://github.com/nodejs/node/commit/15df5c08ea)] - **doc**: fix changelog for v6 (Myles Borins) [#11090](https://github.com/nodejs/node/pull/11090)
* [[`03302d6133`](https://github.com/nodejs/node/commit/03302d6133)] - **doc**: add joyeecheung to collaborators (Joyee Cheung) [#10603](https://github.com/nodejs/node/pull/10603)
* [[`447287c432`](https://github.com/nodejs/node/commit/447287c432)] - **doc**: unify dirname and filename description (Sam Roberts) [#10527](https://github.com/nodejs/node/pull/10527)
* [[`c3882f4d8b`](https://github.com/nodejs/node/commit/c3882f4d8b)] - **doc**: warn about unvalidated input in child_process (Matthew Garrett) [#10466](https://github.com/nodejs/node/pull/10466)
* [[`11d8f2439b`](https://github.com/nodejs/node/commit/11d8f2439b)] - **doc**: require two-factor authentication (Rich Trott) [#10529](https://github.com/nodejs/node/pull/10529)
* [[`017764018c`](https://github.com/nodejs/node/commit/017764018c)] - **doc**: use "Node.js" in V8 guide (Rich Trott) [#10438](https://github.com/nodejs/node/pull/10438)
* [[`636335a1c3`](https://github.com/nodejs/node/commit/636335a1c3)] - **doc**: require() tries first core not native modules (Vicente Jimenez Aguilar) [#10324](https://github.com/nodejs/node/pull/10324)
* [[`f7c0eb8ba6`](https://github.com/nodejs/node/commit/f7c0eb8ba6)] - **doc**: clarify the review and landing process (Joyee Cheung) [#10202](https://github.com/nodejs/node/pull/10202)
* [[`b814b4cec7`](https://github.com/nodejs/node/commit/b814b4cec7)] - **doc**: update writable.write return value (Tanuja-Sawant) [#9468](https://github.com/nodejs/node/pull/9468)
* [[`3079ba6e78`](https://github.com/nodejs/node/commit/3079ba6e78)] - **doc**: redirect 'Start a Working Group' to TSC repo (William Kapke) [#9655](https://github.com/nodejs/node/pull/9655)
* [[`8dbba48f70`](https://github.com/nodejs/node/commit/8dbba48f70)] - **doc**: add Working Group dissolution text (William Kapke) [#9656](https://github.com/nodejs/node/pull/9656)
* [[`1dc7b8918d`](https://github.com/nodejs/node/commit/1dc7b8918d)] - **doc**: fixup errors in stream.md (Fumiya KARASAWA) [#10411](https://github.com/nodejs/node/pull/10411)
* [[`c2156fcba1`](https://github.com/nodejs/node/commit/c2156fcba1)] - **doc**: more efficient example in the console.md (Vse Mozhet Byt) [#10451](https://github.com/nodejs/node/pull/10451)
* [[`809ae9da29`](https://github.com/nodejs/node/commit/809ae9da29)] - **doc**: var -> const / let in the console.md (Vse Mozhet Byt) [#10451](https://github.com/nodejs/node/pull/10451)
* [[`3f289a3efe`](https://github.com/nodejs/node/commit/3f289a3efe)] - **doc**: improve common.mustCall() explanation (Rich Trott) [#10390](https://github.com/nodejs/node/pull/10390)
* [[`59aa4e9e29`](https://github.com/nodejs/node/commit/59aa4e9e29)] - **doc**: consistent 'Returns:' part two (Myles Borins) [#10391](https://github.com/nodejs/node/pull/10391)
* [[`54dec23aba`](https://github.com/nodejs/node/commit/54dec23aba)] - **doc**: clarify macosx-firewall suggestion BUILDING (Chase Starr) [#10311](https://github.com/nodejs/node/pull/10311)
* [[`c9c9b5c47e`](https://github.com/nodejs/node/commit/c9c9b5c47e)] - **doc**: modernize code examples in the cluster.md (Vse Mozhet Byt) [#10270](https://github.com/nodejs/node/pull/10270)
* [[`540ff7c123`](https://github.com/nodejs/node/commit/540ff7c123)] - **doc**: add Michaël Zasso to the CTC (Michaël Zasso)
* [[`c95adab452`](https://github.com/nodejs/node/commit/c95adab452)] - **doc**: fix broken link in COLLABORATOR_GUIDE.md (Emanuel Buholzer) [#10337](https://github.com/nodejs/node/pull/10337)
* [[`24bf75309a`](https://github.com/nodejs/node/commit/24bf75309a)] - **doc**: fix typo in ecdhCurve, a tls property name (Sam Roberts) [#10345](https://github.com/nodejs/node/pull/10345)
* [[`2eccea06b5`](https://github.com/nodejs/node/commit/2eccea06b5)] - **doc**: expand common module material in test guide (Rich Trott) [#10251](https://github.com/nodejs/node/pull/10251)
* [[`843d4557e2`](https://github.com/nodejs/node/commit/843d4557e2)] - **doc**: fix broken link in COLLABORATOR_GUIDE.md (Michael Dawson) [#10267](https://github.com/nodejs/node/pull/10267)
* [[`b662de6301`](https://github.com/nodejs/node/commit/b662de6301)] - **doc**: rework tls for accuracy and clarity (Sam Roberts) [#9800](https://github.com/nodejs/node/pull/9800)
* [[`e53262cda9`](https://github.com/nodejs/node/commit/e53262cda9)] - **doc**: modernize child_process example code (Vse Mozhet Byt) [#10102](https://github.com/nodejs/node/pull/10102)
* [[`9988f02025`](https://github.com/nodejs/node/commit/9988f02025)] - **doc**: fix typo in code example of 'path' module (pallxk) [#10136](https://github.com/nodejs/node/pull/10136)
* [[`718b5902bc`](https://github.com/nodejs/node/commit/718b5902bc)] - **doc**: standardizing on make -j4 (Jonathan Darling) [#9961](https://github.com/nodejs/node/pull/9961)
* [[`5b6317b10f`](https://github.com/nodejs/node/commit/5b6317b10f)] - **doc**: add note to parallelize make (Jonathan Darling) [#9961](https://github.com/nodejs/node/pull/9961)
* [[`7815efa5c1`](https://github.com/nodejs/node/commit/7815efa5c1)] - **doc**: add some info on `tty#setRawMode()` (Jeremiah Senkpiel) [#10147](https://github.com/nodejs/node/pull/10147)
* [[`639ef411b4`](https://github.com/nodejs/node/commit/639ef411b4)] - **doc**: update `path.format` description and examples (anoff) [#10046](https://github.com/nodejs/node/pull/10046)
* [[`e6c74b37b3`](https://github.com/nodejs/node/commit/e6c74b37b3)] - **fs**: remove needless assignment of null (Francis Gulotta) [#10260](https://github.com/nodejs/node/pull/10260)
* [[`709b9b4660`](https://github.com/nodejs/node/commit/709b9b4660)] - **fs**: cache non-symlinks in realpathSync. (Jeremy Yallop) [#10253](https://github.com/nodejs/node/pull/10253)
* [[`b5f747187d`](https://github.com/nodejs/node/commit/b5f747187d)] - **http**: remove stale timeout listeners (Karl Böhlmark) [#9440](https://github.com/nodejs/node/pull/9440)
* [[`90bd36bd15`](https://github.com/nodejs/node/commit/90bd36bd15)] - **inspector**: check if connected before waiting (Eugene Ostroukhov) [#10094](https://github.com/nodejs/node/pull/10094)
* [[`5ddd508304`](https://github.com/nodejs/node/commit/5ddd508304)] - **lib,test**: use consistent operator linebreak style (Michaël Zasso) [#10178](https://github.com/nodejs/node/pull/10178)
* [[`3eb9373095`](https://github.com/nodejs/node/commit/3eb9373095)] - **os**: fix os.release() for aix and add test (jBarz) [#10245](https://github.com/nodejs/node/pull/10245)
* [[`8ea4487ca7`](https://github.com/nodejs/node/commit/8ea4487ca7)] - **(SEMVER-MINOR)** **process**: add `process.memoryUsage.external` (Fedor Indutny) [#9587](https://github.com/nodejs/node/pull/9587)
* [[`6f8b32e754`](https://github.com/nodejs/node/commit/6f8b32e754)] - **promise**: better stack traces for --trace-warnings (Anna Henningsen) [#9525](https://github.com/nodejs/node/pull/9525)
* [[`1d400ea484`](https://github.com/nodejs/node/commit/1d400ea484)] - ***Revert*** "**repl**: disable Ctrl+C support on win32 for now" (Anna Henningsen) [#8645](https://github.com/nodejs/node/pull/8645)
* [[`57c4c6f5ae`](https://github.com/nodejs/node/commit/57c4c6f5ae)] - **repl**: allow autocompletion for scoped packages (Evan Lucas) [#10296](https://github.com/nodejs/node/pull/10296)
* [[`5e07bce166`](https://github.com/nodejs/node/commit/5e07bce166)] - **(SEMVER-MINOR)** **src**: add wrapper for process.emitWarning() (Sam Roberts) [#9139](https://github.com/nodejs/node/pull/9139)
* [[`7da06088eb`](https://github.com/nodejs/node/commit/7da06088eb)] - **src**: describe what NODE_MODULE_VERSION is for (Sam Roberts) [#10414](https://github.com/nodejs/node/pull/10414)
* [[`7897e7685f`](https://github.com/nodejs/node/commit/7897e7685f)] - **src**: fix string format mistake for 32 bit node (Alex Newman) [#10082](https://github.com/nodejs/node/pull/10082)
* [[`cfa1b5a9e7`](https://github.com/nodejs/node/commit/cfa1b5a9e7)] - **src**: fix memory leak introduced in 34febfbf4 (Ben Noordhuis) [#9604](https://github.com/nodejs/node/pull/9604)
* [[`cc0c736bcc`](https://github.com/nodejs/node/commit/cc0c736bcc)] - **src,tools**: speed up startup by 2.5% (Ben Noordhuis) [#5458](https://github.com/nodejs/node/pull/5458)
* [[`9a8416258d`](https://github.com/nodejs/node/commit/9a8416258d)] - **stream, test**: test _readableState.emittedReadable (Joyee Cheung) [#10249](https://github.com/nodejs/node/pull/10249)
* [[`f9227fe944`](https://github.com/nodejs/node/commit/f9227fe944)] - **stream_base**: homogenize req_wrap_obj use (Fedor Indutny) [#10184](https://github.com/nodejs/node/pull/10184)
* [[`8f00f70d19`](https://github.com/nodejs/node/commit/8f00f70d19)] - **test**: fix test.py command line options processing (Julien Gilli) [#11153](https://github.com/nodejs/node/pull/11153)
* [[`fce1d10153`](https://github.com/nodejs/node/commit/fce1d10153)] - **test**: add --abort-on-timeout option to test.py (Julien Gilli) [#11086](https://github.com/nodejs/node/pull/11086)
* [[`1c6e171de9`](https://github.com/nodejs/node/commit/1c6e171de9)] - **test**: add tests for clearBuffer state machine (Safia Abdalla) [#9922](https://github.com/nodejs/node/pull/9922)
* [[`8ede25964b`](https://github.com/nodejs/node/commit/8ede25964b)] - **test**: update test-cluster-shared-handle-bind-error (cjihrig) [#10547](https://github.com/nodejs/node/pull/10547)
* [[`e34af8d647`](https://github.com/nodejs/node/commit/e34af8d647)] - **test**: avoid assigning this to variables (cjihrig) [#10548](https://github.com/nodejs/node/pull/10548)
* [[`c07cfc83e4`](https://github.com/nodejs/node/commit/c07cfc83e4)] - **test**: improve test-http-allow-req-after-204-res (Adrian Estrada) [#10503](https://github.com/nodejs/node/pull/10503)
* [[`e067c48889`](https://github.com/nodejs/node/commit/e067c48889)] - **test**: improve test-fs-empty-readStream.js (Adrian Estrada) [#10479](https://github.com/nodejs/node/pull/10479)
* [[`aca927e928`](https://github.com/nodejs/node/commit/aca927e928)] - **test**: refactor test-stream-pipe-after-end (Rich Trott) [#10483](https://github.com/nodejs/node/pull/10483)
* [[`82f4a33359`](https://github.com/nodejs/node/commit/82f4a33359)] - **test**: use strictEqual in test-http-server (Fabrice Tatieze) [#10478](https://github.com/nodejs/node/pull/10478)
* [[`683b060050`](https://github.com/nodejs/node/commit/683b060050)] - **test**: refactor test-stream2-unpipe-drain (Chris Story) [#10033](https://github.com/nodejs/node/pull/10033)
* [[`f1dea3fa41`](https://github.com/nodejs/node/commit/f1dea3fa41)] - **test**: add test for SIGWINCH handling by stdio.js (Sarah Meyer) [#10063](https://github.com/nodejs/node/pull/10063)
* [[`c5ccffd387`](https://github.com/nodejs/node/commit/c5ccffd387)] - **test**: improve code in test-vm-preserves-property (Adrian Estrada) [#10428](https://github.com/nodejs/node/pull/10428)
* [[`c9ca82e58e`](https://github.com/nodejs/node/commit/c9ca82e58e)] - **test**: basic functionality of readUIntLE() (larissayvette) [#10359](https://github.com/nodejs/node/pull/10359)
* [[`b1f2aeb801`](https://github.com/nodejs/node/commit/b1f2aeb801)] - **test**: fix flaky test-https-timeout (Rich Trott) [#10404](https://github.com/nodejs/node/pull/10404)
* [[`9546ad7d4d`](https://github.com/nodejs/node/commit/9546ad7d4d)] - **test**: basic functionality of readUIntBE() (larissayvette) [#10417](https://github.com/nodejs/node/pull/10417)
* [[`b0adda0335`](https://github.com/nodejs/node/commit/b0adda0335)] - **test**: improve test-cluster-worker-constructor.js (Adrian Estrada) [#10396](https://github.com/nodejs/node/pull/10396)
* [[`d37443ca8d`](https://github.com/nodejs/node/commit/d37443ca8d)] - **test**: add known_issues test for #5350 (AnnaMag) [#10319](https://github.com/nodejs/node/pull/10319)
* [[`959860f55c`](https://github.com/nodejs/node/commit/959860f55c)] - **test**: stream readable resumeScheduled state (Italo A. Casas) [#10299](https://github.com/nodejs/node/pull/10299)
* [[`c604016cb4`](https://github.com/nodejs/node/commit/c604016cb4)] - **test**: add known_issues test for #6287 (AnnaMag) [#10272](https://github.com/nodejs/node/pull/10272)
* [[`a24a35f668`](https://github.com/nodejs/node/commit/a24a35f668)] - **test**: stream readable needReadable state (Joyee Cheung) [#10241](https://github.com/nodejs/node/pull/10241)
* [[`8d2f722541`](https://github.com/nodejs/node/commit/8d2f722541)] - **test**: clean up domain-no-error-handler test (weyj4) [#10291](https://github.com/nodejs/node/pull/10291)
* [[`c5ef631fdc`](https://github.com/nodejs/node/commit/c5ef631fdc)] - **test**: update test-domain-uncaught-exception.js (Andy Chen) [#10193](https://github.com/nodejs/node/pull/10193)
* [[`4b5587c5db`](https://github.com/nodejs/node/commit/4b5587c5db)] - **test**: refactor test-domain.js (Siddhartha Sahai) [#10207](https://github.com/nodejs/node/pull/10207)
* [[`99ba710bca`](https://github.com/nodejs/node/commit/99ba710bca)] - **test**: fail for missing output files (Anna Henningsen) [#10150](https://github.com/nodejs/node/pull/10150)
* [[`25d6eed654`](https://github.com/nodejs/node/commit/25d6eed654)] - **test**: stream readableState readingMore state (Gregory) [#9868](https://github.com/nodejs/node/pull/9868)
* [[`f3d1b7209d`](https://github.com/nodejs/node/commit/f3d1b7209d)] - **test**: s/ASSERT/assert/ (cjihrig) [#10544](https://github.com/nodejs/node/pull/10544)
* [[`9cee6786f7`](https://github.com/nodejs/node/commit/9cee6786f7)] - **test**: refactor test-stream-unshift-read-race (Rich Trott) [#10532](https://github.com/nodejs/node/pull/10532)
* [[`19b3015201`](https://github.com/nodejs/node/commit/19b3015201)] - **test**: refactor test-stream-pipe-error-handling (Rich Trott) [#10530](https://github.com/nodejs/node/pull/10530)
* [[`33c47a6415`](https://github.com/nodejs/node/commit/33c47a6415)] - **test**: refactor test-tls-alert-handling (Rich Trott) [#10482](https://github.com/nodejs/node/pull/10482)
* [[`1a7ca46544`](https://github.com/nodejs/node/commit/1a7ca46544)] - **test**: fix flaky test-http-client-timeout-with-data (Rich Trott) [#10431](https://github.com/nodejs/node/pull/10431)
* [[`328c14512f`](https://github.com/nodejs/node/commit/328c14512f)] - **test**: refactor the code in test-http-connect (Adrian Estrada) [#10397](https://github.com/nodejs/node/pull/10397)
* [[`99c9cda6d1`](https://github.com/nodejs/node/commit/99c9cda6d1)] - **test**: refactor test-stdin-from-file (Rob Adelmann) [#10331](https://github.com/nodejs/node/pull/10331)
* [[`38d9c15edd`](https://github.com/nodejs/node/commit/38d9c15edd)] - **test**: refactor the code in test-dns-ipv4 (Adrian Estrada) [#10200](https://github.com/nodejs/node/pull/10200)
* [[`4f18943810`](https://github.com/nodejs/node/commit/4f18943810)] - **test**: refactor the code in test-fs-chmod (Adrian Estrada) [#10440](https://github.com/nodejs/node/pull/10440)
* [[`d89587c1bf`](https://github.com/nodejs/node/commit/d89587c1bf)] - **test**: swap var for let/const throughout (Paul Graham) [#10177](https://github.com/nodejs/node/pull/10177)
* [[`d2ce3909b1`](https://github.com/nodejs/node/commit/d2ce3909b1)] - **test**: improve the code in test-pipe.js (Adrian Estrada) [#10452](https://github.com/nodejs/node/pull/10452)
* [[`3c642ee2ce`](https://github.com/nodejs/node/commit/3c642ee2ce)] - **test**: improve code in test-fs-readfile-error (Adrian Estrada) [#10367](https://github.com/nodejs/node/pull/10367)
* [[`f1075a1726`](https://github.com/nodejs/node/commit/f1075a1726)] - **test**: improve code in test-vm-symbols (Adrian Estrada) [#10429](https://github.com/nodejs/node/pull/10429)
* [[`5f18f0c448`](https://github.com/nodejs/node/commit/5f18f0c448)] - **test**: fix and improve debug-break-on-uncaught (Sakthipriyan Vairamani (thefourtheye)) [#10370](https://github.com/nodejs/node/pull/10370)
* [[`12d86aba49`](https://github.com/nodejs/node/commit/12d86aba49)] - **test**: refactor test-init.js (Sakthipriyan Vairamani (thefourtheye)) [#10384](https://github.com/nodejs/node/pull/10384)
* [[`6370cbe9dc`](https://github.com/nodejs/node/commit/6370cbe9dc)] - **test**: refactor code in test-cluster-http-pipe (Adrian Estrada) [#10297](https://github.com/nodejs/node/pull/10297)
* [[`781d04a1b3`](https://github.com/nodejs/node/commit/781d04a1b3)] - **test**: improve code in test-http-bind-twice.js (Adrian Estrada) [#10318](https://github.com/nodejs/node/pull/10318)
* [[`390cab8d1a`](https://github.com/nodejs/node/commit/390cab8d1a)] - **test**: change var declarations, add mustCall check (Daniel Sims) [#9962](https://github.com/nodejs/node/pull/9962)
* [[`e60be9ccc3`](https://github.com/nodejs/node/commit/e60be9ccc3)] - **test**: refactor test-stdin-script-child (Emanuel Buholzer) [#10321](https://github.com/nodejs/node/pull/10321)
* [[`8b44fb30a1`](https://github.com/nodejs/node/commit/8b44fb30a1)] - **test**: fix timers-same-timeout-wrong-list-deleted (Rich Trott) [#10362](https://github.com/nodejs/node/pull/10362)
* [[`1b9c125325`](https://github.com/nodejs/node/commit/1b9c125325)] - **test**: refactor test-stream2-writable (Rich Trott) [#10353](https://github.com/nodejs/node/pull/10353)
* [[`4cf11d9f4a`](https://github.com/nodejs/node/commit/4cf11d9f4a)] - **test**: refactor test-cluster-net-listen (Segu Riluvan) [#10047](https://github.com/nodejs/node/pull/10047)
* [[`0e5ef4164d`](https://github.com/nodejs/node/commit/0e5ef4164d)] - **test**: change assert.strict to assert.strictEqual() (Ashita Nagesh) [#9988](https://github.com/nodejs/node/pull/9988)
* [[`37ced4d324`](https://github.com/nodejs/node/commit/37ced4d324)] - **test**: refactor the code in test-http-keep-alive (Adrian Estrada) [#10350](https://github.com/nodejs/node/pull/10350)
* [[`61105d75fb`](https://github.com/nodejs/node/commit/61105d75fb)] - **test**: use strictEqual in test-cwd-enoent-repl.js (Neeraj Sharma) [#9952](https://github.com/nodejs/node/pull/9952)
* [[`40c55e73be`](https://github.com/nodejs/node/commit/40c55e73be)] - **test**: refactor test-net-reconnect-error (Duy Le) [#9903](https://github.com/nodejs/node/pull/9903)
* [[`0c31802ea9`](https://github.com/nodejs/node/commit/0c31802ea9)] - **test**: add test-require-invalid-package (Duy Le) [#9903](https://github.com/nodejs/node/pull/9903)
* [[`c706a92373`](https://github.com/nodejs/node/commit/c706a92373)] - **test**: refactor test-child-process-kill (Duy Le) [#9903](https://github.com/nodejs/node/pull/9903)
* [[`d7a36fc2da`](https://github.com/nodejs/node/commit/d7a36fc2da)] - **test**: use consistent block spacing (Rich Trott) [#10377](https://github.com/nodejs/node/pull/10377)
* [[`03bf87c703`](https://github.com/nodejs/node/commit/03bf87c703)] - **test**: refactor test-timers-this (Rich Trott) [#10315](https://github.com/nodejs/node/pull/10315)
* [[`8792fb1788`](https://github.com/nodejs/node/commit/8792fb1788)] - **test**: improve code in test-fs-open.js (Adrian Estrada) [#10312](https://github.com/nodejs/node/pull/10312)
* [[`d8405da44c`](https://github.com/nodejs/node/commit/d8405da44c)] - **test**: refactor the code in test-dns-ipv6 (Adrian Estrada) [#10219](https://github.com/nodejs/node/pull/10219)
* [[`a18f72d8d2`](https://github.com/nodejs/node/commit/a18f72d8d2)] - **test**: improve test-child-process-fork-and-spawn (Adrian Estrada) [#10273](https://github.com/nodejs/node/pull/10273)
* [[`4cba20c1c8`](https://github.com/nodejs/node/commit/4cba20c1c8)] - **test**: fix flaky test-http-client-timeout-event (Rich Trott) [#10293](https://github.com/nodejs/node/pull/10293)
* [[`70f70478de`](https://github.com/nodejs/node/commit/70f70478de)] - **test**: improve test-child-process-exec-buffer (Adrian Estrada) [#10275](https://github.com/nodejs/node/pull/10275)
* [[`3a6fdd805d`](https://github.com/nodejs/node/commit/3a6fdd805d)] - **test**: refactor test-fs-read-stream-inherit (Rich Trott) [#10246](https://github.com/nodejs/node/pull/10246)
* [[`92e3f8f26e`](https://github.com/nodejs/node/commit/92e3f8f26e)] - **test**: refactor test-dgram-send-callback-multi-buffer (mfrance) [#9999](https://github.com/nodejs/node/pull/9999)
* [[`5ff6011cec`](https://github.com/nodejs/node/commit/5ff6011cec)] - **test**: refactor test-tls-ecdh-disable (Aaron Williams) [#9989](https://github.com/nodejs/node/pull/9989)
* [[`be3334709d`](https://github.com/nodejs/node/commit/be3334709d)] - **test**: fix http-client-timeout-option-listeners (Rich Trott) [#10224](https://github.com/nodejs/node/pull/10224)
* [[`713f04ce1d`](https://github.com/nodejs/node/commit/713f04ce1d)] - **test**: refactor test-stream-big-push (Rich Trott) [#10226](https://github.com/nodejs/node/pull/10226)
* [[`373755cad0`](https://github.com/nodejs/node/commit/373755cad0)] - **test**: refactor test-http-dns-fail (Adrian Estrada) [#10243](https://github.com/nodejs/node/pull/10243)
* [[`2f64d5a294`](https://github.com/nodejs/node/commit/2f64d5a294)] - **test**: refactor test-crypto-random (Rich Trott) [#10232](https://github.com/nodejs/node/pull/10232)
* [[`70e4fb8ca1`](https://github.com/nodejs/node/commit/70e4fb8ca1)] - **test**: refactor test-http-pause-resume-one-end (Rich Trott) [#10210](https://github.com/nodejs/node/pull/10210)
* [[`b0a5a3bb70`](https://github.com/nodejs/node/commit/b0a5a3bb70)] - **test**: fix flaky test-dgram-exclusive-implicit-bind (Rich Trott) [#10212](https://github.com/nodejs/node/pull/10212)
* [[`e3f926594e`](https://github.com/nodejs/node/commit/e3f926594e)] - **test**: improvements in test fixtures symlinked (Adrian Estrada) [#10182](https://github.com/nodejs/node/pull/10182)
* [[`217e2c6fcf`](https://github.com/nodejs/node/commit/217e2c6fcf)] - **test**: refactor test-fs-fsync (Rob Adelmann) [#10176](https://github.com/nodejs/node/pull/10176)
* [[`10747f4102`](https://github.com/nodejs/node/commit/10747f4102)] - **test**: refactor test-http-after-connect.js (larissayvette) [#10229](https://github.com/nodejs/node/pull/10229)
* [[`0b243ca178`](https://github.com/nodejs/node/commit/0b243ca178)] - **test**: refactor assert.equal, update syntax to ES6 (Prieto, Marcos)
* [[`c57d72089f`](https://github.com/nodejs/node/commit/c57d72089f)] - **test**: refactor http pipelined socket test (Rich Trott) [#10189](https://github.com/nodejs/node/pull/10189)
* [[`3f17c180be`](https://github.com/nodejs/node/commit/3f17c180be)] - **test**: var to const in tls-no-cert-required (Sam Roberts) [#9800](https://github.com/nodejs/node/pull/9800)
* [[`6b8d4cab41`](https://github.com/nodejs/node/commit/6b8d4cab41)] - **test**: tls key/cert ordering not necessary (Sam Roberts) [#9800](https://github.com/nodejs/node/pull/9800)
* [[`b2b2774325`](https://github.com/nodejs/node/commit/b2b2774325)] - **test**: refactor test-handle-wrap-close-abort (Rich Trott) [#10188](https://github.com/nodejs/node/pull/10188)
* [[`c65dfa9b12`](https://github.com/nodejs/node/commit/c65dfa9b12)] - **test**: add ES6 and strictEqual to test-fs-truncate (Adrian Estrada) [#10167](https://github.com/nodejs/node/pull/10167)
* [[`951ddb3d53`](https://github.com/nodejs/node/commit/951ddb3d53)] - **test**: improving crypto fips (James Tenenbaum) [#10002](https://github.com/nodejs/node/pull/10002)
* [[`a75883ec7c`](https://github.com/nodejs/node/commit/a75883ec7c)] - **test**: stream readableListening internal state (Italo A. Casas) [#9864](https://github.com/nodejs/node/pull/9864)
* [[`56a512f7be`](https://github.com/nodejs/node/commit/56a512f7be)] - **test**: check for error on invalid signal (Matt Phillips) [#10026](https://github.com/nodejs/node/pull/10026)
* [[`8e7f150a8e`](https://github.com/nodejs/node/commit/8e7f150a8e)] - **test**: refactor test-http-unix-socket (davidmarkclements) [#10072](https://github.com/nodejs/node/pull/10072)
* [[`717b4b4e8a`](https://github.com/nodejs/node/commit/717b4b4e8a)] - **test**: increase test coverage of BufferList (joyeecheung) [#10171](https://github.com/nodejs/node/pull/10171)
* [[`a56b22e881`](https://github.com/nodejs/node/commit/a56b22e881)] - **test**: fix flaky test-net-socket-timeout (Rich Trott) [#10172](https://github.com/nodejs/node/pull/10172)
* [[`58c5bdc57c`](https://github.com/nodejs/node/commit/58c5bdc57c)] - **test**: refactor test-net-keepalive.js (Kyle Corsi) [#9995](https://github.com/nodejs/node/pull/9995)
* [[`b868ce6763`](https://github.com/nodejs/node/commit/b868ce6763)] - **timers**: fix handling of cleared immediates (hveldstra) [#9759](https://github.com/nodejs/node/pull/9759)
* [[`95a0a67ff3`](https://github.com/nodejs/node/commit/95a0a67ff3)] - **tls**: do not refer to secureOptions as flags (Sam Roberts) [#9800](https://github.com/nodejs/node/pull/9800)
* [[`d50e8d8af9`](https://github.com/nodejs/node/commit/d50e8d8af9)] - **tls**: document and test option-less createServer (Sam Roberts) [#9800](https://github.com/nodejs/node/pull/9800)
* [[`89db5fcc23`](https://github.com/nodejs/node/commit/89db5fcc23)] - **tls**: fix/annotate connect arg comments (Sam Roberts) [#9800](https://github.com/nodejs/node/pull/9800)
* [[`20665f408b`](https://github.com/nodejs/node/commit/20665f408b)] - **tools**: enable block-spacing rule in .eslintrc (Rich Trott) [#10377](https://github.com/nodejs/node/pull/10377)
* [[`e8effa434e`](https://github.com/nodejs/node/commit/e8effa434e)] - **tools**: enforce consistent operator linebreak style (Michaël Zasso) [#10178](https://github.com/nodejs/node/pull/10178)
* [[`0162908708`](https://github.com/nodejs/node/commit/0162908708)] - **tools**: add macosx-firwall script to avoid popups (Daniel Bevenius) [#10114](https://github.com/nodejs/node/pull/10114)
* [[`3ac9e01faa`](https://github.com/nodejs/node/commit/3ac9e01faa)] - **url**: add a got host pattern in url.js (Axel Monroy) [#9653](https://github.com/nodejs/node/pull/9653)
* [[`9eaf2e9517`](https://github.com/nodejs/node/commit/9eaf2e9517)] - **watchdog**: add flag to mark handler as disabled (Bartosz Sosnowski) [#10248](https://github.com/nodejs/node/pull/10248)
* [[`969dcab5aa`](https://github.com/nodejs/node/commit/969dcab5aa)] - **win,msi**: add required UIRef for localized strings (Bill Ticehurst) [#8884](https://github.com/nodejs/node/pull/8884)

<a id="6.9.5"></a>
## 2017-01-31, Version 6.9.5 'Boron' (LTS), @MylesBorins

This is a security release of the 'Boron' release line to upgrade OpenSSL to version 1.0.2k

Although the OpenSSL team have determined a maximum severity rating of "moderate", the Node.js
crypto team (Ben Noordhuis, Shigeki Ohtsu and Fedor Indutny) have determined the impact to Node
users is "low". Details on this determination can be found
[on the Nodejs.org website](https://nodejs.org/en/blog/vulnerability/openssl-january-2017/).

### Notable Changes

* **deps**: upgrade openssl sources to 1.0.2k (Shigeki Ohtsu) [#11021](https://github.com/nodejs/node/pull/11021)

### Commits

* [[`87ac44974a`](https://github.com/nodejs/node/commit/87ac44974a)] - **deps**: update openssl asm and asm_obsolete files (Shigeki Ohtsu) [#11021](https://github.com/nodejs/node/pull/11021)
* [[`a4b43a7ef9`](https://github.com/nodejs/node/commit/a4b43a7ef9)] - **deps**: add -no_rand_screen to openssl s_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`f5b77fdf8d`](https://github.com/nodejs/node/commit/f5b77fdf8d)] - **deps**: fix asm build error of openssl in x86_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`58fae148fa`](https://github.com/nodejs/node/commit/58fae148fa)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`d623e8c5b9`](https://github.com/nodejs/node/commit/d623e8c5b9)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu) [#11021](https://github.com/nodejs/node/pull/11021)
* [[`3f2bef60b8`](https://github.com/nodejs/node/commit/3f2bef60b8)] - **deps**: upgrade openssl sources to 1.0.2k (Shigeki Ohtsu) [#11021](https://github.com/nodejs/node/pull/11021)
* [[`c4678d2f9a`](https://github.com/nodejs/node/commit/c4678d2f9a)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)

<a id="6.9.4"></a>
## 2017-01-05, Version 6.9.4 'Boron' (LTS), @MylesBorins

This is a special release that contains 0 commits. While promoting additional
platforms for v6.9.3 after the release, the tarballs on the release server were
overwritten and now have different shasums. In order to remove any ambiguity
around the release we have opted to do a semver patch release with no changes.

### Notable Changes

N/A

### Commits

N/A

<a id="6.9.3"></a>
## 2017-01-03, Version 6.9.3 'Boron' (LTS), @MylesBorins

This LTS release comes with 312 commits. This includes 229 that are test related,
62 that are docs related, 17 which are build / tools related, and 4 commits which
are updates to dependencies.

### Notable Changes

* **build**: shared library support is now working for AIX builds (Stewart Addison) [#9675](https://github.com/nodejs/node/pull/9675)
* **deps**:
  * *npm*: upgrade npm to 3.10.10 (Rebecca Turner) [#9847](https://github.com/nodejs/node/pull/9847)
  * *V8*: Destructuring of arrow function arguments via computed property no longer throws (Michaël Zasso) [#10386](https://github.com/nodejs/node/pull/10386)
* **inspector**: /json/version returns object, not an object wrapped in an array (Ben Noordhuis) [#9762](https://github.com/nodejs/node/pull/9762)
* **module**: using --debug-brk and --eval together now works as expected (Kelvin Jin) [#8876](https://github.com/nodejs/node/pull/8876)
* **process**: improve performance of nextTick up to 20% (Evan Lucas) [#8932](https://github.com/nodejs/node/pull/8932)
* **repl**:
  * the division operator will no longer be accidentally parsed as regex (Teddy Katz) [#10103](https://github.com/nodejs/node/pull/10103)
  * improved support for generator functions (Teddy Katz) [#9852](https://github.com/nodejs/node/pull/9852)
* **timers**: Re canceling a cancelled timers will no longer throw (Jeremiah Senkpiel) [#9685](https://github.com/nodejs/node/pull/9685)

### Commits

* [[`98b2eae328`](https://github.com/nodejs/node/commit/98b2eae328)] - **benchmark**: split timers benchmark and refactor (Rich Trott) [#9497](https://github.com/nodejs/node/pull/9497)
* [[`c32c86b3c3`](https://github.com/nodejs/node/commit/c32c86b3c3)] - **benchmark**: reformat code for clarity (Rich Trott) [#9790](https://github.com/nodejs/node/pull/9790)
* [[`a8909b833e`](https://github.com/nodejs/node/commit/a8909b833e)] - **benchmark,lib,test,tools**: remove unneeded . escape (Rich Trott) [#9449](https://github.com/nodejs/node/pull/9449)
* [[`a9d528be5b`](https://github.com/nodejs/node/commit/a9d528be5b)] - **buffer**: fix range checks for slice() (Trevor Norris) [#9174](https://github.com/nodejs/node/pull/9174)
* [[`868e5e624c`](https://github.com/nodejs/node/commit/868e5e624c)] - **build**: remove node.dsYM directory (Michaël Zasso) [#10463](https://github.com/nodejs/node/pull/10463)
* [[`66687c0906`](https://github.com/nodejs/node/commit/66687c0906)] - **build**: prioritise --shared-X-Y over pkg-config (Rod Vagg) [#9368](https://github.com/nodejs/node/pull/9368)
* [[`9703bf14ef`](https://github.com/nodejs/node/commit/9703bf14ef)] - **build**: add MAKEFLAGS="-j1" to node-gyp (Daniel Bevenius) [#9450](https://github.com/nodejs/node/pull/9450)
* [[`18b8e7bd8b`](https://github.com/nodejs/node/commit/18b8e7bd8b)] - **build**: Make configure file parseable on python3 (kalrover) [#9657](https://github.com/nodejs/node/pull/9657)
* [[`12993b298a`](https://github.com/nodejs/node/commit/12993b298a)] - **build**: default to ppc64 on AIX (Gibson Fahnestock) [#9645](https://github.com/nodejs/node/pull/9645)
* [[`5c0d82bae6`](https://github.com/nodejs/node/commit/5c0d82bae6)] - **build**: Add option to compile for coverage reports (Wayne Andrews) [#9463](https://github.com/nodejs/node/pull/9463)
* [[`168241a98a`](https://github.com/nodejs/node/commit/168241a98a)] - **build**: add shared library support to AIX build (Stewart Addison) [#9675](https://github.com/nodejs/node/pull/9675)
* [[`9a526cb8fe`](https://github.com/nodejs/node/commit/9a526cb8fe)] - **child_process**: remove unreachable code (cjihrig) [#9307](https://github.com/nodejs/node/pull/9307)
* [[`166eea7534`](https://github.com/nodejs/node/commit/166eea7534)] - **constants**: errors -> errno (Bryan English) [#9349](https://github.com/nodejs/node/pull/9349)
* [[`3c09579eee`](https://github.com/nodejs/node/commit/3c09579eee)] - **crypto**: use SSL_get_servername. (Adam Langley) [#9347](https://github.com/nodejs/node/pull/9347)
* [[`106e6cdebd`](https://github.com/nodejs/node/commit/106e6cdebd)] - **debugger**: refactor _debugger.js (Rich Trott) [#9860](https://github.com/nodejs/node/pull/9860)
* [[`e60cafdb3b`](https://github.com/nodejs/node/commit/e60cafdb3b)] - **deps**: backport f795a79 from upstream V8 (Michaël Zasso) [#10386](https://github.com/nodejs/node/pull/10386)
* [[`284d3cc3b7`](https://github.com/nodejs/node/commit/284d3cc3b7)] - **deps**: upgrade npm to 3.10.10 (Rebecca Turner) [#9847](https://github.com/nodejs/node/pull/9847)
* [[`ee09828622`](https://github.com/nodejs/node/commit/ee09828622)] - **deps**: backport 2bd7464 from upstream V8 (Cristian Cavalli) [#10169](https://github.com/nodejs/node/pull/10169)
* [[`10222128e9`](https://github.com/nodejs/node/commit/10222128e9)] - **deps**: backport GYP fix to fix AIX shared suffix (Stewart Addison) [#9675](https://github.com/nodejs/node/pull/9675)
* [[`1684d6d65e`](https://github.com/nodejs/node/commit/1684d6d65e)] - **doc**: update CONTRIBUTING.MD with link to V8 guide (sarahmeyer) [#10070](https://github.com/nodejs/node/pull/10070)
* [[`f9d0cce9ae`](https://github.com/nodejs/node/commit/f9d0cce9ae)] - **doc**: update process.versions.modules documentation (Kevin Zurawel) [#9901](https://github.com/nodejs/node/pull/9901)
* [[`acebfedf80`](https://github.com/nodejs/node/commit/acebfedf80)] - **doc**: add return types and props types to OS module (imatvieiev) [#9648](https://github.com/nodejs/node/pull/9648)
* [[`241470cfbe`](https://github.com/nodejs/node/commit/241470cfbe)] - **doc**: small improvements in readline code examples (Vse Mozhet Byt) [#9628](https://github.com/nodejs/node/pull/9628)
* [[`d33520cdd2`](https://github.com/nodejs/node/commit/d33520cdd2)] - **doc**: consistent 'Returns:' (Roman Reiss) [#9554](https://github.com/nodejs/node/pull/9554)
* [[`c87ccfa3c3`](https://github.com/nodejs/node/commit/c87ccfa3c3)] - **doc**: added types to path docs (imatvieiev) [#9514](https://github.com/nodejs/node/pull/9514)
* [[`d2a1a670e1`](https://github.com/nodejs/node/commit/d2a1a670e1)] - **doc**: add process api data types to documentation (imatvieiev) [#9505](https://github.com/nodejs/node/pull/9505)
* [[`912cae626b`](https://github.com/nodejs/node/commit/912cae626b)] - **doc**: clarify eventType in fs.watch (Nikolai Vavilov) [#9318](https://github.com/nodejs/node/pull/9318)
* [[`30f7802b78`](https://github.com/nodejs/node/commit/30f7802b78)] - **doc**: clarify fs.link and fs.linkSync arguments (Kyle E. Mitchell) [#9145](https://github.com/nodejs/node/pull/9145)
* [[`c55fb737c5`](https://github.com/nodejs/node/commit/c55fb737c5)] - **doc**: adding missing - in README (Italo A. Casas) [#10170](https://github.com/nodejs/node/pull/10170)
* [[`7f4cef1170`](https://github.com/nodejs/node/commit/7f4cef1170)] - **doc**: removing extra space in README (Italo A. Casas) [#10168](https://github.com/nodejs/node/pull/10168)
* [[`e0dbb453e4`](https://github.com/nodejs/node/commit/e0dbb453e4)] - **doc**: remove repeated info onboarding.md (BethGriggs) [#9635](https://github.com/nodejs/node/pull/9635)
* [[`fa7d378335`](https://github.com/nodejs/node/commit/fa7d378335)] - **doc**: correct it's vs. its usage (Rich Trott) [#10098](https://github.com/nodejs/node/pull/10098)
* [[`176f680432`](https://github.com/nodejs/node/commit/176f680432)] - **doc**: add people to cc for async_wrap (Anna Henningsen) [#9471](https://github.com/nodejs/node/pull/9471)
* [[`b77d3d86f7`](https://github.com/nodejs/node/commit/b77d3d86f7)] - **doc**: add link to `net.Server` in tls.md (Devon Rifkin) [#10109](https://github.com/nodejs/node/pull/10109)
* [[`b167727dcc`](https://github.com/nodejs/node/commit/b167727dcc)] - **doc**: fix typo for `decipher.final`. (iamchenxin) [#10086](https://github.com/nodejs/node/pull/10086)
* [[`adb30676b2`](https://github.com/nodejs/node/commit/adb30676b2)] - **doc**: suggest Buffer.alloc instead of Buffer#fill (Teddy Katz) [#10000](https://github.com/nodejs/node/pull/10000)
* [[`36b45c1112`](https://github.com/nodejs/node/commit/36b45c1112)] - **doc**: clarify fs.createReadStream options (Wes Tyler) [#10078](https://github.com/nodejs/node/pull/10078)
* [[`fc6c666d49`](https://github.com/nodejs/node/commit/fc6c666d49)] - **doc**: var => const in js code examples of addons.md (Vse Mozhet Byt) [#10092](https://github.com/nodejs/node/pull/10092)
* [[`0e46f7e745`](https://github.com/nodejs/node/commit/0e46f7e745)] - **doc**: rename writing_tests.md to writing-tests.md (Safia Abdalla) [#9867](https://github.com/nodejs/node/pull/9867)
* [[`99ed5ed5f4`](https://github.com/nodejs/node/commit/99ed5ed5f4)] - **doc**: it’s -> its in api/child_process.md (Devon Rifkin) [#10090](https://github.com/nodejs/node/pull/10090)
* [[`d068fe5ab6`](https://github.com/nodejs/node/commit/d068fe5ab6)] - **doc**: update Collaborators list in README (Rich Trott) [#9846](https://github.com/nodejs/node/pull/9846)
* [[`e5ab0e8670`](https://github.com/nodejs/node/commit/e5ab0e8670)] - **doc**: remove minor contradiction in debugger doc (Rich Trott) [#9832](https://github.com/nodejs/node/pull/9832)
* [[`b74d8cdbdb`](https://github.com/nodejs/node/commit/b74d8cdbdb)] - **doc**: clarify introductory module material (Rich Trott) [#9816](https://github.com/nodejs/node/pull/9816)
* [[`ba077a424b`](https://github.com/nodejs/node/commit/ba077a424b)] - **doc**: improve description of module `exports` (Sam Roberts) [#9622](https://github.com/nodejs/node/pull/9622)
* [[`5396408690`](https://github.com/nodejs/node/commit/5396408690)] - **doc**: fix crypto Verify cut-n-paste from Sign (子丶言) [#9796](https://github.com/nodejs/node/pull/9796)
* [[`9c3f4d63cc`](https://github.com/nodejs/node/commit/9c3f4d63cc)] - **doc**: minor fixes event-loop-timers-and-nexttick.md (Dan Koster) [#9126](https://github.com/nodejs/node/pull/9126)
* [[`87f008393e`](https://github.com/nodejs/node/commit/87f008393e)] - **doc**: changed order of invocations in https.request() example. (atrioom) [#9614](https://github.com/nodejs/node/pull/9614)
* [[`7051ea8606`](https://github.com/nodejs/node/commit/7051ea8606)] - **doc**: fix crypto "decipher.setAAD()" typo (子丶言) [#9782](https://github.com/nodejs/node/pull/9782)
* [[`4b7200ef7b`](https://github.com/nodejs/node/commit/4b7200ef7b)] - **doc**: clarify slashes-appending in url module (Rich Trott) [#9731](https://github.com/nodejs/node/pull/9731)
* [[`1c9817cbeb`](https://github.com/nodejs/node/commit/1c9817cbeb)] - **doc**: "util" is not needed to extend ES6 classes (Adam Brunner) [#9737](https://github.com/nodejs/node/pull/9737)
* [[`4334d6a85a`](https://github.com/nodejs/node/commit/4334d6a85a)] - **doc**: fix typo in assert code example (Vse Mozhet Byt) [#9704](https://github.com/nodejs/node/pull/9704)
* [[`cbea672214`](https://github.com/nodejs/node/commit/cbea672214)] - **doc**: fix typo in BUILDING.md (monkick) [#9569](https://github.com/nodejs/node/pull/9569)
* [[`7a02eb2b03`](https://github.com/nodejs/node/commit/7a02eb2b03)] - **doc**: remove backtick escaping for manpage refs (Anna Henningsen) [#9632](https://github.com/nodejs/node/pull/9632)
* [[`cd3b91bc4e`](https://github.com/nodejs/node/commit/cd3b91bc4e)] - **doc**: improve description of urlObject.query (Rahat Ahmed) [#9625](https://github.com/nodejs/node/pull/9625)
* [[`ff7d85647b`](https://github.com/nodejs/node/commit/ff7d85647b)] - **doc**: remove invalid padding from privateEncrypt (JungMinu) [#9611](https://github.com/nodejs/node/pull/9611)
* [[`50947b7b0f`](https://github.com/nodejs/node/commit/50947b7b0f)] - **doc**: remove Sam Roberts from release team (Sam Roberts) [#9862](https://github.com/nodejs/node/pull/9862)
* [[`cf131bfa90`](https://github.com/nodejs/node/commit/cf131bfa90)] - **doc**: add guide for maintaining V8 (Ali Ijaz Sheikh) [#9777](https://github.com/nodejs/node/pull/9777)
* [[`9796efabc6`](https://github.com/nodejs/node/commit/9796efabc6)] - **doc**: strip trailing whitespace (Sam Roberts) [#9620](https://github.com/nodejs/node/pull/9620)
* [[`35b094b8fe`](https://github.com/nodejs/node/commit/35b094b8fe)] - **doc**: fix "either as either" typo (Sam Roberts) [#9665](https://github.com/nodejs/node/pull/9665)
* [[`1a58a21d29`](https://github.com/nodejs/node/commit/1a58a21d29)] - **doc**: fix tls "the the" typo (Sam Roberts) [#9665](https://github.com/nodejs/node/pull/9665)
* [[`4f205deb66`](https://github.com/nodejs/node/commit/4f205deb66)] - **doc**: describe when a tls server emits 'close' (Sam Roberts) [#9665](https://github.com/nodejs/node/pull/9665)
* [[`4d4ac071da`](https://github.com/nodejs/node/commit/4d4ac071da)] - **doc**: fix an SNI mistyped as SNS (Sam Roberts) [#9665](https://github.com/nodejs/node/pull/9665)
* [[`8475ba294d`](https://github.com/nodejs/node/commit/8475ba294d)] - **doc**: move TSC and CTC meeting minutes out of core repo (James M Snell) [#9503](https://github.com/nodejs/node/pull/9503)
* [[`d343595216`](https://github.com/nodejs/node/commit/d343595216)] - **doc**: fix typo in doc/repl.md line: 6 (Mitsuo Utano) [#9582](https://github.com/nodejs/node/pull/9582)
* [[`d283704cd6`](https://github.com/nodejs/node/commit/d283704cd6)] - **doc**: make comment indentation consistent (Daniel Bevenius) [#9518](https://github.com/nodejs/node/pull/9518)
* [[`b99a9e9a81`](https://github.com/nodejs/node/commit/b99a9e9a81)] - **doc**: wrap long lines in http.request (Timothy Gu) [#9584](https://github.com/nodejs/node/pull/9584)
* [[`fd75b25cbf`](https://github.com/nodejs/node/commit/fd75b25cbf)] - **doc**: fix type of http.request's `agent` option (Timothy Gu) [#9584](https://github.com/nodejs/node/pull/9584)
* [[`1783d3b5fc`](https://github.com/nodejs/node/commit/1783d3b5fc)] - **doc**: fix a typo in the assert.md (Vse Mozhet Byt) [#9598](https://github.com/nodejs/node/pull/9598)
* [[`c286f5719c`](https://github.com/nodejs/node/commit/c286f5719c)] - **doc**: fix typo e.g., => e.g. (Daijiro Yamada) [#9563](https://github.com/nodejs/node/pull/9563)
* [[`82fd0e192f`](https://github.com/nodejs/node/commit/82fd0e192f)] - **doc**: fix typo about cluster doc, (eg. -> e.g.) (YutamaKotaro) [#9568](https://github.com/nodejs/node/pull/9568)
* [[`1bbc2c682a`](https://github.com/nodejs/node/commit/1bbc2c682a)] - **doc**: fix typo in doc/tls.md (Syuhei Kobayashi) [#9566](https://github.com/nodejs/node/pull/9566)
* [[`97093314c2`](https://github.com/nodejs/node/commit/97093314c2)] - **doc**: fix e.g., to e.g. in doc/http.md (ikasumi_wt) [#9564](https://github.com/nodejs/node/pull/9564)
* [[`caa0a7876d`](https://github.com/nodejs/node/commit/caa0a7876d)] - **doc**: fix the index order in pseudocode of modules (kohta ito) [#9562](https://github.com/nodejs/node/pull/9562)
* [[`0088ed87ea`](https://github.com/nodejs/node/commit/0088ed87ea)] - **doc**: remove Roadmap Working Group (William Kapke) [#9545](https://github.com/nodejs/node/pull/9545)
* [[`3219ecea2a`](https://github.com/nodejs/node/commit/3219ecea2a)] - **doc**: fix fs constants link (Timothy) [#9508](https://github.com/nodejs/node/pull/9508)
* [[`cb367ec1b3`](https://github.com/nodejs/node/commit/cb367ec1b3)] - **doc**: fix minor style issue in code examples (Daniel Bevenius) [#9482](https://github.com/nodejs/node/pull/9482)
* [[`ff8c31abfd`](https://github.com/nodejs/node/commit/ff8c31abfd)] - **doc**: grammar and structure revisions of wg doc (Ryan Lewis) [#9495](https://github.com/nodejs/node/pull/9495)
* [[`6f850f4037`](https://github.com/nodejs/node/commit/6f850f4037)] - **doc**: clarify the exit code part of writing_tests (Jeremiah Senkpiel) [#9502](https://github.com/nodejs/node/pull/9502)
* [[`16b53141f7`](https://github.com/nodejs/node/commit/16b53141f7)] - **doc**: fix link to Event Loop page (timathon) [#9527](https://github.com/nodejs/node/pull/9527)
* [[`2d581f1cb5`](https://github.com/nodejs/node/commit/2d581f1cb5)] - **doc**: Fix inaccuracy in https.request docs (Andreas Lind) [#9453](https://github.com/nodejs/node/pull/9453)
* [[`f707b006eb`](https://github.com/nodejs/node/commit/f707b006eb)] - **doc**: add npm link to README (Oscar Morrison) [#7894](https://github.com/nodejs/node/pull/7894)
* [[`2ce6916ddc`](https://github.com/nodejs/node/commit/2ce6916ddc)] - **events**: remove unnecessary checks (cjihrig) [#9330](https://github.com/nodejs/node/pull/9330)
* [[`fe821fbefa`](https://github.com/nodejs/node/commit/fe821fbefa)] - **fs**: clarify fs.link and fs.linkSync arguments (Kyle E. Mitchell) [#9145](https://github.com/nodejs/node/pull/9145)
* [[`a3ba4ff49f`](https://github.com/nodejs/node/commit/a3ba4ff49f)] - **inspector**: /json/version returns object, not array (Ben Noordhuis) [#9762](https://github.com/nodejs/node/pull/9762)
* [[`6632b3d1ab`](https://github.com/nodejs/node/commit/6632b3d1ab)] - **lib**: use === in _http_server and _tls_wrap (Walter Beller-Morales) [#9849](https://github.com/nodejs/node/pull/9849)
* [[`f3861c200d`](https://github.com/nodejs/node/commit/f3861c200d)] - **lib,test**: remove unneeded escaping of / (Rich Trott) [#9485](https://github.com/nodejs/node/pull/9485)
* [[`0be56cd1e9`](https://github.com/nodejs/node/commit/0be56cd1e9)] - **meta**: whitelist dotfiles in .gitignore (Claudio Rodriguez) [#8016](https://github.com/nodejs/node/pull/8016)
* [[`3689813fdd`](https://github.com/nodejs/node/commit/3689813fdd)] - **module**: check -e flag in debug break setup (Kelvin Jin) [#8876](https://github.com/nodejs/node/pull/8876)
* [[`db10e94083`](https://github.com/nodejs/node/commit/db10e94083)] - **process**: improve performance of nextTick (Evan Lucas) [#8932](https://github.com/nodejs/node/pull/8932)
* [[`fac61118f9`](https://github.com/nodejs/node/commit/fac61118f9)] - **repl**: avoid parsing division operator as regex (Teddy Katz) [#10103](https://github.com/nodejs/node/pull/10103)
* [[`86efc93a41`](https://github.com/nodejs/node/commit/86efc93a41)] - **repl**: preprocess only for defaultEval (Prince J Wesley) [#9752](https://github.com/nodejs/node/pull/9752)
* [[`eba4f9a3ff`](https://github.com/nodejs/node/commit/eba4f9a3ff)] - **repl**: fix generator function preprocessing (Teddy Katz) [#9852](https://github.com/nodejs/node/pull/9852)
* [[`70062f7cd7`](https://github.com/nodejs/node/commit/70062f7cd7)] - **repl**: refactor lib/repl.js (Rich Trott) [#9374](https://github.com/nodejs/node/pull/9374)
* [[`f9fd53d82d`](https://github.com/nodejs/node/commit/f9fd53d82d)] - **src**: fix method name, output format (Josh Gavant) [#9627](https://github.com/nodejs/node/pull/9627)
* [[`dee5a7f9be`](https://github.com/nodejs/node/commit/dee5a7f9be)] - **test**: invalid package.json causes error when require()ing in directory (Sam Shull) [#10044](https://github.com/nodejs/node/pull/10044)
* [[`487f91a097`](https://github.com/nodejs/node/commit/487f91a097)] - **test**: refactor domain test (Adao Junior) [#10269](https://github.com/nodejs/node/pull/10269)
* [[`26aa148ac5`](https://github.com/nodejs/node/commit/26aa148ac5)] - **test**: refactor test-child-process-stdin (Segu Riluvan) [#10420](https://github.com/nodejs/node/pull/10420)
* [[`25b76a44a7`](https://github.com/nodejs/node/commit/25b76a44a7)] - **test**: test error messages in test-dns-regress-7070 (Wallace Zhang) [#10058](https://github.com/nodejs/node/pull/10058)
* [[`8389a1eef4`](https://github.com/nodejs/node/commit/8389a1eef4)] - **test**: refactor test-pipe-file-to-http (Josh Mays) [#10054](https://github.com/nodejs/node/pull/10054)
* [[`f9f2cda5dc`](https://github.com/nodejs/node/commit/f9f2cda5dc)] - **test**: refactor test-cluster-send-handle-twice.js (Amar Zavery) [#10049](https://github.com/nodejs/node/pull/10049)
* [[`aba15fb9f2`](https://github.com/nodejs/node/commit/aba15fb9f2)] - **test**: add regex check in test-buffer-bad-overload (Sam Shull) [#10038](https://github.com/nodejs/node/pull/10038)
* [[`ac9348d79f`](https://github.com/nodejs/node/commit/ac9348d79f)] - **test**: refactoring test-pipe-head (Travis Bretton) [#10036](https://github.com/nodejs/node/pull/10036)
* [[`0ab2cfc64e`](https://github.com/nodejs/node/commit/0ab2cfc64e)] - **test**: add second argument to assert.throws() (Ken Russo) [#9987](https://github.com/nodejs/node/pull/9987)
* [[`610ec557a6`](https://github.com/nodejs/node/commit/610ec557a6)] - **test**: refactor test-child-process-ipc (malen) [#9990](https://github.com/nodejs/node/pull/9990)
* [[`ff3a1e69f5`](https://github.com/nodejs/node/commit/ff3a1e69f5)] - **test**: cleanup test-stdout-close-catch.js (Travis Bretton) [#10006](https://github.com/nodejs/node/pull/10006)
* [[`49e7029283`](https://github.com/nodejs/node/commit/49e7029283)] - **test**: refactor test-internal-modules (Christy Leung) [#10016](https://github.com/nodejs/node/pull/10016)
* [[`21a60912a8`](https://github.com/nodejs/node/commit/21a60912a8)] - **test**: refactor test-tls-interleave (Brian Chirgwin) [#10017](https://github.com/nodejs/node/pull/10017)
* [[`e53506ac01`](https://github.com/nodejs/node/commit/e53506ac01)] - **test**: update test-tls-check-server-identity.js (Kevin Cox) [#9986](https://github.com/nodejs/node/pull/9986)
* [[`bdf633a32e`](https://github.com/nodejs/node/commit/bdf633a32e)] - **test**: use const/let and common.mustCall (Outsider) [#9959](https://github.com/nodejs/node/pull/9959)
* [[`77334a2143`](https://github.com/nodejs/node/commit/77334a2143)] - **test**: refactoring test-cluster-worker-constructor (Christopher Rokita) [#9956](https://github.com/nodejs/node/pull/9956)
* [[`3c3d2d6776`](https://github.com/nodejs/node/commit/3c3d2d6776)] - **test**: refactor test-tls-client-getephemeralkeyinfo (Harish Tejwani) [#9954](https://github.com/nodejs/node/pull/9954)
* [[`da3ccb969d`](https://github.com/nodejs/node/commit/da3ccb969d)] - **test**: improve test-cluster-net-listen.js (Rico Cai) [#9953](https://github.com/nodejs/node/pull/9953)
* [[`9991bcbada`](https://github.com/nodejs/node/commit/9991bcbada)] - **test**: improve domain-top-level-error-handler-throw (CodeVana) [#9950](https://github.com/nodejs/node/pull/9950)
* [[`eff85e659f`](https://github.com/nodejs/node/commit/eff85e659f)] - **test**: refactor test-tls-0-dns-altname (Richard Karmazin) [#9948](https://github.com/nodejs/node/pull/9948)
* [[`b37fce91d3`](https://github.com/nodejs/node/commit/b37fce91d3)] - **test**: test: refactor test-sync-fileread (Jason Wohlgemuth) [#9941](https://github.com/nodejs/node/pull/9941)
* [[`420b3b851e`](https://github.com/nodejs/node/commit/420b3b851e)] - **test**: clean up repl-reset-event file (Kailean Courtney) [#9931](https://github.com/nodejs/node/pull/9931)
* [[`b8511aba04`](https://github.com/nodejs/node/commit/b8511aba04)] - **test**: replace var with const in test-require-dot (Amar Zavery) [#9916](https://github.com/nodejs/node/pull/9916)
* [[`68836ec455`](https://github.com/nodejs/node/commit/68836ec455)] - **test**: added validation regex argument to test (Avery, Frank) [#9918](https://github.com/nodejs/node/pull/9918)
* [[`70d3b808a0`](https://github.com/nodejs/node/commit/70d3b808a0)] - **test**: fix test-buffer-slow (Michaël Zasso) [#9809](https://github.com/nodejs/node/pull/9809)
* [[`3d368d0322`](https://github.com/nodejs/node/commit/3d368d0322)] - **test**: refactor test-buffer-bytelength (Michaël Zasso) [#9808](https://github.com/nodejs/node/pull/9808)
* [[`b5c8b355c8`](https://github.com/nodejs/node/commit/b5c8b355c8)] - **test**: add stdin-setrawmode.out file (Jonathan Darling) [#10149](https://github.com/nodejs/node/pull/10149)
* [[`e057925316`](https://github.com/nodejs/node/commit/e057925316)] - **test**: set stdin too for pseudo-tty tests (Anna Henningsen) [#10149](https://github.com/nodejs/node/pull/10149)
* [[`272a97178d`](https://github.com/nodejs/node/commit/272a97178d)] - **test**: refactor and fix test-crypto (Michaël Zasso) [#9807](https://github.com/nodejs/node/pull/9807)
* [[`65e27176f6`](https://github.com/nodejs/node/commit/65e27176f6)] - **test**: add child_process customFds test (cjihrig) [#9307](https://github.com/nodejs/node/pull/9307)
* [[`dc76aaef50`](https://github.com/nodejs/node/commit/dc76aaef50)] - **test**: refactor test-crypto-hmac (eudaimos) [#9958](https://github.com/nodejs/node/pull/9958)
* [[`1bbf143898`](https://github.com/nodejs/node/commit/1bbf143898)] - **test**: renamed assert.Equal to assert.strictEqual (Jared Young)
* [[`6dbff7aaed`](https://github.com/nodejs/node/commit/6dbff7aaed)] - **test**: convert assert.equal to assert.strictEqual (Jonathan Darling) [#9925](https://github.com/nodejs/node/pull/9925)
* [[`bbebebe087`](https://github.com/nodejs/node/commit/bbebebe087)] - **test**: strictEqual() and RegExp in test-buffer-fill.js (J Scott Chapman) [#9895](https://github.com/nodejs/node/pull/9895)
* [[`afbd8df7fd`](https://github.com/nodejs/node/commit/afbd8df7fd)] - **test**: increase coverage for lib/events.js (Safia Abdalla) [#9865](https://github.com/nodejs/node/pull/9865)
* [[`99ef3c0e45`](https://github.com/nodejs/node/commit/99ef3c0e45)] - **test**: run cpplint on files in test/cctest (Ben Noordhuis) [#9787](https://github.com/nodejs/node/pull/9787)
* [[`2ffd13e90d`](https://github.com/nodejs/node/commit/2ffd13e90d)] - **test**: move tick-processor tests to own directory (Rich Trott) [#9506](https://github.com/nodejs/node/pull/9506)
* [[`fb525f1507`](https://github.com/nodejs/node/commit/fb525f1507)] - **test**: fix error in test-cluster-worker-death.js (Bruce Lai) [#9981](https://github.com/nodejs/node/pull/9981)
* [[`1288d074ab`](https://github.com/nodejs/node/commit/1288d074ab)] - **test**: use `assert.strictEqual` (anoff) [#9975](https://github.com/nodejs/node/pull/9975)
* [[`653f2b76f3`](https://github.com/nodejs/node/commit/653f2b76f3)] - **test**: change assert.equal to assert.strictEqual (Aileen) [#9946](https://github.com/nodejs/node/pull/9946)
* [[`70c5e4fca2`](https://github.com/nodejs/node/commit/70c5e4fca2)] - **test**: changed assert.equal to assert.strictEqual (vazina robertson) [#10015](https://github.com/nodejs/node/pull/10015)
* [[`690cc2a88f`](https://github.com/nodejs/node/commit/690cc2a88f)] - **test**: improves test-tls-client-verify (Paul Graham) [#10051](https://github.com/nodejs/node/pull/10051)
* [[`780d444d3f`](https://github.com/nodejs/node/commit/780d444d3f)] - **test**: refactor test-https-agent-session-reuse (Diego Paez) [#10105](https://github.com/nodejs/node/pull/10105)
* [[`3686687cd2`](https://github.com/nodejs/node/commit/3686687cd2)] - **test**: refactor test-beforeexit-event (Rob Adelmann) [#10121](https://github.com/nodejs/node/pull/10121)
* [[`314b04d2d9`](https://github.com/nodejs/node/commit/314b04d2d9)] - **test**: improve test-fs-read-stream.js (Jenna Vuong) [#9629](https://github.com/nodejs/node/pull/9629)
* [[`a6bc868bf9`](https://github.com/nodejs/node/commit/a6bc868bf9)] - **test**: refactor test-domain-from-timer (Daniel Sims) [#9889](https://github.com/nodejs/node/pull/9889)
* [[`793addf585`](https://github.com/nodejs/node/commit/793addf585)] - **test**: refactor test-domain-exit-dispose-again (Ethan Arrowood) [#10003](https://github.com/nodejs/node/pull/10003)
* [[`faf0f2d254`](https://github.com/nodejs/node/commit/faf0f2d254)] - **test**: use const and strictEqual in test-os-homedir-no-envvar (CodeVana) [#9899](https://github.com/nodejs/node/pull/9899)
* [[`a696934faa`](https://github.com/nodejs/node/commit/a696934faa)] - **test**: check result of uv_loop_init and uv_write (Ben Noordhuis) [#10126](https://github.com/nodejs/node/pull/10126)
* [[`c2d7e67458`](https://github.com/nodejs/node/commit/c2d7e67458)] - **test**: refactor test-dgram-bind-default-address (Michael-Bryant Choa) [#9947](https://github.com/nodejs/node/pull/9947)
* [[`3c46ab69af`](https://github.com/nodejs/node/commit/3c46ab69af)] - **test**: assert.throws() should include a RegExp (Chris Bystrek) [#9976](https://github.com/nodejs/node/pull/9976)
* [[`0e3593a454`](https://github.com/nodejs/node/commit/0e3593a454)] - **test**: refactor test-listen-fd-ebadf (Richard Karmazin) [#10034](https://github.com/nodejs/node/pull/10034)
* [[`e49c7bbae3`](https://github.com/nodejs/node/commit/e49c7bbae3)] - **test**: refactor test-event-emitter-method-names (Rodrigo Palma) [#10027](https://github.com/nodejs/node/pull/10027)
* [[`290f359857`](https://github.com/nodejs/node/commit/290f359857)] - **test**: refactor tls-ticket-cluster (Yojan Shrestha) [#10023](https://github.com/nodejs/node/pull/10023)
* [[`5d9c224384`](https://github.com/nodejs/node/commit/5d9c224384)] - **test**: refactor test-domain-exit-dispose (Chris Henney) [#9938](https://github.com/nodejs/node/pull/9938)
* [[`7c929591c1`](https://github.com/nodejs/node/commit/7c929591c1)] - **test**: refactor test-stdin-from-file.js (amrios) [#10012](https://github.com/nodejs/node/pull/10012)
* [[`9af076e97d`](https://github.com/nodejs/node/commit/9af076e97d)] - **test**: use ES6 to update let & const (Jason Humphrey) [#9917](https://github.com/nodejs/node/pull/9917)
* [[`dd4586bd41`](https://github.com/nodejs/node/commit/dd4586bd41)] - **test**: fix test for buffer regression #649 (joyeecheung) [#9924](https://github.com/nodejs/node/pull/9924)
* [[`fed9acd8af`](https://github.com/nodejs/node/commit/fed9acd8af)] - **test**: update parallel/test-crypto-hash.js (Deepti Agrawal) [#10009](https://github.com/nodejs/node/pull/10009)
* [[`d64cb1e04e`](https://github.com/nodejs/node/commit/d64cb1e04e)] - **test**: refactor test-require-extensions-main (Daryl Thayil) [#9912](https://github.com/nodejs/node/pull/9912)
* [[`cdb803d18b`](https://github.com/nodejs/node/commit/cdb803d18b)] - **test**: refactor test-tls-ocsp-callback (k3kathy) [#9970](https://github.com/nodejs/node/pull/9970)
* [[`78b5a8d5c2`](https://github.com/nodejs/node/commit/78b5a8d5c2)] - **test**: use assert.strictEqual and fix setTimeout (Matt Phillips) [#9957](https://github.com/nodejs/node/pull/9957)
* [[`f4c8044007`](https://github.com/nodejs/node/commit/f4c8044007)] - **test**: clean up tls junk test (Danny Guo) [#9940](https://github.com/nodejs/node/pull/9940)
* [[`626d59f7a6`](https://github.com/nodejs/node/commit/626d59f7a6)] - **test**: update test-stdout-to-file (scalkpdev) [#9939](https://github.com/nodejs/node/pull/9939)
* [[`223ec17080`](https://github.com/nodejs/node/commit/223ec17080)] - **test**: changed assert.Equal to asset.strictEqual (Paul Chin) [#9973](https://github.com/nodejs/node/pull/9973)
* [[`230d552a85`](https://github.com/nodejs/node/commit/230d552a85)] - **test**: refactor test-domain-multi (Wes Tyler) [#9963](https://github.com/nodejs/node/pull/9963)
* [[`b893dc986c`](https://github.com/nodejs/node/commit/b893dc986c)] - **test**: refactor test-fs-write.js (hirabhullar) [#9982](https://github.com/nodejs/node/pull/9982)
* [[`c506b7be90`](https://github.com/nodejs/node/commit/c506b7be90)] - **test**: refactor test-child-fork-exec-path.js (hirabhullar) [#9982](https://github.com/nodejs/node/pull/9982)
* [[`050bae63f1`](https://github.com/nodejs/node/commit/050bae63f1)] - **test**: use assert.strictEqual in test-cli-eval (Nigel Kibodeaux) [#9919](https://github.com/nodejs/node/pull/9919)
* [[`2a514f20e1`](https://github.com/nodejs/node/commit/2a514f20e1)] - **test**: refactor test-tls-connect-simple (Russell Sherman) [#9934](https://github.com/nodejs/node/pull/9934)
* [[`75c37fa8a2`](https://github.com/nodejs/node/commit/75c37fa8a2)] - **test**: refactor test-signal-unregister (mark hughes) [#9920](https://github.com/nodejs/node/pull/9920)
* [[`093adcac9a`](https://github.com/nodejs/node/commit/093adcac9a)] - **test**: update test-net-connect-handle-econnrefused (Punit Buch) [#9932](https://github.com/nodejs/node/pull/9932)
* [[`75712a3032`](https://github.com/nodejs/node/commit/75712a3032)] - **test**: refactor test-require-resolve (blugavere) [#10120](https://github.com/nodejs/node/pull/10120)
* [[`4a28eac54b`](https://github.com/nodejs/node/commit/4a28eac54b)] - **test**: refactor test-fs-symlink-dir-junction (Walter Beller-Morales) [#9928](https://github.com/nodejs/node/pull/9928)
* [[`09de7149f2`](https://github.com/nodejs/node/commit/09de7149f2)] - **test**: refactor test-fs-read-stream-resume (Matt Webb) [#9927](https://github.com/nodejs/node/pull/9927)
* [[`8ce6dd2a57`](https://github.com/nodejs/node/commit/8ce6dd2a57)] - **test**: replace equal with strictEqual (Tracy Hinds) [#10011](https://github.com/nodejs/node/pull/10011)
* [[`3b765cb231`](https://github.com/nodejs/node/commit/3b765cb231)] - **test**: use strictEqual instead of equal (Uttam Pawar) [#9921](https://github.com/nodejs/node/pull/9921)
* [[`baa0adfe46`](https://github.com/nodejs/node/commit/baa0adfe46)] - **test**: using const and strictEqual (Fabrice Tatieze) [#9926](https://github.com/nodejs/node/pull/9926)
* [[`8ceca4a135`](https://github.com/nodejs/node/commit/8ceca4a135)] - **test**: changed assert.equal to assert.strictEqual (Scott Smereka) [#9936](https://github.com/nodejs/node/pull/9936)
* [[`f248c67da6`](https://github.com/nodejs/node/commit/f248c67da6)] - **test**: test-file-write-stream3.js refactor (Richard Karmazin) [#10035](https://github.com/nodejs/node/pull/10035)
* [[`dd4f9195f1`](https://github.com/nodejs/node/commit/dd4f9195f1)] - **test**: implemented es6 conventions (Erez Weiss) [#9669](https://github.com/nodejs/node/pull/9669)
* [[`c30332daa6`](https://github.com/nodejs/node/commit/c30332daa6)] - **test**: Modernize test-tls-peer-certificate.js (Ilya Potuzhnov) [#10014](https://github.com/nodejs/node/pull/10014)
* [[`ba5e37765a`](https://github.com/nodejs/node/commit/ba5e37765a)] - **test**: strictCompare and explcit inputs mprovement to test-buffer-slice (Michael Alexander) [#10048](https://github.com/nodejs/node/pull/10048)
* [[`ec7df6c0a4`](https://github.com/nodejs/node/commit/ec7df6c0a4)] - **test**: add test for process.stdin.setRawMode() (Jonathan Darling) [#10037](https://github.com/nodejs/node/pull/10037)
* [[`4fce85554a`](https://github.com/nodejs/node/commit/4fce85554a)] - **test**: refactor test for net listen on fd0 (Julian Duque) [#10025](https://github.com/nodejs/node/pull/10025)
* [[`b7619e3b16`](https://github.com/nodejs/node/commit/b7619e3b16)] - **test**: update assert.equal() to assert.strictEqual() (Peter Diaz) [#10024](https://github.com/nodejs/node/pull/10024)
* [[`a6096041c6`](https://github.com/nodejs/node/commit/a6096041c6)] - **test**: use const or let and assert.strictEqual (Christopher Rokita) [#10001](https://github.com/nodejs/node/pull/10001)
* [[`cc8100a529`](https://github.com/nodejs/node/commit/cc8100a529)] - **test**: fix buffer alloc tests (levsoroka) [#9998](https://github.com/nodejs/node/pull/9998)
* [[`eb61d918b1`](https://github.com/nodejs/node/commit/eb61d918b1)] - **test**: Added more validations to setEncoding (Paul Lucas) [#9997](https://github.com/nodejs/node/pull/9997)
* [[`fe59a67b6e`](https://github.com/nodejs/node/commit/fe59a67b6e)] - **test**: use strictEqual() domain-http (cdnadmin) [#9996](https://github.com/nodejs/node/pull/9996)
* [[`ced89ede03`](https://github.com/nodejs/node/commit/ced89ede03)] - **test**: refactor test-cluster-worker-events (fmizzell) [#9994](https://github.com/nodejs/node/pull/9994)
* [[`aea0d47b77`](https://github.com/nodejs/node/commit/aea0d47b77)] - **test**: update repl tests (makenova) [#9991](https://github.com/nodejs/node/pull/9991)
* [[`a749604e11`](https://github.com/nodejs/node/commit/a749604e11)] - **test**: modernize test-fs-truncate-fd (Nigel Kibodeaux) [#9978](https://github.com/nodejs/node/pull/9978)
* [[`1addb3ba53`](https://github.com/nodejs/node/commit/1addb3ba53)] - **test**: update tls test to use const/let and common.mustCall (rgoodwin) [#9968](https://github.com/nodejs/node/pull/9968)
* [[`6d79c0cd2c`](https://github.com/nodejs/node/commit/6d79c0cd2c)] - **test**: adding strictEqual to test-buffer-indexof.js (Eric Gonzalez) [#9955](https://github.com/nodejs/node/pull/9955)
* [[`eeab546fb6`](https://github.com/nodejs/node/commit/eeab546fb6)] - **test**: strictEqual in test-beforeexit-event.js (CodeTheInternet) [#10004](https://github.com/nodejs/node/pull/10004)
* [[`b71d3fd748`](https://github.com/nodejs/node/commit/b71d3fd748)] - **test**: refactor test-child-process-double-pipe (Dan Villa) [#9930](https://github.com/nodejs/node/pull/9930)
* [[`47c925a4ac`](https://github.com/nodejs/node/commit/47c925a4ac)] - **test**: updated tls-getcipher test (Ethan Arrowood) [#9923](https://github.com/nodejs/node/pull/9923)
* [[`bc3b77f525`](https://github.com/nodejs/node/commit/bc3b77f525)] - **test**: replace equal with strictEqual in test-freelist.js (Adrian Estrada) [#9910](https://github.com/nodejs/node/pull/9910)
* [[`5afcf3ac78`](https://github.com/nodejs/node/commit/5afcf3ac78)] - **test**: updated test-stream-pipe-unpipe-stream (Raja Panidepu) [#10100](https://github.com/nodejs/node/pull/10100)
* [[`3aa51ecb6f`](https://github.com/nodejs/node/commit/3aa51ecb6f)] - **test**: refactor test-crypto-ecb (michael6) [#10029](https://github.com/nodejs/node/pull/10029)
* [[`af5c4a9958`](https://github.com/nodejs/node/commit/af5c4a9958)] - **test**: refactor test-require-exceptions (Oscar Martinez) [#9882](https://github.com/nodejs/node/pull/9882)
* [[`26d61c3dbc`](https://github.com/nodejs/node/commit/26d61c3dbc)] - **test**: refactor test-console (Matt Crummey) [#9873](https://github.com/nodejs/node/pull/9873)
* [[`5ba08d9473`](https://github.com/nodejs/node/commit/5ba08d9473)] - **test**: refactor test-crypto-certificate (Josh Mays) [#9911](https://github.com/nodejs/node/pull/9911)
* [[`81def1857d`](https://github.com/nodejs/node/commit/81def1857d)] - **test**: refactor dgram-send-multi-buffer-copy (Konstantin Likhter) [#9909](https://github.com/nodejs/node/pull/9909)
* [[`6fc75ba498`](https://github.com/nodejs/node/commit/6fc75ba498)] - **test**: refactor test-domain (Johnny Reading) [#9890](https://github.com/nodejs/node/pull/9890)
* [[`b343a584e6`](https://github.com/nodejs/node/commit/b343a584e6)] - **test**: refactor test-cli-syntax (Exlipse7) [#10057](https://github.com/nodejs/node/pull/10057)
* [[`76dda9ca37`](https://github.com/nodejs/node/commit/76dda9ca37)] - **test**: refactor test-child-process-constructor (k3kathy) [#10060](https://github.com/nodejs/node/pull/10060)
* [[`f78b81750d`](https://github.com/nodejs/node/commit/f78b81750d)] - **test**: refactor test-repl-mode.js (Cesar Hernandez) [#10061](https://github.com/nodejs/node/pull/10061)
* [[`2127798eaa`](https://github.com/nodejs/node/commit/2127798eaa)] - **test**: var to const, assert.equal to assert.strictEqual in net (Sean Villars) [#9907](https://github.com/nodejs/node/pull/9907)
* [[`cf9f6f8dbf`](https://github.com/nodejs/node/commit/cf9f6f8dbf)] - **test**: changed vars to const in test-net-better-error-messages-listen-path.js (anoff) [#9905](https://github.com/nodejs/node/pull/9905)
* [[`e9d4665b29`](https://github.com/nodejs/node/commit/e9d4665b29)] - **test**: use const instead of var in test-require-json.js (Sarah Meyer) [#9904](https://github.com/nodejs/node/pull/9904)
* [[`f4b6b9faa7`](https://github.com/nodejs/node/commit/f4b6b9faa7)] - **test**: refactor test-http-dns-error (Outsider) [#10062](https://github.com/nodejs/node/pull/10062)
* [[`7a228fe4ae`](https://github.com/nodejs/node/commit/7a228fe4ae)] - **test**: Changed assert.equal to assert.strictEqual (Daniel Pittman) [#9902](https://github.com/nodejs/node/pull/9902)
* [[`7c4b59f9b1`](https://github.com/nodejs/node/commit/7c4b59f9b1)] - **test**: refactor test-vm-syntax-error-stderr.js (Jay Brownlee) [#9900](https://github.com/nodejs/node/pull/9900)
* [[`5d28864d7f`](https://github.com/nodejs/node/commit/5d28864d7f)] - **test**: refactor test-tls-destroy-whilst-write (Chris Bystrek) [#10064](https://github.com/nodejs/node/pull/10064)
* [[`1c3227fd8c`](https://github.com/nodejs/node/commit/1c3227fd8c)] - **test**: refactor test-net-dns-custom-lookup (Kent.Fan) [#10071](https://github.com/nodejs/node/pull/10071)
* [[`9b7d7487ef`](https://github.com/nodejs/node/commit/9b7d7487ef)] - **test**: refactor test-https-truncate (davidmarkclements) [#10074](https://github.com/nodejs/node/pull/10074)
* [[`d698f9d0ac`](https://github.com/nodejs/node/commit/d698f9d0ac)] - **test**: refactor test-tls-server-verify (Hutson Betts) [#10076](https://github.com/nodejs/node/pull/10076)
* [[`7277c376c2`](https://github.com/nodejs/node/commit/7277c376c2)] - **test**: use strictEqual in test-cli-eval-event.js (Richard Karmazin) [#9964](https://github.com/nodejs/node/pull/9964)
* [[`404306fd0e`](https://github.com/nodejs/node/commit/404306fd0e)] - **test**: refactor test-crypto-padding.js (Konstantin Likhter) [#9971](https://github.com/nodejs/node/pull/9971)
* [[`821518d4e4`](https://github.com/nodejs/node/commit/821518d4e4)] - **test**: refactor test-tls-friendly-error-message.js (Adrian Estrada) [#9967](https://github.com/nodejs/node/pull/9967)
* [[`55269c106b`](https://github.com/nodejs/node/commit/55269c106b)] - **test**: refactor test-fs-append-file.js (adelmann) [#10110](https://github.com/nodejs/node/pull/10110)
* [[`bffbf6881a`](https://github.com/nodejs/node/commit/bffbf6881a)] - **test**: assert.equal -> assert.strictEqual (davidmarkclements) [#10065](https://github.com/nodejs/node/pull/10065)
* [[`f10c3210a1`](https://github.com/nodejs/node/commit/f10c3210a1)] - **test**: refactor test-dgram-exclusive-implicit-bind (Cesar Hernandez) [#10066](https://github.com/nodejs/node/pull/10066)
* [[`67b11a429b`](https://github.com/nodejs/node/commit/67b11a429b)] - **test**: assert.equal -> assert.strictEqual (davidmarkclements) [#10067](https://github.com/nodejs/node/pull/10067)
* [[`bb950a6997`](https://github.com/nodejs/node/commit/bb950a6997)] - **test**: improve test for crypto padding (Julian Duque) [#9906](https://github.com/nodejs/node/pull/9906)
* [[`7bf13f3834`](https://github.com/nodejs/node/commit/7bf13f3834)] - **test**: polish test-net-better-error-messages-listen (Hitesh Kanwathirtha) [#10087](https://github.com/nodejs/node/pull/10087)
* [[`776cfc5898`](https://github.com/nodejs/node/commit/776cfc5898)] - **test**: change var to const in test-tls-key-mismatch.js (bjdelro) [#9897](https://github.com/nodejs/node/pull/9897)
* [[`f3ef0d9c1b`](https://github.com/nodejs/node/commit/f3ef0d9c1b)] - **test**: use strictEqual in cwd-enoent (JDHarmon) [#10077](https://github.com/nodejs/node/pull/10077)
* [[`5377f72b5a`](https://github.com/nodejs/node/commit/5377f72b5a)] - **test**: refactor test-fs-read-stream-inherit.js (Jonathan Darling) [#9894](https://github.com/nodejs/node/pull/9894)
* [[`a11f9ab82e`](https://github.com/nodejs/node/commit/a11f9ab82e)] - **test**: refactor test-child-process-stdio-inherit (Wes Tyler) [#9893](https://github.com/nodejs/node/pull/9893)
* [[`80e3aabedd`](https://github.com/nodejs/node/commit/80e3aabedd)] - **test**: change var to const for require and strict equality checks (Harish Tejwani) [#9892](https://github.com/nodejs/node/pull/9892)
* [[`8097b3b1ec`](https://github.com/nodejs/node/commit/8097b3b1ec)] - **test**: Update to const and use regex for assertions (Daniel Flores) [#9891](https://github.com/nodejs/node/pull/9891)
* [[`6d5b21517a`](https://github.com/nodejs/node/commit/6d5b21517a)] - **test**: swap var->const/let and equal->strictEqual (Peter Masucci) [#9888](https://github.com/nodejs/node/pull/9888)
* [[`5446b3c6a0`](https://github.com/nodejs/node/commit/5446b3c6a0)] - **test**: replace equal with strictEqual in crypto (Julian Duque) [#9886](https://github.com/nodejs/node/pull/9886)
* [[`0c66f68fe2`](https://github.com/nodejs/node/commit/0c66f68fe2)] - **test**: replace equal with strictEqual (Julian Duque) [#9879](https://github.com/nodejs/node/pull/9879)
* [[`c5bfe90900`](https://github.com/nodejs/node/commit/c5bfe90900)] - **test**: var to const/let in test-tls-set-ciphers (rajatk) [#9877](https://github.com/nodejs/node/pull/9877)
* [[`7fa3b6fad3`](https://github.com/nodejs/node/commit/7fa3b6fad3)] - **test**: refactor test-tls-timeout-server-2 (Devon Rifkin) [#9876](https://github.com/nodejs/node/pull/9876)
* [[`e6747048e7`](https://github.com/nodejs/node/commit/e6747048e7)] - **test**: Updating vars to const and tsl server test (Matt Webb) [#9874](https://github.com/nodejs/node/pull/9874)
* [[`393cb97cbb`](https://github.com/nodejs/node/commit/393cb97cbb)] - **test**: refactor test-crypto-hash-stream-pipe (Matt Wilson) [#10055](https://github.com/nodejs/node/pull/10055)
* [[`b48d83190a`](https://github.com/nodejs/node/commit/b48d83190a)] - **test**: crypto-hash-stream-pipe use strict equal (Mitchell Stoutin) [#9935](https://github.com/nodejs/node/pull/9935)
* [[`91b942ec8a`](https://github.com/nodejs/node/commit/91b942ec8a)] - **test**: refactor child-process-spawn-error (Johnny Reading) [#9951](https://github.com/nodejs/node/pull/9951)
* [[`a2e88f6e0c`](https://github.com/nodejs/node/commit/a2e88f6e0c)] - **test**: refactor test-child-process-spawn-error (stokingerl) [#9937](https://github.com/nodejs/node/pull/9937)
* [[`52cc1bb08e`](https://github.com/nodejs/node/commit/52cc1bb08e)] - **test**: refactor test-vm-static-this.js (David Bradford) [#9887](https://github.com/nodejs/node/pull/9887)
* [[`895472474b`](https://github.com/nodejs/node/commit/895472474b)] - **test**: refactor test-crypto-cipheriv-decipheriv (Aileen) [#10018](https://github.com/nodejs/node/pull/10018)
* [[`c4277d9b5e`](https://github.com/nodejs/node/commit/c4277d9b5e)] - **test**: refactor test for crypto cipher/decipher iv (Julian Duque) [#9943](https://github.com/nodejs/node/pull/9943)
* [[`346ea432b4`](https://github.com/nodejs/node/commit/346ea432b4)] - **test**: refactor test-cluster-setup-master-argv (Oscar Martinez) [#9960](https://github.com/nodejs/node/pull/9960)
* [[`5009de4a53`](https://github.com/nodejs/node/commit/5009de4a53)] - **test**: refactor test-cluster-setup-master-argv (Christine Hong) [#9993](https://github.com/nodejs/node/pull/9993)
* [[`e75f81495d`](https://github.com/nodejs/node/commit/e75f81495d)] - **test**: refactor test-fs-append-file-sync (Chris Bystrek) [#10056](https://github.com/nodejs/node/pull/10056)
* [[`61225eac1a`](https://github.com/nodejs/node/commit/61225eac1a)] - **test**: refactor test-fs-append-file-sync (Ian White) [#9977](https://github.com/nodejs/node/pull/9977)
* [[`f093760166`](https://github.com/nodejs/node/commit/f093760166)] - **test**: use assert.strictEqual in test-crypto-ecb (Daniel Pittman) [#9980](https://github.com/nodejs/node/pull/9980)
* [[`1bbaace480`](https://github.com/nodejs/node/commit/1bbaace480)] - **test**: refactor test-fs-write-file (adelmann) [#10030](https://github.com/nodejs/node/pull/10030)
* [[`ac5bf86fd1`](https://github.com/nodejs/node/commit/ac5bf86fd1)] - **test**: refactor test/parallel/test-fs-write-file.js (Kyle Carter) [#9992](https://github.com/nodejs/node/pull/9992)
* [[`bf71b63444`](https://github.com/nodejs/node/commit/bf71b63444)] - **test**: update to const iin cluster test (Greg Valdez) [#10007](https://github.com/nodejs/node/pull/10007)
* [[`a36389ee08`](https://github.com/nodejs/node/commit/a36389ee08)] - **test**: use assert.strictEqual() cluster test (Bidur Adhikari) [#10042](https://github.com/nodejs/node/pull/10042)
* [[`effa15ead9`](https://github.com/nodejs/node/commit/effa15ead9)] - **test**: use const in test-crypto-pbkdf2 (Greg Valdez) [#9974](https://github.com/nodejs/node/pull/9974)
* [[`59f643096a`](https://github.com/nodejs/node/commit/59f643096a)] - **test**: improve test for crypto pbkdf2 (joyeecheung) [#9883](https://github.com/nodejs/node/pull/9883)
* [[`503167ba36`](https://github.com/nodejs/node/commit/503167ba36)] - **test**: var -> let/const, .equal -> .strictEqual (shiya) [#9913](https://github.com/nodejs/node/pull/9913)
* [[`f1d0bf4757`](https://github.com/nodejs/node/commit/f1d0bf4757)] - **test**: increase coverage for timers (lrlna) [#10068](https://github.com/nodejs/node/pull/10068)
* [[`e14a597d35`](https://github.com/nodejs/node/commit/e14a597d35)] - **test**: change equal to strictEqual (Kevin Zurawel) [#9872](https://github.com/nodejs/node/pull/9872)
* [[`076c2c2c54`](https://github.com/nodejs/node/commit/076c2c2c54)] - **test**: test for http.request() invalid method error (Ashton Kinslow) [#10080](https://github.com/nodejs/node/pull/10080)
* [[`f38cb9bbe2`](https://github.com/nodejs/node/commit/f38cb9bbe2)] - **test**: update net-local-address-port (scalkpdev) [#9885](https://github.com/nodejs/node/pull/9885)
* [[`c9ac2b366f`](https://github.com/nodejs/node/commit/c9ac2b366f)] - **test**: refactor test-tls-ecdh (Adriana Rios) [#9878](https://github.com/nodejs/node/pull/9878)
* [[`5186604fa9`](https://github.com/nodejs/node/commit/5186604fa9)] - **test**: refactor test-vm-debug-context (makenova) [#9875](https://github.com/nodejs/node/pull/9875)
* [[`fcc511a57b`](https://github.com/nodejs/node/commit/fcc511a57b)] - **test**: use strictEqual in test-zlib-truncated (ben_cripps) [#9858](https://github.com/nodejs/node/pull/9858)
* [[`e55a5936cd`](https://github.com/nodejs/node/commit/e55a5936cd)] - **test**: use strictEqual in test-debugger-client.js (ben_cripps) [#9857](https://github.com/nodejs/node/pull/9857)
* [[`a773843c01`](https://github.com/nodejs/node/commit/a773843c01)] - **test**: refactor test-debug-args (Rich Trott) [#9833](https://github.com/nodejs/node/pull/9833)
* [[`015812e2b8`](https://github.com/nodejs/node/commit/015812e2b8)] - **test**: refactor test-fs-non-number-arguments-throw (Michaël Zasso) [#9844](https://github.com/nodejs/node/pull/9844)
* [[`74919eb5ef`](https://github.com/nodejs/node/commit/74919eb5ef)] - **test**: replace assert.equal with assert.strictEqual (brad-decker) [#9842](https://github.com/nodejs/node/pull/9842)
* [[`0605c74538`](https://github.com/nodejs/node/commit/0605c74538)] - **test**: refactor test-crypto-timing-safe-equal (Michaël Zasso) [#9843](https://github.com/nodejs/node/pull/9843)
* [[`b93c3d89f5`](https://github.com/nodejs/node/commit/b93c3d89f5)] - **test**: add toASCII and toUnicode punycode tests (Claudio Rodriguez) [#9741](https://github.com/nodejs/node/pull/9741)
* [[`51c8fe0c66`](https://github.com/nodejs/node/commit/51c8fe0c66)] - **test**: refactor test-util-inspect (Rich Trott) [#9804](https://github.com/nodejs/node/pull/9804)
* [[`e2e51c52c9`](https://github.com/nodejs/node/commit/e2e51c52c9)] - **test**: refactor test-preload (Rich Trott) [#9803](https://github.com/nodejs/node/pull/9803)
* [[`8c6b127c93`](https://github.com/nodejs/node/commit/8c6b127c93)] - **test**: refine test-http-status-reason-invalid-chars (Rich Trott) [#9802](https://github.com/nodejs/node/pull/9802)
* [[`ca0e577673`](https://github.com/nodejs/node/commit/ca0e577673)] - **test**: refactor test-crypto-binary-default (Michaël Zasso) [#9810](https://github.com/nodejs/node/pull/9810)
* [[`3219586512`](https://github.com/nodejs/node/commit/3219586512)] - **test**: refactor test-net-pingpong (Michaël Zasso) [#9812](https://github.com/nodejs/node/pull/9812)
* [[`ca461bf561`](https://github.com/nodejs/node/commit/ca461bf561)] - **test**: refactor and fix test-dns (Michaël Zasso) [#9811](https://github.com/nodejs/node/pull/9811)
* [[`aebc8dfa57`](https://github.com/nodejs/node/commit/aebc8dfa57)] - **test**: fix flaky test-cluster-dgram-2 (Rich Trott) [#9791](https://github.com/nodejs/node/pull/9791)
* [[`5542a72558`](https://github.com/nodejs/node/commit/5542a72558)] - **test**: fix test-tls-connect-address-family (mkamakura) [#9573](https://github.com/nodejs/node/pull/9573)
* [[`6105c91f89`](https://github.com/nodejs/node/commit/6105c91f89)] - **test**: fix test-http-status-reason-invalid-chars (Yosuke Saito) [#9572](https://github.com/nodejs/node/pull/9572)
* [[`d1f5e99a2a`](https://github.com/nodejs/node/commit/d1f5e99a2a)] - **test**: refactor test-child-process-exec-error (Rich Trott) [#9780](https://github.com/nodejs/node/pull/9780)
* [[`0772984cb3`](https://github.com/nodejs/node/commit/0772984cb3)] - **test**: refactor common.js (Rich Trott) [#9732](https://github.com/nodejs/node/pull/9732)
* [[`605c84f8d6`](https://github.com/nodejs/node/commit/605c84f8d6)] - **test**: exclude no_interleaved_stdio test for AIX (Michael Dawson) [#9772](https://github.com/nodejs/node/pull/9772)
* [[`75bebbf3a0`](https://github.com/nodejs/node/commit/75bebbf3a0)] - **test**: fix flaky test-dgram-empty-packet & friends (Rich Trott) [#9724](https://github.com/nodejs/node/pull/9724)
* [[`1296a689b6`](https://github.com/nodejs/node/commit/1296a689b6)] - **test**: fix flaky test-inspector (Rich Trott) [#9727](https://github.com/nodejs/node/pull/9727)
* [[`c5e806c894`](https://github.com/nodejs/node/commit/c5e806c894)] - **test**: refactor test-tls-hello-parser-failure (Rich Trott) [#9715](https://github.com/nodejs/node/pull/9715)
* [[`9e4ce6fc8e`](https://github.com/nodejs/node/commit/9e4ce6fc8e)] - **test**: refactor test-async-wrap-* (Rich Trott) [#9663](https://github.com/nodejs/node/pull/9663)
* [[`31304144cd`](https://github.com/nodejs/node/commit/31304144cd)] - **test**: Use strictEqual in test-tls-writewrap-leak (Aaron Petcoff) [#9666](https://github.com/nodejs/node/pull/9666)
* [[`333e5d1c49`](https://github.com/nodejs/node/commit/333e5d1c49)] - **test**: run tests even if os.cpus() fails (Bethany Griggs) [#9616](https://github.com/nodejs/node/pull/9616)
* [[`1bb626610a`](https://github.com/nodejs/node/commit/1bb626610a)] - **test**: use setImmediate() in test of stream2 (masashi.g) [#9583](https://github.com/nodejs/node/pull/9583)
* [[`70691e3c53`](https://github.com/nodejs/node/commit/70691e3c53)] - **test**: add test case of PassThrough (Yoshiya Hinosawa) [#9581](https://github.com/nodejs/node/pull/9581)
* [[`7e031170a6`](https://github.com/nodejs/node/commit/7e031170a6)] - **test**: check that `process.execPath` is a realpath (Anna Henningsen) [#9229](https://github.com/nodejs/node/pull/9229)
* [[`14fead0299`](https://github.com/nodejs/node/commit/14fead0299)] - **test**: add test for broken child process stdio (cjihrig) [#9528](https://github.com/nodejs/node/pull/9528)
* [[`2c5e6afd97`](https://github.com/nodejs/node/commit/2c5e6afd97)] - **test**: ensure nextTick is not scheduled in exit (Jeremiah Senkpiel) [#9555](https://github.com/nodejs/node/pull/9555)
* [[`f7a2f75fa9`](https://github.com/nodejs/node/commit/f7a2f75fa9)] - **test**: increase coverage of process.emitWarning (Jeremiah Senkpiel) [#9556](https://github.com/nodejs/node/pull/9556)
* [[`7bd9ecdb14`](https://github.com/nodejs/node/commit/7bd9ecdb14)] - **test**: refactor test-zlib.js (Rich Trott) [#9544](https://github.com/nodejs/node/pull/9544)
* [[`8a94c69c79`](https://github.com/nodejs/node/commit/8a94c69c79)] - **test**: change from setTimeout to setImmediate (MURAKAMI Masahiko) [#9578](https://github.com/nodejs/node/pull/9578)
* [[`92f8073879`](https://github.com/nodejs/node/commit/92f8073879)] - **test**: improve test-stream2-objects.js (Yoshiya Hinosawa) [#9565](https://github.com/nodejs/node/pull/9565)
* [[`64d7ea9ce4`](https://github.com/nodejs/node/commit/64d7ea9ce4)] - **test**: refactor test-next-tick-error-spin (Rich Trott) [#9537](https://github.com/nodejs/node/pull/9537)
* [[`d8eb4c2595`](https://github.com/nodejs/node/commit/d8eb4c2595)] - **test**: refactor test-tls-inception (Rich Trott) [#9536](https://github.com/nodejs/node/pull/9536)
* [[`0db54ab98e`](https://github.com/nodejs/node/commit/0db54ab98e)] - **test**: refactor inspector-helper.js (Rich Trott) [#9499](https://github.com/nodejs/node/pull/9499)
* [[`31a3328269`](https://github.com/nodejs/node/commit/31a3328269)] - **test**: refactor make-callback-recurse test (Rich Trott) [#9498](https://github.com/nodejs/node/pull/9498)
* [[`9808985689`](https://github.com/nodejs/node/commit/9808985689)] - **test**: move timer-dependent test to sequential (Rich Trott) [#9487](https://github.com/nodejs/node/pull/9487)
* [[`e97c610850`](https://github.com/nodejs/node/commit/e97c610850)] - **test**: fix helper-debugger-repl.js (Rich Trott) [#9486](https://github.com/nodejs/node/pull/9486)
* [[`13b16881ef`](https://github.com/nodejs/node/commit/13b16881ef)] - **test,url**: improve escaping in url.parse (joyeecheung) [#10083](https://github.com/nodejs/node/pull/10083)
* [[`8bb66cd920`](https://github.com/nodejs/node/commit/8bb66cd920)] - **timers**: use consistent checks for canceled timers (Jeremiah Senkpiel) [#9685](https://github.com/nodejs/node/pull/9685)
* [[`e355604aa5`](https://github.com/nodejs/node/commit/e355604aa5)] - **tools**: forbid template literals in assert.throws (Michaël Zasso) [#10301](https://github.com/nodejs/node/pull/10301)
* [[`9c85d0f396`](https://github.com/nodejs/node/commit/9c85d0f396)] - **tools**: add ESLint rule for assert.throws arguments (Michaël Zasso) [#10089](https://github.com/nodejs/node/pull/10089)
* [[`a5d27f3515`](https://github.com/nodejs/node/commit/a5d27f3515)] - **tools**: enable final newline in .editorconfig (Roman Reiss) [#9410](https://github.com/nodejs/node/pull/9410)
* [[`e94b72e41e`](https://github.com/nodejs/node/commit/e94b72e41e)] - **tools**: remove unneeded escaping in generate.js (Rich Trott) [#9781](https://github.com/nodejs/node/pull/9781)
* [[`f05f0fe74e`](https://github.com/nodejs/node/commit/f05f0fe74e)] - **tools**: disallow trailing whitespace for markdown (Sam Roberts) [#9676](https://github.com/nodejs/node/pull/9676)
* [[`0256b7b057`](https://github.com/nodejs/node/commit/0256b7b057)] - **tools**: use better regexp for manpage references (Anna Henningsen) [#9632](https://github.com/nodejs/node/pull/9632)
* [[`232026d8b9`](https://github.com/nodejs/node/commit/232026d8b9)] - **tools**: improve docopen target in Makefile (Sakthipriyan Vairamani (thefourtheye)) [#9436](https://github.com/nodejs/node/pull/9436)
* [[`79e0577702`](https://github.com/nodejs/node/commit/79e0577702)] - **tools**: make run-valgrind.py useful (Ben Noordhuis) [#9520](https://github.com/nodejs/node/pull/9520)
* [[`8a8646c0b2`](https://github.com/nodejs/node/commit/8a8646c0b2)] - **tools**: fix run-valgrind.py script (Ben Noordhuis) [#9520](https://github.com/nodejs/node/pull/9520)
* [[`5401b04648`](https://github.com/nodejs/node/commit/5401b04648)] - **tools**: copy run-valgrind.py to tools/ (Ben Noordhuis) [#9520](https://github.com/nodejs/node/pull/9520)
* [[`12fe071abf`](https://github.com/nodejs/node/commit/12fe071abf)] - **util**: move the case 'latin1' (Jackson Tian) [#9646](https://github.com/nodejs/node/pull/9646)

<a id="6.9.2"></a>
## 2016-12-06, Version 6.9.2 'Boron' (LTS), @thealphanerd

This LTS release comes with 144 commits. This includes 47 that are docs
related, 46 that are test related, 15 which are build / tools related, and 9
commits which are updates to dependencies.

### Notable Changes

* **buffer**: coerce slice parameters consistently (Sakthipriyan Vairamani (thefourtheye)) [#9101](https://github.com/nodejs/node/pull/9101)
* **deps**:
  * *npm*: upgrade npm to 3.10.9 (Kat Marchán) [#9286](https://github.com/nodejs/node/pull/9286)
  * *V8*: Various fixes to destructuring edge cases
    * cherry-pick 3c39bac from V8 upstream (Cristian Cavalli) [#9138](https://github.com/nodejs/node/pull/9138)
    * cherry pick 7166503 from upstream v8 (Cristian Cavalli) [#9173](https://github.com/nodejs/node/pull/9173)
* **gtest**: the test reporter now outputs tap comments as yamlish (Johan Bergström) [#9262](https://github.com/nodejs/node/pull/9262)
* **inspector**: inspector now prompts user to use 127.0.0.1 rather than localhost (Eugene Ostroukhov) [#9451](https://github.com/nodejs/node/pull/9451)
* **tls**: fix memory leak when writing data to TLSWrap instance during handshake (Fedor Indutny) [#9586](https://github.com/nodejs/node/pull/9586)

### Commits

* [[`f3b0cf5052`](https://github.com/nodejs/node/commit/f3b0cf5052)] - **async_wrap**: call destroy() callback in uv_idle_t (Trevor Norris) [#10096](https://github.com/nodejs/node/pull/10096)
* [[`3e5b2eb49c`](https://github.com/nodejs/node/commit/3e5b2eb49c)] - **async_wrap**: make Initialize a static class member (Trevor Norris) [#10096](https://github.com/nodejs/node/pull/10096)
* [[`9ed60d308c`](https://github.com/nodejs/node/commit/9ed60d308c)] - **async_wrap**: mode constructor/destructor to .cc (Trevor Norris) [#10096](https://github.com/nodejs/node/pull/10096)
* [[`5eeac8cc57`](https://github.com/nodejs/node/commit/5eeac8cc57)] - **benchmark**: add microbenchmarks for ES Map (Rod Vagg) [#7581](https://github.com/nodejs/node/pull/7581)
* [[`e108f20d5c`](https://github.com/nodejs/node/commit/e108f20d5c)] - **buffer**: use correct name for custom inspect symbol (Charmander) [#9289](https://github.com/nodejs/node/pull/9289)
* [[`0cffa3c87e`](https://github.com/nodejs/node/commit/0cffa3c87e)] - **buffer**: coerce offset using Math.trunc() (cjihrig) [#9341](https://github.com/nodejs/node/pull/9341)
* [[`0276e9e82c`](https://github.com/nodejs/node/commit/0276e9e82c)] - **buffer**: coerce slice parameters consistently (Sakthipriyan Vairamani (thefourtheye)) [#9101](https://github.com/nodejs/node/pull/9101)
* [[`c1aee029d5`](https://github.com/nodejs/node/commit/c1aee029d5)] - **build**: start comments at beginning of line (Sakthipriyan Vairamani (thefourtheye)) [#9375](https://github.com/nodejs/node/pull/9375)
* [[`1ed58ed7fe`](https://github.com/nodejs/node/commit/1ed58ed7fe)] - **build**: reduce noise from doc target (Daniel Bevenius) [#9457](https://github.com/nodejs/node/pull/9457)
* [[`5c2ed2eefe`](https://github.com/nodejs/node/commit/5c2ed2eefe)] - **build**: make node-gyp output silent (Sakthipriyan Vairamani (thefourtheye)) [#8990](https://github.com/nodejs/node/pull/8990)
* [[`c857586fd7`](https://github.com/nodejs/node/commit/c857586fd7)] - **build**: use wxneeded on openbsd (Aaron Bieber) [#9232](https://github.com/nodejs/node/pull/9232)
* [[`9de8cfecd9`](https://github.com/nodejs/node/commit/9de8cfecd9)] - **build**: fix config.gypi target (Daniel Bevenius) [#9053](https://github.com/nodejs/node/pull/9053)
* [[`b867294aa0`](https://github.com/nodejs/node/commit/b867294aa0)] - **child_process**: remove unreachable execSync() code (cjihrig) [#9209](https://github.com/nodejs/node/pull/9209)
* [[`cbfde3cd0a`](https://github.com/nodejs/node/commit/cbfde3cd0a)] - **child_process**: update outdated comment (Tanuja-Sawant)
* [[`4d4d02ace4`](https://github.com/nodejs/node/commit/4d4d02ace4)] - **crypto**: fix faulty logic in iv size check (Ben Noordhuis) [#9032](https://github.com/nodejs/node/pull/9032)
* [[`9cfa91b585`](https://github.com/nodejs/node/commit/9cfa91b585)] - **crypto**: use SSL_get_SSL_CTX. (Adam Langley) [#8995](https://github.com/nodejs/node/pull/8995)
* [[`0d15ec82e3`](https://github.com/nodejs/node/commit/0d15ec82e3)] - **deps**: cherry pick 7166503 from upstream v8 (Cristian Cavalli) [#9173](https://github.com/nodejs/node/pull/9173)
* [[`f0a8bcc735`](https://github.com/nodejs/node/commit/f0a8bcc735)] - **deps**: back port OpenBSD fix in c-ares/c-ares (Aaron Bieber) [#9232](https://github.com/nodejs/node/pull/9232)
* [[`96e8e869c0`](https://github.com/nodejs/node/commit/96e8e869c0)] - **deps**: cherry-pick 6f68f30 from v8 upstream (Stefan Budeanu) [#9610](https://github.com/nodejs/node/pull/9610)
* [[`804b398239`](https://github.com/nodejs/node/commit/804b398239)] - **deps**: revert botched V8 backport (Myles Borins) [#9610](https://github.com/nodejs/node/pull/9610)
* [[`a8840bbbe4`](https://github.com/nodejs/node/commit/a8840bbbe4)] - **deps**: cherry-pick 3c39bac from V8 upstream (Cristian Cavalli) [#9138](https://github.com/nodejs/node/pull/9138)
* [[`bda45b510c`](https://github.com/nodejs/node/commit/bda45b510c)] - **deps**: backport 5c8cb16 from upstream V8 (Cristian Cavalli) [#9422](https://github.com/nodejs/node/pull/9422)
* [[`39b4a1ca9b`](https://github.com/nodejs/node/commit/39b4a1ca9b)] - **deps**: revert default gtest reporter change (Brian White) [#8948](https://github.com/nodejs/node/pull/8948)
* [[`2230c26c49`](https://github.com/nodejs/node/commit/2230c26c49)] - **deps**: upgrade npm to 3.10.9 (Kat Marchán) [#9286](https://github.com/nodejs/node/pull/9286)
* [[`0fcf249078`](https://github.com/nodejs/node/commit/0fcf249078)] - **deps**: cherry-pick bb4974d from v8 upstream (Matt Loring) [#9192](https://github.com/nodejs/node/pull/9192)
* [[`d926f16c52`](https://github.com/nodejs/node/commit/d926f16c52)] - **doc**: update minute-taking procedure for CTC (Rich Trott) [#9425](https://github.com/nodejs/node/pull/9425)
* [[`6fc0f1b99f`](https://github.com/nodejs/node/commit/6fc0f1b99f)] - **doc**: note that tests should include a description (Gibson Fahnestock) [#9415](https://github.com/nodejs/node/pull/9415)
* [[`d36c6f5e2e`](https://github.com/nodejs/node/commit/d36c6f5e2e)] - **doc**: update GOVERNANCE.md to use "meeting chair" (Rich Trott) [#9432](https://github.com/nodejs/node/pull/9432)
* [[`1726dc7f68`](https://github.com/nodejs/node/commit/1726dc7f68)] - **doc**: update Diagnostics WG info (Josh Gavant) [#9329](https://github.com/nodejs/node/pull/9329)
* [[`7b60288942`](https://github.com/nodejs/node/commit/7b60288942)] - **doc**: use 'an' over 'a', remove redundant sentence (Zeke Sikelianos) [#9345](https://github.com/nodejs/node/pull/9345)
* [[`6908bc4ed7`](https://github.com/nodejs/node/commit/6908bc4ed7)] - **doc**: add more internal links to fs.Stats object (Zeke Sikelianos) [#9345](https://github.com/nodejs/node/pull/9345)
* [[`5d971afc04`](https://github.com/nodejs/node/commit/5d971afc04)] - **doc**: fix outdate ninja link (Yangyang Liu) [#9278](https://github.com/nodejs/node/pull/9278)
* [[`c31fa2468f`](https://github.com/nodejs/node/commit/c31fa2468f)] - **doc**: fix broken links to Buffer.from(string) (Jesse McCarthy) [#9294](https://github.com/nodejs/node/pull/9294)
* [[`c379c29e1f`](https://github.com/nodejs/node/commit/c379c29e1f)] - **doc**: fs: fix link to mkdtemp (coderaiser) [#9379](https://github.com/nodejs/node/pull/9379)
* [[`7c90d9638a`](https://github.com/nodejs/node/commit/7c90d9638a)] - **doc**: update OpenSSL links (kobelb) [#9338](https://github.com/nodejs/node/pull/9338)
* [[`627c0cb3ee`](https://github.com/nodejs/node/commit/627c0cb3ee)] - **doc**: child_process .stdio accepts a String type (Kenneth Skovhus) [#9637](https://github.com/nodejs/node/pull/9637)
* [[`653f092639`](https://github.com/nodejs/node/commit/653f092639)] - **doc**: simplify process.memoryUsage() example code (Thomas Watson Steen) [#9560](https://github.com/nodejs/node/pull/9560)
* [[`d2b0caef33`](https://github.com/nodejs/node/commit/d2b0caef33)] - **doc**: update CONTRIBUTING.md to address editing PRs (Gibson Fahnestock) [#9259](https://github.com/nodejs/node/pull/9259)
* [[`eeaadcdd6a`](https://github.com/nodejs/node/commit/eeaadcdd6a)] - **doc**: add italoacasas to collaborators (Italo A. Casas) [#9677](https://github.com/nodejs/node/pull/9677)
* [[`adee93962a`](https://github.com/nodejs/node/commit/adee93962a)] - **doc**: more realistic custom inspect example (Ryan Scheel (Havvy)) [#8875](https://github.com/nodejs/node/pull/8875)
* [[`ae3ce7ff60`](https://github.com/nodejs/node/commit/ae3ce7ff60)] - **doc**: clarify buffer toString docs. (Olan Byrne) [#8984](https://github.com/nodejs/node/pull/8984)
* [[`a5860b4dbd`](https://github.com/nodejs/node/commit/a5860b4dbd)] - **doc**: clarify relation between a file and a module (marzelin) [#9026](https://github.com/nodejs/node/pull/9026)
* [[`6f212b910b`](https://github.com/nodejs/node/commit/6f212b910b)] - **doc**: mention case-insensitive env on windows (Oliver Salzburg) [#9166](https://github.com/nodejs/node/pull/9166)
* [[`ee01594d07`](https://github.com/nodejs/node/commit/ee01594d07)] - **doc**: fixes formatting in process (Rod Machen) [#9235](https://github.com/nodejs/node/pull/9235)
* [[`4f2523697c`](https://github.com/nodejs/node/commit/4f2523697c)] - **doc**: fix link to cli.md in vm.md (Daniel Bevenius) [#9481](https://github.com/nodejs/node/pull/9481)
* [[`1b792742e8`](https://github.com/nodejs/node/commit/1b792742e8)] - **doc**: add Sakthipriyan to the CTC (Rod Vagg) [#9427](https://github.com/nodejs/node/pull/9427)
* [[`4c4b0f7a0e`](https://github.com/nodejs/node/commit/4c4b0f7a0e)] - **doc**: add 2016-10-26 CTC meeting minutes (Rich Trott) [#9348](https://github.com/nodejs/node/pull/9348)
* [[`925a51b6a5`](https://github.com/nodejs/node/commit/925a51b6a5)] - **doc**: add 2016-10-05 CTC meeting minutes (Josh Gavant) [#9326](https://github.com/nodejs/node/pull/9326)
* [[`2a9fc7ccd3`](https://github.com/nodejs/node/commit/2a9fc7ccd3)] - **doc**: add 2016-09-28 CTC meeting minutes (Josh Gavant) [#9325](https://github.com/nodejs/node/pull/9325)
* [[`ae73ecbe3f`](https://github.com/nodejs/node/commit/ae73ecbe3f)] - **doc**: add 2016-10-19 CTC meeting minutes (Josh Gavant) [#9193](https://github.com/nodejs/node/pull/9193)
* [[`53de0c258f`](https://github.com/nodejs/node/commit/53de0c258f)] - **doc**: improve header styling for API docs (Jeremiah Senkpiel) [#8811](https://github.com/nodejs/node/pull/8811)
* [[`79e998abbb`](https://github.com/nodejs/node/commit/79e998abbb)] - **doc**: add CTC meeting minutes for 2016-10-12 (Michael Dawson) [#9070](https://github.com/nodejs/node/pull/9070)
* [[`3ee94f24a8`](https://github.com/nodejs/node/commit/3ee94f24a8)] - **doc**: remove confusing reference in governance doc (Rich Trott) [#9073](https://github.com/nodejs/node/pull/9073)
* [[`cfcf9481c7`](https://github.com/nodejs/node/commit/cfcf9481c7)] - **doc**: v6 is now LTS rather than Current (Jeremiah Senkpiel) [#9182](https://github.com/nodejs/node/pull/9182)
* [[`a03811508a`](https://github.com/nodejs/node/commit/a03811508a)] - **doc**: suggest nodejs/help for general support (Myles Borins) [#9128](https://github.com/nodejs/node/pull/9128)
* [[`e680ad552d`](https://github.com/nodejs/node/commit/e680ad552d)] - **doc**: fix header level for crypto.constants (Evan Lucas) [#9187](https://github.com/nodejs/node/pull/9187)
* [[`6c9a84b034`](https://github.com/nodejs/node/commit/6c9a84b034)] - **doc**: add ctc-review label information (Rich Trott) [#9072](https://github.com/nodejs/node/pull/9072)
* [[`bdd91e0d8e`](https://github.com/nodejs/node/commit/bdd91e0d8e)] - **doc**: fix typo in zlib.md (Parambir Singh) [#9123](https://github.com/nodejs/node/pull/9123)
* [[`fd006e5c46`](https://github.com/nodejs/node/commit/fd006e5c46)] - **doc**: further improve child_process doc types (Indrek Ardel) [#9095](https://github.com/nodejs/node/pull/9095)
* [[`e5777b344c`](https://github.com/nodejs/node/commit/e5777b344c)] - **doc**: edit Stream api grammar (Benji Marinacci) [#9100](https://github.com/nodejs/node/pull/9100)
* [[`2c5b27a247`](https://github.com/nodejs/node/commit/2c5b27a247)] - **doc**: improved example for http.get (marzelin) [#9065](https://github.com/nodejs/node/pull/9065)
* [[`de2f050ac3`](https://github.com/nodejs/node/commit/de2f050ac3)] - **doc**: update reference to list hash algorithms in crypto.md (scott stern) [#9043](https://github.com/nodejs/node/pull/9043)
* [[`b2a2a57836`](https://github.com/nodejs/node/commit/b2a2a57836)] - **doc**: specify that errno is a number, not a string (John Vilk) [#9007](https://github.com/nodejs/node/pull/9007)
* [[`0d21f951b2`](https://github.com/nodejs/node/commit/0d21f951b2)] - **doc**: highlight deprecated API in ToC (Ilya Frolov) [#7189](https://github.com/nodejs/node/pull/7189)
* [[`0a2a39cb95`](https://github.com/nodejs/node/commit/0a2a39cb95)] - **doc**: explains why Reviewed-By is added in PRs (jessicaquynh) [#9044](https://github.com/nodejs/node/pull/9044)
* [[`3af679ee36`](https://github.com/nodejs/node/commit/3af679ee36)] - **doc**: explain why GitHub merge button is not used (jessicaquynh) [#9044](https://github.com/nodejs/node/pull/9044)
* [[`c0f8198d64`](https://github.com/nodejs/node/commit/c0f8198d64)] - **doc**: fix typo (Nikolai Vavilov) [#9089](https://github.com/nodejs/node/pull/9089)
* [[`70eadea8e1`](https://github.com/nodejs/node/commit/70eadea8e1)] - **doc**: fix broken links in changelogs (Evan Lucas) [#8122](https://github.com/nodejs/node/pull/8122)
* [[`d3128996e0`](https://github.com/nodejs/node/commit/d3128996e0)] - **doc**: revise http documentation (Timothy Gu) [#8486](https://github.com/nodejs/node/pull/8486)
* [[`2ea5db92de`](https://github.com/nodejs/node/commit/2ea5db92de)] - **doc**: do not link in the headings (Sakthipriyan Vairamani (thefourtheye)) [#9416](https://github.com/nodejs/node/pull/9416)
* [[`ec90f73e64`](https://github.com/nodejs/node/commit/ec90f73e64)] - **doc**: reference signal(7) for the list of signals (Emanuele DelBono) [#9323](https://github.com/nodejs/node/pull/9323)
* [[`638ef09455`](https://github.com/nodejs/node/commit/638ef09455)] - **doc**: fix typo in http.md (anu0012) [#9144](https://github.com/nodejs/node/pull/9144)
* [[`4141c77a25`](https://github.com/nodejs/node/commit/4141c77a25)] - **gitignore**: ignore all tap files (Johan Bergström) [#9262](https://github.com/nodejs/node/pull/9262)
* [[`847b15c177`](https://github.com/nodejs/node/commit/847b15c177)] - **governance**: expand use of CTC issue tracker (Rich Trott) [#8945](https://github.com/nodejs/node/pull/8945)
* [[`575fc4eca0`](https://github.com/nodejs/node/commit/575fc4eca0)] - **gtest**: output tap comments as yamlish (Johan Bergström) [#9262](https://github.com/nodejs/node/pull/9262)
* [[`cf5a00e904`](https://github.com/nodejs/node/commit/cf5a00e904)] - **inspector**: do not prompt to use localhost (Eugene Ostroukhov) [#9451](https://github.com/nodejs/node/pull/9451)
* [[`b5bcd25c7b`](https://github.com/nodejs/node/commit/b5bcd25c7b)] - **inspector**: fix request path nullptr dereference (Ben Noordhuis) [#9184](https://github.com/nodejs/node/pull/9184)
* [[`b3f8f8902d`](https://github.com/nodejs/node/commit/b3f8f8902d)] - **inspector**: no URLs when the debugger is connected (Eugene Ostroukhov) [#8919](https://github.com/nodejs/node/pull/8919)
* [[`a178abfae6`](https://github.com/nodejs/node/commit/a178abfae6)] - **lib**: change == to === in linkedlist (jedireza) [#9362](https://github.com/nodejs/node/pull/9362)
* [[`5efb3c373a`](https://github.com/nodejs/node/commit/5efb3c373a)] - **lib**: fix beforeExit not working with -e (Ben Noordhuis) [#8821](https://github.com/nodejs/node/pull/8821)
* [[`0f1a22d28a`](https://github.com/nodejs/node/commit/0f1a22d28a)] - **net**: fix ambiguity in EOF handling (Fedor Indutny) [#9066](https://github.com/nodejs/node/pull/9066)
* [[`58b60fc79d`](https://github.com/nodejs/node/commit/58b60fc79d)] - **repl**: don’t write to input stream in editor mode (Anna Henningsen) [#9207](https://github.com/nodejs/node/pull/9207)
* [[`ed3de0854e`](https://github.com/nodejs/node/commit/ed3de0854e)] - **repl**: make `key` of `repl.write()` optional always (Anna Henningsen) [#9207](https://github.com/nodejs/node/pull/9207)
* [[`8a91616ba9`](https://github.com/nodejs/node/commit/8a91616ba9)] - **src**: replace SetNamedPropertyHandler() (AnnaMag) [#9062](https://github.com/nodejs/node/pull/9062)
* [[`89eb175c89`](https://github.com/nodejs/node/commit/89eb175c89)] - **src**: remove unused function (Brian White) [#9243](https://github.com/nodejs/node/pull/9243)
* [[`0e37a6a2ce`](https://github.com/nodejs/node/commit/0e37a6a2ce)] - **src**: fix typo rval to value (Miguel Angel Asencio Hurtado) [#9023](https://github.com/nodejs/node/pull/9023)
* [[`59d8255b52`](https://github.com/nodejs/node/commit/59d8255b52)] - **test**: remove watchdog in test-debug-signal-cluster (Rich Trott) [#9476](https://github.com/nodejs/node/pull/9476)
* [[`24fc1e24ac`](https://github.com/nodejs/node/commit/24fc1e24ac)] - **test**: cleanup test-dgram-error-message-address (Michael Macherey) [#8938](https://github.com/nodejs/node/pull/8938)
* [[`0216dbe293`](https://github.com/nodejs/node/commit/0216dbe293)] - **test**: remove timers from streams test (Anna Henningsen)
* [[`4ccdbb27c5`](https://github.com/nodejs/node/commit/4ccdbb27c5)] - **test**: improve test-debugger-util-regression (Santiago Gimeno) [#9490](https://github.com/nodejs/node/pull/9490)
* [[`093d677252`](https://github.com/nodejs/node/commit/093d677252)] - **test**: fix flaky test-net-GH-5504 (Santiago Gimeno) [#9461](https://github.com/nodejs/node/pull/9461)
* [[`aaf783443b`](https://github.com/nodejs/node/commit/aaf783443b)] - **test**: fix flaky test-force-repl-with-eval (Santiago Gimeno) [#9460](https://github.com/nodejs/node/pull/9460)
* [[`b91d5e10f5`](https://github.com/nodejs/node/commit/b91d5e10f5)] - **test**: update http-header-obstext (Gibson Fahnestock) [#9415](https://github.com/nodejs/node/pull/9415)
* [[`259b94202a`](https://github.com/nodejs/node/commit/259b94202a)] - **test**: move timer-dependent test to sequential (Rich Trott) [#9431](https://github.com/nodejs/node/pull/9431)
* [[`54def06d73`](https://github.com/nodejs/node/commit/54def06d73)] - **test**: add test for HTTP client "aborted" event (Kyle E. Mitchell) [#7376](https://github.com/nodejs/node/pull/7376)
* [[`2c056a40c7`](https://github.com/nodejs/node/commit/2c056a40c7)] - **test**: remove timer in test-dgram-send-empty-array (Rich Trott) [#9361](https://github.com/nodejs/node/pull/9361)
* [[`5e1fd2822e`](https://github.com/nodejs/node/commit/5e1fd2822e)] - **test**: refactor test-http-client-readable (Rich Trott) [#9344](https://github.com/nodejs/node/pull/9344)
* [[`bec1ccae99`](https://github.com/nodejs/node/commit/bec1ccae99)] - **test**: clean up dgram-broadcast-multi-process test (Isobel Redelmeier) [#9308](https://github.com/nodejs/node/pull/9308)
* [[`ce05b70595`](https://github.com/nodejs/node/commit/ce05b70595)] - **test**: fix freebsd10-64 CI failures (Rich Trott) [#9317](https://github.com/nodejs/node/pull/9317)
* [[`8b2b08a636`](https://github.com/nodejs/node/commit/8b2b08a636)] - **test**: fix flaky test-fs-watch-recursive on OS X (Rich Trott) [#9303](https://github.com/nodejs/node/pull/9303)
* [[`4ef7f00e2d`](https://github.com/nodejs/node/commit/4ef7f00e2d)] - **test**: refactor test-async-wrap-check-providers (Gerges Beshay) [#9297](https://github.com/nodejs/node/pull/9297)
* [[`4fcc2c1d3b`](https://github.com/nodejs/node/commit/4fcc2c1d3b)] - **test**: run all of test-timers-blocking-callback (Rich Trott) [#9305](https://github.com/nodejs/node/pull/9305)
* [[`1d54f07b31`](https://github.com/nodejs/node/commit/1d54f07b31)] - **test**: refactor /parallel/test-cluster-uncaught-exception.js to ES6 (Deverick) [#9239](https://github.com/nodejs/node/pull/9239)
* [[`88e60c2124`](https://github.com/nodejs/node/commit/88e60c2124)] - **test**: use strict assertions in module loader test (Ben Noordhuis) [#9263](https://github.com/nodejs/node/pull/9263)
* [[`0c32b03bdc`](https://github.com/nodejs/node/commit/0c32b03bdc)] - **test**: remove err timer from test-http-set-timeout (BethGriggs) [#9264](https://github.com/nodejs/node/pull/9264)
* [[`8d985c293c`](https://github.com/nodejs/node/commit/8d985c293c)] - **test**: clean up `test-child-process-exec-cwd.js` (Jeena Lee) [#9231](https://github.com/nodejs/node/pull/9231)
* [[`b83b5176d4`](https://github.com/nodejs/node/commit/b83b5176d4)] - **test**: add child_process.exec() timeout coverage (cjihrig) [#9208](https://github.com/nodejs/node/pull/9208)
* [[`0fdfba8fbe`](https://github.com/nodejs/node/commit/0fdfba8fbe)] - **test**: fix flaky test by removing timer (Evan Lucas) [#9199](https://github.com/nodejs/node/pull/9199)
* [[`ad4cc361dd`](https://github.com/nodejs/node/commit/ad4cc361dd)] - **test**: add coverage for execFileSync() errors (cjihrig) [#9211](https://github.com/nodejs/node/pull/9211)
* [[`ef1cf6b040`](https://github.com/nodejs/node/commit/ef1cf6b040)] - **test**: remove test-v8-inspector-json-protocol test (Ben Noordhuis) [#9184](https://github.com/nodejs/node/pull/9184)
* [[`1fee6c11e5`](https://github.com/nodejs/node/commit/1fee6c11e5)] - **test**: writable stream needDrain state (Italo A. Casas) [#8799](https://github.com/nodejs/node/pull/8799)
* [[`7fbfb739c1`](https://github.com/nodejs/node/commit/7fbfb739c1)] - **test**: writable stream ending state (Italo A. Casas) [#8707](https://github.com/nodejs/node/pull/8707)
* [[`f64d93f198`](https://github.com/nodejs/node/commit/f64d93f198)] - **test**: writable stream finished state (Italo A. Casas) [#8791](https://github.com/nodejs/node/pull/8791)
* [[`210ae5607c`](https://github.com/nodejs/node/commit/210ae5607c)] - **test**: prevent workers outliving parent (Sam Roberts) [#9257](https://github.com/nodejs/node/pull/9257)
* [[`1d79af6525`](https://github.com/nodejs/node/commit/1d79af6525)] - **test**: case sensitivity of env variables (Oliver Salzburg) [#9166](https://github.com/nodejs/node/pull/9166)
* [[`18a235b9a7`](https://github.com/nodejs/node/commit/18a235b9a7)] - **test**: make flaky pummel test more reliable (Ben Noordhuis) [#9241](https://github.com/nodejs/node/pull/9241)
* [[`a46c02746a`](https://github.com/nodejs/node/commit/a46c02746a)] - **test**: move flaky test to test/pummel (Ben Noordhuis) [#9241](https://github.com/nodejs/node/pull/9241)
* [[`60704fbb20`](https://github.com/nodejs/node/commit/60704fbb20)] - **test**: fix flaky test-timers-blocking-callback (Rich Trott) [#9198](https://github.com/nodejs/node/pull/9198)
* [[`ce2d434ab6`](https://github.com/nodejs/node/commit/ce2d434ab6)] - **test**: remove arbitrary timer (Rich Trott) [#9197](https://github.com/nodejs/node/pull/9197)
* [[`5c42d98bbd`](https://github.com/nodejs/node/commit/5c42d98bbd)] - **test**: remove duplicate required module (Rich Trott) [#9169](https://github.com/nodejs/node/pull/9169)
* [[`88cd4cfcb0`](https://github.com/nodejs/node/commit/88cd4cfcb0)] - **test**: rename target to exports for consistency (Daniel Bevenius) [#9135](https://github.com/nodejs/node/pull/9135)
* [[`02f7e3aca3`](https://github.com/nodejs/node/commit/02f7e3aca3)] - **test**: checking if error constructor is assert.AssertionError (larissayvette) [#9119](https://github.com/nodejs/node/pull/9119)
* [[`6f780893eb`](https://github.com/nodejs/node/commit/6f780893eb)] - **test**: fix flaky test-child-process-fork-dgram (Rich Trott) [#9098](https://github.com/nodejs/node/pull/9098)
* [[`39a53a0f29`](https://github.com/nodejs/node/commit/39a53a0f29)] - **test**: remove unneeded escaping in template strings (Rich Trott) [#9112](https://github.com/nodejs/node/pull/9112)
* [[`127ed73f3c`](https://github.com/nodejs/node/commit/127ed73f3c)] - **test**: remove unused common.libDir (Rich Trott) [#9124](https://github.com/nodejs/node/pull/9124)
* [[`def6874b5f`](https://github.com/nodejs/node/commit/def6874b5f)] - **test**: use npm sandbox in test-npm-install (João Reis) [#9079](https://github.com/nodejs/node/pull/9079)
* [[`97748c6d02`](https://github.com/nodejs/node/commit/97748c6d02)] - **test**: move module out of fixture directory (Rich Trott) [#9022](https://github.com/nodejs/node/pull/9022)
* [[`ae3f31b267`](https://github.com/nodejs/node/commit/ae3f31b267)] - **test**: fix issues reported by Coverity (Eugene Ostroukhov) [#8870](https://github.com/nodejs/node/pull/8870)
* [[`9cc9001244`](https://github.com/nodejs/node/commit/9cc9001244)] - **test**: refactor test-file-* (Jenna Vuong) [#8999](https://github.com/nodejs/node/pull/8999)
* [[`cc6b2f49cf`](https://github.com/nodejs/node/commit/cc6b2f49cf)] - **test**: fixes that do not affect performance (larissayvette) [#9011](https://github.com/nodejs/node/pull/9011)
* [[`a643d3caed`](https://github.com/nodejs/node/commit/a643d3caed)] - **test**: output tap13 instead of almost-tap (Johan Bergström) [#9262](https://github.com/nodejs/node/pull/9262)
* [[`7b75cb9e5a`](https://github.com/nodejs/node/commit/7b75cb9e5a)] - **test,lib,benchmark**: match function names (Rich Trott) [#9113](https://github.com/nodejs/node/pull/9113)
* [[`9cb236ff45`](https://github.com/nodejs/node/commit/9cb236ff45)] - **tls**: fix leak of WriteWrap+TLSWrap combination (Fedor Indutny) [#9586](https://github.com/nodejs/node/pull/9586)
* [[`bd7c1e7542`](https://github.com/nodejs/node/commit/bd7c1e7542)] - **tools**: allow test.py to use full paths of tests (Francis Gulotta) [#9694](https://github.com/nodejs/node/pull/9694)
* [[`2388648bea`](https://github.com/nodejs/node/commit/2388648bea)] - **tools**: make --repeat work with -j in test.py (Rich Trott) [#9249](https://github.com/nodejs/node/pull/9249)
* [[`07d34f98b2`](https://github.com/nodejs/node/commit/07d34f98b2)] - **tools**: remove dangling eslint symlink (Sam Roberts) [#9299](https://github.com/nodejs/node/pull/9299)
* [[`a120199ea9`](https://github.com/nodejs/node/commit/a120199ea9)] - **tools**: enable ES2016 syntax support in ESLint (Michaël Zasso) [#9218](https://github.com/nodejs/node/pull/9218)
* [[`9077f63dcf`](https://github.com/nodejs/node/commit/9077f63dcf)] - **tools**: replace custom lint rule for getter/setter (Rich Trott) [#9194](https://github.com/nodejs/node/pull/9194)
* [[`e9d5cd79bb`](https://github.com/nodejs/node/commit/e9d5cd79bb)] - **tools**: update ESLint to v3.8.0 (Rich Trott) [#9112](https://github.com/nodejs/node/pull/9112)
* [[`87285ed984`](https://github.com/nodejs/node/commit/87285ed984)] - **tools**: avoid let in for loops (jessicaquynh) [#9049](https://github.com/nodejs/node/pull/9049)
* [[`e2bb2a2550`](https://github.com/nodejs/node/commit/e2bb2a2550)] - **tools**: fix release script on macOS 10.12 (Evan Lucas) [#8824](https://github.com/nodejs/node/pull/8824)
* [[`8b85d47112`](https://github.com/nodejs/node/commit/8b85d47112)] - **tools**: use long format for gpg fingerprint (Myles Borins) [#9258](https://github.com/nodejs/node/pull/9258)
* [[`52a04bbfe2`](https://github.com/nodejs/node/commit/52a04bbfe2)] - **util**: use template strings (Alejandro Oviedo Garcia) [#9120](https://github.com/nodejs/node/pull/9120)
* [[`7dc875c08a`](https://github.com/nodejs/node/commit/7dc875c08a)] - **v8**: update make-v8.sh to use git (Jaideep Bajwa) [#9393](https://github.com/nodejs/node/pull/9393)

<a id="6.9.1"></a>
## 2016-10-19, Version 6.9.1 'Boron' (LTS), @thealphanerd

### Notable changes

* **streams**: Fix a regression introduced in v6.8.0 in readable stream that caused unpipe to remove the wrong stream (Anna Henningsen)

### Commits

* [[`2c3bbb576c`](https://github.com/nodejs/node/commit/2c3bbb576c)] - **doc**: fix changelog index for v6.9.0 (Rod Vagg) [#9168](https://github.com/nodejs/node/pull/9168)
* [[`f4b766f5b7`](https://github.com/nodejs/node/commit/f4b766f5b7)] - **streams**: fix regression in `unpipe()` (Anna Henningsen) [#9171](https://github.com/nodejs/node/pull/9171)
* [[`6072326009`](https://github.com/nodejs/node/commit/6072326009)] - **test**: add regression test for `unpipe()` (Niels Nielsen) [#9171](https://github.com/nodejs/node/pull/9171)
* [[`9f248a4d83`](https://github.com/nodejs/node/commit/9f248a4d83)] - **tools**: check tag is on github before release (Rod Vagg) [#9142](https://github.com/nodejs/node/pull/9142)
* [[`c74d3a700a`](https://github.com/nodejs/node/commit/c74d3a700a)] - **tools**: make detached SHASUM .sig file for releases (Rod Vagg) [#9071](https://github.com/nodejs/node/pull/9071)
* [[`955bbf876f`](https://github.com/nodejs/node/commit/955bbf876f)] - **tools**: explicitly set digest algo for SHASUM to 256 (Rod Vagg) [#9071](https://github.com/nodejs/node/pull/9071)

<a id="6.9.0"></a>
## 2016-10-18, Version 6.9.0 'Boron' (LTS), @rvagg

This release marks the transition of Node.js v6 into Long Term Support (LTS) with the codename 'Boron'. The v6 release line now moves in to "Active LTS" and will remain so until April 2018. After that time it will move in to "Maintenance" until end of life in April 2019.

This is also a security release. All Node.js users should consult the security release summary at https://nodejs.org/en/blog/vulnerability/october-2016-security-releases/ for details on patched vulnerabilities.

### Notable changes

* **crypto**: Don't automatically attempt to load an OpenSSL configuration file, from the `OPENSSL_CONF` environment variable or from the default location for the current platform. Always triggering a configuration file load attempt may allow an attacker to load compromised OpenSSL configuration into a Node.js process if they are able to place a file in a default location. (Fedor Indutny, Rod Vagg)
* **node**: Introduce the `process.release.lts` property, set to `"Boron"`. This value is `"Argon"` for v4 LTS releases and `undefined` for all other releases. (Rod Vagg)
* **V8**: Backport fix for CVE-2016-5172, an arbitrary memory read. The parser in V8 mishandled scopes, potentially allowing an attacker to obtain sensitive information from arbitrary memory locations via crafted JavaScript code. This vulnerability would require an attacker to be able to execute arbitrary JavaScript code in a Node.js process. (Rod Vagg)
* **v8_inspector**: Generate a UUID for each execution of the inspector. This provides additional security to prevent unauthorized clients from connecting to the Node.js process via the v8_inspector port when running with `--inspect`. Since the debugging protocol allows extensive access to the internals of a running process, and the execution of arbitrary code, it is important to limit connections to authorized tools only. Vulnerability originally reported by Jann Horn. (Eugene Ostroukhov)

### Commits

* [[`99e4eee8ef`](https://github.com/nodejs/node/commit/99e4eee8ef)] - **build**: do not define ZLIB_CONST (Bradley T. Hughes) [#9122](https://github.com/nodejs/node/pull/9122)
* [[`cae9eb35f0`](https://github.com/nodejs/node/commit/cae9eb35f0)] - **crypto**: fix openssl.cnf FIPS handling & testing (Rod Vagg) [nodejs/node-private#82](https://github.com/nodejs/node-private/pull/82)
* [[`c947d448da`](https://github.com/nodejs/node/commit/c947d448da)] - **deps**: cherry-pick 0e14baf712 from V8 upstream (Rod Vagg) [nodejs/node-private#80](https://github.com/nodejs/node-private/pull/80)
* [[`647afe9d9a`](https://github.com/nodejs/node/commit/647afe9d9a)] - **inspector**: generate UUID for debug targets (Eugene Ostroukhov) [nodejs/node-private#79](https://github.com/nodejs/node-private/pull/79)
* [[`1ea0358a91`](https://github.com/nodejs/node/commit/1ea0358a91)] - **node**: --openssl-config cli argument (Fedor Indutny) [nodejs/node-private#78](https://github.com/nodejs/node-private/pull/78)
* [[`455272ad33`](https://github.com/nodejs/node/commit/455272ad33)] - **(SEMVER-MINOR)** **src**: add process.release.lts property (Rod Vagg) [#3212](https://github.com/nodejs/node/pull/3212)
* [[`9ace073949`](https://github.com/nodejs/node/commit/9ace073949)] - **win,build**: try multiple timeservers when signing (Rod Vagg) [#9155](https://github.com/nodejs/node/pull/9155)

<a id="6.8.1"></a>
## 2016-10-14, Version 6.8.1 (Current), @evanlucas

### Notable changes

* **build**: Fix building with shared zlib. (Bradley T. Hughes) [#9077](https://github.com/nodejs/node/pull/9077)
* **stream**: Fix regression in `stream.Writable` subclass `instanceof` checks. (Anna Henningsen) [#9088](https://github.com/nodejs/node/pull/9088)
* **timers**: Fix regression where immediates that are cleared in the callback would never be called. (Brian White) [#9086](https://github.com/nodejs/node/pull/9086)

### Commits

* [[`8d2206fe41`](https://github.com/nodejs/node/commit/8d2206fe41)] - **build**: add -DZLIB_CONST when building with --shared-zlib (Bradley T. Hughes) [#9077](https://github.com/nodejs/node/pull/9077)
* [[`8c4fab0a28`](https://github.com/nodejs/node/commit/8c4fab0a28)] - **stream**: fix `Writable` subclass instanceof checks (Anna Henningsen) [#9088](https://github.com/nodejs/node/pull/9088)
* [[`7171bd6311`](https://github.com/nodejs/node/commit/7171bd6311)] - **timers**: fix regression with clearImmediate() (Brian White) [#9086](https://github.com/nodejs/node/pull/9086)

<a id="6.8.0"></a>
## 2016-10-12, Version 6.8.0 (Current), @Fishrock123

### Notable changes

* **fs**:
  * `SyncWriteStream` now inherits from `Stream.Writable`. (Anna Henningsen) [#8830](https://github.com/nodejs/node/pull/8830)
    * Practically, this means that when stdio is piped to a file, stdout and stderr will still be `Writable` streams.
  * `fs.existsSync()` has been undeprecated. `fs.exists()` remains deprecated. (Dan Fabulich) [#8364](https://github.com/nodejs/node/pull/8364)
* **http**: `http.request()` now accepts a `timeout` option. (Rene Weber) [#8101](https://github.com/nodejs/node/pull/8101)
* **module**: The module loader now maintains its own realpath cache. (Anna Henningsen) [#8100](https://github.com/nodejs/node/pull/8100)
* **npm**: Upgraded to 3.10.8 (Kat Marchán) [#8706](https://github.com/nodejs/node/pull/8706)
* **stream**: `Duplex` streams now show proper `instanceof Stream.Writable`. (Anna Henningsen) [#8834](https://github.com/nodejs/node/pull/8834)
* **timers**: Improved `setTimeout`/`Interval` performance by up to 22%. (Brian White) [#8661](https://github.com/nodejs/node/pull/8661)

### Commits

* [[`1a6e8983a6`](https://github.com/nodejs/node/commit/1a6e8983a6)] - **benchmark**: add benchmarks for `Buffer.from()` (Anna Henningsen) [#8738](https://github.com/nodejs/node/pull/8738)
* [[`882f8b3d6c`](https://github.com/nodejs/node/commit/882f8b3d6c)] - **benchmark**: use 'yes' instead of echo in a loop (Bartosz Sosnowski) [#8721](https://github.com/nodejs/node/pull/8721)
* [[`999f727bb5`](https://github.com/nodejs/node/commit/999f727bb5)] - **benchmark**: add benchmark for destructuring object (Fangdun Cai (Fundon)) [#8680](https://github.com/nodejs/node/pull/8680)
* [[`5c10898e31`](https://github.com/nodejs/node/commit/5c10898e31)] - **buffer**: fix check for `.buffer` property (Ojas Shirekar) [#8739](https://github.com/nodejs/node/pull/8739)
* [[`b9c2270502`](https://github.com/nodejs/node/commit/b9c2270502)] - **buffer**: fix performance regression (Michaël Zasso) [#8754](https://github.com/nodejs/node/pull/8754)
* [[`3fcdf4e80a`](https://github.com/nodejs/node/commit/3fcdf4e80a)] - **buffer**: remove unnecessary argument check (Michaël Zasso) [#8552](https://github.com/nodejs/node/pull/8552)
* [[`ee319b739c`](https://github.com/nodejs/node/commit/ee319b739c)] - **buffer**: add isSharedArrayBuffer checks (Ojas Shirekar) [#8510](https://github.com/nodejs/node/pull/8510)
* [[`38fdbcd7f7`](https://github.com/nodejs/node/commit/38fdbcd7f7)] - **build**: make addons build dep. on node_version.h (Anna Henningsen) [#8861](https://github.com/nodejs/node/pull/8861)
* [[`f057d193ec`](https://github.com/nodejs/node/commit/f057d193ec)] - **build**: run cctests as part of test-ci target (Ben Noordhuis) [#8034](https://github.com/nodejs/node/pull/8034)
* [[`a202be6690`](https://github.com/nodejs/node/commit/a202be6690)] - **build**: don't build icu with -fno-rtti (Ben Noordhuis) [#8886](https://github.com/nodejs/node/pull/8886)
* [[`296254f141`](https://github.com/nodejs/node/commit/296254f141)] - **build**: remove VS 2013 switch from vcbuild.bat (Ben Noordhuis) [#8067](https://github.com/nodejs/node/pull/8067)
* [[`a425c4da98`](https://github.com/nodejs/node/commit/a425c4da98)] - **build**: run `npm install` for doc builds in tarball (Anna Henningsen) [#8413](https://github.com/nodejs/node/pull/8413)
* [[`3d3bce6ca1`](https://github.com/nodejs/node/commit/3d3bce6ca1)] - **cluster**: remove unused backlog argument (Brian White) [#8877](https://github.com/nodejs/node/pull/8877)
* [[`23a851dfe6`](https://github.com/nodejs/node/commit/23a851dfe6)] - **deps**: avoid single-byte buffer overwrite in ares_create_query (Daniel Stenberg) [#8849](https://github.com/nodejs/node/pull/8849)
* [[`46af58898c`](https://github.com/nodejs/node/commit/46af58898c)] - **deps**: make gtest output tap (Ben Noordhuis) [#8034](https://github.com/nodejs/node/pull/8034)
* [[`9d41e8913f`](https://github.com/nodejs/node/commit/9d41e8913f)] - **deps**: bump V8 patch to 84 (Myles Borins) [#8851](https://github.com/nodejs/node/pull/8851)
* [[`4d41bd9c68`](https://github.com/nodejs/node/commit/4d41bd9c68)] - **deps**: hotfix upgrade npm tap version for tests (Kat Marchán) [#8706](https://github.com/nodejs/node/pull/8706)
* [[`9ecfc32fde`](https://github.com/nodejs/node/commit/9ecfc32fde)] - **deps**: upgrade npm to 3.10.8 (Kat Marchán) [#8706](https://github.com/nodejs/node/pull/8706)
* [[`c4d9b54f75`](https://github.com/nodejs/node/commit/c4d9b54f75)] - **dgram**: use Buffer.alloc(0) for zero-size buffers (Сковорода Никита Андреевич) [#8751](https://github.com/nodejs/node/pull/8751)
* [[`e1a774d314`](https://github.com/nodejs/node/commit/e1a774d314)] - **dns**: remove internal variable from makeAsync (yorkie) [#8800](https://github.com/nodejs/node/pull/8800)
* [[`787558935c`](https://github.com/nodejs/node/commit/787558935c)] - **dns**: tweak regex for IPv6 addresses (Luigi Pinca) [#8665](https://github.com/nodejs/node/pull/8665)
* [[`4e8c03707a`](https://github.com/nodejs/node/commit/4e8c03707a)] - **dns**: handle array holes in setServers() (cjihrig) [#8567](https://github.com/nodejs/node/pull/8567)
* [[`5e6be7b4c2`](https://github.com/nodejs/node/commit/5e6be7b4c2)] - **doc**: fix typo in email address in README (Rich Trott) [#8941](https://github.com/nodejs/node/pull/8941)
* [[`72ed6aa205`](https://github.com/nodejs/node/commit/72ed6aa205)] - **doc**: make node(1) more consistent with tradition (Alex Jordan) [#8902](https://github.com/nodejs/node/pull/8902)
* [[`2fad4d29b0`](https://github.com/nodejs/node/commit/2fad4d29b0)] - **doc**: add example for file existence with fs.stat (Christopn Noelke) [#8585](https://github.com/nodejs/node/pull/8585)
* [[`0bdc363205`](https://github.com/nodejs/node/commit/0bdc363205)] - **doc**: add `added:` information for globals (Luigi Pinca) [#8901](https://github.com/nodejs/node/pull/8901)
* [[`bc2dd3e467`](https://github.com/nodejs/node/commit/bc2dd3e467)] - **doc**: change ./node to node in debugger.md (AnnaMag) [#8943](https://github.com/nodejs/node/pull/8943)
* [[`b212b9b44b`](https://github.com/nodejs/node/commit/b212b9b44b)] - **doc**: add CTC meeting minutes 2016-09-07 (Josh Gavant) [#8499](https://github.com/nodejs/node/pull/8499)
* [[`c31a3178e8`](https://github.com/nodejs/node/commit/c31a3178e8)] - **doc**: fixup link in fs.md (ss22ever) [#8940](https://github.com/nodejs/node/pull/8940)
* [[`e7039cdbb8`](https://github.com/nodejs/node/commit/e7039cdbb8)] - **doc**: fix markdown formatting in url.md (Bryan Bess) [#8933](https://github.com/nodejs/node/pull/8933)
* [[`ff9a84d324`](https://github.com/nodejs/node/commit/ff9a84d324)] - **doc**: update punctuation in README.md (Abner Chou) [#8892](https://github.com/nodejs/node/pull/8892)
* [[`c36c8dc3cc`](https://github.com/nodejs/node/commit/c36c8dc3cc)] - **doc**: add documentation for test common module (Paul Grock) [#8840](https://github.com/nodejs/node/pull/8840)
* [[`a604a82186`](https://github.com/nodejs/node/commit/a604a82186)] - **doc**: recommend using port 0 instead of common.PORT (Niklas Ingholt) [#8694](https://github.com/nodejs/node/pull/8694)
* [[`77fc5caceb`](https://github.com/nodejs/node/commit/77fc5caceb)] - **doc**: add CTC meeting minutes 2016-09-14 (Josh Gavant) [#8726](https://github.com/nodejs/node/pull/8726)
* [[`505b88d3c3`](https://github.com/nodejs/node/commit/505b88d3c3)] - **doc**: add CTC meeting minutes 2016-09-21 (Josh Gavant) [#8727](https://github.com/nodejs/node/pull/8727)
* [[`3e8c8f90bc`](https://github.com/nodejs/node/commit/3e8c8f90bc)] - **doc**: fix typo in repl doc (Franziska Hinkelmann) [#8826](https://github.com/nodejs/node/pull/8826)
* [[`a00ae75805`](https://github.com/nodejs/node/commit/a00ae75805)] - **doc**: improve documentation for commit subject line (Luigi Pinca) [#8546](https://github.com/nodejs/node/pull/8546)
* [[`aaebbf9708`](https://github.com/nodejs/node/commit/aaebbf9708)] - **doc**: encourage 2FA before onboarding (Rich Trott) [#8776](https://github.com/nodejs/node/pull/8776)
* [[`f07054dd49`](https://github.com/nodejs/node/commit/f07054dd49)] - **doc**: add optional step to onboarding doc (Rich Trott) [#8774](https://github.com/nodejs/node/pull/8774)
* [[`dceaa0ba4a`](https://github.com/nodejs/node/commit/dceaa0ba4a)] - **doc**: remove failing workaround in BUILDING.md (Christopher Fujino) [#8763](https://github.com/nodejs/node/pull/8763)
* [[`0522aa0dc0`](https://github.com/nodejs/node/commit/0522aa0dc0)] - **doc**: add commit formats for release blog posts (fen) [#8631](https://github.com/nodejs/node/pull/8631)
* [[`98e425eed4`](https://github.com/nodejs/node/commit/98e425eed4)] - **doc**: fix title level at tls.md (yorkie) [#8782](https://github.com/nodejs/node/pull/8782)
* [[`e7c0f34f20`](https://github.com/nodejs/node/commit/e7c0f34f20)] - **doc**: add added: info for crypto.timingSafeEqual() (Marc-Aurèle DARCHE) [#8796](https://github.com/nodejs/node/pull/8796)
* [[`4fb051426c`](https://github.com/nodejs/node/commit/4fb051426c)] - **doc**: enable no-file-name-articles remark-lint rule (Сковорода Никита Андреевич) [#8713](https://github.com/nodejs/node/pull/8713)
* [[`4699e3022b`](https://github.com/nodejs/node/commit/4699e3022b)] - **doc**: enable first-heading-level remark-lint rule (Сковорода Никита Андреевич) [#8716](https://github.com/nodejs/node/pull/8716)
* [[`3aec6a68bf`](https://github.com/nodejs/node/commit/3aec6a68bf)] - **doc**: improve child_process doc types (yorkie) [#8741](https://github.com/nodejs/node/pull/8741)
* [[`6fab334a73`](https://github.com/nodejs/node/commit/6fab334a73)] - **doc**: fix example in stream doc (Luigi Pinca) [#8378](https://github.com/nodejs/node/pull/8378)
* [[`f13089b834`](https://github.com/nodejs/node/commit/f13089b834)] - **doc**: update BUILDING.md (rainabba) [#8704](https://github.com/nodejs/node/pull/8704)
* [[`5c014bb532`](https://github.com/nodejs/node/commit/5c014bb532)] - **doc**: standardize on `make -j8` (Rich Trott) [#8678](https://github.com/nodejs/node/pull/8678)
* [[`98ca442cae`](https://github.com/nodejs/node/commit/98ca442cae)] - **doc**: add CTC meeting minutes 2016-08-24 (Josh Gavant) [#8423](https://github.com/nodejs/node/pull/8423)
* [[`28264f8da4`](https://github.com/nodejs/node/commit/28264f8da4)] - **doc**: add eugeneo to collaborators (Eugene Ostroukhov) [#8696](https://github.com/nodejs/node/pull/8696)
* [[`85ee89edd6`](https://github.com/nodejs/node/commit/85ee89edd6)] - **doc**: add ak239 to collaborators (Aleksey Kozyatinskiy) [#8676](https://github.com/nodejs/node/pull/8676)
* [[`5dd6229aeb`](https://github.com/nodejs/node/commit/5dd6229aeb)] - **doc**: clarify fs.utimes() arguments (Danny Guo) [#8651](https://github.com/nodejs/node/pull/8651)
* [[`42386d7229`](https://github.com/nodejs/node/commit/42386d7229)] - **doc**: add link to help repo in README (Rich Trott) [#8570](https://github.com/nodejs/node/pull/8570)
* [[`2f6101ed10`](https://github.com/nodejs/node/commit/2f6101ed10)] - **doc**: fix broken link in timers doc (Ltrlg) [#8562](https://github.com/nodejs/node/pull/8562)
* [[`e16f95db4d`](https://github.com/nodejs/node/commit/e16f95db4d)] - **doc**: update exercise portion of onboarding doc (Rich Trott) [#8559](https://github.com/nodejs/node/pull/8559)
* [[`a91050c57b`](https://github.com/nodejs/node/commit/a91050c57b)] - **doc**: fix typo in path doc (Kalman Hazins) [#8527](https://github.com/nodejs/node/pull/8527)
* [[`64b79eba42`](https://github.com/nodejs/node/commit/64b79eba42)] - **doc**: remove extra comma in cluster docs (Teddy Katz) [#8557](https://github.com/nodejs/node/pull/8557)
* [[`2d23227060`](https://github.com/nodejs/node/commit/2d23227060)] - **doc**: fix a formatting error in buffer.md (Сковорода Никита Андреевич) [#8553](https://github.com/nodejs/node/pull/8553)
* [[`eebecef9a4`](https://github.com/nodejs/node/commit/eebecef9a4)] - **doc**: link onboarding to contributing guide (Rich Trott) [#8529](https://github.com/nodejs/node/pull/8529)
* [[`8a1f74338c`](https://github.com/nodejs/node/commit/8a1f74338c)] - **doc**: remove duplicate content from readline doc (Italo A. Casas) [#8497](https://github.com/nodejs/node/pull/8497)
* [[`71dd4c193a`](https://github.com/nodejs/node/commit/71dd4c193a)] - **doc**: capitalize arguments' type names in url doc (yorkie) [#8489](https://github.com/nodejs/node/pull/8489)
* [[`8e28e03fb9`](https://github.com/nodejs/node/commit/8e28e03fb9)] - **doc**: add gibfahn to collaborators (Gibson Fahnestock) [#8533](https://github.com/nodejs/node/pull/8533)
* [[`c96618f241`](https://github.com/nodejs/node/commit/c96618f241)] - **doc**: add imyller to collaborators (Ilkka Myller) [#8530](https://github.com/nodejs/node/pull/8530)
* [[`929d9bb222`](https://github.com/nodejs/node/commit/929d9bb222)] - **doc**: standardize rest parameters (Timothy Gu) [#8485](https://github.com/nodejs/node/pull/8485)
* [[`125df45b80`](https://github.com/nodejs/node/commit/125df45b80)] - **doc**: add not-an-aardvark to collaborators (not-an-aardvark) [#8525](https://github.com/nodejs/node/pull/8525)
* [[`3eb93e1fe8`](https://github.com/nodejs/node/commit/3eb93e1fe8)] - **doc**: add example for running with v8-inspector (Franziska Hinkelmann) [#8845](https://github.com/nodejs/node/pull/8845)
* [[`d6dcbc212b`](https://github.com/nodejs/node/commit/d6dcbc212b)] - **doc,tool**: add tls.TLSSocket to typeMap (yorkie) [#8742](https://github.com/nodejs/node/pull/8742)
* [[`d69570d5fc`](https://github.com/nodejs/node/commit/d69570d5fc)] - **doc,tool**: add ref to Integer (yorkie) [#8740](https://github.com/nodejs/node/pull/8740)
* [[`688abac7b2`](https://github.com/nodejs/node/commit/688abac7b2)] - **(SEMVER-MINOR)** **fs**: make `SyncWriteStream` inherit from `Writable` (Anna Henningsen) [#8830](https://github.com/nodejs/node/pull/8830)
* [[`07d97f4f3e`](https://github.com/nodejs/node/commit/07d97f4f3e)] - **fs**: fix handling of `uv_stat_t` fields (Anna Henningsen) [#8515](https://github.com/nodejs/node/pull/8515)
* [[`14e2d67776`](https://github.com/nodejs/node/commit/14e2d67776)] - **(SEMVER-MINOR)** **fs,doc**: undeprecate existsSync (Dan Fabulich) [#8364](https://github.com/nodejs/node/pull/8364)
* [[`980c1edf63`](https://github.com/nodejs/node/commit/980c1edf63)] - **(SEMVER-MINOR)** **fs,module**: add module-loader-only realpath cache (Anna Henningsen) [#8100](https://github.com/nodejs/node/pull/8100)
* [[`ee7af01b93`](https://github.com/nodejs/node/commit/ee7af01b93)] - **(SEMVER-MINOR)** **http**: socket connection timeout for http request (Rene Weber) [#8101](https://github.com/nodejs/node/pull/8101)
* [[`7a59449478`](https://github.com/nodejs/node/commit/7a59449478)] - **https**: fix memory leak with https.request() (Ilkka Myller) [#8647](https://github.com/nodejs/node/pull/8647)
* [[`573d8bcee4`](https://github.com/nodejs/node/commit/573d8bcee4)] - **inspector**: fix minor issues (Brian White) [#8890](https://github.com/nodejs/node/pull/8890)
* [[`f4f9cf779f`](https://github.com/nodejs/node/commit/f4f9cf779f)] - **inspector**: build file cleanup (Eugene Ostroukhov) [#8753](https://github.com/nodejs/node/pull/8753)
* [[`e80ae1350c`](https://github.com/nodejs/node/commit/e80ae1350c)] - **inspector**: address race conditions (Eugene Ostroukhov) [#8672](https://github.com/nodejs/node/pull/8672)
* [[`f817875235`](https://github.com/nodejs/node/commit/f817875235)] - **inspector**: wait for both sides closing (Eugene Ostroukhov) [#8505](https://github.com/nodejs/node/pull/8505)
* [[`4ed46b47a1`](https://github.com/nodejs/node/commit/4ed46b47a1)] - **inspector**: report default context (Eugene Ostroukhov) [#8502](https://github.com/nodejs/node/pull/8502)
* [[`b05ce842ce`](https://github.com/nodejs/node/commit/b05ce842ce)] - **inspector**: zero out structure members (Eugene Ostroukhov) [#8536](https://github.com/nodejs/node/pull/8536)
* [[`0b90ff7a8d`](https://github.com/nodejs/node/commit/0b90ff7a8d)] - **inspector**: introduce a smoke test (Eugene Ostroukhov) [#8429](https://github.com/nodejs/node/pull/8429)
* [[`3222b66abe`](https://github.com/nodejs/node/commit/3222b66abe)] - **inspector**: fix tests on Windows (Eugene Ostroukhov) [#8528](https://github.com/nodejs/node/pull/8528)
* [[`a1925a7955`](https://github.com/nodejs/node/commit/a1925a7955)] - **lib**: minor improvements to bootstrap_node.js (Rémy MEJA) [#8906](https://github.com/nodejs/node/pull/8906)
* [[`313a45da24`](https://github.com/nodejs/node/commit/313a45da24)] - **lib**: changed var to const in linkedlist (Adri Van Houdt) [#8609](https://github.com/nodejs/node/pull/8609)
* [[`6cd5588a67`](https://github.com/nodejs/node/commit/6cd5588a67)] - **lib**: fix TypeError in v8-polyfill (Wyatt Preul) [#8863](https://github.com/nodejs/node/pull/8863)
* [[`ba361a2aa0`](https://github.com/nodejs/node/commit/ba361a2aa0)] - **lib**: remove let from for loops (Myles Borins) [#8873](https://github.com/nodejs/node/pull/8873)
* [[`beb288b639`](https://github.com/nodejs/node/commit/beb288b639)] - **lib**: changed var to const in internal/v8_polyfill (Adri Van Houdt) [#8615](https://github.com/nodejs/node/pull/8615)
* [[`858a7bbacf`](https://github.com/nodejs/node/commit/858a7bbacf)] - **lib**: changed var to const in bootstrap_node.js (Adri Van Houdt) [#8588](https://github.com/nodejs/node/pull/8588)
* [[`31232adebb`](https://github.com/nodejs/node/commit/31232adebb)] - **module**: fix comment from "read-only" to "shallow" (Bryan English) [#8887](https://github.com/nodejs/node/pull/8887)
* [[`0eaf3ff53c`](https://github.com/nodejs/node/commit/0eaf3ff53c)] - **path**: fallback to process cwd when resolving drive cwd (Jason Ginchereau) [#8541](https://github.com/nodejs/node/pull/8541)
* [[`d72a7b3d0c`](https://github.com/nodejs/node/commit/d72a7b3d0c)] - **path**: fix path.relative UNC path result (Jason Ginchereau) [#8523](https://github.com/nodejs/node/pull/8523)
* [[`e0c10f63b0`](https://github.com/nodejs/node/commit/e0c10f63b0)] - **process**: changed var to const in internal/process.js (Adri Van Houdt) [#8614](https://github.com/nodejs/node/pull/8614)
* [[`37ce6da59a`](https://github.com/nodejs/node/commit/37ce6da59a)] - **process**: changed var to const in internal/v8_prof_processor (Adri Van Houdt) [#8619](https://github.com/nodejs/node/pull/8619)
* [[`e8f1cf1bd8`](https://github.com/nodejs/node/commit/e8f1cf1bd8)] - **process**: changed var to const in internal/process/promises (Adri Van Houdt) [#8620](https://github.com/nodejs/node/pull/8620)
* [[`4c194ee7bd`](https://github.com/nodejs/node/commit/4c194ee7bd)] - **readline**: fix `concievably` typo in readline.js (Miguel Angel Asencio Hurtado) [#8953](https://github.com/nodejs/node/pull/8953)
* [[`8c91a9b848`](https://github.com/nodejs/node/commit/8c91a9b848)] - **repl**: improve .help message (Roman Reiss) [#8519](https://github.com/nodejs/node/pull/8519)
* [[`443bedeb68`](https://github.com/nodejs/node/commit/443bedeb68)] - **src**: remove out-of-date TODO comment (Daniel Bevenius) [#9000](https://github.com/nodejs/node/pull/9000)
* [[`59aa103df2`](https://github.com/nodejs/node/commit/59aa103df2)] - **src**: fix typo in #endif comment (Juan Andres Andrango) [#8989](https://github.com/nodejs/node/pull/8989)
* [[`8a2ba6fe83`](https://github.com/nodejs/node/commit/8a2ba6fe83)] - **src**: fix build for older clang (Zach Bjornson) [#7645](https://github.com/nodejs/node/pull/7645)
* [[`d8df78c573`](https://github.com/nodejs/node/commit/d8df78c573)] - **src**: remove unused function declaration (Brian White) [#8878](https://github.com/nodejs/node/pull/8878)
* [[`a6b9ffbf5b`](https://github.com/nodejs/node/commit/a6b9ffbf5b)] - **src**: refactor reading of options in contextify (Franziska Hinkelmann) [#8850](https://github.com/nodejs/node/pull/8850)
* [[`324c8b5f7e`](https://github.com/nodejs/node/commit/324c8b5f7e)] - **src**: fixes misplaced comment (Madhav Gharmalkar) [#8860](https://github.com/nodejs/node/pull/8860)
* [[`86b9db601d`](https://github.com/nodejs/node/commit/86b9db601d)] - **src**: add missing length argument to send comment (Daniel Bevenius) [#8816](https://github.com/nodejs/node/pull/8816)
* [[`aa11205f71`](https://github.com/nodejs/node/commit/aa11205f71)] - **src**: rename CHECK_NOT_OOB() macro (Ben Noordhuis) [#8784](https://github.com/nodejs/node/pull/8784)
* [[`8be818eb07`](https://github.com/nodejs/node/commit/8be818eb07)] - **src**: fix minor typo in comments (Daniel Bevenius) [#8736](https://github.com/nodejs/node/pull/8736)
* [[`41ad6e3965`](https://github.com/nodejs/node/commit/41ad6e3965)] - **src**: rename `handle__` to `handle_` in HandleWrap (Daniel Bevenius) [#8712](https://github.com/nodejs/node/pull/8712)
* [[`9205edc35c`](https://github.com/nodejs/node/commit/9205edc35c)] - **src**: don't abort when c-ares initialization fails (Ben Noordhuis) [#8710](https://github.com/nodejs/node/pull/8710)
* [[`6ddfe89fdf`](https://github.com/nodejs/node/commit/6ddfe89fdf)] - **src**: remove VS 2013 compatibility hacks (Ben Noordhuis) [#8067](https://github.com/nodejs/node/pull/8067)
* [[`a9491f1604`](https://github.com/nodejs/node/commit/a9491f1604)] - **src**: make ReqWrap req_ member private (Daniel Bevenius) [#8532](https://github.com/nodejs/node/pull/8532)
* [[`5ebce30468`](https://github.com/nodejs/node/commit/5ebce30468)] - **src**: remove unneeded ABORT after CHECK (yorkie) [#8593](https://github.com/nodejs/node/pull/8593)
* [[`2dbef79ca7`](https://github.com/nodejs/node/commit/2dbef79ca7)] - **src**: handle thrown errors in CopyProperties() (cjihrig) [#8649](https://github.com/nodejs/node/pull/8649)
* [[`52f0f64e79`](https://github.com/nodejs/node/commit/52f0f64e79)] - **src**: use MaybeStackBuffer on DoSend/Writev (Paul Kiddie) [#8626](https://github.com/nodejs/node/pull/8626)
* [[`a62999ac70`](https://github.com/nodejs/node/commit/a62999ac70)] - **src**: add /json/protocol endpoint to inspector (Ben Noordhuis) [#7491](https://github.com/nodejs/node/pull/7491)
* [[`4e7c67cf55`](https://github.com/nodejs/node/commit/4e7c67cf55)] - **(SEMVER-MINOR)** **stream**: proper `instanceof` for `Writable`s (Anna Henningsen) [#8834](https://github.com/nodejs/node/pull/8834)
* [[`56951b4367`](https://github.com/nodejs/node/commit/56951b4367)] - **test**: add coverage for spawnSync() killSignal (cjihrig) [#8960](https://github.com/nodejs/node/pull/8960)
* [[`05f74120e8`](https://github.com/nodejs/node/commit/05f74120e8)] - **test**: refactor `assert` in internet test-dns.js (Junshu Okamoto) [#8980](https://github.com/nodejs/node/pull/8980)
* [[`1a4207d91d`](https://github.com/nodejs/node/commit/1a4207d91d)] - **test**: various test improvements (James M Snell) [#8468](https://github.com/nodejs/node/pull/8468)
* [[`c4f0bb237a`](https://github.com/nodejs/node/commit/c4f0bb237a)] - **test**: expand test coverage for url.js (Junshu Okamoto) [#8976](https://github.com/nodejs/node/pull/8976)
* [[`4e9b6a0022`](https://github.com/nodejs/node/commit/4e9b6a0022)] - **test**: fix test-child-process-fork-regr-gh-2847 (Santiago Gimeno) [#8954](https://github.com/nodejs/node/pull/8954)
* [[`b579fcab45`](https://github.com/nodejs/node/commit/b579fcab45)] - **test**: remove FIXME pummel/test-tls-securepair-client (Alfred Cepeda) [#8757](https://github.com/nodejs/node/pull/8757)
* [[`9b0733fd49`](https://github.com/nodejs/node/commit/9b0733fd49)] - **test**: run faster and cleanup after run (Wyatt Preul) [#8848](https://github.com/nodejs/node/pull/8848)
* [[`df0211d95e`](https://github.com/nodejs/node/commit/df0211d95e)] - **test**: refactor test-net-server-max-connections (Rich Trott) [#8931](https://github.com/nodejs/node/pull/8931)
* [[`147a06d4a5`](https://github.com/nodejs/node/commit/147a06d4a5)] - **test**: enable addons test to pass with debug build (Daniel Bevenius) [#8836](https://github.com/nodejs/node/pull/8836)
* [[`636026a22d`](https://github.com/nodejs/node/commit/636026a22d)] - **test**: remove blank lines at end of files (Rich Trott) [#8920](https://github.com/nodejs/node/pull/8920)
* [[`93c48743f1`](https://github.com/nodejs/node/commit/93c48743f1)] - **test**: refactor test-file-write-stream (Sudaraka Wijesinghe) [#8894](https://github.com/nodejs/node/pull/8894)
* [[`516486526f`](https://github.com/nodejs/node/commit/516486526f)] - **test**: cleanup/update test-dgram-empty-packet.js (Michael Macherey) [#8896](https://github.com/nodejs/node/pull/8896)
* [[`2f0f596e07`](https://github.com/nodejs/node/commit/2f0f596e07)] - **test**: fix child-process-uid-gid on Windows (Michaël Zasso) [#8924](https://github.com/nodejs/node/pull/8924)
* [[`52d0424c56`](https://github.com/nodejs/node/commit/52d0424c56)] - **test**: mark test-tick-processor-unknown flaky (Rich Trott) [#8900](https://github.com/nodejs/node/pull/8900)
* [[`424c126742`](https://github.com/nodejs/node/commit/424c126742)] - **test**: fix -Wformat warnings in inspector cctest (Ben Noordhuis) [#8034](https://github.com/nodejs/node/pull/8034)
* [[`76f80a3f74`](https://github.com/nodejs/node/commit/76f80a3f74)] - **test**: fix running child-process-uid-gid as root (Wyatt Preul) [#8864](https://github.com/nodejs/node/pull/8864)
* [[`11ba56c83d`](https://github.com/nodejs/node/commit/11ba56c83d)] - **test**: expand test coverage for url.js (Junshu Okamoto) [#8859](https://github.com/nodejs/node/pull/8859)
* [[`c9450cef1b`](https://github.com/nodejs/node/commit/c9450cef1b)] - **test**: clean up test-timers-immediate (Rich Trott) [#8857](https://github.com/nodejs/node/pull/8857)
* [[`17922de555`](https://github.com/nodejs/node/commit/17922de555)] - **test**: add and assert readable/writable arguments (Daniel Bevenius) [#8815](https://github.com/nodejs/node/pull/8815)
* [[`bc710ef461`](https://github.com/nodejs/node/commit/bc710ef461)] - **test**: cleanup/update test-os.js (Mike Woods) [#8761](https://github.com/nodejs/node/pull/8761)
* [[`fc42825530`](https://github.com/nodejs/node/commit/fc42825530)] - **test**: modernize syntax, add strict checks (Lydia Kats) [#8841](https://github.com/nodejs/node/pull/8841)
* [[`72de8594fe`](https://github.com/nodejs/node/commit/72de8594fe)] - **test**: use common.skip for tap skip output (Lydia Kats) [#8841](https://github.com/nodejs/node/pull/8841)
* [[`4fa0fc59cd`](https://github.com/nodejs/node/commit/4fa0fc59cd)] - **test**: stream writable ended state (Italo A. Casas) [#8778](https://github.com/nodejs/node/pull/8778)
* [[`6dbda6aa86`](https://github.com/nodejs/node/commit/6dbda6aa86)] - **test**: clean up test-buffer-badhex (Jeremiah Senkpiel) [#7773](https://github.com/nodejs/node/pull/7773)
* [[`af092f1fc0`](https://github.com/nodejs/node/commit/af092f1fc0)] - **test**: cleanup test-net-server-address.js (Akito Ito) [#8586](https://github.com/nodejs/node/pull/8586)
* [[`af84528d41`](https://github.com/nodejs/node/commit/af84528d41)] - **test**: replace indexOf, assert.equal, add mustCall() (Richard Hong) [#8766](https://github.com/nodejs/node/pull/8766)
* [[`2e95b0e24b`](https://github.com/nodejs/node/commit/2e95b0e24b)] - **test**: fixed FIXME in test-repl-persistent-history (Alfred Cepeda) [#8756](https://github.com/nodejs/node/pull/8756)
* [[`76fd7db521`](https://github.com/nodejs/node/commit/76fd7db521)] - **test**: update var to const, use arrow functions (Matt Lang) [#8595](https://github.com/nodejs/node/pull/8595)
* [[`5bd13a3d6c`](https://github.com/nodejs/node/commit/5bd13a3d6c)] - **test**: cleanup parallel/test-fs-readfile-unlink.js (nohmapp) [#8764](https://github.com/nodejs/node/pull/8764)
* [[`f523b82c7b`](https://github.com/nodejs/node/commit/f523b82c7b)] - **test**: cleanup parallel/test-file-write-stream2.js (Jenna Vuong) [#8770](https://github.com/nodejs/node/pull/8770)
* [[`9252e7a52d`](https://github.com/nodejs/node/commit/9252e7a52d)] - **test**: cleanup parallel/test-fs-realpath.js (mpmckenna8) [#8769](https://github.com/nodejs/node/pull/8769)
* [[`6ba8aa963e`](https://github.com/nodejs/node/commit/6ba8aa963e)] - **test**: changed var to const, added strict equal checks (Lydia Katsamberis) [#8762](https://github.com/nodejs/node/pull/8762)
* [[`81ed50c5da`](https://github.com/nodejs/node/commit/81ed50c5da)] - **test**: add assertions to zero length buffer test (Lauren Spiegel) [#8729](https://github.com/nodejs/node/pull/8729)
* [[`b2aea505df`](https://github.com/nodejs/node/commit/b2aea505df)] - **test**: use Buffer.alloc (Eugene Ostroukhov) [#8748](https://github.com/nodejs/node/pull/8748)
* [[`5e4d8984b4`](https://github.com/nodejs/node/commit/5e4d8984b4)] - **test**: accept expected AIX result test-stdio-closed (Rich Trott) [#8755](https://github.com/nodejs/node/pull/8755)
* [[`906283837f`](https://github.com/nodejs/node/commit/906283837f)] - **test**: skip cpu-intensive tests on slow hosts (Rich Trott) [#8652](https://github.com/nodejs/node/pull/8652)
* [[`aa5a16a8ae`](https://github.com/nodejs/node/commit/aa5a16a8ae)] - **test**: add expectWarning to common (Michaël Zasso) [#8662](https://github.com/nodejs/node/pull/8662)
* [[`b46d8cdcde`](https://github.com/nodejs/node/commit/b46d8cdcde)] - **test**: cleanup vars to const and '==' to '===' (oogz) [#8705](https://github.com/nodejs/node/pull/8705)
* [[`5540e3d488`](https://github.com/nodejs/node/commit/5540e3d488)] - **test**: fix test-cluster-worker-init.js flakyness (Ilkka Myller) [#8703](https://github.com/nodejs/node/pull/8703)
* [[`ed625fefd2`](https://github.com/nodejs/node/commit/ed625fefd2)] - **test**: add tests for add/remove header after sent (Niklas Ingholt) [#8682](https://github.com/nodejs/node/pull/8682)
* [[`e9d1426080`](https://github.com/nodejs/node/commit/e9d1426080)] - **test**: enable cyrillic punycode test case (Ben Noordhuis) [#8695](https://github.com/nodejs/node/pull/8695)
* [[`b62735a302`](https://github.com/nodejs/node/commit/b62735a302)] - **test**: remove call to `net.Socket.resume()` (Alfred Cepeda) [#8679](https://github.com/nodejs/node/pull/8679)
* [[`9ca8722203`](https://github.com/nodejs/node/commit/9ca8722203)] - **test**: cleanup stream tests (Italo A. Casas) [#8668](https://github.com/nodejs/node/pull/8668)
* [[`dfd022ff9e`](https://github.com/nodejs/node/commit/dfd022ff9e)] - **test**: update test/parallel/test-child-process-stdio.js (matzavinos) [#8584](https://github.com/nodejs/node/pull/8584)
* [[`fef4341f46`](https://github.com/nodejs/node/commit/fef4341f46)] - **test**: update test/parallel/test-eval.js (Pavol Otcenas) [#8590](https://github.com/nodejs/node/pull/8590)
* [[`43d6212257`](https://github.com/nodejs/node/commit/43d6212257)] - **test**: update test/parallel/test-child-process-send-utf8.js (Jonathan Prince) [#8594](https://github.com/nodejs/node/pull/8594)
* [[`6924a4d237`](https://github.com/nodejs/node/commit/6924a4d237)] - **test**: update test/parallel/test-fs-read.js (Richard Walker) [#8596](https://github.com/nodejs/node/pull/8596)
* [[`1b494d3b96`](https://github.com/nodejs/node/commit/1b494d3b96)] - **test**: fixup parallel/test-async-wrap-post-did-throw.js (Jermaine Oppong) [#8625](https://github.com/nodejs/node/pull/8625)
* [[`edf9242f56`](https://github.com/nodejs/node/commit/edf9242f56)] - **test**: cleanup test-os.js (delvedor) [#8606](https://github.com/nodejs/node/pull/8606)
* [[`d4ad8d9619`](https://github.com/nodejs/node/commit/d4ad8d9619)] - **test**: refactor test-dgram-bind-shared-ports.js (Fikret Burak Gazioglu) [#8582](https://github.com/nodejs/node/pull/8582)
* [[`714cbfd46c`](https://github.com/nodejs/node/commit/714cbfd46c)] - **test**: update test-child-process-recv-handle (Jonathan Prince) [#8648](https://github.com/nodejs/node/pull/8648)
* [[`c664109c72`](https://github.com/nodejs/node/commit/c664109c72)] - **test**: improve test-child-process-stdout-flush (Wietse Venema) [#8581](https://github.com/nodejs/node/pull/8581)
* [[`c98d0c984d`](https://github.com/nodejs/node/commit/c98d0c984d)] - **test**: cleanup test-child-process-exec-env.js (Yevgen Safronov) [#8600](https://github.com/nodejs/node/pull/8600)
* [[`3269a7d6f5`](https://github.com/nodejs/node/commit/3269a7d6f5)] - **test**: cleanup test-tls-connect-given-socket.js (Thomas van Lankveld) [#8616](https://github.com/nodejs/node/pull/8616)
* [[`5e5a1c0e3c`](https://github.com/nodejs/node/commit/5e5a1c0e3c)] - **test**: cleanup test-child-process-buffering.js (Adri Van Houdt) [#8578](https://github.com/nodejs/node/pull/8578)
* [[`bcba27e8c6`](https://github.com/nodejs/node/commit/bcba27e8c6)] - **test**: update test-cluster-disconnect-unshared-udp (matt-in-a-hat) [#8599](https://github.com/nodejs/node/pull/8599)
* [[`5a59ca6168`](https://github.com/nodejs/node/commit/5a59ca6168)] - **test**: changing equal to strictEqual in path (lrlna) [#8628](https://github.com/nodejs/node/pull/8628)
* [[`3ddf77fc24`](https://github.com/nodejs/node/commit/3ddf77fc24)] - **test**: modernize js and tighten equality checking (Pavol Otcenas) [#8618](https://github.com/nodejs/node/pull/8618)
* [[`34f24e559d`](https://github.com/nodejs/node/commit/34f24e559d)] - **test**: refactor parallel/test-tcp-wrap-listen (scott stern) [#8640](https://github.com/nodejs/node/pull/8640)
* [[`6fb8ebd98c`](https://github.com/nodejs/node/commit/6fb8ebd98c)] - **test**: cleanup cluster-disconnect-unshared-tcp test (Rachel) [#8598](https://github.com/nodejs/node/pull/8598)
* [[`fd7f87ef40`](https://github.com/nodejs/node/commit/fd7f87ef40)] - **test**: var variables to const in zlib (Ishan Aditya) [#8627](https://github.com/nodejs/node/pull/8627)
* [[`fc6b4970b5`](https://github.com/nodejs/node/commit/fc6b4970b5)] - **test**: modernize JS and tighten equality checking (Pavol Otcenas) [#8580](https://github.com/nodejs/node/pull/8580)
* [[`f2f6353bc4`](https://github.com/nodejs/node/commit/f2f6353bc4)] - **test**: cleanup test-intl.js (Alessandro Metta) [#8641](https://github.com/nodejs/node/pull/8641)
* [[`14025db8c5`](https://github.com/nodejs/node/commit/14025db8c5)] - **test**: cleanup test-child-process-disconnect.js (Pavol Otcenas) [#8602](https://github.com/nodejs/node/pull/8602)
* [[`9032ba60a5`](https://github.com/nodejs/node/commit/9032ba60a5)] - **test**: replace var by const test-tls-zero-clear-in (Sébastien Barbieri) [#8621](https://github.com/nodejs/node/pull/8621)
* [[`1aa1740f12`](https://github.com/nodejs/node/commit/1aa1740f12)] - **test**: improve coverage of the util module (Michaël Zasso) [#8633](https://github.com/nodejs/node/pull/8633)
* [[`28d009be76`](https://github.com/nodejs/node/commit/28d009be76)] - **test**: refactored test-crypto-random.js (Tobias Kahse) [#8632](https://github.com/nodejs/node/pull/8632)
* [[`a89deb9c59`](https://github.com/nodejs/node/commit/a89deb9c59)] - **test**: cleanup test-c-ares.js (Yevgen Safronov) [#8577](https://github.com/nodejs/node/pull/8577)
* [[`9c3d521d90`](https://github.com/nodejs/node/commit/9c3d521d90)] - **test**: improve child_process tests (Dennis Schwartz) [#8617](https://github.com/nodejs/node/pull/8617)
* [[`ba88f5b8f8`](https://github.com/nodejs/node/commit/ba88f5b8f8)] - **test**: improve coverage of the buffer module (Michaël Zasso) [#8552](https://github.com/nodejs/node/pull/8552)
* [[`b10467cde2`](https://github.com/nodejs/node/commit/b10467cde2)] - **test**: improve test-https-agent.js (Dan.Williams) [#8517](https://github.com/nodejs/node/pull/8517)
* [[`82b7894d3b`](https://github.com/nodejs/node/commit/82b7894d3b)] - **test**: make test-tick-processor.js non-flaky (Fedor Indutny) [#8542](https://github.com/nodejs/node/pull/8542)
* [[`30e995f714`](https://github.com/nodejs/node/commit/30e995f714)] - **test**: add coverage for `client._addHandle()` (Rich Trott) [#8518](https://github.com/nodejs/node/pull/8518)
* [[`ff238c8d15`](https://github.com/nodejs/node/commit/ff238c8d15)] - **test**: fix flaky test-force-repl (Rich Trott) [#8484](https://github.com/nodejs/node/pull/8484)
* [[`83ed5085f4`](https://github.com/nodejs/node/commit/83ed5085f4)] - **test**: mark test-inspector flaky on windows (Rich Trott) [#8835](https://github.com/nodejs/node/pull/8835)
* [[`5a7dd18699`](https://github.com/nodejs/node/commit/5a7dd18699)] - **test,benchmark**: fix lint errors on v6.x (Jeremiah Senkpiel) [#9029](https://github.com/nodejs/node/pull/9029)
* [[`4492cc3e25`](https://github.com/nodejs/node/commit/4492cc3e25)] - **test,lib**: align arguments in multiline calls (Rich Trott) [#8642](https://github.com/nodejs/node/pull/8642)
* [[`3a72a606cb`](https://github.com/nodejs/node/commit/3a72a606cb)] - **timers**: improve setImmediate() performance (Brian White) [#8655](https://github.com/nodejs/node/pull/8655)
* [[`06c411753e`](https://github.com/nodejs/node/commit/06c411753e)] - **timers**: improve setTimeout/Interval performance (Brian White) [#8661](https://github.com/nodejs/node/pull/8661)
* [[`02da155e4b`](https://github.com/nodejs/node/commit/02da155e4b)] - **timers**: remove unreachable code (yorkie) [#8487](https://github.com/nodejs/node/pull/8487)
* [[`cf92be6939`](https://github.com/nodejs/node/commit/cf92be6939)] - **tls**: TLSSocket emits 'error' on handshake failure (Mariusz 'koder' Chwalba) [#8805](https://github.com/nodejs/node/pull/8805)
* [[`bee1955f4e`](https://github.com/nodejs/node/commit/bee1955f4e)] - **tls**: handle `error` events with `_tlsError` (Fedor Indutny) [#8889](https://github.com/nodejs/node/pull/8889)
* [[`d2eaa12a23`](https://github.com/nodejs/node/commit/d2eaa12a23)] - **tls**: improve createSecureContext in `_tls_common` (yorkie) [#8781](https://github.com/nodejs/node/pull/8781)
* [[`b0234e7968`](https://github.com/nodejs/node/commit/b0234e7968)] - **tls**: add 'new' keyword for Array constructor call (Mike Ralphson) [#8514](https://github.com/nodejs/node/pull/8514)
* [[`58c55108d2`](https://github.com/nodejs/node/commit/58c55108d2)] - **tools**: disallow extra blank lines at EOF/BOF (Rich Trott) [#8920](https://github.com/nodejs/node/pull/8920)
* [[`336d505dd9`](https://github.com/nodejs/node/commit/336d505dd9)] - **tools**: enable more remark-lint rules (Сковорода Никита Андреевич) [#8708](https://github.com/nodejs/node/pull/8708)
* [[`0310655cda`](https://github.com/nodejs/node/commit/0310655cda)] - **tools**: update remark configuration (Сковорода Никита Андреевич) [#8666](https://github.com/nodejs/node/pull/8666)
* [[`5c6284a417`](https://github.com/nodejs/node/commit/5c6284a417)] - **tools**: add additional ESLint rules (Teddy Katz) [#8643](https://github.com/nodejs/node/pull/8643)
* [[`73d54a6fc7`](https://github.com/nodejs/node/commit/73d54a6fc7)] - **tools**: add eslint rule prefer-assert-methods (Dany Shaanan) [#8622](https://github.com/nodejs/node/pull/8622)
* [[`ac6927f549`](https://github.com/nodejs/node/commit/ac6927f549)] - **tools**: make argument alignment linting more strict (Rich Trott) [#8642](https://github.com/nodejs/node/pull/8642)
* [[`8684cea9b7`](https://github.com/nodejs/node/commit/8684cea9b7)] - **tools**: make sure links are correctly passed to marked (Timothy Gu) [#8494](https://github.com/nodejs/node/pull/8494)
* [[`a12ff5cc5d`](https://github.com/nodejs/node/commit/a12ff5cc5d)] - **tools**: clean up icu/README.md formatting (Сковорода Никита Андреевич) [#8660](https://github.com/nodejs/node/pull/8660)
* [[`fc68b12bc3`](https://github.com/nodejs/node/commit/fc68b12bc3)] - **(SEMVER-MINOR)** **util**: Add format for SharedArrayBuffer (Yosuke Furukawa) [#8587](https://github.com/nodejs/node/pull/8587)
* [[`38be15549e`](https://github.com/nodejs/node/commit/38be15549e)] - **util**: don't init Debug if it's not needed yet (Bryan English) [#8452](https://github.com/nodejs/node/pull/8452)
* [[`7728f95967`](https://github.com/nodejs/node/commit/7728f95967)] - **util**: simplify SIMD setup (Dany Shaanan) [#8579](https://github.com/nodejs/node/pull/8579)
* [[`8282d6fc60`](https://github.com/nodejs/node/commit/8282d6fc60)] - **vm**: add error message if we abort (Franziska Hinkelmann) [#8634](https://github.com/nodejs/node/pull/8634)
* [[`b83f51a326`](https://github.com/nodejs/node/commit/b83f51a326)] - **win,msi**: mark INSTALLDIR property as secure (João Reis) [#8795](https://github.com/nodejs/node/pull/8795)
* [[`623d3c6eb5`](https://github.com/nodejs/node/commit/623d3c6eb5)] - **win,tools**: ignore linting for line breaks (João Reis) [#8785](https://github.com/nodejs/node/pull/8785)
* [[`7403aaa13f`](https://github.com/nodejs/node/commit/7403aaa13f)] - **zlib**: tighten up dictionary tests (Tarjei Husøy) [#8512](https://github.com/nodejs/node/pull/8512)
* [[`15474951a5`](https://github.com/nodejs/node/commit/15474951a5)] - **zlib**: fix raw inflate with custom dictionary (Tarjei Husøy) [#8512](https://github.com/nodejs/node/pull/8512)

<a id="6.7.0"></a>
## 2016-09-27, Version 6.7.0 (Current), @evanlucas

This is a security release. All Node.js users should consult the security release summary at https://nodejs.org/en/blog/vulnerability/september-2016-security-releases/ for details on patched vulnerabilities.

### Notable changes

Semver Minor:

* **openssl**:
  * Upgrade to 1.0.2i, fixes a number of defects impacting Node.js: CVE-2016-6304 ("OCSP Status Request extension unbounded memory growth", high severity), CVE-2016-2183, CVE-2016-2178 and CVE-2016-6306. (Shigeki Ohtsu) [#8714](https://github.com/nodejs/node/pull/8714)
  * Upgrade to 1.0.2j, fixes a defect included in 1.0.2i resulting in a crash when using CRLs, CVE-2016-7052. (Shigeki Ohtsu) [#8786](https://github.com/nodejs/node/pull/8786)
  * Remove support for loading dynamic third-party engine modules. An attacker may be able to hide malicious code to be inserted into Node.js at runtime by masquerading as one of the dynamic engine modules. Originally reported by Ahmed Zaki (Skype). (Ben Noordhuis) [nodejs/node-private#73](https://github.com/nodejs/node-private/pull/73)
* **http**: CVE-2016-5325 - Properly validate for allowable characters in the `reason` argument in `ServerResponse#writeHead()`. Fixes a possible response splitting attack vector. This introduces a new case where `throw` may occur when configuring HTTP responses, users should already be adopting try/catch here. Originally reported independently by Evan Lucas and Romain Gaucher. (Evan Lucas) [nodejs/node-private#60](https://github.com/nodejs/node-private/pull/60)

Semver Patch:

* **buffer**: Zero-fill excess bytes in new `Buffer` objects created with `Buffer.concat()` while providing a `totalLength` parameter that exceeds the total length of the original `Buffer` objects being concatenated. (Сковорода Никита Андреевич) [nodejs/node-private#64](https://github.com/nodejs/node-private/pull/64)
* **src**: Fix regression where passing an empty password and/or salt to crypto.pbkdf2() would cause a fatal error (Rich Trott) [#8572](https://github.com/nodejs/node/pull/8572)
* **tls**: CVE-2016-7099 - Fix invalid wildcard certificate validation check whereby a TLS server may be able to serve an invalid wildcard certificate for its hostname due to improper validation of `*.` in the wildcard string. Originally reported by Alexander Minozhenko and James Bunton (Atlassian). (Ben Noordhuis) [nodejs/node-private#75](https://github.com/nodejs/node-private/pull/75)
* **v8**: Fix regression where a regex on a frozen object was broken (Myles Borins) [#8673](https://github.com/nodejs/node/pull/8673)

### Commits

* [[`8fb8c46303`](https://github.com/nodejs/node/commit/8fb8c46303)] - **buffer**: zero-fill uninitialized bytes in .concat() (Сковорода Никита Андреевич) [nodejs/node-private#64](https://github.com/nodejs/node-private/pull/64)
* [[`e5998c44b4`](https://github.com/nodejs/node/commit/e5998c44b4)] - **crypto**: don't build hardware engines (Ben Noordhuis) [nodejs/node-private#73](https://github.com/nodejs/node-private/pull/73)
* [[`ed4cd2eebe`](https://github.com/nodejs/node/commit/ed4cd2eebe)] - **deps**: cherry-pick 34880eb3dc from V8 upstream (Myles Borins) [#8673](https://github.com/nodejs/node/pull/8673)
* [[`f8ad0dc0e2`](https://github.com/nodejs/node/commit/f8ad0dc0e2)] - **deps**: add -no_rand_screen to openssl s_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`9181def9d4`](https://github.com/nodejs/node/commit/9181def9d4)] - **deps**: fix asm build error of openssl in x86_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`2dee4af5c3`](https://github.com/nodejs/node/commit/2dee4af5c3)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`4255dc82a9`](https://github.com/nodejs/node/commit/4255dc82a9)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu) [#8786](https://github.com/nodejs/node/pull/8786)
* [[`c08d81df50`](https://github.com/nodejs/node/commit/c08d81df50)] - **deps**: upgrade openssl sources to 1.0.2j (Shigeki Ohtsu) [#8786](https://github.com/nodejs/node/pull/8786)
* [[`2573efc9df`](https://github.com/nodejs/node/commit/2573efc9df)] - **deps**: update openssl asm and asm_obsolete files (Shigeki Ohtsu) [#8714](https://github.com/nodejs/node/pull/8714)
* [[`67751f3d7e`](https://github.com/nodejs/node/commit/67751f3d7e)] - **deps**: add -no_rand_screen to openssl s_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`4382de338b`](https://github.com/nodejs/node/commit/4382de338b)] - **deps**: fix asm build error of openssl in x86_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`cfa00611b0`](https://github.com/nodejs/node/commit/cfa00611b0)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`3e4ea603b3`](https://github.com/nodejs/node/commit/3e4ea603b3)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu) [#8714](https://github.com/nodejs/node/pull/8714)
* [[`8937fd0dbb`](https://github.com/nodejs/node/commit/8937fd0dbb)] - **deps**: upgrade openssl sources to 1.0.2i (Shigeki Ohtsu) [#8714](https://github.com/nodejs/node/pull/8714)
* [[`c0f13e56a2`](https://github.com/nodejs/node/commit/c0f13e56a2)] - **http**: check reason chars in writeHead (Evan Lucas) [nodejs/node-private#60](https://github.com/nodejs/node-private/pull/60)
* [[`743f0c9164`](https://github.com/nodejs/node/commit/743f0c9164)] - **lib**: make tls.checkServerIdentity() more strict (Ben Noordhuis) [nodejs/node-private#75](https://github.com/nodejs/node-private/pull/75)
* [[`38bed98a92`](https://github.com/nodejs/node/commit/38bed98a92)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`a25fc3f715`](https://github.com/nodejs/node/commit/a25fc3f715)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`5902ba3989`](https://github.com/nodejs/node/commit/5902ba3989)] - **src**: Malloc/Calloc size 0 returns non-null pointer (Rich Trott) [#8572](https://github.com/nodejs/node/pull/8572)
* [[`a14d832884`](https://github.com/nodejs/node/commit/a14d832884)] - **test**: remove openssl options of -no_\<prot> (Shigeki Ohtsu) [#8714](https://github.com/nodejs/node/pull/8714)

<a id="6.6.0"></a>
## 2016-09-14, Version 6.6.0 (Current), @Fishrock123

### Notable changes

* **crypto**: Added `crypto.timingSafeEqual()`. (not-an-aardvark) [#8304](https://github.com/nodejs/node/pull/8304)
* **events**: Made the "max event listeners" memory leak warning more accessible. (Anna Henningsen) [#8298](https://github.com/nodejs/node/pull/8298)
* **promises**: Unhandled rejections now emit a [process warning](https://nodejs.org/dist/latest-v6.x/docs/api/process.html#process_event_warning) after the first tick. (Benjamin Gruenbaum) [#8223](https://github.com/nodejs/node/pull/8223)
* **repl**: Added auto alignment for `.editor` mode. (Prince J Wesley) [#8241](https://github.com/nodejs/node/pull/8241)
* **util**: Some functionality has been added to `util.inspect()`:
  * Returning `this` from a custom inspect function now works. (Anna Henningsen) [#8174](https://github.com/nodejs/node/pull/8174)
  * Added support for Symbol-based custom inspection methods. (Anna Henningsen) [#8174](https://github.com/nodejs/node/pull/8174)

### Commits

* [[`2ecc8c4c23`](https://github.com/nodejs/node/commit/2ecc8c4c23)] - **async_wrap**: add a missing case to test-async-wrap-throw-no-init (yorkie) [#8198](https://github.com/nodejs/node/pull/8198)
* [[`00f4bc3105`](https://github.com/nodejs/node/commit/00f4bc3105)] - **benchmark**: add benches for fs.stat & fs.statSync (Anna Henningsen) [#8338](https://github.com/nodejs/node/pull/8338)
* [[`7cc1391287`](https://github.com/nodejs/node/commit/7cc1391287)] - **benchmark**: fix off-by-one error in fs benchmarks (Anna Henningsen) [#8338](https://github.com/nodejs/node/pull/8338)
* [[`6e3db283ed`](https://github.com/nodejs/node/commit/6e3db283ed)] - **buffer**: fix ArrayBuffer checks (Brian White) [#8453](https://github.com/nodejs/node/pull/8453)
* [[`dd51b1f428`](https://github.com/nodejs/node/commit/dd51b1f428)] - **buffer,string_decoder**: consolidate encoding validation logic (James M Snell) [#7207](https://github.com/nodejs/node/pull/7207)
* [[`a830e37dc9`](https://github.com/nodejs/node/commit/a830e37dc9)] - **build**: don't require processing docs for nightlies (Johan Bergström) [#8325](https://github.com/nodejs/node/pull/8325)
* [[`836bfc188b`](https://github.com/nodejs/node/commit/836bfc188b)] - **build**: fix dependencies on AIX (Michael Dawson) [#8285](https://github.com/nodejs/node/pull/8285)
* [[`bc9d2fb543`](https://github.com/nodejs/node/commit/bc9d2fb543)] - **build**: fix dependencies on AIX (Michael Dawson) [#8272](https://github.com/nodejs/node/pull/8272)
* [[`206b105b1e`](https://github.com/nodejs/node/commit/206b105b1e)] - **build**: add missing files to zip and 7z packages (Richard Lau) [#8069](https://github.com/nodejs/node/pull/8069)
* [[`afb9917f16`](https://github.com/nodejs/node/commit/afb9917f16)] - **(SEMVER-MINOR)** **crypto**: add crypto.timingSafeEqual() (not-an-aardvark) [#8304](https://github.com/nodejs/node/pull/8304)
* [[`1640e7a4da`](https://github.com/nodejs/node/commit/1640e7a4da)] - **crypto**: fix getDecoder() encoding check (atstojanov) [#8301](https://github.com/nodejs/node/pull/8301)
* [[`49f996f4f6`](https://github.com/nodejs/node/commit/49f996f4f6)] - **crypto**: make malloc failure check cross-platform (Rich Trott) [#8352](https://github.com/nodejs/node/pull/8352)
* [[`9c460d7475`](https://github.com/nodejs/node/commit/9c460d7475)] - **deps**: add back no-op harmony shipping flags (Ali Ijaz Sheikh) [#8445](https://github.com/nodejs/node/pull/8445)
* [[`c8bcf1b591`](https://github.com/nodejs/node/commit/c8bcf1b591)] - **deps**: workaround clang-3.4 ICE (Ali Ijaz Sheikh) [#8343](https://github.com/nodejs/node/pull/8343)
* [[`ac3471ca23`](https://github.com/nodejs/node/commit/ac3471ca23)] - **deps**: v8_inspector update (Eugene Ostroukhov) [#8150](https://github.com/nodejs/node/pull/8150)
* [[`f829660c71`](https://github.com/nodejs/node/commit/f829660c71)] - **deps**: cherry-pick 8ed65b97 from V8's upstream (Anna Henningsen) [#8411](https://github.com/nodejs/node/pull/8411)
* [[`c48cb2de48`](https://github.com/nodejs/node/commit/c48cb2de48)] - **doc**: link SIGTSTP / SIGCONT events in readline doc (Italo A. Casas) [#8475](https://github.com/nodejs/node/pull/8475)
* [[`ce1a46c02d`](https://github.com/nodejs/node/commit/ce1a46c02d)] - **doc**: update onboarding PR landing info (Rich Trott) [#8479](https://github.com/nodejs/node/pull/8479)
* [[`92acff82ea`](https://github.com/nodejs/node/commit/92acff82ea)] - **doc**: add CTC meeting minutes 2016-08-31 (Josh Gavant) [#8424](https://github.com/nodejs/node/pull/8424)
* [[`53877357fc`](https://github.com/nodejs/node/commit/53877357fc)] - **doc**: fix link on timers.md (yorkie) [#8488](https://github.com/nodejs/node/pull/8488)
* [[`09da5756e5`](https://github.com/nodejs/node/commit/09da5756e5)] - **doc**: add `added:` information for crypto (Luigi Pinca) [#8281](https://github.com/nodejs/node/pull/8281)
* [[`19df5cef3b`](https://github.com/nodejs/node/commit/19df5cef3b)] - **doc**: fix example in repl documentation (Franziska Hinkelmann) [#8469](https://github.com/nodejs/node/pull/8469)
* [[`3ce6eaa3b9`](https://github.com/nodejs/node/commit/3ce6eaa3b9)] - **doc**: note that listening on SIGSEGV & co is unsafe (Anna Henningsen) [#8410](https://github.com/nodejs/node/pull/8410)
* [[`c7771e6fbc`](https://github.com/nodejs/node/commit/c7771e6fbc)] - **doc**: clarify sentence in event loop doc (Luigi Pinca) [#8400](https://github.com/nodejs/node/pull/8400)
* [[`2c45782b12`](https://github.com/nodejs/node/commit/2c45782b12)] - **doc**: add CI help/support info to onboarding doc (Rich Trott) [#8407](https://github.com/nodejs/node/pull/8407)
* [[`cffe7b731d`](https://github.com/nodejs/node/commit/cffe7b731d)] - **doc**: add 2016-08-17 CTC meeting minutes (Josh Gavant) [#8245](https://github.com/nodejs/node/pull/8245)
* [[`fdd59cc04c`](https://github.com/nodejs/node/commit/fdd59cc04c)] - **doc**: update BUILDING.md (Rich Trott) [#8398](https://github.com/nodejs/node/pull/8398)
* [[`d0a92be798`](https://github.com/nodejs/node/commit/d0a92be798)] - **doc**: add 2016-08-10 CTC meeting minutes (Josh Gavant) [#8229](https://github.com/nodejs/node/pull/8229)
* [[`ca31187087`](https://github.com/nodejs/node/commit/ca31187087)] - **doc**: update CI content in onboarding doc (Rich Trott) [#8374](https://github.com/nodejs/node/pull/8374)
* [[`44983b1fdc`](https://github.com/nodejs/node/commit/44983b1fdc)] - **doc**: update authors list (James M Snell) [#8346](https://github.com/nodejs/node/pull/8346)
* [[`ee83f5d541`](https://github.com/nodejs/node/commit/ee83f5d541)] - **doc**: add return type of clientRequest.setTimeout (Mike Ralphson) [#8356](https://github.com/nodejs/node/pull/8356)
* [[`1695c84240`](https://github.com/nodejs/node/commit/1695c84240)] - **doc**: fix a wrong link,add '.md' to the link (Alexis374) [#8315](https://github.com/nodejs/node/pull/8315)
* [[`65096de443`](https://github.com/nodejs/node/commit/65096de443)] - **doc**: fix typos (Mike Ralphson) [#8370](https://github.com/nodejs/node/pull/8370)
* [[`6d421a2ee2`](https://github.com/nodejs/node/commit/6d421a2ee2)] - **doc**: fix broken link in dgram doc (Brian White) [#8365](https://github.com/nodejs/node/pull/8365)
* [[`fbabd36de9`](https://github.com/nodejs/node/commit/fbabd36de9)] - **doc**: update targos email in readme per request (James M Snell) [#8389](https://github.com/nodejs/node/pull/8389)
* [[`76a3050c34`](https://github.com/nodejs/node/commit/76a3050c34)] - **doc**: update landing pr info in onboarding doc (Rich Trott) [#8344](https://github.com/nodejs/node/pull/8344)
* [[`372e4f3f79`](https://github.com/nodejs/node/commit/372e4f3f79)] - **doc**: bad/better examples for fs.access() and fs.exists() (Dan Fabulich) [#7832](https://github.com/nodejs/node/pull/7832)
* [[`9f18878eee`](https://github.com/nodejs/node/commit/9f18878eee)] - **doc**: fix typo in stream doc (Hubert Mine) [#8326](https://github.com/nodejs/node/pull/8326)
* [[`59e96bb1af`](https://github.com/nodejs/node/commit/59e96bb1af)] - **doc**: adding danbev to collaborators (Daniel Bevenius) [#8359](https://github.com/nodejs/node/pull/8359)
* [[`b553e57f5f`](https://github.com/nodejs/node/commit/b553e57f5f)] - **doc**: clarify that path on windows accepts / and \ (James M Snell) [#8291](https://github.com/nodejs/node/pull/8291)
* [[`feab3d4c25`](https://github.com/nodejs/node/commit/feab3d4c25)] - **doc**: add lpinca to collaborators (Luigi Pinca) [#8331](https://github.com/nodejs/node/pull/8331)
* [[`d2b2abe9d9`](https://github.com/nodejs/node/commit/d2b2abe9d9)] - **doc**: doc that listen can be called multiple times (James M Snell) [#8294](https://github.com/nodejs/node/pull/8294)
* [[`54d76137cd`](https://github.com/nodejs/node/commit/54d76137cd)] - **doc**: readline write() is processed as input (James M Snell) [#8295](https://github.com/nodejs/node/pull/8295)
* [[`48be8bc4e1`](https://github.com/nodejs/node/commit/48be8bc4e1)] - **doc**: `'ipc'` is required with fork stdio option (James M Snell) [#8290](https://github.com/nodejs/node/pull/8290)
* [[`47ecd21133`](https://github.com/nodejs/node/commit/47ecd21133)] - **doc**: improve fs.truncate functions' documentation (Sakthipriyan Vairamani) [#7648](https://github.com/nodejs/node/pull/7648)
* [[`d565183c37`](https://github.com/nodejs/node/commit/d565183c37)] - **doc**: add `added:` information for modules (Luigi Pinca) [#8250](https://github.com/nodejs/node/pull/8250)
* [[`b6f5104145`](https://github.com/nodejs/node/commit/b6f5104145)] - **doc**: fix onReadable reentry after unshift called (Zwb) [#8200](https://github.com/nodejs/node/pull/8200)
* [[`93ac875d53`](https://github.com/nodejs/node/commit/93ac875d53)] - **doc**: add `added:` information for dgram (Luigi Pinca) [#8196](https://github.com/nodejs/node/pull/8196)
* [[`260663fbfa`](https://github.com/nodejs/node/commit/260663fbfa)] - **doc**: add Myles Borins to the CTC (Rod Vagg) [#8260](https://github.com/nodejs/node/pull/8260)
* [[`a7c21759d9`](https://github.com/nodejs/node/commit/a7c21759d9)] - **doc**: fix buf.readUIntBE, buf.readUIntLE examples (David Keeler) [#8240](https://github.com/nodejs/node/pull/8240)
* [[`e4fcf55701`](https://github.com/nodejs/node/commit/e4fcf55701)] - **doc**: fix "timout" typo in timeout (Fangshi He) [#8231](https://github.com/nodejs/node/pull/8231)
* [[`03f5297ccd`](https://github.com/nodejs/node/commit/03f5297ccd)] - **doc**: include the optional options parameter (Sakthipriyan Vairamani) [#7842](https://github.com/nodejs/node/pull/7842)
* [[`605db31fe7`](https://github.com/nodejs/node/commit/605db31fe7)] - **(SEMVER-MINOR)** **events**: make memory leak warning more accessible (Anna Henningsen) [#8298](https://github.com/nodejs/node/pull/8298)
* [[`fa4c4d655a`](https://github.com/nodejs/node/commit/fa4c4d655a)] - **http**: fix connection upgrade checks (Brian White) [#8238](https://github.com/nodejs/node/pull/8238)
* [[`b603ac24cb`](https://github.com/nodejs/node/commit/b603ac24cb)] - **inspector**: use script name for target title (Eugene Ostroukhov) [#8243](https://github.com/nodejs/node/pull/8243)
* [[`13a522ac39`](https://github.com/nodejs/node/commit/13a522ac39)] - **inspector**: make sure all messages are dispatched (Eugene Ostroukhov) [#8264](https://github.com/nodejs/node/pull/8264)
* [[`250a380231`](https://github.com/nodejs/node/commit/250a380231)] - **inspector**: simplify buffer management (Eugene Ostroukhov) [#8257](https://github.com/nodejs/node/pull/8257)
* [[`354166c061`](https://github.com/nodejs/node/commit/354166c061)] - **inspector**: use new inspector headers (Eugene Ostroukhov) [#8150](https://github.com/nodejs/node/pull/8150)
* [[`3ef8ba8bdc`](https://github.com/nodejs/node/commit/3ef8ba8bdc)] - **net**: make holding the buffer in memory more robust (Anna Henningsen) [#8252](https://github.com/nodejs/node/pull/8252)
* [[`180867d6a6`](https://github.com/nodejs/node/commit/180867d6a6)] - **(SEMVER-MINOR)** **promise**: warn on unhandled rejections (Benjamin Gruenbaum) [#8223](https://github.com/nodejs/node/pull/8223)
* [[`408308f2e6`](https://github.com/nodejs/node/commit/408308f2e6)] - **(SEMVER-MINOR)** **readline**: key interval delay for \r & \n (Prince J Wesley) [#8109](https://github.com/nodejs/node/pull/8109)
* [[`6f20f477c4`](https://github.com/nodejs/node/commit/6f20f477c4)] - **(SEMVER-MINOR)** **repl**: Auto alignment for .editor mode (Prince J Wesley) [#8241](https://github.com/nodejs/node/pull/8241)
* [[`0d24247e50`](https://github.com/nodejs/node/commit/0d24247e50)] - **src**: pull AfterConnect from pipe_wrap and tcp_wrap (Daniel Bevenius) [#8448](https://github.com/nodejs/node/pull/8448)
* [[`16202264d1`](https://github.com/nodejs/node/commit/16202264d1)] - **src**: remove unneeded Environment error methods (Ben Noordhuis) [#8427](https://github.com/nodejs/node/pull/8427)
* [[`8cbbb47e39`](https://github.com/nodejs/node/commit/8cbbb47e39)] - **src**: update f function call comment (Daniel Bevenius) [#8416](https://github.com/nodejs/node/pull/8416)
* [[`d1d1433b02`](https://github.com/nodejs/node/commit/d1d1433b02)] - **src**: normalize malloc, realloc (Michael Dawson) [#7564](https://github.com/nodejs/node/pull/7564)
* [[`2c2a21ab56`](https://github.com/nodejs/node/commit/2c2a21ab56)] - **src**: unbreak build when compiling against uclibc (Ben Noordhuis) [#8308](https://github.com/nodejs/node/pull/8308)
* [[`4e368c58ff`](https://github.com/nodejs/node/commit/4e368c58ff)] - **src**: moving f function call comment (Daniel Bevenius) [#8405](https://github.com/nodejs/node/pull/8405)
* [[`0f2c619f55`](https://github.com/nodejs/node/commit/0f2c619f55)] - **src**: avoid duplicate AtExit functions (Ali Ijaz Sheikh) [#8273](https://github.com/nodejs/node/pull/8273)
* [[`3358861470`](https://github.com/nodejs/node/commit/3358861470)] - **test**: refector parallel/test-http.js (Junshu Okamoto) [#8471](https://github.com/nodejs/node/pull/8471)
* [[`2ce364ad10`](https://github.com/nodejs/node/commit/2ce364ad10)] - **test**: modernize JS and tighten equality checking (Peter Ogilvie) [#8476](https://github.com/nodejs/node/pull/8476)
* [[`1a30fe563d`](https://github.com/nodejs/node/commit/1a30fe563d)] - **test**: swapped == and equal to === and strictEqual (Christopher Dunavan) [#8472](https://github.com/nodejs/node/pull/8472)
* [[`d2b6b66037`](https://github.com/nodejs/node/commit/d2b6b66037)] - **test**: refactor test-net-pipe-connect-errors (Rich Trott) [#8473](https://github.com/nodejs/node/pull/8473)
* [[`3294c2c82b`](https://github.com/nodejs/node/commit/3294c2c82b)] - **test**: skip pseudo-tty/no_dropped_stdio test (Michael Dawson) [#8470](https://github.com/nodejs/node/pull/8470)
* [[`5baa4e0156`](https://github.com/nodejs/node/commit/5baa4e0156)] - **test**: clean up net server try ports test (Thomas Hunter II) [#8458](https://github.com/nodejs/node/pull/8458)
* [[`d0e61d4cc3`](https://github.com/nodejs/node/commit/d0e61d4cc3)] - **test**: make crypto.timingSafeEqual test less flaky (not-an-aardvark) [#8456](https://github.com/nodejs/node/pull/8456)
* [[`154d6893b0`](https://github.com/nodejs/node/commit/154d6893b0)] - **test**: add test-debug-protocol-execute (Rich Trott) [#8454](https://github.com/nodejs/node/pull/8454)
* [[`6c30dddc36`](https://github.com/nodejs/node/commit/6c30dddc36)] - **test**: exercise EE function type checking paths (cjihrig) [#8168](https://github.com/nodejs/node/pull/8168)
* [[`d536d6d334`](https://github.com/nodejs/node/commit/d536d6d334)] - **test**: increase `_debugger` coverage (Rich Trott) [#8403](https://github.com/nodejs/node/pull/8403)
* [[`6d07e57a36`](https://github.com/nodejs/node/commit/6d07e57a36)] - **test**: mark pseudo-tty/no_dropped_stdio as flaky (Michael Dawson) [#8385](https://github.com/nodejs/node/pull/8385)
* [[`680a4c8b8e`](https://github.com/nodejs/node/commit/680a4c8b8e)] - **test**: test non-buffer/string with zlib (Rich Trott) [#8350](https://github.com/nodejs/node/pull/8350)
* [[`f0300eda27`](https://github.com/nodejs/node/commit/f0300eda27)] - **test**: fix test-cluster-dgram-1 flakiness (Santiago Gimeno) [#8383](https://github.com/nodejs/node/pull/8383)
* [[`b8fa7c949d`](https://github.com/nodejs/node/commit/b8fa7c949d)] - **test**: fix ::1 error in test-dns-ipv6 (Gibson Fahnestock) [#8254](https://github.com/nodejs/node/pull/8254)
* [[`c07e063dd9`](https://github.com/nodejs/node/commit/c07e063dd9)] - **test**: fix `fs-watch-recursive` flakiness on OS X (Santiago Gimeno) [#4629](https://github.com/nodejs/node/pull/4629)
* [[`1aa7168e91`](https://github.com/nodejs/node/commit/1aa7168e91)] - **test**: refactor/cleanup a number of cluster tests (James M Snell) [#8261](https://github.com/nodejs/node/pull/8261)
* [[`39cf7bf24d`](https://github.com/nodejs/node/commit/39cf7bf24d)] - **test**: refactor parallel/test-process-env.js (Rich Trott) [#8324](https://github.com/nodejs/node/pull/8324)
* [[`40e84218a0`](https://github.com/nodejs/node/commit/40e84218a0)] - **test**: add test for zlib.create*Raw() (Rich Trott) [#8306](https://github.com/nodejs/node/pull/8306)
* [[`cc61d1a3ba`](https://github.com/nodejs/node/commit/cc61d1a3ba)] - **test**: cleanup test require symlink (Paul Grock) [#8305](https://github.com/nodejs/node/pull/8305)
* [[`cde0a1edfd`](https://github.com/nodejs/node/commit/cde0a1edfd)] - **test**: refactor test-debug-signal-cluster (Rich Trott) [#8289](https://github.com/nodejs/node/pull/8289)
* [[`bc6a7ca8e7`](https://github.com/nodejs/node/commit/bc6a7ca8e7)] - **test**: additional refactoring/cleanup of buffer tests (James M Snell) [#8283](https://github.com/nodejs/node/pull/8283)
* [[`5d43131af4`](https://github.com/nodejs/node/commit/5d43131af4)] - **test**: add known issue test for path parse issue #6229 (James M Snell) [#8293](https://github.com/nodejs/node/pull/8293)
* [[`d2179bd6f1`](https://github.com/nodejs/node/commit/d2179bd6f1)] - **test**: make sure over truncation of file zero fills (Sakthipriyan Vairamani) [#7648](https://github.com/nodejs/node/pull/7648)
* [[`5cff625d6a`](https://github.com/nodejs/node/commit/5cff625d6a)] - **test**: add check in test-signal-handler (Rich Trott) [#8248](https://github.com/nodejs/node/pull/8248)
* [[`0b0a1ceac3`](https://github.com/nodejs/node/commit/0b0a1ceac3)] - **test**: clean up / refactor buffer tests, remove duplication (James M Snell) [#8256](https://github.com/nodejs/node/pull/8256)
* [[`0f977f9797`](https://github.com/nodejs/node/commit/0f977f9797)] - **test**: mark test-child-process-fork-dgram as flaky (Michael Dawson) [#8274](https://github.com/nodejs/node/pull/8274)
* [[`6f269bed99`](https://github.com/nodejs/node/commit/6f269bed99)] - **test**: refactor test-util-inspect (Rich Trott) [#8189](https://github.com/nodejs/node/pull/8189)
* [[`eff771f399`](https://github.com/nodejs/node/commit/eff771f399)] - **tickprocessor**: apply c++filt manually on mac (Fedor Indutny) [#8480](https://github.com/nodejs/node/pull/8480)
* [[`f47ce9d9f8`](https://github.com/nodejs/node/commit/f47ce9d9f8)] - **tools**: replace custom ESLint rule with built-in (Rich Trott) [#8478](https://github.com/nodejs/node/pull/8478)
* [[`36235ac323`](https://github.com/nodejs/node/commit/36235ac323)] - **tools**: update ESLint to 3.5.0 (Rich Trott) [#8478](https://github.com/nodejs/node/pull/8478)
* [[`ef5cb129ae`](https://github.com/nodejs/node/commit/ef5cb129ae)] - **tools**: fix new-parens violations (Rich Trott) [#8478](https://github.com/nodejs/node/pull/8478)
* [[`773e1c1304`](https://github.com/nodejs/node/commit/773e1c1304)] - **tools**: enable caching for jslint task (Rich Trott) [#8296](https://github.com/nodejs/node/pull/8296)
* [[`54f689fc1e`](https://github.com/nodejs/node/commit/54f689fc1e)] - **tools**: update ESLint to 3.4.0 (Rich Trott) [#8296](https://github.com/nodejs/node/pull/8296)
* [[`f840bc87d6`](https://github.com/nodejs/node/commit/f840bc87d6)] - **url**: fix off-by-one error in loop handling dots (Luigi Pinca) [#8420](https://github.com/nodejs/node/pull/8420)
* [[`6ae7af0fa3`](https://github.com/nodejs/node/commit/6ae7af0fa3)] - **url**: keep auth in `url.resolve()` if host matches (Ilkka Myller) [#8215](https://github.com/nodejs/node/pull/8215)
* [[`eec5d02266`](https://github.com/nodejs/node/commit/eec5d02266)] - **url**: `url.format()` encodes all `#` in `search` (Ilkka Myller) [#8072](https://github.com/nodejs/node/pull/8072)
* [[`d67ece2f68`](https://github.com/nodejs/node/commit/d67ece2f68)] - **util**: improve function signature of `util._extend` (Sakthipriyan Vairamani) [#8187](https://github.com/nodejs/node/pull/8187)
* [[`e9c4805c1f`](https://github.com/nodejs/node/commit/e9c4805c1f)] - **(SEMVER-MINOR)** **util**: allow returning `this` from custom inspect (Anna Henningsen) [#8174](https://github.com/nodejs/node/pull/8174)
* [[`4cb55ff392`](https://github.com/nodejs/node/commit/4cb55ff392)] - **(SEMVER-MINOR)** **util**: allow symbol-based custom inspection methods (Anna Henningsen) [#8174](https://github.com/nodejs/node/pull/8174)
* [[`151d1ea6a6`](https://github.com/nodejs/node/commit/151d1ea6a6)] - **vm**: change ContextifyScript to Script in comment (Daniel Bevenius) [#8415](https://github.com/nodejs/node/pull/8415)
* [[`f346dee940`](https://github.com/nodejs/node/commit/f346dee940)] - **win,build**: forward release_urlbase to configure (João Reis) [#8430](https://github.com/nodejs/node/pull/8430)
* [[`6bb057ec6a`](https://github.com/nodejs/node/commit/6bb057ec6a)] - **win,build**: exit when addons fail to build (João Reis) [#8412](https://github.com/nodejs/node/pull/8412)
* [[`14d356d0ab`](https://github.com/nodejs/node/commit/14d356d0ab)] - **win,build**: skip finding VS when not needed (João Reis) [#8412](https://github.com/nodejs/node/pull/8412)
* [[`81d063e174`](https://github.com/nodejs/node/commit/81d063e174)] - **win,build**: fail on invalid option in vcbuild (João Reis) [#8412](https://github.com/nodejs/node/pull/8412)

<a id="6.5.0"></a>
## 2016-08-26, Version 6.5.0 (Current), @evanlucas

### Notable changes

* **buffer**: Fix regression introduced in v6.4.0 that prevented .write() at buffer end (Anna Henningsen) [#8154](https://github.com/nodejs/node/pull/8154)
* **deps**: update V8 to 5.1.281.75 (Ali Ijaz Sheikh) [#8054](https://github.com/nodejs/node/pull/8054)
* **inspector**:
  * fix inspector hang while disconnecting (Aleksei Koziatinskii) [#8021](https://github.com/nodejs/node/pull/8021)
  * add support for uncaught exception (Aleksei Koziatinskii) [#8043](https://github.com/nodejs/node/pull/8043)
* **repl**: Fix saving editor mode text in `.save` (Prince J Wesley) [#8145](https://github.com/nodejs/node/pull/8145)
* ***Revert*** "**repl,util**: insert carriage returns in output" (Evan Lucas) [#8143](https://github.com/nodejs/node/pull/8143)

### Commits

* [[`5bc311909f`](https://github.com/nodejs/node/commit/5bc311909f)] - **assert**: remove code that is never reached (Rich Trott) [#8132](https://github.com/nodejs/node/pull/8132)
* [[`e371545dfe`](https://github.com/nodejs/node/commit/e371545dfe)] - **buffer**: allow .write() offset to be at buffer end (Anna Henningsen) [#8154](https://github.com/nodejs/node/pull/8154)
* [[`dcd065522e`](https://github.com/nodejs/node/commit/dcd065522e)] - **(SEMVER-MINOR)** **build**: don't include V8 from node.gyp (Michaël Zasso) [#7016](https://github.com/nodejs/node/pull/7016)
* [[`92ecbc4edc`](https://github.com/nodejs/node/commit/92ecbc4edc)] - **build**: cherry pick V8 change for windows DLL support (Stefan Budeanu) [#8084](https://github.com/nodejs/node/pull/8084)
* [[`4e4c091542`](https://github.com/nodejs/node/commit/4e4c091542)] - **build**: windows sharedlib support (Stefan Budeanu) [#8084](https://github.com/nodejs/node/pull/8084)
* [[`f4c3456610`](https://github.com/nodejs/node/commit/f4c3456610)] - **build**: do not lint src dir for JS errors (Rich Trott) [#8128](https://github.com/nodejs/node/pull/8128)
* [[`71343b6caa`](https://github.com/nodejs/node/commit/71343b6caa)] - **child_process**: reuse existing no-op function (cjihrig) [#8164](https://github.com/nodejs/node/pull/8164)
* [[`0884c70535`](https://github.com/nodejs/node/commit/0884c70535)] - **child_process**: workaround fd passing issue on OS X (Santiago Gimeno) [#7572](https://github.com/nodejs/node/pull/7572)
* [[`8eb6e71758`](https://github.com/nodejs/node/commit/8eb6e71758)] - **configure**: reword help for --without-npm (BlackYoup) [#7471](https://github.com/nodejs/node/pull/7471)
* [[`c406ad8258`](https://github.com/nodejs/node/commit/c406ad8258)] - **debugger**: use arrow function for lexical `this` (Guy Fraser) [#7415](https://github.com/nodejs/node/pull/7415)
* [[`723fa9637c`](https://github.com/nodejs/node/commit/723fa9637c)] - **deps**: cherry-pick de5aaad from V8's upstream (Michaël Zasso) [#8099](https://github.com/nodejs/node/pull/8099)
* [[`fc2a89ccb7`](https://github.com/nodejs/node/commit/fc2a89ccb7)] - **deps**: V8: cherry-pick 588e15c, c0d4bb8 (epertoso) [#8038](https://github.com/nodejs/node/pull/8038)
* [[`cd77ca397a`](https://github.com/nodejs/node/commit/cd77ca397a)] - **deps**: cherry-pick 6f68f30 from v8 upstream (Stefan Budeanu) [#7802](https://github.com/nodejs/node/pull/7802)
* [[`b4f11efafa`](https://github.com/nodejs/node/commit/b4f11efafa)] - **deps**: cherry-pick a51f429 from V8 upstream (Franziska Hinkelmann) [#7833](https://github.com/nodejs/node/pull/7833)
* [[`4a20869714`](https://github.com/nodejs/node/commit/4a20869714)] - **deps**: cherry-pick a76d133 from v8 upstream (Matt Loring) [#7689](https://github.com/nodejs/node/pull/7689)
* [[`3b2f692b23`](https://github.com/nodejs/node/commit/3b2f692b23)] - **deps**: cherry-pick b93c80a from v8 upstream (Matt Loring) [#7689](https://github.com/nodejs/node/pull/7689)
* [[`c4401d283b`](https://github.com/nodejs/node/commit/c4401d283b)] - **deps**: cherry-pick 2b4c9c1 from v8 upstream (Joran Siu) [#7771](https://github.com/nodejs/node/pull/7771)
* [[`0ac21bc860`](https://github.com/nodejs/node/commit/0ac21bc860)] - **deps**: cherry-pick 1f53e42 from v8 upstream (Ben Noordhuis) [#7612](https://github.com/nodejs/node/pull/7612)
* [[`fc442e0f43`](https://github.com/nodejs/node/commit/fc442e0f43)] - **deps**: cherry-pick d721121 from v8 upstream (Ben Noordhuis) [#7632](https://github.com/nodejs/node/pull/7632)
* [[`9a4b338f0c`](https://github.com/nodejs/node/commit/9a4b338f0c)] - **deps**: remove extra field from v8::HeapStatistics (Anna Henningsen) [#7526](https://github.com/nodejs/node/pull/7526)
* [[`2c46e23969`](https://github.com/nodejs/node/commit/2c46e23969)] - **(SEMVER-MINOR)** **deps**: bring in V8 5.1 - 5.0 ABI compatibility (Matt Loring) [#7016](https://github.com/nodejs/node/pull/7016)
* [[`06a6c03e57`](https://github.com/nodejs/node/commit/06a6c03e57)] - **(SEMVER-MINOR)** **deps**: revert removal of V8::PromiseEvent (Matt Loring) [#7016](https://github.com/nodejs/node/pull/7016)
* [[`a91f6b8433`](https://github.com/nodejs/node/commit/a91f6b8433)] - **deps**: backport IsValid changes from 4e8736d in V8 (Michaël Zasso) [#6544](https://github.com/nodejs/node/pull/6544)
* [[`b2f7c32a9f`](https://github.com/nodejs/node/commit/b2f7c32a9f)] - **deps**: cherry-pick 1ef7487b from v8 upstream (Michael Dawson) [#6218](https://github.com/nodejs/node/pull/6218)
* [[`7af2f63f10`](https://github.com/nodejs/node/commit/7af2f63f10)] - **deps**: limit regress/regress-crbug-514081 v8 test (Michael Dawson) [#6678](https://github.com/nodejs/node/pull/6678)
* [[`abbad66126`](https://github.com/nodejs/node/commit/abbad66126)] - **(SEMVER-MINOR)** **deps**: update V8 to 5.1.281.75 (Ali Ijaz Sheikh) [#8054](https://github.com/nodejs/node/pull/8054)
* [[`08e2b0408a`](https://github.com/nodejs/node/commit/08e2b0408a)] - **deps**: cherry-pick 7bd24767 from v8 upstream (v6.x) (Franziska Hinkelmann) [#8078](https://github.com/nodejs/node/pull/8078)
* [[`d0cb52b967`](https://github.com/nodejs/node/commit/d0cb52b967)] - **dns**: remove makeAsync() function check (cjihrig) [#8170](https://github.com/nodejs/node/pull/8170)
* [[`70648f47ca`](https://github.com/nodejs/node/commit/70648f47ca)] - **dns**: lookupService() callback must be a function (cjihrig) [#8170](https://github.com/nodejs/node/pull/8170)
* [[`d9142b4bd6`](https://github.com/nodejs/node/commit/d9142b4bd6)] - **doc**: add `added:` information for util (Luigi Pinca) [#8206](https://github.com/nodejs/node/pull/8206)
* [[`c2f5471f6d`](https://github.com/nodejs/node/commit/c2f5471f6d)] - **doc**: remove "feature branch" jargon (Rich Trott) [#8194](https://github.com/nodejs/node/pull/8194)
* [[`7f34cc3e03`](https://github.com/nodejs/node/commit/7f34cc3e03)] - **doc**: correct argument type for process.cpuUsage (Simen Bekkhus) [#8158](https://github.com/nodejs/node/pull/8158)
* [[`0c9960b3c5`](https://github.com/nodejs/node/commit/0c9960b3c5)] - **doc**: remove outdated LTS info from ROADMAP.md (Rich Trott) [#8161](https://github.com/nodejs/node/pull/8161)
* [[`afbe4d8ebd`](https://github.com/nodejs/node/commit/afbe4d8ebd)] - **doc**: add es6 code example in util.md (Shahid Shaikh) [#8183](https://github.com/nodejs/node/pull/8183)
* [[`4a8aca7f94`](https://github.com/nodejs/node/commit/4a8aca7f94)] - **doc**: script with spaces spawn example for windows (Bartosz Sosnowski) [#8035](https://github.com/nodejs/node/pull/8035)
* [[`82329b6e8f`](https://github.com/nodejs/node/commit/82329b6e8f)] - **doc**: fix variable scoping bug in server example code (lazlojuly) [#8124](https://github.com/nodejs/node/pull/8124)
* [[`d7ab1baed2`](https://github.com/nodejs/node/commit/d7ab1baed2)] - **doc**: update release announce instruction to tweet (Tracy Hinds) [#8126](https://github.com/nodejs/node/pull/8126)
* [[`5d37b49f90`](https://github.com/nodejs/node/commit/5d37b49f90)] - **doc**: add @joshgav to collaborators (Josh Gavant) [#8146](https://github.com/nodejs/node/pull/8146)
* [[`31653a5006`](https://github.com/nodejs/node/commit/31653a5006)] - **doc**: update Reviewing section of onboarding doc (Rich Trott)
* [[`bf5c5f3ce0`](https://github.com/nodejs/node/commit/bf5c5f3ce0)] - **doc**: fix "hashOwnProperty" typo in querystring (Ben Gourley) [#8107](https://github.com/nodejs/node/pull/8107)
* [[`b1922e7b5b`](https://github.com/nodejs/node/commit/b1922e7b5b)] - **dtrace**: fix ustack helper for V8 5.1 (Ali Ijaz Sheikh) [#6482](https://github.com/nodejs/node/pull/6482)
* [[`92de0bc1a6`](https://github.com/nodejs/node/commit/92de0bc1a6)] - **inspector**: fix inspector hang while disconnecting (Aleksei Koziatinskii) [#8021](https://github.com/nodejs/node/pull/8021)
* [[`bfd8265ec2`](https://github.com/nodejs/node/commit/bfd8265ec2)] - **inspector**: add support for uncaught exception (Aleksei Koziatinskii) [#8043](https://github.com/nodejs/node/pull/8043)
* [[`089a1cbecb`](https://github.com/nodejs/node/commit/089a1cbecb)] - **net**: add length check when normalizing args (Brian White) [#8112](https://github.com/nodejs/node/pull/8112)
* [[`17b8381585`](https://github.com/nodejs/node/commit/17b8381585)] - **net**: remove unnecessary variables (Brian White) [#8112](https://github.com/nodejs/node/pull/8112)
* [[`fbc5805e65`](https://github.com/nodejs/node/commit/fbc5805e65)] - **readline**: keypress trigger for escape character (Prince J Wesley) [#7382](https://github.com/nodejs/node/pull/7382)
* [[`66e66e59a4`](https://github.com/nodejs/node/commit/66e66e59a4)] - **(SEMVER-MINOR)** **repl**: fix repl after V8 upgrade (Ali Ijaz Sheikh) [#7016](https://github.com/nodejs/node/pull/7016)
* [[`60c50468e3`](https://github.com/nodejs/node/commit/60c50468e3)] - **repl**: Failed to save editor mode text in `.save` (Prince J Wesley) [#8145](https://github.com/nodejs/node/pull/8145)
* [[`ffb2db8285`](https://github.com/nodejs/node/commit/ffb2db8285)] - ***Revert*** "**repl,util**: insert carriage returns in output" (Evan Lucas) [#8143](https://github.com/nodejs/node/pull/8143)
* [[`4118598dbb`](https://github.com/nodejs/node/commit/4118598dbb)] - **src**: don't include a null character in the WriteConsoleW call (Nikolai Vavilov) [#7764](https://github.com/nodejs/node/pull/7764)
* [[`d863619a30`](https://github.com/nodejs/node/commit/d863619a30)] - **src**: clean up PER_ISOLATE_STRING_PROPERTIES, v2 (Ben Noordhuis) [#8207](https://github.com/nodejs/node/pull/8207)
* [[`d3950a2013`](https://github.com/nodejs/node/commit/d3950a2013)] - **src**: clean up PER_ISOLATE_STRING_PROPERTIES, v1 (Ben Noordhuis) [#8207](https://github.com/nodejs/node/pull/8207)
* [[`8f9fb8154d`](https://github.com/nodejs/node/commit/8f9fb8154d)] - **src**: updating references to the old node.js file (Daniel Bevenius) [#8092](https://github.com/nodejs/node/pull/8092)
* [[`091ba2c511`](https://github.com/nodejs/node/commit/091ba2c511)] - **src**: fix build break for !NODE_USE_V8_PLATFORM (Kunal Pathak) [#8114](https://github.com/nodejs/node/pull/8114)
* [[`1bf80a0a3f`](https://github.com/nodejs/node/commit/1bf80a0a3f)] - **stream**: avoid caching prepend check (Calvin Metcalf) [#8018](https://github.com/nodejs/node/pull/8018)
* [[`cda8bfc3c8`](https://github.com/nodejs/node/commit/cda8bfc3c8)] - **test**: fix tests after V8 upgrade (Ali Ijaz Sheikh) [#6482](https://github.com/nodejs/node/pull/6482)
* [[`441e8fe566`](https://github.com/nodejs/node/commit/441e8fe566)] - **test**: refactor test-timers-linked-list.js (Rich Trott) [#8193](https://github.com/nodejs/node/pull/8193)
* [[`bb6d6a677c`](https://github.com/nodejs/node/commit/bb6d6a677c)] - **test**: fix flaky `test-child-process-pass-fd` (Santiago Gimeno) [#8212](https://github.com/nodejs/node/pull/8212)
* [[`b0619e8dff`](https://github.com/nodejs/node/commit/b0619e8dff)] - **test**: comparison operator now more strict (Jason Hedrick) [#8190](https://github.com/nodejs/node/pull/8190)
* [[`923a61774d`](https://github.com/nodejs/node/commit/923a61774d)] - **test**: refactor test-tick-processor (Rich Trott) [#8180](https://github.com/nodejs/node/pull/8180)
* [[`b9b762f308`](https://github.com/nodejs/node/commit/b9b762f308)] - **test**: add test for invalid cert string (Rich Trott) [#8179](https://github.com/nodejs/node/pull/8179)
* [[`a6f83797df`](https://github.com/nodejs/node/commit/a6f83797df)] - **test**: add assert.notDeepStrictEqual() tests (Rich Trott) [#8177](https://github.com/nodejs/node/pull/8177)
* [[`29a71965c0`](https://github.com/nodejs/node/commit/29a71965c0)] - **test**: favor `===` over `==` in crypto tests (Rich Trott) [#8176](https://github.com/nodejs/node/pull/8176)
* [[`c568dfad39`](https://github.com/nodejs/node/commit/c568dfad39)] - **test**: refactor pummel/test-dtrace-jsstack (Rich Trott) [#8175](https://github.com/nodejs/node/pull/8175)
* [[`cfbafd7c7d`](https://github.com/nodejs/node/commit/cfbafd7c7d)] - **test**: favor strict equality in test-exec (Rich Trott) [#8173](https://github.com/nodejs/node/pull/8173)
* [[`b8f5a2b789`](https://github.com/nodejs/node/commit/b8f5a2b789)] - **test**: favor `===` over `==` in vm test (jun-oka) [#8191](https://github.com/nodejs/node/pull/8191)
* [[`498238f462`](https://github.com/nodejs/node/commit/498238f462)] - **test**: test sending over a closed IPC channel (cjihrig) [#8160](https://github.com/nodejs/node/pull/8160)
* [[`15bd48986b`](https://github.com/nodejs/node/commit/15bd48986b)] - **test**: add test for attempted multiple IPC channels (cjihrig) [#8159](https://github.com/nodejs/node/pull/8159)
* [[`4deb05434f`](https://github.com/nodejs/node/commit/4deb05434f)] - **test**: add assert.notDeepEqual() tests (Rich Trott) [#8156](https://github.com/nodejs/node/pull/8156)
* [[`3d0cf9e4f1`](https://github.com/nodejs/node/commit/3d0cf9e4f1)] - **test**: add missing assert.deepEqual() test case (Rich Trott) [#8152](https://github.com/nodejs/node/pull/8152)
* [[`6abbe17ab2`](https://github.com/nodejs/node/commit/6abbe17ab2)] - **test**: favor strict equality in http tests (Rich Trott) [#8151](https://github.com/nodejs/node/pull/8151)
* [[`cc9bb34120`](https://github.com/nodejs/node/commit/cc9bb34120)] - **test**: favor strict equality in pummel net tests (Rich Trott) [#8135](https://github.com/nodejs/node/pull/8135)
* [[`4b6ed24f02`](https://github.com/nodejs/node/commit/4b6ed24f02)] - **test**: confirm that assert truncates long values (Rich Trott) [#8134](https://github.com/nodejs/node/pull/8134)
* [[`e5a8790727`](https://github.com/nodejs/node/commit/e5a8790727)] - **test**: favor `===` over `==` in test-timers.js (Rich Trott) [#8131](https://github.com/nodejs/node/pull/8131)
* [[`086e57f404`](https://github.com/nodejs/node/commit/086e57f404)] - **test**: favor strict equality check (Rich Trott) [#8130](https://github.com/nodejs/node/pull/8130)
* [[`9a393a7ff4`](https://github.com/nodejs/node/commit/9a393a7ff4)] - **test**: fix assertion in test-watch-file.js (Rich Trott) [#8129](https://github.com/nodejs/node/pull/8129)
* [[`4f09886dce`](https://github.com/nodejs/node/commit/4f09886dce)] - **test**: fix flaky fs-watch tests (Santiago Gimeno) [#8115](https://github.com/nodejs/node/pull/8115)
* [[`d401e5575a`](https://github.com/nodejs/node/commit/d401e5575a)] - **test**: add an zlib binding addon test (Anna Henningsen) [#8039](https://github.com/nodejs/node/pull/8039)
* [[`6bdc0e54b4`](https://github.com/nodejs/node/commit/6bdc0e54b4)] - **test**: use strict equality in regression test (Rich Trott) [#8098](https://github.com/nodejs/node/pull/8098)
* [[`be41f584f3`](https://github.com/nodejs/node/commit/be41f584f3)] - **test**: remove extraneous space (Rich Trott) [#8097](https://github.com/nodejs/node/pull/8097)
* [[`853f605de4`](https://github.com/nodejs/node/commit/853f605de4)] - **test**: add test for assert.notStrictEqual() (Rich Trott) [#8091](https://github.com/nodejs/node/pull/8091)
* [[`f4698f3568`](https://github.com/nodejs/node/commit/f4698f3568)] - **test**: add uncaught exception test for debugger (Rich Trott) [#8087](https://github.com/nodejs/node/pull/8087)
* [[`c26b9af1e2`](https://github.com/nodejs/node/commit/c26b9af1e2)] - **tls**: copy the Buffer object before using (Sakthipriyan Vairamani) [#8055](https://github.com/nodejs/node/pull/8055)
* [[`cdcf23ab7f`](https://github.com/nodejs/node/commit/cdcf23ab7f)] - **tools**: update ESLint to 3.3.0 and enable rules (Rich Trott) [#8097](https://github.com/nodejs/node/pull/8097)
* [[`14c7dcbbcd`](https://github.com/nodejs/node/commit/14c7dcbbcd)] - **url**: fix inconsistent port in url.resolveObject (Ilkka Myller) [#8214](https://github.com/nodejs/node/pull/8214)
* [[`1f9fbade4c`](https://github.com/nodejs/node/commit/1f9fbade4c)] - **util**: fix deprecated class prototype (Bryan English) [#8105](https://github.com/nodejs/node/pull/8105)
* [[`44f781d06a`](https://github.com/nodejs/node/commit/44f781d06a)] - **v8**: warn in Template::Set() on improper use (Ben Noordhuis) [#6277](https://github.com/nodejs/node/pull/6277)
* [[`a146e683dd`](https://github.com/nodejs/node/commit/a146e683dd)] - **win,msi**: add zh-CN translations for the installer (Minqi Pan) [#2569](https://github.com/nodejs/node/pull/2569)

<a id="6.4.0"></a>
## 2016-08-15, Version 6.4.0 (Current), @cjihrig

### Notable changes

* **build**: zlib symbols and additional OpenSSL symbols are now exposed on Windows platforms. (Alex Hultman) [#7983](https://github.com/nodejs/node/pull/7983) and [#7576](https://github.com/nodejs/node/pull/7576)
* **child_process**, **cluster**: Forked child processes and cluster workers now support stdio configuration. (Colin Ihrig) [#7811](https://github.com/nodejs/node/pull/7811) and [#7838](https://github.com/nodejs/node/pull/7838)
* **child_process**: `argv[0]` can now be set to arbitrary values in spawned processes. (Pat Pannuto) [#7696](https://github.com/nodejs/node/pull/7696)
* **fs**: `fs.ReadStream` now exposes the number of bytes it has read so far. (Linus Unnebäck) [#7942](https://github.com/nodejs/node/pull/7942)
* **repl**: The REPL now supports editor mode. (Prince J Wesley) [#7275](https://github.com/nodejs/node/pull/7275)
* **util**: `inspect()` can now be configured globally using `util.inspect.defaultOptions`. (Roman Reiss) [#8013](https://github.com/nodejs/node/pull/8013)

### Commits

* [[`06a0a053ea`](https://github.com/nodejs/node/commit/06a0a053ea)] - 2016-08-15, Version 6.4.0 (Current) (cjihrig) [#8070](https://github.com/nodejs/node/pull/8070)
* [[`342a85b1a7`](https://github.com/nodejs/node/commit/342a85b1a7)] - Working on v6.3.2 (Evan Lucas) [#7782](https://github.com/nodejs/node/pull/7782)
* [[`f135a4c3d1`](https://github.com/nodejs/node/commit/f135a4c3d1)] - 2016-07-21, Version 6.3.1 (Current) (Evan Lucas) [#7782](https://github.com/nodejs/node/pull/7782)
* [[`57043aad33`](https://github.com/nodejs/node/commit/57043aad33)] - **assert**: fix deepEqual/deepStrictEqual on equivalent typed arrays (Feross Aboukhadijeh) [#8002](https://github.com/nodejs/node/pull/8002)
* [[`f6713bfabd`](https://github.com/nodejs/node/commit/f6713bfabd)] - **bench**: add bench for fs.realpath() fix (Trevor Norris) [#7899](https://github.com/nodejs/node/pull/7899)
* [[`0d4b04659f`](https://github.com/nodejs/node/commit/0d4b04659f)] - **benchmark**: favor === over == (Rich Trott) [#8000](https://github.com/nodejs/node/pull/8000)
* [[`98f51ffeb6`](https://github.com/nodejs/node/commit/98f51ffeb6)] - **buffer**: fix unintended unsigned overflow (Fedor Indutny) [#7494](https://github.com/nodejs/node/pull/7494)
* [[`28071a130e`](https://github.com/nodejs/node/commit/28071a130e)] - **buffer**: introduce latin1 encoding term (Trevor Norris) [#7111](https://github.com/nodejs/node/pull/7111)
* [[`b0a557eef7`](https://github.com/nodejs/node/commit/b0a557eef7)] - **build**: add correct shared library naming on OS X (Stewart Addison) [#7687](https://github.com/nodejs/node/pull/7687)
* [[`6ed4ea8fd6`](https://github.com/nodejs/node/commit/6ed4ea8fd6)] - **build**: turn on thin static archives (Ben Noordhuis) [#7957](https://github.com/nodejs/node/pull/7957)
* [[`c843e58914`](https://github.com/nodejs/node/commit/c843e58914)] - **(SEMVER-MINOR)** **build**: export zlib symbols on Windows (Alex Hultman) [#7983](https://github.com/nodejs/node/pull/7983)
* [[`889c62fec1`](https://github.com/nodejs/node/commit/889c62fec1)] - **build**: fix dependency on missing header file (Ben Noordhuis) [#7945](https://github.com/nodejs/node/pull/7945)
* [[`a4394b8745`](https://github.com/nodejs/node/commit/a4394b8745)] - **build**: fix typo in non-essential source file name (Ben Noordhuis) [#7945](https://github.com/nodejs/node/pull/7945)
* [[`636cf2236a`](https://github.com/nodejs/node/commit/636cf2236a)] - **build**: adding config.gypi dep to addons/.buildstamp (Daniel Bevenius) [#7893](https://github.com/nodejs/node/pull/7893)
* [[`ddf292fc32`](https://github.com/nodejs/node/commit/ddf292fc32)] - **build**: don't link against liblog on host system (Ben Noordhuis) [#7762](https://github.com/nodejs/node/pull/7762)
* [[`f0312e6560`](https://github.com/nodejs/node/commit/f0312e6560)] - **(SEMVER-MINOR)** **build**: export more openssl symbols on Windows (Alex Hultman) [#7576](https://github.com/nodejs/node/pull/7576)
* [[`e561895275`](https://github.com/nodejs/node/commit/e561895275)] - **(SEMVER-MINOR)** **child_process**: control argv0 for spawned processes (Pat Pannuto) [#7696](https://github.com/nodejs/node/pull/7696)
* [[`da481c634f`](https://github.com/nodejs/node/commit/da481c634f)] - **(SEMVER-MINOR)** **child_process**: support stdio option in fork() (cjihrig) [#7811](https://github.com/nodejs/node/pull/7811)
* [[`a4f0b13e2b`](https://github.com/nodejs/node/commit/a4f0b13e2b)] - **(SEMVER-MINOR)** **cluster**: support stdio option for workers (cjihrig) [#7838](https://github.com/nodejs/node/pull/7838)
* [[`5f3ab3ffd1`](https://github.com/nodejs/node/commit/5f3ab3ffd1)] - **(SEMVER-MINOR)** **crypto**: fix undefined behavior in ParseExtension (Fedor Indutny) [#7494](https://github.com/nodejs/node/pull/7494)
* [[`60d6e048f0`](https://github.com/nodejs/node/commit/60d6e048f0)] - **(SEMVER-MINOR)** **deps**: v8_inspector: console support (Aleksei Koziatinskii) [#7988](https://github.com/nodejs/node/pull/7988)
* [[`a9fe85ee9c`](https://github.com/nodejs/node/commit/a9fe85ee9c)] - **deps**: v8_inspector update (Ali Ijaz Sheikh) [#8014](https://github.com/nodejs/node/pull/8014)
* [[`4d81362b99`](https://github.com/nodejs/node/commit/4d81362b99)] - **deps**: v8_inspector: remove jinja2 tests (Ali Ijaz Sheikh) [#7796](https://github.com/nodejs/node/pull/7796)
* [[`57312fc0c5`](https://github.com/nodejs/node/commit/57312fc0c5)] - **deps**: remove jinja.el from deps/v8_inspector (Ali Ijaz Sheikh) [#7796](https://github.com/nodejs/node/pull/7796)
* [[`507c65d94a`](https://github.com/nodejs/node/commit/507c65d94a)] - **deps**: update v8_inspector (Ali Ijaz Sheikh) [#7796](https://github.com/nodejs/node/pull/7796)
* [[`3f46b5c18e`](https://github.com/nodejs/node/commit/3f46b5c18e)] - **deps**: float gyp patch for long filenames (Anna Henningsen) [#7963](https://github.com/nodejs/node/pull/7963)
* [[`e6887e2ceb`](https://github.com/nodejs/node/commit/e6887e2ceb)] - **deps**: cherry-pick a76d133 from v8 upstream (Matt Loring) [#7689](https://github.com/nodejs/node/pull/7689)
* [[`a03e3d3cff`](https://github.com/nodejs/node/commit/a03e3d3cff)] - **deps**: cherry-pick b93c80a from v8 upstream (Matt Loring) [#7689](https://github.com/nodejs/node/pull/7689)
* [[`75b37a6bac`](https://github.com/nodejs/node/commit/75b37a6bac)] - **deps**: cherry-pick 43547df from V8 upstream (Franziska Hinkelmann) [#7863](https://github.com/nodejs/node/pull/7863)
* [[`af63871593`](https://github.com/nodejs/node/commit/af63871593)] - **deps**: cherry-pick a51f429 from V8 upstream (Franziska Hinkelmann) [#7834](https://github.com/nodejs/node/pull/7834)
* [[`e82e80417b`](https://github.com/nodejs/node/commit/e82e80417b)] - **deps**: backport 2bcbe2f from V8 upstream (ofrobots) [#7814](https://github.com/nodejs/node/pull/7814)
* [[`51a2041b90`](https://github.com/nodejs/node/commit/51a2041b90)] - **(SEMVER-MINOR)** **dgram**: generalized send queue to handle close (Matteo Collina) [#7066](https://github.com/nodejs/node/pull/7066)
* [[`7eb95f6faa`](https://github.com/nodejs/node/commit/7eb95f6faa)] - **doc**: minor updates to onboarding doc (Rich Trott) [#8060](https://github.com/nodejs/node/pull/8060)
* [[`5259322e62`](https://github.com/nodejs/node/commit/5259322e62)] - **doc**: add POST_STATUS_TO_PR info to onboarding doc (Rich Trott) [#8059](https://github.com/nodejs/node/pull/8059)
* [[`1903275963`](https://github.com/nodejs/node/commit/1903275963)] - **doc**: update windows prerequisites (Ben Noordhuis) [#8049](https://github.com/nodejs/node/pull/8049)
* [[`3fe122f57e`](https://github.com/nodejs/node/commit/3fe122f57e)] - **doc**: update licenses (Ali Ijaz Sheikh) [#7796](https://github.com/nodejs/node/pull/7796)
* [[`14b762f81f`](https://github.com/nodejs/node/commit/14b762f81f)] - **doc**: move orangemocha to collaborators list (Rich Trott) [#8062](https://github.com/nodejs/node/pull/8062)
* [[`ffbead92a0`](https://github.com/nodejs/node/commit/ffbead92a0)] - **doc**: Add fhinkel to collaborators (Franziska Hinkelmann) [#8052](https://github.com/nodejs/node/pull/8052)
* [[`96d15e2f3c`](https://github.com/nodejs/node/commit/96d15e2f3c)] - **doc**: fix cluster message event docs (Zach Bjornson) [#8017](https://github.com/nodejs/node/pull/8017)
* [[`4a8b8048f2`](https://github.com/nodejs/node/commit/4a8b8048f2)] - **doc**: add `added:` information for cluster (Anna Henningsen) [#7640](https://github.com/nodejs/node/pull/7640)
* [[`38255080db`](https://github.com/nodejs/node/commit/38255080db)] - **doc**: remove spurious new line in CHANGELOG_V6.md (Luigi Pinca) [#8009](https://github.com/nodejs/node/pull/8009)
* [[`9f78c3f64f`](https://github.com/nodejs/node/commit/9f78c3f64f)] - **doc**: fix typo in vm.runInNewContext() description (Luigi Pinca) [#8005](https://github.com/nodejs/node/pull/8005)
* [[`c4765a1b66`](https://github.com/nodejs/node/commit/c4765a1b66)] - **doc**: Clean up roff source in manpage (Alhadis) [#7819](https://github.com/nodejs/node/pull/7819)
* [[`cbcd03c912`](https://github.com/nodejs/node/commit/cbcd03c912)] - **doc**: add CTC meeting minutes 2016-08-03 (Josh Gavant) [#7980](https://github.com/nodejs/node/pull/7980)
* [[`7d0e5a0622`](https://github.com/nodejs/node/commit/7d0e5a0622)] - **doc**: clarify collaborators & ctc members relationships (yorkie) [#7996](https://github.com/nodejs/node/pull/7996)
* [[`dedfcb7858`](https://github.com/nodejs/node/commit/dedfcb7858)] - **doc**: clarify fd closing by `fs.readFile` etc. (kibertoad) [#7561](https://github.com/nodejs/node/pull/7561)
* [[`ce776d22f9`](https://github.com/nodejs/node/commit/ce776d22f9)] - **doc**: fix a markdown error in CTC meeting minutes (Сковорода Никита Андреевич) [#7729](https://github.com/nodejs/node/pull/7729)
* [[`b20518a013`](https://github.com/nodejs/node/commit/b20518a013)] - **doc**: add `added:` information for events (Luigi Pinca) [#7822](https://github.com/nodejs/node/pull/7822)
* [[`7fa4be0f87`](https://github.com/nodejs/node/commit/7fa4be0f87)] - **doc**: improve server.listen() random port (Phillip Johnsen) [#7976](https://github.com/nodejs/node/pull/7976)
* [[`7c427bdccc`](https://github.com/nodejs/node/commit/7c427bdccc)] - **doc**: clarify "Reviewed-By" iff "LGTM" (Bryan English) [#7183](https://github.com/nodejs/node/pull/7183)
* [[`cdbeae9adc`](https://github.com/nodejs/node/commit/cdbeae9adc)] - **doc**: add CTC meeting minutes 2016-07-13 (Josh Gavant) [#7968](https://github.com/nodejs/node/pull/7968)
* [[`2245e843cc`](https://github.com/nodejs/node/commit/2245e843cc)] - **doc**: add CTC meeting minutes 2016-07-20 (Josh Gavant) [#7970](https://github.com/nodejs/node/pull/7970)
* [[`cb0baca982`](https://github.com/nodejs/node/commit/cb0baca982)] - **doc**: use consistent markdown in README (Rich Trott) [#7971](https://github.com/nodejs/node/pull/7971)
* [[`3d1a06451a`](https://github.com/nodejs/node/commit/3d1a06451a)] - **doc**: use `git-secure-tag` for release tags (Fedor Indutny) [#7603](https://github.com/nodejs/node/pull/7603)
* [[`e116cf96a0`](https://github.com/nodejs/node/commit/e116cf96a0)] - **doc**: use blockquotes for Stability: markers (Anna Henningsen) [#7757](https://github.com/nodejs/node/pull/7757)
* [[`c934f51aa4`](https://github.com/nodejs/node/commit/c934f51aa4)] - **doc**: fix default encoding mention in crypto.md (hugnosis) [#7805](https://github.com/nodejs/node/pull/7805)
* [[`df35ae6246`](https://github.com/nodejs/node/commit/df35ae6246)] - **doc**: fix minor formatting issue in 0.10 changelog (Сковорода Никита Андреевич) [#7727](https://github.com/nodejs/node/pull/7727)
* [[`5f12807c46`](https://github.com/nodejs/node/commit/5f12807c46)] - **doc**: remove extra indentation in iojs changelog (Сковорода Никита Андреевич) [#7727](https://github.com/nodejs/node/pull/7727)
* [[`abd0bc0523`](https://github.com/nodejs/node/commit/abd0bc0523)] - **doc**: *.md formatting fixes in the top-level dir (Сковорода Никита Андреевич) [#7727](https://github.com/nodejs/node/pull/7727)
* [[`c72019b75a`](https://github.com/nodejs/node/commit/c72019b75a)] - **doc**: convert tabs to spaces (Сковорода Никита Андреевич) [#7727](https://github.com/nodejs/node/pull/7727)
* [[`0fbb83a67b`](https://github.com/nodejs/node/commit/0fbb83a67b)] - **doc**: piscisaureus has stepped-down from the CTC (James M Snell) [#7969](https://github.com/nodejs/node/pull/7969)
* [[`48422c240a`](https://github.com/nodejs/node/commit/48422c240a)] - **doc**: add @addaleax to the CTC (Anna Henningsen) [#7966](https://github.com/nodejs/node/pull/7966)
* [[`0094adc0b2`](https://github.com/nodejs/node/commit/0094adc0b2)] - **doc**: add CTC meeting minutes 2016-06-22 (Josh Gavant) [#7390](https://github.com/nodejs/node/pull/7390)
* [[`fd9b7b4c5a`](https://github.com/nodejs/node/commit/fd9b7b4c5a)] - **doc**: add CTC meeting minutes 2016-07-06 (Josh Gavant) [#7570](https://github.com/nodejs/node/pull/7570)
* [[`4616261110`](https://github.com/nodejs/node/commit/4616261110)] - **doc**: add CTC meeting minutes 2016-06-29 (Josh Gavant) [#7571](https://github.com/nodejs/node/pull/7571)
* [[`bb90867339`](https://github.com/nodejs/node/commit/bb90867339)] - **doc**: add CTC meeting minutes 2016-07-27 (William Kapke) [#7900](https://github.com/nodejs/node/pull/7900)
* [[`7d0c1bf781`](https://github.com/nodejs/node/commit/7d0c1bf781)] - **doc**: fix path markdown formatting (Joey Cozza) [#7817](https://github.com/nodejs/node/pull/7817)
* [[`04ec64aacc`](https://github.com/nodejs/node/commit/04ec64aacc)] - **doc**: add missing semicolon (Ravindra barthwal) [#7915](https://github.com/nodejs/node/pull/7915)
* [[`8d8d70d826`](https://github.com/nodejs/node/commit/8d8d70d826)] - **doc**: fill in missing V8 version (Timothy Gu) [#7878](https://github.com/nodejs/node/pull/7878)
* [[`6ce9c80ccb`](https://github.com/nodejs/node/commit/6ce9c80ccb)] - **doc**: remove extra spaces and concats in examples (Joe Esposito) [#7885](https://github.com/nodejs/node/pull/7885)
* [[`23b6468667`](https://github.com/nodejs/node/commit/23b6468667)] - **doc**: add information about CTC quorum rules (Rich Trott) [#7813](https://github.com/nodejs/node/pull/7813)
* [[`0645c3d0c4`](https://github.com/nodejs/node/commit/0645c3d0c4)] - **doc**: align breakEvalOnSigint - repl option (Prince J Wesley) [#7849](https://github.com/nodejs/node/pull/7849)
* [[`14a0c3181c`](https://github.com/nodejs/node/commit/14a0c3181c)] - **doc**: remove platform assumption from CONTRIBUTING (Bethany N Griggs) [#7783](https://github.com/nodejs/node/pull/7783)
* [[`5c4b938665`](https://github.com/nodejs/node/commit/5c4b938665)] - **doc**: minor typo fixes in stream docs (Alex Perkins) [#7763](https://github.com/nodejs/node/pull/7763)
* [[`57fb0d2ee2`](https://github.com/nodejs/node/commit/57fb0d2ee2)] - **doc**: add/fix version metadata for Buffer methods (Brian White) [#7784](https://github.com/nodejs/node/pull/7784)
* [[`49a669bcda`](https://github.com/nodejs/node/commit/49a669bcda)] - **doc**: improve function parameter descriptions (Brian White) [#7784](https://github.com/nodejs/node/pull/7784)
* [[`bdc8690610`](https://github.com/nodejs/node/commit/bdc8690610)] - **doc**: add missing properties in Buffer docs (Brian White) [#7784](https://github.com/nodejs/node/pull/7784)
* [[`a8e7c7f2bf`](https://github.com/nodejs/node/commit/a8e7c7f2bf)] - **doc**: improve wording and style of Buffer docs (Brian White) [#7784](https://github.com/nodejs/node/pull/7784)
* [[`9a4a00bcdb`](https://github.com/nodejs/node/commit/9a4a00bcdb)] - **doc**: improve links in Buffer docs (Brian White) [#7784](https://github.com/nodejs/node/pull/7784)
* [[`0103d9dcea`](https://github.com/nodejs/node/commit/0103d9dcea)] - **doc**: reorganize Buffer link references (Brian White) [#7784](https://github.com/nodejs/node/pull/7784)
* [[`17ae49a055`](https://github.com/nodejs/node/commit/17ae49a055)] - **doc**: improve Buffer code examples (Brian White) [#7784](https://github.com/nodejs/node/pull/7784)
* [[`0ffeddb5b4`](https://github.com/nodejs/node/commit/0ffeddb5b4)] - **doc**: various documentation formatting fixes (Сковорода Никита Андреевич) [#7637](https://github.com/nodejs/node/pull/7637)
* [[`1fa9330ac6`](https://github.com/nodejs/node/commit/1fa9330ac6)] - **doc**: add princejwesley to collaborators (Prince J Wesley) [#7877](https://github.com/nodejs/node/pull/7877)
* [[`715ac62670`](https://github.com/nodejs/node/commit/715ac62670)] - **doc**: clarify that the node.js irc channel is not under tsc oversight (James M Snell) [#7810](https://github.com/nodejs/node/pull/7810)
* [[`edb877da65`](https://github.com/nodejs/node/commit/edb877da65)] - **doc**: fix `added:` date for `NODE_REPL_HISTORY` (Anna Henningsen) [#7775](https://github.com/nodejs/node/pull/7775)
* [[`27f92efaee`](https://github.com/nodejs/node/commit/27f92efaee)] - **doctool**: improve the title of pages in doc (yorkie) [#7939](https://github.com/nodejs/node/pull/7939)
* [[`18a3064937`](https://github.com/nodejs/node/commit/18a3064937)] - **fs**: restore JS implementation of realpath (Bartosz Sosnowski) [#7899](https://github.com/nodejs/node/pull/7899)
* [[`0bb9d21f0e`](https://github.com/nodejs/node/commit/0bb9d21f0e)] - **(SEMVER-MINOR)** **fs**: add bytesRead to ReadStream (Linus Unnebäck) [#7942](https://github.com/nodejs/node/pull/7942)
* [[`db3a7e83eb`](https://github.com/nodejs/node/commit/db3a7e83eb)] - **http**: specify \_implicitHeader in OutgoingMessage (yorkie) [#7949](https://github.com/nodejs/node/pull/7949)
* [[`b75ca50c90`](https://github.com/nodejs/node/commit/b75ca50c90)] - **inspector**: Do not crash if the port is n/a (Eugene Ostroukhov) [#7874](https://github.com/nodejs/node/pull/7874)
* [[`7dc66f82e3`](https://github.com/nodejs/node/commit/7dc66f82e3)] - **lib**: remove double check of string type (Franziska Hinkelmann) [#7985](https://github.com/nodejs/node/pull/7985)
* [[`5cc4b0ed15`](https://github.com/nodejs/node/commit/5cc4b0ed15)] - **meta**: clarify process for breaking changes (Rich Trott) [#7955](https://github.com/nodejs/node/pull/7955)
* [[`79ecfb5183`](https://github.com/nodejs/node/commit/79ecfb5183)] - **meta**: include a minimal CTC removal policy (Rich Trott) [#7720](https://github.com/nodejs/node/pull/7720)
* [[`376d73b3b9`](https://github.com/nodejs/node/commit/376d73b3b9)] - **meta**: provide example activities (Rich Trott) [#7744](https://github.com/nodejs/node/pull/7744)
* [[`ccbb46378f`](https://github.com/nodejs/node/commit/ccbb46378f)] - **module**: fix node_modules search path in edge case (hefangshi) [#6670](https://github.com/nodejs/node/pull/6670)
* [[`2f32191686`](https://github.com/nodejs/node/commit/2f32191686)] - **(SEMVER-MINOR)** **process**: save original argv\[0\] (Pat Pannuto) [#7696](https://github.com/nodejs/node/pull/7696)
* [[`d9c9e46780`](https://github.com/nodejs/node/commit/d9c9e46780)] - **repl**: disable Ctrl+C support on win32 for now (Anna Henningsen) [#7977](https://github.com/nodejs/node/pull/7977)
* [[`61e57e06a6`](https://github.com/nodejs/node/commit/61e57e06a6)] - **repl**: don't override all internal repl defaults (cjihrig) [#7826](https://github.com/nodejs/node/pull/7826)
* [[`4875aa2aa2`](https://github.com/nodejs/node/commit/4875aa2aa2)] - **(SEMVER-MINOR)** **repl**: Add editor mode support (Prince J Wesley) [#7275](https://github.com/nodejs/node/pull/7275)
* [[`fc3ba2ff4f`](https://github.com/nodejs/node/commit/fc3ba2ff4f)] - **(SEMVER-MINOR)** **repl**: Use displayErrors for SyntaxError (Prince J Wesley) [#7589](https://github.com/nodejs/node/pull/7589)
* [[`b3164ae22e`](https://github.com/nodejs/node/commit/b3164ae22e)] - **(SEMVER-MINOR)** **repl**: add support for custom completions (Diosney Sarmiento) [#7527](https://github.com/nodejs/node/pull/7527)
* [[`980f4da8c4`](https://github.com/nodejs/node/commit/980f4da8c4)] - **repl**: prevent undefined ref in completion (Evan Lucas) [#7718](https://github.com/nodejs/node/pull/7718)
* [[`6e6cf36761`](https://github.com/nodejs/node/commit/6e6cf36761)] - **repl**: default useGlobal to true (cjihrig) [#7795](https://github.com/nodejs/node/pull/7795)
* [[`08e6eeee70`](https://github.com/nodejs/node/commit/08e6eeee70)] - **repl,util**: insert carriage returns in output (JungMinu) [#8028](https://github.com/nodejs/node/pull/8028)
* [[`fb8840cac2`](https://github.com/nodejs/node/commit/fb8840cac2)] - **src**: use RAII for mutexes in node_watchdog.cc (Anna Henningsen) [#7933](https://github.com/nodejs/node/pull/7933)
* [[`780395ffca`](https://github.com/nodejs/node/commit/780395ffca)] - **src**: fix use-after-free in inspector agent (Ben Noordhuis) [#7907](https://github.com/nodejs/node/pull/7907)
* [[`9d45569ed4`](https://github.com/nodejs/node/commit/9d45569ed4)] - **src**: avoid manual memory management in inspector (Ben Noordhuis) [#7906](https://github.com/nodejs/node/pull/7906)
* [[`a20336e708`](https://github.com/nodejs/node/commit/a20336e708)] - **src**: remove unused using decls (Haojian Wu) [#7990](https://github.com/nodejs/node/pull/7990)
* [[`317ae96c33`](https://github.com/nodejs/node/commit/317ae96c33)] - **src**: make EnvDelete behave like the delete operator (Franziska Hinkelmann) [#7975](https://github.com/nodejs/node/pull/7975)
* [[`1ab796fa96`](https://github.com/nodejs/node/commit/1ab796fa96)] - **src**: do not copy on failing setProperty() (Franziska Hinkelmann) [#7908](https://github.com/nodejs/node/pull/7908)
* [[`cf65a7ce9e`](https://github.com/nodejs/node/commit/cf65a7ce9e)] - **src**: unifying PipeConnectWrap and TCPConnectWrap (Daniel Bevenius) [#7501](https://github.com/nodejs/node/pull/7501)
* [[`63c62cce35`](https://github.com/nodejs/node/commit/63c62cce35)] - **src**: Only use TR1 type_traits on OSX<10.9 (Ehsan Akhgari) [#7778](https://github.com/nodejs/node/pull/7778)
* [[`d7143095cb`](https://github.com/nodejs/node/commit/d7143095cb)] - **src**: fix build on CentOS (Rich Trott) [#7873](https://github.com/nodejs/node/pull/7873)
* [[`303f4102d3`](https://github.com/nodejs/node/commit/303f4102d3)] - **src**: pull OnConnection from pipe_wrap and tcp_wrap (Daniel Bevenius) [#7547](https://github.com/nodejs/node/pull/7547)
* [[`c967af8c07`](https://github.com/nodejs/node/commit/c967af8c07)] - **src**: suppress coverity message (cjihrig) [#7587](https://github.com/nodejs/node/pull/7587)
* [[`f3e5b39696`](https://github.com/nodejs/node/commit/f3e5b39696)] - **src**: guard against overflow in ParseArrayIndex() (Ben Noordhuis) [#7497](https://github.com/nodejs/node/pull/7497)
* [[`c730a5d026`](https://github.com/nodejs/node/commit/c730a5d026)] - **src**: move ParseArrayIndex() to src/node_buffer.cc (Ben Noordhuis) [#7497](https://github.com/nodejs/node/pull/7497)
* [[`da9bd2fc48`](https://github.com/nodejs/node/commit/da9bd2fc48)] - **src**: alias BINARY to LATIN1 (Ben Noordhuis) [#7284](https://github.com/nodejs/node/pull/7284)
* [[`7ba0f860a6`](https://github.com/nodejs/node/commit/7ba0f860a6)] - **src**: fix erroneous fallthrough in ParseEncoding() (Ben Noordhuis) [#7262](https://github.com/nodejs/node/pull/7262)
* [[`a059aea9a2`](https://github.com/nodejs/node/commit/a059aea9a2)] - **src**: remove final trace of raw encoding (Trevor Norris) [#7111](https://github.com/nodejs/node/pull/7111)
* [[`2db26cb165`](https://github.com/nodejs/node/commit/2db26cb165)] - **test**: add test for debug usage message (Rich Trott) [#8061](https://github.com/nodejs/node/pull/8061)
* [[`2e435998eb`](https://github.com/nodejs/node/commit/2e435998eb)] - **test**: mark test failing on AIX as flaky (Michael Dawson) [#8065](https://github.com/nodejs/node/pull/8065)
* [[`554b0f9d91`](https://github.com/nodejs/node/commit/554b0f9d91)] - **test**: fix failing inspector cctest (Eugene Ostroukhov) [#8019](https://github.com/nodejs/node/pull/8019)
* [[`c565c17636`](https://github.com/nodejs/node/commit/c565c17636)] - **test**: fix memory leaks in inspector tests (Ben Noordhuis) [#7906](https://github.com/nodejs/node/pull/7906)
* [[`5d68e4ba9b`](https://github.com/nodejs/node/commit/5d68e4ba9b)] - **test**: console constructor missing new keyword (Rich Trott) [#8003](https://github.com/nodejs/node/pull/8003)
* [[`9735accd3e`](https://github.com/nodejs/node/commit/9735accd3e)] - **test**: allow globals to be whitelisted (cjihrig) [#7826](https://github.com/nodejs/node/pull/7826)
* [[`a385277eb5`](https://github.com/nodejs/node/commit/a385277eb5)] - **test**: fix flaky test-vm-sigint-existing-handler (Anna Henningsen) [#7982](https://github.com/nodejs/node/pull/7982)
* [[`b5beae2529`](https://github.com/nodejs/node/commit/b5beae2529)] - **test**: remove internal headers from addons (Gibson Fahnestock) [#7947](https://github.com/nodejs/node/pull/7947)
* [[`02b12fe880`](https://github.com/nodejs/node/commit/02b12fe880)] - **test**: improve chained property readability (Rich Trott) [#7920](https://github.com/nodejs/node/pull/7920)
* [[`d94063a22b`](https://github.com/nodejs/node/commit/d94063a22b)] - **test**: fix test-vm-sigint flakiness (Santiago Gimeno) [#7854](https://github.com/nodejs/node/pull/7854)
* [[`facd7dade1`](https://github.com/nodejs/node/commit/facd7dade1)] - **test**: don't hard code deprecation count (Prince J Wesley) [#7927](https://github.com/nodejs/node/pull/7927)
* [[`4aee970d92`](https://github.com/nodejs/node/commit/4aee970d92)] - **test**: decrease inconsistency in the common.js (Vse Mozhet Byt) [#7758](https://github.com/nodejs/node/pull/7758)
* [[`10f0c94c35`](https://github.com/nodejs/node/commit/10f0c94c35)] - **test**: fix flaky test-tls-wrap-timeout (Rich Trott) [#7857](https://github.com/nodejs/node/pull/7857)
* [[`ccfa6bf4d4`](https://github.com/nodejs/node/commit/ccfa6bf4d4)] - **test**: speed up test-net-reconnect-error (Rich Trott) [#7886](https://github.com/nodejs/node/pull/7886)
* [[`577adc74cd`](https://github.com/nodejs/node/commit/577adc74cd)] - **test**: ensure stream preprocessing order (Vse Mozhet Byt) [#7741](https://github.com/nodejs/node/pull/7741)
* [[`8f51e36898`](https://github.com/nodejs/node/commit/8f51e36898)] - **test**: use common platform helpers everywhere (Santiago Gimeno) [#7845](https://github.com/nodejs/node/pull/7845)
* [[`2f45941807`](https://github.com/nodejs/node/commit/2f45941807)] - **test**: handle IPv6 localhost issues within tests (Rich Trott) [#7766](https://github.com/nodejs/node/pull/7766)
* [[`e56db1477c`](https://github.com/nodejs/node/commit/e56db1477c)] - **test**: fix flaky test-*-connect-address-family (Rich Trott) [#7605](https://github.com/nodejs/node/pull/7605)
* [[`1ab6df6b04`](https://github.com/nodejs/node/commit/1ab6df6b04)] - **test**: make import common as the first line (Sakthipriyan Vairamani) [#7786](https://github.com/nodejs/node/pull/7786)
* [[`0daceffd38`](https://github.com/nodejs/node/commit/0daceffd38)] - **test,assert**: add deepEqual/deepStrictEqual tests for typed arrays (Feross Aboukhadijeh) [#8002](https://github.com/nodejs/node/pull/8002)
* [[`4416ffab8a`](https://github.com/nodejs/node/commit/4416ffab8a)] - **test,util**: fix flaky test-util-sigint-watchdog (Anna Henningsen) [#7933](https://github.com/nodejs/node/pull/7933)
* [[`4535149794`](https://github.com/nodejs/node/commit/4535149794)] - **timers**: remove unused repeat param in timer_wrap (Jan Schär) [#7994](https://github.com/nodejs/node/pull/7994)
* [[`381aef8145`](https://github.com/nodejs/node/commit/381aef8145)] - **timers**: fix cleanup of nested same-timeout timers (Erin Spiceland) [#7827](https://github.com/nodejs/node/pull/7827)
* [[`e611c293bb`](https://github.com/nodejs/node/commit/e611c293bb)] - **tools**: enable rest-spread-spacing (Rich Trott) [#8073](https://github.com/nodejs/node/pull/8073)
* [[`7eb0e7a479`](https://github.com/nodejs/node/commit/7eb0e7a479)] - **tools**: favor === over == in license2rtf.js (Rich Trott)
* [[`583a2515da`](https://github.com/nodejs/node/commit/583a2515da)] - **tools**: update license-builder.sh for v8_inspector (Ali Ijaz Sheikh) [#7796](https://github.com/nodejs/node/pull/7796)
* [[`97934f99bb`](https://github.com/nodejs/node/commit/97934f99bb)] - **tools**: enable linting for chained properties (Rich Trott) [#7999](https://github.com/nodejs/node/pull/7999)
* [[`60ff991c09`](https://github.com/nodejs/node/commit/60ff991c09)] - **tools**: update to ESLint 3.2.2 (Rich Trott) [#7999](https://github.com/nodejs/node/pull/7999)
* [[`d37a17ec5f`](https://github.com/nodejs/node/commit/d37a17ec5f)] - **tools**: add remark-lint configuration in .remarkrc (Сковорода Никита Андреевич) [#7729](https://github.com/nodejs/node/pull/7729)
* [[`cb16e97e9f`](https://github.com/nodejs/node/commit/cb16e97e9f)] - **tools**: add .vscode folder to .gitignore (Josh Gavant) [#7967](https://github.com/nodejs/node/pull/7967)
* [[`fecf611ca8`](https://github.com/nodejs/node/commit/fecf611ca8)] - **tools,test**: show signal code when test crashes (Santiago Gimeno) [#7859](https://github.com/nodejs/node/pull/7859)
* [[`2f20910e24`](https://github.com/nodejs/node/commit/2f20910e24)] - **tty**: set the handle to blocking mode (Jeremiah Senkpiel) [#6816](https://github.com/nodejs/node/pull/6816)
* [[`cfec3ae5fd`](https://github.com/nodejs/node/commit/cfec3ae5fd)] - **(SEMVER-MINOR)** **util**: add inspect.defaultOptions (Roman Reiss) [#8013](https://github.com/nodejs/node/pull/8013)
* [[`295d1ea016`](https://github.com/nodejs/node/commit/295d1ea016)] - **util**: support classes in util.deprecate() (vladimir) [#7690](https://github.com/nodejs/node/pull/7690)
* [[`0a07201ca1`](https://github.com/nodejs/node/commit/0a07201ca1)] - **util**: fix formatting of objects with SIMD enabled (Anna Henningsen) [#7864](https://github.com/nodejs/node/pull/7864)
* [[`f1c50a8c5e`](https://github.com/nodejs/node/commit/f1c50a8c5e)] - **win,msi**: fix inclusion of translations (João Reis) [#7798](https://github.com/nodejs/node/pull/7798)
* [[`dbbcb9dbd9`](https://github.com/nodejs/node/commit/dbbcb9dbd9)] - **win,msi**: Added Italian translation (Matteo Collina) [#4647](https://github.com/nodejs/node/pull/4647)
* [[`909254c901`](https://github.com/nodejs/node/commit/909254c901)] - **zlib**: remove unneeded property (Jan Schär) [#7987](https://github.com/nodejs/node/pull/7987)

<a id="6.3.1"></a>
## 2016-07-21, Version 6.3.1 (Current), @evanlucas

### Notable changes

* **buffer**:
  * Improve performance of Buffer.from(str, 'hex') and Buffer#write(str, 'hex'). (Christopher Jeffrey) [#7602](https://github.com/nodejs/node/pull/7602)
  * Fix creating from zero-length ArrayBuffer. (Ingvar Stepanyan) [#7176](https://github.com/nodejs/node/pull/7176)
* **deps**:
  * Upgrade to V8 5.0.71.57. (Ben Noordhuis) [#7531](https://github.com/nodejs/node/pull/7531)
  * Backport V8 instanceof bugfix (Franziska Hinkelmann) [#7638](https://github.com/nodejs/node/pull/7638)
* **repl**: Fix issue with function redeclaration. (Prince J Wesley) [#7794](https://github.com/nodejs/node/pull/7794)
* **util**: Fix inspecting of boxed symbols. (Anna Henningsen) [#7641](https://github.com/nodejs/node/pull/7641)

### Commits

* [[`3747d910ec`](https://github.com/nodejs/node/commit/3747d910ec)] - **benchmark**: remove unused variables (Rich Trott) [#7600](https://github.com/nodejs/node/pull/7600)
* [[`41582722c8`](https://github.com/nodejs/node/commit/41582722c8)] - **buffer**: optimize hex_decode (Christopher Jeffrey) [#7602](https://github.com/nodejs/node/pull/7602)
* [[`4a3300e66b`](https://github.com/nodejs/node/commit/4a3300e66b)] - **buffer**: fix creating from zero-length ArrayBuffer (Ingvar Stepanyan) [#7176](https://github.com/nodejs/node/pull/7176)
* [[`71f84b5e6c`](https://github.com/nodejs/node/commit/71f84b5e6c)] - **build**: add conflict marker check during CI lint (Brian White) [#7625](https://github.com/nodejs/node/pull/7625)
* [[`4480b14fda`](https://github.com/nodejs/node/commit/4480b14fda)] - **build**: use BUILDTYPE when building V8 in Makefile (Michaël Zasso) [#7482](https://github.com/nodejs/node/pull/7482)
* [[`94a486a388`](https://github.com/nodejs/node/commit/94a486a388)] - **build**: add v8 requirement to test-v8* in Makefile (Michaël Zasso) [#7482](https://github.com/nodejs/node/pull/7482)
* [[`e5627278f1`](https://github.com/nodejs/node/commit/e5627278f1)] - **build**: add --enable-d8 configure option (Ben Noordhuis) [#7538](https://github.com/nodejs/node/pull/7538)
* [[`933ff62fa5`](https://github.com/nodejs/node/commit/933ff62fa5)] - **build**: respect --shared-* flags for inspector deps (Сковорода Никита Андреевич) [#7569](https://github.com/nodejs/node/pull/7569)
* [[`9bb1024dc3`](https://github.com/nodejs/node/commit/9bb1024dc3)] - **child_process**: Check stderr before accessing it (Robert Chiras) [#6877](https://github.com/nodejs/node/pull/6877)
* [[`f574bd4cec`](https://github.com/nodejs/node/commit/f574bd4cec)] - **cluster**: remove bind() and self (cjihrig) [#7710](https://github.com/nodejs/node/pull/7710)
* [[`164981af5f`](https://github.com/nodejs/node/commit/164981af5f)] - **deps**: bump V8 patchlevel for instanceof cherry-picks (Franziska Hinkelmann) [#7638](https://github.com/nodejs/node/pull/7638)
* [[`287006149b`](https://github.com/nodejs/node/commit/287006149b)] - **deps**: cherry-pick 5b5d24b for X87 from V8 upstream (Franziska Hinkelmann) [#7638](https://github.com/nodejs/node/pull/7638)
* [[`e5cce7acfe`](https://github.com/nodejs/node/commit/e5cce7acfe)] - **deps**: cherry-pick 3a903c4 for PPC from V8 upstream (Franziska Hinkelmann) [#7638](https://github.com/nodejs/node/pull/7638)
* [[`e23904523f`](https://github.com/nodejs/node/commit/e23904523f)] - **deps**: cherry-pick 2aa070be from V8 upstream (Franziska Hinkelmann) [#7638](https://github.com/nodejs/node/pull/7638)
* [[`d3f0a6a52f`](https://github.com/nodejs/node/commit/d3f0a6a52f)] - **deps**: cherry-pick 1f53e42 from v8 upstream (Ben Noordhuis) [#7612](https://github.com/nodejs/node/pull/7612)
* [[`cf8a4889db`](https://github.com/nodejs/node/commit/cf8a4889db)] - **deps**: v8_inspector no longer depends on wtf (Ali Ijaz Sheikh) [#7751](https://github.com/nodejs/node/pull/7751)
* [[`939cf6ddb2`](https://github.com/nodejs/node/commit/939cf6ddb2)] - **deps**: no /safeseh for ml64.exe (Fedor Indutny) [#7759](https://github.com/nodejs/node/pull/7759)
* [[`abf86adee1`](https://github.com/nodejs/node/commit/abf86adee1)] - **deps**: back-port d721121 from v8 upstream (Ben Noordhuis) [#7633](https://github.com/nodejs/node/pull/7633)
* [[`dbdcded866`](https://github.com/nodejs/node/commit/dbdcded866)] - **deps**: upgrade to V8 5.0.71.54 (Ben Noordhuis) [#7531](https://github.com/nodejs/node/pull/7531)
* [[`4839ef37a9`](https://github.com/nodejs/node/commit/4839ef37a9)] - **doc**: correcting misspelling (Vitaly Tomilov) [#7797](https://github.com/nodejs/node/pull/7797)
* [[`3343d46f2c`](https://github.com/nodejs/node/commit/3343d46f2c)] - **doc**: general improvments to events documentation (Sakthipriyan Vairamani) [#7480](https://github.com/nodejs/node/pull/7480)
* [[`e8a6a223ec`](https://github.com/nodejs/node/commit/e8a6a223ec)] - **doc**: update readme with andrasq as a collaborator (Andras) [#7801](https://github.com/nodejs/node/pull/7801)
* [[`59ed303612`](https://github.com/nodejs/node/commit/59ed303612)] - **doc**: update CTC governance information (Rich Trott) [#7719](https://github.com/nodejs/node/pull/7719)
* [[`4b320adb49`](https://github.com/nodejs/node/commit/4b320adb49)] - **doc**: correct sample output of buf.compare (Hargobind S. Khalsa) [#7777](https://github.com/nodejs/node/pull/7777)
* [[`9847f8459c`](https://github.com/nodejs/node/commit/9847f8459c)] - **doc**: add `added:` information for stream (Italo A. Casas) [#7287](https://github.com/nodejs/node/pull/7287)
* [[`1f003590d6`](https://github.com/nodejs/node/commit/1f003590d6)] - **doc**: fix inconsistencies in code style (saadq) [#7745](https://github.com/nodejs/node/pull/7745)
* [[`9c274e32fd`](https://github.com/nodejs/node/commit/9c274e32fd)] - **doc**: Warn against `uncaughtException` dependency. (Lance Ball) [#6378](https://github.com/nodejs/node/pull/6378)
* [[`fc4df0df6c`](https://github.com/nodejs/node/commit/fc4df0df6c)] - **doc**: fix typo in stream doc (Kevin Donahue) [#7738](https://github.com/nodejs/node/pull/7738)
* [[`2a023bfd00`](https://github.com/nodejs/node/commit/2a023bfd00)] - **doc**: removed old git conflict markers from fs.md (Jaime Hidalgo García) [#7590](https://github.com/nodejs/node/pull/7590)
* [[`1d07d29bfe`](https://github.com/nodejs/node/commit/1d07d29bfe)] - **doc**: fix typo in the CHANGELOG_V6 (vsemozhetbyt) [#7568](https://github.com/nodejs/node/pull/7568)
* [[`f15d2d6dae`](https://github.com/nodejs/node/commit/f15d2d6dae)] - **doc**: fix util.deprecate() example (Evan Lucas) [#7674](https://github.com/nodejs/node/pull/7674)
* [[`58b70d34ee`](https://github.com/nodejs/node/commit/58b70d34ee)] - **doc**: link and highlight Object.assign (Sakthipriyan Vairamani) [#7670](https://github.com/nodejs/node/pull/7670)
* [[`cc7fdf429e`](https://github.com/nodejs/node/commit/cc7fdf429e)] - **doc**: grammar fixes to event loop guide (Ryan Lewis) [#7479](https://github.com/nodejs/node/pull/7479)
* [[`a81ff702cc`](https://github.com/nodejs/node/commit/a81ff702cc)] - **doc**: dns.resolve fix callback argument description (Quentin Headen) [#7532](https://github.com/nodejs/node/pull/7532)
* [[`f0c335c347`](https://github.com/nodejs/node/commit/f0c335c347)] - **doc**: add benchmark who-to-CC info (Rich Trott) [#7604](https://github.com/nodejs/node/pull/7604)
* [[`9e0cba0552`](https://github.com/nodejs/node/commit/9e0cba0552)] - **doc**: added information on how to run the linter. (Diosney Sarmiento) [#7534](https://github.com/nodejs/node/pull/7534)
* [[`e13ee29cbd`](https://github.com/nodejs/node/commit/e13ee29cbd)] - **doc**: delete non-existing zlib constants (Franziska Hinkelmann) [#7520](https://github.com/nodejs/node/pull/7520)
* [[`663b103bc5`](https://github.com/nodejs/node/commit/663b103bc5)] - **doc**: fix minor style issues in http.md (Rich Trott) [#7528](https://github.com/nodejs/node/pull/7528)
* [[`6c4d4596cc`](https://github.com/nodejs/node/commit/6c4d4596cc)] - **doc**: updating REPLACEME tag during release (Gibson Fahnestock) [#7514](https://github.com/nodejs/node/pull/7514)
* [[`b4547340ee`](https://github.com/nodejs/node/commit/b4547340ee)] - **doc**: fix detached child stdio example (cjihrig) [#7540](https://github.com/nodejs/node/pull/7540)
* [[`0f7b4efaaf`](https://github.com/nodejs/node/commit/0f7b4efaaf)] - **doc**: add bartosz sosnowski to colaborators (Bartosz Sosnowski) [#7567](https://github.com/nodejs/node/pull/7567)
* [[`77afeb2ec7`](https://github.com/nodejs/node/commit/77afeb2ec7)] - **doc,dgram**: fix addMembership documentation (Santiago Gimeno) [#7244](https://github.com/nodejs/node/pull/7244)
* [[`11d6f1af59`](https://github.com/nodejs/node/commit/11d6f1af59)] - **fs**: rename event to eventType in fs.watch listener (Claudio Rodriguez) [#7506](https://github.com/nodejs/node/pull/7506)
* [[`989a2a1c92`](https://github.com/nodejs/node/commit/989a2a1c92)] - **inspector**: Unify event queues (Eugene Ostroukhov) [#7271](https://github.com/nodejs/node/pull/7271)
* [[`fc0ed2e8c7`](https://github.com/nodejs/node/commit/fc0ed2e8c7)] - **lib,benchmark,test**: implement consistent braces (Rich Trott) [#7630](https://github.com/nodejs/node/pull/7630)
* [[`80ca0630a6`](https://github.com/nodejs/node/commit/80ca0630a6)] - **net**: export isIPv4, isIPv6 directly from cares (Sakthipriyan Vairamani) [#7481](https://github.com/nodejs/node/pull/7481)
* [[`72fc4ebca2`](https://github.com/nodejs/node/commit/72fc4ebca2)] - **repl**: Mitigate vm #548 function redefinition issue (Prince J Wesley) [#7794](https://github.com/nodejs/node/pull/7794)
* [[`f97aa4be39`](https://github.com/nodejs/node/commit/f97aa4be39)] - **src**: remove unnecessary HandleScopes (Ben Noordhuis) [#7711](https://github.com/nodejs/node/pull/7711)
* [[`78dcf0d641`](https://github.com/nodejs/node/commit/78dcf0d641)] - **src**: fix handle leak in UDPWrap::Instantiate() (Ben Noordhuis) [#7711](https://github.com/nodejs/node/pull/7711)
* [[`dc766e6a6f`](https://github.com/nodejs/node/commit/dc766e6a6f)] - **src**: fix handle leak in BuildStatsObject() (Ben Noordhuis) [#7711](https://github.com/nodejs/node/pull/7711)
* [[`96882e14d1`](https://github.com/nodejs/node/commit/96882e14d1)] - **src**: fix handle leak in Buffer::New() (Ben Noordhuis) [#7711](https://github.com/nodejs/node/pull/7711)
* [[`fbc9ef84b8`](https://github.com/nodejs/node/commit/fbc9ef84b8)] - **src**: disable stdio buffering (Ben Noordhuis) [#7610](https://github.com/nodejs/node/pull/7610)
* [[`44c9a72aad`](https://github.com/nodejs/node/commit/44c9a72aad)] - **test**: add regression test for instanceof (Franziska Hinkelmann) [#7638](https://github.com/nodejs/node/pull/7638)
* [[`2e05e65916`](https://github.com/nodejs/node/commit/2e05e65916)] - **test**: add known issue test for #7788 (cjihrig) [#7793](https://github.com/nodejs/node/pull/7793)
* [[`7fb4794e19`](https://github.com/nodejs/node/commit/7fb4794e19)] - **test**: increase RAM requirement for intensive tests (Rich Trott) [#7772](https://github.com/nodejs/node/pull/7772)
* [[`61542e82c1`](https://github.com/nodejs/node/commit/61542e82c1)] - **test**: ensure callback runs in test-vm-sigint (Rich Trott) [#7768](https://github.com/nodejs/node/pull/7768)
* [[`9e9d499b8b`](https://github.com/nodejs/node/commit/9e9d499b8b)] - **test**: use mustCall() for simple flow tracking (cjihrig) [#7753](https://github.com/nodejs/node/pull/7753)
* [[`83cbf3175c`](https://github.com/nodejs/node/commit/83cbf3175c)] - **test**: avoid usage of mixed IPV6 addresses (Gireesh Punathil) [#7702](https://github.com/nodejs/node/pull/7702)
* [[`39f5d9ca7a`](https://github.com/nodejs/node/commit/39f5d9ca7a)] - **test**: fix flaky test-http-server-consumed-timeout (Rich Trott) [#7717](https://github.com/nodejs/node/pull/7717)
* [[`3ed0204f23`](https://github.com/nodejs/node/commit/3ed0204f23)] - **test**: s/assert.fail/common.fail as appropriate (cjihrig) [#7735](https://github.com/nodejs/node/pull/7735)
* [[`f7651d24d4`](https://github.com/nodejs/node/commit/f7651d24d4)] - **test**: improve error message in test-tick-processor (Rich Trott) [#7693](https://github.com/nodejs/node/pull/7693)
* [[`acb976ac26`](https://github.com/nodejs/node/commit/acb976ac26)] - **test**: cleanup IIFE tests (cjihrig) [#7694](https://github.com/nodejs/node/pull/7694)
* [[`432cb353e1`](https://github.com/nodejs/node/commit/432cb353e1)] - **test**: add common.rootDir (cjihrig) [#7685](https://github.com/nodejs/node/pull/7685)
* [[`9797969ad4`](https://github.com/nodejs/node/commit/9797969ad4)] - **test**: fix old tty tests (Jeremiah Senkpiel) [#7613](https://github.com/nodejs/node/pull/7613)
* [[`37dc7954d8`](https://github.com/nodejs/node/commit/37dc7954d8)] - **test**: move parallel/test-tty-* to pseudo-tty/ (Jeremiah Senkpiel) [#7613](https://github.com/nodejs/node/pull/7613)
* [[`5192bed68c`](https://github.com/nodejs/node/commit/5192bed68c)] - **test**: remove unused var from child-process-fork (Rich Trott) [#7599](https://github.com/nodejs/node/pull/7599)
* [[`e1aedbf671`](https://github.com/nodejs/node/commit/e1aedbf671)] - **test**: remove unused vars from http/https tests (Rich Trott) [#7598](https://github.com/nodejs/node/pull/7598)
* [[`64e2eed662`](https://github.com/nodejs/node/commit/64e2eed662)] - **test**: remove unused var in test-tls-server-verify (Rich Trott) [#7595](https://github.com/nodejs/node/pull/7595)
* [[`8e50413b7e`](https://github.com/nodejs/node/commit/8e50413b7e)] - **test**: fix flaky test-fs-read-buffer-tostring-fail (Rich Trott) [#7575](https://github.com/nodejs/node/pull/7575)
* [[`447a8f26e1`](https://github.com/nodejs/node/commit/447a8f26e1)] - **test**: remove unused var in net-server-try-ports (Rich Trott) [#7597](https://github.com/nodejs/node/pull/7597)
* [[`326006527d`](https://github.com/nodejs/node/commit/326006527d)] - **test**: remove unused var from stream2 test (Rich Trott) [#7596](https://github.com/nodejs/node/pull/7596)
* [[`97167291e7`](https://github.com/nodejs/node/commit/97167291e7)] - **test**: fix flaky test-net-write-slow (Rich Trott) [#7555](https://github.com/nodejs/node/pull/7555)
* [[`657fd7aee9`](https://github.com/nodejs/node/commit/657fd7aee9)] - **test**: skip doctool tests when js-yaml is missing (Anna Henningsen) [#7218](https://github.com/nodejs/node/pull/7218)
* [[`1576730ef3`](https://github.com/nodejs/node/commit/1576730ef3)] - **test,doc**: clarify `buf.indexOf(num)` input range (Anna Henningsen) [#7611](https://github.com/nodejs/node/pull/7611)
* [[`49a6ea1b73`](https://github.com/nodejs/node/commit/49a6ea1b73)] - **timers**: fix processing of nested timers (Jeremy Whitlock) [#3063](https://github.com/nodejs/node/pull/3063)
* [[`5a2ce3633f`](https://github.com/nodejs/node/commit/5a2ce3633f)] - **tools**: consistent .eslintrc formatting (silverwind) [#7691](https://github.com/nodejs/node/pull/7691)
* [[`2a84da5d09`](https://github.com/nodejs/node/commit/2a84da5d09)] - **tools**: increase lint coverage (Rich Trott) [#7647](https://github.com/nodejs/node/pull/7647)
* [[`a82573d480`](https://github.com/nodejs/node/commit/a82573d480)] - **tools**: enforce JS brace style with linting (Rich Trott) [#7630](https://github.com/nodejs/node/pull/7630)
* [[`8efca46e78`](https://github.com/nodejs/node/commit/8efca46e78)] - **tools**: fix broken format string (Sakthipriyan Vairamani) [#7620](https://github.com/nodejs/node/pull/7620)
* [[`2bef583f8a`](https://github.com/nodejs/node/commit/2bef583f8a)] - **tools**: cleanup no-build and build-only options (Sakthipriyan Vairamani) [#7620](https://github.com/nodejs/node/pull/7620)
* [[`df697c486e`](https://github.com/nodejs/node/commit/df697c486e)] - **tools**: update ESLint, fix unused vars bug (Rich Trott) [#7601](https://github.com/nodejs/node/pull/7601)
* [[`1a360d63db`](https://github.com/nodejs/node/commit/1a360d63db)] - **tools**: remove unused variable (Rich Trott) [#7594](https://github.com/nodejs/node/pull/7594)
* [[`fa99dadda4`](https://github.com/nodejs/node/commit/fa99dadda4)] - **tools**: remove unnecessary imports and assignments (Sakthipriyan Vairamani) [#7483](https://github.com/nodejs/node/pull/7483)
* [[`0858e620e9`](https://github.com/nodejs/node/commit/0858e620e9)] - **util**: inspect boxed symbols like other primitives (Anna Henningsen) [#7641](https://github.com/nodejs/node/pull/7641)

<a id="6.3.0"></a>
## 2016-07-06, Version 6.3.0 (Current), @Fishrock123

### Notable changes

* **buffer**: Added `buffer.swap64()` to complement `swap16()` & `swap32()`. (Zach Bjornson) [#7157](https://github.com/nodejs/node/pull/7157)
* **build**: New `configure` options have been added for building Node.js as a shared library. (Stefan Budeanu) [#6994](https://github.com/nodejs/node/pull/6994)
  * The options are: `--shared`, `--without-v8-platform` & `--without-bundled-v8`.
* **crypto**: Root certificates have been updated. (Ben Noordhuis) [#7363](https://github.com/nodejs/node/pull/7363)
* **debugger**: The server address is now configurable via `--debug=<address>:<port>`. (Ben Noordhuis) [#3316](https://github.com/nodejs/node/pull/3316)
* **npm**: Upgraded npm to v3.10.3 (Kat Marchán) [#7515](https://github.com/nodejs/node/pull/7515) & (Rebecca Turner) [#7410](https://github.com/nodejs/node/pull/7410)
* **readline**: Added the `prompt` option to the readline constructor. (Evan Lucas) [#7125](https://github.com/nodejs/node/pull/7125)
* **repl / vm**: `sigint`/`ctrl+c` will now break out of infinite loops without stopping the Node.js instance. (Anna Henningsen) [#6635](https://github.com/nodejs/node/pull/6635)
* **src**:
  * Added a `node::FreeEnvironment` public C++ API. (Cheng Zhao) [#3098](https://github.com/nodejs/node/pull/3098)
  * Refactored `require('constants')`, constants are now available directly from their respective modules. (James M Snell) [#6534](https://github.com/nodejs/node/pull/6534)
* **stream**: Improved `readable.read()` performance by up to 70%. (Brian White) [#7077](https://github.com/nodejs/node/pull/7077)
* **timers**: `setImmediate()` is now up to 150% faster in some situations. (Andras) [#6436](https://github.com/nodejs/node/pull/6436)
* **util**: Added a `breakLength` option to `util.inspect()` to control how objects are formatted across lines. (cjihrig) [#7499](https://github.com/nodejs/node/pull/7499)
* **v8-inspector**: Experimental support has been added for debugging Node.js over the inspector protocol. (Ali Ijaz Sheikh) [#6792](https://github.com/nodejs/node/pull/6792)
  * **Note: This feature is _experimental_, and it could be altered or removed.**
  * You can try this feature by running Node.js with the `--inspect` flag.

### Commits

* [[`40211e80f2`](https://github.com/nodejs/node/commit/40211e80f2)] - **assert**: remove unneeded arguments special handling (Rich Trott) [#7413](https://github.com/nodejs/node/pull/7413)
* [[`44f0f940c8`](https://github.com/nodejs/node/commit/44f0f940c8)] - **benchmark**: add `setImmediate()` benchmarks (Andras) [#6436](https://github.com/nodejs/node/pull/6436)
* [[`35c70b5668`](https://github.com/nodejs/node/commit/35c70b5668)] - **benchmark**: `util._extend` vs `object.assign` (surya panikkal) [#7255](https://github.com/nodejs/node/pull/7255)
* [[`4014ecbfb4`](https://github.com/nodejs/node/commit/4014ecbfb4)] - **(SEMVER-MINOR)** **buffer**: speed up swap16/32, add swap64 (Zach Bjornson) [#7157](https://github.com/nodejs/node/pull/7157)
* [[`ac8e1bf609`](https://github.com/nodejs/node/commit/ac8e1bf609)] - **buffer**: improve creation performance. (Ingvar Stepanyan) [#7349](https://github.com/nodejs/node/pull/7349)
* [[`5e4113e58d`](https://github.com/nodejs/node/commit/5e4113e58d)] - **build**: Fix compile failure in `backtrace_posix.cc` (Michael Dawson) [#7544](https://github.com/nodejs/node/pull/7544)
* [[`15a32dd42b`](https://github.com/nodejs/node/commit/15a32dd42b)] - **build**: export openssl symbols on windows (Ben Noordhuis) [#6274](https://github.com/nodejs/node/pull/6274)
* [[`b829a4969f`](https://github.com/nodejs/node/commit/b829a4969f)] - **build**: enable big toc for release builds in AIX (Gireesh Punathil) [#7508](https://github.com/nodejs/node/pull/7508)
* [[`9b5be44b01`](https://github.com/nodejs/node/commit/9b5be44b01)] - **build**: split CI rules in Makefile (João Reis) [#7317](https://github.com/nodejs/node/pull/7317)
* [[`1bd6a623a0`](https://github.com/nodejs/node/commit/1bd6a623a0)] - **build**: drop unconditional openssl dep from cctest (Ben Noordhuis) [#7486](https://github.com/nodejs/node/pull/7486)
* [[`8a31b234ee`](https://github.com/nodejs/node/commit/8a31b234ee)] - **build**: remove unused files from `CPPLINT_FILES` (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`91744aaf00`](https://github.com/nodejs/node/commit/91744aaf00)] - **build**: configure `--shared` (Stefan Budeanu) [#6994](https://github.com/nodejs/node/pull/6994)
* [[`2aa06b9fa0`](https://github.com/nodejs/node/commit/2aa06b9fa0)] - **child\_process**: preserve argument type (Rich Trott) [#7391](https://github.com/nodejs/node/pull/7391)
* [[`4a0fb6fcb8`](https://github.com/nodejs/node/commit/4a0fb6fcb8)] - ***Revert*** "**child\_process**: measure buffer length in bytes" (Rich Trott) [#7391](https://github.com/nodejs/node/pull/7391)
* [[`c1bd3fe14c`](https://github.com/nodejs/node/commit/c1bd3fe14c)] - **(SEMVER-MINOR)** **cluster**: work with `v8_inspector` (cjihrig) [#6792](https://github.com/nodejs/node/pull/6792)
* [[`fa9e6f7463`](https://github.com/nodejs/node/commit/fa9e6f7463)] - **crypto**: Allow GCM ciphers to have a longer IV length (Michael Wain) [#6376](https://github.com/nodejs/node/pull/6376)
* [[`ef41c8bd8e`](https://github.com/nodejs/node/commit/ef41c8bd8e)] - **crypto**: update root certificates (Ben Noordhuis) [#7363](https://github.com/nodejs/node/pull/7363)
* [[`2c7804ad9e`](https://github.com/nodejs/node/commit/2c7804ad9e)] - **crypto,tls**: perf improvements for crypto and tls getCiphers (James M Snell) [#7225](https://github.com/nodejs/node/pull/7225)
* [[`4891001d7e`](https://github.com/nodejs/node/commit/4891001d7e)] - **(SEMVER-MINOR)** **debugger**: make listen address configurable (Ben Noordhuis) [#3316](https://github.com/nodejs/node/pull/3316)
* [[`5bb63e13d1`](https://github.com/nodejs/node/commit/5bb63e13d1)] - **deps**: upgrade npm to 3.10.3 (Kat Marchán) [#7515](https://github.com/nodejs/node/pull/7515)
* [[`581e6deeda`](https://github.com/nodejs/node/commit/581e6deeda)] - **deps**: upgrade npm to 3.10.2 (Rebecca Turner) [#7410](https://github.com/nodejs/node/pull/7410)
* [[`12b199369d`](https://github.com/nodejs/node/commit/12b199369d)] - **deps**: update `icu-small` to include punycode datafiles (James M Snell) [#7355](https://github.com/nodejs/node/pull/7355)
* [[`225f3b9f34`](https://github.com/nodejs/node/commit/225f3b9f34)] - **deps**: update `v8_inspector` (Michaël Zasso) [#7385](https://github.com/nodejs/node/pull/7385)
* [[`a4880b5b10`](https://github.com/nodejs/node/commit/a4880b5b10)] - **deps**: `MASM.UseSafeExceptionHandlers` for OpenSSL (Fedor Indutny) [#7427](https://github.com/nodejs/node/pull/7427)
* [[`cbe57479c4`](https://github.com/nodejs/node/commit/cbe57479c4)] - **deps**: switch to upstream `v8_inspector` (Ali Ijaz Sheikh) [#7302](https://github.com/nodejs/node/pull/7302)
* [[`f4777c77eb`](https://github.com/nodejs/node/commit/f4777c77eb)] - **deps**: update `v8_inspector` (Ali Ijaz Sheikh) [#7118](https://github.com/nodejs/node/pull/7118)
* [[`62105288d3`](https://github.com/nodejs/node/commit/62105288d3)] - **(SEMVER-MINOR)** **deps**: import `v8_inspector` (Ali Ijaz Sheikh) [#6792](https://github.com/nodejs/node/pull/6792)
* [[`c544213717`](https://github.com/nodejs/node/commit/c544213717)] - **deps**: backport 7dfb5beeec from V8 upstream (Myles Borins) [#7348](https://github.com/nodejs/node/pull/7348)
* [[`b0da07a788`](https://github.com/nodejs/node/commit/b0da07a788)] - **doc**: add `added:` information for timers (Anna Henningsen) [#7493](https://github.com/nodejs/node/pull/7493)
* [[`63d361b531`](https://github.com/nodejs/node/commit/63d361b531)] - **doc**: fix documentation of process.argv (Tarun Garg) [#7449](https://github.com/nodejs/node/pull/7449)
* [[`45f83e59c4`](https://github.com/nodejs/node/commit/45f83e59c4)] - **doc**: add guide for Node.js Timers (Ryan Lewis) [#6825](https://github.com/nodejs/node/pull/6825)
* [[`7d07a0b68e`](https://github.com/nodejs/node/commit/7d07a0b68e)] - **doc**: improve usage of `zero`/`0` (Rich Trott) [#7466](https://github.com/nodejs/node/pull/7466)
* [[`8d18aed59e`](https://github.com/nodejs/node/commit/8d18aed59e)] - **doc**: fixing minor typo in `AtExit` hooks section (Daniel Bevenius) [#7485](https://github.com/nodejs/node/pull/7485)
* [[`58ae35c34d`](https://github.com/nodejs/node/commit/58ae35c34d)] - **doc**: fix broken refs to `url.parse()` in http docs (Anna Henningsen) [#7392](https://github.com/nodejs/node/pull/7392)
* [[`f269c008f2`](https://github.com/nodejs/node/commit/f269c008f2)] - **doc**: add `added:` information for https (Anna Henningsen) [#7392](https://github.com/nodejs/node/pull/7392)
* [[`1c7b622cfc`](https://github.com/nodejs/node/commit/1c7b622cfc)] - **doc**: add `added:` information for http (Anna Henningsen) [#7392](https://github.com/nodejs/node/pull/7392)
* [[`bc37e6a22d`](https://github.com/nodejs/node/commit/bc37e6a22d)] - **doc**: general improvements to timers.md (James M Snell) [#6937](https://github.com/nodejs/node/pull/6937)
* [[`5f766ad6d0`](https://github.com/nodejs/node/commit/5f766ad6d0)] - **doc**: fix typographic error in process doc (Rich Trott) [#7431](https://github.com/nodejs/node/pull/7431)
* [[`3475591d1c`](https://github.com/nodejs/node/commit/3475591d1c)] - **doc**: fix "sign.verify" typo in crypto doc. (Ruslan Iusupov) [#7411](https://github.com/nodejs/node/pull/7411)
* [[`44bc638cdb`](https://github.com/nodejs/node/commit/44bc638cdb)] - **doc**: clarify `child_process` stdout/stderr types (sartrey) [#7361](https://github.com/nodejs/node/pull/7361)
* [[`efce335e63`](https://github.com/nodejs/node/commit/efce335e63)] - **doc**: add CTC meeting minutes 2016-06-15 (Josh Gavant) [#7320](https://github.com/nodejs/node/pull/7320)
* [[`b725437c81`](https://github.com/nodejs/node/commit/b725437c81)] - **doc**: minor rewording to the GitHub issue/pr templates (Jeremiah Senkpiel) [#7403](https://github.com/nodejs/node/pull/7403)
* [[`4486ba9ee1`](https://github.com/nodejs/node/commit/4486ba9ee1)] - **doc**: add lance to collaborators (Lance Ball) [#7407](https://github.com/nodejs/node/pull/7407)
* [[`09a7c91baa`](https://github.com/nodejs/node/commit/09a7c91baa)] - **doc**: update "who to cc in issues" chart (Jeremiah Senkpiel) [#6694](https://github.com/nodejs/node/pull/6694)
* [[`eed65973d5`](https://github.com/nodejs/node/commit/eed65973d5)] - **doc**: fix link in the stream doc (Italo A. Casas) [#7347](https://github.com/nodejs/node/pull/7347)
* [[`a04cd85667`](https://github.com/nodejs/node/commit/a04cd85667)] - **doc**: fix repl defineCommand example (akki) [#7365](https://github.com/nodejs/node/pull/7365)
* [[`029af2c1f6`](https://github.com/nodejs/node/commit/029af2c1f6)] - **doc**: update build instructions for Windows (João Reis) [#7285](https://github.com/nodejs/node/pull/7285)
* [[`7a0718bdc6`](https://github.com/nodejs/node/commit/7a0718bdc6)] - **doc**: add `added:` information for tls (Italo A. Casas) [#7018](https://github.com/nodejs/node/pull/7018)
* [[`ec515c5d3b`](https://github.com/nodejs/node/commit/ec515c5d3b)] - **doc**: mention http request "aborted" events (Kyle E. Mitchell) [#7270](https://github.com/nodejs/node/pull/7270)
* [[`0f434fee6e`](https://github.com/nodejs/node/commit/0f434fee6e)] - **doc**: add RReverser to collaborators (Ingvar Stepanyan) [#7370](https://github.com/nodejs/node/pull/7370)
* [[`7aa2125fae`](https://github.com/nodejs/node/commit/7aa2125fae)] - **doc**: add argument information for `socket.destroy()` (Rich Trott) [#7238](https://github.com/nodejs/node/pull/7238)
* [[`9e9d7b8fba`](https://github.com/nodejs/node/commit/9e9d7b8fba)] - **doc**: general improvements to os.md copy (James M Snell) [#7124](https://github.com/nodejs/node/pull/7124)
* [[`cd439465cc`](https://github.com/nodejs/node/commit/cd439465cc)] - **doc**: fix typos in the stream doc (vsemozhetbyt) [#7336](https://github.com/nodejs/node/pull/7336)
* [[`dddfed24db`](https://github.com/nodejs/node/commit/dddfed24db)] - **doc**: document `socket.destroyed` (Tushar Mathur) [#6128](https://github.com/nodejs/node/pull/6128)
* [[`cd7c29e471`](https://github.com/nodejs/node/commit/cd7c29e471)] - **doc**: correct `added:` information for fs.access (Richard Lau) [#7299](https://github.com/nodejs/node/pull/7299)
* [[`6aa179b4a6`](https://github.com/nodejs/node/commit/6aa179b4a6)] - **doc**: add `added:` information for repl (Anna Henningsen) [#7256](https://github.com/nodejs/node/pull/7256)
* [[`08a9aa31e1`](https://github.com/nodejs/node/commit/08a9aa31e1)] - **doc**: fix broken link in vm.md (Luigi Pinca) [#7304](https://github.com/nodejs/node/pull/7304)
* [[`12fbac102b`](https://github.com/nodejs/node/commit/12fbac102b)] - **doc**: fix cluster worker `'message'` event (cjihrig) [#7309](https://github.com/nodejs/node/pull/7309)
* [[`1a0ed26883`](https://github.com/nodejs/node/commit/1a0ed26883)] - **doc**: fix events typo (Greyson Parrelli) [#7329](https://github.com/nodejs/node/pull/7329)
* [[`1e7a7be1ad`](https://github.com/nodejs/node/commit/1e7a7be1ad)] - **doc**: clarify `fs.access()` works on directories too. (Lance Ball) [#7321](https://github.com/nodejs/node/pull/7321)
* [[`e7b84007be`](https://github.com/nodejs/node/commit/e7b84007be)] - **http**: replace finish() callback with arrow function (Guy Fraser) [#7378](https://github.com/nodejs/node/pull/7378)
* [[`c4aaf47f4d`](https://github.com/nodejs/node/commit/c4aaf47f4d)] - **inspector**: Do cleanups before notifying callback (Eugene Ostroukhov) [#7450](https://github.com/nodejs/node/pull/7450)
* [[`fe580eb578`](https://github.com/nodejs/node/commit/fe580eb578)] - **inspector**: print warning when used (Evan Lucas) [#7383](https://github.com/nodejs/node/pull/7383)
* [[`8dd48c9251`](https://github.com/nodejs/node/commit/8dd48c9251)] - **inspector**: fix inspector connection cleanup (Eugene Ostroukhov) [#7268](https://github.com/nodejs/node/pull/7268)
* [[`09ecd1fb58`](https://github.com/nodejs/node/commit/09ecd1fb58)] - **inspector**: fix coverity scan errors (Eugene Ostroukhov) [#7324](https://github.com/nodejs/node/pull/7324)
* [[`88b2aa3ce6`](https://github.com/nodejs/node/commit/88b2aa3ce6)] - **inspector**: `process.exit()` should wait for inspector (Eugene Ostroukhov) [#7252](https://github.com/nodejs/node/pull/7252)
* [[`7da8a413f6`](https://github.com/nodejs/node/commit/7da8a413f6)] - **inspector**: reduce implementation in header (Eugene Ostroukhov) [#7228](https://github.com/nodejs/node/pull/7228)
* [[`ec90a7a92e`](https://github.com/nodejs/node/commit/ec90a7a92e)] - **inspector**: change default port (Ali Ijaz Sheikh) [#7212](https://github.com/nodejs/node/pull/7212)
* [[`d0e24923a6`](https://github.com/nodejs/node/commit/d0e24923a6)] - **net**: use icu's punycode implementation (James M Snell) [#7355](https://github.com/nodejs/node/pull/7355)
* [[`fb39025e31`](https://github.com/nodejs/node/commit/fb39025e31)] - **punycode**: update to v2.0.0 (Mathias Bynens) [#7267](https://github.com/nodejs/node/pull/7267)
* [[`6b1fc63dcb`](https://github.com/nodejs/node/commit/6b1fc63dcb)] - **(SEMVER-MINOR)** **readline**: allow passing prompt to constructor (Evan Lucas) [#7125](https://github.com/nodejs/node/pull/7125)
* [[`72d659a000`](https://github.com/nodejs/node/commit/72d659a000)] - **(SEMVER-MINOR)** **readline**: return old status from `_setRawMode()` (Anna Henningsen) [#6635](https://github.com/nodejs/node/pull/6635)
* [[`7a7b8f7e67`](https://github.com/nodejs/node/commit/7a7b8f7e67)] - **repl**: Default `useGlobal` to false in CLI REPL. (Lance Ball) [#5703](https://github.com/nodejs/node/pull/5703)
* [[`c39f6c0204`](https://github.com/nodejs/node/commit/c39f6c0204)] - **repl**: Enable tab completion for global properties (Lance Ball) [#7369](https://github.com/nodejs/node/pull/7369)
* [[`ca95a84bc4`](https://github.com/nodejs/node/commit/ca95a84bc4)] - **repl**: fix tab completion for defined commands (Prince J Wesley) [#7364](https://github.com/nodejs/node/pull/7364)
* [[`da8e510ee0`](https://github.com/nodejs/node/commit/da8e510ee0)] - **(SEMVER-MINOR)** **repl**: break on sigint/ctrl+c (Anna Henningsen) [#6635](https://github.com/nodejs/node/pull/6635)
* [[`3cba8acc15`](https://github.com/nodejs/node/commit/3cba8acc15)] - **src**: remove obsolete `NOLINT` comments (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`57cc4e3071`](https://github.com/nodejs/node/commit/57cc4e3071)] - **src**: print backtrace on failed `CHECK`/`ASSERT` (Ben Noordhuis) [#6734](https://github.com/nodejs/node/pull/6734)
* [[`b8919b1d23`](https://github.com/nodejs/node/commit/b8919b1d23)] - **src**: move `ABORT()` logic into `node::Abort()` (Ben Noordhuis) [#6734](https://github.com/nodejs/node/pull/6734)
* [[`c96d701769`](https://github.com/nodejs/node/commit/c96d701769)] - **src**: print backtrace on abort/unreachable code (Ben Noordhuis) [#6734](https://github.com/nodejs/node/pull/6734)
* [[`6cec90a611`](https://github.com/nodejs/node/commit/6cec90a611)] - **src**: print backtrace on fatal error (Ben Noordhuis) [#6734](https://github.com/nodejs/node/pull/6734)
* [[`8f7baffee4`](https://github.com/nodejs/node/commit/8f7baffee4)] - **src**: fix bad logic in uid/gid checks (Ben Noordhuis) [#7374](https://github.com/nodejs/node/pull/7374)
* [[`6fa560dce9`](https://github.com/nodejs/node/commit/6fa560dce9)] - **src**: fix memory leak in `WriteBuffers()` error path (Ben Noordhuis) [#7374](https://github.com/nodejs/node/pull/7374)
* [[`ce039c3240`](https://github.com/nodejs/node/commit/ce039c3240)] - **src**: fix use-after-return in zlib bindings (Ben Noordhuis) [#7374](https://github.com/nodejs/node/pull/7374)
* [[`2816418c04`](https://github.com/nodejs/node/commit/2816418c04)] - **src**: remove deprecated `HMAC_Init`, use `HMAC_Init_ex` (Ben Noordhuis) [#7374](https://github.com/nodejs/node/pull/7374)
* [[`b7e661b12c`](https://github.com/nodejs/node/commit/b7e661b12c)] - **src**: remove duplicate `HMAC_Init` calls (Ben Noordhuis) [#7374](https://github.com/nodejs/node/pull/7374)
* [[`25bc7fee34`](https://github.com/nodejs/node/commit/25bc7fee34)] - **src**: remove unused `md_` data members (Ben Noordhuis) [#7374](https://github.com/nodejs/node/pull/7374)
* [[`2228a656b0`](https://github.com/nodejs/node/commit/2228a656b0)] - **src**: remove unused data member `write_queue_size_` (Ben Noordhuis) [#7374](https://github.com/nodejs/node/pull/7374)
* [[`9945b4ecd6`](https://github.com/nodejs/node/commit/9945b4ecd6)] - **src**: guard against starting fs watcher twice (Ben Noordhuis) [#7374](https://github.com/nodejs/node/pull/7374)
* [[`3b1c19f90a`](https://github.com/nodejs/node/commit/3b1c19f90a)] - **src**: initialize `encoding_` data member (Ben Noordhuis) [#7374](https://github.com/nodejs/node/pull/7374)
* [[`c795d1ed9b`](https://github.com/nodejs/node/commit/c795d1ed9b)] - **src**: check `uv_async_init()` return value (Ben Noordhuis) [#7374](https://github.com/nodejs/node/pull/7374)
* [[`001aa06bc0`](https://github.com/nodejs/node/commit/001aa06bc0)] - **src**: lint v8abbr.h (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`ca4fb084f6`](https://github.com/nodejs/node/commit/ca4fb084f6)] - **src**: lint `node_lttng_tp.h` (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`da0ebf62c7`](https://github.com/nodejs/node/commit/da0ebf62c7)] - **src**: lint `node_win32_perfctr_provider.cc` (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`3fa643b069`](https://github.com/nodejs/node/commit/3fa643b069)] - **src**: fix whitespace/indent cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`f72259aa89`](https://github.com/nodejs/node/commit/f72259aa89)] - **src**: fix whitespace/blank\_line cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`1b3c1b08a8`](https://github.com/nodejs/node/commit/1b3c1b08a8)] - **src**: fix runtime/references cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`be0c575ab4`](https://github.com/nodejs/node/commit/be0c575ab4)] - **src**: fix runtime/int cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`88c5183147`](https://github.com/nodejs/node/commit/88c5183147)] - **src**: fix runtime/indentation\_namespace warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`1fa6dba8f2`](https://github.com/nodejs/node/commit/1fa6dba8f2)] - **src**: fix readability/nolint cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`43e83576bd`](https://github.com/nodejs/node/commit/43e83576bd)] - **src**: fix readability/namespace cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`5fd158568f`](https://github.com/nodejs/node/commit/5fd158568f)] - **src**: fix readability/inheritance cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`b7e006b489`](https://github.com/nodejs/node/commit/b7e006b489)] - **src**: fix readability/constructors cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`7fe758de85`](https://github.com/nodejs/node/commit/7fe758de85)] - **src**: fix readability/braces cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`6280ccdaaa`](https://github.com/nodejs/node/commit/6280ccdaaa)] - **src**: fix build/header\_guard cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`5dfa234bae`](https://github.com/nodejs/node/commit/5dfa234bae)] - **src**: fix build/c++tr1 cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`84dd526f51`](https://github.com/nodejs/node/commit/84dd526f51)] - **src**: renaming `ares_task` struct to `node_ares_task` (Daniel Bevenius) [#7345](https://github.com/nodejs/node/pull/7345)
* [[`059335180d`](https://github.com/nodejs/node/commit/059335180d)] - **src**: use RAII for mutexes and condition variables (Ben Noordhuis) [#7334](https://github.com/nodejs/node/pull/7334)
* [[`3d69ad1cf3`](https://github.com/nodejs/node/commit/3d69ad1cf3)] - **src**: make Sec-WebSocket-Key check case-insensitive (Myles Borins) [#7248](https://github.com/nodejs/node/pull/7248)
* [[`38d36e3285`](https://github.com/nodejs/node/commit/38d36e3285)] - **src**: fix `--without-inspector` build (Anna Henningsen) [#7258](https://github.com/nodejs/node/pull/7258)
* [[`2fd140b949`](https://github.com/nodejs/node/commit/2fd140b949)] - **src**: fix json payload from inspector (Myles Borins) [#7232](https://github.com/nodejs/node/pull/7232)
* [[`643b33b497`](https://github.com/nodejs/node/commit/643b33b497)] - **src**: add linebreak to inspector message (Nicolas Romer) [#7070](https://github.com/nodejs/node/pull/7070)
* [[`ea2d661447`](https://github.com/nodejs/node/commit/ea2d661447)] - **src**: fix `--without-inspector` build (Anna Henningsen) [#7078](https://github.com/nodejs/node/pull/7078)
* [[`2a8bd35bac`](https://github.com/nodejs/node/commit/2a8bd35bac)] - **(SEMVER-MINOR)** **src**: add `node::FreeEnvironment` public API (Cheng Zhao) [#3098](https://github.com/nodejs/node/pull/3098)
* [[`929b6c29d8`](https://github.com/nodejs/node/commit/929b6c29d8)] - **(SEMVER-MINOR)** **src**: refactor `require('constants')` (James M Snell) [#6534](https://github.com/nodejs/node/pull/6534)
* [[`cd38401724`](https://github.com/nodejs/node/commit/cd38401724)] - **src**: fix Windows segfault with `--eval` (Bryce Simonds) [#6938](https://github.com/nodejs/node/pull/6938)
* [[`6dc0dae830`](https://github.com/nodejs/node/commit/6dc0dae830)] - **src**: rename "node" script to "bootstrap\_node" (Daniel Bevenius) [#7277](https://github.com/nodejs/node/pull/7277)
* [[`7d4f038a78`](https://github.com/nodejs/node/commit/7d4f038a78)] - **(SEMVER-MINOR)** **src,lib**: v8-inspector support (Pavel Feldman) [#6792](https://github.com/nodejs/node/pull/6792)
* [[`e1d6bd9e30`](https://github.com/nodejs/node/commit/e1d6bd9e30)] - **(SEMVER-MINOR)** **stream**: improve `Readable.read()` performance (Brian White) [#7077](https://github.com/nodejs/node/pull/7077)
* [[`962ac37e1f`](https://github.com/nodejs/node/commit/962ac37e1f)] - **string_decoder**: fix bad utf8 character handling (Brian White) [#7310](https://github.com/nodejs/node/pull/7310)
* [[`f6ba5f6380`](https://github.com/nodejs/node/commit/f6ba5f6380)] - **test**: really run addon tests on `make test` (Anna Henningsen) [#7542](https://github.com/nodejs/node/pull/7542)
* [[`c132e9cc24`](https://github.com/nodejs/node/commit/c132e9cc24)] - **test**: listen on and connect to `127.0.0.1` (Ben Noordhuis) [#7524](https://github.com/nodejs/node/pull/7524)
* [[`6da49ac1fd`](https://github.com/nodejs/node/commit/6da49ac1fd)] - **test**: handle SmartOS bug in test-tls-session-cache (Rich Trott) [#7505](https://github.com/nodejs/node/pull/7505)
* [[`b383fdde79`](https://github.com/nodejs/node/commit/b383fdde79)] - **test**: remove `common.PORT` from http tests (Rich Trott) [#7467](https://github.com/nodejs/node/pull/7467)
* [[`658ab3d1e6`](https://github.com/nodejs/node/commit/658ab3d1e6)] - **test**: check types for http request and response (Ben Noordhuis) [#7003](https://github.com/nodejs/node/pull/7003)
* [[`517e71508e`](https://github.com/nodejs/node/commit/517e71508e)] - **test**: add abort test for backtrace validation (cjihrig) [#6734](https://github.com/nodejs/node/pull/6734)
* [[`6de80fcaea`](https://github.com/nodejs/node/commit/6de80fcaea)] - **test**: don't use internal headers in add-on tests (Ben Noordhuis) [#6734](https://github.com/nodejs/node/pull/6734)
* [[`c7ab7a31d7`](https://github.com/nodejs/node/commit/c7ab7a31d7)] - **test**: fix abort/test-abort-uncaught-exception (Ben Noordhuis) [#6734](https://github.com/nodejs/node/pull/6734)
* [[`4b0ab5b308`](https://github.com/nodejs/node/commit/4b0ab5b308)] - **test**: add `testcfg.py` to test/abort/ (Ben Noordhuis) [#6734](https://github.com/nodejs/node/pull/6734)
* [[`365f5207b3`](https://github.com/nodejs/node/commit/365f5207b3)] - **test**: test `isFullWidthCodePoint()` with invalid input (Rich Trott) [#7422](https://github.com/nodejs/node/pull/7422)
* [[`e30f32f003`](https://github.com/nodejs/node/commit/e30f32f003)] - ***Revert*** "**test**: mark test-vm-timeout flaky on windows" (Anna Henningsen) [#7373](https://github.com/nodejs/node/pull/7373)
* [[`457d244170`](https://github.com/nodejs/node/commit/457d244170)] - **test**: fix flaky test-vm-timeout (Anna Henningsen) [#7373](https://github.com/nodejs/node/pull/7373)
* [[`16aff79dee`](https://github.com/nodejs/node/commit/16aff79dee)] - **test**: add test for `exec()` known issue (Rich Trott) [#7375](https://github.com/nodejs/node/pull/7375)
* [[`8f1733c4e7`](https://github.com/nodejs/node/commit/8f1733c4e7)] - **test**: add more `UTF-8` `StringDecoder` tests (Martin von Gagern) [#7310](https://github.com/nodejs/node/pull/7310)
* [[`0bbf2ef6ea`](https://github.com/nodejs/node/commit/0bbf2ef6ea)] - **test**: fix flaky test-fs-watch-encoding on OS X (Rich Trott) [#7356](https://github.com/nodejs/node/pull/7356)
* [[`009858bd0a`](https://github.com/nodejs/node/commit/009858bd0a)] - **test**: remove internet/test-tls-connnect-cnnic (Ben Noordhuis) [#7363](https://github.com/nodejs/node/pull/7363)
* [[`c236a13341`](https://github.com/nodejs/node/commit/c236a13341)] - **test**: mark test-vm-timeout flaky on windows (Rich Trott) [#7359](https://github.com/nodejs/node/pull/7359)
* [[`580e11026e`](https://github.com/nodejs/node/commit/580e11026e)] - **test**: refresh the tmpdir before using (Rich Trott) [#7327](https://github.com/nodejs/node/pull/7327)
* [[`e2bf250a29`](https://github.com/nodejs/node/commit/e2bf250a29)] - **test**: add tests for some `stream.Readable` uses (Anna Henningsen) [#7260](https://github.com/nodejs/node/pull/7260)
* [[`efb7a90fa9`](https://github.com/nodejs/node/commit/efb7a90fa9)] - **timers**: optimize `setImmediate()` (Andras) [#6436](https://github.com/nodejs/node/pull/6436)
* [[`a5d894590d`](https://github.com/nodejs/node/commit/a5d894590d)] - **timers**: optimize linkedlist (Andras) [#6436](https://github.com/nodejs/node/pull/6436)
* [[`77331a7c01`](https://github.com/nodejs/node/commit/77331a7c01)] - **tls**: avoid calling `Buffer.byteLength` multiple times (James M Snell) [#7236](https://github.com/nodejs/node/pull/7236)
* [[`d857e9a3e9`](https://github.com/nodejs/node/commit/d857e9a3e9)] - **tools**: explicit path for V8 test tap output (Myles Borins) [#7460](https://github.com/nodejs/node/pull/7460)
* [[`e727cb5021`](https://github.com/nodejs/node/commit/e727cb5021)] - **tools**: fix `-Wunused-variable` warning (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`9d0641e20d`](https://github.com/nodejs/node/commit/9d0641e20d)] - **tools**: allow cpplint to run outside git repo (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`01b7b9a2bc`](https://github.com/nodejs/node/commit/01b7b9a2bc)] - **tools**: add back `--mode=tap` to cpplint (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`e3662a4386`](https://github.com/nodejs/node/commit/e3662a4386)] - **tools**: disable unwanted cpplint rules again (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`5830ec5d41`](https://github.com/nodejs/node/commit/5830ec5d41)] - **tools**: update cpplint to r456 (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`3eb02b6743`](https://github.com/nodejs/node/commit/3eb02b6743)] - **tools**: output include guards in mk-ca-bundle.pl (Ben Noordhuis) [#7363](https://github.com/nodejs/node/pull/7363)
* [[`32e068a5d0`](https://github.com/nodejs/node/commit/32e068a5d0)] - **tools**: update certdata.txt (Ben Noordhuis) [#7363](https://github.com/nodejs/node/pull/7363)
* [[`bd8c951757`](https://github.com/nodejs/node/commit/bd8c951757)] - **tools**: disable readability/function cpplint rule (Ben Noordhuis) [#7334](https://github.com/nodejs/node/pull/7334)
* [[`3b8914d5ce`](https://github.com/nodejs/node/commit/3b8914d5ce)] - **(SEMVER-MINOR)** **util**: add an option for configuring break length (cjihrig) [#7499](https://github.com/nodejs/node/pull/7499)
* [[`6151544751`](https://github.com/nodejs/node/commit/6151544751)] - **vm**: don't print out arrow message for custom error (Anna Henningsen) [#7398](https://github.com/nodejs/node/pull/7398)
* [[`55b87c0238`](https://github.com/nodejs/node/commit/55b87c0238)] - **vm**: test for abort condition of current invocation (Anna Henningsen) [#7373](https://github.com/nodejs/node/pull/7373)
* [[`d049919e7d`](https://github.com/nodejs/node/commit/d049919e7d)] - **(SEMVER-MINOR)** **vm**: add ability to break on sigint/ctrl+c (Anna Henningsen) [#6635](https://github.com/nodejs/node/pull/6635)

<a id="6.2.2"></a>
## 2016-06-17, Version 6.2.2 (Current), @evanlucas

### Notable changes

* **http**:
  * `req.read(0)` could cause incoming connections to stall and time out under certain conditions. (Fedor Indutny) [#7211](https://github.com/nodejs/node/pull/7211)
  * When freeing the socket to be reused in keep-alive Agent wait for both prefinish and end events. Otherwise the next request may be written before the previous one has finished sending the body, leading to a parser errors. (Fedor Indutny) [#7149](https://github.com/nodejs/node/pull/7149)
* **npm**: upgrade npm to 3.9.5 (Kat Marchán) [#7139](https://github.com/nodejs/node/pull/7139)

### Commits

* [[`d71ede8113`](https://github.com/nodejs/node/commit/d71ede8113)] - **benchmark**: don't convert arguments to numbers (Brian White) [#6570](https://github.com/nodejs/node/pull/6570)
* [[`32f76983e2`](https://github.com/nodejs/node/commit/32f76983e2)] - **benchmark**: increase http token check iterations (Brian White) [#6570](https://github.com/nodejs/node/pull/6570)
* [[`23a495a9a9`](https://github.com/nodejs/node/commit/23a495a9a9)] - **benchmark**: add benchmark for url.format() (Rich Trott) [#7250](https://github.com/nodejs/node/pull/7250)
* [[`27ed7fc56c`](https://github.com/nodejs/node/commit/27ed7fc56c)] - **benchmark**: fix child-process-exec-stdout on win (Bartosz Sosnowski) [#7178](https://github.com/nodejs/node/pull/7178)
* [[`5e5af8b4bb`](https://github.com/nodejs/node/commit/5e5af8b4bb)] - **benchmark**: fix child-process-read on Windows (Bartosz Sosnowski) [#6971](https://github.com/nodejs/node/pull/6971)
* [[`d24e4095bf`](https://github.com/nodejs/node/commit/d24e4095bf)] - **benchmark**: add benchmark for Buffer.concat (Anna Henningsen) [#7054](https://github.com/nodejs/node/pull/7054)
* [[`666b6f9302`](https://github.com/nodejs/node/commit/666b6f9302)] - **build**: add REPLACEME tag for version info in docs (Ben Noordhuis) [#6864](https://github.com/nodejs/node/pull/6864)
* [[`6d3d2d1ae4`](https://github.com/nodejs/node/commit/6d3d2d1ae4)] - **cluster**: don't send messages if no IPC channel (Santiago Gimeno) [#7132](https://github.com/nodejs/node/pull/7132)
* [[`068718c91c`](https://github.com/nodejs/node/commit/068718c91c)] - **debugger**: remove obsolete setTimeout (Rich Trott) [#7154](https://github.com/nodejs/node/pull/7154)
* [[`2961f06f6f`](https://github.com/nodejs/node/commit/2961f06f6f)] - **debugger**: fix --debug-brk interaction with -e (Rich Trott) [#7089](https://github.com/nodejs/node/pull/7089)
* [[`701e699d4f`](https://github.com/nodejs/node/commit/701e699d4f)] - **deps**: upgrade npm to 3.9.5 (Kat Marchán) [#7139](https://github.com/nodejs/node/pull/7139)
* [[`1095ae1ac5`](https://github.com/nodejs/node/commit/1095ae1ac5)] - **doc**: Add CII Best Practices badge to README.md (David A. Wheeler) [#6819](https://github.com/nodejs/node/pull/6819)
* [[`0198987b0d`](https://github.com/nodejs/node/commit/0198987b0d)] - **doc**: add internal link in GOVERNANCE.md (Rich Trott) [#7279](https://github.com/nodejs/node/pull/7279)
* [[`8e14f761bb`](https://github.com/nodejs/node/commit/8e14f761bb)] - **doc**: use `Buffer.byteLength` for Content-Length (kimown) [#7274](https://github.com/nodejs/node/pull/7274)
* [[`5d03bdd94f`](https://github.com/nodejs/node/commit/5d03bdd94f)] - **doc**: add information for IncomingMessage.destroy() (Rich Trott) [#7237](https://github.com/nodejs/node/pull/7237)
* [[`a113734099`](https://github.com/nodejs/node/commit/a113734099)] - **doc**: general improvements to path.md copy (James M Snell) [#7122](https://github.com/nodejs/node/pull/7122)
* [[`b5e44df9a3`](https://github.com/nodejs/node/commit/b5e44df9a3)] - **doc**: make pull request template more concise (Rich Trott) [#7239](https://github.com/nodejs/node/pull/7239)
* [[`40a5974a0e`](https://github.com/nodejs/node/commit/40a5974a0e)] - **doc**: `url.format()` parameter may be a string (Rich Trott) [#7235](https://github.com/nodejs/node/pull/7235)
* [[`a7d813915e`](https://github.com/nodejs/node/commit/a7d813915e)] - **doc**: clarify use of `0` port value (Rich Trott) [#7206](https://github.com/nodejs/node/pull/7206)
* [[`0fc8012b65`](https://github.com/nodejs/node/commit/0fc8012b65)] - **doc**: remove cluster.setupMaster() myth (cjihrig) [#7179](https://github.com/nodejs/node/pull/7179)
* [[`70167fd1d4`](https://github.com/nodejs/node/commit/70167fd1d4)] - **doc**: fix IRC link (Ilkka Myller) [#7210](https://github.com/nodejs/node/pull/7210)
* [[`4f2215fd98`](https://github.com/nodejs/node/commit/4f2215fd98)] - **doc**: fix minor nit introduced in readline.md (James M Snell) [#7198](https://github.com/nodejs/node/pull/7198)
* [[`d31f728e09`](https://github.com/nodejs/node/commit/d31f728e09)] - **doc**: clarify rl.question callback args (James M Snell) [#7022](https://github.com/nodejs/node/pull/7022)
* [[`70f2f357be`](https://github.com/nodejs/node/commit/70f2f357be)] - **doc**: general improvements to readline.md copy (James M Snell) [#7022](https://github.com/nodejs/node/pull/7022)
* [[`c2aba5ba27`](https://github.com/nodejs/node/commit/c2aba5ba27)] - **doc**: consolidate test/lint text in GH PR template (Rich Trott) [#7155](https://github.com/nodejs/node/pull/7155)
* [[`712120112f`](https://github.com/nodejs/node/commit/712120112f)] - **doc**: use consistent typography in streams.md (Rich Trott) [#6986](https://github.com/nodejs/node/pull/6986)
* [[`e2f6f8061b`](https://github.com/nodejs/node/commit/e2f6f8061b)] - **doc**: general improvements to process.md copy (James M Snell) [#7029](https://github.com/nodejs/node/pull/7029)
* [[`84ea6fc57c`](https://github.com/nodejs/node/commit/84ea6fc57c)] - **doc**: general improvements to repl.md copy (James M Snell) [#7002](https://github.com/nodejs/node/pull/7002)
* [[`bfb7e3cc6e`](https://github.com/nodejs/node/commit/bfb7e3cc6e)] - **doc**: add `added:` information for readline (Julian Duque) [#6996](https://github.com/nodejs/node/pull/6996)
* [[`632b411cd0`](https://github.com/nodejs/node/commit/632b411cd0)] - **doc**: improved syntax consistency in console.md (Jonathan Montane) [#7062](https://github.com/nodejs/node/pull/7062)
* [[`826bd99486`](https://github.com/nodejs/node/commit/826bd99486)] - **doc**: specify how to link issues in commit log (Luigi Pinca) [#7161](https://github.com/nodejs/node/pull/7161)
* [[`865644a604`](https://github.com/nodejs/node/commit/865644a604)] - **doc**: general improvements to querystring.md copy (James M Snell) [#7023](https://github.com/nodejs/node/pull/7023)
* [[`dd4c607267`](https://github.com/nodejs/node/commit/dd4c607267)] - **doc**: fix header depth of util.isSymbol (James M Snell) [#7138](https://github.com/nodejs/node/pull/7138)
* [[`5086e5f3ee`](https://github.com/nodejs/node/commit/5086e5f3ee)] - **doc**: general improvements to stream.md copy (James M Snell) [#6947](https://github.com/nodejs/node/pull/6947)
* [[`75d6875034`](https://github.com/nodejs/node/commit/75d6875034)] - **doc**: update licenses (Myles Borins) [#7121](https://github.com/nodejs/node/pull/7121)
* [[`dc8cb93c4f`](https://github.com/nodejs/node/commit/dc8cb93c4f)] - **doc**: add `added:` information for dns (Julian Duque) [#7021](https://github.com/nodejs/node/pull/7021)
* [[`a7c85e6fd5`](https://github.com/nodejs/node/commit/a7c85e6fd5)] - **doc**: add `added:` information for path (Julian Duque) [#6985](https://github.com/nodejs/node/pull/6985)
* [[`026bf17378`](https://github.com/nodejs/node/commit/026bf17378)] - **doc**: add `added` information for net (Italo A. Casas) [#7038](https://github.com/nodejs/node/pull/7038)
* [[`d4a2c82f5f`](https://github.com/nodejs/node/commit/d4a2c82f5f)] - **doc**: general improvements to punycode.md copy (James M Snell) [#7025](https://github.com/nodejs/node/pull/7025)
* [[`51d295efe6`](https://github.com/nodejs/node/commit/51d295efe6)] - **doc**: add links to platform specific mechanisms (Michael Dawson) [#7071](https://github.com/nodejs/node/pull/7071)
* [[`1600966f59`](https://github.com/nodejs/node/commit/1600966f59)] - **fs**: execute mkdtemp's callback with no context (Sakthipriyan Vairamani) [#7068](https://github.com/nodejs/node/pull/7068)
* [[`ad1045c829`](https://github.com/nodejs/node/commit/ad1045c829)] - **http**: fix no dumping after `maybeReadMore` (Fedor Indutny) [#7211](https://github.com/nodejs/node/pull/7211)
* [[`2a462ba1e2`](https://github.com/nodejs/node/commit/2a462ba1e2)] - **http**: optimize checkInvalidHeaderChar() (Brian White) [#6570](https://github.com/nodejs/node/pull/6570)
* [[`4a63be031f`](https://github.com/nodejs/node/commit/4a63be031f)] - **http**: optimize checkIsHttpToken() (Brian White) [#6570](https://github.com/nodejs/node/pull/6570)
* [[`40e49dee82`](https://github.com/nodejs/node/commit/40e49dee82)] - **http**: wait for both prefinish/end to keepalive (Fedor Indutny) [#7149](https://github.com/nodejs/node/pull/7149)
* [[`e8c91e7557`](https://github.com/nodejs/node/commit/e8c91e7557)] - **repl**: refine handling of illegal tokens (Rich Trott) [#7104](https://github.com/nodejs/node/pull/7104)
* [[`cf0928ccb7`](https://github.com/nodejs/node/commit/cf0928ccb7)] - **src**: clean up string_search (Brian White) [#7174](https://github.com/nodejs/node/pull/7174)
* [[`b0225e5926`](https://github.com/nodejs/node/commit/b0225e5926)] - **stream**: ensure awaitDrain is increased once (David Halls) [#7292](https://github.com/nodejs/node/pull/7292)
* [[`9c6b69ec1b`](https://github.com/nodejs/node/commit/9c6b69ec1b)] - **stream**: reset awaitDrain after manual .resume() (Anna Henningsen) [#7160](https://github.com/nodejs/node/pull/7160)
* [[`caa6718a01`](https://github.com/nodejs/node/commit/caa6718a01)] - **test**: fix test-net-* error code check for getaddrinfo(3) (Natanael Copa) [#5099](https://github.com/nodejs/node/pull/5099)
* [[`535c8dd554`](https://github.com/nodejs/node/commit/535c8dd554)] - **test**: add more http token/value checking tests (Brian White) [#6570](https://github.com/nodejs/node/pull/6570)
* [[`257f4e6202`](https://github.com/nodejs/node/commit/257f4e6202)] - **test**: add note about duration_ms in TAP reporter (Rod Vagg) [#7216](https://github.com/nodejs/node/pull/7216)
* [[`798a737f45`](https://github.com/nodejs/node/commit/798a737f45)] - ***Revert*** "**test**: change duration_ms to duration" (Rod Vagg) [#7216](https://github.com/nodejs/node/pull/7216)
* [[`72e4e43b91`](https://github.com/nodejs/node/commit/72e4e43b91)] - **test**: rebuild add-ons when their sources change (Ben Noordhuis) [#7262](https://github.com/nodejs/node/pull/7262)
* [[`eded11705b`](https://github.com/nodejs/node/commit/eded11705b)] - **test**: use random ports where possible (Brian White) [#7045](https://github.com/nodejs/node/pull/7045)
* [[`d54c7c19a6`](https://github.com/nodejs/node/commit/d54c7c19a6)] - **test**: fix spawn on windows (Brian White) [#7049](https://github.com/nodejs/node/pull/7049)
* [[`e873063a3c`](https://github.com/nodejs/node/commit/e873063a3c)] - **test**: enable test-debug-brk-no-arg (Rich Trott) [#7143](https://github.com/nodejs/node/pull/7143)
* [[`d6091c8194`](https://github.com/nodejs/node/commit/d6091c8194)] - **test**: use common.fixturesDir almost everywhere (Bryan English) [#6997](https://github.com/nodejs/node/pull/6997)
* [[`e8b1456d8b`](https://github.com/nodejs/node/commit/e8b1456d8b)] - **test**: change duration_ms to duration (Gibson Fahnestock) [#7133](https://github.com/nodejs/node/pull/7133)
* [[`6ce26c8c8b`](https://github.com/nodejs/node/commit/6ce26c8c8b)] - **test**: add test for uid/gid setting in spawn (Rich Trott) [#7084](https://github.com/nodejs/node/pull/7084)
* [[`40604b54d4`](https://github.com/nodejs/node/commit/40604b54d4)] - **test**: remove disabled eio race test (Rich Trott) [#7083](https://github.com/nodejs/node/pull/7083)
* [[`9545c41cba`](https://github.com/nodejs/node/commit/9545c41cba)] - **tools**: fix license builder to work with icu-small (Myles Borins) [#7119](https://github.com/nodejs/node/pull/7119)
* [[`6562c9fc75`](https://github.com/nodejs/node/commit/6562c9fc75)] - **tools,doc**: add example usage for REPLACEME tag (Anna Henningsen) [#6864](https://github.com/nodejs/node/pull/6864)

<a id="6.2.1"></a>
## 2016-06-02, Version 6.2.1 (Current), @rvagg

### Notable changes

* **buffer**: Ignore negative lengths in calls to `Buffer()` and `Buffer.allocUnsafe()`. This fixes a possible security concern (reported by Feross Aboukhadijeh) where user input is passed unchecked to the Buffer constructor or `allocUnsafe()` as it can expose parts of the memory slab used by other Buffers in the application. Note that negative lengths are not supported by the Buffer API and user input to the constructor should always be sanitised and type-checked. (Anna Henningsen) [#7051](https://github.com/nodejs/node/pull/7051)
* **npm**: Upgrade npm to 3.9.3 (Kat Marchán) [#7030](https://github.com/nodejs/node/pull/7030)
  * [`npm/npm@42d71be`](https://github.com/npm/npm/commit/42d71be2cec674dd9e860ad414f53184f667620d) [npm/npm#12685](https://github.com/npm/npm/pull/12685) When using `npm ls <pkg>` without a semver specifier, `npm ls` would skip any packages in your tree that matched by name, but had a prerelease version in their `package.json`. ([@zkat](https://github.com/zkat))
  * [`npm/npm@f04e05`](https://github.com/npm/npm/commit/df04e05af1f257a1903372e1baf334c0969fbdbd) [npm/npm#10013](https://github.com/npm/npm/issues/10013) `read-package-tree@5.1.4`: Fixes an issue where `npm install` would fail if your `node_modules` was symlinked. ([@iarna](https://github.com/iarna))
  * [`b894413`](https://github.com/npm/npm/commit/b8944139a935680c4a267468bb2d3c3082b5609f) [#12372](https://github.com/npm/npm/issues/12372) Changing a nested dependency in an `npm-shrinkwrap.json` and then running `npm install` would not get up the updated package. This corrects that. ([@misterbyrne](https://github.com/misterbyrne))
  * This release includes `npm@3.9.0`, which is the result of our Windows testing push -- the test suite (should) pass on Windows now. We're working on getting AppVeyor to a place where we can just rely on it like Travis.
* **tty**: Default to blocking mode for stdio on OS X. A bug fix in libuv 1.9.0, introduced in Node.js v6.0.0, exposed problems with Node's use of non-blocking stdio, particularly on OS X which has a small output buffer. This change should fix CLI applications that have been having problems with output since Node.js v6.0.0 on OS X. The core team is continuing to address stdio concerns that exist across supported platforms and progress can be tracked at <https://github.com/nodejs/node/issues/6980>. (Jeremiah Senkpiel) [#6895](https://github.com/nodejs/node/pull/6895)
* **V8**: Upgrade to V8 5.0.71.52. This includes a fix that addresses problems experienced by users of node-inspector since Node.js v6.0.0, see <https://github.com/node-inspector/node-inspector/issues/864> for details. (Michaël Zasso) [#6928](https://github.com/nodejs/node/pull/6928)

### Commits

* [[`99c05a1af0`](https://github.com/nodejs/node/commit/99c05a1af0)] - **async_wrap**: pass uid to JS as double (Trevor Norris) [#7096](https://github.com/nodejs/node/pull/7096)
* [[`371be9cd80`](https://github.com/nodejs/node/commit/371be9cd80)] - **buffer**: ignore negative allocation lengths (Anna Henningsen) [#7051](https://github.com/nodejs/node/pull/7051)
* [[`1bcc226edf`](https://github.com/nodejs/node/commit/1bcc226edf)] - **buffer**: fix dataview-set benchmark (Ingvar Stepanyan) [#6922](https://github.com/nodejs/node/pull/6922)
* [[`98270c6d15`](https://github.com/nodejs/node/commit/98270c6d15)] - **buffer**: fix single digit hex string handling (Justin Sprigg) [#6775](https://github.com/nodejs/node/pull/6775)
* [[`1fece2f8c0`](https://github.com/nodejs/node/commit/1fece2f8c0)] - **build**: re-add --ninja option to configure (Ehsan Akhgari) [#6780](https://github.com/nodejs/node/pull/6780)
* [[`e7b03be191`](https://github.com/nodejs/node/commit/e7b03be191)] - **build**: update build-addons when node-gyp changes (Lance Ball) [#6787](https://github.com/nodejs/node/pull/6787)
* [[`55c0b3e0e5`](https://github.com/nodejs/node/commit/55c0b3e0e5)] - **build**: unbreak configure with python 2.6 (Ben Noordhuis) [#6874](https://github.com/nodejs/node/pull/6874)
* [[`0503681348`](https://github.com/nodejs/node/commit/0503681348)] - **child_process**: measure buffer length in bytes (Rich Trott) [#6764](https://github.com/nodejs/node/pull/6764)
* [[`27d0eb054c`](https://github.com/nodejs/node/commit/27d0eb054c)] - **child_process**: emit IPC messages on next tick (cjihrig) [#6909](https://github.com/nodejs/node/pull/6909)
* [[`b28468e0a7`](https://github.com/nodejs/node/commit/b28468e0a7)] - **child_process**: allow buffer encoding in spawnSync (cjihrig) [#6939](https://github.com/nodejs/node/pull/6939)
* [[`6a62bb0070`](https://github.com/nodejs/node/commit/6a62bb0070)] - **cluster**: expose result of send() (cjihrig) [#6998](https://github.com/nodejs/node/pull/6998)
* [[`2132d349b5`](https://github.com/nodejs/node/commit/2132d349b5)] - **cluster**: rewrite debug ports consistently (cjihrig) [#7050](https://github.com/nodejs/node/pull/7050)
* [[`0bd8f4c4d8`](https://github.com/nodejs/node/commit/0bd8f4c4d8)] - **cluster**: reset handle index on close (Santiago Gimeno) [#6981](https://github.com/nodejs/node/pull/6981)
* [[`93e150f1d6`](https://github.com/nodejs/node/commit/93e150f1d6)] - **cluster**: guard against undefined message handlers (cjihrig) [#6902](https://github.com/nodejs/node/pull/6902)
* [[`28b73428e1`](https://github.com/nodejs/node/commit/28b73428e1)] - **cluster**: close ownerless handles on disconnect() (cjihrig) [#6909](https://github.com/nodejs/node/pull/6909)
* [[`2184e772d2`](https://github.com/nodejs/node/commit/2184e772d2)] - **debugger**: propagate --debug-port= to debuggee (Ben Noordhuis) [#3470](https://github.com/nodejs/node/pull/3470)
* [[`ded02b909f`](https://github.com/nodejs/node/commit/ded02b909f)] - **deps**: upgrade npm to 3.9.3 (Kat Marchán) [#7030](https://github.com/nodejs/node/pull/7030)
* [[`bfd7b24c63`](https://github.com/nodejs/node/commit/bfd7b24c63)] - **deps**: upgrade to V8 5.0.71.52 (Michaël Zasso) [#6928](https://github.com/nodejs/node/pull/6928)
* [[`8e6f8b2fb5`](https://github.com/nodejs/node/commit/8e6f8b2fb5)] - **dgram**: copy the list in send (Matteo Collina) [#6804](https://github.com/nodejs/node/pull/6804)
* [[`588c76cd5c`](https://github.com/nodejs/node/commit/588c76cd5c)] - **dgram,test**: add addMembership/dropMembership tests (Rich Trott) [#6753](https://github.com/nodejs/node/pull/6753)
* [[`e93198e86d`](https://github.com/nodejs/node/commit/e93198e86d)] - **doc**: edit pull request template (Rich Trott) [#7058](https://github.com/nodejs/node/pull/7058)
* [[`1c1256718e`](https://github.com/nodejs/node/commit/1c1256718e)] - **doc**: addresses nits in string_decoder, url, util (Jeremiah Senkpiel) [#7026](https://github.com/nodejs/node/pull/7026)
* [[`14b3ba35fc`](https://github.com/nodejs/node/commit/14b3ba35fc)] - **doc**: improve debugger doc prose (Rich Trott) [#7007](https://github.com/nodejs/node/pull/7007)
* [[`3c2c4c8d5c`](https://github.com/nodejs/node/commit/3c2c4c8d5c)] - **doc**: update labels and CI info in onboarding doc (Rich Trott) [#7006](https://github.com/nodejs/node/pull/7006)
* [[`b5e93c97f8`](https://github.com/nodejs/node/commit/b5e93c97f8)] - **doc**: fix typos in WORKING_GROUPS.md (Joao Andrade) [#7032](https://github.com/nodejs/node/pull/7032)
* [[`f15448681a`](https://github.com/nodejs/node/commit/f15448681a)] - **doc**: buffers are not sent over IPC with a socket (Tim Kuijsten) [#6951](https://github.com/nodejs/node/pull/6951)
* [[`3518ab93b1`](https://github.com/nodejs/node/commit/3518ab93b1)] - **doc**: minor improvements to util.md (Sakthipriyan Vairamani) [#6932](https://github.com/nodejs/node/pull/6932)
* [[`216a3cdcce`](https://github.com/nodejs/node/commit/216a3cdcce)] - **doc**: add `added:` information for vm (Anna Henningsen) [#7011](https://github.com/nodejs/node/pull/7011)
* [[`b30d07845d`](https://github.com/nodejs/node/commit/b30d07845d)] - **doc**: add `added:` information for console (Adrian Estrada) [#6995](https://github.com/nodejs/node/pull/6995)
* [[`72d4692e94`](https://github.com/nodejs/node/commit/72d4692e94)] - **doc**: add info on what's used for fswatch on AIX (Michael Dawson) [#6837](https://github.com/nodejs/node/pull/6837)
* [[`7c38327dee`](https://github.com/nodejs/node/commit/7c38327dee)] - **doc**: update process.hrtime docs to include optional parameter (doug.wade) [#6585](https://github.com/nodejs/node/pull/6585)
* [[`0f17a28a00`](https://github.com/nodejs/node/commit/0f17a28a00)] - **doc**: improve server.listen() documentation prose (Rich Trott) [#7000](https://github.com/nodejs/node/pull/7000)
* [[`3ae9f1469d`](https://github.com/nodejs/node/commit/3ae9f1469d)] - **doc**: improve `server.address()` doc text (Rich Trott) [#7001](https://github.com/nodejs/node/pull/7001)
* [[`ae1bf83b6c`](https://github.com/nodejs/node/commit/ae1bf83b6c)] - **doc**: clarified use of sexual language in the CoC (Bryan Hughes) [#6973](https://github.com/nodejs/node/pull/6973)
* [[`3909209e7a`](https://github.com/nodejs/node/commit/3909209e7a)] - **doc**: general improvements to tty.md (James M Snell) [#6931](https://github.com/nodejs/node/pull/6931)
* [[`bc2efe22f6`](https://github.com/nodejs/node/commit/bc2efe22f6)] - **doc**: add `added: ` data for cli.md (Rich Trott) [#6960](https://github.com/nodejs/node/pull/6960)
* [[`856638d0b7`](https://github.com/nodejs/node/commit/856638d0b7)] - **doc**: add `added:` information for child_process (Anna Henningsen) [#6927](https://github.com/nodejs/node/pull/6927)
* [[`a5e3eddfbf`](https://github.com/nodejs/node/commit/a5e3eddfbf)] - **doc**: general improvements to url.md copy (James M Snell) [#6904](https://github.com/nodejs/node/pull/6904)
* [[`b7ca0a2653`](https://github.com/nodejs/node/commit/b7ca0a2653)] - **doc**: add yorkie to collaborators (Yazhong Liu) [#7004](https://github.com/nodejs/node/pull/7004)
* [[`a9b90a6952`](https://github.com/nodejs/node/commit/a9b90a6952)] - **doc**: general improvements to tls.md copy (James M Snell) [#6933](https://github.com/nodejs/node/pull/6933)
* [[`5990a7fe91`](https://github.com/nodejs/node/commit/5990a7fe91)] - **doc**: fix broken references (Anna Henningsen) [#6941](https://github.com/nodejs/node/pull/6941)
* [[`98e497bdad`](https://github.com/nodejs/node/commit/98e497bdad)] - **doc**: fix broken references in changelogs (Anna Henningsen) [#6942](https://github.com/nodejs/node/pull/6942)
* [[`f3ae42168a`](https://github.com/nodejs/node/commit/f3ae42168a)] - **doc**: general improvements to string_decoder.md copy (James M Snell) [#6940](https://github.com/nodejs/node/pull/6940)
* [[`8f623a3c75`](https://github.com/nodejs/node/commit/8f623a3c75)] - **doc**: add firedfox to collaborators (Daniel Wang) [#6961](https://github.com/nodejs/node/pull/6961)
* [[`145a6b946a`](https://github.com/nodejs/node/commit/145a6b946a)] - **doc**: add bmeck to collaborators (Bradley Meck) [#6962](https://github.com/nodejs/node/pull/6962)
* [[`95f8d59e0d`](https://github.com/nodejs/node/commit/95f8d59e0d)] - **doc**: remove "\" within backticks (Rod Machen) [#6952](https://github.com/nodejs/node/pull/6952)
* [[`ee1865dd2f`](https://github.com/nodejs/node/commit/ee1865dd2f)] - **doc**: clarify buffer class (Steve Mao) [#6914](https://github.com/nodejs/node/pull/6914)
* [[`db3d2a7b96`](https://github.com/nodejs/node/commit/db3d2a7b96)] - **doc**: fix typos in timers topic to aid readability (Kevin Donahue) [#6916](https://github.com/nodejs/node/pull/6916)
* [[`0f0003fc54`](https://github.com/nodejs/node/commit/0f0003fc54)] - **doc**: add jhamhader to collaborators (Yuval Brik) [#6946](https://github.com/nodejs/node/pull/6946)
* [[`f6558ec537`](https://github.com/nodejs/node/commit/f6558ec537)] - **doc**: add @othiym23 to list of collaborators (Forrest L Norvell) [#6945](https://github.com/nodejs/node/pull/6945)
* [[`9fa1b19eda`](https://github.com/nodejs/node/commit/9fa1b19eda)] - **doc**: reference list of language-specific globals (Anna Henningsen) [#6900](https://github.com/nodejs/node/pull/6900)
* [[`15f6224418`](https://github.com/nodejs/node/commit/15f6224418)] - **doc**: make doc-only -> fallback to user binary (Robert Jefe Lindstaedt) [#6906](https://github.com/nodejs/node/pull/6906)
* [[`a320a019f1`](https://github.com/nodejs/node/commit/a320a019f1)] - **doc**: general improvements to util.md (James M Snell) [#6897](https://github.com/nodejs/node/pull/6897)
* [[`527a8a4844`](https://github.com/nodejs/node/commit/527a8a4844)] - **doc**: add `added:` information for zlib (Anna Henningsen) [#6840](https://github.com/nodejs/node/pull/6840)
* [[`cb8de85100`](https://github.com/nodejs/node/commit/cb8de85100)] - **doc**: make the api doc print-friendly (Marian) [#6748](https://github.com/nodejs/node/pull/6748)
* [[`f1a8c3164a`](https://github.com/nodejs/node/commit/f1a8c3164a)] - **doc**: add bengl to collaborators (Bryan English) [#6921](https://github.com/nodejs/node/pull/6921)
* [[`565d4ca12e`](https://github.com/nodejs/node/commit/565d4ca12e)] - **doc**: Update DCO to v1.1 (William Kapke) [#6353](https://github.com/nodejs/node/pull/6353)
* [[`eff73c78c5`](https://github.com/nodejs/node/commit/eff73c78c5)] - **doc**: general improvements to v8.md copy (James M Snell) [#6829](https://github.com/nodejs/node/pull/6829)
* [[`e5a7cec828`](https://github.com/nodejs/node/commit/e5a7cec828)] - **doc**: fix typo in Error.captureStackTrace (Mohsen) [#6811](https://github.com/nodejs/node/pull/6811)
* [[`5afb91bef7`](https://github.com/nodejs/node/commit/5afb91bef7)] - **doc**: make param names consistent & fix doc link (Sakthipriyan Vairamani) [#6832](https://github.com/nodejs/node/pull/6832)
* [[`e1fb4805cf`](https://github.com/nodejs/node/commit/e1fb4805cf)] - **doc**: add `added:` info for `process.cpuUsage` (Anna Henningsen) [#6863](https://github.com/nodejs/node/pull/6863)
* [[`8a0329f110`](https://github.com/nodejs/node/commit/8a0329f110)] - **doc**: fix mkdtemp example by removing hyphen (Sakthipriyan Vairamani) [#6834](https://github.com/nodejs/node/pull/6834)
* [[`45ca7cfcdd`](https://github.com/nodejs/node/commit/45ca7cfcdd)] - **doc**: reduce GitHub template verbosity (Rich Trott) [#6801](https://github.com/nodejs/node/pull/6801)
* [[`12a3d0120b`](https://github.com/nodejs/node/commit/12a3d0120b)] - **doc**: improve vm.md copy (James M Snell) [#6827](https://github.com/nodejs/node/pull/6827)
* [[`0ae512a3cf`](https://github.com/nodejs/node/commit/0ae512a3cf)] - **doc**: Add resolveNaptr and naptr rrtype docs (Doug Wade) [#6586](https://github.com/nodejs/node/pull/6586)
* [[`8309dbaf9c`](https://github.com/nodejs/node/commit/8309dbaf9c)] - **doc**: fix name to match git log (Robert Jefe Lindstaedt) [#6880](https://github.com/nodejs/node/pull/6880)
* [[`b52d838f0d`](https://github.com/nodejs/node/commit/b52d838f0d)] - **doc**: add note for fs.watch virtualized env (Robert Jefe Lindstaedt) [#6809](https://github.com/nodejs/node/pull/6809)
* [[`08f1361cb6`](https://github.com/nodejs/node/commit/08f1361cb6)] - **doc**: add `added:` information for punycode (Daniel Wang) [#6805](https://github.com/nodejs/node/pull/6805)
* [[`253db33527`](https://github.com/nodejs/node/commit/253db33527)] - **doc**: add `added:` info for dgram.*Membership() (Rich Trott) [#6753](https://github.com/nodejs/node/pull/6753)
* [[`5cad04b063`](https://github.com/nodejs/node/commit/5cad04b063)] - **doc**: clarify fs.mkdtemp prefix argument (James M Snell) [#6800](https://github.com/nodejs/node/pull/6800)
* [[`5a1e823fa5`](https://github.com/nodejs/node/commit/5a1e823fa5)] - **doc**: add `added:` information for fs (Anna Henningsen) [#6717](https://github.com/nodejs/node/pull/6717)
* [[`bf4724a7bb`](https://github.com/nodejs/node/commit/bf4724a7bb)] - **doc**: remove link to Sign in crypto.md (Kirill Fomichev) [#6812](https://github.com/nodejs/node/pull/6812)
* [[`ba3089970d`](https://github.com/nodejs/node/commit/ba3089970d)] - **doc**: add `added:` in for `tty` (Rich Trott) [#6783](https://github.com/nodejs/node/pull/6783)
* [[`758fadfa0d`](https://github.com/nodejs/node/commit/758fadfa0d)] - **doc**: update openssl.org hash links (silverwind) [#6817](https://github.com/nodejs/node/pull/6817)
* [[`b2c7d466d4`](https://github.com/nodejs/node/commit/b2c7d466d4)] - **doc,test**: add `How to write a Node.js test` guide (Santiago Gimeno) [#6984](https://github.com/nodejs/node/pull/6984)
* [[`c4329aa226`](https://github.com/nodejs/node/commit/c4329aa226)] - **fs**: move mkdtemp* functions near static functions (Sakthipriyan Vairamani) [#6828](https://github.com/nodejs/node/pull/6828)
* [[`c068880757`](https://github.com/nodejs/node/commit/c068880757)] - **fs**: mkdtemp shouldn't crash if no callback passed (Sakthipriyan Vairamani) [#6828](https://github.com/nodejs/node/pull/6828)
* [[`2ab36093e6`](https://github.com/nodejs/node/commit/2ab36093e6)] - **http**: use `localAddress` instead of `path` (Dirceu Pereira Tiegs) [#5190](https://github.com/nodejs/node/pull/5190)
* [[`6f0d8b3a1b`](https://github.com/nodejs/node/commit/6f0d8b3a1b)] - **installer**: don't install node_internals.h (Ben Noordhuis) [#6913](https://github.com/nodejs/node/pull/6913)
* [[`178f3080f8`](https://github.com/nodejs/node/commit/178f3080f8)] - **module**: don't cache uninitialized builtins (Anna Henningsen) [#6907](https://github.com/nodejs/node/pull/6907)
* [[`1908b7f00a`](https://github.com/nodejs/node/commit/1908b7f00a)] - **path**: fix basename() regressions (Brian White) [#6590](https://github.com/nodejs/node/pull/6590)
* [[`10671406ac`](https://github.com/nodejs/node/commit/10671406ac)] - **process**: internal/process/stdio.js cleanup / modernization (James M Snell) [#6766](https://github.com/nodejs/node/pull/6766)
* [[`64445674f0`](https://github.com/nodejs/node/commit/64445674f0)] - **src**: add include guards to internal headers (Ben Noordhuis) [#6948](https://github.com/nodejs/node/pull/6948)
* [[`4333fda46d`](https://github.com/nodejs/node/commit/4333fda46d)] - **src**: no abort from getter if object isn't wrapped (Trevor Norris) [#6184](https://github.com/nodejs/node/pull/6184)
* [[`4da3e1e461`](https://github.com/nodejs/node/commit/4da3e1e461)] - **src**: always clear wrap before persistent Reset() (Trevor Norris) [#6184](https://github.com/nodejs/node/pull/6184)
* [[`7e5775704e`](https://github.com/nodejs/node/commit/7e5775704e)] - **src**: inherit first from AsyncWrap (Trevor Norris) [#6184](https://github.com/nodejs/node/pull/6184)
* [[`0841496992`](https://github.com/nodejs/node/commit/0841496992)] - **src**: fix without-intl build (Anna Henningsen) [#6820](https://github.com/nodejs/node/pull/6820)
* [[`0d08fc415f`](https://github.com/nodejs/node/commit/0d08fc415f)] - **stream_base**: always use Base template class (Trevor Norris) [#6184](https://github.com/nodejs/node/pull/6184)
* [[`756ec80d50`](https://github.com/nodejs/node/commit/756ec80d50)] - **string_bytes**: Make base64 encode/decode reusable (Eugene Ostroukhov) [#6910](https://github.com/nodejs/node/pull/6910)
* [[`79ad172589`](https://github.com/nodejs/node/commit/79ad172589)] - **string_decoder**: rewrite implementation (Brian White) [#6777](https://github.com/nodejs/node/pull/6777)
* [[`8b720c4582`](https://github.com/nodejs/node/commit/8b720c4582)] - **test**: remove non-incremental common.PORT changes (Rich Trott) [#7055](https://github.com/nodejs/node/pull/7055)
* [[`6439fbfac0`](https://github.com/nodejs/node/commit/6439fbfac0)] - **test**: test TTY problems by fakeing a TTY using openpty (Jeremiah Senkpiel) [#6895](https://github.com/nodejs/node/pull/6895)
* [[`81a9f96a29`](https://github.com/nodejs/node/commit/81a9f96a29)] - **test**: make test-child-process-fork-net more robust (Rich Trott) [#7033](https://github.com/nodejs/node/pull/7033)
* [[`6cf0f622ef`](https://github.com/nodejs/node/commit/6cf0f622ef)] - **test**: fix spurious EADDRINUSE in test-https-strict (Rich Trott) [#7024](https://github.com/nodejs/node/pull/7024)
* [[`dea120f247`](https://github.com/nodejs/node/commit/dea120f247)] - **test**: update weak module for gc tests (Rich Trott) [#7014](https://github.com/nodejs/node/pull/7014)
* [[`3bfbe8a62a`](https://github.com/nodejs/node/commit/3bfbe8a62a)] - **test**: remove `common.PORT` from gc tests (Rich Trott) [#7013](https://github.com/nodejs/node/pull/7013)
* [[`b23cd48ca0`](https://github.com/nodejs/node/commit/b23cd48ca0)] - **test**: fix test-debug-port-numbers on OS X (Santiago Gimeno) [#7046](https://github.com/nodejs/node/pull/7046)
* [[`0a258e5369`](https://github.com/nodejs/node/commit/0a258e5369)] - **test**: remove modifcation to common.PORT (Rich Trott) [#6990](https://github.com/nodejs/node/pull/6990)
* [[`8c289df175`](https://github.com/nodejs/node/commit/8c289df175)] - **test**: use strictEqual consistently in agent test (Ben Noordhuis) [#6654](https://github.com/nodejs/node/pull/6654)
* [[`e4ac808c4d`](https://github.com/nodejs/node/commit/e4ac808c4d)] - **test**: work around debugger not killing inferior (Ben Noordhuis) [#7037](https://github.com/nodejs/node/pull/7037)
* [[`b5949f8bbc`](https://github.com/nodejs/node/commit/b5949f8bbc)] - **test**: verify cluster worker exit (cjihrig) [#6993](https://github.com/nodejs/node/pull/6993)
* [[`6f3f5af396`](https://github.com/nodejs/node/commit/6f3f5af396)] - **test**: add regression test for Proxy as vm context (Michaël Zasso) [#6967](https://github.com/nodejs/node/pull/6967)
* [[`38a3323cc9`](https://github.com/nodejs/node/commit/38a3323cc9)] - **test**: improve debug-break-on-uncaught reliability (Rich Trott) [#6793](https://github.com/nodejs/node/pull/6793)
* [[`83e6d53817`](https://github.com/nodejs/node/commit/83e6d53817)] - **test**: test cluster worker disconnection on error (Santiago Gimeno) [#6909](https://github.com/nodejs/node/pull/6909)
* [[`4cc6a18448`](https://github.com/nodejs/node/commit/4cc6a18448)] - **test**: verify IPC messages are emitted on next tick (Santiago Gimeno) [#6909](https://github.com/nodejs/node/pull/6909)
* [[`69e119dbfb`](https://github.com/nodejs/node/commit/69e119dbfb)] - **test**: refactor spawnSync() cwd test (cjihrig) [#6939](https://github.com/nodejs/node/pull/6939)
* [[`32cc43a1bd`](https://github.com/nodejs/node/commit/32cc43a1bd)] - **test**: fix component printing on windows (Ben Noordhuis) [#6915](https://github.com/nodejs/node/pull/6915)
* [[`c81b6f8d0d`](https://github.com/nodejs/node/commit/c81b6f8d0d)] - **test**: refactor to eliminate `__defineGetter__` (Rich Trott) [#6774](https://github.com/nodejs/node/pull/6774)
* [[`1965e445ec`](https://github.com/nodejs/node/commit/1965e445ec)] - **test**: refactor test-tls-reuse-host-from-socket (Rich Trott) [#6756](https://github.com/nodejs/node/pull/6756)
* [[`2cf3a53ce1`](https://github.com/nodejs/node/commit/2cf3a53ce1)] - **test**: fix test-debug-port-cluster flakiness (Rich Trott) [#6769](https://github.com/nodejs/node/pull/6769)
* [[`5374afdef8`](https://github.com/nodejs/node/commit/5374afdef8)] - **test**: add logging for test-debug-port-cluster (Rich Trott) [#6769](https://github.com/nodejs/node/pull/6769)
* [[`bae7adb6fa`](https://github.com/nodejs/node/commit/bae7adb6fa)] - **test**: fix flaky test-stdout-close-catch (Santiago Gimeno) [#6808](https://github.com/nodejs/node/pull/6808)
* [[`528ca04e8d`](https://github.com/nodejs/node/commit/528ca04e8d)] - **test**: add more path.basename() tests (Brian White) [#6590](https://github.com/nodejs/node/pull/6590)
* [[`1469b98fa1`](https://github.com/nodejs/node/commit/1469b98fa1)] - **test**: remove duplicate path tests (Brian White) [#6590](https://github.com/nodejs/node/pull/6590)
* [[`81e765f521`](https://github.com/nodejs/node/commit/81e765f521)] - **test**: robust handling of env for npm-test-install (Myles Borins) [#6797](https://github.com/nodejs/node/pull/6797)
* [[`2895860138`](https://github.com/nodejs/node/commit/2895860138)] - **test**: cluster-setup-master online workers check (Devon Rifkin) [#6535](https://github.com/nodejs/node/pull/6535)
* [[`7c932c2d49`](https://github.com/nodejs/node/commit/7c932c2d49)] - **test**: added tests for https-agent-getname (suryagh) [#6762](https://github.com/nodejs/node/pull/6762)
* [[`827b3eb503`](https://github.com/nodejs/node/commit/827b3eb503)] - **test**: add --repeat option to tools/test.py (Michael Dawson) [#6700](https://github.com/nodejs/node/pull/6700)
* [[`ea287fc1a6`](https://github.com/nodejs/node/commit/ea287fc1a6)] - **test,win**: skip addons/load-long-path on WOW64 (Alexis Campailla) [#6675](https://github.com/nodejs/node/pull/6675)
* [[`21e31352d7`](https://github.com/nodejs/node/commit/21e31352d7)] - **tls**: catch `certCbDone` exceptions (Fedor Indutny) [#6887](https://github.com/nodejs/node/pull/6887)
* [[`257e54b9c0`](https://github.com/nodejs/node/commit/257e54b9c0)] - **tls,https**: respect address family when connecting (Ben Noordhuis) [#6654](https://github.com/nodejs/node/pull/6654)
* [[`5779ed2a4a`](https://github.com/nodejs/node/commit/5779ed2a4a)] - **tls_wrap**: do not abort on new TLSWrap() (Trevor Norris) [#6184](https://github.com/nodejs/node/pull/6184)
* [[`108523e06e`](https://github.com/nodejs/node/commit/108523e06e)] - **tools**: make sure doctool anchors respect includes (Anna Henningsen) [#6943](https://github.com/nodejs/node/pull/6943)
* [[`bf3afce668`](https://github.com/nodejs/node/commit/bf3afce668)] - **tools**: restore change of signatures to opts hashes (Jesse McCarthy) [#6690](https://github.com/nodejs/node/pull/6690)
* [[`ceee56b28b`](https://github.com/nodejs/node/commit/ceee56b28b)] - **tools**: disallow deprecated define getter/setter (Rich Trott) [#6774](https://github.com/nodejs/node/pull/6774)
* [[`614907e516`](https://github.com/nodejs/node/commit/614907e516)] - **tools**: print stderr on bad test.py `vmArch` check (Jeremiah Senkpiel) [#6786](https://github.com/nodejs/node/pull/6786)
* [[`4d3a7594a5`](https://github.com/nodejs/node/commit/4d3a7594a5)] - **tty**: use blocking mode on OS X (Jeremiah Senkpiel) [#6895](https://github.com/nodejs/node/pull/6895)
* [[`36ed4a2d7a`](https://github.com/nodejs/node/commit/36ed4a2d7a)] - **udp**: use libuv API to get file descriptor (Saúl Ibarra Corretgé) [#6908](https://github.com/nodejs/node/pull/6908)
* [[`f3e3eebec8`](https://github.com/nodejs/node/commit/f3e3eebec8)] - **unix,stream**: fix getting the correct fd for a handle (Saúl Ibarra Corretgé) [#6753](https://github.com/nodejs/node/pull/6753)
* [[`d270706881`](https://github.com/nodejs/node/commit/d270706881)] - **util**: pretty-print SIMD types (Ben Noordhuis) [#6917](https://github.com/nodejs/node/pull/6917)
* [[`55b736a63b`](https://github.com/nodejs/node/commit/55b736a63b)] - **vm**: don't abort process when stack space runs out (Anna Henningsen) [#6907](https://github.com/nodejs/node/pull/6907)
* [[`cb2ef35b76`](https://github.com/nodejs/node/commit/cb2ef35b76)] - **win,build**: add creation of zip and 7z package (Bartosz Sosnowski) [#5995](https://github.com/nodejs/node/pull/5995)
* [[`1e26b82ce4`](https://github.com/nodejs/node/commit/1e26b82ce4)] - **zlib**: release callback and buffer after processing (Matt Lavin) [#6955](https://github.com/nodejs/node/pull/6955)
* [[`64415564de`](https://github.com/nodejs/node/commit/64415564de)] - **zlib**: remove `_closed` in source (Anna Henningsen) [#6574](https://github.com/nodejs/node/pull/6574)

<a id="6.2.0"></a>
## 2016-05-17, Version 6.2.0 (Current), @evanlucas

### Notable changes

* **buffer**: fix lastIndexOf and indexOf in various edge cases (Anna Henningsen) [#6511](https://github.com/nodejs/node/pull/6511)
* **child_process**: use /system/bin/sh on android (Ben Noordhuis) [#6745](https://github.com/nodejs/node/pull/6745)
* **deps**:
  * upgrade npm to 3.8.9 (Rebecca Turner) [#6664](https://github.com/nodejs/node/pull/6664)
  * upgrade to V8 5.0.71.47 (Ali Ijaz Sheikh) [#6572](https://github.com/nodejs/node/pull/6572)
  * upgrade libuv to 1.9.1 (Saúl Ibarra Corretgé) [#6796](https://github.com/nodejs/node/pull/6796)
  * Intl: ICU 57 bump (Steven R. Loomis) [#6088](https://github.com/nodejs/node/pull/6088)
* **repl**:
  * copying tabs shouldn't trigger completion (Eugene Obrezkov) [#5958](https://github.com/nodejs/node/pull/5958)
  * exports `Recoverable` (Blake Embrey) [#3488](https://github.com/nodejs/node/pull/3488)
* **src**: add O_NOATIME constant (Rich Trott) [#6492](https://github.com/nodejs/node/pull/6492)
* **src,module**: add --preserve-symlinks command line flag (James M Snell) [#6537](https://github.com/nodejs/node/pull/6537)
* **util**: adhere to `noDeprecation` set at runtime (Anna Henningsen) [#6683](https://github.com/nodejs/node/pull/6683)

As of this release the 6.X line now includes 64-bit binaries for Linux on Power Systems
running in big endian mode in addition to the existing 64-bit binaries for running in little endian mode.

### Commits

* [[`955c90d725`](https://github.com/nodejs/node/commit/955c90d725)] - **benchmark,test,lib**: remove extra spaces (Rich Trott) [#6645](https://github.com/nodejs/node/pull/6645)
* [[`9cd14ced09`](https://github.com/nodejs/node/commit/9cd14ced09)] - **buffer**: fix UCS2 indexOf for odd buffer length (Anna Henningsen) [#6511](https://github.com/nodejs/node/pull/6511)
* [[`a550ddbf3c`](https://github.com/nodejs/node/commit/a550ddbf3c)] - **buffer**: fix needle length misestimation for UCS2 (Anna Henningsen) [#6511](https://github.com/nodejs/node/pull/6511)
* [[`6fc20c5a97`](https://github.com/nodejs/node/commit/6fc20c5a97)] - **buffer**: fix lastIndexOf crash for overlong needle (Anna Henningsen) [#6511](https://github.com/nodejs/node/pull/6511)
* [[`44015754a3`](https://github.com/nodejs/node/commit/44015754a3)] - **buffer**: fix lastIndexOf index underflow issue (Anna Henningsen) [#6511](https://github.com/nodejs/node/pull/6511)
* [[`6032dc25cc`](https://github.com/nodejs/node/commit/6032dc25cc)] - **build**: add Make `doc-only` target (Jesse McCarthy) [#3888](https://github.com/nodejs/node/pull/3888)
* [[`3af9382a5d`](https://github.com/nodejs/node/commit/3af9382a5d)] - **build**: don't compile with -B, redux (Ben Noordhuis) [#6650](https://github.com/nodejs/node/pull/6650)
* [[`5149d66702`](https://github.com/nodejs/node/commit/5149d66702)] - **build**: fix DESTCPU detection for binary target (Richard Lau) [#6310](https://github.com/nodejs/node/pull/6310)
* [[`6eed6a3ac0`](https://github.com/nodejs/node/commit/6eed6a3ac0)] - **build,test**: fix build-addons dependency chain (Ben Noordhuis) [#6652](https://github.com/nodejs/node/pull/6652)
* [[`e0240ab592`](https://github.com/nodejs/node/commit/e0240ab592)] - **child_process**: use /system/bin/sh on android (Ben Noordhuis) [#6745](https://github.com/nodejs/node/pull/6745)
* [[`e8c9f01cdd`](https://github.com/nodejs/node/commit/e8c9f01cdd)] - **crypto**: disable ssl compression at build time (Ben Noordhuis) [#6582](https://github.com/nodejs/node/pull/6582)
* [[`62690aa0be`](https://github.com/nodejs/node/commit/62690aa0be)] - **deps**: update comment about PURIFY define (Ben Noordhuis) [#6582](https://github.com/nodejs/node/pull/6582)
* [[`bddf413412`](https://github.com/nodejs/node/commit/bddf413412)] - **deps**: upgrade npm to 3.8.9 (Rebecca Turner) [#6664](https://github.com/nodejs/node/pull/6664)
* [[`a6ca5e559a`](https://github.com/nodejs/node/commit/a6ca5e559a)] - **deps**: upgrade to V8 5.0.71.47 (Ali Ijaz Sheikh) [#6572](https://github.com/nodejs/node/pull/6572)
* [[`16159c23ed`](https://github.com/nodejs/node/commit/16159c23ed)] - **deps**: limit regress/regress-crbug-514081 v8 test (Michael Dawson) [#6678](https://github.com/nodejs/node/pull/6678)
* [[`2d84ac735a`](https://github.com/nodejs/node/commit/2d84ac735a)] - **deps**: upgrade libuv to 1.9.1 (Saúl Ibarra Corretgé) [#6796](https://github.com/nodejs/node/pull/6796)
* [[`7a6d2ad181`](https://github.com/nodejs/node/commit/7a6d2ad181)] - **deps**: Intl: Check in "small-icu" 57.1 (Steven R. Loomis) [#6088](https://github.com/nodejs/node/pull/6088)
* [[`ee1e5a267d`](https://github.com/nodejs/node/commit/ee1e5a267d)] - **deps**: Intl: ICU 57 bump (Steven R. Loomis) [#6088](https://github.com/nodejs/node/pull/6088)
* [[`a4ed7dfb3d`](https://github.com/nodejs/node/commit/a4ed7dfb3d)] - **doc**: Add CTC meeting minutes for 2016-05-04 (Michael Dawson) [#6579](https://github.com/nodejs/node/pull/6579)
* [[`5c7da210df`](https://github.com/nodejs/node/commit/5c7da210df)] - **doc**: refactor the changelog by version (James M Snell) [#6503](https://github.com/nodejs/node/pull/6503)
* [[`4f2a55f92f`](https://github.com/nodejs/node/commit/4f2a55f92f)] - **doc**: fix issues related to page scrolling (Roman Reiss)
* [[`b4fb95eade`](https://github.com/nodejs/node/commit/b4fb95eade)] - **doc**: add `added:` information for assert (Rich Trott) [#6688](https://github.com/nodejs/node/pull/6688)
* [[`64fcba2a2e`](https://github.com/nodejs/node/commit/64fcba2a2e)] - **doc**: appendFileSync accepts fd as well (Faiz Halde) [#6707](https://github.com/nodejs/node/pull/6707)
* [[`520369d8e0`](https://github.com/nodejs/node/commit/520369d8e0)] - **doc**: fix exec example in child_process (Evan Lucas) [#6660](https://github.com/nodejs/node/pull/6660)
* [[`51d1960955`](https://github.com/nodejs/node/commit/51d1960955)] - **doc**: undocument fs.open's 'rs' mode (Saúl Ibarra Corretgé) [#6732](https://github.com/nodejs/node/pull/6732)
* [[`f1c773d18b`](https://github.com/nodejs/node/commit/f1c773d18b)] - **doc**: add `added:` information for v8 (Rich Trott) [#6684](https://github.com/nodejs/node/pull/6684)
* [[`29b28a233c`](https://github.com/nodejs/node/commit/29b28a233c)] - **doc**: server.listen truncates socket path on unix (Jean Regisser) [#6659](https://github.com/nodejs/node/pull/6659)
* [[`c1d5f2e96e`](https://github.com/nodejs/node/commit/c1d5f2e96e)] - **doc**: update releases.md with new changelog structure (James M Snell) [#6503](https://github.com/nodejs/node/pull/6503)
* [[`d962fbafb2`](https://github.com/nodejs/node/commit/d962fbafb2)] - **doc**: "a" -> "an" in api/documentation.md (Anchika Agarwal) [#6689](https://github.com/nodejs/node/pull/6689)
* [[`26e22e200a`](https://github.com/nodejs/node/commit/26e22e200a)] - **doc**: move the readme newcomers section (Jeremiah Senkpiel) [#6681](https://github.com/nodejs/node/pull/6681)
* [[`8f526494b5`](https://github.com/nodejs/node/commit/8f526494b5)] - **doc**: fix deprecation warnings in addon examples (Ben Noordhuis) [#6652](https://github.com/nodejs/node/pull/6652)
* [[`d34343f0de`](https://github.com/nodejs/node/commit/d34343f0de)] - **doc**: mention existence/purpose of module wrapper (Matt Harrison) [#6433](https://github.com/nodejs/node/pull/6433)
* [[`5c154a87e0`](https://github.com/nodejs/node/commit/5c154a87e0)] - **doc**: add steps for running addons + npm tests (Myles Borins) [#6231](https://github.com/nodejs/node/pull/6231)
* [[`6ea43d12f4`](https://github.com/nodejs/node/commit/6ea43d12f4)] - **doc**: improve onboarding-extras.md formatting (Jeremiah Senkpiel) [#6548](https://github.com/nodejs/node/pull/6548)
* [[`38f5603e97`](https://github.com/nodejs/node/commit/38f5603e97)] - **doc**: fix linewrap in node.1 (Jeremiah Senkpiel) [#6532](https://github.com/nodejs/node/pull/6532)
* [[`5b47accfa6`](https://github.com/nodejs/node/commit/5b47accfa6)] - **doc**: v8 options can use either `_` or `-` (Jeremiah Senkpiel) [#6532](https://github.com/nodejs/node/pull/6532)
* [[`fa94a91bbd`](https://github.com/nodejs/node/commit/fa94a91bbd)] - **doc**: v8 functions as methods on v8 (Bryan English) [#6615](https://github.com/nodejs/node/pull/6615)
* [[`d49b49e8b1`](https://github.com/nodejs/node/commit/d49b49e8b1)] - **doc**: discourage use of util.inherits (Robert Jefe Lindstaedt) [#6514](https://github.com/nodejs/node/pull/6514)
* [[`925fc36dd9`](https://github.com/nodejs/node/commit/925fc36dd9)] - **doc**: add `added:` information for os (Bryan English) [#6609](https://github.com/nodejs/node/pull/6609)
* [[`58cd11c844`](https://github.com/nodejs/node/commit/58cd11c844)] - **doc**: add `added:` information for process (Bryan English) [#6589](https://github.com/nodejs/node/pull/6589)
* [[`d5f7f24aec`](https://github.com/nodejs/node/commit/d5f7f24aec)] - **doc**: add `added:` information for url (Bryan English) [#6593](https://github.com/nodejs/node/pull/6593)
* [[`715b48c1d3`](https://github.com/nodejs/node/commit/715b48c1d3)] - **doc**: add `added:` information for querystring (Bryan English) [#6593](https://github.com/nodejs/node/pull/6593)
* [[`04697a5023`](https://github.com/nodejs/node/commit/04697a5023)] - **doc**: correct anchors for buffer.md (Jackson Tian) [#6542](https://github.com/nodejs/node/pull/6542)
* [[`2d677411a4`](https://github.com/nodejs/node/commit/2d677411a4)] - **doc**: add `added:` information for buffer (Anna Henningsen) [#6495](https://github.com/nodejs/node/pull/6495)
* [[`49af20c2e6`](https://github.com/nodejs/node/commit/49af20c2e6)] - **doc**: update fs callback example error stack (DavidCai) [#6617](https://github.com/nodejs/node/pull/6617)
* [[`9196d87704`](https://github.com/nodejs/node/commit/9196d87704)] - **doc**: add `added:` info for `string_decoder` (Rich Trott) [#6741](https://github.com/nodejs/node/pull/6741)
* [[`688f563ca8`](https://github.com/nodejs/node/commit/688f563ca8)] - **doc**: update vm.runInDebugContext() example (Ben Noordhuis) [#6757](https://github.com/nodejs/node/pull/6757)
* [[`2273971a69`](https://github.com/nodejs/node/commit/2273971a69)] - **doc**: readline.emitKeypressEvents and raw mode (Arve Seljebu) [#6628](https://github.com/nodejs/node/pull/6628)
* [[`1c7b6e276f`](https://github.com/nodejs/node/commit/1c7b6e276f)] - **doc**: improve zlib docs (James M Snell) [#6746](https://github.com/nodejs/node/pull/6746)
* [[`897934a719`](https://github.com/nodejs/node/commit/897934a719)] - **doc**: copyedit maxBuffer note for child_process (Rich Trott) [#6760](https://github.com/nodejs/node/pull/6760)
* [[`c1bf3fc0b1`](https://github.com/nodejs/node/commit/c1bf3fc0b1)] - **doc**: fix links in socket.connecting (Kirill Fomichev) [#6657](https://github.com/nodejs/node/pull/6657)
* [[`ad895f490b`](https://github.com/nodejs/node/commit/ad895f490b)] - **doc**: trim GitHub template comments (Rich Trott) [#6755](https://github.com/nodejs/node/pull/6755)
* [[`af096f1172`](https://github.com/nodejs/node/commit/af096f1172)] - **doc**: add `added` info for `dgram.setBroadcast()` (Rich Trott) [#6750](https://github.com/nodejs/node/pull/6750)
* [[`e8c0dba4bd`](https://github.com/nodejs/node/commit/e8c0dba4bd)] - **doc,events**: fix a link typo (yorkie) [#6640](https://github.com/nodejs/node/pull/6640)
* [[`f31a5ec34a`](https://github.com/nodejs/node/commit/f31a5ec34a)] - **handle_wrap**: IsRefed() -> HasRef() (Jeremiah Senkpiel) [#6546](https://github.com/nodejs/node/pull/6546)
* [[`cc2af793d2`](https://github.com/nodejs/node/commit/cc2af793d2)] - ***Revert*** "**handle_wrap**: IsRefed -> Unrefed, no isAlive check" (Jeremiah Senkpiel) [#6546](https://github.com/nodejs/node/pull/6546)
* [[`2000072903`](https://github.com/nodejs/node/commit/2000072903)] - **handle_wrap**: IsRefed -> Unrefed, no isAlive check (Jeremiah Senkpiel) [#6204](https://github.com/nodejs/node/pull/6204)
* [[`d3132048cb`](https://github.com/nodejs/node/commit/d3132048cb)] - **(SEMVER-MINOR)** **handle_wrap**: expose an `isRefed()` check to JS (Jeremiah Senkpiel) [#5834](https://github.com/nodejs/node/pull/5834)
* [[`59666502c5`](https://github.com/nodejs/node/commit/59666502c5)] - **intl**: Don't crash if v8BreakIterator not available (Steven R. Loomis) [#4253](https://github.com/nodejs/node/pull/4253)
* [[`74582aa590`](https://github.com/nodejs/node/commit/74582aa590)] - **lib**: replace legacy uses of `__defineGetter__` (James M Snell) [#6768](https://github.com/nodejs/node/pull/6768)
* [[`559c2583e0`](https://github.com/nodejs/node/commit/559c2583e0)] - **lib,test**: update in preparation for linter update (Rich Trott) [#6498](https://github.com/nodejs/node/pull/6498)
* [[`226b9668db`](https://github.com/nodejs/node/commit/226b9668db)] - **(SEMVER-MINOR)** **repl**: copying tabs shouldn't trigger completion (Eugene Obrezkov) [#5958](https://github.com/nodejs/node/pull/5958)
* [[`ce2d5be4a1`](https://github.com/nodejs/node/commit/ce2d5be4a1)] - **(SEMVER-MINOR)** **repl**: exports `Recoverable` (Blake Embrey) [#3488](https://github.com/nodejs/node/pull/3488)
* [[`635357958d`](https://github.com/nodejs/node/commit/635357958d)] - **repl**: create history file with mode 0600 (Carl Lei) [#3394](https://github.com/nodejs/node/pull/3394)
* [[`e3920d12ef`](https://github.com/nodejs/node/commit/e3920d12ef)] - **src**: fix check-imports.py linter errors (Sakthipriyan Vairamani) [#6105](https://github.com/nodejs/node/pull/6105)
* [[`bbf3b3ebbb`](https://github.com/nodejs/node/commit/bbf3b3ebbb)] - **src**: simplify handlewrap state tracking logic (Ben Noordhuis) [#6395](https://github.com/nodejs/node/pull/6395)
* [[`965274d384`](https://github.com/nodejs/node/commit/965274d384)] - **src**: use libuv's refcounting directly (Ben Noordhuis) [#6395](https://github.com/nodejs/node/pull/6395)
* [[`316871f268`](https://github.com/nodejs/node/commit/316871f268)] - **src**: fix -Wunused-variable compiler warning (Ben Noordhuis) [#6129](https://github.com/nodejs/node/pull/6129)
* [[`1def098b9f`](https://github.com/nodejs/node/commit/1def098b9f)] - **src**: fix sporadic deadlock in SIGUSR1 handler (Ben Noordhuis) [#5904](https://github.com/nodejs/node/pull/5904)
* [[`477e61db9f`](https://github.com/nodejs/node/commit/477e61db9f)] - **src**: don't use locale-sensitive strcasecmp() (Ben Noordhuis) [#6582](https://github.com/nodejs/node/pull/6582)
* [[`1e99643fc9`](https://github.com/nodejs/node/commit/1e99643fc9)] - **src**: remove unused #include statement (Ben Noordhuis) [#6582](https://github.com/nodejs/node/pull/6582)
* [[`62593bd44c`](https://github.com/nodejs/node/commit/62593bd44c)] - **src**: remove pre-openssl 1.0 legacy code (Ben Noordhuis) [#6582](https://github.com/nodejs/node/pull/6582)
* [[`27c17ce9d1`](https://github.com/nodejs/node/commit/27c17ce9d1)] - **src**: fix FindFirstCharacter argument alignment (Anna Henningsen) [#6511](https://github.com/nodejs/node/pull/6511)
* [[`37736f4dad`](https://github.com/nodejs/node/commit/37736f4dad)] - **(SEMVER-MINOR)** **src**: add O_NOATIME constant (Rich Trott) [#6492](https://github.com/nodejs/node/pull/6492)
* [[`bd4454fa0f`](https://github.com/nodejs/node/commit/bd4454fa0f)] - **src,lib**: minor --debug-brk cleanup (Ali Ijaz Sheikh) [#6599](https://github.com/nodejs/node/pull/6599)
* [[`95b7560d8e`](https://github.com/nodejs/node/commit/95b7560d8e)] - **(SEMVER-MINOR)** **src,module**: add --preserve-symlinks command line flag (James M Snell) [#6537](https://github.com/nodejs/node/pull/6537)
* [[`8a7e68ff83`](https://github.com/nodejs/node/commit/8a7e68ff83)] - **test**: check that 2nd handle.close() call is a nop (Ben Noordhuis) [#6395](https://github.com/nodejs/node/pull/6395)
* [[`ccbc78cfc6`](https://github.com/nodejs/node/commit/ccbc78cfc6)] - **test**: remove common.getServiceName() (Rich Trott) [#6709](https://github.com/nodejs/node/pull/6709)
* [[`8c634d78f8`](https://github.com/nodejs/node/commit/8c634d78f8)] - **test**: favor strictEqual() in addon test (Rich Trott) [#6704](https://github.com/nodejs/node/pull/6704)
* [[`1389a4fc5e`](https://github.com/nodejs/node/commit/1389a4fc5e)] - **test**: fix flaky test-preload (Rich Trott) [#6728](https://github.com/nodejs/node/pull/6728)
* [[`adb2d610e6`](https://github.com/nodejs/node/commit/adb2d610e6)] - **test**: include component in tap output (Ben Noordhuis) [#6653](https://github.com/nodejs/node/pull/6653)
* [[`abb063a6a3`](https://github.com/nodejs/node/commit/abb063a6a3)] - **test**: fix test-debugger-repl-break-in-module (Rich Trott) [#6686](https://github.com/nodejs/node/pull/6686)
* [[`5701599767`](https://github.com/nodejs/node/commit/5701599767)] - **test**: fix test-debugger-repl-term (Rich Trott) [#6682](https://github.com/nodejs/node/pull/6682)
* [[`71c91747ef`](https://github.com/nodejs/node/commit/71c91747ef)] - **test**: add tests for stream3 buffering using cork (Alex J Burke) [#6493](https://github.com/nodejs/node/pull/6493)
* [[`b1f58edd54`](https://github.com/nodejs/node/commit/b1f58edd54)] - **test**: abstract skip functionality to common (Jeremiah Senkpiel) [#6697](https://github.com/nodejs/node/pull/6697)
* [[`7d3f5751b3`](https://github.com/nodejs/node/commit/7d3f5751b3)] - **test**: make sure O_NOATIME is present only in Linux (Sakthipriyan Vairamani) [#6614](https://github.com/nodejs/node/pull/6614)
* [[`75adc6a026`](https://github.com/nodejs/node/commit/75adc6a026)] - **test**: move test-debugger-debug-brk to sequential (Rich Trott) [#6731](https://github.com/nodejs/node/pull/6731)
* [[`0bc1784529`](https://github.com/nodejs/node/commit/0bc1784529)] - **test**: refactor doctool tests (Rich Trott) [#6719](https://github.com/nodejs/node/pull/6719)
* [[`89b25fac4c`](https://github.com/nodejs/node/commit/89b25fac4c)] - **test**: fix test-process-exec-argv flakiness (Santiago Gimeno) [#6575](https://github.com/nodejs/node/pull/6575)
* [[`3f9d72408f`](https://github.com/nodejs/node/commit/3f9d72408f)] - **test**: pass python path to node-gyp (hefangshi) [#6646](https://github.com/nodejs/node/pull/6646)
* [[`0c62bd13fb`](https://github.com/nodejs/node/commit/0c62bd13fb)] - **test**: ensure test-npm-install uses correct node (Myles Borins) [#6658](https://github.com/nodejs/node/pull/6658)
* [[`1b71231dd2`](https://github.com/nodejs/node/commit/1b71231dd2)] - **test**: fix test-vm-cached-data to work with old v8 (Myles Borins) [#6317](https://github.com/nodejs/node/pull/6317)
* [[`0eb25cb4b5`](https://github.com/nodejs/node/commit/0eb25cb4b5)] - **test**: test preloaded modules using stdin or repl (Bradley Meck) [#2253](https://github.com/nodejs/node/pull/2253)
* [[`577e132f00`](https://github.com/nodejs/node/commit/577e132f00)] - **test**: fix test-debugger-pid (Santiago Gimeno) [#6584](https://github.com/nodejs/node/pull/6584)
* [[`d74062454b`](https://github.com/nodejs/node/commit/d74062454b)] - **test**: make stdout buffer test more robust (Rich Trott) [#6633](https://github.com/nodejs/node/pull/6633)
* [[`f264749c5c`](https://github.com/nodejs/node/commit/f264749c5c)] - **test**: build addons with V8_DEPRECATION_WARNINGS=1 (Ben Noordhuis) [#6652](https://github.com/nodejs/node/pull/6652)
* [[`01f010f669`](https://github.com/nodejs/node/commit/01f010f669)] - **test**: allow out-of-order replies in dgram tests (Anna Henningsen) [#6607](https://github.com/nodejs/node/pull/6607)
* [[`be241c3262`](https://github.com/nodejs/node/commit/be241c3262)] - **test**: run known_issues tests in CI (Rich Trott) [#6559](https://github.com/nodejs/node/pull/6559)
* [[`8141c2fce2`](https://github.com/nodejs/node/commit/8141c2fce2)] - **test**: add tests for console.\[info|error|warn\] (Bryan English) [#6538](https://github.com/nodejs/node/pull/6538)
* [[`83dab801e2`](https://github.com/nodejs/node/commit/83dab801e2)] - **test**: fix unreliable known_issues test (Rich Trott) [#6555](https://github.com/nodejs/node/pull/6555)
* [[`8c434e6d84`](https://github.com/nodejs/node/commit/8c434e6d84)] - **test**: unmark test-http-regr-gh-2928 as flaky (Rich Trott) [#6540](https://github.com/nodejs/node/pull/6540)
* [[`916e694b2b`](https://github.com/nodejs/node/commit/916e694b2b)] - **test**: avoid test-cluster-master-* flakiness (Stefan Budeanu) [#6531](https://github.com/nodejs/node/pull/6531)
* [[`be5386e0cf`](https://github.com/nodejs/node/commit/be5386e0cf)] - **test,dgram**: add tests for setBroadcast() (Rich Trott) [#6750](https://github.com/nodejs/node/pull/6750)
* [[`1370fdcad5`](https://github.com/nodejs/node/commit/1370fdcad5)] - **test,tools**: test yaml parsing of doctool (Anna Henningsen) [#6495](https://github.com/nodejs/node/pull/6495)
* [[`347abf341d`](https://github.com/nodejs/node/commit/347abf341d)] - **tools**: enforce linting for unix-style line endings (Rich Trott) [#6685](https://github.com/nodejs/node/pull/6685)
* [[`a63c556c11`](https://github.com/nodejs/node/commit/a63c556c11)] - **tools**: remove the minifying logic (Sakthipriyan Vairamani) [#6636](https://github.com/nodejs/node/pull/6636)
* [[`efcbafa3f7`](https://github.com/nodejs/node/commit/efcbafa3f7)] - **tools**: fix regression in doctool (Myles Borins) [#6680](https://github.com/nodejs/node/pull/6680)
* [[`edb29b8096`](https://github.com/nodejs/node/commit/edb29b8096)] - **tools**: lint for object literal spacing (Rich Trott) [#6592](https://github.com/nodejs/node/pull/6592)
* [[`6806ebb608`](https://github.com/nodejs/node/commit/6806ebb608)] - **tools**: lint for use of space in template strings (Rich Trott) [#6591](https://github.com/nodejs/node/pull/6591)
* [[`341eaf202e`](https://github.com/nodejs/node/commit/341eaf202e)] - **tools**: update marked dependency (Daniel Wang) [#6396](https://github.com/nodejs/node/pull/6396)
* [[`94f82553aa`](https://github.com/nodejs/node/commit/94f82553aa)] - **tools**: allow multiple added: version entries (Anna Henningsen) [#6495](https://github.com/nodejs/node/pull/6495)
* [[`1de25f208c`](https://github.com/nodejs/node/commit/1de25f208c)] - **tools**: do not build addons during compilation (Myles Borins) [#6723](https://github.com/nodejs/node/pull/6723)
* [[`26805c97d0`](https://github.com/nodejs/node/commit/26805c97d0)] - **tools**: fix tools/doc/addon-verify.js regression (Anna Henningsen) [#6652](https://github.com/nodejs/node/pull/6652)
* [[`cea17775e0`](https://github.com/nodejs/node/commit/cea17775e0)] - **tools**: parse documentation metadata (Tristian Flanagan) [#6495](https://github.com/nodejs/node/pull/6495)
* [[`a568ad4205`](https://github.com/nodejs/node/commit/a568ad4205)] - **tools**: add mock-y js-yaml dependency to doctool (Anna Henningsen) [#6495](https://github.com/nodejs/node/pull/6495)
* [[`dce6413576`](https://github.com/nodejs/node/commit/dce6413576)] - **tools**: Check in tools for shrinking ICU size, change default to small-icu (Steven R. Loomis) [#6088](https://github.com/nodejs/node/pull/6088)
* [[`d629f265fe`](https://github.com/nodejs/node/commit/d629f265fe)] - **tools**: update ESLint to 2.9.0 (Rich Trott) [#6498](https://github.com/nodejs/node/pull/6498)
* [[`6aa92d5a98`](https://github.com/nodejs/node/commit/6aa92d5a98)] - **tools**: disallow multiple spaces except indentation (Rich Trott) [#6645](https://github.com/nodejs/node/pull/6645)
* [[`ceeae4b180`](https://github.com/nodejs/node/commit/ceeae4b180)] - **tools,test**: make argument linting more stringent (Rich Trott) [#6720](https://github.com/nodejs/node/pull/6720)
* [[`6d1527bb37`](https://github.com/nodejs/node/commit/6d1527bb37)] - **util**: fix invalid date output with util.inspect (Rumkin) [#6504](https://github.com/nodejs/node/pull/6504)
* [[`1d6c17efd7`](https://github.com/nodejs/node/commit/1d6c17efd7)] - **util**: adhere to `noDeprecation` set at runtime (Anna Henningsen) [#6683](https://github.com/nodejs/node/pull/6683)

<a id="6.1.0"></a>
## 2016-05-05, Version 6.1.0 (Current), @Fishrock123

### Notable Changes

* **assert**: `deep{Strict}Equal()` now works correctly with circular references. (Rich Trott) [#6432](https://github.com/nodejs/node/pull/6432)
* **debugger**: Arrays are now formatted correctly in the debugger repl. (cjihrig) [#6448](https://github.com/nodejs/node/pull/6448)
* **deps**: Upgrade OpenSSL sources to 1.0.2h (Shigeki Ohtsu) [#6550](https://github.com/nodejs/node/pull/6550)
  * Please see our [blog post](https://nodejs.org/en/blog/vulnerability/openssl-may-2016/) for more info on the security contents of this release.
* **net**: Introduced a `Socket#connecting` property. (Fedor Indutny) [#6404](https://github.com/nodejs/node/pull/6404)
  * Previously this information was only available as the undocumented, internal `_connecting` property.
* **process**: Introduced `process.cpuUsage()`. (Patrick Mueller) [#6157](https://github.com/nodejs/node/pull/6157)
* **stream**: `Writable#setDefaultEncoding()` now returns `this`. (Alexander Makarenko) [#5040](https://github.com/nodejs/node/pull/5040)
* **util**: Two new additions to `util.inspect()`:
  * Added a `maxArrayLength` option to truncate the formatting of Arrays. (James M Snell) [#6334](https://github.com/nodejs/node/pull/6334)
    * This is set to `100` by default.
  * Added a `showProxy` option for formatting proxy intercepting handlers. (James M Snell) [#6465](https://github.com/nodejs/node/pull/6465)
    * Inspecting proxies is non-trivial and as such this is off by default.

### Commits

* [[`76c9ab5fcf`](https://github.com/nodejs/node/commit/76c9ab5fcf)] - **assert**: allow circular references (Rich Trott) [#6432](https://github.com/nodejs/node/pull/6432)
* [[`7b9ae70757`](https://github.com/nodejs/node/commit/7b9ae70757)] - **benchmark**: Fix crash in net benchmarks (Matt Loring) [#6407](https://www.github.com/nodejs/node/pull/6407)
* [[`0d1985358a`](https://github.com/nodejs/node/commit/0d1985358a)] - **build**: use shorthand lint target from test (Johan Bergström) [#6406](https://github.com/nodejs/node/pull/6406)
* [[`7153f96f0e`](https://github.com/nodejs/node/commit/7153f96f0e)] - **build**: unbreak -prof, disable PIE on OS X (Ben Noordhuis) [#6453](https://github.com/nodejs/node/pull/6453)
* [[`8956432e18`](https://github.com/nodejs/node/commit/8956432e18)] - **build**: exclude tap files from tarballs (Brian White) [#6348](https://github.com/nodejs/node/pull/6348)
* [[`11e7cc5310`](https://github.com/nodejs/node/commit/11e7cc5310)] - **build**: don't compile with -B (Ben Noordhuis) [#6393](https://github.com/nodejs/node/pull/6393)
* [[`1330496bbf`](https://github.com/nodejs/node/commit/1330496bbf)] - **cluster**: remove use of bind() in destroy() (yorkie) [#6502](https://github.com/nodejs/node/pull/6502)
* [[`fdde36909c`](https://github.com/nodejs/node/commit/fdde36909c)] - **crypto**: fix error in deprecation message (Rich Trott) [#6344](https://github.com/nodejs/node/pull/6344)
* [[`2d503b1d4b`](https://github.com/nodejs/node/commit/2d503b1d4b)] - **debugger**: display array contents in repl (cjihrig) [#6448](https://github.com/nodejs/node/pull/6448)
* [[`54f8600613`](https://github.com/nodejs/node/commit/54f8600613)] - **deps**: update openssl asm and asm_obsolete files (Shigeki Ohtsu) [#6550](https://github.com/nodejs/node/pull/6550)
* [[`a5a2944877`](https://github.com/nodejs/node/commit/a5a2944877)] - **deps**: add -no_rand_screen to openssl s_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`3fe68129c8`](https://github.com/nodejs/node/commit/3fe68129c8)] - **deps**: fix asm build error of openssl in x86_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`d159462fed`](https://github.com/nodejs/node/commit/d159462fed)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`3af28d3693`](https://github.com/nodejs/node/commit/3af28d3693)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu) [#6550](https://github.com/nodejs/node/pull/6550)
* [[`e6ab3ece65`](https://github.com/nodejs/node/commit/e6ab3ece65)] - **deps**: upgrade openssl sources to 1.0.2h (Shigeki Ohtsu) [#6550](https://github.com/nodejs/node/pull/6550)
* [[`65b6574d59`](https://github.com/nodejs/node/commit/65b6574d59)] - **deps**: backport IsValid changes from 4e8736d in V8 (Michaël Zasso) [#6544](https://github.com/nodejs/node/pull/6544)
* [[`33f24c821b`](https://github.com/nodejs/node/commit/33f24c821b)] - **doc**: adds 'close' events to fs.ReadStream and fs.WriteStream (Jenna Vuong) [#6499](https://github.com/nodejs/node/pull/6499)
* [[`4f728df1bf`](https://github.com/nodejs/node/commit/4f728df1bf)] - **doc**: linkify remaining references to fs.Stats object (Kevin Donahue) [#6485](https://github.com/nodejs/node/pull/6485)
* [[`9a29b50c52`](https://github.com/nodejs/node/commit/9a29b50c52)] - **doc**: fix the lint of an example in cluster.md (yorkie) [#6516](https://github.com/nodejs/node/pull/6516)
* [[`d674493fa5`](https://github.com/nodejs/node/commit/d674493fa5)] - **doc**: add missing underscore for markdown italics (Kevin Donahue) [#6529](https://github.com/nodejs/node/pull/6529)
* [[`7c30f15e1b`](https://github.com/nodejs/node/commit/7c30f15e1b)] - **doc**: ensure consistent grammar in node.1 file (justshiv) [#6426](https://github.com/nodejs/node/pull/6426)
* [[`e5ce53a217`](https://github.com/nodejs/node/commit/e5ce53a217)] - **doc**: fix sentence fragment in fs doc (Rich Trott) [#6488](https://github.com/nodejs/node/pull/6488)
* [[`3e028a143c`](https://github.com/nodejs/node/commit/3e028a143c)] - **doc**: remove obsolete comment in isError() example (cjihrig) [#6486](https://github.com/nodejs/node/pull/6486)
* [[`969f96a019`](https://github.com/nodejs/node/commit/969f96a019)] - **doc**: fix a typo in `__dirname` section (William Luo) [#6473](https://github.com/nodejs/node/pull/6473)
* [[`ab7055b003`](https://github.com/nodejs/node/commit/ab7055b003)] - **doc**: fix fs.realpath man pg links (phette23) [#6451](https://github.com/nodejs/node/pull/6451)
* [[`13e660888f`](https://github.com/nodejs/node/commit/13e660888f)] - **doc**: extra clarification of historySize option (vsemozhetbyt) [#6397](https://github.com/nodejs/node/pull/6397)
* [[`3d5b732660`](https://github.com/nodejs/node/commit/3d5b732660)] - **doc**: clarifies http.serverResponse implementation (Allen Hernandez) [#6072](https://github.com/nodejs/node/pull/6072)
* [[`7034ebe2bc`](https://github.com/nodejs/node/commit/7034ebe2bc)] - **doc**: use `Node.js` in synopsis document (Rich Trott) [#6476](https://github.com/nodejs/node/pull/6476)
* [[`4ae39f9863`](https://github.com/nodejs/node/commit/4ae39f9863)] - **doc**: remove all scrollbar styling (Claudio Rodriguez) [#6479](https://github.com/nodejs/node/pull/6479)
* [[`e6c8da45b1`](https://github.com/nodejs/node/commit/e6c8da45b1)] - **(SEMVER-MINOR)** **doc**: make `writable.setDefaultEncoding()` return `this` (Alexander Makarenko) [#5040](https://github.com/nodejs/node/pull/5040)
* [[`4068d64f4f`](https://github.com/nodejs/node/commit/4068d64f4f)] - **doc**: fix EventEmitter#eventNames() example (Сковорода Никита Андреевич) [#6417](https://github.com/nodejs/node/pull/6417)
* [[`bfcde97251`](https://github.com/nodejs/node/commit/bfcde97251)] - **doc**: fix incorrect syntax in examples (Evan Lucas) [#6463](https://github.com/nodejs/node/pull/6463)
* [[`8eb87ee239`](https://github.com/nodejs/node/commit/8eb87ee239)] - **doc**: Remove extra space in REPL example (Juan) [#6447](https://github.com/nodejs/node/pull/6447)
* [[`fd37d54eb5`](https://github.com/nodejs/node/commit/fd37d54eb5)] - **doc**: added note warning about change to console.endTime() (Ben Page) [#6454](https://github.com/nodejs/node/pull/6454)
* [[`b3f75ec801`](https://github.com/nodejs/node/commit/b3f75ec801)] - **doc**: expand documentation for process.exit() (James M Snell) [#6410](https://github.com/nodejs/node/pull/6410)
* [[`fc0fbf1c63`](https://github.com/nodejs/node/commit/fc0fbf1c63)] - **doc**: subdivide TOC, add auxiliary links (Jeremiah Senkpiel) [#6167](https://github.com/nodejs/node/pull/6167)
* [[`150dd36503`](https://github.com/nodejs/node/commit/150dd36503)] - **doc**: no Node.js(1) (Jeremiah Senkpiel) [#6167](https://github.com/nodejs/node/pull/6167)
* [[`ab84d69048`](https://github.com/nodejs/node/commit/ab84d69048)] - **doc**: better example & synopsis (Jeremiah Senkpiel) [#6167](https://github.com/nodejs/node/pull/6167)
* [[`f6d72791a1`](https://github.com/nodejs/node/commit/f6d72791a1)] - **doc**: update build instructions for OS X (Rich Trott) [#6309](https://github.com/nodejs/node/pull/6309)
* [[`36207c6daf`](https://github.com/nodejs/node/commit/36207c6daf)] - **doc**: correctly document the behavior of ee.once(). (Lance Ball) [#6371](https://github.com/nodejs/node/pull/6371)
* [[`19fb1345ba`](https://github.com/nodejs/node/commit/19fb1345ba)] - **doc**: use Buffer.from() instead of new Buffer() (Jackson Tian) [#6367](https://github.com/nodejs/node/pull/6367)
* [[`fb6753c75c`](https://github.com/nodejs/node/commit/fb6753c75c)] - **doc**: fix v6 changelog (James M Snell) [#6435](https://github.com/nodejs/node/pull/6435)
* [[`2c92a1fe03`](https://github.com/nodejs/node/commit/2c92a1fe03)] - **events**: pass the original listener added by once (DavidCai) [#6394](https://github.com/nodejs/node/pull/6394)
* [[`9ea6b282e8`](https://github.com/nodejs/node/commit/9ea6b282e8)] - **meta**: split CHANGELOG into two files (Myles Borins) [#6337](https://github.com/nodejs/node/pull/6337)
* [[`cbbe95e1e1`](https://github.com/nodejs/node/commit/cbbe95e1e1)] - **(SEMVER-MINOR)** **net**: introduce `Socket#connecting` property (Fedor Indutny) [#6404](https://github.com/nodejs/node/pull/6404)
* [[`534f03c2f0`](https://github.com/nodejs/node/commit/534f03c2f0)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`1b9fdba04e`](https://github.com/nodejs/node/commit/1b9fdba04e)] - **(SEMVER-MINOR)** **process**: add process.cpuUsage() - implementation, doc, tests (Patrick Mueller) [#6157](https://github.com/nodejs/node/pull/6157)
* [[`fa9d82d120`](https://github.com/nodejs/node/commit/fa9d82d120)] - **src**: unify implementations of Utf8Value etc. (Anna Henningsen) [#6357](https://github.com/nodejs/node/pull/6357)
* [[`65030c77b7`](https://github.com/nodejs/node/commit/65030c77b7)] - **test**: fix alpn tests for openssl1.0.2h (Shigeki Ohtsu) [#6550](https://github.com/nodejs/node/pull/6550)
* [[`7641f9a6de`](https://github.com/nodejs/node/commit/7641f9a6de)] - **test**: refactor large event emitter tests (cjihrig) [#6446](https://github.com/nodejs/node/pull/6446)
* [[`5fe5fa2897`](https://github.com/nodejs/node/commit/5fe5fa2897)] - **test**: make addon testing part of `make test` (Ben Noordhuis) [#6232](https://github.com/nodejs/node/pull/6232)
* [[`457d12a0a1`](https://github.com/nodejs/node/commit/457d12a0a1)] - **test**: add failing url parse tests as known_issue (James M Snell) [#5885](https://github.com/nodejs/node/pull/5885)
* [[`089362f8b8`](https://github.com/nodejs/node/commit/089362f8b8)] - **test,tools**: limit lint tolerance of gc global (Rich Trott) [#6324](https://github.com/nodejs/node/pull/6324)
* [[`6d1606ee94`](https://github.com/nodejs/node/commit/6d1606ee94)] - **test,tools**: adjust function argument alignment (Rich Trott) [#6390](https://github.com/nodejs/node/pull/6390)
* [[`08e0884ae0`](https://github.com/nodejs/node/commit/08e0884ae0)] - **tools**: add -F flag for fixing lint issues (Rich Trott) [#6483](https://github.com/nodejs/node/pull/6483)
* [[`9f23cb24f2`](https://github.com/nodejs/node/commit/9f23cb24f2)] - **tools**: fix exit code when linting from CI (Brian White) [#6412](https://github.com/nodejs/node/pull/6412)
* [[`e62c42b8f4`](https://github.com/nodejs/node/commit/e62c42b8f4)] - **tools**: remove default parameters from lint rule (Rich Trott) [#6411](https://github.com/nodejs/node/pull/6411)
* [[`66903f6695`](https://github.com/nodejs/node/commit/66903f6695)] - **tools**: add tests for the doctool (Ian Kronquist) [#6031](https://github.com/nodejs/node/pull/6031)
* [[`3f608b16a7`](https://github.com/nodejs/node/commit/3f608b16a7)] - **tools**: lint for function argument alignment (Rich Trott) [#6390](https://github.com/nodejs/node/pull/6390)
* [[`91ab769940`](https://github.com/nodejs/node/commit/91ab769940)] - **(SEMVER-MINOR)** **util**: truncate inspect array and typed array (James M Snell) [#6334](https://github.com/nodejs/node/pull/6334)
* [[`0bca959617`](https://github.com/nodejs/node/commit/0bca959617)] - **(SEMVER-MINOR)** **util**: fix inspecting of proxy objects (James M Snell) [#6465](https://github.com/nodejs/node/pull/6465)

<a id="6.0.0"></a>
## 2016-04-26, Version 6.0.0 (Current), @jasnell

### Notable changes

The following significant changes have been made since the previous Node.js
v5.0.0 release.

* Buffer
  * New Buffer constructors have been added
    [#4682](https://github.com/nodejs/node/pull/4682) and
    [#5833](https://github.com/nodejs/node/pull/5833).
  * Existing `Buffer()` and `SlowBuffer()` constructors have been deprecated
    in docs [#4682](https://github.com/nodejs/node/pull/4682) and
    [#5833](https://github.com/nodejs/node/pull/5833).
  * Previously deprecated Buffer APIs are removed
    [#5048](https://github.com/nodejs/node/pull/5048),
    [#4594](https://github.com/nodejs/node/pull/4594).
  * Improved error handling [#4514](https://github.com/nodejs/node/pull/4514).
  * The `Buffer.prototype.lastIndexOf()` method has been added
    [#4846](https://github.com/nodejs/node/pull/4846).
* Cluster
  * Worker emitted as first argument in 'message' event
    [#5361](https://github.com/nodejs/node/pull/5361).
  * The `worker.exitedAfterDisconnect` property replaces `worker.suicide`
    [#3743](https://github.com/nodejs/node/pull/3743).
* Console
  * Calling `console.timeEnd()` with an unknown label now emits a process
    warning rather than throwing
    [#5901](https://github.com/nodejs/node/pull/5901).
* Crypto
  * Improved error handling [#3100](https://github.com/nodejs/node/pull/3100),
    [#5611](https://github.com/nodejs/node/pull/5611).
  * Simplified Certificate class bindings
    [#5382](https://github.com/nodejs/node/pull/5382).
  * Improved control over FIPS mode
    [#5181](https://github.com/nodejs/node/pull/5181).
  * pbkdf2 digest overloading is deprecated
    [#4047](https://github.com/nodejs/node/pull/4047).
* Dependencies
  * Reintroduce shared c-ares build support
    [#5775](https://github.com/nodejs/node/pull/5775).
  * V8 updated to 5.0.71.35 [#6372](https://github.com/nodejs/node/pull/6372).
* DNS
  * Add `dns.resolvePtr()` API to query plain DNS PTR records
    [#4921](https://github.com/nodejs/node/pull/4921).
* Domains
  * Clear stack when no error handler
  [#4659](https://github.com/nodejs/node/pull/4659).
* Events
  * The `EventEmitter.prototype._events` object no longer inherits from
    Object.prototype [#6092](https://github.com/nodejs/node/pull/6092).
  * The `EventEmitter.prototype.prependListener()` and
    `EventEmitter.prototype.prependOnceListener()` methods have been added
    [#6032](https://github.com/nodejs/node/pull/6032).
* File System
  * The `fs.realpath()` and `fs.realpathSync()` methods have been updated
    to use a more efficient libuv-based implementation. This change includes
    the removal of the `cache` argument and the method can throw new errors
    [#3594](https://github.com/nodejs/node/pull/3594).
  * FS apis can now accept and return paths as Buffers
    [#5616](https://github.com/nodejs/node/pull/5616).
  * Error handling and type checking improvements
    [#5616](https://github.com/nodejs/node/pull/5616),
    [#5590](https://github.com/nodejs/node/pull/5590),
    [#4518](https://github.com/nodejs/node/pull/4518),
    [#3917](https://github.com/nodejs/node/pull/3917).
  * fs.read's string interface is deprecated
    [#4525](https://github.com/nodejs/node/pull/4525).
* HTTP
  * 'clientError' can now be used to return custom errors from an
    HTTP server [#4557](https://github.com/nodejs/node/pull/4557).
* Modules
  * Current directory is now prioritized for local lookups
    [#5689](https://github.com/nodejs/node/pull/5689).
  * Symbolic links are preserved when requiring modules
    [#5950](https://github.com/nodejs/node/pull/5950).
* Net
  * DNS hints no longer implicitly set
    [#6021](https://github.com/nodejs/node/pull/6021).
  * Improved error handling and type checking
    [#5981](https://github.com/nodejs/node/pull/5981),
    [#5733](https://github.com/nodejs/node/pull/5733),
    [#2904](https://github.com/nodejs/node/pull/2904).
* npm
  * Running npm requires the node binary to be in the path
    [#6098](https://github.com/nodejs/node/pull/6098).
* OS X
  * MACOSX_DEPLOYMENT_TARGET has been bumped up to 10.7
    [#6402](https://github.com/nodejs/node/pull/6402).
* Path
  * Improved type checking [#5348](https://github.com/nodejs/node/pull/5348).
* Process
  * Introduce process warnings API
    [#4782](https://github.com/nodejs/node/pull/4782).
  * Throw exception when non-function passed to nextTick
    [#3860](https://github.com/nodejs/node/pull/3860).
* Querystring
  * The object returned by `querystring.parse()` no longer inherits from
    Object.prototype [#6055](https://github.com/nodejs/node/pull/6055).
* Readline
  * Key info is emitted unconditionally
    [#6024](https://github.com/nodejs/node/pull/6024).
  * History can now be explicitly disabled
    [#6352](https://github.com/nodejs/node/pull/6352).
* REPL
  * Assignment to `_` will emit a warning
    [#5535](https://github.com/nodejs/node/pull/5535).
  * Expressions will no longer be completed when eval fails
    [#6328](https://github.com/nodejs/node/pull/6328).
* Timers
  * Fail early when callback is not a function
    [#4362](https://github.com/nodejs/node/pull/4362).
* Streams
  * `null` is now an invalid chunk to write in object mode
    [#6170](https://github.com/nodejs/node/pull/6170).
* TLS
  * Rename 'clientError' to 'tlsClientError'
    [#4557](https://github.com/nodejs/node/pull/4557).
  * SHA1 used for sessionIdContext
    [#3866](https://github.com/nodejs/node/pull/3866).
* TTY
  * Previously deprecated setRawMode wrapper is removed
    [#2528](https://github.com/nodejs/node/pull/2528).
* URL
  * Username and password will be dropped by `url.resolve()` if the host
    changes [#1480](https://github.com/nodejs/node/pull/1480).
* Util
  * Changes to Error object formatting
    [#4582](https://github.com/nodejs/node/pull/4582).
  * The `util._extend()` method has been deprecated
    [#4903](https://github.com/nodejs/node/pull/4903)
  * The `util.log()` method has been deprecated
    [#6161](https://github.com/nodejs/node/pull/6161).
* Windows
  * Windows XP and Vista are no longer supported
    [#5167](https://github.com/nodejs/node/pull/5167).
* Zlib
  * Multiple improvements have been made to Zlib processing
    [#5883](https://github.com/nodejs/node/pull/5883) and
    [#5707](https://github.com/nodejs/node/pull/5707).

### Commits

Semver-major Changes since v5.0.0

* [[`829d613daa`](https://github.com/nodejs/node/commit/829d613daa)] - **(SEMVER-MAJOR)** **buffer**: docs-only deprecate SlowBuffer (James M Snell) [#5833](https://github.com/nodejs/node/pull/5833)
* [[`d0c6e6f7c4`](https://github.com/nodejs/node/commit/d0c6e6f7c4)] - **(SEMVER-MAJOR)** **buffer**: add Buffer.allocUnsafeSlow(size) (James M Snell) [#5833](https://github.com/nodejs/node/pull/5833)
* [[`85ab4a5f12`](https://github.com/nodejs/node/commit/85ab4a5f12)] - **(SEMVER-MAJOR)** **buffer**: add .from(), .alloc() and .allocUnsafe() (James M Snell) [#4682](https://github.com/nodejs/node/pull/4682)
* [[`2c55cc2d2c`](https://github.com/nodejs/node/commit/2c55cc2d2c)] - **(SEMVER-MAJOR)** **buffer**: remove deprecated Buffer.write branch (dcposch@dcpos.ch) [#5048](https://github.com/nodejs/node/pull/5048)
* [[`101bca988c`](https://github.com/nodejs/node/commit/101bca988c)] - **(SEMVER-MAJOR)** **buffer**: remove deprecated buffer.get/.set methods (Feross Aboukhadijeh) [#4594](https://github.com/nodejs/node/pull/4594)
* [[`3b27dd5ce1`](https://github.com/nodejs/node/commit/3b27dd5ce1)] - **(SEMVER-MAJOR)** **buffer**: throw if both length and enc are passed (Mathias Buus) [#4514](https://github.com/nodejs/node/pull/4514)
* [[`ce864ef502`](https://github.com/nodejs/node/commit/ce864ef502)] - **(SEMVER-MAJOR)** **build**: Bump MACOSX_DEPLOYMENT_TARGET to 10.7 (Сковорода Никита Андреевич) [#6402](https://github.com/nodejs/node/pull/6402)
* [[`90a5fc20be`](https://github.com/nodejs/node/commit/90a5fc20be)] - **(SEMVER-MAJOR)** **build**: remove lint/dotfiles from release tarball (Johan Bergström) [#5695](https://github.com/nodejs/node/pull/5695)
* [[`66f048af6f`](https://github.com/nodejs/node/commit/66f048af6f)] - **(SEMVER-MAJOR)** **cluster**: migrate from worker.suicide (Evan Lucas) [#3743](https://github.com/nodejs/node/pull/3743)
* [[`66f4586dd0`](https://github.com/nodejs/node/commit/66f4586dd0)] - **(SEMVER-MAJOR)** **cluster**: emit worker as first 'message' event arg (Ben Noordhuis) [#5361](https://github.com/nodejs/node/pull/5361)
* [[`30507951d9`](https://github.com/nodejs/node/commit/30507951d9)] - **(SEMVER-MAJOR)** **console**: timeEnd() with no label emits warning (Eugene Obrezkov) [#5901](https://github.com/nodejs/node/pull/5901)
* [[`a5cce79ec3`](https://github.com/nodejs/node/commit/a5cce79ec3)] - **(SEMVER-MAJOR)** **console**: delete timers that have ended (Vladimir Varankin) [#3562](https://github.com/nodejs/node/pull/3562)
* [[`47cca06412`](https://github.com/nodejs/node/commit/47cca06412)] - **(SEMVER-MAJOR)** **crypto**: better error message for createHash (Calvin Metcalf) [#6042](https://github.com/nodejs/node/pull/6042)
* [[`41feaa89e0`](https://github.com/nodejs/node/commit/41feaa89e0)] - **(SEMVER-MAJOR)** **crypto**: improve error messages (Sakthipriyan Vairamani) [#3100](https://github.com/nodejs/node/pull/3100)
* [[`f429fe1b88`](https://github.com/nodejs/node/commit/f429fe1b88)] - **(SEMVER-MAJOR)** **crypto**: fail early when loading crypto without openssl (James M Snell) [#5611](https://github.com/nodejs/node/pull/5611)
* [[`a37401e061`](https://github.com/nodejs/node/commit/a37401e061)] - **(SEMVER-MAJOR)** **crypto**: simplify Certificate class bindings (Alexander Makarenko) [#5382](https://github.com/nodejs/node/pull/5382)
* [[`7c48cb5601`](https://github.com/nodejs/node/commit/7c48cb5601)] - **(SEMVER-MAJOR)** **crypto**: Improve control of FIPS mode (Stefan Budeanu) [#5181](https://github.com/nodejs/node/pull/5181)
* [[`a1163582c5`](https://github.com/nodejs/node/commit/a1163582c5)] - **(SEMVER-MAJOR)** **crypto**: pbkdf2 deprecate digest overload. (Tom Gallacher) [#4047](https://github.com/nodejs/node/pull/4047)
* [[`b010c87164`](https://github.com/nodejs/node/commit/b010c87164)] - **(SEMVER-MAJOR)** **crypto, string_bytes**: treat `buffer` str as `utf8` (Fedor Indutny) [#5522](https://github.com/nodejs/node/pull/5522)
* [[`a42453b085`](https://github.com/nodejs/node/commit/a42453b085)] - **(SEMVER-MAJOR)** **deps**: upgrade V8 to 5.0.71.32 (Ali Ijaz Sheikh) [#6111](https://github.com/nodejs/node/pull/6111)
* [[`2253be95d0`](https://github.com/nodejs/node/commit/2253be95d0)] - **(SEMVER-MAJOR)** **deps**: reintroduce supporting shared c-ares builds (Johan Bergström) [#5775](https://github.com/nodejs/node/pull/5775)
* [[`4bc1cccb22`](https://github.com/nodejs/node/commit/4bc1cccb22)] - **(SEMVER-MAJOR)** **dgram**: pass null as error on successful send() (cjihrig) [#5929](https://github.com/nodejs/node/pull/5929)
* [[`dbdbdd4998`](https://github.com/nodejs/node/commit/dbdbdd4998)] - **(SEMVER-MAJOR)** **dns**: add resolvePtr to query plain DNS PTR records (Daniel Turing) [#4921](https://github.com/nodejs/node/pull/4921)
* [[`c4ab861a49`](https://github.com/nodejs/node/commit/c4ab861a49)] - **(SEMVER-MAJOR)** **dns**: add failure test for dns.resolveXXX (Daniel Turing) [#4921](https://github.com/nodejs/node/pull/4921)
* [[`f3be421c1c`](https://github.com/nodejs/node/commit/f3be421c1c)] - **(SEMVER-MAJOR)** **dns**: coerce port to number in lookupService (Evan Lucas) [#4883](https://github.com/nodejs/node/pull/4883)
* [[`fa74805bac`](https://github.com/nodejs/node/commit/fa74805bac)] - **(SEMVER-MAJOR)** **doc**: doc-only deprecation for util.log() (Jackson Tian) [#6161](https://github.com/nodejs/node/pull/6161)
* [[`34b1a64068`](https://github.com/nodejs/node/commit/34b1a64068)] - **(SEMVER-MAJOR)** **doc**: minor copy improvement in buffer.markdown (James M Snell) [#5833](https://github.com/nodejs/node/pull/5833)
* [[`4d4f3535a9`](https://github.com/nodejs/node/commit/4d4f3535a9)] - **(SEMVER-MAJOR)** **doc**: general improvements to fs.markdown (James M Snell) [#5616](https://github.com/nodejs/node/pull/5616)
* [[`d8290286b3`](https://github.com/nodejs/node/commit/d8290286b3)] - **(SEMVER-MAJOR)** **doc**: document deprecation of util._extend (Benjamin Gruenbaum) [#4903](https://github.com/nodejs/node/pull/4903)
* [[`3abf9d5df5`](https://github.com/nodejs/node/commit/3abf9d5df5)] - **(SEMVER-MAJOR)** **doc, tls**: deprecate createSecurePair (Yuval Brik) [#6063](https://github.com/nodejs/node/pull/6063)
* [[`90204cc468`](https://github.com/nodejs/node/commit/90204cc468)] - **(SEMVER-MAJOR)** **domains**: clear stack when no error handler (Julien Gilli) [#4659](https://github.com/nodejs/node/pull/4659)
* [[`c3ad97d3cc`](https://github.com/nodejs/node/commit/c3ad97d3cc)] - **(SEMVER-MAJOR)** **events**: don't inherit from Object.prototype (Brian White) [#6092](https://github.com/nodejs/node/pull/6092)
* [[`a2492f989f`](https://github.com/nodejs/node/commit/a2492f989f)] - **(SEMVER-MAJOR)** **fs**: optimize realpath using uv_fs_realpath() (Yuval Brik) [#3594](https://github.com/nodejs/node/pull/3594)
* [[`53a95a5b12`](https://github.com/nodejs/node/commit/53a95a5b12)] - **(SEMVER-MAJOR)** **fs**: make fs.watch error message more useful (James M Snell) [#5616](https://github.com/nodejs/node/pull/5616)
* [[`060e5f0c00`](https://github.com/nodejs/node/commit/060e5f0c00)] - **(SEMVER-MAJOR)** **fs**: Buffer and encoding enhancements to fs API (James M Snell) [#5616](https://github.com/nodejs/node/pull/5616)
* [[`8bb60e3c8d`](https://github.com/nodejs/node/commit/8bb60e3c8d)] - **(SEMVER-MAJOR)** **fs**: improve error message for invalid flag (James M Snell) [#5590](https://github.com/nodejs/node/pull/5590)
* [[`1124de2d76`](https://github.com/nodejs/node/commit/1124de2d76)] - **(SEMVER-MAJOR)** **fs**: deprecate fs.read's string interface (Sakthipriyan Vairamani) [#4525](https://github.com/nodejs/node/pull/4525)
* [[`2b15e68bbe`](https://github.com/nodejs/node/commit/2b15e68bbe)] - **(SEMVER-MAJOR)** **fs**: fs.read into zero buffer should not throw exception (Feross Aboukhadijeh) [#4518](https://github.com/nodejs/node/pull/4518)
* [[`8b97249893`](https://github.com/nodejs/node/commit/8b97249893)] - **(SEMVER-MAJOR)** **fs**: fix the error report on fs.link(Sync) (yorkie) [#3917](https://github.com/nodejs/node/pull/3917)
* [[`5f76b24e5e`](https://github.com/nodejs/node/commit/5f76b24e5e)] - **(SEMVER-MAJOR)** **http**: overridable `clientError` (Fedor Indutny) [#4557](https://github.com/nodejs/node/pull/4557)
* [[`d01eb6882f`](https://github.com/nodejs/node/commit/d01eb6882f)] - **(SEMVER-MAJOR)** **lib**: add 'pid' prefix in `internal/util` (Minwoo Jung) [#3878](https://github.com/nodejs/node/pull/3878)
* [[`20285ad177`](https://github.com/nodejs/node/commit/20285ad177)] - **(SEMVER-MAJOR)** **lib**: Consistent error messages in all modules (micnic) [#3374](https://github.com/nodejs/node/pull/3374)
* [[`94b9948d63`](https://github.com/nodejs/node/commit/94b9948d63)] - **(SEMVER-MAJOR)** **lib,src**: ensure '(node:pid)' prefix for stdout logging (Minwoo Jung) [#3833](https://github.com/nodejs/node/pull/3833)
* [[`b70dc67828`](https://github.com/nodejs/node/commit/b70dc67828)] - **(SEMVER-MAJOR)** **lib,test**: remove publicly exposed freelist (cjihrig) [#3738](https://github.com/nodejs/node/pull/3738)
* [[`c43b182b11`](https://github.com/nodejs/node/commit/c43b182b11)] - **(SEMVER-MAJOR)** **module**: preserve symlinks when requiring (Alex Lamar) [#5950](https://github.com/nodejs/node/pull/5950)
* [[`d38503ab01`](https://github.com/nodejs/node/commit/d38503ab01)] - **(SEMVER-MAJOR)** **module**: prioritize current dir for local lookups (Phillip Johnsen) [#5689](https://github.com/nodejs/node/pull/5689)
* [[`71470a8e45`](https://github.com/nodejs/node/commit/71470a8e45)] - **(SEMVER-MAJOR)** **module**: pass v8::Object to linked module initialization function (Phillip Kovalev) [#4771](https://github.com/nodejs/node/pull/4771)
* [[`18490d3d5a`](https://github.com/nodejs/node/commit/18490d3d5a)] - **(SEMVER-MAJOR)** **module**: always decorate thrown errors (Brian White) [#4287](https://github.com/nodejs/node/pull/4287)
* [[`c32c889c45`](https://github.com/nodejs/node/commit/c32c889c45)] - **(SEMVER-MAJOR)** **net**: Validate port in createServer().listen() (Dirceu Pereira Tiegs) [#5732](https://github.com/nodejs/node/pull/5732)
* [[`b85a50b6da`](https://github.com/nodejs/node/commit/b85a50b6da)] - **(SEMVER-MAJOR)** **net**: remove implicit setting of DNS hints (cjihrig) [#6021](https://github.com/nodejs/node/pull/6021)
* [[`ec49fc8229`](https://github.com/nodejs/node/commit/ec49fc8229)] - **(SEMVER-MAJOR)** **net**: improve socket.write() error message (Phillip Johnsen) [#5981](https://github.com/nodejs/node/pull/5981)
* [[`d0edabecbf`](https://github.com/nodejs/node/commit/d0edabecbf)] - **(SEMVER-MAJOR)** **net**: strict checking for internal/net isLegalPort (James M Snell) [#5733](https://github.com/nodejs/node/pull/5733)
* [[`a78b3344f8`](https://github.com/nodejs/node/commit/a78b3344f8)] - **(SEMVER-MAJOR)** **net**: type check createServer options object (Sam Roberts) [#2904](https://github.com/nodejs/node/pull/2904)
* [[`25751bedfe`](https://github.com/nodejs/node/commit/25751bedfe)] - **(SEMVER-MAJOR)** **node**: deprecate process.EventEmitter (Evan Lucas) [#5049](https://github.com/nodejs/node/pull/5049)
* [[`08085c49b6`](https://github.com/nodejs/node/commit/08085c49b6)] - **(SEMVER-MAJOR)** **path**: assert inputs are strings (Brian White) [#5348](https://github.com/nodejs/node/pull/5348)
* [[`d1000b4137`](https://github.com/nodejs/node/commit/d1000b4137)] - **(SEMVER-MAJOR)** **path**: make format() consistent and more functional (Nathan Woltman) [#2408](https://github.com/nodejs/node/pull/2408)
* [[`c6656db352`](https://github.com/nodejs/node/commit/c6656db352)] - **(SEMVER-MAJOR)** **process**: add 'warning' event and process.emitWarning() (James M Snell) [#4782](https://github.com/nodejs/node/pull/4782)
* [[`72e3dd9f43`](https://github.com/nodejs/node/commit/72e3dd9f43)] - **(SEMVER-MAJOR)** **process**: throw on non-function to nextTick() (yorkie) [#3860](https://github.com/nodejs/node/pull/3860)
* [[`33c286154b`](https://github.com/nodejs/node/commit/33c286154b)] - **(SEMVER-MAJOR)** **querystring**: don't inherit from Object.prototype (Brian White) [#6055](https://github.com/nodejs/node/pull/6055)
* [[`5c8b5971eb`](https://github.com/nodejs/node/commit/5c8b5971eb)] - **(SEMVER-MAJOR)** **querystring**: using toString for objects on querystring.escape (Igor Kalashnikov) [#5341](https://github.com/nodejs/node/pull/5341)
* [[`9c6ef5b3e1`](https://github.com/nodejs/node/commit/9c6ef5b3e1)] - **(SEMVER-MAJOR)** **readline**: allow history to be disabled (surya panikkal) [#6352](https://github.com/nodejs/node/pull/6352)
* [[`0a62f929da`](https://github.com/nodejs/node/commit/0a62f929da)] - **(SEMVER-MAJOR)** **readline**: emit key info unconditionally (cjihrig) [#6024](https://github.com/nodejs/node/pull/6024)
* [[`3de9bc9429`](https://github.com/nodejs/node/commit/3de9bc9429)] - **(SEMVER-MAJOR)** **readline**: document emitKeypressEvents() (cjihrig) [#6024](https://github.com/nodejs/node/pull/6024)
* [[`ca2e8b292f`](https://github.com/nodejs/node/commit/ca2e8b292f)] - **(SEMVER-MAJOR)** **readline**: deprecate undocumented exports (cjihrig) [#3862](https://github.com/nodejs/node/pull/3862)
* [[`bd2cee1b10`](https://github.com/nodejs/node/commit/bd2cee1b10)] - **(SEMVER-MAJOR)** **repl**: don’t complete expressions when eval fails (Anna Henningsen) [#6328](https://github.com/nodejs/node/pull/6328)
* [[`ad8257fa5b`](https://github.com/nodejs/node/commit/ad8257fa5b)] - **(SEMVER-MAJOR)** **repl**: Assignment of _ allowed with warning (Lance Ball) [#5535](https://github.com/nodejs/node/pull/5535)
* [[`757fbac64b`](https://github.com/nodejs/node/commit/757fbac64b)] - **(SEMVER-MAJOR)** **src**: remove deprecated internal functions (Ben Noordhuis) [#6053](https://github.com/nodejs/node/pull/6053)
* [[`57003520f8`](https://github.com/nodejs/node/commit/57003520f8)] - **(SEMVER-MAJOR)** **src**: attach error to stack on displayErrors (cjihrig) [#4874](https://github.com/nodejs/node/pull/4874)
* [[`4e46931406`](https://github.com/nodejs/node/commit/4e46931406)] - **(SEMVER-MAJOR)** **src**: deprecate undocumented variables (Jackson Tian) [#1838](https://github.com/nodejs/node/pull/1838)
* [[`c0abecdaf3`](https://github.com/nodejs/node/commit/c0abecdaf3)] - **(SEMVER-MAJOR)** **stream**: make null an invalid chunk to write in object mode (Calvin Metcalf) [#6170](https://github.com/nodejs/node/pull/6170)
* [[`652782d137`](https://github.com/nodejs/node/commit/652782d137)] - **(SEMVER-MAJOR)** **test**: update test-repl-require for local paths (Myles Borins) [#5689](https://github.com/nodejs/node/pull/5689)
* [[`a5aa7c1713`](https://github.com/nodejs/node/commit/a5aa7c1713)] - **(SEMVER-MAJOR)** **test**: expand test case for unknown file open flags (James M Snell) [#5590](https://github.com/nodejs/node/pull/5590)
* [[`2c33819370`](https://github.com/nodejs/node/commit/2c33819370)] - **(SEMVER-MAJOR)** **test**: fix tests that check error messages (cjihrig) [#3727](https://github.com/nodejs/node/pull/3727)
* [[`ac153bd2a6`](https://github.com/nodejs/node/commit/ac153bd2a6)] - **(SEMVER-MAJOR)** **timers**: fail early when callback is not a function (Anna Henningsen) [#4362](https://github.com/nodejs/node/pull/4362)
* [[`1ab6b21360`](https://github.com/nodejs/node/commit/1ab6b21360)] - **(SEMVER-MAJOR)** **tls**: rename `clientError` to `tlsClientError` (Fedor Indutny) [#4557](https://github.com/nodejs/node/pull/4557)
* [[`df268f97bc`](https://github.com/nodejs/node/commit/df268f97bc)] - **(SEMVER-MAJOR)** **tls**: use SHA1 for sessionIdContext (Stefan Budeanu) [#3866](https://github.com/nodejs/node/pull/3866)
* [[`102a77655a`](https://github.com/nodejs/node/commit/102a77655a)] - **(SEMVER-MAJOR)** **tools**: do not rewrite npm shebang in install.py (Evan Lucas) [#6098](https://github.com/nodejs/node/pull/6098)
* [[`a2c0aa84e0`](https://github.com/nodejs/node/commit/a2c0aa84e0)] - **(SEMVER-MAJOR)** **tty**: Remove deprecated setRawMode wrapper (Wyatt Preul) [#2528](https://github.com/nodejs/node/pull/2528)
* [[`1b50b80e06`](https://github.com/nodejs/node/commit/1b50b80e06)] - **(SEMVER-MAJOR)** **url**: drop auth in `url.resolve()` if host changes (Alex Kocharin) [#1480](https://github.com/nodejs/node/pull/1480)
* [[`e2f47f5698`](https://github.com/nodejs/node/commit/e2f47f5698)] - **(SEMVER-MAJOR)** **util**: Change how Error objects are formatted (Mudit Ameta) [#4582](https://github.com/nodejs/node/pull/4582)
* [[`93d6b5fb68`](https://github.com/nodejs/node/commit/93d6b5fb68)] - **(SEMVER-MAJOR)** **util**: use consistent Dates in inspect() (Xotic750) [#4318](https://github.com/nodejs/node/pull/4318)
* [[`24012a879d`](https://github.com/nodejs/node/commit/24012a879d)] - **(SEMVER-MAJOR)** **util**: make inspect more reliable (Evan Lucas) [#4098](https://github.com/nodejs/node/pull/4098)
* [[`007cfea308`](https://github.com/nodejs/node/commit/007cfea308)] - **(SEMVER-MAJOR)** **util**: remove pump (Wyatt Preul) [#2531](https://github.com/nodejs/node/pull/2531)
* [[`4cf19ad1bb`](https://github.com/nodejs/node/commit/4cf19ad1bb)] - **(SEMVER-MAJOR)** **util**: Remove exec, has been deprecated for years (Wyatt Preul) [#2530](https://github.com/nodejs/node/pull/2530)
* [[`34a35919e1`](https://github.com/nodejs/node/commit/34a35919e1)] - **(SEMVER-MAJOR)** **util**: improve typed array formatting (Ben Noordhuis) [#3793](https://github.com/nodejs/node/pull/3793)
* [[`1cf26c036d`](https://github.com/nodejs/node/commit/1cf26c036d)] - **(SEMVER-MAJOR)** **win**: prevent node from running on Windows Vista or earlier (Alexis Campailla) [#5167](https://github.com/nodejs/node/pull/5167)
* [[`55db19074d`](https://github.com/nodejs/node/commit/55db19074d)] - **(SEMVER-MAJOR)** **win,msi**: prevent from installing on Windows Vista or earlier (Alexis Campailla) [#5167](https://github.com/nodejs/node/pull/5167)
* [[`54a5287e3e`](https://github.com/nodejs/node/commit/54a5287e3e)] - **(SEMVER-MAJOR)** **zlib**: fix gzip member head/buffer boundary issue (Anna Henningsen) [#5883](https://github.com/nodejs/node/pull/5883)
* [[`8b43d3f52d`](https://github.com/nodejs/node/commit/8b43d3f52d)] - **(SEMVER-MAJOR)** **zlib**: do not emit event on *Sync() methods (Rich Trott) [#5707](https://github.com/nodejs/node/pull/5707)

Semver-minor and patch commits since v5.11.0

* [[`7d4f652ced`](https://github.com/nodejs/node/commit/7d4f652ced)] - **benchmarks**: fix lint error (Myles Borins) [#6314](https://github.com/nodejs/node/pull/6314)
* [[`451f4fc88e`](https://github.com/nodejs/node/commit/451f4fc88e)] - **benchmarks**: add microbenchmarks for new ES6 features (James M Snell) [#6222](https://github.com/nodejs/node/pull/6222)
* [[`962c1e1cac`](https://github.com/nodejs/node/commit/962c1e1cac)] - **benchmarks**: add common.v8ForceOptimization (James M Snell) [#6222](https://github.com/nodejs/node/pull/6222)
* [[`d866438ce1`](https://github.com/nodejs/node/commit/d866438ce1)] - **buffer**: safeguard against accidental kNoZeroFill (Сковорода Никита Андреевич) [nodejs/node-private#30](https://github.com/nodejs/node-private/pull/30)
* [[`3350b4712b`](https://github.com/nodejs/node/commit/3350b4712b)] - **(SEMVER-MINOR)** **buffer**: add Buffer.prototype.lastIndexOf() (dcposch@dcpos.ch) [#4846](https://github.com/nodejs/node/pull/4846)
* [[`afd821a91d`](https://github.com/nodejs/node/commit/afd821a91d)] - **buffer**: faster case for create buffer from empty string (Jackson Tian) [#4414](https://github.com/nodejs/node/pull/4414)
* [[`73fc440870`](https://github.com/nodejs/node/commit/73fc440870)] - **buffer**: fix buffer alignment restriction (Ali Ijaz Sheikh) [#5752](https://github.com/nodejs/node/pull/5752)
* [[`206a81fb14`](https://github.com/nodejs/node/commit/206a81fb14)] - **buffer**: avoid undefined behaviour (Ali Ijaz Sheikh) [#5494](https://github.com/nodejs/node/pull/5494)
* [[`ebbbc5a790`](https://github.com/nodejs/node/commit/ebbbc5a790)] - **buffer**: replace deprecated SetWeak usage (Ali Ijaz Sheikh) [#5204](https://github.com/nodejs/node/pull/5204)
* [[`34aac23d0b`](https://github.com/nodejs/node/commit/34aac23d0b)] - **buffer**: cleanup CallbackInfo (Ali Ijaz Sheikh) [#5204](https://github.com/nodejs/node/pull/5204)
* [[`d7259280ee`](https://github.com/nodejs/node/commit/d7259280ee)] - **build**: update android-configure script for npm (Robert Chiras) [#6349](https://github.com/nodejs/node/pull/6349)
* [[`8cf94006c9`](https://github.com/nodejs/node/commit/8cf94006c9)] - **build**: do not ignore errors during build-addons (Ali Ijaz Sheikh) [#5494](https://github.com/nodejs/node/pull/5494)
* [[`704b68aeb9`](https://github.com/nodejs/node/commit/704b68aeb9)] - **cares**: Support malloc(0) scenarios for AIX (Gireesh Punathil) [#6305](https://github.com/nodejs/node/pull/6305)
* [[`77e2efec8c`](https://github.com/nodejs/node/commit/77e2efec8c)] - **console**: refactor to use rest params and template strings (James M Snell) [#6233](https://github.com/nodejs/node/pull/6233)
* [[`a53b2ac4b1`](https://github.com/nodejs/node/commit/a53b2ac4b1)] - **contextify**: tie lifetimes of context & sandbox (Ali Ijaz Sheikh) [#5786](https://github.com/nodejs/node/pull/5786)
* [[`d6237aa7c6`](https://github.com/nodejs/node/commit/d6237aa7c6)] - **(SEMVER-MINOR)** **crypto**: Read OpenSSL config before init (Stefan Budeanu) [#6374](https://github.com/nodejs/node/pull/6374)
* [[`c1729b0c38`](https://github.com/nodejs/node/commit/c1729b0c38)] - **deps**: upgrade to V8 5.0.71.35 (Ali Ijaz Sheikh) [#6372](https://github.com/nodejs/node/pull/6372)
* [[`7337693c33`](https://github.com/nodejs/node/commit/7337693c33)] - **deps**: upgrade to V8 5.0.71.34 (Ali Ijaz Sheikh) [#6320](https://github.com/nodejs/node/pull/6320)
* [[`809ed52147`](https://github.com/nodejs/node/commit/809ed52147)] - **deps**: upgrade to V8 5.0.71.33 (Ali Ijaz Sheikh) [#6290](https://github.com/nodejs/node/pull/6290)
* [[`19867cedfe`](https://github.com/nodejs/node/commit/19867cedfe)] - **deps**: exclude tests on ppc for v8 5.0 (Michael Dawson) [#6267](https://github.com/nodejs/node/pull/6267)
* [[`450418286a`](https://github.com/nodejs/node/commit/450418286a)] - **deps**: cherry-pick 1ef7487b from v8 upstream (Michael Dawson) [#6218](https://github.com/nodejs/node/pull/6218)
* [[`c3cec1eefc`](https://github.com/nodejs/node/commit/c3cec1eefc)] - **deps**: upgrade libuv to 1.9.0 (Saúl Ibarra Corretgé) [#5994](https://github.com/nodejs/node/pull/5994)
* [[`3a8e8230ee`](https://github.com/nodejs/node/commit/3a8e8230ee)] - **deps**: upgrade to V8 4.9.385.35 (Ben Noordhuis) [#6077](https://github.com/nodejs/node/pull/6077)
* [[`f8e8075a62`](https://github.com/nodejs/node/commit/f8e8075a62)] - **deps**: upgrade to V8 4.9.385.27 (Ali Ijaz Sheikh) [#5494](https://github.com/nodejs/node/pull/5494)
* [[`079973b96a`](https://github.com/nodejs/node/commit/079973b96a)] - **deps**: add V8 DEP trace_event (Ali Ijaz Sheikh) [#4722](https://github.com/nodejs/node/pull/4722)
* [[`89f234300a`](https://github.com/nodejs/node/commit/89f234300a)] - **deps**: edit v8 gitignore to allow trace_event copy (Ali Ijaz Sheikh) [#4722](https://github.com/nodejs/node/pull/4722)
* [[`069e02ab47`](https://github.com/nodejs/node/commit/069e02ab47)] - **deps**: upgrade to V8 4.9.385.18 (Ali Ijaz Sheikh) [#4722](https://github.com/nodejs/node/pull/4722)
* [[`674e5131ed`](https://github.com/nodejs/node/commit/674e5131ed)] - **deps**: backport bc2e393 from v8 upstream (evan.lucas) [#4106](https://github.com/nodejs/node/pull/4106)
* [[`113d1f3821`](https://github.com/nodejs/node/commit/113d1f3821)] - **deps**: cherry-pick 68e89fb from v8's upstream (Fedor Indutny) [#4106](https://github.com/nodejs/node/pull/4106)
* [[`ef4170ea03`](https://github.com/nodejs/node/commit/ef4170ea03)] - **deps**: upgrade to V8 4.8.271.17 (Ali Ijaz Sheikh) [#4785](https://github.com/nodejs/node/pull/4785)
* [[`384b20362c`](https://github.com/nodejs/node/commit/384b20362c)] - **deps**: upgrade to V8 4.7.80.32 (Ali Ijaz Sheikh) [#4699](https://github.com/nodejs/node/pull/4699)
* [[`36ac3d642e`](https://github.com/nodejs/node/commit/36ac3d642e)] - **deps**: backport 8d6a228 from the v8's upstream (Fedor Indutny) [#4259](https://github.com/nodejs/node/pull/4259)
* [[`e2dec98837`](https://github.com/nodejs/node/commit/e2dec98837)] - **deps**: upgrade to V8 4.7.80.25 (Ali Ijaz Sheikh) [#4160](https://github.com/nodejs/node/pull/4160)
* [[`1e324d883e`](https://github.com/nodejs/node/commit/1e324d883e)] - **deps**: backport bc2e393 from v8 upstream (evan.lucas) [#4106](https://github.com/nodejs/node/pull/4106)
* [[`d9d050d396`](https://github.com/nodejs/node/commit/d9d050d396)] - **deps**: cherry-pick 68e89fb from v8's upstream (Fedor Indutny) [#4106](https://github.com/nodejs/node/pull/4106)
* [[`edfc8cde04`](https://github.com/nodejs/node/commit/edfc8cde04)] - **deps**: backport 1ee712a from V8 upstream (Julien Gilli) [#4106](https://github.com/nodejs/node/pull/4106)
* [[`8a43a3d761`](https://github.com/nodejs/node/commit/8a43a3d761)] - **deps**: upgrade V8 to 4.7.80.24 (Ali Ijaz Sheikh) [#4106](https://github.com/nodejs/node/pull/4106)
* [[`61be0004a6`](https://github.com/nodejs/node/commit/61be0004a6)] - **doc**: fix position of `fs.readSync()` (Jeremiah Senkpiel) [#6399](https://github.com/nodejs/node/pull/6399)
* [[`27ce7fe953`](https://github.com/nodejs/node/commit/27ce7fe953)] - **doc**: change references to Stable to Current (Myles Borins) [#6318](https://github.com/nodejs/node/pull/6318)
* [[`547a6fecb9`](https://github.com/nodejs/node/commit/547a6fecb9)] - **doc**: update authors (James M Snell) [#6373](https://github.com/nodejs/node/pull/6373)
* [[`af8dd44d43`](https://github.com/nodejs/node/commit/af8dd44d43)] - **doc**: add JacksonTian to collaborators (Jackson Tian) [#6388](https://github.com/nodejs/node/pull/6388)
* [[`09f7b8a818`](https://github.com/nodejs/node/commit/09f7b8a818)] - **doc**: add Minqi Pan to collaborators (Minqi Pan) [#6387](https://github.com/nodejs/node/pull/6387)
* [[`dfc7ffd24d`](https://github.com/nodejs/node/commit/dfc7ffd24d)] - **doc**: add eljefedelrodeodeljefe to collaborators (Robert Jefe Lindstaedt) [#6389](https://github.com/nodejs/node/pull/6389)
* [[`e45dbd3089`](https://github.com/nodejs/node/commit/e45dbd3089)] - **doc**: add ronkorving to collaborators (ronkorving) [#6385](https://github.com/nodejs/node/pull/6385)
* [[`96f6af7b26`](https://github.com/nodejs/node/commit/96f6af7b26)] - **doc**: add estliberitas to collaborators (Alexander Makarenko) [#6386](https://github.com/nodejs/node/pull/6386)
* [[`8def5fa4e7`](https://github.com/nodejs/node/commit/8def5fa4e7)] - **doc**: fix broken references (Alexander Gromnitsky) [#6350](https://github.com/nodejs/node/pull/6350)
* [[`11d71da558`](https://github.com/nodejs/node/commit/11d71da558)] - **doc**: add note for platform specific flags `fs.open()` (Robert Jefe Lindstaedt) [#6136](https://github.com/nodejs/node/pull/6136)
* [[`e6d4f3befb`](https://github.com/nodejs/node/commit/e6d4f3befb)] - **doc**: improvements to child_process, process docs (Alexander Makarenko)
* [[`7c03595b2a`](https://github.com/nodejs/node/commit/7c03595b2a)] - **doc**: fix a typo in the CONTRIBUTING.md (vsemozhetbyt) [#6343](https://github.com/nodejs/node/pull/6343)
* [[`557c309447`](https://github.com/nodejs/node/commit/557c309447)] - **doc**: add vm example, be able to require modules (Robert Jefe Lindstaedt) [#5323](https://github.com/nodejs/node/pull/5323)
* [[`61a214e957`](https://github.com/nodejs/node/commit/61a214e957)] - **doc**: note that process.config can and will be changed (James M Snell) [#6266](https://github.com/nodejs/node/pull/6266)
* [[`09ec1cc1c7`](https://github.com/nodejs/node/commit/09ec1cc1c7)] - **doc**: path.resolve ignores zero-length strings (Igor Klopov) [#5928](https://github.com/nodejs/node/pull/5928)
* [[`b743d82ffc`](https://github.com/nodejs/node/commit/b743d82ffc)] - **doc**: improve github templates by using comments (Johan Bergström) [#5710](https://github.com/nodejs/node/pull/5710)
* [[`d939152230`](https://github.com/nodejs/node/commit/d939152230)] - **doc**: fix typo in fs writeSync param list (firedfox) [#5984](https://github.com/nodejs/node/pull/5984)
* [[`4039ef1a58`](https://github.com/nodejs/node/commit/4039ef1a58)] - **doc**: remove redundant parameter comments from fs (firedfox) [#5952](https://github.com/nodejs/node/pull/5952)
* [[`9b6440a86c`](https://github.com/nodejs/node/commit/9b6440a86c)] - **doc**: add simple http clientError example (James M Snell) [#5248](https://github.com/nodejs/node/pull/5248)
* [[`de91e9a8a7`](https://github.com/nodejs/node/commit/de91e9a8a7)] - **doc**: fix v4.3.0 changelog commit entries (James M Snell) [#5164](https://github.com/nodejs/node/pull/5164)
* [[`e31bda81dd`](https://github.com/nodejs/node/commit/e31bda81dd)] - **doc**: add CTC meeting minutes 2016-01-20 (Rod Vagg) [#4904](https://github.com/nodejs/node/pull/4904)
* [[`ce11a37c4a`](https://github.com/nodejs/node/commit/ce11a37c4a)] - **doc**: add CTC meeting minutes 2016-01-27 (Rod Vagg) [#5057](https://github.com/nodejs/node/pull/5057)
* [[`3c70dc83ed`](https://github.com/nodejs/node/commit/3c70dc83ed)] - **doc**: add CTC meeting minutes 2016-01-06 (Rod Vagg) [#4667](https://github.com/nodejs/node/pull/4667)
* [[`55326f5488`](https://github.com/nodejs/node/commit/55326f5488)] - **doc**: add CTC meeting minutes 2015-12-16 (Rod Vagg) [#4666](https://github.com/nodejs/node/pull/4666)
* [[`1a346840bf`](https://github.com/nodejs/node/commit/1a346840bf)] - **doc**: add CTC meeting minutes 2015-12-02 (Rod Vagg) [#4665](https://github.com/nodejs/node/pull/4665)
* [[`3ac5f8dcba`](https://github.com/nodejs/node/commit/3ac5f8dcba)] - **doc**: add CTC meeting minutes 2015-11-11 (Rod Vagg) [#4664](https://github.com/nodejs/node/pull/4664)
* [[`db39625a44`](https://github.com/nodejs/node/commit/db39625a44)] - **doc**: add CTC meeting minutes 2015-11-04 (Rod Vagg) [#4663](https://github.com/nodejs/node/pull/4663)
* [[`aa53bf2faa`](https://github.com/nodejs/node/commit/aa53bf2faa)] - **(SEMVER-MINOR)** **events**: add prependListener() and prependOnceListener() (James M Snell) [#6032](https://github.com/nodejs/node/pull/6032)
* [[`c9628c55fa`](https://github.com/nodejs/node/commit/c9628c55fa)] - **events**: make eventNames() use Reflect.ownKeys() (Luigi Pinca) [#5822](https://github.com/nodejs/node/pull/5822)
* [[`b6e3fa745b`](https://github.com/nodejs/node/commit/b6e3fa745b)] - **(SEMVER-MINOR)** **events**: add eventNames() method (James M Snell) [#5617](https://github.com/nodejs/node/pull/5617)
* [[`1d79787e2e`](https://github.com/nodejs/node/commit/1d79787e2e)] - **fs**: add a temporary fix for re-evaluation support (Сковорода Никита Андреевич) [#5102](https://github.com/nodejs/node/pull/5102)
* [[`3441a4178b`](https://github.com/nodejs/node/commit/3441a4178b)] - **fs**: revert "change statSync to accessSync..." (Rich Trott) [#4679](https://github.com/nodejs/node/pull/4679)
* [[`809bf5e38c`](https://github.com/nodejs/node/commit/809bf5e38c)] - **fs**: change statSync to accessSync in realpathSync (Ben Noordhuis) [#4575](https://github.com/nodejs/node/pull/4575)
* [[`4bd8b20f20`](https://github.com/nodejs/node/commit/4bd8b20f20)] - **github**: put description of PR to the end of tmpl (Fedor Indutny) [#5378](https://github.com/nodejs/node/pull/5378)
* [[`81e35b5a29`](https://github.com/nodejs/node/commit/81e35b5a29)] - **github**: add issue and pull request templates (Fedor Indutny) [#5291](https://github.com/nodejs/node/pull/5291)
* [[`7cbd9fe39a`](https://github.com/nodejs/node/commit/7cbd9fe39a)] - **gyp**: inherit parent for `*.host` (Johan Bergström) [#6173](https://github.com/nodejs/node/pull/6173)
* [[`c29b3c1808`](https://github.com/nodejs/node/commit/c29b3c1808)] - **lib**: improve module loading performance (Brian White) [#5172](https://github.com/nodejs/node/pull/5172)
* [[`953173b0d7`](https://github.com/nodejs/node/commit/953173b0d7)] - **lib**: wrap tick_processor scripts in IIFE (Ali Ijaz Sheikh) [#4722](https://github.com/nodejs/node/pull/4722)
* [[`f3d9de772c`](https://github.com/nodejs/node/commit/f3d9de772c)] - **module**: fix resolution of filename with trailing slash (Michaël Zasso) [#6215](https://github.com/nodejs/node/pull/6215)
* [[`5c14efbbe9`](https://github.com/nodejs/node/commit/5c14efbbe9)] - **module**: return correct exports from linked binding (Phillip Kovalev) [#5337](https://github.com/nodejs/node/pull/5337)
* [[`19f700859b`](https://github.com/nodejs/node/commit/19f700859b)] - **module**: revert "optimize js and json file i/o" (Rich Trott) [#4679](https://github.com/nodejs/node/pull/4679)
* [[`7c60328002`](https://github.com/nodejs/node/commit/7c60328002)] - **module**: optimize js and json file i/o (Ben Noordhuis) [#4575](https://github.com/nodejs/node/pull/4575)
* [[`aa395b78fe`](https://github.com/nodejs/node/commit/aa395b78fe)] - **net**: set ADDRCONFIG DNS hint in connections (cjihrig) [#6281](https://github.com/nodejs/node/pull/6281)
* [[`e052096ee0`](https://github.com/nodejs/node/commit/e052096ee0)] - **(SEMVER-MINOR)** **os**: add userInfo() method (cjihrig) [#6104](https://github.com/nodejs/node/pull/6104)
* [[`d18daaa4e7`](https://github.com/nodejs/node/commit/d18daaa4e7)] - **querystring**: fix comments (Brian White) [#6365](https://github.com/nodejs/node/pull/6365)
* [[`633268c6df`](https://github.com/nodejs/node/commit/633268c6df)] - **src**: fix check-imports.py linter errors (Sakthipriyan Vairamani) [#6105](https://github.com/nodejs/node/pull/6105)
* [[`b0b7f6a12b`](https://github.com/nodejs/node/commit/b0b7f6a12b)] - **src**: squelch -Wunused-variable in non-icu builds (Ben Noordhuis) [#6351](https://github.com/nodejs/node/pull/6351)
* [[`b6a41d6120`](https://github.com/nodejs/node/commit/b6a41d6120)] - **src**: fix out-of-bounds write in TwoByteValue (Anna Henningsen) [#6330](https://github.com/nodejs/node/pull/6330)
* [[`86ff8447f3`](https://github.com/nodejs/node/commit/86ff8447f3)] - **src**: add intl and icu configs to process.binding('config') (James M Snell) [#6266](https://github.com/nodejs/node/pull/6266)
* [[`5b7a011e1b`](https://github.com/nodejs/node/commit/5b7a011e1b)] - **src**: add process.binding('config') (James M Snell) [#6266](https://github.com/nodejs/node/pull/6266)
* [[`f286e1e1ad`](https://github.com/nodejs/node/commit/f286e1e1ad)] - **src**: fix -Wunused-result warning in e38bade (Sakthipriyan Vairamani) [#6276](https://github.com/nodejs/node/pull/6276)
* [[`2a4998c5c0`](https://github.com/nodejs/node/commit/2a4998c5c0)] - **src**: don't set non-primitive values on templates (Ben Noordhuis) [#6228](https://github.com/nodejs/node/pull/6228)
* [[`00c876dec5`](https://github.com/nodejs/node/commit/00c876dec5)] - **src**: fix ARRAY_SIZE() logic error (Ben Noordhuis) [#5969](https://github.com/nodejs/node/pull/5969)
* [[`ad0ce57432`](https://github.com/nodejs/node/commit/ad0ce57432)] - **src**: fix NewInstance deprecation warnings (Michaël Zasso) [#4722](https://github.com/nodejs/node/pull/4722)
* [[`67b5a8a936`](https://github.com/nodejs/node/commit/67b5a8a936)] - **src**: replace usage of deprecated ForceSet (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`536cfecd71`](https://github.com/nodejs/node/commit/536cfecd71)] - **src**: replace deprecated SetWeak in object_wrap (Ali Ijaz Sheikh) [#5494](https://github.com/nodejs/node/pull/5494)
* [[`492fbfbff8`](https://github.com/nodejs/node/commit/492fbfbff8)] - **src**: update uses of deprecated NewExternal (Ali Ijaz Sheikh) [#5462](https://github.com/nodejs/node/pull/5462)
* [[`a45e1f9f98`](https://github.com/nodejs/node/commit/a45e1f9f98)] - **src**: fix deprecated SetWeak usage in base-object (Ali Ijaz Sheikh) [#5204](https://github.com/nodejs/node/pull/5204)
* [[`c1649a7e4e`](https://github.com/nodejs/node/commit/c1649a7e4e)] - **src**: replace usage of deprecated SetAccessor (Ali Ijaz Sheikh) [#5204](https://github.com/nodejs/node/pull/5204)
* [[`cddd5347f6`](https://github.com/nodejs/node/commit/cddd5347f6)] - **src**: replace deprecated ProcessDebugMessages (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`d515a3f4b4`](https://github.com/nodejs/node/commit/d515a3f4b4)] - **src**: replace usage of deprecated GetDebugContext (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`4417f99432`](https://github.com/nodejs/node/commit/4417f99432)] - **src**: replace usage of deprecated SetMessageHandler (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`8894f2745f`](https://github.com/nodejs/node/commit/8894f2745f)] - **src**: replace deprecated CancelTerminateExecution (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`f50ef1a46f`](https://github.com/nodejs/node/commit/f50ef1a46f)] - **src**: replace deprecated TerminateExecution (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`ac32340997`](https://github.com/nodejs/node/commit/ac32340997)] - **src**: replace usage of deprecated HasOwnProperty (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`a729208808`](https://github.com/nodejs/node/commit/a729208808)] - **src**: replace usage of deprecated Has (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`3d7fd9aa22`](https://github.com/nodejs/node/commit/3d7fd9aa22)] - **src**: replace usage of deprecated GetEndColumn (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`d45045f318`](https://github.com/nodejs/node/commit/d45045f318)] - **src**: replace usage of deprecated Delete (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`16b0a8c1ac`](https://github.com/nodejs/node/commit/16b0a8c1ac)] - **src**: replace usage of deprecated CompileUnbound (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`023c317173`](https://github.com/nodejs/node/commit/023c317173)] - **src**: replace usage of deprecated Compile (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`79d7475604`](https://github.com/nodejs/node/commit/79d7475604)] - **src**: fix TryCatch deprecation warnings (Michaël Zasso) [#4722](https://github.com/nodejs/node/pull/4722)
* [[`81f1732a05`](https://github.com/nodejs/node/commit/81f1732a05)] - **src**: replace deprecated String::NewFromOneByte (Michaël Zasso) [#4722](https://github.com/nodejs/node/pull/4722)
* [[`924cc6c633`](https://github.com/nodejs/node/commit/924cc6c633)] - **src**: upgrade to new v8::Private api (Ben Noordhuis) [#5045](https://github.com/nodejs/node/pull/5045)
* [[`79dc1d7635`](https://github.com/nodejs/node/commit/79dc1d7635)] - **src**: remove forwards for v8::GC*logueCallback (Ali Ijaz Sheikh) [#4381](https://github.com/nodejs/node/pull/4381)
* [[`89abe86808`](https://github.com/nodejs/node/commit/89abe86808)] - ***Revert*** "**stream**: emit 'pause' on nextTick" (Evan Lucas) [#5947](https://github.com/nodejs/node/pull/5947)
* [[`ace1009456`](https://github.com/nodejs/node/commit/ace1009456)] - **stream**: emit 'pause' on nextTick (Alexis Campailla) [#5776](https://github.com/nodejs/node/pull/5776)
* [[`eee9dc7e9d`](https://github.com/nodejs/node/commit/eee9dc7e9d)] - ***Revert*** "**stream**: add bytesRead property for readable" (cjihrig) [#4746](https://github.com/nodejs/node/pull/4746)
* [[`bfb2cd0bfd`](https://github.com/nodejs/node/commit/bfb2cd0bfd)] - **stream**: add bytesRead property for readable (Jackson Tian) [#4372](https://github.com/nodejs/node/pull/4372)
* [[`0ed85e35a9`](https://github.com/nodejs/node/commit/0ed85e35a9)] - **test**: increase the platform timeout for AIX (Michael Dawson) [#6342](https://github.com/nodejs/node/pull/6342)
* [[`591ebe7d82`](https://github.com/nodejs/node/commit/591ebe7d82)] - **test**: add tests for console.assert (Evan Lucas) [#6302](https://github.com/nodejs/node/pull/6302)
* [[`a9bab5fddb`](https://github.com/nodejs/node/commit/a9bab5fddb)] - **test**: v8-flags is sensitive to script caching (Ali Ijaz Sheikh) [#6316](https://github.com/nodejs/node/pull/6316)
* [[`c83204e2d9`](https://github.com/nodejs/node/commit/c83204e2d9)] - **test**: don't assume IPv6 in test-regress-GH-5727 (cjihrig) [#6319](https://github.com/nodejs/node/pull/6319)
* [[`6e57d2d7c4`](https://github.com/nodejs/node/commit/6e57d2d7c4)] - **test**: spawn new processes in vm-cached-data (Fedor Indutny) [#6280](https://github.com/nodejs/node/pull/6280)
* [[`3ebabc95aa`](https://github.com/nodejs/node/commit/3ebabc95aa)] - **test**: update error message for JSON.parse (Michaël Zasso) [#5945](https://github.com/nodejs/node/pull/5945)
* [[`b73e1b3c5a`](https://github.com/nodejs/node/commit/b73e1b3c5a)] - **test**: fix another flaky stringbytes test (Ali Ijaz Sheikh) [#6073](https://github.com/nodejs/node/pull/6073)
* [[`f4ebd5989a`](https://github.com/nodejs/node/commit/f4ebd5989a)] - **test**: fix flakiness of stringbytes-external (Ali Ijaz Sheikh) [#6039](https://github.com/nodejs/node/pull/6039)
* [[`be97db92af`](https://github.com/nodejs/node/commit/be97db92af)] - **test**: add buffer alignment regression tests (Anna Henningsen) [#5752](https://github.com/nodejs/node/pull/5752)
* [[`01f82f0685`](https://github.com/nodejs/node/commit/01f82f0685)] - **test**: fix proxy tab-completion test (Ali Ijaz Sheikh) [#4722](https://github.com/nodejs/node/pull/4722)
* [[`9968941797`](https://github.com/nodejs/node/commit/9968941797)] - **test**: fix tests after V8 upgrade (Michaël Zasso) [#4722](https://github.com/nodejs/node/pull/4722)
* [[`db9e122182`](https://github.com/nodejs/node/commit/db9e122182)] - **test**: update ArrayBuffer alloc failure message (Ali Ijaz Sheikh) [#4785](https://github.com/nodejs/node/pull/4785)
* [[`dc09bbe3ee`](https://github.com/nodejs/node/commit/dc09bbe3ee)] - **test**: fix test-repl-tab-complete after V8 upgrade (Ali Ijaz Sheikh) [#4106](https://github.com/nodejs/node/pull/4106)
* [[`3a0eef7b99`](https://github.com/nodejs/node/commit/3a0eef7b99)] - **test,benchmark**: use deepStrictEqual() (Rich Trott) [#6213](https://github.com/nodejs/node/pull/6213)
* [[`e928edad65`](https://github.com/nodejs/node/commit/e928edad65)] - **tools**: rewrite check-install.sh in python (Sakthipriyan Vairamani) [#6105](https://github.com/nodejs/node/pull/6105)
* [[`96978768c9`](https://github.com/nodejs/node/commit/96978768c9)] - **tools**: enforce deepStrictEqual over deepEqual (Rich Trott) [#6213](https://github.com/nodejs/node/pull/6213)
* [[`9e30129fa7`](https://github.com/nodejs/node/commit/9e30129fa7)] - **(SEMVER-MINOR)** **tools**: add buffer-constructor eslint rule (James M Snell) [#5740](https://github.com/nodejs/node/pull/5740)
* [[`b6475b9a9d`](https://github.com/nodejs/node/commit/b6475b9a9d)] - ***Revert*** "**tty**: don't read from console stream upon creation" (Evan Lucas) [#5947](https://github.com/nodejs/node/pull/5947)
* [[`4611389294`](https://github.com/nodejs/node/commit/4611389294)] - **tty**: don't read from console stream upon creation (Alexis Campailla) [#5776](https://github.com/nodejs/node/pull/5776)
* [[`59737b29c7`](https://github.com/nodejs/node/commit/59737b29c7)] - **url**: use "empty" object for empty query strings (Brian White) [#6289](https://github.com/nodejs/node/pull/6289)
* [[`0b43c08f44`](https://github.com/nodejs/node/commit/0b43c08f44)] - **util**: pass on additional error() args (Brian White) [#4279](https://github.com/nodejs/node/pull/4279)
* [[`967a15541b`](https://github.com/nodejs/node/commit/967a15541b)] - **v8**: warn in Template::Set() on improper use (Ben Noordhuis) [#6277](https://github.com/nodejs/node/pull/6277)
