'use strict';
// Flags: --expose-internals

const common = require('../common');

if (!common.hasCrypto)
  common.skip('missing crypto');

const h2 = require('http2');
const net = require('net');
const { NghttpError } = require('internal/http2/util');
const h2test = require('../common/http2');
let client;

const server = h2.createServer();
server.on('stream', common.mustCall((stream) => {
  stream.respond();
  stream.end('ok');

  // The error will be emitted asynchronously
  stream.on('error', common.expectsError({
    type: NghttpError,
    code: 'ERR_HTTP2_ERROR',
    message: 'Stream was already closed or invalid'
  }));
}, 2));

server.on('session', common.mustCall((session) => {
  session.on('error', common.expectsError({
    code: 'ERR_HTTP2_ERROR',
    type: NghttpError,
    message: 'Stream was already closed or invalid'
  }));
}));

const settings = new h2test.SettingsFrame();
const settingsAck = new h2test.SettingsFrame(true);
const head1 = new h2test.HeadersFrame(1, h2test.kFakeRequestHeaders, 0, true);
const head2 = new h2test.HeadersFrame(3, h2test.kFakeRequestHeaders, 0, true);
const head3 = new h2test.HeadersFrame(1, h2test.kFakeRequestHeaders, 0, true);
const head4 = new h2test.HeadersFrame(5, h2test.kFakeRequestHeaders, 0, true);

server.listen(0, () => {
  client = net.connect(server.address().port, () => {
    client.write(h2test.kClientMagic, () => {
      client.write(settings.data, () => {
        client.write(settingsAck.data);
        // This will make it ok.
        client.write(head1.data, () => {
          // This will make it ok.
          client.write(head2.data, () => {
            // This will cause an error to occur because the client is
            // attempting to reuse an already closed stream. This must
            // cause the server session to be torn down.
            client.write(head3.data, () => {
              // This won't ever make it to the server
              client.write(head4.data);
            });
          });
        });
      });
    });
  });

  // An error may or may not be emitted on the client side, we don't care
  // either way if it is, but we don't want to die if it is.
  client.on('error', () => {});
  client.on('close', common.mustCall(() => server.close()));
  client.resume();
});
