// Copyright 2019 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef V8_TOOLS_DEBUG_HELPER_HEAP_CONSTANTS_H_
#define V8_TOOLS_DEBUG_HELPER_HEAP_CONSTANTS_H_

#include <cstdint>
#include <string>

#include "debug-helper.h"

namespace d = v8::debug_helper;

namespace v8_debug_helper_internal {

// Functions generated by mkgrokdump:
std::string FindKnownObjectInOldSpace(uintptr_t offset);
std::string FindKnownObjectInReadOnlySpace(uintptr_t offset);
std::string FindKnownObjectInMapSpace(uintptr_t offset);
std::string FindKnownMapInstanceTypeInMapSpace(uintptr_t offset);
std::string FindKnownMapInstanceTypeInReadOnlySpace(uintptr_t offset);

std::string FindKnownObject(uintptr_t address, const d::Roots& roots);

}  // namespace v8_debug_helper_internal

#endif
