# Node.js 12 ChangeLog

<!--lint disable prohibited-strings-->
<!--lint disable maximum-line-length-->

<table>
<tr>
<th>Current</th>
</tr>
<tr>
<td>
<a href="#12.4.0">12.4.0</a><br/>
<a href="#12.3.1">12.3.1</a><br/>
<a href="#12.3.0">12.3.0</a><br/>
<a href="#12.2.0">12.2.0</a><br/>
<a href="#12.1.0">12.1.0</a><br/>
<a href="#12.0.0">12.0.0</a><br/>
</td>
</tr>
</table>

* Other Versions
  * [11.x](CHANGELOG_V11.md)
  * [10.x](CHANGELOG_V10.md)
  * [9.x](CHANGELOG_V9.md)
  * [8.x](CHANGELOG_V8.md)
  * [7.x](CHANGELOG_V7.md)
  * [6.x](CHANGELOG_V6.md)
  * [5.x](CHANGELOG_V5.md)
  * [4.x](CHANGELOG_V4.md)
  * [0.12.x](CHANGELOG_V012.md)
  * [0.10.x](CHANGELOG_V010.md)
  * [io.js](CHANGELOG_IOJS.md)
  * [Archive](CHANGELOG_ARCHIVE.md)

<a id="12.4.0"></a>
## 2019-06-04, Version 12.4.0 (Current), @targos

### Notable changes

* **doc**:
  * The JSON variant of the API documentation is no longer experimental (Rich Trott) [#27842](https://github.com/nodejs/node/pull/27842).
* **esm**:
  * JSON module support is always enabled under `--experimental-modules`. The
    `--experimental-json-modules` flag has been removed (Myles Borins) [#27752](https://github.com/nodejs/node/pull/27752).
* **http,http2**:
  * A new flag has been added for overriding the default HTTP server socket
    timeout (which is two minutes). Pass `--http-server-default-timeout=milliseconds`
    or `--http-server-default-timeout=0` to respectively change or disable the timeout.
    Starting with Node.js 13.0.0, the timeout will be disabled by default (Ali Ijaz Sheikh) [#27704](https://github.com/nodejs/node/pull/27704).
* **inspector**:
  * Added an experimental `--heap-prof` flag to start the V8 heap profiler
    on startup and write the heap profile to disk before exit (Joyee Cheung) [#27596](https://github.com/nodejs/node/pull/27596).
* **stream**:
  * The `readable.unshift()` method now correctly converts strings to buffers.
    Additionally, a new optional argument is accepted to specify the string's
    encoding, such as `'utf8'` or `'ascii'` (Marcos Casagrande) [#27194](https://github.com/nodejs/node/pull/27194).
* **v8**:
  * The object returned by `v8.getHeapStatistics()` has two new properties:
    `number_of_native_contexts` and `number_of_detached_contexts` (Yuriy Vasiyarov) [#27933](https://github.com/nodejs/node/pull/27933).

### Commits

* [[`5bbc6d79c3`](https://github.com/nodejs/node/commit/5bbc6d79c3)] - **assert**: remove unreachable code (Rich Trott) [#27840](https://github.com/nodejs/node/pull/27840)
* [[`530e63a4eb`](https://github.com/nodejs/node/commit/530e63a4eb)] - **assert**: remove unreachable code (Rich Trott) [#27786](https://github.com/nodejs/node/pull/27786)
* [[`9b08c458be`](https://github.com/nodejs/node/commit/9b08c458be)] - **build,aix**: link with `noerrmsg` to eliminate warnings (Refael Ackermann) [#27773](https://github.com/nodejs/node/pull/27773)
* [[`08b0ca9645`](https://github.com/nodejs/node/commit/08b0ca9645)] - **build,win**: create junction instead of symlink to `out\\%config%` (Refael Ackermann) [#27736](https://github.com/nodejs/node/pull/27736)
* [[`ea2d550507`](https://github.com/nodejs/node/commit/ea2d550507)] - **child_process**: move exports to bottom for consistent code style (himself65) [#27845](https://github.com/nodejs/node/pull/27845)
* [[`a9f95572c3`](https://github.com/nodejs/node/commit/a9f95572c3)] - **child_process**: remove extra shallow copy (zero1five) [#27801](https://github.com/nodejs/node/pull/27801)
* [[`449ee8dd42`](https://github.com/nodejs/node/commit/449ee8dd42)] - **console**: fix table() output (Brian White) [#27917](https://github.com/nodejs/node/pull/27917)
* [[`9220a68a76`](https://github.com/nodejs/node/commit/9220a68a76)] - **crypto**: fix KeyObject handle type error message (Alexander Avakov) [#27904](https://github.com/nodejs/node/pull/27904)
* [[`3b6424fa29`](https://github.com/nodejs/node/commit/3b6424fa29)] - **deps**: histogram: unexport symbols (Ben Noordhuis) [#27779](https://github.com/nodejs/node/pull/27779)
* [[`ef25ac5223`](https://github.com/nodejs/node/commit/ef25ac5223)] - **doc**: clarify wording in modules.md (Alex Temny) [#27853](https://github.com/nodejs/node/pull/27853)
* [[`c683cd99d7`](https://github.com/nodejs/node/commit/c683cd99d7)] - **doc**: improve explanation for directory with fs.rename() (Rich Trott) [#27963](https://github.com/nodejs/node/pull/27963)
* [[`70b485478c`](https://github.com/nodejs/node/commit/70b485478c)] - **doc**: fix the wrong name of AssertionError (Kyle Zhang) [#27982](https://github.com/nodejs/node/pull/27982)
* [[`11c3ddb4cb`](https://github.com/nodejs/node/commit/11c3ddb4cb)] - **doc**: simplify system call material in doc overview (Rich Trott) [#27966](https://github.com/nodejs/node/pull/27966)
* [[`c56640138a`](https://github.com/nodejs/node/commit/c56640138a)] - **doc**: warn about relying on fs gc close behavior (Benjamin Gruenbaum) [#27972](https://github.com/nodejs/node/pull/27972)
* [[`bab9f5a891`](https://github.com/nodejs/node/commit/bab9f5a891)] - **doc**: add information to revoked deprecations (cjihrig) [#27952](https://github.com/nodejs/node/pull/27952)
* [[`f4fc75d245`](https://github.com/nodejs/node/commit/f4fc75d245)] - **doc**: add missing status to DEP0121 (cjihrig) [#27950](https://github.com/nodejs/node/pull/27950)
* [[`77ff597faa`](https://github.com/nodejs/node/commit/77ff597faa)] - **doc**: add missing --experimental-wasm-modules docs (cjihrig) [#27948](https://github.com/nodejs/node/pull/27948)
* [[`6ca4f03ccf`](https://github.com/nodejs/node/commit/6ca4f03ccf)] - **doc**: revise additional Experimental status text (Rich Trott) [#27931](https://github.com/nodejs/node/pull/27931)
* [[`a1788de0a4`](https://github.com/nodejs/node/commit/a1788de0a4)] - **doc**: adds link to nightly code coverage report (Tariq Ramlall) [#27922](https://github.com/nodejs/node/pull/27922)
* [[`b7cd0de145`](https://github.com/nodejs/node/commit/b7cd0de145)] - **doc**: fix typo in pipe from async iterator example (Luigi Pinca) [#27870](https://github.com/nodejs/node/pull/27870)
* [[`f621b8f178`](https://github.com/nodejs/node/commit/f621b8f178)] - **doc**: reword Experimental stability index (Rich Trott) [#27879](https://github.com/nodejs/node/pull/27879)
* [[`7a7fc4e7e6`](https://github.com/nodejs/node/commit/7a7fc4e7e6)] - **doc**: update n-api support matrix (teams2ua) [#27567](https://github.com/nodejs/node/pull/27567)
* [[`9d9b32eff5`](https://github.com/nodejs/node/commit/9d9b32eff5)] - **doc**: fix for OutgoingMessage.prototype.\_headers/\_headerNames (Daniel Nalborczyk) [#27574](https://github.com/nodejs/node/pull/27574)
* [[`263e53317b`](https://github.com/nodejs/node/commit/263e53317b)] - **doc**: reposition "How to Contribute" README section (Anish Asrani) [#27811](https://github.com/nodejs/node/pull/27811)
* [[`85f505c292`](https://github.com/nodejs/node/commit/85f505c292)] - **doc**: add version info for types (Michael Dawson) [#27754](https://github.com/nodejs/node/pull/27754)
* [[`e3bb2aef60`](https://github.com/nodejs/node/commit/e3bb2aef60)] - **doc**: remove experimental status for JSON documentation (Rich Trott) [#27842](https://github.com/nodejs/node/pull/27842)
* [[`6981565c20`](https://github.com/nodejs/node/commit/6981565c20)] - **doc**: edit stability index overview (Rich Trott) [#27831](https://github.com/nodejs/node/pull/27831)
* [[`1a8e67cc1f`](https://github.com/nodejs/node/commit/1a8e67cc1f)] - **doc**: simplify contributing documentation (Rich Trott) [#27785](https://github.com/nodejs/node/pull/27785)
* [[`041b2220be`](https://github.com/nodejs/node/commit/041b2220be)] - **doc,n-api**: fix typo in N-API introduction (Richard Lau) [#27833](https://github.com/nodejs/node/pull/27833)
* [[`6cd64c8279`](https://github.com/nodejs/node/commit/6cd64c8279)] - **doc,test**: clarify that Http2Stream is destroyed after data is read (Alba Mendez) [#27891](https://github.com/nodejs/node/pull/27891)
* [[`cc69d5af8e`](https://github.com/nodejs/node/commit/cc69d5af8e)] - **doc,tools**: get altDocs versions from CHANGELOG.md (Richard Lau) [#27661](https://github.com/nodejs/node/pull/27661)
* [[`e72d4aa522`](https://github.com/nodejs/node/commit/e72d4aa522)] - **errors**: create internal connResetException (Rich Trott) [#27953](https://github.com/nodejs/node/pull/27953)
* [[`be1166fd01`](https://github.com/nodejs/node/commit/be1166fd01)] - **esm**: refactor createDynamicModule() (cjihrig) [#27809](https://github.com/nodejs/node/pull/27809)
* [[`e66648e887`](https://github.com/nodejs/node/commit/e66648e887)] - **(SEMVER-MINOR)** **esm**: remove experimental status from JSON modules (Myles Borins) [#27752](https://github.com/nodejs/node/pull/27752)
* [[`d948656635`](https://github.com/nodejs/node/commit/d948656635)] - **http**: fix deferToConnect comments (Robert Nagy) [#27876](https://github.com/nodejs/node/pull/27876)
* [[`24eaeed393`](https://github.com/nodejs/node/commit/24eaeed393)] - **http**: fix socketOnWrap edge cases (Anatoli Papirovski) [#27968](https://github.com/nodejs/node/pull/27968)
* [[`8b38dfbf39`](https://github.com/nodejs/node/commit/8b38dfbf39)] - **http**: call write callback even if there is no message body (Luigi Pinca) [#27777](https://github.com/nodejs/node/pull/27777)
* [[`588fd0c20d`](https://github.com/nodejs/node/commit/588fd0c20d)] - **(SEMVER-MINOR)** **http, http2**: flag for overriding server timeout (Ali Ijaz Sheikh) [#27704](https://github.com/nodejs/node/pull/27704)
* [[`799aeca134`](https://github.com/nodejs/node/commit/799aeca134)] - **http2**: respect inspect() depth (cjihrig) [#27983](https://github.com/nodejs/node/pull/27983)
* [[`83aaef87d0`](https://github.com/nodejs/node/commit/83aaef87d0)] - **http2**: fix tracking received data for maxSessionMemory (Anna Henningsen) [#27914](https://github.com/nodejs/node/pull/27914)
* [[`8c35198499`](https://github.com/nodejs/node/commit/8c35198499)] - **http2**: support net.Server options (Luigi Pinca) [#27782](https://github.com/nodejs/node/pull/27782)
* [[`23119cacf8`](https://github.com/nodejs/node/commit/23119cacf8)] - **inspector**: supported NodeRuntime domain in worker (Aleksei Koziatinskii) [#27706](https://github.com/nodejs/node/pull/27706)
* [[`89483be254`](https://github.com/nodejs/node/commit/89483be254)] - **inspector**: more conservative minimum stack size (Ben Noordhuis) [#27855](https://github.com/nodejs/node/pull/27855)
* [[`512ab1fddf`](https://github.com/nodejs/node/commit/512ab1fddf)] - **inspector**: removing checking of non existent field in lib/inspector.js (Keroosha) [#27919](https://github.com/nodejs/node/pull/27919)
* [[`d99e70381e`](https://github.com/nodejs/node/commit/d99e70381e)] - **SEMVER-MINOR** **inspector**: implement --heap-prof (Joyee Cheung) [#27596](https://github.com/nodejs/node/pull/27596)
* [[`25eb05a97a`](https://github.com/nodejs/node/commit/25eb05a97a)] - **lib**: removed unnecessary fs.realpath `options` arg check + tests (Alex Pry) [#27909](https://github.com/nodejs/node/pull/27909)
* [[`9b90385825`](https://github.com/nodejs/node/commit/9b90385825)] - ***Revert*** "**lib**: print to stdout/stderr directly instead of using console" (Richard Lau) [#27823](https://github.com/nodejs/node/pull/27823)
* [[`18650579e8`](https://github.com/nodejs/node/commit/18650579e8)] - **meta**: correct personal info (Refael Ackermann (רפאל פלחי)) [#27940](https://github.com/nodejs/node/pull/27940)
* [[`d982f0b7e2`](https://github.com/nodejs/node/commit/d982f0b7e2)] - **meta**: create github support file (Gus Caplan) [#27926](https://github.com/nodejs/node/pull/27926)
* [[`2b7ad122b2`](https://github.com/nodejs/node/commit/2b7ad122b2)] - **n-api**: DRY napi\_coerce\_to\_x() API methods (Ben Noordhuis) [#27796](https://github.com/nodejs/node/pull/27796)
* [[`1da5acbf91`](https://github.com/nodejs/node/commit/1da5acbf91)] - **os**: assume UTF-8 for hostname (Anna Henningsen) [#27849](https://github.com/nodejs/node/pull/27849)
* [[`d406785814`](https://github.com/nodejs/node/commit/d406785814)] - **src**: unimplement deprecated v8-platform methods (Michaël Zasso) [#27872](https://github.com/nodejs/node/pull/27872)
* [[`33236b7c54`](https://github.com/nodejs/node/commit/33236b7c54)] - **(SEMVER-MINOR)** **src**: export number\_of\_native\_contexts and number\_of\_detached\_contexts (Yuriy Vasiyarov) [#27933](https://github.com/nodejs/node/pull/27933)
* [[`1a179e1736`](https://github.com/nodejs/node/commit/1a179e1736)] - **src**: use ArrayBufferViewContents more frequently (Anna Henningsen) [#27920](https://github.com/nodejs/node/pull/27920)
* [[`b9cc4072e6`](https://github.com/nodejs/node/commit/b9cc4072e6)] - **src**: make UNREACHABLE variadic (Refael Ackermann) [#27877](https://github.com/nodejs/node/pull/27877)
* [[`44846aebd2`](https://github.com/nodejs/node/commit/44846aebd2)] - **src**: move DiagnosticFilename inlines into a -inl.h (Sam Roberts) [#27839](https://github.com/nodejs/node/pull/27839)
* [[`d774ea5cce`](https://github.com/nodejs/node/commit/d774ea5cce)] - **src**: remove env-inl.h from header files (Sam Roberts) [#27755](https://github.com/nodejs/node/pull/27755)
* [[`02f794a53f`](https://github.com/nodejs/node/commit/02f794a53f)] - **src**: remove memory\_tracker-inl.h from header files (Sam Roberts) [#27755](https://github.com/nodejs/node/pull/27755)
* [[`940577bd76`](https://github.com/nodejs/node/commit/940577bd76)] - **src**: move ThreadPoolWork inlines into a -inl.h (Sam Roberts) [#27755](https://github.com/nodejs/node/pull/27755)
* [[`c0cf17388c`](https://github.com/nodejs/node/commit/c0cf17388c)] - **src**: ignore SIGXFSZ, don't terminate (ulimit -f) (Ben Noordhuis) [#27798](https://github.com/nodejs/node/pull/27798)
* [[`a47ee80114`](https://github.com/nodejs/node/commit/a47ee80114)] - **(SEMVER-MINOR)** **stream**: convert string to Buffer when calling `unshift(\<string\>)` (Marcos Casagrande) [#27194](https://github.com/nodejs/node/pull/27194)
* [[`5eccd642ef`](https://github.com/nodejs/node/commit/5eccd642ef)] - **stream**: convert existing buffer when calling .setEncoding (Anna Henningsen) [#27936](https://github.com/nodejs/node/pull/27936)
* [[`6a5ce36fb8`](https://github.com/nodejs/node/commit/6a5ce36fb8)] - **test**: handle unknown message type in worker threads (Rich Trott) [#27995](https://github.com/nodejs/node/pull/27995)
* [[`182725651b`](https://github.com/nodejs/node/commit/182725651b)] - **test**: add coverage for unserializable worker thread error (Rich Trott) [#27995](https://github.com/nodejs/node/pull/27995)
* [[`887dd604f1`](https://github.com/nodejs/node/commit/887dd604f1)] - **test**: simplify fs promises test (Daniel Nalborczyk) [#27242](https://github.com/nodejs/node/pull/27242)
* [[`9229825496`](https://github.com/nodejs/node/commit/9229825496)] - **test**: covering destroying when worker already disconnected (Keroosha) [#27896](https://github.com/nodejs/node/pull/27896)
* [[`10bdd13972`](https://github.com/nodejs/node/commit/10bdd13972)] - **test**: rename test-performance to test-perf-hooks (Ujjwal Sharma) [#27969](https://github.com/nodejs/node/pull/27969)
* [[`6129376cd9`](https://github.com/nodejs/node/commit/6129376cd9)] - **test**: add coverage for sparse array maxArrayLength (went.out) [#27901](https://github.com/nodejs/node/pull/27901)
* [[`38e3827ca8`](https://github.com/nodejs/node/commit/38e3827ca8)] - **test**: add util inspect null getter test (Mikhail Kuklin) [#27884](https://github.com/nodejs/node/pull/27884)
* [[`0e1ce2055e`](https://github.com/nodejs/node/commit/0e1ce2055e)] - **test**: rsa-pss generateKeyPairSync invalid option hash (Evgenii Shchepotev) [#27883](https://github.com/nodejs/node/pull/27883)
* [[`0d74198123`](https://github.com/nodejs/node/commit/0d74198123)] - **test**: cover import of a \*.node file with a policy manifest (Evgenii Shchepotev) [#27903](https://github.com/nodejs/node/pull/27903)
* [[`6f9aa3f722`](https://github.com/nodejs/node/commit/6f9aa3f722)] - **test**: add test cases for paramEncoding 'explicit' (oksana) [#27900](https://github.com/nodejs/node/pull/27900)
* [[`682319f449`](https://github.com/nodejs/node/commit/682319f449)] - **test**: switch assertEqual arguments (Evgenii Shchepotev) [#27910](https://github.com/nodejs/node/pull/27910)
* [[`b5b234deff`](https://github.com/nodejs/node/commit/b5b234deff)] - **test**: add testcase for SourceTextModule custom inspect (Grigory Gorshkov) [#27889](https://github.com/nodejs/node/pull/27889)
* [[`630cc3ac30`](https://github.com/nodejs/node/commit/630cc3ac30)] - **test**: cover util.inspect on boxed primitive with colors (Alexander Avakov) [#27897](https://github.com/nodejs/node/pull/27897)
* [[`67b692bdb9`](https://github.com/nodejs/node/commit/67b692bdb9)] - **test**: add test case for checking typeof mgf1Hash (Levin Eugene) [#27892](https://github.com/nodejs/node/pull/27892)
* [[`2a509d40f4`](https://github.com/nodejs/node/commit/2a509d40f4)] - **test**: switch assertEqual arguments (Evgenii Shchepotev) [#27912](https://github.com/nodejs/node/pull/27912)
* [[`3ba354aaaa`](https://github.com/nodejs/node/commit/3ba354aaaa)] - **test**: add test for util.inspect (Levin Eugene) [#27906](https://github.com/nodejs/node/pull/27906)
* [[`313077ea62`](https://github.com/nodejs/node/commit/313077ea62)] - **test**: expect wpt/encoding/encodeInto.any.js to fail (Joyee Cheung) [#27860](https://github.com/nodejs/node/pull/27860)
* [[`8fc6914d09`](https://github.com/nodejs/node/commit/8fc6914d09)] - **test**: update wpt/encoding to 7287608f90 (Joyee Cheung) [#27860](https://github.com/nodejs/node/pull/27860)
* [[`0f86c2b185`](https://github.com/nodejs/node/commit/0f86c2b185)] - **test**: run WPT in subdirectories (Joyee Cheung) [#27860](https://github.com/nodejs/node/pull/27860)
* [[`51ccdae445`](https://github.com/nodejs/node/commit/51ccdae445)] - **test**: expect wpt/encoding/streams to fail (Joyee Cheung) [#27860](https://github.com/nodejs/node/pull/27860)
* [[`652cadba1c`](https://github.com/nodejs/node/commit/652cadba1c)] - **test**: fix arguments order of comparsion functions (martyns0n) [#27907](https://github.com/nodejs/node/pull/27907)
* [[`b117f6d5d8`](https://github.com/nodejs/node/commit/b117f6d5d8)] - **test**: switch assertEqual arguments (Evgenii Shchepotev) [#27913](https://github.com/nodejs/node/pull/27913)
* [[`e7966bcb80`](https://github.com/nodejs/node/commit/e7966bcb80)] - **test**: unhardcode server port (MurkyMeow) [#27908](https://github.com/nodejs/node/pull/27908)
* [[`b83571d236`](https://github.com/nodejs/node/commit/b83571d236)] - **test**: add a test case for the path.posix.resolve (Grigorii K. Shartsev) [#27905](https://github.com/nodejs/node/pull/27905)
* [[`f5bb1b380f`](https://github.com/nodejs/node/commit/f5bb1b380f)] - **test**: switch actual value argument and expected in deepStrictEqual call (Kopachyov Vitaliy) [#27888](https://github.com/nodejs/node/pull/27888)
* [[`531669b917`](https://github.com/nodejs/node/commit/531669b917)] - **test**: fix test-http2-multiheaders-raw (Grigorii K. Shartsev) [#27885](https://github.com/nodejs/node/pull/27885)
* [[`724d9c89bc`](https://github.com/nodejs/node/commit/724d9c89bc)] - **test**: change expected and actual values in assert call (oksana) [#27881](https://github.com/nodejs/node/pull/27881)
* [[`34ef9e4a2b`](https://github.com/nodejs/node/commit/34ef9e4a2b)] - **test**: detect missing postmortem metadata (cjihrig) [#27828](https://github.com/nodejs/node/pull/27828)
* [[`bfcbab4c0c`](https://github.com/nodejs/node/commit/bfcbab4c0c)] - **test**: fix test-https-agent-additional-options (Rich Trott) [#27830](https://github.com/nodejs/node/pull/27830)
* [[`a4c1fd5ffc`](https://github.com/nodejs/node/commit/a4c1fd5ffc)] - **test**: refactor test-https-agent-additional-options (Rich Trott) [#27830](https://github.com/nodejs/node/pull/27830)
* [[`17abc8c942`](https://github.com/nodejs/node/commit/17abc8c942)] - **test**: favor arrow functions for anonymous callbacks (Rich Trott) [#27830](https://github.com/nodejs/node/pull/27830)
* [[`155b947251`](https://github.com/nodejs/node/commit/155b947251)] - **test**: replace flag with option (Rich Trott) [#27830](https://github.com/nodejs/node/pull/27830)
* [[`144db48b6d`](https://github.com/nodejs/node/commit/144db48b6d)] - **test**: update wpt/url to 418f7fabeb (Joyee Cheung) [#27822](https://github.com/nodejs/node/pull/27822)
* [[`65d4f734e0`](https://github.com/nodejs/node/commit/65d4f734e0)] - **test**: use ShellTestEnvironment in WPT (Joyee Cheung) [#27822](https://github.com/nodejs/node/pull/27822)
* [[`a9a400e604`](https://github.com/nodejs/node/commit/a9a400e604)] - **test**: update wpt/resources to e1fddfbf80 (Joyee Cheung) [#27822](https://github.com/nodejs/node/pull/27822)
* [[`8040d8b321`](https://github.com/nodejs/node/commit/8040d8b321)] - **test**: increase debugging information on failure (Rich Trott) [#27790](https://github.com/nodejs/node/pull/27790)
* [[`6548b91835`](https://github.com/nodejs/node/commit/6548b91835)] - **tls**: trace errors can show up as SSL errors (Sam Roberts) [#27841](https://github.com/nodejs/node/pull/27841)
* [[`0fe16edfab`](https://github.com/nodejs/node/commit/0fe16edfab)] - **tls**: group chunks into TLS segments (Alba Mendez) [#27861](https://github.com/nodejs/node/pull/27861)
* [[`e8fa0671a4`](https://github.com/nodejs/node/commit/e8fa0671a4)] - **tls**: destroy trace BIO instead of leaking it (Sam Roberts) [#27834](https://github.com/nodejs/node/pull/27834)
* [[`10e0d7f2ac`](https://github.com/nodejs/node/commit/10e0d7f2ac)] - **tls**: support the hints option (Luigi Pinca) [#27816](https://github.com/nodejs/node/pull/27816)
* [[`4716caa12e`](https://github.com/nodejs/node/commit/4716caa12e)] - **tls**: set tlsSocket.servername as early as possible (oyyd) [#27759](https://github.com/nodejs/node/pull/27759)
* [[`2ce24a9452`](https://github.com/nodejs/node/commit/2ce24a9452)] - **tools**: fix js2c regression (Refael Ackermann) [#27980](https://github.com/nodejs/node/pull/27980)
* [[`a75a59d3e3`](https://github.com/nodejs/node/commit/a75a59d3e3)] - **tools**: update inspector\_protocol to 0aafd2 (Michaël Zasso) [#27770](https://github.com/nodejs/node/pull/27770)
* [[`728bc2f59a`](https://github.com/nodejs/node/commit/728bc2f59a)] - **tools**: update dependencies in tools/doc (Rich Trott) [#27927](https://github.com/nodejs/node/pull/27927)
* [[`b54f3e0405`](https://github.com/nodejs/node/commit/b54f3e0405)] - **tools**: edit .eslintrc.js for minor maintainability improvements (Rich Trott) [#27789](https://github.com/nodejs/node/pull/27789)

<a id="12.3.1"></a>
## 2019-05-22, Version 12.3.1 (Current), @BridgeAR

### Notable changes

* **deps**:
  * Fix handling of +0/-0 when constant field tracking is enabled (Michaël Zasso) [#27792](https://github.com/nodejs/node/pull/27792)
  * Fix `os.freemem()` and `os.totalmem` correctness (cjihrig) [#27718](https://github.com/nodejs/node/pull/27718)
* **src**:
  * Fix v12.3.0 regression that prevents native addons from compiling [#27804](https://github.com/nodejs/node/pull/27804)

### Commits

* [[`c478884725`](https://github.com/nodejs/node/commit/c478884725)] - **deps**: V8: cherry-pick 94c87fe (Michaël Zasso) [#27792](https://github.com/nodejs/node/pull/27792)
* [[`aed74ccb4c`](https://github.com/nodejs/node/commit/aed74ccb4c)] - **deps**: upgrade to libuv 1.29.1 (cjihrig) [#27718](https://github.com/nodejs/node/pull/27718)
* [[`7438a557af`](https://github.com/nodejs/node/commit/7438a557af)] - **src**: remove util-inl.h include in node.h (Anna Henningsen) [#27804](https://github.com/nodejs/node/pull/27804)
* [[`6f7005465a`](https://github.com/nodejs/node/commit/6f7005465a)] - **src, lib**: take control of prepareStackTrace (Gus Caplan) [#23926](https://github.com/nodejs/node/pull/23926)

<a id="12.3.0"></a>
## 2019-05-21, Version 12.3.0 (Current), @BridgeAR

### Notable changes

* **esm**:
  * Added the `--experimental-wasm-modules` flag to support WebAssembly modules (Myles Borins & Guy Bedford) [#27659](https://github.com/nodejs/node/pull/27659)
* **process**:
  * Log errors using `util.inspect` in case of fatal exceptions (Ruben Bridgewater) [#27243](https://github.com/nodejs/node/pull/27243)
* **repl**:
  * Add `process.on('uncaughtException')` support (Ruben Bridgewater) [#27151](https://github.com/nodejs/node/pull/27151)
* **stream**:
  * Implemented `Readable.from` async iterator utility (Guy Bedford) [#27660](https://github.com/nodejs/node/pull/27660)
* **tls**:
  * Expose built-in root certificates (Ben Noordhuis) [#26415](https://github.com/nodejs/node/pull/26415)
  * Support `net.Server` options (Luigi Pinca) [#27665](https://github.com/nodejs/node/pull/27665)
  * Expose `keylog` event on TLSSocket (Alba Mendez) [#27654](https://github.com/nodejs/node/pull/27654)
* **worker**:
  * Added the ability to unshift messages from the `MessagePort` (Anna Henningsen) [#27294](https://github.com/nodejs/node/pull/27294)

### Commits

* [[`7cc21d8afa`](https://github.com/nodejs/node/commit/7cc21d8afa)] - **assert**: remove unused code (Ruben Bridgewater) [#27676](https://github.com/nodejs/node/pull/27676)
* [[`6983a0c336`](https://github.com/nodejs/node/commit/6983a0c336)] - **assert**: add compatibility for older Node.js versions (Ruben Bridgewater) [#27672](https://github.com/nodejs/node/pull/27672)
* [[`493ead144d`](https://github.com/nodejs/node/commit/493ead144d)] - **assert**: loose deep equal should not compare symbol properties (Ruben Bridgewater) [#27653](https://github.com/nodejs/node/pull/27653)
* [[`ec642f18cc`](https://github.com/nodejs/node/commit/ec642f18cc)] - **assert**: use less read operations (Ruben Bridgewater) [#27525](https://github.com/nodejs/node/pull/27525)
* [[`3367bad080`](https://github.com/nodejs/node/commit/3367bad080)] - **assert**: refine assertion message (Ruben Bridgewater) [#27525](https://github.com/nodejs/node/pull/27525)
* [[`e573c99bfd`](https://github.com/nodejs/node/commit/e573c99bfd)] - **assert**: fix `assert.fail()` stack (Ruben Bridgewater) [#27525](https://github.com/nodejs/node/pull/27525)
* [[`6070e8872d`](https://github.com/nodejs/node/commit/6070e8872d)] - **async_hooks**: don't reuse resource in HttpAgent (Gerhard Stoebich) [#27581](https://github.com/nodejs/node/pull/27581)
* [[`e74e661044`](https://github.com/nodejs/node/commit/e74e661044)] - **async_hooks**: only disable promise hook if wanted (Anna Henningsen) [#27590](https://github.com/nodejs/node/pull/27590)
* [[`026bebfcbc`](https://github.com/nodejs/node/commit/026bebfcbc)] - **bootstrap**: --frozen-intrinsics unfreeze console (Guy Bedford) [#27663](https://github.com/nodejs/node/pull/27663)
* [[`e0589006a8`](https://github.com/nodejs/node/commit/e0589006a8)] - **build**: add arm64 to vcbuild.bat help message (Jon Kunkee) [#27683](https://github.com/nodejs/node/pull/27683)
* [[`766a731137`](https://github.com/nodejs/node/commit/766a731137)] - **build**: export OpenSSL UI symbols (Sam Roberts) [#27586](https://github.com/nodejs/node/pull/27586)
* [[`2bc177aa4f`](https://github.com/nodejs/node/commit/2bc177aa4f)] - **child_process**: setup stdio on error when possible (cjihrig) [#27696](https://github.com/nodejs/node/pull/27696)
* [[`b380c0f311`](https://github.com/nodejs/node/commit/b380c0f311)] - **child_process**: refactor stdioStringToArray function (zero1five) [#27657](https://github.com/nodejs/node/pull/27657)
* [[`da102cda54`](https://github.com/nodejs/node/commit/da102cda54)] - **console**: don't attach unnecessary error handlers (cjihrig) [#27691](https://github.com/nodejs/node/pull/27691)
* [[`83f243038f`](https://github.com/nodejs/node/commit/83f243038f)] - **deps**: V8: cherry-pick cca9ae3c9a (Benedikt Meurer) [#27729](https://github.com/nodejs/node/pull/27729)
* [[`750556dcfd`](https://github.com/nodejs/node/commit/750556dcfd)] - **deps**: update OpenSSL configs' timestamps (Jon Kunkee) [#27544](https://github.com/nodejs/node/pull/27544)
* [[`314fdda0c3`](https://github.com/nodejs/node/commit/314fdda0c3)] - **deps**: regenerate OpenSSL configs with fixed tooling (Jon Kunkee) [#27544](https://github.com/nodejs/node/pull/27544)
* [[`c7e5fca32c`](https://github.com/nodejs/node/commit/c7e5fca32c)] - **deps**: make VC-WIN config generation deterministic (Jon Kunkee) [#27543](https://github.com/nodejs/node/pull/27543)
* [[`76c9e86609`](https://github.com/nodejs/node/commit/76c9e86609)] - **deps**: patch V8 to 7.4.288.27 (Matheus Marchini) [#27615](https://github.com/nodejs/node/pull/27615)
* [[`9f5b6900e7`](https://github.com/nodejs/node/commit/9f5b6900e7)] - **doc**: corrected tlsSocket.getPeerCertificate response type (Dan Beglin) [#27757](https://github.com/nodejs/node/pull/27757)
* [[`d1da11765d`](https://github.com/nodejs/node/commit/d1da11765d)] - **doc**: correct parameter type on 'subprocess.kill(\[signal\])' (himself65) [#27760](https://github.com/nodejs/node/pull/27760)
* [[`7e750868c6`](https://github.com/nodejs/node/commit/7e750868c6)] - **doc**: replace createRequireFromPath() references (cjihrig) [#27762](https://github.com/nodejs/node/pull/27762)
* [[`55fe340dc2`](https://github.com/nodejs/node/commit/55fe340dc2)] - **doc**: improve createRequire() example (cjihrig) [#27762](https://github.com/nodejs/node/pull/27762)
* [[`378f44c2ed`](https://github.com/nodejs/node/commit/378f44c2ed)] - **doc**: update `util.format` formatters documentation (Ruben Bridgewater) [#27621](https://github.com/nodejs/node/pull/27621)
* [[`f663e74d0b`](https://github.com/nodejs/node/commit/f663e74d0b)] - **doc**: remove stability highlight for stable functions (Michael Dawson) [#27753](https://github.com/nodejs/node/pull/27753)
* [[`cf516f7b6a`](https://github.com/nodejs/node/commit/cf516f7b6a)] - **doc**: rewrite "About this Documentation" section (Rich Trott) [#27725](https://github.com/nodejs/node/pull/27725)
* [[`df01645c7c`](https://github.com/nodejs/node/commit/df01645c7c)] - **doc**: correct entry for electron v4.0.4 (Jacob) [#27394](https://github.com/nodejs/node/pull/27394)
* [[`1f7a527f04`](https://github.com/nodejs/node/commit/1f7a527f04)] - **doc**: clarify behavior of fs.mkdir (Gaelan) [#27505](https://github.com/nodejs/node/pull/27505)
* [[`d570995427`](https://github.com/nodejs/node/commit/d570995427)] - **doc**: remove non-existent entry-type flag (dnalborczyk) [#27678](https://github.com/nodejs/node/pull/27678)
* [[`da4a3797cb`](https://github.com/nodejs/node/commit/da4a3797cb)] - **doc**: format correction for experimental loader hooks (Daniel Nalborczyk) [#27537](https://github.com/nodejs/node/pull/27537)
* [[`cc45080109`](https://github.com/nodejs/node/commit/cc45080109)] - **doc**: dns.lookup() documentation error code (jvelezpo) [#27625](https://github.com/nodejs/node/pull/27625)
* [[`7923b4a407`](https://github.com/nodejs/node/commit/7923b4a407)] - **doc**: add call-once note to napi\_queue\_async\_work (Gabriel Schulhof) [#27582](https://github.com/nodejs/node/pull/27582)
* [[`8d448be9fd`](https://github.com/nodejs/node/commit/8d448be9fd)] - **doc**: simplify test/README.md (Rich Trott) [#27630](https://github.com/nodejs/node/pull/27630)
* [[`172fa639a6`](https://github.com/nodejs/node/commit/172fa639a6)] - **doc**: simplify About This Documentation text (Rich Trott) [#27619](https://github.com/nodejs/node/pull/27619)
* [[`66cf89f57d`](https://github.com/nodejs/node/commit/66cf89f57d)] - **doc**: move Rod Vagg to TSC emeritus (Rod Vagg) [#27633](https://github.com/nodejs/node/pull/27633)
* [[`8a1f2d0bfc`](https://github.com/nodejs/node/commit/8a1f2d0bfc)] - **doc**: doc deprecate the legacy http parser (cjihrig) [#27498](https://github.com/nodejs/node/pull/27498)
* [[`a23e86f029`](https://github.com/nodejs/node/commit/a23e86f029)] - **doc**: add Sam Roberts to TSC (Rod Vagg) [#27606](https://github.com/nodejs/node/pull/27606)
* [[`c53a674be7`](https://github.com/nodejs/node/commit/c53a674be7)] - **doc**: add example to test doc for clarity (Aditya Pratap Singh) [#27561](https://github.com/nodejs/node/pull/27561)
* [[`c0cdf30e6e`](https://github.com/nodejs/node/commit/c0cdf30e6e)] - **doc**: improve CCM example (Tobias Nießen) [#27396](https://github.com/nodejs/node/pull/27396)
* [[`b5498ed19b`](https://github.com/nodejs/node/commit/b5498ed19b)] - **doc,meta**: codify security release commit message (Richard Lau) [#27643](https://github.com/nodejs/node/pull/27643)
* [[`6e2c8d0e18`](https://github.com/nodejs/node/commit/6e2c8d0e18)] - **doc,n-api**: update N-API version matrix for v12.x (Richard Lau) [#27745](https://github.com/nodejs/node/pull/27745)
* [[`767889b0a3`](https://github.com/nodejs/node/commit/767889b0a3)] - **doc,n-api**: fix `introduced\_in` metadata (Richard Lau) [#27745](https://github.com/nodejs/node/pull/27745)
* [[`4ed8a9ba7e`](https://github.com/nodejs/node/commit/4ed8a9ba7e)] - **doc,tools**: updates for 6.x End-of-Life (Richard Lau) [#27658](https://github.com/nodejs/node/pull/27658)
* [[`80f30741bd`](https://github.com/nodejs/node/commit/80f30741bd)] - **esm**: use correct error arguments (cjihrig) [#27763](https://github.com/nodejs/node/pull/27763)
* [[`47f913bedc`](https://github.com/nodejs/node/commit/47f913bedc)] - **(SEMVER-MINOR)** **esm**: --experimental-wasm-modules integration support (Myles Borins) [#27659](https://github.com/nodejs/node/pull/27659)
* [[`89fda94b6a`](https://github.com/nodejs/node/commit/89fda94b6a)] - **esm**: fix esm load bug (ZYSzys) [#25491](https://github.com/nodejs/node/pull/25491)
* [[`1f935f899f`](https://github.com/nodejs/node/commit/1f935f899f)] - **events**: improve max listeners warning (Ruben Bridgewater) [#27694](https://github.com/nodejs/node/pull/27694)
* [[`6f23816bcf`](https://github.com/nodejs/node/commit/6f23816bcf)] - **fs**: extract path conversion and validation to getValidatedPath (ZYSzys) [#27656](https://github.com/nodejs/node/pull/27656)
* [[`206ae31a7e`](https://github.com/nodejs/node/commit/206ae31a7e)] - **http**: always call response.write() callback (Luigi Pinca) [#27709](https://github.com/nodejs/node/pull/27709)
* [[`bfb9356942`](https://github.com/nodejs/node/commit/bfb9356942)] - **http**: do not default to chunked encoding for TRACE (Luigi Pinca) [#27673](https://github.com/nodejs/node/pull/27673)
* [[`4a9af1778d`](https://github.com/nodejs/node/commit/4a9af1778d)] - **http**: add an alias at addListener on Server connection socket (himself65) [#27325](https://github.com/nodejs/node/pull/27325)
* [[`a66b391d20`](https://github.com/nodejs/node/commit/a66b391d20)] - **http2**: do no throw in writeHead if state.closed (Matteo Collina) [#27682](https://github.com/nodejs/node/pull/27682)
* [[`74046cee72`](https://github.com/nodejs/node/commit/74046cee72)] - **http2**: do not override the allowHalfOpen option (Luigi Pinca) [#27623](https://github.com/nodejs/node/pull/27623)
* [[`c7461567ce`](https://github.com/nodejs/node/commit/c7461567ce)] - **inspector**: mark profile type const (gengjiawen) [#27712](https://github.com/nodejs/node/pull/27712)
* [[`24b26c0687`](https://github.com/nodejs/node/commit/24b26c0687)] - **inspector**: fix typo (gengjiawen) [#27712](https://github.com/nodejs/node/pull/27712)
* [[`700459e008`](https://github.com/nodejs/node/commit/700459e008)] - **inspector**: added NodeRuntime domain (Aleksei Koziatinskii) [#27600](https://github.com/nodejs/node/pull/27600)
* [[`d2d3bf8b3b`](https://github.com/nodejs/node/commit/d2d3bf8b3b)] - **inspector**: code cleanup (Eugene Ostroukhov) [#27591](https://github.com/nodejs/node/pull/27591)
* [[`4dbebfd464`](https://github.com/nodejs/node/commit/4dbebfd464)] - **lib**: fix typo in pre\_execution.js (gengjiawen) [#27649](https://github.com/nodejs/node/pull/27649)
* [[`88b4d00fc6`](https://github.com/nodejs/node/commit/88b4d00fc6)] - **lib**: restore `global.module` after --eval code is run (Anna Henningsen) [#27587](https://github.com/nodejs/node/pull/27587)
* [[`3ac4a7122b`](https://github.com/nodejs/node/commit/3ac4a7122b)] - **meta**: move jhamhader to Collaborator Emeriti list (Rich Trott) [#27707](https://github.com/nodejs/node/pull/27707)
* [[`9f9871c4b2`](https://github.com/nodejs/node/commit/9f9871c4b2)] - **meta**: move chrisdickinson to Collaborator Emeriti list (Rich Trott) [#27703](https://github.com/nodejs/node/pull/27703)
* [[`2e85642f4a`](https://github.com/nodejs/node/commit/2e85642f4a)] - **meta**: move whitlockjc to Collaborator Emeriti list (Rich Trott) [#27702](https://github.com/nodejs/node/pull/27702)
* [[`fc8ad7731f`](https://github.com/nodejs/node/commit/fc8ad7731f)] - **meta**: move estliberitas to Collaborator Emeriti list (Rich Trott) [#27697](https://github.com/nodejs/node/pull/27697)
* [[`ea62149212`](https://github.com/nodejs/node/commit/ea62149212)] - **meta**: move firedfox to Collaborator Emeriti list (Rich Trott) [#27618](https://github.com/nodejs/node/pull/27618)
* [[`6bef4c0083`](https://github.com/nodejs/node/commit/6bef4c0083)] - **meta**: move AnnaMag to Collaborator Emeriti list (Rich Trott) [#27603](https://github.com/nodejs/node/pull/27603)
* [[`14d58c2f95`](https://github.com/nodejs/node/commit/14d58c2f95)] - **meta**: move pmq20 to Collaborator Emeriti list (Rich Trott) [#27602](https://github.com/nodejs/node/pull/27602)
* [[`876441eefb`](https://github.com/nodejs/node/commit/876441eefb)] - **meta**: move orangemocha to Collaborator Emeriti list (Rich Trott) [#27626](https://github.com/nodejs/node/pull/27626)
* [[`140b44f3ea`](https://github.com/nodejs/node/commit/140b44f3ea)] - **module**: fix createRequireFromPath() slash logic (cjihrig) [#27634](https://github.com/nodejs/node/pull/27634)
* [[`8a96182827`](https://github.com/nodejs/node/commit/8a96182827)] - **module**: add missing space in error message (cjihrig) [#27627](https://github.com/nodejs/node/pull/27627)
* [[`c33e83497e`](https://github.com/nodejs/node/commit/c33e83497e)] - **module**: simplify createRequire() validation (cjihrig) [#27629](https://github.com/nodejs/node/pull/27629)
* [[`119a590f84`](https://github.com/nodejs/node/commit/119a590f84)] - **module**: improve resolve paths validation (cjihrig) [#27613](https://github.com/nodejs/node/pull/27613)
* [[`2f512e32a7`](https://github.com/nodejs/node/commit/2f512e32a7)] - **module**: handle relative paths in resolve paths (cjihrig) [#27598](https://github.com/nodejs/node/pull/27598)
* [[`74feb0b81e`](https://github.com/nodejs/node/commit/74feb0b81e)] - **process**: mark process.env as side-effect-free (Anna Henningsen) [#27684](https://github.com/nodejs/node/pull/27684)
* [[`0393045198`](https://github.com/nodejs/node/commit/0393045198)] - **(SEMVER-MINOR)** **process**: inspect error in case of a fatal exception (Ruben Bridgewater) [#27243](https://github.com/nodejs/node/pull/27243)
* [[`688a0bd2b8`](https://github.com/nodejs/node/commit/688a0bd2b8)] - **repl**: do not run --eval code if there is none (Anna Henningsen) [#27587](https://github.com/nodejs/node/pull/27587)
* [[`c78de13238`](https://github.com/nodejs/node/commit/c78de13238)] - **(SEMVER-MINOR)** **repl**: handle uncaughtException properly (Ruben Bridgewater) [#27151](https://github.com/nodejs/node/pull/27151)
* [[`d21e066f5a`](https://github.com/nodejs/node/commit/d21e066f5a)] - **src**: update UNREACHABLE macro to take a string (Nitish Sakhawalkar) [#26502](https://github.com/nodejs/node/pull/26502)
* [[`ae8b64df78`](https://github.com/nodejs/node/commit/ae8b64df78)] - **src**: remove util-inl.h from header files (Sam Roberts) [#27631](https://github.com/nodejs/node/pull/27631)
* [[`e736e20e87`](https://github.com/nodejs/node/commit/e736e20e87)] - **src**: declare unused priv argument (Sam Roberts) [#27631](https://github.com/nodejs/node/pull/27631)
* [[`d2e1efe8a3`](https://github.com/nodejs/node/commit/d2e1efe8a3)] - **src**: fix warnings about redefined BSWAP macros (Sam Roberts) [#27631](https://github.com/nodejs/node/pull/27631)
* [[`3c707976da`](https://github.com/nodejs/node/commit/3c707976da)] - **src**: remove extra semicolons after macros (gengjiawen) [#27579](https://github.com/nodejs/node/pull/27579)
* [[`a18692c4df`](https://github.com/nodejs/node/commit/a18692c4df)] - **src**: extract common macro to util.h (gengjiawen) [#27512](https://github.com/nodejs/node/pull/27512)
* [[`f6642e90b2`](https://github.com/nodejs/node/commit/f6642e90b2)] - **src**: elevate namespaces in node\_worker.cc (Preveen Padmanabhan) [#27568](https://github.com/nodejs/node/pull/27568)
* [[`62fe3422fb`](https://github.com/nodejs/node/commit/62fe3422fb)] - **src**: refactor deprecated UVException usage in pipe-wrap.cc (gengjiawen) [#27562](https://github.com/nodejs/node/pull/27562)
* [[`b338d53916`](https://github.com/nodejs/node/commit/b338d53916)] - **src**: fix typos (gengjiawen) [#27580](https://github.com/nodejs/node/pull/27580)
* [[`32fd0ac901`](https://github.com/nodejs/node/commit/32fd0ac901)] - **stream**: use readableObjectMode public api for js stream (Anto Aravinth) [#27655](https://github.com/nodejs/node/pull/27655)
* [[`05c3d53ecc`](https://github.com/nodejs/node/commit/05c3d53ecc)] - **(SEMVER-MINOR)** **stream**: implement Readable.from async iterator utility (Guy Bedford) [#27660](https://github.com/nodejs/node/pull/27660)
* [[`f872210ffd`](https://github.com/nodejs/node/commit/f872210ffd)] - **test**: relax check in verify-graph (Gerhard Stoebich) [#27742](https://github.com/nodejs/node/pull/27742)
* [[`8b4101a97f`](https://github.com/nodejs/node/commit/8b4101a97f)] - **test**: un-mark worker syntax error tests as flaky (Anna Henningsen) [#27705](https://github.com/nodejs/node/pull/27705)
* [[`1757250997`](https://github.com/nodejs/node/commit/1757250997)] - **test**: clearing require cache crashes esm loader (Antoine du HAMEL) [#25491](https://github.com/nodejs/node/pull/25491)
* [[`7252a64a23`](https://github.com/nodejs/node/commit/7252a64a23)] - **test**: pass null params to napi\_xxx\_property() (Octavian Soldea) [#27628](https://github.com/nodejs/node/pull/27628)
* [[`9ed5882dec`](https://github.com/nodejs/node/commit/9ed5882dec)] - **test**: use common.PORT instead of an extraneous variable (Benjamin Ki) [#27565](https://github.com/nodejs/node/pull/27565)
* [[`f01183c29a`](https://github.com/nodejs/node/commit/f01183c29a)] - **test**: move dgram invalid host test to internet tests (Benjamin Ki) [#27565](https://github.com/nodejs/node/pull/27565)
* [[`8cba1affe3`](https://github.com/nodejs/node/commit/8cba1affe3)] - **test**: better assertion for async hook tests (Ali Ijaz Sheikh) [#27601](https://github.com/nodejs/node/pull/27601)
* [[`0c7f18ebd3`](https://github.com/nodejs/node/commit/0c7f18ebd3)] - **test**: test error when breakOnSigint is not a boolean for evaluate (Ruwan Geeganage) [#27503](https://github.com/nodejs/node/pull/27503)
* [[`3801859032`](https://github.com/nodejs/node/commit/3801859032)] - **test**: add tests for hasItems method in FreeList (Ruwan Geeganage) [#27588](https://github.com/nodejs/node/pull/27588)
* [[`691866f124`](https://github.com/nodejs/node/commit/691866f124)] - **test**: fix test-linux-perf flakiness (Matheus Marchini) [#27615](https://github.com/nodejs/node/pull/27615)
* [[`d7fcd75f62`](https://github.com/nodejs/node/commit/d7fcd75f62)] - **test**: remove unneeded `--expose-internals` (Rich Trott) [#27608](https://github.com/nodejs/node/pull/27608)
* [[`815a95734e`](https://github.com/nodejs/node/commit/815a95734e)] - **test**: refactor test-tls-enable-trace-cli.js (cjihrig) [#27553](https://github.com/nodejs/node/pull/27553)
* [[`b6e540a9a2`](https://github.com/nodejs/node/commit/b6e540a9a2)] - **test**: fix flaky test-tls-multiple-cas-as-string (Luigi Pinca) [#27569](https://github.com/nodejs/node/pull/27569)
* [[`a5dab9e85a`](https://github.com/nodejs/node/commit/a5dab9e85a)] - **test**: deflake test-tls-js-stream (Luigi Pinca) [#27478](https://github.com/nodejs/node/pull/27478)
* [[`bdd75d0622`](https://github.com/nodejs/node/commit/bdd75d0622)] - **(SEMVER-MINOR)** **tls**: expose built-in root certificates (Ben Noordhuis) [#26415](https://github.com/nodejs/node/pull/26415)
* [[`e61823c43a`](https://github.com/nodejs/node/commit/e61823c43a)] - **(SEMVER-MINOR)** **tls**: support `net.Server` options (Luigi Pinca) [#27665](https://github.com/nodejs/node/pull/27665)
* [[`eb1f4e50c7`](https://github.com/nodejs/node/commit/eb1f4e50c7)] - **(SEMVER-MINOR)** **tls**: expose keylog event on TLSSocket (Alba Mendez) [#27654](https://github.com/nodejs/node/pull/27654)
* [[`6624f802d9`](https://github.com/nodejs/node/commit/6624f802d9)] - **tls**: fix createSecureContext() cipher list filter (Sam Roberts) [#27614](https://github.com/nodejs/node/pull/27614)
* [[`b8b02c35ee`](https://github.com/nodejs/node/commit/b8b02c35ee)] - **tls**: add missing 'new' (cjihrig) [#27614](https://github.com/nodejs/node/pull/27614)
* [[`a8a11862e0`](https://github.com/nodejs/node/commit/a8a11862e0)] - **tools**: update markdown linter for Windows line endings (Rich Trott) [#27756](https://github.com/nodejs/node/pull/27756)
* [[`c3d16756f2`](https://github.com/nodejs/node/commit/c3d16756f2)] - **tools**: remove unneeded dependency files (Rich Trott) [#27730](https://github.com/nodejs/node/pull/27730)
* [[`0db846f734`](https://github.com/nodejs/node/commit/0db846f734)] - **tools**: refactor js2c.py for maximal Python3 compatibility (Refael Ackermann) [#25518](https://github.com/nodejs/node/pull/25518)
* [[`0e16b352b4`](https://github.com/nodejs/node/commit/0e16b352b4)] - **tools**: decrease code duplication for isString() in lint rules (cjihrig) [#27719](https://github.com/nodejs/node/pull/27719)
* [[`47184d1a0a`](https://github.com/nodejs/node/commit/47184d1a0a)] - **tools**: update capitalized-comments eslint rule (Ruben Bridgewater) [#27675](https://github.com/nodejs/node/pull/27675)
* [[`ea62f4a820`](https://github.com/nodejs/node/commit/ea62f4a820)] - **tools**: update dmn to 2.2.2 (Rich Trott) [#27686](https://github.com/nodejs/node/pull/27686)
* [[`d2dad0b4b8`](https://github.com/nodejs/node/commit/d2dad0b4b8)] - **tools**: DRY isRequireCall() in lint rules (cjihrig) [#27680](https://github.com/nodejs/node/pull/27680)
* [[`1b8bc77990`](https://github.com/nodejs/node/commit/1b8bc77990)] - **tools**: add `12.x` to alternative docs versions (Richard Lau) [#27658](https://github.com/nodejs/node/pull/27658)
* [[`1365683c23`](https://github.com/nodejs/node/commit/1365683c23)] - **tools**: allow RegExp in required-modules eslint rule (Richard Lau) [#27647](https://github.com/nodejs/node/pull/27647)
* [[`169ddc5097`](https://github.com/nodejs/node/commit/169ddc5097)] - **tools**: force common be required before any other modules (ZYSzys) [#27650](https://github.com/nodejs/node/pull/27650)
* [[`c6ab6b279c`](https://github.com/nodejs/node/commit/c6ab6b279c)] - **tools**: enable block-scoped-var eslint rule (Roman Reiss) [#27616](https://github.com/nodejs/node/pull/27616)
* [[`fd823ea7a8`](https://github.com/nodejs/node/commit/fd823ea7a8)] - **tools**: enable camelcase linting in tools (Rich Trott) [#27607](https://github.com/nodejs/node/pull/27607)
* [[`217e6b5a06`](https://github.com/nodejs/node/commit/217e6b5a06)] - **tools**: switch to camelcasing in apilinks.js (Rich Trott) [#27607](https://github.com/nodejs/node/pull/27607)
* [[`10b4a8103d`](https://github.com/nodejs/node/commit/10b4a8103d)] - **util**: if present, fallback to `toString` using the %s formatter (Ruben Bridgewater) [#27621](https://github.com/nodejs/node/pull/27621)
* [[`5205902762`](https://github.com/nodejs/node/commit/5205902762)] - **util**: remove outdated comment (Ruben Bridgewater) [#27733](https://github.com/nodejs/node/pull/27733)
* [[`099c9ce1a1`](https://github.com/nodejs/node/commit/099c9ce1a1)] - **util**: unify constructor inspection in `util.inspect` (Ruben Bridgewater) [#27733](https://github.com/nodejs/node/pull/27733)
* [[`d8b48675a7`](https://github.com/nodejs/node/commit/d8b48675a7)] - **util**: simplify inspection limit handling (Ruben Bridgewater) [#27733](https://github.com/nodejs/node/pull/27733)
* [[`6984ca1c2f`](https://github.com/nodejs/node/commit/6984ca1c2f)] - **util**: reconstruct constructor in more cases (Ruben Bridgewater) [#27668](https://github.com/nodejs/node/pull/27668)
* [[`8f48edd28f`](https://github.com/nodejs/node/commit/8f48edd28f)] - **vm**: mark global proxy as side-effect-free (Anna Henningsen) [#27523](https://github.com/nodejs/node/pull/27523)
* [[`c7cf8d9b74`](https://github.com/nodejs/node/commit/c7cf8d9b74)] - **(SEMVER-MINOR)** **worker**: add ability to unshift message from MessagePort (Anna Henningsen) [#27294](https://github.com/nodejs/node/pull/27294)
* [[`e004d427ce`](https://github.com/nodejs/node/commit/e004d427ce)] - **worker**: use special message as MessagePort close command (Anna Henningsen) [#27705](https://github.com/nodejs/node/pull/27705)
* [[`b7ed4d7187`](https://github.com/nodejs/node/commit/b7ed4d7187)] - **worker**: move `receiving\_messages\_` field to `MessagePort` (Anna Henningsen) [#27705](https://github.com/nodejs/node/pull/27705)

<a id="12.2.0"></a>
## 2019-05-07, Version 12.2.0 (Current), @targos

### Notable changes

* **deps**:
  * Updated llhttp to 1.1.3. This fixes a bug that made Node.js' HTTP parser
    refuse any request URL that contained the "|" (vertical bar) character (Fedor Indutny) [#27595](https://github.com/nodejs/node/pull/27595).
* **tls**:
  * Added an `enableTrace()` method to `TLSSocket` and an `enableTrace` option
    to `tls.createServer()`. When enabled, TSL packet trace information is
    written to `stderr`. This can be used to debug TLS connection problems (cjihrig) [#27497](https://github.com/nodejs/node/pull/27497), (Sam Roberts) [#27376](https://github.com/nodejs/node/pull/27376).
* **cli**:
  * Added a `--trace-tls` command-line flag that enables tracing of TLS
    connections without the need to modify existing application code (cjihrig) [#27497](https://github.com/nodejs/node/pull/27497).
  * Added a `--cpu-prof-interval` command-line flag. It can be used to specify
    the sampling interval for the CPU profiles generated by `--cpu-prof` (Joyee Cheung) [#27535](https://github.com/nodejs/node/pull/27535).
* **module**:
  * Added the `createRequire()` method. It allows to create a require function
    from a file URL object, a file URL string or an absolute path string. The
    existing `createRequireFromPath()` method is now deprecated (Myles Borins) [#27405](https://github.com/nodejs/node/pull/27405).
  * Throw on `require('./path.mjs')`. This is technically a breaking change that
    should have landed with Node.js 12.0.0. It is necessary to have this to keep
    the possibility for a future minor version to load ES Modules with the
    require function (Myles Borins) [#27417](https://github.com/nodejs/node/pull/27417).
* **repl**:
  * The REPL now supports multi-line statements using `BigInt` literals as well
    as public and private class fields and methods (Ruben Bridgewater) [#27400](https://github.com/nodejs/node/pull/27400).
  * The REPL now supports tab autocompletion of file paths with `fs` methods (Anto Aravinth) [#26648](https://github.com/nodejs/node/pull/26648).
* **meta**:
  * Added [Christian Clauss](https://github.com/cclauss) to collaborators [#27554](https://github.com/nodejs/node/pull/27554).

### Commits

* [[`c0ab2a141b`](https://github.com/nodejs/node/commit/c0ab2a141b)] - **assert**: use new language features (Ruben Bridgewater) [#27400](https://github.com/nodejs/node/pull/27400)
* [[`4b3d0d1953`](https://github.com/nodejs/node/commit/4b3d0d1953)] - **async_hooks**: fixup do not reuse HTTPParser (Gerhard Stoebich) [#27477](https://github.com/nodejs/node/pull/27477)
* [[`cfc7bdd303`](https://github.com/nodejs/node/commit/cfc7bdd303)] - **benchmark**: add benchmark for node -p (Joyee Cheung) [#27320](https://github.com/nodejs/node/pull/27320)
* [[`53eefeb73e`](https://github.com/nodejs/node/commit/53eefeb73e)] - **buffer**: remove unreachable code (Rich Trott) [#27445](https://github.com/nodejs/node/pull/27445)
* [[`cac584d260`](https://github.com/nodejs/node/commit/cac584d260)] - **buffer,errors**: improve bigint, big numbers and more (Ruben Bridgewater) [#27228](https://github.com/nodejs/node/pull/27228)
* [[`22a5a05785`](https://github.com/nodejs/node/commit/22a5a05785)] - **build**: delegate building from Makefile to ninja (Refael Ackermann) [#27504](https://github.com/nodejs/node/pull/27504)
* [[`67205f5941`](https://github.com/nodejs/node/commit/67205f5941)] - **build**: remove unsupported Python 2.6 from configure (cclauss) [#27381](https://github.com/nodejs/node/pull/27381)
* [[`615d386390`](https://github.com/nodejs/node/commit/615d386390)] - **child_process**: only stop readable side of stream passed to proc (Anna Henningsen) [#27373](https://github.com/nodejs/node/pull/27373)
* [[`8e876e60aa`](https://github.com/nodejs/node/commit/8e876e60aa)] - **console**: use consolePropAttributes for k-bind properties (reland) (Ruben Bridgewater) [#27352](https://github.com/nodejs/node/pull/27352)
* [[`55804e1726`](https://github.com/nodejs/node/commit/55804e1726)] - **deps**: update llhttp to 1.1.2 (Fedor Indutny) [#27513](https://github.com/nodejs/node/pull/27513)
* [[`f142363cfa`](https://github.com/nodejs/node/commit/f142363cfa)] - **deps**: update llhttp to 1.1.3 (Fedor Indutny) [#27595](https://github.com/nodejs/node/pull/27595)
* [[`5f72246499`](https://github.com/nodejs/node/commit/5f72246499)] - **deps**: add acorn stage-3 plugins (Ruben Bridgewater) [#27400](https://github.com/nodejs/node/pull/27400)
* [[`230a773e32`](https://github.com/nodejs/node/commit/230a773e32)] - **(SEMVER-MINOR)** **deps**: update archs files for OpenSSL-1.1.1b (Sam Roberts) [#27376](https://github.com/nodejs/node/pull/27376)
* [[`b68132e01a`](https://github.com/nodejs/node/commit/b68132e01a)] - **(SEMVER-MINOR)** **deps**: configure OpenSSL's SSL\_trace to be built (Sam Roberts) [#27376](https://github.com/nodejs/node/pull/27376)
* [[`7c25dce7ba`](https://github.com/nodejs/node/commit/7c25dce7ba)] - **deps**: V8: cherry-pick 5d0cf6b (Joyee Cheung) [#27423](https://github.com/nodejs/node/pull/27423)
* [[`2c3c0d7d3e`](https://github.com/nodejs/node/commit/2c3c0d7d3e)] - **doc**: add cclauss to collaborators (cclauss) [#27554](https://github.com/nodejs/node/pull/27554)
* [[`b51dcf62b8`](https://github.com/nodejs/node/commit/b51dcf62b8)] - **doc**: add Electron 6 to abi\_version\_registry (Jeremy Apthorp) [#27288](https://github.com/nodejs/node/pull/27288)
* [[`cb97de7a9b`](https://github.com/nodejs/node/commit/cb97de7a9b)] - **doc**: move James back onto TSC (Michael Dawson) [#27411](https://github.com/nodejs/node/pull/27411)
* [[`a9748bc124`](https://github.com/nodejs/node/commit/a9748bc124)] - **doc**: describe API ERR\_INVALID\_PROTOCOL context (Sam Roberts) [#27393](https://github.com/nodejs/node/pull/27393)
* [[`a0353fdbe2`](https://github.com/nodejs/node/commit/a0353fdbe2)] - **fs**: align fs.ReadStream buffer pool writes to 8-byte boundary (ptaylor) [#24838](https://github.com/nodejs/node/pull/24838)
* [[`7be1e0af44`](https://github.com/nodejs/node/commit/7be1e0af44)] - **fs**: added tests for util file preprocessSymlinkDestination (Ruwan Geeganage) [#27468](https://github.com/nodejs/node/pull/27468)
* [[`f882c9b09b`](https://github.com/nodejs/node/commit/f882c9b09b)] - **(SEMVER-MINOR)** **http**: `servername === false` should disable SNI (Fedor Indutny) [#27316](https://github.com/nodejs/node/pull/27316)
* [[`de337bb37c`](https://github.com/nodejs/node/commit/de337bb37c)] - **(SEMVER-MINOR)** **inspector**: implement --cpu-prof-interval (Joyee Cheung) [#27535](https://github.com/nodejs/node/pull/27535)
* [[`9c842f4119`](https://github.com/nodejs/node/commit/9c842f4119)] - **lib**: remove Reflect.apply where appropriate (Anatoli Papirovski) [#27349](https://github.com/nodejs/node/pull/27349)
* [[`47d311b3f0`](https://github.com/nodejs/node/commit/47d311b3f0)] - **lib**: remove outdated optimizations (Weijia Wang) [#27380](https://github.com/nodejs/node/pull/27380)
* [[`c2a03d58c3`](https://github.com/nodejs/node/commit/c2a03d58c3)] - **lib**: print to stdout/stderr directly instead of using console (Joyee Cheung) [#27320](https://github.com/nodejs/node/pull/27320)
* [[`b68ecf3e17`](https://github.com/nodejs/node/commit/b68ecf3e17)] - **meta**: move andrasq to Collaborator Emeriti list (Rich Trott) [#27546](https://github.com/nodejs/node/pull/27546)
* [[`fd17f37a83`](https://github.com/nodejs/node/commit/fd17f37a83)] - **meta**: move stefanmb to Collaborator Emeriti list (Rich Trott) [#27502](https://github.com/nodejs/node/pull/27502)
* [[`8495e8bceb`](https://github.com/nodejs/node/commit/8495e8bceb)] - **meta**: move Forrest Norvell to Collaborator Emeriti list (Rich Trott) [#27437](https://github.com/nodejs/node/pull/27437)
* [[`7d1c90b614`](https://github.com/nodejs/node/commit/7d1c90b614)] - **meta**: move @vsemozhetbyt to collaborator emeriti (Vse Mozhet Byt) [#27412](https://github.com/nodejs/node/pull/27412)
* [[`014a9fd46f`](https://github.com/nodejs/node/commit/014a9fd46f)] - **module**: throw on require('./path.mjs'); (Myles Borins) [#27417](https://github.com/nodejs/node/pull/27417)
* [[`5bcd7700ca`](https://github.com/nodejs/node/commit/5bcd7700ca)] - **(SEMVER-MINOR)** **module**: add createRequire method (Myles Borins) [#27405](https://github.com/nodejs/node/pull/27405)
* [[`be9a1ec1d1`](https://github.com/nodejs/node/commit/be9a1ec1d1)] - **module**: allow passing a directory to createRequireFromPath (Gilles De Mey) [#23818](https://github.com/nodejs/node/pull/23818)
* [[`e5fdc30bd1`](https://github.com/nodejs/node/commit/e5fdc30bd1)] - **n-api**: make napi\_get\_property\_names return strings (Anna Henningsen) [#27524](https://github.com/nodejs/node/pull/27524)
* [[`826fb66729`](https://github.com/nodejs/node/commit/826fb66729)] - **process**: compatibility patch to backport 1d022e8 (Ruben Bridgewater) [#27483](https://github.com/nodejs/node/pull/27483)
* [[`91b7f5e103`](https://github.com/nodejs/node/commit/91b7f5e103)] - **process**: improve cwd performance (Ruben Bridgewater) [#27224](https://github.com/nodejs/node/pull/27224)
* [[`05cea679a3`](https://github.com/nodejs/node/commit/05cea679a3)] - **repl**: handle stage-3 language features properly (Ruben Bridgewater) [#27400](https://github.com/nodejs/node/pull/27400)
* [[`01d632d7e8`](https://github.com/nodejs/node/commit/01d632d7e8)] - **repl**: add new language features to top level await statements (Ruben Bridgewater) [#27400](https://github.com/nodejs/node/pull/27400)
* [[`149412ca02`](https://github.com/nodejs/node/commit/149412ca02)] - **repl**: add autocomplete for filesystem modules (Anto Aravinth) [#26648](https://github.com/nodejs/node/pull/26648)
* [[`a55457c713`](https://github.com/nodejs/node/commit/a55457c713)] - **report**: use const reference in node\_report.cc (gengjiawen) [#27479](https://github.com/nodejs/node/pull/27479)
* [[`8724229155`](https://github.com/nodejs/node/commit/8724229155)] - **src**: make deleted function public in node\_native\_module.h (gengjiawen) [#27509](https://github.com/nodejs/node/pull/27509)
* [[`1489d12735`](https://github.com/nodejs/node/commit/1489d12735)] - **src**: make deleted function public in node\_main\_instance.h (gengjiawen) [#27509](https://github.com/nodejs/node/pull/27509)
* [[`294d2ea71d`](https://github.com/nodejs/node/commit/294d2ea71d)] - **(SEMVER-MINOR)** **src**: refactor V8ProfilerConnection::DispatchMessage() (Joyee Cheung) [#27535](https://github.com/nodejs/node/pull/27535)
* [[`a758f9bdf5`](https://github.com/nodejs/node/commit/a758f9bdf5)] - **src**: remove node\_options-inl.h from header files (Sam Roberts) [#27538](https://github.com/nodejs/node/pull/27538)
* [[`bb373d0def`](https://github.com/nodejs/node/commit/bb373d0def)] - **src**: remove unnecessary semicolons after macros (Yang Guo) [#27529](https://github.com/nodejs/node/pull/27529)
* [[`0c9bc02b96`](https://github.com/nodejs/node/commit/0c9bc02b96)] - **src**: refactor V8ProfilerConnection to be more reusable (Joyee Cheung) [#27475](https://github.com/nodejs/node/pull/27475)
* [[`c787bb85cd`](https://github.com/nodejs/node/commit/c787bb85cd)] - **src**: refactor profile initialization (Joyee Cheung) [#27475](https://github.com/nodejs/node/pull/27475)
* [[`600048b1b7`](https://github.com/nodejs/node/commit/600048b1b7)] - **src**: move Environment::context out of strong properties (Joyee Cheung) [#27430](https://github.com/nodejs/node/pull/27430)
* [[`33702913b1`](https://github.com/nodejs/node/commit/33702913b1)] - **src**: prefer v8::Global over node::Persistent (Anna Henningsen) [#27287](https://github.com/nodejs/node/pull/27287)
* [[`9d6d45e7d2`](https://github.com/nodejs/node/commit/9d6d45e7d2)] - **stream**: remove TODO and add a description instead (Ruben Bridgewater) [#27086](https://github.com/nodejs/node/pull/27086)
* [[`bb1eaeec75`](https://github.com/nodejs/node/commit/bb1eaeec75)] - **test**: mark test-tls-enable-trace-cli flaky (cjihrig) [#27559](https://github.com/nodejs/node/pull/27559)
* [[`d648ecc488`](https://github.com/nodejs/node/commit/d648ecc488)] - **test**: improve test-async-hooks-http-parser-destroy (Rich Trott) [#27319](https://github.com/nodejs/node/pull/27319)
* [[`ca720b3a55`](https://github.com/nodejs/node/commit/ca720b3a55)] - **test**: converting NghttpError to string in HTTP2 module (Ruwan Geeganage) [#27506](https://github.com/nodejs/node/pull/27506)
* [[`99e4a576eb`](https://github.com/nodejs/node/commit/99e4a576eb)] - **test**: add mustCall to openssl-client-cert-engine (Boxuan Li) [#27474](https://github.com/nodejs/node/pull/27474)
* [[`e1d88aa880`](https://github.com/nodejs/node/commit/e1d88aa880)] - **test**: document NODE\_COMMON\_PORT env var (cjihrig) [#27507](https://github.com/nodejs/node/pull/27507)
* [[`66cf706521`](https://github.com/nodejs/node/commit/66cf706521)] - **test**: allow EAI\_FAIL in test-http-dns-error.js (cjihrig) [#27500](https://github.com/nodejs/node/pull/27500)
* [[`df4246e3b6`](https://github.com/nodejs/node/commit/df4246e3b6)] - **test**: refactor and deflake test-tls-sni-server-client (Luigi Pinca) [#27426](https://github.com/nodejs/node/pull/27426)
* [[`a278814818`](https://github.com/nodejs/node/commit/a278814818)] - **test**: make sure weak references are not GCed too early (Ruben Bridgewater) [#27482](https://github.com/nodejs/node/pull/27482)
* [[`aa281d284a`](https://github.com/nodejs/node/commit/aa281d284a)] - **test**: better output for test-report-uv-handles.js (gengjiawen) [#27479](https://github.com/nodejs/node/pull/27479)
* [[`86c27c6005`](https://github.com/nodejs/node/commit/86c27c6005)] - **test**: add mustcall in test-net-bytes-read.js (imhype) [#27471](https://github.com/nodejs/node/pull/27471)
* [[`33fead3f5e`](https://github.com/nodejs/node/commit/33fead3f5e)] - ***Revert*** "**test**: skip test-cpu-prof in debug builds with code cache" (Anna Henningsen) [#27469](https://github.com/nodejs/node/pull/27469)
* [[`a9a85d6271`](https://github.com/nodejs/node/commit/a9a85d6271)] - **test**: check `napi\_get\_reference\_value()` during finalization (Anna Henningsen) [#27470](https://github.com/nodejs/node/pull/27470)
* [[`16af9435a0`](https://github.com/nodejs/node/commit/16af9435a0)] - **test**: remove flaky designation for test-tls-sni-option (Luigi Pinca) [#27425](https://github.com/nodejs/node/pull/27425)
* [[`1b94d025bc`](https://github.com/nodejs/node/commit/1b94d025bc)] - **test**: add missing line breaks to keep-alive header of slow headers test (Shuhei Kagawa) [#27442](https://github.com/nodejs/node/pull/27442)
* [[`fefbbd90af`](https://github.com/nodejs/node/commit/fefbbd90af)] - **test**: add tests for new language features (Ruben Bridgewater) [#27400](https://github.com/nodejs/node/pull/27400)
* [[`3711684ccf`](https://github.com/nodejs/node/commit/3711684ccf)] - **test**: add mustCall for parallel/test-net-connect-paused-connection (sujunfei) [#27463](https://github.com/nodejs/node/pull/27463)
* [[`0e4f8788eb`](https://github.com/nodejs/node/commit/0e4f8788eb)] - **test**: add mustCallAtLeast to test-fs-read-stream-resume.js (heben) [#27456](https://github.com/nodejs/node/pull/27456)
* [[`e89b6fee3a`](https://github.com/nodejs/node/commit/e89b6fee3a)] - **test**: adding mustCall in test-fs-readfile-empty.js (陈健) [#27455](https://github.com/nodejs/node/pull/27455)
* [[`457549b67d`](https://github.com/nodejs/node/commit/457549b67d)] - **test**: add common.mustCall in test-http-abort-client.js (OneNail) [#27449](https://github.com/nodejs/node/pull/27449)
* [[`f4124d5ba5`](https://github.com/nodejs/node/commit/f4124d5ba5)] - **test**: add mustCall to http-abort-queued test (Yaphet Ye) [#27447](https://github.com/nodejs/node/pull/27447)
* [[`e21f035666`](https://github.com/nodejs/node/commit/e21f035666)] - **test**: add mustCall in test-fs-readfilesync-pipe-large.js (sinoon) [#27458](https://github.com/nodejs/node/pull/27458)
* [[`1dd0205f10`](https://github.com/nodejs/node/commit/1dd0205f10)] - **test**: add mustCall to test-dgram-connect-send-multi-buffer-copy.js (XGHeaven) [#27465](https://github.com/nodejs/node/pull/27465)
* [[`0dfe5bebb2`](https://github.com/nodejs/node/commit/0dfe5bebb2)] - **test**: add test of policy about parse error (Daiki Ihara) [#26873](https://github.com/nodejs/node/pull/26873)
* [[`eeab007b25`](https://github.com/nodejs/node/commit/eeab007b25)] - **test**: add mustCall to test-net-after-close test (xuqinggang) [#27459](https://github.com/nodejs/node/pull/27459)
* [[`c1b04652f5`](https://github.com/nodejs/node/commit/c1b04652f5)] - **test**: add "mustCall" to test-fs-readfile-unlink (wuchenkai) [#27453](https://github.com/nodejs/node/pull/27453)
* [[`b6c65c1351`](https://github.com/nodejs/node/commit/b6c65c1351)] - **test**: add missing ToC entries (cjihrig) [#27434](https://github.com/nodejs/node/pull/27434)
* [[`66bff5071f`](https://github.com/nodejs/node/commit/66bff5071f)] - **test**: document report helper module (cjihrig) [#27434](https://github.com/nodejs/node/pull/27434)
* [[`2c335928cd`](https://github.com/nodejs/node/commit/2c335928cd)] - **test**: document NODE\_SKIP\_FLAG\_CHECK (cjihrig) [#27434](https://github.com/nodejs/node/pull/27434)
* [[`115d06cdbb`](https://github.com/nodejs/node/commit/115d06cdbb)] - **test**: document NODE\_TEST\_KNOWN\_GLOBALS (cjihrig) [#27434](https://github.com/nodejs/node/pull/27434)
* [[`51fc672da9`](https://github.com/nodejs/node/commit/51fc672da9)] - **test**: add mustCallAtLeast to test-fs-read-stream-inherit (nilianzhu) [#27457](https://github.com/nodejs/node/pull/27457)
* [[`4b9d109518`](https://github.com/nodejs/node/commit/4b9d109518)] - **test**: add mustCall to test-dgram-implicit-bind.js (Chenxi Yuan) [#27452](https://github.com/nodejs/node/pull/27452)
* [[`c4d67f2af5`](https://github.com/nodejs/node/commit/c4d67f2af5)] - **test**: add common.mustCall test-dgram-listen-after-bind (zhoujiamin) [#27454](https://github.com/nodejs/node/pull/27454)
* [[`23fb430e03`](https://github.com/nodejs/node/commit/23fb430e03)] - **test**: add mustCall to test-dgram-connect-send-callback-buffer (shenchen) [#27466](https://github.com/nodejs/node/pull/27466)
* [[`a37ca245ff`](https://github.com/nodejs/node/commit/a37ca245ff)] - **test**: add mustCallAtLeast to test-fs-read-stream-fd test (hardfist) [#27461](https://github.com/nodejs/node/pull/27461)
* [[`cf84f20453`](https://github.com/nodejs/node/commit/cf84f20453)] - **test**: skip fs-copyfile-respect-permission if root (Daniel Bevenius) [#27378](https://github.com/nodejs/node/pull/27378)
* [[`7d80999454`](https://github.com/nodejs/node/commit/7d80999454)] - **test**: add mustCall to net-can-reset-timeout (xinyulee) [#27462](https://github.com/nodejs/node/pull/27462)
* [[`9fa5ba8b3c`](https://github.com/nodejs/node/commit/9fa5ba8b3c)] - **test**: add mustCall to test-fs-readfile-pipe-large (luoyu) [#27460](https://github.com/nodejs/node/pull/27460)
* [[`e8d5b6226a`](https://github.com/nodejs/node/commit/e8d5b6226a)] - **test**: add "mustCall" for test-net-buffersize (lixin.atom) [#27451](https://github.com/nodejs/node/pull/27451)
* [[`d784ecb1ad`](https://github.com/nodejs/node/commit/d784ecb1ad)] - **test**: add mustCall to test-net-eaddrinuse test (tongshouyu) [#27448](https://github.com/nodejs/node/pull/27448)
* [[`6fd1384a43`](https://github.com/nodejs/node/commit/6fd1384a43)] - **test**: add mustcall in test-dgram-connect-send-callback-buffer-length (jyjunyz) [#27464](https://github.com/nodejs/node/pull/27464)
* [[`7a35077197`](https://github.com/nodejs/node/commit/7a35077197)] - **test**: add mustCall to test-fs-readfile-pipe (tonyhty) [#27450](https://github.com/nodejs/node/pull/27450)
* [[`af29ae0344`](https://github.com/nodejs/node/commit/af29ae0344)] - **test**: add mustCall to net-connect-buffer test (Rongjian Zhang) [#27446](https://github.com/nodejs/node/pull/27446)
* [[`bdabf699eb`](https://github.com/nodejs/node/commit/bdabf699eb)] - **(SEMVER-MINOR)** **tls**: add --tls-min-v1.2 CLI switch (Sam Roberts) [#27520](https://github.com/nodejs/node/pull/27520)
* [[`7bbf951095`](https://github.com/nodejs/node/commit/7bbf951095)] - **tls**: disallow conflicting TLS protocol options (Sam Roberts) [#27521](https://github.com/nodejs/node/pull/27521)
* [[`84a2768c25`](https://github.com/nodejs/node/commit/84a2768c25)] - **(SEMVER-MINOR)** **tls**: support enableTrace in TLSSocket() (cjihrig) [#27497](https://github.com/nodejs/node/pull/27497)
* [[`576fe339a1`](https://github.com/nodejs/node/commit/576fe339a1)] - **(SEMVER-MINOR)** **tls**: simplify enableTrace logic (cjihrig) [#27497](https://github.com/nodejs/node/pull/27497)
* [[`30a72e8c7b`](https://github.com/nodejs/node/commit/30a72e8c7b)] - **(SEMVER-MINOR)** **tls**: allow enabling the TLS debug trace (Sam Roberts) [#27376](https://github.com/nodejs/node/pull/27376)
* [[`f1efe6dae0`](https://github.com/nodejs/node/commit/f1efe6dae0)] - **(SEMVER-MINOR)** **tls,cli**: add --trace-tls command-line flag (cjihrig) [#27497](https://github.com/nodejs/node/pull/27497)
* [[`3d37414002`](https://github.com/nodejs/node/commit/3d37414002)] - **tools**: fix node-core/required-modules eslint rule (Ben Noordhuis) [#27545](https://github.com/nodejs/node/pull/27545)
* [[`29e2793a87`](https://github.com/nodejs/node/commit/29e2793a87)] - **tools**: add Release and Debug symlinks to .gitignore (Gerhard Stoebich) [#27484](https://github.com/nodejs/node/pull/27484)
* [[`76af4f0d05`](https://github.com/nodejs/node/commit/76af4f0d05)] - **tools**: prohibit `assert.doesNotReject()` in Node.js core (Ruben Bridgewater) [#27402](https://github.com/nodejs/node/pull/27402)
* [[`95498df1cf`](https://github.com/nodejs/node/commit/95498df1cf)] - **util**: inspect constructor closer (Ruben Bridgewater) [#27522](https://github.com/nodejs/node/pull/27522)
* [[`7b5bd93ced`](https://github.com/nodejs/node/commit/7b5bd93ced)] - **util**: compatibility patch to backport d0667e8 (Ruben Bridgewater) [#27570](https://github.com/nodejs/node/pull/27570)
* [[`52d4f1febf`](https://github.com/nodejs/node/commit/52d4f1febf)] - **util**: improve function inspection (Ruben Bridgewater) [#27227](https://github.com/nodejs/node/pull/27227)
* [[`caab7d4664`](https://github.com/nodejs/node/commit/caab7d4664)] - **util**: better number formatters (Ruben Bridgewater) [#27499](https://github.com/nodejs/node/pull/27499)

<a id="12.1.0"></a>
## 2019-04-29, Version 12.1.0 (Current), @targos

### Notable changes

* **intl**:
  * Update ICU to 64.2. This adds support for Japanese Era (Reiwa) (Ujjwal Sharma) [#27361](https://github.com/nodejs/node/pull/27361).
  * Fixes a bug in ICU that affected Node.js 12.0.0 in the case where `new Date().toLocaleString()` was called with a non-default locale (Steven R. Loomis) [#27415](https://github.com/nodejs/node/pull/27415).
* **C++ API**:
  * Added an overload `EmitAsyncDestroy` that can be used during garbage collection (Anna Henningsen) [#27255](https://github.com/nodejs/node/pull/27255).

### Commits

* [[`8ca110cc6f`](https://github.com/nodejs/node/commit/8ca110cc6f)] - **benchmark**: fix http bench-parser.js (Rich Trott) [#27359](https://github.com/nodejs/node/pull/27359)
* [[`2f9bafba08`](https://github.com/nodejs/node/commit/2f9bafba08)] - **bootstrap**: delay the instantiation of maps in per-context scripts (Joyee Cheung) [#27371](https://github.com/nodejs/node/pull/27371)
* [[`e7026f1428`](https://github.com/nodejs/node/commit/e7026f1428)] - **build**: allow icu download to use other hashes besides md5 (Steven R. Loomis) [#27370](https://github.com/nodejs/node/pull/27370)
* [[`50234460f9`](https://github.com/nodejs/node/commit/50234460f9)] - **build**: disable custom v8 snapshot by default (Joyee Cheung) [#27365](https://github.com/nodejs/node/pull/27365)
* [[`b21b28f653`](https://github.com/nodejs/node/commit/b21b28f653)] - **crypto**: update root certificates (Sam Roberts) [#27374](https://github.com/nodejs/node/pull/27374)
* [[`3282ccb845`](https://github.com/nodejs/node/commit/3282ccb845)] - **deps**: backport ICU-20575 to fix err/crasher (Steven R. Loomis) [#27435](https://github.com/nodejs/node/pull/27435)
* [[`e922a22725`](https://github.com/nodejs/node/commit/e922a22725)] - **deps**: backport ICU-20558 to fix Intl crasher (Steven R. Loomis) [#27415](https://github.com/nodejs/node/pull/27415)
* [[`d852d9e904`](https://github.com/nodejs/node/commit/d852d9e904)] - **deps**: update ICU to 64.2 (Ujjwal Sharma) [#27361](https://github.com/nodejs/node/pull/27361)
* [[`ee80a210ff`](https://github.com/nodejs/node/commit/ee80a210ff)] - **dgram**: change 'this' to 'self' for 'isConnected' (MaleDong) [#27338](https://github.com/nodejs/node/pull/27338)
* [[`8302148c83`](https://github.com/nodejs/node/commit/8302148c83)] - **doc**: add Node 12 to the first list of versions (Rivaldo Junior) [#27414](https://github.com/nodejs/node/pull/27414)
* [[`f6ceefa4bd`](https://github.com/nodejs/node/commit/f6ceefa4bd)] - **doc**: update comment in bootstrap for primordials (Myles Borins) [#27398](https://github.com/nodejs/node/pull/27398)
* [[`9c30806fb5`](https://github.com/nodejs/node/commit/9c30806fb5)] - **doc**: simplify GOVERNANCE.md text (Rich Trott) [#27354](https://github.com/nodejs/node/pull/27354)
* [[`453510c7ef`](https://github.com/nodejs/node/commit/453510c7ef)] - **doc**: fix pull request number (Ruben Bridgewater) [#27336](https://github.com/nodejs/node/pull/27336)
* [[`36762883a0`](https://github.com/nodejs/node/commit/36762883a0)] - **doc**: clarify behaviour of writeFile(fd) (Sam Roberts) [#27282](https://github.com/nodejs/node/pull/27282)
* [[`f70588fb67`](https://github.com/nodejs/node/commit/f70588fb67)] - **doc**: fix v12.0.0 changelog id (Beth Griggs) [#27368](https://github.com/nodejs/node/pull/27368)
* [[`a6d1fa5954`](https://github.com/nodejs/node/commit/a6d1fa5954)] - **doc**: simplify Collaborator pre-nomination text (Rich Trott) [#27348](https://github.com/nodejs/node/pull/27348)
* [[`dd709fc84a`](https://github.com/nodejs/node/commit/dd709fc84a)] - **lib**: throw a special error in internal/assert (Joyee Cheung) [#26635](https://github.com/nodejs/node/pull/26635)
* [[`4dfe54a89a`](https://github.com/nodejs/node/commit/4dfe54a89a)] - **module**: initialize module\_wrap.callbackMap during pre-execution (Joyee Cheung) [#27323](https://github.com/nodejs/node/pull/27323)
* [[`8b5d73867f`](https://github.com/nodejs/node/commit/8b5d73867f)] - **(SEMVER-MINOR)** **n-api**: do not require JS Context for `napi\_async\_destroy()` (Anna Henningsen) [#27255](https://github.com/nodejs/node/pull/27255)
* [[`d00014e599`](https://github.com/nodejs/node/commit/d00014e599)] - **process**: reduce the number of internal frames in async stack trace (Joyee Cheung) [#27392](https://github.com/nodejs/node/pull/27392)
* [[`dc510fb435`](https://github.com/nodejs/node/commit/dc510fb435)] - **report**: print common items first for readability (gengjiawen) [#27367](https://github.com/nodejs/node/pull/27367)
* [[`3614a00276`](https://github.com/nodejs/node/commit/3614a00276)] - **src**: refactor deprecated UVException in node\_file.cc (gengjiawen) [#27280](https://github.com/nodejs/node/pull/27280)
* [[`071300b39d`](https://github.com/nodejs/node/commit/071300b39d)] - **src**: move OnMessage to node\_errors.cc (Joyee Cheung) [#27304](https://github.com/nodejs/node/pull/27304)
* [[`81e7b49c8f`](https://github.com/nodejs/node/commit/81e7b49c8f)] - **src**: use predefined AliasedBuffer types in the code base (Joyee Cheung) [#27334](https://github.com/nodejs/node/pull/27334)
* [[`8089d29567`](https://github.com/nodejs/node/commit/8089d29567)] - **src**: apply clang-tidy modernize-deprecated-headers found by Jenkins CI (gengjiawen) [#27279](https://github.com/nodejs/node/pull/27279)
* [[`619c5b6eb3`](https://github.com/nodejs/node/commit/619c5b6eb3)] - **(SEMVER-MINOR)** **src**: do not require JS Context for `\~AsyncResoure()` (Anna Henningsen) [#27255](https://github.com/nodejs/node/pull/27255)
* [[`809cf595eb`](https://github.com/nodejs/node/commit/809cf595eb)] - **(SEMVER-MINOR)** **src**: add `Environment` overload of `EmitAsyncDestroy` (Anna Henningsen) [#27255](https://github.com/nodejs/node/pull/27255)
* [[`7bc47cba2e`](https://github.com/nodejs/node/commit/7bc47cba2e)] - **src**: apply clang-tidy rule modernize-use-equals-default (gengjiawen) [#27264](https://github.com/nodejs/node/pull/27264)
* [[`ad42cd69cf`](https://github.com/nodejs/node/commit/ad42cd69cf)] - **src**: use std::vector\<size\_t\> instead of IndexArray (Joyee Cheung) [#27321](https://github.com/nodejs/node/pull/27321)
* [[`228127fc67`](https://github.com/nodejs/node/commit/228127fc67)] - **src**: enable context snapshot after running per-context scripts (Joyee Cheung) [#27321](https://github.com/nodejs/node/pull/27321)
* [[`45d6106129`](https://github.com/nodejs/node/commit/45d6106129)] - **src**: enable snapshot with per-isolate data (Joyee Cheung) [#27321](https://github.com/nodejs/node/pull/27321)
* [[`631bea8fd2`](https://github.com/nodejs/node/commit/631bea8fd2)] - **src**: implement IsolateData serialization and deserialization (Joyee Cheung) [#27321](https://github.com/nodejs/node/pull/27321)
* [[`a636338945`](https://github.com/nodejs/node/commit/a636338945)] - **src**: allow creating NodeMainInstance that does not own the isolate (Joyee Cheung) [#27321](https://github.com/nodejs/node/pull/27321)
* [[`50732c1b3f`](https://github.com/nodejs/node/commit/50732c1b3f)] - **test**: refactor net-connect-handle-econnrefused (Luigi Pinca) [#27014](https://github.com/nodejs/node/pull/27014)
* [[`e9021cc498`](https://github.com/nodejs/node/commit/e9021cc498)] - **test**: move test-net-connect-handle-econnrefused (Luigi Pinca) [#27014](https://github.com/nodejs/node/pull/27014)
* [[`ebbed6047d`](https://github.com/nodejs/node/commit/ebbed6047d)] - **test**: rework to remove flakiness, and be parallel (Sam Roberts) [#27300](https://github.com/nodejs/node/pull/27300)
* [[`f0b2992f5c`](https://github.com/nodejs/node/commit/f0b2992f5c)] - **test**: fix ineffective error tests (Masashi Hirano) [#27333](https://github.com/nodejs/node/pull/27333)
* [[`d84a6d05a1`](https://github.com/nodejs/node/commit/d84a6d05a1)] - **test**: make test-worker-esm-missing-main more robust (Rich Trott) [#27340](https://github.com/nodejs/node/pull/27340)
* [[`8486917b9a`](https://github.com/nodejs/node/commit/8486917b9a)] - **test**: increase coverage in lib/internal/dns/promises.js (Rich Trott) [#27330](https://github.com/nodejs/node/pull/27330)
* [[`6ca0270320`](https://github.com/nodejs/node/commit/6ca0270320)] - **tls**: include invalid method name in thrown error (Sam Roberts) [#27390](https://github.com/nodejs/node/pull/27390)
* [[`dcbe5b9dff`](https://github.com/nodejs/node/commit/dcbe5b9dff)] - **tools**: update certdata.txt (Sam Roberts) [#27374](https://github.com/nodejs/node/pull/27374)
* [[`53f0ef36c0`](https://github.com/nodejs/node/commit/53f0ef36c0)] - **tools**: update LICENSE and tools/icu/current\_ver.dep (Ujjwal Sharma) [#27361](https://github.com/nodejs/node/pull/27361)
* [[`481789c235`](https://github.com/nodejs/node/commit/481789c235)] - **tools**: fix use-after-free mkcodecache warning (Ben Noordhuis) [#27332](https://github.com/nodejs/node/pull/27332)
* [[`d62a3243b1`](https://github.com/nodejs/node/commit/d62a3243b1)] - **tools**: update tools/license-builder.sh (Ujjwal Sharma) [#27362](https://github.com/nodejs/node/pull/27362)
* [[`b44323f3de`](https://github.com/nodejs/node/commit/b44323f3de)] - **tools**: implement node\_mksnapshot (Joyee Cheung) [#27321](https://github.com/nodejs/node/pull/27321)
* [[`ae2333db65`](https://github.com/nodejs/node/commit/ae2333db65)] - **util**: add prototype support for boxed primitives (Ruben Bridgewater) [#27351](https://github.com/nodejs/node/pull/27351)
* [[`8f3442809a`](https://github.com/nodejs/node/commit/8f3442809a)] - **util**: rename setIteratorBraces to getIteratorBraces (Ruben Bridgewater) [#27342](https://github.com/nodejs/node/pull/27342)
* [[`973d705aa9`](https://github.com/nodejs/node/commit/973d705aa9)] - **util**: improve `Symbol.toStringTag` handling (Ruben Bridgewater) [#27342](https://github.com/nodejs/node/pull/27342)

<a id="12.0.0"></a>
## 2019-04-23, Version 12.0.0 (Current), @BethGriggs

### Notable Changes

* **assert**:
    * validate required arguments (Ruben Bridgewater) [#26641](https://github.com/nodejs/node/pull/26641)
    * adjust loose assertions (Ruben Bridgewater) [#25008](https://github.com/nodejs/node/pull/25008)
* **async_hooks**:
    * remove deprecated `emitBefore` and `emitAfter` (Matteo Collina) [#26530](https://github.com/nodejs/node/pull/26530)
    * remove promise object from resource (Andreas Madsen) [#23443](https://github.com/nodejs/node/pull/23443)
* **bootstrap**: make Buffer and process non-enumerable (Ruben Bridgewater) [#24874](https://github.com/nodejs/node/pull/24874)
* **buffer**:
    * use stricter range checks (Ruben Bridgewater) [#27045](https://github.com/nodejs/node/pull/27045)
    * harden `SlowBuffer` creation (ZYSzys) [#26272](https://github.com/nodejs/node/pull/26272)
    * harden validation of buffer allocation size (ZYSzys) [#26162](https://github.com/nodejs/node/pull/26162)
    * do proper error propagation in addon methods (Anna Henningsen) [#23939](https://github.com/nodejs/node/pull/23939)
* **child_process**:
    * remove `options.customFds` (cjihrig) [#25279](https://github.com/nodejs/node/pull/25279)
    * harden fork arguments validation (ZYSzys) [#27039](https://github.com/nodejs/node/pull/27039)
    * use non-infinite `maxBuffer` defaults (kohta ito) [#23027](https://github.com/nodejs/node/pull/23027)
* **console**: don't use ANSI escape codes when `TERM=dumb` (Vladislav Kaminsky) [#26261](https://github.com/nodejs/node/pull/26261)
* **crypto**:
    * remove legacy native handles (Tobias Nießen) [#27011](https://github.com/nodejs/node/pull/27011)
    * decode missing passphrase errors (Tobias Nießen) [#25208](https://github.com/nodejs/node/pull/25208)
    * remove `Cipher.setAuthTag()` and `Decipher.getAuthTag()` (Tobias Nießen) [#26249](https://github.com/nodejs/node/pull/26249)
    * remove deprecated `crypto._toBuf()` (Tobias Nießen) [#25338](https://github.com/nodejs/node/pull/25338)
    * set `DEFAULT\_ENCODING` property to non-enumerable (Antoine du Hamel) [#23222](https://github.com/nodejs/node/pull/23222)
* **deps**:
    * update V8 to 7.4.288.13 (Michaël Zasso, cjihrig, Refael Ackermann, Anna Henningsen, Ujjwal Sharma) [#26685](https://github.com/nodejs/node/pull/26685)
    * bump minimum icu version to 63 (Ujjwal Sharma) [#25852](https://github.com/nodejs/node/pull/25852)
    * update OpenSSL to 1.1.1b (Sam Roberts, Shigeki Ohtsu) [#26327](https://github.com/nodejs/node/pull/26327)
* **errors**: update error name (Ruben Bridgewater) [#26738](https://github.com/nodejs/node/pull/26738)
* **fs**:
    * use proper .destroy() implementation for SyncWriteStream (Matteo Collina) [#26690](https://github.com/nodejs/node/pull/26690)
    * improve mode validation (Ruben Bridgewater) [#26575](https://github.com/nodejs/node/pull/26575)
    * harden validation of start option in `createWriteStream()` (ZYSzys) [#25579](https://github.com/nodejs/node/pull/25579)
    * make writeFile consistent with readFile wrt fd (Sakthipriyan Vairamani (thefourtheye)) [#23709](https://github.com/nodejs/node/pull/23709)
* **http**:
    * validate timeout in `ClientRequest()` (cjihrig) [#26214](https://github.com/nodejs/node/pull/26214)
    * return HTTP 431 on `HPE_HEADER_OVERFLOW` error (Albert Still) [#25605](https://github.com/nodejs/node/pull/25605)
    * switch default parser to llhttp (Anna Henningsen) [#24870](https://github.com/nodejs/node/pull/24870)
    * Runtime-deprecate `outgoingMessage._headers` and `outgoingMessage._headerNames` (Morgan Roderick) [#24167](https://github.com/nodejs/node/pull/24167)
* **lib**:
    * remove `Atomics.wake()` (Gus Caplan) [#27033](https://github.com/nodejs/node/pull/27033)
    * move DTRACE\_\* probes out of global scope (James M Snell) [#26541](https://github.com/nodejs/node/pull/26541)
    * deprecate `_stream_wrap` (Sam Roberts) [#26245](https://github.com/nodejs/node/pull/26245)
    * use ES6 class inheritance style (Ruben Bridgewater) [#24755](https://github.com/nodejs/node/pull/24755)
* **module**:
    * remove unintended access to deps/ (Anna Henningsen) [#25138](https://github.com/nodejs/node/pull/25138)
    * improve error message for MODULE\_NOT\_FOUND (Ali Ijaz Sheikh) [#25690](https://github.com/nodejs/node/pull/25690)
    * requireStack property for MODULE\_NOT\_FOUND (Ali Ijaz Sheikh) [#25690](https://github.com/nodejs/node/pull/25690)
    * remove dead code (Ruben Bridgewater) [#26983](https://github.com/nodejs/node/pull/26983)
    * make `require('.')` never resolve outside the current directory (Ruben Bridgewater) [#26973](https://github.com/nodejs/node/pull/26973)
    * throw an error for invalid package.json main entries (Ruben Bridgewater) [#26823](https://github.com/nodejs/node/pull/26823)
    * don't search in `require.resolve.paths` (cjihrig) [#23683](https://github.com/nodejs/node/pull/23683)
* **net**:
    * remove `Server.listenFD()` (cjihrig) [#27127](https://github.com/nodejs/node/pull/27127)
    * do not add `.host` and `.port` properties to DNS error (Ruben Bridgewater) [#26751](https://github.com/nodejs/node/pull/26751)
    * emit "write after end" errors in the next tick (Ouyang Yadong) [#24457](https://github.com/nodejs/node/pull/24457)
    * deprecate `_setSimultaneousAccepts()` undocumented function (James M Snell) [#23760](https://github.com/nodejs/node/pull/23760)
* **os**:
    * implement `os.type()` using `uv_os_uname()` (cjihrig) [#25659](https://github.com/nodejs/node/pull/25659)
    * remove `os.getNetworkInterfaces()` (cjihrig) [#25280](https://github.com/nodejs/node/pull/25280)
* **process**:
    * make global.process, global.Buffer getters (Guy Bedford) [#26882](https://github.com/nodejs/node/pull/26882)
    * move DEP0062 (node --debug) to end-of-life (Joyee Cheung) [#25828](https://github.com/nodejs/node/pull/25828)
    * exit on --debug and --debug-brk after option parsing (Joyee Cheung) [#25828](https://github.com/nodejs/node/pull/25828)
    * improve `--redirect-warnings` handling (Ruben Bridgewater) [#24965](https://github.com/nodejs/node/pull/24965)
* **readline**: support TERM=dumb (Vladislav Kaminsky) [#26261](https://github.com/nodejs/node/pull/26261)
* **repl**:
    * add welcome message (gengjiawen) [#25947](https://github.com/nodejs/node/pull/25947)
    * fix terminal default setting (Ruben Bridgewater) [#26518](https://github.com/nodejs/node/pull/26518)
    * check colors with `.getColorDepth()` (Vladislav Kaminsky) [#26261](https://github.com/nodejs/node/pull/26261)
    * deprecate REPLServer.rli (Ruben Bridgewater) [#26260](https://github.com/nodejs/node/pull/26260)
* **src**:
    * remove unused `INT_MAX` constant (Sam Roberts) [#27078](https://github.com/nodejs/node/pull/27078)
    * update `NODE_MODULE_VERSION` to 72 (Ujjwal Sharma) [#26685](https://github.com/nodejs/node/pull/26685)
    * remove `AddPromiseHook()` (Anna Henningsen) [#26574](https://github.com/nodejs/node/pull/26574)
    * clean up `MultiIsolatePlatform` interface (Anna Henningsen) [#26384](https://github.com/nodejs/node/pull/26384)
    * properly configure default heap limits (Ali Ijaz Sheikh) [#25576](https://github.com/nodejs/node/pull/25576)
    * remove `icuDataDir` from node config (GauthamBanasandra) [#24780](https://github.com/nodejs/node/pull/24780)
* **tls**:
    * support TLSv1.3 (Sam Roberts) [#26209](https://github.com/nodejs/node/pull/26209)
    * return correct version from `getCipher()` (Sam Roberts) [#26625](https://github.com/nodejs/node/pull/26625)
    * check arg types of renegotiate() (Sam Roberts) [#25876](https://github.com/nodejs/node/pull/25876)
    * add code for `ERR_TLS_INVALID_PROTOCOL_METHOD` (Sam Roberts) [#24729](https://github.com/nodejs/node/pull/24729)
    * emit a warning when servername is an IP address (Rodger Combs) [#23329](https://github.com/nodejs/node/pull/23329)
    * disable TLS v1.0 and v1.1 by default (Ben Noordhuis) [#23814](https://github.com/nodejs/node/pull/23814)
    * remove unused arg to createSecureContext() (Sam Roberts) [#24241](https://github.com/nodejs/node/pull/24241)
    * deprecate `Server.prototype.setOptions()` (cjihrig) [#23820](https://github.com/nodejs/node/pull/23820)
    * load `NODE_EXTRA_CA_CERTS` at startup (Ouyang Yadong) [#23354](https://github.com/nodejs/node/pull/23354)
* **util**:
    * remove `util.print()`, `util.puts()`, `util.debug()` and `util.error()` (cjihrig) [#25377](https://github.com/nodejs/node/pull/25377)
    * change inspect compact and breakLength default (Ruben Bridgewater) [#27109](https://github.com/nodejs/node/pull/27109)
    * improve inspect edge cases (Ruben Bridgewater) [#27109](https://github.com/nodejs/node/pull/27109)
    * only the first line of the error message (Simon Zünd) [#26685](https://github.com/nodejs/node/pull/26685)
    * don't set the prototype of callbackified functions (Ruben Bridgewater) [#26893](https://github.com/nodejs/node/pull/26893)
    * rename callbackified function (Ruben Bridgewater) [#26893](https://github.com/nodejs/node/pull/26893)
    * increase function length when using `callbackify()` (Ruben Bridgewater) [#26893](https://github.com/nodejs/node/pull/26893)
    * prevent tampering with internals in `inspect()` (Ruben Bridgewater) [#26577](https://github.com/nodejs/node/pull/26577)
    * prevent Proxy traps being triggered by `.inspect()` (Ruben Bridgewater) [#26241](https://github.com/nodejs/node/pull/26241)
    * prevent leaking internal properties (Ruben Bridgewater) [#24971](https://github.com/nodejs/node/pull/24971)
    * protect against monkeypatched Object prototype for inspect() (Rich Trott) [#25953](https://github.com/nodejs/node/pull/25953)
    * treat format arguments equally (Roman Reiss) [#23162](https://github.com/nodejs/node/pull/23162)
* **win, fs**: detect if symlink target is a directory (Bartosz Sosnowski) [#23724](https://github.com/nodejs/node/pull/23724)
* **zlib**:
    * throw TypeError if callback is missing (Anna Henningsen) [#24929](https://github.com/nodejs/node/pull/24929)
    * make “bare” constants un-enumerable (Anna Henningsen) [#24824](https://github.com/nodejs/node/pull/24824)

### Semver-Major Commits

* [[`afce912193`](https://github.com/nodejs/node/commit/afce912193)] - **(SEMVER-MAJOR)** **assert**: improve performance to instantiate errors (Ruben Bridgewater) [#26738](https://github.com/nodejs/node/pull/26738)
* [[`5a3623af74`](https://github.com/nodejs/node/commit/5a3623af74)] - **(SEMVER-MAJOR)** **assert**: validate required arguments (Ruben Bridgewater) [#26641](https://github.com/nodejs/node/pull/26641)
* [[`7493db21b6`](https://github.com/nodejs/node/commit/7493db21b6)] - **(SEMVER-MAJOR)** **assert**: adjust loose assertions (Ruben Bridgewater) [#25008](https://github.com/nodejs/node/pull/25008)
* [[`9d064439e5`](https://github.com/nodejs/node/commit/9d064439e5)] - **(SEMVER-MAJOR)** **async_hooks**: remove deprecated emitBefore and emitAfter (Matteo Collina) [#26530](https://github.com/nodejs/node/pull/26530)
* [[`1a2cf6696f`](https://github.com/nodejs/node/commit/1a2cf6696f)] - **(SEMVER-MAJOR)** **async_hooks**: remove promise object from resource (Andreas Madsen) [#23443](https://github.com/nodejs/node/pull/23443)
* [[`c992639fbd`](https://github.com/nodejs/node/commit/c992639fbd)] - **(SEMVER-MAJOR)** **bootstrap**: make Buffer and process non-enumerable (Ruben Bridgewater) [#24874](https://github.com/nodejs/node/pull/24874)
* [[`693401d0dd`](https://github.com/nodejs/node/commit/693401d0dd)] - **(SEMVER-MAJOR)** **buffer**: use stricter range checks (Ruben Bridgewater) [#27045](https://github.com/nodejs/node/pull/27045)
* [[`6113ba96cb`](https://github.com/nodejs/node/commit/6113ba96cb)] - **(SEMVER-MAJOR)** **buffer**: harden SlowBuffer creation (ZYSzys) [#26272](https://github.com/nodejs/node/pull/26272)
* [[`6fb7baf935`](https://github.com/nodejs/node/commit/6fb7baf935)] - **(SEMVER-MAJOR)** **buffer**: harden validation of buffer allocation size (ZYSzys) [#26162](https://github.com/nodejs/node/pull/26162)
* [[`c6d29ccf5a`](https://github.com/nodejs/node/commit/c6d29ccf5a)] - **(SEMVER-MAJOR)** **buffer**: do proper error propagation in addon methods (Anna Henningsen) [#23939](https://github.com/nodejs/node/pull/23939)
* [[`a7d7d4dfb7`](https://github.com/nodejs/node/commit/a7d7d4dfb7)] - **(SEMVER-MAJOR)** **build**: increase MACOS\_DEPLOYMENT\_TARGET to 10.10 (Rod Vagg) [#27275](https://github.com/nodejs/node/pull/27275)
* [[`561327702d`](https://github.com/nodejs/node/commit/561327702d)] - **(SEMVER-MAJOR)** **build**: reset embedder string to "-node.0" (Ujjwal Sharma) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`dfcc918e65`](https://github.com/nodejs/node/commit/dfcc918e65)] - **(SEMVER-MAJOR)** **build**: reset embedder string to "-node.0" (Michaël Zasso) [#25852](https://github.com/nodejs/node/pull/25852)
* [[`9334e45aa0`](https://github.com/nodejs/node/commit/9334e45aa0)] - **(SEMVER-MAJOR)** **build**: remove mips support (Ben Noordhuis) [#26192](https://github.com/nodejs/node/pull/26192)
* [[`bb564a3688`](https://github.com/nodejs/node/commit/bb564a3688)] - **(SEMVER-MAJOR)** **build**: update prerequisites on progress towards Python 3 (cclauss) [#25766](https://github.com/nodejs/node/pull/25766)
* [[`3c332abe28`](https://github.com/nodejs/node/commit/3c332abe28)] - **(SEMVER-MAJOR)** **build**: reset embedder string to "-node.0" (Michaël Zasso) [#23423](https://github.com/nodejs/node/pull/23423)
* [[`765766be64`](https://github.com/nodejs/node/commit/765766be64)] - **(SEMVER-MAJOR)** **build**: add common `defines` (Refael Ackermann) [#23426](https://github.com/nodejs/node/pull/23426)
* [[`3b5773fee3`](https://github.com/nodejs/node/commit/3b5773fee3)] - **(SEMVER-MAJOR)** **build,deps**: move gypfiles out 2/2 - moving (Refael Ackermann) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`3531fe9320`](https://github.com/nodejs/node/commit/3531fe9320)] - **(SEMVER-MAJOR)** **build,deps**: add `NOMINMAX` to V8 Windows builds (Refael Ackermann) [#25852](https://github.com/nodejs/node/pull/25852)
* [[`ff5d632a83`](https://github.com/nodejs/node/commit/ff5d632a83)] - **(SEMVER-MAJOR)** **build,deps**: fix V8 snapshot gyp dependencies (Refael Ackermann) [#25852](https://github.com/nodejs/node/pull/25852)
* [[`ecf98b0839`](https://github.com/nodejs/node/commit/ecf98b0839)] - **(SEMVER-MAJOR)** **build,meta**: quiet/pretty make output by default (Refael Ackermann) [#26740](https://github.com/nodejs/node/pull/26740)
* [[`2f477bd34d`](https://github.com/nodejs/node/commit/2f477bd34d)] - **(SEMVER-MAJOR)** **build,win**: mark x86 image as not SAFESEH (Refael Ackermann) [#25852](https://github.com/nodejs/node/pull/25852)
* [[`652877e3a9`](https://github.com/nodejs/node/commit/652877e3a9)] - **(SEMVER-MAJOR)** **child_process**: change the defaults maxBuffer size (kohta ito) [#27179](https://github.com/nodejs/node/pull/27179)
* [[`9ad5106934`](https://github.com/nodejs/node/commit/9ad5106934)] - **(SEMVER-MAJOR)** **child_process**: harden fork arguments validation (ZYSzys) [#27039](https://github.com/nodejs/node/pull/27039)
* [[`eb8a51a35c`](https://github.com/nodejs/node/commit/eb8a51a35c)] - **(SEMVER-MAJOR)** **child_process**: use non-infinite maxBuffer defaults (kohta ito) [#23027](https://github.com/nodejs/node/pull/23027)
* [[`99523758dc`](https://github.com/nodejs/node/commit/99523758dc)] - **(SEMVER-MAJOR)** **console**: don't use ANSI escape codes when TERM=dumb (Vladislav Kaminsky) [#26261](https://github.com/nodejs/node/pull/26261)
* [[`2f1ed5c063`](https://github.com/nodejs/node/commit/2f1ed5c063)] - **(SEMVER-MAJOR)** **crypto**: remove legacy native handles (Tobias Nießen) [#27011](https://github.com/nodejs/node/pull/27011)
* [[`2e2c015422`](https://github.com/nodejs/node/commit/2e2c015422)] - **(SEMVER-MAJOR)** **crypto**: decode missing passphrase errors (Tobias Nießen) [#25208](https://github.com/nodejs/node/pull/25208)
* [[`b8018f407b`](https://github.com/nodejs/node/commit/b8018f407b)] - **(SEMVER-MAJOR)** **crypto**: move DEP0113 to End-of-Life (Tobias Nießen) [#26249](https://github.com/nodejs/node/pull/26249)
* [[`bf3cb3f9b1`](https://github.com/nodejs/node/commit/bf3cb3f9b1)] - **(SEMVER-MAJOR)** **crypto**: remove deprecated crypto.\_toBuf (Tobias Nießen) [#25338](https://github.com/nodejs/node/pull/25338)
* [[`0f63d84f80`](https://github.com/nodejs/node/commit/0f63d84f80)] - **(SEMVER-MAJOR)** **crypto**: set `DEFAULT\_ENCODING` property to non-enumerable (Antoine du Hamel) [#23222](https://github.com/nodejs/node/pull/23222)
* [[`95e779a6e9`](https://github.com/nodejs/node/commit/95e779a6e9)] - **(SEMVER-MAJOR)** **deps**: silence irrelevant V8 warning (Michaël Zasso) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`08efd3060d`](https://github.com/nodejs/node/commit/08efd3060d)] - **(SEMVER-MAJOR)** **deps**: update postmortem metadata generation script (cjihrig) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`0da7e99f98`](https://github.com/nodejs/node/commit/0da7e99f98)] - **(SEMVER-MAJOR)** **deps**: V8: un-cherry-pick bd019bd (Refael Ackermann) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`b1015e0de8`](https://github.com/nodejs/node/commit/b1015e0de8)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick 6 commits (Michaël Zasso) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`8181811d73`](https://github.com/nodejs/node/commit/8181811d73)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick d82c9af (Anna Henningsen) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`1f03fb4d49`](https://github.com/nodejs/node/commit/1f03fb4d49)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick e5f01ba (Anna Henningsen) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`e6af2207a9`](https://github.com/nodejs/node/commit/e6af2207a9)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick d5f08e4 (Anna Henningsen) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`963061bc02`](https://github.com/nodejs/node/commit/963061bc02)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick 6b09d21 (Anna Henningsen) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`b7338b700f`](https://github.com/nodejs/node/commit/b7338b700f)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick f0bb5d2 (Anna Henningsen) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`02171949a0`](https://github.com/nodejs/node/commit/02171949a0)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick 5b0510d (Anna Henningsen) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`bf572c7831`](https://github.com/nodejs/node/commit/bf572c7831)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick 91f0cd0 (Anna Henningsen) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`09f134fccf`](https://github.com/nodejs/node/commit/09f134fccf)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick 392316d (Anna Henningsen) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`53ea813d5c`](https://github.com/nodejs/node/commit/53ea813d5c)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick 2f79d68 (Anna Henningsen) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`cc75ba3f14`](https://github.com/nodejs/node/commit/cc75ba3f14)] - **(SEMVER-MAJOR)** **deps**: sync V8 gypfiles with 7.4 (Ujjwal Sharma) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`f579e11940`](https://github.com/nodejs/node/commit/f579e11940)] - **(SEMVER-MAJOR)** **deps**: update V8 to 7.4.288.13 (Ujjwal Sharma) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`e0b3de1e90`](https://github.com/nodejs/node/commit/e0b3de1e90)] - **(SEMVER-MAJOR)** **deps**: bump minimum icu version to 63 (Ujjwal Sharma) [#25852](https://github.com/nodejs/node/pull/25852)
* [[`1c494b0a95`](https://github.com/nodejs/node/commit/1c494b0a95)] - **(SEMVER-MAJOR)** **deps**: silence irrelevant V8 warnings (Michaël Zasso) [#25852](https://github.com/nodejs/node/pull/25852)
* [[`cec35a5eb9`](https://github.com/nodejs/node/commit/cec35a5eb9)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick 7803fa6 (Jon Kunkee) [#25852](https://github.com/nodejs/node/pull/25852)
* [[`0d4d6b39a7`](https://github.com/nodejs/node/commit/0d4d6b39a7)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick 58cefed (Jon Kunkee) [#25852](https://github.com/nodejs/node/pull/25852)
* [[`bea1a386a3`](https://github.com/nodejs/node/commit/bea1a386a3)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick d3308d0 (Michaël Zasso) [#25852](https://github.com/nodejs/node/pull/25852)
* [[`cf649c9b02`](https://github.com/nodejs/node/commit/cf649c9b02)] - **(SEMVER-MAJOR)** **deps**: V8: cherry-pick 74571c8 (Michaël Zasso) [#25852](https://github.com/nodejs/node/pull/25852)
* [[`44d5401b8d`](https://github.com/nodejs/node/commit/44d5401b8d)] - **(SEMVER-MAJOR)** **deps**: cherry-pick fc0ddf5 from upstream V8 (Anna Henningsen) [#25852](https://github.com/nodejs/node/pull/25852)
* [[`cefb8029cd`](https://github.com/nodejs/node/commit/cefb8029cd)] - **(SEMVER-MAJOR)** **deps**: sync V8 gypfiles with 7.3 (Ujjwal Sharma) [#25852](https://github.com/nodejs/node/pull/25852)
* [[`d266e3e2cf`](https://github.com/nodejs/node/commit/d266e3e2cf)] - **(SEMVER-MAJOR)** **deps**: sync V8 gypfiles with 7.2 (Michaël Zasso) [#25852](https://github.com/nodejs/node/pull/25852)
* [[`7b48713334`](https://github.com/nodejs/node/commit/7b48713334)] - **(SEMVER-MAJOR)** **deps**: update V8 to 7.3.492.25 (Michaël Zasso) [#25852](https://github.com/nodejs/node/pull/25852)
* [[`6df7bd6c3b`](https://github.com/nodejs/node/commit/6df7bd6c3b)] - **(SEMVER-MAJOR)** **deps**: add s390 asm rules for OpenSSL-1.1.1 (Shigeki Ohtsu) [#19794](https://github.com/nodejs/node/pull/19794)
* [[`5620727f30`](https://github.com/nodejs/node/commit/5620727f30)] - **(SEMVER-MAJOR)** **deps**: sync V8 gypfiles with 7.1 (Refael Ackermann) [#23423](https://github.com/nodejs/node/pull/23423)
* [[`9b4bf7de6c`](https://github.com/nodejs/node/commit/9b4bf7de6c)] - **(SEMVER-MAJOR)** **deps**: update V8 to 7.1.302.28 (Michaël Zasso) [#23423](https://github.com/nodejs/node/pull/23423)
* [[`3d8b844112`](https://github.com/nodejs/node/commit/3d8b844112)] - **(SEMVER-MAJOR)** **deps,build**: move gypfiles out 1/2 - required changes (Refael Ackermann) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`fff922afee`](https://github.com/nodejs/node/commit/fff922afee)] - **(SEMVER-MAJOR)** **deps,build**: compute torque\_outputs in v8.gyp (Refael Ackermann) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`4507246adc`](https://github.com/nodejs/node/commit/4507246adc)] - **(SEMVER-MAJOR)** **deps,build**: refactor v8 gypfiles (Refael Ackermann) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`b581d59655`](https://github.com/nodejs/node/commit/b581d59655)] - **(SEMVER-MAJOR)** **doc**: update supported platforms for Node.js 12 (Rod Vagg) [#26714](https://github.com/nodejs/node/pull/26714)
* [[`309e7723ea`](https://github.com/nodejs/node/commit/309e7723ea)] - **(SEMVER-MAJOR)** **doc**: update behaviour of fs.writeFile (Sakthipriyan Vairamani (thefourtheye)) [#25080](https://github.com/nodejs/node/pull/25080)
* [[`89740a4f0e`](https://github.com/nodejs/node/commit/89740a4f0e)] - **(SEMVER-MAJOR)** **doc**: add internal functionality details of util.inherits (Ruben Bridgewater) [#24755](https://github.com/nodejs/node/pull/24755)
* [[`1ed3c54ecb`](https://github.com/nodejs/node/commit/1ed3c54ecb)] - **(SEMVER-MAJOR)** **errors**: update error name (Ruben Bridgewater) [#26738](https://github.com/nodejs/node/pull/26738)
* [[`abafd38c8d`](https://github.com/nodejs/node/commit/abafd38c8d)] - **(SEMVER-MAJOR)** **fs**: use proper .destroy() implementation for SyncWriteStream (Matteo Collina) [#26690](https://github.com/nodejs/node/pull/26690)
* [[`1cdeb9f956`](https://github.com/nodejs/node/commit/1cdeb9f956)] - **(SEMVER-MAJOR)** **fs**: improve mode validation (Ruben Bridgewater) [#26575](https://github.com/nodejs/node/pull/26575)
* [[`70f4f08a9f`](https://github.com/nodejs/node/commit/70f4f08a9f)] - **(SEMVER-MAJOR)** **fs**: harden validation of start option in createWriteStream (ZYSzys) [#25579](https://github.com/nodejs/node/pull/25579)
* [[`8f4b924f4a`](https://github.com/nodejs/node/commit/8f4b924f4a)] - **(SEMVER-MAJOR)** **fs**: make writeFile consistent with readFile wrt fd (Sakthipriyan Vairamani (thefourtheye)) [#23709](https://github.com/nodejs/node/pull/23709)
* [[`907941d48e`](https://github.com/nodejs/node/commit/907941d48e)] - **(SEMVER-MAJOR)** **http**: validate timeout in ClientRequest() (cjihrig) [#26214](https://github.com/nodejs/node/pull/26214)
* [[`bcf2886a84`](https://github.com/nodejs/node/commit/bcf2886a84)] - **(SEMVER-MAJOR)** **http**: return HTTP 431 on HPE\_HEADER\_OVERFLOW error (Albert Still) [#25605](https://github.com/nodejs/node/pull/25605)
* [[`2cb8f24751`](https://github.com/nodejs/node/commit/2cb8f24751)] - **(SEMVER-MAJOR)** **http**: switch default parser to llhttp (Anna Henningsen) [#24870](https://github.com/nodejs/node/pull/24870)
* [[`91748dd89c`](https://github.com/nodejs/node/commit/91748dd89c)] - **(SEMVER-MAJOR)** **http**: change DEP0066 to a runtime deprecation (Morgan Roderick) [#24167](https://github.com/nodejs/node/pull/24167)
* [[`f3b49cfa7b`](https://github.com/nodejs/node/commit/f3b49cfa7b)] - **(SEMVER-MAJOR)** **http**: else case is not reachable (szabolcsit) [#24176](https://github.com/nodejs/node/pull/24176)
* [[`bd9109c241`](https://github.com/nodejs/node/commit/bd9109c241)] - **(SEMVER-MAJOR)** **lib**: move DEP0021 to end of life (cjihrig) [#27127](https://github.com/nodejs/node/pull/27127)
* [[`15c0947fee`](https://github.com/nodejs/node/commit/15c0947fee)] - **(SEMVER-MAJOR)** **lib**: remove Atomics.wake (Gus Caplan) [#27033](https://github.com/nodejs/node/pull/27033)
* [[`3fe1e80896`](https://github.com/nodejs/node/commit/3fe1e80896)] - **(SEMVER-MAJOR)** **lib**: validate Error.captureStackTrace() calls (Ruben Bridgewater) [#26738](https://github.com/nodejs/node/pull/26738)
* [[`bfbce289c3`](https://github.com/nodejs/node/commit/bfbce289c3)] - **(SEMVER-MAJOR)** **lib**: refactor Error.captureStackTrace() usage (Ruben Bridgewater) [#26738](https://github.com/nodejs/node/pull/26738)
* [[`f9ddbb6b2f`](https://github.com/nodejs/node/commit/f9ddbb6b2f)] - **(SEMVER-MAJOR)** **lib**: move DTRACE\_\* probes out of global scope (James M Snell) [#26541](https://github.com/nodejs/node/pull/26541)
* [[`c7e628f8b3`](https://github.com/nodejs/node/commit/c7e628f8b3)] - **(SEMVER-MAJOR)** **lib**: deprecate \_stream\_wrap (Sam Roberts) [#26245](https://github.com/nodejs/node/pull/26245)
* [[`be78266fb3`](https://github.com/nodejs/node/commit/be78266fb3)] - **(SEMVER-MAJOR)** **lib**: don't use `util.inspect()` internals (Ruben Bridgewater) [#24971](https://github.com/nodejs/node/pull/24971)
* [[`a02e3e2d5f`](https://github.com/nodejs/node/commit/a02e3e2d5f)] - **(SEMVER-MAJOR)** **lib**: improve error message for MODULE\_NOT\_FOUND (Ali Ijaz Sheikh) [#25690](https://github.com/nodejs/node/pull/25690)
* [[`05cd1a0929`](https://github.com/nodejs/node/commit/05cd1a0929)] - **(SEMVER-MAJOR)** **lib**: requireStack property for MODULE\_NOT\_FOUND (Ali Ijaz Sheikh) [#25690](https://github.com/nodejs/node/pull/25690)
* [[`29d3d1ea13`](https://github.com/nodejs/node/commit/29d3d1ea13)] - **(SEMVER-MAJOR)** **lib**: move DEP0029 to end of life (cjihrig) [#25377](https://github.com/nodejs/node/pull/25377)
* [[`a665d13ad9`](https://github.com/nodejs/node/commit/a665d13ad9)] - **(SEMVER-MAJOR)** **lib**: move DEP0028 to end of life (cjihrig) [#25377](https://github.com/nodejs/node/pull/25377)
* [[`10df21b071`](https://github.com/nodejs/node/commit/10df21b071)] - **(SEMVER-MAJOR)** **lib**: move DEP0027 to end of life (cjihrig) [#25377](https://github.com/nodejs/node/pull/25377)
* [[`2d578ad996`](https://github.com/nodejs/node/commit/2d578ad996)] - **(SEMVER-MAJOR)** **lib**: move DEP0026 to end of life (cjihrig) [#25377](https://github.com/nodejs/node/pull/25377)
* [[`853bee0acf`](https://github.com/nodejs/node/commit/853bee0acf)] - **(SEMVER-MAJOR)** **lib**: move DEP0023 to end of life (cjihrig) [#25280](https://github.com/nodejs/node/pull/25280)
* [[`d4934ae6f2`](https://github.com/nodejs/node/commit/d4934ae6f2)] - **(SEMVER-MAJOR)** **lib**: move DEP0006 to end of life (cjihrig) [#25279](https://github.com/nodejs/node/pull/25279)
* [[`4100001624`](https://github.com/nodejs/node/commit/4100001624)] - **(SEMVER-MAJOR)** **lib**: remove unintended access to deps/ (Anna Henningsen) [#25138](https://github.com/nodejs/node/pull/25138)
* [[`b416dafb87`](https://github.com/nodejs/node/commit/b416dafb87)] - **(SEMVER-MAJOR)** **lib**: move DEP0120 to end of life (cjihrig) [#24862](https://github.com/nodejs/node/pull/24862)
* [[`59257543c3`](https://github.com/nodejs/node/commit/59257543c3)] - **(SEMVER-MAJOR)** **lib**: use ES6 class inheritance style (Ruben Bridgewater) [#24755](https://github.com/nodejs/node/pull/24755)
* [[`dcc82b37b6`](https://github.com/nodejs/node/commit/dcc82b37b6)] - **(SEMVER-MAJOR)** **lib**: remove `inherits()` usage (Ruben Bridgewater) [#24755](https://github.com/nodejs/node/pull/24755)
* [[`d11c4beb4b`](https://github.com/nodejs/node/commit/d11c4beb4b)] - **(SEMVER-MAJOR)** **module**: remove dead code (Ruben Bridgewater) [#26983](https://github.com/nodejs/node/pull/26983)
* [[`75007d64c0`](https://github.com/nodejs/node/commit/75007d64c0)] - **(SEMVER-MAJOR)** **module**: mark DEP0019 as End-of-Life (Ruben Bridgewater) [#26973](https://github.com/nodejs/node/pull/26973)
* [[`115f0f5a57`](https://github.com/nodejs/node/commit/115f0f5a57)] - **(SEMVER-MAJOR)** **module**: throw an error for invalid package.json main entries (Ruben Bridgewater) [#26823](https://github.com/nodejs/node/pull/26823)
* [[`60ce2fd827`](https://github.com/nodejs/node/commit/60ce2fd827)] - **(SEMVER-MAJOR)** **module**: don't search in require.resolve.paths (cjihrig) [#23683](https://github.com/nodejs/node/pull/23683)
* [[`f0f26cedcc`](https://github.com/nodejs/node/commit/f0f26cedcc)] - **(SEMVER-MAJOR)** **n-api**: remove code from error name (Ruben Bridgewater) [#26738](https://github.com/nodejs/node/pull/26738)
* [[`96204c3c71`](https://github.com/nodejs/node/commit/96204c3c71)] - **(SEMVER-MAJOR)** **net**: do not manipulate potential user code (Ruben Bridgewater) [#26751](https://github.com/nodejs/node/pull/26751)
* [[`9389b464ea`](https://github.com/nodejs/node/commit/9389b464ea)] - **(SEMVER-MAJOR)** **net**: emit "write after end" errors in the next tick (Ouyang Yadong) [#24457](https://github.com/nodejs/node/pull/24457)
* [[`1523111250`](https://github.com/nodejs/node/commit/1523111250)] - **(SEMVER-MAJOR)** **net**: deprecate \_setSimultaneousAccepts() undocumented function (James M Snell) [#23760](https://github.com/nodejs/node/pull/23760)
* [[`802ea05a37`](https://github.com/nodejs/node/commit/802ea05a37)] - **(SEMVER-MAJOR)** **net,http2**: merge setTimeout code (ZYSzys) [#25084](https://github.com/nodejs/node/pull/25084)
* [[`16e4cd19f2`](https://github.com/nodejs/node/commit/16e4cd19f2)] - **(SEMVER-MAJOR)** **os**: implement os.type() using uv\_os\_uname() (cjihrig) [#25659](https://github.com/nodejs/node/pull/25659)
* [[`53ebd3311d`](https://github.com/nodejs/node/commit/53ebd3311d)] - **(SEMVER-MAJOR)** **process**: global.process, global.Buffer getters (Guy Bedford) [#26882](https://github.com/nodejs/node/pull/26882)
* [[`fa5e097530`](https://github.com/nodejs/node/commit/fa5e097530)] - **(SEMVER-MAJOR)** **process**: move DEP0062 (node --debug) to end-of-life (Joyee Cheung) [#25828](https://github.com/nodejs/node/pull/25828)
* [[`154efc9bde`](https://github.com/nodejs/node/commit/154efc9bde)] - **(SEMVER-MAJOR)** **process**: exit on --debug and --debug-brk after option parsing (Joyee Cheung) [#25828](https://github.com/nodejs/node/pull/25828)
* [[`3439c955ab`](https://github.com/nodejs/node/commit/3439c955ab)] - **(SEMVER-MAJOR)** **process**: improve `--redirect-warnings` handling (Ruben Bridgewater) [#24965](https://github.com/nodejs/node/pull/24965)
* [[`d3a62fe7fc`](https://github.com/nodejs/node/commit/d3a62fe7fc)] - **(SEMVER-MAJOR)** **readline**: support TERM=dumb (Vladislav Kaminsky) [#26261](https://github.com/nodejs/node/pull/26261)
* [[`fe963149f6`](https://github.com/nodejs/node/commit/fe963149f6)] - **(SEMVER-MAJOR)** **repl**: add welcome message (gengjiawen) [#25947](https://github.com/nodejs/node/pull/25947)
* [[`97737fd5fb`](https://github.com/nodejs/node/commit/97737fd5fb)] - **(SEMVER-MAJOR)** **repl**: fix terminal default setting (Ruben Bridgewater) [#26518](https://github.com/nodejs/node/pull/26518)
* [[`82b3ee776b`](https://github.com/nodejs/node/commit/82b3ee776b)] - **(SEMVER-MAJOR)** **repl**: check colors with .getColorDepth() (Vladislav Kaminsky) [#26261](https://github.com/nodejs/node/pull/26261)
* [[`584305841d`](https://github.com/nodejs/node/commit/584305841d)] - **(SEMVER-MAJOR)** **repl**: deprecate REPLServer.rli (Ruben Bridgewater) [#26260](https://github.com/nodejs/node/pull/26260)
* [[`bf766c1b44`](https://github.com/nodejs/node/commit/bf766c1b44)] - **(SEMVER-MAJOR)** **src**: remove unused INT\_MAX constant (Sam Roberts) [#27078](https://github.com/nodejs/node/pull/27078)
* [[`7df9e77236`](https://github.com/nodejs/node/commit/7df9e77236)] - **(SEMVER-MAJOR)** **src**: update NODE\_MODULE\_VERSION to 72 (Ujjwal Sharma) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`96c3224de0`](https://github.com/nodejs/node/commit/96c3224de0)] - **(SEMVER-MAJOR)** **src**: remove `AddPromiseHook()` (Anna Henningsen) [#26574](https://github.com/nodejs/node/pull/26574)
* [[`9577f7724d`](https://github.com/nodejs/node/commit/9577f7724d)] - **(SEMVER-MAJOR)** **src**: update NODE\_MODULE\_VERSION to 71 (Michaël Zasso) [#25852](https://github.com/nodejs/node/pull/25852)
* [[`6d9aa73b1f`](https://github.com/nodejs/node/commit/6d9aa73b1f)] - **(SEMVER-MAJOR)** **src**: clean up MultiIsolatePlatform interface (Anna Henningsen) [#26384](https://github.com/nodejs/node/pull/26384)
* [[`1d996f58af`](https://github.com/nodejs/node/commit/1d996f58af)] - **(SEMVER-MAJOR)** **src**: properly configure default heap limits (Ali Ijaz Sheikh) [#25576](https://github.com/nodejs/node/pull/25576)
* [[`9021b0d3fc`](https://github.com/nodejs/node/commit/9021b0d3fc)] - **(SEMVER-MAJOR)** **src**: remove icuDataDir from node config (GauthamBanasandra) [#24780](https://github.com/nodejs/node/pull/24780)
* [[`a6f69ebc05`](https://github.com/nodejs/node/commit/a6f69ebc05)] - **(SEMVER-MAJOR)** **src**: explicitly allow JS in ReadHostObject (Yang Guo) [#23423](https://github.com/nodejs/node/pull/23423)
* [[`3d25544148`](https://github.com/nodejs/node/commit/3d25544148)] - **(SEMVER-MAJOR)** **src**: update postmortem constant (cjihrig) [#23423](https://github.com/nodejs/node/pull/23423)
* [[`23603447ad`](https://github.com/nodejs/node/commit/23603447ad)] - **(SEMVER-MAJOR)** **src**: update NODE\_MODULE\_VERSION to 68 (Michaël Zasso) [#23423](https://github.com/nodejs/node/pull/23423)
* [[`afad3b443e`](https://github.com/nodejs/node/commit/afad3b443e)] - **(SEMVER-MAJOR)** **test**: update postmortem metadata test for V8 7.4 (cjihrig) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`e96e3f9eb0`](https://github.com/nodejs/node/commit/e96e3f9eb0)] - **(SEMVER-MAJOR)** **test**: remove redundant common.mustCall (Ruben Bridgewater) [#26738](https://github.com/nodejs/node/pull/26738)
* [[`01b112a031`](https://github.com/nodejs/node/commit/01b112a031)] - **(SEMVER-MAJOR)** **test**: update postmortem metadata test for V8 7.3 (cjihrig) [#25852](https://github.com/nodejs/node/pull/25852)
* [[`38ad285a2e`](https://github.com/nodejs/node/commit/38ad285a2e)] - **(SEMVER-MAJOR)** **test**: fix tests after V8 update (Michaël Zasso) [#25852](https://github.com/nodejs/node/pull/25852)
* [[`260d5f8c3b`](https://github.com/nodejs/node/commit/260d5f8c3b)] - **(SEMVER-MAJOR)** **test**: update test-v8-stats (Michaël Zasso) [#25852](https://github.com/nodejs/node/pull/25852)
* [[`78c8491a7e`](https://github.com/nodejs/node/commit/78c8491a7e)] - **(SEMVER-MAJOR)** **test**: remove apply calls over 65534 arg limit (Peter Marshall) [#25852](https://github.com/nodejs/node/pull/25852)
* [[`22a9fe3552`](https://github.com/nodejs/node/commit/22a9fe3552)] - **(SEMVER-MAJOR)** **test**: add test for net-socket-setTimeout callback (ZYSzys) [#25084](https://github.com/nodejs/node/pull/25084)
* [[`379bf1aa8e`](https://github.com/nodejs/node/commit/379bf1aa8e)] - **(SEMVER-MAJOR)** **test**: update postmortem metadata test for V8 7.1 (cjihrig) [#23423](https://github.com/nodejs/node/pull/23423)
* [[`624a242b05`](https://github.com/nodejs/node/commit/624a242b05)] - **(SEMVER-MAJOR)** **test**: simplify regression test for SEGV (Sam Roberts) [#24241](https://github.com/nodejs/node/pull/24241)
* [[`42dbaed460`](https://github.com/nodejs/node/commit/42dbaed460)] - **(SEMVER-MAJOR)** **tls**: support TLSv1.3 (Sam Roberts) [#26209](https://github.com/nodejs/node/pull/26209)
* [[`0f745bf9bd`](https://github.com/nodejs/node/commit/0f745bf9bd)] - **(SEMVER-MAJOR)** **tls**: return correct version from getCipher() (Sam Roberts) [#26625](https://github.com/nodejs/node/pull/26625)
* [[`6b7c402518`](https://github.com/nodejs/node/commit/6b7c402518)] - **(SEMVER-MAJOR)** **tls**: check arg types of renegotiate() (Sam Roberts) [#25876](https://github.com/nodejs/node/pull/25876)
* [[`b05b330025`](https://github.com/nodejs/node/commit/b05b330025)] - **(SEMVER-MAJOR)** **tls**: add code for ERR\_TLS\_INVALID\_PROTOCOL\_METHOD (Sam Roberts) [#24729](https://github.com/nodejs/node/pull/24729)
* [[`9b2ffff62c`](https://github.com/nodejs/node/commit/9b2ffff62c)] - **(SEMVER-MAJOR)** **tls**: emit a warning when servername is an IP address (Rodger Combs) [#23329](https://github.com/nodejs/node/pull/23329)
* [[`60eca6a5d4`](https://github.com/nodejs/node/commit/60eca6a5d4)] - **(SEMVER-MAJOR)** **tls**: disable TLS v1.0 and v1.1 by default (Ben Noordhuis) [#23814](https://github.com/nodejs/node/pull/23814)
* [[`3b4159c8ed`](https://github.com/nodejs/node/commit/3b4159c8ed)] - **(SEMVER-MAJOR)** **tls**: remove unused arg to createSecureContext() (Sam Roberts) [#24241](https://github.com/nodejs/node/pull/24241)
* [[`246a6fc107`](https://github.com/nodejs/node/commit/246a6fc107)] - **(SEMVER-MAJOR)** **tls**: deprecate Server.prototype.setOptions() (cjihrig) [#23820](https://github.com/nodejs/node/pull/23820)
* [[`87719d792b`](https://github.com/nodejs/node/commit/87719d792b)] - **(SEMVER-MAJOR)** **tls**: load NODE\_EXTRA\_CA\_CERTS at startup (Ouyang Yadong) [#23354](https://github.com/nodejs/node/pull/23354)
* [[`c9fece38c8`](https://github.com/nodejs/node/commit/c9fece38c8)] - **(SEMVER-MAJOR)** **util**: change inspect compact and breakLength default (Ruben Bridgewater) [#27109](https://github.com/nodejs/node/pull/27109)
* [[`892c51f330`](https://github.com/nodejs/node/commit/892c51f330)] - **(SEMVER-MAJOR)** **util**: improve inspect edge cases (Ruben Bridgewater) [#27109](https://github.com/nodejs/node/pull/27109)
* [[`63e13fd220`](https://github.com/nodejs/node/commit/63e13fd220)] - **(SEMVER-MAJOR)** **util**: only the first line of the error message (Simon Zünd) [#26685](https://github.com/nodejs/node/pull/26685)
* [[`b5ea925c8e`](https://github.com/nodejs/node/commit/b5ea925c8e)] - **(SEMVER-MAJOR)** **util**: don't set the prototype of callbackified functions (Ruben Bridgewater) [#26893](https://github.com/nodejs/node/pull/26893)
* [[`46bf0d0f4f`](https://github.com/nodejs/node/commit/46bf0d0f4f)] - **(SEMVER-MAJOR)** **util**: rename callbackified function (Ruben Bridgewater) [#26893](https://github.com/nodejs/node/pull/26893)
* [[`61d1334e5b`](https://github.com/nodejs/node/commit/61d1334e5b)] - **(SEMVER-MAJOR)** **util**: increase function length when using `callbackify()` (Ruben Bridgewater) [#26893](https://github.com/nodejs/node/pull/26893)
* [[`5672ab7668`](https://github.com/nodejs/node/commit/5672ab7668)] - **(SEMVER-MAJOR)** **util**: prevent tampering with internals in `inspect()` (Ruben Bridgewater) [#26577](https://github.com/nodejs/node/pull/26577)
* [[`a32cbe1597`](https://github.com/nodejs/node/commit/a32cbe1597)] - **(SEMVER-MAJOR)** **util**: fix proxy inspection (Ruben Bridgewater) [#26241](https://github.com/nodejs/node/pull/26241)
* [[`7b674697d8`](https://github.com/nodejs/node/commit/7b674697d8)] - **(SEMVER-MAJOR)** **util**: prevent leaking internal properties (Ruben Bridgewater) [#24971](https://github.com/nodejs/node/pull/24971)
* [[`1847696f4b`](https://github.com/nodejs/node/commit/1847696f4b)] - **(SEMVER-MAJOR)** **util**: protect against monkeypatched Object prototype for inspect() (Rich Trott) [#25953](https://github.com/nodejs/node/pull/25953)
* [[`c1b9be53c8`](https://github.com/nodejs/node/commit/c1b9be53c8)] - **(SEMVER-MAJOR)** **util**: treat format arguments equally (Roman Reiss) [#23162](https://github.com/nodejs/node/pull/23162)
* [[`cda6b20816`](https://github.com/nodejs/node/commit/cda6b20816)] - **(SEMVER-MAJOR)** **win, fs**: detect if symlink target is a directory (Bartosz Sosnowski) [#23724](https://github.com/nodejs/node/pull/23724)
* [[`9a2654601e`](https://github.com/nodejs/node/commit/9a2654601e)] - **(SEMVER-MAJOR)** **zlib**: throw TypeError if callback is missing (Anna Henningsen) [#24929](https://github.com/nodejs/node/pull/24929)
* [[`4eee55d354`](https://github.com/nodejs/node/commit/4eee55d354)] - **(SEMVER-MAJOR)** **zlib**: make “bare” constants un-enumerable (Anna Henningsen) [#24824](https://github.com/nodejs/node/pull/24824)

### Semver-Minor Commits

* [[`3d8532f851`](https://github.com/nodejs/node/commit/3d8532f851)] - **(SEMVER-MINOR)** **buffer**: add {read|write}Big\[U\]Int64{BE|LE} methods (Nikolai Vavilov) [#19691](https://github.com/nodejs/node/pull/19691)
* [[`969bd1eb7b`](https://github.com/nodejs/node/commit/969bd1eb7b)] - **(SEMVER-MINOR)** **crypto**: add support for RSA-PSS keys (Tobias Nießen) [#26960](https://github.com/nodejs/node/pull/26960)
* [[`7d0e50dcfe`](https://github.com/nodejs/node/commit/7d0e50dcfe)] - **(SEMVER-MINOR)** **crypto**: add crypto.sign() and crypto.verify() (Brian White) [#26611](https://github.com/nodejs/node/pull/26611)
* [[`bcbd35a48d`](https://github.com/nodejs/node/commit/bcbd35a48d)] - **(SEMVER-MINOR)** **crypto**: add openssl specific error properties (Sam Roberts) [#26868](https://github.com/nodejs/node/pull/26868)
* [[`85fda7e848`](https://github.com/nodejs/node/commit/85fda7e848)] - **(SEMVER-MINOR)** **crypto**: add support for x25119 and x448 KeyObjects (Filip Skokan) [#26774](https://github.com/nodejs/node/pull/26774)
* [[`3a9592496c`](https://github.com/nodejs/node/commit/3a9592496c)] - **(SEMVER-MINOR)** **crypto**: add support for EdDSA key pair generation (Tobias Nießen) [#26554](https://github.com/nodejs/node/pull/26554)
* [[`4895927a0a`](https://github.com/nodejs/node/commit/4895927a0a)] - **(SEMVER-MINOR)** **crypto**: add KeyObject.asymmetricKeySize (Patrick Gansterer) [#26387](https://github.com/nodejs/node/pull/26387)
* [[`2161690024`](https://github.com/nodejs/node/commit/2161690024)] - **(SEMVER-MINOR)** **deps**: update nghttp2 to 1.38.0 (gengjiawen) [#27295](https://github.com/nodejs/node/pull/27295)
* [[`ffd2df063c`](https://github.com/nodejs/node/commit/ffd2df063c)] - **(SEMVER-MINOR)** **doc**: update util colors (Ruben Bridgewater) [#27052](https://github.com/nodejs/node/pull/27052)
* [[`b1094dbe19`](https://github.com/nodejs/node/commit/b1094dbe19)] - **(SEMVER-MINOR)** **esm**: phase two of new esm implementation (guybedford) [#26745](https://github.com/nodejs/node/pull/26745)
* [[`e0e3084482`](https://github.com/nodejs/node/commit/e0e3084482)] - **(SEMVER-MINOR)** **inspector**: implement --cpu-prof\[-path\] (Joyee Cheung) [#27147](https://github.com/nodejs/node/pull/27147)
* [[`9f1282d536`](https://github.com/nodejs/node/commit/9f1282d536)] - **(SEMVER-MINOR)** **lib**: move queueMicrotask to stable (Gus Caplan) [#25594](https://github.com/nodejs/node/pull/25594)
* [[`9b6b567bc4`](https://github.com/nodejs/node/commit/9b6b567bc4)] - **(SEMVER-MINOR)** **lib,src,doc**: add --heapsnapshot-signal CLI flag (cjihrig) [#27133](https://github.com/nodejs/node/pull/27133)
* [[`9dcc9b6a6b`](https://github.com/nodejs/node/commit/9dcc9b6a6b)] - **(SEMVER-MINOR)** **process**: add --unhandled-rejections flag (Ruben Bridgewater) [#26599](https://github.com/nodejs/node/pull/26599)
* [[`ece507394a`](https://github.com/nodejs/node/commit/ece507394a)] - **(SEMVER-MINOR)** **src**: do not reuse async resource in http parsers (Daniel Beckert) [#25094](https://github.com/nodejs/node/pull/25094)
* [[`2755471bf3`](https://github.com/nodejs/node/commit/2755471bf3)] - **(SEMVER-MINOR)** **src**: print error before aborting (Ruben Bridgewater) [#26599](https://github.com/nodejs/node/pull/26599)
* [[`ca9c0c90c2`](https://github.com/nodejs/node/commit/ca9c0c90c2)] - **(SEMVER-MINOR)** **src**: add .code and SSL specific error properties (Sam Roberts) [#25093](https://github.com/nodejs/node/pull/25093)
* [[`8c69e06972`](https://github.com/nodejs/node/commit/8c69e06972)] - **(SEMVER-MINOR)** **tls**: return an OpenSSL error from renegotiate (Sam Roberts) [#26868](https://github.com/nodejs/node/pull/26868)
* [[`90e958aa4d`](https://github.com/nodejs/node/commit/90e958aa4d)] - **(SEMVER-MINOR)** **util**: only sort weak entries once (Ruben Bridgewater) [#27052](https://github.com/nodejs/node/pull/27052)
* [[`1940114ac3`](https://github.com/nodejs/node/commit/1940114ac3)] - **(SEMVER-MINOR)** **util**: highlight stack frames (Ruben Bridgewater) [#27052](https://github.com/nodejs/node/pull/27052)

### Semver-Patch Commits

* [[`75463a9004`](https://github.com/nodejs/node/commit/75463a9004)] - **assert**: fix rejects stack trace and operator (Ruben Bridgewater) [#27047](https://github.com/nodejs/node/pull/27047)
* [[`d3d4e10107`](https://github.com/nodejs/node/commit/d3d4e10107)] - **async_hooks**: improve AsyncResource performance (Anatoli Papirovski) [#27032](https://github.com/nodejs/node/pull/27032)
* [[`3973354951`](https://github.com/nodejs/node/commit/3973354951)] - **benchmark**: fix buffer-base64-decode.js (Rich Trott) [#27260](https://github.com/nodejs/node/pull/27260)
* [[`f98679f3b2`](https://github.com/nodejs/node/commit/f98679f3b2)] - **benchmark**: add benchmark for dns.promises.lookup() (Rich Trott) [#27249](https://github.com/nodejs/node/pull/27249)
* [[`29d0b43426`](https://github.com/nodejs/node/commit/29d0b43426)] - **benchmark**: fix http headers benchmark (Anatoli Papirovski) [#27021](https://github.com/nodejs/node/pull/27021)
* [[`77dee25efd`](https://github.com/nodejs/node/commit/77dee25efd)] - **benchmark**: remove deprecated argument (Rich Trott) [#27091](https://github.com/nodejs/node/pull/27091)
* [[`b08a867d60`](https://github.com/nodejs/node/commit/b08a867d60)] - **benchmark,doc,lib**: capitalize more comments (Ruben Bridgewater) [#26849](https://github.com/nodejs/node/pull/26849)
* [[`d834275a48`](https://github.com/nodejs/node/commit/d834275a48)] - **buffer**: fix custom inspection with extra properties (Ruben Bridgewater) [#27074](https://github.com/nodejs/node/pull/27074)
* [[`75eaf25e78`](https://github.com/nodejs/node/commit/75eaf25e78)] - **buffer**: use stricter `from()` input validation (Ruben Bridgewater) [#26825](https://github.com/nodejs/node/pull/26825)
* [[`5aaf666b3b`](https://github.com/nodejs/node/commit/5aaf666b3b)] - **build**: improve embedded code-cache detection (Refael Ackermann) [#27311](https://github.com/nodejs/node/pull/27311)
* [[`d17dfc7bb1`](https://github.com/nodejs/node/commit/d17dfc7bb1)] - **build**: remove redundant pyenv call in Travis build (Richard Lau) [#27247](https://github.com/nodejs/node/pull/27247)
* [[`14df42fd00`](https://github.com/nodejs/node/commit/14df42fd00)] - **build**: run `mkcodecache` as an action (Refael Ackermann) [#27161](https://github.com/nodejs/node/pull/27161)
* [[`b468a1dfc3`](https://github.com/nodejs/node/commit/b468a1dfc3)] - **build**: pin Python version in Travis (Richard Lau) [#27166](https://github.com/nodejs/node/pull/27166)
* [[`7b0d867389`](https://github.com/nodejs/node/commit/7b0d867389)] - **build**: fix test failures not failing Travis builds (Richard Lau) [#27176](https://github.com/nodejs/node/pull/27176)
* [[`56354d480d`](https://github.com/nodejs/node/commit/56354d480d)] - **build**: run flaky tests in Travis (Anna Henningsen) [#27158](https://github.com/nodejs/node/pull/27158)
* [[`72f4a830d7`](https://github.com/nodejs/node/commit/72f4a830d7)] - **build**: tidy up additional libraries on Windows (Richard Lau) [#27138](https://github.com/nodejs/node/pull/27138)
* [[`af03de48d8`](https://github.com/nodejs/node/commit/af03de48d8)] - **build**: don't use lint-ci on Travis (Richard Lau) [#27062](https://github.com/nodejs/node/pull/27062)
* [[`41ba699973`](https://github.com/nodejs/node/commit/41ba699973)] - **build**: update configure for Node.js 12 (Richard Lau) [#26719](https://github.com/nodejs/node/pull/26719)
* [[`20a917c571`](https://github.com/nodejs/node/commit/20a917c571)] - **build**: move optimizing link directives to node.exe target (Refael Ackermann) [#25931](https://github.com/nodejs/node/pull/25931)
* [[`4698757610`](https://github.com/nodejs/node/commit/4698757610)] - **build,deps**: remove cygwin configuration which is not supported (Refael Ackermann) [#25931](https://github.com/nodejs/node/pull/25931)
* [[`cd5c7bf240`](https://github.com/nodejs/node/commit/cd5c7bf240)] - **build,deps**: use PCH also for v8\_initializers (Refael Ackermann) [#25931](https://github.com/nodejs/node/pull/25931)
* [[`6608cf286d`](https://github.com/nodejs/node/commit/6608cf286d)] - **build,deps,v8**: tie up loose ends (Refael Ackermann) [#26666](https://github.com/nodejs/node/pull/26666)
* [[`6ac80f0e2b`](https://github.com/nodejs/node/commit/6ac80f0e2b)] - **build,src**: add PCH to node.gypi (Refael Ackermann) [#25931](https://github.com/nodejs/node/pull/25931)
* [[`f216d5bbb1`](https://github.com/nodejs/node/commit/f216d5bbb1)] - **build,test**: fail `coverage` target if tests fail (Refael Ackermann) [#25432](https://github.com/nodejs/node/pull/25432)
* [[`82b798907d`](https://github.com/nodejs/node/commit/82b798907d)] - **build,tools**: add more headers to V8 PCH file (Refael Ackermann) [#25931](https://github.com/nodejs/node/pull/25931)
* [[`d66c7e3470`](https://github.com/nodejs/node/commit/d66c7e3470)] - **build,win**: deprecate `vcbuild test-ci` (Refael Ackermann) [#27231](https://github.com/nodejs/node/pull/27231)
* [[`0fc27f6bc0`](https://github.com/nodejs/node/commit/0fc27f6bc0)] - **build,win**: bail vcbuild if mklink fails (Refael Ackermann) [#27216](https://github.com/nodejs/node/pull/27216)
* [[`88beaf01f1`](https://github.com/nodejs/node/commit/88beaf01f1)] - **build,win**: rename node.lib to libnode.lib (Refael Ackermann) [#27150](https://github.com/nodejs/node/pull/27150)
* [[`25df3c10f4`](https://github.com/nodejs/node/commit/25df3c10f4)] - **build,win**: put all compilation artifacts into `out` (Refael Ackermann) [#27149](https://github.com/nodejs/node/pull/27149)
* [[`06c10cdc4c`](https://github.com/nodejs/node/commit/06c10cdc4c)] - **build,win**: teach GYP MSVS generator about MARMASM (Jon Kunkee) [#26020](https://github.com/nodejs/node/pull/26020)
* [[`2ffd20bb91`](https://github.com/nodejs/node/commit/2ffd20bb91)] - **build,win**: emit MSBuild summary (Refael Ackermann) [#25931](https://github.com/nodejs/node/pull/25931)
* [[`ff4adab78c`](https://github.com/nodejs/node/commit/ff4adab78c)] - **build,win**: always build with PCH (Refael Ackermann) [#25931](https://github.com/nodejs/node/pull/25931)
* [[`28e2c3771d`](https://github.com/nodejs/node/commit/28e2c3771d)] - **child_process**: rename \_validateStdtio to getValidStdio (Ruben Bridgewater) [#26809](https://github.com/nodejs/node/pull/26809)
* [[`091902ae00`](https://github.com/nodejs/node/commit/091902ae00)] - **console**: remove trace frame (Ruben Bridgewater) [#27159](https://github.com/nodejs/node/pull/27159)
* [[`a8eac78f8d`](https://github.com/nodejs/node/commit/a8eac78f8d)] - ***Revert*** "**console**: use consolePropAttributes for k-bind properties in constructor" (Daniel Bevenius) [#26943](https://github.com/nodejs/node/pull/26943)
* [[`ed5e69d7e6`](https://github.com/nodejs/node/commit/ed5e69d7e6)] - **console**: use consolePropAttributes for k-bind properties in constructor (Beni von Cheni) [#26850](https://github.com/nodejs/node/pull/26850)
* [[`69140bc7f8`](https://github.com/nodejs/node/commit/69140bc7f8)] - **crypto**: do not abort when setting throws (Sam Roberts) [#27157](https://github.com/nodejs/node/pull/27157)
* [[`0911e88056`](https://github.com/nodejs/node/commit/0911e88056)] - **crypto**: fix rsa key gen with non-default exponent (Sam Roberts) [#27092](https://github.com/nodejs/node/pull/27092)
* [[`fadcb2d850`](https://github.com/nodejs/node/commit/fadcb2d850)] - **crypto**: simplify missing passphrase detection (Tobias Nießen) [#27089](https://github.com/nodejs/node/pull/27089)
* [[`73bca57988`](https://github.com/nodejs/node/commit/73bca57988)] - **crypto**: fail early if passphrase is too long (Tobias Nießen) [#27010](https://github.com/nodejs/node/pull/27010)
* [[`05bd6071a6`](https://github.com/nodejs/node/commit/05bd6071a6)] - **crypto**: use EVP\_PKEY\_X448 in GetEphemeralKeyInfo (cjihrig) [#26988](https://github.com/nodejs/node/pull/26988)
* [[`6ac692a3db`](https://github.com/nodejs/node/commit/6ac692a3db)] - **crypto**: use EVP\_PKEY\_X25519 in GetEphemeralKeyInfo (cjihrig) [#26988](https://github.com/nodejs/node/pull/26988)
* [[`7c1fc93e30`](https://github.com/nodejs/node/commit/7c1fc93e30)] - **crypto**: don't crash on unknown asymmetricKeyType (Filip Skokan) [#26786](https://github.com/nodejs/node/pull/26786)
* [[`df1c9eb975`](https://github.com/nodejs/node/commit/df1c9eb975)] - **crypto**: rename generateKeyPairEdDSA (Tobias Nießen) [#26900](https://github.com/nodejs/node/pull/26900)
* [[`751c92d972`](https://github.com/nodejs/node/commit/751c92d972)] - **crypto**: remove obsolete encoding check (Ruben Bridgewater) [#26809](https://github.com/nodejs/node/pull/26809)
* [[`6f77af541e`](https://github.com/nodejs/node/commit/6f77af541e)] - ***Revert*** "**crypto**: add KeyObject.asymmetricKeySize" (Tobias Nießen) [#26636](https://github.com/nodejs/node/pull/26636)
* [[`247c14c040`](https://github.com/nodejs/node/commit/247c14c040)] - **crypto**: fix EdDSA support for KeyObject (Brian White) [#26319](https://github.com/nodejs/node/pull/26319)
* [[`90cf2d5f00`](https://github.com/nodejs/node/commit/90cf2d5f00)] - **deps**: use nghttp2's config.h on all platforms (Sam Roberts) [#27283](https://github.com/nodejs/node/pull/27283)
* [[`aec2ce4ee1`](https://github.com/nodejs/node/commit/aec2ce4ee1)] - **deps**: upgrade to libuv 1.28.0 (cjihrig) [#27241](https://github.com/nodejs/node/pull/27241)
* [[`7f29117de3`](https://github.com/nodejs/node/commit/7f29117de3)] - **deps**: patch V8 to 7.4.288.21 (Matheus Marchini) [#27265](https://github.com/nodejs/node/pull/27265)
* [[`033f6b566e`](https://github.com/nodejs/node/commit/033f6b566e)] - **deps**: upgrade npm to 6.9.0 (Kat Marchán) [#26244](https://github.com/nodejs/node/pull/26244)
* [[`135b79a31d`](https://github.com/nodejs/node/commit/135b79a31d)] - **deps**: patch V8 to 7.4.288.18 (Michaël Zasso) [#27066](https://github.com/nodejs/node/pull/27066)
* [[`c1d61f2b4b`](https://github.com/nodejs/node/commit/c1d61f2b4b)] - **deps**: patch V8 to 7.4.288.17 (Michaël Zasso) [#27066](https://github.com/nodejs/node/pull/27066)
* [[`5b8434eebc`](https://github.com/nodejs/node/commit/5b8434eebc)] - **deps**: V8: cherry-pick 0188634 (Michaël Zasso) [#27013](https://github.com/nodejs/node/pull/27013)
* [[`8cc181c8ee`](https://github.com/nodejs/node/commit/8cc181c8ee)] - **deps**: V8: cherry-pick c8785d1 (Michaël Zasso) [#27013](https://github.com/nodejs/node/pull/27013)
* [[`2ea9de2e85`](https://github.com/nodejs/node/commit/2ea9de2e85)] - **deps**: V8: cherry-pick f4b860d (Michaël Zasso) [#27013](https://github.com/nodejs/node/pull/27013)
* [[`ddbb7d7777`](https://github.com/nodejs/node/commit/ddbb7d7777)] - **deps**: cherry-pick 56f6a76 from upstream V8 (Ruben Bridgewater) [#25269](https://github.com/nodejs/node/pull/25269)
* [[`59fa7f1257`](https://github.com/nodejs/node/commit/59fa7f1257)] - **deps**: cherry-pick 26b145a from upstream V8 (Sam Roberts) [#25148](https://github.com/nodejs/node/pull/25148)
* [[`a9812142ca`](https://github.com/nodejs/node/commit/a9812142ca)] - **deps**: patch V8 to 7.1.302.33 (Ruben Bridgewater) [#25101](https://github.com/nodejs/node/pull/25101)
* [[`f0e460968e`](https://github.com/nodejs/node/commit/f0e460968e)] - **deps**: remove test-related GYP files (Michaël Zasso) [#25097](https://github.com/nodejs/node/pull/25097)
* [[`323a365766`](https://github.com/nodejs/node/commit/323a365766)] - **deps**: float 26d7fce1 from openssl (Rod Vagg) [#24353](https://github.com/nodejs/node/pull/24353)
* [[`d8fb81fab3`](https://github.com/nodejs/node/commit/d8fb81fab3)] - **deps**: float 99540ec from openssl (CVE-2018-0735) (Rod Vagg) [#23950](https://github.com/nodejs/node/pull/23950)
* [[`213c7d2d64`](https://github.com/nodejs/node/commit/213c7d2d64)] - **deps**: float a9cfb8c2 from openssl (CVE-2018-0734) (Rod Vagg) [#23965](https://github.com/nodejs/node/pull/23965)
* [[`e2260e901d`](https://github.com/nodejs/node/commit/e2260e901d)] - **deps**: float 415c3356 from openssl (DSA vulnerability) (Rod Vagg) [#23965](https://github.com/nodejs/node/pull/23965)
* [[`e356807a79`](https://github.com/nodejs/node/commit/e356807a79)] - **deps,test**: bump googletest to 39f72ea6f5 (Refael Ackermann) [#27231](https://github.com/nodejs/node/pull/27231)
* [[`8e308e8b28`](https://github.com/nodejs/node/commit/8e308e8b28)] - **deps,v8**: cherry-pick 385aa80 (Refael Ackermann) [#26702](https://github.com/nodejs/node/pull/26702)
* [[`d1b7193428`](https://github.com/nodejs/node/commit/d1b7193428)] - **deps,v8**: silence V8 self-deprecation warnings (Refael Ackermann) [#25394](https://github.com/nodejs/node/pull/25394)
* [[`9e960175d1`](https://github.com/nodejs/node/commit/9e960175d1)] - **dgram**: add support for UDP connected sockets (Santiago Gimeno) [#26871](https://github.com/nodejs/node/pull/26871)
* [[`09cdc37824`](https://github.com/nodejs/node/commit/09cdc37824)] - **dns**: do not indicate invalid IPs are IPv6 (Rich Trott) [#27081](https://github.com/nodejs/node/pull/27081)
* [[`bc2d258a3e`](https://github.com/nodejs/node/commit/bc2d258a3e)] - **dns**: refactor internal/dns/promises.js (Rich Trott) [#27081](https://github.com/nodejs/node/pull/27081)
* [[`72308a5deb`](https://github.com/nodejs/node/commit/72308a5deb)] - **doc**: simplify nomination process text (Rich Trott) [#27317](https://github.com/nodejs/node/pull/27317)
* [[`290faec0e7`](https://github.com/nodejs/node/commit/290faec0e7)] - **doc**: fix extname with the correct description (himself65) [#27303](https://github.com/nodejs/node/pull/27303)
* [[`d4dae5e1ca`](https://github.com/nodejs/node/commit/d4dae5e1ca)] - **doc**: simplify bullet points in GOVERNANCE.md (Rich Trott) [#27284](https://github.com/nodejs/node/pull/27284)
* [[`ba74e42000`](https://github.com/nodejs/node/commit/ba74e42000)] - **doc**: revise Collaborator Nominations introduction (Rich Trott) [#27237](https://github.com/nodejs/node/pull/27237)
* [[`c61c722c8c`](https://github.com/nodejs/node/commit/c61c722c8c)] - **doc**: add ABI version registry (Rod Vagg) [#24114](https://github.com/nodejs/node/pull/24114)
* [[`7938238b31`](https://github.com/nodejs/node/commit/7938238b31)] - **doc**: add internal documentation (Aymen Naghmouchi) [#26665](https://github.com/nodejs/node/pull/26665)
* [[`82e6c3378f`](https://github.com/nodejs/node/commit/82e6c3378f)] - **doc**: revise TSC Meetings material in GOVERNANCE.md (Rich Trott) [#27204](https://github.com/nodejs/node/pull/27204)
* [[`d5f9cf81e3`](https://github.com/nodejs/node/commit/d5f9cf81e3)] - **doc**: fix some links (Vse Mozhet Byt) [#27141](https://github.com/nodejs/node/pull/27141)
* [[`7b854959e7`](https://github.com/nodejs/node/commit/7b854959e7)] - **doc**: revise TSC text in GOVERNANCE.md (Rich Trott) [#27169](https://github.com/nodejs/node/pull/27169)
* [[`9b859f50d5`](https://github.com/nodejs/node/commit/9b859f50d5)] - **doc**: add missing n-api version indicator (Michael Dawson) [#27155](https://github.com/nodejs/node/pull/27155)
* [[`41d5666aaa`](https://github.com/nodejs/node/commit/41d5666aaa)] - **doc**: consolidate Collaborator status in GOVERNANCE (Rich Trott) [#27128](https://github.com/nodejs/node/pull/27128)
* [[`1656cd2edb`](https://github.com/nodejs/node/commit/1656cd2edb)] - **doc**: remove outdated link (cjihrig) [#27126](https://github.com/nodejs/node/pull/27126)
* [[`643a2fa447`](https://github.com/nodejs/node/commit/643a2fa447)] - **doc**: specify return type for tty.isatty() (Mykola Bilochub) [#27154](https://github.com/nodejs/node/pull/27154)
* [[`557bd861aa`](https://github.com/nodejs/node/commit/557bd861aa)] - **doc**: revise Collaborator material in GOVERNANCE.md (Rich Trott) [#27103](https://github.com/nodejs/node/pull/27103)
* [[`1afec97130`](https://github.com/nodejs/node/commit/1afec97130)] - **doc**: link bigint type to MDN instead of proposal (Vse Mozhet Byt) [#27101](https://github.com/nodejs/node/pull/27101)
* [[`21b739fb69`](https://github.com/nodejs/node/commit/21b739fb69)] - **doc**: add missing step to npm release process (Myles Borins) [#27105](https://github.com/nodejs/node/pull/27105)
* [[`181052d7c2`](https://github.com/nodejs/node/commit/181052d7c2)] - **doc**: revise Collaborator description in GOVERNANCE.md (Rich Trott) [#27071](https://github.com/nodejs/node/pull/27071)
* [[`10eaf6a09f`](https://github.com/nodejs/node/commit/10eaf6a09f)] - **doc**: fix section sorting, add link reference (Vse Mozhet Byt) [#27075](https://github.com/nodejs/node/pull/27075)
* [[`d989e20717`](https://github.com/nodejs/node/commit/d989e20717)] - **doc**: describe tls.DEFAULT\_MIN\_VERSION/\_MAX\_VERSION (Sam Roberts) [#26821](https://github.com/nodejs/node/pull/26821)
* [[`0622ce6e7f`](https://github.com/nodejs/node/commit/0622ce6e7f)] - **doc**: fix changelog date typo (Jesse McCarthy) [#26831](https://github.com/nodejs/node/pull/26831)
* [[`cd9898a52a`](https://github.com/nodejs/node/commit/cd9898a52a)] - **doc**: add missing pr-url (cjihrig) [#26753](https://github.com/nodejs/node/pull/26753)
* [[`06879aafee`](https://github.com/nodejs/node/commit/06879aafee)] - **doc**: fix year in changelog (Colin Prince) [#26584](https://github.com/nodejs/node/pull/26584)
* [[`7e0ddf66b9`](https://github.com/nodejs/node/commit/7e0ddf66b9)] - **doc**: fix deprecation "End-of-Life" capitalization (Tobias Nießen) [#26251](https://github.com/nodejs/node/pull/26251)
* [[`3d4db3a7bf`](https://github.com/nodejs/node/commit/3d4db3a7bf)] - **doc**: fix metadata of DEP0114 (Tobias Nießen) [#26250](https://github.com/nodejs/node/pull/26250)
* [[`ccf37b3a84`](https://github.com/nodejs/node/commit/ccf37b3a84)] - **doc**: fix deprecations metadata (Richard Lau) [#25434](https://github.com/nodejs/node/pull/25434)
* [[`3614157b78`](https://github.com/nodejs/node/commit/3614157b78)] - **doc**: fix lint in CHANGELOG\_V6 (Myles Borins) [#25233](https://github.com/nodejs/node/pull/25233)
* [[`928f776385`](https://github.com/nodejs/node/commit/928f776385)] - **doc**: add missing pr-url (cjihrig) [#25091](https://github.com/nodejs/node/pull/25091)
* [[`43273262e5`](https://github.com/nodejs/node/commit/43273262e5)] - **doc**: describe secureProtocol and CLI interaction (Sam Roberts) [#24386](https://github.com/nodejs/node/pull/24386)
* [[`34eccb2a1b`](https://github.com/nodejs/node/commit/34eccb2a1b)] - **doc**: fix missing PR id of 23329 (Ouyang Yadong) [#24458](https://github.com/nodejs/node/pull/24458)
* [[`db2ac1dbd9`](https://github.com/nodejs/node/commit/db2ac1dbd9)] - **doc**: fix headings for CHANGELOG\_v10.md (Myles Borins) [#23973](https://github.com/nodejs/node/pull/23973)
* [[`c99026bdd7`](https://github.com/nodejs/node/commit/c99026bdd7)] - **doc**: update missing deprecation (cjihrig) [#23883](https://github.com/nodejs/node/pull/23883)
* [[`4afd503465`](https://github.com/nodejs/node/commit/4afd503465)] - **doc,test,repl**: fix deprecation code (cjihrig) [#26368](https://github.com/nodejs/node/pull/26368)
* [[`3b044962c4`](https://github.com/nodejs/node/commit/3b044962c4)] - **errors**: add more information in case of invalid callbacks (Ruben Bridgewater) [#27048](https://github.com/nodejs/node/pull/27048)
* [[`96e46d37c4`](https://github.com/nodejs/node/commit/96e46d37c4)] - **esm**: replace --entry-type with --input-type (Geoffrey Booth) [#27184](https://github.com/nodejs/node/pull/27184)
* [[`5e98f875b9`](https://github.com/nodejs/node/commit/5e98f875b9)] - **esm**: fix typos (Geoffrey Booth) [#27067](https://github.com/nodejs/node/pull/27067)
* [[`7a547098d5`](https://github.com/nodejs/node/commit/7a547098d5)] - **esm**: use primordials (Myles Borins) [#26954](https://github.com/nodejs/node/pull/26954)
* [[`2400cbcf7c`](https://github.com/nodejs/node/commit/2400cbcf7c)] - **fs**: fix infinite loop with async recursive mkdir on Windows (Richard Lau) [#27207](https://github.com/nodejs/node/pull/27207)
* [[`b925379f50`](https://github.com/nodejs/node/commit/b925379f50)] - **fs**: warn on non-portable mkdtemp() templates (cjihrig) [#26980](https://github.com/nodejs/node/pull/26980)
* [[`eb2d4161f5`](https://github.com/nodejs/node/commit/eb2d4161f5)] - **fs**: improve readFile performance (Ruben Bridgewater) [#27063](https://github.com/nodejs/node/pull/27063)
* [[`92db780d9e`](https://github.com/nodejs/node/commit/92db780d9e)] - **http2**: rename function for clarity (Ruben Bridgewater) [#26809](https://github.com/nodejs/node/pull/26809)
* [[`ce265908eb`](https://github.com/nodejs/node/commit/ce265908eb)] - **http2**: remove side effects from validateSettings (Ruben Bridgewater) [#26809](https://github.com/nodejs/node/pull/26809)
* [[`cd3a9eebca`](https://github.com/nodejs/node/commit/cd3a9eebca)] - **https**: remove usage of public require('util') (dnlup) [#26772](https://github.com/nodejs/node/pull/26772)
* [[`49d3d11ba7`](https://github.com/nodejs/node/commit/49d3d11ba7)] - **inspector**: split --cpu-prof-path to --cpu-prof-dir and --cpu-prof-name (Joyee Cheung) [#27306](https://github.com/nodejs/node/pull/27306)
* [[`94adfe9831`](https://github.com/nodejs/node/commit/94adfe9831)] - **lib**: replace --diagnostic-report-\* with --report-\* (Joyee Cheung) [#27312](https://github.com/nodejs/node/pull/27312)
* [[`49ee010005`](https://github.com/nodejs/node/commit/49ee010005)] - **lib**: use getOptionValue instead of process underscore aliases (Joyee Cheung) [#27278](https://github.com/nodejs/node/pull/27278)
* [[`a38e9c438a`](https://github.com/nodejs/node/commit/a38e9c438a)] - **lib**: require globals instead of using the global proxy (Joyee Cheung) [#27112](https://github.com/nodejs/node/pull/27112)
* [[`914d6c9ab8`](https://github.com/nodejs/node/commit/914d6c9ab8)] - **lib**: use primordials in domexception.js (Joyee Cheung) [#27171](https://github.com/nodejs/node/pull/27171)
* [[`3da36d0e94`](https://github.com/nodejs/node/commit/3da36d0e94)] - **lib**: create primordials in every context (Joyee Cheung) [#27171](https://github.com/nodejs/node/pull/27171)
* [[`908292cf1f`](https://github.com/nodejs/node/commit/908292cf1f)] - **lib**: enforce the use of Object from primordials (Michaël Zasso) [#27146](https://github.com/nodejs/node/pull/27146)
* [[`47f5cc1ad1`](https://github.com/nodejs/node/commit/47f5cc1ad1)] - **lib**: faster FreeList (Anatoli Papirovski) [#27021](https://github.com/nodejs/node/pull/27021)
* [[`5b9e57012a`](https://github.com/nodejs/node/commit/5b9e57012a)] - **lib**: add signal name validator (cjihrig) [#27137](https://github.com/nodejs/node/pull/27137)
* [[`112cc7c275`](https://github.com/nodejs/node/commit/112cc7c275)] - **lib**: use safe methods from primordials (Michaël Zasso) [#27096](https://github.com/nodejs/node/pull/27096)
* [[`5a8c55f078`](https://github.com/nodejs/node/commit/5a8c55f078)] - **lib**: fix outdated comment (Vse Mozhet Byt) [#27122](https://github.com/nodejs/node/pull/27122)
* [[`de23055536`](https://github.com/nodejs/node/commit/de23055536)] - **lib**: remove `env: node` in eslint config for lib files (Joyee Cheung) [#27082](https://github.com/nodejs/node/pull/27082)
* [[`2c49e8b537`](https://github.com/nodejs/node/commit/2c49e8b537)] - **lib**: make queueMicrotask faster (Anatoli Papirovski) [#27032](https://github.com/nodejs/node/pull/27032)
* [[`0817840f77`](https://github.com/nodejs/node/commit/0817840f77)] - **lib**: force using primordials for JSON, Math and Reflect (Michaël Zasso) [#27027](https://github.com/nodejs/node/pull/27027)
* [[`7bddfcc61a`](https://github.com/nodejs/node/commit/7bddfcc61a)] - **lib**: consolidate arrayBufferView validation (Ruben Bridgewater) [#26809](https://github.com/nodejs/node/pull/26809)
* [[`6c913fb028`](https://github.com/nodejs/node/commit/6c913fb028)] - **lib**: remove return values from validation functions (Ruben Bridgewater) [#26809](https://github.com/nodejs/node/pull/26809)
* [[`50a3fe20ea`](https://github.com/nodejs/node/commit/50a3fe20ea)] - **lib**: rename validateMode to parseMode (Ruben Bridgewater) [#26809](https://github.com/nodejs/node/pull/26809)
* [[`76e67e9884`](https://github.com/nodejs/node/commit/76e67e9884)] - **lib**: assign missed deprecation code (Anna Henningsen) [#26492](https://github.com/nodejs/node/pull/26492)
* [[`f3b5cc0807`](https://github.com/nodejs/node/commit/f3b5cc0807)] - **meta**: travis: run compilation jobs first (Refael Ackermann) [#27205](https://github.com/nodejs/node/pull/27205)
* [[`7c816b7588`](https://github.com/nodejs/node/commit/7c816b7588)] - **module**: explicitly initialize CJS loader (Joyee Cheung) [#27313](https://github.com/nodejs/node/pull/27313)
* [[`d6317d0a45`](https://github.com/nodejs/node/commit/d6317d0a45)] - **module**: remove usage of require('util') (dnlup) [#26803](https://github.com/nodejs/node/pull/26803)
* [[`ff89670902`](https://github.com/nodejs/node/commit/ff89670902)] - **n-api**: reduce gc finalization stress (Michael Dawson) [#27085](https://github.com/nodejs/node/pull/27085)
* [[`655c90b287`](https://github.com/nodejs/node/commit/655c90b287)] - **net**: inline maybeDestroy() (Luigi Pinca) [#27136](https://github.com/nodejs/node/pull/27136)
* [[`f0b3855a90`](https://github.com/nodejs/node/commit/f0b3855a90)] - **net**: remove usage of require('util') (dnlup) [#26920](https://github.com/nodejs/node/pull/26920)
* [[`9946c59707`](https://github.com/nodejs/node/commit/9946c59707)] - **path**: simplify normalizeString (Ruben Bridgewater) [#27240](https://github.com/nodejs/node/pull/27240)
* [[`9dba96dc1a`](https://github.com/nodejs/node/commit/9dba96dc1a)] - **process**: patch more process properties during pre-execution (Joyee Cheung) [#26945](https://github.com/nodejs/node/pull/26945)
* [[`d4eda4d876`](https://github.com/nodejs/node/commit/d4eda4d876)] - **process**: remove protection for SyncWriteStream destroy in stdio (Matteo Collina) [#26902](https://github.com/nodejs/node/pull/26902)
* [[`2701f5538f`](https://github.com/nodejs/node/commit/2701f5538f)] - **readline**: remove usage of require('util') (dnlup) [#26818](https://github.com/nodejs/node/pull/26818)
* [[`415a825dc0`](https://github.com/nodejs/node/commit/415a825dc0)] - **repl**: remove usage of require('util') in `repl.js` (dnlup) [#26820](https://github.com/nodejs/node/pull/26820)
* [[`af35d4044f`](https://github.com/nodejs/node/commit/af35d4044f)] - **report**: use uv\_gettimeofday for dumpEventTimeStamp (cjihrig) [#27029](https://github.com/nodejs/node/pull/27029)
* [[`44a3acb627`](https://github.com/nodejs/node/commit/44a3acb627)] - **report**: improve signal name validation (cjihrig) [#27137](https://github.com/nodejs/node/pull/27137)
* [[`e3032708e0`](https://github.com/nodejs/node/commit/e3032708e0)] - **report**: add support for UDP connected sockets (Richard Lau) [#27072](https://github.com/nodejs/node/pull/27072)
* [[`8e1e9946a9`](https://github.com/nodejs/node/commit/8e1e9946a9)] - **src**: use uv\_gettimeofday() to get microseconds (cjihrig) [#27029](https://github.com/nodejs/node/pull/27029)
* [[`8eaf31181a`](https://github.com/nodejs/node/commit/8eaf31181a)] - **src**: apply modernize-use-nullptr in node\_win32\_etw\_provider.cc (gengjiawen) [#27263](https://github.com/nodejs/node/pull/27263)
* [[`19e3e02a2d`](https://github.com/nodejs/node/commit/19e3e02a2d)] - **src**: move SIGINT watchdog utils to the contextify binding (Joyee Cheung) [#27290](https://github.com/nodejs/node/pull/27290)
* [[`5356b4a675`](https://github.com/nodejs/node/commit/5356b4a675)] - **src**: split per-process initialization and teardown routines (Joyee Cheung) [#27276](https://github.com/nodejs/node/pull/27276)
* [[`8d901bb44e`](https://github.com/nodejs/node/commit/8d901bb44e)] - **src**: move guessHandleType in the util binding (Joyee Cheung) [#27289](https://github.com/nodejs/node/pull/27289)
* [[`758191033f`](https://github.com/nodejs/node/commit/758191033f)] - **src**: fix performance-faster-string-find in node\_report.cc (gengjiawen) [#27262](https://github.com/nodejs/node/pull/27262)
* [[`dc8b57fdc1`](https://github.com/nodejs/node/commit/dc8b57fdc1)] - **src**: use ArrayBufferAllocator::Create in node\_worker.cc (Anna Henningsen) [#27251](https://github.com/nodejs/node/pull/27251)
* [[`f9da3f0cce`](https://github.com/nodejs/node/commit/f9da3f0cce)] - **src**: enable non-nestable V8 platform tasks (Anna Henningsen) [#27252](https://github.com/nodejs/node/pull/27252)
* [[`3ef1512f9e`](https://github.com/nodejs/node/commit/3ef1512f9e)] - **src**: allows escaping NODE\_OPTIONS with backslashes (Maël Nison) [#24065](https://github.com/nodejs/node/pull/24065)
* [[`cdba9f23ec`](https://github.com/nodejs/node/commit/cdba9f23ec)] - **src**: handle fatal error when Environment is not assigned to context (Joyee Cheung) [#27236](https://github.com/nodejs/node/pull/27236)
* [[`83d1ca7de9`](https://github.com/nodejs/node/commit/83d1ca7de9)] - **src**: disallow calling env-dependent methods during bootstrap (Joyee Cheung) [#27234](https://github.com/nodejs/node/pull/27234)
* [[`cab1dc5bb3`](https://github.com/nodejs/node/commit/cab1dc5bb3)] - **src**: use RAII to manage the main isolate data (Joyee Cheung) [#27220](https://github.com/nodejs/node/pull/27220)
* [[`1e7823dd4e`](https://github.com/nodejs/node/commit/1e7823dd4e)] - **src**: remove redundant call in node\_options-inl.h (gengjiawen) [#26959](https://github.com/nodejs/node/pull/26959)
* [[`73471236d8`](https://github.com/nodejs/node/commit/73471236d8)] - **src**: remove unimplemented method in TracingAgent (gengjiawen) [#26959](https://github.com/nodejs/node/pull/26959)
* [[`427fce711f`](https://github.com/nodejs/node/commit/427fce711f)] - **src**: fix check for accepting Buffers into Node’s allocator (Anna Henningsen) [#27174](https://github.com/nodejs/node/pull/27174)
* [[`dfd7e99425`](https://github.com/nodejs/node/commit/dfd7e99425)] - **src**: make a Environment-independent proxy class for NativeModuleLoader (Joyee Cheung) [#27160](https://github.com/nodejs/node/pull/27160)
* [[`060d901f87`](https://github.com/nodejs/node/commit/060d901f87)] - **src**: replace FromJust() with Check() when possible (Sam Roberts) [#27162](https://github.com/nodejs/node/pull/27162)
* [[`ee7daf76c0`](https://github.com/nodejs/node/commit/ee7daf76c0)] - **src**: remove redundant string initialization (gengjiawen) [#27152](https://github.com/nodejs/node/pull/27152)
* [[`845a6214f8`](https://github.com/nodejs/node/commit/845a6214f8)] - **src**: use macro instead of magic number for fd (gengjiawen) [#27152](https://github.com/nodejs/node/pull/27152)
* [[`547576f530`](https://github.com/nodejs/node/commit/547576f530)] - **src**: always use diagnostic file sequence number (cjihrig) [#27142](https://github.com/nodejs/node/pull/27142)
* [[`c1e03eda07`](https://github.com/nodejs/node/commit/c1e03eda07)] - **src**: use SealHandleScope for inspector tasks (Anna Henningsen) [#27116](https://github.com/nodejs/node/pull/27116)
* [[`a3f30a48c2`](https://github.com/nodejs/node/commit/a3f30a48c2)] - **src**: unify crypto constant setup (Sam Roberts) [#27077](https://github.com/nodejs/node/pull/27077)
* [[`97c0a34935`](https://github.com/nodejs/node/commit/97c0a34935)] - **src**: don't point to out of scope variable (cjihrig) [#27070](https://github.com/nodejs/node/pull/27070)
* [[`864860e9f3`](https://github.com/nodejs/node/commit/864860e9f3)] - **src**: port coverage serialization to C++ (Joyee Cheung) [#26874](https://github.com/nodejs/node/pull/26874)
* [[`d0e2650d03`](https://github.com/nodejs/node/commit/d0e2650d03)] - **src**: add NOLINT to js\_native\_.\* (gengjiawen) [#26884](https://github.com/nodejs/node/pull/26884)
* [[`eb2dccb17a`](https://github.com/nodejs/node/commit/eb2dccb17a)] - **src**: move AsyncResource impl out of public header (Ben Noordhuis) [#26348](https://github.com/nodejs/node/pull/26348)
* [[`e1d55a0cbc`](https://github.com/nodejs/node/commit/e1d55a0cbc)] - **src**: port bootstrap/cache.js to C++ (Joyee Cheung) [#27046](https://github.com/nodejs/node/pull/27046)
* [[`f59ec2abee`](https://github.com/nodejs/node/commit/f59ec2abee)] - **src**: implement MemoryRetainer in Environment (Joyee Cheung) [#27018](https://github.com/nodejs/node/pull/27018)
* [[`1087805eeb`](https://github.com/nodejs/node/commit/1087805eeb)] - **src**: check return value, silence coverity warning (Ben Noordhuis) [#26997](https://github.com/nodejs/node/pull/26997)
* [[`bb98f27181`](https://github.com/nodejs/node/commit/bb98f27181)] - **src**: check uv\_fs\_close() return value (cjihrig) [#26967](https://github.com/nodejs/node/pull/26967)
* [[`8bc7d2a5be`](https://github.com/nodejs/node/commit/8bc7d2a5be)] - **src**: fix data type when using uv\_get\_total\_memory() (gengjiawen) [#26886](https://github.com/nodejs/node/pull/26886)
* [[`c0f031c5bd`](https://github.com/nodejs/node/commit/c0f031c5bd)] - **src**: remove unused variable (cjihrig) [#26879](https://github.com/nodejs/node/pull/26879)
* [[`1935625df4`](https://github.com/nodejs/node/commit/1935625df4)] - **src**: disallow constructor behaviour for native methods (Anna Henningsen) [#26700](https://github.com/nodejs/node/pull/26700)
* [[`f091d4e840`](https://github.com/nodejs/node/commit/f091d4e840)] - **src**: apply clang-tidy rule modernize-use-emplace (gengjiawen) [#26564](https://github.com/nodejs/node/pull/26564)
* [[`f47adfbda5`](https://github.com/nodejs/node/commit/f47adfbda5)] - **src**: fix DTrace GC callbacks DCHECKs and add cleanup (Joyee Cheung) [#26742](https://github.com/nodejs/node/pull/26742)
* [[`0752a18b88`](https://github.com/nodejs/node/commit/0752a18b88)] - **src**: fix warning in node\_messaging (ZYSzys) [#26682](https://github.com/nodejs/node/pull/26682)
* [[`b200a46bef`](https://github.com/nodejs/node/commit/b200a46bef)] - **src**: remove `process.binding('config').debugOptions` (Joyee Cheung) [#25999](https://github.com/nodejs/node/pull/25999)
* [[`c2d374fccc`](https://github.com/nodejs/node/commit/c2d374fccc)] - **src**: remove unused method in env.h (gengjiawen) [#25934](https://github.com/nodejs/node/pull/25934)
* [[`55569759b3`](https://github.com/nodejs/node/commit/55569759b3)] - **src**: pass along errors from PromiseWrap instantiation (Anna Henningsen) [#25734](https://github.com/nodejs/node/pull/25734)
* [[`24e6b709ea`](https://github.com/nodejs/node/commit/24e6b709ea)] - **src**: use isolate version of BooleanValue() (cjihrig) [#24883](https://github.com/nodejs/node/pull/24883)
* [[`b0089a580f`](https://github.com/nodejs/node/commit/b0089a580f)] - **src**: make model counter in `GetCPUInfo()` unsigned (Anna Henningsen) [#23880](https://github.com/nodejs/node/pull/23880)
* [[`53e0f632db`](https://github.com/nodejs/node/commit/53e0f632db)] - **stream**: inline onwriteStateUpdate() (Luigi Pinca) [#27203](https://github.com/nodejs/node/pull/27203)
* [[`1a67c9948c`](https://github.com/nodejs/node/commit/1a67c9948c)] - **stream**: remove dead code (Marcos Casagrande) [#27125](https://github.com/nodejs/node/pull/27125)
* [[`a3d1922958`](https://github.com/nodejs/node/commit/a3d1922958)] - **test**: unskip copyfile permission test (cjihrig) [#27241](https://github.com/nodejs/node/pull/27241)
* [[`b368571fba`](https://github.com/nodejs/node/commit/b368571fba)] - **test**: move known issue test to parallel (cjihrig) [#27241](https://github.com/nodejs/node/pull/27241)
* [[`528d100394`](https://github.com/nodejs/node/commit/528d100394)] - **test**: mark some known flakes (Refael Ackermann) [#27225](https://github.com/nodejs/node/pull/27225)
* [[`e37eee2b1e`](https://github.com/nodejs/node/commit/e37eee2b1e)] - **test**: remove flaky designation for test-cli-node-options (Rich Trott) [#27305](https://github.com/nodejs/node/pull/27305)
* [[`7167eb2f12`](https://github.com/nodejs/node/commit/7167eb2f12)] - **test**: increase coverage for dns.promises.lookup() (Rich Trott) [#27299](https://github.com/nodejs/node/pull/27299)
* [[`b66f01d903`](https://github.com/nodejs/node/commit/b66f01d903)] - **test**: skip test-cpu-prof in debug builds with code cache (Joyee Cheung) [#27308](https://github.com/nodejs/node/pull/27308)
* [[`57ab3b56fc`](https://github.com/nodejs/node/commit/57ab3b56fc)] - **test**: allow leaked global check to be skipped (cjihrig) [#27239](https://github.com/nodejs/node/pull/27239)
* [[`02885dad5a`](https://github.com/nodejs/node/commit/02885dad5a)] - **test**: add ability to skip common flag checks (Anna Henningsen) [#27254](https://github.com/nodejs/node/pull/27254)
* [[`ed893111b9`](https://github.com/nodejs/node/commit/ed893111b9)] - **test**: do not strip left whitespace in pseudo-tty tests (Ruben Bridgewater) [#27244](https://github.com/nodejs/node/pull/27244)
* [[`8712edf53a`](https://github.com/nodejs/node/commit/8712edf53a)] - **test**: fix postmortem metadata test (Matheus Marchini) [#27265](https://github.com/nodejs/node/pull/27265)
* [[`d5bb500d0f`](https://github.com/nodejs/node/commit/d5bb500d0f)] - **test**: fix test-benchmark-buffer (Rich Trott) [#27260](https://github.com/nodejs/node/pull/27260)
* [[`4f8b497991`](https://github.com/nodejs/node/commit/4f8b497991)] - **test**: try to stabalize test-child-process-fork-exec-path.js (Refael Ackermann) [#27277](https://github.com/nodejs/node/pull/27277)
* [[`c6c37e9e85`](https://github.com/nodejs/node/commit/c6c37e9e85)] - **test**: use assert.rejects() and assert.throws() (Richard Lau) [#27207](https://github.com/nodejs/node/pull/27207)
* [[`f85ef977e6`](https://github.com/nodejs/node/commit/f85ef977e6)] - **test**: log errors in test-fs-readfile-tostring-fail (Richard Lau) [#27058](https://github.com/nodejs/node/pull/27058)
* [[`de463f1490`](https://github.com/nodejs/node/commit/de463f1490)] - **test**: ec2 generateKeyPairSync invalid parameter encoding (Ruwan Geeganage) [#27212](https://github.com/nodejs/node/pull/27212)
* [[`2fed83dee8`](https://github.com/nodejs/node/commit/2fed83dee8)] - **test**: test privateEncrypt/publicDecrypt + padding (Ben Noordhuis) [#27188](https://github.com/nodejs/node/pull/27188)
* [[`f6bd3b27ee`](https://github.com/nodejs/node/commit/f6bd3b27ee)] - **test**: fix test-dns-idna2008.js (Rich Trott) [#27208](https://github.com/nodejs/node/pull/27208)
* [[`8cf3af1486`](https://github.com/nodejs/node/commit/8cf3af1486)] - **test**: optimize total Travis run time (Refael Ackermann) [#27182](https://github.com/nodejs/node/pull/27182)
* [[`abe4183d41`](https://github.com/nodejs/node/commit/abe4183d41)] - **test**: mark some known flakes (Refael Ackermann) [#27193](https://github.com/nodejs/node/pull/27193)
* [[`06c803d9b9`](https://github.com/nodejs/node/commit/06c803d9b9)] - **test**: pass null params to napi\_create\_function() (Octavian Soldea) [#26998](https://github.com/nodejs/node/pull/26998)
* [[`2a51ae424a`](https://github.com/nodejs/node/commit/2a51ae424a)] - **test**: cover thenables when we check for promises (szabolcsit) [#24219](https://github.com/nodejs/node/pull/24219)
* [[`3a6eba3de6`](https://github.com/nodejs/node/commit/3a6eba3de6)] - **test**: use assert.rejects (Ruben Bridgewater) [#27123](https://github.com/nodejs/node/pull/27123)
* [[`3d6533ea02`](https://github.com/nodejs/node/commit/3d6533ea02)] - **test**: simplify vm-module-errors test (Ruben Bridgewater) [#27123](https://github.com/nodejs/node/pull/27123)
* [[`d1413305e0`](https://github.com/nodejs/node/commit/d1413305e0)] - **test**: print child stderr in test-http-chunk-problem (Anna Henningsen) [#27117](https://github.com/nodejs/node/pull/27117)
* [[`f96a6608eb`](https://github.com/nodejs/node/commit/f96a6608eb)] - **test**: fix test-worker-memory.js for large cpu #s (Michael Dawson) [#27090](https://github.com/nodejs/node/pull/27090)
* [[`93df085386`](https://github.com/nodejs/node/commit/93df085386)] - **test**: fix this scope bug in test-stream2-writable.js (gengjiawen) [#27111](https://github.com/nodejs/node/pull/27111)
* [[`58aaf58406`](https://github.com/nodejs/node/commit/58aaf58406)] - **test**: fix test-repl-require-after-write (Michaël Zasso) [#27088](https://github.com/nodejs/node/pull/27088)
* [[`baa54a5ae7`](https://github.com/nodejs/node/commit/baa54a5ae7)] - **test**: cover napi\_get/set/has\_named\_property() (Gabriel Schulhof) [#26947](https://github.com/nodejs/node/pull/26947)
* [[`c86883cfac`](https://github.com/nodejs/node/commit/c86883cfac)] - **test**: fix test-benchmark-module (Rich Trott) [#27094](https://github.com/nodejs/node/pull/27094)
* [[`f13733d12d`](https://github.com/nodejs/node/commit/f13733d12d)] - **test**: test vm.runInNewContext() filename option (Ben Noordhuis) [#27056](https://github.com/nodejs/node/pull/27056)
* [[`666c67e078`](https://github.com/nodejs/node/commit/666c67e078)] - **test**: simplify date inspection tests (Ruben Bridgewater) [#26922](https://github.com/nodejs/node/pull/26922)
* [[`1375af204a`](https://github.com/nodejs/node/commit/1375af204a)] - **test**: revert fail `coverage` target if tests fail" (Michael Dawson) [#25543](https://github.com/nodejs/node/pull/25543)
* [[`3235d318dc`](https://github.com/nodejs/node/commit/3235d318dc)] - **test**: add test for \_setSimultaneousAccepts() (Andrey Melikhov) [#24180](https://github.com/nodejs/node/pull/24180)
* [[`9e8c9be3ff`](https://github.com/nodejs/node/commit/9e8c9be3ff)] - **timers**: rename validateTimerDuration to getTimerDuration (Ruben Bridgewater) [#26809](https://github.com/nodejs/node/pull/26809)
* [[`a1d05e49fe`](https://github.com/nodejs/node/commit/a1d05e49fe)] - **timers**: support name in validateTimerDuration() (cjihrig) [#26215](https://github.com/nodejs/node/pull/26215)
* [[`2d5387e143`](https://github.com/nodejs/node/commit/2d5387e143)] - **tls**: add debugging to native TLS code (Anna Henningsen) [#26843](https://github.com/nodejs/node/pull/26843)
* [[`f87b3a72cd`](https://github.com/nodejs/node/commit/f87b3a72cd)] - **tls**: add CHECK for impossible condition (Anna Henningsen) [#26843](https://github.com/nodejs/node/pull/26843)
* [[`a1330af6a3`](https://github.com/nodejs/node/commit/a1330af6a3)] - **tls**: remove usage of public require('util') (dnlup) [#26747](https://github.com/nodejs/node/pull/26747)
* [[`00d49ad673`](https://github.com/nodejs/node/commit/00d49ad673)] - **tls**: null not valid as a renegotiate callback (Sam Roberts) [#25929](https://github.com/nodejs/node/pull/25929)
* [[`54b4beb506`](https://github.com/nodejs/node/commit/54b4beb506)] - **tls**: support TLS\_client\_method, TLS\_server\_method (Sam Roberts) [#24386](https://github.com/nodejs/node/pull/24386)
* [[`5ac0308af9`](https://github.com/nodejs/node/commit/5ac0308af9)] - **tools**: refactor mkcodecache (Refael Ackermann) [#27161](https://github.com/nodejs/node/pull/27161)
* [[`4fd7193579`](https://github.com/nodejs/node/commit/4fd7193579)] - **tools**: implement mkcodecache as an executable (Joyee Cheung) [#27161](https://github.com/nodejs/node/pull/27161)
* [[`d4e743169e`](https://github.com/nodejs/node/commit/d4e743169e)] - **tools**: update js-yaml to 3.13.1 for lint-md.js (Rich Trott) [#27195](https://github.com/nodejs/node/pull/27195)
* [[`1fc4255221`](https://github.com/nodejs/node/commit/1fc4255221)] - **tools**: python: ignore instead of select flake8 rules (Refael Ackermann) [#25614](https://github.com/nodejs/node/pull/25614)
* [[`a16a0fe962`](https://github.com/nodejs/node/commit/a16a0fe962)] - **tools**: python: activate more flake8 rules (Refael Ackermann) [#25614](https://github.com/nodejs/node/pull/25614)
* [[`0befda6970`](https://github.com/nodejs/node/commit/0befda6970)] - **tools**: python: update flake8 rules (Refael Ackermann) [#25614](https://github.com/nodejs/node/pull/25614)
* [[`0a25ace9c3`](https://github.com/nodejs/node/commit/0a25ace9c3)] - **tools**: move cpplint configuration to .cpplint (Refael Ackermann) [#27098](https://github.com/nodejs/node/pull/27098)
* [[`cd2987f83f`](https://github.com/nodejs/node/commit/cd2987f83f)] - **tools**: refloat 4 Node.js patches to cpplint.py (Refael Ackermann) [#27098](https://github.com/nodejs/node/pull/27098)
* [[`1302e0174a`](https://github.com/nodejs/node/commit/1302e0174a)] - **tools**: bump cpplint.py to 1.4.4 (Refael Ackermann) [#27098](https://github.com/nodejs/node/pull/27098)
* [[`dd89a1182f`](https://github.com/nodejs/node/commit/dd89a1182f)] - **tools**: print a better message for unexpected use of globals (Michaël Zasso) [#27083](https://github.com/nodejs/node/pull/27083)
* [[`39141426d4`](https://github.com/nodejs/node/commit/39141426d4)] - **tools**: update capitalize-comments eslint rule (Ruben Bridgewater) [#26849](https://github.com/nodejs/node/pull/26849)
* [[`964174e339`](https://github.com/nodejs/node/commit/964174e339)] - **tools,doc**: fix 404 broken links in docs (Gerson Niño) [#27168](https://github.com/nodejs/node/pull/27168)
* [[`bbfa93af3d`](https://github.com/nodejs/node/commit/bbfa93af3d)] - **url**: refactor validateHostname (Ruben Bridgewater) [#26809](https://github.com/nodejs/node/pull/26809)
* [[`2e4ceb5747`](https://github.com/nodejs/node/commit/2e4ceb5747)] - **util**: access process states lazily in debuglog (Joyee Cheung) [#27281](https://github.com/nodejs/node/pull/27281)
* [[`2948e96afd`](https://github.com/nodejs/node/commit/2948e96afd)] - **util**: fix wrong usage of Error.prepareStackTrace (Simon Zünd) [#27250](https://github.com/nodejs/node/pull/27250)
* [[`a9bf6652b5`](https://github.com/nodejs/node/commit/a9bf6652b5)] - **util**: use minimal object inspection with %s specifier (Ruben Bridgewater) [#26927](https://github.com/nodejs/node/pull/26927)
* [[`f7c96856f9`](https://github.com/nodejs/node/commit/f7c96856f9)] - **util**: improve error property inspection (Ruben Bridgewater) [#26984](https://github.com/nodejs/node/pull/26984)
* [[`14b2db0145`](https://github.com/nodejs/node/commit/14b2db0145)] - **util**: improve `inspect()` compact number mode (Ruben Bridgewater) [#26984](https://github.com/nodejs/node/pull/26984)
* [[`0f58ae392b`](https://github.com/nodejs/node/commit/0f58ae392b)] - **util**: `format()` now formats bigint and booleans (Ruben Bridgewater) [#25046](https://github.com/nodejs/node/pull/25046)
* [[`9752fce34d`](https://github.com/nodejs/node/commit/9752fce34d)] - **util**: improve format performance (Ruben Bridgewater) [#24981](https://github.com/nodejs/node/pull/24981)
* [[`e9fb92dc42`](https://github.com/nodejs/node/commit/e9fb92dc42)] - **vm**: remove require('util') from lib/vm/source\_text\_module.js (freestraws) [#27285](https://github.com/nodejs/node/pull/27285)
* [[`002dacb7f7`](https://github.com/nodejs/node/commit/002dacb7f7)] - **worker**: handle exception when creating execArgv errors (Anna Henningsen) [#27245](https://github.com/nodejs/node/pull/27245)
* [[`d070f5d965`](https://github.com/nodejs/node/commit/d070f5d965)] - **worker**: improve coverage (Ruben Bridgewater) [#27230](https://github.com/nodejs/node/pull/27230)
* [[`5450e48f69`](https://github.com/nodejs/node/commit/5450e48f69)] - **worker**: simplify filename checks (Ruben Bridgewater) [#27233](https://github.com/nodejs/node/pull/27233)
