#===============================================================================
# Copyright 2014 NetApp, Inc. All Rights Reserved,
# contribution by Jorge Mora <mora@netapp.com>
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#===============================================================================
# Generated by process_xdr.py from nfs4.x on Mon Nov 23 09:21:01 2015
"""
NFSv4 decoding module
"""
import nfstest_config as c
import nfs4_const as const
from packet.utils import *
from baseobj import BaseObj
from packet.unpack import Unpack
from packet.nfs.nfsbase import NFSbase

# Module constants
__author__    = "Jorge Mora (%s)" % c.NFSTEST_AUTHOR_EMAIL
__copyright__ = "Copyright (C) 2014 NetApp, Inc."
__license__   = "GPL v2"
__version__   = "4.2"

#
# Constants
class nfs_bool(Enum):
    """enum nfs_bool"""
    _enumdict = const.nfs_bool

# File types
class nfs_ftype4(Enum):
    """enum nfs_ftype4"""
    _enumdict = const.nfs_ftype4

# Error status
class nfsstat4(Enum):
    """enum nfsstat4"""
    _enumdict = const.nfsstat4

# Basic typedefs for RFC 1832 data type definitions
int32_t         = Unpack.unpack_int
uint32_t        = Unpack.unpack_uint
int64_t         = Unpack.unpack_int64
uint64_t        = Unpack.unpack_uint64

# Basic data types
attrlist4       = Unpack.unpack_opaque
bitmap4         = lambda unpack: LongHex(unpack.unpack_bitmap())
changeid4       = lambda unpack: LongHex(unpack.unpack_uint64())
clientid4       = lambda unpack: LongHex(unpack.unpack_uint64())
offset4         = uint64_t
count4          = uint32_t
length4         = uint64_t
mode4           = uint32_t
nfs_cookie4     = uint64_t
nfs_fh4         = lambda unpack: StrHex(unpack.unpack_opaque(const.NFS4_FHSIZE))
nfs_lease4      = uint32_t
qop4            = uint32_t
sec_oid4        = lambda unpack: StrHex(unpack.unpack_opaque())
seqid4          = uint32_t
utf8string      = Unpack.unpack_opaque
utf8str_cis     = utf8string
utf8str_cs      = utf8string
utf8str_mixed   = utf8string
component4      = utf8str_cs
linktext4       = utf8str_cs
ascii_REQUIRED4 = utf8string
pathname4       = lambda unpack: unpack.unpack_array(component4)
verifier4       = lambda unpack: StrHex(unpack.unpack_fopaque(const.NFS4_VERIFIER_SIZE))
acetype4        = lambda unpack: IntHex(unpack.unpack_uint())
aceflag4        = lambda unpack: IntHex(unpack.unpack_uint())
acemask4        = lambda unpack: IntHex(unpack.unpack_uint())
access4         = uint32_t

# New to NFSv4.1
sequenceid4     = uint32_t
sessionid4      = lambda unpack: StrHex(unpack.unpack_fopaque(const.NFS4_SESSIONID_SIZE))
slotid4         = uint32_t
aclflag4        = lambda unpack: IntHex(unpack.unpack_uint())
deviceid4       = lambda unpack: StrHex(unpack.unpack_fopaque(const.NFS4_DEVICEID4_SIZE))
fs_charset_cap4 = uint32_t
nfl_util4       = lambda unpack: IntHex(unpack.unpack_uint())
gsshandle4_t    = lambda unpack: StrHex(unpack.unpack_opaque())

# New to NFSv4.2
secret4         = Unpack.unpack_opaque
policy4         = uint32_t

# Timeval
class nfstime4(BaseObj):
    """
       struct nfstime4 {
           int64_t  seconds;
           uint32_t nseconds;
       };
    """
    # Class attributes
    _strfmt1  = "{0}.{1:09}"
    _attrlist = ("seconds", "nseconds")

    def __init__(self, unpack):
        self.seconds  = int64_t(unpack)
        self.nseconds = uint32_t(unpack)

class time_how4(Enum):
    """enum time_how4"""
    _enumdict = const.time_how4

class settime4(BaseObj):
    """
       union switch settime4 (time_how4 set_it) {
           case const.SET_TO_CLIENT_TIME4:
               nfstime4 time;
           default:
               void;
       };
    """
    def __init__(self, unpack):
        self.set_attr("set_it", time_how4(unpack))
        if self.set_it == const.SET_TO_CLIENT_TIME4:
            self.set_attr("time", nfstime4(unpack), switch=True)

# File attribute definitions
#
# FSID structure for major/minor
class fsid4(BaseObj):
    """
       struct fsid4 {
           uint64_t major;
           uint64_t minor;
       };
    """
    # Class attributes
    _strfmt1  = "{0},{1}"
    _attrlist = ("major", "minor")

    def __init__(self, unpack):
        self.major = uint64_t(unpack)
        self.minor = uint64_t(unpack)

# Filesystem locations attribute for relocation/migration
class fs_location4(BaseObj):
    """
       struct fs_location4 {
           utf8str_cis server<>;
           pathname4   root;
       };
    """
    # Class attributes
    _strfmt1  = "server:{0} rootpath:{1:/:}"
    _attrlist = ("server", "root")

    def __init__(self, unpack):
        self.server = unpack.unpack_array(utf8str_cis)
        self.root   = pathname4(unpack)

class fs_locations4(BaseObj):
    """
       struct fs_locations4 {
           pathname4    root;
           fs_location4 locations<>;
       };
    """
    # Class attributes
    _strfmt1  = "root:{1:/:}"
    _attrlist = ("root", "locations")

    def __init__(self, unpack):
        self.root      = pathname4(unpack)
        self.locations = unpack.unpack_array(fs_location4)

# Access Control Entry definition
class nfsace4(BaseObj):
    """
       struct nfsace4 {
           acetype4      type;
           aceflag4      flag;
           acemask4      mask;
           utf8str_mixed who;
       };
    """
    # Class attributes
    _attrlist = ("type", "flag", "mask", "who")

    def __init__(self, unpack):
        self.type = acetype4(unpack)
        self.flag = aceflag4(unpack)
        self.mask = acemask4(unpack)
        self.who  = utf8str_mixed(unpack)

# Access Control List definition new to NFSv4.1
class nfsacl41(BaseObj):
    """
       struct nfsacl41 {
           aclflag4 flag;
           nfsace4  aces<>;
       };
    """
    # Class attributes
    _attrlist = ("flag", "aces")

    def __init__(self, unpack):
        self.flag = aclflag4(unpack)
        self.aces = unpack.unpack_array(nfsace4)

# Special data/attribute associated with
# file types NF4BLK and NF4CHR.
class specdata4(BaseObj):
    """
       struct specdata4 {
           uint32_t specdata1;  /* major device number */
           uint32_t specdata2;  /* minor device number */
       };
    """
    # Class attributes
    _strfmt1  = "major:{0} minor:{1}"
    _attrlist = ("specdata1", "specdata2")

    def __init__(self, unpack):
        self.specdata1 = uint32_t(unpack)
        self.specdata2 = uint32_t(unpack)

# Stateid
class stateid4(BaseObj):
    """
       struct stateid4 {
           uint32_t seqid;
           opaque   other[NFS4_OTHER_SIZE];
       };
    """
    # Class attributes
    _eqattr   = "other"
    _strfmt1  = "{0},{1:crc16}"
    _attrlist = ("seqid", "other")

    def __init__(self, unpack):
        self.seqid = uint32_t(unpack)
        self.other = StrHex(unpack.unpack_fopaque(const.NFS4_OTHER_SIZE))

class stable_how4(Enum):
    """enum stable_how4"""
    _enumdict = const.stable_how4

class clientaddr4(BaseObj):
    """
       struct clientaddr4 {
           /* See struct rpcb in RFC 1833 */
           string netid<>;  /* network id */
           string addr<>;   /* universal address */
       };
    """
    # Class attributes
    _strfmt1  = "netid:{0} addr:{1}"
    _attrlist = ("netid", "addr")

    def __init__(self, unpack):
        self.netid = unpack.unpack_opaque()
        self.addr  = unpack.unpack_opaque()

netaddr4 = clientaddr4

# Data structures new to NFSv4.1
#
# Filesystem locations attribute
# for relocation/migration and
# related attributes.
class change_policy4(BaseObj):
    """
       struct change_policy4 {
           uint64_t major;
           uint64_t minor;
       };
    """
    # Class attributes
    _attrlist = ("major", "minor")

    def __init__(self, unpack):
        self.major = uint64_t(unpack)
        self.minor = uint64_t(unpack)

# Masked mode for the mode_set_masked attribute.
class mode_masked4(BaseObj):
    """
       struct mode_masked4 {
           mode4 values;  /* Values of bits to set or reset in mode. */
           mode4 mask;    /* Mask of bits to set or reset in mode. */
       };
    """
    # Class attributes
    _attrlist = ("values", "mask")

    def __init__(self, unpack):
        self.values = mode4(unpack)
        self.mask   = mode4(unpack)

class layouttype4(Enum):
    """enum layouttype4"""
    _enumdict = const.layouttype4

class filelayout_hint_care4(Enum):
    """enum filelayout_hint_care4"""
    _enumdict = const.filelayout_hint_care4

# Encoded in the body field of type layouthint4:
class nfsv4_1_file_layouthint4(BaseObj):
    """
       struct nfsv4_1_file_layouthint4 {
           uint32_t  size;          /* opaque size from layouthint4 */
           uint32_t  care;
           nfl_util4 nfl_util;
           count4    stripe_count;
       };
    """
    # Class attributes
    _attrlist = ("size", "care", "nfl_util", "stripe_count")

    def __init__(self, unpack):
        self.size         = uint32_t(unpack)
        self.care         = uint32_t(unpack)
        self.nfl_util     = nfl_util4(unpack)
        self.stripe_count = count4(unpack)

multipath_list4 = lambda unpack: unpack.unpack_array(netaddr4)

# Encoded in the addr_body field of type device_addr4:
class nfsv4_1_file_layout_ds_addr4(BaseObj):
    """
       struct nfsv4_1_file_layout_ds_addr4 {
           uint32_t        size;                 /* opaque size from device_addr4 */
           uint32_t        stripe_indices<>;
           multipath_list4 multipath_ds_list<>;
       };
    """
    # Class attributes
    _strfmt1  = "{2}"
    _attrlist = ("size", "stripe_indices", "multipath_ds_list")

    def __init__(self, unpack):
        self.size              = uint32_t(unpack)
        self.stripe_indices    = unpack.unpack_array(uint32_t)
        self.multipath_ds_list = unpack.unpack_array(multipath_list4)

# Encoded in the body field of type layout_content4:
class nfsv4_1_file_layout4(BaseObj):
    """
       struct nfsv4_1_file_layout4 {
           uint32_t  size;                /* opaque size from layout_content4 */
           deviceid4 deviceid;
           nfl_util4 nfl_util;
           uint32_t  first_stripe_index;
           offset4   pattern_offset;
           nfs_fh4   fh_list<>;
       };
    """
    # Class attributes
    _strfmt1  = "{5:crc32}"
    _attrlist = ("size", "deviceid", "nfl_util", "first_stripe_index",
                 "pattern_offset", "fh_list")

    def __init__(self, unpack):
        self.size               = uint32_t(unpack)
        self.deviceid           = deviceid4(unpack)
        self.nfl_util           = nfl_util4(unpack)
        self.first_stripe_index = uint32_t(unpack)
        self.pattern_offset     = offset4(unpack)
        self.fh_list            = unpack.unpack_array(nfs_fh4)

# NFSv4.x flex files layout definitions (BEGIN) ================================

class ff_device_versions4(BaseObj):
    """
       struct ff_device_versions4 {
           uint32_t version;
           uint32_t minorversion;
           uint32_t rsize;
           uint32_t wsize;
           bool     tightly_coupled;
       };
    """
    # Class attributes
    _strfmt1  = "vers:{0}.{1}"
    _attrlist = ("version", "minorversion", "rsize", "wsize", "tightly_coupled")

    def __init__(self, unpack):
        self.version         = uint32_t(unpack)
        self.minorversion    = uint32_t(unpack)
        self.rsize           = uint32_t(unpack)
        self.wsize           = uint32_t(unpack)
        self.tightly_coupled = nfs_bool(unpack)

class ff_device_addr4(BaseObj):
    """
       struct ff_device_addr4 {
           uint32_t            size;        /* opaque size from device_addr4 */
           multipath_list4     netaddrs;
           ff_device_versions4 versions<>;
       };
    """
    # Class attributes
    _strfmt1  = "{1} {2}"
    _attrlist = ("size", "netaddrs", "versions")

    def __init__(self, unpack):
        self.size     = uint32_t(unpack)
        self.netaddrs = multipath_list4(unpack)
        self.versions = unpack.unpack_array(ff_device_versions4)

ff_flags4 = uint32_t

class ff_data_server4(BaseObj):
    """
       struct ff_data_server4 {
           deviceid4          deviceid;
           uint32_t           efficiency;
           stateid4           stateid;
           nfs_fh4            fh_list<>;
           fattr4_owner       user;
           fattr4_owner_group group;
       };
    """
    # Class attributes
    _strfmt1  = "{3:crc32}"
    _attrlist = ("deviceid", "efficiency", "stateid", "fh_list", "user",
                 "group")

    def __init__(self, unpack):
        self.deviceid   = deviceid4(unpack)
        self.efficiency = uint32_t(unpack)
        self.stateid    = stateid4(unpack)
        self.fh_list    = unpack.unpack_array(nfs_fh4)
        self.user       = fattr4_owner(unpack)
        self.group      = fattr4_owner_group(unpack)

class ff_mirror4(BaseObj):
    """
       struct ff_mirror4 {
           ff_data_server4 data_servers<>;
       };
    """
    # Class attributes
    _strfmt1  = "{0}"
    _attrlist = ("data_servers",)

    def __init__(self, unpack):
        self.data_servers = unpack.unpack_array(ff_data_server4)

class ff_layout4(BaseObj):
    """
       struct ff_layout4 {
           uint32_t   size;         /* opaque size from layout_content4 */
           length4    stripe_unit;
           ff_mirror4 mirrors<>;
           ff_flags4  flags;
       };
    """
    # Class attributes
    _strfmt1  = "{2}"
    _attrlist = ("size", "stripe_unit", "mirrors", "flags")

    def __init__(self, unpack):
        self.size        = uint32_t(unpack)
        self.stripe_unit = length4(unpack)
        self.mirrors     = unpack.unpack_array(ff_mirror4)
        self.flags       = ff_flags4(unpack)

class ff_ioerr4(BaseObj):
    """
       struct ff_ioerr4 {
           offset4       offset;
           length4       length;
           stateid4      stateid;
           device_error4 errors<>;
       };
    """
    # Class attributes
    _attrlist = ("offset", "length", "stateid", "errors")

    def __init__(self, unpack):
        self.offset  = offset4(unpack)
        self.length  = length4(unpack)
        self.stateid = stateid4(unpack)
        self.errors  = unpack.unpack_array(device_error4)

class ff_io_latency4(BaseObj):
    """
       struct ff_io_latency4 {
           uint64_t ops_requested;
           uint64_t bytes_requested;
           uint64_t ops_completed;
           uint64_t bytes_completed;
           uint64_t bytes_not_delivered;
           nfstime4 total_busy_time;
           nfstime4 aggregate_completion_time;
       };
    """
    # Class attributes
    _attrlist = ("ops_requested", "bytes_requested", "ops_completed",
                 "bytes_completed", "bytes_not_delivered", "total_busy_time",
                 "aggregate_completion_time")

    def __init__(self, unpack):
        self.ops_requested             = uint64_t(unpack)
        self.bytes_requested           = uint64_t(unpack)
        self.ops_completed             = uint64_t(unpack)
        self.bytes_completed           = uint64_t(unpack)
        self.bytes_not_delivered       = uint64_t(unpack)
        self.total_busy_time           = nfstime4(unpack)
        self.aggregate_completion_time = nfstime4(unpack)

class ff_layoutupdate4(BaseObj):
    """
       struct ff_layoutupdate4 {
           netaddr4       addr;
           nfs_fh4        fh;
           ff_io_latency4 read;
           ff_io_latency4 write;
           nfstime4       duration;
           bool           local;
       };
    """
    # Class attributes
    _attrlist = ("addr", "fh", "read", "write", "duration", "local")

    def __init__(self, unpack):
        self.addr     = netaddr4(unpack)
        self.fh       = nfs_fh4(unpack)
        self.read     = ff_io_latency4(unpack)
        self.write    = ff_io_latency4(unpack)
        self.duration = nfstime4(unpack)
        self.local    = nfs_bool(unpack)

class ff_iostats4(BaseObj):
    """
       struct ff_iostats4 {
           offset4          offset;
           length4          length;
           stateid4         stateid;
           io_info4         read;
           io_info4         write;
           deviceid4        deviceid;
           ff_layoutupdate4 layoutupdate;
       };
    """
    # Class attributes
    _attrlist = ("offset", "length", "stateid", "read", "write", "deviceid",
                 "layoutupdate")

    def __init__(self, unpack):
        self.offset       = offset4(unpack)
        self.length       = length4(unpack)
        self.stateid      = stateid4(unpack)
        self.read         = io_info4(unpack)
        self.write        = io_info4(unpack)
        self.deviceid     = deviceid4(unpack)
        self.layoutupdate = ff_layoutupdate4(unpack)

class ff_layoutreturn4(BaseObj):
    """
       struct ff_layoutreturn4 {
           uint32_t    size;              /* opaque size from layoutreturn_file4 */
           ff_ioerr4   ioerr_report<>;
           ff_iostats4 iostats_report<>;
       };
    """
    # Class attributes
    _attrlist = ("size", "ioerr_report", "iostats_report")

    def __init__(self, unpack):
        self.size           = uint32_t(unpack)
        self.ioerr_report   = unpack.unpack_array(ff_ioerr4)
        self.iostats_report = unpack.unpack_array(ff_iostats4)

class ff_mirrors_hint(BaseObj):
    """
       union switch ff_mirrors_hint (bool ffmc_valid) {
           case const.TRUE:
               uint32_t mirrors;
           case const.FALSE:
               void;
       };
    """
    def __init__(self, unpack):
        self.set_attr("ffmc_valid", nfs_bool(unpack))
        if self.ffmc_valid == const.TRUE:
            self.set_attr("mirrors", uint32_t(unpack), switch=True)

class ff_layouthint4(BaseObj):
    """
       struct ff_layouthint4 {
           ff_mirrors_hint mirrors_hint;
       };
    """
    # Class attributes
    _attrlist = ("mirrors_hint",)

    def __init__(self, unpack):
        self.mirrors_hint = ff_mirrors_hint(unpack)

class ff_cb_recall_any_mask(Enum):
    """enum ff_cb_recall_any_mask"""
    _enumdict = const.ff_cb_recall_any_mask

# NFSv4.x flex files layout definitions (END) ==================================

# Original definition
# struct layout_content4 {
#     layouttype4  type;
#     opaque       body<>;
# };
class layout_content4(BaseObj):
    """
       union switch layout_content4 (layouttype4 type) {
           case const.LAYOUT4_NFSV4_1_FILES:
               nfsv4_1_file_layout4 body;
           case const.LAYOUT4_FLEX_FILES:
               ff_layout4 body;
           default:
               /* All other types are not supported yet */
               opaque body<>;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("type", layouttype4(unpack))
        if self.type == const.LAYOUT4_NFSV4_1_FILES:
            self.set_attr("body", nfsv4_1_file_layout4(unpack), switch=True)
        elif self.type == const.LAYOUT4_FLEX_FILES:
            self.set_attr("body", ff_layout4(unpack), switch=True)
        else:
            self.set_attr("body", unpack.unpack_opaque(), switch=True)
            self.set_strfmt(1, "")

# Original definition
# struct layouthint4 {
#     layouttype4  type;
#     opaque       body<>;
# };
class layouthint4(BaseObj):
    """
       union switch layouthint4 (layouttype4 type) {
           case const.LAYOUT4_NFSV4_1_FILES:
               nfsv4_1_file_layouthint4 body;
           case const.LAYOUT4_FLEX_FILES:
               ff_layouthint4 body;
           default:
               /* All other types are not supported yet */
               opaque body<>;
       };
    """
    def __init__(self, unpack):
        self.set_attr("type", layouttype4(unpack))
        if self.type == const.LAYOUT4_NFSV4_1_FILES:
            self.set_attr("body", nfsv4_1_file_layouthint4(unpack), switch=True)
        elif self.type == const.LAYOUT4_FLEX_FILES:
            self.set_attr("body", ff_layouthint4(unpack), switch=True)
        else:
            self.set_attr("body", unpack.unpack_opaque(), switch=True)

class layoutiomode4(Enum):
    """enum layoutiomode4"""
    _enumdict = const.layoutiomode4

class layout4(BaseObj):
    """
       struct layout4 {
           offset4         offset;
           length4         length;
           layoutiomode4   iomode;
           layout_content4 content;
       };
    """
    # Class attributes
    _strfmt1  = "{2:@14} off:{0:umax64} len:{1:umax64} {3}"
    _attrlist = ("offset", "length", "iomode", "content")

    def __init__(self, unpack):
        self.offset  = offset4(unpack)
        self.length  = length4(unpack)
        self.iomode  = layoutiomode4(unpack)
        self.content = layout_content4(unpack)

# Original definition
# struct device_addr4 {
#     layouttype4 type;
#     opaque      addr_body<>;
# };
class device_addr4(BaseObj):
    """
       union switch device_addr4 (layouttype4 type) {
           case const.LAYOUT4_NFSV4_1_FILES:
               nfsv4_1_file_layout_ds_addr4 body;
           case const.LAYOUT4_FLEX_FILES:
               ff_device_addr4 body;
           default:
               /* All other types are not supported yet */
               opaque body<>;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("type", layouttype4(unpack))
        if self.type == const.LAYOUT4_NFSV4_1_FILES:
            self.set_attr("body", nfsv4_1_file_layout_ds_addr4(unpack), switch=True)
        elif self.type == const.LAYOUT4_FLEX_FILES:
            self.set_attr("body", ff_device_addr4(unpack), switch=True)
        else:
            self.set_attr("body", unpack.unpack_opaque(), switch=True)
            self.set_strfmt(1, "")

# For LAYOUT4_NFSV4_1_FILES, the body field MUST have a zero length
class layoutupdate4(BaseObj):
    """
       struct layoutupdate4 {
           layouttype4 type;
           opaque      body<>;
       };
    """
    # Class attributes
    _attrlist = ("type", "body")

    def __init__(self, unpack):
        self.type = layouttype4(unpack)
        self.body = unpack.unpack_opaque()

class layoutreturn_type4(Enum):
    """enum layoutreturn_type4"""
    _enumdict = const.layoutreturn_type4

class layoutreturn_file_body4(BaseObj):
    """
       union switch layoutreturn_file_body4 (layouttype4 nfs4_layouttype) {
           case const.LAYOUT4_FLEX_FILES:
               ff_layoutreturn4 body;
           default:
               /* All other types are not supported yet or not used */
               opaque body<>;
       };
    """
    def __init__(self, unpack):
        if self.nfs4_layouttype == const.LAYOUT4_FLEX_FILES:
            self.set_attr("body", ff_layoutreturn4(unpack), switch=True)
        else:
            self.set_attr("body", unpack.unpack_opaque(), switch=True)

class layoutreturn_file4(BaseObj):
    """
       struct layoutreturn_file4 {
           offset4                 offset;
           length4                 length;
           stateid4                stateid;
           /* layouttype4 specific data */
           layoutreturn_file_body4 data;
       };
    """
    # Class attributes
    _fattrs   = ("data",)
    _strfmt1  = "off:{0:umax64} len:{1:umax64} stid:{2}"
    _attrlist = ("offset", "length", "stateid", "data")

    def __init__(self, unpack):
        self.offset  = offset4(unpack)
        self.length  = length4(unpack)
        self.stateid = stateid4(unpack)
        self.data    = layoutreturn_file_body4(unpack)

class layoutreturn4(BaseObj):
    """
       union switch layoutreturn4 (layoutreturn_type4 returntype) {
           case const.LAYOUTRETURN4_FILE:
               layoutreturn_file4 layout;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("returntype", layoutreturn_type4(unpack))
        if self.returntype == const.LAYOUTRETURN4_FILE:
            self.set_attr("layout", layoutreturn_file4(unpack), switch=True)

class fs4_status_type(Enum):
    """enum fs4_status_type"""
    _enumdict = const.fs4_status_type

class fs4_status(BaseObj):
    """
       struct fs4_status {
           bool            absent;
           fs4_status_type type;
           utf8str_cs      source;
           utf8str_cs      current;
           int32_t         age;
           nfstime4        version;
       };
    """
    # Class attributes
    _attrlist = ("absent", "type", "source", "current", "age", "version")

    def __init__(self, unpack):
        self.absent  = nfs_bool(unpack)
        self.type    = fs4_status_type(unpack)
        self.source  = utf8str_cs(unpack)
        self.current = utf8str_cs(unpack)
        self.age     = int32_t(unpack)
        self.version = nfstime4(unpack)

class threshold_item4(BaseObj):
    """
       struct threshold_item4 {
           layouttype4 type;
           bitmap4     mask;
           opaque      values<>;
       };
    """
    # Class attributes
    _attrlist = ("type", "mask", "values")

    def __init__(self, unpack):
        self.type   = layouttype4(unpack)
        self.mask   = bitmap4(unpack)
        self.values = unpack.unpack_opaque()

class mdsthreshold4(BaseObj):
    """
       struct mdsthreshold4 {
           threshold_item4 hints<>;
       };
    """
    # Class attributes
    _attrlist = ("hints",)

    def __init__(self, unpack):
        self.hints = unpack.unpack_array(threshold_item4)

class retention_get4(BaseObj):
    """
       struct retention_get4 {
           uint64_t duration;
           nfstime4 begin_time<1>;
       };
    """
    # Class attributes
    _attrlist = ("duration", "begin_time")

    def __init__(self, unpack):
        self.duration   = uint64_t(unpack)
        self.begin_time = unpack.unpack_conditional(nfstime4)

class retention_set4(BaseObj):
    """
       struct retention_set4 {
           bool     enable;
           uint64_t duration<1>;
       };
    """
    # Class attributes
    _attrlist = ("enable", "duration")

    def __init__(self, unpack):
        self.enable   = nfs_bool(unpack)
        self.duration = unpack.unpack_conditional(uint64_t)

# Defines an individual server replica
class fs_locations_server4(BaseObj):
    """
       struct fs_locations_server4 {
           int32_t     currency;
           opaque      info<>;
           utf8str_cis server;
       };
    """
    # Class attributes
    _attrlist = ("currency", "info", "server")

    def __init__(self, unpack):
        self.currency = int32_t(unpack)
        self.info     = unpack.unpack_opaque()
        self.server   = utf8str_cis(unpack)

# Defines a set of replicas sharing
# a common value of the root path
# with in the corresponding
# single-server namespaces.
class fs_locations_item4(BaseObj):
    """
       struct fs_locations_item4 {
           fs_locations_server4 entries<>;
           pathname4            root;
       };
    """
    # Class attributes
    _attrlist = ("entries", "root")

    def __init__(self, unpack):
        self.entries = unpack.unpack_array(fs_locations_server4)
        self.root    = pathname4(unpack)

# Defines the overall structure of
# the fs_locations_info attribute.
class fs_locations_info4(BaseObj):
    """
       struct fs_locations_info4 {
           uint32_t           flags;
           int32_t            valid_for;
           pathname4          root;
           fs_locations_item4 items<>;
       };
    """
    # Class attributes
    _attrlist = ("flags", "valid_for", "root", "items")

    def __init__(self, unpack):
        self.flags     = uint32_t(unpack)
        self.valid_for = int32_t(unpack)
        self.root      = pathname4(unpack)
        self.items     = unpack.unpack_array(fs_locations_item4)

# Data structures new to NFSv4.2
class netloc_type4(Enum):
    """enum netloc_type4"""
    _enumdict = const.netloc_type4

class netloc4(BaseObj):
    """
       union switch netloc4 (netloc_type4 type) {
           case const.NL4_NAME:
               utf8str_cis name;
           case const.NL4_URL:
               utf8str_cis url;
           case const.NL4_NETADDR:
               netaddr4 addr;
       };
    """
    # Class attributes
    _strfmt1 = "{0} {1}"

    def __init__(self, unpack):
        self.set_attr("type", netloc_type4(unpack))
        if self.type == const.NL4_NAME:
            self.set_attr("name", utf8str_cis(unpack), switch=True)
        elif self.type == const.NL4_URL:
            self.set_attr("url", utf8str_cis(unpack), switch=True)
        elif self.type == const.NL4_NETADDR:
            self.set_attr("addr", netaddr4(unpack), switch=True)

class change_attr_type4(Enum):
    """enum change_attr_type4"""
    _enumdict = const.change_attr_type4

class labelformat_spec4(BaseObj):
    """
       struct labelformat_spec4 {
           policy4 lfs;
           policy4 pi;
       };
    """
    # Class attributes
    _strfmt1  = "lfs:{0} pi:{1}"
    _attrlist = ("lfs", "pi")

    def __init__(self, unpack):
        self.lfs = policy4(unpack)
        self.pi  = policy4(unpack)

class sec_label4(BaseObj):
    """
       struct sec_label4 {
           labelformat_spec4 lfs;
           opaque            data<>;
       };
    """
    # Class attributes
    _strfmt1  = "{0} data:{1}"
    _attrlist = ("lfs", "data")

    def __init__(self, unpack):
        self.lfs  = labelformat_spec4(unpack)
        self.data = unpack.unpack_opaque()

# Used in RPCSEC_GSSv3
class copy_from_auth_priv(BaseObj):
    """
       struct copy_from_auth_priv {
           secret4       secret;
           netloc4       destination;
           /* the NFSv4 user name that the user principal maps to */
           utf8str_mixed username;
       };
    """
    # Class attributes
    _attrlist = ("secret", "destination", "username")

    def __init__(self, unpack):
        self.secret      = secret4(unpack)
        self.destination = netloc4(unpack)
        self.username    = utf8str_mixed(unpack)

# Used in RPCSEC_GSSv3
class copy_to_auth_priv(BaseObj):
    """
       struct copy_to_auth_priv {
           /* equal to cfap_shared_secret */
           secret4       secret;
           netloc4       source<>;
           /* the NFSv4 user name that the user principal maps to */
           utf8str_mixed username;
       };
    """
    # Class attributes
    _attrlist = ("secret", "source", "username")

    def __init__(self, unpack):
        self.secret   = secret4(unpack)
        self.source   = unpack.unpack_array(netloc4)
        self.username = utf8str_mixed(unpack)

# Used in RPCSEC_GSSv3
class copy_confirm_auth_priv(BaseObj):
    """
       struct copy_confirm_auth_priv {
           /* equal to GSS_GetMIC() of cfap_shared_secret */
           opaque        secret<>;
           /* the NFSv4 user name that the user principal maps to */
           utf8str_mixed username;
       };
    """
    # Class attributes
    _attrlist = ("secret", "username")

    def __init__(self, unpack):
        self.secret   = unpack.unpack_opaque()
        self.username = utf8str_mixed(unpack)

# Attributes
fattr4_supported_attrs    = bitmap4
fattr4_type               = nfs_ftype4
fattr4_fh_expire_type     = uint32_t
fattr4_change             = changeid4
fattr4_size               = uint64_t
fattr4_link_support       = nfs_bool
fattr4_symlink_support    = nfs_bool
fattr4_named_attr         = nfs_bool
fattr4_fsid               = fsid4
fattr4_unique_handles     = nfs_bool
fattr4_lease_time         = nfs_lease4
fattr4_rdattr_error       = nfsstat4
fattr4_acl                = lambda unpack: unpack.unpack_array(nfsace4)
fattr4_aclsupport         = uint32_t
fattr4_archive            = nfs_bool
fattr4_cansettime         = nfs_bool
fattr4_case_insensitive   = nfs_bool
fattr4_case_preserving    = nfs_bool
fattr4_chown_restricted   = nfs_bool
fattr4_fileid             = uint64_t
fattr4_files_avail        = uint64_t
fattr4_filehandle         = nfs_fh4
fattr4_files_free         = uint64_t
fattr4_files_total        = uint64_t
fattr4_fs_locations       = fs_locations4
fattr4_hidden             = nfs_bool
fattr4_homogeneous        = nfs_bool
fattr4_maxfilesize        = uint64_t
fattr4_maxlink            = uint32_t
fattr4_maxname            = uint32_t
fattr4_maxread            = uint64_t
fattr4_maxwrite           = uint64_t
fattr4_mimetype           = ascii_REQUIRED4
fattr4_mode               = mode4
fattr4_mounted_on_fileid  = uint64_t
fattr4_no_trunc           = nfs_bool
fattr4_numlinks           = uint32_t
fattr4_owner              = utf8str_mixed
fattr4_owner_group        = utf8str_mixed
fattr4_quota_avail_hard   = uint64_t
fattr4_quota_avail_soft   = uint64_t
fattr4_quota_used         = uint64_t
fattr4_rawdev             = specdata4
fattr4_space_avail        = uint64_t
fattr4_space_free         = uint64_t
fattr4_space_total        = uint64_t
fattr4_space_used         = uint64_t
fattr4_system             = nfs_bool
fattr4_time_access        = nfstime4
fattr4_time_access_set    = settime4
fattr4_time_backup        = nfstime4
fattr4_time_create        = nfstime4
fattr4_time_delta         = nfstime4
fattr4_time_metadata      = nfstime4
fattr4_time_modify        = nfstime4
fattr4_time_modify_set    = settime4

# Attributes new to NFSv4.1
fattr4_mode_set_masked    = mode_masked4
fattr4_suppattr_exclcreat = bitmap4
fattr4_dir_notif_delay    = nfstime4
fattr4_dirent_notif_delay = nfstime4
fattr4_fs_layout_types    = lambda unpack: unpack.unpack_array(layouttype4)
fattr4_fs_status          = fs4_status
fattr4_fs_charset_cap     = fs_charset_cap4
fattr4_layout_alignment   = uint32_t
fattr4_layout_blksize     = uint32_t
fattr4_layout_hint        = layouthint4
fattr4_layout_types       = lambda unpack: unpack.unpack_array(layouttype4)
fattr4_mdsthreshold       = mdsthreshold4
fattr4_retention_get      = retention_get4
fattr4_retention_set      = retention_set4
fattr4_retentevt_get      = retention_get4
fattr4_retentevt_set      = retention_set4
fattr4_retention_hold     = uint64_t
fattr4_dacl               = nfsacl41
fattr4_sacl               = nfsacl41
fattr4_change_policy      = change_policy4
fattr4_fs_locations_info  = fs_locations_info4

# Attributes new to NFSv4.2
fattr4_clone_blksize      = uint64_t
fattr4_space_freed        = uint64_t
fattr4_change_attr_type   = change_attr_type4
fattr4_sec_label          = sec_label4

class nfs_fattr4(Enum):
    """enum nfs_fattr4"""
    _enumdict = const.nfs_fattr4

nfs_fattr4_f = {
     # Mandatory Attributes
     0 : fattr4_supported_attrs,
     1 : fattr4_type,
     2 : fattr4_fh_expire_type,
     3 : fattr4_change,
     4 : fattr4_size,
     5 : fattr4_link_support,
     6 : fattr4_symlink_support,
     7 : fattr4_named_attr,
     8 : fattr4_fsid,
     9 : fattr4_unique_handles,
    10 : fattr4_lease_time,
    11 : fattr4_rdattr_error,
    19 : fattr4_filehandle,
    75 : fattr4_suppattr_exclcreat,  # New to NFSv4.1
    # Recommended Attributes
    12 : fattr4_acl,
    13 : fattr4_aclsupport,
    14 : fattr4_archive,
    15 : fattr4_cansettime,
    16 : fattr4_case_insensitive,
    17 : fattr4_case_preserving,
    18 : fattr4_chown_restricted,
    20 : fattr4_fileid,
    21 : fattr4_files_avail,
    22 : fattr4_files_free,
    23 : fattr4_files_total,
    24 : fattr4_fs_locations,
    25 : fattr4_hidden,
    26 : fattr4_homogeneous,
    27 : fattr4_maxfilesize,
    28 : fattr4_maxlink,
    29 : fattr4_maxname,
    30 : fattr4_maxread,
    31 : fattr4_maxwrite,
    32 : fattr4_mimetype,
    33 : fattr4_mode,
    34 : fattr4_no_trunc,
    35 : fattr4_numlinks,
    36 : fattr4_owner,
    37 : fattr4_owner_group,
    38 : fattr4_quota_avail_hard,
    39 : fattr4_quota_avail_soft,
    40 : fattr4_quota_used,
    41 : fattr4_rawdev,
    42 : fattr4_space_avail,
    43 : fattr4_space_free,
    44 : fattr4_space_total,
    45 : fattr4_space_used,
    46 : fattr4_system,
    47 : fattr4_time_access,
    48 : fattr4_time_access_set,
    49 : fattr4_time_backup,
    50 : fattr4_time_create,
    51 : fattr4_time_delta,
    52 : fattr4_time_metadata,
    53 : fattr4_time_modify,
    54 : fattr4_time_modify_set,
    55 : fattr4_mounted_on_fileid,
    # New to NFSv4.1
    56 : fattr4_dir_notif_delay,
    57 : fattr4_dirent_notif_delay,
    58 : fattr4_dacl,
    59 : fattr4_sacl,
    60 : fattr4_change_policy,
    61 : fattr4_fs_status,
    62 : fattr4_fs_layout_types,
    63 : fattr4_layout_hint,
    64 : fattr4_layout_types,
    65 : fattr4_layout_blksize,
    66 : fattr4_layout_alignment,
    67 : fattr4_fs_locations_info,
    68 : fattr4_mdsthreshold,
    69 : fattr4_retention_get,
    70 : fattr4_retention_set,
    71 : fattr4_retentevt_get,
    72 : fattr4_retentevt_set,
    73 : fattr4_retention_hold,
    74 : fattr4_mode_set_masked,
    76 : fattr4_fs_charset_cap,
    # New to NFSv4.2
    77 : fattr4_clone_blksize,
    78 : fattr4_space_freed,
    79 : fattr4_change_attr_type,
    80 : fattr4_sec_label,
}

# File attribute container
def fattr4(unpack):
    """
       struct fattr4 {
           bitmap4   mask;
           attrlist4 values;
       };
    """
    bitmap = bitmap4(unpack)
    unpack.unpack_uint()  # size of opaque
    return bitmap_dict(unpack, bitmap, nfs_fattr4_f)

# Change info for the client
class change_info4(BaseObj):
    """
       struct change_info4 {
           bool      atomic;
           changeid4 before;
           changeid4 after;
       };
    """
    # Class attributes
    _attrlist = ("atomic", "before", "after")

    def __init__(self, unpack):
        self.atomic = nfs_bool(unpack)
        self.before = changeid4(unpack)
        self.after  = changeid4(unpack)

class state_owner4(BaseObj):
    """
       struct state_owner4 {
           clientid4 clientid;
           opaque    owner<NFS4_OPAQUE_LIMIT>;
       };
    """
    # Class attributes
    _attrlist = ("clientid", "owner")

    def __init__(self, unpack):
        self.clientid = clientid4(unpack)
        self.owner    = StrHex(unpack.unpack_opaque(const.NFS4_OPAQUE_LIMIT))

open_owner4 = state_owner4
lock_owner4 = state_owner4

# Input for computing subkeys
class ssv_subkey4(Enum):
    """enum ssv_subkey4"""
    _enumdict = const.ssv_subkey4

# Input for computing smt_hmac
class ssv_mic_plain_tkn4(BaseObj):
    """
       struct ssv_mic_plain_tkn4 {
           uint32_t ssv_seq;
           opaque   orig_plain<>;
       };
    """
    # Class attributes
    _attrlist = ("ssv_seq", "orig_plain")

    def __init__(self, unpack):
        self.ssv_seq    = uint32_t(unpack)
        self.orig_plain = unpack.unpack_opaque()

# SSV GSS PerMsgToken token
class ssv_mic_tkn4(BaseObj):
    """
       struct ssv_mic_tkn4 {
           uint32_t ssv_seq;
           opaque   hmac<>;
       };
    """
    # Class attributes
    _attrlist = ("ssv_seq", "hmac")

    def __init__(self, unpack):
        self.ssv_seq = uint32_t(unpack)
        self.hmac    = unpack.unpack_opaque()

# Input for computing ssct_encr_data and ssct_hmac
class ssv_seal_plain_tkn4(BaseObj):
    """
       struct ssv_seal_plain_tkn4 {
           opaque   confounder<>;
           uint32_t ssv_seq;
           opaque   orig_plain<>;
           opaque   pad<>;
       };
    """
    # Class attributes
    _attrlist = ("confounder", "ssv_seq", "orig_plain", "pad")

    def __init__(self, unpack):
        self.confounder = unpack.unpack_opaque()
        self.ssv_seq    = uint32_t(unpack)
        self.orig_plain = unpack.unpack_opaque()
        self.pad        = unpack.unpack_opaque()

# SSV GSS SealedMessage token
class ssv_seal_cipher_tkn4(BaseObj):
    """
       struct ssv_seal_cipher_tkn4 {
           uint32_t ssv_seq;
           opaque   iv<>;
           opaque   encr_data<>;
           opaque   hmac<>;
       };
    """
    # Class attributes
    _attrlist = ("ssv_seq", "iv", "encr_data", "hmac")

    def __init__(self, unpack):
        self.ssv_seq   = uint32_t(unpack)
        self.iv        = unpack.unpack_opaque()
        self.encr_data = unpack.unpack_opaque()
        self.hmac      = unpack.unpack_opaque()

# ======================================================================
# NFSv4 Operation Definitions
# ======================================================================
#
# Operation array
class nfs_opnum4(Enum):
    """enum nfs_opnum4"""
    _enumdict = const.nfs_opnum4

# ACCESS: Check Access Rights
# ======================================================================
class ACCESS4args(BaseObj):
    """
       struct ACCESS4args {
           /* CURRENT_FH: object */
           access4 access;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} acc:{0:#04x}"
    _attrlist = ("access",)

    def __init__(self, unpack):
        self.access = access4(unpack)
        self.fh     = self.nfs4_fh

class ACCESS4resok(BaseObj):
    """
       struct ACCESS4resok {
           access4 supported;
           access4 access;
       };
    """
    # Class attributes
    _strfmt1  = "supported:{0:#04x} acc:{1:#04x}"
    _attrlist = ("supported", "access")

    def __init__(self, unpack):
        self.supported = access4(unpack)
        self.access    = access4(unpack)

class ACCESS4res(BaseObj):
    """
       union switch ACCESS4res (nfsstat4 status) {
           case const.NFS4_OK:
               ACCESS4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", ACCESS4resok(unpack), switch=True)

# CLOSE: Close a File and Release Share Reservations
# ======================================================================
class CLOSE4args(BaseObj):
    """
       struct CLOSE4args {
           /* CURRENT_FH: object */
           seqid4   seqid;
           stateid4 stateid;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} stid:{1}"
    _attrlist = ("seqid", "stateid")

    def __init__(self, unpack):
        self.seqid   = seqid4(unpack)
        self.stateid = stateid4(unpack)
        self.fh      = self.nfs4_fh

class CLOSE4res(BaseObj):
    """
       union switch CLOSE4res (nfsstat4 status) {
           case const.NFS4_OK:
               stateid4 stateid;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "stid:{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("stateid", stateid4(unpack), switch=True)

# COMMIT: Commit Cached Data on Server to Stable Storage
# ======================================================================
class COMMIT4args(BaseObj):
    """
       struct COMMIT4args {
           /* CURRENT_FH: file */
           offset4 offset;
           count4  count;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} off:{0:umax64} len:{1:umax32}"
    _attrlist = ("offset", "count")

    def __init__(self, unpack):
        self.offset = offset4(unpack)
        self.count  = count4(unpack)
        self.fh     = self.nfs4_fh

class COMMIT4resok(BaseObj):
    """
       struct COMMIT4resok {
           verifier4 verifier;
       };
    """
    # Class attributes
    _strfmt1  = "verf:{0}"
    _attrlist = ("verifier",)

    def __init__(self, unpack):
        self.verifier = verifier4(unpack)

class COMMIT4res(BaseObj):
    """
       union switch COMMIT4res (nfsstat4 status) {
           case const.NFS4_OK:
               COMMIT4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", COMMIT4resok(unpack), switch=True)

# CREATE: Create a Non-Regular File Object
# ======================================================================
class createtype4(BaseObj):
    """
       union switch createtype4 (nfs_ftype4 type) {
           case const.NF4LNK:
               linktext4 linkdata;
           case const.NF4BLK:
           case const.NF4CHR:
               specdata4 devdata;
           case const.NF4SOCK:
           case const.NF4FIFO:
           case const.NF4DIR:
               void;
           default:
               void;               /* server should return NFS4ERR_BADTYPE */
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("type", nfs_ftype4(unpack))
        if self.type == const.NF4LNK:
            self.set_attr("linkdata", linktext4(unpack), switch=True)
            self.set_strfmt(1, "-> {1}")
        elif self.type in [const.NF4BLK, const.NF4CHR]:
            self.set_attr("devdata", specdata4(unpack), switch=True)
            self.set_strfmt(1, "{1}")

class CREATE4args(BaseObj):
    """
       struct CREATE4args {
           /* CURRENT_FH: directory for creation */
           createtype4 type;
           component4  name;
           fattr4      attributes;
       };
    """
    # Class attributes
    _strfmt1  = "{0.type} DH:{fh:crc32}/{1} {0}"
    _attrlist = ("type", "name", "attributes")

    def __init__(self, unpack):
        self.type       = createtype4(unpack)
        self.name       = component4(unpack)
        self.attributes = fattr4(unpack)
        self.fh         = self.nfs4_fh

class CREATE4resok(BaseObj):
    """
       struct CREATE4resok {
           change_info4 cinfo;
           bitmap4      attrset;  /* attributes set */
       };
    """
    # Class attributes
    _attrlist = ("cinfo", "attrset")

    def __init__(self, unpack):
        self.cinfo   = change_info4(unpack)
        self.attrset = bitmap4(unpack)

class CREATE4res(BaseObj):
    """
       union switch CREATE4res (nfsstat4 status) {
           case const.NFS4_OK:
               /* new CURRENTFH: created object */
               CREATE4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", CREATE4resok(unpack), switch=True)

# DELEGPURGE: Purge Delegations Awaiting Recovery
# ======================================================================
class DELEGPURGE4args(BaseObj):
    """
       struct DELEGPURGE4args {
           clientid4 clientid;
       };
    """
    # Class attributes
    _strfmt1  = "clientid:{0}"
    _attrlist = ("clientid",)

    def __init__(self, unpack):
        self.clientid = clientid4(unpack)

class DELEGPURGE4res(BaseObj):
    """
       struct DELEGPURGE4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# DELEGRETURN: Return Delegation
# ======================================================================
class DELEGRETURN4args(BaseObj):
    """
       struct DELEGRETURN4args {
           /* CURRENT_FH: delegated object */
           stateid4 stateid;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} stid:{0}"
    _attrlist = ("stateid",)

    def __init__(self, unpack):
        self.stateid = stateid4(unpack)
        self.fh      = self.nfs4_fh

class DELEGRETURN4res(BaseObj):
    """
       struct DELEGRETURN4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# GETATTR: Get File Attributes
# ======================================================================
class GETATTR4args(BaseObj):
    """
       struct GETATTR4args {
           /* CURRENT_FH: object */
           bitmap4 request;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} request:{0}"
    _attrlist = ("request",)

    def __init__(self, unpack):
        self.request = bitmap4(unpack)
        self.fh      = self.nfs4_fh

class GETATTR4resok(BaseObj):
    """
       struct GETATTR4resok {
           fattr4 attributes;
       };
    """
    # Class attributes
    _attrlist = ("attributes",)

    def __init__(self, unpack):
        self.attributes = fattr4(unpack)

class GETATTR4res(BaseObj):
    """
       union switch GETATTR4res (nfsstat4 status) {
           case const.NFS4_OK:
               GETATTR4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", GETATTR4resok(unpack), switch=True)

# GETFH: Get Current Filehandle
# ======================================================================
class GETFH4resok(BaseObj):
    """
       struct GETFH4resok {
           nfs_fh4 fh;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{0:crc32}"
    _attrlist = ("fh",)

    def __init__(self, unpack):
        self.fh = nfs_fh4(unpack)
        self.set_global("nfs4_fh", self.fh)

class GETFH4res(BaseObj):
    """
       union switch GETFH4res (nfsstat4 status) {
           case const.NFS4_OK:
               GETFH4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", GETFH4resok(unpack), switch=True)

# LINK: Create Link to an Object
# ======================================================================
class LINK4args(BaseObj):
    """
       struct LINK4args {
           /*
            * SAVED_FH: source object
            * CURRENT_FH: target directory
            */
           component4 name;
       };
    """
    # Class attributes
    _strfmt1  = "DH:{fh:crc32}/{0} -> FH:{sfh:crc32}"
    _attrlist = ("name",)

    def __init__(self, unpack):
        self.name = component4(unpack)
        self.fh   = self.nfs4_fh
        self.sfh  = self.nfs4_sfh

class LINK4resok(BaseObj):
    """
       struct LINK4resok {
           change_info4 cinfo;
       };
    """
    # Class attributes
    _attrlist = ("cinfo",)

    def __init__(self, unpack):
        self.cinfo = change_info4(unpack)

class LINK4res(BaseObj):
    """
       union switch LINK4res (nfsstat4 status) {
           case const.NFS4_OK:
               LINK4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", LINK4resok(unpack), switch=True)

# LOCK/LOCKT/LOCKU: Record Lock Management
class nfs_lock_type4(Enum):
    """enum nfs_lock_type4"""
    _enumdict = const.nfs_lock_type4

# For LOCK, transition from open_stateid and lock_owner
# to a lock stateid.
class open_to_lock_owner4(BaseObj):
    """
       struct open_to_lock_owner4 {
           seqid4      seqid;
           stateid4    stateid;
           seqid4      lock_seqid;
           lock_owner4 lock_owner;
       };
    """
    # Class attributes
    _strfmt1  = "open(stid:{1}, seqid:{0}) seqid:{2}"
    _attrlist = ("seqid", "stateid", "lock_seqid", "lock_owner")

    def __init__(self, unpack):
        self.seqid      = seqid4(unpack)
        self.stateid    = stateid4(unpack)
        self.lock_seqid = seqid4(unpack)
        self.lock_owner = lock_owner4(unpack)

# For LOCK, existing lock stateid continues to request new
# file lock for the same lock_owner and open_stateid.
class exist_lock_owner4(BaseObj):
    """
       struct exist_lock_owner4 {
           stateid4 stateid;
           seqid4   seqid;
       };
    """
    # Class attributes
    _strfmt1  = "stid:{0} seqid:{1}"
    _attrlist = ("stateid", "seqid")

    def __init__(self, unpack):
        self.stateid = stateid4(unpack)
        self.seqid   = seqid4(unpack)

class locker4(BaseObj):
    """
       union switch locker4 (bool new_lock_owner) {
           case const.TRUE:
               open_to_lock_owner4 open_owner;
           case const.FALSE:
               exist_lock_owner4 lock_owner;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("new_lock_owner", nfs_bool(unpack))
        if self.new_lock_owner == const.TRUE:
            self.set_attr("open_owner", open_to_lock_owner4(unpack), switch=True)
        elif self.new_lock_owner == const.FALSE:
            self.set_attr("lock_owner", exist_lock_owner4(unpack), switch=True)

# LOCK: Create Lock
# ======================================================================
class LOCK4args(BaseObj):
    """
       struct LOCK4args {
           /* CURRENT_FH: file */
           nfs_lock_type4 locktype;
           bool           reclaim;
           offset4        offset;
           length4        length;
           locker4        locker;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} {0} off:{2:umax64} len:{3:umax64} {4}"
    _attrlist = ("locktype", "reclaim", "offset", "length", "locker")

    def __init__(self, unpack):
        self.locktype = nfs_lock_type4(unpack)
        self.reclaim  = nfs_bool(unpack)
        self.offset   = offset4(unpack)
        self.length   = length4(unpack)
        self.locker   = locker4(unpack)
        self.fh       = self.nfs4_fh

class LOCK4denied(BaseObj):
    """
       struct LOCK4denied {
           offset4        offset;
           length4        length;
           nfs_lock_type4 locktype;
           lock_owner4    owner;
       };
    """
    # Class attributes
    _strfmt1  = "{2} off:{0:umax64} len:{1:umax64}"
    _attrlist = ("offset", "length", "locktype", "owner")

    def __init__(self, unpack):
        self.offset   = offset4(unpack)
        self.length   = length4(unpack)
        self.locktype = nfs_lock_type4(unpack)
        self.owner    = lock_owner4(unpack)

class LOCK4resok(BaseObj):
    """
       struct LOCK4resok {
           stateid4 stateid;
       };
    """
    # Class attributes
    _strfmt1  = "stid:{0}"
    _attrlist = ("stateid",)

    def __init__(self, unpack):
        self.stateid = stateid4(unpack)

class LOCK4res(BaseObj):
    """
       union switch LOCK4res (nfsstat4 status) {
           case const.NFS4_OK:
               LOCK4resok resok;
           case const.NFS4ERR_DENIED:
               LOCK4denied denied;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", LOCK4resok(unpack), switch=True)
        elif self.status == const.NFS4ERR_DENIED:
            self.set_attr("denied", LOCK4denied(unpack), switch=True)

# LOCKT: Test For Lock
# ======================================================================
class LOCKT4args(BaseObj):
    """
       struct LOCKT4args {
           /* CURRENT_FH: file */
           nfs_lock_type4 locktype;
           offset4        offset;
           length4        length;
           lock_owner4    owner;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} {0} off:{1:umax64} len:{2:umax64}"
    _attrlist = ("locktype", "offset", "length", "owner")

    def __init__(self, unpack):
        self.locktype = nfs_lock_type4(unpack)
        self.offset   = offset4(unpack)
        self.length   = length4(unpack)
        self.owner    = lock_owner4(unpack)
        self.fh       = self.nfs4_fh

class LOCKT4res(BaseObj):
    """
       union switch LOCKT4res (nfsstat4 status) {
           case const.NFS4ERR_DENIED:
               LOCK4denied denied;
           case const.NFS4_OK:
               void;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4ERR_DENIED:
            self.set_attr("denied", LOCK4denied(unpack), switch=True)

# LOCKU: Unlock File
# ======================================================================
class LOCKU4args(BaseObj):
    """
       struct LOCKU4args {
           /* CURRENT_FH: file */
           nfs_lock_type4 locktype;
           seqid4         seqid;
           stateid4       stateid;
           offset4        offset;
           length4        length;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} {0} off:{3:umax64} len:{4:umax64} stid:{2}"
    _attrlist = ("locktype", "seqid", "stateid", "offset", "length")

    def __init__(self, unpack):
        self.locktype = nfs_lock_type4(unpack)
        self.seqid    = seqid4(unpack)
        self.stateid  = stateid4(unpack)
        self.offset   = offset4(unpack)
        self.length   = length4(unpack)
        self.fh       = self.nfs4_fh

class LOCKU4res(BaseObj):
    """
       union switch LOCKU4res (nfsstat4 status) {
           case const.NFS4_OK:
               stateid4 stateid;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "stid:{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("stateid", stateid4(unpack), switch=True)
        else:
            self.set_strfmt(1, "")

# LOOKUP: Lookup Filename
# ======================================================================
class LOOKUP4args(BaseObj):
    """
       struct LOOKUP4args {
           /* CURRENT_FH: directory */
           component4 name;
       };
    """
    # Class attributes
    _strfmt1  = "DH:{fh:crc32}/{0}"
    _attrlist = ("name",)

    def __init__(self, unpack):
        self.name = component4(unpack)
        self.fh   = self.nfs4_fh

class LOOKUP4res(BaseObj):
    """
       struct LOOKUP4res {
           /* New CURRENT_FH: object */
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# LOOKUPP: Lookup Parent Directory
# ======================================================================
class LOOKUPP4res(BaseObj):
    """
       struct LOOKUPP4res {
           /* new CURRENT_FH: parent directory */
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# NVERIFY: Verify Difference in Attributes
# ======================================================================
class NVERIFY4args(BaseObj):
    """
       struct NVERIFY4args {
           /* CURRENT_FH: object */
           fattr4 attributes;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("attributes",)

    def __init__(self, unpack):
        self.attributes = fattr4(unpack)
        self.fh         = self.nfs4_fh

class NVERIFY4res(BaseObj):
    """
       struct NVERIFY4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# Various definitions for OPEN
class createmode4(Enum):
    """enum createmode4"""
    _enumdict = const.createmode4

class creatverfattr(BaseObj):
    """
       struct creatverfattr {
           verifier4 verifier;
           fattr4    attrs;
       };
    """
    # Class attributes
    _attrlist = ("verifier", "attrs")

    def __init__(self, unpack):
        self.verifier = verifier4(unpack)
        self.attrs    = fattr4(unpack)

class createhow4(BaseObj):
    """
       union switch createhow4 (createmode4 mode) {
           case const.UNCHECKED4:
           case const.GUARDED4:
               fattr4 attributes;
           case const.EXCLUSIVE4:
               verifier4 verifier;
           case const.EXCLUSIVE4_1:
               creatverfattr createboth;
       };
    """
    def __init__(self, unpack):
        self.set_attr("mode", createmode4(unpack))
        if self.mode in [const.UNCHECKED4, const.GUARDED4]:
            self.set_attr("attributes", fattr4(unpack), switch=True)
        elif self.mode == const.EXCLUSIVE4:
            self.set_attr("verifier", verifier4(unpack), switch=True)
        elif self.mode == const.EXCLUSIVE4_1:
            self.set_attr("createboth", creatverfattr(unpack), switch=True)

class opentype4(Enum):
    """enum opentype4"""
    _enumdict = const.opentype4

class openflag4(BaseObj):
    """
       union switch openflag4 (opentype4 opentype) {
           case const.OPEN4_CREATE:
               createhow4 how;
           default:
               void;
       };
    """
    def __init__(self, unpack):
        self.set_attr("opentype", opentype4(unpack))
        if self.opentype == const.OPEN4_CREATE:
            self.set_attr("how", createhow4(unpack), switch=True)

# Next definitions used for OPEN delegation
class limit_by4(Enum):
    """enum limit_by4"""
    _enumdict = const.limit_by4

class nfs_modified_limit4(BaseObj):
    """
       struct nfs_modified_limit4 {
           uint32_t num_blocks;
           uint32_t bytes_per_block;
       };
    """
    # Class attributes
    _attrlist = ("num_blocks", "bytes_per_block")

    def __init__(self, unpack):
        self.num_blocks      = uint32_t(unpack)
        self.bytes_per_block = uint32_t(unpack)

class nfs_space_limit4(BaseObj):
    """
       union switch nfs_space_limit4 (limit_by4 limitby) {
           /* limit specified as file size */
           case const.NFS_LIMIT_SIZE:
               uint64_t filesize;
           /* limit specified by number of blocks */
           case const.NFS_LIMIT_BLOCKS:
               nfs_modified_limit4 mod_blocks;
       };
    """
    def __init__(self, unpack):
        self.set_attr("limitby", limit_by4(unpack))
        if self.limitby == const.NFS_LIMIT_SIZE:
            self.set_attr("filesize", uint64_t(unpack), switch=True)
        elif self.limitby == const.NFS_LIMIT_BLOCKS:
            self.set_attr("mod_blocks", nfs_modified_limit4(unpack), switch=True)

class open_delegation_type4(Enum):
    """enum open_delegation_type4"""
    _enumdict = const.open_delegation_type4

class open_claim_type4(Enum):
    """enum open_claim_type4"""
    _enumdict = const.open_claim_type4

class open_claim_delegate_cur4(BaseObj):
    """
       struct open_claim_delegate_cur4 {
           stateid4   stateid;
           component4 name;
       };
    """
    # Class attributes
    _strfmt1  = "{1} stid:{0}"
    _attrlist = ("stateid", "name")

    def __init__(self, unpack):
        self.stateid = stateid4(unpack)
        self.name    = component4(unpack)

class open_claim4(BaseObj):
    """
       union switch open_claim4 (open_claim_type4 claim) {
           /*
            * No special rights to file.
            * Ordinary OPEN of the specified file.
            */
           case const.CLAIM_NULL:
               /* CURRENT_FH: directory */
               component4 name;
           /*
            * Right to the file established by an
            * open previous to server reboot. File
            * identified by filehandle obtained at
            * that time rather than by name.
            */
           case const.CLAIM_PREVIOUS:
               /* CURRENT_FH: file being reclaimed */
               open_delegation_type4 deleg_type;
           /*
            * Right to file based on a delegation
            * granted by the server. File is
            * specified by name.
            */
           case const.CLAIM_DELEGATE_CUR:
               /* CURRENT_FH: directory */
               open_claim_delegate_cur4 deleg_info;
           /*
            * Right to file based on a delegation
            * granted to a previous boot instance
            * of the client.  File is specified by name.
            */
           case const.CLAIM_DELEGATE_PREV:
               /* CURRENT_FH: directory */
               component4 name;
           /*
            * Like CLAIM_NULL. No special rights
            * to file. Ordinary OPEN of the
            * specified file by current filehandle.
            */
           case const.CLAIM_FH:                     /* New to NFSv4.1 */
               /* CURRENT_FH: regular file to open */
               void;
           /*
            * Like CLAIM_DELEGATE_PREV. Right to file based on a
            * delegation granted to a previous boot
            * instance of the client.  File is identified by
            * by filehandle.
            */
           case const.CLAIM_DELEG_PREV_FH:          /* New to NFSv4.1 */
               /* CURRENT_FH: file being opened */
               void;
           /*
            * Like CLAIM_DELEGATE_CUR. Right to file based on
            * a delegation granted by the server.
            * File is identified by filehandle.
            */
           case const.CLAIM_DELEG_CUR_FH:           /* New to NFSv4.1 */
               /* CURRENT_FH: file being opened */
               stateid4 stateid;
       };
    """
    # Class attributes
    _strfmt1 = "DH:{fh:crc32}/{1}"

    def __init__(self, unpack):
        self.set_attr("claim", open_claim_type4(unpack))
        if self.claim == const.CLAIM_NULL:
            self.set_attr("name", component4(unpack), switch=True)
        elif self.claim == const.CLAIM_PREVIOUS:
            self.set_attr("deleg_type", open_delegation_type4(unpack), switch=True)
            self.set_strfmt(1, "{0}:{fh:crc32} {1}")
        elif self.claim == const.CLAIM_DELEGATE_CUR:
            self.set_attr("deleg_info", open_claim_delegate_cur4(unpack), switch=True)
            self.set_strfmt(1, "{0} DH:{fh:crc32}/{1}")
        elif self.claim == const.CLAIM_DELEGATE_PREV:
            self.set_attr("name", component4(unpack), switch=True)
            self.set_strfmt(1, "{0} DH:{fh:crc32}/{1}")
        elif self.claim == const.CLAIM_FH:
            self.set_strfmt(1, "{0}:{fh:crc32}")
        elif self.claim == const.CLAIM_DELEG_PREV_FH:
            self.set_strfmt(1, "{0}:{fh:crc32}")
        elif self.claim == const.CLAIM_DELEG_CUR_FH:
            self.set_attr("stateid", stateid4(unpack), switch=True)
            self.set_strfmt(1, "{0}:{fh:crc32} stid:{1}")
        self.fh = self.nfs4_fh

# OPEN: Open a Regular File, Potentially Receiving an Open Delegation
# ======================================================================
class OPEN4args(BaseObj):
    """
       struct OPEN4args {
           seqid4      seqid;
           uint32_t    access;
           uint32_t    deny;
           open_owner4 owner;
           openflag4   openhow;
           open_claim4 claim;
       };
    """
    # Class attributes
    _fattrs   = ("claim",)
    _strfmt1  = "{5} acc:{1:#04x} deny:{2:#04x}"
    _attrlist = ("seqid", "access", "deny", "owner", "openhow", "claim")

    def __init__(self, unpack):
        self.seqid   = seqid4(unpack)
        self.access  = uint32_t(unpack)
        self.deny    = uint32_t(unpack)
        self.owner   = open_owner4(unpack)
        self.openhow = openflag4(unpack)
        self.claim   = open_claim4(unpack)

class open_read_delegation4(BaseObj):
    """
       struct open_read_delegation4 {
           stateid4 stateid;      /* Stateid for delegation */
           bool     recall;       /* Pre-recalled flag for delegations obtained by reclaim (CLAIM_PREVIOUS) */
           nfsace4  permissions;  /* Defines users who don't need an ACCESS call to open for read */
       };
    """
    # Class attributes
    _strfmt1  = "rd_deleg_stid:{0}"
    _attrlist = ("stateid", "recall", "permissions")

    def __init__(self, unpack):
        self.stateid     = stateid4(unpack)
        self.recall      = nfs_bool(unpack)
        self.permissions = nfsace4(unpack)

class open_write_delegation4(BaseObj):
    """
       struct open_write_delegation4 {
           stateid4         stateid;      /* Stateid for delegation */
           bool             recall;       /* Pre-recalled flag for delegations obtained by reclaim (CLAIM_PREVIOUS) */
           nfs_space_limit4 space_limit;  /* Defines condition that the client must check to determine whether the file needs to be flushed to the server on close. */
           nfsace4          permissions;  /* Defines users who don't need an ACCESS call as part of a delegated open. */
       };
    """
    # Class attributes
    _strfmt1  = "wr_deleg_stid:{0}"
    _attrlist = ("stateid", "recall", "space_limit", "permissions")

    def __init__(self, unpack):
        self.stateid     = stateid4(unpack)
        self.recall      = nfs_bool(unpack)
        self.space_limit = nfs_space_limit4(unpack)
        self.permissions = nfsace4(unpack)

# New to NFSv4.1
class why_no_delegation4(Enum):
    """enum why_no_delegation4"""
    _enumdict = const.why_no_delegation4

# New to NFSv4.1
class open_none_delegation4(BaseObj):
    """
       union switch open_none_delegation4 (why_no_delegation4 why) {
           case const.WND4_CONTENTION:
               /* Server will push delegation */
               bool push;
           case const.WND4_RESOURCE:
               /* Server will signal availability */
               bool signal;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{0}"

    def __init__(self, unpack):
        self.set_attr("why", why_no_delegation4(unpack))
        if self.why == const.WND4_CONTENTION:
            self.set_attr("push", nfs_bool(unpack), switch=True)
            self.set_strfmt(1, "{0} push:{1}")
        elif self.why == const.WND4_RESOURCE:
            self.set_attr("signal", nfs_bool(unpack), switch=True)
            self.set_strfmt(1, "{0} signal:{1}")

class open_delegation4(BaseObj):
    """
       union switch open_delegation4 (open_delegation_type4 deleg_type) {
           case const.OPEN_DELEGATE_NONE:
               void;
           case const.OPEN_DELEGATE_READ:
               open_read_delegation4 read;
           case const.OPEN_DELEGATE_WRITE:
               open_write_delegation4 write;
           case const.OPEN_DELEGATE_NONE_EXT:  /* New to NFSv4.1 */
               open_none_delegation4 whynone;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("deleg_type", open_delegation_type4(unpack))
        if self.deleg_type == const.OPEN_DELEGATE_READ:
            self.set_attr("read", open_read_delegation4(unpack), switch=True)
        elif self.deleg_type == const.OPEN_DELEGATE_WRITE:
            self.set_attr("write", open_write_delegation4(unpack), switch=True)
        elif self.deleg_type == const.OPEN_DELEGATE_NONE_EXT:
            self.set_attr("whynone", open_none_delegation4(unpack), switch=True)

class OPEN4resok(BaseObj):
    """
       struct OPEN4resok {
           stateid4         stateid;     /* Stateid for open */
           change_info4     cinfo;       /* Directory Change Info */
           uint32_t         rflags;      /* Result flags */
           bitmap4          attrset;     /* attribute set for create */
           open_delegation4 delegation;  /* Info on any open delegation */
       };
    """
    # Class attributes
    _opdisp   = const.OP_GETFH
    _strfmt1  = "stid:{0} {4}"
    _attrlist = ("stateid", "cinfo", "rflags", "attrset", "delegation")

    def __init__(self, unpack):
        self.stateid    = stateid4(unpack)
        self.cinfo      = change_info4(unpack)
        self.rflags     = uint32_t(unpack)
        self.attrset    = bitmap4(unpack)
        self.delegation = open_delegation4(unpack)

class OPEN4res(BaseObj):
    """
       union switch OPEN4res (nfsstat4 status) {
           case const.NFS4_OK:
               /* New CURRENT_FH: opened file */
               OPEN4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", OPEN4resok(unpack), switch=True)

# OPENATTR: Open Named Attributes Directory
# ======================================================================
class OPENATTR4args(BaseObj):
    """
       struct OPENATTR4args {
           /* CURRENT_FH: object */
           bool createdir;
       };
    """
    # Class attributes
    _strfmt1  = "createdir:{0}"
    _attrlist = ("createdir",)

    def __init__(self, unpack):
        self.createdir = nfs_bool(unpack)
        self.fh        = self.nfs4_fh

class OPENATTR4res(BaseObj):
    """
       struct OPENATTR4res {
           /*
            * If status is NFS4_OK,
            *   new CURRENT_FH: named attribute directory
            */
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# OPEN_CONFIRM: Confirm the Open
# ======================================================================
# Obsolete in NFSv4.1
class OPEN_CONFIRM4args(BaseObj):
    """
       struct OPEN_CONFIRM4args {
           /* CURRENT_FH: opened file */
           stateid4 stateid;
           seqid4   seqid;
       };
    """
    # Class attributes
    _strfmt1  = "stid:{0} seqid:{1}"
    _attrlist = ("stateid", "seqid")

    def __init__(self, unpack):
        self.stateid = stateid4(unpack)
        self.seqid   = seqid4(unpack)
        self.fh      = self.nfs4_fh

class OPEN_CONFIRM4resok(BaseObj):
    """
       struct OPEN_CONFIRM4resok {
           stateid4 stateid;
       };
    """
    # Class attributes
    _strfmt1  = "stid:{0}"
    _attrlist = ("stateid",)

    def __init__(self, unpack):
        self.stateid = stateid4(unpack)

class OPEN_CONFIRM4res(BaseObj):
    """
       union switch OPEN_CONFIRM4res (nfsstat4 status) {
           case const.NFS4_OK:
               OPEN_CONFIRM4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", OPEN_CONFIRM4resok(unpack), switch=True)

# OPEN_DOWNGRADE: Reduce Open File Access
# ======================================================================
class OPEN_DOWNGRADE4args(BaseObj):
    """
       struct OPEN_DOWNGRADE4args {
           /* CURRENT_FH: opened file */
           stateid4 stateid;
           seqid4   seqid;
           uint32_t access;
           uint32_t deny;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} stid:{0} acc:{2:#04x} deny:{3:#04x}"
    _attrlist = ("stateid", "seqid", "access", "deny")

    def __init__(self, unpack):
        self.stateid = stateid4(unpack)
        self.seqid   = seqid4(unpack)
        self.access  = uint32_t(unpack)
        self.deny    = uint32_t(unpack)
        self.fh      = self.nfs4_fh

class OPEN_DOWNGRADE4resok(BaseObj):
    """
       struct OPEN_DOWNGRADE4resok {
           stateid4 stateid;
       };
    """
    # Class attributes
    _strfmt1  = "stid:{0}"
    _attrlist = ("stateid",)

    def __init__(self, unpack):
        self.stateid = stateid4(unpack)

class OPEN_DOWNGRADE4res(BaseObj):
    """
       union switch OPEN_DOWNGRADE4res (nfsstat4 status) {
           case const.NFS4_OK:
               OPEN_DOWNGRADE4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", OPEN_DOWNGRADE4resok(unpack), switch=True)

# PUTFH: Set Current Filehandle
# ======================================================================
class PUTFH4args(BaseObj):
    """
       struct PUTFH4args {
           nfs_fh4 fh;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{0:crc32}"
    _attrlist = ("fh",)

    def __init__(self, unpack):
        self.fh = nfs_fh4(unpack)
        self.set_global("nfs4_fh", self.fh)

class PUTFH4res(BaseObj):
    """
       struct PUTFH4res {
           /*
            * If status is NFS4_OK,
            *    new CURRENT_FH: argument to PUTFH
            */
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# PUTPUBFH: Set Public Filehandle
# ======================================================================
class PUTPUBFH4res(BaseObj):
    """
       struct PUTPUBFH4res {
           /*
            * If status is NFS4_OK,
            *   new CURRENT_FH: public fh
            */
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# PUTROOTFH: Set Root Filehandle
# ======================================================================
class PUTROOTFH4res(BaseObj):
    """
       struct PUTROOTFH4res {
           /*
            * If status is NFS4_OK,
            *   new CURRENT_FH: root fh
            */
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# READ: Read From File
# ======================================================================
class READ4args(BaseObj):
    """
       struct READ4args {
           /* CURRENT_FH: file */
           stateid4 stateid;
           offset4  offset;
           count4   count;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} stid:{0} off:{1:umax64} len:{2:umax32}"
    _attrlist = ("stateid", "offset", "count")

    def __init__(self, unpack):
        self.stateid = stateid4(unpack)
        self.offset  = offset4(unpack)
        self.count   = count4(unpack)
        self.fh      = self.nfs4_fh

class READ4resok(BaseObj):
    """
       struct READ4resok {
           bool   eof;
           opaque data<>;
       };
    """
    # Class attributes
    _strfmt1  = "eof:{0} count:{1:umax32}"
    _attrlist = ("eof", "count", "data")

    def __init__(self, unpack):
        self.eof   = nfs_bool(unpack)
        self.count = unpack.unpack_uint()
        self.data  = unpack.unpack_fopaque(self.count)

class READ4res(BaseObj):
    """
       union switch READ4res (nfsstat4 status) {
           case const.NFS4_OK:
               READ4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", READ4resok(unpack), switch=True)

# READDIR: Read Directory
# ======================================================================
class READDIR4args(BaseObj):
    """
       struct READDIR4args {
           /* CURRENT_FH: directory */
           nfs_cookie4 cookie;
           verifier4   verifier;
           count4      dircount;
           count4      maxcount;
           bitmap4     request;
       };
    """
    # Class attributes
    _strfmt1  = "DH:{fh:crc32} cookie:{0} verf:{1} count:{2:umax32}"
    _attrlist = ("cookie", "verifier", "dircount", "maxcount", "request")

    def __init__(self, unpack):
        self.cookie   = nfs_cookie4(unpack)
        self.verifier = verifier4(unpack)
        self.dircount = count4(unpack)
        self.maxcount = count4(unpack)
        self.request  = bitmap4(unpack)
        self.fh       = self.nfs4_fh

class entry4(BaseObj):
    """
       struct entry4 {
           nfs_cookie4 cookie;
           component4  name;
           fattr4      attrs;
           entry4      *nextentry;
       };
    """
    # Class attributes
    _attrlist = ("cookie", "name", "attrs")

    def __init__(self, unpack):
        self.cookie = nfs_cookie4(unpack)
        self.name   = component4(unpack)
        self.attrs  = fattr4(unpack)

class dirlist4(BaseObj):
    """
       struct dirlist4 {
           entry4 *entries;
           bool   eof;
       };
    """
    # Class attributes
    _strfmt1  = "eof:{1}"
    _attrlist = ("entries", "eof")

    def __init__(self, unpack):
        try:
            self.entries = unpack.unpack_list(entry4)
            self.eof     = nfs_bool(unpack)
        except:
            pass

class READDIR4resok(BaseObj):
    """
       struct READDIR4resok {
           verifier4 verifier;
           dirlist4  reply;
       };
    """
    # Class attributes
    _strfmt1  = "verf:{0} {1}"
    _attrlist = ("verifier", "reply")

    def __init__(self, unpack):
        self.verifier = verifier4(unpack)
        self.reply    = dirlist4(unpack)

class READDIR4res(BaseObj):
    """
       union switch READDIR4res (nfsstat4 status) {
           case const.NFS4_OK:
               READDIR4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", READDIR4resok(unpack), switch=True)

# READLINK: Read Symbolic Link
# ======================================================================
class READLINK4resok(BaseObj):
    """
       struct READLINK4resok {
           linktext4 link;
       };
    """
    # Class attributes
    _strfmt1  = "{0}"
    _attrlist = ("link",)

    def __init__(self, unpack):
        self.link = linktext4(unpack)

class READLINK4res(BaseObj):
    """
       union switch READLINK4res (nfsstat4 status) {
           case const.NFS4_OK:
               READLINK4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", READLINK4resok(unpack), switch=True)

# REMOVE: Remove Filesystem Object
# ======================================================================
class REMOVE4args(BaseObj):
    """
       struct REMOVE4args {
           /* CURRENT_FH: directory */
           component4 name;
       };
    """
    # Class attributes
    _strfmt1  = "DH:{fh:crc32}/{0}"
    _attrlist = ("name",)

    def __init__(self, unpack):
        self.name = component4(unpack)
        self.fh   = self.nfs4_fh

class REMOVE4resok(BaseObj):
    """
       struct REMOVE4resok {
           change_info4 cinfo;
       };
    """
    # Class attributes
    _attrlist = ("cinfo",)

    def __init__(self, unpack):
        self.cinfo = change_info4(unpack)

class REMOVE4res(BaseObj):
    """
       union switch REMOVE4res (nfsstat4 status) {
           case const.NFS4_OK:
               REMOVE4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", REMOVE4resok(unpack), switch=True)

# RENAME: Rename Directory Entry
# ======================================================================
class RENAME4args(BaseObj):
    """
       struct RENAME4args {
           /* SAVED_FH: source directory */
           component4 name;
           /* CURRENT_FH: target directory */
           component4 newname;
       };
    """
    # Class attributes
    _strfmt1  = "{sfh:crc32}/{0} -> {fh:crc32}/{1}"
    _attrlist = ("name", "newname")

    def __init__(self, unpack):
        self.name    = component4(unpack)
        self.newname = component4(unpack)
        self.fh      = self.nfs4_fh
        self.sfh     = self.nfs4_sfh

class RENAME4resok(BaseObj):
    """
       struct RENAME4resok {
           change_info4 source;
           change_info4 target;
       };
    """
    # Class attributes
    _attrlist = ("source", "target")

    def __init__(self, unpack):
        self.source = change_info4(unpack)
        self.target = change_info4(unpack)

class RENAME4res(BaseObj):
    """
       union switch RENAME4res (nfsstat4 status) {
           case const.NFS4_OK:
               RENAME4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", RENAME4resok(unpack), switch=True)

# RENEW: Renew a Lease
# ======================================================================
# Obsolete in NFSv4.1
class RENEW4args(BaseObj):
    """
       struct RENEW4args {
           clientid4 clientid;
       };
    """
    # Class attributes
    _strfmt1  = "clientid:{0}"
    _attrlist = ("clientid",)

    def __init__(self, unpack):
        self.clientid = clientid4(unpack)

class RENEW4res(BaseObj):
    """
       struct RENEW4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# RESTOREFH: Restore Saved Filehandle
# ======================================================================
class RESTOREFH4res(BaseObj):
    """
       struct RESTOREFH4res {
           /*
            * If status is NFS4_OK,
            *     new CURRENT_FH: value of saved fh
            */
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# SAVEFH: Save Current Filehandle
# ======================================================================
class SAVEFH4res(BaseObj):
    """
       struct SAVEFH4res {
           /*
            * If status is NFS4_OK,
            *    new SAVED_FH: value of current fh
            */
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# SECINFO: Obtain Available Security Mechanisms
# ======================================================================
class SECINFO4args(BaseObj):
    """
       struct SECINFO4args {
           /* CURRENT_FH: directory */
           component4 name;
       };
    """
    # Class attributes
    _strfmt1  = "{fh:crc32}/{0}"
    _attrlist = ("name",)

    def __init__(self, unpack):
        self.name = component4(unpack)
        self.fh   = self.nfs4_fh

class nfs_secflavor4(Enum):
    """enum nfs_secflavor4"""
    _enumdict = const.nfs_secflavor4

# From RFC 2203
class rpc_gss_svc_t(Enum):
    """enum rpc_gss_svc_t"""
    _enumdict = const.rpc_gss_svc_t

class rpcsec_gss_info(BaseObj):
    """
       struct rpcsec_gss_info {
           sec_oid4      oid;
           qop4          qop;
           rpc_gss_svc_t service;
       };
    """
    # Class attributes
    _strfmt1  = "{2}"
    _attrlist = ("oid", "qop", "service")

    def __init__(self, unpack):
        self.oid     = sec_oid4(unpack)
        self.qop     = qop4(unpack)
        self.service = rpc_gss_svc_t(unpack)

# RPCSEC_GSS has a value of '6' - See RFC 2203
class secinfo4(BaseObj):
    """
       union switch secinfo4 (nfs_secflavor4 flavor) {
           case const.RPCSEC_GSS:
               rpcsec_gss_info info;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{0}"

    def __init__(self, unpack):
        self.set_attr("flavor", nfs_secflavor4(unpack))
        if self.flavor == const.RPCSEC_GSS:
            self.set_attr("info", rpcsec_gss_info(unpack), switch=True)
            self.set_strfmt(1, "{1}")

SECINFO4resok = lambda unpack: unpack.unpack_array(secinfo4)

class SECINFO4res(BaseObj):
    """
       union switch SECINFO4res (nfsstat4 status) {
           case const.NFS4_OK:
               /* CURRENTFH: consumed */
               SECINFO4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", SECINFO4resok(unpack), switch=True)

# SETATTR: Set Attributes
# ======================================================================
class SETATTR4args(BaseObj):
    """
       struct SETATTR4args {
           /* CURRENT_FH: target object */
           stateid4 stateid;
           fattr4   attributes;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} stid:{0}"
    _attrlist = ("stateid", "attributes")

    def __init__(self, unpack):
        self.stateid    = stateid4(unpack)
        self.attributes = fattr4(unpack)
        self.fh         = self.nfs4_fh

class SETATTR4res(BaseObj):
    """
       struct SETATTR4res {
           nfsstat4 status;
           bitmap4  attrset;
       };
    """
    # Class attributes
    _strfmt1  = "attrset:{1}"
    _attrlist = ("status", "attrset")

    def __init__(self, unpack):
        self.status  = nfsstat4(unpack)
        self.attrset = bitmap4(unpack)

# Client ID
class nfs_client_id4(BaseObj):
    """
       struct nfs_client_id4 {
           verifier4 verifier;
           opaque    id<NFS4_OPAQUE_LIMIT>;
       };
    """
    # Class attributes
    _attrlist = ("verifier", "id")

    def __init__(self, unpack):
        self.verifier = verifier4(unpack)
        self.id       = unpack.unpack_opaque(const.NFS4_OPAQUE_LIMIT)

# Callback program info as provided by the client
class cb_client4(BaseObj):
    """
       struct cb_client4 {
           uint32_t cb_program;
           netaddr4 cb_location;
       };
    """
    # Class attributes
    _attrlist = ("cb_program", "cb_location")

    def __init__(self, unpack):
        self.cb_program  = uint32_t(unpack)
        self.cb_location = netaddr4(unpack)

# SETCLIENTID: Negotiate Clientid
# ======================================================================
# Obsolete in NFSv4.1
class SETCLIENTID4args(BaseObj):
    """
       struct SETCLIENTID4args {
           nfs_client_id4 client;
           cb_client4     callback;
           uint32_t       callback_ident;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("client", "callback", "callback_ident")

    def __init__(self, unpack):
        self.client         = nfs_client_id4(unpack)
        self.callback       = cb_client4(unpack)
        self.callback_ident = uint32_t(unpack)

class SETCLIENTID4resok(BaseObj):
    """
       struct SETCLIENTID4resok {
           clientid4 clientid;
           verifier4 verifier;
       };
    """
    # Class attributes
    _strfmt1  = "clientid:{0}"
    _attrlist = ("clientid", "verifier")

    def __init__(self, unpack):
        self.clientid = clientid4(unpack)
        self.verifier = verifier4(unpack)

class SETCLIENTID4res(BaseObj):
    """
       union switch SETCLIENTID4res (nfsstat4 status) {
           case const.NFS4_OK:
               SETCLIENTID4resok resok;
           case const.NFS4ERR_CLID_INUSE:
               clientaddr4 client;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", SETCLIENTID4resok(unpack), switch=True)
        elif self.status == const.NFS4ERR_CLID_INUSE:
            self.set_attr("client", clientaddr4(unpack), switch=True)
            self.set_strfmt(1, "")

# SETCLIENTID_CONFIRM: Confirm Clientid
# ======================================================================
# Obsolete in NFSv4.1
class SETCLIENTID_CONFIRM4args(BaseObj):
    """
       struct SETCLIENTID_CONFIRM4args {
           clientid4 clientid;
           verifier4 verifier;
       };
    """
    # Class attributes
    _strfmt1  = "clientid:{0}"
    _attrlist = ("clientid", "verifier")

    def __init__(self, unpack):
        self.clientid = clientid4(unpack)
        self.verifier = verifier4(unpack)

class SETCLIENTID_CONFIRM4res(BaseObj):
    """
       struct SETCLIENTID_CONFIRM4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# VERIFY: Verify Same Attributes
# ======================================================================
class VERIFY4args(BaseObj):
    """
       struct VERIFY4args {
           /* CURRENT_FH: object */
           fattr4 attributes;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("attributes",)

    def __init__(self, unpack):
        self.attributes = fattr4(unpack)
        self.fh         = self.nfs4_fh

class VERIFY4res(BaseObj):
    """
       struct VERIFY4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# WRITE: Write to File
# ======================================================================
class WRITE4args(BaseObj):
    """
       struct WRITE4args {
           /* CURRENT_FH: file */
           stateid4    stateid;
           offset4     offset;
           stable_how4 stable;
           opaque      data<>;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} stid:{0} off:{1:umax64} len:{3:umax32} {2}"
    _attrlist = ("stateid", "offset", "stable", "count", "data")

    def __init__(self, unpack):
        self.stateid = stateid4(unpack)
        self.offset  = offset4(unpack)
        self.stable  = stable_how4(unpack)
        self.count   = unpack.unpack_uint()
        self.data    = unpack.unpack_fopaque(self.count)
        self.fh      = self.nfs4_fh

class WRITE4resok(BaseObj):
    """
       struct WRITE4resok {
           count4      count;
           stable_how4 committed;
           verifier4   verifier;
       };
    """
    # Class attributes
    _strfmt1  = "count:{0:umax32} verf:{2} {1}"
    _attrlist = ("count", "committed", "verifier")

    def __init__(self, unpack):
        self.count     = count4(unpack)
        self.committed = stable_how4(unpack)
        self.verifier  = verifier4(unpack)

class WRITE4res(BaseObj):
    """
       union switch WRITE4res (nfsstat4 status) {
           case const.NFS4_OK:
               WRITE4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", WRITE4resok(unpack), switch=True)

# RELEASE_LOCKOWNER: Notify Server to Release Lockowner State
# ======================================================================
# Obsolete in NFSv4.1
class RELEASE_LOCKOWNER4args(BaseObj):
    """
       struct RELEASE_LOCKOWNER4args {
           lock_owner4 owner;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("owner",)

    def __init__(self, unpack):
        self.owner = lock_owner4(unpack)

class RELEASE_LOCKOWNER4res(BaseObj):
    """
       struct RELEASE_LOCKOWNER4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# ILLEGAL: Response for Illegal Operation Numbers
# ======================================================================
class ILLEGAL4res(BaseObj):
    """
       struct ILLEGAL4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# ======================================================================
# Operations new to NFSv4.1
# ======================================================================
#
# BACKCHANNEL_CTL: Backchannel Control
# ======================================================================
class authsys_parms(BaseObj):
    """
       struct authsys_parms {
           unsigned int stamp;
           string       machinename<255>;
           unsigned int uid;
           unsigned int gid;
           unsigned int gids<16>;
       };
    """
    # Class attributes
    _attrlist = ("stamp", "machinename", "uid", "gid", "gids")

    def __init__(self, unpack):
        self.stamp       = unpack.unpack_uint()
        self.machinename = unpack.unpack_opaque(255)
        self.uid         = unpack.unpack_uint()
        self.gid         = unpack.unpack_uint()
        self.gids        = unpack.unpack_array(Unpack.unpack_uint, maxcount=16)

class gss_cb_handles4(BaseObj):
    """
       struct gss_cb_handles4 {
           rpc_gss_svc_t service;        /* RFC 2203 */
           gsshandle4_t  server_handle;
           gsshandle4_t  client_handle;
       };
    """
    # Class attributes
    _attrlist = ("service", "server_handle", "client_handle")

    def __init__(self, unpack):
        self.service       = rpc_gss_svc_t(unpack)
        self.server_handle = gsshandle4_t(unpack)
        self.client_handle = gsshandle4_t(unpack)

class callback_sec_parms4(BaseObj):
    """
       union switch callback_sec_parms4 (nfs_secflavor4 flavor) {
           case const.AUTH_NONE:
               void;
           case const.AUTH_SYS:
               authsys_parms sys_cred;      /* RFC 1831 */
           case const.RPCSEC_GSS:
               gss_cb_handles4 gss_handles;
       };
    """
    def __init__(self, unpack):
        self.set_attr("flavor", nfs_secflavor4(unpack))
        if self.flavor == const.AUTH_SYS:
            self.set_attr("sys_cred", authsys_parms(unpack), switch=True)
        elif self.flavor == const.RPCSEC_GSS:
            self.set_attr("gss_handles", gss_cb_handles4(unpack), switch=True)

class BACKCHANNEL_CTL4args(BaseObj):
    """
       struct BACKCHANNEL_CTL4args {
           uint32_t            cb_program;
           callback_sec_parms4 sec_parms<>;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("cb_program", "sec_parms")

    def __init__(self, unpack):
        self.cb_program = uint32_t(unpack)
        self.sec_parms  = unpack.unpack_array(callback_sec_parms4)

class BACKCHANNEL_CTL4res(BaseObj):
    """
       struct BACKCHANNEL_CTL4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# BIND_CONN_TO_SESSION: Associate Connection with Session
# ======================================================================
class channel_dir_from_client4(Enum):
    """enum channel_dir_from_client4"""
    _enumdict = const.channel_dir_from_client4

class BIND_CONN_TO_SESSION4args(BaseObj):
    """
       struct BIND_CONN_TO_SESSION4args {
           sessionid4               sessionid;
           channel_dir_from_client4 dir;
           bool                     rdma_mode;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("sessionid", "dir", "rdma_mode")

    def __init__(self, unpack):
        self.sessionid = sessionid4(unpack)
        self.dir       = channel_dir_from_client4(unpack)
        self.rdma_mode = nfs_bool(unpack)

class channel_dir_from_server4(Enum):
    """enum channel_dir_from_server4"""
    _enumdict = const.channel_dir_from_server4

class BIND_CONN_TO_SESSION4resok(BaseObj):
    """
       struct BIND_CONN_TO_SESSION4resok {
           sessionid4               sessionid;
           channel_dir_from_server4 dir;
           bool                     rdma_mode;
       };
    """
    # Class attributes
    _attrlist = ("sessionid", "dir", "rdma_mode")

    def __init__(self, unpack):
        self.sessionid = sessionid4(unpack)
        self.dir       = channel_dir_from_server4(unpack)
        self.rdma_mode = nfs_bool(unpack)

class BIND_CONN_TO_SESSION4res(BaseObj):
    """
       union switch BIND_CONN_TO_SESSION4res (nfsstat4 status) {
           case const.NFS4_OK:
               BIND_CONN_TO_SESSION4resok resok;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", BIND_CONN_TO_SESSION4resok(unpack), switch=True)

class client_owner4(BaseObj):
    """
       struct client_owner4 {
           verifier4 verifier;
           opaque    ownerid<NFS4_OPAQUE_LIMIT>;
       };
    """
    # Class attributes
    _attrlist = ("verifier", "ownerid")

    def __init__(self, unpack):
        self.verifier = verifier4(unpack)
        self.ownerid  = unpack.unpack_opaque(const.NFS4_OPAQUE_LIMIT)

class state_protect_ops4(BaseObj):
    """
       struct state_protect_ops4 {
           bitmap4 enforce;
           bitmap4 allow;
       };
    """
    # Class attributes
    _attrlist = ("enforce", "allow")

    def __init__(self, unpack):
        self.enforce = bitmap4(unpack)
        self.allow   = bitmap4(unpack)

class ssv_sp_parms4(BaseObj):
    """
       struct ssv_sp_parms4 {
           state_protect_ops4 ops;
           sec_oid4           hash_algs<>;
           sec_oid4           encr_algs<>;
           uint32_t           window;
           uint32_t           num_gss_handles;
       };
    """
    # Class attributes
    _attrlist = ("ops", "hash_algs", "encr_algs", "window", "num_gss_handles")

    def __init__(self, unpack):
        self.ops             = state_protect_ops4(unpack)
        self.hash_algs       = unpack.unpack_array(sec_oid4)
        self.encr_algs       = unpack.unpack_array(sec_oid4)
        self.window          = uint32_t(unpack)
        self.num_gss_handles = uint32_t(unpack)

class state_protect_how4(Enum):
    """enum state_protect_how4"""
    _enumdict = const.state_protect_how4

class state_protect4_a(BaseObj):
    """
       union switch state_protect4_a (state_protect_how4 how) {
           case const.SP4_NONE:
               void;
           case const.SP4_MACH_CRED:
               state_protect_ops4 mach_ops;
           case const.SP4_SSV:
               ssv_sp_parms4 ssv_parms;
       };
    """
    # Class attributes
    _strfmt1 = "{0}"

    def __init__(self, unpack):
        self.set_attr("how", state_protect_how4(unpack))
        if self.how == const.SP4_MACH_CRED:
            self.set_attr("mach_ops", state_protect_ops4(unpack), switch=True)
        elif self.how == const.SP4_SSV:
            self.set_attr("ssv_parms", ssv_sp_parms4(unpack), switch=True)

class nfs_impl_id4(BaseObj):
    """
       struct nfs_impl_id4 {
           utf8str_cis domain;
           utf8str_cs  name;
           nfstime4    date;
       };
    """
    # Class attributes
    _attrlist = ("domain", "name", "date")

    def __init__(self, unpack):
        self.domain = utf8str_cis(unpack)
        self.name   = utf8str_cs(unpack)
        self.date   = nfstime4(unpack)

class EXCHANGE_ID4args(BaseObj):
    """
       struct EXCHANGE_ID4args {
           client_owner4    clientowner;
           uint32_t         flags;
           state_protect4_a state_protect;
           nfs_impl_id4     client_impl_id<1>;
       };
    """
    # Class attributes
    _strfmt1  = "flags:{1:#010x} {2}"
    _attrlist = ("clientowner", "flags", "state_protect", "client_impl_id")

    def __init__(self, unpack):
        self.clientowner    = client_owner4(unpack)
        self.flags          = uint32_t(unpack)
        self.state_protect  = state_protect4_a(unpack)
        self.client_impl_id = unpack.unpack_conditional(nfs_impl_id4)

class ssv_prot_info4(BaseObj):
    """
       struct ssv_prot_info4 {
           state_protect_ops4 ops;
           uint32_t           hash_alg;
           uint32_t           encr_alg;
           uint32_t           ssv_len;
           uint32_t           window;
           gsshandle4_t       handles<>;
       };
    """
    # Class attributes
    _attrlist = ("ops", "hash_alg", "encr_alg", "ssv_len", "window", "handles")

    def __init__(self, unpack):
        self.ops      = state_protect_ops4(unpack)
        self.hash_alg = uint32_t(unpack)
        self.encr_alg = uint32_t(unpack)
        self.ssv_len  = uint32_t(unpack)
        self.window   = uint32_t(unpack)
        self.handles  = unpack.unpack_array(gsshandle4_t)

class state_protect4_r(BaseObj):
    """
       union switch state_protect4_r (state_protect_how4 how) {
           case const.SP4_NONE:
               void;
           case const.SP4_MACH_CRED:
               state_protect_ops4 mach_ops;
           case const.SP4_SSV:
               ssv_prot_info4 ssv_info;
       };
    """
    # Class attributes
    _strfmt1 = "{0}"

    def __init__(self, unpack):
        self.set_attr("how", state_protect_how4(unpack))
        if self.how == const.SP4_MACH_CRED:
            self.set_attr("mach_ops", state_protect_ops4(unpack), switch=True)
        elif self.how == const.SP4_SSV:
            self.set_attr("ssv_info", ssv_prot_info4(unpack), switch=True)

# NFSv4.1 server Owner
class server_owner4(BaseObj):
    """
       struct server_owner4 {
           uint64_t minor_id;
           opaque   major_id<NFS4_OPAQUE_LIMIT>;
       };
    """
    # Class attributes
    _attrlist = ("minor_id", "major_id")

    def __init__(self, unpack):
        self.minor_id = uint64_t(unpack)
        self.major_id = unpack.unpack_opaque(const.NFS4_OPAQUE_LIMIT)

class EXCHANGE_ID4resok(BaseObj):
    """
       struct EXCHANGE_ID4resok {
           clientid4        clientid;
           sequenceid4      sequenceid;
           uint32_t         flags;
           state_protect4_r state_protect;
           server_owner4    server_owner;
           opaque           server_scope<NFS4_OPAQUE_LIMIT>;
           nfs_impl_id4     server_impl_id<1>;
       };
    """
    # Class attributes
    _strfmt1  = "clientid:{0} seqid:{1} flags:{2:#010x} {3}"
    _attrlist = ("clientid", "sequenceid", "flags", "state_protect",
                 "server_owner", "server_scope", "server_impl_id")

    def __init__(self, unpack):
        self.clientid       = clientid4(unpack)
        self.sequenceid     = sequenceid4(unpack)
        self.flags          = uint32_t(unpack)
        self.state_protect  = state_protect4_r(unpack)
        self.server_owner   = server_owner4(unpack)
        self.server_scope   = unpack.unpack_opaque(const.NFS4_OPAQUE_LIMIT)
        self.server_impl_id = unpack.unpack_conditional(nfs_impl_id4)

class EXCHANGE_ID4res(BaseObj):
    """
       union switch EXCHANGE_ID4res (nfsstat4 status) {
           case const.NFS4_OK:
               EXCHANGE_ID4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", EXCHANGE_ID4resok(unpack), switch=True)

# CREATE_SESSION: Create New Session and Confirm Client ID
# ======================================================================
class channel_attrs4(BaseObj):
    """
       struct channel_attrs4 {
           count4   headerpadsize;
           count4   maxrequestsize;
           count4   maxresponsesize;
           count4   maxresponsesize_cached;
           count4   maxoperations;
           count4   maxrequests;
           uint32_t rdma_ird<1>;
       };
    """
    # Class attributes
    _attrlist = ("headerpadsize", "maxrequestsize", "maxresponsesize",
                 "maxresponsesize_cached", "maxoperations", "maxrequests",
                 "rdma_ird")

    def __init__(self, unpack):
        self.headerpadsize          = count4(unpack)
        self.maxrequestsize         = count4(unpack)
        self.maxresponsesize        = count4(unpack)
        self.maxresponsesize_cached = count4(unpack)
        self.maxoperations          = count4(unpack)
        self.maxrequests            = count4(unpack)
        self.rdma_ird               = unpack.unpack_conditional(uint32_t)

class CREATE_SESSION4args(BaseObj):
    """
       struct CREATE_SESSION4args {
           clientid4           clientid;
           sequenceid4         sequenceid;
           uint32_t            flags;
           channel_attrs4      fore_chan_attrs;
           channel_attrs4      back_chan_attrs;
           uint32_t            cb_program;
           callback_sec_parms4 sec_parms<>;
       };
    """
    # Class attributes
    _strfmt1  = "clientid:{0} seqid:{1} cb_prog:{5:#010x}"
    _attrlist = ("clientid", "sequenceid", "flags", "fore_chan_attrs",
                 "back_chan_attrs", "cb_program", "sec_parms")

    def __init__(self, unpack):
        self.clientid        = clientid4(unpack)
        self.sequenceid      = sequenceid4(unpack)
        self.flags           = uint32_t(unpack)
        self.fore_chan_attrs = channel_attrs4(unpack)
        self.back_chan_attrs = channel_attrs4(unpack)
        self.cb_program      = uint32_t(unpack)
        self.sec_parms       = unpack.unpack_array(callback_sec_parms4)

class CREATE_SESSION4resok(BaseObj):
    """
       struct CREATE_SESSION4resok {
           sessionid4     sessionid;
           sequenceid4    sequenceid;
           uint32_t       flags;
           channel_attrs4 fore_chan_attrs;
           channel_attrs4 back_chan_attrs;
       };
    """
    # Class attributes
    _strfmt1  = "sessionid:{0:crc32} seqid:{1}"
    _attrlist = ("sessionid", "sequenceid", "flags", "fore_chan_attrs",
                 "back_chan_attrs")

    def __init__(self, unpack):
        self.sessionid       = sessionid4(unpack)
        self.sequenceid      = sequenceid4(unpack)
        self.flags           = uint32_t(unpack)
        self.fore_chan_attrs = channel_attrs4(unpack)
        self.back_chan_attrs = channel_attrs4(unpack)

class CREATE_SESSION4res(BaseObj):
    """
       union switch CREATE_SESSION4res (nfsstat4 status) {
           case const.NFS4_OK:
               CREATE_SESSION4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", CREATE_SESSION4resok(unpack), switch=True)

# DESTROY_SESSION: Destroy a Session
# ======================================================================
class DESTROY_SESSION4args(BaseObj):
    """
       struct DESTROY_SESSION4args {
           sessionid4 sessionid;
       };
    """
    # Class attributes
    _strfmt1  = "sessionid:{0:crc32}"
    _attrlist = ("sessionid",)

    def __init__(self, unpack):
        self.sessionid = sessionid4(unpack)

class DESTROY_SESSION4res(BaseObj):
    """
       struct DESTROY_SESSION4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# FREE_STATEID: Free Stateid with No Locks
# ======================================================================
class FREE_STATEID4args(BaseObj):
    """
       struct FREE_STATEID4args {
           stateid4 stateid;
       };
    """
    # Class attributes
    _strfmt1  = "stid:{0}"
    _attrlist = ("stateid",)

    def __init__(self, unpack):
        self.stateid = stateid4(unpack)

class FREE_STATEID4res(BaseObj):
    """
       struct FREE_STATEID4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# GET_DIR_DELEGATION: Get a Directory Delegation
# ======================================================================
attr_notice4 = nfstime4

class GET_DIR_DELEGATION4args(BaseObj):
    """
       struct GET_DIR_DELEGATION4args {
           /* CURRENT_FH: delegated directory */
           bool         deleg_avail;
           bitmap4      notification;
           attr_notice4 child_attr_delay;
           attr_notice4 attr_delay;
           bitmap4      child_attributes;
           bitmap4      attributes;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("deleg_avail", "notification", "child_attr_delay",
                 "attr_delay", "child_attributes", "attributes")

    def __init__(self, unpack):
        self.deleg_avail      = nfs_bool(unpack)
        self.notification     = bitmap4(unpack)
        self.child_attr_delay = attr_notice4(unpack)
        self.attr_delay       = attr_notice4(unpack)
        self.child_attributes = bitmap4(unpack)
        self.attributes       = bitmap4(unpack)
        self.fh               = self.nfs4_fh

class GET_DIR_DELEGATION4resok(BaseObj):
    """
       struct GET_DIR_DELEGATION4resok {
           verifier4 verifier;
           /* Stateid for get_dir_delegation */
           stateid4  stateid;
           /* Which notifications can the server support */
           bitmap4   notification;
           bitmap4   child_attributes;
           bitmap4   attributes;
       };
    """
    # Class attributes
    _attrlist = ("verifier", "stateid", "notification", "child_attributes",
                 "attributes")

    def __init__(self, unpack):
        self.verifier         = verifier4(unpack)
        self.stateid          = stateid4(unpack)
        self.notification     = bitmap4(unpack)
        self.child_attributes = bitmap4(unpack)
        self.attributes       = bitmap4(unpack)

class gddrnf4_status(Enum):
    """enum gddrnf4_status"""
    _enumdict = const.gddrnf4_status

class GET_DIR_DELEGATION4res_non_fatal(BaseObj):
    """
       union switch GET_DIR_DELEGATION4res_non_fatal (gddrnf4_status status) {
           case const.GDD4_OK:
               GET_DIR_DELEGATION4resok resok;
           case const.GDD4_UNAVAIL:
               bool signal;
       };
    """
    def __init__(self, unpack):
        self.set_attr("status", gddrnf4_status(unpack))
        if self.status == const.GDD4_OK:
            self.set_attr("resok", GET_DIR_DELEGATION4resok(unpack), switch=True)
        elif self.status == const.GDD4_UNAVAIL:
            self.set_attr("signal", nfs_bool(unpack), switch=True)

class GET_DIR_DELEGATION4res(BaseObj):
    """
       union switch GET_DIR_DELEGATION4res (nfsstat4 status) {
           case const.NFS4_OK:
               GET_DIR_DELEGATION4res_non_fatal resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", GET_DIR_DELEGATION4res_non_fatal(unpack), switch=True)

# GETDEVICEINFO: Get Device Information
# ======================================================================
class GETDEVICEINFO4args(BaseObj):
    """
       struct GETDEVICEINFO4args {
           deviceid4   deviceid;
           layouttype4 type;
           count4      maxcount;
           bitmap4     notification;
       };
    """
    # Class attributes
    _strfmt1  = "devid:{0:crc16} count:{2:umax32}"
    _attrlist = ("deviceid", "type", "maxcount", "notification")

    def __init__(self, unpack):
        self.deviceid     = deviceid4(unpack)
        self.type         = layouttype4(unpack)
        self.maxcount     = count4(unpack)
        self.notification = bitmap4(unpack)

class GETDEVICEINFO4resok(BaseObj):
    """
       struct GETDEVICEINFO4resok {
           device_addr4 device_addr;
           bitmap4      notification;
       };
    """
    # Class attributes
    _strfmt1  = "{0}"
    _attrlist = ("device_addr", "notification")

    def __init__(self, unpack):
        self.device_addr  = device_addr4(unpack)
        self.notification = bitmap4(unpack)

class GETDEVICEINFO4res(BaseObj):
    """
       union switch GETDEVICEINFO4res (nfsstat4 status) {
           case const.NFS4_OK:
               GETDEVICEINFO4resok resok;
           case const.NFS4ERR_TOOSMALL:
               count4 mincount;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", GETDEVICEINFO4resok(unpack), switch=True)
        elif self.status == const.NFS4ERR_TOOSMALL:
            self.set_attr("mincount", count4(unpack), switch=True)
            self.set_strfmt(1, "count:{1:umax32}")

# GETDEVICELIST: Get All Device Mappings for a File System
# ======================================================================
# Obsolete in NFSv4.2
class GETDEVICELIST4args(BaseObj):
    """
       struct GETDEVICELIST4args {
           /* CURRENT_FH: object belonging to the file system */
           layouttype4 type;
           /* number of deviceIDs to return */
           count4      maxdevices;
           nfs_cookie4 cookie;
           verifier4   verifier;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("type", "maxdevices", "cookie", "verifier")

    def __init__(self, unpack):
        self.type       = layouttype4(unpack)
        self.maxdevices = count4(unpack)
        self.cookie     = nfs_cookie4(unpack)
        self.verifier   = verifier4(unpack)
        self.fh         = self.nfs4_fh

class GETDEVICELIST4resok(BaseObj):
    """
       struct GETDEVICELIST4resok {
           nfs_cookie4 cookie;
           verifier4   verifier;
           deviceid4   deviceid_list<>;
           bool        eof;
       };
    """
    # Class attributes
    _attrlist = ("cookie", "verifier", "deviceid_list", "eof")

    def __init__(self, unpack):
        self.cookie        = nfs_cookie4(unpack)
        self.verifier      = verifier4(unpack)
        self.deviceid_list = unpack.unpack_array(deviceid4)
        self.eof           = nfs_bool(unpack)

class GETDEVICELIST4res(BaseObj):
    """
       union switch GETDEVICELIST4res (nfsstat4 status) {
           case const.NFS4_OK:
               GETDEVICELIST4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", GETDEVICELIST4resok(unpack), switch=True)

# LAYOUTCOMMIT: Commit Writes Made Using a Layout
# ======================================================================
class newtime4(BaseObj):
    """
       union switch newtime4 (bool timechanged) {
           case const.TRUE:
               nfstime4 time;
           case const.FALSE:
               void;
       };
    """
    def __init__(self, unpack):
        self.set_attr("timechanged", nfs_bool(unpack))
        if self.timechanged == const.TRUE:
            self.set_attr("time", nfstime4(unpack), switch=True)

class newoffset4(BaseObj):
    """
       union switch newoffset4 (bool newoffset) {
           case const.TRUE:
               offset4 offset;
           case const.FALSE:
               void;
       };
    """
    def __init__(self, unpack):
        self.set_attr("newoffset", nfs_bool(unpack))
        if self.newoffset == const.TRUE:
            self.set_attr("offset", offset4(unpack), switch=True)

class LAYOUTCOMMIT4args(BaseObj):
    """
       struct LAYOUTCOMMIT4args {
           /* CURRENT_FH: file */
           offset4       offset;
           length4       length;
           bool          reclaim;
           stateid4      stateid;
           newoffset4    last_write_offset;
           newtime4      time_modify;
           layoutupdate4 layoutupdate;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} off:{0:umax64} len:{1:umax64} stid:{3}"
    _attrlist = ("offset", "length", "reclaim", "stateid", "last_write_offset",
                 "time_modify", "layoutupdate")

    def __init__(self, unpack):
        self.offset            = offset4(unpack)
        self.length            = length4(unpack)
        self.reclaim           = nfs_bool(unpack)
        self.stateid           = stateid4(unpack)
        self.last_write_offset = newoffset4(unpack)
        self.time_modify       = newtime4(unpack)
        self.layoutupdate      = layoutupdate4(unpack)
        self.fh                = self.nfs4_fh

class newsize4(BaseObj):
    """
       union switch newsize4 (bool sizechanged) {
           case const.TRUE:
               length4 size;
           case const.FALSE:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "size:{1:umax64}"

    def __init__(self, unpack):
        self.set_attr("sizechanged", nfs_bool(unpack))
        if self.sizechanged == const.TRUE:
            self.set_attr("size", length4(unpack), switch=True)
        elif self.sizechanged == const.FALSE:
            self.set_strfmt(1, "")

class LAYOUTCOMMIT4resok(BaseObj):
    """
       struct LAYOUTCOMMIT4resok {
           newsize4 newsize;
       };
    """
    # Class attributes
    _strfmt1  = "{0}"
    _attrlist = ("newsize",)

    def __init__(self, unpack):
        self.newsize = newsize4(unpack)

class LAYOUTCOMMIT4res(BaseObj):
    """
       union switch LAYOUTCOMMIT4res (nfsstat4 status) {
           case const.NFS4_OK:
               LAYOUTCOMMIT4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", LAYOUTCOMMIT4resok(unpack), switch=True)

# LAYOUTGET: Get Layout Information
# ======================================================================
class LAYOUTGET4args(BaseObj):
    """
       struct LAYOUTGET4args {
           /* CURRENT_FH: file */
           bool          avail;
           layouttype4   type;
           layoutiomode4 iomode;
           offset4       offset;
           length4       length;
           length4       minlength;
           stateid4      stateid;
           count4        maxcount;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} {2:@14} off:{3:umax64} len:{4:umax64} stid:{6}"
    _attrlist = ("avail", "type", "iomode", "offset", "length", "minlength",
                 "stateid", "maxcount")

    def __init__(self, unpack):
        self.avail     = nfs_bool(unpack)
        self.type      = layouttype4(unpack)
        self.iomode    = layoutiomode4(unpack)
        self.offset    = offset4(unpack)
        self.length    = length4(unpack)
        self.minlength = length4(unpack)
        self.stateid   = stateid4(unpack)
        self.maxcount  = count4(unpack)
        self.fh        = self.nfs4_fh

class LAYOUTGET4resok(BaseObj):
    """
       struct LAYOUTGET4resok {
           bool     return_on_close;
           stateid4 stateid;
           layout4  layout<>;
       };
    """
    # Class attributes
    _strfmt1  = "stid:{1} layout:{2}"
    _attrlist = ("return_on_close", "stateid", "layout")

    def __init__(self, unpack):
        self.return_on_close = nfs_bool(unpack)
        self.stateid         = stateid4(unpack)
        self.layout          = unpack.unpack_array(layout4)

class LAYOUTGET4res(BaseObj):
    """
       union switch LAYOUTGET4res (nfsstat4 status) {
           case const.NFS4_OK:
               LAYOUTGET4resok resok;
           case const.NFS4ERR_LAYOUTTRYLATER:
               /* Server will signal layout availability */
               bool signal;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", LAYOUTGET4resok(unpack), switch=True)
        elif self.status == const.NFS4ERR_LAYOUTTRYLATER:
            self.set_attr("signal", nfs_bool(unpack), switch=True)
            self.set_strfmt(1, "signal:{1}")

# LAYOUTRETURN: Release Layout Information
# ======================================================================
class LAYOUTRETURN4args(BaseObj):
    """
       struct LAYOUTRETURN4args {
           /* CURRENT_FH: file */
           bool          reclaim;
           layouttype4   type;
           layoutiomode4 iomode;
           layoutreturn4 layoutreturn;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} {2:@14} {3}"
    _attrlist = ("reclaim", "type", "iomode", "layoutreturn")

    def __init__(self, unpack):
        self.reclaim      = nfs_bool(unpack)
        self.type         = layouttype4(unpack)
        self.set_global("nfs4_layouttype", self.type)
        self.iomode       = layoutiomode4(unpack)
        self.layoutreturn = layoutreturn4(unpack)
        self.fh           = self.nfs4_fh

class layoutreturn_stateid(BaseObj):
    """
       union switch layoutreturn_stateid (bool present) {
           case const.TRUE:
               stateid4 stateid;
           case const.FALSE:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "stid:{1}"

    def __init__(self, unpack):
        self.set_attr("present", nfs_bool(unpack))
        if self.present == const.TRUE:
            self.set_attr("stateid", stateid4(unpack), switch=True)
        elif self.present == const.FALSE:
            self.set_strfmt(1, "")

class LAYOUTRETURN4res(BaseObj):
    """
       union switch LAYOUTRETURN4res (nfsstat4 status) {
           case const.NFS4_OK:
               layoutreturn_stateid stateid;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("stateid", layoutreturn_stateid(unpack), switch=True)

# SECINFO_NO_NAME: Get Security on Unnamed Object
# ======================================================================
class secinfo_style4(Enum):
    """enum secinfo_style4"""
    _enumdict = const.secinfo_style4

# Original definition
# typedef secinfo_style4 SECINFO_NO_NAME4args;
class SECINFO_NO_NAME4args(BaseObj):
    """
       struct SECINFO_NO_NAME4args {
           /* CURRENT_FH: object or child directory */
           secinfo_style4 style;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} {0}"
    _attrlist = ("style",)

    def __init__(self, unpack):
        self.style = secinfo_style4(unpack)
        self.fh    = self.nfs4_fh

# CURRENTFH: consumed if status is NFS4_OK
SECINFO_NO_NAME4res = SECINFO4res

# SEQUENCE: Supply Per-Procedure Sequencing and Control
# ======================================================================
class SEQUENCE4args(BaseObj):
    """
       struct SEQUENCE4args {
           sessionid4  sessionid;
           sequenceid4 sequenceid;
           slotid4     slotid;
           slotid4     highest_slotid;
           bool        cachethis;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("sessionid", "sequenceid", "slotid", "highest_slotid",
                 "cachethis")

    def __init__(self, unpack):
        self.sessionid      = sessionid4(unpack)
        self.sequenceid     = sequenceid4(unpack)
        self.slotid         = slotid4(unpack)
        self.highest_slotid = slotid4(unpack)
        self.cachethis      = nfs_bool(unpack)

class SEQUENCE4resok(BaseObj):
    """
       struct SEQUENCE4resok {
           sessionid4  sessionid;
           sequenceid4 sequenceid;
           slotid4     slotid;
           slotid4     highest_slotid;
           slotid4     target_highest_slotid;
           uint32_t    status_flags;
       };
    """
    # Class attributes
    _attrlist = ("sessionid", "sequenceid", "slotid", "highest_slotid",
                 "target_highest_slotid", "status_flags")

    def __init__(self, unpack):
        self.sessionid             = sessionid4(unpack)
        self.sequenceid            = sequenceid4(unpack)
        self.slotid                = slotid4(unpack)
        self.highest_slotid        = slotid4(unpack)
        self.target_highest_slotid = slotid4(unpack)
        self.status_flags          = uint32_t(unpack)

class SEQUENCE4res(BaseObj):
    """
       union switch SEQUENCE4res (nfsstat4 status) {
           case const.NFS4_OK:
               SEQUENCE4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", SEQUENCE4resok(unpack), switch=True)

# SET_SSV: Update SSV for a Client ID
# ======================================================================
class ssa_digest_input4(BaseObj):
    """
       struct ssa_digest_input4 {
           SEQUENCE4args seqargs;
       };
    """
    # Class attributes
    _attrlist = ("seqargs",)

    def __init__(self, unpack):
        self.seqargs = SEQUENCE4args(unpack)

class SET_SSV4args(BaseObj):
    """
       struct SET_SSV4args {
           opaque ssv<>;
           opaque digest<>;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("ssv", "digest")

    def __init__(self, unpack):
        self.ssv    = unpack.unpack_opaque()
        self.digest = unpack.unpack_opaque()

class ssr_digest_input4(BaseObj):
    """
       struct ssr_digest_input4 {
           SEQUENCE4res seqres;
       };
    """
    # Class attributes
    _attrlist = ("seqres",)

    def __init__(self, unpack):
        self.seqres = SEQUENCE4res(unpack)

class SET_SSV4resok(BaseObj):
    """
       struct SET_SSV4resok {
           opaque digest<>;
       };
    """
    # Class attributes
    _attrlist = ("digest",)

    def __init__(self, unpack):
        self.digest = unpack.unpack_opaque()

class SET_SSV4res(BaseObj):
    """
       union switch SET_SSV4res (nfsstat4 status) {
           case const.NFS4_OK:
               SET_SSV4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", SET_SSV4resok(unpack), switch=True)

# TEST_STATEID: Test Stateids for Validity
# ======================================================================
class TEST_STATEID4args(BaseObj):
    """
       struct TEST_STATEID4args {
           stateid4 stateids<>;
       };
    """
    # Class attributes
    _strfmt1  = "stids:{0}"
    _attrlist = ("stateids",)

    def __init__(self, unpack):
        self.stateids = unpack.unpack_array(stateid4)

class TEST_STATEID4resok(BaseObj):
    """
       struct TEST_STATEID4resok {
           nfsstat4 status_codes<>;
       };
    """
    # Class attributes
    _strfmt1  = "status:{0}"
    _attrlist = ("status_codes",)

    def __init__(self, unpack):
        self.status_codes = unpack.unpack_array(nfsstat4)

class TEST_STATEID4res(BaseObj):
    """
       union switch TEST_STATEID4res (nfsstat4 status) {
           case const.NFS4_OK:
               TEST_STATEID4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", TEST_STATEID4resok(unpack), switch=True)

# WANT_DELEGATION: Request Delegation
# ======================================================================
class deleg_claim4(BaseObj):
    """
       union switch deleg_claim4 (open_claim_type4 claim) {
           /*
            * No special rights to object. Ordinary delegation
            * request of the specified object. Object identified
            * by filehandle.
            */
           case const.CLAIM_FH:
               void;
           /*
            * Right to file based on a delegation granted
            * to a previous boot instance of the client.
            * File is specified by filehandle.
            */
           case const.CLAIM_DELEG_PREV_FH:
               /* CURRENT_FH: object being delegated */
               void;
           /*
            * Right to the file established by an open previous
            * to server reboot.  File identified by filehandle.
            * Used during server reclaim grace period.
            */
           case const.CLAIM_PREVIOUS:
               /* CURRENT_FH: object being reclaimed */
               open_delegation_type4 deleg_type;
       };
    """
    # Class attributes
    _strfmt1 = "{0}:{fh:crc32}"

    def __init__(self, unpack):
        self.set_attr("claim", open_claim_type4(unpack))
        if self.claim == const.CLAIM_PREVIOUS:
            self.set_attr("deleg_type", open_delegation_type4(unpack), switch=True)
            self.set_strfmt(1, "{0}:{fh:crc32} {1}")
        self.fh = self.nfs4_fh

class WANT_DELEGATION4args(BaseObj):
    """
       struct WANT_DELEGATION4args {
           uint32_t     want;
           deleg_claim4 claim;
       };
    """
    # Class attributes
    _strfmt1  = "want:{0:#x} {1}"
    _attrlist = ("want", "claim")

    def __init__(self, unpack):
        self.want  = uint32_t(unpack)
        self.claim = deleg_claim4(unpack)

class WANT_DELEGATION4res(BaseObj):
    """
       union switch WANT_DELEGATION4res (nfsstat4 status) {
           case const.NFS4_OK:
               open_delegation4 resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", open_delegation4(unpack), switch=True)

# DESTROY_CLIENTID: Destroy a Client ID
# ======================================================================
class DESTROY_CLIENTID4args(BaseObj):
    """
       struct DESTROY_CLIENTID4args {
           clientid4 clientid;
       };
    """
    # Class attributes
    _strfmt1  = "clientid:{0}"
    _attrlist = ("clientid",)

    def __init__(self, unpack):
        self.clientid = clientid4(unpack)

class DESTROY_CLIENTID4res(BaseObj):
    """
       struct DESTROY_CLIENTID4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# RECLAIM_COMPLETE: Indicates Reclaims Finished
# ======================================================================
#
# Original definition
# struct RECLAIM_COMPLETE4args {
#     bool  one_fs;
# };
class RECLAIM_COMPLETE4args(BaseObj):
    """
       union switch RECLAIM_COMPLETE4args (bool one_fs) {
           case const.TRUE:
               /*
                * If one_fs TRUE,
                *    CURRENT_FH: object in filesystem reclaim is complete for.
                */
               void;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("one_fs", nfs_bool(unpack))
        if self.one_fs == const.TRUE:
            self.fh = self.nfs4_fh
            self.set_strfmt(1, "FH:{fh:crc32}")

class RECLAIM_COMPLETE4res(BaseObj):
    """
       struct RECLAIM_COMPLETE4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# ======================================================================
# Operations new to NFSv4.2
# ======================================================================
#
# ALLOCATE: Reserve Space in A Region of a File
# ======================================================================
class ALLOCATE4args(BaseObj):
    """
       struct ALLOCATE4args {
           /* CURRENT_FH: file */
           stateid4 stateid;
           offset4  offset;
           length4  length;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} stid:{0} off:{1:umax64} len:{2:umax64}"
    _attrlist = ("stateid", "offset", "length")

    def __init__(self, unpack):
        self.stateid = stateid4(unpack)
        self.offset  = offset4(unpack)
        self.length  = length4(unpack)
        self.fh      = self.nfs4_fh

class ALLOCATE4res(BaseObj):
    """
       struct ALLOCATE4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# COPY: Initiate a server-side copy
# ======================================================================
class COPY4args(BaseObj):
    """
       struct COPY4args {
           /*
            * SAVED_FH: source file
            * CURRENT_FH: destination file
            */
           stateid4 src_stateid;
           stateid4 dst_stateid;
           offset4  src_offset;
           offset4  dst_offset;
           length4  count;
           bool     consecutive;
           bool     synchronous;
           netloc4  src_servers<>;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} src:(stid:{0} off:{2:umax64}) dst:(stid:{1} off:{3:umax64}) len:{4:umax64}"
    _attrlist = ("src_stateid", "dst_stateid", "src_offset", "dst_offset",
                 "count", "consecutive", "synchronous", "src_servers")

    def __init__(self, unpack):
        self.src_stateid = stateid4(unpack)
        self.dst_stateid = stateid4(unpack)
        self.src_offset  = offset4(unpack)
        self.dst_offset  = offset4(unpack)
        self.count       = length4(unpack)
        self.consecutive = nfs_bool(unpack)
        self.synchronous = nfs_bool(unpack)
        self.src_servers = unpack.unpack_array(netloc4)
        self.fh          = self.nfs4_fh
        self.sfh         = self.nfs4_sfh

class write_response4(BaseObj):
    """
       struct write_response4 {
           stateid4    callback_id<1>;
           length4     count;
           stable_how4 committed;
           verifier4   verifier;
       };
    """
    # Class attributes
    _strfmt1  = "stid:{0} len:{1:umax64} verf:{3} {2}"
    _attrlist = ("callback_id", "count", "committed", "verifier")

    def __init__(self, unpack):
        self.callback_id = unpack.unpack_conditional(stateid4)
        self.count       = length4(unpack)
        self.committed   = stable_how4(unpack)
        self.verifier    = verifier4(unpack)

class copy_requirements4(BaseObj):
    """
       struct copy_requirements4 {
           bool consecutive;
           bool synchronous;
       };
    """
    # Class attributes
    _strfmt1  = "cons:{2} sync:{3}"
    _attrlist = ("consecutive", "synchronous")

    def __init__(self, unpack):
        self.consecutive = nfs_bool(unpack)
        self.synchronous = nfs_bool(unpack)

class COPY4resok(BaseObj):
    """
       struct COPY4resok {
           write_response4    response;
           copy_requirements4 requirements;
       };
    """
    # Class attributes
    _strfmt1  = "{0} {1}"
    _attrlist = ("response", "requirements")

    def __init__(self, unpack):
        self.response     = write_response4(unpack)
        self.requirements = copy_requirements4(unpack)

class COPY4res(BaseObj):
    """
       union switch COPY4res (nfsstat4 status) {
           case const.NFS4_OK:
               COPY4resok resok;
           case const.NFS4ERR_OFFLOAD_NO_REQS:
               copy_requirements4 requirements;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", COPY4resok(unpack), switch=True)
        elif self.status == const.NFS4ERR_OFFLOAD_NO_REQS:
            self.set_attr("requirements", copy_requirements4(unpack), switch=True)

# COPY_NOTIFY: Notify a Source Server of a Future Copy
# ======================================================================
class COPY_NOTIFY4args(BaseObj):
    """
       struct COPY_NOTIFY4args {
           /* CURRENT_FH: source file */
           stateid4 stateid;
           netloc4  dst_server;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} stid:{0} {1}"
    _attrlist = ("stateid", "dst_server")

    def __init__(self, unpack):
        self.stateid    = stateid4(unpack)
        self.dst_server = netloc4(unpack)
        self.fh         = self.nfs4_fh

class COPY_NOTIFY4resok(BaseObj):
    """
       struct COPY_NOTIFY4resok {
           nfstime4 lease_time;
           stateid4 stateid;
           netloc4  src_servers<>;
       };
    """
    # Class attributes
    _strfmt1  = "lease:{0} stid:{1} {2}"
    _attrlist = ("lease_time", "stateid", "src_servers")

    def __init__(self, unpack):
        self.lease_time  = nfstime4(unpack)
        self.stateid     = stateid4(unpack)
        self.src_servers = unpack.unpack_array(netloc4)

class COPY_NOTIFY4res(BaseObj):
    """
       union switch COPY_NOTIFY4res (nfsstat4 status) {
           case const.NFS4_OK:
               COPY_NOTIFY4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", COPY_NOTIFY4resok(unpack), switch=True)

# DEALLOCATE: Unreserve Space in a Region of a File
# ======================================================================
class DEALLOCATE4args(BaseObj):
    """
       struct DEALLOCATE4args {
           /* CURRENT_FH: file */
           stateid4 stateid;
           offset4  offset;
           length4  length;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} stid:{0} off:{1:umax64} len:{2:umax64}"
    _attrlist = ("stateid", "offset", "length")

    def __init__(self, unpack):
        self.stateid = stateid4(unpack)
        self.offset  = offset4(unpack)
        self.length  = length4(unpack)
        self.fh      = self.nfs4_fh

class DEALLOCATE4res(BaseObj):
    """
       struct DEALLOCATE4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# IO_ADVISE: Application I/O Access Pattern Hints
# ======================================================================
class IO_ADVISE_type4(Enum):
    """enum IO_ADVISE_type4"""
    _enumdict = const.IO_ADVISE_type4

class IO_ADVISE4args(BaseObj):
    """
       struct IO_ADVISE4args {
           /* CURRENT_FH: file */
           stateid4 stateid;
           offset4  offset;
           length4  count;
           bitmap4  hints;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} stid:{0} off:{1:umax64} len:{2:umax64} hints:{3}"
    _attrlist = ("stateid", "offset", "count", "hints")

    def __init__(self, unpack):
        self.stateid = stateid4(unpack)
        self.offset  = offset4(unpack)
        self.count   = length4(unpack)
        self.hints   = bitmap4(unpack)
        self.fh      = self.nfs4_fh

class IO_ADVISE4resok(BaseObj):
    """
       struct IO_ADVISE4resok {
           bitmap4 hints;
       };
    """
    # Class attributes
    _strfmt1  = "hints:{0}"
    _attrlist = ("hints",)

    def __init__(self, unpack):
        self.hints = bitmap4(unpack)

class IO_ADVISE4res(BaseObj):
    """
       union switch IO_ADVISE4res (nfsstat4 status) {
           case const.NFS4_OK:
               IO_ADVISE4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", IO_ADVISE4resok(unpack), switch=True)

# LAYOUTERROR: Provide Errors for the Layout
# ======================================================================
class device_error4(BaseObj):
    """
       struct device_error4 {
           deviceid4  deviceid;
           nfsstat4   status;
           nfs_opnum4 opnum;
       };
    """
    # Class attributes
    _strfmt1  = "devid:{0:crc16} stat:{1} op:{2}"
    _attrlist = ("deviceid", "status", "opnum")

    def __init__(self, unpack):
        self.deviceid = deviceid4(unpack)
        self.status   = nfsstat4(unpack)
        self.opnum    = nfs_opnum4(unpack)

class LAYOUTERROR4args(BaseObj):
    """
       struct LAYOUTERROR4args {
           /* CURRENT_FH: file */
           offset4       offset;
           length4       length;
           stateid4      stateid;
           device_error4 errors<>;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} off:{0:umax64} len:{1:umax64} stid:{2} {3}"
    _attrlist = ("offset", "length", "stateid", "errors")

    def __init__(self, unpack):
        self.offset  = offset4(unpack)
        self.length  = length4(unpack)
        self.stateid = stateid4(unpack)
        self.errors  = unpack.unpack_array(device_error4)
        self.fh      = self.nfs4_fh

class LAYOUTERROR4res(BaseObj):
    """
       struct LAYOUTERROR4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# LAYOUTSTATS: Provide Statistics for the Layout
# ======================================================================
class io_info4(BaseObj):
    """
       struct io_info4 {
           uint64_t count;
           uint64_t bytes;
       };
    """
    # Class attributes
    _strfmt1  = "count:{0:umax64} bytes:{1:umax64}"
    _attrlist = ("count", "bytes")

    def __init__(self, unpack):
        self.count = uint64_t(unpack)
        self.bytes = uint64_t(unpack)

class LAYOUTSTATS4args(BaseObj):
    """
       struct LAYOUTSTATS4args {
           /* CURRENT_FH: file */
           offset4       offset;
           length4       length;
           stateid4      stateid;
           io_info4      read;
           io_info4      write;
           deviceid4     deviceid;
           layoutupdate4 layoutupdate;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} off:{0:umax64} len:{1:umax64} stid:{2}"
    _attrlist = ("offset", "length", "stateid", "read", "write", "deviceid",
                 "layoutupdate")

    def __init__(self, unpack):
        self.offset       = offset4(unpack)
        self.length       = length4(unpack)
        self.stateid      = stateid4(unpack)
        self.read         = io_info4(unpack)
        self.write        = io_info4(unpack)
        self.deviceid     = deviceid4(unpack)
        self.layoutupdate = layoutupdate4(unpack)
        self.fh           = self.nfs4_fh

class LAYOUTSTATS4res(BaseObj):
    """
       struct LAYOUTSTATS4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# OFFLOAD_CANCEL: Stop an Offloaded Operation
# ======================================================================
class OFFLOAD_CANCEL4args(BaseObj):
    """
       struct OFFLOAD_CANCEL4args {
           /* CURRENT_FH: file to cancel */
           stateid4 stateid;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} stid:{0}"
    _attrlist = ("stateid",)

    def __init__(self, unpack):
        self.stateid = stateid4(unpack)
        self.fh      = self.nfs4_fh

class OFFLOAD_CANCEL4res(BaseObj):
    """
       struct OFFLOAD_CANCEL4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# OFFLOAD_STATUS: Poll for Status of Asynchronous Operation
# ======================================================================
class OFFLOAD_STATUS4args(BaseObj):
    """
       struct OFFLOAD_STATUS4args {
           /* CURRENT_FH: destination file */
           stateid4 stateid;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} stid:{0}"
    _attrlist = ("stateid",)

    def __init__(self, unpack):
        self.stateid = stateid4(unpack)
        self.fh      = self.nfs4_fh

class OFFLOAD_STATUS4resok(BaseObj):
    """
       struct OFFLOAD_STATUS4resok {
           length4  count;
           nfsstat4 complete<1>;
       };
    """
    # Class attributes
    _strfmt1  = "len:{0:umax64} {1}"
    _attrlist = ("count", "complete")

    def __init__(self, unpack):
        self.count    = length4(unpack)
        self.complete = unpack.unpack_conditional(nfsstat4)

class OFFLOAD_STATUS4res(BaseObj):
    """
       union switch OFFLOAD_STATUS4res (nfsstat4 status) {
           case const.NFS4_OK:
               OFFLOAD_STATUS4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", OFFLOAD_STATUS4resok(unpack), switch=True)

# READ_PLUS: READ Data or Holes from a File
# ======================================================================
class READ_PLUS4args(BaseObj):
    """
       struct READ_PLUS4args {
           /* CURRENT_FH: file */
           stateid4 stateid;
           offset4  offset;
           count4   count;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} stid:{0} off:{1:umax64} len:{2:umax32}"
    _attrlist = ("stateid", "offset", "count")

    def __init__(self, unpack):
        self.stateid = stateid4(unpack)
        self.offset  = offset4(unpack)
        self.count   = count4(unpack)
        self.fh      = self.nfs4_fh

class data_content4(Enum):
    """enum data_content4"""
    _enumdict = const.data_content4

class data4(BaseObj):
    """
       struct data4 {
           offset4 offset;
           opaque  data<>;
       };
    """
    # Class attributes
    _strfmt1  = "off:{0:umax64} count:{1:umax32}"
    _attrlist = ("offset", "count", "data")

    def __init__(self, unpack):
        self.offset = offset4(unpack)
        self.count  = unpack.unpack_uint()
        self.data   = unpack.unpack_fopaque(self.count)

class data_info4(BaseObj):
    """
       struct data_info4 {
           offset4 offset;
           length4 count;
       };
    """
    # Class attributes
    _strfmt1  = "off:{0:umax64} len:{1:umax64}"
    _attrlist = ("offset", "count")

    def __init__(self, unpack):
        self.offset = offset4(unpack)
        self.count  = length4(unpack)

class read_plus_content(BaseObj):
    """
       union switch read_plus_content (data_content4 content) {
           case const.NFS4_CONTENT_DATA:
               data4 data;
           case const.NFS4_CONTENT_HOLE:
               data_info4 hole;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("content", data_content4(unpack))
        if self.content == const.NFS4_CONTENT_DATA:
            self.set_attr("data", data4(unpack), switch=True)
        elif self.content == const.NFS4_CONTENT_HOLE:
            self.set_attr("hole", data_info4(unpack), switch=True)

# Allow a return of an array of contents.
class read_plus_res4(BaseObj):
    """
       struct read_plus_res4 {
           bool              eof;
           read_plus_content contents<>;
       };
    """
    # Class attributes
    _strfmt1  = "eof:{0} {1}"
    _attrlist = ("eof", "contents")

    def __init__(self, unpack):
        self.eof      = nfs_bool(unpack)
        self.contents = unpack.unpack_array(read_plus_content)

class READ_PLUS4res(BaseObj):
    """
       union switch READ_PLUS4res (nfsstat4 status) {
           case const.NFS4_OK:
               read_plus_res4 resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", read_plus_res4(unpack), switch=True)

# SEEK: Find the Next Data or Hole
# ======================================================================
class SEEK4args(BaseObj):
    """
       struct SEEK4args {
           /* CURRENT_FH: file */
           stateid4      stateid;
           offset4       offset;
           data_content4 what;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} stid:{0} off:{1:umax64} {2}"
    _attrlist = ("stateid", "offset", "what")

    def __init__(self, unpack):
        self.stateid = stateid4(unpack)
        self.offset  = offset4(unpack)
        self.what    = data_content4(unpack)
        self.fh      = self.nfs4_fh

class seek_res4(BaseObj):
    """
       struct seek_res4 {
           bool    eof;
           offset4 offset;
       };
    """
    # Class attributes
    _strfmt1  = "eof:{0} off:{1:umax64}"
    _attrlist = ("eof", "offset")

    def __init__(self, unpack):
        self.eof    = nfs_bool(unpack)
        self.offset = offset4(unpack)

class SEEK4res(BaseObj):
    """
       union switch SEEK4res (nfsstat4 status) {
           case const.NFS4_OK:
               seek_res4 resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", seek_res4(unpack), switch=True)

# WRITE_SAME: WRITE an ADB Multiple Times to a File
# ======================================================================
class app_data_block4(BaseObj):
    """
       struct app_data_block4 {
           offset4 offset;
           length4 block_size;
           length4 block_count;
           length4 reloff_blocknum;
           count4  block_num;
           length4 reloff_pattern;
           opaque  pattern<>;
       };
    """
    # Class attributes
    _strfmt1  = "off:{0:umax64} bsize:{1:umax64} bcount:{2:umax64}"
    _attrlist = ("offset", "block_size", "block_count", "reloff_blocknum",
                 "block_num", "reloff_pattern", "pattern")

    def __init__(self, unpack):
        self.offset          = offset4(unpack)
        self.block_size      = length4(unpack)
        self.block_count     = length4(unpack)
        self.reloff_blocknum = length4(unpack)
        self.block_num       = count4(unpack)
        self.reloff_pattern  = length4(unpack)
        self.pattern         = unpack.unpack_opaque()

class WRITE_SAME4args(BaseObj):
    """
       struct WRITE_SAME4args {
           /* CURRENT_FH: file */
           stateid4        stateid;
           stable_how4     stable;
           app_data_block4 adb;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} stid:{0} {2} {1}"
    _attrlist = ("stateid", "stable", "adb")

    def __init__(self, unpack):
        self.stateid = stateid4(unpack)
        self.stable  = stable_how4(unpack)
        self.adb     = app_data_block4(unpack)
        self.fh      = self.nfs4_fh

class WRITE_SAME4res(BaseObj):
    """
       union switch WRITE_SAME4res (nfsstat4 status) {
           case const.NFS4_OK:
               write_response4 resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", write_response4(unpack), switch=True)

# CLONE: Clone a Range of File Into Another File
# ======================================================================
class CLONE4args(BaseObj):
    """
       struct CLONE4args {
           /*
            * SAVED_FH: source file
            * CURRENT_FH: destination file
            */
           stateid4 src_stateid;
           stateid4 dst_stateid;
           offset4  src_offset;
           offset4  dst_offset;
           length4  count;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{fh:crc32} src:(stid:{0} off:{2:umax64}) dst:(stid:{1} off:{3:umax64}) len:{4:umax64}"
    _attrlist = ("src_stateid", "dst_stateid", "src_offset", "dst_offset",
                 "count")

    def __init__(self, unpack):
        self.src_stateid = stateid4(unpack)
        self.dst_stateid = stateid4(unpack)
        self.src_offset  = offset4(unpack)
        self.dst_offset  = offset4(unpack)
        self.count       = length4(unpack)
        self.fh          = self.nfs4_fh
        self.sfh         = self.nfs4_sfh

class CLONE4res(BaseObj):
    """
       struct CLONE4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

class nfs_argop4(BaseObj):
    """
       union switch nfs_argop4 (nfs_opnum4 argop) {
           case const.OP_ACCESS:
               ACCESS4args opaccess;
           case const.OP_CLOSE:
               CLOSE4args opclose;
           case const.OP_COMMIT:
               COMMIT4args opcommit;
           case const.OP_CREATE:
               CREATE4args opcreate;
           case const.OP_DELEGPURGE:
               DELEGPURGE4args opdelegpurge;
           case const.OP_DELEGRETURN:
               DELEGRETURN4args opdelegreturn;
           case const.OP_GETATTR:
               GETATTR4args opgetattr;
           case const.OP_GETFH:
               void;
           case const.OP_LINK:
               LINK4args oplink;
           case const.OP_LOCK:
               LOCK4args oplock;
           case const.OP_LOCKT:
               LOCKT4args oplockt;
           case const.OP_LOCKU:
               LOCKU4args oplocku;
           case const.OP_LOOKUP:
               LOOKUP4args oplookup;
           case const.OP_LOOKUPP:
               void;
           case const.OP_NVERIFY:
               NVERIFY4args opnverify;
           case const.OP_OPEN:
               OPEN4args opopen;
           case const.OP_OPENATTR:
               OPENATTR4args opopenattr;
           case const.OP_OPEN_CONFIRM:
               /* Not used in NFSv4.1 */
               OPEN_CONFIRM4args opopen_confirm;
           case const.OP_OPEN_DOWNGRADE:
               OPEN_DOWNGRADE4args opopen_downgrade;
           case const.OP_PUTFH:
               PUTFH4args opputfh;
           case const.OP_PUTPUBFH:
               void;
           case const.OP_PUTROOTFH:
               void;
           case const.OP_READ:
               READ4args opread;
           case const.OP_READDIR:
               READDIR4args opreaddir;
           case const.OP_READLINK:
               void;
           case const.OP_REMOVE:
               REMOVE4args opremove;
           case const.OP_RENAME:
               RENAME4args oprename;
           case const.OP_RENEW:
               /* Not used in NFSv4.1 */
               RENEW4args oprenew;
           case const.OP_RESTOREFH:
               void;
           case const.OP_SAVEFH:
               void;
           case const.OP_SECINFO:
               SECINFO4args opsecinfo;
           case const.OP_SETATTR:
               SETATTR4args opsetattr;
           case const.OP_SETCLIENTID:
               /* Not used in NFSv4.1 */
               SETCLIENTID4args opsetclientid;
           case const.OP_SETCLIENTID_CONFIRM:
               /* Not used in NFSv4.1 */
               SETCLIENTID_CONFIRM4args opsetclientid_confirm;
           case const.OP_VERIFY:
               VERIFY4args opverify;
           case const.OP_WRITE:
               WRITE4args opwrite;
           case const.OP_RELEASE_LOCKOWNER:
               /* Not used in NFSv4.1 */
               RELEASE_LOCKOWNER4args oprelease_lockowner;
           /*
            * New to NFSv4.1
            */
           case const.OP_BACKCHANNEL_CTL:
               BACKCHANNEL_CTL4args opbackchannel_ctl;
           case const.OP_BIND_CONN_TO_SESSION:
               BIND_CONN_TO_SESSION4args opbind_conn_to_session;
           case const.OP_EXCHANGE_ID:
               EXCHANGE_ID4args opexchange_id;
           case const.OP_CREATE_SESSION:
               CREATE_SESSION4args opcreate_session;
           case const.OP_DESTROY_SESSION:
               DESTROY_SESSION4args opdestroy_session;
           case const.OP_FREE_STATEID:
               FREE_STATEID4args opfree_stateid;
           case const.OP_GET_DIR_DELEGATION:
               GET_DIR_DELEGATION4args opget_dir_delegation;
           case const.OP_GETDEVICEINFO:
               GETDEVICEINFO4args opgetdeviceinfo;
           case const.OP_GETDEVICELIST:
               /* Not used in NFSv4.2 */
               GETDEVICELIST4args opgetdevicelist;
           case const.OP_LAYOUTCOMMIT:
               LAYOUTCOMMIT4args oplayoutcommit;
           case const.OP_LAYOUTGET:
               LAYOUTGET4args oplayoutget;
           case const.OP_LAYOUTRETURN:
               LAYOUTRETURN4args oplayoutreturn;
           case const.OP_SECINFO_NO_NAME:
               SECINFO_NO_NAME4args opsecinfo_no_name;
           case const.OP_SEQUENCE:
               SEQUENCE4args opsequence;
           case const.OP_SET_SSV:
               SET_SSV4args opset_ssv;
           case const.OP_TEST_STATEID:
               TEST_STATEID4args optest_stateid;
           case const.OP_WANT_DELEGATION:
               WANT_DELEGATION4args opwant_delegation;
           case const.OP_DESTROY_CLIENTID:
               DESTROY_CLIENTID4args opdestroy_clientid;
           case const.OP_RECLAIM_COMPLETE:
               RECLAIM_COMPLETE4args opreclaim_complete;
           /*
            * New to NFSv4.2
            */
           case const.OP_ALLOCATE:
               ALLOCATE4args opallocate;
           case const.OP_COPY:
               COPY4args opcopy;
           case const.OP_COPY_NOTIFY:
               COPY_NOTIFY4args opcopy_notify;
           case const.OP_DEALLOCATE:
               DEALLOCATE4args opdeallocate;
           case const.OP_IO_ADVISE:
               IO_ADVISE4args opio_advise;
           case const.OP_LAYOUTERROR:
               LAYOUTERROR4args oplayouterror;
           case const.OP_LAYOUTSTATS:
               LAYOUTSTATS4args oplayoutstats;
           case const.OP_OFFLOAD_CANCEL:
               OFFLOAD_CANCEL4args opoffload_cancel;
           case const.OP_OFFLOAD_STATUS:
               OFFLOAD_STATUS4args opoffload_status;
           case const.OP_READ_PLUS:
               READ_PLUS4args opread_plus;
           case const.OP_SEEK:
               SEEK4args opseek;
           case const.OP_WRITE_SAME:
               WRITE_SAME4args opwrite_same;
           case const.OP_CLONE:
               CLONE4args opclone;
           case const.OP_ILLEGAL:
               /* Illegal operation */
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"
    _strfmt2 = "{1}"

    def __init__(self, unpack):
        self.set_attr("argop", nfs_opnum4(unpack))
        if self.argop == const.OP_ACCESS:
            self.set_attr("opaccess", ACCESS4args(unpack), switch=True)
        elif self.argop == const.OP_CLOSE:
            self.set_attr("opclose", CLOSE4args(unpack), switch=True)
        elif self.argop == const.OP_COMMIT:
            self.set_attr("opcommit", COMMIT4args(unpack), switch=True)
        elif self.argop == const.OP_CREATE:
            self.set_attr("opcreate", CREATE4args(unpack), switch=True)
        elif self.argop == const.OP_DELEGPURGE:
            self.set_attr("opdelegpurge", DELEGPURGE4args(unpack), switch=True)
        elif self.argop == const.OP_DELEGRETURN:
            self.set_attr("opdelegreturn", DELEGRETURN4args(unpack), switch=True)
        elif self.argop == const.OP_GETATTR:
            self.set_attr("opgetattr", GETATTR4args(unpack), switch=True)
        elif self.argop == const.OP_GETFH:
            self.set_strfmt(2, "GETFH4args()")
        elif self.argop == const.OP_LINK:
            self.set_attr("oplink", LINK4args(unpack), switch=True)
        elif self.argop == const.OP_LOCK:
            self.set_attr("oplock", LOCK4args(unpack), switch=True)
        elif self.argop == const.OP_LOCKT:
            self.set_attr("oplockt", LOCKT4args(unpack), switch=True)
        elif self.argop == const.OP_LOCKU:
            self.set_attr("oplocku", LOCKU4args(unpack), switch=True)
        elif self.argop == const.OP_LOOKUP:
            self.set_attr("oplookup", LOOKUP4args(unpack), switch=True)
        elif self.argop == const.OP_LOOKUPP:
            self.set_strfmt(2, "LOOKUPP4args()")
        elif self.argop == const.OP_NVERIFY:
            self.set_attr("opnverify", NVERIFY4args(unpack), switch=True)
        elif self.argop == const.OP_OPEN:
            self.set_attr("opopen", OPEN4args(unpack), switch=True)
        elif self.argop == const.OP_OPENATTR:
            self.set_attr("opopenattr", OPENATTR4args(unpack), switch=True)
        elif self.argop == const.OP_OPEN_CONFIRM:
            self.set_attr("opopen_confirm", OPEN_CONFIRM4args(unpack), switch=True)
        elif self.argop == const.OP_OPEN_DOWNGRADE:
            self.set_attr("opopen_downgrade", OPEN_DOWNGRADE4args(unpack), switch=True)
        elif self.argop == const.OP_PUTFH:
            self.set_attr("opputfh", PUTFH4args(unpack), switch=True)
        elif self.argop == const.OP_PUTPUBFH:
            self.set_strfmt(2, "PUTPUBFH4args()")
        elif self.argop == const.OP_PUTROOTFH:
            self.set_strfmt(2, "PUTROOTFH4args()")
        elif self.argop == const.OP_READ:
            self.set_attr("opread", READ4args(unpack), switch=True)
        elif self.argop == const.OP_READDIR:
            self.set_attr("opreaddir", READDIR4args(unpack), switch=True)
        elif self.argop == const.OP_READLINK:
            self.fh = self.nfs4_fh
            self.set_strfmt(1, "FH:{fh:crc32}")
            self.set_strfmt(2, "READLINK4args()")
        elif self.argop == const.OP_REMOVE:
            self.set_attr("opremove", REMOVE4args(unpack), switch=True)
        elif self.argop == const.OP_RENAME:
            self.set_attr("oprename", RENAME4args(unpack), switch=True)
        elif self.argop == const.OP_RENEW:
            self.set_attr("oprenew", RENEW4args(unpack), switch=True)
        elif self.argop == const.OP_RESTOREFH:
            self.set_global("nfs4_fh", self.nfs4_sfh)
            self.set_strfmt(2, "RESTOREFH4args()")
        elif self.argop == const.OP_SAVEFH:
            self.set_global("nfs4_sfh", self.nfs4_fh)
            self.set_strfmt(2, "SAVEFH4args()")
        elif self.argop == const.OP_SECINFO:
            self.set_attr("opsecinfo", SECINFO4args(unpack), switch=True)
        elif self.argop == const.OP_SETATTR:
            self.set_attr("opsetattr", SETATTR4args(unpack), switch=True)
        elif self.argop == const.OP_SETCLIENTID:
            self.set_attr("opsetclientid", SETCLIENTID4args(unpack), switch=True)
        elif self.argop == const.OP_SETCLIENTID_CONFIRM:
            self.set_attr("opsetclientid_confirm", SETCLIENTID_CONFIRM4args(unpack), switch=True)
        elif self.argop == const.OP_VERIFY:
            self.set_attr("opverify", VERIFY4args(unpack), switch=True)
        elif self.argop == const.OP_WRITE:
            self.set_attr("opwrite", WRITE4args(unpack), switch=True)
        elif self.argop == const.OP_RELEASE_LOCKOWNER:
            self.set_attr("oprelease_lockowner", RELEASE_LOCKOWNER4args(unpack), switch=True)
        elif self.argop == const.OP_BACKCHANNEL_CTL:
            self.set_attr("opbackchannel_ctl", BACKCHANNEL_CTL4args(unpack), switch=True)
        elif self.argop == const.OP_BIND_CONN_TO_SESSION:
            self.set_attr("opbind_conn_to_session", BIND_CONN_TO_SESSION4args(unpack), switch=True)
        elif self.argop == const.OP_EXCHANGE_ID:
            self.set_attr("opexchange_id", EXCHANGE_ID4args(unpack), switch=True)
        elif self.argop == const.OP_CREATE_SESSION:
            self.set_attr("opcreate_session", CREATE_SESSION4args(unpack), switch=True)
        elif self.argop == const.OP_DESTROY_SESSION:
            self.set_attr("opdestroy_session", DESTROY_SESSION4args(unpack), switch=True)
        elif self.argop == const.OP_FREE_STATEID:
            self.set_attr("opfree_stateid", FREE_STATEID4args(unpack), switch=True)
        elif self.argop == const.OP_GET_DIR_DELEGATION:
            self.set_attr("opget_dir_delegation", GET_DIR_DELEGATION4args(unpack), switch=True)
        elif self.argop == const.OP_GETDEVICEINFO:
            self.set_attr("opgetdeviceinfo", GETDEVICEINFO4args(unpack), switch=True)
        elif self.argop == const.OP_GETDEVICELIST:
            self.set_attr("opgetdevicelist", GETDEVICELIST4args(unpack), switch=True)
        elif self.argop == const.OP_LAYOUTCOMMIT:
            self.set_attr("oplayoutcommit", LAYOUTCOMMIT4args(unpack), switch=True)
        elif self.argop == const.OP_LAYOUTGET:
            self.set_attr("oplayoutget", LAYOUTGET4args(unpack), switch=True)
        elif self.argop == const.OP_LAYOUTRETURN:
            self.set_attr("oplayoutreturn", LAYOUTRETURN4args(unpack), switch=True)
        elif self.argop == const.OP_SECINFO_NO_NAME:
            self.set_attr("opsecinfo_no_name", SECINFO_NO_NAME4args(unpack), switch=True)
        elif self.argop == const.OP_SEQUENCE:
            self.set_attr("opsequence", SEQUENCE4args(unpack), switch=True)
        elif self.argop == const.OP_SET_SSV:
            self.set_attr("opset_ssv", SET_SSV4args(unpack), switch=True)
        elif self.argop == const.OP_TEST_STATEID:
            self.set_attr("optest_stateid", TEST_STATEID4args(unpack), switch=True)
        elif self.argop == const.OP_WANT_DELEGATION:
            self.set_attr("opwant_delegation", WANT_DELEGATION4args(unpack), switch=True)
        elif self.argop == const.OP_DESTROY_CLIENTID:
            self.set_attr("opdestroy_clientid", DESTROY_CLIENTID4args(unpack), switch=True)
        elif self.argop == const.OP_RECLAIM_COMPLETE:
            self.set_attr("opreclaim_complete", RECLAIM_COMPLETE4args(unpack), switch=True)
        elif self.argop == const.OP_ALLOCATE:
            self.set_attr("opallocate", ALLOCATE4args(unpack), switch=True)
        elif self.argop == const.OP_COPY:
            self.set_attr("opcopy", COPY4args(unpack), switch=True)
        elif self.argop == const.OP_COPY_NOTIFY:
            self.set_attr("opcopy_notify", COPY_NOTIFY4args(unpack), switch=True)
        elif self.argop == const.OP_DEALLOCATE:
            self.set_attr("opdeallocate", DEALLOCATE4args(unpack), switch=True)
        elif self.argop == const.OP_IO_ADVISE:
            self.set_attr("opio_advise", IO_ADVISE4args(unpack), switch=True)
        elif self.argop == const.OP_LAYOUTERROR:
            self.set_attr("oplayouterror", LAYOUTERROR4args(unpack), switch=True)
        elif self.argop == const.OP_LAYOUTSTATS:
            self.set_attr("oplayoutstats", LAYOUTSTATS4args(unpack), switch=True)
        elif self.argop == const.OP_OFFLOAD_CANCEL:
            self.set_attr("opoffload_cancel", OFFLOAD_CANCEL4args(unpack), switch=True)
        elif self.argop == const.OP_OFFLOAD_STATUS:
            self.set_attr("opoffload_status", OFFLOAD_STATUS4args(unpack), switch=True)
        elif self.argop == const.OP_READ_PLUS:
            self.set_attr("opread_plus", READ_PLUS4args(unpack), switch=True)
        elif self.argop == const.OP_SEEK:
            self.set_attr("opseek", SEEK4args(unpack), switch=True)
        elif self.argop == const.OP_WRITE_SAME:
            self.set_attr("opwrite_same", WRITE_SAME4args(unpack), switch=True)
        elif self.argop == const.OP_CLONE:
            self.set_attr("opclone", CLONE4args(unpack), switch=True)
        elif self.argop == const.OP_ILLEGAL:
            self.set_strfmt(2, "ILLEGAL4args()")
        self.op = self.argop

class nfs_resop4(BaseObj):
    """
       union switch nfs_resop4 (nfs_opnum4 resop) {
           case const.OP_ACCESS:
               ACCESS4res opaccess;
           case const.OP_CLOSE:
               CLOSE4res opclose;
           case const.OP_COMMIT:
               COMMIT4res opcommit;
           case const.OP_CREATE:
               CREATE4res opcreate;
           case const.OP_DELEGPURGE:
               DELEGPURGE4res opdelegpurge;
           case const.OP_DELEGRETURN:
               DELEGRETURN4res opdelegreturn;
           case const.OP_GETATTR:
               GETATTR4res opgetattr;
           case const.OP_GETFH:
               GETFH4res opgetfh;
           case const.OP_LINK:
               LINK4res oplink;
           case const.OP_LOCK:
               LOCK4res oplock;
           case const.OP_LOCKT:
               LOCKT4res oplockt;
           case const.OP_LOCKU:
               LOCKU4res oplocku;
           case const.OP_LOOKUP:
               LOOKUP4res oplookup;
           case const.OP_LOOKUPP:
               LOOKUPP4res oplookupp;
           case const.OP_NVERIFY:
               NVERIFY4res opnverify;
           case const.OP_OPEN:
               OPEN4res opopen;
           case const.OP_OPENATTR:
               OPENATTR4res opopenattr;
           case const.OP_OPEN_CONFIRM:
               /* Not used in NFSv4.1 */
               OPEN_CONFIRM4res opopen_confirm;
           case const.OP_OPEN_DOWNGRADE:
               OPEN_DOWNGRADE4res opopen_downgrade;
           case const.OP_PUTFH:
               PUTFH4res opputfh;
           case const.OP_PUTPUBFH:
               PUTPUBFH4res opputpubfh;
           case const.OP_PUTROOTFH:
               PUTROOTFH4res opputrootfh;
           case const.OP_READ:
               READ4res opread;
           case const.OP_READDIR:
               READDIR4res opreaddir;
           case const.OP_READLINK:
               READLINK4res opreadlink;
           case const.OP_REMOVE:
               REMOVE4res opremove;
           case const.OP_RENAME:
               RENAME4res oprename;
           case const.OP_RENEW:
               /* Not used in NFSv4.1 */
               RENEW4res oprenew;
           case const.OP_RESTOREFH:
               RESTOREFH4res oprestorefh;
           case const.OP_SAVEFH:
               SAVEFH4res opsavefh;
           case const.OP_SECINFO:
               SECINFO4res opsecinfo;
           case const.OP_SETATTR:
               SETATTR4res opsetattr;
           case const.OP_SETCLIENTID:
               /* Not used in NFSv4.1 */
               SETCLIENTID4res opsetclientid;
           case const.OP_SETCLIENTID_CONFIRM:
               /* Not used in NFSv4.1 */
               SETCLIENTID_CONFIRM4res opsetclientid_confirm;
           case const.OP_VERIFY:
               VERIFY4res opverify;
           case const.OP_WRITE:
               WRITE4res opwrite;
           case const.OP_RELEASE_LOCKOWNER:
               /* Not used in NFSv4.1 */
               RELEASE_LOCKOWNER4res oprelease_lockowner;
           /*
            * New to NFSv4.1
            */
           case const.OP_BACKCHANNEL_CTL:
               BACKCHANNEL_CTL4res opbackchannel_ctl;
           case const.OP_BIND_CONN_TO_SESSION:
               BIND_CONN_TO_SESSION4res opbind_conn_to_session;
           case const.OP_EXCHANGE_ID:
               EXCHANGE_ID4res opexchange_id;
           case const.OP_CREATE_SESSION:
               CREATE_SESSION4res opcreate_session;
           case const.OP_DESTROY_SESSION:
               DESTROY_SESSION4res opdestroy_session;
           case const.OP_FREE_STATEID:
               FREE_STATEID4res opfree_stateid;
           case const.OP_GET_DIR_DELEGATION:
               GET_DIR_DELEGATION4res opget_dir_delegation;
           case const.OP_GETDEVICEINFO:
               GETDEVICEINFO4res opgetdeviceinfo;
           case const.OP_GETDEVICELIST:
               /* Not used in NFSv4.2 */
               GETDEVICELIST4res opgetdevicelist;
           case const.OP_LAYOUTCOMMIT:
               LAYOUTCOMMIT4res oplayoutcommit;
           case const.OP_LAYOUTGET:
               LAYOUTGET4res oplayoutget;
           case const.OP_LAYOUTRETURN:
               LAYOUTRETURN4res oplayoutreturn;
           case const.OP_SECINFO_NO_NAME:
               SECINFO_NO_NAME4res opsecinfo_no_name;
           case const.OP_SEQUENCE:
               SEQUENCE4res opsequence;
           case const.OP_SET_SSV:
               SET_SSV4res opset_ssv;
           case const.OP_TEST_STATEID:
               TEST_STATEID4res optest_stateid;
           case const.OP_WANT_DELEGATION:
               WANT_DELEGATION4res opwant_delegation;
           case const.OP_DESTROY_CLIENTID:
               DESTROY_CLIENTID4res opdestroy_clientid;
           case const.OP_RECLAIM_COMPLETE:
               RECLAIM_COMPLETE4res opreclaim_complete;
           /*
            * New to NFSv4.2
            */
           case const.OP_ALLOCATE:
               ALLOCATE4res opallocate;
           case const.OP_COPY:
               COPY4res opcopy;
           case const.OP_COPY_NOTIFY:
               COPY_NOTIFY4res opcopy_notify;
           case const.OP_DEALLOCATE:
               DEALLOCATE4res opdeallocate;
           case const.OP_IO_ADVISE:
               IO_ADVISE4res opio_advise;
           case const.OP_LAYOUTERROR:
               LAYOUTERROR4res oplayouterror;
           case const.OP_LAYOUTSTATS:
               LAYOUTSTATS4res oplayoutstats;
           case const.OP_OFFLOAD_CANCEL:
               OFFLOAD_CANCEL4res opoffload_cancel;
           case const.OP_OFFLOAD_STATUS:
               OFFLOAD_STATUS4res opoffload_status;
           case const.OP_READ_PLUS:
               READ_PLUS4res opread_plus;
           case const.OP_SEEK:
               SEEK4res opseek;
           case const.OP_WRITE_SAME:
               WRITE_SAME4res opwrite_same;
           case const.OP_CLONE:
               CLONE4res opclone;
           case const.OP_ILLEGAL:
               /* Illegal operation */
               ILLEGAL4res opillegal;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"
    _strfmt2 = "{1}"

    def __init__(self, unpack):
        self.set_attr("resop", nfs_opnum4(unpack))
        if self.resop == const.OP_ACCESS:
            self.set_attr("opaccess", ACCESS4res(unpack), switch=True)
        elif self.resop == const.OP_CLOSE:
            self.set_attr("opclose", CLOSE4res(unpack), switch=True)
        elif self.resop == const.OP_COMMIT:
            self.set_attr("opcommit", COMMIT4res(unpack), switch=True)
        elif self.resop == const.OP_CREATE:
            self.set_attr("opcreate", CREATE4res(unpack), switch=True)
        elif self.resop == const.OP_DELEGPURGE:
            self.set_attr("opdelegpurge", DELEGPURGE4res(unpack), switch=True)
        elif self.resop == const.OP_DELEGRETURN:
            self.set_attr("opdelegreturn", DELEGRETURN4res(unpack), switch=True)
        elif self.resop == const.OP_GETATTR:
            self.set_attr("opgetattr", GETATTR4res(unpack), switch=True)
        elif self.resop == const.OP_GETFH:
            self.set_attr("opgetfh", GETFH4res(unpack), switch=True)
        elif self.resop == const.OP_LINK:
            self.set_attr("oplink", LINK4res(unpack), switch=True)
        elif self.resop == const.OP_LOCK:
            self.set_attr("oplock", LOCK4res(unpack), switch=True)
        elif self.resop == const.OP_LOCKT:
            self.set_attr("oplockt", LOCKT4res(unpack), switch=True)
        elif self.resop == const.OP_LOCKU:
            self.set_attr("oplocku", LOCKU4res(unpack), switch=True)
        elif self.resop == const.OP_LOOKUP:
            self.set_attr("oplookup", LOOKUP4res(unpack), switch=True)
        elif self.resop == const.OP_LOOKUPP:
            self.set_attr("oplookupp", LOOKUPP4res(unpack), switch=True)
        elif self.resop == const.OP_NVERIFY:
            self.set_attr("opnverify", NVERIFY4res(unpack), switch=True)
        elif self.resop == const.OP_OPEN:
            self.set_attr("opopen", OPEN4res(unpack), switch=True)
        elif self.resop == const.OP_OPENATTR:
            self.set_attr("opopenattr", OPENATTR4res(unpack), switch=True)
        elif self.resop == const.OP_OPEN_CONFIRM:
            self.set_attr("opopen_confirm", OPEN_CONFIRM4res(unpack), switch=True)
        elif self.resop == const.OP_OPEN_DOWNGRADE:
            self.set_attr("opopen_downgrade", OPEN_DOWNGRADE4res(unpack), switch=True)
        elif self.resop == const.OP_PUTFH:
            self.set_attr("opputfh", PUTFH4res(unpack), switch=True)
        elif self.resop == const.OP_PUTPUBFH:
            self.set_attr("opputpubfh", PUTPUBFH4res(unpack), switch=True)
        elif self.resop == const.OP_PUTROOTFH:
            self.set_attr("opputrootfh", PUTROOTFH4res(unpack), switch=True)
        elif self.resop == const.OP_READ:
            self.set_attr("opread", READ4res(unpack), switch=True)
        elif self.resop == const.OP_READDIR:
            self.set_attr("opreaddir", READDIR4res(unpack), switch=True)
        elif self.resop == const.OP_READLINK:
            self.set_attr("opreadlink", READLINK4res(unpack), switch=True)
        elif self.resop == const.OP_REMOVE:
            self.set_attr("opremove", REMOVE4res(unpack), switch=True)
        elif self.resop == const.OP_RENAME:
            self.set_attr("oprename", RENAME4res(unpack), switch=True)
        elif self.resop == const.OP_RENEW:
            self.set_attr("oprenew", RENEW4res(unpack), switch=True)
        elif self.resop == const.OP_RESTOREFH:
            self.set_attr("oprestorefh", RESTOREFH4res(unpack), switch=True)
        elif self.resop == const.OP_SAVEFH:
            self.set_attr("opsavefh", SAVEFH4res(unpack), switch=True)
        elif self.resop == const.OP_SECINFO:
            self.set_attr("opsecinfo", SECINFO4res(unpack), switch=True)
        elif self.resop == const.OP_SETATTR:
            self.set_attr("opsetattr", SETATTR4res(unpack), switch=True)
        elif self.resop == const.OP_SETCLIENTID:
            self.set_attr("opsetclientid", SETCLIENTID4res(unpack), switch=True)
        elif self.resop == const.OP_SETCLIENTID_CONFIRM:
            self.set_attr("opsetclientid_confirm", SETCLIENTID_CONFIRM4res(unpack), switch=True)
        elif self.resop == const.OP_VERIFY:
            self.set_attr("opverify", VERIFY4res(unpack), switch=True)
        elif self.resop == const.OP_WRITE:
            self.set_attr("opwrite", WRITE4res(unpack), switch=True)
        elif self.resop == const.OP_RELEASE_LOCKOWNER:
            self.set_attr("oprelease_lockowner", RELEASE_LOCKOWNER4res(unpack), switch=True)
        elif self.resop == const.OP_BACKCHANNEL_CTL:
            self.set_attr("opbackchannel_ctl", BACKCHANNEL_CTL4res(unpack), switch=True)
        elif self.resop == const.OP_BIND_CONN_TO_SESSION:
            self.set_attr("opbind_conn_to_session", BIND_CONN_TO_SESSION4res(unpack), switch=True)
        elif self.resop == const.OP_EXCHANGE_ID:
            self.set_attr("opexchange_id", EXCHANGE_ID4res(unpack), switch=True)
        elif self.resop == const.OP_CREATE_SESSION:
            self.set_attr("opcreate_session", CREATE_SESSION4res(unpack), switch=True)
        elif self.resop == const.OP_DESTROY_SESSION:
            self.set_attr("opdestroy_session", DESTROY_SESSION4res(unpack), switch=True)
        elif self.resop == const.OP_FREE_STATEID:
            self.set_attr("opfree_stateid", FREE_STATEID4res(unpack), switch=True)
        elif self.resop == const.OP_GET_DIR_DELEGATION:
            self.set_attr("opget_dir_delegation", GET_DIR_DELEGATION4res(unpack), switch=True)
        elif self.resop == const.OP_GETDEVICEINFO:
            self.set_attr("opgetdeviceinfo", GETDEVICEINFO4res(unpack), switch=True)
        elif self.resop == const.OP_GETDEVICELIST:
            self.set_attr("opgetdevicelist", GETDEVICELIST4res(unpack), switch=True)
        elif self.resop == const.OP_LAYOUTCOMMIT:
            self.set_attr("oplayoutcommit", LAYOUTCOMMIT4res(unpack), switch=True)
        elif self.resop == const.OP_LAYOUTGET:
            self.set_attr("oplayoutget", LAYOUTGET4res(unpack), switch=True)
        elif self.resop == const.OP_LAYOUTRETURN:
            self.set_attr("oplayoutreturn", LAYOUTRETURN4res(unpack), switch=True)
        elif self.resop == const.OP_SECINFO_NO_NAME:
            self.set_attr("opsecinfo_no_name", SECINFO_NO_NAME4res(unpack), switch=True)
        elif self.resop == const.OP_SEQUENCE:
            self.set_attr("opsequence", SEQUENCE4res(unpack), switch=True)
        elif self.resop == const.OP_SET_SSV:
            self.set_attr("opset_ssv", SET_SSV4res(unpack), switch=True)
        elif self.resop == const.OP_TEST_STATEID:
            self.set_attr("optest_stateid", TEST_STATEID4res(unpack), switch=True)
        elif self.resop == const.OP_WANT_DELEGATION:
            self.set_attr("opwant_delegation", WANT_DELEGATION4res(unpack), switch=True)
        elif self.resop == const.OP_DESTROY_CLIENTID:
            self.set_attr("opdestroy_clientid", DESTROY_CLIENTID4res(unpack), switch=True)
        elif self.resop == const.OP_RECLAIM_COMPLETE:
            self.set_attr("opreclaim_complete", RECLAIM_COMPLETE4res(unpack), switch=True)
        elif self.resop == const.OP_ALLOCATE:
            self.set_attr("opallocate", ALLOCATE4res(unpack), switch=True)
        elif self.resop == const.OP_COPY:
            self.set_attr("opcopy", COPY4res(unpack), switch=True)
        elif self.resop == const.OP_COPY_NOTIFY:
            self.set_attr("opcopy_notify", COPY_NOTIFY4res(unpack), switch=True)
        elif self.resop == const.OP_DEALLOCATE:
            self.set_attr("opdeallocate", DEALLOCATE4res(unpack), switch=True)
        elif self.resop == const.OP_IO_ADVISE:
            self.set_attr("opio_advise", IO_ADVISE4res(unpack), switch=True)
        elif self.resop == const.OP_LAYOUTERROR:
            self.set_attr("oplayouterror", LAYOUTERROR4res(unpack), switch=True)
        elif self.resop == const.OP_LAYOUTSTATS:
            self.set_attr("oplayoutstats", LAYOUTSTATS4res(unpack), switch=True)
        elif self.resop == const.OP_OFFLOAD_CANCEL:
            self.set_attr("opoffload_cancel", OFFLOAD_CANCEL4res(unpack), switch=True)
        elif self.resop == const.OP_OFFLOAD_STATUS:
            self.set_attr("opoffload_status", OFFLOAD_STATUS4res(unpack), switch=True)
        elif self.resop == const.OP_READ_PLUS:
            self.set_attr("opread_plus", READ_PLUS4res(unpack), switch=True)
        elif self.resop == const.OP_SEEK:
            self.set_attr("opseek", SEEK4res(unpack), switch=True)
        elif self.resop == const.OP_WRITE_SAME:
            self.set_attr("opwrite_same", WRITE_SAME4res(unpack), switch=True)
        elif self.resop == const.OP_CLONE:
            self.set_attr("opclone", CLONE4res(unpack), switch=True)
        elif self.resop == const.OP_ILLEGAL:
            self.set_attr("opillegal", ILLEGAL4res(unpack), switch=True)
        self.op = self.resop

class COMPOUND4args(NFSbase):
    """
       struct COMPOUND4args {
           utf8str_cs tag;
           uint32_t   minorversion;
           nfs_argop4 array<>;
       };
    """
    # Class attributes
    _attrlist = ("tag", "minorversion", "array")

    def __init__(self, unpack):
        self.set_global("nfs4_fh", None)
        self.set_global("nfs4_sfh", None)
        self.set_global("nfs4_layouttype", None)
        self.tag          = utf8str_cs(unpack)
        self.minorversion = uint32_t(unpack)
        self.array        = unpack.unpack_array(nfs_argop4)

class COMPOUND4res(NFSbase):
    """
       struct COMPOUND4res {
           nfsstat4   status;
           utf8str_cs tag;
           nfs_resop4 array<>;
       };
    """
    # Class attributes
    _attrlist = ("status", "tag", "array")

    def __init__(self, unpack, minorversion):
        self.set_global("nfs4_fh", None)
        self.set_global("nfs4_sfh", None)
        self.set_global("nfs4_layouttype", None)
        self.minorversion = minorversion
        self.status       = nfsstat4(unpack)
        self.tag          = utf8str_cs(unpack)
        self.array        = unpack.unpack_array(nfs_resop4)

# ======================================================================
# NFS4 Callback Operation Definitions
# ======================================================================
#
# Callback operation array
class nfs_cb_opnum4(Enum):
    """enum nfs_cb_opnum4"""
    _enumdict = const.nfs_cb_opnum4

# CB_GETATTR: Get Attributes of a File That Has Been Write Delegated
# ======================================================================
class CB_GETATTR4args(BaseObj):
    """
       struct CB_GETATTR4args {
           nfs_fh4 fh;
           bitmap4 request;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{0:crc32} request:{1}"
    _attrlist = ("fh", "request")

    def __init__(self, unpack):
        self.fh      = nfs_fh4(unpack)
        self.request = bitmap4(unpack)

class CB_GETATTR4resok(BaseObj):
    """
       struct CB_GETATTR4resok {
           fattr4 attributes;
       };
    """
    # Class attributes
    _attrlist = ("attributes",)

    def __init__(self, unpack):
        self.attributes = fattr4(unpack)

class CB_GETATTR4res(BaseObj):
    """
       union switch CB_GETATTR4res (nfsstat4 status) {
           case const.NFS4_OK:
               CB_GETATTR4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", CB_GETATTR4resok(unpack), switch=True)

# CB_RECALL: Recall an Open Delegation
# ======================================================================
class CB_RECALL4args(BaseObj):
    """
       struct CB_RECALL4args {
           stateid4 stateid;
           bool     truncate;
           nfs_fh4  fh;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{2:crc32} stid:{0} trunc:{1}"
    _attrlist = ("stateid", "truncate", "fh")

    def __init__(self, unpack):
        self.stateid  = stateid4(unpack)
        self.truncate = nfs_bool(unpack)
        self.fh       = nfs_fh4(unpack)

class CB_RECALL4res(BaseObj):
    """
       struct CB_RECALL4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# CB_ILLEGAL: Response for illegal operation numbers
# ======================================================================
class CB_ILLEGAL4res(BaseObj):
    """
       struct CB_ILLEGAL4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# NFSv4.1 callback arguments and results
#
# CB_LAYOUTRECALL: Recall Layout from Client
# ======================================================================
class layoutrecall_type4(Enum):
    """enum layoutrecall_type4"""
    _enumdict = const.layoutrecall_type4

class layoutrecall_file4(BaseObj):
    """
       struct layoutrecall_file4 {
           nfs_fh4  fh;
           offset4  offset;
           length4  length;
           stateid4 stateid;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{0:crc32} stid:{3} off:{1:umax64} len:{2:umax64}"
    _attrlist = ("fh", "offset", "length", "stateid")

    def __init__(self, unpack):
        self.fh      = nfs_fh4(unpack)
        self.offset  = offset4(unpack)
        self.length  = length4(unpack)
        self.stateid = stateid4(unpack)

class layoutrecall4(BaseObj):
    """
       union switch layoutrecall4 (layoutrecall_type4 recalltype) {
           case const.LAYOUTRECALL4_FILE:
               layoutrecall_file4 layout;
           case const.LAYOUTRECALL4_FSID:
               fsid4 fsid;
           case const.LAYOUTRECALL4_ALL:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("recalltype", layoutrecall_type4(unpack))
        if self.recalltype == const.LAYOUTRECALL4_FILE:
            self.set_attr("layout", layoutrecall_file4(unpack), switch=True)
        elif self.recalltype == const.LAYOUTRECALL4_FSID:
            self.set_attr("fsid", fsid4(unpack), switch=True)

class CB_LAYOUTRECALL4args(BaseObj):
    """
       struct CB_LAYOUTRECALL4args {
           layouttype4   type;
           layoutiomode4 iomode;
           bool          changed;
           layoutrecall4 recall;
       };
    """
    # Class attributes
    _strfmt1  = "{1:@14} {3}"
    _attrlist = ("type", "iomode", "changed", "recall")

    def __init__(self, unpack):
        self.type    = layouttype4(unpack)
        self.iomode  = layoutiomode4(unpack)
        self.changed = nfs_bool(unpack)
        self.recall  = layoutrecall4(unpack)

class CB_LAYOUTRECALL4res(BaseObj):
    """
       struct CB_LAYOUTRECALL4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# CB_NOTIFY: Notify Client of Directory Changes
# ======================================================================
#
# Directory notification types.
class notify_type4(Enum):
    """enum notify_type4"""
    _enumdict = const.notify_type4

# Changed entry information.
class notify_entry4(BaseObj):
    """
       struct notify_entry4 {
           component4 name;
           fattr4     attrs;
       };
    """
    # Class attributes
    _attrlist = ("name", "attrs")

    def __init__(self, unpack):
        self.name  = component4(unpack)
        self.attrs = fattr4(unpack)

# Previous entry information
class prev_entry4(BaseObj):
    """
       struct prev_entry4 {
           notify_entry4 entry;
           /* what READDIR returned for this entry */
           nfs_cookie4   cookie;
       };
    """
    # Class attributes
    _attrlist = ("entry", "cookie")

    def __init__(self, unpack):
        self.entry  = notify_entry4(unpack)
        self.cookie = nfs_cookie4(unpack)

class notify_remove4(BaseObj):
    """
       struct notify_remove4 {
           notify_entry4 entry;
           nfs_cookie4   cookie;
       };
    """
    # Class attributes
    _attrlist = ("entry", "cookie")

    def __init__(self, unpack):
        self.entry  = notify_entry4(unpack)
        self.cookie = nfs_cookie4(unpack)

class notify_add4(BaseObj):
    """
       struct notify_add4 {
           /*
            * Information on object
            * possibly renamed over.
            */
           notify_remove4 old_entry<1>;
           notify_entry4  new_entry;
           /* what READDIR would have returned for this entry */
           nfs_cookie4    new_cookie<1>;
           prev_entry4    prev_entry<1>;
           bool           last_entry;
       };
    """
    # Class attributes
    _attrlist = ("old_entry", "new_entry", "new_cookie", "prev_entry",
                 "last_entry")

    def __init__(self, unpack):
        self.old_entry  = unpack.unpack_conditional(notify_remove4)
        self.new_entry  = notify_entry4(unpack)
        self.new_cookie = unpack.unpack_conditional(nfs_cookie4)
        self.prev_entry = unpack.unpack_conditional(prev_entry4)
        self.last_entry = nfs_bool(unpack)

class notify_attr4(BaseObj):
    """
       struct notify_attr4 {
           notify_entry4 entry;
       };
    """
    # Class attributes
    _attrlist = ("entry",)

    def __init__(self, unpack):
        self.entry = notify_entry4(unpack)

class notify_rename4(BaseObj):
    """
       struct notify_rename4 {
           notify_remove4 old_entry;
           notify_add4    new_entry;
       };
    """
    # Class attributes
    _attrlist = ("old_entry", "new_entry")

    def __init__(self, unpack):
        self.old_entry = notify_remove4(unpack)
        self.new_entry = notify_add4(unpack)

class notify_verifier4(BaseObj):
    """
       struct notify_verifier4 {
           verifier4 old_verifier;
           verifier4 new_verifier;
       };
    """
    # Class attributes
    _attrlist = ("old_verifier", "new_verifier")

    def __init__(self, unpack):
        self.old_verifier = verifier4(unpack)
        self.new_verifier = verifier4(unpack)

# Objects of type notify_<>4 and
# notify_device_<>4 are encoded in this.
notifylist4 = lambda unpack: StrHex(unpack.unpack_opaque())

class notify4(BaseObj):
    """
       struct notify4 {
           /* composed from notify_type4 or notify_deviceid_type4 */
           bitmap4     mask;
           notifylist4 values;
       };
    """
    # Class attributes
    _attrlist = ("mask", "values")

    def __init__(self, unpack):
        self.mask   = bitmap4(unpack)
        self.values = notifylist4(unpack)

class CB_NOTIFY4args(BaseObj):
    """
       struct CB_NOTIFY4args {
           stateid4 stateid;
           nfs_fh4  fh;
           notify4  changes<>;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{1:crc32} stid:{0}"
    _attrlist = ("stateid", "fh", "changes")

    def __init__(self, unpack):
        self.stateid = stateid4(unpack)
        self.fh      = nfs_fh4(unpack)
        self.changes = unpack.unpack_array(notify4)

class CB_NOTIFY4res(BaseObj):
    """
       struct CB_NOTIFY4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# CB_PUSH_DELEG: Offer Previously Requested Delegation to Client
# ======================================================================
class CB_PUSH_DELEG4args(BaseObj):
    """
       struct CB_PUSH_DELEG4args {
           nfs_fh4          fh;
           open_delegation4 delegation;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{0:crc32} {1}"
    _attrlist = ("fh", "delegation")

    def __init__(self, unpack):
        self.fh         = nfs_fh4(unpack)
        self.delegation = open_delegation4(unpack)

class CB_PUSH_DELEG4res(BaseObj):
    """
       struct CB_PUSH_DELEG4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

class CB_RECALL_ANY4args(BaseObj):
    """
       struct CB_RECALL_ANY4args {
           uint32_t objects_to_keep;
           bitmap4  mask;
       };
    """
    # Class attributes
    _strfmt1  = "keep:{0} mask:{1}"
    _attrlist = ("objects_to_keep", "mask")

    def __init__(self, unpack):
        self.objects_to_keep = uint32_t(unpack)
        self.mask            = bitmap4(unpack)

class CB_RECALL_ANY4res(BaseObj):
    """
       struct CB_RECALL_ANY4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# CB_RECALLABLE_OBJ_AVAIL: Signal Resources for Recallable Objects
# ======================================================================
CB_RECALLABLE_OBJ_AVAIL4args = CB_RECALL_ANY4args

class CB_RECALLABLE_OBJ_AVAIL4res(BaseObj):
    """
       struct CB_RECALLABLE_OBJ_AVAIL4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# CB_RECALL_SLOT: Change Flow Control Limits
# ======================================================================
class CB_RECALL_SLOT4args(BaseObj):
    """
       struct CB_RECALL_SLOT4args {
           slotid4 target_highest_slotid;
       };
    """
    # Class attributes
    _strfmt1  = "slotid:{0}"
    _attrlist = ("target_highest_slotid",)

    def __init__(self, unpack):
        self.target_highest_slotid = slotid4(unpack)

class CB_RECALL_SLOT4res(BaseObj):
    """
       struct CB_RECALL_SLOT4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# CB_SEQUENCE: Supply Backchannel Sequencing and Control
# ======================================================================
class referring_call4(BaseObj):
    """
       struct referring_call4 {
           sequenceid4 sequenceid;
           slotid4     slotid;
       };
    """
    # Class attributes
    _attrlist = ("sequenceid", "slotid")

    def __init__(self, unpack):
        self.sequenceid = sequenceid4(unpack)
        self.slotid     = slotid4(unpack)

class referring_call_list4(BaseObj):
    """
       struct referring_call_list4 {
           sessionid4      sessionid;
           referring_call4 referring_calls<>;
       };
    """
    # Class attributes
    _attrlist = ("sessionid", "referring_calls")

    def __init__(self, unpack):
        self.sessionid       = sessionid4(unpack)
        self.referring_calls = unpack.unpack_array(referring_call4)

class CB_SEQUENCE4args(BaseObj):
    """
       struct CB_SEQUENCE4args {
           sessionid4           sessionid;
           sequenceid4          sequenceid;
           slotid4              slotid;
           slotid4              highest_slotid;
           bool                 cachethis;
           referring_call_list4 referring_call_lists<>;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("sessionid", "sequenceid", "slotid", "highest_slotid",
                 "cachethis", "referring_call_lists")

    def __init__(self, unpack):
        self.sessionid            = sessionid4(unpack)
        self.sequenceid           = sequenceid4(unpack)
        self.slotid               = slotid4(unpack)
        self.highest_slotid       = slotid4(unpack)
        self.cachethis            = nfs_bool(unpack)
        self.referring_call_lists = unpack.unpack_array(referring_call_list4)

class CB_SEQUENCE4resok(BaseObj):
    """
       struct CB_SEQUENCE4resok {
           sessionid4  sessionid;
           sequenceid4 sequenceid;
           slotid4     slotid;
           slotid4     highest_slotid;
           slotid4     target_highest_slotid;
       };
    """
    # Class attributes
    _attrlist = ("sessionid", "sequenceid", "slotid", "highest_slotid",
                 "target_highest_slotid")

    def __init__(self, unpack):
        self.sessionid             = sessionid4(unpack)
        self.sequenceid            = sequenceid4(unpack)
        self.slotid                = slotid4(unpack)
        self.highest_slotid        = slotid4(unpack)
        self.target_highest_slotid = slotid4(unpack)

class CB_SEQUENCE4res(BaseObj):
    """
       union switch CB_SEQUENCE4res (nfsstat4 status) {
           case const.NFS4_OK:
               CB_SEQUENCE4resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", CB_SEQUENCE4resok(unpack), switch=True)

# CB_WANTS_CANCELLED: Cancel Pending Delegation Wants
# ======================================================================
class CB_WANTS_CANCELLED4args(BaseObj):
    """
       struct CB_WANTS_CANCELLED4args {
           bool contended;
           bool resourced;
       };
    """
    # Class attributes
    _strfmt1  = "contended:{0} resourced:{1}"
    _attrlist = ("contended", "resourced")

    def __init__(self, unpack):
        self.contended = nfs_bool(unpack)
        self.resourced = nfs_bool(unpack)

class CB_WANTS_CANCELLED4res(BaseObj):
    """
       struct CB_WANTS_CANCELLED4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# CB_NOTIFY_LOCK: Notify Client of Possible Lock Availability
# ======================================================================
class CB_NOTIFY_LOCK4args(BaseObj):
    """
       struct CB_NOTIFY_LOCK4args {
           nfs_fh4     fh;
           lock_owner4 lock_owner;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{0:crc32}"
    _attrlist = ("fh", "lock_owner")

    def __init__(self, unpack):
        self.fh         = nfs_fh4(unpack)
        self.lock_owner = lock_owner4(unpack)

class CB_NOTIFY_LOCK4res(BaseObj):
    """
       struct CB_NOTIFY_LOCK4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# CB_NOTIFY_DEVICEID: Notify Client of Device ID Changes
# ======================================================================
#
# Device notification types.
class notify_deviceid_type4(Enum):
    """enum notify_deviceid_type4"""
    _enumdict = const.notify_deviceid_type4

# For NOTIFY4_DEVICEID4_DELETE
class notify_deviceid_delete4(BaseObj):
    """
       struct notify_deviceid_delete4 {
           layouttype4 type;
           deviceid4   deviceid;
       };
    """
    # Class attributes
    _attrlist = ("type", "deviceid")

    def __init__(self, unpack):
        self.type     = layouttype4(unpack)
        self.deviceid = deviceid4(unpack)

# For NOTIFY4_DEVICEID4_CHANGE
class notify_deviceid_change4(BaseObj):
    """
       struct notify_deviceid_change4 {
           layouttype4 type;
           deviceid4   deviceid;
           bool        immediate;
       };
    """
    # Class attributes
    _attrlist = ("type", "deviceid", "immediate")

    def __init__(self, unpack):
        self.type      = layouttype4(unpack)
        self.deviceid  = deviceid4(unpack)
        self.immediate = nfs_bool(unpack)

class CB_NOTIFY_DEVICEID4args(BaseObj):
    """
       struct CB_NOTIFY_DEVICEID4args {
           notify4 changes<>;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("changes",)

    def __init__(self, unpack):
        self.changes = unpack.unpack_array(notify4)

class CB_NOTIFY_DEVICEID4res(BaseObj):
    """
       struct CB_NOTIFY_DEVICEID4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

# New to NFSv4.2
# ======================================================================
#
# CB_OFFLOAD: Report Results of an Asynchronous Operation
# ======================================================================
class offload_info4(BaseObj):
    """
       union switch offload_info4 (nfsstat4 status) {
           case const.NFS4_OK:
               write_response4 resok;
           default:
               length4 count;
       };
    """
    def __init__(self, unpack):
        self.set_attr("status", nfsstat4(unpack))
        if self.status == const.NFS4_OK:
            self.set_attr("resok", write_response4(unpack), switch=True)
        else:
            self.set_attr("count", length4(unpack), switch=True)

class CB_OFFLOAD4args(BaseObj):
    """
       struct CB_OFFLOAD4args {
           nfs_fh4       fh;
           stateid4      stateid;
           offload_info4 info;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{0:crc32} stid:{1}"
    _attrlist = ("fh", "stateid", "info")

    def __init__(self, unpack):
        self.fh      = nfs_fh4(unpack)
        self.stateid = stateid4(unpack)
        self.info    = offload_info4(unpack)

class CB_OFFLOAD4res(BaseObj):
    """
       struct CB_OFFLOAD4res {
           nfsstat4 status;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("status",)

    def __init__(self, unpack):
        self.status = nfsstat4(unpack)

class nfs_cb_argop4(BaseObj):
    """
       union switch nfs_cb_argop4 (nfs_cb_opnum4 argop) {
           case const.OP_CB_GETATTR:
               CB_GETATTR4args opcbgetattr;
           case const.OP_CB_RECALL:
               CB_RECALL4args opcbrecall;
           /*
            * New to NFSv4.1
            */
           case const.OP_CB_LAYOUTRECALL:
               CB_LAYOUTRECALL4args opcblayoutrecall;
           case const.OP_CB_NOTIFY:
               CB_NOTIFY4args opcbnotify;
           case const.OP_CB_PUSH_DELEG:
               CB_PUSH_DELEG4args opcbpush_deleg;
           case const.OP_CB_RECALL_ANY:
               CB_RECALL_ANY4args opcbrecall_any;
           case const.OP_CB_RECALLABLE_OBJ_AVAIL:
               CB_RECALLABLE_OBJ_AVAIL4args opcbrecallable_obj_avail;
           case const.OP_CB_RECALL_SLOT:
               CB_RECALL_SLOT4args opcbrecall_slot;
           case const.OP_CB_SEQUENCE:
               CB_SEQUENCE4args opcbsequence;
           case const.OP_CB_WANTS_CANCELLED:
               CB_WANTS_CANCELLED4args opcbwants_cancelled;
           case const.OP_CB_NOTIFY_LOCK:
               CB_NOTIFY_LOCK4args opcbnotify_lock;
           case const.OP_CB_NOTIFY_DEVICEID:
               CB_NOTIFY_DEVICEID4args opcbnotify_deviceid;
           /*
            * New to NFSv4.2
            */
           case const.OP_CB_OFFLOAD:
               CB_OFFLOAD4args opcboffload;
           case const.OP_CB_ILLEGAL:
               /* Illegal callback operation */
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"
    _strfmt2 = "{1}"

    def __init__(self, unpack):
        self.set_attr("argop", nfs_cb_opnum4(unpack))
        if self.argop == const.OP_CB_GETATTR:
            self.set_attr("opcbgetattr", CB_GETATTR4args(unpack), switch=True)
        elif self.argop == const.OP_CB_RECALL:
            self.set_attr("opcbrecall", CB_RECALL4args(unpack), switch=True)
        elif self.argop == const.OP_CB_LAYOUTRECALL:
            self.set_attr("opcblayoutrecall", CB_LAYOUTRECALL4args(unpack), switch=True)
        elif self.argop == const.OP_CB_NOTIFY:
            self.set_attr("opcbnotify", CB_NOTIFY4args(unpack), switch=True)
        elif self.argop == const.OP_CB_PUSH_DELEG:
            self.set_attr("opcbpush_deleg", CB_PUSH_DELEG4args(unpack), switch=True)
        elif self.argop == const.OP_CB_RECALL_ANY:
            self.set_attr("opcbrecall_any", CB_RECALL_ANY4args(unpack), switch=True)
        elif self.argop == const.OP_CB_RECALLABLE_OBJ_AVAIL:
            self.set_attr("opcbrecallable_obj_avail", CB_RECALLABLE_OBJ_AVAIL4args(unpack), switch=True)
        elif self.argop == const.OP_CB_RECALL_SLOT:
            self.set_attr("opcbrecall_slot", CB_RECALL_SLOT4args(unpack), switch=True)
        elif self.argop == const.OP_CB_SEQUENCE:
            self.set_attr("opcbsequence", CB_SEQUENCE4args(unpack), switch=True)
        elif self.argop == const.OP_CB_WANTS_CANCELLED:
            self.set_attr("opcbwants_cancelled", CB_WANTS_CANCELLED4args(unpack), switch=True)
        elif self.argop == const.OP_CB_NOTIFY_LOCK:
            self.set_attr("opcbnotify_lock", CB_NOTIFY_LOCK4args(unpack), switch=True)
        elif self.argop == const.OP_CB_NOTIFY_DEVICEID:
            self.set_attr("opcbnotify_deviceid", CB_NOTIFY_DEVICEID4args(unpack), switch=True)
        elif self.argop == const.OP_CB_OFFLOAD:
            self.set_attr("opcboffload", CB_OFFLOAD4args(unpack), switch=True)
        elif self.argop == const.OP_CB_ILLEGAL:
            self.set_strfmt(2, "CB_ILLEGAL4args()")
        self.op = self.argop

class nfs_cb_resop4(BaseObj):
    """
       union switch nfs_cb_resop4 (nfs_cb_opnum4 resop) {
           case const.OP_CB_GETATTR:
               CB_GETATTR4res opcbgetattr;
           case const.OP_CB_RECALL:
               CB_RECALL4res opcbrecall;
           /*
            * New to NFSv4.1
            */
           case const.OP_CB_LAYOUTRECALL:
               CB_LAYOUTRECALL4res opcblayoutrecall;
           case const.OP_CB_NOTIFY:
               CB_NOTIFY4res opcbnotify;
           case const.OP_CB_PUSH_DELEG:
               CB_PUSH_DELEG4res opcbpush_deleg;
           case const.OP_CB_RECALL_ANY:
               CB_RECALL_ANY4res opcbrecall_any;
           case const.OP_CB_RECALLABLE_OBJ_AVAIL:
               CB_RECALLABLE_OBJ_AVAIL4res opcbrecallable_obj_avail;
           case const.OP_CB_RECALL_SLOT:
               CB_RECALL_SLOT4res opcbrecall_slot;
           case const.OP_CB_SEQUENCE:
               CB_SEQUENCE4res opcbsequence;
           case const.OP_CB_WANTS_CANCELLED:
               CB_WANTS_CANCELLED4res opcbwants_cancelled;
           case const.OP_CB_NOTIFY_LOCK:
               CB_NOTIFY_LOCK4res opcbnotify_lock;
           case const.OP_CB_NOTIFY_DEVICEID:
               CB_NOTIFY_DEVICEID4res opcbnotify_deviceid;
           /*
            * New to NFSv4.2
            */
           case const.OP_CB_OFFLOAD:
               CB_OFFLOAD4res opcboffload;
           case const.OP_CB_ILLEGAL:
               /* Illegal callback operation */
               CB_ILLEGAL4res opcbillegal;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"
    _strfmt2 = "{1}"

    def __init__(self, unpack):
        self.set_attr("resop", nfs_cb_opnum4(unpack))
        if self.resop == const.OP_CB_GETATTR:
            self.set_attr("opcbgetattr", CB_GETATTR4res(unpack), switch=True)
        elif self.resop == const.OP_CB_RECALL:
            self.set_attr("opcbrecall", CB_RECALL4res(unpack), switch=True)
        elif self.resop == const.OP_CB_LAYOUTRECALL:
            self.set_attr("opcblayoutrecall", CB_LAYOUTRECALL4res(unpack), switch=True)
        elif self.resop == const.OP_CB_NOTIFY:
            self.set_attr("opcbnotify", CB_NOTIFY4res(unpack), switch=True)
        elif self.resop == const.OP_CB_PUSH_DELEG:
            self.set_attr("opcbpush_deleg", CB_PUSH_DELEG4res(unpack), switch=True)
        elif self.resop == const.OP_CB_RECALL_ANY:
            self.set_attr("opcbrecall_any", CB_RECALL_ANY4res(unpack), switch=True)
        elif self.resop == const.OP_CB_RECALLABLE_OBJ_AVAIL:
            self.set_attr("opcbrecallable_obj_avail", CB_RECALLABLE_OBJ_AVAIL4res(unpack), switch=True)
        elif self.resop == const.OP_CB_RECALL_SLOT:
            self.set_attr("opcbrecall_slot", CB_RECALL_SLOT4res(unpack), switch=True)
        elif self.resop == const.OP_CB_SEQUENCE:
            self.set_attr("opcbsequence", CB_SEQUENCE4res(unpack), switch=True)
        elif self.resop == const.OP_CB_WANTS_CANCELLED:
            self.set_attr("opcbwants_cancelled", CB_WANTS_CANCELLED4res(unpack), switch=True)
        elif self.resop == const.OP_CB_NOTIFY_LOCK:
            self.set_attr("opcbnotify_lock", CB_NOTIFY_LOCK4res(unpack), switch=True)
        elif self.resop == const.OP_CB_NOTIFY_DEVICEID:
            self.set_attr("opcbnotify_deviceid", CB_NOTIFY_DEVICEID4res(unpack), switch=True)
        elif self.resop == const.OP_CB_OFFLOAD:
            self.set_attr("opcboffload", CB_OFFLOAD4res(unpack), switch=True)
        elif self.resop == const.OP_CB_ILLEGAL:
            self.set_attr("opcbillegal", CB_ILLEGAL4res(unpack), switch=True)
        self.op = self.resop

class CB_COMPOUND4args(NFSbase):
    """
       struct CB_COMPOUND4args {
           utf8str_cs    tag;
           uint32_t      minorversion;
           uint32_t      callback_ident;
           nfs_cb_argop4 array<>;
       };
    """
    # Class attributes
    _attrlist = ("tag", "minorversion", "callback_ident", "array")

    def __init__(self, unpack):
        self.set_global("nfs4_fh", None)
        self.set_global("nfs4_sfh", None)
        self.set_global("nfs4_layouttype", None)
        self.tag            = utf8str_cs(unpack)
        self.minorversion   = uint32_t(unpack)
        self.callback_ident = uint32_t(unpack)
        self.array          = unpack.unpack_array(nfs_cb_argop4)

class CB_COMPOUND4res(NFSbase):
    """
       struct CB_COMPOUND4res {
           nfsstat4      status;
           utf8str_cs    tag;
           nfs_cb_resop4 array<>;
       };
    """
    # Class attributes
    _attrlist = ("status", "tag", "array")

    def __init__(self, unpack, minorversion):
        self.set_global("nfs4_fh", None)
        self.set_global("nfs4_sfh", None)
        self.set_global("nfs4_layouttype", None)
        self.minorversion = minorversion
        self.status       = nfsstat4(unpack)
        self.tag          = utf8str_cs(unpack)
        self.array        = unpack.unpack_array(nfs_cb_resop4)
