#===============================================================================
# Copyright 2014 NetApp, Inc. All Rights Reserved,
# contribution by Jorge Mora <mora@netapp.com>
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#===============================================================================
# Generated by process_xdr.py from mount3.x on Sun Oct 04 08:09:27 2015
"""
MOUNTv3 decoding module
"""
import nfstest_config as c
from packet.utils import *
from baseobj import BaseObj
import mount3_const as const
from packet.unpack import Unpack

# Module constants
__author__    = "Jorge Mora (%s)" % c.NFSTEST_AUTHOR_EMAIL
__copyright__ = "Copyright (C) 2014 NetApp, Inc."
__license__   = "GPL v2"
__version__   = "3.0"

# Basic Data Types
fhandle3 = lambda unpack: StrHex(unpack.unpack_opaque(const.FHSIZE3))
dirpath3 = lambda unpack: unpack.unpack_opaque(const.MNTPATHLEN)
name3    = lambda unpack: unpack.unpack_opaque(const.MNTNAMLEN)

class mountstat3(Enum):
    """enum mountstat3"""
    _enumdict = const.mountstat3

class rpc_auth_flavors(Enum):
    """enum rpc_auth_flavors"""
    _enumdict = const.rpc_auth_flavors

# MNT3res MOUNTPROC3_MNT(dirpath3) = 1;
class MNT3args(BaseObj):
    """
       struct MNT3args {
           dirpath3 path;
       };
    """
    # Class attributes
    _strfmt1  = "{0}"
    _attrlist = ("path",)

    def __init__(self, unpack):
        self.path = dirpath3(unpack)

class MNT3resok(BaseObj):
    """
       struct MNT3resok {
           fhandle3         fh;
           rpc_auth_flavors auth_flavors<>;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{0:crc32} auth_flavors:{1}"
    _attrlist = ("fh", "auth_flavors")

    def __init__(self, unpack):
        self.fh           = fhandle3(unpack)
        self.auth_flavors = unpack.unpack_array(rpc_auth_flavors)

class MNT3res(BaseObj):
    """
       union switch MNT3res (mountstat3 status) {
           case const.MNT3_OK:
               MNT3resok mountinfo;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", mountstat3(unpack))
        if self.status == const.MNT3_OK:
            self.set_attr("mountinfo", MNT3resok(unpack), switch=True)

# mountlist MOUNTPROC3_DUMP(void) = 2;
class mountentry(BaseObj):
    """
       struct mountentry {
           name3      hostname;
           dirpath3   directory;
           mountentry *next;
       };
    """
    # Class attributes
    _attrlist = ("hostname", "directory")

    def __init__(self, unpack):
        self.hostname  = name3(unpack)
        self.directory = dirpath3(unpack)

class DUMP3res(BaseObj):
    """
       struct DUMP3res {
           mountentry *mountlist;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("mountlist",)

    def __init__(self, unpack):
        self.mountlist = unpack.unpack_list(mountentry)

# void MOUNTPROC3_UMNT(dirpath3) = 3;
class UMNT3args(BaseObj):
    """
       struct UMNT3args {
           dirpath3 path;
       };
    """
    # Class attributes
    _strfmt1  = "{0}"
    _attrlist = ("path",)

    def __init__(self, unpack):
        self.path = dirpath3(unpack)

# void MOUNTPROC3_UMNTALL(void) = 4;
#
# EXPORT3res MOUNTPROC3_EXPORT(void) = 5;
class exportnode3(BaseObj):
    """
       struct exportnode3 {
           dirpath3    dir;
           name3       *groups;
           exportnode3 *next;
       };
    """
    # Class attributes
    _attrlist = ("dir", "groups")

    def __init__(self, unpack):
        self.dir    = dirpath3(unpack)
        self.groups = unpack.unpack_list(name3)

class EXPORT3res(BaseObj):
    """
       struct EXPORT3res {
           exportnode3 *exports;
       };
    """
    # Class attributes
    _strfmt1  = ""
    _attrlist = ("exports",)

    def __init__(self, unpack):
        self.exports = unpack.unpack_list(exportnode3)

# Procedures
class mount_proc3(Enum):
    """enum mount_proc3"""
    _enumdict = const.mount_proc3

# Version 3 of the mount protocol used with
# version 3 of the NFS protocol.
class MOUNT3args(RPCload):
    """
       union switch MOUNT3args (mount_proc3 procedure) {
           case const.MOUNTPROC3_NULL:
               void;
           case const.MOUNTPROC3_MNT:
               MNT3args opmnt;
           case const.MOUNTPROC3_DUMP:
               void;
           case const.MOUNTPROC3_UMNT:
               UMNT3args opumnt;
           case const.MOUNTPROC3_UMNTALL:
               void;
           case const.MOUNTPROC3_EXPORT:
               void;
       };
    """
    # Class attributes
    _pindex  = 11
    _strname = "MOUNT"

    def __init__(self, unpack, procedure):
        self.set_attr("procedure", mount_proc3(procedure))
        if self.procedure == const.MOUNTPROC3_NULL:
            self.set_strfmt(2, "NULL()")
        elif self.procedure == const.MOUNTPROC3_MNT:
            self.set_attr("opmnt", MNT3args(unpack), switch=True)
        elif self.procedure == const.MOUNTPROC3_DUMP:
            self.set_strfmt(2, "DUMP3args()")
        elif self.procedure == const.MOUNTPROC3_UMNT:
            self.set_attr("opumnt", UMNT3args(unpack), switch=True)
        elif self.procedure == const.MOUNTPROC3_UMNTALL:
            self.set_strfmt(2, "UMNTALL3args()")
        elif self.procedure == const.MOUNTPROC3_EXPORT:
            self.set_strfmt(2, "EXPORT3args()")
        self.argop = self.procedure
        self.op    = self.procedure

class MOUNT3res(RPCload):
    """
       union switch MOUNT3res (mount_proc3 procedure) {
           case const.MOUNTPROC3_NULL:
               void;
           case const.MOUNTPROC3_MNT:
               MNT3res opmnt;
           case const.MOUNTPROC3_DUMP:
               DUMP3res opdump;
           case const.MOUNTPROC3_UMNT:
               void;
           case const.MOUNTPROC3_UMNTALL:
               void;
           case const.MOUNTPROC3_EXPORT:
               EXPORT3res opexport;
       };
    """
    # Class attributes
    _pindex  = 11
    _strname = "MOUNT"

    def __init__(self, unpack, procedure):
        self.set_attr("procedure", mount_proc3(procedure))
        if self.procedure == const.MOUNTPROC3_NULL:
            self.set_strfmt(2, "NULL()")
        elif self.procedure == const.MOUNTPROC3_MNT:
            self.set_attr("opmnt", MNT3res(unpack), switch=True)
        elif self.procedure == const.MOUNTPROC3_DUMP:
            self.set_attr("opdump", DUMP3res(unpack), switch=True)
        elif self.procedure == const.MOUNTPROC3_UMNT:
            self.set_strfmt(2, "UMNT3res()")
        elif self.procedure == const.MOUNTPROC3_UMNTALL:
            self.set_strfmt(2, "UMNTALL3res()")
        elif self.procedure == const.MOUNTPROC3_EXPORT:
            self.set_attr("opexport", EXPORT3res(unpack), switch=True)
        self.resop = self.procedure
        self.op    = self.procedure
