# Generated by rpcgen.py from nfs4.x on Wed Jul 11 08:30:29 2012
import nfs4_const as const
class authsys_parms:
    # XDR definition:
    # struct authsys_parms {
    #     uint stamp;
    #     string machinename<255>;
    #     uint uid;
    #     uint gid;
    #     uint gids<16>;
    # };
    def __init__(self, stamp=None, machinename=None, uid=None, gid=None, gids=None):
        self.stamp = stamp
        self.machinename = machinename
        self.uid = uid
        self.gid = gid
        self.gids = gids

    def __repr__(self):
        out = []
        if self.stamp is not None:
            out += ['stamp=%s' % repr(self.stamp)]
        if self.machinename is not None:
            out += ['machinename=%s' % repr(self.machinename)]
        if self.uid is not None:
            out += ['uid=%s' % repr(self.uid)]
        if self.gid is not None:
            out += ['gid=%s' % repr(self.gid)]
        if self.gids is not None:
            out += ['gids=%s' % repr(self.gids)]
        return 'authsys_parms(%s)' % ', '.join(out)
    __str__ = __repr__

class nfstime4:
    # XDR definition:
    # struct nfstime4 {
    #     int64_t seconds;
    #     uint32_t nseconds;
    # };
    def __init__(self, seconds=None, nseconds=None):
        self.seconds = seconds
        self.nseconds = nseconds

    def __repr__(self):
        out = []
        if self.seconds is not None:
            out += ['seconds=%s' % repr(self.seconds)]
        if self.nseconds is not None:
            out += ['nseconds=%s' % repr(self.nseconds)]
        return 'nfstime4(%s)' % ', '.join(out)
    __str__ = __repr__

class settime4:
    # XDR definition:
    # union settime4 switch(time_how4 set_it) {
    #     case SET_TO_CLIENT_TIME4:
    #         nfstime4 time;
    #     default:
    #         void;
    # };
    def __init__(self, set_it=None, time=None):
        self.set_it = set_it
        self.time = time

    switch = property(lambda s: {const.SET_TO_CLIENT_TIME4:s.time,}.get(s.set_it, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.set_it is not None:
            out += ['set_it=%s' % const.time_how4.get(self.set_it, self.set_it)]
        if self.time is not None:
            out += ['time=%s' % repr(self.time)]
        return 'settime4(%s)' % ', '.join(out)
    __str__ = __repr__

class fsid4:
    # XDR definition:
    # struct fsid4 {
    #     uint64_t major;
    #     uint64_t minor;
    # };
    def __init__(self, major=None, minor=None):
        self.major = major
        self.minor = minor

    def __repr__(self):
        out = []
        if self.major is not None:
            out += ['major=%s' % repr(self.major)]
        if self.minor is not None:
            out += ['minor=%s' % repr(self.minor)]
        return 'fsid4(%s)' % ', '.join(out)
    __str__ = __repr__

class change_policy4:
    # XDR definition:
    # struct change_policy4 {
    #     uint64_t cp_major;
    #     uint64_t cp_minor;
    # };
    def __init__(self, cp_major=None, cp_minor=None):
        self.cp_major = cp_major
        self.cp_minor = cp_minor

    def __repr__(self):
        out = []
        if self.cp_major is not None:
            out += ['cp_major=%s' % repr(self.cp_major)]
        if self.cp_minor is not None:
            out += ['cp_minor=%s' % repr(self.cp_minor)]
        return 'change_policy4(%s)' % ', '.join(out)
    __str__ = __repr__

class fs_location4:
    # XDR definition:
    # struct fs_location4 {
    #     utf8str_cis server<>;
    #     pathname4 rootpath;
    # };
    def __init__(self, server=None, rootpath=None):
        self.server = server
        self.rootpath = rootpath

    def __repr__(self):
        out = []
        if self.server is not None:
            out += ['server=%s' % repr(self.server)]
        if self.rootpath is not None:
            out += ['rootpath=%s' % repr(self.rootpath)]
        return 'fs_location4(%s)' % ', '.join(out)
    __str__ = __repr__

class fs_locations4:
    # XDR definition:
    # struct fs_locations4 {
    #     pathname4 fs_root;
    #     fs_location4 locations<>;
    # };
    def __init__(self, fs_root=None, locations=None):
        self.fs_root = fs_root
        self.locations = locations

    def __repr__(self):
        out = []
        if self.fs_root is not None:
            out += ['fs_root=%s' % repr(self.fs_root)]
        if self.locations is not None:
            out += ['locations=%s' % repr(self.locations)]
        return 'fs_locations4(%s)' % ', '.join(out)
    __str__ = __repr__

class nfsace4:
    # XDR definition:
    # struct nfsace4 {
    #     acetype4 type;
    #     aceflag4 flag;
    #     acemask4 access_mask;
    #     utf8str_mixed who;
    # };
    def __init__(self, type=None, flag=None, access_mask=None, who=None):
        self.type = type
        self.flag = flag
        self.access_mask = access_mask
        self.who = who

    def __repr__(self):
        out = []
        if self.type is not None:
            out += ['type=%s' % repr(self.type)]
        if self.flag is not None:
            out += ['flag=%s' % repr(self.flag)]
        if self.access_mask is not None:
            out += ['access_mask=%s' % repr(self.access_mask)]
        if self.who is not None:
            out += ['who=%s' % repr(self.who)]
        return 'nfsace4(%s)' % ', '.join(out)
    __str__ = __repr__

class nfsacl41:
    # XDR definition:
    # struct nfsacl41 {
    #     aclflag4 na41_flag;
    #     nfsace4 na41_aces<>;
    # };
    def __init__(self, na41_flag=None, na41_aces=None):
        self.na41_flag = na41_flag
        self.na41_aces = na41_aces

    def __repr__(self):
        out = []
        if self.na41_flag is not None:
            out += ['na41_flag=%s' % repr(self.na41_flag)]
        if self.na41_aces is not None:
            out += ['na41_aces=%s' % repr(self.na41_aces)]
        return 'nfsacl41(%s)' % ', '.join(out)
    __str__ = __repr__

class mode_masked4:
    # XDR definition:
    # struct mode_masked4 {
    #     mode4 mm_value_to_set;
    #     mode4 mm_mask_bits;
    # };
    def __init__(self, mm_value_to_set=None, mm_mask_bits=None):
        self.mm_value_to_set = mm_value_to_set
        self.mm_mask_bits = mm_mask_bits

    def __repr__(self):
        out = []
        if self.mm_value_to_set is not None:
            out += ['mm_value_to_set=%s' % repr(self.mm_value_to_set)]
        if self.mm_mask_bits is not None:
            out += ['mm_mask_bits=%s' % repr(self.mm_mask_bits)]
        return 'mode_masked4(%s)' % ', '.join(out)
    __str__ = __repr__

class specdata4:
    # XDR definition:
    # struct specdata4 {
    #     uint32_t specdata1;
    #     uint32_t specdata2;
    # };
    def __init__(self, specdata1=None, specdata2=None):
        self.specdata1 = specdata1
        self.specdata2 = specdata2

    def __repr__(self):
        out = []
        if self.specdata1 is not None:
            out += ['specdata1=%s' % repr(self.specdata1)]
        if self.specdata2 is not None:
            out += ['specdata2=%s' % repr(self.specdata2)]
        return 'specdata4(%s)' % ', '.join(out)
    __str__ = __repr__

class netaddr4:
    # XDR definition:
    # struct netaddr4 {
    #     string na_r_netid<>;
    #     string na_r_addr<>;
    # };
    def __init__(self, na_r_netid=None, na_r_addr=None):
        self.na_r_netid = na_r_netid
        self.na_r_addr = na_r_addr

    def __repr__(self):
        out = []
        if self.na_r_netid is not None:
            out += ['na_r_netid=%s' % repr(self.na_r_netid)]
        if self.na_r_addr is not None:
            out += ['na_r_addr=%s' % repr(self.na_r_addr)]
        return 'netaddr4(%s)' % ', '.join(out)
    __str__ = __repr__

class nfs_impl_id4:
    # XDR definition:
    # struct nfs_impl_id4 {
    #     utf8str_cis nii_domain;
    #     utf8str_cs nii_name;
    #     nfstime4 nii_date;
    # };
    def __init__(self, nii_domain=None, nii_name=None, nii_date=None):
        self.nii_domain = nii_domain
        self.nii_name = nii_name
        self.nii_date = nii_date

    def __getattr__(self, attr):
        return getattr(self.nii_date, attr)

    def __repr__(self):
        out = []
        if self.nii_domain is not None:
            out += ['nii_domain=%s' % repr(self.nii_domain)]
        if self.nii_name is not None:
            out += ['nii_name=%s' % repr(self.nii_name)]
        if self.nii_date is not None:
            out += ['nii_date=%s' % repr(self.nii_date)]
        return 'nfs_impl_id4(%s)' % ', '.join(out)
    __str__ = __repr__

class stateid4:
    # XDR definition:
    # struct stateid4 {
    #     uint32_t seqid;
    #     opaque other[12];
    # };
    def __init__(self, seqid=None, other=None):
        self.seqid = seqid
        self.other = other

    def __repr__(self):
        out = []
        if self.seqid is not None:
            out += ['seqid=%s' % repr(self.seqid)]
        if self.other is not None:
            out += ['other=%s' % repr(self.other)]
        return 'stateid4(%s)' % ', '.join(out)
    __str__ = __repr__

class layout_content4:
    # XDR definition:
    # struct layout_content4 {
    #     layouttype4 loc_type;
    #     opaque loc_body<>;
    # };
    def __init__(self, loc_type=None, loc_body=None):
        self.loc_type = loc_type
        self.loc_body = loc_body

    def __repr__(self):
        out = []
        if self.loc_type is not None:
            out += ['loc_type=%s' % const.layouttype4.get(self.loc_type, self.loc_type)]
        if self.loc_body is not None:
            out += ['loc_body=%s' % repr(self.loc_body)]
        return 'layout_content4(%s)' % ', '.join(out)
    __str__ = __repr__

class layouthint4:
    # XDR definition:
    # struct layouthint4 {
    #     layouttype4 loh_type;
    #     opaque loh_body<>;
    # };
    def __init__(self, loh_type=None, loh_body=None):
        self.loh_type = loh_type
        self.loh_body = loh_body

    def __repr__(self):
        out = []
        if self.loh_type is not None:
            out += ['loh_type=%s' % const.layouttype4.get(self.loh_type, self.loh_type)]
        if self.loh_body is not None:
            out += ['loh_body=%s' % repr(self.loh_body)]
        return 'layouthint4(%s)' % ', '.join(out)
    __str__ = __repr__

class layout4:
    # XDR definition:
    # struct layout4 {
    #     offset4 lo_offset;
    #     length4 lo_length;
    #     layoutiomode4 lo_iomode;
    #     layout_content4 lo_content;
    # };
    def __init__(self, lo_offset=None, lo_length=None, lo_iomode=None, lo_content=None):
        self.lo_offset = lo_offset
        self.lo_length = lo_length
        self.lo_iomode = lo_iomode
        self.lo_content = lo_content

    def __getattr__(self, attr):
        return getattr(self.lo_content, attr)

    def __repr__(self):
        out = []
        if self.lo_offset is not None:
            out += ['lo_offset=%s' % repr(self.lo_offset)]
        if self.lo_length is not None:
            out += ['lo_length=%s' % repr(self.lo_length)]
        if self.lo_iomode is not None:
            out += ['lo_iomode=%s' % const.layoutiomode4.get(self.lo_iomode, self.lo_iomode)]
        if self.lo_content is not None:
            out += ['lo_content=%s' % repr(self.lo_content)]
        return 'layout4(%s)' % ', '.join(out)
    __str__ = __repr__

class device_addr4:
    # XDR definition:
    # struct device_addr4 {
    #     layouttype4 da_layout_type;
    #     opaque da_addr_body<>;
    # };
    def __init__(self, da_layout_type=None, da_addr_body=None):
        self.da_layout_type = da_layout_type
        self.da_addr_body = da_addr_body

    def __repr__(self):
        out = []
        if self.da_layout_type is not None:
            out += ['da_layout_type=%s' % const.layouttype4.get(self.da_layout_type, self.da_layout_type)]
        if self.da_addr_body is not None:
            out += ['da_addr_body=%s' % repr(self.da_addr_body)]
        return 'device_addr4(%s)' % ', '.join(out)
    __str__ = __repr__

class layoutupdate4:
    # XDR definition:
    # struct layoutupdate4 {
    #     layouttype4 lou_type;
    #     opaque lou_body<>;
    # };
    def __init__(self, lou_type=None, lou_body=None):
        self.lou_type = lou_type
        self.lou_body = lou_body

    def __repr__(self):
        out = []
        if self.lou_type is not None:
            out += ['lou_type=%s' % const.layouttype4.get(self.lou_type, self.lou_type)]
        if self.lou_body is not None:
            out += ['lou_body=%s' % repr(self.lou_body)]
        return 'layoutupdate4(%s)' % ', '.join(out)
    __str__ = __repr__

class layoutreturn_file4:
    # XDR definition:
    # struct layoutreturn_file4 {
    #     offset4 lrf_offset;
    #     length4 lrf_length;
    #     stateid4 lrf_stateid;
    #     opaque lrf_body<>;
    # };
    def __init__(self, lrf_offset=None, lrf_length=None, lrf_stateid=None, lrf_body=None):
        self.lrf_offset = lrf_offset
        self.lrf_length = lrf_length
        self.lrf_stateid = lrf_stateid
        self.lrf_body = lrf_body

    def __getattr__(self, attr):
        return getattr(self.lrf_stateid, attr)

    def __repr__(self):
        out = []
        if self.lrf_offset is not None:
            out += ['lrf_offset=%s' % repr(self.lrf_offset)]
        if self.lrf_length is not None:
            out += ['lrf_length=%s' % repr(self.lrf_length)]
        if self.lrf_stateid is not None:
            out += ['lrf_stateid=%s' % repr(self.lrf_stateid)]
        if self.lrf_body is not None:
            out += ['lrf_body=%s' % repr(self.lrf_body)]
        return 'layoutreturn_file4(%s)' % ', '.join(out)
    __str__ = __repr__

class layoutreturn4:
    # XDR definition:
    # union layoutreturn4 switch(layoutreturn_type4 lr_returntype) {
    #     case LAYOUTRETURN4_FILE:
    #         layoutreturn_file4 lr_layout;
    #     default:
    #         void;
    # };
    def __init__(self, lr_returntype=None, lr_layout=None):
        self.lr_returntype = lr_returntype
        self.lr_layout = lr_layout

    switch = property(lambda s: {const.LAYOUTRETURN4_FILE:s.lr_layout,}.get(s.lr_returntype, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.lr_returntype is not None:
            out += ['lr_returntype=%s' % const.layoutreturn_type4.get(self.lr_returntype, self.lr_returntype)]
        if self.lr_layout is not None:
            out += ['lr_layout=%s' % repr(self.lr_layout)]
        return 'layoutreturn4(%s)' % ', '.join(out)
    __str__ = __repr__

class fs4_status:
    # XDR definition:
    # struct fs4_status {
    #     bool fss_absent;
    #     fs4_status_type fss_type;
    #     utf8str_cs fss_source;
    #     utf8str_cs fss_current;
    #     int32_t fss_age;
    #     nfstime4 fss_version;
    # };
    def __init__(self, fss_absent=None, fss_type=None, fss_source=None, fss_current=None, fss_age=None, fss_version=None):
        self.fss_absent = fss_absent
        self.fss_type = fss_type
        self.fss_source = fss_source
        self.fss_current = fss_current
        self.fss_age = fss_age
        self.fss_version = fss_version

    def __getattr__(self, attr):
        return getattr(self.fss_version, attr)

    def __repr__(self):
        out = []
        if self.fss_absent is not None:
            out += ['fss_absent=%s' % repr(self.fss_absent)]
        if self.fss_type is not None:
            out += ['fss_type=%s' % const.fs4_status_type.get(self.fss_type, self.fss_type)]
        if self.fss_source is not None:
            out += ['fss_source=%s' % repr(self.fss_source)]
        if self.fss_current is not None:
            out += ['fss_current=%s' % repr(self.fss_current)]
        if self.fss_age is not None:
            out += ['fss_age=%s' % repr(self.fss_age)]
        if self.fss_version is not None:
            out += ['fss_version=%s' % repr(self.fss_version)]
        return 'fs4_status(%s)' % ', '.join(out)
    __str__ = __repr__

class threshold_item4:
    # XDR definition:
    # struct threshold_item4 {
    #     layouttype4 thi_layout_type;
    #     bitmap4 thi_hintset;
    #     opaque thi_hintlist<>;
    # };
    def __init__(self, thi_layout_type=None, thi_hintset=None, thi_hintlist=None):
        self.thi_layout_type = thi_layout_type
        self.thi_hintset = thi_hintset
        self.thi_hintlist = thi_hintlist

    def __repr__(self):
        out = []
        if self.thi_layout_type is not None:
            out += ['thi_layout_type=%s' % const.layouttype4.get(self.thi_layout_type, self.thi_layout_type)]
        if self.thi_hintset is not None:
            out += ['thi_hintset=%s' % repr(self.thi_hintset)]
        if self.thi_hintlist is not None:
            out += ['thi_hintlist=%s' % repr(self.thi_hintlist)]
        return 'threshold_item4(%s)' % ', '.join(out)
    __str__ = __repr__

class mdsthreshold4:
    # XDR definition:
    # struct mdsthreshold4 {
    #     threshold_item4 mth_hints<>;
    # };
    def __init__(self, mth_hints=None):
        self.mth_hints = mth_hints

    def __repr__(self):
        out = []
        if self.mth_hints is not None:
            out += ['mth_hints=%s' % repr(self.mth_hints)]
        return 'mdsthreshold4(%s)' % ', '.join(out)
    __str__ = __repr__

class retention_get4:
    # XDR definition:
    # struct retention_get4 {
    #     uint64_t rg_duration;
    #     nfstime4 rg_begin_time<1>;
    # };
    def __init__(self, rg_duration=None, rg_begin_time=None):
        self.rg_duration = rg_duration
        self.rg_begin_time = rg_begin_time

    def __repr__(self):
        out = []
        if self.rg_duration is not None:
            out += ['rg_duration=%s' % repr(self.rg_duration)]
        if self.rg_begin_time is not None:
            out += ['rg_begin_time=%s' % repr(self.rg_begin_time)]
        return 'retention_get4(%s)' % ', '.join(out)
    __str__ = __repr__

class retention_set4:
    # XDR definition:
    # struct retention_set4 {
    #     bool rs_enable;
    #     uint64_t rs_duration<1>;
    # };
    def __init__(self, rs_enable=None, rs_duration=None):
        self.rs_enable = rs_enable
        self.rs_duration = rs_duration

    def __repr__(self):
        out = []
        if self.rs_enable is not None:
            out += ['rs_enable=%s' % repr(self.rs_enable)]
        if self.rs_duration is not None:
            out += ['rs_duration=%s' % repr(self.rs_duration)]
        return 'retention_set4(%s)' % ', '.join(out)
    __str__ = __repr__

fattr4_type = const.nfs_ftype4
fattr4_fsid = fsid4
fattr4_rdattr_error = const.nfsstat4
fattr4_fs_locations = fs_locations4
fattr4_mode_set_masked = mode_masked4
fattr4_rawdev = specdata4
fattr4_time_access = nfstime4
fattr4_time_access_set = settime4
fattr4_time_backup = nfstime4
fattr4_time_create = nfstime4
fattr4_time_delta = nfstime4
fattr4_time_metadata = nfstime4
fattr4_time_modify = nfstime4
fattr4_time_modify_set = settime4
fattr4_dir_notif_delay = nfstime4
fattr4_dirent_notif_delay = nfstime4
fattr4_fs_status = fs4_status
fattr4_layout_hint = layouthint4
fattr4_mdsthreshold = mdsthreshold4
fattr4_retention_get = retention_get4
fattr4_retention_set = retention_set4
fattr4_retentevt_get = retention_get4
fattr4_retentevt_set = retention_set4
fattr4_dacl = nfsacl41
fattr4_sacl = nfsacl41
class fattr4:
    # XDR definition:
    # struct fattr4 {
    #     bitmap4 attrmask;
    #     attrlist4 attr_vals;
    # };
    def __init__(self, attrmask=None, attr_vals=None):
        self.attrmask = attrmask
        self.attr_vals = attr_vals

    def __repr__(self):
        out = []
        if self.attrmask is not None:
            out += ['attrmask=%s' % repr(self.attrmask)]
        if self.attr_vals is not None:
            out += ['attr_vals=%s' % repr(self.attr_vals)]
        return 'fattr4(%s)' % ', '.join(out)
    __str__ = __repr__

class change_info4:
    # XDR definition:
    # struct change_info4 {
    #     bool atomic;
    #     changeid4 before;
    #     changeid4 after;
    # };
    def __init__(self, atomic=None, before=None, after=None):
        self.atomic = atomic
        self.before = before
        self.after = after

    def __repr__(self):
        out = []
        if self.atomic is not None:
            out += ['atomic=%s' % repr(self.atomic)]
        if self.before is not None:
            out += ['before=%s' % repr(self.before)]
        if self.after is not None:
            out += ['after=%s' % repr(self.after)]
        return 'change_info4(%s)' % ', '.join(out)
    __str__ = __repr__

clientaddr4 = netaddr4
class cb_client4:
    # XDR definition:
    # struct cb_client4 {
    #     uint32_t cb_program;
    #     netaddr4 cb_location;
    # };
    def __init__(self, cb_program=None, cb_location=None):
        self.cb_program = cb_program
        self.cb_location = cb_location

    def __getattr__(self, attr):
        return getattr(self.cb_location, attr)

    def __repr__(self):
        out = []
        if self.cb_program is not None:
            out += ['cb_program=%s' % repr(self.cb_program)]
        if self.cb_location is not None:
            out += ['cb_location=%s' % repr(self.cb_location)]
        return 'cb_client4(%s)' % ', '.join(out)
    __str__ = __repr__

class nfs_client_id4:
    # XDR definition:
    # struct nfs_client_id4 {
    #     verifier4 verifier;
    #     opaque id<NFS4_OPAQUE_LIMIT>;
    # };
    def __init__(self, verifier=None, id=None):
        self.verifier = verifier
        self.id = id

    def __repr__(self):
        out = []
        if self.verifier is not None:
            out += ['verifier=%s' % repr(self.verifier)]
        if self.id is not None:
            out += ['id=%s' % repr(self.id)]
        return 'nfs_client_id4(%s)' % ', '.join(out)
    __str__ = __repr__

class client_owner4:
    # XDR definition:
    # struct client_owner4 {
    #     verifier4 co_verifier;
    #     opaque co_ownerid<NFS4_OPAQUE_LIMIT>;
    # };
    def __init__(self, co_verifier=None, co_ownerid=None):
        self.co_verifier = co_verifier
        self.co_ownerid = co_ownerid

    def __repr__(self):
        out = []
        if self.co_verifier is not None:
            out += ['co_verifier=%s' % repr(self.co_verifier)]
        if self.co_ownerid is not None:
            out += ['co_ownerid=%s' % repr(self.co_ownerid)]
        return 'client_owner4(%s)' % ', '.join(out)
    __str__ = __repr__

class server_owner4:
    # XDR definition:
    # struct server_owner4 {
    #     uint64_t so_minor_id;
    #     opaque so_major_id<NFS4_OPAQUE_LIMIT>;
    # };
    def __init__(self, so_minor_id=None, so_major_id=None):
        self.so_minor_id = so_minor_id
        self.so_major_id = so_major_id

    def __repr__(self):
        out = []
        if self.so_minor_id is not None:
            out += ['so_minor_id=%s' % repr(self.so_minor_id)]
        if self.so_major_id is not None:
            out += ['so_major_id=%s' % repr(self.so_major_id)]
        return 'server_owner4(%s)' % ', '.join(out)
    __str__ = __repr__

class state_owner4:
    # XDR definition:
    # struct state_owner4 {
    #     clientid4 clientid;
    #     opaque owner<NFS4_OPAQUE_LIMIT>;
    # };
    def __init__(self, clientid=None, owner=None):
        self.clientid = clientid
        self.owner = owner

    def __repr__(self):
        out = []
        if self.clientid is not None:
            out += ['clientid=%s' % repr(self.clientid)]
        if self.owner is not None:
            out += ['owner=%s' % repr(self.owner)]
        return 'state_owner4(%s)' % ', '.join(out)
    __str__ = __repr__

open_owner4 = state_owner4
lock_owner4 = state_owner4
class ssv_mic_plain_tkn4:
    # XDR definition:
    # struct ssv_mic_plain_tkn4 {
    #     uint32_t smpt_ssv_seq;
    #     opaque smpt_orig_plain<>;
    # };
    def __init__(self, smpt_ssv_seq=None, smpt_orig_plain=None):
        self.smpt_ssv_seq = smpt_ssv_seq
        self.smpt_orig_plain = smpt_orig_plain

    def __repr__(self):
        out = []
        if self.smpt_ssv_seq is not None:
            out += ['smpt_ssv_seq=%s' % repr(self.smpt_ssv_seq)]
        if self.smpt_orig_plain is not None:
            out += ['smpt_orig_plain=%s' % repr(self.smpt_orig_plain)]
        return 'ssv_mic_plain_tkn4(%s)' % ', '.join(out)
    __str__ = __repr__

class ssv_mic_tkn4:
    # XDR definition:
    # struct ssv_mic_tkn4 {
    #     uint32_t smt_ssv_seq;
    #     opaque smt_hmac<>;
    # };
    def __init__(self, smt_ssv_seq=None, smt_hmac=None):
        self.smt_ssv_seq = smt_ssv_seq
        self.smt_hmac = smt_hmac

    def __repr__(self):
        out = []
        if self.smt_ssv_seq is not None:
            out += ['smt_ssv_seq=%s' % repr(self.smt_ssv_seq)]
        if self.smt_hmac is not None:
            out += ['smt_hmac=%s' % repr(self.smt_hmac)]
        return 'ssv_mic_tkn4(%s)' % ', '.join(out)
    __str__ = __repr__

class ssv_seal_plain_tkn4:
    # XDR definition:
    # struct ssv_seal_plain_tkn4 {
    #     opaque sspt_confounder<>;
    #     uint32_t sspt_ssv_seq;
    #     opaque sspt_orig_plain<>;
    #     opaque sspt_pad<>;
    # };
    def __init__(self, sspt_confounder=None, sspt_ssv_seq=None, sspt_orig_plain=None, sspt_pad=None):
        self.sspt_confounder = sspt_confounder
        self.sspt_ssv_seq = sspt_ssv_seq
        self.sspt_orig_plain = sspt_orig_plain
        self.sspt_pad = sspt_pad

    def __repr__(self):
        out = []
        if self.sspt_confounder is not None:
            out += ['sspt_confounder=%s' % repr(self.sspt_confounder)]
        if self.sspt_ssv_seq is not None:
            out += ['sspt_ssv_seq=%s' % repr(self.sspt_ssv_seq)]
        if self.sspt_orig_plain is not None:
            out += ['sspt_orig_plain=%s' % repr(self.sspt_orig_plain)]
        if self.sspt_pad is not None:
            out += ['sspt_pad=%s' % repr(self.sspt_pad)]
        return 'ssv_seal_plain_tkn4(%s)' % ', '.join(out)
    __str__ = __repr__

class ssv_seal_cipher_tkn4:
    # XDR definition:
    # struct ssv_seal_cipher_tkn4 {
    #     uint32_t ssct_ssv_seq;
    #     opaque ssct_iv<>;
    #     opaque ssct_encr_data<>;
    #     opaque ssct_hmac<>;
    # };
    def __init__(self, ssct_ssv_seq=None, ssct_iv=None, ssct_encr_data=None, ssct_hmac=None):
        self.ssct_ssv_seq = ssct_ssv_seq
        self.ssct_iv = ssct_iv
        self.ssct_encr_data = ssct_encr_data
        self.ssct_hmac = ssct_hmac

    def __repr__(self):
        out = []
        if self.ssct_ssv_seq is not None:
            out += ['ssct_ssv_seq=%s' % repr(self.ssct_ssv_seq)]
        if self.ssct_iv is not None:
            out += ['ssct_iv=%s' % repr(self.ssct_iv)]
        if self.ssct_encr_data is not None:
            out += ['ssct_encr_data=%s' % repr(self.ssct_encr_data)]
        if self.ssct_hmac is not None:
            out += ['ssct_hmac=%s' % repr(self.ssct_hmac)]
        return 'ssv_seal_cipher_tkn4(%s)' % ', '.join(out)
    __str__ = __repr__

class fs_locations_server4:
    # XDR definition:
    # struct fs_locations_server4 {
    #     int32_t fls_currency;
    #     opaque fls_info<>;
    #     utf8str_cis fls_server;
    # };
    def __init__(self, fls_currency=None, fls_info=None, fls_server=None):
        self.fls_currency = fls_currency
        self.fls_info = fls_info
        self.fls_server = fls_server

    def __repr__(self):
        out = []
        if self.fls_currency is not None:
            out += ['fls_currency=%s' % repr(self.fls_currency)]
        if self.fls_info is not None:
            out += ['fls_info=%s' % repr(self.fls_info)]
        if self.fls_server is not None:
            out += ['fls_server=%s' % repr(self.fls_server)]
        return 'fs_locations_server4(%s)' % ', '.join(out)
    __str__ = __repr__

class fs_locations_item4:
    # XDR definition:
    # struct fs_locations_item4 {
    #     fs_locations_server4 fli_entries<>;
    #     pathname4 fli_rootpath;
    # };
    def __init__(self, fli_entries=None, fli_rootpath=None):
        self.fli_entries = fli_entries
        self.fli_rootpath = fli_rootpath

    def __repr__(self):
        out = []
        if self.fli_entries is not None:
            out += ['fli_entries=%s' % repr(self.fli_entries)]
        if self.fli_rootpath is not None:
            out += ['fli_rootpath=%s' % repr(self.fli_rootpath)]
        return 'fs_locations_item4(%s)' % ', '.join(out)
    __str__ = __repr__

class fs_locations_info4:
    # XDR definition:
    # struct fs_locations_info4 {
    #     uint32_t fli_flags;
    #     int32_t fli_valid_for;
    #     pathname4 fli_fs_root;
    #     fs_locations_item4 fli_items<>;
    # };
    def __init__(self, fli_flags=None, fli_valid_for=None, fli_fs_root=None, fli_items=None):
        self.fli_flags = fli_flags
        self.fli_valid_for = fli_valid_for
        self.fli_fs_root = fli_fs_root
        self.fli_items = fli_items

    def __repr__(self):
        out = []
        if self.fli_flags is not None:
            out += ['fli_flags=%s' % repr(self.fli_flags)]
        if self.fli_valid_for is not None:
            out += ['fli_valid_for=%s' % repr(self.fli_valid_for)]
        if self.fli_fs_root is not None:
            out += ['fli_fs_root=%s' % repr(self.fli_fs_root)]
        if self.fli_items is not None:
            out += ['fli_items=%s' % repr(self.fli_items)]
        return 'fs_locations_info4(%s)' % ', '.join(out)
    __str__ = __repr__

fattr4_fs_locations_info = fs_locations_info4
class nfsv4_1_file_layouthint4:
    # XDR definition:
    # struct nfsv4_1_file_layouthint4 {
    #     uint32_t nflh_care;
    #     nfl_util4 nflh_util;
    #     count4 nflh_stripe_count;
    # };
    def __init__(self, nflh_care=None, nflh_util=None, nflh_stripe_count=None):
        self.nflh_care = nflh_care
        self.nflh_util = nflh_util
        self.nflh_stripe_count = nflh_stripe_count

    def __repr__(self):
        out = []
        if self.nflh_care is not None:
            out += ['nflh_care=%s' % repr(self.nflh_care)]
        if self.nflh_util is not None:
            out += ['nflh_util=%s' % repr(self.nflh_util)]
        if self.nflh_stripe_count is not None:
            out += ['nflh_stripe_count=%s' % repr(self.nflh_stripe_count)]
        return 'nfsv4_1_file_layouthint4(%s)' % ', '.join(out)
    __str__ = __repr__

class nfsv4_1_file_layout_ds_addr4:
    # XDR definition:
    # struct nfsv4_1_file_layout_ds_addr4 {
    #     uint32_t nflda_stripe_indices<>;
    #     multipath_list4 nflda_multipath_ds_list<>;
    # };
    def __init__(self, nflda_stripe_indices=None, nflda_multipath_ds_list=None):
        self.nflda_stripe_indices = nflda_stripe_indices
        self.nflda_multipath_ds_list = nflda_multipath_ds_list

    def __repr__(self):
        out = []
        if self.nflda_stripe_indices is not None:
            out += ['nflda_stripe_indices=%s' % repr(self.nflda_stripe_indices)]
        if self.nflda_multipath_ds_list is not None:
            out += ['nflda_multipath_ds_list=%s' % repr(self.nflda_multipath_ds_list)]
        return 'nfsv4_1_file_layout_ds_addr4(%s)' % ', '.join(out)
    __str__ = __repr__

class nfsv4_1_file_layout4:
    # XDR definition:
    # struct nfsv4_1_file_layout4 {
    #     deviceid4 nfl_deviceid;
    #     nfl_util4 nfl_util;
    #     uint32_t nfl_first_stripe_index;
    #     offset4 nfl_pattern_offset;
    #     nfs_fh4 nfl_fh_list<>;
    # };
    def __init__(self, nfl_deviceid=None, nfl_util=None, nfl_first_stripe_index=None, nfl_pattern_offset=None, nfl_fh_list=None):
        self.nfl_deviceid = nfl_deviceid
        self.nfl_util = nfl_util
        self.nfl_first_stripe_index = nfl_first_stripe_index
        self.nfl_pattern_offset = nfl_pattern_offset
        self.nfl_fh_list = nfl_fh_list

    def __repr__(self):
        out = []
        if self.nfl_deviceid is not None:
            out += ['nfl_deviceid=%s' % repr(self.nfl_deviceid)]
        if self.nfl_util is not None:
            out += ['nfl_util=%s' % repr(self.nfl_util)]
        if self.nfl_first_stripe_index is not None:
            out += ['nfl_first_stripe_index=%s' % repr(self.nfl_first_stripe_index)]
        if self.nfl_pattern_offset is not None:
            out += ['nfl_pattern_offset=%s' % repr(self.nfl_pattern_offset)]
        if self.nfl_fh_list is not None:
            out += ['nfl_fh_list=%s' % repr(self.nfl_fh_list)]
        return 'nfsv4_1_file_layout4(%s)' % ', '.join(out)
    __str__ = __repr__

class ACCESS4args:
    # XDR definition:
    # struct ACCESS4args {
    #     uint32_t access;
    # };
    def __init__(self, access=None):
        self.access = access

    def __repr__(self):
        out = []
        if self.access is not None:
            out += ['access=%s' % repr(self.access)]
        return 'ACCESS4args(%s)' % ', '.join(out)
    __str__ = __repr__

class ACCESS4resok:
    # XDR definition:
    # struct ACCESS4resok {
    #     uint32_t supported;
    #     uint32_t access;
    # };
    def __init__(self, supported=None, access=None):
        self.supported = supported
        self.access = access

    def __repr__(self):
        out = []
        if self.supported is not None:
            out += ['supported=%s' % repr(self.supported)]
        if self.access is not None:
            out += ['access=%s' % repr(self.access)]
        return 'ACCESS4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class ACCESS4res:
    # XDR definition:
    # union ACCESS4res switch(nfsstat4 status) {
    #     case NFS4_OK:
    #         ACCESS4resok resok4;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, resok4=None):
        self.status = status
        self.resok4 = resok4

    switch = property(lambda s: {const.NFS4_OK:s.resok4,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.resok4 is not None:
            out += ['resok4=%s' % repr(self.resok4)]
        return 'ACCESS4res(%s)' % ', '.join(out)
    __str__ = __repr__

class CLOSE4args:
    # XDR definition:
    # struct CLOSE4args {
    #     seqid4 seqid;
    #     stateid4 open_stateid;
    # };
    def __init__(self, seqid=None, open_stateid=None):
        self.seqid = seqid
        self.open_stateid = open_stateid

    def __getattr__(self, attr):
        return getattr(self.open_stateid, attr)

    def __repr__(self):
        out = []
        if self.seqid is not None:
            out += ['seqid=%s' % repr(self.seqid)]
        if self.open_stateid is not None:
            out += ['open_stateid=%s' % repr(self.open_stateid)]
        return 'CLOSE4args(%s)' % ', '.join(out)
    __str__ = __repr__

class CLOSE4res:
    # XDR definition:
    # union CLOSE4res switch(nfsstat4 status) {
    #     case NFS4_OK:
    #         stateid4 open_stateid;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, open_stateid=None):
        self.status = status
        self.open_stateid = open_stateid

    switch = property(lambda s: {const.NFS4_OK:s.open_stateid,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.open_stateid is not None:
            out += ['open_stateid=%s' % repr(self.open_stateid)]
        return 'CLOSE4res(%s)' % ', '.join(out)
    __str__ = __repr__

class COMMIT4args:
    # XDR definition:
    # struct COMMIT4args {
    #     offset4 offset;
    #     count4 count;
    # };
    def __init__(self, offset=None, count=None):
        self.offset = offset
        self.count = count

    def __repr__(self):
        out = []
        if self.offset is not None:
            out += ['offset=%s' % repr(self.offset)]
        if self.count is not None:
            out += ['count=%s' % repr(self.count)]
        return 'COMMIT4args(%s)' % ', '.join(out)
    __str__ = __repr__

class COMMIT4resok:
    # XDR definition:
    # struct COMMIT4resok {
    #     verifier4 writeverf;
    # };
    def __init__(self, writeverf=None):
        self.writeverf = writeverf

    def __repr__(self):
        out = []
        if self.writeverf is not None:
            out += ['writeverf=%s' % repr(self.writeverf)]
        return 'COMMIT4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class COMMIT4res:
    # XDR definition:
    # union COMMIT4res switch(nfsstat4 status) {
    #     case NFS4_OK:
    #         COMMIT4resok resok4;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, resok4=None):
        self.status = status
        self.resok4 = resok4

    switch = property(lambda s: {const.NFS4_OK:s.resok4,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.resok4 is not None:
            out += ['resok4=%s' % repr(self.resok4)]
        return 'COMMIT4res(%s)' % ', '.join(out)
    __str__ = __repr__

class createtype4:
    # XDR definition:
    # union createtype4 switch(nfs_ftype4 type) {
    #     case NF4LNK:
    #         linktext4 linkdata;
    #     case NF4BLK:
    #     case NF4CHR:
    #         specdata4 devdata;
    #     case NF4SOCK:
    #     case NF4FIFO:
    #     case NF4DIR:
    #         void;
    #     default:
    #         void;
    # };
    def __init__(self, type=None, linkdata=None, devdata=None):
        self.type = type
        self.linkdata = linkdata
        self.devdata = devdata

    switch = property(lambda s: {const.NF4LNK:s.linkdata,const.NF4BLK:s.devdata,const.NF4CHR:s.devdata,const.NF4SOCK:None,const.NF4FIFO:None,const.NF4DIR:None,}.get(s.type, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.type is not None:
            out += ['type=%s' % const.nfs_ftype4.get(self.type, self.type)]
        if self.linkdata is not None:
            out += ['linkdata=%s' % repr(self.linkdata)]
        if self.devdata is not None:
            out += ['devdata=%s' % repr(self.devdata)]
        return 'createtype4(%s)' % ', '.join(out)
    __str__ = __repr__

class CREATE4args:
    # XDR definition:
    # struct CREATE4args {
    #     createtype4 objtype;
    #     component4 objname;
    #     fattr4 createattrs;
    # };
    def __init__(self, objtype=None, objname=None, createattrs=None):
        self.objtype = objtype
        self.objname = objname
        self.createattrs = createattrs

    def __repr__(self):
        out = []
        if self.objtype is not None:
            out += ['objtype=%s' % repr(self.objtype)]
        if self.objname is not None:
            out += ['objname=%s' % repr(self.objname)]
        if self.createattrs is not None:
            out += ['createattrs=%s' % repr(self.createattrs)]
        return 'CREATE4args(%s)' % ', '.join(out)
    __str__ = __repr__

class CREATE4resok:
    # XDR definition:
    # struct CREATE4resok {
    #     change_info4 cinfo;
    #     bitmap4 attrset;
    # };
    def __init__(self, cinfo=None, attrset=None):
        self.cinfo = cinfo
        self.attrset = attrset

    def __getattr__(self, attr):
        return getattr(self.cinfo, attr)

    def __repr__(self):
        out = []
        if self.cinfo is not None:
            out += ['cinfo=%s' % repr(self.cinfo)]
        if self.attrset is not None:
            out += ['attrset=%s' % repr(self.attrset)]
        return 'CREATE4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class CREATE4res:
    # XDR definition:
    # union CREATE4res switch(nfsstat4 status) {
    #     case NFS4_OK:
    #         CREATE4resok resok4;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, resok4=None):
        self.status = status
        self.resok4 = resok4

    switch = property(lambda s: {const.NFS4_OK:s.resok4,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.resok4 is not None:
            out += ['resok4=%s' % repr(self.resok4)]
        return 'CREATE4res(%s)' % ', '.join(out)
    __str__ = __repr__

class DELEGPURGE4args:
    # XDR definition:
    # struct DELEGPURGE4args {
    #     clientid4 clientid;
    # };
    def __init__(self, clientid=None):
        self.clientid = clientid

    def __repr__(self):
        out = []
        if self.clientid is not None:
            out += ['clientid=%s' % repr(self.clientid)]
        return 'DELEGPURGE4args(%s)' % ', '.join(out)
    __str__ = __repr__

class DELEGPURGE4res:
    # XDR definition:
    # struct DELEGPURGE4res {
    #     nfsstat4 status;
    # };
    def __init__(self, status=None):
        self.status = status

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        return 'DELEGPURGE4res(%s)' % ', '.join(out)
    __str__ = __repr__

class DELEGRETURN4args:
    # XDR definition:
    # struct DELEGRETURN4args {
    #     stateid4 deleg_stateid;
    # };
    def __init__(self, deleg_stateid=None):
        self.deleg_stateid = deleg_stateid

    def __getattr__(self, attr):
        return getattr(self.deleg_stateid, attr)

    def __repr__(self):
        out = []
        if self.deleg_stateid is not None:
            out += ['deleg_stateid=%s' % repr(self.deleg_stateid)]
        return 'DELEGRETURN4args(%s)' % ', '.join(out)
    __str__ = __repr__

class DELEGRETURN4res:
    # XDR definition:
    # struct DELEGRETURN4res {
    #     nfsstat4 status;
    # };
    def __init__(self, status=None):
        self.status = status

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        return 'DELEGRETURN4res(%s)' % ', '.join(out)
    __str__ = __repr__

class GETATTR4args:
    # XDR definition:
    # struct GETATTR4args {
    #     bitmap4 attr_request;
    # };
    def __init__(self, attr_request=None):
        self.attr_request = attr_request

    def __repr__(self):
        out = []
        if self.attr_request is not None:
            out += ['attr_request=%s' % repr(self.attr_request)]
        return 'GETATTR4args(%s)' % ', '.join(out)
    __str__ = __repr__

class GETATTR4resok:
    # XDR definition:
    # struct GETATTR4resok {
    #     fattr4 obj_attributes;
    # };
    def __init__(self, obj_attributes=None):
        self.obj_attributes = obj_attributes

    def __getattr__(self, attr):
        return getattr(self.obj_attributes, attr)

    def __repr__(self):
        out = []
        if self.obj_attributes is not None:
            out += ['obj_attributes=%s' % repr(self.obj_attributes)]
        return 'GETATTR4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class GETATTR4res:
    # XDR definition:
    # union GETATTR4res switch(nfsstat4 status) {
    #     case NFS4_OK:
    #         GETATTR4resok resok4;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, resok4=None):
        self.status = status
        self.resok4 = resok4

    switch = property(lambda s: {const.NFS4_OK:s.resok4,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.resok4 is not None:
            out += ['resok4=%s' % repr(self.resok4)]
        return 'GETATTR4res(%s)' % ', '.join(out)
    __str__ = __repr__

class GETFH4resok:
    # XDR definition:
    # struct GETFH4resok {
    #     nfs_fh4 object;
    # };
    def __init__(self, object=None):
        self.object = object

    def __repr__(self):
        out = []
        if self.object is not None:
            out += ['object=%s' % repr(self.object)]
        return 'GETFH4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class GETFH4res:
    # XDR definition:
    # union GETFH4res switch(nfsstat4 status) {
    #     case NFS4_OK:
    #         GETFH4resok resok4;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, resok4=None):
        self.status = status
        self.resok4 = resok4

    switch = property(lambda s: {const.NFS4_OK:s.resok4,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.resok4 is not None:
            out += ['resok4=%s' % repr(self.resok4)]
        return 'GETFH4res(%s)' % ', '.join(out)
    __str__ = __repr__

class LINK4args:
    # XDR definition:
    # struct LINK4args {
    #     component4 newname;
    # };
    def __init__(self, newname=None):
        self.newname = newname

    def __repr__(self):
        out = []
        if self.newname is not None:
            out += ['newname=%s' % repr(self.newname)]
        return 'LINK4args(%s)' % ', '.join(out)
    __str__ = __repr__

class LINK4resok:
    # XDR definition:
    # struct LINK4resok {
    #     change_info4 cinfo;
    # };
    def __init__(self, cinfo=None):
        self.cinfo = cinfo

    def __getattr__(self, attr):
        return getattr(self.cinfo, attr)

    def __repr__(self):
        out = []
        if self.cinfo is not None:
            out += ['cinfo=%s' % repr(self.cinfo)]
        return 'LINK4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class LINK4res:
    # XDR definition:
    # union LINK4res switch(nfsstat4 status) {
    #     case NFS4_OK:
    #         LINK4resok resok4;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, resok4=None):
        self.status = status
        self.resok4 = resok4

    switch = property(lambda s: {const.NFS4_OK:s.resok4,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.resok4 is not None:
            out += ['resok4=%s' % repr(self.resok4)]
        return 'LINK4res(%s)' % ', '.join(out)
    __str__ = __repr__

class open_to_lock_owner4:
    # XDR definition:
    # struct open_to_lock_owner4 {
    #     seqid4 open_seqid;
    #     stateid4 open_stateid;
    #     seqid4 lock_seqid;
    #     lock_owner4 lock_owner;
    # };
    def __init__(self, open_seqid=None, open_stateid=None, lock_seqid=None, lock_owner=None):
        self.open_seqid = open_seqid
        self.open_stateid = open_stateid
        self.lock_seqid = lock_seqid
        self.lock_owner = lock_owner

    def __repr__(self):
        out = []
        if self.open_seqid is not None:
            out += ['open_seqid=%s' % repr(self.open_seqid)]
        if self.open_stateid is not None:
            out += ['open_stateid=%s' % repr(self.open_stateid)]
        if self.lock_seqid is not None:
            out += ['lock_seqid=%s' % repr(self.lock_seqid)]
        if self.lock_owner is not None:
            out += ['lock_owner=%s' % repr(self.lock_owner)]
        return 'open_to_lock_owner4(%s)' % ', '.join(out)
    __str__ = __repr__

class exist_lock_owner4:
    # XDR definition:
    # struct exist_lock_owner4 {
    #     stateid4 lock_stateid;
    #     seqid4 lock_seqid;
    # };
    def __init__(self, lock_stateid=None, lock_seqid=None):
        self.lock_stateid = lock_stateid
        self.lock_seqid = lock_seqid

    def __getattr__(self, attr):
        return getattr(self.lock_stateid, attr)

    def __repr__(self):
        out = []
        if self.lock_stateid is not None:
            out += ['lock_stateid=%s' % repr(self.lock_stateid)]
        if self.lock_seqid is not None:
            out += ['lock_seqid=%s' % repr(self.lock_seqid)]
        return 'exist_lock_owner4(%s)' % ', '.join(out)
    __str__ = __repr__

class locker4:
    # XDR definition:
    # union locker4 switch(bool new_lock_owner) {
    #     case TRUE:
    #         open_to_lock_owner4 open_owner;
    #     case FALSE:
    #         exist_lock_owner4 lock_owner;
    # };
    def __init__(self, new_lock_owner=None, open_owner=None, lock_owner=None):
        self.new_lock_owner = new_lock_owner
        self.open_owner = open_owner
        self.lock_owner = lock_owner

    switch = property(lambda s: {const.TRUE:s.open_owner,const.FALSE:s.lock_owner,}[s.new_lock_owner])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.new_lock_owner is not None:
            out += ['new_lock_owner=%s' % repr(self.new_lock_owner)]
        if self.open_owner is not None:
            out += ['open_owner=%s' % repr(self.open_owner)]
        if self.lock_owner is not None:
            out += ['lock_owner=%s' % repr(self.lock_owner)]
        return 'locker4(%s)' % ', '.join(out)
    __str__ = __repr__

class LOCK4args:
    # XDR definition:
    # struct LOCK4args {
    #     nfs_lock_type4 locktype;
    #     bool reclaim;
    #     offset4 offset;
    #     length4 length;
    #     locker4 locker;
    # };
    def __init__(self, locktype=None, reclaim=None, offset=None, length=None, locker=None):
        self.locktype = locktype
        self.reclaim = reclaim
        self.offset = offset
        self.length = length
        self.locker = locker

    def __getattr__(self, attr):
        return getattr(self.locker, attr)

    def __repr__(self):
        out = []
        if self.locktype is not None:
            out += ['locktype=%s' % const.nfs_lock_type4.get(self.locktype, self.locktype)]
        if self.reclaim is not None:
            out += ['reclaim=%s' % repr(self.reclaim)]
        if self.offset is not None:
            out += ['offset=%s' % repr(self.offset)]
        if self.length is not None:
            out += ['length=%s' % repr(self.length)]
        if self.locker is not None:
            out += ['locker=%s' % repr(self.locker)]
        return 'LOCK4args(%s)' % ', '.join(out)
    __str__ = __repr__

class LOCK4denied:
    # XDR definition:
    # struct LOCK4denied {
    #     offset4 offset;
    #     length4 length;
    #     nfs_lock_type4 locktype;
    #     lock_owner4 owner;
    # };
    def __init__(self, offset=None, length=None, locktype=None, owner=None):
        self.offset = offset
        self.length = length
        self.locktype = locktype
        self.owner = owner

    def __getattr__(self, attr):
        return getattr(self.owner, attr)

    def __repr__(self):
        out = []
        if self.offset is not None:
            out += ['offset=%s' % repr(self.offset)]
        if self.length is not None:
            out += ['length=%s' % repr(self.length)]
        if self.locktype is not None:
            out += ['locktype=%s' % const.nfs_lock_type4.get(self.locktype, self.locktype)]
        if self.owner is not None:
            out += ['owner=%s' % repr(self.owner)]
        return 'LOCK4denied(%s)' % ', '.join(out)
    __str__ = __repr__

class LOCK4resok:
    # XDR definition:
    # struct LOCK4resok {
    #     stateid4 lock_stateid;
    # };
    def __init__(self, lock_stateid=None):
        self.lock_stateid = lock_stateid

    def __getattr__(self, attr):
        return getattr(self.lock_stateid, attr)

    def __repr__(self):
        out = []
        if self.lock_stateid is not None:
            out += ['lock_stateid=%s' % repr(self.lock_stateid)]
        return 'LOCK4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class LOCK4res:
    # XDR definition:
    # union LOCK4res switch(nfsstat4 status) {
    #     case NFS4_OK:
    #         LOCK4resok resok4;
    #     case NFS4ERR_DENIED:
    #         LOCK4denied denied;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, resok4=None, denied=None):
        self.status = status
        self.resok4 = resok4
        self.denied = denied

    switch = property(lambda s: {const.NFS4_OK:s.resok4,const.NFS4ERR_DENIED:s.denied,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.resok4 is not None:
            out += ['resok4=%s' % repr(self.resok4)]
        if self.denied is not None:
            out += ['denied=%s' % repr(self.denied)]
        return 'LOCK4res(%s)' % ', '.join(out)
    __str__ = __repr__

class LOCKT4args:
    # XDR definition:
    # struct LOCKT4args {
    #     nfs_lock_type4 locktype;
    #     offset4 offset;
    #     length4 length;
    #     lock_owner4 owner;
    # };
    def __init__(self, locktype=None, offset=None, length=None, owner=None):
        self.locktype = locktype
        self.offset = offset
        self.length = length
        self.owner = owner

    def __getattr__(self, attr):
        return getattr(self.owner, attr)

    def __repr__(self):
        out = []
        if self.locktype is not None:
            out += ['locktype=%s' % const.nfs_lock_type4.get(self.locktype, self.locktype)]
        if self.offset is not None:
            out += ['offset=%s' % repr(self.offset)]
        if self.length is not None:
            out += ['length=%s' % repr(self.length)]
        if self.owner is not None:
            out += ['owner=%s' % repr(self.owner)]
        return 'LOCKT4args(%s)' % ', '.join(out)
    __str__ = __repr__

class LOCKT4res:
    # XDR definition:
    # union LOCKT4res switch(nfsstat4 status) {
    #     case NFS4ERR_DENIED:
    #         LOCK4denied denied;
    #     case NFS4_OK:
    #         void;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, denied=None):
        self.status = status
        self.denied = denied

    switch = property(lambda s: {const.NFS4ERR_DENIED:s.denied,const.NFS4_OK:None,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.denied is not None:
            out += ['denied=%s' % repr(self.denied)]
        return 'LOCKT4res(%s)' % ', '.join(out)
    __str__ = __repr__

class LOCKU4args:
    # XDR definition:
    # struct LOCKU4args {
    #     nfs_lock_type4 locktype;
    #     seqid4 seqid;
    #     stateid4 lock_stateid;
    #     offset4 offset;
    #     length4 length;
    # };
    def __init__(self, locktype=None, seqid=None, lock_stateid=None, offset=None, length=None):
        self.locktype = locktype
        self.seqid = seqid
        self.lock_stateid = lock_stateid
        self.offset = offset
        self.length = length

    def __getattr__(self, attr):
        return getattr(self.lock_stateid, attr)

    def __repr__(self):
        out = []
        if self.locktype is not None:
            out += ['locktype=%s' % const.nfs_lock_type4.get(self.locktype, self.locktype)]
        if self.seqid is not None:
            out += ['seqid=%s' % repr(self.seqid)]
        if self.lock_stateid is not None:
            out += ['lock_stateid=%s' % repr(self.lock_stateid)]
        if self.offset is not None:
            out += ['offset=%s' % repr(self.offset)]
        if self.length is not None:
            out += ['length=%s' % repr(self.length)]
        return 'LOCKU4args(%s)' % ', '.join(out)
    __str__ = __repr__

class LOCKU4res:
    # XDR definition:
    # union LOCKU4res switch(nfsstat4 status) {
    #     case NFS4_OK:
    #         stateid4 lock_stateid;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, lock_stateid=None):
        self.status = status
        self.lock_stateid = lock_stateid

    switch = property(lambda s: {const.NFS4_OK:s.lock_stateid,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.lock_stateid is not None:
            out += ['lock_stateid=%s' % repr(self.lock_stateid)]
        return 'LOCKU4res(%s)' % ', '.join(out)
    __str__ = __repr__

class LOOKUP4args:
    # XDR definition:
    # struct LOOKUP4args {
    #     component4 objname;
    # };
    def __init__(self, objname=None):
        self.objname = objname

    def __repr__(self):
        out = []
        if self.objname is not None:
            out += ['objname=%s' % repr(self.objname)]
        return 'LOOKUP4args(%s)' % ', '.join(out)
    __str__ = __repr__

class LOOKUP4res:
    # XDR definition:
    # struct LOOKUP4res {
    #     nfsstat4 status;
    # };
    def __init__(self, status=None):
        self.status = status

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        return 'LOOKUP4res(%s)' % ', '.join(out)
    __str__ = __repr__

class LOOKUPP4res:
    # XDR definition:
    # struct LOOKUPP4res {
    #     nfsstat4 status;
    # };
    def __init__(self, status=None):
        self.status = status

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        return 'LOOKUPP4res(%s)' % ', '.join(out)
    __str__ = __repr__

class NVERIFY4args:
    # XDR definition:
    # struct NVERIFY4args {
    #     fattr4 obj_attributes;
    # };
    def __init__(self, obj_attributes=None):
        self.obj_attributes = obj_attributes

    def __getattr__(self, attr):
        return getattr(self.obj_attributes, attr)

    def __repr__(self):
        out = []
        if self.obj_attributes is not None:
            out += ['obj_attributes=%s' % repr(self.obj_attributes)]
        return 'NVERIFY4args(%s)' % ', '.join(out)
    __str__ = __repr__

class NVERIFY4res:
    # XDR definition:
    # struct NVERIFY4res {
    #     nfsstat4 status;
    # };
    def __init__(self, status=None):
        self.status = status

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        return 'NVERIFY4res(%s)' % ', '.join(out)
    __str__ = __repr__

class creatverfattr:
    # XDR definition:
    # struct creatverfattr {
    #     verifier4 cva_verf;
    #     fattr4 cva_attrs;
    # };
    def __init__(self, cva_verf=None, cva_attrs=None):
        self.cva_verf = cva_verf
        self.cva_attrs = cva_attrs

    def __getattr__(self, attr):
        return getattr(self.cva_attrs, attr)

    def __repr__(self):
        out = []
        if self.cva_verf is not None:
            out += ['cva_verf=%s' % repr(self.cva_verf)]
        if self.cva_attrs is not None:
            out += ['cva_attrs=%s' % repr(self.cva_attrs)]
        return 'creatverfattr(%s)' % ', '.join(out)
    __str__ = __repr__

class createhow4:
    # XDR definition:
    # union createhow4 switch(createmode4 mode) {
    #     case UNCHECKED4:
    #     case GUARDED4:
    #         fattr4 createattrs;
    #     case EXCLUSIVE4:
    #         verifier4 createverf;
    #     case EXCLUSIVE4_1:
    #         creatverfattr ch_createboth;
    # };
    def __init__(self, mode=None, createattrs=None, createverf=None, ch_createboth=None):
        self.mode = mode
        self.createattrs = createattrs
        self.createverf = createverf
        self.ch_createboth = ch_createboth

    switch = property(lambda s: {const.UNCHECKED4:s.createattrs,const.GUARDED4:s.createattrs,const.EXCLUSIVE4:s.createverf,const.EXCLUSIVE4_1:s.ch_createboth,}[s.mode])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.mode is not None:
            out += ['mode=%s' % const.createmode4.get(self.mode, self.mode)]
        if self.createattrs is not None:
            out += ['createattrs=%s' % repr(self.createattrs)]
        if self.createverf is not None:
            out += ['createverf=%s' % repr(self.createverf)]
        if self.ch_createboth is not None:
            out += ['ch_createboth=%s' % repr(self.ch_createboth)]
        return 'createhow4(%s)' % ', '.join(out)
    __str__ = __repr__

class openflag4:
    # XDR definition:
    # union openflag4 switch(opentype4 opentype) {
    #     case OPEN4_CREATE:
    #         createhow4 how;
    #     default:
    #         void;
    # };
    def __init__(self, opentype=None, how=None):
        self.opentype = opentype
        self.how = how

    switch = property(lambda s: {const.OPEN4_CREATE:s.how,}.get(s.opentype, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.opentype is not None:
            out += ['opentype=%s' % const.opentype4.get(self.opentype, self.opentype)]
        if self.how is not None:
            out += ['how=%s' % repr(self.how)]
        return 'openflag4(%s)' % ', '.join(out)
    __str__ = __repr__

class nfs_modified_limit4:
    # XDR definition:
    # struct nfs_modified_limit4 {
    #     uint32_t num_blocks;
    #     uint32_t bytes_per_block;
    # };
    def __init__(self, num_blocks=None, bytes_per_block=None):
        self.num_blocks = num_blocks
        self.bytes_per_block = bytes_per_block

    def __repr__(self):
        out = []
        if self.num_blocks is not None:
            out += ['num_blocks=%s' % repr(self.num_blocks)]
        if self.bytes_per_block is not None:
            out += ['bytes_per_block=%s' % repr(self.bytes_per_block)]
        return 'nfs_modified_limit4(%s)' % ', '.join(out)
    __str__ = __repr__

class nfs_space_limit4:
    # XDR definition:
    # union nfs_space_limit4 switch(limit_by4 limitby) {
    #     case NFS_LIMIT_SIZE:
    #         uint64_t filesize;
    #     case NFS_LIMIT_BLOCKS:
    #         nfs_modified_limit4 mod_blocks;
    # };
    def __init__(self, limitby=None, filesize=None, mod_blocks=None):
        self.limitby = limitby
        self.filesize = filesize
        self.mod_blocks = mod_blocks

    switch = property(lambda s: {const.NFS_LIMIT_SIZE:s.filesize,const.NFS_LIMIT_BLOCKS:s.mod_blocks,}[s.limitby])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.limitby is not None:
            out += ['limitby=%s' % const.limit_by4.get(self.limitby, self.limitby)]
        if self.filesize is not None:
            out += ['filesize=%s' % repr(self.filesize)]
        if self.mod_blocks is not None:
            out += ['mod_blocks=%s' % repr(self.mod_blocks)]
        return 'nfs_space_limit4(%s)' % ', '.join(out)
    __str__ = __repr__

class open_claim_delegate_cur4:
    # XDR definition:
    # struct open_claim_delegate_cur4 {
    #     stateid4 delegate_stateid;
    #     component4 file;
    # };
    def __init__(self, delegate_stateid=None, file=None):
        self.delegate_stateid = delegate_stateid
        self.file = file

    def __getattr__(self, attr):
        return getattr(self.delegate_stateid, attr)

    def __repr__(self):
        out = []
        if self.delegate_stateid is not None:
            out += ['delegate_stateid=%s' % repr(self.delegate_stateid)]
        if self.file is not None:
            out += ['file=%s' % repr(self.file)]
        return 'open_claim_delegate_cur4(%s)' % ', '.join(out)
    __str__ = __repr__

class open_claim4:
    # XDR definition:
    # union open_claim4 switch(open_claim_type4 claim) {
    #     case CLAIM_NULL:
    #         component4 file;
    #     case CLAIM_PREVIOUS:
    #         open_delegation_type4 delegate_type;
    #     case CLAIM_DELEGATE_CUR:
    #         open_claim_delegate_cur4 delegate_cur_info;
    #     case CLAIM_DELEGATE_PREV:
    #         component4 file_delegate_prev;
    #     case CLAIM_FH:
    #         void;
    #     case CLAIM_DELEG_PREV_FH:
    #         void;
    #     case CLAIM_DELEG_CUR_FH:
    #         stateid4 oc_delegate_stateid;
    # };
    def __init__(self, claim=None, file=None, delegate_type=None, delegate_cur_info=None, file_delegate_prev=None, oc_delegate_stateid=None):
        self.claim = claim
        self.file = file
        self.delegate_type = delegate_type
        self.delegate_cur_info = delegate_cur_info
        self.file_delegate_prev = file_delegate_prev
        self.oc_delegate_stateid = oc_delegate_stateid

    switch = property(lambda s: {const.CLAIM_NULL:s.file,const.CLAIM_PREVIOUS:s.delegate_type,const.CLAIM_DELEGATE_CUR:s.delegate_cur_info,const.CLAIM_DELEGATE_PREV:s.file_delegate_prev,const.CLAIM_FH:None,const.CLAIM_DELEG_PREV_FH:None,const.CLAIM_DELEG_CUR_FH:s.oc_delegate_stateid,}[s.claim])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.claim is not None:
            out += ['claim=%s' % const.open_claim_type4.get(self.claim, self.claim)]
        if self.file is not None:
            out += ['file=%s' % repr(self.file)]
        if self.delegate_type is not None:
            out += ['delegate_type=%s' % const.open_delegation_type4.get(self.delegate_type, self.delegate_type)]
        if self.delegate_cur_info is not None:
            out += ['delegate_cur_info=%s' % repr(self.delegate_cur_info)]
        if self.file_delegate_prev is not None:
            out += ['file_delegate_prev=%s' % repr(self.file_delegate_prev)]
        if self.oc_delegate_stateid is not None:
            out += ['oc_delegate_stateid=%s' % repr(self.oc_delegate_stateid)]
        return 'open_claim4(%s)' % ', '.join(out)
    __str__ = __repr__

class OPEN4args:
    # XDR definition:
    # struct OPEN4args {
    #     seqid4 seqid;
    #     uint32_t share_access;
    #     uint32_t share_deny;
    #     open_owner4 owner;
    #     openflag4 openhow;
    #     open_claim4 claim;
    # };
    def __init__(self, seqid=None, share_access=None, share_deny=None, owner=None, openhow=None, claim=None):
        self.seqid = seqid
        self.share_access = share_access
        self.share_deny = share_deny
        self.owner = owner
        self.openhow = openhow
        self.claim = claim

    def __repr__(self):
        out = []
        if self.seqid is not None:
            out += ['seqid=%s' % repr(self.seqid)]
        if self.share_access is not None:
            out += ['share_access=%s' % repr(self.share_access)]
        if self.share_deny is not None:
            out += ['share_deny=%s' % repr(self.share_deny)]
        if self.owner is not None:
            out += ['owner=%s' % repr(self.owner)]
        if self.openhow is not None:
            out += ['openhow=%s' % repr(self.openhow)]
        if self.claim is not None:
            out += ['claim=%s' % repr(self.claim)]
        return 'OPEN4args(%s)' % ', '.join(out)
    __str__ = __repr__

class open_read_delegation4:
    # XDR definition:
    # struct open_read_delegation4 {
    #     stateid4 stateid;
    #     bool recall;
    #     nfsace4 permissions;
    # };
    def __init__(self, stateid=None, recall=None, permissions=None):
        self.stateid = stateid
        self.recall = recall
        self.permissions = permissions

    def __repr__(self):
        out = []
        if self.stateid is not None:
            out += ['stateid=%s' % repr(self.stateid)]
        if self.recall is not None:
            out += ['recall=%s' % repr(self.recall)]
        if self.permissions is not None:
            out += ['permissions=%s' % repr(self.permissions)]
        return 'open_read_delegation4(%s)' % ', '.join(out)
    __str__ = __repr__

class open_write_delegation4:
    # XDR definition:
    # struct open_write_delegation4 {
    #     stateid4 stateid;
    #     bool recall;
    #     nfs_space_limit4 space_limit;
    #     nfsace4 permissions;
    # };
    def __init__(self, stateid=None, recall=None, space_limit=None, permissions=None):
        self.stateid = stateid
        self.recall = recall
        self.space_limit = space_limit
        self.permissions = permissions

    def __repr__(self):
        out = []
        if self.stateid is not None:
            out += ['stateid=%s' % repr(self.stateid)]
        if self.recall is not None:
            out += ['recall=%s' % repr(self.recall)]
        if self.space_limit is not None:
            out += ['space_limit=%s' % repr(self.space_limit)]
        if self.permissions is not None:
            out += ['permissions=%s' % repr(self.permissions)]
        return 'open_write_delegation4(%s)' % ', '.join(out)
    __str__ = __repr__

class open_none_delegation4:
    # XDR definition:
    # union open_none_delegation4 switch(why_no_delegation4 ond_why) {
    #     case WND4_CONTENTION:
    #         bool ond_server_will_push_deleg;
    #     case WND4_RESOURCE:
    #         bool ond_server_will_signal_avail;
    #     default:
    #         void;
    # };
    def __init__(self, ond_why=None, ond_server_will_push_deleg=None, ond_server_will_signal_avail=None):
        self.ond_why = ond_why
        self.ond_server_will_push_deleg = ond_server_will_push_deleg
        self.ond_server_will_signal_avail = ond_server_will_signal_avail

    switch = property(lambda s: {const.WND4_CONTENTION:s.ond_server_will_push_deleg,const.WND4_RESOURCE:s.ond_server_will_signal_avail,}.get(s.ond_why, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.ond_why is not None:
            out += ['ond_why=%s' % const.why_no_delegation4.get(self.ond_why, self.ond_why)]
        if self.ond_server_will_push_deleg is not None:
            out += ['ond_server_will_push_deleg=%s' % repr(self.ond_server_will_push_deleg)]
        if self.ond_server_will_signal_avail is not None:
            out += ['ond_server_will_signal_avail=%s' % repr(self.ond_server_will_signal_avail)]
        return 'open_none_delegation4(%s)' % ', '.join(out)
    __str__ = __repr__

class open_delegation4:
    # XDR definition:
    # union open_delegation4 switch(open_delegation_type4 delegation_type) {
    #     case OPEN_DELEGATE_NONE:
    #         void;
    #     case OPEN_DELEGATE_READ:
    #         open_read_delegation4 read;
    #     case OPEN_DELEGATE_WRITE:
    #         open_write_delegation4 write;
    #     case OPEN_DELEGATE_NONE_EXT:
    #         open_none_delegation4 od_whynone;
    # };
    def __init__(self, delegation_type=None, read=None, write=None, od_whynone=None):
        self.delegation_type = delegation_type
        self.read = read
        self.write = write
        self.od_whynone = od_whynone

    switch = property(lambda s: {const.OPEN_DELEGATE_NONE:None,const.OPEN_DELEGATE_READ:s.read,const.OPEN_DELEGATE_WRITE:s.write,const.OPEN_DELEGATE_NONE_EXT:s.od_whynone,}[s.delegation_type])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.delegation_type is not None:
            out += ['delegation_type=%s' % const.open_delegation_type4.get(self.delegation_type, self.delegation_type)]
        if self.read is not None:
            out += ['read=%s' % repr(self.read)]
        if self.write is not None:
            out += ['write=%s' % repr(self.write)]
        if self.od_whynone is not None:
            out += ['od_whynone=%s' % repr(self.od_whynone)]
        return 'open_delegation4(%s)' % ', '.join(out)
    __str__ = __repr__

class OPEN4resok:
    # XDR definition:
    # struct OPEN4resok {
    #     stateid4 stateid;
    #     change_info4 cinfo;
    #     uint32_t rflags;
    #     bitmap4 attrset;
    #     open_delegation4 delegation;
    # };
    def __init__(self, stateid=None, cinfo=None, rflags=None, attrset=None, delegation=None):
        self.stateid = stateid
        self.cinfo = cinfo
        self.rflags = rflags
        self.attrset = attrset
        self.delegation = delegation

    def __repr__(self):
        out = []
        if self.stateid is not None:
            out += ['stateid=%s' % repr(self.stateid)]
        if self.cinfo is not None:
            out += ['cinfo=%s' % repr(self.cinfo)]
        if self.rflags is not None:
            out += ['rflags=%s' % repr(self.rflags)]
        if self.attrset is not None:
            out += ['attrset=%s' % repr(self.attrset)]
        if self.delegation is not None:
            out += ['delegation=%s' % repr(self.delegation)]
        return 'OPEN4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class OPEN4res:
    # XDR definition:
    # union OPEN4res switch(nfsstat4 status) {
    #     case NFS4_OK:
    #         OPEN4resok resok4;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, resok4=None):
        self.status = status
        self.resok4 = resok4

    switch = property(lambda s: {const.NFS4_OK:s.resok4,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.resok4 is not None:
            out += ['resok4=%s' % repr(self.resok4)]
        return 'OPEN4res(%s)' % ', '.join(out)
    __str__ = __repr__

class OPENATTR4args:
    # XDR definition:
    # struct OPENATTR4args {
    #     bool createdir;
    # };
    def __init__(self, createdir=None):
        self.createdir = createdir

    def __repr__(self):
        out = []
        if self.createdir is not None:
            out += ['createdir=%s' % repr(self.createdir)]
        return 'OPENATTR4args(%s)' % ', '.join(out)
    __str__ = __repr__

class OPENATTR4res:
    # XDR definition:
    # struct OPENATTR4res {
    #     nfsstat4 status;
    # };
    def __init__(self, status=None):
        self.status = status

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        return 'OPENATTR4res(%s)' % ', '.join(out)
    __str__ = __repr__

class OPEN_CONFIRM4args:
    # XDR definition:
    # struct OPEN_CONFIRM4args {
    #     stateid4 open_stateid;
    #     seqid4 seqid;
    # };
    def __init__(self, open_stateid=None, seqid=None):
        self.open_stateid = open_stateid
        self.seqid = seqid

    def __getattr__(self, attr):
        return getattr(self.open_stateid, attr)

    def __repr__(self):
        out = []
        if self.open_stateid is not None:
            out += ['open_stateid=%s' % repr(self.open_stateid)]
        if self.seqid is not None:
            out += ['seqid=%s' % repr(self.seqid)]
        return 'OPEN_CONFIRM4args(%s)' % ', '.join(out)
    __str__ = __repr__

class OPEN_CONFIRM4resok:
    # XDR definition:
    # struct OPEN_CONFIRM4resok {
    #     stateid4 open_stateid;
    # };
    def __init__(self, open_stateid=None):
        self.open_stateid = open_stateid

    def __getattr__(self, attr):
        return getattr(self.open_stateid, attr)

    def __repr__(self):
        out = []
        if self.open_stateid is not None:
            out += ['open_stateid=%s' % repr(self.open_stateid)]
        return 'OPEN_CONFIRM4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class OPEN_CONFIRM4res:
    # XDR definition:
    # union OPEN_CONFIRM4res switch(nfsstat4 status) {
    #     case NFS4_OK:
    #         OPEN_CONFIRM4resok resok4;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, resok4=None):
        self.status = status
        self.resok4 = resok4

    switch = property(lambda s: {const.NFS4_OK:s.resok4,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.resok4 is not None:
            out += ['resok4=%s' % repr(self.resok4)]
        return 'OPEN_CONFIRM4res(%s)' % ', '.join(out)
    __str__ = __repr__

class OPEN_DOWNGRADE4args:
    # XDR definition:
    # struct OPEN_DOWNGRADE4args {
    #     stateid4 open_stateid;
    #     seqid4 seqid;
    #     uint32_t share_access;
    #     uint32_t share_deny;
    # };
    def __init__(self, open_stateid=None, seqid=None, share_access=None, share_deny=None):
        self.open_stateid = open_stateid
        self.seqid = seqid
        self.share_access = share_access
        self.share_deny = share_deny

    def __getattr__(self, attr):
        return getattr(self.open_stateid, attr)

    def __repr__(self):
        out = []
        if self.open_stateid is not None:
            out += ['open_stateid=%s' % repr(self.open_stateid)]
        if self.seqid is not None:
            out += ['seqid=%s' % repr(self.seqid)]
        if self.share_access is not None:
            out += ['share_access=%s' % repr(self.share_access)]
        if self.share_deny is not None:
            out += ['share_deny=%s' % repr(self.share_deny)]
        return 'OPEN_DOWNGRADE4args(%s)' % ', '.join(out)
    __str__ = __repr__

class OPEN_DOWNGRADE4resok:
    # XDR definition:
    # struct OPEN_DOWNGRADE4resok {
    #     stateid4 open_stateid;
    # };
    def __init__(self, open_stateid=None):
        self.open_stateid = open_stateid

    def __getattr__(self, attr):
        return getattr(self.open_stateid, attr)

    def __repr__(self):
        out = []
        if self.open_stateid is not None:
            out += ['open_stateid=%s' % repr(self.open_stateid)]
        return 'OPEN_DOWNGRADE4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class OPEN_DOWNGRADE4res:
    # XDR definition:
    # union OPEN_DOWNGRADE4res switch(nfsstat4 status) {
    #     case NFS4_OK:
    #         OPEN_DOWNGRADE4resok resok4;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, resok4=None):
        self.status = status
        self.resok4 = resok4

    switch = property(lambda s: {const.NFS4_OK:s.resok4,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.resok4 is not None:
            out += ['resok4=%s' % repr(self.resok4)]
        return 'OPEN_DOWNGRADE4res(%s)' % ', '.join(out)
    __str__ = __repr__

class PUTFH4args:
    # XDR definition:
    # struct PUTFH4args {
    #     nfs_fh4 object;
    # };
    def __init__(self, object=None):
        self.object = object

    def __repr__(self):
        out = []
        if self.object is not None:
            out += ['object=%s' % repr(self.object)]
        return 'PUTFH4args(%s)' % ', '.join(out)
    __str__ = __repr__

class PUTFH4res:
    # XDR definition:
    # struct PUTFH4res {
    #     nfsstat4 status;
    # };
    def __init__(self, status=None):
        self.status = status

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        return 'PUTFH4res(%s)' % ', '.join(out)
    __str__ = __repr__

class PUTPUBFH4res:
    # XDR definition:
    # struct PUTPUBFH4res {
    #     nfsstat4 status;
    # };
    def __init__(self, status=None):
        self.status = status

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        return 'PUTPUBFH4res(%s)' % ', '.join(out)
    __str__ = __repr__

class PUTROOTFH4res:
    # XDR definition:
    # struct PUTROOTFH4res {
    #     nfsstat4 status;
    # };
    def __init__(self, status=None):
        self.status = status

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        return 'PUTROOTFH4res(%s)' % ', '.join(out)
    __str__ = __repr__

class READ4args:
    # XDR definition:
    # struct READ4args {
    #     stateid4 stateid;
    #     offset4 offset;
    #     count4 count;
    # };
    def __init__(self, stateid=None, offset=None, count=None):
        self.stateid = stateid
        self.offset = offset
        self.count = count

    def __getattr__(self, attr):
        return getattr(self.stateid, attr)

    def __repr__(self):
        out = []
        if self.stateid is not None:
            out += ['stateid=%s' % repr(self.stateid)]
        if self.offset is not None:
            out += ['offset=%s' % repr(self.offset)]
        if self.count is not None:
            out += ['count=%s' % repr(self.count)]
        return 'READ4args(%s)' % ', '.join(out)
    __str__ = __repr__

class READ4resok:
    # XDR definition:
    # struct READ4resok {
    #     bool eof;
    #     opaque data<>;
    # };
    def __init__(self, eof=None, data=None):
        self.eof = eof
        self.data = data

    def __repr__(self):
        out = []
        if self.eof is not None:
            out += ['eof=%s' % repr(self.eof)]
        if self.data is not None:
            out += ['data=%s' % repr(self.data)]
        return 'READ4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class READ4res:
    # XDR definition:
    # union READ4res switch(nfsstat4 status) {
    #     case NFS4_OK:
    #         READ4resok resok4;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, resok4=None):
        self.status = status
        self.resok4 = resok4

    switch = property(lambda s: {const.NFS4_OK:s.resok4,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.resok4 is not None:
            out += ['resok4=%s' % repr(self.resok4)]
        return 'READ4res(%s)' % ', '.join(out)
    __str__ = __repr__

class READDIR4args:
    # XDR definition:
    # struct READDIR4args {
    #     nfs_cookie4 cookie;
    #     verifier4 cookieverf;
    #     count4 dircount;
    #     count4 maxcount;
    #     bitmap4 attr_request;
    # };
    def __init__(self, cookie=None, cookieverf=None, dircount=None, maxcount=None, attr_request=None):
        self.cookie = cookie
        self.cookieverf = cookieverf
        self.dircount = dircount
        self.maxcount = maxcount
        self.attr_request = attr_request

    def __repr__(self):
        out = []
        if self.cookie is not None:
            out += ['cookie=%s' % repr(self.cookie)]
        if self.cookieverf is not None:
            out += ['cookieverf=%s' % repr(self.cookieverf)]
        if self.dircount is not None:
            out += ['dircount=%s' % repr(self.dircount)]
        if self.maxcount is not None:
            out += ['maxcount=%s' % repr(self.maxcount)]
        if self.attr_request is not None:
            out += ['attr_request=%s' % repr(self.attr_request)]
        return 'READDIR4args(%s)' % ', '.join(out)
    __str__ = __repr__

class entry4:
    # XDR definition:
    # struct entry4 {
    #     nfs_cookie4 cookie;
    #     component4 name;
    #     fattr4 attrs;
    #     entry4 nextentry<1>;
    # };
    def __init__(self, cookie=None, name=None, attrs=None, nextentry=None):
        self.cookie = cookie
        self.name = name
        self.attrs = attrs
        self.nextentry = nextentry

    def __getattr__(self, attr):
        return getattr(self.attrs, attr)

    def __repr__(self):
        out = []
        if self.cookie is not None:
            out += ['cookie=%s' % repr(self.cookie)]
        if self.name is not None:
            out += ['name=%s' % repr(self.name)]
        if self.attrs is not None:
            out += ['attrs=%s' % repr(self.attrs)]
        if self.nextentry is not None:
            out += ['nextentry=%s' % repr(self.nextentry)]
        return 'entry4(%s)' % ', '.join(out)
    __str__ = __repr__

class dirlist4:
    # XDR definition:
    # struct dirlist4 {
    #     entry4 entries<1>;
    #     bool eof;
    # };
    def __init__(self, entries=None, eof=None):
        self.entries = entries
        self.eof = eof

    def __repr__(self):
        out = []
        if self.entries is not None:
            out += ['entries=%s' % repr(self.entries)]
        if self.eof is not None:
            out += ['eof=%s' % repr(self.eof)]
        return 'dirlist4(%s)' % ', '.join(out)
    __str__ = __repr__

class READDIR4resok:
    # XDR definition:
    # struct READDIR4resok {
    #     verifier4 cookieverf;
    #     dirlist4 reply;
    # };
    def __init__(self, cookieverf=None, reply=None):
        self.cookieverf = cookieverf
        self.reply = reply

    def __getattr__(self, attr):
        return getattr(self.reply, attr)

    def __repr__(self):
        out = []
        if self.cookieverf is not None:
            out += ['cookieverf=%s' % repr(self.cookieverf)]
        if self.reply is not None:
            out += ['reply=%s' % repr(self.reply)]
        return 'READDIR4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class READDIR4res:
    # XDR definition:
    # union READDIR4res switch(nfsstat4 status) {
    #     case NFS4_OK:
    #         READDIR4resok resok4;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, resok4=None):
        self.status = status
        self.resok4 = resok4

    switch = property(lambda s: {const.NFS4_OK:s.resok4,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.resok4 is not None:
            out += ['resok4=%s' % repr(self.resok4)]
        return 'READDIR4res(%s)' % ', '.join(out)
    __str__ = __repr__

class READLINK4resok:
    # XDR definition:
    # struct READLINK4resok {
    #     linktext4 link;
    # };
    def __init__(self, link=None):
        self.link = link

    def __repr__(self):
        out = []
        if self.link is not None:
            out += ['link=%s' % repr(self.link)]
        return 'READLINK4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class READLINK4res:
    # XDR definition:
    # union READLINK4res switch(nfsstat4 status) {
    #     case NFS4_OK:
    #         READLINK4resok resok4;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, resok4=None):
        self.status = status
        self.resok4 = resok4

    switch = property(lambda s: {const.NFS4_OK:s.resok4,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.resok4 is not None:
            out += ['resok4=%s' % repr(self.resok4)]
        return 'READLINK4res(%s)' % ', '.join(out)
    __str__ = __repr__

class REMOVE4args:
    # XDR definition:
    # struct REMOVE4args {
    #     component4 target;
    # };
    def __init__(self, target=None):
        self.target = target

    def __repr__(self):
        out = []
        if self.target is not None:
            out += ['target=%s' % repr(self.target)]
        return 'REMOVE4args(%s)' % ', '.join(out)
    __str__ = __repr__

class REMOVE4resok:
    # XDR definition:
    # struct REMOVE4resok {
    #     change_info4 cinfo;
    # };
    def __init__(self, cinfo=None):
        self.cinfo = cinfo

    def __getattr__(self, attr):
        return getattr(self.cinfo, attr)

    def __repr__(self):
        out = []
        if self.cinfo is not None:
            out += ['cinfo=%s' % repr(self.cinfo)]
        return 'REMOVE4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class REMOVE4res:
    # XDR definition:
    # union REMOVE4res switch(nfsstat4 status) {
    #     case NFS4_OK:
    #         REMOVE4resok resok4;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, resok4=None):
        self.status = status
        self.resok4 = resok4

    switch = property(lambda s: {const.NFS4_OK:s.resok4,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.resok4 is not None:
            out += ['resok4=%s' % repr(self.resok4)]
        return 'REMOVE4res(%s)' % ', '.join(out)
    __str__ = __repr__

class RENAME4args:
    # XDR definition:
    # struct RENAME4args {
    #     component4 oldname;
    #     component4 newname;
    # };
    def __init__(self, oldname=None, newname=None):
        self.oldname = oldname
        self.newname = newname

    def __repr__(self):
        out = []
        if self.oldname is not None:
            out += ['oldname=%s' % repr(self.oldname)]
        if self.newname is not None:
            out += ['newname=%s' % repr(self.newname)]
        return 'RENAME4args(%s)' % ', '.join(out)
    __str__ = __repr__

class RENAME4resok:
    # XDR definition:
    # struct RENAME4resok {
    #     change_info4 source_cinfo;
    #     change_info4 target_cinfo;
    # };
    def __init__(self, source_cinfo=None, target_cinfo=None):
        self.source_cinfo = source_cinfo
        self.target_cinfo = target_cinfo

    def __repr__(self):
        out = []
        if self.source_cinfo is not None:
            out += ['source_cinfo=%s' % repr(self.source_cinfo)]
        if self.target_cinfo is not None:
            out += ['target_cinfo=%s' % repr(self.target_cinfo)]
        return 'RENAME4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class RENAME4res:
    # XDR definition:
    # union RENAME4res switch(nfsstat4 status) {
    #     case NFS4_OK:
    #         RENAME4resok resok4;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, resok4=None):
        self.status = status
        self.resok4 = resok4

    switch = property(lambda s: {const.NFS4_OK:s.resok4,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.resok4 is not None:
            out += ['resok4=%s' % repr(self.resok4)]
        return 'RENAME4res(%s)' % ', '.join(out)
    __str__ = __repr__

class RENEW4args:
    # XDR definition:
    # struct RENEW4args {
    #     clientid4 clientid;
    # };
    def __init__(self, clientid=None):
        self.clientid = clientid

    def __repr__(self):
        out = []
        if self.clientid is not None:
            out += ['clientid=%s' % repr(self.clientid)]
        return 'RENEW4args(%s)' % ', '.join(out)
    __str__ = __repr__

class RENEW4res:
    # XDR definition:
    # struct RENEW4res {
    #     nfsstat4 status;
    # };
    def __init__(self, status=None):
        self.status = status

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        return 'RENEW4res(%s)' % ', '.join(out)
    __str__ = __repr__

class RESTOREFH4res:
    # XDR definition:
    # struct RESTOREFH4res {
    #     nfsstat4 status;
    # };
    def __init__(self, status=None):
        self.status = status

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        return 'RESTOREFH4res(%s)' % ', '.join(out)
    __str__ = __repr__

class SAVEFH4res:
    # XDR definition:
    # struct SAVEFH4res {
    #     nfsstat4 status;
    # };
    def __init__(self, status=None):
        self.status = status

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        return 'SAVEFH4res(%s)' % ', '.join(out)
    __str__ = __repr__

class SECINFO4args:
    # XDR definition:
    # struct SECINFO4args {
    #     component4 name;
    # };
    def __init__(self, name=None):
        self.name = name

    def __repr__(self):
        out = []
        if self.name is not None:
            out += ['name=%s' % repr(self.name)]
        return 'SECINFO4args(%s)' % ', '.join(out)
    __str__ = __repr__

class rpcsec_gss_info:
    # XDR definition:
    # struct rpcsec_gss_info {
    #     sec_oid4 oid;
    #     qop4 qop;
    #     rpc_gss_svc_t service;
    # };
    def __init__(self, oid=None, qop=None, service=None):
        self.oid = oid
        self.qop = qop
        self.service = service

    def __repr__(self):
        out = []
        if self.oid is not None:
            out += ['oid=%s' % repr(self.oid)]
        if self.qop is not None:
            out += ['qop=%s' % repr(self.qop)]
        if self.service is not None:
            out += ['service=%s' % const.rpc_gss_svc_t.get(self.service, self.service)]
        return 'rpcsec_gss_info(%s)' % ', '.join(out)
    __str__ = __repr__

class secinfo4:
    # XDR definition:
    # union secinfo4 switch(uint32_t flavor) {
    #     case RPCSEC_GSS:
    #         rpcsec_gss_info flavor_info;
    #     default:
    #         void;
    # };
    def __init__(self, flavor=None, flavor_info=None):
        self.flavor = flavor
        self.flavor_info = flavor_info

    switch = property(lambda s: {const.RPCSEC_GSS:s.flavor_info,}.get(s.flavor, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.flavor is not None:
            out += ['flavor=%s' % repr(self.flavor)]
        if self.flavor_info is not None:
            out += ['flavor_info=%s' % repr(self.flavor_info)]
        return 'secinfo4(%s)' % ', '.join(out)
    __str__ = __repr__

class SECINFO4res:
    # XDR definition:
    # union SECINFO4res switch(nfsstat4 status) {
    #     case NFS4_OK:
    #         SECINFO4resok resok4;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, resok4=None):
        self.status = status
        self.resok4 = resok4

    switch = property(lambda s: {const.NFS4_OK:s.resok4,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.resok4 is not None:
            out += ['resok4=%s' % repr(self.resok4)]
        return 'SECINFO4res(%s)' % ', '.join(out)
    __str__ = __repr__

class SETATTR4args:
    # XDR definition:
    # struct SETATTR4args {
    #     stateid4 stateid;
    #     fattr4 obj_attributes;
    # };
    def __init__(self, stateid=None, obj_attributes=None):
        self.stateid = stateid
        self.obj_attributes = obj_attributes

    def __repr__(self):
        out = []
        if self.stateid is not None:
            out += ['stateid=%s' % repr(self.stateid)]
        if self.obj_attributes is not None:
            out += ['obj_attributes=%s' % repr(self.obj_attributes)]
        return 'SETATTR4args(%s)' % ', '.join(out)
    __str__ = __repr__

class SETATTR4res:
    # XDR definition:
    # struct SETATTR4res {
    #     nfsstat4 status;
    #     bitmap4 attrsset;
    # };
    def __init__(self, status=None, attrsset=None):
        self.status = status
        self.attrsset = attrsset

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.attrsset is not None:
            out += ['attrsset=%s' % repr(self.attrsset)]
        return 'SETATTR4res(%s)' % ', '.join(out)
    __str__ = __repr__

class SETCLIENTID4args:
    # XDR definition:
    # struct SETCLIENTID4args {
    #     nfs_client_id4 client;
    #     cb_client4 callback;
    #     uint32_t callback_ident;
    # };
    def __init__(self, client=None, callback=None, callback_ident=None):
        self.client = client
        self.callback = callback
        self.callback_ident = callback_ident

    def __repr__(self):
        out = []
        if self.client is not None:
            out += ['client=%s' % repr(self.client)]
        if self.callback is not None:
            out += ['callback=%s' % repr(self.callback)]
        if self.callback_ident is not None:
            out += ['callback_ident=%s' % repr(self.callback_ident)]
        return 'SETCLIENTID4args(%s)' % ', '.join(out)
    __str__ = __repr__

class SETCLIENTID4resok:
    # XDR definition:
    # struct SETCLIENTID4resok {
    #     clientid4 clientid;
    #     verifier4 setclientid_confirm;
    # };
    def __init__(self, clientid=None, setclientid_confirm=None):
        self.clientid = clientid
        self.setclientid_confirm = setclientid_confirm

    def __repr__(self):
        out = []
        if self.clientid is not None:
            out += ['clientid=%s' % repr(self.clientid)]
        if self.setclientid_confirm is not None:
            out += ['setclientid_confirm=%s' % repr(self.setclientid_confirm)]
        return 'SETCLIENTID4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class SETCLIENTID4res:
    # XDR definition:
    # union SETCLIENTID4res switch(nfsstat4 status) {
    #     case NFS4_OK:
    #         SETCLIENTID4resok resok4;
    #     case NFS4ERR_CLID_INUSE:
    #         clientaddr4 client_using;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, resok4=None, client_using=None):
        self.status = status
        self.resok4 = resok4
        self.client_using = client_using

    switch = property(lambda s: {const.NFS4_OK:s.resok4,const.NFS4ERR_CLID_INUSE:s.client_using,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.resok4 is not None:
            out += ['resok4=%s' % repr(self.resok4)]
        if self.client_using is not None:
            out += ['client_using=%s' % repr(self.client_using)]
        return 'SETCLIENTID4res(%s)' % ', '.join(out)
    __str__ = __repr__

class SETCLIENTID_CONFIRM4args:
    # XDR definition:
    # struct SETCLIENTID_CONFIRM4args {
    #     clientid4 clientid;
    #     verifier4 setclientid_confirm;
    # };
    def __init__(self, clientid=None, setclientid_confirm=None):
        self.clientid = clientid
        self.setclientid_confirm = setclientid_confirm

    def __repr__(self):
        out = []
        if self.clientid is not None:
            out += ['clientid=%s' % repr(self.clientid)]
        if self.setclientid_confirm is not None:
            out += ['setclientid_confirm=%s' % repr(self.setclientid_confirm)]
        return 'SETCLIENTID_CONFIRM4args(%s)' % ', '.join(out)
    __str__ = __repr__

class SETCLIENTID_CONFIRM4res:
    # XDR definition:
    # struct SETCLIENTID_CONFIRM4res {
    #     nfsstat4 status;
    # };
    def __init__(self, status=None):
        self.status = status

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        return 'SETCLIENTID_CONFIRM4res(%s)' % ', '.join(out)
    __str__ = __repr__

class VERIFY4args:
    # XDR definition:
    # struct VERIFY4args {
    #     fattr4 obj_attributes;
    # };
    def __init__(self, obj_attributes=None):
        self.obj_attributes = obj_attributes

    def __getattr__(self, attr):
        return getattr(self.obj_attributes, attr)

    def __repr__(self):
        out = []
        if self.obj_attributes is not None:
            out += ['obj_attributes=%s' % repr(self.obj_attributes)]
        return 'VERIFY4args(%s)' % ', '.join(out)
    __str__ = __repr__

class VERIFY4res:
    # XDR definition:
    # struct VERIFY4res {
    #     nfsstat4 status;
    # };
    def __init__(self, status=None):
        self.status = status

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        return 'VERIFY4res(%s)' % ', '.join(out)
    __str__ = __repr__

class WRITE4args:
    # XDR definition:
    # struct WRITE4args {
    #     stateid4 stateid;
    #     offset4 offset;
    #     stable_how4 stable;
    #     opaque data<>;
    # };
    def __init__(self, stateid=None, offset=None, stable=None, data=None):
        self.stateid = stateid
        self.offset = offset
        self.stable = stable
        self.data = data

    def __getattr__(self, attr):
        return getattr(self.stateid, attr)

    def __repr__(self):
        out = []
        if self.stateid is not None:
            out += ['stateid=%s' % repr(self.stateid)]
        if self.offset is not None:
            out += ['offset=%s' % repr(self.offset)]
        if self.stable is not None:
            out += ['stable=%s' % const.stable_how4.get(self.stable, self.stable)]
        if self.data is not None:
            out += ['data=%s' % repr(self.data)]
        return 'WRITE4args(%s)' % ', '.join(out)
    __str__ = __repr__

class WRITE4resok:
    # XDR definition:
    # struct WRITE4resok {
    #     count4 count;
    #     stable_how4 committed;
    #     verifier4 writeverf;
    # };
    def __init__(self, count=None, committed=None, writeverf=None):
        self.count = count
        self.committed = committed
        self.writeverf = writeverf

    def __repr__(self):
        out = []
        if self.count is not None:
            out += ['count=%s' % repr(self.count)]
        if self.committed is not None:
            out += ['committed=%s' % const.stable_how4.get(self.committed, self.committed)]
        if self.writeverf is not None:
            out += ['writeverf=%s' % repr(self.writeverf)]
        return 'WRITE4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class WRITE4res:
    # XDR definition:
    # union WRITE4res switch(nfsstat4 status) {
    #     case NFS4_OK:
    #         WRITE4resok resok4;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, resok4=None):
        self.status = status
        self.resok4 = resok4

    switch = property(lambda s: {const.NFS4_OK:s.resok4,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.resok4 is not None:
            out += ['resok4=%s' % repr(self.resok4)]
        return 'WRITE4res(%s)' % ', '.join(out)
    __str__ = __repr__

class RELEASE_LOCKOWNER4args:
    # XDR definition:
    # struct RELEASE_LOCKOWNER4args {
    #     lock_owner4 lock_owner;
    # };
    def __init__(self, lock_owner=None):
        self.lock_owner = lock_owner

    def __getattr__(self, attr):
        return getattr(self.lock_owner, attr)

    def __repr__(self):
        out = []
        if self.lock_owner is not None:
            out += ['lock_owner=%s' % repr(self.lock_owner)]
        return 'RELEASE_LOCKOWNER4args(%s)' % ', '.join(out)
    __str__ = __repr__

class RELEASE_LOCKOWNER4res:
    # XDR definition:
    # struct RELEASE_LOCKOWNER4res {
    #     nfsstat4 status;
    # };
    def __init__(self, status=None):
        self.status = status

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        return 'RELEASE_LOCKOWNER4res(%s)' % ', '.join(out)
    __str__ = __repr__

class ILLEGAL4res:
    # XDR definition:
    # struct ILLEGAL4res {
    #     nfsstat4 status;
    # };
    def __init__(self, status=None):
        self.status = status

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        return 'ILLEGAL4res(%s)' % ', '.join(out)
    __str__ = __repr__

class gss_cb_handles4:
    # XDR definition:
    # struct gss_cb_handles4 {
    #     rpc_gss_svc_t gcbp_service;
    #     gsshandle4_t gcbp_handle_from_server;
    #     gsshandle4_t gcbp_handle_from_client;
    # };
    def __init__(self, gcbp_service=None, gcbp_handle_from_server=None, gcbp_handle_from_client=None):
        self.gcbp_service = gcbp_service
        self.gcbp_handle_from_server = gcbp_handle_from_server
        self.gcbp_handle_from_client = gcbp_handle_from_client

    def __repr__(self):
        out = []
        if self.gcbp_service is not None:
            out += ['gcbp_service=%s' % const.rpc_gss_svc_t.get(self.gcbp_service, self.gcbp_service)]
        if self.gcbp_handle_from_server is not None:
            out += ['gcbp_handle_from_server=%s' % repr(self.gcbp_handle_from_server)]
        if self.gcbp_handle_from_client is not None:
            out += ['gcbp_handle_from_client=%s' % repr(self.gcbp_handle_from_client)]
        return 'gss_cb_handles4(%s)' % ', '.join(out)
    __str__ = __repr__

class callback_sec_parms4:
    # XDR definition:
    # union callback_sec_parms4 switch(uint32_t cb_secflavor) {
    #     case AUTH_NONE:
    #         void;
    #     case AUTH_SYS:
    #         authsys_parms cbsp_sys_cred;
    #     case RPCSEC_GSS:
    #         gss_cb_handles4 cbsp_gss_handles;
    # };
    def __init__(self, cb_secflavor=None, cbsp_sys_cred=None, cbsp_gss_handles=None):
        self.cb_secflavor = cb_secflavor
        self.cbsp_sys_cred = cbsp_sys_cred
        self.cbsp_gss_handles = cbsp_gss_handles

    switch = property(lambda s: {const.AUTH_NONE:None,const.AUTH_SYS:s.cbsp_sys_cred,const.RPCSEC_GSS:s.cbsp_gss_handles,}[s.cb_secflavor])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.cb_secflavor is not None:
            out += ['cb_secflavor=%s' % repr(self.cb_secflavor)]
        if self.cbsp_sys_cred is not None:
            out += ['cbsp_sys_cred=%s' % repr(self.cbsp_sys_cred)]
        if self.cbsp_gss_handles is not None:
            out += ['cbsp_gss_handles=%s' % repr(self.cbsp_gss_handles)]
        return 'callback_sec_parms4(%s)' % ', '.join(out)
    __str__ = __repr__

class BACKCHANNEL_CTL4args:
    # XDR definition:
    # struct BACKCHANNEL_CTL4args {
    #     uint32_t bca_cb_program;
    #     callback_sec_parms4 bca_sec_parms<>;
    # };
    def __init__(self, bca_cb_program=None, bca_sec_parms=None):
        self.bca_cb_program = bca_cb_program
        self.bca_sec_parms = bca_sec_parms

    def __repr__(self):
        out = []
        if self.bca_cb_program is not None:
            out += ['bca_cb_program=%s' % repr(self.bca_cb_program)]
        if self.bca_sec_parms is not None:
            out += ['bca_sec_parms=%s' % repr(self.bca_sec_parms)]
        return 'BACKCHANNEL_CTL4args(%s)' % ', '.join(out)
    __str__ = __repr__

class BACKCHANNEL_CTL4res:
    # XDR definition:
    # struct BACKCHANNEL_CTL4res {
    #     nfsstat4 bcr_status;
    # };
    def __init__(self, bcr_status=None):
        self.bcr_status = bcr_status

    def __repr__(self):
        out = []
        if self.bcr_status is not None:
            out += ['bcr_status=%s' % const.nfsstat4.get(self.bcr_status, self.bcr_status)]
        return 'BACKCHANNEL_CTL4res(%s)' % ', '.join(out)
    __str__ = __repr__

class BIND_CONN_TO_SESSION4args:
    # XDR definition:
    # struct BIND_CONN_TO_SESSION4args {
    #     sessionid4 bctsa_sessid;
    #     channel_dir_from_client4 bctsa_dir;
    #     bool bctsa_use_conn_in_rdma_mode;
    # };
    def __init__(self, bctsa_sessid=None, bctsa_dir=None, bctsa_use_conn_in_rdma_mode=None):
        self.bctsa_sessid = bctsa_sessid
        self.bctsa_dir = bctsa_dir
        self.bctsa_use_conn_in_rdma_mode = bctsa_use_conn_in_rdma_mode

    def __repr__(self):
        out = []
        if self.bctsa_sessid is not None:
            out += ['bctsa_sessid=%s' % repr(self.bctsa_sessid)]
        if self.bctsa_dir is not None:
            out += ['bctsa_dir=%s' % const.channel_dir_from_client4.get(self.bctsa_dir, self.bctsa_dir)]
        if self.bctsa_use_conn_in_rdma_mode is not None:
            out += ['bctsa_use_conn_in_rdma_mode=%s' % repr(self.bctsa_use_conn_in_rdma_mode)]
        return 'BIND_CONN_TO_SESSION4args(%s)' % ', '.join(out)
    __str__ = __repr__

class BIND_CONN_TO_SESSION4resok:
    # XDR definition:
    # struct BIND_CONN_TO_SESSION4resok {
    #     sessionid4 bctsr_sessid;
    #     channel_dir_from_server4 bctsr_dir;
    #     bool bctsr_use_conn_in_rdma_mode;
    # };
    def __init__(self, bctsr_sessid=None, bctsr_dir=None, bctsr_use_conn_in_rdma_mode=None):
        self.bctsr_sessid = bctsr_sessid
        self.bctsr_dir = bctsr_dir
        self.bctsr_use_conn_in_rdma_mode = bctsr_use_conn_in_rdma_mode

    def __repr__(self):
        out = []
        if self.bctsr_sessid is not None:
            out += ['bctsr_sessid=%s' % repr(self.bctsr_sessid)]
        if self.bctsr_dir is not None:
            out += ['bctsr_dir=%s' % const.channel_dir_from_server4.get(self.bctsr_dir, self.bctsr_dir)]
        if self.bctsr_use_conn_in_rdma_mode is not None:
            out += ['bctsr_use_conn_in_rdma_mode=%s' % repr(self.bctsr_use_conn_in_rdma_mode)]
        return 'BIND_CONN_TO_SESSION4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class BIND_CONN_TO_SESSION4res:
    # XDR definition:
    # union BIND_CONN_TO_SESSION4res switch(nfsstat4 bctsr_status) {
    #     case NFS4_OK:
    #         BIND_CONN_TO_SESSION4resok bctsr_resok4;
    #     default:
    #         void;
    # };
    def __init__(self, bctsr_status=None, bctsr_resok4=None):
        self.bctsr_status = bctsr_status
        self.bctsr_resok4 = bctsr_resok4

    switch = property(lambda s: {const.NFS4_OK:s.bctsr_resok4,}.get(s.bctsr_status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.bctsr_status is not None:
            out += ['bctsr_status=%s' % const.nfsstat4.get(self.bctsr_status, self.bctsr_status)]
        if self.bctsr_resok4 is not None:
            out += ['bctsr_resok4=%s' % repr(self.bctsr_resok4)]
        return 'BIND_CONN_TO_SESSION4res(%s)' % ', '.join(out)
    __str__ = __repr__

class state_protect_ops4:
    # XDR definition:
    # struct state_protect_ops4 {
    #     bitmap4 spo_must_enforce;
    #     bitmap4 spo_must_allow;
    # };
    def __init__(self, spo_must_enforce=None, spo_must_allow=None):
        self.spo_must_enforce = spo_must_enforce
        self.spo_must_allow = spo_must_allow

    def __repr__(self):
        out = []
        if self.spo_must_enforce is not None:
            out += ['spo_must_enforce=%s' % repr(self.spo_must_enforce)]
        if self.spo_must_allow is not None:
            out += ['spo_must_allow=%s' % repr(self.spo_must_allow)]
        return 'state_protect_ops4(%s)' % ', '.join(out)
    __str__ = __repr__

class ssv_sp_parms4:
    # XDR definition:
    # struct ssv_sp_parms4 {
    #     state_protect_ops4 ssp_ops;
    #     sec_oid4 ssp_hash_algs<>;
    #     sec_oid4 ssp_encr_algs<>;
    #     uint32_t ssp_window;
    #     uint32_t ssp_num_gss_handles;
    # };
    def __init__(self, ssp_ops=None, ssp_hash_algs=None, ssp_encr_algs=None, ssp_window=None, ssp_num_gss_handles=None):
        self.ssp_ops = ssp_ops
        self.ssp_hash_algs = ssp_hash_algs
        self.ssp_encr_algs = ssp_encr_algs
        self.ssp_window = ssp_window
        self.ssp_num_gss_handles = ssp_num_gss_handles

    def __getattr__(self, attr):
        return getattr(self.ssp_ops, attr)

    def __repr__(self):
        out = []
        if self.ssp_ops is not None:
            out += ['ssp_ops=%s' % repr(self.ssp_ops)]
        if self.ssp_hash_algs is not None:
            out += ['ssp_hash_algs=%s' % repr(self.ssp_hash_algs)]
        if self.ssp_encr_algs is not None:
            out += ['ssp_encr_algs=%s' % repr(self.ssp_encr_algs)]
        if self.ssp_window is not None:
            out += ['ssp_window=%s' % repr(self.ssp_window)]
        if self.ssp_num_gss_handles is not None:
            out += ['ssp_num_gss_handles=%s' % repr(self.ssp_num_gss_handles)]
        return 'ssv_sp_parms4(%s)' % ', '.join(out)
    __str__ = __repr__

class state_protect4_a:
    # XDR definition:
    # union state_protect4_a switch(state_protect_how4 spa_how) {
    #     case SP4_NONE:
    #         void;
    #     case SP4_MACH_CRED:
    #         state_protect_ops4 spa_mach_ops;
    #     case SP4_SSV:
    #         ssv_sp_parms4 spa_ssv_parms;
    # };
    def __init__(self, spa_how=None, spa_mach_ops=None, spa_ssv_parms=None):
        self.spa_how = spa_how
        self.spa_mach_ops = spa_mach_ops
        self.spa_ssv_parms = spa_ssv_parms

    switch = property(lambda s: {const.SP4_NONE:None,const.SP4_MACH_CRED:s.spa_mach_ops,const.SP4_SSV:s.spa_ssv_parms,}[s.spa_how])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.spa_how is not None:
            out += ['spa_how=%s' % const.state_protect_how4.get(self.spa_how, self.spa_how)]
        if self.spa_mach_ops is not None:
            out += ['spa_mach_ops=%s' % repr(self.spa_mach_ops)]
        if self.spa_ssv_parms is not None:
            out += ['spa_ssv_parms=%s' % repr(self.spa_ssv_parms)]
        return 'state_protect4_a(%s)' % ', '.join(out)
    __str__ = __repr__

class EXCHANGE_ID4args:
    # XDR definition:
    # struct EXCHANGE_ID4args {
    #     client_owner4 eia_clientowner;
    #     uint32_t eia_flags;
    #     state_protect4_a eia_state_protect;
    #     nfs_impl_id4 eia_client_impl_id<1>;
    # };
    def __init__(self, eia_clientowner=None, eia_flags=None, eia_state_protect=None, eia_client_impl_id=None):
        self.eia_clientowner = eia_clientowner
        self.eia_flags = eia_flags
        self.eia_state_protect = eia_state_protect
        self.eia_client_impl_id = eia_client_impl_id

    def __repr__(self):
        out = []
        if self.eia_clientowner is not None:
            out += ['eia_clientowner=%s' % repr(self.eia_clientowner)]
        if self.eia_flags is not None:
            out += ['eia_flags=%s' % repr(self.eia_flags)]
        if self.eia_state_protect is not None:
            out += ['eia_state_protect=%s' % repr(self.eia_state_protect)]
        if self.eia_client_impl_id is not None:
            out += ['eia_client_impl_id=%s' % repr(self.eia_client_impl_id)]
        return 'EXCHANGE_ID4args(%s)' % ', '.join(out)
    __str__ = __repr__

class ssv_prot_info4:
    # XDR definition:
    # struct ssv_prot_info4 {
    #     state_protect_ops4 spi_ops;
    #     uint32_t spi_hash_alg;
    #     uint32_t spi_encr_alg;
    #     uint32_t spi_ssv_len;
    #     uint32_t spi_window;
    #     gsshandle4_t spi_handles<>;
    # };
    def __init__(self, spi_ops=None, spi_hash_alg=None, spi_encr_alg=None, spi_ssv_len=None, spi_window=None, spi_handles=None):
        self.spi_ops = spi_ops
        self.spi_hash_alg = spi_hash_alg
        self.spi_encr_alg = spi_encr_alg
        self.spi_ssv_len = spi_ssv_len
        self.spi_window = spi_window
        self.spi_handles = spi_handles

    def __getattr__(self, attr):
        return getattr(self.spi_ops, attr)

    def __repr__(self):
        out = []
        if self.spi_ops is not None:
            out += ['spi_ops=%s' % repr(self.spi_ops)]
        if self.spi_hash_alg is not None:
            out += ['spi_hash_alg=%s' % repr(self.spi_hash_alg)]
        if self.spi_encr_alg is not None:
            out += ['spi_encr_alg=%s' % repr(self.spi_encr_alg)]
        if self.spi_ssv_len is not None:
            out += ['spi_ssv_len=%s' % repr(self.spi_ssv_len)]
        if self.spi_window is not None:
            out += ['spi_window=%s' % repr(self.spi_window)]
        if self.spi_handles is not None:
            out += ['spi_handles=%s' % repr(self.spi_handles)]
        return 'ssv_prot_info4(%s)' % ', '.join(out)
    __str__ = __repr__

class state_protect4_r:
    # XDR definition:
    # union state_protect4_r switch(state_protect_how4 spr_how) {
    #     case SP4_NONE:
    #         void;
    #     case SP4_MACH_CRED:
    #         state_protect_ops4 spr_mach_ops;
    #     case SP4_SSV:
    #         ssv_prot_info4 spr_ssv_info;
    # };
    def __init__(self, spr_how=None, spr_mach_ops=None, spr_ssv_info=None):
        self.spr_how = spr_how
        self.spr_mach_ops = spr_mach_ops
        self.spr_ssv_info = spr_ssv_info

    switch = property(lambda s: {const.SP4_NONE:None,const.SP4_MACH_CRED:s.spr_mach_ops,const.SP4_SSV:s.spr_ssv_info,}[s.spr_how])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.spr_how is not None:
            out += ['spr_how=%s' % const.state_protect_how4.get(self.spr_how, self.spr_how)]
        if self.spr_mach_ops is not None:
            out += ['spr_mach_ops=%s' % repr(self.spr_mach_ops)]
        if self.spr_ssv_info is not None:
            out += ['spr_ssv_info=%s' % repr(self.spr_ssv_info)]
        return 'state_protect4_r(%s)' % ', '.join(out)
    __str__ = __repr__

class EXCHANGE_ID4resok:
    # XDR definition:
    # struct EXCHANGE_ID4resok {
    #     clientid4 eir_clientid;
    #     sequenceid4 eir_sequenceid;
    #     uint32_t eir_flags;
    #     state_protect4_r eir_state_protect;
    #     server_owner4 eir_server_owner;
    #     opaque eir_server_scope<NFS4_OPAQUE_LIMIT>;
    #     nfs_impl_id4 eir_server_impl_id<1>;
    # };
    def __init__(self, eir_clientid=None, eir_sequenceid=None, eir_flags=None, eir_state_protect=None, eir_server_owner=None, eir_server_scope=None, eir_server_impl_id=None):
        self.eir_clientid = eir_clientid
        self.eir_sequenceid = eir_sequenceid
        self.eir_flags = eir_flags
        self.eir_state_protect = eir_state_protect
        self.eir_server_owner = eir_server_owner
        self.eir_server_scope = eir_server_scope
        self.eir_server_impl_id = eir_server_impl_id

    def __repr__(self):
        out = []
        if self.eir_clientid is not None:
            out += ['eir_clientid=%s' % repr(self.eir_clientid)]
        if self.eir_sequenceid is not None:
            out += ['eir_sequenceid=%s' % repr(self.eir_sequenceid)]
        if self.eir_flags is not None:
            out += ['eir_flags=%s' % repr(self.eir_flags)]
        if self.eir_state_protect is not None:
            out += ['eir_state_protect=%s' % repr(self.eir_state_protect)]
        if self.eir_server_owner is not None:
            out += ['eir_server_owner=%s' % repr(self.eir_server_owner)]
        if self.eir_server_scope is not None:
            out += ['eir_server_scope=%s' % repr(self.eir_server_scope)]
        if self.eir_server_impl_id is not None:
            out += ['eir_server_impl_id=%s' % repr(self.eir_server_impl_id)]
        return 'EXCHANGE_ID4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class EXCHANGE_ID4res:
    # XDR definition:
    # union EXCHANGE_ID4res switch(nfsstat4 eir_status) {
    #     case NFS4_OK:
    #         EXCHANGE_ID4resok eir_resok4;
    #     default:
    #         void;
    # };
    def __init__(self, eir_status=None, eir_resok4=None):
        self.eir_status = eir_status
        self.eir_resok4 = eir_resok4

    switch = property(lambda s: {const.NFS4_OK:s.eir_resok4,}.get(s.eir_status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.eir_status is not None:
            out += ['eir_status=%s' % const.nfsstat4.get(self.eir_status, self.eir_status)]
        if self.eir_resok4 is not None:
            out += ['eir_resok4=%s' % repr(self.eir_resok4)]
        return 'EXCHANGE_ID4res(%s)' % ', '.join(out)
    __str__ = __repr__

class channel_attrs4:
    # XDR definition:
    # struct channel_attrs4 {
    #     count4 ca_headerpadsize;
    #     count4 ca_maxrequestsize;
    #     count4 ca_maxresponsesize;
    #     count4 ca_maxresponsesize_cached;
    #     count4 ca_maxoperations;
    #     count4 ca_maxrequests;
    #     uint32_t ca_rdma_ird<1>;
    # };
    def __init__(self, ca_headerpadsize=None, ca_maxrequestsize=None, ca_maxresponsesize=None, ca_maxresponsesize_cached=None, ca_maxoperations=None, ca_maxrequests=None, ca_rdma_ird=None):
        self.ca_headerpadsize = ca_headerpadsize
        self.ca_maxrequestsize = ca_maxrequestsize
        self.ca_maxresponsesize = ca_maxresponsesize
        self.ca_maxresponsesize_cached = ca_maxresponsesize_cached
        self.ca_maxoperations = ca_maxoperations
        self.ca_maxrequests = ca_maxrequests
        self.ca_rdma_ird = ca_rdma_ird

    def __repr__(self):
        out = []
        if self.ca_headerpadsize is not None:
            out += ['ca_headerpadsize=%s' % repr(self.ca_headerpadsize)]
        if self.ca_maxrequestsize is not None:
            out += ['ca_maxrequestsize=%s' % repr(self.ca_maxrequestsize)]
        if self.ca_maxresponsesize is not None:
            out += ['ca_maxresponsesize=%s' % repr(self.ca_maxresponsesize)]
        if self.ca_maxresponsesize_cached is not None:
            out += ['ca_maxresponsesize_cached=%s' % repr(self.ca_maxresponsesize_cached)]
        if self.ca_maxoperations is not None:
            out += ['ca_maxoperations=%s' % repr(self.ca_maxoperations)]
        if self.ca_maxrequests is not None:
            out += ['ca_maxrequests=%s' % repr(self.ca_maxrequests)]
        if self.ca_rdma_ird is not None:
            out += ['ca_rdma_ird=%s' % repr(self.ca_rdma_ird)]
        return 'channel_attrs4(%s)' % ', '.join(out)
    __str__ = __repr__

class CREATE_SESSION4args:
    # XDR definition:
    # struct CREATE_SESSION4args {
    #     clientid4 csa_clientid;
    #     sequenceid4 csa_sequence;
    #     uint32_t csa_flags;
    #     channel_attrs4 csa_fore_chan_attrs;
    #     channel_attrs4 csa_back_chan_attrs;
    #     uint32_t csa_cb_program;
    #     callback_sec_parms4 csa_sec_parms<>;
    # };
    def __init__(self, csa_clientid=None, csa_sequence=None, csa_flags=None, csa_fore_chan_attrs=None, csa_back_chan_attrs=None, csa_cb_program=None, csa_sec_parms=None):
        self.csa_clientid = csa_clientid
        self.csa_sequence = csa_sequence
        self.csa_flags = csa_flags
        self.csa_fore_chan_attrs = csa_fore_chan_attrs
        self.csa_back_chan_attrs = csa_back_chan_attrs
        self.csa_cb_program = csa_cb_program
        self.csa_sec_parms = csa_sec_parms

    def __repr__(self):
        out = []
        if self.csa_clientid is not None:
            out += ['csa_clientid=%s' % repr(self.csa_clientid)]
        if self.csa_sequence is not None:
            out += ['csa_sequence=%s' % repr(self.csa_sequence)]
        if self.csa_flags is not None:
            out += ['csa_flags=%s' % repr(self.csa_flags)]
        if self.csa_fore_chan_attrs is not None:
            out += ['csa_fore_chan_attrs=%s' % repr(self.csa_fore_chan_attrs)]
        if self.csa_back_chan_attrs is not None:
            out += ['csa_back_chan_attrs=%s' % repr(self.csa_back_chan_attrs)]
        if self.csa_cb_program is not None:
            out += ['csa_cb_program=%s' % repr(self.csa_cb_program)]
        if self.csa_sec_parms is not None:
            out += ['csa_sec_parms=%s' % repr(self.csa_sec_parms)]
        return 'CREATE_SESSION4args(%s)' % ', '.join(out)
    __str__ = __repr__

class CREATE_SESSION4resok:
    # XDR definition:
    # struct CREATE_SESSION4resok {
    #     sessionid4 csr_sessionid;
    #     sequenceid4 csr_sequence;
    #     uint32_t csr_flags;
    #     channel_attrs4 csr_fore_chan_attrs;
    #     channel_attrs4 csr_back_chan_attrs;
    # };
    def __init__(self, csr_sessionid=None, csr_sequence=None, csr_flags=None, csr_fore_chan_attrs=None, csr_back_chan_attrs=None):
        self.csr_sessionid = csr_sessionid
        self.csr_sequence = csr_sequence
        self.csr_flags = csr_flags
        self.csr_fore_chan_attrs = csr_fore_chan_attrs
        self.csr_back_chan_attrs = csr_back_chan_attrs

    def __repr__(self):
        out = []
        if self.csr_sessionid is not None:
            out += ['csr_sessionid=%s' % repr(self.csr_sessionid)]
        if self.csr_sequence is not None:
            out += ['csr_sequence=%s' % repr(self.csr_sequence)]
        if self.csr_flags is not None:
            out += ['csr_flags=%s' % repr(self.csr_flags)]
        if self.csr_fore_chan_attrs is not None:
            out += ['csr_fore_chan_attrs=%s' % repr(self.csr_fore_chan_attrs)]
        if self.csr_back_chan_attrs is not None:
            out += ['csr_back_chan_attrs=%s' % repr(self.csr_back_chan_attrs)]
        return 'CREATE_SESSION4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class CREATE_SESSION4res:
    # XDR definition:
    # union CREATE_SESSION4res switch(nfsstat4 csr_status) {
    #     case NFS4_OK:
    #         CREATE_SESSION4resok csr_resok4;
    #     default:
    #         void;
    # };
    def __init__(self, csr_status=None, csr_resok4=None):
        self.csr_status = csr_status
        self.csr_resok4 = csr_resok4

    switch = property(lambda s: {const.NFS4_OK:s.csr_resok4,}.get(s.csr_status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.csr_status is not None:
            out += ['csr_status=%s' % const.nfsstat4.get(self.csr_status, self.csr_status)]
        if self.csr_resok4 is not None:
            out += ['csr_resok4=%s' % repr(self.csr_resok4)]
        return 'CREATE_SESSION4res(%s)' % ', '.join(out)
    __str__ = __repr__

class DESTROY_SESSION4args:
    # XDR definition:
    # struct DESTROY_SESSION4args {
    #     sessionid4 dsa_sessionid;
    # };
    def __init__(self, dsa_sessionid=None):
        self.dsa_sessionid = dsa_sessionid

    def __repr__(self):
        out = []
        if self.dsa_sessionid is not None:
            out += ['dsa_sessionid=%s' % repr(self.dsa_sessionid)]
        return 'DESTROY_SESSION4args(%s)' % ', '.join(out)
    __str__ = __repr__

class DESTROY_SESSION4res:
    # XDR definition:
    # struct DESTROY_SESSION4res {
    #     nfsstat4 dsr_status;
    # };
    def __init__(self, dsr_status=None):
        self.dsr_status = dsr_status

    def __repr__(self):
        out = []
        if self.dsr_status is not None:
            out += ['dsr_status=%s' % const.nfsstat4.get(self.dsr_status, self.dsr_status)]
        return 'DESTROY_SESSION4res(%s)' % ', '.join(out)
    __str__ = __repr__

class FREE_STATEID4args:
    # XDR definition:
    # struct FREE_STATEID4args {
    #     stateid4 fsa_stateid;
    # };
    def __init__(self, fsa_stateid=None):
        self.fsa_stateid = fsa_stateid

    def __getattr__(self, attr):
        return getattr(self.fsa_stateid, attr)

    def __repr__(self):
        out = []
        if self.fsa_stateid is not None:
            out += ['fsa_stateid=%s' % repr(self.fsa_stateid)]
        return 'FREE_STATEID4args(%s)' % ', '.join(out)
    __str__ = __repr__

class FREE_STATEID4res:
    # XDR definition:
    # struct FREE_STATEID4res {
    #     nfsstat4 fsr_status;
    # };
    def __init__(self, fsr_status=None):
        self.fsr_status = fsr_status

    def __repr__(self):
        out = []
        if self.fsr_status is not None:
            out += ['fsr_status=%s' % const.nfsstat4.get(self.fsr_status, self.fsr_status)]
        return 'FREE_STATEID4res(%s)' % ', '.join(out)
    __str__ = __repr__

attr_notice4 = nfstime4
class GET_DIR_DELEGATION4args:
    # XDR definition:
    # struct GET_DIR_DELEGATION4args {
    #     bool gdda_signal_deleg_avail;
    #     bitmap4 gdda_notification_types;
    #     attr_notice4 gdda_child_attr_delay;
    #     attr_notice4 gdda_dir_attr_delay;
    #     bitmap4 gdda_child_attributes;
    #     bitmap4 gdda_dir_attributes;
    # };
    def __init__(self, gdda_signal_deleg_avail=None, gdda_notification_types=None, gdda_child_attr_delay=None, gdda_dir_attr_delay=None, gdda_child_attributes=None, gdda_dir_attributes=None):
        self.gdda_signal_deleg_avail = gdda_signal_deleg_avail
        self.gdda_notification_types = gdda_notification_types
        self.gdda_child_attr_delay = gdda_child_attr_delay
        self.gdda_dir_attr_delay = gdda_dir_attr_delay
        self.gdda_child_attributes = gdda_child_attributes
        self.gdda_dir_attributes = gdda_dir_attributes

    def __repr__(self):
        out = []
        if self.gdda_signal_deleg_avail is not None:
            out += ['gdda_signal_deleg_avail=%s' % repr(self.gdda_signal_deleg_avail)]
        if self.gdda_notification_types is not None:
            out += ['gdda_notification_types=%s' % repr(self.gdda_notification_types)]
        if self.gdda_child_attr_delay is not None:
            out += ['gdda_child_attr_delay=%s' % repr(self.gdda_child_attr_delay)]
        if self.gdda_dir_attr_delay is not None:
            out += ['gdda_dir_attr_delay=%s' % repr(self.gdda_dir_attr_delay)]
        if self.gdda_child_attributes is not None:
            out += ['gdda_child_attributes=%s' % repr(self.gdda_child_attributes)]
        if self.gdda_dir_attributes is not None:
            out += ['gdda_dir_attributes=%s' % repr(self.gdda_dir_attributes)]
        return 'GET_DIR_DELEGATION4args(%s)' % ', '.join(out)
    __str__ = __repr__

class GET_DIR_DELEGATION4resok:
    # XDR definition:
    # struct GET_DIR_DELEGATION4resok {
    #     verifier4 gddr_cookieverf;
    #     stateid4 gddr_stateid;
    #     bitmap4 gddr_notification;
    #     bitmap4 gddr_child_attributes;
    #     bitmap4 gddr_dir_attributes;
    # };
    def __init__(self, gddr_cookieverf=None, gddr_stateid=None, gddr_notification=None, gddr_child_attributes=None, gddr_dir_attributes=None):
        self.gddr_cookieverf = gddr_cookieverf
        self.gddr_stateid = gddr_stateid
        self.gddr_notification = gddr_notification
        self.gddr_child_attributes = gddr_child_attributes
        self.gddr_dir_attributes = gddr_dir_attributes

    def __getattr__(self, attr):
        return getattr(self.gddr_stateid, attr)

    def __repr__(self):
        out = []
        if self.gddr_cookieverf is not None:
            out += ['gddr_cookieverf=%s' % repr(self.gddr_cookieverf)]
        if self.gddr_stateid is not None:
            out += ['gddr_stateid=%s' % repr(self.gddr_stateid)]
        if self.gddr_notification is not None:
            out += ['gddr_notification=%s' % repr(self.gddr_notification)]
        if self.gddr_child_attributes is not None:
            out += ['gddr_child_attributes=%s' % repr(self.gddr_child_attributes)]
        if self.gddr_dir_attributes is not None:
            out += ['gddr_dir_attributes=%s' % repr(self.gddr_dir_attributes)]
        return 'GET_DIR_DELEGATION4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class GET_DIR_DELEGATION4res_non_fatal:
    # XDR definition:
    # union GET_DIR_DELEGATION4res_non_fatal switch(gddrnf4_status gddrnf_status) {
    #     case GDD4_OK:
    #         GET_DIR_DELEGATION4resok gddrnf_resok4;
    #     case GDD4_UNAVAIL:
    #         bool gddrnf_will_signal_deleg_avail;
    # };
    def __init__(self, gddrnf_status=None, gddrnf_resok4=None, gddrnf_will_signal_deleg_avail=None):
        self.gddrnf_status = gddrnf_status
        self.gddrnf_resok4 = gddrnf_resok4
        self.gddrnf_will_signal_deleg_avail = gddrnf_will_signal_deleg_avail

    switch = property(lambda s: {const.GDD4_OK:s.gddrnf_resok4,const.GDD4_UNAVAIL:s.gddrnf_will_signal_deleg_avail,}[s.gddrnf_status])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.gddrnf_status is not None:
            out += ['gddrnf_status=%s' % const.gddrnf4_status.get(self.gddrnf_status, self.gddrnf_status)]
        if self.gddrnf_resok4 is not None:
            out += ['gddrnf_resok4=%s' % repr(self.gddrnf_resok4)]
        if self.gddrnf_will_signal_deleg_avail is not None:
            out += ['gddrnf_will_signal_deleg_avail=%s' % repr(self.gddrnf_will_signal_deleg_avail)]
        return 'GET_DIR_DELEGATION4res_non_fatal(%s)' % ', '.join(out)
    __str__ = __repr__

class GET_DIR_DELEGATION4res:
    # XDR definition:
    # union GET_DIR_DELEGATION4res switch(nfsstat4 gddr_status) {
    #     case NFS4_OK:
    #         GET_DIR_DELEGATION4res_non_fatal gddr_res_non_fatal4;
    #     default:
    #         void;
    # };
    def __init__(self, gddr_status=None, gddr_res_non_fatal4=None):
        self.gddr_status = gddr_status
        self.gddr_res_non_fatal4 = gddr_res_non_fatal4

    switch = property(lambda s: {const.NFS4_OK:s.gddr_res_non_fatal4,}.get(s.gddr_status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.gddr_status is not None:
            out += ['gddr_status=%s' % const.nfsstat4.get(self.gddr_status, self.gddr_status)]
        if self.gddr_res_non_fatal4 is not None:
            out += ['gddr_res_non_fatal4=%s' % repr(self.gddr_res_non_fatal4)]
        return 'GET_DIR_DELEGATION4res(%s)' % ', '.join(out)
    __str__ = __repr__

class GETDEVICEINFO4args:
    # XDR definition:
    # struct GETDEVICEINFO4args {
    #     deviceid4 gdia_device_id;
    #     layouttype4 gdia_layout_type;
    #     count4 gdia_maxcount;
    #     bitmap4 gdia_notify_types;
    # };
    def __init__(self, gdia_device_id=None, gdia_layout_type=None, gdia_maxcount=None, gdia_notify_types=None):
        self.gdia_device_id = gdia_device_id
        self.gdia_layout_type = gdia_layout_type
        self.gdia_maxcount = gdia_maxcount
        self.gdia_notify_types = gdia_notify_types

    def __repr__(self):
        out = []
        if self.gdia_device_id is not None:
            out += ['gdia_device_id=%s' % repr(self.gdia_device_id)]
        if self.gdia_layout_type is not None:
            out += ['gdia_layout_type=%s' % const.layouttype4.get(self.gdia_layout_type, self.gdia_layout_type)]
        if self.gdia_maxcount is not None:
            out += ['gdia_maxcount=%s' % repr(self.gdia_maxcount)]
        if self.gdia_notify_types is not None:
            out += ['gdia_notify_types=%s' % repr(self.gdia_notify_types)]
        return 'GETDEVICEINFO4args(%s)' % ', '.join(out)
    __str__ = __repr__

class GETDEVICEINFO4resok:
    # XDR definition:
    # struct GETDEVICEINFO4resok {
    #     device_addr4 gdir_device_addr;
    #     bitmap4 gdir_notification;
    # };
    def __init__(self, gdir_device_addr=None, gdir_notification=None):
        self.gdir_device_addr = gdir_device_addr
        self.gdir_notification = gdir_notification

    def __getattr__(self, attr):
        return getattr(self.gdir_device_addr, attr)

    def __repr__(self):
        out = []
        if self.gdir_device_addr is not None:
            out += ['gdir_device_addr=%s' % repr(self.gdir_device_addr)]
        if self.gdir_notification is not None:
            out += ['gdir_notification=%s' % repr(self.gdir_notification)]
        return 'GETDEVICEINFO4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class GETDEVICEINFO4res:
    # XDR definition:
    # union GETDEVICEINFO4res switch(nfsstat4 gdir_status) {
    #     case NFS4_OK:
    #         GETDEVICEINFO4resok gdir_resok4;
    #     case NFS4ERR_TOOSMALL:
    #         count4 gdir_mincount;
    #     default:
    #         void;
    # };
    def __init__(self, gdir_status=None, gdir_resok4=None, gdir_mincount=None):
        self.gdir_status = gdir_status
        self.gdir_resok4 = gdir_resok4
        self.gdir_mincount = gdir_mincount

    switch = property(lambda s: {const.NFS4_OK:s.gdir_resok4,const.NFS4ERR_TOOSMALL:s.gdir_mincount,}.get(s.gdir_status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.gdir_status is not None:
            out += ['gdir_status=%s' % const.nfsstat4.get(self.gdir_status, self.gdir_status)]
        if self.gdir_resok4 is not None:
            out += ['gdir_resok4=%s' % repr(self.gdir_resok4)]
        if self.gdir_mincount is not None:
            out += ['gdir_mincount=%s' % repr(self.gdir_mincount)]
        return 'GETDEVICEINFO4res(%s)' % ', '.join(out)
    __str__ = __repr__

class GETDEVICELIST4args:
    # XDR definition:
    # struct GETDEVICELIST4args {
    #     layouttype4 gdla_layout_type;
    #     count4 gdla_maxdevices;
    #     nfs_cookie4 gdla_cookie;
    #     verifier4 gdla_cookieverf;
    # };
    def __init__(self, gdla_layout_type=None, gdla_maxdevices=None, gdla_cookie=None, gdla_cookieverf=None):
        self.gdla_layout_type = gdla_layout_type
        self.gdla_maxdevices = gdla_maxdevices
        self.gdla_cookie = gdla_cookie
        self.gdla_cookieverf = gdla_cookieverf

    def __repr__(self):
        out = []
        if self.gdla_layout_type is not None:
            out += ['gdla_layout_type=%s' % const.layouttype4.get(self.gdla_layout_type, self.gdla_layout_type)]
        if self.gdla_maxdevices is not None:
            out += ['gdla_maxdevices=%s' % repr(self.gdla_maxdevices)]
        if self.gdla_cookie is not None:
            out += ['gdla_cookie=%s' % repr(self.gdla_cookie)]
        if self.gdla_cookieverf is not None:
            out += ['gdla_cookieverf=%s' % repr(self.gdla_cookieverf)]
        return 'GETDEVICELIST4args(%s)' % ', '.join(out)
    __str__ = __repr__

class GETDEVICELIST4resok:
    # XDR definition:
    # struct GETDEVICELIST4resok {
    #     nfs_cookie4 gdlr_cookie;
    #     verifier4 gdlr_cookieverf;
    #     deviceid4 gdlr_deviceid_list<>;
    #     bool gdlr_eof;
    # };
    def __init__(self, gdlr_cookie=None, gdlr_cookieverf=None, gdlr_deviceid_list=None, gdlr_eof=None):
        self.gdlr_cookie = gdlr_cookie
        self.gdlr_cookieverf = gdlr_cookieverf
        self.gdlr_deviceid_list = gdlr_deviceid_list
        self.gdlr_eof = gdlr_eof

    def __repr__(self):
        out = []
        if self.gdlr_cookie is not None:
            out += ['gdlr_cookie=%s' % repr(self.gdlr_cookie)]
        if self.gdlr_cookieverf is not None:
            out += ['gdlr_cookieverf=%s' % repr(self.gdlr_cookieverf)]
        if self.gdlr_deviceid_list is not None:
            out += ['gdlr_deviceid_list=%s' % repr(self.gdlr_deviceid_list)]
        if self.gdlr_eof is not None:
            out += ['gdlr_eof=%s' % repr(self.gdlr_eof)]
        return 'GETDEVICELIST4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class GETDEVICELIST4res:
    # XDR definition:
    # union GETDEVICELIST4res switch(nfsstat4 gdlr_status) {
    #     case NFS4_OK:
    #         GETDEVICELIST4resok gdlr_resok4;
    #     default:
    #         void;
    # };
    def __init__(self, gdlr_status=None, gdlr_resok4=None):
        self.gdlr_status = gdlr_status
        self.gdlr_resok4 = gdlr_resok4

    switch = property(lambda s: {const.NFS4_OK:s.gdlr_resok4,}.get(s.gdlr_status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.gdlr_status is not None:
            out += ['gdlr_status=%s' % const.nfsstat4.get(self.gdlr_status, self.gdlr_status)]
        if self.gdlr_resok4 is not None:
            out += ['gdlr_resok4=%s' % repr(self.gdlr_resok4)]
        return 'GETDEVICELIST4res(%s)' % ', '.join(out)
    __str__ = __repr__

class newtime4:
    # XDR definition:
    # union newtime4 switch(bool nt_timechanged) {
    #     case TRUE:
    #         nfstime4 nt_time;
    #     case FALSE:
    #         void;
    # };
    def __init__(self, nt_timechanged=None, nt_time=None):
        self.nt_timechanged = nt_timechanged
        self.nt_time = nt_time

    switch = property(lambda s: {const.TRUE:s.nt_time,const.FALSE:None,}[s.nt_timechanged])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.nt_timechanged is not None:
            out += ['nt_timechanged=%s' % repr(self.nt_timechanged)]
        if self.nt_time is not None:
            out += ['nt_time=%s' % repr(self.nt_time)]
        return 'newtime4(%s)' % ', '.join(out)
    __str__ = __repr__

class newoffset4:
    # XDR definition:
    # union newoffset4 switch(bool no_newoffset) {
    #     case TRUE:
    #         offset4 no_offset;
    #     case FALSE:
    #         void;
    # };
    def __init__(self, no_newoffset=None, no_offset=None):
        self.no_newoffset = no_newoffset
        self.no_offset = no_offset

    switch = property(lambda s: {const.TRUE:s.no_offset,const.FALSE:None,}[s.no_newoffset])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.no_newoffset is not None:
            out += ['no_newoffset=%s' % repr(self.no_newoffset)]
        if self.no_offset is not None:
            out += ['no_offset=%s' % repr(self.no_offset)]
        return 'newoffset4(%s)' % ', '.join(out)
    __str__ = __repr__

class LAYOUTCOMMIT4args:
    # XDR definition:
    # struct LAYOUTCOMMIT4args {
    #     offset4 loca_offset;
    #     length4 loca_length;
    #     bool loca_reclaim;
    #     stateid4 loca_stateid;
    #     newoffset4 loca_last_write_offset;
    #     newtime4 loca_time_modify;
    #     layoutupdate4 loca_layoutupdate;
    # };
    def __init__(self, loca_offset=None, loca_length=None, loca_reclaim=None, loca_stateid=None, loca_last_write_offset=None, loca_time_modify=None, loca_layoutupdate=None):
        self.loca_offset = loca_offset
        self.loca_length = loca_length
        self.loca_reclaim = loca_reclaim
        self.loca_stateid = loca_stateid
        self.loca_last_write_offset = loca_last_write_offset
        self.loca_time_modify = loca_time_modify
        self.loca_layoutupdate = loca_layoutupdate

    def __repr__(self):
        out = []
        if self.loca_offset is not None:
            out += ['loca_offset=%s' % repr(self.loca_offset)]
        if self.loca_length is not None:
            out += ['loca_length=%s' % repr(self.loca_length)]
        if self.loca_reclaim is not None:
            out += ['loca_reclaim=%s' % repr(self.loca_reclaim)]
        if self.loca_stateid is not None:
            out += ['loca_stateid=%s' % repr(self.loca_stateid)]
        if self.loca_last_write_offset is not None:
            out += ['loca_last_write_offset=%s' % repr(self.loca_last_write_offset)]
        if self.loca_time_modify is not None:
            out += ['loca_time_modify=%s' % repr(self.loca_time_modify)]
        if self.loca_layoutupdate is not None:
            out += ['loca_layoutupdate=%s' % repr(self.loca_layoutupdate)]
        return 'LAYOUTCOMMIT4args(%s)' % ', '.join(out)
    __str__ = __repr__

class newsize4:
    # XDR definition:
    # union newsize4 switch(bool ns_sizechanged) {
    #     case TRUE:
    #         length4 ns_size;
    #     case FALSE:
    #         void;
    # };
    def __init__(self, ns_sizechanged=None, ns_size=None):
        self.ns_sizechanged = ns_sizechanged
        self.ns_size = ns_size

    switch = property(lambda s: {const.TRUE:s.ns_size,const.FALSE:None,}[s.ns_sizechanged])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.ns_sizechanged is not None:
            out += ['ns_sizechanged=%s' % repr(self.ns_sizechanged)]
        if self.ns_size is not None:
            out += ['ns_size=%s' % repr(self.ns_size)]
        return 'newsize4(%s)' % ', '.join(out)
    __str__ = __repr__

class LAYOUTCOMMIT4resok:
    # XDR definition:
    # struct LAYOUTCOMMIT4resok {
    #     newsize4 locr_newsize;
    # };
    def __init__(self, locr_newsize=None):
        self.locr_newsize = locr_newsize

    def __getattr__(self, attr):
        return getattr(self.locr_newsize, attr)

    def __repr__(self):
        out = []
        if self.locr_newsize is not None:
            out += ['locr_newsize=%s' % repr(self.locr_newsize)]
        return 'LAYOUTCOMMIT4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class LAYOUTCOMMIT4res:
    # XDR definition:
    # union LAYOUTCOMMIT4res switch(nfsstat4 locr_status) {
    #     case NFS4_OK:
    #         LAYOUTCOMMIT4resok locr_resok4;
    #     default:
    #         void;
    # };
    def __init__(self, locr_status=None, locr_resok4=None):
        self.locr_status = locr_status
        self.locr_resok4 = locr_resok4

    switch = property(lambda s: {const.NFS4_OK:s.locr_resok4,}.get(s.locr_status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.locr_status is not None:
            out += ['locr_status=%s' % const.nfsstat4.get(self.locr_status, self.locr_status)]
        if self.locr_resok4 is not None:
            out += ['locr_resok4=%s' % repr(self.locr_resok4)]
        return 'LAYOUTCOMMIT4res(%s)' % ', '.join(out)
    __str__ = __repr__

class LAYOUTGET4args:
    # XDR definition:
    # struct LAYOUTGET4args {
    #     bool loga_signal_layout_avail;
    #     layouttype4 loga_layout_type;
    #     layoutiomode4 loga_iomode;
    #     offset4 loga_offset;
    #     length4 loga_length;
    #     length4 loga_minlength;
    #     stateid4 loga_stateid;
    #     count4 loga_maxcount;
    # };
    def __init__(self, loga_signal_layout_avail=None, loga_layout_type=None, loga_iomode=None, loga_offset=None, loga_length=None, loga_minlength=None, loga_stateid=None, loga_maxcount=None):
        self.loga_signal_layout_avail = loga_signal_layout_avail
        self.loga_layout_type = loga_layout_type
        self.loga_iomode = loga_iomode
        self.loga_offset = loga_offset
        self.loga_length = loga_length
        self.loga_minlength = loga_minlength
        self.loga_stateid = loga_stateid
        self.loga_maxcount = loga_maxcount

    def __getattr__(self, attr):
        return getattr(self.loga_stateid, attr)

    def __repr__(self):
        out = []
        if self.loga_signal_layout_avail is not None:
            out += ['loga_signal_layout_avail=%s' % repr(self.loga_signal_layout_avail)]
        if self.loga_layout_type is not None:
            out += ['loga_layout_type=%s' % const.layouttype4.get(self.loga_layout_type, self.loga_layout_type)]
        if self.loga_iomode is not None:
            out += ['loga_iomode=%s' % const.layoutiomode4.get(self.loga_iomode, self.loga_iomode)]
        if self.loga_offset is not None:
            out += ['loga_offset=%s' % repr(self.loga_offset)]
        if self.loga_length is not None:
            out += ['loga_length=%s' % repr(self.loga_length)]
        if self.loga_minlength is not None:
            out += ['loga_minlength=%s' % repr(self.loga_minlength)]
        if self.loga_stateid is not None:
            out += ['loga_stateid=%s' % repr(self.loga_stateid)]
        if self.loga_maxcount is not None:
            out += ['loga_maxcount=%s' % repr(self.loga_maxcount)]
        return 'LAYOUTGET4args(%s)' % ', '.join(out)
    __str__ = __repr__

class LAYOUTGET4resok:
    # XDR definition:
    # struct LAYOUTGET4resok {
    #     bool logr_return_on_close;
    #     stateid4 logr_stateid;
    #     layout4 logr_layout<>;
    # };
    def __init__(self, logr_return_on_close=None, logr_stateid=None, logr_layout=None):
        self.logr_return_on_close = logr_return_on_close
        self.logr_stateid = logr_stateid
        self.logr_layout = logr_layout

    def __getattr__(self, attr):
        return getattr(self.logr_stateid, attr)

    def __repr__(self):
        out = []
        if self.logr_return_on_close is not None:
            out += ['logr_return_on_close=%s' % repr(self.logr_return_on_close)]
        if self.logr_stateid is not None:
            out += ['logr_stateid=%s' % repr(self.logr_stateid)]
        if self.logr_layout is not None:
            out += ['logr_layout=%s' % repr(self.logr_layout)]
        return 'LAYOUTGET4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class LAYOUTGET4res:
    # XDR definition:
    # union LAYOUTGET4res switch(nfsstat4 logr_status) {
    #     case NFS4_OK:
    #         LAYOUTGET4resok logr_resok4;
    #     case NFS4ERR_LAYOUTTRYLATER:
    #         bool logr_will_signal_layout_avail;
    #     default:
    #         void;
    # };
    def __init__(self, logr_status=None, logr_resok4=None, logr_will_signal_layout_avail=None):
        self.logr_status = logr_status
        self.logr_resok4 = logr_resok4
        self.logr_will_signal_layout_avail = logr_will_signal_layout_avail

    switch = property(lambda s: {const.NFS4_OK:s.logr_resok4,const.NFS4ERR_LAYOUTTRYLATER:s.logr_will_signal_layout_avail,}.get(s.logr_status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.logr_status is not None:
            out += ['logr_status=%s' % const.nfsstat4.get(self.logr_status, self.logr_status)]
        if self.logr_resok4 is not None:
            out += ['logr_resok4=%s' % repr(self.logr_resok4)]
        if self.logr_will_signal_layout_avail is not None:
            out += ['logr_will_signal_layout_avail=%s' % repr(self.logr_will_signal_layout_avail)]
        return 'LAYOUTGET4res(%s)' % ', '.join(out)
    __str__ = __repr__

class LAYOUTRETURN4args:
    # XDR definition:
    # struct LAYOUTRETURN4args {
    #     bool lora_reclaim;
    #     layouttype4 lora_layout_type;
    #     layoutiomode4 lora_iomode;
    #     layoutreturn4 lora_layoutreturn;
    # };
    def __init__(self, lora_reclaim=None, lora_layout_type=None, lora_iomode=None, lora_layoutreturn=None):
        self.lora_reclaim = lora_reclaim
        self.lora_layout_type = lora_layout_type
        self.lora_iomode = lora_iomode
        self.lora_layoutreturn = lora_layoutreturn

    def __getattr__(self, attr):
        return getattr(self.lora_layoutreturn, attr)

    def __repr__(self):
        out = []
        if self.lora_reclaim is not None:
            out += ['lora_reclaim=%s' % repr(self.lora_reclaim)]
        if self.lora_layout_type is not None:
            out += ['lora_layout_type=%s' % const.layouttype4.get(self.lora_layout_type, self.lora_layout_type)]
        if self.lora_iomode is not None:
            out += ['lora_iomode=%s' % const.layoutiomode4.get(self.lora_iomode, self.lora_iomode)]
        if self.lora_layoutreturn is not None:
            out += ['lora_layoutreturn=%s' % repr(self.lora_layoutreturn)]
        return 'LAYOUTRETURN4args(%s)' % ', '.join(out)
    __str__ = __repr__

class layoutreturn_stateid:
    # XDR definition:
    # union layoutreturn_stateid switch(bool lrs_present) {
    #     case TRUE:
    #         stateid4 lrs_stateid;
    #     case FALSE:
    #         void;
    # };
    def __init__(self, lrs_present=None, lrs_stateid=None):
        self.lrs_present = lrs_present
        self.lrs_stateid = lrs_stateid

    switch = property(lambda s: {const.TRUE:s.lrs_stateid,const.FALSE:None,}[s.lrs_present])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.lrs_present is not None:
            out += ['lrs_present=%s' % repr(self.lrs_present)]
        if self.lrs_stateid is not None:
            out += ['lrs_stateid=%s' % repr(self.lrs_stateid)]
        return 'layoutreturn_stateid(%s)' % ', '.join(out)
    __str__ = __repr__

class LAYOUTRETURN4res:
    # XDR definition:
    # union LAYOUTRETURN4res switch(nfsstat4 lorr_status) {
    #     case NFS4_OK:
    #         layoutreturn_stateid lorr_stateid;
    #     default:
    #         void;
    # };
    def __init__(self, lorr_status=None, lorr_stateid=None):
        self.lorr_status = lorr_status
        self.lorr_stateid = lorr_stateid

    switch = property(lambda s: {const.NFS4_OK:s.lorr_stateid,}.get(s.lorr_status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.lorr_status is not None:
            out += ['lorr_status=%s' % const.nfsstat4.get(self.lorr_status, self.lorr_status)]
        if self.lorr_stateid is not None:
            out += ['lorr_stateid=%s' % repr(self.lorr_stateid)]
        return 'LAYOUTRETURN4res(%s)' % ', '.join(out)
    __str__ = __repr__

SECINFO_NO_NAME4args = const.secinfo_style4
SECINFO_NO_NAME4res = SECINFO4res
class SEQUENCE4args:
    # XDR definition:
    # struct SEQUENCE4args {
    #     sessionid4 sa_sessionid;
    #     sequenceid4 sa_sequenceid;
    #     slotid4 sa_slotid;
    #     slotid4 sa_highest_slotid;
    #     bool sa_cachethis;
    # };
    def __init__(self, sa_sessionid=None, sa_sequenceid=None, sa_slotid=None, sa_highest_slotid=None, sa_cachethis=None):
        self.sa_sessionid = sa_sessionid
        self.sa_sequenceid = sa_sequenceid
        self.sa_slotid = sa_slotid
        self.sa_highest_slotid = sa_highest_slotid
        self.sa_cachethis = sa_cachethis

    def __repr__(self):
        out = []
        if self.sa_sessionid is not None:
            out += ['sa_sessionid=%s' % repr(self.sa_sessionid)]
        if self.sa_sequenceid is not None:
            out += ['sa_sequenceid=%s' % repr(self.sa_sequenceid)]
        if self.sa_slotid is not None:
            out += ['sa_slotid=%s' % repr(self.sa_slotid)]
        if self.sa_highest_slotid is not None:
            out += ['sa_highest_slotid=%s' % repr(self.sa_highest_slotid)]
        if self.sa_cachethis is not None:
            out += ['sa_cachethis=%s' % repr(self.sa_cachethis)]
        return 'SEQUENCE4args(%s)' % ', '.join(out)
    __str__ = __repr__

class SEQUENCE4resok:
    # XDR definition:
    # struct SEQUENCE4resok {
    #     sessionid4 sr_sessionid;
    #     sequenceid4 sr_sequenceid;
    #     slotid4 sr_slotid;
    #     slotid4 sr_highest_slotid;
    #     slotid4 sr_target_highest_slotid;
    #     uint32_t sr_status_flags;
    # };
    def __init__(self, sr_sessionid=None, sr_sequenceid=None, sr_slotid=None, sr_highest_slotid=None, sr_target_highest_slotid=None, sr_status_flags=None):
        self.sr_sessionid = sr_sessionid
        self.sr_sequenceid = sr_sequenceid
        self.sr_slotid = sr_slotid
        self.sr_highest_slotid = sr_highest_slotid
        self.sr_target_highest_slotid = sr_target_highest_slotid
        self.sr_status_flags = sr_status_flags

    def __repr__(self):
        out = []
        if self.sr_sessionid is not None:
            out += ['sr_sessionid=%s' % repr(self.sr_sessionid)]
        if self.sr_sequenceid is not None:
            out += ['sr_sequenceid=%s' % repr(self.sr_sequenceid)]
        if self.sr_slotid is not None:
            out += ['sr_slotid=%s' % repr(self.sr_slotid)]
        if self.sr_highest_slotid is not None:
            out += ['sr_highest_slotid=%s' % repr(self.sr_highest_slotid)]
        if self.sr_target_highest_slotid is not None:
            out += ['sr_target_highest_slotid=%s' % repr(self.sr_target_highest_slotid)]
        if self.sr_status_flags is not None:
            out += ['sr_status_flags=%s' % repr(self.sr_status_flags)]
        return 'SEQUENCE4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class SEQUENCE4res:
    # XDR definition:
    # union SEQUENCE4res switch(nfsstat4 sr_status) {
    #     case NFS4_OK:
    #         SEQUENCE4resok sr_resok4;
    #     default:
    #         void;
    # };
    def __init__(self, sr_status=None, sr_resok4=None):
        self.sr_status = sr_status
        self.sr_resok4 = sr_resok4

    switch = property(lambda s: {const.NFS4_OK:s.sr_resok4,}.get(s.sr_status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.sr_status is not None:
            out += ['sr_status=%s' % const.nfsstat4.get(self.sr_status, self.sr_status)]
        if self.sr_resok4 is not None:
            out += ['sr_resok4=%s' % repr(self.sr_resok4)]
        return 'SEQUENCE4res(%s)' % ', '.join(out)
    __str__ = __repr__

class ssa_digest_input4:
    # XDR definition:
    # struct ssa_digest_input4 {
    #     SEQUENCE4args sdi_seqargs;
    # };
    def __init__(self, sdi_seqargs=None):
        self.sdi_seqargs = sdi_seqargs

    def __getattr__(self, attr):
        return getattr(self.sdi_seqargs, attr)

    def __repr__(self):
        out = []
        if self.sdi_seqargs is not None:
            out += ['sdi_seqargs=%s' % repr(self.sdi_seqargs)]
        return 'ssa_digest_input4(%s)' % ', '.join(out)
    __str__ = __repr__

class SET_SSV4args:
    # XDR definition:
    # struct SET_SSV4args {
    #     opaque ssa_ssv<>;
    #     opaque ssa_digest<>;
    # };
    def __init__(self, ssa_ssv=None, ssa_digest=None):
        self.ssa_ssv = ssa_ssv
        self.ssa_digest = ssa_digest

    def __repr__(self):
        out = []
        if self.ssa_ssv is not None:
            out += ['ssa_ssv=%s' % repr(self.ssa_ssv)]
        if self.ssa_digest is not None:
            out += ['ssa_digest=%s' % repr(self.ssa_digest)]
        return 'SET_SSV4args(%s)' % ', '.join(out)
    __str__ = __repr__

class ssr_digest_input4:
    # XDR definition:
    # struct ssr_digest_input4 {
    #     SEQUENCE4res sdi_seqres;
    # };
    def __init__(self, sdi_seqres=None):
        self.sdi_seqres = sdi_seqres

    def __getattr__(self, attr):
        return getattr(self.sdi_seqres, attr)

    def __repr__(self):
        out = []
        if self.sdi_seqres is not None:
            out += ['sdi_seqres=%s' % repr(self.sdi_seqres)]
        return 'ssr_digest_input4(%s)' % ', '.join(out)
    __str__ = __repr__

class SET_SSV4resok:
    # XDR definition:
    # struct SET_SSV4resok {
    #     opaque ssr_digest<>;
    # };
    def __init__(self, ssr_digest=None):
        self.ssr_digest = ssr_digest

    def __repr__(self):
        out = []
        if self.ssr_digest is not None:
            out += ['ssr_digest=%s' % repr(self.ssr_digest)]
        return 'SET_SSV4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class SET_SSV4res:
    # XDR definition:
    # union SET_SSV4res switch(nfsstat4 ssr_status) {
    #     case NFS4_OK:
    #         SET_SSV4resok ssr_resok4;
    #     default:
    #         void;
    # };
    def __init__(self, ssr_status=None, ssr_resok4=None):
        self.ssr_status = ssr_status
        self.ssr_resok4 = ssr_resok4

    switch = property(lambda s: {const.NFS4_OK:s.ssr_resok4,}.get(s.ssr_status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.ssr_status is not None:
            out += ['ssr_status=%s' % const.nfsstat4.get(self.ssr_status, self.ssr_status)]
        if self.ssr_resok4 is not None:
            out += ['ssr_resok4=%s' % repr(self.ssr_resok4)]
        return 'SET_SSV4res(%s)' % ', '.join(out)
    __str__ = __repr__

class TEST_STATEID4args:
    # XDR definition:
    # struct TEST_STATEID4args {
    #     stateid4 ts_stateids<>;
    # };
    def __init__(self, ts_stateids=None):
        self.ts_stateids = ts_stateids

    def __repr__(self):
        out = []
        if self.ts_stateids is not None:
            out += ['ts_stateids=%s' % repr(self.ts_stateids)]
        return 'TEST_STATEID4args(%s)' % ', '.join(out)
    __str__ = __repr__

class TEST_STATEID4resok:
    # XDR definition:
    # struct TEST_STATEID4resok {
    #     nfsstat4 tsr_status_codes<>;
    # };
    def __init__(self, tsr_status_codes=None):
        self.tsr_status_codes = tsr_status_codes

    def __repr__(self):
        out = []
        if self.tsr_status_codes is not None:
            out += ['tsr_status_codes=%s' % const.nfsstat4.get(self.tsr_status_codes, self.tsr_status_codes)]
        return 'TEST_STATEID4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class TEST_STATEID4res:
    # XDR definition:
    # union TEST_STATEID4res switch(nfsstat4 tsr_status) {
    #     case NFS4_OK:
    #         TEST_STATEID4resok tsr_resok4;
    #     default:
    #         void;
    # };
    def __init__(self, tsr_status=None, tsr_resok4=None):
        self.tsr_status = tsr_status
        self.tsr_resok4 = tsr_resok4

    switch = property(lambda s: {const.NFS4_OK:s.tsr_resok4,}.get(s.tsr_status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.tsr_status is not None:
            out += ['tsr_status=%s' % const.nfsstat4.get(self.tsr_status, self.tsr_status)]
        if self.tsr_resok4 is not None:
            out += ['tsr_resok4=%s' % repr(self.tsr_resok4)]
        return 'TEST_STATEID4res(%s)' % ', '.join(out)
    __str__ = __repr__

class deleg_claim4:
    # XDR definition:
    # union deleg_claim4 switch(open_claim_type4 dc_claim) {
    #     case CLAIM_FH:
    #         void;
    #     case CLAIM_DELEG_PREV_FH:
    #         void;
    #     case CLAIM_PREVIOUS:
    #         open_delegation_type4 dc_delegate_type;
    # };
    def __init__(self, dc_claim=None, dc_delegate_type=None):
        self.dc_claim = dc_claim
        self.dc_delegate_type = dc_delegate_type

    switch = property(lambda s: {const.CLAIM_FH:None,const.CLAIM_DELEG_PREV_FH:None,const.CLAIM_PREVIOUS:s.dc_delegate_type,}[s.dc_claim])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.dc_claim is not None:
            out += ['dc_claim=%s' % const.open_claim_type4.get(self.dc_claim, self.dc_claim)]
        if self.dc_delegate_type is not None:
            out += ['dc_delegate_type=%s' % const.open_delegation_type4.get(self.dc_delegate_type, self.dc_delegate_type)]
        return 'deleg_claim4(%s)' % ', '.join(out)
    __str__ = __repr__

class WANT_DELEGATION4args:
    # XDR definition:
    # struct WANT_DELEGATION4args {
    #     uint32_t wda_want;
    #     deleg_claim4 wda_claim;
    # };
    def __init__(self, wda_want=None, wda_claim=None):
        self.wda_want = wda_want
        self.wda_claim = wda_claim

    def __getattr__(self, attr):
        return getattr(self.wda_claim, attr)

    def __repr__(self):
        out = []
        if self.wda_want is not None:
            out += ['wda_want=%s' % repr(self.wda_want)]
        if self.wda_claim is not None:
            out += ['wda_claim=%s' % repr(self.wda_claim)]
        return 'WANT_DELEGATION4args(%s)' % ', '.join(out)
    __str__ = __repr__

class WANT_DELEGATION4res:
    # XDR definition:
    # union WANT_DELEGATION4res switch(nfsstat4 wdr_status) {
    #     case NFS4_OK:
    #         open_delegation4 wdr_resok4;
    #     default:
    #         void;
    # };
    def __init__(self, wdr_status=None, wdr_resok4=None):
        self.wdr_status = wdr_status
        self.wdr_resok4 = wdr_resok4

    switch = property(lambda s: {const.NFS4_OK:s.wdr_resok4,}.get(s.wdr_status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.wdr_status is not None:
            out += ['wdr_status=%s' % const.nfsstat4.get(self.wdr_status, self.wdr_status)]
        if self.wdr_resok4 is not None:
            out += ['wdr_resok4=%s' % repr(self.wdr_resok4)]
        return 'WANT_DELEGATION4res(%s)' % ', '.join(out)
    __str__ = __repr__

class DESTROY_CLIENTID4args:
    # XDR definition:
    # struct DESTROY_CLIENTID4args {
    #     clientid4 dca_clientid;
    # };
    def __init__(self, dca_clientid=None):
        self.dca_clientid = dca_clientid

    def __repr__(self):
        out = []
        if self.dca_clientid is not None:
            out += ['dca_clientid=%s' % repr(self.dca_clientid)]
        return 'DESTROY_CLIENTID4args(%s)' % ', '.join(out)
    __str__ = __repr__

class DESTROY_CLIENTID4res:
    # XDR definition:
    # struct DESTROY_CLIENTID4res {
    #     nfsstat4 dcr_status;
    # };
    def __init__(self, dcr_status=None):
        self.dcr_status = dcr_status

    def __repr__(self):
        out = []
        if self.dcr_status is not None:
            out += ['dcr_status=%s' % const.nfsstat4.get(self.dcr_status, self.dcr_status)]
        return 'DESTROY_CLIENTID4res(%s)' % ', '.join(out)
    __str__ = __repr__

class RECLAIM_COMPLETE4args:
    # XDR definition:
    # struct RECLAIM_COMPLETE4args {
    #     bool rca_one_fs;
    # };
    def __init__(self, rca_one_fs=None):
        self.rca_one_fs = rca_one_fs

    def __repr__(self):
        out = []
        if self.rca_one_fs is not None:
            out += ['rca_one_fs=%s' % repr(self.rca_one_fs)]
        return 'RECLAIM_COMPLETE4args(%s)' % ', '.join(out)
    __str__ = __repr__

class RECLAIM_COMPLETE4res:
    # XDR definition:
    # struct RECLAIM_COMPLETE4res {
    #     nfsstat4 rcr_status;
    # };
    def __init__(self, rcr_status=None):
        self.rcr_status = rcr_status

    def __repr__(self):
        out = []
        if self.rcr_status is not None:
            out += ['rcr_status=%s' % const.nfsstat4.get(self.rcr_status, self.rcr_status)]
        return 'RECLAIM_COMPLETE4res(%s)' % ', '.join(out)
    __str__ = __repr__

class nfs_argop4:
    # XDR definition:
    # union nfs_argop4 switch(nfs_opnum4 argop) {
    #     case OP_ACCESS:
    #         ACCESS4args opaccess;
    #     case OP_CLOSE:
    #         CLOSE4args opclose;
    #     case OP_COMMIT:
    #         COMMIT4args opcommit;
    #     case OP_CREATE:
    #         CREATE4args opcreate;
    #     case OP_DELEGPURGE:
    #         DELEGPURGE4args opdelegpurge;
    #     case OP_DELEGRETURN:
    #         DELEGRETURN4args opdelegreturn;
    #     case OP_GETATTR:
    #         GETATTR4args opgetattr;
    #     case OP_GETFH:
    #         void;
    #     case OP_LINK:
    #         LINK4args oplink;
    #     case OP_LOCK:
    #         LOCK4args oplock;
    #     case OP_LOCKT:
    #         LOCKT4args oplockt;
    #     case OP_LOCKU:
    #         LOCKU4args oplocku;
    #     case OP_LOOKUP:
    #         LOOKUP4args oplookup;
    #     case OP_LOOKUPP:
    #         void;
    #     case OP_NVERIFY:
    #         NVERIFY4args opnverify;
    #     case OP_OPEN:
    #         OPEN4args opopen;
    #     case OP_OPENATTR:
    #         OPENATTR4args opopenattr;
    #     case OP_OPEN_CONFIRM:
    #         OPEN_CONFIRM4args opopen_confirm;
    #     case OP_OPEN_DOWNGRADE:
    #         OPEN_DOWNGRADE4args opopen_downgrade;
    #     case OP_PUTFH:
    #         PUTFH4args opputfh;
    #     case OP_PUTPUBFH:
    #         void;
    #     case OP_PUTROOTFH:
    #         void;
    #     case OP_READ:
    #         READ4args opread;
    #     case OP_READDIR:
    #         READDIR4args opreaddir;
    #     case OP_READLINK:
    #         void;
    #     case OP_REMOVE:
    #         REMOVE4args opremove;
    #     case OP_RENAME:
    #         RENAME4args oprename;
    #     case OP_RENEW:
    #         RENEW4args oprenew;
    #     case OP_RESTOREFH:
    #         void;
    #     case OP_SAVEFH:
    #         void;
    #     case OP_SECINFO:
    #         SECINFO4args opsecinfo;
    #     case OP_SETATTR:
    #         SETATTR4args opsetattr;
    #     case OP_SETCLIENTID:
    #         SETCLIENTID4args opsetclientid;
    #     case OP_SETCLIENTID_CONFIRM:
    #         SETCLIENTID_CONFIRM4args opsetclientid_confirm;
    #     case OP_VERIFY:
    #         VERIFY4args opverify;
    #     case OP_WRITE:
    #         WRITE4args opwrite;
    #     case OP_RELEASE_LOCKOWNER:
    #         RELEASE_LOCKOWNER4args oprelease_lockowner;
    #     case OP_BACKCHANNEL_CTL:
    #         BACKCHANNEL_CTL4args opbackchannel_ctl;
    #     case OP_BIND_CONN_TO_SESSION:
    #         BIND_CONN_TO_SESSION4args opbind_conn_to_session;
    #     case OP_EXCHANGE_ID:
    #         EXCHANGE_ID4args opexchange_id;
    #     case OP_CREATE_SESSION:
    #         CREATE_SESSION4args opcreate_session;
    #     case OP_DESTROY_SESSION:
    #         DESTROY_SESSION4args opdestroy_session;
    #     case OP_FREE_STATEID:
    #         FREE_STATEID4args opfree_stateid;
    #     case OP_GET_DIR_DELEGATION:
    #         GET_DIR_DELEGATION4args opget_dir_delegation;
    #     case OP_GETDEVICEINFO:
    #         GETDEVICEINFO4args opgetdeviceinfo;
    #     case OP_GETDEVICELIST:
    #         GETDEVICELIST4args opgetdevicelist;
    #     case OP_LAYOUTCOMMIT:
    #         LAYOUTCOMMIT4args oplayoutcommit;
    #     case OP_LAYOUTGET:
    #         LAYOUTGET4args oplayoutget;
    #     case OP_LAYOUTRETURN:
    #         LAYOUTRETURN4args oplayoutreturn;
    #     case OP_SECINFO_NO_NAME:
    #         SECINFO_NO_NAME4args opsecinfo_no_name;
    #     case OP_SEQUENCE:
    #         SEQUENCE4args opsequence;
    #     case OP_SET_SSV:
    #         SET_SSV4args opset_ssv;
    #     case OP_TEST_STATEID:
    #         TEST_STATEID4args optest_stateid;
    #     case OP_WANT_DELEGATION:
    #         WANT_DELEGATION4args opwant_delegation;
    #     case OP_DESTROY_CLIENTID:
    #         DESTROY_CLIENTID4args opdestroy_clientid;
    #     case OP_RECLAIM_COMPLETE:
    #         RECLAIM_COMPLETE4args opreclaim_complete;
    #     case OP_ILLEGAL:
    #         void;
    # };
    def __init__(self, argop=None, opaccess=None, opclose=None, opcommit=None, opcreate=None, opdelegpurge=None, opdelegreturn=None, opgetattr=None, oplink=None, oplock=None, oplockt=None, oplocku=None, oplookup=None, opnverify=None, opopen=None, opopenattr=None, opopen_confirm=None, opopen_downgrade=None, opputfh=None, opread=None, opreaddir=None, opremove=None, oprename=None, oprenew=None, opsecinfo=None, opsetattr=None, opsetclientid=None, opsetclientid_confirm=None, opverify=None, opwrite=None, oprelease_lockowner=None, opbackchannel_ctl=None, opbind_conn_to_session=None, opexchange_id=None, opcreate_session=None, opdestroy_session=None, opfree_stateid=None, opget_dir_delegation=None, opgetdeviceinfo=None, opgetdevicelist=None, oplayoutcommit=None, oplayoutget=None, oplayoutreturn=None, opsecinfo_no_name=None, opsequence=None, opset_ssv=None, optest_stateid=None, opwant_delegation=None, opdestroy_clientid=None, opreclaim_complete=None):
        self.argop = argop
        self.opaccess = opaccess
        self.opclose = opclose
        self.opcommit = opcommit
        self.opcreate = opcreate
        self.opdelegpurge = opdelegpurge
        self.opdelegreturn = opdelegreturn
        self.opgetattr = opgetattr
        self.oplink = oplink
        self.oplock = oplock
        self.oplockt = oplockt
        self.oplocku = oplocku
        self.oplookup = oplookup
        self.opnverify = opnverify
        self.opopen = opopen
        self.opopenattr = opopenattr
        self.opopen_confirm = opopen_confirm
        self.opopen_downgrade = opopen_downgrade
        self.opputfh = opputfh
        self.opread = opread
        self.opreaddir = opreaddir
        self.opremove = opremove
        self.oprename = oprename
        self.oprenew = oprenew
        self.opsecinfo = opsecinfo
        self.opsetattr = opsetattr
        self.opsetclientid = opsetclientid
        self.opsetclientid_confirm = opsetclientid_confirm
        self.opverify = opverify
        self.opwrite = opwrite
        self.oprelease_lockowner = oprelease_lockowner
        self.opbackchannel_ctl = opbackchannel_ctl
        self.opbind_conn_to_session = opbind_conn_to_session
        self.opexchange_id = opexchange_id
        self.opcreate_session = opcreate_session
        self.opdestroy_session = opdestroy_session
        self.opfree_stateid = opfree_stateid
        self.opget_dir_delegation = opget_dir_delegation
        self.opgetdeviceinfo = opgetdeviceinfo
        self.opgetdevicelist = opgetdevicelist
        self.oplayoutcommit = oplayoutcommit
        self.oplayoutget = oplayoutget
        self.oplayoutreturn = oplayoutreturn
        self.opsecinfo_no_name = opsecinfo_no_name
        self.opsequence = opsequence
        self.opset_ssv = opset_ssv
        self.optest_stateid = optest_stateid
        self.opwant_delegation = opwant_delegation
        self.opdestroy_clientid = opdestroy_clientid
        self.opreclaim_complete = opreclaim_complete

    switch = property(lambda s: {const.OP_ACCESS:s.opaccess,const.OP_CLOSE:s.opclose,const.OP_COMMIT:s.opcommit,const.OP_CREATE:s.opcreate,const.OP_DELEGPURGE:s.opdelegpurge,const.OP_DELEGRETURN:s.opdelegreturn,const.OP_GETATTR:s.opgetattr,const.OP_GETFH:None,const.OP_LINK:s.oplink,const.OP_LOCK:s.oplock,const.OP_LOCKT:s.oplockt,const.OP_LOCKU:s.oplocku,const.OP_LOOKUP:s.oplookup,const.OP_LOOKUPP:None,const.OP_NVERIFY:s.opnverify,const.OP_OPEN:s.opopen,const.OP_OPENATTR:s.opopenattr,const.OP_OPEN_CONFIRM:s.opopen_confirm,const.OP_OPEN_DOWNGRADE:s.opopen_downgrade,const.OP_PUTFH:s.opputfh,const.OP_PUTPUBFH:None,const.OP_PUTROOTFH:None,const.OP_READ:s.opread,const.OP_READDIR:s.opreaddir,const.OP_READLINK:None,const.OP_REMOVE:s.opremove,const.OP_RENAME:s.oprename,const.OP_RENEW:s.oprenew,const.OP_RESTOREFH:None,const.OP_SAVEFH:None,const.OP_SECINFO:s.opsecinfo,const.OP_SETATTR:s.opsetattr,const.OP_SETCLIENTID:s.opsetclientid,const.OP_SETCLIENTID_CONFIRM:s.opsetclientid_confirm,const.OP_VERIFY:s.opverify,const.OP_WRITE:s.opwrite,const.OP_RELEASE_LOCKOWNER:s.oprelease_lockowner,const.OP_BACKCHANNEL_CTL:s.opbackchannel_ctl,const.OP_BIND_CONN_TO_SESSION:s.opbind_conn_to_session,const.OP_EXCHANGE_ID:s.opexchange_id,const.OP_CREATE_SESSION:s.opcreate_session,const.OP_DESTROY_SESSION:s.opdestroy_session,const.OP_FREE_STATEID:s.opfree_stateid,const.OP_GET_DIR_DELEGATION:s.opget_dir_delegation,const.OP_GETDEVICEINFO:s.opgetdeviceinfo,const.OP_GETDEVICELIST:s.opgetdevicelist,const.OP_LAYOUTCOMMIT:s.oplayoutcommit,const.OP_LAYOUTGET:s.oplayoutget,const.OP_LAYOUTRETURN:s.oplayoutreturn,const.OP_SECINFO_NO_NAME:s.opsecinfo_no_name,const.OP_SEQUENCE:s.opsequence,const.OP_SET_SSV:s.opset_ssv,const.OP_TEST_STATEID:s.optest_stateid,const.OP_WANT_DELEGATION:s.opwant_delegation,const.OP_DESTROY_CLIENTID:s.opdestroy_clientid,const.OP_RECLAIM_COMPLETE:s.opreclaim_complete,const.OP_ILLEGAL:None,}[s.argop])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.argop is not None:
            out += ['argop=%s' % const.nfs_opnum4.get(self.argop, self.argop)]
        if self.opaccess is not None:
            out += ['opaccess=%s' % repr(self.opaccess)]
        if self.opclose is not None:
            out += ['opclose=%s' % repr(self.opclose)]
        if self.opcommit is not None:
            out += ['opcommit=%s' % repr(self.opcommit)]
        if self.opcreate is not None:
            out += ['opcreate=%s' % repr(self.opcreate)]
        if self.opdelegpurge is not None:
            out += ['opdelegpurge=%s' % repr(self.opdelegpurge)]
        if self.opdelegreturn is not None:
            out += ['opdelegreturn=%s' % repr(self.opdelegreturn)]
        if self.opgetattr is not None:
            out += ['opgetattr=%s' % repr(self.opgetattr)]
        if self.oplink is not None:
            out += ['oplink=%s' % repr(self.oplink)]
        if self.oplock is not None:
            out += ['oplock=%s' % repr(self.oplock)]
        if self.oplockt is not None:
            out += ['oplockt=%s' % repr(self.oplockt)]
        if self.oplocku is not None:
            out += ['oplocku=%s' % repr(self.oplocku)]
        if self.oplookup is not None:
            out += ['oplookup=%s' % repr(self.oplookup)]
        if self.opnverify is not None:
            out += ['opnverify=%s' % repr(self.opnverify)]
        if self.opopen is not None:
            out += ['opopen=%s' % repr(self.opopen)]
        if self.opopenattr is not None:
            out += ['opopenattr=%s' % repr(self.opopenattr)]
        if self.opopen_confirm is not None:
            out += ['opopen_confirm=%s' % repr(self.opopen_confirm)]
        if self.opopen_downgrade is not None:
            out += ['opopen_downgrade=%s' % repr(self.opopen_downgrade)]
        if self.opputfh is not None:
            out += ['opputfh=%s' % repr(self.opputfh)]
        if self.opread is not None:
            out += ['opread=%s' % repr(self.opread)]
        if self.opreaddir is not None:
            out += ['opreaddir=%s' % repr(self.opreaddir)]
        if self.opremove is not None:
            out += ['opremove=%s' % repr(self.opremove)]
        if self.oprename is not None:
            out += ['oprename=%s' % repr(self.oprename)]
        if self.oprenew is not None:
            out += ['oprenew=%s' % repr(self.oprenew)]
        if self.opsecinfo is not None:
            out += ['opsecinfo=%s' % repr(self.opsecinfo)]
        if self.opsetattr is not None:
            out += ['opsetattr=%s' % repr(self.opsetattr)]
        if self.opsetclientid is not None:
            out += ['opsetclientid=%s' % repr(self.opsetclientid)]
        if self.opsetclientid_confirm is not None:
            out += ['opsetclientid_confirm=%s' % repr(self.opsetclientid_confirm)]
        if self.opverify is not None:
            out += ['opverify=%s' % repr(self.opverify)]
        if self.opwrite is not None:
            out += ['opwrite=%s' % repr(self.opwrite)]
        if self.oprelease_lockowner is not None:
            out += ['oprelease_lockowner=%s' % repr(self.oprelease_lockowner)]
        if self.opbackchannel_ctl is not None:
            out += ['opbackchannel_ctl=%s' % repr(self.opbackchannel_ctl)]
        if self.opbind_conn_to_session is not None:
            out += ['opbind_conn_to_session=%s' % repr(self.opbind_conn_to_session)]
        if self.opexchange_id is not None:
            out += ['opexchange_id=%s' % repr(self.opexchange_id)]
        if self.opcreate_session is not None:
            out += ['opcreate_session=%s' % repr(self.opcreate_session)]
        if self.opdestroy_session is not None:
            out += ['opdestroy_session=%s' % repr(self.opdestroy_session)]
        if self.opfree_stateid is not None:
            out += ['opfree_stateid=%s' % repr(self.opfree_stateid)]
        if self.opget_dir_delegation is not None:
            out += ['opget_dir_delegation=%s' % repr(self.opget_dir_delegation)]
        if self.opgetdeviceinfo is not None:
            out += ['opgetdeviceinfo=%s' % repr(self.opgetdeviceinfo)]
        if self.opgetdevicelist is not None:
            out += ['opgetdevicelist=%s' % repr(self.opgetdevicelist)]
        if self.oplayoutcommit is not None:
            out += ['oplayoutcommit=%s' % repr(self.oplayoutcommit)]
        if self.oplayoutget is not None:
            out += ['oplayoutget=%s' % repr(self.oplayoutget)]
        if self.oplayoutreturn is not None:
            out += ['oplayoutreturn=%s' % repr(self.oplayoutreturn)]
        if self.opsecinfo_no_name is not None:
            out += ['opsecinfo_no_name=%s' % repr(self.opsecinfo_no_name)]
        if self.opsequence is not None:
            out += ['opsequence=%s' % repr(self.opsequence)]
        if self.opset_ssv is not None:
            out += ['opset_ssv=%s' % repr(self.opset_ssv)]
        if self.optest_stateid is not None:
            out += ['optest_stateid=%s' % repr(self.optest_stateid)]
        if self.opwant_delegation is not None:
            out += ['opwant_delegation=%s' % repr(self.opwant_delegation)]
        if self.opdestroy_clientid is not None:
            out += ['opdestroy_clientid=%s' % repr(self.opdestroy_clientid)]
        if self.opreclaim_complete is not None:
            out += ['opreclaim_complete=%s' % repr(self.opreclaim_complete)]
        return 'nfs_argop4(%s)' % ', '.join(out)
    __str__ = __repr__

class nfs_resop4:
    # XDR definition:
    # union nfs_resop4 switch(nfs_opnum4 resop) {
    #     case OP_ACCESS:
    #         ACCESS4res opaccess;
    #     case OP_CLOSE:
    #         CLOSE4res opclose;
    #     case OP_COMMIT:
    #         COMMIT4res opcommit;
    #     case OP_CREATE:
    #         CREATE4res opcreate;
    #     case OP_DELEGPURGE:
    #         DELEGPURGE4res opdelegpurge;
    #     case OP_DELEGRETURN:
    #         DELEGRETURN4res opdelegreturn;
    #     case OP_GETATTR:
    #         GETATTR4res opgetattr;
    #     case OP_GETFH:
    #         GETFH4res opgetfh;
    #     case OP_LINK:
    #         LINK4res oplink;
    #     case OP_LOCK:
    #         LOCK4res oplock;
    #     case OP_LOCKT:
    #         LOCKT4res oplockt;
    #     case OP_LOCKU:
    #         LOCKU4res oplocku;
    #     case OP_LOOKUP:
    #         LOOKUP4res oplookup;
    #     case OP_LOOKUPP:
    #         LOOKUPP4res oplookupp;
    #     case OP_NVERIFY:
    #         NVERIFY4res opnverify;
    #     case OP_OPEN:
    #         OPEN4res opopen;
    #     case OP_OPENATTR:
    #         OPENATTR4res opopenattr;
    #     case OP_OPEN_CONFIRM:
    #         OPEN_CONFIRM4res opopen_confirm;
    #     case OP_OPEN_DOWNGRADE:
    #         OPEN_DOWNGRADE4res opopen_downgrade;
    #     case OP_PUTFH:
    #         PUTFH4res opputfh;
    #     case OP_PUTPUBFH:
    #         PUTPUBFH4res opputpubfh;
    #     case OP_PUTROOTFH:
    #         PUTROOTFH4res opputrootfh;
    #     case OP_READ:
    #         READ4res opread;
    #     case OP_READDIR:
    #         READDIR4res opreaddir;
    #     case OP_READLINK:
    #         READLINK4res opreadlink;
    #     case OP_REMOVE:
    #         REMOVE4res opremove;
    #     case OP_RENAME:
    #         RENAME4res oprename;
    #     case OP_RENEW:
    #         RENEW4res oprenew;
    #     case OP_RESTOREFH:
    #         RESTOREFH4res oprestorefh;
    #     case OP_SAVEFH:
    #         SAVEFH4res opsavefh;
    #     case OP_SECINFO:
    #         SECINFO4res opsecinfo;
    #     case OP_SETATTR:
    #         SETATTR4res opsetattr;
    #     case OP_SETCLIENTID:
    #         SETCLIENTID4res opsetclientid;
    #     case OP_SETCLIENTID_CONFIRM:
    #         SETCLIENTID_CONFIRM4res opsetclientid_confirm;
    #     case OP_VERIFY:
    #         VERIFY4res opverify;
    #     case OP_WRITE:
    #         WRITE4res opwrite;
    #     case OP_RELEASE_LOCKOWNER:
    #         RELEASE_LOCKOWNER4res oprelease_lockowner;
    #     case OP_BACKCHANNEL_CTL:
    #         BACKCHANNEL_CTL4res opbackchannel_ctl;
    #     case OP_BIND_CONN_TO_SESSION:
    #         BIND_CONN_TO_SESSION4res opbind_conn_to_session;
    #     case OP_EXCHANGE_ID:
    #         EXCHANGE_ID4res opexchange_id;
    #     case OP_CREATE_SESSION:
    #         CREATE_SESSION4res opcreate_session;
    #     case OP_DESTROY_SESSION:
    #         DESTROY_SESSION4res opdestroy_session;
    #     case OP_FREE_STATEID:
    #         FREE_STATEID4res opfree_stateid;
    #     case OP_GET_DIR_DELEGATION:
    #         GET_DIR_DELEGATION4res opget_dir_delegation;
    #     case OP_GETDEVICEINFO:
    #         GETDEVICEINFO4res opgetdeviceinfo;
    #     case OP_GETDEVICELIST:
    #         GETDEVICELIST4res opgetdevicelist;
    #     case OP_LAYOUTCOMMIT:
    #         LAYOUTCOMMIT4res oplayoutcommit;
    #     case OP_LAYOUTGET:
    #         LAYOUTGET4res oplayoutget;
    #     case OP_LAYOUTRETURN:
    #         LAYOUTRETURN4res oplayoutreturn;
    #     case OP_SECINFO_NO_NAME:
    #         SECINFO_NO_NAME4res opsecinfo_no_name;
    #     case OP_SEQUENCE:
    #         SEQUENCE4res opsequence;
    #     case OP_SET_SSV:
    #         SET_SSV4res opset_ssv;
    #     case OP_TEST_STATEID:
    #         TEST_STATEID4res optest_stateid;
    #     case OP_WANT_DELEGATION:
    #         WANT_DELEGATION4res opwant_delegation;
    #     case OP_DESTROY_CLIENTID:
    #         DESTROY_CLIENTID4res opdestroy_clientid;
    #     case OP_RECLAIM_COMPLETE:
    #         RECLAIM_COMPLETE4res opreclaim_complete;
    #     case OP_ILLEGAL:
    #         ILLEGAL4res opillegal;
    # };
    def __init__(self, resop=None, opaccess=None, opclose=None, opcommit=None, opcreate=None, opdelegpurge=None, opdelegreturn=None, opgetattr=None, opgetfh=None, oplink=None, oplock=None, oplockt=None, oplocku=None, oplookup=None, oplookupp=None, opnverify=None, opopen=None, opopenattr=None, opopen_confirm=None, opopen_downgrade=None, opputfh=None, opputpubfh=None, opputrootfh=None, opread=None, opreaddir=None, opreadlink=None, opremove=None, oprename=None, oprenew=None, oprestorefh=None, opsavefh=None, opsecinfo=None, opsetattr=None, opsetclientid=None, opsetclientid_confirm=None, opverify=None, opwrite=None, oprelease_lockowner=None, opbackchannel_ctl=None, opbind_conn_to_session=None, opexchange_id=None, opcreate_session=None, opdestroy_session=None, opfree_stateid=None, opget_dir_delegation=None, opgetdeviceinfo=None, opgetdevicelist=None, oplayoutcommit=None, oplayoutget=None, oplayoutreturn=None, opsecinfo_no_name=None, opsequence=None, opset_ssv=None, optest_stateid=None, opwant_delegation=None, opdestroy_clientid=None, opreclaim_complete=None, opillegal=None):
        self.resop = resop
        self.opaccess = opaccess
        self.opclose = opclose
        self.opcommit = opcommit
        self.opcreate = opcreate
        self.opdelegpurge = opdelegpurge
        self.opdelegreturn = opdelegreturn
        self.opgetattr = opgetattr
        self.opgetfh = opgetfh
        self.oplink = oplink
        self.oplock = oplock
        self.oplockt = oplockt
        self.oplocku = oplocku
        self.oplookup = oplookup
        self.oplookupp = oplookupp
        self.opnverify = opnverify
        self.opopen = opopen
        self.opopenattr = opopenattr
        self.opopen_confirm = opopen_confirm
        self.opopen_downgrade = opopen_downgrade
        self.opputfh = opputfh
        self.opputpubfh = opputpubfh
        self.opputrootfh = opputrootfh
        self.opread = opread
        self.opreaddir = opreaddir
        self.opreadlink = opreadlink
        self.opremove = opremove
        self.oprename = oprename
        self.oprenew = oprenew
        self.oprestorefh = oprestorefh
        self.opsavefh = opsavefh
        self.opsecinfo = opsecinfo
        self.opsetattr = opsetattr
        self.opsetclientid = opsetclientid
        self.opsetclientid_confirm = opsetclientid_confirm
        self.opverify = opverify
        self.opwrite = opwrite
        self.oprelease_lockowner = oprelease_lockowner
        self.opbackchannel_ctl = opbackchannel_ctl
        self.opbind_conn_to_session = opbind_conn_to_session
        self.opexchange_id = opexchange_id
        self.opcreate_session = opcreate_session
        self.opdestroy_session = opdestroy_session
        self.opfree_stateid = opfree_stateid
        self.opget_dir_delegation = opget_dir_delegation
        self.opgetdeviceinfo = opgetdeviceinfo
        self.opgetdevicelist = opgetdevicelist
        self.oplayoutcommit = oplayoutcommit
        self.oplayoutget = oplayoutget
        self.oplayoutreturn = oplayoutreturn
        self.opsecinfo_no_name = opsecinfo_no_name
        self.opsequence = opsequence
        self.opset_ssv = opset_ssv
        self.optest_stateid = optest_stateid
        self.opwant_delegation = opwant_delegation
        self.opdestroy_clientid = opdestroy_clientid
        self.opreclaim_complete = opreclaim_complete
        self.opillegal = opillegal

    switch = property(lambda s: {const.OP_ACCESS:s.opaccess,const.OP_CLOSE:s.opclose,const.OP_COMMIT:s.opcommit,const.OP_CREATE:s.opcreate,const.OP_DELEGPURGE:s.opdelegpurge,const.OP_DELEGRETURN:s.opdelegreturn,const.OP_GETATTR:s.opgetattr,const.OP_GETFH:s.opgetfh,const.OP_LINK:s.oplink,const.OP_LOCK:s.oplock,const.OP_LOCKT:s.oplockt,const.OP_LOCKU:s.oplocku,const.OP_LOOKUP:s.oplookup,const.OP_LOOKUPP:s.oplookupp,const.OP_NVERIFY:s.opnverify,const.OP_OPEN:s.opopen,const.OP_OPENATTR:s.opopenattr,const.OP_OPEN_CONFIRM:s.opopen_confirm,const.OP_OPEN_DOWNGRADE:s.opopen_downgrade,const.OP_PUTFH:s.opputfh,const.OP_PUTPUBFH:s.opputpubfh,const.OP_PUTROOTFH:s.opputrootfh,const.OP_READ:s.opread,const.OP_READDIR:s.opreaddir,const.OP_READLINK:s.opreadlink,const.OP_REMOVE:s.opremove,const.OP_RENAME:s.oprename,const.OP_RENEW:s.oprenew,const.OP_RESTOREFH:s.oprestorefh,const.OP_SAVEFH:s.opsavefh,const.OP_SECINFO:s.opsecinfo,const.OP_SETATTR:s.opsetattr,const.OP_SETCLIENTID:s.opsetclientid,const.OP_SETCLIENTID_CONFIRM:s.opsetclientid_confirm,const.OP_VERIFY:s.opverify,const.OP_WRITE:s.opwrite,const.OP_RELEASE_LOCKOWNER:s.oprelease_lockowner,const.OP_BACKCHANNEL_CTL:s.opbackchannel_ctl,const.OP_BIND_CONN_TO_SESSION:s.opbind_conn_to_session,const.OP_EXCHANGE_ID:s.opexchange_id,const.OP_CREATE_SESSION:s.opcreate_session,const.OP_DESTROY_SESSION:s.opdestroy_session,const.OP_FREE_STATEID:s.opfree_stateid,const.OP_GET_DIR_DELEGATION:s.opget_dir_delegation,const.OP_GETDEVICEINFO:s.opgetdeviceinfo,const.OP_GETDEVICELIST:s.opgetdevicelist,const.OP_LAYOUTCOMMIT:s.oplayoutcommit,const.OP_LAYOUTGET:s.oplayoutget,const.OP_LAYOUTRETURN:s.oplayoutreturn,const.OP_SECINFO_NO_NAME:s.opsecinfo_no_name,const.OP_SEQUENCE:s.opsequence,const.OP_SET_SSV:s.opset_ssv,const.OP_TEST_STATEID:s.optest_stateid,const.OP_WANT_DELEGATION:s.opwant_delegation,const.OP_DESTROY_CLIENTID:s.opdestroy_clientid,const.OP_RECLAIM_COMPLETE:s.opreclaim_complete,const.OP_ILLEGAL:s.opillegal,}[s.resop])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.resop is not None:
            out += ['resop=%s' % const.nfs_opnum4.get(self.resop, self.resop)]
        if self.opaccess is not None:
            out += ['opaccess=%s' % repr(self.opaccess)]
        if self.opclose is not None:
            out += ['opclose=%s' % repr(self.opclose)]
        if self.opcommit is not None:
            out += ['opcommit=%s' % repr(self.opcommit)]
        if self.opcreate is not None:
            out += ['opcreate=%s' % repr(self.opcreate)]
        if self.opdelegpurge is not None:
            out += ['opdelegpurge=%s' % repr(self.opdelegpurge)]
        if self.opdelegreturn is not None:
            out += ['opdelegreturn=%s' % repr(self.opdelegreturn)]
        if self.opgetattr is not None:
            out += ['opgetattr=%s' % repr(self.opgetattr)]
        if self.opgetfh is not None:
            out += ['opgetfh=%s' % repr(self.opgetfh)]
        if self.oplink is not None:
            out += ['oplink=%s' % repr(self.oplink)]
        if self.oplock is not None:
            out += ['oplock=%s' % repr(self.oplock)]
        if self.oplockt is not None:
            out += ['oplockt=%s' % repr(self.oplockt)]
        if self.oplocku is not None:
            out += ['oplocku=%s' % repr(self.oplocku)]
        if self.oplookup is not None:
            out += ['oplookup=%s' % repr(self.oplookup)]
        if self.oplookupp is not None:
            out += ['oplookupp=%s' % repr(self.oplookupp)]
        if self.opnverify is not None:
            out += ['opnverify=%s' % repr(self.opnverify)]
        if self.opopen is not None:
            out += ['opopen=%s' % repr(self.opopen)]
        if self.opopenattr is not None:
            out += ['opopenattr=%s' % repr(self.opopenattr)]
        if self.opopen_confirm is not None:
            out += ['opopen_confirm=%s' % repr(self.opopen_confirm)]
        if self.opopen_downgrade is not None:
            out += ['opopen_downgrade=%s' % repr(self.opopen_downgrade)]
        if self.opputfh is not None:
            out += ['opputfh=%s' % repr(self.opputfh)]
        if self.opputpubfh is not None:
            out += ['opputpubfh=%s' % repr(self.opputpubfh)]
        if self.opputrootfh is not None:
            out += ['opputrootfh=%s' % repr(self.opputrootfh)]
        if self.opread is not None:
            out += ['opread=%s' % repr(self.opread)]
        if self.opreaddir is not None:
            out += ['opreaddir=%s' % repr(self.opreaddir)]
        if self.opreadlink is not None:
            out += ['opreadlink=%s' % repr(self.opreadlink)]
        if self.opremove is not None:
            out += ['opremove=%s' % repr(self.opremove)]
        if self.oprename is not None:
            out += ['oprename=%s' % repr(self.oprename)]
        if self.oprenew is not None:
            out += ['oprenew=%s' % repr(self.oprenew)]
        if self.oprestorefh is not None:
            out += ['oprestorefh=%s' % repr(self.oprestorefh)]
        if self.opsavefh is not None:
            out += ['opsavefh=%s' % repr(self.opsavefh)]
        if self.opsecinfo is not None:
            out += ['opsecinfo=%s' % repr(self.opsecinfo)]
        if self.opsetattr is not None:
            out += ['opsetattr=%s' % repr(self.opsetattr)]
        if self.opsetclientid is not None:
            out += ['opsetclientid=%s' % repr(self.opsetclientid)]
        if self.opsetclientid_confirm is not None:
            out += ['opsetclientid_confirm=%s' % repr(self.opsetclientid_confirm)]
        if self.opverify is not None:
            out += ['opverify=%s' % repr(self.opverify)]
        if self.opwrite is not None:
            out += ['opwrite=%s' % repr(self.opwrite)]
        if self.oprelease_lockowner is not None:
            out += ['oprelease_lockowner=%s' % repr(self.oprelease_lockowner)]
        if self.opbackchannel_ctl is not None:
            out += ['opbackchannel_ctl=%s' % repr(self.opbackchannel_ctl)]
        if self.opbind_conn_to_session is not None:
            out += ['opbind_conn_to_session=%s' % repr(self.opbind_conn_to_session)]
        if self.opexchange_id is not None:
            out += ['opexchange_id=%s' % repr(self.opexchange_id)]
        if self.opcreate_session is not None:
            out += ['opcreate_session=%s' % repr(self.opcreate_session)]
        if self.opdestroy_session is not None:
            out += ['opdestroy_session=%s' % repr(self.opdestroy_session)]
        if self.opfree_stateid is not None:
            out += ['opfree_stateid=%s' % repr(self.opfree_stateid)]
        if self.opget_dir_delegation is not None:
            out += ['opget_dir_delegation=%s' % repr(self.opget_dir_delegation)]
        if self.opgetdeviceinfo is not None:
            out += ['opgetdeviceinfo=%s' % repr(self.opgetdeviceinfo)]
        if self.opgetdevicelist is not None:
            out += ['opgetdevicelist=%s' % repr(self.opgetdevicelist)]
        if self.oplayoutcommit is not None:
            out += ['oplayoutcommit=%s' % repr(self.oplayoutcommit)]
        if self.oplayoutget is not None:
            out += ['oplayoutget=%s' % repr(self.oplayoutget)]
        if self.oplayoutreturn is not None:
            out += ['oplayoutreturn=%s' % repr(self.oplayoutreturn)]
        if self.opsecinfo_no_name is not None:
            out += ['opsecinfo_no_name=%s' % repr(self.opsecinfo_no_name)]
        if self.opsequence is not None:
            out += ['opsequence=%s' % repr(self.opsequence)]
        if self.opset_ssv is not None:
            out += ['opset_ssv=%s' % repr(self.opset_ssv)]
        if self.optest_stateid is not None:
            out += ['optest_stateid=%s' % repr(self.optest_stateid)]
        if self.opwant_delegation is not None:
            out += ['opwant_delegation=%s' % repr(self.opwant_delegation)]
        if self.opdestroy_clientid is not None:
            out += ['opdestroy_clientid=%s' % repr(self.opdestroy_clientid)]
        if self.opreclaim_complete is not None:
            out += ['opreclaim_complete=%s' % repr(self.opreclaim_complete)]
        if self.opillegal is not None:
            out += ['opillegal=%s' % repr(self.opillegal)]
        return 'nfs_resop4(%s)' % ', '.join(out)
    __str__ = __repr__

class COMPOUND4args:
    # XDR definition:
    # struct COMPOUND4args {
    #     utf8str_cs tag;
    #     uint32_t minorversion;
    #     nfs_argop4 argarray<>;
    # };
    def __init__(self, tag=None, minorversion=None, argarray=None):
        self.tag = tag
        self.minorversion = minorversion
        self.argarray = argarray

    def __repr__(self):
        out = []
        if self.tag is not None:
            out += ['tag=%s' % repr(self.tag)]
        if self.minorversion is not None:
            out += ['minorversion=%s' % repr(self.minorversion)]
        if self.argarray is not None:
            out += ['argarray=%s' % repr(self.argarray)]
        return 'COMPOUND4args(%s)' % ', '.join(out)
    __str__ = __repr__

class COMPOUND4res:
    # XDR definition:
    # struct COMPOUND4res {
    #     nfsstat4 status;
    #     utf8str_cs tag;
    #     nfs_resop4 resarray<>;
    # };
    def __init__(self, status=None, tag=None, resarray=None):
        self.status = status
        self.tag = tag
        self.resarray = resarray

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.tag is not None:
            out += ['tag=%s' % repr(self.tag)]
        if self.resarray is not None:
            out += ['resarray=%s' % repr(self.resarray)]
        return 'COMPOUND4res(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_GETATTR4args:
    # XDR definition:
    # struct CB_GETATTR4args {
    #     nfs_fh4 fh;
    #     bitmap4 attr_request;
    # };
    def __init__(self, fh=None, attr_request=None):
        self.fh = fh
        self.attr_request = attr_request

    def __repr__(self):
        out = []
        if self.fh is not None:
            out += ['fh=%s' % repr(self.fh)]
        if self.attr_request is not None:
            out += ['attr_request=%s' % repr(self.attr_request)]
        return 'CB_GETATTR4args(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_GETATTR4resok:
    # XDR definition:
    # struct CB_GETATTR4resok {
    #     fattr4 obj_attributes;
    # };
    def __init__(self, obj_attributes=None):
        self.obj_attributes = obj_attributes

    def __getattr__(self, attr):
        return getattr(self.obj_attributes, attr)

    def __repr__(self):
        out = []
        if self.obj_attributes is not None:
            out += ['obj_attributes=%s' % repr(self.obj_attributes)]
        return 'CB_GETATTR4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_GETATTR4res:
    # XDR definition:
    # union CB_GETATTR4res switch(nfsstat4 status) {
    #     case NFS4_OK:
    #         CB_GETATTR4resok resok4;
    #     default:
    #         void;
    # };
    def __init__(self, status=None, resok4=None):
        self.status = status
        self.resok4 = resok4

    switch = property(lambda s: {const.NFS4_OK:s.resok4,}.get(s.status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.resok4 is not None:
            out += ['resok4=%s' % repr(self.resok4)]
        return 'CB_GETATTR4res(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_RECALL4args:
    # XDR definition:
    # struct CB_RECALL4args {
    #     stateid4 stateid;
    #     bool truncate;
    #     nfs_fh4 fh;
    # };
    def __init__(self, stateid=None, truncate=None, fh=None):
        self.stateid = stateid
        self.truncate = truncate
        self.fh = fh

    def __getattr__(self, attr):
        return getattr(self.stateid, attr)

    def __repr__(self):
        out = []
        if self.stateid is not None:
            out += ['stateid=%s' % repr(self.stateid)]
        if self.truncate is not None:
            out += ['truncate=%s' % repr(self.truncate)]
        if self.fh is not None:
            out += ['fh=%s' % repr(self.fh)]
        return 'CB_RECALL4args(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_RECALL4res:
    # XDR definition:
    # struct CB_RECALL4res {
    #     nfsstat4 status;
    # };
    def __init__(self, status=None):
        self.status = status

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        return 'CB_RECALL4res(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_ILLEGAL4res:
    # XDR definition:
    # struct CB_ILLEGAL4res {
    #     nfsstat4 status;
    # };
    def __init__(self, status=None):
        self.status = status

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        return 'CB_ILLEGAL4res(%s)' % ', '.join(out)
    __str__ = __repr__

class layoutrecall_file4:
    # XDR definition:
    # struct layoutrecall_file4 {
    #     nfs_fh4 lor_fh;
    #     offset4 lor_offset;
    #     length4 lor_length;
    #     stateid4 lor_stateid;
    # };
    def __init__(self, lor_fh=None, lor_offset=None, lor_length=None, lor_stateid=None):
        self.lor_fh = lor_fh
        self.lor_offset = lor_offset
        self.lor_length = lor_length
        self.lor_stateid = lor_stateid

    def __getattr__(self, attr):
        return getattr(self.lor_stateid, attr)

    def __repr__(self):
        out = []
        if self.lor_fh is not None:
            out += ['lor_fh=%s' % repr(self.lor_fh)]
        if self.lor_offset is not None:
            out += ['lor_offset=%s' % repr(self.lor_offset)]
        if self.lor_length is not None:
            out += ['lor_length=%s' % repr(self.lor_length)]
        if self.lor_stateid is not None:
            out += ['lor_stateid=%s' % repr(self.lor_stateid)]
        return 'layoutrecall_file4(%s)' % ', '.join(out)
    __str__ = __repr__

class layoutrecall4:
    # XDR definition:
    # union layoutrecall4 switch(layoutrecall_type4 lor_recalltype) {
    #     case LAYOUTRECALL4_FILE:
    #         layoutrecall_file4 lor_layout;
    #     case LAYOUTRECALL4_FSID:
    #         fsid4 lor_fsid;
    #     case LAYOUTRECALL4_ALL:
    #         void;
    # };
    def __init__(self, lor_recalltype=None, lor_layout=None, lor_fsid=None):
        self.lor_recalltype = lor_recalltype
        self.lor_layout = lor_layout
        self.lor_fsid = lor_fsid

    switch = property(lambda s: {const.LAYOUTRECALL4_FILE:s.lor_layout,const.LAYOUTRECALL4_FSID:s.lor_fsid,const.LAYOUTRECALL4_ALL:None,}[s.lor_recalltype])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.lor_recalltype is not None:
            out += ['lor_recalltype=%s' % const.layoutrecall_type4.get(self.lor_recalltype, self.lor_recalltype)]
        if self.lor_layout is not None:
            out += ['lor_layout=%s' % repr(self.lor_layout)]
        if self.lor_fsid is not None:
            out += ['lor_fsid=%s' % repr(self.lor_fsid)]
        return 'layoutrecall4(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_LAYOUTRECALL4args:
    # XDR definition:
    # struct CB_LAYOUTRECALL4args {
    #     layouttype4 clora_type;
    #     layoutiomode4 clora_iomode;
    #     bool clora_changed;
    #     layoutrecall4 clora_recall;
    # };
    def __init__(self, clora_type=None, clora_iomode=None, clora_changed=None, clora_recall=None):
        self.clora_type = clora_type
        self.clora_iomode = clora_iomode
        self.clora_changed = clora_changed
        self.clora_recall = clora_recall

    def __getattr__(self, attr):
        return getattr(self.clora_recall, attr)

    def __repr__(self):
        out = []
        if self.clora_type is not None:
            out += ['clora_type=%s' % const.layouttype4.get(self.clora_type, self.clora_type)]
        if self.clora_iomode is not None:
            out += ['clora_iomode=%s' % const.layoutiomode4.get(self.clora_iomode, self.clora_iomode)]
        if self.clora_changed is not None:
            out += ['clora_changed=%s' % repr(self.clora_changed)]
        if self.clora_recall is not None:
            out += ['clora_recall=%s' % repr(self.clora_recall)]
        return 'CB_LAYOUTRECALL4args(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_LAYOUTRECALL4res:
    # XDR definition:
    # struct CB_LAYOUTRECALL4res {
    #     nfsstat4 clorr_status;
    # };
    def __init__(self, clorr_status=None):
        self.clorr_status = clorr_status

    def __repr__(self):
        out = []
        if self.clorr_status is not None:
            out += ['clorr_status=%s' % const.nfsstat4.get(self.clorr_status, self.clorr_status)]
        return 'CB_LAYOUTRECALL4res(%s)' % ', '.join(out)
    __str__ = __repr__

class notify_entry4:
    # XDR definition:
    # struct notify_entry4 {
    #     component4 ne_file;
    #     fattr4 ne_attrs;
    # };
    def __init__(self, ne_file=None, ne_attrs=None):
        self.ne_file = ne_file
        self.ne_attrs = ne_attrs

    def __getattr__(self, attr):
        return getattr(self.ne_attrs, attr)

    def __repr__(self):
        out = []
        if self.ne_file is not None:
            out += ['ne_file=%s' % repr(self.ne_file)]
        if self.ne_attrs is not None:
            out += ['ne_attrs=%s' % repr(self.ne_attrs)]
        return 'notify_entry4(%s)' % ', '.join(out)
    __str__ = __repr__

class prev_entry4:
    # XDR definition:
    # struct prev_entry4 {
    #     notify_entry4 pe_prev_entry;
    #     nfs_cookie4 pe_prev_entry_cookie;
    # };
    def __init__(self, pe_prev_entry=None, pe_prev_entry_cookie=None):
        self.pe_prev_entry = pe_prev_entry
        self.pe_prev_entry_cookie = pe_prev_entry_cookie

    def __getattr__(self, attr):
        return getattr(self.pe_prev_entry, attr)

    def __repr__(self):
        out = []
        if self.pe_prev_entry is not None:
            out += ['pe_prev_entry=%s' % repr(self.pe_prev_entry)]
        if self.pe_prev_entry_cookie is not None:
            out += ['pe_prev_entry_cookie=%s' % repr(self.pe_prev_entry_cookie)]
        return 'prev_entry4(%s)' % ', '.join(out)
    __str__ = __repr__

class notify_remove4:
    # XDR definition:
    # struct notify_remove4 {
    #     notify_entry4 nrm_old_entry;
    #     nfs_cookie4 nrm_old_entry_cookie;
    # };
    def __init__(self, nrm_old_entry=None, nrm_old_entry_cookie=None):
        self.nrm_old_entry = nrm_old_entry
        self.nrm_old_entry_cookie = nrm_old_entry_cookie

    def __getattr__(self, attr):
        return getattr(self.nrm_old_entry, attr)

    def __repr__(self):
        out = []
        if self.nrm_old_entry is not None:
            out += ['nrm_old_entry=%s' % repr(self.nrm_old_entry)]
        if self.nrm_old_entry_cookie is not None:
            out += ['nrm_old_entry_cookie=%s' % repr(self.nrm_old_entry_cookie)]
        return 'notify_remove4(%s)' % ', '.join(out)
    __str__ = __repr__

class notify_add4:
    # XDR definition:
    # struct notify_add4 {
    #     notify_remove4 nad_old_entry<1>;
    #     notify_entry4 nad_new_entry;
    #     nfs_cookie4 nad_new_entry_cookie<1>;
    #     prev_entry4 nad_prev_entry<1>;
    #     bool nad_last_entry;
    # };
    def __init__(self, nad_old_entry=None, nad_new_entry=None, nad_new_entry_cookie=None, nad_prev_entry=None, nad_last_entry=None):
        self.nad_old_entry = nad_old_entry
        self.nad_new_entry = nad_new_entry
        self.nad_new_entry_cookie = nad_new_entry_cookie
        self.nad_prev_entry = nad_prev_entry
        self.nad_last_entry = nad_last_entry

    def __getattr__(self, attr):
        return getattr(self.nad_new_entry, attr)

    def __repr__(self):
        out = []
        if self.nad_old_entry is not None:
            out += ['nad_old_entry=%s' % repr(self.nad_old_entry)]
        if self.nad_new_entry is not None:
            out += ['nad_new_entry=%s' % repr(self.nad_new_entry)]
        if self.nad_new_entry_cookie is not None:
            out += ['nad_new_entry_cookie=%s' % repr(self.nad_new_entry_cookie)]
        if self.nad_prev_entry is not None:
            out += ['nad_prev_entry=%s' % repr(self.nad_prev_entry)]
        if self.nad_last_entry is not None:
            out += ['nad_last_entry=%s' % repr(self.nad_last_entry)]
        return 'notify_add4(%s)' % ', '.join(out)
    __str__ = __repr__

class notify_attr4:
    # XDR definition:
    # struct notify_attr4 {
    #     notify_entry4 na_changed_entry;
    # };
    def __init__(self, na_changed_entry=None):
        self.na_changed_entry = na_changed_entry

    def __getattr__(self, attr):
        return getattr(self.na_changed_entry, attr)

    def __repr__(self):
        out = []
        if self.na_changed_entry is not None:
            out += ['na_changed_entry=%s' % repr(self.na_changed_entry)]
        return 'notify_attr4(%s)' % ', '.join(out)
    __str__ = __repr__

class notify_rename4:
    # XDR definition:
    # struct notify_rename4 {
    #     notify_remove4 nrn_old_entry;
    #     notify_add4 nrn_new_entry;
    # };
    def __init__(self, nrn_old_entry=None, nrn_new_entry=None):
        self.nrn_old_entry = nrn_old_entry
        self.nrn_new_entry = nrn_new_entry

    def __repr__(self):
        out = []
        if self.nrn_old_entry is not None:
            out += ['nrn_old_entry=%s' % repr(self.nrn_old_entry)]
        if self.nrn_new_entry is not None:
            out += ['nrn_new_entry=%s' % repr(self.nrn_new_entry)]
        return 'notify_rename4(%s)' % ', '.join(out)
    __str__ = __repr__

class notify_verifier4:
    # XDR definition:
    # struct notify_verifier4 {
    #     verifier4 nv_old_cookieverf;
    #     verifier4 nv_new_cookieverf;
    # };
    def __init__(self, nv_old_cookieverf=None, nv_new_cookieverf=None):
        self.nv_old_cookieverf = nv_old_cookieverf
        self.nv_new_cookieverf = nv_new_cookieverf

    def __repr__(self):
        out = []
        if self.nv_old_cookieverf is not None:
            out += ['nv_old_cookieverf=%s' % repr(self.nv_old_cookieverf)]
        if self.nv_new_cookieverf is not None:
            out += ['nv_new_cookieverf=%s' % repr(self.nv_new_cookieverf)]
        return 'notify_verifier4(%s)' % ', '.join(out)
    __str__ = __repr__

class notify4:
    # XDR definition:
    # struct notify4 {
    #     bitmap4 notify_mask;
    #     notifylist4 notify_vals;
    # };
    def __init__(self, notify_mask=None, notify_vals=None):
        self.notify_mask = notify_mask
        self.notify_vals = notify_vals

    def __repr__(self):
        out = []
        if self.notify_mask is not None:
            out += ['notify_mask=%s' % repr(self.notify_mask)]
        if self.notify_vals is not None:
            out += ['notify_vals=%s' % repr(self.notify_vals)]
        return 'notify4(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_NOTIFY4args:
    # XDR definition:
    # struct CB_NOTIFY4args {
    #     stateid4 cna_stateid;
    #     nfs_fh4 cna_fh;
    #     notify4 cna_changes<>;
    # };
    def __init__(self, cna_stateid=None, cna_fh=None, cna_changes=None):
        self.cna_stateid = cna_stateid
        self.cna_fh = cna_fh
        self.cna_changes = cna_changes

    def __getattr__(self, attr):
        return getattr(self.cna_stateid, attr)

    def __repr__(self):
        out = []
        if self.cna_stateid is not None:
            out += ['cna_stateid=%s' % repr(self.cna_stateid)]
        if self.cna_fh is not None:
            out += ['cna_fh=%s' % repr(self.cna_fh)]
        if self.cna_changes is not None:
            out += ['cna_changes=%s' % repr(self.cna_changes)]
        return 'CB_NOTIFY4args(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_NOTIFY4res:
    # XDR definition:
    # struct CB_NOTIFY4res {
    #     nfsstat4 cnr_status;
    # };
    def __init__(self, cnr_status=None):
        self.cnr_status = cnr_status

    def __repr__(self):
        out = []
        if self.cnr_status is not None:
            out += ['cnr_status=%s' % const.nfsstat4.get(self.cnr_status, self.cnr_status)]
        return 'CB_NOTIFY4res(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_PUSH_DELEG4args:
    # XDR definition:
    # struct CB_PUSH_DELEG4args {
    #     nfs_fh4 cpda_fh;
    #     open_delegation4 cpda_delegation;
    # };
    def __init__(self, cpda_fh=None, cpda_delegation=None):
        self.cpda_fh = cpda_fh
        self.cpda_delegation = cpda_delegation

    def __getattr__(self, attr):
        return getattr(self.cpda_delegation, attr)

    def __repr__(self):
        out = []
        if self.cpda_fh is not None:
            out += ['cpda_fh=%s' % repr(self.cpda_fh)]
        if self.cpda_delegation is not None:
            out += ['cpda_delegation=%s' % repr(self.cpda_delegation)]
        return 'CB_PUSH_DELEG4args(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_PUSH_DELEG4res:
    # XDR definition:
    # struct CB_PUSH_DELEG4res {
    #     nfsstat4 cpdr_status;
    # };
    def __init__(self, cpdr_status=None):
        self.cpdr_status = cpdr_status

    def __repr__(self):
        out = []
        if self.cpdr_status is not None:
            out += ['cpdr_status=%s' % const.nfsstat4.get(self.cpdr_status, self.cpdr_status)]
        return 'CB_PUSH_DELEG4res(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_RECALL_ANY4args:
    # XDR definition:
    # struct CB_RECALL_ANY4args {
    #     uint32_t craa_objects_to_keep;
    #     bitmap4 craa_type_mask;
    # };
    def __init__(self, craa_objects_to_keep=None, craa_type_mask=None):
        self.craa_objects_to_keep = craa_objects_to_keep
        self.craa_type_mask = craa_type_mask

    def __repr__(self):
        out = []
        if self.craa_objects_to_keep is not None:
            out += ['craa_objects_to_keep=%s' % repr(self.craa_objects_to_keep)]
        if self.craa_type_mask is not None:
            out += ['craa_type_mask=%s' % repr(self.craa_type_mask)]
        return 'CB_RECALL_ANY4args(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_RECALL_ANY4res:
    # XDR definition:
    # struct CB_RECALL_ANY4res {
    #     nfsstat4 crar_status;
    # };
    def __init__(self, crar_status=None):
        self.crar_status = crar_status

    def __repr__(self):
        out = []
        if self.crar_status is not None:
            out += ['crar_status=%s' % const.nfsstat4.get(self.crar_status, self.crar_status)]
        return 'CB_RECALL_ANY4res(%s)' % ', '.join(out)
    __str__ = __repr__

CB_RECALLABLE_OBJ_AVAIL4args = CB_RECALL_ANY4args
class CB_RECALLABLE_OBJ_AVAIL4res:
    # XDR definition:
    # struct CB_RECALLABLE_OBJ_AVAIL4res {
    #     nfsstat4 croa_status;
    # };
    def __init__(self, croa_status=None):
        self.croa_status = croa_status

    def __repr__(self):
        out = []
        if self.croa_status is not None:
            out += ['croa_status=%s' % const.nfsstat4.get(self.croa_status, self.croa_status)]
        return 'CB_RECALLABLE_OBJ_AVAIL4res(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_RECALL_SLOT4args:
    # XDR definition:
    # struct CB_RECALL_SLOT4args {
    #     slotid4 rsa_target_highest_slotid;
    # };
    def __init__(self, rsa_target_highest_slotid=None):
        self.rsa_target_highest_slotid = rsa_target_highest_slotid

    def __repr__(self):
        out = []
        if self.rsa_target_highest_slotid is not None:
            out += ['rsa_target_highest_slotid=%s' % repr(self.rsa_target_highest_slotid)]
        return 'CB_RECALL_SLOT4args(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_RECALL_SLOT4res:
    # XDR definition:
    # struct CB_RECALL_SLOT4res {
    #     nfsstat4 rsr_status;
    # };
    def __init__(self, rsr_status=None):
        self.rsr_status = rsr_status

    def __repr__(self):
        out = []
        if self.rsr_status is not None:
            out += ['rsr_status=%s' % const.nfsstat4.get(self.rsr_status, self.rsr_status)]
        return 'CB_RECALL_SLOT4res(%s)' % ', '.join(out)
    __str__ = __repr__

class referring_call4:
    # XDR definition:
    # struct referring_call4 {
    #     sequenceid4 rc_sequenceid;
    #     slotid4 rc_slotid;
    # };
    def __init__(self, rc_sequenceid=None, rc_slotid=None):
        self.rc_sequenceid = rc_sequenceid
        self.rc_slotid = rc_slotid

    def __repr__(self):
        out = []
        if self.rc_sequenceid is not None:
            out += ['rc_sequenceid=%s' % repr(self.rc_sequenceid)]
        if self.rc_slotid is not None:
            out += ['rc_slotid=%s' % repr(self.rc_slotid)]
        return 'referring_call4(%s)' % ', '.join(out)
    __str__ = __repr__

class referring_call_list4:
    # XDR definition:
    # struct referring_call_list4 {
    #     sessionid4 rcl_sessionid;
    #     referring_call4 rcl_referring_calls<>;
    # };
    def __init__(self, rcl_sessionid=None, rcl_referring_calls=None):
        self.rcl_sessionid = rcl_sessionid
        self.rcl_referring_calls = rcl_referring_calls

    def __repr__(self):
        out = []
        if self.rcl_sessionid is not None:
            out += ['rcl_sessionid=%s' % repr(self.rcl_sessionid)]
        if self.rcl_referring_calls is not None:
            out += ['rcl_referring_calls=%s' % repr(self.rcl_referring_calls)]
        return 'referring_call_list4(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_SEQUENCE4args:
    # XDR definition:
    # struct CB_SEQUENCE4args {
    #     sessionid4 csa_sessionid;
    #     sequenceid4 csa_sequenceid;
    #     slotid4 csa_slotid;
    #     slotid4 csa_highest_slotid;
    #     bool csa_cachethis;
    #     referring_call_list4 csa_referring_call_lists<>;
    # };
    def __init__(self, csa_sessionid=None, csa_sequenceid=None, csa_slotid=None, csa_highest_slotid=None, csa_cachethis=None, csa_referring_call_lists=None):
        self.csa_sessionid = csa_sessionid
        self.csa_sequenceid = csa_sequenceid
        self.csa_slotid = csa_slotid
        self.csa_highest_slotid = csa_highest_slotid
        self.csa_cachethis = csa_cachethis
        self.csa_referring_call_lists = csa_referring_call_lists

    def __repr__(self):
        out = []
        if self.csa_sessionid is not None:
            out += ['csa_sessionid=%s' % repr(self.csa_sessionid)]
        if self.csa_sequenceid is not None:
            out += ['csa_sequenceid=%s' % repr(self.csa_sequenceid)]
        if self.csa_slotid is not None:
            out += ['csa_slotid=%s' % repr(self.csa_slotid)]
        if self.csa_highest_slotid is not None:
            out += ['csa_highest_slotid=%s' % repr(self.csa_highest_slotid)]
        if self.csa_cachethis is not None:
            out += ['csa_cachethis=%s' % repr(self.csa_cachethis)]
        if self.csa_referring_call_lists is not None:
            out += ['csa_referring_call_lists=%s' % repr(self.csa_referring_call_lists)]
        return 'CB_SEQUENCE4args(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_SEQUENCE4resok:
    # XDR definition:
    # struct CB_SEQUENCE4resok {
    #     sessionid4 csr_sessionid;
    #     sequenceid4 csr_sequenceid;
    #     slotid4 csr_slotid;
    #     slotid4 csr_highest_slotid;
    #     slotid4 csr_target_highest_slotid;
    # };
    def __init__(self, csr_sessionid=None, csr_sequenceid=None, csr_slotid=None, csr_highest_slotid=None, csr_target_highest_slotid=None):
        self.csr_sessionid = csr_sessionid
        self.csr_sequenceid = csr_sequenceid
        self.csr_slotid = csr_slotid
        self.csr_highest_slotid = csr_highest_slotid
        self.csr_target_highest_slotid = csr_target_highest_slotid

    def __repr__(self):
        out = []
        if self.csr_sessionid is not None:
            out += ['csr_sessionid=%s' % repr(self.csr_sessionid)]
        if self.csr_sequenceid is not None:
            out += ['csr_sequenceid=%s' % repr(self.csr_sequenceid)]
        if self.csr_slotid is not None:
            out += ['csr_slotid=%s' % repr(self.csr_slotid)]
        if self.csr_highest_slotid is not None:
            out += ['csr_highest_slotid=%s' % repr(self.csr_highest_slotid)]
        if self.csr_target_highest_slotid is not None:
            out += ['csr_target_highest_slotid=%s' % repr(self.csr_target_highest_slotid)]
        return 'CB_SEQUENCE4resok(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_SEQUENCE4res:
    # XDR definition:
    # union CB_SEQUENCE4res switch(nfsstat4 csr_status) {
    #     case NFS4_OK:
    #         CB_SEQUENCE4resok csr_resok4;
    #     default:
    #         void;
    # };
    def __init__(self, csr_status=None, csr_resok4=None):
        self.csr_status = csr_status
        self.csr_resok4 = csr_resok4

    switch = property(lambda s: {const.NFS4_OK:s.csr_resok4,}.get(s.csr_status, None))

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.csr_status is not None:
            out += ['csr_status=%s' % const.nfsstat4.get(self.csr_status, self.csr_status)]
        if self.csr_resok4 is not None:
            out += ['csr_resok4=%s' % repr(self.csr_resok4)]
        return 'CB_SEQUENCE4res(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_WANTS_CANCELLED4args:
    # XDR definition:
    # struct CB_WANTS_CANCELLED4args {
    #     bool cwca_contended_wants_cancelled;
    #     bool cwca_resourced_wants_cancelled;
    # };
    def __init__(self, cwca_contended_wants_cancelled=None, cwca_resourced_wants_cancelled=None):
        self.cwca_contended_wants_cancelled = cwca_contended_wants_cancelled
        self.cwca_resourced_wants_cancelled = cwca_resourced_wants_cancelled

    def __repr__(self):
        out = []
        if self.cwca_contended_wants_cancelled is not None:
            out += ['cwca_contended_wants_cancelled=%s' % repr(self.cwca_contended_wants_cancelled)]
        if self.cwca_resourced_wants_cancelled is not None:
            out += ['cwca_resourced_wants_cancelled=%s' % repr(self.cwca_resourced_wants_cancelled)]
        return 'CB_WANTS_CANCELLED4args(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_WANTS_CANCELLED4res:
    # XDR definition:
    # struct CB_WANTS_CANCELLED4res {
    #     nfsstat4 cwcr_status;
    # };
    def __init__(self, cwcr_status=None):
        self.cwcr_status = cwcr_status

    def __repr__(self):
        out = []
        if self.cwcr_status is not None:
            out += ['cwcr_status=%s' % const.nfsstat4.get(self.cwcr_status, self.cwcr_status)]
        return 'CB_WANTS_CANCELLED4res(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_NOTIFY_LOCK4args:
    # XDR definition:
    # struct CB_NOTIFY_LOCK4args {
    #     nfs_fh4 cnla_fh;
    #     lock_owner4 cnla_lock_owner;
    # };
    def __init__(self, cnla_fh=None, cnla_lock_owner=None):
        self.cnla_fh = cnla_fh
        self.cnla_lock_owner = cnla_lock_owner

    def __getattr__(self, attr):
        return getattr(self.cnla_lock_owner, attr)

    def __repr__(self):
        out = []
        if self.cnla_fh is not None:
            out += ['cnla_fh=%s' % repr(self.cnla_fh)]
        if self.cnla_lock_owner is not None:
            out += ['cnla_lock_owner=%s' % repr(self.cnla_lock_owner)]
        return 'CB_NOTIFY_LOCK4args(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_NOTIFY_LOCK4res:
    # XDR definition:
    # struct CB_NOTIFY_LOCK4res {
    #     nfsstat4 cnlr_status;
    # };
    def __init__(self, cnlr_status=None):
        self.cnlr_status = cnlr_status

    def __repr__(self):
        out = []
        if self.cnlr_status is not None:
            out += ['cnlr_status=%s' % const.nfsstat4.get(self.cnlr_status, self.cnlr_status)]
        return 'CB_NOTIFY_LOCK4res(%s)' % ', '.join(out)
    __str__ = __repr__

class notify_deviceid_delete4:
    # XDR definition:
    # struct notify_deviceid_delete4 {
    #     layouttype4 ndd_layouttype;
    #     deviceid4 ndd_deviceid;
    # };
    def __init__(self, ndd_layouttype=None, ndd_deviceid=None):
        self.ndd_layouttype = ndd_layouttype
        self.ndd_deviceid = ndd_deviceid

    def __repr__(self):
        out = []
        if self.ndd_layouttype is not None:
            out += ['ndd_layouttype=%s' % const.layouttype4.get(self.ndd_layouttype, self.ndd_layouttype)]
        if self.ndd_deviceid is not None:
            out += ['ndd_deviceid=%s' % repr(self.ndd_deviceid)]
        return 'notify_deviceid_delete4(%s)' % ', '.join(out)
    __str__ = __repr__

class notify_deviceid_change4:
    # XDR definition:
    # struct notify_deviceid_change4 {
    #     layouttype4 ndc_layouttype;
    #     deviceid4 ndc_deviceid;
    #     bool ndc_immediate;
    # };
    def __init__(self, ndc_layouttype=None, ndc_deviceid=None, ndc_immediate=None):
        self.ndc_layouttype = ndc_layouttype
        self.ndc_deviceid = ndc_deviceid
        self.ndc_immediate = ndc_immediate

    def __repr__(self):
        out = []
        if self.ndc_layouttype is not None:
            out += ['ndc_layouttype=%s' % const.layouttype4.get(self.ndc_layouttype, self.ndc_layouttype)]
        if self.ndc_deviceid is not None:
            out += ['ndc_deviceid=%s' % repr(self.ndc_deviceid)]
        if self.ndc_immediate is not None:
            out += ['ndc_immediate=%s' % repr(self.ndc_immediate)]
        return 'notify_deviceid_change4(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_NOTIFY_DEVICEID4args:
    # XDR definition:
    # struct CB_NOTIFY_DEVICEID4args {
    #     notify4 cnda_changes<>;
    # };
    def __init__(self, cnda_changes=None):
        self.cnda_changes = cnda_changes

    def __repr__(self):
        out = []
        if self.cnda_changes is not None:
            out += ['cnda_changes=%s' % repr(self.cnda_changes)]
        return 'CB_NOTIFY_DEVICEID4args(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_NOTIFY_DEVICEID4res:
    # XDR definition:
    # struct CB_NOTIFY_DEVICEID4res {
    #     nfsstat4 cndr_status;
    # };
    def __init__(self, cndr_status=None):
        self.cndr_status = cndr_status

    def __repr__(self):
        out = []
        if self.cndr_status is not None:
            out += ['cndr_status=%s' % const.nfsstat4.get(self.cndr_status, self.cndr_status)]
        return 'CB_NOTIFY_DEVICEID4res(%s)' % ', '.join(out)
    __str__ = __repr__

class nfs_cb_argop4:
    # XDR definition:
    # union nfs_cb_argop4 switch(nfs_cb_opnum4 argop) {
    #     case OP_CB_GETATTR:
    #         CB_GETATTR4args opcbgetattr;
    #     case OP_CB_RECALL:
    #         CB_RECALL4args opcbrecall;
    #     case OP_CB_LAYOUTRECALL:
    #         CB_LAYOUTRECALL4args opcblayoutrecall;
    #     case OP_CB_NOTIFY:
    #         CB_NOTIFY4args opcbnotify;
    #     case OP_CB_PUSH_DELEG:
    #         CB_PUSH_DELEG4args opcbpush_deleg;
    #     case OP_CB_RECALL_ANY:
    #         CB_RECALL_ANY4args opcbrecall_any;
    #     case OP_CB_RECALLABLE_OBJ_AVAIL:
    #         CB_RECALLABLE_OBJ_AVAIL4args opcbrecallable_obj_avail;
    #     case OP_CB_RECALL_SLOT:
    #         CB_RECALL_SLOT4args opcbrecall_slot;
    #     case OP_CB_SEQUENCE:
    #         CB_SEQUENCE4args opcbsequence;
    #     case OP_CB_WANTS_CANCELLED:
    #         CB_WANTS_CANCELLED4args opcbwants_cancelled;
    #     case OP_CB_NOTIFY_LOCK:
    #         CB_NOTIFY_LOCK4args opcbnotify_lock;
    #     case OP_CB_NOTIFY_DEVICEID:
    #         CB_NOTIFY_DEVICEID4args opcbnotify_deviceid;
    #     case OP_CB_ILLEGAL:
    #         void;
    # };
    def __init__(self, argop=None, opcbgetattr=None, opcbrecall=None, opcblayoutrecall=None, opcbnotify=None, opcbpush_deleg=None, opcbrecall_any=None, opcbrecallable_obj_avail=None, opcbrecall_slot=None, opcbsequence=None, opcbwants_cancelled=None, opcbnotify_lock=None, opcbnotify_deviceid=None):
        self.argop = argop
        self.opcbgetattr = opcbgetattr
        self.opcbrecall = opcbrecall
        self.opcblayoutrecall = opcblayoutrecall
        self.opcbnotify = opcbnotify
        self.opcbpush_deleg = opcbpush_deleg
        self.opcbrecall_any = opcbrecall_any
        self.opcbrecallable_obj_avail = opcbrecallable_obj_avail
        self.opcbrecall_slot = opcbrecall_slot
        self.opcbsequence = opcbsequence
        self.opcbwants_cancelled = opcbwants_cancelled
        self.opcbnotify_lock = opcbnotify_lock
        self.opcbnotify_deviceid = opcbnotify_deviceid

    switch = property(lambda s: {const.OP_CB_GETATTR:s.opcbgetattr,const.OP_CB_RECALL:s.opcbrecall,const.OP_CB_LAYOUTRECALL:s.opcblayoutrecall,const.OP_CB_NOTIFY:s.opcbnotify,const.OP_CB_PUSH_DELEG:s.opcbpush_deleg,const.OP_CB_RECALL_ANY:s.opcbrecall_any,const.OP_CB_RECALLABLE_OBJ_AVAIL:s.opcbrecallable_obj_avail,const.OP_CB_RECALL_SLOT:s.opcbrecall_slot,const.OP_CB_SEQUENCE:s.opcbsequence,const.OP_CB_WANTS_CANCELLED:s.opcbwants_cancelled,const.OP_CB_NOTIFY_LOCK:s.opcbnotify_lock,const.OP_CB_NOTIFY_DEVICEID:s.opcbnotify_deviceid,const.OP_CB_ILLEGAL:None,}[s.argop])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.argop is not None:
            out += ['argop=%s' % const.nfs_cb_opnum4.get(self.argop, self.argop)]
        if self.opcbgetattr is not None:
            out += ['opcbgetattr=%s' % repr(self.opcbgetattr)]
        if self.opcbrecall is not None:
            out += ['opcbrecall=%s' % repr(self.opcbrecall)]
        if self.opcblayoutrecall is not None:
            out += ['opcblayoutrecall=%s' % repr(self.opcblayoutrecall)]
        if self.opcbnotify is not None:
            out += ['opcbnotify=%s' % repr(self.opcbnotify)]
        if self.opcbpush_deleg is not None:
            out += ['opcbpush_deleg=%s' % repr(self.opcbpush_deleg)]
        if self.opcbrecall_any is not None:
            out += ['opcbrecall_any=%s' % repr(self.opcbrecall_any)]
        if self.opcbrecallable_obj_avail is not None:
            out += ['opcbrecallable_obj_avail=%s' % repr(self.opcbrecallable_obj_avail)]
        if self.opcbrecall_slot is not None:
            out += ['opcbrecall_slot=%s' % repr(self.opcbrecall_slot)]
        if self.opcbsequence is not None:
            out += ['opcbsequence=%s' % repr(self.opcbsequence)]
        if self.opcbwants_cancelled is not None:
            out += ['opcbwants_cancelled=%s' % repr(self.opcbwants_cancelled)]
        if self.opcbnotify_lock is not None:
            out += ['opcbnotify_lock=%s' % repr(self.opcbnotify_lock)]
        if self.opcbnotify_deviceid is not None:
            out += ['opcbnotify_deviceid=%s' % repr(self.opcbnotify_deviceid)]
        return 'nfs_cb_argop4(%s)' % ', '.join(out)
    __str__ = __repr__

class nfs_cb_resop4:
    # XDR definition:
    # union nfs_cb_resop4 switch(nfs_cb_opnum4 resop) {
    #     case OP_CB_GETATTR:
    #         CB_GETATTR4res opcbgetattr;
    #     case OP_CB_RECALL:
    #         CB_RECALL4res opcbrecall;
    #     case OP_CB_LAYOUTRECALL:
    #         CB_LAYOUTRECALL4res opcblayoutrecall;
    #     case OP_CB_NOTIFY:
    #         CB_NOTIFY4res opcbnotify;
    #     case OP_CB_PUSH_DELEG:
    #         CB_PUSH_DELEG4res opcbpush_deleg;
    #     case OP_CB_RECALL_ANY:
    #         CB_RECALL_ANY4res opcbrecall_any;
    #     case OP_CB_RECALLABLE_OBJ_AVAIL:
    #         CB_RECALLABLE_OBJ_AVAIL4res opcbrecallable_obj_avail;
    #     case OP_CB_RECALL_SLOT:
    #         CB_RECALL_SLOT4res opcbrecall_slot;
    #     case OP_CB_SEQUENCE:
    #         CB_SEQUENCE4res opcbsequence;
    #     case OP_CB_WANTS_CANCELLED:
    #         CB_WANTS_CANCELLED4res opcbwants_cancelled;
    #     case OP_CB_NOTIFY_LOCK:
    #         CB_NOTIFY_LOCK4res opcbnotify_lock;
    #     case OP_CB_NOTIFY_DEVICEID:
    #         CB_NOTIFY_DEVICEID4res opcbnotify_deviceid;
    #     case OP_CB_ILLEGAL:
    #         CB_ILLEGAL4res opcbillegal;
    # };
    def __init__(self, resop=None, opcbgetattr=None, opcbrecall=None, opcblayoutrecall=None, opcbnotify=None, opcbpush_deleg=None, opcbrecall_any=None, opcbrecallable_obj_avail=None, opcbrecall_slot=None, opcbsequence=None, opcbwants_cancelled=None, opcbnotify_lock=None, opcbnotify_deviceid=None, opcbillegal=None):
        self.resop = resop
        self.opcbgetattr = opcbgetattr
        self.opcbrecall = opcbrecall
        self.opcblayoutrecall = opcblayoutrecall
        self.opcbnotify = opcbnotify
        self.opcbpush_deleg = opcbpush_deleg
        self.opcbrecall_any = opcbrecall_any
        self.opcbrecallable_obj_avail = opcbrecallable_obj_avail
        self.opcbrecall_slot = opcbrecall_slot
        self.opcbsequence = opcbsequence
        self.opcbwants_cancelled = opcbwants_cancelled
        self.opcbnotify_lock = opcbnotify_lock
        self.opcbnotify_deviceid = opcbnotify_deviceid
        self.opcbillegal = opcbillegal

    switch = property(lambda s: {const.OP_CB_GETATTR:s.opcbgetattr,const.OP_CB_RECALL:s.opcbrecall,const.OP_CB_LAYOUTRECALL:s.opcblayoutrecall,const.OP_CB_NOTIFY:s.opcbnotify,const.OP_CB_PUSH_DELEG:s.opcbpush_deleg,const.OP_CB_RECALL_ANY:s.opcbrecall_any,const.OP_CB_RECALLABLE_OBJ_AVAIL:s.opcbrecallable_obj_avail,const.OP_CB_RECALL_SLOT:s.opcbrecall_slot,const.OP_CB_SEQUENCE:s.opcbsequence,const.OP_CB_WANTS_CANCELLED:s.opcbwants_cancelled,const.OP_CB_NOTIFY_LOCK:s.opcbnotify_lock,const.OP_CB_NOTIFY_DEVICEID:s.opcbnotify_deviceid,const.OP_CB_ILLEGAL:s.opcbillegal,}[s.resop])

    def __getattr__(self, attr):
        return getattr(self.switch, attr)

    def __repr__(self):
        out = []
        if self.resop is not None:
            out += ['resop=%s' % const.nfs_cb_opnum4.get(self.resop, self.resop)]
        if self.opcbgetattr is not None:
            out += ['opcbgetattr=%s' % repr(self.opcbgetattr)]
        if self.opcbrecall is not None:
            out += ['opcbrecall=%s' % repr(self.opcbrecall)]
        if self.opcblayoutrecall is not None:
            out += ['opcblayoutrecall=%s' % repr(self.opcblayoutrecall)]
        if self.opcbnotify is not None:
            out += ['opcbnotify=%s' % repr(self.opcbnotify)]
        if self.opcbpush_deleg is not None:
            out += ['opcbpush_deleg=%s' % repr(self.opcbpush_deleg)]
        if self.opcbrecall_any is not None:
            out += ['opcbrecall_any=%s' % repr(self.opcbrecall_any)]
        if self.opcbrecallable_obj_avail is not None:
            out += ['opcbrecallable_obj_avail=%s' % repr(self.opcbrecallable_obj_avail)]
        if self.opcbrecall_slot is not None:
            out += ['opcbrecall_slot=%s' % repr(self.opcbrecall_slot)]
        if self.opcbsequence is not None:
            out += ['opcbsequence=%s' % repr(self.opcbsequence)]
        if self.opcbwants_cancelled is not None:
            out += ['opcbwants_cancelled=%s' % repr(self.opcbwants_cancelled)]
        if self.opcbnotify_lock is not None:
            out += ['opcbnotify_lock=%s' % repr(self.opcbnotify_lock)]
        if self.opcbnotify_deviceid is not None:
            out += ['opcbnotify_deviceid=%s' % repr(self.opcbnotify_deviceid)]
        if self.opcbillegal is not None:
            out += ['opcbillegal=%s' % repr(self.opcbillegal)]
        return 'nfs_cb_resop4(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_COMPOUND4args:
    # XDR definition:
    # struct CB_COMPOUND4args {
    #     utf8str_cs tag;
    #     uint32_t minorversion;
    #     uint32_t callback_ident;
    #     nfs_cb_argop4 argarray<>;
    # };
    def __init__(self, tag=None, minorversion=None, callback_ident=None, argarray=None):
        self.tag = tag
        self.minorversion = minorversion
        self.callback_ident = callback_ident
        self.argarray = argarray

    def __repr__(self):
        out = []
        if self.tag is not None:
            out += ['tag=%s' % repr(self.tag)]
        if self.minorversion is not None:
            out += ['minorversion=%s' % repr(self.minorversion)]
        if self.callback_ident is not None:
            out += ['callback_ident=%s' % repr(self.callback_ident)]
        if self.argarray is not None:
            out += ['argarray=%s' % repr(self.argarray)]
        return 'CB_COMPOUND4args(%s)' % ', '.join(out)
    __str__ = __repr__

class CB_COMPOUND4res:
    # XDR definition:
    # struct CB_COMPOUND4res {
    #     nfsstat4 status;
    #     utf8str_cs tag;
    #     nfs_cb_resop4 resarray<>;
    # };
    def __init__(self, status=None, tag=None, resarray=None):
        self.status = status
        self.tag = tag
        self.resarray = resarray

    def __repr__(self):
        out = []
        if self.status is not None:
            out += ['status=%s' % const.nfsstat4.get(self.status, self.status)]
        if self.tag is not None:
            out += ['tag=%s' % repr(self.tag)]
        if self.resarray is not None:
            out += ['resarray=%s' % repr(self.resarray)]
        return 'CB_COMPOUND4res(%s)' % ', '.join(out)
    __str__ = __repr__

