/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.xerces.impl.dv.xs.SchemaDateTimeException;

public class DayDV
extends AbstractDateTimeDV {
    private static final int DAY_SIZE = 5;

    public Object getActualValue(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return this.parse(string);
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "gDay"});
        }
    }

    protected int[] parse(String string) throws SchemaDateTimeException {
        int n = string.length();
        int[] nArray = new int[8];
        int[] nArray2 = new int[2];
        if (string.charAt(0) != '-' || string.charAt(1) != '-' || string.charAt(2) != '-') {
            throw new SchemaDateTimeException("Error in day parsing");
        }
        nArray[0] = 2000;
        nArray[1] = 1;
        nArray[2] = this.parseInt(string, 3, 5);
        if (5 < n) {
            int n2 = this.findUTCSign(string, 5, n);
            if (n2 < 0) {
                throw new SchemaDateTimeException("Error in day parsing");
            }
            this.getTimeZone(string, nArray, n2, n, nArray2);
        }
        this.validateDateTime(nArray, nArray2);
        if (nArray[7] != 0 && nArray[7] != 90) {
            this.normalize(nArray, nArray2);
        }
        return nArray;
    }

    protected String dateToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(6);
        stringBuffer.append('-');
        stringBuffer.append('-');
        stringBuffer.append('-');
        stringBuffer.append(nArray[2]);
        stringBuffer.append((char)nArray[7]);
        return stringBuffer.toString();
    }
}

