/*
 * Copyright (c) 2001-2013 Oracle and/or its affiliates. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *   - Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *
 *   - Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 *   - Neither the name of Oracle nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.sun.msv.verifier;

import org.iso_relax.verifier.VerifierHandler;
import org.relaxng.datatype.Datatype;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;

/**
 * Interface of verifier.
 * 
 * @author <a href="mailto:kohsuke.kawaguchi@eng.sun.com">Kohsuke KAWAGUCHI</a>
 */
public interface IVerifier extends VerifierHandler {

    /**
     * checks if the document was valid.
     * This method may not be called before verification was completed.
     */
    boolean isValid();
    
    /**
     * returns current element type.
     * 
     * Actual java type depends on the implementation.
     * This method works correctly only when called immediately
     * after handling startElement event.
     * 
     * @return null
     *        this method returns null when it doesn't support
     *        type-assignment feature, or type-assignment is impossible
     *        for the current element (for example due to the ambiguous grammar).
     */
    Object getCurrentElementType();
    
    /**
     * gets DataType that validated the last characters.
     * 
     * <p>
     * This method works correctly only when called immediately
     * after startElement and endElement method. When called, this method
     * returns DataType object that validated the last character literals.
     * 
     * <p>
     * For RELAX NG grammar, this method can return an array of length 2 or more.
     * This happens when the last character matches &lt;list&gt; pattern.
     * In that case, each type corresponds to each token (where tokens are the
     * white-space separation of the last characters).
     * 
     * <p>
     * For any other grammar, this method always returns an array of length 1
     * (or null, if the type assignment failed).
     * 
     * <p>
     * So when you are using VerifierFilter, you can call this method only
     * in your startElement and endElement method.
     * 
     * @return null
     *        if type-assignment was not possible.
     */
    Datatype[] getLastCharacterType();

    /**
     * Turns on/off the panic mode.
     * Panic mode is on by default. Turning it on is good
     * for general use. It prevents false error messages to appear.
     * <p>
     * However, turning it off is sometimes useful, when
     * you are sure that the structure of the document is
     * almost valid (e.g., validating a document generated by an
     * application or when you are sure about the validity of the
     * structure and only interested in validating datatypes,)
     */
    void setPanicMode( boolean usePanicMode );

    Locator getLocator();
    ErrorHandler getErrorHandler();
    void setErrorHandler( ErrorHandler handler );
}
