# Copyright (C) Jan 2020 Mellanox Technologies Ltd. All rights reserved.   
#                                                                           
# This software is available to you under a choice of one of two            
# licenses.  You may choose to be licensed under the terms of the GNU       
# General Public License (GPL) Version 2, available from the file           
# COPYING in the main directory of this source tree, or the                 
# OpenIB.org BSD license below:                                             
#                                                                           
#     Redistribution and use in source and binary forms, with or            
#     without modification, are permitted provided that the following       
#     conditions are met:                                                   
#                                                                           
#      - Redistributions of source code must retain the above               
#        copyright notice, this list of conditions and the following        
#        disclaimer.                                                        
#                                                                           
#      - Redistributions in binary form must reproduce the above            
#        copyright notice, this list of conditions and the following        
#        disclaimer in the documentation and/or other materials             
#        provided with the distribution.                                    
#                                                                           
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,         
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF        
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND                     
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS       
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN        
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN         
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE          
# SOFTWARE.                                                                 
# --                                                                        


#######################################################
# 
# RefSegment.py
# Python implementation of the Class RefSegment
# Generated by Enterprise Architect
# Created on:      14-Aug-2019 10:11:58 AM
# Original author: talve
# 
#######################################################
from segments.Segment import Segment
from segments.SegmentFactory import SegmentFactory
from utils import constants as cs


class RefSegment(Segment):
    """this class is responsible for holding reference segment data.
    """
    def __init__(self, data):
        """initialize the class by setting the class data.
        """
        self.raw_data = data
        self.type = hex(int('{:0b}'.format(data[cs.MENU_SEGMENT_TYPE_DWORD_LOCATION]).zfill(32)[16:32], 2))
        self.size = int('{:0b}'.format(data[0]).zfill(32)[0:16], 2)
        self.reference_type = hex(int('{:0b}'.format(data[1]).zfill(32)[16:32], 2))
        self.index1 = int('{:0b}'.format(data[2]).zfill(32)[0:32], 2)
        self.index2 = int('{:0b}'.format(data[3]).zfill(32)[0:32], 2)
        self.num_of_obj1 = int('{:0b}'.format(data[4]).zfill(32)[0:16], 2)
        self.num_of_obj2 = int('{:0b}'.format(data[4]).zfill(32)[16:32], 2)

    def get_data(self):
        """get the reference segment data.
        """
        return self.raw_data

    def get_type(self):
        """get the reference segment type.
        """
        return cs.RESOURCE_DUMP_SEGMENT_TYPE_REFERENCE


SegmentFactory.register(cs.RESOURCE_DUMP_SEGMENT_TYPE_REFERENCE, RefSegment)
