/*
 * Copyright (C) by Argonne National Laboratory
 *     See COPYRIGHT in top-level directory
 */

/* style:c++ header */

// rimshotDoc.h : interface of the CRimshotDoc class
//
/////////////////////////////////////////////////////////////////////////////

#ifndef RIMSHOTDOC_H_INCLUDED
#define RIMSHOTDOC_H_INCLUDED

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "rlog.h"

struct StateNode {
    RLOG_STATE state;
    int id;
    COLORREF color;
    CBrush brush;
    StateNode *pNext;
};

class CRimshotDoc:public CDocument {
  protected:                   // create from serialization only
    CRimshotDoc();
    DECLARE_DYNCREATE(CRimshotDoc)
// Attributes
  public:
    RLOG_IOStruct * m_pInput;
    double m_dFirst, m_dLast;
    double m_dLeft, m_dRight;
    StateNode *m_pStateList;

// Operations
  public:

// Overrides
    // ClassWizard generated virtual function overrides
    //{{AFX_VIRTUAL(CRimshotDoc)
  public:
     virtual BOOL OnNewDocument();
    virtual void Serialize(CArchive & ar);
    virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
    //}}AFX_VIRTUAL

// Implementation
  public:
     CString GetEventDescription(int event);
    CBrush *GetEventBrush(int event);
    COLORREF GetEventColor(int event);
     virtual ~ CRimshotDoc();
#ifdef _DEBUG
    virtual void AssertValid() const;
    virtual void Dump(CDumpContext & dc) const;
#endif

  protected:

// Generated message map functions
  protected:
    //{{AFX_MSG(CRimshotDoc)
     afx_msg void OnFileOpen();
    //}}AFX_MSG
     DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif /* RIMSHOTDOC_H_INCLUDED */
