/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.ant;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.clirr.ant.AntLogger;
import net.sf.clirr.ant.ChangeCounter;
import net.sf.clirr.ant.PatternSetFilter;
import net.sf.clirr.core.Checker;
import net.sf.clirr.core.CheckerException;
import net.sf.clirr.core.ClassFilter;
import net.sf.clirr.core.ClassSelector;
import net.sf.clirr.core.PlainDiffListener;
import net.sf.clirr.core.XmlDiffListener;
import net.sf.clirr.core.internal.ClassLoaderUtil;
import net.sf.clirr.core.internal.bcel.BcelTypeArrayBuilder;
import net.sf.clirr.core.spi.JavaType;
import org.apache.bcel.classfile.JavaClass;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;

public final class AntTask
extends Task {
    private static final String FORMATTER_TYPE_PLAIN = "plain";
    private static final String FORMATTER_TYPE_XML = "xml";
    private FileSet origFiles = null;
    private FileSet newFiles = null;
    private Path newClassPath = null;
    private Path origClassPath = null;
    private boolean failOnBinError = true;
    private boolean failOnBinWarning = false;
    private boolean failOnSrcError = true;
    private boolean failOnSrcWarning = false;
    private List formatters = new LinkedList();
    private List patternSets = new LinkedList();

    public Path createNewClassPath() {
        if (this.newClassPath == null) {
            this.newClassPath = new Path(this.getProject());
        }
        return this.newClassPath.createPath();
    }

    public void setNewClassPath(Path path) {
        if (this.newClassPath == null) {
            this.newClassPath = path;
        } else {
            this.newClassPath.append(path);
        }
    }

    public Path createOrigClassPath() {
        if (this.origClassPath == null) {
            this.origClassPath = new Path(this.getProject());
        }
        return this.origClassPath.createPath();
    }

    public void setOrigClassPath(Path path) {
        if (this.origClassPath == null) {
            this.origClassPath = path;
        } else {
            this.origClassPath.append(path);
        }
    }

    public void addOrigFiles(FileSet origFiles) {
        if (this.origFiles != null) {
            throw new BuildException();
        }
        this.origFiles = origFiles;
    }

    public void addNewFiles(FileSet newFiles) {
        if (this.newFiles != null) {
            throw new BuildException();
        }
        this.newFiles = newFiles;
    }

    public void setFailOnBinError(boolean failOnBinError) {
        this.failOnBinError = failOnBinError;
    }

    public void setFailOnBinWarning(boolean failOnBinWarning) {
        this.failOnBinWarning = failOnBinWarning;
    }

    public void setFailOnSrcError(boolean failOnSrcError) {
        this.failOnSrcError = failOnSrcError;
    }

    public void setFailOnSrcWarning(boolean failOnSrcWarning) {
        this.failOnSrcWarning = failOnSrcWarning;
    }

    public void addFormatter(Formatter formatter) {
        this.formatters.add(formatter);
    }

    public void addApiClasses(PatternSet set) {
        this.patternSets.add(set);
    }

    public void execute() {
        this.log("Running Clirr, built from tag $Name: RELEASE_CLIRR_0_6 $", 3);
        if (this.origFiles == null || this.newFiles == null) {
            throw new BuildException("Missing nested filesets origFiles and newFiles.", this.getLocation());
        }
        if (this.newClassPath == null) {
            this.newClassPath = new Path(this.getProject());
        }
        if (this.origClassPath == null) {
            this.origClassPath = new Path(this.getProject());
        }
        File[] origJars = this.scanFileSet(this.origFiles);
        File[] newJars = this.scanFileSet(this.newFiles);
        if (origJars.length == 0) {
            throw new BuildException("No files in nested fileset origFiles - nothing to check! Please check your fileset specification.");
        }
        if (newJars.length == 0) {
            throw new BuildException("No files in nested fileset newFiles - nothing to check! Please check your fileset specification.");
        }
        ClassLoader origThirdPartyLoader = this.createClasspathLoader(this.origClassPath);
        ClassLoader newThirdPartyLoader = this.createClasspathLoader(this.newClassPath);
        Checker checker = new Checker();
        ChangeCounter counter = new ChangeCounter();
        boolean formattersWriteToStdOut = false;
        Iterator it = this.formatters.iterator();
        while (it.hasNext()) {
            Formatter formatter = (Formatter)it.next();
            String type = formatter.getType();
            String outFile = formatter.getOutFile();
            formattersWriteToStdOut = formattersWriteToStdOut || outFile == null;
            try {
                if (FORMATTER_TYPE_PLAIN.equals(type)) {
                    checker.addDiffListener(new PlainDiffListener(outFile));
                    continue;
                }
                if (!FORMATTER_TYPE_XML.equals(type)) continue;
                checker.addDiffListener(new XmlDiffListener(outFile));
            }
            catch (IOException ex) {
                this.log("unable to initialize formatter: " + ex.getMessage(), 1);
            }
        }
        if (!formattersWriteToStdOut) {
            checker.addDiffListener(new AntLogger(this));
        }
        checker.addDiffListener(counter);
        try {
            ClassFilter classSelector = this.buildClassFilter();
            JavaType[] origClasses = BcelTypeArrayBuilder.createClassSet(origJars, origThirdPartyLoader, classSelector);
            JavaType[] newClasses = BcelTypeArrayBuilder.createClassSet(newJars, newThirdPartyLoader, classSelector);
            checker.reportDiffs(origClasses, newClasses);
        }
        catch (CheckerException ex) {
            throw new BuildException(ex.getMessage());
        }
        if (counter.getBinWarnings() > 0 && this.failOnBinWarning || counter.getBinErrors() > 0 && this.failOnBinError) {
            throw new BuildException("detected binary incompatible API changes");
        }
        if (counter.getSrcWarnings() > 0 && this.failOnSrcWarning || counter.getSrcErrors() > 0 && this.failOnSrcError) {
            throw new BuildException("detected source incompatible API changes");
        }
    }

    private ClassFilter buildClassFilter() {
        PatternSetFilter patternSetFilter = new PatternSetFilter(this.getProject(), this.patternSets);
        ClassSelector scopeSelector = new ClassSelector(ClassSelector.MODE_UNLESS);
        return new CompoundClassFilter(patternSetFilter, scopeSelector);
    }

    private ClassLoader createClasspathLoader(Path classpath) {
        String[] cpEntries = classpath.list();
        return ClassLoaderUtil.createClassLoader(cpEntries);
    }

    private File[] scanFileSet(FileSet fs) {
        Project prj = this.getProject();
        DirectoryScanner scanner = fs.getDirectoryScanner(prj);
        scanner.scan();
        File basedir = scanner.getBasedir();
        String[] fileNames = scanner.getIncludedFiles();
        File[] ret = new File[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            String fileName = fileNames[i];
            ret[i] = new File(basedir, fileName);
        }
        return ret;
    }

    private static class CompoundClassFilter
    implements ClassFilter {
        private final ClassFilter patternSetFilter;
        private final ClassFilter scopeSelector;

        public CompoundClassFilter(ClassFilter patternSetFilter, ClassFilter scopeSelector) {
            this.patternSetFilter = patternSetFilter;
            this.scopeSelector = scopeSelector;
        }

        public boolean isSelected(JavaClass clazz) {
            return this.patternSetFilter.isSelected(clazz) && this.scopeSelector.isSelected(clazz);
        }
    }

    public static final class Formatter {
        private String type = null;
        private String outFile = null;

        public String getOutFile() {
            return this.outFile;
        }

        public void setOutFile(String outFile) {
            this.outFile = outFile;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            String lowerCase = type.toLowerCase();
            if (!lowerCase.equals(AntTask.FORMATTER_TYPE_XML) && !lowerCase.equals(AntTask.FORMATTER_TYPE_PLAIN)) {
                throw new BuildException("Illegal formatter type, only plain and xml are supported");
            }
            this.type = type;
        }
    }
}

