/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.core.internal.bcel;

import net.sf.clirr.core.CheckerException;
import net.sf.clirr.core.spi.Scope;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.Repository;

final class BcelScopeHelper {
    private BcelScopeHelper() {
    }

    public static Scope getScope(int accessFlags) {
        if ((accessFlags & 1) > 0) {
            return Scope.PUBLIC;
        }
        if ((accessFlags & 4) > 0) {
            return Scope.PROTECTED;
        }
        if ((accessFlags & 2) > 0) {
            return Scope.PRIVATE;
        }
        return Scope.PACKAGE;
    }

    public static Scope getClassScope(JavaClass jclass) throws CheckerException {
        int dollarPos = jclass.getClassName().lastIndexOf(36);
        if (dollarPos == -1) {
            return BcelScopeHelper.getScope(jclass.getAccessFlags());
        }
        String jclassName = jclass.getClassName();
        String enclosingClassName = jclassName.substring(0, dollarPos);
        Repository repo = jclass.getRepository();
        JavaClass enclosingClass = repo.findClass(enclosingClassName);
        if (enclosingClass == null) {
            throw new CheckerException("Unable to locate enclosing class " + enclosingClassName + " for nested class " + jclassName);
        }
        ConstantPool pool = enclosingClass.getConstantPool();
        Attribute[] attrs = enclosingClass.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            if (!(attrs[i] instanceof InnerClasses)) continue;
            InnerClasses ics = (InnerClasses)attrs[i];
            InnerClass[] icarray = ics.getInnerClasses();
            for (int j = 0; j < icarray.length; ++j) {
                InnerClass ic = icarray[j];
                int classIndex = ic.getInnerClassIndex();
                ConstantClass constClass = (ConstantClass)pool.getConstant(classIndex);
                int nameIndex = constClass.getNameIndex();
                ConstantUtf8 nameconst = (ConstantUtf8)pool.getConstant(nameIndex);
                String classname = nameconst.getBytes().replace('/', '.');
                if (!jclassName.equals(classname)) continue;
                return BcelScopeHelper.getScope(ic.getInnerAccessFlags());
            }
        }
        throw new CheckerException("Unable to find information in class " + enclosingClass.getClassName() + " referring back to nested class " + jclassName);
    }
}

