/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.core;

import java.text.MessageFormat;
import net.sf.clirr.core.Message;
import net.sf.clirr.core.MessageTranslator;
import net.sf.clirr.core.Severity;

public final class ApiDifference {
    private static final int HASHCODE_MAGIC = 29;
    private Message message = null;
    private String report;
    private Severity binaryCompatibilitySeverity;
    private Severity sourceCompatibilitySeverity;
    private String affectedClass;
    private String affectedMethod;
    private String affectedField;
    private String[] extraInfo;

    public ApiDifference(Message message, Severity severity, String clazz, String method, String field, String[] args) {
        this(message, severity, severity, clazz, method, field, args);
    }

    public ApiDifference(Message message, Severity binarySeverity, Severity sourceSeverity, String clazz, String method, String field, String[] args) {
        this.checkNonNull(message);
        this.checkNonNull(binarySeverity);
        this.checkNonNull(sourceSeverity);
        this.checkNonNull(clazz);
        this.message = message;
        this.binaryCompatibilitySeverity = binarySeverity;
        this.sourceCompatibilitySeverity = sourceSeverity;
        this.affectedClass = clazz;
        this.affectedField = field;
        this.affectedMethod = method;
        this.extraInfo = args;
    }

    private void checkNonNull(Object o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
    }

    public Message getMessage() {
        return this.message;
    }

    public Severity getBinaryCompatibilitySeverity() {
        return this.binaryCompatibilitySeverity;
    }

    public Severity getSourceCompatibilitySeverity() {
        return this.sourceCompatibilitySeverity;
    }

    public Severity getMaximumSeverity() {
        Severity bin;
        Severity src = this.getSourceCompatibilitySeverity();
        return src.compareTo(bin = this.getBinaryCompatibilitySeverity()) < 0 ? bin : src;
    }

    public String getReport(MessageTranslator translator) {
        if (this.report != null) {
            return this.report;
        }
        String desc = translator.getDesc(this.message);
        int nArgs = 0;
        if (this.extraInfo != null) {
            nArgs = this.extraInfo.length;
        }
        Object[] strings = new String[nArgs + 3];
        strings[0] = this.affectedClass;
        strings[1] = this.affectedMethod;
        strings[2] = this.affectedField;
        for (int i = 0; i < nArgs; ++i) {
            strings[i + 3] = this.extraInfo[i];
        }
        return MessageFormat.format(desc, strings);
    }

    public String getAffectedClass() {
        return this.affectedClass;
    }

    public String getAffectedMethod() {
        return this.affectedMethod;
    }

    public String getAffectedField() {
        return this.affectedField;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.message.getId());
        this.appendCommonData(buf);
        return buf.toString();
    }

    public String toString(MessageTranslator translator) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getReport(translator));
        this.appendCommonData(buf);
        return buf.toString();
    }

    private void appendCommonData(StringBuffer buf) {
        buf.append(" (");
        buf.append(this.binaryCompatibilitySeverity);
        if (this.sourceCompatibilitySeverity != this.binaryCompatibilitySeverity) {
            buf.append(",");
            buf.append(this.sourceCompatibilitySeverity);
        }
        buf.append(") - ");
        buf.append(this.affectedClass);
        buf.append("[");
        buf.append(this.affectedField);
        buf.append("/");
        buf.append(this.affectedMethod);
        buf.append("]");
    }
}

