# SPDX-license-identifier: Apache-2.0

from enum import Enum

class MesonOperator(Enum):
    # Arithmetic
    PLUS = '+'
    MINUS = '-'
    TIMES = '*'
    DIV = '/'
    MOD = '%'

    UMINUS = 'uminus'

    # Logic
    NOT = 'not'

    # Should return the boolsche interpretation of the value (`'' == false` for instance)
    BOOL = 'bool()'

    # Comparison
    EQUALS = '=='
    NOT_EQUALS = '!='
    GREATER = '>'
    LESS = '<'
    GREATER_EQUALS = '>='
    LESS_EQUALS = '<='

    # Container
    IN = 'in'
    NOT_IN = 'not in'
    INDEX = '[]'
