/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook;

import org.apache.stylebook.Component;
import org.apache.stylebook.InitializationException;
import org.apache.stylebook.Parser;
import org.apache.stylebook.Printer;
import org.apache.stylebook.Processor;
import org.apache.stylebook.Producer;

public class ComponentFactory {
    private ComponentFactory() {
    }

    public static Component getComponent(String string) throws InitializationException {
        try {
            return (Component)Class.forName(string).newInstance();
        }
        catch (ClassCastException classCastException) {
            throw new InitializationException("Class \"" + string + "\" is not a Component");
        }
        catch (InstantiationException instantiationException) {
            throw new InitializationException("Class \"" + string + "\" cannot be instantiated");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InitializationException("Class \"" + string + "\" cannot be accessed");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InitializationException("Class \"" + string + "\" not found");
        }
    }

    public static Parser getParser(String string) throws InitializationException {
        try {
            return (Parser)ComponentFactory.getComponent(string);
        }
        catch (ClassCastException classCastException) {
            throw new InitializationException("Class \"" + string + "\" is not a Parser");
        }
    }

    public static Producer getProducer(String string) throws InitializationException {
        try {
            return (Producer)ComponentFactory.getComponent(string);
        }
        catch (ClassCastException classCastException) {
            throw new InitializationException("Class \"" + string + "\" is not a Producer");
        }
    }

    public static Processor getProcessor(String string) throws InitializationException {
        try {
            return (Processor)ComponentFactory.getComponent(string);
        }
        catch (ClassCastException classCastException) {
            throw new InitializationException("Class \"" + string + "\" is not a Processor");
        }
    }

    public static Printer getPrinter(String string) throws InitializationException {
        try {
            return (Printer)ComponentFactory.getComponent(string);
        }
        catch (ClassCastException classCastException) {
            throw new InitializationException("Class \"" + string + "\" is not a Printer");
        }
    }
}

