/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.api.tests;

import java.io.StringReader;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.xerces.parsers.SAXParser;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xmldb.api.modules.BinaryResource;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.tests.XMLDBTestCase;

public class ResourceTest
extends XMLDBTestCase {
    static /* synthetic */ Class class$org$xmldb$api$tests$ResourceTest;

    public ResourceTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new TestSuite(class$org$xmldb$api$tests$ResourceTest == null ? (class$org$xmldb$api$tests$ResourceTest = ResourceTest.class$("org.xmldb.api.tests.ResourceTest")) : class$org$xmldb$api$tests$ResourceTest);
    }

    public void testBinaryResource() {
        try {
            if (this.supportsBinary) {
                byte[] byArray = new byte[]{1, 2, 3};
                BinaryResource binaryResource = (BinaryResource)this.col.createResource("test", "BinaryResource");
                Assert.assertTrue((boolean)binaryResource.getId().equals("test"));
                Assert.assertTrue((binaryResource.getParentCollection() == this.col ? 1 : 0) != 0);
                binaryResource.setContent((Object)byArray);
                byte[] byArray2 = (byte[])binaryResource.getContent();
                Assert.assertTrue((byArray2 != null ? 1 : 0) != 0);
                Assert.assertTrue((byArray2[0] == 1 ? 1 : 0) != 0);
                Assert.assertTrue((byArray2[1] == 2 ? 1 : 0) != 0);
                Assert.assertTrue((byArray2[2] == 3 ? 1 : 0) != 0);
            }
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testXMLResource() {
        try {
            String string = "<?xml version=\"1.0\"?><tag1><tag2>value</tag2></tag1>";
            XMLResource xMLResource = (XMLResource)this.col.createResource("test", "XMLResource");
            Assert.assertTrue((boolean)xMLResource.getId().equals("test"));
            Assert.assertTrue((boolean)xMLResource.getId().equals(xMLResource.getDocumentId()));
            Assert.assertTrue((xMLResource.getParentCollection() == this.col ? 1 : 0) != 0);
            xMLResource.setContent((Object)string);
            String string2 = (String)xMLResource.getContent();
            Assert.assertTrue((string2 != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)string.equals(string2));
            Node node = xMLResource.getContentAsDOM();
            Assert.assertTrue((node != null ? 1 : 0) != 0);
            xMLResource.setContentAsDOM(node);
            Node node2 = xMLResource.getContentAsDOM();
            Assert.assertTrue((node2 != null ? 1 : 0) != 0);
            string = "<?xml version=\"1.0\"?><tag1 name=\"tag1\">";
            string = string + "<tag2 name=\"tag2\" xmlns:pre=\"http:///pre\">";
            string = string + "<pre:tag3>value&amp;        &#5030;    </pre:tag3>\n";
            string = string + "</tag2></tag1><?pi-test value=\"none\"?>";
            SAXParser sAXParser = new SAXParser();
            ContentHandler contentHandler = xMLResource.setContentAsSAX();
            sAXParser.setContentHandler(contentHandler);
            sAXParser.setErrorHandler((ErrorHandler)((Object)contentHandler));
            if (string != null) {
                sAXParser.parse(new InputSource(new StringReader(string)));
            }
            Assert.assertNotNull((Object)xMLResource.getContent());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testStub() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

