/*
 * Decompiled with CFR 0.152.
 */
package com.werken.xpath.impl;

import com.werken.xpath.function.BooleanFunction;
import com.werken.xpath.impl.Context;
import com.werken.xpath.impl.Expr;
import com.werken.xpath.impl.Op;
import com.werken.xpath.impl.Operator;

public class BinaryExpr
extends Expr {
    private Op _op = null;
    private Expr _lhs = null;
    private Expr _rhs = null;

    public BinaryExpr(Op op, Expr lhs, Expr rhs) {
        this._op = op;
        this._lhs = lhs;
        this._rhs = rhs;
    }

    public Object evaluate(Context context) {
        Context duplicateContext = context.duplicate();
        Object result = null;
        Object lhsValue = this._lhs.evaluate(context);
        Object rhsValue = null;
        if (this._op == Op.OR) {
            if (BooleanFunction.evaluate(lhsValue).booleanValue()) {
                return Boolean.TRUE;
            }
            rhsValue = this._rhs.evaluate(duplicateContext);
            if (BooleanFunction.evaluate(rhsValue).booleanValue()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this._op == Op.AND) {
            if (!BooleanFunction.evaluate(lhsValue).booleanValue()) {
                return Boolean.FALSE;
            }
            rhsValue = this._rhs.evaluate(duplicateContext);
            if (!BooleanFunction.evaluate(rhsValue).booleanValue()) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        rhsValue = this._rhs.evaluate(duplicateContext);
        result = Operator.evaluate(duplicateContext, this._op, lhsValue, rhsValue);
        return result;
    }
}

