/*
 * Decompiled with CFR 0.152.
 */
package com.werken.xpath.impl;

import com.werken.xpath.impl.Context;
import com.werken.xpath.impl.Op;
import com.werken.xpath.impl.OpBooleanAny;
import com.werken.xpath.impl.OpNodeSetAny;
import com.werken.xpath.impl.OpNodeSetNodeSet;
import com.werken.xpath.impl.OpNumberAny;
import com.werken.xpath.impl.OpStringAny;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;

class Operator {
    Operator() {
    }

    protected static boolean bothAreNodeSets(Object lhs, Object rhs) {
        return lhs instanceof List && rhs instanceof List;
    }

    protected static Boolean convertToBoolean(Object obj) {
        Boolean result = null;
        result = obj instanceof Boolean ? (Boolean)obj : Boolean.valueOf(Operator.convertToString(obj));
        return result;
    }

    protected static Double convertToNumber(Object obj) {
        Double result = null;
        result = obj instanceof Double ? (Double)obj : Double.valueOf(Operator.convertToString(obj));
        return result;
    }

    protected static String convertToString(Object obj) {
        String result = null;
        result = obj instanceof String ? (String)obj : (obj instanceof Attribute ? ((Attribute)obj).getValue() : (obj instanceof Element ? ((Element)obj).getText() : obj.toString()));
        return result;
    }

    protected static boolean eitherIsBoolean(Object lhs, Object rhs) {
        return lhs instanceof Boolean || rhs instanceof Boolean;
    }

    protected static boolean eitherIsNodeSet(Object lhs, Object rhs) {
        return lhs instanceof List || rhs instanceof List;
    }

    protected static boolean eitherIsNumber(Object lhs, Object rhs) {
        return lhs instanceof Number || rhs instanceof Number;
    }

    protected static boolean eitherIsString(Object lhs, Object rhs) {
        return lhs instanceof String || rhs instanceof String;
    }

    static Object evaluate(Context context, Op op, Object lhsValue, Object rhsValue) {
        Object result = null;
        if (op != Op.OR && op != Op.AND) {
            if (Operator.bothAreNodeSets(lhsValue, rhsValue)) {
                result = OpNodeSetNodeSet.evaluate(context, op, lhsValue, rhsValue);
            } else if (Operator.eitherIsNodeSet(lhsValue, rhsValue)) {
                result = OpNodeSetAny.evaluate(context, op, lhsValue, rhsValue);
            } else if (Operator.eitherIsBoolean(lhsValue, rhsValue)) {
                result = OpBooleanAny.evaluate(context, op, lhsValue, rhsValue);
            } else if (Operator.eitherIsNumber(lhsValue, rhsValue)) {
                result = OpNumberAny.evaluate(context, op, lhsValue, rhsValue);
            } else if (Operator.eitherIsString(lhsValue, rhsValue)) {
                result = OpStringAny.evaluate(context, op, lhsValue, rhsValue);
            }
        }
        return result;
    }
}

