/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.NamespaceContext;

public class NamespaceSupport
implements NamespaceContext {
    protected String[] fNamespace = new String[32];
    protected int fNamespaceSize;
    protected int[] fContext = new int[8];
    protected int fCurrentContext;

    public NamespaceSupport() {
    }

    public NamespaceSupport(NamespaceContext namespaceContext) {
        this.pushContext();
        while (namespaceContext != null) {
            int n = namespaceContext.getDeclaredPrefixCount();
            int n2 = 0;
            while (n2 < n) {
                String string = namespaceContext.getDeclaredPrefixAt(n2);
                String string2 = this.getURI(string);
                if (string2 == null) {
                    string2 = namespaceContext.getURI(string);
                    this.declarePrefix(string, string2);
                }
                ++n2;
            }
            namespaceContext = namespaceContext.getParentContext();
        }
    }

    public void reset() {
        this.fNamespaceSize = 0;
        this.fCurrentContext = 0;
        this.fContext[this.fCurrentContext] = this.fNamespaceSize;
        this.fNamespace[this.fNamespaceSize++] = XMLSymbols.PREFIX_XML;
        this.fNamespace[this.fNamespaceSize++] = NamespaceContext.XML_URI;
        this.fNamespace[this.fNamespaceSize++] = XMLSymbols.PREFIX_XMLNS;
        this.fNamespace[this.fNamespaceSize++] = NamespaceContext.XMLNS_URI;
        ++this.fCurrentContext;
    }

    public void pushContext() {
        if (this.fCurrentContext + 1 == this.fContext.length) {
            int[] nArray = new int[this.fContext.length * 2];
            System.arraycopy(this.fContext, 0, nArray, 0, this.fContext.length);
            this.fContext = nArray;
        }
        this.fContext[++this.fCurrentContext] = this.fNamespaceSize;
    }

    public void popContext() {
        this.fNamespaceSize = this.fContext[this.fCurrentContext--];
    }

    public boolean declarePrefix(String string, String string2) {
        if (string == XMLSymbols.PREFIX_XML || string == XMLSymbols.PREFIX_XMLNS) {
            return false;
        }
        int n = this.fNamespaceSize;
        while (n > this.fContext[this.fCurrentContext]) {
            if (this.fNamespace[n - 2] == string) {
                this.fNamespace[n - 1] = string2;
                return true;
            }
            n -= 2;
        }
        if (this.fNamespaceSize == this.fNamespace.length) {
            String[] stringArray = new String[this.fNamespaceSize * 2];
            System.arraycopy(this.fNamespace, 0, stringArray, 0, this.fNamespaceSize);
            this.fNamespace = stringArray;
        }
        this.fNamespace[this.fNamespaceSize++] = string;
        this.fNamespace[this.fNamespaceSize++] = string2;
        return true;
    }

    public String getURI(String string) {
        int n = this.fNamespaceSize;
        while (n > 0) {
            if (this.fNamespace[n - 2] == string) {
                return this.fNamespace[n - 1];
            }
            n -= 2;
        }
        return null;
    }

    public String getPrefix(String string) {
        int n = this.fNamespaceSize;
        while (n > 0) {
            if (this.fNamespace[n - 1] == string && this.getURI(this.fNamespace[n - 2]) == string) {
                return this.fNamespace[n - 2];
            }
            n -= 2;
        }
        return null;
    }

    public int getDeclaredPrefixCount() {
        return (this.fNamespaceSize - this.fContext[this.fCurrentContext]) / 2;
    }

    public String getDeclaredPrefixAt(int n) {
        return this.fNamespace[this.fContext[this.fCurrentContext] + n * 2];
    }

    public NamespaceContext getParentContext() {
        if (this.fCurrentContext == 1) {
            return null;
        }
        return new Context(this.fCurrentContext - 1);
    }

    final class Context
    implements NamespaceContext {
        private int fCurrentContext;

        public Context(int n) {
            this.setCurrentContext(n);
        }

        public void setCurrentContext(int n) {
            this.fCurrentContext = n;
        }

        public String getURI(String string) {
            int n = NamespaceSupport.this.fNamespaceSize;
            while (n > 0) {
                if (NamespaceSupport.this.fNamespace[n - 2] == string) {
                    return NamespaceSupport.this.fNamespace[n - 1];
                }
                n -= 2;
            }
            return null;
        }

        public int getDeclaredPrefixCount() {
            return (NamespaceSupport.this.fNamespaceSize - NamespaceSupport.this.fContext[this.fCurrentContext]) / 2;
        }

        public String getDeclaredPrefixAt(int n) {
            return NamespaceSupport.this.fNamespace[NamespaceSupport.this.fContext[this.fCurrentContext] + n * 2];
        }

        public NamespaceContext getParentContext() {
            if (this.fCurrentContext == 1) {
                return null;
            }
            this.setCurrentContext(this.fCurrentContext - 1);
            return this;
        }
    }
}

