/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import java.io.File;
import org.apache.maven.artifact.ant.DependenciesTask;
import org.apache.maven.artifact.ant.LocalRepository;
import org.apache.maven.model.Dependency;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class Mvn
extends Java {
    public final String BATCH_MODE = "-B";
    private File pom;
    private File mavenHome;
    private final String DEFAULT_MAVEN_VERSION = "2.0.10";
    private String mavenVersion = "2.0.10";
    private boolean batchMode = true;
    private LocalRepository localRepository;

    public void execute() throws BuildException {
        if (this.batchMode) {
            this.createArg().setValue("-B");
        }
        if (this.pom != null) {
            this.createArg().setValue("-f" + this.pom.getAbsolutePath());
        }
        if (this.localRepository != null) {
            this.createJvmarg().setValue("-Dmaven.repo.local=" + this.localRepository.getPath().getAbsolutePath());
        }
        if (this.mavenHome == null) {
            this.downloadAndConfigureMaven();
        } else {
            this.setupLocalMaven();
        }
        super.execute();
    }

    private void downloadAndConfigureMaven() {
        Dependency mavenCore = new Dependency();
        mavenCore.setGroupId("org.apache.maven");
        mavenCore.setArtifactId("maven-core");
        mavenCore.setVersion(this.getMavenVersion());
        DependenciesTask depsTask = new DependenciesTask();
        depsTask.addLocalRepository(this.getLocalRepository());
        depsTask.setProject(this.getProject());
        depsTask.setPathId("maven-core-dependencies");
        depsTask.addDependency(mavenCore);
        depsTask.execute();
        this.setClasspath((Path)this.getProject().getReference("maven-core-dependencies"));
        this.setClassname("org.apache.maven.cli.MavenCli");
    }

    private void setupLocalMaven() {
        Environment.Variable classworldsConfProp = new Environment.Variable();
        classworldsConfProp.setKey("classworlds.conf");
        File classworldsPath = new File(this.mavenHome, "bin/m2.conf");
        classworldsConfProp.setValue(classworldsPath.getAbsolutePath());
        this.addSysproperty(classworldsConfProp);
        Environment.Variable mavenHomeProp = new Environment.Variable();
        mavenHomeProp.setKey("maven.home");
        mavenHomeProp.setValue(this.mavenHome.getAbsolutePath());
        this.addSysproperty(mavenHomeProp);
        FileSet bootDir = new FileSet();
        bootDir.setDir(new File(this.mavenHome, "boot"));
        bootDir.setIncludes("*.jar");
        Path mavenClasspath = new Path(this.getProject());
        mavenClasspath.addFileset(bootDir);
        this.setClasspath(mavenClasspath);
        this.setClassname("org.codehaus.classworlds.Launcher");
    }

    public void setPom(File pom) {
        this.pom = pom;
    }

    public File getPom() {
        return this.pom;
    }

    public void setMavenHome(File mavenHome) {
        this.mavenHome = mavenHome;
    }

    public File getMavenHome() {
        return this.mavenHome;
    }

    public void setBatchMode(boolean batchMode) {
        this.batchMode = batchMode;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void addLocalRepository(LocalRepository localRepository) {
        this.localRepository = localRepository;
    }

    public LocalRepository getLocalRepository() {
        return this.localRepository;
    }

    public void setMavenVersion(String mavenVersion) {
        this.mavenVersion = mavenVersion;
    }

    public String getMavenVersion() {
        return this.mavenVersion;
    }
}

