/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id: BeforeFloat.java 1062901 2011-01-24 18:06:25Z adelmelle $ */

package org.apache.fop.area;

/**
 * The before-float-reference-area optionally generated by an fo:region-body.
 * It has an optional separator and before float block children.
 * See fo:region-body definition in the XSL Rec for more information.
 */
public class BeforeFloat extends BlockParent {

    private static final long serialVersionUID = 4101415711488333380L;

    // this is an optional block area that will be rendered
    // as the separator only if there are float areas
    private Block separator = null;

    /**
     * Set the separator area for this before float.
     *
     * @param sep the before float separator area
     */
    public void setSeparator(Block sep) {
        separator = sep;
    }

    /**
     * Get the separator area for this before float.
     *
     * @return the before float separator area
     */
    public Block getSeparator() {
        return separator;
    }

    /**
     * Get the height of this before float.
     * It gets the height of the children and if there is a
     * separator its height is also added.
     *
     * @return the height of the before float including separator
     */
    @Override
    public int getBPD() {
        int h = super.getBPD();
        if (separator != null) {
            h += separator.getBPD();
        }
        return h;
    }

    /** {@inheritDoc} */
    @Override
    public boolean isEmpty() {
        return true; // before floats are not yet implemented
    }
}

