/*
 * FreeSec: libcrypt for NetBSD
 *
 * Copyright (c) 1994 David Burren
 * All rights reserved.
 *
 * Adapted for FreeBSD-2.0 by Geoffrey M. Rehmet
 *	this file should now *only* export crypt(), in order to make
 *	binaries of libcrypt exportable from the USA
 *
 * Adapted for FreeBSD-4.0 by Mark R V Murray
 *	this file should now *only* export crypt_des(), in order to make
 *	a module that can be optionally included in libcrypt.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of other contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This is an original implementation of the DES and the crypt(3) interfaces
 * by David Burren <davidb@werj.com.au>.
 */

/*
 * The tables in this file were generated from a more compact
 * representation of the DES S-boxes and P-boxes by the program
 * gen-des-tables.c, which we no longer bother to run at build time.
 */

#include "crypt-port.h"
#include "alg-des.h"

#if INCLUDE_des || INCLUDE_des_xbsd || INCLUDE_des_big

const uint8_t m_sbox[4][4096] =
{
  {
    0xef, 0xe3, 0xe1, 0xed, 0xe8, 0xe4, 0xee, 0xe7, 0xe6, 0xef, 0xeb, 0xe2,
    0xe3, 0xe8, 0xe4, 0xee, 0xe9, 0xec, 0xe7, 0xe0, 0xe2, 0xe1, 0xed, 0xea,
    0xec, 0xe6, 0xe0, 0xe9, 0xe5, 0xeb, 0xea, 0xe5, 0xe0, 0xed, 0xee, 0xe8,
    0xe7, 0xea, 0xeb, 0xe1, 0xea, 0xe3, 0xe4, 0xef, 0xed, 0xe4, 0xe1, 0xe2,
    0xe5, 0xeb, 0xe8, 0xe6, 0xec, 0xe7, 0xe6, 0xec, 0xe9, 0xe0, 0xe3, 0xe5,
    0xe2, 0xee, 0xef, 0xe9, 0x0f, 0x03, 0x01, 0x0d, 0x08, 0x04, 0x0e, 0x07,
    0x06, 0x0f, 0x0b, 0x02, 0x03, 0x08, 0x04, 0x0e, 0x09, 0x0c, 0x07, 0x00,
    0x02, 0x01, 0x0d, 0x0a, 0x0c, 0x06, 0x00, 0x09, 0x05, 0x0b, 0x0a, 0x05,
    0x00, 0x0d, 0x0e, 0x08, 0x07, 0x0a, 0x0b, 0x01, 0x0a, 0x03, 0x04, 0x0f,
    0x0d, 0x04, 0x01, 0x02, 0x05, 0x0b, 0x08, 0x06, 0x0c, 0x07, 0x06, 0x0c,
    0x09, 0x00, 0x03, 0x05, 0x02, 0x0e, 0x0f, 0x09, 0x4f, 0x43, 0x41, 0x4d,
    0x48, 0x44, 0x4e, 0x47, 0x46, 0x4f, 0x4b, 0x42, 0x43, 0x48, 0x44, 0x4e,
    0x49, 0x4c, 0x47, 0x40, 0x42, 0x41, 0x4d, 0x4a, 0x4c, 0x46, 0x40, 0x49,
    0x45, 0x4b, 0x4a, 0x45, 0x40, 0x4d, 0x4e, 0x48, 0x47, 0x4a, 0x4b, 0x41,
    0x4a, 0x43, 0x44, 0x4f, 0x4d, 0x44, 0x41, 0x42, 0x45, 0x4b, 0x48, 0x46,
    0x4c, 0x47, 0x46, 0x4c, 0x49, 0x40, 0x43, 0x45, 0x42, 0x4e, 0x4f, 0x49,
    0xff, 0xf3, 0xf1, 0xfd, 0xf8, 0xf4, 0xfe, 0xf7, 0xf6, 0xff, 0xfb, 0xf2,
    0xf3, 0xf8, 0xf4, 0xfe, 0xf9, 0xfc, 0xf7, 0xf0, 0xf2, 0xf1, 0xfd, 0xfa,
    0xfc, 0xf6, 0xf0, 0xf9, 0xf5, 0xfb, 0xfa, 0xf5, 0xf0, 0xfd, 0xfe, 0xf8,
    0xf7, 0xfa, 0xfb, 0xf1, 0xfa, 0xf3, 0xf4, 0xff, 0xfd, 0xf4, 0xf1, 0xf2,
    0xf5, 0xfb, 0xf8, 0xf6, 0xfc, 0xf7, 0xf6, 0xfc, 0xf9, 0xf0, 0xf3, 0xf5,
    0xf2, 0xfe, 0xff, 0xf9, 0xdf, 0xd3, 0xd1, 0xdd, 0xd8, 0xd4, 0xde, 0xd7,
    0xd6, 0xdf, 0xdb, 0xd2, 0xd3, 0xd8, 0xd4, 0xde, 0xd9, 0xdc, 0xd7, 0xd0,
    0xd2, 0xd1, 0xdd, 0xda, 0xdc, 0xd6, 0xd0, 0xd9, 0xd5, 0xdb, 0xda, 0xd5,
    0xd0, 0xdd, 0xde, 0xd8, 0xd7, 0xda, 0xdb, 0xd1, 0xda, 0xd3, 0xd4, 0xdf,
    0xdd, 0xd4, 0xd1, 0xd2, 0xd5, 0xdb, 0xd8, 0xd6, 0xdc, 0xd7, 0xd6, 0xdc,
    0xd9, 0xd0, 0xd3, 0xd5, 0xd2, 0xde, 0xdf, 0xd9, 0x7f, 0x73, 0x71, 0x7d,
    0x78, 0x74, 0x7e, 0x77, 0x76, 0x7f, 0x7b, 0x72, 0x73, 0x78, 0x74, 0x7e,
    0x79, 0x7c, 0x77, 0x70, 0x72, 0x71, 0x7d, 0x7a, 0x7c, 0x76, 0x70, 0x79,
    0x75, 0x7b, 0x7a, 0x75, 0x70, 0x7d, 0x7e, 0x78, 0x77, 0x7a, 0x7b, 0x71,
    0x7a, 0x73, 0x74, 0x7f, 0x7d, 0x74, 0x71, 0x72, 0x75, 0x7b, 0x78, 0x76,
    0x7c, 0x77, 0x76, 0x7c, 0x79, 0x70, 0x73, 0x75, 0x72, 0x7e, 0x7f, 0x79,
    0x1f, 0x13, 0x11, 0x1d, 0x18, 0x14, 0x1e, 0x17, 0x16, 0x1f, 0x1b, 0x12,
    0x13, 0x18, 0x14, 0x1e, 0x19, 0x1c, 0x17, 0x10, 0x12, 0x11, 0x1d, 0x1a,
    0x1c, 0x16, 0x10, 0x19, 0x15, 0x1b, 0x1a, 0x15, 0x10, 0x1d, 0x1e, 0x18,
    0x17, 0x1a, 0x1b, 0x11, 0x1a, 0x13, 0x14, 0x1f, 0x1d, 0x14, 0x11, 0x12,
    0x15, 0x1b, 0x18, 0x16, 0x1c, 0x17, 0x16, 0x1c, 0x19, 0x10, 0x13, 0x15,
    0x12, 0x1e, 0x1f, 0x19, 0x4f, 0x43, 0x41, 0x4d, 0x48, 0x44, 0x4e, 0x47,
    0x46, 0x4f, 0x4b, 0x42, 0x43, 0x48, 0x44, 0x4e, 0x49, 0x4c, 0x47, 0x40,
    0x42, 0x41, 0x4d, 0x4a, 0x4c, 0x46, 0x40, 0x49, 0x45, 0x4b, 0x4a, 0x45,
    0x40, 0x4d, 0x4e, 0x48, 0x47, 0x4a, 0x4b, 0x41, 0x4a, 0x43, 0x44, 0x4f,
    0x4d, 0x44, 0x41, 0x42, 0x45, 0x4b, 0x48, 0x46, 0x4c, 0x47, 0x46, 0x4c,
    0x49, 0x40, 0x43, 0x45, 0x42, 0x4e, 0x4f, 0x49, 0x2f, 0x23, 0x21, 0x2d,
    0x28, 0x24, 0x2e, 0x27, 0x26, 0x2f, 0x2b, 0x22, 0x23, 0x28, 0x24, 0x2e,
    0x29, 0x2c, 0x27, 0x20, 0x22, 0x21, 0x2d, 0x2a, 0x2c, 0x26, 0x20, 0x29,
    0x25, 0x2b, 0x2a, 0x25, 0x20, 0x2d, 0x2e, 0x28, 0x27, 0x2a, 0x2b, 0x21,
    0x2a, 0x23, 0x24, 0x2f, 0x2d, 0x24, 0x21, 0x22, 0x25, 0x2b, 0x28, 0x26,
    0x2c, 0x27, 0x26, 0x2c, 0x29, 0x20, 0x23, 0x25, 0x22, 0x2e, 0x2f, 0x29,
    0xef, 0xe3, 0xe1, 0xed, 0xe8, 0xe4, 0xee, 0xe7, 0xe6, 0xef, 0xeb, 0xe2,
    0xe3, 0xe8, 0xe4, 0xee, 0xe9, 0xec, 0xe7, 0xe0, 0xe2, 0xe1, 0xed, 0xea,
    0xec, 0xe6, 0xe0, 0xe9, 0xe5, 0xeb, 0xea, 0xe5, 0xe0, 0xed, 0xee, 0xe8,
    0xe7, 0xea, 0xeb, 0xe1, 0xea, 0xe3, 0xe4, 0xef, 0xed, 0xe4, 0xe1, 0xe2,
    0xe5, 0xeb, 0xe8, 0xe6, 0xec, 0xe7, 0xe6, 0xec, 0xe9, 0xe0, 0xe3, 0xe5,
    0xe2, 0xee, 0xef, 0xe9, 0xff, 0xf3, 0xf1, 0xfd, 0xf8, 0xf4, 0xfe, 0xf7,
    0xf6, 0xff, 0xfb, 0xf2, 0xf3, 0xf8, 0xf4, 0xfe, 0xf9, 0xfc, 0xf7, 0xf0,
    0xf2, 0xf1, 0xfd, 0xfa, 0xfc, 0xf6, 0xf0, 0xf9, 0xf5, 0xfb, 0xfa, 0xf5,
    0xf0, 0xfd, 0xfe, 0xf8, 0xf7, 0xfa, 0xfb, 0xf1, 0xfa, 0xf3, 0xf4, 0xff,
    0xfd, 0xf4, 0xf1, 0xf2, 0xf5, 0xfb, 0xf8, 0xf6, 0xfc, 0xf7, 0xf6, 0xfc,
    0xf9, 0xf0, 0xf3, 0xf5, 0xf2, 0xfe, 0xff, 0xf9, 0x2f, 0x23, 0x21, 0x2d,
    0x28, 0x24, 0x2e, 0x27, 0x26, 0x2f, 0x2b, 0x22, 0x23, 0x28, 0x24, 0x2e,
    0x29, 0x2c, 0x27, 0x20, 0x22, 0x21, 0x2d, 0x2a, 0x2c, 0x26, 0x20, 0x29,
    0x25, 0x2b, 0x2a, 0x25, 0x20, 0x2d, 0x2e, 0x28, 0x27, 0x2a, 0x2b, 0x21,
    0x2a, 0x23, 0x24, 0x2f, 0x2d, 0x24, 0x21, 0x22, 0x25, 0x2b, 0x28, 0x26,
    0x2c, 0x27, 0x26, 0x2c, 0x29, 0x20, 0x23, 0x25, 0x22, 0x2e, 0x2f, 0x29,
    0xbf, 0xb3, 0xb1, 0xbd, 0xb8, 0xb4, 0xbe, 0xb7, 0xb6, 0xbf, 0xbb, 0xb2,
    0xb3, 0xb8, 0xb4, 0xbe, 0xb9, 0xbc, 0xb7, 0xb0, 0xb2, 0xb1, 0xbd, 0xba,
    0xbc, 0xb6, 0xb0, 0xb9, 0xb5, 0xbb, 0xba, 0xb5, 0xb0, 0xbd, 0xbe, 0xb8,
    0xb7, 0xba, 0xbb, 0xb1, 0xba, 0xb3, 0xb4, 0xbf, 0xbd, 0xb4, 0xb1, 0xb2,
    0xb5, 0xbb, 0xb8, 0xb6, 0xbc, 0xb7, 0xb6, 0xbc, 0xb9, 0xb0, 0xb3, 0xb5,
    0xb2, 0xbe, 0xbf, 0xb9, 0xdf, 0xd3, 0xd1, 0xdd, 0xd8, 0xd4, 0xde, 0xd7,
    0xd6, 0xdf, 0xdb, 0xd2, 0xd3, 0xd8, 0xd4, 0xde, 0xd9, 0xdc, 0xd7, 0xd0,
    0xd2, 0xd1, 0xdd, 0xda, 0xdc, 0xd6, 0xd0, 0xd9, 0xd5, 0xdb, 0xda, 0xd5,
    0xd0, 0xdd, 0xde, 0xd8, 0xd7, 0xda, 0xdb, 0xd1, 0xda, 0xd3, 0xd4, 0xdf,
    0xdd, 0xd4, 0xd1, 0xd2, 0xd5, 0xdb, 0xd8, 0xd6, 0xdc, 0xd7, 0xd6, 0xdc,
    0xd9, 0xd0, 0xd3, 0xd5, 0xd2, 0xde, 0xdf, 0xd9, 0x8f, 0x83, 0x81, 0x8d,
    0x88, 0x84, 0x8e, 0x87, 0x86, 0x8f, 0x8b, 0x82, 0x83, 0x88, 0x84, 0x8e,
    0x89, 0x8c, 0x87, 0x80, 0x82, 0x81, 0x8d, 0x8a, 0x8c, 0x86, 0x80, 0x89,
    0x85, 0x8b, 0x8a, 0x85, 0x80, 0x8d, 0x8e, 0x88, 0x87, 0x8a, 0x8b, 0x81,
    0x8a, 0x83, 0x84, 0x8f, 0x8d, 0x84, 0x81, 0x82, 0x85, 0x8b, 0x88, 0x86,
    0x8c, 0x87, 0x86, 0x8c, 0x89, 0x80, 0x83, 0x85, 0x82, 0x8e, 0x8f, 0x89,
    0x1f, 0x13, 0x11, 0x1d, 0x18, 0x14, 0x1e, 0x17, 0x16, 0x1f, 0x1b, 0x12,
    0x13, 0x18, 0x14, 0x1e, 0x19, 0x1c, 0x17, 0x10, 0x12, 0x11, 0x1d, 0x1a,
    0x1c, 0x16, 0x10, 0x19, 0x15, 0x1b, 0x1a, 0x15, 0x10, 0x1d, 0x1e, 0x18,
    0x17, 0x1a, 0x1b, 0x11, 0x1a, 0x13, 0x14, 0x1f, 0x1d, 0x14, 0x11, 0x12,
    0x15, 0x1b, 0x18, 0x16, 0x1c, 0x17, 0x16, 0x1c, 0x19, 0x10, 0x13, 0x15,
    0x12, 0x1e, 0x1f, 0x19, 0x3f, 0x33, 0x31, 0x3d, 0x38, 0x34, 0x3e, 0x37,
    0x36, 0x3f, 0x3b, 0x32, 0x33, 0x38, 0x34, 0x3e, 0x39, 0x3c, 0x37, 0x30,
    0x32, 0x31, 0x3d, 0x3a, 0x3c, 0x36, 0x30, 0x39, 0x35, 0x3b, 0x3a, 0x35,
    0x30, 0x3d, 0x3e, 0x38, 0x37, 0x3a, 0x3b, 0x31, 0x3a, 0x33, 0x34, 0x3f,
    0x3d, 0x34, 0x31, 0x32, 0x35, 0x3b, 0x38, 0x36, 0x3c, 0x37, 0x36, 0x3c,
    0x39, 0x30, 0x33, 0x35, 0x32, 0x3e, 0x3f, 0x39, 0xaf, 0xa3, 0xa1, 0xad,
    0xa8, 0xa4, 0xae, 0xa7, 0xa6, 0xaf, 0xab, 0xa2, 0xa3, 0xa8, 0xa4, 0xae,
    0xa9, 0xac, 0xa7, 0xa0, 0xa2, 0xa1, 0xad, 0xaa, 0xac, 0xa6, 0xa0, 0xa9,
    0xa5, 0xab, 0xaa, 0xa5, 0xa0, 0xad, 0xae, 0xa8, 0xa7, 0xaa, 0xab, 0xa1,
    0xaa, 0xa3, 0xa4, 0xaf, 0xad, 0xa4, 0xa1, 0xa2, 0xa5, 0xab, 0xa8, 0xa6,
    0xac, 0xa7, 0xa6, 0xac, 0xa9, 0xa0, 0xa3, 0xa5, 0xa2, 0xae, 0xaf, 0xa9,
    0xaf, 0xa3, 0xa1, 0xad, 0xa8, 0xa4, 0xae, 0xa7, 0xa6, 0xaf, 0xab, 0xa2,
    0xa3, 0xa8, 0xa4, 0xae, 0xa9, 0xac, 0xa7, 0xa0, 0xa2, 0xa1, 0xad, 0xaa,
    0xac, 0xa6, 0xa0, 0xa9, 0xa5, 0xab, 0xaa, 0xa5, 0xa0, 0xad, 0xae, 0xa8,
    0xa7, 0xaa, 0xab, 0xa1, 0xaa, 0xa3, 0xa4, 0xaf, 0xad, 0xa4, 0xa1, 0xa2,
    0xa5, 0xab, 0xa8, 0xa6, 0xac, 0xa7, 0xa6, 0xac, 0xa9, 0xa0, 0xa3, 0xa5,
    0xa2, 0xae, 0xaf, 0xa9, 0x6f, 0x63, 0x61, 0x6d, 0x68, 0x64, 0x6e, 0x67,
    0x66, 0x6f, 0x6b, 0x62, 0x63, 0x68, 0x64, 0x6e, 0x69, 0x6c, 0x67, 0x60,
    0x62, 0x61, 0x6d, 0x6a, 0x6c, 0x66, 0x60, 0x69, 0x65, 0x6b, 0x6a, 0x65,
    0x60, 0x6d, 0x6e, 0x68, 0x67, 0x6a, 0x6b, 0x61, 0x6a, 0x63, 0x64, 0x6f,
    0x6d, 0x64, 0x61, 0x62, 0x65, 0x6b, 0x68, 0x66, 0x6c, 0x67, 0x66, 0x6c,
    0x69, 0x60, 0x63, 0x65, 0x62, 0x6e, 0x6f, 0x69, 0x6f, 0x63, 0x61, 0x6d,
    0x68, 0x64, 0x6e, 0x67, 0x66, 0x6f, 0x6b, 0x62, 0x63, 0x68, 0x64, 0x6e,
    0x69, 0x6c, 0x67, 0x60, 0x62, 0x61, 0x6d, 0x6a, 0x6c, 0x66, 0x60, 0x69,
    0x65, 0x6b, 0x6a, 0x65, 0x60, 0x6d, 0x6e, 0x68, 0x67, 0x6a, 0x6b, 0x61,
    0x6a, 0x63, 0x64, 0x6f, 0x6d, 0x64, 0x61, 0x62, 0x65, 0x6b, 0x68, 0x66,
    0x6c, 0x67, 0x66, 0x6c, 0x69, 0x60, 0x63, 0x65, 0x62, 0x6e, 0x6f, 0x69,
    0xcf, 0xc3, 0xc1, 0xcd, 0xc8, 0xc4, 0xce, 0xc7, 0xc6, 0xcf, 0xcb, 0xc2,
    0xc3, 0xc8, 0xc4, 0xce, 0xc9, 0xcc, 0xc7, 0xc0, 0xc2, 0xc1, 0xcd, 0xca,
    0xcc, 0xc6, 0xc0, 0xc9, 0xc5, 0xcb, 0xca, 0xc5, 0xc0, 0xcd, 0xce, 0xc8,
    0xc7, 0xca, 0xcb, 0xc1, 0xca, 0xc3, 0xc4, 0xcf, 0xcd, 0xc4, 0xc1, 0xc2,
    0xc5, 0xcb, 0xc8, 0xc6, 0xcc, 0xc7, 0xc6, 0xcc, 0xc9, 0xc0, 0xc3, 0xc5,
    0xc2, 0xce, 0xcf, 0xc9, 0xcf, 0xc3, 0xc1, 0xcd, 0xc8, 0xc4, 0xce, 0xc7,
    0xc6, 0xcf, 0xcb, 0xc2, 0xc3, 0xc8, 0xc4, 0xce, 0xc9, 0xcc, 0xc7, 0xc0,
    0xc2, 0xc1, 0xcd, 0xca, 0xcc, 0xc6, 0xc0, 0xc9, 0xc5, 0xcb, 0xca, 0xc5,
    0xc0, 0xcd, 0xce, 0xc8, 0xc7, 0xca, 0xcb, 0xc1, 0xca, 0xc3, 0xc4, 0xcf,
    0xcd, 0xc4, 0xc1, 0xc2, 0xc5, 0xcb, 0xc8, 0xc6, 0xcc, 0xc7, 0xc6, 0xcc,
    0xc9, 0xc0, 0xc3, 0xc5, 0xc2, 0xce, 0xcf, 0xc9, 0xbf, 0xb3, 0xb1, 0xbd,
    0xb8, 0xb4, 0xbe, 0xb7, 0xb6, 0xbf, 0xbb, 0xb2, 0xb3, 0xb8, 0xb4, 0xbe,
    0xb9, 0xbc, 0xb7, 0xb0, 0xb2, 0xb1, 0xbd, 0xba, 0xbc, 0xb6, 0xb0, 0xb9,
    0xb5, 0xbb, 0xba, 0xb5, 0xb0, 0xbd, 0xbe, 0xb8, 0xb7, 0xba, 0xbb, 0xb1,
    0xba, 0xb3, 0xb4, 0xbf, 0xbd, 0xb4, 0xb1, 0xb2, 0xb5, 0xbb, 0xb8, 0xb6,
    0xbc, 0xb7, 0xb6, 0xbc, 0xb9, 0xb0, 0xb3, 0xb5, 0xb2, 0xbe, 0xbf, 0xb9,
    0x5f, 0x53, 0x51, 0x5d, 0x58, 0x54, 0x5e, 0x57, 0x56, 0x5f, 0x5b, 0x52,
    0x53, 0x58, 0x54, 0x5e, 0x59, 0x5c, 0x57, 0x50, 0x52, 0x51, 0x5d, 0x5a,
    0x5c, 0x56, 0x50, 0x59, 0x55, 0x5b, 0x5a, 0x55, 0x50, 0x5d, 0x5e, 0x58,
    0x57, 0x5a, 0x5b, 0x51, 0x5a, 0x53, 0x54, 0x5f, 0x5d, 0x54, 0x51, 0x52,
    0x55, 0x5b, 0x58, 0x56, 0x5c, 0x57, 0x56, 0x5c, 0x59, 0x50, 0x53, 0x55,
    0x52, 0x5e, 0x5f, 0x59, 0x9f, 0x93, 0x91, 0x9d, 0x98, 0x94, 0x9e, 0x97,
    0x96, 0x9f, 0x9b, 0x92, 0x93, 0x98, 0x94, 0x9e, 0x99, 0x9c, 0x97, 0x90,
    0x92, 0x91, 0x9d, 0x9a, 0x9c, 0x96, 0x90, 0x99, 0x95, 0x9b, 0x9a, 0x95,
    0x90, 0x9d, 0x9e, 0x98, 0x97, 0x9a, 0x9b, 0x91, 0x9a, 0x93, 0x94, 0x9f,
    0x9d, 0x94, 0x91, 0x92, 0x95, 0x9b, 0x98, 0x96, 0x9c, 0x97, 0x96, 0x9c,
    0x99, 0x90, 0x93, 0x95, 0x92, 0x9e, 0x9f, 0x99, 0x9f, 0x93, 0x91, 0x9d,
    0x98, 0x94, 0x9e, 0x97, 0x96, 0x9f, 0x9b, 0x92, 0x93, 0x98, 0x94, 0x9e,
    0x99, 0x9c, 0x97, 0x90, 0x92, 0x91, 0x9d, 0x9a, 0x9c, 0x96, 0x90, 0x99,
    0x95, 0x9b, 0x9a, 0x95, 0x90, 0x9d, 0x9e, 0x98, 0x97, 0x9a, 0x9b, 0x91,
    0x9a, 0x93, 0x94, 0x9f, 0x9d, 0x94, 0x91, 0x92, 0x95, 0x9b, 0x98, 0x96,
    0x9c, 0x97, 0x96, 0x9c, 0x99, 0x90, 0x93, 0x95, 0x92, 0x9e, 0x9f, 0x99,
    0x5f, 0x53, 0x51, 0x5d, 0x58, 0x54, 0x5e, 0x57, 0x56, 0x5f, 0x5b, 0x52,
    0x53, 0x58, 0x54, 0x5e, 0x59, 0x5c, 0x57, 0x50, 0x52, 0x51, 0x5d, 0x5a,
    0x5c, 0x56, 0x50, 0x59, 0x55, 0x5b, 0x5a, 0x55, 0x50, 0x5d, 0x5e, 0x58,
    0x57, 0x5a, 0x5b, 0x51, 0x5a, 0x53, 0x54, 0x5f, 0x5d, 0x54, 0x51, 0x52,
    0x55, 0x5b, 0x58, 0x56, 0x5c, 0x57, 0x56, 0x5c, 0x59, 0x50, 0x53, 0x55,
    0x52, 0x5e, 0x5f, 0x59, 0x0f, 0x03, 0x01, 0x0d, 0x08, 0x04, 0x0e, 0x07,
    0x06, 0x0f, 0x0b, 0x02, 0x03, 0x08, 0x04, 0x0e, 0x09, 0x0c, 0x07, 0x00,
    0x02, 0x01, 0x0d, 0x0a, 0x0c, 0x06, 0x00, 0x09, 0x05, 0x0b, 0x0a, 0x05,
    0x00, 0x0d, 0x0e, 0x08, 0x07, 0x0a, 0x0b, 0x01, 0x0a, 0x03, 0x04, 0x0f,
    0x0d, 0x04, 0x01, 0x02, 0x05, 0x0b, 0x08, 0x06, 0x0c, 0x07, 0x06, 0x0c,
    0x09, 0x00, 0x03, 0x05, 0x02, 0x0e, 0x0f, 0x09, 0x3f, 0x33, 0x31, 0x3d,
    0x38, 0x34, 0x3e, 0x37, 0x36, 0x3f, 0x3b, 0x32, 0x33, 0x38, 0x34, 0x3e,
    0x39, 0x3c, 0x37, 0x30, 0x32, 0x31, 0x3d, 0x3a, 0x3c, 0x36, 0x30, 0x39,
    0x35, 0x3b, 0x3a, 0x35, 0x30, 0x3d, 0x3e, 0x38, 0x37, 0x3a, 0x3b, 0x31,
    0x3a, 0x33, 0x34, 0x3f, 0x3d, 0x34, 0x31, 0x32, 0x35, 0x3b, 0x38, 0x36,
    0x3c, 0x37, 0x36, 0x3c, 0x39, 0x30, 0x33, 0x35, 0x32, 0x3e, 0x3f, 0x39,
    0x7f, 0x73, 0x71, 0x7d, 0x78, 0x74, 0x7e, 0x77, 0x76, 0x7f, 0x7b, 0x72,
    0x73, 0x78, 0x74, 0x7e, 0x79, 0x7c, 0x77, 0x70, 0x72, 0x71, 0x7d, 0x7a,
    0x7c, 0x76, 0x70, 0x79, 0x75, 0x7b, 0x7a, 0x75, 0x70, 0x7d, 0x7e, 0x78,
    0x77, 0x7a, 0x7b, 0x71, 0x7a, 0x73, 0x74, 0x7f, 0x7d, 0x74, 0x71, 0x72,
    0x75, 0x7b, 0x78, 0x76, 0x7c, 0x77, 0x76, 0x7c, 0x79, 0x70, 0x73, 0x75,
    0x72, 0x7e, 0x7f, 0x79, 0x8f, 0x83, 0x81, 0x8d, 0x88, 0x84, 0x8e, 0x87,
    0x86, 0x8f, 0x8b, 0x82, 0x83, 0x88, 0x84, 0x8e, 0x89, 0x8c, 0x87, 0x80,
    0x82, 0x81, 0x8d, 0x8a, 0x8c, 0x86, 0x80, 0x89, 0x85, 0x8b, 0x8a, 0x85,
    0x80, 0x8d, 0x8e, 0x88, 0x87, 0x8a, 0x8b, 0x81, 0x8a, 0x83, 0x84, 0x8f,
    0x8d, 0x84, 0x81, 0x82, 0x85, 0x8b, 0x88, 0x86, 0x8c, 0x87, 0x86, 0x8c,
    0x89, 0x80, 0x83, 0x85, 0x82, 0x8e, 0x8f, 0x89, 0x4f, 0x43, 0x41, 0x4d,
    0x48, 0x44, 0x4e, 0x47, 0x46, 0x4f, 0x4b, 0x42, 0x43, 0x48, 0x44, 0x4e,
    0x49, 0x4c, 0x47, 0x40, 0x42, 0x41, 0x4d, 0x4a, 0x4c, 0x46, 0x40, 0x49,
    0x45, 0x4b, 0x4a, 0x45, 0x40, 0x4d, 0x4e, 0x48, 0x47, 0x4a, 0x4b, 0x41,
    0x4a, 0x43, 0x44, 0x4f, 0x4d, 0x44, 0x41, 0x42, 0x45, 0x4b, 0x48, 0x46,
    0x4c, 0x47, 0x46, 0x4c, 0x49, 0x40, 0x43, 0x45, 0x42, 0x4e, 0x4f, 0x49,
    0xff, 0xf3, 0xf1, 0xfd, 0xf8, 0xf4, 0xfe, 0xf7, 0xf6, 0xff, 0xfb, 0xf2,
    0xf3, 0xf8, 0xf4, 0xfe, 0xf9, 0xfc, 0xf7, 0xf0, 0xf2, 0xf1, 0xfd, 0xfa,
    0xfc, 0xf6, 0xf0, 0xf9, 0xf5, 0xfb, 0xfa, 0xf5, 0xf0, 0xfd, 0xfe, 0xf8,
    0xf7, 0xfa, 0xfb, 0xf1, 0xfa, 0xf3, 0xf4, 0xff, 0xfd, 0xf4, 0xf1, 0xf2,
    0xf5, 0xfb, 0xf8, 0xf6, 0xfc, 0xf7, 0xf6, 0xfc, 0xf9, 0xf0, 0xf3, 0xf5,
    0xf2, 0xfe, 0xff, 0xf9, 0x1f, 0x13, 0x11, 0x1d, 0x18, 0x14, 0x1e, 0x17,
    0x16, 0x1f, 0x1b, 0x12, 0x13, 0x18, 0x14, 0x1e, 0x19, 0x1c, 0x17, 0x10,
    0x12, 0x11, 0x1d, 0x1a, 0x1c, 0x16, 0x10, 0x19, 0x15, 0x1b, 0x1a, 0x15,
    0x10, 0x1d, 0x1e, 0x18, 0x17, 0x1a, 0x1b, 0x11, 0x1a, 0x13, 0x14, 0x1f,
    0x1d, 0x14, 0x11, 0x12, 0x15, 0x1b, 0x18, 0x16, 0x1c, 0x17, 0x16, 0x1c,
    0x19, 0x10, 0x13, 0x15, 0x12, 0x1e, 0x1f, 0x19, 0xcf, 0xc3, 0xc1, 0xcd,
    0xc8, 0xc4, 0xce, 0xc7, 0xc6, 0xcf, 0xcb, 0xc2, 0xc3, 0xc8, 0xc4, 0xce,
    0xc9, 0xcc, 0xc7, 0xc0, 0xc2, 0xc1, 0xcd, 0xca, 0xcc, 0xc6, 0xc0, 0xc9,
    0xc5, 0xcb, 0xca, 0xc5, 0xc0, 0xcd, 0xce, 0xc8, 0xc7, 0xca, 0xcb, 0xc1,
    0xca, 0xc3, 0xc4, 0xcf, 0xcd, 0xc4, 0xc1, 0xc2, 0xc5, 0xcb, 0xc8, 0xc6,
    0xcc, 0xc7, 0xc6, 0xcc, 0xc9, 0xc0, 0xc3, 0xc5, 0xc2, 0xce, 0xcf, 0xc9,
    0xef, 0xe3, 0xe1, 0xed, 0xe8, 0xe4, 0xee, 0xe7, 0xe6, 0xef, 0xeb, 0xe2,
    0xe3, 0xe8, 0xe4, 0xee, 0xe9, 0xec, 0xe7, 0xe0, 0xe2, 0xe1, 0xed, 0xea,
    0xec, 0xe6, 0xe0, 0xe9, 0xe5, 0xeb, 0xea, 0xe5, 0xe0, 0xed, 0xee, 0xe8,
    0xe7, 0xea, 0xeb, 0xe1, 0xea, 0xe3, 0xe4, 0xef, 0xed, 0xe4, 0xe1, 0xe2,
    0xe5, 0xeb, 0xe8, 0xe6, 0xec, 0xe7, 0xe6, 0xec, 0xe9, 0xe0, 0xe3, 0xe5,
    0xe2, 0xee, 0xef, 0xe9, 0x8f, 0x83, 0x81, 0x8d, 0x88, 0x84, 0x8e, 0x87,
    0x86, 0x8f, 0x8b, 0x82, 0x83, 0x88, 0x84, 0x8e, 0x89, 0x8c, 0x87, 0x80,
    0x82, 0x81, 0x8d, 0x8a, 0x8c, 0x86, 0x80, 0x89, 0x85, 0x8b, 0x8a, 0x85,
    0x80, 0x8d, 0x8e, 0x88, 0x87, 0x8a, 0x8b, 0x81, 0x8a, 0x83, 0x84, 0x8f,
    0x8d, 0x84, 0x81, 0x82, 0x85, 0x8b, 0x88, 0x86, 0x8c, 0x87, 0x86, 0x8c,
    0x89, 0x80, 0x83, 0x85, 0x82, 0x8e, 0x8f, 0x89, 0x8f, 0x83, 0x81, 0x8d,
    0x88, 0x84, 0x8e, 0x87, 0x86, 0x8f, 0x8b, 0x82, 0x83, 0x88, 0x84, 0x8e,
    0x89, 0x8c, 0x87, 0x80, 0x82, 0x81, 0x8d, 0x8a, 0x8c, 0x86, 0x80, 0x89,
    0x85, 0x8b, 0x8a, 0x85, 0x80, 0x8d, 0x8e, 0x88, 0x87, 0x8a, 0x8b, 0x81,
    0x8a, 0x83, 0x84, 0x8f, 0x8d, 0x84, 0x81, 0x82, 0x85, 0x8b, 0x88, 0x86,
    0x8c, 0x87, 0x86, 0x8c, 0x89, 0x80, 0x83, 0x85, 0x82, 0x8e, 0x8f, 0x89,
    0x2f, 0x23, 0x21, 0x2d, 0x28, 0x24, 0x2e, 0x27, 0x26, 0x2f, 0x2b, 0x22,
    0x23, 0x28, 0x24, 0x2e, 0x29, 0x2c, 0x27, 0x20, 0x22, 0x21, 0x2d, 0x2a,
    0x2c, 0x26, 0x20, 0x29, 0x25, 0x2b, 0x2a, 0x25, 0x20, 0x2d, 0x2e, 0x28,
    0x27, 0x2a, 0x2b, 0x21, 0x2a, 0x23, 0x24, 0x2f, 0x2d, 0x24, 0x21, 0x22,
    0x25, 0x2b, 0x28, 0x26, 0x2c, 0x27, 0x26, 0x2c, 0x29, 0x20, 0x23, 0x25,
    0x22, 0x2e, 0x2f, 0x29, 0xdf, 0xd3, 0xd1, 0xdd, 0xd8, 0xd4, 0xde, 0xd7,
    0xd6, 0xdf, 0xdb, 0xd2, 0xd3, 0xd8, 0xd4, 0xde, 0xd9, 0xdc, 0xd7, 0xd0,
    0xd2, 0xd1, 0xdd, 0xda, 0xdc, 0xd6, 0xd0, 0xd9, 0xd5, 0xdb, 0xda, 0xd5,
    0xd0, 0xdd, 0xde, 0xd8, 0xd7, 0xda, 0xdb, 0xd1, 0xda, 0xd3, 0xd4, 0xdf,
    0xdd, 0xd4, 0xd1, 0xd2, 0xd5, 0xdb, 0xd8, 0xd6, 0xdc, 0xd7, 0xd6, 0xdc,
    0xd9, 0xd0, 0xd3, 0xd5, 0xd2, 0xde, 0xdf, 0xd9, 0x4f, 0x43, 0x41, 0x4d,
    0x48, 0x44, 0x4e, 0x47, 0x46, 0x4f, 0x4b, 0x42, 0x43, 0x48, 0x44, 0x4e,
    0x49, 0x4c, 0x47, 0x40, 0x42, 0x41, 0x4d, 0x4a, 0x4c, 0x46, 0x40, 0x49,
    0x45, 0x4b, 0x4a, 0x45, 0x40, 0x4d, 0x4e, 0x48, 0x47, 0x4a, 0x4b, 0x41,
    0x4a, 0x43, 0x44, 0x4f, 0x4d, 0x44, 0x41, 0x42, 0x45, 0x4b, 0x48, 0x46,
    0x4c, 0x47, 0x46, 0x4c, 0x49, 0x40, 0x43, 0x45, 0x42, 0x4e, 0x4f, 0x49,
    0x6f, 0x63, 0x61, 0x6d, 0x68, 0x64, 0x6e, 0x67, 0x66, 0x6f, 0x6b, 0x62,
    0x63, 0x68, 0x64, 0x6e, 0x69, 0x6c, 0x67, 0x60, 0x62, 0x61, 0x6d, 0x6a,
    0x6c, 0x66, 0x60, 0x69, 0x65, 0x6b, 0x6a, 0x65, 0x60, 0x6d, 0x6e, 0x68,
    0x67, 0x6a, 0x6b, 0x61, 0x6a, 0x63, 0x64, 0x6f, 0x6d, 0x64, 0x61, 0x62,
    0x65, 0x6b, 0x68, 0x66, 0x6c, 0x67, 0x66, 0x6c, 0x69, 0x60, 0x63, 0x65,
    0x62, 0x6e, 0x6f, 0x69, 0x9f, 0x93, 0x91, 0x9d, 0x98, 0x94, 0x9e, 0x97,
    0x96, 0x9f, 0x9b, 0x92, 0x93, 0x98, 0x94, 0x9e, 0x99, 0x9c, 0x97, 0x90,
    0x92, 0x91, 0x9d, 0x9a, 0x9c, 0x96, 0x90, 0x99, 0x95, 0x9b, 0x9a, 0x95,
    0x90, 0x9d, 0x9e, 0x98, 0x97, 0x9a, 0x9b, 0x91, 0x9a, 0x93, 0x94, 0x9f,
    0x9d, 0x94, 0x91, 0x92, 0x95, 0x9b, 0x98, 0x96, 0x9c, 0x97, 0x96, 0x9c,
    0x99, 0x90, 0x93, 0x95, 0x92, 0x9e, 0x9f, 0x99, 0x2f, 0x23, 0x21, 0x2d,
    0x28, 0x24, 0x2e, 0x27, 0x26, 0x2f, 0x2b, 0x22, 0x23, 0x28, 0x24, 0x2e,
    0x29, 0x2c, 0x27, 0x20, 0x22, 0x21, 0x2d, 0x2a, 0x2c, 0x26, 0x20, 0x29,
    0x25, 0x2b, 0x2a, 0x25, 0x20, 0x2d, 0x2e, 0x28, 0x27, 0x2a, 0x2b, 0x21,
    0x2a, 0x23, 0x24, 0x2f, 0x2d, 0x24, 0x21, 0x22, 0x25, 0x2b, 0x28, 0x26,
    0x2c, 0x27, 0x26, 0x2c, 0x29, 0x20, 0x23, 0x25, 0x22, 0x2e, 0x2f, 0x29,
    0x1f, 0x13, 0x11, 0x1d, 0x18, 0x14, 0x1e, 0x17, 0x16, 0x1f, 0x1b, 0x12,
    0x13, 0x18, 0x14, 0x1e, 0x19, 0x1c, 0x17, 0x10, 0x12, 0x11, 0x1d, 0x1a,
    0x1c, 0x16, 0x10, 0x19, 0x15, 0x1b, 0x1a, 0x15, 0x10, 0x1d, 0x1e, 0x18,
    0x17, 0x1a, 0x1b, 0x11, 0x1a, 0x13, 0x14, 0x1f, 0x1d, 0x14, 0x11, 0x12,
    0x15, 0x1b, 0x18, 0x16, 0x1c, 0x17, 0x16, 0x1c, 0x19, 0x10, 0x13, 0x15,
    0x12, 0x1e, 0x1f, 0x19, 0xbf, 0xb3, 0xb1, 0xbd, 0xb8, 0xb4, 0xbe, 0xb7,
    0xb6, 0xbf, 0xbb, 0xb2, 0xb3, 0xb8, 0xb4, 0xbe, 0xb9, 0xbc, 0xb7, 0xb0,
    0xb2, 0xb1, 0xbd, 0xba, 0xbc, 0xb6, 0xb0, 0xb9, 0xb5, 0xbb, 0xba, 0xb5,
    0xb0, 0xbd, 0xbe, 0xb8, 0xb7, 0xba, 0xbb, 0xb1, 0xba, 0xb3, 0xb4, 0xbf,
    0xbd, 0xb4, 0xb1, 0xb2, 0xb5, 0xbb, 0xb8, 0xb6, 0xbc, 0xb7, 0xb6, 0xbc,
    0xb9, 0xb0, 0xb3, 0xb5, 0xb2, 0xbe, 0xbf, 0xb9, 0x7f, 0x73, 0x71, 0x7d,
    0x78, 0x74, 0x7e, 0x77, 0x76, 0x7f, 0x7b, 0x72, 0x73, 0x78, 0x74, 0x7e,
    0x79, 0x7c, 0x77, 0x70, 0x72, 0x71, 0x7d, 0x7a, 0x7c, 0x76, 0x70, 0x79,
    0x75, 0x7b, 0x7a, 0x75, 0x70, 0x7d, 0x7e, 0x78, 0x77, 0x7a, 0x7b, 0x71,
    0x7a, 0x73, 0x74, 0x7f, 0x7d, 0x74, 0x71, 0x72, 0x75, 0x7b, 0x78, 0x76,
    0x7c, 0x77, 0x76, 0x7c, 0x79, 0x70, 0x73, 0x75, 0x72, 0x7e, 0x7f, 0x79,
    0xff, 0xf3, 0xf1, 0xfd, 0xf8, 0xf4, 0xfe, 0xf7, 0xf6, 0xff, 0xfb, 0xf2,
    0xf3, 0xf8, 0xf4, 0xfe, 0xf9, 0xfc, 0xf7, 0xf0, 0xf2, 0xf1, 0xfd, 0xfa,
    0xfc, 0xf6, 0xf0, 0xf9, 0xf5, 0xfb, 0xfa, 0xf5, 0xf0, 0xfd, 0xfe, 0xf8,
    0xf7, 0xfa, 0xfb, 0xf1, 0xfa, 0xf3, 0xf4, 0xff, 0xfd, 0xf4, 0xf1, 0xf2,
    0xf5, 0xfb, 0xf8, 0xf6, 0xfc, 0xf7, 0xf6, 0xfc, 0xf9, 0xf0, 0xf3, 0xf5,
    0xf2, 0xfe, 0xff, 0xf9, 0x5f, 0x53, 0x51, 0x5d, 0x58, 0x54, 0x5e, 0x57,
    0x56, 0x5f, 0x5b, 0x52, 0x53, 0x58, 0x54, 0x5e, 0x59, 0x5c, 0x57, 0x50,
    0x52, 0x51, 0x5d, 0x5a, 0x5c, 0x56, 0x50, 0x59, 0x55, 0x5b, 0x5a, 0x55,
    0x50, 0x5d, 0x5e, 0x58, 0x57, 0x5a, 0x5b, 0x51, 0x5a, 0x53, 0x54, 0x5f,
    0x5d, 0x54, 0x51, 0x52, 0x55, 0x5b, 0x58, 0x56, 0x5c, 0x57, 0x56, 0x5c,
    0x59, 0x50, 0x53, 0x55, 0x52, 0x5e, 0x5f, 0x59, 0xcf, 0xc3, 0xc1, 0xcd,
    0xc8, 0xc4, 0xce, 0xc7, 0xc6, 0xcf, 0xcb, 0xc2, 0xc3, 0xc8, 0xc4, 0xce,
    0xc9, 0xcc, 0xc7, 0xc0, 0xc2, 0xc1, 0xcd, 0xca, 0xcc, 0xc6, 0xc0, 0xc9,
    0xc5, 0xcb, 0xca, 0xc5, 0xc0, 0xcd, 0xce, 0xc8, 0xc7, 0xca, 0xcb, 0xc1,
    0xca, 0xc3, 0xc4, 0xcf, 0xcd, 0xc4, 0xc1, 0xc2, 0xc5, 0xcb, 0xc8, 0xc6,
    0xcc, 0xc7, 0xc6, 0xcc, 0xc9, 0xc0, 0xc3, 0xc5, 0xc2, 0xce, 0xcf, 0xc9,
    0xbf, 0xb3, 0xb1, 0xbd, 0xb8, 0xb4, 0xbe, 0xb7, 0xb6, 0xbf, 0xbb, 0xb2,
    0xb3, 0xb8, 0xb4, 0xbe, 0xb9, 0xbc, 0xb7, 0xb0, 0xb2, 0xb1, 0xbd, 0xba,
    0xbc, 0xb6, 0xb0, 0xb9, 0xb5, 0xbb, 0xba, 0xb5, 0xb0, 0xbd, 0xbe, 0xb8,
    0xb7, 0xba, 0xbb, 0xb1, 0xba, 0xb3, 0xb4, 0xbf, 0xbd, 0xb4, 0xb1, 0xb2,
    0xb5, 0xbb, 0xb8, 0xb6, 0xbc, 0xb7, 0xb6, 0xbc, 0xb9, 0xb0, 0xb3, 0xb5,
    0xb2, 0xbe, 0xbf, 0xb9, 0x9f, 0x93, 0x91, 0x9d, 0x98, 0x94, 0x9e, 0x97,
    0x96, 0x9f, 0x9b, 0x92, 0x93, 0x98, 0x94, 0x9e, 0x99, 0x9c, 0x97, 0x90,
    0x92, 0x91, 0x9d, 0x9a, 0x9c, 0x96, 0x90, 0x99, 0x95, 0x9b, 0x9a, 0x95,
    0x90, 0x9d, 0x9e, 0x98, 0x97, 0x9a, 0x9b, 0x91, 0x9a, 0x93, 0x94, 0x9f,
    0x9d, 0x94, 0x91, 0x92, 0x95, 0x9b, 0x98, 0x96, 0x9c, 0x97, 0x96, 0x9c,
    0x99, 0x90, 0x93, 0x95, 0x92, 0x9e, 0x9f, 0x99, 0x3f, 0x33, 0x31, 0x3d,
    0x38, 0x34, 0x3e, 0x37, 0x36, 0x3f, 0x3b, 0x32, 0x33, 0x38, 0x34, 0x3e,
    0x39, 0x3c, 0x37, 0x30, 0x32, 0x31, 0x3d, 0x3a, 0x3c, 0x36, 0x30, 0x39,
    0x35, 0x3b, 0x3a, 0x35, 0x30, 0x3d, 0x3e, 0x38, 0x37, 0x3a, 0x3b, 0x31,
    0x3a, 0x33, 0x34, 0x3f, 0x3d, 0x34, 0x31, 0x32, 0x35, 0x3b, 0x38, 0x36,
    0x3c, 0x37, 0x36, 0x3c, 0x39, 0x30, 0x33, 0x35, 0x32, 0x3e, 0x3f, 0x39,
    0x7f, 0x73, 0x71, 0x7d, 0x78, 0x74, 0x7e, 0x77, 0x76, 0x7f, 0x7b, 0x72,
    0x73, 0x78, 0x74, 0x7e, 0x79, 0x7c, 0x77, 0x70, 0x72, 0x71, 0x7d, 0x7a,
    0x7c, 0x76, 0x70, 0x79, 0x75, 0x7b, 0x7a, 0x75, 0x70, 0x7d, 0x7e, 0x78,
    0x77, 0x7a, 0x7b, 0x71, 0x7a, 0x73, 0x74, 0x7f, 0x7d, 0x74, 0x71, 0x72,
    0x75, 0x7b, 0x78, 0x76, 0x7c, 0x77, 0x76, 0x7c, 0x79, 0x70, 0x73, 0x75,
    0x72, 0x7e, 0x7f, 0x79, 0xef, 0xe3, 0xe1, 0xed, 0xe8, 0xe4, 0xee, 0xe7,
    0xe6, 0xef, 0xeb, 0xe2, 0xe3, 0xe8, 0xe4, 0xee, 0xe9, 0xec, 0xe7, 0xe0,
    0xe2, 0xe1, 0xed, 0xea, 0xec, 0xe6, 0xe0, 0xe9, 0xe5, 0xeb, 0xea, 0xe5,
    0xe0, 0xed, 0xee, 0xe8, 0xe7, 0xea, 0xeb, 0xe1, 0xea, 0xe3, 0xe4, 0xef,
    0xed, 0xe4, 0xe1, 0xe2, 0xe5, 0xeb, 0xe8, 0xe6, 0xec, 0xe7, 0xe6, 0xec,
    0xe9, 0xe0, 0xe3, 0xe5, 0xe2, 0xee, 0xef, 0xe9, 0x3f, 0x33, 0x31, 0x3d,
    0x38, 0x34, 0x3e, 0x37, 0x36, 0x3f, 0x3b, 0x32, 0x33, 0x38, 0x34, 0x3e,
    0x39, 0x3c, 0x37, 0x30, 0x32, 0x31, 0x3d, 0x3a, 0x3c, 0x36, 0x30, 0x39,
    0x35, 0x3b, 0x3a, 0x35, 0x30, 0x3d, 0x3e, 0x38, 0x37, 0x3a, 0x3b, 0x31,
    0x3a, 0x33, 0x34, 0x3f, 0x3d, 0x34, 0x31, 0x32, 0x35, 0x3b, 0x38, 0x36,
    0x3c, 0x37, 0x36, 0x3c, 0x39, 0x30, 0x33, 0x35, 0x32, 0x3e, 0x3f, 0x39,
    0xaf, 0xa3, 0xa1, 0xad, 0xa8, 0xa4, 0xae, 0xa7, 0xa6, 0xaf, 0xab, 0xa2,
    0xa3, 0xa8, 0xa4, 0xae, 0xa9, 0xac, 0xa7, 0xa0, 0xa2, 0xa1, 0xad, 0xaa,
    0xac, 0xa6, 0xa0, 0xa9, 0xa5, 0xab, 0xaa, 0xa5, 0xa0, 0xad, 0xae, 0xa8,
    0xa7, 0xaa, 0xab, 0xa1, 0xaa, 0xa3, 0xa4, 0xaf, 0xad, 0xa4, 0xa1, 0xa2,
    0xa5, 0xab, 0xa8, 0xa6, 0xac, 0xa7, 0xa6, 0xac, 0xa9, 0xa0, 0xa3, 0xa5,
    0xa2, 0xae, 0xaf, 0xa9, 0xaf, 0xa3, 0xa1, 0xad, 0xa8, 0xa4, 0xae, 0xa7,
    0xa6, 0xaf, 0xab, 0xa2, 0xa3, 0xa8, 0xa4, 0xae, 0xa9, 0xac, 0xa7, 0xa0,
    0xa2, 0xa1, 0xad, 0xaa, 0xac, 0xa6, 0xa0, 0xa9, 0xa5, 0xab, 0xaa, 0xa5,
    0xa0, 0xad, 0xae, 0xa8, 0xa7, 0xaa, 0xab, 0xa1, 0xaa, 0xa3, 0xa4, 0xaf,
    0xad, 0xa4, 0xa1, 0xa2, 0xa5, 0xab, 0xa8, 0xa6, 0xac, 0xa7, 0xa6, 0xac,
    0xa9, 0xa0, 0xa3, 0xa5, 0xa2, 0xae, 0xaf, 0xa9, 0x0f, 0x03, 0x01, 0x0d,
    0x08, 0x04, 0x0e, 0x07, 0x06, 0x0f, 0x0b, 0x02, 0x03, 0x08, 0x04, 0x0e,
    0x09, 0x0c, 0x07, 0x00, 0x02, 0x01, 0x0d, 0x0a, 0x0c, 0x06, 0x00, 0x09,
    0x05, 0x0b, 0x0a, 0x05, 0x00, 0x0d, 0x0e, 0x08, 0x07, 0x0a, 0x0b, 0x01,
    0x0a, 0x03, 0x04, 0x0f, 0x0d, 0x04, 0x01, 0x02, 0x05, 0x0b, 0x08, 0x06,
    0x0c, 0x07, 0x06, 0x0c, 0x09, 0x00, 0x03, 0x05, 0x02, 0x0e, 0x0f, 0x09,
    0x5f, 0x53, 0x51, 0x5d, 0x58, 0x54, 0x5e, 0x57, 0x56, 0x5f, 0x5b, 0x52,
    0x53, 0x58, 0x54, 0x5e, 0x59, 0x5c, 0x57, 0x50, 0x52, 0x51, 0x5d, 0x5a,
    0x5c, 0x56, 0x50, 0x59, 0x55, 0x5b, 0x5a, 0x55, 0x50, 0x5d, 0x5e, 0x58,
    0x57, 0x5a, 0x5b, 0x51, 0x5a, 0x53, 0x54, 0x5f, 0x5d, 0x54, 0x51, 0x52,
    0x55, 0x5b, 0x58, 0x56, 0x5c, 0x57, 0x56, 0x5c, 0x59, 0x50, 0x53, 0x55,
    0x52, 0x5e, 0x5f, 0x59, 0x6f, 0x63, 0x61, 0x6d, 0x68, 0x64, 0x6e, 0x67,
    0x66, 0x6f, 0x6b, 0x62, 0x63, 0x68, 0x64, 0x6e, 0x69, 0x6c, 0x67, 0x60,
    0x62, 0x61, 0x6d, 0x6a, 0x6c, 0x66, 0x60, 0x69, 0x65, 0x6b, 0x6a, 0x65,
    0x60, 0x6d, 0x6e, 0x68, 0x67, 0x6a, 0x6b, 0x61, 0x6a, 0x63, 0x64, 0x6f,
    0x6d, 0x64, 0x61, 0x62, 0x65, 0x6b, 0x68, 0x66, 0x6c, 0x67, 0x66, 0x6c,
    0x69, 0x60, 0x63, 0x65, 0x62, 0x6e, 0x6f, 0x69, 0x0f, 0x03, 0x01, 0x0d,
    0x08, 0x04, 0x0e, 0x07, 0x06, 0x0f, 0x0b, 0x02, 0x03, 0x08, 0x04, 0x0e,
    0x09, 0x0c, 0x07, 0x00, 0x02, 0x01, 0x0d, 0x0a, 0x0c, 0x06, 0x00, 0x09,
    0x05, 0x0b, 0x0a, 0x05, 0x00, 0x0d, 0x0e, 0x08, 0x07, 0x0a, 0x0b, 0x01,
    0x0a, 0x03, 0x04, 0x0f, 0x0d, 0x04, 0x01, 0x02, 0x05, 0x0b, 0x08, 0x06,
    0x0c, 0x07, 0x06, 0x0c, 0x09, 0x00, 0x03, 0x05, 0x02, 0x0e, 0x0f, 0x09,
    0xdf, 0xd3, 0xd1, 0xdd, 0xd8, 0xd4, 0xde, 0xd7, 0xd6, 0xdf, 0xdb, 0xd2,
    0xd3, 0xd8, 0xd4, 0xde, 0xd9, 0xdc, 0xd7, 0xd0, 0xd2, 0xd1, 0xdd, 0xda,
    0xdc, 0xd6, 0xd0, 0xd9, 0xd5, 0xdb, 0xda, 0xd5, 0xd0, 0xdd, 0xde, 0xd8,
    0xd7, 0xda, 0xdb, 0xd1, 0xda, 0xd3, 0xd4, 0xdf, 0xdd, 0xd4, 0xd1, 0xd2,
    0xd5, 0xdb, 0xd8, 0xd6, 0xdc, 0xd7, 0xd6, 0xdc, 0xd9, 0xd0, 0xd3, 0xd5,
    0xd2, 0xde, 0xdf, 0xd9,
  },
  {
    0xa7, 0xad, 0xad, 0xa8, 0xae, 0xab, 0xa3, 0xa5, 0xa0, 0xa6, 0xa6, 0xaf,
    0xa9, 0xa0, 0xaa, 0xa3, 0xa1, 0xa4, 0xa2, 0xa7, 0xa8, 0xa2, 0xa5, 0xac,
    0xab, 0xa1, 0xac, 0xaa, 0xa4, 0xae, 0xaf, 0xa9, 0xaa, 0xa3, 0xa6, 0xaf,
    0xa9, 0xa0, 0xa0, 0xa6, 0xac, 0xaa, 0xab, 0xa1, 0xa7, 0xad, 0xad, 0xa8,
    0xaf, 0xa9, 0xa1, 0xa4, 0xa3, 0xa5, 0xae, 0xab, 0xa5, 0xac, 0xa2, 0xa7,
    0xa8, 0xa2, 0xa4, 0xae, 0xd7, 0xdd, 0xdd, 0xd8, 0xde, 0xdb, 0xd3, 0xd5,
    0xd0, 0xd6, 0xd6, 0xdf, 0xd9, 0xd0, 0xda, 0xd3, 0xd1, 0xd4, 0xd2, 0xd7,
    0xd8, 0xd2, 0xd5, 0xdc, 0xdb, 0xd1, 0xdc, 0xda, 0xd4, 0xde, 0xdf, 0xd9,
    0xda, 0xd3, 0xd6, 0xdf, 0xd9, 0xd0, 0xd0, 0xd6, 0xdc, 0xda, 0xdb, 0xd1,
    0xd7, 0xdd, 0xdd, 0xd8, 0xdf, 0xd9, 0xd1, 0xd4, 0xd3, 0xd5, 0xde, 0xdb,
    0xd5, 0xdc, 0xd2, 0xd7, 0xd8, 0xd2, 0xd4, 0xde, 0x07, 0x0d, 0x0d, 0x08,
    0x0e, 0x0b, 0x03, 0x05, 0x00, 0x06, 0x06, 0x0f, 0x09, 0x00, 0x0a, 0x03,
    0x01, 0x04, 0x02, 0x07, 0x08, 0x02, 0x05, 0x0c, 0x0b, 0x01, 0x0c, 0x0a,
    0x04, 0x0e, 0x0f, 0x09, 0x0a, 0x03, 0x06, 0x0f, 0x09, 0x00, 0x00, 0x06,
    0x0c, 0x0a, 0x0b, 0x01, 0x07, 0x0d, 0x0d, 0x08, 0x0f, 0x09, 0x01, 0x04,
    0x03, 0x05, 0x0e, 0x0b, 0x05, 0x0c, 0x02, 0x07, 0x08, 0x02, 0x04, 0x0e,
    0x77, 0x7d, 0x7d, 0x78, 0x7e, 0x7b, 0x73, 0x75, 0x70, 0x76, 0x76, 0x7f,
    0x79, 0x70, 0x7a, 0x73, 0x71, 0x74, 0x72, 0x77, 0x78, 0x72, 0x75, 0x7c,
    0x7b, 0x71, 0x7c, 0x7a, 0x74, 0x7e, 0x7f, 0x79, 0x7a, 0x73, 0x76, 0x7f,
    0x79, 0x70, 0x70, 0x76, 0x7c, 0x7a, 0x7b, 0x71, 0x77, 0x7d, 0x7d, 0x78,
    0x7f, 0x79, 0x71, 0x74, 0x73, 0x75, 0x7e, 0x7b, 0x75, 0x7c, 0x72, 0x77,
    0x78, 0x72, 0x74, 0x7e, 0x97, 0x9d, 0x9d, 0x98, 0x9e, 0x9b, 0x93, 0x95,
    0x90, 0x96, 0x96, 0x9f, 0x99, 0x90, 0x9a, 0x93, 0x91, 0x94, 0x92, 0x97,
    0x98, 0x92, 0x95, 0x9c, 0x9b, 0x91, 0x9c, 0x9a, 0x94, 0x9e, 0x9f, 0x99,
    0x9a, 0x93, 0x96, 0x9f, 0x99, 0x90, 0x90, 0x96, 0x9c, 0x9a, 0x9b, 0x91,
    0x97, 0x9d, 0x9d, 0x98, 0x9f, 0x99, 0x91, 0x94, 0x93, 0x95, 0x9e, 0x9b,
    0x95, 0x9c, 0x92, 0x97, 0x98, 0x92, 0x94, 0x9e, 0x07, 0x0d, 0x0d, 0x08,
    0x0e, 0x0b, 0x03, 0x05, 0x00, 0x06, 0x06, 0x0f, 0x09, 0x00, 0x0a, 0x03,
    0x01, 0x04, 0x02, 0x07, 0x08, 0x02, 0x05, 0x0c, 0x0b, 0x01, 0x0c, 0x0a,
    0x04, 0x0e, 0x0f, 0x09, 0x0a, 0x03, 0x06, 0x0f, 0x09, 0x00, 0x00, 0x06,
    0x0c, 0x0a, 0x0b, 0x01, 0x07, 0x0d, 0x0d, 0x08, 0x0f, 0x09, 0x01, 0x04,
    0x03, 0x05, 0x0e, 0x0b, 0x05, 0x0c, 0x02, 0x07, 0x08, 0x02, 0x04, 0x0e,
    0xe7, 0xed, 0xed, 0xe8, 0xee, 0xeb, 0xe3, 0xe5, 0xe0, 0xe6, 0xe6, 0xef,
    0xe9, 0xe0, 0xea, 0xe3, 0xe1, 0xe4, 0xe2, 0xe7, 0xe8, 0xe2, 0xe5, 0xec,
    0xeb, 0xe1, 0xec, 0xea, 0xe4, 0xee, 0xef, 0xe9, 0xea, 0xe3, 0xe6, 0xef,
    0xe9, 0xe0, 0xe0, 0xe6, 0xec, 0xea, 0xeb, 0xe1, 0xe7, 0xed, 0xed, 0xe8,
    0xef, 0xe9, 0xe1, 0xe4, 0xe3, 0xe5, 0xee, 0xeb, 0xe5, 0xec, 0xe2, 0xe7,
    0xe8, 0xe2, 0xe4, 0xee, 0x97, 0x9d, 0x9d, 0x98, 0x9e, 0x9b, 0x93, 0x95,
    0x90, 0x96, 0x96, 0x9f, 0x99, 0x90, 0x9a, 0x93, 0x91, 0x94, 0x92, 0x97,
    0x98, 0x92, 0x95, 0x9c, 0x9b, 0x91, 0x9c, 0x9a, 0x94, 0x9e, 0x9f, 0x99,
    0x9a, 0x93, 0x96, 0x9f, 0x99, 0x90, 0x90, 0x96, 0x9c, 0x9a, 0x9b, 0x91,
    0x97, 0x9d, 0x9d, 0x98, 0x9f, 0x99, 0x91, 0x94, 0x93, 0x95, 0x9e, 0x9b,
    0x95, 0x9c, 0x92, 0x97, 0x98, 0x92, 0x94, 0x9e, 0x67, 0x6d, 0x6d, 0x68,
    0x6e, 0x6b, 0x63, 0x65, 0x60, 0x66, 0x66, 0x6f, 0x69, 0x60, 0x6a, 0x63,
    0x61, 0x64, 0x62, 0x67, 0x68, 0x62, 0x65, 0x6c, 0x6b, 0x61, 0x6c, 0x6a,
    0x64, 0x6e, 0x6f, 0x69, 0x6a, 0x63, 0x66, 0x6f, 0x69, 0x60, 0x60, 0x66,
    0x6c, 0x6a, 0x6b, 0x61, 0x67, 0x6d, 0x6d, 0x68, 0x6f, 0x69, 0x61, 0x64,
    0x63, 0x65, 0x6e, 0x6b, 0x65, 0x6c, 0x62, 0x67, 0x68, 0x62, 0x64, 0x6e,
    0x37, 0x3d, 0x3d, 0x38, 0x3e, 0x3b, 0x33, 0x35, 0x30, 0x36, 0x36, 0x3f,
    0x39, 0x30, 0x3a, 0x33, 0x31, 0x34, 0x32, 0x37, 0x38, 0x32, 0x35, 0x3c,
    0x3b, 0x31, 0x3c, 0x3a, 0x34, 0x3e, 0x3f, 0x39, 0x3a, 0x33, 0x36, 0x3f,
    0x39, 0x30, 0x30, 0x36, 0x3c, 0x3a, 0x3b, 0x31, 0x37, 0x3d, 0x3d, 0x38,
    0x3f, 0x39, 0x31, 0x34, 0x33, 0x35, 0x3e, 0x3b, 0x35, 0x3c, 0x32, 0x37,
    0x38, 0x32, 0x34, 0x3e, 0x37, 0x3d, 0x3d, 0x38, 0x3e, 0x3b, 0x33, 0x35,
    0x30, 0x36, 0x36, 0x3f, 0x39, 0x30, 0x3a, 0x33, 0x31, 0x34, 0x32, 0x37,
    0x38, 0x32, 0x35, 0x3c, 0x3b, 0x31, 0x3c, 0x3a, 0x34, 0x3e, 0x3f, 0x39,
    0x3a, 0x33, 0x36, 0x3f, 0x39, 0x30, 0x30, 0x36, 0x3c, 0x3a, 0x3b, 0x31,
    0x37, 0x3d, 0x3d, 0x38, 0x3f, 0x39, 0x31, 0x34, 0x33, 0x35, 0x3e, 0x3b,
    0x35, 0x3c, 0x32, 0x37, 0x38, 0x32, 0x34, 0x3e, 0x47, 0x4d, 0x4d, 0x48,
    0x4e, 0x4b, 0x43, 0x45, 0x40, 0x46, 0x46, 0x4f, 0x49, 0x40, 0x4a, 0x43,
    0x41, 0x44, 0x42, 0x47, 0x48, 0x42, 0x45, 0x4c, 0x4b, 0x41, 0x4c, 0x4a,
    0x44, 0x4e, 0x4f, 0x49, 0x4a, 0x43, 0x46, 0x4f, 0x49, 0x40, 0x40, 0x46,
    0x4c, 0x4a, 0x4b, 0x41, 0x47, 0x4d, 0x4d, 0x48, 0x4f, 0x49, 0x41, 0x44,
    0x43, 0x45, 0x4e, 0x4b, 0x45, 0x4c, 0x42, 0x47, 0x48, 0x42, 0x44, 0x4e,
    0xf7, 0xfd, 0xfd, 0xf8, 0xfe, 0xfb, 0xf3, 0xf5, 0xf0, 0xf6, 0xf6, 0xff,
    0xf9, 0xf0, 0xfa, 0xf3, 0xf1, 0xf4, 0xf2, 0xf7, 0xf8, 0xf2, 0xf5, 0xfc,
    0xfb, 0xf1, 0xfc, 0xfa, 0xf4, 0xfe, 0xff, 0xf9, 0xfa, 0xf3, 0xf6, 0xff,
    0xf9, 0xf0, 0xf0, 0xf6, 0xfc, 0xfa, 0xfb, 0xf1, 0xf7, 0xfd, 0xfd, 0xf8,
    0xff, 0xf9, 0xf1, 0xf4, 0xf3, 0xf5, 0xfe, 0xfb, 0xf5, 0xfc, 0xf2, 0xf7,
    0xf8, 0xf2, 0xf4, 0xfe, 0x67, 0x6d, 0x6d, 0x68, 0x6e, 0x6b, 0x63, 0x65,
    0x60, 0x66, 0x66, 0x6f, 0x69, 0x60, 0x6a, 0x63, 0x61, 0x64, 0x62, 0x67,
    0x68, 0x62, 0x65, 0x6c, 0x6b, 0x61, 0x6c, 0x6a, 0x64, 0x6e, 0x6f, 0x69,
    0x6a, 0x63, 0x66, 0x6f, 0x69, 0x60, 0x60, 0x66, 0x6c, 0x6a, 0x6b, 0x61,
    0x67, 0x6d, 0x6d, 0x68, 0x6f, 0x69, 0x61, 0x64, 0x63, 0x65, 0x6e, 0x6b,
    0x65, 0x6c, 0x62, 0x67, 0x68, 0x62, 0x64, 0x6e, 0x57, 0x5d, 0x5d, 0x58,
    0x5e, 0x5b, 0x53, 0x55, 0x50, 0x56, 0x56, 0x5f, 0x59, 0x50, 0x5a, 0x53,
    0x51, 0x54, 0x52, 0x57, 0x58, 0x52, 0x55, 0x5c, 0x5b, 0x51, 0x5c, 0x5a,
    0x54, 0x5e, 0x5f, 0x59, 0x5a, 0x53, 0x56, 0x5f, 0x59, 0x50, 0x50, 0x56,
    0x5c, 0x5a, 0x5b, 0x51, 0x57, 0x5d, 0x5d, 0x58, 0x5f, 0x59, 0x51, 0x54,
    0x53, 0x55, 0x5e, 0x5b, 0x55, 0x5c, 0x52, 0x57, 0x58, 0x52, 0x54, 0x5e,
    0xa7, 0xad, 0xad, 0xa8, 0xae, 0xab, 0xa3, 0xa5, 0xa0, 0xa6, 0xa6, 0xaf,
    0xa9, 0xa0, 0xaa, 0xa3, 0xa1, 0xa4, 0xa2, 0xa7, 0xa8, 0xa2, 0xa5, 0xac,
    0xab, 0xa1, 0xac, 0xaa, 0xa4, 0xae, 0xaf, 0xa9, 0xaa, 0xa3, 0xa6, 0xaf,
    0xa9, 0xa0, 0xa0, 0xa6, 0xac, 0xaa, 0xab, 0xa1, 0xa7, 0xad, 0xad, 0xa8,
    0xaf, 0xa9, 0xa1, 0xa4, 0xa3, 0xa5, 0xae, 0xab, 0xa5, 0xac, 0xa2, 0xa7,
    0xa8, 0xa2, 0xa4, 0xae, 0x17, 0x1d, 0x1d, 0x18, 0x1e, 0x1b, 0x13, 0x15,
    0x10, 0x16, 0x16, 0x1f, 0x19, 0x10, 0x1a, 0x13, 0x11, 0x14, 0x12, 0x17,
    0x18, 0x12, 0x15, 0x1c, 0x1b, 0x11, 0x1c, 0x1a, 0x14, 0x1e, 0x1f, 0x19,
    0x1a, 0x13, 0x16, 0x1f, 0x19, 0x10, 0x10, 0x16, 0x1c, 0x1a, 0x1b, 0x11,
    0x17, 0x1d, 0x1d, 0x18, 0x1f, 0x19, 0x11, 0x14, 0x13, 0x15, 0x1e, 0x1b,
    0x15, 0x1c, 0x12, 0x17, 0x18, 0x12, 0x14, 0x1e, 0x27, 0x2d, 0x2d, 0x28,
    0x2e, 0x2b, 0x23, 0x25, 0x20, 0x26, 0x26, 0x2f, 0x29, 0x20, 0x2a, 0x23,
    0x21, 0x24, 0x22, 0x27, 0x28, 0x22, 0x25, 0x2c, 0x2b, 0x21, 0x2c, 0x2a,
    0x24, 0x2e, 0x2f, 0x29, 0x2a, 0x23, 0x26, 0x2f, 0x29, 0x20, 0x20, 0x26,
    0x2c, 0x2a, 0x2b, 0x21, 0x27, 0x2d, 0x2d, 0x28, 0x2f, 0x29, 0x21, 0x24,
    0x23, 0x25, 0x2e, 0x2b, 0x25, 0x2c, 0x22, 0x27, 0x28, 0x22, 0x24, 0x2e,
    0xd7, 0xdd, 0xdd, 0xd8, 0xde, 0xdb, 0xd3, 0xd5, 0xd0, 0xd6, 0xd6, 0xdf,
    0xd9, 0xd0, 0xda, 0xd3, 0xd1, 0xd4, 0xd2, 0xd7, 0xd8, 0xd2, 0xd5, 0xdc,
    0xdb, 0xd1, 0xdc, 0xda, 0xd4, 0xde, 0xdf, 0xd9, 0xda, 0xd3, 0xd6, 0xdf,
    0xd9, 0xd0, 0xd0, 0xd6, 0xdc, 0xda, 0xdb, 0xd1, 0xd7, 0xdd, 0xdd, 0xd8,
    0xdf, 0xd9, 0xd1, 0xd4, 0xd3, 0xd5, 0xde, 0xdb, 0xd5, 0xdc, 0xd2, 0xd7,
    0xd8, 0xd2, 0xd4, 0xde, 0x87, 0x8d, 0x8d, 0x88, 0x8e, 0x8b, 0x83, 0x85,
    0x80, 0x86, 0x86, 0x8f, 0x89, 0x80, 0x8a, 0x83, 0x81, 0x84, 0x82, 0x87,
    0x88, 0x82, 0x85, 0x8c, 0x8b, 0x81, 0x8c, 0x8a, 0x84, 0x8e, 0x8f, 0x89,
    0x8a, 0x83, 0x86, 0x8f, 0x89, 0x80, 0x80, 0x86, 0x8c, 0x8a, 0x8b, 0x81,
    0x87, 0x8d, 0x8d, 0x88, 0x8f, 0x89, 0x81, 0x84, 0x83, 0x85, 0x8e, 0x8b,
    0x85, 0x8c, 0x82, 0x87, 0x88, 0x82, 0x84, 0x8e, 0xc7, 0xcd, 0xcd, 0xc8,
    0xce, 0xcb, 0xc3, 0xc5, 0xc0, 0xc6, 0xc6, 0xcf, 0xc9, 0xc0, 0xca, 0xc3,
    0xc1, 0xc4, 0xc2, 0xc7, 0xc8, 0xc2, 0xc5, 0xcc, 0xcb, 0xc1, 0xcc, 0xca,
    0xc4, 0xce, 0xcf, 0xc9, 0xca, 0xc3, 0xc6, 0xcf, 0xc9, 0xc0, 0xc0, 0xc6,
    0xcc, 0xca, 0xcb, 0xc1, 0xc7, 0xcd, 0xcd, 0xc8, 0xcf, 0xc9, 0xc1, 0xc4,
    0xc3, 0xc5, 0xce, 0xcb, 0xc5, 0xcc, 0xc2, 0xc7, 0xc8, 0xc2, 0xc4, 0xce,
    0x57, 0x5d, 0x5d, 0x58, 0x5e, 0x5b, 0x53, 0x55, 0x50, 0x56, 0x56, 0x5f,
    0x59, 0x50, 0x5a, 0x53, 0x51, 0x54, 0x52, 0x57, 0x58, 0x52, 0x55, 0x5c,
    0x5b, 0x51, 0x5c, 0x5a, 0x54, 0x5e, 0x5f, 0x59, 0x5a, 0x53, 0x56, 0x5f,
    0x59, 0x50, 0x50, 0x56, 0x5c, 0x5a, 0x5b, 0x51, 0x57, 0x5d, 0x5d, 0x58,
    0x5f, 0x59, 0x51, 0x54, 0x53, 0x55, 0x5e, 0x5b, 0x55, 0x5c, 0x52, 0x57,
    0x58, 0x52, 0x54, 0x5e, 0x77, 0x7d, 0x7d, 0x78, 0x7e, 0x7b, 0x73, 0x75,
    0x70, 0x76, 0x76, 0x7f, 0x79, 0x70, 0x7a, 0x73, 0x71, 0x74, 0x72, 0x77,
    0x78, 0x72, 0x75, 0x7c, 0x7b, 0x71, 0x7c, 0x7a, 0x74, 0x7e, 0x7f, 0x79,
    0x7a, 0x73, 0x76, 0x7f, 0x79, 0x70, 0x70, 0x76, 0x7c, 0x7a, 0x7b, 0x71,
    0x77, 0x7d, 0x7d, 0x78, 0x7f, 0x79, 0x71, 0x74, 0x73, 0x75, 0x7e, 0x7b,
    0x75, 0x7c, 0x72, 0x77, 0x78, 0x72, 0x74, 0x7e, 0xe7, 0xed, 0xed, 0xe8,
    0xee, 0xeb, 0xe3, 0xe5, 0xe0, 0xe6, 0xe6, 0xef, 0xe9, 0xe0, 0xea, 0xe3,
    0xe1, 0xe4, 0xe2, 0xe7, 0xe8, 0xe2, 0xe5, 0xec, 0xeb, 0xe1, 0xec, 0xea,
    0xe4, 0xee, 0xef, 0xe9, 0xea, 0xe3, 0xe6, 0xef, 0xe9, 0xe0, 0xe0, 0xe6,
    0xec, 0xea, 0xeb, 0xe1, 0xe7, 0xed, 0xed, 0xe8, 0xef, 0xe9, 0xe1, 0xe4,
    0xe3, 0xe5, 0xee, 0xeb, 0xe5, 0xec, 0xe2, 0xe7, 0xe8, 0xe2, 0xe4, 0xee,
    0xb7, 0xbd, 0xbd, 0xb8, 0xbe, 0xbb, 0xb3, 0xb5, 0xb0, 0xb6, 0xb6, 0xbf,
    0xb9, 0xb0, 0xba, 0xb3, 0xb1, 0xb4, 0xb2, 0xb7, 0xb8, 0xb2, 0xb5, 0xbc,
    0xbb, 0xb1, 0xbc, 0xba, 0xb4, 0xbe, 0xbf, 0xb9, 0xba, 0xb3, 0xb6, 0xbf,
    0xb9, 0xb0, 0xb0, 0xb6, 0xbc, 0xba, 0xbb, 0xb1, 0xb7, 0xbd, 0xbd, 0xb8,
    0xbf, 0xb9, 0xb1, 0xb4, 0xb3, 0xb5, 0xbe, 0xbb, 0xb5, 0xbc, 0xb2, 0xb7,
    0xb8, 0xb2, 0xb4, 0xbe, 0xc7, 0xcd, 0xcd, 0xc8, 0xce, 0xcb, 0xc3, 0xc5,
    0xc0, 0xc6, 0xc6, 0xcf, 0xc9, 0xc0, 0xca, 0xc3, 0xc1, 0xc4, 0xc2, 0xc7,
    0xc8, 0xc2, 0xc5, 0xcc, 0xcb, 0xc1, 0xcc, 0xca, 0xc4, 0xce, 0xcf, 0xc9,
    0xca, 0xc3, 0xc6, 0xcf, 0xc9, 0xc0, 0xc0, 0xc6, 0xcc, 0xca, 0xcb, 0xc1,
    0xc7, 0xcd, 0xcd, 0xc8, 0xcf, 0xc9, 0xc1, 0xc4, 0xc3, 0xc5, 0xce, 0xcb,
    0xc5, 0xcc, 0xc2, 0xc7, 0xc8, 0xc2, 0xc4, 0xce, 0x47, 0x4d, 0x4d, 0x48,
    0x4e, 0x4b, 0x43, 0x45, 0x40, 0x46, 0x46, 0x4f, 0x49, 0x40, 0x4a, 0x43,
    0x41, 0x44, 0x42, 0x47, 0x48, 0x42, 0x45, 0x4c, 0x4b, 0x41, 0x4c, 0x4a,
    0x44, 0x4e, 0x4f, 0x49, 0x4a, 0x43, 0x46, 0x4f, 0x49, 0x40, 0x40, 0x46,
    0x4c, 0x4a, 0x4b, 0x41, 0x47, 0x4d, 0x4d, 0x48, 0x4f, 0x49, 0x41, 0x44,
    0x43, 0x45, 0x4e, 0x4b, 0x45, 0x4c, 0x42, 0x47, 0x48, 0x42, 0x44, 0x4e,
    0xb7, 0xbd, 0xbd, 0xb8, 0xbe, 0xbb, 0xb3, 0xb5, 0xb0, 0xb6, 0xb6, 0xbf,
    0xb9, 0xb0, 0xba, 0xb3, 0xb1, 0xb4, 0xb2, 0xb7, 0xb8, 0xb2, 0xb5, 0xbc,
    0xbb, 0xb1, 0xbc, 0xba, 0xb4, 0xbe, 0xbf, 0xb9, 0xba, 0xb3, 0xb6, 0xbf,
    0xb9, 0xb0, 0xb0, 0xb6, 0xbc, 0xba, 0xbb, 0xb1, 0xb7, 0xbd, 0xbd, 0xb8,
    0xbf, 0xb9, 0xb1, 0xb4, 0xb3, 0xb5, 0xbe, 0xbb, 0xb5, 0xbc, 0xb2, 0xb7,
    0xb8, 0xb2, 0xb4, 0xbe, 0x27, 0x2d, 0x2d, 0x28, 0x2e, 0x2b, 0x23, 0x25,
    0x20, 0x26, 0x26, 0x2f, 0x29, 0x20, 0x2a, 0x23, 0x21, 0x24, 0x22, 0x27,
    0x28, 0x22, 0x25, 0x2c, 0x2b, 0x21, 0x2c, 0x2a, 0x24, 0x2e, 0x2f, 0x29,
    0x2a, 0x23, 0x26, 0x2f, 0x29, 0x20, 0x20, 0x26, 0x2c, 0x2a, 0x2b, 0x21,
    0x27, 0x2d, 0x2d, 0x28, 0x2f, 0x29, 0x21, 0x24, 0x23, 0x25, 0x2e, 0x2b,
    0x25, 0x2c, 0x22, 0x27, 0x28, 0x22, 0x24, 0x2e, 0xf7, 0xfd, 0xfd, 0xf8,
    0xfe, 0xfb, 0xf3, 0xf5, 0xf0, 0xf6, 0xf6, 0xff, 0xf9, 0xf0, 0xfa, 0xf3,
    0xf1, 0xf4, 0xf2, 0xf7, 0xf8, 0xf2, 0xf5, 0xfc, 0xfb, 0xf1, 0xfc, 0xfa,
    0xf4, 0xfe, 0xff, 0xf9, 0xfa, 0xf3, 0xf6, 0xff, 0xf9, 0xf0, 0xf0, 0xf6,
    0xfc, 0xfa, 0xfb, 0xf1, 0xf7, 0xfd, 0xfd, 0xf8, 0xff, 0xf9, 0xf1, 0xf4,
    0xf3, 0xf5, 0xfe, 0xfb, 0xf5, 0xfc, 0xf2, 0xf7, 0xf8, 0xf2, 0xf4, 0xfe,
    0x87, 0x8d, 0x8d, 0x88, 0x8e, 0x8b, 0x83, 0x85, 0x80, 0x86, 0x86, 0x8f,
    0x89, 0x80, 0x8a, 0x83, 0x81, 0x84, 0x82, 0x87, 0x88, 0x82, 0x85, 0x8c,
    0x8b, 0x81, 0x8c, 0x8a, 0x84, 0x8e, 0x8f, 0x89, 0x8a, 0x83, 0x86, 0x8f,
    0x89, 0x80, 0x80, 0x86, 0x8c, 0x8a, 0x8b, 0x81, 0x87, 0x8d, 0x8d, 0x88,
    0x8f, 0x89, 0x81, 0x84, 0x83, 0x85, 0x8e, 0x8b, 0x85, 0x8c, 0x82, 0x87,
    0x88, 0x82, 0x84, 0x8e, 0x17, 0x1d, 0x1d, 0x18, 0x1e, 0x1b, 0x13, 0x15,
    0x10, 0x16, 0x16, 0x1f, 0x19, 0x10, 0x1a, 0x13, 0x11, 0x14, 0x12, 0x17,
    0x18, 0x12, 0x15, 0x1c, 0x1b, 0x11, 0x1c, 0x1a, 0x14, 0x1e, 0x1f, 0x19,
    0x1a, 0x13, 0x16, 0x1f, 0x19, 0x10, 0x10, 0x16, 0x1c, 0x1a, 0x1b, 0x11,
    0x17, 0x1d, 0x1d, 0x18, 0x1f, 0x19, 0x11, 0x14, 0x13, 0x15, 0x1e, 0x1b,
    0x15, 0x1c, 0x12, 0x17, 0x18, 0x12, 0x14, 0x1e, 0xd7, 0xdd, 0xdd, 0xd8,
    0xde, 0xdb, 0xd3, 0xd5, 0xd0, 0xd6, 0xd6, 0xdf, 0xd9, 0xd0, 0xda, 0xd3,
    0xd1, 0xd4, 0xd2, 0xd7, 0xd8, 0xd2, 0xd5, 0xdc, 0xdb, 0xd1, 0xdc, 0xda,
    0xd4, 0xde, 0xdf, 0xd9, 0xda, 0xd3, 0xd6, 0xdf, 0xd9, 0xd0, 0xd0, 0xd6,
    0xdc, 0xda, 0xdb, 0xd1, 0xd7, 0xdd, 0xdd, 0xd8, 0xdf, 0xd9, 0xd1, 0xd4,
    0xd3, 0xd5, 0xde, 0xdb, 0xd5, 0xdc, 0xd2, 0xd7, 0xd8, 0xd2, 0xd4, 0xde,
    0x17, 0x1d, 0x1d, 0x18, 0x1e, 0x1b, 0x13, 0x15, 0x10, 0x16, 0x16, 0x1f,
    0x19, 0x10, 0x1a, 0x13, 0x11, 0x14, 0x12, 0x17, 0x18, 0x12, 0x15, 0x1c,
    0x1b, 0x11, 0x1c, 0x1a, 0x14, 0x1e, 0x1f, 0x19, 0x1a, 0x13, 0x16, 0x1f,
    0x19, 0x10, 0x10, 0x16, 0x1c, 0x1a, 0x1b, 0x11, 0x17, 0x1d, 0x1d, 0x18,
    0x1f, 0x19, 0x11, 0x14, 0x13, 0x15, 0x1e, 0x1b, 0x15, 0x1c, 0x12, 0x17,
    0x18, 0x12, 0x14, 0x1e, 0x67, 0x6d, 0x6d, 0x68, 0x6e, 0x6b, 0x63, 0x65,
    0x60, 0x66, 0x66, 0x6f, 0x69, 0x60, 0x6a, 0x63, 0x61, 0x64, 0x62, 0x67,
    0x68, 0x62, 0x65, 0x6c, 0x6b, 0x61, 0x6c, 0x6a, 0x64, 0x6e, 0x6f, 0x69,
    0x6a, 0x63, 0x66, 0x6f, 0x69, 0x60, 0x60, 0x66, 0x6c, 0x6a, 0x6b, 0x61,
    0x67, 0x6d, 0x6d, 0x68, 0x6f, 0x69, 0x61, 0x64, 0x63, 0x65, 0x6e, 0x6b,
    0x65, 0x6c, 0x62, 0x67, 0x68, 0x62, 0x64, 0x6e, 0xa7, 0xad, 0xad, 0xa8,
    0xae, 0xab, 0xa3, 0xa5, 0xa0, 0xa6, 0xa6, 0xaf, 0xa9, 0xa0, 0xaa, 0xa3,
    0xa1, 0xa4, 0xa2, 0xa7, 0xa8, 0xa2, 0xa5, 0xac, 0xab, 0xa1, 0xac, 0xaa,
    0xa4, 0xae, 0xaf, 0xa9, 0xaa, 0xa3, 0xa6, 0xaf, 0xa9, 0xa0, 0xa0, 0xa6,
    0xac, 0xaa, 0xab, 0xa1, 0xa7, 0xad, 0xad, 0xa8, 0xaf, 0xa9, 0xa1, 0xa4,
    0xa3, 0xa5, 0xae, 0xab, 0xa5, 0xac, 0xa2, 0xa7, 0xa8, 0xa2, 0xa4, 0xae,
    0x47, 0x4d, 0x4d, 0x48, 0x4e, 0x4b, 0x43, 0x45, 0x40, 0x46, 0x46, 0x4f,
    0x49, 0x40, 0x4a, 0x43, 0x41, 0x44, 0x42, 0x47, 0x48, 0x42, 0x45, 0x4c,
    0x4b, 0x41, 0x4c, 0x4a, 0x44, 0x4e, 0x4f, 0x49, 0x4a, 0x43, 0x46, 0x4f,
    0x49, 0x40, 0x40, 0x46, 0x4c, 0x4a, 0x4b, 0x41, 0x47, 0x4d, 0x4d, 0x48,
    0x4f, 0x49, 0x41, 0x44, 0x43, 0x45, 0x4e, 0x4b, 0x45, 0x4c, 0x42, 0x47,
    0x48, 0x42, 0x44, 0x4e, 0xd7, 0xdd, 0xdd, 0xd8, 0xde, 0xdb, 0xd3, 0xd5,
    0xd0, 0xd6, 0xd6, 0xdf, 0xd9, 0xd0, 0xda, 0xd3, 0xd1, 0xd4, 0xd2, 0xd7,
    0xd8, 0xd2, 0xd5, 0xdc, 0xdb, 0xd1, 0xdc, 0xda, 0xd4, 0xde, 0xdf, 0xd9,
    0xda, 0xd3, 0xd6, 0xdf, 0xd9, 0xd0, 0xd0, 0xd6, 0xdc, 0xda, 0xdb, 0xd1,
    0xd7, 0xdd, 0xdd, 0xd8, 0xdf, 0xd9, 0xd1, 0xd4, 0xd3, 0xd5, 0xde, 0xdb,
    0xd5, 0xdc, 0xd2, 0xd7, 0xd8, 0xd2, 0xd4, 0xde, 0x97, 0x9d, 0x9d, 0x98,
    0x9e, 0x9b, 0x93, 0x95, 0x90, 0x96, 0x96, 0x9f, 0x99, 0x90, 0x9a, 0x93,
    0x91, 0x94, 0x92, 0x97, 0x98, 0x92, 0x95, 0x9c, 0x9b, 0x91, 0x9c, 0x9a,
    0x94, 0x9e, 0x9f, 0x99, 0x9a, 0x93, 0x96, 0x9f, 0x99, 0x90, 0x90, 0x96,
    0x9c, 0x9a, 0x9b, 0x91, 0x97, 0x9d, 0x9d, 0x98, 0x9f, 0x99, 0x91, 0x94,
    0x93, 0x95, 0x9e, 0x9b, 0x95, 0x9c, 0x92, 0x97, 0x98, 0x92, 0x94, 0x9e,
    0x07, 0x0d, 0x0d, 0x08, 0x0e, 0x0b, 0x03, 0x05, 0x00, 0x06, 0x06, 0x0f,
    0x09, 0x00, 0x0a, 0x03, 0x01, 0x04, 0x02, 0x07, 0x08, 0x02, 0x05, 0x0c,
    0x0b, 0x01, 0x0c, 0x0a, 0x04, 0x0e, 0x0f, 0x09, 0x0a, 0x03, 0x06, 0x0f,
    0x09, 0x00, 0x00, 0x06, 0x0c, 0x0a, 0x0b, 0x01, 0x07, 0x0d, 0x0d, 0x08,
    0x0f, 0x09, 0x01, 0x04, 0x03, 0x05, 0x0e, 0x0b, 0x05, 0x0c, 0x02, 0x07,
    0x08, 0x02, 0x04, 0x0e, 0x87, 0x8d, 0x8d, 0x88, 0x8e, 0x8b, 0x83, 0x85,
    0x80, 0x86, 0x86, 0x8f, 0x89, 0x80, 0x8a, 0x83, 0x81, 0x84, 0x82, 0x87,
    0x88, 0x82, 0x85, 0x8c, 0x8b, 0x81, 0x8c, 0x8a, 0x84, 0x8e, 0x8f, 0x89,
    0x8a, 0x83, 0x86, 0x8f, 0x89, 0x80, 0x80, 0x86, 0x8c, 0x8a, 0x8b, 0x81,
    0x87, 0x8d, 0x8d, 0x88, 0x8f, 0x89, 0x81, 0x84, 0x83, 0x85, 0x8e, 0x8b,
    0x85, 0x8c, 0x82, 0x87, 0x88, 0x82, 0x84, 0x8e, 0x67, 0x6d, 0x6d, 0x68,
    0x6e, 0x6b, 0x63, 0x65, 0x60, 0x66, 0x66, 0x6f, 0x69, 0x60, 0x6a, 0x63,
    0x61, 0x64, 0x62, 0x67, 0x68, 0x62, 0x65, 0x6c, 0x6b, 0x61, 0x6c, 0x6a,
    0x64, 0x6e, 0x6f, 0x69, 0x6a, 0x63, 0x66, 0x6f, 0x69, 0x60, 0x60, 0x66,
    0x6c, 0x6a, 0x6b, 0x61, 0x67, 0x6d, 0x6d, 0x68, 0x6f, 0x69, 0x61, 0x64,
    0x63, 0x65, 0x6e, 0x6b, 0x65, 0x6c, 0x62, 0x67, 0x68, 0x62, 0x64, 0x6e,
    0xf7, 0xfd, 0xfd, 0xf8, 0xfe, 0xfb, 0xf3, 0xf5, 0xf0, 0xf6, 0xf6, 0xff,
    0xf9, 0xf0, 0xfa, 0xf3, 0xf1, 0xf4, 0xf2, 0xf7, 0xf8, 0xf2, 0xf5, 0xfc,
    0xfb, 0xf1, 0xfc, 0xfa, 0xf4, 0xfe, 0xff, 0xf9, 0xfa, 0xf3, 0xf6, 0xff,
    0xf9, 0xf0, 0xf0, 0xf6, 0xfc, 0xfa, 0xfb, 0xf1, 0xf7, 0xfd, 0xfd, 0xf8,
    0xff, 0xf9, 0xf1, 0xf4, 0xf3, 0xf5, 0xfe, 0xfb, 0xf5, 0xfc, 0xf2, 0xf7,
    0xf8, 0xf2, 0xf4, 0xfe, 0x97, 0x9d, 0x9d, 0x98, 0x9e, 0x9b, 0x93, 0x95,
    0x90, 0x96, 0x96, 0x9f, 0x99, 0x90, 0x9a, 0x93, 0x91, 0x94, 0x92, 0x97,
    0x98, 0x92, 0x95, 0x9c, 0x9b, 0x91, 0x9c, 0x9a, 0x94, 0x9e, 0x9f, 0x99,
    0x9a, 0x93, 0x96, 0x9f, 0x99, 0x90, 0x90, 0x96, 0x9c, 0x9a, 0x9b, 0x91,
    0x97, 0x9d, 0x9d, 0x98, 0x9f, 0x99, 0x91, 0x94, 0x93, 0x95, 0x9e, 0x9b,
    0x95, 0x9c, 0x92, 0x97, 0x98, 0x92, 0x94, 0x9e, 0x37, 0x3d, 0x3d, 0x38,
    0x3e, 0x3b, 0x33, 0x35, 0x30, 0x36, 0x36, 0x3f, 0x39, 0x30, 0x3a, 0x33,
    0x31, 0x34, 0x32, 0x37, 0x38, 0x32, 0x35, 0x3c, 0x3b, 0x31, 0x3c, 0x3a,
    0x34, 0x3e, 0x3f, 0x39, 0x3a, 0x33, 0x36, 0x3f, 0x39, 0x30, 0x30, 0x36,
    0x3c, 0x3a, 0x3b, 0x31, 0x37, 0x3d, 0x3d, 0x38, 0x3f, 0x39, 0x31, 0x34,
    0x33, 0x35, 0x3e, 0x3b, 0x35, 0x3c, 0x32, 0x37, 0x38, 0x32, 0x34, 0x3e,
    0x87, 0x8d, 0x8d, 0x88, 0x8e, 0x8b, 0x83, 0x85, 0x80, 0x86, 0x86, 0x8f,
    0x89, 0x80, 0x8a, 0x83, 0x81, 0x84, 0x82, 0x87, 0x88, 0x82, 0x85, 0x8c,
    0x8b, 0x81, 0x8c, 0x8a, 0x84, 0x8e, 0x8f, 0x89, 0x8a, 0x83, 0x86, 0x8f,
    0x89, 0x80, 0x80, 0x86, 0x8c, 0x8a, 0x8b, 0x81, 0x87, 0x8d, 0x8d, 0x88,
    0x8f, 0x89, 0x81, 0x84, 0x83, 0x85, 0x8e, 0x8b, 0x85, 0x8c, 0x82, 0x87,
    0x88, 0x82, 0x84, 0x8e, 0x07, 0x0d, 0x0d, 0x08, 0x0e, 0x0b, 0x03, 0x05,
    0x00, 0x06, 0x06, 0x0f, 0x09, 0x00, 0x0a, 0x03, 0x01, 0x04, 0x02, 0x07,
    0x08, 0x02, 0x05, 0x0c, 0x0b, 0x01, 0x0c, 0x0a, 0x04, 0x0e, 0x0f, 0x09,
    0x0a, 0x03, 0x06, 0x0f, 0x09, 0x00, 0x00, 0x06, 0x0c, 0x0a, 0x0b, 0x01,
    0x07, 0x0d, 0x0d, 0x08, 0x0f, 0x09, 0x01, 0x04, 0x03, 0x05, 0x0e, 0x0b,
    0x05, 0x0c, 0x02, 0x07, 0x08, 0x02, 0x04, 0x0e, 0x77, 0x7d, 0x7d, 0x78,
    0x7e, 0x7b, 0x73, 0x75, 0x70, 0x76, 0x76, 0x7f, 0x79, 0x70, 0x7a, 0x73,
    0x71, 0x74, 0x72, 0x77, 0x78, 0x72, 0x75, 0x7c, 0x7b, 0x71, 0x7c, 0x7a,
    0x74, 0x7e, 0x7f, 0x79, 0x7a, 0x73, 0x76, 0x7f, 0x79, 0x70, 0x70, 0x76,
    0x7c, 0x7a, 0x7b, 0x71, 0x77, 0x7d, 0x7d, 0x78, 0x7f, 0x79, 0x71, 0x74,
    0x73, 0x75, 0x7e, 0x7b, 0x75, 0x7c, 0x72, 0x77, 0x78, 0x72, 0x74, 0x7e,
    0xb7, 0xbd, 0xbd, 0xb8, 0xbe, 0xbb, 0xb3, 0xb5, 0xb0, 0xb6, 0xb6, 0xbf,
    0xb9, 0xb0, 0xba, 0xb3, 0xb1, 0xb4, 0xb2, 0xb7, 0xb8, 0xb2, 0xb5, 0xbc,
    0xbb, 0xb1, 0xbc, 0xba, 0xb4, 0xbe, 0xbf, 0xb9, 0xba, 0xb3, 0xb6, 0xbf,
    0xb9, 0xb0, 0xb0, 0xb6, 0xbc, 0xba, 0xbb, 0xb1, 0xb7, 0xbd, 0xbd, 0xb8,
    0xbf, 0xb9, 0xb1, 0xb4, 0xb3, 0xb5, 0xbe, 0xbb, 0xb5, 0xbc, 0xb2, 0xb7,
    0xb8, 0xb2, 0xb4, 0xbe, 0x47, 0x4d, 0x4d, 0x48, 0x4e, 0x4b, 0x43, 0x45,
    0x40, 0x46, 0x46, 0x4f, 0x49, 0x40, 0x4a, 0x43, 0x41, 0x44, 0x42, 0x47,
    0x48, 0x42, 0x45, 0x4c, 0x4b, 0x41, 0x4c, 0x4a, 0x44, 0x4e, 0x4f, 0x49,
    0x4a, 0x43, 0x46, 0x4f, 0x49, 0x40, 0x40, 0x46, 0x4c, 0x4a, 0x4b, 0x41,
    0x47, 0x4d, 0x4d, 0x48, 0x4f, 0x49, 0x41, 0x44, 0x43, 0x45, 0x4e, 0x4b,
    0x45, 0x4c, 0x42, 0x47, 0x48, 0x42, 0x44, 0x4e, 0x17, 0x1d, 0x1d, 0x18,
    0x1e, 0x1b, 0x13, 0x15, 0x10, 0x16, 0x16, 0x1f, 0x19, 0x10, 0x1a, 0x13,
    0x11, 0x14, 0x12, 0x17, 0x18, 0x12, 0x15, 0x1c, 0x1b, 0x11, 0x1c, 0x1a,
    0x14, 0x1e, 0x1f, 0x19, 0x1a, 0x13, 0x16, 0x1f, 0x19, 0x10, 0x10, 0x16,
    0x1c, 0x1a, 0x1b, 0x11, 0x17, 0x1d, 0x1d, 0x18, 0x1f, 0x19, 0x11, 0x14,
    0x13, 0x15, 0x1e, 0x1b, 0x15, 0x1c, 0x12, 0x17, 0x18, 0x12, 0x14, 0x1e,
    0xf7, 0xfd, 0xfd, 0xf8, 0xfe, 0xfb, 0xf3, 0xf5, 0xf0, 0xf6, 0xf6, 0xff,
    0xf9, 0xf0, 0xfa, 0xf3, 0xf1, 0xf4, 0xf2, 0xf7, 0xf8, 0xf2, 0xf5, 0xfc,
    0xfb, 0xf1, 0xfc, 0xfa, 0xf4, 0xfe, 0xff, 0xf9, 0xfa, 0xf3, 0xf6, 0xff,
    0xf9, 0xf0, 0xf0, 0xf6, 0xfc, 0xfa, 0xfb, 0xf1, 0xf7, 0xfd, 0xfd, 0xf8,
    0xff, 0xf9, 0xf1, 0xf4, 0xf3, 0xf5, 0xfe, 0xfb, 0xf5, 0xfc, 0xf2, 0xf7,
    0xf8, 0xf2, 0xf4, 0xfe, 0x27, 0x2d, 0x2d, 0x28, 0x2e, 0x2b, 0x23, 0x25,
    0x20, 0x26, 0x26, 0x2f, 0x29, 0x20, 0x2a, 0x23, 0x21, 0x24, 0x22, 0x27,
    0x28, 0x22, 0x25, 0x2c, 0x2b, 0x21, 0x2c, 0x2a, 0x24, 0x2e, 0x2f, 0x29,
    0x2a, 0x23, 0x26, 0x2f, 0x29, 0x20, 0x20, 0x26, 0x2c, 0x2a, 0x2b, 0x21,
    0x27, 0x2d, 0x2d, 0x28, 0x2f, 0x29, 0x21, 0x24, 0x23, 0x25, 0x2e, 0x2b,
    0x25, 0x2c, 0x22, 0x27, 0x28, 0x22, 0x24, 0x2e, 0xe7, 0xed, 0xed, 0xe8,
    0xee, 0xeb, 0xe3, 0xe5, 0xe0, 0xe6, 0xe6, 0xef, 0xe9, 0xe0, 0xea, 0xe3,
    0xe1, 0xe4, 0xe2, 0xe7, 0xe8, 0xe2, 0xe5, 0xec, 0xeb, 0xe1, 0xec, 0xea,
    0xe4, 0xee, 0xef, 0xe9, 0xea, 0xe3, 0xe6, 0xef, 0xe9, 0xe0, 0xe0, 0xe6,
    0xec, 0xea, 0xeb, 0xe1, 0xe7, 0xed, 0xed, 0xe8, 0xef, 0xe9, 0xe1, 0xe4,
    0xe3, 0xe5, 0xee, 0xeb, 0xe5, 0xec, 0xe2, 0xe7, 0xe8, 0xe2, 0xe4, 0xee,
    0xc7, 0xcd, 0xcd, 0xc8, 0xce, 0xcb, 0xc3, 0xc5, 0xc0, 0xc6, 0xc6, 0xcf,
    0xc9, 0xc0, 0xca, 0xc3, 0xc1, 0xc4, 0xc2, 0xc7, 0xc8, 0xc2, 0xc5, 0xcc,
    0xcb, 0xc1, 0xcc, 0xca, 0xc4, 0xce, 0xcf, 0xc9, 0xca, 0xc3, 0xc6, 0xcf,
    0xc9, 0xc0, 0xc0, 0xc6, 0xcc, 0xca, 0xcb, 0xc1, 0xc7, 0xcd, 0xcd, 0xc8,
    0xcf, 0xc9, 0xc1, 0xc4, 0xc3, 0xc5, 0xce, 0xcb, 0xc5, 0xcc, 0xc2, 0xc7,
    0xc8, 0xc2, 0xc4, 0xce, 0x37, 0x3d, 0x3d, 0x38, 0x3e, 0x3b, 0x33, 0x35,
    0x30, 0x36, 0x36, 0x3f, 0x39, 0x30, 0x3a, 0x33, 0x31, 0x34, 0x32, 0x37,
    0x38, 0x32, 0x35, 0x3c, 0x3b, 0x31, 0x3c, 0x3a, 0x34, 0x3e, 0x3f, 0x39,
    0x3a, 0x33, 0x36, 0x3f, 0x39, 0x30, 0x30, 0x36, 0x3c, 0x3a, 0x3b, 0x31,
    0x37, 0x3d, 0x3d, 0x38, 0x3f, 0x39, 0x31, 0x34, 0x33, 0x35, 0x3e, 0x3b,
    0x35, 0x3c, 0x32, 0x37, 0x38, 0x32, 0x34, 0x3e, 0x57, 0x5d, 0x5d, 0x58,
    0x5e, 0x5b, 0x53, 0x55, 0x50, 0x56, 0x56, 0x5f, 0x59, 0x50, 0x5a, 0x53,
    0x51, 0x54, 0x52, 0x57, 0x58, 0x52, 0x55, 0x5c, 0x5b, 0x51, 0x5c, 0x5a,
    0x54, 0x5e, 0x5f, 0x59, 0x5a, 0x53, 0x56, 0x5f, 0x59, 0x50, 0x50, 0x56,
    0x5c, 0x5a, 0x5b, 0x51, 0x57, 0x5d, 0x5d, 0x58, 0x5f, 0x59, 0x51, 0x54,
    0x53, 0x55, 0x5e, 0x5b, 0x55, 0x5c, 0x52, 0x57, 0x58, 0x52, 0x54, 0x5e,
    0xb7, 0xbd, 0xbd, 0xb8, 0xbe, 0xbb, 0xb3, 0xb5, 0xb0, 0xb6, 0xb6, 0xbf,
    0xb9, 0xb0, 0xba, 0xb3, 0xb1, 0xb4, 0xb2, 0xb7, 0xb8, 0xb2, 0xb5, 0xbc,
    0xbb, 0xb1, 0xbc, 0xba, 0xb4, 0xbe, 0xbf, 0xb9, 0xba, 0xb3, 0xb6, 0xbf,
    0xb9, 0xb0, 0xb0, 0xb6, 0xbc, 0xba, 0xbb, 0xb1, 0xb7, 0xbd, 0xbd, 0xb8,
    0xbf, 0xb9, 0xb1, 0xb4, 0xb3, 0xb5, 0xbe, 0xbb, 0xb5, 0xbc, 0xb2, 0xb7,
    0xb8, 0xb2, 0xb4, 0xbe, 0xa7, 0xad, 0xad, 0xa8, 0xae, 0xab, 0xa3, 0xa5,
    0xa0, 0xa6, 0xa6, 0xaf, 0xa9, 0xa0, 0xaa, 0xa3, 0xa1, 0xa4, 0xa2, 0xa7,
    0xa8, 0xa2, 0xa5, 0xac, 0xab, 0xa1, 0xac, 0xaa, 0xa4, 0xae, 0xaf, 0xa9,
    0xaa, 0xa3, 0xa6, 0xaf, 0xa9, 0xa0, 0xa0, 0xa6, 0xac, 0xaa, 0xab, 0xa1,
    0xa7, 0xad, 0xad, 0xa8, 0xaf, 0xa9, 0xa1, 0xa4, 0xa3, 0xa5, 0xae, 0xab,
    0xa5, 0xac, 0xa2, 0xa7, 0xa8, 0xa2, 0xa4, 0xae, 0x57, 0x5d, 0x5d, 0x58,
    0x5e, 0x5b, 0x53, 0x55, 0x50, 0x56, 0x56, 0x5f, 0x59, 0x50, 0x5a, 0x53,
    0x51, 0x54, 0x52, 0x57, 0x58, 0x52, 0x55, 0x5c, 0x5b, 0x51, 0x5c, 0x5a,
    0x54, 0x5e, 0x5f, 0x59, 0x5a, 0x53, 0x56, 0x5f, 0x59, 0x50, 0x50, 0x56,
    0x5c, 0x5a, 0x5b, 0x51, 0x57, 0x5d, 0x5d, 0x58, 0x5f, 0x59, 0x51, 0x54,
    0x53, 0x55, 0x5e, 0x5b, 0x55, 0x5c, 0x52, 0x57, 0x58, 0x52, 0x54, 0x5e,
    0xe7, 0xed, 0xed, 0xe8, 0xee, 0xeb, 0xe3, 0xe5, 0xe0, 0xe6, 0xe6, 0xef,
    0xe9, 0xe0, 0xea, 0xe3, 0xe1, 0xe4, 0xe2, 0xe7, 0xe8, 0xe2, 0xe5, 0xec,
    0xeb, 0xe1, 0xec, 0xea, 0xe4, 0xee, 0xef, 0xe9, 0xea, 0xe3, 0xe6, 0xef,
    0xe9, 0xe0, 0xe0, 0xe6, 0xec, 0xea, 0xeb, 0xe1, 0xe7, 0xed, 0xed, 0xe8,
    0xef, 0xe9, 0xe1, 0xe4, 0xe3, 0xe5, 0xee, 0xeb, 0xe5, 0xec, 0xe2, 0xe7,
    0xe8, 0xe2, 0xe4, 0xee, 0x27, 0x2d, 0x2d, 0x28, 0x2e, 0x2b, 0x23, 0x25,
    0x20, 0x26, 0x26, 0x2f, 0x29, 0x20, 0x2a, 0x23, 0x21, 0x24, 0x22, 0x27,
    0x28, 0x22, 0x25, 0x2c, 0x2b, 0x21, 0x2c, 0x2a, 0x24, 0x2e, 0x2f, 0x29,
    0x2a, 0x23, 0x26, 0x2f, 0x29, 0x20, 0x20, 0x26, 0x2c, 0x2a, 0x2b, 0x21,
    0x27, 0x2d, 0x2d, 0x28, 0x2f, 0x29, 0x21, 0x24, 0x23, 0x25, 0x2e, 0x2b,
    0x25, 0x2c, 0x22, 0x27, 0x28, 0x22, 0x24, 0x2e, 0x77, 0x7d, 0x7d, 0x78,
    0x7e, 0x7b, 0x73, 0x75, 0x70, 0x76, 0x76, 0x7f, 0x79, 0x70, 0x7a, 0x73,
    0x71, 0x74, 0x72, 0x77, 0x78, 0x72, 0x75, 0x7c, 0x7b, 0x71, 0x7c, 0x7a,
    0x74, 0x7e, 0x7f, 0x79, 0x7a, 0x73, 0x76, 0x7f, 0x79, 0x70, 0x70, 0x76,
    0x7c, 0x7a, 0x7b, 0x71, 0x77, 0x7d, 0x7d, 0x78, 0x7f, 0x79, 0x71, 0x74,
    0x73, 0x75, 0x7e, 0x7b, 0x75, 0x7c, 0x72, 0x77, 0x78, 0x72, 0x74, 0x7e,
    0xc7, 0xcd, 0xcd, 0xc8, 0xce, 0xcb, 0xc3, 0xc5, 0xc0, 0xc6, 0xc6, 0xcf,
    0xc9, 0xc0, 0xca, 0xc3, 0xc1, 0xc4, 0xc2, 0xc7, 0xc8, 0xc2, 0xc5, 0xcc,
    0xcb, 0xc1, 0xcc, 0xca, 0xc4, 0xce, 0xcf, 0xc9, 0xca, 0xc3, 0xc6, 0xcf,
    0xc9, 0xc0, 0xc0, 0xc6, 0xcc, 0xca, 0xcb, 0xc1, 0xc7, 0xcd, 0xcd, 0xc8,
    0xcf, 0xc9, 0xc1, 0xc4, 0xc3, 0xc5, 0xce, 0xcb, 0xc5, 0xcc, 0xc2, 0xc7,
    0xc8, 0xc2, 0xc4, 0xce,
  },
  {
    0x2c, 0x2a, 0x21, 0x2f, 0x2a, 0x24, 0x2f, 0x22, 0x29, 0x27, 0x22, 0x2c,
    0x26, 0x29, 0x28, 0x25, 0x20, 0x26, 0x2d, 0x21, 0x23, 0x2d, 0x24, 0x2e,
    0x2e, 0x20, 0x27, 0x2b, 0x25, 0x23, 0x2b, 0x28, 0x29, 0x24, 0x2e, 0x23,
    0x2f, 0x22, 0x25, 0x2c, 0x22, 0x29, 0x28, 0x25, 0x2c, 0x2f, 0x23, 0x2a,
    0x27, 0x2b, 0x20, 0x2e, 0x24, 0x21, 0x2a, 0x27, 0x21, 0x26, 0x2d, 0x20,
    0x2b, 0x28, 0x26, 0x2d, 0xec, 0xea, 0xe1, 0xef, 0xea, 0xe4, 0xef, 0xe2,
    0xe9, 0xe7, 0xe2, 0xec, 0xe6, 0xe9, 0xe8, 0xe5, 0xe0, 0xe6, 0xed, 0xe1,
    0xe3, 0xed, 0xe4, 0xee, 0xee, 0xe0, 0xe7, 0xeb, 0xe5, 0xe3, 0xeb, 0xe8,
    0xe9, 0xe4, 0xee, 0xe3, 0xef, 0xe2, 0xe5, 0xec, 0xe2, 0xe9, 0xe8, 0xe5,
    0xec, 0xef, 0xe3, 0xea, 0xe7, 0xeb, 0xe0, 0xee, 0xe4, 0xe1, 0xea, 0xe7,
    0xe1, 0xe6, 0xed, 0xe0, 0xeb, 0xe8, 0xe6, 0xed, 0xcc, 0xca, 0xc1, 0xcf,
    0xca, 0xc4, 0xcf, 0xc2, 0xc9, 0xc7, 0xc2, 0xcc, 0xc6, 0xc9, 0xc8, 0xc5,
    0xc0, 0xc6, 0xcd, 0xc1, 0xc3, 0xcd, 0xc4, 0xce, 0xce, 0xc0, 0xc7, 0xcb,
    0xc5, 0xc3, 0xcb, 0xc8, 0xc9, 0xc4, 0xce, 0xc3, 0xcf, 0xc2, 0xc5, 0xcc,
    0xc2, 0xc9, 0xc8, 0xc5, 0xcc, 0xcf, 0xc3, 0xca, 0xc7, 0xcb, 0xc0, 0xce,
    0xc4, 0xc1, 0xca, 0xc7, 0xc1, 0xc6, 0xcd, 0xc0, 0xcb, 0xc8, 0xc6, 0xcd,
    0xbc, 0xba, 0xb1, 0xbf, 0xba, 0xb4, 0xbf, 0xb2, 0xb9, 0xb7, 0xb2, 0xbc,
    0xb6, 0xb9, 0xb8, 0xb5, 0xb0, 0xb6, 0xbd, 0xb1, 0xb3, 0xbd, 0xb4, 0xbe,
    0xbe, 0xb0, 0xb7, 0xbb, 0xb5, 0xb3, 0xbb, 0xb8, 0xb9, 0xb4, 0xbe, 0xb3,
    0xbf, 0xb2, 0xb5, 0xbc, 0xb2, 0xb9, 0xb8, 0xb5, 0xbc, 0xbf, 0xb3, 0xba,
    0xb7, 0xbb, 0xb0, 0xbe, 0xb4, 0xb1, 0xba, 0xb7, 0xb1, 0xb6, 0xbd, 0xb0,
    0xbb, 0xb8, 0xb6, 0xbd, 0x4c, 0x4a, 0x41, 0x4f, 0x4a, 0x44, 0x4f, 0x42,
    0x49, 0x47, 0x42, 0x4c, 0x46, 0x49, 0x48, 0x45, 0x40, 0x46, 0x4d, 0x41,
    0x43, 0x4d, 0x44, 0x4e, 0x4e, 0x40, 0x47, 0x4b, 0x45, 0x43, 0x4b, 0x48,
    0x49, 0x44, 0x4e, 0x43, 0x4f, 0x42, 0x45, 0x4c, 0x42, 0x49, 0x48, 0x45,
    0x4c, 0x4f, 0x43, 0x4a, 0x47, 0x4b, 0x40, 0x4e, 0x44, 0x41, 0x4a, 0x47,
    0x41, 0x46, 0x4d, 0x40, 0x4b, 0x48, 0x46, 0x4d, 0x2c, 0x2a, 0x21, 0x2f,
    0x2a, 0x24, 0x2f, 0x22, 0x29, 0x27, 0x22, 0x2c, 0x26, 0x29, 0x28, 0x25,
    0x20, 0x26, 0x2d, 0x21, 0x23, 0x2d, 0x24, 0x2e, 0x2e, 0x20, 0x27, 0x2b,
    0x25, 0x23, 0x2b, 0x28, 0x29, 0x24, 0x2e, 0x23, 0x2f, 0x22, 0x25, 0x2c,
    0x22, 0x29, 0x28, 0x25, 0x2c, 0x2f, 0x23, 0x2a, 0x27, 0x2b, 0x20, 0x2e,
    0x24, 0x21, 0x2a, 0x27, 0x21, 0x26, 0x2d, 0x20, 0x2b, 0x28, 0x26, 0x2d,
    0x1c, 0x1a, 0x11, 0x1f, 0x1a, 0x14, 0x1f, 0x12, 0x19, 0x17, 0x12, 0x1c,
    0x16, 0x19, 0x18, 0x15, 0x10, 0x16, 0x1d, 0x11, 0x13, 0x1d, 0x14, 0x1e,
    0x1e, 0x10, 0x17, 0x1b, 0x15, 0x13, 0x1b, 0x18, 0x19, 0x14, 0x1e, 0x13,
    0x1f, 0x12, 0x15, 0x1c, 0x12, 0x19, 0x18, 0x15, 0x1c, 0x1f, 0x13, 0x1a,
    0x17, 0x1b, 0x10, 0x1e, 0x14, 0x11, 0x1a, 0x17, 0x11, 0x16, 0x1d, 0x10,
    0x1b, 0x18, 0x16, 0x1d, 0xcc, 0xca, 0xc1, 0xcf, 0xca, 0xc4, 0xcf, 0xc2,
    0xc9, 0xc7, 0xc2, 0xcc, 0xc6, 0xc9, 0xc8, 0xc5, 0xc0, 0xc6, 0xcd, 0xc1,
    0xc3, 0xcd, 0xc4, 0xce, 0xce, 0xc0, 0xc7, 0xcb, 0xc5, 0xc3, 0xcb, 0xc8,
    0xc9, 0xc4, 0xce, 0xc3, 0xcf, 0xc2, 0xc5, 0xcc, 0xc2, 0xc9, 0xc8, 0xc5,
    0xcc, 0xcf, 0xc3, 0xca, 0xc7, 0xcb, 0xc0, 0xce, 0xc4, 0xc1, 0xca, 0xc7,
    0xc1, 0xc6, 0xcd, 0xc0, 0xcb, 0xc8, 0xc6, 0xcd, 0x7c, 0x7a, 0x71, 0x7f,
    0x7a, 0x74, 0x7f, 0x72, 0x79, 0x77, 0x72, 0x7c, 0x76, 0x79, 0x78, 0x75,
    0x70, 0x76, 0x7d, 0x71, 0x73, 0x7d, 0x74, 0x7e, 0x7e, 0x70, 0x77, 0x7b,
    0x75, 0x73, 0x7b, 0x78, 0x79, 0x74, 0x7e, 0x73, 0x7f, 0x72, 0x75, 0x7c,
    0x72, 0x79, 0x78, 0x75, 0x7c, 0x7f, 0x73, 0x7a, 0x77, 0x7b, 0x70, 0x7e,
    0x74, 0x71, 0x7a, 0x77, 0x71, 0x76, 0x7d, 0x70, 0x7b, 0x78, 0x76, 0x7d,
    0x4c, 0x4a, 0x41, 0x4f, 0x4a, 0x44, 0x4f, 0x42, 0x49, 0x47, 0x42, 0x4c,
    0x46, 0x49, 0x48, 0x45, 0x40, 0x46, 0x4d, 0x41, 0x43, 0x4d, 0x44, 0x4e,
    0x4e, 0x40, 0x47, 0x4b, 0x45, 0x43, 0x4b, 0x48, 0x49, 0x44, 0x4e, 0x43,
    0x4f, 0x42, 0x45, 0x4c, 0x42, 0x49, 0x48, 0x45, 0x4c, 0x4f, 0x43, 0x4a,
    0x47, 0x4b, 0x40, 0x4e, 0x44, 0x41, 0x4a, 0x47, 0x41, 0x46, 0x4d, 0x40,
    0x4b, 0x48, 0x46, 0x4d, 0xac, 0xaa, 0xa1, 0xaf, 0xaa, 0xa4, 0xaf, 0xa2,
    0xa9, 0xa7, 0xa2, 0xac, 0xa6, 0xa9, 0xa8, 0xa5, 0xa0, 0xa6, 0xad, 0xa1,
    0xa3, 0xad, 0xa4, 0xae, 0xae, 0xa0, 0xa7, 0xab, 0xa5, 0xa3, 0xab, 0xa8,
    0xa9, 0xa4, 0xae, 0xa3, 0xaf, 0xa2, 0xa5, 0xac, 0xa2, 0xa9, 0xa8, 0xa5,
    0xac, 0xaf, 0xa3, 0xaa, 0xa7, 0xab, 0xa0, 0xae, 0xa4, 0xa1, 0xaa, 0xa7,
    0xa1, 0xa6, 0xad, 0xa0, 0xab, 0xa8, 0xa6, 0xad, 0x7c, 0x7a, 0x71, 0x7f,
    0x7a, 0x74, 0x7f, 0x72, 0x79, 0x77, 0x72, 0x7c, 0x76, 0x79, 0x78, 0x75,
    0x70, 0x76, 0x7d, 0x71, 0x73, 0x7d, 0x74, 0x7e, 0x7e, 0x70, 0x77, 0x7b,
    0x75, 0x73, 0x7b, 0x78, 0x79, 0x74, 0x7e, 0x73, 0x7f, 0x72, 0x75, 0x7c,
    0x72, 0x79, 0x78, 0x75, 0x7c, 0x7f, 0x73, 0x7a, 0x77, 0x7b, 0x70, 0x7e,
    0x74, 0x71, 0x7a, 0x77, 0x71, 0x76, 0x7d, 0x70, 0x7b, 0x78, 0x76, 0x7d,
    0xbc, 0xba, 0xb1, 0xbf, 0xba, 0xb4, 0xbf, 0xb2, 0xb9, 0xb7, 0xb2, 0xbc,
    0xb6, 0xb9, 0xb8, 0xb5, 0xb0, 0xb6, 0xbd, 0xb1, 0xb3, 0xbd, 0xb4, 0xbe,
    0xbe, 0xb0, 0xb7, 0xbb, 0xb5, 0xb3, 0xbb, 0xb8, 0xb9, 0xb4, 0xbe, 0xb3,
    0xbf, 0xb2, 0xb5, 0xbc, 0xb2, 0xb9, 0xb8, 0xb5, 0xbc, 0xbf, 0xb3, 0xba,
    0xb7, 0xbb, 0xb0, 0xbe, 0xb4, 0xb1, 0xba, 0xb7, 0xb1, 0xb6, 0xbd, 0xb0,
    0xbb, 0xb8, 0xb6, 0xbd, 0xdc, 0xda, 0xd1, 0xdf, 0xda, 0xd4, 0xdf, 0xd2,
    0xd9, 0xd7, 0xd2, 0xdc, 0xd6, 0xd9, 0xd8, 0xd5, 0xd0, 0xd6, 0xdd, 0xd1,
    0xd3, 0xdd, 0xd4, 0xde, 0xde, 0xd0, 0xd7, 0xdb, 0xd5, 0xd3, 0xdb, 0xd8,
    0xd9, 0xd4, 0xde, 0xd3, 0xdf, 0xd2, 0xd5, 0xdc, 0xd2, 0xd9, 0xd8, 0xd5,
    0xdc, 0xdf, 0xd3, 0xda, 0xd7, 0xdb, 0xd0, 0xde, 0xd4, 0xd1, 0xda, 0xd7,
    0xd1, 0xd6, 0xdd, 0xd0, 0xdb, 0xd8, 0xd6, 0xdd, 0x6c, 0x6a, 0x61, 0x6f,
    0x6a, 0x64, 0x6f, 0x62, 0x69, 0x67, 0x62, 0x6c, 0x66, 0x69, 0x68, 0x65,
    0x60, 0x66, 0x6d, 0x61, 0x63, 0x6d, 0x64, 0x6e, 0x6e, 0x60, 0x67, 0x6b,
    0x65, 0x63, 0x6b, 0x68, 0x69, 0x64, 0x6e, 0x63, 0x6f, 0x62, 0x65, 0x6c,
    0x62, 0x69, 0x68, 0x65, 0x6c, 0x6f, 0x63, 0x6a, 0x67, 0x6b, 0x60, 0x6e,
    0x64, 0x61, 0x6a, 0x67, 0x61, 0x66, 0x6d, 0x60, 0x6b, 0x68, 0x66, 0x6d,
    0x1c, 0x1a, 0x11, 0x1f, 0x1a, 0x14, 0x1f, 0x12, 0x19, 0x17, 0x12, 0x1c,
    0x16, 0x19, 0x18, 0x15, 0x10, 0x16, 0x1d, 0x11, 0x13, 0x1d, 0x14, 0x1e,
    0x1e, 0x10, 0x17, 0x1b, 0x15, 0x13, 0x1b, 0x18, 0x19, 0x14, 0x1e, 0x13,
    0x1f, 0x12, 0x15, 0x1c, 0x12, 0x19, 0x18, 0x15, 0x1c, 0x1f, 0x13, 0x1a,
    0x17, 0x1b, 0x10, 0x1e, 0x14, 0x11, 0x1a, 0x17, 0x11, 0x16, 0x1d, 0x10,
    0x1b, 0x18, 0x16, 0x1d, 0x8c, 0x8a, 0x81, 0x8f, 0x8a, 0x84, 0x8f, 0x82,
    0x89, 0x87, 0x82, 0x8c, 0x86, 0x89, 0x88, 0x85, 0x80, 0x86, 0x8d, 0x81,
    0x83, 0x8d, 0x84, 0x8e, 0x8e, 0x80, 0x87, 0x8b, 0x85, 0x83, 0x8b, 0x88,
    0x89, 0x84, 0x8e, 0x83, 0x8f, 0x82, 0x85, 0x8c, 0x82, 0x89, 0x88, 0x85,
    0x8c, 0x8f, 0x83, 0x8a, 0x87, 0x8b, 0x80, 0x8e, 0x84, 0x81, 0x8a, 0x87,
    0x81, 0x86, 0x8d, 0x80, 0x8b, 0x88, 0x86, 0x8d, 0x5c, 0x5a, 0x51, 0x5f,
    0x5a, 0x54, 0x5f, 0x52, 0x59, 0x57, 0x52, 0x5c, 0x56, 0x59, 0x58, 0x55,
    0x50, 0x56, 0x5d, 0x51, 0x53, 0x5d, 0x54, 0x5e, 0x5e, 0x50, 0x57, 0x5b,
    0x55, 0x53, 0x5b, 0x58, 0x59, 0x54, 0x5e, 0x53, 0x5f, 0x52, 0x55, 0x5c,
    0x52, 0x59, 0x58, 0x55, 0x5c, 0x5f, 0x53, 0x5a, 0x57, 0x5b, 0x50, 0x5e,
    0x54, 0x51, 0x5a, 0x57, 0x51, 0x56, 0x5d, 0x50, 0x5b, 0x58, 0x56, 0x5d,
    0x5c, 0x5a, 0x51, 0x5f, 0x5a, 0x54, 0x5f, 0x52, 0x59, 0x57, 0x52, 0x5c,
    0x56, 0x59, 0x58, 0x55, 0x50, 0x56, 0x5d, 0x51, 0x53, 0x5d, 0x54, 0x5e,
    0x5e, 0x50, 0x57, 0x5b, 0x55, 0x53, 0x5b, 0x58, 0x59, 0x54, 0x5e, 0x53,
    0x5f, 0x52, 0x55, 0x5c, 0x52, 0x59, 0x58, 0x55, 0x5c, 0x5f, 0x53, 0x5a,
    0x57, 0x5b, 0x50, 0x5e, 0x54, 0x51, 0x5a, 0x57, 0x51, 0x56, 0x5d, 0x50,
    0x5b, 0x58, 0x56, 0x5d, 0x0c, 0x0a, 0x01, 0x0f, 0x0a, 0x04, 0x0f, 0x02,
    0x09, 0x07, 0x02, 0x0c, 0x06, 0x09, 0x08, 0x05, 0x00, 0x06, 0x0d, 0x01,
    0x03, 0x0d, 0x04, 0x0e, 0x0e, 0x00, 0x07, 0x0b, 0x05, 0x03, 0x0b, 0x08,
    0x09, 0x04, 0x0e, 0x03, 0x0f, 0x02, 0x05, 0x0c, 0x02, 0x09, 0x08, 0x05,
    0x0c, 0x0f, 0x03, 0x0a, 0x07, 0x0b, 0x00, 0x0e, 0x04, 0x01, 0x0a, 0x07,
    0x01, 0x06, 0x0d, 0x00, 0x0b, 0x08, 0x06, 0x0d, 0x3c, 0x3a, 0x31, 0x3f,
    0x3a, 0x34, 0x3f, 0x32, 0x39, 0x37, 0x32, 0x3c, 0x36, 0x39, 0x38, 0x35,
    0x30, 0x36, 0x3d, 0x31, 0x33, 0x3d, 0x34, 0x3e, 0x3e, 0x30, 0x37, 0x3b,
    0x35, 0x33, 0x3b, 0x38, 0x39, 0x34, 0x3e, 0x33, 0x3f, 0x32, 0x35, 0x3c,
    0x32, 0x39, 0x38, 0x35, 0x3c, 0x3f, 0x33, 0x3a, 0x37, 0x3b, 0x30, 0x3e,
    0x34, 0x31, 0x3a, 0x37, 0x31, 0x36, 0x3d, 0x30, 0x3b, 0x38, 0x36, 0x3d,
    0xfc, 0xfa, 0xf1, 0xff, 0xfa, 0xf4, 0xff, 0xf2, 0xf9, 0xf7, 0xf2, 0xfc,
    0xf6, 0xf9, 0xf8, 0xf5, 0xf0, 0xf6, 0xfd, 0xf1, 0xf3, 0xfd, 0xf4, 0xfe,
    0xfe, 0xf0, 0xf7, 0xfb, 0xf5, 0xf3, 0xfb, 0xf8, 0xf9, 0xf4, 0xfe, 0xf3,
    0xff, 0xf2, 0xf5, 0xfc, 0xf2, 0xf9, 0xf8, 0xf5, 0xfc, 0xff, 0xf3, 0xfa,
    0xf7, 0xfb, 0xf0, 0xfe, 0xf4, 0xf1, 0xfa, 0xf7, 0xf1, 0xf6, 0xfd, 0xf0,
    0xfb, 0xf8, 0xf6, 0xfd, 0xfc, 0xfa, 0xf1, 0xff, 0xfa, 0xf4, 0xff, 0xf2,
    0xf9, 0xf7, 0xf2, 0xfc, 0xf6, 0xf9, 0xf8, 0xf5, 0xf0, 0xf6, 0xfd, 0xf1,
    0xf3, 0xfd, 0xf4, 0xfe, 0xfe, 0xf0, 0xf7, 0xfb, 0xf5, 0xf3, 0xfb, 0xf8,
    0xf9, 0xf4, 0xfe, 0xf3, 0xff, 0xf2, 0xf5, 0xfc, 0xf2, 0xf9, 0xf8, 0xf5,
    0xfc, 0xff, 0xf3, 0xfa, 0xf7, 0xfb, 0xf0, 0xfe, 0xf4, 0xf1, 0xfa, 0xf7,
    0xf1, 0xf6, 0xfd, 0xf0, 0xfb, 0xf8, 0xf6, 0xfd, 0xac, 0xaa, 0xa1, 0xaf,
    0xaa, 0xa4, 0xaf, 0xa2, 0xa9, 0xa7, 0xa2, 0xac, 0xa6, 0xa9, 0xa8, 0xa5,
    0xa0, 0xa6, 0xad, 0xa1, 0xa3, 0xad, 0xa4, 0xae, 0xae, 0xa0, 0xa7, 0xab,
    0xa5, 0xa3, 0xab, 0xa8, 0xa9, 0xa4, 0xae, 0xa3, 0xaf, 0xa2, 0xa5, 0xac,
    0xa2, 0xa9, 0xa8, 0xa5, 0xac, 0xaf, 0xa3, 0xaa, 0xa7, 0xab, 0xa0, 0xae,
    0xa4, 0xa1, 0xaa, 0xa7, 0xa1, 0xa6, 0xad, 0xa0, 0xab, 0xa8, 0xa6, 0xad,
    0xdc, 0xda, 0xd1, 0xdf, 0xda, 0xd4, 0xdf, 0xd2, 0xd9, 0xd7, 0xd2, 0xdc,
    0xd6, 0xd9, 0xd8, 0xd5, 0xd0, 0xd6, 0xdd, 0xd1, 0xd3, 0xdd, 0xd4, 0xde,
    0xde, 0xd0, 0xd7, 0xdb, 0xd5, 0xd3, 0xdb, 0xd8, 0xd9, 0xd4, 0xde, 0xd3,
    0xdf, 0xd2, 0xd5, 0xdc, 0xd2, 0xd9, 0xd8, 0xd5, 0xdc, 0xdf, 0xd3, 0xda,
    0xd7, 0xdb, 0xd0, 0xde, 0xd4, 0xd1, 0xda, 0xd7, 0xd1, 0xd6, 0xdd, 0xd0,
    0xdb, 0xd8, 0xd6, 0xdd, 0x3c, 0x3a, 0x31, 0x3f, 0x3a, 0x34, 0x3f, 0x32,
    0x39, 0x37, 0x32, 0x3c, 0x36, 0x39, 0x38, 0x35, 0x30, 0x36, 0x3d, 0x31,
    0x33, 0x3d, 0x34, 0x3e, 0x3e, 0x30, 0x37, 0x3b, 0x35, 0x33, 0x3b, 0x38,
    0x39, 0x34, 0x3e, 0x33, 0x3f, 0x32, 0x35, 0x3c, 0x32, 0x39, 0x38, 0x35,
    0x3c, 0x3f, 0x33, 0x3a, 0x37, 0x3b, 0x30, 0x3e, 0x34, 0x31, 0x3a, 0x37,
    0x31, 0x36, 0x3d, 0x30, 0x3b, 0x38, 0x36, 0x3d, 0x0c, 0x0a, 0x01, 0x0f,
    0x0a, 0x04, 0x0f, 0x02, 0x09, 0x07, 0x02, 0x0c, 0x06, 0x09, 0x08, 0x05,
    0x00, 0x06, 0x0d, 0x01, 0x03, 0x0d, 0x04, 0x0e, 0x0e, 0x00, 0x07, 0x0b,
    0x05, 0x03, 0x0b, 0x08, 0x09, 0x04, 0x0e, 0x03, 0x0f, 0x02, 0x05, 0x0c,
    0x02, 0x09, 0x08, 0x05, 0x0c, 0x0f, 0x03, 0x0a, 0x07, 0x0b, 0x00, 0x0e,
    0x04, 0x01, 0x0a, 0x07, 0x01, 0x06, 0x0d, 0x00, 0x0b, 0x08, 0x06, 0x0d,
    0x9c, 0x9a, 0x91, 0x9f, 0x9a, 0x94, 0x9f, 0x92, 0x99, 0x97, 0x92, 0x9c,
    0x96, 0x99, 0x98, 0x95, 0x90, 0x96, 0x9d, 0x91, 0x93, 0x9d, 0x94, 0x9e,
    0x9e, 0x90, 0x97, 0x9b, 0x95, 0x93, 0x9b, 0x98, 0x99, 0x94, 0x9e, 0x93,
    0x9f, 0x92, 0x95, 0x9c, 0x92, 0x99, 0x98, 0x95, 0x9c, 0x9f, 0x93, 0x9a,
    0x97, 0x9b, 0x90, 0x9e, 0x94, 0x91, 0x9a, 0x97, 0x91, 0x96, 0x9d, 0x90,
    0x9b, 0x98, 0x96, 0x9d, 0xec, 0xea, 0xe1, 0xef, 0xea, 0xe4, 0xef, 0xe2,
    0xe9, 0xe7, 0xe2, 0xec, 0xe6, 0xe9, 0xe8, 0xe5, 0xe0, 0xe6, 0xed, 0xe1,
    0xe3, 0xed, 0xe4, 0xee, 0xee, 0xe0, 0xe7, 0xeb, 0xe5, 0xe3, 0xeb, 0xe8,
    0xe9, 0xe4, 0xee, 0xe3, 0xef, 0xe2, 0xe5, 0xec, 0xe2, 0xe9, 0xe8, 0xe5,
    0xec, 0xef, 0xe3, 0xea, 0xe7, 0xeb, 0xe0, 0xee, 0xe4, 0xe1, 0xea, 0xe7,
    0xe1, 0xe6, 0xed, 0xe0, 0xeb, 0xe8, 0xe6, 0xed, 0x8c, 0x8a, 0x81, 0x8f,
    0x8a, 0x84, 0x8f, 0x82, 0x89, 0x87, 0x82, 0x8c, 0x86, 0x89, 0x88, 0x85,
    0x80, 0x86, 0x8d, 0x81, 0x83, 0x8d, 0x84, 0x8e, 0x8e, 0x80, 0x87, 0x8b,
    0x85, 0x83, 0x8b, 0x88, 0x89, 0x84, 0x8e, 0x83, 0x8f, 0x82, 0x85, 0x8c,
    0x82, 0x89, 0x88, 0x85, 0x8c, 0x8f, 0x83, 0x8a, 0x87, 0x8b, 0x80, 0x8e,
    0x84, 0x81, 0x8a, 0x87, 0x81, 0x86, 0x8d, 0x80, 0x8b, 0x88, 0x86, 0x8d,
    0x9c, 0x9a, 0x91, 0x9f, 0x9a, 0x94, 0x9f, 0x92, 0x99, 0x97, 0x92, 0x9c,
    0x96, 0x99, 0x98, 0x95, 0x90, 0x96, 0x9d, 0x91, 0x93, 0x9d, 0x94, 0x9e,
    0x9e, 0x90, 0x97, 0x9b, 0x95, 0x93, 0x9b, 0x98, 0x99, 0x94, 0x9e, 0x93,
    0x9f, 0x92, 0x95, 0x9c, 0x92, 0x99, 0x98, 0x95, 0x9c, 0x9f, 0x93, 0x9a,
    0x97, 0x9b, 0x90, 0x9e, 0x94, 0x91, 0x9a, 0x97, 0x91, 0x96, 0x9d, 0x90,
    0x9b, 0x98, 0x96, 0x9d, 0x6c, 0x6a, 0x61, 0x6f, 0x6a, 0x64, 0x6f, 0x62,
    0x69, 0x67, 0x62, 0x6c, 0x66, 0x69, 0x68, 0x65, 0x60, 0x66, 0x6d, 0x61,
    0x63, 0x6d, 0x64, 0x6e, 0x6e, 0x60, 0x67, 0x6b, 0x65, 0x63, 0x6b, 0x68,
    0x69, 0x64, 0x6e, 0x63, 0x6f, 0x62, 0x65, 0x6c, 0x62, 0x69, 0x68, 0x65,
    0x6c, 0x6f, 0x63, 0x6a, 0x67, 0x6b, 0x60, 0x6e, 0x64, 0x61, 0x6a, 0x67,
    0x61, 0x66, 0x6d, 0x60, 0x6b, 0x68, 0x66, 0x6d, 0x4c, 0x4a, 0x41, 0x4f,
    0x4a, 0x44, 0x4f, 0x42, 0x49, 0x47, 0x42, 0x4c, 0x46, 0x49, 0x48, 0x45,
    0x40, 0x46, 0x4d, 0x41, 0x43, 0x4d, 0x44, 0x4e, 0x4e, 0x40, 0x47, 0x4b,
    0x45, 0x43, 0x4b, 0x48, 0x49, 0x44, 0x4e, 0x43, 0x4f, 0x42, 0x45, 0x4c,
    0x42, 0x49, 0x48, 0x45, 0x4c, 0x4f, 0x43, 0x4a, 0x47, 0x4b, 0x40, 0x4e,
    0x44, 0x41, 0x4a, 0x47, 0x41, 0x46, 0x4d, 0x40, 0x4b, 0x48, 0x46, 0x4d,
    0xbc, 0xba, 0xb1, 0xbf, 0xba, 0xb4, 0xbf, 0xb2, 0xb9, 0xb7, 0xb2, 0xbc,
    0xb6, 0xb9, 0xb8, 0xb5, 0xb0, 0xb6, 0xbd, 0xb1, 0xb3, 0xbd, 0xb4, 0xbe,
    0xbe, 0xb0, 0xb7, 0xbb, 0xb5, 0xb3, 0xbb, 0xb8, 0xb9, 0xb4, 0xbe, 0xb3,
    0xbf, 0xb2, 0xb5, 0xbc, 0xb2, 0xb9, 0xb8, 0xb5, 0xbc, 0xbf, 0xb3, 0xba,
    0xb7, 0xbb, 0xb0, 0xbe, 0xb4, 0xb1, 0xba, 0xb7, 0xb1, 0xb6, 0xbd, 0xb0,
    0xbb, 0xb8, 0xb6, 0xbd, 0x2c, 0x2a, 0x21, 0x2f, 0x2a, 0x24, 0x2f, 0x22,
    0x29, 0x27, 0x22, 0x2c, 0x26, 0x29, 0x28, 0x25, 0x20, 0x26, 0x2d, 0x21,
    0x23, 0x2d, 0x24, 0x2e, 0x2e, 0x20, 0x27, 0x2b, 0x25, 0x23, 0x2b, 0x28,
    0x29, 0x24, 0x2e, 0x23, 0x2f, 0x22, 0x25, 0x2c, 0x22, 0x29, 0x28, 0x25,
    0x2c, 0x2f, 0x23, 0x2a, 0x27, 0x2b, 0x20, 0x2e, 0x24, 0x21, 0x2a, 0x27,
    0x21, 0x26, 0x2d, 0x20, 0x2b, 0x28, 0x26, 0x2d, 0x8c, 0x8a, 0x81, 0x8f,
    0x8a, 0x84, 0x8f, 0x82, 0x89, 0x87, 0x82, 0x8c, 0x86, 0x89, 0x88, 0x85,
    0x80, 0x86, 0x8d, 0x81, 0x83, 0x8d, 0x84, 0x8e, 0x8e, 0x80, 0x87, 0x8b,
    0x85, 0x83, 0x8b, 0x88, 0x89, 0x84, 0x8e, 0x83, 0x8f, 0x82, 0x85, 0x8c,
    0x82, 0x89, 0x88, 0x85, 0x8c, 0x8f, 0x83, 0x8a, 0x87, 0x8b, 0x80, 0x8e,
    0x84, 0x81, 0x8a, 0x87, 0x81, 0x86, 0x8d, 0x80, 0x8b, 0x88, 0x86, 0x8d,
    0x1c, 0x1a, 0x11, 0x1f, 0x1a, 0x14, 0x1f, 0x12, 0x19, 0x17, 0x12, 0x1c,
    0x16, 0x19, 0x18, 0x15, 0x10, 0x16, 0x1d, 0x11, 0x13, 0x1d, 0x14, 0x1e,
    0x1e, 0x10, 0x17, 0x1b, 0x15, 0x13, 0x1b, 0x18, 0x19, 0x14, 0x1e, 0x13,
    0x1f, 0x12, 0x15, 0x1c, 0x12, 0x19, 0x18, 0x15, 0x1c, 0x1f, 0x13, 0x1a,
    0x17, 0x1b, 0x10, 0x1e, 0x14, 0x11, 0x1a, 0x17, 0x11, 0x16, 0x1d, 0x10,
    0x1b, 0x18, 0x16, 0x1d, 0xcc, 0xca, 0xc1, 0xcf, 0xca, 0xc4, 0xcf, 0xc2,
    0xc9, 0xc7, 0xc2, 0xcc, 0xc6, 0xc9, 0xc8, 0xc5, 0xc0, 0xc6, 0xcd, 0xc1,
    0xc3, 0xcd, 0xc4, 0xce, 0xce, 0xc0, 0xc7, 0xcb, 0xc5, 0xc3, 0xcb, 0xc8,
    0xc9, 0xc4, 0xce, 0xc3, 0xcf, 0xc2, 0xc5, 0xcc, 0xc2, 0xc9, 0xc8, 0xc5,
    0xcc, 0xcf, 0xc3, 0xca, 0xc7, 0xcb, 0xc0, 0xce, 0xc4, 0xc1, 0xca, 0xc7,
    0xc1, 0xc6, 0xcd, 0xc0, 0xcb, 0xc8, 0xc6, 0xcd, 0xbc, 0xba, 0xb1, 0xbf,
    0xba, 0xb4, 0xbf, 0xb2, 0xb9, 0xb7, 0xb2, 0xbc, 0xb6, 0xb9, 0xb8, 0xb5,
    0xb0, 0xb6, 0xbd, 0xb1, 0xb3, 0xbd, 0xb4, 0xbe, 0xbe, 0xb0, 0xb7, 0xbb,
    0xb5, 0xb3, 0xbb, 0xb8, 0xb9, 0xb4, 0xbe, 0xb3, 0xbf, 0xb2, 0xb5, 0xbc,
    0xb2, 0xb9, 0xb8, 0xb5, 0xbc, 0xbf, 0xb3, 0xba, 0xb7, 0xbb, 0xb0, 0xbe,
    0xb4, 0xb1, 0xba, 0xb7, 0xb1, 0xb6, 0xbd, 0xb0, 0xbb, 0xb8, 0xb6, 0xbd,
    0x7c, 0x7a, 0x71, 0x7f, 0x7a, 0x74, 0x7f, 0x72, 0x79, 0x77, 0x72, 0x7c,
    0x76, 0x79, 0x78, 0x75, 0x70, 0x76, 0x7d, 0x71, 0x73, 0x7d, 0x74, 0x7e,
    0x7e, 0x70, 0x77, 0x7b, 0x75, 0x73, 0x7b, 0x78, 0x79, 0x74, 0x7e, 0x73,
    0x7f, 0x72, 0x75, 0x7c, 0x72, 0x79, 0x78, 0x75, 0x7c, 0x7f, 0x73, 0x7a,
    0x77, 0x7b, 0x70, 0x7e, 0x74, 0x71, 0x7a, 0x77, 0x71, 0x76, 0x7d, 0x70,
    0x7b, 0x78, 0x76, 0x7d, 0xac, 0xaa, 0xa1, 0xaf, 0xaa, 0xa4, 0xaf, 0xa2,
    0xa9, 0xa7, 0xa2, 0xac, 0xa6, 0xa9, 0xa8, 0xa5, 0xa0, 0xa6, 0xad, 0xa1,
    0xa3, 0xad, 0xa4, 0xae, 0xae, 0xa0, 0xa7, 0xab, 0xa5, 0xa3, 0xab, 0xa8,
    0xa9, 0xa4, 0xae, 0xa3, 0xaf, 0xa2, 0xa5, 0xac, 0xa2, 0xa9, 0xa8, 0xa5,
    0xac, 0xaf, 0xa3, 0xaa, 0xa7, 0xab, 0xa0, 0xae, 0xa4, 0xa1, 0xaa, 0xa7,
    0xa1, 0xa6, 0xad, 0xa0, 0xab, 0xa8, 0xa6, 0xad, 0x1c, 0x1a, 0x11, 0x1f,
    0x1a, 0x14, 0x1f, 0x12, 0x19, 0x17, 0x12, 0x1c, 0x16, 0x19, 0x18, 0x15,
    0x10, 0x16, 0x1d, 0x11, 0x13, 0x1d, 0x14, 0x1e, 0x1e, 0x10, 0x17, 0x1b,
    0x15, 0x13, 0x1b, 0x18, 0x19, 0x14, 0x1e, 0x13, 0x1f, 0x12, 0x15, 0x1c,
    0x12, 0x19, 0x18, 0x15, 0x1c, 0x1f, 0x13, 0x1a, 0x17, 0x1b, 0x10, 0x1e,
    0x14, 0x11, 0x1a, 0x17, 0x11, 0x16, 0x1d, 0x10, 0x1b, 0x18, 0x16, 0x1d,
    0xdc, 0xda, 0xd1, 0xdf, 0xda, 0xd4, 0xdf, 0xd2, 0xd9, 0xd7, 0xd2, 0xdc,
    0xd6, 0xd9, 0xd8, 0xd5, 0xd0, 0xd6, 0xdd, 0xd1, 0xd3, 0xdd, 0xd4, 0xde,
    0xde, 0xd0, 0xd7, 0xdb, 0xd5, 0xd3, 0xdb, 0xd8, 0xd9, 0xd4, 0xde, 0xd3,
    0xdf, 0xd2, 0xd5, 0xdc, 0xd2, 0xd9, 0xd8, 0xd5, 0xdc, 0xdf, 0xd3, 0xda,
    0xd7, 0xdb, 0xd0, 0xde, 0xd4, 0xd1, 0xda, 0xd7, 0xd1, 0xd6, 0xdd, 0xd0,
    0xdb, 0xd8, 0xd6, 0xdd, 0xec, 0xea, 0xe1, 0xef, 0xea, 0xe4, 0xef, 0xe2,
    0xe9, 0xe7, 0xe2, 0xec, 0xe6, 0xe9, 0xe8, 0xe5, 0xe0, 0xe6, 0xed, 0xe1,
    0xe3, 0xed, 0xe4, 0xee, 0xee, 0xe0, 0xe7, 0xeb, 0xe5, 0xe3, 0xeb, 0xe8,
    0xe9, 0xe4, 0xee, 0xe3, 0xef, 0xe2, 0xe5, 0xec, 0xe2, 0xe9, 0xe8, 0xe5,
    0xec, 0xef, 0xe3, 0xea, 0xe7, 0xeb, 0xe0, 0xee, 0xe4, 0xe1, 0xea, 0xe7,
    0xe1, 0xe6, 0xed, 0xe0, 0xeb, 0xe8, 0xe6, 0xed, 0x7c, 0x7a, 0x71, 0x7f,
    0x7a, 0x74, 0x7f, 0x72, 0x79, 0x77, 0x72, 0x7c, 0x76, 0x79, 0x78, 0x75,
    0x70, 0x76, 0x7d, 0x71, 0x73, 0x7d, 0x74, 0x7e, 0x7e, 0x70, 0x77, 0x7b,
    0x75, 0x73, 0x7b, 0x78, 0x79, 0x74, 0x7e, 0x73, 0x7f, 0x72, 0x75, 0x7c,
    0x72, 0x79, 0x78, 0x75, 0x7c, 0x7f, 0x73, 0x7a, 0x77, 0x7b, 0x70, 0x7e,
    0x74, 0x71, 0x7a, 0x77, 0x71, 0x76, 0x7d, 0x70, 0x7b, 0x78, 0x76, 0x7d,
    0x2c, 0x2a, 0x21, 0x2f, 0x2a, 0x24, 0x2f, 0x22, 0x29, 0x27, 0x22, 0x2c,
    0x26, 0x29, 0x28, 0x25, 0x20, 0x26, 0x2d, 0x21, 0x23, 0x2d, 0x24, 0x2e,
    0x2e, 0x20, 0x27, 0x2b, 0x25, 0x23, 0x2b, 0x28, 0x29, 0x24, 0x2e, 0x23,
    0x2f, 0x22, 0x25, 0x2c, 0x22, 0x29, 0x28, 0x25, 0x2c, 0x2f, 0x23, 0x2a,
    0x27, 0x2b, 0x20, 0x2e, 0x24, 0x21, 0x2a, 0x27, 0x21, 0x26, 0x2d, 0x20,
    0x2b, 0x28, 0x26, 0x2d, 0x8c, 0x8a, 0x81, 0x8f, 0x8a, 0x84, 0x8f, 0x82,
    0x89, 0x87, 0x82, 0x8c, 0x86, 0x89, 0x88, 0x85, 0x80, 0x86, 0x8d, 0x81,
    0x83, 0x8d, 0x84, 0x8e, 0x8e, 0x80, 0x87, 0x8b, 0x85, 0x83, 0x8b, 0x88,
    0x89, 0x84, 0x8e, 0x83, 0x8f, 0x82, 0x85, 0x8c, 0x82, 0x89, 0x88, 0x85,
    0x8c, 0x8f, 0x83, 0x8a, 0x87, 0x8b, 0x80, 0x8e, 0x84, 0x81, 0x8a, 0x87,
    0x81, 0x86, 0x8d, 0x80, 0x8b, 0x88, 0x86, 0x8d, 0xdc, 0xda, 0xd1, 0xdf,
    0xda, 0xd4, 0xdf, 0xd2, 0xd9, 0xd7, 0xd2, 0xdc, 0xd6, 0xd9, 0xd8, 0xd5,
    0xd0, 0xd6, 0xdd, 0xd1, 0xd3, 0xdd, 0xd4, 0xde, 0xde, 0xd0, 0xd7, 0xdb,
    0xd5, 0xd3, 0xdb, 0xd8, 0xd9, 0xd4, 0xde, 0xd3, 0xdf, 0xd2, 0xd5, 0xdc,
    0xd2, 0xd9, 0xd8, 0xd5, 0xdc, 0xdf, 0xd3, 0xda, 0xd7, 0xdb, 0xd0, 0xde,
    0xd4, 0xd1, 0xda, 0xd7, 0xd1, 0xd6, 0xdd, 0xd0, 0xdb, 0xd8, 0xd6, 0xdd,
    0xfc, 0xfa, 0xf1, 0xff, 0xfa, 0xf4, 0xff, 0xf2, 0xf9, 0xf7, 0xf2, 0xfc,
    0xf6, 0xf9, 0xf8, 0xf5, 0xf0, 0xf6, 0xfd, 0xf1, 0xf3, 0xfd, 0xf4, 0xfe,
    0xfe, 0xf0, 0xf7, 0xfb, 0xf5, 0xf3, 0xfb, 0xf8, 0xf9, 0xf4, 0xfe, 0xf3,
    0xff, 0xf2, 0xf5, 0xfc, 0xf2, 0xf9, 0xf8, 0xf5, 0xfc, 0xff, 0xf3, 0xfa,
    0xf7, 0xfb, 0xf0, 0xfe, 0xf4, 0xf1, 0xfa, 0xf7, 0xf1, 0xf6, 0xfd, 0xf0,
    0xfb, 0xf8, 0xf6, 0xfd, 0x6c, 0x6a, 0x61, 0x6f, 0x6a, 0x64, 0x6f, 0x62,
    0x69, 0x67, 0x62, 0x6c, 0x66, 0x69, 0x68, 0x65, 0x60, 0x66, 0x6d, 0x61,
    0x63, 0x6d, 0x64, 0x6e, 0x6e, 0x60, 0x67, 0x6b, 0x65, 0x63, 0x6b, 0x68,
    0x69, 0x64, 0x6e, 0x63, 0x6f, 0x62, 0x65, 0x6c, 0x62, 0x69, 0x68, 0x65,
    0x6c, 0x6f, 0x63, 0x6a, 0x67, 0x6b, 0x60, 0x6e, 0x64, 0x61, 0x6a, 0x67,
    0x61, 0x66, 0x6d, 0x60, 0x6b, 0x68, 0x66, 0x6d, 0x9c, 0x9a, 0x91, 0x9f,
    0x9a, 0x94, 0x9f, 0x92, 0x99, 0x97, 0x92, 0x9c, 0x96, 0x99, 0x98, 0x95,
    0x90, 0x96, 0x9d, 0x91, 0x93, 0x9d, 0x94, 0x9e, 0x9e, 0x90, 0x97, 0x9b,
    0x95, 0x93, 0x9b, 0x98, 0x99, 0x94, 0x9e, 0x93, 0x9f, 0x92, 0x95, 0x9c,
    0x92, 0x99, 0x98, 0x95, 0x9c, 0x9f, 0x93, 0x9a, 0x97, 0x9b, 0x90, 0x9e,
    0x94, 0x91, 0x9a, 0x97, 0x91, 0x96, 0x9d, 0x90, 0x9b, 0x98, 0x96, 0x9d,
    0xfc, 0xfa, 0xf1, 0xff, 0xfa, 0xf4, 0xff, 0xf2, 0xf9, 0xf7, 0xf2, 0xfc,
    0xf6, 0xf9, 0xf8, 0xf5, 0xf0, 0xf6, 0xfd, 0xf1, 0xf3, 0xfd, 0xf4, 0xfe,
    0xfe, 0xf0, 0xf7, 0xfb, 0xf5, 0xf3, 0xfb, 0xf8, 0xf9, 0xf4, 0xfe, 0xf3,
    0xff, 0xf2, 0xf5, 0xfc, 0xf2, 0xf9, 0xf8, 0xf5, 0xfc, 0xff, 0xf3, 0xfa,
    0xf7, 0xfb, 0xf0, 0xfe, 0xf4, 0xf1, 0xfa, 0xf7, 0xf1, 0xf6, 0xfd, 0xf0,
    0xfb, 0xf8, 0xf6, 0xfd, 0xcc, 0xca, 0xc1, 0xcf, 0xca, 0xc4, 0xcf, 0xc2,
    0xc9, 0xc7, 0xc2, 0xcc, 0xc6, 0xc9, 0xc8, 0xc5, 0xc0, 0xc6, 0xcd, 0xc1,
    0xc3, 0xcd, 0xc4, 0xce, 0xce, 0xc0, 0xc7, 0xcb, 0xc5, 0xc3, 0xcb, 0xc8,
    0xc9, 0xc4, 0xce, 0xc3, 0xcf, 0xc2, 0xc5, 0xcc, 0xc2, 0xc9, 0xc8, 0xc5,
    0xcc, 0xcf, 0xc3, 0xca, 0xc7, 0xcb, 0xc0, 0xce, 0xc4, 0xc1, 0xca, 0xc7,
    0xc1, 0xc6, 0xcd, 0xc0, 0xcb, 0xc8, 0xc6, 0xcd, 0x0c, 0x0a, 0x01, 0x0f,
    0x0a, 0x04, 0x0f, 0x02, 0x09, 0x07, 0x02, 0x0c, 0x06, 0x09, 0x08, 0x05,
    0x00, 0x06, 0x0d, 0x01, 0x03, 0x0d, 0x04, 0x0e, 0x0e, 0x00, 0x07, 0x0b,
    0x05, 0x03, 0x0b, 0x08, 0x09, 0x04, 0x0e, 0x03, 0x0f, 0x02, 0x05, 0x0c,
    0x02, 0x09, 0x08, 0x05, 0x0c, 0x0f, 0x03, 0x0a, 0x07, 0x0b, 0x00, 0x0e,
    0x04, 0x01, 0x0a, 0x07, 0x01, 0x06, 0x0d, 0x00, 0x0b, 0x08, 0x06, 0x0d,
    0x5c, 0x5a, 0x51, 0x5f, 0x5a, 0x54, 0x5f, 0x52, 0x59, 0x57, 0x52, 0x5c,
    0x56, 0x59, 0x58, 0x55, 0x50, 0x56, 0x5d, 0x51, 0x53, 0x5d, 0x54, 0x5e,
    0x5e, 0x50, 0x57, 0x5b, 0x55, 0x53, 0x5b, 0x58, 0x59, 0x54, 0x5e, 0x53,
    0x5f, 0x52, 0x55, 0x5c, 0x52, 0x59, 0x58, 0x55, 0x5c, 0x5f, 0x53, 0x5a,
    0x57, 0x5b, 0x50, 0x5e, 0x54, 0x51, 0x5a, 0x57, 0x51, 0x56, 0x5d, 0x50,
    0x5b, 0x58, 0x56, 0x5d, 0x9c, 0x9a, 0x91, 0x9f, 0x9a, 0x94, 0x9f, 0x92,
    0x99, 0x97, 0x92, 0x9c, 0x96, 0x99, 0x98, 0x95, 0x90, 0x96, 0x9d, 0x91,
    0x93, 0x9d, 0x94, 0x9e, 0x9e, 0x90, 0x97, 0x9b, 0x95, 0x93, 0x9b, 0x98,
    0x99, 0x94, 0x9e, 0x93, 0x9f, 0x92, 0x95, 0x9c, 0x92, 0x99, 0x98, 0x95,
    0x9c, 0x9f, 0x93, 0x9a, 0x97, 0x9b, 0x90, 0x9e, 0x94, 0x91, 0x9a, 0x97,
    0x91, 0x96, 0x9d, 0x90, 0x9b, 0x98, 0x96, 0x9d, 0x6c, 0x6a, 0x61, 0x6f,
    0x6a, 0x64, 0x6f, 0x62, 0x69, 0x67, 0x62, 0x6c, 0x66, 0x69, 0x68, 0x65,
    0x60, 0x66, 0x6d, 0x61, 0x63, 0x6d, 0x64, 0x6e, 0x6e, 0x60, 0x67, 0x6b,
    0x65, 0x63, 0x6b, 0x68, 0x69, 0x64, 0x6e, 0x63, 0x6f, 0x62, 0x65, 0x6c,
    0x62, 0x69, 0x68, 0x65, 0x6c, 0x6f, 0x63, 0x6a, 0x67, 0x6b, 0x60, 0x6e,
    0x64, 0x61, 0x6a, 0x67, 0x61, 0x66, 0x6d, 0x60, 0x6b, 0x68, 0x66, 0x6d,
    0xac, 0xaa, 0xa1, 0xaf, 0xaa, 0xa4, 0xaf, 0xa2, 0xa9, 0xa7, 0xa2, 0xac,
    0xa6, 0xa9, 0xa8, 0xa5, 0xa0, 0xa6, 0xad, 0xa1, 0xa3, 0xad, 0xa4, 0xae,
    0xae, 0xa0, 0xa7, 0xab, 0xa5, 0xa3, 0xab, 0xa8, 0xa9, 0xa4, 0xae, 0xa3,
    0xaf, 0xa2, 0xa5, 0xac, 0xa2, 0xa9, 0xa8, 0xa5, 0xac, 0xaf, 0xa3, 0xaa,
    0xa7, 0xab, 0xa0, 0xae, 0xa4, 0xa1, 0xaa, 0xa7, 0xa1, 0xa6, 0xad, 0xa0,
    0xab, 0xa8, 0xa6, 0xad, 0x3c, 0x3a, 0x31, 0x3f, 0x3a, 0x34, 0x3f, 0x32,
    0x39, 0x37, 0x32, 0x3c, 0x36, 0x39, 0x38, 0x35, 0x30, 0x36, 0x3d, 0x31,
    0x33, 0x3d, 0x34, 0x3e, 0x3e, 0x30, 0x37, 0x3b, 0x35, 0x33, 0x3b, 0x38,
    0x39, 0x34, 0x3e, 0x33, 0x3f, 0x32, 0x35, 0x3c, 0x32, 0x39, 0x38, 0x35,
    0x3c, 0x3f, 0x33, 0x3a, 0x37, 0x3b, 0x30, 0x3e, 0x34, 0x31, 0x3a, 0x37,
    0x31, 0x36, 0x3d, 0x30, 0x3b, 0x38, 0x36, 0x3d, 0x4c, 0x4a, 0x41, 0x4f,
    0x4a, 0x44, 0x4f, 0x42, 0x49, 0x47, 0x42, 0x4c, 0x46, 0x49, 0x48, 0x45,
    0x40, 0x46, 0x4d, 0x41, 0x43, 0x4d, 0x44, 0x4e, 0x4e, 0x40, 0x47, 0x4b,
    0x45, 0x43, 0x4b, 0x48, 0x49, 0x44, 0x4e, 0x43, 0x4f, 0x42, 0x45, 0x4c,
    0x42, 0x49, 0x48, 0x45, 0x4c, 0x4f, 0x43, 0x4a, 0x47, 0x4b, 0x40, 0x4e,
    0x44, 0x41, 0x4a, 0x47, 0x41, 0x46, 0x4d, 0x40, 0x4b, 0x48, 0x46, 0x4d,
    0x0c, 0x0a, 0x01, 0x0f, 0x0a, 0x04, 0x0f, 0x02, 0x09, 0x07, 0x02, 0x0c,
    0x06, 0x09, 0x08, 0x05, 0x00, 0x06, 0x0d, 0x01, 0x03, 0x0d, 0x04, 0x0e,
    0x0e, 0x00, 0x07, 0x0b, 0x05, 0x03, 0x0b, 0x08, 0x09, 0x04, 0x0e, 0x03,
    0x0f, 0x02, 0x05, 0x0c, 0x02, 0x09, 0x08, 0x05, 0x0c, 0x0f, 0x03, 0x0a,
    0x07, 0x0b, 0x00, 0x0e, 0x04, 0x01, 0x0a, 0x07, 0x01, 0x06, 0x0d, 0x00,
    0x0b, 0x08, 0x06, 0x0d, 0x5c, 0x5a, 0x51, 0x5f, 0x5a, 0x54, 0x5f, 0x52,
    0x59, 0x57, 0x52, 0x5c, 0x56, 0x59, 0x58, 0x55, 0x50, 0x56, 0x5d, 0x51,
    0x53, 0x5d, 0x54, 0x5e, 0x5e, 0x50, 0x57, 0x5b, 0x55, 0x53, 0x5b, 0x58,
    0x59, 0x54, 0x5e, 0x53, 0x5f, 0x52, 0x55, 0x5c, 0x52, 0x59, 0x58, 0x55,
    0x5c, 0x5f, 0x53, 0x5a, 0x57, 0x5b, 0x50, 0x5e, 0x54, 0x51, 0x5a, 0x57,
    0x51, 0x56, 0x5d, 0x50, 0x5b, 0x58, 0x56, 0x5d, 0xec, 0xea, 0xe1, 0xef,
    0xea, 0xe4, 0xef, 0xe2, 0xe9, 0xe7, 0xe2, 0xec, 0xe6, 0xe9, 0xe8, 0xe5,
    0xe0, 0xe6, 0xed, 0xe1, 0xe3, 0xed, 0xe4, 0xee, 0xee, 0xe0, 0xe7, 0xeb,
    0xe5, 0xe3, 0xeb, 0xe8, 0xe9, 0xe4, 0xee, 0xe3, 0xef, 0xe2, 0xe5, 0xec,
    0xe2, 0xe9, 0xe8, 0xe5, 0xec, 0xef, 0xe3, 0xea, 0xe7, 0xeb, 0xe0, 0xee,
    0xe4, 0xe1, 0xea, 0xe7, 0xe1, 0xe6, 0xed, 0xe0, 0xeb, 0xe8, 0xe6, 0xed,
    0x3c, 0x3a, 0x31, 0x3f, 0x3a, 0x34, 0x3f, 0x32, 0x39, 0x37, 0x32, 0x3c,
    0x36, 0x39, 0x38, 0x35, 0x30, 0x36, 0x3d, 0x31, 0x33, 0x3d, 0x34, 0x3e,
    0x3e, 0x30, 0x37, 0x3b, 0x35, 0x33, 0x3b, 0x38, 0x39, 0x34, 0x3e, 0x33,
    0x3f, 0x32, 0x35, 0x3c, 0x32, 0x39, 0x38, 0x35, 0x3c, 0x3f, 0x33, 0x3a,
    0x37, 0x3b, 0x30, 0x3e, 0x34, 0x31, 0x3a, 0x37, 0x31, 0x36, 0x3d, 0x30,
    0x3b, 0x38, 0x36, 0x3d,
  },
  {
    0x4d, 0x41, 0x42, 0x4f, 0x48, 0x4d, 0x44, 0x48, 0x46, 0x4a, 0x4f, 0x43,
    0x4b, 0x47, 0x41, 0x44, 0x4a, 0x4c, 0x49, 0x45, 0x43, 0x46, 0x4e, 0x4b,
    0x45, 0x40, 0x40, 0x4e, 0x4c, 0x49, 0x47, 0x42, 0x47, 0x42, 0x4b, 0x41,
    0x44, 0x4e, 0x41, 0x47, 0x49, 0x44, 0x4c, 0x4a, 0x4e, 0x48, 0x42, 0x4d,
    0x40, 0x4f, 0x46, 0x4c, 0x4a, 0x49, 0x4d, 0x40, 0x4f, 0x43, 0x43, 0x45,
    0x45, 0x46, 0x48, 0x4b, 0xdd, 0xd1, 0xd2, 0xdf, 0xd8, 0xdd, 0xd4, 0xd8,
    0xd6, 0xda, 0xdf, 0xd3, 0xdb, 0xd7, 0xd1, 0xd4, 0xda, 0xdc, 0xd9, 0xd5,
    0xd3, 0xd6, 0xde, 0xdb, 0xd5, 0xd0, 0xd0, 0xde, 0xdc, 0xd9, 0xd7, 0xd2,
    0xd7, 0xd2, 0xdb, 0xd1, 0xd4, 0xde, 0xd1, 0xd7, 0xd9, 0xd4, 0xdc, 0xda,
    0xde, 0xd8, 0xd2, 0xdd, 0xd0, 0xdf, 0xd6, 0xdc, 0xda, 0xd9, 0xdd, 0xd0,
    0xdf, 0xd3, 0xd3, 0xd5, 0xd5, 0xd6, 0xd8, 0xdb, 0xbd, 0xb1, 0xb2, 0xbf,
    0xb8, 0xbd, 0xb4, 0xb8, 0xb6, 0xba, 0xbf, 0xb3, 0xbb, 0xb7, 0xb1, 0xb4,
    0xba, 0xbc, 0xb9, 0xb5, 0xb3, 0xb6, 0xbe, 0xbb, 0xb5, 0xb0, 0xb0, 0xbe,
    0xbc, 0xb9, 0xb7, 0xb2, 0xb7, 0xb2, 0xbb, 0xb1, 0xb4, 0xbe, 0xb1, 0xb7,
    0xb9, 0xb4, 0xbc, 0xba, 0xbe, 0xb8, 0xb2, 0xbd, 0xb0, 0xbf, 0xb6, 0xbc,
    0xba, 0xb9, 0xbd, 0xb0, 0xbf, 0xb3, 0xb3, 0xb5, 0xb5, 0xb6, 0xb8, 0xbb,
    0x0d, 0x01, 0x02, 0x0f, 0x08, 0x0d, 0x04, 0x08, 0x06, 0x0a, 0x0f, 0x03,
    0x0b, 0x07, 0x01, 0x04, 0x0a, 0x0c, 0x09, 0x05, 0x03, 0x06, 0x0e, 0x0b,
    0x05, 0x00, 0x00, 0x0e, 0x0c, 0x09, 0x07, 0x02, 0x07, 0x02, 0x0b, 0x01,
    0x04, 0x0e, 0x01, 0x07, 0x09, 0x04, 0x0c, 0x0a, 0x0e, 0x08, 0x02, 0x0d,
    0x00, 0x0f, 0x06, 0x0c, 0x0a, 0x09, 0x0d, 0x00, 0x0f, 0x03, 0x03, 0x05,
    0x05, 0x06, 0x08, 0x0b, 0x2d, 0x21, 0x22, 0x2f, 0x28, 0x2d, 0x24, 0x28,
    0x26, 0x2a, 0x2f, 0x23, 0x2b, 0x27, 0x21, 0x24, 0x2a, 0x2c, 0x29, 0x25,
    0x23, 0x26, 0x2e, 0x2b, 0x25, 0x20, 0x20, 0x2e, 0x2c, 0x29, 0x27, 0x22,
    0x27, 0x22, 0x2b, 0x21, 0x24, 0x2e, 0x21, 0x27, 0x29, 0x24, 0x2c, 0x2a,
    0x2e, 0x28, 0x22, 0x2d, 0x20, 0x2f, 0x26, 0x2c, 0x2a, 0x29, 0x2d, 0x20,
    0x2f, 0x23, 0x23, 0x25, 0x25, 0x26, 0x28, 0x2b, 0xbd, 0xb1, 0xb2, 0xbf,
    0xb8, 0xbd, 0xb4, 0xb8, 0xb6, 0xba, 0xbf, 0xb3, 0xbb, 0xb7, 0xb1, 0xb4,
    0xba, 0xbc, 0xb9, 0xb5, 0xb3, 0xb6, 0xbe, 0xbb, 0xb5, 0xb0, 0xb0, 0xbe,
    0xbc, 0xb9, 0xb7, 0xb2, 0xb7, 0xb2, 0xbb, 0xb1, 0xb4, 0xbe, 0xb1, 0xb7,
    0xb9, 0xb4, 0xbc, 0xba, 0xbe, 0xb8, 0xb2, 0xbd, 0xb0, 0xbf, 0xb6, 0xbc,
    0xba, 0xb9, 0xbd, 0xb0, 0xbf, 0xb3, 0xb3, 0xb5, 0xb5, 0xb6, 0xb8, 0xbb,
    0xed, 0xe1, 0xe2, 0xef, 0xe8, 0xed, 0xe4, 0xe8, 0xe6, 0xea, 0xef, 0xe3,
    0xeb, 0xe7, 0xe1, 0xe4, 0xea, 0xec, 0xe9, 0xe5, 0xe3, 0xe6, 0xee, 0xeb,
    0xe5, 0xe0, 0xe0, 0xee, 0xec, 0xe9, 0xe7, 0xe2, 0xe7, 0xe2, 0xeb, 0xe1,
    0xe4, 0xee, 0xe1, 0xe7, 0xe9, 0xe4, 0xec, 0xea, 0xee, 0xe8, 0xe2, 0xed,
    0xe0, 0xef, 0xe6, 0xec, 0xea, 0xe9, 0xed, 0xe0, 0xef, 0xe3, 0xe3, 0xe5,
    0xe5, 0xe6, 0xe8, 0xeb, 0x7d, 0x71, 0x72, 0x7f, 0x78, 0x7d, 0x74, 0x78,
    0x76, 0x7a, 0x7f, 0x73, 0x7b, 0x77, 0x71, 0x74, 0x7a, 0x7c, 0x79, 0x75,
    0x73, 0x76, 0x7e, 0x7b, 0x75, 0x70, 0x70, 0x7e, 0x7c, 0x79, 0x77, 0x72,
    0x77, 0x72, 0x7b, 0x71, 0x74, 0x7e, 0x71, 0x77, 0x79, 0x74, 0x7c, 0x7a,
    0x7e, 0x78, 0x72, 0x7d, 0x70, 0x7f, 0x76, 0x7c, 0x7a, 0x79, 0x7d, 0x70,
    0x7f, 0x73, 0x73, 0x75, 0x75, 0x76, 0x78, 0x7b, 0xfd, 0xf1, 0xf2, 0xff,
    0xf8, 0xfd, 0xf4, 0xf8, 0xf6, 0xfa, 0xff, 0xf3, 0xfb, 0xf7, 0xf1, 0xf4,
    0xfa, 0xfc, 0xf9, 0xf5, 0xf3, 0xf6, 0xfe, 0xfb, 0xf5, 0xf0, 0xf0, 0xfe,
    0xfc, 0xf9, 0xf7, 0xf2, 0xf7, 0xf2, 0xfb, 0xf1, 0xf4, 0xfe, 0xf1, 0xf7,
    0xf9, 0xf4, 0xfc, 0xfa, 0xfe, 0xf8, 0xf2, 0xfd, 0xf0, 0xff, 0xf6, 0xfc,
    0xfa, 0xf9, 0xfd, 0xf0, 0xff, 0xf3, 0xf3, 0xf5, 0xf5, 0xf6, 0xf8, 0xfb,
    0x4d, 0x41, 0x42, 0x4f, 0x48, 0x4d, 0x44, 0x48, 0x46, 0x4a, 0x4f, 0x43,
    0x4b, 0x47, 0x41, 0x44, 0x4a, 0x4c, 0x49, 0x45, 0x43, 0x46, 0x4e, 0x4b,
    0x45, 0x40, 0x40, 0x4e, 0x4c, 0x49, 0x47, 0x42, 0x47, 0x42, 0x4b, 0x41,
    0x44, 0x4e, 0x41, 0x47, 0x49, 0x44, 0x4c, 0x4a, 0x4e, 0x48, 0x42, 0x4d,
    0x40, 0x4f, 0x46, 0x4c, 0x4a, 0x49, 0x4d, 0x40, 0x4f, 0x43, 0x43, 0x45,
    0x45, 0x46, 0x48, 0x4b, 0x0d, 0x01, 0x02, 0x0f, 0x08, 0x0d, 0x04, 0x08,
    0x06, 0x0a, 0x0f, 0x03, 0x0b, 0x07, 0x01, 0x04, 0x0a, 0x0c, 0x09, 0x05,
    0x03, 0x06, 0x0e, 0x0b, 0x05, 0x00, 0x00, 0x0e, 0x0c, 0x09, 0x07, 0x02,
    0x07, 0x02, 0x0b, 0x01, 0x04, 0x0e, 0x01, 0x07, 0x09, 0x04, 0x0c, 0x0a,
    0x0e, 0x08, 0x02, 0x0d, 0x00, 0x0f, 0x06, 0x0c, 0x0a, 0x09, 0x0d, 0x00,
    0x0f, 0x03, 0x03, 0x05, 0x05, 0x06, 0x08, 0x0b, 0x9d, 0x91, 0x92, 0x9f,
    0x98, 0x9d, 0x94, 0x98, 0x96, 0x9a, 0x9f, 0x93, 0x9b, 0x97, 0x91, 0x94,
    0x9a, 0x9c, 0x99, 0x95, 0x93, 0x96, 0x9e, 0x9b, 0x95, 0x90, 0x90, 0x9e,
    0x9c, 0x99, 0x97, 0x92, 0x97, 0x92, 0x9b, 0x91, 0x94, 0x9e, 0x91, 0x97,
    0x99, 0x94, 0x9c, 0x9a, 0x9e, 0x98, 0x92, 0x9d, 0x90, 0x9f, 0x96, 0x9c,
    0x9a, 0x99, 0x9d, 0x90, 0x9f, 0x93, 0x93, 0x95, 0x95, 0x96, 0x98, 0x9b,
    0x8d, 0x81, 0x82, 0x8f, 0x88, 0x8d, 0x84, 0x88, 0x86, 0x8a, 0x8f, 0x83,
    0x8b, 0x87, 0x81, 0x84, 0x8a, 0x8c, 0x89, 0x85, 0x83, 0x86, 0x8e, 0x8b,
    0x85, 0x80, 0x80, 0x8e, 0x8c, 0x89, 0x87, 0x82, 0x87, 0x82, 0x8b, 0x81,
    0x84, 0x8e, 0x81, 0x87, 0x89, 0x84, 0x8c, 0x8a, 0x8e, 0x88, 0x82, 0x8d,
    0x80, 0x8f, 0x86, 0x8c, 0x8a, 0x89, 0x8d, 0x80, 0x8f, 0x83, 0x83, 0x85,
    0x85, 0x86, 0x88, 0x8b, 0x1d, 0x11, 0x12, 0x1f, 0x18, 0x1d, 0x14, 0x18,
    0x16, 0x1a, 0x1f, 0x13, 0x1b, 0x17, 0x11, 0x14, 0x1a, 0x1c, 0x19, 0x15,
    0x13, 0x16, 0x1e, 0x1b, 0x15, 0x10, 0x10, 0x1e, 0x1c, 0x19, 0x17, 0x12,
    0x17, 0x12, 0x1b, 0x11, 0x14, 0x1e, 0x11, 0x17, 0x19, 0x14, 0x1c, 0x1a,
    0x1e, 0x18, 0x12, 0x1d, 0x10, 0x1f, 0x16, 0x1c, 0x1a, 0x19, 0x1d, 0x10,
    0x1f, 0x13, 0x13, 0x15, 0x15, 0x16, 0x18, 0x1b, 0xdd, 0xd1, 0xd2, 0xdf,
    0xd8, 0xdd, 0xd4, 0xd8, 0xd6, 0xda, 0xdf, 0xd3, 0xdb, 0xd7, 0xd1, 0xd4,
    0xda, 0xdc, 0xd9, 0xd5, 0xd3, 0xd6, 0xde, 0xdb, 0xd5, 0xd0, 0xd0, 0xde,
    0xdc, 0xd9, 0xd7, 0xd2, 0xd7, 0xd2, 0xdb, 0xd1, 0xd4, 0xde, 0xd1, 0xd7,
    0xd9, 0xd4, 0xdc, 0xda, 0xde, 0xd8, 0xd2, 0xdd, 0xd0, 0xdf, 0xd6, 0xdc,
    0xda, 0xd9, 0xdd, 0xd0, 0xdf, 0xd3, 0xd3, 0xd5, 0xd5, 0xd6, 0xd8, 0xdb,
    0xad, 0xa1, 0xa2, 0xaf, 0xa8, 0xad, 0xa4, 0xa8, 0xa6, 0xaa, 0xaf, 0xa3,
    0xab, 0xa7, 0xa1, 0xa4, 0xaa, 0xac, 0xa9, 0xa5, 0xa3, 0xa6, 0xae, 0xab,
    0xa5, 0xa0, 0xa0, 0xae, 0xac, 0xa9, 0xa7, 0xa2, 0xa7, 0xa2, 0xab, 0xa1,
    0xa4, 0xae, 0xa1, 0xa7, 0xa9, 0xa4, 0xac, 0xaa, 0xae, 0xa8, 0xa2, 0xad,
    0xa0, 0xaf, 0xa6, 0xac, 0xaa, 0xa9, 0xad, 0xa0, 0xaf, 0xa3, 0xa3, 0xa5,
    0xa5, 0xa6, 0xa8, 0xab, 0x3d, 0x31, 0x32, 0x3f, 0x38, 0x3d, 0x34, 0x38,
    0x36, 0x3a, 0x3f, 0x33, 0x3b, 0x37, 0x31, 0x34, 0x3a, 0x3c, 0x39, 0x35,
    0x33, 0x36, 0x3e, 0x3b, 0x35, 0x30, 0x30, 0x3e, 0x3c, 0x39, 0x37, 0x32,
    0x37, 0x32, 0x3b, 0x31, 0x34, 0x3e, 0x31, 0x37, 0x39, 0x34, 0x3c, 0x3a,
    0x3e, 0x38, 0x32, 0x3d, 0x30, 0x3f, 0x36, 0x3c, 0x3a, 0x39, 0x3d, 0x30,
    0x3f, 0x33, 0x33, 0x35, 0x35, 0x36, 0x38, 0x3b, 0xed, 0xe1, 0xe2, 0xef,
    0xe8, 0xed, 0xe4, 0xe8, 0xe6, 0xea, 0xef, 0xe3, 0xeb, 0xe7, 0xe1, 0xe4,
    0xea, 0xec, 0xe9, 0xe5, 0xe3, 0xe6, 0xee, 0xeb, 0xe5, 0xe0, 0xe0, 0xee,
    0xec, 0xe9, 0xe7, 0xe2, 0xe7, 0xe2, 0xeb, 0xe1, 0xe4, 0xee, 0xe1, 0xe7,
    0xe9, 0xe4, 0xec, 0xea, 0xee, 0xe8, 0xe2, 0xed, 0xe0, 0xef, 0xe6, 0xec,
    0xea, 0xe9, 0xed, 0xe0, 0xef, 0xe3, 0xe3, 0xe5, 0xe5, 0xe6, 0xe8, 0xeb,
    0xcd, 0xc1, 0xc2, 0xcf, 0xc8, 0xcd, 0xc4, 0xc8, 0xc6, 0xca, 0xcf, 0xc3,
    0xcb, 0xc7, 0xc1, 0xc4, 0xca, 0xcc, 0xc9, 0xc5, 0xc3, 0xc6, 0xce, 0xcb,
    0xc5, 0xc0, 0xc0, 0xce, 0xcc, 0xc9, 0xc7, 0xc2, 0xc7, 0xc2, 0xcb, 0xc1,
    0xc4, 0xce, 0xc1, 0xc7, 0xc9, 0xc4, 0xcc, 0xca, 0xce, 0xc8, 0xc2, 0xcd,
    0xc0, 0xcf, 0xc6, 0xcc, 0xca, 0xc9, 0xcd, 0xc0, 0xcf, 0xc3, 0xc3, 0xc5,
    0xc5, 0xc6, 0xc8, 0xcb, 0x3d, 0x31, 0x32, 0x3f, 0x38, 0x3d, 0x34, 0x38,
    0x36, 0x3a, 0x3f, 0x33, 0x3b, 0x37, 0x31, 0x34, 0x3a, 0x3c, 0x39, 0x35,
    0x33, 0x36, 0x3e, 0x3b, 0x35, 0x30, 0x30, 0x3e, 0x3c, 0x39, 0x37, 0x32,
    0x37, 0x32, 0x3b, 0x31, 0x34, 0x3e, 0x31, 0x37, 0x39, 0x34, 0x3c, 0x3a,
    0x3e, 0x38, 0x32, 0x3d, 0x30, 0x3f, 0x36, 0x3c, 0x3a, 0x39, 0x3d, 0x30,
    0x3f, 0x33, 0x33, 0x35, 0x35, 0x36, 0x38, 0x3b, 0x9d, 0x91, 0x92, 0x9f,
    0x98, 0x9d, 0x94, 0x98, 0x96, 0x9a, 0x9f, 0x93, 0x9b, 0x97, 0x91, 0x94,
    0x9a, 0x9c, 0x99, 0x95, 0x93, 0x96, 0x9e, 0x9b, 0x95, 0x90, 0x90, 0x9e,
    0x9c, 0x99, 0x97, 0x92, 0x97, 0x92, 0x9b, 0x91, 0x94, 0x9e, 0x91, 0x97,
    0x99, 0x94, 0x9c, 0x9a, 0x9e, 0x98, 0x92, 0x9d, 0x90, 0x9f, 0x96, 0x9c,
    0x9a, 0x99, 0x9d, 0x90, 0x9f, 0x93, 0x93, 0x95, 0x95, 0x96, 0x98, 0x9b,
    0x5d, 0x51, 0x52, 0x5f, 0x58, 0x5d, 0x54, 0x58, 0x56, 0x5a, 0x5f, 0x53,
    0x5b, 0x57, 0x51, 0x54, 0x5a, 0x5c, 0x59, 0x55, 0x53, 0x56, 0x5e, 0x5b,
    0x55, 0x50, 0x50, 0x5e, 0x5c, 0x59, 0x57, 0x52, 0x57, 0x52, 0x5b, 0x51,
    0x54, 0x5e, 0x51, 0x57, 0x59, 0x54, 0x5c, 0x5a, 0x5e, 0x58, 0x52, 0x5d,
    0x50, 0x5f, 0x56, 0x5c, 0x5a, 0x59, 0x5d, 0x50, 0x5f, 0x53, 0x53, 0x55,
    0x55, 0x56, 0x58, 0x5b, 0x7d, 0x71, 0x72, 0x7f, 0x78, 0x7d, 0x74, 0x78,
    0x76, 0x7a, 0x7f, 0x73, 0x7b, 0x77, 0x71, 0x74, 0x7a, 0x7c, 0x79, 0x75,
    0x73, 0x76, 0x7e, 0x7b, 0x75, 0x70, 0x70, 0x7e, 0x7c, 0x79, 0x77, 0x72,
    0x77, 0x72, 0x7b, 0x71, 0x74, 0x7e, 0x71, 0x77, 0x79, 0x74, 0x7c, 0x7a,
    0x7e, 0x78, 0x72, 0x7d, 0x70, 0x7f, 0x76, 0x7c, 0x7a, 0x79, 0x7d, 0x70,
    0x7f, 0x73, 0x73, 0x75, 0x75, 0x76, 0x78, 0x7b, 0xcd, 0xc1, 0xc2, 0xcf,
    0xc8, 0xcd, 0xc4, 0xc8, 0xc6, 0xca, 0xcf, 0xc3, 0xcb, 0xc7, 0xc1, 0xc4,
    0xca, 0xcc, 0xc9, 0xc5, 0xc3, 0xc6, 0xce, 0xcb, 0xc5, 0xc0, 0xc0, 0xce,
    0xcc, 0xc9, 0xc7, 0xc2, 0xc7, 0xc2, 0xcb, 0xc1, 0xc4, 0xce, 0xc1, 0xc7,
    0xc9, 0xc4, 0xcc, 0xca, 0xce, 0xc8, 0xc2, 0xcd, 0xc0, 0xcf, 0xc6, 0xcc,
    0xca, 0xc9, 0xcd, 0xc0, 0xcf, 0xc3, 0xc3, 0xc5, 0xc5, 0xc6, 0xc8, 0xcb,
    0x5d, 0x51, 0x52, 0x5f, 0x58, 0x5d, 0x54, 0x58, 0x56, 0x5a, 0x5f, 0x53,
    0x5b, 0x57, 0x51, 0x54, 0x5a, 0x5c, 0x59, 0x55, 0x53, 0x56, 0x5e, 0x5b,
    0x55, 0x50, 0x50, 0x5e, 0x5c, 0x59, 0x57, 0x52, 0x57, 0x52, 0x5b, 0x51,
    0x54, 0x5e, 0x51, 0x57, 0x59, 0x54, 0x5c, 0x5a, 0x5e, 0x58, 0x52, 0x5d,
    0x50, 0x5f, 0x56, 0x5c, 0x5a, 0x59, 0x5d, 0x50, 0x5f, 0x53, 0x53, 0x55,
    0x55, 0x56, 0x58, 0x5b, 0x2d, 0x21, 0x22, 0x2f, 0x28, 0x2d, 0x24, 0x28,
    0x26, 0x2a, 0x2f, 0x23, 0x2b, 0x27, 0x21, 0x24, 0x2a, 0x2c, 0x29, 0x25,
    0x23, 0x26, 0x2e, 0x2b, 0x25, 0x20, 0x20, 0x2e, 0x2c, 0x29, 0x27, 0x22,
    0x27, 0x22, 0x2b, 0x21, 0x24, 0x2e, 0x21, 0x27, 0x29, 0x24, 0x2c, 0x2a,
    0x2e, 0x28, 0x22, 0x2d, 0x20, 0x2f, 0x26, 0x2c, 0x2a, 0x29, 0x2d, 0x20,
    0x2f, 0x23, 0x23, 0x25, 0x25, 0x26, 0x28, 0x2b, 0xad, 0xa1, 0xa2, 0xaf,
    0xa8, 0xad, 0xa4, 0xa8, 0xa6, 0xaa, 0xaf, 0xa3, 0xab, 0xa7, 0xa1, 0xa4,
    0xaa, 0xac, 0xa9, 0xa5, 0xa3, 0xa6, 0xae, 0xab, 0xa5, 0xa0, 0xa0, 0xae,
    0xac, 0xa9, 0xa7, 0xa2, 0xa7, 0xa2, 0xab, 0xa1, 0xa4, 0xae, 0xa1, 0xa7,
    0xa9, 0xa4, 0xac, 0xaa, 0xae, 0xa8, 0xa2, 0xad, 0xa0, 0xaf, 0xa6, 0xac,
    0xaa, 0xa9, 0xad, 0xa0, 0xaf, 0xa3, 0xa3, 0xa5, 0xa5, 0xa6, 0xa8, 0xab,
    0xfd, 0xf1, 0xf2, 0xff, 0xf8, 0xfd, 0xf4, 0xf8, 0xf6, 0xfa, 0xff, 0xf3,
    0xfb, 0xf7, 0xf1, 0xf4, 0xfa, 0xfc, 0xf9, 0xf5, 0xf3, 0xf6, 0xfe, 0xfb,
    0xf5, 0xf0, 0xf0, 0xfe, 0xfc, 0xf9, 0xf7, 0xf2, 0xf7, 0xf2, 0xfb, 0xf1,
    0xf4, 0xfe, 0xf1, 0xf7, 0xf9, 0xf4, 0xfc, 0xfa, 0xfe, 0xf8, 0xf2, 0xfd,
    0xf0, 0xff, 0xf6, 0xfc, 0xfa, 0xf9, 0xfd, 0xf0, 0xff, 0xf3, 0xf3, 0xf5,
    0xf5, 0xf6, 0xf8, 0xfb, 0x6d, 0x61, 0x62, 0x6f, 0x68, 0x6d, 0x64, 0x68,
    0x66, 0x6a, 0x6f, 0x63, 0x6b, 0x67, 0x61, 0x64, 0x6a, 0x6c, 0x69, 0x65,
    0x63, 0x66, 0x6e, 0x6b, 0x65, 0x60, 0x60, 0x6e, 0x6c, 0x69, 0x67, 0x62,
    0x67, 0x62, 0x6b, 0x61, 0x64, 0x6e, 0x61, 0x67, 0x69, 0x64, 0x6c, 0x6a,
    0x6e, 0x68, 0x62, 0x6d, 0x60, 0x6f, 0x66, 0x6c, 0x6a, 0x69, 0x6d, 0x60,
    0x6f, 0x63, 0x63, 0x65, 0x65, 0x66, 0x68, 0x6b, 0x8d, 0x81, 0x82, 0x8f,
    0x88, 0x8d, 0x84, 0x88, 0x86, 0x8a, 0x8f, 0x83, 0x8b, 0x87, 0x81, 0x84,
    0x8a, 0x8c, 0x89, 0x85, 0x83, 0x86, 0x8e, 0x8b, 0x85, 0x80, 0x80, 0x8e,
    0x8c, 0x89, 0x87, 0x82, 0x87, 0x82, 0x8b, 0x81, 0x84, 0x8e, 0x81, 0x87,
    0x89, 0x84, 0x8c, 0x8a, 0x8e, 0x88, 0x82, 0x8d, 0x80, 0x8f, 0x86, 0x8c,
    0x8a, 0x89, 0x8d, 0x80, 0x8f, 0x83, 0x83, 0x85, 0x85, 0x86, 0x88, 0x8b,
    0x1d, 0x11, 0x12, 0x1f, 0x18, 0x1d, 0x14, 0x18, 0x16, 0x1a, 0x1f, 0x13,
    0x1b, 0x17, 0x11, 0x14, 0x1a, 0x1c, 0x19, 0x15, 0x13, 0x16, 0x1e, 0x1b,
    0x15, 0x10, 0x10, 0x1e, 0x1c, 0x19, 0x17, 0x12, 0x17, 0x12, 0x1b, 0x11,
    0x14, 0x1e, 0x11, 0x17, 0x19, 0x14, 0x1c, 0x1a, 0x1e, 0x18, 0x12, 0x1d,
    0x10, 0x1f, 0x16, 0x1c, 0x1a, 0x19, 0x1d, 0x10, 0x1f, 0x13, 0x13, 0x15,
    0x15, 0x16, 0x18, 0x1b, 0x6d, 0x61, 0x62, 0x6f, 0x68, 0x6d, 0x64, 0x68,
    0x66, 0x6a, 0x6f, 0x63, 0x6b, 0x67, 0x61, 0x64, 0x6a, 0x6c, 0x69, 0x65,
    0x63, 0x66, 0x6e, 0x6b, 0x65, 0x60, 0x60, 0x6e, 0x6c, 0x69, 0x67, 0x62,
    0x67, 0x62, 0x6b, 0x61, 0x64, 0x6e, 0x61, 0x67, 0x69, 0x64, 0x6c, 0x6a,
    0x6e, 0x68, 0x62, 0x6d, 0x60, 0x6f, 0x66, 0x6c, 0x6a, 0x69, 0x6d, 0x60,
    0x6f, 0x63, 0x63, 0x65, 0x65, 0x66, 0x68, 0x6b, 0x1d, 0x11, 0x12, 0x1f,
    0x18, 0x1d, 0x14, 0x18, 0x16, 0x1a, 0x1f, 0x13, 0x1b, 0x17, 0x11, 0x14,
    0x1a, 0x1c, 0x19, 0x15, 0x13, 0x16, 0x1e, 0x1b, 0x15, 0x10, 0x10, 0x1e,
    0x1c, 0x19, 0x17, 0x12, 0x17, 0x12, 0x1b, 0x11, 0x14, 0x1e, 0x11, 0x17,
    0x19, 0x14, 0x1c, 0x1a, 0x1e, 0x18, 0x12, 0x1d, 0x10, 0x1f, 0x16, 0x1c,
    0x1a, 0x19, 0x1d, 0x10, 0x1f, 0x13, 0x13, 0x15, 0x15, 0x16, 0x18, 0x1b,
    0x6d, 0x61, 0x62, 0x6f, 0x68, 0x6d, 0x64, 0x68, 0x66, 0x6a, 0x6f, 0x63,
    0x6b, 0x67, 0x61, 0x64, 0x6a, 0x6c, 0x69, 0x65, 0x63, 0x66, 0x6e, 0x6b,
    0x65, 0x60, 0x60, 0x6e, 0x6c, 0x69, 0x67, 0x62, 0x67, 0x62, 0x6b, 0x61,
    0x64, 0x6e, 0x61, 0x67, 0x69, 0x64, 0x6c, 0x6a, 0x6e, 0x68, 0x62, 0x6d,
    0x60, 0x6f, 0x66, 0x6c, 0x6a, 0x69, 0x6d, 0x60, 0x6f, 0x63, 0x63, 0x65,
    0x65, 0x66, 0x68, 0x6b, 0x4d, 0x41, 0x42, 0x4f, 0x48, 0x4d, 0x44, 0x48,
    0x46, 0x4a, 0x4f, 0x43, 0x4b, 0x47, 0x41, 0x44, 0x4a, 0x4c, 0x49, 0x45,
    0x43, 0x46, 0x4e, 0x4b, 0x45, 0x40, 0x40, 0x4e, 0x4c, 0x49, 0x47, 0x42,
    0x47, 0x42, 0x4b, 0x41, 0x44, 0x4e, 0x41, 0x47, 0x49, 0x44, 0x4c, 0x4a,
    0x4e, 0x48, 0x42, 0x4d, 0x40, 0x4f, 0x46, 0x4c, 0x4a, 0x49, 0x4d, 0x40,
    0x4f, 0x43, 0x43, 0x45, 0x45, 0x46, 0x48, 0x4b, 0xbd, 0xb1, 0xb2, 0xbf,
    0xb8, 0xbd, 0xb4, 0xb8, 0xb6, 0xba, 0xbf, 0xb3, 0xbb, 0xb7, 0xb1, 0xb4,
    0xba, 0xbc, 0xb9, 0xb5, 0xb3, 0xb6, 0xbe, 0xbb, 0xb5, 0xb0, 0xb0, 0xbe,
    0xbc, 0xb9, 0xb7, 0xb2, 0xb7, 0xb2, 0xbb, 0xb1, 0xb4, 0xbe, 0xb1, 0xb7,
    0xb9, 0xb4, 0xbc, 0xba, 0xbe, 0xb8, 0xb2, 0xbd, 0xb0, 0xbf, 0xb6, 0xbc,
    0xba, 0xb9, 0xbd, 0xb0, 0xbf, 0xb3, 0xb3, 0xb5, 0xb5, 0xb6, 0xb8, 0xbb,
    0xbd, 0xb1, 0xb2, 0xbf, 0xb8, 0xbd, 0xb4, 0xb8, 0xb6, 0xba, 0xbf, 0xb3,
    0xbb, 0xb7, 0xb1, 0xb4, 0xba, 0xbc, 0xb9, 0xb5, 0xb3, 0xb6, 0xbe, 0xbb,
    0xb5, 0xb0, 0xb0, 0xbe, 0xbc, 0xb9, 0xb7, 0xb2, 0xb7, 0xb2, 0xbb, 0xb1,
    0xb4, 0xbe, 0xb1, 0xb7, 0xb9, 0xb4, 0xbc, 0xba, 0xbe, 0xb8, 0xb2, 0xbd,
    0xb0, 0xbf, 0xb6, 0xbc, 0xba, 0xb9, 0xbd, 0xb0, 0xbf, 0xb3, 0xb3, 0xb5,
    0xb5, 0xb6, 0xb8, 0xbb, 0xdd, 0xd1, 0xd2, 0xdf, 0xd8, 0xdd, 0xd4, 0xd8,
    0xd6, 0xda, 0xdf, 0xd3, 0xdb, 0xd7, 0xd1, 0xd4, 0xda, 0xdc, 0xd9, 0xd5,
    0xd3, 0xd6, 0xde, 0xdb, 0xd5, 0xd0, 0xd0, 0xde, 0xdc, 0xd9, 0xd7, 0xd2,
    0xd7, 0xd2, 0xdb, 0xd1, 0xd4, 0xde, 0xd1, 0xd7, 0xd9, 0xd4, 0xdc, 0xda,
    0xde, 0xd8, 0xd2, 0xdd, 0xd0, 0xdf, 0xd6, 0xdc, 0xda, 0xd9, 0xdd, 0xd0,
    0xdf, 0xd3, 0xd3, 0xd5, 0xd5, 0xd6, 0xd8, 0xdb, 0xdd, 0xd1, 0xd2, 0xdf,
    0xd8, 0xdd, 0xd4, 0xd8, 0xd6, 0xda, 0xdf, 0xd3, 0xdb, 0xd7, 0xd1, 0xd4,
    0xda, 0xdc, 0xd9, 0xd5, 0xd3, 0xd6, 0xde, 0xdb, 0xd5, 0xd0, 0xd0, 0xde,
    0xdc, 0xd9, 0xd7, 0xd2, 0xd7, 0xd2, 0xdb, 0xd1, 0xd4, 0xde, 0xd1, 0xd7,
    0xd9, 0xd4, 0xdc, 0xda, 0xde, 0xd8, 0xd2, 0xdd, 0xd0, 0xdf, 0xd6, 0xdc,
    0xda, 0xd9, 0xdd, 0xd0, 0xdf, 0xd3, 0xd3, 0xd5, 0xd5, 0xd6, 0xd8, 0xdb,
    0x8d, 0x81, 0x82, 0x8f, 0x88, 0x8d, 0x84, 0x88, 0x86, 0x8a, 0x8f, 0x83,
    0x8b, 0x87, 0x81, 0x84, 0x8a, 0x8c, 0x89, 0x85, 0x83, 0x86, 0x8e, 0x8b,
    0x85, 0x80, 0x80, 0x8e, 0x8c, 0x89, 0x87, 0x82, 0x87, 0x82, 0x8b, 0x81,
    0x84, 0x8e, 0x81, 0x87, 0x89, 0x84, 0x8c, 0x8a, 0x8e, 0x88, 0x82, 0x8d,
    0x80, 0x8f, 0x86, 0x8c, 0x8a, 0x89, 0x8d, 0x80, 0x8f, 0x83, 0x83, 0x85,
    0x85, 0x86, 0x88, 0x8b, 0xcd, 0xc1, 0xc2, 0xcf, 0xc8, 0xcd, 0xc4, 0xc8,
    0xc6, 0xca, 0xcf, 0xc3, 0xcb, 0xc7, 0xc1, 0xc4, 0xca, 0xcc, 0xc9, 0xc5,
    0xc3, 0xc6, 0xce, 0xcb, 0xc5, 0xc0, 0xc0, 0xce, 0xcc, 0xc9, 0xc7, 0xc2,
    0xc7, 0xc2, 0xcb, 0xc1, 0xc4, 0xce, 0xc1, 0xc7, 0xc9, 0xc4, 0xcc, 0xca,
    0xce, 0xc8, 0xc2, 0xcd, 0xc0, 0xcf, 0xc6, 0xcc, 0xca, 0xc9, 0xcd, 0xc0,
    0xcf, 0xc3, 0xc3, 0xc5, 0xc5, 0xc6, 0xc8, 0xcb, 0x1d, 0x11, 0x12, 0x1f,
    0x18, 0x1d, 0x14, 0x18, 0x16, 0x1a, 0x1f, 0x13, 0x1b, 0x17, 0x11, 0x14,
    0x1a, 0x1c, 0x19, 0x15, 0x13, 0x16, 0x1e, 0x1b, 0x15, 0x10, 0x10, 0x1e,
    0x1c, 0x19, 0x17, 0x12, 0x17, 0x12, 0x1b, 0x11, 0x14, 0x1e, 0x11, 0x17,
    0x19, 0x14, 0x1c, 0x1a, 0x1e, 0x18, 0x12, 0x1d, 0x10, 0x1f, 0x16, 0x1c,
    0x1a, 0x19, 0x1d, 0x10, 0x1f, 0x13, 0x13, 0x15, 0x15, 0x16, 0x18, 0x1b,
    0x3d, 0x31, 0x32, 0x3f, 0x38, 0x3d, 0x34, 0x38, 0x36, 0x3a, 0x3f, 0x33,
    0x3b, 0x37, 0x31, 0x34, 0x3a, 0x3c, 0x39, 0x35, 0x33, 0x36, 0x3e, 0x3b,
    0x35, 0x30, 0x30, 0x3e, 0x3c, 0x39, 0x37, 0x32, 0x37, 0x32, 0x3b, 0x31,
    0x34, 0x3e, 0x31, 0x37, 0x39, 0x34, 0x3c, 0x3a, 0x3e, 0x38, 0x32, 0x3d,
    0x30, 0x3f, 0x36, 0x3c, 0x3a, 0x39, 0x3d, 0x30, 0x3f, 0x33, 0x33, 0x35,
    0x35, 0x36, 0x38, 0x3b, 0x4d, 0x41, 0x42, 0x4f, 0x48, 0x4d, 0x44, 0x48,
    0x46, 0x4a, 0x4f, 0x43, 0x4b, 0x47, 0x41, 0x44, 0x4a, 0x4c, 0x49, 0x45,
    0x43, 0x46, 0x4e, 0x4b, 0x45, 0x40, 0x40, 0x4e, 0x4c, 0x49, 0x47, 0x42,
    0x47, 0x42, 0x4b, 0x41, 0x44, 0x4e, 0x41, 0x47, 0x49, 0x44, 0x4c, 0x4a,
    0x4e, 0x48, 0x42, 0x4d, 0x40, 0x4f, 0x46, 0x4c, 0x4a, 0x49, 0x4d, 0x40,
    0x4f, 0x43, 0x43, 0x45, 0x45, 0x46, 0x48, 0x4b, 0x7d, 0x71, 0x72, 0x7f,
    0x78, 0x7d, 0x74, 0x78, 0x76, 0x7a, 0x7f, 0x73, 0x7b, 0x77, 0x71, 0x74,
    0x7a, 0x7c, 0x79, 0x75, 0x73, 0x76, 0x7e, 0x7b, 0x75, 0x70, 0x70, 0x7e,
    0x7c, 0x79, 0x77, 0x72, 0x77, 0x72, 0x7b, 0x71, 0x74, 0x7e, 0x71, 0x77,
    0x79, 0x74, 0x7c, 0x7a, 0x7e, 0x78, 0x72, 0x7d, 0x70, 0x7f, 0x76, 0x7c,
    0x7a, 0x79, 0x7d, 0x70, 0x7f, 0x73, 0x73, 0x75, 0x75, 0x76, 0x78, 0x7b,
    0xad, 0xa1, 0xa2, 0xaf, 0xa8, 0xad, 0xa4, 0xa8, 0xa6, 0xaa, 0xaf, 0xa3,
    0xab, 0xa7, 0xa1, 0xa4, 0xaa, 0xac, 0xa9, 0xa5, 0xa3, 0xa6, 0xae, 0xab,
    0xa5, 0xa0, 0xa0, 0xae, 0xac, 0xa9, 0xa7, 0xa2, 0xa7, 0xa2, 0xab, 0xa1,
    0xa4, 0xae, 0xa1, 0xa7, 0xa9, 0xa4, 0xac, 0xaa, 0xae, 0xa8, 0xa2, 0xad,
    0xa0, 0xaf, 0xa6, 0xac, 0xaa, 0xa9, 0xad, 0xa0, 0xaf, 0xa3, 0xa3, 0xa5,
    0xa5, 0xa6, 0xa8, 0xab, 0xed, 0xe1, 0xe2, 0xef, 0xe8, 0xed, 0xe4, 0xe8,
    0xe6, 0xea, 0xef, 0xe3, 0xeb, 0xe7, 0xe1, 0xe4, 0xea, 0xec, 0xe9, 0xe5,
    0xe3, 0xe6, 0xee, 0xeb, 0xe5, 0xe0, 0xe0, 0xee, 0xec, 0xe9, 0xe7, 0xe2,
    0xe7, 0xe2, 0xeb, 0xe1, 0xe4, 0xee, 0xe1, 0xe7, 0xe9, 0xe4, 0xec, 0xea,
    0xee, 0xe8, 0xe2, 0xed, 0xe0, 0xef, 0xe6, 0xec, 0xea, 0xe9, 0xed, 0xe0,
    0xef, 0xe3, 0xe3, 0xe5, 0xe5, 0xe6, 0xe8, 0xeb, 0x7d, 0x71, 0x72, 0x7f,
    0x78, 0x7d, 0x74, 0x78, 0x76, 0x7a, 0x7f, 0x73, 0x7b, 0x77, 0x71, 0x74,
    0x7a, 0x7c, 0x79, 0x75, 0x73, 0x76, 0x7e, 0x7b, 0x75, 0x70, 0x70, 0x7e,
    0x7c, 0x79, 0x77, 0x72, 0x77, 0x72, 0x7b, 0x71, 0x74, 0x7e, 0x71, 0x77,
    0x79, 0x74, 0x7c, 0x7a, 0x7e, 0x78, 0x72, 0x7d, 0x70, 0x7f, 0x76, 0x7c,
    0x7a, 0x79, 0x7d, 0x70, 0x7f, 0x73, 0x73, 0x75, 0x75, 0x76, 0x78, 0x7b,
    0xad, 0xa1, 0xa2, 0xaf, 0xa8, 0xad, 0xa4, 0xa8, 0xa6, 0xaa, 0xaf, 0xa3,
    0xab, 0xa7, 0xa1, 0xa4, 0xaa, 0xac, 0xa9, 0xa5, 0xa3, 0xa6, 0xae, 0xab,
    0xa5, 0xa0, 0xa0, 0xae, 0xac, 0xa9, 0xa7, 0xa2, 0xa7, 0xa2, 0xab, 0xa1,
    0xa4, 0xae, 0xa1, 0xa7, 0xa9, 0xa4, 0xac, 0xaa, 0xae, 0xa8, 0xa2, 0xad,
    0xa0, 0xaf, 0xa6, 0xac, 0xaa, 0xa9, 0xad, 0xa0, 0xaf, 0xa3, 0xa3, 0xa5,
    0xa5, 0xa6, 0xa8, 0xab, 0x9d, 0x91, 0x92, 0x9f, 0x98, 0x9d, 0x94, 0x98,
    0x96, 0x9a, 0x9f, 0x93, 0x9b, 0x97, 0x91, 0x94, 0x9a, 0x9c, 0x99, 0x95,
    0x93, 0x96, 0x9e, 0x9b, 0x95, 0x90, 0x90, 0x9e, 0x9c, 0x99, 0x97, 0x92,
    0x97, 0x92, 0x9b, 0x91, 0x94, 0x9e, 0x91, 0x97, 0x99, 0x94, 0x9c, 0x9a,
    0x9e, 0x98, 0x92, 0x9d, 0x90, 0x9f, 0x96, 0x9c, 0x9a, 0x99, 0x9d, 0x90,
    0x9f, 0x93, 0x93, 0x95, 0x95, 0x96, 0x98, 0x9b, 0xfd, 0xf1, 0xf2, 0xff,
    0xf8, 0xfd, 0xf4, 0xf8, 0xf6, 0xfa, 0xff, 0xf3, 0xfb, 0xf7, 0xf1, 0xf4,
    0xfa, 0xfc, 0xf9, 0xf5, 0xf3, 0xf6, 0xfe, 0xfb, 0xf5, 0xf0, 0xf0, 0xfe,
    0xfc, 0xf9, 0xf7, 0xf2, 0xf7, 0xf2, 0xfb, 0xf1, 0xf4, 0xfe, 0xf1, 0xf7,
    0xf9, 0xf4, 0xfc, 0xfa, 0xfe, 0xf8, 0xf2, 0xfd, 0xf0, 0xff, 0xf6, 0xfc,
    0xfa, 0xf9, 0xfd, 0xf0, 0xff, 0xf3, 0xf3, 0xf5, 0xf5, 0xf6, 0xf8, 0xfb,
    0x5d, 0x51, 0x52, 0x5f, 0x58, 0x5d, 0x54, 0x58, 0x56, 0x5a, 0x5f, 0x53,
    0x5b, 0x57, 0x51, 0x54, 0x5a, 0x5c, 0x59, 0x55, 0x53, 0x56, 0x5e, 0x5b,
    0x55, 0x50, 0x50, 0x5e, 0x5c, 0x59, 0x57, 0x52, 0x57, 0x52, 0x5b, 0x51,
    0x54, 0x5e, 0x51, 0x57, 0x59, 0x54, 0x5c, 0x5a, 0x5e, 0x58, 0x52, 0x5d,
    0x50, 0x5f, 0x56, 0x5c, 0x5a, 0x59, 0x5d, 0x50, 0x5f, 0x53, 0x53, 0x55,
    0x55, 0x56, 0x58, 0x5b, 0x6d, 0x61, 0x62, 0x6f, 0x68, 0x6d, 0x64, 0x68,
    0x66, 0x6a, 0x6f, 0x63, 0x6b, 0x67, 0x61, 0x64, 0x6a, 0x6c, 0x69, 0x65,
    0x63, 0x66, 0x6e, 0x6b, 0x65, 0x60, 0x60, 0x6e, 0x6c, 0x69, 0x67, 0x62,
    0x67, 0x62, 0x6b, 0x61, 0x64, 0x6e, 0x61, 0x67, 0x69, 0x64, 0x6c, 0x6a,
    0x6e, 0x68, 0x62, 0x6d, 0x60, 0x6f, 0x66, 0x6c, 0x6a, 0x69, 0x6d, 0x60,
    0x6f, 0x63, 0x63, 0x65, 0x65, 0x66, 0x68, 0x6b, 0x0d, 0x01, 0x02, 0x0f,
    0x08, 0x0d, 0x04, 0x08, 0x06, 0x0a, 0x0f, 0x03, 0x0b, 0x07, 0x01, 0x04,
    0x0a, 0x0c, 0x09, 0x05, 0x03, 0x06, 0x0e, 0x0b, 0x05, 0x00, 0x00, 0x0e,
    0x0c, 0x09, 0x07, 0x02, 0x07, 0x02, 0x0b, 0x01, 0x04, 0x0e, 0x01, 0x07,
    0x09, 0x04, 0x0c, 0x0a, 0x0e, 0x08, 0x02, 0x0d, 0x00, 0x0f, 0x06, 0x0c,
    0x0a, 0x09, 0x0d, 0x00, 0x0f, 0x03, 0x03, 0x05, 0x05, 0x06, 0x08, 0x0b,
    0x8d, 0x81, 0x82, 0x8f, 0x88, 0x8d, 0x84, 0x88, 0x86, 0x8a, 0x8f, 0x83,
    0x8b, 0x87, 0x81, 0x84, 0x8a, 0x8c, 0x89, 0x85, 0x83, 0x86, 0x8e, 0x8b,
    0x85, 0x80, 0x80, 0x8e, 0x8c, 0x89, 0x87, 0x82, 0x87, 0x82, 0x8b, 0x81,
    0x84, 0x8e, 0x81, 0x87, 0x89, 0x84, 0x8c, 0x8a, 0x8e, 0x88, 0x82, 0x8d,
    0x80, 0x8f, 0x86, 0x8c, 0x8a, 0x89, 0x8d, 0x80, 0x8f, 0x83, 0x83, 0x85,
    0x85, 0x86, 0x88, 0x8b, 0xfd, 0xf1, 0xf2, 0xff, 0xf8, 0xfd, 0xf4, 0xf8,
    0xf6, 0xfa, 0xff, 0xf3, 0xfb, 0xf7, 0xf1, 0xf4, 0xfa, 0xfc, 0xf9, 0xf5,
    0xf3, 0xf6, 0xfe, 0xfb, 0xf5, 0xf0, 0xf0, 0xfe, 0xfc, 0xf9, 0xf7, 0xf2,
    0xf7, 0xf2, 0xfb, 0xf1, 0xf4, 0xfe, 0xf1, 0xf7, 0xf9, 0xf4, 0xfc, 0xfa,
    0xfe, 0xf8, 0xf2, 0xfd, 0xf0, 0xff, 0xf6, 0xfc, 0xfa, 0xf9, 0xfd, 0xf0,
    0xff, 0xf3, 0xf3, 0xf5, 0xf5, 0xf6, 0xf8, 0xfb, 0x0d, 0x01, 0x02, 0x0f,
    0x08, 0x0d, 0x04, 0x08, 0x06, 0x0a, 0x0f, 0x03, 0x0b, 0x07, 0x01, 0x04,
    0x0a, 0x0c, 0x09, 0x05, 0x03, 0x06, 0x0e, 0x0b, 0x05, 0x00, 0x00, 0x0e,
    0x0c, 0x09, 0x07, 0x02, 0x07, 0x02, 0x0b, 0x01, 0x04, 0x0e, 0x01, 0x07,
    0x09, 0x04, 0x0c, 0x0a, 0x0e, 0x08, 0x02, 0x0d, 0x00, 0x0f, 0x06, 0x0c,
    0x0a, 0x09, 0x0d, 0x00, 0x0f, 0x03, 0x03, 0x05, 0x05, 0x06, 0x08, 0x0b,
    0xed, 0xe1, 0xe2, 0xef, 0xe8, 0xed, 0xe4, 0xe8, 0xe6, 0xea, 0xef, 0xe3,
    0xeb, 0xe7, 0xe1, 0xe4, 0xea, 0xec, 0xe9, 0xe5, 0xe3, 0xe6, 0xee, 0xeb,
    0xe5, 0xe0, 0xe0, 0xee, 0xec, 0xe9, 0xe7, 0xe2, 0xe7, 0xe2, 0xeb, 0xe1,
    0xe4, 0xee, 0xe1, 0xe7, 0xe9, 0xe4, 0xec, 0xea, 0xee, 0xe8, 0xe2, 0xed,
    0xe0, 0xef, 0xe6, 0xec, 0xea, 0xe9, 0xed, 0xe0, 0xef, 0xe3, 0xe3, 0xe5,
    0xe5, 0xe6, 0xe8, 0xeb, 0x5d, 0x51, 0x52, 0x5f, 0x58, 0x5d, 0x54, 0x58,
    0x56, 0x5a, 0x5f, 0x53, 0x5b, 0x57, 0x51, 0x54, 0x5a, 0x5c, 0x59, 0x55,
    0x53, 0x56, 0x5e, 0x5b, 0x55, 0x50, 0x50, 0x5e, 0x5c, 0x59, 0x57, 0x52,
    0x57, 0x52, 0x5b, 0x51, 0x54, 0x5e, 0x51, 0x57, 0x59, 0x54, 0x5c, 0x5a,
    0x5e, 0x58, 0x52, 0x5d, 0x50, 0x5f, 0x56, 0x5c, 0x5a, 0x59, 0x5d, 0x50,
    0x5f, 0x53, 0x53, 0x55, 0x55, 0x56, 0x58, 0x5b, 0x2d, 0x21, 0x22, 0x2f,
    0x28, 0x2d, 0x24, 0x28, 0x26, 0x2a, 0x2f, 0x23, 0x2b, 0x27, 0x21, 0x24,
    0x2a, 0x2c, 0x29, 0x25, 0x23, 0x26, 0x2e, 0x2b, 0x25, 0x20, 0x20, 0x2e,
    0x2c, 0x29, 0x27, 0x22, 0x27, 0x22, 0x2b, 0x21, 0x24, 0x2e, 0x21, 0x27,
    0x29, 0x24, 0x2c, 0x2a, 0x2e, 0x28, 0x22, 0x2d, 0x20, 0x2f, 0x26, 0x2c,
    0x2a, 0x29, 0x2d, 0x20, 0x2f, 0x23, 0x23, 0x25, 0x25, 0x26, 0x28, 0x2b,
    0x9d, 0x91, 0x92, 0x9f, 0x98, 0x9d, 0x94, 0x98, 0x96, 0x9a, 0x9f, 0x93,
    0x9b, 0x97, 0x91, 0x94, 0x9a, 0x9c, 0x99, 0x95, 0x93, 0x96, 0x9e, 0x9b,
    0x95, 0x90, 0x90, 0x9e, 0x9c, 0x99, 0x97, 0x92, 0x97, 0x92, 0x9b, 0x91,
    0x94, 0x9e, 0x91, 0x97, 0x99, 0x94, 0x9c, 0x9a, 0x9e, 0x98, 0x92, 0x9d,
    0x90, 0x9f, 0x96, 0x9c, 0x9a, 0x99, 0x9d, 0x90, 0x9f, 0x93, 0x93, 0x95,
    0x95, 0x96, 0x98, 0x9b, 0x3d, 0x31, 0x32, 0x3f, 0x38, 0x3d, 0x34, 0x38,
    0x36, 0x3a, 0x3f, 0x33, 0x3b, 0x37, 0x31, 0x34, 0x3a, 0x3c, 0x39, 0x35,
    0x33, 0x36, 0x3e, 0x3b, 0x35, 0x30, 0x30, 0x3e, 0x3c, 0x39, 0x37, 0x32,
    0x37, 0x32, 0x3b, 0x31, 0x34, 0x3e, 0x31, 0x37, 0x39, 0x34, 0x3c, 0x3a,
    0x3e, 0x38, 0x32, 0x3d, 0x30, 0x3f, 0x36, 0x3c, 0x3a, 0x39, 0x3d, 0x30,
    0x3f, 0x33, 0x33, 0x35, 0x35, 0x36, 0x38, 0x3b, 0x2d, 0x21, 0x22, 0x2f,
    0x28, 0x2d, 0x24, 0x28, 0x26, 0x2a, 0x2f, 0x23, 0x2b, 0x27, 0x21, 0x24,
    0x2a, 0x2c, 0x29, 0x25, 0x23, 0x26, 0x2e, 0x2b, 0x25, 0x20, 0x20, 0x2e,
    0x2c, 0x29, 0x27, 0x22, 0x27, 0x22, 0x2b, 0x21, 0x24, 0x2e, 0x21, 0x27,
    0x29, 0x24, 0x2c, 0x2a, 0x2e, 0x28, 0x22, 0x2d, 0x20, 0x2f, 0x26, 0x2c,
    0x2a, 0x29, 0x2d, 0x20, 0x2f, 0x23, 0x23, 0x25, 0x25, 0x26, 0x28, 0x2b,
    0xcd, 0xc1, 0xc2, 0xcf, 0xc8, 0xcd, 0xc4, 0xc8, 0xc6, 0xca, 0xcf, 0xc3,
    0xcb, 0xc7, 0xc1, 0xc4, 0xca, 0xcc, 0xc9, 0xc5, 0xc3, 0xc6, 0xce, 0xcb,
    0xc5, 0xc0, 0xc0, 0xce, 0xcc, 0xc9, 0xc7, 0xc2, 0xc7, 0xc2, 0xcb, 0xc1,
    0xc4, 0xce, 0xc1, 0xc7, 0xc9, 0xc4, 0xcc, 0xca, 0xce, 0xc8, 0xc2, 0xcd,
    0xc0, 0xcf, 0xc6, 0xcc, 0xca, 0xc9, 0xcd, 0xc0, 0xcf, 0xc3, 0xc3, 0xc5,
    0xc5, 0xc6, 0xc8, 0xcb,
  },
};

const uint32_t ip_maskl[8][256] =
{
  {
    0x00000000, 0x00000001, 0x00000000, 0x00000001, 0x00000100, 0x00000101,
    0x00000100, 0x00000101, 0x00000000, 0x00000001, 0x00000000, 0x00000001,
    0x00000100, 0x00000101, 0x00000100, 0x00000101, 0x00010000, 0x00010001,
    0x00010000, 0x00010001, 0x00010100, 0x00010101, 0x00010100, 0x00010101,
    0x00010000, 0x00010001, 0x00010000, 0x00010001, 0x00010100, 0x00010101,
    0x00010100, 0x00010101, 0x00000000, 0x00000001, 0x00000000, 0x00000001,
    0x00000100, 0x00000101, 0x00000100, 0x00000101, 0x00000000, 0x00000001,
    0x00000000, 0x00000001, 0x00000100, 0x00000101, 0x00000100, 0x00000101,
    0x00010000, 0x00010001, 0x00010000, 0x00010001, 0x00010100, 0x00010101,
    0x00010100, 0x00010101, 0x00010000, 0x00010001, 0x00010000, 0x00010001,
    0x00010100, 0x00010101, 0x00010100, 0x00010101, 0x01000000, 0x01000001,
    0x01000000, 0x01000001, 0x01000100, 0x01000101, 0x01000100, 0x01000101,
    0x01000000, 0x01000001, 0x01000000, 0x01000001, 0x01000100, 0x01000101,
    0x01000100, 0x01000101, 0x01010000, 0x01010001, 0x01010000, 0x01010001,
    0x01010100, 0x01010101, 0x01010100, 0x01010101, 0x01010000, 0x01010001,
    0x01010000, 0x01010001, 0x01010100, 0x01010101, 0x01010100, 0x01010101,
    0x01000000, 0x01000001, 0x01000000, 0x01000001, 0x01000100, 0x01000101,
    0x01000100, 0x01000101, 0x01000000, 0x01000001, 0x01000000, 0x01000001,
    0x01000100, 0x01000101, 0x01000100, 0x01000101, 0x01010000, 0x01010001,
    0x01010000, 0x01010001, 0x01010100, 0x01010101, 0x01010100, 0x01010101,
    0x01010000, 0x01010001, 0x01010000, 0x01010001, 0x01010100, 0x01010101,
    0x01010100, 0x01010101, 0x00000000, 0x00000001, 0x00000000, 0x00000001,
    0x00000100, 0x00000101, 0x00000100, 0x00000101, 0x00000000, 0x00000001,
    0x00000000, 0x00000001, 0x00000100, 0x00000101, 0x00000100, 0x00000101,
    0x00010000, 0x00010001, 0x00010000, 0x00010001, 0x00010100, 0x00010101,
    0x00010100, 0x00010101, 0x00010000, 0x00010001, 0x00010000, 0x00010001,
    0x00010100, 0x00010101, 0x00010100, 0x00010101, 0x00000000, 0x00000001,
    0x00000000, 0x00000001, 0x00000100, 0x00000101, 0x00000100, 0x00000101,
    0x00000000, 0x00000001, 0x00000000, 0x00000001, 0x00000100, 0x00000101,
    0x00000100, 0x00000101, 0x00010000, 0x00010001, 0x00010000, 0x00010001,
    0x00010100, 0x00010101, 0x00010100, 0x00010101, 0x00010000, 0x00010001,
    0x00010000, 0x00010001, 0x00010100, 0x00010101, 0x00010100, 0x00010101,
    0x01000000, 0x01000001, 0x01000000, 0x01000001, 0x01000100, 0x01000101,
    0x01000100, 0x01000101, 0x01000000, 0x01000001, 0x01000000, 0x01000001,
    0x01000100, 0x01000101, 0x01000100, 0x01000101, 0x01010000, 0x01010001,
    0x01010000, 0x01010001, 0x01010100, 0x01010101, 0x01010100, 0x01010101,
    0x01010000, 0x01010001, 0x01010000, 0x01010001, 0x01010100, 0x01010101,
    0x01010100, 0x01010101, 0x01000000, 0x01000001, 0x01000000, 0x01000001,
    0x01000100, 0x01000101, 0x01000100, 0x01000101, 0x01000000, 0x01000001,
    0x01000000, 0x01000001, 0x01000100, 0x01000101, 0x01000100, 0x01000101,
    0x01010000, 0x01010001, 0x01010000, 0x01010001, 0x01010100, 0x01010101,
    0x01010100, 0x01010101, 0x01010000, 0x01010001, 0x01010000, 0x01010001,
    0x01010100, 0x01010101, 0x01010100, 0x01010101,
  },
  {
    0x00000000, 0x00000002, 0x00000000, 0x00000002, 0x00000200, 0x00000202,
    0x00000200, 0x00000202, 0x00000000, 0x00000002, 0x00000000, 0x00000002,
    0x00000200, 0x00000202, 0x00000200, 0x00000202, 0x00020000, 0x00020002,
    0x00020000, 0x00020002, 0x00020200, 0x00020202, 0x00020200, 0x00020202,
    0x00020000, 0x00020002, 0x00020000, 0x00020002, 0x00020200, 0x00020202,
    0x00020200, 0x00020202, 0x00000000, 0x00000002, 0x00000000, 0x00000002,
    0x00000200, 0x00000202, 0x00000200, 0x00000202, 0x00000000, 0x00000002,
    0x00000000, 0x00000002, 0x00000200, 0x00000202, 0x00000200, 0x00000202,
    0x00020000, 0x00020002, 0x00020000, 0x00020002, 0x00020200, 0x00020202,
    0x00020200, 0x00020202, 0x00020000, 0x00020002, 0x00020000, 0x00020002,
    0x00020200, 0x00020202, 0x00020200, 0x00020202, 0x02000000, 0x02000002,
    0x02000000, 0x02000002, 0x02000200, 0x02000202, 0x02000200, 0x02000202,
    0x02000000, 0x02000002, 0x02000000, 0x02000002, 0x02000200, 0x02000202,
    0x02000200, 0x02000202, 0x02020000, 0x02020002, 0x02020000, 0x02020002,
    0x02020200, 0x02020202, 0x02020200, 0x02020202, 0x02020000, 0x02020002,
    0x02020000, 0x02020002, 0x02020200, 0x02020202, 0x02020200, 0x02020202,
    0x02000000, 0x02000002, 0x02000000, 0x02000002, 0x02000200, 0x02000202,
    0x02000200, 0x02000202, 0x02000000, 0x02000002, 0x02000000, 0x02000002,
    0x02000200, 0x02000202, 0x02000200, 0x02000202, 0x02020000, 0x02020002,
    0x02020000, 0x02020002, 0x02020200, 0x02020202, 0x02020200, 0x02020202,
    0x02020000, 0x02020002, 0x02020000, 0x02020002, 0x02020200, 0x02020202,
    0x02020200, 0x02020202, 0x00000000, 0x00000002, 0x00000000, 0x00000002,
    0x00000200, 0x00000202, 0x00000200, 0x00000202, 0x00000000, 0x00000002,
    0x00000000, 0x00000002, 0x00000200, 0x00000202, 0x00000200, 0x00000202,
    0x00020000, 0x00020002, 0x00020000, 0x00020002, 0x00020200, 0x00020202,
    0x00020200, 0x00020202, 0x00020000, 0x00020002, 0x00020000, 0x00020002,
    0x00020200, 0x00020202, 0x00020200, 0x00020202, 0x00000000, 0x00000002,
    0x00000000, 0x00000002, 0x00000200, 0x00000202, 0x00000200, 0x00000202,
    0x00000000, 0x00000002, 0x00000000, 0x00000002, 0x00000200, 0x00000202,
    0x00000200, 0x00000202, 0x00020000, 0x00020002, 0x00020000, 0x00020002,
    0x00020200, 0x00020202, 0x00020200, 0x00020202, 0x00020000, 0x00020002,
    0x00020000, 0x00020002, 0x00020200, 0x00020202, 0x00020200, 0x00020202,
    0x02000000, 0x02000002, 0x02000000, 0x02000002, 0x02000200, 0x02000202,
    0x02000200, 0x02000202, 0x02000000, 0x02000002, 0x02000000, 0x02000002,
    0x02000200, 0x02000202, 0x02000200, 0x02000202, 0x02020000, 0x02020002,
    0x02020000, 0x02020002, 0x02020200, 0x02020202, 0x02020200, 0x02020202,
    0x02020000, 0x02020002, 0x02020000, 0x02020002, 0x02020200, 0x02020202,
    0x02020200, 0x02020202, 0x02000000, 0x02000002, 0x02000000, 0x02000002,
    0x02000200, 0x02000202, 0x02000200, 0x02000202, 0x02000000, 0x02000002,
    0x02000000, 0x02000002, 0x02000200, 0x02000202, 0x02000200, 0x02000202,
    0x02020000, 0x02020002, 0x02020000, 0x02020002, 0x02020200, 0x02020202,
    0x02020200, 0x02020202, 0x02020000, 0x02020002, 0x02020000, 0x02020002,
    0x02020200, 0x02020202, 0x02020200, 0x02020202,
  },
  {
    0x00000000, 0x00000004, 0x00000000, 0x00000004, 0x00000400, 0x00000404,
    0x00000400, 0x00000404, 0x00000000, 0x00000004, 0x00000000, 0x00000004,
    0x00000400, 0x00000404, 0x00000400, 0x00000404, 0x00040000, 0x00040004,
    0x00040000, 0x00040004, 0x00040400, 0x00040404, 0x00040400, 0x00040404,
    0x00040000, 0x00040004, 0x00040000, 0x00040004, 0x00040400, 0x00040404,
    0x00040400, 0x00040404, 0x00000000, 0x00000004, 0x00000000, 0x00000004,
    0x00000400, 0x00000404, 0x00000400, 0x00000404, 0x00000000, 0x00000004,
    0x00000000, 0x00000004, 0x00000400, 0x00000404, 0x00000400, 0x00000404,
    0x00040000, 0x00040004, 0x00040000, 0x00040004, 0x00040400, 0x00040404,
    0x00040400, 0x00040404, 0x00040000, 0x00040004, 0x00040000, 0x00040004,
    0x00040400, 0x00040404, 0x00040400, 0x00040404, 0x04000000, 0x04000004,
    0x04000000, 0x04000004, 0x04000400, 0x04000404, 0x04000400, 0x04000404,
    0x04000000, 0x04000004, 0x04000000, 0x04000004, 0x04000400, 0x04000404,
    0x04000400, 0x04000404, 0x04040000, 0x04040004, 0x04040000, 0x04040004,
    0x04040400, 0x04040404, 0x04040400, 0x04040404, 0x04040000, 0x04040004,
    0x04040000, 0x04040004, 0x04040400, 0x04040404, 0x04040400, 0x04040404,
    0x04000000, 0x04000004, 0x04000000, 0x04000004, 0x04000400, 0x04000404,
    0x04000400, 0x04000404, 0x04000000, 0x04000004, 0x04000000, 0x04000004,
    0x04000400, 0x04000404, 0x04000400, 0x04000404, 0x04040000, 0x04040004,
    0x04040000, 0x04040004, 0x04040400, 0x04040404, 0x04040400, 0x04040404,
    0x04040000, 0x04040004, 0x04040000, 0x04040004, 0x04040400, 0x04040404,
    0x04040400, 0x04040404, 0x00000000, 0x00000004, 0x00000000, 0x00000004,
    0x00000400, 0x00000404, 0x00000400, 0x00000404, 0x00000000, 0x00000004,
    0x00000000, 0x00000004, 0x00000400, 0x00000404, 0x00000400, 0x00000404,
    0x00040000, 0x00040004, 0x00040000, 0x00040004, 0x00040400, 0x00040404,
    0x00040400, 0x00040404, 0x00040000, 0x00040004, 0x00040000, 0x00040004,
    0x00040400, 0x00040404, 0x00040400, 0x00040404, 0x00000000, 0x00000004,
    0x00000000, 0x00000004, 0x00000400, 0x00000404, 0x00000400, 0x00000404,
    0x00000000, 0x00000004, 0x00000000, 0x00000004, 0x00000400, 0x00000404,
    0x00000400, 0x00000404, 0x00040000, 0x00040004, 0x00040000, 0x00040004,
    0x00040400, 0x00040404, 0x00040400, 0x00040404, 0x00040000, 0x00040004,
    0x00040000, 0x00040004, 0x00040400, 0x00040404, 0x00040400, 0x00040404,
    0x04000000, 0x04000004, 0x04000000, 0x04000004, 0x04000400, 0x04000404,
    0x04000400, 0x04000404, 0x04000000, 0x04000004, 0x04000000, 0x04000004,
    0x04000400, 0x04000404, 0x04000400, 0x04000404, 0x04040000, 0x04040004,
    0x04040000, 0x04040004, 0x04040400, 0x04040404, 0x04040400, 0x04040404,
    0x04040000, 0x04040004, 0x04040000, 0x04040004, 0x04040400, 0x04040404,
    0x04040400, 0x04040404, 0x04000000, 0x04000004, 0x04000000, 0x04000004,
    0x04000400, 0x04000404, 0x04000400, 0x04000404, 0x04000000, 0x04000004,
    0x04000000, 0x04000004, 0x04000400, 0x04000404, 0x04000400, 0x04000404,
    0x04040000, 0x04040004, 0x04040000, 0x04040004, 0x04040400, 0x04040404,
    0x04040400, 0x04040404, 0x04040000, 0x04040004, 0x04040000, 0x04040004,
    0x04040400, 0x04040404, 0x04040400, 0x04040404,
  },
  {
    0x00000000, 0x00000008, 0x00000000, 0x00000008, 0x00000800, 0x00000808,
    0x00000800, 0x00000808, 0x00000000, 0x00000008, 0x00000000, 0x00000008,
    0x00000800, 0x00000808, 0x00000800, 0x00000808, 0x00080000, 0x00080008,
    0x00080000, 0x00080008, 0x00080800, 0x00080808, 0x00080800, 0x00080808,
    0x00080000, 0x00080008, 0x00080000, 0x00080008, 0x00080800, 0x00080808,
    0x00080800, 0x00080808, 0x00000000, 0x00000008, 0x00000000, 0x00000008,
    0x00000800, 0x00000808, 0x00000800, 0x00000808, 0x00000000, 0x00000008,
    0x00000000, 0x00000008, 0x00000800, 0x00000808, 0x00000800, 0x00000808,
    0x00080000, 0x00080008, 0x00080000, 0x00080008, 0x00080800, 0x00080808,
    0x00080800, 0x00080808, 0x00080000, 0x00080008, 0x00080000, 0x00080008,
    0x00080800, 0x00080808, 0x00080800, 0x00080808, 0x08000000, 0x08000008,
    0x08000000, 0x08000008, 0x08000800, 0x08000808, 0x08000800, 0x08000808,
    0x08000000, 0x08000008, 0x08000000, 0x08000008, 0x08000800, 0x08000808,
    0x08000800, 0x08000808, 0x08080000, 0x08080008, 0x08080000, 0x08080008,
    0x08080800, 0x08080808, 0x08080800, 0x08080808, 0x08080000, 0x08080008,
    0x08080000, 0x08080008, 0x08080800, 0x08080808, 0x08080800, 0x08080808,
    0x08000000, 0x08000008, 0x08000000, 0x08000008, 0x08000800, 0x08000808,
    0x08000800, 0x08000808, 0x08000000, 0x08000008, 0x08000000, 0x08000008,
    0x08000800, 0x08000808, 0x08000800, 0x08000808, 0x08080000, 0x08080008,
    0x08080000, 0x08080008, 0x08080800, 0x08080808, 0x08080800, 0x08080808,
    0x08080000, 0x08080008, 0x08080000, 0x08080008, 0x08080800, 0x08080808,
    0x08080800, 0x08080808, 0x00000000, 0x00000008, 0x00000000, 0x00000008,
    0x00000800, 0x00000808, 0x00000800, 0x00000808, 0x00000000, 0x00000008,
    0x00000000, 0x00000008, 0x00000800, 0x00000808, 0x00000800, 0x00000808,
    0x00080000, 0x00080008, 0x00080000, 0x00080008, 0x00080800, 0x00080808,
    0x00080800, 0x00080808, 0x00080000, 0x00080008, 0x00080000, 0x00080008,
    0x00080800, 0x00080808, 0x00080800, 0x00080808, 0x00000000, 0x00000008,
    0x00000000, 0x00000008, 0x00000800, 0x00000808, 0x00000800, 0x00000808,
    0x00000000, 0x00000008, 0x00000000, 0x00000008, 0x00000800, 0x00000808,
    0x00000800, 0x00000808, 0x00080000, 0x00080008, 0x00080000, 0x00080008,
    0x00080800, 0x00080808, 0x00080800, 0x00080808, 0x00080000, 0x00080008,
    0x00080000, 0x00080008, 0x00080800, 0x00080808, 0x00080800, 0x00080808,
    0x08000000, 0x08000008, 0x08000000, 0x08000008, 0x08000800, 0x08000808,
    0x08000800, 0x08000808, 0x08000000, 0x08000008, 0x08000000, 0x08000008,
    0x08000800, 0x08000808, 0x08000800, 0x08000808, 0x08080000, 0x08080008,
    0x08080000, 0x08080008, 0x08080800, 0x08080808, 0x08080800, 0x08080808,
    0x08080000, 0x08080008, 0x08080000, 0x08080008, 0x08080800, 0x08080808,
    0x08080800, 0x08080808, 0x08000000, 0x08000008, 0x08000000, 0x08000008,
    0x08000800, 0x08000808, 0x08000800, 0x08000808, 0x08000000, 0x08000008,
    0x08000000, 0x08000008, 0x08000800, 0x08000808, 0x08000800, 0x08000808,
    0x08080000, 0x08080008, 0x08080000, 0x08080008, 0x08080800, 0x08080808,
    0x08080800, 0x08080808, 0x08080000, 0x08080008, 0x08080000, 0x08080008,
    0x08080800, 0x08080808, 0x08080800, 0x08080808,
  },
  {
    0x00000000, 0x00000010, 0x00000000, 0x00000010, 0x00001000, 0x00001010,
    0x00001000, 0x00001010, 0x00000000, 0x00000010, 0x00000000, 0x00000010,
    0x00001000, 0x00001010, 0x00001000, 0x00001010, 0x00100000, 0x00100010,
    0x00100000, 0x00100010, 0x00101000, 0x00101010, 0x00101000, 0x00101010,
    0x00100000, 0x00100010, 0x00100000, 0x00100010, 0x00101000, 0x00101010,
    0x00101000, 0x00101010, 0x00000000, 0x00000010, 0x00000000, 0x00000010,
    0x00001000, 0x00001010, 0x00001000, 0x00001010, 0x00000000, 0x00000010,
    0x00000000, 0x00000010, 0x00001000, 0x00001010, 0x00001000, 0x00001010,
    0x00100000, 0x00100010, 0x00100000, 0x00100010, 0x00101000, 0x00101010,
    0x00101000, 0x00101010, 0x00100000, 0x00100010, 0x00100000, 0x00100010,
    0x00101000, 0x00101010, 0x00101000, 0x00101010, 0x10000000, 0x10000010,
    0x10000000, 0x10000010, 0x10001000, 0x10001010, 0x10001000, 0x10001010,
    0x10000000, 0x10000010, 0x10000000, 0x10000010, 0x10001000, 0x10001010,
    0x10001000, 0x10001010, 0x10100000, 0x10100010, 0x10100000, 0x10100010,
    0x10101000, 0x10101010, 0x10101000, 0x10101010, 0x10100000, 0x10100010,
    0x10100000, 0x10100010, 0x10101000, 0x10101010, 0x10101000, 0x10101010,
    0x10000000, 0x10000010, 0x10000000, 0x10000010, 0x10001000, 0x10001010,
    0x10001000, 0x10001010, 0x10000000, 0x10000010, 0x10000000, 0x10000010,
    0x10001000, 0x10001010, 0x10001000, 0x10001010, 0x10100000, 0x10100010,
    0x10100000, 0x10100010, 0x10101000, 0x10101010, 0x10101000, 0x10101010,
    0x10100000, 0x10100010, 0x10100000, 0x10100010, 0x10101000, 0x10101010,
    0x10101000, 0x10101010, 0x00000000, 0x00000010, 0x00000000, 0x00000010,
    0x00001000, 0x00001010, 0x00001000, 0x00001010, 0x00000000, 0x00000010,
    0x00000000, 0x00000010, 0x00001000, 0x00001010, 0x00001000, 0x00001010,
    0x00100000, 0x00100010, 0x00100000, 0x00100010, 0x00101000, 0x00101010,
    0x00101000, 0x00101010, 0x00100000, 0x00100010, 0x00100000, 0x00100010,
    0x00101000, 0x00101010, 0x00101000, 0x00101010, 0x00000000, 0x00000010,
    0x00000000, 0x00000010, 0x00001000, 0x00001010, 0x00001000, 0x00001010,
    0x00000000, 0x00000010, 0x00000000, 0x00000010, 0x00001000, 0x00001010,
    0x00001000, 0x00001010, 0x00100000, 0x00100010, 0x00100000, 0x00100010,
    0x00101000, 0x00101010, 0x00101000, 0x00101010, 0x00100000, 0x00100010,
    0x00100000, 0x00100010, 0x00101000, 0x00101010, 0x00101000, 0x00101010,
    0x10000000, 0x10000010, 0x10000000, 0x10000010, 0x10001000, 0x10001010,
    0x10001000, 0x10001010, 0x10000000, 0x10000010, 0x10000000, 0x10000010,
    0x10001000, 0x10001010, 0x10001000, 0x10001010, 0x10100000, 0x10100010,
    0x10100000, 0x10100010, 0x10101000, 0x10101010, 0x10101000, 0x10101010,
    0x10100000, 0x10100010, 0x10100000, 0x10100010, 0x10101000, 0x10101010,
    0x10101000, 0x10101010, 0x10000000, 0x10000010, 0x10000000, 0x10000010,
    0x10001000, 0x10001010, 0x10001000, 0x10001010, 0x10000000, 0x10000010,
    0x10000000, 0x10000010, 0x10001000, 0x10001010, 0x10001000, 0x10001010,
    0x10100000, 0x10100010, 0x10100000, 0x10100010, 0x10101000, 0x10101010,
    0x10101000, 0x10101010, 0x10100000, 0x10100010, 0x10100000, 0x10100010,
    0x10101000, 0x10101010, 0x10101000, 0x10101010,
  },
  {
    0x00000000, 0x00000020, 0x00000000, 0x00000020, 0x00002000, 0x00002020,
    0x00002000, 0x00002020, 0x00000000, 0x00000020, 0x00000000, 0x00000020,
    0x00002000, 0x00002020, 0x00002000, 0x00002020, 0x00200000, 0x00200020,
    0x00200000, 0x00200020, 0x00202000, 0x00202020, 0x00202000, 0x00202020,
    0x00200000, 0x00200020, 0x00200000, 0x00200020, 0x00202000, 0x00202020,
    0x00202000, 0x00202020, 0x00000000, 0x00000020, 0x00000000, 0x00000020,
    0x00002000, 0x00002020, 0x00002000, 0x00002020, 0x00000000, 0x00000020,
    0x00000000, 0x00000020, 0x00002000, 0x00002020, 0x00002000, 0x00002020,
    0x00200000, 0x00200020, 0x00200000, 0x00200020, 0x00202000, 0x00202020,
    0x00202000, 0x00202020, 0x00200000, 0x00200020, 0x00200000, 0x00200020,
    0x00202000, 0x00202020, 0x00202000, 0x00202020, 0x20000000, 0x20000020,
    0x20000000, 0x20000020, 0x20002000, 0x20002020, 0x20002000, 0x20002020,
    0x20000000, 0x20000020, 0x20000000, 0x20000020, 0x20002000, 0x20002020,
    0x20002000, 0x20002020, 0x20200000, 0x20200020, 0x20200000, 0x20200020,
    0x20202000, 0x20202020, 0x20202000, 0x20202020, 0x20200000, 0x20200020,
    0x20200000, 0x20200020, 0x20202000, 0x20202020, 0x20202000, 0x20202020,
    0x20000000, 0x20000020, 0x20000000, 0x20000020, 0x20002000, 0x20002020,
    0x20002000, 0x20002020, 0x20000000, 0x20000020, 0x20000000, 0x20000020,
    0x20002000, 0x20002020, 0x20002000, 0x20002020, 0x20200000, 0x20200020,
    0x20200000, 0x20200020, 0x20202000, 0x20202020, 0x20202000, 0x20202020,
    0x20200000, 0x20200020, 0x20200000, 0x20200020, 0x20202000, 0x20202020,
    0x20202000, 0x20202020, 0x00000000, 0x00000020, 0x00000000, 0x00000020,
    0x00002000, 0x00002020, 0x00002000, 0x00002020, 0x00000000, 0x00000020,
    0x00000000, 0x00000020, 0x00002000, 0x00002020, 0x00002000, 0x00002020,
    0x00200000, 0x00200020, 0x00200000, 0x00200020, 0x00202000, 0x00202020,
    0x00202000, 0x00202020, 0x00200000, 0x00200020, 0x00200000, 0x00200020,
    0x00202000, 0x00202020, 0x00202000, 0x00202020, 0x00000000, 0x00000020,
    0x00000000, 0x00000020, 0x00002000, 0x00002020, 0x00002000, 0x00002020,
    0x00000000, 0x00000020, 0x00000000, 0x00000020, 0x00002000, 0x00002020,
    0x00002000, 0x00002020, 0x00200000, 0x00200020, 0x00200000, 0x00200020,
    0x00202000, 0x00202020, 0x00202000, 0x00202020, 0x00200000, 0x00200020,
    0x00200000, 0x00200020, 0x00202000, 0x00202020, 0x00202000, 0x00202020,
    0x20000000, 0x20000020, 0x20000000, 0x20000020, 0x20002000, 0x20002020,
    0x20002000, 0x20002020, 0x20000000, 0x20000020, 0x20000000, 0x20000020,
    0x20002000, 0x20002020, 0x20002000, 0x20002020, 0x20200000, 0x20200020,
    0x20200000, 0x20200020, 0x20202000, 0x20202020, 0x20202000, 0x20202020,
    0x20200000, 0x20200020, 0x20200000, 0x20200020, 0x20202000, 0x20202020,
    0x20202000, 0x20202020, 0x20000000, 0x20000020, 0x20000000, 0x20000020,
    0x20002000, 0x20002020, 0x20002000, 0x20002020, 0x20000000, 0x20000020,
    0x20000000, 0x20000020, 0x20002000, 0x20002020, 0x20002000, 0x20002020,
    0x20200000, 0x20200020, 0x20200000, 0x20200020, 0x20202000, 0x20202020,
    0x20202000, 0x20202020, 0x20200000, 0x20200020, 0x20200000, 0x20200020,
    0x20202000, 0x20202020, 0x20202000, 0x20202020,
  },
  {
    0x00000000, 0x00000040, 0x00000000, 0x00000040, 0x00004000, 0x00004040,
    0x00004000, 0x00004040, 0x00000000, 0x00000040, 0x00000000, 0x00000040,
    0x00004000, 0x00004040, 0x00004000, 0x00004040, 0x00400000, 0x00400040,
    0x00400000, 0x00400040, 0x00404000, 0x00404040, 0x00404000, 0x00404040,
    0x00400000, 0x00400040, 0x00400000, 0x00400040, 0x00404000, 0x00404040,
    0x00404000, 0x00404040, 0x00000000, 0x00000040, 0x00000000, 0x00000040,
    0x00004000, 0x00004040, 0x00004000, 0x00004040, 0x00000000, 0x00000040,
    0x00000000, 0x00000040, 0x00004000, 0x00004040, 0x00004000, 0x00004040,
    0x00400000, 0x00400040, 0x00400000, 0x00400040, 0x00404000, 0x00404040,
    0x00404000, 0x00404040, 0x00400000, 0x00400040, 0x00400000, 0x00400040,
    0x00404000, 0x00404040, 0x00404000, 0x00404040, 0x40000000, 0x40000040,
    0x40000000, 0x40000040, 0x40004000, 0x40004040, 0x40004000, 0x40004040,
    0x40000000, 0x40000040, 0x40000000, 0x40000040, 0x40004000, 0x40004040,
    0x40004000, 0x40004040, 0x40400000, 0x40400040, 0x40400000, 0x40400040,
    0x40404000, 0x40404040, 0x40404000, 0x40404040, 0x40400000, 0x40400040,
    0x40400000, 0x40400040, 0x40404000, 0x40404040, 0x40404000, 0x40404040,
    0x40000000, 0x40000040, 0x40000000, 0x40000040, 0x40004000, 0x40004040,
    0x40004000, 0x40004040, 0x40000000, 0x40000040, 0x40000000, 0x40000040,
    0x40004000, 0x40004040, 0x40004000, 0x40004040, 0x40400000, 0x40400040,
    0x40400000, 0x40400040, 0x40404000, 0x40404040, 0x40404000, 0x40404040,
    0x40400000, 0x40400040, 0x40400000, 0x40400040, 0x40404000, 0x40404040,
    0x40404000, 0x40404040, 0x00000000, 0x00000040, 0x00000000, 0x00000040,
    0x00004000, 0x00004040, 0x00004000, 0x00004040, 0x00000000, 0x00000040,
    0x00000000, 0x00000040, 0x00004000, 0x00004040, 0x00004000, 0x00004040,
    0x00400000, 0x00400040, 0x00400000, 0x00400040, 0x00404000, 0x00404040,
    0x00404000, 0x00404040, 0x00400000, 0x00400040, 0x00400000, 0x00400040,
    0x00404000, 0x00404040, 0x00404000, 0x00404040, 0x00000000, 0x00000040,
    0x00000000, 0x00000040, 0x00004000, 0x00004040, 0x00004000, 0x00004040,
    0x00000000, 0x00000040, 0x00000000, 0x00000040, 0x00004000, 0x00004040,
    0x00004000, 0x00004040, 0x00400000, 0x00400040, 0x00400000, 0x00400040,
    0x00404000, 0x00404040, 0x00404000, 0x00404040, 0x00400000, 0x00400040,
    0x00400000, 0x00400040, 0x00404000, 0x00404040, 0x00404000, 0x00404040,
    0x40000000, 0x40000040, 0x40000000, 0x40000040, 0x40004000, 0x40004040,
    0x40004000, 0x40004040, 0x40000000, 0x40000040, 0x40000000, 0x40000040,
    0x40004000, 0x40004040, 0x40004000, 0x40004040, 0x40400000, 0x40400040,
    0x40400000, 0x40400040, 0x40404000, 0x40404040, 0x40404000, 0x40404040,
    0x40400000, 0x40400040, 0x40400000, 0x40400040, 0x40404000, 0x40404040,
    0x40404000, 0x40404040, 0x40000000, 0x40000040, 0x40000000, 0x40000040,
    0x40004000, 0x40004040, 0x40004000, 0x40004040, 0x40000000, 0x40000040,
    0x40000000, 0x40000040, 0x40004000, 0x40004040, 0x40004000, 0x40004040,
    0x40400000, 0x40400040, 0x40400000, 0x40400040, 0x40404000, 0x40404040,
    0x40404000, 0x40404040, 0x40400000, 0x40400040, 0x40400000, 0x40400040,
    0x40404000, 0x40404040, 0x40404000, 0x40404040,
  },
  {
    0x00000000, 0x00000080, 0x00000000, 0x00000080, 0x00008000, 0x00008080,
    0x00008000, 0x00008080, 0x00000000, 0x00000080, 0x00000000, 0x00000080,
    0x00008000, 0x00008080, 0x00008000, 0x00008080, 0x00800000, 0x00800080,
    0x00800000, 0x00800080, 0x00808000, 0x00808080, 0x00808000, 0x00808080,
    0x00800000, 0x00800080, 0x00800000, 0x00800080, 0x00808000, 0x00808080,
    0x00808000, 0x00808080, 0x00000000, 0x00000080, 0x00000000, 0x00000080,
    0x00008000, 0x00008080, 0x00008000, 0x00008080, 0x00000000, 0x00000080,
    0x00000000, 0x00000080, 0x00008000, 0x00008080, 0x00008000, 0x00008080,
    0x00800000, 0x00800080, 0x00800000, 0x00800080, 0x00808000, 0x00808080,
    0x00808000, 0x00808080, 0x00800000, 0x00800080, 0x00800000, 0x00800080,
    0x00808000, 0x00808080, 0x00808000, 0x00808080, 0x80000000, 0x80000080,
    0x80000000, 0x80000080, 0x80008000, 0x80008080, 0x80008000, 0x80008080,
    0x80000000, 0x80000080, 0x80000000, 0x80000080, 0x80008000, 0x80008080,
    0x80008000, 0x80008080, 0x80800000, 0x80800080, 0x80800000, 0x80800080,
    0x80808000, 0x80808080, 0x80808000, 0x80808080, 0x80800000, 0x80800080,
    0x80800000, 0x80800080, 0x80808000, 0x80808080, 0x80808000, 0x80808080,
    0x80000000, 0x80000080, 0x80000000, 0x80000080, 0x80008000, 0x80008080,
    0x80008000, 0x80008080, 0x80000000, 0x80000080, 0x80000000, 0x80000080,
    0x80008000, 0x80008080, 0x80008000, 0x80008080, 0x80800000, 0x80800080,
    0x80800000, 0x80800080, 0x80808000, 0x80808080, 0x80808000, 0x80808080,
    0x80800000, 0x80800080, 0x80800000, 0x80800080, 0x80808000, 0x80808080,
    0x80808000, 0x80808080, 0x00000000, 0x00000080, 0x00000000, 0x00000080,
    0x00008000, 0x00008080, 0x00008000, 0x00008080, 0x00000000, 0x00000080,
    0x00000000, 0x00000080, 0x00008000, 0x00008080, 0x00008000, 0x00008080,
    0x00800000, 0x00800080, 0x00800000, 0x00800080, 0x00808000, 0x00808080,
    0x00808000, 0x00808080, 0x00800000, 0x00800080, 0x00800000, 0x00800080,
    0x00808000, 0x00808080, 0x00808000, 0x00808080, 0x00000000, 0x00000080,
    0x00000000, 0x00000080, 0x00008000, 0x00008080, 0x00008000, 0x00008080,
    0x00000000, 0x00000080, 0x00000000, 0x00000080, 0x00008000, 0x00008080,
    0x00008000, 0x00008080, 0x00800000, 0x00800080, 0x00800000, 0x00800080,
    0x00808000, 0x00808080, 0x00808000, 0x00808080, 0x00800000, 0x00800080,
    0x00800000, 0x00800080, 0x00808000, 0x00808080, 0x00808000, 0x00808080,
    0x80000000, 0x80000080, 0x80000000, 0x80000080, 0x80008000, 0x80008080,
    0x80008000, 0x80008080, 0x80000000, 0x80000080, 0x80000000, 0x80000080,
    0x80008000, 0x80008080, 0x80008000, 0x80008080, 0x80800000, 0x80800080,
    0x80800000, 0x80800080, 0x80808000, 0x80808080, 0x80808000, 0x80808080,
    0x80800000, 0x80800080, 0x80800000, 0x80800080, 0x80808000, 0x80808080,
    0x80808000, 0x80808080, 0x80000000, 0x80000080, 0x80000000, 0x80000080,
    0x80008000, 0x80008080, 0x80008000, 0x80008080, 0x80000000, 0x80000080,
    0x80000000, 0x80000080, 0x80008000, 0x80008080, 0x80008000, 0x80008080,
    0x80800000, 0x80800080, 0x80800000, 0x80800080, 0x80808000, 0x80808080,
    0x80808000, 0x80808080, 0x80800000, 0x80800080, 0x80800000, 0x80800080,
    0x80808000, 0x80808080, 0x80808000, 0x80808080,
  },
};

const uint32_t ip_maskr[8][256] =
{
  {
    0x00000000, 0x00000000, 0x00000001, 0x00000001, 0x00000000, 0x00000000,
    0x00000001, 0x00000001, 0x00000100, 0x00000100, 0x00000101, 0x00000101,
    0x00000100, 0x00000100, 0x00000101, 0x00000101, 0x00000000, 0x00000000,
    0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000001, 0x00000001,
    0x00000100, 0x00000100, 0x00000101, 0x00000101, 0x00000100, 0x00000100,
    0x00000101, 0x00000101, 0x00010000, 0x00010000, 0x00010001, 0x00010001,
    0x00010000, 0x00010000, 0x00010001, 0x00010001, 0x00010100, 0x00010100,
    0x00010101, 0x00010101, 0x00010100, 0x00010100, 0x00010101, 0x00010101,
    0x00010000, 0x00010000, 0x00010001, 0x00010001, 0x00010000, 0x00010000,
    0x00010001, 0x00010001, 0x00010100, 0x00010100, 0x00010101, 0x00010101,
    0x00010100, 0x00010100, 0x00010101, 0x00010101, 0x00000000, 0x00000000,
    0x00000001, 0x00000001, 0x00000000, 0x00000000, 0x00000001, 0x00000001,
    0x00000100, 0x00000100, 0x00000101, 0x00000101, 0x00000100, 0x00000100,
    0x00000101, 0x00000101, 0x00000000, 0x00000000, 0x00000001, 0x00000001,
    0x00000000, 0x00000000, 0x00000001, 0x00000001, 0x00000100, 0x00000100,
    0x00000101, 0x00000101, 0x00000100, 0x00000100, 0x00000101, 0x00000101,
    0x00010000, 0x00010000, 0x00010001, 0x00010001, 0x00010000, 0x00010000,
    0x00010001, 0x00010001, 0x00010100, 0x00010100, 0x00010101, 0x00010101,
    0x00010100, 0x00010100, 0x00010101, 0x00010101, 0x00010000, 0x00010000,
    0x00010001, 0x00010001, 0x00010000, 0x00010000, 0x00010001, 0x00010001,
    0x00010100, 0x00010100, 0x00010101, 0x00010101, 0x00010100, 0x00010100,
    0x00010101, 0x00010101, 0x01000000, 0x01000000, 0x01000001, 0x01000001,
    0x01000000, 0x01000000, 0x01000001, 0x01000001, 0x01000100, 0x01000100,
    0x01000101, 0x01000101, 0x01000100, 0x01000100, 0x01000101, 0x01000101,
    0x01000000, 0x01000000, 0x01000001, 0x01000001, 0x01000000, 0x01000000,
    0x01000001, 0x01000001, 0x01000100, 0x01000100, 0x01000101, 0x01000101,
    0x01000100, 0x01000100, 0x01000101, 0x01000101, 0x01010000, 0x01010000,
    0x01010001, 0x01010001, 0x01010000, 0x01010000, 0x01010001, 0x01010001,
    0x01010100, 0x01010100, 0x01010101, 0x01010101, 0x01010100, 0x01010100,
    0x01010101, 0x01010101, 0x01010000, 0x01010000, 0x01010001, 0x01010001,
    0x01010000, 0x01010000, 0x01010001, 0x01010001, 0x01010100, 0x01010100,
    0x01010101, 0x01010101, 0x01010100, 0x01010100, 0x01010101, 0x01010101,
    0x01000000, 0x01000000, 0x01000001, 0x01000001, 0x01000000, 0x01000000,
    0x01000001, 0x01000001, 0x01000100, 0x01000100, 0x01000101, 0x01000101,
    0x01000100, 0x01000100, 0x01000101, 0x01000101, 0x01000000, 0x01000000,
    0x01000001, 0x01000001, 0x01000000, 0x01000000, 0x01000001, 0x01000001,
    0x01000100, 0x01000100, 0x01000101, 0x01000101, 0x01000100, 0x01000100,
    0x01000101, 0x01000101, 0x01010000, 0x01010000, 0x01010001, 0x01010001,
    0x01010000, 0x01010000, 0x01010001, 0x01010001, 0x01010100, 0x01010100,
    0x01010101, 0x01010101, 0x01010100, 0x01010100, 0x01010101, 0x01010101,
    0x01010000, 0x01010000, 0x01010001, 0x01010001, 0x01010000, 0x01010000,
    0x01010001, 0x01010001, 0x01010100, 0x01010100, 0x01010101, 0x01010101,
    0x01010100, 0x01010100, 0x01010101, 0x01010101,
  },
  {
    0x00000000, 0x00000000, 0x00000002, 0x00000002, 0x00000000, 0x00000000,
    0x00000002, 0x00000002, 0x00000200, 0x00000200, 0x00000202, 0x00000202,
    0x00000200, 0x00000200, 0x00000202, 0x00000202, 0x00000000, 0x00000000,
    0x00000002, 0x00000002, 0x00000000, 0x00000000, 0x00000002, 0x00000002,
    0x00000200, 0x00000200, 0x00000202, 0x00000202, 0x00000200, 0x00000200,
    0x00000202, 0x00000202, 0x00020000, 0x00020000, 0x00020002, 0x00020002,
    0x00020000, 0x00020000, 0x00020002, 0x00020002, 0x00020200, 0x00020200,
    0x00020202, 0x00020202, 0x00020200, 0x00020200, 0x00020202, 0x00020202,
    0x00020000, 0x00020000, 0x00020002, 0x00020002, 0x00020000, 0x00020000,
    0x00020002, 0x00020002, 0x00020200, 0x00020200, 0x00020202, 0x00020202,
    0x00020200, 0x00020200, 0x00020202, 0x00020202, 0x00000000, 0x00000000,
    0x00000002, 0x00000002, 0x00000000, 0x00000000, 0x00000002, 0x00000002,
    0x00000200, 0x00000200, 0x00000202, 0x00000202, 0x00000200, 0x00000200,
    0x00000202, 0x00000202, 0x00000000, 0x00000000, 0x00000002, 0x00000002,
    0x00000000, 0x00000000, 0x00000002, 0x00000002, 0x00000200, 0x00000200,
    0x00000202, 0x00000202, 0x00000200, 0x00000200, 0x00000202, 0x00000202,
    0x00020000, 0x00020000, 0x00020002, 0x00020002, 0x00020000, 0x00020000,
    0x00020002, 0x00020002, 0x00020200, 0x00020200, 0x00020202, 0x00020202,
    0x00020200, 0x00020200, 0x00020202, 0x00020202, 0x00020000, 0x00020000,
    0x00020002, 0x00020002, 0x00020000, 0x00020000, 0x00020002, 0x00020002,
    0x00020200, 0x00020200, 0x00020202, 0x00020202, 0x00020200, 0x00020200,
    0x00020202, 0x00020202, 0x02000000, 0x02000000, 0x02000002, 0x02000002,
    0x02000000, 0x02000000, 0x02000002, 0x02000002, 0x02000200, 0x02000200,
    0x02000202, 0x02000202, 0x02000200, 0x02000200, 0x02000202, 0x02000202,
    0x02000000, 0x02000000, 0x02000002, 0x02000002, 0x02000000, 0x02000000,
    0x02000002, 0x02000002, 0x02000200, 0x02000200, 0x02000202, 0x02000202,
    0x02000200, 0x02000200, 0x02000202, 0x02000202, 0x02020000, 0x02020000,
    0x02020002, 0x02020002, 0x02020000, 0x02020000, 0x02020002, 0x02020002,
    0x02020200, 0x02020200, 0x02020202, 0x02020202, 0x02020200, 0x02020200,
    0x02020202, 0x02020202, 0x02020000, 0x02020000, 0x02020002, 0x02020002,
    0x02020000, 0x02020000, 0x02020002, 0x02020002, 0x02020200, 0x02020200,
    0x02020202, 0x02020202, 0x02020200, 0x02020200, 0x02020202, 0x02020202,
    0x02000000, 0x02000000, 0x02000002, 0x02000002, 0x02000000, 0x02000000,
    0x02000002, 0x02000002, 0x02000200, 0x02000200, 0x02000202, 0x02000202,
    0x02000200, 0x02000200, 0x02000202, 0x02000202, 0x02000000, 0x02000000,
    0x02000002, 0x02000002, 0x02000000, 0x02000000, 0x02000002, 0x02000002,
    0x02000200, 0x02000200, 0x02000202, 0x02000202, 0x02000200, 0x02000200,
    0x02000202, 0x02000202, 0x02020000, 0x02020000, 0x02020002, 0x02020002,
    0x02020000, 0x02020000, 0x02020002, 0x02020002, 0x02020200, 0x02020200,
    0x02020202, 0x02020202, 0x02020200, 0x02020200, 0x02020202, 0x02020202,
    0x02020000, 0x02020000, 0x02020002, 0x02020002, 0x02020000, 0x02020000,
    0x02020002, 0x02020002, 0x02020200, 0x02020200, 0x02020202, 0x02020202,
    0x02020200, 0x02020200, 0x02020202, 0x02020202,
  },
  {
    0x00000000, 0x00000000, 0x00000004, 0x00000004, 0x00000000, 0x00000000,
    0x00000004, 0x00000004, 0x00000400, 0x00000400, 0x00000404, 0x00000404,
    0x00000400, 0x00000400, 0x00000404, 0x00000404, 0x00000000, 0x00000000,
    0x00000004, 0x00000004, 0x00000000, 0x00000000, 0x00000004, 0x00000004,
    0x00000400, 0x00000400, 0x00000404, 0x00000404, 0x00000400, 0x00000400,
    0x00000404, 0x00000404, 0x00040000, 0x00040000, 0x00040004, 0x00040004,
    0x00040000, 0x00040000, 0x00040004, 0x00040004, 0x00040400, 0x00040400,
    0x00040404, 0x00040404, 0x00040400, 0x00040400, 0x00040404, 0x00040404,
    0x00040000, 0x00040000, 0x00040004, 0x00040004, 0x00040000, 0x00040000,
    0x00040004, 0x00040004, 0x00040400, 0x00040400, 0x00040404, 0x00040404,
    0x00040400, 0x00040400, 0x00040404, 0x00040404, 0x00000000, 0x00000000,
    0x00000004, 0x00000004, 0x00000000, 0x00000000, 0x00000004, 0x00000004,
    0x00000400, 0x00000400, 0x00000404, 0x00000404, 0x00000400, 0x00000400,
    0x00000404, 0x00000404, 0x00000000, 0x00000000, 0x00000004, 0x00000004,
    0x00000000, 0x00000000, 0x00000004, 0x00000004, 0x00000400, 0x00000400,
    0x00000404, 0x00000404, 0x00000400, 0x00000400, 0x00000404, 0x00000404,
    0x00040000, 0x00040000, 0x00040004, 0x00040004, 0x00040000, 0x00040000,
    0x00040004, 0x00040004, 0x00040400, 0x00040400, 0x00040404, 0x00040404,
    0x00040400, 0x00040400, 0x00040404, 0x00040404, 0x00040000, 0x00040000,
    0x00040004, 0x00040004, 0x00040000, 0x00040000, 0x00040004, 0x00040004,
    0x00040400, 0x00040400, 0x00040404, 0x00040404, 0x00040400, 0x00040400,
    0x00040404, 0x00040404, 0x04000000, 0x04000000, 0x04000004, 0x04000004,
    0x04000000, 0x04000000, 0x04000004, 0x04000004, 0x04000400, 0x04000400,
    0x04000404, 0x04000404, 0x04000400, 0x04000400, 0x04000404, 0x04000404,
    0x04000000, 0x04000000, 0x04000004, 0x04000004, 0x04000000, 0x04000000,
    0x04000004, 0x04000004, 0x04000400, 0x04000400, 0x04000404, 0x04000404,
    0x04000400, 0x04000400, 0x04000404, 0x04000404, 0x04040000, 0x04040000,
    0x04040004, 0x04040004, 0x04040000, 0x04040000, 0x04040004, 0x04040004,
    0x04040400, 0x04040400, 0x04040404, 0x04040404, 0x04040400, 0x04040400,
    0x04040404, 0x04040404, 0x04040000, 0x04040000, 0x04040004, 0x04040004,
    0x04040000, 0x04040000, 0x04040004, 0x04040004, 0x04040400, 0x04040400,
    0x04040404, 0x04040404, 0x04040400, 0x04040400, 0x04040404, 0x04040404,
    0x04000000, 0x04000000, 0x04000004, 0x04000004, 0x04000000, 0x04000000,
    0x04000004, 0x04000004, 0x04000400, 0x04000400, 0x04000404, 0x04000404,
    0x04000400, 0x04000400, 0x04000404, 0x04000404, 0x04000000, 0x04000000,
    0x04000004, 0x04000004, 0x04000000, 0x04000000, 0x04000004, 0x04000004,
    0x04000400, 0x04000400, 0x04000404, 0x04000404, 0x04000400, 0x04000400,
    0x04000404, 0x04000404, 0x04040000, 0x04040000, 0x04040004, 0x04040004,
    0x04040000, 0x04040000, 0x04040004, 0x04040004, 0x04040400, 0x04040400,
    0x04040404, 0x04040404, 0x04040400, 0x04040400, 0x04040404, 0x04040404,
    0x04040000, 0x04040000, 0x04040004, 0x04040004, 0x04040000, 0x04040000,
    0x04040004, 0x04040004, 0x04040400, 0x04040400, 0x04040404, 0x04040404,
    0x04040400, 0x04040400, 0x04040404, 0x04040404,
  },
  {
    0x00000000, 0x00000000, 0x00000008, 0x00000008, 0x00000000, 0x00000000,
    0x00000008, 0x00000008, 0x00000800, 0x00000800, 0x00000808, 0x00000808,
    0x00000800, 0x00000800, 0x00000808, 0x00000808, 0x00000000, 0x00000000,
    0x00000008, 0x00000008, 0x00000000, 0x00000000, 0x00000008, 0x00000008,
    0x00000800, 0x00000800, 0x00000808, 0x00000808, 0x00000800, 0x00000800,
    0x00000808, 0x00000808, 0x00080000, 0x00080000, 0x00080008, 0x00080008,
    0x00080000, 0x00080000, 0x00080008, 0x00080008, 0x00080800, 0x00080800,
    0x00080808, 0x00080808, 0x00080800, 0x00080800, 0x00080808, 0x00080808,
    0x00080000, 0x00080000, 0x00080008, 0x00080008, 0x00080000, 0x00080000,
    0x00080008, 0x00080008, 0x00080800, 0x00080800, 0x00080808, 0x00080808,
    0x00080800, 0x00080800, 0x00080808, 0x00080808, 0x00000000, 0x00000000,
    0x00000008, 0x00000008, 0x00000000, 0x00000000, 0x00000008, 0x00000008,
    0x00000800, 0x00000800, 0x00000808, 0x00000808, 0x00000800, 0x00000800,
    0x00000808, 0x00000808, 0x00000000, 0x00000000, 0x00000008, 0x00000008,
    0x00000000, 0x00000000, 0x00000008, 0x00000008, 0x00000800, 0x00000800,
    0x00000808, 0x00000808, 0x00000800, 0x00000800, 0x00000808, 0x00000808,
    0x00080000, 0x00080000, 0x00080008, 0x00080008, 0x00080000, 0x00080000,
    0x00080008, 0x00080008, 0x00080800, 0x00080800, 0x00080808, 0x00080808,
    0x00080800, 0x00080800, 0x00080808, 0x00080808, 0x00080000, 0x00080000,
    0x00080008, 0x00080008, 0x00080000, 0x00080000, 0x00080008, 0x00080008,
    0x00080800, 0x00080800, 0x00080808, 0x00080808, 0x00080800, 0x00080800,
    0x00080808, 0x00080808, 0x08000000, 0x08000000, 0x08000008, 0x08000008,
    0x08000000, 0x08000000, 0x08000008, 0x08000008, 0x08000800, 0x08000800,
    0x08000808, 0x08000808, 0x08000800, 0x08000800, 0x08000808, 0x08000808,
    0x08000000, 0x08000000, 0x08000008, 0x08000008, 0x08000000, 0x08000000,
    0x08000008, 0x08000008, 0x08000800, 0x08000800, 0x08000808, 0x08000808,
    0x08000800, 0x08000800, 0x08000808, 0x08000808, 0x08080000, 0x08080000,
    0x08080008, 0x08080008, 0x08080000, 0x08080000, 0x08080008, 0x08080008,
    0x08080800, 0x08080800, 0x08080808, 0x08080808, 0x08080800, 0x08080800,
    0x08080808, 0x08080808, 0x08080000, 0x08080000, 0x08080008, 0x08080008,
    0x08080000, 0x08080000, 0x08080008, 0x08080008, 0x08080800, 0x08080800,
    0x08080808, 0x08080808, 0x08080800, 0x08080800, 0x08080808, 0x08080808,
    0x08000000, 0x08000000, 0x08000008, 0x08000008, 0x08000000, 0x08000000,
    0x08000008, 0x08000008, 0x08000800, 0x08000800, 0x08000808, 0x08000808,
    0x08000800, 0x08000800, 0x08000808, 0x08000808, 0x08000000, 0x08000000,
    0x08000008, 0x08000008, 0x08000000, 0x08000000, 0x08000008, 0x08000008,
    0x08000800, 0x08000800, 0x08000808, 0x08000808, 0x08000800, 0x08000800,
    0x08000808, 0x08000808, 0x08080000, 0x08080000, 0x08080008, 0x08080008,
    0x08080000, 0x08080000, 0x08080008, 0x08080008, 0x08080800, 0x08080800,
    0x08080808, 0x08080808, 0x08080800, 0x08080800, 0x08080808, 0x08080808,
    0x08080000, 0x08080000, 0x08080008, 0x08080008, 0x08080000, 0x08080000,
    0x08080008, 0x08080008, 0x08080800, 0x08080800, 0x08080808, 0x08080808,
    0x08080800, 0x08080800, 0x08080808, 0x08080808,
  },
  {
    0x00000000, 0x00000000, 0x00000010, 0x00000010, 0x00000000, 0x00000000,
    0x00000010, 0x00000010, 0x00001000, 0x00001000, 0x00001010, 0x00001010,
    0x00001000, 0x00001000, 0x00001010, 0x00001010, 0x00000000, 0x00000000,
    0x00000010, 0x00000010, 0x00000000, 0x00000000, 0x00000010, 0x00000010,
    0x00001000, 0x00001000, 0x00001010, 0x00001010, 0x00001000, 0x00001000,
    0x00001010, 0x00001010, 0x00100000, 0x00100000, 0x00100010, 0x00100010,
    0x00100000, 0x00100000, 0x00100010, 0x00100010, 0x00101000, 0x00101000,
    0x00101010, 0x00101010, 0x00101000, 0x00101000, 0x00101010, 0x00101010,
    0x00100000, 0x00100000, 0x00100010, 0x00100010, 0x00100000, 0x00100000,
    0x00100010, 0x00100010, 0x00101000, 0x00101000, 0x00101010, 0x00101010,
    0x00101000, 0x00101000, 0x00101010, 0x00101010, 0x00000000, 0x00000000,
    0x00000010, 0x00000010, 0x00000000, 0x00000000, 0x00000010, 0x00000010,
    0x00001000, 0x00001000, 0x00001010, 0x00001010, 0x00001000, 0x00001000,
    0x00001010, 0x00001010, 0x00000000, 0x00000000, 0x00000010, 0x00000010,
    0x00000000, 0x00000000, 0x00000010, 0x00000010, 0x00001000, 0x00001000,
    0x00001010, 0x00001010, 0x00001000, 0x00001000, 0x00001010, 0x00001010,
    0x00100000, 0x00100000, 0x00100010, 0x00100010, 0x00100000, 0x00100000,
    0x00100010, 0x00100010, 0x00101000, 0x00101000, 0x00101010, 0x00101010,
    0x00101000, 0x00101000, 0x00101010, 0x00101010, 0x00100000, 0x00100000,
    0x00100010, 0x00100010, 0x00100000, 0x00100000, 0x00100010, 0x00100010,
    0x00101000, 0x00101000, 0x00101010, 0x00101010, 0x00101000, 0x00101000,
    0x00101010, 0x00101010, 0x10000000, 0x10000000, 0x10000010, 0x10000010,
    0x10000000, 0x10000000, 0x10000010, 0x10000010, 0x10001000, 0x10001000,
    0x10001010, 0x10001010, 0x10001000, 0x10001000, 0x10001010, 0x10001010,
    0x10000000, 0x10000000, 0x10000010, 0x10000010, 0x10000000, 0x10000000,
    0x10000010, 0x10000010, 0x10001000, 0x10001000, 0x10001010, 0x10001010,
    0x10001000, 0x10001000, 0x10001010, 0x10001010, 0x10100000, 0x10100000,
    0x10100010, 0x10100010, 0x10100000, 0x10100000, 0x10100010, 0x10100010,
    0x10101000, 0x10101000, 0x10101010, 0x10101010, 0x10101000, 0x10101000,
    0x10101010, 0x10101010, 0x10100000, 0x10100000, 0x10100010, 0x10100010,
    0x10100000, 0x10100000, 0x10100010, 0x10100010, 0x10101000, 0x10101000,
    0x10101010, 0x10101010, 0x10101000, 0x10101000, 0x10101010, 0x10101010,
    0x10000000, 0x10000000, 0x10000010, 0x10000010, 0x10000000, 0x10000000,
    0x10000010, 0x10000010, 0x10001000, 0x10001000, 0x10001010, 0x10001010,
    0x10001000, 0x10001000, 0x10001010, 0x10001010, 0x10000000, 0x10000000,
    0x10000010, 0x10000010, 0x10000000, 0x10000000, 0x10000010, 0x10000010,
    0x10001000, 0x10001000, 0x10001010, 0x10001010, 0x10001000, 0x10001000,
    0x10001010, 0x10001010, 0x10100000, 0x10100000, 0x10100010, 0x10100010,
    0x10100000, 0x10100000, 0x10100010, 0x10100010, 0x10101000, 0x10101000,
    0x10101010, 0x10101010, 0x10101000, 0x10101000, 0x10101010, 0x10101010,
    0x10100000, 0x10100000, 0x10100010, 0x10100010, 0x10100000, 0x10100000,
    0x10100010, 0x10100010, 0x10101000, 0x10101000, 0x10101010, 0x10101010,
    0x10101000, 0x10101000, 0x10101010, 0x10101010,
  },
  {
    0x00000000, 0x00000000, 0x00000020, 0x00000020, 0x00000000, 0x00000000,
    0x00000020, 0x00000020, 0x00002000, 0x00002000, 0x00002020, 0x00002020,
    0x00002000, 0x00002000, 0x00002020, 0x00002020, 0x00000000, 0x00000000,
    0x00000020, 0x00000020, 0x00000000, 0x00000000, 0x00000020, 0x00000020,
    0x00002000, 0x00002000, 0x00002020, 0x00002020, 0x00002000, 0x00002000,
    0x00002020, 0x00002020, 0x00200000, 0x00200000, 0x00200020, 0x00200020,
    0x00200000, 0x00200000, 0x00200020, 0x00200020, 0x00202000, 0x00202000,
    0x00202020, 0x00202020, 0x00202000, 0x00202000, 0x00202020, 0x00202020,
    0x00200000, 0x00200000, 0x00200020, 0x00200020, 0x00200000, 0x00200000,
    0x00200020, 0x00200020, 0x00202000, 0x00202000, 0x00202020, 0x00202020,
    0x00202000, 0x00202000, 0x00202020, 0x00202020, 0x00000000, 0x00000000,
    0x00000020, 0x00000020, 0x00000000, 0x00000000, 0x00000020, 0x00000020,
    0x00002000, 0x00002000, 0x00002020, 0x00002020, 0x00002000, 0x00002000,
    0x00002020, 0x00002020, 0x00000000, 0x00000000, 0x00000020, 0x00000020,
    0x00000000, 0x00000000, 0x00000020, 0x00000020, 0x00002000, 0x00002000,
    0x00002020, 0x00002020, 0x00002000, 0x00002000, 0x00002020, 0x00002020,
    0x00200000, 0x00200000, 0x00200020, 0x00200020, 0x00200000, 0x00200000,
    0x00200020, 0x00200020, 0x00202000, 0x00202000, 0x00202020, 0x00202020,
    0x00202000, 0x00202000, 0x00202020, 0x00202020, 0x00200000, 0x00200000,
    0x00200020, 0x00200020, 0x00200000, 0x00200000, 0x00200020, 0x00200020,
    0x00202000, 0x00202000, 0x00202020, 0x00202020, 0x00202000, 0x00202000,
    0x00202020, 0x00202020, 0x20000000, 0x20000000, 0x20000020, 0x20000020,
    0x20000000, 0x20000000, 0x20000020, 0x20000020, 0x20002000, 0x20002000,
    0x20002020, 0x20002020, 0x20002000, 0x20002000, 0x20002020, 0x20002020,
    0x20000000, 0x20000000, 0x20000020, 0x20000020, 0x20000000, 0x20000000,
    0x20000020, 0x20000020, 0x20002000, 0x20002000, 0x20002020, 0x20002020,
    0x20002000, 0x20002000, 0x20002020, 0x20002020, 0x20200000, 0x20200000,
    0x20200020, 0x20200020, 0x20200000, 0x20200000, 0x20200020, 0x20200020,
    0x20202000, 0x20202000, 0x20202020, 0x20202020, 0x20202000, 0x20202000,
    0x20202020, 0x20202020, 0x20200000, 0x20200000, 0x20200020, 0x20200020,
    0x20200000, 0x20200000, 0x20200020, 0x20200020, 0x20202000, 0x20202000,
    0x20202020, 0x20202020, 0x20202000, 0x20202000, 0x20202020, 0x20202020,
    0x20000000, 0x20000000, 0x20000020, 0x20000020, 0x20000000, 0x20000000,
    0x20000020, 0x20000020, 0x20002000, 0x20002000, 0x20002020, 0x20002020,
    0x20002000, 0x20002000, 0x20002020, 0x20002020, 0x20000000, 0x20000000,
    0x20000020, 0x20000020, 0x20000000, 0x20000000, 0x20000020, 0x20000020,
    0x20002000, 0x20002000, 0x20002020, 0x20002020, 0x20002000, 0x20002000,
    0x20002020, 0x20002020, 0x20200000, 0x20200000, 0x20200020, 0x20200020,
    0x20200000, 0x20200000, 0x20200020, 0x20200020, 0x20202000, 0x20202000,
    0x20202020, 0x20202020, 0x20202000, 0x20202000, 0x20202020, 0x20202020,
    0x20200000, 0x20200000, 0x20200020, 0x20200020, 0x20200000, 0x20200000,
    0x20200020, 0x20200020, 0x20202000, 0x20202000, 0x20202020, 0x20202020,
    0x20202000, 0x20202000, 0x20202020, 0x20202020,
  },
  {
    0x00000000, 0x00000000, 0x00000040, 0x00000040, 0x00000000, 0x00000000,
    0x00000040, 0x00000040, 0x00004000, 0x00004000, 0x00004040, 0x00004040,
    0x00004000, 0x00004000, 0x00004040, 0x00004040, 0x00000000, 0x00000000,
    0x00000040, 0x00000040, 0x00000000, 0x00000000, 0x00000040, 0x00000040,
    0x00004000, 0x00004000, 0x00004040, 0x00004040, 0x00004000, 0x00004000,
    0x00004040, 0x00004040, 0x00400000, 0x00400000, 0x00400040, 0x00400040,
    0x00400000, 0x00400000, 0x00400040, 0x00400040, 0x00404000, 0x00404000,
    0x00404040, 0x00404040, 0x00404000, 0x00404000, 0x00404040, 0x00404040,
    0x00400000, 0x00400000, 0x00400040, 0x00400040, 0x00400000, 0x00400000,
    0x00400040, 0x00400040, 0x00404000, 0x00404000, 0x00404040, 0x00404040,
    0x00404000, 0x00404000, 0x00404040, 0x00404040, 0x00000000, 0x00000000,
    0x00000040, 0x00000040, 0x00000000, 0x00000000, 0x00000040, 0x00000040,
    0x00004000, 0x00004000, 0x00004040, 0x00004040, 0x00004000, 0x00004000,
    0x00004040, 0x00004040, 0x00000000, 0x00000000, 0x00000040, 0x00000040,
    0x00000000, 0x00000000, 0x00000040, 0x00000040, 0x00004000, 0x00004000,
    0x00004040, 0x00004040, 0x00004000, 0x00004000, 0x00004040, 0x00004040,
    0x00400000, 0x00400000, 0x00400040, 0x00400040, 0x00400000, 0x00400000,
    0x00400040, 0x00400040, 0x00404000, 0x00404000, 0x00404040, 0x00404040,
    0x00404000, 0x00404000, 0x00404040, 0x00404040, 0x00400000, 0x00400000,
    0x00400040, 0x00400040, 0x00400000, 0x00400000, 0x00400040, 0x00400040,
    0x00404000, 0x00404000, 0x00404040, 0x00404040, 0x00404000, 0x00404000,
    0x00404040, 0x00404040, 0x40000000, 0x40000000, 0x40000040, 0x40000040,
    0x40000000, 0x40000000, 0x40000040, 0x40000040, 0x40004000, 0x40004000,
    0x40004040, 0x40004040, 0x40004000, 0x40004000, 0x40004040, 0x40004040,
    0x40000000, 0x40000000, 0x40000040, 0x40000040, 0x40000000, 0x40000000,
    0x40000040, 0x40000040, 0x40004000, 0x40004000, 0x40004040, 0x40004040,
    0x40004000, 0x40004000, 0x40004040, 0x40004040, 0x40400000, 0x40400000,
    0x40400040, 0x40400040, 0x40400000, 0x40400000, 0x40400040, 0x40400040,
    0x40404000, 0x40404000, 0x40404040, 0x40404040, 0x40404000, 0x40404000,
    0x40404040, 0x40404040, 0x40400000, 0x40400000, 0x40400040, 0x40400040,
    0x40400000, 0x40400000, 0x40400040, 0x40400040, 0x40404000, 0x40404000,
    0x40404040, 0x40404040, 0x40404000, 0x40404000, 0x40404040, 0x40404040,
    0x40000000, 0x40000000, 0x40000040, 0x40000040, 0x40000000, 0x40000000,
    0x40000040, 0x40000040, 0x40004000, 0x40004000, 0x40004040, 0x40004040,
    0x40004000, 0x40004000, 0x40004040, 0x40004040, 0x40000000, 0x40000000,
    0x40000040, 0x40000040, 0x40000000, 0x40000000, 0x40000040, 0x40000040,
    0x40004000, 0x40004000, 0x40004040, 0x40004040, 0x40004000, 0x40004000,
    0x40004040, 0x40004040, 0x40400000, 0x40400000, 0x40400040, 0x40400040,
    0x40400000, 0x40400000, 0x40400040, 0x40400040, 0x40404000, 0x40404000,
    0x40404040, 0x40404040, 0x40404000, 0x40404000, 0x40404040, 0x40404040,
    0x40400000, 0x40400000, 0x40400040, 0x40400040, 0x40400000, 0x40400000,
    0x40400040, 0x40400040, 0x40404000, 0x40404000, 0x40404040, 0x40404040,
    0x40404000, 0x40404000, 0x40404040, 0x40404040,
  },
  {
    0x00000000, 0x00000000, 0x00000080, 0x00000080, 0x00000000, 0x00000000,
    0x00000080, 0x00000080, 0x00008000, 0x00008000, 0x00008080, 0x00008080,
    0x00008000, 0x00008000, 0x00008080, 0x00008080, 0x00000000, 0x00000000,
    0x00000080, 0x00000080, 0x00000000, 0x00000000, 0x00000080, 0x00000080,
    0x00008000, 0x00008000, 0x00008080, 0x00008080, 0x00008000, 0x00008000,
    0x00008080, 0x00008080, 0x00800000, 0x00800000, 0x00800080, 0x00800080,
    0x00800000, 0x00800000, 0x00800080, 0x00800080, 0x00808000, 0x00808000,
    0x00808080, 0x00808080, 0x00808000, 0x00808000, 0x00808080, 0x00808080,
    0x00800000, 0x00800000, 0x00800080, 0x00800080, 0x00800000, 0x00800000,
    0x00800080, 0x00800080, 0x00808000, 0x00808000, 0x00808080, 0x00808080,
    0x00808000, 0x00808000, 0x00808080, 0x00808080, 0x00000000, 0x00000000,
    0x00000080, 0x00000080, 0x00000000, 0x00000000, 0x00000080, 0x00000080,
    0x00008000, 0x00008000, 0x00008080, 0x00008080, 0x00008000, 0x00008000,
    0x00008080, 0x00008080, 0x00000000, 0x00000000, 0x00000080, 0x00000080,
    0x00000000, 0x00000000, 0x00000080, 0x00000080, 0x00008000, 0x00008000,
    0x00008080, 0x00008080, 0x00008000, 0x00008000, 0x00008080, 0x00008080,
    0x00800000, 0x00800000, 0x00800080, 0x00800080, 0x00800000, 0x00800000,
    0x00800080, 0x00800080, 0x00808000, 0x00808000, 0x00808080, 0x00808080,
    0x00808000, 0x00808000, 0x00808080, 0x00808080, 0x00800000, 0x00800000,
    0x00800080, 0x00800080, 0x00800000, 0x00800000, 0x00800080, 0x00800080,
    0x00808000, 0x00808000, 0x00808080, 0x00808080, 0x00808000, 0x00808000,
    0x00808080, 0x00808080, 0x80000000, 0x80000000, 0x80000080, 0x80000080,
    0x80000000, 0x80000000, 0x80000080, 0x80000080, 0x80008000, 0x80008000,
    0x80008080, 0x80008080, 0x80008000, 0x80008000, 0x80008080, 0x80008080,
    0x80000000, 0x80000000, 0x80000080, 0x80000080, 0x80000000, 0x80000000,
    0x80000080, 0x80000080, 0x80008000, 0x80008000, 0x80008080, 0x80008080,
    0x80008000, 0x80008000, 0x80008080, 0x80008080, 0x80800000, 0x80800000,
    0x80800080, 0x80800080, 0x80800000, 0x80800000, 0x80800080, 0x80800080,
    0x80808000, 0x80808000, 0x80808080, 0x80808080, 0x80808000, 0x80808000,
    0x80808080, 0x80808080, 0x80800000, 0x80800000, 0x80800080, 0x80800080,
    0x80800000, 0x80800000, 0x80800080, 0x80800080, 0x80808000, 0x80808000,
    0x80808080, 0x80808080, 0x80808000, 0x80808000, 0x80808080, 0x80808080,
    0x80000000, 0x80000000, 0x80000080, 0x80000080, 0x80000000, 0x80000000,
    0x80000080, 0x80000080, 0x80008000, 0x80008000, 0x80008080, 0x80008080,
    0x80008000, 0x80008000, 0x80008080, 0x80008080, 0x80000000, 0x80000000,
    0x80000080, 0x80000080, 0x80000000, 0x80000000, 0x80000080, 0x80000080,
    0x80008000, 0x80008000, 0x80008080, 0x80008080, 0x80008000, 0x80008000,
    0x80008080, 0x80008080, 0x80800000, 0x80800000, 0x80800080, 0x80800080,
    0x80800000, 0x80800000, 0x80800080, 0x80800080, 0x80808000, 0x80808000,
    0x80808080, 0x80808080, 0x80808000, 0x80808000, 0x80808080, 0x80808080,
    0x80800000, 0x80800000, 0x80800080, 0x80800080, 0x80800000, 0x80800000,
    0x80800080, 0x80800080, 0x80808000, 0x80808000, 0x80808080, 0x80808080,
    0x80808000, 0x80808000, 0x80808080, 0x80808080,
  },
};

const uint32_t fp_maskl[8][256] =
{
  {
    0x00000000, 0x40000000, 0x00400000, 0x40400000, 0x00004000, 0x40004000,
    0x00404000, 0x40404000, 0x00000040, 0x40000040, 0x00400040, 0x40400040,
    0x00004040, 0x40004040, 0x00404040, 0x40404040, 0x00000000, 0x40000000,
    0x00400000, 0x40400000, 0x00004000, 0x40004000, 0x00404000, 0x40404000,
    0x00000040, 0x40000040, 0x00400040, 0x40400040, 0x00004040, 0x40004040,
    0x00404040, 0x40404040, 0x00000000, 0x40000000, 0x00400000, 0x40400000,
    0x00004000, 0x40004000, 0x00404000, 0x40404000, 0x00000040, 0x40000040,
    0x00400040, 0x40400040, 0x00004040, 0x40004040, 0x00404040, 0x40404040,
    0x00000000, 0x40000000, 0x00400000, 0x40400000, 0x00004000, 0x40004000,
    0x00404000, 0x40404000, 0x00000040, 0x40000040, 0x00400040, 0x40400040,
    0x00004040, 0x40004040, 0x00404040, 0x40404040, 0x00000000, 0x40000000,
    0x00400000, 0x40400000, 0x00004000, 0x40004000, 0x00404000, 0x40404000,
    0x00000040, 0x40000040, 0x00400040, 0x40400040, 0x00004040, 0x40004040,
    0x00404040, 0x40404040, 0x00000000, 0x40000000, 0x00400000, 0x40400000,
    0x00004000, 0x40004000, 0x00404000, 0x40404000, 0x00000040, 0x40000040,
    0x00400040, 0x40400040, 0x00004040, 0x40004040, 0x00404040, 0x40404040,
    0x00000000, 0x40000000, 0x00400000, 0x40400000, 0x00004000, 0x40004000,
    0x00404000, 0x40404000, 0x00000040, 0x40000040, 0x00400040, 0x40400040,
    0x00004040, 0x40004040, 0x00404040, 0x40404040, 0x00000000, 0x40000000,
    0x00400000, 0x40400000, 0x00004000, 0x40004000, 0x00404000, 0x40404000,
    0x00000040, 0x40000040, 0x00400040, 0x40400040, 0x00004040, 0x40004040,
    0x00404040, 0x40404040, 0x00000000, 0x40000000, 0x00400000, 0x40400000,
    0x00004000, 0x40004000, 0x00404000, 0x40404000, 0x00000040, 0x40000040,
    0x00400040, 0x40400040, 0x00004040, 0x40004040, 0x00404040, 0x40404040,
    0x00000000, 0x40000000, 0x00400000, 0x40400000, 0x00004000, 0x40004000,
    0x00404000, 0x40404000, 0x00000040, 0x40000040, 0x00400040, 0x40400040,
    0x00004040, 0x40004040, 0x00404040, 0x40404040, 0x00000000, 0x40000000,
    0x00400000, 0x40400000, 0x00004000, 0x40004000, 0x00404000, 0x40404000,
    0x00000040, 0x40000040, 0x00400040, 0x40400040, 0x00004040, 0x40004040,
    0x00404040, 0x40404040, 0x00000000, 0x40000000, 0x00400000, 0x40400000,
    0x00004000, 0x40004000, 0x00404000, 0x40404000, 0x00000040, 0x40000040,
    0x00400040, 0x40400040, 0x00004040, 0x40004040, 0x00404040, 0x40404040,
    0x00000000, 0x40000000, 0x00400000, 0x40400000, 0x00004000, 0x40004000,
    0x00404000, 0x40404000, 0x00000040, 0x40000040, 0x00400040, 0x40400040,
    0x00004040, 0x40004040, 0x00404040, 0x40404040, 0x00000000, 0x40000000,
    0x00400000, 0x40400000, 0x00004000, 0x40004000, 0x00404000, 0x40404000,
    0x00000040, 0x40000040, 0x00400040, 0x40400040, 0x00004040, 0x40004040,
    0x00404040, 0x40404040, 0x00000000, 0x40000000, 0x00400000, 0x40400000,
    0x00004000, 0x40004000, 0x00404000, 0x40404000, 0x00000040, 0x40000040,
    0x00400040, 0x40400040, 0x00004040, 0x40004040, 0x00404040, 0x40404040,
    0x00000000, 0x40000000, 0x00400000, 0x40400000, 0x00004000, 0x40004000,
    0x00404000, 0x40404000, 0x00000040, 0x40000040, 0x00400040, 0x40400040,
    0x00004040, 0x40004040, 0x00404040, 0x40404040,
  },
  {
    0x00000000, 0x10000000, 0x00100000, 0x10100000, 0x00001000, 0x10001000,
    0x00101000, 0x10101000, 0x00000010, 0x10000010, 0x00100010, 0x10100010,
    0x00001010, 0x10001010, 0x00101010, 0x10101010, 0x00000000, 0x10000000,
    0x00100000, 0x10100000, 0x00001000, 0x10001000, 0x00101000, 0x10101000,
    0x00000010, 0x10000010, 0x00100010, 0x10100010, 0x00001010, 0x10001010,
    0x00101010, 0x10101010, 0x00000000, 0x10000000, 0x00100000, 0x10100000,
    0x00001000, 0x10001000, 0x00101000, 0x10101000, 0x00000010, 0x10000010,
    0x00100010, 0x10100010, 0x00001010, 0x10001010, 0x00101010, 0x10101010,
    0x00000000, 0x10000000, 0x00100000, 0x10100000, 0x00001000, 0x10001000,
    0x00101000, 0x10101000, 0x00000010, 0x10000010, 0x00100010, 0x10100010,
    0x00001010, 0x10001010, 0x00101010, 0x10101010, 0x00000000, 0x10000000,
    0x00100000, 0x10100000, 0x00001000, 0x10001000, 0x00101000, 0x10101000,
    0x00000010, 0x10000010, 0x00100010, 0x10100010, 0x00001010, 0x10001010,
    0x00101010, 0x10101010, 0x00000000, 0x10000000, 0x00100000, 0x10100000,
    0x00001000, 0x10001000, 0x00101000, 0x10101000, 0x00000010, 0x10000010,
    0x00100010, 0x10100010, 0x00001010, 0x10001010, 0x00101010, 0x10101010,
    0x00000000, 0x10000000, 0x00100000, 0x10100000, 0x00001000, 0x10001000,
    0x00101000, 0x10101000, 0x00000010, 0x10000010, 0x00100010, 0x10100010,
    0x00001010, 0x10001010, 0x00101010, 0x10101010, 0x00000000, 0x10000000,
    0x00100000, 0x10100000, 0x00001000, 0x10001000, 0x00101000, 0x10101000,
    0x00000010, 0x10000010, 0x00100010, 0x10100010, 0x00001010, 0x10001010,
    0x00101010, 0x10101010, 0x00000000, 0x10000000, 0x00100000, 0x10100000,
    0x00001000, 0x10001000, 0x00101000, 0x10101000, 0x00000010, 0x10000010,
    0x00100010, 0x10100010, 0x00001010, 0x10001010, 0x00101010, 0x10101010,
    0x00000000, 0x10000000, 0x00100000, 0x10100000, 0x00001000, 0x10001000,
    0x00101000, 0x10101000, 0x00000010, 0x10000010, 0x00100010, 0x10100010,
    0x00001010, 0x10001010, 0x00101010, 0x10101010, 0x00000000, 0x10000000,
    0x00100000, 0x10100000, 0x00001000, 0x10001000, 0x00101000, 0x10101000,
    0x00000010, 0x10000010, 0x00100010, 0x10100010, 0x00001010, 0x10001010,
    0x00101010, 0x10101010, 0x00000000, 0x10000000, 0x00100000, 0x10100000,
    0x00001000, 0x10001000, 0x00101000, 0x10101000, 0x00000010, 0x10000010,
    0x00100010, 0x10100010, 0x00001010, 0x10001010, 0x00101010, 0x10101010,
    0x00000000, 0x10000000, 0x00100000, 0x10100000, 0x00001000, 0x10001000,
    0x00101000, 0x10101000, 0x00000010, 0x10000010, 0x00100010, 0x10100010,
    0x00001010, 0x10001010, 0x00101010, 0x10101010, 0x00000000, 0x10000000,
    0x00100000, 0x10100000, 0x00001000, 0x10001000, 0x00101000, 0x10101000,
    0x00000010, 0x10000010, 0x00100010, 0x10100010, 0x00001010, 0x10001010,
    0x00101010, 0x10101010, 0x00000000, 0x10000000, 0x00100000, 0x10100000,
    0x00001000, 0x10001000, 0x00101000, 0x10101000, 0x00000010, 0x10000010,
    0x00100010, 0x10100010, 0x00001010, 0x10001010, 0x00101010, 0x10101010,
    0x00000000, 0x10000000, 0x00100000, 0x10100000, 0x00001000, 0x10001000,
    0x00101000, 0x10101000, 0x00000010, 0x10000010, 0x00100010, 0x10100010,
    0x00001010, 0x10001010, 0x00101010, 0x10101010,
  },
  {
    0x00000000, 0x04000000, 0x00040000, 0x04040000, 0x00000400, 0x04000400,
    0x00040400, 0x04040400, 0x00000004, 0x04000004, 0x00040004, 0x04040004,
    0x00000404, 0x04000404, 0x00040404, 0x04040404, 0x00000000, 0x04000000,
    0x00040000, 0x04040000, 0x00000400, 0x04000400, 0x00040400, 0x04040400,
    0x00000004, 0x04000004, 0x00040004, 0x04040004, 0x00000404, 0x04000404,
    0x00040404, 0x04040404, 0x00000000, 0x04000000, 0x00040000, 0x04040000,
    0x00000400, 0x04000400, 0x00040400, 0x04040400, 0x00000004, 0x04000004,
    0x00040004, 0x04040004, 0x00000404, 0x04000404, 0x00040404, 0x04040404,
    0x00000000, 0x04000000, 0x00040000, 0x04040000, 0x00000400, 0x04000400,
    0x00040400, 0x04040400, 0x00000004, 0x04000004, 0x00040004, 0x04040004,
    0x00000404, 0x04000404, 0x00040404, 0x04040404, 0x00000000, 0x04000000,
    0x00040000, 0x04040000, 0x00000400, 0x04000400, 0x00040400, 0x04040400,
    0x00000004, 0x04000004, 0x00040004, 0x04040004, 0x00000404, 0x04000404,
    0x00040404, 0x04040404, 0x00000000, 0x04000000, 0x00040000, 0x04040000,
    0x00000400, 0x04000400, 0x00040400, 0x04040400, 0x00000004, 0x04000004,
    0x00040004, 0x04040004, 0x00000404, 0x04000404, 0x00040404, 0x04040404,
    0x00000000, 0x04000000, 0x00040000, 0x04040000, 0x00000400, 0x04000400,
    0x00040400, 0x04040400, 0x00000004, 0x04000004, 0x00040004, 0x04040004,
    0x00000404, 0x04000404, 0x00040404, 0x04040404, 0x00000000, 0x04000000,
    0x00040000, 0x04040000, 0x00000400, 0x04000400, 0x00040400, 0x04040400,
    0x00000004, 0x04000004, 0x00040004, 0x04040004, 0x00000404, 0x04000404,
    0x00040404, 0x04040404, 0x00000000, 0x04000000, 0x00040000, 0x04040000,
    0x00000400, 0x04000400, 0x00040400, 0x04040400, 0x00000004, 0x04000004,
    0x00040004, 0x04040004, 0x00000404, 0x04000404, 0x00040404, 0x04040404,
    0x00000000, 0x04000000, 0x00040000, 0x04040000, 0x00000400, 0x04000400,
    0x00040400, 0x04040400, 0x00000004, 0x04000004, 0x00040004, 0x04040004,
    0x00000404, 0x04000404, 0x00040404, 0x04040404, 0x00000000, 0x04000000,
    0x00040000, 0x04040000, 0x00000400, 0x04000400, 0x00040400, 0x04040400,
    0x00000004, 0x04000004, 0x00040004, 0x04040004, 0x00000404, 0x04000404,
    0x00040404, 0x04040404, 0x00000000, 0x04000000, 0x00040000, 0x04040000,
    0x00000400, 0x04000400, 0x00040400, 0x04040400, 0x00000004, 0x04000004,
    0x00040004, 0x04040004, 0x00000404, 0x04000404, 0x00040404, 0x04040404,
    0x00000000, 0x04000000, 0x00040000, 0x04040000, 0x00000400, 0x04000400,
    0x00040400, 0x04040400, 0x00000004, 0x04000004, 0x00040004, 0x04040004,
    0x00000404, 0x04000404, 0x00040404, 0x04040404, 0x00000000, 0x04000000,
    0x00040000, 0x04040000, 0x00000400, 0x04000400, 0x00040400, 0x04040400,
    0x00000004, 0x04000004, 0x00040004, 0x04040004, 0x00000404, 0x04000404,
    0x00040404, 0x04040404, 0x00000000, 0x04000000, 0x00040000, 0x04040000,
    0x00000400, 0x04000400, 0x00040400, 0x04040400, 0x00000004, 0x04000004,
    0x00040004, 0x04040004, 0x00000404, 0x04000404, 0x00040404, 0x04040404,
    0x00000000, 0x04000000, 0x00040000, 0x04040000, 0x00000400, 0x04000400,
    0x00040400, 0x04040400, 0x00000004, 0x04000004, 0x00040004, 0x04040004,
    0x00000404, 0x04000404, 0x00040404, 0x04040404,
  },
  {
    0x00000000, 0x01000000, 0x00010000, 0x01010000, 0x00000100, 0x01000100,
    0x00010100, 0x01010100, 0x00000001, 0x01000001, 0x00010001, 0x01010001,
    0x00000101, 0x01000101, 0x00010101, 0x01010101, 0x00000000, 0x01000000,
    0x00010000, 0x01010000, 0x00000100, 0x01000100, 0x00010100, 0x01010100,
    0x00000001, 0x01000001, 0x00010001, 0x01010001, 0x00000101, 0x01000101,
    0x00010101, 0x01010101, 0x00000000, 0x01000000, 0x00010000, 0x01010000,
    0x00000100, 0x01000100, 0x00010100, 0x01010100, 0x00000001, 0x01000001,
    0x00010001, 0x01010001, 0x00000101, 0x01000101, 0x00010101, 0x01010101,
    0x00000000, 0x01000000, 0x00010000, 0x01010000, 0x00000100, 0x01000100,
    0x00010100, 0x01010100, 0x00000001, 0x01000001, 0x00010001, 0x01010001,
    0x00000101, 0x01000101, 0x00010101, 0x01010101, 0x00000000, 0x01000000,
    0x00010000, 0x01010000, 0x00000100, 0x01000100, 0x00010100, 0x01010100,
    0x00000001, 0x01000001, 0x00010001, 0x01010001, 0x00000101, 0x01000101,
    0x00010101, 0x01010101, 0x00000000, 0x01000000, 0x00010000, 0x01010000,
    0x00000100, 0x01000100, 0x00010100, 0x01010100, 0x00000001, 0x01000001,
    0x00010001, 0x01010001, 0x00000101, 0x01000101, 0x00010101, 0x01010101,
    0x00000000, 0x01000000, 0x00010000, 0x01010000, 0x00000100, 0x01000100,
    0x00010100, 0x01010100, 0x00000001, 0x01000001, 0x00010001, 0x01010001,
    0x00000101, 0x01000101, 0x00010101, 0x01010101, 0x00000000, 0x01000000,
    0x00010000, 0x01010000, 0x00000100, 0x01000100, 0x00010100, 0x01010100,
    0x00000001, 0x01000001, 0x00010001, 0x01010001, 0x00000101, 0x01000101,
    0x00010101, 0x01010101, 0x00000000, 0x01000000, 0x00010000, 0x01010000,
    0x00000100, 0x01000100, 0x00010100, 0x01010100, 0x00000001, 0x01000001,
    0x00010001, 0x01010001, 0x00000101, 0x01000101, 0x00010101, 0x01010101,
    0x00000000, 0x01000000, 0x00010000, 0x01010000, 0x00000100, 0x01000100,
    0x00010100, 0x01010100, 0x00000001, 0x01000001, 0x00010001, 0x01010001,
    0x00000101, 0x01000101, 0x00010101, 0x01010101, 0x00000000, 0x01000000,
    0x00010000, 0x01010000, 0x00000100, 0x01000100, 0x00010100, 0x01010100,
    0x00000001, 0x01000001, 0x00010001, 0x01010001, 0x00000101, 0x01000101,
    0x00010101, 0x01010101, 0x00000000, 0x01000000, 0x00010000, 0x01010000,
    0x00000100, 0x01000100, 0x00010100, 0x01010100, 0x00000001, 0x01000001,
    0x00010001, 0x01010001, 0x00000101, 0x01000101, 0x00010101, 0x01010101,
    0x00000000, 0x01000000, 0x00010000, 0x01010000, 0x00000100, 0x01000100,
    0x00010100, 0x01010100, 0x00000001, 0x01000001, 0x00010001, 0x01010001,
    0x00000101, 0x01000101, 0x00010101, 0x01010101, 0x00000000, 0x01000000,
    0x00010000, 0x01010000, 0x00000100, 0x01000100, 0x00010100, 0x01010100,
    0x00000001, 0x01000001, 0x00010001, 0x01010001, 0x00000101, 0x01000101,
    0x00010101, 0x01010101, 0x00000000, 0x01000000, 0x00010000, 0x01010000,
    0x00000100, 0x01000100, 0x00010100, 0x01010100, 0x00000001, 0x01000001,
    0x00010001, 0x01010001, 0x00000101, 0x01000101, 0x00010101, 0x01010101,
    0x00000000, 0x01000000, 0x00010000, 0x01010000, 0x00000100, 0x01000100,
    0x00010100, 0x01010100, 0x00000001, 0x01000001, 0x00010001, 0x01010001,
    0x00000101, 0x01000101, 0x00010101, 0x01010101,
  },
  {
    0x00000000, 0x80000000, 0x00800000, 0x80800000, 0x00008000, 0x80008000,
    0x00808000, 0x80808000, 0x00000080, 0x80000080, 0x00800080, 0x80800080,
    0x00008080, 0x80008080, 0x00808080, 0x80808080, 0x00000000, 0x80000000,
    0x00800000, 0x80800000, 0x00008000, 0x80008000, 0x00808000, 0x80808000,
    0x00000080, 0x80000080, 0x00800080, 0x80800080, 0x00008080, 0x80008080,
    0x00808080, 0x80808080, 0x00000000, 0x80000000, 0x00800000, 0x80800000,
    0x00008000, 0x80008000, 0x00808000, 0x80808000, 0x00000080, 0x80000080,
    0x00800080, 0x80800080, 0x00008080, 0x80008080, 0x00808080, 0x80808080,
    0x00000000, 0x80000000, 0x00800000, 0x80800000, 0x00008000, 0x80008000,
    0x00808000, 0x80808000, 0x00000080, 0x80000080, 0x00800080, 0x80800080,
    0x00008080, 0x80008080, 0x00808080, 0x80808080, 0x00000000, 0x80000000,
    0x00800000, 0x80800000, 0x00008000, 0x80008000, 0x00808000, 0x80808000,
    0x00000080, 0x80000080, 0x00800080, 0x80800080, 0x00008080, 0x80008080,
    0x00808080, 0x80808080, 0x00000000, 0x80000000, 0x00800000, 0x80800000,
    0x00008000, 0x80008000, 0x00808000, 0x80808000, 0x00000080, 0x80000080,
    0x00800080, 0x80800080, 0x00008080, 0x80008080, 0x00808080, 0x80808080,
    0x00000000, 0x80000000, 0x00800000, 0x80800000, 0x00008000, 0x80008000,
    0x00808000, 0x80808000, 0x00000080, 0x80000080, 0x00800080, 0x80800080,
    0x00008080, 0x80008080, 0x00808080, 0x80808080, 0x00000000, 0x80000000,
    0x00800000, 0x80800000, 0x00008000, 0x80008000, 0x00808000, 0x80808000,
    0x00000080, 0x80000080, 0x00800080, 0x80800080, 0x00008080, 0x80008080,
    0x00808080, 0x80808080, 0x00000000, 0x80000000, 0x00800000, 0x80800000,
    0x00008000, 0x80008000, 0x00808000, 0x80808000, 0x00000080, 0x80000080,
    0x00800080, 0x80800080, 0x00008080, 0x80008080, 0x00808080, 0x80808080,
    0x00000000, 0x80000000, 0x00800000, 0x80800000, 0x00008000, 0x80008000,
    0x00808000, 0x80808000, 0x00000080, 0x80000080, 0x00800080, 0x80800080,
    0x00008080, 0x80008080, 0x00808080, 0x80808080, 0x00000000, 0x80000000,
    0x00800000, 0x80800000, 0x00008000, 0x80008000, 0x00808000, 0x80808000,
    0x00000080, 0x80000080, 0x00800080, 0x80800080, 0x00008080, 0x80008080,
    0x00808080, 0x80808080, 0x00000000, 0x80000000, 0x00800000, 0x80800000,
    0x00008000, 0x80008000, 0x00808000, 0x80808000, 0x00000080, 0x80000080,
    0x00800080, 0x80800080, 0x00008080, 0x80008080, 0x00808080, 0x80808080,
    0x00000000, 0x80000000, 0x00800000, 0x80800000, 0x00008000, 0x80008000,
    0x00808000, 0x80808000, 0x00000080, 0x80000080, 0x00800080, 0x80800080,
    0x00008080, 0x80008080, 0x00808080, 0x80808080, 0x00000000, 0x80000000,
    0x00800000, 0x80800000, 0x00008000, 0x80008000, 0x00808000, 0x80808000,
    0x00000080, 0x80000080, 0x00800080, 0x80800080, 0x00008080, 0x80008080,
    0x00808080, 0x80808080, 0x00000000, 0x80000000, 0x00800000, 0x80800000,
    0x00008000, 0x80008000, 0x00808000, 0x80808000, 0x00000080, 0x80000080,
    0x00800080, 0x80800080, 0x00008080, 0x80008080, 0x00808080, 0x80808080,
    0x00000000, 0x80000000, 0x00800000, 0x80800000, 0x00008000, 0x80008000,
    0x00808000, 0x80808000, 0x00000080, 0x80000080, 0x00800080, 0x80800080,
    0x00008080, 0x80008080, 0x00808080, 0x80808080,
  },
  {
    0x00000000, 0x20000000, 0x00200000, 0x20200000, 0x00002000, 0x20002000,
    0x00202000, 0x20202000, 0x00000020, 0x20000020, 0x00200020, 0x20200020,
    0x00002020, 0x20002020, 0x00202020, 0x20202020, 0x00000000, 0x20000000,
    0x00200000, 0x20200000, 0x00002000, 0x20002000, 0x00202000, 0x20202000,
    0x00000020, 0x20000020, 0x00200020, 0x20200020, 0x00002020, 0x20002020,
    0x00202020, 0x20202020, 0x00000000, 0x20000000, 0x00200000, 0x20200000,
    0x00002000, 0x20002000, 0x00202000, 0x20202000, 0x00000020, 0x20000020,
    0x00200020, 0x20200020, 0x00002020, 0x20002020, 0x00202020, 0x20202020,
    0x00000000, 0x20000000, 0x00200000, 0x20200000, 0x00002000, 0x20002000,
    0x00202000, 0x20202000, 0x00000020, 0x20000020, 0x00200020, 0x20200020,
    0x00002020, 0x20002020, 0x00202020, 0x20202020, 0x00000000, 0x20000000,
    0x00200000, 0x20200000, 0x00002000, 0x20002000, 0x00202000, 0x20202000,
    0x00000020, 0x20000020, 0x00200020, 0x20200020, 0x00002020, 0x20002020,
    0x00202020, 0x20202020, 0x00000000, 0x20000000, 0x00200000, 0x20200000,
    0x00002000, 0x20002000, 0x00202000, 0x20202000, 0x00000020, 0x20000020,
    0x00200020, 0x20200020, 0x00002020, 0x20002020, 0x00202020, 0x20202020,
    0x00000000, 0x20000000, 0x00200000, 0x20200000, 0x00002000, 0x20002000,
    0x00202000, 0x20202000, 0x00000020, 0x20000020, 0x00200020, 0x20200020,
    0x00002020, 0x20002020, 0x00202020, 0x20202020, 0x00000000, 0x20000000,
    0x00200000, 0x20200000, 0x00002000, 0x20002000, 0x00202000, 0x20202000,
    0x00000020, 0x20000020, 0x00200020, 0x20200020, 0x00002020, 0x20002020,
    0x00202020, 0x20202020, 0x00000000, 0x20000000, 0x00200000, 0x20200000,
    0x00002000, 0x20002000, 0x00202000, 0x20202000, 0x00000020, 0x20000020,
    0x00200020, 0x20200020, 0x00002020, 0x20002020, 0x00202020, 0x20202020,
    0x00000000, 0x20000000, 0x00200000, 0x20200000, 0x00002000, 0x20002000,
    0x00202000, 0x20202000, 0x00000020, 0x20000020, 0x00200020, 0x20200020,
    0x00002020, 0x20002020, 0x00202020, 0x20202020, 0x00000000, 0x20000000,
    0x00200000, 0x20200000, 0x00002000, 0x20002000, 0x00202000, 0x20202000,
    0x00000020, 0x20000020, 0x00200020, 0x20200020, 0x00002020, 0x20002020,
    0x00202020, 0x20202020, 0x00000000, 0x20000000, 0x00200000, 0x20200000,
    0x00002000, 0x20002000, 0x00202000, 0x20202000, 0x00000020, 0x20000020,
    0x00200020, 0x20200020, 0x00002020, 0x20002020, 0x00202020, 0x20202020,
    0x00000000, 0x20000000, 0x00200000, 0x20200000, 0x00002000, 0x20002000,
    0x00202000, 0x20202000, 0x00000020, 0x20000020, 0x00200020, 0x20200020,
    0x00002020, 0x20002020, 0x00202020, 0x20202020, 0x00000000, 0x20000000,
    0x00200000, 0x20200000, 0x00002000, 0x20002000, 0x00202000, 0x20202000,
    0x00000020, 0x20000020, 0x00200020, 0x20200020, 0x00002020, 0x20002020,
    0x00202020, 0x20202020, 0x00000000, 0x20000000, 0x00200000, 0x20200000,
    0x00002000, 0x20002000, 0x00202000, 0x20202000, 0x00000020, 0x20000020,
    0x00200020, 0x20200020, 0x00002020, 0x20002020, 0x00202020, 0x20202020,
    0x00000000, 0x20000000, 0x00200000, 0x20200000, 0x00002000, 0x20002000,
    0x00202000, 0x20202000, 0x00000020, 0x20000020, 0x00200020, 0x20200020,
    0x00002020, 0x20002020, 0x00202020, 0x20202020,
  },
  {
    0x00000000, 0x08000000, 0x00080000, 0x08080000, 0x00000800, 0x08000800,
    0x00080800, 0x08080800, 0x00000008, 0x08000008, 0x00080008, 0x08080008,
    0x00000808, 0x08000808, 0x00080808, 0x08080808, 0x00000000, 0x08000000,
    0x00080000, 0x08080000, 0x00000800, 0x08000800, 0x00080800, 0x08080800,
    0x00000008, 0x08000008, 0x00080008, 0x08080008, 0x00000808, 0x08000808,
    0x00080808, 0x08080808, 0x00000000, 0x08000000, 0x00080000, 0x08080000,
    0x00000800, 0x08000800, 0x00080800, 0x08080800, 0x00000008, 0x08000008,
    0x00080008, 0x08080008, 0x00000808, 0x08000808, 0x00080808, 0x08080808,
    0x00000000, 0x08000000, 0x00080000, 0x08080000, 0x00000800, 0x08000800,
    0x00080800, 0x08080800, 0x00000008, 0x08000008, 0x00080008, 0x08080008,
    0x00000808, 0x08000808, 0x00080808, 0x08080808, 0x00000000, 0x08000000,
    0x00080000, 0x08080000, 0x00000800, 0x08000800, 0x00080800, 0x08080800,
    0x00000008, 0x08000008, 0x00080008, 0x08080008, 0x00000808, 0x08000808,
    0x00080808, 0x08080808, 0x00000000, 0x08000000, 0x00080000, 0x08080000,
    0x00000800, 0x08000800, 0x00080800, 0x08080800, 0x00000008, 0x08000008,
    0x00080008, 0x08080008, 0x00000808, 0x08000808, 0x00080808, 0x08080808,
    0x00000000, 0x08000000, 0x00080000, 0x08080000, 0x00000800, 0x08000800,
    0x00080800, 0x08080800, 0x00000008, 0x08000008, 0x00080008, 0x08080008,
    0x00000808, 0x08000808, 0x00080808, 0x08080808, 0x00000000, 0x08000000,
    0x00080000, 0x08080000, 0x00000800, 0x08000800, 0x00080800, 0x08080800,
    0x00000008, 0x08000008, 0x00080008, 0x08080008, 0x00000808, 0x08000808,
    0x00080808, 0x08080808, 0x00000000, 0x08000000, 0x00080000, 0x08080000,
    0x00000800, 0x08000800, 0x00080800, 0x08080800, 0x00000008, 0x08000008,
    0x00080008, 0x08080008, 0x00000808, 0x08000808, 0x00080808, 0x08080808,
    0x00000000, 0x08000000, 0x00080000, 0x08080000, 0x00000800, 0x08000800,
    0x00080800, 0x08080800, 0x00000008, 0x08000008, 0x00080008, 0x08080008,
    0x00000808, 0x08000808, 0x00080808, 0x08080808, 0x00000000, 0x08000000,
    0x00080000, 0x08080000, 0x00000800, 0x08000800, 0x00080800, 0x08080800,
    0x00000008, 0x08000008, 0x00080008, 0x08080008, 0x00000808, 0x08000808,
    0x00080808, 0x08080808, 0x00000000, 0x08000000, 0x00080000, 0x08080000,
    0x00000800, 0x08000800, 0x00080800, 0x08080800, 0x00000008, 0x08000008,
    0x00080008, 0x08080008, 0x00000808, 0x08000808, 0x00080808, 0x08080808,
    0x00000000, 0x08000000, 0x00080000, 0x08080000, 0x00000800, 0x08000800,
    0x00080800, 0x08080800, 0x00000008, 0x08000008, 0x00080008, 0x08080008,
    0x00000808, 0x08000808, 0x00080808, 0x08080808, 0x00000000, 0x08000000,
    0x00080000, 0x08080000, 0x00000800, 0x08000800, 0x00080800, 0x08080800,
    0x00000008, 0x08000008, 0x00080008, 0x08080008, 0x00000808, 0x08000808,
    0x00080808, 0x08080808, 0x00000000, 0x08000000, 0x00080000, 0x08080000,
    0x00000800, 0x08000800, 0x00080800, 0x08080800, 0x00000008, 0x08000008,
    0x00080008, 0x08080008, 0x00000808, 0x08000808, 0x00080808, 0x08080808,
    0x00000000, 0x08000000, 0x00080000, 0x08080000, 0x00000800, 0x08000800,
    0x00080800, 0x08080800, 0x00000008, 0x08000008, 0x00080008, 0x08080008,
    0x00000808, 0x08000808, 0x00080808, 0x08080808,
  },
  {
    0x00000000, 0x02000000, 0x00020000, 0x02020000, 0x00000200, 0x02000200,
    0x00020200, 0x02020200, 0x00000002, 0x02000002, 0x00020002, 0x02020002,
    0x00000202, 0x02000202, 0x00020202, 0x02020202, 0x00000000, 0x02000000,
    0x00020000, 0x02020000, 0x00000200, 0x02000200, 0x00020200, 0x02020200,
    0x00000002, 0x02000002, 0x00020002, 0x02020002, 0x00000202, 0x02000202,
    0x00020202, 0x02020202, 0x00000000, 0x02000000, 0x00020000, 0x02020000,
    0x00000200, 0x02000200, 0x00020200, 0x02020200, 0x00000002, 0x02000002,
    0x00020002, 0x02020002, 0x00000202, 0x02000202, 0x00020202, 0x02020202,
    0x00000000, 0x02000000, 0x00020000, 0x02020000, 0x00000200, 0x02000200,
    0x00020200, 0x02020200, 0x00000002, 0x02000002, 0x00020002, 0x02020002,
    0x00000202, 0x02000202, 0x00020202, 0x02020202, 0x00000000, 0x02000000,
    0x00020000, 0x02020000, 0x00000200, 0x02000200, 0x00020200, 0x02020200,
    0x00000002, 0x02000002, 0x00020002, 0x02020002, 0x00000202, 0x02000202,
    0x00020202, 0x02020202, 0x00000000, 0x02000000, 0x00020000, 0x02020000,
    0x00000200, 0x02000200, 0x00020200, 0x02020200, 0x00000002, 0x02000002,
    0x00020002, 0x02020002, 0x00000202, 0x02000202, 0x00020202, 0x02020202,
    0x00000000, 0x02000000, 0x00020000, 0x02020000, 0x00000200, 0x02000200,
    0x00020200, 0x02020200, 0x00000002, 0x02000002, 0x00020002, 0x02020002,
    0x00000202, 0x02000202, 0x00020202, 0x02020202, 0x00000000, 0x02000000,
    0x00020000, 0x02020000, 0x00000200, 0x02000200, 0x00020200, 0x02020200,
    0x00000002, 0x02000002, 0x00020002, 0x02020002, 0x00000202, 0x02000202,
    0x00020202, 0x02020202, 0x00000000, 0x02000000, 0x00020000, 0x02020000,
    0x00000200, 0x02000200, 0x00020200, 0x02020200, 0x00000002, 0x02000002,
    0x00020002, 0x02020002, 0x00000202, 0x02000202, 0x00020202, 0x02020202,
    0x00000000, 0x02000000, 0x00020000, 0x02020000, 0x00000200, 0x02000200,
    0x00020200, 0x02020200, 0x00000002, 0x02000002, 0x00020002, 0x02020002,
    0x00000202, 0x02000202, 0x00020202, 0x02020202, 0x00000000, 0x02000000,
    0x00020000, 0x02020000, 0x00000200, 0x02000200, 0x00020200, 0x02020200,
    0x00000002, 0x02000002, 0x00020002, 0x02020002, 0x00000202, 0x02000202,
    0x00020202, 0x02020202, 0x00000000, 0x02000000, 0x00020000, 0x02020000,
    0x00000200, 0x02000200, 0x00020200, 0x02020200, 0x00000002, 0x02000002,
    0x00020002, 0x02020002, 0x00000202, 0x02000202, 0x00020202, 0x02020202,
    0x00000000, 0x02000000, 0x00020000, 0x02020000, 0x00000200, 0x02000200,
    0x00020200, 0x02020200, 0x00000002, 0x02000002, 0x00020002, 0x02020002,
    0x00000202, 0x02000202, 0x00020202, 0x02020202, 0x00000000, 0x02000000,
    0x00020000, 0x02020000, 0x00000200, 0x02000200, 0x00020200, 0x02020200,
    0x00000002, 0x02000002, 0x00020002, 0x02020002, 0x00000202, 0x02000202,
    0x00020202, 0x02020202, 0x00000000, 0x02000000, 0x00020000, 0x02020000,
    0x00000200, 0x02000200, 0x00020200, 0x02020200, 0x00000002, 0x02000002,
    0x00020002, 0x02020002, 0x00000202, 0x02000202, 0x00020202, 0x02020202,
    0x00000000, 0x02000000, 0x00020000, 0x02020000, 0x00000200, 0x02000200,
    0x00020200, 0x02020200, 0x00000002, 0x02000002, 0x00020002, 0x02020002,
    0x00000202, 0x02000202, 0x00020202, 0x02020202,
  },
};

const uint32_t fp_maskr[8][256] =
{
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x40000000, 0x40000000,
    0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000,
    0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000,
    0x40000000, 0x40000000, 0x00400000, 0x00400000, 0x00400000, 0x00400000,
    0x00400000, 0x00400000, 0x00400000, 0x00400000, 0x00400000, 0x00400000,
    0x00400000, 0x00400000, 0x00400000, 0x00400000, 0x00400000, 0x00400000,
    0x40400000, 0x40400000, 0x40400000, 0x40400000, 0x40400000, 0x40400000,
    0x40400000, 0x40400000, 0x40400000, 0x40400000, 0x40400000, 0x40400000,
    0x40400000, 0x40400000, 0x40400000, 0x40400000, 0x00004000, 0x00004000,
    0x00004000, 0x00004000, 0x00004000, 0x00004000, 0x00004000, 0x00004000,
    0x00004000, 0x00004000, 0x00004000, 0x00004000, 0x00004000, 0x00004000,
    0x00004000, 0x00004000, 0x40004000, 0x40004000, 0x40004000, 0x40004000,
    0x40004000, 0x40004000, 0x40004000, 0x40004000, 0x40004000, 0x40004000,
    0x40004000, 0x40004000, 0x40004000, 0x40004000, 0x40004000, 0x40004000,
    0x00404000, 0x00404000, 0x00404000, 0x00404000, 0x00404000, 0x00404000,
    0x00404000, 0x00404000, 0x00404000, 0x00404000, 0x00404000, 0x00404000,
    0x00404000, 0x00404000, 0x00404000, 0x00404000, 0x40404000, 0x40404000,
    0x40404000, 0x40404000, 0x40404000, 0x40404000, 0x40404000, 0x40404000,
    0x40404000, 0x40404000, 0x40404000, 0x40404000, 0x40404000, 0x40404000,
    0x40404000, 0x40404000, 0x00000040, 0x00000040, 0x00000040, 0x00000040,
    0x00000040, 0x00000040, 0x00000040, 0x00000040, 0x00000040, 0x00000040,
    0x00000040, 0x00000040, 0x00000040, 0x00000040, 0x00000040, 0x00000040,
    0x40000040, 0x40000040, 0x40000040, 0x40000040, 0x40000040, 0x40000040,
    0x40000040, 0x40000040, 0x40000040, 0x40000040, 0x40000040, 0x40000040,
    0x40000040, 0x40000040, 0x40000040, 0x40000040, 0x00400040, 0x00400040,
    0x00400040, 0x00400040, 0x00400040, 0x00400040, 0x00400040, 0x00400040,
    0x00400040, 0x00400040, 0x00400040, 0x00400040, 0x00400040, 0x00400040,
    0x00400040, 0x00400040, 0x40400040, 0x40400040, 0x40400040, 0x40400040,
    0x40400040, 0x40400040, 0x40400040, 0x40400040, 0x40400040, 0x40400040,
    0x40400040, 0x40400040, 0x40400040, 0x40400040, 0x40400040, 0x40400040,
    0x00004040, 0x00004040, 0x00004040, 0x00004040, 0x00004040, 0x00004040,
    0x00004040, 0x00004040, 0x00004040, 0x00004040, 0x00004040, 0x00004040,
    0x00004040, 0x00004040, 0x00004040, 0x00004040, 0x40004040, 0x40004040,
    0x40004040, 0x40004040, 0x40004040, 0x40004040, 0x40004040, 0x40004040,
    0x40004040, 0x40004040, 0x40004040, 0x40004040, 0x40004040, 0x40004040,
    0x40004040, 0x40004040, 0x00404040, 0x00404040, 0x00404040, 0x00404040,
    0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040,
    0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040,
    0x40404040, 0x40404040, 0x40404040, 0x40404040, 0x40404040, 0x40404040,
    0x40404040, 0x40404040, 0x40404040, 0x40404040, 0x40404040, 0x40404040,
    0x40404040, 0x40404040, 0x40404040, 0x40404040,
  },
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x10000000, 0x10000000,
    0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000,
    0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000,
    0x10000000, 0x10000000, 0x00100000, 0x00100000, 0x00100000, 0x00100000,
    0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000,
    0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000,
    0x10100000, 0x10100000, 0x10100000, 0x10100000, 0x10100000, 0x10100000,
    0x10100000, 0x10100000, 0x10100000, 0x10100000, 0x10100000, 0x10100000,
    0x10100000, 0x10100000, 0x10100000, 0x10100000, 0x00001000, 0x00001000,
    0x00001000, 0x00001000, 0x00001000, 0x00001000, 0x00001000, 0x00001000,
    0x00001000, 0x00001000, 0x00001000, 0x00001000, 0x00001000, 0x00001000,
    0x00001000, 0x00001000, 0x10001000, 0x10001000, 0x10001000, 0x10001000,
    0x10001000, 0x10001000, 0x10001000, 0x10001000, 0x10001000, 0x10001000,
    0x10001000, 0x10001000, 0x10001000, 0x10001000, 0x10001000, 0x10001000,
    0x00101000, 0x00101000, 0x00101000, 0x00101000, 0x00101000, 0x00101000,
    0x00101000, 0x00101000, 0x00101000, 0x00101000, 0x00101000, 0x00101000,
    0x00101000, 0x00101000, 0x00101000, 0x00101000, 0x10101000, 0x10101000,
    0x10101000, 0x10101000, 0x10101000, 0x10101000, 0x10101000, 0x10101000,
    0x10101000, 0x10101000, 0x10101000, 0x10101000, 0x10101000, 0x10101000,
    0x10101000, 0x10101000, 0x00000010, 0x00000010, 0x00000010, 0x00000010,
    0x00000010, 0x00000010, 0x00000010, 0x00000010, 0x00000010, 0x00000010,
    0x00000010, 0x00000010, 0x00000010, 0x00000010, 0x00000010, 0x00000010,
    0x10000010, 0x10000010, 0x10000010, 0x10000010, 0x10000010, 0x10000010,
    0x10000010, 0x10000010, 0x10000010, 0x10000010, 0x10000010, 0x10000010,
    0x10000010, 0x10000010, 0x10000010, 0x10000010, 0x00100010, 0x00100010,
    0x00100010, 0x00100010, 0x00100010, 0x00100010, 0x00100010, 0x00100010,
    0x00100010, 0x00100010, 0x00100010, 0x00100010, 0x00100010, 0x00100010,
    0x00100010, 0x00100010, 0x10100010, 0x10100010, 0x10100010, 0x10100010,
    0x10100010, 0x10100010, 0x10100010, 0x10100010, 0x10100010, 0x10100010,
    0x10100010, 0x10100010, 0x10100010, 0x10100010, 0x10100010, 0x10100010,
    0x00001010, 0x00001010, 0x00001010, 0x00001010, 0x00001010, 0x00001010,
    0x00001010, 0x00001010, 0x00001010, 0x00001010, 0x00001010, 0x00001010,
    0x00001010, 0x00001010, 0x00001010, 0x00001010, 0x10001010, 0x10001010,
    0x10001010, 0x10001010, 0x10001010, 0x10001010, 0x10001010, 0x10001010,
    0x10001010, 0x10001010, 0x10001010, 0x10001010, 0x10001010, 0x10001010,
    0x10001010, 0x10001010, 0x00101010, 0x00101010, 0x00101010, 0x00101010,
    0x00101010, 0x00101010, 0x00101010, 0x00101010, 0x00101010, 0x00101010,
    0x00101010, 0x00101010, 0x00101010, 0x00101010, 0x00101010, 0x00101010,
    0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
    0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x10101010,
    0x10101010, 0x10101010, 0x10101010, 0x10101010,
  },
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x04000000,
    0x04000000, 0x04000000, 0x04000000, 0x04000000, 0x04000000, 0x04000000,
    0x04000000, 0x04000000, 0x04000000, 0x04000000, 0x04000000, 0x04000000,
    0x04000000, 0x04000000, 0x00040000, 0x00040000, 0x00040000, 0x00040000,
    0x00040000, 0x00040000, 0x00040000, 0x00040000, 0x00040000, 0x00040000,
    0x00040000, 0x00040000, 0x00040000, 0x00040000, 0x00040000, 0x00040000,
    0x04040000, 0x04040000, 0x04040000, 0x04040000, 0x04040000, 0x04040000,
    0x04040000, 0x04040000, 0x04040000, 0x04040000, 0x04040000, 0x04040000,
    0x04040000, 0x04040000, 0x04040000, 0x04040000, 0x00000400, 0x00000400,
    0x00000400, 0x00000400, 0x00000400, 0x00000400, 0x00000400, 0x00000400,
    0x00000400, 0x00000400, 0x00000400, 0x00000400, 0x00000400, 0x00000400,
    0x00000400, 0x00000400, 0x04000400, 0x04000400, 0x04000400, 0x04000400,
    0x04000400, 0x04000400, 0x04000400, 0x04000400, 0x04000400, 0x04000400,
    0x04000400, 0x04000400, 0x04000400, 0x04000400, 0x04000400, 0x04000400,
    0x00040400, 0x00040400, 0x00040400, 0x00040400, 0x00040400, 0x00040400,
    0x00040400, 0x00040400, 0x00040400, 0x00040400, 0x00040400, 0x00040400,
    0x00040400, 0x00040400, 0x00040400, 0x00040400, 0x04040400, 0x04040400,
    0x04040400, 0x04040400, 0x04040400, 0x04040400, 0x04040400, 0x04040400,
    0x04040400, 0x04040400, 0x04040400, 0x04040400, 0x04040400, 0x04040400,
    0x04040400, 0x04040400, 0x00000004, 0x00000004, 0x00000004, 0x00000004,
    0x00000004, 0x00000004, 0x00000004, 0x00000004, 0x00000004, 0x00000004,
    0x00000004, 0x00000004, 0x00000004, 0x00000004, 0x00000004, 0x00000004,
    0x04000004, 0x04000004, 0x04000004, 0x04000004, 0x04000004, 0x04000004,
    0x04000004, 0x04000004, 0x04000004, 0x04000004, 0x04000004, 0x04000004,
    0x04000004, 0x04000004, 0x04000004, 0x04000004, 0x00040004, 0x00040004,
    0x00040004, 0x00040004, 0x00040004, 0x00040004, 0x00040004, 0x00040004,
    0x00040004, 0x00040004, 0x00040004, 0x00040004, 0x00040004, 0x00040004,
    0x00040004, 0x00040004, 0x04040004, 0x04040004, 0x04040004, 0x04040004,
    0x04040004, 0x04040004, 0x04040004, 0x04040004, 0x04040004, 0x04040004,
    0x04040004, 0x04040004, 0x04040004, 0x04040004, 0x04040004, 0x04040004,
    0x00000404, 0x00000404, 0x00000404, 0x00000404, 0x00000404, 0x00000404,
    0x00000404, 0x00000404, 0x00000404, 0x00000404, 0x00000404, 0x00000404,
    0x00000404, 0x00000404, 0x00000404, 0x00000404, 0x04000404, 0x04000404,
    0x04000404, 0x04000404, 0x04000404, 0x04000404, 0x04000404, 0x04000404,
    0x04000404, 0x04000404, 0x04000404, 0x04000404, 0x04000404, 0x04000404,
    0x04000404, 0x04000404, 0x00040404, 0x00040404, 0x00040404, 0x00040404,
    0x00040404, 0x00040404, 0x00040404, 0x00040404, 0x00040404, 0x00040404,
    0x00040404, 0x00040404, 0x00040404, 0x00040404, 0x00040404, 0x00040404,
    0x04040404, 0x04040404, 0x04040404, 0x04040404, 0x04040404, 0x04040404,
    0x04040404, 0x04040404, 0x04040404, 0x04040404, 0x04040404, 0x04040404,
    0x04040404, 0x04040404, 0x04040404, 0x04040404,
  },
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000,
    0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000,
    0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000,
    0x01000000, 0x01000000, 0x00010000, 0x00010000, 0x00010000, 0x00010000,
    0x00010000, 0x00010000, 0x00010000, 0x00010000, 0x00010000, 0x00010000,
    0x00010000, 0x00010000, 0x00010000, 0x00010000, 0x00010000, 0x00010000,
    0x01010000, 0x01010000, 0x01010000, 0x01010000, 0x01010000, 0x01010000,
    0x01010000, 0x01010000, 0x01010000, 0x01010000, 0x01010000, 0x01010000,
    0x01010000, 0x01010000, 0x01010000, 0x01010000, 0x00000100, 0x00000100,
    0x00000100, 0x00000100, 0x00000100, 0x00000100, 0x00000100, 0x00000100,
    0x00000100, 0x00000100, 0x00000100, 0x00000100, 0x00000100, 0x00000100,
    0x00000100, 0x00000100, 0x01000100, 0x01000100, 0x01000100, 0x01000100,
    0x01000100, 0x01000100, 0x01000100, 0x01000100, 0x01000100, 0x01000100,
    0x01000100, 0x01000100, 0x01000100, 0x01000100, 0x01000100, 0x01000100,
    0x00010100, 0x00010100, 0x00010100, 0x00010100, 0x00010100, 0x00010100,
    0x00010100, 0x00010100, 0x00010100, 0x00010100, 0x00010100, 0x00010100,
    0x00010100, 0x00010100, 0x00010100, 0x00010100, 0x01010100, 0x01010100,
    0x01010100, 0x01010100, 0x01010100, 0x01010100, 0x01010100, 0x01010100,
    0x01010100, 0x01010100, 0x01010100, 0x01010100, 0x01010100, 0x01010100,
    0x01010100, 0x01010100, 0x00000001, 0x00000001, 0x00000001, 0x00000001,
    0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001,
    0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001,
    0x01000001, 0x01000001, 0x01000001, 0x01000001, 0x01000001, 0x01000001,
    0x01000001, 0x01000001, 0x01000001, 0x01000001, 0x01000001, 0x01000001,
    0x01000001, 0x01000001, 0x01000001, 0x01000001, 0x00010001, 0x00010001,
    0x00010001, 0x00010001, 0x00010001, 0x00010001, 0x00010001, 0x00010001,
    0x00010001, 0x00010001, 0x00010001, 0x00010001, 0x00010001, 0x00010001,
    0x00010001, 0x00010001, 0x01010001, 0x01010001, 0x01010001, 0x01010001,
    0x01010001, 0x01010001, 0x01010001, 0x01010001, 0x01010001, 0x01010001,
    0x01010001, 0x01010001, 0x01010001, 0x01010001, 0x01010001, 0x01010001,
    0x00000101, 0x00000101, 0x00000101, 0x00000101, 0x00000101, 0x00000101,
    0x00000101, 0x00000101, 0x00000101, 0x00000101, 0x00000101, 0x00000101,
    0x00000101, 0x00000101, 0x00000101, 0x00000101, 0x01000101, 0x01000101,
    0x01000101, 0x01000101, 0x01000101, 0x01000101, 0x01000101, 0x01000101,
    0x01000101, 0x01000101, 0x01000101, 0x01000101, 0x01000101, 0x01000101,
    0x01000101, 0x01000101, 0x00010101, 0x00010101, 0x00010101, 0x00010101,
    0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101,
    0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101,
    0x01010101, 0x01010101, 0x01010101, 0x01010101, 0x01010101, 0x01010101,
    0x01010101, 0x01010101, 0x01010101, 0x01010101, 0x01010101, 0x01010101,
    0x01010101, 0x01010101, 0x01010101, 0x01010101,
  },
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x80000000, 0x80000000,
    0x80000000, 0x80000000, 0x80000000, 0x80000000, 0x80000000, 0x80000000,
    0x80000000, 0x80000000, 0x80000000, 0x80000000, 0x80000000, 0x80000000,
    0x80000000, 0x80000000, 0x00800000, 0x00800000, 0x00800000, 0x00800000,
    0x00800000, 0x00800000, 0x00800000, 0x00800000, 0x00800000, 0x00800000,
    0x00800000, 0x00800000, 0x00800000, 0x00800000, 0x00800000, 0x00800000,
    0x80800000, 0x80800000, 0x80800000, 0x80800000, 0x80800000, 0x80800000,
    0x80800000, 0x80800000, 0x80800000, 0x80800000, 0x80800000, 0x80800000,
    0x80800000, 0x80800000, 0x80800000, 0x80800000, 0x00008000, 0x00008000,
    0x00008000, 0x00008000, 0x00008000, 0x00008000, 0x00008000, 0x00008000,
    0x00008000, 0x00008000, 0x00008000, 0x00008000, 0x00008000, 0x00008000,
    0x00008000, 0x00008000, 0x80008000, 0x80008000, 0x80008000, 0x80008000,
    0x80008000, 0x80008000, 0x80008000, 0x80008000, 0x80008000, 0x80008000,
    0x80008000, 0x80008000, 0x80008000, 0x80008000, 0x80008000, 0x80008000,
    0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00808000,
    0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00808000,
    0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x80808000, 0x80808000,
    0x80808000, 0x80808000, 0x80808000, 0x80808000, 0x80808000, 0x80808000,
    0x80808000, 0x80808000, 0x80808000, 0x80808000, 0x80808000, 0x80808000,
    0x80808000, 0x80808000, 0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x80000080, 0x80000080, 0x80000080, 0x80000080, 0x80000080, 0x80000080,
    0x80000080, 0x80000080, 0x80000080, 0x80000080, 0x80000080, 0x80000080,
    0x80000080, 0x80000080, 0x80000080, 0x80000080, 0x00800080, 0x00800080,
    0x00800080, 0x00800080, 0x00800080, 0x00800080, 0x00800080, 0x00800080,
    0x00800080, 0x00800080, 0x00800080, 0x00800080, 0x00800080, 0x00800080,
    0x00800080, 0x00800080, 0x80800080, 0x80800080, 0x80800080, 0x80800080,
    0x80800080, 0x80800080, 0x80800080, 0x80800080, 0x80800080, 0x80800080,
    0x80800080, 0x80800080, 0x80800080, 0x80800080, 0x80800080, 0x80800080,
    0x00008080, 0x00008080, 0x00008080, 0x00008080, 0x00008080, 0x00008080,
    0x00008080, 0x00008080, 0x00008080, 0x00008080, 0x00008080, 0x00008080,
    0x00008080, 0x00008080, 0x00008080, 0x00008080, 0x80008080, 0x80008080,
    0x80008080, 0x80008080, 0x80008080, 0x80008080, 0x80008080, 0x80008080,
    0x80008080, 0x80008080, 0x80008080, 0x80008080, 0x80008080, 0x80008080,
    0x80008080, 0x80008080, 0x00808080, 0x00808080, 0x00808080, 0x00808080,
    0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080,
    0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080,
    0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
    0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080, 0x80808080,
    0x80808080, 0x80808080, 0x80808080, 0x80808080,
  },
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x20000000, 0x20000000,
    0x20000000, 0x20000000, 0x20000000, 0x20000000, 0x20000000, 0x20000000,
    0x20000000, 0x20000000, 0x20000000, 0x20000000, 0x20000000, 0x20000000,
    0x20000000, 0x20000000, 0x00200000, 0x00200000, 0x00200000, 0x00200000,
    0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000,
    0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000,
    0x20200000, 0x20200000, 0x20200000, 0x20200000, 0x20200000, 0x20200000,
    0x20200000, 0x20200000, 0x20200000, 0x20200000, 0x20200000, 0x20200000,
    0x20200000, 0x20200000, 0x20200000, 0x20200000, 0x00002000, 0x00002000,
    0x00002000, 0x00002000, 0x00002000, 0x00002000, 0x00002000, 0x00002000,
    0x00002000, 0x00002000, 0x00002000, 0x00002000, 0x00002000, 0x00002000,
    0x00002000, 0x00002000, 0x20002000, 0x20002000, 0x20002000, 0x20002000,
    0x20002000, 0x20002000, 0x20002000, 0x20002000, 0x20002000, 0x20002000,
    0x20002000, 0x20002000, 0x20002000, 0x20002000, 0x20002000, 0x20002000,
    0x00202000, 0x00202000, 0x00202000, 0x00202000, 0x00202000, 0x00202000,
    0x00202000, 0x00202000, 0x00202000, 0x00202000, 0x00202000, 0x00202000,
    0x00202000, 0x00202000, 0x00202000, 0x00202000, 0x20202000, 0x20202000,
    0x20202000, 0x20202000, 0x20202000, 0x20202000, 0x20202000, 0x20202000,
    0x20202000, 0x20202000, 0x20202000, 0x20202000, 0x20202000, 0x20202000,
    0x20202000, 0x20202000, 0x00000020, 0x00000020, 0x00000020, 0x00000020,
    0x00000020, 0x00000020, 0x00000020, 0x00000020, 0x00000020, 0x00000020,
    0x00000020, 0x00000020, 0x00000020, 0x00000020, 0x00000020, 0x00000020,
    0x20000020, 0x20000020, 0x20000020, 0x20000020, 0x20000020, 0x20000020,
    0x20000020, 0x20000020, 0x20000020, 0x20000020, 0x20000020, 0x20000020,
    0x20000020, 0x20000020, 0x20000020, 0x20000020, 0x00200020, 0x00200020,
    0x00200020, 0x00200020, 0x00200020, 0x00200020, 0x00200020, 0x00200020,
    0x00200020, 0x00200020, 0x00200020, 0x00200020, 0x00200020, 0x00200020,
    0x00200020, 0x00200020, 0x20200020, 0x20200020, 0x20200020, 0x20200020,
    0x20200020, 0x20200020, 0x20200020, 0x20200020, 0x20200020, 0x20200020,
    0x20200020, 0x20200020, 0x20200020, 0x20200020, 0x20200020, 0x20200020,
    0x00002020, 0x00002020, 0x00002020, 0x00002020, 0x00002020, 0x00002020,
    0x00002020, 0x00002020, 0x00002020, 0x00002020, 0x00002020, 0x00002020,
    0x00002020, 0x00002020, 0x00002020, 0x00002020, 0x20002020, 0x20002020,
    0x20002020, 0x20002020, 0x20002020, 0x20002020, 0x20002020, 0x20002020,
    0x20002020, 0x20002020, 0x20002020, 0x20002020, 0x20002020, 0x20002020,
    0x20002020, 0x20002020, 0x00202020, 0x00202020, 0x00202020, 0x00202020,
    0x00202020, 0x00202020, 0x00202020, 0x00202020, 0x00202020, 0x00202020,
    0x00202020, 0x00202020, 0x00202020, 0x00202020, 0x00202020, 0x00202020,
    0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
    0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020, 0x20202020,
    0x20202020, 0x20202020, 0x20202020, 0x20202020,
  },
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08000000, 0x08000000,
    0x08000000, 0x08000000, 0x08000000, 0x08000000, 0x08000000, 0x08000000,
    0x08000000, 0x08000000, 0x08000000, 0x08000000, 0x08000000, 0x08000000,
    0x08000000, 0x08000000, 0x00080000, 0x00080000, 0x00080000, 0x00080000,
    0x00080000, 0x00080000, 0x00080000, 0x00080000, 0x00080000, 0x00080000,
    0x00080000, 0x00080000, 0x00080000, 0x00080000, 0x00080000, 0x00080000,
    0x08080000, 0x08080000, 0x08080000, 0x08080000, 0x08080000, 0x08080000,
    0x08080000, 0x08080000, 0x08080000, 0x08080000, 0x08080000, 0x08080000,
    0x08080000, 0x08080000, 0x08080000, 0x08080000, 0x00000800, 0x00000800,
    0x00000800, 0x00000800, 0x00000800, 0x00000800, 0x00000800, 0x00000800,
    0x00000800, 0x00000800, 0x00000800, 0x00000800, 0x00000800, 0x00000800,
    0x00000800, 0x00000800, 0x08000800, 0x08000800, 0x08000800, 0x08000800,
    0x08000800, 0x08000800, 0x08000800, 0x08000800, 0x08000800, 0x08000800,
    0x08000800, 0x08000800, 0x08000800, 0x08000800, 0x08000800, 0x08000800,
    0x00080800, 0x00080800, 0x00080800, 0x00080800, 0x00080800, 0x00080800,
    0x00080800, 0x00080800, 0x00080800, 0x00080800, 0x00080800, 0x00080800,
    0x00080800, 0x00080800, 0x00080800, 0x00080800, 0x08080800, 0x08080800,
    0x08080800, 0x08080800, 0x08080800, 0x08080800, 0x08080800, 0x08080800,
    0x08080800, 0x08080800, 0x08080800, 0x08080800, 0x08080800, 0x08080800,
    0x08080800, 0x08080800, 0x00000008, 0x00000008, 0x00000008, 0x00000008,
    0x00000008, 0x00000008, 0x00000008, 0x00000008, 0x00000008, 0x00000008,
    0x00000008, 0x00000008, 0x00000008, 0x00000008, 0x00000008, 0x00000008,
    0x08000008, 0x08000008, 0x08000008, 0x08000008, 0x08000008, 0x08000008,
    0x08000008, 0x08000008, 0x08000008, 0x08000008, 0x08000008, 0x08000008,
    0x08000008, 0x08000008, 0x08000008, 0x08000008, 0x00080008, 0x00080008,
    0x00080008, 0x00080008, 0x00080008, 0x00080008, 0x00080008, 0x00080008,
    0x00080008, 0x00080008, 0x00080008, 0x00080008, 0x00080008, 0x00080008,
    0x00080008, 0x00080008, 0x08080008, 0x08080008, 0x08080008, 0x08080008,
    0x08080008, 0x08080008, 0x08080008, 0x08080008, 0x08080008, 0x08080008,
    0x08080008, 0x08080008, 0x08080008, 0x08080008, 0x08080008, 0x08080008,
    0x00000808, 0x00000808, 0x00000808, 0x00000808, 0x00000808, 0x00000808,
    0x00000808, 0x00000808, 0x00000808, 0x00000808, 0x00000808, 0x00000808,
    0x00000808, 0x00000808, 0x00000808, 0x00000808, 0x08000808, 0x08000808,
    0x08000808, 0x08000808, 0x08000808, 0x08000808, 0x08000808, 0x08000808,
    0x08000808, 0x08000808, 0x08000808, 0x08000808, 0x08000808, 0x08000808,
    0x08000808, 0x08000808, 0x00080808, 0x00080808, 0x00080808, 0x00080808,
    0x00080808, 0x00080808, 0x00080808, 0x00080808, 0x00080808, 0x00080808,
    0x00080808, 0x00080808, 0x00080808, 0x00080808, 0x00080808, 0x00080808,
    0x08080808, 0x08080808, 0x08080808, 0x08080808, 0x08080808, 0x08080808,
    0x08080808, 0x08080808, 0x08080808, 0x08080808, 0x08080808, 0x08080808,
    0x08080808, 0x08080808, 0x08080808, 0x08080808,
  },
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x02000000,
    0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000,
    0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000,
    0x02000000, 0x02000000, 0x00020000, 0x00020000, 0x00020000, 0x00020000,
    0x00020000, 0x00020000, 0x00020000, 0x00020000, 0x00020000, 0x00020000,
    0x00020000, 0x00020000, 0x00020000, 0x00020000, 0x00020000, 0x00020000,
    0x02020000, 0x02020000, 0x02020000, 0x02020000, 0x02020000, 0x02020000,
    0x02020000, 0x02020000, 0x02020000, 0x02020000, 0x02020000, 0x02020000,
    0x02020000, 0x02020000, 0x02020000, 0x02020000, 0x00000200, 0x00000200,
    0x00000200, 0x00000200, 0x00000200, 0x00000200, 0x00000200, 0x00000200,
    0x00000200, 0x00000200, 0x00000200, 0x00000200, 0x00000200, 0x00000200,
    0x00000200, 0x00000200, 0x02000200, 0x02000200, 0x02000200, 0x02000200,
    0x02000200, 0x02000200, 0x02000200, 0x02000200, 0x02000200, 0x02000200,
    0x02000200, 0x02000200, 0x02000200, 0x02000200, 0x02000200, 0x02000200,
    0x00020200, 0x00020200, 0x00020200, 0x00020200, 0x00020200, 0x00020200,
    0x00020200, 0x00020200, 0x00020200, 0x00020200, 0x00020200, 0x00020200,
    0x00020200, 0x00020200, 0x00020200, 0x00020200, 0x02020200, 0x02020200,
    0x02020200, 0x02020200, 0x02020200, 0x02020200, 0x02020200, 0x02020200,
    0x02020200, 0x02020200, 0x02020200, 0x02020200, 0x02020200, 0x02020200,
    0x02020200, 0x02020200, 0x00000002, 0x00000002, 0x00000002, 0x00000002,
    0x00000002, 0x00000002, 0x00000002, 0x00000002, 0x00000002, 0x00000002,
    0x00000002, 0x00000002, 0x00000002, 0x00000002, 0x00000002, 0x00000002,
    0x02000002, 0x02000002, 0x02000002, 0x02000002, 0x02000002, 0x02000002,
    0x02000002, 0x02000002, 0x02000002, 0x02000002, 0x02000002, 0x02000002,
    0x02000002, 0x02000002, 0x02000002, 0x02000002, 0x00020002, 0x00020002,
    0x00020002, 0x00020002, 0x00020002, 0x00020002, 0x00020002, 0x00020002,
    0x00020002, 0x00020002, 0x00020002, 0x00020002, 0x00020002, 0x00020002,
    0x00020002, 0x00020002, 0x02020002, 0x02020002, 0x02020002, 0x02020002,
    0x02020002, 0x02020002, 0x02020002, 0x02020002, 0x02020002, 0x02020002,
    0x02020002, 0x02020002, 0x02020002, 0x02020002, 0x02020002, 0x02020002,
    0x00000202, 0x00000202, 0x00000202, 0x00000202, 0x00000202, 0x00000202,
    0x00000202, 0x00000202, 0x00000202, 0x00000202, 0x00000202, 0x00000202,
    0x00000202, 0x00000202, 0x00000202, 0x00000202, 0x02000202, 0x02000202,
    0x02000202, 0x02000202, 0x02000202, 0x02000202, 0x02000202, 0x02000202,
    0x02000202, 0x02000202, 0x02000202, 0x02000202, 0x02000202, 0x02000202,
    0x02000202, 0x02000202, 0x00020202, 0x00020202, 0x00020202, 0x00020202,
    0x00020202, 0x00020202, 0x00020202, 0x00020202, 0x00020202, 0x00020202,
    0x00020202, 0x00020202, 0x00020202, 0x00020202, 0x00020202, 0x00020202,
    0x02020202, 0x02020202, 0x02020202, 0x02020202, 0x02020202, 0x02020202,
    0x02020202, 0x02020202, 0x02020202, 0x02020202, 0x02020202, 0x02020202,
    0x02020202, 0x02020202, 0x02020202, 0x02020202,
  },
};

const uint32_t key_perm_maskl[8][128] =
{
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000010, 0x00000010,
    0x00000010, 0x00000010, 0x00000010, 0x00000010, 0x00000010, 0x00000010,
    0x00000010, 0x00000010, 0x00000010, 0x00000010, 0x00000010, 0x00000010,
    0x00000010, 0x00000010, 0x00001000, 0x00001000, 0x00001000, 0x00001000,
    0x00001000, 0x00001000, 0x00001000, 0x00001000, 0x00001000, 0x00001000,
    0x00001000, 0x00001000, 0x00001000, 0x00001000, 0x00001000, 0x00001000,
    0x00001010, 0x00001010, 0x00001010, 0x00001010, 0x00001010, 0x00001010,
    0x00001010, 0x00001010, 0x00001010, 0x00001010, 0x00001010, 0x00001010,
    0x00001010, 0x00001010, 0x00001010, 0x00001010, 0x00100000, 0x00100000,
    0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000,
    0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000,
    0x00100000, 0x00100000, 0x00100010, 0x00100010, 0x00100010, 0x00100010,
    0x00100010, 0x00100010, 0x00100010, 0x00100010, 0x00100010, 0x00100010,
    0x00100010, 0x00100010, 0x00100010, 0x00100010, 0x00100010, 0x00100010,
    0x00101000, 0x00101000, 0x00101000, 0x00101000, 0x00101000, 0x00101000,
    0x00101000, 0x00101000, 0x00101000, 0x00101000, 0x00101000, 0x00101000,
    0x00101000, 0x00101000, 0x00101000, 0x00101000, 0x00101010, 0x00101010,
    0x00101010, 0x00101010, 0x00101010, 0x00101010, 0x00101010, 0x00101010,
    0x00101010, 0x00101010, 0x00101010, 0x00101010, 0x00101010, 0x00101010,
    0x00101010, 0x00101010,
  },
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000020, 0x00000020,
    0x00000020, 0x00000020, 0x00000020, 0x00000020, 0x00000020, 0x00000020,
    0x00000020, 0x00000020, 0x00000020, 0x00000020, 0x00000020, 0x00000020,
    0x00000020, 0x00000020, 0x00002000, 0x00002000, 0x00002000, 0x00002000,
    0x00002000, 0x00002000, 0x00002000, 0x00002000, 0x00002000, 0x00002000,
    0x00002000, 0x00002000, 0x00002000, 0x00002000, 0x00002000, 0x00002000,
    0x00002020, 0x00002020, 0x00002020, 0x00002020, 0x00002020, 0x00002020,
    0x00002020, 0x00002020, 0x00002020, 0x00002020, 0x00002020, 0x00002020,
    0x00002020, 0x00002020, 0x00002020, 0x00002020, 0x00200000, 0x00200000,
    0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000,
    0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000,
    0x00200000, 0x00200000, 0x00200020, 0x00200020, 0x00200020, 0x00200020,
    0x00200020, 0x00200020, 0x00200020, 0x00200020, 0x00200020, 0x00200020,
    0x00200020, 0x00200020, 0x00200020, 0x00200020, 0x00200020, 0x00200020,
    0x00202000, 0x00202000, 0x00202000, 0x00202000, 0x00202000, 0x00202000,
    0x00202000, 0x00202000, 0x00202000, 0x00202000, 0x00202000, 0x00202000,
    0x00202000, 0x00202000, 0x00202000, 0x00202000, 0x00202020, 0x00202020,
    0x00202020, 0x00202020, 0x00202020, 0x00202020, 0x00202020, 0x00202020,
    0x00202020, 0x00202020, 0x00202020, 0x00202020, 0x00202020, 0x00202020,
    0x00202020, 0x00202020,
  },
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000040, 0x00000040,
    0x00000040, 0x00000040, 0x00000040, 0x00000040, 0x00000040, 0x00000040,
    0x00000040, 0x00000040, 0x00000040, 0x00000040, 0x00000040, 0x00000040,
    0x00000040, 0x00000040, 0x00004000, 0x00004000, 0x00004000, 0x00004000,
    0x00004000, 0x00004000, 0x00004000, 0x00004000, 0x00004000, 0x00004000,
    0x00004000, 0x00004000, 0x00004000, 0x00004000, 0x00004000, 0x00004000,
    0x00004040, 0x00004040, 0x00004040, 0x00004040, 0x00004040, 0x00004040,
    0x00004040, 0x00004040, 0x00004040, 0x00004040, 0x00004040, 0x00004040,
    0x00004040, 0x00004040, 0x00004040, 0x00004040, 0x00400000, 0x00400000,
    0x00400000, 0x00400000, 0x00400000, 0x00400000, 0x00400000, 0x00400000,
    0x00400000, 0x00400000, 0x00400000, 0x00400000, 0x00400000, 0x00400000,
    0x00400000, 0x00400000, 0x00400040, 0x00400040, 0x00400040, 0x00400040,
    0x00400040, 0x00400040, 0x00400040, 0x00400040, 0x00400040, 0x00400040,
    0x00400040, 0x00400040, 0x00400040, 0x00400040, 0x00400040, 0x00400040,
    0x00404000, 0x00404000, 0x00404000, 0x00404000, 0x00404000, 0x00404000,
    0x00404000, 0x00404000, 0x00404000, 0x00404000, 0x00404000, 0x00404000,
    0x00404000, 0x00404000, 0x00404000, 0x00404000, 0x00404040, 0x00404040,
    0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040,
    0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040,
    0x00404040, 0x00404040,
  },
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00008000, 0x00008000, 0x00008000, 0x00008000,
    0x00008000, 0x00008000, 0x00008000, 0x00008000, 0x00008000, 0x00008000,
    0x00008000, 0x00008000, 0x00008000, 0x00008000, 0x00008000, 0x00008000,
    0x00008080, 0x00008080, 0x00008080, 0x00008080, 0x00008080, 0x00008080,
    0x00008080, 0x00008080, 0x00008080, 0x00008080, 0x00008080, 0x00008080,
    0x00008080, 0x00008080, 0x00008080, 0x00008080, 0x00800000, 0x00800000,
    0x00800000, 0x00800000, 0x00800000, 0x00800000, 0x00800000, 0x00800000,
    0x00800000, 0x00800000, 0x00800000, 0x00800000, 0x00800000, 0x00800000,
    0x00800000, 0x00800000, 0x00800080, 0x00800080, 0x00800080, 0x00800080,
    0x00800080, 0x00800080, 0x00800080, 0x00800080, 0x00800080, 0x00800080,
    0x00800080, 0x00800080, 0x00800080, 0x00800080, 0x00800080, 0x00800080,
    0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00808000,
    0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00808000,
    0x00808000, 0x00808000, 0x00808000, 0x00808000, 0x00808080, 0x00808080,
    0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080,
    0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080,
    0x00808080, 0x00808080,
  },
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000001, 0x00000001, 0x00000001, 0x00000001,
    0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000100, 0x00000100,
    0x00000100, 0x00000100, 0x00000100, 0x00000100, 0x00000100, 0x00000100,
    0x00000101, 0x00000101, 0x00000101, 0x00000101, 0x00000101, 0x00000101,
    0x00000101, 0x00000101, 0x00010000, 0x00010000, 0x00010000, 0x00010000,
    0x00010000, 0x00010000, 0x00010000, 0x00010000, 0x00010001, 0x00010001,
    0x00010001, 0x00010001, 0x00010001, 0x00010001, 0x00010001, 0x00010001,
    0x00010100, 0x00010100, 0x00010100, 0x00010100, 0x00010100, 0x00010100,
    0x00010100, 0x00010100, 0x00010101, 0x00010101, 0x00010101, 0x00010101,
    0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x01000000, 0x01000000,
    0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000,
    0x01000001, 0x01000001, 0x01000001, 0x01000001, 0x01000001, 0x01000001,
    0x01000001, 0x01000001, 0x01000100, 0x01000100, 0x01000100, 0x01000100,
    0x01000100, 0x01000100, 0x01000100, 0x01000100, 0x01000101, 0x01000101,
    0x01000101, 0x01000101, 0x01000101, 0x01000101, 0x01000101, 0x01000101,
    0x01010000, 0x01010000, 0x01010000, 0x01010000, 0x01010000, 0x01010000,
    0x01010000, 0x01010000, 0x01010001, 0x01010001, 0x01010001, 0x01010001,
    0x01010001, 0x01010001, 0x01010001, 0x01010001, 0x01010100, 0x01010100,
    0x01010100, 0x01010100, 0x01010100, 0x01010100, 0x01010100, 0x01010100,
    0x01010101, 0x01010101, 0x01010101, 0x01010101, 0x01010101, 0x01010101,
    0x01010101, 0x01010101,
  },
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000002, 0x00000002, 0x00000002, 0x00000002,
    0x00000002, 0x00000002, 0x00000002, 0x00000002, 0x00000200, 0x00000200,
    0x00000200, 0x00000200, 0x00000200, 0x00000200, 0x00000200, 0x00000200,
    0x00000202, 0x00000202, 0x00000202, 0x00000202, 0x00000202, 0x00000202,
    0x00000202, 0x00000202, 0x00020000, 0x00020000, 0x00020000, 0x00020000,
    0x00020000, 0x00020000, 0x00020000, 0x00020000, 0x00020002, 0x00020002,
    0x00020002, 0x00020002, 0x00020002, 0x00020002, 0x00020002, 0x00020002,
    0x00020200, 0x00020200, 0x00020200, 0x00020200, 0x00020200, 0x00020200,
    0x00020200, 0x00020200, 0x00020202, 0x00020202, 0x00020202, 0x00020202,
    0x00020202, 0x00020202, 0x00020202, 0x00020202, 0x02000000, 0x02000000,
    0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000,
    0x02000002, 0x02000002, 0x02000002, 0x02000002, 0x02000002, 0x02000002,
    0x02000002, 0x02000002, 0x02000200, 0x02000200, 0x02000200, 0x02000200,
    0x02000200, 0x02000200, 0x02000200, 0x02000200, 0x02000202, 0x02000202,
    0x02000202, 0x02000202, 0x02000202, 0x02000202, 0x02000202, 0x02000202,
    0x02020000, 0x02020000, 0x02020000, 0x02020000, 0x02020000, 0x02020000,
    0x02020000, 0x02020000, 0x02020002, 0x02020002, 0x02020002, 0x02020002,
    0x02020002, 0x02020002, 0x02020002, 0x02020002, 0x02020200, 0x02020200,
    0x02020200, 0x02020200, 0x02020200, 0x02020200, 0x02020200, 0x02020200,
    0x02020202, 0x02020202, 0x02020202, 0x02020202, 0x02020202, 0x02020202,
    0x02020202, 0x02020202,
  },
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000004, 0x00000004, 0x00000004, 0x00000004,
    0x00000004, 0x00000004, 0x00000004, 0x00000004, 0x00000400, 0x00000400,
    0x00000400, 0x00000400, 0x00000400, 0x00000400, 0x00000400, 0x00000400,
    0x00000404, 0x00000404, 0x00000404, 0x00000404, 0x00000404, 0x00000404,
    0x00000404, 0x00000404, 0x00040000, 0x00040000, 0x00040000, 0x00040000,
    0x00040000, 0x00040000, 0x00040000, 0x00040000, 0x00040004, 0x00040004,
    0x00040004, 0x00040004, 0x00040004, 0x00040004, 0x00040004, 0x00040004,
    0x00040400, 0x00040400, 0x00040400, 0x00040400, 0x00040400, 0x00040400,
    0x00040400, 0x00040400, 0x00040404, 0x00040404, 0x00040404, 0x00040404,
    0x00040404, 0x00040404, 0x00040404, 0x00040404, 0x04000000, 0x04000000,
    0x04000000, 0x04000000, 0x04000000, 0x04000000, 0x04000000, 0x04000000,
    0x04000004, 0x04000004, 0x04000004, 0x04000004, 0x04000004, 0x04000004,
    0x04000004, 0x04000004, 0x04000400, 0x04000400, 0x04000400, 0x04000400,
    0x04000400, 0x04000400, 0x04000400, 0x04000400, 0x04000404, 0x04000404,
    0x04000404, 0x04000404, 0x04000404, 0x04000404, 0x04000404, 0x04000404,
    0x04040000, 0x04040000, 0x04040000, 0x04040000, 0x04040000, 0x04040000,
    0x04040000, 0x04040000, 0x04040004, 0x04040004, 0x04040004, 0x04040004,
    0x04040004, 0x04040004, 0x04040004, 0x04040004, 0x04040400, 0x04040400,
    0x04040400, 0x04040400, 0x04040400, 0x04040400, 0x04040400, 0x04040400,
    0x04040404, 0x04040404, 0x04040404, 0x04040404, 0x04040404, 0x04040404,
    0x04040404, 0x04040404,
  },
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000008, 0x00000008, 0x00000008, 0x00000008,
    0x00000008, 0x00000008, 0x00000008, 0x00000008, 0x00000800, 0x00000800,
    0x00000800, 0x00000800, 0x00000800, 0x00000800, 0x00000800, 0x00000800,
    0x00000808, 0x00000808, 0x00000808, 0x00000808, 0x00000808, 0x00000808,
    0x00000808, 0x00000808, 0x00080000, 0x00080000, 0x00080000, 0x00080000,
    0x00080000, 0x00080000, 0x00080000, 0x00080000, 0x00080008, 0x00080008,
    0x00080008, 0x00080008, 0x00080008, 0x00080008, 0x00080008, 0x00080008,
    0x00080800, 0x00080800, 0x00080800, 0x00080800, 0x00080800, 0x00080800,
    0x00080800, 0x00080800, 0x00080808, 0x00080808, 0x00080808, 0x00080808,
    0x00080808, 0x00080808, 0x00080808, 0x00080808, 0x08000000, 0x08000000,
    0x08000000, 0x08000000, 0x08000000, 0x08000000, 0x08000000, 0x08000000,
    0x08000008, 0x08000008, 0x08000008, 0x08000008, 0x08000008, 0x08000008,
    0x08000008, 0x08000008, 0x08000800, 0x08000800, 0x08000800, 0x08000800,
    0x08000800, 0x08000800, 0x08000800, 0x08000800, 0x08000808, 0x08000808,
    0x08000808, 0x08000808, 0x08000808, 0x08000808, 0x08000808, 0x08000808,
    0x08080000, 0x08080000, 0x08080000, 0x08080000, 0x08080000, 0x08080000,
    0x08080000, 0x08080000, 0x08080008, 0x08080008, 0x08080008, 0x08080008,
    0x08080008, 0x08080008, 0x08080008, 0x08080008, 0x08080800, 0x08080800,
    0x08080800, 0x08080800, 0x08080800, 0x08080800, 0x08080800, 0x08080800,
    0x08080808, 0x08080808, 0x08080808, 0x08080808, 0x08080808, 0x08080808,
    0x08080808, 0x08080808,
  },
};

const uint32_t key_perm_maskr[8][128] =
{
  {
    0x00000000, 0x00100000, 0x00001000, 0x00101000, 0x00000010, 0x00100010,
    0x00001010, 0x00101010, 0x00000001, 0x00100001, 0x00001001, 0x00101001,
    0x00000011, 0x00100011, 0x00001011, 0x00101011, 0x00000000, 0x00100000,
    0x00001000, 0x00101000, 0x00000010, 0x00100010, 0x00001010, 0x00101010,
    0x00000001, 0x00100001, 0x00001001, 0x00101001, 0x00000011, 0x00100011,
    0x00001011, 0x00101011, 0x00000000, 0x00100000, 0x00001000, 0x00101000,
    0x00000010, 0x00100010, 0x00001010, 0x00101010, 0x00000001, 0x00100001,
    0x00001001, 0x00101001, 0x00000011, 0x00100011, 0x00001011, 0x00101011,
    0x00000000, 0x00100000, 0x00001000, 0x00101000, 0x00000010, 0x00100010,
    0x00001010, 0x00101010, 0x00000001, 0x00100001, 0x00001001, 0x00101001,
    0x00000011, 0x00100011, 0x00001011, 0x00101011, 0x00000000, 0x00100000,
    0x00001000, 0x00101000, 0x00000010, 0x00100010, 0x00001010, 0x00101010,
    0x00000001, 0x00100001, 0x00001001, 0x00101001, 0x00000011, 0x00100011,
    0x00001011, 0x00101011, 0x00000000, 0x00100000, 0x00001000, 0x00101000,
    0x00000010, 0x00100010, 0x00001010, 0x00101010, 0x00000001, 0x00100001,
    0x00001001, 0x00101001, 0x00000011, 0x00100011, 0x00001011, 0x00101011,
    0x00000000, 0x00100000, 0x00001000, 0x00101000, 0x00000010, 0x00100010,
    0x00001010, 0x00101010, 0x00000001, 0x00100001, 0x00001001, 0x00101001,
    0x00000011, 0x00100011, 0x00001011, 0x00101011, 0x00000000, 0x00100000,
    0x00001000, 0x00101000, 0x00000010, 0x00100010, 0x00001010, 0x00101010,
    0x00000001, 0x00100001, 0x00001001, 0x00101001, 0x00000011, 0x00100011,
    0x00001011, 0x00101011,
  },
  {
    0x00000000, 0x00200000, 0x00002000, 0x00202000, 0x00000020, 0x00200020,
    0x00002020, 0x00202020, 0x00000002, 0x00200002, 0x00002002, 0x00202002,
    0x00000022, 0x00200022, 0x00002022, 0x00202022, 0x00000000, 0x00200000,
    0x00002000, 0x00202000, 0x00000020, 0x00200020, 0x00002020, 0x00202020,
    0x00000002, 0x00200002, 0x00002002, 0x00202002, 0x00000022, 0x00200022,
    0x00002022, 0x00202022, 0x00000000, 0x00200000, 0x00002000, 0x00202000,
    0x00000020, 0x00200020, 0x00002020, 0x00202020, 0x00000002, 0x00200002,
    0x00002002, 0x00202002, 0x00000022, 0x00200022, 0x00002022, 0x00202022,
    0x00000000, 0x00200000, 0x00002000, 0x00202000, 0x00000020, 0x00200020,
    0x00002020, 0x00202020, 0x00000002, 0x00200002, 0x00002002, 0x00202002,
    0x00000022, 0x00200022, 0x00002022, 0x00202022, 0x00000000, 0x00200000,
    0x00002000, 0x00202000, 0x00000020, 0x00200020, 0x00002020, 0x00202020,
    0x00000002, 0x00200002, 0x00002002, 0x00202002, 0x00000022, 0x00200022,
    0x00002022, 0x00202022, 0x00000000, 0x00200000, 0x00002000, 0x00202000,
    0x00000020, 0x00200020, 0x00002020, 0x00202020, 0x00000002, 0x00200002,
    0x00002002, 0x00202002, 0x00000022, 0x00200022, 0x00002022, 0x00202022,
    0x00000000, 0x00200000, 0x00002000, 0x00202000, 0x00000020, 0x00200020,
    0x00002020, 0x00202020, 0x00000002, 0x00200002, 0x00002002, 0x00202002,
    0x00000022, 0x00200022, 0x00002022, 0x00202022, 0x00000000, 0x00200000,
    0x00002000, 0x00202000, 0x00000020, 0x00200020, 0x00002020, 0x00202020,
    0x00000002, 0x00200002, 0x00002002, 0x00202002, 0x00000022, 0x00200022,
    0x00002022, 0x00202022,
  },
  {
    0x00000000, 0x00400000, 0x00004000, 0x00404000, 0x00000040, 0x00400040,
    0x00004040, 0x00404040, 0x00000004, 0x00400004, 0x00004004, 0x00404004,
    0x00000044, 0x00400044, 0x00004044, 0x00404044, 0x00000000, 0x00400000,
    0x00004000, 0x00404000, 0x00000040, 0x00400040, 0x00004040, 0x00404040,
    0x00000004, 0x00400004, 0x00004004, 0x00404004, 0x00000044, 0x00400044,
    0x00004044, 0x00404044, 0x00000000, 0x00400000, 0x00004000, 0x00404000,
    0x00000040, 0x00400040, 0x00004040, 0x00404040, 0x00000004, 0x00400004,
    0x00004004, 0x00404004, 0x00000044, 0x00400044, 0x00004044, 0x00404044,
    0x00000000, 0x00400000, 0x00004000, 0x00404000, 0x00000040, 0x00400040,
    0x00004040, 0x00404040, 0x00000004, 0x00400004, 0x00004004, 0x00404004,
    0x00000044, 0x00400044, 0x00004044, 0x00404044, 0x00000000, 0x00400000,
    0x00004000, 0x00404000, 0x00000040, 0x00400040, 0x00004040, 0x00404040,
    0x00000004, 0x00400004, 0x00004004, 0x00404004, 0x00000044, 0x00400044,
    0x00004044, 0x00404044, 0x00000000, 0x00400000, 0x00004000, 0x00404000,
    0x00000040, 0x00400040, 0x00004040, 0x00404040, 0x00000004, 0x00400004,
    0x00004004, 0x00404004, 0x00000044, 0x00400044, 0x00004044, 0x00404044,
    0x00000000, 0x00400000, 0x00004000, 0x00404000, 0x00000040, 0x00400040,
    0x00004040, 0x00404040, 0x00000004, 0x00400004, 0x00004004, 0x00404004,
    0x00000044, 0x00400044, 0x00004044, 0x00404044, 0x00000000, 0x00400000,
    0x00004000, 0x00404000, 0x00000040, 0x00400040, 0x00004040, 0x00404040,
    0x00000004, 0x00400004, 0x00004004, 0x00404004, 0x00000044, 0x00400044,
    0x00004044, 0x00404044,
  },
  {
    0x00000000, 0x00800000, 0x00008000, 0x00808000, 0x00000080, 0x00800080,
    0x00008080, 0x00808080, 0x00000008, 0x00800008, 0x00008008, 0x00808008,
    0x00000088, 0x00800088, 0x00008088, 0x00808088, 0x00000000, 0x00800000,
    0x00008000, 0x00808000, 0x00000080, 0x00800080, 0x00008080, 0x00808080,
    0x00000008, 0x00800008, 0x00008008, 0x00808008, 0x00000088, 0x00800088,
    0x00008088, 0x00808088, 0x00000000, 0x00800000, 0x00008000, 0x00808000,
    0x00000080, 0x00800080, 0x00008080, 0x00808080, 0x00000008, 0x00800008,
    0x00008008, 0x00808008, 0x00000088, 0x00800088, 0x00008088, 0x00808088,
    0x00000000, 0x00800000, 0x00008000, 0x00808000, 0x00000080, 0x00800080,
    0x00008080, 0x00808080, 0x00000008, 0x00800008, 0x00008008, 0x00808008,
    0x00000088, 0x00800088, 0x00008088, 0x00808088, 0x00000000, 0x00800000,
    0x00008000, 0x00808000, 0x00000080, 0x00800080, 0x00008080, 0x00808080,
    0x00000008, 0x00800008, 0x00008008, 0x00808008, 0x00000088, 0x00800088,
    0x00008088, 0x00808088, 0x00000000, 0x00800000, 0x00008000, 0x00808000,
    0x00000080, 0x00800080, 0x00008080, 0x00808080, 0x00000008, 0x00800008,
    0x00008008, 0x00808008, 0x00000088, 0x00800088, 0x00008088, 0x00808088,
    0x00000000, 0x00800000, 0x00008000, 0x00808000, 0x00000080, 0x00800080,
    0x00008080, 0x00808080, 0x00000008, 0x00800008, 0x00008008, 0x00808008,
    0x00000088, 0x00800088, 0x00008088, 0x00808088, 0x00000000, 0x00800000,
    0x00008000, 0x00808000, 0x00000080, 0x00800080, 0x00008080, 0x00808080,
    0x00000008, 0x00800008, 0x00008008, 0x00808008, 0x00000088, 0x00800088,
    0x00008088, 0x00808088,
  },
  {
    0x00000000, 0x01000000, 0x00010000, 0x01010000, 0x00000100, 0x01000100,
    0x00010100, 0x01010100, 0x00000000, 0x01000000, 0x00010000, 0x01010000,
    0x00000100, 0x01000100, 0x00010100, 0x01010100, 0x00000000, 0x01000000,
    0x00010000, 0x01010000, 0x00000100, 0x01000100, 0x00010100, 0x01010100,
    0x00000000, 0x01000000, 0x00010000, 0x01010000, 0x00000100, 0x01000100,
    0x00010100, 0x01010100, 0x00000000, 0x01000000, 0x00010000, 0x01010000,
    0x00000100, 0x01000100, 0x00010100, 0x01010100, 0x00000000, 0x01000000,
    0x00010000, 0x01010000, 0x00000100, 0x01000100, 0x00010100, 0x01010100,
    0x00000000, 0x01000000, 0x00010000, 0x01010000, 0x00000100, 0x01000100,
    0x00010100, 0x01010100, 0x00000000, 0x01000000, 0x00010000, 0x01010000,
    0x00000100, 0x01000100, 0x00010100, 0x01010100, 0x00000000, 0x01000000,
    0x00010000, 0x01010000, 0x00000100, 0x01000100, 0x00010100, 0x01010100,
    0x00000000, 0x01000000, 0x00010000, 0x01010000, 0x00000100, 0x01000100,
    0x00010100, 0x01010100, 0x00000000, 0x01000000, 0x00010000, 0x01010000,
    0x00000100, 0x01000100, 0x00010100, 0x01010100, 0x00000000, 0x01000000,
    0x00010000, 0x01010000, 0x00000100, 0x01000100, 0x00010100, 0x01010100,
    0x00000000, 0x01000000, 0x00010000, 0x01010000, 0x00000100, 0x01000100,
    0x00010100, 0x01010100, 0x00000000, 0x01000000, 0x00010000, 0x01010000,
    0x00000100, 0x01000100, 0x00010100, 0x01010100, 0x00000000, 0x01000000,
    0x00010000, 0x01010000, 0x00000100, 0x01000100, 0x00010100, 0x01010100,
    0x00000000, 0x01000000, 0x00010000, 0x01010000, 0x00000100, 0x01000100,
    0x00010100, 0x01010100,
  },
  {
    0x00000000, 0x02000000, 0x00020000, 0x02020000, 0x00000200, 0x02000200,
    0x00020200, 0x02020200, 0x00000000, 0x02000000, 0x00020000, 0x02020000,
    0x00000200, 0x02000200, 0x00020200, 0x02020200, 0x00000000, 0x02000000,
    0x00020000, 0x02020000, 0x00000200, 0x02000200, 0x00020200, 0x02020200,
    0x00000000, 0x02000000, 0x00020000, 0x02020000, 0x00000200, 0x02000200,
    0x00020200, 0x02020200, 0x00000000, 0x02000000, 0x00020000, 0x02020000,
    0x00000200, 0x02000200, 0x00020200, 0x02020200, 0x00000000, 0x02000000,
    0x00020000, 0x02020000, 0x00000200, 0x02000200, 0x00020200, 0x02020200,
    0x00000000, 0x02000000, 0x00020000, 0x02020000, 0x00000200, 0x02000200,
    0x00020200, 0x02020200, 0x00000000, 0x02000000, 0x00020000, 0x02020000,
    0x00000200, 0x02000200, 0x00020200, 0x02020200, 0x00000000, 0x02000000,
    0x00020000, 0x02020000, 0x00000200, 0x02000200, 0x00020200, 0x02020200,
    0x00000000, 0x02000000, 0x00020000, 0x02020000, 0x00000200, 0x02000200,
    0x00020200, 0x02020200, 0x00000000, 0x02000000, 0x00020000, 0x02020000,
    0x00000200, 0x02000200, 0x00020200, 0x02020200, 0x00000000, 0x02000000,
    0x00020000, 0x02020000, 0x00000200, 0x02000200, 0x00020200, 0x02020200,
    0x00000000, 0x02000000, 0x00020000, 0x02020000, 0x00000200, 0x02000200,
    0x00020200, 0x02020200, 0x00000000, 0x02000000, 0x00020000, 0x02020000,
    0x00000200, 0x02000200, 0x00020200, 0x02020200, 0x00000000, 0x02000000,
    0x00020000, 0x02020000, 0x00000200, 0x02000200, 0x00020200, 0x02020200,
    0x00000000, 0x02000000, 0x00020000, 0x02020000, 0x00000200, 0x02000200,
    0x00020200, 0x02020200,
  },
  {
    0x00000000, 0x04000000, 0x00040000, 0x04040000, 0x00000400, 0x04000400,
    0x00040400, 0x04040400, 0x00000000, 0x04000000, 0x00040000, 0x04040000,
    0x00000400, 0x04000400, 0x00040400, 0x04040400, 0x00000000, 0x04000000,
    0x00040000, 0x04040000, 0x00000400, 0x04000400, 0x00040400, 0x04040400,
    0x00000000, 0x04000000, 0x00040000, 0x04040000, 0x00000400, 0x04000400,
    0x00040400, 0x04040400, 0x00000000, 0x04000000, 0x00040000, 0x04040000,
    0x00000400, 0x04000400, 0x00040400, 0x04040400, 0x00000000, 0x04000000,
    0x00040000, 0x04040000, 0x00000400, 0x04000400, 0x00040400, 0x04040400,
    0x00000000, 0x04000000, 0x00040000, 0x04040000, 0x00000400, 0x04000400,
    0x00040400, 0x04040400, 0x00000000, 0x04000000, 0x00040000, 0x04040000,
    0x00000400, 0x04000400, 0x00040400, 0x04040400, 0x00000000, 0x04000000,
    0x00040000, 0x04040000, 0x00000400, 0x04000400, 0x00040400, 0x04040400,
    0x00000000, 0x04000000, 0x00040000, 0x04040000, 0x00000400, 0x04000400,
    0x00040400, 0x04040400, 0x00000000, 0x04000000, 0x00040000, 0x04040000,
    0x00000400, 0x04000400, 0x00040400, 0x04040400, 0x00000000, 0x04000000,
    0x00040000, 0x04040000, 0x00000400, 0x04000400, 0x00040400, 0x04040400,
    0x00000000, 0x04000000, 0x00040000, 0x04040000, 0x00000400, 0x04000400,
    0x00040400, 0x04040400, 0x00000000, 0x04000000, 0x00040000, 0x04040000,
    0x00000400, 0x04000400, 0x00040400, 0x04040400, 0x00000000, 0x04000000,
    0x00040000, 0x04040000, 0x00000400, 0x04000400, 0x00040400, 0x04040400,
    0x00000000, 0x04000000, 0x00040000, 0x04040000, 0x00000400, 0x04000400,
    0x00040400, 0x04040400,
  },
  {
    0x00000000, 0x08000000, 0x00080000, 0x08080000, 0x00000800, 0x08000800,
    0x00080800, 0x08080800, 0x00000000, 0x08000000, 0x00080000, 0x08080000,
    0x00000800, 0x08000800, 0x00080800, 0x08080800, 0x00000000, 0x08000000,
    0x00080000, 0x08080000, 0x00000800, 0x08000800, 0x00080800, 0x08080800,
    0x00000000, 0x08000000, 0x00080000, 0x08080000, 0x00000800, 0x08000800,
    0x00080800, 0x08080800, 0x00000000, 0x08000000, 0x00080000, 0x08080000,
    0x00000800, 0x08000800, 0x00080800, 0x08080800, 0x00000000, 0x08000000,
    0x00080000, 0x08080000, 0x00000800, 0x08000800, 0x00080800, 0x08080800,
    0x00000000, 0x08000000, 0x00080000, 0x08080000, 0x00000800, 0x08000800,
    0x00080800, 0x08080800, 0x00000000, 0x08000000, 0x00080000, 0x08080000,
    0x00000800, 0x08000800, 0x00080800, 0x08080800, 0x00000000, 0x08000000,
    0x00080000, 0x08080000, 0x00000800, 0x08000800, 0x00080800, 0x08080800,
    0x00000000, 0x08000000, 0x00080000, 0x08080000, 0x00000800, 0x08000800,
    0x00080800, 0x08080800, 0x00000000, 0x08000000, 0x00080000, 0x08080000,
    0x00000800, 0x08000800, 0x00080800, 0x08080800, 0x00000000, 0x08000000,
    0x00080000, 0x08080000, 0x00000800, 0x08000800, 0x00080800, 0x08080800,
    0x00000000, 0x08000000, 0x00080000, 0x08080000, 0x00000800, 0x08000800,
    0x00080800, 0x08080800, 0x00000000, 0x08000000, 0x00080000, 0x08080000,
    0x00000800, 0x08000800, 0x00080800, 0x08080800, 0x00000000, 0x08000000,
    0x00080000, 0x08080000, 0x00000800, 0x08000800, 0x00080800, 0x08080800,
    0x00000000, 0x08000000, 0x00080000, 0x08080000, 0x00000800, 0x08000800,
    0x00080800, 0x08080800,
  },
};

const uint32_t comp_maskl[8][128] =
{
  {
    0x00000000, 0x00000010, 0x00004000, 0x00004010, 0x00040000, 0x00040010,
    0x00044000, 0x00044010, 0x00000100, 0x00000110, 0x00004100, 0x00004110,
    0x00040100, 0x00040110, 0x00044100, 0x00044110, 0x00020000, 0x00020010,
    0x00024000, 0x00024010, 0x00060000, 0x00060010, 0x00064000, 0x00064010,
    0x00020100, 0x00020110, 0x00024100, 0x00024110, 0x00060100, 0x00060110,
    0x00064100, 0x00064110, 0x00000001, 0x00000011, 0x00004001, 0x00004011,
    0x00040001, 0x00040011, 0x00044001, 0x00044011, 0x00000101, 0x00000111,
    0x00004101, 0x00004111, 0x00040101, 0x00040111, 0x00044101, 0x00044111,
    0x00020001, 0x00020011, 0x00024001, 0x00024011, 0x00060001, 0x00060011,
    0x00064001, 0x00064011, 0x00020101, 0x00020111, 0x00024101, 0x00024111,
    0x00060101, 0x00060111, 0x00064101, 0x00064111, 0x00080000, 0x00080010,
    0x00084000, 0x00084010, 0x000c0000, 0x000c0010, 0x000c4000, 0x000c4010,
    0x00080100, 0x00080110, 0x00084100, 0x00084110, 0x000c0100, 0x000c0110,
    0x000c4100, 0x000c4110, 0x000a0000, 0x000a0010, 0x000a4000, 0x000a4010,
    0x000e0000, 0x000e0010, 0x000e4000, 0x000e4010, 0x000a0100, 0x000a0110,
    0x000a4100, 0x000a4110, 0x000e0100, 0x000e0110, 0x000e4100, 0x000e4110,
    0x00080001, 0x00080011, 0x00084001, 0x00084011, 0x000c0001, 0x000c0011,
    0x000c4001, 0x000c4011, 0x00080101, 0x00080111, 0x00084101, 0x00084111,
    0x000c0101, 0x000c0111, 0x000c4101, 0x000c4111, 0x000a0001, 0x000a0011,
    0x000a4001, 0x000a4011, 0x000e0001, 0x000e0011, 0x000e4001, 0x000e4011,
    0x000a0101, 0x000a0111, 0x000a4101, 0x000a4111, 0x000e0101, 0x000e0111,
    0x000e4101, 0x000e4111,
  },
  {
    0x00000000, 0x00800000, 0x00000002, 0x00800002, 0x00000200, 0x00800200,
    0x00000202, 0x00800202, 0x00200000, 0x00a00000, 0x00200002, 0x00a00002,
    0x00200200, 0x00a00200, 0x00200202, 0x00a00202, 0x00001000, 0x00801000,
    0x00001002, 0x00801002, 0x00001200, 0x00801200, 0x00001202, 0x00801202,
    0x00201000, 0x00a01000, 0x00201002, 0x00a01002, 0x00201200, 0x00a01200,
    0x00201202, 0x00a01202, 0x00000000, 0x00800000, 0x00000002, 0x00800002,
    0x00000200, 0x00800200, 0x00000202, 0x00800202, 0x00200000, 0x00a00000,
    0x00200002, 0x00a00002, 0x00200200, 0x00a00200, 0x00200202, 0x00a00202,
    0x00001000, 0x00801000, 0x00001002, 0x00801002, 0x00001200, 0x00801200,
    0x00001202, 0x00801202, 0x00201000, 0x00a01000, 0x00201002, 0x00a01002,
    0x00201200, 0x00a01200, 0x00201202, 0x00a01202, 0x00000040, 0x00800040,
    0x00000042, 0x00800042, 0x00000240, 0x00800240, 0x00000242, 0x00800242,
    0x00200040, 0x00a00040, 0x00200042, 0x00a00042, 0x00200240, 0x00a00240,
    0x00200242, 0x00a00242, 0x00001040, 0x00801040, 0x00001042, 0x00801042,
    0x00001240, 0x00801240, 0x00001242, 0x00801242, 0x00201040, 0x00a01040,
    0x00201042, 0x00a01042, 0x00201240, 0x00a01240, 0x00201242, 0x00a01242,
    0x00000040, 0x00800040, 0x00000042, 0x00800042, 0x00000240, 0x00800240,
    0x00000242, 0x00800242, 0x00200040, 0x00a00040, 0x00200042, 0x00a00042,
    0x00200240, 0x00a00240, 0x00200242, 0x00a00242, 0x00001040, 0x00801040,
    0x00001042, 0x00801042, 0x00001240, 0x00801240, 0x00001242, 0x00801242,
    0x00201040, 0x00a01040, 0x00201042, 0x00a01042, 0x00201240, 0x00a01240,
    0x00201242, 0x00a01242,
  },
  {
    0x00000000, 0x00002000, 0x00000004, 0x00002004, 0x00000400, 0x00002400,
    0x00000404, 0x00002404, 0x00000000, 0x00002000, 0x00000004, 0x00002004,
    0x00000400, 0x00002400, 0x00000404, 0x00002404, 0x00400000, 0x00402000,
    0x00400004, 0x00402004, 0x00400400, 0x00402400, 0x00400404, 0x00402404,
    0x00400000, 0x00402000, 0x00400004, 0x00402004, 0x00400400, 0x00402400,
    0x00400404, 0x00402404, 0x00000020, 0x00002020, 0x00000024, 0x00002024,
    0x00000420, 0x00002420, 0x00000424, 0x00002424, 0x00000020, 0x00002020,
    0x00000024, 0x00002024, 0x00000420, 0x00002420, 0x00000424, 0x00002424,
    0x00400020, 0x00402020, 0x00400024, 0x00402024, 0x00400420, 0x00402420,
    0x00400424, 0x00402424, 0x00400020, 0x00402020, 0x00400024, 0x00402024,
    0x00400420, 0x00402420, 0x00400424, 0x00402424, 0x00008000, 0x0000a000,
    0x00008004, 0x0000a004, 0x00008400, 0x0000a400, 0x00008404, 0x0000a404,
    0x00008000, 0x0000a000, 0x00008004, 0x0000a004, 0x00008400, 0x0000a400,
    0x00008404, 0x0000a404, 0x00408000, 0x0040a000, 0x00408004, 0x0040a004,
    0x00408400, 0x0040a400, 0x00408404, 0x0040a404, 0x00408000, 0x0040a000,
    0x00408004, 0x0040a004, 0x00408400, 0x0040a400, 0x00408404, 0x0040a404,
    0x00008020, 0x0000a020, 0x00008024, 0x0000a024, 0x00008420, 0x0000a420,
    0x00008424, 0x0000a424, 0x00008020, 0x0000a020, 0x00008024, 0x0000a024,
    0x00008420, 0x0000a420, 0x00008424, 0x0000a424, 0x00408020, 0x0040a020,
    0x00408024, 0x0040a024, 0x00408420, 0x0040a420, 0x00408424, 0x0040a424,
    0x00408020, 0x0040a020, 0x00408024, 0x0040a024, 0x00408420, 0x0040a420,
    0x00408424, 0x0040a424,
  },
  {
    0x00000000, 0x00010000, 0x00000008, 0x00010008, 0x00000080, 0x00010080,
    0x00000088, 0x00010088, 0x00000000, 0x00010000, 0x00000008, 0x00010008,
    0x00000080, 0x00010080, 0x00000088, 0x00010088, 0x00100000, 0x00110000,
    0x00100008, 0x00110008, 0x00100080, 0x00110080, 0x00100088, 0x00110088,
    0x00100000, 0x00110000, 0x00100008, 0x00110008, 0x00100080, 0x00110080,
    0x00100088, 0x00110088, 0x00000800, 0x00010800, 0x00000808, 0x00010808,
    0x00000880, 0x00010880, 0x00000888, 0x00010888, 0x00000800, 0x00010800,
    0x00000808, 0x00010808, 0x00000880, 0x00010880, 0x00000888, 0x00010888,
    0x00100800, 0x00110800, 0x00100808, 0x00110808, 0x00100880, 0x00110880,
    0x00100888, 0x00110888, 0x00100800, 0x00110800, 0x00100808, 0x00110808,
    0x00100880, 0x00110880, 0x00100888, 0x00110888, 0x00000000, 0x00010000,
    0x00000008, 0x00010008, 0x00000080, 0x00010080, 0x00000088, 0x00010088,
    0x00000000, 0x00010000, 0x00000008, 0x00010008, 0x00000080, 0x00010080,
    0x00000088, 0x00010088, 0x00100000, 0x00110000, 0x00100008, 0x00110008,
    0x00100080, 0x00110080, 0x00100088, 0x00110088, 0x00100000, 0x00110000,
    0x00100008, 0x00110008, 0x00100080, 0x00110080, 0x00100088, 0x00110088,
    0x00000800, 0x00010800, 0x00000808, 0x00010808, 0x00000880, 0x00010880,
    0x00000888, 0x00010888, 0x00000800, 0x00010800, 0x00000808, 0x00010808,
    0x00000880, 0x00010880, 0x00000888, 0x00010888, 0x00100800, 0x00110800,
    0x00100808, 0x00110808, 0x00100880, 0x00110880, 0x00100888, 0x00110888,
    0x00100800, 0x00110800, 0x00100808, 0x00110808, 0x00100880, 0x00110880,
    0x00100888, 0x00110888,
  },
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000,
  },
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000,
  },
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000,
  },
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000,
  },
};

const uint32_t comp_maskr[8][128] =
{
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000,
  },
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000,
  },
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000,
  },
  {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000,
  },
  {
    0x00000000, 0x00000000, 0x00000080, 0x00000080, 0x00002000, 0x00002000,
    0x00002080, 0x00002080, 0x00000001, 0x00000001, 0x00000081, 0x00000081,
    0x00002001, 0x00002001, 0x00002081, 0x00002081, 0x00200000, 0x00200000,
    0x00200080, 0x00200080, 0x00202000, 0x00202000, 0x00202080, 0x00202080,
    0x00200001, 0x00200001, 0x00200081, 0x00200081, 0x00202001, 0x00202001,
    0x00202081, 0x00202081, 0x00020000, 0x00020000, 0x00020080, 0x00020080,
    0x00022000, 0x00022000, 0x00022080, 0x00022080, 0x00020001, 0x00020001,
    0x00020081, 0x00020081, 0x00022001, 0x00022001, 0x00022081, 0x00022081,
    0x00220000, 0x00220000, 0x00220080, 0x00220080, 0x00222000, 0x00222000,
    0x00222080, 0x00222080, 0x00220001, 0x00220001, 0x00220081, 0x00220081,
    0x00222001, 0x00222001, 0x00222081, 0x00222081, 0x00000002, 0x00000002,
    0x00000082, 0x00000082, 0x00002002, 0x00002002, 0x00002082, 0x00002082,
    0x00000003, 0x00000003, 0x00000083, 0x00000083, 0x00002003, 0x00002003,
    0x00002083, 0x00002083, 0x00200002, 0x00200002, 0x00200082, 0x00200082,
    0x00202002, 0x00202002, 0x00202082, 0x00202082, 0x00200003, 0x00200003,
    0x00200083, 0x00200083, 0x00202003, 0x00202003, 0x00202083, 0x00202083,
    0x00020002, 0x00020002, 0x00020082, 0x00020082, 0x00022002, 0x00022002,
    0x00022082, 0x00022082, 0x00020003, 0x00020003, 0x00020083, 0x00020083,
    0x00022003, 0x00022003, 0x00022083, 0x00022083, 0x00220002, 0x00220002,
    0x00220082, 0x00220082, 0x00222002, 0x00222002, 0x00222082, 0x00222082,
    0x00220003, 0x00220003, 0x00220083, 0x00220083, 0x00222003, 0x00222003,
    0x00222083, 0x00222083,
  },
  {
    0x00000000, 0x00000010, 0x00800000, 0x00800010, 0x00010000, 0x00010010,
    0x00810000, 0x00810010, 0x00000200, 0x00000210, 0x00800200, 0x00800210,
    0x00010200, 0x00010210, 0x00810200, 0x00810210, 0x00000000, 0x00000010,
    0x00800000, 0x00800010, 0x00010000, 0x00010010, 0x00810000, 0x00810010,
    0x00000200, 0x00000210, 0x00800200, 0x00800210, 0x00010200, 0x00010210,
    0x00810200, 0x00810210, 0x00100000, 0x00100010, 0x00900000, 0x00900010,
    0x00110000, 0x00110010, 0x00910000, 0x00910010, 0x00100200, 0x00100210,
    0x00900200, 0x00900210, 0x00110200, 0x00110210, 0x00910200, 0x00910210,
    0x00100000, 0x00100010, 0x00900000, 0x00900010, 0x00110000, 0x00110010,
    0x00910000, 0x00910010, 0x00100200, 0x00100210, 0x00900200, 0x00900210,
    0x00110200, 0x00110210, 0x00910200, 0x00910210, 0x00000004, 0x00000014,
    0x00800004, 0x00800014, 0x00010004, 0x00010014, 0x00810004, 0x00810014,
    0x00000204, 0x00000214, 0x00800204, 0x00800214, 0x00010204, 0x00010214,
    0x00810204, 0x00810214, 0x00000004, 0x00000014, 0x00800004, 0x00800014,
    0x00010004, 0x00010014, 0x00810004, 0x00810014, 0x00000204, 0x00000214,
    0x00800204, 0x00800214, 0x00010204, 0x00010214, 0x00810204, 0x00810214,
    0x00100004, 0x00100014, 0x00900004, 0x00900014, 0x00110004, 0x00110014,
    0x00910004, 0x00910014, 0x00100204, 0x00100214, 0x00900204, 0x00900214,
    0x00110204, 0x00110214, 0x00910204, 0x00910214, 0x00100004, 0x00100014,
    0x00900004, 0x00900014, 0x00110004, 0x00110014, 0x00910004, 0x00910014,
    0x00100204, 0x00100214, 0x00900204, 0x00900214, 0x00110204, 0x00110214,
    0x00910204, 0x00910214,
  },
  {
    0x00000000, 0x00000400, 0x00001000, 0x00001400, 0x00080000, 0x00080400,
    0x00081000, 0x00081400, 0x00000020, 0x00000420, 0x00001020, 0x00001420,
    0x00080020, 0x00080420, 0x00081020, 0x00081420, 0x00004000, 0x00004400,
    0x00005000, 0x00005400, 0x00084000, 0x00084400, 0x00085000, 0x00085400,
    0x00004020, 0x00004420, 0x00005020, 0x00005420, 0x00084020, 0x00084420,
    0x00085020, 0x00085420, 0x00000800, 0x00000c00, 0x00001800, 0x00001c00,
    0x00080800, 0x00080c00, 0x00081800, 0x00081c00, 0x00000820, 0x00000c20,
    0x00001820, 0x00001c20, 0x00080820, 0x00080c20, 0x00081820, 0x00081c20,
    0x00004800, 0x00004c00, 0x00005800, 0x00005c00, 0x00084800, 0x00084c00,
    0x00085800, 0x00085c00, 0x00004820, 0x00004c20, 0x00005820, 0x00005c20,
    0x00084820, 0x00084c20, 0x00085820, 0x00085c20, 0x00000000, 0x00000400,
    0x00001000, 0x00001400, 0x00080000, 0x00080400, 0x00081000, 0x00081400,
    0x00000020, 0x00000420, 0x00001020, 0x00001420, 0x00080020, 0x00080420,
    0x00081020, 0x00081420, 0x00004000, 0x00004400, 0x00005000, 0x00005400,
    0x00084000, 0x00084400, 0x00085000, 0x00085400, 0x00004020, 0x00004420,
    0x00005020, 0x00005420, 0x00084020, 0x00084420, 0x00085020, 0x00085420,
    0x00000800, 0x00000c00, 0x00001800, 0x00001c00, 0x00080800, 0x00080c00,
    0x00081800, 0x00081c00, 0x00000820, 0x00000c20, 0x00001820, 0x00001c20,
    0x00080820, 0x00080c20, 0x00081820, 0x00081c20, 0x00004800, 0x00004c00,
    0x00005800, 0x00005c00, 0x00084800, 0x00084c00, 0x00085800, 0x00085c00,
    0x00004820, 0x00004c20, 0x00005820, 0x00005c20, 0x00084820, 0x00084c20,
    0x00085820, 0x00085c20,
  },
  {
    0x00000000, 0x00000100, 0x00040000, 0x00040100, 0x00000000, 0x00000100,
    0x00040000, 0x00040100, 0x00000040, 0x00000140, 0x00040040, 0x00040140,
    0x00000040, 0x00000140, 0x00040040, 0x00040140, 0x00400000, 0x00400100,
    0x00440000, 0x00440100, 0x00400000, 0x00400100, 0x00440000, 0x00440100,
    0x00400040, 0x00400140, 0x00440040, 0x00440140, 0x00400040, 0x00400140,
    0x00440040, 0x00440140, 0x00008000, 0x00008100, 0x00048000, 0x00048100,
    0x00008000, 0x00008100, 0x00048000, 0x00048100, 0x00008040, 0x00008140,
    0x00048040, 0x00048140, 0x00008040, 0x00008140, 0x00048040, 0x00048140,
    0x00408000, 0x00408100, 0x00448000, 0x00448100, 0x00408000, 0x00408100,
    0x00448000, 0x00448100, 0x00408040, 0x00408140, 0x00448040, 0x00448140,
    0x00408040, 0x00408140, 0x00448040, 0x00448140, 0x00000008, 0x00000108,
    0x00040008, 0x00040108, 0x00000008, 0x00000108, 0x00040008, 0x00040108,
    0x00000048, 0x00000148, 0x00040048, 0x00040148, 0x00000048, 0x00000148,
    0x00040048, 0x00040148, 0x00400008, 0x00400108, 0x00440008, 0x00440108,
    0x00400008, 0x00400108, 0x00440008, 0x00440108, 0x00400048, 0x00400148,
    0x00440048, 0x00440148, 0x00400048, 0x00400148, 0x00440048, 0x00440148,
    0x00008008, 0x00008108, 0x00048008, 0x00048108, 0x00008008, 0x00008108,
    0x00048008, 0x00048108, 0x00008048, 0x00008148, 0x00048048, 0x00048148,
    0x00008048, 0x00008148, 0x00048048, 0x00048148, 0x00408008, 0x00408108,
    0x00448008, 0x00448108, 0x00408008, 0x00408108, 0x00448008, 0x00448108,
    0x00408048, 0x00408148, 0x00448048, 0x00448148, 0x00408048, 0x00408148,
    0x00448048, 0x00448148,
  },
};

const uint32_t psbox[4][256] =
{
  {
    0x00000000, 0x00004000, 0x40000000, 0x40004000, 0x00000010, 0x00004010,
    0x40000010, 0x40004010, 0x00080000, 0x00084000, 0x40080000, 0x40084000,
    0x00080010, 0x00084010, 0x40080010, 0x40084010, 0x00000002, 0x00004002,
    0x40000002, 0x40004002, 0x00000012, 0x00004012, 0x40000012, 0x40004012,
    0x00080002, 0x00084002, 0x40080002, 0x40084002, 0x00080012, 0x00084012,
    0x40080012, 0x40084012, 0x00000200, 0x00004200, 0x40000200, 0x40004200,
    0x00000210, 0x00004210, 0x40000210, 0x40004210, 0x00080200, 0x00084200,
    0x40080200, 0x40084200, 0x00080210, 0x00084210, 0x40080210, 0x40084210,
    0x00000202, 0x00004202, 0x40000202, 0x40004202, 0x00000212, 0x00004212,
    0x40000212, 0x40004212, 0x00080202, 0x00084202, 0x40080202, 0x40084202,
    0x00080212, 0x00084212, 0x40080212, 0x40084212, 0x00008000, 0x0000c000,
    0x40008000, 0x4000c000, 0x00008010, 0x0000c010, 0x40008010, 0x4000c010,
    0x00088000, 0x0008c000, 0x40088000, 0x4008c000, 0x00088010, 0x0008c010,
    0x40088010, 0x4008c010, 0x00008002, 0x0000c002, 0x40008002, 0x4000c002,
    0x00008012, 0x0000c012, 0x40008012, 0x4000c012, 0x00088002, 0x0008c002,
    0x40088002, 0x4008c002, 0x00088012, 0x0008c012, 0x40088012, 0x4008c012,
    0x00008200, 0x0000c200, 0x40008200, 0x4000c200, 0x00008210, 0x0000c210,
    0x40008210, 0x4000c210, 0x00088200, 0x0008c200, 0x40088200, 0x4008c200,
    0x00088210, 0x0008c210, 0x40088210, 0x4008c210, 0x00008202, 0x0000c202,
    0x40008202, 0x4000c202, 0x00008212, 0x0000c212, 0x40008212, 0x4000c212,
    0x00088202, 0x0008c202, 0x40088202, 0x4008c202, 0x00088212, 0x0008c212,
    0x40088212, 0x4008c212, 0x00800000, 0x00804000, 0x40800000, 0x40804000,
    0x00800010, 0x00804010, 0x40800010, 0x40804010, 0x00880000, 0x00884000,
    0x40880000, 0x40884000, 0x00880010, 0x00884010, 0x40880010, 0x40884010,
    0x00800002, 0x00804002, 0x40800002, 0x40804002, 0x00800012, 0x00804012,
    0x40800012, 0x40804012, 0x00880002, 0x00884002, 0x40880002, 0x40884002,
    0x00880012, 0x00884012, 0x40880012, 0x40884012, 0x00800200, 0x00804200,
    0x40800200, 0x40804200, 0x00800210, 0x00804210, 0x40800210, 0x40804210,
    0x00880200, 0x00884200, 0x40880200, 0x40884200, 0x00880210, 0x00884210,
    0x40880210, 0x40884210, 0x00800202, 0x00804202, 0x40800202, 0x40804202,
    0x00800212, 0x00804212, 0x40800212, 0x40804212, 0x00880202, 0x00884202,
    0x40880202, 0x40884202, 0x00880212, 0x00884212, 0x40880212, 0x40884212,
    0x00808000, 0x0080c000, 0x40808000, 0x4080c000, 0x00808010, 0x0080c010,
    0x40808010, 0x4080c010, 0x00888000, 0x0088c000, 0x40888000, 0x4088c000,
    0x00888010, 0x0088c010, 0x40888010, 0x4088c010, 0x00808002, 0x0080c002,
    0x40808002, 0x4080c002, 0x00808012, 0x0080c012, 0x40808012, 0x4080c012,
    0x00888002, 0x0088c002, 0x40888002, 0x4088c002, 0x00888012, 0x0088c012,
    0x40888012, 0x4088c012, 0x00808200, 0x0080c200, 0x40808200, 0x4080c200,
    0x00808210, 0x0080c210, 0x40808210, 0x4080c210, 0x00888200, 0x0088c200,
    0x40888200, 0x4088c200, 0x00888210, 0x0088c210, 0x40888210, 0x4088c210,
    0x00808202, 0x0080c202, 0x40808202, 0x4080c202, 0x00808212, 0x0080c212,
    0x40808212, 0x4080c212, 0x00888202, 0x0088c202, 0x40888202, 0x4088c202,
    0x00888212, 0x0088c212, 0x40888212, 0x4088c212,
  },
  {
    0x00000000, 0x80000000, 0x00400000, 0x80400000, 0x00001000, 0x80001000,
    0x00401000, 0x80401000, 0x00000040, 0x80000040, 0x00400040, 0x80400040,
    0x00001040, 0x80001040, 0x00401040, 0x80401040, 0x04000000, 0x84000000,
    0x04400000, 0x84400000, 0x04001000, 0x84001000, 0x04401000, 0x84401000,
    0x04000040, 0x84000040, 0x04400040, 0x84400040, 0x04001040, 0x84001040,
    0x04401040, 0x84401040, 0x00000004, 0x80000004, 0x00400004, 0x80400004,
    0x00001004, 0x80001004, 0x00401004, 0x80401004, 0x00000044, 0x80000044,
    0x00400044, 0x80400044, 0x00001044, 0x80001044, 0x00401044, 0x80401044,
    0x04000004, 0x84000004, 0x04400004, 0x84400004, 0x04001004, 0x84001004,
    0x04401004, 0x84401004, 0x04000044, 0x84000044, 0x04400044, 0x84400044,
    0x04001044, 0x84001044, 0x04401044, 0x84401044, 0x00010000, 0x80010000,
    0x00410000, 0x80410000, 0x00011000, 0x80011000, 0x00411000, 0x80411000,
    0x00010040, 0x80010040, 0x00410040, 0x80410040, 0x00011040, 0x80011040,
    0x00411040, 0x80411040, 0x04010000, 0x84010000, 0x04410000, 0x84410000,
    0x04011000, 0x84011000, 0x04411000, 0x84411000, 0x04010040, 0x84010040,
    0x04410040, 0x84410040, 0x04011040, 0x84011040, 0x04411040, 0x84411040,
    0x00010004, 0x80010004, 0x00410004, 0x80410004, 0x00011004, 0x80011004,
    0x00411004, 0x80411004, 0x00010044, 0x80010044, 0x00410044, 0x80410044,
    0x00011044, 0x80011044, 0x00411044, 0x80411044, 0x04010004, 0x84010004,
    0x04410004, 0x84410004, 0x04011004, 0x84011004, 0x04411004, 0x84411004,
    0x04010044, 0x84010044, 0x04410044, 0x84410044, 0x04011044, 0x84011044,
    0x04411044, 0x84411044, 0x00000100, 0x80000100, 0x00400100, 0x80400100,
    0x00001100, 0x80001100, 0x00401100, 0x80401100, 0x00000140, 0x80000140,
    0x00400140, 0x80400140, 0x00001140, 0x80001140, 0x00401140, 0x80401140,
    0x04000100, 0x84000100, 0x04400100, 0x84400100, 0x04001100, 0x84001100,
    0x04401100, 0x84401100, 0x04000140, 0x84000140, 0x04400140, 0x84400140,
    0x04001140, 0x84001140, 0x04401140, 0x84401140, 0x00000104, 0x80000104,
    0x00400104, 0x80400104, 0x00001104, 0x80001104, 0x00401104, 0x80401104,
    0x00000144, 0x80000144, 0x00400144, 0x80400144, 0x00001144, 0x80001144,
    0x00401144, 0x80401144, 0x04000104, 0x84000104, 0x04400104, 0x84400104,
    0x04001104, 0x84001104, 0x04401104, 0x84401104, 0x04000144, 0x84000144,
    0x04400144, 0x84400144, 0x04001144, 0x84001144, 0x04401144, 0x84401144,
    0x00010100, 0x80010100, 0x00410100, 0x80410100, 0x00011100, 0x80011100,
    0x00411100, 0x80411100, 0x00010140, 0x80010140, 0x00410140, 0x80410140,
    0x00011140, 0x80011140, 0x00411140, 0x80411140, 0x04010100, 0x84010100,
    0x04410100, 0x84410100, 0x04011100, 0x84011100, 0x04411100, 0x84411100,
    0x04010140, 0x84010140, 0x04410140, 0x84410140, 0x04011140, 0x84011140,
    0x04411140, 0x84411140, 0x00010104, 0x80010104, 0x00410104, 0x80410104,
    0x00011104, 0x80011104, 0x00411104, 0x80411104, 0x00010144, 0x80010144,
    0x00410144, 0x80410144, 0x00011144, 0x80011144, 0x00411144, 0x80411144,
    0x04010104, 0x84010104, 0x04410104, 0x84410104, 0x04011104, 0x84011104,
    0x04411104, 0x84411104, 0x04010144, 0x84010144, 0x04410144, 0x84410144,
    0x04011144, 0x84011144, 0x04411144, 0x84411144,
  },
  {
    0x00000000, 0x00002000, 0x00200000, 0x00202000, 0x00000008, 0x00002008,
    0x00200008, 0x00202008, 0x10000000, 0x10002000, 0x10200000, 0x10202000,
    0x10000008, 0x10002008, 0x10200008, 0x10202008, 0x20000000, 0x20002000,
    0x20200000, 0x20202000, 0x20000008, 0x20002008, 0x20200008, 0x20202008,
    0x30000000, 0x30002000, 0x30200000, 0x30202000, 0x30000008, 0x30002008,
    0x30200008, 0x30202008, 0x00000080, 0x00002080, 0x00200080, 0x00202080,
    0x00000088, 0x00002088, 0x00200088, 0x00202088, 0x10000080, 0x10002080,
    0x10200080, 0x10202080, 0x10000088, 0x10002088, 0x10200088, 0x10202088,
    0x20000080, 0x20002080, 0x20200080, 0x20202080, 0x20000088, 0x20002088,
    0x20200088, 0x20202088, 0x30000080, 0x30002080, 0x30200080, 0x30202080,
    0x30000088, 0x30002088, 0x30200088, 0x30202088, 0x00040000, 0x00042000,
    0x00240000, 0x00242000, 0x00040008, 0x00042008, 0x00240008, 0x00242008,
    0x10040000, 0x10042000, 0x10240000, 0x10242000, 0x10040008, 0x10042008,
    0x10240008, 0x10242008, 0x20040000, 0x20042000, 0x20240000, 0x20242000,
    0x20040008, 0x20042008, 0x20240008, 0x20242008, 0x30040000, 0x30042000,
    0x30240000, 0x30242000, 0x30040008, 0x30042008, 0x30240008, 0x30242008,
    0x00040080, 0x00042080, 0x00240080, 0x00242080, 0x00040088, 0x00042088,
    0x00240088, 0x00242088, 0x10040080, 0x10042080, 0x10240080, 0x10242080,
    0x10040088, 0x10042088, 0x10240088, 0x10242088, 0x20040080, 0x20042080,
    0x20240080, 0x20242080, 0x20040088, 0x20042088, 0x20240088, 0x20242088,
    0x30040080, 0x30042080, 0x30240080, 0x30242080, 0x30040088, 0x30042088,
    0x30240088, 0x30242088, 0x01000000, 0x01002000, 0x01200000, 0x01202000,
    0x01000008, 0x01002008, 0x01200008, 0x01202008, 0x11000000, 0x11002000,
    0x11200000, 0x11202000, 0x11000008, 0x11002008, 0x11200008, 0x11202008,
    0x21000000, 0x21002000, 0x21200000, 0x21202000, 0x21000008, 0x21002008,
    0x21200008, 0x21202008, 0x31000000, 0x31002000, 0x31200000, 0x31202000,
    0x31000008, 0x31002008, 0x31200008, 0x31202008, 0x01000080, 0x01002080,
    0x01200080, 0x01202080, 0x01000088, 0x01002088, 0x01200088, 0x01202088,
    0x11000080, 0x11002080, 0x11200080, 0x11202080, 0x11000088, 0x11002088,
    0x11200088, 0x11202088, 0x21000080, 0x21002080, 0x21200080, 0x21202080,
    0x21000088, 0x21002088, 0x21200088, 0x21202088, 0x31000080, 0x31002080,
    0x31200080, 0x31202080, 0x31000088, 0x31002088, 0x31200088, 0x31202088,
    0x01040000, 0x01042000, 0x01240000, 0x01242000, 0x01040008, 0x01042008,
    0x01240008, 0x01242008, 0x11040000, 0x11042000, 0x11240000, 0x11242000,
    0x11040008, 0x11042008, 0x11240008, 0x11242008, 0x21040000, 0x21042000,
    0x21240000, 0x21242000, 0x21040008, 0x21042008, 0x21240008, 0x21242008,
    0x31040000, 0x31042000, 0x31240000, 0x31242000, 0x31040008, 0x31042008,
    0x31240008, 0x31242008, 0x01040080, 0x01042080, 0x01240080, 0x01242080,
    0x01040088, 0x01042088, 0x01240088, 0x01242088, 0x11040080, 0x11042080,
    0x11240080, 0x11242080, 0x11040088, 0x11042088, 0x11240088, 0x11242088,
    0x21040080, 0x21042080, 0x21240080, 0x21242080, 0x21040088, 0x21042088,
    0x21240088, 0x21242088, 0x31040080, 0x31042080, 0x31240080, 0x31242080,
    0x31040088, 0x31042088, 0x31240088, 0x31242088,
  },
  {
    0x00000000, 0x00000800, 0x00020000, 0x00020800, 0x00000020, 0x00000820,
    0x00020020, 0x00020820, 0x08000000, 0x08000800, 0x08020000, 0x08020800,
    0x08000020, 0x08000820, 0x08020020, 0x08020820, 0x02000000, 0x02000800,
    0x02020000, 0x02020800, 0x02000020, 0x02000820, 0x02020020, 0x02020820,
    0x0a000000, 0x0a000800, 0x0a020000, 0x0a020800, 0x0a000020, 0x0a000820,
    0x0a020020, 0x0a020820, 0x00000400, 0x00000c00, 0x00020400, 0x00020c00,
    0x00000420, 0x00000c20, 0x00020420, 0x00020c20, 0x08000400, 0x08000c00,
    0x08020400, 0x08020c00, 0x08000420, 0x08000c20, 0x08020420, 0x08020c20,
    0x02000400, 0x02000c00, 0x02020400, 0x02020c00, 0x02000420, 0x02000c20,
    0x02020420, 0x02020c20, 0x0a000400, 0x0a000c00, 0x0a020400, 0x0a020c00,
    0x0a000420, 0x0a000c20, 0x0a020420, 0x0a020c20, 0x00100000, 0x00100800,
    0x00120000, 0x00120800, 0x00100020, 0x00100820, 0x00120020, 0x00120820,
    0x08100000, 0x08100800, 0x08120000, 0x08120800, 0x08100020, 0x08100820,
    0x08120020, 0x08120820, 0x02100000, 0x02100800, 0x02120000, 0x02120800,
    0x02100020, 0x02100820, 0x02120020, 0x02120820, 0x0a100000, 0x0a100800,
    0x0a120000, 0x0a120800, 0x0a100020, 0x0a100820, 0x0a120020, 0x0a120820,
    0x00100400, 0x00100c00, 0x00120400, 0x00120c00, 0x00100420, 0x00100c20,
    0x00120420, 0x00120c20, 0x08100400, 0x08100c00, 0x08120400, 0x08120c00,
    0x08100420, 0x08100c20, 0x08120420, 0x08120c20, 0x02100400, 0x02100c00,
    0x02120400, 0x02120c00, 0x02100420, 0x02100c20, 0x02120420, 0x02120c20,
    0x0a100400, 0x0a100c00, 0x0a120400, 0x0a120c00, 0x0a100420, 0x0a100c20,
    0x0a120420, 0x0a120c20, 0x00000001, 0x00000801, 0x00020001, 0x00020801,
    0x00000021, 0x00000821, 0x00020021, 0x00020821, 0x08000001, 0x08000801,
    0x08020001, 0x08020801, 0x08000021, 0x08000821, 0x08020021, 0x08020821,
    0x02000001, 0x02000801, 0x02020001, 0x02020801, 0x02000021, 0x02000821,
    0x02020021, 0x02020821, 0x0a000001, 0x0a000801, 0x0a020001, 0x0a020801,
    0x0a000021, 0x0a000821, 0x0a020021, 0x0a020821, 0x00000401, 0x00000c01,
    0x00020401, 0x00020c01, 0x00000421, 0x00000c21, 0x00020421, 0x00020c21,
    0x08000401, 0x08000c01, 0x08020401, 0x08020c01, 0x08000421, 0x08000c21,
    0x08020421, 0x08020c21, 0x02000401, 0x02000c01, 0x02020401, 0x02020c01,
    0x02000421, 0x02000c21, 0x02020421, 0x02020c21, 0x0a000401, 0x0a000c01,
    0x0a020401, 0x0a020c01, 0x0a000421, 0x0a000c21, 0x0a020421, 0x0a020c21,
    0x00100001, 0x00100801, 0x00120001, 0x00120801, 0x00100021, 0x00100821,
    0x00120021, 0x00120821, 0x08100001, 0x08100801, 0x08120001, 0x08120801,
    0x08100021, 0x08100821, 0x08120021, 0x08120821, 0x02100001, 0x02100801,
    0x02120001, 0x02120801, 0x02100021, 0x02100821, 0x02120021, 0x02120821,
    0x0a100001, 0x0a100801, 0x0a120001, 0x0a120801, 0x0a100021, 0x0a100821,
    0x0a120021, 0x0a120821, 0x00100401, 0x00100c01, 0x00120401, 0x00120c01,
    0x00100421, 0x00100c21, 0x00120421, 0x00120c21, 0x08100401, 0x08100c01,
    0x08120401, 0x08120c01, 0x08100421, 0x08100c21, 0x08120421, 0x08120c21,
    0x02100401, 0x02100c01, 0x02120401, 0x02120c01, 0x02100421, 0x02100c21,
    0x02120421, 0x02120c21, 0x0a100401, 0x0a100c01, 0x0a120401, 0x0a120c01,
    0x0a100421, 0x0a100c21, 0x0a120421, 0x0a120c21,
  },
};

#endif
