# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl Interface-TNC-IMC.t'

#########################

use Test;
BEGIN { plan tests => 20 };
use Interface::TNC::IMC;
ok(1); # If we made it this far, we're ok.

my $suppress_log_messages = 0;
my $log_message_was_called = 0;
my $tnccSendMessage_was_called = 0;

# This will be called when the IMC wants to send a message
sub Interface::IMC::TNC_TNCC_SendMessage
{
    $tnccSendMessage_was_called++;

    return Interface::TNC::IMC::TNC_RESULT_SUCCESS;
}

sub Interface::IMC::libtnc_logMessage
{
    $log_message_was_called++;
    print STDERR "Interface::IMC::libtnc_logMessage @_\n"
	unless $suppress_log_messages;
}

#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

my $imc;
my @imcmodules = ('../../src/sample/.libs/libsample_imc.so');
my $imcmodules = \@imcmodules;
my $myImcConnID = 99;

$suppress_log_messages = 1;
ok(!Interface::TNC::IMC::new('ignore.this.dlopen.error.message'));
$suppress_log_messages = 0;
ok($imc = Interface::TNC::IMC::new('../../src/sample/.libs/libsample_imc.so'));
ok(Interface::TNC::IMC::unload() == Interface::TNC::IMC::TNC_RESULT_SUCCESS);
ok(Interface::TNC::IMC::load_modules($imcmodules) == Interface::TNC::IMC::TNC_RESULT_SUCCESS);
ok(Interface::TNC::IMC::unload() == Interface::TNC::IMC::TNC_RESULT_SUCCESS);

# Test loading of IMC
# will fail. We dont usually use this function.
# Prevent messages appearing on stderr, but count them
$suppress_log_messages = 1;
ok(Interface::TNC::IMC::load_config('ignore.this.TNC.config.error.message') == -1);
ok($log_message_was_called == 1);
$suppress_log_messages = 0;

ok(Interface::TNC::IMC::load_config('../../src/libtnc/test_tnc_config') == 1);

# Probe the IMC:
ok(Interface::TNC::IMC::NotifyConnectionChange($myImcConnID, Interface::TNC::IMC::TNC_CONNECTION_STATE_CREATE) == Interface::TNC::IMC::TNC_RESULT_SUCCESS);
ok(Interface::TNC::IMC::NotifyConnectionChange($myImcConnID, Interface::TNC::IMC::TNC_CONNECTION_STATE_HANDSHAKE) == Interface::TNC::IMC::TNC_RESULT_SUCCESS);

# Send some messages into the IMC
ok(Interface::TNC::IMC::BeginHandshake($myImcConnID) == Interface::TNC::IMC::TNC_RESULT_SUCCESS);

# Make sure TNC_TNCC_SendMessage was called from inside TNC_IMC_BeginHandshake
ok($tnccSendMessage_was_called == 1);

# Send a message into IMC
ok(Interface::TNC::IMC::ReceiveMessage($myImcConnID, 'hello mister IMC', (9999 << 8) | 2) == Interface::TNC::IMC::TNC_RESULT_SUCCESS);
# Make sure IMC responded by sending a message out
ok($tnccSendMessage_was_called == 2);

ok(Interface::TNC::IMC::BatchEnding($myImcConnID) == Interface::TNC::IMC::TNC_RESULT_SUCCESS);

ok(Interface::TNC::IMC::NotifyConnectionChange($myImcConnID, Interface::TNC::IMC::TNC_CONNECTION_STATE_ACCESS_ALLOWED) == Interface::TNC::IMC::TNC_RESULT_SUCCESS);
ok(Interface::TNC::IMC::NotifyConnectionChange($myImcConnID, Interface::TNC::IMC::TNC_CONNECTION_STATE_DELETE) == Interface::TNC::IMC::TNC_RESULT_SUCCESS);

ok(Interface::TNC::IMC::Terminate() == Interface::TNC::IMC::TNC_RESULT_SUCCESS);
ok(Interface::TNC::IMC::unload() == Interface::TNC::IMC::TNC_RESULT_SUCCESS);
