#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"

#include <libtncimc.h>
#include "const-c.inc"

// Here we define the functions that can be called from within libtnc
// We create a stack, then call a fixed nmae perl function. The return
// value of the per function will be returned.
// Calls like:
// Interface::IMC::TNC_TNCC_SendMessage(imcID, connectionID, message, messageType)
// The calling program is expected to implement 
// Interface::IMC::TNC_TNCC_SendMessage
TNC_Result TNC_TNCC_SendMessage(
/*in*/ TNC_IMCID imcID,
/*in*/ TNC_ConnectionID connectionID,
/*in*/ TNC_BufferReference message,
/*in*/ TNC_UInt32 messageLength,
/*in*/ TNC_MessageType messageType)
{
    dSP;
    int count;
    int ret;

    ENTER;
    SAVETMPS;
    PUSHMARK(SP);
    XPUSHs(sv_2mortal(newSViv(imcID)));
    XPUSHs(sv_2mortal(newSViv(connectionID)));
    XPUSHs(sv_2mortal(newSVpv((const char*)message, (STRLEN)messageLength)));
    XPUSHs(sv_2mortal(newSViv(messageType)));
    PUTBACK;
    count = call_pv("Interface::IMC::TNC_TNCC_SendMessage", G_SCALAR);
    SPAGAIN ;
    if (count != 1)
       croak("Interface::IMC::TNC_TNCC_SendMessage did not return a status\n");
    ret = POPi;
    FREETMPS;
    LEAVE ;
    return ret;
}

// Here we define the functions that can be called from within libtnc
// We create a stack, then call a fixed nmae perl function. The return
// value of the per function will be returned.
// Calls like:
// Interface::IMC::TNC_TNCC_RequestHandshakeRetry(imcID, connectionID, reason)
// The calling program is expected to implement 
// Interface::IMC::TNC_TNCC_RequestHandshakeRetry
TNC_Result TNC_TNCC_RequestHandshakeRetry(
/*in*/ TNC_IMCID imcID,
/*in*/ TNC_ConnectionID connectionID,
/*in*/ TNC_RetryReason reason)
{
    dSP;
    int count;
    int ret;

    ENTER;
    SAVETMPS;
    PUSHMARK(SP);
    XPUSHs(sv_2mortal(newSViv(imcID)));
    XPUSHs(sv_2mortal(newSViv(connectionID)));
    XPUSHs(sv_2mortal(newSViv(reason)));
    PUTBACK;
    count = call_pv("Interface::IMC::TNC_TNCC_RequestHandshakeRetry", G_SCALAR);
    SPAGAIN ;
    if (count != 1)
       croak("Interface::IMC::TNC_TNCC_RequestHandshakeRetry did not return a status\n");
    ret = POPi;
    FREETMPS;
    LEAVE ;
    return ret;
}

TNC_Result libtnc_logMessage(
    /*in*/ TNC_UInt32 severity,
    /*in*/ const char* format, ...)
{
    dSP;
    char buf[10000];
    va_list arg;
    va_start(arg, format);

    vsnprintf(buf, 10000, format, arg);

    ENTER;
    SAVETMPS;
    PUSHMARK(SP);
    XPUSHs(sv_2mortal(newSVpv((const char*)buf, strlen(buf))));
    PUTBACK;
    call_pv("Interface::IMC::libtnc_logMessage", G_SCALAR);
    FREETMPS;
    LEAVE ;
    return TNC_RESULT_SUCCESS;
}

MODULE = Interface::TNC::IMC	PACKAGE = Interface::TNC::IMC	PREFIX = libtnc_imc_
PROTOTYPES: ENABLE
INCLUDE: const-xs.inc

TNC_Result
libtnc_imc_BatchEnding(connectionID)
	TNC_ConnectionID	connectionID

TNC_Result
libtnc_imc_BeginHandshake(connectionID)
	TNC_ConnectionID	connectionID

TNC_Result
libtnc_imc_NotifyConnectionChange(connectionID, newState)
	TNC_ConnectionID	connectionID
	TNC_ConnectionState	newState

TNC_Result
libtnc_imc_ReceiveMessage(connectionID, message, messageType)
	TNC_ConnectionID  connectionID
	TNC_MessageType	  messageType
	PREINIT:
	STRLEN messageLength;
	INPUT:
	char* message =  SvPV(ST(1), messageLength);
	CODE:
	 RETVAL = libtnc_imc_ReceiveMessage(connectionID, 
	 (TNC_BufferReference)message, 
	 (TNC_UInt32)messageLength, messageType);
        OUTPUT:
         RETVAL

TNC_Result
libtnc_imc_Terminate()

TNC_Result
libtnc_imc_destroy(self)
	libtnc_imc *	self

int
libtnc_imc_load_config(filename)
	char *	filename

TNC_Result
libtnc_imc_load_modules(filenames)
	SV* filenames
	INIT:
	 I32 numfiles = av_len((AV *)SvRV(filenames)) + 1;
	 char** a;
	CODE:
	 New(0, a, numfiles, char*);
         if (a)
	 {
	    int i;
	    for (i = 0; i < numfiles; i++)
	        a[i] = (char*)SvPV(*av_fetch((AV *)SvRV(filenames), i, 0), PL_na);
	    RETVAL = libtnc_imc_load_modules((const char**)a, numfiles);
	    Safefree(a);
	 }
         else
            RETVAL = TNC_RESULT_FATAL;
        OUTPUT:
         RETVAL

int
libtnc_imc_load_std_config()

libtnc_imc *
libtnc_imc_new(filename)
	char *	filename

TNC_Result
libtnc_imc_unload()

