# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl Interface-TNC-IMV.t'

#########################

use Test;
BEGIN { plan tests => 21 };
use Interface::TNC::IMV;
ok(1); # If we made it this far, we're ok.

my $suppress_log_messages = 0;
my $log_message_was_called = 0;
my $tncsSendMessage_was_called = 0;
my $tncsProvideRecommendation_was_called = 0;

# This will be called when the IMV wants to send a message
sub Interface::IMV::TNC_TNCS_SendMessage
{
    $tncsSendMessage_was_called++;

    return Interface::TNC::IMV::TNC_RESULT_SUCCESS;
}

# This will be called when the IMV wants to send a message
sub Interface::IMV::TNC_TNCS_ProvideRecommendation
{
    $tncsProvideRecommendation_was_called++;

    return Interface::TNC::IMV::TNC_RESULT_SUCCESS;
}

sub Interface::IMV::libtnc_logMessage
{
    $log_message_was_called++;
    print STDERR "Interface::IMV::libtnc_logMessage @_\n"
	unless $suppress_log_messages;
}

#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

my $imv;
my @imvmodules = ('../../src/sample/.libs/libsample_imv.so');
my $imvmodules = \@imvmodules;
my $myImvConnID = 199;

$suppress_log_messages = 1;
ok(!Interface::TNC::IMV::new('ignore.this.dlopen.error.message'));
$suppress_log_messages = 0;

ok($imv = Interface::TNC::IMV::new('../../src/sample/.libs/libsample_imv.so'));
ok(Interface::TNC::IMV::unload() == Interface::TNC::IMV::TNC_RESULT_SUCCESS);
ok(Interface::TNC::IMV::load_modules($imvmodules) == Interface::TNC::IMV::TNC_RESULT_SUCCESS);
ok(Interface::TNC::IMV::unload() == Interface::TNC::IMV::TNC_RESULT_SUCCESS);

# Test loading of IMV
# will fail. We dont usually use this function.
# Prevent messages appearing on stderr, but count them
$suppress_log_messages = 1;
ok(Interface::TNC::IMV::load_config('ignore.this.TNC.config.error.message') == -1);
ok($log_message_was_called == 1);
$suppress_log_messages = 0;

ok(Interface::TNC::IMV::load_config('../../src/libtnc/test_tnc_config') == 1);

# Probe the IMV:
ok(Interface::TNC::IMV::NotifyConnectionChange($myImvConnID, Interface::TNC::IMV::TNC_CONNECTION_STATE_CREATE) == Interface::TNC::IMV::TNC_RESULT_SUCCESS);
ok(Interface::TNC::IMV::NotifyConnectionChange($myImvConnID, Interface::TNC::IMV::TNC_CONNECTION_STATE_HANDSHAKE) == Interface::TNC::IMV::TNC_RESULT_SUCCESS);

# Send some messages into the IMV
# This willl provoke a call to SendMessage
ok(Interface::TNC::IMV::ReceiveMessage($myImvConnID, 'hello mister IMV', ((9999 << 8) | 1)) == Interface::TNC::IMV::TNC_RESULT_SUCCESS);
ok($tncsSendMessage_was_called == 1);

# This will provoke a call to ProvideRecommendation
ok(Interface::TNC::IMV::ReceiveMessage($myImvConnID, 'hello mister IMV', ((9999 << 8) | 3)) == Interface::TNC::IMV::TNC_RESULT_SUCCESS);
ok($tncsProvideRecommendation_was_called == 1);

# So will this
ok(Interface::TNC::IMV::SolicitRecommendation($myImvConnID) == Interface::TNC::IMV::TNC_RESULT_SUCCESS);
ok($tncsProvideRecommendation_was_called == 2);

ok(Interface::TNC::IMV::NotifyConnectionChange($myImvConnID, Interface::TNC::IMV::TNC_CONNECTION_STATE_ACCESS_ALLOWED) == Interface::TNC::IMV::TNC_RESULT_SUCCESS);
ok(Interface::TNC::IMV::NotifyConnectionChange($myImvConnID, Interface::TNC::IMV::TNC_CONNECTION_STATE_DELETE) == Interface::TNC::IMV::TNC_RESULT_SUCCESS);

ok(Interface::TNC::IMV::Terminate() == Interface::TNC::IMV::TNC_RESULT_SUCCESS);
ok(Interface::TNC::IMV::unload() == Interface::TNC::IMV::TNC_RESULT_SUCCESS);
