%bcond_with  test
%global py3_build_dir %{_builddir}/%{name}-%{version}-%{release}-python3

Name:           libstoragemgmt
Version:        1.6.1
Release:        1%{?dist}
Summary:        Storage array management library
Group:          System Environment/Libraries
License:        LGPL-2.1+
URL:            https://github.com/libstorage/libstoragemgmt
Source0:        https://github.com/libstorage/libstoragemgmt/releases/download/%{version}/%{name}-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Requires:       python3-%{name}
BuildRequires:  autoconf automake libtool yajl-devel libxml2-devel check-devel
BuildRequires:  perl
BuildRequires:  openssl-devel
BuildRequires:  glib2-devel
BuildRequires:  systemd
BuildRequires:  bash-completion
BuildRequires:  libconfig-devel
BuildRequires:  systemd-devel
BuildRequires:  python-six
BuildRequires:  python-devel
BuildRequires:  procps
BuildRequires:  sqlite-devel
BuildRequires:  python3-six
BuildRequires:  python3-devel

Requires: initscripts
Requires(post): systemd
Requires(preun): systemd
Requires(postun): systemd

BuildRequires:  chrpath
BuildRequires:  valgrind
BuildRequires:  python-pyudev

%description
The libStorageMgmt library will provide a vendor agnostic open source storage
application programming interface (API) that will allow management of storage
arrays.  The library includes a command line interface for interactive use and
scripting (command lsmcli).  The library also has a daemon that is used for
executing plug-ins in a separate process (lsmd).

%package        devel
Summary:        Development files for %{name}
Group:          Development/Libraries
Requires:       %{name}%{?_isa} = %{version}-%{release}

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.

%package        -n python2-%{name}
Summary:        Python2 client libraries for %{name}
Group:          System Environment/Libraries
Requires:       %{name} = %{version}-%{release}
Requires:       python2-%{name}-clibs
BuildArch:      noarch
%{?python_provide:%python_provide python2-%{name}}
# Remove before F30
Provides: %{name}-python = %{version}-%{release}
Obsoletes: %{name}-python < %{version}-%{release}

%description    -n python2-%{name}
This package contains python2 client libraries.

%package        -n python2-%{name}-clibs
Summary:        Python2 C extension module for %{name}
Group:          System Environment/Libraries
Requires:       %{name} = %{version}-%{release}
%{?python_provide:%python_provide python2-%{name}-clibs}
# Remove before F30
Provides: %{name}-python-clibs = %{version}-%{release}
Provides: %{name}-python-clibs%{?_isa} = %{version}-%{release}
Obsoletes: %{name}-python-clibs < %{version}-%{release}

%description    -n python2-%{name}-clibs
This package contains python2 client C extension libraries.


%package        -n python3-%{name}
Summary:        Python 3 client libraries and plug-in support for %{name}
Group:          System Environment/Libraries
Requires:       %{name} = %{version}-%{release}
BuildArch:      noarch
Requires:       python3-%{name}-clibs
%{?python_provide:%python_provide python3-%{name}}

%description    -n python3-%{name}
This package contains python 3 client libraries as well as python framework
support and open source plug-ins written in python 3.

%package        -n python3-%{name}-clibs
Summary:        Python 3 C extension module for %{name}
Group:          System Environment/Libraries
Requires:       %{name} = %{version}-%{release}
%{?python_provide:%python_provide python3-%{name}-clibs}

%description    -n python3-%{name}-clibs
This package contains python 3 client C extension libraries.

%package        smis-plugin
Summary:        Files for SMI-S generic array support for %{name}
Group:          System Environment/Libraries
BuildRequires:  pywbem
BuildRequires:  python3-pywbem
Requires:       python3-pywbem
BuildArch:      noarch
Provides:       %{name}-ibm-v7k-plugin = 2:%{version}-%{release}
Obsoletes:      %{name}-ibm-v7k-plugin <= 2:0.1.0-3
Requires:       python3-%{name} = %{version}
Requires(post): python3-%{name} = %{version}
Requires(postun): python3-%{name} = %{version}


%description    smis-plugin
The %{name}-smis-plugin package contains plug-in for generic SMI-S array
support.


%package        netapp-plugin
Summary:        Files for NetApp array support for %{name}
Group:          System Environment/Libraries
Requires:       python3-%{name} = %{version}
Requires(post): python3-%{name} = %{version}
Requires(postun): python3-%{name} = %{version}
Requires:       python3-%{name} = %{version}-%{release}
BuildArch:      noarch

%description    netapp-plugin
The %{name}-netapp-plugin package contains plug-in for NetApp array
support.


%package        targetd-plugin
Summary:        Files for targetd array support for %{name}
Group:          System Environment/Libraries
Requires:       python3-%{name} = %{version}
Requires(post): python3-%{name} = %{version}
Requires(postun): python3-%{name} = %{version}
BuildArch:      noarch

%description    targetd-plugin
The %{name}-targetd-plugin package contains plug-in for targetd array
support.


%package        nstor-plugin
Summary:        Files for NexentaStor array support for %{name}
Group:          System Environment/Libraries
Requires:       python3-%{name} = %{version}
Requires(post): python3-%{name} = %{version}
Requires(postun): python3-%{name} = %{version}
BuildArch:      noarch

%description    nstor-plugin
The %{name}-nstor-plugin package contains plug-in for NexentaStor array
support.

%package        udev
Summary:        Udev files for %{name}
Group:          System Environment/Base

%description    udev
The %{name}-udev package contains udev rules and helper utilities for
uevents generated by the kernel.

%package        megaraid-plugin
Summary:        Files for LSI MegaRAID support for %{name}
Group:          System Environment/Libraries
Requires:       python3-%{name} = %{version}
Requires(post): python3-%{name} = %{version}
Requires(postun): python3-%{name} = %{version}
BuildArch:      noarch

%description    megaraid-plugin
The %{name}-megaraid-plugin package contains the plugin for LSI
MegaRAID storage management via storcli.

%package        hpsa-plugin
Summary:        Files for HPE SmartArray support for %{name}
Group:          System Environment/Libraries
Requires:       python3-%{name} = %{version}
Requires:       python3-pyudev
BuildRequires:  python3-pyudev
Requires(post): python3-%{name} = %{version}
Requires(postun): python3-%{name} = %{version}
BuildArch:      noarch

%description    hpsa-plugin
The %{name}-hpsa-plugin package contains the plugin for HP
SmartArray storage management.

%package        arcconf-plugin
Summary:        Files for Microsemi Adaptec and Smart Family support for %{name}
Group:          System Environment/Libraries
Requires:       python3-%{name} = %{version}
Requires(post): python3-%{name} = %{version}
Requires(postun): python3-%{name} = %{version}
BuildArch:      noarch

%description    arcconf-plugin
The %{name}-arcconf-plugin package contains the plugin for Microsemi
Adaptec RAID and Smart Family Controller storage management.

%package        nfs-plugin
Summary:        Files for NFS local filesystem support for %{name}
Group:          System Environment/Libraries
Requires:       python3-%{name} = %{version}
Requires(post): python3-%{name} = %{version}
Requires(postun): python3-%{name} = %{version}

%description    nfs-plugin
The nfs-plugin package contains plug-in for local NFS exports support.

%package        local-plugin
Summary:        Files for local pseudo plugin of %{name}
Group:          System Environment/Libraries
Requires:       python3-%{name} = %{version}
Requires(post): python3-%{name} = %{version}
Requires(postun): python3-%{name} = %{version}
BuildArch:      noarch

%description    local-plugin
The nfs-plugin package contains plug-in for local NFS exports support.
LibstorageMgmt local plugin allows user to manage locally storage system
without caring which real plugin(s) should be used.

%prep
%setup -q

%build
# Copy the whole directory to Python3 build
rm -fr %{py3_build_dir}
cp -a . %{py3_build_dir}
%configure --disable-static

pushd %{py3_build_dir}
%configure --with-python3 --disable-static
popd

V=1 make %{?_smp_mflags}
pushd %{py3_build_dir}
V=1 make %{?_smp_mflags}
popd

%install
rm -rf %{buildroot}
make install DESTDIR=%{buildroot}

# If python3 enabled, all plugins and CLI tools will be use python3 as
# 'Fedora Packaging Guidelines for Python' suggested.
#   https://fedoraproject.org/wiki/Packaging:Python#Executables_in_.2Fusr.2Fbin
# Quote:
#   If the executables provide the same functionality independent of whether
#   they are run on top of Python 2 or Python 3, then only the Python 3 version
#   of the executable should be packaged.

rm -rf %{buildroot}/%{python_sitelib}/lsm/plugin
rm -rf %{buildroot}/%{_bindir}/lsmcli
pushd %{py3_build_dir}
make install DESTDIR=%{buildroot}
popd
find %{buildroot} -name '*.la' -exec rm -f {} ';'

install -d -m755 %{buildroot}/%{_unitdir}
install -m644 packaging/daemon/%{name}.service \
    %{buildroot}/%{_unitdir}/%{name}.service

#tempfiles.d configuration for /run
mkdir -p %{buildroot}/%{_tmpfilesdir}
install -m 0644 packaging/daemon/lsm-tmpfiles.conf \
    %{buildroot}/%{_tmpfilesdir}/%{name}.conf

#Files for udev handling
mkdir -p %{buildroot}/%{_udevrulesdir}
install -m 644 tools/udev/90-scsi-ua.rules \
    %{buildroot}/%{_udevrulesdir}/90-scsi-ua.rules
install -m 755 tools/udev/scan-scsi-target \
    %{buildroot}/%{_udevrulesdir}/../scan-scsi-target

%clean
rm -rf %{buildroot}

%if 0%{with test}
%check
pushd %{py3_build_dir}
if ! make check
then
  cat test-suite.log || true
  exit 1
fi
popd
%endif

%pre
getent group libstoragemgmt >/dev/null || groupadd -r libstoragemgmt
getent passwd libstoragemgmt >/dev/null || \
    useradd -r -g libstoragemgmt -d /var/run/lsm -s /sbin/nologin \
    -c "daemon account for libstoragemgmt" libstoragemgmt

%post
/sbin/ldconfig
# Create tmp socket folders.
%tmpfiles_create %{_tmpfilesdir}/%{name}.conf
%systemd_post %{name}.service

%preun
%systemd_preun %{name}.service

%postun
/sbin/ldconfig
%systemd_postun %{name}.service

# Need to restart lsmd if plugin is new installed or removed.
%post smis-plugin
if [ $1 -eq 1 ]; then
    # New install.
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi

%postun smis-plugin
if [ $1 -eq 0 ]; then
    # Remove
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi

# Need to restart lsmd if plugin is new installed or removed.
%post netapp-plugin
if [ $1 -eq 1 ]; then
    # New install.
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi

%postun netapp-plugin
if [ $1 -eq 0 ]; then
    # Remove
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi

# Need to restart lsmd if plugin is new installed or removed.
%post targetd-plugin
if [ $1 -eq 1 ]; then
    # New install.
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi

%postun targetd-plugin
if [ $1 -eq 0 ]; then
    # Remove
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi

# Need to restart lsmd if plugin is new installed or removed.
%post nstor-plugin
if [ $1 -eq 1 ]; then
    # New install.
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi

%postun nstor-plugin
if [ $1 -eq 0 ]; then
    # Remove
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi

# Need to restart lsmd if plugin is new installed or removed.
%post megaraid-plugin
if [ $1 -eq 1 ]; then
    # New install.
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi
%postun megaraid-plugin
if [ $1 -eq 0 ]; then
    # Remove
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi

# Need to restart lsmd if plugin is new installed or removed.
%post hpsa-plugin
if [ $1 -eq 1 ]; then
    # New install.
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi
%postun hpsa-plugin
if [ $1 -eq 0 ]; then
    # Remove
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi

# Need to restart lsmd if plugin is new installed or removed.
%post nfs-plugin
if [ $1 -eq 1 ]; then
    # New install.
    /usr/bin/systemctl try-restart libstoragemgmt.service \
        >/dev/null 2>&1 || :
fi

%postun nfs-plugin
if [ $1 -eq 0 ]; then
    # Remove
    /usr/bin/systemctl try-restart libstoragemgmt.service \
        >/dev/null 2>&1 || :
fi

# Need to restart lsmd if plugin is new installed or removed.
%post arcconf-plugin
if [ $1 -eq 1 ]; then
    # New install.
    /usr/bin/systemctl try-restart libstoragemgmt.service \
        >/dev/null 2>&1 || :
fi

%postun arcconf-plugin
if [ $1 -eq 0 ]; then
    # Remove
    /usr/bin/systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi

%files
%defattr(-,root,root,-)
%doc README COPYING.LIB NEWS
%{_mandir}/man1/lsmcli.1*
%{_mandir}/man1/lsmd.1*
%{_mandir}/man5/lsmd.conf.5*
%{_libdir}/*.so.*
%{_bindir}/lsmcli
%{_datadir}/bash-completion/completions/lsmcli
%{_bindir}/lsmd
%{_bindir}/simc_lsmplugin
%dir %{_sysconfdir}/lsm
%dir %{_sysconfdir}/lsm/pluginconf.d
%config(noreplace) %{_sysconfdir}/lsm/lsmd.conf
%{_mandir}/man1/simc_lsmplugin.1*

%{_unitdir}/%{name}.service

%ghost %dir %attr(0755, -, -) /run/lsm/
%ghost %dir %attr(0755, -, -) /run/lsm/ipc

%attr(0644, root, root) %{_tmpfilesdir}/%{name}.conf

%files devel
%defattr(-,root,root,-)
%{_includedir}/*
%{_libdir}/*.so
%{_libdir}/pkgconfig/%{name}.pc
%{_mandir}/man3/lsm_*
%{_mandir}/man3/libstoragemgmt*

%files -n python2-%{name}
%defattr(-,root,root,-)
#Python library files
%dir %{python_sitelib}/lsm
%{python_sitelib}/lsm/__init__.*
%dir %{python_sitelib}/lsm/external
%{python_sitelib}/lsm/external/*
%{python_sitelib}/lsm/_client.*
%{python_sitelib}/lsm/_common.*
%{python_sitelib}/lsm/_local_disk.*
%{python_sitelib}/lsm/_data.*
%{python_sitelib}/lsm/_iplugin.*
%{python_sitelib}/lsm/_pluginrunner.*
%{python_sitelib}/lsm/_transport.*
%{python_sitelib}/lsm/version.*
%dir %{python_sitelib}/lsm/lsmcli
%{python_sitelib}/lsm/lsmcli/__init__.*
%{python_sitelib}/lsm/lsmcli/data_display.*
%{python_sitelib}/lsm/lsmcli/cmdline.*

# Compiled C files for python library
%files -n python2-%{name}-clibs
%{python_sitelib}/lsm/_clib.*

%files -n python3-%{name}
%dir %{python3_sitelib}/lsm
%{python3_sitelib}/lsm/__init__.*
%dir %{python3_sitelib}/lsm/external
%{python3_sitelib}/lsm/external/*
%{python3_sitelib}/lsm/_client.*
%{python3_sitelib}/lsm/_common.*
%{python3_sitelib}/lsm/_local_disk.*
%{python3_sitelib}/lsm/_data.*
%{python3_sitelib}/lsm/_iplugin.*
%{python3_sitelib}/lsm/_pluginrunner.*
%{python3_sitelib}/lsm/_transport.*
%{python3_sitelib}/lsm/__pycache__/*
%{python3_sitelib}/lsm/version.*
%dir %{python3_sitelib}/lsm/plugin
%{python3_sitelib}/lsm/plugin/__init__.*
%{python3_sitelib}/lsm/plugin/__pycache__/*
%dir %{python3_sitelib}/lsm/plugin/sim
%{python3_sitelib}/lsm/plugin/sim/__pycache__/*
%{python3_sitelib}/lsm/plugin/sim/__init__.*
%{python3_sitelib}/lsm/plugin/sim/simulator.*
%{python3_sitelib}/lsm/plugin/sim/simarray.*
%dir %{python3_sitelib}/lsm/lsmcli
%{python3_sitelib}/lsm/lsmcli/__init__.*
%{python3_sitelib}/lsm/lsmcli/__pycache__/*
%{python3_sitelib}/lsm/lsmcli/data_display.*
%{python3_sitelib}/lsm/lsmcli/cmdline.*
%{_bindir}/sim_lsmplugin
%{_sysconfdir}/lsm/pluginconf.d/sim.conf
%{_mandir}/man1/sim_lsmplugin.1*

%files -n python3-%{name}-clibs
%{python3_sitelib}/lsm/_clib.*

%files smis-plugin
%defattr(-,root,root,-)
%dir %{python3_sitelib}/lsm/plugin/smispy
%dir %{python3_sitelib}/lsm/plugin/smispy/__pycache__
%{python3_sitelib}/lsm/plugin/smispy/__pycache__/*
%{python3_sitelib}/lsm/plugin/smispy/__init__.*
%{python3_sitelib}/lsm/plugin/smispy/smis.*
%{python3_sitelib}/lsm/plugin/smispy/dmtf.*
%{python3_sitelib}/lsm/plugin/smispy/utils.*
%{python3_sitelib}/lsm/plugin/smispy/smis_common.*
%{python3_sitelib}/lsm/plugin/smispy/smis_cap.*
%{python3_sitelib}/lsm/plugin/smispy/smis_sys.*
%{python3_sitelib}/lsm/plugin/smispy/smis_pool.*
%{python3_sitelib}/lsm/plugin/smispy/smis_disk.*
%{python3_sitelib}/lsm/plugin/smispy/smis_vol.*
%{python3_sitelib}/lsm/plugin/smispy/smis_ag.*
%{_bindir}/smispy_lsmplugin
%{_mandir}/man1/smispy_lsmplugin.1*

%files netapp-plugin
%defattr(-,root,root,-)
%dir %{python3_sitelib}/lsm/plugin/ontap
%dir %{python3_sitelib}/lsm/plugin/ontap/__pycache__
%{python3_sitelib}/lsm/plugin/ontap/__pycache__/*
%{python3_sitelib}/lsm/plugin/ontap/__init__.*
%{python3_sitelib}/lsm/plugin/ontap/na.*
%{python3_sitelib}/lsm/plugin/ontap/ontap.*
%{_bindir}/ontap_lsmplugin
%{_mandir}/man1/ontap_lsmplugin.1*

%files targetd-plugin
%defattr(-,root,root,-)
%dir %{python3_sitelib}/lsm/plugin/targetd
%dir %{python3_sitelib}/lsm/plugin/targetd/__pycache__
%{python3_sitelib}/lsm/plugin/targetd/__pycache__/*
%{python3_sitelib}/lsm/plugin/targetd/__init__.*
%{python3_sitelib}/lsm/plugin/targetd/targetd.*
%{_bindir}/targetd_lsmplugin
%{_mandir}/man1/targetd_lsmplugin.1*

%files nstor-plugin
%defattr(-,root,root,-)
%dir %{python3_sitelib}/lsm/plugin/nstor
%dir %{python3_sitelib}/lsm/plugin/nstor/__pycache__
%{python3_sitelib}/lsm/plugin/nstor/__pycache__/*
%{python3_sitelib}/lsm/plugin/nstor/__init__.*
%{python3_sitelib}/lsm/plugin/nstor/nstor.*
%{_bindir}/nstor_lsmplugin
%{_mandir}/man1/nstor_lsmplugin.1*

%files udev
%defattr(-,root,root,-)
%{_udevrulesdir}/../scan-scsi-target
%{_udevrulesdir}/90-scsi-ua.rules

%files megaraid-plugin
%defattr(-,root,root,-)
%dir %{python3_sitelib}/lsm/plugin/megaraid
%dir %{python3_sitelib}/lsm/plugin/megaraid/__pycache__
%{python3_sitelib}/lsm/plugin/megaraid/__pycache__/*
%{python3_sitelib}/lsm/plugin/megaraid/__init__.*
%{python3_sitelib}/lsm/plugin/megaraid/megaraid.*
%{python3_sitelib}/lsm/plugin/megaraid/utils.*
%{_bindir}/megaraid_lsmplugin
%config(noreplace) %{_sysconfdir}/lsm/pluginconf.d/megaraid.conf
%{_mandir}/man1/megaraid_lsmplugin.1*

%files hpsa-plugin
%defattr(-,root,root,-)
%dir %{python3_sitelib}/lsm/plugin/hpsa
%dir %{python3_sitelib}/lsm/plugin/hpsa/__pycache__
%{python3_sitelib}/lsm/plugin/hpsa/__pycache__/*
%{python3_sitelib}/lsm/plugin/hpsa/__init__.*
%{python3_sitelib}/lsm/plugin/hpsa/hpsa.*
%{python3_sitelib}/lsm/plugin/hpsa/utils.*
%{_bindir}/hpsa_lsmplugin
%config(noreplace) %{_sysconfdir}/lsm/pluginconf.d/hpsa.conf
%{_mandir}/man1/hpsa_lsmplugin.1*

%files nfs-plugin
%defattr(-,root,root,-)
%dir %{python3_sitelib}/lsm/plugin/nfs
%dir %{python3_sitelib}/lsm/plugin/nfs/__pycache__
%{python3_sitelib}/lsm/plugin/nfs/__pycache__/*
%{python3_sitelib}/lsm/plugin/nfs/__init__.*
%{python3_sitelib}/lsm/plugin/nfs/nfs.*
%{python3_sitelib}/lsm/plugin/nfs/nfs_clib.*
%{_sysconfdir}/lsm/pluginconf.d/nfs.conf
%{_bindir}/nfs_lsmplugin
%{_mandir}/man1/nfs_lsmplugin.1*

%files arcconf-plugin
%defattr(-,root,root,-)
%dir %{python3_sitelib}/lsm/plugin/arcconf
%dir %{python3_sitelib}/lsm/plugin/arcconf/__pycache__
%{python3_sitelib}/lsm/plugin/arcconf/__pycache__/*
%{python3_sitelib}/lsm/plugin/arcconf/__init__.*
%{python3_sitelib}/lsm/plugin/arcconf/arcconf.*
%{python3_sitelib}/lsm/plugin/arcconf/utils.*
%{_bindir}/arcconf_lsmplugin
%config(noreplace) %{_sysconfdir}/lsm/pluginconf.d/arcconf.conf
%{_mandir}/man1/arcconf_lsmplugin.1*

%files local-plugin
%defattr(-,root,root,-)
%dir %{python3_sitelib}/lsm/plugin/local
%dir %{python3_sitelib}/lsm/plugin/local/__pycache__
%{python3_sitelib}/lsm/plugin/local/__pycache__/*
%{python3_sitelib}/lsm/plugin/local/__init__.*
%{python3_sitelib}/lsm/plugin/local/local.*
%{_sysconfdir}/lsm/pluginconf.d/local.conf
%{_bindir}/local_lsmplugin
%{_mandir}/man1/local_lsmplugin.1*

%changelog
