/* expression.c generated by valac 0.20.1.19-a6516, the Vala compiler
 * generated from expression.vala, do not modify */

/*
 * Copyright (C) 2011-2013 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2013 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>


#define KKC_TYPE_EXPRESSION_NODE_TYPE (kkc_expression_node_type_get_type ())

#define KKC_TYPE_EXPRESSION_NODE (kkc_expression_node_get_type ())
typedef struct _KkcExpressionNode KkcExpressionNode;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define KKC_TYPE_EXPRESSION_READER (kkc_expression_reader_get_type ())
#define KKC_EXPRESSION_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_EXPRESSION_READER, KkcExpressionReader))
#define KKC_EXPRESSION_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_EXPRESSION_READER, KkcExpressionReaderClass))
#define KKC_IS_EXPRESSION_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_EXPRESSION_READER))
#define KKC_IS_EXPRESSION_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_EXPRESSION_READER))
#define KKC_EXPRESSION_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_EXPRESSION_READER, KkcExpressionReaderClass))

typedef struct _KkcExpressionReader KkcExpressionReader;
typedef struct _KkcExpressionReaderClass KkcExpressionReaderClass;
typedef struct _KkcExpressionReaderPrivate KkcExpressionReaderPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _kkc_expression_node_free0(var) ((var == NULL) ? NULL : (var = (kkc_expression_node_free (var), NULL)))

#define KKC_TYPE_EXPRESSION_EVALUATOR (kkc_expression_evaluator_get_type ())
#define KKC_EXPRESSION_EVALUATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_EXPRESSION_EVALUATOR, KkcExpressionEvaluator))
#define KKC_EXPRESSION_EVALUATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_EXPRESSION_EVALUATOR, KkcExpressionEvaluatorClass))
#define KKC_IS_EXPRESSION_EVALUATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_EXPRESSION_EVALUATOR))
#define KKC_IS_EXPRESSION_EVALUATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_EXPRESSION_EVALUATOR))
#define KKC_EXPRESSION_EVALUATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_EXPRESSION_EVALUATOR, KkcExpressionEvaluatorClass))

typedef struct _KkcExpressionEvaluator KkcExpressionEvaluator;
typedef struct _KkcExpressionEvaluatorClass KkcExpressionEvaluatorClass;
typedef struct _KkcExpressionEvaluatorPrivate KkcExpressionEvaluatorPrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define KKC_TYPE_EXPRESSION (kkc_expression_get_type ())
#define KKC_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_EXPRESSION, KkcExpression))
#define KKC_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_EXPRESSION, KkcExpressionClass))
#define KKC_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_EXPRESSION))
#define KKC_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_EXPRESSION))
#define KKC_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_EXPRESSION, KkcExpressionClass))

typedef struct _KkcExpression KkcExpression;
typedef struct _KkcExpressionClass KkcExpressionClass;
typedef struct _KkcExpressionPrivate KkcExpressionPrivate;

typedef enum  {
	KKC_EXPRESSION_NODE_TYPE_ARRAY,
	KKC_EXPRESSION_NODE_TYPE_SYMBOL,
	KKC_EXPRESSION_NODE_TYPE_STRING
} KkcExpressionNodeType;

struct _KkcExpressionNode {
	KkcExpressionNodeType type;
	GeeLinkedList* nodes;
	gchar* data;
};

struct _KkcExpressionReader {
	GObject parent_instance;
	KkcExpressionReaderPrivate * priv;
};

struct _KkcExpressionReaderClass {
	GObjectClass parent_class;
};

struct _KkcExpressionEvaluator {
	GObject parent_instance;
	KkcExpressionEvaluatorPrivate * priv;
};

struct _KkcExpressionEvaluatorClass {
	GObjectClass parent_class;
};

struct _KkcExpression {
	GObject parent_instance;
	KkcExpressionPrivate * priv;
};

struct _KkcExpressionClass {
	GObjectClass parent_class;
};


static gpointer kkc_expression_reader_parent_class = NULL;
static gpointer kkc_expression_evaluator_parent_class = NULL;
static gpointer kkc_expression_parent_class = NULL;

GType kkc_expression_node_type_get_type (void) G_GNUC_CONST;
GType kkc_expression_node_get_type (void) G_GNUC_CONST;
KkcExpressionNode* kkc_expression_node_dup (const KkcExpressionNode* self);
void kkc_expression_node_free (KkcExpressionNode* self);
void kkc_expression_node_copy (const KkcExpressionNode* self, KkcExpressionNode* dest);
void kkc_expression_node_destroy (KkcExpressionNode* self);
void kkc_expression_node_init (KkcExpressionNode *self, KkcExpressionNodeType type);
GType kkc_expression_reader_get_type (void) G_GNUC_CONST;
enum  {
	KKC_EXPRESSION_READER_DUMMY_PROPERTY
};
void kkc_expression_reader_read_symbol (KkcExpressionReader* self, const gchar* expr, gint* index, KkcExpressionNode* result);
KkcExpressionNode* kkc_expression_reader_read_string (KkcExpressionReader* self, const gchar* expr, gint* index);
KkcExpressionNode* kkc_expression_reader_read (KkcExpressionReader* self, const gchar* expr, gint* index);
KkcExpressionReader* kkc_expression_reader_new (void);
KkcExpressionReader* kkc_expression_reader_construct (GType object_type);
GType kkc_expression_evaluator_get_type (void) G_GNUC_CONST;
enum  {
	KKC_EXPRESSION_EVALUATOR_DUMMY_PROPERTY
};
gchar* kkc_expression_evaluator_eval (KkcExpressionEvaluator* self, KkcExpressionNode* node);
KkcExpressionEvaluator* kkc_expression_evaluator_new (void);
KkcExpressionEvaluator* kkc_expression_evaluator_construct (GType object_type);
GType kkc_expression_get_type (void) G_GNUC_CONST;
enum  {
	KKC_EXPRESSION_DUMMY_PROPERTY
};
gchar* kkc_expression_eval (const gchar* text);
KkcExpression* kkc_expression_construct (GType object_type);


GType kkc_expression_node_type_get_type (void) {
	static volatile gsize kkc_expression_node_type_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_expression_node_type_type_id__volatile)) {
		static const GEnumValue values[] = {{KKC_EXPRESSION_NODE_TYPE_ARRAY, "KKC_EXPRESSION_NODE_TYPE_ARRAY", "array"}, {KKC_EXPRESSION_NODE_TYPE_SYMBOL, "KKC_EXPRESSION_NODE_TYPE_SYMBOL", "symbol"}, {KKC_EXPRESSION_NODE_TYPE_STRING, "KKC_EXPRESSION_NODE_TYPE_STRING", "string"}, {0, NULL, NULL}};
		GType kkc_expression_node_type_type_id;
		kkc_expression_node_type_type_id = g_enum_register_static ("KkcExpressionNodeType", values);
		g_once_init_leave (&kkc_expression_node_type_type_id__volatile, kkc_expression_node_type_type_id);
	}
	return kkc_expression_node_type_type_id__volatile;
}


void kkc_expression_node_init (KkcExpressionNode *self, KkcExpressionNodeType type) {
	KkcExpressionNodeType _tmp0_;
	memset (self, 0, sizeof (KkcExpressionNode));
	_tmp0_ = type;
	(*self).type = _tmp0_;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void kkc_expression_node_copy (const KkcExpressionNode* self, KkcExpressionNode* dest) {
	KkcExpressionNodeType _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = (*self).type;
	(*dest).type = _tmp0_;
	_tmp1_ = (*self).nodes;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 ((*dest).nodes);
	(*dest).nodes = _tmp2_;
	_tmp3_ = (*self).data;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*dest).data);
	(*dest).data = _tmp4_;
}


void kkc_expression_node_destroy (KkcExpressionNode* self) {
	_g_object_unref0 ((*self).nodes);
	_g_free0 ((*self).data);
}


KkcExpressionNode* kkc_expression_node_dup (const KkcExpressionNode* self) {
	KkcExpressionNode* dup;
	dup = g_new0 (KkcExpressionNode, 1);
	kkc_expression_node_copy (self, dup);
	return dup;
}


void kkc_expression_node_free (KkcExpressionNode* self) {
	kkc_expression_node_destroy (self);
	g_free (self);
}


GType kkc_expression_node_get_type (void) {
	static volatile gsize kkc_expression_node_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_expression_node_type_id__volatile)) {
		GType kkc_expression_node_type_id;
		kkc_expression_node_type_id = g_boxed_type_register_static ("KkcExpressionNode", (GBoxedCopyFunc) kkc_expression_node_dup, (GBoxedFreeFunc) kkc_expression_node_free);
		g_once_init_leave (&kkc_expression_node_type_id__volatile, kkc_expression_node_type_id);
	}
	return kkc_expression_node_type_id__volatile;
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


void kkc_expression_reader_read_symbol (KkcExpressionReader* self, const gchar* expr, gint* index, KkcExpressionNode* result) {
	GString* builder = NULL;
	GString* _tmp0_;
	gboolean stop = FALSE;
	gunichar uc = 0U;
	KkcExpressionNode node = {0};
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	stop = FALSE;
	uc = (gunichar) '\0';
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_;
		gboolean _tmp6_;
		gunichar _tmp7_;
		_tmp2_ = stop;
		if (!_tmp2_) {
			const gchar* _tmp3_;
			gunichar _tmp4_ = 0U;
			gboolean _tmp5_ = FALSE;
			_tmp3_ = expr;
			_tmp5_ = string_get_next_char (_tmp3_, index, &_tmp4_);
			uc = _tmp4_;
			_tmp1_ = _tmp5_;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp6_ = _tmp1_;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = uc;
		switch (_tmp7_) {
			case '\\':
			{
				const gchar* _tmp8_;
				gunichar _tmp9_ = 0U;
				gboolean _tmp10_ = FALSE;
				_tmp8_ = expr;
				_tmp10_ = string_get_next_char (_tmp8_, index, &_tmp9_);
				uc = _tmp9_;
				if (_tmp10_) {
					GString* _tmp11_;
					gunichar _tmp12_;
					_tmp11_ = builder;
					_tmp12_ = uc;
					g_string_append_unichar (_tmp11_, _tmp12_);
				}
				break;
			}
			case '(':
			case ')':
			case '"':
			case ' ':
			{
				stop = TRUE;
				break;
			}
			default:
			{
				GString* _tmp13_;
				gunichar _tmp14_;
				_tmp13_ = builder;
				_tmp14_ = uc;
				g_string_append_unichar (_tmp13_, _tmp14_);
				break;
			}
		}
	}
	kkc_expression_node_init (&node, KKC_EXPRESSION_NODE_TYPE_SYMBOL);
	_tmp15_ = builder;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	_g_free0 (node.data);
	node.data = _tmp17_;
	*result = node;
	_g_string_free0 (builder);
	return;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gpointer _kkc_expression_node_dup0 (gpointer self) {
	return self ? kkc_expression_node_dup (self) : NULL;
}


KkcExpressionNode* kkc_expression_reader_read_string (KkcExpressionReader* self, const gchar* expr, gint* index) {
	KkcExpressionNode* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp8_;
	GString* builder = NULL;
	GString* _tmp9_;
	gint _tmp10_;
	gboolean stop = FALSE;
	gunichar uc = 0U;
	KkcExpressionNode node = {0};
	GString* _tmp63_;
	const gchar* _tmp64_;
	gchar* _tmp65_;
	KkcExpressionNode _tmp66_;
	KkcExpressionNode* _tmp67_;
	KkcExpressionNode* _tmp68_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	_tmp1_ = *index;
	_tmp2_ = expr;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp1_ < _tmp4_) {
		const gchar* _tmp5_;
		gint _tmp6_;
		gchar _tmp7_ = '\0';
		_tmp5_ = expr;
		_tmp6_ = *index;
		_tmp7_ = string_get (_tmp5_, (glong) _tmp6_);
		_tmp0_ = _tmp7_ == '"';
	} else {
		_tmp0_ = FALSE;
	}
	_tmp8_ = _tmp0_;
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp9_ = g_string_new ("");
	builder = _tmp9_;
	_tmp10_ = *index;
	*index = _tmp10_ + 1;
	stop = FALSE;
	uc = (gunichar) '\0';
	while (TRUE) {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_;
		gboolean _tmp16_;
		gunichar _tmp17_;
		_tmp12_ = stop;
		if (!_tmp12_) {
			const gchar* _tmp13_;
			gunichar _tmp14_ = 0U;
			gboolean _tmp15_ = FALSE;
			_tmp13_ = expr;
			_tmp15_ = string_get_next_char (_tmp13_, index, &_tmp14_);
			uc = _tmp14_;
			_tmp11_ = _tmp15_;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp16_ = _tmp11_;
		if (!_tmp16_) {
			break;
		}
		_tmp17_ = uc;
		switch (_tmp17_) {
			case '\\':
			{
				const gchar* _tmp18_;
				gunichar _tmp19_ = 0U;
				gboolean _tmp20_ = FALSE;
				_tmp18_ = expr;
				_tmp20_ = string_get_next_char (_tmp18_, index, &_tmp19_);
				uc = _tmp19_;
				if (_tmp20_) {
					gunichar _tmp21_;
					GString* _tmp59_;
					gunichar _tmp60_;
					_tmp21_ = uc;
					switch (_tmp21_) {
						case '0':
						case '1':
						case '2':
						case '3':
						case '4':
						case '5':
						case '6':
						case '7':
						{
							gint start = 0;
							gint _tmp22_;
							gint num = 0;
							gunichar _tmp23_;
							gint _tmp36_;
							gint _tmp37_;
							_tmp22_ = *index;
							start = _tmp22_;
							_tmp23_ = uc;
							num = ((gint) _tmp23_) - '0';
							while (TRUE) {
								const gchar* _tmp24_;
								gunichar _tmp25_ = 0U;
								gboolean _tmp26_ = FALSE;
								gint _tmp27_;
								gint _tmp28_;
								gboolean _tmp29_ = FALSE;
								gunichar _tmp30_;
								gboolean _tmp32_;
								gint _tmp33_;
								gint _tmp34_;
								gunichar _tmp35_;
								_tmp24_ = expr;
								_tmp26_ = string_get_next_char (_tmp24_, index, &_tmp25_);
								uc = _tmp25_;
								if (!_tmp26_) {
									break;
								}
								_tmp27_ = *index;
								_tmp28_ = start;
								if ((_tmp27_ - _tmp28_) == 3) {
									break;
								}
								_tmp30_ = uc;
								if (_tmp30_ < ((gunichar) '0')) {
									_tmp29_ = TRUE;
								} else {
									gunichar _tmp31_;
									_tmp31_ = uc;
									_tmp29_ = _tmp31_ > ((gunichar) '7');
								}
								_tmp32_ = _tmp29_;
								if (_tmp32_) {
									break;
								}
								_tmp33_ = num;
								num = _tmp33_ << 3;
								_tmp34_ = num;
								_tmp35_ = uc;
								num = _tmp34_ + (((gint) _tmp35_) - '0');
							}
							_tmp36_ = *index;
							*index = _tmp36_ - 1;
							_tmp37_ = num;
							uc = (gunichar) _tmp37_;
							break;
						}
						case 'x':
						{
							gint num = 0;
							gint _tmp57_;
							gint _tmp58_;
							num = 0;
							while (TRUE) {
								const gchar* _tmp38_;
								gunichar _tmp39_ = 0U;
								gboolean _tmp40_ = FALSE;
								gunichar _tmp41_;
								gunichar _tmp42_ = 0U;
								gboolean _tmp43_ = FALSE;
								gunichar _tmp44_;
								gboolean _tmp46_;
								_tmp38_ = expr;
								_tmp40_ = string_get_next_char (_tmp38_, index, &_tmp39_);
								uc = _tmp39_;
								if (!_tmp40_) {
									break;
								}
								_tmp41_ = uc;
								_tmp42_ = g_unichar_tolower (_tmp41_);
								uc = _tmp42_;
								_tmp44_ = uc;
								if (((gunichar) '0') <= _tmp44_) {
									gunichar _tmp45_;
									_tmp45_ = uc;
									_tmp43_ = _tmp45_ <= ((gunichar) '9');
								} else {
									_tmp43_ = FALSE;
								}
								_tmp46_ = _tmp43_;
								if (_tmp46_) {
									gint _tmp47_;
									gint _tmp48_;
									gunichar _tmp49_;
									_tmp47_ = num;
									num = _tmp47_ << 4;
									_tmp48_ = num;
									_tmp49_ = uc;
									num = _tmp48_ + (((gint) _tmp49_) - '0');
								} else {
									gboolean _tmp50_ = FALSE;
									gunichar _tmp51_;
									gboolean _tmp53_;
									_tmp51_ = uc;
									if (((gunichar) 'a') <= _tmp51_) {
										gunichar _tmp52_;
										_tmp52_ = uc;
										_tmp50_ = _tmp52_ <= ((gunichar) 'f');
									} else {
										_tmp50_ = FALSE;
									}
									_tmp53_ = _tmp50_;
									if (_tmp53_) {
										gint _tmp54_;
										gint _tmp55_;
										gunichar _tmp56_;
										_tmp54_ = num;
										num = _tmp54_ << 4;
										_tmp55_ = num;
										_tmp56_ = uc;
										num = _tmp55_ + ((((gint) _tmp56_) - 'a') + 10);
									} else {
										break;
									}
								}
							}
							_tmp57_ = *index;
							*index = _tmp57_ - 1;
							_tmp58_ = num;
							uc = (gunichar) _tmp58_;
							break;
						}
						default:
						{
							break;
						}
					}
					_tmp59_ = builder;
					_tmp60_ = uc;
					g_string_append_unichar (_tmp59_, _tmp60_);
				}
				break;
			}
			case '\"':
			{
				stop = TRUE;
				break;
			}
			default:
			{
				GString* _tmp61_;
				gunichar _tmp62_;
				_tmp61_ = builder;
				_tmp62_ = uc;
				g_string_append_unichar (_tmp61_, _tmp62_);
				break;
			}
		}
	}
	kkc_expression_node_init (&node, KKC_EXPRESSION_NODE_TYPE_STRING);
	_tmp63_ = builder;
	_tmp64_ = _tmp63_->str;
	_tmp65_ = g_strdup (_tmp64_);
	_g_free0 (node.data);
	node.data = _tmp65_;
	_tmp66_ = node;
	_tmp67_ = _kkc_expression_node_dup0 (&_tmp66_);
	_tmp68_ = _tmp67_;
	kkc_expression_node_destroy (&_tmp66_);
	result = _tmp68_;
	_g_string_free0 (builder);
	return result;
}


KkcExpressionNode* kkc_expression_reader_read (KkcExpressionReader* self, const gchar* expr, gint* index) {
	KkcExpressionNode* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp8_;
	GeeLinkedList* nodes = NULL;
	GeeLinkedList* _tmp9_;
	gboolean stop = FALSE;
	gint _tmp10_;
	gunichar uc = 0U;
	KkcExpressionNode node = {0};
	GeeLinkedList* _tmp35_;
	GeeLinkedList* _tmp36_;
	KkcExpressionNode _tmp37_;
	KkcExpressionNode* _tmp38_;
	KkcExpressionNode* _tmp39_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	_tmp1_ = *index;
	_tmp2_ = expr;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp1_ < _tmp4_) {
		const gchar* _tmp5_;
		gint _tmp6_;
		gchar _tmp7_ = '\0';
		_tmp5_ = expr;
		_tmp6_ = *index;
		_tmp7_ = string_get (_tmp5_, (glong) _tmp6_);
		_tmp0_ = _tmp7_ == '(';
	} else {
		_tmp0_ = FALSE;
	}
	_tmp8_ = _tmp0_;
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp9_ = gee_linked_list_new (KKC_TYPE_EXPRESSION_NODE, (GBoxedCopyFunc) kkc_expression_node_dup, kkc_expression_node_free, NULL);
	nodes = _tmp9_;
	stop = FALSE;
	_tmp10_ = *index;
	*index = _tmp10_ + 1;
	uc = (gunichar) '\0';
	while (TRUE) {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_;
		gboolean _tmp16_;
		gunichar _tmp17_;
		_tmp12_ = stop;
		if (!_tmp12_) {
			const gchar* _tmp13_;
			gunichar _tmp14_ = 0U;
			gboolean _tmp15_ = FALSE;
			_tmp13_ = expr;
			_tmp15_ = string_get_next_char (_tmp13_, index, &_tmp14_);
			uc = _tmp14_;
			_tmp11_ = _tmp15_;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp16_ = _tmp11_;
		if (!_tmp16_) {
			break;
		}
		_tmp17_ = uc;
		switch (_tmp17_) {
			case ' ':
			{
				break;
			}
			case ')':
			{
				gint _tmp18_;
				_tmp18_ = *index;
				*index = _tmp18_ + 1;
				stop = TRUE;
				break;
			}
			case '(':
			{
				gint _tmp19_;
				GeeLinkedList* _tmp20_;
				const gchar* _tmp21_;
				KkcExpressionNode* _tmp22_ = NULL;
				KkcExpressionNode* _tmp23_;
				_tmp19_ = *index;
				*index = _tmp19_ - 1;
				_tmp20_ = nodes;
				_tmp21_ = expr;
				_tmp22_ = kkc_expression_reader_read (self, _tmp21_, index);
				_tmp23_ = _tmp22_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp23_);
				_kkc_expression_node_free0 (_tmp23_);
				break;
			}
			case '"':
			{
				gint _tmp24_;
				GeeLinkedList* _tmp25_;
				const gchar* _tmp26_;
				KkcExpressionNode* _tmp27_ = NULL;
				KkcExpressionNode* _tmp28_;
				_tmp24_ = *index;
				*index = _tmp24_ - 1;
				_tmp25_ = nodes;
				_tmp26_ = expr;
				_tmp27_ = kkc_expression_reader_read_string (self, _tmp26_, index);
				_tmp28_ = _tmp27_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp28_);
				_kkc_expression_node_free0 (_tmp28_);
				break;
			}
			default:
			{
				gint _tmp29_;
				GeeLinkedList* _tmp30_;
				const gchar* _tmp31_;
				KkcExpressionNode _tmp32_ = {0};
				KkcExpressionNode _tmp33_;
				KkcExpressionNode _tmp34_;
				_tmp29_ = *index;
				*index = _tmp29_ - 1;
				_tmp30_ = nodes;
				_tmp31_ = expr;
				kkc_expression_reader_read_symbol (self, _tmp31_, index, &_tmp32_);
				_tmp33_ = _tmp32_;
				_tmp34_ = _tmp33_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, &_tmp34_);
				kkc_expression_node_destroy (&_tmp33_);
				break;
			}
		}
	}
	kkc_expression_node_init (&node, KKC_EXPRESSION_NODE_TYPE_ARRAY);
	_tmp35_ = nodes;
	_tmp36_ = _g_object_ref0 (_tmp35_);
	_g_object_unref0 (node.nodes);
	node.nodes = _tmp36_;
	_tmp37_ = node;
	_tmp38_ = _kkc_expression_node_dup0 (&_tmp37_);
	_tmp39_ = _tmp38_;
	kkc_expression_node_destroy (&_tmp37_);
	result = _tmp39_;
	_g_object_unref0 (nodes);
	return result;
}


KkcExpressionReader* kkc_expression_reader_construct (GType object_type) {
	KkcExpressionReader * self = NULL;
	self = (KkcExpressionReader*) g_object_new (object_type, NULL);
	return self;
}


KkcExpressionReader* kkc_expression_reader_new (void) {
	return kkc_expression_reader_construct (KKC_TYPE_EXPRESSION_READER);
}


static void kkc_expression_reader_class_init (KkcExpressionReaderClass * klass) {
	kkc_expression_reader_parent_class = g_type_class_peek_parent (klass);
}


static void kkc_expression_reader_instance_init (KkcExpressionReader * self) {
}


GType kkc_expression_reader_get_type (void) {
	static volatile gsize kkc_expression_reader_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_expression_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcExpressionReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_expression_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcExpressionReader), 0, (GInstanceInitFunc) kkc_expression_reader_instance_init, NULL };
		GType kkc_expression_reader_type_id;
		kkc_expression_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcExpressionReader", &g_define_type_info, 0);
		g_once_init_leave (&kkc_expression_reader_type_id__volatile, kkc_expression_reader_type_id);
	}
	return kkc_expression_reader_type_id__volatile;
}


gchar* kkc_expression_evaluator_eval (KkcExpressionEvaluator* self, KkcExpressionNode* node) {
	gchar* result = NULL;
	KkcExpressionNode _tmp0_;
	KkcExpressionNodeType _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = *node;
	_tmp1_ = _tmp0_.type;
	if (_tmp1_ == KKC_EXPRESSION_NODE_TYPE_ARRAY) {
		GeeListIterator* iter = NULL;
		KkcExpressionNode _tmp2_;
		GeeLinkedList* _tmp3_;
		GeeListIterator* _tmp4_ = NULL;
		GeeListIterator* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp2_ = *node;
		_tmp3_ = _tmp2_.nodes;
		_tmp4_ = gee_abstract_list_list_iterator ((GeeAbstractList*) _tmp3_);
		iter = _tmp4_;
		_tmp5_ = iter;
		_tmp6_ = gee_iterator_first ((GeeIterator*) _tmp5_);
		if (_tmp6_) {
			KkcExpressionNode* funcall = NULL;
			GeeListIterator* _tmp7_;
			gpointer _tmp8_ = NULL;
			KkcExpressionNode* _tmp9_;
			KkcExpressionNodeType _tmp10_;
			_tmp7_ = iter;
			_tmp8_ = gee_iterator_get ((GeeIterator*) _tmp7_);
			funcall = (KkcExpressionNode*) _tmp8_;
			_tmp9_ = funcall;
			_tmp10_ = (*_tmp9_).type;
			if (_tmp10_ == KKC_EXPRESSION_NODE_TYPE_SYMBOL) {
				KkcExpressionNode* _tmp11_;
				const gchar* _tmp12_;
				_tmp11_ = funcall;
				_tmp12_ = (*_tmp11_).data;
				if (g_strcmp0 (_tmp12_, "concat") == 0) {
					GString* builder = NULL;
					GString* _tmp13_;
					GString* _tmp23_;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp13_ = g_string_new ("");
					builder = _tmp13_;
					while (TRUE) {
						GeeListIterator* _tmp14_;
						gboolean _tmp15_ = FALSE;
						KkcExpressionNode* arg = NULL;
						GeeListIterator* _tmp16_;
						gpointer _tmp17_ = NULL;
						KkcExpressionNode* _tmp18_;
						KkcExpressionNodeType _tmp19_;
						_tmp14_ = iter;
						_tmp15_ = gee_iterator_next ((GeeIterator*) _tmp14_);
						if (!_tmp15_) {
							break;
						}
						_tmp16_ = iter;
						_tmp17_ = gee_iterator_get ((GeeIterator*) _tmp16_);
						arg = (KkcExpressionNode*) _tmp17_;
						_tmp18_ = arg;
						_tmp19_ = (*_tmp18_).type;
						if (_tmp19_ == KKC_EXPRESSION_NODE_TYPE_STRING) {
							GString* _tmp20_;
							KkcExpressionNode* _tmp21_;
							const gchar* _tmp22_;
							_tmp20_ = builder;
							_tmp21_ = arg;
							_tmp22_ = (*_tmp21_).data;
							g_string_append (_tmp20_, _tmp22_);
						}
						_kkc_expression_node_free0 (arg);
					}
					_tmp23_ = builder;
					_tmp24_ = _tmp23_->str;
					_tmp25_ = g_strdup (_tmp24_);
					result = _tmp25_;
					_g_string_free0 (builder);
					_kkc_expression_node_free0 (funcall);
					_g_object_unref0 (iter);
					return result;
				} else {
					KkcExpressionNode* _tmp26_;
					const gchar* _tmp27_;
					_tmp26_ = funcall;
					_tmp27_ = (*_tmp26_).data;
					if (g_strcmp0 (_tmp27_, "current-time-string") == 0) {
						GDateTime* datetime = NULL;
						GDateTime* _tmp28_;
						GDateTime* _tmp29_;
						gchar* _tmp30_ = NULL;
						_tmp28_ = g_date_time_new_now_local ();
						datetime = _tmp28_;
						_tmp29_ = datetime;
						_tmp30_ = g_date_time_format (_tmp29_, "%a, %d %b %Y %T %z");
						result = _tmp30_;
						_g_date_time_unref0 (datetime);
						_kkc_expression_node_free0 (funcall);
						_g_object_unref0 (iter);
						return result;
					} else {
						KkcExpressionNode* _tmp31_;
						const gchar* _tmp32_;
						_tmp31_ = funcall;
						_tmp32_ = (*_tmp31_).data;
						if (g_strcmp0 (_tmp32_, "pwd") == 0) {
							gchar* _tmp33_ = NULL;
							_tmp33_ = g_get_current_dir ();
							result = _tmp33_;
							_kkc_expression_node_free0 (funcall);
							_g_object_unref0 (iter);
							return result;
						} else {
							KkcExpressionNode* _tmp34_;
							const gchar* _tmp35_;
							_tmp34_ = funcall;
							_tmp35_ = (*_tmp34_).data;
							if (g_strcmp0 (_tmp35_, "kkc-version") == 0) {
								gchar* _tmp36_ = NULL;
								_tmp36_ = g_strdup_printf ("%s/%s", PACKAGE_NAME, PACKAGE_VERSION);
								result = _tmp36_;
								_kkc_expression_node_free0 (funcall);
								_g_object_unref0 (iter);
								return result;
							}
						}
					}
				}
			}
			_kkc_expression_node_free0 (funcall);
		}
		_g_object_unref0 (iter);
	}
	result = NULL;
	return result;
}


KkcExpressionEvaluator* kkc_expression_evaluator_construct (GType object_type) {
	KkcExpressionEvaluator * self = NULL;
	self = (KkcExpressionEvaluator*) g_object_new (object_type, NULL);
	return self;
}


KkcExpressionEvaluator* kkc_expression_evaluator_new (void) {
	return kkc_expression_evaluator_construct (KKC_TYPE_EXPRESSION_EVALUATOR);
}


static void kkc_expression_evaluator_class_init (KkcExpressionEvaluatorClass * klass) {
	kkc_expression_evaluator_parent_class = g_type_class_peek_parent (klass);
}


static void kkc_expression_evaluator_instance_init (KkcExpressionEvaluator * self) {
}


GType kkc_expression_evaluator_get_type (void) {
	static volatile gsize kkc_expression_evaluator_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_expression_evaluator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcExpressionEvaluatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_expression_evaluator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcExpressionEvaluator), 0, (GInstanceInitFunc) kkc_expression_evaluator_instance_init, NULL };
		GType kkc_expression_evaluator_type_id;
		kkc_expression_evaluator_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcExpressionEvaluator", &g_define_type_info, 0);
		g_once_init_leave (&kkc_expression_evaluator_type_id__volatile, kkc_expression_evaluator_type_id);
	}
	return kkc_expression_evaluator_type_id__volatile;
}


gchar* kkc_expression_eval (const gchar* text) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = text;
	_tmp1_ = g_str_has_prefix (_tmp0_, "(");
	if (_tmp1_) {
		KkcExpressionReader* reader = NULL;
		KkcExpressionReader* _tmp2_;
		gint index = 0;
		KkcExpressionNode* node = NULL;
		KkcExpressionReader* _tmp3_;
		const gchar* _tmp4_;
		KkcExpressionNode* _tmp5_ = NULL;
		KkcExpressionEvaluator* evaluator = NULL;
		KkcExpressionEvaluator* _tmp6_;
		gchar* _result_ = NULL;
		KkcExpressionEvaluator* _tmp7_;
		KkcExpressionNode* _tmp8_;
		KkcExpressionNode _tmp9_;
		gchar* _tmp10_ = NULL;
		const gchar* _tmp11_;
		_tmp2_ = kkc_expression_reader_new ();
		reader = _tmp2_;
		index = 0;
		_tmp3_ = reader;
		_tmp4_ = text;
		_tmp5_ = kkc_expression_reader_read (_tmp3_, _tmp4_, &index);
		node = _tmp5_;
		_tmp6_ = kkc_expression_evaluator_new ();
		evaluator = _tmp6_;
		_tmp7_ = evaluator;
		_tmp8_ = node;
		_tmp9_ = *_tmp8_;
		_tmp10_ = kkc_expression_evaluator_eval (_tmp7_, &_tmp9_);
		_result_ = _tmp10_;
		_tmp11_ = _result_;
		if (_tmp11_ != NULL) {
			result = _result_;
			_g_object_unref0 (evaluator);
			_kkc_expression_node_free0 (node);
			_g_object_unref0 (reader);
			return result;
		}
		_g_free0 (_result_);
		_g_object_unref0 (evaluator);
		_kkc_expression_node_free0 (node);
		_g_object_unref0 (reader);
	}
	_tmp12_ = text;
	_tmp13_ = g_strdup (_tmp12_);
	result = _tmp13_;
	return result;
}


KkcExpression* kkc_expression_construct (GType object_type) {
	KkcExpression * self = NULL;
	self = (KkcExpression*) g_object_new (object_type, NULL);
	return self;
}


static void kkc_expression_class_init (KkcExpressionClass * klass) {
	kkc_expression_parent_class = g_type_class_peek_parent (klass);
}


static void kkc_expression_instance_init (KkcExpression * self) {
}


GType kkc_expression_get_type (void) {
	static volatile gsize kkc_expression_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcExpression), 0, (GInstanceInitFunc) kkc_expression_instance_init, NULL };
		GType kkc_expression_type_id;
		kkc_expression_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcExpression", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&kkc_expression_type_id__volatile, kkc_expression_type_id);
	}
	return kkc_expression_type_id__volatile;
}



