/* This program is released under the Common Public License V1.0
 *
 * You should have received a copy of Common Public License V1.0 along with
 * with this program.
 */

/* Copyright IBM Corp. 2001, 2009, 2011 */

#include <fcntl.h>
#include <memory.h>
#include <sys/errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include "ica_api.h"

unsigned char pubkey1024[] =
                  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03 };

unsigned char modulus1024[] =
                  { 0xec, 0x51, 0xab, 0xa1, 0xf8, 0x40, 0x2c, 0x08,
                    0x2e, 0x24, 0x52, 0x2e, 0x3c, 0x51, 0x6d, 0x98,
                    0xad, 0xee, 0xc7, 0x7d, 0x00, 0xaf, 0xe1, 0xa8,
                    0x61, 0xda, 0x32, 0x97, 0xb4, 0x32, 0x97, 0xe3,
                    0x52, 0xda, 0x28, 0x45, 0x55, 0xc6, 0xb2, 0x46,
                    0x65, 0x1b, 0x02, 0xcb, 0xbe, 0xf4, 0x2c, 0x6b,
                    0x2a, 0x5f, 0xe1, 0xdf, 0xe9, 0xe3, 0xbc, 0x47,
                    0xb7, 0x38, 0xb5, 0xa2, 0x78, 0x9d, 0x15, 0xe2,
                    0x59, 0x81, 0x77, 0x6b, 0x6b, 0x2e, 0xa9, 0xdb,
                    0x13, 0x26, 0x9c, 0xca, 0x5e, 0x0a, 0x1f, 0x3c,
                    0x50, 0x9d, 0xd6, 0x79, 0x59, 0x99, 0x50, 0xe5,
                    0x68, 0x1a, 0x98, 0xca, 0x11, 0xce, 0x37, 0x63,
                    0x58, 0x22, 0x40, 0x19, 0x29, 0x72, 0x4c, 0x41,
                    0x89, 0x0b, 0x56, 0x9e, 0x3e, 0xd5, 0x6d, 0x75,
                    0x9e, 0x3f, 0x8a, 0x50, 0xf1, 0x0a, 0x59, 0x4a,
                    0xc3, 0x59, 0x4b, 0xf6, 0xbb, 0xc9, 0xa5, 0x93 };



unsigned char Bp[] =
                  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                    0xa7, 0xcf, 0xa2, 0x18, 0x2c, 0xa9, 0xb4, 0xb9,
                    0xf5, 0x9e, 0xc9, 0x04, 0x16, 0xd9, 0xa6, 0x8b,
                    0x90, 0x4a, 0x19, 0x6d, 0x64, 0xb7, 0x17, 0x67,
                    0x53, 0xfa, 0x4e, 0x8d, 0xde, 0xa6, 0x94, 0x32,
                    0x5d, 0xcf, 0x58, 0x3e, 0x90, 0xbb, 0x30, 0x19,
                    0x96, 0x38, 0x95, 0xb6, 0xca, 0x2f, 0xfa, 0x22,
                    0x81, 0x65, 0x3b, 0x3c, 0x95, 0x9e, 0x79, 0x75,
                    0xe4, 0x93, 0x50, 0xf1, 0x88, 0x6b, 0xc1, 0x87 };

unsigned char Bq[] =
                  { 0xa0, 0x3a, 0x18, 0xa4, 0x1c, 0x3c, 0x49, 0x09,
                    0xd0, 0x84, 0x4a, 0x8c, 0x7c, 0xce, 0xdf, 0x9e,
                    0x90, 0x7d, 0xc4, 0xca, 0x7e, 0x2d, 0x3d, 0xbc,
                    0x09, 0x71, 0x79, 0xd0, 0xc0, 0xae, 0xa6, 0xc1,
                    0x9d, 0xf0, 0x16, 0xf0, 0x1f, 0x68, 0x9a, 0xc5,
                    0x2b, 0xf3, 0x5a, 0xfc, 0x2c, 0xf5, 0xa7, 0xec,
                    0xd9, 0xa2, 0xac, 0x49, 0xcc, 0x76, 0x9c, 0xd8,
                    0x4c, 0x59, 0x5e, 0x38, 0xd2, 0x85, 0xd3, 0x3b };

unsigned char Np[] =
                  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                    0xfb, 0xb7, 0x73, 0x24, 0x42, 0xfe, 0x8f, 0x16,
                    0xf0, 0x6e, 0x2d, 0x86, 0x22, 0x46, 0x79, 0xd1,
                    0x58, 0x6f, 0x26, 0x24, 0x17, 0x12, 0xa3, 0x1a,
                    0xfd, 0xf7, 0x75, 0xd4, 0xcd, 0xf9, 0xde, 0x4b,
                    0x8c, 0xb7, 0x04, 0x5d, 0xd9, 0x18, 0xc8, 0x26,
                    0x61, 0x54, 0xe0, 0x92, 0x2f, 0x47, 0xf7, 0x33,
                    0xc2, 0x17, 0xd8, 0xda, 0xe0, 0x6d, 0xb6, 0x30,
                    0xd6, 0xdc, 0xf9, 0x6a, 0x4c, 0xa1, 0xa2, 0x4b };

unsigned char Nq[] =
                  { 0xf0, 0x57, 0x24, 0xf6, 0x2a, 0x5a, 0x6d, 0x8e,
                    0xb8, 0xc6, 0x6f, 0xd2, 0xbb, 0x36, 0x4f, 0x6d,
                    0xd8, 0xbc, 0xa7, 0x2f, 0xbd, 0x43, 0xdc, 0x9a,
                    0x0e, 0x2a, 0x36, 0xb9, 0x21, 0x05, 0xfa, 0x22,
                    0x6c, 0xe8, 0x22, 0x68, 0x2f, 0x1c, 0xe8, 0x27,
                    0xc1, 0xed, 0x08, 0x7a, 0x43, 0x70, 0x7b, 0xe3,
                    0x46, 0x74, 0x02, 0x6e, 0xb2, 0xb1, 0xeb, 0x44,
                    0x72, 0x86, 0x0d, 0x55, 0x3b, 0xc8, 0xbc, 0xd9 };

unsigned char U[] =
                  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                    0x83, 0xf1, 0xca, 0x06, 0x58, 0x4a, 0x04, 0x5e,
                    0x96, 0xb5, 0x30, 0x32, 0x40, 0x36, 0x48, 0xb9,
                    0x02, 0x0c, 0xe3, 0x37, 0xb7, 0x51, 0xbc, 0x22,
                    0x26, 0x5d, 0x74, 0x03, 0x47, 0xd3, 0x33, 0x20,
                    0x8e, 0x75, 0x62, 0xf2, 0x9d, 0x4e, 0xc8, 0x7d,
                    0x5d, 0x8e, 0xb6, 0xd9, 0x69, 0x4a, 0x9a, 0xe1,
                    0x36, 0x6e, 0x1c, 0xbe, 0x8a, 0x14, 0xb1, 0x85,
                    0x39, 0x74, 0x7c, 0x25, 0xd8, 0xa4, 0x4f, 0xde };




unsigned char R[128];

unsigned char A[] =
                  { 0x00, 0x02, 0x08, 0x68, 0x30, 0x9a, 0x32, 0x08,
                    0x57, 0xb0, 0x28, 0xaa, 0x76, 0x30, 0x3d, 0x84,
                    0x5f, 0x92, 0x0d, 0x8e, 0x34, 0xe0, 0xd5, 0xcc,
                    0x36, 0x97, 0xed, 0x00, 0x00, 0x01, 0x02, 0x03,
                    0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
                    0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13,
                    0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
                    0x1c, 0x1d, 0x1e, 0x1f, 0x20, 0x21, 0x22, 0x23,
                    0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b,
                    0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33,
                    0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b,
                    0x3c, 0x3d, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43,
                    0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b,
                    0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53,
                    0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b,
                    0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61, 0x62, 0x63 };

unsigned char Ciphertext[] =
                  { 0xb2, 0xb2, 0x82, 0xd7, 0x2c, 0x6f, 0x53, 0x29,
                    0xee, 0x4c, 0xd1, 0x77, 0xb7, 0x13, 0xf3, 0x1c,
                    0x51, 0x60, 0xd8, 0xa9, 0x4e, 0x52, 0x72, 0x43,
                    0x29, 0xfa, 0x51, 0xaa, 0xd8, 0xbc, 0x31, 0x21,
                    0xe0, 0xac, 0x9b, 0x4e, 0x0, 0x94, 0xac, 0x91,
                    0x7f, 0x1e, 0xfd, 0xfb, 0x1c, 0xfa, 0xa8, 0xe8,
                    0x56, 0x5a, 0x1, 0x17, 0xf1, 0x5f, 0x1, 0xba,
                    0xcd, 0x77, 0xa1, 0x8c, 0x74, 0x8a, 0xef, 0xfa,
                    0x64, 0x58, 0x79, 0x13, 0xaa, 0x54, 0x13, 0x2b,
                    0xaa, 0xe7, 0xc3, 0x50, 0x3b, 0x69, 0x3b, 0xb,
                    0x9a, 0xa9, 0x9d, 0x15, 0x8a, 0x6, 0x45, 0x71,
                    0x40, 0x7a, 0x80, 0x85, 0x4a, 0xbe, 0x68, 0x48,
                    0x6c, 0xe6, 0xdd, 0x96, 0xb0, 0xdc, 0xf4, 0x23,
                    0xa8, 0xea, 0x21, 0x9f, 0xbc, 0x6b, 0x15, 0xa4,
                    0x87, 0x6e, 0x93, 0x56, 0xae, 0xa7, 0x17, 0x4e,
                    0xd7, 0x14, 0xe4, 0x69, 0x4, 0xd5, 0x2e, 0x62 };

extern int errno;

void dump_array(unsigned char *ptr, unsigned int size)
{
   unsigned char *ptr_end;
   unsigned char *h;
   int i = 1;


   h = ptr;
   ptr_end = ptr + size;
   while (h < (unsigned char *)ptr_end) {
      printf("0x%02x ",(unsigned char ) *h);
      h++;
      if (i == 8) {
         printf("\n");
         i = 1;
      } else {
         ++i;
      }
   }
   printf("\n");
}

int main()
{
   ICA_ADAPTER_HANDLE	adapter_handle;
   ICA_KEY_RSA_CRT	icakey;
   ICA_KEY_RSA_MODEXPO	wockey;
   caddr_t		key;
   caddr_t		my_result;
   caddr_t		my_result2;
   /* icaRsaModExpo_t	rsawoc; */
   int			i;
   unsigned int		length;

   i = icaOpenAdapter(0, &adapter_handle);
   if (i != 0) {
      printf("icaOpenAdapter failed and returned %d (0x%x), errno=%d\n", i, i, errno);
      return i;
   }

    /*
     * encrypt with public key
     */

    printf("modulus size = %ld\n", (long)sizeof(modulus1024));
    bzero(&wockey, sizeof(wockey));
    wockey.keyType = KEYTYPE_MODEXPO;
    wockey.keyLength = sizeof(ICA_KEY_RSA_MODEXPO);
    wockey.modulusBitLength = sizeof(modulus1024) * 8;
    wockey.nLength = sizeof(modulus1024);
    wockey.expLength = sizeof(pubkey1024);

    key = (caddr_t)wockey.keyRecord;

    bcopy(&pubkey1024, key, sizeof(pubkey1024));
    wockey.expOffset = key - (char *) &wockey;
    key += sizeof(pubkey1024);
    bcopy(&modulus1024, key, sizeof(modulus1024));
    wockey.nOffset = key - (char *) &wockey;

    my_result = (caddr_t) malloc(sizeof(A));
    bzero(my_result, sizeof(A));
    length = sizeof(A);
	
	printf("wockey.modulusBitLength = %i\n", wockey.modulusBitLength);
    if ((i = icaRsaModExpo(adapter_handle, sizeof(A), A,
                          &wockey, &length, (unsigned char *)my_result)) != 0) {
      printf("icaRsaModExpo failed and returned %d (0x%x).\n", i, i);
    }

    printf("\n\n\n\n\n result of encrypt with public key\n");
    dump_array((unsigned char *)my_result,sizeof(A));
    printf("Ciphertext \n");
    dump_array(Ciphertext,sizeof(A));
    if (memcmp(my_result,Ciphertext,sizeof(A))){
       printf("Ciphertext mismatch\n");
       return 0;
    } else {
       printf("ENCRYPT WORKED\n");
    }

    bzero(&icakey, sizeof(icakey));

     /* Card level CRT operation */
    icakey.keyType = KEYTYPE_PKCSCRT;
    icakey.keyLength = sizeof(ICA_KEY_RSA_CRT);
    icakey.modulusBitLength = sizeof(modulus1024)*8;


    my_result2 = (caddr_t)malloc(sizeof(A));
    bzero(my_result2,sizeof(A));

    key = (caddr_t)icakey.keyRecord;
    /*
     * Bp is copied into the key */
    bcopy(Bp,key,sizeof(Bp));
    icakey.dpLength = sizeof(Bp);
    icakey.dpOffset =  key - (char *)&icakey;
    key += sizeof(Bp);
    /*
     * Bq is copied into the key */
    bcopy(Bq,key,sizeof(Bq));
    icakey.dqLength = sizeof(Bq);
    icakey.dqOffset =  key - (char *)&icakey;
    key += sizeof(Bq);
    /*
     * Np is copied into the key */
    bcopy(Np,key,sizeof(Np));
    icakey.pLength = sizeof(Np);
    icakey.pOffset =  key - (char *)&icakey;
    key += sizeof(Np);
    /*
     * Nq is copied into the key */
    bcopy(Nq,key,sizeof(Nq));
    icakey.qLength = sizeof(Nq);
    icakey.qOffset =  key - (char *)&icakey;
    key += sizeof(Nq);
    /*
     * U is copied into the key */
    bcopy(U,key,sizeof(U));
    icakey.qInvLength = sizeof(U);
    icakey.qInvOffset =  key - (char *)&icakey;
    key += sizeof(U);

/*    printf("size of Bp=%d\n",sizeof(Bp));
    printf("size of Bq=%d\n",sizeof(Bq));
    printf("size of Np=%d\n",sizeof(Np));
    printf("size of Nq=%d\n",sizeof(Nq));
    printf("size of U=%d\n",sizeof(U));
    printf("size of R=%d\n",sizeof(R));

    printf("icakey  private Key record\n");
    dump_array(&icakey,sizeof(ICA_KEY_RSA_CRT)); */


    length = sizeof(Ciphertext);
	icakey.modulusBitLength = length * 8;
	icakey.keyLength = length;
    if ((i = icaRsaCrt(adapter_handle, sizeof(Ciphertext), Ciphertext,
                      &icakey, &length, (unsigned char *)my_result2)) != 0) {
      printf("icaRsaCrt failed and returned %d (0x%x).\n", i, i);
    }

    printf("Result of decrypt\n");
    dump_array((unsigned char *)my_result2, sizeof(A));
    printf("original data\n");
    dump_array(A, sizeof(A));
    if( memcmp(A,my_result2,sizeof(A)) != 0) {
      printf("Results do not match.  Failure!\n");
      return -1;
    } else {
      printf("Results match!\n");
    }

   icaCloseAdapter(adapter_handle);

   return 0;
}

