/* SPDX-License-Identifier: LGPL-2.1-or-later */
/*
 * Copyright (C) 2021 Steven Stallion <sstallion@gmail.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 * the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MOCKS_H
#define MOCKS_H

#include <stdbool.h>
#include <stddef.h>

extern bool mocks_enabled;

void *mock_calloc(size_t nmemb, size_t size);
char *mock_strdup(const char *s);
void mock_free(void *ptr);
int mock_open(const char *pathname, int flags);
int mock_close(int fd);
int mock_ioctl(int fd, unsigned long request, ...);

#endif /* MOCKS_H */
