% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duckdb.R
\name{to_arrow}
\alias{to_arrow}
\title{Create an Arrow object from others}
\usage{
to_arrow(.data, as_arrow_query = TRUE)
}
\arguments{
\item{.data}{the object to be converted}

\item{as_arrow_query}{should the returned object be wrapped as an
\code{arrow_dplyr_query}? (logical, default: \code{TRUE})}
}
\value{
a \code{RecordBatchReader} object, wrapped as an arrow dplyr query which
can be used in dplyr pipelines.
}
\description{
This can be used in pipelines that pass data back and forth between Arrow and
other processes (like DuckDB).
}
\examples{
\dontshow{if (getFromNamespace("run_duckdb_examples", "arrow")()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr)

ds <- InMemoryDataset$create(mtcars)

ds \%>\%
  filter(mpg < 30) \%>\%
  to_duckdb() \%>\%
  group_by(cyl) \%>\%
  summarize(mean_mpg = mean(mpg, na.rm = TRUE)) \%>\%
  to_arrow() \%>\%
  collect()
\dontshow{\}) # examplesIf}
}
