// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package utils

import (
	"encoding/binary"
	"io"
)

type unpackFunc func(in io.Reader, out []uint32)

func unpack1_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	for idx := range out[:32] {
		out[idx] = (inl >> idx) & 1
	}
}

func unpack2_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 2)
	out[1] = (inl >> 2) % (1 << 2)
	out[2] = (inl >> 4) % (1 << 2)
	out[3] = (inl >> 6) % (1 << 2)
	out[4] = (inl >> 8) % (1 << 2)
	out[5] = (inl >> 10) % (1 << 2)
	out[6] = (inl >> 12) % (1 << 2)
	out[7] = (inl >> 14) % (1 << 2)
	out[8] = (inl >> 16) % (1 << 2)
	out[9] = (inl >> 18) % (1 << 2)
	out[10] = (inl >> 20) % (1 << 2)
	out[11] = (inl >> 22) % (1 << 2)
	out[12] = (inl >> 24) % (1 << 2)
	out[13] = (inl >> 26) % (1 << 2)
	out[14] = (inl >> 28) % (1 << 2)
	out[15] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[16] = (inl >> 0) % (1 << 2)
	out[17] = (inl >> 2) % (1 << 2)
	out[18] = (inl >> 4) % (1 << 2)
	out[19] = (inl >> 6) % (1 << 2)
	out[20] = (inl >> 8) % (1 << 2)
	out[21] = (inl >> 10) % (1 << 2)
	out[22] = (inl >> 12) % (1 << 2)
	out[23] = (inl >> 14) % (1 << 2)
	out[24] = (inl >> 16) % (1 << 2)
	out[25] = (inl >> 18) % (1 << 2)
	out[26] = (inl >> 20) % (1 << 2)
	out[27] = (inl >> 22) % (1 << 2)
	out[28] = (inl >> 24) % (1 << 2)
	out[29] = (inl >> 26) % (1 << 2)
	out[30] = (inl >> 28) % (1 << 2)
	out[31] = (inl >> 30)
}

func unpack3_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 3)
	out[1] = (inl >> 3) % (1 << 3)
	out[2] = (inl >> 6) % (1 << 3)
	out[3] = (inl >> 9) % (1 << 3)
	out[4] = (inl >> 12) % (1 << 3)
	out[5] = (inl >> 15) % (1 << 3)
	out[6] = (inl >> 18) % (1 << 3)
	out[7] = (inl >> 21) % (1 << 3)
	out[8] = (inl >> 24) % (1 << 3)
	out[9] = (inl >> 27) % (1 << 3)
	out[10] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[10] |= (inl % (1 << 1)) << (3 - 1)
	out[11] = (inl >> 1) % (1 << 3)
	out[12] = (inl >> 4) % (1 << 3)
	out[13] = (inl >> 7) % (1 << 3)
	out[14] = (inl >> 10) % (1 << 3)
	out[15] = (inl >> 13) % (1 << 3)
	out[16] = (inl >> 16) % (1 << 3)
	out[17] = (inl >> 19) % (1 << 3)
	out[18] = (inl >> 22) % (1 << 3)
	out[19] = (inl >> 25) % (1 << 3)
	out[20] = (inl >> 28) % (1 << 3)
	out[21] = (inl >> 31) % (1 << 3)
	binary.Read(in, binary.LittleEndian, &inl)
	out[21] |= (inl % (1 << 2)) << (3 - 2)
	out[22] = (inl >> 2) % (1 << 3)
	out[23] = (inl >> 5) % (1 << 3)
	out[24] = (inl >> 8) % (1 << 3)
	out[25] = (inl >> 11) % (1 << 3)
	out[26] = (inl >> 14) % (1 << 3)
	out[27] = (inl >> 17) % (1 << 3)
	out[28] = (inl >> 20) % (1 << 3)
	out[29] = (inl >> 23) % (1 << 3)
	out[30] = (inl >> 26) % (1 << 3)
	out[31] = (inl >> 29)
}

func unpack4_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	for i := 0; i < 28; i += 4 {
		out[i/4] = (inl >> i) % (1 << 4)
	}
	out[7] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	for i := 0; i < 28; i += 4 {
		out[8+i/4] = (inl >> i) % (1 << 4)
	}
	out[15] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	for i := 0; i < 28; i += 4 {
		out[16+i/4] = (inl >> i) % (1 << 4)
	}
	out[23] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	for i := 0; i < 28; i += 4 {
		out[24+i/4] = (inl >> i) % (1 << 4)
	}
	out[31] = (inl >> 28)
}

func unpack5_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 5)
	out[1] = (inl >> 5) % (1 << 5)
	out[2] = (inl >> 10) % (1 << 5)
	out[3] = (inl >> 15) % (1 << 5)
	out[4] = (inl >> 20) % (1 << 5)
	out[5] = (inl >> 25) % (1 << 5)
	out[6] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[6] |= (inl % (1 << 3)) << (5 - 3)
	out[7] = (inl >> 3) % (1 << 5)
	out[8] = (inl >> 8) % (1 << 5)
	out[9] = (inl >> 13) % (1 << 5)
	out[10] = (inl >> 18) % (1 << 5)
	out[11] = (inl >> 23) % (1 << 5)
	out[12] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[12] |= (inl % (1 << 1)) << (5 - 1)
	out[13] = (inl >> 1) % (1 << 5)
	out[14] = (inl >> 6) % (1 << 5)
	out[15] = (inl >> 11) % (1 << 5)
	out[16] = (inl >> 16) % (1 << 5)
	out[17] = (inl >> 21) % (1 << 5)
	out[18] = (inl >> 26) % (1 << 5)
	out[19] = (inl >> 31)
	binary.Read(in, binary.LittleEndian, &inl)
	out[19] |= (inl % (1 << 4)) << (5 - 4)
	out[20] = (inl >> 4) % (1 << 5)
	out[21] = (inl >> 9) % (1 << 5)
	out[22] = (inl >> 14) % (1 << 5)
	out[23] = (inl >> 19) % (1 << 5)
	out[24] = (inl >> 24) % (1 << 5)
	out[25] = (inl >> 29)
	binary.Read(in, binary.LittleEndian, &inl)
	out[25] |= (inl % (1 << 2)) << (5 - 2)
	out[26] = (inl >> 2) % (1 << 5)
	out[27] = (inl >> 7) % (1 << 5)
	out[28] = (inl >> 12) % (1 << 5)
	out[29] = (inl >> 17) % (1 << 5)
	out[30] = (inl >> 22) % (1 << 5)
	out[31] = (inl >> 27)
}

func unpack6_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 6)
	out[1] = (inl >> 6) % (1 << 6)
	out[2] = (inl >> 12) % (1 << 6)
	out[3] = (inl >> 18) % (1 << 6)
	out[4] = (inl >> 24) % (1 << 6)
	out[5] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[5] |= (inl % (1 << 4)) << (6 - 4)
	out[6] = (inl >> 4) % (1 << 6)
	out[7] = (inl >> 10) % (1 << 6)
	out[8] = (inl >> 16) % (1 << 6)
	out[9] = (inl >> 22) % (1 << 6)
	out[10] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[10] |= (inl % (1 << 2)) << (6 - 2)
	out[11] = (inl >> 2) % (1 << 6)
	out[12] = (inl >> 8) % (1 << 6)
	out[13] = (inl >> 14) % (1 << 6)
	out[14] = (inl >> 20) % (1 << 6)
	out[15] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[16] = (inl >> 0) % (1 << 6)
	out[17] = (inl >> 6) % (1 << 6)
	out[18] = (inl >> 12) % (1 << 6)
	out[19] = (inl >> 18) % (1 << 6)
	out[20] = (inl >> 24) % (1 << 6)
	out[21] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[21] |= (inl % (1 << 4)) << (6 - 4)
	out[22] = (inl >> 4) % (1 << 6)
	out[23] = (inl >> 10) % (1 << 6)
	out[24] = (inl >> 16) % (1 << 6)
	out[25] = (inl >> 22) % (1 << 6)
	out[26] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[26] |= (inl % (1 << 2)) << (6 - 2)
	out[27] = (inl >> 2) % (1 << 6)
	out[28] = (inl >> 8) % (1 << 6)
	out[29] = (inl >> 14) % (1 << 6)
	out[30] = (inl >> 20) % (1 << 6)
	out[31] = (inl >> 26)
}

func unpack7_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 7)
	out[1] = (inl >> 7) % (1 << 7)
	out[2] = (inl >> 14) % (1 << 7)
	out[3] = (inl >> 21) % (1 << 7)
	out[4] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[4] |= (inl % (1 << 3)) << (7 - 3)
	out[5] = (inl >> 3) % (1 << 7)
	out[6] = (inl >> 10) % (1 << 7)
	out[7] = (inl >> 17) % (1 << 7)
	out[8] = (inl >> 24) % (1 << 7)
	out[9] = (inl >> 31)
	binary.Read(in, binary.LittleEndian, &inl)
	out[9] |= (inl % (1 << 6)) << (7 - 6)
	out[10] = (inl >> 6) % (1 << 7)
	out[11] = (inl >> 13) % (1 << 7)
	out[12] = (inl >> 20) % (1 << 7)
	out[13] = (inl >> 27)
	binary.Read(in, binary.LittleEndian, &inl)
	out[13] |= (inl % (1 << 2)) << (7 - 2)
	out[14] = (inl >> 2) % (1 << 7)
	out[15] = (inl >> 9) % (1 << 7)
	out[16] = (inl >> 16) % (1 << 7)
	out[17] = (inl >> 23) % (1 << 7)
	out[18] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[18] |= (inl % (1 << 5)) << (7 - 5)
	out[19] = (inl >> 5) % (1 << 7)
	out[20] = (inl >> 12) % (1 << 7)
	out[21] = (inl >> 19) % (1 << 7)
	out[22] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[22] |= (inl % (1 << 1)) << (7 - 1)
	out[23] = (inl >> 1) % (1 << 7)
	out[24] = (inl >> 8) % (1 << 7)
	out[25] = (inl >> 15) % (1 << 7)
	out[26] = (inl >> 22) % (1 << 7)
	out[27] = (inl >> 29)
	binary.Read(in, binary.LittleEndian, &inl)
	out[27] |= (inl % (1 << 4)) << (7 - 4)
	out[28] = (inl >> 4) % (1 << 7)
	out[29] = (inl >> 11) % (1 << 7)
	out[30] = (inl >> 18) % (1 << 7)
	out[31] = (inl >> 25)
}

func unpack8_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	for i := 0; i < 24; i += 8 {
		out[0+i/8] = (inl >> i) % (1 << 8)
	}
	out[3] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	for i := 0; i < 24; i += 8 {
		out[4+i/8] = (inl >> i) % (1 << 8)
	}
	out[7] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	for i := 0; i < 24; i += 8 {
		out[8+i/8] = (inl >> i) % (1 << 8)
	}
	out[11] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	for i := 0; i < 24; i += 8 {
		out[12+i/8] = (inl >> i) % (1 << 8)
	}
	out[15] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	for i := 0; i < 24; i += 8 {
		out[16+i/8] = (inl >> i) % (1 << 8)
	}
	out[19] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	for i := 0; i < 24; i += 8 {
		out[20+i/8] = (inl >> i) % (1 << 8)
	}
	out[23] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	for i := 0; i < 24; i += 8 {
		out[24+i/8] = (inl >> i) % (1 << 8)
	}
	out[27] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	for i := 0; i < 24; i += 8 {
		out[28+i/8] = (inl >> i) % (1 << 8)
	}
	out[31] = (inl >> 24)
}

func unpack9_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 9)
	out[1] = (inl >> 9) % (1 << 9)
	out[2] = (inl >> 18) % (1 << 9)
	out[3] = (inl >> 27)
	binary.Read(in, binary.LittleEndian, &inl)
	out[3] |= (inl % (1 << 4)) << (9 - 4)
	out[4] = (inl >> 4) % (1 << 9)
	out[5] = (inl >> 13) % (1 << 9)
	out[6] = (inl >> 22) % (1 << 9)
	out[7] = (inl >> 31)
	binary.Read(in, binary.LittleEndian, &inl)
	out[7] |= (inl % (1 << 8)) << (9 - 8)
	out[8] = (inl >> 8) % (1 << 9)
	out[9] = (inl >> 17) % (1 << 9)
	out[10] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[10] |= (inl % (1 << 3)) << (9 - 3)
	out[11] = (inl >> 3) % (1 << 9)
	out[12] = (inl >> 12) % (1 << 9)
	out[13] = (inl >> 21) % (1 << 9)
	out[14] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[14] |= (inl % (1 << 7)) << (9 - 7)
	out[15] = (inl >> 7) % (1 << 9)
	out[16] = (inl >> 16) % (1 << 9)
	out[17] = (inl >> 25)
	binary.Read(in, binary.LittleEndian, &inl)
	out[17] |= (inl % (1 << 2)) << (9 - 2)
	out[18] = (inl >> 2) % (1 << 9)
	out[19] = (inl >> 11) % (1 << 9)
	out[20] = (inl >> 20) % (1 << 9)
	out[21] = (inl >> 29)
	binary.Read(in, binary.LittleEndian, &inl)
	out[21] |= (inl % (1 << 6)) << (9 - 6)
	out[22] = (inl >> 6) % (1 << 9)
	out[23] = (inl >> 15) % (1 << 9)
	out[24] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[24] |= (inl % (1 << 1)) << (9 - 1)
	out[25] = (inl >> 1) % (1 << 9)
	out[26] = (inl >> 10) % (1 << 9)
	out[27] = (inl >> 19) % (1 << 9)
	out[28] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[28] |= (inl % (1 << 5)) << (9 - 5)
	out[29] = (inl >> 5) % (1 << 9)
	out[30] = (inl >> 14) % (1 << 9)
	out[31] = (inl >> 23)
}

func unpack10_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 10)
	out[1] = (inl >> 10) % (1 << 10)
	out[2] = (inl >> 20) % (1 << 10)
	out[3] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[3] |= (inl % (1 << 8)) << (10 - 8)
	out[4] = (inl >> 8) % (1 << 10)
	out[5] = (inl >> 18) % (1 << 10)
	out[6] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[6] |= (inl % (1 << 6)) << (10 - 6)
	out[7] = (inl >> 6) % (1 << 10)
	out[8] = (inl >> 16) % (1 << 10)
	out[9] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[9] |= (inl % (1 << 4)) << (10 - 4)
	out[10] = (inl >> 4) % (1 << 10)
	out[11] = (inl >> 14) % (1 << 10)
	out[12] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[12] |= (inl % (1 << 2)) << (10 - 2)
	out[13] = (inl >> 2) % (1 << 10)
	out[14] = (inl >> 12) % (1 << 10)
	out[15] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[16] = (inl >> 0) % (1 << 10)
	out[17] = (inl >> 10) % (1 << 10)
	out[18] = (inl >> 20) % (1 << 10)
	out[19] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[19] |= (inl % (1 << 8)) << (10 - 8)
	out[20] = (inl >> 8) % (1 << 10)
	out[21] = (inl >> 18) % (1 << 10)
	out[22] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[22] |= (inl % (1 << 6)) << (10 - 6)
	out[23] = (inl >> 6) % (1 << 10)
	out[24] = (inl >> 16) % (1 << 10)
	out[25] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[25] |= (inl % (1 << 4)) << (10 - 4)
	out[26] = (inl >> 4) % (1 << 10)
	out[27] = (inl >> 14) % (1 << 10)
	out[28] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[28] |= (inl % (1 << 2)) << (10 - 2)
	out[29] = (inl >> 2) % (1 << 10)
	out[30] = (inl >> 12) % (1 << 10)
	out[31] = (inl >> 22)
}

func unpack11_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 11)
	out[1] = (inl >> 11) % (1 << 11)
	out[2] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[2] |= (inl % (1 << 1)) << (11 - 1)
	out[3] = (inl >> 1) % (1 << 11)
	out[4] = (inl >> 12) % (1 << 11)
	out[5] = (inl >> 23)
	binary.Read(in, binary.LittleEndian, &inl)
	out[5] |= (inl % (1 << 2)) << (11 - 2)
	out[6] = (inl >> 2) % (1 << 11)
	out[7] = (inl >> 13) % (1 << 11)
	out[8] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[8] |= (inl % (1 << 3)) << (11 - 3)
	out[9] = (inl >> 3) % (1 << 11)
	out[10] = (inl >> 14) % (1 << 11)
	out[11] = (inl >> 25)
	binary.Read(in, binary.LittleEndian, &inl)
	out[11] |= (inl % (1 << 4)) << (11 - 4)
	out[12] = (inl >> 4) % (1 << 11)
	out[13] = (inl >> 15) % (1 << 11)
	out[14] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[14] |= (inl % (1 << 5)) << (11 - 5)
	out[15] = (inl >> 5) % (1 << 11)
	out[16] = (inl >> 16) % (1 << 11)
	out[17] = (inl >> 27)
	binary.Read(in, binary.LittleEndian, &inl)
	out[17] |= (inl % (1 << 6)) << (11 - 6)
	out[18] = (inl >> 6) % (1 << 11)
	out[19] = (inl >> 17) % (1 << 11)
	out[20] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[20] |= (inl % (1 << 7)) << (11 - 7)
	out[21] = (inl >> 7) % (1 << 11)
	out[22] = (inl >> 18) % (1 << 11)
	out[23] = (inl >> 29)
	binary.Read(in, binary.LittleEndian, &inl)
	out[23] |= (inl % (1 << 8)) << (11 - 8)
	out[24] = (inl >> 8) % (1 << 11)
	out[25] = (inl >> 19) % (1 << 11)
	out[26] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[26] |= (inl % (1 << 9)) << (11 - 9)
	out[27] = (inl >> 9) % (1 << 11)
	out[28] = (inl >> 20) % (1 << 11)
	out[29] = (inl >> 31)
	binary.Read(in, binary.LittleEndian, &inl)
	out[29] |= (inl % (1 << 10)) << (11 - 10)
	out[30] = (inl >> 10) % (1 << 11)
	out[31] = (inl >> 21)
}

func unpack12_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 12)
	out[1] = (inl >> 12) % (1 << 12)
	out[2] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[2] |= (inl % (1 << 4)) << (12 - 4)
	out[3] = (inl >> 4) % (1 << 12)
	out[4] = (inl >> 16) % (1 << 12)
	out[5] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[5] |= (inl % (1 << 8)) << (12 - 8)
	out[6] = (inl >> 8) % (1 << 12)
	out[7] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[8] = (inl >> 0) % (1 << 12)
	out[9] = (inl >> 12) % (1 << 12)
	out[10] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[10] |= (inl % (1 << 4)) << (12 - 4)
	out[11] = (inl >> 4) % (1 << 12)
	out[12] = (inl >> 16) % (1 << 12)
	out[13] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[13] |= (inl % (1 << 8)) << (12 - 8)
	out[14] = (inl >> 8) % (1 << 12)
	out[15] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[16] = (inl >> 0) % (1 << 12)
	out[17] = (inl >> 12) % (1 << 12)
	out[18] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[18] |= (inl % (1 << 4)) << (12 - 4)
	out[19] = (inl >> 4) % (1 << 12)
	out[20] = (inl >> 16) % (1 << 12)
	out[21] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[21] |= (inl % (1 << 8)) << (12 - 8)
	out[22] = (inl >> 8) % (1 << 12)
	out[23] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[24] = (inl >> 0) % (1 << 12)
	out[25] = (inl >> 12) % (1 << 12)
	out[26] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[26] |= (inl % (1 << 4)) << (12 - 4)
	out[27] = (inl >> 4) % (1 << 12)
	out[28] = (inl >> 16) % (1 << 12)
	out[29] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[29] |= (inl % (1 << 8)) << (12 - 8)
	out[30] = (inl >> 8) % (1 << 12)
	out[31] = (inl >> 20)
}

func unpack13_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 13)
	out[1] = (inl >> 13) % (1 << 13)
	out[2] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[2] |= (inl % (1 << 7)) << (13 - 7)
	out[3] = (inl >> 7) % (1 << 13)
	out[4] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[4] |= (inl % (1 << 1)) << (13 - 1)
	out[5] = (inl >> 1) % (1 << 13)
	out[6] = (inl >> 14) % (1 << 13)
	out[7] = (inl >> 27)
	binary.Read(in, binary.LittleEndian, &inl)
	out[7] |= (inl % (1 << 8)) << (13 - 8)
	out[8] = (inl >> 8) % (1 << 13)
	out[9] = (inl >> 21)
	binary.Read(in, binary.LittleEndian, &inl)
	out[9] |= (inl % (1 << 2)) << (13 - 2)
	out[10] = (inl >> 2) % (1 << 13)
	out[11] = (inl >> 15) % (1 << 13)
	out[12] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[12] |= (inl % (1 << 9)) << (13 - 9)
	out[13] = (inl >> 9) % (1 << 13)
	out[14] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[14] |= (inl % (1 << 3)) << (13 - 3)
	out[15] = (inl >> 3) % (1 << 13)
	out[16] = (inl >> 16) % (1 << 13)
	out[17] = (inl >> 29)
	binary.Read(in, binary.LittleEndian, &inl)
	out[17] |= (inl % (1 << 10)) << (13 - 10)
	out[18] = (inl >> 10) % (1 << 13)
	out[19] = (inl >> 23)
	binary.Read(in, binary.LittleEndian, &inl)
	out[19] |= (inl % (1 << 4)) << (13 - 4)
	out[20] = (inl >> 4) % (1 << 13)
	out[21] = (inl >> 17) % (1 << 13)
	out[22] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[22] |= (inl % (1 << 11)) << (13 - 11)
	out[23] = (inl >> 11) % (1 << 13)
	out[24] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[24] |= (inl % (1 << 5)) << (13 - 5)
	out[25] = (inl >> 5) % (1 << 13)
	out[26] = (inl >> 18) % (1 << 13)
	out[27] = (inl >> 31)
	binary.Read(in, binary.LittleEndian, &inl)
	out[27] |= (inl % (1 << 12)) << (13 - 12)
	out[28] = (inl >> 12) % (1 << 13)
	out[29] = (inl >> 25)
	binary.Read(in, binary.LittleEndian, &inl)
	out[29] |= (inl % (1 << 6)) << (13 - 6)
	out[30] = (inl >> 6) % (1 << 13)
	out[31] = (inl >> 19)
}

func unpack14_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 14)
	out[1] = (inl >> 14) % (1 << 14)
	out[2] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[2] |= (inl % (1 << 10)) << (14 - 10)
	out[3] = (inl >> 10) % (1 << 14)
	out[4] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[4] |= (inl % (1 << 6)) << (14 - 6)
	out[5] = (inl >> 6) % (1 << 14)
	out[6] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[6] |= (inl % (1 << 2)) << (14 - 2)
	out[7] = (inl >> 2) % (1 << 14)
	out[8] = (inl >> 16) % (1 << 14)
	out[9] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[9] |= (inl % (1 << 12)) << (14 - 12)
	out[10] = (inl >> 12) % (1 << 14)
	out[11] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[11] |= (inl % (1 << 8)) << (14 - 8)
	out[12] = (inl >> 8) % (1 << 14)
	out[13] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[13] |= (inl % (1 << 4)) << (14 - 4)
	out[14] = (inl >> 4) % (1 << 14)
	out[15] = (inl >> 18)
	binary.Read(in, binary.LittleEndian, &inl)
	out[16] = (inl >> 0) % (1 << 14)
	out[17] = (inl >> 14) % (1 << 14)
	out[18] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[18] |= (inl % (1 << 10)) << (14 - 10)
	out[19] = (inl >> 10) % (1 << 14)
	out[20] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[20] |= (inl % (1 << 6)) << (14 - 6)
	out[21] = (inl >> 6) % (1 << 14)
	out[22] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[22] |= (inl % (1 << 2)) << (14 - 2)
	out[23] = (inl >> 2) % (1 << 14)
	out[24] = (inl >> 16) % (1 << 14)
	out[25] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[25] |= (inl % (1 << 12)) << (14 - 12)
	out[26] = (inl >> 12) % (1 << 14)
	out[27] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[27] |= (inl % (1 << 8)) << (14 - 8)
	out[28] = (inl >> 8) % (1 << 14)
	out[29] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[29] |= (inl % (1 << 4)) << (14 - 4)
	out[30] = (inl >> 4) % (1 << 14)
	out[31] = (inl >> 18)
}

func unpack15_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 15)
	out[1] = (inl >> 15) % (1 << 15)
	out[2] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[2] |= (inl % (1 << 13)) << (15 - 13)
	out[3] = (inl >> 13) % (1 << 15)
	out[4] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[4] |= (inl % (1 << 11)) << (15 - 11)
	out[5] = (inl >> 11) % (1 << 15)
	out[6] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[6] |= (inl % (1 << 9)) << (15 - 9)
	out[7] = (inl >> 9) % (1 << 15)
	out[8] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[8] |= (inl % (1 << 7)) << (15 - 7)
	out[9] = (inl >> 7) % (1 << 15)
	out[10] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[10] |= (inl % (1 << 5)) << (15 - 5)
	out[11] = (inl >> 5) % (1 << 15)
	out[12] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[12] |= (inl % (1 << 3)) << (15 - 3)
	out[13] = (inl >> 3) % (1 << 15)
	out[14] = (inl >> 18)
	binary.Read(in, binary.LittleEndian, &inl)
	out[14] |= (inl % (1 << 1)) << (15 - 1)
	out[15] = (inl >> 1) % (1 << 15)
	out[16] = (inl >> 16) % (1 << 15)
	out[17] = (inl >> 31)
	binary.Read(in, binary.LittleEndian, &inl)
	out[17] |= (inl % (1 << 14)) << (15 - 14)
	out[18] = (inl >> 14) % (1 << 15)
	out[19] = (inl >> 29)
	binary.Read(in, binary.LittleEndian, &inl)
	out[19] |= (inl % (1 << 12)) << (15 - 12)
	out[20] = (inl >> 12) % (1 << 15)
	out[21] = (inl >> 27)
	binary.Read(in, binary.LittleEndian, &inl)
	out[21] |= (inl % (1 << 10)) << (15 - 10)
	out[22] = (inl >> 10) % (1 << 15)
	out[23] = (inl >> 25)
	binary.Read(in, binary.LittleEndian, &inl)
	out[23] |= (inl % (1 << 8)) << (15 - 8)
	out[24] = (inl >> 8) % (1 << 15)
	out[25] = (inl >> 23)
	binary.Read(in, binary.LittleEndian, &inl)
	out[25] |= (inl % (1 << 6)) << (15 - 6)
	out[26] = (inl >> 6) % (1 << 15)
	out[27] = (inl >> 21)
	binary.Read(in, binary.LittleEndian, &inl)
	out[27] |= (inl % (1 << 4)) << (15 - 4)
	out[28] = (inl >> 4) % (1 << 15)
	out[29] = (inl >> 19)
	binary.Read(in, binary.LittleEndian, &inl)
	out[29] |= (inl % (1 << 2)) << (15 - 2)
	out[30] = (inl >> 2) % (1 << 15)
	out[31] = (inl >> 17)
}

func unpack16_32(in io.Reader, out []uint32) {
	var inl uint32
	for i := 0; i < 16; i++ {
		binary.Read(in, binary.LittleEndian, &inl)
		out[i*2] = (inl >> 0) % (1 << 16)
		out[(i*2)+1] = (inl >> 16)
	}
}

func unpack17_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 17)
	out[1] = (inl >> 17)
	binary.Read(in, binary.LittleEndian, &inl)
	out[1] |= (inl % (1 << 2)) << (17 - 2)
	out[2] = (inl >> 2) % (1 << 17)
	out[3] = (inl >> 19)
	binary.Read(in, binary.LittleEndian, &inl)
	out[3] |= (inl % (1 << 4)) << (17 - 4)
	out[4] = (inl >> 4) % (1 << 17)
	out[5] = (inl >> 21)
	binary.Read(in, binary.LittleEndian, &inl)
	out[5] |= (inl % (1 << 6)) << (17 - 6)
	out[6] = (inl >> 6) % (1 << 17)
	out[7] = (inl >> 23)
	binary.Read(in, binary.LittleEndian, &inl)
	out[7] |= (inl % (1 << 8)) << (17 - 8)
	out[8] = (inl >> 8) % (1 << 17)
	out[9] = (inl >> 25)
	binary.Read(in, binary.LittleEndian, &inl)
	out[9] |= (inl % (1 << 10)) << (17 - 10)
	out[10] = (inl >> 10) % (1 << 17)
	out[11] = (inl >> 27)
	binary.Read(in, binary.LittleEndian, &inl)
	out[11] |= (inl % (1 << 12)) << (17 - 12)
	out[12] = (inl >> 12) % (1 << 17)
	out[13] = (inl >> 29)
	binary.Read(in, binary.LittleEndian, &inl)
	out[13] |= (inl % (1 << 14)) << (17 - 14)
	out[14] = (inl >> 14) % (1 << 17)
	out[15] = (inl >> 31)
	binary.Read(in, binary.LittleEndian, &inl)
	out[15] |= (inl % (1 << 16)) << (17 - 16)
	out[16] = (inl >> 16)
	binary.Read(in, binary.LittleEndian, &inl)
	out[16] |= (inl % (1 << 1)) << (17 - 1)
	out[17] = (inl >> 1) % (1 << 17)
	out[18] = (inl >> 18)
	binary.Read(in, binary.LittleEndian, &inl)
	out[18] |= (inl % (1 << 3)) << (17 - 3)
	out[19] = (inl >> 3) % (1 << 17)
	out[20] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[20] |= (inl % (1 << 5)) << (17 - 5)
	out[21] = (inl >> 5) % (1 << 17)
	out[22] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[22] |= (inl % (1 << 7)) << (17 - 7)
	out[23] = (inl >> 7) % (1 << 17)
	out[24] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[24] |= (inl % (1 << 9)) << (17 - 9)
	out[25] = (inl >> 9) % (1 << 17)
	out[26] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[26] |= (inl % (1 << 11)) << (17 - 11)
	out[27] = (inl >> 11) % (1 << 17)
	out[28] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[28] |= (inl % (1 << 13)) << (17 - 13)
	out[29] = (inl >> 13) % (1 << 17)
	out[30] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[30] |= (inl % (1 << 15)) << (17 - 15)
	out[31] = (inl >> 15)
}

func unpack18_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 18)
	out[1] = (inl >> 18)
	binary.Read(in, binary.LittleEndian, &inl)
	out[1] |= (inl % (1 << 4)) << (18 - 4)
	out[2] = (inl >> 4) % (1 << 18)
	out[3] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[3] |= (inl % (1 << 8)) << (18 - 8)
	out[4] = (inl >> 8) % (1 << 18)
	out[5] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[5] |= (inl % (1 << 12)) << (18 - 12)
	out[6] = (inl >> 12) % (1 << 18)
	out[7] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[7] |= (inl % (1 << 16)) << (18 - 16)
	out[8] = (inl >> 16)
	binary.Read(in, binary.LittleEndian, &inl)
	out[8] |= (inl % (1 << 2)) << (18 - 2)
	out[9] = (inl >> 2) % (1 << 18)
	out[10] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[10] |= (inl % (1 << 6)) << (18 - 6)
	out[11] = (inl >> 6) % (1 << 18)
	out[12] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[12] |= (inl % (1 << 10)) << (18 - 10)
	out[13] = (inl >> 10) % (1 << 18)
	out[14] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[14] |= (inl % (1 << 14)) << (18 - 14)
	out[15] = (inl >> 14)
	binary.Read(in, binary.LittleEndian, &inl)
	out[16] = (inl >> 0) % (1 << 18)
	out[17] = (inl >> 18)
	binary.Read(in, binary.LittleEndian, &inl)
	out[17] |= (inl % (1 << 4)) << (18 - 4)
	out[18] = (inl >> 4) % (1 << 18)
	out[19] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[19] |= (inl % (1 << 8)) << (18 - 8)
	out[20] = (inl >> 8) % (1 << 18)
	out[21] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[21] |= (inl % (1 << 12)) << (18 - 12)
	out[22] = (inl >> 12) % (1 << 18)
	out[23] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[23] |= (inl % (1 << 16)) << (18 - 16)
	out[24] = (inl >> 16)
	binary.Read(in, binary.LittleEndian, &inl)
	out[24] |= (inl % (1 << 2)) << (18 - 2)
	out[25] = (inl >> 2) % (1 << 18)
	out[26] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[26] |= (inl % (1 << 6)) << (18 - 6)
	out[27] = (inl >> 6) % (1 << 18)
	out[28] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[28] |= (inl % (1 << 10)) << (18 - 10)
	out[29] = (inl >> 10) % (1 << 18)
	out[30] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[30] |= (inl % (1 << 14)) << (18 - 14)
	out[31] = (inl >> 14)
}

func unpack19_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 19)
	out[1] = (inl >> 19)
	binary.Read(in, binary.LittleEndian, &inl)
	out[1] |= (inl % (1 << 6)) << (19 - 6)
	out[2] = (inl >> 6) % (1 << 19)
	out[3] = (inl >> 25)
	binary.Read(in, binary.LittleEndian, &inl)
	out[3] |= (inl % (1 << 12)) << (19 - 12)
	out[4] = (inl >> 12) % (1 << 19)
	out[5] = (inl >> 31)
	binary.Read(in, binary.LittleEndian, &inl)
	out[5] |= (inl % (1 << 18)) << (19 - 18)
	out[6] = (inl >> 18)
	binary.Read(in, binary.LittleEndian, &inl)
	out[6] |= (inl % (1 << 5)) << (19 - 5)
	out[7] = (inl >> 5) % (1 << 19)
	out[8] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[8] |= (inl % (1 << 11)) << (19 - 11)
	out[9] = (inl >> 11) % (1 << 19)
	out[10] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[10] |= (inl % (1 << 17)) << (19 - 17)
	out[11] = (inl >> 17)
	binary.Read(in, binary.LittleEndian, &inl)
	out[11] |= (inl % (1 << 4)) << (19 - 4)
	out[12] = (inl >> 4) % (1 << 19)
	out[13] = (inl >> 23)
	binary.Read(in, binary.LittleEndian, &inl)
	out[13] |= (inl % (1 << 10)) << (19 - 10)
	out[14] = (inl >> 10) % (1 << 19)
	out[15] = (inl >> 29)
	binary.Read(in, binary.LittleEndian, &inl)
	out[15] |= (inl % (1 << 16)) << (19 - 16)
	out[16] = (inl >> 16)
	binary.Read(in, binary.LittleEndian, &inl)
	out[16] |= (inl % (1 << 3)) << (19 - 3)
	out[17] = (inl >> 3) % (1 << 19)
	out[18] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[18] |= (inl % (1 << 9)) << (19 - 9)
	out[19] = (inl >> 9) % (1 << 19)
	out[20] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[20] |= (inl % (1 << 15)) << (19 - 15)
	out[21] = (inl >> 15)
	binary.Read(in, binary.LittleEndian, &inl)
	out[21] |= (inl % (1 << 2)) << (19 - 2)
	out[22] = (inl >> 2) % (1 << 19)
	out[23] = (inl >> 21)
	binary.Read(in, binary.LittleEndian, &inl)
	out[23] |= (inl % (1 << 8)) << (19 - 8)
	out[24] = (inl >> 8) % (1 << 19)
	out[25] = (inl >> 27)
	binary.Read(in, binary.LittleEndian, &inl)
	out[25] |= (inl % (1 << 14)) << (19 - 14)
	out[26] = (inl >> 14)
	binary.Read(in, binary.LittleEndian, &inl)
	out[26] |= (inl % (1 << 1)) << (19 - 1)
	out[27] = (inl >> 1) % (1 << 19)
	out[28] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[28] |= (inl % (1 << 7)) << (19 - 7)
	out[29] = (inl >> 7) % (1 << 19)
	out[30] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[30] |= (inl % (1 << 13)) << (19 - 13)
	out[31] = (inl >> 13)
}

func unpack20_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 20)
	out[1] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[1] |= (inl % (1 << 8)) << (20 - 8)
	out[2] = (inl >> 8) % (1 << 20)
	out[3] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[3] |= (inl % (1 << 16)) << (20 - 16)
	out[4] = (inl >> 16)
	binary.Read(in, binary.LittleEndian, &inl)
	out[4] |= (inl % (1 << 4)) << (20 - 4)
	out[5] = (inl >> 4) % (1 << 20)
	out[6] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[6] |= (inl % (1 << 12)) << (20 - 12)
	out[7] = (inl >> 12)
	binary.Read(in, binary.LittleEndian, &inl)
	out[8] = (inl >> 0) % (1 << 20)
	out[9] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[9] |= (inl % (1 << 8)) << (20 - 8)
	out[10] = (inl >> 8) % (1 << 20)
	out[11] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[11] |= (inl % (1 << 16)) << (20 - 16)
	out[12] = (inl >> 16)
	binary.Read(in, binary.LittleEndian, &inl)
	out[12] |= (inl % (1 << 4)) << (20 - 4)
	out[13] = (inl >> 4) % (1 << 20)
	out[14] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[14] |= (inl % (1 << 12)) << (20 - 12)
	out[15] = (inl >> 12)
	binary.Read(in, binary.LittleEndian, &inl)
	out[16] = (inl >> 0) % (1 << 20)
	out[17] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[17] |= (inl % (1 << 8)) << (20 - 8)
	out[18] = (inl >> 8) % (1 << 20)
	out[19] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[19] |= (inl % (1 << 16)) << (20 - 16)
	out[20] = (inl >> 16)
	binary.Read(in, binary.LittleEndian, &inl)
	out[20] |= (inl % (1 << 4)) << (20 - 4)
	out[21] = (inl >> 4) % (1 << 20)
	out[22] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[22] |= (inl % (1 << 12)) << (20 - 12)
	out[23] = (inl >> 12)
	binary.Read(in, binary.LittleEndian, &inl)
	out[24] = (inl >> 0) % (1 << 20)
	out[25] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[25] |= (inl % (1 << 8)) << (20 - 8)
	out[26] = (inl >> 8) % (1 << 20)
	out[27] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[27] |= (inl % (1 << 16)) << (20 - 16)
	out[28] = (inl >> 16)
	binary.Read(in, binary.LittleEndian, &inl)
	out[28] |= (inl % (1 << 4)) << (20 - 4)
	out[29] = (inl >> 4) % (1 << 20)
	out[30] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[30] |= (inl % (1 << 12)) << (20 - 12)
	out[31] = (inl >> 12)
}

func unpack21_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 21)
	out[1] = (inl >> 21)
	binary.Read(in, binary.LittleEndian, &inl)
	out[1] |= (inl % (1 << 10)) << (21 - 10)
	out[2] = (inl >> 10) % (1 << 21)
	out[3] = (inl >> 31)
	binary.Read(in, binary.LittleEndian, &inl)
	out[3] |= (inl % (1 << 20)) << (21 - 20)
	out[4] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[4] |= (inl % (1 << 9)) << (21 - 9)
	out[5] = (inl >> 9) % (1 << 21)
	out[6] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[6] |= (inl % (1 << 19)) << (21 - 19)
	out[7] = (inl >> 19)
	binary.Read(in, binary.LittleEndian, &inl)
	out[7] |= (inl % (1 << 8)) << (21 - 8)
	out[8] = (inl >> 8) % (1 << 21)
	out[9] = (inl >> 29)
	binary.Read(in, binary.LittleEndian, &inl)
	out[9] |= (inl % (1 << 18)) << (21 - 18)
	out[10] = (inl >> 18)
	binary.Read(in, binary.LittleEndian, &inl)
	out[10] |= (inl % (1 << 7)) << (21 - 7)
	out[11] = (inl >> 7) % (1 << 21)
	out[12] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[12] |= (inl % (1 << 17)) << (21 - 17)
	out[13] = (inl >> 17)
	binary.Read(in, binary.LittleEndian, &inl)
	out[13] |= (inl % (1 << 6)) << (21 - 6)
	out[14] = (inl >> 6) % (1 << 21)
	out[15] = (inl >> 27)
	binary.Read(in, binary.LittleEndian, &inl)
	out[15] |= (inl % (1 << 16)) << (21 - 16)
	out[16] = (inl >> 16)
	binary.Read(in, binary.LittleEndian, &inl)
	out[16] |= (inl % (1 << 5)) << (21 - 5)
	out[17] = (inl >> 5) % (1 << 21)
	out[18] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[18] |= (inl % (1 << 15)) << (21 - 15)
	out[19] = (inl >> 15)
	binary.Read(in, binary.LittleEndian, &inl)
	out[19] |= (inl % (1 << 4)) << (21 - 4)
	out[20] = (inl >> 4) % (1 << 21)
	out[21] = (inl >> 25)
	binary.Read(in, binary.LittleEndian, &inl)
	out[21] |= (inl % (1 << 14)) << (21 - 14)
	out[22] = (inl >> 14)
	binary.Read(in, binary.LittleEndian, &inl)
	out[22] |= (inl % (1 << 3)) << (21 - 3)
	out[23] = (inl >> 3) % (1 << 21)
	out[24] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[24] |= (inl % (1 << 13)) << (21 - 13)
	out[25] = (inl >> 13)
	binary.Read(in, binary.LittleEndian, &inl)
	out[25] |= (inl % (1 << 2)) << (21 - 2)
	out[26] = (inl >> 2) % (1 << 21)
	out[27] = (inl >> 23)
	binary.Read(in, binary.LittleEndian, &inl)
	out[27] |= (inl % (1 << 12)) << (21 - 12)
	out[28] = (inl >> 12)
	binary.Read(in, binary.LittleEndian, &inl)
	out[28] |= (inl % (1 << 1)) << (21 - 1)
	out[29] = (inl >> 1) % (1 << 21)
	out[30] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[30] |= (inl % (1 << 11)) << (21 - 11)
	out[31] = (inl >> 11)
}

func unpack22_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 22)
	out[1] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[1] |= (inl % (1 << 12)) << (22 - 12)
	out[2] = (inl >> 12)
	binary.Read(in, binary.LittleEndian, &inl)
	out[2] |= (inl % (1 << 2)) << (22 - 2)
	out[3] = (inl >> 2) % (1 << 22)
	out[4] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[4] |= (inl % (1 << 14)) << (22 - 14)
	out[5] = (inl >> 14)
	binary.Read(in, binary.LittleEndian, &inl)
	out[5] |= (inl % (1 << 4)) << (22 - 4)
	out[6] = (inl >> 4) % (1 << 22)
	out[7] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[7] |= (inl % (1 << 16)) << (22 - 16)
	out[8] = (inl >> 16)
	binary.Read(in, binary.LittleEndian, &inl)
	out[8] |= (inl % (1 << 6)) << (22 - 6)
	out[9] = (inl >> 6) % (1 << 22)
	out[10] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[10] |= (inl % (1 << 18)) << (22 - 18)
	out[11] = (inl >> 18)
	binary.Read(in, binary.LittleEndian, &inl)
	out[11] |= (inl % (1 << 8)) << (22 - 8)
	out[12] = (inl >> 8) % (1 << 22)
	out[13] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[13] |= (inl % (1 << 20)) << (22 - 20)
	out[14] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[14] |= (inl % (1 << 10)) << (22 - 10)
	out[15] = (inl >> 10)
	binary.Read(in, binary.LittleEndian, &inl)
	out[16] = (inl >> 0) % (1 << 22)
	out[17] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[17] |= (inl % (1 << 12)) << (22 - 12)
	out[18] = (inl >> 12)
	binary.Read(in, binary.LittleEndian, &inl)
	out[18] |= (inl % (1 << 2)) << (22 - 2)
	out[19] = (inl >> 2) % (1 << 22)
	out[20] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[20] |= (inl % (1 << 14)) << (22 - 14)
	out[21] = (inl >> 14)
	binary.Read(in, binary.LittleEndian, &inl)
	out[21] |= (inl % (1 << 4)) << (22 - 4)
	out[22] = (inl >> 4) % (1 << 22)
	out[23] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[23] |= (inl % (1 << 16)) << (22 - 16)
	out[24] = (inl >> 16)
	binary.Read(in, binary.LittleEndian, &inl)
	out[24] |= (inl % (1 << 6)) << (22 - 6)
	out[25] = (inl >> 6) % (1 << 22)
	out[26] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[26] |= (inl % (1 << 18)) << (22 - 18)
	out[27] = (inl >> 18)
	binary.Read(in, binary.LittleEndian, &inl)
	out[27] |= (inl % (1 << 8)) << (22 - 8)
	out[28] = (inl >> 8) % (1 << 22)
	out[29] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[29] |= (inl % (1 << 20)) << (22 - 20)
	out[30] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[30] |= (inl % (1 << 10)) << (22 - 10)
	out[31] = (inl >> 10)
}

func unpack23_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 23)
	out[1] = (inl >> 23)
	binary.Read(in, binary.LittleEndian, &inl)
	out[1] |= (inl % (1 << 14)) << (23 - 14)
	out[2] = (inl >> 14)
	binary.Read(in, binary.LittleEndian, &inl)
	out[2] |= (inl % (1 << 5)) << (23 - 5)
	out[3] = (inl >> 5) % (1 << 23)
	out[4] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[4] |= (inl % (1 << 19)) << (23 - 19)
	out[5] = (inl >> 19)
	binary.Read(in, binary.LittleEndian, &inl)
	out[5] |= (inl % (1 << 10)) << (23 - 10)
	out[6] = (inl >> 10)
	binary.Read(in, binary.LittleEndian, &inl)
	out[6] |= (inl % (1 << 1)) << (23 - 1)
	out[7] = (inl >> 1) % (1 << 23)
	out[8] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[8] |= (inl % (1 << 15)) << (23 - 15)
	out[9] = (inl >> 15)
	binary.Read(in, binary.LittleEndian, &inl)
	out[9] |= (inl % (1 << 6)) << (23 - 6)
	out[10] = (inl >> 6) % (1 << 23)
	out[11] = (inl >> 29)
	binary.Read(in, binary.LittleEndian, &inl)
	out[11] |= (inl % (1 << 20)) << (23 - 20)
	out[12] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[12] |= (inl % (1 << 11)) << (23 - 11)
	out[13] = (inl >> 11)
	binary.Read(in, binary.LittleEndian, &inl)
	out[13] |= (inl % (1 << 2)) << (23 - 2)
	out[14] = (inl >> 2) % (1 << 23)
	out[15] = (inl >> 25)
	binary.Read(in, binary.LittleEndian, &inl)
	out[15] |= (inl % (1 << 16)) << (23 - 16)
	out[16] = (inl >> 16)
	binary.Read(in, binary.LittleEndian, &inl)
	out[16] |= (inl % (1 << 7)) << (23 - 7)
	out[17] = (inl >> 7) % (1 << 23)
	out[18] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[18] |= (inl % (1 << 21)) << (23 - 21)
	out[19] = (inl >> 21)
	binary.Read(in, binary.LittleEndian, &inl)
	out[19] |= (inl % (1 << 12)) << (23 - 12)
	out[20] = (inl >> 12)
	binary.Read(in, binary.LittleEndian, &inl)
	out[20] |= (inl % (1 << 3)) << (23 - 3)
	out[21] = (inl >> 3) % (1 << 23)
	out[22] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[22] |= (inl % (1 << 17)) << (23 - 17)
	out[23] = (inl >> 17)
	binary.Read(in, binary.LittleEndian, &inl)
	out[23] |= (inl % (1 << 8)) << (23 - 8)
	out[24] = (inl >> 8) % (1 << 23)
	out[25] = (inl >> 31)
	binary.Read(in, binary.LittleEndian, &inl)
	out[25] |= (inl % (1 << 22)) << (23 - 22)
	out[26] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[26] |= (inl % (1 << 13)) << (23 - 13)
	out[27] = (inl >> 13)
	binary.Read(in, binary.LittleEndian, &inl)
	out[27] |= (inl % (1 << 4)) << (23 - 4)
	out[28] = (inl >> 4) % (1 << 23)
	out[29] = (inl >> 27)
	binary.Read(in, binary.LittleEndian, &inl)
	out[29] |= (inl % (1 << 18)) << (23 - 18)
	out[30] = (inl >> 18)
	binary.Read(in, binary.LittleEndian, &inl)
	out[30] |= (inl % (1 << 9)) << (23 - 9)
	out[31] = (inl >> 9)
}

func unpack24_32(in io.Reader, out []uint32) {
	var inl uint32
	for i := 0; i < 8; i++ {
		base := i * 4

		binary.Read(in, binary.LittleEndian, &inl)
		out[base] = (inl >> 0) % (1 << 24)
		out[base+1] = (inl >> 24)
		binary.Read(in, binary.LittleEndian, &inl)
		out[base+1] |= (inl % (1 << 16)) << (24 - 16)
		out[base+2] = (inl >> 16)
		binary.Read(in, binary.LittleEndian, &inl)
		out[base+2] |= (inl % (1 << 8)) << (24 - 8)
		out[base+3] = (inl >> 8)
	}
}

func unpack25_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 25)
	out[1] = (inl >> 25)
	binary.Read(in, binary.LittleEndian, &inl)
	out[1] |= (inl % (1 << 18)) << (25 - 18)
	out[2] = (inl >> 18)
	binary.Read(in, binary.LittleEndian, &inl)
	out[2] |= (inl % (1 << 11)) << (25 - 11)
	out[3] = (inl >> 11)
	binary.Read(in, binary.LittleEndian, &inl)
	out[3] |= (inl % (1 << 4)) << (25 - 4)
	out[4] = (inl >> 4) % (1 << 25)
	out[5] = (inl >> 29)
	binary.Read(in, binary.LittleEndian, &inl)
	out[5] |= (inl % (1 << 22)) << (25 - 22)
	out[6] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[6] |= (inl % (1 << 15)) << (25 - 15)
	out[7] = (inl >> 15)
	binary.Read(in, binary.LittleEndian, &inl)
	out[7] |= (inl % (1 << 8)) << (25 - 8)
	out[8] = (inl >> 8)
	binary.Read(in, binary.LittleEndian, &inl)
	out[8] |= (inl % (1 << 1)) << (25 - 1)
	out[9] = (inl >> 1) % (1 << 25)
	out[10] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[10] |= (inl % (1 << 19)) << (25 - 19)
	out[11] = (inl >> 19)
	binary.Read(in, binary.LittleEndian, &inl)
	out[11] |= (inl % (1 << 12)) << (25 - 12)
	out[12] = (inl >> 12)
	binary.Read(in, binary.LittleEndian, &inl)
	out[12] |= (inl % (1 << 5)) << (25 - 5)
	out[13] = (inl >> 5) % (1 << 25)
	out[14] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[14] |= (inl % (1 << 23)) << (25 - 23)
	out[15] = (inl >> 23)
	binary.Read(in, binary.LittleEndian, &inl)
	out[15] |= (inl % (1 << 16)) << (25 - 16)
	out[16] = (inl >> 16)
	binary.Read(in, binary.LittleEndian, &inl)
	out[16] |= (inl % (1 << 9)) << (25 - 9)
	out[17] = (inl >> 9)
	binary.Read(in, binary.LittleEndian, &inl)
	out[17] |= (inl % (1 << 2)) << (25 - 2)
	out[18] = (inl >> 2) % (1 << 25)
	out[19] = (inl >> 27)
	binary.Read(in, binary.LittleEndian, &inl)
	out[19] |= (inl % (1 << 20)) << (25 - 20)
	out[20] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[20] |= (inl % (1 << 13)) << (25 - 13)
	out[21] = (inl >> 13)
	binary.Read(in, binary.LittleEndian, &inl)
	out[21] |= (inl % (1 << 6)) << (25 - 6)
	out[22] = (inl >> 6) % (1 << 25)
	out[23] = (inl >> 31)
	binary.Read(in, binary.LittleEndian, &inl)
	out[23] |= (inl % (1 << 24)) << (25 - 24)
	out[24] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[24] |= (inl % (1 << 17)) << (25 - 17)
	out[25] = (inl >> 17)
	binary.Read(in, binary.LittleEndian, &inl)
	out[25] |= (inl % (1 << 10)) << (25 - 10)
	out[26] = (inl >> 10)
	binary.Read(in, binary.LittleEndian, &inl)
	out[26] |= (inl % (1 << 3)) << (25 - 3)
	out[27] = (inl >> 3) % (1 << 25)
	out[28] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[28] |= (inl % (1 << 21)) << (25 - 21)
	out[29] = (inl >> 21)
	binary.Read(in, binary.LittleEndian, &inl)
	out[29] |= (inl % (1 << 14)) << (25 - 14)
	out[30] = (inl >> 14)
	binary.Read(in, binary.LittleEndian, &inl)
	out[30] |= (inl % (1 << 7)) << (25 - 7)
	out[31] = (inl >> 7)
}

func unpack26_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 26)
	out[1] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[1] |= (inl % (1 << 20)) << (26 - 20)
	out[2] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[2] |= (inl % (1 << 14)) << (26 - 14)
	out[3] = (inl >> 14)
	binary.Read(in, binary.LittleEndian, &inl)
	out[3] |= (inl % (1 << 8)) << (26 - 8)
	out[4] = (inl >> 8)
	binary.Read(in, binary.LittleEndian, &inl)
	out[4] |= (inl % (1 << 2)) << (26 - 2)
	out[5] = (inl >> 2) % (1 << 26)
	out[6] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[6] |= (inl % (1 << 22)) << (26 - 22)
	out[7] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[7] |= (inl % (1 << 16)) << (26 - 16)
	out[8] = (inl >> 16)
	binary.Read(in, binary.LittleEndian, &inl)
	out[8] |= (inl % (1 << 10)) << (26 - 10)
	out[9] = (inl >> 10)
	binary.Read(in, binary.LittleEndian, &inl)
	out[9] |= (inl % (1 << 4)) << (26 - 4)
	out[10] = (inl >> 4) % (1 << 26)
	out[11] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[11] |= (inl % (1 << 24)) << (26 - 24)
	out[12] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[12] |= (inl % (1 << 18)) << (26 - 18)
	out[13] = (inl >> 18)
	binary.Read(in, binary.LittleEndian, &inl)
	out[13] |= (inl % (1 << 12)) << (26 - 12)
	out[14] = (inl >> 12)
	binary.Read(in, binary.LittleEndian, &inl)
	out[14] |= (inl % (1 << 6)) << (26 - 6)
	out[15] = (inl >> 6)
	binary.Read(in, binary.LittleEndian, &inl)
	out[16] = (inl >> 0) % (1 << 26)
	out[17] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[17] |= (inl % (1 << 20)) << (26 - 20)
	out[18] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[18] |= (inl % (1 << 14)) << (26 - 14)
	out[19] = (inl >> 14)
	binary.Read(in, binary.LittleEndian, &inl)
	out[19] |= (inl % (1 << 8)) << (26 - 8)
	out[20] = (inl >> 8)
	binary.Read(in, binary.LittleEndian, &inl)
	out[20] |= (inl % (1 << 2)) << (26 - 2)
	out[21] = (inl >> 2) % (1 << 26)
	out[22] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[22] |= (inl % (1 << 22)) << (26 - 22)
	out[23] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[23] |= (inl % (1 << 16)) << (26 - 16)
	out[24] = (inl >> 16)
	binary.Read(in, binary.LittleEndian, &inl)
	out[24] |= (inl % (1 << 10)) << (26 - 10)
	out[25] = (inl >> 10)
	binary.Read(in, binary.LittleEndian, &inl)
	out[25] |= (inl % (1 << 4)) << (26 - 4)
	out[26] = (inl >> 4) % (1 << 26)
	out[27] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[27] |= (inl % (1 << 24)) << (26 - 24)
	out[28] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[28] |= (inl % (1 << 18)) << (26 - 18)
	out[29] = (inl >> 18)
	binary.Read(in, binary.LittleEndian, &inl)
	out[29] |= (inl % (1 << 12)) << (26 - 12)
	out[30] = (inl >> 12)
	binary.Read(in, binary.LittleEndian, &inl)
	out[30] |= (inl % (1 << 6)) << (26 - 6)
	out[31] = (inl >> 6)
}

func unpack27_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 27)
	out[1] = (inl >> 27)
	binary.Read(in, binary.LittleEndian, &inl)
	out[1] |= (inl % (1 << 22)) << (27 - 22)
	out[2] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[2] |= (inl % (1 << 17)) << (27 - 17)
	out[3] = (inl >> 17)
	binary.Read(in, binary.LittleEndian, &inl)
	out[3] |= (inl % (1 << 12)) << (27 - 12)
	out[4] = (inl >> 12)
	binary.Read(in, binary.LittleEndian, &inl)
	out[4] |= (inl % (1 << 7)) << (27 - 7)
	out[5] = (inl >> 7)
	binary.Read(in, binary.LittleEndian, &inl)
	out[5] |= (inl % (1 << 2)) << (27 - 2)
	out[6] = (inl >> 2) % (1 << 27)
	out[7] = (inl >> 29)
	binary.Read(in, binary.LittleEndian, &inl)
	out[7] |= (inl % (1 << 24)) << (27 - 24)
	out[8] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[8] |= (inl % (1 << 19)) << (27 - 19)
	out[9] = (inl >> 19)
	binary.Read(in, binary.LittleEndian, &inl)
	out[9] |= (inl % (1 << 14)) << (27 - 14)
	out[10] = (inl >> 14)
	binary.Read(in, binary.LittleEndian, &inl)
	out[10] |= (inl % (1 << 9)) << (27 - 9)
	out[11] = (inl >> 9)
	binary.Read(in, binary.LittleEndian, &inl)
	out[11] |= (inl % (1 << 4)) << (27 - 4)
	out[12] = (inl >> 4) % (1 << 27)
	out[13] = (inl >> 31)
	binary.Read(in, binary.LittleEndian, &inl)
	out[13] |= (inl % (1 << 26)) << (27 - 26)
	out[14] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[14] |= (inl % (1 << 21)) << (27 - 21)
	out[15] = (inl >> 21)
	binary.Read(in, binary.LittleEndian, &inl)
	out[15] |= (inl % (1 << 16)) << (27 - 16)
	out[16] = (inl >> 16)
	binary.Read(in, binary.LittleEndian, &inl)
	out[16] |= (inl % (1 << 11)) << (27 - 11)
	out[17] = (inl >> 11)
	binary.Read(in, binary.LittleEndian, &inl)
	out[17] |= (inl % (1 << 6)) << (27 - 6)
	out[18] = (inl >> 6)
	binary.Read(in, binary.LittleEndian, &inl)
	out[18] |= (inl % (1 << 1)) << (27 - 1)
	out[19] = (inl >> 1) % (1 << 27)
	out[20] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[20] |= (inl % (1 << 23)) << (27 - 23)
	out[21] = (inl >> 23)
	binary.Read(in, binary.LittleEndian, &inl)
	out[21] |= (inl % (1 << 18)) << (27 - 18)
	out[22] = (inl >> 18)
	binary.Read(in, binary.LittleEndian, &inl)
	out[22] |= (inl % (1 << 13)) << (27 - 13)
	out[23] = (inl >> 13)
	binary.Read(in, binary.LittleEndian, &inl)
	out[23] |= (inl % (1 << 8)) << (27 - 8)
	out[24] = (inl >> 8)
	binary.Read(in, binary.LittleEndian, &inl)
	out[24] |= (inl % (1 << 3)) << (27 - 3)
	out[25] = (inl >> 3) % (1 << 27)
	out[26] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[26] |= (inl % (1 << 25)) << (27 - 25)
	out[27] = (inl >> 25)
	binary.Read(in, binary.LittleEndian, &inl)
	out[27] |= (inl % (1 << 20)) << (27 - 20)
	out[28] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[28] |= (inl % (1 << 15)) << (27 - 15)
	out[29] = (inl >> 15)
	binary.Read(in, binary.LittleEndian, &inl)
	out[29] |= (inl % (1 << 10)) << (27 - 10)
	out[30] = (inl >> 10)
	binary.Read(in, binary.LittleEndian, &inl)
	out[30] |= (inl % (1 << 5)) << (27 - 5)
	out[31] = (inl >> 5)
}

func unpack28_32(in io.Reader, out []uint32) {
	var inl uint32
	for i := 0; i < 4; i++ {
		base := i * 8

		binary.Read(in, binary.LittleEndian, &inl)
		out[base] = (inl >> 0) % (1 << 28)
		out[base+1] = (inl >> 28)
		binary.Read(in, binary.LittleEndian, &inl)
		out[base+1] |= (inl % (1 << 24)) << (28 - 24)
		out[base+2] = (inl >> 24)
		binary.Read(in, binary.LittleEndian, &inl)
		out[base+2] |= (inl % (1 << 20)) << (28 - 20)
		out[base+3] = (inl >> 20)
		binary.Read(in, binary.LittleEndian, &inl)
		out[base+3] |= (inl % (1 << 16)) << (28 - 16)
		out[base+4] = (inl >> 16)
		binary.Read(in, binary.LittleEndian, &inl)
		out[base+4] |= (inl % (1 << 12)) << (28 - 12)
		out[base+5] = (inl >> 12)
		binary.Read(in, binary.LittleEndian, &inl)
		out[base+5] |= (inl % (1 << 8)) << (28 - 8)
		out[base+6] = (inl >> 8)
		binary.Read(in, binary.LittleEndian, &inl)
		out[base+6] |= (inl % (1 << 4)) << (28 - 4)
		out[base+7] = (inl >> 4)
	}
}

func unpack29_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 29)
	out[1] = (inl >> 29)
	binary.Read(in, binary.LittleEndian, &inl)
	out[1] |= (inl % (1 << 26)) << (29 - 26)
	out[2] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[2] |= (inl % (1 << 23)) << (29 - 23)
	out[3] = (inl >> 23)
	binary.Read(in, binary.LittleEndian, &inl)
	out[3] |= (inl % (1 << 20)) << (29 - 20)
	out[4] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[4] |= (inl % (1 << 17)) << (29 - 17)
	out[5] = (inl >> 17)
	binary.Read(in, binary.LittleEndian, &inl)
	out[5] |= (inl % (1 << 14)) << (29 - 14)
	out[6] = (inl >> 14)
	binary.Read(in, binary.LittleEndian, &inl)
	out[6] |= (inl % (1 << 11)) << (29 - 11)
	out[7] = (inl >> 11)
	binary.Read(in, binary.LittleEndian, &inl)
	out[7] |= (inl % (1 << 8)) << (29 - 8)
	out[8] = (inl >> 8)
	binary.Read(in, binary.LittleEndian, &inl)
	out[8] |= (inl % (1 << 5)) << (29 - 5)
	out[9] = (inl >> 5)
	binary.Read(in, binary.LittleEndian, &inl)
	out[9] |= (inl % (1 << 2)) << (29 - 2)
	out[10] = (inl >> 2) % (1 << 29)
	out[11] = (inl >> 31)
	binary.Read(in, binary.LittleEndian, &inl)
	out[11] |= (inl % (1 << 28)) << (29 - 28)
	out[12] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[12] |= (inl % (1 << 25)) << (29 - 25)
	out[13] = (inl >> 25)
	binary.Read(in, binary.LittleEndian, &inl)
	out[13] |= (inl % (1 << 22)) << (29 - 22)
	out[14] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[14] |= (inl % (1 << 19)) << (29 - 19)
	out[15] = (inl >> 19)
	binary.Read(in, binary.LittleEndian, &inl)
	out[15] |= (inl % (1 << 16)) << (29 - 16)
	out[16] = (inl >> 16)
	binary.Read(in, binary.LittleEndian, &inl)
	out[16] |= (inl % (1 << 13)) << (29 - 13)
	out[17] = (inl >> 13)
	binary.Read(in, binary.LittleEndian, &inl)
	out[17] |= (inl % (1 << 10)) << (29 - 10)
	out[18] = (inl >> 10)
	binary.Read(in, binary.LittleEndian, &inl)
	out[18] |= (inl % (1 << 7)) << (29 - 7)
	out[19] = (inl >> 7)
	binary.Read(in, binary.LittleEndian, &inl)
	out[19] |= (inl % (1 << 4)) << (29 - 4)
	out[20] = (inl >> 4)
	binary.Read(in, binary.LittleEndian, &inl)
	out[20] |= (inl % (1 << 1)) << (29 - 1)
	out[21] = (inl >> 1) % (1 << 29)
	out[22] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[22] |= (inl % (1 << 27)) << (29 - 27)
	out[23] = (inl >> 27)
	binary.Read(in, binary.LittleEndian, &inl)
	out[23] |= (inl % (1 << 24)) << (29 - 24)
	out[24] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[24] |= (inl % (1 << 21)) << (29 - 21)
	out[25] = (inl >> 21)
	binary.Read(in, binary.LittleEndian, &inl)
	out[25] |= (inl % (1 << 18)) << (29 - 18)
	out[26] = (inl >> 18)
	binary.Read(in, binary.LittleEndian, &inl)
	out[26] |= (inl % (1 << 15)) << (29 - 15)
	out[27] = (inl >> 15)
	binary.Read(in, binary.LittleEndian, &inl)
	out[27] |= (inl % (1 << 12)) << (29 - 12)
	out[28] = (inl >> 12)
	binary.Read(in, binary.LittleEndian, &inl)
	out[28] |= (inl % (1 << 9)) << (29 - 9)
	out[29] = (inl >> 9)
	binary.Read(in, binary.LittleEndian, &inl)
	out[29] |= (inl % (1 << 6)) << (29 - 6)
	out[30] = (inl >> 6)
	binary.Read(in, binary.LittleEndian, &inl)
	out[30] |= (inl % (1 << 3)) << (29 - 3)
	out[31] = (inl >> 3)
}

func unpack30_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 30)
	out[1] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[1] |= (inl % (1 << 28)) << (30 - 28)
	out[2] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[2] |= (inl % (1 << 26)) << (30 - 26)
	out[3] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[3] |= (inl % (1 << 24)) << (30 - 24)
	out[4] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[4] |= (inl % (1 << 22)) << (30 - 22)
	out[5] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[5] |= (inl % (1 << 20)) << (30 - 20)
	out[6] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[6] |= (inl % (1 << 18)) << (30 - 18)
	out[7] = (inl >> 18)
	binary.Read(in, binary.LittleEndian, &inl)
	out[7] |= (inl % (1 << 16)) << (30 - 16)
	out[8] = (inl >> 16)
	binary.Read(in, binary.LittleEndian, &inl)
	out[8] |= (inl % (1 << 14)) << (30 - 14)
	out[9] = (inl >> 14)
	binary.Read(in, binary.LittleEndian, &inl)
	out[9] |= (inl % (1 << 12)) << (30 - 12)
	out[10] = (inl >> 12)
	binary.Read(in, binary.LittleEndian, &inl)
	out[10] |= (inl % (1 << 10)) << (30 - 10)
	out[11] = (inl >> 10)
	binary.Read(in, binary.LittleEndian, &inl)
	out[11] |= (inl % (1 << 8)) << (30 - 8)
	out[12] = (inl >> 8)
	binary.Read(in, binary.LittleEndian, &inl)
	out[12] |= (inl % (1 << 6)) << (30 - 6)
	out[13] = (inl >> 6)
	binary.Read(in, binary.LittleEndian, &inl)
	out[13] |= (inl % (1 << 4)) << (30 - 4)
	out[14] = (inl >> 4)
	binary.Read(in, binary.LittleEndian, &inl)
	out[14] |= (inl % (1 << 2)) << (30 - 2)
	out[15] = (inl >> 2)
	binary.Read(in, binary.LittleEndian, &inl)
	out[16] = (inl >> 0) % (1 << 30)
	out[17] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[17] |= (inl % (1 << 28)) << (30 - 28)
	out[18] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[18] |= (inl % (1 << 26)) << (30 - 26)
	out[19] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[19] |= (inl % (1 << 24)) << (30 - 24)
	out[20] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[20] |= (inl % (1 << 22)) << (30 - 22)
	out[21] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[21] |= (inl % (1 << 20)) << (30 - 20)
	out[22] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[22] |= (inl % (1 << 18)) << (30 - 18)
	out[23] = (inl >> 18)
	binary.Read(in, binary.LittleEndian, &inl)
	out[23] |= (inl % (1 << 16)) << (30 - 16)
	out[24] = (inl >> 16)
	binary.Read(in, binary.LittleEndian, &inl)
	out[24] |= (inl % (1 << 14)) << (30 - 14)
	out[25] = (inl >> 14)
	binary.Read(in, binary.LittleEndian, &inl)
	out[25] |= (inl % (1 << 12)) << (30 - 12)
	out[26] = (inl >> 12)
	binary.Read(in, binary.LittleEndian, &inl)
	out[26] |= (inl % (1 << 10)) << (30 - 10)
	out[27] = (inl >> 10)
	binary.Read(in, binary.LittleEndian, &inl)
	out[27] |= (inl % (1 << 8)) << (30 - 8)
	out[28] = (inl >> 8)
	binary.Read(in, binary.LittleEndian, &inl)
	out[28] |= (inl % (1 << 6)) << (30 - 6)
	out[29] = (inl >> 6)
	binary.Read(in, binary.LittleEndian, &inl)
	out[29] |= (inl % (1 << 4)) << (30 - 4)
	out[30] = (inl >> 4)
	binary.Read(in, binary.LittleEndian, &inl)
	out[30] |= (inl % (1 << 2)) << (30 - 2)
	out[31] = (inl >> 2)
}

func unpack31_32(in io.Reader, out []uint32) {
	var inl uint32
	binary.Read(in, binary.LittleEndian, &inl)
	out[0] = (inl >> 0) % (1 << 31)
	out[1] = (inl >> 31)
	binary.Read(in, binary.LittleEndian, &inl)
	out[1] |= (inl % (1 << 30)) << (31 - 30)
	out[2] = (inl >> 30)
	binary.Read(in, binary.LittleEndian, &inl)
	out[2] |= (inl % (1 << 29)) << (31 - 29)
	out[3] = (inl >> 29)
	binary.Read(in, binary.LittleEndian, &inl)
	out[3] |= (inl % (1 << 28)) << (31 - 28)
	out[4] = (inl >> 28)
	binary.Read(in, binary.LittleEndian, &inl)
	out[4] |= (inl % (1 << 27)) << (31 - 27)
	out[5] = (inl >> 27)
	binary.Read(in, binary.LittleEndian, &inl)
	out[5] |= (inl % (1 << 26)) << (31 - 26)
	out[6] = (inl >> 26)
	binary.Read(in, binary.LittleEndian, &inl)
	out[6] |= (inl % (1 << 25)) << (31 - 25)
	out[7] = (inl >> 25)
	binary.Read(in, binary.LittleEndian, &inl)
	out[7] |= (inl % (1 << 24)) << (31 - 24)
	out[8] = (inl >> 24)
	binary.Read(in, binary.LittleEndian, &inl)
	out[8] |= (inl % (1 << 23)) << (31 - 23)
	out[9] = (inl >> 23)
	binary.Read(in, binary.LittleEndian, &inl)
	out[9] |= (inl % (1 << 22)) << (31 - 22)
	out[10] = (inl >> 22)
	binary.Read(in, binary.LittleEndian, &inl)
	out[10] |= (inl % (1 << 21)) << (31 - 21)
	out[11] = (inl >> 21)
	binary.Read(in, binary.LittleEndian, &inl)
	out[11] |= (inl % (1 << 20)) << (31 - 20)
	out[12] = (inl >> 20)
	binary.Read(in, binary.LittleEndian, &inl)
	out[12] |= (inl % (1 << 19)) << (31 - 19)
	out[13] = (inl >> 19)
	binary.Read(in, binary.LittleEndian, &inl)
	out[13] |= (inl % (1 << 18)) << (31 - 18)
	out[14] = (inl >> 18)
	binary.Read(in, binary.LittleEndian, &inl)
	out[14] |= (inl % (1 << 17)) << (31 - 17)
	out[15] = (inl >> 17)
	binary.Read(in, binary.LittleEndian, &inl)
	out[15] |= (inl % (1 << 16)) << (31 - 16)
	out[16] = (inl >> 16)
	binary.Read(in, binary.LittleEndian, &inl)
	out[16] |= (inl % (1 << 15)) << (31 - 15)
	out[17] = (inl >> 15)
	binary.Read(in, binary.LittleEndian, &inl)
	out[17] |= (inl % (1 << 14)) << (31 - 14)
	out[18] = (inl >> 14)
	binary.Read(in, binary.LittleEndian, &inl)
	out[18] |= (inl % (1 << 13)) << (31 - 13)
	out[19] = (inl >> 13)
	binary.Read(in, binary.LittleEndian, &inl)
	out[19] |= (inl % (1 << 12)) << (31 - 12)
	out[20] = (inl >> 12)
	binary.Read(in, binary.LittleEndian, &inl)
	out[20] |= (inl % (1 << 11)) << (31 - 11)
	out[21] = (inl >> 11)
	binary.Read(in, binary.LittleEndian, &inl)
	out[21] |= (inl % (1 << 10)) << (31 - 10)
	out[22] = (inl >> 10)
	binary.Read(in, binary.LittleEndian, &inl)
	out[22] |= (inl % (1 << 9)) << (31 - 9)
	out[23] = (inl >> 9)
	binary.Read(in, binary.LittleEndian, &inl)
	out[23] |= (inl % (1 << 8)) << (31 - 8)
	out[24] = (inl >> 8)
	binary.Read(in, binary.LittleEndian, &inl)
	out[24] |= (inl % (1 << 7)) << (31 - 7)
	out[25] = (inl >> 7)
	binary.Read(in, binary.LittleEndian, &inl)
	out[25] |= (inl % (1 << 6)) << (31 - 6)
	out[26] = (inl >> 6)
	binary.Read(in, binary.LittleEndian, &inl)
	out[26] |= (inl % (1 << 5)) << (31 - 5)
	out[27] = (inl >> 5)
	binary.Read(in, binary.LittleEndian, &inl)
	out[27] |= (inl % (1 << 4)) << (31 - 4)
	out[28] = (inl >> 4)
	binary.Read(in, binary.LittleEndian, &inl)
	out[28] |= (inl % (1 << 3)) << (31 - 3)
	out[29] = (inl >> 3)
	binary.Read(in, binary.LittleEndian, &inl)
	out[29] |= (inl % (1 << 2)) << (31 - 2)
	out[30] = (inl >> 2)
	binary.Read(in, binary.LittleEndian, &inl)
	out[30] |= (inl % (1 << 1)) << (31 - 1)
	out[31] = (inl >> 1)
}

func unpack32_32(in io.Reader, out []uint32) {
	for idx := range out[:32] {
		binary.Read(in, binary.LittleEndian, &out[idx])
	}
}

func nullunpack32(_ io.Reader, out []uint32) {
	out[0] = 0
	for i := 1; i < 32; i *= 2 {
		copy(out[i:], out[:i])
	}
}

func unpack32Default(in io.Reader, out []uint32, nbits int) int {
	batch := len(out) / 32 * 32
	nloops := batch / 32

	var f unpackFunc
	switch nbits {
	case 0:
		f = nullunpack32
	case 1:
		f = unpack1_32
	case 2:
		f = unpack2_32
	case 3:
		f = unpack3_32
	case 4:
		f = unpack4_32
	case 5:
		f = unpack5_32
	case 6:
		f = unpack6_32
	case 7:
		f = unpack7_32
	case 8:
		f = unpack8_32
	case 9:
		f = unpack9_32
	case 10:
		f = unpack10_32
	case 11:
		f = unpack11_32
	case 12:
		f = unpack12_32
	case 13:
		f = unpack13_32
	case 14:
		f = unpack14_32
	case 15:
		f = unpack15_32
	case 16:
		f = unpack16_32
	case 17:
		f = unpack17_32
	case 18:
		f = unpack18_32
	case 19:
		f = unpack19_32
	case 20:
		f = unpack20_32
	case 21:
		f = unpack21_32
	case 22:
		f = unpack22_32
	case 23:
		f = unpack23_32
	case 24:
		f = unpack24_32
	case 25:
		f = unpack25_32
	case 26:
		f = unpack26_32
	case 27:
		f = unpack27_32
	case 28:
		f = unpack28_32
	case 29:
		f = unpack29_32
	case 30:
		f = unpack30_32
	case 31:
		f = unpack31_32
	case 32:
		f = unpack32_32
	default:
		return 0
	}

	for i := 0; i < nloops; i++ {
		f(in, out[i*32:])
	}
	return batch
}
