% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R
\name{concat_tables}
\alias{concat_tables}
\title{Concatenate one or more Tables}
\usage{
concat_tables(..., unify_schemas = TRUE)
}
\arguments{
\item{...}{A \link{Table}}

\item{unify_schemas}{If TRUE, the schemas of the tables will be first unified
with fields of the same name being merged, then each table will be promoted
to the unified schema before being concatenated. Otherwise, all tables should
have the same schema.}
}
\description{
Concatenate one or more \link{Table} objects into a single table. This operation
does not copy array data, but instead creates new chunked arrays for each
column that point at existing array data.
}
\examples{
\dontshow{if (arrow_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
tbl <- arrow_table(name = rownames(mtcars), mtcars)
prius <- arrow_table(name = "Prius", mpg = 58, cyl = 4, disp = 1.8)
combined <- concat_tables(tbl, prius)
tail(combined)$to_data_frame()
\dontshow{\}) # examplesIf}
}
