#include "ptr_rr.h"

namespace ADNS {

	PTR_RR::PTR_RR()
	{
		rr_type = RR_TYPE::PTR;
		rr_class = RR_CLASS::IN;
		Ptrdname = gcnew DOMAIN_NAME();
		UpdateRdata();
	}

	Void PTR_RR::SetPtrdname(DOMAIN_NAME^ dn)
	{
		Ptrdname = gcnew DOMAIN_NAME(dn->GetName());
		UpdateRdata();
		return;
	}

	DOMAIN_NAME^ PTR_RR::GetPtrdname()
	{
		return Ptrdname->Clone();
	}

	String^ PTR_RR::Print()
	{
		String^ output;
		output = PrintHeader();
		output += Ptrdname->Print();

		return output;
	}

	Void PTR_RR::UpdateRdata()
	{
		if (!rdata)
			rdata = gcnew array<Byte>(Ptrdname->GetName()->Length);
		else
			rdata->Resize(rdata,Ptrdname->GetName()->Length);

		Ptrdname->GetName()->CopyTo(rdata,0);

		return;
	}

	Void PTR_RR::ToCanonical()
	{
		Ptrdname->MakeCanonical();
		owner->MakeCanonical();
		UpdateRdata();
		return;
	}

	PTR_RR^ PTR_RR::Clone()
	{
		PTR_RR^ newrr = gcnew PTR_RR();
		newrr->rr_type = rr_type;
		newrr->owner = owner->Clone();
		newrr->ttl = ttl;
		newrr->rr_class = rr_class;
		newrr->Ptrdname = Ptrdname->Clone();
		newrr->UpdateRdata();
		return newrr;
	}

	ResourceRecord^ PTR_RR::ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start)
	{
		PTR_RR^ ptrout;
		array<Byte>^ tmparray;
		int reallen;

		ptrout = gcnew PTR_RR();
		ptrout->owner = gcnew DOMAIN_NAME(domainname);
		ptrout->rr_class = (RR_CLASS) rr_class;
		ptrout->ttl = ttl;
		tmparray = ReadDomainFromPacket(packet, rdata_start, reallen);
		ptrout->SetPtrdname(gcnew DOMAIN_NAME(tmparray));
		return ptrout;

	}

	String^ PTR_RR::PrintRR(ResourceRecord^ rec)
	{
		return safe_cast<PTR_RR^>(rec)->Print();
	}

	ResourceRecord^ PTR_RR::CloneRR(ResourceRecord^ rec)
	{
		return safe_cast<PTR_RR^>(rec)->Clone();
	}

}