#ifndef HAVE_ADNS_OPT_RR_H
#define HAVE_ADNS_OPT_RR_H

using namespace System;
using namespace System::Collections::Generic;

#include "adns_rr.h"

namespace ADNS {
/*
	RFC 2671          Extension Mechanisms for DNS (EDNS0)       August 1999


	4.3. The fixed part of an OPT RR is structured as follows:


		 Field Name   Field Type     Description
		 ------------------------------------------------------
		 NAME         domain name    empty (root domain)
		 TYPE         u_int16_t      OPT
		 CLASS        u_int16_t      sender's UDP payload size
		 TTL          u_int32_t      extended RCODE and flags
		 RDLEN        u_int16_t      describes RDATA
		 RDATA        octet stream   {attribute,value} pairs

	4.4. The variable part of an OPT RR is encoded in its RDATA and is

		 structured as zero or more of the following:

					+0 (MSB)                            +1 (LSB)
		 +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	  0: |                          OPTION-CODE                          |
		 +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	  2: |                         OPTION-LENGTH                         |
		 +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	  4: |                                                               |
		 /                          OPTION-DATA                          /
		 /                                                               /
		 +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+

	   OPTION-CODE    (Assigned by IANA.)

	   OPTION-LENGTH  Size (in octets) of OPTION-DATA.

	   OPTION-DATA    Varies per OPTION-CODE.
*/
	public ref class OPT_RR : ResourceRecord
	{
	private:
		DOMAIN_NAME^ dname;
		UInt16 payload_size;
		array<Byte>^ ext_rcode;
		List<UInt16>^ option_codes;
		List<array<Byte>^>^ option_data;
		Void UpdateRdata();


	public:
		OPT_RR();
		UInt16 GetPayloadSize();
		Void SetPayloadSize(UInt16 ps);
		array<Byte>^ GetOptionData(UInt16 optcode);
		array<UInt16>^ GetOptions();
		bool SetOption(UInt16 ocode, array<Byte>^ odata); //returns false if option already exists
		bool RemoveOption(UInt16 ocode); //returns false if option doesn't exist
		array<Byte>^ OPT_RR::ToWire();
		Byte GetExtendedRcode();
		Void SetExtendedRcode(Byte c);
		Byte GetVersion();
		Void SetVersion(Byte c);
		bool OPT_RR::GetDnssecOk();
		Void OPT_RR::SetDnssecOk(bool b);
		String^ Print();
		OPT_RR^ Clone();
		static ResourceRecord^ ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start);
		static String^ PrintRR(ResourceRecord^ rec);
		static ResourceRecord^ CloneRR(ResourceRecord^ rec);

	};

}

#endif
