/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss;

import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.mozilla.jss.CRLImportException;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.JSSProvider;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.NoSuchTokenException;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.JSSSecureRandom;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.TokenSupplier;
import org.mozilla.jss.crypto.TokenSupplierManager;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.PK11Cert;
import org.mozilla.jss.pkcs11.PK11Module;
import org.mozilla.jss.pkcs11.PK11SecureRandom;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.provider.java.security.JSSMessageDigestSpi;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.ConsolePasswordCallback;
import org.mozilla.jss.util.Debug;
import org.mozilla.jss.util.InvalidNicknameException;
import org.mozilla.jss.util.PasswordCallback;

public final class CryptoManager
implements TokenSupplier {
    private Vector moduleVector;
    private CryptoToken internalCryptoToken;
    private CryptoToken internalKeyStorageToken;
    private static CryptoManager instance = null;
    private PasswordCallback passwordCallback;
    private static int TYPE_KRL = 0;
    private static int TYPE_CRL = 1;
    public static final String JAR_JSS_VERSION = "JSS_VERSION = JSS_3_2";
    public static final String JAR_JDK_VERSION = "JDK_VERSION = N/A";
    public static final String JAR_NSS_VERSION = "NSS_VERSION = NSS_3_4_2_RTM";
    public static final String JAR_DBM_VERSION = "DBM_VERSION = N/A";
    public static final String JAR_NSPR_VERSION = "NSPR_VERSION = NSPRPUB_RELEASE_4_2";
    private static boolean mNativeLibrariesLoaded = false;
    private Hashtable perThreadTokenTable = new Hashtable();

    protected CryptoManager() {
        TokenSupplierManager.setTokenSupplier((TokenSupplier)this);
        this.reloadModules();
    }

    public synchronized native boolean FIPSEnabled();

    public X509Certificate[] buildCertificateChain(X509Certificate x509Certificate) throws CertificateException, TokenException {
        if (!(x509Certificate instanceof PK11Cert)) {
            throw new CertificateException("Certificate is not a PKCS #11 certificate");
        }
        return this.buildCertificateChainNative((PK11Cert)x509Certificate);
    }

    native X509Certificate[] buildCertificateChainNative(PK11Cert var1) throws CertificateException, TokenException;

    public JSSSecureRandom createPseudoRandomNumberGenerator() {
        return new PK11SecureRandom();
    }

    private static native boolean enableFIPS(boolean var0) throws GeneralSecurityException;

    public native byte[] exportCertsToPKCS7(X509Certificate[] var1) throws CertificateEncodingException;

    public X509Certificate findCertByIssuerAndSerialNumber(byte[] byArray, INTEGER iNTEGER) throws ObjectNotFoundException, TokenException {
        try {
            ANY aNY = (ANY)ASN1Util.decode((ASN1Template)ANY.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)iNTEGER));
            return this.findCertByIssuerAndSerialNumberNative(byArray, aNY.getContents());
        }
        catch (InvalidBERException invalidBERException) {
            Assert.notReached((String)"Invalid BER encoding of INTEGER");
            return null;
        }
    }

    private native X509Certificate findCertByIssuerAndSerialNumberNative(byte[] var1, byte[] var2) throws ObjectNotFoundException, TokenException;

    public X509Certificate findCertByNickname(String string) throws ObjectNotFoundException, TokenException {
        Assert._assert((string != null ? 1 : 0) != 0);
        return this.findCertByNicknameNative(string);
    }

    protected native X509Certificate findCertByNicknameNative(String var1) throws ObjectNotFoundException, TokenException;

    public X509Certificate[] findCertsByNickname(String string) throws TokenException {
        Assert._assert((string != null ? 1 : 0) != 0);
        return this.findCertsByNicknameNative(string);
    }

    protected native X509Certificate[] findCertsByNicknameNative(String var1) throws TokenException;

    public PrivateKey findPrivKeyByCert(X509Certificate x509Certificate) throws ObjectNotFoundException, TokenException {
        Assert._assert((x509Certificate != null ? 1 : 0) != 0);
        if (!(x509Certificate instanceof PK11Cert)) {
            Assert.notReached((String)"non-pkcs11 cert passed to PK11Finder");
            throw new ObjectNotFoundException();
        }
        return this.findPrivKeyByCertNative(x509Certificate);
    }

    protected native PrivateKey findPrivKeyByCertNative(X509Certificate var1) throws ObjectNotFoundException, TokenException;

    public synchronized Enumeration getAllTokens() {
        Enumeration enumeration = this.getModules();
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2 = ((PK11Module)enumeration.nextElement()).getTokens();
            while (enumeration2.hasMoreElements()) {
                vector.addElement(enumeration2.nextElement());
            }
        }
        return vector.elements();
    }

    public native X509Certificate[] getCACerts();

    public synchronized Enumeration getExternalTokens() {
        Enumeration enumeration = this.getModules();
        Vector<PK11Token> vector = new Vector<PK11Token>();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2 = ((PK11Module)enumeration.nextElement()).getTokens();
            while (enumeration2.hasMoreElements()) {
                PK11Token pK11Token = (PK11Token)enumeration2.nextElement();
                if (pK11Token.isInternalCryptoToken() || pK11Token.isInternalKeyStorageToken()) continue;
                vector.addElement(pK11Token);
            }
        }
        return vector.elements();
    }

    public static synchronized CryptoManager getInstance() throws NotInitializedException {
        if (instance == null) {
            throw new NotInitializedException();
        }
        return instance;
    }

    public synchronized CryptoToken getInternalCryptoToken() {
        return this.internalCryptoToken;
    }

    public synchronized CryptoToken getInternalKeyStorageToken() {
        return this.internalKeyStorageToken;
    }

    public synchronized Enumeration getModules() {
        return this.moduleVector.elements();
    }

    public synchronized PasswordCallback getPasswordCallback() {
        return this.passwordCallback;
    }

    public native X509Certificate[] getPermCerts();

    public JSSSecureRandom getSecureRNG() {
        return new PK11SecureRandom();
    }

    public CryptoToken getThreadToken() {
        CryptoToken cryptoToken = (CryptoToken)this.perThreadTokenTable.get(Thread.currentThread());
        if (cryptoToken == null) {
            cryptoToken = this.getInternalKeyStorageToken();
        }
        return cryptoToken;
    }

    public synchronized CryptoToken getTokenByName(String string) throws NoSuchTokenException {
        Enumeration enumeration = this.getAllTokens();
        while (enumeration.hasMoreElements()) {
            CryptoToken cryptoToken = (CryptoToken)enumeration.nextElement();
            try {
                if (!string.equals(cryptoToken.getName())) continue;
                return cryptoToken;
            }
            catch (TokenException tokenException) {
                Assert._assert((boolean)false, (String)"Got a token exception");
            }
        }
        throw new NoSuchTokenException();
    }

    public synchronized Enumeration getTokensSupportingAlgorithm(Algorithm algorithm) {
        Enumeration enumeration = this.getAllTokens();
        Vector<CryptoToken> vector = new Vector<CryptoToken>();
        while (enumeration.hasMoreElements()) {
            CryptoToken cryptoToken = (CryptoToken)enumeration.nextElement();
            if (!cryptoToken.doesAlgorithm(algorithm)) continue;
            vector.addElement(cryptoToken);
        }
        return vector.elements();
    }

    public X509Certificate importCACertPackage(byte[] byArray) throws CertificateEncodingException, TokenException {
        try {
            return this.importCertPackageNative(byArray, null, true, false);
        }
        catch (NicknameConflictException nicknameConflictException) {
            Assert.notReached((String)"importing CA certs caused nickname conflict");
            Debug.trace((int)1, (String)"importing CA certs caused nickname conflict");
        }
        catch (UserCertConflictException userCertConflictException) {
            Assert.notReached((String)"importing CA certs caused user cert conflict");
            Debug.trace((int)1, (String)"importing CA certs caused user cert conflict");
        }
        catch (NoSuchItemOnTokenException noSuchItemOnTokenException) {
            Assert.notReached((String)"importing CA certs caused NoSuchItemOnTokenException");
            Debug.trace((int)1, (String)"importing CA certs caused NoSuchItemOnTokenException");
        }
        return null;
    }

    public void importCRL(byte[] byArray, String string) throws CRLImportException, TokenException {
        this.importCRLNative(byArray, string, TYPE_CRL);
    }

    private native void importCRLNative(byte[] var1, String var2, int var3) throws CRLImportException, TokenException;

    public X509Certificate importCertPackage(byte[] byArray, String string) throws CertificateEncodingException, NicknameConflictException, UserCertConflictException, NoSuchItemOnTokenException, TokenException {
        return this.importCertPackageNative(byArray, string, false, false);
    }

    private native X509Certificate importCertPackageNative(byte[] var1, String var2, boolean var3, boolean var4) throws CertificateEncodingException, NicknameConflictException, UserCertConflictException, NoSuchItemOnTokenException, TokenException;

    public InternalCertificate importCertToPerm(X509Certificate x509Certificate, String string) throws TokenException, InvalidNicknameException {
        if (string == null) {
            throw new InvalidNicknameException("Nickname must be non-null");
        }
        return this.importCertToPermNative(x509Certificate, string);
    }

    private native InternalCertificate importCertToPermNative(X509Certificate var1, String var2) throws TokenException;

    public X509Certificate importUserCACertPackage(byte[] byArray, String string) throws CertificateEncodingException, NicknameConflictException, UserCertConflictException, NoSuchItemOnTokenException, TokenException {
        return this.importCertPackageNative(byArray, string, false, true);
    }

    public static synchronized void initialize(String string) throws KeyDatabaseException, CertDatabaseException, AlreadyInitializedException, GeneralSecurityException {
        CryptoManager.initialize(new InitializationValues(string));
    }

    public static synchronized void initialize(InitializationValues initializationValues) throws KeyDatabaseException, CertDatabaseException, AlreadyInitializedException, GeneralSecurityException {
        if (instance != null) {
            throw new AlreadyInitializedException();
        }
        CryptoManager.loadNativeLibraries();
        if (initializationValues.ocspResponderURL != null && initializationValues.ocspResponderCertNickname == null) {
            throw new GeneralSecurityException("Must set ocspResponderCertNickname");
        }
        CryptoManager.initializeAllNative2(initializationValues.configDir, initializationValues.certPrefix, initializationValues.keyPrefix, initializationValues.secmodName, initializationValues.readOnly, initializationValues.getManufacturerID(), initializationValues.getLibraryDescription(), initializationValues.getInternalTokenDescription(), initializationValues.getInternalKeyStorageTokenDescription(), initializationValues.getInternalSlotDescription(), initializationValues.getInternalKeyStorageSlotDescription(), initializationValues.getFIPSSlotDescription(), initializationValues.getFIPSKeyStorageSlotDescription(), initializationValues.ocspCheckingEnabled, initializationValues.ocspResponderURL, initializationValues.ocspResponderCertNickname, initializationValues.initializeJavaOnly);
        instance = new CryptoManager();
        instance.setPasswordCallback(initializationValues.passwordCallback);
        if (initializationValues.fipsMode != InitializationValues.FIPSMode.UNCHANGED && CryptoManager.enableFIPS(initializationValues.fipsMode == InitializationValues.FIPSMode.ENABLED)) {
            instance.reloadModules();
        }
        if (initializationValues.removeSunProvider) {
            Security.removeProvider("SUN");
        }
        if (initializationValues.installJSSProvider) {
            JSSMessageDigestSpi.SHA1 sHA1 = new JSSMessageDigestSpi.SHA1();
            int n = Security.insertProviderAt((Provider)new JSSProvider(), 1);
            if (n == -1) {
                Debug.trace((int)1, (String)"Unable to install default provider");
            }
        }
    }

    private static native void initializeAllNative2(String var0, String var1, String var2, String var3, boolean var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, boolean var13, String var14, String var15, boolean var16) throws KeyDatabaseException, CertDatabaseException, AlreadyInitializedException;

    public boolean isCertValid(String string, boolean bl, CertUsage certUsage) throws ObjectNotFoundException, InvalidNicknameException {
        if (string == null) {
            throw new InvalidNicknameException("Nickname must be non-null");
        }
        return this.verifyCertNowNative(string, bl, certUsage.getUsage());
    }

    public boolean isCertValid(byte[] byArray, boolean bl, CertUsage certUsage) throws TokenException, CertificateEncodingException {
        return this.verifyCertTempNative(byArray, bl, certUsage.getUsage());
    }

    static synchronized void loadNativeLibraries() {
        if (!mNativeLibrariesLoaded && !"no".equals(System.getProperty("jss.load"))) {
            try {
                Debug.trace((int)5, (String)"about to load jss library");
                System.loadLibrary("jss3");
                Debug.trace((int)5, (String)"jss library loaded");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Debug.trace((int)1, (String)"ERROR: Unable to load jss library");
                throw new UnsatisfiedLinkError("Unable to load jss library or one of its dependencies");
            }
            mNativeLibrariesLoaded = true;
        }
    }

    private native void putModulesInVector(Vector var1);

    private synchronized void reloadModules() {
        this.moduleVector = new Vector();
        this.putModulesInVector(this.moduleVector);
        Enumeration enumeration = this.getAllTokens();
        this.internalCryptoToken = null;
        this.internalKeyStorageToken = null;
        while (enumeration.hasMoreElements()) {
            PK11Token pK11Token = (PK11Token)enumeration.nextElement();
            if (pK11Token.isInternalCryptoToken()) {
                Assert._assert((this.internalCryptoToken == null ? 1 : 0) != 0);
                this.internalCryptoToken = pK11Token;
            }
            if (!pK11Token.isInternalKeyStorageToken()) continue;
            Assert._assert((this.internalKeyStorageToken == null ? 1 : 0) != 0);
            this.internalKeyStorageToken = pK11Token;
        }
        Assert._assert((this.internalKeyStorageToken != null ? 1 : 0) != 0);
        Assert._assert((this.internalCryptoToken != null ? 1 : 0) != 0);
    }

    private native void setNativePasswordCallback(PasswordCallback var1);

    public synchronized void setPasswordCallback(PasswordCallback passwordCallback) {
        this.passwordCallback = passwordCallback;
        this.setNativePasswordCallback(passwordCallback);
    }

    public void setThreadToken(CryptoToken cryptoToken) {
        if (cryptoToken != null) {
            this.perThreadTokenTable.put(Thread.currentThread(), cryptoToken);
        } else {
            this.perThreadTokenTable.remove(Thread.currentThread());
        }
    }

    private native boolean verifyCertNowNative(String var1, boolean var2, int var3) throws ObjectNotFoundException;

    private native boolean verifyCertTempNative(byte[] var1, boolean var2, int var3) throws TokenException, CertificateEncodingException;

    public static final class InitializationValues {
        public final int TOKEN_LENGTH = 33;
        public final int SLOT_LENGTH = 65;
        public final int MANUFACTURER_LENGTH = 33;
        public final int LIBRARY_LENGTH = 33;
        public String configDir = null;
        public String certPrefix = null;
        public String keyPrefix = null;
        public String secmodName = null;
        public PasswordCallback passwordCallback = new ConsolePasswordCallback();
        public FIPSMode fipsMode = FIPSMode.UNCHANGED;
        public boolean readOnly = false;
        private String manufacturerID = "mozilla.org                      ";
        private String libraryDescription = "Internal Crypto Services         ";
        private String internalTokenDescription = "Internal Crypto Services Token   ";
        private String internalKeyStorageTokenDescription = "Internal Key Storage Token       ";
        private String internalSlotDescription = "NSS Internal Cryptographic Services                              ";
        private String internalKeyStorageSlotDescription = "NSS Internal Private Key and Certificate Storage                 ";
        private String FIPSSlotDescription = "NSS Internal FIPS-140-1 Cryptographic Services                   ";
        private String FIPSKeyStorageSlotDescription = "NSS Internal FIPS-140-1 Private Key and Certificate Storage      ";
        public boolean ocspCheckingEnabled = false;
        public String ocspResponderURL = null;
        public String ocspResponderCertNickname = null;
        public boolean installJSSProvider = true;
        public boolean removeSunProvider = false;
        public boolean initializeJavaOnly = false;

        protected InitializationValues() {
            Assert.notReached((String)"Default constructor");
        }

        public InitializationValues(String string) {
            this.configDir = string;
        }

        public InitializationValues(String string, String string2, String string3, String string4) {
            this.configDir = string;
            this.certPrefix = string2;
            this.keyPrefix = string3;
            this.secmodName = string4;
        }

        public String getFIPSKeyStorageSlotDescription() {
            return this.FIPSKeyStorageSlotDescription;
        }

        public String getFIPSSlotDescription() {
            return this.FIPSSlotDescription;
        }

        public String getInternalKeyStorageSlotDescription() {
            return this.internalKeyStorageSlotDescription;
        }

        public String getInternalKeyStorageTokenDescription() {
            return this.internalKeyStorageTokenDescription;
        }

        public String getInternalSlotDescription() {
            return this.internalSlotDescription;
        }

        public String getInternalTokenDescription() {
            return this.internalTokenDescription;
        }

        public String getLibraryDescription() {
            return this.libraryDescription;
        }

        public String getManufacturerID() {
            return this.manufacturerID;
        }

        public void setFIPSKeyStorageSlotDescription(String string) throws InvalidLengthException {
            if (string.length() != 65) {
                throw new InvalidLengthException();
            }
            this.FIPSKeyStorageSlotDescription = string;
        }

        public void setFIPSSlotDescription(String string) throws InvalidLengthException {
            if (string.length() != 65) {
                throw new InvalidLengthException();
            }
            this.FIPSSlotDescription = string;
        }

        public void setInternalKeyStorageSlotDescription(String string) throws InvalidLengthException {
            if (string.length() != 65) {
                throw new InvalidLengthException();
            }
            this.internalKeyStorageSlotDescription = string;
        }

        public void setInternalKeyStorageTokenDescription(String string) throws InvalidLengthException {
            if (string.length() != 33) {
                throw new InvalidLengthException();
            }
            this.internalKeyStorageTokenDescription = string;
        }

        public void setInternalSlotDescription(String string) throws InvalidLengthException {
            if (string.length() != 65) {
                throw new InvalidLengthException();
            }
            this.internalSlotDescription = string;
        }

        public void setInternalTokenDescription(String string) throws InvalidLengthException {
            if (string.length() != 33) {
                throw new InvalidLengthException();
            }
            this.internalTokenDescription = string;
        }

        public void setLibraryDescription(String string) throws InvalidLengthException {
            if (string.length() != 33) {
                throw new InvalidLengthException();
            }
            this.libraryDescription = string;
        }

        public void setManufacturerID(String string) throws InvalidLengthException {
            if (string.length() != 33) {
                throw new InvalidLengthException();
            }
            this.manufacturerID = string;
        }
    }
}

