# $Id: otf.perl,v 1.5 2019-06-26 13:46:38+09 shige Exp $
# latex2html perl file for otf package
# shige
#
# \UTF{[code]} => &#[code] (if OTFUTFTOIMAGE == 0)
# \CID{[code]} => image 

package main;

sub do_cmd_UTF {
    local($_) = @_;
    local($utfcode, $image);
    local($env) = 'tex2html_wrap_inline';
    $utfcode = &missing_braces unless (
        (s/$next_pair_pr_rx/$utfcode=$2;''/e)
        ||(s/$next_pair_rx/$utfcode=$2;''/e));
    if ($OTFUTFTOIMAGE) {
	$image = &process_math_in_latex('', '', 0, "\\mbox{\\UTF{$utfcode}}");
    } else {
	$image = "&#x${utfcode};";
    }
    if ($USING_STYLES) {
	join('', "<SPAN CLASS=\"otf-utf\">", $image, "</SPAN>", $_);
    } else { 
	join('', $image, $_);
    }
}

sub do_cmd_CID {
    local($_) = @_;
    local($cidcode, $image);
    local($env) = 'tex2html_wrap_inline';
    $cidcode = &missing_braces unless (
        (s/$next_pair_pr_rx/$cidcode=$2;''/e)
        ||(s/$next_pair_rx/$cidcode=$2;''/e));
    $image = &process_math_in_latex('', '', 0, "\\mbox{\\CID{$cidcode}}");
    if ($USING_STYLES) {
	join('', "<SPAN CLASS=\"otf-cid\">", $image, "</SPAN>", $_);
    } else {
	join('', $image, $_);
    }
}

1;
