# jbook.perl by Kouji Kodama <kdm@kobe-kosen.ac.jp>
# copied from:
# book.perl by Ross Moore <ross@mpce.mq.edu.au>  09-14-97
#
# Extension to LaTeX2HTML V97.1 to support the "book" document class
# and standard LaTeX2e class options.
#
# Change Log:
# ===========

package main;

require "$LATEX2HTMLSTYLES${dd}japanese.perl";

# Suppress option-warning messages:

sub do_jbook_a4paper{}
sub do_jbook_a5paper{}
sub do_jbook_b4paper{}
sub do_jbook_b5paper{}
sub do_jbook_legalpaper{}
sub do_jbook_letterpaper{}
sub do_jbook_executivepaper{}
sub do_jbook_landscape{}
sub do_jbook_final{}
sub do_jbook_draft{}
sub do_jbook_oneside{}
sub do_jbook_twoside{}
sub do_jbook_openright{}
sub do_jbook_openany{}
sub do_jbook_onecolumn{}
sub do_jbook_twocolumn{}
sub do_jbook_notitlepage{}
sub do_jbook_titlepage{}
sub do_jbook_openbib{}
#
sub do_jbook_a4j{}
sub do_jbook_a5j{}
sub do_jbook_b4j{}
sub do_jbook_b5j{}
sub do_jbook_a4p{}
sub do_jbook_a5p{}
sub do_jbook_b4p{}
sub do_jbook_b5p{}


sub do_jbook_10pt{ $LATEX_FONT_SIZE = '10pt' unless $LATEX_FONT_SIZE; }
sub do_jbook_11pt{ $LATEX_FONT_SIZE = '11pt' unless $LATEX_FONT_SIZE; }
sub do_jbook_12pt{ $LATEX_FONT_SIZE = '12pt' unless $LATEX_FONT_SIZE; }

sub do_jbook_leqno{ $EQN_TAGS = 'L'; }
sub do_jbook_reqno{ $EQN_TAGS = 'R'; }
sub do_jbook_fleqn{ $FLUSH_EQN = 1; }

sub do_cmd_thepart {
    join('', &do_cmd_Roman("${O}0${C}part${O}0$C"), ".", @_[0]) }

sub do_cmd_thechapter {
    join('', &do_cmd_arabic("${O}0${C}chapter${O}0$C"), ".", @_[0]) }


sub do_cmd_thesection {
    join('',&translate_commands("\\thechapter")
	, &do_cmd_arabic("${O}0${C}section${O}0$C"), @_[0]) }

sub do_cmd_thesubsection {
    join('',&translate_commands("\\thesection")
	,"." , &do_cmd_arabic("${O}0${C}subsection${O}0$C"), @_[0]) }

sub do_cmd_thesubsubsection {
    join('',&translate_commands("\\thesubsection")
	,"." , &do_cmd_arabic("${O}0${C}subsubsection${O}0$C"), @_[0]) }

sub do_cmd_theparagraph {
    join('',&translate_commands("\\thesubsubsection")
	,"." , &do_cmd_arabic("${O}0${C}paragraph${O}0$C"), @_[0]) }

sub do_cmd_thesubparagraph {
    join('',&translate_commands("\\theparagraph")
	,"." , &do_cmd_arabic("${O}0${C}subparagraph${O}0$C"), @_[0]) }


&addto_dependents('chapter','equation');
&addto_dependents('chapter','footnote');
&addto_dependents('chapter','figure');
&addto_dependents('chapter','table');

sub do_cmd_theequation {
    local($chap) =  &translate_commands("\\thechapter");
    join('', (($chap =~ /^(0\.)?$/)? '' : $chap)
        , &do_cmd_arabic("${O}0${C}equation${O}0$C"), @_[0]) }

sub do_cmd_thefootnote {
    local($chap) =  &translate_commands("\\thechapter");
    join('', (($chap =~ /^(0\.)?$/)? '' : $chap)
        , &do_cmd_arabic("${O}0${C}footnote${O}0$C"), @_[0]) }

sub do_cmd_thefigure {
    local($chap) =  &translate_commands("\\thechapter");
    join('', (($chap =~ /^(0\.)?$/)? '' : $chap)
        , &do_cmd_arabic("${O}0${C}figure${O}0$C"), @_[0]) }

sub do_cmd_thetable {
    local($chap) =  &translate_commands("\\thechapter");
    join('', (($chap =~ /^(0\.)?$/)? '' : $chap)
        , &do_cmd_arabic("${O}0${C}table${O}0$C"), @_[0]) }


1;	# Must be last line

