#!/bin/bash

# Copyright 2014 Google Inc. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This script builds ui assets into a single go datafile

set -o errexit
set -o nounset
set -o pipefail

KUBE_ROOT=$(dirname "${BASH_SOURCE}")/..
source "${KUBE_ROOT}/hack/lib/init.sh"

cd "${KUBE_ROOT}"

if ! which go-bindata > /dev/null 2>&1 ; then
	echo "Cannot find go-bindata. Install with \"go get github.com/jteeuwen/go-bindata/...\""
	exit 1
fi

DATAFILE=pkg/ui/datafile.go
TMP_DATAFILE=/tmp/datafile.go

go-bindata -nocompress -o $DATAFILE -prefix ${PWD} -pkg ui www/... third_party/swagger-ui/...

cat hooks/boilerplate.go.txt > $TMP_DATAFILE
echo "// generated by hack/build-ui.sh; DO NOT EDIT
" >> $TMP_DATAFILE
cat $DATAFILE >> $TMP_DATAFILE

gofmt -s -w $TMP_DATAFILE

mv $TMP_DATAFILE $DATAFILE
