/*
 * Decompiled with CFR 0.152.
 */
package io.k8s.cassandra;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.cassandra.locator.SeedProvider;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesSeedProvider
implements SeedProvider {
    static TrustManager[] managers = null;
    private static final Logger logger = LoggerFactory.getLogger(KubernetesSeedProvider.class);
    private List defaultSeeds;

    private static String getEnvOrDefault(String string, String string2) {
        String string3 = System.getenv(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public KubernetesSeedProvider(Map<String, String> map) {
        String[] stringArray = map.get("seeds").split(",", -1);
        this.defaultSeeds = new ArrayList(stringArray.length);
        for (String string : stringArray) {
            try {
                this.defaultSeeds.add(InetAddress.getByName(string.trim()));
            }
            catch (UnknownHostException unknownHostException) {
                logger.warn("Seed provider couldn't lookup host " + string);
            }
        }
    }

    private void ignoreSelfSignedCerts() {
        Object object;
        if (managers != null) {
            return;
        }
        managers = new TrustManager[]{new TrustAll()};
        try {
            object = SSLContext.getInstance("SSL");
            ((SSLContext)object).init(null, managers, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(((SSLContext)object).getSocketFactory());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (KeyManagementException keyManagementException) {
            keyManagementException.printStackTrace();
        }
        object = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)object);
    }

    public List<InetAddress> getSeeds() {
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        String string = KubernetesSeedProvider.getEnvOrDefault("KUBERNETES_API_PROTOCOL", "http");
        String string2 = KubernetesSeedProvider.getEnvOrDefault("KUBERNETES_RO_SERVICE_HOST", "localhost");
        String string3 = KubernetesSeedProvider.getEnvOrDefault("KUBERNETES_RO_SERVICE_PORT", "8080");
        String string4 = string + "://" + string2 + ":" + string3;
        String string5 = KubernetesSeedProvider.getEnvOrDefault("CASSANDRA_SERVICE", "cassandra");
        String string6 = "/api/v1beta1/endpoints/";
        try {
            URL uRL = new URL(string4 + string6 + string5);
            ObjectMapper objectMapper = new ObjectMapper();
            Endpoints endpoints = (Endpoints)objectMapper.readValue(uRL, Endpoints.class);
            if (endpoints != null) {
                for (String string7 : endpoints.endpoints) {
                    String[] stringArray = string7.split(":");
                    arrayList.add(InetAddress.getByName(stringArray[0]));
                }
            }
        }
        catch (IOException iOException) {
            logger.warn("Request to kubernetes apiserver failed");
        }
        if (arrayList.size() == 0) {
            return this.defaultSeeds;
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        KubernetesSeedProvider kubernetesSeedProvider = new KubernetesSeedProvider(new HashMap<String, String>());
        System.out.println(kubernetesSeedProvider.getSeeds());
    }

    static class TrustAll
    implements X509TrustManager {
        TrustAll() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Endpoints {
        public String[] endpoints;

        Endpoints() {
        }
    }
}

