package main

import (
	"k8s.io/gengo/args"
	"k8s.io/kubernetes/cmd/libs/go2idl/lister-gen/generators"

	"github.com/golang/glog"
	"github.com/spf13/pflag"
)

func main() {
	arguments := &args.GeneratorArgs{
		OutputBase:        args.DefaultSourceTree(),
		GoHeaderFilePath:  "hack/boilerplate.txt",
		GeneratedBuildTag: "ignore_autogenerated_openshift",
		OutputPackagePath: "github.com/openshift/origin/pkg/client/listers",
	}
	arguments.AddFlags(pflag.CommandLine)

	// Run it.
	if err := arguments.Execute(
		generators.NameSystems(),
		generators.DefaultNameSystem(),
		generators.Packages,
	); err != nil {
		glog.Fatalf("Error: %v", err)
	}
	glog.V(2).Info("Completed successfully.")
}
