// Code generated by go-bindata.
// sources:
// examples/image-streams/image-streams-centos7.json
// examples/image-streams/image-streams-rhel7.json
// examples/db-templates/mariadb-ephemeral-template.json
// examples/db-templates/mariadb-persistent-template.json
// examples/db-templates/mongodb-ephemeral-template.json
// examples/db-templates/mongodb-persistent-template.json
// examples/db-templates/mysql-ephemeral-template.json
// examples/db-templates/mysql-persistent-template.json
// examples/db-templates/postgresql-ephemeral-template.json
// examples/db-templates/postgresql-persistent-template.json
// examples/jenkins/jenkins-ephemeral-template.json
// examples/jenkins/jenkins-persistent-template.json
// examples/jenkins/pipeline/samplepipeline.json
// examples/quickstarts/cakephp-mysql.json
// examples/quickstarts/dancer-mysql.json
// examples/quickstarts/django-postgresql.json
// examples/quickstarts/nodejs-mongodb.json
// examples/quickstarts/rails-postgresql.json
// pkg/image/admission/imagepolicy/api/v1/default-policy.yaml
// DO NOT EDIT!

package bootstrap

import (
	"fmt"
	"strings"
	"os"
	"time"
	"io/ioutil"
	"path/filepath"
)
type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name string
	size int64
	mode os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _examplesImageStreamsImageStreamsCentos7Json = []byte(`{
  "kind": "ImageStreamList",
  "apiVersion": "v1",
  "metadata": {},
  "items": [
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "ruby"
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run Ruby applications",
              "iconClass": "icon-ruby",
              "tags": "builder,ruby",
              "supports": "ruby",
              "sampleRepo": "https://github.com/openshift/ruby-ex.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "2.3"
            }
          },
          {
            "name": "2.0",
            "annotations": {
              "description": "Build and run Ruby 2.0 applications",
              "iconClass": "icon-ruby",
              "tags": "builder,ruby",
              "supports": "ruby:2.0,ruby",
              "version": "2.0",
              "sampleRepo": "https://github.com/openshift/ruby-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/ruby-20-centos7:latest"
            }
          },
          {
            "name": "2.2",
            "annotations": {
              "description": "Build and run Ruby 2.2 applications",
              "iconClass": "icon-ruby",
              "tags": "builder,ruby",
              "supports": "ruby:2.2,ruby",
              "version": "2.2",
              "sampleRepo": "https://github.com/openshift/ruby-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/ruby-22-centos7:latest"
            }
          },
          {
            "name": "2.3",
            "annotations": {
              "description": "Build and run Ruby 2.3 applications",
              "iconClass": "icon-ruby",
              "tags": "builder,ruby",
              "supports": "ruby:2.3,ruby",
              "version": "2.3",
              "sampleRepo": "https://github.com/openshift/ruby-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/ruby-23-centos7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "nodejs"
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run NodeJS applications",
              "iconClass": "icon-nodejs",
              "tags": "builder,nodejs",
              "supports":"nodejs",
              "sampleRepo": "https://github.com/openshift/nodejs-ex.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "4"
            }
          },
          {
            "name": "0.10",
            "annotations": {
              "description": "Build and run NodeJS 0.10 applications",
              "iconClass": "icon-nodejs",
              "tags": "builder,nodejs",
              "supports":"nodejs:0.10,nodejs:0.1,nodejs",
              "version": "0.10",
              "sampleRepo": "https://github.com/openshift/nodejs-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/nodejs-010-centos7:latest"
            }
          },
          {
            "name": "4",
            "annotations": {
              "description": "Build and run NodeJS 4 applications",
              "iconClass": "icon-nodejs",
              "tags": "builder,nodejs",
              "supports":"nodejs:4,nodejs",
              "version": "4",
              "sampleRepo": "https://github.com/openshift/nodejs-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/nodejs-4-centos7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "perl"
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run Perl applications",
              "iconClass": "icon-perl",
              "tags": "builder,perl",
              "supports":"perl",
              "sampleRepo": "https://github.com/openshift/dancer-ex.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "5.20"
            }
          },
          {
            "name": "5.16",
            "annotations": {
              "description": "Build and run Perl 5.16 applications",
              "iconClass": "icon-perl",
              "tags": "builder,perl",
              "supports":"perl:5.16,perl",
              "version": "5.16",
              "sampleRepo": "https://github.com/openshift/dancer-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/perl-516-centos7:latest"
            }
          },
          {
            "name": "5.20",
            "annotations": {
              "description": "Build and run Perl 5.20 applications",
              "iconClass": "icon-perl",
              "tags": "builder,perl",
              "supports":"perl:5.20,perl",
              "version": "5.20",
              "sampleRepo": "https://github.com/openshift/dancer-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/perl-520-centos7:latest"
            }

          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "php"
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run PHP applications",
              "iconClass": "icon-php",
              "tags": "builder,php",
              "supports":"php",
              "sampleRepo": "https://github.com/openshift/cakephp-ex.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "5.6"
            }
          },
          {
            "name": "5.5",
            "annotations": {
              "description": "Build and run PHP 5.5 applications",
              "iconClass": "icon-php",
              "tags": "builder,php",
              "supports":"php:5.5,php",
              "version": "5.5",
              "sampleRepo": "https://github.com/openshift/cakephp-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/php-55-centos7:latest"
            }
          },
          {
            "name": "5.6",
            "annotations": {
              "description": "Build and run PHP 5.6 applications",
              "iconClass": "icon-php",
              "tags": "builder,php",
              "supports":"php:5.6,php",
              "version": "5.6",
              "sampleRepo": "https://github.com/openshift/cakephp-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/php-56-centos7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "python"
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run Python applications",
              "iconClass": "icon-python",
              "tags": "builder,python",
              "supports":"python",
              "sampleRepo": "https://github.com/openshift/django-ex.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "3.5"
            }
          },
          {
            "name": "3.3",
            "annotations": {
              "description": "Build and run Python 3.3 applications",
              "iconClass": "icon-python",
              "tags": "builder,python",
              "supports":"python:3.3,python",
              "version": "3.3",
              "sampleRepo": "https://github.com/openshift/django-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/python-33-centos7:latest"
            }
          },
          {
            "name": "2.7",
            "annotations": {
              "description": "Build and run Python 2.7 applications",
              "iconClass": "icon-python",
              "tags": "builder,python",
              "supports":"python:2.7,python",
              "version": "2.7",
              "sampleRepo": "https://github.com/openshift/django-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/python-27-centos7:latest"
            }
          },
          {
            "name": "3.4",
            "annotations": {
              "description": "Build and run Python 3.4 applications",
              "iconClass": "icon-python",
              "tags": "builder,python",
              "supports":"python:3.4,python",
              "version": "3.4",
              "sampleRepo": "https://github.com/openshift/django-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/python-34-centos7:latest"
            }
          },
          {
            "name": "3.5",
            "annotations": {
              "description": "Build and run Python 3.5 applications",
              "iconClass": "icon-python",
              "tags": "builder,python",
              "supports":"python:3.5,python",
              "version": "3.5",
              "sampleRepo": "https://github.com/openshift/django-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/python-35-centos7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "wildfly"
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run Java applications on Wildfly",
              "iconClass": "icon-wildfly",
              "tags": "builder,wildfly,java",
              "supports":"jee,java",
              "sampleRepo": "https://github.com/bparees/openshift-jee-sample.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "10.0"
            }
          },
          {
            "name": "8.1",
            "annotations": {
              "description": "Build and run Java applications on Wildfly 8.1",
              "iconClass": "icon-wildfly",
              "tags": "builder,wildfly,java",
              "supports":"wildfly:8.1,jee,java",
              "version": "8.1",
              "sampleRepo": "https://github.com/bparees/openshift-jee-sample.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/wildfly-81-centos7:latest"
            }
          },
          {
            "name": "9.0",
            "annotations": {
              "description": "Build and run Java applications on Wildfly 9.0",
              "iconClass": "icon-wildfly",
              "tags": "builder,wildfly,java",
              "supports":"wildfly:9.0,jee,java",
              "version": "9.0",
              "sampleRepo": "https://github.com/bparees/openshift-jee-sample.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/wildfly-90-centos7:latest"
            }
          },
          {
            "name": "10.0",
            "annotations": {
              "description": "Build and run Java applications on Wildfly 10.0",
              "iconClass": "icon-wildfly",
              "tags": "builder,wildfly,java",
              "supports":"wildfly:10.0,jee,java",
              "version": "10.0",
              "sampleRepo": "https://github.com/bparees/openshift-jee-sample.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/wildfly-100-centos7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "mysql"
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Provides a MySQL database",
              "iconClass": "icon-mysql-database",
              "tags": "mysql"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "5.6"
            }
          },
          {
            "name": "5.5",
            "annotations": {
              "description": "Provides a MySQL v5.5 database",
              "iconClass": "icon-mysql-database",
              "tags": "mysql",
              "version": "5.5"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/mysql-55-centos7:latest"
            }
          },
          {
            "name": "5.6",
            "annotations": {
              "description": "Provides a MySQL v5.6 database",
              "iconClass": "icon-mysql-database",
              "tags": "mysql",
              "version": "5.6"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/mysql-56-centos7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "mariadb"
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Provides a MariaDB database",
              "iconClass": "icon-mariadb",
              "tags": "mariadb"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "10.1"
            }
          },
          {
            "name": "10.1",
            "annotations": {
              "description": "Provides a MariaDB v10.1 database",
              "iconClass": "icon-mariadb",
              "tags": "mariadb",
              "version": "10.1"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/mariadb-101-centos7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "postgresql"
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Provides a PostgreSQL database",
              "iconClass": "icon-postgresql",
              "tags": "postgresql"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "9.5"
            }
          },
          {
            "name": "9.2",
            "annotations": {
              "description": "Provides a PostgreSQL v9.2 database",
              "iconClass": "icon-postgresql",
              "tags": "postgresql",
              "version": "9.2"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/postgresql-92-centos7:latest"
            }
          },
          {
            "name": "9.4",
            "annotations": {
              "description": "Provides a PostgreSQL v9.4 database",
              "iconClass": "icon-postgresql",
              "tags": "postgresql",
              "version": "9.4"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/postgresql-94-centos7:latest"
            }
          },
          {
            "name": "9.5",
            "annotations": {
              "description": "Provides a PostgreSQL v9.5 database",
              "iconClass": "icon-postgresql",
              "tags": "postgresql",
              "version": "9.5"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/postgresql-95-centos7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "mongodb"
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Provides a MongoDB database",
              "iconClass": "icon-mongodb",
              "tags": "mongodb"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "3.2"
            }
          },
          {
            "name": "2.4",
            "annotations": {
              "description": "Provides a MongoDB v2.4 database",
              "iconClass": "icon-mongodb",
              "tags": "mongodb",
              "version": "2.4"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/mongodb-24-centos7:latest"
            }
          },
          {
            "name": "2.6",
            "annotations": {
              "description": "Provides a MongoDB v2.6 database",
              "iconClass": "icon-mongodb",
              "tags": "mongodb",
              "version": "2.6"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/mongodb-26-centos7:latest"
            }
          },
          {
            "name": "3.2",
            "annotations": {
              "description": "Provides a MongoDB v3.2 database",
              "iconClass": "icon-mongodb",
              "tags": "mongodb",
              "version": "3.2"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/mongodb-32-centos7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "jenkins"
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Provides a Jenkins server",
              "iconClass": "icon-jenkins",
              "tags": "jenkins"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "1"
            }
          },
          {
            "name": "1",
            "annotations": {
              "description": "Provides a Jenkins server",
              "iconClass": "icon-jenkins",
              "tags": "jenkins",
              "version": "1.x"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/jenkins-1-centos7:latest"
            }
          }
        ]
      }
    }
  ]
}
`)

func examplesImageStreamsImageStreamsCentos7JsonBytes() ([]byte, error) {
	return _examplesImageStreamsImageStreamsCentos7Json, nil
}

func examplesImageStreamsImageStreamsCentos7Json() (*asset, error) {
	bytes, err := examplesImageStreamsImageStreamsCentos7JsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/image-streams/image-streams-centos7.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesImageStreamsImageStreamsRhel7Json = []byte(`{
  "kind": "ImageStreamList",
  "apiVersion": "v1",
  "metadata": {},
  "items": [
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "ruby"
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run Ruby applications",
              "iconClass": "icon-ruby",
              "tags": "builder,ruby",
              "supports": "ruby",
              "sampleRepo": "https://github.com/openshift/ruby-ex.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "2.3"
            }
          },
          {
            "name": "2.0",
            "annotations": {
              "description": "Build and run Ruby 2.0 applications",
              "iconClass": "icon-ruby",
              "tags": "builder,ruby",
              "supports": "ruby:2.0,ruby",
              "version": "2.0",
              "sampleRepo": "https://github.com/openshift/ruby-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/openshift3/ruby-20-rhel7:latest"
            }
          },
          {
            "name": "2.2",
            "annotations": {
              "description": "Build and run Ruby 2.2 applications",
              "iconClass": "icon-ruby",
              "tags": "builder,ruby",
              "supports": "ruby:2.2,ruby",
              "version": "2.2",
              "sampleRepo": "https://github.com/openshift/ruby-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/ruby-22-rhel7:latest"
            }
          },
          {
            "name": "2.3",
            "annotations": {
              "description": "Build and run Ruby 2.3 applications",
              "iconClass": "icon-ruby",
              "tags": "builder,ruby",
              "supports": "ruby:2.3,ruby",
              "version": "2.3",
              "sampleRepo": "https://github.com/openshift/ruby-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/ruby-23-rhel7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "nodejs"
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run NodeJS applications",
              "iconClass": "icon-nodejs",
              "tags": "builder,nodejs",
              "supports":"nodejs",
              "sampleRepo": "https://github.com/openshift/nodejs-ex.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "4"
            }
          },
          {
            "name": "0.10",
            "annotations": {
              "description": "Build and run NodeJS 0.10 applications",
              "iconClass": "icon-nodejs",
              "tags": "builder,nodejs",
              "supports":"nodejs:0.10,nodejs:0.1,nodejs",
              "version": "0.10",
              "sampleRepo": "https://github.com/openshift/nodejs-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/openshift3/nodejs-010-rhel7:latest"
            }
          },
          {
            "name": "4",
            "annotations": {
              "description": "Build and run NodeJS 4.x applications",
              "iconClass": "icon-nodejs",
              "tags": "builder,nodejs",
              "supports":"nodejs:4,nodejs",
              "version": "4",
              "sampleRepo": "https://github.com/openshift/nodejs-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/nodejs-4-rhel7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "perl"
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run Perl applications",
              "iconClass": "icon-perl",
              "tags": "builder,perl",
              "supports":"perl",
              "sampleRepo": "https://github.com/openshift/dancer-ex.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "5.20"
            }
          },
          {
            "name": "5.16",
            "annotations": {
              "description": "Build and run Perl 5.16 applications",
              "iconClass": "icon-perl",
              "tags": "builder,perl",
              "supports":"perl:5.16,perl",
              "version": "5.16",
              "sampleRepo": "https://github.com/openshift/dancer-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/openshift3/perl-516-rhel7:latest"
            }
          },
          {
            "name": "5.20",
            "annotations": {
              "description": "Build and run Perl 5.20 applications",
              "iconClass": "icon-perl",
              "tags": "builder,perl",
              "supports":"perl:5.20,perl",
              "version": "5.20",
              "sampleRepo": "https://github.com/openshift/dancer-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/perl-520-rhel7:latest"
            }

          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "php"
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run PHP applications",
              "iconClass": "icon-php",
              "tags": "builder,php",
              "supports":"php",
              "sampleRepo": "https://github.com/openshift/cakephp-ex.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "5.6"
            }
          },
          {
            "name": "5.5",
            "annotations": {
              "description": "Build and run PHP 5.5 applications",
              "iconClass": "icon-php",
              "tags": "builder,php",
              "supports":"php:5.5,php",
              "version": "5.5",
              "sampleRepo": "https://github.com/openshift/cakephp-ex.git"              
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/openshift3/php-55-rhel7:latest"
            }
          },
          {
            "name": "5.6",
            "annotations": {
              "description": "Build and run PHP 5.6 applications",
              "iconClass": "icon-php",
              "tags": "builder,php",
              "supports":"php:5.6,php",
              "version": "5.6",
              "sampleRepo": "https://github.com/openshift/cakephp-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/php-56-rhel7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "python"
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run Python applications",
              "iconClass": "icon-python",
              "tags": "builder,python",
              "supports":"python",
              "sampleRepo": "https://github.com/openshift/django-ex.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "3.5"
            }
          },
          {
            "name": "3.3",
            "annotations": {
              "description": "Build and run Python 3.3 applications",
              "iconClass": "icon-python",
              "tags": "builder,python",
              "supports":"python:3.3,python",
              "version": "3.3",
              "sampleRepo": "https://github.com/openshift/django-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/openshift3/python-33-rhel7:latest"
            }
          },
          {
            "name": "2.7",
            "annotations": {
              "description": "Build and run Python 2.7 applications",
              "iconClass": "icon-python",
              "tags": "builder,python",
              "supports":"python:2.7,python",
              "version": "2.7",
              "sampleRepo": "https://github.com/openshift/django-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/python-27-rhel7:latest"
            }
          },
          {
            "name": "3.4",
            "annotations": {
              "description": "Build and run Python 3.4 applications",
              "iconClass": "icon-python",
              "tags": "builder,python",
              "supports":"python:3.4,python",
              "version": "3.4",
              "sampleRepo": "https://github.com/openshift/django-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/python-34-rhel7:latest"
            }
          },
          {
            "name": "3.5",
            "annotations": {
              "description": "Build and run Python 3.5 applications",
              "iconClass": "icon-python",
              "tags": "builder,python",
              "supports":"python:3.5,python",
              "version": "3.5",
              "sampleRepo": "https://github.com/openshift/django-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/python-35-rhel7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "mysql"
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Provides a MySQL database",
              "iconClass": "icon-mysql-database",
              "tags": "mysql"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "5.6"
            }
          },
          {
            "name": "5.5",
            "annotations": {
              "description": "Provides a MySQL v5.5 database",
              "iconClass": "icon-mysql-database",
              "tags": "mysql",
              "version": "5.5"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/openshift3/mysql-55-rhel7:latest"
            }
          },
          {
            "name": "5.6",
            "annotations": {
              "description": "Provides a MySQL v5.6 database",
              "iconClass": "icon-mysql-database",
              "tags": "mysql",
              "version": "5.6"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/mysql-56-rhel7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "mariadb"
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Provides a MariaDB database",
              "iconClass": "icon-mariadb",
              "tags": "mariadb"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "10.1"
            }
          },
          {
            "name": "10.1",
            "annotations": {
              "description": "Provides a MariaDB v10.1 database",
              "iconClass": "icon-mariadb",
              "tags": "mariadb",
              "version": "10.1"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/mariadb-101-rhel7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "postgresql"
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Provides a PostgreSQL database",
              "iconClass": "icon-postgresql",
              "tags": "postgresql"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "9.5"
            }
          },
          {
            "name": "9.2",
            "annotations": {
              "description": "Provides a PostgreSQL v9.2 database",
              "iconClass": "icon-postgresql",
              "tags": "postgresql",
              "version": "9.2"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/openshift3/postgresql-92-rhel7:latest"
            }
          },
          {
            "name": "9.4",
            "annotations": {
              "description": "Provides a PostgreSQL v9.4 database",
              "iconClass": "icon-postgresql",
              "tags": "postgresql",
              "version": "9.4"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/postgresql-94-rhel7:latest"
            }
          },
          {
            "name": "9.5",
            "annotations": {
              "description": "Provides a PostgreSQL v9.5 database",
              "iconClass": "icon-postgresql",
              "tags": "postgresql",
              "version": "9.5"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/postgresql-95-rhel7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "mongodb"
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Provides a MongoDB database",
              "iconClass": "icon-mongodb",
              "tags": "mongodb"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "3.2"
            }
          },
          {
            "name": "2.4",
            "annotations": {
              "description": "Provides a MongoDB v2.4 database",
              "iconClass": "icon-mongodb",
              "tags": "mongodb",
              "version": "2.4"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/openshift3/mongodb-24-rhel7:latest"
            }
          },
          {
            "name": "2.6",
            "annotations": {
              "description": "Provides a MongoDB v2.6 database",
              "iconClass": "icon-mongodb",
              "tags": "mongodb",
              "version": "2.6"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/mongodb-26-rhel7:latest"
            }
          },
          {
            "name": "3.2",
            "annotations": {
              "description": "Provides a MongoDB v3.2 database",
              "iconClass": "icon-mongodb",
              "tags": "mongodb",
              "version": "3.2"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/mongodb-32-rhel7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "jenkins"
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Provides a Jenkins server",
              "iconClass": "icon-jenkins",
              "tags": "jenkins"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "1"
            }
          },
          {
            "name": "1",
            "annotations": {
              "description": "Provides a Jenkins server",
              "iconClass": "icon-jenkins",
              "tags": "jenkins",
              "version": "1.x"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/openshift3/jenkins-1-rhel7:latest"
            }
          }
        ]
      }
    }
  ]
}
`)

func examplesImageStreamsImageStreamsRhel7JsonBytes() ([]byte, error) {
	return _examplesImageStreamsImageStreamsRhel7Json, nil
}

func examplesImageStreamsImageStreamsRhel7Json() (*asset, error) {
	bytes, err := examplesImageStreamsImageStreamsRhel7JsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/image-streams/image-streams-rhel7.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesDbTemplatesMariadbEphemeralTemplateJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "mariadb-ephemeral",
    "annotations": {
      "description": "MariaDB database service, without persistent storage. WARNING: Any data stored will be lost upon pod destruction. Only use this template for testing",
      "iconClass": "icon-mariadb",
      "tags": "database,mariadb"
    }
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}"
      },
      "spec": {
        "ports": [
          {
            "name": "mariadb",
            "port": 3306
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}"
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "mariadb"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "mariadb:10.1",
                "namespace": "${NAMESPACE}"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "mariadb",
                "image": " ",
                "ports": [
                  {
                    "containerPort": 3306
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 5,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c",
                      "MYSQL_PWD=\"$MYSQL_PASSWORD\" mysql -h 127.0.0.1 -u $MYSQL_USER -D $MYSQL_DATABASE -e 'SELECT 1'"]
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 30,
                  "tcpSocket": {
                    "port": 3306
                  }
                },
                "env": [
                  {
                    "name": "MYSQL_USER",
                    "value": "${MYSQL_USER}"
                  },
                  {
                    "name": "MYSQL_PASSWORD",
                    "value": "${MYSQL_PASSWORD}"
                  },
                  {
                    "name": "MYSQL_DATABASE",
                    "value": "${MYSQL_DATABASE}"
                  }
                ],
                "resources": {
                  "limits": {
                    "memory": "${MEMORY_LIMIT}"
                  }
                },
                "volumeMounts": [
                  {
                    "name": "${DATABASE_SERVICE_NAME}-data",
                    "mountPath": "/var/lib/mysql/data"
                  }
                ],
                "imagePullPolicy": "IfNotPresent"
              }
            ],
            "volumes": [
              {
                "name": "${DATABASE_SERVICE_NAME}-data",
                "emptyDir": {
                  "medium": ""
                }
              }
            ]
          }
        }
      }
    }
  ],
  "parameters": [
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the container can use.",
      "value": "512Mi",
      "required": true
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "description": "The name of the OpenShift Service exposed for the database.",
      "value": "mariadb",
      "required": true
    },
    {
      "name": "MYSQL_USER",
      "displayName": "MariaDB Connection Username",
      "description": "Username for MariaDB user that will be used for accessing the database.",
      "generate": "expression",
      "from": "user[A-Z0-9]{3}",
      "required": true
    },
    {
      "name": "MYSQL_PASSWORD",
      "displayName": "MariaDB Connection Password",
      "description": "Password for the MariaDB connection user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}",
      "required": true
    },
    {
      "name": "MYSQL_DATABASE",
      "displayName": "MariaDB Database Name",
      "description": "Name of the MariaDB database accessed.",
      "value": "sampledb",
      "required": true
    }
  ],
  "labels": {
    "template": "mariadb-persistent-template"
  }
}
`)

func examplesDbTemplatesMariadbEphemeralTemplateJsonBytes() ([]byte, error) {
	return _examplesDbTemplatesMariadbEphemeralTemplateJson, nil
}

func examplesDbTemplatesMariadbEphemeralTemplateJson() (*asset, error) {
	bytes, err := examplesDbTemplatesMariadbEphemeralTemplateJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/db-templates/mariadb-ephemeral-template.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesDbTemplatesMariadbPersistentTemplateJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "mariadb-persistent",
    "annotations": {
      "description": "MariaDB database service, with persistent storage.  Scaling to more than one replica is not supported.  You must have persistent volumes available in your cluster to use this template.",
      "iconClass": "icon-mariadb",
      "tags": "database,mariadb"
    }
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}"
      },
      "spec": {
        "ports": [
          {
            "name": "mariadb",
            "port": 3306
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        }
      }
    },
    {
      "kind": "PersistentVolumeClaim",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}"
      },
      "spec": {
        "accessModes": [
          "ReadWriteOnce"
        ],
        "resources": {
          "requests": {
            "storage": "${VOLUME_CAPACITY}"
          }
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}"
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "mariadb"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "mariadb:10.1",
                "namespace": "${NAMESPACE}"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "mariadb",
                "image": " ",
                "ports": [
                  {
                    "containerPort": 3306
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 5,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c",
                      "MYSQL_PWD=\"$MYSQL_PASSWORD\" mysql -h 127.0.0.1 -u $MYSQL_USER -D $MYSQL_DATABASE -e 'SELECT 1'"]
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 30,
                  "tcpSocket": {
                    "port": 3306
                  }
                },
                "env": [
                  {
                    "name": "MYSQL_USER",
                    "value": "${MYSQL_USER}"
                  },
                  {
                    "name": "MYSQL_PASSWORD",
                    "value": "${MYSQL_PASSWORD}"
                  },
                  {
                    "name": "MYSQL_DATABASE",
                    "value": "${MYSQL_DATABASE}"
                  }
                ],
                "resources": {
                  "limits": {
                    "memory": "${MEMORY_LIMIT}"
                  }
                },
                "volumeMounts": [
                  {
                    "name": "${DATABASE_SERVICE_NAME}-data",
                    "mountPath": "/var/lib/mysql/data"
                  }
                ],
                "imagePullPolicy": "IfNotPresent"
              }
            ],
            "volumes": [
              {
                "name": "${DATABASE_SERVICE_NAME}-data",
                "persistentVolumeClaim": {
                  "claimName": "${DATABASE_SERVICE_NAME}"
                }
              }
            ]
          }
        }
      }
    }
  ],
  "parameters": [
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the container can use.",
      "value": "512Mi",
      "required": true
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "description": "The name of the OpenShift Service exposed for the database.",
      "value": "mariadb",
      "required": true
    },
    {
      "name": "MYSQL_USER",
      "displayName": "MariaDB Connection Username",
      "description": "Username for MariaDB user that will be used for accessing the database.",
      "generate": "expression",
      "from": "user[A-Z0-9]{3}",
      "required": true
    },
    {
      "name": "MYSQL_PASSWORD",
      "displayName": "MariaDB Connection Password",
      "description": "Password for the MariaDB connection user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}",
      "required": true
    },
    {
      "name": "MYSQL_DATABASE",
      "displayName": "MariaDB Database Name",
      "description": "Name of the MariaDB database accessed.",
      "value": "sampledb",
      "required": true
    },
    {
      "name": "VOLUME_CAPACITY",
      "displayName": "Volume Capacity",
      "description": "Volume space available for data, e.g. 512Mi, 2Gi.",
      "value": "1Gi",
      "required": true
    }
  ],
  "labels": {
    "template": "mariadb-persistent-template"
  }
}
`)

func examplesDbTemplatesMariadbPersistentTemplateJsonBytes() ([]byte, error) {
	return _examplesDbTemplatesMariadbPersistentTemplateJson, nil
}

func examplesDbTemplatesMariadbPersistentTemplateJson() (*asset, error) {
	bytes, err := examplesDbTemplatesMariadbPersistentTemplateJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/db-templates/mariadb-persistent-template.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesDbTemplatesMongodbEphemeralTemplateJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "mongodb-ephemeral",
    "creationTimestamp": null,
    "annotations": {
      "description": "MongoDB database service, without persistent storage. WARNING: Any data stored will be lost upon pod destruction. Only use this template for testing",
      "iconClass": "icon-mongodb",
      "tags": "database,mongodb"
    }
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "ports": [
          {
            "name": "mongo",
            "protocol": "TCP",
            "port": 27017,
            "targetPort": 27017,
            "nodePort": 0
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "portalIP": "",
        "type": "ClusterIP",
        "sessionAffinity": "None"
      },
      "status": {
        "loadBalancer": {}
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "mongodb"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "mongodb:3.2",
                "namespace": "${NAMESPACE}"
              },
              "lastTriggeredImage": ""
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "creationTimestamp": null,
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "mongodb",
                "image": " ",
                "ports": [
                  {
                    "containerPort": 27017,
                    "protocol": "TCP"
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 3,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c", "mongo 127.0.0.1:27017/$MONGODB_DATABASE -u $MONGODB_USER -p $MONGODB_PASSWORD --eval=\"quit()\""]
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 30,
                  "tcpSocket": {
                    "port": 27017
                  }
                },
                "env": [
                  {
                    "name": "MONGODB_USER",
                    "value": "${MONGODB_USER}"
                  },
                  {
                    "name": "MONGODB_PASSWORD",
                    "value": "${MONGODB_PASSWORD}"
                  },
                  {
                    "name": "MONGODB_DATABASE",
                    "value": "${MONGODB_DATABASE}"
                  },
                  {
                    "name": "MONGODB_ADMIN_PASSWORD",
                    "value": "${MONGODB_ADMIN_PASSWORD}"
                  }
                ],
                "resources": {
                  "limits": {
                    "memory": "${MEMORY_LIMIT}"
                  }
                },
                "volumeMounts": [
                  {
                    "name": "${DATABASE_SERVICE_NAME}-data",
                    "mountPath": "/var/lib/mongodb/data"
                  }
                ],
                "terminationMessagePath": "/dev/termination-log",
                "imagePullPolicy": "IfNotPresent",
                "capabilities": {},
                "securityContext": {
                  "capabilities": {},
                  "privileged": false
                }
              }
            ],
            "volumes": [
              {
                "name": "${DATABASE_SERVICE_NAME}-data",
                "emptyDir": {
                  "medium": ""
                }
              }
            ],
            "restartPolicy": "Always",
            "dnsPolicy": "ClusterFirst"
          }
        }
      },
      "status": {}
    }
  ],
  "parameters": [
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the container can use.",
      "value": "512Mi"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "description": "The name of the OpenShift Service exposed for the database.",
      "value": "mongodb",
      "required": true
    },
    {
      "name": "MONGODB_USER",
      "displayName": "MongoDB Connection Username",
      "description": "Username for MongoDB user that will be used for accessing the database.",
      "generate": "expression",
      "from": "user[A-Z0-9]{3}",
      "required": true
    },
    {
      "name": "MONGODB_PASSWORD",
      "displayName": "MongoDB Connection Password",
      "description": "Password for the MongoDB connection user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}",
      "required": true
    },
    {
      "name": "MONGODB_DATABASE",
      "displayName": "MongoDB Database Name",
      "description": "Name of the MongoDB database accessed.",
      "value": "sampledb",
      "required": true
    },
    {
      "name": "MONGODB_ADMIN_PASSWORD",
      "displayName": "MongoDB Admin Password",
      "description": "Password for the database admin user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}",
      "required": true
    }
  ],
  "labels": {
    "template": "mongodb-ephemeral-template"
  },
  "message": "You can connect to the database using MongoDB connection URL mongodb://${MONGODB_USER}:${MONGODB_PASSWORD}@${DATABASE_SERVICE_NAME}/${MONGODB_DATABASE}"
}
`)

func examplesDbTemplatesMongodbEphemeralTemplateJsonBytes() ([]byte, error) {
	return _examplesDbTemplatesMongodbEphemeralTemplateJson, nil
}

func examplesDbTemplatesMongodbEphemeralTemplateJson() (*asset, error) {
	bytes, err := examplesDbTemplatesMongodbEphemeralTemplateJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/db-templates/mongodb-ephemeral-template.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesDbTemplatesMongodbPersistentTemplateJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "mongodb-persistent",
    "creationTimestamp": null,
    "annotations": {
      "description": "MongoDB database service, with persistent storage.  Scaling to more than one replica is not supported.  You must have persistent volumes available in your cluster to use this template.",
      "iconClass": "icon-mongodb",
      "tags": "database,mongodb"
    }
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "ports": [
          {
            "name": "mongo",
            "protocol": "TCP",
            "port": 27017,
            "targetPort": 27017,
            "nodePort": 0
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "portalIP": "",
        "type": "ClusterIP",
        "sessionAffinity": "None"
      },
      "status": {
        "loadBalancer": {}
      }
    },
    {
      "kind": "PersistentVolumeClaim",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}"
      },
      "spec": {
        "accessModes": [
          "ReadWriteOnce"
        ],
        "resources": {
          "requests": {
            "storage": "${VOLUME_CAPACITY}"
          }
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "mongodb"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "mongodb:3.2",
                "namespace": "${NAMESPACE}"
              },
              "lastTriggeredImage": ""
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "creationTimestamp": null,
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "mongodb",
                "image": " ",
                "ports": [
                  {
                    "containerPort": 27017,
                    "protocol": "TCP"
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 3,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c", "mongo 127.0.0.1:27017/$MONGODB_DATABASE -u $MONGODB_USER -p $MONGODB_PASSWORD --eval=\"quit()\""]
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 30,
                  "tcpSocket": {
                    "port": 27017
                  }
                },
                "env": [
                  {
                    "name": "MONGODB_USER",
                    "value": "${MONGODB_USER}"
                  },
                  {
                    "name": "MONGODB_PASSWORD",
                    "value": "${MONGODB_PASSWORD}"
                  },
                  {
                    "name": "MONGODB_DATABASE",
                    "value": "${MONGODB_DATABASE}"
                  },
                  {
                    "name": "MONGODB_ADMIN_PASSWORD",
                    "value": "${MONGODB_ADMIN_PASSWORD}"
                  }
                ],
                "resources": {
                  "limits": {
                    "memory": "${MEMORY_LIMIT}"
                  }
                },
                "volumeMounts": [
                  {
                    "name": "${DATABASE_SERVICE_NAME}-data",
                    "mountPath": "/var/lib/mongodb/data"
                  }
                ],
                "terminationMessagePath": "/dev/termination-log",
                "imagePullPolicy": "IfNotPresent",
                "capabilities": {},
                "securityContext": {
                  "capabilities": {},
                  "privileged": false
                }
              }
            ],
            "volumes": [
              {
                "name": "${DATABASE_SERVICE_NAME}-data",
                "persistentVolumeClaim": {
                  "claimName": "${DATABASE_SERVICE_NAME}"
                }
              }
            ],
            "restartPolicy": "Always",
            "dnsPolicy": "ClusterFirst"
          }
        }
      },
      "status": {}
    }
  ],
  "parameters": [
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the container can use.",
      "value": "512Mi"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "description": "The name of the OpenShift Service exposed for the database.",
      "value": "mongodb",
      "required": true
    },
    {
      "name": "MONGODB_USER",
      "displayName": "MongoDB Connection Username",
      "description": "Username for MongoDB user that will be used for accessing the database.",
      "generate": "expression",
      "from": "user[A-Z0-9]{3}",
      "required": true
    },
    {
      "name": "MONGODB_PASSWORD",
      "displayName": "MongoDB Connection Password",
      "description": "Password for the MongoDB connection user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}",
      "required": true
    },
    {
      "name": "MONGODB_DATABASE",
      "displayName": "MongoDB Database Name",
      "description": "Name of the MongoDB database accessed.",
      "value": "sampledb",
      "required": true
    },
    {
      "name": "MONGODB_ADMIN_PASSWORD",
      "displayName": "MongoDB Admin Password",
      "description": "Password for the database admin user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}",
      "required": true
    },
    {
      "name": "VOLUME_CAPACITY",
      "displayName": "Volume Capacity",
      "description": "Volume space available for data, e.g. 512Mi, 2Gi.",
      "value": "1Gi",
      "required": true
    }
  ],
  "labels": {
    "template": "mongodb-persistent-template"
  },
  "message": "You can connect to the database using MongoDB connection URL mongodb://${MONGODB_USER}:${MONGODB_PASSWORD}@${DATABASE_SERVICE_NAME}/${MONGODB_DATABASE}"
}
`)

func examplesDbTemplatesMongodbPersistentTemplateJsonBytes() ([]byte, error) {
	return _examplesDbTemplatesMongodbPersistentTemplateJson, nil
}

func examplesDbTemplatesMongodbPersistentTemplateJson() (*asset, error) {
	bytes, err := examplesDbTemplatesMongodbPersistentTemplateJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/db-templates/mongodb-persistent-template.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesDbTemplatesMysqlEphemeralTemplateJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "mysql-ephemeral",
    "annotations": {
      "description": "MySQL database service, without persistent storage. WARNING: Any data stored will be lost upon pod destruction. Only use this template for testing",
      "iconClass": "icon-mysql-database",
      "tags": "database,mysql"
    }
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "ports": [
          {
            "name": "mysql",
            "protocol": "TCP",
            "port": 3306,
            "targetPort": 3306,
            "nodePort": 0
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "portalIP": "",
        "type": "ClusterIP",
        "sessionAffinity": "None"
      },
      "status": {
        "loadBalancer": {}
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "mysql"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "mysql:5.6",
                "namespace": "${NAMESPACE}"
              },
              "lastTriggeredImage": ""
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "creationTimestamp": null,
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "mysql",
                "image": " ",
                "ports": [
                  {
                    "containerPort": 3306,
                    "protocol": "TCP"
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 5,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c",
                      "MYSQL_PWD=\"$MYSQL_PASSWORD\" mysql -h 127.0.0.1 -u $MYSQL_USER -D $MYSQL_DATABASE -e 'SELECT 1'"]
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 30,
                  "tcpSocket": {
                    "port": 3306
                  }
                },
                "env": [
                  {
                    "name": "MYSQL_USER",
                    "value": "${MYSQL_USER}"
                  },
                  {
                    "name": "MYSQL_PASSWORD",
                    "value": "${MYSQL_PASSWORD}"
                  },
                  {
                    "name": "MYSQL_DATABASE",
                    "value": "${MYSQL_DATABASE}"
                  }
                ],
                "resources": {
                  "limits": {
                    "memory": "${MEMORY_LIMIT}"
                  }
                },
                "volumeMounts": [
                  {
                    "name": "${DATABASE_SERVICE_NAME}-data",
                    "mountPath": "/var/lib/mysql/data"
                  }
                ],
                "terminationMessagePath": "/dev/termination-log",
                "imagePullPolicy": "IfNotPresent",
                "capabilities": {},
                "securityContext": {
                  "capabilities": {},
                  "privileged": false
                }
              }
            ],
            "volumes": [
              {
                "name": "${DATABASE_SERVICE_NAME}-data",
                "emptyDir": {
                  "medium": ""
                }
              }
            ],
            "restartPolicy": "Always",
            "dnsPolicy": "ClusterFirst"
          }
        }
      },
      "status": {}
    }
  ],
  "parameters": [
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the container can use.",
      "value": "512Mi"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "description": "The name of the OpenShift Service exposed for the database.",
      "value": "mysql",
      "required": true
    },
    {
      "name": "MYSQL_USER",
      "displayName": "MySQL Connection Username",
      "description": "Username for MySQL user that will be used for accessing the database.",
      "generate": "expression",
      "from": "user[A-Z0-9]{3}",
      "required": true
    },
    {
      "name": "MYSQL_PASSWORD",
      "displayName": "MySQL Connection Password",
      "description": "Password for the MySQL connection user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}",
      "required": true
    },
    {
      "name": "MYSQL_DATABASE",
      "displayName": "MySQL Database Name",
      "description": "Name of the MySQL database accessed.",
      "value": "sampledb",
      "required": true
    }
  ],
  "labels": {
    "template": "mysql-ephemeral-template"
  }
}
`)

func examplesDbTemplatesMysqlEphemeralTemplateJsonBytes() ([]byte, error) {
	return _examplesDbTemplatesMysqlEphemeralTemplateJson, nil
}

func examplesDbTemplatesMysqlEphemeralTemplateJson() (*asset, error) {
	bytes, err := examplesDbTemplatesMysqlEphemeralTemplateJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/db-templates/mysql-ephemeral-template.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesDbTemplatesMysqlPersistentTemplateJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "mysql-persistent",
    "annotations": {
      "description": "MySQL database service, with persistent storage.  Scaling to more than one replica is not supported.  You must have persistent volumes available in your cluster to use this template.",
      "iconClass": "icon-mysql-database",
      "tags": "database,mysql"
    }
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}"
      },
      "spec": {
        "ports": [
          {
            "name": "mysql",
            "port": 3306
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        }
      }
    },
    {
      "kind": "PersistentVolumeClaim",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}"
      },
      "spec": {
        "accessModes": [
          "ReadWriteOnce"
        ],
        "resources": {
          "requests": {
            "storage": "${VOLUME_CAPACITY}"
          }
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}"
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "mysql"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "mysql:5.6",
                "namespace": "${NAMESPACE}"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "mysql",
                "image": " ",
                "ports": [
                  {
                    "containerPort": 3306
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 5,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c",
                      "MYSQL_PWD=\"$MYSQL_PASSWORD\" mysql -h 127.0.0.1 -u $MYSQL_USER -D $MYSQL_DATABASE -e 'SELECT 1'"]
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 30,
                  "tcpSocket": {
                    "port": 3306
                  }
                },
                "env": [
                  {
                    "name": "MYSQL_USER",
                    "value": "${MYSQL_USER}"
                  },
                  {
                    "name": "MYSQL_PASSWORD",
                    "value": "${MYSQL_PASSWORD}"
                  },
                  {
                    "name": "MYSQL_DATABASE",
                    "value": "${MYSQL_DATABASE}"
                  }
                ],
                "resources": {
                  "limits": {
                    "memory": "${MEMORY_LIMIT}"
                  }
                },
                "volumeMounts": [
                  {
                    "name": "${DATABASE_SERVICE_NAME}-data",
                    "mountPath": "/var/lib/mysql/data"
                  }
                ],
                "imagePullPolicy": "IfNotPresent"
              }
            ],
            "volumes": [
              {
                "name": "${DATABASE_SERVICE_NAME}-data",
                "persistentVolumeClaim": {
                  "claimName": "${DATABASE_SERVICE_NAME}"
                }
              }
            ]
          }
        }
      }
    }
  ],
  "parameters": [
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the container can use.",
      "value": "512Mi",
      "required": true
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "description": "The name of the OpenShift Service exposed for the database.",
      "value": "mysql",
      "required": true
    },
    {
      "name": "MYSQL_USER",
      "displayName": "MySQL Connection Username",
      "description": "Username for MySQL user that will be used for accessing the database.",
      "generate": "expression",
      "from": "user[A-Z0-9]{3}",
      "required": true
    },
    {
      "name": "MYSQL_PASSWORD",
      "displayName": "MySQL Connection Password",
      "description": "Password for the MySQL connection user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}",
      "required": true
    },
    {
      "name": "MYSQL_DATABASE",
      "displayName": "MySQL Database Name",
      "description": "Name of the MySQL database accessed.",
      "value": "sampledb",
      "required": true
    },
    {
      "name": "VOLUME_CAPACITY",
      "displayName": "Volume Capacity",
      "description": "Volume space available for data, e.g. 512Mi, 2Gi.",
      "value": "1Gi",
      "required": true
    }
  ],
  "labels": {
    "template": "mysql-persistent-template"
  }
}
`)

func examplesDbTemplatesMysqlPersistentTemplateJsonBytes() ([]byte, error) {
	return _examplesDbTemplatesMysqlPersistentTemplateJson, nil
}

func examplesDbTemplatesMysqlPersistentTemplateJson() (*asset, error) {
	bytes, err := examplesDbTemplatesMysqlPersistentTemplateJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/db-templates/mysql-persistent-template.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesDbTemplatesPostgresqlEphemeralTemplateJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "postgresql-ephemeral",
    "creationTimestamp": null,
    "annotations": {
      "description": "PostgreSQL database service, without persistent storage. WARNING: Any data stored will be lost upon pod destruction. Only use this template for testing",
      "iconClass": "icon-postgresql",
      "tags": "database,postgresql"
    }
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "ports": [
          {
            "name": "postgresql",
            "protocol": "TCP",
            "port": 5432,
            "targetPort": 5432,
            "nodePort": 0
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "portalIP": "",
        "type": "ClusterIP",
        "sessionAffinity": "None"
      },
      "status": {
        "loadBalancer": {}
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "postgresql"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "postgresql:9.5",
                "namespace": "${NAMESPACE}"
              },
              "lastTriggeredImage": ""
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "creationTimestamp": null,
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "postgresql",
                "image": " ",
                "ports": [
                  {
                    "containerPort": 5432,
                    "protocol": "TCP"
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 5,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c", "psql -h 127.0.0.1 -U $POSTGRESQL_USER -q -d $POSTGRESQL_DATABASE -c 'SELECT 1'"]
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 30,
                  "tcpSocket": {
                    "port": 5432
                  }
                },
                "env": [
                  {
                    "name": "POSTGRESQL_USER",
                    "value": "${POSTGRESQL_USER}"
                  },
                  {
                    "name": "POSTGRESQL_PASSWORD",
                    "value": "${POSTGRESQL_PASSWORD}"
                  },
                  {
                    "name": "POSTGRESQL_DATABASE",
                    "value": "${POSTGRESQL_DATABASE}"
                  }
                ],
                "resources": {
                  "limits": {
                    "memory": "${MEMORY_LIMIT}"
                  }
                },
                "volumeMounts": [
                  {
                    "name": "${DATABASE_SERVICE_NAME}-data",
                    "mountPath": "/var/lib/pgsql/data"
                  }
                ],
                "terminationMessagePath": "/dev/termination-log",
                "imagePullPolicy": "IfNotPresent",
                "capabilities": {},
                "securityContext": {
                  "capabilities": {},
                  "privileged": false
                }
              }
            ],
            "volumes": [
              {
                "name": "${DATABASE_SERVICE_NAME}-data",
                "emptyDir": {
                  "medium": ""
                }
              }
            ],
            "restartPolicy": "Always",
            "dnsPolicy": "ClusterFirst"
          }
        }
      },
      "status": {}
    }
  ],
  "parameters": [
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the container can use.",
      "value": "512Mi"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "description": "The name of the OpenShift Service exposed for the database.",
      "value": "postgresql",
      "required": true
    },
    {
      "name": "POSTGRESQL_USER",
      "displayName": "PostgreSQL Connection Username",
      "description": "Username for PostgreSQL user that will be used for accessing the database.",
      "generate": "expression",
      "from": "user[A-Z0-9]{3}",
      "required": true
    },
    {
      "name": "POSTGRESQL_PASSWORD",
      "displayName": "PostgreSQL Connection Password",
      "description": "Password for the PostgreSQL connection user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}",
      "required": true
    },
    {
      "name": "POSTGRESQL_DATABASE",
      "displayName": "PostgreSQL Database Name",
      "description": "Name of the PostgreSQL database accessed.",
      "value": "sampledb",
      "required": true
    }
  ],
  "labels": {
    "template": "postgresql-ephemeral-template"
  }
}
`)

func examplesDbTemplatesPostgresqlEphemeralTemplateJsonBytes() ([]byte, error) {
	return _examplesDbTemplatesPostgresqlEphemeralTemplateJson, nil
}

func examplesDbTemplatesPostgresqlEphemeralTemplateJson() (*asset, error) {
	bytes, err := examplesDbTemplatesPostgresqlEphemeralTemplateJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/db-templates/postgresql-ephemeral-template.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesDbTemplatesPostgresqlPersistentTemplateJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "postgresql-persistent",
    "creationTimestamp": null,
    "annotations": {
      "description": "PostgreSQL database service, with persistent storage.  Scaling to more than one replica is not supported.  You must have persistent volumes available in your cluster to use this template.",
      "iconClass": "icon-postgresql",
      "tags": "database,postgresql"
    }
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "ports": [
          {
            "name": "postgresql",
            "protocol": "TCP",
            "port": 5432,
            "targetPort": 5432,
            "nodePort": 0
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "portalIP": "",
        "type": "ClusterIP",
        "sessionAffinity": "None"
      },
      "status": {
        "loadBalancer": {}
      }
    },
    {
      "kind": "PersistentVolumeClaim",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}"
      },
      "spec": {
        "accessModes": [
          "ReadWriteOnce"
        ],
        "resources": {
          "requests": {
            "storage": "${VOLUME_CAPACITY}"
          }
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "postgresql"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "postgresql:9.5",
                "namespace": "${NAMESPACE}"
              },
              "lastTriggeredImage": ""
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "creationTimestamp": null,
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "postgresql",
                "image": " ",
                "ports": [
                  {
                    "containerPort": 5432,
                    "protocol": "TCP"
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 5,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c", "psql -h 127.0.0.1 -U $POSTGRESQL_USER -q -d $POSTGRESQL_DATABASE -c 'SELECT 1'"]
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 30,
                  "tcpSocket": {
                    "port": 5432
                  }
                },
                "env": [
                  {
                    "name": "POSTGRESQL_USER",
                    "value": "${POSTGRESQL_USER}"
                  },
                  {
                    "name": "POSTGRESQL_PASSWORD",
                    "value": "${POSTGRESQL_PASSWORD}"
                  },
                  {
                    "name": "POSTGRESQL_DATABASE",
                    "value": "${POSTGRESQL_DATABASE}"
                  }
                ],
                "resources": {
                  "limits": {
                    "memory": "${MEMORY_LIMIT}"
                  }
                },
                "volumeMounts": [
                  {
                    "name": "${DATABASE_SERVICE_NAME}-data",
                    "mountPath": "/var/lib/pgsql/data"
                  }
                ],
                "terminationMessagePath": "/dev/termination-log",
                "imagePullPolicy": "IfNotPresent",
                "capabilities": {},
                "securityContext": {
                  "capabilities": {},
                  "privileged": false
                }
              }
            ],
            "volumes": [
              {
                "name": "${DATABASE_SERVICE_NAME}-data",
                "persistentVolumeClaim": {
                  "claimName": "${DATABASE_SERVICE_NAME}"
                }
              }
            ],
            "restartPolicy": "Always",
            "dnsPolicy": "ClusterFirst"
          }
        }
      },
      "status": {}
    }
  ],
  "parameters": [
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the container can use.",
      "value": "512Mi"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "description": "The name of the OpenShift Service exposed for the database.",
      "value": "postgresql",
      "required": true
    },
    {
      "name": "POSTGRESQL_USER",
      "displayName": "PostgreSQL Connection Username",
      "description": "Username for PostgreSQL user that will be used for accessing the database.",
      "generate": "expression",
      "from": "user[A-Z0-9]{3}",
      "required": true
    },
    {
      "name": "POSTGRESQL_PASSWORD",
      "displayName": "PostgreSQL Connection Password",
      "description": "Password for the PostgreSQL connection user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}",
      "required": true
    },
    {
      "name": "POSTGRESQL_DATABASE",
      "displayName": "PostgreSQL Database Name",
      "description": "Name of the PostgreSQL database accessed.",
      "value": "sampledb",
      "required": true
    },
    {
      "name": "VOLUME_CAPACITY",
      "displayName": "Volume Capacity",
      "description": "Volume space available for data, e.g. 512Mi, 2Gi.",
      "value": "1Gi",
      "required": true
    }
  ],
  "labels": {
    "template": "postgresql-persistent-template"
  }
}
`)

func examplesDbTemplatesPostgresqlPersistentTemplateJsonBytes() ([]byte, error) {
	return _examplesDbTemplatesPostgresqlPersistentTemplateJson, nil
}

func examplesDbTemplatesPostgresqlPersistentTemplateJson() (*asset, error) {
	bytes, err := examplesDbTemplatesPostgresqlPersistentTemplateJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/db-templates/postgresql-persistent-template.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesJenkinsJenkinsEphemeralTemplateJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "jenkins-ephemeral",
    "creationTimestamp": null,
    "annotations": {
      "description": "Jenkins service, without persistent storage.\nWARNING: Any data stored will be lost upon pod destruction. Only use this template for testing",
      "iconClass": "icon-jenkins",
      "tags": "instant-app,jenkins"
    }
  },
  "message": "A Jenkins service has been created in your project.  The username/password are admin/${JENKINS_PASSWORD}.  The tutorial at https://github.com/openshift/origin/blob/master/examples/jenkins/README.md contains more information about using this template.",
  "objects": [
    {
      "kind": "Route",
      "apiVersion": "v1",
      "metadata": {
        "name": "${JENKINS_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "to": {
          "kind": "Service",
          "name": "${JENKINS_SERVICE_NAME}"
        },
        "tls": {
          "termination": "edge",
          "insecureEdgeTerminationPolicy": "Redirect",
          "certificate": "-----BEGIN CERTIFICATE-----\nMIIDIjCCAgqgAwIBAgIBATANBgkqhkiG9w0BAQUFADCBoTELMAkGA1UEBhMCVVMx\nCzAJBgNVBAgMAlNDMRUwEwYDVQQHDAxEZWZhdWx0IENpdHkxHDAaBgNVBAoME0Rl\nZmF1bHQgQ29tcGFueSBMdGQxEDAOBgNVBAsMB1Rlc3QgQ0ExGjAYBgNVBAMMEXd3\ndy5leGFtcGxlY2EuY29tMSIwIAYJKoZIhvcNAQkBFhNleGFtcGxlQGV4YW1wbGUu\nY29tMB4XDTE1MDExMjE0MTk0MVoXDTE2MDExMjE0MTk0MVowfDEYMBYGA1UEAwwP\nd3d3LmV4YW1wbGUuY29tMQswCQYDVQQIDAJTQzELMAkGA1UEBhMCVVMxIjAgBgkq\nhkiG9w0BCQEWE2V4YW1wbGVAZXhhbXBsZS5jb20xEDAOBgNVBAoMB0V4YW1wbGUx\nEDAOBgNVBAsMB0V4YW1wbGUwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAMrv\ngu6ZTTefNN7jjiZbS/xvQjyXjYMN7oVXv76jbX8gjMOmg9m0xoVZZFAE4XyQDuCm\n47VRx5Qrf/YLXmB2VtCFvB0AhXr5zSeWzPwaAPrjA4ebG+LUo24ziS8KqNxrFs1M\nmNrQUgZyQC6XIe1JHXc9t+JlL5UZyZQC1IfaJulDAgMBAAGjDTALMAkGA1UdEwQC\nMAAwDQYJKoZIhvcNAQEFBQADggEBAFCi7ZlkMnESvzlZCvv82Pq6S46AAOTPXdFd\nTMvrh12E1sdVALF1P1oYFJzG1EiZ5ezOx88fEDTW+Lxb9anw5/KJzwtWcfsupf1m\nV7J0D3qKzw5C1wjzYHh9/Pz7B1D0KthQRATQCfNf8s6bbFLaw/dmiIUhHLtIH5Qc\nyfrejTZbOSP77z8NOWir+BWWgIDDB2//3AkDIQvT20vmkZRhkqSdT7et4NmXOX/j\njhPti4b2Fie0LeuvgaOdKjCpQQNrYthZHXeVlOLRhMTSk3qUczenkKTOhvP7IS9q\n+Dzv5hqgSfvMG392KWh5f8xXfJNs4W5KLbZyl901MeReiLrPH3w=\n-----END CERTIFICATE-----",
          "key": "-----BEGIN PRIVATE KEY-----\nMIICeAIBADANBgkqhkiG9w0BAQEFAASCAmIwggJeAgEAAoGBAMrvgu6ZTTefNN7j\njiZbS/xvQjyXjYMN7oVXv76jbX8gjMOmg9m0xoVZZFAE4XyQDuCm47VRx5Qrf/YL\nXmB2VtCFvB0AhXr5zSeWzPwaAPrjA4ebG+LUo24ziS8KqNxrFs1MmNrQUgZyQC6X\nIe1JHXc9t+JlL5UZyZQC1IfaJulDAgMBAAECgYEAnxOjEj/vrLNLMZE1Q9H7PZVF\nWdP/JQVNvQ7tCpZ3ZdjxHwkvf//aQnuxS5yX2Rnf37BS/TZu+TIkK4373CfHomSx\nUTAn2FsLmOJljupgGcoeLx5K5nu7B7rY5L1NHvdpxZ4YjeISrRtEPvRakllENU5y\ngJE8c2eQOx08ZSRE4TkCQQD7dws2/FldqwdjJucYijsJVuUdoTqxP8gWL6bB251q\nelP2/a6W2elqOcWId28560jG9ZS3cuKvnmu/4LG88vZFAkEAzphrH3673oTsHN+d\nuBd5uyrlnGjWjuiMKv2TPITZcWBjB8nJDSvLneHF59MYwejNNEof2tRjgFSdImFH\nmi995wJBAMtPjW6wiqRz0i41VuT9ZgwACJBzOdvzQJfHgSD9qgFb1CU/J/hpSRIM\nkYvrXK9MbvQFvG6x4VuyT1W8mpe1LK0CQAo8VPpffhFdRpF7psXLK/XQ/0VLkG3O\nKburipLyBg/u9ZkaL0Ley5zL5dFBjTV2Qkx367Ic2b0u9AYTCcgi2DsCQQD3zZ7B\nv7BOm7MkylKokY2MduFFXU0Bxg6pfZ7q3rvg8gqhUFbaMStPRYg6myiDiW/JfLhF\nTcFT4touIo7oriFJ\n-----END PRIVATE KEY-----",
          "caCertificate": "-----BEGIN CERTIFICATE-----\nMIIEFzCCAv+gAwIBAgIJALK1iUpF2VQLMA0GCSqGSIb3DQEBBQUAMIGhMQswCQYD\nVQQGEwJVUzELMAkGA1UECAwCU0MxFTATBgNVBAcMDERlZmF1bHQgQ2l0eTEcMBoG\nA1UECgwTRGVmYXVsdCBDb21wYW55IEx0ZDEQMA4GA1UECwwHVGVzdCBDQTEaMBgG\nA1UEAwwRd3d3LmV4YW1wbGVjYS5jb20xIjAgBgkqhkiG9w0BCQEWE2V4YW1wbGVA\nZXhhbXBsZS5jb20wHhcNMTUwMTEyMTQxNTAxWhcNMjUwMTA5MTQxNTAxWjCBoTEL\nMAkGA1UEBhMCVVMxCzAJBgNVBAgMAlNDMRUwEwYDVQQHDAxEZWZhdWx0IENpdHkx\nHDAaBgNVBAoME0RlZmF1bHQgQ29tcGFueSBMdGQxEDAOBgNVBAsMB1Rlc3QgQ0Ex\nGjAYBgNVBAMMEXd3dy5leGFtcGxlY2EuY29tMSIwIAYJKoZIhvcNAQkBFhNleGFt\ncGxlQGV4YW1wbGUuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nw2rK1J2NMtQj0KDug7g7HRKl5jbf0QMkMKyTU1fBtZ0cCzvsF4CqV11LK4BSVWaK\nrzkaXe99IVJnH8KdOlDl5Dh/+cJ3xdkClSyeUT4zgb6CCBqg78ePp+nN11JKuJlV\nIG1qdJpB1J5O/kCLsGcTf7RS74MtqMFo96446Zvt7YaBhWPz6gDaO/TUzfrNcGLA\nEfHVXkvVWqb3gqXUztZyVex/gtP9FXQ7gxTvJml7UkmT0VAFjtZnCqmFxpLZFZ15\n+qP9O7Q2MpsGUO/4vDAuYrKBeg1ZdPSi8gwqUP2qWsGd9MIWRv3thI2903BczDc7\nr8WaIbm37vYZAS9G56E4+wIDAQABo1AwTjAdBgNVHQ4EFgQUugLrSJshOBk5TSsU\nANs4+SmJUGwwHwYDVR0jBBgwFoAUugLrSJshOBk5TSsUANs4+SmJUGwwDAYDVR0T\nBAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEAaMJ33zAMV4korHo5aPfayV3uHoYZ\n1ChzP3eSsF+FjoscpoNSKs91ZXZF6LquzoNezbfiihK4PYqgwVD2+O0/Ty7UjN4S\nqzFKVR4OS/6lCJ8YncxoFpTntbvjgojf1DEataKFUN196PAANc3yz8cWHF4uvjPv\nWkgFqbIjb+7D1YgglNyovXkRDlRZl0LD1OQ0ZWhd4Ge1qx8mmmanoBeYZ9+DgpFC\nj9tQAbS867yeOryNe7sEOIpXAAqK/DTu0hB6+ySsDfMo4piXCc2aA/eI2DCuw08e\nw17Dz9WnupZjVdwTKzDhFgJZMLDqn37HQnT6EemLFqbcR0VPEnfyhDtZIQ==\n-----END CERTIFICATE-----"
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${JENKINS_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "jenkins"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "${JENKINS_IMAGE_STREAM_TAG}",
                "namespace": "${NAMESPACE}"
              },
              "lastTriggeredImage": ""
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${JENKINS_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "creationTimestamp": null,
            "labels": {
              "name": "${JENKINS_SERVICE_NAME}"
            }
          },
          "spec": {
            "serviceAccountName": "${JENKINS_SERVICE_NAME}",
            "containers": [
              {
                "name": "jenkins",
                "image": " ",
                "readinessProbe": {
                  "timeoutSeconds": 3,
                  "initialDelaySeconds": 3,
                  "httpGet": {
                    "path": "/login",
                    "port": 8080
                  }
                },
                "livenessProbe": {
                    "timeoutSeconds": 3,
                    "initialDelaySeconds": 120,
                    "httpGet": {
                        "path": "/login",
                        "port": 8080
                    }
                },
                "env": [
                  {
                    "name": "JENKINS_PASSWORD",
                    "value": "${JENKINS_PASSWORD}"
                  },
                  {
                    "name": "KUBERNETES_MASTER",
                    "value": "https://kubernetes.default:443"
                  },
                  {
                    "name": "KUBERNETES_TRUST_CERTIFICATES",
                    "value": "true"
                  },
                  {
                    "name": "JNLP_SERVICE_NAME",
                    "value": "${JNLP_SERVICE_NAME}"
                  }
                ],
                "resources": {
                  "limits": {
                    "memory": "${MEMORY_LIMIT}"
                  }
                },
                "volumeMounts": [
                  {
                    "name": "${JENKINS_SERVICE_NAME}-data",
                    "mountPath": "/var/lib/jenkins"
                  }
                ],
                "terminationMessagePath": "/dev/termination-log",
                "imagePullPolicy": "IfNotPresent",
                "capabilities": {},
                "securityContext": {
                  "capabilities": {},
                  "privileged": false
                }
              }
            ],
            "volumes": [
              {
                "name": "${JENKINS_SERVICE_NAME}-data",
                "emptyDir": {
                  "medium": ""
                }
              }
            ],
            "restartPolicy": "Always",
            "dnsPolicy": "ClusterFirst"
          }
        }
      }
    },
    {
      "kind": "ServiceAccount",
        "apiVersion": "v1",
        "metadata": {
            "name": "${JENKINS_SERVICE_NAME}"
        }
    },
    {
      "kind": "RoleBinding",
      "apiVersion": "v1",
      "metadata": {
          "name": "${JENKINS_SERVICE_NAME}_edit"
      },
      "groupNames": null,
      "subjects": [
          {
              "kind": "ServiceAccount",
              "name": "${JENKINS_SERVICE_NAME}"
          }
      ],
      "roleRef": {
          "name": "edit"
      }
    },
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${JNLP_SERVICE_NAME}"
      },
      "spec": {
        "ports": [
          {
            "name": "agent",
            "protocol": "TCP",
            "port": 50000,
            "targetPort": 50000,
            "nodePort": 0
          }
        ],
        "selector": {
          "name": "${JENKINS_SERVICE_NAME}"
        },
        "portalIP": "",
        "type": "ClusterIP",
        "sessionAffinity": "None"
      }
    },
    {
       "kind": "Service",
       "apiVersion": "v1",
       "metadata": {
         "name": "${JENKINS_SERVICE_NAME}",
         "annotations": {
           "service.alpha.openshift.io/dependencies": "[{\"name\": \"${JNLP_SERVICE_NAME}\", \"namespace\": \"\", \"kind\": \"Service\"}]",
           "service.openshift.io/infrastructure": "true"
         },
         "creationTimestamp": null
       },
       "spec": {
         "ports": [
           {
             "name": "web",
             "protocol": "TCP",
             "port": 80,
             "targetPort": 8080,
             "nodePort": 0
           }
         ],
         "selector": {
           "name": "${JENKINS_SERVICE_NAME}"
         },
         "portalIP": "",
         "type": "ClusterIP",
         "sessionAffinity": "None"
       }
    }
  ],
  "parameters": [
    {
      "name": "JENKINS_SERVICE_NAME",
      "displayName": "Jenkins Service Name",
      "description": "The name of the OpenShift Service exposed for the Jenkins container.",
      "value": "jenkins"
    },
    {
      "name": "JNLP_SERVICE_NAME",
      "displayName": "Jenkins JNLP Service Name",
      "description": "The name of the service used for master/slave communication.",
      "value": "jenkins-jnlp"
    },
    {
      "name": "JENKINS_PASSWORD",
      "displayName": "Jenkins Password",
      "description": "Password for the Jenkins 'admin' user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}",
      "required": true
    },
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the container can use.",
      "value": "512Mi"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Jenkins ImageStream Namespace",
      "description": "The OpenShift Namespace where the Jenkins ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "JENKINS_IMAGE_STREAM_TAG",
      "displayName": "Jenkins ImageStreamTag",
      "description": "Name of the ImageStreamTag to be used for the Jenkins image.",
      "value": "jenkins:latest"
    }
  ],
  "labels": {
    "template": "jenkins-ephemeral-template"
  }
}
`)

func examplesJenkinsJenkinsEphemeralTemplateJsonBytes() ([]byte, error) {
	return _examplesJenkinsJenkinsEphemeralTemplateJson, nil
}

func examplesJenkinsJenkinsEphemeralTemplateJson() (*asset, error) {
	bytes, err := examplesJenkinsJenkinsEphemeralTemplateJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/jenkins/jenkins-ephemeral-template.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesJenkinsJenkinsPersistentTemplateJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "jenkins-persistent",
    "creationTimestamp": null,
    "annotations": {
      "description": "Jenkins service, with persistent storage.\nYou must have persistent volumes available in your cluster to use this template.",
      "iconClass": "icon-jenkins",
      "tags": "instant-app,jenkins"
    }
  },
  "message": "A Jenkins service has been created in your project.  The username/password are admin/${JENKINS_PASSWORD}.  The tutorial at https://github.com/openshift/origin/blob/master/examples/jenkins/README.md contains more information about using this template.",
  "objects": [
    {
      "kind": "Route",
      "apiVersion": "v1",
      "metadata": {
        "name": "${JENKINS_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "to": {
          "kind": "Service",
          "name": "${JENKINS_SERVICE_NAME}"
        },
        "tls": {
          "termination": "edge",
          "insecureEdgeTerminationPolicy": "Redirect",
          "certificate": "-----BEGIN CERTIFICATE-----\nMIIDIjCCAgqgAwIBAgIBATANBgkqhkiG9w0BAQUFADCBoTELMAkGA1UEBhMCVVMx\nCzAJBgNVBAgMAlNDMRUwEwYDVQQHDAxEZWZhdWx0IENpdHkxHDAaBgNVBAoME0Rl\nZmF1bHQgQ29tcGFueSBMdGQxEDAOBgNVBAsMB1Rlc3QgQ0ExGjAYBgNVBAMMEXd3\ndy5leGFtcGxlY2EuY29tMSIwIAYJKoZIhvcNAQkBFhNleGFtcGxlQGV4YW1wbGUu\nY29tMB4XDTE1MDExMjE0MTk0MVoXDTE2MDExMjE0MTk0MVowfDEYMBYGA1UEAwwP\nd3d3LmV4YW1wbGUuY29tMQswCQYDVQQIDAJTQzELMAkGA1UEBhMCVVMxIjAgBgkq\nhkiG9w0BCQEWE2V4YW1wbGVAZXhhbXBsZS5jb20xEDAOBgNVBAoMB0V4YW1wbGUx\nEDAOBgNVBAsMB0V4YW1wbGUwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAMrv\ngu6ZTTefNN7jjiZbS/xvQjyXjYMN7oVXv76jbX8gjMOmg9m0xoVZZFAE4XyQDuCm\n47VRx5Qrf/YLXmB2VtCFvB0AhXr5zSeWzPwaAPrjA4ebG+LUo24ziS8KqNxrFs1M\nmNrQUgZyQC6XIe1JHXc9t+JlL5UZyZQC1IfaJulDAgMBAAGjDTALMAkGA1UdEwQC\nMAAwDQYJKoZIhvcNAQEFBQADggEBAFCi7ZlkMnESvzlZCvv82Pq6S46AAOTPXdFd\nTMvrh12E1sdVALF1P1oYFJzG1EiZ5ezOx88fEDTW+Lxb9anw5/KJzwtWcfsupf1m\nV7J0D3qKzw5C1wjzYHh9/Pz7B1D0KthQRATQCfNf8s6bbFLaw/dmiIUhHLtIH5Qc\nyfrejTZbOSP77z8NOWir+BWWgIDDB2//3AkDIQvT20vmkZRhkqSdT7et4NmXOX/j\njhPti4b2Fie0LeuvgaOdKjCpQQNrYthZHXeVlOLRhMTSk3qUczenkKTOhvP7IS9q\n+Dzv5hqgSfvMG392KWh5f8xXfJNs4W5KLbZyl901MeReiLrPH3w=\n-----END CERTIFICATE-----",
          "key": "-----BEGIN PRIVATE KEY-----\nMIICeAIBADANBgkqhkiG9w0BAQEFAASCAmIwggJeAgEAAoGBAMrvgu6ZTTefNN7j\njiZbS/xvQjyXjYMN7oVXv76jbX8gjMOmg9m0xoVZZFAE4XyQDuCm47VRx5Qrf/YL\nXmB2VtCFvB0AhXr5zSeWzPwaAPrjA4ebG+LUo24ziS8KqNxrFs1MmNrQUgZyQC6X\nIe1JHXc9t+JlL5UZyZQC1IfaJulDAgMBAAECgYEAnxOjEj/vrLNLMZE1Q9H7PZVF\nWdP/JQVNvQ7tCpZ3ZdjxHwkvf//aQnuxS5yX2Rnf37BS/TZu+TIkK4373CfHomSx\nUTAn2FsLmOJljupgGcoeLx5K5nu7B7rY5L1NHvdpxZ4YjeISrRtEPvRakllENU5y\ngJE8c2eQOx08ZSRE4TkCQQD7dws2/FldqwdjJucYijsJVuUdoTqxP8gWL6bB251q\nelP2/a6W2elqOcWId28560jG9ZS3cuKvnmu/4LG88vZFAkEAzphrH3673oTsHN+d\nuBd5uyrlnGjWjuiMKv2TPITZcWBjB8nJDSvLneHF59MYwejNNEof2tRjgFSdImFH\nmi995wJBAMtPjW6wiqRz0i41VuT9ZgwACJBzOdvzQJfHgSD9qgFb1CU/J/hpSRIM\nkYvrXK9MbvQFvG6x4VuyT1W8mpe1LK0CQAo8VPpffhFdRpF7psXLK/XQ/0VLkG3O\nKburipLyBg/u9ZkaL0Ley5zL5dFBjTV2Qkx367Ic2b0u9AYTCcgi2DsCQQD3zZ7B\nv7BOm7MkylKokY2MduFFXU0Bxg6pfZ7q3rvg8gqhUFbaMStPRYg6myiDiW/JfLhF\nTcFT4touIo7oriFJ\n-----END PRIVATE KEY-----",
          "caCertificate": "-----BEGIN CERTIFICATE-----\nMIIEFzCCAv+gAwIBAgIJALK1iUpF2VQLMA0GCSqGSIb3DQEBBQUAMIGhMQswCQYD\nVQQGEwJVUzELMAkGA1UECAwCU0MxFTATBgNVBAcMDERlZmF1bHQgQ2l0eTEcMBoG\nA1UECgwTRGVmYXVsdCBDb21wYW55IEx0ZDEQMA4GA1UECwwHVGVzdCBDQTEaMBgG\nA1UEAwwRd3d3LmV4YW1wbGVjYS5jb20xIjAgBgkqhkiG9w0BCQEWE2V4YW1wbGVA\nZXhhbXBsZS5jb20wHhcNMTUwMTEyMTQxNTAxWhcNMjUwMTA5MTQxNTAxWjCBoTEL\nMAkGA1UEBhMCVVMxCzAJBgNVBAgMAlNDMRUwEwYDVQQHDAxEZWZhdWx0IENpdHkx\nHDAaBgNVBAoME0RlZmF1bHQgQ29tcGFueSBMdGQxEDAOBgNVBAsMB1Rlc3QgQ0Ex\nGjAYBgNVBAMMEXd3dy5leGFtcGxlY2EuY29tMSIwIAYJKoZIhvcNAQkBFhNleGFt\ncGxlQGV4YW1wbGUuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nw2rK1J2NMtQj0KDug7g7HRKl5jbf0QMkMKyTU1fBtZ0cCzvsF4CqV11LK4BSVWaK\nrzkaXe99IVJnH8KdOlDl5Dh/+cJ3xdkClSyeUT4zgb6CCBqg78ePp+nN11JKuJlV\nIG1qdJpB1J5O/kCLsGcTf7RS74MtqMFo96446Zvt7YaBhWPz6gDaO/TUzfrNcGLA\nEfHVXkvVWqb3gqXUztZyVex/gtP9FXQ7gxTvJml7UkmT0VAFjtZnCqmFxpLZFZ15\n+qP9O7Q2MpsGUO/4vDAuYrKBeg1ZdPSi8gwqUP2qWsGd9MIWRv3thI2903BczDc7\nr8WaIbm37vYZAS9G56E4+wIDAQABo1AwTjAdBgNVHQ4EFgQUugLrSJshOBk5TSsU\nANs4+SmJUGwwHwYDVR0jBBgwFoAUugLrSJshOBk5TSsUANs4+SmJUGwwDAYDVR0T\nBAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEAaMJ33zAMV4korHo5aPfayV3uHoYZ\n1ChzP3eSsF+FjoscpoNSKs91ZXZF6LquzoNezbfiihK4PYqgwVD2+O0/Ty7UjN4S\nqzFKVR4OS/6lCJ8YncxoFpTntbvjgojf1DEataKFUN196PAANc3yz8cWHF4uvjPv\nWkgFqbIjb+7D1YgglNyovXkRDlRZl0LD1OQ0ZWhd4Ge1qx8mmmanoBeYZ9+DgpFC\nj9tQAbS867yeOryNe7sEOIpXAAqK/DTu0hB6+ySsDfMo4piXCc2aA/eI2DCuw08e\nw17Dz9WnupZjVdwTKzDhFgJZMLDqn37HQnT6EemLFqbcR0VPEnfyhDtZIQ==\n-----END CERTIFICATE-----"
        }
      }
    },
    {
      "kind": "PersistentVolumeClaim",
      "apiVersion": "v1",
      "metadata": {
        "name": "${JENKINS_SERVICE_NAME}"
      },
      "spec": {
        "accessModes": [
          "ReadWriteOnce"
        ],
        "resources": {
          "requests": {
            "storage": "${VOLUME_CAPACITY}"
          }
        }
      }
    },    
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${JENKINS_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "jenkins"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "${JENKINS_IMAGE_STREAM_TAG}",
                "namespace": "${NAMESPACE}"
              },
              "lastTriggeredImage": ""
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${JENKINS_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "creationTimestamp": null,
            "labels": {
              "name": "${JENKINS_SERVICE_NAME}"
            }
          },
          "spec": {
            "serviceAccountName": "${JENKINS_SERVICE_NAME}",
            "containers": [
              {
                "name": "jenkins",
                "image": " ",
                "readinessProbe": {
                  "timeoutSeconds": 3,
                  "initialDelaySeconds": 3,
                  "httpGet": {
                    "path": "/login",
                    "port": 8080
                  }
                },
                "livenessProbe": {
                    "timeoutSeconds": 3,
                    "initialDelaySeconds": 120,
                    "httpGet": {
                        "path": "/login",
                        "port": 8080
                    }
                },
                "env": [
                  {
                    "name": "JENKINS_PASSWORD",
                    "value": "${JENKINS_PASSWORD}"
                  },
                  {
                    "name": "KUBERNETES_MASTER",
                    "value": "https://kubernetes.default:443"
                  },
                  {
                    "name": "KUBERNETES_TRUST_CERTIFICATES",
                    "value": "true"
                  },
                  {
                    "name": "JNLP_SERVICE_NAME",
                    "value": "${JNLP_SERVICE_NAME}"
                  }
                ],
                "resources": {
                  "limits": {
                    "memory": "${MEMORY_LIMIT}"
                  }
                },
                "volumeMounts": [
                  {
                    "name": "${JENKINS_SERVICE_NAME}-data",
                    "mountPath": "/var/lib/jenkins"
                  }
                ],
                "terminationMessagePath": "/dev/termination-log",
                "imagePullPolicy": "IfNotPresent",
                "capabilities": {},
                "securityContext": {
                  "capabilities": {},
                  "privileged": false
                }
              }
            ],
            "volumes": [
              {
                "name": "${JENKINS_SERVICE_NAME}-data",
                "persistentVolumeClaim": {
                  "claimName": "${JENKINS_SERVICE_NAME}"
                }
              }
            ],
            "restartPolicy": "Always",
            "dnsPolicy": "ClusterFirst"
          }
        }
      }
    },
    {
      "kind": "ServiceAccount",
        "apiVersion": "v1",
        "metadata": {
            "name": "${JENKINS_SERVICE_NAME}"
        }
    },
    {
      "kind": "RoleBinding",
      "apiVersion": "v1",
      "metadata": {
          "name": "${JENKINS_SERVICE_NAME}_edit"
      },
      "groupNames": null,
      "subjects": [
          {
              "kind": "ServiceAccount",
              "name": "${JENKINS_SERVICE_NAME}"
          }
      ],
      "roleRef": {
          "name": "edit"
      }
    },
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${JNLP_SERVICE_NAME}"
      },
      "spec": {
        "ports": [
          {
            "name": "agent",
            "protocol": "TCP",
            "port": 50000,
            "targetPort": 50000,
            "nodePort": 0
          }
        ],
        "selector": {
          "name": "${JENKINS_SERVICE_NAME}"
        },
        "portalIP": "",
        "type": "ClusterIP",
        "sessionAffinity": "None"
      }
    },
    {
       "kind": "Service",
       "apiVersion": "v1",
       "metadata": {
         "name": "${JENKINS_SERVICE_NAME}",
         "annotations": {
           "service.alpha.openshift.io/dependencies": "[{\"name\": \"${JNLP_SERVICE_NAME}\", \"namespace\": \"\", \"kind\": \"Service\"}]",
           "service.openshift.io/infrastructure": "true"
         },
         "creationTimestamp": null
       },
       "spec": {
         "ports": [
           {
             "name": "web",
             "protocol": "TCP",
             "port": 80,
             "targetPort": 8080,
             "nodePort": 0
           }
         ],
         "selector": {
           "name": "${JENKINS_SERVICE_NAME}"
         },
         "portalIP": "",
         "type": "ClusterIP",
         "sessionAffinity": "None"
       }
    }
  ],
  "parameters": [
    {
      "name": "JENKINS_SERVICE_NAME",
      "displayName": "Jenkins Service Name",
      "description": "The name of the OpenShift Service exposed for the Jenkins container.",
      "value": "jenkins"
    },
    {
      "name": "JNLP_SERVICE_NAME",
      "displayName": "Jenkins JNLP Service Name",
      "description": "The name of the service used for master/slave communication.",
      "value": "jenkins-jnlp"
    },
    {
      "name": "JENKINS_PASSWORD",
      "displayName": "Jenkins Password",
      "description": "Password for the Jenkins 'admin' user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}",
      "required": true
    },
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the container can use.",
      "value": "512Mi"
    },
    {
      "name": "VOLUME_CAPACITY",
      "displayName": "Volume Capacity",
      "description": "Volume space available for data, e.g. 512Mi, 2Gi.",
      "value": "1Gi",
      "required": true
    },
    {
      "name": "NAMESPACE",
      "displayName": "Jenkins ImageStream Namespace",
      "description": "The OpenShift Namespace where the Jenkins ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "JENKINS_IMAGE_STREAM_TAG",
      "displayName": "Jenkins ImageStreamTag",
      "description": "Name of the ImageStreamTag to be used for the Jenkins image.",
      "value": "jenkins:latest"
    }
  ],
  "labels": {
    "template": "jenkins-persistent-template"
  }
}
`)

func examplesJenkinsJenkinsPersistentTemplateJsonBytes() ([]byte, error) {
	return _examplesJenkinsJenkinsPersistentTemplateJson, nil
}

func examplesJenkinsJenkinsPersistentTemplateJson() (*asset, error) {
	bytes, err := examplesJenkinsJenkinsPersistentTemplateJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/jenkins/jenkins-persistent-template.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesJenkinsPipelineSamplepipelineJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "jenkins-pipeline-example",
    "creationTimestamp": null,
    "annotations": {
      "description": "This example showcases the new Jenkins Pipeline integration in OpenShift, which performs continuous integration and deployment right on the platform. The template contains a Jenkinsfile - a definition of a multi-stage CI process - that leverages the underlying OpenShift platform for dynamic and scalable builds. OpenShift integrates the status of your pipeline builds into the web console allowing you to see your entire application lifecycle in a single view.",
      "iconClass": "icon-jenkins",
      "tags": "instant-app,ruby,mysql,jenkins"
    }
  },
  "message": "The Jenkins server is not currently automatically instantiated for you.  Please instantiate one of the Jenkins templates to create a Jenkins server for managing your pipeline build configurations.",
  "objects": [
    {
      "kind": "BuildConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "sample-pipeline",
        "creationTimestamp": null,
        "labels": {
          "name": "sample-pipeline"
        },
        "annotations": {
          "pipeline.alpha.openshift.io/uses": "[{\"name\": \"frontend\", \"namespace\": \"\", \"kind\": \"DeploymentConfig\"}]"
        }
      },
      "spec": {
        "triggers": [
          {
            "type": "GitHub",
            "github": {
              "secret": "secret101"
            }
          },
          {
            "type": "Generic",
            "generic": {
              "secret": "secret101"
            }
          }
        ],
        "strategy": {
          "type": "JenkinsPipeline",
          "jenkinsPipelineStrategy": {
            "jenkinsfile": "node('maven') {\nstage 'build'\nopenshiftBuild(buildConfig: 'ruby-sample-build', showBuildLogs: 'true')\nstage 'deploy'\nopenshiftDeploy(deploymentConfig: 'frontend')\n}"
          }
        }
      }
    },
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "frontend",
        "creationTimestamp": null,
        "annotations": {
          "service.alpha.openshift.io/dependencies": "[{\"name\": \"database\", \"namespace\": \"\", \"kind\": \"Service\"}]"
        }
      },
      "spec": {
        "ports": [
          {
            "name": "web",
            "protocol": "TCP",
            "port": 5432,
            "targetPort": 8080,
            "nodePort": 0
          }
        ],
        "selector": {
          "name": "frontend"
        },
        "portalIP": "",
        "type": "ClusterIP",
        "sessionAffinity": "None"
      },
      "status": {
        "loadBalancer": {}
      }
    },
    {
      "kind": "Route",
      "apiVersion": "v1",
      "metadata": {
        "name": "frontend",
        "creationTimestamp": null
      },
      "spec": {
        "to": {
          "kind": "Service",
          "name": "frontend"
        },
        "tls": {
          "termination": "edge",
          "certificate": "-----BEGIN CERTIFICATE-----\nMIIDIjCCAgqgAwIBAgIBATANBgkqhkiG9w0BAQUFADCBoTELMAkGA1UEBhMCVVMx\nCzAJBgNVBAgMAlNDMRUwEwYDVQQHDAxEZWZhdWx0IENpdHkxHDAaBgNVBAoME0Rl\nZmF1bHQgQ29tcGFueSBMdGQxEDAOBgNVBAsMB1Rlc3QgQ0ExGjAYBgNVBAMMEXd3\ndy5leGFtcGxlY2EuY29tMSIwIAYJKoZIhvcNAQkBFhNleGFtcGxlQGV4YW1wbGUu\nY29tMB4XDTE1MDExMjE0MTk0MVoXDTE2MDExMjE0MTk0MVowfDEYMBYGA1UEAwwP\nd3d3LmV4YW1wbGUuY29tMQswCQYDVQQIDAJTQzELMAkGA1UEBhMCVVMxIjAgBgkq\nhkiG9w0BCQEWE2V4YW1wbGVAZXhhbXBsZS5jb20xEDAOBgNVBAoMB0V4YW1wbGUx\nEDAOBgNVBAsMB0V4YW1wbGUwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAMrv\ngu6ZTTefNN7jjiZbS/xvQjyXjYMN7oVXv76jbX8gjMOmg9m0xoVZZFAE4XyQDuCm\n47VRx5Qrf/YLXmB2VtCFvB0AhXr5zSeWzPwaAPrjA4ebG+LUo24ziS8KqNxrFs1M\nmNrQUgZyQC6XIe1JHXc9t+JlL5UZyZQC1IfaJulDAgMBAAGjDTALMAkGA1UdEwQC\nMAAwDQYJKoZIhvcNAQEFBQADggEBAFCi7ZlkMnESvzlZCvv82Pq6S46AAOTPXdFd\nTMvrh12E1sdVALF1P1oYFJzG1EiZ5ezOx88fEDTW+Lxb9anw5/KJzwtWcfsupf1m\nV7J0D3qKzw5C1wjzYHh9/Pz7B1D0KthQRATQCfNf8s6bbFLaw/dmiIUhHLtIH5Qc\nyfrejTZbOSP77z8NOWir+BWWgIDDB2//3AkDIQvT20vmkZRhkqSdT7et4NmXOX/j\njhPti4b2Fie0LeuvgaOdKjCpQQNrYthZHXeVlOLRhMTSk3qUczenkKTOhvP7IS9q\n+Dzv5hqgSfvMG392KWh5f8xXfJNs4W5KLbZyl901MeReiLrPH3w=\n-----END CERTIFICATE-----",
          "key": "-----BEGIN PRIVATE KEY-----\nMIICeAIBADANBgkqhkiG9w0BAQEFAASCAmIwggJeAgEAAoGBAMrvgu6ZTTefNN7j\njiZbS/xvQjyXjYMN7oVXv76jbX8gjMOmg9m0xoVZZFAE4XyQDuCm47VRx5Qrf/YL\nXmB2VtCFvB0AhXr5zSeWzPwaAPrjA4ebG+LUo24ziS8KqNxrFs1MmNrQUgZyQC6X\nIe1JHXc9t+JlL5UZyZQC1IfaJulDAgMBAAECgYEAnxOjEj/vrLNLMZE1Q9H7PZVF\nWdP/JQVNvQ7tCpZ3ZdjxHwkvf//aQnuxS5yX2Rnf37BS/TZu+TIkK4373CfHomSx\nUTAn2FsLmOJljupgGcoeLx5K5nu7B7rY5L1NHvdpxZ4YjeISrRtEPvRakllENU5y\ngJE8c2eQOx08ZSRE4TkCQQD7dws2/FldqwdjJucYijsJVuUdoTqxP8gWL6bB251q\nelP2/a6W2elqOcWId28560jG9ZS3cuKvnmu/4LG88vZFAkEAzphrH3673oTsHN+d\nuBd5uyrlnGjWjuiMKv2TPITZcWBjB8nJDSvLneHF59MYwejNNEof2tRjgFSdImFH\nmi995wJBAMtPjW6wiqRz0i41VuT9ZgwACJBzOdvzQJfHgSD9qgFb1CU/J/hpSRIM\nkYvrXK9MbvQFvG6x4VuyT1W8mpe1LK0CQAo8VPpffhFdRpF7psXLK/XQ/0VLkG3O\nKburipLyBg/u9ZkaL0Ley5zL5dFBjTV2Qkx367Ic2b0u9AYTCcgi2DsCQQD3zZ7B\nv7BOm7MkylKokY2MduFFXU0Bxg6pfZ7q3rvg8gqhUFbaMStPRYg6myiDiW/JfLhF\nTcFT4touIo7oriFJ\n-----END PRIVATE KEY-----",
          "caCertificate": "-----BEGIN CERTIFICATE-----\nMIIEFzCCAv+gAwIBAgIJALK1iUpF2VQLMA0GCSqGSIb3DQEBBQUAMIGhMQswCQYD\nVQQGEwJVUzELMAkGA1UECAwCU0MxFTATBgNVBAcMDERlZmF1bHQgQ2l0eTEcMBoG\nA1UECgwTRGVmYXVsdCBDb21wYW55IEx0ZDEQMA4GA1UECwwHVGVzdCBDQTEaMBgG\nA1UEAwwRd3d3LmV4YW1wbGVjYS5jb20xIjAgBgkqhkiG9w0BCQEWE2V4YW1wbGVA\nZXhhbXBsZS5jb20wHhcNMTUwMTEyMTQxNTAxWhcNMjUwMTA5MTQxNTAxWjCBoTEL\nMAkGA1UEBhMCVVMxCzAJBgNVBAgMAlNDMRUwEwYDVQQHDAxEZWZhdWx0IENpdHkx\nHDAaBgNVBAoME0RlZmF1bHQgQ29tcGFueSBMdGQxEDAOBgNVBAsMB1Rlc3QgQ0Ex\nGjAYBgNVBAMMEXd3dy5leGFtcGxlY2EuY29tMSIwIAYJKoZIhvcNAQkBFhNleGFt\ncGxlQGV4YW1wbGUuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nw2rK1J2NMtQj0KDug7g7HRKl5jbf0QMkMKyTU1fBtZ0cCzvsF4CqV11LK4BSVWaK\nrzkaXe99IVJnH8KdOlDl5Dh/+cJ3xdkClSyeUT4zgb6CCBqg78ePp+nN11JKuJlV\nIG1qdJpB1J5O/kCLsGcTf7RS74MtqMFo96446Zvt7YaBhWPz6gDaO/TUzfrNcGLA\nEfHVXkvVWqb3gqXUztZyVex/gtP9FXQ7gxTvJml7UkmT0VAFjtZnCqmFxpLZFZ15\n+qP9O7Q2MpsGUO/4vDAuYrKBeg1ZdPSi8gwqUP2qWsGd9MIWRv3thI2903BczDc7\nr8WaIbm37vYZAS9G56E4+wIDAQABo1AwTjAdBgNVHQ4EFgQUugLrSJshOBk5TSsU\nANs4+SmJUGwwHwYDVR0jBBgwFoAUugLrSJshOBk5TSsUANs4+SmJUGwwDAYDVR0T\nBAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEAaMJ33zAMV4korHo5aPfayV3uHoYZ\n1ChzP3eSsF+FjoscpoNSKs91ZXZF6LquzoNezbfiihK4PYqgwVD2+O0/Ty7UjN4S\nqzFKVR4OS/6lCJ8YncxoFpTntbvjgojf1DEataKFUN196PAANc3yz8cWHF4uvjPv\nWkgFqbIjb+7D1YgglNyovXkRDlRZl0LD1OQ0ZWhd4Ge1qx8mmmanoBeYZ9+DgpFC\nj9tQAbS867yeOryNe7sEOIpXAAqK/DTu0hB6+ySsDfMo4piXCc2aA/eI2DCuw08e\nw17Dz9WnupZjVdwTKzDhFgJZMLDqn37HQnT6EemLFqbcR0VPEnfyhDtZIQ==\n-----END CERTIFICATE-----"
        }
      },
      "status": {}
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "origin-ruby-sample",
        "creationTimestamp": null
      },
      "spec": {},
      "status": {
        "dockerImageRepository": ""
      }
    },
    {
      "kind": "BuildConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "ruby-sample-build",
        "creationTimestamp": null,
        "labels": {
          "name": "ruby-sample-build"
        }
      },
      "spec": {
        "triggers": [
          {
            "type": "GitHub",
            "github": {
              "secret": "secret101"
            }
          },
          {
            "type": "Generic",
            "generic": {
              "secret": "secret101"
            }
          }
        ],
        "source": {
          "type": "Git",
          "git": {
            "uri": "https://github.com/openshift/ruby-hello-world.git"
          }
        },
        "strategy": {
          "type": "Source",
          "sourceStrategy": {
            "from": {
              "kind": "ImageStreamTag",
              "name": "ruby:2.2",
              "namespace": "openshift"
            },
            "env": [
              {
                "name": "EXAMPLE",
                "value": "sample-app"
              }
            ]
          }
        },
        "output": {
          "to": {
            "kind": "ImageStreamTag",
            "name": "origin-ruby-sample:latest"
          }
        },
        "postCommit": {
          "args": ["bundle", "exec", "rake", "test"]
        },
        "resources": {}
      },
      "status": {
        "lastVersion": 0
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "frontend",
        "creationTimestamp": null
      },
      "spec": {
        "strategy": {
          "type": "Rolling",
          "rollingParams": {
            "updatePeriodSeconds": 1,
            "intervalSeconds": 1,
            "timeoutSeconds": 120,
            "pre": {
              "failurePolicy": "Abort",
              "execNewPod": {
                "command": [
                  "/bin/true"
                ],
                "env": [
                  {
                    "name": "CUSTOM_VAR1",
                    "value": "custom_value1"
                  }
                ],
                "containerName": "ruby-helloworld"
              }
            },
            "post": {
              "failurePolicy": "Ignore",
              "execNewPod": {
                "command": [
                  "/bin/false"
                ],
                "env": [
                  {
                    "name": "CUSTOM_VAR2",
                    "value": "custom_value2"
                  }
                ],
                "containerName": "ruby-helloworld"
              }
            }
          },
          "resources": {}
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "ruby-helloworld"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "origin-ruby-sample:latest"
              }
            }
          }
        ],
        "replicas": 2,
        "selector": {
          "name": "frontend"
        },
        "template": {
          "metadata": {
            "creationTimestamp": null,
            "labels": {
              "name": "frontend"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "ruby-helloworld",
                "image": " ",
                "ports": [
                  {
                    "containerPort": 8080,
                    "protocol": "TCP"
                  }
                ],
                "env": [
                  {
                    "name": "ADMIN_USERNAME",
                    "value": "${ADMIN_USERNAME}"
                  },
                  {
                    "name": "ADMIN_PASSWORD",
                    "value": "${ADMIN_PASSWORD}"
                  },
                  {
                    "name": "MYSQL_USER",
                    "value": "${MYSQL_USER}"
                  },
                  {
                    "name": "MYSQL_PASSWORD",
                    "value": "${MYSQL_PASSWORD}"
                  },
                  {
                    "name": "MYSQL_DATABASE",
                    "value": "${MYSQL_DATABASE}"
                  }
                ],
                "resources": {},
                "terminationMessagePath": "/dev/termination-log",
                "imagePullPolicy": "IfNotPresent",
                "securityContext": {
                  "capabilities": {},
                  "privileged": false
                }
              }
            ],
            "restartPolicy": "Always",
            "dnsPolicy": "ClusterFirst"
          }
        }
      },
      "status": {}
    },
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "database",
        "creationTimestamp": null
      },
      "spec": {
        "ports": [
          {
            "name": "db",
            "protocol": "TCP",
            "port": 5434,
            "targetPort": 3306,
            "nodePort": 0
          }
        ],
        "selector": {
          "name": "database"
        },
        "portalIP": "",
        "type": "ClusterIP",
        "sessionAffinity": "None"
      },
      "status": {
        "loadBalancer": {}
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "database",
        "creationTimestamp": null
      },
      "spec": {
        "strategy": {
          "type": "Recreate",
          "recreateParams": {
            "pre": {
              "failurePolicy": "Abort",
              "execNewPod": {
                "command": [
                  "/bin/true"
                ],
                "env": [
                  {
                    "name": "CUSTOM_VAR1",
                    "value": "custom_value1"
                  }
                ],
                "containerName": "ruby-helloworld-database",
                "volumes": ["ruby-helloworld-data"]
              }
            },
            "mid": {
              "failurePolicy": "Abort",
              "execNewPod": {
                "command": [
                  "/bin/true"
                ],
                "env": [
                  {
                    "name": "CUSTOM_VAR2",
                    "value": "custom_value2"
                  }
                ],
                "containerName": "ruby-helloworld-database",
                "volumes": ["ruby-helloworld-data"]
              }
            },
            "post": {
              "failurePolicy": "Ignore",
              "execNewPod": {
                "command": [
                  "/bin/false"
                ],
                "env": [
                  {
                    "name": "CUSTOM_VAR2",
                    "value": "custom_value2"
                  }
                ],
                "containerName": "ruby-helloworld-database",
                "volumes": ["ruby-helloworld-data"]
              }
            }
          },
          "resources": {}
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "ruby-helloworld-database"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "mysql:5.6",
                "namespace": "openshift"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "database"
        },
        "template": {
          "metadata": {
            "creationTimestamp": null,
            "labels": {
              "name": "database"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "ruby-helloworld-database",
                "image": " ",
                "ports": [
                  {
                    "containerPort": 3306,
                    "protocol": "TCP"
                  }
                ],
                "env": [
                  {
                    "name": "MYSQL_USER",
                    "value": "${MYSQL_USER}"
                  },
                  {
                    "name": "MYSQL_PASSWORD",
                    "value": "${MYSQL_PASSWORD}"
                  },
                  {
                    "name": "MYSQL_DATABASE",
                    "value": "${MYSQL_DATABASE}"
                  }
                ],
                "resources": {},
                "volumeMounts": [
                  {
                    "name": "ruby-helloworld-data",
                    "mountPath": "/var/lib/mysql/data"
                  }
                ],
                "terminationMessagePath": "/dev/termination-log",
                "imagePullPolicy": "Always",
                "securityContext": {
                  "capabilities": {},
                  "privileged": false
                }
              }
            ],
            "volumes": [
              {
                "name": "ruby-helloworld-data",
                "emptyDir": {
                  "medium": ""
                }
              }
            ],
            "restartPolicy": "Always",
            "dnsPolicy": "ClusterFirst"
          }
        }
      },
      "status": {}
    }
  ],
  "parameters": [
    {
      "name": "ADMIN_USERNAME",
      "description": "administrator username",
      "generate": "expression",
      "from": "admin[A-Z0-9]{3}"
    },
    {
      "name": "ADMIN_PASSWORD",
      "description": "administrator password",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{8}"
    },
    {
      "name": "MYSQL_USER",
      "description": "database username",
      "generate": "expression",
      "from": "user[A-Z0-9]{3}",
      "required": true
    },
    {
      "name": "MYSQL_PASSWORD",
      "description": "database password",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{8}",
      "required": true
    },
    {
      "name": "MYSQL_DATABASE",
      "description": "database name",
      "value": "root",
      "required": true
    }
  ],
  "labels": {
    "template": "application-template-sample-pipeline"
  }
}
`)

func examplesJenkinsPipelineSamplepipelineJsonBytes() ([]byte, error) {
	return _examplesJenkinsPipelineSamplepipelineJson, nil
}

func examplesJenkinsPipelineSamplepipelineJson() (*asset, error) {
	bytes, err := examplesJenkinsPipelineSamplepipelineJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/jenkins/pipeline/samplepipeline.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesQuickstartsCakephpMysqlJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "cakephp-mysql-example",
    "annotations": {
      "description": "An example CakePHP application with a MySQL database",
      "tags": "quickstart,php,cakephp,mysql",
      "iconClass": "icon-php"
    }
  },
  "labels": {
    "template": "cakephp-mysql-example"
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Exposes and load balances the application pods"
        }
      },
      "spec": {
        "ports": [
          {
            "name": "web",
            "port": 8080,
            "targetPort": 8080
          }
        ],
        "selector": {
          "name": "${NAME}"
        }
      }
    },
    {
      "kind": "Route",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}"
      },
      "spec": {
        "host": "${APPLICATION_DOMAIN}",
        "to": {
          "kind": "Service",
          "name": "${NAME}"
        }
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Keeps track of changes in the application image"
        }
      }
    },
    {
      "kind": "BuildConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Defines how to build the application"
        }
      },
      "spec": {
        "source": {
          "type": "Git",
          "git": {
            "uri": "${SOURCE_REPOSITORY_URL}",
            "ref": "${SOURCE_REPOSITORY_REF}"
          },
          "contextDir": "${CONTEXT_DIR}"
        },
        "strategy": {
          "type": "Source",
          "sourceStrategy": {
            "from": {
              "kind": "ImageStreamTag",
              "namespace": "${NAMESPACE}",
              "name": "php:5.6"
            },
            "env":  [
              {
                  "name": "COMPOSER_MIRROR",
                  "value": "${COMPOSER_MIRROR}"
              }
            ]
          }
        },
        "output": {
          "to": {
            "kind": "ImageStreamTag",
            "name": "${NAME}:latest"
          }
        },
        "triggers": [
          {
            "type": "ImageChange"
          },
          {
            "type": "ConfigChange"
          },
          {
            "type": "GitHub",
            "github": {
              "secret": "${GITHUB_WEBHOOK_SECRET}"
            }
          }
        ]
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Defines how to deploy the application server"
        }
      },
      "spec": {
        "strategy": {
          "type": "Recreate",
          "recreateParams": {
            "pre": {
              "failurePolicy": "Retry",
              "execNewPod": {
                "command": [
                  "./migrate-database.sh"
                ],
                "containerName": "cakephp-mysql-example"
              }
            }
          }
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "cakephp-mysql-example"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "${NAME}:latest"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${NAME}"
        },
        "template": {
          "metadata": {
            "name": "${NAME}",
            "labels": {
              "name": "${NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "cakephp-mysql-example",
                "image": " ",
                "ports": [
                  {
                    "containerPort": 8080
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 3,
                  "initialDelaySeconds": 3,
                  "httpGet": {
                    "path": "/health.php",
                    "port": 8080
                  }
                },
                "livenessProbe": {
                    "timeoutSeconds": 3,
                    "initialDelaySeconds": 30,
                    "httpGet": {
                        "path": "/",
                        "port": 8080
                    }
                },
                "env": [
                  {
                    "name": "DATABASE_SERVICE_NAME",
                    "value": "${DATABASE_SERVICE_NAME}"
                  },
                  {
                    "name": "DATABASE_ENGINE",
                    "value": "${DATABASE_ENGINE}"
                  },
                  {
                    "name": "DATABASE_NAME",
                    "value": "${DATABASE_NAME}"
                  },
                  {
                    "name": "DATABASE_USER",
                    "value": "${DATABASE_USER}"
                  },
                  {
                    "name": "DATABASE_PASSWORD",
                    "value": "${DATABASE_PASSWORD}"
                  },
                  {
                    "name": "CAKEPHP_SECRET_TOKEN",
                    "value": "${CAKEPHP_SECRET_TOKEN}"
                  },
                  {
                    "name": "CAKEPHP_SECURITY_SALT",
                    "value": "${CAKEPHP_SECURITY_SALT}"
                  },
                  {
                    "name": "CAKEPHP_SECURITY_CIPHER_SEED",
                    "value": "${CAKEPHP_SECURITY_CIPHER_SEED}"
                  },
                  {
                    "name": "OPCACHE_REVALIDATE_FREQ",
                    "value": "${OPCACHE_REVALIDATE_FREQ}"
                  }
                ],
                "resources": {
		    "limits": {
			"memory": "${MEMORY_LIMIT}"
		    }
                }
              }
            ]
          }
        }
      }
    },
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "annotations": {
          "description": "Exposes the database server"
        }
      },
      "spec": {
        "ports": [
          {
            "name": "mysql",
            "port": 3306,
            "targetPort": 3306
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "annotations": {
          "description": "Defines how to deploy the database"
        }
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "mysql"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "namespace": "${NAMESPACE}",
                "name": "mysql:5.6"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "name": "${DATABASE_SERVICE_NAME}",
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "volumes": [
              {
                "name": "data",
                "emptyDir": {}
              }
            ],
            "containers": [
              {
                "name": "mysql",
                "image": " ",
                "ports": [
                  {
                    "containerPort": 3306
                  }
                ],
                "volumeMounts": [
                  {
                    "name": "data",
                    "mountPath": "/var/lib/mysql/data"
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 5,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c", "MYSQL_PWD='${DATABASE_PASSWORD}' mysql -h 127.0.0.1 -u ${DATABASE_USER} -D ${DATABASE_NAME} -e 'SELECT 1'" ]
                  }
                },
                "livenessProbe": {
                    "timeoutSeconds": 1,
                    "initialDelaySeconds": 30,
                    "tcpSocket": {
                        "port": 3306
                    }
                },
                "env": [
                    {
                        "name": "MYSQL_USER",
                        "value": "${DATABASE_USER}"
                    },
                    {
                        "name": "MYSQL_PASSWORD",
                        "value": "${DATABASE_PASSWORD}"
                    },
                    {
                        "name": "MYSQL_DATABASE",
                        "value": "${DATABASE_NAME}"
                    }
                ],
                "resources": {
                    "limits": {
                        "memory": "${MEMORY_MYSQL_LIMIT}"
                    }
                }
              }
            ]
          }
        }
      }
    }
  ],
  "parameters": [
    {
      "name": "NAME",
      "displayName": "Name",
      "description": "The name assigned to all of the frontend objects defined in this template.",
      "required": true,
      "value": "cakephp-mysql-example"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "required": true,
      "value": "openshift"
    },
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the CakePHP container can use.",
      "required": true,
      "value": "512Mi"
    },
    {
      "name": "MEMORY_MYSQL_LIMIT",
      "displayName": "Memory Limit (MySQL)",
      "description": "Maximum amount of memory the MySQL container can use.",
      "required": true,
      "value": "512Mi"
    },
    {
      "name": "SOURCE_REPOSITORY_URL",
      "displayName": "Git Repository URL",
      "description": "The URL of the repository with your application source code.",
      "required": true,
      "value": "https://github.com/openshift/cakephp-ex.git"
    },
    {
      "name": "SOURCE_REPOSITORY_REF",
      "displayName": "Git Reference",
      "description": "Set this to a branch name, tag or other ref of your repository if you are not using the default branch."
    },
    {
      "name": "CONTEXT_DIR",
      "displayName": "Context Directory",
      "description": "Set this to the relative path to your project if it is not in the root of your repository."
    },
    {
      "name": "APPLICATION_DOMAIN",
      "displayName": "Application Hostname",
      "description": "The exposed hostname that will route to the CakePHP service, if left blank a value will be defaulted.",
      "value": ""
    },
    {
      "name": "GITHUB_WEBHOOK_SECRET",
      "displayName": "GitHub Webhook Secret",
      "description": "A secret string used to configure the GitHub webhook.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{40}"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "required": true,
      "value": "mysql"
    },
    {
      "name": "DATABASE_ENGINE",
      "displayName": "Database Engine",
      "description": "Database engine: postgresql, mysql or sqlite (default).",
      "required": true,
      "value": "mysql"
    },
    {
      "name": "DATABASE_NAME",
      "displayName": "Database Name",
      "required": true,
      "value": "default"
    },
    {
      "name": "DATABASE_USER",
      "displayName": "Database User",
      "required": true,
      "value": "cakephp"
    },
    {
      "name": "DATABASE_PASSWORD",
      "displayName": "Database Password",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}"
    },
    {
      "name": "CAKEPHP_SECRET_TOKEN",
      "displayName": "CakePHP secret token",
      "description": "Set this to a long random string.",
      "generate": "expression",
      "from": "[\\w]{50}"
    },
    {
      "name": "CAKEPHP_SECURITY_SALT",
      "displayName": "CakePHP Security Salt",
      "description": "Security salt for session hash.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{40}"
    },
    {
      "name": "CAKEPHP_SECURITY_CIPHER_SEED",
      "displayName": "CakePHP Security Cipher Seed",
      "description": "Security cipher seed for session hash.",
      "generate": "expression",
      "from": "[0-9]{30}"
    },
    {
      "name": "OPCACHE_REVALIDATE_FREQ",
      "displayName": "OPcache Revalidation Frequency",
      "description": "How often to check script timestamps for updates, in seconds. 0 will result in OPcache checking for updates on every request.",
      "value": "2"
    },
    {
      "name": "COMPOSER_MIRROR",
      "displayName": "Custom Composer Mirror URL",
      "description": "The custom Composer mirror URL",
      "value": ""
    }
  ]
}
`)

func examplesQuickstartsCakephpMysqlJsonBytes() ([]byte, error) {
	return _examplesQuickstartsCakephpMysqlJson, nil
}

func examplesQuickstartsCakephpMysqlJson() (*asset, error) {
	bytes, err := examplesQuickstartsCakephpMysqlJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/quickstarts/cakephp-mysql.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesQuickstartsDancerMysqlJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "dancer-mysql-example",
    "annotations": {
      "description": "An example Dancer application with a MySQL database",
      "tags": "quickstart,perl,dancer,mysql",
      "iconClass": "icon-perl"
    }
  },
  "labels": {
    "template": "dancer-mysql-example"
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Exposes and load balances the application pods"
        }
      },
      "spec": {
        "ports": [
          {
            "name": "web",
            "port": 8080,
            "targetPort": 8080
          }
        ],
        "selector": {
          "name": "${NAME}"
        }
      }
    },
    {
      "kind": "Route",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}"
      },
      "spec": {
        "host": "${APPLICATION_DOMAIN}",
        "to": {
          "kind": "Service",
          "name": "${NAME}"
        }
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Keeps track of changes in the application image"
        }
      }
    },
    {
      "kind": "BuildConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Defines how to build the application"
        }
      },
      "spec": {
        "source": {
          "type": "Git",
          "git": {
            "uri": "${SOURCE_REPOSITORY_URL}",
            "ref": "${SOURCE_REPOSITORY_REF}"
          },
          "contextDir": "${CONTEXT_DIR}"
        },
        "strategy": {
          "type": "Source",
          "sourceStrategy": {
            "from": {
              "kind": "ImageStreamTag",
              "namespace": "${NAMESPACE}",
              "name": "perl:5.20"
            },
            "env":  [
              {
                  "name": "CPAN_MIRROR",
                  "value": "${CPAN_MIRROR}"
              }
            ]
          }
        },
        "output": {
          "to": {
            "kind": "ImageStreamTag",
            "name": "${NAME}:latest"
          }
        },
        "triggers": [
          {
            "type": "ImageChange"
          },
          {
            "type": "ConfigChange"
          },
          {
            "type": "GitHub",
            "github": {
              "secret": "${GITHUB_WEBHOOK_SECRET}"
            }
          }
        ]
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Defines how to deploy the application server"
        }
      },
      "spec": {
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "dancer-mysql-example"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "${NAME}:latest"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${NAME}"
        },
        "template": {
          "metadata": {
            "name": "${NAME}",
            "labels": {
              "name": "${NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "dancer-mysql-example",
                "image": " ",
                "ports": [
                  {
                    "containerPort": 8080
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 3,
                  "initialDelaySeconds": 3,
                  "httpGet": {
                    "path": "/health",
                    "port": 8080
                  }
                },
                "livenessProbe": {
                    "timeoutSeconds": 3,
                    "initialDelaySeconds": 30,
                    "httpGet": {
                        "path": "/",
                        "port": 8080
                    }
                },
                "env": [
                  {
                    "name": "DATABASE_SERVICE_NAME",
                    "value": "${DATABASE_SERVICE_NAME}"
                  },
                  {
                    "name": "MYSQL_USER",
                    "value": "${DATABASE_USER}"
                  },
                  {
                    "name": "MYSQL_PASSWORD",
                    "value": "${DATABASE_PASSWORD}"
                  },
                  {
                    "name": "MYSQL_DATABASE",
                    "value": "${DATABASE_NAME}"
                  },
                  {
                    "name": "SECRET_KEY_BASE",
                    "value": "${SECRET_KEY_BASE}"
                  },
                  {
                    "name": "PERL_APACHE2_RELOAD",
                    "value": "${PERL_APACHE2_RELOAD}"
                  }
                ],
                "resources": {
                  "limits": {
                    "memory": "${MEMORY_LIMIT}"
                  }
                }
              }
            ]
          }
        }
      }
    },
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "annotations": {
          "description": "Exposes the database server"
        }
      },
      "spec": {
        "ports": [
          {
            "name": "mysql",
            "port": 3306,
            "targetPort": 3306
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "annotations": {
          "description": "Defines how to deploy the database"
        }
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "mysql"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "namespace": "${NAMESPACE}",
                "name": "mysql:5.6"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "name": "${DATABASE_SERVICE_NAME}",
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "volumes": [
              {
                "name": "data",
                "emptyDir": {}
              }
            ],
            "containers": [
              {
                "name": "mysql",
                "image": " ",
                "ports": [
                  {
                    "containerPort": 3306
                  }
                ],
                "volumeMounts": [
                  {
                    "name": "data",
                    "mountPath": "/var/lib/mysql/data"
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 5,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c", "MYSQL_PWD='${DATABASE_PASSWORD}' mysql -h 127.0.0.1 -u ${DATABASE_USER} -D ${DATABASE_NAME} -e 'SELECT 1'" ]
                  }
                },
                "livenessProbe": {
                    "timeoutSeconds": 1,
                    "initialDelaySeconds": 30,
                    "tcpSocket": {
                        "port": 3306
                    }
                },
                "env": [
                  {
                    "name": "MYSQL_USER",
                    "value": "${DATABASE_USER}"
                  },
                  {
                    "name": "MYSQL_PASSWORD",
                    "value": "${DATABASE_PASSWORD}"
                  },
                  {
                      "name": "MYSQL_DATABASE",
                      "value": "${DATABASE_NAME}"
                  }
                ],
                "resources": {
                    "limits": {
                        "memory": "${MEMORY_MYSQL_LIMIT}"
                    }
                }
              }
            ]
          }
        }
      }
    }
  ],
  "parameters": [
    {
      "name": "NAME",
      "displayName": "Name",
      "description": "The name assigned to all of the frontend objects defined in this template.",
      "required": true,
      "value": "dancer-mysql-example"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "required": true,
      "value": "openshift"
    },
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the Perl Dancer container can use.",
      "required": true,
      "value": "512Mi"
    },
    {
      "name": "MEMORY_MYSQL_LIMIT",
      "displayName": "Memory Limit (MySQL)",
      "description": "Maximum amount of memory the MySQL container can use.",
      "required": true,
      "value": "512Mi"
    },
    {
      "name": "SOURCE_REPOSITORY_URL",
      "displayName": "Git Repository URL",
      "description": "The URL of the repository with your application source code.",
      "required": true,
      "value": "https://github.com/openshift/dancer-ex.git"
    },
    {
      "name": "SOURCE_REPOSITORY_REF",
      "displayName": "Git Reference",
      "description": "Set this to a branch name, tag or other ref of your repository if you are not using the default branch."
    },
    {
      "name": "CONTEXT_DIR",
      "displayName": "Context Directory",
      "description": "Set this to the relative path to your project if it is not in the root of your repository."
    },
    {
      "name": "APPLICATION_DOMAIN",
      "displayName": "Application Hostname",
      "description": "The exposed hostname that will route to the Dancer service, if left blank a value will be defaulted.",
      "value": ""
    },
    {
      "name": "GITHUB_WEBHOOK_SECRET",
      "displayName": "GitHub Webhook Secret",
      "description": "A secret string used to configure the GitHub webhook.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{40}"
    },
    {
      "name": "ADMIN_USERNAME",
      "displayName": "Administrator Username",
      "generate": "expression",
      "from": "admin[A-Z0-9]{3}"
    },
    {
      "name": "ADMIN_PASSWORD",
      "displayName": "Administrator Password",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{8}"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "required": true,
      "value": "database"
    },
    {
      "name": "DATABASE_USER",
      "displayName": "Database Username",
      "generate": "expression",
      "from": "user[A-Z0-9]{3}"
    },
    {
      "name": "DATABASE_PASSWORD",
      "displayName": "Database Password",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{8}"
    },
    {
      "name": "DATABASE_NAME",
      "displayName": "Database Name",
      "required": true,
      "value": "sampledb"
    },
    {
      "name": "PERL_APACHE2_RELOAD",
      "displayName": "Perl Module Reload",
      "description": "Set this to \"true\" to enable automatic reloading of modified Perl modules.",
      "value": ""
    },
    {
      "name": "SECRET_KEY_BASE",
      "displayName": "Secret Key",
      "description": "Your secret key for verifying the integrity of signed cookies.",
      "generate": "expression",
      "from": "[a-z0-9]{127}"
    },
    {
      "name": "CPAN_MIRROR",
      "displayName": "Custom CPAN Mirror URL",
      "description": "The custom CPAN mirror URL",
      "value": ""
    }
  ]
}
`)

func examplesQuickstartsDancerMysqlJsonBytes() ([]byte, error) {
	return _examplesQuickstartsDancerMysqlJson, nil
}

func examplesQuickstartsDancerMysqlJson() (*asset, error) {
	bytes, err := examplesQuickstartsDancerMysqlJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/quickstarts/dancer-mysql.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesQuickstartsDjangoPostgresqlJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "django-psql-example",
    "annotations": {
      "description": "An example Django application with a PostgreSQL database",
      "tags": "quickstart,python,django,postgresql",
      "iconClass": "icon-python"
    }
  },
  "labels": {
    "template": "django-psql-example"
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Exposes and load balances the application pods"
        }
      },
      "spec": {
        "ports": [
          {
            "name": "web",
            "port": 8080,
            "targetPort": 8080
          }
        ],
        "selector": {
          "name": "${NAME}"
        }
      }
    },
    {
      "kind": "Route",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}"
      },
      "spec": {
        "host": "${APPLICATION_DOMAIN}",
        "to": {
          "kind": "Service",
          "name": "${NAME}"
        }
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Keeps track of changes in the application image"
        }
      }
    },
    {
      "kind": "BuildConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Defines how to build the application"
        }
      },
      "spec": {
        "source": {
          "type": "Git",
          "git": {
            "uri": "${SOURCE_REPOSITORY_URL}",
            "ref": "${SOURCE_REPOSITORY_REF}"
          },
          "contextDir": "${CONTEXT_DIR}"
        },
        "strategy": {
          "type": "Source",
          "sourceStrategy": {
            "from": {
              "kind": "ImageStreamTag",
              "namespace": "${NAMESPACE}",
              "name": "python:3.5"
            },
            "env": [
              {
                  "name": "PIP_INDEX_URL",
                  "value": "${PIP_INDEX_URL}"
              }
            ]
          }
        },
        "output": {
          "to": {
            "kind": "ImageStreamTag",
            "name": "${NAME}:latest"
          }
        },
        "triggers": [
          {
            "type": "ImageChange"
          },
          {
            "type": "ConfigChange"
          },
          {
            "type": "GitHub",
            "github": {
              "secret": "${GITHUB_WEBHOOK_SECRET}"
            }
          }
        ],
        "postCommit": {
           "script": "./manage.py test"
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Defines how to deploy the application server"
        }
      },
      "spec": {
        "strategy": {
          "type": "Rolling"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "django-psql-example"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "${NAME}:latest"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${NAME}"
        },
        "template": {
          "metadata": {
            "name": "${NAME}",
            "labels": {
              "name": "${NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "django-psql-example",
                "image": " ",
                "ports": [
                  {
                    "containerPort": 8080
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 3,
                  "initialDelaySeconds": 3,
                  "httpGet": {
                    "path": "/health",
                    "port": 8080
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 3,
                  "initialDelaySeconds": 30,
                  "httpGet": {
                    "path": "/health",
                    "port": 8080
                  }
                },
                "env": [
                  {
                    "name": "DATABASE_SERVICE_NAME",
                    "value": "${DATABASE_SERVICE_NAME}"
                  },
                  {
                    "name": "DATABASE_ENGINE",
                    "value": "${DATABASE_ENGINE}"
                  },
                  {
                    "name": "DATABASE_NAME",
                    "value": "${DATABASE_NAME}"
                  },
                  {
                    "name": "DATABASE_USER",
                    "value": "${DATABASE_USER}"
                  },
                  {
                    "name": "DATABASE_PASSWORD",
                    "value": "${DATABASE_PASSWORD}"
                  },
                  {
                    "name": "APP_CONFIG",
                    "value": "${APP_CONFIG}"
                  },
                  {
                    "name": "DJANGO_SECRET_KEY",
                    "value": "${DJANGO_SECRET_KEY}"
                  }
                ],
                "resources": {
                  "limits": {
                    "memory": "${MEMORY_LIMIT}"
                  }
                }
              }
            ]
          }
        }
      }
    },
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "annotations": {
          "description": "Exposes the database server"
        }
      },
      "spec": {
        "ports": [
          {
            "name": "postgresql",
            "port": 5432,
            "targetPort": 5432
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "annotations": {
          "description": "Defines how to deploy the database"
        }
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "postgresql"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "namespace": "${NAMESPACE}",
                "name": "postgresql:9.5"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "name": "${DATABASE_SERVICE_NAME}",
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "volumes": [
              {
                "name": "data",
                "emptyDir": {}
              }
            ],
            "containers": [
              {
                "name": "postgresql",
                "image": " ",
                "ports": [
                  {
                    "containerPort": 5432
                  }
                ],
                "env": [
                  {
                    "name": "POSTGRESQL_USER",
                    "value": "${DATABASE_USER}"
                  },
                  {
                    "name": "POSTGRESQL_PASSWORD",
                    "value": "${DATABASE_PASSWORD}"
                  },
                  {
                    "name": "POSTGRESQL_DATABASE",
                    "value": "${DATABASE_NAME}"
                  }
                ],
                "volumeMounts": [
                  {
                    "name": "data",
                    "mountPath": "/var/lib/pgsql/data"
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 5,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c", "psql -h 127.0.0.1 -U ${POSTGRESQL_USER} -q -d ${POSTGRESQL_DATABASE} -c 'SELECT 1'"]
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 30,
                  "tcpSocket": {
                    "port": 5432
                  }
                },
                "resources": {
                  "limits": {
                    "memory": "${MEMORY_POSTGRESQL_LIMIT}"
                  }
                }
              }
            ]
          }
        }
      }
    }
  ],
  "parameters": [
    {
      "name": "NAME",
      "displayName": "Name",
      "description": "The name assigned to all of the frontend objects defined in this template.",
      "required": true,
      "value": "django-psql-example"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "required": true,
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "required": true,
      "description": "Maximum amount of memory the Django container can use.",
      "value": "512Mi"
    },
    {
      "name": "MEMORY_POSTGRESQL_LIMIT",
      "displayName": "Memory Limit (PostgreSQL)",
      "required": true,
      "description": "Maximum amount of memory the PostgreSQL container can use.",
      "value": "512Mi"
    },
    {
      "name": "SOURCE_REPOSITORY_URL",
      "displayName": "Git Repository URL",
      "required": true,
      "description": "The URL of the repository with your application source code.",
      "value": "https://github.com/openshift/django-ex.git"
    },
    {
      "name": "SOURCE_REPOSITORY_REF",
      "displayName": "Git Reference",
      "description": "Set this to a branch name, tag or other ref of your repository if you are not using the default branch."
    },
    {
      "name": "CONTEXT_DIR",
      "displayName": "Context Directory",
      "description": "Set this to the relative path to your project if it is not in the root of your repository."
    },
    {
      "name": "APPLICATION_DOMAIN",
      "displayName": "Application Hostname",
      "description": "The exposed hostname that will route to the Django service, if left blank a value will be defaulted.",
      "value": ""
    },
    {
      "name": "GITHUB_WEBHOOK_SECRET",
      "displayName": "GitHub Webhook Secret",
      "description": "A secret string used to configure the GitHub webhook.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{40}"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "required": true,
      "value": "postgresql"
    },
    {
      "name": "DATABASE_ENGINE",
      "displayName": "Database Engine",
      "required": true,
      "description": "Database engine: postgresql, mysql or sqlite (default).",
      "value": "postgresql"
    },
    {
      "name": "DATABASE_NAME",
      "displayName": "Database Name",
      "required": true,
      "value": "default"
    },
    {
      "name": "DATABASE_USER",
      "displayName": "Database Username",
      "required": true,
      "value": "django"
    },
    {
      "name": "DATABASE_PASSWORD",
      "displayName": "Database User Password",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}"
    },
    {
      "name": "APP_CONFIG",
      "displayName": "Application Configuration File Path",
      "description": "Relative path to Gunicorn configuration file (optional)."
    },
    {
      "name": "DJANGO_SECRET_KEY",
      "displayName": "Django Secret Key",
      "description": "Set this to a long random string.",
      "generate": "expression",
      "from": "[\\w]{50}"
    },
    {
      "name": "PIP_INDEX_URL",
      "displayName": "Custom PyPi Index URL",
      "description": "The custom PyPi index URL",
      "value": ""
    }
  ]
}
`)

func examplesQuickstartsDjangoPostgresqlJsonBytes() ([]byte, error) {
	return _examplesQuickstartsDjangoPostgresqlJson, nil
}

func examplesQuickstartsDjangoPostgresqlJson() (*asset, error) {
	bytes, err := examplesQuickstartsDjangoPostgresqlJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/quickstarts/django-postgresql.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesQuickstartsNodejsMongodbJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "nodejs-mongodb-example",
    "annotations": {
      "description": "An example Node.js application with a MongoDB database",
      "tags": "quickstart,nodejs,mongodb",
      "iconClass": "icon-nodejs"
    }
  },
  "labels": {
    "template": "nodejs-mongodb-example"
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Exposes and load balances the application pods"
        }
      },
      "spec": {
        "ports": [
          {
            "name": "web",
            "port": 8080,
            "targetPort": 8080
          }
        ],
        "selector": {
          "name": "${NAME}"
        }
      }
    },
    {
      "kind": "Route",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}"
      },
      "spec": {
        "host": "${APPLICATION_DOMAIN}",
        "to": {
          "kind": "Service",
          "name": "${NAME}"
        }
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Keeps track of changes in the application image"
        }
      }
    },
    {
      "kind": "BuildConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Defines how to build the application"
        }
      },
      "spec": {
        "source": {
          "type": "Git",
          "git": {
            "uri": "${SOURCE_REPOSITORY_URL}",
            "ref": "${SOURCE_REPOSITORY_REF}"
          },
          "contextDir": "${CONTEXT_DIR}"
        },
        "strategy": {
          "type": "Source",
          "sourceStrategy": {
            "from": {
              "kind": "ImageStreamTag",
              "namespace": "${NAMESPACE}",
              "name": "nodejs:4"
            },
            "env":  [
              {
                  "name": "NPM_MIRROR",
                  "value": "${NPM_MIRROR}"
              }
            ]
          }
        },
        "output": {
          "to": {
            "kind": "ImageStreamTag",
            "name": "${NAME}:latest"
          }
        },
        "triggers": [
          {
            "type": "ImageChange"
          },
          {
            "type": "ConfigChange"
          },
          {
            "type": "GitHub",
            "github": {
              "secret": "${GITHUB_WEBHOOK_SECRET}"
            }
          },
          {
            "type": "Generic",
            "generic": {
              "secret": "${GENERIC_WEBHOOK_SECRET}"
            }
          }
        ],
        "postCommit": {
          "script": "npm test"
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Defines how to deploy the application server"
        }
      },
      "spec": {
        "strategy": {
          "type": "Rolling"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "nodejs-mongodb-example"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "${NAME}:latest"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${NAME}"
        },
        "template": {
          "metadata": {
            "name": "${NAME}",
            "labels": {
              "name": "${NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "nodejs-mongodb-example",
                "image": " ",
                "ports": [
                  {
                    "containerPort": 8080
                  }
                ],
                "env": [
                  {
                    "name": "DATABASE_SERVICE_NAME",
                    "value": "${DATABASE_SERVICE_NAME}"
                  },
                  {
                    "name": "MONGODB_USER",
                    "value": "${DATABASE_USER}"
                  },
                  {
                    "name": "MONGODB_PASSWORD",
                    "value": "${DATABASE_PASSWORD}"
                  },
                  {
                    "name": "MONGODB_DATABASE",
                    "value": "${DATABASE_NAME}"
                  },
                  {
                    "name": "MONGODB_ADMIN_PASSWORD",
                    "value": "${DATABASE_ADMIN_PASSWORD}"
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 3,
                  "initialDelaySeconds": 3,
                  "httpGet": {
                    "path": "/pagecount",
                    "port": 8080
                  }
                },
                "livenessProbe": {
                    "timeoutSeconds": 3,
                    "initialDelaySeconds": 30,
                    "httpGet": {
                        "path": "/pagecount",
                        "port": 8080
                    }
                },
                "resources": {
                    "limits": {
                        "memory": "${MEMORY_LIMIT}"
                    }
                }
              }
            ]
          }
        }
      }
    },
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "annotations": {
          "description": "Exposes the database server"
        }
      },
      "spec": {
        "ports": [
          {
            "name": "mongodb",
            "port": 27017,
            "targetPort": 27017
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "annotations": {
          "description": "Defines how to deploy the database"
        }
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "mongodb"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "namespace": "${NAMESPACE}",
                "name": "mongodb:3.2"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "name": "${DATABASE_SERVICE_NAME}",
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "mongodb",
                "image": " ",
                "ports": [
                  {
                    "containerPort": 27017
                  }
                ],
                "env": [
                  {
                    "name": "MONGODB_USER",
                    "value": "${DATABASE_USER}"
                  },
                  {
                    "name": "MONGODB_PASSWORD",
                    "value": "${DATABASE_PASSWORD}"
                  },
                  {
                    "name": "MONGODB_DATABASE",
                    "value": "${DATABASE_NAME}"
                  },
                  {
                    "name": "MONGODB_ADMIN_PASSWORD",
                    "value": "${DATABASE_ADMIN_PASSWORD}"
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 3,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c", "mongo 127.0.0.1:27017/$MONGODB_DATABASE -u $MONGODB_USER -p $MONGODB_PASSWORD --eval=\"quit()\""]
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 30,
                  "tcpSocket": {
                    "port": 27017
                  }
                },
                "resources": {
                    "limits": {
                        "memory": "${MEMORY_MONGODB_LIMIT}"
                    }
                },
                "volumeMounts": [
                  {
                    "name": "${DATABASE_SERVICE_NAME}-data",
                    "mountPath": "/var/lib/mongodb/data"
                  }
                ]
              }
            ],
            "volumes": [
              {
                "name": "${DATABASE_SERVICE_NAME}-data",
                "emptyDir": {
                  "medium": ""
                }
              }
            ]
          }
        }
      }
    }
  ],
  "parameters": [
    {
      "name": "NAME",
      "displayName": "Name",
      "description": "The name assigned to all of the frontend objects defined in this template.",
      "required": true,
      "value": "nodejs-mongodb-example"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "required": true,
      "value": "openshift"
    },
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the Node.js container can use.",
      "required": true,
      "value": "512Mi"
    },
    {
      "name": "MEMORY_MONGODB_LIMIT",
      "displayName": "Memory Limit (MongoDB)",
      "description": "Maximum amount of memory the MongoDB container can use.",
      "required": true,
      "value": "512Mi"
    },
    {
      "name": "SOURCE_REPOSITORY_URL",
      "displayName": "Git Repository URL",
      "description": "The URL of the repository with your application source code.",
      "required": true,
      "value": "https://github.com/openshift/nodejs-ex.git"
    },
    {
      "name": "SOURCE_REPOSITORY_REF",
      "displayName": "Git Reference",
      "description": "Set this to a branch name, tag or other ref of your repository if you are not using the default branch."
    },
    {
      "name": "CONTEXT_DIR",
      "displayName": "Context Directory",
      "description": "Set this to the relative path to your project if it is not in the root of your repository."
    },
    {
      "name": "APPLICATION_DOMAIN",
      "displayName": "Application Hostname",
      "description": "The exposed hostname that will route to the Node.js service, if left blank a value will be defaulted.",
      "value": ""
    },
    {
      "name": "GITHUB_WEBHOOK_SECRET",
      "displayName": "GitHub Webhook Secret",
      "description": "A secret string used to configure the GitHub webhook.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{40}"
    },
    {
      "name": "GENERIC_WEBHOOK_SECRET",
      "displayName": "Generic Webhook Secret",
      "description": "A secret string used to configure the Generic webhook.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{40}"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "required": true,
      "value": "mongodb"
    },
    {
      "name": "DATABASE_USER",
      "displayName": "MongoDB Username",
      "description": "Username for MongoDB user that will be used for accessing the database.",
      "generate": "expression",
      "from": "user[A-Z0-9]{3}"
    },
    {
      "name": "DATABASE_PASSWORD",
      "displayName": "MongoDB Password",
      "description": "Password for the MongoDB user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}"
    },
    {
      "name": "DATABASE_NAME",
      "displayName": "Database Name",
      "required": true,
      "value": "sampledb"
    },
    {
      "name": "DATABASE_ADMIN_PASSWORD",
      "displayName": "Database Administrator Password",
      "description": "Password for the database admin user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}"
    },
    {
      "name": "NPM_MIRROR",
      "displayName": "Custom NPM Mirror URL",
      "description": "The custom NPM mirror URL",
      "value": ""
    }
  ]
}
`)

func examplesQuickstartsNodejsMongodbJsonBytes() ([]byte, error) {
	return _examplesQuickstartsNodejsMongodbJson, nil
}

func examplesQuickstartsNodejsMongodbJson() (*asset, error) {
	bytes, err := examplesQuickstartsNodejsMongodbJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/quickstarts/nodejs-mongodb.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesQuickstartsRailsPostgresqlJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "rails-postgresql-example",
    "annotations": {
      "description": "An example Rails application with a PostgreSQL database",
      "tags": "quickstart,ruby,rails,postgresql",
      "iconClass": "icon-ruby"
    }
  },
  "labels": {
    "template": "rails-postgresql-example"
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Exposes and load balances the application pods"
        }
      },
      "spec": {
        "ports": [
          {
            "name": "web",
            "port": 8080,
            "targetPort": 8080
          }
        ],
        "selector": {
          "name": "${NAME}"
        }
      }
    },
    {
      "kind": "Route",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}"
      },
      "spec": {
        "host": "${APPLICATION_DOMAIN}",
        "to": {
          "kind": "Service",
          "name": "${NAME}"
        }
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Keeps track of changes in the application image"
        }
      }
    },
    {
      "kind": "BuildConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Defines how to build the application"
        }
      },
      "spec": {
        "source": {
          "type": "Git",
          "git": {
            "uri": "${SOURCE_REPOSITORY_URL}",
            "ref": "${SOURCE_REPOSITORY_REF}"
          },
          "contextDir": "${CONTEXT_DIR}"
        },
        "strategy": {
          "type": "Source",
          "sourceStrategy": {
            "from": {
              "kind": "ImageStreamTag",
              "namespace": "${NAMESPACE}",
              "name": "ruby:2.3"
            },
            "env": [
              {
                  "name": "RUBYGEM_MIRROR",
                  "value": "${RUBYGEM_MIRROR}"
              }
            ]
          }
        },
        "output": {
          "to": {
            "kind": "ImageStreamTag",
            "name": "${NAME}:latest"
          }
        },
        "triggers": [
          {
            "type": "ImageChange"
          },
          {
            "type": "ConfigChange"
          },
          {
            "type": "GitHub",
            "github": {
              "secret": "${GITHUB_WEBHOOK_SECRET}"
            }
          }
        ],
        "postCommit": {
          "script": "bundle exec rake test"
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Defines how to deploy the application server"
        }
      },
      "spec": {
        "strategy": {
          "type": "Recreate",
          "recreateParams": {
          "pre": {
              "failurePolicy": "Abort",
              "execNewPod": {
                "command": [
                  "./migrate-database.sh"
                ],
                "containerName": "${NAME}"
              }
            }
          }
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "rails-postgresql-example"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "${NAME}:latest"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${NAME}"
        },
        "template": {
          "metadata": {
            "name": "${NAME}",
            "labels": {
              "name": "${NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "rails-postgresql-example",
                "image": " ",
                "ports": [
                  {
                    "containerPort": 8080
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 3,
                  "initialDelaySeconds": 5,
                  "httpGet": {
                    "path": "/articles",
                    "port": 8080
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 3,
                  "initialDelaySeconds": 10,
                  "httpGet": {
                    "path": "/articles",
                    "port": 8080
                  }
                },
                "env": [
                  {
                    "name": "DATABASE_SERVICE_NAME",
                    "value": "${DATABASE_SERVICE_NAME}"
                  },
                  {
                    "name": "POSTGRESQL_USER",
                    "value": "${DATABASE_USER}"
                  },
                  {
                    "name": "POSTGRESQL_PASSWORD",
                    "value": "${DATABASE_PASSWORD}"
                  },
                  {
                    "name": "POSTGRESQL_DATABASE",
                    "value": "${DATABASE_NAME}"
                  },
                  {
                    "name": "SECRET_KEY_BASE",
                    "value": "${SECRET_KEY_BASE}"
                  },
                  {
                    "name": "POSTGRESQL_MAX_CONNECTIONS",
                    "value": "${POSTGRESQL_MAX_CONNECTIONS}"
                  },
                  {
                    "name": "POSTGRESQL_SHARED_BUFFERS",
                    "value": "${POSTGRESQL_SHARED_BUFFERS}"
                  },
                  {
                    "name": "APPLICATION_DOMAIN",
                    "value": "${APPLICATION_DOMAIN}"
                  },
                  {
                    "name": "APPLICATION_USER",
                    "value": "${APPLICATION_USER}"
                  },
                  {
                    "name": "APPLICATION_PASSWORD",
                    "value": "${APPLICATION_PASSWORD}"
                  },
                  {
                    "name": "RAILS_ENV",
                    "value": "${RAILS_ENV}"
                  }
                ],
                "resources": {
		      "limits": {
			  "memory": "${MEMORY_LIMIT}"
		      }
                }
              }
            ]
          }
        }
      }
    },
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "annotations": {
          "description": "Exposes the database server"
        }
      },
      "spec": {
        "ports": [
          {
            "name": "postgresql",
            "port": 5432,
            "targetPort": 5432
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "annotations": {
          "description": "Defines how to deploy the database"
        }
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "postgresql"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "namespace": "${NAMESPACE}",
                "name": "postgresql:9.5"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "name": "${DATABASE_SERVICE_NAME}",
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "volumes": [
              {
                "name": "data",
                "emptyDir": {}
              }
            ],
            "containers": [
              {
                "name": "postgresql",
                "image": " ",
                "ports": [
                  {
                    "containerPort": 5432
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 5,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c", "psql -h 127.0.0.1 -U ${POSTGRESQL_USER} -q -d ${POSTGRESQL_DATABASE} -c 'SELECT 1'"]
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 30,
                  "tcpSocket": {
                    "port": 5432
                  }
                },
                "volumeMounts": [
                  {
                    "name": "data",
                    "mountPath": "/var/lib/pgsql/data"
                  }
                ],
                "env": [
                  {
                    "name": "POSTGRESQL_USER",
                    "value": "${DATABASE_USER}"
                  },
                  {
                    "name": "POSTGRESQL_PASSWORD",
                    "value": "${DATABASE_PASSWORD}"
                  },
                  {
                    "name": "POSTGRESQL_DATABASE",
                    "value": "${DATABASE_NAME}"
                  },
                  {
                    "name": "POSTGRESQL_MAX_CONNECTIONS",
                    "value": "${POSTGRESQL_MAX_CONNECTIONS}"
                  },
                  {
                    "name": "POSTGRESQL_SHARED_BUFFERS",
                    "value": "${POSTGRESQL_SHARED_BUFFERS}"
                  }
                ],
                "resources": {
		      "limits": {
			  "memory": "${MEMORY_POSTGRESQL_LIMIT}"
		      }
                }
              }
            ]
          }
        }
      }
    }
  ],
  "parameters": [
    {
      "name": "NAME",
      "displayName": "Name",
      "description": "The name assigned to all of the frontend objects defined in this template.",
      "required": true,
      "value": "rails-postgresql-example"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "required": true,
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "required": true,
      "description": "Maximum amount of memory the Rails container can use.",
      "value": "512Mi"
    },
    {
      "name": "MEMORY_POSTGRESQL_LIMIT",
      "displayName": "Memory Limit (PostgreSQL)",
      "required": true,
      "description": "Maximum amount of memory the PostgreSQL container can use.",
      "value": "512Mi"
    },
    {
      "name": "SOURCE_REPOSITORY_URL",
      "displayName": "Git Repository URL",
      "required": true,
      "description": "The URL of the repository with your application source code.",
      "value": "https://github.com/openshift/rails-ex.git"
    },
    {
      "name": "SOURCE_REPOSITORY_REF",
      "displayName": "Git Reference",
      "description": "Set this to a branch name, tag or other ref of your repository if you are not using the default branch."
    },
    {
      "name": "CONTEXT_DIR",
      "displayName": "Context Directory",
      "description": "Set this to the relative path to your project if it is not in the root of your repository."
    },
    {
      "name": "APPLICATION_DOMAIN",
      "displayName": "Application Hostname",
      "description": "The exposed hostname that will route to the Rails service, if left blank a value will be defaulted.",
      "value": ""
    },
    {
      "name": "GITHUB_WEBHOOK_SECRET",
      "displayName": "GitHub Webhook Secret",
      "description": "A secret string used to configure the GitHub webhook.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{40}"
    },
    {
      "name": "SECRET_KEY_BASE",
      "displayName": "Secret Key",
      "description": "Your secret key for verifying the integrity of signed cookies.",
      "generate": "expression",
      "from": "[a-z0-9]{127}"
    },
    {
      "name": "APPLICATION_USER",
      "displayName": "Application Username",
      "required": true,
      "description": "The application user that is used within the sample application to authorize access on pages.",
      "value": "openshift"
    },
    {
      "name": "APPLICATION_PASSWORD",
      "displayName": "Application Password",
      "required": true,
      "description": "The application password that is used within the sample application to authorize access on pages.",
      "value": "secret"
    },
    {
      "name": "RAILS_ENV",
      "displayName": "Rails Environment",
      "required": true,
      "description": "Environment under which the sample application will run. Could be set to production, development or test.",
      "value": "production"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "required": true,
      "displayName": "Database Service Name",
      "value": "postgresql"
    },
    {
      "name": "DATABASE_USER",
      "displayName": "Database Username",
      "generate": "expression",
      "from": "user[A-Z0-9]{3}"
    },
    {
      "name": "DATABASE_PASSWORD",
      "displayName": "Database Password",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{8}"
    },
    {
      "name": "DATABASE_NAME",
      "required": true,
      "displayName": "Database Name",
      "value": "root"
    },
    {
      "name": "POSTGRESQL_MAX_CONNECTIONS",
      "displayName": "Maximum Database Connections",
      "value": "100"
    },
    {
      "name": "POSTGRESQL_SHARED_BUFFERS",
      "displayName": "Shared Buffer Amount",
      "value": "12MB"
    },
    {
      "name": "RUBYGEM_MIRROR",
      "displayName": "Custom RubyGems Mirror URL",
      "description": "The custom RubyGems mirror URL",
      "value": ""
    }
  ]
}
`)

func examplesQuickstartsRailsPostgresqlJsonBytes() ([]byte, error) {
	return _examplesQuickstartsRailsPostgresqlJson, nil
}

func examplesQuickstartsRailsPostgresqlJson() (*asset, error) {
	bytes, err := examplesQuickstartsRailsPostgresqlJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/quickstarts/rails-postgresql.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _pkgImageAdmissionImagepolicyApiV1DefaultPolicyYaml = []byte(`kind: ImagePolicyConfig
apiVersion: v1
# To require that all images running on the platform be imported first, you may uncomment the
# following rule. Any image that refers to a registry outside of OpenShift will be rejected unless it
# unless it points directly to an image digest (myregistry.com/myrepo/image@sha256:ea83bcf...) and that
# digest has been imported via the import-image flow.
#resolveImages: Required
executionRules:
- name: execution-denied
  # Reject all images that have the annotation images.openshift.io/deny-execution set to true.
  # This annotation may be set by infrastructure that wishes to flag particular images as dangerous
  onResources:
  - resource: pods
  - resource: builds
  reject: true
  matchImageAnnotations:
  - key: images.openshift.io/deny-execution
    value: "true"
  skipOnResolutionFailure: true

`)

func pkgImageAdmissionImagepolicyApiV1DefaultPolicyYamlBytes() ([]byte, error) {
	return _pkgImageAdmissionImagepolicyApiV1DefaultPolicyYaml, nil
}

func pkgImageAdmissionImagepolicyApiV1DefaultPolicyYaml() (*asset, error) {
	bytes, err := pkgImageAdmissionImagepolicyApiV1DefaultPolicyYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "pkg/image/admission/imagepolicy/api/v1/default-policy.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if (err != nil) {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"examples/image-streams/image-streams-centos7.json": examplesImageStreamsImageStreamsCentos7Json,
	"examples/image-streams/image-streams-rhel7.json": examplesImageStreamsImageStreamsRhel7Json,
	"examples/db-templates/mariadb-ephemeral-template.json": examplesDbTemplatesMariadbEphemeralTemplateJson,
	"examples/db-templates/mariadb-persistent-template.json": examplesDbTemplatesMariadbPersistentTemplateJson,
	"examples/db-templates/mongodb-ephemeral-template.json": examplesDbTemplatesMongodbEphemeralTemplateJson,
	"examples/db-templates/mongodb-persistent-template.json": examplesDbTemplatesMongodbPersistentTemplateJson,
	"examples/db-templates/mysql-ephemeral-template.json": examplesDbTemplatesMysqlEphemeralTemplateJson,
	"examples/db-templates/mysql-persistent-template.json": examplesDbTemplatesMysqlPersistentTemplateJson,
	"examples/db-templates/postgresql-ephemeral-template.json": examplesDbTemplatesPostgresqlEphemeralTemplateJson,
	"examples/db-templates/postgresql-persistent-template.json": examplesDbTemplatesPostgresqlPersistentTemplateJson,
	"examples/jenkins/jenkins-ephemeral-template.json": examplesJenkinsJenkinsEphemeralTemplateJson,
	"examples/jenkins/jenkins-persistent-template.json": examplesJenkinsJenkinsPersistentTemplateJson,
	"examples/jenkins/pipeline/samplepipeline.json": examplesJenkinsPipelineSamplepipelineJson,
	"examples/quickstarts/cakephp-mysql.json": examplesQuickstartsCakephpMysqlJson,
	"examples/quickstarts/dancer-mysql.json": examplesQuickstartsDancerMysqlJson,
	"examples/quickstarts/django-postgresql.json": examplesQuickstartsDjangoPostgresqlJson,
	"examples/quickstarts/nodejs-mongodb.json": examplesQuickstartsNodejsMongodbJson,
	"examples/quickstarts/rails-postgresql.json": examplesQuickstartsRailsPostgresqlJson,
	"pkg/image/admission/imagepolicy/api/v1/default-policy.yaml": pkgImageAdmissionImagepolicyApiV1DefaultPolicyYaml,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func func() (*asset, error)
	Children map[string]*bintree
}
var _bintree = &bintree{nil, map[string]*bintree{
	"examples": &bintree{nil, map[string]*bintree{
		"db-templates": &bintree{nil, map[string]*bintree{
			"mariadb-ephemeral-template.json": &bintree{examplesDbTemplatesMariadbEphemeralTemplateJson, map[string]*bintree{
			}},
			"mariadb-persistent-template.json": &bintree{examplesDbTemplatesMariadbPersistentTemplateJson, map[string]*bintree{
			}},
			"mongodb-ephemeral-template.json": &bintree{examplesDbTemplatesMongodbEphemeralTemplateJson, map[string]*bintree{
			}},
			"mongodb-persistent-template.json": &bintree{examplesDbTemplatesMongodbPersistentTemplateJson, map[string]*bintree{
			}},
			"mysql-ephemeral-template.json": &bintree{examplesDbTemplatesMysqlEphemeralTemplateJson, map[string]*bintree{
			}},
			"mysql-persistent-template.json": &bintree{examplesDbTemplatesMysqlPersistentTemplateJson, map[string]*bintree{
			}},
			"postgresql-ephemeral-template.json": &bintree{examplesDbTemplatesPostgresqlEphemeralTemplateJson, map[string]*bintree{
			}},
			"postgresql-persistent-template.json": &bintree{examplesDbTemplatesPostgresqlPersistentTemplateJson, map[string]*bintree{
			}},
		}},
		"image-streams": &bintree{nil, map[string]*bintree{
			"image-streams-centos7.json": &bintree{examplesImageStreamsImageStreamsCentos7Json, map[string]*bintree{
			}},
			"image-streams-rhel7.json": &bintree{examplesImageStreamsImageStreamsRhel7Json, map[string]*bintree{
			}},
		}},
		"jenkins": &bintree{nil, map[string]*bintree{
			"jenkins-ephemeral-template.json": &bintree{examplesJenkinsJenkinsEphemeralTemplateJson, map[string]*bintree{
			}},
			"jenkins-persistent-template.json": &bintree{examplesJenkinsJenkinsPersistentTemplateJson, map[string]*bintree{
			}},
			"pipeline": &bintree{nil, map[string]*bintree{
				"samplepipeline.json": &bintree{examplesJenkinsPipelineSamplepipelineJson, map[string]*bintree{
				}},
			}},
		}},
		"quickstarts": &bintree{nil, map[string]*bintree{
			"cakephp-mysql.json": &bintree{examplesQuickstartsCakephpMysqlJson, map[string]*bintree{
			}},
			"dancer-mysql.json": &bintree{examplesQuickstartsDancerMysqlJson, map[string]*bintree{
			}},
			"django-postgresql.json": &bintree{examplesQuickstartsDjangoPostgresqlJson, map[string]*bintree{
			}},
			"nodejs-mongodb.json": &bintree{examplesQuickstartsNodejsMongodbJson, map[string]*bintree{
			}},
			"rails-postgresql.json": &bintree{examplesQuickstartsRailsPostgresqlJson, map[string]*bintree{
			}},
		}},
	}},
	"pkg": &bintree{nil, map[string]*bintree{
		"image": &bintree{nil, map[string]*bintree{
			"admission": &bintree{nil, map[string]*bintree{
				"imagepolicy": &bintree{nil, map[string]*bintree{
					"api": &bintree{nil, map[string]*bintree{
						"v1": &bintree{nil, map[string]*bintree{
							"default-policy.yaml": &bintree{pkgImageAdmissionImagepolicyApiV1DefaultPolicyYaml, map[string]*bintree{
							}},
						}},
					}},
				}},
			}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
        data, err := Asset(name)
        if err != nil {
                return err
        }
        info, err := AssetInfo(name)
        if err != nil {
                return err
        }
        err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
        if err != nil {
                return err
        }
        err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
        if err != nil {
                return err
        }
        err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
        if err != nil {
                return err
        }
        return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
        children, err := AssetDir(name)
        // File
        if err != nil {
                return RestoreAsset(dir, name)
        }
        // Dir
        for _, child := range children {
                err = RestoreAssets(dir, filepath.Join(name, child))
                if err != nil {
                        return err
                }
        }
        return nil
}

func _filePath(dir, name string) string {
        cannonicalName := strings.Replace(name, "\\", "/", -1)
        return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}

