// +build !ignore_autogenerated_openshift

// This file was autogenerated by deepcopy-gen. Do not edit it manually!

package api

import (
	api "k8s.io/kubernetes/pkg/api"
	unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	conversion "k8s.io/kubernetes/pkg/conversion"
)

func init() {
	if err := api.Scheme.AddGeneratedDeepCopyFuncs(
		DeepCopy_api_Descriptor,
		DeepCopy_api_DockerConfig,
		DeepCopy_api_DockerConfigHistory,
		DeepCopy_api_DockerConfigRootFS,
		DeepCopy_api_DockerFSLayer,
		DeepCopy_api_DockerHistory,
		DeepCopy_api_DockerImage,
		DeepCopy_api_DockerImageConfig,
		DeepCopy_api_DockerImageManifest,
		DeepCopy_api_DockerImageReference,
		DeepCopy_api_DockerV1CompatibilityImage,
		DeepCopy_api_DockerV1CompatibilityImageSize,
		DeepCopy_api_Image,
		DeepCopy_api_ImageImportSpec,
		DeepCopy_api_ImageImportStatus,
		DeepCopy_api_ImageLayer,
		DeepCopy_api_ImageList,
		DeepCopy_api_ImageSignature,
		DeepCopy_api_ImageStream,
		DeepCopy_api_ImageStreamImage,
		DeepCopy_api_ImageStreamImport,
		DeepCopy_api_ImageStreamImportSpec,
		DeepCopy_api_ImageStreamImportStatus,
		DeepCopy_api_ImageStreamList,
		DeepCopy_api_ImageStreamMapping,
		DeepCopy_api_ImageStreamSpec,
		DeepCopy_api_ImageStreamStatus,
		DeepCopy_api_ImageStreamTag,
		DeepCopy_api_ImageStreamTagList,
		DeepCopy_api_RepositoryImportSpec,
		DeepCopy_api_RepositoryImportStatus,
		DeepCopy_api_SignatureCondition,
		DeepCopy_api_SignatureGenericEntity,
		DeepCopy_api_SignatureIssuer,
		DeepCopy_api_SignatureSubject,
		DeepCopy_api_TagEvent,
		DeepCopy_api_TagEventCondition,
		DeepCopy_api_TagEventList,
		DeepCopy_api_TagImportPolicy,
		DeepCopy_api_TagReference,
	); err != nil {
		// if one of the deep copy functions is malformed, detect it immediately.
		panic(err)
	}
}

func DeepCopy_api_Descriptor(in Descriptor, out *Descriptor, c *conversion.Cloner) error {
	out.MediaType = in.MediaType
	out.Size = in.Size
	out.Digest = in.Digest
	return nil
}

func DeepCopy_api_DockerConfig(in DockerConfig, out *DockerConfig, c *conversion.Cloner) error {
	out.Hostname = in.Hostname
	out.Domainname = in.Domainname
	out.User = in.User
	out.Memory = in.Memory
	out.MemorySwap = in.MemorySwap
	out.CPUShares = in.CPUShares
	out.CPUSet = in.CPUSet
	out.AttachStdin = in.AttachStdin
	out.AttachStdout = in.AttachStdout
	out.AttachStderr = in.AttachStderr
	if in.PortSpecs != nil {
		in, out := in.PortSpecs, &out.PortSpecs
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.PortSpecs = nil
	}
	if in.ExposedPorts != nil {
		in, out := in.ExposedPorts, &out.ExposedPorts
		*out = make(map[string]struct{})
		for key, val := range in {
			if newVal, err := c.DeepCopy(val); err != nil {
				return err
			} else {
				(*out)[key] = newVal.(struct{})
			}
		}
	} else {
		out.ExposedPorts = nil
	}
	out.Tty = in.Tty
	out.OpenStdin = in.OpenStdin
	out.StdinOnce = in.StdinOnce
	if in.Env != nil {
		in, out := in.Env, &out.Env
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.Env = nil
	}
	if in.Cmd != nil {
		in, out := in.Cmd, &out.Cmd
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.Cmd = nil
	}
	if in.DNS != nil {
		in, out := in.DNS, &out.DNS
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.DNS = nil
	}
	out.Image = in.Image
	if in.Volumes != nil {
		in, out := in.Volumes, &out.Volumes
		*out = make(map[string]struct{})
		for key, val := range in {
			if newVal, err := c.DeepCopy(val); err != nil {
				return err
			} else {
				(*out)[key] = newVal.(struct{})
			}
		}
	} else {
		out.Volumes = nil
	}
	out.VolumesFrom = in.VolumesFrom
	out.WorkingDir = in.WorkingDir
	if in.Entrypoint != nil {
		in, out := in.Entrypoint, &out.Entrypoint
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.Entrypoint = nil
	}
	out.NetworkDisabled = in.NetworkDisabled
	if in.SecurityOpts != nil {
		in, out := in.SecurityOpts, &out.SecurityOpts
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.SecurityOpts = nil
	}
	if in.OnBuild != nil {
		in, out := in.OnBuild, &out.OnBuild
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.OnBuild = nil
	}
	if in.Labels != nil {
		in, out := in.Labels, &out.Labels
		*out = make(map[string]string)
		for key, val := range in {
			(*out)[key] = val
		}
	} else {
		out.Labels = nil
	}
	return nil
}

func DeepCopy_api_DockerConfigHistory(in DockerConfigHistory, out *DockerConfigHistory, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_Time(in.Created, &out.Created, c); err != nil {
		return err
	}
	out.Author = in.Author
	out.CreatedBy = in.CreatedBy
	out.Comment = in.Comment
	out.EmptyLayer = in.EmptyLayer
	return nil
}

func DeepCopy_api_DockerConfigRootFS(in DockerConfigRootFS, out *DockerConfigRootFS, c *conversion.Cloner) error {
	out.Type = in.Type
	if in.DiffIDs != nil {
		in, out := in.DiffIDs, &out.DiffIDs
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.DiffIDs = nil
	}
	return nil
}

func DeepCopy_api_DockerFSLayer(in DockerFSLayer, out *DockerFSLayer, c *conversion.Cloner) error {
	out.DockerBlobSum = in.DockerBlobSum
	return nil
}

func DeepCopy_api_DockerHistory(in DockerHistory, out *DockerHistory, c *conversion.Cloner) error {
	out.DockerV1Compatibility = in.DockerV1Compatibility
	return nil
}

func DeepCopy_api_DockerImage(in DockerImage, out *DockerImage, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	out.ID = in.ID
	out.Parent = in.Parent
	out.Comment = in.Comment
	if err := unversioned.DeepCopy_unversioned_Time(in.Created, &out.Created, c); err != nil {
		return err
	}
	out.Container = in.Container
	if err := DeepCopy_api_DockerConfig(in.ContainerConfig, &out.ContainerConfig, c); err != nil {
		return err
	}
	out.DockerVersion = in.DockerVersion
	out.Author = in.Author
	if in.Config != nil {
		in, out := in.Config, &out.Config
		*out = new(DockerConfig)
		if err := DeepCopy_api_DockerConfig(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Config = nil
	}
	out.Architecture = in.Architecture
	out.Size = in.Size
	return nil
}

func DeepCopy_api_DockerImageConfig(in DockerImageConfig, out *DockerImageConfig, c *conversion.Cloner) error {
	out.ID = in.ID
	out.Parent = in.Parent
	out.Comment = in.Comment
	if err := unversioned.DeepCopy_unversioned_Time(in.Created, &out.Created, c); err != nil {
		return err
	}
	out.Container = in.Container
	if err := DeepCopy_api_DockerConfig(in.ContainerConfig, &out.ContainerConfig, c); err != nil {
		return err
	}
	out.DockerVersion = in.DockerVersion
	out.Author = in.Author
	if in.Config != nil {
		in, out := in.Config, &out.Config
		*out = new(DockerConfig)
		if err := DeepCopy_api_DockerConfig(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Config = nil
	}
	out.Architecture = in.Architecture
	out.Size = in.Size
	if in.RootFS != nil {
		in, out := in.RootFS, &out.RootFS
		*out = new(DockerConfigRootFS)
		if err := DeepCopy_api_DockerConfigRootFS(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.RootFS = nil
	}
	if in.History != nil {
		in, out := in.History, &out.History
		*out = make([]DockerConfigHistory, len(in))
		for i := range in {
			if err := DeepCopy_api_DockerConfigHistory(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.History = nil
	}
	out.OSVersion = in.OSVersion
	if in.OSFeatures != nil {
		in, out := in.OSFeatures, &out.OSFeatures
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.OSFeatures = nil
	}
	return nil
}

func DeepCopy_api_DockerImageManifest(in DockerImageManifest, out *DockerImageManifest, c *conversion.Cloner) error {
	out.SchemaVersion = in.SchemaVersion
	out.MediaType = in.MediaType
	out.Name = in.Name
	out.Tag = in.Tag
	out.Architecture = in.Architecture
	if in.FSLayers != nil {
		in, out := in.FSLayers, &out.FSLayers
		*out = make([]DockerFSLayer, len(in))
		for i := range in {
			if err := DeepCopy_api_DockerFSLayer(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.FSLayers = nil
	}
	if in.History != nil {
		in, out := in.History, &out.History
		*out = make([]DockerHistory, len(in))
		for i := range in {
			if err := DeepCopy_api_DockerHistory(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.History = nil
	}
	if in.Layers != nil {
		in, out := in.Layers, &out.Layers
		*out = make([]Descriptor, len(in))
		for i := range in {
			if err := DeepCopy_api_Descriptor(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Layers = nil
	}
	if err := DeepCopy_api_Descriptor(in.Config, &out.Config, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_DockerImageReference(in DockerImageReference, out *DockerImageReference, c *conversion.Cloner) error {
	out.Registry = in.Registry
	out.Namespace = in.Namespace
	out.Name = in.Name
	out.Tag = in.Tag
	out.ID = in.ID
	return nil
}

func DeepCopy_api_DockerV1CompatibilityImage(in DockerV1CompatibilityImage, out *DockerV1CompatibilityImage, c *conversion.Cloner) error {
	out.ID = in.ID
	out.Parent = in.Parent
	out.Comment = in.Comment
	if err := unversioned.DeepCopy_unversioned_Time(in.Created, &out.Created, c); err != nil {
		return err
	}
	out.Container = in.Container
	if err := DeepCopy_api_DockerConfig(in.ContainerConfig, &out.ContainerConfig, c); err != nil {
		return err
	}
	out.DockerVersion = in.DockerVersion
	out.Author = in.Author
	if in.Config != nil {
		in, out := in.Config, &out.Config
		*out = new(DockerConfig)
		if err := DeepCopy_api_DockerConfig(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Config = nil
	}
	out.Architecture = in.Architecture
	out.Size = in.Size
	return nil
}

func DeepCopy_api_DockerV1CompatibilityImageSize(in DockerV1CompatibilityImageSize, out *DockerV1CompatibilityImageSize, c *conversion.Cloner) error {
	out.Size = in.Size
	return nil
}

func DeepCopy_api_Image(in Image, out *Image, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := api.DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	out.DockerImageReference = in.DockerImageReference
	if err := DeepCopy_api_DockerImage(in.DockerImageMetadata, &out.DockerImageMetadata, c); err != nil {
		return err
	}
	out.DockerImageMetadataVersion = in.DockerImageMetadataVersion
	out.DockerImageManifest = in.DockerImageManifest
	if in.DockerImageLayers != nil {
		in, out := in.DockerImageLayers, &out.DockerImageLayers
		*out = make([]ImageLayer, len(in))
		for i := range in {
			if err := DeepCopy_api_ImageLayer(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.DockerImageLayers = nil
	}
	if in.Signatures != nil {
		in, out := in.Signatures, &out.Signatures
		*out = make([]ImageSignature, len(in))
		for i := range in {
			if err := DeepCopy_api_ImageSignature(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Signatures = nil
	}
	if in.DockerImageSignatures != nil {
		in, out := in.DockerImageSignatures, &out.DockerImageSignatures
		*out = make([][]byte, len(in))
		for i := range in {
			if newVal, err := c.DeepCopy(in[i]); err != nil {
				return err
			} else {
				(*out)[i] = newVal.([]byte)
			}
		}
	} else {
		out.DockerImageSignatures = nil
	}
	out.DockerImageManifestMediaType = in.DockerImageManifestMediaType
	out.DockerImageConfig = in.DockerImageConfig
	return nil
}

func DeepCopy_api_ImageImportSpec(in ImageImportSpec, out *ImageImportSpec, c *conversion.Cloner) error {
	if err := api.DeepCopy_api_ObjectReference(in.From, &out.From, c); err != nil {
		return err
	}
	if in.To != nil {
		in, out := in.To, &out.To
		*out = new(api.LocalObjectReference)
		if err := api.DeepCopy_api_LocalObjectReference(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.To = nil
	}
	if err := DeepCopy_api_TagImportPolicy(in.ImportPolicy, &out.ImportPolicy, c); err != nil {
		return err
	}
	out.IncludeManifest = in.IncludeManifest
	return nil
}

func DeepCopy_api_ImageImportStatus(in ImageImportStatus, out *ImageImportStatus, c *conversion.Cloner) error {
	out.Tag = in.Tag
	if err := unversioned.DeepCopy_unversioned_Status(in.Status, &out.Status, c); err != nil {
		return err
	}
	if in.Image != nil {
		in, out := in.Image, &out.Image
		*out = new(Image)
		if err := DeepCopy_api_Image(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Image = nil
	}
	return nil
}

func DeepCopy_api_ImageLayer(in ImageLayer, out *ImageLayer, c *conversion.Cloner) error {
	out.Name = in.Name
	out.LayerSize = in.LayerSize
	out.MediaType = in.MediaType
	return nil
}

func DeepCopy_api_ImageList(in ImageList, out *ImageList, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_ListMeta(in.ListMeta, &out.ListMeta, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]Image, len(in))
		for i := range in {
			if err := DeepCopy_api_Image(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_ImageSignature(in ImageSignature, out *ImageSignature, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := api.DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	out.Type = in.Type
	if in.Content != nil {
		in, out := in.Content, &out.Content
		*out = make([]byte, len(in))
		copy(*out, in)
	} else {
		out.Content = nil
	}
	if in.Conditions != nil {
		in, out := in.Conditions, &out.Conditions
		*out = make([]SignatureCondition, len(in))
		for i := range in {
			if err := DeepCopy_api_SignatureCondition(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Conditions = nil
	}
	out.ImageIdentity = in.ImageIdentity
	if in.SignedClaims != nil {
		in, out := in.SignedClaims, &out.SignedClaims
		*out = make(map[string]string)
		for key, val := range in {
			(*out)[key] = val
		}
	} else {
		out.SignedClaims = nil
	}
	if in.Created != nil {
		in, out := in.Created, &out.Created
		*out = new(unversioned.Time)
		if err := unversioned.DeepCopy_unversioned_Time(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Created = nil
	}
	if in.IssuedBy != nil {
		in, out := in.IssuedBy, &out.IssuedBy
		*out = new(SignatureIssuer)
		if err := DeepCopy_api_SignatureIssuer(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.IssuedBy = nil
	}
	if in.IssuedTo != nil {
		in, out := in.IssuedTo, &out.IssuedTo
		*out = new(SignatureSubject)
		if err := DeepCopy_api_SignatureSubject(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.IssuedTo = nil
	}
	return nil
}

func DeepCopy_api_ImageStream(in ImageStream, out *ImageStream, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := api.DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ImageStreamSpec(in.Spec, &out.Spec, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ImageStreamStatus(in.Status, &out.Status, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_ImageStreamImage(in ImageStreamImage, out *ImageStreamImage, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := api.DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_Image(in.Image, &out.Image, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_ImageStreamImport(in ImageStreamImport, out *ImageStreamImport, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := api.DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ImageStreamImportSpec(in.Spec, &out.Spec, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ImageStreamImportStatus(in.Status, &out.Status, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_ImageStreamImportSpec(in ImageStreamImportSpec, out *ImageStreamImportSpec, c *conversion.Cloner) error {
	out.Import = in.Import
	if in.Repository != nil {
		in, out := in.Repository, &out.Repository
		*out = new(RepositoryImportSpec)
		if err := DeepCopy_api_RepositoryImportSpec(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Repository = nil
	}
	if in.Images != nil {
		in, out := in.Images, &out.Images
		*out = make([]ImageImportSpec, len(in))
		for i := range in {
			if err := DeepCopy_api_ImageImportSpec(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	return nil
}

func DeepCopy_api_ImageStreamImportStatus(in ImageStreamImportStatus, out *ImageStreamImportStatus, c *conversion.Cloner) error {
	if in.Import != nil {
		in, out := in.Import, &out.Import
		*out = new(ImageStream)
		if err := DeepCopy_api_ImageStream(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Import = nil
	}
	if in.Repository != nil {
		in, out := in.Repository, &out.Repository
		*out = new(RepositoryImportStatus)
		if err := DeepCopy_api_RepositoryImportStatus(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Repository = nil
	}
	if in.Images != nil {
		in, out := in.Images, &out.Images
		*out = make([]ImageImportStatus, len(in))
		for i := range in {
			if err := DeepCopy_api_ImageImportStatus(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	return nil
}

func DeepCopy_api_ImageStreamList(in ImageStreamList, out *ImageStreamList, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_ListMeta(in.ListMeta, &out.ListMeta, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]ImageStream, len(in))
		for i := range in {
			if err := DeepCopy_api_ImageStream(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_ImageStreamMapping(in ImageStreamMapping, out *ImageStreamMapping, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := api.DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	out.DockerImageRepository = in.DockerImageRepository
	if err := DeepCopy_api_Image(in.Image, &out.Image, c); err != nil {
		return err
	}
	out.Tag = in.Tag
	return nil
}

func DeepCopy_api_ImageStreamSpec(in ImageStreamSpec, out *ImageStreamSpec, c *conversion.Cloner) error {
	out.DockerImageRepository = in.DockerImageRepository
	if in.Tags != nil {
		in, out := in.Tags, &out.Tags
		*out = make(map[string]TagReference)
		for key, val := range in {
			newVal := new(TagReference)
			if err := DeepCopy_api_TagReference(val, newVal, c); err != nil {
				return err
			}
			(*out)[key] = *newVal
		}
	} else {
		out.Tags = nil
	}
	return nil
}

func DeepCopy_api_ImageStreamStatus(in ImageStreamStatus, out *ImageStreamStatus, c *conversion.Cloner) error {
	out.DockerImageRepository = in.DockerImageRepository
	if in.Tags != nil {
		in, out := in.Tags, &out.Tags
		*out = make(map[string]TagEventList)
		for key, val := range in {
			newVal := new(TagEventList)
			if err := DeepCopy_api_TagEventList(val, newVal, c); err != nil {
				return err
			}
			(*out)[key] = *newVal
		}
	} else {
		out.Tags = nil
	}
	return nil
}

func DeepCopy_api_ImageStreamTag(in ImageStreamTag, out *ImageStreamTag, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := api.DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if in.Tag != nil {
		in, out := in.Tag, &out.Tag
		*out = new(TagReference)
		if err := DeepCopy_api_TagReference(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Tag = nil
	}
	out.Generation = in.Generation
	if in.Conditions != nil {
		in, out := in.Conditions, &out.Conditions
		*out = make([]TagEventCondition, len(in))
		for i := range in {
			if err := DeepCopy_api_TagEventCondition(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Conditions = nil
	}
	if err := DeepCopy_api_Image(in.Image, &out.Image, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_ImageStreamTagList(in ImageStreamTagList, out *ImageStreamTagList, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_ListMeta(in.ListMeta, &out.ListMeta, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]ImageStreamTag, len(in))
		for i := range in {
			if err := DeepCopy_api_ImageStreamTag(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_RepositoryImportSpec(in RepositoryImportSpec, out *RepositoryImportSpec, c *conversion.Cloner) error {
	if err := api.DeepCopy_api_ObjectReference(in.From, &out.From, c); err != nil {
		return err
	}
	if err := DeepCopy_api_TagImportPolicy(in.ImportPolicy, &out.ImportPolicy, c); err != nil {
		return err
	}
	out.IncludeManifest = in.IncludeManifest
	return nil
}

func DeepCopy_api_RepositoryImportStatus(in RepositoryImportStatus, out *RepositoryImportStatus, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_Status(in.Status, &out.Status, c); err != nil {
		return err
	}
	if in.Images != nil {
		in, out := in.Images, &out.Images
		*out = make([]ImageImportStatus, len(in))
		for i := range in {
			if err := DeepCopy_api_ImageImportStatus(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	if in.AdditionalTags != nil {
		in, out := in.AdditionalTags, &out.AdditionalTags
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.AdditionalTags = nil
	}
	return nil
}

func DeepCopy_api_SignatureCondition(in SignatureCondition, out *SignatureCondition, c *conversion.Cloner) error {
	out.Type = in.Type
	out.Status = in.Status
	if err := unversioned.DeepCopy_unversioned_Time(in.LastProbeTime, &out.LastProbeTime, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_Time(in.LastTransitionTime, &out.LastTransitionTime, c); err != nil {
		return err
	}
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

func DeepCopy_api_SignatureGenericEntity(in SignatureGenericEntity, out *SignatureGenericEntity, c *conversion.Cloner) error {
	out.Organization = in.Organization
	out.CommonName = in.CommonName
	return nil
}

func DeepCopy_api_SignatureIssuer(in SignatureIssuer, out *SignatureIssuer, c *conversion.Cloner) error {
	if err := DeepCopy_api_SignatureGenericEntity(in.SignatureGenericEntity, &out.SignatureGenericEntity, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_SignatureSubject(in SignatureSubject, out *SignatureSubject, c *conversion.Cloner) error {
	if err := DeepCopy_api_SignatureGenericEntity(in.SignatureGenericEntity, &out.SignatureGenericEntity, c); err != nil {
		return err
	}
	out.PublicKeyID = in.PublicKeyID
	return nil
}

func DeepCopy_api_TagEvent(in TagEvent, out *TagEvent, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_Time(in.Created, &out.Created, c); err != nil {
		return err
	}
	out.DockerImageReference = in.DockerImageReference
	out.Image = in.Image
	out.Generation = in.Generation
	return nil
}

func DeepCopy_api_TagEventCondition(in TagEventCondition, out *TagEventCondition, c *conversion.Cloner) error {
	out.Type = in.Type
	out.Status = in.Status
	if err := unversioned.DeepCopy_unversioned_Time(in.LastTransitionTime, &out.LastTransitionTime, c); err != nil {
		return err
	}
	out.Reason = in.Reason
	out.Message = in.Message
	out.Generation = in.Generation
	return nil
}

func DeepCopy_api_TagEventList(in TagEventList, out *TagEventList, c *conversion.Cloner) error {
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]TagEvent, len(in))
		for i := range in {
			if err := DeepCopy_api_TagEvent(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	if in.Conditions != nil {
		in, out := in.Conditions, &out.Conditions
		*out = make([]TagEventCondition, len(in))
		for i := range in {
			if err := DeepCopy_api_TagEventCondition(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Conditions = nil
	}
	return nil
}

func DeepCopy_api_TagImportPolicy(in TagImportPolicy, out *TagImportPolicy, c *conversion.Cloner) error {
	out.Insecure = in.Insecure
	out.Scheduled = in.Scheduled
	return nil
}

func DeepCopy_api_TagReference(in TagReference, out *TagReference, c *conversion.Cloner) error {
	out.Name = in.Name
	if in.Annotations != nil {
		in, out := in.Annotations, &out.Annotations
		*out = make(map[string]string)
		for key, val := range in {
			(*out)[key] = val
		}
	} else {
		out.Annotations = nil
	}
	if in.From != nil {
		in, out := in.From, &out.From
		*out = new(api.ObjectReference)
		if err := api.DeepCopy_api_ObjectReference(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	out.Reference = in.Reference
	if in.Generation != nil {
		in, out := in.Generation, &out.Generation
		*out = new(int64)
		**out = *in
	} else {
		out.Generation = nil
	}
	if err := DeepCopy_api_TagImportPolicy(in.ImportPolicy, &out.ImportPolicy, c); err != nil {
		return err
	}
	return nil
}
