// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package elb provides a client for Elastic Load Balancing.
package elb

import (
	"sync"
	"time"

	"github.com/aws/aws-sdk-go/aws"
)

var oprw sync.Mutex

// AddTagsRequest generates a request for the AddTags operation.
func (c *ELB) AddTagsRequest(input *AddTagsInput) (req *aws.Request, output *AddTagsOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opAddTags == nil {
		opAddTags = &aws.Operation{
			Name:       "AddTags",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &AddTagsInput{}
	}

	req = c.newRequest(opAddTags, input, output)
	output = &AddTagsOutput{}
	req.Data = output
	return
}

// Adds the specified tags to the specified load balancer. Each load balancer
// can have a maximum of 10 tags.
//
// Each tag consists of a key and an optional value. If a tag with the same
// key is already associated with the load balancer, AddTags updates its value.
//
// For more information, see Tagging (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#tagging-elb)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) AddTags(input *AddTagsInput) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	err := req.Send()
	return out, err
}

var opAddTags *aws.Operation

// ApplySecurityGroupsToLoadBalancerRequest generates a request for the ApplySecurityGroupsToLoadBalancer operation.
func (c *ELB) ApplySecurityGroupsToLoadBalancerRequest(input *ApplySecurityGroupsToLoadBalancerInput) (req *aws.Request, output *ApplySecurityGroupsToLoadBalancerOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opApplySecurityGroupsToLoadBalancer == nil {
		opApplySecurityGroupsToLoadBalancer = &aws.Operation{
			Name:       "ApplySecurityGroupsToLoadBalancer",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &ApplySecurityGroupsToLoadBalancerInput{}
	}

	req = c.newRequest(opApplySecurityGroupsToLoadBalancer, input, output)
	output = &ApplySecurityGroupsToLoadBalancerOutput{}
	req.Data = output
	return
}

// Associates one or more security groups with your load balancer in a virtual
// private cloud (VPC). The specified security groups override the previously
// associated security groups.
//
// For more information, see Manage Security Groups for Amazon VPC (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/USVPC_ApplySG.html)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) ApplySecurityGroupsToLoadBalancer(input *ApplySecurityGroupsToLoadBalancerInput) (*ApplySecurityGroupsToLoadBalancerOutput, error) {
	req, out := c.ApplySecurityGroupsToLoadBalancerRequest(input)
	err := req.Send()
	return out, err
}

var opApplySecurityGroupsToLoadBalancer *aws.Operation

// AttachLoadBalancerToSubnetsRequest generates a request for the AttachLoadBalancerToSubnets operation.
func (c *ELB) AttachLoadBalancerToSubnetsRequest(input *AttachLoadBalancerToSubnetsInput) (req *aws.Request, output *AttachLoadBalancerToSubnetsOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opAttachLoadBalancerToSubnets == nil {
		opAttachLoadBalancerToSubnets = &aws.Operation{
			Name:       "AttachLoadBalancerToSubnets",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &AttachLoadBalancerToSubnetsInput{}
	}

	req = c.newRequest(opAttachLoadBalancerToSubnets, input, output)
	output = &AttachLoadBalancerToSubnetsOutput{}
	req.Data = output
	return
}

// Adds one or more subnets to the set of configured subnets for the specified
// load balancer.
//
// The load balancer evenly distributes requests across all registered subnets.
// For more information, see Elastic Load Balancing in Amazon VPC (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/UserScenariosForVPC.html)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) AttachLoadBalancerToSubnets(input *AttachLoadBalancerToSubnetsInput) (*AttachLoadBalancerToSubnetsOutput, error) {
	req, out := c.AttachLoadBalancerToSubnetsRequest(input)
	err := req.Send()
	return out, err
}

var opAttachLoadBalancerToSubnets *aws.Operation

// ConfigureHealthCheckRequest generates a request for the ConfigureHealthCheck operation.
func (c *ELB) ConfigureHealthCheckRequest(input *ConfigureHealthCheckInput) (req *aws.Request, output *ConfigureHealthCheckOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opConfigureHealthCheck == nil {
		opConfigureHealthCheck = &aws.Operation{
			Name:       "ConfigureHealthCheck",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &ConfigureHealthCheckInput{}
	}

	req = c.newRequest(opConfigureHealthCheck, input, output)
	output = &ConfigureHealthCheckOutput{}
	req.Data = output
	return
}

// Specifies the health check settings to use when evaluating the health state
// of your back-end instances.
//
// For more information, see Health Checks (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#healthcheck)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) ConfigureHealthCheck(input *ConfigureHealthCheckInput) (*ConfigureHealthCheckOutput, error) {
	req, out := c.ConfigureHealthCheckRequest(input)
	err := req.Send()
	return out, err
}

var opConfigureHealthCheck *aws.Operation

// CreateAppCookieStickinessPolicyRequest generates a request for the CreateAppCookieStickinessPolicy operation.
func (c *ELB) CreateAppCookieStickinessPolicyRequest(input *CreateAppCookieStickinessPolicyInput) (req *aws.Request, output *CreateAppCookieStickinessPolicyOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opCreateAppCookieStickinessPolicy == nil {
		opCreateAppCookieStickinessPolicy = &aws.Operation{
			Name:       "CreateAppCookieStickinessPolicy",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &CreateAppCookieStickinessPolicyInput{}
	}

	req = c.newRequest(opCreateAppCookieStickinessPolicy, input, output)
	output = &CreateAppCookieStickinessPolicyOutput{}
	req.Data = output
	return
}

// Generates a stickiness policy with sticky session lifetimes that follow that
// of an application-generated cookie. This policy can be associated only with
// HTTP/HTTPS listeners.
//
// This policy is similar to the policy created by CreateLBCookieStickinessPolicy,
// except that the lifetime of the special Elastic Load Balancing cookie, AWSELB,
// follows the lifetime of the application-generated cookie specified in the
// policy configuration. The load balancer only inserts a new stickiness cookie
// when the application response includes a new application cookie.
//
// If the application cookie is explicitly removed or expires, the session
// stops being sticky until a new application cookie is issued.
//
// For more information, see Application-Controlled Session Stickiness (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/US_StickySessions.html#US_EnableStickySessionsAppCookies)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) CreateAppCookieStickinessPolicy(input *CreateAppCookieStickinessPolicyInput) (*CreateAppCookieStickinessPolicyOutput, error) {
	req, out := c.CreateAppCookieStickinessPolicyRequest(input)
	err := req.Send()
	return out, err
}

var opCreateAppCookieStickinessPolicy *aws.Operation

// CreateLBCookieStickinessPolicyRequest generates a request for the CreateLBCookieStickinessPolicy operation.
func (c *ELB) CreateLBCookieStickinessPolicyRequest(input *CreateLBCookieStickinessPolicyInput) (req *aws.Request, output *CreateLBCookieStickinessPolicyOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opCreateLBCookieStickinessPolicy == nil {
		opCreateLBCookieStickinessPolicy = &aws.Operation{
			Name:       "CreateLBCookieStickinessPolicy",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &CreateLBCookieStickinessPolicyInput{}
	}

	req = c.newRequest(opCreateLBCookieStickinessPolicy, input, output)
	output = &CreateLBCookieStickinessPolicyOutput{}
	req.Data = output
	return
}

// Generates a stickiness policy with sticky session lifetimes controlled by
// the lifetime of the browser (user-agent) or a specified expiration period.
// This policy can be associated only with HTTP/HTTPS listeners.
//
// When a load balancer implements this policy, the load balancer uses a special
// cookie to track the back-end server instance for each request. When the load
// balancer receives a request, it first checks to see if this cookie is present
// in the request. If so, the load balancer sends the request to the application
// server specified in the cookie. If not, the load balancer sends the request
// to a server that is chosen based on the existing load-balancing algorithm.
//
// A cookie is inserted into the response for binding subsequent requests from
// the same user to that server. The validity of the cookie is based on the
// cookie expiration time, which is specified in the policy configuration.
//
// For more information, see Duration-Based Session Stickiness (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/US_StickySessions.html#US_EnableStickySessionsLBCookies)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) CreateLBCookieStickinessPolicy(input *CreateLBCookieStickinessPolicyInput) (*CreateLBCookieStickinessPolicyOutput, error) {
	req, out := c.CreateLBCookieStickinessPolicyRequest(input)
	err := req.Send()
	return out, err
}

var opCreateLBCookieStickinessPolicy *aws.Operation

// CreateLoadBalancerRequest generates a request for the CreateLoadBalancer operation.
func (c *ELB) CreateLoadBalancerRequest(input *CreateLoadBalancerInput) (req *aws.Request, output *CreateLoadBalancerOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opCreateLoadBalancer == nil {
		opCreateLoadBalancer = &aws.Operation{
			Name:       "CreateLoadBalancer",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &CreateLoadBalancerInput{}
	}

	req = c.newRequest(opCreateLoadBalancer, input, output)
	output = &CreateLoadBalancerOutput{}
	req.Data = output
	return
}

// Creates a load balancer.
//
// If the call completes successfully, a new load balancer is created with
// a unique Domain Name Service (DNS) name. The DNS name includes the name of
// the AWS region in which the load balancer was created. For example, the DNS
// name might end with either of the following:
//
//   us-east-1.elb.amazonaws.com   us-west-2.elb.amazonaws.com   For information
// about the AWS regions supported by Elastic Load Balancing, see Regions and
// Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html#elb_region)
// in the Amazon Web Services General Reference.
//
// You can create up to 20 load balancers per region per account. You can request
// an increase for the number of load balancers for your account. For more information,
// see Elastic Load Balancing Limits (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-limits.html)
// in the Elastic Load Balancing Developer Guide.
//
// Elastic Load Balancing supports load balancing your EC2 instances launched
// in either the EC2-Classic or EC2-VPC platform. For more information, see
// Elastic Load Balancing in EC2-Classic (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/UserScenariosForEC2.html)
// or Elastic Load Balancing in a VPC (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/UserScenariosForVPC.html)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) CreateLoadBalancer(input *CreateLoadBalancerInput) (*CreateLoadBalancerOutput, error) {
	req, out := c.CreateLoadBalancerRequest(input)
	err := req.Send()
	return out, err
}

var opCreateLoadBalancer *aws.Operation

// CreateLoadBalancerListenersRequest generates a request for the CreateLoadBalancerListeners operation.
func (c *ELB) CreateLoadBalancerListenersRequest(input *CreateLoadBalancerListenersInput) (req *aws.Request, output *CreateLoadBalancerListenersOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opCreateLoadBalancerListeners == nil {
		opCreateLoadBalancerListeners = &aws.Operation{
			Name:       "CreateLoadBalancerListeners",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &CreateLoadBalancerListenersInput{}
	}

	req = c.newRequest(opCreateLoadBalancerListeners, input, output)
	output = &CreateLoadBalancerListenersOutput{}
	req.Data = output
	return
}

// Creates one or more listeners for the specified load balancer. If a listener
// with the specified port does not already exist, it is created; otherwise,
// the properties of the new listener must match the properties of the existing
// listener.
//
// For more information, see Add a Listener to Your Load Balancer (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/us-add-listener.html)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) CreateLoadBalancerListeners(input *CreateLoadBalancerListenersInput) (*CreateLoadBalancerListenersOutput, error) {
	req, out := c.CreateLoadBalancerListenersRequest(input)
	err := req.Send()
	return out, err
}

var opCreateLoadBalancerListeners *aws.Operation

// CreateLoadBalancerPolicyRequest generates a request for the CreateLoadBalancerPolicy operation.
func (c *ELB) CreateLoadBalancerPolicyRequest(input *CreateLoadBalancerPolicyInput) (req *aws.Request, output *CreateLoadBalancerPolicyOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opCreateLoadBalancerPolicy == nil {
		opCreateLoadBalancerPolicy = &aws.Operation{
			Name:       "CreateLoadBalancerPolicy",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &CreateLoadBalancerPolicyInput{}
	}

	req = c.newRequest(opCreateLoadBalancerPolicy, input, output)
	output = &CreateLoadBalancerPolicyOutput{}
	req.Data = output
	return
}

// Creates a policy with the specified attributes for the specified load balancer.
//
// Policies are settings that are saved for your load balancer and that can
// be applied to the front-end listener or the back-end application server,
// depending on the policy type.
func (c *ELB) CreateLoadBalancerPolicy(input *CreateLoadBalancerPolicyInput) (*CreateLoadBalancerPolicyOutput, error) {
	req, out := c.CreateLoadBalancerPolicyRequest(input)
	err := req.Send()
	return out, err
}

var opCreateLoadBalancerPolicy *aws.Operation

// DeleteLoadBalancerRequest generates a request for the DeleteLoadBalancer operation.
func (c *ELB) DeleteLoadBalancerRequest(input *DeleteLoadBalancerInput) (req *aws.Request, output *DeleteLoadBalancerOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDeleteLoadBalancer == nil {
		opDeleteLoadBalancer = &aws.Operation{
			Name:       "DeleteLoadBalancer",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DeleteLoadBalancerInput{}
	}

	req = c.newRequest(opDeleteLoadBalancer, input, output)
	output = &DeleteLoadBalancerOutput{}
	req.Data = output
	return
}

// Deletes the specified load balancer.
//
// If you are attempting to recreate a load balancer, you must reconfigure
// all settings. The DNS name associated with a deleted load balancer are no
// longer usable. The name and associated DNS record of the deleted load balancer
// no longer exist and traffic sent to any of its IP addresses is no longer
// delivered to back-end instances.
//
// If the load balancer does not exist or has already been deleted, the call
// to DeleteLoadBalancer still succeeds.
func (c *ELB) DeleteLoadBalancer(input *DeleteLoadBalancerInput) (*DeleteLoadBalancerOutput, error) {
	req, out := c.DeleteLoadBalancerRequest(input)
	err := req.Send()
	return out, err
}

var opDeleteLoadBalancer *aws.Operation

// DeleteLoadBalancerListenersRequest generates a request for the DeleteLoadBalancerListeners operation.
func (c *ELB) DeleteLoadBalancerListenersRequest(input *DeleteLoadBalancerListenersInput) (req *aws.Request, output *DeleteLoadBalancerListenersOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDeleteLoadBalancerListeners == nil {
		opDeleteLoadBalancerListeners = &aws.Operation{
			Name:       "DeleteLoadBalancerListeners",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DeleteLoadBalancerListenersInput{}
	}

	req = c.newRequest(opDeleteLoadBalancerListeners, input, output)
	output = &DeleteLoadBalancerListenersOutput{}
	req.Data = output
	return
}

// Deletes the specified listeners from the specified load balancer.
func (c *ELB) DeleteLoadBalancerListeners(input *DeleteLoadBalancerListenersInput) (*DeleteLoadBalancerListenersOutput, error) {
	req, out := c.DeleteLoadBalancerListenersRequest(input)
	err := req.Send()
	return out, err
}

var opDeleteLoadBalancerListeners *aws.Operation

// DeleteLoadBalancerPolicyRequest generates a request for the DeleteLoadBalancerPolicy operation.
func (c *ELB) DeleteLoadBalancerPolicyRequest(input *DeleteLoadBalancerPolicyInput) (req *aws.Request, output *DeleteLoadBalancerPolicyOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDeleteLoadBalancerPolicy == nil {
		opDeleteLoadBalancerPolicy = &aws.Operation{
			Name:       "DeleteLoadBalancerPolicy",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DeleteLoadBalancerPolicyInput{}
	}

	req = c.newRequest(opDeleteLoadBalancerPolicy, input, output)
	output = &DeleteLoadBalancerPolicyOutput{}
	req.Data = output
	return
}

// Deletes the specified policy from the specified load balancer. This policy
// must not be enabled for any listeners.
func (c *ELB) DeleteLoadBalancerPolicy(input *DeleteLoadBalancerPolicyInput) (*DeleteLoadBalancerPolicyOutput, error) {
	req, out := c.DeleteLoadBalancerPolicyRequest(input)
	err := req.Send()
	return out, err
}

var opDeleteLoadBalancerPolicy *aws.Operation

// DeregisterInstancesFromLoadBalancerRequest generates a request for the DeregisterInstancesFromLoadBalancer operation.
func (c *ELB) DeregisterInstancesFromLoadBalancerRequest(input *DeregisterInstancesFromLoadBalancerInput) (req *aws.Request, output *DeregisterInstancesFromLoadBalancerOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDeregisterInstancesFromLoadBalancer == nil {
		opDeregisterInstancesFromLoadBalancer = &aws.Operation{
			Name:       "DeregisterInstancesFromLoadBalancer",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DeregisterInstancesFromLoadBalancerInput{}
	}

	req = c.newRequest(opDeregisterInstancesFromLoadBalancer, input, output)
	output = &DeregisterInstancesFromLoadBalancerOutput{}
	req.Data = output
	return
}

// Deregisters the specified instances from the specified load balancer. After
// the instance is deregistered, it no longer receives traffic from the load
// balancer.
//
// You can use DescribeLoadBalancers to verify that the instance is deregistered
// from the load balancer.
//
// For more information, see Deregister and Register Amazon EC2 Instances (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/US_DeReg_Reg_Instances.html)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) DeregisterInstancesFromLoadBalancer(input *DeregisterInstancesFromLoadBalancerInput) (*DeregisterInstancesFromLoadBalancerOutput, error) {
	req, out := c.DeregisterInstancesFromLoadBalancerRequest(input)
	err := req.Send()
	return out, err
}

var opDeregisterInstancesFromLoadBalancer *aws.Operation

// DescribeInstanceHealthRequest generates a request for the DescribeInstanceHealth operation.
func (c *ELB) DescribeInstanceHealthRequest(input *DescribeInstanceHealthInput) (req *aws.Request, output *DescribeInstanceHealthOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribeInstanceHealth == nil {
		opDescribeInstanceHealth = &aws.Operation{
			Name:       "DescribeInstanceHealth",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DescribeInstanceHealthInput{}
	}

	req = c.newRequest(opDescribeInstanceHealth, input, output)
	output = &DescribeInstanceHealthOutput{}
	req.Data = output
	return
}

// Describes the state of the specified instances registered with the specified
// load balancer. If no instances are specified, the call describes the state
// of all instances registered with the load balancer, not including any terminated
// instances.
func (c *ELB) DescribeInstanceHealth(input *DescribeInstanceHealthInput) (*DescribeInstanceHealthOutput, error) {
	req, out := c.DescribeInstanceHealthRequest(input)
	err := req.Send()
	return out, err
}

var opDescribeInstanceHealth *aws.Operation

// DescribeLoadBalancerAttributesRequest generates a request for the DescribeLoadBalancerAttributes operation.
func (c *ELB) DescribeLoadBalancerAttributesRequest(input *DescribeLoadBalancerAttributesInput) (req *aws.Request, output *DescribeLoadBalancerAttributesOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribeLoadBalancerAttributes == nil {
		opDescribeLoadBalancerAttributes = &aws.Operation{
			Name:       "DescribeLoadBalancerAttributes",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DescribeLoadBalancerAttributesInput{}
	}

	req = c.newRequest(opDescribeLoadBalancerAttributes, input, output)
	output = &DescribeLoadBalancerAttributesOutput{}
	req.Data = output
	return
}

// Describes the attributes for the specified load balancer.
func (c *ELB) DescribeLoadBalancerAttributes(input *DescribeLoadBalancerAttributesInput) (*DescribeLoadBalancerAttributesOutput, error) {
	req, out := c.DescribeLoadBalancerAttributesRequest(input)
	err := req.Send()
	return out, err
}

var opDescribeLoadBalancerAttributes *aws.Operation

// DescribeLoadBalancerPoliciesRequest generates a request for the DescribeLoadBalancerPolicies operation.
func (c *ELB) DescribeLoadBalancerPoliciesRequest(input *DescribeLoadBalancerPoliciesInput) (req *aws.Request, output *DescribeLoadBalancerPoliciesOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribeLoadBalancerPolicies == nil {
		opDescribeLoadBalancerPolicies = &aws.Operation{
			Name:       "DescribeLoadBalancerPolicies",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DescribeLoadBalancerPoliciesInput{}
	}

	req = c.newRequest(opDescribeLoadBalancerPolicies, input, output)
	output = &DescribeLoadBalancerPoliciesOutput{}
	req.Data = output
	return
}

// Describes the specified policies.
//
// If you specify a load balancer name, the action returns the descriptions
// of all policies created for the load balancer. If you specify a policy name
// associated with your load balancer, the action returns the description of
// that policy. If you don't specify a load balancer name, the action returns
// descriptions of the specified sample policies, or descriptions of all sample
// policies. The names of the sample policies have the ELBSample- prefix.
func (c *ELB) DescribeLoadBalancerPolicies(input *DescribeLoadBalancerPoliciesInput) (*DescribeLoadBalancerPoliciesOutput, error) {
	req, out := c.DescribeLoadBalancerPoliciesRequest(input)
	err := req.Send()
	return out, err
}

var opDescribeLoadBalancerPolicies *aws.Operation

// DescribeLoadBalancerPolicyTypesRequest generates a request for the DescribeLoadBalancerPolicyTypes operation.
func (c *ELB) DescribeLoadBalancerPolicyTypesRequest(input *DescribeLoadBalancerPolicyTypesInput) (req *aws.Request, output *DescribeLoadBalancerPolicyTypesOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribeLoadBalancerPolicyTypes == nil {
		opDescribeLoadBalancerPolicyTypes = &aws.Operation{
			Name:       "DescribeLoadBalancerPolicyTypes",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DescribeLoadBalancerPolicyTypesInput{}
	}

	req = c.newRequest(opDescribeLoadBalancerPolicyTypes, input, output)
	output = &DescribeLoadBalancerPolicyTypesOutput{}
	req.Data = output
	return
}

// Describes the specified load balancer policy types.
//
// You can use these policy types with CreateLoadBalancerPolicy to create policy
// configurations for a load balancer.
func (c *ELB) DescribeLoadBalancerPolicyTypes(input *DescribeLoadBalancerPolicyTypesInput) (*DescribeLoadBalancerPolicyTypesOutput, error) {
	req, out := c.DescribeLoadBalancerPolicyTypesRequest(input)
	err := req.Send()
	return out, err
}

var opDescribeLoadBalancerPolicyTypes *aws.Operation

// DescribeLoadBalancersRequest generates a request for the DescribeLoadBalancers operation.
func (c *ELB) DescribeLoadBalancersRequest(input *DescribeLoadBalancersInput) (req *aws.Request, output *DescribeLoadBalancersOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribeLoadBalancers == nil {
		opDescribeLoadBalancers = &aws.Operation{
			Name:       "DescribeLoadBalancers",
			HTTPMethod: "POST",
			HTTPPath:   "/",
			Paginator: &aws.Paginator{
				InputTokens:     []string{"Marker"},
				OutputTokens:    []string{"NextMarker"},
				LimitToken:      "",
				TruncationToken: "",
			},
		}
	}

	if input == nil {
		input = &DescribeLoadBalancersInput{}
	}

	req = c.newRequest(opDescribeLoadBalancers, input, output)
	output = &DescribeLoadBalancersOutput{}
	req.Data = output
	return
}

// Describes the specified the load balancers. If no load balancers are specified,
// the call describes all of your load balancers.
func (c *ELB) DescribeLoadBalancers(input *DescribeLoadBalancersInput) (*DescribeLoadBalancersOutput, error) {
	req, out := c.DescribeLoadBalancersRequest(input)
	err := req.Send()
	return out, err
}

func (c *ELB) DescribeLoadBalancersPages(input *DescribeLoadBalancersInput, fn func(p *DescribeLoadBalancersOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeLoadBalancersRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeLoadBalancersOutput), lastPage)
	})
}

var opDescribeLoadBalancers *aws.Operation

// DescribeTagsRequest generates a request for the DescribeTags operation.
func (c *ELB) DescribeTagsRequest(input *DescribeTagsInput) (req *aws.Request, output *DescribeTagsOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDescribeTags == nil {
		opDescribeTags = &aws.Operation{
			Name:       "DescribeTags",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	req = c.newRequest(opDescribeTags, input, output)
	output = &DescribeTagsOutput{}
	req.Data = output
	return
}

// Describes the tags associated with the specified load balancers.
func (c *ELB) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	err := req.Send()
	return out, err
}

var opDescribeTags *aws.Operation

// DetachLoadBalancerFromSubnetsRequest generates a request for the DetachLoadBalancerFromSubnets operation.
func (c *ELB) DetachLoadBalancerFromSubnetsRequest(input *DetachLoadBalancerFromSubnetsInput) (req *aws.Request, output *DetachLoadBalancerFromSubnetsOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDetachLoadBalancerFromSubnets == nil {
		opDetachLoadBalancerFromSubnets = &aws.Operation{
			Name:       "DetachLoadBalancerFromSubnets",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DetachLoadBalancerFromSubnetsInput{}
	}

	req = c.newRequest(opDetachLoadBalancerFromSubnets, input, output)
	output = &DetachLoadBalancerFromSubnetsOutput{}
	req.Data = output
	return
}

// Removes the specified subnets from the set of configured subnets for the
// load balancer.
//
// After a subnet is removed, all EC2 instances registered with the load balancer
// in the removed subnet go into the OutOfService state. Then, the load balancer
// balances the traffic among the remaining routable subnets.
func (c *ELB) DetachLoadBalancerFromSubnets(input *DetachLoadBalancerFromSubnetsInput) (*DetachLoadBalancerFromSubnetsOutput, error) {
	req, out := c.DetachLoadBalancerFromSubnetsRequest(input)
	err := req.Send()
	return out, err
}

var opDetachLoadBalancerFromSubnets *aws.Operation

// DisableAvailabilityZonesForLoadBalancerRequest generates a request for the DisableAvailabilityZonesForLoadBalancer operation.
func (c *ELB) DisableAvailabilityZonesForLoadBalancerRequest(input *DisableAvailabilityZonesForLoadBalancerInput) (req *aws.Request, output *DisableAvailabilityZonesForLoadBalancerOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opDisableAvailabilityZonesForLoadBalancer == nil {
		opDisableAvailabilityZonesForLoadBalancer = &aws.Operation{
			Name:       "DisableAvailabilityZonesForLoadBalancer",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &DisableAvailabilityZonesForLoadBalancerInput{}
	}

	req = c.newRequest(opDisableAvailabilityZonesForLoadBalancer, input, output)
	output = &DisableAvailabilityZonesForLoadBalancerOutput{}
	req.Data = output
	return
}

// Removes the specified Availability Zones from the set of Availability Zones
// for the specified load balancer.
//
// There must be at least one Availability Zone registered with a load balancer
// at all times. After an Availability Zone is removed, all instances registered
// with the load balancer that are in the removed Availability Zone go into
// the OutOfService state. Then, the load balancer attempts to equally balance
// the traffic among its remaining Availability Zones.
//
// For more information, see Disable an Availability Zone from a Load-Balanced
// Application (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/US_ShrinkLBApp04.html)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) DisableAvailabilityZonesForLoadBalancer(input *DisableAvailabilityZonesForLoadBalancerInput) (*DisableAvailabilityZonesForLoadBalancerOutput, error) {
	req, out := c.DisableAvailabilityZonesForLoadBalancerRequest(input)
	err := req.Send()
	return out, err
}

var opDisableAvailabilityZonesForLoadBalancer *aws.Operation

// EnableAvailabilityZonesForLoadBalancerRequest generates a request for the EnableAvailabilityZonesForLoadBalancer operation.
func (c *ELB) EnableAvailabilityZonesForLoadBalancerRequest(input *EnableAvailabilityZonesForLoadBalancerInput) (req *aws.Request, output *EnableAvailabilityZonesForLoadBalancerOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opEnableAvailabilityZonesForLoadBalancer == nil {
		opEnableAvailabilityZonesForLoadBalancer = &aws.Operation{
			Name:       "EnableAvailabilityZonesForLoadBalancer",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &EnableAvailabilityZonesForLoadBalancerInput{}
	}

	req = c.newRequest(opEnableAvailabilityZonesForLoadBalancer, input, output)
	output = &EnableAvailabilityZonesForLoadBalancerOutput{}
	req.Data = output
	return
}

// Adds the specified Availability Zones to the set of Availability Zones for
// the specified load balancer.
//
// The load balancer evenly distributes requests across all its registered
// Availability Zones that contain instances.
//
// For more information, see Add Availability Zone (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/US_AddLBAvailabilityZone.html)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) EnableAvailabilityZonesForLoadBalancer(input *EnableAvailabilityZonesForLoadBalancerInput) (*EnableAvailabilityZonesForLoadBalancerOutput, error) {
	req, out := c.EnableAvailabilityZonesForLoadBalancerRequest(input)
	err := req.Send()
	return out, err
}

var opEnableAvailabilityZonesForLoadBalancer *aws.Operation

// ModifyLoadBalancerAttributesRequest generates a request for the ModifyLoadBalancerAttributes operation.
func (c *ELB) ModifyLoadBalancerAttributesRequest(input *ModifyLoadBalancerAttributesInput) (req *aws.Request, output *ModifyLoadBalancerAttributesOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opModifyLoadBalancerAttributes == nil {
		opModifyLoadBalancerAttributes = &aws.Operation{
			Name:       "ModifyLoadBalancerAttributes",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &ModifyLoadBalancerAttributesInput{}
	}

	req = c.newRequest(opModifyLoadBalancerAttributes, input, output)
	output = &ModifyLoadBalancerAttributesOutput{}
	req.Data = output
	return
}

// Modifies the attributes of the specified load balancer.
//
// You can modify the load balancer attributes, such as AccessLogs, ConnectionDraining,
// and CrossZoneLoadBalancing by either enabling or disabling them. Or, you
// can modify the load balancer attribute ConnectionSettings by specifying an
// idle connection timeout value for your load balancer.
//
// For more information, see the following in the Elastic Load Balancing Developer
// Guide:
//
//  Cross-Zone Load Balancing (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#request-routing)
// Connection Draining (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain)
// Access Logs (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/access-log-collection.html)
// Idle Connection Timeout (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#idle-timeout)
func (c *ELB) ModifyLoadBalancerAttributes(input *ModifyLoadBalancerAttributesInput) (*ModifyLoadBalancerAttributesOutput, error) {
	req, out := c.ModifyLoadBalancerAttributesRequest(input)
	err := req.Send()
	return out, err
}

var opModifyLoadBalancerAttributes *aws.Operation

// RegisterInstancesWithLoadBalancerRequest generates a request for the RegisterInstancesWithLoadBalancer operation.
func (c *ELB) RegisterInstancesWithLoadBalancerRequest(input *RegisterInstancesWithLoadBalancerInput) (req *aws.Request, output *RegisterInstancesWithLoadBalancerOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opRegisterInstancesWithLoadBalancer == nil {
		opRegisterInstancesWithLoadBalancer = &aws.Operation{
			Name:       "RegisterInstancesWithLoadBalancer",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &RegisterInstancesWithLoadBalancerInput{}
	}

	req = c.newRequest(opRegisterInstancesWithLoadBalancer, input, output)
	output = &RegisterInstancesWithLoadBalancerOutput{}
	req.Data = output
	return
}

// Adds the specified instances to the specified load balancer.
//
// The instance must be a running instance in the same network as the load
// balancer (EC2-Classic or the same VPC). If you have EC2-Classic instances
// and a load balancer in a VPC with ClassicLink enabled, you can link the EC2-Classic
// instances to that VPC and then register the linked EC2-Classic instances
// with the load balancer in the VPC.
//
// Note that RegisterInstanceWithLoadBalancer completes when the request has
// been registered. Instance registration happens shortly afterwards. To check
// the state of the registered instances, use DescribeLoadBalancers or DescribeInstanceHealth.
//
// After the instance is registered, it starts receiving traffic and requests
// from the load balancer. Any instance that is not in one of the Availability
// Zones registered for the load balancer is moved to the OutOfService state.
// If an Availability Zone is added to the load balancer later, any instances
// registered with the load balancer move to the InService state.
//
// If you stop an instance registered with a load balancer and then start it,
// the IP addresses associated with the instance changes. Elastic Load Balancing
// cannot recognize the new IP address, which prevents it from routing traffic
// to the instances. We recommend that you use the following sequence: stop
// the instance, deregister the instance, start the instance, and then register
// the instance. To deregister instances from a load balancer, use DeregisterInstancesFromLoadBalancer.
//
// For more information, see Deregister and Register EC2 Instances (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/US_DeReg_Reg_Instances.html)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) RegisterInstancesWithLoadBalancer(input *RegisterInstancesWithLoadBalancerInput) (*RegisterInstancesWithLoadBalancerOutput, error) {
	req, out := c.RegisterInstancesWithLoadBalancerRequest(input)
	err := req.Send()
	return out, err
}

var opRegisterInstancesWithLoadBalancer *aws.Operation

// RemoveTagsRequest generates a request for the RemoveTags operation.
func (c *ELB) RemoveTagsRequest(input *RemoveTagsInput) (req *aws.Request, output *RemoveTagsOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opRemoveTags == nil {
		opRemoveTags = &aws.Operation{
			Name:       "RemoveTags",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &RemoveTagsInput{}
	}

	req = c.newRequest(opRemoveTags, input, output)
	output = &RemoveTagsOutput{}
	req.Data = output
	return
}

// Removes one or more tags from the specified load balancer.
func (c *ELB) RemoveTags(input *RemoveTagsInput) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	err := req.Send()
	return out, err
}

var opRemoveTags *aws.Operation

// SetLoadBalancerListenerSSLCertificateRequest generates a request for the SetLoadBalancerListenerSSLCertificate operation.
func (c *ELB) SetLoadBalancerListenerSSLCertificateRequest(input *SetLoadBalancerListenerSSLCertificateInput) (req *aws.Request, output *SetLoadBalancerListenerSSLCertificateOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opSetLoadBalancerListenerSSLCertificate == nil {
		opSetLoadBalancerListenerSSLCertificate = &aws.Operation{
			Name:       "SetLoadBalancerListenerSSLCertificate",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &SetLoadBalancerListenerSSLCertificateInput{}
	}

	req = c.newRequest(opSetLoadBalancerListenerSSLCertificate, input, output)
	output = &SetLoadBalancerListenerSSLCertificateOutput{}
	req.Data = output
	return
}

// Sets the certificate that terminates the specified listener's SSL connections.
// The specified certificate replaces any prior certificate that was used on
// the same load balancer and port.
//
// For more information about updating your SSL certificate, see Updating an
// SSL Certificate for a Load Balancer (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/US_UpdatingLoadBalancerSSL.html)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) SetLoadBalancerListenerSSLCertificate(input *SetLoadBalancerListenerSSLCertificateInput) (*SetLoadBalancerListenerSSLCertificateOutput, error) {
	req, out := c.SetLoadBalancerListenerSSLCertificateRequest(input)
	err := req.Send()
	return out, err
}

var opSetLoadBalancerListenerSSLCertificate *aws.Operation

// SetLoadBalancerPoliciesForBackendServerRequest generates a request for the SetLoadBalancerPoliciesForBackendServer operation.
func (c *ELB) SetLoadBalancerPoliciesForBackendServerRequest(input *SetLoadBalancerPoliciesForBackendServerInput) (req *aws.Request, output *SetLoadBalancerPoliciesForBackendServerOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opSetLoadBalancerPoliciesForBackendServer == nil {
		opSetLoadBalancerPoliciesForBackendServer = &aws.Operation{
			Name:       "SetLoadBalancerPoliciesForBackendServer",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &SetLoadBalancerPoliciesForBackendServerInput{}
	}

	req = c.newRequest(opSetLoadBalancerPoliciesForBackendServer, input, output)
	output = &SetLoadBalancerPoliciesForBackendServerOutput{}
	req.Data = output
	return
}

// Replaces the set of policies associated with the specified port on which
// the back-end server is listening with a new set of policies. At this time,
// only the back-end server authentication policy type can be applied to the
// back-end ports; this policy type is composed of multiple public key policies.
//
// Each time you use SetLoadBalancerPoliciesForBackendServer to enable the
// policies, use the PolicyNames parameter to list the policies that you want
// to enable.
//
// You can use DescribeLoadBalancers or DescribeLoadBalancerPolicies to verify
// that the policy is associated with the back-end server.
func (c *ELB) SetLoadBalancerPoliciesForBackendServer(input *SetLoadBalancerPoliciesForBackendServerInput) (*SetLoadBalancerPoliciesForBackendServerOutput, error) {
	req, out := c.SetLoadBalancerPoliciesForBackendServerRequest(input)
	err := req.Send()
	return out, err
}

var opSetLoadBalancerPoliciesForBackendServer *aws.Operation

// SetLoadBalancerPoliciesOfListenerRequest generates a request for the SetLoadBalancerPoliciesOfListener operation.
func (c *ELB) SetLoadBalancerPoliciesOfListenerRequest(input *SetLoadBalancerPoliciesOfListenerInput) (req *aws.Request, output *SetLoadBalancerPoliciesOfListenerOutput) {
	oprw.Lock()
	defer oprw.Unlock()

	if opSetLoadBalancerPoliciesOfListener == nil {
		opSetLoadBalancerPoliciesOfListener = &aws.Operation{
			Name:       "SetLoadBalancerPoliciesOfListener",
			HTTPMethod: "POST",
			HTTPPath:   "/",
		}
	}

	if input == nil {
		input = &SetLoadBalancerPoliciesOfListenerInput{}
	}

	req = c.newRequest(opSetLoadBalancerPoliciesOfListener, input, output)
	output = &SetLoadBalancerPoliciesOfListenerOutput{}
	req.Data = output
	return
}

// Associates, updates, or disables a policy with a listener for the specified
// load balancer. You can associate multiple policies with a listener.
func (c *ELB) SetLoadBalancerPoliciesOfListener(input *SetLoadBalancerPoliciesOfListenerInput) (*SetLoadBalancerPoliciesOfListenerOutput, error) {
	req, out := c.SetLoadBalancerPoliciesOfListenerRequest(input)
	err := req.Send()
	return out, err
}

var opSetLoadBalancerPoliciesOfListener *aws.Operation

// Information about the AccessLog attribute.
type AccessLog struct {
	// The interval for publishing the access logs. You can specify an interval
	// of either 5 minutes or 60 minutes.
	//
	// Default: 60 minutes
	EmitInterval *int64 `type:"integer"`

	// Specifies whether access log is enabled for the load balancer.
	Enabled *bool `type:"boolean" required:"true"`

	// The name of the Amazon S3 bucket where the access logs are stored.
	S3BucketName *string `type:"string"`

	// The logical hierarchy you created for your Amazon S3 bucket, for example
	// my-bucket-prefix/prod. If the prefix is not provided, the log is placed at
	// the root level of the bucket.
	S3BucketPrefix *string `type:"string"`

	metadataAccessLog `json:"-" xml:"-"`
}

type metadataAccessLog struct {
	SDKShapeTraits bool `type:"structure"`
}

type AddTagsInput struct {
	// The name of the load balancer. You can specify one load balancer only.
	LoadBalancerNames []*string `type:"list" required:"true"`

	// The tags.
	Tags []*Tag `type:"list" required:"true"`

	metadataAddTagsInput `json:"-" xml:"-"`
}

type metadataAddTagsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type AddTagsOutput struct {
	metadataAddTagsOutput `json:"-" xml:"-"`
}

type metadataAddTagsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// This data type is reserved.
type AdditionalAttribute struct {
	// This parameter is reserved.
	Key *string `type:"string"`

	// This parameter is reserved.
	Value *string `type:"string"`

	metadataAdditionalAttribute `json:"-" xml:"-"`
}

type metadataAdditionalAttribute struct {
	SDKShapeTraits bool `type:"structure"`
}

// Information about a policy for application-controlled session stickiness.
type AppCookieStickinessPolicy struct {
	// The name of the application cookie used for stickiness.
	CookieName *string `type:"string"`

	// The mnemonic name for the policy being created. The name must be unique within
	// a set of policies for this load balancer.
	PolicyName *string `type:"string"`

	metadataAppCookieStickinessPolicy `json:"-" xml:"-"`
}

type metadataAppCookieStickinessPolicy struct {
	SDKShapeTraits bool `type:"structure"`
}

type ApplySecurityGroupsToLoadBalancerInput struct {
	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The IDs of the security groups to associate with the load balancer. Note
	// that you cannot specify the name of the security group.
	SecurityGroups []*string `type:"list" required:"true"`

	metadataApplySecurityGroupsToLoadBalancerInput `json:"-" xml:"-"`
}

type metadataApplySecurityGroupsToLoadBalancerInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type ApplySecurityGroupsToLoadBalancerOutput struct {
	// The IDs of the security groups associated with the load balancer.
	SecurityGroups []*string `type:"list"`

	metadataApplySecurityGroupsToLoadBalancerOutput `json:"-" xml:"-"`
}

type metadataApplySecurityGroupsToLoadBalancerOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type AttachLoadBalancerToSubnetsInput struct {
	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The IDs of the subnets to add for the load balancer. You can add only one
	// subnet per Availability Zone.
	Subnets []*string `type:"list" required:"true"`

	metadataAttachLoadBalancerToSubnetsInput `json:"-" xml:"-"`
}

type metadataAttachLoadBalancerToSubnetsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type AttachLoadBalancerToSubnetsOutput struct {
	// The IDs of the subnets attached to the load balancer.
	Subnets []*string `type:"list"`

	metadataAttachLoadBalancerToSubnetsOutput `json:"-" xml:"-"`
}

type metadataAttachLoadBalancerToSubnetsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// Information about the configuration of a back-end server.
type BackendServerDescription struct {
	// The port on which the back-end server is listening.
	InstancePort *int64 `type:"integer"`

	// The names of the policies enabled for the back-end server.
	PolicyNames []*string `type:"list"`

	metadataBackendServerDescription `json:"-" xml:"-"`
}

type metadataBackendServerDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

type ConfigureHealthCheckInput struct {
	// The configuration information for the new health check.
	HealthCheck *HealthCheck `type:"structure" required:"true"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	metadataConfigureHealthCheckInput `json:"-" xml:"-"`
}

type metadataConfigureHealthCheckInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type ConfigureHealthCheckOutput struct {
	// The updated health check.
	HealthCheck *HealthCheck `type:"structure"`

	metadataConfigureHealthCheckOutput `json:"-" xml:"-"`
}

type metadataConfigureHealthCheckOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// Information about the ConnectionDraining attribute.
type ConnectionDraining struct {
	// Specifies whether connection draining is enabled for the load balancer.
	Enabled *bool `type:"boolean" required:"true"`

	// The maximum time, in seconds, to keep the existing connections open before
	// deregistering the instances.
	Timeout *int64 `type:"integer"`

	metadataConnectionDraining `json:"-" xml:"-"`
}

type metadataConnectionDraining struct {
	SDKShapeTraits bool `type:"structure"`
}

// Information about the ConnectionSettings attribute.
type ConnectionSettings struct {
	// The time, in seconds, that the connection is allowed to be idle (no data
	// has been sent over the connection) before it is closed by the load balancer.
	IdleTimeout *int64 `type:"integer" required:"true"`

	metadataConnectionSettings `json:"-" xml:"-"`
}

type metadataConnectionSettings struct {
	SDKShapeTraits bool `type:"structure"`
}

type CreateAppCookieStickinessPolicyInput struct {
	// The name of the application cookie used for stickiness.
	CookieName *string `type:"string" required:"true"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The name of the policy being created. This name must be unique within the
	// set of policies for this load balancer.
	PolicyName *string `type:"string" required:"true"`

	metadataCreateAppCookieStickinessPolicyInput `json:"-" xml:"-"`
}

type metadataCreateAppCookieStickinessPolicyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type CreateAppCookieStickinessPolicyOutput struct {
	metadataCreateAppCookieStickinessPolicyOutput `json:"-" xml:"-"`
}

type metadataCreateAppCookieStickinessPolicyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type CreateLBCookieStickinessPolicyInput struct {
	// The time period, in seconds, after which the cookie should be considered
	// stale. If you do not specify this parameter, the sticky session lasts for
	// the duration of the browser session.
	CookieExpirationPeriod *int64 `type:"long"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The name of the policy being created. This name must be unique within the
	// set of policies for this load balancer.
	PolicyName *string `type:"string" required:"true"`

	metadataCreateLBCookieStickinessPolicyInput `json:"-" xml:"-"`
}

type metadataCreateLBCookieStickinessPolicyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type CreateLBCookieStickinessPolicyOutput struct {
	metadataCreateLBCookieStickinessPolicyOutput `json:"-" xml:"-"`
}

type metadataCreateLBCookieStickinessPolicyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type CreateLoadBalancerInput struct {
	// One or more Availability Zones from the same region as the load balancer.
	// Traffic is equally distributed across all specified Availability Zones.
	//
	// You must specify at least one Availability Zone.
	//
	// You can add more Availability Zones after you create the load balancer using
	// EnableAvailabilityZonesForLoadBalancer.
	AvailabilityZones []*string `type:"list"`

	// The listeners.
	//
	// For more information, see Listener Configurations for Elastic Load Balancing
	// (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-listener-config.html)
	// in the Elastic Load Balancing Developer Guide.
	Listeners []*Listener `type:"list" required:"true"`

	// The name of the load balancer.
	//
	// This name must be unique within your AWS account, must have a maximum of
	// 32 characters, must contain only alphanumeric characters or hyphens, and
	// cannot begin or end with a hyphen.
	LoadBalancerName *string `type:"string" required:"true"`

	// The type of a load balancer. Valid only for load balancers in a VPC.
	//
	// By default, Elastic Load Balancing creates an Internet-facing load balancer
	// with a publicly resolvable DNS name, which resolves to public IP addresses.
	// For more information about Internet-facing and Internal load balancers, see
	// Internet-facing and Internal Load Balancers (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/vpc-loadbalancer-types.html)
	// in the Elastic Load Balancing Developer Guide.
	//
	// Specify internal to create an internal load balancer with a DNS name that
	// resolves to private IP addresses.
	Scheme *string `type:"string"`

	// The IDs of the security groups to assign to the load balancer.
	SecurityGroups []*string `type:"list"`

	// The IDs of the subnets in your VPC to attach to the load balancer. Specify
	// one subnet per Availability Zone specified in AvailabilityZones.
	Subnets []*string `type:"list"`

	// A list of tags to assign to the load balancer.
	//
	// For more information about tagging your load balancer, see Tagging (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#tagging-elb)
	// in the Elastic Load Balancing Developer Guide.
	Tags []*Tag `type:"list"`

	metadataCreateLoadBalancerInput `json:"-" xml:"-"`
}

type metadataCreateLoadBalancerInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type CreateLoadBalancerListenersInput struct {
	// The listeners.
	Listeners []*Listener `type:"list" required:"true"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	metadataCreateLoadBalancerListenersInput `json:"-" xml:"-"`
}

type metadataCreateLoadBalancerListenersInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type CreateLoadBalancerListenersOutput struct {
	metadataCreateLoadBalancerListenersOutput `json:"-" xml:"-"`
}

type metadataCreateLoadBalancerListenersOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type CreateLoadBalancerOutput struct {
	// The DNS name of the load balancer.
	DNSName *string `type:"string"`

	metadataCreateLoadBalancerOutput `json:"-" xml:"-"`
}

type metadataCreateLoadBalancerOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type CreateLoadBalancerPolicyInput struct {
	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The attributes for the policy.
	PolicyAttributes []*PolicyAttribute `type:"list"`

	// The name of the load balancer policy to be created. This name must be unique
	// within the set of policies for this load balancer.
	PolicyName *string `type:"string" required:"true"`

	// The name of the base policy type. To get the list of policy types, use DescribeLoadBalancerPolicyTypes.
	PolicyTypeName *string `type:"string" required:"true"`

	metadataCreateLoadBalancerPolicyInput `json:"-" xml:"-"`
}

type metadataCreateLoadBalancerPolicyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type CreateLoadBalancerPolicyOutput struct {
	metadataCreateLoadBalancerPolicyOutput `json:"-" xml:"-"`
}

type metadataCreateLoadBalancerPolicyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// Information about the CrossZoneLoadBalancing attribute.
type CrossZoneLoadBalancing struct {
	// Specifies whether cross-zone load balancing is enabled for the load balancer.
	Enabled *bool `type:"boolean" required:"true"`

	metadataCrossZoneLoadBalancing `json:"-" xml:"-"`
}

type metadataCrossZoneLoadBalancing struct {
	SDKShapeTraits bool `type:"structure"`
}

type DeleteLoadBalancerInput struct {
	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	metadataDeleteLoadBalancerInput `json:"-" xml:"-"`
}

type metadataDeleteLoadBalancerInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DeleteLoadBalancerListenersInput struct {
	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The client port numbers of the listeners.
	LoadBalancerPorts []*int64 `type:"list" required:"true"`

	metadataDeleteLoadBalancerListenersInput `json:"-" xml:"-"`
}

type metadataDeleteLoadBalancerListenersInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DeleteLoadBalancerListenersOutput struct {
	metadataDeleteLoadBalancerListenersOutput `json:"-" xml:"-"`
}

type metadataDeleteLoadBalancerListenersOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DeleteLoadBalancerOutput struct {
	metadataDeleteLoadBalancerOutput `json:"-" xml:"-"`
}

type metadataDeleteLoadBalancerOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// =
type DeleteLoadBalancerPolicyInput struct {
	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The name of the policy.
	PolicyName *string `type:"string" required:"true"`

	metadataDeleteLoadBalancerPolicyInput `json:"-" xml:"-"`
}

type metadataDeleteLoadBalancerPolicyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DeleteLoadBalancerPolicyOutput struct {
	metadataDeleteLoadBalancerPolicyOutput `json:"-" xml:"-"`
}

type metadataDeleteLoadBalancerPolicyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DeregisterInstancesFromLoadBalancerInput struct {
	// The IDs of the instances.
	Instances []*Instance `type:"list" required:"true"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	metadataDeregisterInstancesFromLoadBalancerInput `json:"-" xml:"-"`
}

type metadataDeregisterInstancesFromLoadBalancerInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DeregisterInstancesFromLoadBalancerOutput struct {
	// The remaining instances registered with the load balancer.
	Instances []*Instance `type:"list"`

	metadataDeregisterInstancesFromLoadBalancerOutput `json:"-" xml:"-"`
}

type metadataDeregisterInstancesFromLoadBalancerOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeInstanceHealthInput struct {
	// The IDs of the instances.
	Instances []*Instance `type:"list"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	metadataDescribeInstanceHealthInput `json:"-" xml:"-"`
}

type metadataDescribeInstanceHealthInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeInstanceHealthOutput struct {
	// Information about the health of the instances.
	InstanceStates []*InstanceState `type:"list"`

	metadataDescribeInstanceHealthOutput `json:"-" xml:"-"`
}

type metadataDescribeInstanceHealthOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeLoadBalancerAttributesInput struct {
	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	metadataDescribeLoadBalancerAttributesInput `json:"-" xml:"-"`
}

type metadataDescribeLoadBalancerAttributesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeLoadBalancerAttributesOutput struct {
	// Information about the load balancer attributes.
	LoadBalancerAttributes *LoadBalancerAttributes `type:"structure"`

	metadataDescribeLoadBalancerAttributesOutput `json:"-" xml:"-"`
}

type metadataDescribeLoadBalancerAttributesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeLoadBalancerPoliciesInput struct {
	// The name of the load balancer.
	LoadBalancerName *string `type:"string"`

	// The names of the policies.
	PolicyNames []*string `type:"list"`

	metadataDescribeLoadBalancerPoliciesInput `json:"-" xml:"-"`
}

type metadataDescribeLoadBalancerPoliciesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeLoadBalancerPoliciesOutput struct {
	// Information about the policies.
	PolicyDescriptions []*PolicyDescription `type:"list"`

	metadataDescribeLoadBalancerPoliciesOutput `json:"-" xml:"-"`
}

type metadataDescribeLoadBalancerPoliciesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeLoadBalancerPolicyTypesInput struct {
	// The names of the policy types. If no names are specified, describes all policy
	// types defined by Elastic Load Balancing.
	PolicyTypeNames []*string `type:"list"`

	metadataDescribeLoadBalancerPolicyTypesInput `json:"-" xml:"-"`
}

type metadataDescribeLoadBalancerPolicyTypesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeLoadBalancerPolicyTypesOutput struct {
	// Information about the policy types.
	PolicyTypeDescriptions []*PolicyTypeDescription `type:"list"`

	metadataDescribeLoadBalancerPolicyTypesOutput `json:"-" xml:"-"`
}

type metadataDescribeLoadBalancerPolicyTypesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeLoadBalancersInput struct {
	// The names of the load balancers.
	LoadBalancerNames []*string `type:"list"`

	// The marker for the next set of results. (You received this marker from a
	// previous call.)
	Marker *string `type:"string"`

	// The maximum number of results to return with this call (a number from 1 to
	// 400). The default is 400.
	PageSize *int64 `type:"integer"`

	metadataDescribeLoadBalancersInput `json:"-" xml:"-"`
}

type metadataDescribeLoadBalancersInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeLoadBalancersOutput struct {
	// Information about the load balancers.
	LoadBalancerDescriptions []*LoadBalancerDescription `type:"list"`

	// The marker to use when requesting the next set of results. If there are no
	// additional results, the string is empty.
	NextMarker *string `type:"string"`

	metadataDescribeLoadBalancersOutput `json:"-" xml:"-"`
}

type metadataDescribeLoadBalancersOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeTagsInput struct {
	// The names of the load balancers.
	LoadBalancerNames []*string `type:"list" required:"true"`

	metadataDescribeTagsInput `json:"-" xml:"-"`
}

type metadataDescribeTagsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DescribeTagsOutput struct {
	// Information about the tags.
	TagDescriptions []*TagDescription `type:"list"`

	metadataDescribeTagsOutput `json:"-" xml:"-"`
}

type metadataDescribeTagsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DetachLoadBalancerFromSubnetsInput struct {
	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The IDs of the subnets.
	Subnets []*string `type:"list" required:"true"`

	metadataDetachLoadBalancerFromSubnetsInput `json:"-" xml:"-"`
}

type metadataDetachLoadBalancerFromSubnetsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DetachLoadBalancerFromSubnetsOutput struct {
	// The IDs of the remaining subnets for the load balancer.
	Subnets []*string `type:"list"`

	metadataDetachLoadBalancerFromSubnetsOutput `json:"-" xml:"-"`
}

type metadataDetachLoadBalancerFromSubnetsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DisableAvailabilityZonesForLoadBalancerInput struct {
	// The Availability Zones.
	AvailabilityZones []*string `type:"list" required:"true"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	metadataDisableAvailabilityZonesForLoadBalancerInput `json:"-" xml:"-"`
}

type metadataDisableAvailabilityZonesForLoadBalancerInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type DisableAvailabilityZonesForLoadBalancerOutput struct {
	// The remaining Availability Zones for the load balancer.
	AvailabilityZones []*string `type:"list"`

	metadataDisableAvailabilityZonesForLoadBalancerOutput `json:"-" xml:"-"`
}

type metadataDisableAvailabilityZonesForLoadBalancerOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type EnableAvailabilityZonesForLoadBalancerInput struct {
	// The Availability Zones. These must be in the same region as the load balancer.
	AvailabilityZones []*string `type:"list" required:"true"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	metadataEnableAvailabilityZonesForLoadBalancerInput `json:"-" xml:"-"`
}

type metadataEnableAvailabilityZonesForLoadBalancerInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type EnableAvailabilityZonesForLoadBalancerOutput struct {
	// The updated list of Availability Zones for the load balancer.
	AvailabilityZones []*string `type:"list"`

	metadataEnableAvailabilityZonesForLoadBalancerOutput `json:"-" xml:"-"`
}

type metadataEnableAvailabilityZonesForLoadBalancerOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// Information about a health check.
type HealthCheck struct {
	// The number of consecutive health checks successes required before moving
	// the instance to the Healthy state.
	HealthyThreshold *int64 `type:"integer" required:"true"`

	// The approximate interval, in seconds, between health checks of an individual
	// instance.
	Interval *int64 `type:"integer" required:"true"`

	// The instance being checked. The protocol is either TCP, HTTP, HTTPS, or SSL.
	// The range of valid ports is one (1) through 65535.
	//
	// TCP is the default, specified as a TCP: port pair, for example "TCP:5000".
	// In this case, a health check simply attempts to open a TCP connection to
	// the instance on the specified port. Failure to connect within the configured
	// timeout is considered unhealthy.
	//
	// SSL is also specified as SSL: port pair, for example, SSL:5000.
	//
	// For HTTP/HTTPS, you must include a ping path in the string. HTTP is specified
	// as a HTTP:port;/;PathToPing; grouping, for example "HTTP:80/weather/us/wa/seattle".
	// In this case, a HTTP GET request is issued to the instance on the given port
	// and path. Any answer other than "200 OK" within the timeout period is considered
	// unhealthy.
	//
	// The total length of the HTTP ping target must be 1024 16-bit Unicode characters
	// or less.
	Target *string `type:"string" required:"true"`

	// The amount of time, in seconds, during which no response means a failed health
	// check.
	//
	// This value must be less than the Interval value.
	Timeout *int64 `type:"integer" required:"true"`

	// The number of consecutive health check failures required before moving the
	// instance to the Unhealthy state.
	UnhealthyThreshold *int64 `type:"integer" required:"true"`

	metadataHealthCheck `json:"-" xml:"-"`
}

type metadataHealthCheck struct {
	SDKShapeTraits bool `type:"structure"`
}

// The ID of a back-end instance.
type Instance struct {
	// The ID of the instance.
	InstanceID *string `locationName:"InstanceId" type:"string"`

	metadataInstance `json:"-" xml:"-"`
}

type metadataInstance struct {
	SDKShapeTraits bool `type:"structure"`
}

// Information about the state of a back-end instance.
type InstanceState struct {
	// A description of the instance state. This string can contain one or more
	// of the following messages.
	//
	//   N/A
	//
	//   A transient error occurred. Please try again later.
	//
	//   Instance has failed at least the UnhealthyThreshold number of health checks
	// consecutively.
	//
	//   Instance has not passed the configured HealthyThreshold number of health
	// checks consecutively.
	//
	//   Instance registration is still in progress.
	//
	//   Instance is in the EC2 Availability Zone for which LoadBalancer is not
	// configured to route traffic to.
	//
	//   Instance is not currently registered with the LoadBalancer.
	//
	//   Instance deregistration currently in progress.
	//
	//   Disable Availability Zone is currently in progress.
	//
	//   Instance is in pending state.
	//
	//   Instance is in stopped state.
	//
	//   Instance is in terminated state.
	Description *string `type:"string"`

	// The ID of the instance.
	InstanceID *string `locationName:"InstanceId" type:"string"`

	// Information about the cause of OutOfService instances. Specifically, whether
	// the cause is Elastic Load Balancing or the instance.
	//
	// Valid values: ELB | Instance | N/A
	ReasonCode *string `type:"string"`

	// The current state of the instance.
	//
	// Valid values: InService | OutOfService | Unknown
	State *string `type:"string"`

	metadataInstanceState `json:"-" xml:"-"`
}

type metadataInstanceState struct {
	SDKShapeTraits bool `type:"structure"`
}

// Information about a policy for duration-based session stickiness.
type LBCookieStickinessPolicy struct {
	// The time period, in seconds, after which the cookie should be considered
	// stale. If this parameter is not specified, the stickiness session lasts for
	// the duration of the browser session.
	CookieExpirationPeriod *int64 `type:"long"`

	// The name for the policy being created. The name must be unique within the
	// set of policies for this load balancer.
	PolicyName *string `type:"string"`

	metadataLBCookieStickinessPolicy `json:"-" xml:"-"`
}

type metadataLBCookieStickinessPolicy struct {
	SDKShapeTraits bool `type:"structure"`
}

// Information about a listener.
//
// For information about the protocols and the ports supported by Elastic Load
// Balancing, see Listener Configurations for Elastic Load Balancing (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-listener-config.html)
// in the Elastic Load Balancing Developer Guide.
type Listener struct {
	// The port on which the instance server is listening - 25, 80, 443, 465, 587,
	// or 1024-65535.
	InstancePort *int64 `type:"integer" required:"true"`

	// The protocol to use for routing traffic to back-end instances: HTTP, HTTPS,
	// TCP, or SSL.
	//
	// If the front-end protocol is HTTP, HTTPS, TCP, or SSL, InstanceProtocol
	// must be at the same protocol.
	//
	// If there is another listener with the same InstancePort whose InstanceProtocol
	// is secure, (HTTPS or SSL), the listener's InstanceProtocol must also be secure.
	//
	// If there is another listener with the same InstancePort whose InstanceProtocol
	// is HTTP or TCP, the listener's InstanceProtocol must be HTTP or TCP.
	InstanceProtocol *string `type:"string"`

	// The port on which the load balancer is listening: 25, 80, 443, 465, 587,
	// or 1024-65535.
	LoadBalancerPort *int64 `type:"integer" required:"true"`

	// The load balancer transport protocol to use for routing: HTTP, HTTPS, TCP,
	// or SSL.
	Protocol *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the server certificate.
	SSLCertificateID *string `locationName:"SSLCertificateId" type:"string"`

	metadataListener `json:"-" xml:"-"`
}

type metadataListener struct {
	SDKShapeTraits bool `type:"structure"`
}

// The policies enabled for a listener.
type ListenerDescription struct {
	// Information about a listener.
	//
	// For information about the protocols and the ports supported by Elastic Load
	// Balancing, see Listener Configurations for Elastic Load Balancing (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-listener-config.html)
	// in the Elastic Load Balancing Developer Guide.
	Listener *Listener `type:"structure"`

	// The policies. If there are no policies enabled, the list is empty.
	PolicyNames []*string `type:"list"`

	metadataListenerDescription `json:"-" xml:"-"`
}

type metadataListenerDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// The attributes for a load balancer.
type LoadBalancerAttributes struct {
	// If enabled, the load balancer captures detailed information of all requests
	// and delivers the information to the Amazon S3 bucket that you specify.
	//
	// For more information, see Enable Access Logs (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/enable-access-logs.html)
	// in the Elastic Load Balancing Developer Guide.
	AccessLog *AccessLog `type:"structure"`

	// This parameter is reserved.
	AdditionalAttributes []*AdditionalAttribute `type:"list"`

	// If enabled, the load balancer allows existing requests to complete before
	// the load balancer shifts traffic away from a deregistered or unhealthy back-end
	// instance.
	//
	// For more information, see Enable Connection Draining (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/config-conn-drain.html)
	// in the Elastic Load Balancing Developer Guide.
	ConnectionDraining *ConnectionDraining `type:"structure"`

	// If enabled, the load balancer allows the connections to remain idle (no data
	// is sent over the connection) for the specified duration.
	//
	// By default, Elastic Load Balancing maintains a 60-second idle connection
	// timeout for both front-end and back-end connections of your load balancer.
	// For more information, see Configure Idle Connection Timeout (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/config-idle-timeout.html)
	// in the Elastic Load Balancing Developer Guide.
	ConnectionSettings *ConnectionSettings `type:"structure"`

	// If enabled, the load balancer routes the request traffic evenly across all
	// back-end instances regardless of the Availability Zones.
	//
	// For more information, see Enable Cross-Zone Load Balancing (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/enable-disable-crosszone-lb.html)
	// in the Elastic Load Balancing Developer Guide.
	CrossZoneLoadBalancing *CrossZoneLoadBalancing `type:"structure"`

	metadataLoadBalancerAttributes `json:"-" xml:"-"`
}

type metadataLoadBalancerAttributes struct {
	SDKShapeTraits bool `type:"structure"`
}

// Information about a load balancer.
type LoadBalancerDescription struct {
	// The Availability Zones for the load balancer.
	AvailabilityZones []*string `type:"list"`

	// Information about the back-end servers.
	BackendServerDescriptions []*BackendServerDescription `type:"list"`

	// The Amazon Route 53 hosted zone associated with the load balancer.
	//
	// For more information, see Using Domain Names With Elastic Load Balancing
	// (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/using-domain-names-with-elb.html)
	// in the Elastic Load Balancing Developer Guide.
	CanonicalHostedZoneName *string `type:"string"`

	// The ID of the Amazon Route 53 hosted zone name associated with the load balancer.
	CanonicalHostedZoneNameID *string `type:"string"`

	// The date and time the load balancer was created.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The external DNS name of the load balancer.
	DNSName *string `type:"string"`

	// Information about the health checks conducted on the load balancer.
	HealthCheck *HealthCheck `type:"structure"`

	// The IDs of the instances for the load balancer.
	Instances []*Instance `type:"list"`

	// The listeners for the load balancer.
	ListenerDescriptions []*ListenerDescription `type:"list"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string"`

	// The policies defined for the load balancer.
	Policies *Policies `type:"structure"`

	// The type of load balancer. Valid only for load balancers in a VPC.
	//
	// If Scheme is internet-facing, the load balancer has a public DNS name that
	// resolves to a public IP address.
	//
	// If Scheme is internal, the load balancer has a public DNS name that resolves
	// to a private IP address.
	Scheme *string `type:"string"`

	// The security groups for the load balancer. Valid only for load balancers
	// in a VPC.
	SecurityGroups []*string `type:"list"`

	// The security group that you can use as part of your inbound rules for your
	// load balancer's back-end application instances. To only allow traffic from
	// load balancers, add a security group rule to your back end instance that
	// specifies this source security group as the inbound source.
	SourceSecurityGroup *SourceSecurityGroup `type:"structure"`

	// The IDs of the subnets for the load balancer.
	Subnets []*string `type:"list"`

	// The ID of the VPC for the load balancer.
	VPCID *string `locationName:"VPCId" type:"string"`

	metadataLoadBalancerDescription `json:"-" xml:"-"`
}

type metadataLoadBalancerDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

type ModifyLoadBalancerAttributesInput struct {
	// The attributes of the load balancer.
	LoadBalancerAttributes *LoadBalancerAttributes `type:"structure" required:"true"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	metadataModifyLoadBalancerAttributesInput `json:"-" xml:"-"`
}

type metadataModifyLoadBalancerAttributesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type ModifyLoadBalancerAttributesOutput struct {
	// The attributes for a load balancer.
	LoadBalancerAttributes *LoadBalancerAttributes `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string"`

	metadataModifyLoadBalancerAttributesOutput `json:"-" xml:"-"`
}

type metadataModifyLoadBalancerAttributesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// The policies for a load balancer.
type Policies struct {
	// The stickiness policies created using CreateAppCookieStickinessPolicy.
	AppCookieStickinessPolicies []*AppCookieStickinessPolicy `type:"list"`

	// The stickiness policies created using CreateLBCookieStickinessPolicy.
	LBCookieStickinessPolicies []*LBCookieStickinessPolicy `type:"list"`

	// The policies other than the stickiness policies.
	OtherPolicies []*string `type:"list"`

	metadataPolicies `json:"-" xml:"-"`
}

type metadataPolicies struct {
	SDKShapeTraits bool `type:"structure"`
}

// Information about a policy attribute.
type PolicyAttribute struct {
	// The name of the attribute.
	AttributeName *string `type:"string"`

	// The value of the attribute.
	AttributeValue *string `type:"string"`

	metadataPolicyAttribute `json:"-" xml:"-"`
}

type metadataPolicyAttribute struct {
	SDKShapeTraits bool `type:"structure"`
}

// Information about a policy attribute.
type PolicyAttributeDescription struct {
	// The name of the attribute.
	AttributeName *string `type:"string"`

	// The value of the attribute.
	AttributeValue *string `type:"string"`

	metadataPolicyAttributeDescription `json:"-" xml:"-"`
}

type metadataPolicyAttributeDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// Information about a policy attribute type.
type PolicyAttributeTypeDescription struct {
	// The name of the attribute.
	AttributeName *string `type:"string"`

	// The type of the attribute. For example, Boolean or Integer.
	AttributeType *string `type:"string"`

	// The cardinality of the attribute.
	//
	// Valid values:
	//
	//  ONE(1) : Single value required ZERO_OR_ONE(0..1) : Up to one value can
	// be supplied ZERO_OR_MORE(0..*) : Optional. Multiple values are allowed ONE_OR_MORE(1..*0)
	// : Required. Multiple values are allowed
	Cardinality *string `type:"string"`

	// The default value of the attribute, if applicable.
	DefaultValue *string `type:"string"`

	// A description of the attribute.
	Description *string `type:"string"`

	metadataPolicyAttributeTypeDescription `json:"-" xml:"-"`
}

type metadataPolicyAttributeTypeDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// Information about a policy.
type PolicyDescription struct {
	// The policy attributes.
	PolicyAttributeDescriptions []*PolicyAttributeDescription `type:"list"`

	// The name of the policy.
	PolicyName *string `type:"string"`

	// The name of the policy type.
	PolicyTypeName *string `type:"string"`

	metadataPolicyDescription `json:"-" xml:"-"`
}

type metadataPolicyDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// Information about a policy type.
type PolicyTypeDescription struct {
	// A description of the policy type.
	Description *string `type:"string"`

	// The description of the policy attributes associated with the policies defined
	// by Elastic Load Balancing.
	PolicyAttributeTypeDescriptions []*PolicyAttributeTypeDescription `type:"list"`

	// The name of the policy type.
	PolicyTypeName *string `type:"string"`

	metadataPolicyTypeDescription `json:"-" xml:"-"`
}

type metadataPolicyTypeDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

type RegisterInstancesWithLoadBalancerInput struct {
	// The IDs of the instances.
	Instances []*Instance `type:"list" required:"true"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	metadataRegisterInstancesWithLoadBalancerInput `json:"-" xml:"-"`
}

type metadataRegisterInstancesWithLoadBalancerInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type RegisterInstancesWithLoadBalancerOutput struct {
	// The updated list of instances for the load balancer.
	Instances []*Instance `type:"list"`

	metadataRegisterInstancesWithLoadBalancerOutput `json:"-" xml:"-"`
}

type metadataRegisterInstancesWithLoadBalancerOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type RemoveTagsInput struct {
	// The name of the load balancer. You can specify a maximum of one load balancer
	// name.
	LoadBalancerNames []*string `type:"list" required:"true"`

	// The list of tag keys to remove.
	Tags []*TagKeyOnly `type:"list" required:"true"`

	metadataRemoveTagsInput `json:"-" xml:"-"`
}

type metadataRemoveTagsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type RemoveTagsOutput struct {
	metadataRemoveTagsOutput `json:"-" xml:"-"`
}

type metadataRemoveTagsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type SetLoadBalancerListenerSSLCertificateInput struct {
	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The port that uses the specified SSL certificate.
	LoadBalancerPort *int64 `type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of the SSL certificate.
	SSLCertificateID *string `locationName:"SSLCertificateId" type:"string" required:"true"`

	metadataSetLoadBalancerListenerSSLCertificateInput `json:"-" xml:"-"`
}

type metadataSetLoadBalancerListenerSSLCertificateInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type SetLoadBalancerListenerSSLCertificateOutput struct {
	metadataSetLoadBalancerListenerSSLCertificateOutput `json:"-" xml:"-"`
}

type metadataSetLoadBalancerListenerSSLCertificateOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type SetLoadBalancerPoliciesForBackendServerInput struct {
	// The port number associated with the back-end server.
	InstancePort *int64 `type:"integer" required:"true"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The names of the policies. If the list is empty, then all current polices
	// are removed from the back-end server.
	PolicyNames []*string `type:"list" required:"true"`

	metadataSetLoadBalancerPoliciesForBackendServerInput `json:"-" xml:"-"`
}

type metadataSetLoadBalancerPoliciesForBackendServerInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type SetLoadBalancerPoliciesForBackendServerOutput struct {
	metadataSetLoadBalancerPoliciesForBackendServerOutput `json:"-" xml:"-"`
}

type metadataSetLoadBalancerPoliciesForBackendServerOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

type SetLoadBalancerPoliciesOfListenerInput struct {
	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The external port of the load balancer for the policy.
	LoadBalancerPort *int64 `type:"integer" required:"true"`

	// The names of the policies. If the list is empty, the current policy is removed
	// from the listener.
	PolicyNames []*string `type:"list" required:"true"`

	metadataSetLoadBalancerPoliciesOfListenerInput `json:"-" xml:"-"`
}

type metadataSetLoadBalancerPoliciesOfListenerInput struct {
	SDKShapeTraits bool `type:"structure"`
}

type SetLoadBalancerPoliciesOfListenerOutput struct {
	metadataSetLoadBalancerPoliciesOfListenerOutput `json:"-" xml:"-"`
}

type metadataSetLoadBalancerPoliciesOfListenerOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// Information about a source security group.
type SourceSecurityGroup struct {
	// The name of the security group.
	GroupName *string `type:"string"`

	// The owner of the security group.
	OwnerAlias *string `type:"string"`

	metadataSourceSecurityGroup `json:"-" xml:"-"`
}

type metadataSourceSecurityGroup struct {
	SDKShapeTraits bool `type:"structure"`
}

// Information about a tag.
type Tag struct {
	// The key of the tag.
	Key *string `type:"string" required:"true"`

	// The value of the tag.
	Value *string `type:"string"`

	metadataTag `json:"-" xml:"-"`
}

type metadataTag struct {
	SDKShapeTraits bool `type:"structure"`
}

// The tags associated with a load balancer.
type TagDescription struct {
	// The name of the load balancer.
	LoadBalancerName *string `type:"string"`

	// The tags.
	Tags []*Tag `type:"list"`

	metadataTagDescription `json:"-" xml:"-"`
}

type metadataTagDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// The key of a tag.
type TagKeyOnly struct {
	// The name of the key.
	Key *string `type:"string"`

	metadataTagKeyOnly `json:"-" xml:"-"`
}

type metadataTagKeyOnly struct {
	SDKShapeTraits bool `type:"structure"`
}
